# The PIMMUR Principles: Ensuring Validity in Collective Behavior of LLM Societies
## Executing the LLM test for Unawarenes and Min-control
Go to the `Unaware&ControlTest` folder.

To interactively test new prompts, run:
```bash
export OPENAI_API_KEY="YOUR_API_KEY"
python run.py --mode interactive --model gpt-4o-2024-11-20 --api openai
```

To execute our complete *Unawareness* and *Min-control* test, switch the `--mode` to `unawareness` or `steering` respectively.

## Executing the Multi-Agent System
Go to the `MAS` folder.

First, set your configuration in the `configs` folder. To run specifc simulation. run
```bash
python run.py --config <path_to_the corresponding_config_file>
```

To process the results， go to the result file and excute the `vis.py` file under the folder will produce a visualization for the result

## Customization
To run your own simulation using our framework. You need to implement your own config generator and simluation class like the ones under `config_generators.py` and `simulation.py`. The config you generated will be passed on directly to the Simulation. If you need to run a dataset, you can define your own execution function in `run.py`. In `configs\ConfigTemplate.json` provides the minimal configs you need to include in your config file.