#SelfRegulationSCP2.
#
#from 
#http://bbci.de/competition/ii/tuebingen_desc_i.html
#
#Data set 1b: Self-regulation of Slow Cortical Potentials
#
#Datasets provided by University of Tuebingen. 
#Correspondence to Thilo Hinterberger <thilo.Hinterberger@uni-tuebingen.de> 
# 
#Description of Experiments:
#The datasets were taken from an artificially respirated ALS patient. The subject was asked to move a cursor up and down on a computer screen, while his cortical potentials were taken. During the recording, the subject received auditory and visual feedback of his slow cortical potentials (Cz-Mastoids).  Cortical positivity lead to a downward movement of the cursor on the screen.  Cortical negativity lead to an upward movement of the cursor.  Each trial lasted 8s. 
#During every trial, the task was visually and auditorily presented by a highlighed goal at the top (for negativity) or bottom (for positivity) of the screen from second 0.5 until second 7.5 of every trial.  In addition, the task ("up" or "down") was vocalised at second 0.5. 
#The visual feedback was presented from second 2 to second 6.5. Only this 4.5 second interval of every trial is provided for training and testing. The sampling rate of 256 Hz and the recording length of 4.5s results in 1152 samples per channel for every trial.
#Trial structure overview: 
#Duration: 8 s, no inter trial intervals 
#task presentation: from 0.5 s to 7.5 s 
#feedback period: from 2.0 s to 6.5 s 
#  
# 
#
#Data:
#Amplifier: PsyLab EEG8 
#A/D-converter: Computer Boards PCIM-DAS1602/16 bit 
#Amplitude range: +/-1000 �V 
#Sampling rate: 256 S/s 
#EEG data was taken from the following positions: 
#Channel 1: A1-Cz (10/20 system) (A1 = left mastoid) 
#Channel 2: A2-Cz 
#Channel 3: 2 cm frontal of C3 
#Channel 4: 2 cm parietal of C3 
#Channel 5: vEOG artifact channel to detect vertical eye movements 
#Channel 6: 2 cm frontal of C4 
#Channel 7: 2 cm parietal of C4 
#All values are in �Volt. 
#The EEG-values are not EOG-corrected.
#Traindata_0.txt and Traindata_1.txt:
#
#The train data contains  200 trials, 100 of each class which were recorded on the same day and permuted randomly.
#There are 7 dimensions and the series are length 1152. 
#
#Test data contains 180 trials of test data.  This test data was recorded after the train data (during the same day) day.  The 180 trials belong to either class 0 or class 1.  
#
#Note that it is not clear if there is any information contained in this data set that is useful for the classification task. A view on the result suggests that it is not. 
#
#http://bbci.de/competition/ii/results/index.html
#The best has error 45.5%.  
#
#Reference:
#Birbaumer, N., Flor, H., Ghanayim, N., Hinterberger, T., Iverson, I., Taub, E., Kotchoubey, B., K�bler, A., & Perelmouter, J, A Brain-Controlled Spelling Device for the Completely Paralyzed, Nature, 398, 297-298.
@problemName SelfRegulationSCP2
@timeStamps false
@missing false
@univariate false
@dimensions 7
@equalLength true
@seriesLength 1152
@classLabel true negativity positivity
@data
15.22,13.12,12.5,13.22,12.38,10.25,9.34,11.19,13.06,12.28,11.69,13.28,15.31,14.97,14.41,15.97,19.0,19.5,18.06,17.88,18.94,18.59,16.19,14.47,15.31,15.81,14.09,12.84,13.47,14.47,13.03,10.53,10.06,11.25,10.62,8.47,8.09,9.62,10.62,9.66,9.91,12.25,14.03,13.03,10.97,11.12,11.97,11.28,10.19,11.38,14.59,16.0,15.31,15.66,17.38,17.44,14.75,12.38,12.47,13.28,12.03,10.62,11.75,14.19,14.25,13.59,14.78,17.44,18.12,17.12,17.25,19.66,21.91,21.41,20.41,21.31,22.16,19.78,16.41,15.38,16.03,15.0,12.97,12.59,13.81,13.66,11.16,9.19,10.06,10.47,8.56,7.22,8.53,10.47,10.41,9.31,10.44,12.31,12.62,11.81,12.5,15.38,17.16,16.75,16.47,18.59,19.94,18.38,16.34,16.88,18.34,17.66,16.47,17.12,19.03,18.72,16.78,16.47,18.72,20.56,20.09,20.25,22.28,23.53,21.88,19.84,19.91,21.34,20.91,19.88,20.97,23.69,24.62,24.03,24.47,26.84,28.72,27.91,27.03,28.22,28.81,26.41,23.34,22.31,22.72,22.28,21.44,22.59,26.0,27.91,27.38,26.62,27.88,28.38,26.44,24.78,25.56,27.06,25.91,23.69,23.5,24.5,23.47,21.06,20.0,21.12,21.41,20.53,21.25,24.78,27.81,28.09,27.41,27.72,28.03,26.0,23.06,22.41,23.53,23.06,20.91,19.81,20.41,20.16,17.62,16.19,18.22,21.09,21.75,21.66,23.47,25.28,23.94,21.41,20.84,22.0,21.66,20.19,19.59,21.12,21.56,19.53,17.53,18.31,19.41,18.75,17.53,18.25,19.47,18.5,15.84,14.53,15.59,15.62,14.41,14.38,17.06,19.0,18.38,17.66,18.88,20.69,20.31,18.34,18.28,19.09,18.12,15.38,14.41,16.03,16.94,16.22,16.78,19.94,22.28,21.78,20.56,21.28,21.88,20.5,17.72,17.41,17.91,17.31,15.19,14.38,16.0,16.25,14.25,13.16,14.62,16.03,15.75,15.03,16.5,18.78,19.16,18.19,19.19,21.59,22.31,20.66,20.0,21.0,21.53,19.75,18.69,20.16,21.75,20.69,18.41,17.91,17.78,15.84,13.09,12.41,13.75,14.31,12.62,12.22,14.12,15.62,15.53,15.25,17.62,20.0,19.53,17.41,16.62,16.69,15.47,13.34,13.44,15.59,17.16,16.59,16.47,18.59,20.56,19.47,17.91,17.88,17.78,15.41,12.22,11.88,13.62,15.03,15.78,18.53,23.41,26.88,26.72,25.59,25.5,24.66,21.31,17.88,17.25,18.12,18.03,16.69,16.88,18.31,18.44,16.81,16.53,18.62,20.81,20.62,20.75,23.34,26.19,26.5,25.81,27.34,29.12,29.19,27.88,28.25,29.94,30.09,27.88,25.91,25.59,24.44,20.97,17.66,16.88,16.66,15.09,13.34,14.12,16.28,17.22,17.16,18.38,21.47,23.22,22.22,21.78,23.22,24.0,22.59,21.28,22.19,23.28,22.47,20.84,20.75,21.62,20.91,18.5,17.44,18.56,19.47,18.75,19.16,21.94,25.06,25.47,25.38,26.81,28.69,28.28,26.38,26.19,27.03,26.53,23.88,22.28,22.56,22.44,19.81,17.44,17.81,18.56,17.66,16.47,17.44,19.34,19.47,18.25,18.75,20.91,21.75,20.53,19.78,20.88,21.5,19.75,17.88,17.97,18.69,17.12,14.72,14.69,15.34,13.88,11.38,10.66,12.09,13.5,13.28,14.25,17.09,19.31,18.78,17.56,18.38,19.62,18.47,16.38,16.41,18.06,18.94,18.44,18.97,20.97,21.75,20.41,19.53,21.34,24.0,24.53,24.56,25.78,27.66,26.69,24.12,23.06,23.81,23.56,21.84,21.19,22.69,23.53,21.38,19.84,20.53,21.47,20.72,19.91,21.06,23.84,24.69,24.31,25.03,26.69,27.12,25.5,24.81,26.41,28.31,27.72,26.91,27.75,28.53,26.72,24.09,23.38,23.94,23.22,21.12,21.06,22.75,23.53,22.38,21.56,23.0,24.53,23.56,22.34,23.31,24.62,23.84,22.12,22.28,24.03,24.28,23.88,24.38,27.03,29.0,28.0,27.41,28.62,29.53,27.72,24.88,23.31,22.0,18.56,14.5,12.53,13.38,13.41,12.03,12.12,14.31,16.25,16.09,17.0,20.28,23.97,24.75,24.75,25.84,27.09,26.09,23.41,22.25,22.78,22.94,21.94,22.25,24.81,27.19,26.59,25.66,26.41,27.34,25.78,23.38,23.03,23.84,23.03,21.16,20.81,22.5,23.81,24.03,25.28,29.25,33.25,34.44,34.69,36.16,37.25,36.03,33.44,32.66,33.88,34.03,33.09,33.31,35.34,36.25,34.66,32.91,33.62,34.41,32.94,31.22,31.56,32.38,31.44,28.44,26.53,26.22,25.16,22.19,20.91,22.09,23.38,22.88,22.38,24.31,26.69,26.31,24.75,25.31,26.44,25.41,22.78,21.41,22.22,22.25,20.94,20.72,23.34,25.0,24.78,24.88,27.34,30.28,30.97,30.72,31.56,33.09,32.38,30.31,29.12,30.25,30.44,28.78,27.34,27.88,27.44,24.56,21.59,21.56,22.84,23.09,23.22,25.06,27.53,28.0,26.12,24.62,25.41,25.78,24.72,23.84,25.56,26.97,25.66,23.09,22.66,22.69,21.28,19.25,19.16,21.03,21.56,20.53,19.84,21.16,21.94,20.88,20.0,21.81,23.25,21.81,19.28,18.06,17.75,15.81,13.28,12.91,14.78,15.97,15.19,14.47,15.62,16.56,15.03,13.59,14.91,16.34,15.31,13.16,12.66,13.84,14.16,13.91,15.47,19.53,22.25,22.06,21.62,22.41,22.38,19.88,16.72,15.88,15.56,13.44,10.19,9.28,10.09,9.81,8.31,7.72,9.41,9.97,8.41,7.75,9.81,12.5,13.5,13.88,15.97,18.0,17.38,14.62,13.25,13.22,12.69,10.72,9.94,12.0,14.16,14.16,14.28,16.94,20.03,20.94,20.38,21.22,22.31,20.41,16.38,14.03,14.25,14.59,14.53,16.0,19.91,22.38,21.59,18.78,18.03,17.84,16.09,14.34,15.31,17.78,18.97,18.19,19.31,22.53,25.19,26.12,27.16,30.94,34.47,34.84,34.34,35.31,36.0,34.03,30.25,28.47,28.03,26.66,24.03,22.66,23.22,23.16,20.97,18.84,19.59,20.75,20.0,19.0,20.62,23.5,24.72,24.78,26.59,29.44,30.56,28.97,27.53,27.25,25.88,21.41,17.12,15.56,15.12,13.5,11.66,12.41,14.59,15.25,14.78,15.84,18.78,21.19,21.38,22.47,25.84,29.0,29.59,29.84,32.06,34.72,34.88,33.62,34.0,35.41,34.62,31.97,30.09,29.41,28.09,24.12,21.12,21.12,22.12,21.25,20.62,22.06,23.91,23.88,22.53,23.34,26.34,28.22,28.47,29.91,33.25,35.59,35.34,34.94,35.94,37.06,35.47,33.12,32.84,33.44,32.25,29.69,28.72,29.22,28.41,25.53,23.69,24.12,24.0,21.0,18.25,17.91,18.47,17.72,17.34,19.56,23.34,25.66,25.12,25.22,26.09,24.66,20.47,17.25,16.62,16.56,14.84,13.44,14.69,16.38,15.91,14.59,15.22,17.38,18.59,18.12,19.56,22.78,25.44,25.5,25.62,27.66,28.84,27.03,24.69,24.41,24.75,23.28,20.62,20.28,21.22,20.62,18.06,16.66,17.5,18.09,16.97,17.16,20.28,23.53,24.28,24.06,25.44,27.06,26.34,24.31,24.06,25.53,26.06,24.09,22.81,23.38,23.44,21.09,19.22,20.75,23.5,24.22,24.19,25.75,28.12,27.5,24.34,22.19,21.5,19.59,15.41,12.62,12.75,13.56,12.28,11.5,13.47,16.22,16.88,17.0,19.44,23.44,25.81,26.12,27.62,30.44,32.31,31.53,31.31,33.66,35.38,34.22,32.28,31.5,30.88,27.59,23.06,20.5,19.97,18.56,15.91,15.56,18.12,21.25,22.38,24.62,29.31,34.62,36.88,38.22,40.44,41.56,38.75,32.78,27.09,23.09,18.38,12.91,10.12,11.78,14.62,16.03,18.22,22.66,27.28,28.91,29.06,31.19,34.12,34.78,33.91,34.16,35.5,34.78,31.0,27.06,24.78,22.59,18.38,15.38,16.28,19.34,20.44,20.97,22.91,24.91,23.69,20.0,17.0,16.16,14.72,11.69,9.62,10.12,10.81,8.81,6.91,7.41,9.12,8.25,6.75,7.25,9.19,10.0,9.59,10.62,14.06,16.97,17.78,18.91,22.25,25.91,26.19,25.0,24.75,24.09,20.12,14.34,10.38,9.09,7.88,6.38,7.41,12.5,17.69,20.5,22.66,26.28,28.88,27.66,25.62,25.5,27.09,27.22,26.56,27.0,29.19,29.5,27.56,26.47,27.94,29.66,29.38,29.03,30.88,33.44,33.41,33.19,34.78,38.34,39.38,38.19,37.34,37.62,36.31,32.22,28.62,27.44,26.62,23.72,21.53,22.19,24.31,24.09,22.81,22.88,24.31,24.0,21.69,20.78,21.97,22.69,21.44,20.56,22.69,24.72,24.69,24.25,25.31,27.09,25.94,22.97,21.53,21.97,21.12,18.84,17.66,18.78,18.91,16.31,14.12,14.12,14.69,13.09,11.06,11.34,13.62,14.78,15.09,17.34,21.22,23.56,23.12,21.88,22.56,21.91,18.06,13.5,11.56,10.34,7.31,4.16,4.03,6.09,7.47,7.84,9.66,13.53,16.22,16.41,16.59,19.72,22.75,23.16,22.88,24.22,25.41,24.25,21.62,21.06,22.47,22.53,20.41,18.53,18.09,15.88,10.84,6.19,5.16,5.31,3.91,2.66,3.91,5.56:11.19,13.06,12.28,11.69,13.28,15.31,14.97,14.41,15.97,19.0,19.5,18.06,17.88,18.94,18.59,16.19,14.47,15.31,15.81,14.09,12.84,13.47,14.47,13.03,10.53,10.06,11.25,10.62,8.47,8.09,9.62,10.62,9.66,9.91,12.25,14.03,13.03,10.97,11.12,11.97,11.28,10.19,11.38,14.59,16.0,15.31,15.66,17.38,17.44,14.75,12.38,12.47,13.28,12.03,10.62,11.75,14.19,14.25,13.59,14.78,17.44,18.12,17.12,17.25,19.66,21.91,21.41,20.41,21.31,22.16,19.78,16.41,15.38,16.03,15.0,12.97,12.59,13.81,13.66,11.16,9.19,10.06,10.47,8.56,7.22,8.53,10.47,10.41,9.31,10.44,12.31,12.62,11.81,12.5,15.38,17.16,16.75,16.47,18.59,19.94,18.38,16.34,16.88,18.34,17.66,16.47,17.12,19.03,18.72,16.78,16.47,18.72,20.56,20.09,20.25,22.28,23.53,21.88,19.84,19.91,21.34,20.91,19.88,20.97,23.69,24.62,24.03,24.47,26.84,28.72,27.91,27.03,28.22,28.81,26.41,23.34,22.31,22.72,22.28,21.44,22.59,26.0,27.91,27.38,26.62,27.88,28.38,26.44,24.78,25.56,27.06,25.91,23.69,23.5,24.5,23.47,21.06,20.0,21.12,21.41,20.53,21.25,24.78,27.81,28.09,27.41,27.72,28.03,26.0,23.06,22.41,23.53,23.06,20.91,19.81,20.41,20.16,17.62,16.19,18.22,21.09,21.75,21.66,23.47,25.28,23.94,21.41,20.84,22.0,21.66,20.19,19.59,21.12,21.56,19.53,17.53,18.31,19.41,18.75,17.53,18.25,19.47,18.5,15.84,14.53,15.59,15.62,14.41,14.38,17.06,19.0,18.38,17.66,18.88,20.69,20.31,18.34,18.28,19.09,18.12,15.38,14.41,16.03,16.94,16.22,16.78,19.94,22.28,21.78,20.56,21.28,21.88,20.5,17.72,17.41,17.91,17.31,15.19,14.38,16.0,16.25,14.25,13.16,14.62,16.03,15.75,15.03,16.5,18.78,19.16,18.19,19.19,21.59,22.31,20.66,20.0,21.0,21.53,19.75,18.69,20.16,21.75,20.69,18.41,17.91,17.78,15.84,13.09,12.41,13.75,14.31,12.62,12.22,14.12,15.62,15.53,15.25,17.62,20.0,19.53,17.41,16.62,16.69,15.47,13.34,13.44,15.59,17.16,16.59,16.47,18.59,20.56,19.47,17.91,17.88,17.78,15.41,12.22,11.88,13.62,15.03,15.78,18.53,23.41,26.88,26.72,25.59,25.5,24.66,21.31,17.88,17.25,18.12,18.03,16.69,16.88,18.31,18.44,16.81,16.53,18.62,20.81,20.62,20.75,23.34,26.19,26.5,25.81,27.34,29.12,29.19,27.88,28.25,29.94,30.09,27.88,25.91,25.59,24.44,20.97,17.66,16.88,16.66,15.09,13.34,14.12,16.28,17.22,17.16,18.38,21.47,23.22,22.22,21.78,23.22,24.0,22.59,21.28,22.19,23.28,22.47,20.84,20.75,21.62,20.91,18.5,17.44,18.56,19.47,18.75,19.16,21.94,25.06,25.47,25.38,26.81,28.69,28.28,26.38,26.19,27.03,26.53,23.88,22.28,22.56,22.44,19.81,17.44,17.81,18.56,17.66,16.47,17.44,19.34,19.47,18.25,18.75,20.91,21.75,20.53,19.78,20.88,21.5,19.75,17.88,17.97,18.69,17.12,14.72,14.69,15.34,13.88,11.38,10.66,12.09,13.5,13.28,14.25,17.09,19.31,18.78,17.56,18.38,19.62,18.47,16.38,16.41,18.06,18.94,18.44,18.97,20.97,21.75,20.41,19.53,21.34,24.0,24.53,24.56,25.78,27.66,26.69,24.12,23.06,23.81,23.56,21.84,21.19,22.69,23.53,21.38,19.84,20.53,21.47,20.72,19.91,21.06,23.84,24.69,24.31,25.03,26.69,27.12,25.5,24.81,26.41,28.31,27.72,26.91,27.75,28.53,26.72,24.09,23.38,23.94,23.22,21.12,21.06,22.75,23.53,22.38,21.56,23.0,24.53,23.56,22.34,23.31,24.62,23.84,22.12,22.28,24.03,24.28,23.88,24.38,27.03,29.0,28.0,27.41,28.62,29.53,27.72,24.88,23.31,22.0,18.56,14.5,12.53,13.38,13.41,12.03,12.12,14.31,16.25,16.09,17.0,20.28,23.97,24.75,24.75,25.84,27.09,26.09,23.41,22.25,22.78,22.94,21.94,22.25,24.81,27.19,26.59,25.66,26.41,27.34,25.78,23.38,23.03,23.84,23.03,21.16,20.81,22.5,23.81,24.03,25.28,29.25,33.25,34.44,34.69,36.16,37.25,36.03,33.44,32.66,33.88,34.03,33.09,33.31,35.34,36.25,34.66,32.91,33.62,34.41,32.94,31.22,31.56,32.38,31.44,28.44,26.53,26.22,25.16,22.19,20.91,22.09,23.38,22.88,22.38,24.31,26.69,26.31,24.75,25.31,26.44,25.41,22.78,21.41,22.22,22.25,20.94,20.72,23.34,25.0,24.78,24.88,27.34,30.28,30.97,30.72,31.56,33.09,32.38,30.31,29.12,30.25,30.44,28.78,27.34,27.88,27.44,24.56,21.59,21.56,22.84,23.09,23.22,25.06,27.53,28.0,26.12,24.62,25.41,25.78,24.72,23.84,25.56,26.97,25.66,23.09,22.66,22.69,21.28,19.25,19.16,21.03,21.56,20.53,19.84,21.16,21.94,20.88,20.0,21.81,23.25,21.81,19.28,18.06,17.75,15.81,13.28,12.91,14.78,15.97,15.19,14.47,15.62,16.56,15.03,13.59,14.91,16.34,15.31,13.16,12.66,13.84,14.16,13.91,15.47,19.53,22.25,22.06,21.62,22.41,22.38,19.88,16.72,15.88,15.56,13.44,10.19,9.28,10.09,9.81,8.31,7.72,9.41,9.97,8.41,7.75,9.81,12.5,13.5,13.88,15.97,18.0,17.38,14.62,13.25,13.22,12.69,10.72,9.94,12.0,14.16,14.16,14.28,16.94,20.03,20.94,20.38,21.22,22.31,20.41,16.38,14.03,14.25,14.59,14.53,16.0,19.91,22.38,21.59,18.78,18.03,17.84,16.09,14.34,15.31,17.78,18.97,18.19,19.31,22.53,25.19,26.12,27.16,30.94,34.47,34.84,34.34,35.31,36.0,34.03,30.25,28.47,28.03,26.66,24.03,22.66,23.22,23.16,20.97,18.84,19.59,20.75,20.0,19.0,20.62,23.5,24.72,24.78,26.59,29.44,30.56,28.97,27.53,27.25,25.88,21.41,17.12,15.56,15.12,13.5,11.66,12.41,14.59,15.25,14.78,15.84,18.78,21.19,21.38,22.47,25.84,29.0,29.59,29.84,32.06,34.72,34.88,33.62,34.0,35.41,34.62,31.97,30.09,29.41,28.09,24.12,21.12,21.12,22.12,21.25,20.62,22.06,23.91,23.88,22.53,23.34,26.34,28.22,28.47,29.91,33.25,35.59,35.34,34.94,35.94,37.06,35.47,33.12,32.84,33.44,32.25,29.69,28.72,29.22,28.41,25.53,23.69,24.12,24.0,21.0,18.25,17.91,18.47,17.72,17.34,19.56,23.34,25.66,25.12,25.22,26.09,24.66,20.47,17.25,16.62,16.56,14.84,13.44,14.69,16.38,15.91,14.59,15.22,17.38,18.59,18.12,19.56,22.78,25.44,25.5,25.62,27.66,28.84,27.03,24.69,24.41,24.75,23.28,20.62,20.28,21.22,20.62,18.06,16.66,17.5,18.09,16.97,17.16,20.28,23.53,24.28,24.06,25.44,27.06,26.34,24.31,24.06,25.53,26.06,24.09,22.81,23.38,23.44,21.09,19.22,20.75,23.5,24.22,24.19,25.75,28.12,27.5,24.34,22.19,21.5,19.59,15.41,12.62,12.75,13.56,12.28,11.5,13.47,16.22,16.88,17.0,19.44,23.44,25.81,26.12,27.62,30.44,32.31,31.53,31.31,33.66,35.38,34.22,32.28,31.5,30.88,27.59,23.06,20.5,19.97,18.56,15.91,15.56,18.12,21.25,22.38,24.62,29.31,34.62,36.88,38.22,40.44,41.56,38.75,32.78,27.09,23.09,18.38,12.91,10.12,11.78,14.62,16.03,18.22,22.66,27.28,28.91,29.06,31.19,34.12,34.78,33.91,34.16,35.5,34.78,31.0,27.06,24.78,22.59,18.38,15.38,16.28,19.34,20.44,20.97,22.91,24.91,23.69,20.0,17.0,16.16,14.72,11.69,9.62,10.12,10.81,8.81,6.91,7.41,9.12,8.25,6.75,7.25,9.19,10.0,9.59,10.62,14.06,16.97,17.78,18.91,22.25,25.91,26.19,25.0,24.75,24.09,20.12,14.34,10.38,9.09,7.88,6.38,7.41,12.5,17.69,20.5,22.66,26.28,28.88,27.66,25.62,25.5,27.09,27.22,26.56,27.0,29.19,29.5,27.56,26.47,27.94,29.66,29.38,29.03,30.88,33.44,33.41,33.19,34.78,38.34,39.38,38.19,37.34,37.62,36.31,32.22,28.62,27.44,26.62,23.72,21.53,22.19,24.31,24.09,22.81,22.88,24.31,24.0,21.69,20.78,21.97,22.69,21.44,20.56,22.69,24.72,24.69,24.25,25.31,27.09,25.94,22.97,21.53,21.97,21.12,18.84,17.66,18.78,18.91,16.31,14.12,14.12,14.69,13.09,11.06,11.34,13.62,14.78,15.09,17.34,21.22,23.56,23.12,21.88,22.56,21.91,18.06,13.5,11.56,10.34,7.31,4.16,4.03,6.09,7.47,7.84,9.66,13.53,16.22,16.41,16.59,19.72,22.75,23.16,22.88,24.22,25.41,24.25,21.62,21.06,22.47,22.53,20.41,18.53,18.09,15.88,10.84,6.19,5.16,5.31,3.91,2.66,3.91,5.56,24.94,23.81,23.72,24.19,23.62,22.03,21.41:14.41,15.97,19.0,19.5,18.06,17.88,18.94,18.59,16.19,14.47,15.31,15.81,14.09,12.84,13.47,14.47,13.03,10.53,10.06,11.25,10.62,8.47,8.09,9.62,10.62,9.66,9.91,12.25,14.03,13.03,10.97,11.12,11.97,11.28,10.19,11.38,14.59,16.0,15.31,15.66,17.38,17.44,14.75,12.38,12.47,13.28,12.03,10.62,11.75,14.19,14.25,13.59,14.78,17.44,18.12,17.12,17.25,19.66,21.91,21.41,20.41,21.31,22.16,19.78,16.41,15.38,16.03,15.0,12.97,12.59,13.81,13.66,11.16,9.19,10.06,10.47,8.56,7.22,8.53,10.47,10.41,9.31,10.44,12.31,12.62,11.81,12.5,15.38,17.16,16.75,16.47,18.59,19.94,18.38,16.34,16.88,18.34,17.66,16.47,17.12,19.03,18.72,16.78,16.47,18.72,20.56,20.09,20.25,22.28,23.53,21.88,19.84,19.91,21.34,20.91,19.88,20.97,23.69,24.62,24.03,24.47,26.84,28.72,27.91,27.03,28.22,28.81,26.41,23.34,22.31,22.72,22.28,21.44,22.59,26.0,27.91,27.38,26.62,27.88,28.38,26.44,24.78,25.56,27.06,25.91,23.69,23.5,24.5,23.47,21.06,20.0,21.12,21.41,20.53,21.25,24.78,27.81,28.09,27.41,27.72,28.03,26.0,23.06,22.41,23.53,23.06,20.91,19.81,20.41,20.16,17.62,16.19,18.22,21.09,21.75,21.66,23.47,25.28,23.94,21.41,20.84,22.0,21.66,20.19,19.59,21.12,21.56,19.53,17.53,18.31,19.41,18.75,17.53,18.25,19.47,18.5,15.84,14.53,15.59,15.62,14.41,14.38,17.06,19.0,18.38,17.66,18.88,20.69,20.31,18.34,18.28,19.09,18.12,15.38,14.41,16.03,16.94,16.22,16.78,19.94,22.28,21.78,20.56,21.28,21.88,20.5,17.72,17.41,17.91,17.31,15.19,14.38,16.0,16.25,14.25,13.16,14.62,16.03,15.75,15.03,16.5,18.78,19.16,18.19,19.19,21.59,22.31,20.66,20.0,21.0,21.53,19.75,18.69,20.16,21.75,20.69,18.41,17.91,17.78,15.84,13.09,12.41,13.75,14.31,12.62,12.22,14.12,15.62,15.53,15.25,17.62,20.0,19.53,17.41,16.62,16.69,15.47,13.34,13.44,15.59,17.16,16.59,16.47,18.59,20.56,19.47,17.91,17.88,17.78,15.41,12.22,11.88,13.62,15.03,15.78,18.53,23.41,26.88,26.72,25.59,25.5,24.66,21.31,17.88,17.25,18.12,18.03,16.69,16.88,18.31,18.44,16.81,16.53,18.62,20.81,20.62,20.75,23.34,26.19,26.5,25.81,27.34,29.12,29.19,27.88,28.25,29.94,30.09,27.88,25.91,25.59,24.44,20.97,17.66,16.88,16.66,15.09,13.34,14.12,16.28,17.22,17.16,18.38,21.47,23.22,22.22,21.78,23.22,24.0,22.59,21.28,22.19,23.28,22.47,20.84,20.75,21.62,20.91,18.5,17.44,18.56,19.47,18.75,19.16,21.94,25.06,25.47,25.38,26.81,28.69,28.28,26.38,26.19,27.03,26.53,23.88,22.28,22.56,22.44,19.81,17.44,17.81,18.56,17.66,16.47,17.44,19.34,19.47,18.25,18.75,20.91,21.75,20.53,19.78,20.88,21.5,19.75,17.88,17.97,18.69,17.12,14.72,14.69,15.34,13.88,11.38,10.66,12.09,13.5,13.28,14.25,17.09,19.31,18.78,17.56,18.38,19.62,18.47,16.38,16.41,18.06,18.94,18.44,18.97,20.97,21.75,20.41,19.53,21.34,24.0,24.53,24.56,25.78,27.66,26.69,24.12,23.06,23.81,23.56,21.84,21.19,22.69,23.53,21.38,19.84,20.53,21.47,20.72,19.91,21.06,23.84,24.69,24.31,25.03,26.69,27.12,25.5,24.81,26.41,28.31,27.72,26.91,27.75,28.53,26.72,24.09,23.38,23.94,23.22,21.12,21.06,22.75,23.53,22.38,21.56,23.0,24.53,23.56,22.34,23.31,24.62,23.84,22.12,22.28,24.03,24.28,23.88,24.38,27.03,29.0,28.0,27.41,28.62,29.53,27.72,24.88,23.31,22.0,18.56,14.5,12.53,13.38,13.41,12.03,12.12,14.31,16.25,16.09,17.0,20.28,23.97,24.75,24.75,25.84,27.09,26.09,23.41,22.25,22.78,22.94,21.94,22.25,24.81,27.19,26.59,25.66,26.41,27.34,25.78,23.38,23.03,23.84,23.03,21.16,20.81,22.5,23.81,24.03,25.28,29.25,33.25,34.44,34.69,36.16,37.25,36.03,33.44,32.66,33.88,34.03,33.09,33.31,35.34,36.25,34.66,32.91,33.62,34.41,32.94,31.22,31.56,32.38,31.44,28.44,26.53,26.22,25.16,22.19,20.91,22.09,23.38,22.88,22.38,24.31,26.69,26.31,24.75,25.31,26.44,25.41,22.78,21.41,22.22,22.25,20.94,20.72,23.34,25.0,24.78,24.88,27.34,30.28,30.97,30.72,31.56,33.09,32.38,30.31,29.12,30.25,30.44,28.78,27.34,27.88,27.44,24.56,21.59,21.56,22.84,23.09,23.22,25.06,27.53,28.0,26.12,24.62,25.41,25.78,24.72,23.84,25.56,26.97,25.66,23.09,22.66,22.69,21.28,19.25,19.16,21.03,21.56,20.53,19.84,21.16,21.94,20.88,20.0,21.81,23.25,21.81,19.28,18.06,17.75,15.81,13.28,12.91,14.78,15.97,15.19,14.47,15.62,16.56,15.03,13.59,14.91,16.34,15.31,13.16,12.66,13.84,14.16,13.91,15.47,19.53,22.25,22.06,21.62,22.41,22.38,19.88,16.72,15.88,15.56,13.44,10.19,9.28,10.09,9.81,8.31,7.72,9.41,9.97,8.41,7.75,9.81,12.5,13.5,13.88,15.97,18.0,17.38,14.62,13.25,13.22,12.69,10.72,9.94,12.0,14.16,14.16,14.28,16.94,20.03,20.94,20.38,21.22,22.31,20.41,16.38,14.03,14.25,14.59,14.53,16.0,19.91,22.38,21.59,18.78,18.03,17.84,16.09,14.34,15.31,17.78,18.97,18.19,19.31,22.53,25.19,26.12,27.16,30.94,34.47,34.84,34.34,35.31,36.0,34.03,30.25,28.47,28.03,26.66,24.03,22.66,23.22,23.16,20.97,18.84,19.59,20.75,20.0,19.0,20.62,23.5,24.72,24.78,26.59,29.44,30.56,28.97,27.53,27.25,25.88,21.41,17.12,15.56,15.12,13.5,11.66,12.41,14.59,15.25,14.78,15.84,18.78,21.19,21.38,22.47,25.84,29.0,29.59,29.84,32.06,34.72,34.88,33.62,34.0,35.41,34.62,31.97,30.09,29.41,28.09,24.12,21.12,21.12,22.12,21.25,20.62,22.06,23.91,23.88,22.53,23.34,26.34,28.22,28.47,29.91,33.25,35.59,35.34,34.94,35.94,37.06,35.47,33.12,32.84,33.44,32.25,29.69,28.72,29.22,28.41,25.53,23.69,24.12,24.0,21.0,18.25,17.91,18.47,17.72,17.34,19.56,23.34,25.66,25.12,25.22,26.09,24.66,20.47,17.25,16.62,16.56,14.84,13.44,14.69,16.38,15.91,14.59,15.22,17.38,18.59,18.12,19.56,22.78,25.44,25.5,25.62,27.66,28.84,27.03,24.69,24.41,24.75,23.28,20.62,20.28,21.22,20.62,18.06,16.66,17.5,18.09,16.97,17.16,20.28,23.53,24.28,24.06,25.44,27.06,26.34,24.31,24.06,25.53,26.06,24.09,22.81,23.38,23.44,21.09,19.22,20.75,23.5,24.22,24.19,25.75,28.12,27.5,24.34,22.19,21.5,19.59,15.41,12.62,12.75,13.56,12.28,11.5,13.47,16.22,16.88,17.0,19.44,23.44,25.81,26.12,27.62,30.44,32.31,31.53,31.31,33.66,35.38,34.22,32.28,31.5,30.88,27.59,23.06,20.5,19.97,18.56,15.91,15.56,18.12,21.25,22.38,24.62,29.31,34.62,36.88,38.22,40.44,41.56,38.75,32.78,27.09,23.09,18.38,12.91,10.12,11.78,14.62,16.03,18.22,22.66,27.28,28.91,29.06,31.19,34.12,34.78,33.91,34.16,35.5,34.78,31.0,27.06,24.78,22.59,18.38,15.38,16.28,19.34,20.44,20.97,22.91,24.91,23.69,20.0,17.0,16.16,14.72,11.69,9.62,10.12,10.81,8.81,6.91,7.41,9.12,8.25,6.75,7.25,9.19,10.0,9.59,10.62,14.06,16.97,17.78,18.91,22.25,25.91,26.19,25.0,24.75,24.09,20.12,14.34,10.38,9.09,7.88,6.38,7.41,12.5,17.69,20.5,22.66,26.28,28.88,27.66,25.62,25.5,27.09,27.22,26.56,27.0,29.19,29.5,27.56,26.47,27.94,29.66,29.38,29.03,30.88,33.44,33.41,33.19,34.78,38.34,39.38,38.19,37.34,37.62,36.31,32.22,28.62,27.44,26.62,23.72,21.53,22.19,24.31,24.09,22.81,22.88,24.31,24.0,21.69,20.78,21.97,22.69,21.44,20.56,22.69,24.72,24.69,24.25,25.31,27.09,25.94,22.97,21.53,21.97,21.12,18.84,17.66,18.78,18.91,16.31,14.12,14.12,14.69,13.09,11.06,11.34,13.62,14.78,15.09,17.34,21.22,23.56,23.12,21.88,22.56,21.91,18.06,13.5,11.56,10.34,7.31,4.16,4.03,6.09,7.47,7.84,9.66,13.53,16.22,16.41,16.59,19.72,22.75,23.16,22.88,24.22,25.41,24.25,21.62,21.06,22.47,22.53,20.41,18.53,18.09,15.88,10.84,6.19,5.16,5.31,3.91,2.66,3.91,5.56,24.94,23.81,23.72,24.19,23.62,22.03,21.41,22.62,23.56,23.06,23.28,24.53,26.09,26.06:18.59,16.19,14.47,15.31,15.81,14.09,12.84,13.47,14.47,13.03,10.53,10.06,11.25,10.62,8.47,8.09,9.62,10.62,9.66,9.91,12.25,14.03,13.03,10.97,11.12,11.97,11.28,10.19,11.38,14.59,16.0,15.31,15.66,17.38,17.44,14.75,12.38,12.47,13.28,12.03,10.62,11.75,14.19,14.25,13.59,14.78,17.44,18.12,17.12,17.25,19.66,21.91,21.41,20.41,21.31,22.16,19.78,16.41,15.38,16.03,15.0,12.97,12.59,13.81,13.66,11.16,9.19,10.06,10.47,8.56,7.22,8.53,10.47,10.41,9.31,10.44,12.31,12.62,11.81,12.5,15.38,17.16,16.75,16.47,18.59,19.94,18.38,16.34,16.88,18.34,17.66,16.47,17.12,19.03,18.72,16.78,16.47,18.72,20.56,20.09,20.25,22.28,23.53,21.88,19.84,19.91,21.34,20.91,19.88,20.97,23.69,24.62,24.03,24.47,26.84,28.72,27.91,27.03,28.22,28.81,26.41,23.34,22.31,22.72,22.28,21.44,22.59,26.0,27.91,27.38,26.62,27.88,28.38,26.44,24.78,25.56,27.06,25.91,23.69,23.5,24.5,23.47,21.06,20.0,21.12,21.41,20.53,21.25,24.78,27.81,28.09,27.41,27.72,28.03,26.0,23.06,22.41,23.53,23.06,20.91,19.81,20.41,20.16,17.62,16.19,18.22,21.09,21.75,21.66,23.47,25.28,23.94,21.41,20.84,22.0,21.66,20.19,19.59,21.12,21.56,19.53,17.53,18.31,19.41,18.75,17.53,18.25,19.47,18.5,15.84,14.53,15.59,15.62,14.41,14.38,17.06,19.0,18.38,17.66,18.88,20.69,20.31,18.34,18.28,19.09,18.12,15.38,14.41,16.03,16.94,16.22,16.78,19.94,22.28,21.78,20.56,21.28,21.88,20.5,17.72,17.41,17.91,17.31,15.19,14.38,16.0,16.25,14.25,13.16,14.62,16.03,15.75,15.03,16.5,18.78,19.16,18.19,19.19,21.59,22.31,20.66,20.0,21.0,21.53,19.75,18.69,20.16,21.75,20.69,18.41,17.91,17.78,15.84,13.09,12.41,13.75,14.31,12.62,12.22,14.12,15.62,15.53,15.25,17.62,20.0,19.53,17.41,16.62,16.69,15.47,13.34,13.44,15.59,17.16,16.59,16.47,18.59,20.56,19.47,17.91,17.88,17.78,15.41,12.22,11.88,13.62,15.03,15.78,18.53,23.41,26.88,26.72,25.59,25.5,24.66,21.31,17.88,17.25,18.12,18.03,16.69,16.88,18.31,18.44,16.81,16.53,18.62,20.81,20.62,20.75,23.34,26.19,26.5,25.81,27.34,29.12,29.19,27.88,28.25,29.94,30.09,27.88,25.91,25.59,24.44,20.97,17.66,16.88,16.66,15.09,13.34,14.12,16.28,17.22,17.16,18.38,21.47,23.22,22.22,21.78,23.22,24.0,22.59,21.28,22.19,23.28,22.47,20.84,20.75,21.62,20.91,18.5,17.44,18.56,19.47,18.75,19.16,21.94,25.06,25.47,25.38,26.81,28.69,28.28,26.38,26.19,27.03,26.53,23.88,22.28,22.56,22.44,19.81,17.44,17.81,18.56,17.66,16.47,17.44,19.34,19.47,18.25,18.75,20.91,21.75,20.53,19.78,20.88,21.5,19.75,17.88,17.97,18.69,17.12,14.72,14.69,15.34,13.88,11.38,10.66,12.09,13.5,13.28,14.25,17.09,19.31,18.78,17.56,18.38,19.62,18.47,16.38,16.41,18.06,18.94,18.44,18.97,20.97,21.75,20.41,19.53,21.34,24.0,24.53,24.56,25.78,27.66,26.69,24.12,23.06,23.81,23.56,21.84,21.19,22.69,23.53,21.38,19.84,20.53,21.47,20.72,19.91,21.06,23.84,24.69,24.31,25.03,26.69,27.12,25.5,24.81,26.41,28.31,27.72,26.91,27.75,28.53,26.72,24.09,23.38,23.94,23.22,21.12,21.06,22.75,23.53,22.38,21.56,23.0,24.53,23.56,22.34,23.31,24.62,23.84,22.12,22.28,24.03,24.28,23.88,24.38,27.03,29.0,28.0,27.41,28.62,29.53,27.72,24.88,23.31,22.0,18.56,14.5,12.53,13.38,13.41,12.03,12.12,14.31,16.25,16.09,17.0,20.28,23.97,24.75,24.75,25.84,27.09,26.09,23.41,22.25,22.78,22.94,21.94,22.25,24.81,27.19,26.59,25.66,26.41,27.34,25.78,23.38,23.03,23.84,23.03,21.16,20.81,22.5,23.81,24.03,25.28,29.25,33.25,34.44,34.69,36.16,37.25,36.03,33.44,32.66,33.88,34.03,33.09,33.31,35.34,36.25,34.66,32.91,33.62,34.41,32.94,31.22,31.56,32.38,31.44,28.44,26.53,26.22,25.16,22.19,20.91,22.09,23.38,22.88,22.38,24.31,26.69,26.31,24.75,25.31,26.44,25.41,22.78,21.41,22.22,22.25,20.94,20.72,23.34,25.0,24.78,24.88,27.34,30.28,30.97,30.72,31.56,33.09,32.38,30.31,29.12,30.25,30.44,28.78,27.34,27.88,27.44,24.56,21.59,21.56,22.84,23.09,23.22,25.06,27.53,28.0,26.12,24.62,25.41,25.78,24.72,23.84,25.56,26.97,25.66,23.09,22.66,22.69,21.28,19.25,19.16,21.03,21.56,20.53,19.84,21.16,21.94,20.88,20.0,21.81,23.25,21.81,19.28,18.06,17.75,15.81,13.28,12.91,14.78,15.97,15.19,14.47,15.62,16.56,15.03,13.59,14.91,16.34,15.31,13.16,12.66,13.84,14.16,13.91,15.47,19.53,22.25,22.06,21.62,22.41,22.38,19.88,16.72,15.88,15.56,13.44,10.19,9.28,10.09,9.81,8.31,7.72,9.41,9.97,8.41,7.75,9.81,12.5,13.5,13.88,15.97,18.0,17.38,14.62,13.25,13.22,12.69,10.72,9.94,12.0,14.16,14.16,14.28,16.94,20.03,20.94,20.38,21.22,22.31,20.41,16.38,14.03,14.25,14.59,14.53,16.0,19.91,22.38,21.59,18.78,18.03,17.84,16.09,14.34,15.31,17.78,18.97,18.19,19.31,22.53,25.19,26.12,27.16,30.94,34.47,34.84,34.34,35.31,36.0,34.03,30.25,28.47,28.03,26.66,24.03,22.66,23.22,23.16,20.97,18.84,19.59,20.75,20.0,19.0,20.62,23.5,24.72,24.78,26.59,29.44,30.56,28.97,27.53,27.25,25.88,21.41,17.12,15.56,15.12,13.5,11.66,12.41,14.59,15.25,14.78,15.84,18.78,21.19,21.38,22.47,25.84,29.0,29.59,29.84,32.06,34.72,34.88,33.62,34.0,35.41,34.62,31.97,30.09,29.41,28.09,24.12,21.12,21.12,22.12,21.25,20.62,22.06,23.91,23.88,22.53,23.34,26.34,28.22,28.47,29.91,33.25,35.59,35.34,34.94,35.94,37.06,35.47,33.12,32.84,33.44,32.25,29.69,28.72,29.22,28.41,25.53,23.69,24.12,24.0,21.0,18.25,17.91,18.47,17.72,17.34,19.56,23.34,25.66,25.12,25.22,26.09,24.66,20.47,17.25,16.62,16.56,14.84,13.44,14.69,16.38,15.91,14.59,15.22,17.38,18.59,18.12,19.56,22.78,25.44,25.5,25.62,27.66,28.84,27.03,24.69,24.41,24.75,23.28,20.62,20.28,21.22,20.62,18.06,16.66,17.5,18.09,16.97,17.16,20.28,23.53,24.28,24.06,25.44,27.06,26.34,24.31,24.06,25.53,26.06,24.09,22.81,23.38,23.44,21.09,19.22,20.75,23.5,24.22,24.19,25.75,28.12,27.5,24.34,22.19,21.5,19.59,15.41,12.62,12.75,13.56,12.28,11.5,13.47,16.22,16.88,17.0,19.44,23.44,25.81,26.12,27.62,30.44,32.31,31.53,31.31,33.66,35.38,34.22,32.28,31.5,30.88,27.59,23.06,20.5,19.97,18.56,15.91,15.56,18.12,21.25,22.38,24.62,29.31,34.62,36.88,38.22,40.44,41.56,38.75,32.78,27.09,23.09,18.38,12.91,10.12,11.78,14.62,16.03,18.22,22.66,27.28,28.91,29.06,31.19,34.12,34.78,33.91,34.16,35.5,34.78,31.0,27.06,24.78,22.59,18.38,15.38,16.28,19.34,20.44,20.97,22.91,24.91,23.69,20.0,17.0,16.16,14.72,11.69,9.62,10.12,10.81,8.81,6.91,7.41,9.12,8.25,6.75,7.25,9.19,10.0,9.59,10.62,14.06,16.97,17.78,18.91,22.25,25.91,26.19,25.0,24.75,24.09,20.12,14.34,10.38,9.09,7.88,6.38,7.41,12.5,17.69,20.5,22.66,26.28,28.88,27.66,25.62,25.5,27.09,27.22,26.56,27.0,29.19,29.5,27.56,26.47,27.94,29.66,29.38,29.03,30.88,33.44,33.41,33.19,34.78,38.34,39.38,38.19,37.34,37.62,36.31,32.22,28.62,27.44,26.62,23.72,21.53,22.19,24.31,24.09,22.81,22.88,24.31,24.0,21.69,20.78,21.97,22.69,21.44,20.56,22.69,24.72,24.69,24.25,25.31,27.09,25.94,22.97,21.53,21.97,21.12,18.84,17.66,18.78,18.91,16.31,14.12,14.12,14.69,13.09,11.06,11.34,13.62,14.78,15.09,17.34,21.22,23.56,23.12,21.88,22.56,21.91,18.06,13.5,11.56,10.34,7.31,4.16,4.03,6.09,7.47,7.84,9.66,13.53,16.22,16.41,16.59,19.72,22.75,23.16,22.88,24.22,25.41,24.25,21.62,21.06,22.47,22.53,20.41,18.53,18.09,15.88,10.84,6.19,5.16,5.31,3.91,2.66,3.91,5.56,24.94,23.81,23.72,24.19,23.62,22.03,21.41,22.62,23.56,23.06,23.28,24.53,26.09,26.06,26.03,27.44,29.16,29.22,28.31,27.62,27.5:13.47,14.47,13.03,10.53,10.06,11.25,10.62,8.47,8.09,9.62,10.62,9.66,9.91,12.25,14.03,13.03,10.97,11.12,11.97,11.28,10.19,11.38,14.59,16.0,15.31,15.66,17.38,17.44,14.75,12.38,12.47,13.28,12.03,10.62,11.75,14.19,14.25,13.59,14.78,17.44,18.12,17.12,17.25,19.66,21.91,21.41,20.41,21.31,22.16,19.78,16.41,15.38,16.03,15.0,12.97,12.59,13.81,13.66,11.16,9.19,10.06,10.47,8.56,7.22,8.53,10.47,10.41,9.31,10.44,12.31,12.62,11.81,12.5,15.38,17.16,16.75,16.47,18.59,19.94,18.38,16.34,16.88,18.34,17.66,16.47,17.12,19.03,18.72,16.78,16.47,18.72,20.56,20.09,20.25,22.28,23.53,21.88,19.84,19.91,21.34,20.91,19.88,20.97,23.69,24.62,24.03,24.47,26.84,28.72,27.91,27.03,28.22,28.81,26.41,23.34,22.31,22.72,22.28,21.44,22.59,26.0,27.91,27.38,26.62,27.88,28.38,26.44,24.78,25.56,27.06,25.91,23.69,23.5,24.5,23.47,21.06,20.0,21.12,21.41,20.53,21.25,24.78,27.81,28.09,27.41,27.72,28.03,26.0,23.06,22.41,23.53,23.06,20.91,19.81,20.41,20.16,17.62,16.19,18.22,21.09,21.75,21.66,23.47,25.28,23.94,21.41,20.84,22.0,21.66,20.19,19.59,21.12,21.56,19.53,17.53,18.31,19.41,18.75,17.53,18.25,19.47,18.5,15.84,14.53,15.59,15.62,14.41,14.38,17.06,19.0,18.38,17.66,18.88,20.69,20.31,18.34,18.28,19.09,18.12,15.38,14.41,16.03,16.94,16.22,16.78,19.94,22.28,21.78,20.56,21.28,21.88,20.5,17.72,17.41,17.91,17.31,15.19,14.38,16.0,16.25,14.25,13.16,14.62,16.03,15.75,15.03,16.5,18.78,19.16,18.19,19.19,21.59,22.31,20.66,20.0,21.0,21.53,19.75,18.69,20.16,21.75,20.69,18.41,17.91,17.78,15.84,13.09,12.41,13.75,14.31,12.62,12.22,14.12,15.62,15.53,15.25,17.62,20.0,19.53,17.41,16.62,16.69,15.47,13.34,13.44,15.59,17.16,16.59,16.47,18.59,20.56,19.47,17.91,17.88,17.78,15.41,12.22,11.88,13.62,15.03,15.78,18.53,23.41,26.88,26.72,25.59,25.5,24.66,21.31,17.88,17.25,18.12,18.03,16.69,16.88,18.31,18.44,16.81,16.53,18.62,20.81,20.62,20.75,23.34,26.19,26.5,25.81,27.34,29.12,29.19,27.88,28.25,29.94,30.09,27.88,25.91,25.59,24.44,20.97,17.66,16.88,16.66,15.09,13.34,14.12,16.28,17.22,17.16,18.38,21.47,23.22,22.22,21.78,23.22,24.0,22.59,21.28,22.19,23.28,22.47,20.84,20.75,21.62,20.91,18.5,17.44,18.56,19.47,18.75,19.16,21.94,25.06,25.47,25.38,26.81,28.69,28.28,26.38,26.19,27.03,26.53,23.88,22.28,22.56,22.44,19.81,17.44,17.81,18.56,17.66,16.47,17.44,19.34,19.47,18.25,18.75,20.91,21.75,20.53,19.78,20.88,21.5,19.75,17.88,17.97,18.69,17.12,14.72,14.69,15.34,13.88,11.38,10.66,12.09,13.5,13.28,14.25,17.09,19.31,18.78,17.56,18.38,19.62,18.47,16.38,16.41,18.06,18.94,18.44,18.97,20.97,21.75,20.41,19.53,21.34,24.0,24.53,24.56,25.78,27.66,26.69,24.12,23.06,23.81,23.56,21.84,21.19,22.69,23.53,21.38,19.84,20.53,21.47,20.72,19.91,21.06,23.84,24.69,24.31,25.03,26.69,27.12,25.5,24.81,26.41,28.31,27.72,26.91,27.75,28.53,26.72,24.09,23.38,23.94,23.22,21.12,21.06,22.75,23.53,22.38,21.56,23.0,24.53,23.56,22.34,23.31,24.62,23.84,22.12,22.28,24.03,24.28,23.88,24.38,27.03,29.0,28.0,27.41,28.62,29.53,27.72,24.88,23.31,22.0,18.56,14.5,12.53,13.38,13.41,12.03,12.12,14.31,16.25,16.09,17.0,20.28,23.97,24.75,24.75,25.84,27.09,26.09,23.41,22.25,22.78,22.94,21.94,22.25,24.81,27.19,26.59,25.66,26.41,27.34,25.78,23.38,23.03,23.84,23.03,21.16,20.81,22.5,23.81,24.03,25.28,29.25,33.25,34.44,34.69,36.16,37.25,36.03,33.44,32.66,33.88,34.03,33.09,33.31,35.34,36.25,34.66,32.91,33.62,34.41,32.94,31.22,31.56,32.38,31.44,28.44,26.53,26.22,25.16,22.19,20.91,22.09,23.38,22.88,22.38,24.31,26.69,26.31,24.75,25.31,26.44,25.41,22.78,21.41,22.22,22.25,20.94,20.72,23.34,25.0,24.78,24.88,27.34,30.28,30.97,30.72,31.56,33.09,32.38,30.31,29.12,30.25,30.44,28.78,27.34,27.88,27.44,24.56,21.59,21.56,22.84,23.09,23.22,25.06,27.53,28.0,26.12,24.62,25.41,25.78,24.72,23.84,25.56,26.97,25.66,23.09,22.66,22.69,21.28,19.25,19.16,21.03,21.56,20.53,19.84,21.16,21.94,20.88,20.0,21.81,23.25,21.81,19.28,18.06,17.75,15.81,13.28,12.91,14.78,15.97,15.19,14.47,15.62,16.56,15.03,13.59,14.91,16.34,15.31,13.16,12.66,13.84,14.16,13.91,15.47,19.53,22.25,22.06,21.62,22.41,22.38,19.88,16.72,15.88,15.56,13.44,10.19,9.28,10.09,9.81,8.31,7.72,9.41,9.97,8.41,7.75,9.81,12.5,13.5,13.88,15.97,18.0,17.38,14.62,13.25,13.22,12.69,10.72,9.94,12.0,14.16,14.16,14.28,16.94,20.03,20.94,20.38,21.22,22.31,20.41,16.38,14.03,14.25,14.59,14.53,16.0,19.91,22.38,21.59,18.78,18.03,17.84,16.09,14.34,15.31,17.78,18.97,18.19,19.31,22.53,25.19,26.12,27.16,30.94,34.47,34.84,34.34,35.31,36.0,34.03,30.25,28.47,28.03,26.66,24.03,22.66,23.22,23.16,20.97,18.84,19.59,20.75,20.0,19.0,20.62,23.5,24.72,24.78,26.59,29.44,30.56,28.97,27.53,27.25,25.88,21.41,17.12,15.56,15.12,13.5,11.66,12.41,14.59,15.25,14.78,15.84,18.78,21.19,21.38,22.47,25.84,29.0,29.59,29.84,32.06,34.72,34.88,33.62,34.0,35.41,34.62,31.97,30.09,29.41,28.09,24.12,21.12,21.12,22.12,21.25,20.62,22.06,23.91,23.88,22.53,23.34,26.34,28.22,28.47,29.91,33.25,35.59,35.34,34.94,35.94,37.06,35.47,33.12,32.84,33.44,32.25,29.69,28.72,29.22,28.41,25.53,23.69,24.12,24.0,21.0,18.25,17.91,18.47,17.72,17.34,19.56,23.34,25.66,25.12,25.22,26.09,24.66,20.47,17.25,16.62,16.56,14.84,13.44,14.69,16.38,15.91,14.59,15.22,17.38,18.59,18.12,19.56,22.78,25.44,25.5,25.62,27.66,28.84,27.03,24.69,24.41,24.75,23.28,20.62,20.28,21.22,20.62,18.06,16.66,17.5,18.09,16.97,17.16,20.28,23.53,24.28,24.06,25.44,27.06,26.34,24.31,24.06,25.53,26.06,24.09,22.81,23.38,23.44,21.09,19.22,20.75,23.5,24.22,24.19,25.75,28.12,27.5,24.34,22.19,21.5,19.59,15.41,12.62,12.75,13.56,12.28,11.5,13.47,16.22,16.88,17.0,19.44,23.44,25.81,26.12,27.62,30.44,32.31,31.53,31.31,33.66,35.38,34.22,32.28,31.5,30.88,27.59,23.06,20.5,19.97,18.56,15.91,15.56,18.12,21.25,22.38,24.62,29.31,34.62,36.88,38.22,40.44,41.56,38.75,32.78,27.09,23.09,18.38,12.91,10.12,11.78,14.62,16.03,18.22,22.66,27.28,28.91,29.06,31.19,34.12,34.78,33.91,34.16,35.5,34.78,31.0,27.06,24.78,22.59,18.38,15.38,16.28,19.34,20.44,20.97,22.91,24.91,23.69,20.0,17.0,16.16,14.72,11.69,9.62,10.12,10.81,8.81,6.91,7.41,9.12,8.25,6.75,7.25,9.19,10.0,9.59,10.62,14.06,16.97,17.78,18.91,22.25,25.91,26.19,25.0,24.75,24.09,20.12,14.34,10.38,9.09,7.88,6.38,7.41,12.5,17.69,20.5,22.66,26.28,28.88,27.66,25.62,25.5,27.09,27.22,26.56,27.0,29.19,29.5,27.56,26.47,27.94,29.66,29.38,29.03,30.88,33.44,33.41,33.19,34.78,38.34,39.38,38.19,37.34,37.62,36.31,32.22,28.62,27.44,26.62,23.72,21.53,22.19,24.31,24.09,22.81,22.88,24.31,24.0,21.69,20.78,21.97,22.69,21.44,20.56,22.69,24.72,24.69,24.25,25.31,27.09,25.94,22.97,21.53,21.97,21.12,18.84,17.66,18.78,18.91,16.31,14.12,14.12,14.69,13.09,11.06,11.34,13.62,14.78,15.09,17.34,21.22,23.56,23.12,21.88,22.56,21.91,18.06,13.5,11.56,10.34,7.31,4.16,4.03,6.09,7.47,7.84,9.66,13.53,16.22,16.41,16.59,19.72,22.75,23.16,22.88,24.22,25.41,24.25,21.62,21.06,22.47,22.53,20.41,18.53,18.09,15.88,10.84,6.19,5.16,5.31,3.91,2.66,3.91,5.56,24.94,23.81,23.72,24.19,23.62,22.03,21.41,22.62,23.56,23.06,23.28,24.53,26.09,26.06,26.03,27.44,29.16,29.22,28.31,27.62,27.5,26.5,24.19,22.84,22.94,23.34,22.5,22.53:8.47,8.09,9.62,10.62,9.66,9.91,12.25,14.03,13.03,10.97,11.12,11.97,11.28,10.19,11.38,14.59,16.0,15.31,15.66,17.38,17.44,14.75,12.38,12.47,13.28,12.03,10.62,11.75,14.19,14.25,13.59,14.78,17.44,18.12,17.12,17.25,19.66,21.91,21.41,20.41,21.31,22.16,19.78,16.41,15.38,16.03,15.0,12.97,12.59,13.81,13.66,11.16,9.19,10.06,10.47,8.56,7.22,8.53,10.47,10.41,9.31,10.44,12.31,12.62,11.81,12.5,15.38,17.16,16.75,16.47,18.59,19.94,18.38,16.34,16.88,18.34,17.66,16.47,17.12,19.03,18.72,16.78,16.47,18.72,20.56,20.09,20.25,22.28,23.53,21.88,19.84,19.91,21.34,20.91,19.88,20.97,23.69,24.62,24.03,24.47,26.84,28.72,27.91,27.03,28.22,28.81,26.41,23.34,22.31,22.72,22.28,21.44,22.59,26.0,27.91,27.38,26.62,27.88,28.38,26.44,24.78,25.56,27.06,25.91,23.69,23.5,24.5,23.47,21.06,20.0,21.12,21.41,20.53,21.25,24.78,27.81,28.09,27.41,27.72,28.03,26.0,23.06,22.41,23.53,23.06,20.91,19.81,20.41,20.16,17.62,16.19,18.22,21.09,21.75,21.66,23.47,25.28,23.94,21.41,20.84,22.0,21.66,20.19,19.59,21.12,21.56,19.53,17.53,18.31,19.41,18.75,17.53,18.25,19.47,18.5,15.84,14.53,15.59,15.62,14.41,14.38,17.06,19.0,18.38,17.66,18.88,20.69,20.31,18.34,18.28,19.09,18.12,15.38,14.41,16.03,16.94,16.22,16.78,19.94,22.28,21.78,20.56,21.28,21.88,20.5,17.72,17.41,17.91,17.31,15.19,14.38,16.0,16.25,14.25,13.16,14.62,16.03,15.75,15.03,16.5,18.78,19.16,18.19,19.19,21.59,22.31,20.66,20.0,21.0,21.53,19.75,18.69,20.16,21.75,20.69,18.41,17.91,17.78,15.84,13.09,12.41,13.75,14.31,12.62,12.22,14.12,15.62,15.53,15.25,17.62,20.0,19.53,17.41,16.62,16.69,15.47,13.34,13.44,15.59,17.16,16.59,16.47,18.59,20.56,19.47,17.91,17.88,17.78,15.41,12.22,11.88,13.62,15.03,15.78,18.53,23.41,26.88,26.72,25.59,25.5,24.66,21.31,17.88,17.25,18.12,18.03,16.69,16.88,18.31,18.44,16.81,16.53,18.62,20.81,20.62,20.75,23.34,26.19,26.5,25.81,27.34,29.12,29.19,27.88,28.25,29.94,30.09,27.88,25.91,25.59,24.44,20.97,17.66,16.88,16.66,15.09,13.34,14.12,16.28,17.22,17.16,18.38,21.47,23.22,22.22,21.78,23.22,24.0,22.59,21.28,22.19,23.28,22.47,20.84,20.75,21.62,20.91,18.5,17.44,18.56,19.47,18.75,19.16,21.94,25.06,25.47,25.38,26.81,28.69,28.28,26.38,26.19,27.03,26.53,23.88,22.28,22.56,22.44,19.81,17.44,17.81,18.56,17.66,16.47,17.44,19.34,19.47,18.25,18.75,20.91,21.75,20.53,19.78,20.88,21.5,19.75,17.88,17.97,18.69,17.12,14.72,14.69,15.34,13.88,11.38,10.66,12.09,13.5,13.28,14.25,17.09,19.31,18.78,17.56,18.38,19.62,18.47,16.38,16.41,18.06,18.94,18.44,18.97,20.97,21.75,20.41,19.53,21.34,24.0,24.53,24.56,25.78,27.66,26.69,24.12,23.06,23.81,23.56,21.84,21.19,22.69,23.53,21.38,19.84,20.53,21.47,20.72,19.91,21.06,23.84,24.69,24.31,25.03,26.69,27.12,25.5,24.81,26.41,28.31,27.72,26.91,27.75,28.53,26.72,24.09,23.38,23.94,23.22,21.12,21.06,22.75,23.53,22.38,21.56,23.0,24.53,23.56,22.34,23.31,24.62,23.84,22.12,22.28,24.03,24.28,23.88,24.38,27.03,29.0,28.0,27.41,28.62,29.53,27.72,24.88,23.31,22.0,18.56,14.5,12.53,13.38,13.41,12.03,12.12,14.31,16.25,16.09,17.0,20.28,23.97,24.75,24.75,25.84,27.09,26.09,23.41,22.25,22.78,22.94,21.94,22.25,24.81,27.19,26.59,25.66,26.41,27.34,25.78,23.38,23.03,23.84,23.03,21.16,20.81,22.5,23.81,24.03,25.28,29.25,33.25,34.44,34.69,36.16,37.25,36.03,33.44,32.66,33.88,34.03,33.09,33.31,35.34,36.25,34.66,32.91,33.62,34.41,32.94,31.22,31.56,32.38,31.44,28.44,26.53,26.22,25.16,22.19,20.91,22.09,23.38,22.88,22.38,24.31,26.69,26.31,24.75,25.31,26.44,25.41,22.78,21.41,22.22,22.25,20.94,20.72,23.34,25.0,24.78,24.88,27.34,30.28,30.97,30.72,31.56,33.09,32.38,30.31,29.12,30.25,30.44,28.78,27.34,27.88,27.44,24.56,21.59,21.56,22.84,23.09,23.22,25.06,27.53,28.0,26.12,24.62,25.41,25.78,24.72,23.84,25.56,26.97,25.66,23.09,22.66,22.69,21.28,19.25,19.16,21.03,21.56,20.53,19.84,21.16,21.94,20.88,20.0,21.81,23.25,21.81,19.28,18.06,17.75,15.81,13.28,12.91,14.78,15.97,15.19,14.47,15.62,16.56,15.03,13.59,14.91,16.34,15.31,13.16,12.66,13.84,14.16,13.91,15.47,19.53,22.25,22.06,21.62,22.41,22.38,19.88,16.72,15.88,15.56,13.44,10.19,9.28,10.09,9.81,8.31,7.72,9.41,9.97,8.41,7.75,9.81,12.5,13.5,13.88,15.97,18.0,17.38,14.62,13.25,13.22,12.69,10.72,9.94,12.0,14.16,14.16,14.28,16.94,20.03,20.94,20.38,21.22,22.31,20.41,16.38,14.03,14.25,14.59,14.53,16.0,19.91,22.38,21.59,18.78,18.03,17.84,16.09,14.34,15.31,17.78,18.97,18.19,19.31,22.53,25.19,26.12,27.16,30.94,34.47,34.84,34.34,35.31,36.0,34.03,30.25,28.47,28.03,26.66,24.03,22.66,23.22,23.16,20.97,18.84,19.59,20.75,20.0,19.0,20.62,23.5,24.72,24.78,26.59,29.44,30.56,28.97,27.53,27.25,25.88,21.41,17.12,15.56,15.12,13.5,11.66,12.41,14.59,15.25,14.78,15.84,18.78,21.19,21.38,22.47,25.84,29.0,29.59,29.84,32.06,34.72,34.88,33.62,34.0,35.41,34.62,31.97,30.09,29.41,28.09,24.12,21.12,21.12,22.12,21.25,20.62,22.06,23.91,23.88,22.53,23.34,26.34,28.22,28.47,29.91,33.25,35.59,35.34,34.94,35.94,37.06,35.47,33.12,32.84,33.44,32.25,29.69,28.72,29.22,28.41,25.53,23.69,24.12,24.0,21.0,18.25,17.91,18.47,17.72,17.34,19.56,23.34,25.66,25.12,25.22,26.09,24.66,20.47,17.25,16.62,16.56,14.84,13.44,14.69,16.38,15.91,14.59,15.22,17.38,18.59,18.12,19.56,22.78,25.44,25.5,25.62,27.66,28.84,27.03,24.69,24.41,24.75,23.28,20.62,20.28,21.22,20.62,18.06,16.66,17.5,18.09,16.97,17.16,20.28,23.53,24.28,24.06,25.44,27.06,26.34,24.31,24.06,25.53,26.06,24.09,22.81,23.38,23.44,21.09,19.22,20.75,23.5,24.22,24.19,25.75,28.12,27.5,24.34,22.19,21.5,19.59,15.41,12.62,12.75,13.56,12.28,11.5,13.47,16.22,16.88,17.0,19.44,23.44,25.81,26.12,27.62,30.44,32.31,31.53,31.31,33.66,35.38,34.22,32.28,31.5,30.88,27.59,23.06,20.5,19.97,18.56,15.91,15.56,18.12,21.25,22.38,24.62,29.31,34.62,36.88,38.22,40.44,41.56,38.75,32.78,27.09,23.09,18.38,12.91,10.12,11.78,14.62,16.03,18.22,22.66,27.28,28.91,29.06,31.19,34.12,34.78,33.91,34.16,35.5,34.78,31.0,27.06,24.78,22.59,18.38,15.38,16.28,19.34,20.44,20.97,22.91,24.91,23.69,20.0,17.0,16.16,14.72,11.69,9.62,10.12,10.81,8.81,6.91,7.41,9.12,8.25,6.75,7.25,9.19,10.0,9.59,10.62,14.06,16.97,17.78,18.91,22.25,25.91,26.19,25.0,24.75,24.09,20.12,14.34,10.38,9.09,7.88,6.38,7.41,12.5,17.69,20.5,22.66,26.28,28.88,27.66,25.62,25.5,27.09,27.22,26.56,27.0,29.19,29.5,27.56,26.47,27.94,29.66,29.38,29.03,30.88,33.44,33.41,33.19,34.78,38.34,39.38,38.19,37.34,37.62,36.31,32.22,28.62,27.44,26.62,23.72,21.53,22.19,24.31,24.09,22.81,22.88,24.31,24.0,21.69,20.78,21.97,22.69,21.44,20.56,22.69,24.72,24.69,24.25,25.31,27.09,25.94,22.97,21.53,21.97,21.12,18.84,17.66,18.78,18.91,16.31,14.12,14.12,14.69,13.09,11.06,11.34,13.62,14.78,15.09,17.34,21.22,23.56,23.12,21.88,22.56,21.91,18.06,13.5,11.56,10.34,7.31,4.16,4.03,6.09,7.47,7.84,9.66,13.53,16.22,16.41,16.59,19.72,22.75,23.16,22.88,24.22,25.41,24.25,21.62,21.06,22.47,22.53,20.41,18.53,18.09,15.88,10.84,6.19,5.16,5.31,3.91,2.66,3.91,5.56,24.94,23.81,23.72,24.19,23.62,22.03,21.41,22.62,23.56,23.06,23.28,24.53,26.09,26.06,26.03,27.44,29.16,29.22,28.31,27.62,27.5,26.5,24.19,22.84,22.94,23.34,22.5,22.53,23.88,25.34,25.16,24.22,24.53,25.41,25.12:14.03,13.03,10.97,11.12,11.97,11.28,10.19,11.38,14.59,16.0,15.31,15.66,17.38,17.44,14.75,12.38,12.47,13.28,12.03,10.62,11.75,14.19,14.25,13.59,14.78,17.44,18.12,17.12,17.25,19.66,21.91,21.41,20.41,21.31,22.16,19.78,16.41,15.38,16.03,15.0,12.97,12.59,13.81,13.66,11.16,9.19,10.06,10.47,8.56,7.22,8.53,10.47,10.41,9.31,10.44,12.31,12.62,11.81,12.5,15.38,17.16,16.75,16.47,18.59,19.94,18.38,16.34,16.88,18.34,17.66,16.47,17.12,19.03,18.72,16.78,16.47,18.72,20.56,20.09,20.25,22.28,23.53,21.88,19.84,19.91,21.34,20.91,19.88,20.97,23.69,24.62,24.03,24.47,26.84,28.72,27.91,27.03,28.22,28.81,26.41,23.34,22.31,22.72,22.28,21.44,22.59,26.0,27.91,27.38,26.62,27.88,28.38,26.44,24.78,25.56,27.06,25.91,23.69,23.5,24.5,23.47,21.06,20.0,21.12,21.41,20.53,21.25,24.78,27.81,28.09,27.41,27.72,28.03,26.0,23.06,22.41,23.53,23.06,20.91,19.81,20.41,20.16,17.62,16.19,18.22,21.09,21.75,21.66,23.47,25.28,23.94,21.41,20.84,22.0,21.66,20.19,19.59,21.12,21.56,19.53,17.53,18.31,19.41,18.75,17.53,18.25,19.47,18.5,15.84,14.53,15.59,15.62,14.41,14.38,17.06,19.0,18.38,17.66,18.88,20.69,20.31,18.34,18.28,19.09,18.12,15.38,14.41,16.03,16.94,16.22,16.78,19.94,22.28,21.78,20.56,21.28,21.88,20.5,17.72,17.41,17.91,17.31,15.19,14.38,16.0,16.25,14.25,13.16,14.62,16.03,15.75,15.03,16.5,18.78,19.16,18.19,19.19,21.59,22.31,20.66,20.0,21.0,21.53,19.75,18.69,20.16,21.75,20.69,18.41,17.91,17.78,15.84,13.09,12.41,13.75,14.31,12.62,12.22,14.12,15.62,15.53,15.25,17.62,20.0,19.53,17.41,16.62,16.69,15.47,13.34,13.44,15.59,17.16,16.59,16.47,18.59,20.56,19.47,17.91,17.88,17.78,15.41,12.22,11.88,13.62,15.03,15.78,18.53,23.41,26.88,26.72,25.59,25.5,24.66,21.31,17.88,17.25,18.12,18.03,16.69,16.88,18.31,18.44,16.81,16.53,18.62,20.81,20.62,20.75,23.34,26.19,26.5,25.81,27.34,29.12,29.19,27.88,28.25,29.94,30.09,27.88,25.91,25.59,24.44,20.97,17.66,16.88,16.66,15.09,13.34,14.12,16.28,17.22,17.16,18.38,21.47,23.22,22.22,21.78,23.22,24.0,22.59,21.28,22.19,23.28,22.47,20.84,20.75,21.62,20.91,18.5,17.44,18.56,19.47,18.75,19.16,21.94,25.06,25.47,25.38,26.81,28.69,28.28,26.38,26.19,27.03,26.53,23.88,22.28,22.56,22.44,19.81,17.44,17.81,18.56,17.66,16.47,17.44,19.34,19.47,18.25,18.75,20.91,21.75,20.53,19.78,20.88,21.5,19.75,17.88,17.97,18.69,17.12,14.72,14.69,15.34,13.88,11.38,10.66,12.09,13.5,13.28,14.25,17.09,19.31,18.78,17.56,18.38,19.62,18.47,16.38,16.41,18.06,18.94,18.44,18.97,20.97,21.75,20.41,19.53,21.34,24.0,24.53,24.56,25.78,27.66,26.69,24.12,23.06,23.81,23.56,21.84,21.19,22.69,23.53,21.38,19.84,20.53,21.47,20.72,19.91,21.06,23.84,24.69,24.31,25.03,26.69,27.12,25.5,24.81,26.41,28.31,27.72,26.91,27.75,28.53,26.72,24.09,23.38,23.94,23.22,21.12,21.06,22.75,23.53,22.38,21.56,23.0,24.53,23.56,22.34,23.31,24.62,23.84,22.12,22.28,24.03,24.28,23.88,24.38,27.03,29.0,28.0,27.41,28.62,29.53,27.72,24.88,23.31,22.0,18.56,14.5,12.53,13.38,13.41,12.03,12.12,14.31,16.25,16.09,17.0,20.28,23.97,24.75,24.75,25.84,27.09,26.09,23.41,22.25,22.78,22.94,21.94,22.25,24.81,27.19,26.59,25.66,26.41,27.34,25.78,23.38,23.03,23.84,23.03,21.16,20.81,22.5,23.81,24.03,25.28,29.25,33.25,34.44,34.69,36.16,37.25,36.03,33.44,32.66,33.88,34.03,33.09,33.31,35.34,36.25,34.66,32.91,33.62,34.41,32.94,31.22,31.56,32.38,31.44,28.44,26.53,26.22,25.16,22.19,20.91,22.09,23.38,22.88,22.38,24.31,26.69,26.31,24.75,25.31,26.44,25.41,22.78,21.41,22.22,22.25,20.94,20.72,23.34,25.0,24.78,24.88,27.34,30.28,30.97,30.72,31.56,33.09,32.38,30.31,29.12,30.25,30.44,28.78,27.34,27.88,27.44,24.56,21.59,21.56,22.84,23.09,23.22,25.06,27.53,28.0,26.12,24.62,25.41,25.78,24.72,23.84,25.56,26.97,25.66,23.09,22.66,22.69,21.28,19.25,19.16,21.03,21.56,20.53,19.84,21.16,21.94,20.88,20.0,21.81,23.25,21.81,19.28,18.06,17.75,15.81,13.28,12.91,14.78,15.97,15.19,14.47,15.62,16.56,15.03,13.59,14.91,16.34,15.31,13.16,12.66,13.84,14.16,13.91,15.47,19.53,22.25,22.06,21.62,22.41,22.38,19.88,16.72,15.88,15.56,13.44,10.19,9.28,10.09,9.81,8.31,7.72,9.41,9.97,8.41,7.75,9.81,12.5,13.5,13.88,15.97,18.0,17.38,14.62,13.25,13.22,12.69,10.72,9.94,12.0,14.16,14.16,14.28,16.94,20.03,20.94,20.38,21.22,22.31,20.41,16.38,14.03,14.25,14.59,14.53,16.0,19.91,22.38,21.59,18.78,18.03,17.84,16.09,14.34,15.31,17.78,18.97,18.19,19.31,22.53,25.19,26.12,27.16,30.94,34.47,34.84,34.34,35.31,36.0,34.03,30.25,28.47,28.03,26.66,24.03,22.66,23.22,23.16,20.97,18.84,19.59,20.75,20.0,19.0,20.62,23.5,24.72,24.78,26.59,29.44,30.56,28.97,27.53,27.25,25.88,21.41,17.12,15.56,15.12,13.5,11.66,12.41,14.59,15.25,14.78,15.84,18.78,21.19,21.38,22.47,25.84,29.0,29.59,29.84,32.06,34.72,34.88,33.62,34.0,35.41,34.62,31.97,30.09,29.41,28.09,24.12,21.12,21.12,22.12,21.25,20.62,22.06,23.91,23.88,22.53,23.34,26.34,28.22,28.47,29.91,33.25,35.59,35.34,34.94,35.94,37.06,35.47,33.12,32.84,33.44,32.25,29.69,28.72,29.22,28.41,25.53,23.69,24.12,24.0,21.0,18.25,17.91,18.47,17.72,17.34,19.56,23.34,25.66,25.12,25.22,26.09,24.66,20.47,17.25,16.62,16.56,14.84,13.44,14.69,16.38,15.91,14.59,15.22,17.38,18.59,18.12,19.56,22.78,25.44,25.5,25.62,27.66,28.84,27.03,24.69,24.41,24.75,23.28,20.62,20.28,21.22,20.62,18.06,16.66,17.5,18.09,16.97,17.16,20.28,23.53,24.28,24.06,25.44,27.06,26.34,24.31,24.06,25.53,26.06,24.09,22.81,23.38,23.44,21.09,19.22,20.75,23.5,24.22,24.19,25.75,28.12,27.5,24.34,22.19,21.5,19.59,15.41,12.62,12.75,13.56,12.28,11.5,13.47,16.22,16.88,17.0,19.44,23.44,25.81,26.12,27.62,30.44,32.31,31.53,31.31,33.66,35.38,34.22,32.28,31.5,30.88,27.59,23.06,20.5,19.97,18.56,15.91,15.56,18.12,21.25,22.38,24.62,29.31,34.62,36.88,38.22,40.44,41.56,38.75,32.78,27.09,23.09,18.38,12.91,10.12,11.78,14.62,16.03,18.22,22.66,27.28,28.91,29.06,31.19,34.12,34.78,33.91,34.16,35.5,34.78,31.0,27.06,24.78,22.59,18.38,15.38,16.28,19.34,20.44,20.97,22.91,24.91,23.69,20.0,17.0,16.16,14.72,11.69,9.62,10.12,10.81,8.81,6.91,7.41,9.12,8.25,6.75,7.25,9.19,10.0,9.59,10.62,14.06,16.97,17.78,18.91,22.25,25.91,26.19,25.0,24.75,24.09,20.12,14.34,10.38,9.09,7.88,6.38,7.41,12.5,17.69,20.5,22.66,26.28,28.88,27.66,25.62,25.5,27.09,27.22,26.56,27.0,29.19,29.5,27.56,26.47,27.94,29.66,29.38,29.03,30.88,33.44,33.41,33.19,34.78,38.34,39.38,38.19,37.34,37.62,36.31,32.22,28.62,27.44,26.62,23.72,21.53,22.19,24.31,24.09,22.81,22.88,24.31,24.0,21.69,20.78,21.97,22.69,21.44,20.56,22.69,24.72,24.69,24.25,25.31,27.09,25.94,22.97,21.53,21.97,21.12,18.84,17.66,18.78,18.91,16.31,14.12,14.12,14.69,13.09,11.06,11.34,13.62,14.78,15.09,17.34,21.22,23.56,23.12,21.88,22.56,21.91,18.06,13.5,11.56,10.34,7.31,4.16,4.03,6.09,7.47,7.84,9.66,13.53,16.22,16.41,16.59,19.72,22.75,23.16,22.88,24.22,25.41,24.25,21.62,21.06,22.47,22.53,20.41,18.53,18.09,15.88,10.84,6.19,5.16,5.31,3.91,2.66,3.91,5.56,24.94,23.81,23.72,24.19,23.62,22.03,21.41,22.62,23.56,23.06,23.28,24.53,26.09,26.06,26.03,27.44,29.16,29.22,28.31,27.62,27.5,26.5,24.19,22.84,22.94,23.34,22.5,22.53,23.88,25.34,25.16,24.22,24.53,25.41,25.12,24.25,24.66,26.03,26.84,26.5,26.75,27.84:positivity
22.62,23.88,25.75,27.81,26.84,24.47,22.72,22.84,22.25,20.53,20.16,22.41,24.81,25.22,25.34,27.69,30.31,31.09,31.09,32.78,35.38,36.06,35.16,35.06,36.62,36.88,35.16,33.56,34.03,34.81,32.91,31.16,31.16,31.53,30.06,27.34,26.62,27.41,27.16,25.69,25.41,27.31,28.38,27.12,25.75,26.31,26.38,24.5,22.34,22.41,23.47,23.25,21.84,22.28,24.53,25.78,25.78,26.94,30.25,32.69,32.78,33.09,35.75,37.78,37.5,36.06,36.38,37.28,36.53,35.25,35.75,37.31,37.69,36.31,35.28,36.06,35.94,33.59,31.06,31.0,31.66,30.75,29.41,29.94,30.59,29.44,26.44,24.53,24.53,23.78,21.44,20.03,21.31,23.0,23.44,24.38,27.78,31.72,32.94,32.31,32.5,32.19,29.69,25.5,22.94,22.22,20.91,17.84,15.25,14.47,12.94,9.62,6.38,6.22,7.78,8.88,9.53,13.5,18.75,22.56,24.66,27.12,30.56,32.19,31.25,30.56,31.53,32.0,30.31,27.03,25.31,23.53,19.84,15.28,13.25,13.12,12.75,11.34,11.44,13.06,14.25,13.12,12.59,14.25,15.62,14.81,13.16,13.72,15.25,15.78,16.06,18.69,23.25,25.72,25.5,25.31,25.25,23.81,19.53,15.78,15.06,14.75,13.47,12.0,12.41,13.38,12.03,8.88,7.41,8.0,8.34,7.38,7.88,10.16,11.53,10.09,8.53,9.25,10.19,9.72,8.88,10.41,12.75,13.47,12.44,12.78,14.28,14.97,13.78,13.78,15.78,17.06,15.94,14.19,14.03,13.81,11.41,8.09,7.28,7.78,7.22,5.97,6.44,9.16,11.12,11.81,13.97,18.25,21.97,22.59,22.03,22.81,23.12,21.09,18.59,19.12,20.19,20.38,18.66,18.69,20.25,20.62,18.53,17.28,18.0,18.66,17.25,16.25,17.44,19.16,18.91,17.19,17.28,18.44,18.66,17.66,18.38,21.28,23.41,22.75,22.19,23.38,24.22,23.06,22.03,22.75,24.91,25.12,24.0,24.31,25.0,23.78,20.41,18.19,18.12,18.25,16.56,15.81,17.38,19.38,18.78,18.03,19.56,22.12,23.34,23.31,24.97,27.53,28.28,26.62,26.09,26.69,26.5,23.22,19.69,18.0,17.56,15.69,14.19,15.47,17.72,18.22,17.0,16.97,19.19,21.12,21.56,23.19,26.59,28.75,27.41,25.12,24.62,24.47,22.47,20.31,20.53,22.25,22.59,21.62,21.91,23.38,23.12,20.53,18.91,19.19,18.69,16.0,13.5,13.34,14.53,14.12,13.56,15.0,17.31,17.72,16.09,15.66,17.28,18.0,16.78,16.25,17.78,18.88,17.12,15.47,16.56,18.44,18.44,18.0,19.19,21.31,21.91,20.62,20.53,22.16,22.78,20.81,19.41,20.22,20.72,18.56,16.44,16.22,16.84,15.78,13.91,13.66,15.06,15.12,13.53,13.62,15.59,17.44,17.03,17.28,19.56,21.78,21.62,20.75,21.66,22.97,22.16,20.0,19.19,19.97,19.56,18.03,18.41,20.75,22.69,21.94,20.88,21.44,21.94,19.81,17.66,17.75,19.0,18.22,16.59,16.69,18.31,19.19,18.34,18.91,21.44,23.88,23.53,23.47,25.06,25.91,24.47,22.31,22.41,23.5,22.97,21.09,20.47,21.16,20.62,18.19,17.12,18.47,19.53,18.12,17.34,18.66,20.56,20.25,19.5,20.88,23.44,24.19,23.62,23.88,25.38,25.75,23.97,23.31,24.91,26.66,26.31,25.81,27.38,29.53,29.12,27.88,28.16,29.16,28.16,25.38,23.66,23.34,22.75,20.0,18.25,18.97,19.81,17.91,16.0,16.38,17.38,16.34,14.91,15.59,17.69,18.84,18.75,19.78,22.59,24.34,23.97,23.47,24.78,25.97,24.25,22.0,21.97,22.75,21.78,20.38,20.66,22.47,22.59,20.84,19.72,20.41,20.06,17.12,14.56,14.84,15.81,15.28,15.66,18.5,22.44,24.12,24.38,25.75,27.94,28.69,27.0,25.72,26.09,25.62,22.69,20.22,20.16,20.25,18.28,15.53,14.62,15.19,13.84,11.47,11.41,13.03,13.88,13.06,13.16,15.88,17.91,17.16,16.56,17.78,19.66,18.88,18.25,19.31,21.94,22.31,21.41,22.12,24.19,24.91,23.16,21.72,22.66,23.16,21.56,20.38,21.41,23.44,22.91,22.34,23.41,26.31,26.88,26.03,26.28,27.69,27.69,24.97,23.03,22.72,22.19,19.34,16.88,17.16,18.47,18.06,17.72,18.94,21.88,23.56,24.12,25.75,29.0,30.75,29.53,27.84,27.62,26.69,23.12,19.56,18.59,18.75,16.94,14.88,14.31,15.09,14.56,13.06,13.34,15.75,17.44,16.94,16.66,18.56,20.69,20.5,19.72,21.03,22.28,21.16,18.38,17.25,17.5,16.09,13.12,11.38,11.91,12.19,10.59,10.0,12.22,14.66,15.22,15.03,17.0,19.5,19.38,17.59,17.12,17.69,16.25,13.53,12.34,13.16,13.69,12.34,11.22,11.94,13.0,11.84,10.34,10.84,12.69,13.44,13.09,14.56,17.16,18.16,16.56,15.59,16.72,18.19,17.78,17.72,19.75,21.78,20.59,18.34,18.28,18.72,17.38,15.06,13.88,14.78,14.84,13.53,13.31,16.06,18.75,19.16,20.03,22.97,25.78,26.19,25.66,26.31,28.22,27.84,26.56,26.38,28.03,28.25,26.34,24.72,25.47,26.0,24.88,23.88,25.5,27.69,27.22,25.47,24.69,24.62,23.28,21.28,21.03,23.69,25.66,24.84,23.97,24.56,24.97,23.03,21.62,22.88,25.44,26.19,25.81,26.75,28.47,28.19,25.97,24.47,24.97,24.44,21.62,19.5,20.28,21.53,20.81,20.56,22.72,25.5,25.88,24.81,25.41,27.44,28.31,27.25,26.88,28.03,27.59,24.81,21.88,21.56,21.5,19.09,16.94,17.59,20.03,20.78,20.53,22.12,24.12,24.16,22.12,20.69,21.44,21.59,19.88,18.03,18.91,20.0,19.03,18.09,19.38,22.28,23.12,23.16,24.56,27.47,28.19,26.56,25.19,25.91,25.59,23.31,21.97,23.12,25.12,24.72,23.75,24.38,25.81,25.56,24.31,24.44,26.12,25.91,23.12,20.91,20.47,20.12,18.03,16.47,17.81,19.72,19.19,17.56,17.62,18.44,17.31,14.94,14.41,16.31,17.34,16.88,17.38,19.88,21.25,20.56,19.47,20.56,22.47,22.22,21.41,22.19,24.06,24.09,23.25,23.69,25.84,26.78,25.44,24.0,24.41,24.19,21.84,19.28,19.28,20.22,19.5,18.0,18.47,20.31,20.69,20.19,21.22,24.75,27.44,27.78,27.72,29.38,29.91,27.88,25.31,25.19,25.66,24.22,21.59,20.81,21.22,20.72,18.97,18.41,20.41,21.72,20.72,20.28,21.88,22.78,21.5,19.69,19.97,20.66,19.56,16.75,15.25,14.78,13.06,10.06,8.69,10.03,11.41,10.34,9.0,9.5,9.66,7.75,5.19,5.25,6.62,6.31,4.84,5.0,6.69,7.75,7.34,7.59,10.19,11.47,10.28,8.78,9.72,11.62,11.78,11.66,13.25,15.47,15.59,13.91,13.81,15.91,16.84,16.41,17.22,20.47,23.31,23.19,22.84,24.03,24.69,22.44,19.19,18.09,18.22,17.12,14.75,14.22,15.28,15.12,12.84,10.72,11.0,10.78,8.88,7.5,9.41,12.75,14.88,16.19,18.78,21.47,21.91,20.28,20.03,21.81,22.56,21.69,20.72,22.09,22.34,20.56,17.88,17.09,16.03,12.12,7.28,4.56,3.56,1.88,0.34,1.06,5.56,10.03,13.16,16.94,22.34,26.56,26.78,25.34,24.75,23.66,20.38,16.44,14.72,15.12,14.78,13.62,13.75,15.88,17.66,16.91,16.91,18.78,20.53,20.03,18.25,18.69,19.34,18.12,16.12,17.0,19.84,21.91,23.25,25.56,28.94,30.47,28.78,26.34,25.66,25.16,23.09,21.0,21.38,22.56,21.88,20.0,19.16,19.09,17.72,14.53,13.16,14.06,14.88,14.0,13.03,13.75,13.81,11.53,8.56,7.88,8.56,8.44,8.03,9.84,13.5,16.47,17.78,20.12,25.03,29.47,31.31,32.66,35.91,38.69,38.84,37.94,38.84,39.62,38.56,35.75,34.09,33.59,31.78,28.09,25.19,24.25,23.28,20.31,17.19,16.44,15.94,13.94,11.72,12.28,14.31,15.19,15.06,16.28,19.06,21.09,20.78,20.81,22.66,23.62,22.53,21.22,22.16,23.69,23.06,21.81,22.38,23.41,23.03,21.03,19.88,20.69,20.91,19.28,19.0,21.19,22.81,21.97,20.5,20.31,20.31,18.75,17.22,18.41,21.34,23.56,23.69,24.56,26.25,26.78,24.22,22.41,22.81,23.44,22.06,20.94,22.41,24.12,23.5,21.62,21.47,22.0,21.41,18.97,17.97,18.34,17.78,15.03,12.88,13.28,14.34,13.59,13.34,16.0,19.06,20.28,19.72,20.62,21.94,21.78,19.53,18.69,20.06,20.25,18.47,17.03,17.53,18.53,17.25,15.69,16.78,18.59,18.59,17.31,17.88,19.72,20.28,19.53,20.25,22.97,24.56,23.47,22.03,22.22,22.28,20.0,17.44,16.97,17.03,15.62,13.16,12.94,14.28,14.97,13.81,13.84,15.78,16.97,15.94,15.44,16.88,18.5,18.0,17.66,19.56,21.69,22.16,21.44,21.91,23.97,24.88,23.91,23.75,24.84,25.0,22.78,20.62,20.56,21.03,19.78,18.19,18.5,19.91,19.66,17.84,17.44,18.22,18.12,16.59,16.06,18.41,20.66,21.47,22.38,25.28,28.0,28.34,27.34:22.84,22.25,20.53,20.16,22.41,24.81,25.22,25.34,27.69,30.31,31.09,31.09,32.78,35.38,36.06,35.16,35.06,36.62,36.88,35.16,33.56,34.03,34.81,32.91,31.16,31.16,31.53,30.06,27.34,26.62,27.41,27.16,25.69,25.41,27.31,28.38,27.12,25.75,26.31,26.38,24.5,22.34,22.41,23.47,23.25,21.84,22.28,24.53,25.78,25.78,26.94,30.25,32.69,32.78,33.09,35.75,37.78,37.5,36.06,36.38,37.28,36.53,35.25,35.75,37.31,37.69,36.31,35.28,36.06,35.94,33.59,31.06,31.0,31.66,30.75,29.41,29.94,30.59,29.44,26.44,24.53,24.53,23.78,21.44,20.03,21.31,23.0,23.44,24.38,27.78,31.72,32.94,32.31,32.5,32.19,29.69,25.5,22.94,22.22,20.91,17.84,15.25,14.47,12.94,9.62,6.38,6.22,7.78,8.88,9.53,13.5,18.75,22.56,24.66,27.12,30.56,32.19,31.25,30.56,31.53,32.0,30.31,27.03,25.31,23.53,19.84,15.28,13.25,13.12,12.75,11.34,11.44,13.06,14.25,13.12,12.59,14.25,15.62,14.81,13.16,13.72,15.25,15.78,16.06,18.69,23.25,25.72,25.5,25.31,25.25,23.81,19.53,15.78,15.06,14.75,13.47,12.0,12.41,13.38,12.03,8.88,7.41,8.0,8.34,7.38,7.88,10.16,11.53,10.09,8.53,9.25,10.19,9.72,8.88,10.41,12.75,13.47,12.44,12.78,14.28,14.97,13.78,13.78,15.78,17.06,15.94,14.19,14.03,13.81,11.41,8.09,7.28,7.78,7.22,5.97,6.44,9.16,11.12,11.81,13.97,18.25,21.97,22.59,22.03,22.81,23.12,21.09,18.59,19.12,20.19,20.38,18.66,18.69,20.25,20.62,18.53,17.28,18.0,18.66,17.25,16.25,17.44,19.16,18.91,17.19,17.28,18.44,18.66,17.66,18.38,21.28,23.41,22.75,22.19,23.38,24.22,23.06,22.03,22.75,24.91,25.12,24.0,24.31,25.0,23.78,20.41,18.19,18.12,18.25,16.56,15.81,17.38,19.38,18.78,18.03,19.56,22.12,23.34,23.31,24.97,27.53,28.28,26.62,26.09,26.69,26.5,23.22,19.69,18.0,17.56,15.69,14.19,15.47,17.72,18.22,17.0,16.97,19.19,21.12,21.56,23.19,26.59,28.75,27.41,25.12,24.62,24.47,22.47,20.31,20.53,22.25,22.59,21.62,21.91,23.38,23.12,20.53,18.91,19.19,18.69,16.0,13.5,13.34,14.53,14.12,13.56,15.0,17.31,17.72,16.09,15.66,17.28,18.0,16.78,16.25,17.78,18.88,17.12,15.47,16.56,18.44,18.44,18.0,19.19,21.31,21.91,20.62,20.53,22.16,22.78,20.81,19.41,20.22,20.72,18.56,16.44,16.22,16.84,15.78,13.91,13.66,15.06,15.12,13.53,13.62,15.59,17.44,17.03,17.28,19.56,21.78,21.62,20.75,21.66,22.97,22.16,20.0,19.19,19.97,19.56,18.03,18.41,20.75,22.69,21.94,20.88,21.44,21.94,19.81,17.66,17.75,19.0,18.22,16.59,16.69,18.31,19.19,18.34,18.91,21.44,23.88,23.53,23.47,25.06,25.91,24.47,22.31,22.41,23.5,22.97,21.09,20.47,21.16,20.62,18.19,17.12,18.47,19.53,18.12,17.34,18.66,20.56,20.25,19.5,20.88,23.44,24.19,23.62,23.88,25.38,25.75,23.97,23.31,24.91,26.66,26.31,25.81,27.38,29.53,29.12,27.88,28.16,29.16,28.16,25.38,23.66,23.34,22.75,20.0,18.25,18.97,19.81,17.91,16.0,16.38,17.38,16.34,14.91,15.59,17.69,18.84,18.75,19.78,22.59,24.34,23.97,23.47,24.78,25.97,24.25,22.0,21.97,22.75,21.78,20.38,20.66,22.47,22.59,20.84,19.72,20.41,20.06,17.12,14.56,14.84,15.81,15.28,15.66,18.5,22.44,24.12,24.38,25.75,27.94,28.69,27.0,25.72,26.09,25.62,22.69,20.22,20.16,20.25,18.28,15.53,14.62,15.19,13.84,11.47,11.41,13.03,13.88,13.06,13.16,15.88,17.91,17.16,16.56,17.78,19.66,18.88,18.25,19.31,21.94,22.31,21.41,22.12,24.19,24.91,23.16,21.72,22.66,23.16,21.56,20.38,21.41,23.44,22.91,22.34,23.41,26.31,26.88,26.03,26.28,27.69,27.69,24.97,23.03,22.72,22.19,19.34,16.88,17.16,18.47,18.06,17.72,18.94,21.88,23.56,24.12,25.75,29.0,30.75,29.53,27.84,27.62,26.69,23.12,19.56,18.59,18.75,16.94,14.88,14.31,15.09,14.56,13.06,13.34,15.75,17.44,16.94,16.66,18.56,20.69,20.5,19.72,21.03,22.28,21.16,18.38,17.25,17.5,16.09,13.12,11.38,11.91,12.19,10.59,10.0,12.22,14.66,15.22,15.03,17.0,19.5,19.38,17.59,17.12,17.69,16.25,13.53,12.34,13.16,13.69,12.34,11.22,11.94,13.0,11.84,10.34,10.84,12.69,13.44,13.09,14.56,17.16,18.16,16.56,15.59,16.72,18.19,17.78,17.72,19.75,21.78,20.59,18.34,18.28,18.72,17.38,15.06,13.88,14.78,14.84,13.53,13.31,16.06,18.75,19.16,20.03,22.97,25.78,26.19,25.66,26.31,28.22,27.84,26.56,26.38,28.03,28.25,26.34,24.72,25.47,26.0,24.88,23.88,25.5,27.69,27.22,25.47,24.69,24.62,23.28,21.28,21.03,23.69,25.66,24.84,23.97,24.56,24.97,23.03,21.62,22.88,25.44,26.19,25.81,26.75,28.47,28.19,25.97,24.47,24.97,24.44,21.62,19.5,20.28,21.53,20.81,20.56,22.72,25.5,25.88,24.81,25.41,27.44,28.31,27.25,26.88,28.03,27.59,24.81,21.88,21.56,21.5,19.09,16.94,17.59,20.03,20.78,20.53,22.12,24.12,24.16,22.12,20.69,21.44,21.59,19.88,18.03,18.91,20.0,19.03,18.09,19.38,22.28,23.12,23.16,24.56,27.47,28.19,26.56,25.19,25.91,25.59,23.31,21.97,23.12,25.12,24.72,23.75,24.38,25.81,25.56,24.31,24.44,26.12,25.91,23.12,20.91,20.47,20.12,18.03,16.47,17.81,19.72,19.19,17.56,17.62,18.44,17.31,14.94,14.41,16.31,17.34,16.88,17.38,19.88,21.25,20.56,19.47,20.56,22.47,22.22,21.41,22.19,24.06,24.09,23.25,23.69,25.84,26.78,25.44,24.0,24.41,24.19,21.84,19.28,19.28,20.22,19.5,18.0,18.47,20.31,20.69,20.19,21.22,24.75,27.44,27.78,27.72,29.38,29.91,27.88,25.31,25.19,25.66,24.22,21.59,20.81,21.22,20.72,18.97,18.41,20.41,21.72,20.72,20.28,21.88,22.78,21.5,19.69,19.97,20.66,19.56,16.75,15.25,14.78,13.06,10.06,8.69,10.03,11.41,10.34,9.0,9.5,9.66,7.75,5.19,5.25,6.62,6.31,4.84,5.0,6.69,7.75,7.34,7.59,10.19,11.47,10.28,8.78,9.72,11.62,11.78,11.66,13.25,15.47,15.59,13.91,13.81,15.91,16.84,16.41,17.22,20.47,23.31,23.19,22.84,24.03,24.69,22.44,19.19,18.09,18.22,17.12,14.75,14.22,15.28,15.12,12.84,10.72,11.0,10.78,8.88,7.5,9.41,12.75,14.88,16.19,18.78,21.47,21.91,20.28,20.03,21.81,22.56,21.69,20.72,22.09,22.34,20.56,17.88,17.09,16.03,12.12,7.28,4.56,3.56,1.88,0.34,1.06,5.56,10.03,13.16,16.94,22.34,26.56,26.78,25.34,24.75,23.66,20.38,16.44,14.72,15.12,14.78,13.62,13.75,15.88,17.66,16.91,16.91,18.78,20.53,20.03,18.25,18.69,19.34,18.12,16.12,17.0,19.84,21.91,23.25,25.56,28.94,30.47,28.78,26.34,25.66,25.16,23.09,21.0,21.38,22.56,21.88,20.0,19.16,19.09,17.72,14.53,13.16,14.06,14.88,14.0,13.03,13.75,13.81,11.53,8.56,7.88,8.56,8.44,8.03,9.84,13.5,16.47,17.78,20.12,25.03,29.47,31.31,32.66,35.91,38.69,38.84,37.94,38.84,39.62,38.56,35.75,34.09,33.59,31.78,28.09,25.19,24.25,23.28,20.31,17.19,16.44,15.94,13.94,11.72,12.28,14.31,15.19,15.06,16.28,19.06,21.09,20.78,20.81,22.66,23.62,22.53,21.22,22.16,23.69,23.06,21.81,22.38,23.41,23.03,21.03,19.88,20.69,20.91,19.28,19.0,21.19,22.81,21.97,20.5,20.31,20.31,18.75,17.22,18.41,21.34,23.56,23.69,24.56,26.25,26.78,24.22,22.41,22.81,23.44,22.06,20.94,22.41,24.12,23.5,21.62,21.47,22.0,21.41,18.97,17.97,18.34,17.78,15.03,12.88,13.28,14.34,13.59,13.34,16.0,19.06,20.28,19.72,20.62,21.94,21.78,19.53,18.69,20.06,20.25,18.47,17.03,17.53,18.53,17.25,15.69,16.78,18.59,18.59,17.31,17.88,19.72,20.28,19.53,20.25,22.97,24.56,23.47,22.03,22.22,22.28,20.0,17.44,16.97,17.03,15.62,13.16,12.94,14.28,14.97,13.81,13.84,15.78,16.97,15.94,15.44,16.88,18.5,18.0,17.66,19.56,21.69,22.16,21.44,21.91,23.97,24.88,23.91,23.75,24.84,25.0,22.78,20.62,20.56,21.03,19.78,18.19,18.5,19.91,19.66,17.84,17.44,18.22,18.12,16.59,16.06,18.41,20.66,21.47,22.38,25.28,28.0,28.34,27.34,20.88,21.97,23.22,23.75,22.12,19.09,16.38:25.34,27.69,30.31,31.09,31.09,32.78,35.38,36.06,35.16,35.06,36.62,36.88,35.16,33.56,34.03,34.81,32.91,31.16,31.16,31.53,30.06,27.34,26.62,27.41,27.16,25.69,25.41,27.31,28.38,27.12,25.75,26.31,26.38,24.5,22.34,22.41,23.47,23.25,21.84,22.28,24.53,25.78,25.78,26.94,30.25,32.69,32.78,33.09,35.75,37.78,37.5,36.06,36.38,37.28,36.53,35.25,35.75,37.31,37.69,36.31,35.28,36.06,35.94,33.59,31.06,31.0,31.66,30.75,29.41,29.94,30.59,29.44,26.44,24.53,24.53,23.78,21.44,20.03,21.31,23.0,23.44,24.38,27.78,31.72,32.94,32.31,32.5,32.19,29.69,25.5,22.94,22.22,20.91,17.84,15.25,14.47,12.94,9.62,6.38,6.22,7.78,8.88,9.53,13.5,18.75,22.56,24.66,27.12,30.56,32.19,31.25,30.56,31.53,32.0,30.31,27.03,25.31,23.53,19.84,15.28,13.25,13.12,12.75,11.34,11.44,13.06,14.25,13.12,12.59,14.25,15.62,14.81,13.16,13.72,15.25,15.78,16.06,18.69,23.25,25.72,25.5,25.31,25.25,23.81,19.53,15.78,15.06,14.75,13.47,12.0,12.41,13.38,12.03,8.88,7.41,8.0,8.34,7.38,7.88,10.16,11.53,10.09,8.53,9.25,10.19,9.72,8.88,10.41,12.75,13.47,12.44,12.78,14.28,14.97,13.78,13.78,15.78,17.06,15.94,14.19,14.03,13.81,11.41,8.09,7.28,7.78,7.22,5.97,6.44,9.16,11.12,11.81,13.97,18.25,21.97,22.59,22.03,22.81,23.12,21.09,18.59,19.12,20.19,20.38,18.66,18.69,20.25,20.62,18.53,17.28,18.0,18.66,17.25,16.25,17.44,19.16,18.91,17.19,17.28,18.44,18.66,17.66,18.38,21.28,23.41,22.75,22.19,23.38,24.22,23.06,22.03,22.75,24.91,25.12,24.0,24.31,25.0,23.78,20.41,18.19,18.12,18.25,16.56,15.81,17.38,19.38,18.78,18.03,19.56,22.12,23.34,23.31,24.97,27.53,28.28,26.62,26.09,26.69,26.5,23.22,19.69,18.0,17.56,15.69,14.19,15.47,17.72,18.22,17.0,16.97,19.19,21.12,21.56,23.19,26.59,28.75,27.41,25.12,24.62,24.47,22.47,20.31,20.53,22.25,22.59,21.62,21.91,23.38,23.12,20.53,18.91,19.19,18.69,16.0,13.5,13.34,14.53,14.12,13.56,15.0,17.31,17.72,16.09,15.66,17.28,18.0,16.78,16.25,17.78,18.88,17.12,15.47,16.56,18.44,18.44,18.0,19.19,21.31,21.91,20.62,20.53,22.16,22.78,20.81,19.41,20.22,20.72,18.56,16.44,16.22,16.84,15.78,13.91,13.66,15.06,15.12,13.53,13.62,15.59,17.44,17.03,17.28,19.56,21.78,21.62,20.75,21.66,22.97,22.16,20.0,19.19,19.97,19.56,18.03,18.41,20.75,22.69,21.94,20.88,21.44,21.94,19.81,17.66,17.75,19.0,18.22,16.59,16.69,18.31,19.19,18.34,18.91,21.44,23.88,23.53,23.47,25.06,25.91,24.47,22.31,22.41,23.5,22.97,21.09,20.47,21.16,20.62,18.19,17.12,18.47,19.53,18.12,17.34,18.66,20.56,20.25,19.5,20.88,23.44,24.19,23.62,23.88,25.38,25.75,23.97,23.31,24.91,26.66,26.31,25.81,27.38,29.53,29.12,27.88,28.16,29.16,28.16,25.38,23.66,23.34,22.75,20.0,18.25,18.97,19.81,17.91,16.0,16.38,17.38,16.34,14.91,15.59,17.69,18.84,18.75,19.78,22.59,24.34,23.97,23.47,24.78,25.97,24.25,22.0,21.97,22.75,21.78,20.38,20.66,22.47,22.59,20.84,19.72,20.41,20.06,17.12,14.56,14.84,15.81,15.28,15.66,18.5,22.44,24.12,24.38,25.75,27.94,28.69,27.0,25.72,26.09,25.62,22.69,20.22,20.16,20.25,18.28,15.53,14.62,15.19,13.84,11.47,11.41,13.03,13.88,13.06,13.16,15.88,17.91,17.16,16.56,17.78,19.66,18.88,18.25,19.31,21.94,22.31,21.41,22.12,24.19,24.91,23.16,21.72,22.66,23.16,21.56,20.38,21.41,23.44,22.91,22.34,23.41,26.31,26.88,26.03,26.28,27.69,27.69,24.97,23.03,22.72,22.19,19.34,16.88,17.16,18.47,18.06,17.72,18.94,21.88,23.56,24.12,25.75,29.0,30.75,29.53,27.84,27.62,26.69,23.12,19.56,18.59,18.75,16.94,14.88,14.31,15.09,14.56,13.06,13.34,15.75,17.44,16.94,16.66,18.56,20.69,20.5,19.72,21.03,22.28,21.16,18.38,17.25,17.5,16.09,13.12,11.38,11.91,12.19,10.59,10.0,12.22,14.66,15.22,15.03,17.0,19.5,19.38,17.59,17.12,17.69,16.25,13.53,12.34,13.16,13.69,12.34,11.22,11.94,13.0,11.84,10.34,10.84,12.69,13.44,13.09,14.56,17.16,18.16,16.56,15.59,16.72,18.19,17.78,17.72,19.75,21.78,20.59,18.34,18.28,18.72,17.38,15.06,13.88,14.78,14.84,13.53,13.31,16.06,18.75,19.16,20.03,22.97,25.78,26.19,25.66,26.31,28.22,27.84,26.56,26.38,28.03,28.25,26.34,24.72,25.47,26.0,24.88,23.88,25.5,27.69,27.22,25.47,24.69,24.62,23.28,21.28,21.03,23.69,25.66,24.84,23.97,24.56,24.97,23.03,21.62,22.88,25.44,26.19,25.81,26.75,28.47,28.19,25.97,24.47,24.97,24.44,21.62,19.5,20.28,21.53,20.81,20.56,22.72,25.5,25.88,24.81,25.41,27.44,28.31,27.25,26.88,28.03,27.59,24.81,21.88,21.56,21.5,19.09,16.94,17.59,20.03,20.78,20.53,22.12,24.12,24.16,22.12,20.69,21.44,21.59,19.88,18.03,18.91,20.0,19.03,18.09,19.38,22.28,23.12,23.16,24.56,27.47,28.19,26.56,25.19,25.91,25.59,23.31,21.97,23.12,25.12,24.72,23.75,24.38,25.81,25.56,24.31,24.44,26.12,25.91,23.12,20.91,20.47,20.12,18.03,16.47,17.81,19.72,19.19,17.56,17.62,18.44,17.31,14.94,14.41,16.31,17.34,16.88,17.38,19.88,21.25,20.56,19.47,20.56,22.47,22.22,21.41,22.19,24.06,24.09,23.25,23.69,25.84,26.78,25.44,24.0,24.41,24.19,21.84,19.28,19.28,20.22,19.5,18.0,18.47,20.31,20.69,20.19,21.22,24.75,27.44,27.78,27.72,29.38,29.91,27.88,25.31,25.19,25.66,24.22,21.59,20.81,21.22,20.72,18.97,18.41,20.41,21.72,20.72,20.28,21.88,22.78,21.5,19.69,19.97,20.66,19.56,16.75,15.25,14.78,13.06,10.06,8.69,10.03,11.41,10.34,9.0,9.5,9.66,7.75,5.19,5.25,6.62,6.31,4.84,5.0,6.69,7.75,7.34,7.59,10.19,11.47,10.28,8.78,9.72,11.62,11.78,11.66,13.25,15.47,15.59,13.91,13.81,15.91,16.84,16.41,17.22,20.47,23.31,23.19,22.84,24.03,24.69,22.44,19.19,18.09,18.22,17.12,14.75,14.22,15.28,15.12,12.84,10.72,11.0,10.78,8.88,7.5,9.41,12.75,14.88,16.19,18.78,21.47,21.91,20.28,20.03,21.81,22.56,21.69,20.72,22.09,22.34,20.56,17.88,17.09,16.03,12.12,7.28,4.56,3.56,1.88,0.34,1.06,5.56,10.03,13.16,16.94,22.34,26.56,26.78,25.34,24.75,23.66,20.38,16.44,14.72,15.12,14.78,13.62,13.75,15.88,17.66,16.91,16.91,18.78,20.53,20.03,18.25,18.69,19.34,18.12,16.12,17.0,19.84,21.91,23.25,25.56,28.94,30.47,28.78,26.34,25.66,25.16,23.09,21.0,21.38,22.56,21.88,20.0,19.16,19.09,17.72,14.53,13.16,14.06,14.88,14.0,13.03,13.75,13.81,11.53,8.56,7.88,8.56,8.44,8.03,9.84,13.5,16.47,17.78,20.12,25.03,29.47,31.31,32.66,35.91,38.69,38.84,37.94,38.84,39.62,38.56,35.75,34.09,33.59,31.78,28.09,25.19,24.25,23.28,20.31,17.19,16.44,15.94,13.94,11.72,12.28,14.31,15.19,15.06,16.28,19.06,21.09,20.78,20.81,22.66,23.62,22.53,21.22,22.16,23.69,23.06,21.81,22.38,23.41,23.03,21.03,19.88,20.69,20.91,19.28,19.0,21.19,22.81,21.97,20.5,20.31,20.31,18.75,17.22,18.41,21.34,23.56,23.69,24.56,26.25,26.78,24.22,22.41,22.81,23.44,22.06,20.94,22.41,24.12,23.5,21.62,21.47,22.0,21.41,18.97,17.97,18.34,17.78,15.03,12.88,13.28,14.34,13.59,13.34,16.0,19.06,20.28,19.72,20.62,21.94,21.78,19.53,18.69,20.06,20.25,18.47,17.03,17.53,18.53,17.25,15.69,16.78,18.59,18.59,17.31,17.88,19.72,20.28,19.53,20.25,22.97,24.56,23.47,22.03,22.22,22.28,20.0,17.44,16.97,17.03,15.62,13.16,12.94,14.28,14.97,13.81,13.84,15.78,16.97,15.94,15.44,16.88,18.5,18.0,17.66,19.56,21.69,22.16,21.44,21.91,23.97,24.88,23.91,23.75,24.84,25.0,22.78,20.62,20.56,21.03,19.78,18.19,18.5,19.91,19.66,17.84,17.44,18.22,18.12,16.59,16.06,18.41,20.66,21.47,22.38,25.28,28.0,28.34,27.34,20.88,21.97,23.22,23.75,22.12,19.09,16.38,14.75,12.5,9.91,8.88,10.12,12.16,14.19:36.06,35.16,35.06,36.62,36.88,35.16,33.56,34.03,34.81,32.91,31.16,31.16,31.53,30.06,27.34,26.62,27.41,27.16,25.69,25.41,27.31,28.38,27.12,25.75,26.31,26.38,24.5,22.34,22.41,23.47,23.25,21.84,22.28,24.53,25.78,25.78,26.94,30.25,32.69,32.78,33.09,35.75,37.78,37.5,36.06,36.38,37.28,36.53,35.25,35.75,37.31,37.69,36.31,35.28,36.06,35.94,33.59,31.06,31.0,31.66,30.75,29.41,29.94,30.59,29.44,26.44,24.53,24.53,23.78,21.44,20.03,21.31,23.0,23.44,24.38,27.78,31.72,32.94,32.31,32.5,32.19,29.69,25.5,22.94,22.22,20.91,17.84,15.25,14.47,12.94,9.62,6.38,6.22,7.78,8.88,9.53,13.5,18.75,22.56,24.66,27.12,30.56,32.19,31.25,30.56,31.53,32.0,30.31,27.03,25.31,23.53,19.84,15.28,13.25,13.12,12.75,11.34,11.44,13.06,14.25,13.12,12.59,14.25,15.62,14.81,13.16,13.72,15.25,15.78,16.06,18.69,23.25,25.72,25.5,25.31,25.25,23.81,19.53,15.78,15.06,14.75,13.47,12.0,12.41,13.38,12.03,8.88,7.41,8.0,8.34,7.38,7.88,10.16,11.53,10.09,8.53,9.25,10.19,9.72,8.88,10.41,12.75,13.47,12.44,12.78,14.28,14.97,13.78,13.78,15.78,17.06,15.94,14.19,14.03,13.81,11.41,8.09,7.28,7.78,7.22,5.97,6.44,9.16,11.12,11.81,13.97,18.25,21.97,22.59,22.03,22.81,23.12,21.09,18.59,19.12,20.19,20.38,18.66,18.69,20.25,20.62,18.53,17.28,18.0,18.66,17.25,16.25,17.44,19.16,18.91,17.19,17.28,18.44,18.66,17.66,18.38,21.28,23.41,22.75,22.19,23.38,24.22,23.06,22.03,22.75,24.91,25.12,24.0,24.31,25.0,23.78,20.41,18.19,18.12,18.25,16.56,15.81,17.38,19.38,18.78,18.03,19.56,22.12,23.34,23.31,24.97,27.53,28.28,26.62,26.09,26.69,26.5,23.22,19.69,18.0,17.56,15.69,14.19,15.47,17.72,18.22,17.0,16.97,19.19,21.12,21.56,23.19,26.59,28.75,27.41,25.12,24.62,24.47,22.47,20.31,20.53,22.25,22.59,21.62,21.91,23.38,23.12,20.53,18.91,19.19,18.69,16.0,13.5,13.34,14.53,14.12,13.56,15.0,17.31,17.72,16.09,15.66,17.28,18.0,16.78,16.25,17.78,18.88,17.12,15.47,16.56,18.44,18.44,18.0,19.19,21.31,21.91,20.62,20.53,22.16,22.78,20.81,19.41,20.22,20.72,18.56,16.44,16.22,16.84,15.78,13.91,13.66,15.06,15.12,13.53,13.62,15.59,17.44,17.03,17.28,19.56,21.78,21.62,20.75,21.66,22.97,22.16,20.0,19.19,19.97,19.56,18.03,18.41,20.75,22.69,21.94,20.88,21.44,21.94,19.81,17.66,17.75,19.0,18.22,16.59,16.69,18.31,19.19,18.34,18.91,21.44,23.88,23.53,23.47,25.06,25.91,24.47,22.31,22.41,23.5,22.97,21.09,20.47,21.16,20.62,18.19,17.12,18.47,19.53,18.12,17.34,18.66,20.56,20.25,19.5,20.88,23.44,24.19,23.62,23.88,25.38,25.75,23.97,23.31,24.91,26.66,26.31,25.81,27.38,29.53,29.12,27.88,28.16,29.16,28.16,25.38,23.66,23.34,22.75,20.0,18.25,18.97,19.81,17.91,16.0,16.38,17.38,16.34,14.91,15.59,17.69,18.84,18.75,19.78,22.59,24.34,23.97,23.47,24.78,25.97,24.25,22.0,21.97,22.75,21.78,20.38,20.66,22.47,22.59,20.84,19.72,20.41,20.06,17.12,14.56,14.84,15.81,15.28,15.66,18.5,22.44,24.12,24.38,25.75,27.94,28.69,27.0,25.72,26.09,25.62,22.69,20.22,20.16,20.25,18.28,15.53,14.62,15.19,13.84,11.47,11.41,13.03,13.88,13.06,13.16,15.88,17.91,17.16,16.56,17.78,19.66,18.88,18.25,19.31,21.94,22.31,21.41,22.12,24.19,24.91,23.16,21.72,22.66,23.16,21.56,20.38,21.41,23.44,22.91,22.34,23.41,26.31,26.88,26.03,26.28,27.69,27.69,24.97,23.03,22.72,22.19,19.34,16.88,17.16,18.47,18.06,17.72,18.94,21.88,23.56,24.12,25.75,29.0,30.75,29.53,27.84,27.62,26.69,23.12,19.56,18.59,18.75,16.94,14.88,14.31,15.09,14.56,13.06,13.34,15.75,17.44,16.94,16.66,18.56,20.69,20.5,19.72,21.03,22.28,21.16,18.38,17.25,17.5,16.09,13.12,11.38,11.91,12.19,10.59,10.0,12.22,14.66,15.22,15.03,17.0,19.5,19.38,17.59,17.12,17.69,16.25,13.53,12.34,13.16,13.69,12.34,11.22,11.94,13.0,11.84,10.34,10.84,12.69,13.44,13.09,14.56,17.16,18.16,16.56,15.59,16.72,18.19,17.78,17.72,19.75,21.78,20.59,18.34,18.28,18.72,17.38,15.06,13.88,14.78,14.84,13.53,13.31,16.06,18.75,19.16,20.03,22.97,25.78,26.19,25.66,26.31,28.22,27.84,26.56,26.38,28.03,28.25,26.34,24.72,25.47,26.0,24.88,23.88,25.5,27.69,27.22,25.47,24.69,24.62,23.28,21.28,21.03,23.69,25.66,24.84,23.97,24.56,24.97,23.03,21.62,22.88,25.44,26.19,25.81,26.75,28.47,28.19,25.97,24.47,24.97,24.44,21.62,19.5,20.28,21.53,20.81,20.56,22.72,25.5,25.88,24.81,25.41,27.44,28.31,27.25,26.88,28.03,27.59,24.81,21.88,21.56,21.5,19.09,16.94,17.59,20.03,20.78,20.53,22.12,24.12,24.16,22.12,20.69,21.44,21.59,19.88,18.03,18.91,20.0,19.03,18.09,19.38,22.28,23.12,23.16,24.56,27.47,28.19,26.56,25.19,25.91,25.59,23.31,21.97,23.12,25.12,24.72,23.75,24.38,25.81,25.56,24.31,24.44,26.12,25.91,23.12,20.91,20.47,20.12,18.03,16.47,17.81,19.72,19.19,17.56,17.62,18.44,17.31,14.94,14.41,16.31,17.34,16.88,17.38,19.88,21.25,20.56,19.47,20.56,22.47,22.22,21.41,22.19,24.06,24.09,23.25,23.69,25.84,26.78,25.44,24.0,24.41,24.19,21.84,19.28,19.28,20.22,19.5,18.0,18.47,20.31,20.69,20.19,21.22,24.75,27.44,27.78,27.72,29.38,29.91,27.88,25.31,25.19,25.66,24.22,21.59,20.81,21.22,20.72,18.97,18.41,20.41,21.72,20.72,20.28,21.88,22.78,21.5,19.69,19.97,20.66,19.56,16.75,15.25,14.78,13.06,10.06,8.69,10.03,11.41,10.34,9.0,9.5,9.66,7.75,5.19,5.25,6.62,6.31,4.84,5.0,6.69,7.75,7.34,7.59,10.19,11.47,10.28,8.78,9.72,11.62,11.78,11.66,13.25,15.47,15.59,13.91,13.81,15.91,16.84,16.41,17.22,20.47,23.31,23.19,22.84,24.03,24.69,22.44,19.19,18.09,18.22,17.12,14.75,14.22,15.28,15.12,12.84,10.72,11.0,10.78,8.88,7.5,9.41,12.75,14.88,16.19,18.78,21.47,21.91,20.28,20.03,21.81,22.56,21.69,20.72,22.09,22.34,20.56,17.88,17.09,16.03,12.12,7.28,4.56,3.56,1.88,0.34,1.06,5.56,10.03,13.16,16.94,22.34,26.56,26.78,25.34,24.75,23.66,20.38,16.44,14.72,15.12,14.78,13.62,13.75,15.88,17.66,16.91,16.91,18.78,20.53,20.03,18.25,18.69,19.34,18.12,16.12,17.0,19.84,21.91,23.25,25.56,28.94,30.47,28.78,26.34,25.66,25.16,23.09,21.0,21.38,22.56,21.88,20.0,19.16,19.09,17.72,14.53,13.16,14.06,14.88,14.0,13.03,13.75,13.81,11.53,8.56,7.88,8.56,8.44,8.03,9.84,13.5,16.47,17.78,20.12,25.03,29.47,31.31,32.66,35.91,38.69,38.84,37.94,38.84,39.62,38.56,35.75,34.09,33.59,31.78,28.09,25.19,24.25,23.28,20.31,17.19,16.44,15.94,13.94,11.72,12.28,14.31,15.19,15.06,16.28,19.06,21.09,20.78,20.81,22.66,23.62,22.53,21.22,22.16,23.69,23.06,21.81,22.38,23.41,23.03,21.03,19.88,20.69,20.91,19.28,19.0,21.19,22.81,21.97,20.5,20.31,20.31,18.75,17.22,18.41,21.34,23.56,23.69,24.56,26.25,26.78,24.22,22.41,22.81,23.44,22.06,20.94,22.41,24.12,23.5,21.62,21.47,22.0,21.41,18.97,17.97,18.34,17.78,15.03,12.88,13.28,14.34,13.59,13.34,16.0,19.06,20.28,19.72,20.62,21.94,21.78,19.53,18.69,20.06,20.25,18.47,17.03,17.53,18.53,17.25,15.69,16.78,18.59,18.59,17.31,17.88,19.72,20.28,19.53,20.25,22.97,24.56,23.47,22.03,22.22,22.28,20.0,17.44,16.97,17.03,15.62,13.16,12.94,14.28,14.97,13.81,13.84,15.78,16.97,15.94,15.44,16.88,18.5,18.0,17.66,19.56,21.69,22.16,21.44,21.91,23.97,24.88,23.91,23.75,24.84,25.0,22.78,20.62,20.56,21.03,19.78,18.19,18.5,19.91,19.66,17.84,17.44,18.22,18.12,16.59,16.06,18.41,20.66,21.47,22.38,25.28,28.0,28.34,27.34,20.88,21.97,23.22,23.75,22.12,19.09,16.38,14.75,12.5,9.91,8.88,10.12,12.16,14.19,16.56,20.97,25.38,28.41,30.5,33.03,35.38:34.03,34.81,32.91,31.16,31.16,31.53,30.06,27.34,26.62,27.41,27.16,25.69,25.41,27.31,28.38,27.12,25.75,26.31,26.38,24.5,22.34,22.41,23.47,23.25,21.84,22.28,24.53,25.78,25.78,26.94,30.25,32.69,32.78,33.09,35.75,37.78,37.5,36.06,36.38,37.28,36.53,35.25,35.75,37.31,37.69,36.31,35.28,36.06,35.94,33.59,31.06,31.0,31.66,30.75,29.41,29.94,30.59,29.44,26.44,24.53,24.53,23.78,21.44,20.03,21.31,23.0,23.44,24.38,27.78,31.72,32.94,32.31,32.5,32.19,29.69,25.5,22.94,22.22,20.91,17.84,15.25,14.47,12.94,9.62,6.38,6.22,7.78,8.88,9.53,13.5,18.75,22.56,24.66,27.12,30.56,32.19,31.25,30.56,31.53,32.0,30.31,27.03,25.31,23.53,19.84,15.28,13.25,13.12,12.75,11.34,11.44,13.06,14.25,13.12,12.59,14.25,15.62,14.81,13.16,13.72,15.25,15.78,16.06,18.69,23.25,25.72,25.5,25.31,25.25,23.81,19.53,15.78,15.06,14.75,13.47,12.0,12.41,13.38,12.03,8.88,7.41,8.0,8.34,7.38,7.88,10.16,11.53,10.09,8.53,9.25,10.19,9.72,8.88,10.41,12.75,13.47,12.44,12.78,14.28,14.97,13.78,13.78,15.78,17.06,15.94,14.19,14.03,13.81,11.41,8.09,7.28,7.78,7.22,5.97,6.44,9.16,11.12,11.81,13.97,18.25,21.97,22.59,22.03,22.81,23.12,21.09,18.59,19.12,20.19,20.38,18.66,18.69,20.25,20.62,18.53,17.28,18.0,18.66,17.25,16.25,17.44,19.16,18.91,17.19,17.28,18.44,18.66,17.66,18.38,21.28,23.41,22.75,22.19,23.38,24.22,23.06,22.03,22.75,24.91,25.12,24.0,24.31,25.0,23.78,20.41,18.19,18.12,18.25,16.56,15.81,17.38,19.38,18.78,18.03,19.56,22.12,23.34,23.31,24.97,27.53,28.28,26.62,26.09,26.69,26.5,23.22,19.69,18.0,17.56,15.69,14.19,15.47,17.72,18.22,17.0,16.97,19.19,21.12,21.56,23.19,26.59,28.75,27.41,25.12,24.62,24.47,22.47,20.31,20.53,22.25,22.59,21.62,21.91,23.38,23.12,20.53,18.91,19.19,18.69,16.0,13.5,13.34,14.53,14.12,13.56,15.0,17.31,17.72,16.09,15.66,17.28,18.0,16.78,16.25,17.78,18.88,17.12,15.47,16.56,18.44,18.44,18.0,19.19,21.31,21.91,20.62,20.53,22.16,22.78,20.81,19.41,20.22,20.72,18.56,16.44,16.22,16.84,15.78,13.91,13.66,15.06,15.12,13.53,13.62,15.59,17.44,17.03,17.28,19.56,21.78,21.62,20.75,21.66,22.97,22.16,20.0,19.19,19.97,19.56,18.03,18.41,20.75,22.69,21.94,20.88,21.44,21.94,19.81,17.66,17.75,19.0,18.22,16.59,16.69,18.31,19.19,18.34,18.91,21.44,23.88,23.53,23.47,25.06,25.91,24.47,22.31,22.41,23.5,22.97,21.09,20.47,21.16,20.62,18.19,17.12,18.47,19.53,18.12,17.34,18.66,20.56,20.25,19.5,20.88,23.44,24.19,23.62,23.88,25.38,25.75,23.97,23.31,24.91,26.66,26.31,25.81,27.38,29.53,29.12,27.88,28.16,29.16,28.16,25.38,23.66,23.34,22.75,20.0,18.25,18.97,19.81,17.91,16.0,16.38,17.38,16.34,14.91,15.59,17.69,18.84,18.75,19.78,22.59,24.34,23.97,23.47,24.78,25.97,24.25,22.0,21.97,22.75,21.78,20.38,20.66,22.47,22.59,20.84,19.72,20.41,20.06,17.12,14.56,14.84,15.81,15.28,15.66,18.5,22.44,24.12,24.38,25.75,27.94,28.69,27.0,25.72,26.09,25.62,22.69,20.22,20.16,20.25,18.28,15.53,14.62,15.19,13.84,11.47,11.41,13.03,13.88,13.06,13.16,15.88,17.91,17.16,16.56,17.78,19.66,18.88,18.25,19.31,21.94,22.31,21.41,22.12,24.19,24.91,23.16,21.72,22.66,23.16,21.56,20.38,21.41,23.44,22.91,22.34,23.41,26.31,26.88,26.03,26.28,27.69,27.69,24.97,23.03,22.72,22.19,19.34,16.88,17.16,18.47,18.06,17.72,18.94,21.88,23.56,24.12,25.75,29.0,30.75,29.53,27.84,27.62,26.69,23.12,19.56,18.59,18.75,16.94,14.88,14.31,15.09,14.56,13.06,13.34,15.75,17.44,16.94,16.66,18.56,20.69,20.5,19.72,21.03,22.28,21.16,18.38,17.25,17.5,16.09,13.12,11.38,11.91,12.19,10.59,10.0,12.22,14.66,15.22,15.03,17.0,19.5,19.38,17.59,17.12,17.69,16.25,13.53,12.34,13.16,13.69,12.34,11.22,11.94,13.0,11.84,10.34,10.84,12.69,13.44,13.09,14.56,17.16,18.16,16.56,15.59,16.72,18.19,17.78,17.72,19.75,21.78,20.59,18.34,18.28,18.72,17.38,15.06,13.88,14.78,14.84,13.53,13.31,16.06,18.75,19.16,20.03,22.97,25.78,26.19,25.66,26.31,28.22,27.84,26.56,26.38,28.03,28.25,26.34,24.72,25.47,26.0,24.88,23.88,25.5,27.69,27.22,25.47,24.69,24.62,23.28,21.28,21.03,23.69,25.66,24.84,23.97,24.56,24.97,23.03,21.62,22.88,25.44,26.19,25.81,26.75,28.47,28.19,25.97,24.47,24.97,24.44,21.62,19.5,20.28,21.53,20.81,20.56,22.72,25.5,25.88,24.81,25.41,27.44,28.31,27.25,26.88,28.03,27.59,24.81,21.88,21.56,21.5,19.09,16.94,17.59,20.03,20.78,20.53,22.12,24.12,24.16,22.12,20.69,21.44,21.59,19.88,18.03,18.91,20.0,19.03,18.09,19.38,22.28,23.12,23.16,24.56,27.47,28.19,26.56,25.19,25.91,25.59,23.31,21.97,23.12,25.12,24.72,23.75,24.38,25.81,25.56,24.31,24.44,26.12,25.91,23.12,20.91,20.47,20.12,18.03,16.47,17.81,19.72,19.19,17.56,17.62,18.44,17.31,14.94,14.41,16.31,17.34,16.88,17.38,19.88,21.25,20.56,19.47,20.56,22.47,22.22,21.41,22.19,24.06,24.09,23.25,23.69,25.84,26.78,25.44,24.0,24.41,24.19,21.84,19.28,19.28,20.22,19.5,18.0,18.47,20.31,20.69,20.19,21.22,24.75,27.44,27.78,27.72,29.38,29.91,27.88,25.31,25.19,25.66,24.22,21.59,20.81,21.22,20.72,18.97,18.41,20.41,21.72,20.72,20.28,21.88,22.78,21.5,19.69,19.97,20.66,19.56,16.75,15.25,14.78,13.06,10.06,8.69,10.03,11.41,10.34,9.0,9.5,9.66,7.75,5.19,5.25,6.62,6.31,4.84,5.0,6.69,7.75,7.34,7.59,10.19,11.47,10.28,8.78,9.72,11.62,11.78,11.66,13.25,15.47,15.59,13.91,13.81,15.91,16.84,16.41,17.22,20.47,23.31,23.19,22.84,24.03,24.69,22.44,19.19,18.09,18.22,17.12,14.75,14.22,15.28,15.12,12.84,10.72,11.0,10.78,8.88,7.5,9.41,12.75,14.88,16.19,18.78,21.47,21.91,20.28,20.03,21.81,22.56,21.69,20.72,22.09,22.34,20.56,17.88,17.09,16.03,12.12,7.28,4.56,3.56,1.88,0.34,1.06,5.56,10.03,13.16,16.94,22.34,26.56,26.78,25.34,24.75,23.66,20.38,16.44,14.72,15.12,14.78,13.62,13.75,15.88,17.66,16.91,16.91,18.78,20.53,20.03,18.25,18.69,19.34,18.12,16.12,17.0,19.84,21.91,23.25,25.56,28.94,30.47,28.78,26.34,25.66,25.16,23.09,21.0,21.38,22.56,21.88,20.0,19.16,19.09,17.72,14.53,13.16,14.06,14.88,14.0,13.03,13.75,13.81,11.53,8.56,7.88,8.56,8.44,8.03,9.84,13.5,16.47,17.78,20.12,25.03,29.47,31.31,32.66,35.91,38.69,38.84,37.94,38.84,39.62,38.56,35.75,34.09,33.59,31.78,28.09,25.19,24.25,23.28,20.31,17.19,16.44,15.94,13.94,11.72,12.28,14.31,15.19,15.06,16.28,19.06,21.09,20.78,20.81,22.66,23.62,22.53,21.22,22.16,23.69,23.06,21.81,22.38,23.41,23.03,21.03,19.88,20.69,20.91,19.28,19.0,21.19,22.81,21.97,20.5,20.31,20.31,18.75,17.22,18.41,21.34,23.56,23.69,24.56,26.25,26.78,24.22,22.41,22.81,23.44,22.06,20.94,22.41,24.12,23.5,21.62,21.47,22.0,21.41,18.97,17.97,18.34,17.78,15.03,12.88,13.28,14.34,13.59,13.34,16.0,19.06,20.28,19.72,20.62,21.94,21.78,19.53,18.69,20.06,20.25,18.47,17.03,17.53,18.53,17.25,15.69,16.78,18.59,18.59,17.31,17.88,19.72,20.28,19.53,20.25,22.97,24.56,23.47,22.03,22.22,22.28,20.0,17.44,16.97,17.03,15.62,13.16,12.94,14.28,14.97,13.81,13.84,15.78,16.97,15.94,15.44,16.88,18.5,18.0,17.66,19.56,21.69,22.16,21.44,21.91,23.97,24.88,23.91,23.75,24.84,25.0,22.78,20.62,20.56,21.03,19.78,18.19,18.5,19.91,19.66,17.84,17.44,18.22,18.12,16.59,16.06,18.41,20.66,21.47,22.38,25.28,28.0,28.34,27.34,20.88,21.97,23.22,23.75,22.12,19.09,16.38,14.75,12.5,9.91,8.88,10.12,12.16,14.19,16.56,20.97,25.38,28.41,30.5,33.03,35.38,36.19,35.44,35.19,35.88,35.81,34.53,33.38:27.34,26.62,27.41,27.16,25.69,25.41,27.31,28.38,27.12,25.75,26.31,26.38,24.5,22.34,22.41,23.47,23.25,21.84,22.28,24.53,25.78,25.78,26.94,30.25,32.69,32.78,33.09,35.75,37.78,37.5,36.06,36.38,37.28,36.53,35.25,35.75,37.31,37.69,36.31,35.28,36.06,35.94,33.59,31.06,31.0,31.66,30.75,29.41,29.94,30.59,29.44,26.44,24.53,24.53,23.78,21.44,20.03,21.31,23.0,23.44,24.38,27.78,31.72,32.94,32.31,32.5,32.19,29.69,25.5,22.94,22.22,20.91,17.84,15.25,14.47,12.94,9.62,6.38,6.22,7.78,8.88,9.53,13.5,18.75,22.56,24.66,27.12,30.56,32.19,31.25,30.56,31.53,32.0,30.31,27.03,25.31,23.53,19.84,15.28,13.25,13.12,12.75,11.34,11.44,13.06,14.25,13.12,12.59,14.25,15.62,14.81,13.16,13.72,15.25,15.78,16.06,18.69,23.25,25.72,25.5,25.31,25.25,23.81,19.53,15.78,15.06,14.75,13.47,12.0,12.41,13.38,12.03,8.88,7.41,8.0,8.34,7.38,7.88,10.16,11.53,10.09,8.53,9.25,10.19,9.72,8.88,10.41,12.75,13.47,12.44,12.78,14.28,14.97,13.78,13.78,15.78,17.06,15.94,14.19,14.03,13.81,11.41,8.09,7.28,7.78,7.22,5.97,6.44,9.16,11.12,11.81,13.97,18.25,21.97,22.59,22.03,22.81,23.12,21.09,18.59,19.12,20.19,20.38,18.66,18.69,20.25,20.62,18.53,17.28,18.0,18.66,17.25,16.25,17.44,19.16,18.91,17.19,17.28,18.44,18.66,17.66,18.38,21.28,23.41,22.75,22.19,23.38,24.22,23.06,22.03,22.75,24.91,25.12,24.0,24.31,25.0,23.78,20.41,18.19,18.12,18.25,16.56,15.81,17.38,19.38,18.78,18.03,19.56,22.12,23.34,23.31,24.97,27.53,28.28,26.62,26.09,26.69,26.5,23.22,19.69,18.0,17.56,15.69,14.19,15.47,17.72,18.22,17.0,16.97,19.19,21.12,21.56,23.19,26.59,28.75,27.41,25.12,24.62,24.47,22.47,20.31,20.53,22.25,22.59,21.62,21.91,23.38,23.12,20.53,18.91,19.19,18.69,16.0,13.5,13.34,14.53,14.12,13.56,15.0,17.31,17.72,16.09,15.66,17.28,18.0,16.78,16.25,17.78,18.88,17.12,15.47,16.56,18.44,18.44,18.0,19.19,21.31,21.91,20.62,20.53,22.16,22.78,20.81,19.41,20.22,20.72,18.56,16.44,16.22,16.84,15.78,13.91,13.66,15.06,15.12,13.53,13.62,15.59,17.44,17.03,17.28,19.56,21.78,21.62,20.75,21.66,22.97,22.16,20.0,19.19,19.97,19.56,18.03,18.41,20.75,22.69,21.94,20.88,21.44,21.94,19.81,17.66,17.75,19.0,18.22,16.59,16.69,18.31,19.19,18.34,18.91,21.44,23.88,23.53,23.47,25.06,25.91,24.47,22.31,22.41,23.5,22.97,21.09,20.47,21.16,20.62,18.19,17.12,18.47,19.53,18.12,17.34,18.66,20.56,20.25,19.5,20.88,23.44,24.19,23.62,23.88,25.38,25.75,23.97,23.31,24.91,26.66,26.31,25.81,27.38,29.53,29.12,27.88,28.16,29.16,28.16,25.38,23.66,23.34,22.75,20.0,18.25,18.97,19.81,17.91,16.0,16.38,17.38,16.34,14.91,15.59,17.69,18.84,18.75,19.78,22.59,24.34,23.97,23.47,24.78,25.97,24.25,22.0,21.97,22.75,21.78,20.38,20.66,22.47,22.59,20.84,19.72,20.41,20.06,17.12,14.56,14.84,15.81,15.28,15.66,18.5,22.44,24.12,24.38,25.75,27.94,28.69,27.0,25.72,26.09,25.62,22.69,20.22,20.16,20.25,18.28,15.53,14.62,15.19,13.84,11.47,11.41,13.03,13.88,13.06,13.16,15.88,17.91,17.16,16.56,17.78,19.66,18.88,18.25,19.31,21.94,22.31,21.41,22.12,24.19,24.91,23.16,21.72,22.66,23.16,21.56,20.38,21.41,23.44,22.91,22.34,23.41,26.31,26.88,26.03,26.28,27.69,27.69,24.97,23.03,22.72,22.19,19.34,16.88,17.16,18.47,18.06,17.72,18.94,21.88,23.56,24.12,25.75,29.0,30.75,29.53,27.84,27.62,26.69,23.12,19.56,18.59,18.75,16.94,14.88,14.31,15.09,14.56,13.06,13.34,15.75,17.44,16.94,16.66,18.56,20.69,20.5,19.72,21.03,22.28,21.16,18.38,17.25,17.5,16.09,13.12,11.38,11.91,12.19,10.59,10.0,12.22,14.66,15.22,15.03,17.0,19.5,19.38,17.59,17.12,17.69,16.25,13.53,12.34,13.16,13.69,12.34,11.22,11.94,13.0,11.84,10.34,10.84,12.69,13.44,13.09,14.56,17.16,18.16,16.56,15.59,16.72,18.19,17.78,17.72,19.75,21.78,20.59,18.34,18.28,18.72,17.38,15.06,13.88,14.78,14.84,13.53,13.31,16.06,18.75,19.16,20.03,22.97,25.78,26.19,25.66,26.31,28.22,27.84,26.56,26.38,28.03,28.25,26.34,24.72,25.47,26.0,24.88,23.88,25.5,27.69,27.22,25.47,24.69,24.62,23.28,21.28,21.03,23.69,25.66,24.84,23.97,24.56,24.97,23.03,21.62,22.88,25.44,26.19,25.81,26.75,28.47,28.19,25.97,24.47,24.97,24.44,21.62,19.5,20.28,21.53,20.81,20.56,22.72,25.5,25.88,24.81,25.41,27.44,28.31,27.25,26.88,28.03,27.59,24.81,21.88,21.56,21.5,19.09,16.94,17.59,20.03,20.78,20.53,22.12,24.12,24.16,22.12,20.69,21.44,21.59,19.88,18.03,18.91,20.0,19.03,18.09,19.38,22.28,23.12,23.16,24.56,27.47,28.19,26.56,25.19,25.91,25.59,23.31,21.97,23.12,25.12,24.72,23.75,24.38,25.81,25.56,24.31,24.44,26.12,25.91,23.12,20.91,20.47,20.12,18.03,16.47,17.81,19.72,19.19,17.56,17.62,18.44,17.31,14.94,14.41,16.31,17.34,16.88,17.38,19.88,21.25,20.56,19.47,20.56,22.47,22.22,21.41,22.19,24.06,24.09,23.25,23.69,25.84,26.78,25.44,24.0,24.41,24.19,21.84,19.28,19.28,20.22,19.5,18.0,18.47,20.31,20.69,20.19,21.22,24.75,27.44,27.78,27.72,29.38,29.91,27.88,25.31,25.19,25.66,24.22,21.59,20.81,21.22,20.72,18.97,18.41,20.41,21.72,20.72,20.28,21.88,22.78,21.5,19.69,19.97,20.66,19.56,16.75,15.25,14.78,13.06,10.06,8.69,10.03,11.41,10.34,9.0,9.5,9.66,7.75,5.19,5.25,6.62,6.31,4.84,5.0,6.69,7.75,7.34,7.59,10.19,11.47,10.28,8.78,9.72,11.62,11.78,11.66,13.25,15.47,15.59,13.91,13.81,15.91,16.84,16.41,17.22,20.47,23.31,23.19,22.84,24.03,24.69,22.44,19.19,18.09,18.22,17.12,14.75,14.22,15.28,15.12,12.84,10.72,11.0,10.78,8.88,7.5,9.41,12.75,14.88,16.19,18.78,21.47,21.91,20.28,20.03,21.81,22.56,21.69,20.72,22.09,22.34,20.56,17.88,17.09,16.03,12.12,7.28,4.56,3.56,1.88,0.34,1.06,5.56,10.03,13.16,16.94,22.34,26.56,26.78,25.34,24.75,23.66,20.38,16.44,14.72,15.12,14.78,13.62,13.75,15.88,17.66,16.91,16.91,18.78,20.53,20.03,18.25,18.69,19.34,18.12,16.12,17.0,19.84,21.91,23.25,25.56,28.94,30.47,28.78,26.34,25.66,25.16,23.09,21.0,21.38,22.56,21.88,20.0,19.16,19.09,17.72,14.53,13.16,14.06,14.88,14.0,13.03,13.75,13.81,11.53,8.56,7.88,8.56,8.44,8.03,9.84,13.5,16.47,17.78,20.12,25.03,29.47,31.31,32.66,35.91,38.69,38.84,37.94,38.84,39.62,38.56,35.75,34.09,33.59,31.78,28.09,25.19,24.25,23.28,20.31,17.19,16.44,15.94,13.94,11.72,12.28,14.31,15.19,15.06,16.28,19.06,21.09,20.78,20.81,22.66,23.62,22.53,21.22,22.16,23.69,23.06,21.81,22.38,23.41,23.03,21.03,19.88,20.69,20.91,19.28,19.0,21.19,22.81,21.97,20.5,20.31,20.31,18.75,17.22,18.41,21.34,23.56,23.69,24.56,26.25,26.78,24.22,22.41,22.81,23.44,22.06,20.94,22.41,24.12,23.5,21.62,21.47,22.0,21.41,18.97,17.97,18.34,17.78,15.03,12.88,13.28,14.34,13.59,13.34,16.0,19.06,20.28,19.72,20.62,21.94,21.78,19.53,18.69,20.06,20.25,18.47,17.03,17.53,18.53,17.25,15.69,16.78,18.59,18.59,17.31,17.88,19.72,20.28,19.53,20.25,22.97,24.56,23.47,22.03,22.22,22.28,20.0,17.44,16.97,17.03,15.62,13.16,12.94,14.28,14.97,13.81,13.84,15.78,16.97,15.94,15.44,16.88,18.5,18.0,17.66,19.56,21.69,22.16,21.44,21.91,23.97,24.88,23.91,23.75,24.84,25.0,22.78,20.62,20.56,21.03,19.78,18.19,18.5,19.91,19.66,17.84,17.44,18.22,18.12,16.59,16.06,18.41,20.66,21.47,22.38,25.28,28.0,28.34,27.34,20.88,21.97,23.22,23.75,22.12,19.09,16.38,14.75,12.5,9.91,8.88,10.12,12.16,14.19,16.56,20.97,25.38,28.41,30.5,33.03,35.38,36.19,35.44,35.19,35.88,35.81,34.53,33.38,33.34,33.22,31.62,29.81,29.25,28.72,27.12:28.38,27.12,25.75,26.31,26.38,24.5,22.34,22.41,23.47,23.25,21.84,22.28,24.53,25.78,25.78,26.94,30.25,32.69,32.78,33.09,35.75,37.78,37.5,36.06,36.38,37.28,36.53,35.25,35.75,37.31,37.69,36.31,35.28,36.06,35.94,33.59,31.06,31.0,31.66,30.75,29.41,29.94,30.59,29.44,26.44,24.53,24.53,23.78,21.44,20.03,21.31,23.0,23.44,24.38,27.78,31.72,32.94,32.31,32.5,32.19,29.69,25.5,22.94,22.22,20.91,17.84,15.25,14.47,12.94,9.62,6.38,6.22,7.78,8.88,9.53,13.5,18.75,22.56,24.66,27.12,30.56,32.19,31.25,30.56,31.53,32.0,30.31,27.03,25.31,23.53,19.84,15.28,13.25,13.12,12.75,11.34,11.44,13.06,14.25,13.12,12.59,14.25,15.62,14.81,13.16,13.72,15.25,15.78,16.06,18.69,23.25,25.72,25.5,25.31,25.25,23.81,19.53,15.78,15.06,14.75,13.47,12.0,12.41,13.38,12.03,8.88,7.41,8.0,8.34,7.38,7.88,10.16,11.53,10.09,8.53,9.25,10.19,9.72,8.88,10.41,12.75,13.47,12.44,12.78,14.28,14.97,13.78,13.78,15.78,17.06,15.94,14.19,14.03,13.81,11.41,8.09,7.28,7.78,7.22,5.97,6.44,9.16,11.12,11.81,13.97,18.25,21.97,22.59,22.03,22.81,23.12,21.09,18.59,19.12,20.19,20.38,18.66,18.69,20.25,20.62,18.53,17.28,18.0,18.66,17.25,16.25,17.44,19.16,18.91,17.19,17.28,18.44,18.66,17.66,18.38,21.28,23.41,22.75,22.19,23.38,24.22,23.06,22.03,22.75,24.91,25.12,24.0,24.31,25.0,23.78,20.41,18.19,18.12,18.25,16.56,15.81,17.38,19.38,18.78,18.03,19.56,22.12,23.34,23.31,24.97,27.53,28.28,26.62,26.09,26.69,26.5,23.22,19.69,18.0,17.56,15.69,14.19,15.47,17.72,18.22,17.0,16.97,19.19,21.12,21.56,23.19,26.59,28.75,27.41,25.12,24.62,24.47,22.47,20.31,20.53,22.25,22.59,21.62,21.91,23.38,23.12,20.53,18.91,19.19,18.69,16.0,13.5,13.34,14.53,14.12,13.56,15.0,17.31,17.72,16.09,15.66,17.28,18.0,16.78,16.25,17.78,18.88,17.12,15.47,16.56,18.44,18.44,18.0,19.19,21.31,21.91,20.62,20.53,22.16,22.78,20.81,19.41,20.22,20.72,18.56,16.44,16.22,16.84,15.78,13.91,13.66,15.06,15.12,13.53,13.62,15.59,17.44,17.03,17.28,19.56,21.78,21.62,20.75,21.66,22.97,22.16,20.0,19.19,19.97,19.56,18.03,18.41,20.75,22.69,21.94,20.88,21.44,21.94,19.81,17.66,17.75,19.0,18.22,16.59,16.69,18.31,19.19,18.34,18.91,21.44,23.88,23.53,23.47,25.06,25.91,24.47,22.31,22.41,23.5,22.97,21.09,20.47,21.16,20.62,18.19,17.12,18.47,19.53,18.12,17.34,18.66,20.56,20.25,19.5,20.88,23.44,24.19,23.62,23.88,25.38,25.75,23.97,23.31,24.91,26.66,26.31,25.81,27.38,29.53,29.12,27.88,28.16,29.16,28.16,25.38,23.66,23.34,22.75,20.0,18.25,18.97,19.81,17.91,16.0,16.38,17.38,16.34,14.91,15.59,17.69,18.84,18.75,19.78,22.59,24.34,23.97,23.47,24.78,25.97,24.25,22.0,21.97,22.75,21.78,20.38,20.66,22.47,22.59,20.84,19.72,20.41,20.06,17.12,14.56,14.84,15.81,15.28,15.66,18.5,22.44,24.12,24.38,25.75,27.94,28.69,27.0,25.72,26.09,25.62,22.69,20.22,20.16,20.25,18.28,15.53,14.62,15.19,13.84,11.47,11.41,13.03,13.88,13.06,13.16,15.88,17.91,17.16,16.56,17.78,19.66,18.88,18.25,19.31,21.94,22.31,21.41,22.12,24.19,24.91,23.16,21.72,22.66,23.16,21.56,20.38,21.41,23.44,22.91,22.34,23.41,26.31,26.88,26.03,26.28,27.69,27.69,24.97,23.03,22.72,22.19,19.34,16.88,17.16,18.47,18.06,17.72,18.94,21.88,23.56,24.12,25.75,29.0,30.75,29.53,27.84,27.62,26.69,23.12,19.56,18.59,18.75,16.94,14.88,14.31,15.09,14.56,13.06,13.34,15.75,17.44,16.94,16.66,18.56,20.69,20.5,19.72,21.03,22.28,21.16,18.38,17.25,17.5,16.09,13.12,11.38,11.91,12.19,10.59,10.0,12.22,14.66,15.22,15.03,17.0,19.5,19.38,17.59,17.12,17.69,16.25,13.53,12.34,13.16,13.69,12.34,11.22,11.94,13.0,11.84,10.34,10.84,12.69,13.44,13.09,14.56,17.16,18.16,16.56,15.59,16.72,18.19,17.78,17.72,19.75,21.78,20.59,18.34,18.28,18.72,17.38,15.06,13.88,14.78,14.84,13.53,13.31,16.06,18.75,19.16,20.03,22.97,25.78,26.19,25.66,26.31,28.22,27.84,26.56,26.38,28.03,28.25,26.34,24.72,25.47,26.0,24.88,23.88,25.5,27.69,27.22,25.47,24.69,24.62,23.28,21.28,21.03,23.69,25.66,24.84,23.97,24.56,24.97,23.03,21.62,22.88,25.44,26.19,25.81,26.75,28.47,28.19,25.97,24.47,24.97,24.44,21.62,19.5,20.28,21.53,20.81,20.56,22.72,25.5,25.88,24.81,25.41,27.44,28.31,27.25,26.88,28.03,27.59,24.81,21.88,21.56,21.5,19.09,16.94,17.59,20.03,20.78,20.53,22.12,24.12,24.16,22.12,20.69,21.44,21.59,19.88,18.03,18.91,20.0,19.03,18.09,19.38,22.28,23.12,23.16,24.56,27.47,28.19,26.56,25.19,25.91,25.59,23.31,21.97,23.12,25.12,24.72,23.75,24.38,25.81,25.56,24.31,24.44,26.12,25.91,23.12,20.91,20.47,20.12,18.03,16.47,17.81,19.72,19.19,17.56,17.62,18.44,17.31,14.94,14.41,16.31,17.34,16.88,17.38,19.88,21.25,20.56,19.47,20.56,22.47,22.22,21.41,22.19,24.06,24.09,23.25,23.69,25.84,26.78,25.44,24.0,24.41,24.19,21.84,19.28,19.28,20.22,19.5,18.0,18.47,20.31,20.69,20.19,21.22,24.75,27.44,27.78,27.72,29.38,29.91,27.88,25.31,25.19,25.66,24.22,21.59,20.81,21.22,20.72,18.97,18.41,20.41,21.72,20.72,20.28,21.88,22.78,21.5,19.69,19.97,20.66,19.56,16.75,15.25,14.78,13.06,10.06,8.69,10.03,11.41,10.34,9.0,9.5,9.66,7.75,5.19,5.25,6.62,6.31,4.84,5.0,6.69,7.75,7.34,7.59,10.19,11.47,10.28,8.78,9.72,11.62,11.78,11.66,13.25,15.47,15.59,13.91,13.81,15.91,16.84,16.41,17.22,20.47,23.31,23.19,22.84,24.03,24.69,22.44,19.19,18.09,18.22,17.12,14.75,14.22,15.28,15.12,12.84,10.72,11.0,10.78,8.88,7.5,9.41,12.75,14.88,16.19,18.78,21.47,21.91,20.28,20.03,21.81,22.56,21.69,20.72,22.09,22.34,20.56,17.88,17.09,16.03,12.12,7.28,4.56,3.56,1.88,0.34,1.06,5.56,10.03,13.16,16.94,22.34,26.56,26.78,25.34,24.75,23.66,20.38,16.44,14.72,15.12,14.78,13.62,13.75,15.88,17.66,16.91,16.91,18.78,20.53,20.03,18.25,18.69,19.34,18.12,16.12,17.0,19.84,21.91,23.25,25.56,28.94,30.47,28.78,26.34,25.66,25.16,23.09,21.0,21.38,22.56,21.88,20.0,19.16,19.09,17.72,14.53,13.16,14.06,14.88,14.0,13.03,13.75,13.81,11.53,8.56,7.88,8.56,8.44,8.03,9.84,13.5,16.47,17.78,20.12,25.03,29.47,31.31,32.66,35.91,38.69,38.84,37.94,38.84,39.62,38.56,35.75,34.09,33.59,31.78,28.09,25.19,24.25,23.28,20.31,17.19,16.44,15.94,13.94,11.72,12.28,14.31,15.19,15.06,16.28,19.06,21.09,20.78,20.81,22.66,23.62,22.53,21.22,22.16,23.69,23.06,21.81,22.38,23.41,23.03,21.03,19.88,20.69,20.91,19.28,19.0,21.19,22.81,21.97,20.5,20.31,20.31,18.75,17.22,18.41,21.34,23.56,23.69,24.56,26.25,26.78,24.22,22.41,22.81,23.44,22.06,20.94,22.41,24.12,23.5,21.62,21.47,22.0,21.41,18.97,17.97,18.34,17.78,15.03,12.88,13.28,14.34,13.59,13.34,16.0,19.06,20.28,19.72,20.62,21.94,21.78,19.53,18.69,20.06,20.25,18.47,17.03,17.53,18.53,17.25,15.69,16.78,18.59,18.59,17.31,17.88,19.72,20.28,19.53,20.25,22.97,24.56,23.47,22.03,22.22,22.28,20.0,17.44,16.97,17.03,15.62,13.16,12.94,14.28,14.97,13.81,13.84,15.78,16.97,15.94,15.44,16.88,18.5,18.0,17.66,19.56,21.69,22.16,21.44,21.91,23.97,24.88,23.91,23.75,24.84,25.0,22.78,20.62,20.56,21.03,19.78,18.19,18.5,19.91,19.66,17.84,17.44,18.22,18.12,16.59,16.06,18.41,20.66,21.47,22.38,25.28,28.0,28.34,27.34,20.88,21.97,23.22,23.75,22.12,19.09,16.38,14.75,12.5,9.91,8.88,10.12,12.16,14.19,16.56,20.97,25.38,28.41,30.5,33.03,35.38,36.19,35.44,35.19,35.88,35.81,34.53,33.38,33.34,33.22,31.62,29.81,29.25,28.72,27.12,25.41,25.16,26.12,26.81,26.72,27.22,28.62:positivity
25.84,23.38,21.75,22.84,24.38,23.94,23.41,25.06,27.41,27.94,27.44,27.88,29.88,30.38,28.97,28.44,30.06,31.25,30.31,29.81,31.28,33.0,31.75,29.28,27.88,27.44,25.28,21.88,20.94,22.75,24.16,23.75,23.88,25.81,27.25,26.09,24.84,25.75,27.62,28.22,27.72,29.06,31.88,33.09,32.72,32.84,34.81,35.81,34.62,33.28,34.12,35.16,33.91,32.28,32.38,33.56,32.72,30.47,30.03,31.47,32.25,31.56,31.62,33.66,35.03,34.41,33.91,35.72,38.19,37.97,36.81,36.56,36.94,35.03,31.91,30.03,30.5,30.19,28.34,27.06,27.53,28.09,26.66,25.06,26.28,28.5,29.09,28.84,30.09,32.16,32.69,31.28,30.5,31.84,32.5,31.41,30.66,32.31,34.28,34.25,33.75,35.16,37.12,37.59,36.66,36.25,37.19,36.19,32.53,29.09,27.88,26.75,23.91,21.56,22.16,23.53,22.78,21.78,22.56,24.97,26.12,26.41,28.0,31.78,34.75,35.0,35.06,36.44,37.03,34.91,32.12,31.25,31.12,29.31,26.66,26.06,26.97,26.56,24.12,22.41,23.25,24.03,23.59,23.97,26.75,29.47,29.41,27.78,28.03,28.94,28.38,26.41,25.75,26.59,26.41,24.53,23.12,24.69,25.97,24.94,23.69,24.5,25.38,24.19,21.81,21.16,22.16,22.22,20.97,21.31,23.78,25.53,25.22,24.81,26.75,28.59,28.81,28.84,31.12,34.5,35.81,35.22,35.72,37.47,38.62,37.66,37.69,39.94,41.06,39.12,36.38,35.59,35.0,32.66,29.72,29.09,29.78,28.84,26.16,24.56,25.03,24.59,22.78,21.94,24.0,26.78,27.25,27.47,29.56,31.62,31.66,30.34,30.41,32.06,32.34,30.69,29.84,30.75,30.62,28.19,25.59,25.31,25.31,23.41,21.0,20.72,21.94,21.56,20.09,20.53,22.44,23.66,22.59,22.59,24.69,26.59,25.88,24.81,25.47,26.53,25.31,22.91,22.91,24.09,24.69,24.44,26.09,29.88,31.94,31.25,29.56,29.09,28.16,25.03,21.81,21.97,23.72,24.56,24.88,27.0,30.0,31.25,29.91,28.66,29.59,30.22,28.69,27.78,29.47,30.94,29.84,27.56,26.91,27.47,26.59,24.47,23.97,25.38,26.34,25.09,25.25,27.53,29.91,29.81,29.22,29.88,30.81,28.66,24.88,22.75,22.0,20.22,17.5,16.59,18.25,20.5,21.06,22.59,26.69,30.97,32.53,33.62,35.72,38.19,38.41,36.34,35.06,35.31,34.19,31.34,29.62,30.75,31.81,30.91,30.16,31.38,33.28,32.34,30.91,30.84,32.03,31.44,29.47,29.25,30.66,31.72,30.28,29.06,29.84,30.22,28.09,25.78,26.41,28.56,29.03,28.66,30.22,32.88,33.91,33.12,32.97,35.25,36.66,35.12,33.5,33.41,33.22,30.28,26.38,24.88,24.91,23.0,19.72,18.03,18.34,18.22,16.91,17.03,20.66,23.88,24.41,24.5,26.47,28.97,29.81,30.47,33.28,37.19,38.5,36.81,35.25,34.84,33.59,30.5,28.69,30.03,31.91,31.72,31.59,33.28,36.09,36.19,34.62,34.38,35.66,35.19,33.0,32.19,33.19,33.25,31.06,29.5,30.72,33.25,34.38,35.56,39.28,43.56,45.72,45.81,46.69,48.41,48.06,44.44,40.25,38.06,35.0,29.56,24.84,23.59,23.81,22.72,21.25,21.62,23.41,23.5,22.25,22.09,24.22,25.44,24.53,23.91,25.97,28.12,27.59,26.31,26.97,27.91,26.94,25.0,25.44,28.28,29.91,30.34,31.69,35.81,39.38,40.44,41.47,44.66,47.38,47.25,46.03,46.22,47.12,46.06,43.09,41.03,40.5,38.72,35.22,32.03,30.94,29.56,25.75,21.88,20.56,20.59,19.09,16.66,16.78,19.03,20.44,20.22,21.81,25.28,27.34,26.72,25.62,26.06,25.94,23.81,21.78,22.72,25.78,27.22,27.62,29.28,31.75,32.16,30.72,29.56,31.31,32.88,32.91,32.97,34.88,36.88,36.59,35.59,36.75,39.66,41.0,40.72,41.31,42.72,42.44,38.94,35.91,35.19,34.97,32.94,30.72,30.97,31.22,29.53,26.41,24.78,24.5,23.25,20.72,19.34,20.69,21.53,20.38,19.75,21.69,23.81,24.22,23.66,25.03,27.06,27.34,26.44,26.41,28.34,28.72,26.88,25.94,27.62,29.41,29.28,29.25,31.38,33.59,32.97,30.62,29.41,28.78,27.0,24.12,23.81,26.22,28.75,29.25,30.19,33.22,35.91,35.22,33.47,33.44,34.25,32.94,30.47,30.41,31.53,31.31,28.97,27.25,27.16,26.41,23.44,21.44,22.41,24.78,25.66,25.56,27.28,29.25,29.31,27.66,27.84,30.38,32.5,32.56,33.47,36.16,37.94,36.53,34.56,34.28,34.03,31.38,28.25,27.31,28.22,28.56,27.34,28.09,30.19,32.06,31.25,30.69,31.75,33.25,32.12,30.75,31.78,33.5,33.0,30.94,30.03,30.09,29.22,26.09,24.31,24.94,26.16,25.28,24.84,27.06,29.62,29.59,28.69,29.41,31.25,31.41,30.16,30.47,32.31,33.19,31.59,30.53,31.84,33.75,33.69,33.25,35.09,37.19,37.34,36.06,36.34,37.53,36.75,33.97,31.88,32.06,31.78,29.16,27.12,27.22,27.47,25.34,22.78,22.44,22.72,20.94,17.94,16.47,17.0,16.84,15.09,14.28,15.91,17.41,16.88,16.84,19.44,22.72,23.5,23.28,24.59,26.56,27.06,26.16,26.5,28.5,29.41,27.5,25.5,25.28,25.03,23.12,21.72,22.56,24.69,24.75,23.53,23.62,25.12,24.72,22.12,20.69,21.25,21.31,19.41,18.38,19.91,22.5,22.94,23.03,24.53,26.34,25.47,23.12,22.06,22.94,23.38,22.06,21.88,23.19,24.16,22.66,20.56,20.72,21.88,21.19,20.31,21.06,23.53,24.59,24.38,24.91,27.16,28.22,26.84,25.31,25.69,25.75,23.44,20.47,19.78,20.03,19.16,17.56,17.28,18.97,19.56,18.72,18.75,21.06,23.0,22.25,21.31,22.31,23.84,23.22,21.5,21.59,23.53,23.91,22.88,23.38,25.41,25.66,24.0,23.19,24.84,27.0,26.97,26.06,26.38,25.97,22.88,18.44,16.31,16.31,16.0,14.66,14.34,16.06,17.31,16.56,15.81,18.28,21.47,22.72,23.41,26.06,29.03,29.81,28.75,29.12,30.97,31.16,29.19,27.06,26.81,25.41,21.62,18.09,17.59,18.19,18.0,18.03,20.47,24.16,25.91,25.88,26.59,28.41,29.19,27.91,27.0,28.22,29.06,27.5,25.31,25.44,26.25,25.69,24.5,24.81,26.59,27.03,25.69,25.47,26.94,27.38,25.28,22.56,21.78,21.06,18.97,16.72,17.31,19.69,20.72,20.38,20.81,22.78,23.09,21.56,20.19,20.88,21.0,18.5,15.44,15.22,16.25,15.91,15.66,17.78,21.06,22.59,23.0,23.78,26.44,28.53,27.69,26.75,27.41,28.06,25.59,22.41,21.06,20.75,18.84,15.91,14.94,15.69,15.69,14.38,14.25,16.31,18.31,18.0,17.41,18.69,20.38,19.75,17.91,17.78,18.44,17.5,14.94,14.19,15.25,15.62,14.16,13.12,15.16,17.06,17.09,16.81,18.62,20.97,21.28,20.19,20.91,22.75,23.5,22.28,22.22,24.38,26.31,25.91,25.88,28.06,30.0,28.66,25.94,24.25,23.28,20.28,16.38,14.81,15.56,15.81,14.66,14.72,16.62,18.31,17.5,16.53,18.25,20.84,21.78,22.03,24.0,26.66,27.25,25.44,24.84,25.53,25.59,22.84,20.69,20.91,21.66,20.62,19.75,21.38,23.81,24.69,24.41,26.34,29.97,32.16,32.41,33.22,35.94,37.72,36.75,35.53,36.09,36.25,33.84,30.12,28.09,27.34,24.84,20.88,19.0,19.22,18.94,17.25,16.59,18.28,20.31,19.72,19.44,21.75,25.38,26.44,25.97,26.75,27.97,27.09,24.34,23.16,24.38,25.0,23.88,23.5,25.53,28.16,28.56,28.88,30.81,33.06,32.78,30.69,30.09,30.97,30.97,29.19,28.5,29.25,29.44,26.94,24.91,25.66,27.22,26.88,25.91,26.53,28.5,28.62,27.19,27.75,30.31,31.84,31.31,30.81,32.22,32.78,30.53,28.03,28.09,29.31,28.75,27.06,26.72,27.03,25.41,22.16,20.09,20.97,22.56,22.38,23.66,27.12,30.22,30.03,28.12,27.53,27.56,26.06,23.72,24.0,26.03,26.97,25.69,24.59,25.03,24.78,22.28,19.94,20.88,22.47,21.53,19.94,20.5,22.28,22.56,21.94,23.16,26.31,27.94,26.69,25.31,25.78,26.06,24.09,22.34,22.94,24.72,24.72,23.66,24.56,27.09,27.72,26.28,25.5,26.72,27.16,25.03,23.56,24.62,26.16,25.19,24.88,26.84,29.53,30.34,29.19,28.59,29.03,28.12,25.5,24.56,26.47,28.62,28.5,28.88,31.22,33.84,33.41,31.78,31.97,32.66,31.75,30.06,29.84,31.44,32.12,30.56,29.03,29.78,30.19,28.34,25.91,25.53,26.09,23.88,21.16,20.75,22.53,23.56,23.88,25.72,30.28,33.59,34.25,34.41,35.66,36.09,33.41,30.09,29.06,29.28,27.97,25.72,25.62,27.28,27.91,26.97,27.69,30.62,32.94,32.78,32.31,33.56,34.81,33.56,31.0,30.31,30.84,29.81,27.44,26.59,27.0,26.41,23.5,21.28,21.78,22.41,21.62,20.84,23.25,26.28,26.88,26.09,26.56,27.97,28.28,27.09,27.19,29.81,31.06,29.84:25.06,27.41,27.94,27.44,27.88,29.88,30.38,28.97,28.44,30.06,31.25,30.31,29.81,31.28,33.0,31.75,29.28,27.88,27.44,25.28,21.88,20.94,22.75,24.16,23.75,23.88,25.81,27.25,26.09,24.84,25.75,27.62,28.22,27.72,29.06,31.88,33.09,32.72,32.84,34.81,35.81,34.62,33.28,34.12,35.16,33.91,32.28,32.38,33.56,32.72,30.47,30.03,31.47,32.25,31.56,31.62,33.66,35.03,34.41,33.91,35.72,38.19,37.97,36.81,36.56,36.94,35.03,31.91,30.03,30.5,30.19,28.34,27.06,27.53,28.09,26.66,25.06,26.28,28.5,29.09,28.84,30.09,32.16,32.69,31.28,30.5,31.84,32.5,31.41,30.66,32.31,34.28,34.25,33.75,35.16,37.12,37.59,36.66,36.25,37.19,36.19,32.53,29.09,27.88,26.75,23.91,21.56,22.16,23.53,22.78,21.78,22.56,24.97,26.12,26.41,28.0,31.78,34.75,35.0,35.06,36.44,37.03,34.91,32.12,31.25,31.12,29.31,26.66,26.06,26.97,26.56,24.12,22.41,23.25,24.03,23.59,23.97,26.75,29.47,29.41,27.78,28.03,28.94,28.38,26.41,25.75,26.59,26.41,24.53,23.12,24.69,25.97,24.94,23.69,24.5,25.38,24.19,21.81,21.16,22.16,22.22,20.97,21.31,23.78,25.53,25.22,24.81,26.75,28.59,28.81,28.84,31.12,34.5,35.81,35.22,35.72,37.47,38.62,37.66,37.69,39.94,41.06,39.12,36.38,35.59,35.0,32.66,29.72,29.09,29.78,28.84,26.16,24.56,25.03,24.59,22.78,21.94,24.0,26.78,27.25,27.47,29.56,31.62,31.66,30.34,30.41,32.06,32.34,30.69,29.84,30.75,30.62,28.19,25.59,25.31,25.31,23.41,21.0,20.72,21.94,21.56,20.09,20.53,22.44,23.66,22.59,22.59,24.69,26.59,25.88,24.81,25.47,26.53,25.31,22.91,22.91,24.09,24.69,24.44,26.09,29.88,31.94,31.25,29.56,29.09,28.16,25.03,21.81,21.97,23.72,24.56,24.88,27.0,30.0,31.25,29.91,28.66,29.59,30.22,28.69,27.78,29.47,30.94,29.84,27.56,26.91,27.47,26.59,24.47,23.97,25.38,26.34,25.09,25.25,27.53,29.91,29.81,29.22,29.88,30.81,28.66,24.88,22.75,22.0,20.22,17.5,16.59,18.25,20.5,21.06,22.59,26.69,30.97,32.53,33.62,35.72,38.19,38.41,36.34,35.06,35.31,34.19,31.34,29.62,30.75,31.81,30.91,30.16,31.38,33.28,32.34,30.91,30.84,32.03,31.44,29.47,29.25,30.66,31.72,30.28,29.06,29.84,30.22,28.09,25.78,26.41,28.56,29.03,28.66,30.22,32.88,33.91,33.12,32.97,35.25,36.66,35.12,33.5,33.41,33.22,30.28,26.38,24.88,24.91,23.0,19.72,18.03,18.34,18.22,16.91,17.03,20.66,23.88,24.41,24.5,26.47,28.97,29.81,30.47,33.28,37.19,38.5,36.81,35.25,34.84,33.59,30.5,28.69,30.03,31.91,31.72,31.59,33.28,36.09,36.19,34.62,34.38,35.66,35.19,33.0,32.19,33.19,33.25,31.06,29.5,30.72,33.25,34.38,35.56,39.28,43.56,45.72,45.81,46.69,48.41,48.06,44.44,40.25,38.06,35.0,29.56,24.84,23.59,23.81,22.72,21.25,21.62,23.41,23.5,22.25,22.09,24.22,25.44,24.53,23.91,25.97,28.12,27.59,26.31,26.97,27.91,26.94,25.0,25.44,28.28,29.91,30.34,31.69,35.81,39.38,40.44,41.47,44.66,47.38,47.25,46.03,46.22,47.12,46.06,43.09,41.03,40.5,38.72,35.22,32.03,30.94,29.56,25.75,21.88,20.56,20.59,19.09,16.66,16.78,19.03,20.44,20.22,21.81,25.28,27.34,26.72,25.62,26.06,25.94,23.81,21.78,22.72,25.78,27.22,27.62,29.28,31.75,32.16,30.72,29.56,31.31,32.88,32.91,32.97,34.88,36.88,36.59,35.59,36.75,39.66,41.0,40.72,41.31,42.72,42.44,38.94,35.91,35.19,34.97,32.94,30.72,30.97,31.22,29.53,26.41,24.78,24.5,23.25,20.72,19.34,20.69,21.53,20.38,19.75,21.69,23.81,24.22,23.66,25.03,27.06,27.34,26.44,26.41,28.34,28.72,26.88,25.94,27.62,29.41,29.28,29.25,31.38,33.59,32.97,30.62,29.41,28.78,27.0,24.12,23.81,26.22,28.75,29.25,30.19,33.22,35.91,35.22,33.47,33.44,34.25,32.94,30.47,30.41,31.53,31.31,28.97,27.25,27.16,26.41,23.44,21.44,22.41,24.78,25.66,25.56,27.28,29.25,29.31,27.66,27.84,30.38,32.5,32.56,33.47,36.16,37.94,36.53,34.56,34.28,34.03,31.38,28.25,27.31,28.22,28.56,27.34,28.09,30.19,32.06,31.25,30.69,31.75,33.25,32.12,30.75,31.78,33.5,33.0,30.94,30.03,30.09,29.22,26.09,24.31,24.94,26.16,25.28,24.84,27.06,29.62,29.59,28.69,29.41,31.25,31.41,30.16,30.47,32.31,33.19,31.59,30.53,31.84,33.75,33.69,33.25,35.09,37.19,37.34,36.06,36.34,37.53,36.75,33.97,31.88,32.06,31.78,29.16,27.12,27.22,27.47,25.34,22.78,22.44,22.72,20.94,17.94,16.47,17.0,16.84,15.09,14.28,15.91,17.41,16.88,16.84,19.44,22.72,23.5,23.28,24.59,26.56,27.06,26.16,26.5,28.5,29.41,27.5,25.5,25.28,25.03,23.12,21.72,22.56,24.69,24.75,23.53,23.62,25.12,24.72,22.12,20.69,21.25,21.31,19.41,18.38,19.91,22.5,22.94,23.03,24.53,26.34,25.47,23.12,22.06,22.94,23.38,22.06,21.88,23.19,24.16,22.66,20.56,20.72,21.88,21.19,20.31,21.06,23.53,24.59,24.38,24.91,27.16,28.22,26.84,25.31,25.69,25.75,23.44,20.47,19.78,20.03,19.16,17.56,17.28,18.97,19.56,18.72,18.75,21.06,23.0,22.25,21.31,22.31,23.84,23.22,21.5,21.59,23.53,23.91,22.88,23.38,25.41,25.66,24.0,23.19,24.84,27.0,26.97,26.06,26.38,25.97,22.88,18.44,16.31,16.31,16.0,14.66,14.34,16.06,17.31,16.56,15.81,18.28,21.47,22.72,23.41,26.06,29.03,29.81,28.75,29.12,30.97,31.16,29.19,27.06,26.81,25.41,21.62,18.09,17.59,18.19,18.0,18.03,20.47,24.16,25.91,25.88,26.59,28.41,29.19,27.91,27.0,28.22,29.06,27.5,25.31,25.44,26.25,25.69,24.5,24.81,26.59,27.03,25.69,25.47,26.94,27.38,25.28,22.56,21.78,21.06,18.97,16.72,17.31,19.69,20.72,20.38,20.81,22.78,23.09,21.56,20.19,20.88,21.0,18.5,15.44,15.22,16.25,15.91,15.66,17.78,21.06,22.59,23.0,23.78,26.44,28.53,27.69,26.75,27.41,28.06,25.59,22.41,21.06,20.75,18.84,15.91,14.94,15.69,15.69,14.38,14.25,16.31,18.31,18.0,17.41,18.69,20.38,19.75,17.91,17.78,18.44,17.5,14.94,14.19,15.25,15.62,14.16,13.12,15.16,17.06,17.09,16.81,18.62,20.97,21.28,20.19,20.91,22.75,23.5,22.28,22.22,24.38,26.31,25.91,25.88,28.06,30.0,28.66,25.94,24.25,23.28,20.28,16.38,14.81,15.56,15.81,14.66,14.72,16.62,18.31,17.5,16.53,18.25,20.84,21.78,22.03,24.0,26.66,27.25,25.44,24.84,25.53,25.59,22.84,20.69,20.91,21.66,20.62,19.75,21.38,23.81,24.69,24.41,26.34,29.97,32.16,32.41,33.22,35.94,37.72,36.75,35.53,36.09,36.25,33.84,30.12,28.09,27.34,24.84,20.88,19.0,19.22,18.94,17.25,16.59,18.28,20.31,19.72,19.44,21.75,25.38,26.44,25.97,26.75,27.97,27.09,24.34,23.16,24.38,25.0,23.88,23.5,25.53,28.16,28.56,28.88,30.81,33.06,32.78,30.69,30.09,30.97,30.97,29.19,28.5,29.25,29.44,26.94,24.91,25.66,27.22,26.88,25.91,26.53,28.5,28.62,27.19,27.75,30.31,31.84,31.31,30.81,32.22,32.78,30.53,28.03,28.09,29.31,28.75,27.06,26.72,27.03,25.41,22.16,20.09,20.97,22.56,22.38,23.66,27.12,30.22,30.03,28.12,27.53,27.56,26.06,23.72,24.0,26.03,26.97,25.69,24.59,25.03,24.78,22.28,19.94,20.88,22.47,21.53,19.94,20.5,22.28,22.56,21.94,23.16,26.31,27.94,26.69,25.31,25.78,26.06,24.09,22.34,22.94,24.72,24.72,23.66,24.56,27.09,27.72,26.28,25.5,26.72,27.16,25.03,23.56,24.62,26.16,25.19,24.88,26.84,29.53,30.34,29.19,28.59,29.03,28.12,25.5,24.56,26.47,28.62,28.5,28.88,31.22,33.84,33.41,31.78,31.97,32.66,31.75,30.06,29.84,31.44,32.12,30.56,29.03,29.78,30.19,28.34,25.91,25.53,26.09,23.88,21.16,20.75,22.53,23.56,23.88,25.72,30.28,33.59,34.25,34.41,35.66,36.09,33.41,30.09,29.06,29.28,27.97,25.72,25.62,27.28,27.91,26.97,27.69,30.62,32.94,32.78,32.31,33.56,34.81,33.56,31.0,30.31,30.84,29.81,27.44,26.59,27.0,26.41,23.5,21.28,21.78,22.41,21.62,20.84,23.25,26.28,26.88,26.09,26.56,27.97,28.28,27.09,27.19,29.81,31.06,29.84,19.19,17.0,15.62,16.25,17.38,17.66,17.94:28.97,28.44,30.06,31.25,30.31,29.81,31.28,33.0,31.75,29.28,27.88,27.44,25.28,21.88,20.94,22.75,24.16,23.75,23.88,25.81,27.25,26.09,24.84,25.75,27.62,28.22,27.72,29.06,31.88,33.09,32.72,32.84,34.81,35.81,34.62,33.28,34.12,35.16,33.91,32.28,32.38,33.56,32.72,30.47,30.03,31.47,32.25,31.56,31.62,33.66,35.03,34.41,33.91,35.72,38.19,37.97,36.81,36.56,36.94,35.03,31.91,30.03,30.5,30.19,28.34,27.06,27.53,28.09,26.66,25.06,26.28,28.5,29.09,28.84,30.09,32.16,32.69,31.28,30.5,31.84,32.5,31.41,30.66,32.31,34.28,34.25,33.75,35.16,37.12,37.59,36.66,36.25,37.19,36.19,32.53,29.09,27.88,26.75,23.91,21.56,22.16,23.53,22.78,21.78,22.56,24.97,26.12,26.41,28.0,31.78,34.75,35.0,35.06,36.44,37.03,34.91,32.12,31.25,31.12,29.31,26.66,26.06,26.97,26.56,24.12,22.41,23.25,24.03,23.59,23.97,26.75,29.47,29.41,27.78,28.03,28.94,28.38,26.41,25.75,26.59,26.41,24.53,23.12,24.69,25.97,24.94,23.69,24.5,25.38,24.19,21.81,21.16,22.16,22.22,20.97,21.31,23.78,25.53,25.22,24.81,26.75,28.59,28.81,28.84,31.12,34.5,35.81,35.22,35.72,37.47,38.62,37.66,37.69,39.94,41.06,39.12,36.38,35.59,35.0,32.66,29.72,29.09,29.78,28.84,26.16,24.56,25.03,24.59,22.78,21.94,24.0,26.78,27.25,27.47,29.56,31.62,31.66,30.34,30.41,32.06,32.34,30.69,29.84,30.75,30.62,28.19,25.59,25.31,25.31,23.41,21.0,20.72,21.94,21.56,20.09,20.53,22.44,23.66,22.59,22.59,24.69,26.59,25.88,24.81,25.47,26.53,25.31,22.91,22.91,24.09,24.69,24.44,26.09,29.88,31.94,31.25,29.56,29.09,28.16,25.03,21.81,21.97,23.72,24.56,24.88,27.0,30.0,31.25,29.91,28.66,29.59,30.22,28.69,27.78,29.47,30.94,29.84,27.56,26.91,27.47,26.59,24.47,23.97,25.38,26.34,25.09,25.25,27.53,29.91,29.81,29.22,29.88,30.81,28.66,24.88,22.75,22.0,20.22,17.5,16.59,18.25,20.5,21.06,22.59,26.69,30.97,32.53,33.62,35.72,38.19,38.41,36.34,35.06,35.31,34.19,31.34,29.62,30.75,31.81,30.91,30.16,31.38,33.28,32.34,30.91,30.84,32.03,31.44,29.47,29.25,30.66,31.72,30.28,29.06,29.84,30.22,28.09,25.78,26.41,28.56,29.03,28.66,30.22,32.88,33.91,33.12,32.97,35.25,36.66,35.12,33.5,33.41,33.22,30.28,26.38,24.88,24.91,23.0,19.72,18.03,18.34,18.22,16.91,17.03,20.66,23.88,24.41,24.5,26.47,28.97,29.81,30.47,33.28,37.19,38.5,36.81,35.25,34.84,33.59,30.5,28.69,30.03,31.91,31.72,31.59,33.28,36.09,36.19,34.62,34.38,35.66,35.19,33.0,32.19,33.19,33.25,31.06,29.5,30.72,33.25,34.38,35.56,39.28,43.56,45.72,45.81,46.69,48.41,48.06,44.44,40.25,38.06,35.0,29.56,24.84,23.59,23.81,22.72,21.25,21.62,23.41,23.5,22.25,22.09,24.22,25.44,24.53,23.91,25.97,28.12,27.59,26.31,26.97,27.91,26.94,25.0,25.44,28.28,29.91,30.34,31.69,35.81,39.38,40.44,41.47,44.66,47.38,47.25,46.03,46.22,47.12,46.06,43.09,41.03,40.5,38.72,35.22,32.03,30.94,29.56,25.75,21.88,20.56,20.59,19.09,16.66,16.78,19.03,20.44,20.22,21.81,25.28,27.34,26.72,25.62,26.06,25.94,23.81,21.78,22.72,25.78,27.22,27.62,29.28,31.75,32.16,30.72,29.56,31.31,32.88,32.91,32.97,34.88,36.88,36.59,35.59,36.75,39.66,41.0,40.72,41.31,42.72,42.44,38.94,35.91,35.19,34.97,32.94,30.72,30.97,31.22,29.53,26.41,24.78,24.5,23.25,20.72,19.34,20.69,21.53,20.38,19.75,21.69,23.81,24.22,23.66,25.03,27.06,27.34,26.44,26.41,28.34,28.72,26.88,25.94,27.62,29.41,29.28,29.25,31.38,33.59,32.97,30.62,29.41,28.78,27.0,24.12,23.81,26.22,28.75,29.25,30.19,33.22,35.91,35.22,33.47,33.44,34.25,32.94,30.47,30.41,31.53,31.31,28.97,27.25,27.16,26.41,23.44,21.44,22.41,24.78,25.66,25.56,27.28,29.25,29.31,27.66,27.84,30.38,32.5,32.56,33.47,36.16,37.94,36.53,34.56,34.28,34.03,31.38,28.25,27.31,28.22,28.56,27.34,28.09,30.19,32.06,31.25,30.69,31.75,33.25,32.12,30.75,31.78,33.5,33.0,30.94,30.03,30.09,29.22,26.09,24.31,24.94,26.16,25.28,24.84,27.06,29.62,29.59,28.69,29.41,31.25,31.41,30.16,30.47,32.31,33.19,31.59,30.53,31.84,33.75,33.69,33.25,35.09,37.19,37.34,36.06,36.34,37.53,36.75,33.97,31.88,32.06,31.78,29.16,27.12,27.22,27.47,25.34,22.78,22.44,22.72,20.94,17.94,16.47,17.0,16.84,15.09,14.28,15.91,17.41,16.88,16.84,19.44,22.72,23.5,23.28,24.59,26.56,27.06,26.16,26.5,28.5,29.41,27.5,25.5,25.28,25.03,23.12,21.72,22.56,24.69,24.75,23.53,23.62,25.12,24.72,22.12,20.69,21.25,21.31,19.41,18.38,19.91,22.5,22.94,23.03,24.53,26.34,25.47,23.12,22.06,22.94,23.38,22.06,21.88,23.19,24.16,22.66,20.56,20.72,21.88,21.19,20.31,21.06,23.53,24.59,24.38,24.91,27.16,28.22,26.84,25.31,25.69,25.75,23.44,20.47,19.78,20.03,19.16,17.56,17.28,18.97,19.56,18.72,18.75,21.06,23.0,22.25,21.31,22.31,23.84,23.22,21.5,21.59,23.53,23.91,22.88,23.38,25.41,25.66,24.0,23.19,24.84,27.0,26.97,26.06,26.38,25.97,22.88,18.44,16.31,16.31,16.0,14.66,14.34,16.06,17.31,16.56,15.81,18.28,21.47,22.72,23.41,26.06,29.03,29.81,28.75,29.12,30.97,31.16,29.19,27.06,26.81,25.41,21.62,18.09,17.59,18.19,18.0,18.03,20.47,24.16,25.91,25.88,26.59,28.41,29.19,27.91,27.0,28.22,29.06,27.5,25.31,25.44,26.25,25.69,24.5,24.81,26.59,27.03,25.69,25.47,26.94,27.38,25.28,22.56,21.78,21.06,18.97,16.72,17.31,19.69,20.72,20.38,20.81,22.78,23.09,21.56,20.19,20.88,21.0,18.5,15.44,15.22,16.25,15.91,15.66,17.78,21.06,22.59,23.0,23.78,26.44,28.53,27.69,26.75,27.41,28.06,25.59,22.41,21.06,20.75,18.84,15.91,14.94,15.69,15.69,14.38,14.25,16.31,18.31,18.0,17.41,18.69,20.38,19.75,17.91,17.78,18.44,17.5,14.94,14.19,15.25,15.62,14.16,13.12,15.16,17.06,17.09,16.81,18.62,20.97,21.28,20.19,20.91,22.75,23.5,22.28,22.22,24.38,26.31,25.91,25.88,28.06,30.0,28.66,25.94,24.25,23.28,20.28,16.38,14.81,15.56,15.81,14.66,14.72,16.62,18.31,17.5,16.53,18.25,20.84,21.78,22.03,24.0,26.66,27.25,25.44,24.84,25.53,25.59,22.84,20.69,20.91,21.66,20.62,19.75,21.38,23.81,24.69,24.41,26.34,29.97,32.16,32.41,33.22,35.94,37.72,36.75,35.53,36.09,36.25,33.84,30.12,28.09,27.34,24.84,20.88,19.0,19.22,18.94,17.25,16.59,18.28,20.31,19.72,19.44,21.75,25.38,26.44,25.97,26.75,27.97,27.09,24.34,23.16,24.38,25.0,23.88,23.5,25.53,28.16,28.56,28.88,30.81,33.06,32.78,30.69,30.09,30.97,30.97,29.19,28.5,29.25,29.44,26.94,24.91,25.66,27.22,26.88,25.91,26.53,28.5,28.62,27.19,27.75,30.31,31.84,31.31,30.81,32.22,32.78,30.53,28.03,28.09,29.31,28.75,27.06,26.72,27.03,25.41,22.16,20.09,20.97,22.56,22.38,23.66,27.12,30.22,30.03,28.12,27.53,27.56,26.06,23.72,24.0,26.03,26.97,25.69,24.59,25.03,24.78,22.28,19.94,20.88,22.47,21.53,19.94,20.5,22.28,22.56,21.94,23.16,26.31,27.94,26.69,25.31,25.78,26.06,24.09,22.34,22.94,24.72,24.72,23.66,24.56,27.09,27.72,26.28,25.5,26.72,27.16,25.03,23.56,24.62,26.16,25.19,24.88,26.84,29.53,30.34,29.19,28.59,29.03,28.12,25.5,24.56,26.47,28.62,28.5,28.88,31.22,33.84,33.41,31.78,31.97,32.66,31.75,30.06,29.84,31.44,32.12,30.56,29.03,29.78,30.19,28.34,25.91,25.53,26.09,23.88,21.16,20.75,22.53,23.56,23.88,25.72,30.28,33.59,34.25,34.41,35.66,36.09,33.41,30.09,29.06,29.28,27.97,25.72,25.62,27.28,27.91,26.97,27.69,30.62,32.94,32.78,32.31,33.56,34.81,33.56,31.0,30.31,30.84,29.81,27.44,26.59,27.0,26.41,23.5,21.28,21.78,22.41,21.62,20.84,23.25,26.28,26.88,26.09,26.56,27.97,28.28,27.09,27.19,29.81,31.06,29.84,19.19,17.0,15.62,16.25,17.38,17.66,17.94,19.69,22.0,22.47,22.44,23.03,23.84,23.56:33.0,31.75,29.28,27.88,27.44,25.28,21.88,20.94,22.75,24.16,23.75,23.88,25.81,27.25,26.09,24.84,25.75,27.62,28.22,27.72,29.06,31.88,33.09,32.72,32.84,34.81,35.81,34.62,33.28,34.12,35.16,33.91,32.28,32.38,33.56,32.72,30.47,30.03,31.47,32.25,31.56,31.62,33.66,35.03,34.41,33.91,35.72,38.19,37.97,36.81,36.56,36.94,35.03,31.91,30.03,30.5,30.19,28.34,27.06,27.53,28.09,26.66,25.06,26.28,28.5,29.09,28.84,30.09,32.16,32.69,31.28,30.5,31.84,32.5,31.41,30.66,32.31,34.28,34.25,33.75,35.16,37.12,37.59,36.66,36.25,37.19,36.19,32.53,29.09,27.88,26.75,23.91,21.56,22.16,23.53,22.78,21.78,22.56,24.97,26.12,26.41,28.0,31.78,34.75,35.0,35.06,36.44,37.03,34.91,32.12,31.25,31.12,29.31,26.66,26.06,26.97,26.56,24.12,22.41,23.25,24.03,23.59,23.97,26.75,29.47,29.41,27.78,28.03,28.94,28.38,26.41,25.75,26.59,26.41,24.53,23.12,24.69,25.97,24.94,23.69,24.5,25.38,24.19,21.81,21.16,22.16,22.22,20.97,21.31,23.78,25.53,25.22,24.81,26.75,28.59,28.81,28.84,31.12,34.5,35.81,35.22,35.72,37.47,38.62,37.66,37.69,39.94,41.06,39.12,36.38,35.59,35.0,32.66,29.72,29.09,29.78,28.84,26.16,24.56,25.03,24.59,22.78,21.94,24.0,26.78,27.25,27.47,29.56,31.62,31.66,30.34,30.41,32.06,32.34,30.69,29.84,30.75,30.62,28.19,25.59,25.31,25.31,23.41,21.0,20.72,21.94,21.56,20.09,20.53,22.44,23.66,22.59,22.59,24.69,26.59,25.88,24.81,25.47,26.53,25.31,22.91,22.91,24.09,24.69,24.44,26.09,29.88,31.94,31.25,29.56,29.09,28.16,25.03,21.81,21.97,23.72,24.56,24.88,27.0,30.0,31.25,29.91,28.66,29.59,30.22,28.69,27.78,29.47,30.94,29.84,27.56,26.91,27.47,26.59,24.47,23.97,25.38,26.34,25.09,25.25,27.53,29.91,29.81,29.22,29.88,30.81,28.66,24.88,22.75,22.0,20.22,17.5,16.59,18.25,20.5,21.06,22.59,26.69,30.97,32.53,33.62,35.72,38.19,38.41,36.34,35.06,35.31,34.19,31.34,29.62,30.75,31.81,30.91,30.16,31.38,33.28,32.34,30.91,30.84,32.03,31.44,29.47,29.25,30.66,31.72,30.28,29.06,29.84,30.22,28.09,25.78,26.41,28.56,29.03,28.66,30.22,32.88,33.91,33.12,32.97,35.25,36.66,35.12,33.5,33.41,33.22,30.28,26.38,24.88,24.91,23.0,19.72,18.03,18.34,18.22,16.91,17.03,20.66,23.88,24.41,24.5,26.47,28.97,29.81,30.47,33.28,37.19,38.5,36.81,35.25,34.84,33.59,30.5,28.69,30.03,31.91,31.72,31.59,33.28,36.09,36.19,34.62,34.38,35.66,35.19,33.0,32.19,33.19,33.25,31.06,29.5,30.72,33.25,34.38,35.56,39.28,43.56,45.72,45.81,46.69,48.41,48.06,44.44,40.25,38.06,35.0,29.56,24.84,23.59,23.81,22.72,21.25,21.62,23.41,23.5,22.25,22.09,24.22,25.44,24.53,23.91,25.97,28.12,27.59,26.31,26.97,27.91,26.94,25.0,25.44,28.28,29.91,30.34,31.69,35.81,39.38,40.44,41.47,44.66,47.38,47.25,46.03,46.22,47.12,46.06,43.09,41.03,40.5,38.72,35.22,32.03,30.94,29.56,25.75,21.88,20.56,20.59,19.09,16.66,16.78,19.03,20.44,20.22,21.81,25.28,27.34,26.72,25.62,26.06,25.94,23.81,21.78,22.72,25.78,27.22,27.62,29.28,31.75,32.16,30.72,29.56,31.31,32.88,32.91,32.97,34.88,36.88,36.59,35.59,36.75,39.66,41.0,40.72,41.31,42.72,42.44,38.94,35.91,35.19,34.97,32.94,30.72,30.97,31.22,29.53,26.41,24.78,24.5,23.25,20.72,19.34,20.69,21.53,20.38,19.75,21.69,23.81,24.22,23.66,25.03,27.06,27.34,26.44,26.41,28.34,28.72,26.88,25.94,27.62,29.41,29.28,29.25,31.38,33.59,32.97,30.62,29.41,28.78,27.0,24.12,23.81,26.22,28.75,29.25,30.19,33.22,35.91,35.22,33.47,33.44,34.25,32.94,30.47,30.41,31.53,31.31,28.97,27.25,27.16,26.41,23.44,21.44,22.41,24.78,25.66,25.56,27.28,29.25,29.31,27.66,27.84,30.38,32.5,32.56,33.47,36.16,37.94,36.53,34.56,34.28,34.03,31.38,28.25,27.31,28.22,28.56,27.34,28.09,30.19,32.06,31.25,30.69,31.75,33.25,32.12,30.75,31.78,33.5,33.0,30.94,30.03,30.09,29.22,26.09,24.31,24.94,26.16,25.28,24.84,27.06,29.62,29.59,28.69,29.41,31.25,31.41,30.16,30.47,32.31,33.19,31.59,30.53,31.84,33.75,33.69,33.25,35.09,37.19,37.34,36.06,36.34,37.53,36.75,33.97,31.88,32.06,31.78,29.16,27.12,27.22,27.47,25.34,22.78,22.44,22.72,20.94,17.94,16.47,17.0,16.84,15.09,14.28,15.91,17.41,16.88,16.84,19.44,22.72,23.5,23.28,24.59,26.56,27.06,26.16,26.5,28.5,29.41,27.5,25.5,25.28,25.03,23.12,21.72,22.56,24.69,24.75,23.53,23.62,25.12,24.72,22.12,20.69,21.25,21.31,19.41,18.38,19.91,22.5,22.94,23.03,24.53,26.34,25.47,23.12,22.06,22.94,23.38,22.06,21.88,23.19,24.16,22.66,20.56,20.72,21.88,21.19,20.31,21.06,23.53,24.59,24.38,24.91,27.16,28.22,26.84,25.31,25.69,25.75,23.44,20.47,19.78,20.03,19.16,17.56,17.28,18.97,19.56,18.72,18.75,21.06,23.0,22.25,21.31,22.31,23.84,23.22,21.5,21.59,23.53,23.91,22.88,23.38,25.41,25.66,24.0,23.19,24.84,27.0,26.97,26.06,26.38,25.97,22.88,18.44,16.31,16.31,16.0,14.66,14.34,16.06,17.31,16.56,15.81,18.28,21.47,22.72,23.41,26.06,29.03,29.81,28.75,29.12,30.97,31.16,29.19,27.06,26.81,25.41,21.62,18.09,17.59,18.19,18.0,18.03,20.47,24.16,25.91,25.88,26.59,28.41,29.19,27.91,27.0,28.22,29.06,27.5,25.31,25.44,26.25,25.69,24.5,24.81,26.59,27.03,25.69,25.47,26.94,27.38,25.28,22.56,21.78,21.06,18.97,16.72,17.31,19.69,20.72,20.38,20.81,22.78,23.09,21.56,20.19,20.88,21.0,18.5,15.44,15.22,16.25,15.91,15.66,17.78,21.06,22.59,23.0,23.78,26.44,28.53,27.69,26.75,27.41,28.06,25.59,22.41,21.06,20.75,18.84,15.91,14.94,15.69,15.69,14.38,14.25,16.31,18.31,18.0,17.41,18.69,20.38,19.75,17.91,17.78,18.44,17.5,14.94,14.19,15.25,15.62,14.16,13.12,15.16,17.06,17.09,16.81,18.62,20.97,21.28,20.19,20.91,22.75,23.5,22.28,22.22,24.38,26.31,25.91,25.88,28.06,30.0,28.66,25.94,24.25,23.28,20.28,16.38,14.81,15.56,15.81,14.66,14.72,16.62,18.31,17.5,16.53,18.25,20.84,21.78,22.03,24.0,26.66,27.25,25.44,24.84,25.53,25.59,22.84,20.69,20.91,21.66,20.62,19.75,21.38,23.81,24.69,24.41,26.34,29.97,32.16,32.41,33.22,35.94,37.72,36.75,35.53,36.09,36.25,33.84,30.12,28.09,27.34,24.84,20.88,19.0,19.22,18.94,17.25,16.59,18.28,20.31,19.72,19.44,21.75,25.38,26.44,25.97,26.75,27.97,27.09,24.34,23.16,24.38,25.0,23.88,23.5,25.53,28.16,28.56,28.88,30.81,33.06,32.78,30.69,30.09,30.97,30.97,29.19,28.5,29.25,29.44,26.94,24.91,25.66,27.22,26.88,25.91,26.53,28.5,28.62,27.19,27.75,30.31,31.84,31.31,30.81,32.22,32.78,30.53,28.03,28.09,29.31,28.75,27.06,26.72,27.03,25.41,22.16,20.09,20.97,22.56,22.38,23.66,27.12,30.22,30.03,28.12,27.53,27.56,26.06,23.72,24.0,26.03,26.97,25.69,24.59,25.03,24.78,22.28,19.94,20.88,22.47,21.53,19.94,20.5,22.28,22.56,21.94,23.16,26.31,27.94,26.69,25.31,25.78,26.06,24.09,22.34,22.94,24.72,24.72,23.66,24.56,27.09,27.72,26.28,25.5,26.72,27.16,25.03,23.56,24.62,26.16,25.19,24.88,26.84,29.53,30.34,29.19,28.59,29.03,28.12,25.5,24.56,26.47,28.62,28.5,28.88,31.22,33.84,33.41,31.78,31.97,32.66,31.75,30.06,29.84,31.44,32.12,30.56,29.03,29.78,30.19,28.34,25.91,25.53,26.09,23.88,21.16,20.75,22.53,23.56,23.88,25.72,30.28,33.59,34.25,34.41,35.66,36.09,33.41,30.09,29.06,29.28,27.97,25.72,25.62,27.28,27.91,26.97,27.69,30.62,32.94,32.78,32.31,33.56,34.81,33.56,31.0,30.31,30.84,29.81,27.44,26.59,27.0,26.41,23.5,21.28,21.78,22.41,21.62,20.84,23.25,26.28,26.88,26.09,26.56,27.97,28.28,27.09,27.19,29.81,31.06,29.84,19.19,17.0,15.62,16.25,17.38,17.66,17.94,19.69,22.0,22.47,22.44,23.03,23.84,23.56,21.78,21.19,21.66,22.0,21.56,21.59,23.12:20.94,22.75,24.16,23.75,23.88,25.81,27.25,26.09,24.84,25.75,27.62,28.22,27.72,29.06,31.88,33.09,32.72,32.84,34.81,35.81,34.62,33.28,34.12,35.16,33.91,32.28,32.38,33.56,32.72,30.47,30.03,31.47,32.25,31.56,31.62,33.66,35.03,34.41,33.91,35.72,38.19,37.97,36.81,36.56,36.94,35.03,31.91,30.03,30.5,30.19,28.34,27.06,27.53,28.09,26.66,25.06,26.28,28.5,29.09,28.84,30.09,32.16,32.69,31.28,30.5,31.84,32.5,31.41,30.66,32.31,34.28,34.25,33.75,35.16,37.12,37.59,36.66,36.25,37.19,36.19,32.53,29.09,27.88,26.75,23.91,21.56,22.16,23.53,22.78,21.78,22.56,24.97,26.12,26.41,28.0,31.78,34.75,35.0,35.06,36.44,37.03,34.91,32.12,31.25,31.12,29.31,26.66,26.06,26.97,26.56,24.12,22.41,23.25,24.03,23.59,23.97,26.75,29.47,29.41,27.78,28.03,28.94,28.38,26.41,25.75,26.59,26.41,24.53,23.12,24.69,25.97,24.94,23.69,24.5,25.38,24.19,21.81,21.16,22.16,22.22,20.97,21.31,23.78,25.53,25.22,24.81,26.75,28.59,28.81,28.84,31.12,34.5,35.81,35.22,35.72,37.47,38.62,37.66,37.69,39.94,41.06,39.12,36.38,35.59,35.0,32.66,29.72,29.09,29.78,28.84,26.16,24.56,25.03,24.59,22.78,21.94,24.0,26.78,27.25,27.47,29.56,31.62,31.66,30.34,30.41,32.06,32.34,30.69,29.84,30.75,30.62,28.19,25.59,25.31,25.31,23.41,21.0,20.72,21.94,21.56,20.09,20.53,22.44,23.66,22.59,22.59,24.69,26.59,25.88,24.81,25.47,26.53,25.31,22.91,22.91,24.09,24.69,24.44,26.09,29.88,31.94,31.25,29.56,29.09,28.16,25.03,21.81,21.97,23.72,24.56,24.88,27.0,30.0,31.25,29.91,28.66,29.59,30.22,28.69,27.78,29.47,30.94,29.84,27.56,26.91,27.47,26.59,24.47,23.97,25.38,26.34,25.09,25.25,27.53,29.91,29.81,29.22,29.88,30.81,28.66,24.88,22.75,22.0,20.22,17.5,16.59,18.25,20.5,21.06,22.59,26.69,30.97,32.53,33.62,35.72,38.19,38.41,36.34,35.06,35.31,34.19,31.34,29.62,30.75,31.81,30.91,30.16,31.38,33.28,32.34,30.91,30.84,32.03,31.44,29.47,29.25,30.66,31.72,30.28,29.06,29.84,30.22,28.09,25.78,26.41,28.56,29.03,28.66,30.22,32.88,33.91,33.12,32.97,35.25,36.66,35.12,33.5,33.41,33.22,30.28,26.38,24.88,24.91,23.0,19.72,18.03,18.34,18.22,16.91,17.03,20.66,23.88,24.41,24.5,26.47,28.97,29.81,30.47,33.28,37.19,38.5,36.81,35.25,34.84,33.59,30.5,28.69,30.03,31.91,31.72,31.59,33.28,36.09,36.19,34.62,34.38,35.66,35.19,33.0,32.19,33.19,33.25,31.06,29.5,30.72,33.25,34.38,35.56,39.28,43.56,45.72,45.81,46.69,48.41,48.06,44.44,40.25,38.06,35.0,29.56,24.84,23.59,23.81,22.72,21.25,21.62,23.41,23.5,22.25,22.09,24.22,25.44,24.53,23.91,25.97,28.12,27.59,26.31,26.97,27.91,26.94,25.0,25.44,28.28,29.91,30.34,31.69,35.81,39.38,40.44,41.47,44.66,47.38,47.25,46.03,46.22,47.12,46.06,43.09,41.03,40.5,38.72,35.22,32.03,30.94,29.56,25.75,21.88,20.56,20.59,19.09,16.66,16.78,19.03,20.44,20.22,21.81,25.28,27.34,26.72,25.62,26.06,25.94,23.81,21.78,22.72,25.78,27.22,27.62,29.28,31.75,32.16,30.72,29.56,31.31,32.88,32.91,32.97,34.88,36.88,36.59,35.59,36.75,39.66,41.0,40.72,41.31,42.72,42.44,38.94,35.91,35.19,34.97,32.94,30.72,30.97,31.22,29.53,26.41,24.78,24.5,23.25,20.72,19.34,20.69,21.53,20.38,19.75,21.69,23.81,24.22,23.66,25.03,27.06,27.34,26.44,26.41,28.34,28.72,26.88,25.94,27.62,29.41,29.28,29.25,31.38,33.59,32.97,30.62,29.41,28.78,27.0,24.12,23.81,26.22,28.75,29.25,30.19,33.22,35.91,35.22,33.47,33.44,34.25,32.94,30.47,30.41,31.53,31.31,28.97,27.25,27.16,26.41,23.44,21.44,22.41,24.78,25.66,25.56,27.28,29.25,29.31,27.66,27.84,30.38,32.5,32.56,33.47,36.16,37.94,36.53,34.56,34.28,34.03,31.38,28.25,27.31,28.22,28.56,27.34,28.09,30.19,32.06,31.25,30.69,31.75,33.25,32.12,30.75,31.78,33.5,33.0,30.94,30.03,30.09,29.22,26.09,24.31,24.94,26.16,25.28,24.84,27.06,29.62,29.59,28.69,29.41,31.25,31.41,30.16,30.47,32.31,33.19,31.59,30.53,31.84,33.75,33.69,33.25,35.09,37.19,37.34,36.06,36.34,37.53,36.75,33.97,31.88,32.06,31.78,29.16,27.12,27.22,27.47,25.34,22.78,22.44,22.72,20.94,17.94,16.47,17.0,16.84,15.09,14.28,15.91,17.41,16.88,16.84,19.44,22.72,23.5,23.28,24.59,26.56,27.06,26.16,26.5,28.5,29.41,27.5,25.5,25.28,25.03,23.12,21.72,22.56,24.69,24.75,23.53,23.62,25.12,24.72,22.12,20.69,21.25,21.31,19.41,18.38,19.91,22.5,22.94,23.03,24.53,26.34,25.47,23.12,22.06,22.94,23.38,22.06,21.88,23.19,24.16,22.66,20.56,20.72,21.88,21.19,20.31,21.06,23.53,24.59,24.38,24.91,27.16,28.22,26.84,25.31,25.69,25.75,23.44,20.47,19.78,20.03,19.16,17.56,17.28,18.97,19.56,18.72,18.75,21.06,23.0,22.25,21.31,22.31,23.84,23.22,21.5,21.59,23.53,23.91,22.88,23.38,25.41,25.66,24.0,23.19,24.84,27.0,26.97,26.06,26.38,25.97,22.88,18.44,16.31,16.31,16.0,14.66,14.34,16.06,17.31,16.56,15.81,18.28,21.47,22.72,23.41,26.06,29.03,29.81,28.75,29.12,30.97,31.16,29.19,27.06,26.81,25.41,21.62,18.09,17.59,18.19,18.0,18.03,20.47,24.16,25.91,25.88,26.59,28.41,29.19,27.91,27.0,28.22,29.06,27.5,25.31,25.44,26.25,25.69,24.5,24.81,26.59,27.03,25.69,25.47,26.94,27.38,25.28,22.56,21.78,21.06,18.97,16.72,17.31,19.69,20.72,20.38,20.81,22.78,23.09,21.56,20.19,20.88,21.0,18.5,15.44,15.22,16.25,15.91,15.66,17.78,21.06,22.59,23.0,23.78,26.44,28.53,27.69,26.75,27.41,28.06,25.59,22.41,21.06,20.75,18.84,15.91,14.94,15.69,15.69,14.38,14.25,16.31,18.31,18.0,17.41,18.69,20.38,19.75,17.91,17.78,18.44,17.5,14.94,14.19,15.25,15.62,14.16,13.12,15.16,17.06,17.09,16.81,18.62,20.97,21.28,20.19,20.91,22.75,23.5,22.28,22.22,24.38,26.31,25.91,25.88,28.06,30.0,28.66,25.94,24.25,23.28,20.28,16.38,14.81,15.56,15.81,14.66,14.72,16.62,18.31,17.5,16.53,18.25,20.84,21.78,22.03,24.0,26.66,27.25,25.44,24.84,25.53,25.59,22.84,20.69,20.91,21.66,20.62,19.75,21.38,23.81,24.69,24.41,26.34,29.97,32.16,32.41,33.22,35.94,37.72,36.75,35.53,36.09,36.25,33.84,30.12,28.09,27.34,24.84,20.88,19.0,19.22,18.94,17.25,16.59,18.28,20.31,19.72,19.44,21.75,25.38,26.44,25.97,26.75,27.97,27.09,24.34,23.16,24.38,25.0,23.88,23.5,25.53,28.16,28.56,28.88,30.81,33.06,32.78,30.69,30.09,30.97,30.97,29.19,28.5,29.25,29.44,26.94,24.91,25.66,27.22,26.88,25.91,26.53,28.5,28.62,27.19,27.75,30.31,31.84,31.31,30.81,32.22,32.78,30.53,28.03,28.09,29.31,28.75,27.06,26.72,27.03,25.41,22.16,20.09,20.97,22.56,22.38,23.66,27.12,30.22,30.03,28.12,27.53,27.56,26.06,23.72,24.0,26.03,26.97,25.69,24.59,25.03,24.78,22.28,19.94,20.88,22.47,21.53,19.94,20.5,22.28,22.56,21.94,23.16,26.31,27.94,26.69,25.31,25.78,26.06,24.09,22.34,22.94,24.72,24.72,23.66,24.56,27.09,27.72,26.28,25.5,26.72,27.16,25.03,23.56,24.62,26.16,25.19,24.88,26.84,29.53,30.34,29.19,28.59,29.03,28.12,25.5,24.56,26.47,28.62,28.5,28.88,31.22,33.84,33.41,31.78,31.97,32.66,31.75,30.06,29.84,31.44,32.12,30.56,29.03,29.78,30.19,28.34,25.91,25.53,26.09,23.88,21.16,20.75,22.53,23.56,23.88,25.72,30.28,33.59,34.25,34.41,35.66,36.09,33.41,30.09,29.06,29.28,27.97,25.72,25.62,27.28,27.91,26.97,27.69,30.62,32.94,32.78,32.31,33.56,34.81,33.56,31.0,30.31,30.84,29.81,27.44,26.59,27.0,26.41,23.5,21.28,21.78,22.41,21.62,20.84,23.25,26.28,26.88,26.09,26.56,27.97,28.28,27.09,27.19,29.81,31.06,29.84,19.19,17.0,15.62,16.25,17.38,17.66,17.94,19.69,22.0,22.47,22.44,23.03,23.84,23.56,21.78,21.19,21.66,22.0,21.56,21.59,23.12,24.56,24.38,23.22,22.62,22.25,20.38,18.28:26.09,24.84,25.75,27.62,28.22,27.72,29.06,31.88,33.09,32.72,32.84,34.81,35.81,34.62,33.28,34.12,35.16,33.91,32.28,32.38,33.56,32.72,30.47,30.03,31.47,32.25,31.56,31.62,33.66,35.03,34.41,33.91,35.72,38.19,37.97,36.81,36.56,36.94,35.03,31.91,30.03,30.5,30.19,28.34,27.06,27.53,28.09,26.66,25.06,26.28,28.5,29.09,28.84,30.09,32.16,32.69,31.28,30.5,31.84,32.5,31.41,30.66,32.31,34.28,34.25,33.75,35.16,37.12,37.59,36.66,36.25,37.19,36.19,32.53,29.09,27.88,26.75,23.91,21.56,22.16,23.53,22.78,21.78,22.56,24.97,26.12,26.41,28.0,31.78,34.75,35.0,35.06,36.44,37.03,34.91,32.12,31.25,31.12,29.31,26.66,26.06,26.97,26.56,24.12,22.41,23.25,24.03,23.59,23.97,26.75,29.47,29.41,27.78,28.03,28.94,28.38,26.41,25.75,26.59,26.41,24.53,23.12,24.69,25.97,24.94,23.69,24.5,25.38,24.19,21.81,21.16,22.16,22.22,20.97,21.31,23.78,25.53,25.22,24.81,26.75,28.59,28.81,28.84,31.12,34.5,35.81,35.22,35.72,37.47,38.62,37.66,37.69,39.94,41.06,39.12,36.38,35.59,35.0,32.66,29.72,29.09,29.78,28.84,26.16,24.56,25.03,24.59,22.78,21.94,24.0,26.78,27.25,27.47,29.56,31.62,31.66,30.34,30.41,32.06,32.34,30.69,29.84,30.75,30.62,28.19,25.59,25.31,25.31,23.41,21.0,20.72,21.94,21.56,20.09,20.53,22.44,23.66,22.59,22.59,24.69,26.59,25.88,24.81,25.47,26.53,25.31,22.91,22.91,24.09,24.69,24.44,26.09,29.88,31.94,31.25,29.56,29.09,28.16,25.03,21.81,21.97,23.72,24.56,24.88,27.0,30.0,31.25,29.91,28.66,29.59,30.22,28.69,27.78,29.47,30.94,29.84,27.56,26.91,27.47,26.59,24.47,23.97,25.38,26.34,25.09,25.25,27.53,29.91,29.81,29.22,29.88,30.81,28.66,24.88,22.75,22.0,20.22,17.5,16.59,18.25,20.5,21.06,22.59,26.69,30.97,32.53,33.62,35.72,38.19,38.41,36.34,35.06,35.31,34.19,31.34,29.62,30.75,31.81,30.91,30.16,31.38,33.28,32.34,30.91,30.84,32.03,31.44,29.47,29.25,30.66,31.72,30.28,29.06,29.84,30.22,28.09,25.78,26.41,28.56,29.03,28.66,30.22,32.88,33.91,33.12,32.97,35.25,36.66,35.12,33.5,33.41,33.22,30.28,26.38,24.88,24.91,23.0,19.72,18.03,18.34,18.22,16.91,17.03,20.66,23.88,24.41,24.5,26.47,28.97,29.81,30.47,33.28,37.19,38.5,36.81,35.25,34.84,33.59,30.5,28.69,30.03,31.91,31.72,31.59,33.28,36.09,36.19,34.62,34.38,35.66,35.19,33.0,32.19,33.19,33.25,31.06,29.5,30.72,33.25,34.38,35.56,39.28,43.56,45.72,45.81,46.69,48.41,48.06,44.44,40.25,38.06,35.0,29.56,24.84,23.59,23.81,22.72,21.25,21.62,23.41,23.5,22.25,22.09,24.22,25.44,24.53,23.91,25.97,28.12,27.59,26.31,26.97,27.91,26.94,25.0,25.44,28.28,29.91,30.34,31.69,35.81,39.38,40.44,41.47,44.66,47.38,47.25,46.03,46.22,47.12,46.06,43.09,41.03,40.5,38.72,35.22,32.03,30.94,29.56,25.75,21.88,20.56,20.59,19.09,16.66,16.78,19.03,20.44,20.22,21.81,25.28,27.34,26.72,25.62,26.06,25.94,23.81,21.78,22.72,25.78,27.22,27.62,29.28,31.75,32.16,30.72,29.56,31.31,32.88,32.91,32.97,34.88,36.88,36.59,35.59,36.75,39.66,41.0,40.72,41.31,42.72,42.44,38.94,35.91,35.19,34.97,32.94,30.72,30.97,31.22,29.53,26.41,24.78,24.5,23.25,20.72,19.34,20.69,21.53,20.38,19.75,21.69,23.81,24.22,23.66,25.03,27.06,27.34,26.44,26.41,28.34,28.72,26.88,25.94,27.62,29.41,29.28,29.25,31.38,33.59,32.97,30.62,29.41,28.78,27.0,24.12,23.81,26.22,28.75,29.25,30.19,33.22,35.91,35.22,33.47,33.44,34.25,32.94,30.47,30.41,31.53,31.31,28.97,27.25,27.16,26.41,23.44,21.44,22.41,24.78,25.66,25.56,27.28,29.25,29.31,27.66,27.84,30.38,32.5,32.56,33.47,36.16,37.94,36.53,34.56,34.28,34.03,31.38,28.25,27.31,28.22,28.56,27.34,28.09,30.19,32.06,31.25,30.69,31.75,33.25,32.12,30.75,31.78,33.5,33.0,30.94,30.03,30.09,29.22,26.09,24.31,24.94,26.16,25.28,24.84,27.06,29.62,29.59,28.69,29.41,31.25,31.41,30.16,30.47,32.31,33.19,31.59,30.53,31.84,33.75,33.69,33.25,35.09,37.19,37.34,36.06,36.34,37.53,36.75,33.97,31.88,32.06,31.78,29.16,27.12,27.22,27.47,25.34,22.78,22.44,22.72,20.94,17.94,16.47,17.0,16.84,15.09,14.28,15.91,17.41,16.88,16.84,19.44,22.72,23.5,23.28,24.59,26.56,27.06,26.16,26.5,28.5,29.41,27.5,25.5,25.28,25.03,23.12,21.72,22.56,24.69,24.75,23.53,23.62,25.12,24.72,22.12,20.69,21.25,21.31,19.41,18.38,19.91,22.5,22.94,23.03,24.53,26.34,25.47,23.12,22.06,22.94,23.38,22.06,21.88,23.19,24.16,22.66,20.56,20.72,21.88,21.19,20.31,21.06,23.53,24.59,24.38,24.91,27.16,28.22,26.84,25.31,25.69,25.75,23.44,20.47,19.78,20.03,19.16,17.56,17.28,18.97,19.56,18.72,18.75,21.06,23.0,22.25,21.31,22.31,23.84,23.22,21.5,21.59,23.53,23.91,22.88,23.38,25.41,25.66,24.0,23.19,24.84,27.0,26.97,26.06,26.38,25.97,22.88,18.44,16.31,16.31,16.0,14.66,14.34,16.06,17.31,16.56,15.81,18.28,21.47,22.72,23.41,26.06,29.03,29.81,28.75,29.12,30.97,31.16,29.19,27.06,26.81,25.41,21.62,18.09,17.59,18.19,18.0,18.03,20.47,24.16,25.91,25.88,26.59,28.41,29.19,27.91,27.0,28.22,29.06,27.5,25.31,25.44,26.25,25.69,24.5,24.81,26.59,27.03,25.69,25.47,26.94,27.38,25.28,22.56,21.78,21.06,18.97,16.72,17.31,19.69,20.72,20.38,20.81,22.78,23.09,21.56,20.19,20.88,21.0,18.5,15.44,15.22,16.25,15.91,15.66,17.78,21.06,22.59,23.0,23.78,26.44,28.53,27.69,26.75,27.41,28.06,25.59,22.41,21.06,20.75,18.84,15.91,14.94,15.69,15.69,14.38,14.25,16.31,18.31,18.0,17.41,18.69,20.38,19.75,17.91,17.78,18.44,17.5,14.94,14.19,15.25,15.62,14.16,13.12,15.16,17.06,17.09,16.81,18.62,20.97,21.28,20.19,20.91,22.75,23.5,22.28,22.22,24.38,26.31,25.91,25.88,28.06,30.0,28.66,25.94,24.25,23.28,20.28,16.38,14.81,15.56,15.81,14.66,14.72,16.62,18.31,17.5,16.53,18.25,20.84,21.78,22.03,24.0,26.66,27.25,25.44,24.84,25.53,25.59,22.84,20.69,20.91,21.66,20.62,19.75,21.38,23.81,24.69,24.41,26.34,29.97,32.16,32.41,33.22,35.94,37.72,36.75,35.53,36.09,36.25,33.84,30.12,28.09,27.34,24.84,20.88,19.0,19.22,18.94,17.25,16.59,18.28,20.31,19.72,19.44,21.75,25.38,26.44,25.97,26.75,27.97,27.09,24.34,23.16,24.38,25.0,23.88,23.5,25.53,28.16,28.56,28.88,30.81,33.06,32.78,30.69,30.09,30.97,30.97,29.19,28.5,29.25,29.44,26.94,24.91,25.66,27.22,26.88,25.91,26.53,28.5,28.62,27.19,27.75,30.31,31.84,31.31,30.81,32.22,32.78,30.53,28.03,28.09,29.31,28.75,27.06,26.72,27.03,25.41,22.16,20.09,20.97,22.56,22.38,23.66,27.12,30.22,30.03,28.12,27.53,27.56,26.06,23.72,24.0,26.03,26.97,25.69,24.59,25.03,24.78,22.28,19.94,20.88,22.47,21.53,19.94,20.5,22.28,22.56,21.94,23.16,26.31,27.94,26.69,25.31,25.78,26.06,24.09,22.34,22.94,24.72,24.72,23.66,24.56,27.09,27.72,26.28,25.5,26.72,27.16,25.03,23.56,24.62,26.16,25.19,24.88,26.84,29.53,30.34,29.19,28.59,29.03,28.12,25.5,24.56,26.47,28.62,28.5,28.88,31.22,33.84,33.41,31.78,31.97,32.66,31.75,30.06,29.84,31.44,32.12,30.56,29.03,29.78,30.19,28.34,25.91,25.53,26.09,23.88,21.16,20.75,22.53,23.56,23.88,25.72,30.28,33.59,34.25,34.41,35.66,36.09,33.41,30.09,29.06,29.28,27.97,25.72,25.62,27.28,27.91,26.97,27.69,30.62,32.94,32.78,32.31,33.56,34.81,33.56,31.0,30.31,30.84,29.81,27.44,26.59,27.0,26.41,23.5,21.28,21.78,22.41,21.62,20.84,23.25,26.28,26.88,26.09,26.56,27.97,28.28,27.09,27.19,29.81,31.06,29.84,19.19,17.0,15.62,16.25,17.38,17.66,17.94,19.69,22.0,22.47,22.44,23.03,23.84,23.56,21.78,21.19,21.66,22.0,21.56,21.59,23.12,24.56,24.38,23.22,22.62,22.25,20.38,18.28,17.81,19.0,20.0,19.88,20.25,21.22,21.16:31.88,33.09,32.72,32.84,34.81,35.81,34.62,33.28,34.12,35.16,33.91,32.28,32.38,33.56,32.72,30.47,30.03,31.47,32.25,31.56,31.62,33.66,35.03,34.41,33.91,35.72,38.19,37.97,36.81,36.56,36.94,35.03,31.91,30.03,30.5,30.19,28.34,27.06,27.53,28.09,26.66,25.06,26.28,28.5,29.09,28.84,30.09,32.16,32.69,31.28,30.5,31.84,32.5,31.41,30.66,32.31,34.28,34.25,33.75,35.16,37.12,37.59,36.66,36.25,37.19,36.19,32.53,29.09,27.88,26.75,23.91,21.56,22.16,23.53,22.78,21.78,22.56,24.97,26.12,26.41,28.0,31.78,34.75,35.0,35.06,36.44,37.03,34.91,32.12,31.25,31.12,29.31,26.66,26.06,26.97,26.56,24.12,22.41,23.25,24.03,23.59,23.97,26.75,29.47,29.41,27.78,28.03,28.94,28.38,26.41,25.75,26.59,26.41,24.53,23.12,24.69,25.97,24.94,23.69,24.5,25.38,24.19,21.81,21.16,22.16,22.22,20.97,21.31,23.78,25.53,25.22,24.81,26.75,28.59,28.81,28.84,31.12,34.5,35.81,35.22,35.72,37.47,38.62,37.66,37.69,39.94,41.06,39.12,36.38,35.59,35.0,32.66,29.72,29.09,29.78,28.84,26.16,24.56,25.03,24.59,22.78,21.94,24.0,26.78,27.25,27.47,29.56,31.62,31.66,30.34,30.41,32.06,32.34,30.69,29.84,30.75,30.62,28.19,25.59,25.31,25.31,23.41,21.0,20.72,21.94,21.56,20.09,20.53,22.44,23.66,22.59,22.59,24.69,26.59,25.88,24.81,25.47,26.53,25.31,22.91,22.91,24.09,24.69,24.44,26.09,29.88,31.94,31.25,29.56,29.09,28.16,25.03,21.81,21.97,23.72,24.56,24.88,27.0,30.0,31.25,29.91,28.66,29.59,30.22,28.69,27.78,29.47,30.94,29.84,27.56,26.91,27.47,26.59,24.47,23.97,25.38,26.34,25.09,25.25,27.53,29.91,29.81,29.22,29.88,30.81,28.66,24.88,22.75,22.0,20.22,17.5,16.59,18.25,20.5,21.06,22.59,26.69,30.97,32.53,33.62,35.72,38.19,38.41,36.34,35.06,35.31,34.19,31.34,29.62,30.75,31.81,30.91,30.16,31.38,33.28,32.34,30.91,30.84,32.03,31.44,29.47,29.25,30.66,31.72,30.28,29.06,29.84,30.22,28.09,25.78,26.41,28.56,29.03,28.66,30.22,32.88,33.91,33.12,32.97,35.25,36.66,35.12,33.5,33.41,33.22,30.28,26.38,24.88,24.91,23.0,19.72,18.03,18.34,18.22,16.91,17.03,20.66,23.88,24.41,24.5,26.47,28.97,29.81,30.47,33.28,37.19,38.5,36.81,35.25,34.84,33.59,30.5,28.69,30.03,31.91,31.72,31.59,33.28,36.09,36.19,34.62,34.38,35.66,35.19,33.0,32.19,33.19,33.25,31.06,29.5,30.72,33.25,34.38,35.56,39.28,43.56,45.72,45.81,46.69,48.41,48.06,44.44,40.25,38.06,35.0,29.56,24.84,23.59,23.81,22.72,21.25,21.62,23.41,23.5,22.25,22.09,24.22,25.44,24.53,23.91,25.97,28.12,27.59,26.31,26.97,27.91,26.94,25.0,25.44,28.28,29.91,30.34,31.69,35.81,39.38,40.44,41.47,44.66,47.38,47.25,46.03,46.22,47.12,46.06,43.09,41.03,40.5,38.72,35.22,32.03,30.94,29.56,25.75,21.88,20.56,20.59,19.09,16.66,16.78,19.03,20.44,20.22,21.81,25.28,27.34,26.72,25.62,26.06,25.94,23.81,21.78,22.72,25.78,27.22,27.62,29.28,31.75,32.16,30.72,29.56,31.31,32.88,32.91,32.97,34.88,36.88,36.59,35.59,36.75,39.66,41.0,40.72,41.31,42.72,42.44,38.94,35.91,35.19,34.97,32.94,30.72,30.97,31.22,29.53,26.41,24.78,24.5,23.25,20.72,19.34,20.69,21.53,20.38,19.75,21.69,23.81,24.22,23.66,25.03,27.06,27.34,26.44,26.41,28.34,28.72,26.88,25.94,27.62,29.41,29.28,29.25,31.38,33.59,32.97,30.62,29.41,28.78,27.0,24.12,23.81,26.22,28.75,29.25,30.19,33.22,35.91,35.22,33.47,33.44,34.25,32.94,30.47,30.41,31.53,31.31,28.97,27.25,27.16,26.41,23.44,21.44,22.41,24.78,25.66,25.56,27.28,29.25,29.31,27.66,27.84,30.38,32.5,32.56,33.47,36.16,37.94,36.53,34.56,34.28,34.03,31.38,28.25,27.31,28.22,28.56,27.34,28.09,30.19,32.06,31.25,30.69,31.75,33.25,32.12,30.75,31.78,33.5,33.0,30.94,30.03,30.09,29.22,26.09,24.31,24.94,26.16,25.28,24.84,27.06,29.62,29.59,28.69,29.41,31.25,31.41,30.16,30.47,32.31,33.19,31.59,30.53,31.84,33.75,33.69,33.25,35.09,37.19,37.34,36.06,36.34,37.53,36.75,33.97,31.88,32.06,31.78,29.16,27.12,27.22,27.47,25.34,22.78,22.44,22.72,20.94,17.94,16.47,17.0,16.84,15.09,14.28,15.91,17.41,16.88,16.84,19.44,22.72,23.5,23.28,24.59,26.56,27.06,26.16,26.5,28.5,29.41,27.5,25.5,25.28,25.03,23.12,21.72,22.56,24.69,24.75,23.53,23.62,25.12,24.72,22.12,20.69,21.25,21.31,19.41,18.38,19.91,22.5,22.94,23.03,24.53,26.34,25.47,23.12,22.06,22.94,23.38,22.06,21.88,23.19,24.16,22.66,20.56,20.72,21.88,21.19,20.31,21.06,23.53,24.59,24.38,24.91,27.16,28.22,26.84,25.31,25.69,25.75,23.44,20.47,19.78,20.03,19.16,17.56,17.28,18.97,19.56,18.72,18.75,21.06,23.0,22.25,21.31,22.31,23.84,23.22,21.5,21.59,23.53,23.91,22.88,23.38,25.41,25.66,24.0,23.19,24.84,27.0,26.97,26.06,26.38,25.97,22.88,18.44,16.31,16.31,16.0,14.66,14.34,16.06,17.31,16.56,15.81,18.28,21.47,22.72,23.41,26.06,29.03,29.81,28.75,29.12,30.97,31.16,29.19,27.06,26.81,25.41,21.62,18.09,17.59,18.19,18.0,18.03,20.47,24.16,25.91,25.88,26.59,28.41,29.19,27.91,27.0,28.22,29.06,27.5,25.31,25.44,26.25,25.69,24.5,24.81,26.59,27.03,25.69,25.47,26.94,27.38,25.28,22.56,21.78,21.06,18.97,16.72,17.31,19.69,20.72,20.38,20.81,22.78,23.09,21.56,20.19,20.88,21.0,18.5,15.44,15.22,16.25,15.91,15.66,17.78,21.06,22.59,23.0,23.78,26.44,28.53,27.69,26.75,27.41,28.06,25.59,22.41,21.06,20.75,18.84,15.91,14.94,15.69,15.69,14.38,14.25,16.31,18.31,18.0,17.41,18.69,20.38,19.75,17.91,17.78,18.44,17.5,14.94,14.19,15.25,15.62,14.16,13.12,15.16,17.06,17.09,16.81,18.62,20.97,21.28,20.19,20.91,22.75,23.5,22.28,22.22,24.38,26.31,25.91,25.88,28.06,30.0,28.66,25.94,24.25,23.28,20.28,16.38,14.81,15.56,15.81,14.66,14.72,16.62,18.31,17.5,16.53,18.25,20.84,21.78,22.03,24.0,26.66,27.25,25.44,24.84,25.53,25.59,22.84,20.69,20.91,21.66,20.62,19.75,21.38,23.81,24.69,24.41,26.34,29.97,32.16,32.41,33.22,35.94,37.72,36.75,35.53,36.09,36.25,33.84,30.12,28.09,27.34,24.84,20.88,19.0,19.22,18.94,17.25,16.59,18.28,20.31,19.72,19.44,21.75,25.38,26.44,25.97,26.75,27.97,27.09,24.34,23.16,24.38,25.0,23.88,23.5,25.53,28.16,28.56,28.88,30.81,33.06,32.78,30.69,30.09,30.97,30.97,29.19,28.5,29.25,29.44,26.94,24.91,25.66,27.22,26.88,25.91,26.53,28.5,28.62,27.19,27.75,30.31,31.84,31.31,30.81,32.22,32.78,30.53,28.03,28.09,29.31,28.75,27.06,26.72,27.03,25.41,22.16,20.09,20.97,22.56,22.38,23.66,27.12,30.22,30.03,28.12,27.53,27.56,26.06,23.72,24.0,26.03,26.97,25.69,24.59,25.03,24.78,22.28,19.94,20.88,22.47,21.53,19.94,20.5,22.28,22.56,21.94,23.16,26.31,27.94,26.69,25.31,25.78,26.06,24.09,22.34,22.94,24.72,24.72,23.66,24.56,27.09,27.72,26.28,25.5,26.72,27.16,25.03,23.56,24.62,26.16,25.19,24.88,26.84,29.53,30.34,29.19,28.59,29.03,28.12,25.5,24.56,26.47,28.62,28.5,28.88,31.22,33.84,33.41,31.78,31.97,32.66,31.75,30.06,29.84,31.44,32.12,30.56,29.03,29.78,30.19,28.34,25.91,25.53,26.09,23.88,21.16,20.75,22.53,23.56,23.88,25.72,30.28,33.59,34.25,34.41,35.66,36.09,33.41,30.09,29.06,29.28,27.97,25.72,25.62,27.28,27.91,26.97,27.69,30.62,32.94,32.78,32.31,33.56,34.81,33.56,31.0,30.31,30.84,29.81,27.44,26.59,27.0,26.41,23.5,21.28,21.78,22.41,21.62,20.84,23.25,26.28,26.88,26.09,26.56,27.97,28.28,27.09,27.19,29.81,31.06,29.84,19.19,17.0,15.62,16.25,17.38,17.66,17.94,19.69,22.0,22.47,22.44,23.03,23.84,23.56,21.78,21.19,21.66,22.0,21.56,21.59,23.12,24.56,24.38,23.22,22.62,22.25,20.38,18.28,17.81,19.0,20.0,19.88,20.25,21.22,21.16,19.59,17.91,17.53,18.5,18.47,18.72,20.62:negativity
11.31,12.06,11.31,11.03,12.78,13.38,11.75,9.75,10.0,10.75,10.16,9.09,10.03,11.84,12.19,11.25,10.91,12.41,13.38,12.25,11.91,14.16,15.66,14.97,13.62,13.84,14.0,12.19,9.44,8.28,8.97,8.56,7.28,7.41,9.56,10.88,10.31,9.91,11.38,12.5,11.09,8.81,8.16,7.88,5.75,3.28,3.09,5.16,6.97,7.56,9.38,13.19,15.44,15.47,14.59,15.53,16.06,14.06,11.44,11.16,11.38,10.56,9.03,9.28,10.94,11.62,10.62,10.41,12.22,13.44,12.5,11.28,12.12,12.81,11.19,9.34,9.5,11.09,11.0,9.84,10.09,12.12,12.41,11.19,10.09,11.41,11.75,9.59,7.12,6.91,7.22,6.22,4.72,5.81,8.47,9.62,9.19,10.19,12.59,14.16,13.94,13.88,15.72,16.28,14.28,10.72,9.25,8.66,7.12,5.28,6.75,10.19,12.47,12.72,13.31,14.72,15.47,13.84,12.78,14.75,16.56,16.53,15.59,16.91,18.38,17.81,15.47,14.47,14.31,13.25,10.03,8.34,8.88,9.66,8.66,8.53,10.41,12.56,12.66,11.62,12.69,14.66,15.5,15.34,16.75,19.75,21.09,19.47,17.44,16.06,14.03,9.62,5.44,4.12,4.09,2.66,0.66,1.0,2.19,2.28,0.44,0.41,2.09,3.66,3.28,3.88,6.91,9.41,9.38,8.28,8.53,8.88,7.22,4.5,4.19,5.66,6.66,6.12,7.41,10.81,13.38,13.34,13.34,14.53,15.09,13.16,11.19,11.75,13.5,14.31,13.53,14.56,16.62,16.72,15.12,14.12,14.56,13.97,10.97,8.53,8.72,9.41,8.59,7.22,7.41,8.12,7.09,5.0,4.88,6.84,8.19,7.78,8.03,9.66,10.34,8.31,5.81,4.94,4.62,2.28,-0.62,-1.19,-0.03,0.25,-0.47,0.94,4.41,7.19,7.91,9.56,12.75,15.31,15.44,15.12,16.84,19.16,18.91,17.03,17.16,18.25,17.97,16.31,16.41,18.5,19.53,17.91,16.59,17.38,17.69,15.75,13.28,13.06,13.38,11.69,8.94,8.06,8.81,8.47,6.78,6.91,8.91,10.62,9.72,9.06,10.31,10.75,8.84,6.47,6.62,7.62,7.34,6.41,7.25,9.41,10.66,9.94,9.81,11.38,12.03,9.88,8.41,9.12,10.53,9.53,7.84,7.94,8.62,7.41,5.56,5.34,7.38,8.56,7.84,8.12,10.25,11.69,10.56,8.78,9.03,9.5,7.5,5.41,5.81,7.59,8.25,7.78,8.25,10.09,10.75,8.78,7.44,7.62,7.91,5.53,3.38,3.78,5.12,5.0,4.47,6.12,9.34,11.06,11.12,12.41,15.06,16.78,16.19,15.88,17.75,19.44,18.28,16.34,16.12,16.47,15.03,13.41,14.25,17.31,19.69,20.0,20.94,22.97,23.25,20.53,17.53,16.5,16.0,13.31,10.66,10.09,10.16,7.66,4.09,1.88,1.72,1.0,-0.5,-0.31,2.94,6.19,7.53,9.28,13.34,17.53,18.53,18.47,19.38,20.41,19.0,15.91,14.66,15.16,15.22,13.31,11.91,12.75,13.0,10.91,9.06,10.0,11.44,10.5,8.97,9.06,10.06,9.78,8.31,8.09,9.62,10.16,8.72,8.19,10.47,13.25,13.75,14.69,17.81,21.0,21.47,20.81,20.78,21.59,20.59,17.81,16.56,17.75,18.38,17.03,16.22,17.25,18.0,15.88,13.78,13.56,14.25,12.91,10.25,9.22,10.06,10.0,9.34,10.47,14.5,17.88,18.59,18.78,20.25,21.19,19.28,16.28,15.44,15.38,13.44,10.66,9.88,11.09,11.31,9.81,9.25,10.5,11.09,9.03,7.19,6.94,7.22,5.03,2.47,2.44,3.94,3.53,2.22,2.34,4.12,4.75,3.34,2.97,5.03,7.38,7.72,8.41,11.25,14.41,14.72,13.69,14.16,15.41,14.59,12.41,11.62,12.75,13.56,12.88,13.09,15.53,17.06,15.56,12.75,11.66,11.19,8.5,5.44,4.78,5.94,5.97,4.78,4.81,7.12,8.84,8.59,9.06,12.06,15.62,16.44,16.88,18.66,21.44,21.28,20.22,20.34,21.97,21.31,18.19,15.72,14.66,13.34,10.53,8.97,9.94,11.25,10.0,8.25,8.31,9.12,8.41,6.62,6.38,7.72,7.69,6.25,5.38,7.09,7.88,6.75,5.84,6.88,8.34,7.81,6.69,7.88,9.88,9.97,8.62,8.56,9.75,9.41,7.28,5.69,6.53,6.97,5.19,3.16,3.75,5.25,5.34,5.12,7.16,10.34,11.91,11.22,12.22,14.75,16.25,15.75,15.41,17.41,18.41,16.78,14.25,13.09,12.31,9.31,6.12,5.19,6.5,7.28,6.91,7.75,10.91,12.72,12.72,12.59,14.31,15.0,12.81,9.56,8.5,8.59,7.72,6.12,6.62,8.44,8.44,6.59,5.53,6.0,5.97,4.47,3.66,6.0,8.56,9.22,8.62,9.88,11.38,10.88,9.53,9.5,10.91,10.88,8.78,7.28,7.81,8.16,6.16,4.59,5.69,6.47,5.28,3.56,3.16,3.88,2.72,0.97,0.59,2.03,2.31,0.72,0.22,2.22,3.91,3.97,4.03,5.88,7.94,7.56,6.5,7.41,9.03,8.81,6.72,5.38,5.34,3.84,0.22,-3.03,-3.53,-4.69,-7.88,-10.78,-10.28,-8.41,-6.97,-5.38,-1.28,4.03,7.94,9.47,11.62,15.28,17.44,16.62,15.38,15.97,15.75,12.81,8.97,7.56,6.59,4.53,1.88,1.16,2.44,2.28,0.19,-1.59,-1.84,-2.91,-6.16,-9.09,-9.06,-8.31,-9.34,-9.91,-7.94,-5.03,-3.25,-2.66,-0.38,3.12,5.31,5.16,5.38,7.47,8.41,6.69,5.28,6.03,7.5,7.09,5.78,7.03,8.38,8.0,5.84,4.94,5.84,5.97,4.09,3.38,5.31,7.03,6.56,6.19,8.0,10.0,10.28,9.31,9.88,11.38,10.5,8.09,6.97,7.66,8.12,6.88,6.56,8.06,9.41,7.59,5.16,4.53,4.44,2.31,-0.25,-1.19,-1.38,-2.66,-5.53,-6.22,-4.44,-2.25,-1.47,0.19,4.28,7.5,8.34,8.53,9.88,11.53,11.53,10.09,10.28,11.59,11.44,9.22,7.72,7.75,6.97,3.75,0.81,0.81,1.53,1.28,1.41,3.97,6.94,7.38,5.5,4.22,3.97,2.66,-0.09,-1.56,-0.53,0.66,-0.03,-0.56,1.34,3.5,3.47,1.78,2.03,2.72,2.03,0.09,-0.09,1.28,2.06,0.66,0.22,1.78,3.75,3.75,3.88,6.09,8.72,8.78,7.47,7.59,8.62,7.97,6.09,5.44,6.47,6.91,5.0,3.34,3.28,2.75,0.16,-2.41,-2.5,-1.44,-1.62,-2.44,-1.97,-0.69,-0.72,-2.34,-2.59,-0.12,2.31,3.25,4.56,7.75,9.81,8.66,6.44,6.09,5.72,4.16,1.81,1.25,1.88,1.19,-1.94,-4.06,-4.5,-4.78,-6.66,-7.0,-4.25,-0.78,0.72,1.66,4.34,7.44,8.62,9.06,10.59,13.41,15.06,14.03,13.75,15.0,15.88,14.16,11.81,10.84,9.03,3.88,-2.12,-6.34,-8.66,-11.34,-13.88,-13.56,-10.81,-8.34,-7.78,-6.44,-3.41,-0.69,0.41,1.38,4.16,6.78,6.75,4.78,3.88,3.38,1.81,-1.12,-2.0,-0.97,0.06,-0.34,-0.28,1.69,3.66,3.09,2.91,4.75,7.78,9.12,9.31,9.84,11.03,10.12,6.81,4.28,3.66,2.62,-0.56,-3.12,-3.41,-3.22,-4.53,-5.47,-4.31,-2.16,-1.88,-2.59,-1.38,1.34,3.41,3.53,4.31,6.06,6.72,4.72,2.25,1.41,0.38,-2.62,-6.62,-8.16,-8.44,-9.59,-11.44,-11.41,-9.25,-7.59,-7.12,-5.44,-1.5,2.31,3.53,4.47,7.09,9.88,10.59,11.0,12.78,15.84,17.03,16.53,16.81,18.28,18.28,15.53,13.0,11.69,10.22,6.78,3.25,1.94,2.38,1.38,0.16,1.03,3.75,5.41,5.81,7.38,10.62,12.47,11.72,10.56,10.59,10.25,7.97,5.59,5.78,6.81,6.22,4.38,3.06,2.78,1.44,-1.34,-3.03,-2.56,-1.88,-3.5,-4.16,-2.41,0.28,1.19,2.09,4.75,7.97,9.12,8.66,9.31,11.16,11.38,9.81,7.94,7.47,6.22,2.31,-0.44,-1.38,-0.69,-1.31,-2.22,-1.12,0.88,1.47,0.72,1.06,2.84,3.34,1.97,1.56,3.22,4.69,4.16,3.03,3.44,3.81,1.41,-1.66,-3.12,-3.25,-4.34,-6.41,-6.69,-4.84,-3.69,-3.72,-3.19,-0.62,1.94,2.5,2.62,4.47,7.06,7.97,7.84,8.69,10.62,9.88,7.69,6.19,6.5,6.94,5.47,4.53,6.19,8.03,8.12,8.53,10.56,14.0,15.44,15.69,17.28,19.59,20.03,18.12,16.09,15.41,13.66,9.88,6.28,5.19,4.34,2.25,0.16,0.59,3.0,4.28,4.84,7.25,10.62,12.72,12.47,12.03,12.94,13.25,11.44,10.03,10.78,11.88,10.53,8.69,8.25,9.22,9.09,7.97,8.12,10.09,11.03,9.62,8.62,9.62,9.88,8.03,6.03,6.12,6.91,5.88,4.72,5.5,7.59,8.69,7.84,7.22,8.41,8.88,7.28,5.88,6.75,7.69,6.75,5.38,6.66,9.12,9.97,10.0,10.84,12.44,11.81,9.12,7.06,7.19,7.09,4.91,3.09,3.72,4.62,3.44,2.31,3.56,5.88,7.03,6.72,7.06,8.0,6.84,3.38,1.25,2.0,3.47,3.94,5.0,7.88,10.03,9.34,6.91,5.91,5.97,4.44,1.78,0.94,2.28,3.06,2.66,2.81,5.34:9.75,10.0,10.75,10.16,9.09,10.03,11.84,12.19,11.25,10.91,12.41,13.38,12.25,11.91,14.16,15.66,14.97,13.62,13.84,14.0,12.19,9.44,8.28,8.97,8.56,7.28,7.41,9.56,10.88,10.31,9.91,11.38,12.5,11.09,8.81,8.16,7.88,5.75,3.28,3.09,5.16,6.97,7.56,9.38,13.19,15.44,15.47,14.59,15.53,16.06,14.06,11.44,11.16,11.38,10.56,9.03,9.28,10.94,11.62,10.62,10.41,12.22,13.44,12.5,11.28,12.12,12.81,11.19,9.34,9.5,11.09,11.0,9.84,10.09,12.12,12.41,11.19,10.09,11.41,11.75,9.59,7.12,6.91,7.22,6.22,4.72,5.81,8.47,9.62,9.19,10.19,12.59,14.16,13.94,13.88,15.72,16.28,14.28,10.72,9.25,8.66,7.12,5.28,6.75,10.19,12.47,12.72,13.31,14.72,15.47,13.84,12.78,14.75,16.56,16.53,15.59,16.91,18.38,17.81,15.47,14.47,14.31,13.25,10.03,8.34,8.88,9.66,8.66,8.53,10.41,12.56,12.66,11.62,12.69,14.66,15.5,15.34,16.75,19.75,21.09,19.47,17.44,16.06,14.03,9.62,5.44,4.12,4.09,2.66,0.66,1.0,2.19,2.28,0.44,0.41,2.09,3.66,3.28,3.88,6.91,9.41,9.38,8.28,8.53,8.88,7.22,4.5,4.19,5.66,6.66,6.12,7.41,10.81,13.38,13.34,13.34,14.53,15.09,13.16,11.19,11.75,13.5,14.31,13.53,14.56,16.62,16.72,15.12,14.12,14.56,13.97,10.97,8.53,8.72,9.41,8.59,7.22,7.41,8.12,7.09,5.0,4.88,6.84,8.19,7.78,8.03,9.66,10.34,8.31,5.81,4.94,4.62,2.28,-0.62,-1.19,-0.03,0.25,-0.47,0.94,4.41,7.19,7.91,9.56,12.75,15.31,15.44,15.12,16.84,19.16,18.91,17.03,17.16,18.25,17.97,16.31,16.41,18.5,19.53,17.91,16.59,17.38,17.69,15.75,13.28,13.06,13.38,11.69,8.94,8.06,8.81,8.47,6.78,6.91,8.91,10.62,9.72,9.06,10.31,10.75,8.84,6.47,6.62,7.62,7.34,6.41,7.25,9.41,10.66,9.94,9.81,11.38,12.03,9.88,8.41,9.12,10.53,9.53,7.84,7.94,8.62,7.41,5.56,5.34,7.38,8.56,7.84,8.12,10.25,11.69,10.56,8.78,9.03,9.5,7.5,5.41,5.81,7.59,8.25,7.78,8.25,10.09,10.75,8.78,7.44,7.62,7.91,5.53,3.38,3.78,5.12,5.0,4.47,6.12,9.34,11.06,11.12,12.41,15.06,16.78,16.19,15.88,17.75,19.44,18.28,16.34,16.12,16.47,15.03,13.41,14.25,17.31,19.69,20.0,20.94,22.97,23.25,20.53,17.53,16.5,16.0,13.31,10.66,10.09,10.16,7.66,4.09,1.88,1.72,1.0,-0.5,-0.31,2.94,6.19,7.53,9.28,13.34,17.53,18.53,18.47,19.38,20.41,19.0,15.91,14.66,15.16,15.22,13.31,11.91,12.75,13.0,10.91,9.06,10.0,11.44,10.5,8.97,9.06,10.06,9.78,8.31,8.09,9.62,10.16,8.72,8.19,10.47,13.25,13.75,14.69,17.81,21.0,21.47,20.81,20.78,21.59,20.59,17.81,16.56,17.75,18.38,17.03,16.22,17.25,18.0,15.88,13.78,13.56,14.25,12.91,10.25,9.22,10.06,10.0,9.34,10.47,14.5,17.88,18.59,18.78,20.25,21.19,19.28,16.28,15.44,15.38,13.44,10.66,9.88,11.09,11.31,9.81,9.25,10.5,11.09,9.03,7.19,6.94,7.22,5.03,2.47,2.44,3.94,3.53,2.22,2.34,4.12,4.75,3.34,2.97,5.03,7.38,7.72,8.41,11.25,14.41,14.72,13.69,14.16,15.41,14.59,12.41,11.62,12.75,13.56,12.88,13.09,15.53,17.06,15.56,12.75,11.66,11.19,8.5,5.44,4.78,5.94,5.97,4.78,4.81,7.12,8.84,8.59,9.06,12.06,15.62,16.44,16.88,18.66,21.44,21.28,20.22,20.34,21.97,21.31,18.19,15.72,14.66,13.34,10.53,8.97,9.94,11.25,10.0,8.25,8.31,9.12,8.41,6.62,6.38,7.72,7.69,6.25,5.38,7.09,7.88,6.75,5.84,6.88,8.34,7.81,6.69,7.88,9.88,9.97,8.62,8.56,9.75,9.41,7.28,5.69,6.53,6.97,5.19,3.16,3.75,5.25,5.34,5.12,7.16,10.34,11.91,11.22,12.22,14.75,16.25,15.75,15.41,17.41,18.41,16.78,14.25,13.09,12.31,9.31,6.12,5.19,6.5,7.28,6.91,7.75,10.91,12.72,12.72,12.59,14.31,15.0,12.81,9.56,8.5,8.59,7.72,6.12,6.62,8.44,8.44,6.59,5.53,6.0,5.97,4.47,3.66,6.0,8.56,9.22,8.62,9.88,11.38,10.88,9.53,9.5,10.91,10.88,8.78,7.28,7.81,8.16,6.16,4.59,5.69,6.47,5.28,3.56,3.16,3.88,2.72,0.97,0.59,2.03,2.31,0.72,0.22,2.22,3.91,3.97,4.03,5.88,7.94,7.56,6.5,7.41,9.03,8.81,6.72,5.38,5.34,3.84,0.22,-3.03,-3.53,-4.69,-7.88,-10.78,-10.28,-8.41,-6.97,-5.38,-1.28,4.03,7.94,9.47,11.62,15.28,17.44,16.62,15.38,15.97,15.75,12.81,8.97,7.56,6.59,4.53,1.88,1.16,2.44,2.28,0.19,-1.59,-1.84,-2.91,-6.16,-9.09,-9.06,-8.31,-9.34,-9.91,-7.94,-5.03,-3.25,-2.66,-0.38,3.12,5.31,5.16,5.38,7.47,8.41,6.69,5.28,6.03,7.5,7.09,5.78,7.03,8.38,8.0,5.84,4.94,5.84,5.97,4.09,3.38,5.31,7.03,6.56,6.19,8.0,10.0,10.28,9.31,9.88,11.38,10.5,8.09,6.97,7.66,8.12,6.88,6.56,8.06,9.41,7.59,5.16,4.53,4.44,2.31,-0.25,-1.19,-1.38,-2.66,-5.53,-6.22,-4.44,-2.25,-1.47,0.19,4.28,7.5,8.34,8.53,9.88,11.53,11.53,10.09,10.28,11.59,11.44,9.22,7.72,7.75,6.97,3.75,0.81,0.81,1.53,1.28,1.41,3.97,6.94,7.38,5.5,4.22,3.97,2.66,-0.09,-1.56,-0.53,0.66,-0.03,-0.56,1.34,3.5,3.47,1.78,2.03,2.72,2.03,0.09,-0.09,1.28,2.06,0.66,0.22,1.78,3.75,3.75,3.88,6.09,8.72,8.78,7.47,7.59,8.62,7.97,6.09,5.44,6.47,6.91,5.0,3.34,3.28,2.75,0.16,-2.41,-2.5,-1.44,-1.62,-2.44,-1.97,-0.69,-0.72,-2.34,-2.59,-0.12,2.31,3.25,4.56,7.75,9.81,8.66,6.44,6.09,5.72,4.16,1.81,1.25,1.88,1.19,-1.94,-4.06,-4.5,-4.78,-6.66,-7.0,-4.25,-0.78,0.72,1.66,4.34,7.44,8.62,9.06,10.59,13.41,15.06,14.03,13.75,15.0,15.88,14.16,11.81,10.84,9.03,3.88,-2.12,-6.34,-8.66,-11.34,-13.88,-13.56,-10.81,-8.34,-7.78,-6.44,-3.41,-0.69,0.41,1.38,4.16,6.78,6.75,4.78,3.88,3.38,1.81,-1.12,-2.0,-0.97,0.06,-0.34,-0.28,1.69,3.66,3.09,2.91,4.75,7.78,9.12,9.31,9.84,11.03,10.12,6.81,4.28,3.66,2.62,-0.56,-3.12,-3.41,-3.22,-4.53,-5.47,-4.31,-2.16,-1.88,-2.59,-1.38,1.34,3.41,3.53,4.31,6.06,6.72,4.72,2.25,1.41,0.38,-2.62,-6.62,-8.16,-8.44,-9.59,-11.44,-11.41,-9.25,-7.59,-7.12,-5.44,-1.5,2.31,3.53,4.47,7.09,9.88,10.59,11.0,12.78,15.84,17.03,16.53,16.81,18.28,18.28,15.53,13.0,11.69,10.22,6.78,3.25,1.94,2.38,1.38,0.16,1.03,3.75,5.41,5.81,7.38,10.62,12.47,11.72,10.56,10.59,10.25,7.97,5.59,5.78,6.81,6.22,4.38,3.06,2.78,1.44,-1.34,-3.03,-2.56,-1.88,-3.5,-4.16,-2.41,0.28,1.19,2.09,4.75,7.97,9.12,8.66,9.31,11.16,11.38,9.81,7.94,7.47,6.22,2.31,-0.44,-1.38,-0.69,-1.31,-2.22,-1.12,0.88,1.47,0.72,1.06,2.84,3.34,1.97,1.56,3.22,4.69,4.16,3.03,3.44,3.81,1.41,-1.66,-3.12,-3.25,-4.34,-6.41,-6.69,-4.84,-3.69,-3.72,-3.19,-0.62,1.94,2.5,2.62,4.47,7.06,7.97,7.84,8.69,10.62,9.88,7.69,6.19,6.5,6.94,5.47,4.53,6.19,8.03,8.12,8.53,10.56,14.0,15.44,15.69,17.28,19.59,20.03,18.12,16.09,15.41,13.66,9.88,6.28,5.19,4.34,2.25,0.16,0.59,3.0,4.28,4.84,7.25,10.62,12.72,12.47,12.03,12.94,13.25,11.44,10.03,10.78,11.88,10.53,8.69,8.25,9.22,9.09,7.97,8.12,10.09,11.03,9.62,8.62,9.62,9.88,8.03,6.03,6.12,6.91,5.88,4.72,5.5,7.59,8.69,7.84,7.22,8.41,8.88,7.28,5.88,6.75,7.69,6.75,5.38,6.66,9.12,9.97,10.0,10.84,12.44,11.81,9.12,7.06,7.19,7.09,4.91,3.09,3.72,4.62,3.44,2.31,3.56,5.88,7.03,6.72,7.06,8.0,6.84,3.38,1.25,2.0,3.47,3.94,5.0,7.88,10.03,9.34,6.91,5.91,5.97,4.44,1.78,0.94,2.28,3.06,2.66,2.81,5.34,13.22,13.75,13.34,13.16,13.59,12.88,11.31:12.19,11.25,10.91,12.41,13.38,12.25,11.91,14.16,15.66,14.97,13.62,13.84,14.0,12.19,9.44,8.28,8.97,8.56,7.28,7.41,9.56,10.88,10.31,9.91,11.38,12.5,11.09,8.81,8.16,7.88,5.75,3.28,3.09,5.16,6.97,7.56,9.38,13.19,15.44,15.47,14.59,15.53,16.06,14.06,11.44,11.16,11.38,10.56,9.03,9.28,10.94,11.62,10.62,10.41,12.22,13.44,12.5,11.28,12.12,12.81,11.19,9.34,9.5,11.09,11.0,9.84,10.09,12.12,12.41,11.19,10.09,11.41,11.75,9.59,7.12,6.91,7.22,6.22,4.72,5.81,8.47,9.62,9.19,10.19,12.59,14.16,13.94,13.88,15.72,16.28,14.28,10.72,9.25,8.66,7.12,5.28,6.75,10.19,12.47,12.72,13.31,14.72,15.47,13.84,12.78,14.75,16.56,16.53,15.59,16.91,18.38,17.81,15.47,14.47,14.31,13.25,10.03,8.34,8.88,9.66,8.66,8.53,10.41,12.56,12.66,11.62,12.69,14.66,15.5,15.34,16.75,19.75,21.09,19.47,17.44,16.06,14.03,9.62,5.44,4.12,4.09,2.66,0.66,1.0,2.19,2.28,0.44,0.41,2.09,3.66,3.28,3.88,6.91,9.41,9.38,8.28,8.53,8.88,7.22,4.5,4.19,5.66,6.66,6.12,7.41,10.81,13.38,13.34,13.34,14.53,15.09,13.16,11.19,11.75,13.5,14.31,13.53,14.56,16.62,16.72,15.12,14.12,14.56,13.97,10.97,8.53,8.72,9.41,8.59,7.22,7.41,8.12,7.09,5.0,4.88,6.84,8.19,7.78,8.03,9.66,10.34,8.31,5.81,4.94,4.62,2.28,-0.62,-1.19,-0.03,0.25,-0.47,0.94,4.41,7.19,7.91,9.56,12.75,15.31,15.44,15.12,16.84,19.16,18.91,17.03,17.16,18.25,17.97,16.31,16.41,18.5,19.53,17.91,16.59,17.38,17.69,15.75,13.28,13.06,13.38,11.69,8.94,8.06,8.81,8.47,6.78,6.91,8.91,10.62,9.72,9.06,10.31,10.75,8.84,6.47,6.62,7.62,7.34,6.41,7.25,9.41,10.66,9.94,9.81,11.38,12.03,9.88,8.41,9.12,10.53,9.53,7.84,7.94,8.62,7.41,5.56,5.34,7.38,8.56,7.84,8.12,10.25,11.69,10.56,8.78,9.03,9.5,7.5,5.41,5.81,7.59,8.25,7.78,8.25,10.09,10.75,8.78,7.44,7.62,7.91,5.53,3.38,3.78,5.12,5.0,4.47,6.12,9.34,11.06,11.12,12.41,15.06,16.78,16.19,15.88,17.75,19.44,18.28,16.34,16.12,16.47,15.03,13.41,14.25,17.31,19.69,20.0,20.94,22.97,23.25,20.53,17.53,16.5,16.0,13.31,10.66,10.09,10.16,7.66,4.09,1.88,1.72,1.0,-0.5,-0.31,2.94,6.19,7.53,9.28,13.34,17.53,18.53,18.47,19.38,20.41,19.0,15.91,14.66,15.16,15.22,13.31,11.91,12.75,13.0,10.91,9.06,10.0,11.44,10.5,8.97,9.06,10.06,9.78,8.31,8.09,9.62,10.16,8.72,8.19,10.47,13.25,13.75,14.69,17.81,21.0,21.47,20.81,20.78,21.59,20.59,17.81,16.56,17.75,18.38,17.03,16.22,17.25,18.0,15.88,13.78,13.56,14.25,12.91,10.25,9.22,10.06,10.0,9.34,10.47,14.5,17.88,18.59,18.78,20.25,21.19,19.28,16.28,15.44,15.38,13.44,10.66,9.88,11.09,11.31,9.81,9.25,10.5,11.09,9.03,7.19,6.94,7.22,5.03,2.47,2.44,3.94,3.53,2.22,2.34,4.12,4.75,3.34,2.97,5.03,7.38,7.72,8.41,11.25,14.41,14.72,13.69,14.16,15.41,14.59,12.41,11.62,12.75,13.56,12.88,13.09,15.53,17.06,15.56,12.75,11.66,11.19,8.5,5.44,4.78,5.94,5.97,4.78,4.81,7.12,8.84,8.59,9.06,12.06,15.62,16.44,16.88,18.66,21.44,21.28,20.22,20.34,21.97,21.31,18.19,15.72,14.66,13.34,10.53,8.97,9.94,11.25,10.0,8.25,8.31,9.12,8.41,6.62,6.38,7.72,7.69,6.25,5.38,7.09,7.88,6.75,5.84,6.88,8.34,7.81,6.69,7.88,9.88,9.97,8.62,8.56,9.75,9.41,7.28,5.69,6.53,6.97,5.19,3.16,3.75,5.25,5.34,5.12,7.16,10.34,11.91,11.22,12.22,14.75,16.25,15.75,15.41,17.41,18.41,16.78,14.25,13.09,12.31,9.31,6.12,5.19,6.5,7.28,6.91,7.75,10.91,12.72,12.72,12.59,14.31,15.0,12.81,9.56,8.5,8.59,7.72,6.12,6.62,8.44,8.44,6.59,5.53,6.0,5.97,4.47,3.66,6.0,8.56,9.22,8.62,9.88,11.38,10.88,9.53,9.5,10.91,10.88,8.78,7.28,7.81,8.16,6.16,4.59,5.69,6.47,5.28,3.56,3.16,3.88,2.72,0.97,0.59,2.03,2.31,0.72,0.22,2.22,3.91,3.97,4.03,5.88,7.94,7.56,6.5,7.41,9.03,8.81,6.72,5.38,5.34,3.84,0.22,-3.03,-3.53,-4.69,-7.88,-10.78,-10.28,-8.41,-6.97,-5.38,-1.28,4.03,7.94,9.47,11.62,15.28,17.44,16.62,15.38,15.97,15.75,12.81,8.97,7.56,6.59,4.53,1.88,1.16,2.44,2.28,0.19,-1.59,-1.84,-2.91,-6.16,-9.09,-9.06,-8.31,-9.34,-9.91,-7.94,-5.03,-3.25,-2.66,-0.38,3.12,5.31,5.16,5.38,7.47,8.41,6.69,5.28,6.03,7.5,7.09,5.78,7.03,8.38,8.0,5.84,4.94,5.84,5.97,4.09,3.38,5.31,7.03,6.56,6.19,8.0,10.0,10.28,9.31,9.88,11.38,10.5,8.09,6.97,7.66,8.12,6.88,6.56,8.06,9.41,7.59,5.16,4.53,4.44,2.31,-0.25,-1.19,-1.38,-2.66,-5.53,-6.22,-4.44,-2.25,-1.47,0.19,4.28,7.5,8.34,8.53,9.88,11.53,11.53,10.09,10.28,11.59,11.44,9.22,7.72,7.75,6.97,3.75,0.81,0.81,1.53,1.28,1.41,3.97,6.94,7.38,5.5,4.22,3.97,2.66,-0.09,-1.56,-0.53,0.66,-0.03,-0.56,1.34,3.5,3.47,1.78,2.03,2.72,2.03,0.09,-0.09,1.28,2.06,0.66,0.22,1.78,3.75,3.75,3.88,6.09,8.72,8.78,7.47,7.59,8.62,7.97,6.09,5.44,6.47,6.91,5.0,3.34,3.28,2.75,0.16,-2.41,-2.5,-1.44,-1.62,-2.44,-1.97,-0.69,-0.72,-2.34,-2.59,-0.12,2.31,3.25,4.56,7.75,9.81,8.66,6.44,6.09,5.72,4.16,1.81,1.25,1.88,1.19,-1.94,-4.06,-4.5,-4.78,-6.66,-7.0,-4.25,-0.78,0.72,1.66,4.34,7.44,8.62,9.06,10.59,13.41,15.06,14.03,13.75,15.0,15.88,14.16,11.81,10.84,9.03,3.88,-2.12,-6.34,-8.66,-11.34,-13.88,-13.56,-10.81,-8.34,-7.78,-6.44,-3.41,-0.69,0.41,1.38,4.16,6.78,6.75,4.78,3.88,3.38,1.81,-1.12,-2.0,-0.97,0.06,-0.34,-0.28,1.69,3.66,3.09,2.91,4.75,7.78,9.12,9.31,9.84,11.03,10.12,6.81,4.28,3.66,2.62,-0.56,-3.12,-3.41,-3.22,-4.53,-5.47,-4.31,-2.16,-1.88,-2.59,-1.38,1.34,3.41,3.53,4.31,6.06,6.72,4.72,2.25,1.41,0.38,-2.62,-6.62,-8.16,-8.44,-9.59,-11.44,-11.41,-9.25,-7.59,-7.12,-5.44,-1.5,2.31,3.53,4.47,7.09,9.88,10.59,11.0,12.78,15.84,17.03,16.53,16.81,18.28,18.28,15.53,13.0,11.69,10.22,6.78,3.25,1.94,2.38,1.38,0.16,1.03,3.75,5.41,5.81,7.38,10.62,12.47,11.72,10.56,10.59,10.25,7.97,5.59,5.78,6.81,6.22,4.38,3.06,2.78,1.44,-1.34,-3.03,-2.56,-1.88,-3.5,-4.16,-2.41,0.28,1.19,2.09,4.75,7.97,9.12,8.66,9.31,11.16,11.38,9.81,7.94,7.47,6.22,2.31,-0.44,-1.38,-0.69,-1.31,-2.22,-1.12,0.88,1.47,0.72,1.06,2.84,3.34,1.97,1.56,3.22,4.69,4.16,3.03,3.44,3.81,1.41,-1.66,-3.12,-3.25,-4.34,-6.41,-6.69,-4.84,-3.69,-3.72,-3.19,-0.62,1.94,2.5,2.62,4.47,7.06,7.97,7.84,8.69,10.62,9.88,7.69,6.19,6.5,6.94,5.47,4.53,6.19,8.03,8.12,8.53,10.56,14.0,15.44,15.69,17.28,19.59,20.03,18.12,16.09,15.41,13.66,9.88,6.28,5.19,4.34,2.25,0.16,0.59,3.0,4.28,4.84,7.25,10.62,12.72,12.47,12.03,12.94,13.25,11.44,10.03,10.78,11.88,10.53,8.69,8.25,9.22,9.09,7.97,8.12,10.09,11.03,9.62,8.62,9.62,9.88,8.03,6.03,6.12,6.91,5.88,4.72,5.5,7.59,8.69,7.84,7.22,8.41,8.88,7.28,5.88,6.75,7.69,6.75,5.38,6.66,9.12,9.97,10.0,10.84,12.44,11.81,9.12,7.06,7.19,7.09,4.91,3.09,3.72,4.62,3.44,2.31,3.56,5.88,7.03,6.72,7.06,8.0,6.84,3.38,1.25,2.0,3.47,3.94,5.0,7.88,10.03,9.34,6.91,5.91,5.97,4.44,1.78,0.94,2.28,3.06,2.66,2.81,5.34,13.22,13.75,13.34,13.16,13.59,12.88,11.31,9.75,9.78,10.12,9.81,9.69,10.34,11.22:14.16,15.66,14.97,13.62,13.84,14.0,12.19,9.44,8.28,8.97,8.56,7.28,7.41,9.56,10.88,10.31,9.91,11.38,12.5,11.09,8.81,8.16,7.88,5.75,3.28,3.09,5.16,6.97,7.56,9.38,13.19,15.44,15.47,14.59,15.53,16.06,14.06,11.44,11.16,11.38,10.56,9.03,9.28,10.94,11.62,10.62,10.41,12.22,13.44,12.5,11.28,12.12,12.81,11.19,9.34,9.5,11.09,11.0,9.84,10.09,12.12,12.41,11.19,10.09,11.41,11.75,9.59,7.12,6.91,7.22,6.22,4.72,5.81,8.47,9.62,9.19,10.19,12.59,14.16,13.94,13.88,15.72,16.28,14.28,10.72,9.25,8.66,7.12,5.28,6.75,10.19,12.47,12.72,13.31,14.72,15.47,13.84,12.78,14.75,16.56,16.53,15.59,16.91,18.38,17.81,15.47,14.47,14.31,13.25,10.03,8.34,8.88,9.66,8.66,8.53,10.41,12.56,12.66,11.62,12.69,14.66,15.5,15.34,16.75,19.75,21.09,19.47,17.44,16.06,14.03,9.62,5.44,4.12,4.09,2.66,0.66,1.0,2.19,2.28,0.44,0.41,2.09,3.66,3.28,3.88,6.91,9.41,9.38,8.28,8.53,8.88,7.22,4.5,4.19,5.66,6.66,6.12,7.41,10.81,13.38,13.34,13.34,14.53,15.09,13.16,11.19,11.75,13.5,14.31,13.53,14.56,16.62,16.72,15.12,14.12,14.56,13.97,10.97,8.53,8.72,9.41,8.59,7.22,7.41,8.12,7.09,5.0,4.88,6.84,8.19,7.78,8.03,9.66,10.34,8.31,5.81,4.94,4.62,2.28,-0.62,-1.19,-0.03,0.25,-0.47,0.94,4.41,7.19,7.91,9.56,12.75,15.31,15.44,15.12,16.84,19.16,18.91,17.03,17.16,18.25,17.97,16.31,16.41,18.5,19.53,17.91,16.59,17.38,17.69,15.75,13.28,13.06,13.38,11.69,8.94,8.06,8.81,8.47,6.78,6.91,8.91,10.62,9.72,9.06,10.31,10.75,8.84,6.47,6.62,7.62,7.34,6.41,7.25,9.41,10.66,9.94,9.81,11.38,12.03,9.88,8.41,9.12,10.53,9.53,7.84,7.94,8.62,7.41,5.56,5.34,7.38,8.56,7.84,8.12,10.25,11.69,10.56,8.78,9.03,9.5,7.5,5.41,5.81,7.59,8.25,7.78,8.25,10.09,10.75,8.78,7.44,7.62,7.91,5.53,3.38,3.78,5.12,5.0,4.47,6.12,9.34,11.06,11.12,12.41,15.06,16.78,16.19,15.88,17.75,19.44,18.28,16.34,16.12,16.47,15.03,13.41,14.25,17.31,19.69,20.0,20.94,22.97,23.25,20.53,17.53,16.5,16.0,13.31,10.66,10.09,10.16,7.66,4.09,1.88,1.72,1.0,-0.5,-0.31,2.94,6.19,7.53,9.28,13.34,17.53,18.53,18.47,19.38,20.41,19.0,15.91,14.66,15.16,15.22,13.31,11.91,12.75,13.0,10.91,9.06,10.0,11.44,10.5,8.97,9.06,10.06,9.78,8.31,8.09,9.62,10.16,8.72,8.19,10.47,13.25,13.75,14.69,17.81,21.0,21.47,20.81,20.78,21.59,20.59,17.81,16.56,17.75,18.38,17.03,16.22,17.25,18.0,15.88,13.78,13.56,14.25,12.91,10.25,9.22,10.06,10.0,9.34,10.47,14.5,17.88,18.59,18.78,20.25,21.19,19.28,16.28,15.44,15.38,13.44,10.66,9.88,11.09,11.31,9.81,9.25,10.5,11.09,9.03,7.19,6.94,7.22,5.03,2.47,2.44,3.94,3.53,2.22,2.34,4.12,4.75,3.34,2.97,5.03,7.38,7.72,8.41,11.25,14.41,14.72,13.69,14.16,15.41,14.59,12.41,11.62,12.75,13.56,12.88,13.09,15.53,17.06,15.56,12.75,11.66,11.19,8.5,5.44,4.78,5.94,5.97,4.78,4.81,7.12,8.84,8.59,9.06,12.06,15.62,16.44,16.88,18.66,21.44,21.28,20.22,20.34,21.97,21.31,18.19,15.72,14.66,13.34,10.53,8.97,9.94,11.25,10.0,8.25,8.31,9.12,8.41,6.62,6.38,7.72,7.69,6.25,5.38,7.09,7.88,6.75,5.84,6.88,8.34,7.81,6.69,7.88,9.88,9.97,8.62,8.56,9.75,9.41,7.28,5.69,6.53,6.97,5.19,3.16,3.75,5.25,5.34,5.12,7.16,10.34,11.91,11.22,12.22,14.75,16.25,15.75,15.41,17.41,18.41,16.78,14.25,13.09,12.31,9.31,6.12,5.19,6.5,7.28,6.91,7.75,10.91,12.72,12.72,12.59,14.31,15.0,12.81,9.56,8.5,8.59,7.72,6.12,6.62,8.44,8.44,6.59,5.53,6.0,5.97,4.47,3.66,6.0,8.56,9.22,8.62,9.88,11.38,10.88,9.53,9.5,10.91,10.88,8.78,7.28,7.81,8.16,6.16,4.59,5.69,6.47,5.28,3.56,3.16,3.88,2.72,0.97,0.59,2.03,2.31,0.72,0.22,2.22,3.91,3.97,4.03,5.88,7.94,7.56,6.5,7.41,9.03,8.81,6.72,5.38,5.34,3.84,0.22,-3.03,-3.53,-4.69,-7.88,-10.78,-10.28,-8.41,-6.97,-5.38,-1.28,4.03,7.94,9.47,11.62,15.28,17.44,16.62,15.38,15.97,15.75,12.81,8.97,7.56,6.59,4.53,1.88,1.16,2.44,2.28,0.19,-1.59,-1.84,-2.91,-6.16,-9.09,-9.06,-8.31,-9.34,-9.91,-7.94,-5.03,-3.25,-2.66,-0.38,3.12,5.31,5.16,5.38,7.47,8.41,6.69,5.28,6.03,7.5,7.09,5.78,7.03,8.38,8.0,5.84,4.94,5.84,5.97,4.09,3.38,5.31,7.03,6.56,6.19,8.0,10.0,10.28,9.31,9.88,11.38,10.5,8.09,6.97,7.66,8.12,6.88,6.56,8.06,9.41,7.59,5.16,4.53,4.44,2.31,-0.25,-1.19,-1.38,-2.66,-5.53,-6.22,-4.44,-2.25,-1.47,0.19,4.28,7.5,8.34,8.53,9.88,11.53,11.53,10.09,10.28,11.59,11.44,9.22,7.72,7.75,6.97,3.75,0.81,0.81,1.53,1.28,1.41,3.97,6.94,7.38,5.5,4.22,3.97,2.66,-0.09,-1.56,-0.53,0.66,-0.03,-0.56,1.34,3.5,3.47,1.78,2.03,2.72,2.03,0.09,-0.09,1.28,2.06,0.66,0.22,1.78,3.75,3.75,3.88,6.09,8.72,8.78,7.47,7.59,8.62,7.97,6.09,5.44,6.47,6.91,5.0,3.34,3.28,2.75,0.16,-2.41,-2.5,-1.44,-1.62,-2.44,-1.97,-0.69,-0.72,-2.34,-2.59,-0.12,2.31,3.25,4.56,7.75,9.81,8.66,6.44,6.09,5.72,4.16,1.81,1.25,1.88,1.19,-1.94,-4.06,-4.5,-4.78,-6.66,-7.0,-4.25,-0.78,0.72,1.66,4.34,7.44,8.62,9.06,10.59,13.41,15.06,14.03,13.75,15.0,15.88,14.16,11.81,10.84,9.03,3.88,-2.12,-6.34,-8.66,-11.34,-13.88,-13.56,-10.81,-8.34,-7.78,-6.44,-3.41,-0.69,0.41,1.38,4.16,6.78,6.75,4.78,3.88,3.38,1.81,-1.12,-2.0,-0.97,0.06,-0.34,-0.28,1.69,3.66,3.09,2.91,4.75,7.78,9.12,9.31,9.84,11.03,10.12,6.81,4.28,3.66,2.62,-0.56,-3.12,-3.41,-3.22,-4.53,-5.47,-4.31,-2.16,-1.88,-2.59,-1.38,1.34,3.41,3.53,4.31,6.06,6.72,4.72,2.25,1.41,0.38,-2.62,-6.62,-8.16,-8.44,-9.59,-11.44,-11.41,-9.25,-7.59,-7.12,-5.44,-1.5,2.31,3.53,4.47,7.09,9.88,10.59,11.0,12.78,15.84,17.03,16.53,16.81,18.28,18.28,15.53,13.0,11.69,10.22,6.78,3.25,1.94,2.38,1.38,0.16,1.03,3.75,5.41,5.81,7.38,10.62,12.47,11.72,10.56,10.59,10.25,7.97,5.59,5.78,6.81,6.22,4.38,3.06,2.78,1.44,-1.34,-3.03,-2.56,-1.88,-3.5,-4.16,-2.41,0.28,1.19,2.09,4.75,7.97,9.12,8.66,9.31,11.16,11.38,9.81,7.94,7.47,6.22,2.31,-0.44,-1.38,-0.69,-1.31,-2.22,-1.12,0.88,1.47,0.72,1.06,2.84,3.34,1.97,1.56,3.22,4.69,4.16,3.03,3.44,3.81,1.41,-1.66,-3.12,-3.25,-4.34,-6.41,-6.69,-4.84,-3.69,-3.72,-3.19,-0.62,1.94,2.5,2.62,4.47,7.06,7.97,7.84,8.69,10.62,9.88,7.69,6.19,6.5,6.94,5.47,4.53,6.19,8.03,8.12,8.53,10.56,14.0,15.44,15.69,17.28,19.59,20.03,18.12,16.09,15.41,13.66,9.88,6.28,5.19,4.34,2.25,0.16,0.59,3.0,4.28,4.84,7.25,10.62,12.72,12.47,12.03,12.94,13.25,11.44,10.03,10.78,11.88,10.53,8.69,8.25,9.22,9.09,7.97,8.12,10.09,11.03,9.62,8.62,9.62,9.88,8.03,6.03,6.12,6.91,5.88,4.72,5.5,7.59,8.69,7.84,7.22,8.41,8.88,7.28,5.88,6.75,7.69,6.75,5.38,6.66,9.12,9.97,10.0,10.84,12.44,11.81,9.12,7.06,7.19,7.09,4.91,3.09,3.72,4.62,3.44,2.31,3.56,5.88,7.03,6.72,7.06,8.0,6.84,3.38,1.25,2.0,3.47,3.94,5.0,7.88,10.03,9.34,6.91,5.91,5.97,4.44,1.78,0.94,2.28,3.06,2.66,2.81,5.34,13.22,13.75,13.34,13.16,13.59,12.88,11.31,9.75,9.78,10.12,9.81,9.69,10.34,11.22,10.78,9.97,9.34,9.78,10.06,10.06,10.94:9.44,8.28,8.97,8.56,7.28,7.41,9.56,10.88,10.31,9.91,11.38,12.5,11.09,8.81,8.16,7.88,5.75,3.28,3.09,5.16,6.97,7.56,9.38,13.19,15.44,15.47,14.59,15.53,16.06,14.06,11.44,11.16,11.38,10.56,9.03,9.28,10.94,11.62,10.62,10.41,12.22,13.44,12.5,11.28,12.12,12.81,11.19,9.34,9.5,11.09,11.0,9.84,10.09,12.12,12.41,11.19,10.09,11.41,11.75,9.59,7.12,6.91,7.22,6.22,4.72,5.81,8.47,9.62,9.19,10.19,12.59,14.16,13.94,13.88,15.72,16.28,14.28,10.72,9.25,8.66,7.12,5.28,6.75,10.19,12.47,12.72,13.31,14.72,15.47,13.84,12.78,14.75,16.56,16.53,15.59,16.91,18.38,17.81,15.47,14.47,14.31,13.25,10.03,8.34,8.88,9.66,8.66,8.53,10.41,12.56,12.66,11.62,12.69,14.66,15.5,15.34,16.75,19.75,21.09,19.47,17.44,16.06,14.03,9.62,5.44,4.12,4.09,2.66,0.66,1.0,2.19,2.28,0.44,0.41,2.09,3.66,3.28,3.88,6.91,9.41,9.38,8.28,8.53,8.88,7.22,4.5,4.19,5.66,6.66,6.12,7.41,10.81,13.38,13.34,13.34,14.53,15.09,13.16,11.19,11.75,13.5,14.31,13.53,14.56,16.62,16.72,15.12,14.12,14.56,13.97,10.97,8.53,8.72,9.41,8.59,7.22,7.41,8.12,7.09,5.0,4.88,6.84,8.19,7.78,8.03,9.66,10.34,8.31,5.81,4.94,4.62,2.28,-0.62,-1.19,-0.03,0.25,-0.47,0.94,4.41,7.19,7.91,9.56,12.75,15.31,15.44,15.12,16.84,19.16,18.91,17.03,17.16,18.25,17.97,16.31,16.41,18.5,19.53,17.91,16.59,17.38,17.69,15.75,13.28,13.06,13.38,11.69,8.94,8.06,8.81,8.47,6.78,6.91,8.91,10.62,9.72,9.06,10.31,10.75,8.84,6.47,6.62,7.62,7.34,6.41,7.25,9.41,10.66,9.94,9.81,11.38,12.03,9.88,8.41,9.12,10.53,9.53,7.84,7.94,8.62,7.41,5.56,5.34,7.38,8.56,7.84,8.12,10.25,11.69,10.56,8.78,9.03,9.5,7.5,5.41,5.81,7.59,8.25,7.78,8.25,10.09,10.75,8.78,7.44,7.62,7.91,5.53,3.38,3.78,5.12,5.0,4.47,6.12,9.34,11.06,11.12,12.41,15.06,16.78,16.19,15.88,17.75,19.44,18.28,16.34,16.12,16.47,15.03,13.41,14.25,17.31,19.69,20.0,20.94,22.97,23.25,20.53,17.53,16.5,16.0,13.31,10.66,10.09,10.16,7.66,4.09,1.88,1.72,1.0,-0.5,-0.31,2.94,6.19,7.53,9.28,13.34,17.53,18.53,18.47,19.38,20.41,19.0,15.91,14.66,15.16,15.22,13.31,11.91,12.75,13.0,10.91,9.06,10.0,11.44,10.5,8.97,9.06,10.06,9.78,8.31,8.09,9.62,10.16,8.72,8.19,10.47,13.25,13.75,14.69,17.81,21.0,21.47,20.81,20.78,21.59,20.59,17.81,16.56,17.75,18.38,17.03,16.22,17.25,18.0,15.88,13.78,13.56,14.25,12.91,10.25,9.22,10.06,10.0,9.34,10.47,14.5,17.88,18.59,18.78,20.25,21.19,19.28,16.28,15.44,15.38,13.44,10.66,9.88,11.09,11.31,9.81,9.25,10.5,11.09,9.03,7.19,6.94,7.22,5.03,2.47,2.44,3.94,3.53,2.22,2.34,4.12,4.75,3.34,2.97,5.03,7.38,7.72,8.41,11.25,14.41,14.72,13.69,14.16,15.41,14.59,12.41,11.62,12.75,13.56,12.88,13.09,15.53,17.06,15.56,12.75,11.66,11.19,8.5,5.44,4.78,5.94,5.97,4.78,4.81,7.12,8.84,8.59,9.06,12.06,15.62,16.44,16.88,18.66,21.44,21.28,20.22,20.34,21.97,21.31,18.19,15.72,14.66,13.34,10.53,8.97,9.94,11.25,10.0,8.25,8.31,9.12,8.41,6.62,6.38,7.72,7.69,6.25,5.38,7.09,7.88,6.75,5.84,6.88,8.34,7.81,6.69,7.88,9.88,9.97,8.62,8.56,9.75,9.41,7.28,5.69,6.53,6.97,5.19,3.16,3.75,5.25,5.34,5.12,7.16,10.34,11.91,11.22,12.22,14.75,16.25,15.75,15.41,17.41,18.41,16.78,14.25,13.09,12.31,9.31,6.12,5.19,6.5,7.28,6.91,7.75,10.91,12.72,12.72,12.59,14.31,15.0,12.81,9.56,8.5,8.59,7.72,6.12,6.62,8.44,8.44,6.59,5.53,6.0,5.97,4.47,3.66,6.0,8.56,9.22,8.62,9.88,11.38,10.88,9.53,9.5,10.91,10.88,8.78,7.28,7.81,8.16,6.16,4.59,5.69,6.47,5.28,3.56,3.16,3.88,2.72,0.97,0.59,2.03,2.31,0.72,0.22,2.22,3.91,3.97,4.03,5.88,7.94,7.56,6.5,7.41,9.03,8.81,6.72,5.38,5.34,3.84,0.22,-3.03,-3.53,-4.69,-7.88,-10.78,-10.28,-8.41,-6.97,-5.38,-1.28,4.03,7.94,9.47,11.62,15.28,17.44,16.62,15.38,15.97,15.75,12.81,8.97,7.56,6.59,4.53,1.88,1.16,2.44,2.28,0.19,-1.59,-1.84,-2.91,-6.16,-9.09,-9.06,-8.31,-9.34,-9.91,-7.94,-5.03,-3.25,-2.66,-0.38,3.12,5.31,5.16,5.38,7.47,8.41,6.69,5.28,6.03,7.5,7.09,5.78,7.03,8.38,8.0,5.84,4.94,5.84,5.97,4.09,3.38,5.31,7.03,6.56,6.19,8.0,10.0,10.28,9.31,9.88,11.38,10.5,8.09,6.97,7.66,8.12,6.88,6.56,8.06,9.41,7.59,5.16,4.53,4.44,2.31,-0.25,-1.19,-1.38,-2.66,-5.53,-6.22,-4.44,-2.25,-1.47,0.19,4.28,7.5,8.34,8.53,9.88,11.53,11.53,10.09,10.28,11.59,11.44,9.22,7.72,7.75,6.97,3.75,0.81,0.81,1.53,1.28,1.41,3.97,6.94,7.38,5.5,4.22,3.97,2.66,-0.09,-1.56,-0.53,0.66,-0.03,-0.56,1.34,3.5,3.47,1.78,2.03,2.72,2.03,0.09,-0.09,1.28,2.06,0.66,0.22,1.78,3.75,3.75,3.88,6.09,8.72,8.78,7.47,7.59,8.62,7.97,6.09,5.44,6.47,6.91,5.0,3.34,3.28,2.75,0.16,-2.41,-2.5,-1.44,-1.62,-2.44,-1.97,-0.69,-0.72,-2.34,-2.59,-0.12,2.31,3.25,4.56,7.75,9.81,8.66,6.44,6.09,5.72,4.16,1.81,1.25,1.88,1.19,-1.94,-4.06,-4.5,-4.78,-6.66,-7.0,-4.25,-0.78,0.72,1.66,4.34,7.44,8.62,9.06,10.59,13.41,15.06,14.03,13.75,15.0,15.88,14.16,11.81,10.84,9.03,3.88,-2.12,-6.34,-8.66,-11.34,-13.88,-13.56,-10.81,-8.34,-7.78,-6.44,-3.41,-0.69,0.41,1.38,4.16,6.78,6.75,4.78,3.88,3.38,1.81,-1.12,-2.0,-0.97,0.06,-0.34,-0.28,1.69,3.66,3.09,2.91,4.75,7.78,9.12,9.31,9.84,11.03,10.12,6.81,4.28,3.66,2.62,-0.56,-3.12,-3.41,-3.22,-4.53,-5.47,-4.31,-2.16,-1.88,-2.59,-1.38,1.34,3.41,3.53,4.31,6.06,6.72,4.72,2.25,1.41,0.38,-2.62,-6.62,-8.16,-8.44,-9.59,-11.44,-11.41,-9.25,-7.59,-7.12,-5.44,-1.5,2.31,3.53,4.47,7.09,9.88,10.59,11.0,12.78,15.84,17.03,16.53,16.81,18.28,18.28,15.53,13.0,11.69,10.22,6.78,3.25,1.94,2.38,1.38,0.16,1.03,3.75,5.41,5.81,7.38,10.62,12.47,11.72,10.56,10.59,10.25,7.97,5.59,5.78,6.81,6.22,4.38,3.06,2.78,1.44,-1.34,-3.03,-2.56,-1.88,-3.5,-4.16,-2.41,0.28,1.19,2.09,4.75,7.97,9.12,8.66,9.31,11.16,11.38,9.81,7.94,7.47,6.22,2.31,-0.44,-1.38,-0.69,-1.31,-2.22,-1.12,0.88,1.47,0.72,1.06,2.84,3.34,1.97,1.56,3.22,4.69,4.16,3.03,3.44,3.81,1.41,-1.66,-3.12,-3.25,-4.34,-6.41,-6.69,-4.84,-3.69,-3.72,-3.19,-0.62,1.94,2.5,2.62,4.47,7.06,7.97,7.84,8.69,10.62,9.88,7.69,6.19,6.5,6.94,5.47,4.53,6.19,8.03,8.12,8.53,10.56,14.0,15.44,15.69,17.28,19.59,20.03,18.12,16.09,15.41,13.66,9.88,6.28,5.19,4.34,2.25,0.16,0.59,3.0,4.28,4.84,7.25,10.62,12.72,12.47,12.03,12.94,13.25,11.44,10.03,10.78,11.88,10.53,8.69,8.25,9.22,9.09,7.97,8.12,10.09,11.03,9.62,8.62,9.62,9.88,8.03,6.03,6.12,6.91,5.88,4.72,5.5,7.59,8.69,7.84,7.22,8.41,8.88,7.28,5.88,6.75,7.69,6.75,5.38,6.66,9.12,9.97,10.0,10.84,12.44,11.81,9.12,7.06,7.19,7.09,4.91,3.09,3.72,4.62,3.44,2.31,3.56,5.88,7.03,6.72,7.06,8.0,6.84,3.38,1.25,2.0,3.47,3.94,5.0,7.88,10.03,9.34,6.91,5.91,5.97,4.44,1.78,0.94,2.28,3.06,2.66,2.81,5.34,13.22,13.75,13.34,13.16,13.59,12.88,11.31,9.75,9.78,10.12,9.81,9.69,10.34,11.22,10.78,9.97,9.34,9.78,10.06,10.06,10.94,13.5,15.22,15.66,15.75,16.22,15.81,14.44:10.88,10.31,9.91,11.38,12.5,11.09,8.81,8.16,7.88,5.75,3.28,3.09,5.16,6.97,7.56,9.38,13.19,15.44,15.47,14.59,15.53,16.06,14.06,11.44,11.16,11.38,10.56,9.03,9.28,10.94,11.62,10.62,10.41,12.22,13.44,12.5,11.28,12.12,12.81,11.19,9.34,9.5,11.09,11.0,9.84,10.09,12.12,12.41,11.19,10.09,11.41,11.75,9.59,7.12,6.91,7.22,6.22,4.72,5.81,8.47,9.62,9.19,10.19,12.59,14.16,13.94,13.88,15.72,16.28,14.28,10.72,9.25,8.66,7.12,5.28,6.75,10.19,12.47,12.72,13.31,14.72,15.47,13.84,12.78,14.75,16.56,16.53,15.59,16.91,18.38,17.81,15.47,14.47,14.31,13.25,10.03,8.34,8.88,9.66,8.66,8.53,10.41,12.56,12.66,11.62,12.69,14.66,15.5,15.34,16.75,19.75,21.09,19.47,17.44,16.06,14.03,9.62,5.44,4.12,4.09,2.66,0.66,1.0,2.19,2.28,0.44,0.41,2.09,3.66,3.28,3.88,6.91,9.41,9.38,8.28,8.53,8.88,7.22,4.5,4.19,5.66,6.66,6.12,7.41,10.81,13.38,13.34,13.34,14.53,15.09,13.16,11.19,11.75,13.5,14.31,13.53,14.56,16.62,16.72,15.12,14.12,14.56,13.97,10.97,8.53,8.72,9.41,8.59,7.22,7.41,8.12,7.09,5.0,4.88,6.84,8.19,7.78,8.03,9.66,10.34,8.31,5.81,4.94,4.62,2.28,-0.62,-1.19,-0.03,0.25,-0.47,0.94,4.41,7.19,7.91,9.56,12.75,15.31,15.44,15.12,16.84,19.16,18.91,17.03,17.16,18.25,17.97,16.31,16.41,18.5,19.53,17.91,16.59,17.38,17.69,15.75,13.28,13.06,13.38,11.69,8.94,8.06,8.81,8.47,6.78,6.91,8.91,10.62,9.72,9.06,10.31,10.75,8.84,6.47,6.62,7.62,7.34,6.41,7.25,9.41,10.66,9.94,9.81,11.38,12.03,9.88,8.41,9.12,10.53,9.53,7.84,7.94,8.62,7.41,5.56,5.34,7.38,8.56,7.84,8.12,10.25,11.69,10.56,8.78,9.03,9.5,7.5,5.41,5.81,7.59,8.25,7.78,8.25,10.09,10.75,8.78,7.44,7.62,7.91,5.53,3.38,3.78,5.12,5.0,4.47,6.12,9.34,11.06,11.12,12.41,15.06,16.78,16.19,15.88,17.75,19.44,18.28,16.34,16.12,16.47,15.03,13.41,14.25,17.31,19.69,20.0,20.94,22.97,23.25,20.53,17.53,16.5,16.0,13.31,10.66,10.09,10.16,7.66,4.09,1.88,1.72,1.0,-0.5,-0.31,2.94,6.19,7.53,9.28,13.34,17.53,18.53,18.47,19.38,20.41,19.0,15.91,14.66,15.16,15.22,13.31,11.91,12.75,13.0,10.91,9.06,10.0,11.44,10.5,8.97,9.06,10.06,9.78,8.31,8.09,9.62,10.16,8.72,8.19,10.47,13.25,13.75,14.69,17.81,21.0,21.47,20.81,20.78,21.59,20.59,17.81,16.56,17.75,18.38,17.03,16.22,17.25,18.0,15.88,13.78,13.56,14.25,12.91,10.25,9.22,10.06,10.0,9.34,10.47,14.5,17.88,18.59,18.78,20.25,21.19,19.28,16.28,15.44,15.38,13.44,10.66,9.88,11.09,11.31,9.81,9.25,10.5,11.09,9.03,7.19,6.94,7.22,5.03,2.47,2.44,3.94,3.53,2.22,2.34,4.12,4.75,3.34,2.97,5.03,7.38,7.72,8.41,11.25,14.41,14.72,13.69,14.16,15.41,14.59,12.41,11.62,12.75,13.56,12.88,13.09,15.53,17.06,15.56,12.75,11.66,11.19,8.5,5.44,4.78,5.94,5.97,4.78,4.81,7.12,8.84,8.59,9.06,12.06,15.62,16.44,16.88,18.66,21.44,21.28,20.22,20.34,21.97,21.31,18.19,15.72,14.66,13.34,10.53,8.97,9.94,11.25,10.0,8.25,8.31,9.12,8.41,6.62,6.38,7.72,7.69,6.25,5.38,7.09,7.88,6.75,5.84,6.88,8.34,7.81,6.69,7.88,9.88,9.97,8.62,8.56,9.75,9.41,7.28,5.69,6.53,6.97,5.19,3.16,3.75,5.25,5.34,5.12,7.16,10.34,11.91,11.22,12.22,14.75,16.25,15.75,15.41,17.41,18.41,16.78,14.25,13.09,12.31,9.31,6.12,5.19,6.5,7.28,6.91,7.75,10.91,12.72,12.72,12.59,14.31,15.0,12.81,9.56,8.5,8.59,7.72,6.12,6.62,8.44,8.44,6.59,5.53,6.0,5.97,4.47,3.66,6.0,8.56,9.22,8.62,9.88,11.38,10.88,9.53,9.5,10.91,10.88,8.78,7.28,7.81,8.16,6.16,4.59,5.69,6.47,5.28,3.56,3.16,3.88,2.72,0.97,0.59,2.03,2.31,0.72,0.22,2.22,3.91,3.97,4.03,5.88,7.94,7.56,6.5,7.41,9.03,8.81,6.72,5.38,5.34,3.84,0.22,-3.03,-3.53,-4.69,-7.88,-10.78,-10.28,-8.41,-6.97,-5.38,-1.28,4.03,7.94,9.47,11.62,15.28,17.44,16.62,15.38,15.97,15.75,12.81,8.97,7.56,6.59,4.53,1.88,1.16,2.44,2.28,0.19,-1.59,-1.84,-2.91,-6.16,-9.09,-9.06,-8.31,-9.34,-9.91,-7.94,-5.03,-3.25,-2.66,-0.38,3.12,5.31,5.16,5.38,7.47,8.41,6.69,5.28,6.03,7.5,7.09,5.78,7.03,8.38,8.0,5.84,4.94,5.84,5.97,4.09,3.38,5.31,7.03,6.56,6.19,8.0,10.0,10.28,9.31,9.88,11.38,10.5,8.09,6.97,7.66,8.12,6.88,6.56,8.06,9.41,7.59,5.16,4.53,4.44,2.31,-0.25,-1.19,-1.38,-2.66,-5.53,-6.22,-4.44,-2.25,-1.47,0.19,4.28,7.5,8.34,8.53,9.88,11.53,11.53,10.09,10.28,11.59,11.44,9.22,7.72,7.75,6.97,3.75,0.81,0.81,1.53,1.28,1.41,3.97,6.94,7.38,5.5,4.22,3.97,2.66,-0.09,-1.56,-0.53,0.66,-0.03,-0.56,1.34,3.5,3.47,1.78,2.03,2.72,2.03,0.09,-0.09,1.28,2.06,0.66,0.22,1.78,3.75,3.75,3.88,6.09,8.72,8.78,7.47,7.59,8.62,7.97,6.09,5.44,6.47,6.91,5.0,3.34,3.28,2.75,0.16,-2.41,-2.5,-1.44,-1.62,-2.44,-1.97,-0.69,-0.72,-2.34,-2.59,-0.12,2.31,3.25,4.56,7.75,9.81,8.66,6.44,6.09,5.72,4.16,1.81,1.25,1.88,1.19,-1.94,-4.06,-4.5,-4.78,-6.66,-7.0,-4.25,-0.78,0.72,1.66,4.34,7.44,8.62,9.06,10.59,13.41,15.06,14.03,13.75,15.0,15.88,14.16,11.81,10.84,9.03,3.88,-2.12,-6.34,-8.66,-11.34,-13.88,-13.56,-10.81,-8.34,-7.78,-6.44,-3.41,-0.69,0.41,1.38,4.16,6.78,6.75,4.78,3.88,3.38,1.81,-1.12,-2.0,-0.97,0.06,-0.34,-0.28,1.69,3.66,3.09,2.91,4.75,7.78,9.12,9.31,9.84,11.03,10.12,6.81,4.28,3.66,2.62,-0.56,-3.12,-3.41,-3.22,-4.53,-5.47,-4.31,-2.16,-1.88,-2.59,-1.38,1.34,3.41,3.53,4.31,6.06,6.72,4.72,2.25,1.41,0.38,-2.62,-6.62,-8.16,-8.44,-9.59,-11.44,-11.41,-9.25,-7.59,-7.12,-5.44,-1.5,2.31,3.53,4.47,7.09,9.88,10.59,11.0,12.78,15.84,17.03,16.53,16.81,18.28,18.28,15.53,13.0,11.69,10.22,6.78,3.25,1.94,2.38,1.38,0.16,1.03,3.75,5.41,5.81,7.38,10.62,12.47,11.72,10.56,10.59,10.25,7.97,5.59,5.78,6.81,6.22,4.38,3.06,2.78,1.44,-1.34,-3.03,-2.56,-1.88,-3.5,-4.16,-2.41,0.28,1.19,2.09,4.75,7.97,9.12,8.66,9.31,11.16,11.38,9.81,7.94,7.47,6.22,2.31,-0.44,-1.38,-0.69,-1.31,-2.22,-1.12,0.88,1.47,0.72,1.06,2.84,3.34,1.97,1.56,3.22,4.69,4.16,3.03,3.44,3.81,1.41,-1.66,-3.12,-3.25,-4.34,-6.41,-6.69,-4.84,-3.69,-3.72,-3.19,-0.62,1.94,2.5,2.62,4.47,7.06,7.97,7.84,8.69,10.62,9.88,7.69,6.19,6.5,6.94,5.47,4.53,6.19,8.03,8.12,8.53,10.56,14.0,15.44,15.69,17.28,19.59,20.03,18.12,16.09,15.41,13.66,9.88,6.28,5.19,4.34,2.25,0.16,0.59,3.0,4.28,4.84,7.25,10.62,12.72,12.47,12.03,12.94,13.25,11.44,10.03,10.78,11.88,10.53,8.69,8.25,9.22,9.09,7.97,8.12,10.09,11.03,9.62,8.62,9.62,9.88,8.03,6.03,6.12,6.91,5.88,4.72,5.5,7.59,8.69,7.84,7.22,8.41,8.88,7.28,5.88,6.75,7.69,6.75,5.38,6.66,9.12,9.97,10.0,10.84,12.44,11.81,9.12,7.06,7.19,7.09,4.91,3.09,3.72,4.62,3.44,2.31,3.56,5.88,7.03,6.72,7.06,8.0,6.84,3.38,1.25,2.0,3.47,3.94,5.0,7.88,10.03,9.34,6.91,5.91,5.97,4.44,1.78,0.94,2.28,3.06,2.66,2.81,5.34,13.22,13.75,13.34,13.16,13.59,12.88,11.31,9.75,9.78,10.12,9.81,9.69,10.34,11.22,10.78,9.97,9.34,9.78,10.06,10.06,10.94,13.5,15.22,15.66,15.75,16.22,15.81,14.44,12.91,12.41,12.56,12.09,11.19,11.12,12.06:8.16,7.88,5.75,3.28,3.09,5.16,6.97,7.56,9.38,13.19,15.44,15.47,14.59,15.53,16.06,14.06,11.44,11.16,11.38,10.56,9.03,9.28,10.94,11.62,10.62,10.41,12.22,13.44,12.5,11.28,12.12,12.81,11.19,9.34,9.5,11.09,11.0,9.84,10.09,12.12,12.41,11.19,10.09,11.41,11.75,9.59,7.12,6.91,7.22,6.22,4.72,5.81,8.47,9.62,9.19,10.19,12.59,14.16,13.94,13.88,15.72,16.28,14.28,10.72,9.25,8.66,7.12,5.28,6.75,10.19,12.47,12.72,13.31,14.72,15.47,13.84,12.78,14.75,16.56,16.53,15.59,16.91,18.38,17.81,15.47,14.47,14.31,13.25,10.03,8.34,8.88,9.66,8.66,8.53,10.41,12.56,12.66,11.62,12.69,14.66,15.5,15.34,16.75,19.75,21.09,19.47,17.44,16.06,14.03,9.62,5.44,4.12,4.09,2.66,0.66,1.0,2.19,2.28,0.44,0.41,2.09,3.66,3.28,3.88,6.91,9.41,9.38,8.28,8.53,8.88,7.22,4.5,4.19,5.66,6.66,6.12,7.41,10.81,13.38,13.34,13.34,14.53,15.09,13.16,11.19,11.75,13.5,14.31,13.53,14.56,16.62,16.72,15.12,14.12,14.56,13.97,10.97,8.53,8.72,9.41,8.59,7.22,7.41,8.12,7.09,5.0,4.88,6.84,8.19,7.78,8.03,9.66,10.34,8.31,5.81,4.94,4.62,2.28,-0.62,-1.19,-0.03,0.25,-0.47,0.94,4.41,7.19,7.91,9.56,12.75,15.31,15.44,15.12,16.84,19.16,18.91,17.03,17.16,18.25,17.97,16.31,16.41,18.5,19.53,17.91,16.59,17.38,17.69,15.75,13.28,13.06,13.38,11.69,8.94,8.06,8.81,8.47,6.78,6.91,8.91,10.62,9.72,9.06,10.31,10.75,8.84,6.47,6.62,7.62,7.34,6.41,7.25,9.41,10.66,9.94,9.81,11.38,12.03,9.88,8.41,9.12,10.53,9.53,7.84,7.94,8.62,7.41,5.56,5.34,7.38,8.56,7.84,8.12,10.25,11.69,10.56,8.78,9.03,9.5,7.5,5.41,5.81,7.59,8.25,7.78,8.25,10.09,10.75,8.78,7.44,7.62,7.91,5.53,3.38,3.78,5.12,5.0,4.47,6.12,9.34,11.06,11.12,12.41,15.06,16.78,16.19,15.88,17.75,19.44,18.28,16.34,16.12,16.47,15.03,13.41,14.25,17.31,19.69,20.0,20.94,22.97,23.25,20.53,17.53,16.5,16.0,13.31,10.66,10.09,10.16,7.66,4.09,1.88,1.72,1.0,-0.5,-0.31,2.94,6.19,7.53,9.28,13.34,17.53,18.53,18.47,19.38,20.41,19.0,15.91,14.66,15.16,15.22,13.31,11.91,12.75,13.0,10.91,9.06,10.0,11.44,10.5,8.97,9.06,10.06,9.78,8.31,8.09,9.62,10.16,8.72,8.19,10.47,13.25,13.75,14.69,17.81,21.0,21.47,20.81,20.78,21.59,20.59,17.81,16.56,17.75,18.38,17.03,16.22,17.25,18.0,15.88,13.78,13.56,14.25,12.91,10.25,9.22,10.06,10.0,9.34,10.47,14.5,17.88,18.59,18.78,20.25,21.19,19.28,16.28,15.44,15.38,13.44,10.66,9.88,11.09,11.31,9.81,9.25,10.5,11.09,9.03,7.19,6.94,7.22,5.03,2.47,2.44,3.94,3.53,2.22,2.34,4.12,4.75,3.34,2.97,5.03,7.38,7.72,8.41,11.25,14.41,14.72,13.69,14.16,15.41,14.59,12.41,11.62,12.75,13.56,12.88,13.09,15.53,17.06,15.56,12.75,11.66,11.19,8.5,5.44,4.78,5.94,5.97,4.78,4.81,7.12,8.84,8.59,9.06,12.06,15.62,16.44,16.88,18.66,21.44,21.28,20.22,20.34,21.97,21.31,18.19,15.72,14.66,13.34,10.53,8.97,9.94,11.25,10.0,8.25,8.31,9.12,8.41,6.62,6.38,7.72,7.69,6.25,5.38,7.09,7.88,6.75,5.84,6.88,8.34,7.81,6.69,7.88,9.88,9.97,8.62,8.56,9.75,9.41,7.28,5.69,6.53,6.97,5.19,3.16,3.75,5.25,5.34,5.12,7.16,10.34,11.91,11.22,12.22,14.75,16.25,15.75,15.41,17.41,18.41,16.78,14.25,13.09,12.31,9.31,6.12,5.19,6.5,7.28,6.91,7.75,10.91,12.72,12.72,12.59,14.31,15.0,12.81,9.56,8.5,8.59,7.72,6.12,6.62,8.44,8.44,6.59,5.53,6.0,5.97,4.47,3.66,6.0,8.56,9.22,8.62,9.88,11.38,10.88,9.53,9.5,10.91,10.88,8.78,7.28,7.81,8.16,6.16,4.59,5.69,6.47,5.28,3.56,3.16,3.88,2.72,0.97,0.59,2.03,2.31,0.72,0.22,2.22,3.91,3.97,4.03,5.88,7.94,7.56,6.5,7.41,9.03,8.81,6.72,5.38,5.34,3.84,0.22,-3.03,-3.53,-4.69,-7.88,-10.78,-10.28,-8.41,-6.97,-5.38,-1.28,4.03,7.94,9.47,11.62,15.28,17.44,16.62,15.38,15.97,15.75,12.81,8.97,7.56,6.59,4.53,1.88,1.16,2.44,2.28,0.19,-1.59,-1.84,-2.91,-6.16,-9.09,-9.06,-8.31,-9.34,-9.91,-7.94,-5.03,-3.25,-2.66,-0.38,3.12,5.31,5.16,5.38,7.47,8.41,6.69,5.28,6.03,7.5,7.09,5.78,7.03,8.38,8.0,5.84,4.94,5.84,5.97,4.09,3.38,5.31,7.03,6.56,6.19,8.0,10.0,10.28,9.31,9.88,11.38,10.5,8.09,6.97,7.66,8.12,6.88,6.56,8.06,9.41,7.59,5.16,4.53,4.44,2.31,-0.25,-1.19,-1.38,-2.66,-5.53,-6.22,-4.44,-2.25,-1.47,0.19,4.28,7.5,8.34,8.53,9.88,11.53,11.53,10.09,10.28,11.59,11.44,9.22,7.72,7.75,6.97,3.75,0.81,0.81,1.53,1.28,1.41,3.97,6.94,7.38,5.5,4.22,3.97,2.66,-0.09,-1.56,-0.53,0.66,-0.03,-0.56,1.34,3.5,3.47,1.78,2.03,2.72,2.03,0.09,-0.09,1.28,2.06,0.66,0.22,1.78,3.75,3.75,3.88,6.09,8.72,8.78,7.47,7.59,8.62,7.97,6.09,5.44,6.47,6.91,5.0,3.34,3.28,2.75,0.16,-2.41,-2.5,-1.44,-1.62,-2.44,-1.97,-0.69,-0.72,-2.34,-2.59,-0.12,2.31,3.25,4.56,7.75,9.81,8.66,6.44,6.09,5.72,4.16,1.81,1.25,1.88,1.19,-1.94,-4.06,-4.5,-4.78,-6.66,-7.0,-4.25,-0.78,0.72,1.66,4.34,7.44,8.62,9.06,10.59,13.41,15.06,14.03,13.75,15.0,15.88,14.16,11.81,10.84,9.03,3.88,-2.12,-6.34,-8.66,-11.34,-13.88,-13.56,-10.81,-8.34,-7.78,-6.44,-3.41,-0.69,0.41,1.38,4.16,6.78,6.75,4.78,3.88,3.38,1.81,-1.12,-2.0,-0.97,0.06,-0.34,-0.28,1.69,3.66,3.09,2.91,4.75,7.78,9.12,9.31,9.84,11.03,10.12,6.81,4.28,3.66,2.62,-0.56,-3.12,-3.41,-3.22,-4.53,-5.47,-4.31,-2.16,-1.88,-2.59,-1.38,1.34,3.41,3.53,4.31,6.06,6.72,4.72,2.25,1.41,0.38,-2.62,-6.62,-8.16,-8.44,-9.59,-11.44,-11.41,-9.25,-7.59,-7.12,-5.44,-1.5,2.31,3.53,4.47,7.09,9.88,10.59,11.0,12.78,15.84,17.03,16.53,16.81,18.28,18.28,15.53,13.0,11.69,10.22,6.78,3.25,1.94,2.38,1.38,0.16,1.03,3.75,5.41,5.81,7.38,10.62,12.47,11.72,10.56,10.59,10.25,7.97,5.59,5.78,6.81,6.22,4.38,3.06,2.78,1.44,-1.34,-3.03,-2.56,-1.88,-3.5,-4.16,-2.41,0.28,1.19,2.09,4.75,7.97,9.12,8.66,9.31,11.16,11.38,9.81,7.94,7.47,6.22,2.31,-0.44,-1.38,-0.69,-1.31,-2.22,-1.12,0.88,1.47,0.72,1.06,2.84,3.34,1.97,1.56,3.22,4.69,4.16,3.03,3.44,3.81,1.41,-1.66,-3.12,-3.25,-4.34,-6.41,-6.69,-4.84,-3.69,-3.72,-3.19,-0.62,1.94,2.5,2.62,4.47,7.06,7.97,7.84,8.69,10.62,9.88,7.69,6.19,6.5,6.94,5.47,4.53,6.19,8.03,8.12,8.53,10.56,14.0,15.44,15.69,17.28,19.59,20.03,18.12,16.09,15.41,13.66,9.88,6.28,5.19,4.34,2.25,0.16,0.59,3.0,4.28,4.84,7.25,10.62,12.72,12.47,12.03,12.94,13.25,11.44,10.03,10.78,11.88,10.53,8.69,8.25,9.22,9.09,7.97,8.12,10.09,11.03,9.62,8.62,9.62,9.88,8.03,6.03,6.12,6.91,5.88,4.72,5.5,7.59,8.69,7.84,7.22,8.41,8.88,7.28,5.88,6.75,7.69,6.75,5.38,6.66,9.12,9.97,10.0,10.84,12.44,11.81,9.12,7.06,7.19,7.09,4.91,3.09,3.72,4.62,3.44,2.31,3.56,5.88,7.03,6.72,7.06,8.0,6.84,3.38,1.25,2.0,3.47,3.94,5.0,7.88,10.03,9.34,6.91,5.91,5.97,4.44,1.78,0.94,2.28,3.06,2.66,2.81,5.34,13.22,13.75,13.34,13.16,13.59,12.88,11.31,9.75,9.78,10.12,9.81,9.69,10.34,11.22,10.78,9.97,9.34,9.78,10.06,10.06,10.94,13.5,15.22,15.66,15.75,16.22,15.81,14.44,12.91,12.41,12.56,12.09,11.19,11.12,12.06,12.47,11.72,11.19,11.84,11.72,10.34,9.09:positivity
0.34,-1.44,-0.97,-0.19,-1.81,-3.84,-3.75,-2.81,-3.25,-3.56,-1.72,2.28,4.66,4.78,5.78,8.03,9.12,7.91,7.56,9.47,11.28,10.97,10.94,12.25,13.94,13.41,10.91,8.88,7.84,5.03,0.69,-1.88,-2.19,-2.31,-4.12,-5.56,-5.5,-5.59,-7.94,-11.41,-12.94,-12.84,-14.19,-15.78,-14.94,-11.34,-8.09,-5.94,-3.0,1.5,4.97,5.59,5.22,6.59,8.53,8.0,6.97,7.59,9.44,9.25,7.31,6.41,7.41,7.59,6.25,5.5,7.44,9.53,9.16,9.56,11.5,13.88,14.22,13.09,13.38,14.75,14.84,13.19,12.28,13.25,13.88,12.47,11.41,12.81,13.91,13.41,11.97,11.94,12.94,11.75,9.53,8.47,9.12,8.94,6.66,5.12,5.59,5.81,3.84,2.53,4.06,6.75,8.19,9.06,11.44,15.06,16.5,16.28,16.84,18.94,20.25,18.78,17.62,18.22,18.78,16.78,14.28,13.78,13.69,11.34,7.88,6.28,6.66,6.41,5.03,5.41,7.56,9.19,8.91,8.69,10.81,13.16,14.09,14.34,16.94,20.47,22.03,21.38,21.34,21.94,21.09,18.53,16.66,17.53,18.03,16.31,14.0,13.53,13.5,11.38,9.0,8.62,9.88,9.91,8.72,8.81,10.88,11.88,10.75,9.94,11.59,13.22,12.53,11.59,13.22,15.5,15.34,14.0,14.19,14.59,13.31,9.94,7.78,8.09,8.59,7.62,7.69,10.25,12.81,13.41,13.12,14.47,16.66,16.62,15.19,14.78,15.69,15.16,13.0,12.03,13.75,15.34,15.12,14.88,16.91,19.22,19.31,18.53,19.34,20.94,20.72,18.75,17.88,18.47,18.12,15.53,13.47,14.06,14.41,13.12,11.69,12.28,13.66,12.62,10.44,9.75,10.44,9.84,7.56,6.84,7.84,8.66,7.31,6.28,7.84,9.69,9.41,8.75,10.0,12.28,12.69,11.19,11.94,13.91,14.28,12.69,11.62,12.28,11.75,8.78,6.25,6.22,6.62,5.28,3.09,3.47,4.91,4.53,2.84,2.75,4.22,5.0,3.97,4.34,7.16,9.69,9.94,8.88,9.38,9.94,7.88,5.06,4.66,6.03,6.19,5.0,5.12,6.41,7.0,4.84,3.19,3.56,4.47,2.91,1.25,2.41,3.91,3.91,2.44,2.56,3.88,3.66,1.88,1.38,3.0,4.22,3.03,2.28,3.59,5.62,5.25,4.72,6.47,8.97,9.62,8.31,8.34,9.53,8.78,5.81,3.31,2.72,1.56,-1.59,-4.09,-3.41,-0.97,0.44,2.06,5.78,10.66,13.62,13.72,14.28,15.69,15.31,12.38,10.06,9.88,9.72,7.19,4.5,4.19,4.56,2.81,0.16,-0.91,-0.25,-0.28,-1.38,-0.38,3.38,7.09,8.72,10.16,13.62,16.94,17.12,16.47,17.5,18.66,17.28,14.09,12.09,11.28,9.5,6.16,4.44,5.81,7.75,7.81,8.16,10.25,12.56,11.44,9.25,8.91,9.78,9.25,8.31,9.31,12.72,15.5,15.88,16.72,18.81,20.38,18.38,15.53,15.09,15.56,14.06,12.31,12.88,14.78,15.22,13.78,12.88,13.66,13.84,11.72,11.09,13.5,16.44,16.66,16.5,17.91,19.19,18.22,15.84,14.84,16.0,16.03,14.81,14.75,16.88,18.53,17.44,16.25,17.31,17.88,15.72,13.06,13.0,14.88,14.94,14.16,14.5,15.91,15.0,11.91,9.69,10.0,10.06,8.03,6.78,7.75,10.31,10.97,11.72,14.41,18.28,19.91,19.81,20.44,22.5,23.34,22.19,21.31,22.25,23.31,21.59,19.28,19.72,21.19,20.53,18.84,19.06,20.25,19.5,16.97,15.31,16.25,16.94,15.56,14.88,16.62,18.31,17.28,15.72,16.31,18.12,18.31,17.31,17.41,18.59,18.19,15.44,13.88,14.56,14.72,12.72,10.66,10.94,11.88,10.66,9.28,10.09,12.59,13.19,12.31,12.81,15.28,16.47,15.94,16.28,18.81,20.88,20.69,19.94,20.88,22.56,22.16,20.94,21.78,23.53,23.34,21.19,19.78,20.03,19.5,16.84,14.5,15.03,15.31,13.91,12.22,13.62,15.97,16.75,16.44,17.06,18.78,18.56,16.62,15.72,17.78,19.38,18.75,17.91,19.03,19.91,18.69,17.06,17.62,19.81,20.12,19.16,19.38,21.34,21.69,19.56,17.53,17.41,16.84,14.09,11.78,12.69,14.44,14.66,14.41,16.0,19.09,20.66,20.38,20.78,22.78,23.0,21.75,21.12,23.75,26.66,27.25,27.09,28.22,29.38,27.84,24.69,23.19,22.75,20.62,17.06,14.78,15.47,16.06,15.19,15.34,18.03,20.81,21.81,22.03,23.94,26.59,26.81,25.12,24.81,25.72,25.31,23.03,21.78,22.78,23.94,23.22,22.84,24.97,27.47,27.53,26.25,27.25,28.72,28.84,26.84,26.19,26.72,27.03,24.94,23.34,24.69,25.47,24.16,22.41,22.62,23.09,21.03,17.16,14.84,14.34,13.47,11.69,11.62,14.31,16.69,16.78,17.28,20.19,22.84,23.22,22.78,24.28,26.19,25.88,23.75,22.75,23.0,21.94,18.84,17.0,17.69,18.12,16.38,15.53,17.22,19.16,18.72,17.19,17.28,17.97,17.41,15.56,16.12,18.88,20.97,21.06,21.84,24.66,27.19,27.25,27.0,29.5,31.72,32.12,30.78,30.88,31.25,29.81,26.44,24.84,25.34,26.16,25.91,26.56,29.5,32.59,33.34,33.41,34.81,36.47,35.72,33.59,32.84,33.12,32.56,30.56,29.69,31.25,32.28,31.09,29.5,29.66,29.78,27.41,24.59,23.97,24.47,23.97,22.06,22.16,23.56,24.41,22.72,21.84,22.88,23.66,21.81,19.78,19.56,20.03,18.94,16.91,17.0,18.5,18.88,17.5,17.88,20.0,21.75,21.72,21.88,23.69,25.59,24.53,22.97,23.44,24.56,23.72,22.16,22.34,23.88,24.22,22.59,22.12,23.59,23.84,21.72,20.09,20.78,22.0,21.31,20.31,21.25,22.84,22.59,20.97,21.06,22.5,22.75,20.75,19.5,19.84,20.03,18.59,17.5,18.75,20.81,20.34,18.84,18.84,19.62,18.34,15.38,13.84,14.44,14.5,13.25,13.06,15.47,18.0,18.28,18.22,19.72,22.0,21.78,20.16,19.59,19.84,18.03,14.47,12.09,11.94,11.5,8.94,6.94,7.25,7.97,6.78,6.31,8.22,11.34,12.41,12.0,12.75,14.78,15.5,14.75,15.38,18.19,20.91,20.75,21.0,22.88,24.38,23.19,20.88,20.12,19.81,18.06,14.62,12.31,11.84,10.78,8.34,7.34,9.44,12.28,13.69,14.97,18.47,22.69,24.16,24.59,26.16,28.66,29.09,27.25,25.62,25.31,23.94,20.22,17.31,16.91,17.0,14.88,13.0,13.25,14.62,14.62,14.06,15.12,18.0,19.78,19.91,21.28,24.38,26.59,26.22,25.41,26.62,27.88,26.62,25.19,25.09,25.88,24.53,21.59,20.62,21.38,21.78,20.34,20.22,22.62,24.84,24.88,24.34,25.66,27.25,26.22,24.28,23.84,24.81,24.16,22.03,21.09,22.44,23.06,22.09,21.19,22.38,23.41,21.56,19.41,19.38,20.56,20.31,19.56,20.22,22.47,23.22,21.75,21.12,22.38,22.56,20.44,18.56,18.72,19.03,17.09,14.66,14.25,14.88,13.88,12.0,11.91,13.62,14.03,12.72,11.59,12.72,13.5,12.66,12.0,13.88,16.5,17.0,16.38,17.31,18.97,18.25,16.41,15.28,15.78,15.25,13.0,11.66,12.78,14.5,13.78,13.0,14.03,15.62,14.56,12.69,12.22,12.97,12.59,11.12,11.25,13.59,15.22,15.16,15.12,16.72,18.56,18.47,18.0,19.69,22.97,24.03,23.56,24.19,25.69,25.34,22.78,20.66,20.28,18.62,14.69,10.97,9.69,9.81,8.19,7.0,8.72,12.06,13.62,14.09,15.34,17.91,19.03,17.91,16.44,17.06,17.16,15.09,13.16,13.88,15.56,15.03,13.31,13.06,14.19,13.5,11.28,10.25,11.03,10.78,8.41,6.31,6.34,6.88,5.09,3.59,5.19,8.28,10.53,12.66,16.72,21.72,25.16,25.91,26.53,28.44,28.75,26.38,22.97,21.72,20.28,16.38,11.69,9.69,9.22,7.81,5.72,6.22,8.78,10.5,10.81,11.97,15.91,19.56,20.94,21.84,23.94,25.81,24.88,22.47,22.03,23.19,23.28,22.5,23.31,26.03,27.38,25.91,24.41,24.44,24.16,21.44,17.94,16.72,16.62,14.94,12.88,13.75,16.25,17.81,17.59,18.19,20.69,22.5,21.78,20.78,21.75,22.75,21.53,19.22,19.34,20.28,19.53,17.06,16.38,17.06,16.78,15.41,15.12,17.62,19.88,19.88,19.66,21.91,25.06,26.5,27.25,29.62,31.59,31.16,28.0,26.03,25.69,24.53,21.97,20.75,22.38,23.81,22.91,20.97,20.69,20.66,18.69,16.16,15.97,17.69,18.19,16.72,16.94,19.53,21.56,21.28,21.34,23.12,24.69,23.56,21.47,21.75,22.16,20.59,17.81,17.12,17.97,18.03,16.22,15.66,16.81,17.91,16.81,16.5,19.12,22.56,23.69,23.44,24.09,25.19,23.62,20.41,18.78,18.59,17.16,13.72,11.44,11.84,13.25,12.91,13.41,16.16,19.44,20.06,19.25,19.97,21.72,21.84,20.0,19.28,20.06,19.94,17.41,15.47,15.5,15.47,12.81,9.72,8.91,9.03,7.66,5.44,5.38,7.06,7.94,7.19,7.5,10.16,12.03,10.97,10.59,11.78,13.16,12.28,10.91,11.28,12.72,12.38,10.56,9.84,10.47:-2.81,-3.25,-3.56,-1.72,2.28,4.66,4.78,5.78,8.03,9.12,7.91,7.56,9.47,11.28,10.97,10.94,12.25,13.94,13.41,10.91,8.88,7.84,5.03,0.69,-1.88,-2.19,-2.31,-4.12,-5.56,-5.5,-5.59,-7.94,-11.41,-12.94,-12.84,-14.19,-15.78,-14.94,-11.34,-8.09,-5.94,-3.0,1.5,4.97,5.59,5.22,6.59,8.53,8.0,6.97,7.59,9.44,9.25,7.31,6.41,7.41,7.59,6.25,5.5,7.44,9.53,9.16,9.56,11.5,13.88,14.22,13.09,13.38,14.75,14.84,13.19,12.28,13.25,13.88,12.47,11.41,12.81,13.91,13.41,11.97,11.94,12.94,11.75,9.53,8.47,9.12,8.94,6.66,5.12,5.59,5.81,3.84,2.53,4.06,6.75,8.19,9.06,11.44,15.06,16.5,16.28,16.84,18.94,20.25,18.78,17.62,18.22,18.78,16.78,14.28,13.78,13.69,11.34,7.88,6.28,6.66,6.41,5.03,5.41,7.56,9.19,8.91,8.69,10.81,13.16,14.09,14.34,16.94,20.47,22.03,21.38,21.34,21.94,21.09,18.53,16.66,17.53,18.03,16.31,14.0,13.53,13.5,11.38,9.0,8.62,9.88,9.91,8.72,8.81,10.88,11.88,10.75,9.94,11.59,13.22,12.53,11.59,13.22,15.5,15.34,14.0,14.19,14.59,13.31,9.94,7.78,8.09,8.59,7.62,7.69,10.25,12.81,13.41,13.12,14.47,16.66,16.62,15.19,14.78,15.69,15.16,13.0,12.03,13.75,15.34,15.12,14.88,16.91,19.22,19.31,18.53,19.34,20.94,20.72,18.75,17.88,18.47,18.12,15.53,13.47,14.06,14.41,13.12,11.69,12.28,13.66,12.62,10.44,9.75,10.44,9.84,7.56,6.84,7.84,8.66,7.31,6.28,7.84,9.69,9.41,8.75,10.0,12.28,12.69,11.19,11.94,13.91,14.28,12.69,11.62,12.28,11.75,8.78,6.25,6.22,6.62,5.28,3.09,3.47,4.91,4.53,2.84,2.75,4.22,5.0,3.97,4.34,7.16,9.69,9.94,8.88,9.38,9.94,7.88,5.06,4.66,6.03,6.19,5.0,5.12,6.41,7.0,4.84,3.19,3.56,4.47,2.91,1.25,2.41,3.91,3.91,2.44,2.56,3.88,3.66,1.88,1.38,3.0,4.22,3.03,2.28,3.59,5.62,5.25,4.72,6.47,8.97,9.62,8.31,8.34,9.53,8.78,5.81,3.31,2.72,1.56,-1.59,-4.09,-3.41,-0.97,0.44,2.06,5.78,10.66,13.62,13.72,14.28,15.69,15.31,12.38,10.06,9.88,9.72,7.19,4.5,4.19,4.56,2.81,0.16,-0.91,-0.25,-0.28,-1.38,-0.38,3.38,7.09,8.72,10.16,13.62,16.94,17.12,16.47,17.5,18.66,17.28,14.09,12.09,11.28,9.5,6.16,4.44,5.81,7.75,7.81,8.16,10.25,12.56,11.44,9.25,8.91,9.78,9.25,8.31,9.31,12.72,15.5,15.88,16.72,18.81,20.38,18.38,15.53,15.09,15.56,14.06,12.31,12.88,14.78,15.22,13.78,12.88,13.66,13.84,11.72,11.09,13.5,16.44,16.66,16.5,17.91,19.19,18.22,15.84,14.84,16.0,16.03,14.81,14.75,16.88,18.53,17.44,16.25,17.31,17.88,15.72,13.06,13.0,14.88,14.94,14.16,14.5,15.91,15.0,11.91,9.69,10.0,10.06,8.03,6.78,7.75,10.31,10.97,11.72,14.41,18.28,19.91,19.81,20.44,22.5,23.34,22.19,21.31,22.25,23.31,21.59,19.28,19.72,21.19,20.53,18.84,19.06,20.25,19.5,16.97,15.31,16.25,16.94,15.56,14.88,16.62,18.31,17.28,15.72,16.31,18.12,18.31,17.31,17.41,18.59,18.19,15.44,13.88,14.56,14.72,12.72,10.66,10.94,11.88,10.66,9.28,10.09,12.59,13.19,12.31,12.81,15.28,16.47,15.94,16.28,18.81,20.88,20.69,19.94,20.88,22.56,22.16,20.94,21.78,23.53,23.34,21.19,19.78,20.03,19.5,16.84,14.5,15.03,15.31,13.91,12.22,13.62,15.97,16.75,16.44,17.06,18.78,18.56,16.62,15.72,17.78,19.38,18.75,17.91,19.03,19.91,18.69,17.06,17.62,19.81,20.12,19.16,19.38,21.34,21.69,19.56,17.53,17.41,16.84,14.09,11.78,12.69,14.44,14.66,14.41,16.0,19.09,20.66,20.38,20.78,22.78,23.0,21.75,21.12,23.75,26.66,27.25,27.09,28.22,29.38,27.84,24.69,23.19,22.75,20.62,17.06,14.78,15.47,16.06,15.19,15.34,18.03,20.81,21.81,22.03,23.94,26.59,26.81,25.12,24.81,25.72,25.31,23.03,21.78,22.78,23.94,23.22,22.84,24.97,27.47,27.53,26.25,27.25,28.72,28.84,26.84,26.19,26.72,27.03,24.94,23.34,24.69,25.47,24.16,22.41,22.62,23.09,21.03,17.16,14.84,14.34,13.47,11.69,11.62,14.31,16.69,16.78,17.28,20.19,22.84,23.22,22.78,24.28,26.19,25.88,23.75,22.75,23.0,21.94,18.84,17.0,17.69,18.12,16.38,15.53,17.22,19.16,18.72,17.19,17.28,17.97,17.41,15.56,16.12,18.88,20.97,21.06,21.84,24.66,27.19,27.25,27.0,29.5,31.72,32.12,30.78,30.88,31.25,29.81,26.44,24.84,25.34,26.16,25.91,26.56,29.5,32.59,33.34,33.41,34.81,36.47,35.72,33.59,32.84,33.12,32.56,30.56,29.69,31.25,32.28,31.09,29.5,29.66,29.78,27.41,24.59,23.97,24.47,23.97,22.06,22.16,23.56,24.41,22.72,21.84,22.88,23.66,21.81,19.78,19.56,20.03,18.94,16.91,17.0,18.5,18.88,17.5,17.88,20.0,21.75,21.72,21.88,23.69,25.59,24.53,22.97,23.44,24.56,23.72,22.16,22.34,23.88,24.22,22.59,22.12,23.59,23.84,21.72,20.09,20.78,22.0,21.31,20.31,21.25,22.84,22.59,20.97,21.06,22.5,22.75,20.75,19.5,19.84,20.03,18.59,17.5,18.75,20.81,20.34,18.84,18.84,19.62,18.34,15.38,13.84,14.44,14.5,13.25,13.06,15.47,18.0,18.28,18.22,19.72,22.0,21.78,20.16,19.59,19.84,18.03,14.47,12.09,11.94,11.5,8.94,6.94,7.25,7.97,6.78,6.31,8.22,11.34,12.41,12.0,12.75,14.78,15.5,14.75,15.38,18.19,20.91,20.75,21.0,22.88,24.38,23.19,20.88,20.12,19.81,18.06,14.62,12.31,11.84,10.78,8.34,7.34,9.44,12.28,13.69,14.97,18.47,22.69,24.16,24.59,26.16,28.66,29.09,27.25,25.62,25.31,23.94,20.22,17.31,16.91,17.0,14.88,13.0,13.25,14.62,14.62,14.06,15.12,18.0,19.78,19.91,21.28,24.38,26.59,26.22,25.41,26.62,27.88,26.62,25.19,25.09,25.88,24.53,21.59,20.62,21.38,21.78,20.34,20.22,22.62,24.84,24.88,24.34,25.66,27.25,26.22,24.28,23.84,24.81,24.16,22.03,21.09,22.44,23.06,22.09,21.19,22.38,23.41,21.56,19.41,19.38,20.56,20.31,19.56,20.22,22.47,23.22,21.75,21.12,22.38,22.56,20.44,18.56,18.72,19.03,17.09,14.66,14.25,14.88,13.88,12.0,11.91,13.62,14.03,12.72,11.59,12.72,13.5,12.66,12.0,13.88,16.5,17.0,16.38,17.31,18.97,18.25,16.41,15.28,15.78,15.25,13.0,11.66,12.78,14.5,13.78,13.0,14.03,15.62,14.56,12.69,12.22,12.97,12.59,11.12,11.25,13.59,15.22,15.16,15.12,16.72,18.56,18.47,18.0,19.69,22.97,24.03,23.56,24.19,25.69,25.34,22.78,20.66,20.28,18.62,14.69,10.97,9.69,9.81,8.19,7.0,8.72,12.06,13.62,14.09,15.34,17.91,19.03,17.91,16.44,17.06,17.16,15.09,13.16,13.88,15.56,15.03,13.31,13.06,14.19,13.5,11.28,10.25,11.03,10.78,8.41,6.31,6.34,6.88,5.09,3.59,5.19,8.28,10.53,12.66,16.72,21.72,25.16,25.91,26.53,28.44,28.75,26.38,22.97,21.72,20.28,16.38,11.69,9.69,9.22,7.81,5.72,6.22,8.78,10.5,10.81,11.97,15.91,19.56,20.94,21.84,23.94,25.81,24.88,22.47,22.03,23.19,23.28,22.5,23.31,26.03,27.38,25.91,24.41,24.44,24.16,21.44,17.94,16.72,16.62,14.94,12.88,13.75,16.25,17.81,17.59,18.19,20.69,22.5,21.78,20.78,21.75,22.75,21.53,19.22,19.34,20.28,19.53,17.06,16.38,17.06,16.78,15.41,15.12,17.62,19.88,19.88,19.66,21.91,25.06,26.5,27.25,29.62,31.59,31.16,28.0,26.03,25.69,24.53,21.97,20.75,22.38,23.81,22.91,20.97,20.69,20.66,18.69,16.16,15.97,17.69,18.19,16.72,16.94,19.53,21.56,21.28,21.34,23.12,24.69,23.56,21.47,21.75,22.16,20.59,17.81,17.12,17.97,18.03,16.22,15.66,16.81,17.91,16.81,16.5,19.12,22.56,23.69,23.44,24.09,25.19,23.62,20.41,18.78,18.59,17.16,13.72,11.44,11.84,13.25,12.91,13.41,16.16,19.44,20.06,19.25,19.97,21.72,21.84,20.0,19.28,20.06,19.94,17.41,15.47,15.5,15.47,12.81,9.72,8.91,9.03,7.66,5.44,5.38,7.06,7.94,7.19,7.5,10.16,12.03,10.97,10.59,11.78,13.16,12.28,10.91,11.28,12.72,12.38,10.56,9.84,10.47,21.44,20.41,20.69,21.34,20.5,19.91,20.69:5.78,8.03,9.12,7.91,7.56,9.47,11.28,10.97,10.94,12.25,13.94,13.41,10.91,8.88,7.84,5.03,0.69,-1.88,-2.19,-2.31,-4.12,-5.56,-5.5,-5.59,-7.94,-11.41,-12.94,-12.84,-14.19,-15.78,-14.94,-11.34,-8.09,-5.94,-3.0,1.5,4.97,5.59,5.22,6.59,8.53,8.0,6.97,7.59,9.44,9.25,7.31,6.41,7.41,7.59,6.25,5.5,7.44,9.53,9.16,9.56,11.5,13.88,14.22,13.09,13.38,14.75,14.84,13.19,12.28,13.25,13.88,12.47,11.41,12.81,13.91,13.41,11.97,11.94,12.94,11.75,9.53,8.47,9.12,8.94,6.66,5.12,5.59,5.81,3.84,2.53,4.06,6.75,8.19,9.06,11.44,15.06,16.5,16.28,16.84,18.94,20.25,18.78,17.62,18.22,18.78,16.78,14.28,13.78,13.69,11.34,7.88,6.28,6.66,6.41,5.03,5.41,7.56,9.19,8.91,8.69,10.81,13.16,14.09,14.34,16.94,20.47,22.03,21.38,21.34,21.94,21.09,18.53,16.66,17.53,18.03,16.31,14.0,13.53,13.5,11.38,9.0,8.62,9.88,9.91,8.72,8.81,10.88,11.88,10.75,9.94,11.59,13.22,12.53,11.59,13.22,15.5,15.34,14.0,14.19,14.59,13.31,9.94,7.78,8.09,8.59,7.62,7.69,10.25,12.81,13.41,13.12,14.47,16.66,16.62,15.19,14.78,15.69,15.16,13.0,12.03,13.75,15.34,15.12,14.88,16.91,19.22,19.31,18.53,19.34,20.94,20.72,18.75,17.88,18.47,18.12,15.53,13.47,14.06,14.41,13.12,11.69,12.28,13.66,12.62,10.44,9.75,10.44,9.84,7.56,6.84,7.84,8.66,7.31,6.28,7.84,9.69,9.41,8.75,10.0,12.28,12.69,11.19,11.94,13.91,14.28,12.69,11.62,12.28,11.75,8.78,6.25,6.22,6.62,5.28,3.09,3.47,4.91,4.53,2.84,2.75,4.22,5.0,3.97,4.34,7.16,9.69,9.94,8.88,9.38,9.94,7.88,5.06,4.66,6.03,6.19,5.0,5.12,6.41,7.0,4.84,3.19,3.56,4.47,2.91,1.25,2.41,3.91,3.91,2.44,2.56,3.88,3.66,1.88,1.38,3.0,4.22,3.03,2.28,3.59,5.62,5.25,4.72,6.47,8.97,9.62,8.31,8.34,9.53,8.78,5.81,3.31,2.72,1.56,-1.59,-4.09,-3.41,-0.97,0.44,2.06,5.78,10.66,13.62,13.72,14.28,15.69,15.31,12.38,10.06,9.88,9.72,7.19,4.5,4.19,4.56,2.81,0.16,-0.91,-0.25,-0.28,-1.38,-0.38,3.38,7.09,8.72,10.16,13.62,16.94,17.12,16.47,17.5,18.66,17.28,14.09,12.09,11.28,9.5,6.16,4.44,5.81,7.75,7.81,8.16,10.25,12.56,11.44,9.25,8.91,9.78,9.25,8.31,9.31,12.72,15.5,15.88,16.72,18.81,20.38,18.38,15.53,15.09,15.56,14.06,12.31,12.88,14.78,15.22,13.78,12.88,13.66,13.84,11.72,11.09,13.5,16.44,16.66,16.5,17.91,19.19,18.22,15.84,14.84,16.0,16.03,14.81,14.75,16.88,18.53,17.44,16.25,17.31,17.88,15.72,13.06,13.0,14.88,14.94,14.16,14.5,15.91,15.0,11.91,9.69,10.0,10.06,8.03,6.78,7.75,10.31,10.97,11.72,14.41,18.28,19.91,19.81,20.44,22.5,23.34,22.19,21.31,22.25,23.31,21.59,19.28,19.72,21.19,20.53,18.84,19.06,20.25,19.5,16.97,15.31,16.25,16.94,15.56,14.88,16.62,18.31,17.28,15.72,16.31,18.12,18.31,17.31,17.41,18.59,18.19,15.44,13.88,14.56,14.72,12.72,10.66,10.94,11.88,10.66,9.28,10.09,12.59,13.19,12.31,12.81,15.28,16.47,15.94,16.28,18.81,20.88,20.69,19.94,20.88,22.56,22.16,20.94,21.78,23.53,23.34,21.19,19.78,20.03,19.5,16.84,14.5,15.03,15.31,13.91,12.22,13.62,15.97,16.75,16.44,17.06,18.78,18.56,16.62,15.72,17.78,19.38,18.75,17.91,19.03,19.91,18.69,17.06,17.62,19.81,20.12,19.16,19.38,21.34,21.69,19.56,17.53,17.41,16.84,14.09,11.78,12.69,14.44,14.66,14.41,16.0,19.09,20.66,20.38,20.78,22.78,23.0,21.75,21.12,23.75,26.66,27.25,27.09,28.22,29.38,27.84,24.69,23.19,22.75,20.62,17.06,14.78,15.47,16.06,15.19,15.34,18.03,20.81,21.81,22.03,23.94,26.59,26.81,25.12,24.81,25.72,25.31,23.03,21.78,22.78,23.94,23.22,22.84,24.97,27.47,27.53,26.25,27.25,28.72,28.84,26.84,26.19,26.72,27.03,24.94,23.34,24.69,25.47,24.16,22.41,22.62,23.09,21.03,17.16,14.84,14.34,13.47,11.69,11.62,14.31,16.69,16.78,17.28,20.19,22.84,23.22,22.78,24.28,26.19,25.88,23.75,22.75,23.0,21.94,18.84,17.0,17.69,18.12,16.38,15.53,17.22,19.16,18.72,17.19,17.28,17.97,17.41,15.56,16.12,18.88,20.97,21.06,21.84,24.66,27.19,27.25,27.0,29.5,31.72,32.12,30.78,30.88,31.25,29.81,26.44,24.84,25.34,26.16,25.91,26.56,29.5,32.59,33.34,33.41,34.81,36.47,35.72,33.59,32.84,33.12,32.56,30.56,29.69,31.25,32.28,31.09,29.5,29.66,29.78,27.41,24.59,23.97,24.47,23.97,22.06,22.16,23.56,24.41,22.72,21.84,22.88,23.66,21.81,19.78,19.56,20.03,18.94,16.91,17.0,18.5,18.88,17.5,17.88,20.0,21.75,21.72,21.88,23.69,25.59,24.53,22.97,23.44,24.56,23.72,22.16,22.34,23.88,24.22,22.59,22.12,23.59,23.84,21.72,20.09,20.78,22.0,21.31,20.31,21.25,22.84,22.59,20.97,21.06,22.5,22.75,20.75,19.5,19.84,20.03,18.59,17.5,18.75,20.81,20.34,18.84,18.84,19.62,18.34,15.38,13.84,14.44,14.5,13.25,13.06,15.47,18.0,18.28,18.22,19.72,22.0,21.78,20.16,19.59,19.84,18.03,14.47,12.09,11.94,11.5,8.94,6.94,7.25,7.97,6.78,6.31,8.22,11.34,12.41,12.0,12.75,14.78,15.5,14.75,15.38,18.19,20.91,20.75,21.0,22.88,24.38,23.19,20.88,20.12,19.81,18.06,14.62,12.31,11.84,10.78,8.34,7.34,9.44,12.28,13.69,14.97,18.47,22.69,24.16,24.59,26.16,28.66,29.09,27.25,25.62,25.31,23.94,20.22,17.31,16.91,17.0,14.88,13.0,13.25,14.62,14.62,14.06,15.12,18.0,19.78,19.91,21.28,24.38,26.59,26.22,25.41,26.62,27.88,26.62,25.19,25.09,25.88,24.53,21.59,20.62,21.38,21.78,20.34,20.22,22.62,24.84,24.88,24.34,25.66,27.25,26.22,24.28,23.84,24.81,24.16,22.03,21.09,22.44,23.06,22.09,21.19,22.38,23.41,21.56,19.41,19.38,20.56,20.31,19.56,20.22,22.47,23.22,21.75,21.12,22.38,22.56,20.44,18.56,18.72,19.03,17.09,14.66,14.25,14.88,13.88,12.0,11.91,13.62,14.03,12.72,11.59,12.72,13.5,12.66,12.0,13.88,16.5,17.0,16.38,17.31,18.97,18.25,16.41,15.28,15.78,15.25,13.0,11.66,12.78,14.5,13.78,13.0,14.03,15.62,14.56,12.69,12.22,12.97,12.59,11.12,11.25,13.59,15.22,15.16,15.12,16.72,18.56,18.47,18.0,19.69,22.97,24.03,23.56,24.19,25.69,25.34,22.78,20.66,20.28,18.62,14.69,10.97,9.69,9.81,8.19,7.0,8.72,12.06,13.62,14.09,15.34,17.91,19.03,17.91,16.44,17.06,17.16,15.09,13.16,13.88,15.56,15.03,13.31,13.06,14.19,13.5,11.28,10.25,11.03,10.78,8.41,6.31,6.34,6.88,5.09,3.59,5.19,8.28,10.53,12.66,16.72,21.72,25.16,25.91,26.53,28.44,28.75,26.38,22.97,21.72,20.28,16.38,11.69,9.69,9.22,7.81,5.72,6.22,8.78,10.5,10.81,11.97,15.91,19.56,20.94,21.84,23.94,25.81,24.88,22.47,22.03,23.19,23.28,22.5,23.31,26.03,27.38,25.91,24.41,24.44,24.16,21.44,17.94,16.72,16.62,14.94,12.88,13.75,16.25,17.81,17.59,18.19,20.69,22.5,21.78,20.78,21.75,22.75,21.53,19.22,19.34,20.28,19.53,17.06,16.38,17.06,16.78,15.41,15.12,17.62,19.88,19.88,19.66,21.91,25.06,26.5,27.25,29.62,31.59,31.16,28.0,26.03,25.69,24.53,21.97,20.75,22.38,23.81,22.91,20.97,20.69,20.66,18.69,16.16,15.97,17.69,18.19,16.72,16.94,19.53,21.56,21.28,21.34,23.12,24.69,23.56,21.47,21.75,22.16,20.59,17.81,17.12,17.97,18.03,16.22,15.66,16.81,17.91,16.81,16.5,19.12,22.56,23.69,23.44,24.09,25.19,23.62,20.41,18.78,18.59,17.16,13.72,11.44,11.84,13.25,12.91,13.41,16.16,19.44,20.06,19.25,19.97,21.72,21.84,20.0,19.28,20.06,19.94,17.41,15.47,15.5,15.47,12.81,9.72,8.91,9.03,7.66,5.44,5.38,7.06,7.94,7.19,7.5,10.16,12.03,10.97,10.59,11.78,13.16,12.28,10.91,11.28,12.72,12.38,10.56,9.84,10.47,21.44,20.41,20.69,21.34,20.5,19.91,20.69,21.81,21.81,22.75,25.03,28.31,30.56,31.25:10.97,10.94,12.25,13.94,13.41,10.91,8.88,7.84,5.03,0.69,-1.88,-2.19,-2.31,-4.12,-5.56,-5.5,-5.59,-7.94,-11.41,-12.94,-12.84,-14.19,-15.78,-14.94,-11.34,-8.09,-5.94,-3.0,1.5,4.97,5.59,5.22,6.59,8.53,8.0,6.97,7.59,9.44,9.25,7.31,6.41,7.41,7.59,6.25,5.5,7.44,9.53,9.16,9.56,11.5,13.88,14.22,13.09,13.38,14.75,14.84,13.19,12.28,13.25,13.88,12.47,11.41,12.81,13.91,13.41,11.97,11.94,12.94,11.75,9.53,8.47,9.12,8.94,6.66,5.12,5.59,5.81,3.84,2.53,4.06,6.75,8.19,9.06,11.44,15.06,16.5,16.28,16.84,18.94,20.25,18.78,17.62,18.22,18.78,16.78,14.28,13.78,13.69,11.34,7.88,6.28,6.66,6.41,5.03,5.41,7.56,9.19,8.91,8.69,10.81,13.16,14.09,14.34,16.94,20.47,22.03,21.38,21.34,21.94,21.09,18.53,16.66,17.53,18.03,16.31,14.0,13.53,13.5,11.38,9.0,8.62,9.88,9.91,8.72,8.81,10.88,11.88,10.75,9.94,11.59,13.22,12.53,11.59,13.22,15.5,15.34,14.0,14.19,14.59,13.31,9.94,7.78,8.09,8.59,7.62,7.69,10.25,12.81,13.41,13.12,14.47,16.66,16.62,15.19,14.78,15.69,15.16,13.0,12.03,13.75,15.34,15.12,14.88,16.91,19.22,19.31,18.53,19.34,20.94,20.72,18.75,17.88,18.47,18.12,15.53,13.47,14.06,14.41,13.12,11.69,12.28,13.66,12.62,10.44,9.75,10.44,9.84,7.56,6.84,7.84,8.66,7.31,6.28,7.84,9.69,9.41,8.75,10.0,12.28,12.69,11.19,11.94,13.91,14.28,12.69,11.62,12.28,11.75,8.78,6.25,6.22,6.62,5.28,3.09,3.47,4.91,4.53,2.84,2.75,4.22,5.0,3.97,4.34,7.16,9.69,9.94,8.88,9.38,9.94,7.88,5.06,4.66,6.03,6.19,5.0,5.12,6.41,7.0,4.84,3.19,3.56,4.47,2.91,1.25,2.41,3.91,3.91,2.44,2.56,3.88,3.66,1.88,1.38,3.0,4.22,3.03,2.28,3.59,5.62,5.25,4.72,6.47,8.97,9.62,8.31,8.34,9.53,8.78,5.81,3.31,2.72,1.56,-1.59,-4.09,-3.41,-0.97,0.44,2.06,5.78,10.66,13.62,13.72,14.28,15.69,15.31,12.38,10.06,9.88,9.72,7.19,4.5,4.19,4.56,2.81,0.16,-0.91,-0.25,-0.28,-1.38,-0.38,3.38,7.09,8.72,10.16,13.62,16.94,17.12,16.47,17.5,18.66,17.28,14.09,12.09,11.28,9.5,6.16,4.44,5.81,7.75,7.81,8.16,10.25,12.56,11.44,9.25,8.91,9.78,9.25,8.31,9.31,12.72,15.5,15.88,16.72,18.81,20.38,18.38,15.53,15.09,15.56,14.06,12.31,12.88,14.78,15.22,13.78,12.88,13.66,13.84,11.72,11.09,13.5,16.44,16.66,16.5,17.91,19.19,18.22,15.84,14.84,16.0,16.03,14.81,14.75,16.88,18.53,17.44,16.25,17.31,17.88,15.72,13.06,13.0,14.88,14.94,14.16,14.5,15.91,15.0,11.91,9.69,10.0,10.06,8.03,6.78,7.75,10.31,10.97,11.72,14.41,18.28,19.91,19.81,20.44,22.5,23.34,22.19,21.31,22.25,23.31,21.59,19.28,19.72,21.19,20.53,18.84,19.06,20.25,19.5,16.97,15.31,16.25,16.94,15.56,14.88,16.62,18.31,17.28,15.72,16.31,18.12,18.31,17.31,17.41,18.59,18.19,15.44,13.88,14.56,14.72,12.72,10.66,10.94,11.88,10.66,9.28,10.09,12.59,13.19,12.31,12.81,15.28,16.47,15.94,16.28,18.81,20.88,20.69,19.94,20.88,22.56,22.16,20.94,21.78,23.53,23.34,21.19,19.78,20.03,19.5,16.84,14.5,15.03,15.31,13.91,12.22,13.62,15.97,16.75,16.44,17.06,18.78,18.56,16.62,15.72,17.78,19.38,18.75,17.91,19.03,19.91,18.69,17.06,17.62,19.81,20.12,19.16,19.38,21.34,21.69,19.56,17.53,17.41,16.84,14.09,11.78,12.69,14.44,14.66,14.41,16.0,19.09,20.66,20.38,20.78,22.78,23.0,21.75,21.12,23.75,26.66,27.25,27.09,28.22,29.38,27.84,24.69,23.19,22.75,20.62,17.06,14.78,15.47,16.06,15.19,15.34,18.03,20.81,21.81,22.03,23.94,26.59,26.81,25.12,24.81,25.72,25.31,23.03,21.78,22.78,23.94,23.22,22.84,24.97,27.47,27.53,26.25,27.25,28.72,28.84,26.84,26.19,26.72,27.03,24.94,23.34,24.69,25.47,24.16,22.41,22.62,23.09,21.03,17.16,14.84,14.34,13.47,11.69,11.62,14.31,16.69,16.78,17.28,20.19,22.84,23.22,22.78,24.28,26.19,25.88,23.75,22.75,23.0,21.94,18.84,17.0,17.69,18.12,16.38,15.53,17.22,19.16,18.72,17.19,17.28,17.97,17.41,15.56,16.12,18.88,20.97,21.06,21.84,24.66,27.19,27.25,27.0,29.5,31.72,32.12,30.78,30.88,31.25,29.81,26.44,24.84,25.34,26.16,25.91,26.56,29.5,32.59,33.34,33.41,34.81,36.47,35.72,33.59,32.84,33.12,32.56,30.56,29.69,31.25,32.28,31.09,29.5,29.66,29.78,27.41,24.59,23.97,24.47,23.97,22.06,22.16,23.56,24.41,22.72,21.84,22.88,23.66,21.81,19.78,19.56,20.03,18.94,16.91,17.0,18.5,18.88,17.5,17.88,20.0,21.75,21.72,21.88,23.69,25.59,24.53,22.97,23.44,24.56,23.72,22.16,22.34,23.88,24.22,22.59,22.12,23.59,23.84,21.72,20.09,20.78,22.0,21.31,20.31,21.25,22.84,22.59,20.97,21.06,22.5,22.75,20.75,19.5,19.84,20.03,18.59,17.5,18.75,20.81,20.34,18.84,18.84,19.62,18.34,15.38,13.84,14.44,14.5,13.25,13.06,15.47,18.0,18.28,18.22,19.72,22.0,21.78,20.16,19.59,19.84,18.03,14.47,12.09,11.94,11.5,8.94,6.94,7.25,7.97,6.78,6.31,8.22,11.34,12.41,12.0,12.75,14.78,15.5,14.75,15.38,18.19,20.91,20.75,21.0,22.88,24.38,23.19,20.88,20.12,19.81,18.06,14.62,12.31,11.84,10.78,8.34,7.34,9.44,12.28,13.69,14.97,18.47,22.69,24.16,24.59,26.16,28.66,29.09,27.25,25.62,25.31,23.94,20.22,17.31,16.91,17.0,14.88,13.0,13.25,14.62,14.62,14.06,15.12,18.0,19.78,19.91,21.28,24.38,26.59,26.22,25.41,26.62,27.88,26.62,25.19,25.09,25.88,24.53,21.59,20.62,21.38,21.78,20.34,20.22,22.62,24.84,24.88,24.34,25.66,27.25,26.22,24.28,23.84,24.81,24.16,22.03,21.09,22.44,23.06,22.09,21.19,22.38,23.41,21.56,19.41,19.38,20.56,20.31,19.56,20.22,22.47,23.22,21.75,21.12,22.38,22.56,20.44,18.56,18.72,19.03,17.09,14.66,14.25,14.88,13.88,12.0,11.91,13.62,14.03,12.72,11.59,12.72,13.5,12.66,12.0,13.88,16.5,17.0,16.38,17.31,18.97,18.25,16.41,15.28,15.78,15.25,13.0,11.66,12.78,14.5,13.78,13.0,14.03,15.62,14.56,12.69,12.22,12.97,12.59,11.12,11.25,13.59,15.22,15.16,15.12,16.72,18.56,18.47,18.0,19.69,22.97,24.03,23.56,24.19,25.69,25.34,22.78,20.66,20.28,18.62,14.69,10.97,9.69,9.81,8.19,7.0,8.72,12.06,13.62,14.09,15.34,17.91,19.03,17.91,16.44,17.06,17.16,15.09,13.16,13.88,15.56,15.03,13.31,13.06,14.19,13.5,11.28,10.25,11.03,10.78,8.41,6.31,6.34,6.88,5.09,3.59,5.19,8.28,10.53,12.66,16.72,21.72,25.16,25.91,26.53,28.44,28.75,26.38,22.97,21.72,20.28,16.38,11.69,9.69,9.22,7.81,5.72,6.22,8.78,10.5,10.81,11.97,15.91,19.56,20.94,21.84,23.94,25.81,24.88,22.47,22.03,23.19,23.28,22.5,23.31,26.03,27.38,25.91,24.41,24.44,24.16,21.44,17.94,16.72,16.62,14.94,12.88,13.75,16.25,17.81,17.59,18.19,20.69,22.5,21.78,20.78,21.75,22.75,21.53,19.22,19.34,20.28,19.53,17.06,16.38,17.06,16.78,15.41,15.12,17.62,19.88,19.88,19.66,21.91,25.06,26.5,27.25,29.62,31.59,31.16,28.0,26.03,25.69,24.53,21.97,20.75,22.38,23.81,22.91,20.97,20.69,20.66,18.69,16.16,15.97,17.69,18.19,16.72,16.94,19.53,21.56,21.28,21.34,23.12,24.69,23.56,21.47,21.75,22.16,20.59,17.81,17.12,17.97,18.03,16.22,15.66,16.81,17.91,16.81,16.5,19.12,22.56,23.69,23.44,24.09,25.19,23.62,20.41,18.78,18.59,17.16,13.72,11.44,11.84,13.25,12.91,13.41,16.16,19.44,20.06,19.25,19.97,21.72,21.84,20.0,19.28,20.06,19.94,17.41,15.47,15.5,15.47,12.81,9.72,8.91,9.03,7.66,5.44,5.38,7.06,7.94,7.19,7.5,10.16,12.03,10.97,10.59,11.78,13.16,12.28,10.91,11.28,12.72,12.38,10.56,9.84,10.47,21.44,20.41,20.69,21.34,20.5,19.91,20.69,21.81,21.81,22.75,25.03,28.31,30.56,31.25,32.22,33.38,33.06,32.16,31.81,33.12,34.44:7.84,5.03,0.69,-1.88,-2.19,-2.31,-4.12,-5.56,-5.5,-5.59,-7.94,-11.41,-12.94,-12.84,-14.19,-15.78,-14.94,-11.34,-8.09,-5.94,-3.0,1.5,4.97,5.59,5.22,6.59,8.53,8.0,6.97,7.59,9.44,9.25,7.31,6.41,7.41,7.59,6.25,5.5,7.44,9.53,9.16,9.56,11.5,13.88,14.22,13.09,13.38,14.75,14.84,13.19,12.28,13.25,13.88,12.47,11.41,12.81,13.91,13.41,11.97,11.94,12.94,11.75,9.53,8.47,9.12,8.94,6.66,5.12,5.59,5.81,3.84,2.53,4.06,6.75,8.19,9.06,11.44,15.06,16.5,16.28,16.84,18.94,20.25,18.78,17.62,18.22,18.78,16.78,14.28,13.78,13.69,11.34,7.88,6.28,6.66,6.41,5.03,5.41,7.56,9.19,8.91,8.69,10.81,13.16,14.09,14.34,16.94,20.47,22.03,21.38,21.34,21.94,21.09,18.53,16.66,17.53,18.03,16.31,14.0,13.53,13.5,11.38,9.0,8.62,9.88,9.91,8.72,8.81,10.88,11.88,10.75,9.94,11.59,13.22,12.53,11.59,13.22,15.5,15.34,14.0,14.19,14.59,13.31,9.94,7.78,8.09,8.59,7.62,7.69,10.25,12.81,13.41,13.12,14.47,16.66,16.62,15.19,14.78,15.69,15.16,13.0,12.03,13.75,15.34,15.12,14.88,16.91,19.22,19.31,18.53,19.34,20.94,20.72,18.75,17.88,18.47,18.12,15.53,13.47,14.06,14.41,13.12,11.69,12.28,13.66,12.62,10.44,9.75,10.44,9.84,7.56,6.84,7.84,8.66,7.31,6.28,7.84,9.69,9.41,8.75,10.0,12.28,12.69,11.19,11.94,13.91,14.28,12.69,11.62,12.28,11.75,8.78,6.25,6.22,6.62,5.28,3.09,3.47,4.91,4.53,2.84,2.75,4.22,5.0,3.97,4.34,7.16,9.69,9.94,8.88,9.38,9.94,7.88,5.06,4.66,6.03,6.19,5.0,5.12,6.41,7.0,4.84,3.19,3.56,4.47,2.91,1.25,2.41,3.91,3.91,2.44,2.56,3.88,3.66,1.88,1.38,3.0,4.22,3.03,2.28,3.59,5.62,5.25,4.72,6.47,8.97,9.62,8.31,8.34,9.53,8.78,5.81,3.31,2.72,1.56,-1.59,-4.09,-3.41,-0.97,0.44,2.06,5.78,10.66,13.62,13.72,14.28,15.69,15.31,12.38,10.06,9.88,9.72,7.19,4.5,4.19,4.56,2.81,0.16,-0.91,-0.25,-0.28,-1.38,-0.38,3.38,7.09,8.72,10.16,13.62,16.94,17.12,16.47,17.5,18.66,17.28,14.09,12.09,11.28,9.5,6.16,4.44,5.81,7.75,7.81,8.16,10.25,12.56,11.44,9.25,8.91,9.78,9.25,8.31,9.31,12.72,15.5,15.88,16.72,18.81,20.38,18.38,15.53,15.09,15.56,14.06,12.31,12.88,14.78,15.22,13.78,12.88,13.66,13.84,11.72,11.09,13.5,16.44,16.66,16.5,17.91,19.19,18.22,15.84,14.84,16.0,16.03,14.81,14.75,16.88,18.53,17.44,16.25,17.31,17.88,15.72,13.06,13.0,14.88,14.94,14.16,14.5,15.91,15.0,11.91,9.69,10.0,10.06,8.03,6.78,7.75,10.31,10.97,11.72,14.41,18.28,19.91,19.81,20.44,22.5,23.34,22.19,21.31,22.25,23.31,21.59,19.28,19.72,21.19,20.53,18.84,19.06,20.25,19.5,16.97,15.31,16.25,16.94,15.56,14.88,16.62,18.31,17.28,15.72,16.31,18.12,18.31,17.31,17.41,18.59,18.19,15.44,13.88,14.56,14.72,12.72,10.66,10.94,11.88,10.66,9.28,10.09,12.59,13.19,12.31,12.81,15.28,16.47,15.94,16.28,18.81,20.88,20.69,19.94,20.88,22.56,22.16,20.94,21.78,23.53,23.34,21.19,19.78,20.03,19.5,16.84,14.5,15.03,15.31,13.91,12.22,13.62,15.97,16.75,16.44,17.06,18.78,18.56,16.62,15.72,17.78,19.38,18.75,17.91,19.03,19.91,18.69,17.06,17.62,19.81,20.12,19.16,19.38,21.34,21.69,19.56,17.53,17.41,16.84,14.09,11.78,12.69,14.44,14.66,14.41,16.0,19.09,20.66,20.38,20.78,22.78,23.0,21.75,21.12,23.75,26.66,27.25,27.09,28.22,29.38,27.84,24.69,23.19,22.75,20.62,17.06,14.78,15.47,16.06,15.19,15.34,18.03,20.81,21.81,22.03,23.94,26.59,26.81,25.12,24.81,25.72,25.31,23.03,21.78,22.78,23.94,23.22,22.84,24.97,27.47,27.53,26.25,27.25,28.72,28.84,26.84,26.19,26.72,27.03,24.94,23.34,24.69,25.47,24.16,22.41,22.62,23.09,21.03,17.16,14.84,14.34,13.47,11.69,11.62,14.31,16.69,16.78,17.28,20.19,22.84,23.22,22.78,24.28,26.19,25.88,23.75,22.75,23.0,21.94,18.84,17.0,17.69,18.12,16.38,15.53,17.22,19.16,18.72,17.19,17.28,17.97,17.41,15.56,16.12,18.88,20.97,21.06,21.84,24.66,27.19,27.25,27.0,29.5,31.72,32.12,30.78,30.88,31.25,29.81,26.44,24.84,25.34,26.16,25.91,26.56,29.5,32.59,33.34,33.41,34.81,36.47,35.72,33.59,32.84,33.12,32.56,30.56,29.69,31.25,32.28,31.09,29.5,29.66,29.78,27.41,24.59,23.97,24.47,23.97,22.06,22.16,23.56,24.41,22.72,21.84,22.88,23.66,21.81,19.78,19.56,20.03,18.94,16.91,17.0,18.5,18.88,17.5,17.88,20.0,21.75,21.72,21.88,23.69,25.59,24.53,22.97,23.44,24.56,23.72,22.16,22.34,23.88,24.22,22.59,22.12,23.59,23.84,21.72,20.09,20.78,22.0,21.31,20.31,21.25,22.84,22.59,20.97,21.06,22.5,22.75,20.75,19.5,19.84,20.03,18.59,17.5,18.75,20.81,20.34,18.84,18.84,19.62,18.34,15.38,13.84,14.44,14.5,13.25,13.06,15.47,18.0,18.28,18.22,19.72,22.0,21.78,20.16,19.59,19.84,18.03,14.47,12.09,11.94,11.5,8.94,6.94,7.25,7.97,6.78,6.31,8.22,11.34,12.41,12.0,12.75,14.78,15.5,14.75,15.38,18.19,20.91,20.75,21.0,22.88,24.38,23.19,20.88,20.12,19.81,18.06,14.62,12.31,11.84,10.78,8.34,7.34,9.44,12.28,13.69,14.97,18.47,22.69,24.16,24.59,26.16,28.66,29.09,27.25,25.62,25.31,23.94,20.22,17.31,16.91,17.0,14.88,13.0,13.25,14.62,14.62,14.06,15.12,18.0,19.78,19.91,21.28,24.38,26.59,26.22,25.41,26.62,27.88,26.62,25.19,25.09,25.88,24.53,21.59,20.62,21.38,21.78,20.34,20.22,22.62,24.84,24.88,24.34,25.66,27.25,26.22,24.28,23.84,24.81,24.16,22.03,21.09,22.44,23.06,22.09,21.19,22.38,23.41,21.56,19.41,19.38,20.56,20.31,19.56,20.22,22.47,23.22,21.75,21.12,22.38,22.56,20.44,18.56,18.72,19.03,17.09,14.66,14.25,14.88,13.88,12.0,11.91,13.62,14.03,12.72,11.59,12.72,13.5,12.66,12.0,13.88,16.5,17.0,16.38,17.31,18.97,18.25,16.41,15.28,15.78,15.25,13.0,11.66,12.78,14.5,13.78,13.0,14.03,15.62,14.56,12.69,12.22,12.97,12.59,11.12,11.25,13.59,15.22,15.16,15.12,16.72,18.56,18.47,18.0,19.69,22.97,24.03,23.56,24.19,25.69,25.34,22.78,20.66,20.28,18.62,14.69,10.97,9.69,9.81,8.19,7.0,8.72,12.06,13.62,14.09,15.34,17.91,19.03,17.91,16.44,17.06,17.16,15.09,13.16,13.88,15.56,15.03,13.31,13.06,14.19,13.5,11.28,10.25,11.03,10.78,8.41,6.31,6.34,6.88,5.09,3.59,5.19,8.28,10.53,12.66,16.72,21.72,25.16,25.91,26.53,28.44,28.75,26.38,22.97,21.72,20.28,16.38,11.69,9.69,9.22,7.81,5.72,6.22,8.78,10.5,10.81,11.97,15.91,19.56,20.94,21.84,23.94,25.81,24.88,22.47,22.03,23.19,23.28,22.5,23.31,26.03,27.38,25.91,24.41,24.44,24.16,21.44,17.94,16.72,16.62,14.94,12.88,13.75,16.25,17.81,17.59,18.19,20.69,22.5,21.78,20.78,21.75,22.75,21.53,19.22,19.34,20.28,19.53,17.06,16.38,17.06,16.78,15.41,15.12,17.62,19.88,19.88,19.66,21.91,25.06,26.5,27.25,29.62,31.59,31.16,28.0,26.03,25.69,24.53,21.97,20.75,22.38,23.81,22.91,20.97,20.69,20.66,18.69,16.16,15.97,17.69,18.19,16.72,16.94,19.53,21.56,21.28,21.34,23.12,24.69,23.56,21.47,21.75,22.16,20.59,17.81,17.12,17.97,18.03,16.22,15.66,16.81,17.91,16.81,16.5,19.12,22.56,23.69,23.44,24.09,25.19,23.62,20.41,18.78,18.59,17.16,13.72,11.44,11.84,13.25,12.91,13.41,16.16,19.44,20.06,19.25,19.97,21.72,21.84,20.0,19.28,20.06,19.94,17.41,15.47,15.5,15.47,12.81,9.72,8.91,9.03,7.66,5.44,5.38,7.06,7.94,7.19,7.5,10.16,12.03,10.97,10.59,11.78,13.16,12.28,10.91,11.28,12.72,12.38,10.56,9.84,10.47,21.44,20.41,20.69,21.34,20.5,19.91,20.69,21.81,21.81,22.75,25.03,28.31,30.56,31.25,32.22,33.38,33.06,32.16,31.81,33.12,34.44,34.75,36.16,38.31,41.06,41.75,40.97,39.81:-5.56,-5.5,-5.59,-7.94,-11.41,-12.94,-12.84,-14.19,-15.78,-14.94,-11.34,-8.09,-5.94,-3.0,1.5,4.97,5.59,5.22,6.59,8.53,8.0,6.97,7.59,9.44,9.25,7.31,6.41,7.41,7.59,6.25,5.5,7.44,9.53,9.16,9.56,11.5,13.88,14.22,13.09,13.38,14.75,14.84,13.19,12.28,13.25,13.88,12.47,11.41,12.81,13.91,13.41,11.97,11.94,12.94,11.75,9.53,8.47,9.12,8.94,6.66,5.12,5.59,5.81,3.84,2.53,4.06,6.75,8.19,9.06,11.44,15.06,16.5,16.28,16.84,18.94,20.25,18.78,17.62,18.22,18.78,16.78,14.28,13.78,13.69,11.34,7.88,6.28,6.66,6.41,5.03,5.41,7.56,9.19,8.91,8.69,10.81,13.16,14.09,14.34,16.94,20.47,22.03,21.38,21.34,21.94,21.09,18.53,16.66,17.53,18.03,16.31,14.0,13.53,13.5,11.38,9.0,8.62,9.88,9.91,8.72,8.81,10.88,11.88,10.75,9.94,11.59,13.22,12.53,11.59,13.22,15.5,15.34,14.0,14.19,14.59,13.31,9.94,7.78,8.09,8.59,7.62,7.69,10.25,12.81,13.41,13.12,14.47,16.66,16.62,15.19,14.78,15.69,15.16,13.0,12.03,13.75,15.34,15.12,14.88,16.91,19.22,19.31,18.53,19.34,20.94,20.72,18.75,17.88,18.47,18.12,15.53,13.47,14.06,14.41,13.12,11.69,12.28,13.66,12.62,10.44,9.75,10.44,9.84,7.56,6.84,7.84,8.66,7.31,6.28,7.84,9.69,9.41,8.75,10.0,12.28,12.69,11.19,11.94,13.91,14.28,12.69,11.62,12.28,11.75,8.78,6.25,6.22,6.62,5.28,3.09,3.47,4.91,4.53,2.84,2.75,4.22,5.0,3.97,4.34,7.16,9.69,9.94,8.88,9.38,9.94,7.88,5.06,4.66,6.03,6.19,5.0,5.12,6.41,7.0,4.84,3.19,3.56,4.47,2.91,1.25,2.41,3.91,3.91,2.44,2.56,3.88,3.66,1.88,1.38,3.0,4.22,3.03,2.28,3.59,5.62,5.25,4.72,6.47,8.97,9.62,8.31,8.34,9.53,8.78,5.81,3.31,2.72,1.56,-1.59,-4.09,-3.41,-0.97,0.44,2.06,5.78,10.66,13.62,13.72,14.28,15.69,15.31,12.38,10.06,9.88,9.72,7.19,4.5,4.19,4.56,2.81,0.16,-0.91,-0.25,-0.28,-1.38,-0.38,3.38,7.09,8.72,10.16,13.62,16.94,17.12,16.47,17.5,18.66,17.28,14.09,12.09,11.28,9.5,6.16,4.44,5.81,7.75,7.81,8.16,10.25,12.56,11.44,9.25,8.91,9.78,9.25,8.31,9.31,12.72,15.5,15.88,16.72,18.81,20.38,18.38,15.53,15.09,15.56,14.06,12.31,12.88,14.78,15.22,13.78,12.88,13.66,13.84,11.72,11.09,13.5,16.44,16.66,16.5,17.91,19.19,18.22,15.84,14.84,16.0,16.03,14.81,14.75,16.88,18.53,17.44,16.25,17.31,17.88,15.72,13.06,13.0,14.88,14.94,14.16,14.5,15.91,15.0,11.91,9.69,10.0,10.06,8.03,6.78,7.75,10.31,10.97,11.72,14.41,18.28,19.91,19.81,20.44,22.5,23.34,22.19,21.31,22.25,23.31,21.59,19.28,19.72,21.19,20.53,18.84,19.06,20.25,19.5,16.97,15.31,16.25,16.94,15.56,14.88,16.62,18.31,17.28,15.72,16.31,18.12,18.31,17.31,17.41,18.59,18.19,15.44,13.88,14.56,14.72,12.72,10.66,10.94,11.88,10.66,9.28,10.09,12.59,13.19,12.31,12.81,15.28,16.47,15.94,16.28,18.81,20.88,20.69,19.94,20.88,22.56,22.16,20.94,21.78,23.53,23.34,21.19,19.78,20.03,19.5,16.84,14.5,15.03,15.31,13.91,12.22,13.62,15.97,16.75,16.44,17.06,18.78,18.56,16.62,15.72,17.78,19.38,18.75,17.91,19.03,19.91,18.69,17.06,17.62,19.81,20.12,19.16,19.38,21.34,21.69,19.56,17.53,17.41,16.84,14.09,11.78,12.69,14.44,14.66,14.41,16.0,19.09,20.66,20.38,20.78,22.78,23.0,21.75,21.12,23.75,26.66,27.25,27.09,28.22,29.38,27.84,24.69,23.19,22.75,20.62,17.06,14.78,15.47,16.06,15.19,15.34,18.03,20.81,21.81,22.03,23.94,26.59,26.81,25.12,24.81,25.72,25.31,23.03,21.78,22.78,23.94,23.22,22.84,24.97,27.47,27.53,26.25,27.25,28.72,28.84,26.84,26.19,26.72,27.03,24.94,23.34,24.69,25.47,24.16,22.41,22.62,23.09,21.03,17.16,14.84,14.34,13.47,11.69,11.62,14.31,16.69,16.78,17.28,20.19,22.84,23.22,22.78,24.28,26.19,25.88,23.75,22.75,23.0,21.94,18.84,17.0,17.69,18.12,16.38,15.53,17.22,19.16,18.72,17.19,17.28,17.97,17.41,15.56,16.12,18.88,20.97,21.06,21.84,24.66,27.19,27.25,27.0,29.5,31.72,32.12,30.78,30.88,31.25,29.81,26.44,24.84,25.34,26.16,25.91,26.56,29.5,32.59,33.34,33.41,34.81,36.47,35.72,33.59,32.84,33.12,32.56,30.56,29.69,31.25,32.28,31.09,29.5,29.66,29.78,27.41,24.59,23.97,24.47,23.97,22.06,22.16,23.56,24.41,22.72,21.84,22.88,23.66,21.81,19.78,19.56,20.03,18.94,16.91,17.0,18.5,18.88,17.5,17.88,20.0,21.75,21.72,21.88,23.69,25.59,24.53,22.97,23.44,24.56,23.72,22.16,22.34,23.88,24.22,22.59,22.12,23.59,23.84,21.72,20.09,20.78,22.0,21.31,20.31,21.25,22.84,22.59,20.97,21.06,22.5,22.75,20.75,19.5,19.84,20.03,18.59,17.5,18.75,20.81,20.34,18.84,18.84,19.62,18.34,15.38,13.84,14.44,14.5,13.25,13.06,15.47,18.0,18.28,18.22,19.72,22.0,21.78,20.16,19.59,19.84,18.03,14.47,12.09,11.94,11.5,8.94,6.94,7.25,7.97,6.78,6.31,8.22,11.34,12.41,12.0,12.75,14.78,15.5,14.75,15.38,18.19,20.91,20.75,21.0,22.88,24.38,23.19,20.88,20.12,19.81,18.06,14.62,12.31,11.84,10.78,8.34,7.34,9.44,12.28,13.69,14.97,18.47,22.69,24.16,24.59,26.16,28.66,29.09,27.25,25.62,25.31,23.94,20.22,17.31,16.91,17.0,14.88,13.0,13.25,14.62,14.62,14.06,15.12,18.0,19.78,19.91,21.28,24.38,26.59,26.22,25.41,26.62,27.88,26.62,25.19,25.09,25.88,24.53,21.59,20.62,21.38,21.78,20.34,20.22,22.62,24.84,24.88,24.34,25.66,27.25,26.22,24.28,23.84,24.81,24.16,22.03,21.09,22.44,23.06,22.09,21.19,22.38,23.41,21.56,19.41,19.38,20.56,20.31,19.56,20.22,22.47,23.22,21.75,21.12,22.38,22.56,20.44,18.56,18.72,19.03,17.09,14.66,14.25,14.88,13.88,12.0,11.91,13.62,14.03,12.72,11.59,12.72,13.5,12.66,12.0,13.88,16.5,17.0,16.38,17.31,18.97,18.25,16.41,15.28,15.78,15.25,13.0,11.66,12.78,14.5,13.78,13.0,14.03,15.62,14.56,12.69,12.22,12.97,12.59,11.12,11.25,13.59,15.22,15.16,15.12,16.72,18.56,18.47,18.0,19.69,22.97,24.03,23.56,24.19,25.69,25.34,22.78,20.66,20.28,18.62,14.69,10.97,9.69,9.81,8.19,7.0,8.72,12.06,13.62,14.09,15.34,17.91,19.03,17.91,16.44,17.06,17.16,15.09,13.16,13.88,15.56,15.03,13.31,13.06,14.19,13.5,11.28,10.25,11.03,10.78,8.41,6.31,6.34,6.88,5.09,3.59,5.19,8.28,10.53,12.66,16.72,21.72,25.16,25.91,26.53,28.44,28.75,26.38,22.97,21.72,20.28,16.38,11.69,9.69,9.22,7.81,5.72,6.22,8.78,10.5,10.81,11.97,15.91,19.56,20.94,21.84,23.94,25.81,24.88,22.47,22.03,23.19,23.28,22.5,23.31,26.03,27.38,25.91,24.41,24.44,24.16,21.44,17.94,16.72,16.62,14.94,12.88,13.75,16.25,17.81,17.59,18.19,20.69,22.5,21.78,20.78,21.75,22.75,21.53,19.22,19.34,20.28,19.53,17.06,16.38,17.06,16.78,15.41,15.12,17.62,19.88,19.88,19.66,21.91,25.06,26.5,27.25,29.62,31.59,31.16,28.0,26.03,25.69,24.53,21.97,20.75,22.38,23.81,22.91,20.97,20.69,20.66,18.69,16.16,15.97,17.69,18.19,16.72,16.94,19.53,21.56,21.28,21.34,23.12,24.69,23.56,21.47,21.75,22.16,20.59,17.81,17.12,17.97,18.03,16.22,15.66,16.81,17.91,16.81,16.5,19.12,22.56,23.69,23.44,24.09,25.19,23.62,20.41,18.78,18.59,17.16,13.72,11.44,11.84,13.25,12.91,13.41,16.16,19.44,20.06,19.25,19.97,21.72,21.84,20.0,19.28,20.06,19.94,17.41,15.47,15.5,15.47,12.81,9.72,8.91,9.03,7.66,5.44,5.38,7.06,7.94,7.19,7.5,10.16,12.03,10.97,10.59,11.78,13.16,12.28,10.91,11.28,12.72,12.38,10.56,9.84,10.47,21.44,20.41,20.69,21.34,20.5,19.91,20.69,21.81,21.81,22.75,25.03,28.31,30.56,31.25,32.22,33.38,33.06,32.16,31.81,33.12,34.44,34.75,36.16,38.31,41.06,41.75,40.97,39.81,37.91,34.12,29.03,25.12,22.72,20.62,18.84:-14.19,-15.78,-14.94,-11.34,-8.09,-5.94,-3.0,1.5,4.97,5.59,5.22,6.59,8.53,8.0,6.97,7.59,9.44,9.25,7.31,6.41,7.41,7.59,6.25,5.5,7.44,9.53,9.16,9.56,11.5,13.88,14.22,13.09,13.38,14.75,14.84,13.19,12.28,13.25,13.88,12.47,11.41,12.81,13.91,13.41,11.97,11.94,12.94,11.75,9.53,8.47,9.12,8.94,6.66,5.12,5.59,5.81,3.84,2.53,4.06,6.75,8.19,9.06,11.44,15.06,16.5,16.28,16.84,18.94,20.25,18.78,17.62,18.22,18.78,16.78,14.28,13.78,13.69,11.34,7.88,6.28,6.66,6.41,5.03,5.41,7.56,9.19,8.91,8.69,10.81,13.16,14.09,14.34,16.94,20.47,22.03,21.38,21.34,21.94,21.09,18.53,16.66,17.53,18.03,16.31,14.0,13.53,13.5,11.38,9.0,8.62,9.88,9.91,8.72,8.81,10.88,11.88,10.75,9.94,11.59,13.22,12.53,11.59,13.22,15.5,15.34,14.0,14.19,14.59,13.31,9.94,7.78,8.09,8.59,7.62,7.69,10.25,12.81,13.41,13.12,14.47,16.66,16.62,15.19,14.78,15.69,15.16,13.0,12.03,13.75,15.34,15.12,14.88,16.91,19.22,19.31,18.53,19.34,20.94,20.72,18.75,17.88,18.47,18.12,15.53,13.47,14.06,14.41,13.12,11.69,12.28,13.66,12.62,10.44,9.75,10.44,9.84,7.56,6.84,7.84,8.66,7.31,6.28,7.84,9.69,9.41,8.75,10.0,12.28,12.69,11.19,11.94,13.91,14.28,12.69,11.62,12.28,11.75,8.78,6.25,6.22,6.62,5.28,3.09,3.47,4.91,4.53,2.84,2.75,4.22,5.0,3.97,4.34,7.16,9.69,9.94,8.88,9.38,9.94,7.88,5.06,4.66,6.03,6.19,5.0,5.12,6.41,7.0,4.84,3.19,3.56,4.47,2.91,1.25,2.41,3.91,3.91,2.44,2.56,3.88,3.66,1.88,1.38,3.0,4.22,3.03,2.28,3.59,5.62,5.25,4.72,6.47,8.97,9.62,8.31,8.34,9.53,8.78,5.81,3.31,2.72,1.56,-1.59,-4.09,-3.41,-0.97,0.44,2.06,5.78,10.66,13.62,13.72,14.28,15.69,15.31,12.38,10.06,9.88,9.72,7.19,4.5,4.19,4.56,2.81,0.16,-0.91,-0.25,-0.28,-1.38,-0.38,3.38,7.09,8.72,10.16,13.62,16.94,17.12,16.47,17.5,18.66,17.28,14.09,12.09,11.28,9.5,6.16,4.44,5.81,7.75,7.81,8.16,10.25,12.56,11.44,9.25,8.91,9.78,9.25,8.31,9.31,12.72,15.5,15.88,16.72,18.81,20.38,18.38,15.53,15.09,15.56,14.06,12.31,12.88,14.78,15.22,13.78,12.88,13.66,13.84,11.72,11.09,13.5,16.44,16.66,16.5,17.91,19.19,18.22,15.84,14.84,16.0,16.03,14.81,14.75,16.88,18.53,17.44,16.25,17.31,17.88,15.72,13.06,13.0,14.88,14.94,14.16,14.5,15.91,15.0,11.91,9.69,10.0,10.06,8.03,6.78,7.75,10.31,10.97,11.72,14.41,18.28,19.91,19.81,20.44,22.5,23.34,22.19,21.31,22.25,23.31,21.59,19.28,19.72,21.19,20.53,18.84,19.06,20.25,19.5,16.97,15.31,16.25,16.94,15.56,14.88,16.62,18.31,17.28,15.72,16.31,18.12,18.31,17.31,17.41,18.59,18.19,15.44,13.88,14.56,14.72,12.72,10.66,10.94,11.88,10.66,9.28,10.09,12.59,13.19,12.31,12.81,15.28,16.47,15.94,16.28,18.81,20.88,20.69,19.94,20.88,22.56,22.16,20.94,21.78,23.53,23.34,21.19,19.78,20.03,19.5,16.84,14.5,15.03,15.31,13.91,12.22,13.62,15.97,16.75,16.44,17.06,18.78,18.56,16.62,15.72,17.78,19.38,18.75,17.91,19.03,19.91,18.69,17.06,17.62,19.81,20.12,19.16,19.38,21.34,21.69,19.56,17.53,17.41,16.84,14.09,11.78,12.69,14.44,14.66,14.41,16.0,19.09,20.66,20.38,20.78,22.78,23.0,21.75,21.12,23.75,26.66,27.25,27.09,28.22,29.38,27.84,24.69,23.19,22.75,20.62,17.06,14.78,15.47,16.06,15.19,15.34,18.03,20.81,21.81,22.03,23.94,26.59,26.81,25.12,24.81,25.72,25.31,23.03,21.78,22.78,23.94,23.22,22.84,24.97,27.47,27.53,26.25,27.25,28.72,28.84,26.84,26.19,26.72,27.03,24.94,23.34,24.69,25.47,24.16,22.41,22.62,23.09,21.03,17.16,14.84,14.34,13.47,11.69,11.62,14.31,16.69,16.78,17.28,20.19,22.84,23.22,22.78,24.28,26.19,25.88,23.75,22.75,23.0,21.94,18.84,17.0,17.69,18.12,16.38,15.53,17.22,19.16,18.72,17.19,17.28,17.97,17.41,15.56,16.12,18.88,20.97,21.06,21.84,24.66,27.19,27.25,27.0,29.5,31.72,32.12,30.78,30.88,31.25,29.81,26.44,24.84,25.34,26.16,25.91,26.56,29.5,32.59,33.34,33.41,34.81,36.47,35.72,33.59,32.84,33.12,32.56,30.56,29.69,31.25,32.28,31.09,29.5,29.66,29.78,27.41,24.59,23.97,24.47,23.97,22.06,22.16,23.56,24.41,22.72,21.84,22.88,23.66,21.81,19.78,19.56,20.03,18.94,16.91,17.0,18.5,18.88,17.5,17.88,20.0,21.75,21.72,21.88,23.69,25.59,24.53,22.97,23.44,24.56,23.72,22.16,22.34,23.88,24.22,22.59,22.12,23.59,23.84,21.72,20.09,20.78,22.0,21.31,20.31,21.25,22.84,22.59,20.97,21.06,22.5,22.75,20.75,19.5,19.84,20.03,18.59,17.5,18.75,20.81,20.34,18.84,18.84,19.62,18.34,15.38,13.84,14.44,14.5,13.25,13.06,15.47,18.0,18.28,18.22,19.72,22.0,21.78,20.16,19.59,19.84,18.03,14.47,12.09,11.94,11.5,8.94,6.94,7.25,7.97,6.78,6.31,8.22,11.34,12.41,12.0,12.75,14.78,15.5,14.75,15.38,18.19,20.91,20.75,21.0,22.88,24.38,23.19,20.88,20.12,19.81,18.06,14.62,12.31,11.84,10.78,8.34,7.34,9.44,12.28,13.69,14.97,18.47,22.69,24.16,24.59,26.16,28.66,29.09,27.25,25.62,25.31,23.94,20.22,17.31,16.91,17.0,14.88,13.0,13.25,14.62,14.62,14.06,15.12,18.0,19.78,19.91,21.28,24.38,26.59,26.22,25.41,26.62,27.88,26.62,25.19,25.09,25.88,24.53,21.59,20.62,21.38,21.78,20.34,20.22,22.62,24.84,24.88,24.34,25.66,27.25,26.22,24.28,23.84,24.81,24.16,22.03,21.09,22.44,23.06,22.09,21.19,22.38,23.41,21.56,19.41,19.38,20.56,20.31,19.56,20.22,22.47,23.22,21.75,21.12,22.38,22.56,20.44,18.56,18.72,19.03,17.09,14.66,14.25,14.88,13.88,12.0,11.91,13.62,14.03,12.72,11.59,12.72,13.5,12.66,12.0,13.88,16.5,17.0,16.38,17.31,18.97,18.25,16.41,15.28,15.78,15.25,13.0,11.66,12.78,14.5,13.78,13.0,14.03,15.62,14.56,12.69,12.22,12.97,12.59,11.12,11.25,13.59,15.22,15.16,15.12,16.72,18.56,18.47,18.0,19.69,22.97,24.03,23.56,24.19,25.69,25.34,22.78,20.66,20.28,18.62,14.69,10.97,9.69,9.81,8.19,7.0,8.72,12.06,13.62,14.09,15.34,17.91,19.03,17.91,16.44,17.06,17.16,15.09,13.16,13.88,15.56,15.03,13.31,13.06,14.19,13.5,11.28,10.25,11.03,10.78,8.41,6.31,6.34,6.88,5.09,3.59,5.19,8.28,10.53,12.66,16.72,21.72,25.16,25.91,26.53,28.44,28.75,26.38,22.97,21.72,20.28,16.38,11.69,9.69,9.22,7.81,5.72,6.22,8.78,10.5,10.81,11.97,15.91,19.56,20.94,21.84,23.94,25.81,24.88,22.47,22.03,23.19,23.28,22.5,23.31,26.03,27.38,25.91,24.41,24.44,24.16,21.44,17.94,16.72,16.62,14.94,12.88,13.75,16.25,17.81,17.59,18.19,20.69,22.5,21.78,20.78,21.75,22.75,21.53,19.22,19.34,20.28,19.53,17.06,16.38,17.06,16.78,15.41,15.12,17.62,19.88,19.88,19.66,21.91,25.06,26.5,27.25,29.62,31.59,31.16,28.0,26.03,25.69,24.53,21.97,20.75,22.38,23.81,22.91,20.97,20.69,20.66,18.69,16.16,15.97,17.69,18.19,16.72,16.94,19.53,21.56,21.28,21.34,23.12,24.69,23.56,21.47,21.75,22.16,20.59,17.81,17.12,17.97,18.03,16.22,15.66,16.81,17.91,16.81,16.5,19.12,22.56,23.69,23.44,24.09,25.19,23.62,20.41,18.78,18.59,17.16,13.72,11.44,11.84,13.25,12.91,13.41,16.16,19.44,20.06,19.25,19.97,21.72,21.84,20.0,19.28,20.06,19.94,17.41,15.47,15.5,15.47,12.81,9.72,8.91,9.03,7.66,5.44,5.38,7.06,7.94,7.19,7.5,10.16,12.03,10.97,10.59,11.78,13.16,12.28,10.91,11.28,12.72,12.38,10.56,9.84,10.47,21.44,20.41,20.69,21.34,20.5,19.91,20.69,21.81,21.81,22.75,25.03,28.31,30.56,31.25,32.22,33.38,33.06,32.16,31.81,33.12,34.44,34.75,36.16,38.31,41.06,41.75,40.97,39.81,37.91,34.12,29.03,25.12,22.72,20.62,18.84,18.0,18.47,19.12,18.28,17.19,16.88,17.12:positivity
4.22,2.81,1.97,3.12,4.62,3.53,2.66,3.34,3.81,2.44,0.19,-0.12,1.47,1.62,0.97,1.53,3.47,4.84,4.62,5.03,7.28,9.69,9.12,8.19,8.78,9.97,9.53,8.56,9.12,11.25,12.34,11.56,11.34,12.34,11.97,8.56,4.97,3.38,2.44,0.16,-1.62,-0.62,1.84,2.66,2.22,3.22,5.12,5.22,4.0,3.5,5.12,6.56,6.06,5.56,7.16,9.0,8.44,7.38,7.94,9.47,8.75,7.16,7.0,8.03,8.56,6.91,5.81,6.53,7.09,5.59,4.62,5.56,7.44,6.38,4.19,3.53,3.75,2.75,0.78,0.78,3.03,5.16,5.25,6.06,8.62,10.81,9.97,8.31,8.0,7.69,4.62,0.72,-1.09,-1.56,-2.47,-3.69,-3.16,-0.47,2.03,2.84,4.06,6.62,9.12,8.91,8.0,8.5,9.59,8.5,6.88,6.47,7.31,6.72,4.47,3.0,3.62,3.88,2.62,2.12,4.03,5.88,5.69,4.75,4.94,5.62,4.31,1.66,0.53,1.5,1.53,0.47,0.44,2.16,3.16,2.16,0.91,1.69,2.97,3.09,3.25,5.22,8.47,9.78,9.94,10.97,13.31,13.81,11.97,9.88,9.31,8.22,5.56,3.44,3.78,5.5,5.09,3.69,3.81,4.84,4.03,2.53,2.59,5.53,7.81,8.09,8.38,9.94,10.78,9.22,7.0,5.94,5.38,2.31,-1.38,-2.94,-2.62,-2.34,-2.19,-0.31,4.25,7.62,8.25,8.22,8.91,8.75,6.06,2.44,0.94,0.34,-1.69,-3.78,-3.56,-0.84,1.06,1.66,2.75,5.06,5.38,3.56,1.53,1.28,2.12,1.72,1.19,2.66,5.38,6.56,6.38,7.75,10.06,10.5,8.72,6.38,5.28,3.41,-0.34,-3.72,-3.84,-2.59,-2.0,-1.12,1.69,5.81,8.44,9.28,11.28,14.84,16.25,15.53,14.16,14.03,12.94,9.97,7.19,7.09,8.25,8.16,7.62,8.59,10.28,10.0,8.06,6.56,6.78,6.34,4.84,3.78,5.75,7.94,8.34,8.41,10.09,12.31,12.62,11.91,12.09,13.41,13.47,11.97,10.94,11.78,11.91,9.78,7.34,6.88,6.47,4.53,2.16,2.16,3.16,3.03,2.28,2.78,4.88,5.91,4.62,3.56,4.62,4.94,3.75,2.88,4.47,7.22,8.59,9.25,11.0,12.94,12.25,9.47,6.84,5.84,3.91,-0.28,-3.75,-4.84,-5.78,-8.03,-9.22,-7.34,-4.47,-2.44,-0.94,2.59,7.19,10.81,13.0,15.56,19.81,22.66,22.75,22.5,23.5,23.66,21.5,18.22,17.19,16.44,13.84,10.53,9.0,9.44,9.09,7.94,8.31,10.44,11.22,9.44,7.06,6.28,5.44,3.38,1.19,1.62,2.94,2.62,1.09,0.34,1.0,0.19,-1.81,-2.97,-1.16,0.5,0.5,0.78,2.84,4.84,4.56,3.75,4.62,5.97,5.66,3.59,2.94,3.41,3.38,1.69,0.47,1.31,1.88,0.19,-1.16,-0.38,0.78,0.0,-1.78,-1.62,-0.53,-0.19,-0.75,-0.12,2.12,3.0,1.88,0.84,1.91,2.53,1.56,0.03,1.16,3.31,3.56,3.16,4.59,6.28,6.0,3.22,1.41,1.09,0.5,-1.09,-1.41,0.91,3.81,4.78,5.34,7.41,9.62,9.31,7.28,6.16,6.16,5.66,3.78,3.59,5.78,7.44,6.56,5.25,5.5,5.72,4.16,2.84,3.69,6.06,7.56,8.47,10.84,15.12,18.28,19.5,20.31,22.03,22.28,19.28,15.03,12.66,10.16,5.97,1.06,-1.84,-3.34,-6.34,-10.69,-12.75,-12.59,-12.38,-12.69,-10.91,-5.72,0.03,4.03,7.91,13.53,18.78,20.88,20.75,21.28,21.59,19.38,15.25,12.19,10.47,8.19,4.19,0.84,-0.03,-0.5,-2.53,-4.38,-4.0,-2.12,-2.09,-2.66,-0.94,2.22,4.19,4.34,5.12,7.41,8.41,7.0,5.69,6.38,7.03,5.88,3.78,3.56,3.91,2.91,0.84,0.59,1.66,1.41,-0.75,-2.72,-2.84,-3.09,-5.12,-5.97,-4.31,-2.03,-1.75,-1.94,-0.56,1.66,2.75,2.28,3.34,5.75,6.91,5.88,5.31,6.16,7.22,5.94,4.47,5.28,6.69,6.31,5.19,6.25,8.22,9.25,8.19,8.28,9.59,9.91,7.59,5.44,5.09,3.69,0.16,-3.31,-4.12,-3.25,-3.25,-3.41,-1.56,1.16,2.12,0.91,1.09,3.09,4.75,4.72,5.72,8.53,11.16,10.97,10.25,11.59,13.16,12.91,11.19,10.47,10.88,10.0,6.88,5.56,6.0,6.19,4.81,3.94,5.28,6.97,6.78,6.44,7.62,9.72,10.19,8.88,8.81,9.53,9.25,7.12,6.09,7.72,9.62,10.12,11.12,13.81,16.81,16.97,15.75,15.59,16.25,15.12,12.62,11.62,12.72,13.56,12.5,12.09,13.5,14.88,13.41,11.28,11.0,11.19,8.94,6.09,5.03,6.06,6.53,6.0,7.22,10.66,13.5,13.56,14.0,16.06,17.41,15.75,13.53,12.81,12.62,10.66,7.97,7.25,8.59,9.5,8.88,9.5,12.19,13.62,12.44,11.62,12.16,12.47,10.06,6.69,5.06,4.44,2.44,0.38,0.06,1.88,2.75,1.66,1.59,3.5,4.59,3.66,2.88,4.22,6.03,5.59,4.66,5.91,8.12,8.41,7.47,7.69,9.41,9.62,8.0,7.22,8.75,9.97,9.06,7.88,8.53,9.28,7.72,5.34,4.53,5.09,3.97,1.88,0.66,1.78,2.34,1.5,1.72,4.5,7.34,7.16,6.62,7.16,7.94,6.62,5.0,5.53,8.25,9.53,9.06,8.97,10.41,10.38,7.84,5.91,6.5,7.56,6.66,5.78,6.44,7.94,7.44,5.38,5.16,6.47,6.75,5.53,5.28,7.22,8.25,7.38,7.16,8.75,10.22,8.84,6.56,5.72,6.09,4.88,3.5,4.19,6.88,8.28,8.16,8.38,10.88,12.53,11.59,10.62,11.28,11.62,9.47,6.47,5.28,5.22,3.41,1.03,0.53,2.31,3.5,2.59,1.94,3.25,3.5,1.44,-0.72,0.03,1.59,1.47,1.09,2.25,4.56,5.38,4.59,5.25,7.75,9.19,8.62,8.0,9.59,10.56,9.34,7.25,7.5,7.88,6.41,4.31,3.66,4.47,3.38,0.56,-0.94,-1.16,-1.5,-3.5,-4.81,-3.03,-1.25,-1.66,-2.34,-1.12,0.22,-0.44,-2.47,-3.06,-1.97,-2.19,-3.78,-3.44,-1.19,1.06,1.91,2.91,5.88,8.06,7.59,5.78,5.69,7.0,7.25,6.97,8.75,11.88,12.91,11.97,10.5,10.66,10.25,7.69,5.44,5.56,6.19,4.62,1.88,1.28,1.78,1.09,-0.06,-0.09,1.56,2.19,1.16,0.38,2.19,3.53,2.38,1.06,1.78,2.97,2.41,1.16,2.22,4.94,6.62,7.62,10.0,14.09,16.06,14.81,13.0,12.44,10.91,7.62,3.78,2.88,3.12,2.0,0.09,0.16,1.84,2.0,1.38,1.75,4.62,6.47,5.75,5.19,6.25,7.75,7.0,5.84,6.78,8.5,8.12,6.38,6.69,8.09,8.38,6.81,6.47,8.78,10.59,10.53,10.28,11.81,12.62,10.19,7.5,6.56,6.75,6.16,4.28,3.91,5.06,4.91,3.03,2.41,4.59,6.56,6.5,5.81,7.22,8.53,7.59,5.62,5.31,5.66,4.53,1.88,1.25,2.56,3.16,2.25,1.53,2.91,3.34,1.72,-0.56,-0.69,-0.16,-1.72,-4.19,-4.97,-3.97,-4.19,-5.09,-4.5,-2.19,-0.59,-1.72,-3.0,-2.28,-2.25,-4.56,-7.44,-7.91,-7.28,-7.91,-9.34,-8.5,-5.91,-4.69,-5.47,-5.03,-3.0,-2.25,-3.53,-4.62,-3.44,-2.5,-3.56,-5.06,-4.28,-2.16,-1.59,-1.84,-0.78,1.78,2.97,2.44,2.38,4.12,4.97,3.28,1.69,1.88,2.19,1.09,-0.62,-0.16,1.22,0.81,-1.34,-1.91,-1.12,-0.91,-2.16,-1.56,1.22,3.53,3.25,2.34,2.62,2.94,1.25,-1.22,-1.28,0.19,0.25,-0.88,-0.97,0.44,0.59,-1.75,-3.47,-3.16,-3.28,-5.59,-7.78,-7.59,-6.88,-7.34,-8.47,-7.25,-5.28,-4.19,-4.72,-4.41,-2.59,-2.03,-4.22,-6.12,-6.53,-6.5,-8.41,-10.53,-9.88,-8.59,-8.62,-9.19,-7.66,-5.03,-2.91,-2.97,-2.12,0.06,1.31,0.0,-1.53,-1.06,-0.28,-1.31,-2.16,-0.59,1.62,2.66,1.78,2.91,5.38,6.81,6.53,6.72,8.69,9.69,7.78,5.53,5.38,5.88,4.47,3.25,4.84,7.72,9.31,9.12,9.44,9.78,8.03,3.72,0.28,-0.84,-1.31,-3.28,-4.5,-2.38,0.91,2.06,2.78,4.53,6.31,5.88,2.97,1.44,1.16,0.25,-2.56,-4.44,-3.19,-1.19,-1.03,-0.69,2.16,5.47,6.53,6.72,8.62,10.94,11.34,9.25,7.19,6.12,4.06,-0.09,-2.97,-2.88,-1.84,-2.09,-2.94,-1.94,-0.91,-2.22,-4.44,-4.91,-3.84,-3.25,-3.78,-2.72,0.88,4.47,6.12,7.94,11.38,14.41,14.16,12.69,12.62,12.53,9.97,6.47,4.53,3.91,2.75,-0.12,-2.06,-1.97,-2.03,-4.31,-5.88,-5.53,-5.16,-7.44,-10.94,-13.09,-14.56,-17.09,-20.34,-21.62,-20.38,-18.88,-17.78,-15.0,-9.75,-4.22,-1.12,1.59,5.91,10.38,12.19,12.44,13.53,14.94,14.19,11.78,10.41,10.72,10.66,8.72,8.0,8.53,9.12,6.59,4.03,3.25,3.41,2.47,1.78,3.31,6.72,9.06,9.28,9.53,10.47,9.78,6.56,3.94,3.62,4.16:3.34,3.81,2.44,0.19,-0.12,1.47,1.62,0.97,1.53,3.47,4.84,4.62,5.03,7.28,9.69,9.12,8.19,8.78,9.97,9.53,8.56,9.12,11.25,12.34,11.56,11.34,12.34,11.97,8.56,4.97,3.38,2.44,0.16,-1.62,-0.62,1.84,2.66,2.22,3.22,5.12,5.22,4.0,3.5,5.12,6.56,6.06,5.56,7.16,9.0,8.44,7.38,7.94,9.47,8.75,7.16,7.0,8.03,8.56,6.91,5.81,6.53,7.09,5.59,4.62,5.56,7.44,6.38,4.19,3.53,3.75,2.75,0.78,0.78,3.03,5.16,5.25,6.06,8.62,10.81,9.97,8.31,8.0,7.69,4.62,0.72,-1.09,-1.56,-2.47,-3.69,-3.16,-0.47,2.03,2.84,4.06,6.62,9.12,8.91,8.0,8.5,9.59,8.5,6.88,6.47,7.31,6.72,4.47,3.0,3.62,3.88,2.62,2.12,4.03,5.88,5.69,4.75,4.94,5.62,4.31,1.66,0.53,1.5,1.53,0.47,0.44,2.16,3.16,2.16,0.91,1.69,2.97,3.09,3.25,5.22,8.47,9.78,9.94,10.97,13.31,13.81,11.97,9.88,9.31,8.22,5.56,3.44,3.78,5.5,5.09,3.69,3.81,4.84,4.03,2.53,2.59,5.53,7.81,8.09,8.38,9.94,10.78,9.22,7.0,5.94,5.38,2.31,-1.38,-2.94,-2.62,-2.34,-2.19,-0.31,4.25,7.62,8.25,8.22,8.91,8.75,6.06,2.44,0.94,0.34,-1.69,-3.78,-3.56,-0.84,1.06,1.66,2.75,5.06,5.38,3.56,1.53,1.28,2.12,1.72,1.19,2.66,5.38,6.56,6.38,7.75,10.06,10.5,8.72,6.38,5.28,3.41,-0.34,-3.72,-3.84,-2.59,-2.0,-1.12,1.69,5.81,8.44,9.28,11.28,14.84,16.25,15.53,14.16,14.03,12.94,9.97,7.19,7.09,8.25,8.16,7.62,8.59,10.28,10.0,8.06,6.56,6.78,6.34,4.84,3.78,5.75,7.94,8.34,8.41,10.09,12.31,12.62,11.91,12.09,13.41,13.47,11.97,10.94,11.78,11.91,9.78,7.34,6.88,6.47,4.53,2.16,2.16,3.16,3.03,2.28,2.78,4.88,5.91,4.62,3.56,4.62,4.94,3.75,2.88,4.47,7.22,8.59,9.25,11.0,12.94,12.25,9.47,6.84,5.84,3.91,-0.28,-3.75,-4.84,-5.78,-8.03,-9.22,-7.34,-4.47,-2.44,-0.94,2.59,7.19,10.81,13.0,15.56,19.81,22.66,22.75,22.5,23.5,23.66,21.5,18.22,17.19,16.44,13.84,10.53,9.0,9.44,9.09,7.94,8.31,10.44,11.22,9.44,7.06,6.28,5.44,3.38,1.19,1.62,2.94,2.62,1.09,0.34,1.0,0.19,-1.81,-2.97,-1.16,0.5,0.5,0.78,2.84,4.84,4.56,3.75,4.62,5.97,5.66,3.59,2.94,3.41,3.38,1.69,0.47,1.31,1.88,0.19,-1.16,-0.38,0.78,0.0,-1.78,-1.62,-0.53,-0.19,-0.75,-0.12,2.12,3.0,1.88,0.84,1.91,2.53,1.56,0.03,1.16,3.31,3.56,3.16,4.59,6.28,6.0,3.22,1.41,1.09,0.5,-1.09,-1.41,0.91,3.81,4.78,5.34,7.41,9.62,9.31,7.28,6.16,6.16,5.66,3.78,3.59,5.78,7.44,6.56,5.25,5.5,5.72,4.16,2.84,3.69,6.06,7.56,8.47,10.84,15.12,18.28,19.5,20.31,22.03,22.28,19.28,15.03,12.66,10.16,5.97,1.06,-1.84,-3.34,-6.34,-10.69,-12.75,-12.59,-12.38,-12.69,-10.91,-5.72,0.03,4.03,7.91,13.53,18.78,20.88,20.75,21.28,21.59,19.38,15.25,12.19,10.47,8.19,4.19,0.84,-0.03,-0.5,-2.53,-4.38,-4.0,-2.12,-2.09,-2.66,-0.94,2.22,4.19,4.34,5.12,7.41,8.41,7.0,5.69,6.38,7.03,5.88,3.78,3.56,3.91,2.91,0.84,0.59,1.66,1.41,-0.75,-2.72,-2.84,-3.09,-5.12,-5.97,-4.31,-2.03,-1.75,-1.94,-0.56,1.66,2.75,2.28,3.34,5.75,6.91,5.88,5.31,6.16,7.22,5.94,4.47,5.28,6.69,6.31,5.19,6.25,8.22,9.25,8.19,8.28,9.59,9.91,7.59,5.44,5.09,3.69,0.16,-3.31,-4.12,-3.25,-3.25,-3.41,-1.56,1.16,2.12,0.91,1.09,3.09,4.75,4.72,5.72,8.53,11.16,10.97,10.25,11.59,13.16,12.91,11.19,10.47,10.88,10.0,6.88,5.56,6.0,6.19,4.81,3.94,5.28,6.97,6.78,6.44,7.62,9.72,10.19,8.88,8.81,9.53,9.25,7.12,6.09,7.72,9.62,10.12,11.12,13.81,16.81,16.97,15.75,15.59,16.25,15.12,12.62,11.62,12.72,13.56,12.5,12.09,13.5,14.88,13.41,11.28,11.0,11.19,8.94,6.09,5.03,6.06,6.53,6.0,7.22,10.66,13.5,13.56,14.0,16.06,17.41,15.75,13.53,12.81,12.62,10.66,7.97,7.25,8.59,9.5,8.88,9.5,12.19,13.62,12.44,11.62,12.16,12.47,10.06,6.69,5.06,4.44,2.44,0.38,0.06,1.88,2.75,1.66,1.59,3.5,4.59,3.66,2.88,4.22,6.03,5.59,4.66,5.91,8.12,8.41,7.47,7.69,9.41,9.62,8.0,7.22,8.75,9.97,9.06,7.88,8.53,9.28,7.72,5.34,4.53,5.09,3.97,1.88,0.66,1.78,2.34,1.5,1.72,4.5,7.34,7.16,6.62,7.16,7.94,6.62,5.0,5.53,8.25,9.53,9.06,8.97,10.41,10.38,7.84,5.91,6.5,7.56,6.66,5.78,6.44,7.94,7.44,5.38,5.16,6.47,6.75,5.53,5.28,7.22,8.25,7.38,7.16,8.75,10.22,8.84,6.56,5.72,6.09,4.88,3.5,4.19,6.88,8.28,8.16,8.38,10.88,12.53,11.59,10.62,11.28,11.62,9.47,6.47,5.28,5.22,3.41,1.03,0.53,2.31,3.5,2.59,1.94,3.25,3.5,1.44,-0.72,0.03,1.59,1.47,1.09,2.25,4.56,5.38,4.59,5.25,7.75,9.19,8.62,8.0,9.59,10.56,9.34,7.25,7.5,7.88,6.41,4.31,3.66,4.47,3.38,0.56,-0.94,-1.16,-1.5,-3.5,-4.81,-3.03,-1.25,-1.66,-2.34,-1.12,0.22,-0.44,-2.47,-3.06,-1.97,-2.19,-3.78,-3.44,-1.19,1.06,1.91,2.91,5.88,8.06,7.59,5.78,5.69,7.0,7.25,6.97,8.75,11.88,12.91,11.97,10.5,10.66,10.25,7.69,5.44,5.56,6.19,4.62,1.88,1.28,1.78,1.09,-0.06,-0.09,1.56,2.19,1.16,0.38,2.19,3.53,2.38,1.06,1.78,2.97,2.41,1.16,2.22,4.94,6.62,7.62,10.0,14.09,16.06,14.81,13.0,12.44,10.91,7.62,3.78,2.88,3.12,2.0,0.09,0.16,1.84,2.0,1.38,1.75,4.62,6.47,5.75,5.19,6.25,7.75,7.0,5.84,6.78,8.5,8.12,6.38,6.69,8.09,8.38,6.81,6.47,8.78,10.59,10.53,10.28,11.81,12.62,10.19,7.5,6.56,6.75,6.16,4.28,3.91,5.06,4.91,3.03,2.41,4.59,6.56,6.5,5.81,7.22,8.53,7.59,5.62,5.31,5.66,4.53,1.88,1.25,2.56,3.16,2.25,1.53,2.91,3.34,1.72,-0.56,-0.69,-0.16,-1.72,-4.19,-4.97,-3.97,-4.19,-5.09,-4.5,-2.19,-0.59,-1.72,-3.0,-2.28,-2.25,-4.56,-7.44,-7.91,-7.28,-7.91,-9.34,-8.5,-5.91,-4.69,-5.47,-5.03,-3.0,-2.25,-3.53,-4.62,-3.44,-2.5,-3.56,-5.06,-4.28,-2.16,-1.59,-1.84,-0.78,1.78,2.97,2.44,2.38,4.12,4.97,3.28,1.69,1.88,2.19,1.09,-0.62,-0.16,1.22,0.81,-1.34,-1.91,-1.12,-0.91,-2.16,-1.56,1.22,3.53,3.25,2.34,2.62,2.94,1.25,-1.22,-1.28,0.19,0.25,-0.88,-0.97,0.44,0.59,-1.75,-3.47,-3.16,-3.28,-5.59,-7.78,-7.59,-6.88,-7.34,-8.47,-7.25,-5.28,-4.19,-4.72,-4.41,-2.59,-2.03,-4.22,-6.12,-6.53,-6.5,-8.41,-10.53,-9.88,-8.59,-8.62,-9.19,-7.66,-5.03,-2.91,-2.97,-2.12,0.06,1.31,0.0,-1.53,-1.06,-0.28,-1.31,-2.16,-0.59,1.62,2.66,1.78,2.91,5.38,6.81,6.53,6.72,8.69,9.69,7.78,5.53,5.38,5.88,4.47,3.25,4.84,7.72,9.31,9.12,9.44,9.78,8.03,3.72,0.28,-0.84,-1.31,-3.28,-4.5,-2.38,0.91,2.06,2.78,4.53,6.31,5.88,2.97,1.44,1.16,0.25,-2.56,-4.44,-3.19,-1.19,-1.03,-0.69,2.16,5.47,6.53,6.72,8.62,10.94,11.34,9.25,7.19,6.12,4.06,-0.09,-2.97,-2.88,-1.84,-2.09,-2.94,-1.94,-0.91,-2.22,-4.44,-4.91,-3.84,-3.25,-3.78,-2.72,0.88,4.47,6.12,7.94,11.38,14.41,14.16,12.69,12.62,12.53,9.97,6.47,4.53,3.91,2.75,-0.12,-2.06,-1.97,-2.03,-4.31,-5.88,-5.53,-5.16,-7.44,-10.94,-13.09,-14.56,-17.09,-20.34,-21.62,-20.38,-18.88,-17.78,-15.0,-9.75,-4.22,-1.12,1.59,5.91,10.38,12.19,12.44,13.53,14.94,14.19,11.78,10.41,10.72,10.66,8.72,8.0,8.53,9.12,6.59,4.03,3.25,3.41,2.47,1.78,3.31,6.72,9.06,9.28,9.53,10.47,9.78,6.56,3.94,3.62,4.16,39.97,39.78,39.72,40.81,41.72,41.19,40.59:0.97,1.53,3.47,4.84,4.62,5.03,7.28,9.69,9.12,8.19,8.78,9.97,9.53,8.56,9.12,11.25,12.34,11.56,11.34,12.34,11.97,8.56,4.97,3.38,2.44,0.16,-1.62,-0.62,1.84,2.66,2.22,3.22,5.12,5.22,4.0,3.5,5.12,6.56,6.06,5.56,7.16,9.0,8.44,7.38,7.94,9.47,8.75,7.16,7.0,8.03,8.56,6.91,5.81,6.53,7.09,5.59,4.62,5.56,7.44,6.38,4.19,3.53,3.75,2.75,0.78,0.78,3.03,5.16,5.25,6.06,8.62,10.81,9.97,8.31,8.0,7.69,4.62,0.72,-1.09,-1.56,-2.47,-3.69,-3.16,-0.47,2.03,2.84,4.06,6.62,9.12,8.91,8.0,8.5,9.59,8.5,6.88,6.47,7.31,6.72,4.47,3.0,3.62,3.88,2.62,2.12,4.03,5.88,5.69,4.75,4.94,5.62,4.31,1.66,0.53,1.5,1.53,0.47,0.44,2.16,3.16,2.16,0.91,1.69,2.97,3.09,3.25,5.22,8.47,9.78,9.94,10.97,13.31,13.81,11.97,9.88,9.31,8.22,5.56,3.44,3.78,5.5,5.09,3.69,3.81,4.84,4.03,2.53,2.59,5.53,7.81,8.09,8.38,9.94,10.78,9.22,7.0,5.94,5.38,2.31,-1.38,-2.94,-2.62,-2.34,-2.19,-0.31,4.25,7.62,8.25,8.22,8.91,8.75,6.06,2.44,0.94,0.34,-1.69,-3.78,-3.56,-0.84,1.06,1.66,2.75,5.06,5.38,3.56,1.53,1.28,2.12,1.72,1.19,2.66,5.38,6.56,6.38,7.75,10.06,10.5,8.72,6.38,5.28,3.41,-0.34,-3.72,-3.84,-2.59,-2.0,-1.12,1.69,5.81,8.44,9.28,11.28,14.84,16.25,15.53,14.16,14.03,12.94,9.97,7.19,7.09,8.25,8.16,7.62,8.59,10.28,10.0,8.06,6.56,6.78,6.34,4.84,3.78,5.75,7.94,8.34,8.41,10.09,12.31,12.62,11.91,12.09,13.41,13.47,11.97,10.94,11.78,11.91,9.78,7.34,6.88,6.47,4.53,2.16,2.16,3.16,3.03,2.28,2.78,4.88,5.91,4.62,3.56,4.62,4.94,3.75,2.88,4.47,7.22,8.59,9.25,11.0,12.94,12.25,9.47,6.84,5.84,3.91,-0.28,-3.75,-4.84,-5.78,-8.03,-9.22,-7.34,-4.47,-2.44,-0.94,2.59,7.19,10.81,13.0,15.56,19.81,22.66,22.75,22.5,23.5,23.66,21.5,18.22,17.19,16.44,13.84,10.53,9.0,9.44,9.09,7.94,8.31,10.44,11.22,9.44,7.06,6.28,5.44,3.38,1.19,1.62,2.94,2.62,1.09,0.34,1.0,0.19,-1.81,-2.97,-1.16,0.5,0.5,0.78,2.84,4.84,4.56,3.75,4.62,5.97,5.66,3.59,2.94,3.41,3.38,1.69,0.47,1.31,1.88,0.19,-1.16,-0.38,0.78,0.0,-1.78,-1.62,-0.53,-0.19,-0.75,-0.12,2.12,3.0,1.88,0.84,1.91,2.53,1.56,0.03,1.16,3.31,3.56,3.16,4.59,6.28,6.0,3.22,1.41,1.09,0.5,-1.09,-1.41,0.91,3.81,4.78,5.34,7.41,9.62,9.31,7.28,6.16,6.16,5.66,3.78,3.59,5.78,7.44,6.56,5.25,5.5,5.72,4.16,2.84,3.69,6.06,7.56,8.47,10.84,15.12,18.28,19.5,20.31,22.03,22.28,19.28,15.03,12.66,10.16,5.97,1.06,-1.84,-3.34,-6.34,-10.69,-12.75,-12.59,-12.38,-12.69,-10.91,-5.72,0.03,4.03,7.91,13.53,18.78,20.88,20.75,21.28,21.59,19.38,15.25,12.19,10.47,8.19,4.19,0.84,-0.03,-0.5,-2.53,-4.38,-4.0,-2.12,-2.09,-2.66,-0.94,2.22,4.19,4.34,5.12,7.41,8.41,7.0,5.69,6.38,7.03,5.88,3.78,3.56,3.91,2.91,0.84,0.59,1.66,1.41,-0.75,-2.72,-2.84,-3.09,-5.12,-5.97,-4.31,-2.03,-1.75,-1.94,-0.56,1.66,2.75,2.28,3.34,5.75,6.91,5.88,5.31,6.16,7.22,5.94,4.47,5.28,6.69,6.31,5.19,6.25,8.22,9.25,8.19,8.28,9.59,9.91,7.59,5.44,5.09,3.69,0.16,-3.31,-4.12,-3.25,-3.25,-3.41,-1.56,1.16,2.12,0.91,1.09,3.09,4.75,4.72,5.72,8.53,11.16,10.97,10.25,11.59,13.16,12.91,11.19,10.47,10.88,10.0,6.88,5.56,6.0,6.19,4.81,3.94,5.28,6.97,6.78,6.44,7.62,9.72,10.19,8.88,8.81,9.53,9.25,7.12,6.09,7.72,9.62,10.12,11.12,13.81,16.81,16.97,15.75,15.59,16.25,15.12,12.62,11.62,12.72,13.56,12.5,12.09,13.5,14.88,13.41,11.28,11.0,11.19,8.94,6.09,5.03,6.06,6.53,6.0,7.22,10.66,13.5,13.56,14.0,16.06,17.41,15.75,13.53,12.81,12.62,10.66,7.97,7.25,8.59,9.5,8.88,9.5,12.19,13.62,12.44,11.62,12.16,12.47,10.06,6.69,5.06,4.44,2.44,0.38,0.06,1.88,2.75,1.66,1.59,3.5,4.59,3.66,2.88,4.22,6.03,5.59,4.66,5.91,8.12,8.41,7.47,7.69,9.41,9.62,8.0,7.22,8.75,9.97,9.06,7.88,8.53,9.28,7.72,5.34,4.53,5.09,3.97,1.88,0.66,1.78,2.34,1.5,1.72,4.5,7.34,7.16,6.62,7.16,7.94,6.62,5.0,5.53,8.25,9.53,9.06,8.97,10.41,10.38,7.84,5.91,6.5,7.56,6.66,5.78,6.44,7.94,7.44,5.38,5.16,6.47,6.75,5.53,5.28,7.22,8.25,7.38,7.16,8.75,10.22,8.84,6.56,5.72,6.09,4.88,3.5,4.19,6.88,8.28,8.16,8.38,10.88,12.53,11.59,10.62,11.28,11.62,9.47,6.47,5.28,5.22,3.41,1.03,0.53,2.31,3.5,2.59,1.94,3.25,3.5,1.44,-0.72,0.03,1.59,1.47,1.09,2.25,4.56,5.38,4.59,5.25,7.75,9.19,8.62,8.0,9.59,10.56,9.34,7.25,7.5,7.88,6.41,4.31,3.66,4.47,3.38,0.56,-0.94,-1.16,-1.5,-3.5,-4.81,-3.03,-1.25,-1.66,-2.34,-1.12,0.22,-0.44,-2.47,-3.06,-1.97,-2.19,-3.78,-3.44,-1.19,1.06,1.91,2.91,5.88,8.06,7.59,5.78,5.69,7.0,7.25,6.97,8.75,11.88,12.91,11.97,10.5,10.66,10.25,7.69,5.44,5.56,6.19,4.62,1.88,1.28,1.78,1.09,-0.06,-0.09,1.56,2.19,1.16,0.38,2.19,3.53,2.38,1.06,1.78,2.97,2.41,1.16,2.22,4.94,6.62,7.62,10.0,14.09,16.06,14.81,13.0,12.44,10.91,7.62,3.78,2.88,3.12,2.0,0.09,0.16,1.84,2.0,1.38,1.75,4.62,6.47,5.75,5.19,6.25,7.75,7.0,5.84,6.78,8.5,8.12,6.38,6.69,8.09,8.38,6.81,6.47,8.78,10.59,10.53,10.28,11.81,12.62,10.19,7.5,6.56,6.75,6.16,4.28,3.91,5.06,4.91,3.03,2.41,4.59,6.56,6.5,5.81,7.22,8.53,7.59,5.62,5.31,5.66,4.53,1.88,1.25,2.56,3.16,2.25,1.53,2.91,3.34,1.72,-0.56,-0.69,-0.16,-1.72,-4.19,-4.97,-3.97,-4.19,-5.09,-4.5,-2.19,-0.59,-1.72,-3.0,-2.28,-2.25,-4.56,-7.44,-7.91,-7.28,-7.91,-9.34,-8.5,-5.91,-4.69,-5.47,-5.03,-3.0,-2.25,-3.53,-4.62,-3.44,-2.5,-3.56,-5.06,-4.28,-2.16,-1.59,-1.84,-0.78,1.78,2.97,2.44,2.38,4.12,4.97,3.28,1.69,1.88,2.19,1.09,-0.62,-0.16,1.22,0.81,-1.34,-1.91,-1.12,-0.91,-2.16,-1.56,1.22,3.53,3.25,2.34,2.62,2.94,1.25,-1.22,-1.28,0.19,0.25,-0.88,-0.97,0.44,0.59,-1.75,-3.47,-3.16,-3.28,-5.59,-7.78,-7.59,-6.88,-7.34,-8.47,-7.25,-5.28,-4.19,-4.72,-4.41,-2.59,-2.03,-4.22,-6.12,-6.53,-6.5,-8.41,-10.53,-9.88,-8.59,-8.62,-9.19,-7.66,-5.03,-2.91,-2.97,-2.12,0.06,1.31,0.0,-1.53,-1.06,-0.28,-1.31,-2.16,-0.59,1.62,2.66,1.78,2.91,5.38,6.81,6.53,6.72,8.69,9.69,7.78,5.53,5.38,5.88,4.47,3.25,4.84,7.72,9.31,9.12,9.44,9.78,8.03,3.72,0.28,-0.84,-1.31,-3.28,-4.5,-2.38,0.91,2.06,2.78,4.53,6.31,5.88,2.97,1.44,1.16,0.25,-2.56,-4.44,-3.19,-1.19,-1.03,-0.69,2.16,5.47,6.53,6.72,8.62,10.94,11.34,9.25,7.19,6.12,4.06,-0.09,-2.97,-2.88,-1.84,-2.09,-2.94,-1.94,-0.91,-2.22,-4.44,-4.91,-3.84,-3.25,-3.78,-2.72,0.88,4.47,6.12,7.94,11.38,14.41,14.16,12.69,12.62,12.53,9.97,6.47,4.53,3.91,2.75,-0.12,-2.06,-1.97,-2.03,-4.31,-5.88,-5.53,-5.16,-7.44,-10.94,-13.09,-14.56,-17.09,-20.34,-21.62,-20.38,-18.88,-17.78,-15.0,-9.75,-4.22,-1.12,1.59,5.91,10.38,12.19,12.44,13.53,14.94,14.19,11.78,10.41,10.72,10.66,8.72,8.0,8.53,9.12,6.59,4.03,3.25,3.41,2.47,1.78,3.31,6.72,9.06,9.28,9.53,10.47,9.78,6.56,3.94,3.62,4.16,39.97,39.78,39.72,40.81,41.72,41.19,40.59,40.78,40.78,39.56,37.69,37.06,37.78,37.69:9.69,9.12,8.19,8.78,9.97,9.53,8.56,9.12,11.25,12.34,11.56,11.34,12.34,11.97,8.56,4.97,3.38,2.44,0.16,-1.62,-0.62,1.84,2.66,2.22,3.22,5.12,5.22,4.0,3.5,5.12,6.56,6.06,5.56,7.16,9.0,8.44,7.38,7.94,9.47,8.75,7.16,7.0,8.03,8.56,6.91,5.81,6.53,7.09,5.59,4.62,5.56,7.44,6.38,4.19,3.53,3.75,2.75,0.78,0.78,3.03,5.16,5.25,6.06,8.62,10.81,9.97,8.31,8.0,7.69,4.62,0.72,-1.09,-1.56,-2.47,-3.69,-3.16,-0.47,2.03,2.84,4.06,6.62,9.12,8.91,8.0,8.5,9.59,8.5,6.88,6.47,7.31,6.72,4.47,3.0,3.62,3.88,2.62,2.12,4.03,5.88,5.69,4.75,4.94,5.62,4.31,1.66,0.53,1.5,1.53,0.47,0.44,2.16,3.16,2.16,0.91,1.69,2.97,3.09,3.25,5.22,8.47,9.78,9.94,10.97,13.31,13.81,11.97,9.88,9.31,8.22,5.56,3.44,3.78,5.5,5.09,3.69,3.81,4.84,4.03,2.53,2.59,5.53,7.81,8.09,8.38,9.94,10.78,9.22,7.0,5.94,5.38,2.31,-1.38,-2.94,-2.62,-2.34,-2.19,-0.31,4.25,7.62,8.25,8.22,8.91,8.75,6.06,2.44,0.94,0.34,-1.69,-3.78,-3.56,-0.84,1.06,1.66,2.75,5.06,5.38,3.56,1.53,1.28,2.12,1.72,1.19,2.66,5.38,6.56,6.38,7.75,10.06,10.5,8.72,6.38,5.28,3.41,-0.34,-3.72,-3.84,-2.59,-2.0,-1.12,1.69,5.81,8.44,9.28,11.28,14.84,16.25,15.53,14.16,14.03,12.94,9.97,7.19,7.09,8.25,8.16,7.62,8.59,10.28,10.0,8.06,6.56,6.78,6.34,4.84,3.78,5.75,7.94,8.34,8.41,10.09,12.31,12.62,11.91,12.09,13.41,13.47,11.97,10.94,11.78,11.91,9.78,7.34,6.88,6.47,4.53,2.16,2.16,3.16,3.03,2.28,2.78,4.88,5.91,4.62,3.56,4.62,4.94,3.75,2.88,4.47,7.22,8.59,9.25,11.0,12.94,12.25,9.47,6.84,5.84,3.91,-0.28,-3.75,-4.84,-5.78,-8.03,-9.22,-7.34,-4.47,-2.44,-0.94,2.59,7.19,10.81,13.0,15.56,19.81,22.66,22.75,22.5,23.5,23.66,21.5,18.22,17.19,16.44,13.84,10.53,9.0,9.44,9.09,7.94,8.31,10.44,11.22,9.44,7.06,6.28,5.44,3.38,1.19,1.62,2.94,2.62,1.09,0.34,1.0,0.19,-1.81,-2.97,-1.16,0.5,0.5,0.78,2.84,4.84,4.56,3.75,4.62,5.97,5.66,3.59,2.94,3.41,3.38,1.69,0.47,1.31,1.88,0.19,-1.16,-0.38,0.78,0.0,-1.78,-1.62,-0.53,-0.19,-0.75,-0.12,2.12,3.0,1.88,0.84,1.91,2.53,1.56,0.03,1.16,3.31,3.56,3.16,4.59,6.28,6.0,3.22,1.41,1.09,0.5,-1.09,-1.41,0.91,3.81,4.78,5.34,7.41,9.62,9.31,7.28,6.16,6.16,5.66,3.78,3.59,5.78,7.44,6.56,5.25,5.5,5.72,4.16,2.84,3.69,6.06,7.56,8.47,10.84,15.12,18.28,19.5,20.31,22.03,22.28,19.28,15.03,12.66,10.16,5.97,1.06,-1.84,-3.34,-6.34,-10.69,-12.75,-12.59,-12.38,-12.69,-10.91,-5.72,0.03,4.03,7.91,13.53,18.78,20.88,20.75,21.28,21.59,19.38,15.25,12.19,10.47,8.19,4.19,0.84,-0.03,-0.5,-2.53,-4.38,-4.0,-2.12,-2.09,-2.66,-0.94,2.22,4.19,4.34,5.12,7.41,8.41,7.0,5.69,6.38,7.03,5.88,3.78,3.56,3.91,2.91,0.84,0.59,1.66,1.41,-0.75,-2.72,-2.84,-3.09,-5.12,-5.97,-4.31,-2.03,-1.75,-1.94,-0.56,1.66,2.75,2.28,3.34,5.75,6.91,5.88,5.31,6.16,7.22,5.94,4.47,5.28,6.69,6.31,5.19,6.25,8.22,9.25,8.19,8.28,9.59,9.91,7.59,5.44,5.09,3.69,0.16,-3.31,-4.12,-3.25,-3.25,-3.41,-1.56,1.16,2.12,0.91,1.09,3.09,4.75,4.72,5.72,8.53,11.16,10.97,10.25,11.59,13.16,12.91,11.19,10.47,10.88,10.0,6.88,5.56,6.0,6.19,4.81,3.94,5.28,6.97,6.78,6.44,7.62,9.72,10.19,8.88,8.81,9.53,9.25,7.12,6.09,7.72,9.62,10.12,11.12,13.81,16.81,16.97,15.75,15.59,16.25,15.12,12.62,11.62,12.72,13.56,12.5,12.09,13.5,14.88,13.41,11.28,11.0,11.19,8.94,6.09,5.03,6.06,6.53,6.0,7.22,10.66,13.5,13.56,14.0,16.06,17.41,15.75,13.53,12.81,12.62,10.66,7.97,7.25,8.59,9.5,8.88,9.5,12.19,13.62,12.44,11.62,12.16,12.47,10.06,6.69,5.06,4.44,2.44,0.38,0.06,1.88,2.75,1.66,1.59,3.5,4.59,3.66,2.88,4.22,6.03,5.59,4.66,5.91,8.12,8.41,7.47,7.69,9.41,9.62,8.0,7.22,8.75,9.97,9.06,7.88,8.53,9.28,7.72,5.34,4.53,5.09,3.97,1.88,0.66,1.78,2.34,1.5,1.72,4.5,7.34,7.16,6.62,7.16,7.94,6.62,5.0,5.53,8.25,9.53,9.06,8.97,10.41,10.38,7.84,5.91,6.5,7.56,6.66,5.78,6.44,7.94,7.44,5.38,5.16,6.47,6.75,5.53,5.28,7.22,8.25,7.38,7.16,8.75,10.22,8.84,6.56,5.72,6.09,4.88,3.5,4.19,6.88,8.28,8.16,8.38,10.88,12.53,11.59,10.62,11.28,11.62,9.47,6.47,5.28,5.22,3.41,1.03,0.53,2.31,3.5,2.59,1.94,3.25,3.5,1.44,-0.72,0.03,1.59,1.47,1.09,2.25,4.56,5.38,4.59,5.25,7.75,9.19,8.62,8.0,9.59,10.56,9.34,7.25,7.5,7.88,6.41,4.31,3.66,4.47,3.38,0.56,-0.94,-1.16,-1.5,-3.5,-4.81,-3.03,-1.25,-1.66,-2.34,-1.12,0.22,-0.44,-2.47,-3.06,-1.97,-2.19,-3.78,-3.44,-1.19,1.06,1.91,2.91,5.88,8.06,7.59,5.78,5.69,7.0,7.25,6.97,8.75,11.88,12.91,11.97,10.5,10.66,10.25,7.69,5.44,5.56,6.19,4.62,1.88,1.28,1.78,1.09,-0.06,-0.09,1.56,2.19,1.16,0.38,2.19,3.53,2.38,1.06,1.78,2.97,2.41,1.16,2.22,4.94,6.62,7.62,10.0,14.09,16.06,14.81,13.0,12.44,10.91,7.62,3.78,2.88,3.12,2.0,0.09,0.16,1.84,2.0,1.38,1.75,4.62,6.47,5.75,5.19,6.25,7.75,7.0,5.84,6.78,8.5,8.12,6.38,6.69,8.09,8.38,6.81,6.47,8.78,10.59,10.53,10.28,11.81,12.62,10.19,7.5,6.56,6.75,6.16,4.28,3.91,5.06,4.91,3.03,2.41,4.59,6.56,6.5,5.81,7.22,8.53,7.59,5.62,5.31,5.66,4.53,1.88,1.25,2.56,3.16,2.25,1.53,2.91,3.34,1.72,-0.56,-0.69,-0.16,-1.72,-4.19,-4.97,-3.97,-4.19,-5.09,-4.5,-2.19,-0.59,-1.72,-3.0,-2.28,-2.25,-4.56,-7.44,-7.91,-7.28,-7.91,-9.34,-8.5,-5.91,-4.69,-5.47,-5.03,-3.0,-2.25,-3.53,-4.62,-3.44,-2.5,-3.56,-5.06,-4.28,-2.16,-1.59,-1.84,-0.78,1.78,2.97,2.44,2.38,4.12,4.97,3.28,1.69,1.88,2.19,1.09,-0.62,-0.16,1.22,0.81,-1.34,-1.91,-1.12,-0.91,-2.16,-1.56,1.22,3.53,3.25,2.34,2.62,2.94,1.25,-1.22,-1.28,0.19,0.25,-0.88,-0.97,0.44,0.59,-1.75,-3.47,-3.16,-3.28,-5.59,-7.78,-7.59,-6.88,-7.34,-8.47,-7.25,-5.28,-4.19,-4.72,-4.41,-2.59,-2.03,-4.22,-6.12,-6.53,-6.5,-8.41,-10.53,-9.88,-8.59,-8.62,-9.19,-7.66,-5.03,-2.91,-2.97,-2.12,0.06,1.31,0.0,-1.53,-1.06,-0.28,-1.31,-2.16,-0.59,1.62,2.66,1.78,2.91,5.38,6.81,6.53,6.72,8.69,9.69,7.78,5.53,5.38,5.88,4.47,3.25,4.84,7.72,9.31,9.12,9.44,9.78,8.03,3.72,0.28,-0.84,-1.31,-3.28,-4.5,-2.38,0.91,2.06,2.78,4.53,6.31,5.88,2.97,1.44,1.16,0.25,-2.56,-4.44,-3.19,-1.19,-1.03,-0.69,2.16,5.47,6.53,6.72,8.62,10.94,11.34,9.25,7.19,6.12,4.06,-0.09,-2.97,-2.88,-1.84,-2.09,-2.94,-1.94,-0.91,-2.22,-4.44,-4.91,-3.84,-3.25,-3.78,-2.72,0.88,4.47,6.12,7.94,11.38,14.41,14.16,12.69,12.62,12.53,9.97,6.47,4.53,3.91,2.75,-0.12,-2.06,-1.97,-2.03,-4.31,-5.88,-5.53,-5.16,-7.44,-10.94,-13.09,-14.56,-17.09,-20.34,-21.62,-20.38,-18.88,-17.78,-15.0,-9.75,-4.22,-1.12,1.59,5.91,10.38,12.19,12.44,13.53,14.94,14.19,11.78,10.41,10.72,10.66,8.72,8.0,8.53,9.12,6.59,4.03,3.25,3.41,2.47,1.78,3.31,6.72,9.06,9.28,9.53,10.47,9.78,6.56,3.94,3.62,4.16,39.97,39.78,39.72,40.81,41.72,41.19,40.59,40.78,40.78,39.56,37.69,37.06,37.78,37.69,37.31,37.94,39.38,40.62,40.97,41.75,44.0:9.12,11.25,12.34,11.56,11.34,12.34,11.97,8.56,4.97,3.38,2.44,0.16,-1.62,-0.62,1.84,2.66,2.22,3.22,5.12,5.22,4.0,3.5,5.12,6.56,6.06,5.56,7.16,9.0,8.44,7.38,7.94,9.47,8.75,7.16,7.0,8.03,8.56,6.91,5.81,6.53,7.09,5.59,4.62,5.56,7.44,6.38,4.19,3.53,3.75,2.75,0.78,0.78,3.03,5.16,5.25,6.06,8.62,10.81,9.97,8.31,8.0,7.69,4.62,0.72,-1.09,-1.56,-2.47,-3.69,-3.16,-0.47,2.03,2.84,4.06,6.62,9.12,8.91,8.0,8.5,9.59,8.5,6.88,6.47,7.31,6.72,4.47,3.0,3.62,3.88,2.62,2.12,4.03,5.88,5.69,4.75,4.94,5.62,4.31,1.66,0.53,1.5,1.53,0.47,0.44,2.16,3.16,2.16,0.91,1.69,2.97,3.09,3.25,5.22,8.47,9.78,9.94,10.97,13.31,13.81,11.97,9.88,9.31,8.22,5.56,3.44,3.78,5.5,5.09,3.69,3.81,4.84,4.03,2.53,2.59,5.53,7.81,8.09,8.38,9.94,10.78,9.22,7.0,5.94,5.38,2.31,-1.38,-2.94,-2.62,-2.34,-2.19,-0.31,4.25,7.62,8.25,8.22,8.91,8.75,6.06,2.44,0.94,0.34,-1.69,-3.78,-3.56,-0.84,1.06,1.66,2.75,5.06,5.38,3.56,1.53,1.28,2.12,1.72,1.19,2.66,5.38,6.56,6.38,7.75,10.06,10.5,8.72,6.38,5.28,3.41,-0.34,-3.72,-3.84,-2.59,-2.0,-1.12,1.69,5.81,8.44,9.28,11.28,14.84,16.25,15.53,14.16,14.03,12.94,9.97,7.19,7.09,8.25,8.16,7.62,8.59,10.28,10.0,8.06,6.56,6.78,6.34,4.84,3.78,5.75,7.94,8.34,8.41,10.09,12.31,12.62,11.91,12.09,13.41,13.47,11.97,10.94,11.78,11.91,9.78,7.34,6.88,6.47,4.53,2.16,2.16,3.16,3.03,2.28,2.78,4.88,5.91,4.62,3.56,4.62,4.94,3.75,2.88,4.47,7.22,8.59,9.25,11.0,12.94,12.25,9.47,6.84,5.84,3.91,-0.28,-3.75,-4.84,-5.78,-8.03,-9.22,-7.34,-4.47,-2.44,-0.94,2.59,7.19,10.81,13.0,15.56,19.81,22.66,22.75,22.5,23.5,23.66,21.5,18.22,17.19,16.44,13.84,10.53,9.0,9.44,9.09,7.94,8.31,10.44,11.22,9.44,7.06,6.28,5.44,3.38,1.19,1.62,2.94,2.62,1.09,0.34,1.0,0.19,-1.81,-2.97,-1.16,0.5,0.5,0.78,2.84,4.84,4.56,3.75,4.62,5.97,5.66,3.59,2.94,3.41,3.38,1.69,0.47,1.31,1.88,0.19,-1.16,-0.38,0.78,0.0,-1.78,-1.62,-0.53,-0.19,-0.75,-0.12,2.12,3.0,1.88,0.84,1.91,2.53,1.56,0.03,1.16,3.31,3.56,3.16,4.59,6.28,6.0,3.22,1.41,1.09,0.5,-1.09,-1.41,0.91,3.81,4.78,5.34,7.41,9.62,9.31,7.28,6.16,6.16,5.66,3.78,3.59,5.78,7.44,6.56,5.25,5.5,5.72,4.16,2.84,3.69,6.06,7.56,8.47,10.84,15.12,18.28,19.5,20.31,22.03,22.28,19.28,15.03,12.66,10.16,5.97,1.06,-1.84,-3.34,-6.34,-10.69,-12.75,-12.59,-12.38,-12.69,-10.91,-5.72,0.03,4.03,7.91,13.53,18.78,20.88,20.75,21.28,21.59,19.38,15.25,12.19,10.47,8.19,4.19,0.84,-0.03,-0.5,-2.53,-4.38,-4.0,-2.12,-2.09,-2.66,-0.94,2.22,4.19,4.34,5.12,7.41,8.41,7.0,5.69,6.38,7.03,5.88,3.78,3.56,3.91,2.91,0.84,0.59,1.66,1.41,-0.75,-2.72,-2.84,-3.09,-5.12,-5.97,-4.31,-2.03,-1.75,-1.94,-0.56,1.66,2.75,2.28,3.34,5.75,6.91,5.88,5.31,6.16,7.22,5.94,4.47,5.28,6.69,6.31,5.19,6.25,8.22,9.25,8.19,8.28,9.59,9.91,7.59,5.44,5.09,3.69,0.16,-3.31,-4.12,-3.25,-3.25,-3.41,-1.56,1.16,2.12,0.91,1.09,3.09,4.75,4.72,5.72,8.53,11.16,10.97,10.25,11.59,13.16,12.91,11.19,10.47,10.88,10.0,6.88,5.56,6.0,6.19,4.81,3.94,5.28,6.97,6.78,6.44,7.62,9.72,10.19,8.88,8.81,9.53,9.25,7.12,6.09,7.72,9.62,10.12,11.12,13.81,16.81,16.97,15.75,15.59,16.25,15.12,12.62,11.62,12.72,13.56,12.5,12.09,13.5,14.88,13.41,11.28,11.0,11.19,8.94,6.09,5.03,6.06,6.53,6.0,7.22,10.66,13.5,13.56,14.0,16.06,17.41,15.75,13.53,12.81,12.62,10.66,7.97,7.25,8.59,9.5,8.88,9.5,12.19,13.62,12.44,11.62,12.16,12.47,10.06,6.69,5.06,4.44,2.44,0.38,0.06,1.88,2.75,1.66,1.59,3.5,4.59,3.66,2.88,4.22,6.03,5.59,4.66,5.91,8.12,8.41,7.47,7.69,9.41,9.62,8.0,7.22,8.75,9.97,9.06,7.88,8.53,9.28,7.72,5.34,4.53,5.09,3.97,1.88,0.66,1.78,2.34,1.5,1.72,4.5,7.34,7.16,6.62,7.16,7.94,6.62,5.0,5.53,8.25,9.53,9.06,8.97,10.41,10.38,7.84,5.91,6.5,7.56,6.66,5.78,6.44,7.94,7.44,5.38,5.16,6.47,6.75,5.53,5.28,7.22,8.25,7.38,7.16,8.75,10.22,8.84,6.56,5.72,6.09,4.88,3.5,4.19,6.88,8.28,8.16,8.38,10.88,12.53,11.59,10.62,11.28,11.62,9.47,6.47,5.28,5.22,3.41,1.03,0.53,2.31,3.5,2.59,1.94,3.25,3.5,1.44,-0.72,0.03,1.59,1.47,1.09,2.25,4.56,5.38,4.59,5.25,7.75,9.19,8.62,8.0,9.59,10.56,9.34,7.25,7.5,7.88,6.41,4.31,3.66,4.47,3.38,0.56,-0.94,-1.16,-1.5,-3.5,-4.81,-3.03,-1.25,-1.66,-2.34,-1.12,0.22,-0.44,-2.47,-3.06,-1.97,-2.19,-3.78,-3.44,-1.19,1.06,1.91,2.91,5.88,8.06,7.59,5.78,5.69,7.0,7.25,6.97,8.75,11.88,12.91,11.97,10.5,10.66,10.25,7.69,5.44,5.56,6.19,4.62,1.88,1.28,1.78,1.09,-0.06,-0.09,1.56,2.19,1.16,0.38,2.19,3.53,2.38,1.06,1.78,2.97,2.41,1.16,2.22,4.94,6.62,7.62,10.0,14.09,16.06,14.81,13.0,12.44,10.91,7.62,3.78,2.88,3.12,2.0,0.09,0.16,1.84,2.0,1.38,1.75,4.62,6.47,5.75,5.19,6.25,7.75,7.0,5.84,6.78,8.5,8.12,6.38,6.69,8.09,8.38,6.81,6.47,8.78,10.59,10.53,10.28,11.81,12.62,10.19,7.5,6.56,6.75,6.16,4.28,3.91,5.06,4.91,3.03,2.41,4.59,6.56,6.5,5.81,7.22,8.53,7.59,5.62,5.31,5.66,4.53,1.88,1.25,2.56,3.16,2.25,1.53,2.91,3.34,1.72,-0.56,-0.69,-0.16,-1.72,-4.19,-4.97,-3.97,-4.19,-5.09,-4.5,-2.19,-0.59,-1.72,-3.0,-2.28,-2.25,-4.56,-7.44,-7.91,-7.28,-7.91,-9.34,-8.5,-5.91,-4.69,-5.47,-5.03,-3.0,-2.25,-3.53,-4.62,-3.44,-2.5,-3.56,-5.06,-4.28,-2.16,-1.59,-1.84,-0.78,1.78,2.97,2.44,2.38,4.12,4.97,3.28,1.69,1.88,2.19,1.09,-0.62,-0.16,1.22,0.81,-1.34,-1.91,-1.12,-0.91,-2.16,-1.56,1.22,3.53,3.25,2.34,2.62,2.94,1.25,-1.22,-1.28,0.19,0.25,-0.88,-0.97,0.44,0.59,-1.75,-3.47,-3.16,-3.28,-5.59,-7.78,-7.59,-6.88,-7.34,-8.47,-7.25,-5.28,-4.19,-4.72,-4.41,-2.59,-2.03,-4.22,-6.12,-6.53,-6.5,-8.41,-10.53,-9.88,-8.59,-8.62,-9.19,-7.66,-5.03,-2.91,-2.97,-2.12,0.06,1.31,0.0,-1.53,-1.06,-0.28,-1.31,-2.16,-0.59,1.62,2.66,1.78,2.91,5.38,6.81,6.53,6.72,8.69,9.69,7.78,5.53,5.38,5.88,4.47,3.25,4.84,7.72,9.31,9.12,9.44,9.78,8.03,3.72,0.28,-0.84,-1.31,-3.28,-4.5,-2.38,0.91,2.06,2.78,4.53,6.31,5.88,2.97,1.44,1.16,0.25,-2.56,-4.44,-3.19,-1.19,-1.03,-0.69,2.16,5.47,6.53,6.72,8.62,10.94,11.34,9.25,7.19,6.12,4.06,-0.09,-2.97,-2.88,-1.84,-2.09,-2.94,-1.94,-0.91,-2.22,-4.44,-4.91,-3.84,-3.25,-3.78,-2.72,0.88,4.47,6.12,7.94,11.38,14.41,14.16,12.69,12.62,12.53,9.97,6.47,4.53,3.91,2.75,-0.12,-2.06,-1.97,-2.03,-4.31,-5.88,-5.53,-5.16,-7.44,-10.94,-13.09,-14.56,-17.09,-20.34,-21.62,-20.38,-18.88,-17.78,-15.0,-9.75,-4.22,-1.12,1.59,5.91,10.38,12.19,12.44,13.53,14.94,14.19,11.78,10.41,10.72,10.66,8.72,8.0,8.53,9.12,6.59,4.03,3.25,3.41,2.47,1.78,3.31,6.72,9.06,9.28,9.53,10.47,9.78,6.56,3.94,3.62,4.16,39.97,39.78,39.72,40.81,41.72,41.19,40.59,40.78,40.78,39.56,37.69,37.06,37.78,37.69,37.31,37.94,39.38,40.62,40.97,41.75,44.0,45.84,45.78,44.88,44.84,45.0,44.38,43.84:8.56,4.97,3.38,2.44,0.16,-1.62,-0.62,1.84,2.66,2.22,3.22,5.12,5.22,4.0,3.5,5.12,6.56,6.06,5.56,7.16,9.0,8.44,7.38,7.94,9.47,8.75,7.16,7.0,8.03,8.56,6.91,5.81,6.53,7.09,5.59,4.62,5.56,7.44,6.38,4.19,3.53,3.75,2.75,0.78,0.78,3.03,5.16,5.25,6.06,8.62,10.81,9.97,8.31,8.0,7.69,4.62,0.72,-1.09,-1.56,-2.47,-3.69,-3.16,-0.47,2.03,2.84,4.06,6.62,9.12,8.91,8.0,8.5,9.59,8.5,6.88,6.47,7.31,6.72,4.47,3.0,3.62,3.88,2.62,2.12,4.03,5.88,5.69,4.75,4.94,5.62,4.31,1.66,0.53,1.5,1.53,0.47,0.44,2.16,3.16,2.16,0.91,1.69,2.97,3.09,3.25,5.22,8.47,9.78,9.94,10.97,13.31,13.81,11.97,9.88,9.31,8.22,5.56,3.44,3.78,5.5,5.09,3.69,3.81,4.84,4.03,2.53,2.59,5.53,7.81,8.09,8.38,9.94,10.78,9.22,7.0,5.94,5.38,2.31,-1.38,-2.94,-2.62,-2.34,-2.19,-0.31,4.25,7.62,8.25,8.22,8.91,8.75,6.06,2.44,0.94,0.34,-1.69,-3.78,-3.56,-0.84,1.06,1.66,2.75,5.06,5.38,3.56,1.53,1.28,2.12,1.72,1.19,2.66,5.38,6.56,6.38,7.75,10.06,10.5,8.72,6.38,5.28,3.41,-0.34,-3.72,-3.84,-2.59,-2.0,-1.12,1.69,5.81,8.44,9.28,11.28,14.84,16.25,15.53,14.16,14.03,12.94,9.97,7.19,7.09,8.25,8.16,7.62,8.59,10.28,10.0,8.06,6.56,6.78,6.34,4.84,3.78,5.75,7.94,8.34,8.41,10.09,12.31,12.62,11.91,12.09,13.41,13.47,11.97,10.94,11.78,11.91,9.78,7.34,6.88,6.47,4.53,2.16,2.16,3.16,3.03,2.28,2.78,4.88,5.91,4.62,3.56,4.62,4.94,3.75,2.88,4.47,7.22,8.59,9.25,11.0,12.94,12.25,9.47,6.84,5.84,3.91,-0.28,-3.75,-4.84,-5.78,-8.03,-9.22,-7.34,-4.47,-2.44,-0.94,2.59,7.19,10.81,13.0,15.56,19.81,22.66,22.75,22.5,23.5,23.66,21.5,18.22,17.19,16.44,13.84,10.53,9.0,9.44,9.09,7.94,8.31,10.44,11.22,9.44,7.06,6.28,5.44,3.38,1.19,1.62,2.94,2.62,1.09,0.34,1.0,0.19,-1.81,-2.97,-1.16,0.5,0.5,0.78,2.84,4.84,4.56,3.75,4.62,5.97,5.66,3.59,2.94,3.41,3.38,1.69,0.47,1.31,1.88,0.19,-1.16,-0.38,0.78,0.0,-1.78,-1.62,-0.53,-0.19,-0.75,-0.12,2.12,3.0,1.88,0.84,1.91,2.53,1.56,0.03,1.16,3.31,3.56,3.16,4.59,6.28,6.0,3.22,1.41,1.09,0.5,-1.09,-1.41,0.91,3.81,4.78,5.34,7.41,9.62,9.31,7.28,6.16,6.16,5.66,3.78,3.59,5.78,7.44,6.56,5.25,5.5,5.72,4.16,2.84,3.69,6.06,7.56,8.47,10.84,15.12,18.28,19.5,20.31,22.03,22.28,19.28,15.03,12.66,10.16,5.97,1.06,-1.84,-3.34,-6.34,-10.69,-12.75,-12.59,-12.38,-12.69,-10.91,-5.72,0.03,4.03,7.91,13.53,18.78,20.88,20.75,21.28,21.59,19.38,15.25,12.19,10.47,8.19,4.19,0.84,-0.03,-0.5,-2.53,-4.38,-4.0,-2.12,-2.09,-2.66,-0.94,2.22,4.19,4.34,5.12,7.41,8.41,7.0,5.69,6.38,7.03,5.88,3.78,3.56,3.91,2.91,0.84,0.59,1.66,1.41,-0.75,-2.72,-2.84,-3.09,-5.12,-5.97,-4.31,-2.03,-1.75,-1.94,-0.56,1.66,2.75,2.28,3.34,5.75,6.91,5.88,5.31,6.16,7.22,5.94,4.47,5.28,6.69,6.31,5.19,6.25,8.22,9.25,8.19,8.28,9.59,9.91,7.59,5.44,5.09,3.69,0.16,-3.31,-4.12,-3.25,-3.25,-3.41,-1.56,1.16,2.12,0.91,1.09,3.09,4.75,4.72,5.72,8.53,11.16,10.97,10.25,11.59,13.16,12.91,11.19,10.47,10.88,10.0,6.88,5.56,6.0,6.19,4.81,3.94,5.28,6.97,6.78,6.44,7.62,9.72,10.19,8.88,8.81,9.53,9.25,7.12,6.09,7.72,9.62,10.12,11.12,13.81,16.81,16.97,15.75,15.59,16.25,15.12,12.62,11.62,12.72,13.56,12.5,12.09,13.5,14.88,13.41,11.28,11.0,11.19,8.94,6.09,5.03,6.06,6.53,6.0,7.22,10.66,13.5,13.56,14.0,16.06,17.41,15.75,13.53,12.81,12.62,10.66,7.97,7.25,8.59,9.5,8.88,9.5,12.19,13.62,12.44,11.62,12.16,12.47,10.06,6.69,5.06,4.44,2.44,0.38,0.06,1.88,2.75,1.66,1.59,3.5,4.59,3.66,2.88,4.22,6.03,5.59,4.66,5.91,8.12,8.41,7.47,7.69,9.41,9.62,8.0,7.22,8.75,9.97,9.06,7.88,8.53,9.28,7.72,5.34,4.53,5.09,3.97,1.88,0.66,1.78,2.34,1.5,1.72,4.5,7.34,7.16,6.62,7.16,7.94,6.62,5.0,5.53,8.25,9.53,9.06,8.97,10.41,10.38,7.84,5.91,6.5,7.56,6.66,5.78,6.44,7.94,7.44,5.38,5.16,6.47,6.75,5.53,5.28,7.22,8.25,7.38,7.16,8.75,10.22,8.84,6.56,5.72,6.09,4.88,3.5,4.19,6.88,8.28,8.16,8.38,10.88,12.53,11.59,10.62,11.28,11.62,9.47,6.47,5.28,5.22,3.41,1.03,0.53,2.31,3.5,2.59,1.94,3.25,3.5,1.44,-0.72,0.03,1.59,1.47,1.09,2.25,4.56,5.38,4.59,5.25,7.75,9.19,8.62,8.0,9.59,10.56,9.34,7.25,7.5,7.88,6.41,4.31,3.66,4.47,3.38,0.56,-0.94,-1.16,-1.5,-3.5,-4.81,-3.03,-1.25,-1.66,-2.34,-1.12,0.22,-0.44,-2.47,-3.06,-1.97,-2.19,-3.78,-3.44,-1.19,1.06,1.91,2.91,5.88,8.06,7.59,5.78,5.69,7.0,7.25,6.97,8.75,11.88,12.91,11.97,10.5,10.66,10.25,7.69,5.44,5.56,6.19,4.62,1.88,1.28,1.78,1.09,-0.06,-0.09,1.56,2.19,1.16,0.38,2.19,3.53,2.38,1.06,1.78,2.97,2.41,1.16,2.22,4.94,6.62,7.62,10.0,14.09,16.06,14.81,13.0,12.44,10.91,7.62,3.78,2.88,3.12,2.0,0.09,0.16,1.84,2.0,1.38,1.75,4.62,6.47,5.75,5.19,6.25,7.75,7.0,5.84,6.78,8.5,8.12,6.38,6.69,8.09,8.38,6.81,6.47,8.78,10.59,10.53,10.28,11.81,12.62,10.19,7.5,6.56,6.75,6.16,4.28,3.91,5.06,4.91,3.03,2.41,4.59,6.56,6.5,5.81,7.22,8.53,7.59,5.62,5.31,5.66,4.53,1.88,1.25,2.56,3.16,2.25,1.53,2.91,3.34,1.72,-0.56,-0.69,-0.16,-1.72,-4.19,-4.97,-3.97,-4.19,-5.09,-4.5,-2.19,-0.59,-1.72,-3.0,-2.28,-2.25,-4.56,-7.44,-7.91,-7.28,-7.91,-9.34,-8.5,-5.91,-4.69,-5.47,-5.03,-3.0,-2.25,-3.53,-4.62,-3.44,-2.5,-3.56,-5.06,-4.28,-2.16,-1.59,-1.84,-0.78,1.78,2.97,2.44,2.38,4.12,4.97,3.28,1.69,1.88,2.19,1.09,-0.62,-0.16,1.22,0.81,-1.34,-1.91,-1.12,-0.91,-2.16,-1.56,1.22,3.53,3.25,2.34,2.62,2.94,1.25,-1.22,-1.28,0.19,0.25,-0.88,-0.97,0.44,0.59,-1.75,-3.47,-3.16,-3.28,-5.59,-7.78,-7.59,-6.88,-7.34,-8.47,-7.25,-5.28,-4.19,-4.72,-4.41,-2.59,-2.03,-4.22,-6.12,-6.53,-6.5,-8.41,-10.53,-9.88,-8.59,-8.62,-9.19,-7.66,-5.03,-2.91,-2.97,-2.12,0.06,1.31,0.0,-1.53,-1.06,-0.28,-1.31,-2.16,-0.59,1.62,2.66,1.78,2.91,5.38,6.81,6.53,6.72,8.69,9.69,7.78,5.53,5.38,5.88,4.47,3.25,4.84,7.72,9.31,9.12,9.44,9.78,8.03,3.72,0.28,-0.84,-1.31,-3.28,-4.5,-2.38,0.91,2.06,2.78,4.53,6.31,5.88,2.97,1.44,1.16,0.25,-2.56,-4.44,-3.19,-1.19,-1.03,-0.69,2.16,5.47,6.53,6.72,8.62,10.94,11.34,9.25,7.19,6.12,4.06,-0.09,-2.97,-2.88,-1.84,-2.09,-2.94,-1.94,-0.91,-2.22,-4.44,-4.91,-3.84,-3.25,-3.78,-2.72,0.88,4.47,6.12,7.94,11.38,14.41,14.16,12.69,12.62,12.53,9.97,6.47,4.53,3.91,2.75,-0.12,-2.06,-1.97,-2.03,-4.31,-5.88,-5.53,-5.16,-7.44,-10.94,-13.09,-14.56,-17.09,-20.34,-21.62,-20.38,-18.88,-17.78,-15.0,-9.75,-4.22,-1.12,1.59,5.91,10.38,12.19,12.44,13.53,14.94,14.19,11.78,10.41,10.72,10.66,8.72,8.0,8.53,9.12,6.59,4.03,3.25,3.41,2.47,1.78,3.31,6.72,9.06,9.28,9.53,10.47,9.78,6.56,3.94,3.62,4.16,39.97,39.78,39.72,40.81,41.72,41.19,40.59,40.78,40.78,39.56,37.69,37.06,37.78,37.69,37.31,37.94,39.38,40.62,40.97,41.75,44.0,45.84,45.78,44.88,44.84,45.0,44.38,43.84,44.53,46.16,47.28,47.25,47.5,48.12,47.97:1.84,2.66,2.22,3.22,5.12,5.22,4.0,3.5,5.12,6.56,6.06,5.56,7.16,9.0,8.44,7.38,7.94,9.47,8.75,7.16,7.0,8.03,8.56,6.91,5.81,6.53,7.09,5.59,4.62,5.56,7.44,6.38,4.19,3.53,3.75,2.75,0.78,0.78,3.03,5.16,5.25,6.06,8.62,10.81,9.97,8.31,8.0,7.69,4.62,0.72,-1.09,-1.56,-2.47,-3.69,-3.16,-0.47,2.03,2.84,4.06,6.62,9.12,8.91,8.0,8.5,9.59,8.5,6.88,6.47,7.31,6.72,4.47,3.0,3.62,3.88,2.62,2.12,4.03,5.88,5.69,4.75,4.94,5.62,4.31,1.66,0.53,1.5,1.53,0.47,0.44,2.16,3.16,2.16,0.91,1.69,2.97,3.09,3.25,5.22,8.47,9.78,9.94,10.97,13.31,13.81,11.97,9.88,9.31,8.22,5.56,3.44,3.78,5.5,5.09,3.69,3.81,4.84,4.03,2.53,2.59,5.53,7.81,8.09,8.38,9.94,10.78,9.22,7.0,5.94,5.38,2.31,-1.38,-2.94,-2.62,-2.34,-2.19,-0.31,4.25,7.62,8.25,8.22,8.91,8.75,6.06,2.44,0.94,0.34,-1.69,-3.78,-3.56,-0.84,1.06,1.66,2.75,5.06,5.38,3.56,1.53,1.28,2.12,1.72,1.19,2.66,5.38,6.56,6.38,7.75,10.06,10.5,8.72,6.38,5.28,3.41,-0.34,-3.72,-3.84,-2.59,-2.0,-1.12,1.69,5.81,8.44,9.28,11.28,14.84,16.25,15.53,14.16,14.03,12.94,9.97,7.19,7.09,8.25,8.16,7.62,8.59,10.28,10.0,8.06,6.56,6.78,6.34,4.84,3.78,5.75,7.94,8.34,8.41,10.09,12.31,12.62,11.91,12.09,13.41,13.47,11.97,10.94,11.78,11.91,9.78,7.34,6.88,6.47,4.53,2.16,2.16,3.16,3.03,2.28,2.78,4.88,5.91,4.62,3.56,4.62,4.94,3.75,2.88,4.47,7.22,8.59,9.25,11.0,12.94,12.25,9.47,6.84,5.84,3.91,-0.28,-3.75,-4.84,-5.78,-8.03,-9.22,-7.34,-4.47,-2.44,-0.94,2.59,7.19,10.81,13.0,15.56,19.81,22.66,22.75,22.5,23.5,23.66,21.5,18.22,17.19,16.44,13.84,10.53,9.0,9.44,9.09,7.94,8.31,10.44,11.22,9.44,7.06,6.28,5.44,3.38,1.19,1.62,2.94,2.62,1.09,0.34,1.0,0.19,-1.81,-2.97,-1.16,0.5,0.5,0.78,2.84,4.84,4.56,3.75,4.62,5.97,5.66,3.59,2.94,3.41,3.38,1.69,0.47,1.31,1.88,0.19,-1.16,-0.38,0.78,0.0,-1.78,-1.62,-0.53,-0.19,-0.75,-0.12,2.12,3.0,1.88,0.84,1.91,2.53,1.56,0.03,1.16,3.31,3.56,3.16,4.59,6.28,6.0,3.22,1.41,1.09,0.5,-1.09,-1.41,0.91,3.81,4.78,5.34,7.41,9.62,9.31,7.28,6.16,6.16,5.66,3.78,3.59,5.78,7.44,6.56,5.25,5.5,5.72,4.16,2.84,3.69,6.06,7.56,8.47,10.84,15.12,18.28,19.5,20.31,22.03,22.28,19.28,15.03,12.66,10.16,5.97,1.06,-1.84,-3.34,-6.34,-10.69,-12.75,-12.59,-12.38,-12.69,-10.91,-5.72,0.03,4.03,7.91,13.53,18.78,20.88,20.75,21.28,21.59,19.38,15.25,12.19,10.47,8.19,4.19,0.84,-0.03,-0.5,-2.53,-4.38,-4.0,-2.12,-2.09,-2.66,-0.94,2.22,4.19,4.34,5.12,7.41,8.41,7.0,5.69,6.38,7.03,5.88,3.78,3.56,3.91,2.91,0.84,0.59,1.66,1.41,-0.75,-2.72,-2.84,-3.09,-5.12,-5.97,-4.31,-2.03,-1.75,-1.94,-0.56,1.66,2.75,2.28,3.34,5.75,6.91,5.88,5.31,6.16,7.22,5.94,4.47,5.28,6.69,6.31,5.19,6.25,8.22,9.25,8.19,8.28,9.59,9.91,7.59,5.44,5.09,3.69,0.16,-3.31,-4.12,-3.25,-3.25,-3.41,-1.56,1.16,2.12,0.91,1.09,3.09,4.75,4.72,5.72,8.53,11.16,10.97,10.25,11.59,13.16,12.91,11.19,10.47,10.88,10.0,6.88,5.56,6.0,6.19,4.81,3.94,5.28,6.97,6.78,6.44,7.62,9.72,10.19,8.88,8.81,9.53,9.25,7.12,6.09,7.72,9.62,10.12,11.12,13.81,16.81,16.97,15.75,15.59,16.25,15.12,12.62,11.62,12.72,13.56,12.5,12.09,13.5,14.88,13.41,11.28,11.0,11.19,8.94,6.09,5.03,6.06,6.53,6.0,7.22,10.66,13.5,13.56,14.0,16.06,17.41,15.75,13.53,12.81,12.62,10.66,7.97,7.25,8.59,9.5,8.88,9.5,12.19,13.62,12.44,11.62,12.16,12.47,10.06,6.69,5.06,4.44,2.44,0.38,0.06,1.88,2.75,1.66,1.59,3.5,4.59,3.66,2.88,4.22,6.03,5.59,4.66,5.91,8.12,8.41,7.47,7.69,9.41,9.62,8.0,7.22,8.75,9.97,9.06,7.88,8.53,9.28,7.72,5.34,4.53,5.09,3.97,1.88,0.66,1.78,2.34,1.5,1.72,4.5,7.34,7.16,6.62,7.16,7.94,6.62,5.0,5.53,8.25,9.53,9.06,8.97,10.41,10.38,7.84,5.91,6.5,7.56,6.66,5.78,6.44,7.94,7.44,5.38,5.16,6.47,6.75,5.53,5.28,7.22,8.25,7.38,7.16,8.75,10.22,8.84,6.56,5.72,6.09,4.88,3.5,4.19,6.88,8.28,8.16,8.38,10.88,12.53,11.59,10.62,11.28,11.62,9.47,6.47,5.28,5.22,3.41,1.03,0.53,2.31,3.5,2.59,1.94,3.25,3.5,1.44,-0.72,0.03,1.59,1.47,1.09,2.25,4.56,5.38,4.59,5.25,7.75,9.19,8.62,8.0,9.59,10.56,9.34,7.25,7.5,7.88,6.41,4.31,3.66,4.47,3.38,0.56,-0.94,-1.16,-1.5,-3.5,-4.81,-3.03,-1.25,-1.66,-2.34,-1.12,0.22,-0.44,-2.47,-3.06,-1.97,-2.19,-3.78,-3.44,-1.19,1.06,1.91,2.91,5.88,8.06,7.59,5.78,5.69,7.0,7.25,6.97,8.75,11.88,12.91,11.97,10.5,10.66,10.25,7.69,5.44,5.56,6.19,4.62,1.88,1.28,1.78,1.09,-0.06,-0.09,1.56,2.19,1.16,0.38,2.19,3.53,2.38,1.06,1.78,2.97,2.41,1.16,2.22,4.94,6.62,7.62,10.0,14.09,16.06,14.81,13.0,12.44,10.91,7.62,3.78,2.88,3.12,2.0,0.09,0.16,1.84,2.0,1.38,1.75,4.62,6.47,5.75,5.19,6.25,7.75,7.0,5.84,6.78,8.5,8.12,6.38,6.69,8.09,8.38,6.81,6.47,8.78,10.59,10.53,10.28,11.81,12.62,10.19,7.5,6.56,6.75,6.16,4.28,3.91,5.06,4.91,3.03,2.41,4.59,6.56,6.5,5.81,7.22,8.53,7.59,5.62,5.31,5.66,4.53,1.88,1.25,2.56,3.16,2.25,1.53,2.91,3.34,1.72,-0.56,-0.69,-0.16,-1.72,-4.19,-4.97,-3.97,-4.19,-5.09,-4.5,-2.19,-0.59,-1.72,-3.0,-2.28,-2.25,-4.56,-7.44,-7.91,-7.28,-7.91,-9.34,-8.5,-5.91,-4.69,-5.47,-5.03,-3.0,-2.25,-3.53,-4.62,-3.44,-2.5,-3.56,-5.06,-4.28,-2.16,-1.59,-1.84,-0.78,1.78,2.97,2.44,2.38,4.12,4.97,3.28,1.69,1.88,2.19,1.09,-0.62,-0.16,1.22,0.81,-1.34,-1.91,-1.12,-0.91,-2.16,-1.56,1.22,3.53,3.25,2.34,2.62,2.94,1.25,-1.22,-1.28,0.19,0.25,-0.88,-0.97,0.44,0.59,-1.75,-3.47,-3.16,-3.28,-5.59,-7.78,-7.59,-6.88,-7.34,-8.47,-7.25,-5.28,-4.19,-4.72,-4.41,-2.59,-2.03,-4.22,-6.12,-6.53,-6.5,-8.41,-10.53,-9.88,-8.59,-8.62,-9.19,-7.66,-5.03,-2.91,-2.97,-2.12,0.06,1.31,0.0,-1.53,-1.06,-0.28,-1.31,-2.16,-0.59,1.62,2.66,1.78,2.91,5.38,6.81,6.53,6.72,8.69,9.69,7.78,5.53,5.38,5.88,4.47,3.25,4.84,7.72,9.31,9.12,9.44,9.78,8.03,3.72,0.28,-0.84,-1.31,-3.28,-4.5,-2.38,0.91,2.06,2.78,4.53,6.31,5.88,2.97,1.44,1.16,0.25,-2.56,-4.44,-3.19,-1.19,-1.03,-0.69,2.16,5.47,6.53,6.72,8.62,10.94,11.34,9.25,7.19,6.12,4.06,-0.09,-2.97,-2.88,-1.84,-2.09,-2.94,-1.94,-0.91,-2.22,-4.44,-4.91,-3.84,-3.25,-3.78,-2.72,0.88,4.47,6.12,7.94,11.38,14.41,14.16,12.69,12.62,12.53,9.97,6.47,4.53,3.91,2.75,-0.12,-2.06,-1.97,-2.03,-4.31,-5.88,-5.53,-5.16,-7.44,-10.94,-13.09,-14.56,-17.09,-20.34,-21.62,-20.38,-18.88,-17.78,-15.0,-9.75,-4.22,-1.12,1.59,5.91,10.38,12.19,12.44,13.53,14.94,14.19,11.78,10.41,10.72,10.66,8.72,8.0,8.53,9.12,6.59,4.03,3.25,3.41,2.47,1.78,3.31,6.72,9.06,9.28,9.53,10.47,9.78,6.56,3.94,3.62,4.16,39.97,39.78,39.72,40.81,41.72,41.19,40.59,40.78,40.78,39.56,37.69,37.06,37.78,37.69,37.31,37.94,39.38,40.62,40.97,41.75,44.0,45.84,45.78,44.88,44.84,45.0,44.38,43.84,44.53,46.16,47.28,47.25,47.5,48.12,47.97,45.53,43.12,42.06,41.41,40.28,39.69,41.03:negativity
-7.75,-5.66,-4.75,-5.41,-4.5,-1.28,1.22,1.81,2.5,5.16,7.06,6.19,3.88,2.94,2.62,0.31,-3.47,-5.09,-5.06,-6.34,-8.97,-10.19,-9.44,-8.59,-9.44,-9.94,-8.03,-5.81,-6.03,-6.81,-5.69,-3.44,-3.19,-4.31,-4.59,-3.56,-3.94,-6.25,-7.66,-6.59,-5.94,-7.09,-8.06,-6.72,-5.28,-6.34,-8.34,-8.72,-8.03,-8.88,-10.97,-11.44,-9.28,-8.0,-8.31,-7.81,-5.28,-3.69,-4.16,-4.72,-3.19,-1.41,-1.41,-2.66,-2.41,-0.72,-0.66,-2.28,-2.94,-1.91,-2.38,-5.84,-9.0,-9.41,-9.75,-11.25,-11.91,-9.72,-6.47,-4.94,-4.78,-2.78,0.44,1.5,0.75,0.59,2.25,2.97,1.28,0.06,1.22,2.44,1.59,0.5,1.53,2.91,2.31,-0.03,-0.94,-0.59,-1.94,-5.03,-7.22,-6.56,-6.5,-8.41,-10.09,-9.19,-8.53,-9.94,-11.72,-10.56,-8.72,-7.94,-8.38,-7.53,-5.12,-4.5,-6.44,-7.78,-7.28,-7.47,-9.72,-11.47,-10.84,-9.72,-9.88,-10.59,-8.84,-6.22,-5.03,-5.75,-5.25,-3.84,-4.41,-7.31,-9.72,-10.31,-10.75,-12.47,-13.28,-11.0,-7.53,-5.53,-4.81,-2.03,0.91,2.19,1.44,1.47,2.84,2.81,1.0,-0.75,0.31,1.38,0.22,-1.41,-1.31,-1.16,-2.94,-5.78,-6.56,-6.03,-6.38,-8.72,-9.41,-8.56,-8.19,-10.09,-11.25,-9.88,-8.12,-8.38,-8.47,-6.66,-3.75,-2.66,-2.75,-0.94,1.5,2.5,1.06,-0.56,-1.31,-3.72,-9.0,-14.47,-17.16,-19.19,-21.84,-24.03,-23.12,-20.66,-19.59,-19.44,-18.03,-15.38,-13.56,-13.5,-12.78,-10.62,-9.41,-10.44,-11.59,-10.81,-9.44,-9.56,-10.47,-9.59,-7.91,-7.38,-8.03,-7.81,-5.75,-4.84,-5.66,-4.91,-1.53,2.28,4.28,6.12,9.38,11.72,10.75,7.94,6.28,5.09,2.78,-0.88,-2.53,-2.19,-2.28,-4.12,-4.88,-3.06,-1.38,-1.62,-2.12,-0.62,1.22,0.91,-0.84,-1.25,-0.69,-2.19,-4.94,-6.0,-5.0,-4.44,-5.88,-6.25,-4.5,-2.06,-1.44,-0.28,3.0,6.28,6.91,5.75,4.69,4.56,2.75,-0.38,-2.16,-1.59,-0.91,-2.56,-3.25,-2.03,-0.66,-1.12,-1.97,-0.62,1.53,2.0,1.78,2.66,4.53,4.69,2.66,0.47,0.0,-1.09,-3.94,-6.16,-5.75,-4.16,-5.06,-6.31,-5.47,-3.84,-4.06,-4.56,-3.38,-0.59,0.81,0.03,-0.72,-0.03,-0.28,-2.81,-5.25,-5.25,-4.06,-5.03,-6.22,-5.59,-4.66,-5.41,-7.56,-8.28,-6.31,-4.25,-3.66,-1.62,2.28,5.5,5.53,4.81,5.22,5.53,3.91,1.38,0.81,0.97,-0.53,-3.5,-5.19,-5.12,-5.59,-7.5,-8.47,-7.22,-5.62,-5.97,-6.59,-5.25,-3.5,-4.0,-5.47,-5.12,-3.5,-3.0,-3.97,-4.16,-2.66,-2.03,-4.19,-6.06,-6.06,-6.09,-8.28,-10.66,-10.34,-9.16,-9.22,-10.16,-10.06,-9.0,-9.34,-11.5,-11.31,-8.47,-5.47,-4.28,-2.84,-0.12,2.66,2.53,1.94,3.03,4.38,2.94,-0.41,-3.03,-4.84,-7.59,-11.19,-13.19,-12.06,-10.34,-10.59,-10.69,-8.47,-5.81,-5.53,-5.91,-4.69,-2.16,-1.53,-1.34,0.28,3.59,5.22,4.47,4.03,5.31,6.41,6.31,6.5,8.94,11.69,11.53,9.94,9.09,8.91,6.91,3.66,1.19,0.78,-0.59,-4.06,-6.62,-6.69,-6.12,-7.09,-7.12,-4.41,-0.41,1.72,2.56,4.28,6.56,6.5,4.53,3.41,4.28,4.56,2.72,1.41,2.19,2.62,0.28,-3.16,-5.22,-6.72,-10.25,-14.16,-15.47,-14.69,-14.72,-15.38,-14.91,-12.19,-9.88,-9.53,-7.69,-3.88,-0.34,1.06,1.88,4.09,6.31,6.06,4.19,3.06,2.91,0.91,-2.81,-5.44,-5.81,-6.53,-8.28,-9.06,-7.47,-5.84,-6.66,-7.97,-7.91,-6.56,-6.69,-7.5,-6.72,-4.5,-3.62,-4.53,-4.84,-3.22,-2.0,-2.75,-3.84,-3.31,-2.62,-3.91,-5.16,-4.28,-1.66,-0.75,-1.06,-0.31,1.41,1.75,-0.44,-2.47,-2.75,-3.62,-6.06,-8.12,-7.88,-6.91,-8.16,-10.0,-10.22,-9.59,-10.47,-12.47,-13.41,-12.53,-12.19,-13.34,-13.34,-10.75,-8.44,-8.28,-8.91,-8.16,-7.28,-8.66,-10.16,-9.88,-8.38,-8.09,-9.19,-9.25,-7.59,-6.94,-8.25,-9.69,-9.22,-8.91,-10.59,-12.81,-13.06,-12.44,-14.03,-15.84,-15.53,-13.41,-11.94,-11.59,-10.19,-6.59,-3.66,-2.66,-2.03,0.31,1.88,0.31,-2.66,-4.22,-5.06,-7.0,-9.12,-8.94,-6.56,-5.09,-5.44,-5.62,-3.88,-3.66,-5.91,-8.03,-8.09,-7.19,-8.12,-8.84,-7.66,-5.62,-6.09,-8.03,-9.09,-8.72,-9.06,-10.31,-10.66,-8.41,-6.56,-6.75,-7.0,-4.97,-2.56,-2.09,-2.09,-0.22,2.31,3.19,2.5,2.75,4.28,4.72,3.06,1.94,2.91,2.75,0.38,-2.88,-4.53,-6.38,-10.66,-15.25,-17.22,-16.56,-16.28,-15.88,-14.0,-10.25,-7.31,-6.62,-5.84,-2.97,-0.84,-1.22,-2.09,-1.22,-0.38,-1.56,-3.88,-4.78,-4.5,-4.97,-6.75,-7.34,-5.62,-4.72,-6.16,-7.34,-6.69,-6.19,-7.81,-9.56,-9.06,-7.59,-7.47,-8.69,-8.56,-7.34,-7.5,-9.47,-10.78,-10.47,-10.88,-13.03,-14.69,-13.75,-12.34,-12.88,-13.72,-12.31,-10.0,-9.44,-9.47,-8.41,-5.69,-4.41,-4.97,-5.5,-4.25,-3.84,-5.81,-8.19,-8.12,-8.0,-9.66,-11.69,-11.38,-10.16,-10.94,-12.88,-13.53,-12.72,-12.5,-13.41,-12.88,-10.0,-6.75,-5.28,-4.19,-1.62,0.81,0.31,-1.44,-1.25,-0.41,-1.56,-4.34,-6.28,-6.62,-7.97,-10.19,-11.47,-9.75,-8.16,-8.62,-9.31,-8.16,-7.16,-8.22,-10.12,-9.59,-7.84,-7.19,-8.0,-8.41,-6.97,-6.78,-8.69,-9.69,-8.44,-7.44,-8.38,-9.66,-8.72,-6.91,-6.69,-7.69,-6.47,-4.47,-3.66,-4.97,-5.31,-3.72,-3.44,-5.03,-6.66,-6.34,-5.81,-7.56,-9.34,-8.62,-7.59,-8.25,-10.62,-11.34,-11.0,-11.81,-13.59,-13.75,-11.69,-9.38,-8.25,-6.56,-1.94,2.44,4.41,5.19,7.09,9.53,9.38,7.53,7.0,6.66,4.94,1.0,-2.31,-3.47,-4.91,-8.09,-10.94,-11.22,-11.28,-13.38,-16.06,-16.5,-15.66,-16.19,-17.44,-16.69,-14.66,-13.12,-13.28,-12.59,-9.25,-6.31,-5.56,-5.03,-2.44,-0.41,-0.97,-3.09,-3.28,-3.0,-3.75,-5.12,-4.75,-2.47,-0.72,-0.69,-0.75,1.03,1.84,0.03,-2.84,-3.69,-4.0,-6.06,-8.5,-8.75,-7.34,-7.19,-7.84,-6.62,-3.72,-1.41,-0.84,0.03,2.62,4.59,4.16,2.19,2.0,1.84,-0.66,-4.34,-6.31,-6.72,-7.91,-9.88,-9.94,-7.94,-6.25,-7.19,-7.56,-5.62,-3.66,-3.31,-3.97,-2.06,0.5,0.97,0.28,1.25,3.28,3.88,2.25,1.44,2.53,3.12,1.66,0.88,2.06,3.41,2.75,1.59,2.38,4.0,3.91,2.22,1.78,2.59,2.12,-0.53,-2.62,-2.88,-4.03,-7.78,-10.84,-11.66,-11.56,-12.97,-14.31,-12.75,-10.34,-9.41,-9.94,-8.81,-6.56,-5.47,-6.06,-6.12,-4.38,-3.38,-4.97,-6.59,-6.03,-5.44,-7.06,-9.34,-9.81,-9.5,-11.16,-13.97,-15.38,-14.78,-14.25,-15.19,-14.34,-10.94,-8.22,-7.78,-8.06,-6.78,-5.31,-5.97,-7.22,-5.84,-3.41,-2.38,-3.12,-2.94,-1.44,-1.03,-2.88,-3.44,-1.62,0.22,-0.59,-1.75,-1.44,-1.56,-3.34,-6.62,-7.47,-6.75,-7.25,-8.94,-9.22,-8.28,-7.97,-9.44,-10.28,-8.41,-5.94,-5.38,-5.12,-3.12,-0.81,-0.91,-2.53,-2.19,-0.62,-0.28,-1.75,-1.97,-0.75,-0.56,-2.78,-3.94,-2.78,-1.06,-1.56,-2.81,-2.41,-1.72,-3.16,-5.62,-5.81,-4.78,-4.38,-5.72,-5.62,-3.06,-0.56,-0.03,1.09,4.25,7.28,7.59,6.75,7.47,8.47,6.91,3.84,2.28,2.12,1.03,-1.97,-3.84,-3.47,-3.34,-5.0,-6.12,-4.09,-1.97,-2.22,-3.0,-2.25,-0.72,-1.09,-2.72,-3.03,-2.16,-2.06,-3.47,-4.03,-2.53,-1.25,-3.09,-5.06,-5.44,-5.06,-6.22,-7.44,-6.56,-4.03,-2.91,-3.34,-2.28,0.56,2.78,3.03,4.25,6.94,8.88,7.69,5.81,5.44,6.12,4.34,2.12,1.84,3.09,2.59,0.53,0.44,2.31,3.91,3.47,3.34,4.78,5.31,2.66,-0.38,-0.41,0.81,0.66,0.38,2.0,5.12,5.97,4.84,4.47,5.31,5.25,3.0,2.0,3.75,5.94,5.69,5.34,6.69,8.44,7.69,5.53,5.16,6.34,6.22,4.59,4.22,5.56,6.41,4.72,3.75,5.09,6.25,5.06,3.59,3.84,5.38,4.84,3.56,4.19,6.41,7.75,7.41,7.97,10.31,11.66,10.19,8.88,9.41,10.09,8.06,5.41,4.88,5.81,4.88,2.94,2.62,4.0,3.66,1.84,1.69,3.97,6.44,6.38,6.31,8.25,9.88,8.19,5.69,4.59,4.09,2.19,-0.38,-0.94,0.69,1.41,0.12,-0.03,1.66,3.06,2.16,1.38,2.22,3.25,1.16,-1.66,-2.44,-1.41,-2.25,-3.94,-3.44,-1.44,-0.75,-1.94,-2.22,-0.19,1.75,1.28,1.12,2.78,4.78,3.81,1.75,1.12,1.91,1.19,-0.56,-0.25,1.75,2.47,1.0,-0.25,0.47,0.47,-1.94,-4.56,-5.19,-5.06,-6.72,-9.0,-9.31,-7.59,-7.38,-8.12,-7.12,-3.81,-1.59,-1.69,-1.22,1.78:1.81,2.5,5.16,7.06,6.19,3.88,2.94,2.62,0.31,-3.47,-5.09,-5.06,-6.34,-8.97,-10.19,-9.44,-8.59,-9.44,-9.94,-8.03,-5.81,-6.03,-6.81,-5.69,-3.44,-3.19,-4.31,-4.59,-3.56,-3.94,-6.25,-7.66,-6.59,-5.94,-7.09,-8.06,-6.72,-5.28,-6.34,-8.34,-8.72,-8.03,-8.88,-10.97,-11.44,-9.28,-8.0,-8.31,-7.81,-5.28,-3.69,-4.16,-4.72,-3.19,-1.41,-1.41,-2.66,-2.41,-0.72,-0.66,-2.28,-2.94,-1.91,-2.38,-5.84,-9.0,-9.41,-9.75,-11.25,-11.91,-9.72,-6.47,-4.94,-4.78,-2.78,0.44,1.5,0.75,0.59,2.25,2.97,1.28,0.06,1.22,2.44,1.59,0.5,1.53,2.91,2.31,-0.03,-0.94,-0.59,-1.94,-5.03,-7.22,-6.56,-6.5,-8.41,-10.09,-9.19,-8.53,-9.94,-11.72,-10.56,-8.72,-7.94,-8.38,-7.53,-5.12,-4.5,-6.44,-7.78,-7.28,-7.47,-9.72,-11.47,-10.84,-9.72,-9.88,-10.59,-8.84,-6.22,-5.03,-5.75,-5.25,-3.84,-4.41,-7.31,-9.72,-10.31,-10.75,-12.47,-13.28,-11.0,-7.53,-5.53,-4.81,-2.03,0.91,2.19,1.44,1.47,2.84,2.81,1.0,-0.75,0.31,1.38,0.22,-1.41,-1.31,-1.16,-2.94,-5.78,-6.56,-6.03,-6.38,-8.72,-9.41,-8.56,-8.19,-10.09,-11.25,-9.88,-8.12,-8.38,-8.47,-6.66,-3.75,-2.66,-2.75,-0.94,1.5,2.5,1.06,-0.56,-1.31,-3.72,-9.0,-14.47,-17.16,-19.19,-21.84,-24.03,-23.12,-20.66,-19.59,-19.44,-18.03,-15.38,-13.56,-13.5,-12.78,-10.62,-9.41,-10.44,-11.59,-10.81,-9.44,-9.56,-10.47,-9.59,-7.91,-7.38,-8.03,-7.81,-5.75,-4.84,-5.66,-4.91,-1.53,2.28,4.28,6.12,9.38,11.72,10.75,7.94,6.28,5.09,2.78,-0.88,-2.53,-2.19,-2.28,-4.12,-4.88,-3.06,-1.38,-1.62,-2.12,-0.62,1.22,0.91,-0.84,-1.25,-0.69,-2.19,-4.94,-6.0,-5.0,-4.44,-5.88,-6.25,-4.5,-2.06,-1.44,-0.28,3.0,6.28,6.91,5.75,4.69,4.56,2.75,-0.38,-2.16,-1.59,-0.91,-2.56,-3.25,-2.03,-0.66,-1.12,-1.97,-0.62,1.53,2.0,1.78,2.66,4.53,4.69,2.66,0.47,0.0,-1.09,-3.94,-6.16,-5.75,-4.16,-5.06,-6.31,-5.47,-3.84,-4.06,-4.56,-3.38,-0.59,0.81,0.03,-0.72,-0.03,-0.28,-2.81,-5.25,-5.25,-4.06,-5.03,-6.22,-5.59,-4.66,-5.41,-7.56,-8.28,-6.31,-4.25,-3.66,-1.62,2.28,5.5,5.53,4.81,5.22,5.53,3.91,1.38,0.81,0.97,-0.53,-3.5,-5.19,-5.12,-5.59,-7.5,-8.47,-7.22,-5.62,-5.97,-6.59,-5.25,-3.5,-4.0,-5.47,-5.12,-3.5,-3.0,-3.97,-4.16,-2.66,-2.03,-4.19,-6.06,-6.06,-6.09,-8.28,-10.66,-10.34,-9.16,-9.22,-10.16,-10.06,-9.0,-9.34,-11.5,-11.31,-8.47,-5.47,-4.28,-2.84,-0.12,2.66,2.53,1.94,3.03,4.38,2.94,-0.41,-3.03,-4.84,-7.59,-11.19,-13.19,-12.06,-10.34,-10.59,-10.69,-8.47,-5.81,-5.53,-5.91,-4.69,-2.16,-1.53,-1.34,0.28,3.59,5.22,4.47,4.03,5.31,6.41,6.31,6.5,8.94,11.69,11.53,9.94,9.09,8.91,6.91,3.66,1.19,0.78,-0.59,-4.06,-6.62,-6.69,-6.12,-7.09,-7.12,-4.41,-0.41,1.72,2.56,4.28,6.56,6.5,4.53,3.41,4.28,4.56,2.72,1.41,2.19,2.62,0.28,-3.16,-5.22,-6.72,-10.25,-14.16,-15.47,-14.69,-14.72,-15.38,-14.91,-12.19,-9.88,-9.53,-7.69,-3.88,-0.34,1.06,1.88,4.09,6.31,6.06,4.19,3.06,2.91,0.91,-2.81,-5.44,-5.81,-6.53,-8.28,-9.06,-7.47,-5.84,-6.66,-7.97,-7.91,-6.56,-6.69,-7.5,-6.72,-4.5,-3.62,-4.53,-4.84,-3.22,-2.0,-2.75,-3.84,-3.31,-2.62,-3.91,-5.16,-4.28,-1.66,-0.75,-1.06,-0.31,1.41,1.75,-0.44,-2.47,-2.75,-3.62,-6.06,-8.12,-7.88,-6.91,-8.16,-10.0,-10.22,-9.59,-10.47,-12.47,-13.41,-12.53,-12.19,-13.34,-13.34,-10.75,-8.44,-8.28,-8.91,-8.16,-7.28,-8.66,-10.16,-9.88,-8.38,-8.09,-9.19,-9.25,-7.59,-6.94,-8.25,-9.69,-9.22,-8.91,-10.59,-12.81,-13.06,-12.44,-14.03,-15.84,-15.53,-13.41,-11.94,-11.59,-10.19,-6.59,-3.66,-2.66,-2.03,0.31,1.88,0.31,-2.66,-4.22,-5.06,-7.0,-9.12,-8.94,-6.56,-5.09,-5.44,-5.62,-3.88,-3.66,-5.91,-8.03,-8.09,-7.19,-8.12,-8.84,-7.66,-5.62,-6.09,-8.03,-9.09,-8.72,-9.06,-10.31,-10.66,-8.41,-6.56,-6.75,-7.0,-4.97,-2.56,-2.09,-2.09,-0.22,2.31,3.19,2.5,2.75,4.28,4.72,3.06,1.94,2.91,2.75,0.38,-2.88,-4.53,-6.38,-10.66,-15.25,-17.22,-16.56,-16.28,-15.88,-14.0,-10.25,-7.31,-6.62,-5.84,-2.97,-0.84,-1.22,-2.09,-1.22,-0.38,-1.56,-3.88,-4.78,-4.5,-4.97,-6.75,-7.34,-5.62,-4.72,-6.16,-7.34,-6.69,-6.19,-7.81,-9.56,-9.06,-7.59,-7.47,-8.69,-8.56,-7.34,-7.5,-9.47,-10.78,-10.47,-10.88,-13.03,-14.69,-13.75,-12.34,-12.88,-13.72,-12.31,-10.0,-9.44,-9.47,-8.41,-5.69,-4.41,-4.97,-5.5,-4.25,-3.84,-5.81,-8.19,-8.12,-8.0,-9.66,-11.69,-11.38,-10.16,-10.94,-12.88,-13.53,-12.72,-12.5,-13.41,-12.88,-10.0,-6.75,-5.28,-4.19,-1.62,0.81,0.31,-1.44,-1.25,-0.41,-1.56,-4.34,-6.28,-6.62,-7.97,-10.19,-11.47,-9.75,-8.16,-8.62,-9.31,-8.16,-7.16,-8.22,-10.12,-9.59,-7.84,-7.19,-8.0,-8.41,-6.97,-6.78,-8.69,-9.69,-8.44,-7.44,-8.38,-9.66,-8.72,-6.91,-6.69,-7.69,-6.47,-4.47,-3.66,-4.97,-5.31,-3.72,-3.44,-5.03,-6.66,-6.34,-5.81,-7.56,-9.34,-8.62,-7.59,-8.25,-10.62,-11.34,-11.0,-11.81,-13.59,-13.75,-11.69,-9.38,-8.25,-6.56,-1.94,2.44,4.41,5.19,7.09,9.53,9.38,7.53,7.0,6.66,4.94,1.0,-2.31,-3.47,-4.91,-8.09,-10.94,-11.22,-11.28,-13.38,-16.06,-16.5,-15.66,-16.19,-17.44,-16.69,-14.66,-13.12,-13.28,-12.59,-9.25,-6.31,-5.56,-5.03,-2.44,-0.41,-0.97,-3.09,-3.28,-3.0,-3.75,-5.12,-4.75,-2.47,-0.72,-0.69,-0.75,1.03,1.84,0.03,-2.84,-3.69,-4.0,-6.06,-8.5,-8.75,-7.34,-7.19,-7.84,-6.62,-3.72,-1.41,-0.84,0.03,2.62,4.59,4.16,2.19,2.0,1.84,-0.66,-4.34,-6.31,-6.72,-7.91,-9.88,-9.94,-7.94,-6.25,-7.19,-7.56,-5.62,-3.66,-3.31,-3.97,-2.06,0.5,0.97,0.28,1.25,3.28,3.88,2.25,1.44,2.53,3.12,1.66,0.88,2.06,3.41,2.75,1.59,2.38,4.0,3.91,2.22,1.78,2.59,2.12,-0.53,-2.62,-2.88,-4.03,-7.78,-10.84,-11.66,-11.56,-12.97,-14.31,-12.75,-10.34,-9.41,-9.94,-8.81,-6.56,-5.47,-6.06,-6.12,-4.38,-3.38,-4.97,-6.59,-6.03,-5.44,-7.06,-9.34,-9.81,-9.5,-11.16,-13.97,-15.38,-14.78,-14.25,-15.19,-14.34,-10.94,-8.22,-7.78,-8.06,-6.78,-5.31,-5.97,-7.22,-5.84,-3.41,-2.38,-3.12,-2.94,-1.44,-1.03,-2.88,-3.44,-1.62,0.22,-0.59,-1.75,-1.44,-1.56,-3.34,-6.62,-7.47,-6.75,-7.25,-8.94,-9.22,-8.28,-7.97,-9.44,-10.28,-8.41,-5.94,-5.38,-5.12,-3.12,-0.81,-0.91,-2.53,-2.19,-0.62,-0.28,-1.75,-1.97,-0.75,-0.56,-2.78,-3.94,-2.78,-1.06,-1.56,-2.81,-2.41,-1.72,-3.16,-5.62,-5.81,-4.78,-4.38,-5.72,-5.62,-3.06,-0.56,-0.03,1.09,4.25,7.28,7.59,6.75,7.47,8.47,6.91,3.84,2.28,2.12,1.03,-1.97,-3.84,-3.47,-3.34,-5.0,-6.12,-4.09,-1.97,-2.22,-3.0,-2.25,-0.72,-1.09,-2.72,-3.03,-2.16,-2.06,-3.47,-4.03,-2.53,-1.25,-3.09,-5.06,-5.44,-5.06,-6.22,-7.44,-6.56,-4.03,-2.91,-3.34,-2.28,0.56,2.78,3.03,4.25,6.94,8.88,7.69,5.81,5.44,6.12,4.34,2.12,1.84,3.09,2.59,0.53,0.44,2.31,3.91,3.47,3.34,4.78,5.31,2.66,-0.38,-0.41,0.81,0.66,0.38,2.0,5.12,5.97,4.84,4.47,5.31,5.25,3.0,2.0,3.75,5.94,5.69,5.34,6.69,8.44,7.69,5.53,5.16,6.34,6.22,4.59,4.22,5.56,6.41,4.72,3.75,5.09,6.25,5.06,3.59,3.84,5.38,4.84,3.56,4.19,6.41,7.75,7.41,7.97,10.31,11.66,10.19,8.88,9.41,10.09,8.06,5.41,4.88,5.81,4.88,2.94,2.62,4.0,3.66,1.84,1.69,3.97,6.44,6.38,6.31,8.25,9.88,8.19,5.69,4.59,4.09,2.19,-0.38,-0.94,0.69,1.41,0.12,-0.03,1.66,3.06,2.16,1.38,2.22,3.25,1.16,-1.66,-2.44,-1.41,-2.25,-3.94,-3.44,-1.44,-0.75,-1.94,-2.22,-0.19,1.75,1.28,1.12,2.78,4.78,3.81,1.75,1.12,1.91,1.19,-0.56,-0.25,1.75,2.47,1.0,-0.25,0.47,0.47,-1.94,-4.56,-5.19,-5.06,-6.72,-9.0,-9.31,-7.59,-7.38,-8.12,-7.12,-3.81,-1.59,-1.69,-1.22,1.78,-15.75,-14.44,-14.25,-15.03,-14.34,-12.12,-10.59:2.62,0.31,-3.47,-5.09,-5.06,-6.34,-8.97,-10.19,-9.44,-8.59,-9.44,-9.94,-8.03,-5.81,-6.03,-6.81,-5.69,-3.44,-3.19,-4.31,-4.59,-3.56,-3.94,-6.25,-7.66,-6.59,-5.94,-7.09,-8.06,-6.72,-5.28,-6.34,-8.34,-8.72,-8.03,-8.88,-10.97,-11.44,-9.28,-8.0,-8.31,-7.81,-5.28,-3.69,-4.16,-4.72,-3.19,-1.41,-1.41,-2.66,-2.41,-0.72,-0.66,-2.28,-2.94,-1.91,-2.38,-5.84,-9.0,-9.41,-9.75,-11.25,-11.91,-9.72,-6.47,-4.94,-4.78,-2.78,0.44,1.5,0.75,0.59,2.25,2.97,1.28,0.06,1.22,2.44,1.59,0.5,1.53,2.91,2.31,-0.03,-0.94,-0.59,-1.94,-5.03,-7.22,-6.56,-6.5,-8.41,-10.09,-9.19,-8.53,-9.94,-11.72,-10.56,-8.72,-7.94,-8.38,-7.53,-5.12,-4.5,-6.44,-7.78,-7.28,-7.47,-9.72,-11.47,-10.84,-9.72,-9.88,-10.59,-8.84,-6.22,-5.03,-5.75,-5.25,-3.84,-4.41,-7.31,-9.72,-10.31,-10.75,-12.47,-13.28,-11.0,-7.53,-5.53,-4.81,-2.03,0.91,2.19,1.44,1.47,2.84,2.81,1.0,-0.75,0.31,1.38,0.22,-1.41,-1.31,-1.16,-2.94,-5.78,-6.56,-6.03,-6.38,-8.72,-9.41,-8.56,-8.19,-10.09,-11.25,-9.88,-8.12,-8.38,-8.47,-6.66,-3.75,-2.66,-2.75,-0.94,1.5,2.5,1.06,-0.56,-1.31,-3.72,-9.0,-14.47,-17.16,-19.19,-21.84,-24.03,-23.12,-20.66,-19.59,-19.44,-18.03,-15.38,-13.56,-13.5,-12.78,-10.62,-9.41,-10.44,-11.59,-10.81,-9.44,-9.56,-10.47,-9.59,-7.91,-7.38,-8.03,-7.81,-5.75,-4.84,-5.66,-4.91,-1.53,2.28,4.28,6.12,9.38,11.72,10.75,7.94,6.28,5.09,2.78,-0.88,-2.53,-2.19,-2.28,-4.12,-4.88,-3.06,-1.38,-1.62,-2.12,-0.62,1.22,0.91,-0.84,-1.25,-0.69,-2.19,-4.94,-6.0,-5.0,-4.44,-5.88,-6.25,-4.5,-2.06,-1.44,-0.28,3.0,6.28,6.91,5.75,4.69,4.56,2.75,-0.38,-2.16,-1.59,-0.91,-2.56,-3.25,-2.03,-0.66,-1.12,-1.97,-0.62,1.53,2.0,1.78,2.66,4.53,4.69,2.66,0.47,0.0,-1.09,-3.94,-6.16,-5.75,-4.16,-5.06,-6.31,-5.47,-3.84,-4.06,-4.56,-3.38,-0.59,0.81,0.03,-0.72,-0.03,-0.28,-2.81,-5.25,-5.25,-4.06,-5.03,-6.22,-5.59,-4.66,-5.41,-7.56,-8.28,-6.31,-4.25,-3.66,-1.62,2.28,5.5,5.53,4.81,5.22,5.53,3.91,1.38,0.81,0.97,-0.53,-3.5,-5.19,-5.12,-5.59,-7.5,-8.47,-7.22,-5.62,-5.97,-6.59,-5.25,-3.5,-4.0,-5.47,-5.12,-3.5,-3.0,-3.97,-4.16,-2.66,-2.03,-4.19,-6.06,-6.06,-6.09,-8.28,-10.66,-10.34,-9.16,-9.22,-10.16,-10.06,-9.0,-9.34,-11.5,-11.31,-8.47,-5.47,-4.28,-2.84,-0.12,2.66,2.53,1.94,3.03,4.38,2.94,-0.41,-3.03,-4.84,-7.59,-11.19,-13.19,-12.06,-10.34,-10.59,-10.69,-8.47,-5.81,-5.53,-5.91,-4.69,-2.16,-1.53,-1.34,0.28,3.59,5.22,4.47,4.03,5.31,6.41,6.31,6.5,8.94,11.69,11.53,9.94,9.09,8.91,6.91,3.66,1.19,0.78,-0.59,-4.06,-6.62,-6.69,-6.12,-7.09,-7.12,-4.41,-0.41,1.72,2.56,4.28,6.56,6.5,4.53,3.41,4.28,4.56,2.72,1.41,2.19,2.62,0.28,-3.16,-5.22,-6.72,-10.25,-14.16,-15.47,-14.69,-14.72,-15.38,-14.91,-12.19,-9.88,-9.53,-7.69,-3.88,-0.34,1.06,1.88,4.09,6.31,6.06,4.19,3.06,2.91,0.91,-2.81,-5.44,-5.81,-6.53,-8.28,-9.06,-7.47,-5.84,-6.66,-7.97,-7.91,-6.56,-6.69,-7.5,-6.72,-4.5,-3.62,-4.53,-4.84,-3.22,-2.0,-2.75,-3.84,-3.31,-2.62,-3.91,-5.16,-4.28,-1.66,-0.75,-1.06,-0.31,1.41,1.75,-0.44,-2.47,-2.75,-3.62,-6.06,-8.12,-7.88,-6.91,-8.16,-10.0,-10.22,-9.59,-10.47,-12.47,-13.41,-12.53,-12.19,-13.34,-13.34,-10.75,-8.44,-8.28,-8.91,-8.16,-7.28,-8.66,-10.16,-9.88,-8.38,-8.09,-9.19,-9.25,-7.59,-6.94,-8.25,-9.69,-9.22,-8.91,-10.59,-12.81,-13.06,-12.44,-14.03,-15.84,-15.53,-13.41,-11.94,-11.59,-10.19,-6.59,-3.66,-2.66,-2.03,0.31,1.88,0.31,-2.66,-4.22,-5.06,-7.0,-9.12,-8.94,-6.56,-5.09,-5.44,-5.62,-3.88,-3.66,-5.91,-8.03,-8.09,-7.19,-8.12,-8.84,-7.66,-5.62,-6.09,-8.03,-9.09,-8.72,-9.06,-10.31,-10.66,-8.41,-6.56,-6.75,-7.0,-4.97,-2.56,-2.09,-2.09,-0.22,2.31,3.19,2.5,2.75,4.28,4.72,3.06,1.94,2.91,2.75,0.38,-2.88,-4.53,-6.38,-10.66,-15.25,-17.22,-16.56,-16.28,-15.88,-14.0,-10.25,-7.31,-6.62,-5.84,-2.97,-0.84,-1.22,-2.09,-1.22,-0.38,-1.56,-3.88,-4.78,-4.5,-4.97,-6.75,-7.34,-5.62,-4.72,-6.16,-7.34,-6.69,-6.19,-7.81,-9.56,-9.06,-7.59,-7.47,-8.69,-8.56,-7.34,-7.5,-9.47,-10.78,-10.47,-10.88,-13.03,-14.69,-13.75,-12.34,-12.88,-13.72,-12.31,-10.0,-9.44,-9.47,-8.41,-5.69,-4.41,-4.97,-5.5,-4.25,-3.84,-5.81,-8.19,-8.12,-8.0,-9.66,-11.69,-11.38,-10.16,-10.94,-12.88,-13.53,-12.72,-12.5,-13.41,-12.88,-10.0,-6.75,-5.28,-4.19,-1.62,0.81,0.31,-1.44,-1.25,-0.41,-1.56,-4.34,-6.28,-6.62,-7.97,-10.19,-11.47,-9.75,-8.16,-8.62,-9.31,-8.16,-7.16,-8.22,-10.12,-9.59,-7.84,-7.19,-8.0,-8.41,-6.97,-6.78,-8.69,-9.69,-8.44,-7.44,-8.38,-9.66,-8.72,-6.91,-6.69,-7.69,-6.47,-4.47,-3.66,-4.97,-5.31,-3.72,-3.44,-5.03,-6.66,-6.34,-5.81,-7.56,-9.34,-8.62,-7.59,-8.25,-10.62,-11.34,-11.0,-11.81,-13.59,-13.75,-11.69,-9.38,-8.25,-6.56,-1.94,2.44,4.41,5.19,7.09,9.53,9.38,7.53,7.0,6.66,4.94,1.0,-2.31,-3.47,-4.91,-8.09,-10.94,-11.22,-11.28,-13.38,-16.06,-16.5,-15.66,-16.19,-17.44,-16.69,-14.66,-13.12,-13.28,-12.59,-9.25,-6.31,-5.56,-5.03,-2.44,-0.41,-0.97,-3.09,-3.28,-3.0,-3.75,-5.12,-4.75,-2.47,-0.72,-0.69,-0.75,1.03,1.84,0.03,-2.84,-3.69,-4.0,-6.06,-8.5,-8.75,-7.34,-7.19,-7.84,-6.62,-3.72,-1.41,-0.84,0.03,2.62,4.59,4.16,2.19,2.0,1.84,-0.66,-4.34,-6.31,-6.72,-7.91,-9.88,-9.94,-7.94,-6.25,-7.19,-7.56,-5.62,-3.66,-3.31,-3.97,-2.06,0.5,0.97,0.28,1.25,3.28,3.88,2.25,1.44,2.53,3.12,1.66,0.88,2.06,3.41,2.75,1.59,2.38,4.0,3.91,2.22,1.78,2.59,2.12,-0.53,-2.62,-2.88,-4.03,-7.78,-10.84,-11.66,-11.56,-12.97,-14.31,-12.75,-10.34,-9.41,-9.94,-8.81,-6.56,-5.47,-6.06,-6.12,-4.38,-3.38,-4.97,-6.59,-6.03,-5.44,-7.06,-9.34,-9.81,-9.5,-11.16,-13.97,-15.38,-14.78,-14.25,-15.19,-14.34,-10.94,-8.22,-7.78,-8.06,-6.78,-5.31,-5.97,-7.22,-5.84,-3.41,-2.38,-3.12,-2.94,-1.44,-1.03,-2.88,-3.44,-1.62,0.22,-0.59,-1.75,-1.44,-1.56,-3.34,-6.62,-7.47,-6.75,-7.25,-8.94,-9.22,-8.28,-7.97,-9.44,-10.28,-8.41,-5.94,-5.38,-5.12,-3.12,-0.81,-0.91,-2.53,-2.19,-0.62,-0.28,-1.75,-1.97,-0.75,-0.56,-2.78,-3.94,-2.78,-1.06,-1.56,-2.81,-2.41,-1.72,-3.16,-5.62,-5.81,-4.78,-4.38,-5.72,-5.62,-3.06,-0.56,-0.03,1.09,4.25,7.28,7.59,6.75,7.47,8.47,6.91,3.84,2.28,2.12,1.03,-1.97,-3.84,-3.47,-3.34,-5.0,-6.12,-4.09,-1.97,-2.22,-3.0,-2.25,-0.72,-1.09,-2.72,-3.03,-2.16,-2.06,-3.47,-4.03,-2.53,-1.25,-3.09,-5.06,-5.44,-5.06,-6.22,-7.44,-6.56,-4.03,-2.91,-3.34,-2.28,0.56,2.78,3.03,4.25,6.94,8.88,7.69,5.81,5.44,6.12,4.34,2.12,1.84,3.09,2.59,0.53,0.44,2.31,3.91,3.47,3.34,4.78,5.31,2.66,-0.38,-0.41,0.81,0.66,0.38,2.0,5.12,5.97,4.84,4.47,5.31,5.25,3.0,2.0,3.75,5.94,5.69,5.34,6.69,8.44,7.69,5.53,5.16,6.34,6.22,4.59,4.22,5.56,6.41,4.72,3.75,5.09,6.25,5.06,3.59,3.84,5.38,4.84,3.56,4.19,6.41,7.75,7.41,7.97,10.31,11.66,10.19,8.88,9.41,10.09,8.06,5.41,4.88,5.81,4.88,2.94,2.62,4.0,3.66,1.84,1.69,3.97,6.44,6.38,6.31,8.25,9.88,8.19,5.69,4.59,4.09,2.19,-0.38,-0.94,0.69,1.41,0.12,-0.03,1.66,3.06,2.16,1.38,2.22,3.25,1.16,-1.66,-2.44,-1.41,-2.25,-3.94,-3.44,-1.44,-0.75,-1.94,-2.22,-0.19,1.75,1.28,1.12,2.78,4.78,3.81,1.75,1.12,1.91,1.19,-0.56,-0.25,1.75,2.47,1.0,-0.25,0.47,0.47,-1.94,-4.56,-5.19,-5.06,-6.72,-9.0,-9.31,-7.59,-7.38,-8.12,-7.12,-3.81,-1.59,-1.69,-1.22,1.78,-15.75,-14.44,-14.25,-15.03,-14.34,-12.12,-10.59,-9.34,-8.31,-6.25,-5.16,-6.28,-8.03,-8.97:-10.19,-9.44,-8.59,-9.44,-9.94,-8.03,-5.81,-6.03,-6.81,-5.69,-3.44,-3.19,-4.31,-4.59,-3.56,-3.94,-6.25,-7.66,-6.59,-5.94,-7.09,-8.06,-6.72,-5.28,-6.34,-8.34,-8.72,-8.03,-8.88,-10.97,-11.44,-9.28,-8.0,-8.31,-7.81,-5.28,-3.69,-4.16,-4.72,-3.19,-1.41,-1.41,-2.66,-2.41,-0.72,-0.66,-2.28,-2.94,-1.91,-2.38,-5.84,-9.0,-9.41,-9.75,-11.25,-11.91,-9.72,-6.47,-4.94,-4.78,-2.78,0.44,1.5,0.75,0.59,2.25,2.97,1.28,0.06,1.22,2.44,1.59,0.5,1.53,2.91,2.31,-0.03,-0.94,-0.59,-1.94,-5.03,-7.22,-6.56,-6.5,-8.41,-10.09,-9.19,-8.53,-9.94,-11.72,-10.56,-8.72,-7.94,-8.38,-7.53,-5.12,-4.5,-6.44,-7.78,-7.28,-7.47,-9.72,-11.47,-10.84,-9.72,-9.88,-10.59,-8.84,-6.22,-5.03,-5.75,-5.25,-3.84,-4.41,-7.31,-9.72,-10.31,-10.75,-12.47,-13.28,-11.0,-7.53,-5.53,-4.81,-2.03,0.91,2.19,1.44,1.47,2.84,2.81,1.0,-0.75,0.31,1.38,0.22,-1.41,-1.31,-1.16,-2.94,-5.78,-6.56,-6.03,-6.38,-8.72,-9.41,-8.56,-8.19,-10.09,-11.25,-9.88,-8.12,-8.38,-8.47,-6.66,-3.75,-2.66,-2.75,-0.94,1.5,2.5,1.06,-0.56,-1.31,-3.72,-9.0,-14.47,-17.16,-19.19,-21.84,-24.03,-23.12,-20.66,-19.59,-19.44,-18.03,-15.38,-13.56,-13.5,-12.78,-10.62,-9.41,-10.44,-11.59,-10.81,-9.44,-9.56,-10.47,-9.59,-7.91,-7.38,-8.03,-7.81,-5.75,-4.84,-5.66,-4.91,-1.53,2.28,4.28,6.12,9.38,11.72,10.75,7.94,6.28,5.09,2.78,-0.88,-2.53,-2.19,-2.28,-4.12,-4.88,-3.06,-1.38,-1.62,-2.12,-0.62,1.22,0.91,-0.84,-1.25,-0.69,-2.19,-4.94,-6.0,-5.0,-4.44,-5.88,-6.25,-4.5,-2.06,-1.44,-0.28,3.0,6.28,6.91,5.75,4.69,4.56,2.75,-0.38,-2.16,-1.59,-0.91,-2.56,-3.25,-2.03,-0.66,-1.12,-1.97,-0.62,1.53,2.0,1.78,2.66,4.53,4.69,2.66,0.47,0.0,-1.09,-3.94,-6.16,-5.75,-4.16,-5.06,-6.31,-5.47,-3.84,-4.06,-4.56,-3.38,-0.59,0.81,0.03,-0.72,-0.03,-0.28,-2.81,-5.25,-5.25,-4.06,-5.03,-6.22,-5.59,-4.66,-5.41,-7.56,-8.28,-6.31,-4.25,-3.66,-1.62,2.28,5.5,5.53,4.81,5.22,5.53,3.91,1.38,0.81,0.97,-0.53,-3.5,-5.19,-5.12,-5.59,-7.5,-8.47,-7.22,-5.62,-5.97,-6.59,-5.25,-3.5,-4.0,-5.47,-5.12,-3.5,-3.0,-3.97,-4.16,-2.66,-2.03,-4.19,-6.06,-6.06,-6.09,-8.28,-10.66,-10.34,-9.16,-9.22,-10.16,-10.06,-9.0,-9.34,-11.5,-11.31,-8.47,-5.47,-4.28,-2.84,-0.12,2.66,2.53,1.94,3.03,4.38,2.94,-0.41,-3.03,-4.84,-7.59,-11.19,-13.19,-12.06,-10.34,-10.59,-10.69,-8.47,-5.81,-5.53,-5.91,-4.69,-2.16,-1.53,-1.34,0.28,3.59,5.22,4.47,4.03,5.31,6.41,6.31,6.5,8.94,11.69,11.53,9.94,9.09,8.91,6.91,3.66,1.19,0.78,-0.59,-4.06,-6.62,-6.69,-6.12,-7.09,-7.12,-4.41,-0.41,1.72,2.56,4.28,6.56,6.5,4.53,3.41,4.28,4.56,2.72,1.41,2.19,2.62,0.28,-3.16,-5.22,-6.72,-10.25,-14.16,-15.47,-14.69,-14.72,-15.38,-14.91,-12.19,-9.88,-9.53,-7.69,-3.88,-0.34,1.06,1.88,4.09,6.31,6.06,4.19,3.06,2.91,0.91,-2.81,-5.44,-5.81,-6.53,-8.28,-9.06,-7.47,-5.84,-6.66,-7.97,-7.91,-6.56,-6.69,-7.5,-6.72,-4.5,-3.62,-4.53,-4.84,-3.22,-2.0,-2.75,-3.84,-3.31,-2.62,-3.91,-5.16,-4.28,-1.66,-0.75,-1.06,-0.31,1.41,1.75,-0.44,-2.47,-2.75,-3.62,-6.06,-8.12,-7.88,-6.91,-8.16,-10.0,-10.22,-9.59,-10.47,-12.47,-13.41,-12.53,-12.19,-13.34,-13.34,-10.75,-8.44,-8.28,-8.91,-8.16,-7.28,-8.66,-10.16,-9.88,-8.38,-8.09,-9.19,-9.25,-7.59,-6.94,-8.25,-9.69,-9.22,-8.91,-10.59,-12.81,-13.06,-12.44,-14.03,-15.84,-15.53,-13.41,-11.94,-11.59,-10.19,-6.59,-3.66,-2.66,-2.03,0.31,1.88,0.31,-2.66,-4.22,-5.06,-7.0,-9.12,-8.94,-6.56,-5.09,-5.44,-5.62,-3.88,-3.66,-5.91,-8.03,-8.09,-7.19,-8.12,-8.84,-7.66,-5.62,-6.09,-8.03,-9.09,-8.72,-9.06,-10.31,-10.66,-8.41,-6.56,-6.75,-7.0,-4.97,-2.56,-2.09,-2.09,-0.22,2.31,3.19,2.5,2.75,4.28,4.72,3.06,1.94,2.91,2.75,0.38,-2.88,-4.53,-6.38,-10.66,-15.25,-17.22,-16.56,-16.28,-15.88,-14.0,-10.25,-7.31,-6.62,-5.84,-2.97,-0.84,-1.22,-2.09,-1.22,-0.38,-1.56,-3.88,-4.78,-4.5,-4.97,-6.75,-7.34,-5.62,-4.72,-6.16,-7.34,-6.69,-6.19,-7.81,-9.56,-9.06,-7.59,-7.47,-8.69,-8.56,-7.34,-7.5,-9.47,-10.78,-10.47,-10.88,-13.03,-14.69,-13.75,-12.34,-12.88,-13.72,-12.31,-10.0,-9.44,-9.47,-8.41,-5.69,-4.41,-4.97,-5.5,-4.25,-3.84,-5.81,-8.19,-8.12,-8.0,-9.66,-11.69,-11.38,-10.16,-10.94,-12.88,-13.53,-12.72,-12.5,-13.41,-12.88,-10.0,-6.75,-5.28,-4.19,-1.62,0.81,0.31,-1.44,-1.25,-0.41,-1.56,-4.34,-6.28,-6.62,-7.97,-10.19,-11.47,-9.75,-8.16,-8.62,-9.31,-8.16,-7.16,-8.22,-10.12,-9.59,-7.84,-7.19,-8.0,-8.41,-6.97,-6.78,-8.69,-9.69,-8.44,-7.44,-8.38,-9.66,-8.72,-6.91,-6.69,-7.69,-6.47,-4.47,-3.66,-4.97,-5.31,-3.72,-3.44,-5.03,-6.66,-6.34,-5.81,-7.56,-9.34,-8.62,-7.59,-8.25,-10.62,-11.34,-11.0,-11.81,-13.59,-13.75,-11.69,-9.38,-8.25,-6.56,-1.94,2.44,4.41,5.19,7.09,9.53,9.38,7.53,7.0,6.66,4.94,1.0,-2.31,-3.47,-4.91,-8.09,-10.94,-11.22,-11.28,-13.38,-16.06,-16.5,-15.66,-16.19,-17.44,-16.69,-14.66,-13.12,-13.28,-12.59,-9.25,-6.31,-5.56,-5.03,-2.44,-0.41,-0.97,-3.09,-3.28,-3.0,-3.75,-5.12,-4.75,-2.47,-0.72,-0.69,-0.75,1.03,1.84,0.03,-2.84,-3.69,-4.0,-6.06,-8.5,-8.75,-7.34,-7.19,-7.84,-6.62,-3.72,-1.41,-0.84,0.03,2.62,4.59,4.16,2.19,2.0,1.84,-0.66,-4.34,-6.31,-6.72,-7.91,-9.88,-9.94,-7.94,-6.25,-7.19,-7.56,-5.62,-3.66,-3.31,-3.97,-2.06,0.5,0.97,0.28,1.25,3.28,3.88,2.25,1.44,2.53,3.12,1.66,0.88,2.06,3.41,2.75,1.59,2.38,4.0,3.91,2.22,1.78,2.59,2.12,-0.53,-2.62,-2.88,-4.03,-7.78,-10.84,-11.66,-11.56,-12.97,-14.31,-12.75,-10.34,-9.41,-9.94,-8.81,-6.56,-5.47,-6.06,-6.12,-4.38,-3.38,-4.97,-6.59,-6.03,-5.44,-7.06,-9.34,-9.81,-9.5,-11.16,-13.97,-15.38,-14.78,-14.25,-15.19,-14.34,-10.94,-8.22,-7.78,-8.06,-6.78,-5.31,-5.97,-7.22,-5.84,-3.41,-2.38,-3.12,-2.94,-1.44,-1.03,-2.88,-3.44,-1.62,0.22,-0.59,-1.75,-1.44,-1.56,-3.34,-6.62,-7.47,-6.75,-7.25,-8.94,-9.22,-8.28,-7.97,-9.44,-10.28,-8.41,-5.94,-5.38,-5.12,-3.12,-0.81,-0.91,-2.53,-2.19,-0.62,-0.28,-1.75,-1.97,-0.75,-0.56,-2.78,-3.94,-2.78,-1.06,-1.56,-2.81,-2.41,-1.72,-3.16,-5.62,-5.81,-4.78,-4.38,-5.72,-5.62,-3.06,-0.56,-0.03,1.09,4.25,7.28,7.59,6.75,7.47,8.47,6.91,3.84,2.28,2.12,1.03,-1.97,-3.84,-3.47,-3.34,-5.0,-6.12,-4.09,-1.97,-2.22,-3.0,-2.25,-0.72,-1.09,-2.72,-3.03,-2.16,-2.06,-3.47,-4.03,-2.53,-1.25,-3.09,-5.06,-5.44,-5.06,-6.22,-7.44,-6.56,-4.03,-2.91,-3.34,-2.28,0.56,2.78,3.03,4.25,6.94,8.88,7.69,5.81,5.44,6.12,4.34,2.12,1.84,3.09,2.59,0.53,0.44,2.31,3.91,3.47,3.34,4.78,5.31,2.66,-0.38,-0.41,0.81,0.66,0.38,2.0,5.12,5.97,4.84,4.47,5.31,5.25,3.0,2.0,3.75,5.94,5.69,5.34,6.69,8.44,7.69,5.53,5.16,6.34,6.22,4.59,4.22,5.56,6.41,4.72,3.75,5.09,6.25,5.06,3.59,3.84,5.38,4.84,3.56,4.19,6.41,7.75,7.41,7.97,10.31,11.66,10.19,8.88,9.41,10.09,8.06,5.41,4.88,5.81,4.88,2.94,2.62,4.0,3.66,1.84,1.69,3.97,6.44,6.38,6.31,8.25,9.88,8.19,5.69,4.59,4.09,2.19,-0.38,-0.94,0.69,1.41,0.12,-0.03,1.66,3.06,2.16,1.38,2.22,3.25,1.16,-1.66,-2.44,-1.41,-2.25,-3.94,-3.44,-1.44,-0.75,-1.94,-2.22,-0.19,1.75,1.28,1.12,2.78,4.78,3.81,1.75,1.12,1.91,1.19,-0.56,-0.25,1.75,2.47,1.0,-0.25,0.47,0.47,-1.94,-4.56,-5.19,-5.06,-6.72,-9.0,-9.31,-7.59,-7.38,-8.12,-7.12,-3.81,-1.59,-1.69,-1.22,1.78,-15.75,-14.44,-14.25,-15.03,-14.34,-12.12,-10.59,-9.34,-8.31,-6.25,-5.16,-6.28,-8.03,-8.97,-10.03,-12.0,-14.38,-15.31,-15.41,-16.56,-18.56:-6.03,-6.81,-5.69,-3.44,-3.19,-4.31,-4.59,-3.56,-3.94,-6.25,-7.66,-6.59,-5.94,-7.09,-8.06,-6.72,-5.28,-6.34,-8.34,-8.72,-8.03,-8.88,-10.97,-11.44,-9.28,-8.0,-8.31,-7.81,-5.28,-3.69,-4.16,-4.72,-3.19,-1.41,-1.41,-2.66,-2.41,-0.72,-0.66,-2.28,-2.94,-1.91,-2.38,-5.84,-9.0,-9.41,-9.75,-11.25,-11.91,-9.72,-6.47,-4.94,-4.78,-2.78,0.44,1.5,0.75,0.59,2.25,2.97,1.28,0.06,1.22,2.44,1.59,0.5,1.53,2.91,2.31,-0.03,-0.94,-0.59,-1.94,-5.03,-7.22,-6.56,-6.5,-8.41,-10.09,-9.19,-8.53,-9.94,-11.72,-10.56,-8.72,-7.94,-8.38,-7.53,-5.12,-4.5,-6.44,-7.78,-7.28,-7.47,-9.72,-11.47,-10.84,-9.72,-9.88,-10.59,-8.84,-6.22,-5.03,-5.75,-5.25,-3.84,-4.41,-7.31,-9.72,-10.31,-10.75,-12.47,-13.28,-11.0,-7.53,-5.53,-4.81,-2.03,0.91,2.19,1.44,1.47,2.84,2.81,1.0,-0.75,0.31,1.38,0.22,-1.41,-1.31,-1.16,-2.94,-5.78,-6.56,-6.03,-6.38,-8.72,-9.41,-8.56,-8.19,-10.09,-11.25,-9.88,-8.12,-8.38,-8.47,-6.66,-3.75,-2.66,-2.75,-0.94,1.5,2.5,1.06,-0.56,-1.31,-3.72,-9.0,-14.47,-17.16,-19.19,-21.84,-24.03,-23.12,-20.66,-19.59,-19.44,-18.03,-15.38,-13.56,-13.5,-12.78,-10.62,-9.41,-10.44,-11.59,-10.81,-9.44,-9.56,-10.47,-9.59,-7.91,-7.38,-8.03,-7.81,-5.75,-4.84,-5.66,-4.91,-1.53,2.28,4.28,6.12,9.38,11.72,10.75,7.94,6.28,5.09,2.78,-0.88,-2.53,-2.19,-2.28,-4.12,-4.88,-3.06,-1.38,-1.62,-2.12,-0.62,1.22,0.91,-0.84,-1.25,-0.69,-2.19,-4.94,-6.0,-5.0,-4.44,-5.88,-6.25,-4.5,-2.06,-1.44,-0.28,3.0,6.28,6.91,5.75,4.69,4.56,2.75,-0.38,-2.16,-1.59,-0.91,-2.56,-3.25,-2.03,-0.66,-1.12,-1.97,-0.62,1.53,2.0,1.78,2.66,4.53,4.69,2.66,0.47,0.0,-1.09,-3.94,-6.16,-5.75,-4.16,-5.06,-6.31,-5.47,-3.84,-4.06,-4.56,-3.38,-0.59,0.81,0.03,-0.72,-0.03,-0.28,-2.81,-5.25,-5.25,-4.06,-5.03,-6.22,-5.59,-4.66,-5.41,-7.56,-8.28,-6.31,-4.25,-3.66,-1.62,2.28,5.5,5.53,4.81,5.22,5.53,3.91,1.38,0.81,0.97,-0.53,-3.5,-5.19,-5.12,-5.59,-7.5,-8.47,-7.22,-5.62,-5.97,-6.59,-5.25,-3.5,-4.0,-5.47,-5.12,-3.5,-3.0,-3.97,-4.16,-2.66,-2.03,-4.19,-6.06,-6.06,-6.09,-8.28,-10.66,-10.34,-9.16,-9.22,-10.16,-10.06,-9.0,-9.34,-11.5,-11.31,-8.47,-5.47,-4.28,-2.84,-0.12,2.66,2.53,1.94,3.03,4.38,2.94,-0.41,-3.03,-4.84,-7.59,-11.19,-13.19,-12.06,-10.34,-10.59,-10.69,-8.47,-5.81,-5.53,-5.91,-4.69,-2.16,-1.53,-1.34,0.28,3.59,5.22,4.47,4.03,5.31,6.41,6.31,6.5,8.94,11.69,11.53,9.94,9.09,8.91,6.91,3.66,1.19,0.78,-0.59,-4.06,-6.62,-6.69,-6.12,-7.09,-7.12,-4.41,-0.41,1.72,2.56,4.28,6.56,6.5,4.53,3.41,4.28,4.56,2.72,1.41,2.19,2.62,0.28,-3.16,-5.22,-6.72,-10.25,-14.16,-15.47,-14.69,-14.72,-15.38,-14.91,-12.19,-9.88,-9.53,-7.69,-3.88,-0.34,1.06,1.88,4.09,6.31,6.06,4.19,3.06,2.91,0.91,-2.81,-5.44,-5.81,-6.53,-8.28,-9.06,-7.47,-5.84,-6.66,-7.97,-7.91,-6.56,-6.69,-7.5,-6.72,-4.5,-3.62,-4.53,-4.84,-3.22,-2.0,-2.75,-3.84,-3.31,-2.62,-3.91,-5.16,-4.28,-1.66,-0.75,-1.06,-0.31,1.41,1.75,-0.44,-2.47,-2.75,-3.62,-6.06,-8.12,-7.88,-6.91,-8.16,-10.0,-10.22,-9.59,-10.47,-12.47,-13.41,-12.53,-12.19,-13.34,-13.34,-10.75,-8.44,-8.28,-8.91,-8.16,-7.28,-8.66,-10.16,-9.88,-8.38,-8.09,-9.19,-9.25,-7.59,-6.94,-8.25,-9.69,-9.22,-8.91,-10.59,-12.81,-13.06,-12.44,-14.03,-15.84,-15.53,-13.41,-11.94,-11.59,-10.19,-6.59,-3.66,-2.66,-2.03,0.31,1.88,0.31,-2.66,-4.22,-5.06,-7.0,-9.12,-8.94,-6.56,-5.09,-5.44,-5.62,-3.88,-3.66,-5.91,-8.03,-8.09,-7.19,-8.12,-8.84,-7.66,-5.62,-6.09,-8.03,-9.09,-8.72,-9.06,-10.31,-10.66,-8.41,-6.56,-6.75,-7.0,-4.97,-2.56,-2.09,-2.09,-0.22,2.31,3.19,2.5,2.75,4.28,4.72,3.06,1.94,2.91,2.75,0.38,-2.88,-4.53,-6.38,-10.66,-15.25,-17.22,-16.56,-16.28,-15.88,-14.0,-10.25,-7.31,-6.62,-5.84,-2.97,-0.84,-1.22,-2.09,-1.22,-0.38,-1.56,-3.88,-4.78,-4.5,-4.97,-6.75,-7.34,-5.62,-4.72,-6.16,-7.34,-6.69,-6.19,-7.81,-9.56,-9.06,-7.59,-7.47,-8.69,-8.56,-7.34,-7.5,-9.47,-10.78,-10.47,-10.88,-13.03,-14.69,-13.75,-12.34,-12.88,-13.72,-12.31,-10.0,-9.44,-9.47,-8.41,-5.69,-4.41,-4.97,-5.5,-4.25,-3.84,-5.81,-8.19,-8.12,-8.0,-9.66,-11.69,-11.38,-10.16,-10.94,-12.88,-13.53,-12.72,-12.5,-13.41,-12.88,-10.0,-6.75,-5.28,-4.19,-1.62,0.81,0.31,-1.44,-1.25,-0.41,-1.56,-4.34,-6.28,-6.62,-7.97,-10.19,-11.47,-9.75,-8.16,-8.62,-9.31,-8.16,-7.16,-8.22,-10.12,-9.59,-7.84,-7.19,-8.0,-8.41,-6.97,-6.78,-8.69,-9.69,-8.44,-7.44,-8.38,-9.66,-8.72,-6.91,-6.69,-7.69,-6.47,-4.47,-3.66,-4.97,-5.31,-3.72,-3.44,-5.03,-6.66,-6.34,-5.81,-7.56,-9.34,-8.62,-7.59,-8.25,-10.62,-11.34,-11.0,-11.81,-13.59,-13.75,-11.69,-9.38,-8.25,-6.56,-1.94,2.44,4.41,5.19,7.09,9.53,9.38,7.53,7.0,6.66,4.94,1.0,-2.31,-3.47,-4.91,-8.09,-10.94,-11.22,-11.28,-13.38,-16.06,-16.5,-15.66,-16.19,-17.44,-16.69,-14.66,-13.12,-13.28,-12.59,-9.25,-6.31,-5.56,-5.03,-2.44,-0.41,-0.97,-3.09,-3.28,-3.0,-3.75,-5.12,-4.75,-2.47,-0.72,-0.69,-0.75,1.03,1.84,0.03,-2.84,-3.69,-4.0,-6.06,-8.5,-8.75,-7.34,-7.19,-7.84,-6.62,-3.72,-1.41,-0.84,0.03,2.62,4.59,4.16,2.19,2.0,1.84,-0.66,-4.34,-6.31,-6.72,-7.91,-9.88,-9.94,-7.94,-6.25,-7.19,-7.56,-5.62,-3.66,-3.31,-3.97,-2.06,0.5,0.97,0.28,1.25,3.28,3.88,2.25,1.44,2.53,3.12,1.66,0.88,2.06,3.41,2.75,1.59,2.38,4.0,3.91,2.22,1.78,2.59,2.12,-0.53,-2.62,-2.88,-4.03,-7.78,-10.84,-11.66,-11.56,-12.97,-14.31,-12.75,-10.34,-9.41,-9.94,-8.81,-6.56,-5.47,-6.06,-6.12,-4.38,-3.38,-4.97,-6.59,-6.03,-5.44,-7.06,-9.34,-9.81,-9.5,-11.16,-13.97,-15.38,-14.78,-14.25,-15.19,-14.34,-10.94,-8.22,-7.78,-8.06,-6.78,-5.31,-5.97,-7.22,-5.84,-3.41,-2.38,-3.12,-2.94,-1.44,-1.03,-2.88,-3.44,-1.62,0.22,-0.59,-1.75,-1.44,-1.56,-3.34,-6.62,-7.47,-6.75,-7.25,-8.94,-9.22,-8.28,-7.97,-9.44,-10.28,-8.41,-5.94,-5.38,-5.12,-3.12,-0.81,-0.91,-2.53,-2.19,-0.62,-0.28,-1.75,-1.97,-0.75,-0.56,-2.78,-3.94,-2.78,-1.06,-1.56,-2.81,-2.41,-1.72,-3.16,-5.62,-5.81,-4.78,-4.38,-5.72,-5.62,-3.06,-0.56,-0.03,1.09,4.25,7.28,7.59,6.75,7.47,8.47,6.91,3.84,2.28,2.12,1.03,-1.97,-3.84,-3.47,-3.34,-5.0,-6.12,-4.09,-1.97,-2.22,-3.0,-2.25,-0.72,-1.09,-2.72,-3.03,-2.16,-2.06,-3.47,-4.03,-2.53,-1.25,-3.09,-5.06,-5.44,-5.06,-6.22,-7.44,-6.56,-4.03,-2.91,-3.34,-2.28,0.56,2.78,3.03,4.25,6.94,8.88,7.69,5.81,5.44,6.12,4.34,2.12,1.84,3.09,2.59,0.53,0.44,2.31,3.91,3.47,3.34,4.78,5.31,2.66,-0.38,-0.41,0.81,0.66,0.38,2.0,5.12,5.97,4.84,4.47,5.31,5.25,3.0,2.0,3.75,5.94,5.69,5.34,6.69,8.44,7.69,5.53,5.16,6.34,6.22,4.59,4.22,5.56,6.41,4.72,3.75,5.09,6.25,5.06,3.59,3.84,5.38,4.84,3.56,4.19,6.41,7.75,7.41,7.97,10.31,11.66,10.19,8.88,9.41,10.09,8.06,5.41,4.88,5.81,4.88,2.94,2.62,4.0,3.66,1.84,1.69,3.97,6.44,6.38,6.31,8.25,9.88,8.19,5.69,4.59,4.09,2.19,-0.38,-0.94,0.69,1.41,0.12,-0.03,1.66,3.06,2.16,1.38,2.22,3.25,1.16,-1.66,-2.44,-1.41,-2.25,-3.94,-3.44,-1.44,-0.75,-1.94,-2.22,-0.19,1.75,1.28,1.12,2.78,4.78,3.81,1.75,1.12,1.91,1.19,-0.56,-0.25,1.75,2.47,1.0,-0.25,0.47,0.47,-1.94,-4.56,-5.19,-5.06,-6.72,-9.0,-9.31,-7.59,-7.38,-8.12,-7.12,-3.81,-1.59,-1.69,-1.22,1.78,-15.75,-14.44,-14.25,-15.03,-14.34,-12.12,-10.59,-9.34,-8.31,-6.25,-5.16,-6.28,-8.03,-8.97,-10.03,-12.0,-14.38,-15.31,-15.41,-16.56,-18.56,-19.5,-19.38,-19.53,-20.16,-20.06,-18.31,-16.97:-3.56,-3.94,-6.25,-7.66,-6.59,-5.94,-7.09,-8.06,-6.72,-5.28,-6.34,-8.34,-8.72,-8.03,-8.88,-10.97,-11.44,-9.28,-8.0,-8.31,-7.81,-5.28,-3.69,-4.16,-4.72,-3.19,-1.41,-1.41,-2.66,-2.41,-0.72,-0.66,-2.28,-2.94,-1.91,-2.38,-5.84,-9.0,-9.41,-9.75,-11.25,-11.91,-9.72,-6.47,-4.94,-4.78,-2.78,0.44,1.5,0.75,0.59,2.25,2.97,1.28,0.06,1.22,2.44,1.59,0.5,1.53,2.91,2.31,-0.03,-0.94,-0.59,-1.94,-5.03,-7.22,-6.56,-6.5,-8.41,-10.09,-9.19,-8.53,-9.94,-11.72,-10.56,-8.72,-7.94,-8.38,-7.53,-5.12,-4.5,-6.44,-7.78,-7.28,-7.47,-9.72,-11.47,-10.84,-9.72,-9.88,-10.59,-8.84,-6.22,-5.03,-5.75,-5.25,-3.84,-4.41,-7.31,-9.72,-10.31,-10.75,-12.47,-13.28,-11.0,-7.53,-5.53,-4.81,-2.03,0.91,2.19,1.44,1.47,2.84,2.81,1.0,-0.75,0.31,1.38,0.22,-1.41,-1.31,-1.16,-2.94,-5.78,-6.56,-6.03,-6.38,-8.72,-9.41,-8.56,-8.19,-10.09,-11.25,-9.88,-8.12,-8.38,-8.47,-6.66,-3.75,-2.66,-2.75,-0.94,1.5,2.5,1.06,-0.56,-1.31,-3.72,-9.0,-14.47,-17.16,-19.19,-21.84,-24.03,-23.12,-20.66,-19.59,-19.44,-18.03,-15.38,-13.56,-13.5,-12.78,-10.62,-9.41,-10.44,-11.59,-10.81,-9.44,-9.56,-10.47,-9.59,-7.91,-7.38,-8.03,-7.81,-5.75,-4.84,-5.66,-4.91,-1.53,2.28,4.28,6.12,9.38,11.72,10.75,7.94,6.28,5.09,2.78,-0.88,-2.53,-2.19,-2.28,-4.12,-4.88,-3.06,-1.38,-1.62,-2.12,-0.62,1.22,0.91,-0.84,-1.25,-0.69,-2.19,-4.94,-6.0,-5.0,-4.44,-5.88,-6.25,-4.5,-2.06,-1.44,-0.28,3.0,6.28,6.91,5.75,4.69,4.56,2.75,-0.38,-2.16,-1.59,-0.91,-2.56,-3.25,-2.03,-0.66,-1.12,-1.97,-0.62,1.53,2.0,1.78,2.66,4.53,4.69,2.66,0.47,0.0,-1.09,-3.94,-6.16,-5.75,-4.16,-5.06,-6.31,-5.47,-3.84,-4.06,-4.56,-3.38,-0.59,0.81,0.03,-0.72,-0.03,-0.28,-2.81,-5.25,-5.25,-4.06,-5.03,-6.22,-5.59,-4.66,-5.41,-7.56,-8.28,-6.31,-4.25,-3.66,-1.62,2.28,5.5,5.53,4.81,5.22,5.53,3.91,1.38,0.81,0.97,-0.53,-3.5,-5.19,-5.12,-5.59,-7.5,-8.47,-7.22,-5.62,-5.97,-6.59,-5.25,-3.5,-4.0,-5.47,-5.12,-3.5,-3.0,-3.97,-4.16,-2.66,-2.03,-4.19,-6.06,-6.06,-6.09,-8.28,-10.66,-10.34,-9.16,-9.22,-10.16,-10.06,-9.0,-9.34,-11.5,-11.31,-8.47,-5.47,-4.28,-2.84,-0.12,2.66,2.53,1.94,3.03,4.38,2.94,-0.41,-3.03,-4.84,-7.59,-11.19,-13.19,-12.06,-10.34,-10.59,-10.69,-8.47,-5.81,-5.53,-5.91,-4.69,-2.16,-1.53,-1.34,0.28,3.59,5.22,4.47,4.03,5.31,6.41,6.31,6.5,8.94,11.69,11.53,9.94,9.09,8.91,6.91,3.66,1.19,0.78,-0.59,-4.06,-6.62,-6.69,-6.12,-7.09,-7.12,-4.41,-0.41,1.72,2.56,4.28,6.56,6.5,4.53,3.41,4.28,4.56,2.72,1.41,2.19,2.62,0.28,-3.16,-5.22,-6.72,-10.25,-14.16,-15.47,-14.69,-14.72,-15.38,-14.91,-12.19,-9.88,-9.53,-7.69,-3.88,-0.34,1.06,1.88,4.09,6.31,6.06,4.19,3.06,2.91,0.91,-2.81,-5.44,-5.81,-6.53,-8.28,-9.06,-7.47,-5.84,-6.66,-7.97,-7.91,-6.56,-6.69,-7.5,-6.72,-4.5,-3.62,-4.53,-4.84,-3.22,-2.0,-2.75,-3.84,-3.31,-2.62,-3.91,-5.16,-4.28,-1.66,-0.75,-1.06,-0.31,1.41,1.75,-0.44,-2.47,-2.75,-3.62,-6.06,-8.12,-7.88,-6.91,-8.16,-10.0,-10.22,-9.59,-10.47,-12.47,-13.41,-12.53,-12.19,-13.34,-13.34,-10.75,-8.44,-8.28,-8.91,-8.16,-7.28,-8.66,-10.16,-9.88,-8.38,-8.09,-9.19,-9.25,-7.59,-6.94,-8.25,-9.69,-9.22,-8.91,-10.59,-12.81,-13.06,-12.44,-14.03,-15.84,-15.53,-13.41,-11.94,-11.59,-10.19,-6.59,-3.66,-2.66,-2.03,0.31,1.88,0.31,-2.66,-4.22,-5.06,-7.0,-9.12,-8.94,-6.56,-5.09,-5.44,-5.62,-3.88,-3.66,-5.91,-8.03,-8.09,-7.19,-8.12,-8.84,-7.66,-5.62,-6.09,-8.03,-9.09,-8.72,-9.06,-10.31,-10.66,-8.41,-6.56,-6.75,-7.0,-4.97,-2.56,-2.09,-2.09,-0.22,2.31,3.19,2.5,2.75,4.28,4.72,3.06,1.94,2.91,2.75,0.38,-2.88,-4.53,-6.38,-10.66,-15.25,-17.22,-16.56,-16.28,-15.88,-14.0,-10.25,-7.31,-6.62,-5.84,-2.97,-0.84,-1.22,-2.09,-1.22,-0.38,-1.56,-3.88,-4.78,-4.5,-4.97,-6.75,-7.34,-5.62,-4.72,-6.16,-7.34,-6.69,-6.19,-7.81,-9.56,-9.06,-7.59,-7.47,-8.69,-8.56,-7.34,-7.5,-9.47,-10.78,-10.47,-10.88,-13.03,-14.69,-13.75,-12.34,-12.88,-13.72,-12.31,-10.0,-9.44,-9.47,-8.41,-5.69,-4.41,-4.97,-5.5,-4.25,-3.84,-5.81,-8.19,-8.12,-8.0,-9.66,-11.69,-11.38,-10.16,-10.94,-12.88,-13.53,-12.72,-12.5,-13.41,-12.88,-10.0,-6.75,-5.28,-4.19,-1.62,0.81,0.31,-1.44,-1.25,-0.41,-1.56,-4.34,-6.28,-6.62,-7.97,-10.19,-11.47,-9.75,-8.16,-8.62,-9.31,-8.16,-7.16,-8.22,-10.12,-9.59,-7.84,-7.19,-8.0,-8.41,-6.97,-6.78,-8.69,-9.69,-8.44,-7.44,-8.38,-9.66,-8.72,-6.91,-6.69,-7.69,-6.47,-4.47,-3.66,-4.97,-5.31,-3.72,-3.44,-5.03,-6.66,-6.34,-5.81,-7.56,-9.34,-8.62,-7.59,-8.25,-10.62,-11.34,-11.0,-11.81,-13.59,-13.75,-11.69,-9.38,-8.25,-6.56,-1.94,2.44,4.41,5.19,7.09,9.53,9.38,7.53,7.0,6.66,4.94,1.0,-2.31,-3.47,-4.91,-8.09,-10.94,-11.22,-11.28,-13.38,-16.06,-16.5,-15.66,-16.19,-17.44,-16.69,-14.66,-13.12,-13.28,-12.59,-9.25,-6.31,-5.56,-5.03,-2.44,-0.41,-0.97,-3.09,-3.28,-3.0,-3.75,-5.12,-4.75,-2.47,-0.72,-0.69,-0.75,1.03,1.84,0.03,-2.84,-3.69,-4.0,-6.06,-8.5,-8.75,-7.34,-7.19,-7.84,-6.62,-3.72,-1.41,-0.84,0.03,2.62,4.59,4.16,2.19,2.0,1.84,-0.66,-4.34,-6.31,-6.72,-7.91,-9.88,-9.94,-7.94,-6.25,-7.19,-7.56,-5.62,-3.66,-3.31,-3.97,-2.06,0.5,0.97,0.28,1.25,3.28,3.88,2.25,1.44,2.53,3.12,1.66,0.88,2.06,3.41,2.75,1.59,2.38,4.0,3.91,2.22,1.78,2.59,2.12,-0.53,-2.62,-2.88,-4.03,-7.78,-10.84,-11.66,-11.56,-12.97,-14.31,-12.75,-10.34,-9.41,-9.94,-8.81,-6.56,-5.47,-6.06,-6.12,-4.38,-3.38,-4.97,-6.59,-6.03,-5.44,-7.06,-9.34,-9.81,-9.5,-11.16,-13.97,-15.38,-14.78,-14.25,-15.19,-14.34,-10.94,-8.22,-7.78,-8.06,-6.78,-5.31,-5.97,-7.22,-5.84,-3.41,-2.38,-3.12,-2.94,-1.44,-1.03,-2.88,-3.44,-1.62,0.22,-0.59,-1.75,-1.44,-1.56,-3.34,-6.62,-7.47,-6.75,-7.25,-8.94,-9.22,-8.28,-7.97,-9.44,-10.28,-8.41,-5.94,-5.38,-5.12,-3.12,-0.81,-0.91,-2.53,-2.19,-0.62,-0.28,-1.75,-1.97,-0.75,-0.56,-2.78,-3.94,-2.78,-1.06,-1.56,-2.81,-2.41,-1.72,-3.16,-5.62,-5.81,-4.78,-4.38,-5.72,-5.62,-3.06,-0.56,-0.03,1.09,4.25,7.28,7.59,6.75,7.47,8.47,6.91,3.84,2.28,2.12,1.03,-1.97,-3.84,-3.47,-3.34,-5.0,-6.12,-4.09,-1.97,-2.22,-3.0,-2.25,-0.72,-1.09,-2.72,-3.03,-2.16,-2.06,-3.47,-4.03,-2.53,-1.25,-3.09,-5.06,-5.44,-5.06,-6.22,-7.44,-6.56,-4.03,-2.91,-3.34,-2.28,0.56,2.78,3.03,4.25,6.94,8.88,7.69,5.81,5.44,6.12,4.34,2.12,1.84,3.09,2.59,0.53,0.44,2.31,3.91,3.47,3.34,4.78,5.31,2.66,-0.38,-0.41,0.81,0.66,0.38,2.0,5.12,5.97,4.84,4.47,5.31,5.25,3.0,2.0,3.75,5.94,5.69,5.34,6.69,8.44,7.69,5.53,5.16,6.34,6.22,4.59,4.22,5.56,6.41,4.72,3.75,5.09,6.25,5.06,3.59,3.84,5.38,4.84,3.56,4.19,6.41,7.75,7.41,7.97,10.31,11.66,10.19,8.88,9.41,10.09,8.06,5.41,4.88,5.81,4.88,2.94,2.62,4.0,3.66,1.84,1.69,3.97,6.44,6.38,6.31,8.25,9.88,8.19,5.69,4.59,4.09,2.19,-0.38,-0.94,0.69,1.41,0.12,-0.03,1.66,3.06,2.16,1.38,2.22,3.25,1.16,-1.66,-2.44,-1.41,-2.25,-3.94,-3.44,-1.44,-0.75,-1.94,-2.22,-0.19,1.75,1.28,1.12,2.78,4.78,3.81,1.75,1.12,1.91,1.19,-0.56,-0.25,1.75,2.47,1.0,-0.25,0.47,0.47,-1.94,-4.56,-5.19,-5.06,-6.72,-9.0,-9.31,-7.59,-7.38,-8.12,-7.12,-3.81,-1.59,-1.69,-1.22,1.78,-15.75,-14.44,-14.25,-15.03,-14.34,-12.12,-10.59,-9.34,-8.31,-6.25,-5.16,-6.28,-8.03,-8.97,-10.03,-12.0,-14.38,-15.31,-15.41,-16.56,-18.56,-19.5,-19.38,-19.53,-20.16,-20.06,-18.31,-16.97,-16.62,-16.34,-14.94,-13.22,-12.47,-13.03,-12.53:-8.06,-6.72,-5.28,-6.34,-8.34,-8.72,-8.03,-8.88,-10.97,-11.44,-9.28,-8.0,-8.31,-7.81,-5.28,-3.69,-4.16,-4.72,-3.19,-1.41,-1.41,-2.66,-2.41,-0.72,-0.66,-2.28,-2.94,-1.91,-2.38,-5.84,-9.0,-9.41,-9.75,-11.25,-11.91,-9.72,-6.47,-4.94,-4.78,-2.78,0.44,1.5,0.75,0.59,2.25,2.97,1.28,0.06,1.22,2.44,1.59,0.5,1.53,2.91,2.31,-0.03,-0.94,-0.59,-1.94,-5.03,-7.22,-6.56,-6.5,-8.41,-10.09,-9.19,-8.53,-9.94,-11.72,-10.56,-8.72,-7.94,-8.38,-7.53,-5.12,-4.5,-6.44,-7.78,-7.28,-7.47,-9.72,-11.47,-10.84,-9.72,-9.88,-10.59,-8.84,-6.22,-5.03,-5.75,-5.25,-3.84,-4.41,-7.31,-9.72,-10.31,-10.75,-12.47,-13.28,-11.0,-7.53,-5.53,-4.81,-2.03,0.91,2.19,1.44,1.47,2.84,2.81,1.0,-0.75,0.31,1.38,0.22,-1.41,-1.31,-1.16,-2.94,-5.78,-6.56,-6.03,-6.38,-8.72,-9.41,-8.56,-8.19,-10.09,-11.25,-9.88,-8.12,-8.38,-8.47,-6.66,-3.75,-2.66,-2.75,-0.94,1.5,2.5,1.06,-0.56,-1.31,-3.72,-9.0,-14.47,-17.16,-19.19,-21.84,-24.03,-23.12,-20.66,-19.59,-19.44,-18.03,-15.38,-13.56,-13.5,-12.78,-10.62,-9.41,-10.44,-11.59,-10.81,-9.44,-9.56,-10.47,-9.59,-7.91,-7.38,-8.03,-7.81,-5.75,-4.84,-5.66,-4.91,-1.53,2.28,4.28,6.12,9.38,11.72,10.75,7.94,6.28,5.09,2.78,-0.88,-2.53,-2.19,-2.28,-4.12,-4.88,-3.06,-1.38,-1.62,-2.12,-0.62,1.22,0.91,-0.84,-1.25,-0.69,-2.19,-4.94,-6.0,-5.0,-4.44,-5.88,-6.25,-4.5,-2.06,-1.44,-0.28,3.0,6.28,6.91,5.75,4.69,4.56,2.75,-0.38,-2.16,-1.59,-0.91,-2.56,-3.25,-2.03,-0.66,-1.12,-1.97,-0.62,1.53,2.0,1.78,2.66,4.53,4.69,2.66,0.47,0.0,-1.09,-3.94,-6.16,-5.75,-4.16,-5.06,-6.31,-5.47,-3.84,-4.06,-4.56,-3.38,-0.59,0.81,0.03,-0.72,-0.03,-0.28,-2.81,-5.25,-5.25,-4.06,-5.03,-6.22,-5.59,-4.66,-5.41,-7.56,-8.28,-6.31,-4.25,-3.66,-1.62,2.28,5.5,5.53,4.81,5.22,5.53,3.91,1.38,0.81,0.97,-0.53,-3.5,-5.19,-5.12,-5.59,-7.5,-8.47,-7.22,-5.62,-5.97,-6.59,-5.25,-3.5,-4.0,-5.47,-5.12,-3.5,-3.0,-3.97,-4.16,-2.66,-2.03,-4.19,-6.06,-6.06,-6.09,-8.28,-10.66,-10.34,-9.16,-9.22,-10.16,-10.06,-9.0,-9.34,-11.5,-11.31,-8.47,-5.47,-4.28,-2.84,-0.12,2.66,2.53,1.94,3.03,4.38,2.94,-0.41,-3.03,-4.84,-7.59,-11.19,-13.19,-12.06,-10.34,-10.59,-10.69,-8.47,-5.81,-5.53,-5.91,-4.69,-2.16,-1.53,-1.34,0.28,3.59,5.22,4.47,4.03,5.31,6.41,6.31,6.5,8.94,11.69,11.53,9.94,9.09,8.91,6.91,3.66,1.19,0.78,-0.59,-4.06,-6.62,-6.69,-6.12,-7.09,-7.12,-4.41,-0.41,1.72,2.56,4.28,6.56,6.5,4.53,3.41,4.28,4.56,2.72,1.41,2.19,2.62,0.28,-3.16,-5.22,-6.72,-10.25,-14.16,-15.47,-14.69,-14.72,-15.38,-14.91,-12.19,-9.88,-9.53,-7.69,-3.88,-0.34,1.06,1.88,4.09,6.31,6.06,4.19,3.06,2.91,0.91,-2.81,-5.44,-5.81,-6.53,-8.28,-9.06,-7.47,-5.84,-6.66,-7.97,-7.91,-6.56,-6.69,-7.5,-6.72,-4.5,-3.62,-4.53,-4.84,-3.22,-2.0,-2.75,-3.84,-3.31,-2.62,-3.91,-5.16,-4.28,-1.66,-0.75,-1.06,-0.31,1.41,1.75,-0.44,-2.47,-2.75,-3.62,-6.06,-8.12,-7.88,-6.91,-8.16,-10.0,-10.22,-9.59,-10.47,-12.47,-13.41,-12.53,-12.19,-13.34,-13.34,-10.75,-8.44,-8.28,-8.91,-8.16,-7.28,-8.66,-10.16,-9.88,-8.38,-8.09,-9.19,-9.25,-7.59,-6.94,-8.25,-9.69,-9.22,-8.91,-10.59,-12.81,-13.06,-12.44,-14.03,-15.84,-15.53,-13.41,-11.94,-11.59,-10.19,-6.59,-3.66,-2.66,-2.03,0.31,1.88,0.31,-2.66,-4.22,-5.06,-7.0,-9.12,-8.94,-6.56,-5.09,-5.44,-5.62,-3.88,-3.66,-5.91,-8.03,-8.09,-7.19,-8.12,-8.84,-7.66,-5.62,-6.09,-8.03,-9.09,-8.72,-9.06,-10.31,-10.66,-8.41,-6.56,-6.75,-7.0,-4.97,-2.56,-2.09,-2.09,-0.22,2.31,3.19,2.5,2.75,4.28,4.72,3.06,1.94,2.91,2.75,0.38,-2.88,-4.53,-6.38,-10.66,-15.25,-17.22,-16.56,-16.28,-15.88,-14.0,-10.25,-7.31,-6.62,-5.84,-2.97,-0.84,-1.22,-2.09,-1.22,-0.38,-1.56,-3.88,-4.78,-4.5,-4.97,-6.75,-7.34,-5.62,-4.72,-6.16,-7.34,-6.69,-6.19,-7.81,-9.56,-9.06,-7.59,-7.47,-8.69,-8.56,-7.34,-7.5,-9.47,-10.78,-10.47,-10.88,-13.03,-14.69,-13.75,-12.34,-12.88,-13.72,-12.31,-10.0,-9.44,-9.47,-8.41,-5.69,-4.41,-4.97,-5.5,-4.25,-3.84,-5.81,-8.19,-8.12,-8.0,-9.66,-11.69,-11.38,-10.16,-10.94,-12.88,-13.53,-12.72,-12.5,-13.41,-12.88,-10.0,-6.75,-5.28,-4.19,-1.62,0.81,0.31,-1.44,-1.25,-0.41,-1.56,-4.34,-6.28,-6.62,-7.97,-10.19,-11.47,-9.75,-8.16,-8.62,-9.31,-8.16,-7.16,-8.22,-10.12,-9.59,-7.84,-7.19,-8.0,-8.41,-6.97,-6.78,-8.69,-9.69,-8.44,-7.44,-8.38,-9.66,-8.72,-6.91,-6.69,-7.69,-6.47,-4.47,-3.66,-4.97,-5.31,-3.72,-3.44,-5.03,-6.66,-6.34,-5.81,-7.56,-9.34,-8.62,-7.59,-8.25,-10.62,-11.34,-11.0,-11.81,-13.59,-13.75,-11.69,-9.38,-8.25,-6.56,-1.94,2.44,4.41,5.19,7.09,9.53,9.38,7.53,7.0,6.66,4.94,1.0,-2.31,-3.47,-4.91,-8.09,-10.94,-11.22,-11.28,-13.38,-16.06,-16.5,-15.66,-16.19,-17.44,-16.69,-14.66,-13.12,-13.28,-12.59,-9.25,-6.31,-5.56,-5.03,-2.44,-0.41,-0.97,-3.09,-3.28,-3.0,-3.75,-5.12,-4.75,-2.47,-0.72,-0.69,-0.75,1.03,1.84,0.03,-2.84,-3.69,-4.0,-6.06,-8.5,-8.75,-7.34,-7.19,-7.84,-6.62,-3.72,-1.41,-0.84,0.03,2.62,4.59,4.16,2.19,2.0,1.84,-0.66,-4.34,-6.31,-6.72,-7.91,-9.88,-9.94,-7.94,-6.25,-7.19,-7.56,-5.62,-3.66,-3.31,-3.97,-2.06,0.5,0.97,0.28,1.25,3.28,3.88,2.25,1.44,2.53,3.12,1.66,0.88,2.06,3.41,2.75,1.59,2.38,4.0,3.91,2.22,1.78,2.59,2.12,-0.53,-2.62,-2.88,-4.03,-7.78,-10.84,-11.66,-11.56,-12.97,-14.31,-12.75,-10.34,-9.41,-9.94,-8.81,-6.56,-5.47,-6.06,-6.12,-4.38,-3.38,-4.97,-6.59,-6.03,-5.44,-7.06,-9.34,-9.81,-9.5,-11.16,-13.97,-15.38,-14.78,-14.25,-15.19,-14.34,-10.94,-8.22,-7.78,-8.06,-6.78,-5.31,-5.97,-7.22,-5.84,-3.41,-2.38,-3.12,-2.94,-1.44,-1.03,-2.88,-3.44,-1.62,0.22,-0.59,-1.75,-1.44,-1.56,-3.34,-6.62,-7.47,-6.75,-7.25,-8.94,-9.22,-8.28,-7.97,-9.44,-10.28,-8.41,-5.94,-5.38,-5.12,-3.12,-0.81,-0.91,-2.53,-2.19,-0.62,-0.28,-1.75,-1.97,-0.75,-0.56,-2.78,-3.94,-2.78,-1.06,-1.56,-2.81,-2.41,-1.72,-3.16,-5.62,-5.81,-4.78,-4.38,-5.72,-5.62,-3.06,-0.56,-0.03,1.09,4.25,7.28,7.59,6.75,7.47,8.47,6.91,3.84,2.28,2.12,1.03,-1.97,-3.84,-3.47,-3.34,-5.0,-6.12,-4.09,-1.97,-2.22,-3.0,-2.25,-0.72,-1.09,-2.72,-3.03,-2.16,-2.06,-3.47,-4.03,-2.53,-1.25,-3.09,-5.06,-5.44,-5.06,-6.22,-7.44,-6.56,-4.03,-2.91,-3.34,-2.28,0.56,2.78,3.03,4.25,6.94,8.88,7.69,5.81,5.44,6.12,4.34,2.12,1.84,3.09,2.59,0.53,0.44,2.31,3.91,3.47,3.34,4.78,5.31,2.66,-0.38,-0.41,0.81,0.66,0.38,2.0,5.12,5.97,4.84,4.47,5.31,5.25,3.0,2.0,3.75,5.94,5.69,5.34,6.69,8.44,7.69,5.53,5.16,6.34,6.22,4.59,4.22,5.56,6.41,4.72,3.75,5.09,6.25,5.06,3.59,3.84,5.38,4.84,3.56,4.19,6.41,7.75,7.41,7.97,10.31,11.66,10.19,8.88,9.41,10.09,8.06,5.41,4.88,5.81,4.88,2.94,2.62,4.0,3.66,1.84,1.69,3.97,6.44,6.38,6.31,8.25,9.88,8.19,5.69,4.59,4.09,2.19,-0.38,-0.94,0.69,1.41,0.12,-0.03,1.66,3.06,2.16,1.38,2.22,3.25,1.16,-1.66,-2.44,-1.41,-2.25,-3.94,-3.44,-1.44,-0.75,-1.94,-2.22,-0.19,1.75,1.28,1.12,2.78,4.78,3.81,1.75,1.12,1.91,1.19,-0.56,-0.25,1.75,2.47,1.0,-0.25,0.47,0.47,-1.94,-4.56,-5.19,-5.06,-6.72,-9.0,-9.31,-7.59,-7.38,-8.12,-7.12,-3.81,-1.59,-1.69,-1.22,1.78,-15.75,-14.44,-14.25,-15.03,-14.34,-12.12,-10.59,-9.34,-8.31,-6.25,-5.16,-6.28,-8.03,-8.97,-10.03,-12.0,-14.38,-15.31,-15.41,-16.56,-18.56,-19.5,-19.38,-19.53,-20.16,-20.06,-18.31,-16.97,-16.62,-16.34,-14.94,-13.22,-12.47,-13.03,-12.53,-12.16,-13.47,-15.47,-16.69,-16.56,-16.88,-17.81:positivity
2.66,2.38,2.06,-0.44,-2.91,-3.19,-2.62,-3.81,-5.44,-4.47,-2.12,-0.53,0.34,3.28,7.62,10.69,11.22,11.47,12.34,11.56,8.09,4.22,2.03,1.19,-1.25,-4.47,-5.94,-6.78,-9.12,-12.78,-14.72,-13.78,-12.56,-12.09,-10.0,-5.28,0.38,4.59,8.88,15.44,21.97,25.81,26.94,27.75,27.53,23.72,17.12,9.97,3.81,-2.62,-10.44,-16.97,-20.19,-21.78,-24.22,-25.5,-23.59,-19.69,-16.5,-12.88,-7.16,0.22,6.31,10.25,13.59,17.09,18.69,17.0,14.41,12.81,11.62,8.25,4.47,2.94,3.06,1.97,-0.19,-0.84,-0.47,-2.03,-5.19,-8.12,-9.22,-10.25,-12.34,-13.38,-11.09,-7.38,-4.47,-2.16,1.94,6.59,9.22,10.12,11.44,13.38,13.72,11.75,9.81,9.09,7.53,2.97,-2.62,-6.5,-9.16,-13.03,-15.66,-15.09,-11.88,-9.28,-7.31,-3.66,1.25,5.06,5.97,6.94,8.88,9.44,7.38,5.22,4.44,4.75,3.44,1.56,0.81,0.59,-1.53,-5.66,-8.62,-9.28,-9.34,-10.22,-9.53,-6.41,-2.84,-1.25,-0.94,0.56,2.44,1.56,-0.5,-1.5,-0.88,-1.31,-3.0,-3.78,-2.72,-2.5,-4.75,-7.28,-8.44,-9.53,-12.19,-15.03,-15.53,-14.09,-13.19,-12.78,-10.59,-6.19,-2.47,-0.78,1.44,4.78,6.66,5.5,3.44,2.59,2.12,0.12,-2.34,-2.84,-1.81,-2.0,-3.5,-3.59,-1.88,-0.94,-1.56,-1.66,0.16,1.5,1.0,0.22,1.62,4.06,4.62,4.12,4.72,5.94,4.81,2.75,2.12,3.88,4.97,4.28,3.25,3.47,3.38,1.41,-0.31,0.5,2.22,2.28,1.41,1.59,2.78,3.03,1.88,1.47,3.59,5.91,6.47,7.69,10.78,13.25,12.84,11.19,10.66,10.53,8.97,6.38,5.34,5.97,5.28,3.28,1.91,2.69,3.22,2.25,1.53,3.0,4.78,4.56,3.78,5.12,7.56,8.66,8.53,10.06,12.5,13.31,11.69,10.16,10.03,9.09,6.56,4.41,4.34,5.12,4.84,4.0,5.59,8.84,10.75,11.06,12.12,13.88,13.66,10.91,8.03,7.44,6.69,4.78,3.03,4.03,5.94,6.25,5.78,6.28,7.91,7.94,6.06,5.03,5.75,4.94,2.25,-0.44,-0.88,-1.38,-3.5,-5.34,-4.44,-2.5,-1.53,-0.38,1.72,5.56,7.94,8.12,8.31,9.38,9.38,7.0,4.72,4.56,4.53,2.78,0.53,0.47,1.47,1.47,1.03,1.75,3.84,4.88,3.69,2.53,3.16,3.19,1.5,0.53,1.94,3.75,3.56,2.28,2.06,2.84,2.31,0.75,0.75,2.62,3.25,1.56,0.34,0.88,0.69,-0.75,-2.06,-0.91,0.59,-0.53,-3.09,-4.53,-5.41,-7.38,-9.56,-9.72,-7.62,-5.62,-5.5,-5.25,-3.38,-2.34,-3.38,-4.78,-3.5,-1.78,-1.62,-2.78,-2.62,-1.94,-3.06,-5.88,-7.59,-6.78,-6.25,-6.81,-6.53,-4.44,-2.41,-2.97,-4.78,-4.53,-4.0,-4.44,-5.12,-3.94,-1.0,0.72,0.34,0.22,1.88,2.34,1.31,0.38,1.75,3.72,3.47,2.59,3.19,4.16,3.09,0.53,-0.56,-0.56,-1.5,-3.59,-5.06,-4.53,-4.09,-5.91,-7.41,-6.69,-5.09,-4.94,-5.5,-4.12,-2.19,-2.06,-3.94,-4.75,-4.78,-5.59,-7.97,-9.72,-8.47,-6.97,-7.19,-7.62,-6.41,-5.19,-6.25,-8.25,-8.34,-6.94,-6.38,-7.19,-6.72,-4.72,-3.69,-5.06,-5.56,-4.09,-2.66,-3.56,-5.22,-5.47,-5.28,-7.5,-10.06,-10.03,-8.66,-7.16,-7.47,-6.72,-4.78,-3.59,-4.25,-4.75,-3.19,-1.47,-2.19,-3.72,-3.88,-3.16,-4.03,-5.78,-5.84,-4.25,-4.09,-5.84,-6.97,-6.88,-7.31,-9.84,-11.94,-11.06,-9.47,-9.19,-8.72,-6.59,-3.0,-1.22,-1.06,0.09,1.56,1.28,-1.97,-5.19,-7.0,-8.91,-12.25,-14.34,-13.22,-10.03,-8.03,-6.16,-3.09,0.03,0.84,-0.47,-1.25,-0.78,-1.12,-3.97,-6.06,-5.78,-4.91,-5.72,-6.12,-3.94,-1.0,-0.09,-0.41,1.22,3.69,4.25,3.03,2.5,3.03,3.09,0.34,-1.22,-0.94,-0.12,-1.0,-1.75,0.53,4.22,6.44,7.88,10.62,14.0,14.62,12.09,9.44,7.62,4.78,0.16,-3.03,-3.31,-2.41,-3.28,-4.62,-4.22,-3.22,-3.97,-5.91,-5.97,-4.41,-3.81,-4.84,-5.06,-3.41,-2.66,-4.12,-5.72,-5.44,-4.66,-5.69,-6.81,-6.28,-5.31,-6.59,-9.56,-11.56,-11.84,-13.06,-15.94,-17.47,-16.28,-14.59,-14.28,-13.0,-9.31,-4.91,-3.12,-2.97,-1.5,0.12,0.25,-1.22,-0.59,2.0,4.03,4.16,4.81,6.75,8.25,6.72,4.78,4.22,3.88,1.09,-1.91,-3.22,-2.94,-3.06,-3.66,-2.78,0.62,3.5,4.16,4.78,7.03,8.22,6.72,4.66,4.12,4.72,3.56,2.34,3.34,6.25,8.0,8.5,9.31,11.5,12.5,11.22,10.09,11.22,12.62,11.38,8.97,8.06,7.56,5.12,2.09,1.19,2.03,2.84,2.03,2.59,5.31,7.16,5.88,3.78,3.59,3.75,1.66,-0.44,-0.81,0.31,-0.81,-2.97,-3.97,-2.81,-2.88,-4.84,-6.12,-5.31,-5.16,-7.12,-8.97,-8.5,-7.62,-8.75,-11.12,-11.97,-11.81,-13.28,-15.09,-14.62,-11.41,-8.28,-6.94,-5.31,-2.59,-1.12,-2.5,-4.44,-4.09,-2.72,-3.03,-3.84,-3.41,-1.97,-3.0,-5.59,-7.12,-6.72,-6.66,-8.47,-9.97,-9.25,-8.38,-9.31,-10.53,-9.16,-6.59,-5.75,-5.19,-3.34,0.03,1.53,0.78,0.0,0.38,-0.19,-3.75,-7.5,-9.31,-10.16,-12.62,-14.56,-13.59,-10.97,-9.69,-8.91,-5.94,-0.59,4.0,7.03,10.91,16.53,20.25,20.34,18.91,18.22,16.31,11.19,4.97,0.31,-3.19,-8.28,-13.84,-17.5,-18.72,-20.56,-23.22,-24.81,-23.34,-21.53,-21.16,-20.47,-16.94,-12.19,-8.88,-5.59,-0.41,5.91,10.16,12.22,14.62,17.34,17.94,15.19,11.41,8.56,4.66,-1.94,-8.5,-11.84,-13.16,-14.62,-15.62,-13.53,-9.75,-7.38,-6.38,-4.28,-0.41,2.28,2.12,1.81,2.88,3.31,1.03,-1.41,-1.38,-0.03,-0.03,-0.62,0.41,3.09,3.97,3.28,3.66,6.31,8.47,8.19,7.47,8.31,8.16,4.75,-0.12,-3.22,-4.94,-7.69,-10.34,-9.91,-7.19,-4.88,-4.34,-3.03,0.28,2.34,2.12,1.44,2.66,3.69,1.72,-1.0,-2.5,-2.94,-4.28,-6.62,-6.94,-4.81,-3.31,-3.31,-2.72,-0.47,0.78,-0.81,-3.03,-2.88,-1.56,-1.91,-2.56,-1.25,1.12,1.75,0.91,1.06,2.94,3.59,2.38,1.5,2.5,3.66,2.59,1.41,2.72,5.16,5.69,5.72,6.97,9.34,9.34,7.06,5.62,5.56,4.03,0.16,-3.28,-4.56,-5.88,-8.59,-10.47,-9.09,-6.5,-4.62,-3.88,-1.88,0.81,1.38,-0.09,-1.5,-0.59,-0.47,-2.38,-3.88,-2.53,-0.66,-0.94,-1.53,-0.16,1.22,0.28,-2.09,-3.06,-2.25,-2.28,-3.38,-4.0,-2.44,-1.44,-3.31,-5.16,-4.88,-3.88,-4.59,-5.62,-3.97,-0.88,0.81,1.06,2.91,6.06,7.81,7.0,6.28,7.59,7.84,5.94,3.56,3.38,3.28,0.91,-2.16,-2.88,-1.88,-1.75,-1.75,-0.34,2.94,4.81,3.78,2.22,2.0,1.44,-0.69,-2.0,0.19,4.0,5.91,6.62,8.0,9.72,9.03,6.31,4.16,4.22,3.59,1.28,-0.12,1.0,2.69,2.72,2.66,5.47,9.22,10.97,11.19,12.66,14.78,15.03,13.09,11.81,11.97,10.97,7.66,4.94,5.16,6.34,6.0,5.38,7.22,9.31,9.88,8.81,9.25,10.47,10.16,7.94,5.91,6.56,6.34,4.56,3.06,4.22,5.69,5.03,3.72,4.0,5.09,4.62,3.03,3.47,5.97,7.91,8.12,8.88,11.0,12.0,9.97,7.75,7.41,7.5,6.12,4.09,4.25,5.31,5.22,2.72,1.38,1.72,1.56,0.09,-0.12,2.88,6.03,6.78,6.97,9.16,10.66,10.19,8.56,8.16,9.16,8.69,6.91,6.78,8.41,9.88,9.22,8.62,9.97,10.75,8.88,6.66,6.53,7.06,6.78,5.97,7.41,10.03,11.31,10.19,9.56,10.38,9.94,6.88,3.97,3.19,2.56,0.09,-2.31,-1.94,-0.47,0.41,0.16,1.72,4.72,6.16,5.44,5.66,7.84,9.31,8.44,7.59,8.44,9.16,7.72,5.81,5.84,7.19,7.69,6.59,7.31,9.34,10.16,8.03,6.34,6.62,6.22,3.5,1.66,2.91,5.25,6.38,7.5,10.59,14.38,16.25,15.88,16.09,16.94,16.66,13.78,11.84,12.44,13.12,11.84,10.75,11.69,13.03,12.47,10.81,10.62,11.47,10.97,8.44,7.0,7.53,7.25,5.12,3.81,4.44,5.12,3.41,1.75,2.31,3.78,3.72,2.56,2.62,3.94,4.25,3.09,3.44,5.72,7.47,6.75,5.91,6.94,7.62,6.09,4.31,4.59,5.94,5.53,3.91,3.94,4.91,4.97,3.06,2.97,4.56,6.03,5.19,4.22,5.28,6.12,4.69,2.91,2.94,3.75,2.78,0.75,-0.16,0.53,0.53,-1.03,-1.72,0.06,1.66,1.44,1.66,4.03,7.03,7.19,6.66,7.41,8.53,8.12,6.38,6.0,7.31,8.03,7.0,6.34,7.69,8.28,5.97,3.25,2.88,3.28,2.91,2.81,4.91,8.41,10.5,11.06,12.53,15.41,17.22,16.75,16.25:-3.81,-5.44,-4.47,-2.12,-0.53,0.34,3.28,7.62,10.69,11.22,11.47,12.34,11.56,8.09,4.22,2.03,1.19,-1.25,-4.47,-5.94,-6.78,-9.12,-12.78,-14.72,-13.78,-12.56,-12.09,-10.0,-5.28,0.38,4.59,8.88,15.44,21.97,25.81,26.94,27.75,27.53,23.72,17.12,9.97,3.81,-2.62,-10.44,-16.97,-20.19,-21.78,-24.22,-25.5,-23.59,-19.69,-16.5,-12.88,-7.16,0.22,6.31,10.25,13.59,17.09,18.69,17.0,14.41,12.81,11.62,8.25,4.47,2.94,3.06,1.97,-0.19,-0.84,-0.47,-2.03,-5.19,-8.12,-9.22,-10.25,-12.34,-13.38,-11.09,-7.38,-4.47,-2.16,1.94,6.59,9.22,10.12,11.44,13.38,13.72,11.75,9.81,9.09,7.53,2.97,-2.62,-6.5,-9.16,-13.03,-15.66,-15.09,-11.88,-9.28,-7.31,-3.66,1.25,5.06,5.97,6.94,8.88,9.44,7.38,5.22,4.44,4.75,3.44,1.56,0.81,0.59,-1.53,-5.66,-8.62,-9.28,-9.34,-10.22,-9.53,-6.41,-2.84,-1.25,-0.94,0.56,2.44,1.56,-0.5,-1.5,-0.88,-1.31,-3.0,-3.78,-2.72,-2.5,-4.75,-7.28,-8.44,-9.53,-12.19,-15.03,-15.53,-14.09,-13.19,-12.78,-10.59,-6.19,-2.47,-0.78,1.44,4.78,6.66,5.5,3.44,2.59,2.12,0.12,-2.34,-2.84,-1.81,-2.0,-3.5,-3.59,-1.88,-0.94,-1.56,-1.66,0.16,1.5,1.0,0.22,1.62,4.06,4.62,4.12,4.72,5.94,4.81,2.75,2.12,3.88,4.97,4.28,3.25,3.47,3.38,1.41,-0.31,0.5,2.22,2.28,1.41,1.59,2.78,3.03,1.88,1.47,3.59,5.91,6.47,7.69,10.78,13.25,12.84,11.19,10.66,10.53,8.97,6.38,5.34,5.97,5.28,3.28,1.91,2.69,3.22,2.25,1.53,3.0,4.78,4.56,3.78,5.12,7.56,8.66,8.53,10.06,12.5,13.31,11.69,10.16,10.03,9.09,6.56,4.41,4.34,5.12,4.84,4.0,5.59,8.84,10.75,11.06,12.12,13.88,13.66,10.91,8.03,7.44,6.69,4.78,3.03,4.03,5.94,6.25,5.78,6.28,7.91,7.94,6.06,5.03,5.75,4.94,2.25,-0.44,-0.88,-1.38,-3.5,-5.34,-4.44,-2.5,-1.53,-0.38,1.72,5.56,7.94,8.12,8.31,9.38,9.38,7.0,4.72,4.56,4.53,2.78,0.53,0.47,1.47,1.47,1.03,1.75,3.84,4.88,3.69,2.53,3.16,3.19,1.5,0.53,1.94,3.75,3.56,2.28,2.06,2.84,2.31,0.75,0.75,2.62,3.25,1.56,0.34,0.88,0.69,-0.75,-2.06,-0.91,0.59,-0.53,-3.09,-4.53,-5.41,-7.38,-9.56,-9.72,-7.62,-5.62,-5.5,-5.25,-3.38,-2.34,-3.38,-4.78,-3.5,-1.78,-1.62,-2.78,-2.62,-1.94,-3.06,-5.88,-7.59,-6.78,-6.25,-6.81,-6.53,-4.44,-2.41,-2.97,-4.78,-4.53,-4.0,-4.44,-5.12,-3.94,-1.0,0.72,0.34,0.22,1.88,2.34,1.31,0.38,1.75,3.72,3.47,2.59,3.19,4.16,3.09,0.53,-0.56,-0.56,-1.5,-3.59,-5.06,-4.53,-4.09,-5.91,-7.41,-6.69,-5.09,-4.94,-5.5,-4.12,-2.19,-2.06,-3.94,-4.75,-4.78,-5.59,-7.97,-9.72,-8.47,-6.97,-7.19,-7.62,-6.41,-5.19,-6.25,-8.25,-8.34,-6.94,-6.38,-7.19,-6.72,-4.72,-3.69,-5.06,-5.56,-4.09,-2.66,-3.56,-5.22,-5.47,-5.28,-7.5,-10.06,-10.03,-8.66,-7.16,-7.47,-6.72,-4.78,-3.59,-4.25,-4.75,-3.19,-1.47,-2.19,-3.72,-3.88,-3.16,-4.03,-5.78,-5.84,-4.25,-4.09,-5.84,-6.97,-6.88,-7.31,-9.84,-11.94,-11.06,-9.47,-9.19,-8.72,-6.59,-3.0,-1.22,-1.06,0.09,1.56,1.28,-1.97,-5.19,-7.0,-8.91,-12.25,-14.34,-13.22,-10.03,-8.03,-6.16,-3.09,0.03,0.84,-0.47,-1.25,-0.78,-1.12,-3.97,-6.06,-5.78,-4.91,-5.72,-6.12,-3.94,-1.0,-0.09,-0.41,1.22,3.69,4.25,3.03,2.5,3.03,3.09,0.34,-1.22,-0.94,-0.12,-1.0,-1.75,0.53,4.22,6.44,7.88,10.62,14.0,14.62,12.09,9.44,7.62,4.78,0.16,-3.03,-3.31,-2.41,-3.28,-4.62,-4.22,-3.22,-3.97,-5.91,-5.97,-4.41,-3.81,-4.84,-5.06,-3.41,-2.66,-4.12,-5.72,-5.44,-4.66,-5.69,-6.81,-6.28,-5.31,-6.59,-9.56,-11.56,-11.84,-13.06,-15.94,-17.47,-16.28,-14.59,-14.28,-13.0,-9.31,-4.91,-3.12,-2.97,-1.5,0.12,0.25,-1.22,-0.59,2.0,4.03,4.16,4.81,6.75,8.25,6.72,4.78,4.22,3.88,1.09,-1.91,-3.22,-2.94,-3.06,-3.66,-2.78,0.62,3.5,4.16,4.78,7.03,8.22,6.72,4.66,4.12,4.72,3.56,2.34,3.34,6.25,8.0,8.5,9.31,11.5,12.5,11.22,10.09,11.22,12.62,11.38,8.97,8.06,7.56,5.12,2.09,1.19,2.03,2.84,2.03,2.59,5.31,7.16,5.88,3.78,3.59,3.75,1.66,-0.44,-0.81,0.31,-0.81,-2.97,-3.97,-2.81,-2.88,-4.84,-6.12,-5.31,-5.16,-7.12,-8.97,-8.5,-7.62,-8.75,-11.12,-11.97,-11.81,-13.28,-15.09,-14.62,-11.41,-8.28,-6.94,-5.31,-2.59,-1.12,-2.5,-4.44,-4.09,-2.72,-3.03,-3.84,-3.41,-1.97,-3.0,-5.59,-7.12,-6.72,-6.66,-8.47,-9.97,-9.25,-8.38,-9.31,-10.53,-9.16,-6.59,-5.75,-5.19,-3.34,0.03,1.53,0.78,0.0,0.38,-0.19,-3.75,-7.5,-9.31,-10.16,-12.62,-14.56,-13.59,-10.97,-9.69,-8.91,-5.94,-0.59,4.0,7.03,10.91,16.53,20.25,20.34,18.91,18.22,16.31,11.19,4.97,0.31,-3.19,-8.28,-13.84,-17.5,-18.72,-20.56,-23.22,-24.81,-23.34,-21.53,-21.16,-20.47,-16.94,-12.19,-8.88,-5.59,-0.41,5.91,10.16,12.22,14.62,17.34,17.94,15.19,11.41,8.56,4.66,-1.94,-8.5,-11.84,-13.16,-14.62,-15.62,-13.53,-9.75,-7.38,-6.38,-4.28,-0.41,2.28,2.12,1.81,2.88,3.31,1.03,-1.41,-1.38,-0.03,-0.03,-0.62,0.41,3.09,3.97,3.28,3.66,6.31,8.47,8.19,7.47,8.31,8.16,4.75,-0.12,-3.22,-4.94,-7.69,-10.34,-9.91,-7.19,-4.88,-4.34,-3.03,0.28,2.34,2.12,1.44,2.66,3.69,1.72,-1.0,-2.5,-2.94,-4.28,-6.62,-6.94,-4.81,-3.31,-3.31,-2.72,-0.47,0.78,-0.81,-3.03,-2.88,-1.56,-1.91,-2.56,-1.25,1.12,1.75,0.91,1.06,2.94,3.59,2.38,1.5,2.5,3.66,2.59,1.41,2.72,5.16,5.69,5.72,6.97,9.34,9.34,7.06,5.62,5.56,4.03,0.16,-3.28,-4.56,-5.88,-8.59,-10.47,-9.09,-6.5,-4.62,-3.88,-1.88,0.81,1.38,-0.09,-1.5,-0.59,-0.47,-2.38,-3.88,-2.53,-0.66,-0.94,-1.53,-0.16,1.22,0.28,-2.09,-3.06,-2.25,-2.28,-3.38,-4.0,-2.44,-1.44,-3.31,-5.16,-4.88,-3.88,-4.59,-5.62,-3.97,-0.88,0.81,1.06,2.91,6.06,7.81,7.0,6.28,7.59,7.84,5.94,3.56,3.38,3.28,0.91,-2.16,-2.88,-1.88,-1.75,-1.75,-0.34,2.94,4.81,3.78,2.22,2.0,1.44,-0.69,-2.0,0.19,4.0,5.91,6.62,8.0,9.72,9.03,6.31,4.16,4.22,3.59,1.28,-0.12,1.0,2.69,2.72,2.66,5.47,9.22,10.97,11.19,12.66,14.78,15.03,13.09,11.81,11.97,10.97,7.66,4.94,5.16,6.34,6.0,5.38,7.22,9.31,9.88,8.81,9.25,10.47,10.16,7.94,5.91,6.56,6.34,4.56,3.06,4.22,5.69,5.03,3.72,4.0,5.09,4.62,3.03,3.47,5.97,7.91,8.12,8.88,11.0,12.0,9.97,7.75,7.41,7.5,6.12,4.09,4.25,5.31,5.22,2.72,1.38,1.72,1.56,0.09,-0.12,2.88,6.03,6.78,6.97,9.16,10.66,10.19,8.56,8.16,9.16,8.69,6.91,6.78,8.41,9.88,9.22,8.62,9.97,10.75,8.88,6.66,6.53,7.06,6.78,5.97,7.41,10.03,11.31,10.19,9.56,10.38,9.94,6.88,3.97,3.19,2.56,0.09,-2.31,-1.94,-0.47,0.41,0.16,1.72,4.72,6.16,5.44,5.66,7.84,9.31,8.44,7.59,8.44,9.16,7.72,5.81,5.84,7.19,7.69,6.59,7.31,9.34,10.16,8.03,6.34,6.62,6.22,3.5,1.66,2.91,5.25,6.38,7.5,10.59,14.38,16.25,15.88,16.09,16.94,16.66,13.78,11.84,12.44,13.12,11.84,10.75,11.69,13.03,12.47,10.81,10.62,11.47,10.97,8.44,7.0,7.53,7.25,5.12,3.81,4.44,5.12,3.41,1.75,2.31,3.78,3.72,2.56,2.62,3.94,4.25,3.09,3.44,5.72,7.47,6.75,5.91,6.94,7.62,6.09,4.31,4.59,5.94,5.53,3.91,3.94,4.91,4.97,3.06,2.97,4.56,6.03,5.19,4.22,5.28,6.12,4.69,2.91,2.94,3.75,2.78,0.75,-0.16,0.53,0.53,-1.03,-1.72,0.06,1.66,1.44,1.66,4.03,7.03,7.19,6.66,7.41,8.53,8.12,6.38,6.0,7.31,8.03,7.0,6.34,7.69,8.28,5.97,3.25,2.88,3.28,2.91,2.81,4.91,8.41,10.5,11.06,12.53,15.41,17.22,16.75,16.25,26.16,23.72,20.53,15.81,11.81,9.72,9.19:7.62,10.69,11.22,11.47,12.34,11.56,8.09,4.22,2.03,1.19,-1.25,-4.47,-5.94,-6.78,-9.12,-12.78,-14.72,-13.78,-12.56,-12.09,-10.0,-5.28,0.38,4.59,8.88,15.44,21.97,25.81,26.94,27.75,27.53,23.72,17.12,9.97,3.81,-2.62,-10.44,-16.97,-20.19,-21.78,-24.22,-25.5,-23.59,-19.69,-16.5,-12.88,-7.16,0.22,6.31,10.25,13.59,17.09,18.69,17.0,14.41,12.81,11.62,8.25,4.47,2.94,3.06,1.97,-0.19,-0.84,-0.47,-2.03,-5.19,-8.12,-9.22,-10.25,-12.34,-13.38,-11.09,-7.38,-4.47,-2.16,1.94,6.59,9.22,10.12,11.44,13.38,13.72,11.75,9.81,9.09,7.53,2.97,-2.62,-6.5,-9.16,-13.03,-15.66,-15.09,-11.88,-9.28,-7.31,-3.66,1.25,5.06,5.97,6.94,8.88,9.44,7.38,5.22,4.44,4.75,3.44,1.56,0.81,0.59,-1.53,-5.66,-8.62,-9.28,-9.34,-10.22,-9.53,-6.41,-2.84,-1.25,-0.94,0.56,2.44,1.56,-0.5,-1.5,-0.88,-1.31,-3.0,-3.78,-2.72,-2.5,-4.75,-7.28,-8.44,-9.53,-12.19,-15.03,-15.53,-14.09,-13.19,-12.78,-10.59,-6.19,-2.47,-0.78,1.44,4.78,6.66,5.5,3.44,2.59,2.12,0.12,-2.34,-2.84,-1.81,-2.0,-3.5,-3.59,-1.88,-0.94,-1.56,-1.66,0.16,1.5,1.0,0.22,1.62,4.06,4.62,4.12,4.72,5.94,4.81,2.75,2.12,3.88,4.97,4.28,3.25,3.47,3.38,1.41,-0.31,0.5,2.22,2.28,1.41,1.59,2.78,3.03,1.88,1.47,3.59,5.91,6.47,7.69,10.78,13.25,12.84,11.19,10.66,10.53,8.97,6.38,5.34,5.97,5.28,3.28,1.91,2.69,3.22,2.25,1.53,3.0,4.78,4.56,3.78,5.12,7.56,8.66,8.53,10.06,12.5,13.31,11.69,10.16,10.03,9.09,6.56,4.41,4.34,5.12,4.84,4.0,5.59,8.84,10.75,11.06,12.12,13.88,13.66,10.91,8.03,7.44,6.69,4.78,3.03,4.03,5.94,6.25,5.78,6.28,7.91,7.94,6.06,5.03,5.75,4.94,2.25,-0.44,-0.88,-1.38,-3.5,-5.34,-4.44,-2.5,-1.53,-0.38,1.72,5.56,7.94,8.12,8.31,9.38,9.38,7.0,4.72,4.56,4.53,2.78,0.53,0.47,1.47,1.47,1.03,1.75,3.84,4.88,3.69,2.53,3.16,3.19,1.5,0.53,1.94,3.75,3.56,2.28,2.06,2.84,2.31,0.75,0.75,2.62,3.25,1.56,0.34,0.88,0.69,-0.75,-2.06,-0.91,0.59,-0.53,-3.09,-4.53,-5.41,-7.38,-9.56,-9.72,-7.62,-5.62,-5.5,-5.25,-3.38,-2.34,-3.38,-4.78,-3.5,-1.78,-1.62,-2.78,-2.62,-1.94,-3.06,-5.88,-7.59,-6.78,-6.25,-6.81,-6.53,-4.44,-2.41,-2.97,-4.78,-4.53,-4.0,-4.44,-5.12,-3.94,-1.0,0.72,0.34,0.22,1.88,2.34,1.31,0.38,1.75,3.72,3.47,2.59,3.19,4.16,3.09,0.53,-0.56,-0.56,-1.5,-3.59,-5.06,-4.53,-4.09,-5.91,-7.41,-6.69,-5.09,-4.94,-5.5,-4.12,-2.19,-2.06,-3.94,-4.75,-4.78,-5.59,-7.97,-9.72,-8.47,-6.97,-7.19,-7.62,-6.41,-5.19,-6.25,-8.25,-8.34,-6.94,-6.38,-7.19,-6.72,-4.72,-3.69,-5.06,-5.56,-4.09,-2.66,-3.56,-5.22,-5.47,-5.28,-7.5,-10.06,-10.03,-8.66,-7.16,-7.47,-6.72,-4.78,-3.59,-4.25,-4.75,-3.19,-1.47,-2.19,-3.72,-3.88,-3.16,-4.03,-5.78,-5.84,-4.25,-4.09,-5.84,-6.97,-6.88,-7.31,-9.84,-11.94,-11.06,-9.47,-9.19,-8.72,-6.59,-3.0,-1.22,-1.06,0.09,1.56,1.28,-1.97,-5.19,-7.0,-8.91,-12.25,-14.34,-13.22,-10.03,-8.03,-6.16,-3.09,0.03,0.84,-0.47,-1.25,-0.78,-1.12,-3.97,-6.06,-5.78,-4.91,-5.72,-6.12,-3.94,-1.0,-0.09,-0.41,1.22,3.69,4.25,3.03,2.5,3.03,3.09,0.34,-1.22,-0.94,-0.12,-1.0,-1.75,0.53,4.22,6.44,7.88,10.62,14.0,14.62,12.09,9.44,7.62,4.78,0.16,-3.03,-3.31,-2.41,-3.28,-4.62,-4.22,-3.22,-3.97,-5.91,-5.97,-4.41,-3.81,-4.84,-5.06,-3.41,-2.66,-4.12,-5.72,-5.44,-4.66,-5.69,-6.81,-6.28,-5.31,-6.59,-9.56,-11.56,-11.84,-13.06,-15.94,-17.47,-16.28,-14.59,-14.28,-13.0,-9.31,-4.91,-3.12,-2.97,-1.5,0.12,0.25,-1.22,-0.59,2.0,4.03,4.16,4.81,6.75,8.25,6.72,4.78,4.22,3.88,1.09,-1.91,-3.22,-2.94,-3.06,-3.66,-2.78,0.62,3.5,4.16,4.78,7.03,8.22,6.72,4.66,4.12,4.72,3.56,2.34,3.34,6.25,8.0,8.5,9.31,11.5,12.5,11.22,10.09,11.22,12.62,11.38,8.97,8.06,7.56,5.12,2.09,1.19,2.03,2.84,2.03,2.59,5.31,7.16,5.88,3.78,3.59,3.75,1.66,-0.44,-0.81,0.31,-0.81,-2.97,-3.97,-2.81,-2.88,-4.84,-6.12,-5.31,-5.16,-7.12,-8.97,-8.5,-7.62,-8.75,-11.12,-11.97,-11.81,-13.28,-15.09,-14.62,-11.41,-8.28,-6.94,-5.31,-2.59,-1.12,-2.5,-4.44,-4.09,-2.72,-3.03,-3.84,-3.41,-1.97,-3.0,-5.59,-7.12,-6.72,-6.66,-8.47,-9.97,-9.25,-8.38,-9.31,-10.53,-9.16,-6.59,-5.75,-5.19,-3.34,0.03,1.53,0.78,0.0,0.38,-0.19,-3.75,-7.5,-9.31,-10.16,-12.62,-14.56,-13.59,-10.97,-9.69,-8.91,-5.94,-0.59,4.0,7.03,10.91,16.53,20.25,20.34,18.91,18.22,16.31,11.19,4.97,0.31,-3.19,-8.28,-13.84,-17.5,-18.72,-20.56,-23.22,-24.81,-23.34,-21.53,-21.16,-20.47,-16.94,-12.19,-8.88,-5.59,-0.41,5.91,10.16,12.22,14.62,17.34,17.94,15.19,11.41,8.56,4.66,-1.94,-8.5,-11.84,-13.16,-14.62,-15.62,-13.53,-9.75,-7.38,-6.38,-4.28,-0.41,2.28,2.12,1.81,2.88,3.31,1.03,-1.41,-1.38,-0.03,-0.03,-0.62,0.41,3.09,3.97,3.28,3.66,6.31,8.47,8.19,7.47,8.31,8.16,4.75,-0.12,-3.22,-4.94,-7.69,-10.34,-9.91,-7.19,-4.88,-4.34,-3.03,0.28,2.34,2.12,1.44,2.66,3.69,1.72,-1.0,-2.5,-2.94,-4.28,-6.62,-6.94,-4.81,-3.31,-3.31,-2.72,-0.47,0.78,-0.81,-3.03,-2.88,-1.56,-1.91,-2.56,-1.25,1.12,1.75,0.91,1.06,2.94,3.59,2.38,1.5,2.5,3.66,2.59,1.41,2.72,5.16,5.69,5.72,6.97,9.34,9.34,7.06,5.62,5.56,4.03,0.16,-3.28,-4.56,-5.88,-8.59,-10.47,-9.09,-6.5,-4.62,-3.88,-1.88,0.81,1.38,-0.09,-1.5,-0.59,-0.47,-2.38,-3.88,-2.53,-0.66,-0.94,-1.53,-0.16,1.22,0.28,-2.09,-3.06,-2.25,-2.28,-3.38,-4.0,-2.44,-1.44,-3.31,-5.16,-4.88,-3.88,-4.59,-5.62,-3.97,-0.88,0.81,1.06,2.91,6.06,7.81,7.0,6.28,7.59,7.84,5.94,3.56,3.38,3.28,0.91,-2.16,-2.88,-1.88,-1.75,-1.75,-0.34,2.94,4.81,3.78,2.22,2.0,1.44,-0.69,-2.0,0.19,4.0,5.91,6.62,8.0,9.72,9.03,6.31,4.16,4.22,3.59,1.28,-0.12,1.0,2.69,2.72,2.66,5.47,9.22,10.97,11.19,12.66,14.78,15.03,13.09,11.81,11.97,10.97,7.66,4.94,5.16,6.34,6.0,5.38,7.22,9.31,9.88,8.81,9.25,10.47,10.16,7.94,5.91,6.56,6.34,4.56,3.06,4.22,5.69,5.03,3.72,4.0,5.09,4.62,3.03,3.47,5.97,7.91,8.12,8.88,11.0,12.0,9.97,7.75,7.41,7.5,6.12,4.09,4.25,5.31,5.22,2.72,1.38,1.72,1.56,0.09,-0.12,2.88,6.03,6.78,6.97,9.16,10.66,10.19,8.56,8.16,9.16,8.69,6.91,6.78,8.41,9.88,9.22,8.62,9.97,10.75,8.88,6.66,6.53,7.06,6.78,5.97,7.41,10.03,11.31,10.19,9.56,10.38,9.94,6.88,3.97,3.19,2.56,0.09,-2.31,-1.94,-0.47,0.41,0.16,1.72,4.72,6.16,5.44,5.66,7.84,9.31,8.44,7.59,8.44,9.16,7.72,5.81,5.84,7.19,7.69,6.59,7.31,9.34,10.16,8.03,6.34,6.62,6.22,3.5,1.66,2.91,5.25,6.38,7.5,10.59,14.38,16.25,15.88,16.09,16.94,16.66,13.78,11.84,12.44,13.12,11.84,10.75,11.69,13.03,12.47,10.81,10.62,11.47,10.97,8.44,7.0,7.53,7.25,5.12,3.81,4.44,5.12,3.41,1.75,2.31,3.78,3.72,2.56,2.62,3.94,4.25,3.09,3.44,5.72,7.47,6.75,5.91,6.94,7.62,6.09,4.31,4.59,5.94,5.53,3.91,3.94,4.91,4.97,3.06,2.97,4.56,6.03,5.19,4.22,5.28,6.12,4.69,2.91,2.94,3.75,2.78,0.75,-0.16,0.53,0.53,-1.03,-1.72,0.06,1.66,1.44,1.66,4.03,7.03,7.19,6.66,7.41,8.53,8.12,6.38,6.0,7.31,8.03,7.0,6.34,7.69,8.28,5.97,3.25,2.88,3.28,2.91,2.81,4.91,8.41,10.5,11.06,12.53,15.41,17.22,16.75,16.25,26.16,23.72,20.53,15.81,11.81,9.72,9.19,8.5,8.72,11.28,15.19,18.34,20.75,24.22:4.22,2.03,1.19,-1.25,-4.47,-5.94,-6.78,-9.12,-12.78,-14.72,-13.78,-12.56,-12.09,-10.0,-5.28,0.38,4.59,8.88,15.44,21.97,25.81,26.94,27.75,27.53,23.72,17.12,9.97,3.81,-2.62,-10.44,-16.97,-20.19,-21.78,-24.22,-25.5,-23.59,-19.69,-16.5,-12.88,-7.16,0.22,6.31,10.25,13.59,17.09,18.69,17.0,14.41,12.81,11.62,8.25,4.47,2.94,3.06,1.97,-0.19,-0.84,-0.47,-2.03,-5.19,-8.12,-9.22,-10.25,-12.34,-13.38,-11.09,-7.38,-4.47,-2.16,1.94,6.59,9.22,10.12,11.44,13.38,13.72,11.75,9.81,9.09,7.53,2.97,-2.62,-6.5,-9.16,-13.03,-15.66,-15.09,-11.88,-9.28,-7.31,-3.66,1.25,5.06,5.97,6.94,8.88,9.44,7.38,5.22,4.44,4.75,3.44,1.56,0.81,0.59,-1.53,-5.66,-8.62,-9.28,-9.34,-10.22,-9.53,-6.41,-2.84,-1.25,-0.94,0.56,2.44,1.56,-0.5,-1.5,-0.88,-1.31,-3.0,-3.78,-2.72,-2.5,-4.75,-7.28,-8.44,-9.53,-12.19,-15.03,-15.53,-14.09,-13.19,-12.78,-10.59,-6.19,-2.47,-0.78,1.44,4.78,6.66,5.5,3.44,2.59,2.12,0.12,-2.34,-2.84,-1.81,-2.0,-3.5,-3.59,-1.88,-0.94,-1.56,-1.66,0.16,1.5,1.0,0.22,1.62,4.06,4.62,4.12,4.72,5.94,4.81,2.75,2.12,3.88,4.97,4.28,3.25,3.47,3.38,1.41,-0.31,0.5,2.22,2.28,1.41,1.59,2.78,3.03,1.88,1.47,3.59,5.91,6.47,7.69,10.78,13.25,12.84,11.19,10.66,10.53,8.97,6.38,5.34,5.97,5.28,3.28,1.91,2.69,3.22,2.25,1.53,3.0,4.78,4.56,3.78,5.12,7.56,8.66,8.53,10.06,12.5,13.31,11.69,10.16,10.03,9.09,6.56,4.41,4.34,5.12,4.84,4.0,5.59,8.84,10.75,11.06,12.12,13.88,13.66,10.91,8.03,7.44,6.69,4.78,3.03,4.03,5.94,6.25,5.78,6.28,7.91,7.94,6.06,5.03,5.75,4.94,2.25,-0.44,-0.88,-1.38,-3.5,-5.34,-4.44,-2.5,-1.53,-0.38,1.72,5.56,7.94,8.12,8.31,9.38,9.38,7.0,4.72,4.56,4.53,2.78,0.53,0.47,1.47,1.47,1.03,1.75,3.84,4.88,3.69,2.53,3.16,3.19,1.5,0.53,1.94,3.75,3.56,2.28,2.06,2.84,2.31,0.75,0.75,2.62,3.25,1.56,0.34,0.88,0.69,-0.75,-2.06,-0.91,0.59,-0.53,-3.09,-4.53,-5.41,-7.38,-9.56,-9.72,-7.62,-5.62,-5.5,-5.25,-3.38,-2.34,-3.38,-4.78,-3.5,-1.78,-1.62,-2.78,-2.62,-1.94,-3.06,-5.88,-7.59,-6.78,-6.25,-6.81,-6.53,-4.44,-2.41,-2.97,-4.78,-4.53,-4.0,-4.44,-5.12,-3.94,-1.0,0.72,0.34,0.22,1.88,2.34,1.31,0.38,1.75,3.72,3.47,2.59,3.19,4.16,3.09,0.53,-0.56,-0.56,-1.5,-3.59,-5.06,-4.53,-4.09,-5.91,-7.41,-6.69,-5.09,-4.94,-5.5,-4.12,-2.19,-2.06,-3.94,-4.75,-4.78,-5.59,-7.97,-9.72,-8.47,-6.97,-7.19,-7.62,-6.41,-5.19,-6.25,-8.25,-8.34,-6.94,-6.38,-7.19,-6.72,-4.72,-3.69,-5.06,-5.56,-4.09,-2.66,-3.56,-5.22,-5.47,-5.28,-7.5,-10.06,-10.03,-8.66,-7.16,-7.47,-6.72,-4.78,-3.59,-4.25,-4.75,-3.19,-1.47,-2.19,-3.72,-3.88,-3.16,-4.03,-5.78,-5.84,-4.25,-4.09,-5.84,-6.97,-6.88,-7.31,-9.84,-11.94,-11.06,-9.47,-9.19,-8.72,-6.59,-3.0,-1.22,-1.06,0.09,1.56,1.28,-1.97,-5.19,-7.0,-8.91,-12.25,-14.34,-13.22,-10.03,-8.03,-6.16,-3.09,0.03,0.84,-0.47,-1.25,-0.78,-1.12,-3.97,-6.06,-5.78,-4.91,-5.72,-6.12,-3.94,-1.0,-0.09,-0.41,1.22,3.69,4.25,3.03,2.5,3.03,3.09,0.34,-1.22,-0.94,-0.12,-1.0,-1.75,0.53,4.22,6.44,7.88,10.62,14.0,14.62,12.09,9.44,7.62,4.78,0.16,-3.03,-3.31,-2.41,-3.28,-4.62,-4.22,-3.22,-3.97,-5.91,-5.97,-4.41,-3.81,-4.84,-5.06,-3.41,-2.66,-4.12,-5.72,-5.44,-4.66,-5.69,-6.81,-6.28,-5.31,-6.59,-9.56,-11.56,-11.84,-13.06,-15.94,-17.47,-16.28,-14.59,-14.28,-13.0,-9.31,-4.91,-3.12,-2.97,-1.5,0.12,0.25,-1.22,-0.59,2.0,4.03,4.16,4.81,6.75,8.25,6.72,4.78,4.22,3.88,1.09,-1.91,-3.22,-2.94,-3.06,-3.66,-2.78,0.62,3.5,4.16,4.78,7.03,8.22,6.72,4.66,4.12,4.72,3.56,2.34,3.34,6.25,8.0,8.5,9.31,11.5,12.5,11.22,10.09,11.22,12.62,11.38,8.97,8.06,7.56,5.12,2.09,1.19,2.03,2.84,2.03,2.59,5.31,7.16,5.88,3.78,3.59,3.75,1.66,-0.44,-0.81,0.31,-0.81,-2.97,-3.97,-2.81,-2.88,-4.84,-6.12,-5.31,-5.16,-7.12,-8.97,-8.5,-7.62,-8.75,-11.12,-11.97,-11.81,-13.28,-15.09,-14.62,-11.41,-8.28,-6.94,-5.31,-2.59,-1.12,-2.5,-4.44,-4.09,-2.72,-3.03,-3.84,-3.41,-1.97,-3.0,-5.59,-7.12,-6.72,-6.66,-8.47,-9.97,-9.25,-8.38,-9.31,-10.53,-9.16,-6.59,-5.75,-5.19,-3.34,0.03,1.53,0.78,0.0,0.38,-0.19,-3.75,-7.5,-9.31,-10.16,-12.62,-14.56,-13.59,-10.97,-9.69,-8.91,-5.94,-0.59,4.0,7.03,10.91,16.53,20.25,20.34,18.91,18.22,16.31,11.19,4.97,0.31,-3.19,-8.28,-13.84,-17.5,-18.72,-20.56,-23.22,-24.81,-23.34,-21.53,-21.16,-20.47,-16.94,-12.19,-8.88,-5.59,-0.41,5.91,10.16,12.22,14.62,17.34,17.94,15.19,11.41,8.56,4.66,-1.94,-8.5,-11.84,-13.16,-14.62,-15.62,-13.53,-9.75,-7.38,-6.38,-4.28,-0.41,2.28,2.12,1.81,2.88,3.31,1.03,-1.41,-1.38,-0.03,-0.03,-0.62,0.41,3.09,3.97,3.28,3.66,6.31,8.47,8.19,7.47,8.31,8.16,4.75,-0.12,-3.22,-4.94,-7.69,-10.34,-9.91,-7.19,-4.88,-4.34,-3.03,0.28,2.34,2.12,1.44,2.66,3.69,1.72,-1.0,-2.5,-2.94,-4.28,-6.62,-6.94,-4.81,-3.31,-3.31,-2.72,-0.47,0.78,-0.81,-3.03,-2.88,-1.56,-1.91,-2.56,-1.25,1.12,1.75,0.91,1.06,2.94,3.59,2.38,1.5,2.5,3.66,2.59,1.41,2.72,5.16,5.69,5.72,6.97,9.34,9.34,7.06,5.62,5.56,4.03,0.16,-3.28,-4.56,-5.88,-8.59,-10.47,-9.09,-6.5,-4.62,-3.88,-1.88,0.81,1.38,-0.09,-1.5,-0.59,-0.47,-2.38,-3.88,-2.53,-0.66,-0.94,-1.53,-0.16,1.22,0.28,-2.09,-3.06,-2.25,-2.28,-3.38,-4.0,-2.44,-1.44,-3.31,-5.16,-4.88,-3.88,-4.59,-5.62,-3.97,-0.88,0.81,1.06,2.91,6.06,7.81,7.0,6.28,7.59,7.84,5.94,3.56,3.38,3.28,0.91,-2.16,-2.88,-1.88,-1.75,-1.75,-0.34,2.94,4.81,3.78,2.22,2.0,1.44,-0.69,-2.0,0.19,4.0,5.91,6.62,8.0,9.72,9.03,6.31,4.16,4.22,3.59,1.28,-0.12,1.0,2.69,2.72,2.66,5.47,9.22,10.97,11.19,12.66,14.78,15.03,13.09,11.81,11.97,10.97,7.66,4.94,5.16,6.34,6.0,5.38,7.22,9.31,9.88,8.81,9.25,10.47,10.16,7.94,5.91,6.56,6.34,4.56,3.06,4.22,5.69,5.03,3.72,4.0,5.09,4.62,3.03,3.47,5.97,7.91,8.12,8.88,11.0,12.0,9.97,7.75,7.41,7.5,6.12,4.09,4.25,5.31,5.22,2.72,1.38,1.72,1.56,0.09,-0.12,2.88,6.03,6.78,6.97,9.16,10.66,10.19,8.56,8.16,9.16,8.69,6.91,6.78,8.41,9.88,9.22,8.62,9.97,10.75,8.88,6.66,6.53,7.06,6.78,5.97,7.41,10.03,11.31,10.19,9.56,10.38,9.94,6.88,3.97,3.19,2.56,0.09,-2.31,-1.94,-0.47,0.41,0.16,1.72,4.72,6.16,5.44,5.66,7.84,9.31,8.44,7.59,8.44,9.16,7.72,5.81,5.84,7.19,7.69,6.59,7.31,9.34,10.16,8.03,6.34,6.62,6.22,3.5,1.66,2.91,5.25,6.38,7.5,10.59,14.38,16.25,15.88,16.09,16.94,16.66,13.78,11.84,12.44,13.12,11.84,10.75,11.69,13.03,12.47,10.81,10.62,11.47,10.97,8.44,7.0,7.53,7.25,5.12,3.81,4.44,5.12,3.41,1.75,2.31,3.78,3.72,2.56,2.62,3.94,4.25,3.09,3.44,5.72,7.47,6.75,5.91,6.94,7.62,6.09,4.31,4.59,5.94,5.53,3.91,3.94,4.91,4.97,3.06,2.97,4.56,6.03,5.19,4.22,5.28,6.12,4.69,2.91,2.94,3.75,2.78,0.75,-0.16,0.53,0.53,-1.03,-1.72,0.06,1.66,1.44,1.66,4.03,7.03,7.19,6.66,7.41,8.53,8.12,6.38,6.0,7.31,8.03,7.0,6.34,7.69,8.28,5.97,3.25,2.88,3.28,2.91,2.81,4.91,8.41,10.5,11.06,12.53,15.41,17.22,16.75,16.25,26.16,23.72,20.53,15.81,11.81,9.72,9.19,8.5,8.72,11.28,15.19,18.34,20.75,24.22,27.88,29.88,29.91,29.28,28.38,26.5,22.66:-9.12,-12.78,-14.72,-13.78,-12.56,-12.09,-10.0,-5.28,0.38,4.59,8.88,15.44,21.97,25.81,26.94,27.75,27.53,23.72,17.12,9.97,3.81,-2.62,-10.44,-16.97,-20.19,-21.78,-24.22,-25.5,-23.59,-19.69,-16.5,-12.88,-7.16,0.22,6.31,10.25,13.59,17.09,18.69,17.0,14.41,12.81,11.62,8.25,4.47,2.94,3.06,1.97,-0.19,-0.84,-0.47,-2.03,-5.19,-8.12,-9.22,-10.25,-12.34,-13.38,-11.09,-7.38,-4.47,-2.16,1.94,6.59,9.22,10.12,11.44,13.38,13.72,11.75,9.81,9.09,7.53,2.97,-2.62,-6.5,-9.16,-13.03,-15.66,-15.09,-11.88,-9.28,-7.31,-3.66,1.25,5.06,5.97,6.94,8.88,9.44,7.38,5.22,4.44,4.75,3.44,1.56,0.81,0.59,-1.53,-5.66,-8.62,-9.28,-9.34,-10.22,-9.53,-6.41,-2.84,-1.25,-0.94,0.56,2.44,1.56,-0.5,-1.5,-0.88,-1.31,-3.0,-3.78,-2.72,-2.5,-4.75,-7.28,-8.44,-9.53,-12.19,-15.03,-15.53,-14.09,-13.19,-12.78,-10.59,-6.19,-2.47,-0.78,1.44,4.78,6.66,5.5,3.44,2.59,2.12,0.12,-2.34,-2.84,-1.81,-2.0,-3.5,-3.59,-1.88,-0.94,-1.56,-1.66,0.16,1.5,1.0,0.22,1.62,4.06,4.62,4.12,4.72,5.94,4.81,2.75,2.12,3.88,4.97,4.28,3.25,3.47,3.38,1.41,-0.31,0.5,2.22,2.28,1.41,1.59,2.78,3.03,1.88,1.47,3.59,5.91,6.47,7.69,10.78,13.25,12.84,11.19,10.66,10.53,8.97,6.38,5.34,5.97,5.28,3.28,1.91,2.69,3.22,2.25,1.53,3.0,4.78,4.56,3.78,5.12,7.56,8.66,8.53,10.06,12.5,13.31,11.69,10.16,10.03,9.09,6.56,4.41,4.34,5.12,4.84,4.0,5.59,8.84,10.75,11.06,12.12,13.88,13.66,10.91,8.03,7.44,6.69,4.78,3.03,4.03,5.94,6.25,5.78,6.28,7.91,7.94,6.06,5.03,5.75,4.94,2.25,-0.44,-0.88,-1.38,-3.5,-5.34,-4.44,-2.5,-1.53,-0.38,1.72,5.56,7.94,8.12,8.31,9.38,9.38,7.0,4.72,4.56,4.53,2.78,0.53,0.47,1.47,1.47,1.03,1.75,3.84,4.88,3.69,2.53,3.16,3.19,1.5,0.53,1.94,3.75,3.56,2.28,2.06,2.84,2.31,0.75,0.75,2.62,3.25,1.56,0.34,0.88,0.69,-0.75,-2.06,-0.91,0.59,-0.53,-3.09,-4.53,-5.41,-7.38,-9.56,-9.72,-7.62,-5.62,-5.5,-5.25,-3.38,-2.34,-3.38,-4.78,-3.5,-1.78,-1.62,-2.78,-2.62,-1.94,-3.06,-5.88,-7.59,-6.78,-6.25,-6.81,-6.53,-4.44,-2.41,-2.97,-4.78,-4.53,-4.0,-4.44,-5.12,-3.94,-1.0,0.72,0.34,0.22,1.88,2.34,1.31,0.38,1.75,3.72,3.47,2.59,3.19,4.16,3.09,0.53,-0.56,-0.56,-1.5,-3.59,-5.06,-4.53,-4.09,-5.91,-7.41,-6.69,-5.09,-4.94,-5.5,-4.12,-2.19,-2.06,-3.94,-4.75,-4.78,-5.59,-7.97,-9.72,-8.47,-6.97,-7.19,-7.62,-6.41,-5.19,-6.25,-8.25,-8.34,-6.94,-6.38,-7.19,-6.72,-4.72,-3.69,-5.06,-5.56,-4.09,-2.66,-3.56,-5.22,-5.47,-5.28,-7.5,-10.06,-10.03,-8.66,-7.16,-7.47,-6.72,-4.78,-3.59,-4.25,-4.75,-3.19,-1.47,-2.19,-3.72,-3.88,-3.16,-4.03,-5.78,-5.84,-4.25,-4.09,-5.84,-6.97,-6.88,-7.31,-9.84,-11.94,-11.06,-9.47,-9.19,-8.72,-6.59,-3.0,-1.22,-1.06,0.09,1.56,1.28,-1.97,-5.19,-7.0,-8.91,-12.25,-14.34,-13.22,-10.03,-8.03,-6.16,-3.09,0.03,0.84,-0.47,-1.25,-0.78,-1.12,-3.97,-6.06,-5.78,-4.91,-5.72,-6.12,-3.94,-1.0,-0.09,-0.41,1.22,3.69,4.25,3.03,2.5,3.03,3.09,0.34,-1.22,-0.94,-0.12,-1.0,-1.75,0.53,4.22,6.44,7.88,10.62,14.0,14.62,12.09,9.44,7.62,4.78,0.16,-3.03,-3.31,-2.41,-3.28,-4.62,-4.22,-3.22,-3.97,-5.91,-5.97,-4.41,-3.81,-4.84,-5.06,-3.41,-2.66,-4.12,-5.72,-5.44,-4.66,-5.69,-6.81,-6.28,-5.31,-6.59,-9.56,-11.56,-11.84,-13.06,-15.94,-17.47,-16.28,-14.59,-14.28,-13.0,-9.31,-4.91,-3.12,-2.97,-1.5,0.12,0.25,-1.22,-0.59,2.0,4.03,4.16,4.81,6.75,8.25,6.72,4.78,4.22,3.88,1.09,-1.91,-3.22,-2.94,-3.06,-3.66,-2.78,0.62,3.5,4.16,4.78,7.03,8.22,6.72,4.66,4.12,4.72,3.56,2.34,3.34,6.25,8.0,8.5,9.31,11.5,12.5,11.22,10.09,11.22,12.62,11.38,8.97,8.06,7.56,5.12,2.09,1.19,2.03,2.84,2.03,2.59,5.31,7.16,5.88,3.78,3.59,3.75,1.66,-0.44,-0.81,0.31,-0.81,-2.97,-3.97,-2.81,-2.88,-4.84,-6.12,-5.31,-5.16,-7.12,-8.97,-8.5,-7.62,-8.75,-11.12,-11.97,-11.81,-13.28,-15.09,-14.62,-11.41,-8.28,-6.94,-5.31,-2.59,-1.12,-2.5,-4.44,-4.09,-2.72,-3.03,-3.84,-3.41,-1.97,-3.0,-5.59,-7.12,-6.72,-6.66,-8.47,-9.97,-9.25,-8.38,-9.31,-10.53,-9.16,-6.59,-5.75,-5.19,-3.34,0.03,1.53,0.78,0.0,0.38,-0.19,-3.75,-7.5,-9.31,-10.16,-12.62,-14.56,-13.59,-10.97,-9.69,-8.91,-5.94,-0.59,4.0,7.03,10.91,16.53,20.25,20.34,18.91,18.22,16.31,11.19,4.97,0.31,-3.19,-8.28,-13.84,-17.5,-18.72,-20.56,-23.22,-24.81,-23.34,-21.53,-21.16,-20.47,-16.94,-12.19,-8.88,-5.59,-0.41,5.91,10.16,12.22,14.62,17.34,17.94,15.19,11.41,8.56,4.66,-1.94,-8.5,-11.84,-13.16,-14.62,-15.62,-13.53,-9.75,-7.38,-6.38,-4.28,-0.41,2.28,2.12,1.81,2.88,3.31,1.03,-1.41,-1.38,-0.03,-0.03,-0.62,0.41,3.09,3.97,3.28,3.66,6.31,8.47,8.19,7.47,8.31,8.16,4.75,-0.12,-3.22,-4.94,-7.69,-10.34,-9.91,-7.19,-4.88,-4.34,-3.03,0.28,2.34,2.12,1.44,2.66,3.69,1.72,-1.0,-2.5,-2.94,-4.28,-6.62,-6.94,-4.81,-3.31,-3.31,-2.72,-0.47,0.78,-0.81,-3.03,-2.88,-1.56,-1.91,-2.56,-1.25,1.12,1.75,0.91,1.06,2.94,3.59,2.38,1.5,2.5,3.66,2.59,1.41,2.72,5.16,5.69,5.72,6.97,9.34,9.34,7.06,5.62,5.56,4.03,0.16,-3.28,-4.56,-5.88,-8.59,-10.47,-9.09,-6.5,-4.62,-3.88,-1.88,0.81,1.38,-0.09,-1.5,-0.59,-0.47,-2.38,-3.88,-2.53,-0.66,-0.94,-1.53,-0.16,1.22,0.28,-2.09,-3.06,-2.25,-2.28,-3.38,-4.0,-2.44,-1.44,-3.31,-5.16,-4.88,-3.88,-4.59,-5.62,-3.97,-0.88,0.81,1.06,2.91,6.06,7.81,7.0,6.28,7.59,7.84,5.94,3.56,3.38,3.28,0.91,-2.16,-2.88,-1.88,-1.75,-1.75,-0.34,2.94,4.81,3.78,2.22,2.0,1.44,-0.69,-2.0,0.19,4.0,5.91,6.62,8.0,9.72,9.03,6.31,4.16,4.22,3.59,1.28,-0.12,1.0,2.69,2.72,2.66,5.47,9.22,10.97,11.19,12.66,14.78,15.03,13.09,11.81,11.97,10.97,7.66,4.94,5.16,6.34,6.0,5.38,7.22,9.31,9.88,8.81,9.25,10.47,10.16,7.94,5.91,6.56,6.34,4.56,3.06,4.22,5.69,5.03,3.72,4.0,5.09,4.62,3.03,3.47,5.97,7.91,8.12,8.88,11.0,12.0,9.97,7.75,7.41,7.5,6.12,4.09,4.25,5.31,5.22,2.72,1.38,1.72,1.56,0.09,-0.12,2.88,6.03,6.78,6.97,9.16,10.66,10.19,8.56,8.16,9.16,8.69,6.91,6.78,8.41,9.88,9.22,8.62,9.97,10.75,8.88,6.66,6.53,7.06,6.78,5.97,7.41,10.03,11.31,10.19,9.56,10.38,9.94,6.88,3.97,3.19,2.56,0.09,-2.31,-1.94,-0.47,0.41,0.16,1.72,4.72,6.16,5.44,5.66,7.84,9.31,8.44,7.59,8.44,9.16,7.72,5.81,5.84,7.19,7.69,6.59,7.31,9.34,10.16,8.03,6.34,6.62,6.22,3.5,1.66,2.91,5.25,6.38,7.5,10.59,14.38,16.25,15.88,16.09,16.94,16.66,13.78,11.84,12.44,13.12,11.84,10.75,11.69,13.03,12.47,10.81,10.62,11.47,10.97,8.44,7.0,7.53,7.25,5.12,3.81,4.44,5.12,3.41,1.75,2.31,3.78,3.72,2.56,2.62,3.94,4.25,3.09,3.44,5.72,7.47,6.75,5.91,6.94,7.62,6.09,4.31,4.59,5.94,5.53,3.91,3.94,4.91,4.97,3.06,2.97,4.56,6.03,5.19,4.22,5.28,6.12,4.69,2.91,2.94,3.75,2.78,0.75,-0.16,0.53,0.53,-1.03,-1.72,0.06,1.66,1.44,1.66,4.03,7.03,7.19,6.66,7.41,8.53,8.12,6.38,6.0,7.31,8.03,7.0,6.34,7.69,8.28,5.97,3.25,2.88,3.28,2.91,2.81,4.91,8.41,10.5,11.06,12.53,15.41,17.22,16.75,16.25,26.16,23.72,20.53,15.81,11.81,9.72,9.19,8.5,8.72,11.28,15.19,18.34,20.75,24.22,27.88,29.88,29.91,29.28,28.38,26.5,22.66,18.62,16.28,14.97,12.91,11.12,10.72,10.66:-5.28,0.38,4.59,8.88,15.44,21.97,25.81,26.94,27.75,27.53,23.72,17.12,9.97,3.81,-2.62,-10.44,-16.97,-20.19,-21.78,-24.22,-25.5,-23.59,-19.69,-16.5,-12.88,-7.16,0.22,6.31,10.25,13.59,17.09,18.69,17.0,14.41,12.81,11.62,8.25,4.47,2.94,3.06,1.97,-0.19,-0.84,-0.47,-2.03,-5.19,-8.12,-9.22,-10.25,-12.34,-13.38,-11.09,-7.38,-4.47,-2.16,1.94,6.59,9.22,10.12,11.44,13.38,13.72,11.75,9.81,9.09,7.53,2.97,-2.62,-6.5,-9.16,-13.03,-15.66,-15.09,-11.88,-9.28,-7.31,-3.66,1.25,5.06,5.97,6.94,8.88,9.44,7.38,5.22,4.44,4.75,3.44,1.56,0.81,0.59,-1.53,-5.66,-8.62,-9.28,-9.34,-10.22,-9.53,-6.41,-2.84,-1.25,-0.94,0.56,2.44,1.56,-0.5,-1.5,-0.88,-1.31,-3.0,-3.78,-2.72,-2.5,-4.75,-7.28,-8.44,-9.53,-12.19,-15.03,-15.53,-14.09,-13.19,-12.78,-10.59,-6.19,-2.47,-0.78,1.44,4.78,6.66,5.5,3.44,2.59,2.12,0.12,-2.34,-2.84,-1.81,-2.0,-3.5,-3.59,-1.88,-0.94,-1.56,-1.66,0.16,1.5,1.0,0.22,1.62,4.06,4.62,4.12,4.72,5.94,4.81,2.75,2.12,3.88,4.97,4.28,3.25,3.47,3.38,1.41,-0.31,0.5,2.22,2.28,1.41,1.59,2.78,3.03,1.88,1.47,3.59,5.91,6.47,7.69,10.78,13.25,12.84,11.19,10.66,10.53,8.97,6.38,5.34,5.97,5.28,3.28,1.91,2.69,3.22,2.25,1.53,3.0,4.78,4.56,3.78,5.12,7.56,8.66,8.53,10.06,12.5,13.31,11.69,10.16,10.03,9.09,6.56,4.41,4.34,5.12,4.84,4.0,5.59,8.84,10.75,11.06,12.12,13.88,13.66,10.91,8.03,7.44,6.69,4.78,3.03,4.03,5.94,6.25,5.78,6.28,7.91,7.94,6.06,5.03,5.75,4.94,2.25,-0.44,-0.88,-1.38,-3.5,-5.34,-4.44,-2.5,-1.53,-0.38,1.72,5.56,7.94,8.12,8.31,9.38,9.38,7.0,4.72,4.56,4.53,2.78,0.53,0.47,1.47,1.47,1.03,1.75,3.84,4.88,3.69,2.53,3.16,3.19,1.5,0.53,1.94,3.75,3.56,2.28,2.06,2.84,2.31,0.75,0.75,2.62,3.25,1.56,0.34,0.88,0.69,-0.75,-2.06,-0.91,0.59,-0.53,-3.09,-4.53,-5.41,-7.38,-9.56,-9.72,-7.62,-5.62,-5.5,-5.25,-3.38,-2.34,-3.38,-4.78,-3.5,-1.78,-1.62,-2.78,-2.62,-1.94,-3.06,-5.88,-7.59,-6.78,-6.25,-6.81,-6.53,-4.44,-2.41,-2.97,-4.78,-4.53,-4.0,-4.44,-5.12,-3.94,-1.0,0.72,0.34,0.22,1.88,2.34,1.31,0.38,1.75,3.72,3.47,2.59,3.19,4.16,3.09,0.53,-0.56,-0.56,-1.5,-3.59,-5.06,-4.53,-4.09,-5.91,-7.41,-6.69,-5.09,-4.94,-5.5,-4.12,-2.19,-2.06,-3.94,-4.75,-4.78,-5.59,-7.97,-9.72,-8.47,-6.97,-7.19,-7.62,-6.41,-5.19,-6.25,-8.25,-8.34,-6.94,-6.38,-7.19,-6.72,-4.72,-3.69,-5.06,-5.56,-4.09,-2.66,-3.56,-5.22,-5.47,-5.28,-7.5,-10.06,-10.03,-8.66,-7.16,-7.47,-6.72,-4.78,-3.59,-4.25,-4.75,-3.19,-1.47,-2.19,-3.72,-3.88,-3.16,-4.03,-5.78,-5.84,-4.25,-4.09,-5.84,-6.97,-6.88,-7.31,-9.84,-11.94,-11.06,-9.47,-9.19,-8.72,-6.59,-3.0,-1.22,-1.06,0.09,1.56,1.28,-1.97,-5.19,-7.0,-8.91,-12.25,-14.34,-13.22,-10.03,-8.03,-6.16,-3.09,0.03,0.84,-0.47,-1.25,-0.78,-1.12,-3.97,-6.06,-5.78,-4.91,-5.72,-6.12,-3.94,-1.0,-0.09,-0.41,1.22,3.69,4.25,3.03,2.5,3.03,3.09,0.34,-1.22,-0.94,-0.12,-1.0,-1.75,0.53,4.22,6.44,7.88,10.62,14.0,14.62,12.09,9.44,7.62,4.78,0.16,-3.03,-3.31,-2.41,-3.28,-4.62,-4.22,-3.22,-3.97,-5.91,-5.97,-4.41,-3.81,-4.84,-5.06,-3.41,-2.66,-4.12,-5.72,-5.44,-4.66,-5.69,-6.81,-6.28,-5.31,-6.59,-9.56,-11.56,-11.84,-13.06,-15.94,-17.47,-16.28,-14.59,-14.28,-13.0,-9.31,-4.91,-3.12,-2.97,-1.5,0.12,0.25,-1.22,-0.59,2.0,4.03,4.16,4.81,6.75,8.25,6.72,4.78,4.22,3.88,1.09,-1.91,-3.22,-2.94,-3.06,-3.66,-2.78,0.62,3.5,4.16,4.78,7.03,8.22,6.72,4.66,4.12,4.72,3.56,2.34,3.34,6.25,8.0,8.5,9.31,11.5,12.5,11.22,10.09,11.22,12.62,11.38,8.97,8.06,7.56,5.12,2.09,1.19,2.03,2.84,2.03,2.59,5.31,7.16,5.88,3.78,3.59,3.75,1.66,-0.44,-0.81,0.31,-0.81,-2.97,-3.97,-2.81,-2.88,-4.84,-6.12,-5.31,-5.16,-7.12,-8.97,-8.5,-7.62,-8.75,-11.12,-11.97,-11.81,-13.28,-15.09,-14.62,-11.41,-8.28,-6.94,-5.31,-2.59,-1.12,-2.5,-4.44,-4.09,-2.72,-3.03,-3.84,-3.41,-1.97,-3.0,-5.59,-7.12,-6.72,-6.66,-8.47,-9.97,-9.25,-8.38,-9.31,-10.53,-9.16,-6.59,-5.75,-5.19,-3.34,0.03,1.53,0.78,0.0,0.38,-0.19,-3.75,-7.5,-9.31,-10.16,-12.62,-14.56,-13.59,-10.97,-9.69,-8.91,-5.94,-0.59,4.0,7.03,10.91,16.53,20.25,20.34,18.91,18.22,16.31,11.19,4.97,0.31,-3.19,-8.28,-13.84,-17.5,-18.72,-20.56,-23.22,-24.81,-23.34,-21.53,-21.16,-20.47,-16.94,-12.19,-8.88,-5.59,-0.41,5.91,10.16,12.22,14.62,17.34,17.94,15.19,11.41,8.56,4.66,-1.94,-8.5,-11.84,-13.16,-14.62,-15.62,-13.53,-9.75,-7.38,-6.38,-4.28,-0.41,2.28,2.12,1.81,2.88,3.31,1.03,-1.41,-1.38,-0.03,-0.03,-0.62,0.41,3.09,3.97,3.28,3.66,6.31,8.47,8.19,7.47,8.31,8.16,4.75,-0.12,-3.22,-4.94,-7.69,-10.34,-9.91,-7.19,-4.88,-4.34,-3.03,0.28,2.34,2.12,1.44,2.66,3.69,1.72,-1.0,-2.5,-2.94,-4.28,-6.62,-6.94,-4.81,-3.31,-3.31,-2.72,-0.47,0.78,-0.81,-3.03,-2.88,-1.56,-1.91,-2.56,-1.25,1.12,1.75,0.91,1.06,2.94,3.59,2.38,1.5,2.5,3.66,2.59,1.41,2.72,5.16,5.69,5.72,6.97,9.34,9.34,7.06,5.62,5.56,4.03,0.16,-3.28,-4.56,-5.88,-8.59,-10.47,-9.09,-6.5,-4.62,-3.88,-1.88,0.81,1.38,-0.09,-1.5,-0.59,-0.47,-2.38,-3.88,-2.53,-0.66,-0.94,-1.53,-0.16,1.22,0.28,-2.09,-3.06,-2.25,-2.28,-3.38,-4.0,-2.44,-1.44,-3.31,-5.16,-4.88,-3.88,-4.59,-5.62,-3.97,-0.88,0.81,1.06,2.91,6.06,7.81,7.0,6.28,7.59,7.84,5.94,3.56,3.38,3.28,0.91,-2.16,-2.88,-1.88,-1.75,-1.75,-0.34,2.94,4.81,3.78,2.22,2.0,1.44,-0.69,-2.0,0.19,4.0,5.91,6.62,8.0,9.72,9.03,6.31,4.16,4.22,3.59,1.28,-0.12,1.0,2.69,2.72,2.66,5.47,9.22,10.97,11.19,12.66,14.78,15.03,13.09,11.81,11.97,10.97,7.66,4.94,5.16,6.34,6.0,5.38,7.22,9.31,9.88,8.81,9.25,10.47,10.16,7.94,5.91,6.56,6.34,4.56,3.06,4.22,5.69,5.03,3.72,4.0,5.09,4.62,3.03,3.47,5.97,7.91,8.12,8.88,11.0,12.0,9.97,7.75,7.41,7.5,6.12,4.09,4.25,5.31,5.22,2.72,1.38,1.72,1.56,0.09,-0.12,2.88,6.03,6.78,6.97,9.16,10.66,10.19,8.56,8.16,9.16,8.69,6.91,6.78,8.41,9.88,9.22,8.62,9.97,10.75,8.88,6.66,6.53,7.06,6.78,5.97,7.41,10.03,11.31,10.19,9.56,10.38,9.94,6.88,3.97,3.19,2.56,0.09,-2.31,-1.94,-0.47,0.41,0.16,1.72,4.72,6.16,5.44,5.66,7.84,9.31,8.44,7.59,8.44,9.16,7.72,5.81,5.84,7.19,7.69,6.59,7.31,9.34,10.16,8.03,6.34,6.62,6.22,3.5,1.66,2.91,5.25,6.38,7.5,10.59,14.38,16.25,15.88,16.09,16.94,16.66,13.78,11.84,12.44,13.12,11.84,10.75,11.69,13.03,12.47,10.81,10.62,11.47,10.97,8.44,7.0,7.53,7.25,5.12,3.81,4.44,5.12,3.41,1.75,2.31,3.78,3.72,2.56,2.62,3.94,4.25,3.09,3.44,5.72,7.47,6.75,5.91,6.94,7.62,6.09,4.31,4.59,5.94,5.53,3.91,3.94,4.91,4.97,3.06,2.97,4.56,6.03,5.19,4.22,5.28,6.12,4.69,2.91,2.94,3.75,2.78,0.75,-0.16,0.53,0.53,-1.03,-1.72,0.06,1.66,1.44,1.66,4.03,7.03,7.19,6.66,7.41,8.53,8.12,6.38,6.0,7.31,8.03,7.0,6.34,7.69,8.28,5.97,3.25,2.88,3.28,2.91,2.81,4.91,8.41,10.5,11.06,12.53,15.41,17.22,16.75,16.25,26.16,23.72,20.53,15.81,11.81,9.72,9.19,8.5,8.72,11.28,15.19,18.34,20.75,24.22,27.88,29.88,29.91,29.28,28.38,26.5,22.66,18.62,16.28,14.97,12.91,11.12,10.72,10.66,9.06,6.53,4.66,3.88,3.0,1.72,1.88:26.94,27.75,27.53,23.72,17.12,9.97,3.81,-2.62,-10.44,-16.97,-20.19,-21.78,-24.22,-25.5,-23.59,-19.69,-16.5,-12.88,-7.16,0.22,6.31,10.25,13.59,17.09,18.69,17.0,14.41,12.81,11.62,8.25,4.47,2.94,3.06,1.97,-0.19,-0.84,-0.47,-2.03,-5.19,-8.12,-9.22,-10.25,-12.34,-13.38,-11.09,-7.38,-4.47,-2.16,1.94,6.59,9.22,10.12,11.44,13.38,13.72,11.75,9.81,9.09,7.53,2.97,-2.62,-6.5,-9.16,-13.03,-15.66,-15.09,-11.88,-9.28,-7.31,-3.66,1.25,5.06,5.97,6.94,8.88,9.44,7.38,5.22,4.44,4.75,3.44,1.56,0.81,0.59,-1.53,-5.66,-8.62,-9.28,-9.34,-10.22,-9.53,-6.41,-2.84,-1.25,-0.94,0.56,2.44,1.56,-0.5,-1.5,-0.88,-1.31,-3.0,-3.78,-2.72,-2.5,-4.75,-7.28,-8.44,-9.53,-12.19,-15.03,-15.53,-14.09,-13.19,-12.78,-10.59,-6.19,-2.47,-0.78,1.44,4.78,6.66,5.5,3.44,2.59,2.12,0.12,-2.34,-2.84,-1.81,-2.0,-3.5,-3.59,-1.88,-0.94,-1.56,-1.66,0.16,1.5,1.0,0.22,1.62,4.06,4.62,4.12,4.72,5.94,4.81,2.75,2.12,3.88,4.97,4.28,3.25,3.47,3.38,1.41,-0.31,0.5,2.22,2.28,1.41,1.59,2.78,3.03,1.88,1.47,3.59,5.91,6.47,7.69,10.78,13.25,12.84,11.19,10.66,10.53,8.97,6.38,5.34,5.97,5.28,3.28,1.91,2.69,3.22,2.25,1.53,3.0,4.78,4.56,3.78,5.12,7.56,8.66,8.53,10.06,12.5,13.31,11.69,10.16,10.03,9.09,6.56,4.41,4.34,5.12,4.84,4.0,5.59,8.84,10.75,11.06,12.12,13.88,13.66,10.91,8.03,7.44,6.69,4.78,3.03,4.03,5.94,6.25,5.78,6.28,7.91,7.94,6.06,5.03,5.75,4.94,2.25,-0.44,-0.88,-1.38,-3.5,-5.34,-4.44,-2.5,-1.53,-0.38,1.72,5.56,7.94,8.12,8.31,9.38,9.38,7.0,4.72,4.56,4.53,2.78,0.53,0.47,1.47,1.47,1.03,1.75,3.84,4.88,3.69,2.53,3.16,3.19,1.5,0.53,1.94,3.75,3.56,2.28,2.06,2.84,2.31,0.75,0.75,2.62,3.25,1.56,0.34,0.88,0.69,-0.75,-2.06,-0.91,0.59,-0.53,-3.09,-4.53,-5.41,-7.38,-9.56,-9.72,-7.62,-5.62,-5.5,-5.25,-3.38,-2.34,-3.38,-4.78,-3.5,-1.78,-1.62,-2.78,-2.62,-1.94,-3.06,-5.88,-7.59,-6.78,-6.25,-6.81,-6.53,-4.44,-2.41,-2.97,-4.78,-4.53,-4.0,-4.44,-5.12,-3.94,-1.0,0.72,0.34,0.22,1.88,2.34,1.31,0.38,1.75,3.72,3.47,2.59,3.19,4.16,3.09,0.53,-0.56,-0.56,-1.5,-3.59,-5.06,-4.53,-4.09,-5.91,-7.41,-6.69,-5.09,-4.94,-5.5,-4.12,-2.19,-2.06,-3.94,-4.75,-4.78,-5.59,-7.97,-9.72,-8.47,-6.97,-7.19,-7.62,-6.41,-5.19,-6.25,-8.25,-8.34,-6.94,-6.38,-7.19,-6.72,-4.72,-3.69,-5.06,-5.56,-4.09,-2.66,-3.56,-5.22,-5.47,-5.28,-7.5,-10.06,-10.03,-8.66,-7.16,-7.47,-6.72,-4.78,-3.59,-4.25,-4.75,-3.19,-1.47,-2.19,-3.72,-3.88,-3.16,-4.03,-5.78,-5.84,-4.25,-4.09,-5.84,-6.97,-6.88,-7.31,-9.84,-11.94,-11.06,-9.47,-9.19,-8.72,-6.59,-3.0,-1.22,-1.06,0.09,1.56,1.28,-1.97,-5.19,-7.0,-8.91,-12.25,-14.34,-13.22,-10.03,-8.03,-6.16,-3.09,0.03,0.84,-0.47,-1.25,-0.78,-1.12,-3.97,-6.06,-5.78,-4.91,-5.72,-6.12,-3.94,-1.0,-0.09,-0.41,1.22,3.69,4.25,3.03,2.5,3.03,3.09,0.34,-1.22,-0.94,-0.12,-1.0,-1.75,0.53,4.22,6.44,7.88,10.62,14.0,14.62,12.09,9.44,7.62,4.78,0.16,-3.03,-3.31,-2.41,-3.28,-4.62,-4.22,-3.22,-3.97,-5.91,-5.97,-4.41,-3.81,-4.84,-5.06,-3.41,-2.66,-4.12,-5.72,-5.44,-4.66,-5.69,-6.81,-6.28,-5.31,-6.59,-9.56,-11.56,-11.84,-13.06,-15.94,-17.47,-16.28,-14.59,-14.28,-13.0,-9.31,-4.91,-3.12,-2.97,-1.5,0.12,0.25,-1.22,-0.59,2.0,4.03,4.16,4.81,6.75,8.25,6.72,4.78,4.22,3.88,1.09,-1.91,-3.22,-2.94,-3.06,-3.66,-2.78,0.62,3.5,4.16,4.78,7.03,8.22,6.72,4.66,4.12,4.72,3.56,2.34,3.34,6.25,8.0,8.5,9.31,11.5,12.5,11.22,10.09,11.22,12.62,11.38,8.97,8.06,7.56,5.12,2.09,1.19,2.03,2.84,2.03,2.59,5.31,7.16,5.88,3.78,3.59,3.75,1.66,-0.44,-0.81,0.31,-0.81,-2.97,-3.97,-2.81,-2.88,-4.84,-6.12,-5.31,-5.16,-7.12,-8.97,-8.5,-7.62,-8.75,-11.12,-11.97,-11.81,-13.28,-15.09,-14.62,-11.41,-8.28,-6.94,-5.31,-2.59,-1.12,-2.5,-4.44,-4.09,-2.72,-3.03,-3.84,-3.41,-1.97,-3.0,-5.59,-7.12,-6.72,-6.66,-8.47,-9.97,-9.25,-8.38,-9.31,-10.53,-9.16,-6.59,-5.75,-5.19,-3.34,0.03,1.53,0.78,0.0,0.38,-0.19,-3.75,-7.5,-9.31,-10.16,-12.62,-14.56,-13.59,-10.97,-9.69,-8.91,-5.94,-0.59,4.0,7.03,10.91,16.53,20.25,20.34,18.91,18.22,16.31,11.19,4.97,0.31,-3.19,-8.28,-13.84,-17.5,-18.72,-20.56,-23.22,-24.81,-23.34,-21.53,-21.16,-20.47,-16.94,-12.19,-8.88,-5.59,-0.41,5.91,10.16,12.22,14.62,17.34,17.94,15.19,11.41,8.56,4.66,-1.94,-8.5,-11.84,-13.16,-14.62,-15.62,-13.53,-9.75,-7.38,-6.38,-4.28,-0.41,2.28,2.12,1.81,2.88,3.31,1.03,-1.41,-1.38,-0.03,-0.03,-0.62,0.41,3.09,3.97,3.28,3.66,6.31,8.47,8.19,7.47,8.31,8.16,4.75,-0.12,-3.22,-4.94,-7.69,-10.34,-9.91,-7.19,-4.88,-4.34,-3.03,0.28,2.34,2.12,1.44,2.66,3.69,1.72,-1.0,-2.5,-2.94,-4.28,-6.62,-6.94,-4.81,-3.31,-3.31,-2.72,-0.47,0.78,-0.81,-3.03,-2.88,-1.56,-1.91,-2.56,-1.25,1.12,1.75,0.91,1.06,2.94,3.59,2.38,1.5,2.5,3.66,2.59,1.41,2.72,5.16,5.69,5.72,6.97,9.34,9.34,7.06,5.62,5.56,4.03,0.16,-3.28,-4.56,-5.88,-8.59,-10.47,-9.09,-6.5,-4.62,-3.88,-1.88,0.81,1.38,-0.09,-1.5,-0.59,-0.47,-2.38,-3.88,-2.53,-0.66,-0.94,-1.53,-0.16,1.22,0.28,-2.09,-3.06,-2.25,-2.28,-3.38,-4.0,-2.44,-1.44,-3.31,-5.16,-4.88,-3.88,-4.59,-5.62,-3.97,-0.88,0.81,1.06,2.91,6.06,7.81,7.0,6.28,7.59,7.84,5.94,3.56,3.38,3.28,0.91,-2.16,-2.88,-1.88,-1.75,-1.75,-0.34,2.94,4.81,3.78,2.22,2.0,1.44,-0.69,-2.0,0.19,4.0,5.91,6.62,8.0,9.72,9.03,6.31,4.16,4.22,3.59,1.28,-0.12,1.0,2.69,2.72,2.66,5.47,9.22,10.97,11.19,12.66,14.78,15.03,13.09,11.81,11.97,10.97,7.66,4.94,5.16,6.34,6.0,5.38,7.22,9.31,9.88,8.81,9.25,10.47,10.16,7.94,5.91,6.56,6.34,4.56,3.06,4.22,5.69,5.03,3.72,4.0,5.09,4.62,3.03,3.47,5.97,7.91,8.12,8.88,11.0,12.0,9.97,7.75,7.41,7.5,6.12,4.09,4.25,5.31,5.22,2.72,1.38,1.72,1.56,0.09,-0.12,2.88,6.03,6.78,6.97,9.16,10.66,10.19,8.56,8.16,9.16,8.69,6.91,6.78,8.41,9.88,9.22,8.62,9.97,10.75,8.88,6.66,6.53,7.06,6.78,5.97,7.41,10.03,11.31,10.19,9.56,10.38,9.94,6.88,3.97,3.19,2.56,0.09,-2.31,-1.94,-0.47,0.41,0.16,1.72,4.72,6.16,5.44,5.66,7.84,9.31,8.44,7.59,8.44,9.16,7.72,5.81,5.84,7.19,7.69,6.59,7.31,9.34,10.16,8.03,6.34,6.62,6.22,3.5,1.66,2.91,5.25,6.38,7.5,10.59,14.38,16.25,15.88,16.09,16.94,16.66,13.78,11.84,12.44,13.12,11.84,10.75,11.69,13.03,12.47,10.81,10.62,11.47,10.97,8.44,7.0,7.53,7.25,5.12,3.81,4.44,5.12,3.41,1.75,2.31,3.78,3.72,2.56,2.62,3.94,4.25,3.09,3.44,5.72,7.47,6.75,5.91,6.94,7.62,6.09,4.31,4.59,5.94,5.53,3.91,3.94,4.91,4.97,3.06,2.97,4.56,6.03,5.19,4.22,5.28,6.12,4.69,2.91,2.94,3.75,2.78,0.75,-0.16,0.53,0.53,-1.03,-1.72,0.06,1.66,1.44,1.66,4.03,7.03,7.19,6.66,7.41,8.53,8.12,6.38,6.0,7.31,8.03,7.0,6.34,7.69,8.28,5.97,3.25,2.88,3.28,2.91,2.81,4.91,8.41,10.5,11.06,12.53,15.41,17.22,16.75,16.25,26.16,23.72,20.53,15.81,11.81,9.72,9.19,8.5,8.72,11.28,15.19,18.34,20.75,24.22,27.88,29.88,29.91,29.28,28.38,26.5,22.66,18.62,16.28,14.97,12.91,11.12,10.72,10.66,9.06,6.53,4.66,3.88,3.0,1.72,1.88,4.56,8.56,13.19,18.53,25.72,32.72,36.81:negativity
33.12,33.31,35.94,38.75,38.88,37.97,38.88,40.59,40.09,37.66,36.06,35.78,33.69,28.81,24.47,22.41,20.34,16.81,15.03,16.84,21.31,24.22,26.44,30.44,34.5,35.56,34.53,34.69,36.66,37.84,36.69,35.75,36.38,36.47,33.66,30.62,30.0,30.38,28.75,25.91,24.78,24.72,23.34,19.81,17.84,18.47,19.12,17.5,16.94,19.06,21.28,21.19,20.97,23.25,26.5,27.44,27.0,27.91,30.62,31.72,29.88,27.78,27.97,27.38,25.03,23.62,24.88,26.0,23.47,19.28,17.38,17.94,18.03,18.09,20.44,24.88,28.16,29.34,31.25,35.19,39.16,39.53,39.09,40.19,40.94,38.81,35.19,33.28,32.62,30.5,27.19,25.47,26.5,26.81,24.72,23.31,24.28,25.38,23.94,22.25,22.84,24.31,23.78,22.56,23.0,25.06,25.03,22.47,20.38,20.09,19.53,17.12,15.53,16.53,17.94,16.75,15.66,16.78,19.06,19.38,18.06,17.97,18.81,17.38,13.81,11.62,11.91,11.97,10.56,10.16,12.0,13.94,13.44,12.25,12.94,14.41,13.84,11.78,11.25,12.66,12.94,10.94,10.16,11.88,13.25,12.34,12.03,14.31,17.34,17.44,16.62,16.88,18.09,16.75,13.69,12.06,12.59,12.66,11.03,10.31,11.75,13.25,12.16,10.53,11.31,13.28,13.5,13.22,15.28,19.16,22.03,22.94,24.53,27.28,28.12,25.84,23.53,23.72,23.62,21.62,19.41,19.56,21.0,20.41,18.97,19.38,21.25,21.56,19.84,18.81,19.84,19.66,17.62,15.78,16.81,18.44,18.16,17.59,19.22,21.75,21.91,21.03,21.0,22.62,22.75,20.94,19.69,20.78,21.72,20.12,18.81,20.06,21.72,20.53,18.19,17.78,18.44,17.41,15.53,15.56,18.06,19.12,17.72,16.5,17.34,17.66,15.53,13.22,13.53,14.59,13.0,10.72,11.0,13.28,14.72,14.81,16.84,21.19,23.5,23.31,22.78,23.94,24.47,22.5,20.16,20.5,22.34,21.88,20.44,20.66,22.72,22.97,21.53,21.75,23.69,25.03,24.31,23.56,25.56,27.47,26.5,24.38,23.78,23.31,20.97,16.91,15.03,15.16,14.41,12.53,12.5,15.25,17.84,17.88,17.75,19.5,21.19,20.31,18.28,18.28,19.53,18.84,16.34,15.47,17.03,17.59,16.59,16.44,18.69,20.12,18.38,16.22,16.53,17.44,16.28,14.25,14.16,15.31,14.47,12.19,11.19,12.84,13.44,12.12,11.53,13.44,14.84,13.81,12.5,13.75,15.97,16.09,15.19,16.06,17.78,17.53,15.09,13.81,14.16,13.81,11.59,9.69,11.19,12.88,12.34,11.69,13.56,16.38,17.25,17.03,18.28,20.62,21.59,19.84,18.16,18.5,17.38,13.53,9.28,7.97,6.78,3.88,1.25,1.75,4.41,6.03,6.81,9.41,13.69,16.31,16.81,17.69,20.91,23.19,23.28,22.62,24.56,26.56,25.66,23.94,23.59,24.22,23.06,20.25,18.94,18.94,17.88,14.22,11.0,10.47,9.84,7.56,5.5,6.5,8.78,8.88,7.94,9.16,11.25,12.28,11.56,12.5,15.41,17.44,16.75,16.22,17.75,18.91,17.72,15.41,15.62,17.16,16.94,15.09,15.34,17.16,17.25,15.69,15.53,17.28,18.06,16.72,15.25,15.78,16.34,14.44,11.34,10.31,10.41,8.59,6.28,5.5,6.72,6.94,4.78,4.31,6.38,8.34,8.41,8.97,11.75,14.94,15.88,16.0,17.94,20.81,21.78,20.31,20.22,21.84,21.97,20.09,18.47,19.41,19.66,17.53,15.22,16.06,17.84,17.69,16.44,17.03,18.41,17.78,15.06,13.56,14.44,14.91,13.44,13.06,15.41,17.81,17.47,16.47,17.75,19.38,18.78,16.84,17.06,18.81,19.12,17.84,17.78,19.5,20.41,18.47,17.28,17.97,18.97,17.78,15.94,16.19,17.78,17.5,15.78,16.38,18.66,19.72,18.94,18.53,20.12,20.41,17.97,15.66,16.31,18.0,18.03,17.03,17.91,19.34,18.66,16.28,15.62,17.25,17.66,16.25,15.75,17.62,19.22,18.34,17.16,18.12,19.88,19.06,17.69,17.97,19.41,19.12,17.09,16.41,17.84,18.75,17.38,16.88,18.28,19.62,18.44,16.22,15.91,16.25,14.12,11.22,10.5,11.47,11.78,10.56,11.06,13.31,14.88,13.31,11.59,12.44,13.31,12.59,12.0,14.34,17.88,19.09,19.0,19.97,21.56,21.78,19.19,17.72,18.47,18.62,15.75,12.44,11.53,11.09,8.81,7.5,8.91,12.34,13.59,13.44,14.41,16.81,17.81,16.19,15.66,17.44,18.69,17.09,15.38,15.53,15.56,12.84,8.97,7.28,6.97,5.62,3.88,4.44,7.5,10.16,10.53,11.69,14.69,17.03,16.66,15.81,16.97,18.84,18.91,18.03,19.0,20.97,20.81,18.34,16.34,15.84,14.28,10.44,7.72,8.81,11.12,12.44,13.81,17.91,22.5,23.91,24.28,25.69,28.22,28.81,27.22,25.81,25.31,23.5,18.72,14.03,11.69,10.78,8.25,6.16,6.75,8.5,8.19,6.12,5.41,6.09,5.62,3.22,1.88,3.25,4.53,3.91,3.22,4.66,6.66,6.03,4.75,5.75,8.03,9.0,8.62,9.84,12.78,14.19,13.19,11.62,11.41,10.38,6.69,2.72,1.44,1.78,1.12,0.84,3.47,7.88,11.03,12.44,13.66,15.81,16.38,13.81,11.41,11.78,12.5,11.84,11.38,12.94,15.56,16.34,15.78,16.66,19.03,19.91,18.75,18.09,19.47,20.22,18.09,16.28,15.97,15.44,12.31,8.31,6.81,6.78,6.22,5.28,6.84,10.62,13.19,13.5,14.38,16.75,18.38,17.41,15.97,16.25,16.28,13.38,8.94,6.06,4.41,1.09,-2.91,-4.78,-3.91,-3.38,-4.06,-3.53,-0.41,2.41,2.72,2.75,4.97,7.78,8.09,7.12,7.31,8.06,6.25,2.59,0.5,0.88,1.12,-0.16,-0.56,1.41,3.66,3.62,3.28,5.22,8.06,8.94,8.66,9.84,12.44,13.44,12.81,13.12,15.75,17.47,16.41,14.59,14.47,13.91,10.75,6.72,5.12,5.12,4.72,4.25,6.5,11.06,14.47,16.06,17.88,21.28,23.69,23.5,22.94,24.31,25.84,24.72,22.34,21.53,20.88,18.41,14.5,12.22,12.12,11.0,8.19,6.0,6.56,7.19,5.94,5.44,7.47,10.78,12.66,14.03,17.5,21.12,22.41,21.16,19.91,20.44,19.66,16.91,14.25,13.59,12.84,10.16,7.59,7.72,9.31,9.88,9.22,10.44,13.19,14.19,13.03,12.53,13.59,13.69,11.91,10.41,11.81,14.06,14.88,15.47,17.88,21.25,22.25,21.66,21.88,23.62,23.91,22.56,21.81,23.59,24.41,22.78,20.69,20.81,21.16,19.5,17.38,17.56,19.06,19.41,18.5,19.19,21.91,23.62,23.78,24.34,27.09,29.5,29.12,28.09,29.03,30.03,28.94,26.75,26.5,27.34,26.97,25.28,24.66,26.03,26.38,24.81,23.25,24.28,25.31,24.72,23.56,24.91,26.78,26.78,24.66,23.81,23.69,22.31,19.34,18.03,19.56,21.12,20.62,20.09,21.78,23.56,22.75,21.28,22.0,23.53,23.72,22.47,22.25,23.53,23.19,19.88,17.28,17.16,16.53,14.44,12.69,13.62,15.0,14.81,13.31,13.91,15.28,15.34,13.44,12.94,14.31,15.38,14.5,14.44,17.59,20.72,21.41,21.0,22.56,23.75,22.72,19.97,19.25,19.84,18.97,16.38,15.41,16.78,17.22,15.41,13.75,14.44,15.12,13.62,12.38,13.84,16.34,17.09,16.5,17.72,20.41,21.59,21.22,22.06,24.25,25.59,24.53,23.59,24.62,25.75,24.91,23.0,23.16,24.03,23.09,20.72,20.25,21.53,22.03,20.75,20.19,22.06,23.38,22.41,21.44,22.19,22.72,20.75,18.0,17.88,20.16,21.5,21.53,22.62,24.66,25.25,23.38,22.62,24.41,26.12,25.44,24.0,23.97,24.16,22.44,19.53,18.91,20.06,20.47,19.5,20.06,22.5,24.22,23.59,23.5,25.91,28.84,29.0,27.91,28.16,28.09,25.66,22.06,20.97,22.44,23.31,23.25,24.22,27.41,29.84,29.38,28.5,29.62,30.41,28.31,25.19,24.0,23.47,21.47,18.25,17.09,18.47,19.25,18.62,19.19,22.22,25.0,24.84,24.16,24.66,25.34,23.25,20.62,20.25,21.62,22.09,20.91,21.03,22.75,23.38,21.81,20.78,22.09,23.5,22.81,22.34,24.06,27.12,28.38,28.53,29.88,31.53,30.56,26.62,23.06,21.38,19.06,15.06,12.28,12.44,13.53,13.03,12.75,14.81,18.38,19.81,19.28,20.34,22.75,23.19,21.69,20.75,22.12,22.81,20.56,18.88,20.06,21.81,21.44,20.72,21.53,23.31,22.56,20.5,19.47,20.5,21.09,19.81,19.88,22.06,24.0,22.44,20.12,20.06,20.69,19.28,17.66,18.38,20.19,20.0,17.81,17.56,19.53,20.91,20.78,21.38,23.97,25.97,25.53,25.06,27.09,30.34,31.38,30.97,31.25,31.34,29.19,24.03,19.91,18.47,16.72,13.34,11.5,13.09,14.69,14.22,13.44,14.28,16.12,16.34,16.09,17.31,20.25,21.34,19.56,18.41,19.41,20.38,19.56,19.5,21.91,24.69,24.72,24.06,24.97,27.0,26.62,24.06,22.25,21.62,19.41,15.34,13.03,14.09,15.78,15.91,16.06,18.16,19.97,19.03,16.81,16.5,17.16,16.5,14.5,14.12,16.34,18.12:40.59,40.09,37.66,36.06,35.78,33.69,28.81,24.47,22.41,20.34,16.81,15.03,16.84,21.31,24.22,26.44,30.44,34.5,35.56,34.53,34.69,36.66,37.84,36.69,35.75,36.38,36.47,33.66,30.62,30.0,30.38,28.75,25.91,24.78,24.72,23.34,19.81,17.84,18.47,19.12,17.5,16.94,19.06,21.28,21.19,20.97,23.25,26.5,27.44,27.0,27.91,30.62,31.72,29.88,27.78,27.97,27.38,25.03,23.62,24.88,26.0,23.47,19.28,17.38,17.94,18.03,18.09,20.44,24.88,28.16,29.34,31.25,35.19,39.16,39.53,39.09,40.19,40.94,38.81,35.19,33.28,32.62,30.5,27.19,25.47,26.5,26.81,24.72,23.31,24.28,25.38,23.94,22.25,22.84,24.31,23.78,22.56,23.0,25.06,25.03,22.47,20.38,20.09,19.53,17.12,15.53,16.53,17.94,16.75,15.66,16.78,19.06,19.38,18.06,17.97,18.81,17.38,13.81,11.62,11.91,11.97,10.56,10.16,12.0,13.94,13.44,12.25,12.94,14.41,13.84,11.78,11.25,12.66,12.94,10.94,10.16,11.88,13.25,12.34,12.03,14.31,17.34,17.44,16.62,16.88,18.09,16.75,13.69,12.06,12.59,12.66,11.03,10.31,11.75,13.25,12.16,10.53,11.31,13.28,13.5,13.22,15.28,19.16,22.03,22.94,24.53,27.28,28.12,25.84,23.53,23.72,23.62,21.62,19.41,19.56,21.0,20.41,18.97,19.38,21.25,21.56,19.84,18.81,19.84,19.66,17.62,15.78,16.81,18.44,18.16,17.59,19.22,21.75,21.91,21.03,21.0,22.62,22.75,20.94,19.69,20.78,21.72,20.12,18.81,20.06,21.72,20.53,18.19,17.78,18.44,17.41,15.53,15.56,18.06,19.12,17.72,16.5,17.34,17.66,15.53,13.22,13.53,14.59,13.0,10.72,11.0,13.28,14.72,14.81,16.84,21.19,23.5,23.31,22.78,23.94,24.47,22.5,20.16,20.5,22.34,21.88,20.44,20.66,22.72,22.97,21.53,21.75,23.69,25.03,24.31,23.56,25.56,27.47,26.5,24.38,23.78,23.31,20.97,16.91,15.03,15.16,14.41,12.53,12.5,15.25,17.84,17.88,17.75,19.5,21.19,20.31,18.28,18.28,19.53,18.84,16.34,15.47,17.03,17.59,16.59,16.44,18.69,20.12,18.38,16.22,16.53,17.44,16.28,14.25,14.16,15.31,14.47,12.19,11.19,12.84,13.44,12.12,11.53,13.44,14.84,13.81,12.5,13.75,15.97,16.09,15.19,16.06,17.78,17.53,15.09,13.81,14.16,13.81,11.59,9.69,11.19,12.88,12.34,11.69,13.56,16.38,17.25,17.03,18.28,20.62,21.59,19.84,18.16,18.5,17.38,13.53,9.28,7.97,6.78,3.88,1.25,1.75,4.41,6.03,6.81,9.41,13.69,16.31,16.81,17.69,20.91,23.19,23.28,22.62,24.56,26.56,25.66,23.94,23.59,24.22,23.06,20.25,18.94,18.94,17.88,14.22,11.0,10.47,9.84,7.56,5.5,6.5,8.78,8.88,7.94,9.16,11.25,12.28,11.56,12.5,15.41,17.44,16.75,16.22,17.75,18.91,17.72,15.41,15.62,17.16,16.94,15.09,15.34,17.16,17.25,15.69,15.53,17.28,18.06,16.72,15.25,15.78,16.34,14.44,11.34,10.31,10.41,8.59,6.28,5.5,6.72,6.94,4.78,4.31,6.38,8.34,8.41,8.97,11.75,14.94,15.88,16.0,17.94,20.81,21.78,20.31,20.22,21.84,21.97,20.09,18.47,19.41,19.66,17.53,15.22,16.06,17.84,17.69,16.44,17.03,18.41,17.78,15.06,13.56,14.44,14.91,13.44,13.06,15.41,17.81,17.47,16.47,17.75,19.38,18.78,16.84,17.06,18.81,19.12,17.84,17.78,19.5,20.41,18.47,17.28,17.97,18.97,17.78,15.94,16.19,17.78,17.5,15.78,16.38,18.66,19.72,18.94,18.53,20.12,20.41,17.97,15.66,16.31,18.0,18.03,17.03,17.91,19.34,18.66,16.28,15.62,17.25,17.66,16.25,15.75,17.62,19.22,18.34,17.16,18.12,19.88,19.06,17.69,17.97,19.41,19.12,17.09,16.41,17.84,18.75,17.38,16.88,18.28,19.62,18.44,16.22,15.91,16.25,14.12,11.22,10.5,11.47,11.78,10.56,11.06,13.31,14.88,13.31,11.59,12.44,13.31,12.59,12.0,14.34,17.88,19.09,19.0,19.97,21.56,21.78,19.19,17.72,18.47,18.62,15.75,12.44,11.53,11.09,8.81,7.5,8.91,12.34,13.59,13.44,14.41,16.81,17.81,16.19,15.66,17.44,18.69,17.09,15.38,15.53,15.56,12.84,8.97,7.28,6.97,5.62,3.88,4.44,7.5,10.16,10.53,11.69,14.69,17.03,16.66,15.81,16.97,18.84,18.91,18.03,19.0,20.97,20.81,18.34,16.34,15.84,14.28,10.44,7.72,8.81,11.12,12.44,13.81,17.91,22.5,23.91,24.28,25.69,28.22,28.81,27.22,25.81,25.31,23.5,18.72,14.03,11.69,10.78,8.25,6.16,6.75,8.5,8.19,6.12,5.41,6.09,5.62,3.22,1.88,3.25,4.53,3.91,3.22,4.66,6.66,6.03,4.75,5.75,8.03,9.0,8.62,9.84,12.78,14.19,13.19,11.62,11.41,10.38,6.69,2.72,1.44,1.78,1.12,0.84,3.47,7.88,11.03,12.44,13.66,15.81,16.38,13.81,11.41,11.78,12.5,11.84,11.38,12.94,15.56,16.34,15.78,16.66,19.03,19.91,18.75,18.09,19.47,20.22,18.09,16.28,15.97,15.44,12.31,8.31,6.81,6.78,6.22,5.28,6.84,10.62,13.19,13.5,14.38,16.75,18.38,17.41,15.97,16.25,16.28,13.38,8.94,6.06,4.41,1.09,-2.91,-4.78,-3.91,-3.38,-4.06,-3.53,-0.41,2.41,2.72,2.75,4.97,7.78,8.09,7.12,7.31,8.06,6.25,2.59,0.5,0.88,1.12,-0.16,-0.56,1.41,3.66,3.62,3.28,5.22,8.06,8.94,8.66,9.84,12.44,13.44,12.81,13.12,15.75,17.47,16.41,14.59,14.47,13.91,10.75,6.72,5.12,5.12,4.72,4.25,6.5,11.06,14.47,16.06,17.88,21.28,23.69,23.5,22.94,24.31,25.84,24.72,22.34,21.53,20.88,18.41,14.5,12.22,12.12,11.0,8.19,6.0,6.56,7.19,5.94,5.44,7.47,10.78,12.66,14.03,17.5,21.12,22.41,21.16,19.91,20.44,19.66,16.91,14.25,13.59,12.84,10.16,7.59,7.72,9.31,9.88,9.22,10.44,13.19,14.19,13.03,12.53,13.59,13.69,11.91,10.41,11.81,14.06,14.88,15.47,17.88,21.25,22.25,21.66,21.88,23.62,23.91,22.56,21.81,23.59,24.41,22.78,20.69,20.81,21.16,19.5,17.38,17.56,19.06,19.41,18.5,19.19,21.91,23.62,23.78,24.34,27.09,29.5,29.12,28.09,29.03,30.03,28.94,26.75,26.5,27.34,26.97,25.28,24.66,26.03,26.38,24.81,23.25,24.28,25.31,24.72,23.56,24.91,26.78,26.78,24.66,23.81,23.69,22.31,19.34,18.03,19.56,21.12,20.62,20.09,21.78,23.56,22.75,21.28,22.0,23.53,23.72,22.47,22.25,23.53,23.19,19.88,17.28,17.16,16.53,14.44,12.69,13.62,15.0,14.81,13.31,13.91,15.28,15.34,13.44,12.94,14.31,15.38,14.5,14.44,17.59,20.72,21.41,21.0,22.56,23.75,22.72,19.97,19.25,19.84,18.97,16.38,15.41,16.78,17.22,15.41,13.75,14.44,15.12,13.62,12.38,13.84,16.34,17.09,16.5,17.72,20.41,21.59,21.22,22.06,24.25,25.59,24.53,23.59,24.62,25.75,24.91,23.0,23.16,24.03,23.09,20.72,20.25,21.53,22.03,20.75,20.19,22.06,23.38,22.41,21.44,22.19,22.72,20.75,18.0,17.88,20.16,21.5,21.53,22.62,24.66,25.25,23.38,22.62,24.41,26.12,25.44,24.0,23.97,24.16,22.44,19.53,18.91,20.06,20.47,19.5,20.06,22.5,24.22,23.59,23.5,25.91,28.84,29.0,27.91,28.16,28.09,25.66,22.06,20.97,22.44,23.31,23.25,24.22,27.41,29.84,29.38,28.5,29.62,30.41,28.31,25.19,24.0,23.47,21.47,18.25,17.09,18.47,19.25,18.62,19.19,22.22,25.0,24.84,24.16,24.66,25.34,23.25,20.62,20.25,21.62,22.09,20.91,21.03,22.75,23.38,21.81,20.78,22.09,23.5,22.81,22.34,24.06,27.12,28.38,28.53,29.88,31.53,30.56,26.62,23.06,21.38,19.06,15.06,12.28,12.44,13.53,13.03,12.75,14.81,18.38,19.81,19.28,20.34,22.75,23.19,21.69,20.75,22.12,22.81,20.56,18.88,20.06,21.81,21.44,20.72,21.53,23.31,22.56,20.5,19.47,20.5,21.09,19.81,19.88,22.06,24.0,22.44,20.12,20.06,20.69,19.28,17.66,18.38,20.19,20.0,17.81,17.56,19.53,20.91,20.78,21.38,23.97,25.97,25.53,25.06,27.09,30.34,31.38,30.97,31.25,31.34,29.19,24.03,19.91,18.47,16.72,13.34,11.5,13.09,14.69,14.22,13.44,14.28,16.12,16.34,16.09,17.31,20.25,21.34,19.56,18.41,19.41,20.38,19.56,19.5,21.91,24.69,24.72,24.06,24.97,27.0,26.62,24.06,22.25,21.62,19.41,15.34,13.03,14.09,15.78,15.91,16.06,18.16,19.97,19.03,16.81,16.5,17.16,16.5,14.5,14.12,16.34,18.12,60.53,62.22,65.0,67.72,68.28,68.25,69.06:24.47,22.41,20.34,16.81,15.03,16.84,21.31,24.22,26.44,30.44,34.5,35.56,34.53,34.69,36.66,37.84,36.69,35.75,36.38,36.47,33.66,30.62,30.0,30.38,28.75,25.91,24.78,24.72,23.34,19.81,17.84,18.47,19.12,17.5,16.94,19.06,21.28,21.19,20.97,23.25,26.5,27.44,27.0,27.91,30.62,31.72,29.88,27.78,27.97,27.38,25.03,23.62,24.88,26.0,23.47,19.28,17.38,17.94,18.03,18.09,20.44,24.88,28.16,29.34,31.25,35.19,39.16,39.53,39.09,40.19,40.94,38.81,35.19,33.28,32.62,30.5,27.19,25.47,26.5,26.81,24.72,23.31,24.28,25.38,23.94,22.25,22.84,24.31,23.78,22.56,23.0,25.06,25.03,22.47,20.38,20.09,19.53,17.12,15.53,16.53,17.94,16.75,15.66,16.78,19.06,19.38,18.06,17.97,18.81,17.38,13.81,11.62,11.91,11.97,10.56,10.16,12.0,13.94,13.44,12.25,12.94,14.41,13.84,11.78,11.25,12.66,12.94,10.94,10.16,11.88,13.25,12.34,12.03,14.31,17.34,17.44,16.62,16.88,18.09,16.75,13.69,12.06,12.59,12.66,11.03,10.31,11.75,13.25,12.16,10.53,11.31,13.28,13.5,13.22,15.28,19.16,22.03,22.94,24.53,27.28,28.12,25.84,23.53,23.72,23.62,21.62,19.41,19.56,21.0,20.41,18.97,19.38,21.25,21.56,19.84,18.81,19.84,19.66,17.62,15.78,16.81,18.44,18.16,17.59,19.22,21.75,21.91,21.03,21.0,22.62,22.75,20.94,19.69,20.78,21.72,20.12,18.81,20.06,21.72,20.53,18.19,17.78,18.44,17.41,15.53,15.56,18.06,19.12,17.72,16.5,17.34,17.66,15.53,13.22,13.53,14.59,13.0,10.72,11.0,13.28,14.72,14.81,16.84,21.19,23.5,23.31,22.78,23.94,24.47,22.5,20.16,20.5,22.34,21.88,20.44,20.66,22.72,22.97,21.53,21.75,23.69,25.03,24.31,23.56,25.56,27.47,26.5,24.38,23.78,23.31,20.97,16.91,15.03,15.16,14.41,12.53,12.5,15.25,17.84,17.88,17.75,19.5,21.19,20.31,18.28,18.28,19.53,18.84,16.34,15.47,17.03,17.59,16.59,16.44,18.69,20.12,18.38,16.22,16.53,17.44,16.28,14.25,14.16,15.31,14.47,12.19,11.19,12.84,13.44,12.12,11.53,13.44,14.84,13.81,12.5,13.75,15.97,16.09,15.19,16.06,17.78,17.53,15.09,13.81,14.16,13.81,11.59,9.69,11.19,12.88,12.34,11.69,13.56,16.38,17.25,17.03,18.28,20.62,21.59,19.84,18.16,18.5,17.38,13.53,9.28,7.97,6.78,3.88,1.25,1.75,4.41,6.03,6.81,9.41,13.69,16.31,16.81,17.69,20.91,23.19,23.28,22.62,24.56,26.56,25.66,23.94,23.59,24.22,23.06,20.25,18.94,18.94,17.88,14.22,11.0,10.47,9.84,7.56,5.5,6.5,8.78,8.88,7.94,9.16,11.25,12.28,11.56,12.5,15.41,17.44,16.75,16.22,17.75,18.91,17.72,15.41,15.62,17.16,16.94,15.09,15.34,17.16,17.25,15.69,15.53,17.28,18.06,16.72,15.25,15.78,16.34,14.44,11.34,10.31,10.41,8.59,6.28,5.5,6.72,6.94,4.78,4.31,6.38,8.34,8.41,8.97,11.75,14.94,15.88,16.0,17.94,20.81,21.78,20.31,20.22,21.84,21.97,20.09,18.47,19.41,19.66,17.53,15.22,16.06,17.84,17.69,16.44,17.03,18.41,17.78,15.06,13.56,14.44,14.91,13.44,13.06,15.41,17.81,17.47,16.47,17.75,19.38,18.78,16.84,17.06,18.81,19.12,17.84,17.78,19.5,20.41,18.47,17.28,17.97,18.97,17.78,15.94,16.19,17.78,17.5,15.78,16.38,18.66,19.72,18.94,18.53,20.12,20.41,17.97,15.66,16.31,18.0,18.03,17.03,17.91,19.34,18.66,16.28,15.62,17.25,17.66,16.25,15.75,17.62,19.22,18.34,17.16,18.12,19.88,19.06,17.69,17.97,19.41,19.12,17.09,16.41,17.84,18.75,17.38,16.88,18.28,19.62,18.44,16.22,15.91,16.25,14.12,11.22,10.5,11.47,11.78,10.56,11.06,13.31,14.88,13.31,11.59,12.44,13.31,12.59,12.0,14.34,17.88,19.09,19.0,19.97,21.56,21.78,19.19,17.72,18.47,18.62,15.75,12.44,11.53,11.09,8.81,7.5,8.91,12.34,13.59,13.44,14.41,16.81,17.81,16.19,15.66,17.44,18.69,17.09,15.38,15.53,15.56,12.84,8.97,7.28,6.97,5.62,3.88,4.44,7.5,10.16,10.53,11.69,14.69,17.03,16.66,15.81,16.97,18.84,18.91,18.03,19.0,20.97,20.81,18.34,16.34,15.84,14.28,10.44,7.72,8.81,11.12,12.44,13.81,17.91,22.5,23.91,24.28,25.69,28.22,28.81,27.22,25.81,25.31,23.5,18.72,14.03,11.69,10.78,8.25,6.16,6.75,8.5,8.19,6.12,5.41,6.09,5.62,3.22,1.88,3.25,4.53,3.91,3.22,4.66,6.66,6.03,4.75,5.75,8.03,9.0,8.62,9.84,12.78,14.19,13.19,11.62,11.41,10.38,6.69,2.72,1.44,1.78,1.12,0.84,3.47,7.88,11.03,12.44,13.66,15.81,16.38,13.81,11.41,11.78,12.5,11.84,11.38,12.94,15.56,16.34,15.78,16.66,19.03,19.91,18.75,18.09,19.47,20.22,18.09,16.28,15.97,15.44,12.31,8.31,6.81,6.78,6.22,5.28,6.84,10.62,13.19,13.5,14.38,16.75,18.38,17.41,15.97,16.25,16.28,13.38,8.94,6.06,4.41,1.09,-2.91,-4.78,-3.91,-3.38,-4.06,-3.53,-0.41,2.41,2.72,2.75,4.97,7.78,8.09,7.12,7.31,8.06,6.25,2.59,0.5,0.88,1.12,-0.16,-0.56,1.41,3.66,3.62,3.28,5.22,8.06,8.94,8.66,9.84,12.44,13.44,12.81,13.12,15.75,17.47,16.41,14.59,14.47,13.91,10.75,6.72,5.12,5.12,4.72,4.25,6.5,11.06,14.47,16.06,17.88,21.28,23.69,23.5,22.94,24.31,25.84,24.72,22.34,21.53,20.88,18.41,14.5,12.22,12.12,11.0,8.19,6.0,6.56,7.19,5.94,5.44,7.47,10.78,12.66,14.03,17.5,21.12,22.41,21.16,19.91,20.44,19.66,16.91,14.25,13.59,12.84,10.16,7.59,7.72,9.31,9.88,9.22,10.44,13.19,14.19,13.03,12.53,13.59,13.69,11.91,10.41,11.81,14.06,14.88,15.47,17.88,21.25,22.25,21.66,21.88,23.62,23.91,22.56,21.81,23.59,24.41,22.78,20.69,20.81,21.16,19.5,17.38,17.56,19.06,19.41,18.5,19.19,21.91,23.62,23.78,24.34,27.09,29.5,29.12,28.09,29.03,30.03,28.94,26.75,26.5,27.34,26.97,25.28,24.66,26.03,26.38,24.81,23.25,24.28,25.31,24.72,23.56,24.91,26.78,26.78,24.66,23.81,23.69,22.31,19.34,18.03,19.56,21.12,20.62,20.09,21.78,23.56,22.75,21.28,22.0,23.53,23.72,22.47,22.25,23.53,23.19,19.88,17.28,17.16,16.53,14.44,12.69,13.62,15.0,14.81,13.31,13.91,15.28,15.34,13.44,12.94,14.31,15.38,14.5,14.44,17.59,20.72,21.41,21.0,22.56,23.75,22.72,19.97,19.25,19.84,18.97,16.38,15.41,16.78,17.22,15.41,13.75,14.44,15.12,13.62,12.38,13.84,16.34,17.09,16.5,17.72,20.41,21.59,21.22,22.06,24.25,25.59,24.53,23.59,24.62,25.75,24.91,23.0,23.16,24.03,23.09,20.72,20.25,21.53,22.03,20.75,20.19,22.06,23.38,22.41,21.44,22.19,22.72,20.75,18.0,17.88,20.16,21.5,21.53,22.62,24.66,25.25,23.38,22.62,24.41,26.12,25.44,24.0,23.97,24.16,22.44,19.53,18.91,20.06,20.47,19.5,20.06,22.5,24.22,23.59,23.5,25.91,28.84,29.0,27.91,28.16,28.09,25.66,22.06,20.97,22.44,23.31,23.25,24.22,27.41,29.84,29.38,28.5,29.62,30.41,28.31,25.19,24.0,23.47,21.47,18.25,17.09,18.47,19.25,18.62,19.19,22.22,25.0,24.84,24.16,24.66,25.34,23.25,20.62,20.25,21.62,22.09,20.91,21.03,22.75,23.38,21.81,20.78,22.09,23.5,22.81,22.34,24.06,27.12,28.38,28.53,29.88,31.53,30.56,26.62,23.06,21.38,19.06,15.06,12.28,12.44,13.53,13.03,12.75,14.81,18.38,19.81,19.28,20.34,22.75,23.19,21.69,20.75,22.12,22.81,20.56,18.88,20.06,21.81,21.44,20.72,21.53,23.31,22.56,20.5,19.47,20.5,21.09,19.81,19.88,22.06,24.0,22.44,20.12,20.06,20.69,19.28,17.66,18.38,20.19,20.0,17.81,17.56,19.53,20.91,20.78,21.38,23.97,25.97,25.53,25.06,27.09,30.34,31.38,30.97,31.25,31.34,29.19,24.03,19.91,18.47,16.72,13.34,11.5,13.09,14.69,14.22,13.44,14.28,16.12,16.34,16.09,17.31,20.25,21.34,19.56,18.41,19.41,20.38,19.56,19.5,21.91,24.69,24.72,24.06,24.97,27.0,26.62,24.06,22.25,21.62,19.41,15.34,13.03,14.09,15.78,15.91,16.06,18.16,19.97,19.03,16.81,16.5,17.16,16.5,14.5,14.12,16.34,18.12,60.53,62.22,65.0,67.72,68.28,68.25,69.06,70.03,70.03,68.75,68.22,68.22,66.97,64.03:24.22,26.44,30.44,34.5,35.56,34.53,34.69,36.66,37.84,36.69,35.75,36.38,36.47,33.66,30.62,30.0,30.38,28.75,25.91,24.78,24.72,23.34,19.81,17.84,18.47,19.12,17.5,16.94,19.06,21.28,21.19,20.97,23.25,26.5,27.44,27.0,27.91,30.62,31.72,29.88,27.78,27.97,27.38,25.03,23.62,24.88,26.0,23.47,19.28,17.38,17.94,18.03,18.09,20.44,24.88,28.16,29.34,31.25,35.19,39.16,39.53,39.09,40.19,40.94,38.81,35.19,33.28,32.62,30.5,27.19,25.47,26.5,26.81,24.72,23.31,24.28,25.38,23.94,22.25,22.84,24.31,23.78,22.56,23.0,25.06,25.03,22.47,20.38,20.09,19.53,17.12,15.53,16.53,17.94,16.75,15.66,16.78,19.06,19.38,18.06,17.97,18.81,17.38,13.81,11.62,11.91,11.97,10.56,10.16,12.0,13.94,13.44,12.25,12.94,14.41,13.84,11.78,11.25,12.66,12.94,10.94,10.16,11.88,13.25,12.34,12.03,14.31,17.34,17.44,16.62,16.88,18.09,16.75,13.69,12.06,12.59,12.66,11.03,10.31,11.75,13.25,12.16,10.53,11.31,13.28,13.5,13.22,15.28,19.16,22.03,22.94,24.53,27.28,28.12,25.84,23.53,23.72,23.62,21.62,19.41,19.56,21.0,20.41,18.97,19.38,21.25,21.56,19.84,18.81,19.84,19.66,17.62,15.78,16.81,18.44,18.16,17.59,19.22,21.75,21.91,21.03,21.0,22.62,22.75,20.94,19.69,20.78,21.72,20.12,18.81,20.06,21.72,20.53,18.19,17.78,18.44,17.41,15.53,15.56,18.06,19.12,17.72,16.5,17.34,17.66,15.53,13.22,13.53,14.59,13.0,10.72,11.0,13.28,14.72,14.81,16.84,21.19,23.5,23.31,22.78,23.94,24.47,22.5,20.16,20.5,22.34,21.88,20.44,20.66,22.72,22.97,21.53,21.75,23.69,25.03,24.31,23.56,25.56,27.47,26.5,24.38,23.78,23.31,20.97,16.91,15.03,15.16,14.41,12.53,12.5,15.25,17.84,17.88,17.75,19.5,21.19,20.31,18.28,18.28,19.53,18.84,16.34,15.47,17.03,17.59,16.59,16.44,18.69,20.12,18.38,16.22,16.53,17.44,16.28,14.25,14.16,15.31,14.47,12.19,11.19,12.84,13.44,12.12,11.53,13.44,14.84,13.81,12.5,13.75,15.97,16.09,15.19,16.06,17.78,17.53,15.09,13.81,14.16,13.81,11.59,9.69,11.19,12.88,12.34,11.69,13.56,16.38,17.25,17.03,18.28,20.62,21.59,19.84,18.16,18.5,17.38,13.53,9.28,7.97,6.78,3.88,1.25,1.75,4.41,6.03,6.81,9.41,13.69,16.31,16.81,17.69,20.91,23.19,23.28,22.62,24.56,26.56,25.66,23.94,23.59,24.22,23.06,20.25,18.94,18.94,17.88,14.22,11.0,10.47,9.84,7.56,5.5,6.5,8.78,8.88,7.94,9.16,11.25,12.28,11.56,12.5,15.41,17.44,16.75,16.22,17.75,18.91,17.72,15.41,15.62,17.16,16.94,15.09,15.34,17.16,17.25,15.69,15.53,17.28,18.06,16.72,15.25,15.78,16.34,14.44,11.34,10.31,10.41,8.59,6.28,5.5,6.72,6.94,4.78,4.31,6.38,8.34,8.41,8.97,11.75,14.94,15.88,16.0,17.94,20.81,21.78,20.31,20.22,21.84,21.97,20.09,18.47,19.41,19.66,17.53,15.22,16.06,17.84,17.69,16.44,17.03,18.41,17.78,15.06,13.56,14.44,14.91,13.44,13.06,15.41,17.81,17.47,16.47,17.75,19.38,18.78,16.84,17.06,18.81,19.12,17.84,17.78,19.5,20.41,18.47,17.28,17.97,18.97,17.78,15.94,16.19,17.78,17.5,15.78,16.38,18.66,19.72,18.94,18.53,20.12,20.41,17.97,15.66,16.31,18.0,18.03,17.03,17.91,19.34,18.66,16.28,15.62,17.25,17.66,16.25,15.75,17.62,19.22,18.34,17.16,18.12,19.88,19.06,17.69,17.97,19.41,19.12,17.09,16.41,17.84,18.75,17.38,16.88,18.28,19.62,18.44,16.22,15.91,16.25,14.12,11.22,10.5,11.47,11.78,10.56,11.06,13.31,14.88,13.31,11.59,12.44,13.31,12.59,12.0,14.34,17.88,19.09,19.0,19.97,21.56,21.78,19.19,17.72,18.47,18.62,15.75,12.44,11.53,11.09,8.81,7.5,8.91,12.34,13.59,13.44,14.41,16.81,17.81,16.19,15.66,17.44,18.69,17.09,15.38,15.53,15.56,12.84,8.97,7.28,6.97,5.62,3.88,4.44,7.5,10.16,10.53,11.69,14.69,17.03,16.66,15.81,16.97,18.84,18.91,18.03,19.0,20.97,20.81,18.34,16.34,15.84,14.28,10.44,7.72,8.81,11.12,12.44,13.81,17.91,22.5,23.91,24.28,25.69,28.22,28.81,27.22,25.81,25.31,23.5,18.72,14.03,11.69,10.78,8.25,6.16,6.75,8.5,8.19,6.12,5.41,6.09,5.62,3.22,1.88,3.25,4.53,3.91,3.22,4.66,6.66,6.03,4.75,5.75,8.03,9.0,8.62,9.84,12.78,14.19,13.19,11.62,11.41,10.38,6.69,2.72,1.44,1.78,1.12,0.84,3.47,7.88,11.03,12.44,13.66,15.81,16.38,13.81,11.41,11.78,12.5,11.84,11.38,12.94,15.56,16.34,15.78,16.66,19.03,19.91,18.75,18.09,19.47,20.22,18.09,16.28,15.97,15.44,12.31,8.31,6.81,6.78,6.22,5.28,6.84,10.62,13.19,13.5,14.38,16.75,18.38,17.41,15.97,16.25,16.28,13.38,8.94,6.06,4.41,1.09,-2.91,-4.78,-3.91,-3.38,-4.06,-3.53,-0.41,2.41,2.72,2.75,4.97,7.78,8.09,7.12,7.31,8.06,6.25,2.59,0.5,0.88,1.12,-0.16,-0.56,1.41,3.66,3.62,3.28,5.22,8.06,8.94,8.66,9.84,12.44,13.44,12.81,13.12,15.75,17.47,16.41,14.59,14.47,13.91,10.75,6.72,5.12,5.12,4.72,4.25,6.5,11.06,14.47,16.06,17.88,21.28,23.69,23.5,22.94,24.31,25.84,24.72,22.34,21.53,20.88,18.41,14.5,12.22,12.12,11.0,8.19,6.0,6.56,7.19,5.94,5.44,7.47,10.78,12.66,14.03,17.5,21.12,22.41,21.16,19.91,20.44,19.66,16.91,14.25,13.59,12.84,10.16,7.59,7.72,9.31,9.88,9.22,10.44,13.19,14.19,13.03,12.53,13.59,13.69,11.91,10.41,11.81,14.06,14.88,15.47,17.88,21.25,22.25,21.66,21.88,23.62,23.91,22.56,21.81,23.59,24.41,22.78,20.69,20.81,21.16,19.5,17.38,17.56,19.06,19.41,18.5,19.19,21.91,23.62,23.78,24.34,27.09,29.5,29.12,28.09,29.03,30.03,28.94,26.75,26.5,27.34,26.97,25.28,24.66,26.03,26.38,24.81,23.25,24.28,25.31,24.72,23.56,24.91,26.78,26.78,24.66,23.81,23.69,22.31,19.34,18.03,19.56,21.12,20.62,20.09,21.78,23.56,22.75,21.28,22.0,23.53,23.72,22.47,22.25,23.53,23.19,19.88,17.28,17.16,16.53,14.44,12.69,13.62,15.0,14.81,13.31,13.91,15.28,15.34,13.44,12.94,14.31,15.38,14.5,14.44,17.59,20.72,21.41,21.0,22.56,23.75,22.72,19.97,19.25,19.84,18.97,16.38,15.41,16.78,17.22,15.41,13.75,14.44,15.12,13.62,12.38,13.84,16.34,17.09,16.5,17.72,20.41,21.59,21.22,22.06,24.25,25.59,24.53,23.59,24.62,25.75,24.91,23.0,23.16,24.03,23.09,20.72,20.25,21.53,22.03,20.75,20.19,22.06,23.38,22.41,21.44,22.19,22.72,20.75,18.0,17.88,20.16,21.5,21.53,22.62,24.66,25.25,23.38,22.62,24.41,26.12,25.44,24.0,23.97,24.16,22.44,19.53,18.91,20.06,20.47,19.5,20.06,22.5,24.22,23.59,23.5,25.91,28.84,29.0,27.91,28.16,28.09,25.66,22.06,20.97,22.44,23.31,23.25,24.22,27.41,29.84,29.38,28.5,29.62,30.41,28.31,25.19,24.0,23.47,21.47,18.25,17.09,18.47,19.25,18.62,19.19,22.22,25.0,24.84,24.16,24.66,25.34,23.25,20.62,20.25,21.62,22.09,20.91,21.03,22.75,23.38,21.81,20.78,22.09,23.5,22.81,22.34,24.06,27.12,28.38,28.53,29.88,31.53,30.56,26.62,23.06,21.38,19.06,15.06,12.28,12.44,13.53,13.03,12.75,14.81,18.38,19.81,19.28,20.34,22.75,23.19,21.69,20.75,22.12,22.81,20.56,18.88,20.06,21.81,21.44,20.72,21.53,23.31,22.56,20.5,19.47,20.5,21.09,19.81,19.88,22.06,24.0,22.44,20.12,20.06,20.69,19.28,17.66,18.38,20.19,20.0,17.81,17.56,19.53,20.91,20.78,21.38,23.97,25.97,25.53,25.06,27.09,30.34,31.38,30.97,31.25,31.34,29.19,24.03,19.91,18.47,16.72,13.34,11.5,13.09,14.69,14.22,13.44,14.28,16.12,16.34,16.09,17.31,20.25,21.34,19.56,18.41,19.41,20.38,19.56,19.5,21.91,24.69,24.72,24.06,24.97,27.0,26.62,24.06,22.25,21.62,19.41,15.34,13.03,14.09,15.78,15.91,16.06,18.16,19.97,19.03,16.81,16.5,17.16,16.5,14.5,14.12,16.34,18.12,60.53,62.22,65.0,67.72,68.28,68.25,69.06,70.03,70.03,68.75,68.22,68.22,66.97,64.03,61.44,59.47,56.94,53.38,51.5,52.66,55.78:36.66,37.84,36.69,35.75,36.38,36.47,33.66,30.62,30.0,30.38,28.75,25.91,24.78,24.72,23.34,19.81,17.84,18.47,19.12,17.5,16.94,19.06,21.28,21.19,20.97,23.25,26.5,27.44,27.0,27.91,30.62,31.72,29.88,27.78,27.97,27.38,25.03,23.62,24.88,26.0,23.47,19.28,17.38,17.94,18.03,18.09,20.44,24.88,28.16,29.34,31.25,35.19,39.16,39.53,39.09,40.19,40.94,38.81,35.19,33.28,32.62,30.5,27.19,25.47,26.5,26.81,24.72,23.31,24.28,25.38,23.94,22.25,22.84,24.31,23.78,22.56,23.0,25.06,25.03,22.47,20.38,20.09,19.53,17.12,15.53,16.53,17.94,16.75,15.66,16.78,19.06,19.38,18.06,17.97,18.81,17.38,13.81,11.62,11.91,11.97,10.56,10.16,12.0,13.94,13.44,12.25,12.94,14.41,13.84,11.78,11.25,12.66,12.94,10.94,10.16,11.88,13.25,12.34,12.03,14.31,17.34,17.44,16.62,16.88,18.09,16.75,13.69,12.06,12.59,12.66,11.03,10.31,11.75,13.25,12.16,10.53,11.31,13.28,13.5,13.22,15.28,19.16,22.03,22.94,24.53,27.28,28.12,25.84,23.53,23.72,23.62,21.62,19.41,19.56,21.0,20.41,18.97,19.38,21.25,21.56,19.84,18.81,19.84,19.66,17.62,15.78,16.81,18.44,18.16,17.59,19.22,21.75,21.91,21.03,21.0,22.62,22.75,20.94,19.69,20.78,21.72,20.12,18.81,20.06,21.72,20.53,18.19,17.78,18.44,17.41,15.53,15.56,18.06,19.12,17.72,16.5,17.34,17.66,15.53,13.22,13.53,14.59,13.0,10.72,11.0,13.28,14.72,14.81,16.84,21.19,23.5,23.31,22.78,23.94,24.47,22.5,20.16,20.5,22.34,21.88,20.44,20.66,22.72,22.97,21.53,21.75,23.69,25.03,24.31,23.56,25.56,27.47,26.5,24.38,23.78,23.31,20.97,16.91,15.03,15.16,14.41,12.53,12.5,15.25,17.84,17.88,17.75,19.5,21.19,20.31,18.28,18.28,19.53,18.84,16.34,15.47,17.03,17.59,16.59,16.44,18.69,20.12,18.38,16.22,16.53,17.44,16.28,14.25,14.16,15.31,14.47,12.19,11.19,12.84,13.44,12.12,11.53,13.44,14.84,13.81,12.5,13.75,15.97,16.09,15.19,16.06,17.78,17.53,15.09,13.81,14.16,13.81,11.59,9.69,11.19,12.88,12.34,11.69,13.56,16.38,17.25,17.03,18.28,20.62,21.59,19.84,18.16,18.5,17.38,13.53,9.28,7.97,6.78,3.88,1.25,1.75,4.41,6.03,6.81,9.41,13.69,16.31,16.81,17.69,20.91,23.19,23.28,22.62,24.56,26.56,25.66,23.94,23.59,24.22,23.06,20.25,18.94,18.94,17.88,14.22,11.0,10.47,9.84,7.56,5.5,6.5,8.78,8.88,7.94,9.16,11.25,12.28,11.56,12.5,15.41,17.44,16.75,16.22,17.75,18.91,17.72,15.41,15.62,17.16,16.94,15.09,15.34,17.16,17.25,15.69,15.53,17.28,18.06,16.72,15.25,15.78,16.34,14.44,11.34,10.31,10.41,8.59,6.28,5.5,6.72,6.94,4.78,4.31,6.38,8.34,8.41,8.97,11.75,14.94,15.88,16.0,17.94,20.81,21.78,20.31,20.22,21.84,21.97,20.09,18.47,19.41,19.66,17.53,15.22,16.06,17.84,17.69,16.44,17.03,18.41,17.78,15.06,13.56,14.44,14.91,13.44,13.06,15.41,17.81,17.47,16.47,17.75,19.38,18.78,16.84,17.06,18.81,19.12,17.84,17.78,19.5,20.41,18.47,17.28,17.97,18.97,17.78,15.94,16.19,17.78,17.5,15.78,16.38,18.66,19.72,18.94,18.53,20.12,20.41,17.97,15.66,16.31,18.0,18.03,17.03,17.91,19.34,18.66,16.28,15.62,17.25,17.66,16.25,15.75,17.62,19.22,18.34,17.16,18.12,19.88,19.06,17.69,17.97,19.41,19.12,17.09,16.41,17.84,18.75,17.38,16.88,18.28,19.62,18.44,16.22,15.91,16.25,14.12,11.22,10.5,11.47,11.78,10.56,11.06,13.31,14.88,13.31,11.59,12.44,13.31,12.59,12.0,14.34,17.88,19.09,19.0,19.97,21.56,21.78,19.19,17.72,18.47,18.62,15.75,12.44,11.53,11.09,8.81,7.5,8.91,12.34,13.59,13.44,14.41,16.81,17.81,16.19,15.66,17.44,18.69,17.09,15.38,15.53,15.56,12.84,8.97,7.28,6.97,5.62,3.88,4.44,7.5,10.16,10.53,11.69,14.69,17.03,16.66,15.81,16.97,18.84,18.91,18.03,19.0,20.97,20.81,18.34,16.34,15.84,14.28,10.44,7.72,8.81,11.12,12.44,13.81,17.91,22.5,23.91,24.28,25.69,28.22,28.81,27.22,25.81,25.31,23.5,18.72,14.03,11.69,10.78,8.25,6.16,6.75,8.5,8.19,6.12,5.41,6.09,5.62,3.22,1.88,3.25,4.53,3.91,3.22,4.66,6.66,6.03,4.75,5.75,8.03,9.0,8.62,9.84,12.78,14.19,13.19,11.62,11.41,10.38,6.69,2.72,1.44,1.78,1.12,0.84,3.47,7.88,11.03,12.44,13.66,15.81,16.38,13.81,11.41,11.78,12.5,11.84,11.38,12.94,15.56,16.34,15.78,16.66,19.03,19.91,18.75,18.09,19.47,20.22,18.09,16.28,15.97,15.44,12.31,8.31,6.81,6.78,6.22,5.28,6.84,10.62,13.19,13.5,14.38,16.75,18.38,17.41,15.97,16.25,16.28,13.38,8.94,6.06,4.41,1.09,-2.91,-4.78,-3.91,-3.38,-4.06,-3.53,-0.41,2.41,2.72,2.75,4.97,7.78,8.09,7.12,7.31,8.06,6.25,2.59,0.5,0.88,1.12,-0.16,-0.56,1.41,3.66,3.62,3.28,5.22,8.06,8.94,8.66,9.84,12.44,13.44,12.81,13.12,15.75,17.47,16.41,14.59,14.47,13.91,10.75,6.72,5.12,5.12,4.72,4.25,6.5,11.06,14.47,16.06,17.88,21.28,23.69,23.5,22.94,24.31,25.84,24.72,22.34,21.53,20.88,18.41,14.5,12.22,12.12,11.0,8.19,6.0,6.56,7.19,5.94,5.44,7.47,10.78,12.66,14.03,17.5,21.12,22.41,21.16,19.91,20.44,19.66,16.91,14.25,13.59,12.84,10.16,7.59,7.72,9.31,9.88,9.22,10.44,13.19,14.19,13.03,12.53,13.59,13.69,11.91,10.41,11.81,14.06,14.88,15.47,17.88,21.25,22.25,21.66,21.88,23.62,23.91,22.56,21.81,23.59,24.41,22.78,20.69,20.81,21.16,19.5,17.38,17.56,19.06,19.41,18.5,19.19,21.91,23.62,23.78,24.34,27.09,29.5,29.12,28.09,29.03,30.03,28.94,26.75,26.5,27.34,26.97,25.28,24.66,26.03,26.38,24.81,23.25,24.28,25.31,24.72,23.56,24.91,26.78,26.78,24.66,23.81,23.69,22.31,19.34,18.03,19.56,21.12,20.62,20.09,21.78,23.56,22.75,21.28,22.0,23.53,23.72,22.47,22.25,23.53,23.19,19.88,17.28,17.16,16.53,14.44,12.69,13.62,15.0,14.81,13.31,13.91,15.28,15.34,13.44,12.94,14.31,15.38,14.5,14.44,17.59,20.72,21.41,21.0,22.56,23.75,22.72,19.97,19.25,19.84,18.97,16.38,15.41,16.78,17.22,15.41,13.75,14.44,15.12,13.62,12.38,13.84,16.34,17.09,16.5,17.72,20.41,21.59,21.22,22.06,24.25,25.59,24.53,23.59,24.62,25.75,24.91,23.0,23.16,24.03,23.09,20.72,20.25,21.53,22.03,20.75,20.19,22.06,23.38,22.41,21.44,22.19,22.72,20.75,18.0,17.88,20.16,21.5,21.53,22.62,24.66,25.25,23.38,22.62,24.41,26.12,25.44,24.0,23.97,24.16,22.44,19.53,18.91,20.06,20.47,19.5,20.06,22.5,24.22,23.59,23.5,25.91,28.84,29.0,27.91,28.16,28.09,25.66,22.06,20.97,22.44,23.31,23.25,24.22,27.41,29.84,29.38,28.5,29.62,30.41,28.31,25.19,24.0,23.47,21.47,18.25,17.09,18.47,19.25,18.62,19.19,22.22,25.0,24.84,24.16,24.66,25.34,23.25,20.62,20.25,21.62,22.09,20.91,21.03,22.75,23.38,21.81,20.78,22.09,23.5,22.81,22.34,24.06,27.12,28.38,28.53,29.88,31.53,30.56,26.62,23.06,21.38,19.06,15.06,12.28,12.44,13.53,13.03,12.75,14.81,18.38,19.81,19.28,20.34,22.75,23.19,21.69,20.75,22.12,22.81,20.56,18.88,20.06,21.81,21.44,20.72,21.53,23.31,22.56,20.5,19.47,20.5,21.09,19.81,19.88,22.06,24.0,22.44,20.12,20.06,20.69,19.28,17.66,18.38,20.19,20.0,17.81,17.56,19.53,20.91,20.78,21.38,23.97,25.97,25.53,25.06,27.09,30.34,31.38,30.97,31.25,31.34,29.19,24.03,19.91,18.47,16.72,13.34,11.5,13.09,14.69,14.22,13.44,14.28,16.12,16.34,16.09,17.31,20.25,21.34,19.56,18.41,19.41,20.38,19.56,19.5,21.91,24.69,24.72,24.06,24.97,27.0,26.62,24.06,22.25,21.62,19.41,15.34,13.03,14.09,15.78,15.91,16.06,18.16,19.97,19.03,16.81,16.5,17.16,16.5,14.5,14.12,16.34,18.12,60.53,62.22,65.0,67.72,68.28,68.25,69.06,70.03,70.03,68.75,68.22,68.22,66.97,64.03,61.44,59.47,56.94,53.38,51.5,52.66,55.78,59.0,62.16,66.44,70.19,71.25,70.97,70.94:30.62,30.0,30.38,28.75,25.91,24.78,24.72,23.34,19.81,17.84,18.47,19.12,17.5,16.94,19.06,21.28,21.19,20.97,23.25,26.5,27.44,27.0,27.91,30.62,31.72,29.88,27.78,27.97,27.38,25.03,23.62,24.88,26.0,23.47,19.28,17.38,17.94,18.03,18.09,20.44,24.88,28.16,29.34,31.25,35.19,39.16,39.53,39.09,40.19,40.94,38.81,35.19,33.28,32.62,30.5,27.19,25.47,26.5,26.81,24.72,23.31,24.28,25.38,23.94,22.25,22.84,24.31,23.78,22.56,23.0,25.06,25.03,22.47,20.38,20.09,19.53,17.12,15.53,16.53,17.94,16.75,15.66,16.78,19.06,19.38,18.06,17.97,18.81,17.38,13.81,11.62,11.91,11.97,10.56,10.16,12.0,13.94,13.44,12.25,12.94,14.41,13.84,11.78,11.25,12.66,12.94,10.94,10.16,11.88,13.25,12.34,12.03,14.31,17.34,17.44,16.62,16.88,18.09,16.75,13.69,12.06,12.59,12.66,11.03,10.31,11.75,13.25,12.16,10.53,11.31,13.28,13.5,13.22,15.28,19.16,22.03,22.94,24.53,27.28,28.12,25.84,23.53,23.72,23.62,21.62,19.41,19.56,21.0,20.41,18.97,19.38,21.25,21.56,19.84,18.81,19.84,19.66,17.62,15.78,16.81,18.44,18.16,17.59,19.22,21.75,21.91,21.03,21.0,22.62,22.75,20.94,19.69,20.78,21.72,20.12,18.81,20.06,21.72,20.53,18.19,17.78,18.44,17.41,15.53,15.56,18.06,19.12,17.72,16.5,17.34,17.66,15.53,13.22,13.53,14.59,13.0,10.72,11.0,13.28,14.72,14.81,16.84,21.19,23.5,23.31,22.78,23.94,24.47,22.5,20.16,20.5,22.34,21.88,20.44,20.66,22.72,22.97,21.53,21.75,23.69,25.03,24.31,23.56,25.56,27.47,26.5,24.38,23.78,23.31,20.97,16.91,15.03,15.16,14.41,12.53,12.5,15.25,17.84,17.88,17.75,19.5,21.19,20.31,18.28,18.28,19.53,18.84,16.34,15.47,17.03,17.59,16.59,16.44,18.69,20.12,18.38,16.22,16.53,17.44,16.28,14.25,14.16,15.31,14.47,12.19,11.19,12.84,13.44,12.12,11.53,13.44,14.84,13.81,12.5,13.75,15.97,16.09,15.19,16.06,17.78,17.53,15.09,13.81,14.16,13.81,11.59,9.69,11.19,12.88,12.34,11.69,13.56,16.38,17.25,17.03,18.28,20.62,21.59,19.84,18.16,18.5,17.38,13.53,9.28,7.97,6.78,3.88,1.25,1.75,4.41,6.03,6.81,9.41,13.69,16.31,16.81,17.69,20.91,23.19,23.28,22.62,24.56,26.56,25.66,23.94,23.59,24.22,23.06,20.25,18.94,18.94,17.88,14.22,11.0,10.47,9.84,7.56,5.5,6.5,8.78,8.88,7.94,9.16,11.25,12.28,11.56,12.5,15.41,17.44,16.75,16.22,17.75,18.91,17.72,15.41,15.62,17.16,16.94,15.09,15.34,17.16,17.25,15.69,15.53,17.28,18.06,16.72,15.25,15.78,16.34,14.44,11.34,10.31,10.41,8.59,6.28,5.5,6.72,6.94,4.78,4.31,6.38,8.34,8.41,8.97,11.75,14.94,15.88,16.0,17.94,20.81,21.78,20.31,20.22,21.84,21.97,20.09,18.47,19.41,19.66,17.53,15.22,16.06,17.84,17.69,16.44,17.03,18.41,17.78,15.06,13.56,14.44,14.91,13.44,13.06,15.41,17.81,17.47,16.47,17.75,19.38,18.78,16.84,17.06,18.81,19.12,17.84,17.78,19.5,20.41,18.47,17.28,17.97,18.97,17.78,15.94,16.19,17.78,17.5,15.78,16.38,18.66,19.72,18.94,18.53,20.12,20.41,17.97,15.66,16.31,18.0,18.03,17.03,17.91,19.34,18.66,16.28,15.62,17.25,17.66,16.25,15.75,17.62,19.22,18.34,17.16,18.12,19.88,19.06,17.69,17.97,19.41,19.12,17.09,16.41,17.84,18.75,17.38,16.88,18.28,19.62,18.44,16.22,15.91,16.25,14.12,11.22,10.5,11.47,11.78,10.56,11.06,13.31,14.88,13.31,11.59,12.44,13.31,12.59,12.0,14.34,17.88,19.09,19.0,19.97,21.56,21.78,19.19,17.72,18.47,18.62,15.75,12.44,11.53,11.09,8.81,7.5,8.91,12.34,13.59,13.44,14.41,16.81,17.81,16.19,15.66,17.44,18.69,17.09,15.38,15.53,15.56,12.84,8.97,7.28,6.97,5.62,3.88,4.44,7.5,10.16,10.53,11.69,14.69,17.03,16.66,15.81,16.97,18.84,18.91,18.03,19.0,20.97,20.81,18.34,16.34,15.84,14.28,10.44,7.72,8.81,11.12,12.44,13.81,17.91,22.5,23.91,24.28,25.69,28.22,28.81,27.22,25.81,25.31,23.5,18.72,14.03,11.69,10.78,8.25,6.16,6.75,8.5,8.19,6.12,5.41,6.09,5.62,3.22,1.88,3.25,4.53,3.91,3.22,4.66,6.66,6.03,4.75,5.75,8.03,9.0,8.62,9.84,12.78,14.19,13.19,11.62,11.41,10.38,6.69,2.72,1.44,1.78,1.12,0.84,3.47,7.88,11.03,12.44,13.66,15.81,16.38,13.81,11.41,11.78,12.5,11.84,11.38,12.94,15.56,16.34,15.78,16.66,19.03,19.91,18.75,18.09,19.47,20.22,18.09,16.28,15.97,15.44,12.31,8.31,6.81,6.78,6.22,5.28,6.84,10.62,13.19,13.5,14.38,16.75,18.38,17.41,15.97,16.25,16.28,13.38,8.94,6.06,4.41,1.09,-2.91,-4.78,-3.91,-3.38,-4.06,-3.53,-0.41,2.41,2.72,2.75,4.97,7.78,8.09,7.12,7.31,8.06,6.25,2.59,0.5,0.88,1.12,-0.16,-0.56,1.41,3.66,3.62,3.28,5.22,8.06,8.94,8.66,9.84,12.44,13.44,12.81,13.12,15.75,17.47,16.41,14.59,14.47,13.91,10.75,6.72,5.12,5.12,4.72,4.25,6.5,11.06,14.47,16.06,17.88,21.28,23.69,23.5,22.94,24.31,25.84,24.72,22.34,21.53,20.88,18.41,14.5,12.22,12.12,11.0,8.19,6.0,6.56,7.19,5.94,5.44,7.47,10.78,12.66,14.03,17.5,21.12,22.41,21.16,19.91,20.44,19.66,16.91,14.25,13.59,12.84,10.16,7.59,7.72,9.31,9.88,9.22,10.44,13.19,14.19,13.03,12.53,13.59,13.69,11.91,10.41,11.81,14.06,14.88,15.47,17.88,21.25,22.25,21.66,21.88,23.62,23.91,22.56,21.81,23.59,24.41,22.78,20.69,20.81,21.16,19.5,17.38,17.56,19.06,19.41,18.5,19.19,21.91,23.62,23.78,24.34,27.09,29.5,29.12,28.09,29.03,30.03,28.94,26.75,26.5,27.34,26.97,25.28,24.66,26.03,26.38,24.81,23.25,24.28,25.31,24.72,23.56,24.91,26.78,26.78,24.66,23.81,23.69,22.31,19.34,18.03,19.56,21.12,20.62,20.09,21.78,23.56,22.75,21.28,22.0,23.53,23.72,22.47,22.25,23.53,23.19,19.88,17.28,17.16,16.53,14.44,12.69,13.62,15.0,14.81,13.31,13.91,15.28,15.34,13.44,12.94,14.31,15.38,14.5,14.44,17.59,20.72,21.41,21.0,22.56,23.75,22.72,19.97,19.25,19.84,18.97,16.38,15.41,16.78,17.22,15.41,13.75,14.44,15.12,13.62,12.38,13.84,16.34,17.09,16.5,17.72,20.41,21.59,21.22,22.06,24.25,25.59,24.53,23.59,24.62,25.75,24.91,23.0,23.16,24.03,23.09,20.72,20.25,21.53,22.03,20.75,20.19,22.06,23.38,22.41,21.44,22.19,22.72,20.75,18.0,17.88,20.16,21.5,21.53,22.62,24.66,25.25,23.38,22.62,24.41,26.12,25.44,24.0,23.97,24.16,22.44,19.53,18.91,20.06,20.47,19.5,20.06,22.5,24.22,23.59,23.5,25.91,28.84,29.0,27.91,28.16,28.09,25.66,22.06,20.97,22.44,23.31,23.25,24.22,27.41,29.84,29.38,28.5,29.62,30.41,28.31,25.19,24.0,23.47,21.47,18.25,17.09,18.47,19.25,18.62,19.19,22.22,25.0,24.84,24.16,24.66,25.34,23.25,20.62,20.25,21.62,22.09,20.91,21.03,22.75,23.38,21.81,20.78,22.09,23.5,22.81,22.34,24.06,27.12,28.38,28.53,29.88,31.53,30.56,26.62,23.06,21.38,19.06,15.06,12.28,12.44,13.53,13.03,12.75,14.81,18.38,19.81,19.28,20.34,22.75,23.19,21.69,20.75,22.12,22.81,20.56,18.88,20.06,21.81,21.44,20.72,21.53,23.31,22.56,20.5,19.47,20.5,21.09,19.81,19.88,22.06,24.0,22.44,20.12,20.06,20.69,19.28,17.66,18.38,20.19,20.0,17.81,17.56,19.53,20.91,20.78,21.38,23.97,25.97,25.53,25.06,27.09,30.34,31.38,30.97,31.25,31.34,29.19,24.03,19.91,18.47,16.72,13.34,11.5,13.09,14.69,14.22,13.44,14.28,16.12,16.34,16.09,17.31,20.25,21.34,19.56,18.41,19.41,20.38,19.56,19.5,21.91,24.69,24.72,24.06,24.97,27.0,26.62,24.06,22.25,21.62,19.41,15.34,13.03,14.09,15.78,15.91,16.06,18.16,19.97,19.03,16.81,16.5,17.16,16.5,14.5,14.12,16.34,18.12,60.53,62.22,65.0,67.72,68.28,68.25,69.06,70.03,70.03,68.75,68.22,68.22,66.97,64.03,61.44,59.47,56.94,53.38,51.5,52.66,55.78,59.0,62.16,66.44,70.19,71.25,70.97,70.94,71.5,71.84,70.56,70.19,70.47,70.78,69.5:23.34,19.81,17.84,18.47,19.12,17.5,16.94,19.06,21.28,21.19,20.97,23.25,26.5,27.44,27.0,27.91,30.62,31.72,29.88,27.78,27.97,27.38,25.03,23.62,24.88,26.0,23.47,19.28,17.38,17.94,18.03,18.09,20.44,24.88,28.16,29.34,31.25,35.19,39.16,39.53,39.09,40.19,40.94,38.81,35.19,33.28,32.62,30.5,27.19,25.47,26.5,26.81,24.72,23.31,24.28,25.38,23.94,22.25,22.84,24.31,23.78,22.56,23.0,25.06,25.03,22.47,20.38,20.09,19.53,17.12,15.53,16.53,17.94,16.75,15.66,16.78,19.06,19.38,18.06,17.97,18.81,17.38,13.81,11.62,11.91,11.97,10.56,10.16,12.0,13.94,13.44,12.25,12.94,14.41,13.84,11.78,11.25,12.66,12.94,10.94,10.16,11.88,13.25,12.34,12.03,14.31,17.34,17.44,16.62,16.88,18.09,16.75,13.69,12.06,12.59,12.66,11.03,10.31,11.75,13.25,12.16,10.53,11.31,13.28,13.5,13.22,15.28,19.16,22.03,22.94,24.53,27.28,28.12,25.84,23.53,23.72,23.62,21.62,19.41,19.56,21.0,20.41,18.97,19.38,21.25,21.56,19.84,18.81,19.84,19.66,17.62,15.78,16.81,18.44,18.16,17.59,19.22,21.75,21.91,21.03,21.0,22.62,22.75,20.94,19.69,20.78,21.72,20.12,18.81,20.06,21.72,20.53,18.19,17.78,18.44,17.41,15.53,15.56,18.06,19.12,17.72,16.5,17.34,17.66,15.53,13.22,13.53,14.59,13.0,10.72,11.0,13.28,14.72,14.81,16.84,21.19,23.5,23.31,22.78,23.94,24.47,22.5,20.16,20.5,22.34,21.88,20.44,20.66,22.72,22.97,21.53,21.75,23.69,25.03,24.31,23.56,25.56,27.47,26.5,24.38,23.78,23.31,20.97,16.91,15.03,15.16,14.41,12.53,12.5,15.25,17.84,17.88,17.75,19.5,21.19,20.31,18.28,18.28,19.53,18.84,16.34,15.47,17.03,17.59,16.59,16.44,18.69,20.12,18.38,16.22,16.53,17.44,16.28,14.25,14.16,15.31,14.47,12.19,11.19,12.84,13.44,12.12,11.53,13.44,14.84,13.81,12.5,13.75,15.97,16.09,15.19,16.06,17.78,17.53,15.09,13.81,14.16,13.81,11.59,9.69,11.19,12.88,12.34,11.69,13.56,16.38,17.25,17.03,18.28,20.62,21.59,19.84,18.16,18.5,17.38,13.53,9.28,7.97,6.78,3.88,1.25,1.75,4.41,6.03,6.81,9.41,13.69,16.31,16.81,17.69,20.91,23.19,23.28,22.62,24.56,26.56,25.66,23.94,23.59,24.22,23.06,20.25,18.94,18.94,17.88,14.22,11.0,10.47,9.84,7.56,5.5,6.5,8.78,8.88,7.94,9.16,11.25,12.28,11.56,12.5,15.41,17.44,16.75,16.22,17.75,18.91,17.72,15.41,15.62,17.16,16.94,15.09,15.34,17.16,17.25,15.69,15.53,17.28,18.06,16.72,15.25,15.78,16.34,14.44,11.34,10.31,10.41,8.59,6.28,5.5,6.72,6.94,4.78,4.31,6.38,8.34,8.41,8.97,11.75,14.94,15.88,16.0,17.94,20.81,21.78,20.31,20.22,21.84,21.97,20.09,18.47,19.41,19.66,17.53,15.22,16.06,17.84,17.69,16.44,17.03,18.41,17.78,15.06,13.56,14.44,14.91,13.44,13.06,15.41,17.81,17.47,16.47,17.75,19.38,18.78,16.84,17.06,18.81,19.12,17.84,17.78,19.5,20.41,18.47,17.28,17.97,18.97,17.78,15.94,16.19,17.78,17.5,15.78,16.38,18.66,19.72,18.94,18.53,20.12,20.41,17.97,15.66,16.31,18.0,18.03,17.03,17.91,19.34,18.66,16.28,15.62,17.25,17.66,16.25,15.75,17.62,19.22,18.34,17.16,18.12,19.88,19.06,17.69,17.97,19.41,19.12,17.09,16.41,17.84,18.75,17.38,16.88,18.28,19.62,18.44,16.22,15.91,16.25,14.12,11.22,10.5,11.47,11.78,10.56,11.06,13.31,14.88,13.31,11.59,12.44,13.31,12.59,12.0,14.34,17.88,19.09,19.0,19.97,21.56,21.78,19.19,17.72,18.47,18.62,15.75,12.44,11.53,11.09,8.81,7.5,8.91,12.34,13.59,13.44,14.41,16.81,17.81,16.19,15.66,17.44,18.69,17.09,15.38,15.53,15.56,12.84,8.97,7.28,6.97,5.62,3.88,4.44,7.5,10.16,10.53,11.69,14.69,17.03,16.66,15.81,16.97,18.84,18.91,18.03,19.0,20.97,20.81,18.34,16.34,15.84,14.28,10.44,7.72,8.81,11.12,12.44,13.81,17.91,22.5,23.91,24.28,25.69,28.22,28.81,27.22,25.81,25.31,23.5,18.72,14.03,11.69,10.78,8.25,6.16,6.75,8.5,8.19,6.12,5.41,6.09,5.62,3.22,1.88,3.25,4.53,3.91,3.22,4.66,6.66,6.03,4.75,5.75,8.03,9.0,8.62,9.84,12.78,14.19,13.19,11.62,11.41,10.38,6.69,2.72,1.44,1.78,1.12,0.84,3.47,7.88,11.03,12.44,13.66,15.81,16.38,13.81,11.41,11.78,12.5,11.84,11.38,12.94,15.56,16.34,15.78,16.66,19.03,19.91,18.75,18.09,19.47,20.22,18.09,16.28,15.97,15.44,12.31,8.31,6.81,6.78,6.22,5.28,6.84,10.62,13.19,13.5,14.38,16.75,18.38,17.41,15.97,16.25,16.28,13.38,8.94,6.06,4.41,1.09,-2.91,-4.78,-3.91,-3.38,-4.06,-3.53,-0.41,2.41,2.72,2.75,4.97,7.78,8.09,7.12,7.31,8.06,6.25,2.59,0.5,0.88,1.12,-0.16,-0.56,1.41,3.66,3.62,3.28,5.22,8.06,8.94,8.66,9.84,12.44,13.44,12.81,13.12,15.75,17.47,16.41,14.59,14.47,13.91,10.75,6.72,5.12,5.12,4.72,4.25,6.5,11.06,14.47,16.06,17.88,21.28,23.69,23.5,22.94,24.31,25.84,24.72,22.34,21.53,20.88,18.41,14.5,12.22,12.12,11.0,8.19,6.0,6.56,7.19,5.94,5.44,7.47,10.78,12.66,14.03,17.5,21.12,22.41,21.16,19.91,20.44,19.66,16.91,14.25,13.59,12.84,10.16,7.59,7.72,9.31,9.88,9.22,10.44,13.19,14.19,13.03,12.53,13.59,13.69,11.91,10.41,11.81,14.06,14.88,15.47,17.88,21.25,22.25,21.66,21.88,23.62,23.91,22.56,21.81,23.59,24.41,22.78,20.69,20.81,21.16,19.5,17.38,17.56,19.06,19.41,18.5,19.19,21.91,23.62,23.78,24.34,27.09,29.5,29.12,28.09,29.03,30.03,28.94,26.75,26.5,27.34,26.97,25.28,24.66,26.03,26.38,24.81,23.25,24.28,25.31,24.72,23.56,24.91,26.78,26.78,24.66,23.81,23.69,22.31,19.34,18.03,19.56,21.12,20.62,20.09,21.78,23.56,22.75,21.28,22.0,23.53,23.72,22.47,22.25,23.53,23.19,19.88,17.28,17.16,16.53,14.44,12.69,13.62,15.0,14.81,13.31,13.91,15.28,15.34,13.44,12.94,14.31,15.38,14.5,14.44,17.59,20.72,21.41,21.0,22.56,23.75,22.72,19.97,19.25,19.84,18.97,16.38,15.41,16.78,17.22,15.41,13.75,14.44,15.12,13.62,12.38,13.84,16.34,17.09,16.5,17.72,20.41,21.59,21.22,22.06,24.25,25.59,24.53,23.59,24.62,25.75,24.91,23.0,23.16,24.03,23.09,20.72,20.25,21.53,22.03,20.75,20.19,22.06,23.38,22.41,21.44,22.19,22.72,20.75,18.0,17.88,20.16,21.5,21.53,22.62,24.66,25.25,23.38,22.62,24.41,26.12,25.44,24.0,23.97,24.16,22.44,19.53,18.91,20.06,20.47,19.5,20.06,22.5,24.22,23.59,23.5,25.91,28.84,29.0,27.91,28.16,28.09,25.66,22.06,20.97,22.44,23.31,23.25,24.22,27.41,29.84,29.38,28.5,29.62,30.41,28.31,25.19,24.0,23.47,21.47,18.25,17.09,18.47,19.25,18.62,19.19,22.22,25.0,24.84,24.16,24.66,25.34,23.25,20.62,20.25,21.62,22.09,20.91,21.03,22.75,23.38,21.81,20.78,22.09,23.5,22.81,22.34,24.06,27.12,28.38,28.53,29.88,31.53,30.56,26.62,23.06,21.38,19.06,15.06,12.28,12.44,13.53,13.03,12.75,14.81,18.38,19.81,19.28,20.34,22.75,23.19,21.69,20.75,22.12,22.81,20.56,18.88,20.06,21.81,21.44,20.72,21.53,23.31,22.56,20.5,19.47,20.5,21.09,19.81,19.88,22.06,24.0,22.44,20.12,20.06,20.69,19.28,17.66,18.38,20.19,20.0,17.81,17.56,19.53,20.91,20.78,21.38,23.97,25.97,25.53,25.06,27.09,30.34,31.38,30.97,31.25,31.34,29.19,24.03,19.91,18.47,16.72,13.34,11.5,13.09,14.69,14.22,13.44,14.28,16.12,16.34,16.09,17.31,20.25,21.34,19.56,18.41,19.41,20.38,19.56,19.5,21.91,24.69,24.72,24.06,24.97,27.0,26.62,24.06,22.25,21.62,19.41,15.34,13.03,14.09,15.78,15.91,16.06,18.16,19.97,19.03,16.81,16.5,17.16,16.5,14.5,14.12,16.34,18.12,60.53,62.22,65.0,67.72,68.28,68.25,69.06,70.03,70.03,68.75,68.22,68.22,66.97,64.03,61.44,59.47,56.94,53.38,51.5,52.66,55.78,59.0,62.16,66.44,70.19,71.25,70.97,70.94,71.5,71.84,70.56,70.19,70.47,70.78,69.5,68.53,69.19,70.19,69.66,68.56,68.38,68.53:negativity
-2.91,-3.88,-5.25,-4.59,-2.19,-0.62,-0.53,0.09,2.75,4.16,3.0,1.0,0.75,0.5,-2.0,-4.97,-6.12,-5.69,-6.53,-7.59,-6.94,-3.97,-1.25,-0.5,0.59,3.53,5.12,3.5,0.97,-0.34,-1.5,-5.25,-9.03,-10.0,-9.16,-8.97,-9.62,-9.25,-7.41,-6.78,-8.06,-8.69,-6.56,-4.69,-4.38,-4.0,-1.03,2.47,3.59,2.94,3.38,4.78,4.31,2.38,1.19,1.84,0.75,-2.88,-5.84,-6.59,-6.38,-7.25,-7.53,-5.19,-1.06,1.28,2.62,4.75,7.88,8.53,6.97,5.69,5.97,5.78,3.31,1.41,2.56,4.12,4.47,4.84,7.41,10.47,11.12,9.75,9.19,9.47,8.22,5.25,3.47,3.84,4.12,2.5,1.41,3.0,5.38,6.47,6.91,8.69,10.72,10.16,7.34,4.97,4.5,3.16,0.28,-1.44,-0.22,0.56,-0.69,-2.16,-2.03,-1.66,-4.09,-6.91,-7.5,-6.56,-6.62,-7.62,-7.31,-4.94,-3.22,-3.16,-2.03,1.41,4.59,5.47,5.41,7.28,9.97,11.16,11.25,12.72,15.16,15.38,13.25,12.03,12.16,11.19,8.19,5.62,5.44,4.72,2.47,-0.5,-1.06,-0.72,-2.47,-4.91,-5.59,-4.28,-3.94,-4.97,-4.28,-1.38,0.31,-0.03,-0.75,0.5,1.59,0.41,-1.66,-1.97,-1.19,-2.44,-5.12,-5.56,-4.16,-3.38,-4.16,-4.06,-2.09,-0.81,-1.34,-2.16,-1.22,0.44,-0.41,-2.62,-3.0,-2.12,-2.59,-3.84,-3.47,-1.0,0.22,-1.09,-2.34,-1.94,-2.44,-5.44,-8.09,-8.25,-7.38,-7.97,-9.47,-9.47,-9.03,-10.12,-12.25,-12.28,-9.81,-7.72,-7.59,-7.38,-5.75,-4.0,-3.84,-3.38,-0.22,3.34,4.53,3.81,3.62,3.94,2.44,-0.53,-1.75,-0.72,-0.38,-2.16,-4.38,-4.78,-5.53,-7.75,-9.81,-9.16,-6.75,-5.34,-4.88,-2.59,1.5,3.88,3.88,4.25,6.66,8.16,6.97,5.62,6.41,6.56,4.5,1.41,0.28,-0.06,-2.28,-5.62,-7.62,-7.69,-8.62,-11.72,-13.75,-13.78,-13.12,-14.59,-15.12,-12.31,-8.34,-5.75,-3.78,-0.12,3.41,5.31,4.62,4.72,6.22,6.84,5.06,3.94,4.81,4.88,2.72,0.25,-0.09,0.16,-1.34,-3.91,-4.88,-4.69,-5.81,-8.03,-8.75,-6.84,-5.06,-5.44,-5.0,-2.78,-0.44,-0.78,-1.88,-1.16,-0.53,-1.75,-4.38,-5.06,-4.44,-4.56,-6.56,-7.59,-6.91,-7.06,-9.69,-11.72,-12.12,-11.84,-12.72,-13.38,-11.5,-8.16,-6.12,-5.12,-2.78,0.44,2.16,0.94,-0.62,-0.72,-1.47,-4.34,-6.19,-5.59,-4.09,-3.91,-4.28,-2.5,0.44,1.38,0.53,0.53,1.03,0.34,-2.25,-4.22,-4.0,-3.5,-5.12,-6.91,-6.66,-6.25,-7.16,-8.19,-7.03,-3.72,-1.41,-1.0,0.19,2.28,3.16,1.75,0.72,1.56,3.03,3.0,2.72,4.5,6.97,6.59,4.12,2.5,1.88,0.06,-3.16,-4.88,-4.06,-3.47,-4.25,-4.38,-2.31,0.06,0.38,-0.03,1.62,4.56,6.19,7.19,9.41,12.44,13.31,11.28,8.97,7.47,5.88,1.78,-0.94,-1.03,0.03,-1.28,-3.44,-4.03,-3.75,-4.62,-6.34,-6.19,-4.72,-3.72,-5.09,-5.06,-2.78,-0.47,-0.38,-0.28,1.62,3.62,3.38,2.31,2.59,3.41,2.56,0.47,-0.09,0.97,1.5,0.19,-0.72,0.03,0.88,-0.62,-2.16,-1.81,-0.72,-1.31,-2.06,-0.69,1.88,3.16,2.84,2.72,4.19,4.41,2.94,1.81,2.72,4.09,3.22,1.88,1.81,2.03,-0.06,-3.47,-5.47,-6.12,-7.91,-11.22,-13.31,-13.19,-12.97,-14.47,-15.34,-14.0,-12.34,-12.91,-13.88,-13.19,-11.56,-11.19,-11.72,-10.22,-7.56,-6.25,-7.53,-8.62,-8.16,-7.59,-8.72,-9.53,-8.16,-6.25,-7.06,-8.66,-9.0,-8.62,-10.28,-13.56,-15.69,-15.81,-16.78,-19.38,-21.12,-20.75,-20.28,-21.84,-23.16,-21.97,-19.75,-19.25,-19.41,-18.41,-16.53,-16.75,-18.59,-19.59,-18.91,-18.12,-18.91,-18.97,-16.88,-14.47,-14.47,-14.91,-14.09,-12.97,-13.88,-16.47,-17.78,-17.94,-18.78,-20.94,-21.12,-18.94,-17.19,-17.12,-16.75,-14.5,-11.38,-10.91,-11.09,-10.22,-9.19,-10.72,-14.25,-16.47,-17.72,-19.62,-22.91,-24.28,-22.69,-20.25,-18.72,-16.34,-11.16,-5.88,-2.69,-0.75,1.94,5.09,5.97,4.72,3.78,3.41,1.28,-2.81,-6.19,-6.78,-7.25,-9.19,-11.09,-11.31,-11.12,-12.69,-14.62,-14.53,-12.34,-11.06,-10.84,-9.94,-7.19,-5.5,-6.06,-5.62,-2.88,-0.12,0.34,0.59,1.69,2.97,1.91,-0.31,-1.22,-0.91,-1.25,-3.19,-4.03,-3.28,-3.03,-4.69,-5.84,-4.75,-2.88,-2.5,-2.88,-2.06,-0.94,-2.25,-4.88,-5.81,-4.75,-4.31,-5.03,-4.81,-2.25,-0.5,-0.59,-0.59,1.03,2.72,2.06,0.38,-0.53,-1.16,-3.25,-6.59,-8.12,-7.19,-6.34,-6.22,-4.84,-1.06,2.25,3.12,3.19,4.47,5.91,5.59,4.81,5.59,7.19,7.41,5.75,5.06,6.09,6.78,5.75,5.12,6.62,7.53,6.09,3.88,3.38,3.44,2.47,1.38,2.75,5.75,7.69,8.09,8.94,11.09,11.56,9.31,6.5,5.47,3.97,1.28,-1.81,-3.0,-3.25,-5.66,-8.75,-10.44,-10.47,-11.16,-12.5,-12.44,-9.78,-6.62,-5.06,-2.75,1.25,4.34,4.53,2.72,1.53,0.34,-2.09,-5.69,-7.84,-7.69,-7.94,-9.78,-11.03,-10.16,-9.56,-10.94,-12.31,-11.62,-10.5,-10.47,-11.38,-10.88,-8.94,-8.09,-8.62,-7.88,-5.69,-4.06,-4.75,-5.25,-4.19,-2.97,-3.34,-3.97,-2.97,-1.75,-2.91,-5.81,-7.81,-8.81,-10.78,-13.56,-14.69,-14.06,-13.22,-14.28,-15.56,-14.81,-14.09,-15.22,-16.84,-16.0,-14.34,-13.69,-13.91,-12.84,-10.53,-9.72,-10.38,-10.19,-7.59,-4.81,-4.25,-4.12,-2.53,-1.78,-3.72,-7.28,-8.97,-10.22,-12.44,-15.72,-17.81,-18.03,-18.94,-21.12,-22.75,-21.94,-21.0,-21.97,-22.22,-19.75,-15.84,-13.06,-10.69,-7.22,-3.41,-1.75,-3.09,-4.53,-5.53,-7.59,-11.5,-14.91,-15.25,-15.16,-16.53,-17.75,-16.75,-15.59,-15.31,-16.53,-16.22,-14.62,-14.12,-15.53,-16.06,-14.94,-14.72,-16.5,-18.03,-17.62,-16.81,-18.28,-20.0,-19.47,-17.62,-16.88,-16.62,-14.09,-10.03,-7.09,-5.84,-4.5,-2.09,-1.69,-4.22,-7.94,-10.09,-12.09,-15.81,-19.53,-20.59,-20.06,-20.34,-21.69,-21.44,-20.09,-19.25,-20.34,-20.28,-18.16,-16.31,-16.66,-17.78,-16.78,-15.53,-16.34,-17.78,-17.56,-16.34,-16.34,-17.44,-16.69,-14.09,-12.31,-12.34,-12.12,-10.75,-9.59,-10.25,-11.66,-11.0,-9.41,-10.12,-11.94,-11.78,-10.22,-9.78,-10.78,-10.78,-9.47,-9.06,-11.78,-14.69,-15.84,-16.88,-19.47,-21.03,-19.25,-15.25,-11.81,-9.56,-6.88,-4.0,-3.53,-5.94,-8.09,-9.09,-10.22,-13.25,-15.75,-15.56,-13.78,-13.53,-14.0,-13.06,-11.34,-11.91,-14.09,-14.78,-13.59,-13.16,-14.22,-14.19,-12.41,-11.25,-12.19,-13.34,-12.53,-10.88,-10.72,-11.44,-9.81,-7.06,-5.94,-6.62,-6.66,-5.34,-5.03,-6.84,-8.16,-8.06,-8.31,-11.38,-15.06,-17.0,-18.0,-19.97,-22.22,-21.81,-19.91,-19.09,-20.09,-20.56,-19.28,-18.38,-19.75,-20.69,-19.53,-18.16,-19.38,-20.84,-20.38,-18.88,-19.0,-19.94,-18.97,-16.47,-14.62,-14.5,-14.12,-11.72,-9.88,-10.84,-12.25,-12.06,-11.31,-12.97,-14.84,-14.81,-12.94,-12.5,-13.59,-13.56,-12.69,-13.5,-16.81,-19.56,-20.22,-20.28,-21.97,-23.34,-21.75,-19.41,-18.91,-19.28,-18.0,-15.88,-15.25,-16.75,-16.81,-15.69,-15.25,-17.12,-18.31,-17.03,-15.62,-16.03,-16.47,-14.69,-11.97,-11.03,-11.12,-10.16,-7.78,-7.75,-9.81,-11.09,-10.38,-10.34,-12.19,-13.25,-12.12,-10.78,-11.5,-12.53,-11.81,-10.25,-10.47,-11.97,-12.0,-10.5,-9.75,-11.03,-11.22,-9.97,-9.25,-10.75,-12.28,-11.75,-10.97,-12.22,-14.53,-15.0,-14.88,-16.56,-19.38,-20.81,-20.09,-19.38,-20.22,-19.91,-17.72,-15.97,-16.81,-17.41,-15.62,-13.03,-12.09,-12.25,-10.91,-9.0,-9.16,-11.19,-12.25,-10.78,-9.78,-10.34,-10.19,-8.59,-7.69,-10.0,-13.25,-14.09,-14.03,-15.12,-16.38,-15.75,-13.91,-13.91,-15.47,-16.19,-15.0,-13.66,-14.38,-15.12,-14.03,-12.97,-14.5,-16.66,-16.91,-16.03,-16.81,-18.25,-17.84,-15.75,-15.16,-16.41,-17.0,-15.38,-14.31,-15.81,-16.97,-15.94,-14.44,-14.12,-14.12,-12.22,-9.44,-9.28,-10.66,-11.81,-11.28,-12.09,-14.69,-16.41,-15.19,-13.84,-13.88,-13.94,-12.03,-10.19,-11.22,-13.81,-14.69,-14.25,-14.94,-16.72,-16.66,-14.47,-12.75,-13.0,-12.69,-10.06,-7.69,-7.34,-7.09,-5.22,-2.97,-3.41,-5.62,-6.91,-6.78,-8.06,-10.81,-12.03,-11.31,-10.97,-12.03,-12.5,-10.09,-7.69,-7.56,-8.09,-6.81,-5.0,-5.44,-7.25,-7.91,-8.03,-9.94,-13.56,-16.22,-16.75,-17.56,-20.72,-23.84,-24.53,-25.0,-27.31,-29.72,-29.56,-27.47,-26.62,-26.47,-24.09,-19.5,-16.53,-15.38,-14.38,-12.0,-10.66,-11.97,-13.88,-13.62,-13.47,-15.88,-19.0,-20.56,-20.69,-22.5,-25.22,-26.28,-25.44,-25.22,-26.53,-26.94,-24.38,-21.56,-20.09,-18.44,-14.59,-10.72,-9.41,-9.62,-8.84,-7.34,-7.75,-9.66,-10.75,-9.72,-8.78,-10.19,-11.38,-10.47:0.09,2.75,4.16,3.0,1.0,0.75,0.5,-2.0,-4.97,-6.12,-5.69,-6.53,-7.59,-6.94,-3.97,-1.25,-0.5,0.59,3.53,5.12,3.5,0.97,-0.34,-1.5,-5.25,-9.03,-10.0,-9.16,-8.97,-9.62,-9.25,-7.41,-6.78,-8.06,-8.69,-6.56,-4.69,-4.38,-4.0,-1.03,2.47,3.59,2.94,3.38,4.78,4.31,2.38,1.19,1.84,0.75,-2.88,-5.84,-6.59,-6.38,-7.25,-7.53,-5.19,-1.06,1.28,2.62,4.75,7.88,8.53,6.97,5.69,5.97,5.78,3.31,1.41,2.56,4.12,4.47,4.84,7.41,10.47,11.12,9.75,9.19,9.47,8.22,5.25,3.47,3.84,4.12,2.5,1.41,3.0,5.38,6.47,6.91,8.69,10.72,10.16,7.34,4.97,4.5,3.16,0.28,-1.44,-0.22,0.56,-0.69,-2.16,-2.03,-1.66,-4.09,-6.91,-7.5,-6.56,-6.62,-7.62,-7.31,-4.94,-3.22,-3.16,-2.03,1.41,4.59,5.47,5.41,7.28,9.97,11.16,11.25,12.72,15.16,15.38,13.25,12.03,12.16,11.19,8.19,5.62,5.44,4.72,2.47,-0.5,-1.06,-0.72,-2.47,-4.91,-5.59,-4.28,-3.94,-4.97,-4.28,-1.38,0.31,-0.03,-0.75,0.5,1.59,0.41,-1.66,-1.97,-1.19,-2.44,-5.12,-5.56,-4.16,-3.38,-4.16,-4.06,-2.09,-0.81,-1.34,-2.16,-1.22,0.44,-0.41,-2.62,-3.0,-2.12,-2.59,-3.84,-3.47,-1.0,0.22,-1.09,-2.34,-1.94,-2.44,-5.44,-8.09,-8.25,-7.38,-7.97,-9.47,-9.47,-9.03,-10.12,-12.25,-12.28,-9.81,-7.72,-7.59,-7.38,-5.75,-4.0,-3.84,-3.38,-0.22,3.34,4.53,3.81,3.62,3.94,2.44,-0.53,-1.75,-0.72,-0.38,-2.16,-4.38,-4.78,-5.53,-7.75,-9.81,-9.16,-6.75,-5.34,-4.88,-2.59,1.5,3.88,3.88,4.25,6.66,8.16,6.97,5.62,6.41,6.56,4.5,1.41,0.28,-0.06,-2.28,-5.62,-7.62,-7.69,-8.62,-11.72,-13.75,-13.78,-13.12,-14.59,-15.12,-12.31,-8.34,-5.75,-3.78,-0.12,3.41,5.31,4.62,4.72,6.22,6.84,5.06,3.94,4.81,4.88,2.72,0.25,-0.09,0.16,-1.34,-3.91,-4.88,-4.69,-5.81,-8.03,-8.75,-6.84,-5.06,-5.44,-5.0,-2.78,-0.44,-0.78,-1.88,-1.16,-0.53,-1.75,-4.38,-5.06,-4.44,-4.56,-6.56,-7.59,-6.91,-7.06,-9.69,-11.72,-12.12,-11.84,-12.72,-13.38,-11.5,-8.16,-6.12,-5.12,-2.78,0.44,2.16,0.94,-0.62,-0.72,-1.47,-4.34,-6.19,-5.59,-4.09,-3.91,-4.28,-2.5,0.44,1.38,0.53,0.53,1.03,0.34,-2.25,-4.22,-4.0,-3.5,-5.12,-6.91,-6.66,-6.25,-7.16,-8.19,-7.03,-3.72,-1.41,-1.0,0.19,2.28,3.16,1.75,0.72,1.56,3.03,3.0,2.72,4.5,6.97,6.59,4.12,2.5,1.88,0.06,-3.16,-4.88,-4.06,-3.47,-4.25,-4.38,-2.31,0.06,0.38,-0.03,1.62,4.56,6.19,7.19,9.41,12.44,13.31,11.28,8.97,7.47,5.88,1.78,-0.94,-1.03,0.03,-1.28,-3.44,-4.03,-3.75,-4.62,-6.34,-6.19,-4.72,-3.72,-5.09,-5.06,-2.78,-0.47,-0.38,-0.28,1.62,3.62,3.38,2.31,2.59,3.41,2.56,0.47,-0.09,0.97,1.5,0.19,-0.72,0.03,0.88,-0.62,-2.16,-1.81,-0.72,-1.31,-2.06,-0.69,1.88,3.16,2.84,2.72,4.19,4.41,2.94,1.81,2.72,4.09,3.22,1.88,1.81,2.03,-0.06,-3.47,-5.47,-6.12,-7.91,-11.22,-13.31,-13.19,-12.97,-14.47,-15.34,-14.0,-12.34,-12.91,-13.88,-13.19,-11.56,-11.19,-11.72,-10.22,-7.56,-6.25,-7.53,-8.62,-8.16,-7.59,-8.72,-9.53,-8.16,-6.25,-7.06,-8.66,-9.0,-8.62,-10.28,-13.56,-15.69,-15.81,-16.78,-19.38,-21.12,-20.75,-20.28,-21.84,-23.16,-21.97,-19.75,-19.25,-19.41,-18.41,-16.53,-16.75,-18.59,-19.59,-18.91,-18.12,-18.91,-18.97,-16.88,-14.47,-14.47,-14.91,-14.09,-12.97,-13.88,-16.47,-17.78,-17.94,-18.78,-20.94,-21.12,-18.94,-17.19,-17.12,-16.75,-14.5,-11.38,-10.91,-11.09,-10.22,-9.19,-10.72,-14.25,-16.47,-17.72,-19.62,-22.91,-24.28,-22.69,-20.25,-18.72,-16.34,-11.16,-5.88,-2.69,-0.75,1.94,5.09,5.97,4.72,3.78,3.41,1.28,-2.81,-6.19,-6.78,-7.25,-9.19,-11.09,-11.31,-11.12,-12.69,-14.62,-14.53,-12.34,-11.06,-10.84,-9.94,-7.19,-5.5,-6.06,-5.62,-2.88,-0.12,0.34,0.59,1.69,2.97,1.91,-0.31,-1.22,-0.91,-1.25,-3.19,-4.03,-3.28,-3.03,-4.69,-5.84,-4.75,-2.88,-2.5,-2.88,-2.06,-0.94,-2.25,-4.88,-5.81,-4.75,-4.31,-5.03,-4.81,-2.25,-0.5,-0.59,-0.59,1.03,2.72,2.06,0.38,-0.53,-1.16,-3.25,-6.59,-8.12,-7.19,-6.34,-6.22,-4.84,-1.06,2.25,3.12,3.19,4.47,5.91,5.59,4.81,5.59,7.19,7.41,5.75,5.06,6.09,6.78,5.75,5.12,6.62,7.53,6.09,3.88,3.38,3.44,2.47,1.38,2.75,5.75,7.69,8.09,8.94,11.09,11.56,9.31,6.5,5.47,3.97,1.28,-1.81,-3.0,-3.25,-5.66,-8.75,-10.44,-10.47,-11.16,-12.5,-12.44,-9.78,-6.62,-5.06,-2.75,1.25,4.34,4.53,2.72,1.53,0.34,-2.09,-5.69,-7.84,-7.69,-7.94,-9.78,-11.03,-10.16,-9.56,-10.94,-12.31,-11.62,-10.5,-10.47,-11.38,-10.88,-8.94,-8.09,-8.62,-7.88,-5.69,-4.06,-4.75,-5.25,-4.19,-2.97,-3.34,-3.97,-2.97,-1.75,-2.91,-5.81,-7.81,-8.81,-10.78,-13.56,-14.69,-14.06,-13.22,-14.28,-15.56,-14.81,-14.09,-15.22,-16.84,-16.0,-14.34,-13.69,-13.91,-12.84,-10.53,-9.72,-10.38,-10.19,-7.59,-4.81,-4.25,-4.12,-2.53,-1.78,-3.72,-7.28,-8.97,-10.22,-12.44,-15.72,-17.81,-18.03,-18.94,-21.12,-22.75,-21.94,-21.0,-21.97,-22.22,-19.75,-15.84,-13.06,-10.69,-7.22,-3.41,-1.75,-3.09,-4.53,-5.53,-7.59,-11.5,-14.91,-15.25,-15.16,-16.53,-17.75,-16.75,-15.59,-15.31,-16.53,-16.22,-14.62,-14.12,-15.53,-16.06,-14.94,-14.72,-16.5,-18.03,-17.62,-16.81,-18.28,-20.0,-19.47,-17.62,-16.88,-16.62,-14.09,-10.03,-7.09,-5.84,-4.5,-2.09,-1.69,-4.22,-7.94,-10.09,-12.09,-15.81,-19.53,-20.59,-20.06,-20.34,-21.69,-21.44,-20.09,-19.25,-20.34,-20.28,-18.16,-16.31,-16.66,-17.78,-16.78,-15.53,-16.34,-17.78,-17.56,-16.34,-16.34,-17.44,-16.69,-14.09,-12.31,-12.34,-12.12,-10.75,-9.59,-10.25,-11.66,-11.0,-9.41,-10.12,-11.94,-11.78,-10.22,-9.78,-10.78,-10.78,-9.47,-9.06,-11.78,-14.69,-15.84,-16.88,-19.47,-21.03,-19.25,-15.25,-11.81,-9.56,-6.88,-4.0,-3.53,-5.94,-8.09,-9.09,-10.22,-13.25,-15.75,-15.56,-13.78,-13.53,-14.0,-13.06,-11.34,-11.91,-14.09,-14.78,-13.59,-13.16,-14.22,-14.19,-12.41,-11.25,-12.19,-13.34,-12.53,-10.88,-10.72,-11.44,-9.81,-7.06,-5.94,-6.62,-6.66,-5.34,-5.03,-6.84,-8.16,-8.06,-8.31,-11.38,-15.06,-17.0,-18.0,-19.97,-22.22,-21.81,-19.91,-19.09,-20.09,-20.56,-19.28,-18.38,-19.75,-20.69,-19.53,-18.16,-19.38,-20.84,-20.38,-18.88,-19.0,-19.94,-18.97,-16.47,-14.62,-14.5,-14.12,-11.72,-9.88,-10.84,-12.25,-12.06,-11.31,-12.97,-14.84,-14.81,-12.94,-12.5,-13.59,-13.56,-12.69,-13.5,-16.81,-19.56,-20.22,-20.28,-21.97,-23.34,-21.75,-19.41,-18.91,-19.28,-18.0,-15.88,-15.25,-16.75,-16.81,-15.69,-15.25,-17.12,-18.31,-17.03,-15.62,-16.03,-16.47,-14.69,-11.97,-11.03,-11.12,-10.16,-7.78,-7.75,-9.81,-11.09,-10.38,-10.34,-12.19,-13.25,-12.12,-10.78,-11.5,-12.53,-11.81,-10.25,-10.47,-11.97,-12.0,-10.5,-9.75,-11.03,-11.22,-9.97,-9.25,-10.75,-12.28,-11.75,-10.97,-12.22,-14.53,-15.0,-14.88,-16.56,-19.38,-20.81,-20.09,-19.38,-20.22,-19.91,-17.72,-15.97,-16.81,-17.41,-15.62,-13.03,-12.09,-12.25,-10.91,-9.0,-9.16,-11.19,-12.25,-10.78,-9.78,-10.34,-10.19,-8.59,-7.69,-10.0,-13.25,-14.09,-14.03,-15.12,-16.38,-15.75,-13.91,-13.91,-15.47,-16.19,-15.0,-13.66,-14.38,-15.12,-14.03,-12.97,-14.5,-16.66,-16.91,-16.03,-16.81,-18.25,-17.84,-15.75,-15.16,-16.41,-17.0,-15.38,-14.31,-15.81,-16.97,-15.94,-14.44,-14.12,-14.12,-12.22,-9.44,-9.28,-10.66,-11.81,-11.28,-12.09,-14.69,-16.41,-15.19,-13.84,-13.88,-13.94,-12.03,-10.19,-11.22,-13.81,-14.69,-14.25,-14.94,-16.72,-16.66,-14.47,-12.75,-13.0,-12.69,-10.06,-7.69,-7.34,-7.09,-5.22,-2.97,-3.41,-5.62,-6.91,-6.78,-8.06,-10.81,-12.03,-11.31,-10.97,-12.03,-12.5,-10.09,-7.69,-7.56,-8.09,-6.81,-5.0,-5.44,-7.25,-7.91,-8.03,-9.94,-13.56,-16.22,-16.75,-17.56,-20.72,-23.84,-24.53,-25.0,-27.31,-29.72,-29.56,-27.47,-26.62,-26.47,-24.09,-19.5,-16.53,-15.38,-14.38,-12.0,-10.66,-11.97,-13.88,-13.62,-13.47,-15.88,-19.0,-20.56,-20.69,-22.5,-25.22,-26.28,-25.44,-25.22,-26.53,-26.94,-24.38,-21.56,-20.09,-18.44,-14.59,-10.72,-9.41,-9.62,-8.84,-7.34,-7.75,-9.66,-10.75,-9.72,-8.78,-10.19,-11.38,-10.47,8.94,7.41,6.56,7.12,8.62,9.53,10.31:-2.0,-4.97,-6.12,-5.69,-6.53,-7.59,-6.94,-3.97,-1.25,-0.5,0.59,3.53,5.12,3.5,0.97,-0.34,-1.5,-5.25,-9.03,-10.0,-9.16,-8.97,-9.62,-9.25,-7.41,-6.78,-8.06,-8.69,-6.56,-4.69,-4.38,-4.0,-1.03,2.47,3.59,2.94,3.38,4.78,4.31,2.38,1.19,1.84,0.75,-2.88,-5.84,-6.59,-6.38,-7.25,-7.53,-5.19,-1.06,1.28,2.62,4.75,7.88,8.53,6.97,5.69,5.97,5.78,3.31,1.41,2.56,4.12,4.47,4.84,7.41,10.47,11.12,9.75,9.19,9.47,8.22,5.25,3.47,3.84,4.12,2.5,1.41,3.0,5.38,6.47,6.91,8.69,10.72,10.16,7.34,4.97,4.5,3.16,0.28,-1.44,-0.22,0.56,-0.69,-2.16,-2.03,-1.66,-4.09,-6.91,-7.5,-6.56,-6.62,-7.62,-7.31,-4.94,-3.22,-3.16,-2.03,1.41,4.59,5.47,5.41,7.28,9.97,11.16,11.25,12.72,15.16,15.38,13.25,12.03,12.16,11.19,8.19,5.62,5.44,4.72,2.47,-0.5,-1.06,-0.72,-2.47,-4.91,-5.59,-4.28,-3.94,-4.97,-4.28,-1.38,0.31,-0.03,-0.75,0.5,1.59,0.41,-1.66,-1.97,-1.19,-2.44,-5.12,-5.56,-4.16,-3.38,-4.16,-4.06,-2.09,-0.81,-1.34,-2.16,-1.22,0.44,-0.41,-2.62,-3.0,-2.12,-2.59,-3.84,-3.47,-1.0,0.22,-1.09,-2.34,-1.94,-2.44,-5.44,-8.09,-8.25,-7.38,-7.97,-9.47,-9.47,-9.03,-10.12,-12.25,-12.28,-9.81,-7.72,-7.59,-7.38,-5.75,-4.0,-3.84,-3.38,-0.22,3.34,4.53,3.81,3.62,3.94,2.44,-0.53,-1.75,-0.72,-0.38,-2.16,-4.38,-4.78,-5.53,-7.75,-9.81,-9.16,-6.75,-5.34,-4.88,-2.59,1.5,3.88,3.88,4.25,6.66,8.16,6.97,5.62,6.41,6.56,4.5,1.41,0.28,-0.06,-2.28,-5.62,-7.62,-7.69,-8.62,-11.72,-13.75,-13.78,-13.12,-14.59,-15.12,-12.31,-8.34,-5.75,-3.78,-0.12,3.41,5.31,4.62,4.72,6.22,6.84,5.06,3.94,4.81,4.88,2.72,0.25,-0.09,0.16,-1.34,-3.91,-4.88,-4.69,-5.81,-8.03,-8.75,-6.84,-5.06,-5.44,-5.0,-2.78,-0.44,-0.78,-1.88,-1.16,-0.53,-1.75,-4.38,-5.06,-4.44,-4.56,-6.56,-7.59,-6.91,-7.06,-9.69,-11.72,-12.12,-11.84,-12.72,-13.38,-11.5,-8.16,-6.12,-5.12,-2.78,0.44,2.16,0.94,-0.62,-0.72,-1.47,-4.34,-6.19,-5.59,-4.09,-3.91,-4.28,-2.5,0.44,1.38,0.53,0.53,1.03,0.34,-2.25,-4.22,-4.0,-3.5,-5.12,-6.91,-6.66,-6.25,-7.16,-8.19,-7.03,-3.72,-1.41,-1.0,0.19,2.28,3.16,1.75,0.72,1.56,3.03,3.0,2.72,4.5,6.97,6.59,4.12,2.5,1.88,0.06,-3.16,-4.88,-4.06,-3.47,-4.25,-4.38,-2.31,0.06,0.38,-0.03,1.62,4.56,6.19,7.19,9.41,12.44,13.31,11.28,8.97,7.47,5.88,1.78,-0.94,-1.03,0.03,-1.28,-3.44,-4.03,-3.75,-4.62,-6.34,-6.19,-4.72,-3.72,-5.09,-5.06,-2.78,-0.47,-0.38,-0.28,1.62,3.62,3.38,2.31,2.59,3.41,2.56,0.47,-0.09,0.97,1.5,0.19,-0.72,0.03,0.88,-0.62,-2.16,-1.81,-0.72,-1.31,-2.06,-0.69,1.88,3.16,2.84,2.72,4.19,4.41,2.94,1.81,2.72,4.09,3.22,1.88,1.81,2.03,-0.06,-3.47,-5.47,-6.12,-7.91,-11.22,-13.31,-13.19,-12.97,-14.47,-15.34,-14.0,-12.34,-12.91,-13.88,-13.19,-11.56,-11.19,-11.72,-10.22,-7.56,-6.25,-7.53,-8.62,-8.16,-7.59,-8.72,-9.53,-8.16,-6.25,-7.06,-8.66,-9.0,-8.62,-10.28,-13.56,-15.69,-15.81,-16.78,-19.38,-21.12,-20.75,-20.28,-21.84,-23.16,-21.97,-19.75,-19.25,-19.41,-18.41,-16.53,-16.75,-18.59,-19.59,-18.91,-18.12,-18.91,-18.97,-16.88,-14.47,-14.47,-14.91,-14.09,-12.97,-13.88,-16.47,-17.78,-17.94,-18.78,-20.94,-21.12,-18.94,-17.19,-17.12,-16.75,-14.5,-11.38,-10.91,-11.09,-10.22,-9.19,-10.72,-14.25,-16.47,-17.72,-19.62,-22.91,-24.28,-22.69,-20.25,-18.72,-16.34,-11.16,-5.88,-2.69,-0.75,1.94,5.09,5.97,4.72,3.78,3.41,1.28,-2.81,-6.19,-6.78,-7.25,-9.19,-11.09,-11.31,-11.12,-12.69,-14.62,-14.53,-12.34,-11.06,-10.84,-9.94,-7.19,-5.5,-6.06,-5.62,-2.88,-0.12,0.34,0.59,1.69,2.97,1.91,-0.31,-1.22,-0.91,-1.25,-3.19,-4.03,-3.28,-3.03,-4.69,-5.84,-4.75,-2.88,-2.5,-2.88,-2.06,-0.94,-2.25,-4.88,-5.81,-4.75,-4.31,-5.03,-4.81,-2.25,-0.5,-0.59,-0.59,1.03,2.72,2.06,0.38,-0.53,-1.16,-3.25,-6.59,-8.12,-7.19,-6.34,-6.22,-4.84,-1.06,2.25,3.12,3.19,4.47,5.91,5.59,4.81,5.59,7.19,7.41,5.75,5.06,6.09,6.78,5.75,5.12,6.62,7.53,6.09,3.88,3.38,3.44,2.47,1.38,2.75,5.75,7.69,8.09,8.94,11.09,11.56,9.31,6.5,5.47,3.97,1.28,-1.81,-3.0,-3.25,-5.66,-8.75,-10.44,-10.47,-11.16,-12.5,-12.44,-9.78,-6.62,-5.06,-2.75,1.25,4.34,4.53,2.72,1.53,0.34,-2.09,-5.69,-7.84,-7.69,-7.94,-9.78,-11.03,-10.16,-9.56,-10.94,-12.31,-11.62,-10.5,-10.47,-11.38,-10.88,-8.94,-8.09,-8.62,-7.88,-5.69,-4.06,-4.75,-5.25,-4.19,-2.97,-3.34,-3.97,-2.97,-1.75,-2.91,-5.81,-7.81,-8.81,-10.78,-13.56,-14.69,-14.06,-13.22,-14.28,-15.56,-14.81,-14.09,-15.22,-16.84,-16.0,-14.34,-13.69,-13.91,-12.84,-10.53,-9.72,-10.38,-10.19,-7.59,-4.81,-4.25,-4.12,-2.53,-1.78,-3.72,-7.28,-8.97,-10.22,-12.44,-15.72,-17.81,-18.03,-18.94,-21.12,-22.75,-21.94,-21.0,-21.97,-22.22,-19.75,-15.84,-13.06,-10.69,-7.22,-3.41,-1.75,-3.09,-4.53,-5.53,-7.59,-11.5,-14.91,-15.25,-15.16,-16.53,-17.75,-16.75,-15.59,-15.31,-16.53,-16.22,-14.62,-14.12,-15.53,-16.06,-14.94,-14.72,-16.5,-18.03,-17.62,-16.81,-18.28,-20.0,-19.47,-17.62,-16.88,-16.62,-14.09,-10.03,-7.09,-5.84,-4.5,-2.09,-1.69,-4.22,-7.94,-10.09,-12.09,-15.81,-19.53,-20.59,-20.06,-20.34,-21.69,-21.44,-20.09,-19.25,-20.34,-20.28,-18.16,-16.31,-16.66,-17.78,-16.78,-15.53,-16.34,-17.78,-17.56,-16.34,-16.34,-17.44,-16.69,-14.09,-12.31,-12.34,-12.12,-10.75,-9.59,-10.25,-11.66,-11.0,-9.41,-10.12,-11.94,-11.78,-10.22,-9.78,-10.78,-10.78,-9.47,-9.06,-11.78,-14.69,-15.84,-16.88,-19.47,-21.03,-19.25,-15.25,-11.81,-9.56,-6.88,-4.0,-3.53,-5.94,-8.09,-9.09,-10.22,-13.25,-15.75,-15.56,-13.78,-13.53,-14.0,-13.06,-11.34,-11.91,-14.09,-14.78,-13.59,-13.16,-14.22,-14.19,-12.41,-11.25,-12.19,-13.34,-12.53,-10.88,-10.72,-11.44,-9.81,-7.06,-5.94,-6.62,-6.66,-5.34,-5.03,-6.84,-8.16,-8.06,-8.31,-11.38,-15.06,-17.0,-18.0,-19.97,-22.22,-21.81,-19.91,-19.09,-20.09,-20.56,-19.28,-18.38,-19.75,-20.69,-19.53,-18.16,-19.38,-20.84,-20.38,-18.88,-19.0,-19.94,-18.97,-16.47,-14.62,-14.5,-14.12,-11.72,-9.88,-10.84,-12.25,-12.06,-11.31,-12.97,-14.84,-14.81,-12.94,-12.5,-13.59,-13.56,-12.69,-13.5,-16.81,-19.56,-20.22,-20.28,-21.97,-23.34,-21.75,-19.41,-18.91,-19.28,-18.0,-15.88,-15.25,-16.75,-16.81,-15.69,-15.25,-17.12,-18.31,-17.03,-15.62,-16.03,-16.47,-14.69,-11.97,-11.03,-11.12,-10.16,-7.78,-7.75,-9.81,-11.09,-10.38,-10.34,-12.19,-13.25,-12.12,-10.78,-11.5,-12.53,-11.81,-10.25,-10.47,-11.97,-12.0,-10.5,-9.75,-11.03,-11.22,-9.97,-9.25,-10.75,-12.28,-11.75,-10.97,-12.22,-14.53,-15.0,-14.88,-16.56,-19.38,-20.81,-20.09,-19.38,-20.22,-19.91,-17.72,-15.97,-16.81,-17.41,-15.62,-13.03,-12.09,-12.25,-10.91,-9.0,-9.16,-11.19,-12.25,-10.78,-9.78,-10.34,-10.19,-8.59,-7.69,-10.0,-13.25,-14.09,-14.03,-15.12,-16.38,-15.75,-13.91,-13.91,-15.47,-16.19,-15.0,-13.66,-14.38,-15.12,-14.03,-12.97,-14.5,-16.66,-16.91,-16.03,-16.81,-18.25,-17.84,-15.75,-15.16,-16.41,-17.0,-15.38,-14.31,-15.81,-16.97,-15.94,-14.44,-14.12,-14.12,-12.22,-9.44,-9.28,-10.66,-11.81,-11.28,-12.09,-14.69,-16.41,-15.19,-13.84,-13.88,-13.94,-12.03,-10.19,-11.22,-13.81,-14.69,-14.25,-14.94,-16.72,-16.66,-14.47,-12.75,-13.0,-12.69,-10.06,-7.69,-7.34,-7.09,-5.22,-2.97,-3.41,-5.62,-6.91,-6.78,-8.06,-10.81,-12.03,-11.31,-10.97,-12.03,-12.5,-10.09,-7.69,-7.56,-8.09,-6.81,-5.0,-5.44,-7.25,-7.91,-8.03,-9.94,-13.56,-16.22,-16.75,-17.56,-20.72,-23.84,-24.53,-25.0,-27.31,-29.72,-29.56,-27.47,-26.62,-26.47,-24.09,-19.5,-16.53,-15.38,-14.38,-12.0,-10.66,-11.97,-13.88,-13.62,-13.47,-15.88,-19.0,-20.56,-20.69,-22.5,-25.22,-26.28,-25.44,-25.22,-26.53,-26.94,-24.38,-21.56,-20.09,-18.44,-14.59,-10.72,-9.41,-9.62,-8.84,-7.34,-7.75,-9.66,-10.75,-9.72,-8.78,-10.19,-11.38,-10.47,8.94,7.41,6.56,7.12,8.62,9.53,10.31,11.69,13.53,14.06,12.72,11.0,10.06,8.84:-3.97,-1.25,-0.5,0.59,3.53,5.12,3.5,0.97,-0.34,-1.5,-5.25,-9.03,-10.0,-9.16,-8.97,-9.62,-9.25,-7.41,-6.78,-8.06,-8.69,-6.56,-4.69,-4.38,-4.0,-1.03,2.47,3.59,2.94,3.38,4.78,4.31,2.38,1.19,1.84,0.75,-2.88,-5.84,-6.59,-6.38,-7.25,-7.53,-5.19,-1.06,1.28,2.62,4.75,7.88,8.53,6.97,5.69,5.97,5.78,3.31,1.41,2.56,4.12,4.47,4.84,7.41,10.47,11.12,9.75,9.19,9.47,8.22,5.25,3.47,3.84,4.12,2.5,1.41,3.0,5.38,6.47,6.91,8.69,10.72,10.16,7.34,4.97,4.5,3.16,0.28,-1.44,-0.22,0.56,-0.69,-2.16,-2.03,-1.66,-4.09,-6.91,-7.5,-6.56,-6.62,-7.62,-7.31,-4.94,-3.22,-3.16,-2.03,1.41,4.59,5.47,5.41,7.28,9.97,11.16,11.25,12.72,15.16,15.38,13.25,12.03,12.16,11.19,8.19,5.62,5.44,4.72,2.47,-0.5,-1.06,-0.72,-2.47,-4.91,-5.59,-4.28,-3.94,-4.97,-4.28,-1.38,0.31,-0.03,-0.75,0.5,1.59,0.41,-1.66,-1.97,-1.19,-2.44,-5.12,-5.56,-4.16,-3.38,-4.16,-4.06,-2.09,-0.81,-1.34,-2.16,-1.22,0.44,-0.41,-2.62,-3.0,-2.12,-2.59,-3.84,-3.47,-1.0,0.22,-1.09,-2.34,-1.94,-2.44,-5.44,-8.09,-8.25,-7.38,-7.97,-9.47,-9.47,-9.03,-10.12,-12.25,-12.28,-9.81,-7.72,-7.59,-7.38,-5.75,-4.0,-3.84,-3.38,-0.22,3.34,4.53,3.81,3.62,3.94,2.44,-0.53,-1.75,-0.72,-0.38,-2.16,-4.38,-4.78,-5.53,-7.75,-9.81,-9.16,-6.75,-5.34,-4.88,-2.59,1.5,3.88,3.88,4.25,6.66,8.16,6.97,5.62,6.41,6.56,4.5,1.41,0.28,-0.06,-2.28,-5.62,-7.62,-7.69,-8.62,-11.72,-13.75,-13.78,-13.12,-14.59,-15.12,-12.31,-8.34,-5.75,-3.78,-0.12,3.41,5.31,4.62,4.72,6.22,6.84,5.06,3.94,4.81,4.88,2.72,0.25,-0.09,0.16,-1.34,-3.91,-4.88,-4.69,-5.81,-8.03,-8.75,-6.84,-5.06,-5.44,-5.0,-2.78,-0.44,-0.78,-1.88,-1.16,-0.53,-1.75,-4.38,-5.06,-4.44,-4.56,-6.56,-7.59,-6.91,-7.06,-9.69,-11.72,-12.12,-11.84,-12.72,-13.38,-11.5,-8.16,-6.12,-5.12,-2.78,0.44,2.16,0.94,-0.62,-0.72,-1.47,-4.34,-6.19,-5.59,-4.09,-3.91,-4.28,-2.5,0.44,1.38,0.53,0.53,1.03,0.34,-2.25,-4.22,-4.0,-3.5,-5.12,-6.91,-6.66,-6.25,-7.16,-8.19,-7.03,-3.72,-1.41,-1.0,0.19,2.28,3.16,1.75,0.72,1.56,3.03,3.0,2.72,4.5,6.97,6.59,4.12,2.5,1.88,0.06,-3.16,-4.88,-4.06,-3.47,-4.25,-4.38,-2.31,0.06,0.38,-0.03,1.62,4.56,6.19,7.19,9.41,12.44,13.31,11.28,8.97,7.47,5.88,1.78,-0.94,-1.03,0.03,-1.28,-3.44,-4.03,-3.75,-4.62,-6.34,-6.19,-4.72,-3.72,-5.09,-5.06,-2.78,-0.47,-0.38,-0.28,1.62,3.62,3.38,2.31,2.59,3.41,2.56,0.47,-0.09,0.97,1.5,0.19,-0.72,0.03,0.88,-0.62,-2.16,-1.81,-0.72,-1.31,-2.06,-0.69,1.88,3.16,2.84,2.72,4.19,4.41,2.94,1.81,2.72,4.09,3.22,1.88,1.81,2.03,-0.06,-3.47,-5.47,-6.12,-7.91,-11.22,-13.31,-13.19,-12.97,-14.47,-15.34,-14.0,-12.34,-12.91,-13.88,-13.19,-11.56,-11.19,-11.72,-10.22,-7.56,-6.25,-7.53,-8.62,-8.16,-7.59,-8.72,-9.53,-8.16,-6.25,-7.06,-8.66,-9.0,-8.62,-10.28,-13.56,-15.69,-15.81,-16.78,-19.38,-21.12,-20.75,-20.28,-21.84,-23.16,-21.97,-19.75,-19.25,-19.41,-18.41,-16.53,-16.75,-18.59,-19.59,-18.91,-18.12,-18.91,-18.97,-16.88,-14.47,-14.47,-14.91,-14.09,-12.97,-13.88,-16.47,-17.78,-17.94,-18.78,-20.94,-21.12,-18.94,-17.19,-17.12,-16.75,-14.5,-11.38,-10.91,-11.09,-10.22,-9.19,-10.72,-14.25,-16.47,-17.72,-19.62,-22.91,-24.28,-22.69,-20.25,-18.72,-16.34,-11.16,-5.88,-2.69,-0.75,1.94,5.09,5.97,4.72,3.78,3.41,1.28,-2.81,-6.19,-6.78,-7.25,-9.19,-11.09,-11.31,-11.12,-12.69,-14.62,-14.53,-12.34,-11.06,-10.84,-9.94,-7.19,-5.5,-6.06,-5.62,-2.88,-0.12,0.34,0.59,1.69,2.97,1.91,-0.31,-1.22,-0.91,-1.25,-3.19,-4.03,-3.28,-3.03,-4.69,-5.84,-4.75,-2.88,-2.5,-2.88,-2.06,-0.94,-2.25,-4.88,-5.81,-4.75,-4.31,-5.03,-4.81,-2.25,-0.5,-0.59,-0.59,1.03,2.72,2.06,0.38,-0.53,-1.16,-3.25,-6.59,-8.12,-7.19,-6.34,-6.22,-4.84,-1.06,2.25,3.12,3.19,4.47,5.91,5.59,4.81,5.59,7.19,7.41,5.75,5.06,6.09,6.78,5.75,5.12,6.62,7.53,6.09,3.88,3.38,3.44,2.47,1.38,2.75,5.75,7.69,8.09,8.94,11.09,11.56,9.31,6.5,5.47,3.97,1.28,-1.81,-3.0,-3.25,-5.66,-8.75,-10.44,-10.47,-11.16,-12.5,-12.44,-9.78,-6.62,-5.06,-2.75,1.25,4.34,4.53,2.72,1.53,0.34,-2.09,-5.69,-7.84,-7.69,-7.94,-9.78,-11.03,-10.16,-9.56,-10.94,-12.31,-11.62,-10.5,-10.47,-11.38,-10.88,-8.94,-8.09,-8.62,-7.88,-5.69,-4.06,-4.75,-5.25,-4.19,-2.97,-3.34,-3.97,-2.97,-1.75,-2.91,-5.81,-7.81,-8.81,-10.78,-13.56,-14.69,-14.06,-13.22,-14.28,-15.56,-14.81,-14.09,-15.22,-16.84,-16.0,-14.34,-13.69,-13.91,-12.84,-10.53,-9.72,-10.38,-10.19,-7.59,-4.81,-4.25,-4.12,-2.53,-1.78,-3.72,-7.28,-8.97,-10.22,-12.44,-15.72,-17.81,-18.03,-18.94,-21.12,-22.75,-21.94,-21.0,-21.97,-22.22,-19.75,-15.84,-13.06,-10.69,-7.22,-3.41,-1.75,-3.09,-4.53,-5.53,-7.59,-11.5,-14.91,-15.25,-15.16,-16.53,-17.75,-16.75,-15.59,-15.31,-16.53,-16.22,-14.62,-14.12,-15.53,-16.06,-14.94,-14.72,-16.5,-18.03,-17.62,-16.81,-18.28,-20.0,-19.47,-17.62,-16.88,-16.62,-14.09,-10.03,-7.09,-5.84,-4.5,-2.09,-1.69,-4.22,-7.94,-10.09,-12.09,-15.81,-19.53,-20.59,-20.06,-20.34,-21.69,-21.44,-20.09,-19.25,-20.34,-20.28,-18.16,-16.31,-16.66,-17.78,-16.78,-15.53,-16.34,-17.78,-17.56,-16.34,-16.34,-17.44,-16.69,-14.09,-12.31,-12.34,-12.12,-10.75,-9.59,-10.25,-11.66,-11.0,-9.41,-10.12,-11.94,-11.78,-10.22,-9.78,-10.78,-10.78,-9.47,-9.06,-11.78,-14.69,-15.84,-16.88,-19.47,-21.03,-19.25,-15.25,-11.81,-9.56,-6.88,-4.0,-3.53,-5.94,-8.09,-9.09,-10.22,-13.25,-15.75,-15.56,-13.78,-13.53,-14.0,-13.06,-11.34,-11.91,-14.09,-14.78,-13.59,-13.16,-14.22,-14.19,-12.41,-11.25,-12.19,-13.34,-12.53,-10.88,-10.72,-11.44,-9.81,-7.06,-5.94,-6.62,-6.66,-5.34,-5.03,-6.84,-8.16,-8.06,-8.31,-11.38,-15.06,-17.0,-18.0,-19.97,-22.22,-21.81,-19.91,-19.09,-20.09,-20.56,-19.28,-18.38,-19.75,-20.69,-19.53,-18.16,-19.38,-20.84,-20.38,-18.88,-19.0,-19.94,-18.97,-16.47,-14.62,-14.5,-14.12,-11.72,-9.88,-10.84,-12.25,-12.06,-11.31,-12.97,-14.84,-14.81,-12.94,-12.5,-13.59,-13.56,-12.69,-13.5,-16.81,-19.56,-20.22,-20.28,-21.97,-23.34,-21.75,-19.41,-18.91,-19.28,-18.0,-15.88,-15.25,-16.75,-16.81,-15.69,-15.25,-17.12,-18.31,-17.03,-15.62,-16.03,-16.47,-14.69,-11.97,-11.03,-11.12,-10.16,-7.78,-7.75,-9.81,-11.09,-10.38,-10.34,-12.19,-13.25,-12.12,-10.78,-11.5,-12.53,-11.81,-10.25,-10.47,-11.97,-12.0,-10.5,-9.75,-11.03,-11.22,-9.97,-9.25,-10.75,-12.28,-11.75,-10.97,-12.22,-14.53,-15.0,-14.88,-16.56,-19.38,-20.81,-20.09,-19.38,-20.22,-19.91,-17.72,-15.97,-16.81,-17.41,-15.62,-13.03,-12.09,-12.25,-10.91,-9.0,-9.16,-11.19,-12.25,-10.78,-9.78,-10.34,-10.19,-8.59,-7.69,-10.0,-13.25,-14.09,-14.03,-15.12,-16.38,-15.75,-13.91,-13.91,-15.47,-16.19,-15.0,-13.66,-14.38,-15.12,-14.03,-12.97,-14.5,-16.66,-16.91,-16.03,-16.81,-18.25,-17.84,-15.75,-15.16,-16.41,-17.0,-15.38,-14.31,-15.81,-16.97,-15.94,-14.44,-14.12,-14.12,-12.22,-9.44,-9.28,-10.66,-11.81,-11.28,-12.09,-14.69,-16.41,-15.19,-13.84,-13.88,-13.94,-12.03,-10.19,-11.22,-13.81,-14.69,-14.25,-14.94,-16.72,-16.66,-14.47,-12.75,-13.0,-12.69,-10.06,-7.69,-7.34,-7.09,-5.22,-2.97,-3.41,-5.62,-6.91,-6.78,-8.06,-10.81,-12.03,-11.31,-10.97,-12.03,-12.5,-10.09,-7.69,-7.56,-8.09,-6.81,-5.0,-5.44,-7.25,-7.91,-8.03,-9.94,-13.56,-16.22,-16.75,-17.56,-20.72,-23.84,-24.53,-25.0,-27.31,-29.72,-29.56,-27.47,-26.62,-26.47,-24.09,-19.5,-16.53,-15.38,-14.38,-12.0,-10.66,-11.97,-13.88,-13.62,-13.47,-15.88,-19.0,-20.56,-20.69,-22.5,-25.22,-26.28,-25.44,-25.22,-26.53,-26.94,-24.38,-21.56,-20.09,-18.44,-14.59,-10.72,-9.41,-9.62,-8.84,-7.34,-7.75,-9.66,-10.75,-9.72,-8.78,-10.19,-11.38,-10.47,8.94,7.41,6.56,7.12,8.62,9.53,10.31,11.69,13.53,14.06,12.72,11.0,10.06,8.84,6.81,5.28,5.31,5.59,5.41,5.47,6.38:0.97,-0.34,-1.5,-5.25,-9.03,-10.0,-9.16,-8.97,-9.62,-9.25,-7.41,-6.78,-8.06,-8.69,-6.56,-4.69,-4.38,-4.0,-1.03,2.47,3.59,2.94,3.38,4.78,4.31,2.38,1.19,1.84,0.75,-2.88,-5.84,-6.59,-6.38,-7.25,-7.53,-5.19,-1.06,1.28,2.62,4.75,7.88,8.53,6.97,5.69,5.97,5.78,3.31,1.41,2.56,4.12,4.47,4.84,7.41,10.47,11.12,9.75,9.19,9.47,8.22,5.25,3.47,3.84,4.12,2.5,1.41,3.0,5.38,6.47,6.91,8.69,10.72,10.16,7.34,4.97,4.5,3.16,0.28,-1.44,-0.22,0.56,-0.69,-2.16,-2.03,-1.66,-4.09,-6.91,-7.5,-6.56,-6.62,-7.62,-7.31,-4.94,-3.22,-3.16,-2.03,1.41,4.59,5.47,5.41,7.28,9.97,11.16,11.25,12.72,15.16,15.38,13.25,12.03,12.16,11.19,8.19,5.62,5.44,4.72,2.47,-0.5,-1.06,-0.72,-2.47,-4.91,-5.59,-4.28,-3.94,-4.97,-4.28,-1.38,0.31,-0.03,-0.75,0.5,1.59,0.41,-1.66,-1.97,-1.19,-2.44,-5.12,-5.56,-4.16,-3.38,-4.16,-4.06,-2.09,-0.81,-1.34,-2.16,-1.22,0.44,-0.41,-2.62,-3.0,-2.12,-2.59,-3.84,-3.47,-1.0,0.22,-1.09,-2.34,-1.94,-2.44,-5.44,-8.09,-8.25,-7.38,-7.97,-9.47,-9.47,-9.03,-10.12,-12.25,-12.28,-9.81,-7.72,-7.59,-7.38,-5.75,-4.0,-3.84,-3.38,-0.22,3.34,4.53,3.81,3.62,3.94,2.44,-0.53,-1.75,-0.72,-0.38,-2.16,-4.38,-4.78,-5.53,-7.75,-9.81,-9.16,-6.75,-5.34,-4.88,-2.59,1.5,3.88,3.88,4.25,6.66,8.16,6.97,5.62,6.41,6.56,4.5,1.41,0.28,-0.06,-2.28,-5.62,-7.62,-7.69,-8.62,-11.72,-13.75,-13.78,-13.12,-14.59,-15.12,-12.31,-8.34,-5.75,-3.78,-0.12,3.41,5.31,4.62,4.72,6.22,6.84,5.06,3.94,4.81,4.88,2.72,0.25,-0.09,0.16,-1.34,-3.91,-4.88,-4.69,-5.81,-8.03,-8.75,-6.84,-5.06,-5.44,-5.0,-2.78,-0.44,-0.78,-1.88,-1.16,-0.53,-1.75,-4.38,-5.06,-4.44,-4.56,-6.56,-7.59,-6.91,-7.06,-9.69,-11.72,-12.12,-11.84,-12.72,-13.38,-11.5,-8.16,-6.12,-5.12,-2.78,0.44,2.16,0.94,-0.62,-0.72,-1.47,-4.34,-6.19,-5.59,-4.09,-3.91,-4.28,-2.5,0.44,1.38,0.53,0.53,1.03,0.34,-2.25,-4.22,-4.0,-3.5,-5.12,-6.91,-6.66,-6.25,-7.16,-8.19,-7.03,-3.72,-1.41,-1.0,0.19,2.28,3.16,1.75,0.72,1.56,3.03,3.0,2.72,4.5,6.97,6.59,4.12,2.5,1.88,0.06,-3.16,-4.88,-4.06,-3.47,-4.25,-4.38,-2.31,0.06,0.38,-0.03,1.62,4.56,6.19,7.19,9.41,12.44,13.31,11.28,8.97,7.47,5.88,1.78,-0.94,-1.03,0.03,-1.28,-3.44,-4.03,-3.75,-4.62,-6.34,-6.19,-4.72,-3.72,-5.09,-5.06,-2.78,-0.47,-0.38,-0.28,1.62,3.62,3.38,2.31,2.59,3.41,2.56,0.47,-0.09,0.97,1.5,0.19,-0.72,0.03,0.88,-0.62,-2.16,-1.81,-0.72,-1.31,-2.06,-0.69,1.88,3.16,2.84,2.72,4.19,4.41,2.94,1.81,2.72,4.09,3.22,1.88,1.81,2.03,-0.06,-3.47,-5.47,-6.12,-7.91,-11.22,-13.31,-13.19,-12.97,-14.47,-15.34,-14.0,-12.34,-12.91,-13.88,-13.19,-11.56,-11.19,-11.72,-10.22,-7.56,-6.25,-7.53,-8.62,-8.16,-7.59,-8.72,-9.53,-8.16,-6.25,-7.06,-8.66,-9.0,-8.62,-10.28,-13.56,-15.69,-15.81,-16.78,-19.38,-21.12,-20.75,-20.28,-21.84,-23.16,-21.97,-19.75,-19.25,-19.41,-18.41,-16.53,-16.75,-18.59,-19.59,-18.91,-18.12,-18.91,-18.97,-16.88,-14.47,-14.47,-14.91,-14.09,-12.97,-13.88,-16.47,-17.78,-17.94,-18.78,-20.94,-21.12,-18.94,-17.19,-17.12,-16.75,-14.5,-11.38,-10.91,-11.09,-10.22,-9.19,-10.72,-14.25,-16.47,-17.72,-19.62,-22.91,-24.28,-22.69,-20.25,-18.72,-16.34,-11.16,-5.88,-2.69,-0.75,1.94,5.09,5.97,4.72,3.78,3.41,1.28,-2.81,-6.19,-6.78,-7.25,-9.19,-11.09,-11.31,-11.12,-12.69,-14.62,-14.53,-12.34,-11.06,-10.84,-9.94,-7.19,-5.5,-6.06,-5.62,-2.88,-0.12,0.34,0.59,1.69,2.97,1.91,-0.31,-1.22,-0.91,-1.25,-3.19,-4.03,-3.28,-3.03,-4.69,-5.84,-4.75,-2.88,-2.5,-2.88,-2.06,-0.94,-2.25,-4.88,-5.81,-4.75,-4.31,-5.03,-4.81,-2.25,-0.5,-0.59,-0.59,1.03,2.72,2.06,0.38,-0.53,-1.16,-3.25,-6.59,-8.12,-7.19,-6.34,-6.22,-4.84,-1.06,2.25,3.12,3.19,4.47,5.91,5.59,4.81,5.59,7.19,7.41,5.75,5.06,6.09,6.78,5.75,5.12,6.62,7.53,6.09,3.88,3.38,3.44,2.47,1.38,2.75,5.75,7.69,8.09,8.94,11.09,11.56,9.31,6.5,5.47,3.97,1.28,-1.81,-3.0,-3.25,-5.66,-8.75,-10.44,-10.47,-11.16,-12.5,-12.44,-9.78,-6.62,-5.06,-2.75,1.25,4.34,4.53,2.72,1.53,0.34,-2.09,-5.69,-7.84,-7.69,-7.94,-9.78,-11.03,-10.16,-9.56,-10.94,-12.31,-11.62,-10.5,-10.47,-11.38,-10.88,-8.94,-8.09,-8.62,-7.88,-5.69,-4.06,-4.75,-5.25,-4.19,-2.97,-3.34,-3.97,-2.97,-1.75,-2.91,-5.81,-7.81,-8.81,-10.78,-13.56,-14.69,-14.06,-13.22,-14.28,-15.56,-14.81,-14.09,-15.22,-16.84,-16.0,-14.34,-13.69,-13.91,-12.84,-10.53,-9.72,-10.38,-10.19,-7.59,-4.81,-4.25,-4.12,-2.53,-1.78,-3.72,-7.28,-8.97,-10.22,-12.44,-15.72,-17.81,-18.03,-18.94,-21.12,-22.75,-21.94,-21.0,-21.97,-22.22,-19.75,-15.84,-13.06,-10.69,-7.22,-3.41,-1.75,-3.09,-4.53,-5.53,-7.59,-11.5,-14.91,-15.25,-15.16,-16.53,-17.75,-16.75,-15.59,-15.31,-16.53,-16.22,-14.62,-14.12,-15.53,-16.06,-14.94,-14.72,-16.5,-18.03,-17.62,-16.81,-18.28,-20.0,-19.47,-17.62,-16.88,-16.62,-14.09,-10.03,-7.09,-5.84,-4.5,-2.09,-1.69,-4.22,-7.94,-10.09,-12.09,-15.81,-19.53,-20.59,-20.06,-20.34,-21.69,-21.44,-20.09,-19.25,-20.34,-20.28,-18.16,-16.31,-16.66,-17.78,-16.78,-15.53,-16.34,-17.78,-17.56,-16.34,-16.34,-17.44,-16.69,-14.09,-12.31,-12.34,-12.12,-10.75,-9.59,-10.25,-11.66,-11.0,-9.41,-10.12,-11.94,-11.78,-10.22,-9.78,-10.78,-10.78,-9.47,-9.06,-11.78,-14.69,-15.84,-16.88,-19.47,-21.03,-19.25,-15.25,-11.81,-9.56,-6.88,-4.0,-3.53,-5.94,-8.09,-9.09,-10.22,-13.25,-15.75,-15.56,-13.78,-13.53,-14.0,-13.06,-11.34,-11.91,-14.09,-14.78,-13.59,-13.16,-14.22,-14.19,-12.41,-11.25,-12.19,-13.34,-12.53,-10.88,-10.72,-11.44,-9.81,-7.06,-5.94,-6.62,-6.66,-5.34,-5.03,-6.84,-8.16,-8.06,-8.31,-11.38,-15.06,-17.0,-18.0,-19.97,-22.22,-21.81,-19.91,-19.09,-20.09,-20.56,-19.28,-18.38,-19.75,-20.69,-19.53,-18.16,-19.38,-20.84,-20.38,-18.88,-19.0,-19.94,-18.97,-16.47,-14.62,-14.5,-14.12,-11.72,-9.88,-10.84,-12.25,-12.06,-11.31,-12.97,-14.84,-14.81,-12.94,-12.5,-13.59,-13.56,-12.69,-13.5,-16.81,-19.56,-20.22,-20.28,-21.97,-23.34,-21.75,-19.41,-18.91,-19.28,-18.0,-15.88,-15.25,-16.75,-16.81,-15.69,-15.25,-17.12,-18.31,-17.03,-15.62,-16.03,-16.47,-14.69,-11.97,-11.03,-11.12,-10.16,-7.78,-7.75,-9.81,-11.09,-10.38,-10.34,-12.19,-13.25,-12.12,-10.78,-11.5,-12.53,-11.81,-10.25,-10.47,-11.97,-12.0,-10.5,-9.75,-11.03,-11.22,-9.97,-9.25,-10.75,-12.28,-11.75,-10.97,-12.22,-14.53,-15.0,-14.88,-16.56,-19.38,-20.81,-20.09,-19.38,-20.22,-19.91,-17.72,-15.97,-16.81,-17.41,-15.62,-13.03,-12.09,-12.25,-10.91,-9.0,-9.16,-11.19,-12.25,-10.78,-9.78,-10.34,-10.19,-8.59,-7.69,-10.0,-13.25,-14.09,-14.03,-15.12,-16.38,-15.75,-13.91,-13.91,-15.47,-16.19,-15.0,-13.66,-14.38,-15.12,-14.03,-12.97,-14.5,-16.66,-16.91,-16.03,-16.81,-18.25,-17.84,-15.75,-15.16,-16.41,-17.0,-15.38,-14.31,-15.81,-16.97,-15.94,-14.44,-14.12,-14.12,-12.22,-9.44,-9.28,-10.66,-11.81,-11.28,-12.09,-14.69,-16.41,-15.19,-13.84,-13.88,-13.94,-12.03,-10.19,-11.22,-13.81,-14.69,-14.25,-14.94,-16.72,-16.66,-14.47,-12.75,-13.0,-12.69,-10.06,-7.69,-7.34,-7.09,-5.22,-2.97,-3.41,-5.62,-6.91,-6.78,-8.06,-10.81,-12.03,-11.31,-10.97,-12.03,-12.5,-10.09,-7.69,-7.56,-8.09,-6.81,-5.0,-5.44,-7.25,-7.91,-8.03,-9.94,-13.56,-16.22,-16.75,-17.56,-20.72,-23.84,-24.53,-25.0,-27.31,-29.72,-29.56,-27.47,-26.62,-26.47,-24.09,-19.5,-16.53,-15.38,-14.38,-12.0,-10.66,-11.97,-13.88,-13.62,-13.47,-15.88,-19.0,-20.56,-20.69,-22.5,-25.22,-26.28,-25.44,-25.22,-26.53,-26.94,-24.38,-21.56,-20.09,-18.44,-14.59,-10.72,-9.41,-9.62,-8.84,-7.34,-7.75,-9.66,-10.75,-9.72,-8.78,-10.19,-11.38,-10.47,8.94,7.41,6.56,7.12,8.62,9.53,10.31,11.69,13.53,14.06,12.72,11.0,10.06,8.84,6.81,5.28,5.31,5.59,5.41,5.47,6.38,8.16,9.5,10.22,11.22,12.78,13.28,11.91:-8.97,-9.62,-9.25,-7.41,-6.78,-8.06,-8.69,-6.56,-4.69,-4.38,-4.0,-1.03,2.47,3.59,2.94,3.38,4.78,4.31,2.38,1.19,1.84,0.75,-2.88,-5.84,-6.59,-6.38,-7.25,-7.53,-5.19,-1.06,1.28,2.62,4.75,7.88,8.53,6.97,5.69,5.97,5.78,3.31,1.41,2.56,4.12,4.47,4.84,7.41,10.47,11.12,9.75,9.19,9.47,8.22,5.25,3.47,3.84,4.12,2.5,1.41,3.0,5.38,6.47,6.91,8.69,10.72,10.16,7.34,4.97,4.5,3.16,0.28,-1.44,-0.22,0.56,-0.69,-2.16,-2.03,-1.66,-4.09,-6.91,-7.5,-6.56,-6.62,-7.62,-7.31,-4.94,-3.22,-3.16,-2.03,1.41,4.59,5.47,5.41,7.28,9.97,11.16,11.25,12.72,15.16,15.38,13.25,12.03,12.16,11.19,8.19,5.62,5.44,4.72,2.47,-0.5,-1.06,-0.72,-2.47,-4.91,-5.59,-4.28,-3.94,-4.97,-4.28,-1.38,0.31,-0.03,-0.75,0.5,1.59,0.41,-1.66,-1.97,-1.19,-2.44,-5.12,-5.56,-4.16,-3.38,-4.16,-4.06,-2.09,-0.81,-1.34,-2.16,-1.22,0.44,-0.41,-2.62,-3.0,-2.12,-2.59,-3.84,-3.47,-1.0,0.22,-1.09,-2.34,-1.94,-2.44,-5.44,-8.09,-8.25,-7.38,-7.97,-9.47,-9.47,-9.03,-10.12,-12.25,-12.28,-9.81,-7.72,-7.59,-7.38,-5.75,-4.0,-3.84,-3.38,-0.22,3.34,4.53,3.81,3.62,3.94,2.44,-0.53,-1.75,-0.72,-0.38,-2.16,-4.38,-4.78,-5.53,-7.75,-9.81,-9.16,-6.75,-5.34,-4.88,-2.59,1.5,3.88,3.88,4.25,6.66,8.16,6.97,5.62,6.41,6.56,4.5,1.41,0.28,-0.06,-2.28,-5.62,-7.62,-7.69,-8.62,-11.72,-13.75,-13.78,-13.12,-14.59,-15.12,-12.31,-8.34,-5.75,-3.78,-0.12,3.41,5.31,4.62,4.72,6.22,6.84,5.06,3.94,4.81,4.88,2.72,0.25,-0.09,0.16,-1.34,-3.91,-4.88,-4.69,-5.81,-8.03,-8.75,-6.84,-5.06,-5.44,-5.0,-2.78,-0.44,-0.78,-1.88,-1.16,-0.53,-1.75,-4.38,-5.06,-4.44,-4.56,-6.56,-7.59,-6.91,-7.06,-9.69,-11.72,-12.12,-11.84,-12.72,-13.38,-11.5,-8.16,-6.12,-5.12,-2.78,0.44,2.16,0.94,-0.62,-0.72,-1.47,-4.34,-6.19,-5.59,-4.09,-3.91,-4.28,-2.5,0.44,1.38,0.53,0.53,1.03,0.34,-2.25,-4.22,-4.0,-3.5,-5.12,-6.91,-6.66,-6.25,-7.16,-8.19,-7.03,-3.72,-1.41,-1.0,0.19,2.28,3.16,1.75,0.72,1.56,3.03,3.0,2.72,4.5,6.97,6.59,4.12,2.5,1.88,0.06,-3.16,-4.88,-4.06,-3.47,-4.25,-4.38,-2.31,0.06,0.38,-0.03,1.62,4.56,6.19,7.19,9.41,12.44,13.31,11.28,8.97,7.47,5.88,1.78,-0.94,-1.03,0.03,-1.28,-3.44,-4.03,-3.75,-4.62,-6.34,-6.19,-4.72,-3.72,-5.09,-5.06,-2.78,-0.47,-0.38,-0.28,1.62,3.62,3.38,2.31,2.59,3.41,2.56,0.47,-0.09,0.97,1.5,0.19,-0.72,0.03,0.88,-0.62,-2.16,-1.81,-0.72,-1.31,-2.06,-0.69,1.88,3.16,2.84,2.72,4.19,4.41,2.94,1.81,2.72,4.09,3.22,1.88,1.81,2.03,-0.06,-3.47,-5.47,-6.12,-7.91,-11.22,-13.31,-13.19,-12.97,-14.47,-15.34,-14.0,-12.34,-12.91,-13.88,-13.19,-11.56,-11.19,-11.72,-10.22,-7.56,-6.25,-7.53,-8.62,-8.16,-7.59,-8.72,-9.53,-8.16,-6.25,-7.06,-8.66,-9.0,-8.62,-10.28,-13.56,-15.69,-15.81,-16.78,-19.38,-21.12,-20.75,-20.28,-21.84,-23.16,-21.97,-19.75,-19.25,-19.41,-18.41,-16.53,-16.75,-18.59,-19.59,-18.91,-18.12,-18.91,-18.97,-16.88,-14.47,-14.47,-14.91,-14.09,-12.97,-13.88,-16.47,-17.78,-17.94,-18.78,-20.94,-21.12,-18.94,-17.19,-17.12,-16.75,-14.5,-11.38,-10.91,-11.09,-10.22,-9.19,-10.72,-14.25,-16.47,-17.72,-19.62,-22.91,-24.28,-22.69,-20.25,-18.72,-16.34,-11.16,-5.88,-2.69,-0.75,1.94,5.09,5.97,4.72,3.78,3.41,1.28,-2.81,-6.19,-6.78,-7.25,-9.19,-11.09,-11.31,-11.12,-12.69,-14.62,-14.53,-12.34,-11.06,-10.84,-9.94,-7.19,-5.5,-6.06,-5.62,-2.88,-0.12,0.34,0.59,1.69,2.97,1.91,-0.31,-1.22,-0.91,-1.25,-3.19,-4.03,-3.28,-3.03,-4.69,-5.84,-4.75,-2.88,-2.5,-2.88,-2.06,-0.94,-2.25,-4.88,-5.81,-4.75,-4.31,-5.03,-4.81,-2.25,-0.5,-0.59,-0.59,1.03,2.72,2.06,0.38,-0.53,-1.16,-3.25,-6.59,-8.12,-7.19,-6.34,-6.22,-4.84,-1.06,2.25,3.12,3.19,4.47,5.91,5.59,4.81,5.59,7.19,7.41,5.75,5.06,6.09,6.78,5.75,5.12,6.62,7.53,6.09,3.88,3.38,3.44,2.47,1.38,2.75,5.75,7.69,8.09,8.94,11.09,11.56,9.31,6.5,5.47,3.97,1.28,-1.81,-3.0,-3.25,-5.66,-8.75,-10.44,-10.47,-11.16,-12.5,-12.44,-9.78,-6.62,-5.06,-2.75,1.25,4.34,4.53,2.72,1.53,0.34,-2.09,-5.69,-7.84,-7.69,-7.94,-9.78,-11.03,-10.16,-9.56,-10.94,-12.31,-11.62,-10.5,-10.47,-11.38,-10.88,-8.94,-8.09,-8.62,-7.88,-5.69,-4.06,-4.75,-5.25,-4.19,-2.97,-3.34,-3.97,-2.97,-1.75,-2.91,-5.81,-7.81,-8.81,-10.78,-13.56,-14.69,-14.06,-13.22,-14.28,-15.56,-14.81,-14.09,-15.22,-16.84,-16.0,-14.34,-13.69,-13.91,-12.84,-10.53,-9.72,-10.38,-10.19,-7.59,-4.81,-4.25,-4.12,-2.53,-1.78,-3.72,-7.28,-8.97,-10.22,-12.44,-15.72,-17.81,-18.03,-18.94,-21.12,-22.75,-21.94,-21.0,-21.97,-22.22,-19.75,-15.84,-13.06,-10.69,-7.22,-3.41,-1.75,-3.09,-4.53,-5.53,-7.59,-11.5,-14.91,-15.25,-15.16,-16.53,-17.75,-16.75,-15.59,-15.31,-16.53,-16.22,-14.62,-14.12,-15.53,-16.06,-14.94,-14.72,-16.5,-18.03,-17.62,-16.81,-18.28,-20.0,-19.47,-17.62,-16.88,-16.62,-14.09,-10.03,-7.09,-5.84,-4.5,-2.09,-1.69,-4.22,-7.94,-10.09,-12.09,-15.81,-19.53,-20.59,-20.06,-20.34,-21.69,-21.44,-20.09,-19.25,-20.34,-20.28,-18.16,-16.31,-16.66,-17.78,-16.78,-15.53,-16.34,-17.78,-17.56,-16.34,-16.34,-17.44,-16.69,-14.09,-12.31,-12.34,-12.12,-10.75,-9.59,-10.25,-11.66,-11.0,-9.41,-10.12,-11.94,-11.78,-10.22,-9.78,-10.78,-10.78,-9.47,-9.06,-11.78,-14.69,-15.84,-16.88,-19.47,-21.03,-19.25,-15.25,-11.81,-9.56,-6.88,-4.0,-3.53,-5.94,-8.09,-9.09,-10.22,-13.25,-15.75,-15.56,-13.78,-13.53,-14.0,-13.06,-11.34,-11.91,-14.09,-14.78,-13.59,-13.16,-14.22,-14.19,-12.41,-11.25,-12.19,-13.34,-12.53,-10.88,-10.72,-11.44,-9.81,-7.06,-5.94,-6.62,-6.66,-5.34,-5.03,-6.84,-8.16,-8.06,-8.31,-11.38,-15.06,-17.0,-18.0,-19.97,-22.22,-21.81,-19.91,-19.09,-20.09,-20.56,-19.28,-18.38,-19.75,-20.69,-19.53,-18.16,-19.38,-20.84,-20.38,-18.88,-19.0,-19.94,-18.97,-16.47,-14.62,-14.5,-14.12,-11.72,-9.88,-10.84,-12.25,-12.06,-11.31,-12.97,-14.84,-14.81,-12.94,-12.5,-13.59,-13.56,-12.69,-13.5,-16.81,-19.56,-20.22,-20.28,-21.97,-23.34,-21.75,-19.41,-18.91,-19.28,-18.0,-15.88,-15.25,-16.75,-16.81,-15.69,-15.25,-17.12,-18.31,-17.03,-15.62,-16.03,-16.47,-14.69,-11.97,-11.03,-11.12,-10.16,-7.78,-7.75,-9.81,-11.09,-10.38,-10.34,-12.19,-13.25,-12.12,-10.78,-11.5,-12.53,-11.81,-10.25,-10.47,-11.97,-12.0,-10.5,-9.75,-11.03,-11.22,-9.97,-9.25,-10.75,-12.28,-11.75,-10.97,-12.22,-14.53,-15.0,-14.88,-16.56,-19.38,-20.81,-20.09,-19.38,-20.22,-19.91,-17.72,-15.97,-16.81,-17.41,-15.62,-13.03,-12.09,-12.25,-10.91,-9.0,-9.16,-11.19,-12.25,-10.78,-9.78,-10.34,-10.19,-8.59,-7.69,-10.0,-13.25,-14.09,-14.03,-15.12,-16.38,-15.75,-13.91,-13.91,-15.47,-16.19,-15.0,-13.66,-14.38,-15.12,-14.03,-12.97,-14.5,-16.66,-16.91,-16.03,-16.81,-18.25,-17.84,-15.75,-15.16,-16.41,-17.0,-15.38,-14.31,-15.81,-16.97,-15.94,-14.44,-14.12,-14.12,-12.22,-9.44,-9.28,-10.66,-11.81,-11.28,-12.09,-14.69,-16.41,-15.19,-13.84,-13.88,-13.94,-12.03,-10.19,-11.22,-13.81,-14.69,-14.25,-14.94,-16.72,-16.66,-14.47,-12.75,-13.0,-12.69,-10.06,-7.69,-7.34,-7.09,-5.22,-2.97,-3.41,-5.62,-6.91,-6.78,-8.06,-10.81,-12.03,-11.31,-10.97,-12.03,-12.5,-10.09,-7.69,-7.56,-8.09,-6.81,-5.0,-5.44,-7.25,-7.91,-8.03,-9.94,-13.56,-16.22,-16.75,-17.56,-20.72,-23.84,-24.53,-25.0,-27.31,-29.72,-29.56,-27.47,-26.62,-26.47,-24.09,-19.5,-16.53,-15.38,-14.38,-12.0,-10.66,-11.97,-13.88,-13.62,-13.47,-15.88,-19.0,-20.56,-20.69,-22.5,-25.22,-26.28,-25.44,-25.22,-26.53,-26.94,-24.38,-21.56,-20.09,-18.44,-14.59,-10.72,-9.41,-9.62,-8.84,-7.34,-7.75,-9.66,-10.75,-9.72,-8.78,-10.19,-11.38,-10.47,8.94,7.41,6.56,7.12,8.62,9.53,10.31,11.69,13.53,14.06,12.72,11.0,10.06,8.84,6.81,5.28,5.31,5.59,5.41,5.47,6.38,8.16,9.5,10.22,11.22,12.78,13.28,11.91,9.91,8.38,6.53,3.38,0.66,0.09,0.59:-6.56,-4.69,-4.38,-4.0,-1.03,2.47,3.59,2.94,3.38,4.78,4.31,2.38,1.19,1.84,0.75,-2.88,-5.84,-6.59,-6.38,-7.25,-7.53,-5.19,-1.06,1.28,2.62,4.75,7.88,8.53,6.97,5.69,5.97,5.78,3.31,1.41,2.56,4.12,4.47,4.84,7.41,10.47,11.12,9.75,9.19,9.47,8.22,5.25,3.47,3.84,4.12,2.5,1.41,3.0,5.38,6.47,6.91,8.69,10.72,10.16,7.34,4.97,4.5,3.16,0.28,-1.44,-0.22,0.56,-0.69,-2.16,-2.03,-1.66,-4.09,-6.91,-7.5,-6.56,-6.62,-7.62,-7.31,-4.94,-3.22,-3.16,-2.03,1.41,4.59,5.47,5.41,7.28,9.97,11.16,11.25,12.72,15.16,15.38,13.25,12.03,12.16,11.19,8.19,5.62,5.44,4.72,2.47,-0.5,-1.06,-0.72,-2.47,-4.91,-5.59,-4.28,-3.94,-4.97,-4.28,-1.38,0.31,-0.03,-0.75,0.5,1.59,0.41,-1.66,-1.97,-1.19,-2.44,-5.12,-5.56,-4.16,-3.38,-4.16,-4.06,-2.09,-0.81,-1.34,-2.16,-1.22,0.44,-0.41,-2.62,-3.0,-2.12,-2.59,-3.84,-3.47,-1.0,0.22,-1.09,-2.34,-1.94,-2.44,-5.44,-8.09,-8.25,-7.38,-7.97,-9.47,-9.47,-9.03,-10.12,-12.25,-12.28,-9.81,-7.72,-7.59,-7.38,-5.75,-4.0,-3.84,-3.38,-0.22,3.34,4.53,3.81,3.62,3.94,2.44,-0.53,-1.75,-0.72,-0.38,-2.16,-4.38,-4.78,-5.53,-7.75,-9.81,-9.16,-6.75,-5.34,-4.88,-2.59,1.5,3.88,3.88,4.25,6.66,8.16,6.97,5.62,6.41,6.56,4.5,1.41,0.28,-0.06,-2.28,-5.62,-7.62,-7.69,-8.62,-11.72,-13.75,-13.78,-13.12,-14.59,-15.12,-12.31,-8.34,-5.75,-3.78,-0.12,3.41,5.31,4.62,4.72,6.22,6.84,5.06,3.94,4.81,4.88,2.72,0.25,-0.09,0.16,-1.34,-3.91,-4.88,-4.69,-5.81,-8.03,-8.75,-6.84,-5.06,-5.44,-5.0,-2.78,-0.44,-0.78,-1.88,-1.16,-0.53,-1.75,-4.38,-5.06,-4.44,-4.56,-6.56,-7.59,-6.91,-7.06,-9.69,-11.72,-12.12,-11.84,-12.72,-13.38,-11.5,-8.16,-6.12,-5.12,-2.78,0.44,2.16,0.94,-0.62,-0.72,-1.47,-4.34,-6.19,-5.59,-4.09,-3.91,-4.28,-2.5,0.44,1.38,0.53,0.53,1.03,0.34,-2.25,-4.22,-4.0,-3.5,-5.12,-6.91,-6.66,-6.25,-7.16,-8.19,-7.03,-3.72,-1.41,-1.0,0.19,2.28,3.16,1.75,0.72,1.56,3.03,3.0,2.72,4.5,6.97,6.59,4.12,2.5,1.88,0.06,-3.16,-4.88,-4.06,-3.47,-4.25,-4.38,-2.31,0.06,0.38,-0.03,1.62,4.56,6.19,7.19,9.41,12.44,13.31,11.28,8.97,7.47,5.88,1.78,-0.94,-1.03,0.03,-1.28,-3.44,-4.03,-3.75,-4.62,-6.34,-6.19,-4.72,-3.72,-5.09,-5.06,-2.78,-0.47,-0.38,-0.28,1.62,3.62,3.38,2.31,2.59,3.41,2.56,0.47,-0.09,0.97,1.5,0.19,-0.72,0.03,0.88,-0.62,-2.16,-1.81,-0.72,-1.31,-2.06,-0.69,1.88,3.16,2.84,2.72,4.19,4.41,2.94,1.81,2.72,4.09,3.22,1.88,1.81,2.03,-0.06,-3.47,-5.47,-6.12,-7.91,-11.22,-13.31,-13.19,-12.97,-14.47,-15.34,-14.0,-12.34,-12.91,-13.88,-13.19,-11.56,-11.19,-11.72,-10.22,-7.56,-6.25,-7.53,-8.62,-8.16,-7.59,-8.72,-9.53,-8.16,-6.25,-7.06,-8.66,-9.0,-8.62,-10.28,-13.56,-15.69,-15.81,-16.78,-19.38,-21.12,-20.75,-20.28,-21.84,-23.16,-21.97,-19.75,-19.25,-19.41,-18.41,-16.53,-16.75,-18.59,-19.59,-18.91,-18.12,-18.91,-18.97,-16.88,-14.47,-14.47,-14.91,-14.09,-12.97,-13.88,-16.47,-17.78,-17.94,-18.78,-20.94,-21.12,-18.94,-17.19,-17.12,-16.75,-14.5,-11.38,-10.91,-11.09,-10.22,-9.19,-10.72,-14.25,-16.47,-17.72,-19.62,-22.91,-24.28,-22.69,-20.25,-18.72,-16.34,-11.16,-5.88,-2.69,-0.75,1.94,5.09,5.97,4.72,3.78,3.41,1.28,-2.81,-6.19,-6.78,-7.25,-9.19,-11.09,-11.31,-11.12,-12.69,-14.62,-14.53,-12.34,-11.06,-10.84,-9.94,-7.19,-5.5,-6.06,-5.62,-2.88,-0.12,0.34,0.59,1.69,2.97,1.91,-0.31,-1.22,-0.91,-1.25,-3.19,-4.03,-3.28,-3.03,-4.69,-5.84,-4.75,-2.88,-2.5,-2.88,-2.06,-0.94,-2.25,-4.88,-5.81,-4.75,-4.31,-5.03,-4.81,-2.25,-0.5,-0.59,-0.59,1.03,2.72,2.06,0.38,-0.53,-1.16,-3.25,-6.59,-8.12,-7.19,-6.34,-6.22,-4.84,-1.06,2.25,3.12,3.19,4.47,5.91,5.59,4.81,5.59,7.19,7.41,5.75,5.06,6.09,6.78,5.75,5.12,6.62,7.53,6.09,3.88,3.38,3.44,2.47,1.38,2.75,5.75,7.69,8.09,8.94,11.09,11.56,9.31,6.5,5.47,3.97,1.28,-1.81,-3.0,-3.25,-5.66,-8.75,-10.44,-10.47,-11.16,-12.5,-12.44,-9.78,-6.62,-5.06,-2.75,1.25,4.34,4.53,2.72,1.53,0.34,-2.09,-5.69,-7.84,-7.69,-7.94,-9.78,-11.03,-10.16,-9.56,-10.94,-12.31,-11.62,-10.5,-10.47,-11.38,-10.88,-8.94,-8.09,-8.62,-7.88,-5.69,-4.06,-4.75,-5.25,-4.19,-2.97,-3.34,-3.97,-2.97,-1.75,-2.91,-5.81,-7.81,-8.81,-10.78,-13.56,-14.69,-14.06,-13.22,-14.28,-15.56,-14.81,-14.09,-15.22,-16.84,-16.0,-14.34,-13.69,-13.91,-12.84,-10.53,-9.72,-10.38,-10.19,-7.59,-4.81,-4.25,-4.12,-2.53,-1.78,-3.72,-7.28,-8.97,-10.22,-12.44,-15.72,-17.81,-18.03,-18.94,-21.12,-22.75,-21.94,-21.0,-21.97,-22.22,-19.75,-15.84,-13.06,-10.69,-7.22,-3.41,-1.75,-3.09,-4.53,-5.53,-7.59,-11.5,-14.91,-15.25,-15.16,-16.53,-17.75,-16.75,-15.59,-15.31,-16.53,-16.22,-14.62,-14.12,-15.53,-16.06,-14.94,-14.72,-16.5,-18.03,-17.62,-16.81,-18.28,-20.0,-19.47,-17.62,-16.88,-16.62,-14.09,-10.03,-7.09,-5.84,-4.5,-2.09,-1.69,-4.22,-7.94,-10.09,-12.09,-15.81,-19.53,-20.59,-20.06,-20.34,-21.69,-21.44,-20.09,-19.25,-20.34,-20.28,-18.16,-16.31,-16.66,-17.78,-16.78,-15.53,-16.34,-17.78,-17.56,-16.34,-16.34,-17.44,-16.69,-14.09,-12.31,-12.34,-12.12,-10.75,-9.59,-10.25,-11.66,-11.0,-9.41,-10.12,-11.94,-11.78,-10.22,-9.78,-10.78,-10.78,-9.47,-9.06,-11.78,-14.69,-15.84,-16.88,-19.47,-21.03,-19.25,-15.25,-11.81,-9.56,-6.88,-4.0,-3.53,-5.94,-8.09,-9.09,-10.22,-13.25,-15.75,-15.56,-13.78,-13.53,-14.0,-13.06,-11.34,-11.91,-14.09,-14.78,-13.59,-13.16,-14.22,-14.19,-12.41,-11.25,-12.19,-13.34,-12.53,-10.88,-10.72,-11.44,-9.81,-7.06,-5.94,-6.62,-6.66,-5.34,-5.03,-6.84,-8.16,-8.06,-8.31,-11.38,-15.06,-17.0,-18.0,-19.97,-22.22,-21.81,-19.91,-19.09,-20.09,-20.56,-19.28,-18.38,-19.75,-20.69,-19.53,-18.16,-19.38,-20.84,-20.38,-18.88,-19.0,-19.94,-18.97,-16.47,-14.62,-14.5,-14.12,-11.72,-9.88,-10.84,-12.25,-12.06,-11.31,-12.97,-14.84,-14.81,-12.94,-12.5,-13.59,-13.56,-12.69,-13.5,-16.81,-19.56,-20.22,-20.28,-21.97,-23.34,-21.75,-19.41,-18.91,-19.28,-18.0,-15.88,-15.25,-16.75,-16.81,-15.69,-15.25,-17.12,-18.31,-17.03,-15.62,-16.03,-16.47,-14.69,-11.97,-11.03,-11.12,-10.16,-7.78,-7.75,-9.81,-11.09,-10.38,-10.34,-12.19,-13.25,-12.12,-10.78,-11.5,-12.53,-11.81,-10.25,-10.47,-11.97,-12.0,-10.5,-9.75,-11.03,-11.22,-9.97,-9.25,-10.75,-12.28,-11.75,-10.97,-12.22,-14.53,-15.0,-14.88,-16.56,-19.38,-20.81,-20.09,-19.38,-20.22,-19.91,-17.72,-15.97,-16.81,-17.41,-15.62,-13.03,-12.09,-12.25,-10.91,-9.0,-9.16,-11.19,-12.25,-10.78,-9.78,-10.34,-10.19,-8.59,-7.69,-10.0,-13.25,-14.09,-14.03,-15.12,-16.38,-15.75,-13.91,-13.91,-15.47,-16.19,-15.0,-13.66,-14.38,-15.12,-14.03,-12.97,-14.5,-16.66,-16.91,-16.03,-16.81,-18.25,-17.84,-15.75,-15.16,-16.41,-17.0,-15.38,-14.31,-15.81,-16.97,-15.94,-14.44,-14.12,-14.12,-12.22,-9.44,-9.28,-10.66,-11.81,-11.28,-12.09,-14.69,-16.41,-15.19,-13.84,-13.88,-13.94,-12.03,-10.19,-11.22,-13.81,-14.69,-14.25,-14.94,-16.72,-16.66,-14.47,-12.75,-13.0,-12.69,-10.06,-7.69,-7.34,-7.09,-5.22,-2.97,-3.41,-5.62,-6.91,-6.78,-8.06,-10.81,-12.03,-11.31,-10.97,-12.03,-12.5,-10.09,-7.69,-7.56,-8.09,-6.81,-5.0,-5.44,-7.25,-7.91,-8.03,-9.94,-13.56,-16.22,-16.75,-17.56,-20.72,-23.84,-24.53,-25.0,-27.31,-29.72,-29.56,-27.47,-26.62,-26.47,-24.09,-19.5,-16.53,-15.38,-14.38,-12.0,-10.66,-11.97,-13.88,-13.62,-13.47,-15.88,-19.0,-20.56,-20.69,-22.5,-25.22,-26.28,-25.44,-25.22,-26.53,-26.94,-24.38,-21.56,-20.09,-18.44,-14.59,-10.72,-9.41,-9.62,-8.84,-7.34,-7.75,-9.66,-10.75,-9.72,-8.78,-10.19,-11.38,-10.47,8.94,7.41,6.56,7.12,8.62,9.53,10.31,11.69,13.53,14.06,12.72,11.0,10.06,8.84,6.81,5.28,5.31,5.59,5.41,5.47,6.38,8.16,9.5,10.22,11.22,12.78,13.28,11.91,9.91,8.38,6.53,3.38,0.66,0.09,0.59,1.06,1.69,3.38,5.62,6.78,7.47,8.47:negativity
32.0,30.06,29.44,30.06,30.22,28.53,27.66,28.5,29.75,28.94,27.84,28.78,29.94,29.28,27.78,28.38,30.38,31.31,30.75,30.81,32.38,32.84,30.62,28.47,28.0,27.59,25.0,22.28,21.75,22.22,21.12,19.09,19.47,21.5,22.72,22.56,23.25,25.03,25.75,24.34,23.22,24.75,26.78,27.12,27.38,29.25,31.16,30.66,28.22,26.84,26.22,24.44,20.66,18.44,18.59,19.38,19.06,19.25,21.84,24.44,24.41,23.16,23.06,24.25,24.16,23.38,24.66,27.19,29.22,28.88,29.16,31.22,32.66,31.34,29.91,30.03,30.16,27.84,24.78,23.19,22.81,21.03,18.0,17.25,18.62,19.78,19.62,20.09,22.59,24.47,23.53,22.5,23.28,24.84,24.84,24.75,26.25,28.62,29.38,27.78,26.78,26.5,25.28,22.59,20.78,21.41,22.06,20.53,18.66,18.72,19.44,18.44,16.88,16.91,18.25,18.47,17.0,17.53,19.62,20.97,20.09,19.25,19.78,20.19,18.34,16.31,16.88,18.59,18.59,17.59,18.19,19.09,18.53,16.09,14.44,14.47,14.47,13.09,12.53,14.12,16.09,15.62,14.78,15.75,17.75,17.59,16.69,17.0,18.28,18.56,17.31,17.16,18.88,20.84,20.16,19.19,20.25,21.44,20.91,20.59,22.62,25.91,27.78,27.84,28.84,30.19,29.69,27.12,24.44,23.19,22.06,18.94,16.66,16.69,17.38,16.34,14.66,14.94,16.38,15.62,14.09,13.72,14.97,15.41,14.34,14.66,16.47,18.78,18.31,17.41,18.41,19.34,18.22,16.25,16.41,18.09,18.84,18.66,19.88,22.88,24.72,24.03,23.84,25.25,26.62,25.38,24.16,24.53,24.84,23.16,20.66,20.0,20.75,20.19,18.31,17.44,17.97,17.97,15.91,14.97,16.88,19.53,20.16,21.06,23.62,26.44,26.66,25.88,26.38,28.06,28.25,26.94,26.5,27.97,29.12,28.0,27.41,28.0,27.72,23.78,19.06,16.0,14.34,11.66,8.22,7.38,8.5,8.44,7.47,7.88,10.62,12.84,13.03,13.62,15.59,17.97,17.56,16.19,16.25,17.12,16.41,15.16,16.38,19.19,20.94,20.78,20.31,20.84,20.06,16.94,13.91,13.41,13.78,12.75,12.12,13.16,15.41,15.66,14.47,14.66,16.47,18.22,18.47,20.56,25.41,29.84,31.84,33.09,35.19,36.5,34.88,31.59,29.72,28.78,26.88,24.16,23.5,24.5,24.88,23.78,23.16,24.69,26.59,26.12,25.84,27.16,28.94,28.66,28.16,29.69,32.94,34.5,34.38,35.0,37.06,38.03,36.97,36.47,37.94,38.56,36.19,32.66,30.69,29.53,26.41,23.44,22.56,23.66,23.47,21.22,20.06,20.19,19.59,17.22,15.5,16.34,17.72,17.03,16.0,17.19,19.0,18.16,16.69,16.84,18.03,17.69,15.59,14.09,14.72,14.66,12.97,12.66,15.44,18.56,19.88,20.28,21.81,23.41,22.5,20.03,19.12,20.53,20.84,20.0,20.16,21.72,22.59,20.75,18.72,18.91,19.38,17.78,16.22,16.19,17.47,16.38,13.75,12.66,13.16,13.0,11.84,12.56,15.75,18.5,19.22,19.47,21.53,23.34,23.09,21.88,23.0,24.94,24.5,22.44,20.66,19.91,17.5,13.5,10.22,10.03,10.22,9.06,8.91,11.81,15.53,17.25,18.59,21.31,24.47,25.09,24.44,24.62,26.22,26.84,26.03,25.31,26.03,26.12,23.5,20.25,19.03,18.59,16.69,14.25,14.34,15.75,16.03,14.59,14.06,15.28,15.38,13.75,12.53,13.62,14.53,12.78,10.41,9.72,9.69,7.72,5.59,5.78,8.19,9.75,10.25,11.75,14.97,16.62,15.91,15.53,17.78,20.47,21.19,22.06,24.53,27.38,27.03,24.91,23.59,22.22,19.41,14.97,11.22,9.78,7.72,4.47,2.19,2.66,3.78,3.47,3.34,5.75,9.44,11.25,12.25,14.75,18.0,19.38,18.78,18.19,18.88,18.62,15.53,12.38,11.88,11.66,8.94,5.91,4.62,4.53,2.69,0.16,-0.06,1.41,2.09,1.47,1.38,3.47,5.41,5.38,5.72,8.25,11.5,12.5,12.69,14.19,15.78,15.09,13.12,13.0,15.31,17.0,17.56,18.22,20.81,22.5,21.56,20.25,21.06,22.12,21.03,19.12,18.84,19.94,19.12,16.94,15.88,16.75,17.09,16.06,15.31,17.25,18.75,17.94,16.94,18.56,20.81,21.19,20.84,22.44,25.16,26.19,25.75,26.28,28.06,28.88,27.16,25.69,26.38,26.62,24.78,22.31,22.28,22.78,21.25,19.03,19.12,20.88,21.47,20.56,20.84,22.5,22.84,21.5,20.38,21.41,22.28,21.19,19.75,20.91,23.22,24.25,24.28,25.75,28.06,27.84,25.25,23.12,23.09,22.06,19.5,17.28,17.47,17.84,16.38,14.41,15.25,16.91,17.0,16.28,17.34,19.62,20.78,20.0,20.0,21.72,23.38,22.91,22.31,23.88,24.91,23.69,21.09,19.91,19.22,17.03,13.47,11.59,12.19,11.78,10.69,11.0,14.06,17.0,18.47,19.78,23.59,27.72,29.59,29.75,30.81,32.16,30.69,27.84,26.62,27.28,27.34,25.75,25.03,25.97,26.12,24.16,22.28,22.72,23.69,23.16,22.31,23.28,25.22,25.88,25.25,25.81,28.0,29.5,28.78,28.84,30.5,32.12,31.88,31.06,32.66,34.47,34.5,33.5,34.25,35.75,35.72,33.84,33.12,34.28,34.5,33.25,32.06,32.44,32.16,30.06,27.72,27.81,28.84,28.28,26.81,27.5,28.94,29.06,27.34,26.41,27.19,27.5,25.69,24.59,25.81,27.28,26.81,26.41,28.28,30.47,30.38,28.5,27.94,28.03,27.28,25.25,24.5,26.03,27.22,26.91,26.78,28.84,31.0,30.66,29.53,29.47,29.72,28.44,26.22,25.66,27.06,27.22,25.53,24.34,24.88,24.81,22.69,20.81,21.41,22.38,21.28,19.81,20.31,21.38,20.97,19.0,18.53,19.56,20.0,18.5,18.25,19.94,21.03,19.81,18.72,19.59,21.19,21.09,20.91,22.28,24.19,24.31,22.66,21.69,22.0,21.75,19.97,19.91,22.38,24.88,25.28,25.19,26.59,28.0,27.0,25.25,25.12,26.31,25.94,23.84,22.84,23.16,22.69,20.0,17.84,18.12,18.53,16.91,15.31,16.0,17.22,16.72,15.72,17.16,20.0,21.44,21.12,21.84,24.16,25.44,24.5,23.84,25.03,25.34,23.69,21.12,20.84,21.19,19.38,16.44,15.31,16.0,16.38,16.25,17.75,21.84,25.56,26.81,28.56,31.88,35.09,35.03,33.81,33.16,32.25,28.75,24.16,21.97,21.41,20.62,18.91,18.81,20.56,22.78,23.12,24.06,26.66,28.94,28.47,26.56,26.5,27.06,26.91,25.38,25.06,25.84,25.19,22.41,20.72,21.22,22.0,21.19,20.62,22.0,23.22,21.72,19.22,18.16,18.38,17.47,15.84,16.31,19.25,21.62,22.5,23.5,25.91,27.5,26.06,24.19,24.31,24.69,22.34,19.28,18.19,18.41,17.78,16.44,16.72,19.16,20.88,20.59,20.59,21.59,22.06,20.03,17.84,17.97,18.91,18.59,17.66,19.47,22.66,24.59,25.12,25.91,27.88,28.5,26.53,24.59,24.44,24.06,21.22,18.06,17.12,17.31,16.31,15.16,16.34,19.12,20.94,21.25,22.31,24.28,25.69,24.84,24.28,24.84,25.53,23.72,21.34,21.28,21.5,19.75,17.12,16.34,16.94,17.12,16.16,16.38,18.5,19.94,19.19,18.22,18.75,19.12,17.06,14.5,14.0,14.84,15.03,15.03,16.91,20.41,22.44,22.34,21.94,22.84,23.09,21.06,19.22,19.34,19.88,17.97,15.5,15.25,16.25,16.06,15.19,15.88,18.25,19.34,18.19,17.38,17.84,17.47,14.62,12.12,12.06,13.12,12.19,11.12,11.5,12.41,12.09,10.69,10.75,12.84,14.44,13.78,13.97,15.41,16.16,14.09,12.06,11.38,11.22,9.0,6.34,5.97,6.91,6.94,5.84,6.56,9.31,11.53,11.94,13.28,16.66,19.72,20.25,19.91,21.12,22.56,21.41,18.97,17.84,17.47,15.5,11.62,9.34,8.44,6.97,3.59,1.5,1.94,2.88,2.41,2.25,4.53,7.94,9.59,10.25,12.78,16.5,18.91,19.62,20.97,23.59,25.06,23.5,21.5,20.59,19.28,16.06,12.88,11.44,11.31,9.22,5.56,2.41,0.31,-2.53,-6.09,-7.22,-5.47,-2.66,-1.12,1.53,6.66,12.41,16.12,19.16,23.47,27.31,28.25,27.06,25.53,24.75,22.69,18.97,16.5,16.38,16.5,14.25,11.28,10.16,9.19,5.81,2.5,1.56,2.66,2.88,3.38,5.78,10.5,14.28,16.0,18.03,20.88,22.97,22.44,21.34,21.72,23.03,22.5,21.22,21.41,22.25,20.94,17.62,14.5,13.16,10.94,7.81,5.75,6.34,7.69,7.19,7.09,9.22,11.69,12.19,11.72,12.38,13.25,12.66,10.41,8.91,9.38,9.31,7.81,7.16,8.72,10.19,9.94,8.84,9.66,11.0,10.41,8.69,8.09,9.16,8.75,7.12,6.38,8.09,9.12,7.81,6.81,7.41,7.97,6.28,4.34,4.75,6.34,6.59,6.38,7.25,9.47,9.56,7.53,6.59,7.38,8.34,7.72,7.78,10.38,13.88,15.31,15.97,18.5,21.16,21.56,20.41,20.41,21.62,21.69,20.19,18.81,19.12,18.66,16.16,13.47,12.41,12.31,10.19,8.16,8.34,10.38,11.28,11.25,12.75,15.81,17.5,16.94:28.5,29.75,28.94,27.84,28.78,29.94,29.28,27.78,28.38,30.38,31.31,30.75,30.81,32.38,32.84,30.62,28.47,28.0,27.59,25.0,22.28,21.75,22.22,21.12,19.09,19.47,21.5,22.72,22.56,23.25,25.03,25.75,24.34,23.22,24.75,26.78,27.12,27.38,29.25,31.16,30.66,28.22,26.84,26.22,24.44,20.66,18.44,18.59,19.38,19.06,19.25,21.84,24.44,24.41,23.16,23.06,24.25,24.16,23.38,24.66,27.19,29.22,28.88,29.16,31.22,32.66,31.34,29.91,30.03,30.16,27.84,24.78,23.19,22.81,21.03,18.0,17.25,18.62,19.78,19.62,20.09,22.59,24.47,23.53,22.5,23.28,24.84,24.84,24.75,26.25,28.62,29.38,27.78,26.78,26.5,25.28,22.59,20.78,21.41,22.06,20.53,18.66,18.72,19.44,18.44,16.88,16.91,18.25,18.47,17.0,17.53,19.62,20.97,20.09,19.25,19.78,20.19,18.34,16.31,16.88,18.59,18.59,17.59,18.19,19.09,18.53,16.09,14.44,14.47,14.47,13.09,12.53,14.12,16.09,15.62,14.78,15.75,17.75,17.59,16.69,17.0,18.28,18.56,17.31,17.16,18.88,20.84,20.16,19.19,20.25,21.44,20.91,20.59,22.62,25.91,27.78,27.84,28.84,30.19,29.69,27.12,24.44,23.19,22.06,18.94,16.66,16.69,17.38,16.34,14.66,14.94,16.38,15.62,14.09,13.72,14.97,15.41,14.34,14.66,16.47,18.78,18.31,17.41,18.41,19.34,18.22,16.25,16.41,18.09,18.84,18.66,19.88,22.88,24.72,24.03,23.84,25.25,26.62,25.38,24.16,24.53,24.84,23.16,20.66,20.0,20.75,20.19,18.31,17.44,17.97,17.97,15.91,14.97,16.88,19.53,20.16,21.06,23.62,26.44,26.66,25.88,26.38,28.06,28.25,26.94,26.5,27.97,29.12,28.0,27.41,28.0,27.72,23.78,19.06,16.0,14.34,11.66,8.22,7.38,8.5,8.44,7.47,7.88,10.62,12.84,13.03,13.62,15.59,17.97,17.56,16.19,16.25,17.12,16.41,15.16,16.38,19.19,20.94,20.78,20.31,20.84,20.06,16.94,13.91,13.41,13.78,12.75,12.12,13.16,15.41,15.66,14.47,14.66,16.47,18.22,18.47,20.56,25.41,29.84,31.84,33.09,35.19,36.5,34.88,31.59,29.72,28.78,26.88,24.16,23.5,24.5,24.88,23.78,23.16,24.69,26.59,26.12,25.84,27.16,28.94,28.66,28.16,29.69,32.94,34.5,34.38,35.0,37.06,38.03,36.97,36.47,37.94,38.56,36.19,32.66,30.69,29.53,26.41,23.44,22.56,23.66,23.47,21.22,20.06,20.19,19.59,17.22,15.5,16.34,17.72,17.03,16.0,17.19,19.0,18.16,16.69,16.84,18.03,17.69,15.59,14.09,14.72,14.66,12.97,12.66,15.44,18.56,19.88,20.28,21.81,23.41,22.5,20.03,19.12,20.53,20.84,20.0,20.16,21.72,22.59,20.75,18.72,18.91,19.38,17.78,16.22,16.19,17.47,16.38,13.75,12.66,13.16,13.0,11.84,12.56,15.75,18.5,19.22,19.47,21.53,23.34,23.09,21.88,23.0,24.94,24.5,22.44,20.66,19.91,17.5,13.5,10.22,10.03,10.22,9.06,8.91,11.81,15.53,17.25,18.59,21.31,24.47,25.09,24.44,24.62,26.22,26.84,26.03,25.31,26.03,26.12,23.5,20.25,19.03,18.59,16.69,14.25,14.34,15.75,16.03,14.59,14.06,15.28,15.38,13.75,12.53,13.62,14.53,12.78,10.41,9.72,9.69,7.72,5.59,5.78,8.19,9.75,10.25,11.75,14.97,16.62,15.91,15.53,17.78,20.47,21.19,22.06,24.53,27.38,27.03,24.91,23.59,22.22,19.41,14.97,11.22,9.78,7.72,4.47,2.19,2.66,3.78,3.47,3.34,5.75,9.44,11.25,12.25,14.75,18.0,19.38,18.78,18.19,18.88,18.62,15.53,12.38,11.88,11.66,8.94,5.91,4.62,4.53,2.69,0.16,-0.06,1.41,2.09,1.47,1.38,3.47,5.41,5.38,5.72,8.25,11.5,12.5,12.69,14.19,15.78,15.09,13.12,13.0,15.31,17.0,17.56,18.22,20.81,22.5,21.56,20.25,21.06,22.12,21.03,19.12,18.84,19.94,19.12,16.94,15.88,16.75,17.09,16.06,15.31,17.25,18.75,17.94,16.94,18.56,20.81,21.19,20.84,22.44,25.16,26.19,25.75,26.28,28.06,28.88,27.16,25.69,26.38,26.62,24.78,22.31,22.28,22.78,21.25,19.03,19.12,20.88,21.47,20.56,20.84,22.5,22.84,21.5,20.38,21.41,22.28,21.19,19.75,20.91,23.22,24.25,24.28,25.75,28.06,27.84,25.25,23.12,23.09,22.06,19.5,17.28,17.47,17.84,16.38,14.41,15.25,16.91,17.0,16.28,17.34,19.62,20.78,20.0,20.0,21.72,23.38,22.91,22.31,23.88,24.91,23.69,21.09,19.91,19.22,17.03,13.47,11.59,12.19,11.78,10.69,11.0,14.06,17.0,18.47,19.78,23.59,27.72,29.59,29.75,30.81,32.16,30.69,27.84,26.62,27.28,27.34,25.75,25.03,25.97,26.12,24.16,22.28,22.72,23.69,23.16,22.31,23.28,25.22,25.88,25.25,25.81,28.0,29.5,28.78,28.84,30.5,32.12,31.88,31.06,32.66,34.47,34.5,33.5,34.25,35.75,35.72,33.84,33.12,34.28,34.5,33.25,32.06,32.44,32.16,30.06,27.72,27.81,28.84,28.28,26.81,27.5,28.94,29.06,27.34,26.41,27.19,27.5,25.69,24.59,25.81,27.28,26.81,26.41,28.28,30.47,30.38,28.5,27.94,28.03,27.28,25.25,24.5,26.03,27.22,26.91,26.78,28.84,31.0,30.66,29.53,29.47,29.72,28.44,26.22,25.66,27.06,27.22,25.53,24.34,24.88,24.81,22.69,20.81,21.41,22.38,21.28,19.81,20.31,21.38,20.97,19.0,18.53,19.56,20.0,18.5,18.25,19.94,21.03,19.81,18.72,19.59,21.19,21.09,20.91,22.28,24.19,24.31,22.66,21.69,22.0,21.75,19.97,19.91,22.38,24.88,25.28,25.19,26.59,28.0,27.0,25.25,25.12,26.31,25.94,23.84,22.84,23.16,22.69,20.0,17.84,18.12,18.53,16.91,15.31,16.0,17.22,16.72,15.72,17.16,20.0,21.44,21.12,21.84,24.16,25.44,24.5,23.84,25.03,25.34,23.69,21.12,20.84,21.19,19.38,16.44,15.31,16.0,16.38,16.25,17.75,21.84,25.56,26.81,28.56,31.88,35.09,35.03,33.81,33.16,32.25,28.75,24.16,21.97,21.41,20.62,18.91,18.81,20.56,22.78,23.12,24.06,26.66,28.94,28.47,26.56,26.5,27.06,26.91,25.38,25.06,25.84,25.19,22.41,20.72,21.22,22.0,21.19,20.62,22.0,23.22,21.72,19.22,18.16,18.38,17.47,15.84,16.31,19.25,21.62,22.5,23.5,25.91,27.5,26.06,24.19,24.31,24.69,22.34,19.28,18.19,18.41,17.78,16.44,16.72,19.16,20.88,20.59,20.59,21.59,22.06,20.03,17.84,17.97,18.91,18.59,17.66,19.47,22.66,24.59,25.12,25.91,27.88,28.5,26.53,24.59,24.44,24.06,21.22,18.06,17.12,17.31,16.31,15.16,16.34,19.12,20.94,21.25,22.31,24.28,25.69,24.84,24.28,24.84,25.53,23.72,21.34,21.28,21.5,19.75,17.12,16.34,16.94,17.12,16.16,16.38,18.5,19.94,19.19,18.22,18.75,19.12,17.06,14.5,14.0,14.84,15.03,15.03,16.91,20.41,22.44,22.34,21.94,22.84,23.09,21.06,19.22,19.34,19.88,17.97,15.5,15.25,16.25,16.06,15.19,15.88,18.25,19.34,18.19,17.38,17.84,17.47,14.62,12.12,12.06,13.12,12.19,11.12,11.5,12.41,12.09,10.69,10.75,12.84,14.44,13.78,13.97,15.41,16.16,14.09,12.06,11.38,11.22,9.0,6.34,5.97,6.91,6.94,5.84,6.56,9.31,11.53,11.94,13.28,16.66,19.72,20.25,19.91,21.12,22.56,21.41,18.97,17.84,17.47,15.5,11.62,9.34,8.44,6.97,3.59,1.5,1.94,2.88,2.41,2.25,4.53,7.94,9.59,10.25,12.78,16.5,18.91,19.62,20.97,23.59,25.06,23.5,21.5,20.59,19.28,16.06,12.88,11.44,11.31,9.22,5.56,2.41,0.31,-2.53,-6.09,-7.22,-5.47,-2.66,-1.12,1.53,6.66,12.41,16.12,19.16,23.47,27.31,28.25,27.06,25.53,24.75,22.69,18.97,16.5,16.38,16.5,14.25,11.28,10.16,9.19,5.81,2.5,1.56,2.66,2.88,3.38,5.78,10.5,14.28,16.0,18.03,20.88,22.97,22.44,21.34,21.72,23.03,22.5,21.22,21.41,22.25,20.94,17.62,14.5,13.16,10.94,7.81,5.75,6.34,7.69,7.19,7.09,9.22,11.69,12.19,11.72,12.38,13.25,12.66,10.41,8.91,9.38,9.31,7.81,7.16,8.72,10.19,9.94,8.84,9.66,11.0,10.41,8.69,8.09,9.16,8.75,7.12,6.38,8.09,9.12,7.81,6.81,7.41,7.97,6.28,4.34,4.75,6.34,6.59,6.38,7.25,9.47,9.56,7.53,6.59,7.38,8.34,7.72,7.78,10.38,13.88,15.31,15.97,18.5,21.16,21.56,20.41,20.41,21.62,21.69,20.19,18.81,19.12,18.66,16.16,13.47,12.41,12.31,10.19,8.16,8.34,10.38,11.28,11.25,12.75,15.81,17.5,16.94,55.22,54.25,54.06,54.62,54.56,53.38,52.53:27.78,28.38,30.38,31.31,30.75,30.81,32.38,32.84,30.62,28.47,28.0,27.59,25.0,22.28,21.75,22.22,21.12,19.09,19.47,21.5,22.72,22.56,23.25,25.03,25.75,24.34,23.22,24.75,26.78,27.12,27.38,29.25,31.16,30.66,28.22,26.84,26.22,24.44,20.66,18.44,18.59,19.38,19.06,19.25,21.84,24.44,24.41,23.16,23.06,24.25,24.16,23.38,24.66,27.19,29.22,28.88,29.16,31.22,32.66,31.34,29.91,30.03,30.16,27.84,24.78,23.19,22.81,21.03,18.0,17.25,18.62,19.78,19.62,20.09,22.59,24.47,23.53,22.5,23.28,24.84,24.84,24.75,26.25,28.62,29.38,27.78,26.78,26.5,25.28,22.59,20.78,21.41,22.06,20.53,18.66,18.72,19.44,18.44,16.88,16.91,18.25,18.47,17.0,17.53,19.62,20.97,20.09,19.25,19.78,20.19,18.34,16.31,16.88,18.59,18.59,17.59,18.19,19.09,18.53,16.09,14.44,14.47,14.47,13.09,12.53,14.12,16.09,15.62,14.78,15.75,17.75,17.59,16.69,17.0,18.28,18.56,17.31,17.16,18.88,20.84,20.16,19.19,20.25,21.44,20.91,20.59,22.62,25.91,27.78,27.84,28.84,30.19,29.69,27.12,24.44,23.19,22.06,18.94,16.66,16.69,17.38,16.34,14.66,14.94,16.38,15.62,14.09,13.72,14.97,15.41,14.34,14.66,16.47,18.78,18.31,17.41,18.41,19.34,18.22,16.25,16.41,18.09,18.84,18.66,19.88,22.88,24.72,24.03,23.84,25.25,26.62,25.38,24.16,24.53,24.84,23.16,20.66,20.0,20.75,20.19,18.31,17.44,17.97,17.97,15.91,14.97,16.88,19.53,20.16,21.06,23.62,26.44,26.66,25.88,26.38,28.06,28.25,26.94,26.5,27.97,29.12,28.0,27.41,28.0,27.72,23.78,19.06,16.0,14.34,11.66,8.22,7.38,8.5,8.44,7.47,7.88,10.62,12.84,13.03,13.62,15.59,17.97,17.56,16.19,16.25,17.12,16.41,15.16,16.38,19.19,20.94,20.78,20.31,20.84,20.06,16.94,13.91,13.41,13.78,12.75,12.12,13.16,15.41,15.66,14.47,14.66,16.47,18.22,18.47,20.56,25.41,29.84,31.84,33.09,35.19,36.5,34.88,31.59,29.72,28.78,26.88,24.16,23.5,24.5,24.88,23.78,23.16,24.69,26.59,26.12,25.84,27.16,28.94,28.66,28.16,29.69,32.94,34.5,34.38,35.0,37.06,38.03,36.97,36.47,37.94,38.56,36.19,32.66,30.69,29.53,26.41,23.44,22.56,23.66,23.47,21.22,20.06,20.19,19.59,17.22,15.5,16.34,17.72,17.03,16.0,17.19,19.0,18.16,16.69,16.84,18.03,17.69,15.59,14.09,14.72,14.66,12.97,12.66,15.44,18.56,19.88,20.28,21.81,23.41,22.5,20.03,19.12,20.53,20.84,20.0,20.16,21.72,22.59,20.75,18.72,18.91,19.38,17.78,16.22,16.19,17.47,16.38,13.75,12.66,13.16,13.0,11.84,12.56,15.75,18.5,19.22,19.47,21.53,23.34,23.09,21.88,23.0,24.94,24.5,22.44,20.66,19.91,17.5,13.5,10.22,10.03,10.22,9.06,8.91,11.81,15.53,17.25,18.59,21.31,24.47,25.09,24.44,24.62,26.22,26.84,26.03,25.31,26.03,26.12,23.5,20.25,19.03,18.59,16.69,14.25,14.34,15.75,16.03,14.59,14.06,15.28,15.38,13.75,12.53,13.62,14.53,12.78,10.41,9.72,9.69,7.72,5.59,5.78,8.19,9.75,10.25,11.75,14.97,16.62,15.91,15.53,17.78,20.47,21.19,22.06,24.53,27.38,27.03,24.91,23.59,22.22,19.41,14.97,11.22,9.78,7.72,4.47,2.19,2.66,3.78,3.47,3.34,5.75,9.44,11.25,12.25,14.75,18.0,19.38,18.78,18.19,18.88,18.62,15.53,12.38,11.88,11.66,8.94,5.91,4.62,4.53,2.69,0.16,-0.06,1.41,2.09,1.47,1.38,3.47,5.41,5.38,5.72,8.25,11.5,12.5,12.69,14.19,15.78,15.09,13.12,13.0,15.31,17.0,17.56,18.22,20.81,22.5,21.56,20.25,21.06,22.12,21.03,19.12,18.84,19.94,19.12,16.94,15.88,16.75,17.09,16.06,15.31,17.25,18.75,17.94,16.94,18.56,20.81,21.19,20.84,22.44,25.16,26.19,25.75,26.28,28.06,28.88,27.16,25.69,26.38,26.62,24.78,22.31,22.28,22.78,21.25,19.03,19.12,20.88,21.47,20.56,20.84,22.5,22.84,21.5,20.38,21.41,22.28,21.19,19.75,20.91,23.22,24.25,24.28,25.75,28.06,27.84,25.25,23.12,23.09,22.06,19.5,17.28,17.47,17.84,16.38,14.41,15.25,16.91,17.0,16.28,17.34,19.62,20.78,20.0,20.0,21.72,23.38,22.91,22.31,23.88,24.91,23.69,21.09,19.91,19.22,17.03,13.47,11.59,12.19,11.78,10.69,11.0,14.06,17.0,18.47,19.78,23.59,27.72,29.59,29.75,30.81,32.16,30.69,27.84,26.62,27.28,27.34,25.75,25.03,25.97,26.12,24.16,22.28,22.72,23.69,23.16,22.31,23.28,25.22,25.88,25.25,25.81,28.0,29.5,28.78,28.84,30.5,32.12,31.88,31.06,32.66,34.47,34.5,33.5,34.25,35.75,35.72,33.84,33.12,34.28,34.5,33.25,32.06,32.44,32.16,30.06,27.72,27.81,28.84,28.28,26.81,27.5,28.94,29.06,27.34,26.41,27.19,27.5,25.69,24.59,25.81,27.28,26.81,26.41,28.28,30.47,30.38,28.5,27.94,28.03,27.28,25.25,24.5,26.03,27.22,26.91,26.78,28.84,31.0,30.66,29.53,29.47,29.72,28.44,26.22,25.66,27.06,27.22,25.53,24.34,24.88,24.81,22.69,20.81,21.41,22.38,21.28,19.81,20.31,21.38,20.97,19.0,18.53,19.56,20.0,18.5,18.25,19.94,21.03,19.81,18.72,19.59,21.19,21.09,20.91,22.28,24.19,24.31,22.66,21.69,22.0,21.75,19.97,19.91,22.38,24.88,25.28,25.19,26.59,28.0,27.0,25.25,25.12,26.31,25.94,23.84,22.84,23.16,22.69,20.0,17.84,18.12,18.53,16.91,15.31,16.0,17.22,16.72,15.72,17.16,20.0,21.44,21.12,21.84,24.16,25.44,24.5,23.84,25.03,25.34,23.69,21.12,20.84,21.19,19.38,16.44,15.31,16.0,16.38,16.25,17.75,21.84,25.56,26.81,28.56,31.88,35.09,35.03,33.81,33.16,32.25,28.75,24.16,21.97,21.41,20.62,18.91,18.81,20.56,22.78,23.12,24.06,26.66,28.94,28.47,26.56,26.5,27.06,26.91,25.38,25.06,25.84,25.19,22.41,20.72,21.22,22.0,21.19,20.62,22.0,23.22,21.72,19.22,18.16,18.38,17.47,15.84,16.31,19.25,21.62,22.5,23.5,25.91,27.5,26.06,24.19,24.31,24.69,22.34,19.28,18.19,18.41,17.78,16.44,16.72,19.16,20.88,20.59,20.59,21.59,22.06,20.03,17.84,17.97,18.91,18.59,17.66,19.47,22.66,24.59,25.12,25.91,27.88,28.5,26.53,24.59,24.44,24.06,21.22,18.06,17.12,17.31,16.31,15.16,16.34,19.12,20.94,21.25,22.31,24.28,25.69,24.84,24.28,24.84,25.53,23.72,21.34,21.28,21.5,19.75,17.12,16.34,16.94,17.12,16.16,16.38,18.5,19.94,19.19,18.22,18.75,19.12,17.06,14.5,14.0,14.84,15.03,15.03,16.91,20.41,22.44,22.34,21.94,22.84,23.09,21.06,19.22,19.34,19.88,17.97,15.5,15.25,16.25,16.06,15.19,15.88,18.25,19.34,18.19,17.38,17.84,17.47,14.62,12.12,12.06,13.12,12.19,11.12,11.5,12.41,12.09,10.69,10.75,12.84,14.44,13.78,13.97,15.41,16.16,14.09,12.06,11.38,11.22,9.0,6.34,5.97,6.91,6.94,5.84,6.56,9.31,11.53,11.94,13.28,16.66,19.72,20.25,19.91,21.12,22.56,21.41,18.97,17.84,17.47,15.5,11.62,9.34,8.44,6.97,3.59,1.5,1.94,2.88,2.41,2.25,4.53,7.94,9.59,10.25,12.78,16.5,18.91,19.62,20.97,23.59,25.06,23.5,21.5,20.59,19.28,16.06,12.88,11.44,11.31,9.22,5.56,2.41,0.31,-2.53,-6.09,-7.22,-5.47,-2.66,-1.12,1.53,6.66,12.41,16.12,19.16,23.47,27.31,28.25,27.06,25.53,24.75,22.69,18.97,16.5,16.38,16.5,14.25,11.28,10.16,9.19,5.81,2.5,1.56,2.66,2.88,3.38,5.78,10.5,14.28,16.0,18.03,20.88,22.97,22.44,21.34,21.72,23.03,22.5,21.22,21.41,22.25,20.94,17.62,14.5,13.16,10.94,7.81,5.75,6.34,7.69,7.19,7.09,9.22,11.69,12.19,11.72,12.38,13.25,12.66,10.41,8.91,9.38,9.31,7.81,7.16,8.72,10.19,9.94,8.84,9.66,11.0,10.41,8.69,8.09,9.16,8.75,7.12,6.38,8.09,9.12,7.81,6.81,7.41,7.97,6.28,4.34,4.75,6.34,6.59,6.38,7.25,9.47,9.56,7.53,6.59,7.38,8.34,7.72,7.78,10.38,13.88,15.31,15.97,18.5,21.16,21.56,20.41,20.41,21.62,21.69,20.19,18.81,19.12,18.66,16.16,13.47,12.41,12.31,10.19,8.16,8.34,10.38,11.28,11.25,12.75,15.81,17.5,16.94,55.22,54.25,54.06,54.62,54.56,53.38,52.53,52.59,52.5,51.09,49.81,49.47,49.66,49.19:32.84,30.62,28.47,28.0,27.59,25.0,22.28,21.75,22.22,21.12,19.09,19.47,21.5,22.72,22.56,23.25,25.03,25.75,24.34,23.22,24.75,26.78,27.12,27.38,29.25,31.16,30.66,28.22,26.84,26.22,24.44,20.66,18.44,18.59,19.38,19.06,19.25,21.84,24.44,24.41,23.16,23.06,24.25,24.16,23.38,24.66,27.19,29.22,28.88,29.16,31.22,32.66,31.34,29.91,30.03,30.16,27.84,24.78,23.19,22.81,21.03,18.0,17.25,18.62,19.78,19.62,20.09,22.59,24.47,23.53,22.5,23.28,24.84,24.84,24.75,26.25,28.62,29.38,27.78,26.78,26.5,25.28,22.59,20.78,21.41,22.06,20.53,18.66,18.72,19.44,18.44,16.88,16.91,18.25,18.47,17.0,17.53,19.62,20.97,20.09,19.25,19.78,20.19,18.34,16.31,16.88,18.59,18.59,17.59,18.19,19.09,18.53,16.09,14.44,14.47,14.47,13.09,12.53,14.12,16.09,15.62,14.78,15.75,17.75,17.59,16.69,17.0,18.28,18.56,17.31,17.16,18.88,20.84,20.16,19.19,20.25,21.44,20.91,20.59,22.62,25.91,27.78,27.84,28.84,30.19,29.69,27.12,24.44,23.19,22.06,18.94,16.66,16.69,17.38,16.34,14.66,14.94,16.38,15.62,14.09,13.72,14.97,15.41,14.34,14.66,16.47,18.78,18.31,17.41,18.41,19.34,18.22,16.25,16.41,18.09,18.84,18.66,19.88,22.88,24.72,24.03,23.84,25.25,26.62,25.38,24.16,24.53,24.84,23.16,20.66,20.0,20.75,20.19,18.31,17.44,17.97,17.97,15.91,14.97,16.88,19.53,20.16,21.06,23.62,26.44,26.66,25.88,26.38,28.06,28.25,26.94,26.5,27.97,29.12,28.0,27.41,28.0,27.72,23.78,19.06,16.0,14.34,11.66,8.22,7.38,8.5,8.44,7.47,7.88,10.62,12.84,13.03,13.62,15.59,17.97,17.56,16.19,16.25,17.12,16.41,15.16,16.38,19.19,20.94,20.78,20.31,20.84,20.06,16.94,13.91,13.41,13.78,12.75,12.12,13.16,15.41,15.66,14.47,14.66,16.47,18.22,18.47,20.56,25.41,29.84,31.84,33.09,35.19,36.5,34.88,31.59,29.72,28.78,26.88,24.16,23.5,24.5,24.88,23.78,23.16,24.69,26.59,26.12,25.84,27.16,28.94,28.66,28.16,29.69,32.94,34.5,34.38,35.0,37.06,38.03,36.97,36.47,37.94,38.56,36.19,32.66,30.69,29.53,26.41,23.44,22.56,23.66,23.47,21.22,20.06,20.19,19.59,17.22,15.5,16.34,17.72,17.03,16.0,17.19,19.0,18.16,16.69,16.84,18.03,17.69,15.59,14.09,14.72,14.66,12.97,12.66,15.44,18.56,19.88,20.28,21.81,23.41,22.5,20.03,19.12,20.53,20.84,20.0,20.16,21.72,22.59,20.75,18.72,18.91,19.38,17.78,16.22,16.19,17.47,16.38,13.75,12.66,13.16,13.0,11.84,12.56,15.75,18.5,19.22,19.47,21.53,23.34,23.09,21.88,23.0,24.94,24.5,22.44,20.66,19.91,17.5,13.5,10.22,10.03,10.22,9.06,8.91,11.81,15.53,17.25,18.59,21.31,24.47,25.09,24.44,24.62,26.22,26.84,26.03,25.31,26.03,26.12,23.5,20.25,19.03,18.59,16.69,14.25,14.34,15.75,16.03,14.59,14.06,15.28,15.38,13.75,12.53,13.62,14.53,12.78,10.41,9.72,9.69,7.72,5.59,5.78,8.19,9.75,10.25,11.75,14.97,16.62,15.91,15.53,17.78,20.47,21.19,22.06,24.53,27.38,27.03,24.91,23.59,22.22,19.41,14.97,11.22,9.78,7.72,4.47,2.19,2.66,3.78,3.47,3.34,5.75,9.44,11.25,12.25,14.75,18.0,19.38,18.78,18.19,18.88,18.62,15.53,12.38,11.88,11.66,8.94,5.91,4.62,4.53,2.69,0.16,-0.06,1.41,2.09,1.47,1.38,3.47,5.41,5.38,5.72,8.25,11.5,12.5,12.69,14.19,15.78,15.09,13.12,13.0,15.31,17.0,17.56,18.22,20.81,22.5,21.56,20.25,21.06,22.12,21.03,19.12,18.84,19.94,19.12,16.94,15.88,16.75,17.09,16.06,15.31,17.25,18.75,17.94,16.94,18.56,20.81,21.19,20.84,22.44,25.16,26.19,25.75,26.28,28.06,28.88,27.16,25.69,26.38,26.62,24.78,22.31,22.28,22.78,21.25,19.03,19.12,20.88,21.47,20.56,20.84,22.5,22.84,21.5,20.38,21.41,22.28,21.19,19.75,20.91,23.22,24.25,24.28,25.75,28.06,27.84,25.25,23.12,23.09,22.06,19.5,17.28,17.47,17.84,16.38,14.41,15.25,16.91,17.0,16.28,17.34,19.62,20.78,20.0,20.0,21.72,23.38,22.91,22.31,23.88,24.91,23.69,21.09,19.91,19.22,17.03,13.47,11.59,12.19,11.78,10.69,11.0,14.06,17.0,18.47,19.78,23.59,27.72,29.59,29.75,30.81,32.16,30.69,27.84,26.62,27.28,27.34,25.75,25.03,25.97,26.12,24.16,22.28,22.72,23.69,23.16,22.31,23.28,25.22,25.88,25.25,25.81,28.0,29.5,28.78,28.84,30.5,32.12,31.88,31.06,32.66,34.47,34.5,33.5,34.25,35.75,35.72,33.84,33.12,34.28,34.5,33.25,32.06,32.44,32.16,30.06,27.72,27.81,28.84,28.28,26.81,27.5,28.94,29.06,27.34,26.41,27.19,27.5,25.69,24.59,25.81,27.28,26.81,26.41,28.28,30.47,30.38,28.5,27.94,28.03,27.28,25.25,24.5,26.03,27.22,26.91,26.78,28.84,31.0,30.66,29.53,29.47,29.72,28.44,26.22,25.66,27.06,27.22,25.53,24.34,24.88,24.81,22.69,20.81,21.41,22.38,21.28,19.81,20.31,21.38,20.97,19.0,18.53,19.56,20.0,18.5,18.25,19.94,21.03,19.81,18.72,19.59,21.19,21.09,20.91,22.28,24.19,24.31,22.66,21.69,22.0,21.75,19.97,19.91,22.38,24.88,25.28,25.19,26.59,28.0,27.0,25.25,25.12,26.31,25.94,23.84,22.84,23.16,22.69,20.0,17.84,18.12,18.53,16.91,15.31,16.0,17.22,16.72,15.72,17.16,20.0,21.44,21.12,21.84,24.16,25.44,24.5,23.84,25.03,25.34,23.69,21.12,20.84,21.19,19.38,16.44,15.31,16.0,16.38,16.25,17.75,21.84,25.56,26.81,28.56,31.88,35.09,35.03,33.81,33.16,32.25,28.75,24.16,21.97,21.41,20.62,18.91,18.81,20.56,22.78,23.12,24.06,26.66,28.94,28.47,26.56,26.5,27.06,26.91,25.38,25.06,25.84,25.19,22.41,20.72,21.22,22.0,21.19,20.62,22.0,23.22,21.72,19.22,18.16,18.38,17.47,15.84,16.31,19.25,21.62,22.5,23.5,25.91,27.5,26.06,24.19,24.31,24.69,22.34,19.28,18.19,18.41,17.78,16.44,16.72,19.16,20.88,20.59,20.59,21.59,22.06,20.03,17.84,17.97,18.91,18.59,17.66,19.47,22.66,24.59,25.12,25.91,27.88,28.5,26.53,24.59,24.44,24.06,21.22,18.06,17.12,17.31,16.31,15.16,16.34,19.12,20.94,21.25,22.31,24.28,25.69,24.84,24.28,24.84,25.53,23.72,21.34,21.28,21.5,19.75,17.12,16.34,16.94,17.12,16.16,16.38,18.5,19.94,19.19,18.22,18.75,19.12,17.06,14.5,14.0,14.84,15.03,15.03,16.91,20.41,22.44,22.34,21.94,22.84,23.09,21.06,19.22,19.34,19.88,17.97,15.5,15.25,16.25,16.06,15.19,15.88,18.25,19.34,18.19,17.38,17.84,17.47,14.62,12.12,12.06,13.12,12.19,11.12,11.5,12.41,12.09,10.69,10.75,12.84,14.44,13.78,13.97,15.41,16.16,14.09,12.06,11.38,11.22,9.0,6.34,5.97,6.91,6.94,5.84,6.56,9.31,11.53,11.94,13.28,16.66,19.72,20.25,19.91,21.12,22.56,21.41,18.97,17.84,17.47,15.5,11.62,9.34,8.44,6.97,3.59,1.5,1.94,2.88,2.41,2.25,4.53,7.94,9.59,10.25,12.78,16.5,18.91,19.62,20.97,23.59,25.06,23.5,21.5,20.59,19.28,16.06,12.88,11.44,11.31,9.22,5.56,2.41,0.31,-2.53,-6.09,-7.22,-5.47,-2.66,-1.12,1.53,6.66,12.41,16.12,19.16,23.47,27.31,28.25,27.06,25.53,24.75,22.69,18.97,16.5,16.38,16.5,14.25,11.28,10.16,9.19,5.81,2.5,1.56,2.66,2.88,3.38,5.78,10.5,14.28,16.0,18.03,20.88,22.97,22.44,21.34,21.72,23.03,22.5,21.22,21.41,22.25,20.94,17.62,14.5,13.16,10.94,7.81,5.75,6.34,7.69,7.19,7.09,9.22,11.69,12.19,11.72,12.38,13.25,12.66,10.41,8.91,9.38,9.31,7.81,7.16,8.72,10.19,9.94,8.84,9.66,11.0,10.41,8.69,8.09,9.16,8.75,7.12,6.38,8.09,9.12,7.81,6.81,7.41,7.97,6.28,4.34,4.75,6.34,6.59,6.38,7.25,9.47,9.56,7.53,6.59,7.38,8.34,7.72,7.78,10.38,13.88,15.31,15.97,18.5,21.16,21.56,20.41,20.41,21.62,21.69,20.19,18.81,19.12,18.66,16.16,13.47,12.41,12.31,10.19,8.16,8.34,10.38,11.28,11.25,12.75,15.81,17.5,16.94,55.22,54.25,54.06,54.62,54.56,53.38,52.53,52.59,52.5,51.09,49.81,49.47,49.66,49.19,48.5,49.22,50.84,51.84,51.72,52.19,52.69:21.75,22.22,21.12,19.09,19.47,21.5,22.72,22.56,23.25,25.03,25.75,24.34,23.22,24.75,26.78,27.12,27.38,29.25,31.16,30.66,28.22,26.84,26.22,24.44,20.66,18.44,18.59,19.38,19.06,19.25,21.84,24.44,24.41,23.16,23.06,24.25,24.16,23.38,24.66,27.19,29.22,28.88,29.16,31.22,32.66,31.34,29.91,30.03,30.16,27.84,24.78,23.19,22.81,21.03,18.0,17.25,18.62,19.78,19.62,20.09,22.59,24.47,23.53,22.5,23.28,24.84,24.84,24.75,26.25,28.62,29.38,27.78,26.78,26.5,25.28,22.59,20.78,21.41,22.06,20.53,18.66,18.72,19.44,18.44,16.88,16.91,18.25,18.47,17.0,17.53,19.62,20.97,20.09,19.25,19.78,20.19,18.34,16.31,16.88,18.59,18.59,17.59,18.19,19.09,18.53,16.09,14.44,14.47,14.47,13.09,12.53,14.12,16.09,15.62,14.78,15.75,17.75,17.59,16.69,17.0,18.28,18.56,17.31,17.16,18.88,20.84,20.16,19.19,20.25,21.44,20.91,20.59,22.62,25.91,27.78,27.84,28.84,30.19,29.69,27.12,24.44,23.19,22.06,18.94,16.66,16.69,17.38,16.34,14.66,14.94,16.38,15.62,14.09,13.72,14.97,15.41,14.34,14.66,16.47,18.78,18.31,17.41,18.41,19.34,18.22,16.25,16.41,18.09,18.84,18.66,19.88,22.88,24.72,24.03,23.84,25.25,26.62,25.38,24.16,24.53,24.84,23.16,20.66,20.0,20.75,20.19,18.31,17.44,17.97,17.97,15.91,14.97,16.88,19.53,20.16,21.06,23.62,26.44,26.66,25.88,26.38,28.06,28.25,26.94,26.5,27.97,29.12,28.0,27.41,28.0,27.72,23.78,19.06,16.0,14.34,11.66,8.22,7.38,8.5,8.44,7.47,7.88,10.62,12.84,13.03,13.62,15.59,17.97,17.56,16.19,16.25,17.12,16.41,15.16,16.38,19.19,20.94,20.78,20.31,20.84,20.06,16.94,13.91,13.41,13.78,12.75,12.12,13.16,15.41,15.66,14.47,14.66,16.47,18.22,18.47,20.56,25.41,29.84,31.84,33.09,35.19,36.5,34.88,31.59,29.72,28.78,26.88,24.16,23.5,24.5,24.88,23.78,23.16,24.69,26.59,26.12,25.84,27.16,28.94,28.66,28.16,29.69,32.94,34.5,34.38,35.0,37.06,38.03,36.97,36.47,37.94,38.56,36.19,32.66,30.69,29.53,26.41,23.44,22.56,23.66,23.47,21.22,20.06,20.19,19.59,17.22,15.5,16.34,17.72,17.03,16.0,17.19,19.0,18.16,16.69,16.84,18.03,17.69,15.59,14.09,14.72,14.66,12.97,12.66,15.44,18.56,19.88,20.28,21.81,23.41,22.5,20.03,19.12,20.53,20.84,20.0,20.16,21.72,22.59,20.75,18.72,18.91,19.38,17.78,16.22,16.19,17.47,16.38,13.75,12.66,13.16,13.0,11.84,12.56,15.75,18.5,19.22,19.47,21.53,23.34,23.09,21.88,23.0,24.94,24.5,22.44,20.66,19.91,17.5,13.5,10.22,10.03,10.22,9.06,8.91,11.81,15.53,17.25,18.59,21.31,24.47,25.09,24.44,24.62,26.22,26.84,26.03,25.31,26.03,26.12,23.5,20.25,19.03,18.59,16.69,14.25,14.34,15.75,16.03,14.59,14.06,15.28,15.38,13.75,12.53,13.62,14.53,12.78,10.41,9.72,9.69,7.72,5.59,5.78,8.19,9.75,10.25,11.75,14.97,16.62,15.91,15.53,17.78,20.47,21.19,22.06,24.53,27.38,27.03,24.91,23.59,22.22,19.41,14.97,11.22,9.78,7.72,4.47,2.19,2.66,3.78,3.47,3.34,5.75,9.44,11.25,12.25,14.75,18.0,19.38,18.78,18.19,18.88,18.62,15.53,12.38,11.88,11.66,8.94,5.91,4.62,4.53,2.69,0.16,-0.06,1.41,2.09,1.47,1.38,3.47,5.41,5.38,5.72,8.25,11.5,12.5,12.69,14.19,15.78,15.09,13.12,13.0,15.31,17.0,17.56,18.22,20.81,22.5,21.56,20.25,21.06,22.12,21.03,19.12,18.84,19.94,19.12,16.94,15.88,16.75,17.09,16.06,15.31,17.25,18.75,17.94,16.94,18.56,20.81,21.19,20.84,22.44,25.16,26.19,25.75,26.28,28.06,28.88,27.16,25.69,26.38,26.62,24.78,22.31,22.28,22.78,21.25,19.03,19.12,20.88,21.47,20.56,20.84,22.5,22.84,21.5,20.38,21.41,22.28,21.19,19.75,20.91,23.22,24.25,24.28,25.75,28.06,27.84,25.25,23.12,23.09,22.06,19.5,17.28,17.47,17.84,16.38,14.41,15.25,16.91,17.0,16.28,17.34,19.62,20.78,20.0,20.0,21.72,23.38,22.91,22.31,23.88,24.91,23.69,21.09,19.91,19.22,17.03,13.47,11.59,12.19,11.78,10.69,11.0,14.06,17.0,18.47,19.78,23.59,27.72,29.59,29.75,30.81,32.16,30.69,27.84,26.62,27.28,27.34,25.75,25.03,25.97,26.12,24.16,22.28,22.72,23.69,23.16,22.31,23.28,25.22,25.88,25.25,25.81,28.0,29.5,28.78,28.84,30.5,32.12,31.88,31.06,32.66,34.47,34.5,33.5,34.25,35.75,35.72,33.84,33.12,34.28,34.5,33.25,32.06,32.44,32.16,30.06,27.72,27.81,28.84,28.28,26.81,27.5,28.94,29.06,27.34,26.41,27.19,27.5,25.69,24.59,25.81,27.28,26.81,26.41,28.28,30.47,30.38,28.5,27.94,28.03,27.28,25.25,24.5,26.03,27.22,26.91,26.78,28.84,31.0,30.66,29.53,29.47,29.72,28.44,26.22,25.66,27.06,27.22,25.53,24.34,24.88,24.81,22.69,20.81,21.41,22.38,21.28,19.81,20.31,21.38,20.97,19.0,18.53,19.56,20.0,18.5,18.25,19.94,21.03,19.81,18.72,19.59,21.19,21.09,20.91,22.28,24.19,24.31,22.66,21.69,22.0,21.75,19.97,19.91,22.38,24.88,25.28,25.19,26.59,28.0,27.0,25.25,25.12,26.31,25.94,23.84,22.84,23.16,22.69,20.0,17.84,18.12,18.53,16.91,15.31,16.0,17.22,16.72,15.72,17.16,20.0,21.44,21.12,21.84,24.16,25.44,24.5,23.84,25.03,25.34,23.69,21.12,20.84,21.19,19.38,16.44,15.31,16.0,16.38,16.25,17.75,21.84,25.56,26.81,28.56,31.88,35.09,35.03,33.81,33.16,32.25,28.75,24.16,21.97,21.41,20.62,18.91,18.81,20.56,22.78,23.12,24.06,26.66,28.94,28.47,26.56,26.5,27.06,26.91,25.38,25.06,25.84,25.19,22.41,20.72,21.22,22.0,21.19,20.62,22.0,23.22,21.72,19.22,18.16,18.38,17.47,15.84,16.31,19.25,21.62,22.5,23.5,25.91,27.5,26.06,24.19,24.31,24.69,22.34,19.28,18.19,18.41,17.78,16.44,16.72,19.16,20.88,20.59,20.59,21.59,22.06,20.03,17.84,17.97,18.91,18.59,17.66,19.47,22.66,24.59,25.12,25.91,27.88,28.5,26.53,24.59,24.44,24.06,21.22,18.06,17.12,17.31,16.31,15.16,16.34,19.12,20.94,21.25,22.31,24.28,25.69,24.84,24.28,24.84,25.53,23.72,21.34,21.28,21.5,19.75,17.12,16.34,16.94,17.12,16.16,16.38,18.5,19.94,19.19,18.22,18.75,19.12,17.06,14.5,14.0,14.84,15.03,15.03,16.91,20.41,22.44,22.34,21.94,22.84,23.09,21.06,19.22,19.34,19.88,17.97,15.5,15.25,16.25,16.06,15.19,15.88,18.25,19.34,18.19,17.38,17.84,17.47,14.62,12.12,12.06,13.12,12.19,11.12,11.5,12.41,12.09,10.69,10.75,12.84,14.44,13.78,13.97,15.41,16.16,14.09,12.06,11.38,11.22,9.0,6.34,5.97,6.91,6.94,5.84,6.56,9.31,11.53,11.94,13.28,16.66,19.72,20.25,19.91,21.12,22.56,21.41,18.97,17.84,17.47,15.5,11.62,9.34,8.44,6.97,3.59,1.5,1.94,2.88,2.41,2.25,4.53,7.94,9.59,10.25,12.78,16.5,18.91,19.62,20.97,23.59,25.06,23.5,21.5,20.59,19.28,16.06,12.88,11.44,11.31,9.22,5.56,2.41,0.31,-2.53,-6.09,-7.22,-5.47,-2.66,-1.12,1.53,6.66,12.41,16.12,19.16,23.47,27.31,28.25,27.06,25.53,24.75,22.69,18.97,16.5,16.38,16.5,14.25,11.28,10.16,9.19,5.81,2.5,1.56,2.66,2.88,3.38,5.78,10.5,14.28,16.0,18.03,20.88,22.97,22.44,21.34,21.72,23.03,22.5,21.22,21.41,22.25,20.94,17.62,14.5,13.16,10.94,7.81,5.75,6.34,7.69,7.19,7.09,9.22,11.69,12.19,11.72,12.38,13.25,12.66,10.41,8.91,9.38,9.31,7.81,7.16,8.72,10.19,9.94,8.84,9.66,11.0,10.41,8.69,8.09,9.16,8.75,7.12,6.38,8.09,9.12,7.81,6.81,7.41,7.97,6.28,4.34,4.75,6.34,6.59,6.38,7.25,9.47,9.56,7.53,6.59,7.38,8.34,7.72,7.78,10.38,13.88,15.31,15.97,18.5,21.16,21.56,20.41,20.41,21.62,21.69,20.19,18.81,19.12,18.66,16.16,13.47,12.41,12.31,10.19,8.16,8.34,10.38,11.28,11.25,12.75,15.81,17.5,16.94,55.22,54.25,54.06,54.62,54.56,53.38,52.53,52.59,52.5,51.09,49.81,49.47,49.66,49.19,48.5,49.22,50.84,51.84,51.72,52.19,52.69,52.72,51.0,48.88,48.38,47.56,45.81,44.38:22.56,23.25,25.03,25.75,24.34,23.22,24.75,26.78,27.12,27.38,29.25,31.16,30.66,28.22,26.84,26.22,24.44,20.66,18.44,18.59,19.38,19.06,19.25,21.84,24.44,24.41,23.16,23.06,24.25,24.16,23.38,24.66,27.19,29.22,28.88,29.16,31.22,32.66,31.34,29.91,30.03,30.16,27.84,24.78,23.19,22.81,21.03,18.0,17.25,18.62,19.78,19.62,20.09,22.59,24.47,23.53,22.5,23.28,24.84,24.84,24.75,26.25,28.62,29.38,27.78,26.78,26.5,25.28,22.59,20.78,21.41,22.06,20.53,18.66,18.72,19.44,18.44,16.88,16.91,18.25,18.47,17.0,17.53,19.62,20.97,20.09,19.25,19.78,20.19,18.34,16.31,16.88,18.59,18.59,17.59,18.19,19.09,18.53,16.09,14.44,14.47,14.47,13.09,12.53,14.12,16.09,15.62,14.78,15.75,17.75,17.59,16.69,17.0,18.28,18.56,17.31,17.16,18.88,20.84,20.16,19.19,20.25,21.44,20.91,20.59,22.62,25.91,27.78,27.84,28.84,30.19,29.69,27.12,24.44,23.19,22.06,18.94,16.66,16.69,17.38,16.34,14.66,14.94,16.38,15.62,14.09,13.72,14.97,15.41,14.34,14.66,16.47,18.78,18.31,17.41,18.41,19.34,18.22,16.25,16.41,18.09,18.84,18.66,19.88,22.88,24.72,24.03,23.84,25.25,26.62,25.38,24.16,24.53,24.84,23.16,20.66,20.0,20.75,20.19,18.31,17.44,17.97,17.97,15.91,14.97,16.88,19.53,20.16,21.06,23.62,26.44,26.66,25.88,26.38,28.06,28.25,26.94,26.5,27.97,29.12,28.0,27.41,28.0,27.72,23.78,19.06,16.0,14.34,11.66,8.22,7.38,8.5,8.44,7.47,7.88,10.62,12.84,13.03,13.62,15.59,17.97,17.56,16.19,16.25,17.12,16.41,15.16,16.38,19.19,20.94,20.78,20.31,20.84,20.06,16.94,13.91,13.41,13.78,12.75,12.12,13.16,15.41,15.66,14.47,14.66,16.47,18.22,18.47,20.56,25.41,29.84,31.84,33.09,35.19,36.5,34.88,31.59,29.72,28.78,26.88,24.16,23.5,24.5,24.88,23.78,23.16,24.69,26.59,26.12,25.84,27.16,28.94,28.66,28.16,29.69,32.94,34.5,34.38,35.0,37.06,38.03,36.97,36.47,37.94,38.56,36.19,32.66,30.69,29.53,26.41,23.44,22.56,23.66,23.47,21.22,20.06,20.19,19.59,17.22,15.5,16.34,17.72,17.03,16.0,17.19,19.0,18.16,16.69,16.84,18.03,17.69,15.59,14.09,14.72,14.66,12.97,12.66,15.44,18.56,19.88,20.28,21.81,23.41,22.5,20.03,19.12,20.53,20.84,20.0,20.16,21.72,22.59,20.75,18.72,18.91,19.38,17.78,16.22,16.19,17.47,16.38,13.75,12.66,13.16,13.0,11.84,12.56,15.75,18.5,19.22,19.47,21.53,23.34,23.09,21.88,23.0,24.94,24.5,22.44,20.66,19.91,17.5,13.5,10.22,10.03,10.22,9.06,8.91,11.81,15.53,17.25,18.59,21.31,24.47,25.09,24.44,24.62,26.22,26.84,26.03,25.31,26.03,26.12,23.5,20.25,19.03,18.59,16.69,14.25,14.34,15.75,16.03,14.59,14.06,15.28,15.38,13.75,12.53,13.62,14.53,12.78,10.41,9.72,9.69,7.72,5.59,5.78,8.19,9.75,10.25,11.75,14.97,16.62,15.91,15.53,17.78,20.47,21.19,22.06,24.53,27.38,27.03,24.91,23.59,22.22,19.41,14.97,11.22,9.78,7.72,4.47,2.19,2.66,3.78,3.47,3.34,5.75,9.44,11.25,12.25,14.75,18.0,19.38,18.78,18.19,18.88,18.62,15.53,12.38,11.88,11.66,8.94,5.91,4.62,4.53,2.69,0.16,-0.06,1.41,2.09,1.47,1.38,3.47,5.41,5.38,5.72,8.25,11.5,12.5,12.69,14.19,15.78,15.09,13.12,13.0,15.31,17.0,17.56,18.22,20.81,22.5,21.56,20.25,21.06,22.12,21.03,19.12,18.84,19.94,19.12,16.94,15.88,16.75,17.09,16.06,15.31,17.25,18.75,17.94,16.94,18.56,20.81,21.19,20.84,22.44,25.16,26.19,25.75,26.28,28.06,28.88,27.16,25.69,26.38,26.62,24.78,22.31,22.28,22.78,21.25,19.03,19.12,20.88,21.47,20.56,20.84,22.5,22.84,21.5,20.38,21.41,22.28,21.19,19.75,20.91,23.22,24.25,24.28,25.75,28.06,27.84,25.25,23.12,23.09,22.06,19.5,17.28,17.47,17.84,16.38,14.41,15.25,16.91,17.0,16.28,17.34,19.62,20.78,20.0,20.0,21.72,23.38,22.91,22.31,23.88,24.91,23.69,21.09,19.91,19.22,17.03,13.47,11.59,12.19,11.78,10.69,11.0,14.06,17.0,18.47,19.78,23.59,27.72,29.59,29.75,30.81,32.16,30.69,27.84,26.62,27.28,27.34,25.75,25.03,25.97,26.12,24.16,22.28,22.72,23.69,23.16,22.31,23.28,25.22,25.88,25.25,25.81,28.0,29.5,28.78,28.84,30.5,32.12,31.88,31.06,32.66,34.47,34.5,33.5,34.25,35.75,35.72,33.84,33.12,34.28,34.5,33.25,32.06,32.44,32.16,30.06,27.72,27.81,28.84,28.28,26.81,27.5,28.94,29.06,27.34,26.41,27.19,27.5,25.69,24.59,25.81,27.28,26.81,26.41,28.28,30.47,30.38,28.5,27.94,28.03,27.28,25.25,24.5,26.03,27.22,26.91,26.78,28.84,31.0,30.66,29.53,29.47,29.72,28.44,26.22,25.66,27.06,27.22,25.53,24.34,24.88,24.81,22.69,20.81,21.41,22.38,21.28,19.81,20.31,21.38,20.97,19.0,18.53,19.56,20.0,18.5,18.25,19.94,21.03,19.81,18.72,19.59,21.19,21.09,20.91,22.28,24.19,24.31,22.66,21.69,22.0,21.75,19.97,19.91,22.38,24.88,25.28,25.19,26.59,28.0,27.0,25.25,25.12,26.31,25.94,23.84,22.84,23.16,22.69,20.0,17.84,18.12,18.53,16.91,15.31,16.0,17.22,16.72,15.72,17.16,20.0,21.44,21.12,21.84,24.16,25.44,24.5,23.84,25.03,25.34,23.69,21.12,20.84,21.19,19.38,16.44,15.31,16.0,16.38,16.25,17.75,21.84,25.56,26.81,28.56,31.88,35.09,35.03,33.81,33.16,32.25,28.75,24.16,21.97,21.41,20.62,18.91,18.81,20.56,22.78,23.12,24.06,26.66,28.94,28.47,26.56,26.5,27.06,26.91,25.38,25.06,25.84,25.19,22.41,20.72,21.22,22.0,21.19,20.62,22.0,23.22,21.72,19.22,18.16,18.38,17.47,15.84,16.31,19.25,21.62,22.5,23.5,25.91,27.5,26.06,24.19,24.31,24.69,22.34,19.28,18.19,18.41,17.78,16.44,16.72,19.16,20.88,20.59,20.59,21.59,22.06,20.03,17.84,17.97,18.91,18.59,17.66,19.47,22.66,24.59,25.12,25.91,27.88,28.5,26.53,24.59,24.44,24.06,21.22,18.06,17.12,17.31,16.31,15.16,16.34,19.12,20.94,21.25,22.31,24.28,25.69,24.84,24.28,24.84,25.53,23.72,21.34,21.28,21.5,19.75,17.12,16.34,16.94,17.12,16.16,16.38,18.5,19.94,19.19,18.22,18.75,19.12,17.06,14.5,14.0,14.84,15.03,15.03,16.91,20.41,22.44,22.34,21.94,22.84,23.09,21.06,19.22,19.34,19.88,17.97,15.5,15.25,16.25,16.06,15.19,15.88,18.25,19.34,18.19,17.38,17.84,17.47,14.62,12.12,12.06,13.12,12.19,11.12,11.5,12.41,12.09,10.69,10.75,12.84,14.44,13.78,13.97,15.41,16.16,14.09,12.06,11.38,11.22,9.0,6.34,5.97,6.91,6.94,5.84,6.56,9.31,11.53,11.94,13.28,16.66,19.72,20.25,19.91,21.12,22.56,21.41,18.97,17.84,17.47,15.5,11.62,9.34,8.44,6.97,3.59,1.5,1.94,2.88,2.41,2.25,4.53,7.94,9.59,10.25,12.78,16.5,18.91,19.62,20.97,23.59,25.06,23.5,21.5,20.59,19.28,16.06,12.88,11.44,11.31,9.22,5.56,2.41,0.31,-2.53,-6.09,-7.22,-5.47,-2.66,-1.12,1.53,6.66,12.41,16.12,19.16,23.47,27.31,28.25,27.06,25.53,24.75,22.69,18.97,16.5,16.38,16.5,14.25,11.28,10.16,9.19,5.81,2.5,1.56,2.66,2.88,3.38,5.78,10.5,14.28,16.0,18.03,20.88,22.97,22.44,21.34,21.72,23.03,22.5,21.22,21.41,22.25,20.94,17.62,14.5,13.16,10.94,7.81,5.75,6.34,7.69,7.19,7.09,9.22,11.69,12.19,11.72,12.38,13.25,12.66,10.41,8.91,9.38,9.31,7.81,7.16,8.72,10.19,9.94,8.84,9.66,11.0,10.41,8.69,8.09,9.16,8.75,7.12,6.38,8.09,9.12,7.81,6.81,7.41,7.97,6.28,4.34,4.75,6.34,6.59,6.38,7.25,9.47,9.56,7.53,6.59,7.38,8.34,7.72,7.78,10.38,13.88,15.31,15.97,18.5,21.16,21.56,20.41,20.41,21.62,21.69,20.19,18.81,19.12,18.66,16.16,13.47,12.41,12.31,10.19,8.16,8.34,10.38,11.28,11.25,12.75,15.81,17.5,16.94,55.22,54.25,54.06,54.62,54.56,53.38,52.53,52.59,52.5,51.09,49.81,49.47,49.66,49.19,48.5,49.22,50.84,51.84,51.72,52.19,52.69,52.72,51.0,48.88,48.38,47.56,45.81,44.38,44.12,44.12,43.12,41.47,41.22,42.44,43.38:26.78,27.12,27.38,29.25,31.16,30.66,28.22,26.84,26.22,24.44,20.66,18.44,18.59,19.38,19.06,19.25,21.84,24.44,24.41,23.16,23.06,24.25,24.16,23.38,24.66,27.19,29.22,28.88,29.16,31.22,32.66,31.34,29.91,30.03,30.16,27.84,24.78,23.19,22.81,21.03,18.0,17.25,18.62,19.78,19.62,20.09,22.59,24.47,23.53,22.5,23.28,24.84,24.84,24.75,26.25,28.62,29.38,27.78,26.78,26.5,25.28,22.59,20.78,21.41,22.06,20.53,18.66,18.72,19.44,18.44,16.88,16.91,18.25,18.47,17.0,17.53,19.62,20.97,20.09,19.25,19.78,20.19,18.34,16.31,16.88,18.59,18.59,17.59,18.19,19.09,18.53,16.09,14.44,14.47,14.47,13.09,12.53,14.12,16.09,15.62,14.78,15.75,17.75,17.59,16.69,17.0,18.28,18.56,17.31,17.16,18.88,20.84,20.16,19.19,20.25,21.44,20.91,20.59,22.62,25.91,27.78,27.84,28.84,30.19,29.69,27.12,24.44,23.19,22.06,18.94,16.66,16.69,17.38,16.34,14.66,14.94,16.38,15.62,14.09,13.72,14.97,15.41,14.34,14.66,16.47,18.78,18.31,17.41,18.41,19.34,18.22,16.25,16.41,18.09,18.84,18.66,19.88,22.88,24.72,24.03,23.84,25.25,26.62,25.38,24.16,24.53,24.84,23.16,20.66,20.0,20.75,20.19,18.31,17.44,17.97,17.97,15.91,14.97,16.88,19.53,20.16,21.06,23.62,26.44,26.66,25.88,26.38,28.06,28.25,26.94,26.5,27.97,29.12,28.0,27.41,28.0,27.72,23.78,19.06,16.0,14.34,11.66,8.22,7.38,8.5,8.44,7.47,7.88,10.62,12.84,13.03,13.62,15.59,17.97,17.56,16.19,16.25,17.12,16.41,15.16,16.38,19.19,20.94,20.78,20.31,20.84,20.06,16.94,13.91,13.41,13.78,12.75,12.12,13.16,15.41,15.66,14.47,14.66,16.47,18.22,18.47,20.56,25.41,29.84,31.84,33.09,35.19,36.5,34.88,31.59,29.72,28.78,26.88,24.16,23.5,24.5,24.88,23.78,23.16,24.69,26.59,26.12,25.84,27.16,28.94,28.66,28.16,29.69,32.94,34.5,34.38,35.0,37.06,38.03,36.97,36.47,37.94,38.56,36.19,32.66,30.69,29.53,26.41,23.44,22.56,23.66,23.47,21.22,20.06,20.19,19.59,17.22,15.5,16.34,17.72,17.03,16.0,17.19,19.0,18.16,16.69,16.84,18.03,17.69,15.59,14.09,14.72,14.66,12.97,12.66,15.44,18.56,19.88,20.28,21.81,23.41,22.5,20.03,19.12,20.53,20.84,20.0,20.16,21.72,22.59,20.75,18.72,18.91,19.38,17.78,16.22,16.19,17.47,16.38,13.75,12.66,13.16,13.0,11.84,12.56,15.75,18.5,19.22,19.47,21.53,23.34,23.09,21.88,23.0,24.94,24.5,22.44,20.66,19.91,17.5,13.5,10.22,10.03,10.22,9.06,8.91,11.81,15.53,17.25,18.59,21.31,24.47,25.09,24.44,24.62,26.22,26.84,26.03,25.31,26.03,26.12,23.5,20.25,19.03,18.59,16.69,14.25,14.34,15.75,16.03,14.59,14.06,15.28,15.38,13.75,12.53,13.62,14.53,12.78,10.41,9.72,9.69,7.72,5.59,5.78,8.19,9.75,10.25,11.75,14.97,16.62,15.91,15.53,17.78,20.47,21.19,22.06,24.53,27.38,27.03,24.91,23.59,22.22,19.41,14.97,11.22,9.78,7.72,4.47,2.19,2.66,3.78,3.47,3.34,5.75,9.44,11.25,12.25,14.75,18.0,19.38,18.78,18.19,18.88,18.62,15.53,12.38,11.88,11.66,8.94,5.91,4.62,4.53,2.69,0.16,-0.06,1.41,2.09,1.47,1.38,3.47,5.41,5.38,5.72,8.25,11.5,12.5,12.69,14.19,15.78,15.09,13.12,13.0,15.31,17.0,17.56,18.22,20.81,22.5,21.56,20.25,21.06,22.12,21.03,19.12,18.84,19.94,19.12,16.94,15.88,16.75,17.09,16.06,15.31,17.25,18.75,17.94,16.94,18.56,20.81,21.19,20.84,22.44,25.16,26.19,25.75,26.28,28.06,28.88,27.16,25.69,26.38,26.62,24.78,22.31,22.28,22.78,21.25,19.03,19.12,20.88,21.47,20.56,20.84,22.5,22.84,21.5,20.38,21.41,22.28,21.19,19.75,20.91,23.22,24.25,24.28,25.75,28.06,27.84,25.25,23.12,23.09,22.06,19.5,17.28,17.47,17.84,16.38,14.41,15.25,16.91,17.0,16.28,17.34,19.62,20.78,20.0,20.0,21.72,23.38,22.91,22.31,23.88,24.91,23.69,21.09,19.91,19.22,17.03,13.47,11.59,12.19,11.78,10.69,11.0,14.06,17.0,18.47,19.78,23.59,27.72,29.59,29.75,30.81,32.16,30.69,27.84,26.62,27.28,27.34,25.75,25.03,25.97,26.12,24.16,22.28,22.72,23.69,23.16,22.31,23.28,25.22,25.88,25.25,25.81,28.0,29.5,28.78,28.84,30.5,32.12,31.88,31.06,32.66,34.47,34.5,33.5,34.25,35.75,35.72,33.84,33.12,34.28,34.5,33.25,32.06,32.44,32.16,30.06,27.72,27.81,28.84,28.28,26.81,27.5,28.94,29.06,27.34,26.41,27.19,27.5,25.69,24.59,25.81,27.28,26.81,26.41,28.28,30.47,30.38,28.5,27.94,28.03,27.28,25.25,24.5,26.03,27.22,26.91,26.78,28.84,31.0,30.66,29.53,29.47,29.72,28.44,26.22,25.66,27.06,27.22,25.53,24.34,24.88,24.81,22.69,20.81,21.41,22.38,21.28,19.81,20.31,21.38,20.97,19.0,18.53,19.56,20.0,18.5,18.25,19.94,21.03,19.81,18.72,19.59,21.19,21.09,20.91,22.28,24.19,24.31,22.66,21.69,22.0,21.75,19.97,19.91,22.38,24.88,25.28,25.19,26.59,28.0,27.0,25.25,25.12,26.31,25.94,23.84,22.84,23.16,22.69,20.0,17.84,18.12,18.53,16.91,15.31,16.0,17.22,16.72,15.72,17.16,20.0,21.44,21.12,21.84,24.16,25.44,24.5,23.84,25.03,25.34,23.69,21.12,20.84,21.19,19.38,16.44,15.31,16.0,16.38,16.25,17.75,21.84,25.56,26.81,28.56,31.88,35.09,35.03,33.81,33.16,32.25,28.75,24.16,21.97,21.41,20.62,18.91,18.81,20.56,22.78,23.12,24.06,26.66,28.94,28.47,26.56,26.5,27.06,26.91,25.38,25.06,25.84,25.19,22.41,20.72,21.22,22.0,21.19,20.62,22.0,23.22,21.72,19.22,18.16,18.38,17.47,15.84,16.31,19.25,21.62,22.5,23.5,25.91,27.5,26.06,24.19,24.31,24.69,22.34,19.28,18.19,18.41,17.78,16.44,16.72,19.16,20.88,20.59,20.59,21.59,22.06,20.03,17.84,17.97,18.91,18.59,17.66,19.47,22.66,24.59,25.12,25.91,27.88,28.5,26.53,24.59,24.44,24.06,21.22,18.06,17.12,17.31,16.31,15.16,16.34,19.12,20.94,21.25,22.31,24.28,25.69,24.84,24.28,24.84,25.53,23.72,21.34,21.28,21.5,19.75,17.12,16.34,16.94,17.12,16.16,16.38,18.5,19.94,19.19,18.22,18.75,19.12,17.06,14.5,14.0,14.84,15.03,15.03,16.91,20.41,22.44,22.34,21.94,22.84,23.09,21.06,19.22,19.34,19.88,17.97,15.5,15.25,16.25,16.06,15.19,15.88,18.25,19.34,18.19,17.38,17.84,17.47,14.62,12.12,12.06,13.12,12.19,11.12,11.5,12.41,12.09,10.69,10.75,12.84,14.44,13.78,13.97,15.41,16.16,14.09,12.06,11.38,11.22,9.0,6.34,5.97,6.91,6.94,5.84,6.56,9.31,11.53,11.94,13.28,16.66,19.72,20.25,19.91,21.12,22.56,21.41,18.97,17.84,17.47,15.5,11.62,9.34,8.44,6.97,3.59,1.5,1.94,2.88,2.41,2.25,4.53,7.94,9.59,10.25,12.78,16.5,18.91,19.62,20.97,23.59,25.06,23.5,21.5,20.59,19.28,16.06,12.88,11.44,11.31,9.22,5.56,2.41,0.31,-2.53,-6.09,-7.22,-5.47,-2.66,-1.12,1.53,6.66,12.41,16.12,19.16,23.47,27.31,28.25,27.06,25.53,24.75,22.69,18.97,16.5,16.38,16.5,14.25,11.28,10.16,9.19,5.81,2.5,1.56,2.66,2.88,3.38,5.78,10.5,14.28,16.0,18.03,20.88,22.97,22.44,21.34,21.72,23.03,22.5,21.22,21.41,22.25,20.94,17.62,14.5,13.16,10.94,7.81,5.75,6.34,7.69,7.19,7.09,9.22,11.69,12.19,11.72,12.38,13.25,12.66,10.41,8.91,9.38,9.31,7.81,7.16,8.72,10.19,9.94,8.84,9.66,11.0,10.41,8.69,8.09,9.16,8.75,7.12,6.38,8.09,9.12,7.81,6.81,7.41,7.97,6.28,4.34,4.75,6.34,6.59,6.38,7.25,9.47,9.56,7.53,6.59,7.38,8.34,7.72,7.78,10.38,13.88,15.31,15.97,18.5,21.16,21.56,20.41,20.41,21.62,21.69,20.19,18.81,19.12,18.66,16.16,13.47,12.41,12.31,10.19,8.16,8.34,10.38,11.28,11.25,12.75,15.81,17.5,16.94,55.22,54.25,54.06,54.62,54.56,53.38,52.53,52.59,52.5,51.09,49.81,49.47,49.66,49.19,48.5,49.22,50.84,51.84,51.72,52.19,52.69,52.72,51.0,48.88,48.38,47.56,45.81,44.38,44.12,44.12,43.12,41.47,41.22,42.44,43.38,43.44,44.38,45.66,46.19,45.09,44.34,45.12:negativity
17.75,18.56,20.91,25.38,28.34,28.19,26.72,26.19,24.75,21.28,17.28,15.5,14.62,12.44,9.0,7.19,7.69,7.41,5.66,5.31,7.16,9.03,8.81,8.91,10.78,12.72,12.81,12.03,13.09,15.03,14.84,12.44,10.69,10.38,9.19,6.75,5.47,6.91,8.72,8.69,8.75,11.38,14.66,16.12,15.62,16.5,17.91,16.97,13.78,11.34,10.72,10.0,7.88,6.97,9.56,12.06,12.19,11.31,11.66,12.03,9.91,6.56,4.75,4.53,3.47,0.75,-0.88,0.06,1.09,0.75,1.12,4.44,7.94,9.09,8.94,10.19,11.62,11.16,9.56,9.25,10.16,9.81,7.19,4.97,4.72,4.03,1.03,-2.38,-3.84,-5.5,-8.94,-12.16,-11.97,-9.28,-6.5,-4.44,-0.62,5.16,9.62,11.78,14.03,17.72,20.44,20.22,18.66,18.38,17.72,14.5,9.81,6.56,4.97,2.56,-0.84,-2.25,-1.44,-0.09,-0.28,0.59,4.44,8.16,9.16,8.62,9.5,10.16,9.09,6.19,4.78,4.41,2.75,-0.97,-3.41,-3.19,-3.19,-5.19,-6.81,-6.22,-5.25,-5.91,-6.75,-4.28,-0.31,3.12,5.31,8.59,13.06,15.53,15.12,14.34,14.69,14.28,10.69,6.22,3.47,1.34,-2.12,-5.62,-6.25,-4.62,-3.47,-3.53,-2.34,0.84,3.88,5.03,7.16,11.66,15.84,17.0,16.59,16.31,15.91,13.16,9.09,6.94,6.56,5.66,2.88,1.44,2.56,3.44,2.06,0.91,1.66,2.91,2.5,1.94,4.28,8.53,11.5,13.5,16.25,19.88,21.66,20.34,18.5,18.03,16.97,13.44,9.59,7.78,6.66,3.53,0.03,-1.53,-1.41,-1.47,-2.06,-0.12,4.47,9.12,12.22,15.88,21.03,24.75,25.0,23.88,23.25,22.41,19.47,15.94,14.78,15.69,16.09,15.84,16.62,18.94,19.97,18.0,15.44,14.72,14.88,13.66,13.03,14.94,17.84,18.59,17.75,16.66,16.06,13.66,9.0,4.88,3.53,2.84,0.81,-0.03,2.09,6.31,8.72,10.47,13.59,17.19,17.72,16.34,15.56,15.94,15.69,13.72,13.03,15.12,17.97,19.0,20.06,22.84,25.88,26.69,26.28,27.03,28.28,28.19,26.44,25.78,26.66,27.19,25.62,24.22,24.38,24.91,23.44,21.69,21.78,22.78,22.0,20.09,19.16,19.31,17.72,13.81,10.59,8.97,7.22,3.88,1.62,2.66,5.5,7.56,9.91,14.25,19.16,21.94,22.56,23.66,25.94,26.78,25.47,24.53,25.38,26.19,24.62,23.16,23.25,23.28,20.66,16.78,14.03,12.69,9.5,5.25,2.69,2.31,2.19,1.38,1.97,5.56,9.5,10.97,11.38,13.03,14.94,14.84,14.16,15.09,18.44,20.66,21.41,22.66,25.16,25.94,23.91,21.31,20.25,19.41,16.72,14.09,13.5,14.72,14.16,12.72,12.81,14.28,14.91,13.59,12.03,12.12,11.12,7.84,4.19,3.16,3.97,3.62,3.0,4.69,7.62,8.31,7.72,7.25,8.16,7.97,5.69,3.91,4.34,4.81,4.0,2.88,3.91,5.69,5.91,5.22,6.03,8.22,8.59,7.84,7.5,9.19,10.38,9.97,9.66,11.69,13.75,13.56,12.62,13.28,14.53,13.34,11.25,10.72,11.66,11.72,10.5,9.72,10.72,10.53,8.06,5.81,6.16,7.72,7.91,8.5,11.41,15.09,16.59,16.84,17.44,18.88,18.53,16.66,14.88,15.72,17.03,16.56,15.41,15.53,15.09,11.94,8.38,6.94,8.28,9.31,9.69,11.59,15.28,18.0,18.56,18.66,20.62,21.25,19.22,17.0,16.5,17.22,16.66,15.81,16.88,19.34,19.97,18.88,18.06,18.59,18.59,16.78,15.56,16.88,18.03,17.38,15.66,16.0,17.41,17.88,17.25,18.38,20.91,22.41,21.84,21.91,23.78,25.06,23.75,21.75,21.94,22.12,20.62,18.66,18.69,20.38,20.53,19.81,19.81,21.47,22.19,20.72,19.25,20.41,21.84,21.69,21.34,23.5,25.91,25.62,24.84,25.22,26.41,25.94,23.5,22.03,22.28,22.75,21.06,20.16,21.91,23.72,23.5,22.78,23.97,25.62,25.34,24.0,24.0,25.5,25.16,22.72,20.69,20.91,20.78,18.72,17.38,18.31,20.0,20.19,19.25,20.56,22.44,22.72,21.91,22.38,24.5,25.5,23.78,21.62,21.31,20.28,17.56,15.28,15.69,17.09,16.53,14.75,14.34,15.34,14.97,13.31,12.97,14.0,14.72,13.38,12.72,15.25,17.53,17.81,17.31,18.09,19.78,19.22,17.34,17.56,18.69,18.78,16.78,15.97,17.06,17.06,14.94,13.12,13.47,13.62,12.66,11.12,11.97,14.28,15.53,15.75,17.78,20.91,22.62,21.12,20.69,22.09,23.81,24.28,25.5,28.91,31.91,32.03,30.03,28.44,27.41,24.75,20.44,18.09,17.91,17.59,15.78,15.03,16.28,17.81,17.22,16.66,18.25,20.78,21.56,21.47,22.19,23.88,23.78,21.41,20.06,20.12,19.53,16.5,13.78,13.09,12.56,10.47,8.06,8.03,9.78,9.88,9.16,9.97,12.25,12.94,11.09,10.19,11.22,12.06,11.28,11.06,13.06,15.0,14.75,13.53,14.34,16.19,16.22,14.41,13.44,13.44,12.94,10.56,9.59,11.62,13.97,13.91,13.62,15.34,17.69,17.78,16.44,16.94,17.59,16.31,12.22,9.62,9.25,8.84,7.66,8.16,11.59,15.75,17.69,19.28,22.12,25.03,25.5,24.0,23.69,24.41,23.91,22.03,21.91,24.25,25.72,24.38,22.69,22.06,21.06,17.66,14.0,12.69,12.94,11.41,8.88,8.38,9.53,10.16,9.62,10.41,13.12,15.06,14.31,13.44,14.56,16.31,16.0,15.19,16.0,17.75,17.56,15.97,15.44,16.59,16.69,14.66,13.5,14.44,15.75,15.06,13.88,15.16,17.16,16.97,16.0,16.72,18.47,18.47,16.44,16.22,18.44,20.0,20.19,20.47,22.56,24.44,23.47,21.88,22.31,24.06,23.5,22.03,22.62,25.09,25.94,25.44,25.62,27.5,28.09,26.19,24.09,24.12,24.19,22.06,19.25,18.62,18.84,16.97,13.94,12.56,13.06,13.12,11.91,12.03,14.31,16.69,16.16,15.19,16.56,18.41,17.91,16.97,17.88,19.91,19.81,17.94,17.12,17.66,16.81,13.72,11.69,11.81,12.75,11.19,9.75,10.25,11.66,10.62,8.81,8.62,9.66,9.12,7.09,6.84,9.03,10.53,10.16,10.22,12.28,14.62,14.84,14.59,16.47,19.03,19.69,19.22,19.84,21.66,22.0,20.41,18.81,19.25,18.59,15.81,13.66,14.0,16.19,16.44,16.47,17.91,19.91,19.69,17.66,17.12,18.38,18.5,16.66,15.41,16.03,15.91,13.62,11.16,10.69,11.22,9.41,6.66,6.12,7.28,6.84,5.12,4.94,6.66,7.38,6.5,5.69,6.94,7.88,6.12,3.84,3.5,3.97,2.69,0.5,0.12,1.66,1.88,0.66,0.59,2.62,3.5,2.72,1.88,3.75,5.44,5.31,4.62,5.91,8.25,8.19,6.53,6.34,6.94,6.0,3.22,1.03,1.34,1.44,-0.25,-1.25,0.06,2.09,1.56,-0.09,-0.56,-0.16,-1.81,-4.69,-5.5,-3.59,-2.09,-1.69,0.16,4.19,7.09,6.94,5.59,5.81,6.0,4.5,2.09,2.12,3.72,3.53,1.97,1.5,3.69,4.78,3.94,3.69,6.0,8.0,7.69,6.28,6.91,8.09,7.25,5.34,5.47,7.62,8.09,7.12,6.84,8.84,10.19,9.22,7.97,9.0,10.34,9.78,8.66,9.94,11.94,12.28,11.16,11.31,13.09,13.38,11.78,10.88,12.38,13.34,12.25,10.84,12.09,13.16,12.59,11.19,11.75,13.22,12.75,9.88,7.97,7.44,5.59,2.41,-0.03,0.28,0.75,-0.38,-1.31,0.31,2.94,4.25,5.09,8.0,12.03,14.53,15.22,16.25,18.84,19.94,18.62,17.25,17.91,18.19,15.81,12.69,11.28,10.53,8.34,5.31,4.75,6.09,6.78,5.56,5.5,7.38,8.59,7.31,6.25,7.5,8.66,7.94,6.69,7.38,9.0,9.72,9.28,10.97,14.25,16.62,17.16,17.69,19.88,21.0,19.31,15.97,14.47,13.0,9.62,5.56,3.62,3.38,2.5,0.78,0.78,3.47,6.25,6.81,8.34,11.62,14.34,13.78,11.84,11.56,11.47,9.88,7.97,8.22,10.03,10.16,8.12,6.62,6.88,6.88,5.28,4.47,6.34,8.47,8.56,7.91,9.62,11.22,10.91,9.44,9.19,10.97,12.5,12.03,12.41,13.97,14.19,11.31,7.75,6.28,4.72,1.66,-1.31,-0.94,1.69,3.56,4.88,7.62,11.66,14.12,14.5,15.16,18.0,20.5,20.44,19.44,20.03,20.53,18.28,15.25,13.88,13.75,12.88,11.0,10.97,13.53,15.91,16.44,17.62,20.75,24.19,25.12,25.22,26.81,28.31,26.47,22.16,18.72,15.28,9.88,2.78,-3.09,-6.28,-8.0,-10.34,-10.75,-8.12,-4.72,-3.06,-2.22,0.31,3.59,4.78,4.19,5.28,8.06,10.62,11.75,14.25,18.72,22.28,23.03,22.62,23.16,23.19,20.09,15.31,12.22,10.66,8.56,6.16,6.16,8.56,10.94,11.47,12.84,16.22,19.75,21.16,22.0,24.38,26.5,25.75,22.41,19.56,17.12,13.34,8.47,5.78,6.0,6.81,6.22,6.81,10.03,13.75,15.47,16.62,19.03,21.81,22.16,20.88,21.06,22.22,21.78,19.56,17.5,17.41,17.47,15.34,13.62,14.0:26.19,24.75,21.28,17.28,15.5,14.62,12.44,9.0,7.19,7.69,7.41,5.66,5.31,7.16,9.03,8.81,8.91,10.78,12.72,12.81,12.03,13.09,15.03,14.84,12.44,10.69,10.38,9.19,6.75,5.47,6.91,8.72,8.69,8.75,11.38,14.66,16.12,15.62,16.5,17.91,16.97,13.78,11.34,10.72,10.0,7.88,6.97,9.56,12.06,12.19,11.31,11.66,12.03,9.91,6.56,4.75,4.53,3.47,0.75,-0.88,0.06,1.09,0.75,1.12,4.44,7.94,9.09,8.94,10.19,11.62,11.16,9.56,9.25,10.16,9.81,7.19,4.97,4.72,4.03,1.03,-2.38,-3.84,-5.5,-8.94,-12.16,-11.97,-9.28,-6.5,-4.44,-0.62,5.16,9.62,11.78,14.03,17.72,20.44,20.22,18.66,18.38,17.72,14.5,9.81,6.56,4.97,2.56,-0.84,-2.25,-1.44,-0.09,-0.28,0.59,4.44,8.16,9.16,8.62,9.5,10.16,9.09,6.19,4.78,4.41,2.75,-0.97,-3.41,-3.19,-3.19,-5.19,-6.81,-6.22,-5.25,-5.91,-6.75,-4.28,-0.31,3.12,5.31,8.59,13.06,15.53,15.12,14.34,14.69,14.28,10.69,6.22,3.47,1.34,-2.12,-5.62,-6.25,-4.62,-3.47,-3.53,-2.34,0.84,3.88,5.03,7.16,11.66,15.84,17.0,16.59,16.31,15.91,13.16,9.09,6.94,6.56,5.66,2.88,1.44,2.56,3.44,2.06,0.91,1.66,2.91,2.5,1.94,4.28,8.53,11.5,13.5,16.25,19.88,21.66,20.34,18.5,18.03,16.97,13.44,9.59,7.78,6.66,3.53,0.03,-1.53,-1.41,-1.47,-2.06,-0.12,4.47,9.12,12.22,15.88,21.03,24.75,25.0,23.88,23.25,22.41,19.47,15.94,14.78,15.69,16.09,15.84,16.62,18.94,19.97,18.0,15.44,14.72,14.88,13.66,13.03,14.94,17.84,18.59,17.75,16.66,16.06,13.66,9.0,4.88,3.53,2.84,0.81,-0.03,2.09,6.31,8.72,10.47,13.59,17.19,17.72,16.34,15.56,15.94,15.69,13.72,13.03,15.12,17.97,19.0,20.06,22.84,25.88,26.69,26.28,27.03,28.28,28.19,26.44,25.78,26.66,27.19,25.62,24.22,24.38,24.91,23.44,21.69,21.78,22.78,22.0,20.09,19.16,19.31,17.72,13.81,10.59,8.97,7.22,3.88,1.62,2.66,5.5,7.56,9.91,14.25,19.16,21.94,22.56,23.66,25.94,26.78,25.47,24.53,25.38,26.19,24.62,23.16,23.25,23.28,20.66,16.78,14.03,12.69,9.5,5.25,2.69,2.31,2.19,1.38,1.97,5.56,9.5,10.97,11.38,13.03,14.94,14.84,14.16,15.09,18.44,20.66,21.41,22.66,25.16,25.94,23.91,21.31,20.25,19.41,16.72,14.09,13.5,14.72,14.16,12.72,12.81,14.28,14.91,13.59,12.03,12.12,11.12,7.84,4.19,3.16,3.97,3.62,3.0,4.69,7.62,8.31,7.72,7.25,8.16,7.97,5.69,3.91,4.34,4.81,4.0,2.88,3.91,5.69,5.91,5.22,6.03,8.22,8.59,7.84,7.5,9.19,10.38,9.97,9.66,11.69,13.75,13.56,12.62,13.28,14.53,13.34,11.25,10.72,11.66,11.72,10.5,9.72,10.72,10.53,8.06,5.81,6.16,7.72,7.91,8.5,11.41,15.09,16.59,16.84,17.44,18.88,18.53,16.66,14.88,15.72,17.03,16.56,15.41,15.53,15.09,11.94,8.38,6.94,8.28,9.31,9.69,11.59,15.28,18.0,18.56,18.66,20.62,21.25,19.22,17.0,16.5,17.22,16.66,15.81,16.88,19.34,19.97,18.88,18.06,18.59,18.59,16.78,15.56,16.88,18.03,17.38,15.66,16.0,17.41,17.88,17.25,18.38,20.91,22.41,21.84,21.91,23.78,25.06,23.75,21.75,21.94,22.12,20.62,18.66,18.69,20.38,20.53,19.81,19.81,21.47,22.19,20.72,19.25,20.41,21.84,21.69,21.34,23.5,25.91,25.62,24.84,25.22,26.41,25.94,23.5,22.03,22.28,22.75,21.06,20.16,21.91,23.72,23.5,22.78,23.97,25.62,25.34,24.0,24.0,25.5,25.16,22.72,20.69,20.91,20.78,18.72,17.38,18.31,20.0,20.19,19.25,20.56,22.44,22.72,21.91,22.38,24.5,25.5,23.78,21.62,21.31,20.28,17.56,15.28,15.69,17.09,16.53,14.75,14.34,15.34,14.97,13.31,12.97,14.0,14.72,13.38,12.72,15.25,17.53,17.81,17.31,18.09,19.78,19.22,17.34,17.56,18.69,18.78,16.78,15.97,17.06,17.06,14.94,13.12,13.47,13.62,12.66,11.12,11.97,14.28,15.53,15.75,17.78,20.91,22.62,21.12,20.69,22.09,23.81,24.28,25.5,28.91,31.91,32.03,30.03,28.44,27.41,24.75,20.44,18.09,17.91,17.59,15.78,15.03,16.28,17.81,17.22,16.66,18.25,20.78,21.56,21.47,22.19,23.88,23.78,21.41,20.06,20.12,19.53,16.5,13.78,13.09,12.56,10.47,8.06,8.03,9.78,9.88,9.16,9.97,12.25,12.94,11.09,10.19,11.22,12.06,11.28,11.06,13.06,15.0,14.75,13.53,14.34,16.19,16.22,14.41,13.44,13.44,12.94,10.56,9.59,11.62,13.97,13.91,13.62,15.34,17.69,17.78,16.44,16.94,17.59,16.31,12.22,9.62,9.25,8.84,7.66,8.16,11.59,15.75,17.69,19.28,22.12,25.03,25.5,24.0,23.69,24.41,23.91,22.03,21.91,24.25,25.72,24.38,22.69,22.06,21.06,17.66,14.0,12.69,12.94,11.41,8.88,8.38,9.53,10.16,9.62,10.41,13.12,15.06,14.31,13.44,14.56,16.31,16.0,15.19,16.0,17.75,17.56,15.97,15.44,16.59,16.69,14.66,13.5,14.44,15.75,15.06,13.88,15.16,17.16,16.97,16.0,16.72,18.47,18.47,16.44,16.22,18.44,20.0,20.19,20.47,22.56,24.44,23.47,21.88,22.31,24.06,23.5,22.03,22.62,25.09,25.94,25.44,25.62,27.5,28.09,26.19,24.09,24.12,24.19,22.06,19.25,18.62,18.84,16.97,13.94,12.56,13.06,13.12,11.91,12.03,14.31,16.69,16.16,15.19,16.56,18.41,17.91,16.97,17.88,19.91,19.81,17.94,17.12,17.66,16.81,13.72,11.69,11.81,12.75,11.19,9.75,10.25,11.66,10.62,8.81,8.62,9.66,9.12,7.09,6.84,9.03,10.53,10.16,10.22,12.28,14.62,14.84,14.59,16.47,19.03,19.69,19.22,19.84,21.66,22.0,20.41,18.81,19.25,18.59,15.81,13.66,14.0,16.19,16.44,16.47,17.91,19.91,19.69,17.66,17.12,18.38,18.5,16.66,15.41,16.03,15.91,13.62,11.16,10.69,11.22,9.41,6.66,6.12,7.28,6.84,5.12,4.94,6.66,7.38,6.5,5.69,6.94,7.88,6.12,3.84,3.5,3.97,2.69,0.5,0.12,1.66,1.88,0.66,0.59,2.62,3.5,2.72,1.88,3.75,5.44,5.31,4.62,5.91,8.25,8.19,6.53,6.34,6.94,6.0,3.22,1.03,1.34,1.44,-0.25,-1.25,0.06,2.09,1.56,-0.09,-0.56,-0.16,-1.81,-4.69,-5.5,-3.59,-2.09,-1.69,0.16,4.19,7.09,6.94,5.59,5.81,6.0,4.5,2.09,2.12,3.72,3.53,1.97,1.5,3.69,4.78,3.94,3.69,6.0,8.0,7.69,6.28,6.91,8.09,7.25,5.34,5.47,7.62,8.09,7.12,6.84,8.84,10.19,9.22,7.97,9.0,10.34,9.78,8.66,9.94,11.94,12.28,11.16,11.31,13.09,13.38,11.78,10.88,12.38,13.34,12.25,10.84,12.09,13.16,12.59,11.19,11.75,13.22,12.75,9.88,7.97,7.44,5.59,2.41,-0.03,0.28,0.75,-0.38,-1.31,0.31,2.94,4.25,5.09,8.0,12.03,14.53,15.22,16.25,18.84,19.94,18.62,17.25,17.91,18.19,15.81,12.69,11.28,10.53,8.34,5.31,4.75,6.09,6.78,5.56,5.5,7.38,8.59,7.31,6.25,7.5,8.66,7.94,6.69,7.38,9.0,9.72,9.28,10.97,14.25,16.62,17.16,17.69,19.88,21.0,19.31,15.97,14.47,13.0,9.62,5.56,3.62,3.38,2.5,0.78,0.78,3.47,6.25,6.81,8.34,11.62,14.34,13.78,11.84,11.56,11.47,9.88,7.97,8.22,10.03,10.16,8.12,6.62,6.88,6.88,5.28,4.47,6.34,8.47,8.56,7.91,9.62,11.22,10.91,9.44,9.19,10.97,12.5,12.03,12.41,13.97,14.19,11.31,7.75,6.28,4.72,1.66,-1.31,-0.94,1.69,3.56,4.88,7.62,11.66,14.12,14.5,15.16,18.0,20.5,20.44,19.44,20.03,20.53,18.28,15.25,13.88,13.75,12.88,11.0,10.97,13.53,15.91,16.44,17.62,20.75,24.19,25.12,25.22,26.81,28.31,26.47,22.16,18.72,15.28,9.88,2.78,-3.09,-6.28,-8.0,-10.34,-10.75,-8.12,-4.72,-3.06,-2.22,0.31,3.59,4.78,4.19,5.28,8.06,10.62,11.75,14.25,18.72,22.28,23.03,22.62,23.16,23.19,20.09,15.31,12.22,10.66,8.56,6.16,6.16,8.56,10.94,11.47,12.84,16.22,19.75,21.16,22.0,24.38,26.5,25.75,22.41,19.56,17.12,13.34,8.47,5.78,6.0,6.81,6.22,6.81,10.03,13.75,15.47,16.62,19.03,21.81,22.16,20.88,21.06,22.22,21.78,19.56,17.5,17.41,17.47,15.34,13.62,14.0,23.0,23.5,24.81,26.66,27.12,25.47,23.0:9.0,7.19,7.69,7.41,5.66,5.31,7.16,9.03,8.81,8.91,10.78,12.72,12.81,12.03,13.09,15.03,14.84,12.44,10.69,10.38,9.19,6.75,5.47,6.91,8.72,8.69,8.75,11.38,14.66,16.12,15.62,16.5,17.91,16.97,13.78,11.34,10.72,10.0,7.88,6.97,9.56,12.06,12.19,11.31,11.66,12.03,9.91,6.56,4.75,4.53,3.47,0.75,-0.88,0.06,1.09,0.75,1.12,4.44,7.94,9.09,8.94,10.19,11.62,11.16,9.56,9.25,10.16,9.81,7.19,4.97,4.72,4.03,1.03,-2.38,-3.84,-5.5,-8.94,-12.16,-11.97,-9.28,-6.5,-4.44,-0.62,5.16,9.62,11.78,14.03,17.72,20.44,20.22,18.66,18.38,17.72,14.5,9.81,6.56,4.97,2.56,-0.84,-2.25,-1.44,-0.09,-0.28,0.59,4.44,8.16,9.16,8.62,9.5,10.16,9.09,6.19,4.78,4.41,2.75,-0.97,-3.41,-3.19,-3.19,-5.19,-6.81,-6.22,-5.25,-5.91,-6.75,-4.28,-0.31,3.12,5.31,8.59,13.06,15.53,15.12,14.34,14.69,14.28,10.69,6.22,3.47,1.34,-2.12,-5.62,-6.25,-4.62,-3.47,-3.53,-2.34,0.84,3.88,5.03,7.16,11.66,15.84,17.0,16.59,16.31,15.91,13.16,9.09,6.94,6.56,5.66,2.88,1.44,2.56,3.44,2.06,0.91,1.66,2.91,2.5,1.94,4.28,8.53,11.5,13.5,16.25,19.88,21.66,20.34,18.5,18.03,16.97,13.44,9.59,7.78,6.66,3.53,0.03,-1.53,-1.41,-1.47,-2.06,-0.12,4.47,9.12,12.22,15.88,21.03,24.75,25.0,23.88,23.25,22.41,19.47,15.94,14.78,15.69,16.09,15.84,16.62,18.94,19.97,18.0,15.44,14.72,14.88,13.66,13.03,14.94,17.84,18.59,17.75,16.66,16.06,13.66,9.0,4.88,3.53,2.84,0.81,-0.03,2.09,6.31,8.72,10.47,13.59,17.19,17.72,16.34,15.56,15.94,15.69,13.72,13.03,15.12,17.97,19.0,20.06,22.84,25.88,26.69,26.28,27.03,28.28,28.19,26.44,25.78,26.66,27.19,25.62,24.22,24.38,24.91,23.44,21.69,21.78,22.78,22.0,20.09,19.16,19.31,17.72,13.81,10.59,8.97,7.22,3.88,1.62,2.66,5.5,7.56,9.91,14.25,19.16,21.94,22.56,23.66,25.94,26.78,25.47,24.53,25.38,26.19,24.62,23.16,23.25,23.28,20.66,16.78,14.03,12.69,9.5,5.25,2.69,2.31,2.19,1.38,1.97,5.56,9.5,10.97,11.38,13.03,14.94,14.84,14.16,15.09,18.44,20.66,21.41,22.66,25.16,25.94,23.91,21.31,20.25,19.41,16.72,14.09,13.5,14.72,14.16,12.72,12.81,14.28,14.91,13.59,12.03,12.12,11.12,7.84,4.19,3.16,3.97,3.62,3.0,4.69,7.62,8.31,7.72,7.25,8.16,7.97,5.69,3.91,4.34,4.81,4.0,2.88,3.91,5.69,5.91,5.22,6.03,8.22,8.59,7.84,7.5,9.19,10.38,9.97,9.66,11.69,13.75,13.56,12.62,13.28,14.53,13.34,11.25,10.72,11.66,11.72,10.5,9.72,10.72,10.53,8.06,5.81,6.16,7.72,7.91,8.5,11.41,15.09,16.59,16.84,17.44,18.88,18.53,16.66,14.88,15.72,17.03,16.56,15.41,15.53,15.09,11.94,8.38,6.94,8.28,9.31,9.69,11.59,15.28,18.0,18.56,18.66,20.62,21.25,19.22,17.0,16.5,17.22,16.66,15.81,16.88,19.34,19.97,18.88,18.06,18.59,18.59,16.78,15.56,16.88,18.03,17.38,15.66,16.0,17.41,17.88,17.25,18.38,20.91,22.41,21.84,21.91,23.78,25.06,23.75,21.75,21.94,22.12,20.62,18.66,18.69,20.38,20.53,19.81,19.81,21.47,22.19,20.72,19.25,20.41,21.84,21.69,21.34,23.5,25.91,25.62,24.84,25.22,26.41,25.94,23.5,22.03,22.28,22.75,21.06,20.16,21.91,23.72,23.5,22.78,23.97,25.62,25.34,24.0,24.0,25.5,25.16,22.72,20.69,20.91,20.78,18.72,17.38,18.31,20.0,20.19,19.25,20.56,22.44,22.72,21.91,22.38,24.5,25.5,23.78,21.62,21.31,20.28,17.56,15.28,15.69,17.09,16.53,14.75,14.34,15.34,14.97,13.31,12.97,14.0,14.72,13.38,12.72,15.25,17.53,17.81,17.31,18.09,19.78,19.22,17.34,17.56,18.69,18.78,16.78,15.97,17.06,17.06,14.94,13.12,13.47,13.62,12.66,11.12,11.97,14.28,15.53,15.75,17.78,20.91,22.62,21.12,20.69,22.09,23.81,24.28,25.5,28.91,31.91,32.03,30.03,28.44,27.41,24.75,20.44,18.09,17.91,17.59,15.78,15.03,16.28,17.81,17.22,16.66,18.25,20.78,21.56,21.47,22.19,23.88,23.78,21.41,20.06,20.12,19.53,16.5,13.78,13.09,12.56,10.47,8.06,8.03,9.78,9.88,9.16,9.97,12.25,12.94,11.09,10.19,11.22,12.06,11.28,11.06,13.06,15.0,14.75,13.53,14.34,16.19,16.22,14.41,13.44,13.44,12.94,10.56,9.59,11.62,13.97,13.91,13.62,15.34,17.69,17.78,16.44,16.94,17.59,16.31,12.22,9.62,9.25,8.84,7.66,8.16,11.59,15.75,17.69,19.28,22.12,25.03,25.5,24.0,23.69,24.41,23.91,22.03,21.91,24.25,25.72,24.38,22.69,22.06,21.06,17.66,14.0,12.69,12.94,11.41,8.88,8.38,9.53,10.16,9.62,10.41,13.12,15.06,14.31,13.44,14.56,16.31,16.0,15.19,16.0,17.75,17.56,15.97,15.44,16.59,16.69,14.66,13.5,14.44,15.75,15.06,13.88,15.16,17.16,16.97,16.0,16.72,18.47,18.47,16.44,16.22,18.44,20.0,20.19,20.47,22.56,24.44,23.47,21.88,22.31,24.06,23.5,22.03,22.62,25.09,25.94,25.44,25.62,27.5,28.09,26.19,24.09,24.12,24.19,22.06,19.25,18.62,18.84,16.97,13.94,12.56,13.06,13.12,11.91,12.03,14.31,16.69,16.16,15.19,16.56,18.41,17.91,16.97,17.88,19.91,19.81,17.94,17.12,17.66,16.81,13.72,11.69,11.81,12.75,11.19,9.75,10.25,11.66,10.62,8.81,8.62,9.66,9.12,7.09,6.84,9.03,10.53,10.16,10.22,12.28,14.62,14.84,14.59,16.47,19.03,19.69,19.22,19.84,21.66,22.0,20.41,18.81,19.25,18.59,15.81,13.66,14.0,16.19,16.44,16.47,17.91,19.91,19.69,17.66,17.12,18.38,18.5,16.66,15.41,16.03,15.91,13.62,11.16,10.69,11.22,9.41,6.66,6.12,7.28,6.84,5.12,4.94,6.66,7.38,6.5,5.69,6.94,7.88,6.12,3.84,3.5,3.97,2.69,0.5,0.12,1.66,1.88,0.66,0.59,2.62,3.5,2.72,1.88,3.75,5.44,5.31,4.62,5.91,8.25,8.19,6.53,6.34,6.94,6.0,3.22,1.03,1.34,1.44,-0.25,-1.25,0.06,2.09,1.56,-0.09,-0.56,-0.16,-1.81,-4.69,-5.5,-3.59,-2.09,-1.69,0.16,4.19,7.09,6.94,5.59,5.81,6.0,4.5,2.09,2.12,3.72,3.53,1.97,1.5,3.69,4.78,3.94,3.69,6.0,8.0,7.69,6.28,6.91,8.09,7.25,5.34,5.47,7.62,8.09,7.12,6.84,8.84,10.19,9.22,7.97,9.0,10.34,9.78,8.66,9.94,11.94,12.28,11.16,11.31,13.09,13.38,11.78,10.88,12.38,13.34,12.25,10.84,12.09,13.16,12.59,11.19,11.75,13.22,12.75,9.88,7.97,7.44,5.59,2.41,-0.03,0.28,0.75,-0.38,-1.31,0.31,2.94,4.25,5.09,8.0,12.03,14.53,15.22,16.25,18.84,19.94,18.62,17.25,17.91,18.19,15.81,12.69,11.28,10.53,8.34,5.31,4.75,6.09,6.78,5.56,5.5,7.38,8.59,7.31,6.25,7.5,8.66,7.94,6.69,7.38,9.0,9.72,9.28,10.97,14.25,16.62,17.16,17.69,19.88,21.0,19.31,15.97,14.47,13.0,9.62,5.56,3.62,3.38,2.5,0.78,0.78,3.47,6.25,6.81,8.34,11.62,14.34,13.78,11.84,11.56,11.47,9.88,7.97,8.22,10.03,10.16,8.12,6.62,6.88,6.88,5.28,4.47,6.34,8.47,8.56,7.91,9.62,11.22,10.91,9.44,9.19,10.97,12.5,12.03,12.41,13.97,14.19,11.31,7.75,6.28,4.72,1.66,-1.31,-0.94,1.69,3.56,4.88,7.62,11.66,14.12,14.5,15.16,18.0,20.5,20.44,19.44,20.03,20.53,18.28,15.25,13.88,13.75,12.88,11.0,10.97,13.53,15.91,16.44,17.62,20.75,24.19,25.12,25.22,26.81,28.31,26.47,22.16,18.72,15.28,9.88,2.78,-3.09,-6.28,-8.0,-10.34,-10.75,-8.12,-4.72,-3.06,-2.22,0.31,3.59,4.78,4.19,5.28,8.06,10.62,11.75,14.25,18.72,22.28,23.03,22.62,23.16,23.19,20.09,15.31,12.22,10.66,8.56,6.16,6.16,8.56,10.94,11.47,12.84,16.22,19.75,21.16,22.0,24.38,26.5,25.75,22.41,19.56,17.12,13.34,8.47,5.78,6.0,6.81,6.22,6.81,10.03,13.75,15.47,16.62,19.03,21.81,22.16,20.88,21.06,22.22,21.78,19.56,17.5,17.41,17.47,15.34,13.62,14.0,23.0,23.5,24.81,26.66,27.12,25.47,23.0,21.25,18.69,15.47,12.72,12.19,12.44,12.16:9.03,8.81,8.91,10.78,12.72,12.81,12.03,13.09,15.03,14.84,12.44,10.69,10.38,9.19,6.75,5.47,6.91,8.72,8.69,8.75,11.38,14.66,16.12,15.62,16.5,17.91,16.97,13.78,11.34,10.72,10.0,7.88,6.97,9.56,12.06,12.19,11.31,11.66,12.03,9.91,6.56,4.75,4.53,3.47,0.75,-0.88,0.06,1.09,0.75,1.12,4.44,7.94,9.09,8.94,10.19,11.62,11.16,9.56,9.25,10.16,9.81,7.19,4.97,4.72,4.03,1.03,-2.38,-3.84,-5.5,-8.94,-12.16,-11.97,-9.28,-6.5,-4.44,-0.62,5.16,9.62,11.78,14.03,17.72,20.44,20.22,18.66,18.38,17.72,14.5,9.81,6.56,4.97,2.56,-0.84,-2.25,-1.44,-0.09,-0.28,0.59,4.44,8.16,9.16,8.62,9.5,10.16,9.09,6.19,4.78,4.41,2.75,-0.97,-3.41,-3.19,-3.19,-5.19,-6.81,-6.22,-5.25,-5.91,-6.75,-4.28,-0.31,3.12,5.31,8.59,13.06,15.53,15.12,14.34,14.69,14.28,10.69,6.22,3.47,1.34,-2.12,-5.62,-6.25,-4.62,-3.47,-3.53,-2.34,0.84,3.88,5.03,7.16,11.66,15.84,17.0,16.59,16.31,15.91,13.16,9.09,6.94,6.56,5.66,2.88,1.44,2.56,3.44,2.06,0.91,1.66,2.91,2.5,1.94,4.28,8.53,11.5,13.5,16.25,19.88,21.66,20.34,18.5,18.03,16.97,13.44,9.59,7.78,6.66,3.53,0.03,-1.53,-1.41,-1.47,-2.06,-0.12,4.47,9.12,12.22,15.88,21.03,24.75,25.0,23.88,23.25,22.41,19.47,15.94,14.78,15.69,16.09,15.84,16.62,18.94,19.97,18.0,15.44,14.72,14.88,13.66,13.03,14.94,17.84,18.59,17.75,16.66,16.06,13.66,9.0,4.88,3.53,2.84,0.81,-0.03,2.09,6.31,8.72,10.47,13.59,17.19,17.72,16.34,15.56,15.94,15.69,13.72,13.03,15.12,17.97,19.0,20.06,22.84,25.88,26.69,26.28,27.03,28.28,28.19,26.44,25.78,26.66,27.19,25.62,24.22,24.38,24.91,23.44,21.69,21.78,22.78,22.0,20.09,19.16,19.31,17.72,13.81,10.59,8.97,7.22,3.88,1.62,2.66,5.5,7.56,9.91,14.25,19.16,21.94,22.56,23.66,25.94,26.78,25.47,24.53,25.38,26.19,24.62,23.16,23.25,23.28,20.66,16.78,14.03,12.69,9.5,5.25,2.69,2.31,2.19,1.38,1.97,5.56,9.5,10.97,11.38,13.03,14.94,14.84,14.16,15.09,18.44,20.66,21.41,22.66,25.16,25.94,23.91,21.31,20.25,19.41,16.72,14.09,13.5,14.72,14.16,12.72,12.81,14.28,14.91,13.59,12.03,12.12,11.12,7.84,4.19,3.16,3.97,3.62,3.0,4.69,7.62,8.31,7.72,7.25,8.16,7.97,5.69,3.91,4.34,4.81,4.0,2.88,3.91,5.69,5.91,5.22,6.03,8.22,8.59,7.84,7.5,9.19,10.38,9.97,9.66,11.69,13.75,13.56,12.62,13.28,14.53,13.34,11.25,10.72,11.66,11.72,10.5,9.72,10.72,10.53,8.06,5.81,6.16,7.72,7.91,8.5,11.41,15.09,16.59,16.84,17.44,18.88,18.53,16.66,14.88,15.72,17.03,16.56,15.41,15.53,15.09,11.94,8.38,6.94,8.28,9.31,9.69,11.59,15.28,18.0,18.56,18.66,20.62,21.25,19.22,17.0,16.5,17.22,16.66,15.81,16.88,19.34,19.97,18.88,18.06,18.59,18.59,16.78,15.56,16.88,18.03,17.38,15.66,16.0,17.41,17.88,17.25,18.38,20.91,22.41,21.84,21.91,23.78,25.06,23.75,21.75,21.94,22.12,20.62,18.66,18.69,20.38,20.53,19.81,19.81,21.47,22.19,20.72,19.25,20.41,21.84,21.69,21.34,23.5,25.91,25.62,24.84,25.22,26.41,25.94,23.5,22.03,22.28,22.75,21.06,20.16,21.91,23.72,23.5,22.78,23.97,25.62,25.34,24.0,24.0,25.5,25.16,22.72,20.69,20.91,20.78,18.72,17.38,18.31,20.0,20.19,19.25,20.56,22.44,22.72,21.91,22.38,24.5,25.5,23.78,21.62,21.31,20.28,17.56,15.28,15.69,17.09,16.53,14.75,14.34,15.34,14.97,13.31,12.97,14.0,14.72,13.38,12.72,15.25,17.53,17.81,17.31,18.09,19.78,19.22,17.34,17.56,18.69,18.78,16.78,15.97,17.06,17.06,14.94,13.12,13.47,13.62,12.66,11.12,11.97,14.28,15.53,15.75,17.78,20.91,22.62,21.12,20.69,22.09,23.81,24.28,25.5,28.91,31.91,32.03,30.03,28.44,27.41,24.75,20.44,18.09,17.91,17.59,15.78,15.03,16.28,17.81,17.22,16.66,18.25,20.78,21.56,21.47,22.19,23.88,23.78,21.41,20.06,20.12,19.53,16.5,13.78,13.09,12.56,10.47,8.06,8.03,9.78,9.88,9.16,9.97,12.25,12.94,11.09,10.19,11.22,12.06,11.28,11.06,13.06,15.0,14.75,13.53,14.34,16.19,16.22,14.41,13.44,13.44,12.94,10.56,9.59,11.62,13.97,13.91,13.62,15.34,17.69,17.78,16.44,16.94,17.59,16.31,12.22,9.62,9.25,8.84,7.66,8.16,11.59,15.75,17.69,19.28,22.12,25.03,25.5,24.0,23.69,24.41,23.91,22.03,21.91,24.25,25.72,24.38,22.69,22.06,21.06,17.66,14.0,12.69,12.94,11.41,8.88,8.38,9.53,10.16,9.62,10.41,13.12,15.06,14.31,13.44,14.56,16.31,16.0,15.19,16.0,17.75,17.56,15.97,15.44,16.59,16.69,14.66,13.5,14.44,15.75,15.06,13.88,15.16,17.16,16.97,16.0,16.72,18.47,18.47,16.44,16.22,18.44,20.0,20.19,20.47,22.56,24.44,23.47,21.88,22.31,24.06,23.5,22.03,22.62,25.09,25.94,25.44,25.62,27.5,28.09,26.19,24.09,24.12,24.19,22.06,19.25,18.62,18.84,16.97,13.94,12.56,13.06,13.12,11.91,12.03,14.31,16.69,16.16,15.19,16.56,18.41,17.91,16.97,17.88,19.91,19.81,17.94,17.12,17.66,16.81,13.72,11.69,11.81,12.75,11.19,9.75,10.25,11.66,10.62,8.81,8.62,9.66,9.12,7.09,6.84,9.03,10.53,10.16,10.22,12.28,14.62,14.84,14.59,16.47,19.03,19.69,19.22,19.84,21.66,22.0,20.41,18.81,19.25,18.59,15.81,13.66,14.0,16.19,16.44,16.47,17.91,19.91,19.69,17.66,17.12,18.38,18.5,16.66,15.41,16.03,15.91,13.62,11.16,10.69,11.22,9.41,6.66,6.12,7.28,6.84,5.12,4.94,6.66,7.38,6.5,5.69,6.94,7.88,6.12,3.84,3.5,3.97,2.69,0.5,0.12,1.66,1.88,0.66,0.59,2.62,3.5,2.72,1.88,3.75,5.44,5.31,4.62,5.91,8.25,8.19,6.53,6.34,6.94,6.0,3.22,1.03,1.34,1.44,-0.25,-1.25,0.06,2.09,1.56,-0.09,-0.56,-0.16,-1.81,-4.69,-5.5,-3.59,-2.09,-1.69,0.16,4.19,7.09,6.94,5.59,5.81,6.0,4.5,2.09,2.12,3.72,3.53,1.97,1.5,3.69,4.78,3.94,3.69,6.0,8.0,7.69,6.28,6.91,8.09,7.25,5.34,5.47,7.62,8.09,7.12,6.84,8.84,10.19,9.22,7.97,9.0,10.34,9.78,8.66,9.94,11.94,12.28,11.16,11.31,13.09,13.38,11.78,10.88,12.38,13.34,12.25,10.84,12.09,13.16,12.59,11.19,11.75,13.22,12.75,9.88,7.97,7.44,5.59,2.41,-0.03,0.28,0.75,-0.38,-1.31,0.31,2.94,4.25,5.09,8.0,12.03,14.53,15.22,16.25,18.84,19.94,18.62,17.25,17.91,18.19,15.81,12.69,11.28,10.53,8.34,5.31,4.75,6.09,6.78,5.56,5.5,7.38,8.59,7.31,6.25,7.5,8.66,7.94,6.69,7.38,9.0,9.72,9.28,10.97,14.25,16.62,17.16,17.69,19.88,21.0,19.31,15.97,14.47,13.0,9.62,5.56,3.62,3.38,2.5,0.78,0.78,3.47,6.25,6.81,8.34,11.62,14.34,13.78,11.84,11.56,11.47,9.88,7.97,8.22,10.03,10.16,8.12,6.62,6.88,6.88,5.28,4.47,6.34,8.47,8.56,7.91,9.62,11.22,10.91,9.44,9.19,10.97,12.5,12.03,12.41,13.97,14.19,11.31,7.75,6.28,4.72,1.66,-1.31,-0.94,1.69,3.56,4.88,7.62,11.66,14.12,14.5,15.16,18.0,20.5,20.44,19.44,20.03,20.53,18.28,15.25,13.88,13.75,12.88,11.0,10.97,13.53,15.91,16.44,17.62,20.75,24.19,25.12,25.22,26.81,28.31,26.47,22.16,18.72,15.28,9.88,2.78,-3.09,-6.28,-8.0,-10.34,-10.75,-8.12,-4.72,-3.06,-2.22,0.31,3.59,4.78,4.19,5.28,8.06,10.62,11.75,14.25,18.72,22.28,23.03,22.62,23.16,23.19,20.09,15.31,12.22,10.66,8.56,6.16,6.16,8.56,10.94,11.47,12.84,16.22,19.75,21.16,22.0,24.38,26.5,25.75,22.41,19.56,17.12,13.34,8.47,5.78,6.0,6.81,6.22,6.81,10.03,13.75,15.47,16.62,19.03,21.81,22.16,20.88,21.06,22.22,21.78,19.56,17.5,17.41,17.47,15.34,13.62,14.0,23.0,23.5,24.81,26.66,27.12,25.47,23.0,21.25,18.69,15.47,12.72,12.19,12.44,12.16,11.38,11.69,12.84,12.88,11.81,11.69,12.91:13.09,15.03,14.84,12.44,10.69,10.38,9.19,6.75,5.47,6.91,8.72,8.69,8.75,11.38,14.66,16.12,15.62,16.5,17.91,16.97,13.78,11.34,10.72,10.0,7.88,6.97,9.56,12.06,12.19,11.31,11.66,12.03,9.91,6.56,4.75,4.53,3.47,0.75,-0.88,0.06,1.09,0.75,1.12,4.44,7.94,9.09,8.94,10.19,11.62,11.16,9.56,9.25,10.16,9.81,7.19,4.97,4.72,4.03,1.03,-2.38,-3.84,-5.5,-8.94,-12.16,-11.97,-9.28,-6.5,-4.44,-0.62,5.16,9.62,11.78,14.03,17.72,20.44,20.22,18.66,18.38,17.72,14.5,9.81,6.56,4.97,2.56,-0.84,-2.25,-1.44,-0.09,-0.28,0.59,4.44,8.16,9.16,8.62,9.5,10.16,9.09,6.19,4.78,4.41,2.75,-0.97,-3.41,-3.19,-3.19,-5.19,-6.81,-6.22,-5.25,-5.91,-6.75,-4.28,-0.31,3.12,5.31,8.59,13.06,15.53,15.12,14.34,14.69,14.28,10.69,6.22,3.47,1.34,-2.12,-5.62,-6.25,-4.62,-3.47,-3.53,-2.34,0.84,3.88,5.03,7.16,11.66,15.84,17.0,16.59,16.31,15.91,13.16,9.09,6.94,6.56,5.66,2.88,1.44,2.56,3.44,2.06,0.91,1.66,2.91,2.5,1.94,4.28,8.53,11.5,13.5,16.25,19.88,21.66,20.34,18.5,18.03,16.97,13.44,9.59,7.78,6.66,3.53,0.03,-1.53,-1.41,-1.47,-2.06,-0.12,4.47,9.12,12.22,15.88,21.03,24.75,25.0,23.88,23.25,22.41,19.47,15.94,14.78,15.69,16.09,15.84,16.62,18.94,19.97,18.0,15.44,14.72,14.88,13.66,13.03,14.94,17.84,18.59,17.75,16.66,16.06,13.66,9.0,4.88,3.53,2.84,0.81,-0.03,2.09,6.31,8.72,10.47,13.59,17.19,17.72,16.34,15.56,15.94,15.69,13.72,13.03,15.12,17.97,19.0,20.06,22.84,25.88,26.69,26.28,27.03,28.28,28.19,26.44,25.78,26.66,27.19,25.62,24.22,24.38,24.91,23.44,21.69,21.78,22.78,22.0,20.09,19.16,19.31,17.72,13.81,10.59,8.97,7.22,3.88,1.62,2.66,5.5,7.56,9.91,14.25,19.16,21.94,22.56,23.66,25.94,26.78,25.47,24.53,25.38,26.19,24.62,23.16,23.25,23.28,20.66,16.78,14.03,12.69,9.5,5.25,2.69,2.31,2.19,1.38,1.97,5.56,9.5,10.97,11.38,13.03,14.94,14.84,14.16,15.09,18.44,20.66,21.41,22.66,25.16,25.94,23.91,21.31,20.25,19.41,16.72,14.09,13.5,14.72,14.16,12.72,12.81,14.28,14.91,13.59,12.03,12.12,11.12,7.84,4.19,3.16,3.97,3.62,3.0,4.69,7.62,8.31,7.72,7.25,8.16,7.97,5.69,3.91,4.34,4.81,4.0,2.88,3.91,5.69,5.91,5.22,6.03,8.22,8.59,7.84,7.5,9.19,10.38,9.97,9.66,11.69,13.75,13.56,12.62,13.28,14.53,13.34,11.25,10.72,11.66,11.72,10.5,9.72,10.72,10.53,8.06,5.81,6.16,7.72,7.91,8.5,11.41,15.09,16.59,16.84,17.44,18.88,18.53,16.66,14.88,15.72,17.03,16.56,15.41,15.53,15.09,11.94,8.38,6.94,8.28,9.31,9.69,11.59,15.28,18.0,18.56,18.66,20.62,21.25,19.22,17.0,16.5,17.22,16.66,15.81,16.88,19.34,19.97,18.88,18.06,18.59,18.59,16.78,15.56,16.88,18.03,17.38,15.66,16.0,17.41,17.88,17.25,18.38,20.91,22.41,21.84,21.91,23.78,25.06,23.75,21.75,21.94,22.12,20.62,18.66,18.69,20.38,20.53,19.81,19.81,21.47,22.19,20.72,19.25,20.41,21.84,21.69,21.34,23.5,25.91,25.62,24.84,25.22,26.41,25.94,23.5,22.03,22.28,22.75,21.06,20.16,21.91,23.72,23.5,22.78,23.97,25.62,25.34,24.0,24.0,25.5,25.16,22.72,20.69,20.91,20.78,18.72,17.38,18.31,20.0,20.19,19.25,20.56,22.44,22.72,21.91,22.38,24.5,25.5,23.78,21.62,21.31,20.28,17.56,15.28,15.69,17.09,16.53,14.75,14.34,15.34,14.97,13.31,12.97,14.0,14.72,13.38,12.72,15.25,17.53,17.81,17.31,18.09,19.78,19.22,17.34,17.56,18.69,18.78,16.78,15.97,17.06,17.06,14.94,13.12,13.47,13.62,12.66,11.12,11.97,14.28,15.53,15.75,17.78,20.91,22.62,21.12,20.69,22.09,23.81,24.28,25.5,28.91,31.91,32.03,30.03,28.44,27.41,24.75,20.44,18.09,17.91,17.59,15.78,15.03,16.28,17.81,17.22,16.66,18.25,20.78,21.56,21.47,22.19,23.88,23.78,21.41,20.06,20.12,19.53,16.5,13.78,13.09,12.56,10.47,8.06,8.03,9.78,9.88,9.16,9.97,12.25,12.94,11.09,10.19,11.22,12.06,11.28,11.06,13.06,15.0,14.75,13.53,14.34,16.19,16.22,14.41,13.44,13.44,12.94,10.56,9.59,11.62,13.97,13.91,13.62,15.34,17.69,17.78,16.44,16.94,17.59,16.31,12.22,9.62,9.25,8.84,7.66,8.16,11.59,15.75,17.69,19.28,22.12,25.03,25.5,24.0,23.69,24.41,23.91,22.03,21.91,24.25,25.72,24.38,22.69,22.06,21.06,17.66,14.0,12.69,12.94,11.41,8.88,8.38,9.53,10.16,9.62,10.41,13.12,15.06,14.31,13.44,14.56,16.31,16.0,15.19,16.0,17.75,17.56,15.97,15.44,16.59,16.69,14.66,13.5,14.44,15.75,15.06,13.88,15.16,17.16,16.97,16.0,16.72,18.47,18.47,16.44,16.22,18.44,20.0,20.19,20.47,22.56,24.44,23.47,21.88,22.31,24.06,23.5,22.03,22.62,25.09,25.94,25.44,25.62,27.5,28.09,26.19,24.09,24.12,24.19,22.06,19.25,18.62,18.84,16.97,13.94,12.56,13.06,13.12,11.91,12.03,14.31,16.69,16.16,15.19,16.56,18.41,17.91,16.97,17.88,19.91,19.81,17.94,17.12,17.66,16.81,13.72,11.69,11.81,12.75,11.19,9.75,10.25,11.66,10.62,8.81,8.62,9.66,9.12,7.09,6.84,9.03,10.53,10.16,10.22,12.28,14.62,14.84,14.59,16.47,19.03,19.69,19.22,19.84,21.66,22.0,20.41,18.81,19.25,18.59,15.81,13.66,14.0,16.19,16.44,16.47,17.91,19.91,19.69,17.66,17.12,18.38,18.5,16.66,15.41,16.03,15.91,13.62,11.16,10.69,11.22,9.41,6.66,6.12,7.28,6.84,5.12,4.94,6.66,7.38,6.5,5.69,6.94,7.88,6.12,3.84,3.5,3.97,2.69,0.5,0.12,1.66,1.88,0.66,0.59,2.62,3.5,2.72,1.88,3.75,5.44,5.31,4.62,5.91,8.25,8.19,6.53,6.34,6.94,6.0,3.22,1.03,1.34,1.44,-0.25,-1.25,0.06,2.09,1.56,-0.09,-0.56,-0.16,-1.81,-4.69,-5.5,-3.59,-2.09,-1.69,0.16,4.19,7.09,6.94,5.59,5.81,6.0,4.5,2.09,2.12,3.72,3.53,1.97,1.5,3.69,4.78,3.94,3.69,6.0,8.0,7.69,6.28,6.91,8.09,7.25,5.34,5.47,7.62,8.09,7.12,6.84,8.84,10.19,9.22,7.97,9.0,10.34,9.78,8.66,9.94,11.94,12.28,11.16,11.31,13.09,13.38,11.78,10.88,12.38,13.34,12.25,10.84,12.09,13.16,12.59,11.19,11.75,13.22,12.75,9.88,7.97,7.44,5.59,2.41,-0.03,0.28,0.75,-0.38,-1.31,0.31,2.94,4.25,5.09,8.0,12.03,14.53,15.22,16.25,18.84,19.94,18.62,17.25,17.91,18.19,15.81,12.69,11.28,10.53,8.34,5.31,4.75,6.09,6.78,5.56,5.5,7.38,8.59,7.31,6.25,7.5,8.66,7.94,6.69,7.38,9.0,9.72,9.28,10.97,14.25,16.62,17.16,17.69,19.88,21.0,19.31,15.97,14.47,13.0,9.62,5.56,3.62,3.38,2.5,0.78,0.78,3.47,6.25,6.81,8.34,11.62,14.34,13.78,11.84,11.56,11.47,9.88,7.97,8.22,10.03,10.16,8.12,6.62,6.88,6.88,5.28,4.47,6.34,8.47,8.56,7.91,9.62,11.22,10.91,9.44,9.19,10.97,12.5,12.03,12.41,13.97,14.19,11.31,7.75,6.28,4.72,1.66,-1.31,-0.94,1.69,3.56,4.88,7.62,11.66,14.12,14.5,15.16,18.0,20.5,20.44,19.44,20.03,20.53,18.28,15.25,13.88,13.75,12.88,11.0,10.97,13.53,15.91,16.44,17.62,20.75,24.19,25.12,25.22,26.81,28.31,26.47,22.16,18.72,15.28,9.88,2.78,-3.09,-6.28,-8.0,-10.34,-10.75,-8.12,-4.72,-3.06,-2.22,0.31,3.59,4.78,4.19,5.28,8.06,10.62,11.75,14.25,18.72,22.28,23.03,22.62,23.16,23.19,20.09,15.31,12.22,10.66,8.56,6.16,6.16,8.56,10.94,11.47,12.84,16.22,19.75,21.16,22.0,24.38,26.5,25.75,22.41,19.56,17.12,13.34,8.47,5.78,6.0,6.81,6.22,6.81,10.03,13.75,15.47,16.62,19.03,21.81,22.16,20.88,21.06,22.22,21.78,19.56,17.5,17.41,17.47,15.34,13.62,14.0,23.0,23.5,24.81,26.66,27.12,25.47,23.0,21.25,18.69,15.47,12.72,12.19,12.44,12.16,11.38,11.69,12.84,12.88,11.81,11.69,12.91,13.84,14.38,15.12,17.38,18.38,18.06,16.78:6.75,5.47,6.91,8.72,8.69,8.75,11.38,14.66,16.12,15.62,16.5,17.91,16.97,13.78,11.34,10.72,10.0,7.88,6.97,9.56,12.06,12.19,11.31,11.66,12.03,9.91,6.56,4.75,4.53,3.47,0.75,-0.88,0.06,1.09,0.75,1.12,4.44,7.94,9.09,8.94,10.19,11.62,11.16,9.56,9.25,10.16,9.81,7.19,4.97,4.72,4.03,1.03,-2.38,-3.84,-5.5,-8.94,-12.16,-11.97,-9.28,-6.5,-4.44,-0.62,5.16,9.62,11.78,14.03,17.72,20.44,20.22,18.66,18.38,17.72,14.5,9.81,6.56,4.97,2.56,-0.84,-2.25,-1.44,-0.09,-0.28,0.59,4.44,8.16,9.16,8.62,9.5,10.16,9.09,6.19,4.78,4.41,2.75,-0.97,-3.41,-3.19,-3.19,-5.19,-6.81,-6.22,-5.25,-5.91,-6.75,-4.28,-0.31,3.12,5.31,8.59,13.06,15.53,15.12,14.34,14.69,14.28,10.69,6.22,3.47,1.34,-2.12,-5.62,-6.25,-4.62,-3.47,-3.53,-2.34,0.84,3.88,5.03,7.16,11.66,15.84,17.0,16.59,16.31,15.91,13.16,9.09,6.94,6.56,5.66,2.88,1.44,2.56,3.44,2.06,0.91,1.66,2.91,2.5,1.94,4.28,8.53,11.5,13.5,16.25,19.88,21.66,20.34,18.5,18.03,16.97,13.44,9.59,7.78,6.66,3.53,0.03,-1.53,-1.41,-1.47,-2.06,-0.12,4.47,9.12,12.22,15.88,21.03,24.75,25.0,23.88,23.25,22.41,19.47,15.94,14.78,15.69,16.09,15.84,16.62,18.94,19.97,18.0,15.44,14.72,14.88,13.66,13.03,14.94,17.84,18.59,17.75,16.66,16.06,13.66,9.0,4.88,3.53,2.84,0.81,-0.03,2.09,6.31,8.72,10.47,13.59,17.19,17.72,16.34,15.56,15.94,15.69,13.72,13.03,15.12,17.97,19.0,20.06,22.84,25.88,26.69,26.28,27.03,28.28,28.19,26.44,25.78,26.66,27.19,25.62,24.22,24.38,24.91,23.44,21.69,21.78,22.78,22.0,20.09,19.16,19.31,17.72,13.81,10.59,8.97,7.22,3.88,1.62,2.66,5.5,7.56,9.91,14.25,19.16,21.94,22.56,23.66,25.94,26.78,25.47,24.53,25.38,26.19,24.62,23.16,23.25,23.28,20.66,16.78,14.03,12.69,9.5,5.25,2.69,2.31,2.19,1.38,1.97,5.56,9.5,10.97,11.38,13.03,14.94,14.84,14.16,15.09,18.44,20.66,21.41,22.66,25.16,25.94,23.91,21.31,20.25,19.41,16.72,14.09,13.5,14.72,14.16,12.72,12.81,14.28,14.91,13.59,12.03,12.12,11.12,7.84,4.19,3.16,3.97,3.62,3.0,4.69,7.62,8.31,7.72,7.25,8.16,7.97,5.69,3.91,4.34,4.81,4.0,2.88,3.91,5.69,5.91,5.22,6.03,8.22,8.59,7.84,7.5,9.19,10.38,9.97,9.66,11.69,13.75,13.56,12.62,13.28,14.53,13.34,11.25,10.72,11.66,11.72,10.5,9.72,10.72,10.53,8.06,5.81,6.16,7.72,7.91,8.5,11.41,15.09,16.59,16.84,17.44,18.88,18.53,16.66,14.88,15.72,17.03,16.56,15.41,15.53,15.09,11.94,8.38,6.94,8.28,9.31,9.69,11.59,15.28,18.0,18.56,18.66,20.62,21.25,19.22,17.0,16.5,17.22,16.66,15.81,16.88,19.34,19.97,18.88,18.06,18.59,18.59,16.78,15.56,16.88,18.03,17.38,15.66,16.0,17.41,17.88,17.25,18.38,20.91,22.41,21.84,21.91,23.78,25.06,23.75,21.75,21.94,22.12,20.62,18.66,18.69,20.38,20.53,19.81,19.81,21.47,22.19,20.72,19.25,20.41,21.84,21.69,21.34,23.5,25.91,25.62,24.84,25.22,26.41,25.94,23.5,22.03,22.28,22.75,21.06,20.16,21.91,23.72,23.5,22.78,23.97,25.62,25.34,24.0,24.0,25.5,25.16,22.72,20.69,20.91,20.78,18.72,17.38,18.31,20.0,20.19,19.25,20.56,22.44,22.72,21.91,22.38,24.5,25.5,23.78,21.62,21.31,20.28,17.56,15.28,15.69,17.09,16.53,14.75,14.34,15.34,14.97,13.31,12.97,14.0,14.72,13.38,12.72,15.25,17.53,17.81,17.31,18.09,19.78,19.22,17.34,17.56,18.69,18.78,16.78,15.97,17.06,17.06,14.94,13.12,13.47,13.62,12.66,11.12,11.97,14.28,15.53,15.75,17.78,20.91,22.62,21.12,20.69,22.09,23.81,24.28,25.5,28.91,31.91,32.03,30.03,28.44,27.41,24.75,20.44,18.09,17.91,17.59,15.78,15.03,16.28,17.81,17.22,16.66,18.25,20.78,21.56,21.47,22.19,23.88,23.78,21.41,20.06,20.12,19.53,16.5,13.78,13.09,12.56,10.47,8.06,8.03,9.78,9.88,9.16,9.97,12.25,12.94,11.09,10.19,11.22,12.06,11.28,11.06,13.06,15.0,14.75,13.53,14.34,16.19,16.22,14.41,13.44,13.44,12.94,10.56,9.59,11.62,13.97,13.91,13.62,15.34,17.69,17.78,16.44,16.94,17.59,16.31,12.22,9.62,9.25,8.84,7.66,8.16,11.59,15.75,17.69,19.28,22.12,25.03,25.5,24.0,23.69,24.41,23.91,22.03,21.91,24.25,25.72,24.38,22.69,22.06,21.06,17.66,14.0,12.69,12.94,11.41,8.88,8.38,9.53,10.16,9.62,10.41,13.12,15.06,14.31,13.44,14.56,16.31,16.0,15.19,16.0,17.75,17.56,15.97,15.44,16.59,16.69,14.66,13.5,14.44,15.75,15.06,13.88,15.16,17.16,16.97,16.0,16.72,18.47,18.47,16.44,16.22,18.44,20.0,20.19,20.47,22.56,24.44,23.47,21.88,22.31,24.06,23.5,22.03,22.62,25.09,25.94,25.44,25.62,27.5,28.09,26.19,24.09,24.12,24.19,22.06,19.25,18.62,18.84,16.97,13.94,12.56,13.06,13.12,11.91,12.03,14.31,16.69,16.16,15.19,16.56,18.41,17.91,16.97,17.88,19.91,19.81,17.94,17.12,17.66,16.81,13.72,11.69,11.81,12.75,11.19,9.75,10.25,11.66,10.62,8.81,8.62,9.66,9.12,7.09,6.84,9.03,10.53,10.16,10.22,12.28,14.62,14.84,14.59,16.47,19.03,19.69,19.22,19.84,21.66,22.0,20.41,18.81,19.25,18.59,15.81,13.66,14.0,16.19,16.44,16.47,17.91,19.91,19.69,17.66,17.12,18.38,18.5,16.66,15.41,16.03,15.91,13.62,11.16,10.69,11.22,9.41,6.66,6.12,7.28,6.84,5.12,4.94,6.66,7.38,6.5,5.69,6.94,7.88,6.12,3.84,3.5,3.97,2.69,0.5,0.12,1.66,1.88,0.66,0.59,2.62,3.5,2.72,1.88,3.75,5.44,5.31,4.62,5.91,8.25,8.19,6.53,6.34,6.94,6.0,3.22,1.03,1.34,1.44,-0.25,-1.25,0.06,2.09,1.56,-0.09,-0.56,-0.16,-1.81,-4.69,-5.5,-3.59,-2.09,-1.69,0.16,4.19,7.09,6.94,5.59,5.81,6.0,4.5,2.09,2.12,3.72,3.53,1.97,1.5,3.69,4.78,3.94,3.69,6.0,8.0,7.69,6.28,6.91,8.09,7.25,5.34,5.47,7.62,8.09,7.12,6.84,8.84,10.19,9.22,7.97,9.0,10.34,9.78,8.66,9.94,11.94,12.28,11.16,11.31,13.09,13.38,11.78,10.88,12.38,13.34,12.25,10.84,12.09,13.16,12.59,11.19,11.75,13.22,12.75,9.88,7.97,7.44,5.59,2.41,-0.03,0.28,0.75,-0.38,-1.31,0.31,2.94,4.25,5.09,8.0,12.03,14.53,15.22,16.25,18.84,19.94,18.62,17.25,17.91,18.19,15.81,12.69,11.28,10.53,8.34,5.31,4.75,6.09,6.78,5.56,5.5,7.38,8.59,7.31,6.25,7.5,8.66,7.94,6.69,7.38,9.0,9.72,9.28,10.97,14.25,16.62,17.16,17.69,19.88,21.0,19.31,15.97,14.47,13.0,9.62,5.56,3.62,3.38,2.5,0.78,0.78,3.47,6.25,6.81,8.34,11.62,14.34,13.78,11.84,11.56,11.47,9.88,7.97,8.22,10.03,10.16,8.12,6.62,6.88,6.88,5.28,4.47,6.34,8.47,8.56,7.91,9.62,11.22,10.91,9.44,9.19,10.97,12.5,12.03,12.41,13.97,14.19,11.31,7.75,6.28,4.72,1.66,-1.31,-0.94,1.69,3.56,4.88,7.62,11.66,14.12,14.5,15.16,18.0,20.5,20.44,19.44,20.03,20.53,18.28,15.25,13.88,13.75,12.88,11.0,10.97,13.53,15.91,16.44,17.62,20.75,24.19,25.12,25.22,26.81,28.31,26.47,22.16,18.72,15.28,9.88,2.78,-3.09,-6.28,-8.0,-10.34,-10.75,-8.12,-4.72,-3.06,-2.22,0.31,3.59,4.78,4.19,5.28,8.06,10.62,11.75,14.25,18.72,22.28,23.03,22.62,23.16,23.19,20.09,15.31,12.22,10.66,8.56,6.16,6.16,8.56,10.94,11.47,12.84,16.22,19.75,21.16,22.0,24.38,26.5,25.75,22.41,19.56,17.12,13.34,8.47,5.78,6.0,6.81,6.22,6.81,10.03,13.75,15.47,16.62,19.03,21.81,22.16,20.88,21.06,22.22,21.78,19.56,17.5,17.41,17.47,15.34,13.62,14.0,23.0,23.5,24.81,26.66,27.12,25.47,23.0,21.25,18.69,15.47,12.72,12.19,12.44,12.16,11.38,11.69,12.84,12.88,11.81,11.69,12.91,13.84,14.38,15.12,17.38,18.38,18.06,16.78,16.25,15.5,13.38,10.28,8.12,7.31,6.47:14.66,16.12,15.62,16.5,17.91,16.97,13.78,11.34,10.72,10.0,7.88,6.97,9.56,12.06,12.19,11.31,11.66,12.03,9.91,6.56,4.75,4.53,3.47,0.75,-0.88,0.06,1.09,0.75,1.12,4.44,7.94,9.09,8.94,10.19,11.62,11.16,9.56,9.25,10.16,9.81,7.19,4.97,4.72,4.03,1.03,-2.38,-3.84,-5.5,-8.94,-12.16,-11.97,-9.28,-6.5,-4.44,-0.62,5.16,9.62,11.78,14.03,17.72,20.44,20.22,18.66,18.38,17.72,14.5,9.81,6.56,4.97,2.56,-0.84,-2.25,-1.44,-0.09,-0.28,0.59,4.44,8.16,9.16,8.62,9.5,10.16,9.09,6.19,4.78,4.41,2.75,-0.97,-3.41,-3.19,-3.19,-5.19,-6.81,-6.22,-5.25,-5.91,-6.75,-4.28,-0.31,3.12,5.31,8.59,13.06,15.53,15.12,14.34,14.69,14.28,10.69,6.22,3.47,1.34,-2.12,-5.62,-6.25,-4.62,-3.47,-3.53,-2.34,0.84,3.88,5.03,7.16,11.66,15.84,17.0,16.59,16.31,15.91,13.16,9.09,6.94,6.56,5.66,2.88,1.44,2.56,3.44,2.06,0.91,1.66,2.91,2.5,1.94,4.28,8.53,11.5,13.5,16.25,19.88,21.66,20.34,18.5,18.03,16.97,13.44,9.59,7.78,6.66,3.53,0.03,-1.53,-1.41,-1.47,-2.06,-0.12,4.47,9.12,12.22,15.88,21.03,24.75,25.0,23.88,23.25,22.41,19.47,15.94,14.78,15.69,16.09,15.84,16.62,18.94,19.97,18.0,15.44,14.72,14.88,13.66,13.03,14.94,17.84,18.59,17.75,16.66,16.06,13.66,9.0,4.88,3.53,2.84,0.81,-0.03,2.09,6.31,8.72,10.47,13.59,17.19,17.72,16.34,15.56,15.94,15.69,13.72,13.03,15.12,17.97,19.0,20.06,22.84,25.88,26.69,26.28,27.03,28.28,28.19,26.44,25.78,26.66,27.19,25.62,24.22,24.38,24.91,23.44,21.69,21.78,22.78,22.0,20.09,19.16,19.31,17.72,13.81,10.59,8.97,7.22,3.88,1.62,2.66,5.5,7.56,9.91,14.25,19.16,21.94,22.56,23.66,25.94,26.78,25.47,24.53,25.38,26.19,24.62,23.16,23.25,23.28,20.66,16.78,14.03,12.69,9.5,5.25,2.69,2.31,2.19,1.38,1.97,5.56,9.5,10.97,11.38,13.03,14.94,14.84,14.16,15.09,18.44,20.66,21.41,22.66,25.16,25.94,23.91,21.31,20.25,19.41,16.72,14.09,13.5,14.72,14.16,12.72,12.81,14.28,14.91,13.59,12.03,12.12,11.12,7.84,4.19,3.16,3.97,3.62,3.0,4.69,7.62,8.31,7.72,7.25,8.16,7.97,5.69,3.91,4.34,4.81,4.0,2.88,3.91,5.69,5.91,5.22,6.03,8.22,8.59,7.84,7.5,9.19,10.38,9.97,9.66,11.69,13.75,13.56,12.62,13.28,14.53,13.34,11.25,10.72,11.66,11.72,10.5,9.72,10.72,10.53,8.06,5.81,6.16,7.72,7.91,8.5,11.41,15.09,16.59,16.84,17.44,18.88,18.53,16.66,14.88,15.72,17.03,16.56,15.41,15.53,15.09,11.94,8.38,6.94,8.28,9.31,9.69,11.59,15.28,18.0,18.56,18.66,20.62,21.25,19.22,17.0,16.5,17.22,16.66,15.81,16.88,19.34,19.97,18.88,18.06,18.59,18.59,16.78,15.56,16.88,18.03,17.38,15.66,16.0,17.41,17.88,17.25,18.38,20.91,22.41,21.84,21.91,23.78,25.06,23.75,21.75,21.94,22.12,20.62,18.66,18.69,20.38,20.53,19.81,19.81,21.47,22.19,20.72,19.25,20.41,21.84,21.69,21.34,23.5,25.91,25.62,24.84,25.22,26.41,25.94,23.5,22.03,22.28,22.75,21.06,20.16,21.91,23.72,23.5,22.78,23.97,25.62,25.34,24.0,24.0,25.5,25.16,22.72,20.69,20.91,20.78,18.72,17.38,18.31,20.0,20.19,19.25,20.56,22.44,22.72,21.91,22.38,24.5,25.5,23.78,21.62,21.31,20.28,17.56,15.28,15.69,17.09,16.53,14.75,14.34,15.34,14.97,13.31,12.97,14.0,14.72,13.38,12.72,15.25,17.53,17.81,17.31,18.09,19.78,19.22,17.34,17.56,18.69,18.78,16.78,15.97,17.06,17.06,14.94,13.12,13.47,13.62,12.66,11.12,11.97,14.28,15.53,15.75,17.78,20.91,22.62,21.12,20.69,22.09,23.81,24.28,25.5,28.91,31.91,32.03,30.03,28.44,27.41,24.75,20.44,18.09,17.91,17.59,15.78,15.03,16.28,17.81,17.22,16.66,18.25,20.78,21.56,21.47,22.19,23.88,23.78,21.41,20.06,20.12,19.53,16.5,13.78,13.09,12.56,10.47,8.06,8.03,9.78,9.88,9.16,9.97,12.25,12.94,11.09,10.19,11.22,12.06,11.28,11.06,13.06,15.0,14.75,13.53,14.34,16.19,16.22,14.41,13.44,13.44,12.94,10.56,9.59,11.62,13.97,13.91,13.62,15.34,17.69,17.78,16.44,16.94,17.59,16.31,12.22,9.62,9.25,8.84,7.66,8.16,11.59,15.75,17.69,19.28,22.12,25.03,25.5,24.0,23.69,24.41,23.91,22.03,21.91,24.25,25.72,24.38,22.69,22.06,21.06,17.66,14.0,12.69,12.94,11.41,8.88,8.38,9.53,10.16,9.62,10.41,13.12,15.06,14.31,13.44,14.56,16.31,16.0,15.19,16.0,17.75,17.56,15.97,15.44,16.59,16.69,14.66,13.5,14.44,15.75,15.06,13.88,15.16,17.16,16.97,16.0,16.72,18.47,18.47,16.44,16.22,18.44,20.0,20.19,20.47,22.56,24.44,23.47,21.88,22.31,24.06,23.5,22.03,22.62,25.09,25.94,25.44,25.62,27.5,28.09,26.19,24.09,24.12,24.19,22.06,19.25,18.62,18.84,16.97,13.94,12.56,13.06,13.12,11.91,12.03,14.31,16.69,16.16,15.19,16.56,18.41,17.91,16.97,17.88,19.91,19.81,17.94,17.12,17.66,16.81,13.72,11.69,11.81,12.75,11.19,9.75,10.25,11.66,10.62,8.81,8.62,9.66,9.12,7.09,6.84,9.03,10.53,10.16,10.22,12.28,14.62,14.84,14.59,16.47,19.03,19.69,19.22,19.84,21.66,22.0,20.41,18.81,19.25,18.59,15.81,13.66,14.0,16.19,16.44,16.47,17.91,19.91,19.69,17.66,17.12,18.38,18.5,16.66,15.41,16.03,15.91,13.62,11.16,10.69,11.22,9.41,6.66,6.12,7.28,6.84,5.12,4.94,6.66,7.38,6.5,5.69,6.94,7.88,6.12,3.84,3.5,3.97,2.69,0.5,0.12,1.66,1.88,0.66,0.59,2.62,3.5,2.72,1.88,3.75,5.44,5.31,4.62,5.91,8.25,8.19,6.53,6.34,6.94,6.0,3.22,1.03,1.34,1.44,-0.25,-1.25,0.06,2.09,1.56,-0.09,-0.56,-0.16,-1.81,-4.69,-5.5,-3.59,-2.09,-1.69,0.16,4.19,7.09,6.94,5.59,5.81,6.0,4.5,2.09,2.12,3.72,3.53,1.97,1.5,3.69,4.78,3.94,3.69,6.0,8.0,7.69,6.28,6.91,8.09,7.25,5.34,5.47,7.62,8.09,7.12,6.84,8.84,10.19,9.22,7.97,9.0,10.34,9.78,8.66,9.94,11.94,12.28,11.16,11.31,13.09,13.38,11.78,10.88,12.38,13.34,12.25,10.84,12.09,13.16,12.59,11.19,11.75,13.22,12.75,9.88,7.97,7.44,5.59,2.41,-0.03,0.28,0.75,-0.38,-1.31,0.31,2.94,4.25,5.09,8.0,12.03,14.53,15.22,16.25,18.84,19.94,18.62,17.25,17.91,18.19,15.81,12.69,11.28,10.53,8.34,5.31,4.75,6.09,6.78,5.56,5.5,7.38,8.59,7.31,6.25,7.5,8.66,7.94,6.69,7.38,9.0,9.72,9.28,10.97,14.25,16.62,17.16,17.69,19.88,21.0,19.31,15.97,14.47,13.0,9.62,5.56,3.62,3.38,2.5,0.78,0.78,3.47,6.25,6.81,8.34,11.62,14.34,13.78,11.84,11.56,11.47,9.88,7.97,8.22,10.03,10.16,8.12,6.62,6.88,6.88,5.28,4.47,6.34,8.47,8.56,7.91,9.62,11.22,10.91,9.44,9.19,10.97,12.5,12.03,12.41,13.97,14.19,11.31,7.75,6.28,4.72,1.66,-1.31,-0.94,1.69,3.56,4.88,7.62,11.66,14.12,14.5,15.16,18.0,20.5,20.44,19.44,20.03,20.53,18.28,15.25,13.88,13.75,12.88,11.0,10.97,13.53,15.91,16.44,17.62,20.75,24.19,25.12,25.22,26.81,28.31,26.47,22.16,18.72,15.28,9.88,2.78,-3.09,-6.28,-8.0,-10.34,-10.75,-8.12,-4.72,-3.06,-2.22,0.31,3.59,4.78,4.19,5.28,8.06,10.62,11.75,14.25,18.72,22.28,23.03,22.62,23.16,23.19,20.09,15.31,12.22,10.66,8.56,6.16,6.16,8.56,10.94,11.47,12.84,16.22,19.75,21.16,22.0,24.38,26.5,25.75,22.41,19.56,17.12,13.34,8.47,5.78,6.0,6.81,6.22,6.81,10.03,13.75,15.47,16.62,19.03,21.81,22.16,20.88,21.06,22.22,21.78,19.56,17.5,17.41,17.47,15.34,13.62,14.0,23.0,23.5,24.81,26.66,27.12,25.47,23.0,21.25,18.69,15.47,12.72,12.19,12.44,12.16,11.38,11.69,12.84,12.88,11.81,11.69,12.91,13.84,14.38,15.12,17.38,18.38,18.06,16.78,16.25,15.5,13.38,10.28,8.12,7.31,6.47,5.31,5.22,6.34,7.12,6.47,6.5,8.47:positivity
-0.34,2.78,4.28,3.0,1.97,2.19,1.09,-2.69,-6.25,-7.56,-9.0,-12.56,-16.44,-18.25,-18.59,-20.09,-21.75,-21.16,-18.03,-15.41,-14.88,-13.19,-9.53,-6.25,-5.5,-5.44,-3.44,-1.81,-3.75,-7.59,-10.66,-12.47,-15.56,-19.31,-20.69,-18.81,-16.66,-16.03,-14.5,-10.97,-7.59,-7.25,-8.53,-7.84,-6.47,-7.19,-9.09,-9.44,-8.72,-9.25,-10.88,-12.09,-10.81,-9.88,-11.25,-12.69,-11.31,-9.28,-9.12,-9.56,-7.88,-5.19,-4.25,-5.06,-5.06,-3.53,-3.59,-5.81,-7.78,-7.38,-7.31,-9.38,-12.16,-12.94,-13.12,-15.38,-18.53,-19.03,-17.34,-16.19,-16.25,-14.88,-11.38,-8.72,-8.72,-8.97,-7.5,-5.91,-7.12,-9.03,-8.56,-7.16,-7.94,-10.5,-11.84,-11.94,-13.5,-16.56,-18.5,-17.25,-15.94,-16.28,-16.34,-14.12,-11.59,-10.78,-10.88,-9.22,-6.88,-5.88,-7.28,-7.56,-6.12,-5.72,-7.38,-8.69,-7.97,-7.69,-9.66,-12.31,-12.69,-12.38,-13.69,-15.47,-15.34,-14.0,-13.84,-15.56,-16.59,-15.69,-14.88,-15.88,-16.47,-14.25,-11.97,-11.91,-13.12,-12.47,-10.97,-10.66,-11.44,-10.03,-7.12,-5.38,-6.06,-6.12,-4.72,-3.81,-5.44,-8.0,-8.78,-9.25,-11.06,-13.25,-12.81,-10.91,-9.84,-10.62,-10.81,-9.03,-8.0,-8.72,-9.38,-6.84,-4.06,-3.09,-2.59,-0.19,2.34,2.91,1.78,1.38,2.0,1.19,-1.34,-2.81,-2.19,-1.84,-3.19,-4.47,-3.97,-2.84,-3.56,-4.91,-4.38,-2.81,-2.34,-3.41,-3.41,-2.19,-1.66,-3.62,-4.94,-3.78,-2.19,-2.34,-3.06,-2.03,-1.03,-2.12,-4.72,-5.97,-6.25,-7.66,-10.72,-12.62,-12.0,-11.06,-12.0,-12.28,-10.5,-8.88,-9.62,-11.28,-11.44,-10.59,-10.69,-11.44,-10.38,-7.56,-5.5,-6.38,-6.84,-5.69,-4.88,-6.22,-8.16,-7.91,-6.97,-8.34,-10.03,-9.75,-7.84,-7.41,-8.47,-8.72,-7.84,-7.81,-10.38,-12.59,-13.16,-13.34,-15.44,-17.97,-18.19,-17.44,-17.91,-19.66,-20.28,-19.38,-19.16,-20.59,-20.28,-17.06,-13.41,-11.56,-9.66,-5.97,-1.97,-0.5,-0.03,1.44,3.22,2.75,-0.09,-2.66,-4.19,-6.84,-11.25,-14.47,-14.75,-14.34,-15.62,-17.09,-16.72,-15.59,-15.91,-16.59,-16.12,-14.03,-13.31,-14.38,-15.03,-13.72,-12.91,-14.44,-16.03,-15.62,-14.5,-15.16,-15.31,-13.22,-9.53,-7.53,-6.44,-4.44,-1.22,1.09,1.66,2.03,3.5,3.94,1.56,-1.59,-2.97,-3.59,-5.53,-8.03,-8.25,-6.53,-5.91,-6.31,-5.81,-3.59,-2.12,-2.47,-2.78,-0.81,1.22,1.44,0.41,0.56,1.53,0.5,-1.34,-1.88,-0.81,-0.62,-2.16,-3.0,-2.0,-0.97,-2.47,-3.78,-3.0,-1.81,-2.75,-4.44,-4.66,-3.88,-4.53,-6.12,-6.69,-4.91,-3.62,-4.25,-4.75,-3.31,-2.28,-3.53,-5.19,-4.72,-3.22,-3.22,-4.03,-3.84,-2.53,-3.0,-5.25,-6.41,-5.41,-4.06,-4.16,-4.66,-3.41,-2.03,-2.84,-4.56,-4.09,-2.0,-1.38,-1.28,-0.09,2.41,3.72,2.91,2.0,2.91,3.88,2.97,1.62,2.34,3.66,2.75,1.09,1.03,2.88,4.0,4.25,5.75,8.94,11.12,10.94,10.78,13.06,15.34,15.56,14.81,14.84,15.03,12.78,8.69,5.81,4.41,1.94,-1.88,-4.53,-4.59,-4.47,-5.5,-6.25,-4.66,-2.62,-2.34,-3.25,-2.78,-0.94,-1.03,-2.5,-3.19,-1.94,-1.31,-2.81,-4.03,-3.5,-2.84,-4.38,-5.56,-3.59,-0.25,1.62,2.69,4.81,7.72,8.97,8.22,7.5,7.97,8.03,5.19,2.28,1.12,0.19,-2.88,-6.81,-8.38,-8.59,-8.69,-9.78,-8.84,-5.97,-3.94,-4.19,-4.47,-2.66,-0.97,-1.28,-2.28,-1.16,0.25,-0.34,-2.84,-3.72,-3.97,-5.62,-8.88,-11.0,-10.75,-10.84,-12.47,-13.66,-12.16,-10.44,-10.53,-11.41,-10.78,-9.41,-9.81,-11.44,-10.97,-9.16,-7.91,-8.59,-8.91,-7.56,-6.31,-7.06,-7.53,-5.72,-3.44,-3.44,-5.22,-6.16,-6.5,-9.06,-13.34,-15.59,-15.75,-15.34,-16.38,-16.56,-14.56,-13.38,-15.03,-17.5,-17.59,-16.72,-16.66,-16.75,-14.72,-10.91,-7.75,-6.69,-4.75,-1.09,1.62,2.0,2.03,4.03,5.91,5.62,3.91,3.44,3.59,1.34,-2.66,-5.25,-5.88,-6.81,-8.97,-10.06,-8.66,-7.34,-8.81,-10.56,-11.31,-11.34,-13.44,-16.34,-16.97,-15.28,-14.12,-14.12,-12.16,-7.69,-3.84,-2.69,-1.22,1.28,3.41,1.91,-0.56,-1.47,-1.59,-3.06,-5.56,-5.78,-3.88,-2.72,-3.28,-3.19,-1.06,0.22,-1.03,-2.56,-2.34,-1.5,-3.0,-5.38,-5.47,-4.22,-4.03,-4.81,-4.03,-1.09,1.41,1.22,1.31,3.03,4.31,2.81,0.91,0.69,1.44,-0.03,-2.22,-2.38,-0.72,0.56,-0.06,0.66,3.09,4.91,4.53,4.06,5.69,7.34,6.62,5.16,5.5,7.47,7.59,6.94,7.78,9.84,10.66,9.25,7.88,8.28,7.81,5.16,2.28,2.25,3.28,2.72,1.38,1.81,3.91,4.38,3.84,5.31,9.28,12.0,12.0,11.28,11.34,10.56,6.31,1.44,-1.5,-3.38,-7.03,-11.22,-12.72,-11.47,-11.12,-11.41,-10.38,-6.81,-3.94,-3.28,-2.38,0.62,4.5,5.69,5.88,7.66,10.19,10.5,9.44,9.59,11.28,11.69,9.91,8.06,8.06,7.0,3.38,-0.38,-1.88,-2.28,-4.22,-6.62,-7.09,-5.88,-5.91,-7.16,-7.06,-4.16,-1.59,-0.5,0.97,5.0,8.59,9.38,8.5,8.97,9.38,7.62,4.81,3.78,4.78,4.66,2.88,1.72,3.0,3.69,2.59,1.94,3.41,5.56,5.91,4.94,5.88,7.94,7.75,5.72,4.62,5.03,4.06,1.03,-1.28,-0.94,-0.31,-1.38,-2.25,0.09,3.19,4.09,3.25,3.44,4.12,2.88,-0.03,-1.88,-1.12,-1.31,-3.34,-5.09,-4.34,-3.44,-4.44,-6.31,-6.16,-5.25,-5.72,-7.22,-7.19,-4.44,-2.62,-2.12,-1.0,2.56,5.38,5.47,4.91,6.06,7.53,6.88,5.12,4.88,5.59,4.59,1.12,-1.22,-1.94,-3.56,-7.56,-10.75,-11.62,-12.06,-14.59,-16.78,-15.84,-13.19,-11.22,-9.75,-6.44,-1.72,1.16,1.16,1.75,3.81,4.78,3.5,2.22,3.0,3.91,2.78,1.06,0.97,1.47,0.28,-2.5,-3.97,-3.75,-4.19,-6.66,-8.22,-7.12,-6.88,-8.66,-10.75,-10.72,-10.09,-10.94,-11.75,-10.19,-7.16,-5.38,-5.66,-4.94,-3.41,-2.88,-4.62,-5.94,-4.78,-3.56,-4.72,-7.19,-8.38,-9.47,-12.78,-17.5,-20.31,-21.44,-22.88,-25.34,-26.47,-24.41,-22.22,-22.22,-21.72,-18.75,-15.56,-13.69,-12.66,-9.69,-5.88,-4.16,-4.59,-4.62,-3.69,-4.09,-6.88,-9.31,-9.38,-9.59,-11.25,-13.31,-13.03,-11.47,-11.31,-11.59,-9.84,-6.88,-5.09,-5.38,-4.84,-2.66,-1.22,-2.16,-2.91,-1.81,-0.44,-1.09,-1.75,0.19,3.25,4.69,4.06,4.28,4.25,2.88,-1.09,-4.09,-4.78,-5.09,-6.56,-7.84,-6.81,-5.03,-5.12,-6.03,-4.81,-2.59,-1.47,-2.09,-1.44,0.53,2.09,1.59,2.03,4.69,7.78,8.75,9.47,11.62,13.88,13.66,12.28,11.91,12.44,11.75,9.19,7.69,7.94,7.88,6.19,4.94,5.78,6.91,5.78,4.12,3.75,4.22,3.0,0.16,-1.28,-0.94,-1.44,-3.56,-4.03,-2.59,-0.88,-1.06,-2.25,-1.81,-1.28,-3.16,-5.91,-7.0,-6.22,-5.59,-6.03,-4.84,-2.5,-1.09,-3.03,-5.84,-7.56,-9.31,-13.38,-17.31,-19.0,-18.69,-19.69,-21.09,-21.25,-19.84,-19.5,-20.5,-20.56,-18.25,-15.56,-14.69,-14.0,-12.0,-9.78,-10.53,-12.19,-12.69,-11.75,-11.97,-12.81,-12.38,-9.91,-8.47,-9.38,-10.44,-10.0,-9.62,-11.25,-12.81,-11.81,-9.56,-8.97,-9.41,-9.09,-8.41,-9.06,-11.56,-12.28,-10.03,-7.38,-6.22,-4.75,-1.34,1.84,2.53,2.38,3.75,5.75,5.75,4.16,3.59,4.22,3.59,0.75,-1.5,-1.5,-1.88,-3.66,-5.44,-4.94,-3.69,-4.5,-5.78,-6.19,-5.12,-5.38,-6.81,-7.38,-6.03,-5.09,-6.03,-6.78,-5.25,-3.59,-3.59,-3.94,-2.03,0.72,1.47,0.97,1.03,2.44,2.44,0.69,-0.75,-0.5,-0.69,-3.38,-6.44,-7.34,-7.91,-10.31,-12.94,-13.75,-12.56,-12.28,-12.5,-11.5,-8.12,-5.72,-5.06,-4.34,-2.06,-0.25,-0.56,-1.56,-0.66,1.0,0.72,-0.78,-0.38,1.28,1.53,-0.03,-1.47,-0.94,-1.03,-2.88,-4.38,-3.34,-1.94,-2.72,-3.94,-2.94,-0.34,0.88,1.41,3.12,6.25,7.69,6.84,5.62,6.16,5.84,3.34,0.75,0.97,1.78,1.59,0.75,1.41,2.72,2.16,-0.59,-2.62,-2.81,-3.81,-6.22,-7.31,-5.66,-3.38,-2.5,-2.56,-0.91,0.84,0.47,-0.72,0.47,3.41,5.75,6.56,7.97,11.09,13.19,13.16,12.44,13.0,13.31,10.91,7.22,4.88,3.84,1.38,-2.25,-3.69,-3.16,-3.0,-4.59,-5.31,-3.75,-2.28,-2.31,-2.59,-0.5,2.06,2.78,1.94,3.03,5.31,6.41,5.75,5.91,7.78,8.25,6.03,3.91,3.72,3.34,0.75,-2.34,-2.91,-2.25,-3.16,-4.38,-3.62,-1.12,0.38,0.38,0.88,3.59,5.25,4.03,2.97,3.69,4.91,4.19,2.81,3.09,4.06,3.16,0.06,-1.94,-2.28,-2.75,-4.91,-5.44,-3.5:-2.69,-6.25,-7.56,-9.0,-12.56,-16.44,-18.25,-18.59,-20.09,-21.75,-21.16,-18.03,-15.41,-14.88,-13.19,-9.53,-6.25,-5.5,-5.44,-3.44,-1.81,-3.75,-7.59,-10.66,-12.47,-15.56,-19.31,-20.69,-18.81,-16.66,-16.03,-14.5,-10.97,-7.59,-7.25,-8.53,-7.84,-6.47,-7.19,-9.09,-9.44,-8.72,-9.25,-10.88,-12.09,-10.81,-9.88,-11.25,-12.69,-11.31,-9.28,-9.12,-9.56,-7.88,-5.19,-4.25,-5.06,-5.06,-3.53,-3.59,-5.81,-7.78,-7.38,-7.31,-9.38,-12.16,-12.94,-13.12,-15.38,-18.53,-19.03,-17.34,-16.19,-16.25,-14.88,-11.38,-8.72,-8.72,-8.97,-7.5,-5.91,-7.12,-9.03,-8.56,-7.16,-7.94,-10.5,-11.84,-11.94,-13.5,-16.56,-18.5,-17.25,-15.94,-16.28,-16.34,-14.12,-11.59,-10.78,-10.88,-9.22,-6.88,-5.88,-7.28,-7.56,-6.12,-5.72,-7.38,-8.69,-7.97,-7.69,-9.66,-12.31,-12.69,-12.38,-13.69,-15.47,-15.34,-14.0,-13.84,-15.56,-16.59,-15.69,-14.88,-15.88,-16.47,-14.25,-11.97,-11.91,-13.12,-12.47,-10.97,-10.66,-11.44,-10.03,-7.12,-5.38,-6.06,-6.12,-4.72,-3.81,-5.44,-8.0,-8.78,-9.25,-11.06,-13.25,-12.81,-10.91,-9.84,-10.62,-10.81,-9.03,-8.0,-8.72,-9.38,-6.84,-4.06,-3.09,-2.59,-0.19,2.34,2.91,1.78,1.38,2.0,1.19,-1.34,-2.81,-2.19,-1.84,-3.19,-4.47,-3.97,-2.84,-3.56,-4.91,-4.38,-2.81,-2.34,-3.41,-3.41,-2.19,-1.66,-3.62,-4.94,-3.78,-2.19,-2.34,-3.06,-2.03,-1.03,-2.12,-4.72,-5.97,-6.25,-7.66,-10.72,-12.62,-12.0,-11.06,-12.0,-12.28,-10.5,-8.88,-9.62,-11.28,-11.44,-10.59,-10.69,-11.44,-10.38,-7.56,-5.5,-6.38,-6.84,-5.69,-4.88,-6.22,-8.16,-7.91,-6.97,-8.34,-10.03,-9.75,-7.84,-7.41,-8.47,-8.72,-7.84,-7.81,-10.38,-12.59,-13.16,-13.34,-15.44,-17.97,-18.19,-17.44,-17.91,-19.66,-20.28,-19.38,-19.16,-20.59,-20.28,-17.06,-13.41,-11.56,-9.66,-5.97,-1.97,-0.5,-0.03,1.44,3.22,2.75,-0.09,-2.66,-4.19,-6.84,-11.25,-14.47,-14.75,-14.34,-15.62,-17.09,-16.72,-15.59,-15.91,-16.59,-16.12,-14.03,-13.31,-14.38,-15.03,-13.72,-12.91,-14.44,-16.03,-15.62,-14.5,-15.16,-15.31,-13.22,-9.53,-7.53,-6.44,-4.44,-1.22,1.09,1.66,2.03,3.5,3.94,1.56,-1.59,-2.97,-3.59,-5.53,-8.03,-8.25,-6.53,-5.91,-6.31,-5.81,-3.59,-2.12,-2.47,-2.78,-0.81,1.22,1.44,0.41,0.56,1.53,0.5,-1.34,-1.88,-0.81,-0.62,-2.16,-3.0,-2.0,-0.97,-2.47,-3.78,-3.0,-1.81,-2.75,-4.44,-4.66,-3.88,-4.53,-6.12,-6.69,-4.91,-3.62,-4.25,-4.75,-3.31,-2.28,-3.53,-5.19,-4.72,-3.22,-3.22,-4.03,-3.84,-2.53,-3.0,-5.25,-6.41,-5.41,-4.06,-4.16,-4.66,-3.41,-2.03,-2.84,-4.56,-4.09,-2.0,-1.38,-1.28,-0.09,2.41,3.72,2.91,2.0,2.91,3.88,2.97,1.62,2.34,3.66,2.75,1.09,1.03,2.88,4.0,4.25,5.75,8.94,11.12,10.94,10.78,13.06,15.34,15.56,14.81,14.84,15.03,12.78,8.69,5.81,4.41,1.94,-1.88,-4.53,-4.59,-4.47,-5.5,-6.25,-4.66,-2.62,-2.34,-3.25,-2.78,-0.94,-1.03,-2.5,-3.19,-1.94,-1.31,-2.81,-4.03,-3.5,-2.84,-4.38,-5.56,-3.59,-0.25,1.62,2.69,4.81,7.72,8.97,8.22,7.5,7.97,8.03,5.19,2.28,1.12,0.19,-2.88,-6.81,-8.38,-8.59,-8.69,-9.78,-8.84,-5.97,-3.94,-4.19,-4.47,-2.66,-0.97,-1.28,-2.28,-1.16,0.25,-0.34,-2.84,-3.72,-3.97,-5.62,-8.88,-11.0,-10.75,-10.84,-12.47,-13.66,-12.16,-10.44,-10.53,-11.41,-10.78,-9.41,-9.81,-11.44,-10.97,-9.16,-7.91,-8.59,-8.91,-7.56,-6.31,-7.06,-7.53,-5.72,-3.44,-3.44,-5.22,-6.16,-6.5,-9.06,-13.34,-15.59,-15.75,-15.34,-16.38,-16.56,-14.56,-13.38,-15.03,-17.5,-17.59,-16.72,-16.66,-16.75,-14.72,-10.91,-7.75,-6.69,-4.75,-1.09,1.62,2.0,2.03,4.03,5.91,5.62,3.91,3.44,3.59,1.34,-2.66,-5.25,-5.88,-6.81,-8.97,-10.06,-8.66,-7.34,-8.81,-10.56,-11.31,-11.34,-13.44,-16.34,-16.97,-15.28,-14.12,-14.12,-12.16,-7.69,-3.84,-2.69,-1.22,1.28,3.41,1.91,-0.56,-1.47,-1.59,-3.06,-5.56,-5.78,-3.88,-2.72,-3.28,-3.19,-1.06,0.22,-1.03,-2.56,-2.34,-1.5,-3.0,-5.38,-5.47,-4.22,-4.03,-4.81,-4.03,-1.09,1.41,1.22,1.31,3.03,4.31,2.81,0.91,0.69,1.44,-0.03,-2.22,-2.38,-0.72,0.56,-0.06,0.66,3.09,4.91,4.53,4.06,5.69,7.34,6.62,5.16,5.5,7.47,7.59,6.94,7.78,9.84,10.66,9.25,7.88,8.28,7.81,5.16,2.28,2.25,3.28,2.72,1.38,1.81,3.91,4.38,3.84,5.31,9.28,12.0,12.0,11.28,11.34,10.56,6.31,1.44,-1.5,-3.38,-7.03,-11.22,-12.72,-11.47,-11.12,-11.41,-10.38,-6.81,-3.94,-3.28,-2.38,0.62,4.5,5.69,5.88,7.66,10.19,10.5,9.44,9.59,11.28,11.69,9.91,8.06,8.06,7.0,3.38,-0.38,-1.88,-2.28,-4.22,-6.62,-7.09,-5.88,-5.91,-7.16,-7.06,-4.16,-1.59,-0.5,0.97,5.0,8.59,9.38,8.5,8.97,9.38,7.62,4.81,3.78,4.78,4.66,2.88,1.72,3.0,3.69,2.59,1.94,3.41,5.56,5.91,4.94,5.88,7.94,7.75,5.72,4.62,5.03,4.06,1.03,-1.28,-0.94,-0.31,-1.38,-2.25,0.09,3.19,4.09,3.25,3.44,4.12,2.88,-0.03,-1.88,-1.12,-1.31,-3.34,-5.09,-4.34,-3.44,-4.44,-6.31,-6.16,-5.25,-5.72,-7.22,-7.19,-4.44,-2.62,-2.12,-1.0,2.56,5.38,5.47,4.91,6.06,7.53,6.88,5.12,4.88,5.59,4.59,1.12,-1.22,-1.94,-3.56,-7.56,-10.75,-11.62,-12.06,-14.59,-16.78,-15.84,-13.19,-11.22,-9.75,-6.44,-1.72,1.16,1.16,1.75,3.81,4.78,3.5,2.22,3.0,3.91,2.78,1.06,0.97,1.47,0.28,-2.5,-3.97,-3.75,-4.19,-6.66,-8.22,-7.12,-6.88,-8.66,-10.75,-10.72,-10.09,-10.94,-11.75,-10.19,-7.16,-5.38,-5.66,-4.94,-3.41,-2.88,-4.62,-5.94,-4.78,-3.56,-4.72,-7.19,-8.38,-9.47,-12.78,-17.5,-20.31,-21.44,-22.88,-25.34,-26.47,-24.41,-22.22,-22.22,-21.72,-18.75,-15.56,-13.69,-12.66,-9.69,-5.88,-4.16,-4.59,-4.62,-3.69,-4.09,-6.88,-9.31,-9.38,-9.59,-11.25,-13.31,-13.03,-11.47,-11.31,-11.59,-9.84,-6.88,-5.09,-5.38,-4.84,-2.66,-1.22,-2.16,-2.91,-1.81,-0.44,-1.09,-1.75,0.19,3.25,4.69,4.06,4.28,4.25,2.88,-1.09,-4.09,-4.78,-5.09,-6.56,-7.84,-6.81,-5.03,-5.12,-6.03,-4.81,-2.59,-1.47,-2.09,-1.44,0.53,2.09,1.59,2.03,4.69,7.78,8.75,9.47,11.62,13.88,13.66,12.28,11.91,12.44,11.75,9.19,7.69,7.94,7.88,6.19,4.94,5.78,6.91,5.78,4.12,3.75,4.22,3.0,0.16,-1.28,-0.94,-1.44,-3.56,-4.03,-2.59,-0.88,-1.06,-2.25,-1.81,-1.28,-3.16,-5.91,-7.0,-6.22,-5.59,-6.03,-4.84,-2.5,-1.09,-3.03,-5.84,-7.56,-9.31,-13.38,-17.31,-19.0,-18.69,-19.69,-21.09,-21.25,-19.84,-19.5,-20.5,-20.56,-18.25,-15.56,-14.69,-14.0,-12.0,-9.78,-10.53,-12.19,-12.69,-11.75,-11.97,-12.81,-12.38,-9.91,-8.47,-9.38,-10.44,-10.0,-9.62,-11.25,-12.81,-11.81,-9.56,-8.97,-9.41,-9.09,-8.41,-9.06,-11.56,-12.28,-10.03,-7.38,-6.22,-4.75,-1.34,1.84,2.53,2.38,3.75,5.75,5.75,4.16,3.59,4.22,3.59,0.75,-1.5,-1.5,-1.88,-3.66,-5.44,-4.94,-3.69,-4.5,-5.78,-6.19,-5.12,-5.38,-6.81,-7.38,-6.03,-5.09,-6.03,-6.78,-5.25,-3.59,-3.59,-3.94,-2.03,0.72,1.47,0.97,1.03,2.44,2.44,0.69,-0.75,-0.5,-0.69,-3.38,-6.44,-7.34,-7.91,-10.31,-12.94,-13.75,-12.56,-12.28,-12.5,-11.5,-8.12,-5.72,-5.06,-4.34,-2.06,-0.25,-0.56,-1.56,-0.66,1.0,0.72,-0.78,-0.38,1.28,1.53,-0.03,-1.47,-0.94,-1.03,-2.88,-4.38,-3.34,-1.94,-2.72,-3.94,-2.94,-0.34,0.88,1.41,3.12,6.25,7.69,6.84,5.62,6.16,5.84,3.34,0.75,0.97,1.78,1.59,0.75,1.41,2.72,2.16,-0.59,-2.62,-2.81,-3.81,-6.22,-7.31,-5.66,-3.38,-2.5,-2.56,-0.91,0.84,0.47,-0.72,0.47,3.41,5.75,6.56,7.97,11.09,13.19,13.16,12.44,13.0,13.31,10.91,7.22,4.88,3.84,1.38,-2.25,-3.69,-3.16,-3.0,-4.59,-5.31,-3.75,-2.28,-2.31,-2.59,-0.5,2.06,2.78,1.94,3.03,5.31,6.41,5.75,5.91,7.78,8.25,6.03,3.91,3.72,3.34,0.75,-2.34,-2.91,-2.25,-3.16,-4.38,-3.62,-1.12,0.38,0.38,0.88,3.59,5.25,4.03,2.97,3.69,4.91,4.19,2.81,3.09,4.06,3.16,0.06,-1.94,-2.28,-2.75,-4.91,-5.44,-3.5,-6.22,-3.72,-2.38,-2.19,-2.19,-1.91,-2.84:-18.59,-20.09,-21.75,-21.16,-18.03,-15.41,-14.88,-13.19,-9.53,-6.25,-5.5,-5.44,-3.44,-1.81,-3.75,-7.59,-10.66,-12.47,-15.56,-19.31,-20.69,-18.81,-16.66,-16.03,-14.5,-10.97,-7.59,-7.25,-8.53,-7.84,-6.47,-7.19,-9.09,-9.44,-8.72,-9.25,-10.88,-12.09,-10.81,-9.88,-11.25,-12.69,-11.31,-9.28,-9.12,-9.56,-7.88,-5.19,-4.25,-5.06,-5.06,-3.53,-3.59,-5.81,-7.78,-7.38,-7.31,-9.38,-12.16,-12.94,-13.12,-15.38,-18.53,-19.03,-17.34,-16.19,-16.25,-14.88,-11.38,-8.72,-8.72,-8.97,-7.5,-5.91,-7.12,-9.03,-8.56,-7.16,-7.94,-10.5,-11.84,-11.94,-13.5,-16.56,-18.5,-17.25,-15.94,-16.28,-16.34,-14.12,-11.59,-10.78,-10.88,-9.22,-6.88,-5.88,-7.28,-7.56,-6.12,-5.72,-7.38,-8.69,-7.97,-7.69,-9.66,-12.31,-12.69,-12.38,-13.69,-15.47,-15.34,-14.0,-13.84,-15.56,-16.59,-15.69,-14.88,-15.88,-16.47,-14.25,-11.97,-11.91,-13.12,-12.47,-10.97,-10.66,-11.44,-10.03,-7.12,-5.38,-6.06,-6.12,-4.72,-3.81,-5.44,-8.0,-8.78,-9.25,-11.06,-13.25,-12.81,-10.91,-9.84,-10.62,-10.81,-9.03,-8.0,-8.72,-9.38,-6.84,-4.06,-3.09,-2.59,-0.19,2.34,2.91,1.78,1.38,2.0,1.19,-1.34,-2.81,-2.19,-1.84,-3.19,-4.47,-3.97,-2.84,-3.56,-4.91,-4.38,-2.81,-2.34,-3.41,-3.41,-2.19,-1.66,-3.62,-4.94,-3.78,-2.19,-2.34,-3.06,-2.03,-1.03,-2.12,-4.72,-5.97,-6.25,-7.66,-10.72,-12.62,-12.0,-11.06,-12.0,-12.28,-10.5,-8.88,-9.62,-11.28,-11.44,-10.59,-10.69,-11.44,-10.38,-7.56,-5.5,-6.38,-6.84,-5.69,-4.88,-6.22,-8.16,-7.91,-6.97,-8.34,-10.03,-9.75,-7.84,-7.41,-8.47,-8.72,-7.84,-7.81,-10.38,-12.59,-13.16,-13.34,-15.44,-17.97,-18.19,-17.44,-17.91,-19.66,-20.28,-19.38,-19.16,-20.59,-20.28,-17.06,-13.41,-11.56,-9.66,-5.97,-1.97,-0.5,-0.03,1.44,3.22,2.75,-0.09,-2.66,-4.19,-6.84,-11.25,-14.47,-14.75,-14.34,-15.62,-17.09,-16.72,-15.59,-15.91,-16.59,-16.12,-14.03,-13.31,-14.38,-15.03,-13.72,-12.91,-14.44,-16.03,-15.62,-14.5,-15.16,-15.31,-13.22,-9.53,-7.53,-6.44,-4.44,-1.22,1.09,1.66,2.03,3.5,3.94,1.56,-1.59,-2.97,-3.59,-5.53,-8.03,-8.25,-6.53,-5.91,-6.31,-5.81,-3.59,-2.12,-2.47,-2.78,-0.81,1.22,1.44,0.41,0.56,1.53,0.5,-1.34,-1.88,-0.81,-0.62,-2.16,-3.0,-2.0,-0.97,-2.47,-3.78,-3.0,-1.81,-2.75,-4.44,-4.66,-3.88,-4.53,-6.12,-6.69,-4.91,-3.62,-4.25,-4.75,-3.31,-2.28,-3.53,-5.19,-4.72,-3.22,-3.22,-4.03,-3.84,-2.53,-3.0,-5.25,-6.41,-5.41,-4.06,-4.16,-4.66,-3.41,-2.03,-2.84,-4.56,-4.09,-2.0,-1.38,-1.28,-0.09,2.41,3.72,2.91,2.0,2.91,3.88,2.97,1.62,2.34,3.66,2.75,1.09,1.03,2.88,4.0,4.25,5.75,8.94,11.12,10.94,10.78,13.06,15.34,15.56,14.81,14.84,15.03,12.78,8.69,5.81,4.41,1.94,-1.88,-4.53,-4.59,-4.47,-5.5,-6.25,-4.66,-2.62,-2.34,-3.25,-2.78,-0.94,-1.03,-2.5,-3.19,-1.94,-1.31,-2.81,-4.03,-3.5,-2.84,-4.38,-5.56,-3.59,-0.25,1.62,2.69,4.81,7.72,8.97,8.22,7.5,7.97,8.03,5.19,2.28,1.12,0.19,-2.88,-6.81,-8.38,-8.59,-8.69,-9.78,-8.84,-5.97,-3.94,-4.19,-4.47,-2.66,-0.97,-1.28,-2.28,-1.16,0.25,-0.34,-2.84,-3.72,-3.97,-5.62,-8.88,-11.0,-10.75,-10.84,-12.47,-13.66,-12.16,-10.44,-10.53,-11.41,-10.78,-9.41,-9.81,-11.44,-10.97,-9.16,-7.91,-8.59,-8.91,-7.56,-6.31,-7.06,-7.53,-5.72,-3.44,-3.44,-5.22,-6.16,-6.5,-9.06,-13.34,-15.59,-15.75,-15.34,-16.38,-16.56,-14.56,-13.38,-15.03,-17.5,-17.59,-16.72,-16.66,-16.75,-14.72,-10.91,-7.75,-6.69,-4.75,-1.09,1.62,2.0,2.03,4.03,5.91,5.62,3.91,3.44,3.59,1.34,-2.66,-5.25,-5.88,-6.81,-8.97,-10.06,-8.66,-7.34,-8.81,-10.56,-11.31,-11.34,-13.44,-16.34,-16.97,-15.28,-14.12,-14.12,-12.16,-7.69,-3.84,-2.69,-1.22,1.28,3.41,1.91,-0.56,-1.47,-1.59,-3.06,-5.56,-5.78,-3.88,-2.72,-3.28,-3.19,-1.06,0.22,-1.03,-2.56,-2.34,-1.5,-3.0,-5.38,-5.47,-4.22,-4.03,-4.81,-4.03,-1.09,1.41,1.22,1.31,3.03,4.31,2.81,0.91,0.69,1.44,-0.03,-2.22,-2.38,-0.72,0.56,-0.06,0.66,3.09,4.91,4.53,4.06,5.69,7.34,6.62,5.16,5.5,7.47,7.59,6.94,7.78,9.84,10.66,9.25,7.88,8.28,7.81,5.16,2.28,2.25,3.28,2.72,1.38,1.81,3.91,4.38,3.84,5.31,9.28,12.0,12.0,11.28,11.34,10.56,6.31,1.44,-1.5,-3.38,-7.03,-11.22,-12.72,-11.47,-11.12,-11.41,-10.38,-6.81,-3.94,-3.28,-2.38,0.62,4.5,5.69,5.88,7.66,10.19,10.5,9.44,9.59,11.28,11.69,9.91,8.06,8.06,7.0,3.38,-0.38,-1.88,-2.28,-4.22,-6.62,-7.09,-5.88,-5.91,-7.16,-7.06,-4.16,-1.59,-0.5,0.97,5.0,8.59,9.38,8.5,8.97,9.38,7.62,4.81,3.78,4.78,4.66,2.88,1.72,3.0,3.69,2.59,1.94,3.41,5.56,5.91,4.94,5.88,7.94,7.75,5.72,4.62,5.03,4.06,1.03,-1.28,-0.94,-0.31,-1.38,-2.25,0.09,3.19,4.09,3.25,3.44,4.12,2.88,-0.03,-1.88,-1.12,-1.31,-3.34,-5.09,-4.34,-3.44,-4.44,-6.31,-6.16,-5.25,-5.72,-7.22,-7.19,-4.44,-2.62,-2.12,-1.0,2.56,5.38,5.47,4.91,6.06,7.53,6.88,5.12,4.88,5.59,4.59,1.12,-1.22,-1.94,-3.56,-7.56,-10.75,-11.62,-12.06,-14.59,-16.78,-15.84,-13.19,-11.22,-9.75,-6.44,-1.72,1.16,1.16,1.75,3.81,4.78,3.5,2.22,3.0,3.91,2.78,1.06,0.97,1.47,0.28,-2.5,-3.97,-3.75,-4.19,-6.66,-8.22,-7.12,-6.88,-8.66,-10.75,-10.72,-10.09,-10.94,-11.75,-10.19,-7.16,-5.38,-5.66,-4.94,-3.41,-2.88,-4.62,-5.94,-4.78,-3.56,-4.72,-7.19,-8.38,-9.47,-12.78,-17.5,-20.31,-21.44,-22.88,-25.34,-26.47,-24.41,-22.22,-22.22,-21.72,-18.75,-15.56,-13.69,-12.66,-9.69,-5.88,-4.16,-4.59,-4.62,-3.69,-4.09,-6.88,-9.31,-9.38,-9.59,-11.25,-13.31,-13.03,-11.47,-11.31,-11.59,-9.84,-6.88,-5.09,-5.38,-4.84,-2.66,-1.22,-2.16,-2.91,-1.81,-0.44,-1.09,-1.75,0.19,3.25,4.69,4.06,4.28,4.25,2.88,-1.09,-4.09,-4.78,-5.09,-6.56,-7.84,-6.81,-5.03,-5.12,-6.03,-4.81,-2.59,-1.47,-2.09,-1.44,0.53,2.09,1.59,2.03,4.69,7.78,8.75,9.47,11.62,13.88,13.66,12.28,11.91,12.44,11.75,9.19,7.69,7.94,7.88,6.19,4.94,5.78,6.91,5.78,4.12,3.75,4.22,3.0,0.16,-1.28,-0.94,-1.44,-3.56,-4.03,-2.59,-0.88,-1.06,-2.25,-1.81,-1.28,-3.16,-5.91,-7.0,-6.22,-5.59,-6.03,-4.84,-2.5,-1.09,-3.03,-5.84,-7.56,-9.31,-13.38,-17.31,-19.0,-18.69,-19.69,-21.09,-21.25,-19.84,-19.5,-20.5,-20.56,-18.25,-15.56,-14.69,-14.0,-12.0,-9.78,-10.53,-12.19,-12.69,-11.75,-11.97,-12.81,-12.38,-9.91,-8.47,-9.38,-10.44,-10.0,-9.62,-11.25,-12.81,-11.81,-9.56,-8.97,-9.41,-9.09,-8.41,-9.06,-11.56,-12.28,-10.03,-7.38,-6.22,-4.75,-1.34,1.84,2.53,2.38,3.75,5.75,5.75,4.16,3.59,4.22,3.59,0.75,-1.5,-1.5,-1.88,-3.66,-5.44,-4.94,-3.69,-4.5,-5.78,-6.19,-5.12,-5.38,-6.81,-7.38,-6.03,-5.09,-6.03,-6.78,-5.25,-3.59,-3.59,-3.94,-2.03,0.72,1.47,0.97,1.03,2.44,2.44,0.69,-0.75,-0.5,-0.69,-3.38,-6.44,-7.34,-7.91,-10.31,-12.94,-13.75,-12.56,-12.28,-12.5,-11.5,-8.12,-5.72,-5.06,-4.34,-2.06,-0.25,-0.56,-1.56,-0.66,1.0,0.72,-0.78,-0.38,1.28,1.53,-0.03,-1.47,-0.94,-1.03,-2.88,-4.38,-3.34,-1.94,-2.72,-3.94,-2.94,-0.34,0.88,1.41,3.12,6.25,7.69,6.84,5.62,6.16,5.84,3.34,0.75,0.97,1.78,1.59,0.75,1.41,2.72,2.16,-0.59,-2.62,-2.81,-3.81,-6.22,-7.31,-5.66,-3.38,-2.5,-2.56,-0.91,0.84,0.47,-0.72,0.47,3.41,5.75,6.56,7.97,11.09,13.19,13.16,12.44,13.0,13.31,10.91,7.22,4.88,3.84,1.38,-2.25,-3.69,-3.16,-3.0,-4.59,-5.31,-3.75,-2.28,-2.31,-2.59,-0.5,2.06,2.78,1.94,3.03,5.31,6.41,5.75,5.91,7.78,8.25,6.03,3.91,3.72,3.34,0.75,-2.34,-2.91,-2.25,-3.16,-4.38,-3.62,-1.12,0.38,0.38,0.88,3.59,5.25,4.03,2.97,3.69,4.91,4.19,2.81,3.09,4.06,3.16,0.06,-1.94,-2.28,-2.75,-4.91,-5.44,-3.5,-6.22,-3.72,-2.38,-2.19,-2.19,-1.91,-2.84,-5.38,-7.5,-8.34,-9.0,-10.91,-12.84,-13.56:-13.19,-9.53,-6.25,-5.5,-5.44,-3.44,-1.81,-3.75,-7.59,-10.66,-12.47,-15.56,-19.31,-20.69,-18.81,-16.66,-16.03,-14.5,-10.97,-7.59,-7.25,-8.53,-7.84,-6.47,-7.19,-9.09,-9.44,-8.72,-9.25,-10.88,-12.09,-10.81,-9.88,-11.25,-12.69,-11.31,-9.28,-9.12,-9.56,-7.88,-5.19,-4.25,-5.06,-5.06,-3.53,-3.59,-5.81,-7.78,-7.38,-7.31,-9.38,-12.16,-12.94,-13.12,-15.38,-18.53,-19.03,-17.34,-16.19,-16.25,-14.88,-11.38,-8.72,-8.72,-8.97,-7.5,-5.91,-7.12,-9.03,-8.56,-7.16,-7.94,-10.5,-11.84,-11.94,-13.5,-16.56,-18.5,-17.25,-15.94,-16.28,-16.34,-14.12,-11.59,-10.78,-10.88,-9.22,-6.88,-5.88,-7.28,-7.56,-6.12,-5.72,-7.38,-8.69,-7.97,-7.69,-9.66,-12.31,-12.69,-12.38,-13.69,-15.47,-15.34,-14.0,-13.84,-15.56,-16.59,-15.69,-14.88,-15.88,-16.47,-14.25,-11.97,-11.91,-13.12,-12.47,-10.97,-10.66,-11.44,-10.03,-7.12,-5.38,-6.06,-6.12,-4.72,-3.81,-5.44,-8.0,-8.78,-9.25,-11.06,-13.25,-12.81,-10.91,-9.84,-10.62,-10.81,-9.03,-8.0,-8.72,-9.38,-6.84,-4.06,-3.09,-2.59,-0.19,2.34,2.91,1.78,1.38,2.0,1.19,-1.34,-2.81,-2.19,-1.84,-3.19,-4.47,-3.97,-2.84,-3.56,-4.91,-4.38,-2.81,-2.34,-3.41,-3.41,-2.19,-1.66,-3.62,-4.94,-3.78,-2.19,-2.34,-3.06,-2.03,-1.03,-2.12,-4.72,-5.97,-6.25,-7.66,-10.72,-12.62,-12.0,-11.06,-12.0,-12.28,-10.5,-8.88,-9.62,-11.28,-11.44,-10.59,-10.69,-11.44,-10.38,-7.56,-5.5,-6.38,-6.84,-5.69,-4.88,-6.22,-8.16,-7.91,-6.97,-8.34,-10.03,-9.75,-7.84,-7.41,-8.47,-8.72,-7.84,-7.81,-10.38,-12.59,-13.16,-13.34,-15.44,-17.97,-18.19,-17.44,-17.91,-19.66,-20.28,-19.38,-19.16,-20.59,-20.28,-17.06,-13.41,-11.56,-9.66,-5.97,-1.97,-0.5,-0.03,1.44,3.22,2.75,-0.09,-2.66,-4.19,-6.84,-11.25,-14.47,-14.75,-14.34,-15.62,-17.09,-16.72,-15.59,-15.91,-16.59,-16.12,-14.03,-13.31,-14.38,-15.03,-13.72,-12.91,-14.44,-16.03,-15.62,-14.5,-15.16,-15.31,-13.22,-9.53,-7.53,-6.44,-4.44,-1.22,1.09,1.66,2.03,3.5,3.94,1.56,-1.59,-2.97,-3.59,-5.53,-8.03,-8.25,-6.53,-5.91,-6.31,-5.81,-3.59,-2.12,-2.47,-2.78,-0.81,1.22,1.44,0.41,0.56,1.53,0.5,-1.34,-1.88,-0.81,-0.62,-2.16,-3.0,-2.0,-0.97,-2.47,-3.78,-3.0,-1.81,-2.75,-4.44,-4.66,-3.88,-4.53,-6.12,-6.69,-4.91,-3.62,-4.25,-4.75,-3.31,-2.28,-3.53,-5.19,-4.72,-3.22,-3.22,-4.03,-3.84,-2.53,-3.0,-5.25,-6.41,-5.41,-4.06,-4.16,-4.66,-3.41,-2.03,-2.84,-4.56,-4.09,-2.0,-1.38,-1.28,-0.09,2.41,3.72,2.91,2.0,2.91,3.88,2.97,1.62,2.34,3.66,2.75,1.09,1.03,2.88,4.0,4.25,5.75,8.94,11.12,10.94,10.78,13.06,15.34,15.56,14.81,14.84,15.03,12.78,8.69,5.81,4.41,1.94,-1.88,-4.53,-4.59,-4.47,-5.5,-6.25,-4.66,-2.62,-2.34,-3.25,-2.78,-0.94,-1.03,-2.5,-3.19,-1.94,-1.31,-2.81,-4.03,-3.5,-2.84,-4.38,-5.56,-3.59,-0.25,1.62,2.69,4.81,7.72,8.97,8.22,7.5,7.97,8.03,5.19,2.28,1.12,0.19,-2.88,-6.81,-8.38,-8.59,-8.69,-9.78,-8.84,-5.97,-3.94,-4.19,-4.47,-2.66,-0.97,-1.28,-2.28,-1.16,0.25,-0.34,-2.84,-3.72,-3.97,-5.62,-8.88,-11.0,-10.75,-10.84,-12.47,-13.66,-12.16,-10.44,-10.53,-11.41,-10.78,-9.41,-9.81,-11.44,-10.97,-9.16,-7.91,-8.59,-8.91,-7.56,-6.31,-7.06,-7.53,-5.72,-3.44,-3.44,-5.22,-6.16,-6.5,-9.06,-13.34,-15.59,-15.75,-15.34,-16.38,-16.56,-14.56,-13.38,-15.03,-17.5,-17.59,-16.72,-16.66,-16.75,-14.72,-10.91,-7.75,-6.69,-4.75,-1.09,1.62,2.0,2.03,4.03,5.91,5.62,3.91,3.44,3.59,1.34,-2.66,-5.25,-5.88,-6.81,-8.97,-10.06,-8.66,-7.34,-8.81,-10.56,-11.31,-11.34,-13.44,-16.34,-16.97,-15.28,-14.12,-14.12,-12.16,-7.69,-3.84,-2.69,-1.22,1.28,3.41,1.91,-0.56,-1.47,-1.59,-3.06,-5.56,-5.78,-3.88,-2.72,-3.28,-3.19,-1.06,0.22,-1.03,-2.56,-2.34,-1.5,-3.0,-5.38,-5.47,-4.22,-4.03,-4.81,-4.03,-1.09,1.41,1.22,1.31,3.03,4.31,2.81,0.91,0.69,1.44,-0.03,-2.22,-2.38,-0.72,0.56,-0.06,0.66,3.09,4.91,4.53,4.06,5.69,7.34,6.62,5.16,5.5,7.47,7.59,6.94,7.78,9.84,10.66,9.25,7.88,8.28,7.81,5.16,2.28,2.25,3.28,2.72,1.38,1.81,3.91,4.38,3.84,5.31,9.28,12.0,12.0,11.28,11.34,10.56,6.31,1.44,-1.5,-3.38,-7.03,-11.22,-12.72,-11.47,-11.12,-11.41,-10.38,-6.81,-3.94,-3.28,-2.38,0.62,4.5,5.69,5.88,7.66,10.19,10.5,9.44,9.59,11.28,11.69,9.91,8.06,8.06,7.0,3.38,-0.38,-1.88,-2.28,-4.22,-6.62,-7.09,-5.88,-5.91,-7.16,-7.06,-4.16,-1.59,-0.5,0.97,5.0,8.59,9.38,8.5,8.97,9.38,7.62,4.81,3.78,4.78,4.66,2.88,1.72,3.0,3.69,2.59,1.94,3.41,5.56,5.91,4.94,5.88,7.94,7.75,5.72,4.62,5.03,4.06,1.03,-1.28,-0.94,-0.31,-1.38,-2.25,0.09,3.19,4.09,3.25,3.44,4.12,2.88,-0.03,-1.88,-1.12,-1.31,-3.34,-5.09,-4.34,-3.44,-4.44,-6.31,-6.16,-5.25,-5.72,-7.22,-7.19,-4.44,-2.62,-2.12,-1.0,2.56,5.38,5.47,4.91,6.06,7.53,6.88,5.12,4.88,5.59,4.59,1.12,-1.22,-1.94,-3.56,-7.56,-10.75,-11.62,-12.06,-14.59,-16.78,-15.84,-13.19,-11.22,-9.75,-6.44,-1.72,1.16,1.16,1.75,3.81,4.78,3.5,2.22,3.0,3.91,2.78,1.06,0.97,1.47,0.28,-2.5,-3.97,-3.75,-4.19,-6.66,-8.22,-7.12,-6.88,-8.66,-10.75,-10.72,-10.09,-10.94,-11.75,-10.19,-7.16,-5.38,-5.66,-4.94,-3.41,-2.88,-4.62,-5.94,-4.78,-3.56,-4.72,-7.19,-8.38,-9.47,-12.78,-17.5,-20.31,-21.44,-22.88,-25.34,-26.47,-24.41,-22.22,-22.22,-21.72,-18.75,-15.56,-13.69,-12.66,-9.69,-5.88,-4.16,-4.59,-4.62,-3.69,-4.09,-6.88,-9.31,-9.38,-9.59,-11.25,-13.31,-13.03,-11.47,-11.31,-11.59,-9.84,-6.88,-5.09,-5.38,-4.84,-2.66,-1.22,-2.16,-2.91,-1.81,-0.44,-1.09,-1.75,0.19,3.25,4.69,4.06,4.28,4.25,2.88,-1.09,-4.09,-4.78,-5.09,-6.56,-7.84,-6.81,-5.03,-5.12,-6.03,-4.81,-2.59,-1.47,-2.09,-1.44,0.53,2.09,1.59,2.03,4.69,7.78,8.75,9.47,11.62,13.88,13.66,12.28,11.91,12.44,11.75,9.19,7.69,7.94,7.88,6.19,4.94,5.78,6.91,5.78,4.12,3.75,4.22,3.0,0.16,-1.28,-0.94,-1.44,-3.56,-4.03,-2.59,-0.88,-1.06,-2.25,-1.81,-1.28,-3.16,-5.91,-7.0,-6.22,-5.59,-6.03,-4.84,-2.5,-1.09,-3.03,-5.84,-7.56,-9.31,-13.38,-17.31,-19.0,-18.69,-19.69,-21.09,-21.25,-19.84,-19.5,-20.5,-20.56,-18.25,-15.56,-14.69,-14.0,-12.0,-9.78,-10.53,-12.19,-12.69,-11.75,-11.97,-12.81,-12.38,-9.91,-8.47,-9.38,-10.44,-10.0,-9.62,-11.25,-12.81,-11.81,-9.56,-8.97,-9.41,-9.09,-8.41,-9.06,-11.56,-12.28,-10.03,-7.38,-6.22,-4.75,-1.34,1.84,2.53,2.38,3.75,5.75,5.75,4.16,3.59,4.22,3.59,0.75,-1.5,-1.5,-1.88,-3.66,-5.44,-4.94,-3.69,-4.5,-5.78,-6.19,-5.12,-5.38,-6.81,-7.38,-6.03,-5.09,-6.03,-6.78,-5.25,-3.59,-3.59,-3.94,-2.03,0.72,1.47,0.97,1.03,2.44,2.44,0.69,-0.75,-0.5,-0.69,-3.38,-6.44,-7.34,-7.91,-10.31,-12.94,-13.75,-12.56,-12.28,-12.5,-11.5,-8.12,-5.72,-5.06,-4.34,-2.06,-0.25,-0.56,-1.56,-0.66,1.0,0.72,-0.78,-0.38,1.28,1.53,-0.03,-1.47,-0.94,-1.03,-2.88,-4.38,-3.34,-1.94,-2.72,-3.94,-2.94,-0.34,0.88,1.41,3.12,6.25,7.69,6.84,5.62,6.16,5.84,3.34,0.75,0.97,1.78,1.59,0.75,1.41,2.72,2.16,-0.59,-2.62,-2.81,-3.81,-6.22,-7.31,-5.66,-3.38,-2.5,-2.56,-0.91,0.84,0.47,-0.72,0.47,3.41,5.75,6.56,7.97,11.09,13.19,13.16,12.44,13.0,13.31,10.91,7.22,4.88,3.84,1.38,-2.25,-3.69,-3.16,-3.0,-4.59,-5.31,-3.75,-2.28,-2.31,-2.59,-0.5,2.06,2.78,1.94,3.03,5.31,6.41,5.75,5.91,7.78,8.25,6.03,3.91,3.72,3.34,0.75,-2.34,-2.91,-2.25,-3.16,-4.38,-3.62,-1.12,0.38,0.38,0.88,3.59,5.25,4.03,2.97,3.69,4.91,4.19,2.81,3.09,4.06,3.16,0.06,-1.94,-2.28,-2.75,-4.91,-5.44,-3.5,-6.22,-3.72,-2.38,-2.19,-2.19,-1.91,-2.84,-5.38,-7.5,-8.34,-9.0,-10.91,-12.84,-13.56,-14.0,-15.44,-16.59,-16.75,-15.06,-13.78,-12.97:-3.75,-7.59,-10.66,-12.47,-15.56,-19.31,-20.69,-18.81,-16.66,-16.03,-14.5,-10.97,-7.59,-7.25,-8.53,-7.84,-6.47,-7.19,-9.09,-9.44,-8.72,-9.25,-10.88,-12.09,-10.81,-9.88,-11.25,-12.69,-11.31,-9.28,-9.12,-9.56,-7.88,-5.19,-4.25,-5.06,-5.06,-3.53,-3.59,-5.81,-7.78,-7.38,-7.31,-9.38,-12.16,-12.94,-13.12,-15.38,-18.53,-19.03,-17.34,-16.19,-16.25,-14.88,-11.38,-8.72,-8.72,-8.97,-7.5,-5.91,-7.12,-9.03,-8.56,-7.16,-7.94,-10.5,-11.84,-11.94,-13.5,-16.56,-18.5,-17.25,-15.94,-16.28,-16.34,-14.12,-11.59,-10.78,-10.88,-9.22,-6.88,-5.88,-7.28,-7.56,-6.12,-5.72,-7.38,-8.69,-7.97,-7.69,-9.66,-12.31,-12.69,-12.38,-13.69,-15.47,-15.34,-14.0,-13.84,-15.56,-16.59,-15.69,-14.88,-15.88,-16.47,-14.25,-11.97,-11.91,-13.12,-12.47,-10.97,-10.66,-11.44,-10.03,-7.12,-5.38,-6.06,-6.12,-4.72,-3.81,-5.44,-8.0,-8.78,-9.25,-11.06,-13.25,-12.81,-10.91,-9.84,-10.62,-10.81,-9.03,-8.0,-8.72,-9.38,-6.84,-4.06,-3.09,-2.59,-0.19,2.34,2.91,1.78,1.38,2.0,1.19,-1.34,-2.81,-2.19,-1.84,-3.19,-4.47,-3.97,-2.84,-3.56,-4.91,-4.38,-2.81,-2.34,-3.41,-3.41,-2.19,-1.66,-3.62,-4.94,-3.78,-2.19,-2.34,-3.06,-2.03,-1.03,-2.12,-4.72,-5.97,-6.25,-7.66,-10.72,-12.62,-12.0,-11.06,-12.0,-12.28,-10.5,-8.88,-9.62,-11.28,-11.44,-10.59,-10.69,-11.44,-10.38,-7.56,-5.5,-6.38,-6.84,-5.69,-4.88,-6.22,-8.16,-7.91,-6.97,-8.34,-10.03,-9.75,-7.84,-7.41,-8.47,-8.72,-7.84,-7.81,-10.38,-12.59,-13.16,-13.34,-15.44,-17.97,-18.19,-17.44,-17.91,-19.66,-20.28,-19.38,-19.16,-20.59,-20.28,-17.06,-13.41,-11.56,-9.66,-5.97,-1.97,-0.5,-0.03,1.44,3.22,2.75,-0.09,-2.66,-4.19,-6.84,-11.25,-14.47,-14.75,-14.34,-15.62,-17.09,-16.72,-15.59,-15.91,-16.59,-16.12,-14.03,-13.31,-14.38,-15.03,-13.72,-12.91,-14.44,-16.03,-15.62,-14.5,-15.16,-15.31,-13.22,-9.53,-7.53,-6.44,-4.44,-1.22,1.09,1.66,2.03,3.5,3.94,1.56,-1.59,-2.97,-3.59,-5.53,-8.03,-8.25,-6.53,-5.91,-6.31,-5.81,-3.59,-2.12,-2.47,-2.78,-0.81,1.22,1.44,0.41,0.56,1.53,0.5,-1.34,-1.88,-0.81,-0.62,-2.16,-3.0,-2.0,-0.97,-2.47,-3.78,-3.0,-1.81,-2.75,-4.44,-4.66,-3.88,-4.53,-6.12,-6.69,-4.91,-3.62,-4.25,-4.75,-3.31,-2.28,-3.53,-5.19,-4.72,-3.22,-3.22,-4.03,-3.84,-2.53,-3.0,-5.25,-6.41,-5.41,-4.06,-4.16,-4.66,-3.41,-2.03,-2.84,-4.56,-4.09,-2.0,-1.38,-1.28,-0.09,2.41,3.72,2.91,2.0,2.91,3.88,2.97,1.62,2.34,3.66,2.75,1.09,1.03,2.88,4.0,4.25,5.75,8.94,11.12,10.94,10.78,13.06,15.34,15.56,14.81,14.84,15.03,12.78,8.69,5.81,4.41,1.94,-1.88,-4.53,-4.59,-4.47,-5.5,-6.25,-4.66,-2.62,-2.34,-3.25,-2.78,-0.94,-1.03,-2.5,-3.19,-1.94,-1.31,-2.81,-4.03,-3.5,-2.84,-4.38,-5.56,-3.59,-0.25,1.62,2.69,4.81,7.72,8.97,8.22,7.5,7.97,8.03,5.19,2.28,1.12,0.19,-2.88,-6.81,-8.38,-8.59,-8.69,-9.78,-8.84,-5.97,-3.94,-4.19,-4.47,-2.66,-0.97,-1.28,-2.28,-1.16,0.25,-0.34,-2.84,-3.72,-3.97,-5.62,-8.88,-11.0,-10.75,-10.84,-12.47,-13.66,-12.16,-10.44,-10.53,-11.41,-10.78,-9.41,-9.81,-11.44,-10.97,-9.16,-7.91,-8.59,-8.91,-7.56,-6.31,-7.06,-7.53,-5.72,-3.44,-3.44,-5.22,-6.16,-6.5,-9.06,-13.34,-15.59,-15.75,-15.34,-16.38,-16.56,-14.56,-13.38,-15.03,-17.5,-17.59,-16.72,-16.66,-16.75,-14.72,-10.91,-7.75,-6.69,-4.75,-1.09,1.62,2.0,2.03,4.03,5.91,5.62,3.91,3.44,3.59,1.34,-2.66,-5.25,-5.88,-6.81,-8.97,-10.06,-8.66,-7.34,-8.81,-10.56,-11.31,-11.34,-13.44,-16.34,-16.97,-15.28,-14.12,-14.12,-12.16,-7.69,-3.84,-2.69,-1.22,1.28,3.41,1.91,-0.56,-1.47,-1.59,-3.06,-5.56,-5.78,-3.88,-2.72,-3.28,-3.19,-1.06,0.22,-1.03,-2.56,-2.34,-1.5,-3.0,-5.38,-5.47,-4.22,-4.03,-4.81,-4.03,-1.09,1.41,1.22,1.31,3.03,4.31,2.81,0.91,0.69,1.44,-0.03,-2.22,-2.38,-0.72,0.56,-0.06,0.66,3.09,4.91,4.53,4.06,5.69,7.34,6.62,5.16,5.5,7.47,7.59,6.94,7.78,9.84,10.66,9.25,7.88,8.28,7.81,5.16,2.28,2.25,3.28,2.72,1.38,1.81,3.91,4.38,3.84,5.31,9.28,12.0,12.0,11.28,11.34,10.56,6.31,1.44,-1.5,-3.38,-7.03,-11.22,-12.72,-11.47,-11.12,-11.41,-10.38,-6.81,-3.94,-3.28,-2.38,0.62,4.5,5.69,5.88,7.66,10.19,10.5,9.44,9.59,11.28,11.69,9.91,8.06,8.06,7.0,3.38,-0.38,-1.88,-2.28,-4.22,-6.62,-7.09,-5.88,-5.91,-7.16,-7.06,-4.16,-1.59,-0.5,0.97,5.0,8.59,9.38,8.5,8.97,9.38,7.62,4.81,3.78,4.78,4.66,2.88,1.72,3.0,3.69,2.59,1.94,3.41,5.56,5.91,4.94,5.88,7.94,7.75,5.72,4.62,5.03,4.06,1.03,-1.28,-0.94,-0.31,-1.38,-2.25,0.09,3.19,4.09,3.25,3.44,4.12,2.88,-0.03,-1.88,-1.12,-1.31,-3.34,-5.09,-4.34,-3.44,-4.44,-6.31,-6.16,-5.25,-5.72,-7.22,-7.19,-4.44,-2.62,-2.12,-1.0,2.56,5.38,5.47,4.91,6.06,7.53,6.88,5.12,4.88,5.59,4.59,1.12,-1.22,-1.94,-3.56,-7.56,-10.75,-11.62,-12.06,-14.59,-16.78,-15.84,-13.19,-11.22,-9.75,-6.44,-1.72,1.16,1.16,1.75,3.81,4.78,3.5,2.22,3.0,3.91,2.78,1.06,0.97,1.47,0.28,-2.5,-3.97,-3.75,-4.19,-6.66,-8.22,-7.12,-6.88,-8.66,-10.75,-10.72,-10.09,-10.94,-11.75,-10.19,-7.16,-5.38,-5.66,-4.94,-3.41,-2.88,-4.62,-5.94,-4.78,-3.56,-4.72,-7.19,-8.38,-9.47,-12.78,-17.5,-20.31,-21.44,-22.88,-25.34,-26.47,-24.41,-22.22,-22.22,-21.72,-18.75,-15.56,-13.69,-12.66,-9.69,-5.88,-4.16,-4.59,-4.62,-3.69,-4.09,-6.88,-9.31,-9.38,-9.59,-11.25,-13.31,-13.03,-11.47,-11.31,-11.59,-9.84,-6.88,-5.09,-5.38,-4.84,-2.66,-1.22,-2.16,-2.91,-1.81,-0.44,-1.09,-1.75,0.19,3.25,4.69,4.06,4.28,4.25,2.88,-1.09,-4.09,-4.78,-5.09,-6.56,-7.84,-6.81,-5.03,-5.12,-6.03,-4.81,-2.59,-1.47,-2.09,-1.44,0.53,2.09,1.59,2.03,4.69,7.78,8.75,9.47,11.62,13.88,13.66,12.28,11.91,12.44,11.75,9.19,7.69,7.94,7.88,6.19,4.94,5.78,6.91,5.78,4.12,3.75,4.22,3.0,0.16,-1.28,-0.94,-1.44,-3.56,-4.03,-2.59,-0.88,-1.06,-2.25,-1.81,-1.28,-3.16,-5.91,-7.0,-6.22,-5.59,-6.03,-4.84,-2.5,-1.09,-3.03,-5.84,-7.56,-9.31,-13.38,-17.31,-19.0,-18.69,-19.69,-21.09,-21.25,-19.84,-19.5,-20.5,-20.56,-18.25,-15.56,-14.69,-14.0,-12.0,-9.78,-10.53,-12.19,-12.69,-11.75,-11.97,-12.81,-12.38,-9.91,-8.47,-9.38,-10.44,-10.0,-9.62,-11.25,-12.81,-11.81,-9.56,-8.97,-9.41,-9.09,-8.41,-9.06,-11.56,-12.28,-10.03,-7.38,-6.22,-4.75,-1.34,1.84,2.53,2.38,3.75,5.75,5.75,4.16,3.59,4.22,3.59,0.75,-1.5,-1.5,-1.88,-3.66,-5.44,-4.94,-3.69,-4.5,-5.78,-6.19,-5.12,-5.38,-6.81,-7.38,-6.03,-5.09,-6.03,-6.78,-5.25,-3.59,-3.59,-3.94,-2.03,0.72,1.47,0.97,1.03,2.44,2.44,0.69,-0.75,-0.5,-0.69,-3.38,-6.44,-7.34,-7.91,-10.31,-12.94,-13.75,-12.56,-12.28,-12.5,-11.5,-8.12,-5.72,-5.06,-4.34,-2.06,-0.25,-0.56,-1.56,-0.66,1.0,0.72,-0.78,-0.38,1.28,1.53,-0.03,-1.47,-0.94,-1.03,-2.88,-4.38,-3.34,-1.94,-2.72,-3.94,-2.94,-0.34,0.88,1.41,3.12,6.25,7.69,6.84,5.62,6.16,5.84,3.34,0.75,0.97,1.78,1.59,0.75,1.41,2.72,2.16,-0.59,-2.62,-2.81,-3.81,-6.22,-7.31,-5.66,-3.38,-2.5,-2.56,-0.91,0.84,0.47,-0.72,0.47,3.41,5.75,6.56,7.97,11.09,13.19,13.16,12.44,13.0,13.31,10.91,7.22,4.88,3.84,1.38,-2.25,-3.69,-3.16,-3.0,-4.59,-5.31,-3.75,-2.28,-2.31,-2.59,-0.5,2.06,2.78,1.94,3.03,5.31,6.41,5.75,5.91,7.78,8.25,6.03,3.91,3.72,3.34,0.75,-2.34,-2.91,-2.25,-3.16,-4.38,-3.62,-1.12,0.38,0.38,0.88,3.59,5.25,4.03,2.97,3.69,4.91,4.19,2.81,3.09,4.06,3.16,0.06,-1.94,-2.28,-2.75,-4.91,-5.44,-3.5,-6.22,-3.72,-2.38,-2.19,-2.19,-1.91,-2.84,-5.38,-7.5,-8.34,-9.0,-10.91,-12.84,-13.56,-14.0,-15.44,-16.59,-16.75,-15.06,-13.78,-12.97,-11.44,-8.78,-6.66,-6.44,-6.78,-6.44,-6.66:-18.81,-16.66,-16.03,-14.5,-10.97,-7.59,-7.25,-8.53,-7.84,-6.47,-7.19,-9.09,-9.44,-8.72,-9.25,-10.88,-12.09,-10.81,-9.88,-11.25,-12.69,-11.31,-9.28,-9.12,-9.56,-7.88,-5.19,-4.25,-5.06,-5.06,-3.53,-3.59,-5.81,-7.78,-7.38,-7.31,-9.38,-12.16,-12.94,-13.12,-15.38,-18.53,-19.03,-17.34,-16.19,-16.25,-14.88,-11.38,-8.72,-8.72,-8.97,-7.5,-5.91,-7.12,-9.03,-8.56,-7.16,-7.94,-10.5,-11.84,-11.94,-13.5,-16.56,-18.5,-17.25,-15.94,-16.28,-16.34,-14.12,-11.59,-10.78,-10.88,-9.22,-6.88,-5.88,-7.28,-7.56,-6.12,-5.72,-7.38,-8.69,-7.97,-7.69,-9.66,-12.31,-12.69,-12.38,-13.69,-15.47,-15.34,-14.0,-13.84,-15.56,-16.59,-15.69,-14.88,-15.88,-16.47,-14.25,-11.97,-11.91,-13.12,-12.47,-10.97,-10.66,-11.44,-10.03,-7.12,-5.38,-6.06,-6.12,-4.72,-3.81,-5.44,-8.0,-8.78,-9.25,-11.06,-13.25,-12.81,-10.91,-9.84,-10.62,-10.81,-9.03,-8.0,-8.72,-9.38,-6.84,-4.06,-3.09,-2.59,-0.19,2.34,2.91,1.78,1.38,2.0,1.19,-1.34,-2.81,-2.19,-1.84,-3.19,-4.47,-3.97,-2.84,-3.56,-4.91,-4.38,-2.81,-2.34,-3.41,-3.41,-2.19,-1.66,-3.62,-4.94,-3.78,-2.19,-2.34,-3.06,-2.03,-1.03,-2.12,-4.72,-5.97,-6.25,-7.66,-10.72,-12.62,-12.0,-11.06,-12.0,-12.28,-10.5,-8.88,-9.62,-11.28,-11.44,-10.59,-10.69,-11.44,-10.38,-7.56,-5.5,-6.38,-6.84,-5.69,-4.88,-6.22,-8.16,-7.91,-6.97,-8.34,-10.03,-9.75,-7.84,-7.41,-8.47,-8.72,-7.84,-7.81,-10.38,-12.59,-13.16,-13.34,-15.44,-17.97,-18.19,-17.44,-17.91,-19.66,-20.28,-19.38,-19.16,-20.59,-20.28,-17.06,-13.41,-11.56,-9.66,-5.97,-1.97,-0.5,-0.03,1.44,3.22,2.75,-0.09,-2.66,-4.19,-6.84,-11.25,-14.47,-14.75,-14.34,-15.62,-17.09,-16.72,-15.59,-15.91,-16.59,-16.12,-14.03,-13.31,-14.38,-15.03,-13.72,-12.91,-14.44,-16.03,-15.62,-14.5,-15.16,-15.31,-13.22,-9.53,-7.53,-6.44,-4.44,-1.22,1.09,1.66,2.03,3.5,3.94,1.56,-1.59,-2.97,-3.59,-5.53,-8.03,-8.25,-6.53,-5.91,-6.31,-5.81,-3.59,-2.12,-2.47,-2.78,-0.81,1.22,1.44,0.41,0.56,1.53,0.5,-1.34,-1.88,-0.81,-0.62,-2.16,-3.0,-2.0,-0.97,-2.47,-3.78,-3.0,-1.81,-2.75,-4.44,-4.66,-3.88,-4.53,-6.12,-6.69,-4.91,-3.62,-4.25,-4.75,-3.31,-2.28,-3.53,-5.19,-4.72,-3.22,-3.22,-4.03,-3.84,-2.53,-3.0,-5.25,-6.41,-5.41,-4.06,-4.16,-4.66,-3.41,-2.03,-2.84,-4.56,-4.09,-2.0,-1.38,-1.28,-0.09,2.41,3.72,2.91,2.0,2.91,3.88,2.97,1.62,2.34,3.66,2.75,1.09,1.03,2.88,4.0,4.25,5.75,8.94,11.12,10.94,10.78,13.06,15.34,15.56,14.81,14.84,15.03,12.78,8.69,5.81,4.41,1.94,-1.88,-4.53,-4.59,-4.47,-5.5,-6.25,-4.66,-2.62,-2.34,-3.25,-2.78,-0.94,-1.03,-2.5,-3.19,-1.94,-1.31,-2.81,-4.03,-3.5,-2.84,-4.38,-5.56,-3.59,-0.25,1.62,2.69,4.81,7.72,8.97,8.22,7.5,7.97,8.03,5.19,2.28,1.12,0.19,-2.88,-6.81,-8.38,-8.59,-8.69,-9.78,-8.84,-5.97,-3.94,-4.19,-4.47,-2.66,-0.97,-1.28,-2.28,-1.16,0.25,-0.34,-2.84,-3.72,-3.97,-5.62,-8.88,-11.0,-10.75,-10.84,-12.47,-13.66,-12.16,-10.44,-10.53,-11.41,-10.78,-9.41,-9.81,-11.44,-10.97,-9.16,-7.91,-8.59,-8.91,-7.56,-6.31,-7.06,-7.53,-5.72,-3.44,-3.44,-5.22,-6.16,-6.5,-9.06,-13.34,-15.59,-15.75,-15.34,-16.38,-16.56,-14.56,-13.38,-15.03,-17.5,-17.59,-16.72,-16.66,-16.75,-14.72,-10.91,-7.75,-6.69,-4.75,-1.09,1.62,2.0,2.03,4.03,5.91,5.62,3.91,3.44,3.59,1.34,-2.66,-5.25,-5.88,-6.81,-8.97,-10.06,-8.66,-7.34,-8.81,-10.56,-11.31,-11.34,-13.44,-16.34,-16.97,-15.28,-14.12,-14.12,-12.16,-7.69,-3.84,-2.69,-1.22,1.28,3.41,1.91,-0.56,-1.47,-1.59,-3.06,-5.56,-5.78,-3.88,-2.72,-3.28,-3.19,-1.06,0.22,-1.03,-2.56,-2.34,-1.5,-3.0,-5.38,-5.47,-4.22,-4.03,-4.81,-4.03,-1.09,1.41,1.22,1.31,3.03,4.31,2.81,0.91,0.69,1.44,-0.03,-2.22,-2.38,-0.72,0.56,-0.06,0.66,3.09,4.91,4.53,4.06,5.69,7.34,6.62,5.16,5.5,7.47,7.59,6.94,7.78,9.84,10.66,9.25,7.88,8.28,7.81,5.16,2.28,2.25,3.28,2.72,1.38,1.81,3.91,4.38,3.84,5.31,9.28,12.0,12.0,11.28,11.34,10.56,6.31,1.44,-1.5,-3.38,-7.03,-11.22,-12.72,-11.47,-11.12,-11.41,-10.38,-6.81,-3.94,-3.28,-2.38,0.62,4.5,5.69,5.88,7.66,10.19,10.5,9.44,9.59,11.28,11.69,9.91,8.06,8.06,7.0,3.38,-0.38,-1.88,-2.28,-4.22,-6.62,-7.09,-5.88,-5.91,-7.16,-7.06,-4.16,-1.59,-0.5,0.97,5.0,8.59,9.38,8.5,8.97,9.38,7.62,4.81,3.78,4.78,4.66,2.88,1.72,3.0,3.69,2.59,1.94,3.41,5.56,5.91,4.94,5.88,7.94,7.75,5.72,4.62,5.03,4.06,1.03,-1.28,-0.94,-0.31,-1.38,-2.25,0.09,3.19,4.09,3.25,3.44,4.12,2.88,-0.03,-1.88,-1.12,-1.31,-3.34,-5.09,-4.34,-3.44,-4.44,-6.31,-6.16,-5.25,-5.72,-7.22,-7.19,-4.44,-2.62,-2.12,-1.0,2.56,5.38,5.47,4.91,6.06,7.53,6.88,5.12,4.88,5.59,4.59,1.12,-1.22,-1.94,-3.56,-7.56,-10.75,-11.62,-12.06,-14.59,-16.78,-15.84,-13.19,-11.22,-9.75,-6.44,-1.72,1.16,1.16,1.75,3.81,4.78,3.5,2.22,3.0,3.91,2.78,1.06,0.97,1.47,0.28,-2.5,-3.97,-3.75,-4.19,-6.66,-8.22,-7.12,-6.88,-8.66,-10.75,-10.72,-10.09,-10.94,-11.75,-10.19,-7.16,-5.38,-5.66,-4.94,-3.41,-2.88,-4.62,-5.94,-4.78,-3.56,-4.72,-7.19,-8.38,-9.47,-12.78,-17.5,-20.31,-21.44,-22.88,-25.34,-26.47,-24.41,-22.22,-22.22,-21.72,-18.75,-15.56,-13.69,-12.66,-9.69,-5.88,-4.16,-4.59,-4.62,-3.69,-4.09,-6.88,-9.31,-9.38,-9.59,-11.25,-13.31,-13.03,-11.47,-11.31,-11.59,-9.84,-6.88,-5.09,-5.38,-4.84,-2.66,-1.22,-2.16,-2.91,-1.81,-0.44,-1.09,-1.75,0.19,3.25,4.69,4.06,4.28,4.25,2.88,-1.09,-4.09,-4.78,-5.09,-6.56,-7.84,-6.81,-5.03,-5.12,-6.03,-4.81,-2.59,-1.47,-2.09,-1.44,0.53,2.09,1.59,2.03,4.69,7.78,8.75,9.47,11.62,13.88,13.66,12.28,11.91,12.44,11.75,9.19,7.69,7.94,7.88,6.19,4.94,5.78,6.91,5.78,4.12,3.75,4.22,3.0,0.16,-1.28,-0.94,-1.44,-3.56,-4.03,-2.59,-0.88,-1.06,-2.25,-1.81,-1.28,-3.16,-5.91,-7.0,-6.22,-5.59,-6.03,-4.84,-2.5,-1.09,-3.03,-5.84,-7.56,-9.31,-13.38,-17.31,-19.0,-18.69,-19.69,-21.09,-21.25,-19.84,-19.5,-20.5,-20.56,-18.25,-15.56,-14.69,-14.0,-12.0,-9.78,-10.53,-12.19,-12.69,-11.75,-11.97,-12.81,-12.38,-9.91,-8.47,-9.38,-10.44,-10.0,-9.62,-11.25,-12.81,-11.81,-9.56,-8.97,-9.41,-9.09,-8.41,-9.06,-11.56,-12.28,-10.03,-7.38,-6.22,-4.75,-1.34,1.84,2.53,2.38,3.75,5.75,5.75,4.16,3.59,4.22,3.59,0.75,-1.5,-1.5,-1.88,-3.66,-5.44,-4.94,-3.69,-4.5,-5.78,-6.19,-5.12,-5.38,-6.81,-7.38,-6.03,-5.09,-6.03,-6.78,-5.25,-3.59,-3.59,-3.94,-2.03,0.72,1.47,0.97,1.03,2.44,2.44,0.69,-0.75,-0.5,-0.69,-3.38,-6.44,-7.34,-7.91,-10.31,-12.94,-13.75,-12.56,-12.28,-12.5,-11.5,-8.12,-5.72,-5.06,-4.34,-2.06,-0.25,-0.56,-1.56,-0.66,1.0,0.72,-0.78,-0.38,1.28,1.53,-0.03,-1.47,-0.94,-1.03,-2.88,-4.38,-3.34,-1.94,-2.72,-3.94,-2.94,-0.34,0.88,1.41,3.12,6.25,7.69,6.84,5.62,6.16,5.84,3.34,0.75,0.97,1.78,1.59,0.75,1.41,2.72,2.16,-0.59,-2.62,-2.81,-3.81,-6.22,-7.31,-5.66,-3.38,-2.5,-2.56,-0.91,0.84,0.47,-0.72,0.47,3.41,5.75,6.56,7.97,11.09,13.19,13.16,12.44,13.0,13.31,10.91,7.22,4.88,3.84,1.38,-2.25,-3.69,-3.16,-3.0,-4.59,-5.31,-3.75,-2.28,-2.31,-2.59,-0.5,2.06,2.78,1.94,3.03,5.31,6.41,5.75,5.91,7.78,8.25,6.03,3.91,3.72,3.34,0.75,-2.34,-2.91,-2.25,-3.16,-4.38,-3.62,-1.12,0.38,0.38,0.88,3.59,5.25,4.03,2.97,3.69,4.91,4.19,2.81,3.09,4.06,3.16,0.06,-1.94,-2.28,-2.75,-4.91,-5.44,-3.5,-6.22,-3.72,-2.38,-2.19,-2.19,-1.91,-2.84,-5.38,-7.5,-8.34,-9.0,-10.91,-12.84,-13.56,-14.0,-15.44,-16.59,-16.75,-15.06,-13.78,-12.97,-11.44,-8.78,-6.66,-6.44,-6.78,-6.44,-6.66,-9.34,-12.97,-15.41,-17.03,-18.69,-20.09,-19.69:-8.53,-7.84,-6.47,-7.19,-9.09,-9.44,-8.72,-9.25,-10.88,-12.09,-10.81,-9.88,-11.25,-12.69,-11.31,-9.28,-9.12,-9.56,-7.88,-5.19,-4.25,-5.06,-5.06,-3.53,-3.59,-5.81,-7.78,-7.38,-7.31,-9.38,-12.16,-12.94,-13.12,-15.38,-18.53,-19.03,-17.34,-16.19,-16.25,-14.88,-11.38,-8.72,-8.72,-8.97,-7.5,-5.91,-7.12,-9.03,-8.56,-7.16,-7.94,-10.5,-11.84,-11.94,-13.5,-16.56,-18.5,-17.25,-15.94,-16.28,-16.34,-14.12,-11.59,-10.78,-10.88,-9.22,-6.88,-5.88,-7.28,-7.56,-6.12,-5.72,-7.38,-8.69,-7.97,-7.69,-9.66,-12.31,-12.69,-12.38,-13.69,-15.47,-15.34,-14.0,-13.84,-15.56,-16.59,-15.69,-14.88,-15.88,-16.47,-14.25,-11.97,-11.91,-13.12,-12.47,-10.97,-10.66,-11.44,-10.03,-7.12,-5.38,-6.06,-6.12,-4.72,-3.81,-5.44,-8.0,-8.78,-9.25,-11.06,-13.25,-12.81,-10.91,-9.84,-10.62,-10.81,-9.03,-8.0,-8.72,-9.38,-6.84,-4.06,-3.09,-2.59,-0.19,2.34,2.91,1.78,1.38,2.0,1.19,-1.34,-2.81,-2.19,-1.84,-3.19,-4.47,-3.97,-2.84,-3.56,-4.91,-4.38,-2.81,-2.34,-3.41,-3.41,-2.19,-1.66,-3.62,-4.94,-3.78,-2.19,-2.34,-3.06,-2.03,-1.03,-2.12,-4.72,-5.97,-6.25,-7.66,-10.72,-12.62,-12.0,-11.06,-12.0,-12.28,-10.5,-8.88,-9.62,-11.28,-11.44,-10.59,-10.69,-11.44,-10.38,-7.56,-5.5,-6.38,-6.84,-5.69,-4.88,-6.22,-8.16,-7.91,-6.97,-8.34,-10.03,-9.75,-7.84,-7.41,-8.47,-8.72,-7.84,-7.81,-10.38,-12.59,-13.16,-13.34,-15.44,-17.97,-18.19,-17.44,-17.91,-19.66,-20.28,-19.38,-19.16,-20.59,-20.28,-17.06,-13.41,-11.56,-9.66,-5.97,-1.97,-0.5,-0.03,1.44,3.22,2.75,-0.09,-2.66,-4.19,-6.84,-11.25,-14.47,-14.75,-14.34,-15.62,-17.09,-16.72,-15.59,-15.91,-16.59,-16.12,-14.03,-13.31,-14.38,-15.03,-13.72,-12.91,-14.44,-16.03,-15.62,-14.5,-15.16,-15.31,-13.22,-9.53,-7.53,-6.44,-4.44,-1.22,1.09,1.66,2.03,3.5,3.94,1.56,-1.59,-2.97,-3.59,-5.53,-8.03,-8.25,-6.53,-5.91,-6.31,-5.81,-3.59,-2.12,-2.47,-2.78,-0.81,1.22,1.44,0.41,0.56,1.53,0.5,-1.34,-1.88,-0.81,-0.62,-2.16,-3.0,-2.0,-0.97,-2.47,-3.78,-3.0,-1.81,-2.75,-4.44,-4.66,-3.88,-4.53,-6.12,-6.69,-4.91,-3.62,-4.25,-4.75,-3.31,-2.28,-3.53,-5.19,-4.72,-3.22,-3.22,-4.03,-3.84,-2.53,-3.0,-5.25,-6.41,-5.41,-4.06,-4.16,-4.66,-3.41,-2.03,-2.84,-4.56,-4.09,-2.0,-1.38,-1.28,-0.09,2.41,3.72,2.91,2.0,2.91,3.88,2.97,1.62,2.34,3.66,2.75,1.09,1.03,2.88,4.0,4.25,5.75,8.94,11.12,10.94,10.78,13.06,15.34,15.56,14.81,14.84,15.03,12.78,8.69,5.81,4.41,1.94,-1.88,-4.53,-4.59,-4.47,-5.5,-6.25,-4.66,-2.62,-2.34,-3.25,-2.78,-0.94,-1.03,-2.5,-3.19,-1.94,-1.31,-2.81,-4.03,-3.5,-2.84,-4.38,-5.56,-3.59,-0.25,1.62,2.69,4.81,7.72,8.97,8.22,7.5,7.97,8.03,5.19,2.28,1.12,0.19,-2.88,-6.81,-8.38,-8.59,-8.69,-9.78,-8.84,-5.97,-3.94,-4.19,-4.47,-2.66,-0.97,-1.28,-2.28,-1.16,0.25,-0.34,-2.84,-3.72,-3.97,-5.62,-8.88,-11.0,-10.75,-10.84,-12.47,-13.66,-12.16,-10.44,-10.53,-11.41,-10.78,-9.41,-9.81,-11.44,-10.97,-9.16,-7.91,-8.59,-8.91,-7.56,-6.31,-7.06,-7.53,-5.72,-3.44,-3.44,-5.22,-6.16,-6.5,-9.06,-13.34,-15.59,-15.75,-15.34,-16.38,-16.56,-14.56,-13.38,-15.03,-17.5,-17.59,-16.72,-16.66,-16.75,-14.72,-10.91,-7.75,-6.69,-4.75,-1.09,1.62,2.0,2.03,4.03,5.91,5.62,3.91,3.44,3.59,1.34,-2.66,-5.25,-5.88,-6.81,-8.97,-10.06,-8.66,-7.34,-8.81,-10.56,-11.31,-11.34,-13.44,-16.34,-16.97,-15.28,-14.12,-14.12,-12.16,-7.69,-3.84,-2.69,-1.22,1.28,3.41,1.91,-0.56,-1.47,-1.59,-3.06,-5.56,-5.78,-3.88,-2.72,-3.28,-3.19,-1.06,0.22,-1.03,-2.56,-2.34,-1.5,-3.0,-5.38,-5.47,-4.22,-4.03,-4.81,-4.03,-1.09,1.41,1.22,1.31,3.03,4.31,2.81,0.91,0.69,1.44,-0.03,-2.22,-2.38,-0.72,0.56,-0.06,0.66,3.09,4.91,4.53,4.06,5.69,7.34,6.62,5.16,5.5,7.47,7.59,6.94,7.78,9.84,10.66,9.25,7.88,8.28,7.81,5.16,2.28,2.25,3.28,2.72,1.38,1.81,3.91,4.38,3.84,5.31,9.28,12.0,12.0,11.28,11.34,10.56,6.31,1.44,-1.5,-3.38,-7.03,-11.22,-12.72,-11.47,-11.12,-11.41,-10.38,-6.81,-3.94,-3.28,-2.38,0.62,4.5,5.69,5.88,7.66,10.19,10.5,9.44,9.59,11.28,11.69,9.91,8.06,8.06,7.0,3.38,-0.38,-1.88,-2.28,-4.22,-6.62,-7.09,-5.88,-5.91,-7.16,-7.06,-4.16,-1.59,-0.5,0.97,5.0,8.59,9.38,8.5,8.97,9.38,7.62,4.81,3.78,4.78,4.66,2.88,1.72,3.0,3.69,2.59,1.94,3.41,5.56,5.91,4.94,5.88,7.94,7.75,5.72,4.62,5.03,4.06,1.03,-1.28,-0.94,-0.31,-1.38,-2.25,0.09,3.19,4.09,3.25,3.44,4.12,2.88,-0.03,-1.88,-1.12,-1.31,-3.34,-5.09,-4.34,-3.44,-4.44,-6.31,-6.16,-5.25,-5.72,-7.22,-7.19,-4.44,-2.62,-2.12,-1.0,2.56,5.38,5.47,4.91,6.06,7.53,6.88,5.12,4.88,5.59,4.59,1.12,-1.22,-1.94,-3.56,-7.56,-10.75,-11.62,-12.06,-14.59,-16.78,-15.84,-13.19,-11.22,-9.75,-6.44,-1.72,1.16,1.16,1.75,3.81,4.78,3.5,2.22,3.0,3.91,2.78,1.06,0.97,1.47,0.28,-2.5,-3.97,-3.75,-4.19,-6.66,-8.22,-7.12,-6.88,-8.66,-10.75,-10.72,-10.09,-10.94,-11.75,-10.19,-7.16,-5.38,-5.66,-4.94,-3.41,-2.88,-4.62,-5.94,-4.78,-3.56,-4.72,-7.19,-8.38,-9.47,-12.78,-17.5,-20.31,-21.44,-22.88,-25.34,-26.47,-24.41,-22.22,-22.22,-21.72,-18.75,-15.56,-13.69,-12.66,-9.69,-5.88,-4.16,-4.59,-4.62,-3.69,-4.09,-6.88,-9.31,-9.38,-9.59,-11.25,-13.31,-13.03,-11.47,-11.31,-11.59,-9.84,-6.88,-5.09,-5.38,-4.84,-2.66,-1.22,-2.16,-2.91,-1.81,-0.44,-1.09,-1.75,0.19,3.25,4.69,4.06,4.28,4.25,2.88,-1.09,-4.09,-4.78,-5.09,-6.56,-7.84,-6.81,-5.03,-5.12,-6.03,-4.81,-2.59,-1.47,-2.09,-1.44,0.53,2.09,1.59,2.03,4.69,7.78,8.75,9.47,11.62,13.88,13.66,12.28,11.91,12.44,11.75,9.19,7.69,7.94,7.88,6.19,4.94,5.78,6.91,5.78,4.12,3.75,4.22,3.0,0.16,-1.28,-0.94,-1.44,-3.56,-4.03,-2.59,-0.88,-1.06,-2.25,-1.81,-1.28,-3.16,-5.91,-7.0,-6.22,-5.59,-6.03,-4.84,-2.5,-1.09,-3.03,-5.84,-7.56,-9.31,-13.38,-17.31,-19.0,-18.69,-19.69,-21.09,-21.25,-19.84,-19.5,-20.5,-20.56,-18.25,-15.56,-14.69,-14.0,-12.0,-9.78,-10.53,-12.19,-12.69,-11.75,-11.97,-12.81,-12.38,-9.91,-8.47,-9.38,-10.44,-10.0,-9.62,-11.25,-12.81,-11.81,-9.56,-8.97,-9.41,-9.09,-8.41,-9.06,-11.56,-12.28,-10.03,-7.38,-6.22,-4.75,-1.34,1.84,2.53,2.38,3.75,5.75,5.75,4.16,3.59,4.22,3.59,0.75,-1.5,-1.5,-1.88,-3.66,-5.44,-4.94,-3.69,-4.5,-5.78,-6.19,-5.12,-5.38,-6.81,-7.38,-6.03,-5.09,-6.03,-6.78,-5.25,-3.59,-3.59,-3.94,-2.03,0.72,1.47,0.97,1.03,2.44,2.44,0.69,-0.75,-0.5,-0.69,-3.38,-6.44,-7.34,-7.91,-10.31,-12.94,-13.75,-12.56,-12.28,-12.5,-11.5,-8.12,-5.72,-5.06,-4.34,-2.06,-0.25,-0.56,-1.56,-0.66,1.0,0.72,-0.78,-0.38,1.28,1.53,-0.03,-1.47,-0.94,-1.03,-2.88,-4.38,-3.34,-1.94,-2.72,-3.94,-2.94,-0.34,0.88,1.41,3.12,6.25,7.69,6.84,5.62,6.16,5.84,3.34,0.75,0.97,1.78,1.59,0.75,1.41,2.72,2.16,-0.59,-2.62,-2.81,-3.81,-6.22,-7.31,-5.66,-3.38,-2.5,-2.56,-0.91,0.84,0.47,-0.72,0.47,3.41,5.75,6.56,7.97,11.09,13.19,13.16,12.44,13.0,13.31,10.91,7.22,4.88,3.84,1.38,-2.25,-3.69,-3.16,-3.0,-4.59,-5.31,-3.75,-2.28,-2.31,-2.59,-0.5,2.06,2.78,1.94,3.03,5.31,6.41,5.75,5.91,7.78,8.25,6.03,3.91,3.72,3.34,0.75,-2.34,-2.91,-2.25,-3.16,-4.38,-3.62,-1.12,0.38,0.38,0.88,3.59,5.25,4.03,2.97,3.69,4.91,4.19,2.81,3.09,4.06,3.16,0.06,-1.94,-2.28,-2.75,-4.91,-5.44,-3.5,-6.22,-3.72,-2.38,-2.19,-2.19,-1.91,-2.84,-5.38,-7.5,-8.34,-9.0,-10.91,-12.84,-13.56,-14.0,-15.44,-16.59,-16.75,-15.06,-13.78,-12.97,-11.44,-8.78,-6.66,-6.44,-6.78,-6.44,-6.66,-9.34,-12.97,-15.41,-17.03,-18.69,-20.09,-19.69,-17.44,-15.62,-14.72,-13.47,-11.03,-8.97,-8.97:positivity
20.5,16.47,14.69,14.88,13.75,12.25,12.59,15.44,17.97,19.31,21.38,26.0,29.81,30.5,29.09,28.69,27.78,24.28,19.25,16.25,14.81,12.75,9.84,8.78,10.59,12.12,11.41,11.09,13.56,16.31,16.81,16.69,18.28,20.03,19.41,17.25,17.09,18.22,18.06,16.34,15.91,17.78,19.47,19.0,18.25,19.12,19.84,18.03,15.47,15.25,16.41,16.5,15.5,16.12,18.34,19.09,18.31,18.56,21.47,23.84,24.06,23.91,24.91,25.19,23.06,19.97,19.03,18.94,17.09,13.59,11.22,10.75,9.62,7.19,5.97,7.44,8.88,8.47,8.44,10.84,14.09,15.28,15.16,17.0,20.03,21.38,21.25,22.19,24.09,24.31,21.56,18.44,17.66,16.88,14.62,12.72,13.56,15.31,15.62,14.62,15.5,17.38,17.78,16.0,14.75,14.94,14.53,12.47,11.09,12.75,15.0,14.72,13.31,13.12,13.03,10.31,6.53,4.53,4.66,3.56,0.94,-0.84,-0.75,-1.81,-4.69,-7.12,-6.44,-4.75,-4.16,-2.88,0.75,5.47,8.72,10.03,11.69,14.0,14.5,12.06,9.97,9.56,8.84,6.44,4.06,4.5,5.06,3.38,0.47,-1.06,-1.75,-3.84,-7.16,-8.12,-6.59,-5.16,-4.97,-3.19,1.25,4.81,5.5,5.38,6.91,7.72,6.25,3.28,1.41,0.03,-3.0,-7.06,-9.62,-9.88,-9.94,-11.5,-11.06,-7.31,-2.66,0.22,2.75,6.56,9.31,8.97,5.75,3.62,1.62,-1.94,-7.03,-10.09,-10.28,-10.5,-12.19,-12.34,-10.59,-8.81,-8.38,-7.5,-3.44,1.31,4.97,7.06,9.88,12.97,14.19,13.28,12.97,15.47,17.59,17.69,18.88,22.03,24.69,24.09,22.28,21.75,21.06,19.22,16.44,15.31,16.31,16.34,14.81,14.0,14.62,14.78,12.34,10.56,11.19,12.56,11.75,10.5,11.5,12.5,12.66,11.25,11.78,14.12,15.31,14.56,14.16,15.19,15.0,12.03,8.75,7.78,7.28,5.28,3.0,3.12,4.41,3.72,2.5,3.31,5.84,7.88,7.78,7.97,9.47,10.69,9.25,7.97,9.47,12.31,13.44,13.75,15.56,17.75,18.06,16.38,16.25,17.38,17.88,15.97,14.56,14.78,14.94,12.97,10.91,11.0,11.84,10.56,7.75,6.56,6.53,6.0,4.5,4.69,6.94,8.38,7.31,6.31,6.97,8.44,7.97,7.41,9.12,12.06,13.0,12.81,14.0,16.56,17.81,17.34,17.78,19.75,21.03,19.84,18.66,19.19,19.75,17.81,16.09,16.5,17.97,17.88,16.28,15.81,16.06,15.41,13.31,13.12,15.5,18.59,19.91,21.66,24.97,27.72,27.12,24.94,23.62,23.12,21.31,18.25,16.75,17.19,17.09,14.88,13.47,13.72,13.22,9.94,6.56,5.69,6.03,4.91,3.97,5.34,7.97,9.38,9.62,11.19,14.53,17.47,18.12,19.5,22.66,25.09,24.38,22.91,22.81,23.03,21.41,19.19,18.66,19.22,18.47,16.09,14.72,15.34,15.47,13.34,12.12,12.84,13.94,13.19,12.0,12.78,13.91,12.88,10.81,10.03,10.5,9.25,6.75,5.38,6.5,7.94,7.94,8.47,11.28,13.78,13.03,11.38,10.78,10.78,9.25,7.09,7.19,9.03,9.56,7.78,6.06,5.53,4.62,1.75,0.38,2.56,6.34,9.09,11.41,15.03,18.72,19.97,18.91,18.78,20.22,20.59,19.0,18.06,18.28,17.75,14.78,12.38,12.78,14.56,14.91,14.53,15.19,16.44,15.53,13.19,12.31,13.38,14.0,13.0,12.91,15.25,17.47,17.16,16.66,17.78,19.31,17.91,15.22,14.09,14.16,12.91,11.06,11.09,13.12,14.91,14.38,14.25,15.72,16.97,15.59,13.91,14.19,15.69,15.91,15.16,16.03,17.72,17.38,14.59,12.5,12.06,11.16,8.53,6.56,7.44,8.66,8.06,7.12,8.38,10.5,10.5,10.09,11.06,13.66,15.06,15.0,16.03,18.88,20.66,20.12,19.16,19.28,19.66,18.12,15.91,15.69,17.38,18.03,18.19,20.69,25.03,28.16,28.91,29.16,30.03,30.12,27.31,24.47,23.69,23.56,21.69,18.88,17.66,17.34,15.28,11.69,9.34,8.94,8.28,6.5,6.41,9.56,12.66,14.12,15.25,17.91,21.19,22.44,22.5,23.47,25.53,25.47,23.69,22.72,23.97,24.41,23.34,23.22,25.22,27.06,26.22,24.75,24.94,25.12,23.19,20.62,19.38,19.94,19.97,18.97,18.97,21.12,22.12,20.81,19.66,20.72,21.31,19.78,17.88,17.59,18.19,17.53,16.25,16.69,19.12,20.66,20.59,21.56,23.97,25.22,23.78,21.75,21.56,20.94,18.59,16.12,15.88,17.28,17.88,18.22,20.19,23.47,25.0,24.44,23.72,24.88,25.59,24.31,23.44,24.16,24.12,21.56,17.91,15.94,15.34,14.03,12.56,12.78,15.44,17.12,17.0,16.84,18.41,19.31,17.41,15.5,15.84,16.84,16.22,14.81,15.22,17.41,18.22,18.34,19.28,22.25,23.84,22.94,22.09,23.28,23.59,21.72,19.78,19.59,20.44,19.5,17.59,17.38,18.19,17.44,15.38,14.16,14.34,13.81,11.59,9.66,10.16,10.75,10.28,9.22,10.53,12.53,13.16,12.66,13.53,15.41,15.78,14.28,13.06,13.62,13.38,11.72,9.78,10.66,12.0,11.81,11.69,13.47,15.91,16.12,14.88,14.5,15.28,15.12,13.62,12.41,13.44,14.16,13.22,12.12,13.66,15.66,15.97,15.97,17.66,20.41,21.34,20.38,20.06,20.81,20.06,17.03,14.88,15.41,15.81,14.75,13.72,15.0,16.78,16.25,14.91,15.56,17.25,17.69,17.06,17.38,19.5,20.53,19.25,17.78,18.94,19.5,17.84,15.97,16.66,17.81,17.75,16.66,17.09,18.66,18.47,16.91,16.56,18.34,20.0,19.91,19.72,21.47,22.31,20.91,18.53,18.34,18.94,17.91,15.75,14.84,14.91,13.62,10.78,9.47,10.97,12.31,11.88,11.34,12.81,14.22,13.62,12.94,14.69,16.66,16.75,14.72,13.53,13.69,12.97,11.56,11.41,13.38,15.03,14.56,13.5,14.38,15.91,15.72,14.56,15.69,17.56,17.53,15.78,15.06,15.56,15.47,13.47,12.41,13.91,15.34,14.41,13.47,14.5,15.84,15.28,13.84,14.38,15.5,15.22,13.66,13.72,15.59,17.28,17.19,17.28,19.09,20.31,19.28,17.59,18.69,21.16,22.34,22.88,25.19,28.38,29.44,28.47,27.88,28.81,28.16,25.69,23.69,23.88,24.66,23.81,22.59,23.53,24.72,23.84,21.41,20.22,19.59,18.5,16.16,15.12,16.44,18.38,18.12,17.69,19.12,20.31,18.72,15.94,15.75,16.47,16.0,15.16,16.25,18.59,19.81,18.5,17.38,17.72,17.03,14.72,12.72,13.31,14.78,14.91,14.47,15.91,18.31,19.28,18.75,19.66,22.44,24.56,24.69,25.16,27.38,28.94,27.38,25.47,25.41,25.47,23.31,19.88,18.44,19.16,18.88,17.84,18.56,20.69,21.5,19.5,17.91,18.12,17.69,15.09,11.47,9.72,8.62,6.22,2.78,1.69,2.34,2.53,2.38,4.34,9.06,13.69,15.72,17.22,19.59,20.16,17.34,13.19,11.25,10.69,8.84,7.09,7.25,8.88,9.19,7.5,6.72,7.75,8.5,8.06,8.72,11.91,15.91,17.66,18.12,19.41,20.94,20.25,17.66,16.09,15.88,14.66,11.44,9.25,9.56,9.91,8.5,7.91,9.59,12.06,12.22,11.03,11.84,13.0,13.03,12.03,12.69,15.56,18.16,18.91,20.66,24.0,26.38,25.5,24.31,25.06,26.56,26.44,25.97,26.66,28.28,27.72,24.41,22.12,21.56,19.94,16.56,14.5,14.88,15.5,13.56,11.19,10.44,10.25,8.25,5.75,6.09,8.62,10.78,11.88,14.34,19.0,23.19,25.25,27.78,31.16,33.22,31.75,29.16,27.97,27.69,25.97,22.81,20.97,20.28,18.31,14.84,13.03,14.25,15.97,15.97,16.78,19.47,22.19,22.25,21.72,22.88,25.5,26.59,26.94,29.0,32.19,34.5,33.75,33.0,33.16,32.28,28.38,24.62,22.72,21.91,19.28,16.91,16.97,18.84,19.16,17.97,17.97,19.09,19.19,17.03,16.34,17.88,19.62,19.0,18.19,19.16,20.22,19.09,17.22,17.22,19.09,19.88,19.75,21.66,25.19,27.41,27.44,27.16,28.91,30.81,30.59,30.03,31.81,33.97,33.66,31.75,30.72,30.62,28.84,25.5,23.56,23.78,23.41,20.97,18.69,18.78,18.75,16.69,14.31,14.19,15.09,14.59,13.09,13.59,15.56,16.12,14.78,14.72,16.38,18.0,17.38,17.12,19.44,21.88,22.38,22.91,25.75,29.62,31.38,31.16,30.97,31.75,30.44,27.19,25.38,25.75,26.44,24.81,23.69,24.53,26.12,25.12,23.22,22.62,22.69,20.72,17.66,16.66,18.12,18.84,17.59,16.66,16.81,16.38,13.38,10.88,11.19,12.81,12.62,11.34,11.78,12.78,12.12,10.09,9.22,10.53,11.31,9.72,8.75,10.62,12.41,11.72,11.03,12.41,14.25,13.91,12.75,12.78,14.34,14.88,13.84,13.94,16.19,17.38,15.78,13.81,13.44,13.0,10.28,7.94,8.31,10.91,11.97,11.53,12.44,14.19,14.41,12.5,11.69,13.31,14.41,13.0,11.97,12.72,13.75,12.44,10.59,11.34,13.25,13.53,12.75,13.31,15.44,15.72,14.12,12.75,13.69,14.0,12.59,11.34,12.56,13.88,12.59:15.44,17.97,19.31,21.38,26.0,29.81,30.5,29.09,28.69,27.78,24.28,19.25,16.25,14.81,12.75,9.84,8.78,10.59,12.12,11.41,11.09,13.56,16.31,16.81,16.69,18.28,20.03,19.41,17.25,17.09,18.22,18.06,16.34,15.91,17.78,19.47,19.0,18.25,19.12,19.84,18.03,15.47,15.25,16.41,16.5,15.5,16.12,18.34,19.09,18.31,18.56,21.47,23.84,24.06,23.91,24.91,25.19,23.06,19.97,19.03,18.94,17.09,13.59,11.22,10.75,9.62,7.19,5.97,7.44,8.88,8.47,8.44,10.84,14.09,15.28,15.16,17.0,20.03,21.38,21.25,22.19,24.09,24.31,21.56,18.44,17.66,16.88,14.62,12.72,13.56,15.31,15.62,14.62,15.5,17.38,17.78,16.0,14.75,14.94,14.53,12.47,11.09,12.75,15.0,14.72,13.31,13.12,13.03,10.31,6.53,4.53,4.66,3.56,0.94,-0.84,-0.75,-1.81,-4.69,-7.12,-6.44,-4.75,-4.16,-2.88,0.75,5.47,8.72,10.03,11.69,14.0,14.5,12.06,9.97,9.56,8.84,6.44,4.06,4.5,5.06,3.38,0.47,-1.06,-1.75,-3.84,-7.16,-8.12,-6.59,-5.16,-4.97,-3.19,1.25,4.81,5.5,5.38,6.91,7.72,6.25,3.28,1.41,0.03,-3.0,-7.06,-9.62,-9.88,-9.94,-11.5,-11.06,-7.31,-2.66,0.22,2.75,6.56,9.31,8.97,5.75,3.62,1.62,-1.94,-7.03,-10.09,-10.28,-10.5,-12.19,-12.34,-10.59,-8.81,-8.38,-7.5,-3.44,1.31,4.97,7.06,9.88,12.97,14.19,13.28,12.97,15.47,17.59,17.69,18.88,22.03,24.69,24.09,22.28,21.75,21.06,19.22,16.44,15.31,16.31,16.34,14.81,14.0,14.62,14.78,12.34,10.56,11.19,12.56,11.75,10.5,11.5,12.5,12.66,11.25,11.78,14.12,15.31,14.56,14.16,15.19,15.0,12.03,8.75,7.78,7.28,5.28,3.0,3.12,4.41,3.72,2.5,3.31,5.84,7.88,7.78,7.97,9.47,10.69,9.25,7.97,9.47,12.31,13.44,13.75,15.56,17.75,18.06,16.38,16.25,17.38,17.88,15.97,14.56,14.78,14.94,12.97,10.91,11.0,11.84,10.56,7.75,6.56,6.53,6.0,4.5,4.69,6.94,8.38,7.31,6.31,6.97,8.44,7.97,7.41,9.12,12.06,13.0,12.81,14.0,16.56,17.81,17.34,17.78,19.75,21.03,19.84,18.66,19.19,19.75,17.81,16.09,16.5,17.97,17.88,16.28,15.81,16.06,15.41,13.31,13.12,15.5,18.59,19.91,21.66,24.97,27.72,27.12,24.94,23.62,23.12,21.31,18.25,16.75,17.19,17.09,14.88,13.47,13.72,13.22,9.94,6.56,5.69,6.03,4.91,3.97,5.34,7.97,9.38,9.62,11.19,14.53,17.47,18.12,19.5,22.66,25.09,24.38,22.91,22.81,23.03,21.41,19.19,18.66,19.22,18.47,16.09,14.72,15.34,15.47,13.34,12.12,12.84,13.94,13.19,12.0,12.78,13.91,12.88,10.81,10.03,10.5,9.25,6.75,5.38,6.5,7.94,7.94,8.47,11.28,13.78,13.03,11.38,10.78,10.78,9.25,7.09,7.19,9.03,9.56,7.78,6.06,5.53,4.62,1.75,0.38,2.56,6.34,9.09,11.41,15.03,18.72,19.97,18.91,18.78,20.22,20.59,19.0,18.06,18.28,17.75,14.78,12.38,12.78,14.56,14.91,14.53,15.19,16.44,15.53,13.19,12.31,13.38,14.0,13.0,12.91,15.25,17.47,17.16,16.66,17.78,19.31,17.91,15.22,14.09,14.16,12.91,11.06,11.09,13.12,14.91,14.38,14.25,15.72,16.97,15.59,13.91,14.19,15.69,15.91,15.16,16.03,17.72,17.38,14.59,12.5,12.06,11.16,8.53,6.56,7.44,8.66,8.06,7.12,8.38,10.5,10.5,10.09,11.06,13.66,15.06,15.0,16.03,18.88,20.66,20.12,19.16,19.28,19.66,18.12,15.91,15.69,17.38,18.03,18.19,20.69,25.03,28.16,28.91,29.16,30.03,30.12,27.31,24.47,23.69,23.56,21.69,18.88,17.66,17.34,15.28,11.69,9.34,8.94,8.28,6.5,6.41,9.56,12.66,14.12,15.25,17.91,21.19,22.44,22.5,23.47,25.53,25.47,23.69,22.72,23.97,24.41,23.34,23.22,25.22,27.06,26.22,24.75,24.94,25.12,23.19,20.62,19.38,19.94,19.97,18.97,18.97,21.12,22.12,20.81,19.66,20.72,21.31,19.78,17.88,17.59,18.19,17.53,16.25,16.69,19.12,20.66,20.59,21.56,23.97,25.22,23.78,21.75,21.56,20.94,18.59,16.12,15.88,17.28,17.88,18.22,20.19,23.47,25.0,24.44,23.72,24.88,25.59,24.31,23.44,24.16,24.12,21.56,17.91,15.94,15.34,14.03,12.56,12.78,15.44,17.12,17.0,16.84,18.41,19.31,17.41,15.5,15.84,16.84,16.22,14.81,15.22,17.41,18.22,18.34,19.28,22.25,23.84,22.94,22.09,23.28,23.59,21.72,19.78,19.59,20.44,19.5,17.59,17.38,18.19,17.44,15.38,14.16,14.34,13.81,11.59,9.66,10.16,10.75,10.28,9.22,10.53,12.53,13.16,12.66,13.53,15.41,15.78,14.28,13.06,13.62,13.38,11.72,9.78,10.66,12.0,11.81,11.69,13.47,15.91,16.12,14.88,14.5,15.28,15.12,13.62,12.41,13.44,14.16,13.22,12.12,13.66,15.66,15.97,15.97,17.66,20.41,21.34,20.38,20.06,20.81,20.06,17.03,14.88,15.41,15.81,14.75,13.72,15.0,16.78,16.25,14.91,15.56,17.25,17.69,17.06,17.38,19.5,20.53,19.25,17.78,18.94,19.5,17.84,15.97,16.66,17.81,17.75,16.66,17.09,18.66,18.47,16.91,16.56,18.34,20.0,19.91,19.72,21.47,22.31,20.91,18.53,18.34,18.94,17.91,15.75,14.84,14.91,13.62,10.78,9.47,10.97,12.31,11.88,11.34,12.81,14.22,13.62,12.94,14.69,16.66,16.75,14.72,13.53,13.69,12.97,11.56,11.41,13.38,15.03,14.56,13.5,14.38,15.91,15.72,14.56,15.69,17.56,17.53,15.78,15.06,15.56,15.47,13.47,12.41,13.91,15.34,14.41,13.47,14.5,15.84,15.28,13.84,14.38,15.5,15.22,13.66,13.72,15.59,17.28,17.19,17.28,19.09,20.31,19.28,17.59,18.69,21.16,22.34,22.88,25.19,28.38,29.44,28.47,27.88,28.81,28.16,25.69,23.69,23.88,24.66,23.81,22.59,23.53,24.72,23.84,21.41,20.22,19.59,18.5,16.16,15.12,16.44,18.38,18.12,17.69,19.12,20.31,18.72,15.94,15.75,16.47,16.0,15.16,16.25,18.59,19.81,18.5,17.38,17.72,17.03,14.72,12.72,13.31,14.78,14.91,14.47,15.91,18.31,19.28,18.75,19.66,22.44,24.56,24.69,25.16,27.38,28.94,27.38,25.47,25.41,25.47,23.31,19.88,18.44,19.16,18.88,17.84,18.56,20.69,21.5,19.5,17.91,18.12,17.69,15.09,11.47,9.72,8.62,6.22,2.78,1.69,2.34,2.53,2.38,4.34,9.06,13.69,15.72,17.22,19.59,20.16,17.34,13.19,11.25,10.69,8.84,7.09,7.25,8.88,9.19,7.5,6.72,7.75,8.5,8.06,8.72,11.91,15.91,17.66,18.12,19.41,20.94,20.25,17.66,16.09,15.88,14.66,11.44,9.25,9.56,9.91,8.5,7.91,9.59,12.06,12.22,11.03,11.84,13.0,13.03,12.03,12.69,15.56,18.16,18.91,20.66,24.0,26.38,25.5,24.31,25.06,26.56,26.44,25.97,26.66,28.28,27.72,24.41,22.12,21.56,19.94,16.56,14.5,14.88,15.5,13.56,11.19,10.44,10.25,8.25,5.75,6.09,8.62,10.78,11.88,14.34,19.0,23.19,25.25,27.78,31.16,33.22,31.75,29.16,27.97,27.69,25.97,22.81,20.97,20.28,18.31,14.84,13.03,14.25,15.97,15.97,16.78,19.47,22.19,22.25,21.72,22.88,25.5,26.59,26.94,29.0,32.19,34.5,33.75,33.0,33.16,32.28,28.38,24.62,22.72,21.91,19.28,16.91,16.97,18.84,19.16,17.97,17.97,19.09,19.19,17.03,16.34,17.88,19.62,19.0,18.19,19.16,20.22,19.09,17.22,17.22,19.09,19.88,19.75,21.66,25.19,27.41,27.44,27.16,28.91,30.81,30.59,30.03,31.81,33.97,33.66,31.75,30.72,30.62,28.84,25.5,23.56,23.78,23.41,20.97,18.69,18.78,18.75,16.69,14.31,14.19,15.09,14.59,13.09,13.59,15.56,16.12,14.78,14.72,16.38,18.0,17.38,17.12,19.44,21.88,22.38,22.91,25.75,29.62,31.38,31.16,30.97,31.75,30.44,27.19,25.38,25.75,26.44,24.81,23.69,24.53,26.12,25.12,23.22,22.62,22.69,20.72,17.66,16.66,18.12,18.84,17.59,16.66,16.81,16.38,13.38,10.88,11.19,12.81,12.62,11.34,11.78,12.78,12.12,10.09,9.22,10.53,11.31,9.72,8.75,10.62,12.41,11.72,11.03,12.41,14.25,13.91,12.75,12.78,14.34,14.88,13.84,13.94,16.19,17.38,15.78,13.81,13.44,13.0,10.28,7.94,8.31,10.91,11.97,11.53,12.44,14.19,14.41,12.5,11.69,13.31,14.41,13.0,11.97,12.72,13.75,12.44,10.59,11.34,13.25,13.53,12.75,13.31,15.44,15.72,14.12,12.75,13.69,14.0,12.59,11.34,12.56,13.88,12.59,25.75,22.81,21.44,20.97,20.19,19.12,19.84:29.09,28.69,27.78,24.28,19.25,16.25,14.81,12.75,9.84,8.78,10.59,12.12,11.41,11.09,13.56,16.31,16.81,16.69,18.28,20.03,19.41,17.25,17.09,18.22,18.06,16.34,15.91,17.78,19.47,19.0,18.25,19.12,19.84,18.03,15.47,15.25,16.41,16.5,15.5,16.12,18.34,19.09,18.31,18.56,21.47,23.84,24.06,23.91,24.91,25.19,23.06,19.97,19.03,18.94,17.09,13.59,11.22,10.75,9.62,7.19,5.97,7.44,8.88,8.47,8.44,10.84,14.09,15.28,15.16,17.0,20.03,21.38,21.25,22.19,24.09,24.31,21.56,18.44,17.66,16.88,14.62,12.72,13.56,15.31,15.62,14.62,15.5,17.38,17.78,16.0,14.75,14.94,14.53,12.47,11.09,12.75,15.0,14.72,13.31,13.12,13.03,10.31,6.53,4.53,4.66,3.56,0.94,-0.84,-0.75,-1.81,-4.69,-7.12,-6.44,-4.75,-4.16,-2.88,0.75,5.47,8.72,10.03,11.69,14.0,14.5,12.06,9.97,9.56,8.84,6.44,4.06,4.5,5.06,3.38,0.47,-1.06,-1.75,-3.84,-7.16,-8.12,-6.59,-5.16,-4.97,-3.19,1.25,4.81,5.5,5.38,6.91,7.72,6.25,3.28,1.41,0.03,-3.0,-7.06,-9.62,-9.88,-9.94,-11.5,-11.06,-7.31,-2.66,0.22,2.75,6.56,9.31,8.97,5.75,3.62,1.62,-1.94,-7.03,-10.09,-10.28,-10.5,-12.19,-12.34,-10.59,-8.81,-8.38,-7.5,-3.44,1.31,4.97,7.06,9.88,12.97,14.19,13.28,12.97,15.47,17.59,17.69,18.88,22.03,24.69,24.09,22.28,21.75,21.06,19.22,16.44,15.31,16.31,16.34,14.81,14.0,14.62,14.78,12.34,10.56,11.19,12.56,11.75,10.5,11.5,12.5,12.66,11.25,11.78,14.12,15.31,14.56,14.16,15.19,15.0,12.03,8.75,7.78,7.28,5.28,3.0,3.12,4.41,3.72,2.5,3.31,5.84,7.88,7.78,7.97,9.47,10.69,9.25,7.97,9.47,12.31,13.44,13.75,15.56,17.75,18.06,16.38,16.25,17.38,17.88,15.97,14.56,14.78,14.94,12.97,10.91,11.0,11.84,10.56,7.75,6.56,6.53,6.0,4.5,4.69,6.94,8.38,7.31,6.31,6.97,8.44,7.97,7.41,9.12,12.06,13.0,12.81,14.0,16.56,17.81,17.34,17.78,19.75,21.03,19.84,18.66,19.19,19.75,17.81,16.09,16.5,17.97,17.88,16.28,15.81,16.06,15.41,13.31,13.12,15.5,18.59,19.91,21.66,24.97,27.72,27.12,24.94,23.62,23.12,21.31,18.25,16.75,17.19,17.09,14.88,13.47,13.72,13.22,9.94,6.56,5.69,6.03,4.91,3.97,5.34,7.97,9.38,9.62,11.19,14.53,17.47,18.12,19.5,22.66,25.09,24.38,22.91,22.81,23.03,21.41,19.19,18.66,19.22,18.47,16.09,14.72,15.34,15.47,13.34,12.12,12.84,13.94,13.19,12.0,12.78,13.91,12.88,10.81,10.03,10.5,9.25,6.75,5.38,6.5,7.94,7.94,8.47,11.28,13.78,13.03,11.38,10.78,10.78,9.25,7.09,7.19,9.03,9.56,7.78,6.06,5.53,4.62,1.75,0.38,2.56,6.34,9.09,11.41,15.03,18.72,19.97,18.91,18.78,20.22,20.59,19.0,18.06,18.28,17.75,14.78,12.38,12.78,14.56,14.91,14.53,15.19,16.44,15.53,13.19,12.31,13.38,14.0,13.0,12.91,15.25,17.47,17.16,16.66,17.78,19.31,17.91,15.22,14.09,14.16,12.91,11.06,11.09,13.12,14.91,14.38,14.25,15.72,16.97,15.59,13.91,14.19,15.69,15.91,15.16,16.03,17.72,17.38,14.59,12.5,12.06,11.16,8.53,6.56,7.44,8.66,8.06,7.12,8.38,10.5,10.5,10.09,11.06,13.66,15.06,15.0,16.03,18.88,20.66,20.12,19.16,19.28,19.66,18.12,15.91,15.69,17.38,18.03,18.19,20.69,25.03,28.16,28.91,29.16,30.03,30.12,27.31,24.47,23.69,23.56,21.69,18.88,17.66,17.34,15.28,11.69,9.34,8.94,8.28,6.5,6.41,9.56,12.66,14.12,15.25,17.91,21.19,22.44,22.5,23.47,25.53,25.47,23.69,22.72,23.97,24.41,23.34,23.22,25.22,27.06,26.22,24.75,24.94,25.12,23.19,20.62,19.38,19.94,19.97,18.97,18.97,21.12,22.12,20.81,19.66,20.72,21.31,19.78,17.88,17.59,18.19,17.53,16.25,16.69,19.12,20.66,20.59,21.56,23.97,25.22,23.78,21.75,21.56,20.94,18.59,16.12,15.88,17.28,17.88,18.22,20.19,23.47,25.0,24.44,23.72,24.88,25.59,24.31,23.44,24.16,24.12,21.56,17.91,15.94,15.34,14.03,12.56,12.78,15.44,17.12,17.0,16.84,18.41,19.31,17.41,15.5,15.84,16.84,16.22,14.81,15.22,17.41,18.22,18.34,19.28,22.25,23.84,22.94,22.09,23.28,23.59,21.72,19.78,19.59,20.44,19.5,17.59,17.38,18.19,17.44,15.38,14.16,14.34,13.81,11.59,9.66,10.16,10.75,10.28,9.22,10.53,12.53,13.16,12.66,13.53,15.41,15.78,14.28,13.06,13.62,13.38,11.72,9.78,10.66,12.0,11.81,11.69,13.47,15.91,16.12,14.88,14.5,15.28,15.12,13.62,12.41,13.44,14.16,13.22,12.12,13.66,15.66,15.97,15.97,17.66,20.41,21.34,20.38,20.06,20.81,20.06,17.03,14.88,15.41,15.81,14.75,13.72,15.0,16.78,16.25,14.91,15.56,17.25,17.69,17.06,17.38,19.5,20.53,19.25,17.78,18.94,19.5,17.84,15.97,16.66,17.81,17.75,16.66,17.09,18.66,18.47,16.91,16.56,18.34,20.0,19.91,19.72,21.47,22.31,20.91,18.53,18.34,18.94,17.91,15.75,14.84,14.91,13.62,10.78,9.47,10.97,12.31,11.88,11.34,12.81,14.22,13.62,12.94,14.69,16.66,16.75,14.72,13.53,13.69,12.97,11.56,11.41,13.38,15.03,14.56,13.5,14.38,15.91,15.72,14.56,15.69,17.56,17.53,15.78,15.06,15.56,15.47,13.47,12.41,13.91,15.34,14.41,13.47,14.5,15.84,15.28,13.84,14.38,15.5,15.22,13.66,13.72,15.59,17.28,17.19,17.28,19.09,20.31,19.28,17.59,18.69,21.16,22.34,22.88,25.19,28.38,29.44,28.47,27.88,28.81,28.16,25.69,23.69,23.88,24.66,23.81,22.59,23.53,24.72,23.84,21.41,20.22,19.59,18.5,16.16,15.12,16.44,18.38,18.12,17.69,19.12,20.31,18.72,15.94,15.75,16.47,16.0,15.16,16.25,18.59,19.81,18.5,17.38,17.72,17.03,14.72,12.72,13.31,14.78,14.91,14.47,15.91,18.31,19.28,18.75,19.66,22.44,24.56,24.69,25.16,27.38,28.94,27.38,25.47,25.41,25.47,23.31,19.88,18.44,19.16,18.88,17.84,18.56,20.69,21.5,19.5,17.91,18.12,17.69,15.09,11.47,9.72,8.62,6.22,2.78,1.69,2.34,2.53,2.38,4.34,9.06,13.69,15.72,17.22,19.59,20.16,17.34,13.19,11.25,10.69,8.84,7.09,7.25,8.88,9.19,7.5,6.72,7.75,8.5,8.06,8.72,11.91,15.91,17.66,18.12,19.41,20.94,20.25,17.66,16.09,15.88,14.66,11.44,9.25,9.56,9.91,8.5,7.91,9.59,12.06,12.22,11.03,11.84,13.0,13.03,12.03,12.69,15.56,18.16,18.91,20.66,24.0,26.38,25.5,24.31,25.06,26.56,26.44,25.97,26.66,28.28,27.72,24.41,22.12,21.56,19.94,16.56,14.5,14.88,15.5,13.56,11.19,10.44,10.25,8.25,5.75,6.09,8.62,10.78,11.88,14.34,19.0,23.19,25.25,27.78,31.16,33.22,31.75,29.16,27.97,27.69,25.97,22.81,20.97,20.28,18.31,14.84,13.03,14.25,15.97,15.97,16.78,19.47,22.19,22.25,21.72,22.88,25.5,26.59,26.94,29.0,32.19,34.5,33.75,33.0,33.16,32.28,28.38,24.62,22.72,21.91,19.28,16.91,16.97,18.84,19.16,17.97,17.97,19.09,19.19,17.03,16.34,17.88,19.62,19.0,18.19,19.16,20.22,19.09,17.22,17.22,19.09,19.88,19.75,21.66,25.19,27.41,27.44,27.16,28.91,30.81,30.59,30.03,31.81,33.97,33.66,31.75,30.72,30.62,28.84,25.5,23.56,23.78,23.41,20.97,18.69,18.78,18.75,16.69,14.31,14.19,15.09,14.59,13.09,13.59,15.56,16.12,14.78,14.72,16.38,18.0,17.38,17.12,19.44,21.88,22.38,22.91,25.75,29.62,31.38,31.16,30.97,31.75,30.44,27.19,25.38,25.75,26.44,24.81,23.69,24.53,26.12,25.12,23.22,22.62,22.69,20.72,17.66,16.66,18.12,18.84,17.59,16.66,16.81,16.38,13.38,10.88,11.19,12.81,12.62,11.34,11.78,12.78,12.12,10.09,9.22,10.53,11.31,9.72,8.75,10.62,12.41,11.72,11.03,12.41,14.25,13.91,12.75,12.78,14.34,14.88,13.84,13.94,16.19,17.38,15.78,13.81,13.44,13.0,10.28,7.94,8.31,10.91,11.97,11.53,12.44,14.19,14.41,12.5,11.69,13.31,14.41,13.0,11.97,12.72,13.75,12.44,10.59,11.34,13.25,13.53,12.75,13.31,15.44,15.72,14.12,12.75,13.69,14.0,12.59,11.34,12.56,13.88,12.59,25.75,22.81,21.44,20.97,20.19,19.12,19.84,22.5,24.72,26.47,28.72,32.66,35.84,37.0:12.75,9.84,8.78,10.59,12.12,11.41,11.09,13.56,16.31,16.81,16.69,18.28,20.03,19.41,17.25,17.09,18.22,18.06,16.34,15.91,17.78,19.47,19.0,18.25,19.12,19.84,18.03,15.47,15.25,16.41,16.5,15.5,16.12,18.34,19.09,18.31,18.56,21.47,23.84,24.06,23.91,24.91,25.19,23.06,19.97,19.03,18.94,17.09,13.59,11.22,10.75,9.62,7.19,5.97,7.44,8.88,8.47,8.44,10.84,14.09,15.28,15.16,17.0,20.03,21.38,21.25,22.19,24.09,24.31,21.56,18.44,17.66,16.88,14.62,12.72,13.56,15.31,15.62,14.62,15.5,17.38,17.78,16.0,14.75,14.94,14.53,12.47,11.09,12.75,15.0,14.72,13.31,13.12,13.03,10.31,6.53,4.53,4.66,3.56,0.94,-0.84,-0.75,-1.81,-4.69,-7.12,-6.44,-4.75,-4.16,-2.88,0.75,5.47,8.72,10.03,11.69,14.0,14.5,12.06,9.97,9.56,8.84,6.44,4.06,4.5,5.06,3.38,0.47,-1.06,-1.75,-3.84,-7.16,-8.12,-6.59,-5.16,-4.97,-3.19,1.25,4.81,5.5,5.38,6.91,7.72,6.25,3.28,1.41,0.03,-3.0,-7.06,-9.62,-9.88,-9.94,-11.5,-11.06,-7.31,-2.66,0.22,2.75,6.56,9.31,8.97,5.75,3.62,1.62,-1.94,-7.03,-10.09,-10.28,-10.5,-12.19,-12.34,-10.59,-8.81,-8.38,-7.5,-3.44,1.31,4.97,7.06,9.88,12.97,14.19,13.28,12.97,15.47,17.59,17.69,18.88,22.03,24.69,24.09,22.28,21.75,21.06,19.22,16.44,15.31,16.31,16.34,14.81,14.0,14.62,14.78,12.34,10.56,11.19,12.56,11.75,10.5,11.5,12.5,12.66,11.25,11.78,14.12,15.31,14.56,14.16,15.19,15.0,12.03,8.75,7.78,7.28,5.28,3.0,3.12,4.41,3.72,2.5,3.31,5.84,7.88,7.78,7.97,9.47,10.69,9.25,7.97,9.47,12.31,13.44,13.75,15.56,17.75,18.06,16.38,16.25,17.38,17.88,15.97,14.56,14.78,14.94,12.97,10.91,11.0,11.84,10.56,7.75,6.56,6.53,6.0,4.5,4.69,6.94,8.38,7.31,6.31,6.97,8.44,7.97,7.41,9.12,12.06,13.0,12.81,14.0,16.56,17.81,17.34,17.78,19.75,21.03,19.84,18.66,19.19,19.75,17.81,16.09,16.5,17.97,17.88,16.28,15.81,16.06,15.41,13.31,13.12,15.5,18.59,19.91,21.66,24.97,27.72,27.12,24.94,23.62,23.12,21.31,18.25,16.75,17.19,17.09,14.88,13.47,13.72,13.22,9.94,6.56,5.69,6.03,4.91,3.97,5.34,7.97,9.38,9.62,11.19,14.53,17.47,18.12,19.5,22.66,25.09,24.38,22.91,22.81,23.03,21.41,19.19,18.66,19.22,18.47,16.09,14.72,15.34,15.47,13.34,12.12,12.84,13.94,13.19,12.0,12.78,13.91,12.88,10.81,10.03,10.5,9.25,6.75,5.38,6.5,7.94,7.94,8.47,11.28,13.78,13.03,11.38,10.78,10.78,9.25,7.09,7.19,9.03,9.56,7.78,6.06,5.53,4.62,1.75,0.38,2.56,6.34,9.09,11.41,15.03,18.72,19.97,18.91,18.78,20.22,20.59,19.0,18.06,18.28,17.75,14.78,12.38,12.78,14.56,14.91,14.53,15.19,16.44,15.53,13.19,12.31,13.38,14.0,13.0,12.91,15.25,17.47,17.16,16.66,17.78,19.31,17.91,15.22,14.09,14.16,12.91,11.06,11.09,13.12,14.91,14.38,14.25,15.72,16.97,15.59,13.91,14.19,15.69,15.91,15.16,16.03,17.72,17.38,14.59,12.5,12.06,11.16,8.53,6.56,7.44,8.66,8.06,7.12,8.38,10.5,10.5,10.09,11.06,13.66,15.06,15.0,16.03,18.88,20.66,20.12,19.16,19.28,19.66,18.12,15.91,15.69,17.38,18.03,18.19,20.69,25.03,28.16,28.91,29.16,30.03,30.12,27.31,24.47,23.69,23.56,21.69,18.88,17.66,17.34,15.28,11.69,9.34,8.94,8.28,6.5,6.41,9.56,12.66,14.12,15.25,17.91,21.19,22.44,22.5,23.47,25.53,25.47,23.69,22.72,23.97,24.41,23.34,23.22,25.22,27.06,26.22,24.75,24.94,25.12,23.19,20.62,19.38,19.94,19.97,18.97,18.97,21.12,22.12,20.81,19.66,20.72,21.31,19.78,17.88,17.59,18.19,17.53,16.25,16.69,19.12,20.66,20.59,21.56,23.97,25.22,23.78,21.75,21.56,20.94,18.59,16.12,15.88,17.28,17.88,18.22,20.19,23.47,25.0,24.44,23.72,24.88,25.59,24.31,23.44,24.16,24.12,21.56,17.91,15.94,15.34,14.03,12.56,12.78,15.44,17.12,17.0,16.84,18.41,19.31,17.41,15.5,15.84,16.84,16.22,14.81,15.22,17.41,18.22,18.34,19.28,22.25,23.84,22.94,22.09,23.28,23.59,21.72,19.78,19.59,20.44,19.5,17.59,17.38,18.19,17.44,15.38,14.16,14.34,13.81,11.59,9.66,10.16,10.75,10.28,9.22,10.53,12.53,13.16,12.66,13.53,15.41,15.78,14.28,13.06,13.62,13.38,11.72,9.78,10.66,12.0,11.81,11.69,13.47,15.91,16.12,14.88,14.5,15.28,15.12,13.62,12.41,13.44,14.16,13.22,12.12,13.66,15.66,15.97,15.97,17.66,20.41,21.34,20.38,20.06,20.81,20.06,17.03,14.88,15.41,15.81,14.75,13.72,15.0,16.78,16.25,14.91,15.56,17.25,17.69,17.06,17.38,19.5,20.53,19.25,17.78,18.94,19.5,17.84,15.97,16.66,17.81,17.75,16.66,17.09,18.66,18.47,16.91,16.56,18.34,20.0,19.91,19.72,21.47,22.31,20.91,18.53,18.34,18.94,17.91,15.75,14.84,14.91,13.62,10.78,9.47,10.97,12.31,11.88,11.34,12.81,14.22,13.62,12.94,14.69,16.66,16.75,14.72,13.53,13.69,12.97,11.56,11.41,13.38,15.03,14.56,13.5,14.38,15.91,15.72,14.56,15.69,17.56,17.53,15.78,15.06,15.56,15.47,13.47,12.41,13.91,15.34,14.41,13.47,14.5,15.84,15.28,13.84,14.38,15.5,15.22,13.66,13.72,15.59,17.28,17.19,17.28,19.09,20.31,19.28,17.59,18.69,21.16,22.34,22.88,25.19,28.38,29.44,28.47,27.88,28.81,28.16,25.69,23.69,23.88,24.66,23.81,22.59,23.53,24.72,23.84,21.41,20.22,19.59,18.5,16.16,15.12,16.44,18.38,18.12,17.69,19.12,20.31,18.72,15.94,15.75,16.47,16.0,15.16,16.25,18.59,19.81,18.5,17.38,17.72,17.03,14.72,12.72,13.31,14.78,14.91,14.47,15.91,18.31,19.28,18.75,19.66,22.44,24.56,24.69,25.16,27.38,28.94,27.38,25.47,25.41,25.47,23.31,19.88,18.44,19.16,18.88,17.84,18.56,20.69,21.5,19.5,17.91,18.12,17.69,15.09,11.47,9.72,8.62,6.22,2.78,1.69,2.34,2.53,2.38,4.34,9.06,13.69,15.72,17.22,19.59,20.16,17.34,13.19,11.25,10.69,8.84,7.09,7.25,8.88,9.19,7.5,6.72,7.75,8.5,8.06,8.72,11.91,15.91,17.66,18.12,19.41,20.94,20.25,17.66,16.09,15.88,14.66,11.44,9.25,9.56,9.91,8.5,7.91,9.59,12.06,12.22,11.03,11.84,13.0,13.03,12.03,12.69,15.56,18.16,18.91,20.66,24.0,26.38,25.5,24.31,25.06,26.56,26.44,25.97,26.66,28.28,27.72,24.41,22.12,21.56,19.94,16.56,14.5,14.88,15.5,13.56,11.19,10.44,10.25,8.25,5.75,6.09,8.62,10.78,11.88,14.34,19.0,23.19,25.25,27.78,31.16,33.22,31.75,29.16,27.97,27.69,25.97,22.81,20.97,20.28,18.31,14.84,13.03,14.25,15.97,15.97,16.78,19.47,22.19,22.25,21.72,22.88,25.5,26.59,26.94,29.0,32.19,34.5,33.75,33.0,33.16,32.28,28.38,24.62,22.72,21.91,19.28,16.91,16.97,18.84,19.16,17.97,17.97,19.09,19.19,17.03,16.34,17.88,19.62,19.0,18.19,19.16,20.22,19.09,17.22,17.22,19.09,19.88,19.75,21.66,25.19,27.41,27.44,27.16,28.91,30.81,30.59,30.03,31.81,33.97,33.66,31.75,30.72,30.62,28.84,25.5,23.56,23.78,23.41,20.97,18.69,18.78,18.75,16.69,14.31,14.19,15.09,14.59,13.09,13.59,15.56,16.12,14.78,14.72,16.38,18.0,17.38,17.12,19.44,21.88,22.38,22.91,25.75,29.62,31.38,31.16,30.97,31.75,30.44,27.19,25.38,25.75,26.44,24.81,23.69,24.53,26.12,25.12,23.22,22.62,22.69,20.72,17.66,16.66,18.12,18.84,17.59,16.66,16.81,16.38,13.38,10.88,11.19,12.81,12.62,11.34,11.78,12.78,12.12,10.09,9.22,10.53,11.31,9.72,8.75,10.62,12.41,11.72,11.03,12.41,14.25,13.91,12.75,12.78,14.34,14.88,13.84,13.94,16.19,17.38,15.78,13.81,13.44,13.0,10.28,7.94,8.31,10.91,11.97,11.53,12.44,14.19,14.41,12.5,11.69,13.31,14.41,13.0,11.97,12.72,13.75,12.44,10.59,11.34,13.25,13.53,12.75,13.31,15.44,15.72,14.12,12.75,13.69,14.0,12.59,11.34,12.56,13.88,12.59,25.75,22.81,21.44,20.97,20.19,19.12,19.84,22.5,24.72,26.47,28.72,32.66,35.84,37.0,36.59,36.16,35.09,31.66,27.25,24.19,22.22:13.56,16.31,16.81,16.69,18.28,20.03,19.41,17.25,17.09,18.22,18.06,16.34,15.91,17.78,19.47,19.0,18.25,19.12,19.84,18.03,15.47,15.25,16.41,16.5,15.5,16.12,18.34,19.09,18.31,18.56,21.47,23.84,24.06,23.91,24.91,25.19,23.06,19.97,19.03,18.94,17.09,13.59,11.22,10.75,9.62,7.19,5.97,7.44,8.88,8.47,8.44,10.84,14.09,15.28,15.16,17.0,20.03,21.38,21.25,22.19,24.09,24.31,21.56,18.44,17.66,16.88,14.62,12.72,13.56,15.31,15.62,14.62,15.5,17.38,17.78,16.0,14.75,14.94,14.53,12.47,11.09,12.75,15.0,14.72,13.31,13.12,13.03,10.31,6.53,4.53,4.66,3.56,0.94,-0.84,-0.75,-1.81,-4.69,-7.12,-6.44,-4.75,-4.16,-2.88,0.75,5.47,8.72,10.03,11.69,14.0,14.5,12.06,9.97,9.56,8.84,6.44,4.06,4.5,5.06,3.38,0.47,-1.06,-1.75,-3.84,-7.16,-8.12,-6.59,-5.16,-4.97,-3.19,1.25,4.81,5.5,5.38,6.91,7.72,6.25,3.28,1.41,0.03,-3.0,-7.06,-9.62,-9.88,-9.94,-11.5,-11.06,-7.31,-2.66,0.22,2.75,6.56,9.31,8.97,5.75,3.62,1.62,-1.94,-7.03,-10.09,-10.28,-10.5,-12.19,-12.34,-10.59,-8.81,-8.38,-7.5,-3.44,1.31,4.97,7.06,9.88,12.97,14.19,13.28,12.97,15.47,17.59,17.69,18.88,22.03,24.69,24.09,22.28,21.75,21.06,19.22,16.44,15.31,16.31,16.34,14.81,14.0,14.62,14.78,12.34,10.56,11.19,12.56,11.75,10.5,11.5,12.5,12.66,11.25,11.78,14.12,15.31,14.56,14.16,15.19,15.0,12.03,8.75,7.78,7.28,5.28,3.0,3.12,4.41,3.72,2.5,3.31,5.84,7.88,7.78,7.97,9.47,10.69,9.25,7.97,9.47,12.31,13.44,13.75,15.56,17.75,18.06,16.38,16.25,17.38,17.88,15.97,14.56,14.78,14.94,12.97,10.91,11.0,11.84,10.56,7.75,6.56,6.53,6.0,4.5,4.69,6.94,8.38,7.31,6.31,6.97,8.44,7.97,7.41,9.12,12.06,13.0,12.81,14.0,16.56,17.81,17.34,17.78,19.75,21.03,19.84,18.66,19.19,19.75,17.81,16.09,16.5,17.97,17.88,16.28,15.81,16.06,15.41,13.31,13.12,15.5,18.59,19.91,21.66,24.97,27.72,27.12,24.94,23.62,23.12,21.31,18.25,16.75,17.19,17.09,14.88,13.47,13.72,13.22,9.94,6.56,5.69,6.03,4.91,3.97,5.34,7.97,9.38,9.62,11.19,14.53,17.47,18.12,19.5,22.66,25.09,24.38,22.91,22.81,23.03,21.41,19.19,18.66,19.22,18.47,16.09,14.72,15.34,15.47,13.34,12.12,12.84,13.94,13.19,12.0,12.78,13.91,12.88,10.81,10.03,10.5,9.25,6.75,5.38,6.5,7.94,7.94,8.47,11.28,13.78,13.03,11.38,10.78,10.78,9.25,7.09,7.19,9.03,9.56,7.78,6.06,5.53,4.62,1.75,0.38,2.56,6.34,9.09,11.41,15.03,18.72,19.97,18.91,18.78,20.22,20.59,19.0,18.06,18.28,17.75,14.78,12.38,12.78,14.56,14.91,14.53,15.19,16.44,15.53,13.19,12.31,13.38,14.0,13.0,12.91,15.25,17.47,17.16,16.66,17.78,19.31,17.91,15.22,14.09,14.16,12.91,11.06,11.09,13.12,14.91,14.38,14.25,15.72,16.97,15.59,13.91,14.19,15.69,15.91,15.16,16.03,17.72,17.38,14.59,12.5,12.06,11.16,8.53,6.56,7.44,8.66,8.06,7.12,8.38,10.5,10.5,10.09,11.06,13.66,15.06,15.0,16.03,18.88,20.66,20.12,19.16,19.28,19.66,18.12,15.91,15.69,17.38,18.03,18.19,20.69,25.03,28.16,28.91,29.16,30.03,30.12,27.31,24.47,23.69,23.56,21.69,18.88,17.66,17.34,15.28,11.69,9.34,8.94,8.28,6.5,6.41,9.56,12.66,14.12,15.25,17.91,21.19,22.44,22.5,23.47,25.53,25.47,23.69,22.72,23.97,24.41,23.34,23.22,25.22,27.06,26.22,24.75,24.94,25.12,23.19,20.62,19.38,19.94,19.97,18.97,18.97,21.12,22.12,20.81,19.66,20.72,21.31,19.78,17.88,17.59,18.19,17.53,16.25,16.69,19.12,20.66,20.59,21.56,23.97,25.22,23.78,21.75,21.56,20.94,18.59,16.12,15.88,17.28,17.88,18.22,20.19,23.47,25.0,24.44,23.72,24.88,25.59,24.31,23.44,24.16,24.12,21.56,17.91,15.94,15.34,14.03,12.56,12.78,15.44,17.12,17.0,16.84,18.41,19.31,17.41,15.5,15.84,16.84,16.22,14.81,15.22,17.41,18.22,18.34,19.28,22.25,23.84,22.94,22.09,23.28,23.59,21.72,19.78,19.59,20.44,19.5,17.59,17.38,18.19,17.44,15.38,14.16,14.34,13.81,11.59,9.66,10.16,10.75,10.28,9.22,10.53,12.53,13.16,12.66,13.53,15.41,15.78,14.28,13.06,13.62,13.38,11.72,9.78,10.66,12.0,11.81,11.69,13.47,15.91,16.12,14.88,14.5,15.28,15.12,13.62,12.41,13.44,14.16,13.22,12.12,13.66,15.66,15.97,15.97,17.66,20.41,21.34,20.38,20.06,20.81,20.06,17.03,14.88,15.41,15.81,14.75,13.72,15.0,16.78,16.25,14.91,15.56,17.25,17.69,17.06,17.38,19.5,20.53,19.25,17.78,18.94,19.5,17.84,15.97,16.66,17.81,17.75,16.66,17.09,18.66,18.47,16.91,16.56,18.34,20.0,19.91,19.72,21.47,22.31,20.91,18.53,18.34,18.94,17.91,15.75,14.84,14.91,13.62,10.78,9.47,10.97,12.31,11.88,11.34,12.81,14.22,13.62,12.94,14.69,16.66,16.75,14.72,13.53,13.69,12.97,11.56,11.41,13.38,15.03,14.56,13.5,14.38,15.91,15.72,14.56,15.69,17.56,17.53,15.78,15.06,15.56,15.47,13.47,12.41,13.91,15.34,14.41,13.47,14.5,15.84,15.28,13.84,14.38,15.5,15.22,13.66,13.72,15.59,17.28,17.19,17.28,19.09,20.31,19.28,17.59,18.69,21.16,22.34,22.88,25.19,28.38,29.44,28.47,27.88,28.81,28.16,25.69,23.69,23.88,24.66,23.81,22.59,23.53,24.72,23.84,21.41,20.22,19.59,18.5,16.16,15.12,16.44,18.38,18.12,17.69,19.12,20.31,18.72,15.94,15.75,16.47,16.0,15.16,16.25,18.59,19.81,18.5,17.38,17.72,17.03,14.72,12.72,13.31,14.78,14.91,14.47,15.91,18.31,19.28,18.75,19.66,22.44,24.56,24.69,25.16,27.38,28.94,27.38,25.47,25.41,25.47,23.31,19.88,18.44,19.16,18.88,17.84,18.56,20.69,21.5,19.5,17.91,18.12,17.69,15.09,11.47,9.72,8.62,6.22,2.78,1.69,2.34,2.53,2.38,4.34,9.06,13.69,15.72,17.22,19.59,20.16,17.34,13.19,11.25,10.69,8.84,7.09,7.25,8.88,9.19,7.5,6.72,7.75,8.5,8.06,8.72,11.91,15.91,17.66,18.12,19.41,20.94,20.25,17.66,16.09,15.88,14.66,11.44,9.25,9.56,9.91,8.5,7.91,9.59,12.06,12.22,11.03,11.84,13.0,13.03,12.03,12.69,15.56,18.16,18.91,20.66,24.0,26.38,25.5,24.31,25.06,26.56,26.44,25.97,26.66,28.28,27.72,24.41,22.12,21.56,19.94,16.56,14.5,14.88,15.5,13.56,11.19,10.44,10.25,8.25,5.75,6.09,8.62,10.78,11.88,14.34,19.0,23.19,25.25,27.78,31.16,33.22,31.75,29.16,27.97,27.69,25.97,22.81,20.97,20.28,18.31,14.84,13.03,14.25,15.97,15.97,16.78,19.47,22.19,22.25,21.72,22.88,25.5,26.59,26.94,29.0,32.19,34.5,33.75,33.0,33.16,32.28,28.38,24.62,22.72,21.91,19.28,16.91,16.97,18.84,19.16,17.97,17.97,19.09,19.19,17.03,16.34,17.88,19.62,19.0,18.19,19.16,20.22,19.09,17.22,17.22,19.09,19.88,19.75,21.66,25.19,27.41,27.44,27.16,28.91,30.81,30.59,30.03,31.81,33.97,33.66,31.75,30.72,30.62,28.84,25.5,23.56,23.78,23.41,20.97,18.69,18.78,18.75,16.69,14.31,14.19,15.09,14.59,13.09,13.59,15.56,16.12,14.78,14.72,16.38,18.0,17.38,17.12,19.44,21.88,22.38,22.91,25.75,29.62,31.38,31.16,30.97,31.75,30.44,27.19,25.38,25.75,26.44,24.81,23.69,24.53,26.12,25.12,23.22,22.62,22.69,20.72,17.66,16.66,18.12,18.84,17.59,16.66,16.81,16.38,13.38,10.88,11.19,12.81,12.62,11.34,11.78,12.78,12.12,10.09,9.22,10.53,11.31,9.72,8.75,10.62,12.41,11.72,11.03,12.41,14.25,13.91,12.75,12.78,14.34,14.88,13.84,13.94,16.19,17.38,15.78,13.81,13.44,13.0,10.28,7.94,8.31,10.91,11.97,11.53,12.44,14.19,14.41,12.5,11.69,13.31,14.41,13.0,11.97,12.72,13.75,12.44,10.59,11.34,13.25,13.53,12.75,13.31,15.44,15.72,14.12,12.75,13.69,14.0,12.59,11.34,12.56,13.88,12.59,25.75,22.81,21.44,20.97,20.19,19.12,19.84,22.5,24.72,26.47,28.72,32.66,35.84,37.0,36.59,36.16,35.09,31.66,27.25,24.19,22.22,19.88,17.59,16.97,18.06,19.03,18.25,17.59:17.25,17.09,18.22,18.06,16.34,15.91,17.78,19.47,19.0,18.25,19.12,19.84,18.03,15.47,15.25,16.41,16.5,15.5,16.12,18.34,19.09,18.31,18.56,21.47,23.84,24.06,23.91,24.91,25.19,23.06,19.97,19.03,18.94,17.09,13.59,11.22,10.75,9.62,7.19,5.97,7.44,8.88,8.47,8.44,10.84,14.09,15.28,15.16,17.0,20.03,21.38,21.25,22.19,24.09,24.31,21.56,18.44,17.66,16.88,14.62,12.72,13.56,15.31,15.62,14.62,15.5,17.38,17.78,16.0,14.75,14.94,14.53,12.47,11.09,12.75,15.0,14.72,13.31,13.12,13.03,10.31,6.53,4.53,4.66,3.56,0.94,-0.84,-0.75,-1.81,-4.69,-7.12,-6.44,-4.75,-4.16,-2.88,0.75,5.47,8.72,10.03,11.69,14.0,14.5,12.06,9.97,9.56,8.84,6.44,4.06,4.5,5.06,3.38,0.47,-1.06,-1.75,-3.84,-7.16,-8.12,-6.59,-5.16,-4.97,-3.19,1.25,4.81,5.5,5.38,6.91,7.72,6.25,3.28,1.41,0.03,-3.0,-7.06,-9.62,-9.88,-9.94,-11.5,-11.06,-7.31,-2.66,0.22,2.75,6.56,9.31,8.97,5.75,3.62,1.62,-1.94,-7.03,-10.09,-10.28,-10.5,-12.19,-12.34,-10.59,-8.81,-8.38,-7.5,-3.44,1.31,4.97,7.06,9.88,12.97,14.19,13.28,12.97,15.47,17.59,17.69,18.88,22.03,24.69,24.09,22.28,21.75,21.06,19.22,16.44,15.31,16.31,16.34,14.81,14.0,14.62,14.78,12.34,10.56,11.19,12.56,11.75,10.5,11.5,12.5,12.66,11.25,11.78,14.12,15.31,14.56,14.16,15.19,15.0,12.03,8.75,7.78,7.28,5.28,3.0,3.12,4.41,3.72,2.5,3.31,5.84,7.88,7.78,7.97,9.47,10.69,9.25,7.97,9.47,12.31,13.44,13.75,15.56,17.75,18.06,16.38,16.25,17.38,17.88,15.97,14.56,14.78,14.94,12.97,10.91,11.0,11.84,10.56,7.75,6.56,6.53,6.0,4.5,4.69,6.94,8.38,7.31,6.31,6.97,8.44,7.97,7.41,9.12,12.06,13.0,12.81,14.0,16.56,17.81,17.34,17.78,19.75,21.03,19.84,18.66,19.19,19.75,17.81,16.09,16.5,17.97,17.88,16.28,15.81,16.06,15.41,13.31,13.12,15.5,18.59,19.91,21.66,24.97,27.72,27.12,24.94,23.62,23.12,21.31,18.25,16.75,17.19,17.09,14.88,13.47,13.72,13.22,9.94,6.56,5.69,6.03,4.91,3.97,5.34,7.97,9.38,9.62,11.19,14.53,17.47,18.12,19.5,22.66,25.09,24.38,22.91,22.81,23.03,21.41,19.19,18.66,19.22,18.47,16.09,14.72,15.34,15.47,13.34,12.12,12.84,13.94,13.19,12.0,12.78,13.91,12.88,10.81,10.03,10.5,9.25,6.75,5.38,6.5,7.94,7.94,8.47,11.28,13.78,13.03,11.38,10.78,10.78,9.25,7.09,7.19,9.03,9.56,7.78,6.06,5.53,4.62,1.75,0.38,2.56,6.34,9.09,11.41,15.03,18.72,19.97,18.91,18.78,20.22,20.59,19.0,18.06,18.28,17.75,14.78,12.38,12.78,14.56,14.91,14.53,15.19,16.44,15.53,13.19,12.31,13.38,14.0,13.0,12.91,15.25,17.47,17.16,16.66,17.78,19.31,17.91,15.22,14.09,14.16,12.91,11.06,11.09,13.12,14.91,14.38,14.25,15.72,16.97,15.59,13.91,14.19,15.69,15.91,15.16,16.03,17.72,17.38,14.59,12.5,12.06,11.16,8.53,6.56,7.44,8.66,8.06,7.12,8.38,10.5,10.5,10.09,11.06,13.66,15.06,15.0,16.03,18.88,20.66,20.12,19.16,19.28,19.66,18.12,15.91,15.69,17.38,18.03,18.19,20.69,25.03,28.16,28.91,29.16,30.03,30.12,27.31,24.47,23.69,23.56,21.69,18.88,17.66,17.34,15.28,11.69,9.34,8.94,8.28,6.5,6.41,9.56,12.66,14.12,15.25,17.91,21.19,22.44,22.5,23.47,25.53,25.47,23.69,22.72,23.97,24.41,23.34,23.22,25.22,27.06,26.22,24.75,24.94,25.12,23.19,20.62,19.38,19.94,19.97,18.97,18.97,21.12,22.12,20.81,19.66,20.72,21.31,19.78,17.88,17.59,18.19,17.53,16.25,16.69,19.12,20.66,20.59,21.56,23.97,25.22,23.78,21.75,21.56,20.94,18.59,16.12,15.88,17.28,17.88,18.22,20.19,23.47,25.0,24.44,23.72,24.88,25.59,24.31,23.44,24.16,24.12,21.56,17.91,15.94,15.34,14.03,12.56,12.78,15.44,17.12,17.0,16.84,18.41,19.31,17.41,15.5,15.84,16.84,16.22,14.81,15.22,17.41,18.22,18.34,19.28,22.25,23.84,22.94,22.09,23.28,23.59,21.72,19.78,19.59,20.44,19.5,17.59,17.38,18.19,17.44,15.38,14.16,14.34,13.81,11.59,9.66,10.16,10.75,10.28,9.22,10.53,12.53,13.16,12.66,13.53,15.41,15.78,14.28,13.06,13.62,13.38,11.72,9.78,10.66,12.0,11.81,11.69,13.47,15.91,16.12,14.88,14.5,15.28,15.12,13.62,12.41,13.44,14.16,13.22,12.12,13.66,15.66,15.97,15.97,17.66,20.41,21.34,20.38,20.06,20.81,20.06,17.03,14.88,15.41,15.81,14.75,13.72,15.0,16.78,16.25,14.91,15.56,17.25,17.69,17.06,17.38,19.5,20.53,19.25,17.78,18.94,19.5,17.84,15.97,16.66,17.81,17.75,16.66,17.09,18.66,18.47,16.91,16.56,18.34,20.0,19.91,19.72,21.47,22.31,20.91,18.53,18.34,18.94,17.91,15.75,14.84,14.91,13.62,10.78,9.47,10.97,12.31,11.88,11.34,12.81,14.22,13.62,12.94,14.69,16.66,16.75,14.72,13.53,13.69,12.97,11.56,11.41,13.38,15.03,14.56,13.5,14.38,15.91,15.72,14.56,15.69,17.56,17.53,15.78,15.06,15.56,15.47,13.47,12.41,13.91,15.34,14.41,13.47,14.5,15.84,15.28,13.84,14.38,15.5,15.22,13.66,13.72,15.59,17.28,17.19,17.28,19.09,20.31,19.28,17.59,18.69,21.16,22.34,22.88,25.19,28.38,29.44,28.47,27.88,28.81,28.16,25.69,23.69,23.88,24.66,23.81,22.59,23.53,24.72,23.84,21.41,20.22,19.59,18.5,16.16,15.12,16.44,18.38,18.12,17.69,19.12,20.31,18.72,15.94,15.75,16.47,16.0,15.16,16.25,18.59,19.81,18.5,17.38,17.72,17.03,14.72,12.72,13.31,14.78,14.91,14.47,15.91,18.31,19.28,18.75,19.66,22.44,24.56,24.69,25.16,27.38,28.94,27.38,25.47,25.41,25.47,23.31,19.88,18.44,19.16,18.88,17.84,18.56,20.69,21.5,19.5,17.91,18.12,17.69,15.09,11.47,9.72,8.62,6.22,2.78,1.69,2.34,2.53,2.38,4.34,9.06,13.69,15.72,17.22,19.59,20.16,17.34,13.19,11.25,10.69,8.84,7.09,7.25,8.88,9.19,7.5,6.72,7.75,8.5,8.06,8.72,11.91,15.91,17.66,18.12,19.41,20.94,20.25,17.66,16.09,15.88,14.66,11.44,9.25,9.56,9.91,8.5,7.91,9.59,12.06,12.22,11.03,11.84,13.0,13.03,12.03,12.69,15.56,18.16,18.91,20.66,24.0,26.38,25.5,24.31,25.06,26.56,26.44,25.97,26.66,28.28,27.72,24.41,22.12,21.56,19.94,16.56,14.5,14.88,15.5,13.56,11.19,10.44,10.25,8.25,5.75,6.09,8.62,10.78,11.88,14.34,19.0,23.19,25.25,27.78,31.16,33.22,31.75,29.16,27.97,27.69,25.97,22.81,20.97,20.28,18.31,14.84,13.03,14.25,15.97,15.97,16.78,19.47,22.19,22.25,21.72,22.88,25.5,26.59,26.94,29.0,32.19,34.5,33.75,33.0,33.16,32.28,28.38,24.62,22.72,21.91,19.28,16.91,16.97,18.84,19.16,17.97,17.97,19.09,19.19,17.03,16.34,17.88,19.62,19.0,18.19,19.16,20.22,19.09,17.22,17.22,19.09,19.88,19.75,21.66,25.19,27.41,27.44,27.16,28.91,30.81,30.59,30.03,31.81,33.97,33.66,31.75,30.72,30.62,28.84,25.5,23.56,23.78,23.41,20.97,18.69,18.78,18.75,16.69,14.31,14.19,15.09,14.59,13.09,13.59,15.56,16.12,14.78,14.72,16.38,18.0,17.38,17.12,19.44,21.88,22.38,22.91,25.75,29.62,31.38,31.16,30.97,31.75,30.44,27.19,25.38,25.75,26.44,24.81,23.69,24.53,26.12,25.12,23.22,22.62,22.69,20.72,17.66,16.66,18.12,18.84,17.59,16.66,16.81,16.38,13.38,10.88,11.19,12.81,12.62,11.34,11.78,12.78,12.12,10.09,9.22,10.53,11.31,9.72,8.75,10.62,12.41,11.72,11.03,12.41,14.25,13.91,12.75,12.78,14.34,14.88,13.84,13.94,16.19,17.38,15.78,13.81,13.44,13.0,10.28,7.94,8.31,10.91,11.97,11.53,12.44,14.19,14.41,12.5,11.69,13.31,14.41,13.0,11.97,12.72,13.75,12.44,10.59,11.34,13.25,13.53,12.75,13.31,15.44,15.72,14.12,12.75,13.69,14.0,12.59,11.34,12.56,13.88,12.59,25.75,22.81,21.44,20.97,20.19,19.12,19.84,22.5,24.72,26.47,28.72,32.66,35.84,37.0,36.59,36.16,35.09,31.66,27.25,24.19,22.22,19.88,17.59,16.97,18.06,19.03,18.25,17.59,18.19,18.59,17.38,16.12,16.34,17.44,17.78:19.47,19.0,18.25,19.12,19.84,18.03,15.47,15.25,16.41,16.5,15.5,16.12,18.34,19.09,18.31,18.56,21.47,23.84,24.06,23.91,24.91,25.19,23.06,19.97,19.03,18.94,17.09,13.59,11.22,10.75,9.62,7.19,5.97,7.44,8.88,8.47,8.44,10.84,14.09,15.28,15.16,17.0,20.03,21.38,21.25,22.19,24.09,24.31,21.56,18.44,17.66,16.88,14.62,12.72,13.56,15.31,15.62,14.62,15.5,17.38,17.78,16.0,14.75,14.94,14.53,12.47,11.09,12.75,15.0,14.72,13.31,13.12,13.03,10.31,6.53,4.53,4.66,3.56,0.94,-0.84,-0.75,-1.81,-4.69,-7.12,-6.44,-4.75,-4.16,-2.88,0.75,5.47,8.72,10.03,11.69,14.0,14.5,12.06,9.97,9.56,8.84,6.44,4.06,4.5,5.06,3.38,0.47,-1.06,-1.75,-3.84,-7.16,-8.12,-6.59,-5.16,-4.97,-3.19,1.25,4.81,5.5,5.38,6.91,7.72,6.25,3.28,1.41,0.03,-3.0,-7.06,-9.62,-9.88,-9.94,-11.5,-11.06,-7.31,-2.66,0.22,2.75,6.56,9.31,8.97,5.75,3.62,1.62,-1.94,-7.03,-10.09,-10.28,-10.5,-12.19,-12.34,-10.59,-8.81,-8.38,-7.5,-3.44,1.31,4.97,7.06,9.88,12.97,14.19,13.28,12.97,15.47,17.59,17.69,18.88,22.03,24.69,24.09,22.28,21.75,21.06,19.22,16.44,15.31,16.31,16.34,14.81,14.0,14.62,14.78,12.34,10.56,11.19,12.56,11.75,10.5,11.5,12.5,12.66,11.25,11.78,14.12,15.31,14.56,14.16,15.19,15.0,12.03,8.75,7.78,7.28,5.28,3.0,3.12,4.41,3.72,2.5,3.31,5.84,7.88,7.78,7.97,9.47,10.69,9.25,7.97,9.47,12.31,13.44,13.75,15.56,17.75,18.06,16.38,16.25,17.38,17.88,15.97,14.56,14.78,14.94,12.97,10.91,11.0,11.84,10.56,7.75,6.56,6.53,6.0,4.5,4.69,6.94,8.38,7.31,6.31,6.97,8.44,7.97,7.41,9.12,12.06,13.0,12.81,14.0,16.56,17.81,17.34,17.78,19.75,21.03,19.84,18.66,19.19,19.75,17.81,16.09,16.5,17.97,17.88,16.28,15.81,16.06,15.41,13.31,13.12,15.5,18.59,19.91,21.66,24.97,27.72,27.12,24.94,23.62,23.12,21.31,18.25,16.75,17.19,17.09,14.88,13.47,13.72,13.22,9.94,6.56,5.69,6.03,4.91,3.97,5.34,7.97,9.38,9.62,11.19,14.53,17.47,18.12,19.5,22.66,25.09,24.38,22.91,22.81,23.03,21.41,19.19,18.66,19.22,18.47,16.09,14.72,15.34,15.47,13.34,12.12,12.84,13.94,13.19,12.0,12.78,13.91,12.88,10.81,10.03,10.5,9.25,6.75,5.38,6.5,7.94,7.94,8.47,11.28,13.78,13.03,11.38,10.78,10.78,9.25,7.09,7.19,9.03,9.56,7.78,6.06,5.53,4.62,1.75,0.38,2.56,6.34,9.09,11.41,15.03,18.72,19.97,18.91,18.78,20.22,20.59,19.0,18.06,18.28,17.75,14.78,12.38,12.78,14.56,14.91,14.53,15.19,16.44,15.53,13.19,12.31,13.38,14.0,13.0,12.91,15.25,17.47,17.16,16.66,17.78,19.31,17.91,15.22,14.09,14.16,12.91,11.06,11.09,13.12,14.91,14.38,14.25,15.72,16.97,15.59,13.91,14.19,15.69,15.91,15.16,16.03,17.72,17.38,14.59,12.5,12.06,11.16,8.53,6.56,7.44,8.66,8.06,7.12,8.38,10.5,10.5,10.09,11.06,13.66,15.06,15.0,16.03,18.88,20.66,20.12,19.16,19.28,19.66,18.12,15.91,15.69,17.38,18.03,18.19,20.69,25.03,28.16,28.91,29.16,30.03,30.12,27.31,24.47,23.69,23.56,21.69,18.88,17.66,17.34,15.28,11.69,9.34,8.94,8.28,6.5,6.41,9.56,12.66,14.12,15.25,17.91,21.19,22.44,22.5,23.47,25.53,25.47,23.69,22.72,23.97,24.41,23.34,23.22,25.22,27.06,26.22,24.75,24.94,25.12,23.19,20.62,19.38,19.94,19.97,18.97,18.97,21.12,22.12,20.81,19.66,20.72,21.31,19.78,17.88,17.59,18.19,17.53,16.25,16.69,19.12,20.66,20.59,21.56,23.97,25.22,23.78,21.75,21.56,20.94,18.59,16.12,15.88,17.28,17.88,18.22,20.19,23.47,25.0,24.44,23.72,24.88,25.59,24.31,23.44,24.16,24.12,21.56,17.91,15.94,15.34,14.03,12.56,12.78,15.44,17.12,17.0,16.84,18.41,19.31,17.41,15.5,15.84,16.84,16.22,14.81,15.22,17.41,18.22,18.34,19.28,22.25,23.84,22.94,22.09,23.28,23.59,21.72,19.78,19.59,20.44,19.5,17.59,17.38,18.19,17.44,15.38,14.16,14.34,13.81,11.59,9.66,10.16,10.75,10.28,9.22,10.53,12.53,13.16,12.66,13.53,15.41,15.78,14.28,13.06,13.62,13.38,11.72,9.78,10.66,12.0,11.81,11.69,13.47,15.91,16.12,14.88,14.5,15.28,15.12,13.62,12.41,13.44,14.16,13.22,12.12,13.66,15.66,15.97,15.97,17.66,20.41,21.34,20.38,20.06,20.81,20.06,17.03,14.88,15.41,15.81,14.75,13.72,15.0,16.78,16.25,14.91,15.56,17.25,17.69,17.06,17.38,19.5,20.53,19.25,17.78,18.94,19.5,17.84,15.97,16.66,17.81,17.75,16.66,17.09,18.66,18.47,16.91,16.56,18.34,20.0,19.91,19.72,21.47,22.31,20.91,18.53,18.34,18.94,17.91,15.75,14.84,14.91,13.62,10.78,9.47,10.97,12.31,11.88,11.34,12.81,14.22,13.62,12.94,14.69,16.66,16.75,14.72,13.53,13.69,12.97,11.56,11.41,13.38,15.03,14.56,13.5,14.38,15.91,15.72,14.56,15.69,17.56,17.53,15.78,15.06,15.56,15.47,13.47,12.41,13.91,15.34,14.41,13.47,14.5,15.84,15.28,13.84,14.38,15.5,15.22,13.66,13.72,15.59,17.28,17.19,17.28,19.09,20.31,19.28,17.59,18.69,21.16,22.34,22.88,25.19,28.38,29.44,28.47,27.88,28.81,28.16,25.69,23.69,23.88,24.66,23.81,22.59,23.53,24.72,23.84,21.41,20.22,19.59,18.5,16.16,15.12,16.44,18.38,18.12,17.69,19.12,20.31,18.72,15.94,15.75,16.47,16.0,15.16,16.25,18.59,19.81,18.5,17.38,17.72,17.03,14.72,12.72,13.31,14.78,14.91,14.47,15.91,18.31,19.28,18.75,19.66,22.44,24.56,24.69,25.16,27.38,28.94,27.38,25.47,25.41,25.47,23.31,19.88,18.44,19.16,18.88,17.84,18.56,20.69,21.5,19.5,17.91,18.12,17.69,15.09,11.47,9.72,8.62,6.22,2.78,1.69,2.34,2.53,2.38,4.34,9.06,13.69,15.72,17.22,19.59,20.16,17.34,13.19,11.25,10.69,8.84,7.09,7.25,8.88,9.19,7.5,6.72,7.75,8.5,8.06,8.72,11.91,15.91,17.66,18.12,19.41,20.94,20.25,17.66,16.09,15.88,14.66,11.44,9.25,9.56,9.91,8.5,7.91,9.59,12.06,12.22,11.03,11.84,13.0,13.03,12.03,12.69,15.56,18.16,18.91,20.66,24.0,26.38,25.5,24.31,25.06,26.56,26.44,25.97,26.66,28.28,27.72,24.41,22.12,21.56,19.94,16.56,14.5,14.88,15.5,13.56,11.19,10.44,10.25,8.25,5.75,6.09,8.62,10.78,11.88,14.34,19.0,23.19,25.25,27.78,31.16,33.22,31.75,29.16,27.97,27.69,25.97,22.81,20.97,20.28,18.31,14.84,13.03,14.25,15.97,15.97,16.78,19.47,22.19,22.25,21.72,22.88,25.5,26.59,26.94,29.0,32.19,34.5,33.75,33.0,33.16,32.28,28.38,24.62,22.72,21.91,19.28,16.91,16.97,18.84,19.16,17.97,17.97,19.09,19.19,17.03,16.34,17.88,19.62,19.0,18.19,19.16,20.22,19.09,17.22,17.22,19.09,19.88,19.75,21.66,25.19,27.41,27.44,27.16,28.91,30.81,30.59,30.03,31.81,33.97,33.66,31.75,30.72,30.62,28.84,25.5,23.56,23.78,23.41,20.97,18.69,18.78,18.75,16.69,14.31,14.19,15.09,14.59,13.09,13.59,15.56,16.12,14.78,14.72,16.38,18.0,17.38,17.12,19.44,21.88,22.38,22.91,25.75,29.62,31.38,31.16,30.97,31.75,30.44,27.19,25.38,25.75,26.44,24.81,23.69,24.53,26.12,25.12,23.22,22.62,22.69,20.72,17.66,16.66,18.12,18.84,17.59,16.66,16.81,16.38,13.38,10.88,11.19,12.81,12.62,11.34,11.78,12.78,12.12,10.09,9.22,10.53,11.31,9.72,8.75,10.62,12.41,11.72,11.03,12.41,14.25,13.91,12.75,12.78,14.34,14.88,13.84,13.94,16.19,17.38,15.78,13.81,13.44,13.0,10.28,7.94,8.31,10.91,11.97,11.53,12.44,14.19,14.41,12.5,11.69,13.31,14.41,13.0,11.97,12.72,13.75,12.44,10.59,11.34,13.25,13.53,12.75,13.31,15.44,15.72,14.12,12.75,13.69,14.0,12.59,11.34,12.56,13.88,12.59,25.75,22.81,21.44,20.97,20.19,19.12,19.84,22.5,24.72,26.47,28.72,32.66,35.84,37.0,36.59,36.16,35.09,31.66,27.25,24.19,22.22,19.88,17.59,16.97,18.06,19.03,18.25,17.59,18.19,18.59,17.38,16.12,16.34,17.44,17.78,17.81,19.41,21.97,23.06,22.78,23.16,24.62:negativity
-6.25,-8.62,-8.34,-7.5,-8.25,-9.72,-8.38,-5.34,-3.44,-3.34,-1.34,2.69,5.0,4.47,3.16,3.62,3.56,1.25,-1.22,-0.59,0.72,-0.03,-2.59,-3.59,-3.59,-4.62,-7.19,-8.38,-6.47,-5.06,-5.34,-5.16,-1.94,1.31,1.97,1.72,2.91,5.12,5.5,4.38,4.91,6.72,7.0,4.62,3.06,3.34,3.69,1.31,-0.88,-0.72,0.0,-1.09,-3.16,-3.28,-1.69,-0.84,-1.38,-0.38,2.66,4.25,2.66,0.94,1.72,2.91,2.28,1.81,4.72,8.56,10.94,11.94,14.62,18.41,20.12,18.69,17.19,16.88,15.0,10.31,6.25,5.38,6.09,5.56,5.19,7.44,10.59,11.69,11.09,11.75,14.12,15.28,13.75,13.28,14.84,16.31,15.12,13.91,14.78,16.03,14.81,12.84,12.5,13.5,13.12,10.59,9.62,10.59,11.34,9.53,8.59,10.19,11.97,11.28,10.34,11.38,12.31,11.09,7.69,5.69,5.09,3.44,0.5,-0.75,0.75,1.78,0.91,0.53,2.59,5.47,5.91,5.53,6.75,8.41,7.69,5.06,3.81,4.47,4.0,1.91,0.78,2.12,3.41,1.88,0.62,1.41,2.78,1.66,-0.28,-0.97,-0.22,-0.78,-2.66,-2.91,-0.75,1.41,1.28,1.75,4.28,6.88,6.53,5.62,6.91,9.28,9.91,9.28,9.94,11.84,12.22,9.88,8.0,8.19,8.12,5.69,3.78,4.62,6.28,6.06,5.88,7.47,10.56,11.78,11.41,12.16,14.0,14.41,12.34,10.94,12.22,13.66,13.28,13.44,16.12,19.75,20.84,20.66,21.31,22.34,21.25,18.16,16.12,16.41,15.97,12.94,10.12,9.66,9.53,7.03,4.5,4.66,6.0,5.12,3.34,3.28,4.75,5.25,3.31,2.5,3.72,4.28,2.28,0.66,1.41,3.06,2.59,1.59,2.84,5.03,5.44,4.09,3.81,5.47,5.84,4.28,3.19,5.06,6.38,5.38,4.41,5.34,7.06,6.81,5.75,6.12,8.31,8.41,6.56,6.12,7.16,7.31,5.41,3.84,4.38,5.5,4.22,2.47,2.69,4.16,3.62,2.09,2.28,4.53,5.19,3.88,3.41,5.16,6.34,5.28,4.09,5.62,7.38,7.0,5.56,5.44,5.66,3.56,-0.16,-2.78,-2.59,-2.94,-4.56,-4.91,-2.12,0.41,0.75,0.41,2.12,4.25,3.91,2.0,1.81,3.09,2.53,0.62,-0.69,0.41,0.88,-0.88,-2.47,-1.5,-0.78,-2.28,-4.22,-3.69,-2.12,-1.84,-3.0,-2.62,-0.47,0.19,-1.44,-2.38,-1.16,-0.34,-1.59,-2.88,-1.5,0.5,0.78,-0.25,0.62,2.59,2.69,0.72,0.0,1.5,2.5,1.16,0.53,2.88,5.16,5.44,5.66,8.38,11.44,11.72,9.91,9.12,9.28,7.69,4.28,2.53,3.44,3.69,2.31,1.12,2.62,4.44,4.19,2.94,3.72,5.34,4.53,2.62,2.78,5.19,7.44,7.53,8.31,11.03,12.56,11.72,10.31,11.41,13.19,12.69,11.22,11.59,13.06,12.41,9.56,8.06,8.34,7.72,5.34,4.22,5.59,7.28,6.62,5.31,6.84,8.34,7.91,5.81,5.44,6.03,4.91,1.97,0.22,1.25,1.91,1.09,1.12,3.62,5.62,4.88,2.72,2.53,3.56,3.66,3.53,5.75,10.09,12.62,12.06,11.25,11.78,11.16,7.78,4.53,3.84,4.09,2.19,-0.09,0.03,2.0,2.34,1.66,2.91,5.69,7.53,6.34,5.62,6.62,7.97,7.34,6.75,8.56,11.34,11.69,10.03,9.88,10.69,10.53,8.31,7.41,8.72,9.06,7.5,6.72,9.0,11.81,12.19,11.44,11.84,12.16,10.06,6.59,5.12,5.81,5.84,3.81,2.12,2.66,2.69,0.69,-0.81,0.91,4.44,5.75,7.12,10.5,14.53,15.97,14.62,13.97,14.62,14.0,10.47,8.06,7.88,7.91,6.12,4.31,5.44,7.72,8.22,7.66,9.22,12.53,13.81,12.91,13.22,14.75,15.38,13.59,12.31,13.22,14.03,11.78,8.5,7.44,7.59,7.09,6.22,7.75,11.69,13.59,12.44,11.19,11.38,10.84,8.0,5.56,6.59,8.44,8.47,8.44,10.5,14.38,15.91,15.41,16.25,18.56,19.59,18.34,17.84,19.25,19.84,16.25,12.41,9.72,8.53,5.75,2.5,2.31,4.41,5.09,4.28,4.94,7.72,9.22,7.62,5.66,5.75,5.88,3.19,0.28,-0.03,0.56,-0.97,-3.03,-2.94,-0.62,0.44,-0.53,-1.31,-0.28,-0.31,-3.66,-6.34,-6.84,-6.53,-8.12,-9.75,-8.25,-4.88,-2.75,-1.72,0.91,5.34,8.47,8.5,9.09,11.69,13.38,11.75,9.88,9.53,10.22,8.44,5.97,5.81,7.34,7.47,6.16,6.53,9.06,10.78,9.91,9.34,10.97,12.5,11.19,9.44,9.56,10.12,8.53,5.97,5.41,7.06,7.66,6.19,5.94,8.19,9.53,8.69,8.19,10.12,12.44,12.38,11.94,14.0,17.28,17.84,16.16,15.12,15.47,13.94,10.44,8.41,9.28,10.44,9.22,8.31,10.34,13.53,14.06,13.47,14.22,16.34,15.81,13.25,11.94,12.84,13.16,10.62,9.19,10.69,12.78,12.28,11.88,14.06,16.47,16.22,14.97,15.47,18.19,20.06,20.5,22.34,26.19,28.56,27.31,24.88,23.56,21.22,15.03,8.09,3.88,1.59,-1.5,-4.66,-4.72,-2.0,0.28,1.62,3.97,9.25,13.94,15.84,17.0,20.34,23.56,23.69,22.03,21.91,22.53,20.5,17.12,15.25,15.66,14.75,12.0,9.88,10.22,10.62,8.69,6.72,7.41,9.53,10.16,10.22,12.81,17.09,19.84,20.72,22.59,26.88,29.25,29.12,28.59,30.06,31.44,30.62,29.38,30.66,32.94,32.38,29.81,28.56,28.88,28.0,25.38,24.06,25.12,25.75,23.03,19.97,19.66,19.5,17.53,15.28,15.09,16.25,15.19,12.91,12.0,13.22,13.31,11.25,10.31,11.88,12.94,11.78,9.78,9.94,10.12,8.06,4.91,3.75,4.47,3.94,2.16,1.62,3.34,4.38,2.69,1.75,3.62,5.59,5.62,4.81,6.69,9.53,10.34,10.12,11.56,14.56,15.31,14.09,13.66,15.44,16.25,14.03,11.03,10.16,9.0,6.25,3.25,3.59,5.47,6.12,5.06,5.28,7.81,8.97,8.0,7.84,9.97,11.53,10.16,9.03,10.22,12.16,12.62,12.12,13.81,16.47,17.12,15.44,14.03,13.78,11.75,7.41,3.56,3.25,3.94,3.22,2.88,4.91,7.06,6.53,3.56,2.16,1.91,1.06,-1.38,-1.78,0.69,2.44,1.91,1.06,2.84,4.62,4.44,3.78,5.62,8.28,9.06,7.84,7.97,9.44,9.91,7.75,6.38,7.12,7.5,5.06,2.16,1.94,2.16,0.59,-0.91,1.16,5.03,7.66,8.69,10.41,13.62,15.22,14.34,13.41,14.47,14.91,12.38,9.12,8.06,7.31,5.09,2.19,2.06,4.16,5.38,4.81,4.75,6.78,8.5,8.09,7.47,9.09,10.34,8.84,6.19,5.78,6.78,6.41,5.03,5.75,8.66,10.78,10.56,11.16,13.72,15.66,14.84,13.88,15.66,17.25,16.75,14.91,14.59,15.66,14.59,12.12,10.84,11.22,11.06,8.28,6.38,6.78,7.56,5.88,4.28,5.25,6.84,6.56,5.59,7.03,9.84,11.62,12.0,13.88,17.34,20.03,19.84,19.72,21.0,21.91,20.0,17.31,16.72,17.12,15.91,13.69,12.91,13.66,13.22,10.53,8.84,9.72,10.47,9.25,8.94,10.97,13.22,13.38,11.91,11.78,13.06,12.47,10.44,10.25,12.28,13.78,13.47,13.97,16.88,19.19,18.56,17.28,17.66,18.62,16.94,14.09,12.25,11.41,9.19,5.47,3.19,4.31,5.66,5.25,5.75,9.31,13.06,14.22,14.19,15.44,17.12,16.19,13.53,12.69,13.62,13.69,11.69,10.94,12.41,13.44,12.03,11.03,12.22,14.25,13.91,12.5,12.56,13.81,12.94,10.72,9.59,10.59,10.88,9.47,8.66,10.75,12.91,12.78,12.19,13.22,14.44,13.41,11.0,10.44,11.81,11.84,10.88,11.56,14.75,16.91,16.31,15.41,16.12,16.19,13.62,11.22,11.06,12.22,11.78,10.12,9.62,10.94,11.0,9.19,8.91,11.41,13.56,13.28,13.25,14.53,16.03,15.19,12.97,12.59,13.5,12.84,10.66,10.28,12.0,12.69,11.66,10.78,12.59,14.19,13.34,12.12,13.03,14.47,13.88,12.34,12.06,12.75,11.62,8.78,6.66,7.41,7.78,6.34,5.03,6.47,7.5,6.69,6.0,7.44,10.0,10.53,9.09,8.66,9.31,9.09,6.97,5.81,7.47,8.72,7.72,6.72,7.84,9.56,9.16,8.19,9.22,11.75,12.62,12.0,12.41,14.81,16.06,15.16,14.38,16.28,17.88,17.16,15.72,16.72,18.12,17.84,16.31,16.81,18.75,18.81,17.25,16.31,17.41,17.5,15.44,12.72,12.47,12.53,10.59,8.78,9.84,12.41,14.16,14.88,16.81,20.25,21.41,19.94,18.53,19.5,20.53,19.88,19.41,21.59,24.09,24.25,23.44,23.5,24.31,22.62,18.53,15.47,14.41,12.94,9.56,6.84,6.91,6.84,4.62,1.59,1.44,2.31,2.31,1.75,4.12,8.72,12.0,13.31,15.22,18.19,20.0,18.84,17.38,18.31,19.5,19.25,18.75,19.97,21.75,21.22,18.38,16.59,16.47,15.12,11.88,9.28,8.75,8.31,5.97,3.81,4.41,6.0,5.38,4.25,5.03:-5.34,-3.44,-3.34,-1.34,2.69,5.0,4.47,3.16,3.62,3.56,1.25,-1.22,-0.59,0.72,-0.03,-2.59,-3.59,-3.59,-4.62,-7.19,-8.38,-6.47,-5.06,-5.34,-5.16,-1.94,1.31,1.97,1.72,2.91,5.12,5.5,4.38,4.91,6.72,7.0,4.62,3.06,3.34,3.69,1.31,-0.88,-0.72,0.0,-1.09,-3.16,-3.28,-1.69,-0.84,-1.38,-0.38,2.66,4.25,2.66,0.94,1.72,2.91,2.28,1.81,4.72,8.56,10.94,11.94,14.62,18.41,20.12,18.69,17.19,16.88,15.0,10.31,6.25,5.38,6.09,5.56,5.19,7.44,10.59,11.69,11.09,11.75,14.12,15.28,13.75,13.28,14.84,16.31,15.12,13.91,14.78,16.03,14.81,12.84,12.5,13.5,13.12,10.59,9.62,10.59,11.34,9.53,8.59,10.19,11.97,11.28,10.34,11.38,12.31,11.09,7.69,5.69,5.09,3.44,0.5,-0.75,0.75,1.78,0.91,0.53,2.59,5.47,5.91,5.53,6.75,8.41,7.69,5.06,3.81,4.47,4.0,1.91,0.78,2.12,3.41,1.88,0.62,1.41,2.78,1.66,-0.28,-0.97,-0.22,-0.78,-2.66,-2.91,-0.75,1.41,1.28,1.75,4.28,6.88,6.53,5.62,6.91,9.28,9.91,9.28,9.94,11.84,12.22,9.88,8.0,8.19,8.12,5.69,3.78,4.62,6.28,6.06,5.88,7.47,10.56,11.78,11.41,12.16,14.0,14.41,12.34,10.94,12.22,13.66,13.28,13.44,16.12,19.75,20.84,20.66,21.31,22.34,21.25,18.16,16.12,16.41,15.97,12.94,10.12,9.66,9.53,7.03,4.5,4.66,6.0,5.12,3.34,3.28,4.75,5.25,3.31,2.5,3.72,4.28,2.28,0.66,1.41,3.06,2.59,1.59,2.84,5.03,5.44,4.09,3.81,5.47,5.84,4.28,3.19,5.06,6.38,5.38,4.41,5.34,7.06,6.81,5.75,6.12,8.31,8.41,6.56,6.12,7.16,7.31,5.41,3.84,4.38,5.5,4.22,2.47,2.69,4.16,3.62,2.09,2.28,4.53,5.19,3.88,3.41,5.16,6.34,5.28,4.09,5.62,7.38,7.0,5.56,5.44,5.66,3.56,-0.16,-2.78,-2.59,-2.94,-4.56,-4.91,-2.12,0.41,0.75,0.41,2.12,4.25,3.91,2.0,1.81,3.09,2.53,0.62,-0.69,0.41,0.88,-0.88,-2.47,-1.5,-0.78,-2.28,-4.22,-3.69,-2.12,-1.84,-3.0,-2.62,-0.47,0.19,-1.44,-2.38,-1.16,-0.34,-1.59,-2.88,-1.5,0.5,0.78,-0.25,0.62,2.59,2.69,0.72,0.0,1.5,2.5,1.16,0.53,2.88,5.16,5.44,5.66,8.38,11.44,11.72,9.91,9.12,9.28,7.69,4.28,2.53,3.44,3.69,2.31,1.12,2.62,4.44,4.19,2.94,3.72,5.34,4.53,2.62,2.78,5.19,7.44,7.53,8.31,11.03,12.56,11.72,10.31,11.41,13.19,12.69,11.22,11.59,13.06,12.41,9.56,8.06,8.34,7.72,5.34,4.22,5.59,7.28,6.62,5.31,6.84,8.34,7.91,5.81,5.44,6.03,4.91,1.97,0.22,1.25,1.91,1.09,1.12,3.62,5.62,4.88,2.72,2.53,3.56,3.66,3.53,5.75,10.09,12.62,12.06,11.25,11.78,11.16,7.78,4.53,3.84,4.09,2.19,-0.09,0.03,2.0,2.34,1.66,2.91,5.69,7.53,6.34,5.62,6.62,7.97,7.34,6.75,8.56,11.34,11.69,10.03,9.88,10.69,10.53,8.31,7.41,8.72,9.06,7.5,6.72,9.0,11.81,12.19,11.44,11.84,12.16,10.06,6.59,5.12,5.81,5.84,3.81,2.12,2.66,2.69,0.69,-0.81,0.91,4.44,5.75,7.12,10.5,14.53,15.97,14.62,13.97,14.62,14.0,10.47,8.06,7.88,7.91,6.12,4.31,5.44,7.72,8.22,7.66,9.22,12.53,13.81,12.91,13.22,14.75,15.38,13.59,12.31,13.22,14.03,11.78,8.5,7.44,7.59,7.09,6.22,7.75,11.69,13.59,12.44,11.19,11.38,10.84,8.0,5.56,6.59,8.44,8.47,8.44,10.5,14.38,15.91,15.41,16.25,18.56,19.59,18.34,17.84,19.25,19.84,16.25,12.41,9.72,8.53,5.75,2.5,2.31,4.41,5.09,4.28,4.94,7.72,9.22,7.62,5.66,5.75,5.88,3.19,0.28,-0.03,0.56,-0.97,-3.03,-2.94,-0.62,0.44,-0.53,-1.31,-0.28,-0.31,-3.66,-6.34,-6.84,-6.53,-8.12,-9.75,-8.25,-4.88,-2.75,-1.72,0.91,5.34,8.47,8.5,9.09,11.69,13.38,11.75,9.88,9.53,10.22,8.44,5.97,5.81,7.34,7.47,6.16,6.53,9.06,10.78,9.91,9.34,10.97,12.5,11.19,9.44,9.56,10.12,8.53,5.97,5.41,7.06,7.66,6.19,5.94,8.19,9.53,8.69,8.19,10.12,12.44,12.38,11.94,14.0,17.28,17.84,16.16,15.12,15.47,13.94,10.44,8.41,9.28,10.44,9.22,8.31,10.34,13.53,14.06,13.47,14.22,16.34,15.81,13.25,11.94,12.84,13.16,10.62,9.19,10.69,12.78,12.28,11.88,14.06,16.47,16.22,14.97,15.47,18.19,20.06,20.5,22.34,26.19,28.56,27.31,24.88,23.56,21.22,15.03,8.09,3.88,1.59,-1.5,-4.66,-4.72,-2.0,0.28,1.62,3.97,9.25,13.94,15.84,17.0,20.34,23.56,23.69,22.03,21.91,22.53,20.5,17.12,15.25,15.66,14.75,12.0,9.88,10.22,10.62,8.69,6.72,7.41,9.53,10.16,10.22,12.81,17.09,19.84,20.72,22.59,26.88,29.25,29.12,28.59,30.06,31.44,30.62,29.38,30.66,32.94,32.38,29.81,28.56,28.88,28.0,25.38,24.06,25.12,25.75,23.03,19.97,19.66,19.5,17.53,15.28,15.09,16.25,15.19,12.91,12.0,13.22,13.31,11.25,10.31,11.88,12.94,11.78,9.78,9.94,10.12,8.06,4.91,3.75,4.47,3.94,2.16,1.62,3.34,4.38,2.69,1.75,3.62,5.59,5.62,4.81,6.69,9.53,10.34,10.12,11.56,14.56,15.31,14.09,13.66,15.44,16.25,14.03,11.03,10.16,9.0,6.25,3.25,3.59,5.47,6.12,5.06,5.28,7.81,8.97,8.0,7.84,9.97,11.53,10.16,9.03,10.22,12.16,12.62,12.12,13.81,16.47,17.12,15.44,14.03,13.78,11.75,7.41,3.56,3.25,3.94,3.22,2.88,4.91,7.06,6.53,3.56,2.16,1.91,1.06,-1.38,-1.78,0.69,2.44,1.91,1.06,2.84,4.62,4.44,3.78,5.62,8.28,9.06,7.84,7.97,9.44,9.91,7.75,6.38,7.12,7.5,5.06,2.16,1.94,2.16,0.59,-0.91,1.16,5.03,7.66,8.69,10.41,13.62,15.22,14.34,13.41,14.47,14.91,12.38,9.12,8.06,7.31,5.09,2.19,2.06,4.16,5.38,4.81,4.75,6.78,8.5,8.09,7.47,9.09,10.34,8.84,6.19,5.78,6.78,6.41,5.03,5.75,8.66,10.78,10.56,11.16,13.72,15.66,14.84,13.88,15.66,17.25,16.75,14.91,14.59,15.66,14.59,12.12,10.84,11.22,11.06,8.28,6.38,6.78,7.56,5.88,4.28,5.25,6.84,6.56,5.59,7.03,9.84,11.62,12.0,13.88,17.34,20.03,19.84,19.72,21.0,21.91,20.0,17.31,16.72,17.12,15.91,13.69,12.91,13.66,13.22,10.53,8.84,9.72,10.47,9.25,8.94,10.97,13.22,13.38,11.91,11.78,13.06,12.47,10.44,10.25,12.28,13.78,13.47,13.97,16.88,19.19,18.56,17.28,17.66,18.62,16.94,14.09,12.25,11.41,9.19,5.47,3.19,4.31,5.66,5.25,5.75,9.31,13.06,14.22,14.19,15.44,17.12,16.19,13.53,12.69,13.62,13.69,11.69,10.94,12.41,13.44,12.03,11.03,12.22,14.25,13.91,12.5,12.56,13.81,12.94,10.72,9.59,10.59,10.88,9.47,8.66,10.75,12.91,12.78,12.19,13.22,14.44,13.41,11.0,10.44,11.81,11.84,10.88,11.56,14.75,16.91,16.31,15.41,16.12,16.19,13.62,11.22,11.06,12.22,11.78,10.12,9.62,10.94,11.0,9.19,8.91,11.41,13.56,13.28,13.25,14.53,16.03,15.19,12.97,12.59,13.5,12.84,10.66,10.28,12.0,12.69,11.66,10.78,12.59,14.19,13.34,12.12,13.03,14.47,13.88,12.34,12.06,12.75,11.62,8.78,6.66,7.41,7.78,6.34,5.03,6.47,7.5,6.69,6.0,7.44,10.0,10.53,9.09,8.66,9.31,9.09,6.97,5.81,7.47,8.72,7.72,6.72,7.84,9.56,9.16,8.19,9.22,11.75,12.62,12.0,12.41,14.81,16.06,15.16,14.38,16.28,17.88,17.16,15.72,16.72,18.12,17.84,16.31,16.81,18.75,18.81,17.25,16.31,17.41,17.5,15.44,12.72,12.47,12.53,10.59,8.78,9.84,12.41,14.16,14.88,16.81,20.25,21.41,19.94,18.53,19.5,20.53,19.88,19.41,21.59,24.09,24.25,23.44,23.5,24.31,22.62,18.53,15.47,14.41,12.94,9.56,6.84,6.91,6.84,4.62,1.59,1.44,2.31,2.31,1.75,4.12,8.72,12.0,13.31,15.22,18.19,20.0,18.84,17.38,18.31,19.5,19.25,18.75,19.97,21.75,21.22,18.38,16.59,16.47,15.12,11.88,9.28,8.75,8.31,5.97,3.81,4.41,6.0,5.38,4.25,5.03,3.78,2.38,2.19,1.66,0.09,-1.81,-1.41:3.16,3.62,3.56,1.25,-1.22,-0.59,0.72,-0.03,-2.59,-3.59,-3.59,-4.62,-7.19,-8.38,-6.47,-5.06,-5.34,-5.16,-1.94,1.31,1.97,1.72,2.91,5.12,5.5,4.38,4.91,6.72,7.0,4.62,3.06,3.34,3.69,1.31,-0.88,-0.72,0.0,-1.09,-3.16,-3.28,-1.69,-0.84,-1.38,-0.38,2.66,4.25,2.66,0.94,1.72,2.91,2.28,1.81,4.72,8.56,10.94,11.94,14.62,18.41,20.12,18.69,17.19,16.88,15.0,10.31,6.25,5.38,6.09,5.56,5.19,7.44,10.59,11.69,11.09,11.75,14.12,15.28,13.75,13.28,14.84,16.31,15.12,13.91,14.78,16.03,14.81,12.84,12.5,13.5,13.12,10.59,9.62,10.59,11.34,9.53,8.59,10.19,11.97,11.28,10.34,11.38,12.31,11.09,7.69,5.69,5.09,3.44,0.5,-0.75,0.75,1.78,0.91,0.53,2.59,5.47,5.91,5.53,6.75,8.41,7.69,5.06,3.81,4.47,4.0,1.91,0.78,2.12,3.41,1.88,0.62,1.41,2.78,1.66,-0.28,-0.97,-0.22,-0.78,-2.66,-2.91,-0.75,1.41,1.28,1.75,4.28,6.88,6.53,5.62,6.91,9.28,9.91,9.28,9.94,11.84,12.22,9.88,8.0,8.19,8.12,5.69,3.78,4.62,6.28,6.06,5.88,7.47,10.56,11.78,11.41,12.16,14.0,14.41,12.34,10.94,12.22,13.66,13.28,13.44,16.12,19.75,20.84,20.66,21.31,22.34,21.25,18.16,16.12,16.41,15.97,12.94,10.12,9.66,9.53,7.03,4.5,4.66,6.0,5.12,3.34,3.28,4.75,5.25,3.31,2.5,3.72,4.28,2.28,0.66,1.41,3.06,2.59,1.59,2.84,5.03,5.44,4.09,3.81,5.47,5.84,4.28,3.19,5.06,6.38,5.38,4.41,5.34,7.06,6.81,5.75,6.12,8.31,8.41,6.56,6.12,7.16,7.31,5.41,3.84,4.38,5.5,4.22,2.47,2.69,4.16,3.62,2.09,2.28,4.53,5.19,3.88,3.41,5.16,6.34,5.28,4.09,5.62,7.38,7.0,5.56,5.44,5.66,3.56,-0.16,-2.78,-2.59,-2.94,-4.56,-4.91,-2.12,0.41,0.75,0.41,2.12,4.25,3.91,2.0,1.81,3.09,2.53,0.62,-0.69,0.41,0.88,-0.88,-2.47,-1.5,-0.78,-2.28,-4.22,-3.69,-2.12,-1.84,-3.0,-2.62,-0.47,0.19,-1.44,-2.38,-1.16,-0.34,-1.59,-2.88,-1.5,0.5,0.78,-0.25,0.62,2.59,2.69,0.72,0.0,1.5,2.5,1.16,0.53,2.88,5.16,5.44,5.66,8.38,11.44,11.72,9.91,9.12,9.28,7.69,4.28,2.53,3.44,3.69,2.31,1.12,2.62,4.44,4.19,2.94,3.72,5.34,4.53,2.62,2.78,5.19,7.44,7.53,8.31,11.03,12.56,11.72,10.31,11.41,13.19,12.69,11.22,11.59,13.06,12.41,9.56,8.06,8.34,7.72,5.34,4.22,5.59,7.28,6.62,5.31,6.84,8.34,7.91,5.81,5.44,6.03,4.91,1.97,0.22,1.25,1.91,1.09,1.12,3.62,5.62,4.88,2.72,2.53,3.56,3.66,3.53,5.75,10.09,12.62,12.06,11.25,11.78,11.16,7.78,4.53,3.84,4.09,2.19,-0.09,0.03,2.0,2.34,1.66,2.91,5.69,7.53,6.34,5.62,6.62,7.97,7.34,6.75,8.56,11.34,11.69,10.03,9.88,10.69,10.53,8.31,7.41,8.72,9.06,7.5,6.72,9.0,11.81,12.19,11.44,11.84,12.16,10.06,6.59,5.12,5.81,5.84,3.81,2.12,2.66,2.69,0.69,-0.81,0.91,4.44,5.75,7.12,10.5,14.53,15.97,14.62,13.97,14.62,14.0,10.47,8.06,7.88,7.91,6.12,4.31,5.44,7.72,8.22,7.66,9.22,12.53,13.81,12.91,13.22,14.75,15.38,13.59,12.31,13.22,14.03,11.78,8.5,7.44,7.59,7.09,6.22,7.75,11.69,13.59,12.44,11.19,11.38,10.84,8.0,5.56,6.59,8.44,8.47,8.44,10.5,14.38,15.91,15.41,16.25,18.56,19.59,18.34,17.84,19.25,19.84,16.25,12.41,9.72,8.53,5.75,2.5,2.31,4.41,5.09,4.28,4.94,7.72,9.22,7.62,5.66,5.75,5.88,3.19,0.28,-0.03,0.56,-0.97,-3.03,-2.94,-0.62,0.44,-0.53,-1.31,-0.28,-0.31,-3.66,-6.34,-6.84,-6.53,-8.12,-9.75,-8.25,-4.88,-2.75,-1.72,0.91,5.34,8.47,8.5,9.09,11.69,13.38,11.75,9.88,9.53,10.22,8.44,5.97,5.81,7.34,7.47,6.16,6.53,9.06,10.78,9.91,9.34,10.97,12.5,11.19,9.44,9.56,10.12,8.53,5.97,5.41,7.06,7.66,6.19,5.94,8.19,9.53,8.69,8.19,10.12,12.44,12.38,11.94,14.0,17.28,17.84,16.16,15.12,15.47,13.94,10.44,8.41,9.28,10.44,9.22,8.31,10.34,13.53,14.06,13.47,14.22,16.34,15.81,13.25,11.94,12.84,13.16,10.62,9.19,10.69,12.78,12.28,11.88,14.06,16.47,16.22,14.97,15.47,18.19,20.06,20.5,22.34,26.19,28.56,27.31,24.88,23.56,21.22,15.03,8.09,3.88,1.59,-1.5,-4.66,-4.72,-2.0,0.28,1.62,3.97,9.25,13.94,15.84,17.0,20.34,23.56,23.69,22.03,21.91,22.53,20.5,17.12,15.25,15.66,14.75,12.0,9.88,10.22,10.62,8.69,6.72,7.41,9.53,10.16,10.22,12.81,17.09,19.84,20.72,22.59,26.88,29.25,29.12,28.59,30.06,31.44,30.62,29.38,30.66,32.94,32.38,29.81,28.56,28.88,28.0,25.38,24.06,25.12,25.75,23.03,19.97,19.66,19.5,17.53,15.28,15.09,16.25,15.19,12.91,12.0,13.22,13.31,11.25,10.31,11.88,12.94,11.78,9.78,9.94,10.12,8.06,4.91,3.75,4.47,3.94,2.16,1.62,3.34,4.38,2.69,1.75,3.62,5.59,5.62,4.81,6.69,9.53,10.34,10.12,11.56,14.56,15.31,14.09,13.66,15.44,16.25,14.03,11.03,10.16,9.0,6.25,3.25,3.59,5.47,6.12,5.06,5.28,7.81,8.97,8.0,7.84,9.97,11.53,10.16,9.03,10.22,12.16,12.62,12.12,13.81,16.47,17.12,15.44,14.03,13.78,11.75,7.41,3.56,3.25,3.94,3.22,2.88,4.91,7.06,6.53,3.56,2.16,1.91,1.06,-1.38,-1.78,0.69,2.44,1.91,1.06,2.84,4.62,4.44,3.78,5.62,8.28,9.06,7.84,7.97,9.44,9.91,7.75,6.38,7.12,7.5,5.06,2.16,1.94,2.16,0.59,-0.91,1.16,5.03,7.66,8.69,10.41,13.62,15.22,14.34,13.41,14.47,14.91,12.38,9.12,8.06,7.31,5.09,2.19,2.06,4.16,5.38,4.81,4.75,6.78,8.5,8.09,7.47,9.09,10.34,8.84,6.19,5.78,6.78,6.41,5.03,5.75,8.66,10.78,10.56,11.16,13.72,15.66,14.84,13.88,15.66,17.25,16.75,14.91,14.59,15.66,14.59,12.12,10.84,11.22,11.06,8.28,6.38,6.78,7.56,5.88,4.28,5.25,6.84,6.56,5.59,7.03,9.84,11.62,12.0,13.88,17.34,20.03,19.84,19.72,21.0,21.91,20.0,17.31,16.72,17.12,15.91,13.69,12.91,13.66,13.22,10.53,8.84,9.72,10.47,9.25,8.94,10.97,13.22,13.38,11.91,11.78,13.06,12.47,10.44,10.25,12.28,13.78,13.47,13.97,16.88,19.19,18.56,17.28,17.66,18.62,16.94,14.09,12.25,11.41,9.19,5.47,3.19,4.31,5.66,5.25,5.75,9.31,13.06,14.22,14.19,15.44,17.12,16.19,13.53,12.69,13.62,13.69,11.69,10.94,12.41,13.44,12.03,11.03,12.22,14.25,13.91,12.5,12.56,13.81,12.94,10.72,9.59,10.59,10.88,9.47,8.66,10.75,12.91,12.78,12.19,13.22,14.44,13.41,11.0,10.44,11.81,11.84,10.88,11.56,14.75,16.91,16.31,15.41,16.12,16.19,13.62,11.22,11.06,12.22,11.78,10.12,9.62,10.94,11.0,9.19,8.91,11.41,13.56,13.28,13.25,14.53,16.03,15.19,12.97,12.59,13.5,12.84,10.66,10.28,12.0,12.69,11.66,10.78,12.59,14.19,13.34,12.12,13.03,14.47,13.88,12.34,12.06,12.75,11.62,8.78,6.66,7.41,7.78,6.34,5.03,6.47,7.5,6.69,6.0,7.44,10.0,10.53,9.09,8.66,9.31,9.09,6.97,5.81,7.47,8.72,7.72,6.72,7.84,9.56,9.16,8.19,9.22,11.75,12.62,12.0,12.41,14.81,16.06,15.16,14.38,16.28,17.88,17.16,15.72,16.72,18.12,17.84,16.31,16.81,18.75,18.81,17.25,16.31,17.41,17.5,15.44,12.72,12.47,12.53,10.59,8.78,9.84,12.41,14.16,14.88,16.81,20.25,21.41,19.94,18.53,19.5,20.53,19.88,19.41,21.59,24.09,24.25,23.44,23.5,24.31,22.62,18.53,15.47,14.41,12.94,9.56,6.84,6.91,6.84,4.62,1.59,1.44,2.31,2.31,1.75,4.12,8.72,12.0,13.31,15.22,18.19,20.0,18.84,17.38,18.31,19.5,19.25,18.75,19.97,21.75,21.22,18.38,16.59,16.47,15.12,11.88,9.28,8.75,8.31,5.97,3.81,4.41,6.0,5.38,4.25,5.03,3.78,2.38,2.19,1.66,0.09,-1.81,-1.41,-0.16,0.28,0.25,1.91,5.03,6.91,7.06:-0.03,-2.59,-3.59,-3.59,-4.62,-7.19,-8.38,-6.47,-5.06,-5.34,-5.16,-1.94,1.31,1.97,1.72,2.91,5.12,5.5,4.38,4.91,6.72,7.0,4.62,3.06,3.34,3.69,1.31,-0.88,-0.72,0.0,-1.09,-3.16,-3.28,-1.69,-0.84,-1.38,-0.38,2.66,4.25,2.66,0.94,1.72,2.91,2.28,1.81,4.72,8.56,10.94,11.94,14.62,18.41,20.12,18.69,17.19,16.88,15.0,10.31,6.25,5.38,6.09,5.56,5.19,7.44,10.59,11.69,11.09,11.75,14.12,15.28,13.75,13.28,14.84,16.31,15.12,13.91,14.78,16.03,14.81,12.84,12.5,13.5,13.12,10.59,9.62,10.59,11.34,9.53,8.59,10.19,11.97,11.28,10.34,11.38,12.31,11.09,7.69,5.69,5.09,3.44,0.5,-0.75,0.75,1.78,0.91,0.53,2.59,5.47,5.91,5.53,6.75,8.41,7.69,5.06,3.81,4.47,4.0,1.91,0.78,2.12,3.41,1.88,0.62,1.41,2.78,1.66,-0.28,-0.97,-0.22,-0.78,-2.66,-2.91,-0.75,1.41,1.28,1.75,4.28,6.88,6.53,5.62,6.91,9.28,9.91,9.28,9.94,11.84,12.22,9.88,8.0,8.19,8.12,5.69,3.78,4.62,6.28,6.06,5.88,7.47,10.56,11.78,11.41,12.16,14.0,14.41,12.34,10.94,12.22,13.66,13.28,13.44,16.12,19.75,20.84,20.66,21.31,22.34,21.25,18.16,16.12,16.41,15.97,12.94,10.12,9.66,9.53,7.03,4.5,4.66,6.0,5.12,3.34,3.28,4.75,5.25,3.31,2.5,3.72,4.28,2.28,0.66,1.41,3.06,2.59,1.59,2.84,5.03,5.44,4.09,3.81,5.47,5.84,4.28,3.19,5.06,6.38,5.38,4.41,5.34,7.06,6.81,5.75,6.12,8.31,8.41,6.56,6.12,7.16,7.31,5.41,3.84,4.38,5.5,4.22,2.47,2.69,4.16,3.62,2.09,2.28,4.53,5.19,3.88,3.41,5.16,6.34,5.28,4.09,5.62,7.38,7.0,5.56,5.44,5.66,3.56,-0.16,-2.78,-2.59,-2.94,-4.56,-4.91,-2.12,0.41,0.75,0.41,2.12,4.25,3.91,2.0,1.81,3.09,2.53,0.62,-0.69,0.41,0.88,-0.88,-2.47,-1.5,-0.78,-2.28,-4.22,-3.69,-2.12,-1.84,-3.0,-2.62,-0.47,0.19,-1.44,-2.38,-1.16,-0.34,-1.59,-2.88,-1.5,0.5,0.78,-0.25,0.62,2.59,2.69,0.72,0.0,1.5,2.5,1.16,0.53,2.88,5.16,5.44,5.66,8.38,11.44,11.72,9.91,9.12,9.28,7.69,4.28,2.53,3.44,3.69,2.31,1.12,2.62,4.44,4.19,2.94,3.72,5.34,4.53,2.62,2.78,5.19,7.44,7.53,8.31,11.03,12.56,11.72,10.31,11.41,13.19,12.69,11.22,11.59,13.06,12.41,9.56,8.06,8.34,7.72,5.34,4.22,5.59,7.28,6.62,5.31,6.84,8.34,7.91,5.81,5.44,6.03,4.91,1.97,0.22,1.25,1.91,1.09,1.12,3.62,5.62,4.88,2.72,2.53,3.56,3.66,3.53,5.75,10.09,12.62,12.06,11.25,11.78,11.16,7.78,4.53,3.84,4.09,2.19,-0.09,0.03,2.0,2.34,1.66,2.91,5.69,7.53,6.34,5.62,6.62,7.97,7.34,6.75,8.56,11.34,11.69,10.03,9.88,10.69,10.53,8.31,7.41,8.72,9.06,7.5,6.72,9.0,11.81,12.19,11.44,11.84,12.16,10.06,6.59,5.12,5.81,5.84,3.81,2.12,2.66,2.69,0.69,-0.81,0.91,4.44,5.75,7.12,10.5,14.53,15.97,14.62,13.97,14.62,14.0,10.47,8.06,7.88,7.91,6.12,4.31,5.44,7.72,8.22,7.66,9.22,12.53,13.81,12.91,13.22,14.75,15.38,13.59,12.31,13.22,14.03,11.78,8.5,7.44,7.59,7.09,6.22,7.75,11.69,13.59,12.44,11.19,11.38,10.84,8.0,5.56,6.59,8.44,8.47,8.44,10.5,14.38,15.91,15.41,16.25,18.56,19.59,18.34,17.84,19.25,19.84,16.25,12.41,9.72,8.53,5.75,2.5,2.31,4.41,5.09,4.28,4.94,7.72,9.22,7.62,5.66,5.75,5.88,3.19,0.28,-0.03,0.56,-0.97,-3.03,-2.94,-0.62,0.44,-0.53,-1.31,-0.28,-0.31,-3.66,-6.34,-6.84,-6.53,-8.12,-9.75,-8.25,-4.88,-2.75,-1.72,0.91,5.34,8.47,8.5,9.09,11.69,13.38,11.75,9.88,9.53,10.22,8.44,5.97,5.81,7.34,7.47,6.16,6.53,9.06,10.78,9.91,9.34,10.97,12.5,11.19,9.44,9.56,10.12,8.53,5.97,5.41,7.06,7.66,6.19,5.94,8.19,9.53,8.69,8.19,10.12,12.44,12.38,11.94,14.0,17.28,17.84,16.16,15.12,15.47,13.94,10.44,8.41,9.28,10.44,9.22,8.31,10.34,13.53,14.06,13.47,14.22,16.34,15.81,13.25,11.94,12.84,13.16,10.62,9.19,10.69,12.78,12.28,11.88,14.06,16.47,16.22,14.97,15.47,18.19,20.06,20.5,22.34,26.19,28.56,27.31,24.88,23.56,21.22,15.03,8.09,3.88,1.59,-1.5,-4.66,-4.72,-2.0,0.28,1.62,3.97,9.25,13.94,15.84,17.0,20.34,23.56,23.69,22.03,21.91,22.53,20.5,17.12,15.25,15.66,14.75,12.0,9.88,10.22,10.62,8.69,6.72,7.41,9.53,10.16,10.22,12.81,17.09,19.84,20.72,22.59,26.88,29.25,29.12,28.59,30.06,31.44,30.62,29.38,30.66,32.94,32.38,29.81,28.56,28.88,28.0,25.38,24.06,25.12,25.75,23.03,19.97,19.66,19.5,17.53,15.28,15.09,16.25,15.19,12.91,12.0,13.22,13.31,11.25,10.31,11.88,12.94,11.78,9.78,9.94,10.12,8.06,4.91,3.75,4.47,3.94,2.16,1.62,3.34,4.38,2.69,1.75,3.62,5.59,5.62,4.81,6.69,9.53,10.34,10.12,11.56,14.56,15.31,14.09,13.66,15.44,16.25,14.03,11.03,10.16,9.0,6.25,3.25,3.59,5.47,6.12,5.06,5.28,7.81,8.97,8.0,7.84,9.97,11.53,10.16,9.03,10.22,12.16,12.62,12.12,13.81,16.47,17.12,15.44,14.03,13.78,11.75,7.41,3.56,3.25,3.94,3.22,2.88,4.91,7.06,6.53,3.56,2.16,1.91,1.06,-1.38,-1.78,0.69,2.44,1.91,1.06,2.84,4.62,4.44,3.78,5.62,8.28,9.06,7.84,7.97,9.44,9.91,7.75,6.38,7.12,7.5,5.06,2.16,1.94,2.16,0.59,-0.91,1.16,5.03,7.66,8.69,10.41,13.62,15.22,14.34,13.41,14.47,14.91,12.38,9.12,8.06,7.31,5.09,2.19,2.06,4.16,5.38,4.81,4.75,6.78,8.5,8.09,7.47,9.09,10.34,8.84,6.19,5.78,6.78,6.41,5.03,5.75,8.66,10.78,10.56,11.16,13.72,15.66,14.84,13.88,15.66,17.25,16.75,14.91,14.59,15.66,14.59,12.12,10.84,11.22,11.06,8.28,6.38,6.78,7.56,5.88,4.28,5.25,6.84,6.56,5.59,7.03,9.84,11.62,12.0,13.88,17.34,20.03,19.84,19.72,21.0,21.91,20.0,17.31,16.72,17.12,15.91,13.69,12.91,13.66,13.22,10.53,8.84,9.72,10.47,9.25,8.94,10.97,13.22,13.38,11.91,11.78,13.06,12.47,10.44,10.25,12.28,13.78,13.47,13.97,16.88,19.19,18.56,17.28,17.66,18.62,16.94,14.09,12.25,11.41,9.19,5.47,3.19,4.31,5.66,5.25,5.75,9.31,13.06,14.22,14.19,15.44,17.12,16.19,13.53,12.69,13.62,13.69,11.69,10.94,12.41,13.44,12.03,11.03,12.22,14.25,13.91,12.5,12.56,13.81,12.94,10.72,9.59,10.59,10.88,9.47,8.66,10.75,12.91,12.78,12.19,13.22,14.44,13.41,11.0,10.44,11.81,11.84,10.88,11.56,14.75,16.91,16.31,15.41,16.12,16.19,13.62,11.22,11.06,12.22,11.78,10.12,9.62,10.94,11.0,9.19,8.91,11.41,13.56,13.28,13.25,14.53,16.03,15.19,12.97,12.59,13.5,12.84,10.66,10.28,12.0,12.69,11.66,10.78,12.59,14.19,13.34,12.12,13.03,14.47,13.88,12.34,12.06,12.75,11.62,8.78,6.66,7.41,7.78,6.34,5.03,6.47,7.5,6.69,6.0,7.44,10.0,10.53,9.09,8.66,9.31,9.09,6.97,5.81,7.47,8.72,7.72,6.72,7.84,9.56,9.16,8.19,9.22,11.75,12.62,12.0,12.41,14.81,16.06,15.16,14.38,16.28,17.88,17.16,15.72,16.72,18.12,17.84,16.31,16.81,18.75,18.81,17.25,16.31,17.41,17.5,15.44,12.72,12.47,12.53,10.59,8.78,9.84,12.41,14.16,14.88,16.81,20.25,21.41,19.94,18.53,19.5,20.53,19.88,19.41,21.59,24.09,24.25,23.44,23.5,24.31,22.62,18.53,15.47,14.41,12.94,9.56,6.84,6.91,6.84,4.62,1.59,1.44,2.31,2.31,1.75,4.12,8.72,12.0,13.31,15.22,18.19,20.0,18.84,17.38,18.31,19.5,19.25,18.75,19.97,21.75,21.22,18.38,16.59,16.47,15.12,11.88,9.28,8.75,8.31,5.97,3.81,4.41,6.0,5.38,4.25,5.03,3.78,2.38,2.19,1.66,0.09,-1.81,-1.41,-0.16,0.28,0.25,1.91,5.03,6.91,7.06,7.0,7.5,7.34,5.72,4.53,5.44,6.5:-6.47,-5.06,-5.34,-5.16,-1.94,1.31,1.97,1.72,2.91,5.12,5.5,4.38,4.91,6.72,7.0,4.62,3.06,3.34,3.69,1.31,-0.88,-0.72,0.0,-1.09,-3.16,-3.28,-1.69,-0.84,-1.38,-0.38,2.66,4.25,2.66,0.94,1.72,2.91,2.28,1.81,4.72,8.56,10.94,11.94,14.62,18.41,20.12,18.69,17.19,16.88,15.0,10.31,6.25,5.38,6.09,5.56,5.19,7.44,10.59,11.69,11.09,11.75,14.12,15.28,13.75,13.28,14.84,16.31,15.12,13.91,14.78,16.03,14.81,12.84,12.5,13.5,13.12,10.59,9.62,10.59,11.34,9.53,8.59,10.19,11.97,11.28,10.34,11.38,12.31,11.09,7.69,5.69,5.09,3.44,0.5,-0.75,0.75,1.78,0.91,0.53,2.59,5.47,5.91,5.53,6.75,8.41,7.69,5.06,3.81,4.47,4.0,1.91,0.78,2.12,3.41,1.88,0.62,1.41,2.78,1.66,-0.28,-0.97,-0.22,-0.78,-2.66,-2.91,-0.75,1.41,1.28,1.75,4.28,6.88,6.53,5.62,6.91,9.28,9.91,9.28,9.94,11.84,12.22,9.88,8.0,8.19,8.12,5.69,3.78,4.62,6.28,6.06,5.88,7.47,10.56,11.78,11.41,12.16,14.0,14.41,12.34,10.94,12.22,13.66,13.28,13.44,16.12,19.75,20.84,20.66,21.31,22.34,21.25,18.16,16.12,16.41,15.97,12.94,10.12,9.66,9.53,7.03,4.5,4.66,6.0,5.12,3.34,3.28,4.75,5.25,3.31,2.5,3.72,4.28,2.28,0.66,1.41,3.06,2.59,1.59,2.84,5.03,5.44,4.09,3.81,5.47,5.84,4.28,3.19,5.06,6.38,5.38,4.41,5.34,7.06,6.81,5.75,6.12,8.31,8.41,6.56,6.12,7.16,7.31,5.41,3.84,4.38,5.5,4.22,2.47,2.69,4.16,3.62,2.09,2.28,4.53,5.19,3.88,3.41,5.16,6.34,5.28,4.09,5.62,7.38,7.0,5.56,5.44,5.66,3.56,-0.16,-2.78,-2.59,-2.94,-4.56,-4.91,-2.12,0.41,0.75,0.41,2.12,4.25,3.91,2.0,1.81,3.09,2.53,0.62,-0.69,0.41,0.88,-0.88,-2.47,-1.5,-0.78,-2.28,-4.22,-3.69,-2.12,-1.84,-3.0,-2.62,-0.47,0.19,-1.44,-2.38,-1.16,-0.34,-1.59,-2.88,-1.5,0.5,0.78,-0.25,0.62,2.59,2.69,0.72,0.0,1.5,2.5,1.16,0.53,2.88,5.16,5.44,5.66,8.38,11.44,11.72,9.91,9.12,9.28,7.69,4.28,2.53,3.44,3.69,2.31,1.12,2.62,4.44,4.19,2.94,3.72,5.34,4.53,2.62,2.78,5.19,7.44,7.53,8.31,11.03,12.56,11.72,10.31,11.41,13.19,12.69,11.22,11.59,13.06,12.41,9.56,8.06,8.34,7.72,5.34,4.22,5.59,7.28,6.62,5.31,6.84,8.34,7.91,5.81,5.44,6.03,4.91,1.97,0.22,1.25,1.91,1.09,1.12,3.62,5.62,4.88,2.72,2.53,3.56,3.66,3.53,5.75,10.09,12.62,12.06,11.25,11.78,11.16,7.78,4.53,3.84,4.09,2.19,-0.09,0.03,2.0,2.34,1.66,2.91,5.69,7.53,6.34,5.62,6.62,7.97,7.34,6.75,8.56,11.34,11.69,10.03,9.88,10.69,10.53,8.31,7.41,8.72,9.06,7.5,6.72,9.0,11.81,12.19,11.44,11.84,12.16,10.06,6.59,5.12,5.81,5.84,3.81,2.12,2.66,2.69,0.69,-0.81,0.91,4.44,5.75,7.12,10.5,14.53,15.97,14.62,13.97,14.62,14.0,10.47,8.06,7.88,7.91,6.12,4.31,5.44,7.72,8.22,7.66,9.22,12.53,13.81,12.91,13.22,14.75,15.38,13.59,12.31,13.22,14.03,11.78,8.5,7.44,7.59,7.09,6.22,7.75,11.69,13.59,12.44,11.19,11.38,10.84,8.0,5.56,6.59,8.44,8.47,8.44,10.5,14.38,15.91,15.41,16.25,18.56,19.59,18.34,17.84,19.25,19.84,16.25,12.41,9.72,8.53,5.75,2.5,2.31,4.41,5.09,4.28,4.94,7.72,9.22,7.62,5.66,5.75,5.88,3.19,0.28,-0.03,0.56,-0.97,-3.03,-2.94,-0.62,0.44,-0.53,-1.31,-0.28,-0.31,-3.66,-6.34,-6.84,-6.53,-8.12,-9.75,-8.25,-4.88,-2.75,-1.72,0.91,5.34,8.47,8.5,9.09,11.69,13.38,11.75,9.88,9.53,10.22,8.44,5.97,5.81,7.34,7.47,6.16,6.53,9.06,10.78,9.91,9.34,10.97,12.5,11.19,9.44,9.56,10.12,8.53,5.97,5.41,7.06,7.66,6.19,5.94,8.19,9.53,8.69,8.19,10.12,12.44,12.38,11.94,14.0,17.28,17.84,16.16,15.12,15.47,13.94,10.44,8.41,9.28,10.44,9.22,8.31,10.34,13.53,14.06,13.47,14.22,16.34,15.81,13.25,11.94,12.84,13.16,10.62,9.19,10.69,12.78,12.28,11.88,14.06,16.47,16.22,14.97,15.47,18.19,20.06,20.5,22.34,26.19,28.56,27.31,24.88,23.56,21.22,15.03,8.09,3.88,1.59,-1.5,-4.66,-4.72,-2.0,0.28,1.62,3.97,9.25,13.94,15.84,17.0,20.34,23.56,23.69,22.03,21.91,22.53,20.5,17.12,15.25,15.66,14.75,12.0,9.88,10.22,10.62,8.69,6.72,7.41,9.53,10.16,10.22,12.81,17.09,19.84,20.72,22.59,26.88,29.25,29.12,28.59,30.06,31.44,30.62,29.38,30.66,32.94,32.38,29.81,28.56,28.88,28.0,25.38,24.06,25.12,25.75,23.03,19.97,19.66,19.5,17.53,15.28,15.09,16.25,15.19,12.91,12.0,13.22,13.31,11.25,10.31,11.88,12.94,11.78,9.78,9.94,10.12,8.06,4.91,3.75,4.47,3.94,2.16,1.62,3.34,4.38,2.69,1.75,3.62,5.59,5.62,4.81,6.69,9.53,10.34,10.12,11.56,14.56,15.31,14.09,13.66,15.44,16.25,14.03,11.03,10.16,9.0,6.25,3.25,3.59,5.47,6.12,5.06,5.28,7.81,8.97,8.0,7.84,9.97,11.53,10.16,9.03,10.22,12.16,12.62,12.12,13.81,16.47,17.12,15.44,14.03,13.78,11.75,7.41,3.56,3.25,3.94,3.22,2.88,4.91,7.06,6.53,3.56,2.16,1.91,1.06,-1.38,-1.78,0.69,2.44,1.91,1.06,2.84,4.62,4.44,3.78,5.62,8.28,9.06,7.84,7.97,9.44,9.91,7.75,6.38,7.12,7.5,5.06,2.16,1.94,2.16,0.59,-0.91,1.16,5.03,7.66,8.69,10.41,13.62,15.22,14.34,13.41,14.47,14.91,12.38,9.12,8.06,7.31,5.09,2.19,2.06,4.16,5.38,4.81,4.75,6.78,8.5,8.09,7.47,9.09,10.34,8.84,6.19,5.78,6.78,6.41,5.03,5.75,8.66,10.78,10.56,11.16,13.72,15.66,14.84,13.88,15.66,17.25,16.75,14.91,14.59,15.66,14.59,12.12,10.84,11.22,11.06,8.28,6.38,6.78,7.56,5.88,4.28,5.25,6.84,6.56,5.59,7.03,9.84,11.62,12.0,13.88,17.34,20.03,19.84,19.72,21.0,21.91,20.0,17.31,16.72,17.12,15.91,13.69,12.91,13.66,13.22,10.53,8.84,9.72,10.47,9.25,8.94,10.97,13.22,13.38,11.91,11.78,13.06,12.47,10.44,10.25,12.28,13.78,13.47,13.97,16.88,19.19,18.56,17.28,17.66,18.62,16.94,14.09,12.25,11.41,9.19,5.47,3.19,4.31,5.66,5.25,5.75,9.31,13.06,14.22,14.19,15.44,17.12,16.19,13.53,12.69,13.62,13.69,11.69,10.94,12.41,13.44,12.03,11.03,12.22,14.25,13.91,12.5,12.56,13.81,12.94,10.72,9.59,10.59,10.88,9.47,8.66,10.75,12.91,12.78,12.19,13.22,14.44,13.41,11.0,10.44,11.81,11.84,10.88,11.56,14.75,16.91,16.31,15.41,16.12,16.19,13.62,11.22,11.06,12.22,11.78,10.12,9.62,10.94,11.0,9.19,8.91,11.41,13.56,13.28,13.25,14.53,16.03,15.19,12.97,12.59,13.5,12.84,10.66,10.28,12.0,12.69,11.66,10.78,12.59,14.19,13.34,12.12,13.03,14.47,13.88,12.34,12.06,12.75,11.62,8.78,6.66,7.41,7.78,6.34,5.03,6.47,7.5,6.69,6.0,7.44,10.0,10.53,9.09,8.66,9.31,9.09,6.97,5.81,7.47,8.72,7.72,6.72,7.84,9.56,9.16,8.19,9.22,11.75,12.62,12.0,12.41,14.81,16.06,15.16,14.38,16.28,17.88,17.16,15.72,16.72,18.12,17.84,16.31,16.81,18.75,18.81,17.25,16.31,17.41,17.5,15.44,12.72,12.47,12.53,10.59,8.78,9.84,12.41,14.16,14.88,16.81,20.25,21.41,19.94,18.53,19.5,20.53,19.88,19.41,21.59,24.09,24.25,23.44,23.5,24.31,22.62,18.53,15.47,14.41,12.94,9.56,6.84,6.91,6.84,4.62,1.59,1.44,2.31,2.31,1.75,4.12,8.72,12.0,13.31,15.22,18.19,20.0,18.84,17.38,18.31,19.5,19.25,18.75,19.97,21.75,21.22,18.38,16.59,16.47,15.12,11.88,9.28,8.75,8.31,5.97,3.81,4.41,6.0,5.38,4.25,5.03,3.78,2.38,2.19,1.66,0.09,-1.81,-1.41,-0.16,0.28,0.25,1.91,5.03,6.91,7.06,7.0,7.5,7.34,5.72,4.53,5.44,6.5,5.94,4.31,3.53,2.78,1.03,-1.06,-1.78:1.72,2.91,5.12,5.5,4.38,4.91,6.72,7.0,4.62,3.06,3.34,3.69,1.31,-0.88,-0.72,0.0,-1.09,-3.16,-3.28,-1.69,-0.84,-1.38,-0.38,2.66,4.25,2.66,0.94,1.72,2.91,2.28,1.81,4.72,8.56,10.94,11.94,14.62,18.41,20.12,18.69,17.19,16.88,15.0,10.31,6.25,5.38,6.09,5.56,5.19,7.44,10.59,11.69,11.09,11.75,14.12,15.28,13.75,13.28,14.84,16.31,15.12,13.91,14.78,16.03,14.81,12.84,12.5,13.5,13.12,10.59,9.62,10.59,11.34,9.53,8.59,10.19,11.97,11.28,10.34,11.38,12.31,11.09,7.69,5.69,5.09,3.44,0.5,-0.75,0.75,1.78,0.91,0.53,2.59,5.47,5.91,5.53,6.75,8.41,7.69,5.06,3.81,4.47,4.0,1.91,0.78,2.12,3.41,1.88,0.62,1.41,2.78,1.66,-0.28,-0.97,-0.22,-0.78,-2.66,-2.91,-0.75,1.41,1.28,1.75,4.28,6.88,6.53,5.62,6.91,9.28,9.91,9.28,9.94,11.84,12.22,9.88,8.0,8.19,8.12,5.69,3.78,4.62,6.28,6.06,5.88,7.47,10.56,11.78,11.41,12.16,14.0,14.41,12.34,10.94,12.22,13.66,13.28,13.44,16.12,19.75,20.84,20.66,21.31,22.34,21.25,18.16,16.12,16.41,15.97,12.94,10.12,9.66,9.53,7.03,4.5,4.66,6.0,5.12,3.34,3.28,4.75,5.25,3.31,2.5,3.72,4.28,2.28,0.66,1.41,3.06,2.59,1.59,2.84,5.03,5.44,4.09,3.81,5.47,5.84,4.28,3.19,5.06,6.38,5.38,4.41,5.34,7.06,6.81,5.75,6.12,8.31,8.41,6.56,6.12,7.16,7.31,5.41,3.84,4.38,5.5,4.22,2.47,2.69,4.16,3.62,2.09,2.28,4.53,5.19,3.88,3.41,5.16,6.34,5.28,4.09,5.62,7.38,7.0,5.56,5.44,5.66,3.56,-0.16,-2.78,-2.59,-2.94,-4.56,-4.91,-2.12,0.41,0.75,0.41,2.12,4.25,3.91,2.0,1.81,3.09,2.53,0.62,-0.69,0.41,0.88,-0.88,-2.47,-1.5,-0.78,-2.28,-4.22,-3.69,-2.12,-1.84,-3.0,-2.62,-0.47,0.19,-1.44,-2.38,-1.16,-0.34,-1.59,-2.88,-1.5,0.5,0.78,-0.25,0.62,2.59,2.69,0.72,0.0,1.5,2.5,1.16,0.53,2.88,5.16,5.44,5.66,8.38,11.44,11.72,9.91,9.12,9.28,7.69,4.28,2.53,3.44,3.69,2.31,1.12,2.62,4.44,4.19,2.94,3.72,5.34,4.53,2.62,2.78,5.19,7.44,7.53,8.31,11.03,12.56,11.72,10.31,11.41,13.19,12.69,11.22,11.59,13.06,12.41,9.56,8.06,8.34,7.72,5.34,4.22,5.59,7.28,6.62,5.31,6.84,8.34,7.91,5.81,5.44,6.03,4.91,1.97,0.22,1.25,1.91,1.09,1.12,3.62,5.62,4.88,2.72,2.53,3.56,3.66,3.53,5.75,10.09,12.62,12.06,11.25,11.78,11.16,7.78,4.53,3.84,4.09,2.19,-0.09,0.03,2.0,2.34,1.66,2.91,5.69,7.53,6.34,5.62,6.62,7.97,7.34,6.75,8.56,11.34,11.69,10.03,9.88,10.69,10.53,8.31,7.41,8.72,9.06,7.5,6.72,9.0,11.81,12.19,11.44,11.84,12.16,10.06,6.59,5.12,5.81,5.84,3.81,2.12,2.66,2.69,0.69,-0.81,0.91,4.44,5.75,7.12,10.5,14.53,15.97,14.62,13.97,14.62,14.0,10.47,8.06,7.88,7.91,6.12,4.31,5.44,7.72,8.22,7.66,9.22,12.53,13.81,12.91,13.22,14.75,15.38,13.59,12.31,13.22,14.03,11.78,8.5,7.44,7.59,7.09,6.22,7.75,11.69,13.59,12.44,11.19,11.38,10.84,8.0,5.56,6.59,8.44,8.47,8.44,10.5,14.38,15.91,15.41,16.25,18.56,19.59,18.34,17.84,19.25,19.84,16.25,12.41,9.72,8.53,5.75,2.5,2.31,4.41,5.09,4.28,4.94,7.72,9.22,7.62,5.66,5.75,5.88,3.19,0.28,-0.03,0.56,-0.97,-3.03,-2.94,-0.62,0.44,-0.53,-1.31,-0.28,-0.31,-3.66,-6.34,-6.84,-6.53,-8.12,-9.75,-8.25,-4.88,-2.75,-1.72,0.91,5.34,8.47,8.5,9.09,11.69,13.38,11.75,9.88,9.53,10.22,8.44,5.97,5.81,7.34,7.47,6.16,6.53,9.06,10.78,9.91,9.34,10.97,12.5,11.19,9.44,9.56,10.12,8.53,5.97,5.41,7.06,7.66,6.19,5.94,8.19,9.53,8.69,8.19,10.12,12.44,12.38,11.94,14.0,17.28,17.84,16.16,15.12,15.47,13.94,10.44,8.41,9.28,10.44,9.22,8.31,10.34,13.53,14.06,13.47,14.22,16.34,15.81,13.25,11.94,12.84,13.16,10.62,9.19,10.69,12.78,12.28,11.88,14.06,16.47,16.22,14.97,15.47,18.19,20.06,20.5,22.34,26.19,28.56,27.31,24.88,23.56,21.22,15.03,8.09,3.88,1.59,-1.5,-4.66,-4.72,-2.0,0.28,1.62,3.97,9.25,13.94,15.84,17.0,20.34,23.56,23.69,22.03,21.91,22.53,20.5,17.12,15.25,15.66,14.75,12.0,9.88,10.22,10.62,8.69,6.72,7.41,9.53,10.16,10.22,12.81,17.09,19.84,20.72,22.59,26.88,29.25,29.12,28.59,30.06,31.44,30.62,29.38,30.66,32.94,32.38,29.81,28.56,28.88,28.0,25.38,24.06,25.12,25.75,23.03,19.97,19.66,19.5,17.53,15.28,15.09,16.25,15.19,12.91,12.0,13.22,13.31,11.25,10.31,11.88,12.94,11.78,9.78,9.94,10.12,8.06,4.91,3.75,4.47,3.94,2.16,1.62,3.34,4.38,2.69,1.75,3.62,5.59,5.62,4.81,6.69,9.53,10.34,10.12,11.56,14.56,15.31,14.09,13.66,15.44,16.25,14.03,11.03,10.16,9.0,6.25,3.25,3.59,5.47,6.12,5.06,5.28,7.81,8.97,8.0,7.84,9.97,11.53,10.16,9.03,10.22,12.16,12.62,12.12,13.81,16.47,17.12,15.44,14.03,13.78,11.75,7.41,3.56,3.25,3.94,3.22,2.88,4.91,7.06,6.53,3.56,2.16,1.91,1.06,-1.38,-1.78,0.69,2.44,1.91,1.06,2.84,4.62,4.44,3.78,5.62,8.28,9.06,7.84,7.97,9.44,9.91,7.75,6.38,7.12,7.5,5.06,2.16,1.94,2.16,0.59,-0.91,1.16,5.03,7.66,8.69,10.41,13.62,15.22,14.34,13.41,14.47,14.91,12.38,9.12,8.06,7.31,5.09,2.19,2.06,4.16,5.38,4.81,4.75,6.78,8.5,8.09,7.47,9.09,10.34,8.84,6.19,5.78,6.78,6.41,5.03,5.75,8.66,10.78,10.56,11.16,13.72,15.66,14.84,13.88,15.66,17.25,16.75,14.91,14.59,15.66,14.59,12.12,10.84,11.22,11.06,8.28,6.38,6.78,7.56,5.88,4.28,5.25,6.84,6.56,5.59,7.03,9.84,11.62,12.0,13.88,17.34,20.03,19.84,19.72,21.0,21.91,20.0,17.31,16.72,17.12,15.91,13.69,12.91,13.66,13.22,10.53,8.84,9.72,10.47,9.25,8.94,10.97,13.22,13.38,11.91,11.78,13.06,12.47,10.44,10.25,12.28,13.78,13.47,13.97,16.88,19.19,18.56,17.28,17.66,18.62,16.94,14.09,12.25,11.41,9.19,5.47,3.19,4.31,5.66,5.25,5.75,9.31,13.06,14.22,14.19,15.44,17.12,16.19,13.53,12.69,13.62,13.69,11.69,10.94,12.41,13.44,12.03,11.03,12.22,14.25,13.91,12.5,12.56,13.81,12.94,10.72,9.59,10.59,10.88,9.47,8.66,10.75,12.91,12.78,12.19,13.22,14.44,13.41,11.0,10.44,11.81,11.84,10.88,11.56,14.75,16.91,16.31,15.41,16.12,16.19,13.62,11.22,11.06,12.22,11.78,10.12,9.62,10.94,11.0,9.19,8.91,11.41,13.56,13.28,13.25,14.53,16.03,15.19,12.97,12.59,13.5,12.84,10.66,10.28,12.0,12.69,11.66,10.78,12.59,14.19,13.34,12.12,13.03,14.47,13.88,12.34,12.06,12.75,11.62,8.78,6.66,7.41,7.78,6.34,5.03,6.47,7.5,6.69,6.0,7.44,10.0,10.53,9.09,8.66,9.31,9.09,6.97,5.81,7.47,8.72,7.72,6.72,7.84,9.56,9.16,8.19,9.22,11.75,12.62,12.0,12.41,14.81,16.06,15.16,14.38,16.28,17.88,17.16,15.72,16.72,18.12,17.84,16.31,16.81,18.75,18.81,17.25,16.31,17.41,17.5,15.44,12.72,12.47,12.53,10.59,8.78,9.84,12.41,14.16,14.88,16.81,20.25,21.41,19.94,18.53,19.5,20.53,19.88,19.41,21.59,24.09,24.25,23.44,23.5,24.31,22.62,18.53,15.47,14.41,12.94,9.56,6.84,6.91,6.84,4.62,1.59,1.44,2.31,2.31,1.75,4.12,8.72,12.0,13.31,15.22,18.19,20.0,18.84,17.38,18.31,19.5,19.25,18.75,19.97,21.75,21.22,18.38,16.59,16.47,15.12,11.88,9.28,8.75,8.31,5.97,3.81,4.41,6.0,5.38,4.25,5.03,3.78,2.38,2.19,1.66,0.09,-1.81,-1.41,-0.16,0.28,0.25,1.91,5.03,6.91,7.06,7.0,7.5,7.34,5.72,4.53,5.44,6.5,5.94,4.31,3.53,2.78,1.03,-1.06,-1.78,-0.19,0.88,1.62,3.0,5.97,8.91,9.81:7.0,4.62,3.06,3.34,3.69,1.31,-0.88,-0.72,0.0,-1.09,-3.16,-3.28,-1.69,-0.84,-1.38,-0.38,2.66,4.25,2.66,0.94,1.72,2.91,2.28,1.81,4.72,8.56,10.94,11.94,14.62,18.41,20.12,18.69,17.19,16.88,15.0,10.31,6.25,5.38,6.09,5.56,5.19,7.44,10.59,11.69,11.09,11.75,14.12,15.28,13.75,13.28,14.84,16.31,15.12,13.91,14.78,16.03,14.81,12.84,12.5,13.5,13.12,10.59,9.62,10.59,11.34,9.53,8.59,10.19,11.97,11.28,10.34,11.38,12.31,11.09,7.69,5.69,5.09,3.44,0.5,-0.75,0.75,1.78,0.91,0.53,2.59,5.47,5.91,5.53,6.75,8.41,7.69,5.06,3.81,4.47,4.0,1.91,0.78,2.12,3.41,1.88,0.62,1.41,2.78,1.66,-0.28,-0.97,-0.22,-0.78,-2.66,-2.91,-0.75,1.41,1.28,1.75,4.28,6.88,6.53,5.62,6.91,9.28,9.91,9.28,9.94,11.84,12.22,9.88,8.0,8.19,8.12,5.69,3.78,4.62,6.28,6.06,5.88,7.47,10.56,11.78,11.41,12.16,14.0,14.41,12.34,10.94,12.22,13.66,13.28,13.44,16.12,19.75,20.84,20.66,21.31,22.34,21.25,18.16,16.12,16.41,15.97,12.94,10.12,9.66,9.53,7.03,4.5,4.66,6.0,5.12,3.34,3.28,4.75,5.25,3.31,2.5,3.72,4.28,2.28,0.66,1.41,3.06,2.59,1.59,2.84,5.03,5.44,4.09,3.81,5.47,5.84,4.28,3.19,5.06,6.38,5.38,4.41,5.34,7.06,6.81,5.75,6.12,8.31,8.41,6.56,6.12,7.16,7.31,5.41,3.84,4.38,5.5,4.22,2.47,2.69,4.16,3.62,2.09,2.28,4.53,5.19,3.88,3.41,5.16,6.34,5.28,4.09,5.62,7.38,7.0,5.56,5.44,5.66,3.56,-0.16,-2.78,-2.59,-2.94,-4.56,-4.91,-2.12,0.41,0.75,0.41,2.12,4.25,3.91,2.0,1.81,3.09,2.53,0.62,-0.69,0.41,0.88,-0.88,-2.47,-1.5,-0.78,-2.28,-4.22,-3.69,-2.12,-1.84,-3.0,-2.62,-0.47,0.19,-1.44,-2.38,-1.16,-0.34,-1.59,-2.88,-1.5,0.5,0.78,-0.25,0.62,2.59,2.69,0.72,0.0,1.5,2.5,1.16,0.53,2.88,5.16,5.44,5.66,8.38,11.44,11.72,9.91,9.12,9.28,7.69,4.28,2.53,3.44,3.69,2.31,1.12,2.62,4.44,4.19,2.94,3.72,5.34,4.53,2.62,2.78,5.19,7.44,7.53,8.31,11.03,12.56,11.72,10.31,11.41,13.19,12.69,11.22,11.59,13.06,12.41,9.56,8.06,8.34,7.72,5.34,4.22,5.59,7.28,6.62,5.31,6.84,8.34,7.91,5.81,5.44,6.03,4.91,1.97,0.22,1.25,1.91,1.09,1.12,3.62,5.62,4.88,2.72,2.53,3.56,3.66,3.53,5.75,10.09,12.62,12.06,11.25,11.78,11.16,7.78,4.53,3.84,4.09,2.19,-0.09,0.03,2.0,2.34,1.66,2.91,5.69,7.53,6.34,5.62,6.62,7.97,7.34,6.75,8.56,11.34,11.69,10.03,9.88,10.69,10.53,8.31,7.41,8.72,9.06,7.5,6.72,9.0,11.81,12.19,11.44,11.84,12.16,10.06,6.59,5.12,5.81,5.84,3.81,2.12,2.66,2.69,0.69,-0.81,0.91,4.44,5.75,7.12,10.5,14.53,15.97,14.62,13.97,14.62,14.0,10.47,8.06,7.88,7.91,6.12,4.31,5.44,7.72,8.22,7.66,9.22,12.53,13.81,12.91,13.22,14.75,15.38,13.59,12.31,13.22,14.03,11.78,8.5,7.44,7.59,7.09,6.22,7.75,11.69,13.59,12.44,11.19,11.38,10.84,8.0,5.56,6.59,8.44,8.47,8.44,10.5,14.38,15.91,15.41,16.25,18.56,19.59,18.34,17.84,19.25,19.84,16.25,12.41,9.72,8.53,5.75,2.5,2.31,4.41,5.09,4.28,4.94,7.72,9.22,7.62,5.66,5.75,5.88,3.19,0.28,-0.03,0.56,-0.97,-3.03,-2.94,-0.62,0.44,-0.53,-1.31,-0.28,-0.31,-3.66,-6.34,-6.84,-6.53,-8.12,-9.75,-8.25,-4.88,-2.75,-1.72,0.91,5.34,8.47,8.5,9.09,11.69,13.38,11.75,9.88,9.53,10.22,8.44,5.97,5.81,7.34,7.47,6.16,6.53,9.06,10.78,9.91,9.34,10.97,12.5,11.19,9.44,9.56,10.12,8.53,5.97,5.41,7.06,7.66,6.19,5.94,8.19,9.53,8.69,8.19,10.12,12.44,12.38,11.94,14.0,17.28,17.84,16.16,15.12,15.47,13.94,10.44,8.41,9.28,10.44,9.22,8.31,10.34,13.53,14.06,13.47,14.22,16.34,15.81,13.25,11.94,12.84,13.16,10.62,9.19,10.69,12.78,12.28,11.88,14.06,16.47,16.22,14.97,15.47,18.19,20.06,20.5,22.34,26.19,28.56,27.31,24.88,23.56,21.22,15.03,8.09,3.88,1.59,-1.5,-4.66,-4.72,-2.0,0.28,1.62,3.97,9.25,13.94,15.84,17.0,20.34,23.56,23.69,22.03,21.91,22.53,20.5,17.12,15.25,15.66,14.75,12.0,9.88,10.22,10.62,8.69,6.72,7.41,9.53,10.16,10.22,12.81,17.09,19.84,20.72,22.59,26.88,29.25,29.12,28.59,30.06,31.44,30.62,29.38,30.66,32.94,32.38,29.81,28.56,28.88,28.0,25.38,24.06,25.12,25.75,23.03,19.97,19.66,19.5,17.53,15.28,15.09,16.25,15.19,12.91,12.0,13.22,13.31,11.25,10.31,11.88,12.94,11.78,9.78,9.94,10.12,8.06,4.91,3.75,4.47,3.94,2.16,1.62,3.34,4.38,2.69,1.75,3.62,5.59,5.62,4.81,6.69,9.53,10.34,10.12,11.56,14.56,15.31,14.09,13.66,15.44,16.25,14.03,11.03,10.16,9.0,6.25,3.25,3.59,5.47,6.12,5.06,5.28,7.81,8.97,8.0,7.84,9.97,11.53,10.16,9.03,10.22,12.16,12.62,12.12,13.81,16.47,17.12,15.44,14.03,13.78,11.75,7.41,3.56,3.25,3.94,3.22,2.88,4.91,7.06,6.53,3.56,2.16,1.91,1.06,-1.38,-1.78,0.69,2.44,1.91,1.06,2.84,4.62,4.44,3.78,5.62,8.28,9.06,7.84,7.97,9.44,9.91,7.75,6.38,7.12,7.5,5.06,2.16,1.94,2.16,0.59,-0.91,1.16,5.03,7.66,8.69,10.41,13.62,15.22,14.34,13.41,14.47,14.91,12.38,9.12,8.06,7.31,5.09,2.19,2.06,4.16,5.38,4.81,4.75,6.78,8.5,8.09,7.47,9.09,10.34,8.84,6.19,5.78,6.78,6.41,5.03,5.75,8.66,10.78,10.56,11.16,13.72,15.66,14.84,13.88,15.66,17.25,16.75,14.91,14.59,15.66,14.59,12.12,10.84,11.22,11.06,8.28,6.38,6.78,7.56,5.88,4.28,5.25,6.84,6.56,5.59,7.03,9.84,11.62,12.0,13.88,17.34,20.03,19.84,19.72,21.0,21.91,20.0,17.31,16.72,17.12,15.91,13.69,12.91,13.66,13.22,10.53,8.84,9.72,10.47,9.25,8.94,10.97,13.22,13.38,11.91,11.78,13.06,12.47,10.44,10.25,12.28,13.78,13.47,13.97,16.88,19.19,18.56,17.28,17.66,18.62,16.94,14.09,12.25,11.41,9.19,5.47,3.19,4.31,5.66,5.25,5.75,9.31,13.06,14.22,14.19,15.44,17.12,16.19,13.53,12.69,13.62,13.69,11.69,10.94,12.41,13.44,12.03,11.03,12.22,14.25,13.91,12.5,12.56,13.81,12.94,10.72,9.59,10.59,10.88,9.47,8.66,10.75,12.91,12.78,12.19,13.22,14.44,13.41,11.0,10.44,11.81,11.84,10.88,11.56,14.75,16.91,16.31,15.41,16.12,16.19,13.62,11.22,11.06,12.22,11.78,10.12,9.62,10.94,11.0,9.19,8.91,11.41,13.56,13.28,13.25,14.53,16.03,15.19,12.97,12.59,13.5,12.84,10.66,10.28,12.0,12.69,11.66,10.78,12.59,14.19,13.34,12.12,13.03,14.47,13.88,12.34,12.06,12.75,11.62,8.78,6.66,7.41,7.78,6.34,5.03,6.47,7.5,6.69,6.0,7.44,10.0,10.53,9.09,8.66,9.31,9.09,6.97,5.81,7.47,8.72,7.72,6.72,7.84,9.56,9.16,8.19,9.22,11.75,12.62,12.0,12.41,14.81,16.06,15.16,14.38,16.28,17.88,17.16,15.72,16.72,18.12,17.84,16.31,16.81,18.75,18.81,17.25,16.31,17.41,17.5,15.44,12.72,12.47,12.53,10.59,8.78,9.84,12.41,14.16,14.88,16.81,20.25,21.41,19.94,18.53,19.5,20.53,19.88,19.41,21.59,24.09,24.25,23.44,23.5,24.31,22.62,18.53,15.47,14.41,12.94,9.56,6.84,6.91,6.84,4.62,1.59,1.44,2.31,2.31,1.75,4.12,8.72,12.0,13.31,15.22,18.19,20.0,18.84,17.38,18.31,19.5,19.25,18.75,19.97,21.75,21.22,18.38,16.59,16.47,15.12,11.88,9.28,8.75,8.31,5.97,3.81,4.41,6.0,5.38,4.25,5.03,3.78,2.38,2.19,1.66,0.09,-1.81,-1.41,-0.16,0.28,0.25,1.91,5.03,6.91,7.06,7.0,7.5,7.34,5.72,4.53,5.44,6.5,5.94,4.31,3.53,2.78,1.03,-1.06,-1.78,-0.19,0.88,1.62,3.0,5.97,8.91,9.81,10.22,11.25,12.0,11.56,10.19,10.06,10.41:positivity
10.22,11.44,12.94,11.88,9.47,9.0,10.16,9.78,7.94,7.81,9.25,9.91,8.31,7.12,8.5,9.53,8.47,6.66,6.72,7.31,5.81,3.59,3.66,5.72,7.19,7.0,8.0,10.75,12.5,11.53,10.25,11.19,11.91,10.03,7.81,7.62,8.5,7.16,4.47,3.16,3.34,2.5,-0.12,-0.44,1.94,4.5,4.75,5.38,7.62,9.69,8.78,6.94,6.62,7.72,7.22,5.44,5.34,6.81,6.91,4.59,3.16,3.75,4.53,3.44,2.72,4.88,7.81,8.66,8.97,10.84,13.62,14.19,12.81,12.34,13.16,12.88,10.5,9.22,10.5,11.69,10.94,9.59,10.44,12.03,10.69,8.41,8.53,9.53,9.75,9.22,10.44,14.19,17.03,17.5,17.69,19.16,19.91,17.38,14.72,14.31,15.31,15.09,14.16,15.16,17.03,16.84,13.97,11.5,11.09,10.41,7.41,5.06,5.31,5.88,4.0,1.91,2.06,3.53,3.03,1.38,1.72,4.34,6.19,5.72,6.28,8.5,9.81,7.81,6.22,7.19,9.06,8.72,8.44,10.19,12.78,12.91,11.34,10.59,11.28,10.69,7.5,5.12,5.19,4.88,2.78,0.91,1.38,2.66,1.16,-0.88,-0.66,1.25,2.25,2.12,3.19,5.59,6.22,3.84,1.5,1.72,1.72,-0.53,-2.31,-1.31,0.16,-1.06,-3.38,-3.84,-2.72,-3.03,-4.56,-4.34,-1.69,0.09,-0.34,-0.78,0.62,1.47,-0.72,-3.59,-4.0,-3.25,-4.34,-6.16,-5.34,-1.91,0.56,1.59,2.94,6.31,8.09,6.72,5.19,5.75,6.44,4.84,2.69,3.16,5.09,4.62,2.78,2.0,2.97,2.78,0.5,-0.34,1.09,2.12,0.62,-0.47,1.09,3.56,4.0,3.5,5.09,7.81,8.03,6.38,5.66,6.31,5.41,2.66,0.22,0.69,0.78,-1.53,-3.84,-3.28,-2.09,-2.47,-3.25,-1.81,0.81,1.5,0.56,0.78,3.53,5.25,5.12,5.53,7.84,9.62,8.03,5.28,4.19,3.81,1.41,-1.5,-1.97,0.22,1.78,2.5,4.38,8.69,11.59,11.12,10.78,12.16,13.38,11.66,9.03,8.41,8.31,5.94,2.56,1.31,1.94,1.91,0.81,1.09,4.34,7.06,7.38,7.25,9.59,11.53,10.5,8.84,8.72,9.66,8.25,5.06,3.16,3.06,1.66,-1.38,-3.59,-2.31,-1.81,-3.22,-4.69,-3.41,-1.62,-2.06,-2.91,-2.03,0.47,0.81,-1.31,-2.38,-2.12,-3.28,-6.81,-9.34,-8.91,-8.25,-9.59,-10.5,-8.56,-6.19,-6.44,-7.88,-7.78,-6.69,-7.44,-10.03,-11.47,-10.12,-9.53,-10.34,-10.16,-6.97,-4.31,-4.0,-4.81,-3.53,-1.81,-2.5,-5.03,-5.62,-5.03,-5.91,-8.59,-9.69,-8.28,-7.09,-7.75,-8.25,-6.06,-3.62,-3.78,-4.34,-2.5,0.56,1.0,-0.25,-0.97,-0.88,-3.28,-7.91,-11.53,-12.03,-12.62,-14.81,-15.94,-14.12,-11.78,-11.12,-11.0,-8.06,-3.84,-1.81,-1.88,-0.72,1.91,3.09,2.31,2.53,5.0,7.06,6.72,4.84,5.28,5.47,2.5,-1.62,-3.47,-3.44,-4.28,-5.22,-4.41,-1.06,0.62,-0.12,-0.97,0.09,1.19,0.28,-0.16,1.91,4.62,5.5,4.5,5.03,6.72,6.03,3.03,1.16,0.47,-1.16,-5.12,-8.16,-7.81,-6.72,-7.16,-7.56,-5.31,-2.5,-2.0,-3.62,-3.53,-2.03,-1.78,-3.16,-2.53,0.59,3.34,3.38,3.62,5.94,8.31,7.84,6.16,6.78,7.94,6.94,4.03,2.38,1.44,-1.72,-7.0,-11.03,-11.41,-10.88,-10.84,-9.88,-6.28,-2.56,-1.59,-2.25,-1.31,0.09,0.03,-1.59,-0.84,1.84,4.03,3.75,3.53,5.59,7.38,6.44,6.41,8.97,12.09,12.66,11.19,11.41,12.06,11.06,8.16,7.41,8.97,9.19,7.28,5.78,6.38,7.25,6.22,4.88,6.5,9.12,9.97,9.28,10.53,12.84,13.12,11.47,10.78,12.19,12.91,11.62,10.41,12.03,13.38,12.41,10.78,11.16,12.38,11.53,9.31,9.28,11.44,12.34,11.34,11.81,14.06,15.56,14.06,12.56,13.34,14.47,13.41,11.5,12.16,13.78,13.56,11.84,11.97,13.59,14.12,11.91,10.38,10.78,11.06,8.88,7.19,7.91,8.59,6.97,4.03,3.56,4.53,4.62,3.38,3.59,5.62,6.69,5.28,5.19,7.78,10.06,9.78,8.78,9.56,10.34,8.44,4.84,2.91,2.75,1.31,-0.97,-1.53,-0.06,1.16,-0.31,-1.53,-0.56,0.19,-1.09,-3.38,-2.69,-0.97,-0.53,-0.78,0.75,3.66,4.91,3.22,2.56,3.19,3.34,0.34,-1.91,-1.91,-1.12,-2.47,-3.94,-2.81,-0.62,0.09,-0.34,1.09,4.0,5.78,5.59,5.94,8.25,9.75,8.16,6.44,6.62,7.53,7.06,6.38,8.03,10.69,11.19,9.5,8.28,8.72,7.5,4.44,2.12,2.41,2.91,1.12,-0.47,0.69,2.22,1.38,0.44,1.03,3.25,3.91,2.62,2.41,3.81,4.31,2.34,0.56,1.44,2.28,1.22,0.0,0.91,2.38,1.97,0.28,0.81,2.56,3.09,2.16,1.91,3.12,3.41,1.22,-0.81,-0.66,-0.19,-2.03,-3.97,-4.16,-3.19,-3.44,-4.44,-3.31,0.03,2.31,2.91,3.81,6.59,8.62,7.94,6.66,7.41,8.12,6.03,3.41,2.56,3.47,2.88,1.44,1.75,4.03,5.5,4.66,4.25,5.94,7.47,6.44,5.56,7.0,9.47,9.69,9.19,10.16,11.97,12.12,10.19,9.09,9.59,9.03,6.72,5.97,8.22,11.28,12.31,13.31,15.78,18.56,18.44,16.94,16.41,16.66,15.47,12.91,11.0,11.75,11.72,9.41,7.22,7.09,7.38,5.03,1.88,0.28,-0.38,-2.59,-5.25,-5.66,-3.38,-1.44,-0.66,1.34,5.47,9.25,9.94,9.97,10.97,11.22,8.41,4.5,2.81,3.03,2.62,1.34,1.84,4.41,4.94,3.0,0.78,0.84,0.66,-1.38,-3.19,-2.25,-0.28,-0.16,-1.22,-0.38,1.12,0.47,-1.81,-2.81,-1.09,0.5,0.38,0.78,3.38,6.25,6.09,5.69,7.25,9.31,8.81,6.88,6.25,6.88,5.75,3.19,1.91,3.31,4.72,4.38,4.62,6.81,8.84,8.22,6.47,6.44,7.34,6.06,3.16,1.69,1.5,0.34,-2.84,-4.5,-3.44,-2.62,-3.78,-5.31,-4.81,-4.22,-4.94,-5.59,-3.38,0.94,3.91,5.41,7.03,9.59,10.12,7.12,4.06,3.06,1.66,-2.16,-6.03,-7.56,-8.25,-10.25,-12.09,-11.72,-8.94,-7.25,-6.59,-4.66,0.19,4.44,6.91,9.62,13.94,17.06,16.72,14.5,12.56,10.56,5.78,-0.44,-4.81,-6.66,-8.06,-9.5,-8.34,-3.78,0.66,2.12,2.81,4.69,5.47,3.53,0.69,-0.03,0.03,-1.41,-4.09,-5.06,-4.25,-4.66,-6.94,-9.25,-10.38,-12.75,-17.91,-23.16,-24.97,-25.0,-25.25,-25.19,-21.72,-16.47,-12.72,-10.16,-6.84,-2.09,0.88,1.0,0.44,1.03,0.78,-2.56,-6.59,-8.41,-9.16,-11.28,-14.03,-14.41,-12.84,-12.47,-12.91,-11.47,-7.5,-4.0,-2.09,0.12,3.75,6.72,6.28,4.88,4.56,4.97,3.69,0.56,-0.56,-0.66,-1.25,-3.66,-4.44,-1.88,0.38,0.97,1.72,4.75,7.53,8.16,8.0,9.78,12.16,12.34,10.78,9.88,10.34,10.31,8.69,8.53,10.75,12.06,10.12,6.75,4.31,2.44,-1.47,-5.66,-6.59,-5.38,-4.75,-5.5,-4.5,-1.97,-0.62,-1.81,-2.69,-1.47,-0.34,-1.53,-2.75,-1.34,1.12,1.59,1.22,2.91,5.69,7.41,6.97,7.59,9.47,9.94,7.88,6.0,6.31,7.41,6.84,5.81,7.25,9.41,10.09,9.53,10.22,12.03,12.16,9.94,8.06,8.28,7.97,6.03,4.81,6.22,8.34,8.84,7.75,8.56,9.53,8.03,4.78,2.88,2.75,2.72,1.19,0.91,2.56,4.44,3.25,2.22,3.53,5.09,4.53,2.91,2.91,3.94,3.91,2.69,3.34,6.25,8.44,8.16,8.34,9.81,11.09,9.81,7.47,7.34,7.69,6.09,3.69,3.66,5.22,5.66,4.47,4.06,5.28,5.72,4.06,2.56,3.59,4.94,3.94,2.72,3.94,6.25,6.88,5.91,6.31,7.62,7.16,4.75,3.5,4.84,6.59,6.56,6.84,9.06,11.81,11.5,9.62,9.28,9.69,8.09,5.09,3.78,5.0,5.69,4.66,5.0,8.03,11.09,11.72,11.75,13.88,16.06,15.69,14.25,14.69,16.34,16.28,13.91,12.81,13.03,11.78,8.41,5.25,4.5,3.91,1.38,-0.72,0.12,2.44,3.5,4.31,6.56,10.19,12.06,11.53,11.31,12.66,13.0,10.53,7.69,6.75,6.16,3.25,0.72,0.91,3.0,4.12,4.75,7.59,12.12,16.22,17.12,18.28,20.47,21.38,19.09,16.41,15.94,16.16,14.25,12.09,12.41,14.25,14.06,12.38,12.19,14.06,15.34,15.06,15.5,17.94,19.66,18.47,16.62,17.25,18.44,17.69,15.53,14.53,15.5,14.66,12.59,12.12,13.81,13.94,11.31,9.0,9.0,9.22,7.31,5.25,5.16,6.12,5.0,3.53,4.53,8.12,10.62,11.31,12.16,14.34,14.84,12.06,9.78,10.12,11.84,12.38,13.0,15.81,19.56,20.72,19.38,18.88,19.5,18.44,15.69,14.06,14.81,15.72,14.16,12.5,13.09,14.09,12.88,11.09,11.78,13.78,14.03,12.81,13.03,15.59,17.28,17.41:9.78,7.94,7.81,9.25,9.91,8.31,7.12,8.5,9.53,8.47,6.66,6.72,7.31,5.81,3.59,3.66,5.72,7.19,7.0,8.0,10.75,12.5,11.53,10.25,11.19,11.91,10.03,7.81,7.62,8.5,7.16,4.47,3.16,3.34,2.5,-0.12,-0.44,1.94,4.5,4.75,5.38,7.62,9.69,8.78,6.94,6.62,7.72,7.22,5.44,5.34,6.81,6.91,4.59,3.16,3.75,4.53,3.44,2.72,4.88,7.81,8.66,8.97,10.84,13.62,14.19,12.81,12.34,13.16,12.88,10.5,9.22,10.5,11.69,10.94,9.59,10.44,12.03,10.69,8.41,8.53,9.53,9.75,9.22,10.44,14.19,17.03,17.5,17.69,19.16,19.91,17.38,14.72,14.31,15.31,15.09,14.16,15.16,17.03,16.84,13.97,11.5,11.09,10.41,7.41,5.06,5.31,5.88,4.0,1.91,2.06,3.53,3.03,1.38,1.72,4.34,6.19,5.72,6.28,8.5,9.81,7.81,6.22,7.19,9.06,8.72,8.44,10.19,12.78,12.91,11.34,10.59,11.28,10.69,7.5,5.12,5.19,4.88,2.78,0.91,1.38,2.66,1.16,-0.88,-0.66,1.25,2.25,2.12,3.19,5.59,6.22,3.84,1.5,1.72,1.72,-0.53,-2.31,-1.31,0.16,-1.06,-3.38,-3.84,-2.72,-3.03,-4.56,-4.34,-1.69,0.09,-0.34,-0.78,0.62,1.47,-0.72,-3.59,-4.0,-3.25,-4.34,-6.16,-5.34,-1.91,0.56,1.59,2.94,6.31,8.09,6.72,5.19,5.75,6.44,4.84,2.69,3.16,5.09,4.62,2.78,2.0,2.97,2.78,0.5,-0.34,1.09,2.12,0.62,-0.47,1.09,3.56,4.0,3.5,5.09,7.81,8.03,6.38,5.66,6.31,5.41,2.66,0.22,0.69,0.78,-1.53,-3.84,-3.28,-2.09,-2.47,-3.25,-1.81,0.81,1.5,0.56,0.78,3.53,5.25,5.12,5.53,7.84,9.62,8.03,5.28,4.19,3.81,1.41,-1.5,-1.97,0.22,1.78,2.5,4.38,8.69,11.59,11.12,10.78,12.16,13.38,11.66,9.03,8.41,8.31,5.94,2.56,1.31,1.94,1.91,0.81,1.09,4.34,7.06,7.38,7.25,9.59,11.53,10.5,8.84,8.72,9.66,8.25,5.06,3.16,3.06,1.66,-1.38,-3.59,-2.31,-1.81,-3.22,-4.69,-3.41,-1.62,-2.06,-2.91,-2.03,0.47,0.81,-1.31,-2.38,-2.12,-3.28,-6.81,-9.34,-8.91,-8.25,-9.59,-10.5,-8.56,-6.19,-6.44,-7.88,-7.78,-6.69,-7.44,-10.03,-11.47,-10.12,-9.53,-10.34,-10.16,-6.97,-4.31,-4.0,-4.81,-3.53,-1.81,-2.5,-5.03,-5.62,-5.03,-5.91,-8.59,-9.69,-8.28,-7.09,-7.75,-8.25,-6.06,-3.62,-3.78,-4.34,-2.5,0.56,1.0,-0.25,-0.97,-0.88,-3.28,-7.91,-11.53,-12.03,-12.62,-14.81,-15.94,-14.12,-11.78,-11.12,-11.0,-8.06,-3.84,-1.81,-1.88,-0.72,1.91,3.09,2.31,2.53,5.0,7.06,6.72,4.84,5.28,5.47,2.5,-1.62,-3.47,-3.44,-4.28,-5.22,-4.41,-1.06,0.62,-0.12,-0.97,0.09,1.19,0.28,-0.16,1.91,4.62,5.5,4.5,5.03,6.72,6.03,3.03,1.16,0.47,-1.16,-5.12,-8.16,-7.81,-6.72,-7.16,-7.56,-5.31,-2.5,-2.0,-3.62,-3.53,-2.03,-1.78,-3.16,-2.53,0.59,3.34,3.38,3.62,5.94,8.31,7.84,6.16,6.78,7.94,6.94,4.03,2.38,1.44,-1.72,-7.0,-11.03,-11.41,-10.88,-10.84,-9.88,-6.28,-2.56,-1.59,-2.25,-1.31,0.09,0.03,-1.59,-0.84,1.84,4.03,3.75,3.53,5.59,7.38,6.44,6.41,8.97,12.09,12.66,11.19,11.41,12.06,11.06,8.16,7.41,8.97,9.19,7.28,5.78,6.38,7.25,6.22,4.88,6.5,9.12,9.97,9.28,10.53,12.84,13.12,11.47,10.78,12.19,12.91,11.62,10.41,12.03,13.38,12.41,10.78,11.16,12.38,11.53,9.31,9.28,11.44,12.34,11.34,11.81,14.06,15.56,14.06,12.56,13.34,14.47,13.41,11.5,12.16,13.78,13.56,11.84,11.97,13.59,14.12,11.91,10.38,10.78,11.06,8.88,7.19,7.91,8.59,6.97,4.03,3.56,4.53,4.62,3.38,3.59,5.62,6.69,5.28,5.19,7.78,10.06,9.78,8.78,9.56,10.34,8.44,4.84,2.91,2.75,1.31,-0.97,-1.53,-0.06,1.16,-0.31,-1.53,-0.56,0.19,-1.09,-3.38,-2.69,-0.97,-0.53,-0.78,0.75,3.66,4.91,3.22,2.56,3.19,3.34,0.34,-1.91,-1.91,-1.12,-2.47,-3.94,-2.81,-0.62,0.09,-0.34,1.09,4.0,5.78,5.59,5.94,8.25,9.75,8.16,6.44,6.62,7.53,7.06,6.38,8.03,10.69,11.19,9.5,8.28,8.72,7.5,4.44,2.12,2.41,2.91,1.12,-0.47,0.69,2.22,1.38,0.44,1.03,3.25,3.91,2.62,2.41,3.81,4.31,2.34,0.56,1.44,2.28,1.22,0.0,0.91,2.38,1.97,0.28,0.81,2.56,3.09,2.16,1.91,3.12,3.41,1.22,-0.81,-0.66,-0.19,-2.03,-3.97,-4.16,-3.19,-3.44,-4.44,-3.31,0.03,2.31,2.91,3.81,6.59,8.62,7.94,6.66,7.41,8.12,6.03,3.41,2.56,3.47,2.88,1.44,1.75,4.03,5.5,4.66,4.25,5.94,7.47,6.44,5.56,7.0,9.47,9.69,9.19,10.16,11.97,12.12,10.19,9.09,9.59,9.03,6.72,5.97,8.22,11.28,12.31,13.31,15.78,18.56,18.44,16.94,16.41,16.66,15.47,12.91,11.0,11.75,11.72,9.41,7.22,7.09,7.38,5.03,1.88,0.28,-0.38,-2.59,-5.25,-5.66,-3.38,-1.44,-0.66,1.34,5.47,9.25,9.94,9.97,10.97,11.22,8.41,4.5,2.81,3.03,2.62,1.34,1.84,4.41,4.94,3.0,0.78,0.84,0.66,-1.38,-3.19,-2.25,-0.28,-0.16,-1.22,-0.38,1.12,0.47,-1.81,-2.81,-1.09,0.5,0.38,0.78,3.38,6.25,6.09,5.69,7.25,9.31,8.81,6.88,6.25,6.88,5.75,3.19,1.91,3.31,4.72,4.38,4.62,6.81,8.84,8.22,6.47,6.44,7.34,6.06,3.16,1.69,1.5,0.34,-2.84,-4.5,-3.44,-2.62,-3.78,-5.31,-4.81,-4.22,-4.94,-5.59,-3.38,0.94,3.91,5.41,7.03,9.59,10.12,7.12,4.06,3.06,1.66,-2.16,-6.03,-7.56,-8.25,-10.25,-12.09,-11.72,-8.94,-7.25,-6.59,-4.66,0.19,4.44,6.91,9.62,13.94,17.06,16.72,14.5,12.56,10.56,5.78,-0.44,-4.81,-6.66,-8.06,-9.5,-8.34,-3.78,0.66,2.12,2.81,4.69,5.47,3.53,0.69,-0.03,0.03,-1.41,-4.09,-5.06,-4.25,-4.66,-6.94,-9.25,-10.38,-12.75,-17.91,-23.16,-24.97,-25.0,-25.25,-25.19,-21.72,-16.47,-12.72,-10.16,-6.84,-2.09,0.88,1.0,0.44,1.03,0.78,-2.56,-6.59,-8.41,-9.16,-11.28,-14.03,-14.41,-12.84,-12.47,-12.91,-11.47,-7.5,-4.0,-2.09,0.12,3.75,6.72,6.28,4.88,4.56,4.97,3.69,0.56,-0.56,-0.66,-1.25,-3.66,-4.44,-1.88,0.38,0.97,1.72,4.75,7.53,8.16,8.0,9.78,12.16,12.34,10.78,9.88,10.34,10.31,8.69,8.53,10.75,12.06,10.12,6.75,4.31,2.44,-1.47,-5.66,-6.59,-5.38,-4.75,-5.5,-4.5,-1.97,-0.62,-1.81,-2.69,-1.47,-0.34,-1.53,-2.75,-1.34,1.12,1.59,1.22,2.91,5.69,7.41,6.97,7.59,9.47,9.94,7.88,6.0,6.31,7.41,6.84,5.81,7.25,9.41,10.09,9.53,10.22,12.03,12.16,9.94,8.06,8.28,7.97,6.03,4.81,6.22,8.34,8.84,7.75,8.56,9.53,8.03,4.78,2.88,2.75,2.72,1.19,0.91,2.56,4.44,3.25,2.22,3.53,5.09,4.53,2.91,2.91,3.94,3.91,2.69,3.34,6.25,8.44,8.16,8.34,9.81,11.09,9.81,7.47,7.34,7.69,6.09,3.69,3.66,5.22,5.66,4.47,4.06,5.28,5.72,4.06,2.56,3.59,4.94,3.94,2.72,3.94,6.25,6.88,5.91,6.31,7.62,7.16,4.75,3.5,4.84,6.59,6.56,6.84,9.06,11.81,11.5,9.62,9.28,9.69,8.09,5.09,3.78,5.0,5.69,4.66,5.0,8.03,11.09,11.72,11.75,13.88,16.06,15.69,14.25,14.69,16.34,16.28,13.91,12.81,13.03,11.78,8.41,5.25,4.5,3.91,1.38,-0.72,0.12,2.44,3.5,4.31,6.56,10.19,12.06,11.53,11.31,12.66,13.0,10.53,7.69,6.75,6.16,3.25,0.72,0.91,3.0,4.12,4.75,7.59,12.12,16.22,17.12,18.28,20.47,21.38,19.09,16.41,15.94,16.16,14.25,12.09,12.41,14.25,14.06,12.38,12.19,14.06,15.34,15.06,15.5,17.94,19.66,18.47,16.62,17.25,18.44,17.69,15.53,14.53,15.5,14.66,12.59,12.12,13.81,13.94,11.31,9.0,9.0,9.22,7.31,5.25,5.16,6.12,5.0,3.53,4.53,8.12,10.62,11.31,12.16,14.34,14.84,12.06,9.78,10.12,11.84,12.38,13.0,15.81,19.56,20.72,19.38,18.88,19.5,18.44,15.69,14.06,14.81,15.72,14.16,12.5,13.09,14.09,12.88,11.09,11.78,13.78,14.03,12.81,13.03,15.59,17.28,17.41,39.91,39.0,37.38,34.25,30.53,29.59,30.03:8.5,9.53,8.47,6.66,6.72,7.31,5.81,3.59,3.66,5.72,7.19,7.0,8.0,10.75,12.5,11.53,10.25,11.19,11.91,10.03,7.81,7.62,8.5,7.16,4.47,3.16,3.34,2.5,-0.12,-0.44,1.94,4.5,4.75,5.38,7.62,9.69,8.78,6.94,6.62,7.72,7.22,5.44,5.34,6.81,6.91,4.59,3.16,3.75,4.53,3.44,2.72,4.88,7.81,8.66,8.97,10.84,13.62,14.19,12.81,12.34,13.16,12.88,10.5,9.22,10.5,11.69,10.94,9.59,10.44,12.03,10.69,8.41,8.53,9.53,9.75,9.22,10.44,14.19,17.03,17.5,17.69,19.16,19.91,17.38,14.72,14.31,15.31,15.09,14.16,15.16,17.03,16.84,13.97,11.5,11.09,10.41,7.41,5.06,5.31,5.88,4.0,1.91,2.06,3.53,3.03,1.38,1.72,4.34,6.19,5.72,6.28,8.5,9.81,7.81,6.22,7.19,9.06,8.72,8.44,10.19,12.78,12.91,11.34,10.59,11.28,10.69,7.5,5.12,5.19,4.88,2.78,0.91,1.38,2.66,1.16,-0.88,-0.66,1.25,2.25,2.12,3.19,5.59,6.22,3.84,1.5,1.72,1.72,-0.53,-2.31,-1.31,0.16,-1.06,-3.38,-3.84,-2.72,-3.03,-4.56,-4.34,-1.69,0.09,-0.34,-0.78,0.62,1.47,-0.72,-3.59,-4.0,-3.25,-4.34,-6.16,-5.34,-1.91,0.56,1.59,2.94,6.31,8.09,6.72,5.19,5.75,6.44,4.84,2.69,3.16,5.09,4.62,2.78,2.0,2.97,2.78,0.5,-0.34,1.09,2.12,0.62,-0.47,1.09,3.56,4.0,3.5,5.09,7.81,8.03,6.38,5.66,6.31,5.41,2.66,0.22,0.69,0.78,-1.53,-3.84,-3.28,-2.09,-2.47,-3.25,-1.81,0.81,1.5,0.56,0.78,3.53,5.25,5.12,5.53,7.84,9.62,8.03,5.28,4.19,3.81,1.41,-1.5,-1.97,0.22,1.78,2.5,4.38,8.69,11.59,11.12,10.78,12.16,13.38,11.66,9.03,8.41,8.31,5.94,2.56,1.31,1.94,1.91,0.81,1.09,4.34,7.06,7.38,7.25,9.59,11.53,10.5,8.84,8.72,9.66,8.25,5.06,3.16,3.06,1.66,-1.38,-3.59,-2.31,-1.81,-3.22,-4.69,-3.41,-1.62,-2.06,-2.91,-2.03,0.47,0.81,-1.31,-2.38,-2.12,-3.28,-6.81,-9.34,-8.91,-8.25,-9.59,-10.5,-8.56,-6.19,-6.44,-7.88,-7.78,-6.69,-7.44,-10.03,-11.47,-10.12,-9.53,-10.34,-10.16,-6.97,-4.31,-4.0,-4.81,-3.53,-1.81,-2.5,-5.03,-5.62,-5.03,-5.91,-8.59,-9.69,-8.28,-7.09,-7.75,-8.25,-6.06,-3.62,-3.78,-4.34,-2.5,0.56,1.0,-0.25,-0.97,-0.88,-3.28,-7.91,-11.53,-12.03,-12.62,-14.81,-15.94,-14.12,-11.78,-11.12,-11.0,-8.06,-3.84,-1.81,-1.88,-0.72,1.91,3.09,2.31,2.53,5.0,7.06,6.72,4.84,5.28,5.47,2.5,-1.62,-3.47,-3.44,-4.28,-5.22,-4.41,-1.06,0.62,-0.12,-0.97,0.09,1.19,0.28,-0.16,1.91,4.62,5.5,4.5,5.03,6.72,6.03,3.03,1.16,0.47,-1.16,-5.12,-8.16,-7.81,-6.72,-7.16,-7.56,-5.31,-2.5,-2.0,-3.62,-3.53,-2.03,-1.78,-3.16,-2.53,0.59,3.34,3.38,3.62,5.94,8.31,7.84,6.16,6.78,7.94,6.94,4.03,2.38,1.44,-1.72,-7.0,-11.03,-11.41,-10.88,-10.84,-9.88,-6.28,-2.56,-1.59,-2.25,-1.31,0.09,0.03,-1.59,-0.84,1.84,4.03,3.75,3.53,5.59,7.38,6.44,6.41,8.97,12.09,12.66,11.19,11.41,12.06,11.06,8.16,7.41,8.97,9.19,7.28,5.78,6.38,7.25,6.22,4.88,6.5,9.12,9.97,9.28,10.53,12.84,13.12,11.47,10.78,12.19,12.91,11.62,10.41,12.03,13.38,12.41,10.78,11.16,12.38,11.53,9.31,9.28,11.44,12.34,11.34,11.81,14.06,15.56,14.06,12.56,13.34,14.47,13.41,11.5,12.16,13.78,13.56,11.84,11.97,13.59,14.12,11.91,10.38,10.78,11.06,8.88,7.19,7.91,8.59,6.97,4.03,3.56,4.53,4.62,3.38,3.59,5.62,6.69,5.28,5.19,7.78,10.06,9.78,8.78,9.56,10.34,8.44,4.84,2.91,2.75,1.31,-0.97,-1.53,-0.06,1.16,-0.31,-1.53,-0.56,0.19,-1.09,-3.38,-2.69,-0.97,-0.53,-0.78,0.75,3.66,4.91,3.22,2.56,3.19,3.34,0.34,-1.91,-1.91,-1.12,-2.47,-3.94,-2.81,-0.62,0.09,-0.34,1.09,4.0,5.78,5.59,5.94,8.25,9.75,8.16,6.44,6.62,7.53,7.06,6.38,8.03,10.69,11.19,9.5,8.28,8.72,7.5,4.44,2.12,2.41,2.91,1.12,-0.47,0.69,2.22,1.38,0.44,1.03,3.25,3.91,2.62,2.41,3.81,4.31,2.34,0.56,1.44,2.28,1.22,0.0,0.91,2.38,1.97,0.28,0.81,2.56,3.09,2.16,1.91,3.12,3.41,1.22,-0.81,-0.66,-0.19,-2.03,-3.97,-4.16,-3.19,-3.44,-4.44,-3.31,0.03,2.31,2.91,3.81,6.59,8.62,7.94,6.66,7.41,8.12,6.03,3.41,2.56,3.47,2.88,1.44,1.75,4.03,5.5,4.66,4.25,5.94,7.47,6.44,5.56,7.0,9.47,9.69,9.19,10.16,11.97,12.12,10.19,9.09,9.59,9.03,6.72,5.97,8.22,11.28,12.31,13.31,15.78,18.56,18.44,16.94,16.41,16.66,15.47,12.91,11.0,11.75,11.72,9.41,7.22,7.09,7.38,5.03,1.88,0.28,-0.38,-2.59,-5.25,-5.66,-3.38,-1.44,-0.66,1.34,5.47,9.25,9.94,9.97,10.97,11.22,8.41,4.5,2.81,3.03,2.62,1.34,1.84,4.41,4.94,3.0,0.78,0.84,0.66,-1.38,-3.19,-2.25,-0.28,-0.16,-1.22,-0.38,1.12,0.47,-1.81,-2.81,-1.09,0.5,0.38,0.78,3.38,6.25,6.09,5.69,7.25,9.31,8.81,6.88,6.25,6.88,5.75,3.19,1.91,3.31,4.72,4.38,4.62,6.81,8.84,8.22,6.47,6.44,7.34,6.06,3.16,1.69,1.5,0.34,-2.84,-4.5,-3.44,-2.62,-3.78,-5.31,-4.81,-4.22,-4.94,-5.59,-3.38,0.94,3.91,5.41,7.03,9.59,10.12,7.12,4.06,3.06,1.66,-2.16,-6.03,-7.56,-8.25,-10.25,-12.09,-11.72,-8.94,-7.25,-6.59,-4.66,0.19,4.44,6.91,9.62,13.94,17.06,16.72,14.5,12.56,10.56,5.78,-0.44,-4.81,-6.66,-8.06,-9.5,-8.34,-3.78,0.66,2.12,2.81,4.69,5.47,3.53,0.69,-0.03,0.03,-1.41,-4.09,-5.06,-4.25,-4.66,-6.94,-9.25,-10.38,-12.75,-17.91,-23.16,-24.97,-25.0,-25.25,-25.19,-21.72,-16.47,-12.72,-10.16,-6.84,-2.09,0.88,1.0,0.44,1.03,0.78,-2.56,-6.59,-8.41,-9.16,-11.28,-14.03,-14.41,-12.84,-12.47,-12.91,-11.47,-7.5,-4.0,-2.09,0.12,3.75,6.72,6.28,4.88,4.56,4.97,3.69,0.56,-0.56,-0.66,-1.25,-3.66,-4.44,-1.88,0.38,0.97,1.72,4.75,7.53,8.16,8.0,9.78,12.16,12.34,10.78,9.88,10.34,10.31,8.69,8.53,10.75,12.06,10.12,6.75,4.31,2.44,-1.47,-5.66,-6.59,-5.38,-4.75,-5.5,-4.5,-1.97,-0.62,-1.81,-2.69,-1.47,-0.34,-1.53,-2.75,-1.34,1.12,1.59,1.22,2.91,5.69,7.41,6.97,7.59,9.47,9.94,7.88,6.0,6.31,7.41,6.84,5.81,7.25,9.41,10.09,9.53,10.22,12.03,12.16,9.94,8.06,8.28,7.97,6.03,4.81,6.22,8.34,8.84,7.75,8.56,9.53,8.03,4.78,2.88,2.75,2.72,1.19,0.91,2.56,4.44,3.25,2.22,3.53,5.09,4.53,2.91,2.91,3.94,3.91,2.69,3.34,6.25,8.44,8.16,8.34,9.81,11.09,9.81,7.47,7.34,7.69,6.09,3.69,3.66,5.22,5.66,4.47,4.06,5.28,5.72,4.06,2.56,3.59,4.94,3.94,2.72,3.94,6.25,6.88,5.91,6.31,7.62,7.16,4.75,3.5,4.84,6.59,6.56,6.84,9.06,11.81,11.5,9.62,9.28,9.69,8.09,5.09,3.78,5.0,5.69,4.66,5.0,8.03,11.09,11.72,11.75,13.88,16.06,15.69,14.25,14.69,16.34,16.28,13.91,12.81,13.03,11.78,8.41,5.25,4.5,3.91,1.38,-0.72,0.12,2.44,3.5,4.31,6.56,10.19,12.06,11.53,11.31,12.66,13.0,10.53,7.69,6.75,6.16,3.25,0.72,0.91,3.0,4.12,4.75,7.59,12.12,16.22,17.12,18.28,20.47,21.38,19.09,16.41,15.94,16.16,14.25,12.09,12.41,14.25,14.06,12.38,12.19,14.06,15.34,15.06,15.5,17.94,19.66,18.47,16.62,17.25,18.44,17.69,15.53,14.53,15.5,14.66,12.59,12.12,13.81,13.94,11.31,9.0,9.0,9.22,7.31,5.25,5.16,6.12,5.0,3.53,4.53,8.12,10.62,11.31,12.16,14.34,14.84,12.06,9.78,10.12,11.84,12.38,13.0,15.81,19.56,20.72,19.38,18.88,19.5,18.44,15.69,14.06,14.81,15.72,14.16,12.5,13.09,14.09,12.88,11.09,11.78,13.78,14.03,12.81,13.03,15.59,17.28,17.41,39.91,39.0,37.38,34.25,30.53,29.59,30.03,30.38,30.41,32.12,33.41,34.0,32.72,31.56:3.59,3.66,5.72,7.19,7.0,8.0,10.75,12.5,11.53,10.25,11.19,11.91,10.03,7.81,7.62,8.5,7.16,4.47,3.16,3.34,2.5,-0.12,-0.44,1.94,4.5,4.75,5.38,7.62,9.69,8.78,6.94,6.62,7.72,7.22,5.44,5.34,6.81,6.91,4.59,3.16,3.75,4.53,3.44,2.72,4.88,7.81,8.66,8.97,10.84,13.62,14.19,12.81,12.34,13.16,12.88,10.5,9.22,10.5,11.69,10.94,9.59,10.44,12.03,10.69,8.41,8.53,9.53,9.75,9.22,10.44,14.19,17.03,17.5,17.69,19.16,19.91,17.38,14.72,14.31,15.31,15.09,14.16,15.16,17.03,16.84,13.97,11.5,11.09,10.41,7.41,5.06,5.31,5.88,4.0,1.91,2.06,3.53,3.03,1.38,1.72,4.34,6.19,5.72,6.28,8.5,9.81,7.81,6.22,7.19,9.06,8.72,8.44,10.19,12.78,12.91,11.34,10.59,11.28,10.69,7.5,5.12,5.19,4.88,2.78,0.91,1.38,2.66,1.16,-0.88,-0.66,1.25,2.25,2.12,3.19,5.59,6.22,3.84,1.5,1.72,1.72,-0.53,-2.31,-1.31,0.16,-1.06,-3.38,-3.84,-2.72,-3.03,-4.56,-4.34,-1.69,0.09,-0.34,-0.78,0.62,1.47,-0.72,-3.59,-4.0,-3.25,-4.34,-6.16,-5.34,-1.91,0.56,1.59,2.94,6.31,8.09,6.72,5.19,5.75,6.44,4.84,2.69,3.16,5.09,4.62,2.78,2.0,2.97,2.78,0.5,-0.34,1.09,2.12,0.62,-0.47,1.09,3.56,4.0,3.5,5.09,7.81,8.03,6.38,5.66,6.31,5.41,2.66,0.22,0.69,0.78,-1.53,-3.84,-3.28,-2.09,-2.47,-3.25,-1.81,0.81,1.5,0.56,0.78,3.53,5.25,5.12,5.53,7.84,9.62,8.03,5.28,4.19,3.81,1.41,-1.5,-1.97,0.22,1.78,2.5,4.38,8.69,11.59,11.12,10.78,12.16,13.38,11.66,9.03,8.41,8.31,5.94,2.56,1.31,1.94,1.91,0.81,1.09,4.34,7.06,7.38,7.25,9.59,11.53,10.5,8.84,8.72,9.66,8.25,5.06,3.16,3.06,1.66,-1.38,-3.59,-2.31,-1.81,-3.22,-4.69,-3.41,-1.62,-2.06,-2.91,-2.03,0.47,0.81,-1.31,-2.38,-2.12,-3.28,-6.81,-9.34,-8.91,-8.25,-9.59,-10.5,-8.56,-6.19,-6.44,-7.88,-7.78,-6.69,-7.44,-10.03,-11.47,-10.12,-9.53,-10.34,-10.16,-6.97,-4.31,-4.0,-4.81,-3.53,-1.81,-2.5,-5.03,-5.62,-5.03,-5.91,-8.59,-9.69,-8.28,-7.09,-7.75,-8.25,-6.06,-3.62,-3.78,-4.34,-2.5,0.56,1.0,-0.25,-0.97,-0.88,-3.28,-7.91,-11.53,-12.03,-12.62,-14.81,-15.94,-14.12,-11.78,-11.12,-11.0,-8.06,-3.84,-1.81,-1.88,-0.72,1.91,3.09,2.31,2.53,5.0,7.06,6.72,4.84,5.28,5.47,2.5,-1.62,-3.47,-3.44,-4.28,-5.22,-4.41,-1.06,0.62,-0.12,-0.97,0.09,1.19,0.28,-0.16,1.91,4.62,5.5,4.5,5.03,6.72,6.03,3.03,1.16,0.47,-1.16,-5.12,-8.16,-7.81,-6.72,-7.16,-7.56,-5.31,-2.5,-2.0,-3.62,-3.53,-2.03,-1.78,-3.16,-2.53,0.59,3.34,3.38,3.62,5.94,8.31,7.84,6.16,6.78,7.94,6.94,4.03,2.38,1.44,-1.72,-7.0,-11.03,-11.41,-10.88,-10.84,-9.88,-6.28,-2.56,-1.59,-2.25,-1.31,0.09,0.03,-1.59,-0.84,1.84,4.03,3.75,3.53,5.59,7.38,6.44,6.41,8.97,12.09,12.66,11.19,11.41,12.06,11.06,8.16,7.41,8.97,9.19,7.28,5.78,6.38,7.25,6.22,4.88,6.5,9.12,9.97,9.28,10.53,12.84,13.12,11.47,10.78,12.19,12.91,11.62,10.41,12.03,13.38,12.41,10.78,11.16,12.38,11.53,9.31,9.28,11.44,12.34,11.34,11.81,14.06,15.56,14.06,12.56,13.34,14.47,13.41,11.5,12.16,13.78,13.56,11.84,11.97,13.59,14.12,11.91,10.38,10.78,11.06,8.88,7.19,7.91,8.59,6.97,4.03,3.56,4.53,4.62,3.38,3.59,5.62,6.69,5.28,5.19,7.78,10.06,9.78,8.78,9.56,10.34,8.44,4.84,2.91,2.75,1.31,-0.97,-1.53,-0.06,1.16,-0.31,-1.53,-0.56,0.19,-1.09,-3.38,-2.69,-0.97,-0.53,-0.78,0.75,3.66,4.91,3.22,2.56,3.19,3.34,0.34,-1.91,-1.91,-1.12,-2.47,-3.94,-2.81,-0.62,0.09,-0.34,1.09,4.0,5.78,5.59,5.94,8.25,9.75,8.16,6.44,6.62,7.53,7.06,6.38,8.03,10.69,11.19,9.5,8.28,8.72,7.5,4.44,2.12,2.41,2.91,1.12,-0.47,0.69,2.22,1.38,0.44,1.03,3.25,3.91,2.62,2.41,3.81,4.31,2.34,0.56,1.44,2.28,1.22,0.0,0.91,2.38,1.97,0.28,0.81,2.56,3.09,2.16,1.91,3.12,3.41,1.22,-0.81,-0.66,-0.19,-2.03,-3.97,-4.16,-3.19,-3.44,-4.44,-3.31,0.03,2.31,2.91,3.81,6.59,8.62,7.94,6.66,7.41,8.12,6.03,3.41,2.56,3.47,2.88,1.44,1.75,4.03,5.5,4.66,4.25,5.94,7.47,6.44,5.56,7.0,9.47,9.69,9.19,10.16,11.97,12.12,10.19,9.09,9.59,9.03,6.72,5.97,8.22,11.28,12.31,13.31,15.78,18.56,18.44,16.94,16.41,16.66,15.47,12.91,11.0,11.75,11.72,9.41,7.22,7.09,7.38,5.03,1.88,0.28,-0.38,-2.59,-5.25,-5.66,-3.38,-1.44,-0.66,1.34,5.47,9.25,9.94,9.97,10.97,11.22,8.41,4.5,2.81,3.03,2.62,1.34,1.84,4.41,4.94,3.0,0.78,0.84,0.66,-1.38,-3.19,-2.25,-0.28,-0.16,-1.22,-0.38,1.12,0.47,-1.81,-2.81,-1.09,0.5,0.38,0.78,3.38,6.25,6.09,5.69,7.25,9.31,8.81,6.88,6.25,6.88,5.75,3.19,1.91,3.31,4.72,4.38,4.62,6.81,8.84,8.22,6.47,6.44,7.34,6.06,3.16,1.69,1.5,0.34,-2.84,-4.5,-3.44,-2.62,-3.78,-5.31,-4.81,-4.22,-4.94,-5.59,-3.38,0.94,3.91,5.41,7.03,9.59,10.12,7.12,4.06,3.06,1.66,-2.16,-6.03,-7.56,-8.25,-10.25,-12.09,-11.72,-8.94,-7.25,-6.59,-4.66,0.19,4.44,6.91,9.62,13.94,17.06,16.72,14.5,12.56,10.56,5.78,-0.44,-4.81,-6.66,-8.06,-9.5,-8.34,-3.78,0.66,2.12,2.81,4.69,5.47,3.53,0.69,-0.03,0.03,-1.41,-4.09,-5.06,-4.25,-4.66,-6.94,-9.25,-10.38,-12.75,-17.91,-23.16,-24.97,-25.0,-25.25,-25.19,-21.72,-16.47,-12.72,-10.16,-6.84,-2.09,0.88,1.0,0.44,1.03,0.78,-2.56,-6.59,-8.41,-9.16,-11.28,-14.03,-14.41,-12.84,-12.47,-12.91,-11.47,-7.5,-4.0,-2.09,0.12,3.75,6.72,6.28,4.88,4.56,4.97,3.69,0.56,-0.56,-0.66,-1.25,-3.66,-4.44,-1.88,0.38,0.97,1.72,4.75,7.53,8.16,8.0,9.78,12.16,12.34,10.78,9.88,10.34,10.31,8.69,8.53,10.75,12.06,10.12,6.75,4.31,2.44,-1.47,-5.66,-6.59,-5.38,-4.75,-5.5,-4.5,-1.97,-0.62,-1.81,-2.69,-1.47,-0.34,-1.53,-2.75,-1.34,1.12,1.59,1.22,2.91,5.69,7.41,6.97,7.59,9.47,9.94,7.88,6.0,6.31,7.41,6.84,5.81,7.25,9.41,10.09,9.53,10.22,12.03,12.16,9.94,8.06,8.28,7.97,6.03,4.81,6.22,8.34,8.84,7.75,8.56,9.53,8.03,4.78,2.88,2.75,2.72,1.19,0.91,2.56,4.44,3.25,2.22,3.53,5.09,4.53,2.91,2.91,3.94,3.91,2.69,3.34,6.25,8.44,8.16,8.34,9.81,11.09,9.81,7.47,7.34,7.69,6.09,3.69,3.66,5.22,5.66,4.47,4.06,5.28,5.72,4.06,2.56,3.59,4.94,3.94,2.72,3.94,6.25,6.88,5.91,6.31,7.62,7.16,4.75,3.5,4.84,6.59,6.56,6.84,9.06,11.81,11.5,9.62,9.28,9.69,8.09,5.09,3.78,5.0,5.69,4.66,5.0,8.03,11.09,11.72,11.75,13.88,16.06,15.69,14.25,14.69,16.34,16.28,13.91,12.81,13.03,11.78,8.41,5.25,4.5,3.91,1.38,-0.72,0.12,2.44,3.5,4.31,6.56,10.19,12.06,11.53,11.31,12.66,13.0,10.53,7.69,6.75,6.16,3.25,0.72,0.91,3.0,4.12,4.75,7.59,12.12,16.22,17.12,18.28,20.47,21.38,19.09,16.41,15.94,16.16,14.25,12.09,12.41,14.25,14.06,12.38,12.19,14.06,15.34,15.06,15.5,17.94,19.66,18.47,16.62,17.25,18.44,17.69,15.53,14.53,15.5,14.66,12.59,12.12,13.81,13.94,11.31,9.0,9.0,9.22,7.31,5.25,5.16,6.12,5.0,3.53,4.53,8.12,10.62,11.31,12.16,14.34,14.84,12.06,9.78,10.12,11.84,12.38,13.0,15.81,19.56,20.72,19.38,18.88,19.5,18.44,15.69,14.06,14.81,15.72,14.16,12.5,13.09,14.09,12.88,11.09,11.78,13.78,14.03,12.81,13.03,15.59,17.28,17.41,39.91,39.0,37.38,34.25,30.53,29.59,30.03,30.38,30.41,32.12,33.41,34.0,32.72,31.56,32.0,32.25,31.31,30.62,31.22,31.75,31.0:12.5,11.53,10.25,11.19,11.91,10.03,7.81,7.62,8.5,7.16,4.47,3.16,3.34,2.5,-0.12,-0.44,1.94,4.5,4.75,5.38,7.62,9.69,8.78,6.94,6.62,7.72,7.22,5.44,5.34,6.81,6.91,4.59,3.16,3.75,4.53,3.44,2.72,4.88,7.81,8.66,8.97,10.84,13.62,14.19,12.81,12.34,13.16,12.88,10.5,9.22,10.5,11.69,10.94,9.59,10.44,12.03,10.69,8.41,8.53,9.53,9.75,9.22,10.44,14.19,17.03,17.5,17.69,19.16,19.91,17.38,14.72,14.31,15.31,15.09,14.16,15.16,17.03,16.84,13.97,11.5,11.09,10.41,7.41,5.06,5.31,5.88,4.0,1.91,2.06,3.53,3.03,1.38,1.72,4.34,6.19,5.72,6.28,8.5,9.81,7.81,6.22,7.19,9.06,8.72,8.44,10.19,12.78,12.91,11.34,10.59,11.28,10.69,7.5,5.12,5.19,4.88,2.78,0.91,1.38,2.66,1.16,-0.88,-0.66,1.25,2.25,2.12,3.19,5.59,6.22,3.84,1.5,1.72,1.72,-0.53,-2.31,-1.31,0.16,-1.06,-3.38,-3.84,-2.72,-3.03,-4.56,-4.34,-1.69,0.09,-0.34,-0.78,0.62,1.47,-0.72,-3.59,-4.0,-3.25,-4.34,-6.16,-5.34,-1.91,0.56,1.59,2.94,6.31,8.09,6.72,5.19,5.75,6.44,4.84,2.69,3.16,5.09,4.62,2.78,2.0,2.97,2.78,0.5,-0.34,1.09,2.12,0.62,-0.47,1.09,3.56,4.0,3.5,5.09,7.81,8.03,6.38,5.66,6.31,5.41,2.66,0.22,0.69,0.78,-1.53,-3.84,-3.28,-2.09,-2.47,-3.25,-1.81,0.81,1.5,0.56,0.78,3.53,5.25,5.12,5.53,7.84,9.62,8.03,5.28,4.19,3.81,1.41,-1.5,-1.97,0.22,1.78,2.5,4.38,8.69,11.59,11.12,10.78,12.16,13.38,11.66,9.03,8.41,8.31,5.94,2.56,1.31,1.94,1.91,0.81,1.09,4.34,7.06,7.38,7.25,9.59,11.53,10.5,8.84,8.72,9.66,8.25,5.06,3.16,3.06,1.66,-1.38,-3.59,-2.31,-1.81,-3.22,-4.69,-3.41,-1.62,-2.06,-2.91,-2.03,0.47,0.81,-1.31,-2.38,-2.12,-3.28,-6.81,-9.34,-8.91,-8.25,-9.59,-10.5,-8.56,-6.19,-6.44,-7.88,-7.78,-6.69,-7.44,-10.03,-11.47,-10.12,-9.53,-10.34,-10.16,-6.97,-4.31,-4.0,-4.81,-3.53,-1.81,-2.5,-5.03,-5.62,-5.03,-5.91,-8.59,-9.69,-8.28,-7.09,-7.75,-8.25,-6.06,-3.62,-3.78,-4.34,-2.5,0.56,1.0,-0.25,-0.97,-0.88,-3.28,-7.91,-11.53,-12.03,-12.62,-14.81,-15.94,-14.12,-11.78,-11.12,-11.0,-8.06,-3.84,-1.81,-1.88,-0.72,1.91,3.09,2.31,2.53,5.0,7.06,6.72,4.84,5.28,5.47,2.5,-1.62,-3.47,-3.44,-4.28,-5.22,-4.41,-1.06,0.62,-0.12,-0.97,0.09,1.19,0.28,-0.16,1.91,4.62,5.5,4.5,5.03,6.72,6.03,3.03,1.16,0.47,-1.16,-5.12,-8.16,-7.81,-6.72,-7.16,-7.56,-5.31,-2.5,-2.0,-3.62,-3.53,-2.03,-1.78,-3.16,-2.53,0.59,3.34,3.38,3.62,5.94,8.31,7.84,6.16,6.78,7.94,6.94,4.03,2.38,1.44,-1.72,-7.0,-11.03,-11.41,-10.88,-10.84,-9.88,-6.28,-2.56,-1.59,-2.25,-1.31,0.09,0.03,-1.59,-0.84,1.84,4.03,3.75,3.53,5.59,7.38,6.44,6.41,8.97,12.09,12.66,11.19,11.41,12.06,11.06,8.16,7.41,8.97,9.19,7.28,5.78,6.38,7.25,6.22,4.88,6.5,9.12,9.97,9.28,10.53,12.84,13.12,11.47,10.78,12.19,12.91,11.62,10.41,12.03,13.38,12.41,10.78,11.16,12.38,11.53,9.31,9.28,11.44,12.34,11.34,11.81,14.06,15.56,14.06,12.56,13.34,14.47,13.41,11.5,12.16,13.78,13.56,11.84,11.97,13.59,14.12,11.91,10.38,10.78,11.06,8.88,7.19,7.91,8.59,6.97,4.03,3.56,4.53,4.62,3.38,3.59,5.62,6.69,5.28,5.19,7.78,10.06,9.78,8.78,9.56,10.34,8.44,4.84,2.91,2.75,1.31,-0.97,-1.53,-0.06,1.16,-0.31,-1.53,-0.56,0.19,-1.09,-3.38,-2.69,-0.97,-0.53,-0.78,0.75,3.66,4.91,3.22,2.56,3.19,3.34,0.34,-1.91,-1.91,-1.12,-2.47,-3.94,-2.81,-0.62,0.09,-0.34,1.09,4.0,5.78,5.59,5.94,8.25,9.75,8.16,6.44,6.62,7.53,7.06,6.38,8.03,10.69,11.19,9.5,8.28,8.72,7.5,4.44,2.12,2.41,2.91,1.12,-0.47,0.69,2.22,1.38,0.44,1.03,3.25,3.91,2.62,2.41,3.81,4.31,2.34,0.56,1.44,2.28,1.22,0.0,0.91,2.38,1.97,0.28,0.81,2.56,3.09,2.16,1.91,3.12,3.41,1.22,-0.81,-0.66,-0.19,-2.03,-3.97,-4.16,-3.19,-3.44,-4.44,-3.31,0.03,2.31,2.91,3.81,6.59,8.62,7.94,6.66,7.41,8.12,6.03,3.41,2.56,3.47,2.88,1.44,1.75,4.03,5.5,4.66,4.25,5.94,7.47,6.44,5.56,7.0,9.47,9.69,9.19,10.16,11.97,12.12,10.19,9.09,9.59,9.03,6.72,5.97,8.22,11.28,12.31,13.31,15.78,18.56,18.44,16.94,16.41,16.66,15.47,12.91,11.0,11.75,11.72,9.41,7.22,7.09,7.38,5.03,1.88,0.28,-0.38,-2.59,-5.25,-5.66,-3.38,-1.44,-0.66,1.34,5.47,9.25,9.94,9.97,10.97,11.22,8.41,4.5,2.81,3.03,2.62,1.34,1.84,4.41,4.94,3.0,0.78,0.84,0.66,-1.38,-3.19,-2.25,-0.28,-0.16,-1.22,-0.38,1.12,0.47,-1.81,-2.81,-1.09,0.5,0.38,0.78,3.38,6.25,6.09,5.69,7.25,9.31,8.81,6.88,6.25,6.88,5.75,3.19,1.91,3.31,4.72,4.38,4.62,6.81,8.84,8.22,6.47,6.44,7.34,6.06,3.16,1.69,1.5,0.34,-2.84,-4.5,-3.44,-2.62,-3.78,-5.31,-4.81,-4.22,-4.94,-5.59,-3.38,0.94,3.91,5.41,7.03,9.59,10.12,7.12,4.06,3.06,1.66,-2.16,-6.03,-7.56,-8.25,-10.25,-12.09,-11.72,-8.94,-7.25,-6.59,-4.66,0.19,4.44,6.91,9.62,13.94,17.06,16.72,14.5,12.56,10.56,5.78,-0.44,-4.81,-6.66,-8.06,-9.5,-8.34,-3.78,0.66,2.12,2.81,4.69,5.47,3.53,0.69,-0.03,0.03,-1.41,-4.09,-5.06,-4.25,-4.66,-6.94,-9.25,-10.38,-12.75,-17.91,-23.16,-24.97,-25.0,-25.25,-25.19,-21.72,-16.47,-12.72,-10.16,-6.84,-2.09,0.88,1.0,0.44,1.03,0.78,-2.56,-6.59,-8.41,-9.16,-11.28,-14.03,-14.41,-12.84,-12.47,-12.91,-11.47,-7.5,-4.0,-2.09,0.12,3.75,6.72,6.28,4.88,4.56,4.97,3.69,0.56,-0.56,-0.66,-1.25,-3.66,-4.44,-1.88,0.38,0.97,1.72,4.75,7.53,8.16,8.0,9.78,12.16,12.34,10.78,9.88,10.34,10.31,8.69,8.53,10.75,12.06,10.12,6.75,4.31,2.44,-1.47,-5.66,-6.59,-5.38,-4.75,-5.5,-4.5,-1.97,-0.62,-1.81,-2.69,-1.47,-0.34,-1.53,-2.75,-1.34,1.12,1.59,1.22,2.91,5.69,7.41,6.97,7.59,9.47,9.94,7.88,6.0,6.31,7.41,6.84,5.81,7.25,9.41,10.09,9.53,10.22,12.03,12.16,9.94,8.06,8.28,7.97,6.03,4.81,6.22,8.34,8.84,7.75,8.56,9.53,8.03,4.78,2.88,2.75,2.72,1.19,0.91,2.56,4.44,3.25,2.22,3.53,5.09,4.53,2.91,2.91,3.94,3.91,2.69,3.34,6.25,8.44,8.16,8.34,9.81,11.09,9.81,7.47,7.34,7.69,6.09,3.69,3.66,5.22,5.66,4.47,4.06,5.28,5.72,4.06,2.56,3.59,4.94,3.94,2.72,3.94,6.25,6.88,5.91,6.31,7.62,7.16,4.75,3.5,4.84,6.59,6.56,6.84,9.06,11.81,11.5,9.62,9.28,9.69,8.09,5.09,3.78,5.0,5.69,4.66,5.0,8.03,11.09,11.72,11.75,13.88,16.06,15.69,14.25,14.69,16.34,16.28,13.91,12.81,13.03,11.78,8.41,5.25,4.5,3.91,1.38,-0.72,0.12,2.44,3.5,4.31,6.56,10.19,12.06,11.53,11.31,12.66,13.0,10.53,7.69,6.75,6.16,3.25,0.72,0.91,3.0,4.12,4.75,7.59,12.12,16.22,17.12,18.28,20.47,21.38,19.09,16.41,15.94,16.16,14.25,12.09,12.41,14.25,14.06,12.38,12.19,14.06,15.34,15.06,15.5,17.94,19.66,18.47,16.62,17.25,18.44,17.69,15.53,14.53,15.5,14.66,12.59,12.12,13.81,13.94,11.31,9.0,9.0,9.22,7.31,5.25,5.16,6.12,5.0,3.53,4.53,8.12,10.62,11.31,12.16,14.34,14.84,12.06,9.78,10.12,11.84,12.38,13.0,15.81,19.56,20.72,19.38,18.88,19.5,18.44,15.69,14.06,14.81,15.72,14.16,12.5,13.09,14.09,12.88,11.09,11.78,13.78,14.03,12.81,13.03,15.59,17.28,17.41,39.91,39.0,37.38,34.25,30.53,29.59,30.03,30.38,30.41,32.12,33.41,34.0,32.72,31.56,32.0,32.25,31.31,30.62,31.22,31.75,31.0,29.81,30.53,32.03,32.97,33.84,35.31,37.75:7.62,8.5,7.16,4.47,3.16,3.34,2.5,-0.12,-0.44,1.94,4.5,4.75,5.38,7.62,9.69,8.78,6.94,6.62,7.72,7.22,5.44,5.34,6.81,6.91,4.59,3.16,3.75,4.53,3.44,2.72,4.88,7.81,8.66,8.97,10.84,13.62,14.19,12.81,12.34,13.16,12.88,10.5,9.22,10.5,11.69,10.94,9.59,10.44,12.03,10.69,8.41,8.53,9.53,9.75,9.22,10.44,14.19,17.03,17.5,17.69,19.16,19.91,17.38,14.72,14.31,15.31,15.09,14.16,15.16,17.03,16.84,13.97,11.5,11.09,10.41,7.41,5.06,5.31,5.88,4.0,1.91,2.06,3.53,3.03,1.38,1.72,4.34,6.19,5.72,6.28,8.5,9.81,7.81,6.22,7.19,9.06,8.72,8.44,10.19,12.78,12.91,11.34,10.59,11.28,10.69,7.5,5.12,5.19,4.88,2.78,0.91,1.38,2.66,1.16,-0.88,-0.66,1.25,2.25,2.12,3.19,5.59,6.22,3.84,1.5,1.72,1.72,-0.53,-2.31,-1.31,0.16,-1.06,-3.38,-3.84,-2.72,-3.03,-4.56,-4.34,-1.69,0.09,-0.34,-0.78,0.62,1.47,-0.72,-3.59,-4.0,-3.25,-4.34,-6.16,-5.34,-1.91,0.56,1.59,2.94,6.31,8.09,6.72,5.19,5.75,6.44,4.84,2.69,3.16,5.09,4.62,2.78,2.0,2.97,2.78,0.5,-0.34,1.09,2.12,0.62,-0.47,1.09,3.56,4.0,3.5,5.09,7.81,8.03,6.38,5.66,6.31,5.41,2.66,0.22,0.69,0.78,-1.53,-3.84,-3.28,-2.09,-2.47,-3.25,-1.81,0.81,1.5,0.56,0.78,3.53,5.25,5.12,5.53,7.84,9.62,8.03,5.28,4.19,3.81,1.41,-1.5,-1.97,0.22,1.78,2.5,4.38,8.69,11.59,11.12,10.78,12.16,13.38,11.66,9.03,8.41,8.31,5.94,2.56,1.31,1.94,1.91,0.81,1.09,4.34,7.06,7.38,7.25,9.59,11.53,10.5,8.84,8.72,9.66,8.25,5.06,3.16,3.06,1.66,-1.38,-3.59,-2.31,-1.81,-3.22,-4.69,-3.41,-1.62,-2.06,-2.91,-2.03,0.47,0.81,-1.31,-2.38,-2.12,-3.28,-6.81,-9.34,-8.91,-8.25,-9.59,-10.5,-8.56,-6.19,-6.44,-7.88,-7.78,-6.69,-7.44,-10.03,-11.47,-10.12,-9.53,-10.34,-10.16,-6.97,-4.31,-4.0,-4.81,-3.53,-1.81,-2.5,-5.03,-5.62,-5.03,-5.91,-8.59,-9.69,-8.28,-7.09,-7.75,-8.25,-6.06,-3.62,-3.78,-4.34,-2.5,0.56,1.0,-0.25,-0.97,-0.88,-3.28,-7.91,-11.53,-12.03,-12.62,-14.81,-15.94,-14.12,-11.78,-11.12,-11.0,-8.06,-3.84,-1.81,-1.88,-0.72,1.91,3.09,2.31,2.53,5.0,7.06,6.72,4.84,5.28,5.47,2.5,-1.62,-3.47,-3.44,-4.28,-5.22,-4.41,-1.06,0.62,-0.12,-0.97,0.09,1.19,0.28,-0.16,1.91,4.62,5.5,4.5,5.03,6.72,6.03,3.03,1.16,0.47,-1.16,-5.12,-8.16,-7.81,-6.72,-7.16,-7.56,-5.31,-2.5,-2.0,-3.62,-3.53,-2.03,-1.78,-3.16,-2.53,0.59,3.34,3.38,3.62,5.94,8.31,7.84,6.16,6.78,7.94,6.94,4.03,2.38,1.44,-1.72,-7.0,-11.03,-11.41,-10.88,-10.84,-9.88,-6.28,-2.56,-1.59,-2.25,-1.31,0.09,0.03,-1.59,-0.84,1.84,4.03,3.75,3.53,5.59,7.38,6.44,6.41,8.97,12.09,12.66,11.19,11.41,12.06,11.06,8.16,7.41,8.97,9.19,7.28,5.78,6.38,7.25,6.22,4.88,6.5,9.12,9.97,9.28,10.53,12.84,13.12,11.47,10.78,12.19,12.91,11.62,10.41,12.03,13.38,12.41,10.78,11.16,12.38,11.53,9.31,9.28,11.44,12.34,11.34,11.81,14.06,15.56,14.06,12.56,13.34,14.47,13.41,11.5,12.16,13.78,13.56,11.84,11.97,13.59,14.12,11.91,10.38,10.78,11.06,8.88,7.19,7.91,8.59,6.97,4.03,3.56,4.53,4.62,3.38,3.59,5.62,6.69,5.28,5.19,7.78,10.06,9.78,8.78,9.56,10.34,8.44,4.84,2.91,2.75,1.31,-0.97,-1.53,-0.06,1.16,-0.31,-1.53,-0.56,0.19,-1.09,-3.38,-2.69,-0.97,-0.53,-0.78,0.75,3.66,4.91,3.22,2.56,3.19,3.34,0.34,-1.91,-1.91,-1.12,-2.47,-3.94,-2.81,-0.62,0.09,-0.34,1.09,4.0,5.78,5.59,5.94,8.25,9.75,8.16,6.44,6.62,7.53,7.06,6.38,8.03,10.69,11.19,9.5,8.28,8.72,7.5,4.44,2.12,2.41,2.91,1.12,-0.47,0.69,2.22,1.38,0.44,1.03,3.25,3.91,2.62,2.41,3.81,4.31,2.34,0.56,1.44,2.28,1.22,0.0,0.91,2.38,1.97,0.28,0.81,2.56,3.09,2.16,1.91,3.12,3.41,1.22,-0.81,-0.66,-0.19,-2.03,-3.97,-4.16,-3.19,-3.44,-4.44,-3.31,0.03,2.31,2.91,3.81,6.59,8.62,7.94,6.66,7.41,8.12,6.03,3.41,2.56,3.47,2.88,1.44,1.75,4.03,5.5,4.66,4.25,5.94,7.47,6.44,5.56,7.0,9.47,9.69,9.19,10.16,11.97,12.12,10.19,9.09,9.59,9.03,6.72,5.97,8.22,11.28,12.31,13.31,15.78,18.56,18.44,16.94,16.41,16.66,15.47,12.91,11.0,11.75,11.72,9.41,7.22,7.09,7.38,5.03,1.88,0.28,-0.38,-2.59,-5.25,-5.66,-3.38,-1.44,-0.66,1.34,5.47,9.25,9.94,9.97,10.97,11.22,8.41,4.5,2.81,3.03,2.62,1.34,1.84,4.41,4.94,3.0,0.78,0.84,0.66,-1.38,-3.19,-2.25,-0.28,-0.16,-1.22,-0.38,1.12,0.47,-1.81,-2.81,-1.09,0.5,0.38,0.78,3.38,6.25,6.09,5.69,7.25,9.31,8.81,6.88,6.25,6.88,5.75,3.19,1.91,3.31,4.72,4.38,4.62,6.81,8.84,8.22,6.47,6.44,7.34,6.06,3.16,1.69,1.5,0.34,-2.84,-4.5,-3.44,-2.62,-3.78,-5.31,-4.81,-4.22,-4.94,-5.59,-3.38,0.94,3.91,5.41,7.03,9.59,10.12,7.12,4.06,3.06,1.66,-2.16,-6.03,-7.56,-8.25,-10.25,-12.09,-11.72,-8.94,-7.25,-6.59,-4.66,0.19,4.44,6.91,9.62,13.94,17.06,16.72,14.5,12.56,10.56,5.78,-0.44,-4.81,-6.66,-8.06,-9.5,-8.34,-3.78,0.66,2.12,2.81,4.69,5.47,3.53,0.69,-0.03,0.03,-1.41,-4.09,-5.06,-4.25,-4.66,-6.94,-9.25,-10.38,-12.75,-17.91,-23.16,-24.97,-25.0,-25.25,-25.19,-21.72,-16.47,-12.72,-10.16,-6.84,-2.09,0.88,1.0,0.44,1.03,0.78,-2.56,-6.59,-8.41,-9.16,-11.28,-14.03,-14.41,-12.84,-12.47,-12.91,-11.47,-7.5,-4.0,-2.09,0.12,3.75,6.72,6.28,4.88,4.56,4.97,3.69,0.56,-0.56,-0.66,-1.25,-3.66,-4.44,-1.88,0.38,0.97,1.72,4.75,7.53,8.16,8.0,9.78,12.16,12.34,10.78,9.88,10.34,10.31,8.69,8.53,10.75,12.06,10.12,6.75,4.31,2.44,-1.47,-5.66,-6.59,-5.38,-4.75,-5.5,-4.5,-1.97,-0.62,-1.81,-2.69,-1.47,-0.34,-1.53,-2.75,-1.34,1.12,1.59,1.22,2.91,5.69,7.41,6.97,7.59,9.47,9.94,7.88,6.0,6.31,7.41,6.84,5.81,7.25,9.41,10.09,9.53,10.22,12.03,12.16,9.94,8.06,8.28,7.97,6.03,4.81,6.22,8.34,8.84,7.75,8.56,9.53,8.03,4.78,2.88,2.75,2.72,1.19,0.91,2.56,4.44,3.25,2.22,3.53,5.09,4.53,2.91,2.91,3.94,3.91,2.69,3.34,6.25,8.44,8.16,8.34,9.81,11.09,9.81,7.47,7.34,7.69,6.09,3.69,3.66,5.22,5.66,4.47,4.06,5.28,5.72,4.06,2.56,3.59,4.94,3.94,2.72,3.94,6.25,6.88,5.91,6.31,7.62,7.16,4.75,3.5,4.84,6.59,6.56,6.84,9.06,11.81,11.5,9.62,9.28,9.69,8.09,5.09,3.78,5.0,5.69,4.66,5.0,8.03,11.09,11.72,11.75,13.88,16.06,15.69,14.25,14.69,16.34,16.28,13.91,12.81,13.03,11.78,8.41,5.25,4.5,3.91,1.38,-0.72,0.12,2.44,3.5,4.31,6.56,10.19,12.06,11.53,11.31,12.66,13.0,10.53,7.69,6.75,6.16,3.25,0.72,0.91,3.0,4.12,4.75,7.59,12.12,16.22,17.12,18.28,20.47,21.38,19.09,16.41,15.94,16.16,14.25,12.09,12.41,14.25,14.06,12.38,12.19,14.06,15.34,15.06,15.5,17.94,19.66,18.47,16.62,17.25,18.44,17.69,15.53,14.53,15.5,14.66,12.59,12.12,13.81,13.94,11.31,9.0,9.0,9.22,7.31,5.25,5.16,6.12,5.0,3.53,4.53,8.12,10.62,11.31,12.16,14.34,14.84,12.06,9.78,10.12,11.84,12.38,13.0,15.81,19.56,20.72,19.38,18.88,19.5,18.44,15.69,14.06,14.81,15.72,14.16,12.5,13.09,14.09,12.88,11.09,11.78,13.78,14.03,12.81,13.03,15.59,17.28,17.41,39.91,39.0,37.38,34.25,30.53,29.59,30.03,30.38,30.41,32.12,33.41,34.0,32.72,31.56,32.0,32.25,31.31,30.62,31.22,31.75,31.0,29.81,30.53,32.03,32.97,33.84,35.31,37.75,38.94,38.62,38.03,38.25,38.12,36.38,34.91:-0.12,-0.44,1.94,4.5,4.75,5.38,7.62,9.69,8.78,6.94,6.62,7.72,7.22,5.44,5.34,6.81,6.91,4.59,3.16,3.75,4.53,3.44,2.72,4.88,7.81,8.66,8.97,10.84,13.62,14.19,12.81,12.34,13.16,12.88,10.5,9.22,10.5,11.69,10.94,9.59,10.44,12.03,10.69,8.41,8.53,9.53,9.75,9.22,10.44,14.19,17.03,17.5,17.69,19.16,19.91,17.38,14.72,14.31,15.31,15.09,14.16,15.16,17.03,16.84,13.97,11.5,11.09,10.41,7.41,5.06,5.31,5.88,4.0,1.91,2.06,3.53,3.03,1.38,1.72,4.34,6.19,5.72,6.28,8.5,9.81,7.81,6.22,7.19,9.06,8.72,8.44,10.19,12.78,12.91,11.34,10.59,11.28,10.69,7.5,5.12,5.19,4.88,2.78,0.91,1.38,2.66,1.16,-0.88,-0.66,1.25,2.25,2.12,3.19,5.59,6.22,3.84,1.5,1.72,1.72,-0.53,-2.31,-1.31,0.16,-1.06,-3.38,-3.84,-2.72,-3.03,-4.56,-4.34,-1.69,0.09,-0.34,-0.78,0.62,1.47,-0.72,-3.59,-4.0,-3.25,-4.34,-6.16,-5.34,-1.91,0.56,1.59,2.94,6.31,8.09,6.72,5.19,5.75,6.44,4.84,2.69,3.16,5.09,4.62,2.78,2.0,2.97,2.78,0.5,-0.34,1.09,2.12,0.62,-0.47,1.09,3.56,4.0,3.5,5.09,7.81,8.03,6.38,5.66,6.31,5.41,2.66,0.22,0.69,0.78,-1.53,-3.84,-3.28,-2.09,-2.47,-3.25,-1.81,0.81,1.5,0.56,0.78,3.53,5.25,5.12,5.53,7.84,9.62,8.03,5.28,4.19,3.81,1.41,-1.5,-1.97,0.22,1.78,2.5,4.38,8.69,11.59,11.12,10.78,12.16,13.38,11.66,9.03,8.41,8.31,5.94,2.56,1.31,1.94,1.91,0.81,1.09,4.34,7.06,7.38,7.25,9.59,11.53,10.5,8.84,8.72,9.66,8.25,5.06,3.16,3.06,1.66,-1.38,-3.59,-2.31,-1.81,-3.22,-4.69,-3.41,-1.62,-2.06,-2.91,-2.03,0.47,0.81,-1.31,-2.38,-2.12,-3.28,-6.81,-9.34,-8.91,-8.25,-9.59,-10.5,-8.56,-6.19,-6.44,-7.88,-7.78,-6.69,-7.44,-10.03,-11.47,-10.12,-9.53,-10.34,-10.16,-6.97,-4.31,-4.0,-4.81,-3.53,-1.81,-2.5,-5.03,-5.62,-5.03,-5.91,-8.59,-9.69,-8.28,-7.09,-7.75,-8.25,-6.06,-3.62,-3.78,-4.34,-2.5,0.56,1.0,-0.25,-0.97,-0.88,-3.28,-7.91,-11.53,-12.03,-12.62,-14.81,-15.94,-14.12,-11.78,-11.12,-11.0,-8.06,-3.84,-1.81,-1.88,-0.72,1.91,3.09,2.31,2.53,5.0,7.06,6.72,4.84,5.28,5.47,2.5,-1.62,-3.47,-3.44,-4.28,-5.22,-4.41,-1.06,0.62,-0.12,-0.97,0.09,1.19,0.28,-0.16,1.91,4.62,5.5,4.5,5.03,6.72,6.03,3.03,1.16,0.47,-1.16,-5.12,-8.16,-7.81,-6.72,-7.16,-7.56,-5.31,-2.5,-2.0,-3.62,-3.53,-2.03,-1.78,-3.16,-2.53,0.59,3.34,3.38,3.62,5.94,8.31,7.84,6.16,6.78,7.94,6.94,4.03,2.38,1.44,-1.72,-7.0,-11.03,-11.41,-10.88,-10.84,-9.88,-6.28,-2.56,-1.59,-2.25,-1.31,0.09,0.03,-1.59,-0.84,1.84,4.03,3.75,3.53,5.59,7.38,6.44,6.41,8.97,12.09,12.66,11.19,11.41,12.06,11.06,8.16,7.41,8.97,9.19,7.28,5.78,6.38,7.25,6.22,4.88,6.5,9.12,9.97,9.28,10.53,12.84,13.12,11.47,10.78,12.19,12.91,11.62,10.41,12.03,13.38,12.41,10.78,11.16,12.38,11.53,9.31,9.28,11.44,12.34,11.34,11.81,14.06,15.56,14.06,12.56,13.34,14.47,13.41,11.5,12.16,13.78,13.56,11.84,11.97,13.59,14.12,11.91,10.38,10.78,11.06,8.88,7.19,7.91,8.59,6.97,4.03,3.56,4.53,4.62,3.38,3.59,5.62,6.69,5.28,5.19,7.78,10.06,9.78,8.78,9.56,10.34,8.44,4.84,2.91,2.75,1.31,-0.97,-1.53,-0.06,1.16,-0.31,-1.53,-0.56,0.19,-1.09,-3.38,-2.69,-0.97,-0.53,-0.78,0.75,3.66,4.91,3.22,2.56,3.19,3.34,0.34,-1.91,-1.91,-1.12,-2.47,-3.94,-2.81,-0.62,0.09,-0.34,1.09,4.0,5.78,5.59,5.94,8.25,9.75,8.16,6.44,6.62,7.53,7.06,6.38,8.03,10.69,11.19,9.5,8.28,8.72,7.5,4.44,2.12,2.41,2.91,1.12,-0.47,0.69,2.22,1.38,0.44,1.03,3.25,3.91,2.62,2.41,3.81,4.31,2.34,0.56,1.44,2.28,1.22,0.0,0.91,2.38,1.97,0.28,0.81,2.56,3.09,2.16,1.91,3.12,3.41,1.22,-0.81,-0.66,-0.19,-2.03,-3.97,-4.16,-3.19,-3.44,-4.44,-3.31,0.03,2.31,2.91,3.81,6.59,8.62,7.94,6.66,7.41,8.12,6.03,3.41,2.56,3.47,2.88,1.44,1.75,4.03,5.5,4.66,4.25,5.94,7.47,6.44,5.56,7.0,9.47,9.69,9.19,10.16,11.97,12.12,10.19,9.09,9.59,9.03,6.72,5.97,8.22,11.28,12.31,13.31,15.78,18.56,18.44,16.94,16.41,16.66,15.47,12.91,11.0,11.75,11.72,9.41,7.22,7.09,7.38,5.03,1.88,0.28,-0.38,-2.59,-5.25,-5.66,-3.38,-1.44,-0.66,1.34,5.47,9.25,9.94,9.97,10.97,11.22,8.41,4.5,2.81,3.03,2.62,1.34,1.84,4.41,4.94,3.0,0.78,0.84,0.66,-1.38,-3.19,-2.25,-0.28,-0.16,-1.22,-0.38,1.12,0.47,-1.81,-2.81,-1.09,0.5,0.38,0.78,3.38,6.25,6.09,5.69,7.25,9.31,8.81,6.88,6.25,6.88,5.75,3.19,1.91,3.31,4.72,4.38,4.62,6.81,8.84,8.22,6.47,6.44,7.34,6.06,3.16,1.69,1.5,0.34,-2.84,-4.5,-3.44,-2.62,-3.78,-5.31,-4.81,-4.22,-4.94,-5.59,-3.38,0.94,3.91,5.41,7.03,9.59,10.12,7.12,4.06,3.06,1.66,-2.16,-6.03,-7.56,-8.25,-10.25,-12.09,-11.72,-8.94,-7.25,-6.59,-4.66,0.19,4.44,6.91,9.62,13.94,17.06,16.72,14.5,12.56,10.56,5.78,-0.44,-4.81,-6.66,-8.06,-9.5,-8.34,-3.78,0.66,2.12,2.81,4.69,5.47,3.53,0.69,-0.03,0.03,-1.41,-4.09,-5.06,-4.25,-4.66,-6.94,-9.25,-10.38,-12.75,-17.91,-23.16,-24.97,-25.0,-25.25,-25.19,-21.72,-16.47,-12.72,-10.16,-6.84,-2.09,0.88,1.0,0.44,1.03,0.78,-2.56,-6.59,-8.41,-9.16,-11.28,-14.03,-14.41,-12.84,-12.47,-12.91,-11.47,-7.5,-4.0,-2.09,0.12,3.75,6.72,6.28,4.88,4.56,4.97,3.69,0.56,-0.56,-0.66,-1.25,-3.66,-4.44,-1.88,0.38,0.97,1.72,4.75,7.53,8.16,8.0,9.78,12.16,12.34,10.78,9.88,10.34,10.31,8.69,8.53,10.75,12.06,10.12,6.75,4.31,2.44,-1.47,-5.66,-6.59,-5.38,-4.75,-5.5,-4.5,-1.97,-0.62,-1.81,-2.69,-1.47,-0.34,-1.53,-2.75,-1.34,1.12,1.59,1.22,2.91,5.69,7.41,6.97,7.59,9.47,9.94,7.88,6.0,6.31,7.41,6.84,5.81,7.25,9.41,10.09,9.53,10.22,12.03,12.16,9.94,8.06,8.28,7.97,6.03,4.81,6.22,8.34,8.84,7.75,8.56,9.53,8.03,4.78,2.88,2.75,2.72,1.19,0.91,2.56,4.44,3.25,2.22,3.53,5.09,4.53,2.91,2.91,3.94,3.91,2.69,3.34,6.25,8.44,8.16,8.34,9.81,11.09,9.81,7.47,7.34,7.69,6.09,3.69,3.66,5.22,5.66,4.47,4.06,5.28,5.72,4.06,2.56,3.59,4.94,3.94,2.72,3.94,6.25,6.88,5.91,6.31,7.62,7.16,4.75,3.5,4.84,6.59,6.56,6.84,9.06,11.81,11.5,9.62,9.28,9.69,8.09,5.09,3.78,5.0,5.69,4.66,5.0,8.03,11.09,11.72,11.75,13.88,16.06,15.69,14.25,14.69,16.34,16.28,13.91,12.81,13.03,11.78,8.41,5.25,4.5,3.91,1.38,-0.72,0.12,2.44,3.5,4.31,6.56,10.19,12.06,11.53,11.31,12.66,13.0,10.53,7.69,6.75,6.16,3.25,0.72,0.91,3.0,4.12,4.75,7.59,12.12,16.22,17.12,18.28,20.47,21.38,19.09,16.41,15.94,16.16,14.25,12.09,12.41,14.25,14.06,12.38,12.19,14.06,15.34,15.06,15.5,17.94,19.66,18.47,16.62,17.25,18.44,17.69,15.53,14.53,15.5,14.66,12.59,12.12,13.81,13.94,11.31,9.0,9.0,9.22,7.31,5.25,5.16,6.12,5.0,3.53,4.53,8.12,10.62,11.31,12.16,14.34,14.84,12.06,9.78,10.12,11.84,12.38,13.0,15.81,19.56,20.72,19.38,18.88,19.5,18.44,15.69,14.06,14.81,15.72,14.16,12.5,13.09,14.09,12.88,11.09,11.78,13.78,14.03,12.81,13.03,15.59,17.28,17.41,39.91,39.0,37.38,34.25,30.53,29.59,30.03,30.38,30.41,32.12,33.41,34.0,32.72,31.56,32.0,32.25,31.31,30.62,31.22,31.75,31.0,29.81,30.53,32.03,32.97,33.84,35.31,37.75,38.94,38.62,38.03,38.25,38.12,36.38,34.91,34.59,34.78,33.5,31.09,29.88,28.62,27.06:negativity
13.78,14.53,15.88,15.75,14.53,14.19,15.84,16.47,14.94,13.75,15.34,16.69,16.0,15.16,16.38,18.06,17.84,16.41,16.44,17.41,16.31,13.16,11.22,11.75,11.69,9.84,8.94,10.22,11.25,10.16,8.16,8.09,8.75,7.72,6.0,6.0,7.75,8.47,7.16,6.28,7.72,8.31,7.06,6.09,7.88,10.0,10.56,10.12,11.5,13.19,13.19,11.59,10.72,11.03,10.66,8.78,7.78,9.28,11.44,11.53,11.06,12.12,13.31,12.47,10.5,10.12,11.72,12.12,10.88,9.88,10.62,10.09,7.75,5.72,6.66,8.72,9.09,9.31,11.38,13.62,13.22,9.72,6.75,4.72,2.0,-1.84,-3.38,-1.09,1.78,3.62,5.47,9.38,13.31,14.88,14.22,14.81,15.53,14.06,10.81,8.56,8.19,7.66,5.91,4.5,6.38,8.0,7.47,6.31,7.41,9.81,11.0,11.78,14.25,18.16,20.94,21.38,21.94,24.56,25.72,23.78,21.09,20.06,18.28,13.88,8.06,4.16,1.28,-2.78,-7.06,-8.72,-7.47,-5.66,-4.84,-2.47,2.38,6.72,8.12,8.31,9.94,10.81,9.41,6.47,5.28,5.19,3.84,0.72,-1.47,-2.56,-4.22,-8.44,-11.59,-11.53,-9.97,-9.5,-8.97,-5.28,-0.62,2.0,3.19,5.5,8.44,9.81,8.69,8.22,9.69,10.84,9.5,8.28,9.25,11.03,11.16,10.72,12.62,14.91,14.72,11.78,9.03,7.75,5.47,1.66,-0.72,-0.53,-0.12,-1.75,-2.88,-0.5,3.03,5.28,6.66,9.41,12.56,14.19,13.44,14.03,16.34,17.72,17.0,16.28,17.66,19.5,18.59,16.91,17.0,17.25,15.16,11.66,9.81,9.56,8.28,5.81,4.69,6.62,8.72,9.31,10.44,13.31,16.03,15.88,14.53,14.72,16.19,16.34,15.25,15.28,17.09,17.25,14.69,12.44,12.03,11.62,9.09,6.75,6.91,8.72,9.19,9.12,11.09,14.53,16.28,15.31,14.44,15.25,16.0,14.44,13.41,15.22,17.56,17.66,16.81,17.81,19.75,19.78,17.81,16.84,17.78,17.44,15.06,13.84,14.94,16.0,15.03,14.28,16.09,18.47,18.91,18.22,18.72,20.19,19.03,15.88,13.66,13.47,12.69,10.12,8.03,8.66,9.03,6.84,4.62,4.28,5.0,4.25,2.97,4.06,7.25,9.5,10.34,11.69,15.09,17.38,17.06,16.94,18.88,20.91,20.25,18.34,17.91,17.88,15.62,12.09,10.66,11.03,10.75,8.31,6.97,7.97,8.94,8.03,7.38,9.19,11.62,11.16,9.62,9.78,10.81,9.88,7.5,6.66,7.97,8.47,6.41,3.97,3.31,2.44,-0.59,-3.16,-2.06,1.16,2.69,3.88,6.72,10.88,13.19,13.53,13.88,16.0,16.41,14.19,11.75,11.91,11.97,9.47,5.81,4.69,4.25,2.75,0.56,-0.06,1.06,0.53,-2.22,-4.56,-4.28,-3.66,-4.28,-4.75,-1.88,1.62,3.16,4.0,7.19,11.19,12.62,12.25,12.0,12.53,11.69,8.19,5.16,4.91,4.97,3.84,2.97,4.91,7.5,7.84,7.03,7.47,9.34,9.59,8.19,7.31,8.84,9.44,7.97,6.38,7.31,8.25,7.06,5.44,6.31,8.53,8.88,8.03,8.22,9.84,9.97,8.03,6.78,8.22,9.66,8.84,8.06,9.44,10.81,10.06,8.19,8.38,9.84,9.78,8.25,8.56,11.53,13.53,13.69,13.97,16.06,17.03,15.06,12.12,11.28,11.38,10.44,8.38,8.47,10.0,10.34,8.72,7.97,10.12,11.69,11.31,11.75,14.47,16.88,16.62,15.44,15.62,17.09,16.94,15.59,16.22,17.91,18.41,16.75,15.69,16.59,17.16,15.47,13.53,14.31,15.59,15.75,14.41,15.12,16.88,17.25,15.88,15.38,17.03,18.12,16.78,15.78,17.12,18.28,17.16,15.34,15.78,17.22,17.06,16.09,17.16,19.81,21.0,20.44,20.84,23.25,24.28,22.84,20.44,19.66,19.06,16.75,14.03,13.94,14.75,14.62,13.19,13.5,15.31,16.16,14.84,13.97,15.38,16.5,14.81,13.25,13.78,14.97,14.62,13.53,14.66,16.28,16.09,13.41,12.0,11.78,10.91,8.38,6.94,8.0,9.53,8.94,8.06,9.72,11.78,12.47,12.06,13.78,17.06,19.5,19.97,20.94,23.5,24.5,22.44,19.75,19.34,19.03,17.0,14.97,15.19,17.12,17.31,16.34,16.22,17.44,17.88,15.88,14.91,16.34,17.59,17.12,16.41,18.09,20.66,21.28,20.97,22.28,24.34,24.72,23.0,22.09,22.88,22.88,20.47,19.25,20.44,22.22,22.19,22.09,24.25,26.88,27.38,26.53,26.72,27.72,27.97,26.09,25.31,26.25,26.91,24.62,22.16,22.09,22.19,20.06,18.25,18.47,19.47,19.47,18.28,18.31,19.97,20.62,19.44,19.06,21.0,23.09,23.16,23.0,24.41,26.19,25.28,23.59,23.28,24.47,24.78,23.84,24.44,27.28,29.47,28.81,28.31,29.75,31.09,30.0,28.81,30.03,31.97,32.16,30.94,30.53,30.97,29.47,25.97,24.25,25.0,25.81,25.44,24.88,26.34,28.12,27.16,25.31,24.94,25.41,23.62,20.56,18.5,17.66,16.22,13.66,12.38,14.72,18.31,20.28,22.09,25.84,29.25,29.81,29.09,29.31,30.81,30.66,28.81,27.78,28.31,27.53,24.47,21.69,21.06,20.84,18.91,17.16,18.0,19.97,20.72,20.41,21.38,23.56,24.31,23.19,22.75,24.28,25.25,23.53,21.06,20.41,19.56,16.56,13.44,12.56,14.03,14.44,13.56,14.31,17.25,18.78,18.56,19.56,22.97,25.56,25.97,25.69,26.78,28.03,27.41,25.44,25.06,25.59,24.47,21.41,18.84,18.75,17.91,15.78,14.31,15.81,18.34,19.28,20.56,24.03,28.03,29.59,28.78,27.88,27.25,24.84,20.31,16.47,14.97,13.59,10.78,8.56,9.62,11.69,12.25,12.25,13.69,15.88,16.22,15.38,15.72,18.16,19.78,19.5,19.78,22.69,25.41,26.03,25.81,26.72,27.47,25.31,22.19,20.44,20.88,21.12,20.53,21.88,25.19,27.06,25.25,22.47,21.12,19.44,15.84,12.97,12.78,14.78,15.81,16.06,17.97,20.91,22.06,20.16,17.81,16.94,15.56,12.41,10.25,11.38,13.78,14.97,15.53,18.03,21.31,22.62,22.28,23.09,25.5,26.59,25.28,24.0,25.31,26.34,25.81,25.84,28.66,32.0,33.38,33.34,34.25,36.16,36.56,34.44,32.69,32.28,30.22,25.62,21.34,19.47,18.19,15.25,12.34,12.06,13.41,13.5,12.44,13.0,15.5,16.94,17.12,18.75,23.06,27.12,28.81,29.91,33.12,36.44,37.22,36.72,37.53,38.19,36.38,32.34,28.94,27.41,24.91,20.62,17.34,16.81,17.0,15.59,14.47,16.06,18.81,20.06,20.97,24.19,29.0,32.91,34.75,36.44,39.75,41.5,40.91,40.03,41.19,41.84,40.09,36.75,35.22,34.66,32.06,28.59,26.47,25.88,24.72,21.62,19.56,19.75,19.78,17.25,14.5,13.28,12.94,10.53,7.84,8.25,10.91,12.88,13.31,15.56,19.59,22.88,23.84,25.19,28.0,29.72,28.78,26.88,26.59,27.22,25.72,23.75,23.69,25.5,26.25,25.06,24.69,25.25,24.97,21.41,18.12,17.69,17.69,16.88,16.28,18.22,21.44,22.19,21.22,20.75,21.78,20.84,18.12,16.81,17.38,18.0,16.12,14.41,14.72,15.5,15.0,14.16,15.88,19.84,22.38,23.56,25.62,28.5,29.28,26.97,25.12,25.12,25.22,22.78,19.72,18.5,17.56,14.66,10.84,9.59,10.19,10.56,9.75,10.41,13.62,15.84,15.25,15.25,17.25,19.78,19.84,19.94,21.97,24.88,25.66,25.53,27.16,30.62,33.06,32.84,32.75,33.69,32.94,29.31,25.97,24.62,24.56,22.88,21.25,22.25,24.66,25.16,23.88,23.28,23.5,23.09,20.75,19.97,22.34,25.25,25.81,26.09,28.19,29.91,29.09,26.44,24.94,24.34,22.12,17.75,14.88,14.19,13.31,11.09,10.31,12.25,14.94,15.62,15.88,18.12,21.16,22.19,21.66,22.47,24.41,25.16,23.66,23.0,24.66,25.81,24.81,23.91,25.19,25.97,24.09,21.81,20.94,21.16,20.12,18.38,17.81,18.97,19.0,16.5,14.88,15.75,16.62,15.72,14.97,16.53,18.72,18.66,17.03,17.88,20.28,21.28,21.41,22.72,25.56,26.41,23.91,20.69,19.34,17.91,14.47,11.28,10.69,11.69,10.94,9.12,8.75,9.78,8.62,6.12,4.91,6.53,8.81,10.0,12.16,17.0,22.5,25.0,26.41,28.88,31.56,31.0,28.75,26.91,26.47,24.28,20.53,17.28,16.38,15.38,12.38,10.0,10.16,11.97,11.81,11.12,12.59,15.62,16.84,16.38,16.78,18.94,19.47,17.44,15.78,15.75,15.84,13.72,11.19,11.62,13.5,13.88,14.19,15.88,18.91,19.69,17.94,16.16,16.31,15.53,13.22,11.88,13.38,15.5,15.38,14.47,15.38,17.06,16.44,14.72,14.53,16.38,16.94,15.91,15.31,17.06,17.66,15.53,12.38,11.38,11.16,8.97,6.62,7.09,9.34,10.28,9.59,10.44,13.22,14.66,14.0,13.97,16.62,19.03,19.41,19.25,21.53,24.62,25.44,24.94,25.5,26.78,25.56,22.25,19.88,20.03,19.94,17.75,16.31,17.25,17.94,16.5,14.25,14.78,16.22,16.38,15.62,17.0,19.75,21.34,21.0,21.22,23.5:16.47,14.94,13.75,15.34,16.69,16.0,15.16,16.38,18.06,17.84,16.41,16.44,17.41,16.31,13.16,11.22,11.75,11.69,9.84,8.94,10.22,11.25,10.16,8.16,8.09,8.75,7.72,6.0,6.0,7.75,8.47,7.16,6.28,7.72,8.31,7.06,6.09,7.88,10.0,10.56,10.12,11.5,13.19,13.19,11.59,10.72,11.03,10.66,8.78,7.78,9.28,11.44,11.53,11.06,12.12,13.31,12.47,10.5,10.12,11.72,12.12,10.88,9.88,10.62,10.09,7.75,5.72,6.66,8.72,9.09,9.31,11.38,13.62,13.22,9.72,6.75,4.72,2.0,-1.84,-3.38,-1.09,1.78,3.62,5.47,9.38,13.31,14.88,14.22,14.81,15.53,14.06,10.81,8.56,8.19,7.66,5.91,4.5,6.38,8.0,7.47,6.31,7.41,9.81,11.0,11.78,14.25,18.16,20.94,21.38,21.94,24.56,25.72,23.78,21.09,20.06,18.28,13.88,8.06,4.16,1.28,-2.78,-7.06,-8.72,-7.47,-5.66,-4.84,-2.47,2.38,6.72,8.12,8.31,9.94,10.81,9.41,6.47,5.28,5.19,3.84,0.72,-1.47,-2.56,-4.22,-8.44,-11.59,-11.53,-9.97,-9.5,-8.97,-5.28,-0.62,2.0,3.19,5.5,8.44,9.81,8.69,8.22,9.69,10.84,9.5,8.28,9.25,11.03,11.16,10.72,12.62,14.91,14.72,11.78,9.03,7.75,5.47,1.66,-0.72,-0.53,-0.12,-1.75,-2.88,-0.5,3.03,5.28,6.66,9.41,12.56,14.19,13.44,14.03,16.34,17.72,17.0,16.28,17.66,19.5,18.59,16.91,17.0,17.25,15.16,11.66,9.81,9.56,8.28,5.81,4.69,6.62,8.72,9.31,10.44,13.31,16.03,15.88,14.53,14.72,16.19,16.34,15.25,15.28,17.09,17.25,14.69,12.44,12.03,11.62,9.09,6.75,6.91,8.72,9.19,9.12,11.09,14.53,16.28,15.31,14.44,15.25,16.0,14.44,13.41,15.22,17.56,17.66,16.81,17.81,19.75,19.78,17.81,16.84,17.78,17.44,15.06,13.84,14.94,16.0,15.03,14.28,16.09,18.47,18.91,18.22,18.72,20.19,19.03,15.88,13.66,13.47,12.69,10.12,8.03,8.66,9.03,6.84,4.62,4.28,5.0,4.25,2.97,4.06,7.25,9.5,10.34,11.69,15.09,17.38,17.06,16.94,18.88,20.91,20.25,18.34,17.91,17.88,15.62,12.09,10.66,11.03,10.75,8.31,6.97,7.97,8.94,8.03,7.38,9.19,11.62,11.16,9.62,9.78,10.81,9.88,7.5,6.66,7.97,8.47,6.41,3.97,3.31,2.44,-0.59,-3.16,-2.06,1.16,2.69,3.88,6.72,10.88,13.19,13.53,13.88,16.0,16.41,14.19,11.75,11.91,11.97,9.47,5.81,4.69,4.25,2.75,0.56,-0.06,1.06,0.53,-2.22,-4.56,-4.28,-3.66,-4.28,-4.75,-1.88,1.62,3.16,4.0,7.19,11.19,12.62,12.25,12.0,12.53,11.69,8.19,5.16,4.91,4.97,3.84,2.97,4.91,7.5,7.84,7.03,7.47,9.34,9.59,8.19,7.31,8.84,9.44,7.97,6.38,7.31,8.25,7.06,5.44,6.31,8.53,8.88,8.03,8.22,9.84,9.97,8.03,6.78,8.22,9.66,8.84,8.06,9.44,10.81,10.06,8.19,8.38,9.84,9.78,8.25,8.56,11.53,13.53,13.69,13.97,16.06,17.03,15.06,12.12,11.28,11.38,10.44,8.38,8.47,10.0,10.34,8.72,7.97,10.12,11.69,11.31,11.75,14.47,16.88,16.62,15.44,15.62,17.09,16.94,15.59,16.22,17.91,18.41,16.75,15.69,16.59,17.16,15.47,13.53,14.31,15.59,15.75,14.41,15.12,16.88,17.25,15.88,15.38,17.03,18.12,16.78,15.78,17.12,18.28,17.16,15.34,15.78,17.22,17.06,16.09,17.16,19.81,21.0,20.44,20.84,23.25,24.28,22.84,20.44,19.66,19.06,16.75,14.03,13.94,14.75,14.62,13.19,13.5,15.31,16.16,14.84,13.97,15.38,16.5,14.81,13.25,13.78,14.97,14.62,13.53,14.66,16.28,16.09,13.41,12.0,11.78,10.91,8.38,6.94,8.0,9.53,8.94,8.06,9.72,11.78,12.47,12.06,13.78,17.06,19.5,19.97,20.94,23.5,24.5,22.44,19.75,19.34,19.03,17.0,14.97,15.19,17.12,17.31,16.34,16.22,17.44,17.88,15.88,14.91,16.34,17.59,17.12,16.41,18.09,20.66,21.28,20.97,22.28,24.34,24.72,23.0,22.09,22.88,22.88,20.47,19.25,20.44,22.22,22.19,22.09,24.25,26.88,27.38,26.53,26.72,27.72,27.97,26.09,25.31,26.25,26.91,24.62,22.16,22.09,22.19,20.06,18.25,18.47,19.47,19.47,18.28,18.31,19.97,20.62,19.44,19.06,21.0,23.09,23.16,23.0,24.41,26.19,25.28,23.59,23.28,24.47,24.78,23.84,24.44,27.28,29.47,28.81,28.31,29.75,31.09,30.0,28.81,30.03,31.97,32.16,30.94,30.53,30.97,29.47,25.97,24.25,25.0,25.81,25.44,24.88,26.34,28.12,27.16,25.31,24.94,25.41,23.62,20.56,18.5,17.66,16.22,13.66,12.38,14.72,18.31,20.28,22.09,25.84,29.25,29.81,29.09,29.31,30.81,30.66,28.81,27.78,28.31,27.53,24.47,21.69,21.06,20.84,18.91,17.16,18.0,19.97,20.72,20.41,21.38,23.56,24.31,23.19,22.75,24.28,25.25,23.53,21.06,20.41,19.56,16.56,13.44,12.56,14.03,14.44,13.56,14.31,17.25,18.78,18.56,19.56,22.97,25.56,25.97,25.69,26.78,28.03,27.41,25.44,25.06,25.59,24.47,21.41,18.84,18.75,17.91,15.78,14.31,15.81,18.34,19.28,20.56,24.03,28.03,29.59,28.78,27.88,27.25,24.84,20.31,16.47,14.97,13.59,10.78,8.56,9.62,11.69,12.25,12.25,13.69,15.88,16.22,15.38,15.72,18.16,19.78,19.5,19.78,22.69,25.41,26.03,25.81,26.72,27.47,25.31,22.19,20.44,20.88,21.12,20.53,21.88,25.19,27.06,25.25,22.47,21.12,19.44,15.84,12.97,12.78,14.78,15.81,16.06,17.97,20.91,22.06,20.16,17.81,16.94,15.56,12.41,10.25,11.38,13.78,14.97,15.53,18.03,21.31,22.62,22.28,23.09,25.5,26.59,25.28,24.0,25.31,26.34,25.81,25.84,28.66,32.0,33.38,33.34,34.25,36.16,36.56,34.44,32.69,32.28,30.22,25.62,21.34,19.47,18.19,15.25,12.34,12.06,13.41,13.5,12.44,13.0,15.5,16.94,17.12,18.75,23.06,27.12,28.81,29.91,33.12,36.44,37.22,36.72,37.53,38.19,36.38,32.34,28.94,27.41,24.91,20.62,17.34,16.81,17.0,15.59,14.47,16.06,18.81,20.06,20.97,24.19,29.0,32.91,34.75,36.44,39.75,41.5,40.91,40.03,41.19,41.84,40.09,36.75,35.22,34.66,32.06,28.59,26.47,25.88,24.72,21.62,19.56,19.75,19.78,17.25,14.5,13.28,12.94,10.53,7.84,8.25,10.91,12.88,13.31,15.56,19.59,22.88,23.84,25.19,28.0,29.72,28.78,26.88,26.59,27.22,25.72,23.75,23.69,25.5,26.25,25.06,24.69,25.25,24.97,21.41,18.12,17.69,17.69,16.88,16.28,18.22,21.44,22.19,21.22,20.75,21.78,20.84,18.12,16.81,17.38,18.0,16.12,14.41,14.72,15.5,15.0,14.16,15.88,19.84,22.38,23.56,25.62,28.5,29.28,26.97,25.12,25.12,25.22,22.78,19.72,18.5,17.56,14.66,10.84,9.59,10.19,10.56,9.75,10.41,13.62,15.84,15.25,15.25,17.25,19.78,19.84,19.94,21.97,24.88,25.66,25.53,27.16,30.62,33.06,32.84,32.75,33.69,32.94,29.31,25.97,24.62,24.56,22.88,21.25,22.25,24.66,25.16,23.88,23.28,23.5,23.09,20.75,19.97,22.34,25.25,25.81,26.09,28.19,29.91,29.09,26.44,24.94,24.34,22.12,17.75,14.88,14.19,13.31,11.09,10.31,12.25,14.94,15.62,15.88,18.12,21.16,22.19,21.66,22.47,24.41,25.16,23.66,23.0,24.66,25.81,24.81,23.91,25.19,25.97,24.09,21.81,20.94,21.16,20.12,18.38,17.81,18.97,19.0,16.5,14.88,15.75,16.62,15.72,14.97,16.53,18.72,18.66,17.03,17.88,20.28,21.28,21.41,22.72,25.56,26.41,23.91,20.69,19.34,17.91,14.47,11.28,10.69,11.69,10.94,9.12,8.75,9.78,8.62,6.12,4.91,6.53,8.81,10.0,12.16,17.0,22.5,25.0,26.41,28.88,31.56,31.0,28.75,26.91,26.47,24.28,20.53,17.28,16.38,15.38,12.38,10.0,10.16,11.97,11.81,11.12,12.59,15.62,16.84,16.38,16.78,18.94,19.47,17.44,15.78,15.75,15.84,13.72,11.19,11.62,13.5,13.88,14.19,15.88,18.91,19.69,17.94,16.16,16.31,15.53,13.22,11.88,13.38,15.5,15.38,14.47,15.38,17.06,16.44,14.72,14.53,16.38,16.94,15.91,15.31,17.06,17.66,15.53,12.38,11.38,11.16,8.97,6.62,7.09,9.34,10.28,9.59,10.44,13.22,14.66,14.0,13.97,16.62,19.03,19.41,19.25,21.53,24.62,25.44,24.94,25.5,26.78,25.56,22.25,19.88,20.03,19.94,17.75,16.31,17.25,17.94,16.5,14.25,14.78,16.22,16.38,15.62,17.0,19.75,21.34,21.0,21.22,23.5,40.78,40.91,41.28,40.97,40.62,40.75,42.22:16.38,18.06,17.84,16.41,16.44,17.41,16.31,13.16,11.22,11.75,11.69,9.84,8.94,10.22,11.25,10.16,8.16,8.09,8.75,7.72,6.0,6.0,7.75,8.47,7.16,6.28,7.72,8.31,7.06,6.09,7.88,10.0,10.56,10.12,11.5,13.19,13.19,11.59,10.72,11.03,10.66,8.78,7.78,9.28,11.44,11.53,11.06,12.12,13.31,12.47,10.5,10.12,11.72,12.12,10.88,9.88,10.62,10.09,7.75,5.72,6.66,8.72,9.09,9.31,11.38,13.62,13.22,9.72,6.75,4.72,2.0,-1.84,-3.38,-1.09,1.78,3.62,5.47,9.38,13.31,14.88,14.22,14.81,15.53,14.06,10.81,8.56,8.19,7.66,5.91,4.5,6.38,8.0,7.47,6.31,7.41,9.81,11.0,11.78,14.25,18.16,20.94,21.38,21.94,24.56,25.72,23.78,21.09,20.06,18.28,13.88,8.06,4.16,1.28,-2.78,-7.06,-8.72,-7.47,-5.66,-4.84,-2.47,2.38,6.72,8.12,8.31,9.94,10.81,9.41,6.47,5.28,5.19,3.84,0.72,-1.47,-2.56,-4.22,-8.44,-11.59,-11.53,-9.97,-9.5,-8.97,-5.28,-0.62,2.0,3.19,5.5,8.44,9.81,8.69,8.22,9.69,10.84,9.5,8.28,9.25,11.03,11.16,10.72,12.62,14.91,14.72,11.78,9.03,7.75,5.47,1.66,-0.72,-0.53,-0.12,-1.75,-2.88,-0.5,3.03,5.28,6.66,9.41,12.56,14.19,13.44,14.03,16.34,17.72,17.0,16.28,17.66,19.5,18.59,16.91,17.0,17.25,15.16,11.66,9.81,9.56,8.28,5.81,4.69,6.62,8.72,9.31,10.44,13.31,16.03,15.88,14.53,14.72,16.19,16.34,15.25,15.28,17.09,17.25,14.69,12.44,12.03,11.62,9.09,6.75,6.91,8.72,9.19,9.12,11.09,14.53,16.28,15.31,14.44,15.25,16.0,14.44,13.41,15.22,17.56,17.66,16.81,17.81,19.75,19.78,17.81,16.84,17.78,17.44,15.06,13.84,14.94,16.0,15.03,14.28,16.09,18.47,18.91,18.22,18.72,20.19,19.03,15.88,13.66,13.47,12.69,10.12,8.03,8.66,9.03,6.84,4.62,4.28,5.0,4.25,2.97,4.06,7.25,9.5,10.34,11.69,15.09,17.38,17.06,16.94,18.88,20.91,20.25,18.34,17.91,17.88,15.62,12.09,10.66,11.03,10.75,8.31,6.97,7.97,8.94,8.03,7.38,9.19,11.62,11.16,9.62,9.78,10.81,9.88,7.5,6.66,7.97,8.47,6.41,3.97,3.31,2.44,-0.59,-3.16,-2.06,1.16,2.69,3.88,6.72,10.88,13.19,13.53,13.88,16.0,16.41,14.19,11.75,11.91,11.97,9.47,5.81,4.69,4.25,2.75,0.56,-0.06,1.06,0.53,-2.22,-4.56,-4.28,-3.66,-4.28,-4.75,-1.88,1.62,3.16,4.0,7.19,11.19,12.62,12.25,12.0,12.53,11.69,8.19,5.16,4.91,4.97,3.84,2.97,4.91,7.5,7.84,7.03,7.47,9.34,9.59,8.19,7.31,8.84,9.44,7.97,6.38,7.31,8.25,7.06,5.44,6.31,8.53,8.88,8.03,8.22,9.84,9.97,8.03,6.78,8.22,9.66,8.84,8.06,9.44,10.81,10.06,8.19,8.38,9.84,9.78,8.25,8.56,11.53,13.53,13.69,13.97,16.06,17.03,15.06,12.12,11.28,11.38,10.44,8.38,8.47,10.0,10.34,8.72,7.97,10.12,11.69,11.31,11.75,14.47,16.88,16.62,15.44,15.62,17.09,16.94,15.59,16.22,17.91,18.41,16.75,15.69,16.59,17.16,15.47,13.53,14.31,15.59,15.75,14.41,15.12,16.88,17.25,15.88,15.38,17.03,18.12,16.78,15.78,17.12,18.28,17.16,15.34,15.78,17.22,17.06,16.09,17.16,19.81,21.0,20.44,20.84,23.25,24.28,22.84,20.44,19.66,19.06,16.75,14.03,13.94,14.75,14.62,13.19,13.5,15.31,16.16,14.84,13.97,15.38,16.5,14.81,13.25,13.78,14.97,14.62,13.53,14.66,16.28,16.09,13.41,12.0,11.78,10.91,8.38,6.94,8.0,9.53,8.94,8.06,9.72,11.78,12.47,12.06,13.78,17.06,19.5,19.97,20.94,23.5,24.5,22.44,19.75,19.34,19.03,17.0,14.97,15.19,17.12,17.31,16.34,16.22,17.44,17.88,15.88,14.91,16.34,17.59,17.12,16.41,18.09,20.66,21.28,20.97,22.28,24.34,24.72,23.0,22.09,22.88,22.88,20.47,19.25,20.44,22.22,22.19,22.09,24.25,26.88,27.38,26.53,26.72,27.72,27.97,26.09,25.31,26.25,26.91,24.62,22.16,22.09,22.19,20.06,18.25,18.47,19.47,19.47,18.28,18.31,19.97,20.62,19.44,19.06,21.0,23.09,23.16,23.0,24.41,26.19,25.28,23.59,23.28,24.47,24.78,23.84,24.44,27.28,29.47,28.81,28.31,29.75,31.09,30.0,28.81,30.03,31.97,32.16,30.94,30.53,30.97,29.47,25.97,24.25,25.0,25.81,25.44,24.88,26.34,28.12,27.16,25.31,24.94,25.41,23.62,20.56,18.5,17.66,16.22,13.66,12.38,14.72,18.31,20.28,22.09,25.84,29.25,29.81,29.09,29.31,30.81,30.66,28.81,27.78,28.31,27.53,24.47,21.69,21.06,20.84,18.91,17.16,18.0,19.97,20.72,20.41,21.38,23.56,24.31,23.19,22.75,24.28,25.25,23.53,21.06,20.41,19.56,16.56,13.44,12.56,14.03,14.44,13.56,14.31,17.25,18.78,18.56,19.56,22.97,25.56,25.97,25.69,26.78,28.03,27.41,25.44,25.06,25.59,24.47,21.41,18.84,18.75,17.91,15.78,14.31,15.81,18.34,19.28,20.56,24.03,28.03,29.59,28.78,27.88,27.25,24.84,20.31,16.47,14.97,13.59,10.78,8.56,9.62,11.69,12.25,12.25,13.69,15.88,16.22,15.38,15.72,18.16,19.78,19.5,19.78,22.69,25.41,26.03,25.81,26.72,27.47,25.31,22.19,20.44,20.88,21.12,20.53,21.88,25.19,27.06,25.25,22.47,21.12,19.44,15.84,12.97,12.78,14.78,15.81,16.06,17.97,20.91,22.06,20.16,17.81,16.94,15.56,12.41,10.25,11.38,13.78,14.97,15.53,18.03,21.31,22.62,22.28,23.09,25.5,26.59,25.28,24.0,25.31,26.34,25.81,25.84,28.66,32.0,33.38,33.34,34.25,36.16,36.56,34.44,32.69,32.28,30.22,25.62,21.34,19.47,18.19,15.25,12.34,12.06,13.41,13.5,12.44,13.0,15.5,16.94,17.12,18.75,23.06,27.12,28.81,29.91,33.12,36.44,37.22,36.72,37.53,38.19,36.38,32.34,28.94,27.41,24.91,20.62,17.34,16.81,17.0,15.59,14.47,16.06,18.81,20.06,20.97,24.19,29.0,32.91,34.75,36.44,39.75,41.5,40.91,40.03,41.19,41.84,40.09,36.75,35.22,34.66,32.06,28.59,26.47,25.88,24.72,21.62,19.56,19.75,19.78,17.25,14.5,13.28,12.94,10.53,7.84,8.25,10.91,12.88,13.31,15.56,19.59,22.88,23.84,25.19,28.0,29.72,28.78,26.88,26.59,27.22,25.72,23.75,23.69,25.5,26.25,25.06,24.69,25.25,24.97,21.41,18.12,17.69,17.69,16.88,16.28,18.22,21.44,22.19,21.22,20.75,21.78,20.84,18.12,16.81,17.38,18.0,16.12,14.41,14.72,15.5,15.0,14.16,15.88,19.84,22.38,23.56,25.62,28.5,29.28,26.97,25.12,25.12,25.22,22.78,19.72,18.5,17.56,14.66,10.84,9.59,10.19,10.56,9.75,10.41,13.62,15.84,15.25,15.25,17.25,19.78,19.84,19.94,21.97,24.88,25.66,25.53,27.16,30.62,33.06,32.84,32.75,33.69,32.94,29.31,25.97,24.62,24.56,22.88,21.25,22.25,24.66,25.16,23.88,23.28,23.5,23.09,20.75,19.97,22.34,25.25,25.81,26.09,28.19,29.91,29.09,26.44,24.94,24.34,22.12,17.75,14.88,14.19,13.31,11.09,10.31,12.25,14.94,15.62,15.88,18.12,21.16,22.19,21.66,22.47,24.41,25.16,23.66,23.0,24.66,25.81,24.81,23.91,25.19,25.97,24.09,21.81,20.94,21.16,20.12,18.38,17.81,18.97,19.0,16.5,14.88,15.75,16.62,15.72,14.97,16.53,18.72,18.66,17.03,17.88,20.28,21.28,21.41,22.72,25.56,26.41,23.91,20.69,19.34,17.91,14.47,11.28,10.69,11.69,10.94,9.12,8.75,9.78,8.62,6.12,4.91,6.53,8.81,10.0,12.16,17.0,22.5,25.0,26.41,28.88,31.56,31.0,28.75,26.91,26.47,24.28,20.53,17.28,16.38,15.38,12.38,10.0,10.16,11.97,11.81,11.12,12.59,15.62,16.84,16.38,16.78,18.94,19.47,17.44,15.78,15.75,15.84,13.72,11.19,11.62,13.5,13.88,14.19,15.88,18.91,19.69,17.94,16.16,16.31,15.53,13.22,11.88,13.38,15.5,15.38,14.47,15.38,17.06,16.44,14.72,14.53,16.38,16.94,15.91,15.31,17.06,17.66,15.53,12.38,11.38,11.16,8.97,6.62,7.09,9.34,10.28,9.59,10.44,13.22,14.66,14.0,13.97,16.62,19.03,19.41,19.25,21.53,24.62,25.44,24.94,25.5,26.78,25.56,22.25,19.88,20.03,19.94,17.75,16.31,17.25,17.94,16.5,14.25,14.78,16.22,16.38,15.62,17.0,19.75,21.34,21.0,21.22,23.5,40.78,40.91,41.28,40.97,40.62,40.75,42.22,42.53,41.59,41.31,42.12,42.75,41.97,41.19:13.16,11.22,11.75,11.69,9.84,8.94,10.22,11.25,10.16,8.16,8.09,8.75,7.72,6.0,6.0,7.75,8.47,7.16,6.28,7.72,8.31,7.06,6.09,7.88,10.0,10.56,10.12,11.5,13.19,13.19,11.59,10.72,11.03,10.66,8.78,7.78,9.28,11.44,11.53,11.06,12.12,13.31,12.47,10.5,10.12,11.72,12.12,10.88,9.88,10.62,10.09,7.75,5.72,6.66,8.72,9.09,9.31,11.38,13.62,13.22,9.72,6.75,4.72,2.0,-1.84,-3.38,-1.09,1.78,3.62,5.47,9.38,13.31,14.88,14.22,14.81,15.53,14.06,10.81,8.56,8.19,7.66,5.91,4.5,6.38,8.0,7.47,6.31,7.41,9.81,11.0,11.78,14.25,18.16,20.94,21.38,21.94,24.56,25.72,23.78,21.09,20.06,18.28,13.88,8.06,4.16,1.28,-2.78,-7.06,-8.72,-7.47,-5.66,-4.84,-2.47,2.38,6.72,8.12,8.31,9.94,10.81,9.41,6.47,5.28,5.19,3.84,0.72,-1.47,-2.56,-4.22,-8.44,-11.59,-11.53,-9.97,-9.5,-8.97,-5.28,-0.62,2.0,3.19,5.5,8.44,9.81,8.69,8.22,9.69,10.84,9.5,8.28,9.25,11.03,11.16,10.72,12.62,14.91,14.72,11.78,9.03,7.75,5.47,1.66,-0.72,-0.53,-0.12,-1.75,-2.88,-0.5,3.03,5.28,6.66,9.41,12.56,14.19,13.44,14.03,16.34,17.72,17.0,16.28,17.66,19.5,18.59,16.91,17.0,17.25,15.16,11.66,9.81,9.56,8.28,5.81,4.69,6.62,8.72,9.31,10.44,13.31,16.03,15.88,14.53,14.72,16.19,16.34,15.25,15.28,17.09,17.25,14.69,12.44,12.03,11.62,9.09,6.75,6.91,8.72,9.19,9.12,11.09,14.53,16.28,15.31,14.44,15.25,16.0,14.44,13.41,15.22,17.56,17.66,16.81,17.81,19.75,19.78,17.81,16.84,17.78,17.44,15.06,13.84,14.94,16.0,15.03,14.28,16.09,18.47,18.91,18.22,18.72,20.19,19.03,15.88,13.66,13.47,12.69,10.12,8.03,8.66,9.03,6.84,4.62,4.28,5.0,4.25,2.97,4.06,7.25,9.5,10.34,11.69,15.09,17.38,17.06,16.94,18.88,20.91,20.25,18.34,17.91,17.88,15.62,12.09,10.66,11.03,10.75,8.31,6.97,7.97,8.94,8.03,7.38,9.19,11.62,11.16,9.62,9.78,10.81,9.88,7.5,6.66,7.97,8.47,6.41,3.97,3.31,2.44,-0.59,-3.16,-2.06,1.16,2.69,3.88,6.72,10.88,13.19,13.53,13.88,16.0,16.41,14.19,11.75,11.91,11.97,9.47,5.81,4.69,4.25,2.75,0.56,-0.06,1.06,0.53,-2.22,-4.56,-4.28,-3.66,-4.28,-4.75,-1.88,1.62,3.16,4.0,7.19,11.19,12.62,12.25,12.0,12.53,11.69,8.19,5.16,4.91,4.97,3.84,2.97,4.91,7.5,7.84,7.03,7.47,9.34,9.59,8.19,7.31,8.84,9.44,7.97,6.38,7.31,8.25,7.06,5.44,6.31,8.53,8.88,8.03,8.22,9.84,9.97,8.03,6.78,8.22,9.66,8.84,8.06,9.44,10.81,10.06,8.19,8.38,9.84,9.78,8.25,8.56,11.53,13.53,13.69,13.97,16.06,17.03,15.06,12.12,11.28,11.38,10.44,8.38,8.47,10.0,10.34,8.72,7.97,10.12,11.69,11.31,11.75,14.47,16.88,16.62,15.44,15.62,17.09,16.94,15.59,16.22,17.91,18.41,16.75,15.69,16.59,17.16,15.47,13.53,14.31,15.59,15.75,14.41,15.12,16.88,17.25,15.88,15.38,17.03,18.12,16.78,15.78,17.12,18.28,17.16,15.34,15.78,17.22,17.06,16.09,17.16,19.81,21.0,20.44,20.84,23.25,24.28,22.84,20.44,19.66,19.06,16.75,14.03,13.94,14.75,14.62,13.19,13.5,15.31,16.16,14.84,13.97,15.38,16.5,14.81,13.25,13.78,14.97,14.62,13.53,14.66,16.28,16.09,13.41,12.0,11.78,10.91,8.38,6.94,8.0,9.53,8.94,8.06,9.72,11.78,12.47,12.06,13.78,17.06,19.5,19.97,20.94,23.5,24.5,22.44,19.75,19.34,19.03,17.0,14.97,15.19,17.12,17.31,16.34,16.22,17.44,17.88,15.88,14.91,16.34,17.59,17.12,16.41,18.09,20.66,21.28,20.97,22.28,24.34,24.72,23.0,22.09,22.88,22.88,20.47,19.25,20.44,22.22,22.19,22.09,24.25,26.88,27.38,26.53,26.72,27.72,27.97,26.09,25.31,26.25,26.91,24.62,22.16,22.09,22.19,20.06,18.25,18.47,19.47,19.47,18.28,18.31,19.97,20.62,19.44,19.06,21.0,23.09,23.16,23.0,24.41,26.19,25.28,23.59,23.28,24.47,24.78,23.84,24.44,27.28,29.47,28.81,28.31,29.75,31.09,30.0,28.81,30.03,31.97,32.16,30.94,30.53,30.97,29.47,25.97,24.25,25.0,25.81,25.44,24.88,26.34,28.12,27.16,25.31,24.94,25.41,23.62,20.56,18.5,17.66,16.22,13.66,12.38,14.72,18.31,20.28,22.09,25.84,29.25,29.81,29.09,29.31,30.81,30.66,28.81,27.78,28.31,27.53,24.47,21.69,21.06,20.84,18.91,17.16,18.0,19.97,20.72,20.41,21.38,23.56,24.31,23.19,22.75,24.28,25.25,23.53,21.06,20.41,19.56,16.56,13.44,12.56,14.03,14.44,13.56,14.31,17.25,18.78,18.56,19.56,22.97,25.56,25.97,25.69,26.78,28.03,27.41,25.44,25.06,25.59,24.47,21.41,18.84,18.75,17.91,15.78,14.31,15.81,18.34,19.28,20.56,24.03,28.03,29.59,28.78,27.88,27.25,24.84,20.31,16.47,14.97,13.59,10.78,8.56,9.62,11.69,12.25,12.25,13.69,15.88,16.22,15.38,15.72,18.16,19.78,19.5,19.78,22.69,25.41,26.03,25.81,26.72,27.47,25.31,22.19,20.44,20.88,21.12,20.53,21.88,25.19,27.06,25.25,22.47,21.12,19.44,15.84,12.97,12.78,14.78,15.81,16.06,17.97,20.91,22.06,20.16,17.81,16.94,15.56,12.41,10.25,11.38,13.78,14.97,15.53,18.03,21.31,22.62,22.28,23.09,25.5,26.59,25.28,24.0,25.31,26.34,25.81,25.84,28.66,32.0,33.38,33.34,34.25,36.16,36.56,34.44,32.69,32.28,30.22,25.62,21.34,19.47,18.19,15.25,12.34,12.06,13.41,13.5,12.44,13.0,15.5,16.94,17.12,18.75,23.06,27.12,28.81,29.91,33.12,36.44,37.22,36.72,37.53,38.19,36.38,32.34,28.94,27.41,24.91,20.62,17.34,16.81,17.0,15.59,14.47,16.06,18.81,20.06,20.97,24.19,29.0,32.91,34.75,36.44,39.75,41.5,40.91,40.03,41.19,41.84,40.09,36.75,35.22,34.66,32.06,28.59,26.47,25.88,24.72,21.62,19.56,19.75,19.78,17.25,14.5,13.28,12.94,10.53,7.84,8.25,10.91,12.88,13.31,15.56,19.59,22.88,23.84,25.19,28.0,29.72,28.78,26.88,26.59,27.22,25.72,23.75,23.69,25.5,26.25,25.06,24.69,25.25,24.97,21.41,18.12,17.69,17.69,16.88,16.28,18.22,21.44,22.19,21.22,20.75,21.78,20.84,18.12,16.81,17.38,18.0,16.12,14.41,14.72,15.5,15.0,14.16,15.88,19.84,22.38,23.56,25.62,28.5,29.28,26.97,25.12,25.12,25.22,22.78,19.72,18.5,17.56,14.66,10.84,9.59,10.19,10.56,9.75,10.41,13.62,15.84,15.25,15.25,17.25,19.78,19.84,19.94,21.97,24.88,25.66,25.53,27.16,30.62,33.06,32.84,32.75,33.69,32.94,29.31,25.97,24.62,24.56,22.88,21.25,22.25,24.66,25.16,23.88,23.28,23.5,23.09,20.75,19.97,22.34,25.25,25.81,26.09,28.19,29.91,29.09,26.44,24.94,24.34,22.12,17.75,14.88,14.19,13.31,11.09,10.31,12.25,14.94,15.62,15.88,18.12,21.16,22.19,21.66,22.47,24.41,25.16,23.66,23.0,24.66,25.81,24.81,23.91,25.19,25.97,24.09,21.81,20.94,21.16,20.12,18.38,17.81,18.97,19.0,16.5,14.88,15.75,16.62,15.72,14.97,16.53,18.72,18.66,17.03,17.88,20.28,21.28,21.41,22.72,25.56,26.41,23.91,20.69,19.34,17.91,14.47,11.28,10.69,11.69,10.94,9.12,8.75,9.78,8.62,6.12,4.91,6.53,8.81,10.0,12.16,17.0,22.5,25.0,26.41,28.88,31.56,31.0,28.75,26.91,26.47,24.28,20.53,17.28,16.38,15.38,12.38,10.0,10.16,11.97,11.81,11.12,12.59,15.62,16.84,16.38,16.78,18.94,19.47,17.44,15.78,15.75,15.84,13.72,11.19,11.62,13.5,13.88,14.19,15.88,18.91,19.69,17.94,16.16,16.31,15.53,13.22,11.88,13.38,15.5,15.38,14.47,15.38,17.06,16.44,14.72,14.53,16.38,16.94,15.91,15.31,17.06,17.66,15.53,12.38,11.38,11.16,8.97,6.62,7.09,9.34,10.28,9.59,10.44,13.22,14.66,14.0,13.97,16.62,19.03,19.41,19.25,21.53,24.62,25.44,24.94,25.5,26.78,25.56,22.25,19.88,20.03,19.94,17.75,16.31,17.25,17.94,16.5,14.25,14.78,16.22,16.38,15.62,17.0,19.75,21.34,21.0,21.22,23.5,40.78,40.91,41.28,40.97,40.62,40.75,42.22,42.53,41.59,41.31,42.12,42.75,41.97,41.19,41.06,41.0,39.81,38.16,37.94,38.22,37.56:11.25,10.16,8.16,8.09,8.75,7.72,6.0,6.0,7.75,8.47,7.16,6.28,7.72,8.31,7.06,6.09,7.88,10.0,10.56,10.12,11.5,13.19,13.19,11.59,10.72,11.03,10.66,8.78,7.78,9.28,11.44,11.53,11.06,12.12,13.31,12.47,10.5,10.12,11.72,12.12,10.88,9.88,10.62,10.09,7.75,5.72,6.66,8.72,9.09,9.31,11.38,13.62,13.22,9.72,6.75,4.72,2.0,-1.84,-3.38,-1.09,1.78,3.62,5.47,9.38,13.31,14.88,14.22,14.81,15.53,14.06,10.81,8.56,8.19,7.66,5.91,4.5,6.38,8.0,7.47,6.31,7.41,9.81,11.0,11.78,14.25,18.16,20.94,21.38,21.94,24.56,25.72,23.78,21.09,20.06,18.28,13.88,8.06,4.16,1.28,-2.78,-7.06,-8.72,-7.47,-5.66,-4.84,-2.47,2.38,6.72,8.12,8.31,9.94,10.81,9.41,6.47,5.28,5.19,3.84,0.72,-1.47,-2.56,-4.22,-8.44,-11.59,-11.53,-9.97,-9.5,-8.97,-5.28,-0.62,2.0,3.19,5.5,8.44,9.81,8.69,8.22,9.69,10.84,9.5,8.28,9.25,11.03,11.16,10.72,12.62,14.91,14.72,11.78,9.03,7.75,5.47,1.66,-0.72,-0.53,-0.12,-1.75,-2.88,-0.5,3.03,5.28,6.66,9.41,12.56,14.19,13.44,14.03,16.34,17.72,17.0,16.28,17.66,19.5,18.59,16.91,17.0,17.25,15.16,11.66,9.81,9.56,8.28,5.81,4.69,6.62,8.72,9.31,10.44,13.31,16.03,15.88,14.53,14.72,16.19,16.34,15.25,15.28,17.09,17.25,14.69,12.44,12.03,11.62,9.09,6.75,6.91,8.72,9.19,9.12,11.09,14.53,16.28,15.31,14.44,15.25,16.0,14.44,13.41,15.22,17.56,17.66,16.81,17.81,19.75,19.78,17.81,16.84,17.78,17.44,15.06,13.84,14.94,16.0,15.03,14.28,16.09,18.47,18.91,18.22,18.72,20.19,19.03,15.88,13.66,13.47,12.69,10.12,8.03,8.66,9.03,6.84,4.62,4.28,5.0,4.25,2.97,4.06,7.25,9.5,10.34,11.69,15.09,17.38,17.06,16.94,18.88,20.91,20.25,18.34,17.91,17.88,15.62,12.09,10.66,11.03,10.75,8.31,6.97,7.97,8.94,8.03,7.38,9.19,11.62,11.16,9.62,9.78,10.81,9.88,7.5,6.66,7.97,8.47,6.41,3.97,3.31,2.44,-0.59,-3.16,-2.06,1.16,2.69,3.88,6.72,10.88,13.19,13.53,13.88,16.0,16.41,14.19,11.75,11.91,11.97,9.47,5.81,4.69,4.25,2.75,0.56,-0.06,1.06,0.53,-2.22,-4.56,-4.28,-3.66,-4.28,-4.75,-1.88,1.62,3.16,4.0,7.19,11.19,12.62,12.25,12.0,12.53,11.69,8.19,5.16,4.91,4.97,3.84,2.97,4.91,7.5,7.84,7.03,7.47,9.34,9.59,8.19,7.31,8.84,9.44,7.97,6.38,7.31,8.25,7.06,5.44,6.31,8.53,8.88,8.03,8.22,9.84,9.97,8.03,6.78,8.22,9.66,8.84,8.06,9.44,10.81,10.06,8.19,8.38,9.84,9.78,8.25,8.56,11.53,13.53,13.69,13.97,16.06,17.03,15.06,12.12,11.28,11.38,10.44,8.38,8.47,10.0,10.34,8.72,7.97,10.12,11.69,11.31,11.75,14.47,16.88,16.62,15.44,15.62,17.09,16.94,15.59,16.22,17.91,18.41,16.75,15.69,16.59,17.16,15.47,13.53,14.31,15.59,15.75,14.41,15.12,16.88,17.25,15.88,15.38,17.03,18.12,16.78,15.78,17.12,18.28,17.16,15.34,15.78,17.22,17.06,16.09,17.16,19.81,21.0,20.44,20.84,23.25,24.28,22.84,20.44,19.66,19.06,16.75,14.03,13.94,14.75,14.62,13.19,13.5,15.31,16.16,14.84,13.97,15.38,16.5,14.81,13.25,13.78,14.97,14.62,13.53,14.66,16.28,16.09,13.41,12.0,11.78,10.91,8.38,6.94,8.0,9.53,8.94,8.06,9.72,11.78,12.47,12.06,13.78,17.06,19.5,19.97,20.94,23.5,24.5,22.44,19.75,19.34,19.03,17.0,14.97,15.19,17.12,17.31,16.34,16.22,17.44,17.88,15.88,14.91,16.34,17.59,17.12,16.41,18.09,20.66,21.28,20.97,22.28,24.34,24.72,23.0,22.09,22.88,22.88,20.47,19.25,20.44,22.22,22.19,22.09,24.25,26.88,27.38,26.53,26.72,27.72,27.97,26.09,25.31,26.25,26.91,24.62,22.16,22.09,22.19,20.06,18.25,18.47,19.47,19.47,18.28,18.31,19.97,20.62,19.44,19.06,21.0,23.09,23.16,23.0,24.41,26.19,25.28,23.59,23.28,24.47,24.78,23.84,24.44,27.28,29.47,28.81,28.31,29.75,31.09,30.0,28.81,30.03,31.97,32.16,30.94,30.53,30.97,29.47,25.97,24.25,25.0,25.81,25.44,24.88,26.34,28.12,27.16,25.31,24.94,25.41,23.62,20.56,18.5,17.66,16.22,13.66,12.38,14.72,18.31,20.28,22.09,25.84,29.25,29.81,29.09,29.31,30.81,30.66,28.81,27.78,28.31,27.53,24.47,21.69,21.06,20.84,18.91,17.16,18.0,19.97,20.72,20.41,21.38,23.56,24.31,23.19,22.75,24.28,25.25,23.53,21.06,20.41,19.56,16.56,13.44,12.56,14.03,14.44,13.56,14.31,17.25,18.78,18.56,19.56,22.97,25.56,25.97,25.69,26.78,28.03,27.41,25.44,25.06,25.59,24.47,21.41,18.84,18.75,17.91,15.78,14.31,15.81,18.34,19.28,20.56,24.03,28.03,29.59,28.78,27.88,27.25,24.84,20.31,16.47,14.97,13.59,10.78,8.56,9.62,11.69,12.25,12.25,13.69,15.88,16.22,15.38,15.72,18.16,19.78,19.5,19.78,22.69,25.41,26.03,25.81,26.72,27.47,25.31,22.19,20.44,20.88,21.12,20.53,21.88,25.19,27.06,25.25,22.47,21.12,19.44,15.84,12.97,12.78,14.78,15.81,16.06,17.97,20.91,22.06,20.16,17.81,16.94,15.56,12.41,10.25,11.38,13.78,14.97,15.53,18.03,21.31,22.62,22.28,23.09,25.5,26.59,25.28,24.0,25.31,26.34,25.81,25.84,28.66,32.0,33.38,33.34,34.25,36.16,36.56,34.44,32.69,32.28,30.22,25.62,21.34,19.47,18.19,15.25,12.34,12.06,13.41,13.5,12.44,13.0,15.5,16.94,17.12,18.75,23.06,27.12,28.81,29.91,33.12,36.44,37.22,36.72,37.53,38.19,36.38,32.34,28.94,27.41,24.91,20.62,17.34,16.81,17.0,15.59,14.47,16.06,18.81,20.06,20.97,24.19,29.0,32.91,34.75,36.44,39.75,41.5,40.91,40.03,41.19,41.84,40.09,36.75,35.22,34.66,32.06,28.59,26.47,25.88,24.72,21.62,19.56,19.75,19.78,17.25,14.5,13.28,12.94,10.53,7.84,8.25,10.91,12.88,13.31,15.56,19.59,22.88,23.84,25.19,28.0,29.72,28.78,26.88,26.59,27.22,25.72,23.75,23.69,25.5,26.25,25.06,24.69,25.25,24.97,21.41,18.12,17.69,17.69,16.88,16.28,18.22,21.44,22.19,21.22,20.75,21.78,20.84,18.12,16.81,17.38,18.0,16.12,14.41,14.72,15.5,15.0,14.16,15.88,19.84,22.38,23.56,25.62,28.5,29.28,26.97,25.12,25.12,25.22,22.78,19.72,18.5,17.56,14.66,10.84,9.59,10.19,10.56,9.75,10.41,13.62,15.84,15.25,15.25,17.25,19.78,19.84,19.94,21.97,24.88,25.66,25.53,27.16,30.62,33.06,32.84,32.75,33.69,32.94,29.31,25.97,24.62,24.56,22.88,21.25,22.25,24.66,25.16,23.88,23.28,23.5,23.09,20.75,19.97,22.34,25.25,25.81,26.09,28.19,29.91,29.09,26.44,24.94,24.34,22.12,17.75,14.88,14.19,13.31,11.09,10.31,12.25,14.94,15.62,15.88,18.12,21.16,22.19,21.66,22.47,24.41,25.16,23.66,23.0,24.66,25.81,24.81,23.91,25.19,25.97,24.09,21.81,20.94,21.16,20.12,18.38,17.81,18.97,19.0,16.5,14.88,15.75,16.62,15.72,14.97,16.53,18.72,18.66,17.03,17.88,20.28,21.28,21.41,22.72,25.56,26.41,23.91,20.69,19.34,17.91,14.47,11.28,10.69,11.69,10.94,9.12,8.75,9.78,8.62,6.12,4.91,6.53,8.81,10.0,12.16,17.0,22.5,25.0,26.41,28.88,31.56,31.0,28.75,26.91,26.47,24.28,20.53,17.28,16.38,15.38,12.38,10.0,10.16,11.97,11.81,11.12,12.59,15.62,16.84,16.38,16.78,18.94,19.47,17.44,15.78,15.75,15.84,13.72,11.19,11.62,13.5,13.88,14.19,15.88,18.91,19.69,17.94,16.16,16.31,15.53,13.22,11.88,13.38,15.5,15.38,14.47,15.38,17.06,16.44,14.72,14.53,16.38,16.94,15.91,15.31,17.06,17.66,15.53,12.38,11.38,11.16,8.97,6.62,7.09,9.34,10.28,9.59,10.44,13.22,14.66,14.0,13.97,16.62,19.03,19.41,19.25,21.53,24.62,25.44,24.94,25.5,26.78,25.56,22.25,19.88,20.03,19.94,17.75,16.31,17.25,17.94,16.5,14.25,14.78,16.22,16.38,15.62,17.0,19.75,21.34,21.0,21.22,23.5,40.78,40.91,41.28,40.97,40.62,40.75,42.22,42.53,41.59,41.31,42.12,42.75,41.97,41.19,41.06,41.0,39.81,38.16,37.94,38.22,37.56,36.0,35.41,36.84,37.66,37.66,38.22,40.06:6.0,7.75,8.47,7.16,6.28,7.72,8.31,7.06,6.09,7.88,10.0,10.56,10.12,11.5,13.19,13.19,11.59,10.72,11.03,10.66,8.78,7.78,9.28,11.44,11.53,11.06,12.12,13.31,12.47,10.5,10.12,11.72,12.12,10.88,9.88,10.62,10.09,7.75,5.72,6.66,8.72,9.09,9.31,11.38,13.62,13.22,9.72,6.75,4.72,2.0,-1.84,-3.38,-1.09,1.78,3.62,5.47,9.38,13.31,14.88,14.22,14.81,15.53,14.06,10.81,8.56,8.19,7.66,5.91,4.5,6.38,8.0,7.47,6.31,7.41,9.81,11.0,11.78,14.25,18.16,20.94,21.38,21.94,24.56,25.72,23.78,21.09,20.06,18.28,13.88,8.06,4.16,1.28,-2.78,-7.06,-8.72,-7.47,-5.66,-4.84,-2.47,2.38,6.72,8.12,8.31,9.94,10.81,9.41,6.47,5.28,5.19,3.84,0.72,-1.47,-2.56,-4.22,-8.44,-11.59,-11.53,-9.97,-9.5,-8.97,-5.28,-0.62,2.0,3.19,5.5,8.44,9.81,8.69,8.22,9.69,10.84,9.5,8.28,9.25,11.03,11.16,10.72,12.62,14.91,14.72,11.78,9.03,7.75,5.47,1.66,-0.72,-0.53,-0.12,-1.75,-2.88,-0.5,3.03,5.28,6.66,9.41,12.56,14.19,13.44,14.03,16.34,17.72,17.0,16.28,17.66,19.5,18.59,16.91,17.0,17.25,15.16,11.66,9.81,9.56,8.28,5.81,4.69,6.62,8.72,9.31,10.44,13.31,16.03,15.88,14.53,14.72,16.19,16.34,15.25,15.28,17.09,17.25,14.69,12.44,12.03,11.62,9.09,6.75,6.91,8.72,9.19,9.12,11.09,14.53,16.28,15.31,14.44,15.25,16.0,14.44,13.41,15.22,17.56,17.66,16.81,17.81,19.75,19.78,17.81,16.84,17.78,17.44,15.06,13.84,14.94,16.0,15.03,14.28,16.09,18.47,18.91,18.22,18.72,20.19,19.03,15.88,13.66,13.47,12.69,10.12,8.03,8.66,9.03,6.84,4.62,4.28,5.0,4.25,2.97,4.06,7.25,9.5,10.34,11.69,15.09,17.38,17.06,16.94,18.88,20.91,20.25,18.34,17.91,17.88,15.62,12.09,10.66,11.03,10.75,8.31,6.97,7.97,8.94,8.03,7.38,9.19,11.62,11.16,9.62,9.78,10.81,9.88,7.5,6.66,7.97,8.47,6.41,3.97,3.31,2.44,-0.59,-3.16,-2.06,1.16,2.69,3.88,6.72,10.88,13.19,13.53,13.88,16.0,16.41,14.19,11.75,11.91,11.97,9.47,5.81,4.69,4.25,2.75,0.56,-0.06,1.06,0.53,-2.22,-4.56,-4.28,-3.66,-4.28,-4.75,-1.88,1.62,3.16,4.0,7.19,11.19,12.62,12.25,12.0,12.53,11.69,8.19,5.16,4.91,4.97,3.84,2.97,4.91,7.5,7.84,7.03,7.47,9.34,9.59,8.19,7.31,8.84,9.44,7.97,6.38,7.31,8.25,7.06,5.44,6.31,8.53,8.88,8.03,8.22,9.84,9.97,8.03,6.78,8.22,9.66,8.84,8.06,9.44,10.81,10.06,8.19,8.38,9.84,9.78,8.25,8.56,11.53,13.53,13.69,13.97,16.06,17.03,15.06,12.12,11.28,11.38,10.44,8.38,8.47,10.0,10.34,8.72,7.97,10.12,11.69,11.31,11.75,14.47,16.88,16.62,15.44,15.62,17.09,16.94,15.59,16.22,17.91,18.41,16.75,15.69,16.59,17.16,15.47,13.53,14.31,15.59,15.75,14.41,15.12,16.88,17.25,15.88,15.38,17.03,18.12,16.78,15.78,17.12,18.28,17.16,15.34,15.78,17.22,17.06,16.09,17.16,19.81,21.0,20.44,20.84,23.25,24.28,22.84,20.44,19.66,19.06,16.75,14.03,13.94,14.75,14.62,13.19,13.5,15.31,16.16,14.84,13.97,15.38,16.5,14.81,13.25,13.78,14.97,14.62,13.53,14.66,16.28,16.09,13.41,12.0,11.78,10.91,8.38,6.94,8.0,9.53,8.94,8.06,9.72,11.78,12.47,12.06,13.78,17.06,19.5,19.97,20.94,23.5,24.5,22.44,19.75,19.34,19.03,17.0,14.97,15.19,17.12,17.31,16.34,16.22,17.44,17.88,15.88,14.91,16.34,17.59,17.12,16.41,18.09,20.66,21.28,20.97,22.28,24.34,24.72,23.0,22.09,22.88,22.88,20.47,19.25,20.44,22.22,22.19,22.09,24.25,26.88,27.38,26.53,26.72,27.72,27.97,26.09,25.31,26.25,26.91,24.62,22.16,22.09,22.19,20.06,18.25,18.47,19.47,19.47,18.28,18.31,19.97,20.62,19.44,19.06,21.0,23.09,23.16,23.0,24.41,26.19,25.28,23.59,23.28,24.47,24.78,23.84,24.44,27.28,29.47,28.81,28.31,29.75,31.09,30.0,28.81,30.03,31.97,32.16,30.94,30.53,30.97,29.47,25.97,24.25,25.0,25.81,25.44,24.88,26.34,28.12,27.16,25.31,24.94,25.41,23.62,20.56,18.5,17.66,16.22,13.66,12.38,14.72,18.31,20.28,22.09,25.84,29.25,29.81,29.09,29.31,30.81,30.66,28.81,27.78,28.31,27.53,24.47,21.69,21.06,20.84,18.91,17.16,18.0,19.97,20.72,20.41,21.38,23.56,24.31,23.19,22.75,24.28,25.25,23.53,21.06,20.41,19.56,16.56,13.44,12.56,14.03,14.44,13.56,14.31,17.25,18.78,18.56,19.56,22.97,25.56,25.97,25.69,26.78,28.03,27.41,25.44,25.06,25.59,24.47,21.41,18.84,18.75,17.91,15.78,14.31,15.81,18.34,19.28,20.56,24.03,28.03,29.59,28.78,27.88,27.25,24.84,20.31,16.47,14.97,13.59,10.78,8.56,9.62,11.69,12.25,12.25,13.69,15.88,16.22,15.38,15.72,18.16,19.78,19.5,19.78,22.69,25.41,26.03,25.81,26.72,27.47,25.31,22.19,20.44,20.88,21.12,20.53,21.88,25.19,27.06,25.25,22.47,21.12,19.44,15.84,12.97,12.78,14.78,15.81,16.06,17.97,20.91,22.06,20.16,17.81,16.94,15.56,12.41,10.25,11.38,13.78,14.97,15.53,18.03,21.31,22.62,22.28,23.09,25.5,26.59,25.28,24.0,25.31,26.34,25.81,25.84,28.66,32.0,33.38,33.34,34.25,36.16,36.56,34.44,32.69,32.28,30.22,25.62,21.34,19.47,18.19,15.25,12.34,12.06,13.41,13.5,12.44,13.0,15.5,16.94,17.12,18.75,23.06,27.12,28.81,29.91,33.12,36.44,37.22,36.72,37.53,38.19,36.38,32.34,28.94,27.41,24.91,20.62,17.34,16.81,17.0,15.59,14.47,16.06,18.81,20.06,20.97,24.19,29.0,32.91,34.75,36.44,39.75,41.5,40.91,40.03,41.19,41.84,40.09,36.75,35.22,34.66,32.06,28.59,26.47,25.88,24.72,21.62,19.56,19.75,19.78,17.25,14.5,13.28,12.94,10.53,7.84,8.25,10.91,12.88,13.31,15.56,19.59,22.88,23.84,25.19,28.0,29.72,28.78,26.88,26.59,27.22,25.72,23.75,23.69,25.5,26.25,25.06,24.69,25.25,24.97,21.41,18.12,17.69,17.69,16.88,16.28,18.22,21.44,22.19,21.22,20.75,21.78,20.84,18.12,16.81,17.38,18.0,16.12,14.41,14.72,15.5,15.0,14.16,15.88,19.84,22.38,23.56,25.62,28.5,29.28,26.97,25.12,25.12,25.22,22.78,19.72,18.5,17.56,14.66,10.84,9.59,10.19,10.56,9.75,10.41,13.62,15.84,15.25,15.25,17.25,19.78,19.84,19.94,21.97,24.88,25.66,25.53,27.16,30.62,33.06,32.84,32.75,33.69,32.94,29.31,25.97,24.62,24.56,22.88,21.25,22.25,24.66,25.16,23.88,23.28,23.5,23.09,20.75,19.97,22.34,25.25,25.81,26.09,28.19,29.91,29.09,26.44,24.94,24.34,22.12,17.75,14.88,14.19,13.31,11.09,10.31,12.25,14.94,15.62,15.88,18.12,21.16,22.19,21.66,22.47,24.41,25.16,23.66,23.0,24.66,25.81,24.81,23.91,25.19,25.97,24.09,21.81,20.94,21.16,20.12,18.38,17.81,18.97,19.0,16.5,14.88,15.75,16.62,15.72,14.97,16.53,18.72,18.66,17.03,17.88,20.28,21.28,21.41,22.72,25.56,26.41,23.91,20.69,19.34,17.91,14.47,11.28,10.69,11.69,10.94,9.12,8.75,9.78,8.62,6.12,4.91,6.53,8.81,10.0,12.16,17.0,22.5,25.0,26.41,28.88,31.56,31.0,28.75,26.91,26.47,24.28,20.53,17.28,16.38,15.38,12.38,10.0,10.16,11.97,11.81,11.12,12.59,15.62,16.84,16.38,16.78,18.94,19.47,17.44,15.78,15.75,15.84,13.72,11.19,11.62,13.5,13.88,14.19,15.88,18.91,19.69,17.94,16.16,16.31,15.53,13.22,11.88,13.38,15.5,15.38,14.47,15.38,17.06,16.44,14.72,14.53,16.38,16.94,15.91,15.31,17.06,17.66,15.53,12.38,11.38,11.16,8.97,6.62,7.09,9.34,10.28,9.59,10.44,13.22,14.66,14.0,13.97,16.62,19.03,19.41,19.25,21.53,24.62,25.44,24.94,25.5,26.78,25.56,22.25,19.88,20.03,19.94,17.75,16.31,17.25,17.94,16.5,14.25,14.78,16.22,16.38,15.62,17.0,19.75,21.34,21.0,21.22,23.5,40.78,40.91,41.28,40.97,40.62,40.75,42.22,42.53,41.59,41.31,42.12,42.75,41.97,41.19,41.06,41.0,39.81,38.16,37.94,38.22,37.56,36.0,35.41,36.84,37.66,37.66,38.22,40.06,40.84,39.66,38.34,37.47,36.81,34.62,32.59:7.06,6.09,7.88,10.0,10.56,10.12,11.5,13.19,13.19,11.59,10.72,11.03,10.66,8.78,7.78,9.28,11.44,11.53,11.06,12.12,13.31,12.47,10.5,10.12,11.72,12.12,10.88,9.88,10.62,10.09,7.75,5.72,6.66,8.72,9.09,9.31,11.38,13.62,13.22,9.72,6.75,4.72,2.0,-1.84,-3.38,-1.09,1.78,3.62,5.47,9.38,13.31,14.88,14.22,14.81,15.53,14.06,10.81,8.56,8.19,7.66,5.91,4.5,6.38,8.0,7.47,6.31,7.41,9.81,11.0,11.78,14.25,18.16,20.94,21.38,21.94,24.56,25.72,23.78,21.09,20.06,18.28,13.88,8.06,4.16,1.28,-2.78,-7.06,-8.72,-7.47,-5.66,-4.84,-2.47,2.38,6.72,8.12,8.31,9.94,10.81,9.41,6.47,5.28,5.19,3.84,0.72,-1.47,-2.56,-4.22,-8.44,-11.59,-11.53,-9.97,-9.5,-8.97,-5.28,-0.62,2.0,3.19,5.5,8.44,9.81,8.69,8.22,9.69,10.84,9.5,8.28,9.25,11.03,11.16,10.72,12.62,14.91,14.72,11.78,9.03,7.75,5.47,1.66,-0.72,-0.53,-0.12,-1.75,-2.88,-0.5,3.03,5.28,6.66,9.41,12.56,14.19,13.44,14.03,16.34,17.72,17.0,16.28,17.66,19.5,18.59,16.91,17.0,17.25,15.16,11.66,9.81,9.56,8.28,5.81,4.69,6.62,8.72,9.31,10.44,13.31,16.03,15.88,14.53,14.72,16.19,16.34,15.25,15.28,17.09,17.25,14.69,12.44,12.03,11.62,9.09,6.75,6.91,8.72,9.19,9.12,11.09,14.53,16.28,15.31,14.44,15.25,16.0,14.44,13.41,15.22,17.56,17.66,16.81,17.81,19.75,19.78,17.81,16.84,17.78,17.44,15.06,13.84,14.94,16.0,15.03,14.28,16.09,18.47,18.91,18.22,18.72,20.19,19.03,15.88,13.66,13.47,12.69,10.12,8.03,8.66,9.03,6.84,4.62,4.28,5.0,4.25,2.97,4.06,7.25,9.5,10.34,11.69,15.09,17.38,17.06,16.94,18.88,20.91,20.25,18.34,17.91,17.88,15.62,12.09,10.66,11.03,10.75,8.31,6.97,7.97,8.94,8.03,7.38,9.19,11.62,11.16,9.62,9.78,10.81,9.88,7.5,6.66,7.97,8.47,6.41,3.97,3.31,2.44,-0.59,-3.16,-2.06,1.16,2.69,3.88,6.72,10.88,13.19,13.53,13.88,16.0,16.41,14.19,11.75,11.91,11.97,9.47,5.81,4.69,4.25,2.75,0.56,-0.06,1.06,0.53,-2.22,-4.56,-4.28,-3.66,-4.28,-4.75,-1.88,1.62,3.16,4.0,7.19,11.19,12.62,12.25,12.0,12.53,11.69,8.19,5.16,4.91,4.97,3.84,2.97,4.91,7.5,7.84,7.03,7.47,9.34,9.59,8.19,7.31,8.84,9.44,7.97,6.38,7.31,8.25,7.06,5.44,6.31,8.53,8.88,8.03,8.22,9.84,9.97,8.03,6.78,8.22,9.66,8.84,8.06,9.44,10.81,10.06,8.19,8.38,9.84,9.78,8.25,8.56,11.53,13.53,13.69,13.97,16.06,17.03,15.06,12.12,11.28,11.38,10.44,8.38,8.47,10.0,10.34,8.72,7.97,10.12,11.69,11.31,11.75,14.47,16.88,16.62,15.44,15.62,17.09,16.94,15.59,16.22,17.91,18.41,16.75,15.69,16.59,17.16,15.47,13.53,14.31,15.59,15.75,14.41,15.12,16.88,17.25,15.88,15.38,17.03,18.12,16.78,15.78,17.12,18.28,17.16,15.34,15.78,17.22,17.06,16.09,17.16,19.81,21.0,20.44,20.84,23.25,24.28,22.84,20.44,19.66,19.06,16.75,14.03,13.94,14.75,14.62,13.19,13.5,15.31,16.16,14.84,13.97,15.38,16.5,14.81,13.25,13.78,14.97,14.62,13.53,14.66,16.28,16.09,13.41,12.0,11.78,10.91,8.38,6.94,8.0,9.53,8.94,8.06,9.72,11.78,12.47,12.06,13.78,17.06,19.5,19.97,20.94,23.5,24.5,22.44,19.75,19.34,19.03,17.0,14.97,15.19,17.12,17.31,16.34,16.22,17.44,17.88,15.88,14.91,16.34,17.59,17.12,16.41,18.09,20.66,21.28,20.97,22.28,24.34,24.72,23.0,22.09,22.88,22.88,20.47,19.25,20.44,22.22,22.19,22.09,24.25,26.88,27.38,26.53,26.72,27.72,27.97,26.09,25.31,26.25,26.91,24.62,22.16,22.09,22.19,20.06,18.25,18.47,19.47,19.47,18.28,18.31,19.97,20.62,19.44,19.06,21.0,23.09,23.16,23.0,24.41,26.19,25.28,23.59,23.28,24.47,24.78,23.84,24.44,27.28,29.47,28.81,28.31,29.75,31.09,30.0,28.81,30.03,31.97,32.16,30.94,30.53,30.97,29.47,25.97,24.25,25.0,25.81,25.44,24.88,26.34,28.12,27.16,25.31,24.94,25.41,23.62,20.56,18.5,17.66,16.22,13.66,12.38,14.72,18.31,20.28,22.09,25.84,29.25,29.81,29.09,29.31,30.81,30.66,28.81,27.78,28.31,27.53,24.47,21.69,21.06,20.84,18.91,17.16,18.0,19.97,20.72,20.41,21.38,23.56,24.31,23.19,22.75,24.28,25.25,23.53,21.06,20.41,19.56,16.56,13.44,12.56,14.03,14.44,13.56,14.31,17.25,18.78,18.56,19.56,22.97,25.56,25.97,25.69,26.78,28.03,27.41,25.44,25.06,25.59,24.47,21.41,18.84,18.75,17.91,15.78,14.31,15.81,18.34,19.28,20.56,24.03,28.03,29.59,28.78,27.88,27.25,24.84,20.31,16.47,14.97,13.59,10.78,8.56,9.62,11.69,12.25,12.25,13.69,15.88,16.22,15.38,15.72,18.16,19.78,19.5,19.78,22.69,25.41,26.03,25.81,26.72,27.47,25.31,22.19,20.44,20.88,21.12,20.53,21.88,25.19,27.06,25.25,22.47,21.12,19.44,15.84,12.97,12.78,14.78,15.81,16.06,17.97,20.91,22.06,20.16,17.81,16.94,15.56,12.41,10.25,11.38,13.78,14.97,15.53,18.03,21.31,22.62,22.28,23.09,25.5,26.59,25.28,24.0,25.31,26.34,25.81,25.84,28.66,32.0,33.38,33.34,34.25,36.16,36.56,34.44,32.69,32.28,30.22,25.62,21.34,19.47,18.19,15.25,12.34,12.06,13.41,13.5,12.44,13.0,15.5,16.94,17.12,18.75,23.06,27.12,28.81,29.91,33.12,36.44,37.22,36.72,37.53,38.19,36.38,32.34,28.94,27.41,24.91,20.62,17.34,16.81,17.0,15.59,14.47,16.06,18.81,20.06,20.97,24.19,29.0,32.91,34.75,36.44,39.75,41.5,40.91,40.03,41.19,41.84,40.09,36.75,35.22,34.66,32.06,28.59,26.47,25.88,24.72,21.62,19.56,19.75,19.78,17.25,14.5,13.28,12.94,10.53,7.84,8.25,10.91,12.88,13.31,15.56,19.59,22.88,23.84,25.19,28.0,29.72,28.78,26.88,26.59,27.22,25.72,23.75,23.69,25.5,26.25,25.06,24.69,25.25,24.97,21.41,18.12,17.69,17.69,16.88,16.28,18.22,21.44,22.19,21.22,20.75,21.78,20.84,18.12,16.81,17.38,18.0,16.12,14.41,14.72,15.5,15.0,14.16,15.88,19.84,22.38,23.56,25.62,28.5,29.28,26.97,25.12,25.12,25.22,22.78,19.72,18.5,17.56,14.66,10.84,9.59,10.19,10.56,9.75,10.41,13.62,15.84,15.25,15.25,17.25,19.78,19.84,19.94,21.97,24.88,25.66,25.53,27.16,30.62,33.06,32.84,32.75,33.69,32.94,29.31,25.97,24.62,24.56,22.88,21.25,22.25,24.66,25.16,23.88,23.28,23.5,23.09,20.75,19.97,22.34,25.25,25.81,26.09,28.19,29.91,29.09,26.44,24.94,24.34,22.12,17.75,14.88,14.19,13.31,11.09,10.31,12.25,14.94,15.62,15.88,18.12,21.16,22.19,21.66,22.47,24.41,25.16,23.66,23.0,24.66,25.81,24.81,23.91,25.19,25.97,24.09,21.81,20.94,21.16,20.12,18.38,17.81,18.97,19.0,16.5,14.88,15.75,16.62,15.72,14.97,16.53,18.72,18.66,17.03,17.88,20.28,21.28,21.41,22.72,25.56,26.41,23.91,20.69,19.34,17.91,14.47,11.28,10.69,11.69,10.94,9.12,8.75,9.78,8.62,6.12,4.91,6.53,8.81,10.0,12.16,17.0,22.5,25.0,26.41,28.88,31.56,31.0,28.75,26.91,26.47,24.28,20.53,17.28,16.38,15.38,12.38,10.0,10.16,11.97,11.81,11.12,12.59,15.62,16.84,16.38,16.78,18.94,19.47,17.44,15.78,15.75,15.84,13.72,11.19,11.62,13.5,13.88,14.19,15.88,18.91,19.69,17.94,16.16,16.31,15.53,13.22,11.88,13.38,15.5,15.38,14.47,15.38,17.06,16.44,14.72,14.53,16.38,16.94,15.91,15.31,17.06,17.66,15.53,12.38,11.38,11.16,8.97,6.62,7.09,9.34,10.28,9.59,10.44,13.22,14.66,14.0,13.97,16.62,19.03,19.41,19.25,21.53,24.62,25.44,24.94,25.5,26.78,25.56,22.25,19.88,20.03,19.94,17.75,16.31,17.25,17.94,16.5,14.25,14.78,16.22,16.38,15.62,17.0,19.75,21.34,21.0,21.22,23.5,40.78,40.91,41.28,40.97,40.62,40.75,42.22,42.53,41.59,41.31,42.12,42.75,41.97,41.19,41.06,41.0,39.81,38.16,37.94,38.22,37.56,36.0,35.41,36.84,37.66,37.66,38.22,40.06,40.84,39.66,38.34,37.47,36.81,34.62,32.59,31.97,32.53,32.81,32.47,32.66,34.12,34.91:negativity
6.94,6.16,6.41,9.06,12.03,12.47,12.69,14.5,16.34,15.03,12.56,11.28,11.59,10.28,7.72,7.19,8.94,9.88,8.75,8.62,11.0,12.78,12.22,11.81,13.59,15.78,15.91,14.88,14.69,15.41,13.5,10.16,8.0,8.81,9.16,8.31,8.22,10.25,11.03,9.16,6.19,5.06,4.53,2.34,-0.69,-1.34,0.19,0.81,0.06,1.44,5.0,7.72,8.69,9.22,11.59,13.22,12.25,10.81,11.72,12.97,12.22,10.5,10.41,11.38,11.12,9.44,8.94,10.5,11.19,9.28,7.94,8.69,9.09,7.47,5.16,5.19,6.41,6.28,5.75,6.88,9.81,11.28,10.75,10.72,12.66,13.09,11.41,9.75,11.22,12.81,12.91,12.38,13.69,14.97,13.81,11.0,9.56,10.06,9.38,7.81,7.56,9.66,11.25,10.72,10.97,14.22,17.81,19.72,20.91,24.09,27.62,28.41,27.41,27.28,27.75,25.94,21.72,18.47,16.47,13.75,8.97,4.62,3.62,3.66,2.81,1.56,3.06,5.47,5.97,5.44,6.31,8.88,10.44,10.22,10.69,13.34,15.34,14.66,13.25,14.09,14.53,12.25,8.97,7.56,6.53,3.56,-0.16,-2.5,-2.81,-4.19,-6.66,-7.72,-5.97,-3.91,-3.66,-2.88,0.5,3.88,5.75,6.28,8.84,12.09,13.62,13.81,15.66,19.06,20.78,19.62,18.28,18.22,16.5,12.84,9.0,7.75,7.69,5.94,3.41,3.22,3.78,2.53,0.34,0.44,3.09,5.91,7.22,9.66,13.88,16.91,17.03,16.94,18.59,20.25,19.62,17.84,17.28,17.75,16.5,14.03,12.97,13.75,14.03,12.88,12.53,14.94,16.62,15.47,13.5,13.03,13.03,11.38,9.09,9.25,10.69,10.62,8.66,7.59,8.66,8.25,6.12,5.03,6.56,8.34,8.25,8.03,9.5,10.59,9.62,7.47,7.19,8.5,8.34,6.69,6.06,7.41,7.66,5.72,4.44,5.88,7.34,7.09,6.91,8.88,11.41,12.25,11.84,13.62,16.25,17.34,16.38,16.34,17.84,18.94,17.94,16.81,18.0,18.12,15.84,12.47,11.59,11.69,10.72,9.19,9.28,10.28,10.34,8.44,8.47,10.62,12.78,12.66,12.25,13.97,15.44,14.84,14.0,15.78,17.94,17.88,16.19,16.12,17.25,17.31,15.75,15.88,17.91,19.19,17.97,17.03,18.06,18.78,17.69,15.62,15.88,16.72,16.47,15.62,16.72,19.22,20.84,20.12,19.81,21.53,22.5,21.0,19.34,19.47,19.25,17.25,14.69,14.06,14.81,13.94,11.75,10.94,11.72,11.81,10.03,10.0,12.69,15.66,16.66,17.97,21.62,24.81,25.62,25.28,26.25,26.75,25.06,21.22,17.88,15.88,12.81,7.88,4.03,3.19,3.06,1.66,1.25,4.0,7.0,8.19,8.56,10.12,12.31,12.38,10.69,10.0,11.0,11.38,10.06,9.31,10.84,12.19,10.72,9.34,10.34,11.06,10.0,8.16,8.44,10.06,10.38,9.66,10.25,12.28,13.12,11.5,10.31,10.75,10.88,8.91,6.88,7.94,9.75,9.91,9.38,10.38,11.94,11.34,8.69,7.25,7.69,8.25,7.03,6.62,8.56,10.25,9.34,7.97,8.62,9.53,8.34,6.28,5.97,6.84,6.56,4.41,3.53,4.97,5.25,3.28,1.69,2.38,3.44,2.72,2.16,3.66,5.5,5.19,3.38,3.59,4.81,5.16,3.91,3.66,5.09,5.31,2.94,0.78,0.41,0.53,-0.75,-2.03,-0.72,1.53,2.09,1.22,1.59,3.38,4.38,3.88,5.22,9.25,13.22,15.19,17.06,20.38,22.88,21.88,19.41,18.62,18.41,17.22,14.78,14.28,14.75,13.62,9.88,6.16,4.34,2.41,-1.31,-4.0,-3.69,-2.38,-2.41,-2.41,-0.19,3.19,4.84,4.97,6.75,9.28,10.97,10.66,10.75,12.28,12.56,10.56,8.44,8.31,8.97,8.03,6.72,7.28,9.06,8.91,7.44,7.09,7.31,6.38,3.56,1.56,2.09,3.31,2.59,2.75,4.78,7.66,8.31,8.22,9.56,11.62,11.81,10.28,10.25,11.91,13.28,12.56,12.44,14.09,14.66,12.31,9.19,7.94,6.97,3.94,0.69,0.03,0.81,0.75,-0.5,-0.41,1.34,2.47,1.69,1.75,4.12,5.91,5.19,4.19,4.94,6.53,6.25,5.38,6.44,8.56,9.0,7.5,6.38,6.0,4.53,0.19,-3.44,-5.09,-6.41,-9.38,-12.12,-12.09,-10.5,-10.0,-9.53,-6.72,-2.62,0.47,1.22,2.31,4.84,6.03,4.19,2.91,3.91,4.84,3.5,1.78,1.69,2.03,0.19,-2.44,-3.19,-2.31,-2.34,-3.56,-2.88,-0.22,1.72,1.59,1.81,3.84,6.19,6.78,7.44,9.88,12.78,12.78,11.06,9.47,8.72,6.31,2.56,0.38,0.88,2.34,1.97,1.78,3.44,4.0,2.03,-1.28,-2.81,-2.97,-4.41,-6.47,-6.38,-4.41,-3.19,-3.38,-2.06,1.41,5.06,6.38,7.91,11.38,14.06,13.44,11.84,11.31,11.59,10.62,9.03,9.72,12.47,14.12,13.59,13.88,14.84,15.09,12.62,10.81,10.94,12.62,12.16,10.91,11.25,12.12,10.97,8.72,8.44,10.03,11.94,12.5,14.41,17.72,20.47,19.75,18.22,17.88,17.28,14.25,10.09,7.94,6.81,4.5,1.75,1.59,3.34,4.5,3.91,4.12,6.53,9.12,9.28,9.5,11.16,12.78,11.75,9.72,9.44,10.75,10.84,9.59,9.75,11.25,11.88,10.47,9.5,10.66,11.88,10.75,9.94,10.81,12.72,12.75,11.34,10.78,10.72,8.69,4.62,1.69,1.28,1.47,0.31,0.88,4.47,8.5,10.12,11.22,13.28,15.19,14.12,11.34,9.91,9.34,7.56,4.47,2.72,3.0,2.97,1.06,-0.03,1.0,2.75,2.75,3.5,6.47,10.59,12.38,11.91,11.62,10.94,7.78,2.25,-2.16,-3.94,-5.22,-7.25,-7.91,-5.75,-2.38,-0.94,0.62,4.09,8.62,11.69,13.19,15.78,19.03,20.22,18.12,15.31,13.56,10.47,5.19,0.38,-1.25,-1.78,-3.84,-6.0,-6.34,-5.81,-7.59,-10.28,-11.72,-11.38,-11.78,-13.12,-13.56,-11.19,-9.47,-9.78,-10.09,-8.88,-7.28,-7.91,-8.34,-7.09,-4.03,-2.72,-2.47,-0.75,2.69,5.5,7.31,9.88,14.53,18.31,18.56,17.81,17.84,17.59,14.03,9.31,6.16,4.62,1.97,-1.06,-2.0,-0.66,-0.19,-1.62,-2.94,-2.16,-1.97,-4.03,-6.03,-5.59,-4.41,-5.09,-6.22,-5.5,-2.84,-1.34,-0.56,2.0,6.28,9.22,9.66,10.22,12.28,13.16,11.56,9.47,8.59,7.62,4.62,1.41,-0.03,0.88,1.22,0.81,2.12,5.25,7.28,6.75,6.0,6.44,5.84,3.66,1.44,2.5,5.0,6.44,7.38,9.22,11.62,11.0,8.19,5.62,5.16,3.56,0.31,-2.25,-2.12,-2.22,-4.0,-5.53,-4.91,-2.72,-1.97,-1.44,0.53,4.03,5.47,5.44,6.22,9.0,11.31,11.72,12.12,13.44,13.91,10.59,5.75,2.47,0.38,-2.84,-5.94,-6.66,-5.75,-5.78,-7.16,-8.0,-6.84,-5.5,-5.81,-5.16,-1.69,2.41,4.59,6.19,8.94,12.12,13.03,12.31,12.03,12.53,11.25,7.94,5.16,5.03,5.09,3.88,3.44,5.19,7.38,6.88,5.44,5.09,5.44,4.59,2.97,2.88,5.0,5.78,4.44,3.5,4.81,5.41,4.25,3.41,4.62,5.44,3.62,1.22,0.12,0.38,-0.25,-1.5,-1.19,1.84,4.62,5.72,7.88,12.38,16.06,17.25,17.66,19.03,19.66,17.5,13.53,10.84,9.56,6.91,3.69,1.88,2.44,2.44,0.81,-0.06,1.28,2.59,1.34,0.19,1.25,3.09,2.88,2.25,2.75,4.41,4.19,2.34,1.47,2.25,2.06,0.59,-0.22,1.41,3.22,3.38,3.22,5.34,7.97,8.88,8.38,8.84,10.06,9.22,6.97,5.56,6.06,5.59,3.62,1.78,3.16,4.97,5.06,5.16,7.22,9.91,10.16,9.47,10.41,12.78,13.44,12.66,13.03,15.16,16.41,15.56,14.88,16.0,17.0,15.44,13.38,13.56,14.5,13.91,12.75,12.66,13.59,13.19,10.56,8.78,9.59,9.62,7.38,5.0,4.44,3.81,1.16,-1.72,-2.53,-2.34,-3.22,-4.41,-4.03,-1.38,1.09,2.16,4.19,8.75,12.22,12.91,13.0,14.69,16.0,15.19,13.41,13.56,14.84,14.53,13.56,14.28,16.44,17.59,16.66,15.75,16.84,17.69,16.47,15.38,16.47,17.62,16.44,14.06,13.34,13.25,11.91,9.41,8.25,8.97,9.12,7.66,7.16,9.22,11.22,12.03,12.78,16.06,19.81,21.47,22.12,24.0,26.38,26.91,25.62,24.94,26.03,26.38,24.97,23.94,24.53,24.22,20.81,16.47,14.81,14.5,13.59,12.94,14.56,17.88,19.78,20.03,21.12,23.75,25.25,24.75,24.03,25.5,26.25,24.56,21.72,21.06,20.84,19.25,17.31,17.75,19.94,21.12,20.97,21.41,23.41,24.09,22.56,21.22,22.16,23.06,22.25,20.56,20.53,20.81,19.66,17.66,17.28,18.91,19.75,19.34,19.66,21.78,22.88,21.38,19.53,20.28,21.84,21.84,21.56,23.53,25.53,25.16,23.25,22.53,23.06,22.66,21.59,21.81,24.75,28.03,29.62,30.69,33.38,35.22,34.0,31.34,30.31,29.78,28.03,25.62,25.09,26.88,27.75,27.41,27.31,29.38,31.16,30.84,30.22,31.66,33.06,31.72,28.81:14.5,16.34,15.03,12.56,11.28,11.59,10.28,7.72,7.19,8.94,9.88,8.75,8.62,11.0,12.78,12.22,11.81,13.59,15.78,15.91,14.88,14.69,15.41,13.5,10.16,8.0,8.81,9.16,8.31,8.22,10.25,11.03,9.16,6.19,5.06,4.53,2.34,-0.69,-1.34,0.19,0.81,0.06,1.44,5.0,7.72,8.69,9.22,11.59,13.22,12.25,10.81,11.72,12.97,12.22,10.5,10.41,11.38,11.12,9.44,8.94,10.5,11.19,9.28,7.94,8.69,9.09,7.47,5.16,5.19,6.41,6.28,5.75,6.88,9.81,11.28,10.75,10.72,12.66,13.09,11.41,9.75,11.22,12.81,12.91,12.38,13.69,14.97,13.81,11.0,9.56,10.06,9.38,7.81,7.56,9.66,11.25,10.72,10.97,14.22,17.81,19.72,20.91,24.09,27.62,28.41,27.41,27.28,27.75,25.94,21.72,18.47,16.47,13.75,8.97,4.62,3.62,3.66,2.81,1.56,3.06,5.47,5.97,5.44,6.31,8.88,10.44,10.22,10.69,13.34,15.34,14.66,13.25,14.09,14.53,12.25,8.97,7.56,6.53,3.56,-0.16,-2.5,-2.81,-4.19,-6.66,-7.72,-5.97,-3.91,-3.66,-2.88,0.5,3.88,5.75,6.28,8.84,12.09,13.62,13.81,15.66,19.06,20.78,19.62,18.28,18.22,16.5,12.84,9.0,7.75,7.69,5.94,3.41,3.22,3.78,2.53,0.34,0.44,3.09,5.91,7.22,9.66,13.88,16.91,17.03,16.94,18.59,20.25,19.62,17.84,17.28,17.75,16.5,14.03,12.97,13.75,14.03,12.88,12.53,14.94,16.62,15.47,13.5,13.03,13.03,11.38,9.09,9.25,10.69,10.62,8.66,7.59,8.66,8.25,6.12,5.03,6.56,8.34,8.25,8.03,9.5,10.59,9.62,7.47,7.19,8.5,8.34,6.69,6.06,7.41,7.66,5.72,4.44,5.88,7.34,7.09,6.91,8.88,11.41,12.25,11.84,13.62,16.25,17.34,16.38,16.34,17.84,18.94,17.94,16.81,18.0,18.12,15.84,12.47,11.59,11.69,10.72,9.19,9.28,10.28,10.34,8.44,8.47,10.62,12.78,12.66,12.25,13.97,15.44,14.84,14.0,15.78,17.94,17.88,16.19,16.12,17.25,17.31,15.75,15.88,17.91,19.19,17.97,17.03,18.06,18.78,17.69,15.62,15.88,16.72,16.47,15.62,16.72,19.22,20.84,20.12,19.81,21.53,22.5,21.0,19.34,19.47,19.25,17.25,14.69,14.06,14.81,13.94,11.75,10.94,11.72,11.81,10.03,10.0,12.69,15.66,16.66,17.97,21.62,24.81,25.62,25.28,26.25,26.75,25.06,21.22,17.88,15.88,12.81,7.88,4.03,3.19,3.06,1.66,1.25,4.0,7.0,8.19,8.56,10.12,12.31,12.38,10.69,10.0,11.0,11.38,10.06,9.31,10.84,12.19,10.72,9.34,10.34,11.06,10.0,8.16,8.44,10.06,10.38,9.66,10.25,12.28,13.12,11.5,10.31,10.75,10.88,8.91,6.88,7.94,9.75,9.91,9.38,10.38,11.94,11.34,8.69,7.25,7.69,8.25,7.03,6.62,8.56,10.25,9.34,7.97,8.62,9.53,8.34,6.28,5.97,6.84,6.56,4.41,3.53,4.97,5.25,3.28,1.69,2.38,3.44,2.72,2.16,3.66,5.5,5.19,3.38,3.59,4.81,5.16,3.91,3.66,5.09,5.31,2.94,0.78,0.41,0.53,-0.75,-2.03,-0.72,1.53,2.09,1.22,1.59,3.38,4.38,3.88,5.22,9.25,13.22,15.19,17.06,20.38,22.88,21.88,19.41,18.62,18.41,17.22,14.78,14.28,14.75,13.62,9.88,6.16,4.34,2.41,-1.31,-4.0,-3.69,-2.38,-2.41,-2.41,-0.19,3.19,4.84,4.97,6.75,9.28,10.97,10.66,10.75,12.28,12.56,10.56,8.44,8.31,8.97,8.03,6.72,7.28,9.06,8.91,7.44,7.09,7.31,6.38,3.56,1.56,2.09,3.31,2.59,2.75,4.78,7.66,8.31,8.22,9.56,11.62,11.81,10.28,10.25,11.91,13.28,12.56,12.44,14.09,14.66,12.31,9.19,7.94,6.97,3.94,0.69,0.03,0.81,0.75,-0.5,-0.41,1.34,2.47,1.69,1.75,4.12,5.91,5.19,4.19,4.94,6.53,6.25,5.38,6.44,8.56,9.0,7.5,6.38,6.0,4.53,0.19,-3.44,-5.09,-6.41,-9.38,-12.12,-12.09,-10.5,-10.0,-9.53,-6.72,-2.62,0.47,1.22,2.31,4.84,6.03,4.19,2.91,3.91,4.84,3.5,1.78,1.69,2.03,0.19,-2.44,-3.19,-2.31,-2.34,-3.56,-2.88,-0.22,1.72,1.59,1.81,3.84,6.19,6.78,7.44,9.88,12.78,12.78,11.06,9.47,8.72,6.31,2.56,0.38,0.88,2.34,1.97,1.78,3.44,4.0,2.03,-1.28,-2.81,-2.97,-4.41,-6.47,-6.38,-4.41,-3.19,-3.38,-2.06,1.41,5.06,6.38,7.91,11.38,14.06,13.44,11.84,11.31,11.59,10.62,9.03,9.72,12.47,14.12,13.59,13.88,14.84,15.09,12.62,10.81,10.94,12.62,12.16,10.91,11.25,12.12,10.97,8.72,8.44,10.03,11.94,12.5,14.41,17.72,20.47,19.75,18.22,17.88,17.28,14.25,10.09,7.94,6.81,4.5,1.75,1.59,3.34,4.5,3.91,4.12,6.53,9.12,9.28,9.5,11.16,12.78,11.75,9.72,9.44,10.75,10.84,9.59,9.75,11.25,11.88,10.47,9.5,10.66,11.88,10.75,9.94,10.81,12.72,12.75,11.34,10.78,10.72,8.69,4.62,1.69,1.28,1.47,0.31,0.88,4.47,8.5,10.12,11.22,13.28,15.19,14.12,11.34,9.91,9.34,7.56,4.47,2.72,3.0,2.97,1.06,-0.03,1.0,2.75,2.75,3.5,6.47,10.59,12.38,11.91,11.62,10.94,7.78,2.25,-2.16,-3.94,-5.22,-7.25,-7.91,-5.75,-2.38,-0.94,0.62,4.09,8.62,11.69,13.19,15.78,19.03,20.22,18.12,15.31,13.56,10.47,5.19,0.38,-1.25,-1.78,-3.84,-6.0,-6.34,-5.81,-7.59,-10.28,-11.72,-11.38,-11.78,-13.12,-13.56,-11.19,-9.47,-9.78,-10.09,-8.88,-7.28,-7.91,-8.34,-7.09,-4.03,-2.72,-2.47,-0.75,2.69,5.5,7.31,9.88,14.53,18.31,18.56,17.81,17.84,17.59,14.03,9.31,6.16,4.62,1.97,-1.06,-2.0,-0.66,-0.19,-1.62,-2.94,-2.16,-1.97,-4.03,-6.03,-5.59,-4.41,-5.09,-6.22,-5.5,-2.84,-1.34,-0.56,2.0,6.28,9.22,9.66,10.22,12.28,13.16,11.56,9.47,8.59,7.62,4.62,1.41,-0.03,0.88,1.22,0.81,2.12,5.25,7.28,6.75,6.0,6.44,5.84,3.66,1.44,2.5,5.0,6.44,7.38,9.22,11.62,11.0,8.19,5.62,5.16,3.56,0.31,-2.25,-2.12,-2.22,-4.0,-5.53,-4.91,-2.72,-1.97,-1.44,0.53,4.03,5.47,5.44,6.22,9.0,11.31,11.72,12.12,13.44,13.91,10.59,5.75,2.47,0.38,-2.84,-5.94,-6.66,-5.75,-5.78,-7.16,-8.0,-6.84,-5.5,-5.81,-5.16,-1.69,2.41,4.59,6.19,8.94,12.12,13.03,12.31,12.03,12.53,11.25,7.94,5.16,5.03,5.09,3.88,3.44,5.19,7.38,6.88,5.44,5.09,5.44,4.59,2.97,2.88,5.0,5.78,4.44,3.5,4.81,5.41,4.25,3.41,4.62,5.44,3.62,1.22,0.12,0.38,-0.25,-1.5,-1.19,1.84,4.62,5.72,7.88,12.38,16.06,17.25,17.66,19.03,19.66,17.5,13.53,10.84,9.56,6.91,3.69,1.88,2.44,2.44,0.81,-0.06,1.28,2.59,1.34,0.19,1.25,3.09,2.88,2.25,2.75,4.41,4.19,2.34,1.47,2.25,2.06,0.59,-0.22,1.41,3.22,3.38,3.22,5.34,7.97,8.88,8.38,8.84,10.06,9.22,6.97,5.56,6.06,5.59,3.62,1.78,3.16,4.97,5.06,5.16,7.22,9.91,10.16,9.47,10.41,12.78,13.44,12.66,13.03,15.16,16.41,15.56,14.88,16.0,17.0,15.44,13.38,13.56,14.5,13.91,12.75,12.66,13.59,13.19,10.56,8.78,9.59,9.62,7.38,5.0,4.44,3.81,1.16,-1.72,-2.53,-2.34,-3.22,-4.41,-4.03,-1.38,1.09,2.16,4.19,8.75,12.22,12.91,13.0,14.69,16.0,15.19,13.41,13.56,14.84,14.53,13.56,14.28,16.44,17.59,16.66,15.75,16.84,17.69,16.47,15.38,16.47,17.62,16.44,14.06,13.34,13.25,11.91,9.41,8.25,8.97,9.12,7.66,7.16,9.22,11.22,12.03,12.78,16.06,19.81,21.47,22.12,24.0,26.38,26.91,25.62,24.94,26.03,26.38,24.97,23.94,24.53,24.22,20.81,16.47,14.81,14.5,13.59,12.94,14.56,17.88,19.78,20.03,21.12,23.75,25.25,24.75,24.03,25.5,26.25,24.56,21.72,21.06,20.84,19.25,17.31,17.75,19.94,21.12,20.97,21.41,23.41,24.09,22.56,21.22,22.16,23.06,22.25,20.56,20.53,20.81,19.66,17.66,17.28,18.91,19.75,19.34,19.66,21.78,22.88,21.38,19.53,20.28,21.84,21.84,21.56,23.53,25.53,25.16,23.25,22.53,23.06,22.66,21.59,21.81,24.75,28.03,29.62,30.69,33.38,35.22,34.0,31.34,30.31,29.78,28.03,25.62,25.09,26.88,27.75,27.41,27.31,29.38,31.16,30.84,30.22,31.66,33.06,31.72,28.81,4.31,5.16,6.25,9.03,11.88,13.12,14.19:7.72,7.19,8.94,9.88,8.75,8.62,11.0,12.78,12.22,11.81,13.59,15.78,15.91,14.88,14.69,15.41,13.5,10.16,8.0,8.81,9.16,8.31,8.22,10.25,11.03,9.16,6.19,5.06,4.53,2.34,-0.69,-1.34,0.19,0.81,0.06,1.44,5.0,7.72,8.69,9.22,11.59,13.22,12.25,10.81,11.72,12.97,12.22,10.5,10.41,11.38,11.12,9.44,8.94,10.5,11.19,9.28,7.94,8.69,9.09,7.47,5.16,5.19,6.41,6.28,5.75,6.88,9.81,11.28,10.75,10.72,12.66,13.09,11.41,9.75,11.22,12.81,12.91,12.38,13.69,14.97,13.81,11.0,9.56,10.06,9.38,7.81,7.56,9.66,11.25,10.72,10.97,14.22,17.81,19.72,20.91,24.09,27.62,28.41,27.41,27.28,27.75,25.94,21.72,18.47,16.47,13.75,8.97,4.62,3.62,3.66,2.81,1.56,3.06,5.47,5.97,5.44,6.31,8.88,10.44,10.22,10.69,13.34,15.34,14.66,13.25,14.09,14.53,12.25,8.97,7.56,6.53,3.56,-0.16,-2.5,-2.81,-4.19,-6.66,-7.72,-5.97,-3.91,-3.66,-2.88,0.5,3.88,5.75,6.28,8.84,12.09,13.62,13.81,15.66,19.06,20.78,19.62,18.28,18.22,16.5,12.84,9.0,7.75,7.69,5.94,3.41,3.22,3.78,2.53,0.34,0.44,3.09,5.91,7.22,9.66,13.88,16.91,17.03,16.94,18.59,20.25,19.62,17.84,17.28,17.75,16.5,14.03,12.97,13.75,14.03,12.88,12.53,14.94,16.62,15.47,13.5,13.03,13.03,11.38,9.09,9.25,10.69,10.62,8.66,7.59,8.66,8.25,6.12,5.03,6.56,8.34,8.25,8.03,9.5,10.59,9.62,7.47,7.19,8.5,8.34,6.69,6.06,7.41,7.66,5.72,4.44,5.88,7.34,7.09,6.91,8.88,11.41,12.25,11.84,13.62,16.25,17.34,16.38,16.34,17.84,18.94,17.94,16.81,18.0,18.12,15.84,12.47,11.59,11.69,10.72,9.19,9.28,10.28,10.34,8.44,8.47,10.62,12.78,12.66,12.25,13.97,15.44,14.84,14.0,15.78,17.94,17.88,16.19,16.12,17.25,17.31,15.75,15.88,17.91,19.19,17.97,17.03,18.06,18.78,17.69,15.62,15.88,16.72,16.47,15.62,16.72,19.22,20.84,20.12,19.81,21.53,22.5,21.0,19.34,19.47,19.25,17.25,14.69,14.06,14.81,13.94,11.75,10.94,11.72,11.81,10.03,10.0,12.69,15.66,16.66,17.97,21.62,24.81,25.62,25.28,26.25,26.75,25.06,21.22,17.88,15.88,12.81,7.88,4.03,3.19,3.06,1.66,1.25,4.0,7.0,8.19,8.56,10.12,12.31,12.38,10.69,10.0,11.0,11.38,10.06,9.31,10.84,12.19,10.72,9.34,10.34,11.06,10.0,8.16,8.44,10.06,10.38,9.66,10.25,12.28,13.12,11.5,10.31,10.75,10.88,8.91,6.88,7.94,9.75,9.91,9.38,10.38,11.94,11.34,8.69,7.25,7.69,8.25,7.03,6.62,8.56,10.25,9.34,7.97,8.62,9.53,8.34,6.28,5.97,6.84,6.56,4.41,3.53,4.97,5.25,3.28,1.69,2.38,3.44,2.72,2.16,3.66,5.5,5.19,3.38,3.59,4.81,5.16,3.91,3.66,5.09,5.31,2.94,0.78,0.41,0.53,-0.75,-2.03,-0.72,1.53,2.09,1.22,1.59,3.38,4.38,3.88,5.22,9.25,13.22,15.19,17.06,20.38,22.88,21.88,19.41,18.62,18.41,17.22,14.78,14.28,14.75,13.62,9.88,6.16,4.34,2.41,-1.31,-4.0,-3.69,-2.38,-2.41,-2.41,-0.19,3.19,4.84,4.97,6.75,9.28,10.97,10.66,10.75,12.28,12.56,10.56,8.44,8.31,8.97,8.03,6.72,7.28,9.06,8.91,7.44,7.09,7.31,6.38,3.56,1.56,2.09,3.31,2.59,2.75,4.78,7.66,8.31,8.22,9.56,11.62,11.81,10.28,10.25,11.91,13.28,12.56,12.44,14.09,14.66,12.31,9.19,7.94,6.97,3.94,0.69,0.03,0.81,0.75,-0.5,-0.41,1.34,2.47,1.69,1.75,4.12,5.91,5.19,4.19,4.94,6.53,6.25,5.38,6.44,8.56,9.0,7.5,6.38,6.0,4.53,0.19,-3.44,-5.09,-6.41,-9.38,-12.12,-12.09,-10.5,-10.0,-9.53,-6.72,-2.62,0.47,1.22,2.31,4.84,6.03,4.19,2.91,3.91,4.84,3.5,1.78,1.69,2.03,0.19,-2.44,-3.19,-2.31,-2.34,-3.56,-2.88,-0.22,1.72,1.59,1.81,3.84,6.19,6.78,7.44,9.88,12.78,12.78,11.06,9.47,8.72,6.31,2.56,0.38,0.88,2.34,1.97,1.78,3.44,4.0,2.03,-1.28,-2.81,-2.97,-4.41,-6.47,-6.38,-4.41,-3.19,-3.38,-2.06,1.41,5.06,6.38,7.91,11.38,14.06,13.44,11.84,11.31,11.59,10.62,9.03,9.72,12.47,14.12,13.59,13.88,14.84,15.09,12.62,10.81,10.94,12.62,12.16,10.91,11.25,12.12,10.97,8.72,8.44,10.03,11.94,12.5,14.41,17.72,20.47,19.75,18.22,17.88,17.28,14.25,10.09,7.94,6.81,4.5,1.75,1.59,3.34,4.5,3.91,4.12,6.53,9.12,9.28,9.5,11.16,12.78,11.75,9.72,9.44,10.75,10.84,9.59,9.75,11.25,11.88,10.47,9.5,10.66,11.88,10.75,9.94,10.81,12.72,12.75,11.34,10.78,10.72,8.69,4.62,1.69,1.28,1.47,0.31,0.88,4.47,8.5,10.12,11.22,13.28,15.19,14.12,11.34,9.91,9.34,7.56,4.47,2.72,3.0,2.97,1.06,-0.03,1.0,2.75,2.75,3.5,6.47,10.59,12.38,11.91,11.62,10.94,7.78,2.25,-2.16,-3.94,-5.22,-7.25,-7.91,-5.75,-2.38,-0.94,0.62,4.09,8.62,11.69,13.19,15.78,19.03,20.22,18.12,15.31,13.56,10.47,5.19,0.38,-1.25,-1.78,-3.84,-6.0,-6.34,-5.81,-7.59,-10.28,-11.72,-11.38,-11.78,-13.12,-13.56,-11.19,-9.47,-9.78,-10.09,-8.88,-7.28,-7.91,-8.34,-7.09,-4.03,-2.72,-2.47,-0.75,2.69,5.5,7.31,9.88,14.53,18.31,18.56,17.81,17.84,17.59,14.03,9.31,6.16,4.62,1.97,-1.06,-2.0,-0.66,-0.19,-1.62,-2.94,-2.16,-1.97,-4.03,-6.03,-5.59,-4.41,-5.09,-6.22,-5.5,-2.84,-1.34,-0.56,2.0,6.28,9.22,9.66,10.22,12.28,13.16,11.56,9.47,8.59,7.62,4.62,1.41,-0.03,0.88,1.22,0.81,2.12,5.25,7.28,6.75,6.0,6.44,5.84,3.66,1.44,2.5,5.0,6.44,7.38,9.22,11.62,11.0,8.19,5.62,5.16,3.56,0.31,-2.25,-2.12,-2.22,-4.0,-5.53,-4.91,-2.72,-1.97,-1.44,0.53,4.03,5.47,5.44,6.22,9.0,11.31,11.72,12.12,13.44,13.91,10.59,5.75,2.47,0.38,-2.84,-5.94,-6.66,-5.75,-5.78,-7.16,-8.0,-6.84,-5.5,-5.81,-5.16,-1.69,2.41,4.59,6.19,8.94,12.12,13.03,12.31,12.03,12.53,11.25,7.94,5.16,5.03,5.09,3.88,3.44,5.19,7.38,6.88,5.44,5.09,5.44,4.59,2.97,2.88,5.0,5.78,4.44,3.5,4.81,5.41,4.25,3.41,4.62,5.44,3.62,1.22,0.12,0.38,-0.25,-1.5,-1.19,1.84,4.62,5.72,7.88,12.38,16.06,17.25,17.66,19.03,19.66,17.5,13.53,10.84,9.56,6.91,3.69,1.88,2.44,2.44,0.81,-0.06,1.28,2.59,1.34,0.19,1.25,3.09,2.88,2.25,2.75,4.41,4.19,2.34,1.47,2.25,2.06,0.59,-0.22,1.41,3.22,3.38,3.22,5.34,7.97,8.88,8.38,8.84,10.06,9.22,6.97,5.56,6.06,5.59,3.62,1.78,3.16,4.97,5.06,5.16,7.22,9.91,10.16,9.47,10.41,12.78,13.44,12.66,13.03,15.16,16.41,15.56,14.88,16.0,17.0,15.44,13.38,13.56,14.5,13.91,12.75,12.66,13.59,13.19,10.56,8.78,9.59,9.62,7.38,5.0,4.44,3.81,1.16,-1.72,-2.53,-2.34,-3.22,-4.41,-4.03,-1.38,1.09,2.16,4.19,8.75,12.22,12.91,13.0,14.69,16.0,15.19,13.41,13.56,14.84,14.53,13.56,14.28,16.44,17.59,16.66,15.75,16.84,17.69,16.47,15.38,16.47,17.62,16.44,14.06,13.34,13.25,11.91,9.41,8.25,8.97,9.12,7.66,7.16,9.22,11.22,12.03,12.78,16.06,19.81,21.47,22.12,24.0,26.38,26.91,25.62,24.94,26.03,26.38,24.97,23.94,24.53,24.22,20.81,16.47,14.81,14.5,13.59,12.94,14.56,17.88,19.78,20.03,21.12,23.75,25.25,24.75,24.03,25.5,26.25,24.56,21.72,21.06,20.84,19.25,17.31,17.75,19.94,21.12,20.97,21.41,23.41,24.09,22.56,21.22,22.16,23.06,22.25,20.56,20.53,20.81,19.66,17.66,17.28,18.91,19.75,19.34,19.66,21.78,22.88,21.38,19.53,20.28,21.84,21.84,21.56,23.53,25.53,25.16,23.25,22.53,23.06,22.66,21.59,21.81,24.75,28.03,29.62,30.69,33.38,35.22,34.0,31.34,30.31,29.78,28.03,25.62,25.09,26.88,27.75,27.41,27.31,29.38,31.16,30.84,30.22,31.66,33.06,31.72,28.81,4.31,5.16,6.25,9.03,11.88,13.12,14.19,16.22,17.78,17.28,15.28,14.66,14.06,12.81:12.78,12.22,11.81,13.59,15.78,15.91,14.88,14.69,15.41,13.5,10.16,8.0,8.81,9.16,8.31,8.22,10.25,11.03,9.16,6.19,5.06,4.53,2.34,-0.69,-1.34,0.19,0.81,0.06,1.44,5.0,7.72,8.69,9.22,11.59,13.22,12.25,10.81,11.72,12.97,12.22,10.5,10.41,11.38,11.12,9.44,8.94,10.5,11.19,9.28,7.94,8.69,9.09,7.47,5.16,5.19,6.41,6.28,5.75,6.88,9.81,11.28,10.75,10.72,12.66,13.09,11.41,9.75,11.22,12.81,12.91,12.38,13.69,14.97,13.81,11.0,9.56,10.06,9.38,7.81,7.56,9.66,11.25,10.72,10.97,14.22,17.81,19.72,20.91,24.09,27.62,28.41,27.41,27.28,27.75,25.94,21.72,18.47,16.47,13.75,8.97,4.62,3.62,3.66,2.81,1.56,3.06,5.47,5.97,5.44,6.31,8.88,10.44,10.22,10.69,13.34,15.34,14.66,13.25,14.09,14.53,12.25,8.97,7.56,6.53,3.56,-0.16,-2.5,-2.81,-4.19,-6.66,-7.72,-5.97,-3.91,-3.66,-2.88,0.5,3.88,5.75,6.28,8.84,12.09,13.62,13.81,15.66,19.06,20.78,19.62,18.28,18.22,16.5,12.84,9.0,7.75,7.69,5.94,3.41,3.22,3.78,2.53,0.34,0.44,3.09,5.91,7.22,9.66,13.88,16.91,17.03,16.94,18.59,20.25,19.62,17.84,17.28,17.75,16.5,14.03,12.97,13.75,14.03,12.88,12.53,14.94,16.62,15.47,13.5,13.03,13.03,11.38,9.09,9.25,10.69,10.62,8.66,7.59,8.66,8.25,6.12,5.03,6.56,8.34,8.25,8.03,9.5,10.59,9.62,7.47,7.19,8.5,8.34,6.69,6.06,7.41,7.66,5.72,4.44,5.88,7.34,7.09,6.91,8.88,11.41,12.25,11.84,13.62,16.25,17.34,16.38,16.34,17.84,18.94,17.94,16.81,18.0,18.12,15.84,12.47,11.59,11.69,10.72,9.19,9.28,10.28,10.34,8.44,8.47,10.62,12.78,12.66,12.25,13.97,15.44,14.84,14.0,15.78,17.94,17.88,16.19,16.12,17.25,17.31,15.75,15.88,17.91,19.19,17.97,17.03,18.06,18.78,17.69,15.62,15.88,16.72,16.47,15.62,16.72,19.22,20.84,20.12,19.81,21.53,22.5,21.0,19.34,19.47,19.25,17.25,14.69,14.06,14.81,13.94,11.75,10.94,11.72,11.81,10.03,10.0,12.69,15.66,16.66,17.97,21.62,24.81,25.62,25.28,26.25,26.75,25.06,21.22,17.88,15.88,12.81,7.88,4.03,3.19,3.06,1.66,1.25,4.0,7.0,8.19,8.56,10.12,12.31,12.38,10.69,10.0,11.0,11.38,10.06,9.31,10.84,12.19,10.72,9.34,10.34,11.06,10.0,8.16,8.44,10.06,10.38,9.66,10.25,12.28,13.12,11.5,10.31,10.75,10.88,8.91,6.88,7.94,9.75,9.91,9.38,10.38,11.94,11.34,8.69,7.25,7.69,8.25,7.03,6.62,8.56,10.25,9.34,7.97,8.62,9.53,8.34,6.28,5.97,6.84,6.56,4.41,3.53,4.97,5.25,3.28,1.69,2.38,3.44,2.72,2.16,3.66,5.5,5.19,3.38,3.59,4.81,5.16,3.91,3.66,5.09,5.31,2.94,0.78,0.41,0.53,-0.75,-2.03,-0.72,1.53,2.09,1.22,1.59,3.38,4.38,3.88,5.22,9.25,13.22,15.19,17.06,20.38,22.88,21.88,19.41,18.62,18.41,17.22,14.78,14.28,14.75,13.62,9.88,6.16,4.34,2.41,-1.31,-4.0,-3.69,-2.38,-2.41,-2.41,-0.19,3.19,4.84,4.97,6.75,9.28,10.97,10.66,10.75,12.28,12.56,10.56,8.44,8.31,8.97,8.03,6.72,7.28,9.06,8.91,7.44,7.09,7.31,6.38,3.56,1.56,2.09,3.31,2.59,2.75,4.78,7.66,8.31,8.22,9.56,11.62,11.81,10.28,10.25,11.91,13.28,12.56,12.44,14.09,14.66,12.31,9.19,7.94,6.97,3.94,0.69,0.03,0.81,0.75,-0.5,-0.41,1.34,2.47,1.69,1.75,4.12,5.91,5.19,4.19,4.94,6.53,6.25,5.38,6.44,8.56,9.0,7.5,6.38,6.0,4.53,0.19,-3.44,-5.09,-6.41,-9.38,-12.12,-12.09,-10.5,-10.0,-9.53,-6.72,-2.62,0.47,1.22,2.31,4.84,6.03,4.19,2.91,3.91,4.84,3.5,1.78,1.69,2.03,0.19,-2.44,-3.19,-2.31,-2.34,-3.56,-2.88,-0.22,1.72,1.59,1.81,3.84,6.19,6.78,7.44,9.88,12.78,12.78,11.06,9.47,8.72,6.31,2.56,0.38,0.88,2.34,1.97,1.78,3.44,4.0,2.03,-1.28,-2.81,-2.97,-4.41,-6.47,-6.38,-4.41,-3.19,-3.38,-2.06,1.41,5.06,6.38,7.91,11.38,14.06,13.44,11.84,11.31,11.59,10.62,9.03,9.72,12.47,14.12,13.59,13.88,14.84,15.09,12.62,10.81,10.94,12.62,12.16,10.91,11.25,12.12,10.97,8.72,8.44,10.03,11.94,12.5,14.41,17.72,20.47,19.75,18.22,17.88,17.28,14.25,10.09,7.94,6.81,4.5,1.75,1.59,3.34,4.5,3.91,4.12,6.53,9.12,9.28,9.5,11.16,12.78,11.75,9.72,9.44,10.75,10.84,9.59,9.75,11.25,11.88,10.47,9.5,10.66,11.88,10.75,9.94,10.81,12.72,12.75,11.34,10.78,10.72,8.69,4.62,1.69,1.28,1.47,0.31,0.88,4.47,8.5,10.12,11.22,13.28,15.19,14.12,11.34,9.91,9.34,7.56,4.47,2.72,3.0,2.97,1.06,-0.03,1.0,2.75,2.75,3.5,6.47,10.59,12.38,11.91,11.62,10.94,7.78,2.25,-2.16,-3.94,-5.22,-7.25,-7.91,-5.75,-2.38,-0.94,0.62,4.09,8.62,11.69,13.19,15.78,19.03,20.22,18.12,15.31,13.56,10.47,5.19,0.38,-1.25,-1.78,-3.84,-6.0,-6.34,-5.81,-7.59,-10.28,-11.72,-11.38,-11.78,-13.12,-13.56,-11.19,-9.47,-9.78,-10.09,-8.88,-7.28,-7.91,-8.34,-7.09,-4.03,-2.72,-2.47,-0.75,2.69,5.5,7.31,9.88,14.53,18.31,18.56,17.81,17.84,17.59,14.03,9.31,6.16,4.62,1.97,-1.06,-2.0,-0.66,-0.19,-1.62,-2.94,-2.16,-1.97,-4.03,-6.03,-5.59,-4.41,-5.09,-6.22,-5.5,-2.84,-1.34,-0.56,2.0,6.28,9.22,9.66,10.22,12.28,13.16,11.56,9.47,8.59,7.62,4.62,1.41,-0.03,0.88,1.22,0.81,2.12,5.25,7.28,6.75,6.0,6.44,5.84,3.66,1.44,2.5,5.0,6.44,7.38,9.22,11.62,11.0,8.19,5.62,5.16,3.56,0.31,-2.25,-2.12,-2.22,-4.0,-5.53,-4.91,-2.72,-1.97,-1.44,0.53,4.03,5.47,5.44,6.22,9.0,11.31,11.72,12.12,13.44,13.91,10.59,5.75,2.47,0.38,-2.84,-5.94,-6.66,-5.75,-5.78,-7.16,-8.0,-6.84,-5.5,-5.81,-5.16,-1.69,2.41,4.59,6.19,8.94,12.12,13.03,12.31,12.03,12.53,11.25,7.94,5.16,5.03,5.09,3.88,3.44,5.19,7.38,6.88,5.44,5.09,5.44,4.59,2.97,2.88,5.0,5.78,4.44,3.5,4.81,5.41,4.25,3.41,4.62,5.44,3.62,1.22,0.12,0.38,-0.25,-1.5,-1.19,1.84,4.62,5.72,7.88,12.38,16.06,17.25,17.66,19.03,19.66,17.5,13.53,10.84,9.56,6.91,3.69,1.88,2.44,2.44,0.81,-0.06,1.28,2.59,1.34,0.19,1.25,3.09,2.88,2.25,2.75,4.41,4.19,2.34,1.47,2.25,2.06,0.59,-0.22,1.41,3.22,3.38,3.22,5.34,7.97,8.88,8.38,8.84,10.06,9.22,6.97,5.56,6.06,5.59,3.62,1.78,3.16,4.97,5.06,5.16,7.22,9.91,10.16,9.47,10.41,12.78,13.44,12.66,13.03,15.16,16.41,15.56,14.88,16.0,17.0,15.44,13.38,13.56,14.5,13.91,12.75,12.66,13.59,13.19,10.56,8.78,9.59,9.62,7.38,5.0,4.44,3.81,1.16,-1.72,-2.53,-2.34,-3.22,-4.41,-4.03,-1.38,1.09,2.16,4.19,8.75,12.22,12.91,13.0,14.69,16.0,15.19,13.41,13.56,14.84,14.53,13.56,14.28,16.44,17.59,16.66,15.75,16.84,17.69,16.47,15.38,16.47,17.62,16.44,14.06,13.34,13.25,11.91,9.41,8.25,8.97,9.12,7.66,7.16,9.22,11.22,12.03,12.78,16.06,19.81,21.47,22.12,24.0,26.38,26.91,25.62,24.94,26.03,26.38,24.97,23.94,24.53,24.22,20.81,16.47,14.81,14.5,13.59,12.94,14.56,17.88,19.78,20.03,21.12,23.75,25.25,24.75,24.03,25.5,26.25,24.56,21.72,21.06,20.84,19.25,17.31,17.75,19.94,21.12,20.97,21.41,23.41,24.09,22.56,21.22,22.16,23.06,22.25,20.56,20.53,20.81,19.66,17.66,17.28,18.91,19.75,19.34,19.66,21.78,22.88,21.38,19.53,20.28,21.84,21.84,21.56,23.53,25.53,25.16,23.25,22.53,23.06,22.66,21.59,21.81,24.75,28.03,29.62,30.69,33.38,35.22,34.0,31.34,30.31,29.78,28.03,25.62,25.09,26.88,27.75,27.41,27.31,29.38,31.16,30.84,30.22,31.66,33.06,31.72,28.81,4.31,5.16,6.25,9.03,11.88,13.12,14.19,16.22,17.78,17.28,15.28,14.66,14.06,12.81,10.75,9.84,10.59,10.53,9.16,8.41,9.0:14.69,15.41,13.5,10.16,8.0,8.81,9.16,8.31,8.22,10.25,11.03,9.16,6.19,5.06,4.53,2.34,-0.69,-1.34,0.19,0.81,0.06,1.44,5.0,7.72,8.69,9.22,11.59,13.22,12.25,10.81,11.72,12.97,12.22,10.5,10.41,11.38,11.12,9.44,8.94,10.5,11.19,9.28,7.94,8.69,9.09,7.47,5.16,5.19,6.41,6.28,5.75,6.88,9.81,11.28,10.75,10.72,12.66,13.09,11.41,9.75,11.22,12.81,12.91,12.38,13.69,14.97,13.81,11.0,9.56,10.06,9.38,7.81,7.56,9.66,11.25,10.72,10.97,14.22,17.81,19.72,20.91,24.09,27.62,28.41,27.41,27.28,27.75,25.94,21.72,18.47,16.47,13.75,8.97,4.62,3.62,3.66,2.81,1.56,3.06,5.47,5.97,5.44,6.31,8.88,10.44,10.22,10.69,13.34,15.34,14.66,13.25,14.09,14.53,12.25,8.97,7.56,6.53,3.56,-0.16,-2.5,-2.81,-4.19,-6.66,-7.72,-5.97,-3.91,-3.66,-2.88,0.5,3.88,5.75,6.28,8.84,12.09,13.62,13.81,15.66,19.06,20.78,19.62,18.28,18.22,16.5,12.84,9.0,7.75,7.69,5.94,3.41,3.22,3.78,2.53,0.34,0.44,3.09,5.91,7.22,9.66,13.88,16.91,17.03,16.94,18.59,20.25,19.62,17.84,17.28,17.75,16.5,14.03,12.97,13.75,14.03,12.88,12.53,14.94,16.62,15.47,13.5,13.03,13.03,11.38,9.09,9.25,10.69,10.62,8.66,7.59,8.66,8.25,6.12,5.03,6.56,8.34,8.25,8.03,9.5,10.59,9.62,7.47,7.19,8.5,8.34,6.69,6.06,7.41,7.66,5.72,4.44,5.88,7.34,7.09,6.91,8.88,11.41,12.25,11.84,13.62,16.25,17.34,16.38,16.34,17.84,18.94,17.94,16.81,18.0,18.12,15.84,12.47,11.59,11.69,10.72,9.19,9.28,10.28,10.34,8.44,8.47,10.62,12.78,12.66,12.25,13.97,15.44,14.84,14.0,15.78,17.94,17.88,16.19,16.12,17.25,17.31,15.75,15.88,17.91,19.19,17.97,17.03,18.06,18.78,17.69,15.62,15.88,16.72,16.47,15.62,16.72,19.22,20.84,20.12,19.81,21.53,22.5,21.0,19.34,19.47,19.25,17.25,14.69,14.06,14.81,13.94,11.75,10.94,11.72,11.81,10.03,10.0,12.69,15.66,16.66,17.97,21.62,24.81,25.62,25.28,26.25,26.75,25.06,21.22,17.88,15.88,12.81,7.88,4.03,3.19,3.06,1.66,1.25,4.0,7.0,8.19,8.56,10.12,12.31,12.38,10.69,10.0,11.0,11.38,10.06,9.31,10.84,12.19,10.72,9.34,10.34,11.06,10.0,8.16,8.44,10.06,10.38,9.66,10.25,12.28,13.12,11.5,10.31,10.75,10.88,8.91,6.88,7.94,9.75,9.91,9.38,10.38,11.94,11.34,8.69,7.25,7.69,8.25,7.03,6.62,8.56,10.25,9.34,7.97,8.62,9.53,8.34,6.28,5.97,6.84,6.56,4.41,3.53,4.97,5.25,3.28,1.69,2.38,3.44,2.72,2.16,3.66,5.5,5.19,3.38,3.59,4.81,5.16,3.91,3.66,5.09,5.31,2.94,0.78,0.41,0.53,-0.75,-2.03,-0.72,1.53,2.09,1.22,1.59,3.38,4.38,3.88,5.22,9.25,13.22,15.19,17.06,20.38,22.88,21.88,19.41,18.62,18.41,17.22,14.78,14.28,14.75,13.62,9.88,6.16,4.34,2.41,-1.31,-4.0,-3.69,-2.38,-2.41,-2.41,-0.19,3.19,4.84,4.97,6.75,9.28,10.97,10.66,10.75,12.28,12.56,10.56,8.44,8.31,8.97,8.03,6.72,7.28,9.06,8.91,7.44,7.09,7.31,6.38,3.56,1.56,2.09,3.31,2.59,2.75,4.78,7.66,8.31,8.22,9.56,11.62,11.81,10.28,10.25,11.91,13.28,12.56,12.44,14.09,14.66,12.31,9.19,7.94,6.97,3.94,0.69,0.03,0.81,0.75,-0.5,-0.41,1.34,2.47,1.69,1.75,4.12,5.91,5.19,4.19,4.94,6.53,6.25,5.38,6.44,8.56,9.0,7.5,6.38,6.0,4.53,0.19,-3.44,-5.09,-6.41,-9.38,-12.12,-12.09,-10.5,-10.0,-9.53,-6.72,-2.62,0.47,1.22,2.31,4.84,6.03,4.19,2.91,3.91,4.84,3.5,1.78,1.69,2.03,0.19,-2.44,-3.19,-2.31,-2.34,-3.56,-2.88,-0.22,1.72,1.59,1.81,3.84,6.19,6.78,7.44,9.88,12.78,12.78,11.06,9.47,8.72,6.31,2.56,0.38,0.88,2.34,1.97,1.78,3.44,4.0,2.03,-1.28,-2.81,-2.97,-4.41,-6.47,-6.38,-4.41,-3.19,-3.38,-2.06,1.41,5.06,6.38,7.91,11.38,14.06,13.44,11.84,11.31,11.59,10.62,9.03,9.72,12.47,14.12,13.59,13.88,14.84,15.09,12.62,10.81,10.94,12.62,12.16,10.91,11.25,12.12,10.97,8.72,8.44,10.03,11.94,12.5,14.41,17.72,20.47,19.75,18.22,17.88,17.28,14.25,10.09,7.94,6.81,4.5,1.75,1.59,3.34,4.5,3.91,4.12,6.53,9.12,9.28,9.5,11.16,12.78,11.75,9.72,9.44,10.75,10.84,9.59,9.75,11.25,11.88,10.47,9.5,10.66,11.88,10.75,9.94,10.81,12.72,12.75,11.34,10.78,10.72,8.69,4.62,1.69,1.28,1.47,0.31,0.88,4.47,8.5,10.12,11.22,13.28,15.19,14.12,11.34,9.91,9.34,7.56,4.47,2.72,3.0,2.97,1.06,-0.03,1.0,2.75,2.75,3.5,6.47,10.59,12.38,11.91,11.62,10.94,7.78,2.25,-2.16,-3.94,-5.22,-7.25,-7.91,-5.75,-2.38,-0.94,0.62,4.09,8.62,11.69,13.19,15.78,19.03,20.22,18.12,15.31,13.56,10.47,5.19,0.38,-1.25,-1.78,-3.84,-6.0,-6.34,-5.81,-7.59,-10.28,-11.72,-11.38,-11.78,-13.12,-13.56,-11.19,-9.47,-9.78,-10.09,-8.88,-7.28,-7.91,-8.34,-7.09,-4.03,-2.72,-2.47,-0.75,2.69,5.5,7.31,9.88,14.53,18.31,18.56,17.81,17.84,17.59,14.03,9.31,6.16,4.62,1.97,-1.06,-2.0,-0.66,-0.19,-1.62,-2.94,-2.16,-1.97,-4.03,-6.03,-5.59,-4.41,-5.09,-6.22,-5.5,-2.84,-1.34,-0.56,2.0,6.28,9.22,9.66,10.22,12.28,13.16,11.56,9.47,8.59,7.62,4.62,1.41,-0.03,0.88,1.22,0.81,2.12,5.25,7.28,6.75,6.0,6.44,5.84,3.66,1.44,2.5,5.0,6.44,7.38,9.22,11.62,11.0,8.19,5.62,5.16,3.56,0.31,-2.25,-2.12,-2.22,-4.0,-5.53,-4.91,-2.72,-1.97,-1.44,0.53,4.03,5.47,5.44,6.22,9.0,11.31,11.72,12.12,13.44,13.91,10.59,5.75,2.47,0.38,-2.84,-5.94,-6.66,-5.75,-5.78,-7.16,-8.0,-6.84,-5.5,-5.81,-5.16,-1.69,2.41,4.59,6.19,8.94,12.12,13.03,12.31,12.03,12.53,11.25,7.94,5.16,5.03,5.09,3.88,3.44,5.19,7.38,6.88,5.44,5.09,5.44,4.59,2.97,2.88,5.0,5.78,4.44,3.5,4.81,5.41,4.25,3.41,4.62,5.44,3.62,1.22,0.12,0.38,-0.25,-1.5,-1.19,1.84,4.62,5.72,7.88,12.38,16.06,17.25,17.66,19.03,19.66,17.5,13.53,10.84,9.56,6.91,3.69,1.88,2.44,2.44,0.81,-0.06,1.28,2.59,1.34,0.19,1.25,3.09,2.88,2.25,2.75,4.41,4.19,2.34,1.47,2.25,2.06,0.59,-0.22,1.41,3.22,3.38,3.22,5.34,7.97,8.88,8.38,8.84,10.06,9.22,6.97,5.56,6.06,5.59,3.62,1.78,3.16,4.97,5.06,5.16,7.22,9.91,10.16,9.47,10.41,12.78,13.44,12.66,13.03,15.16,16.41,15.56,14.88,16.0,17.0,15.44,13.38,13.56,14.5,13.91,12.75,12.66,13.59,13.19,10.56,8.78,9.59,9.62,7.38,5.0,4.44,3.81,1.16,-1.72,-2.53,-2.34,-3.22,-4.41,-4.03,-1.38,1.09,2.16,4.19,8.75,12.22,12.91,13.0,14.69,16.0,15.19,13.41,13.56,14.84,14.53,13.56,14.28,16.44,17.59,16.66,15.75,16.84,17.69,16.47,15.38,16.47,17.62,16.44,14.06,13.34,13.25,11.91,9.41,8.25,8.97,9.12,7.66,7.16,9.22,11.22,12.03,12.78,16.06,19.81,21.47,22.12,24.0,26.38,26.91,25.62,24.94,26.03,26.38,24.97,23.94,24.53,24.22,20.81,16.47,14.81,14.5,13.59,12.94,14.56,17.88,19.78,20.03,21.12,23.75,25.25,24.75,24.03,25.5,26.25,24.56,21.72,21.06,20.84,19.25,17.31,17.75,19.94,21.12,20.97,21.41,23.41,24.09,22.56,21.22,22.16,23.06,22.25,20.56,20.53,20.81,19.66,17.66,17.28,18.91,19.75,19.34,19.66,21.78,22.88,21.38,19.53,20.28,21.84,21.84,21.56,23.53,25.53,25.16,23.25,22.53,23.06,22.66,21.59,21.81,24.75,28.03,29.62,30.69,33.38,35.22,34.0,31.34,30.31,29.78,28.03,25.62,25.09,26.88,27.75,27.41,27.31,29.38,31.16,30.84,30.22,31.66,33.06,31.72,28.81,4.31,5.16,6.25,9.03,11.88,13.12,14.19,16.22,17.78,17.28,15.28,14.66,14.06,12.81,10.75,9.84,10.59,10.53,9.16,8.41,9.0,9.69,9.16,8.56,10.22,12.12,12.47,11.94:8.31,8.22,10.25,11.03,9.16,6.19,5.06,4.53,2.34,-0.69,-1.34,0.19,0.81,0.06,1.44,5.0,7.72,8.69,9.22,11.59,13.22,12.25,10.81,11.72,12.97,12.22,10.5,10.41,11.38,11.12,9.44,8.94,10.5,11.19,9.28,7.94,8.69,9.09,7.47,5.16,5.19,6.41,6.28,5.75,6.88,9.81,11.28,10.75,10.72,12.66,13.09,11.41,9.75,11.22,12.81,12.91,12.38,13.69,14.97,13.81,11.0,9.56,10.06,9.38,7.81,7.56,9.66,11.25,10.72,10.97,14.22,17.81,19.72,20.91,24.09,27.62,28.41,27.41,27.28,27.75,25.94,21.72,18.47,16.47,13.75,8.97,4.62,3.62,3.66,2.81,1.56,3.06,5.47,5.97,5.44,6.31,8.88,10.44,10.22,10.69,13.34,15.34,14.66,13.25,14.09,14.53,12.25,8.97,7.56,6.53,3.56,-0.16,-2.5,-2.81,-4.19,-6.66,-7.72,-5.97,-3.91,-3.66,-2.88,0.5,3.88,5.75,6.28,8.84,12.09,13.62,13.81,15.66,19.06,20.78,19.62,18.28,18.22,16.5,12.84,9.0,7.75,7.69,5.94,3.41,3.22,3.78,2.53,0.34,0.44,3.09,5.91,7.22,9.66,13.88,16.91,17.03,16.94,18.59,20.25,19.62,17.84,17.28,17.75,16.5,14.03,12.97,13.75,14.03,12.88,12.53,14.94,16.62,15.47,13.5,13.03,13.03,11.38,9.09,9.25,10.69,10.62,8.66,7.59,8.66,8.25,6.12,5.03,6.56,8.34,8.25,8.03,9.5,10.59,9.62,7.47,7.19,8.5,8.34,6.69,6.06,7.41,7.66,5.72,4.44,5.88,7.34,7.09,6.91,8.88,11.41,12.25,11.84,13.62,16.25,17.34,16.38,16.34,17.84,18.94,17.94,16.81,18.0,18.12,15.84,12.47,11.59,11.69,10.72,9.19,9.28,10.28,10.34,8.44,8.47,10.62,12.78,12.66,12.25,13.97,15.44,14.84,14.0,15.78,17.94,17.88,16.19,16.12,17.25,17.31,15.75,15.88,17.91,19.19,17.97,17.03,18.06,18.78,17.69,15.62,15.88,16.72,16.47,15.62,16.72,19.22,20.84,20.12,19.81,21.53,22.5,21.0,19.34,19.47,19.25,17.25,14.69,14.06,14.81,13.94,11.75,10.94,11.72,11.81,10.03,10.0,12.69,15.66,16.66,17.97,21.62,24.81,25.62,25.28,26.25,26.75,25.06,21.22,17.88,15.88,12.81,7.88,4.03,3.19,3.06,1.66,1.25,4.0,7.0,8.19,8.56,10.12,12.31,12.38,10.69,10.0,11.0,11.38,10.06,9.31,10.84,12.19,10.72,9.34,10.34,11.06,10.0,8.16,8.44,10.06,10.38,9.66,10.25,12.28,13.12,11.5,10.31,10.75,10.88,8.91,6.88,7.94,9.75,9.91,9.38,10.38,11.94,11.34,8.69,7.25,7.69,8.25,7.03,6.62,8.56,10.25,9.34,7.97,8.62,9.53,8.34,6.28,5.97,6.84,6.56,4.41,3.53,4.97,5.25,3.28,1.69,2.38,3.44,2.72,2.16,3.66,5.5,5.19,3.38,3.59,4.81,5.16,3.91,3.66,5.09,5.31,2.94,0.78,0.41,0.53,-0.75,-2.03,-0.72,1.53,2.09,1.22,1.59,3.38,4.38,3.88,5.22,9.25,13.22,15.19,17.06,20.38,22.88,21.88,19.41,18.62,18.41,17.22,14.78,14.28,14.75,13.62,9.88,6.16,4.34,2.41,-1.31,-4.0,-3.69,-2.38,-2.41,-2.41,-0.19,3.19,4.84,4.97,6.75,9.28,10.97,10.66,10.75,12.28,12.56,10.56,8.44,8.31,8.97,8.03,6.72,7.28,9.06,8.91,7.44,7.09,7.31,6.38,3.56,1.56,2.09,3.31,2.59,2.75,4.78,7.66,8.31,8.22,9.56,11.62,11.81,10.28,10.25,11.91,13.28,12.56,12.44,14.09,14.66,12.31,9.19,7.94,6.97,3.94,0.69,0.03,0.81,0.75,-0.5,-0.41,1.34,2.47,1.69,1.75,4.12,5.91,5.19,4.19,4.94,6.53,6.25,5.38,6.44,8.56,9.0,7.5,6.38,6.0,4.53,0.19,-3.44,-5.09,-6.41,-9.38,-12.12,-12.09,-10.5,-10.0,-9.53,-6.72,-2.62,0.47,1.22,2.31,4.84,6.03,4.19,2.91,3.91,4.84,3.5,1.78,1.69,2.03,0.19,-2.44,-3.19,-2.31,-2.34,-3.56,-2.88,-0.22,1.72,1.59,1.81,3.84,6.19,6.78,7.44,9.88,12.78,12.78,11.06,9.47,8.72,6.31,2.56,0.38,0.88,2.34,1.97,1.78,3.44,4.0,2.03,-1.28,-2.81,-2.97,-4.41,-6.47,-6.38,-4.41,-3.19,-3.38,-2.06,1.41,5.06,6.38,7.91,11.38,14.06,13.44,11.84,11.31,11.59,10.62,9.03,9.72,12.47,14.12,13.59,13.88,14.84,15.09,12.62,10.81,10.94,12.62,12.16,10.91,11.25,12.12,10.97,8.72,8.44,10.03,11.94,12.5,14.41,17.72,20.47,19.75,18.22,17.88,17.28,14.25,10.09,7.94,6.81,4.5,1.75,1.59,3.34,4.5,3.91,4.12,6.53,9.12,9.28,9.5,11.16,12.78,11.75,9.72,9.44,10.75,10.84,9.59,9.75,11.25,11.88,10.47,9.5,10.66,11.88,10.75,9.94,10.81,12.72,12.75,11.34,10.78,10.72,8.69,4.62,1.69,1.28,1.47,0.31,0.88,4.47,8.5,10.12,11.22,13.28,15.19,14.12,11.34,9.91,9.34,7.56,4.47,2.72,3.0,2.97,1.06,-0.03,1.0,2.75,2.75,3.5,6.47,10.59,12.38,11.91,11.62,10.94,7.78,2.25,-2.16,-3.94,-5.22,-7.25,-7.91,-5.75,-2.38,-0.94,0.62,4.09,8.62,11.69,13.19,15.78,19.03,20.22,18.12,15.31,13.56,10.47,5.19,0.38,-1.25,-1.78,-3.84,-6.0,-6.34,-5.81,-7.59,-10.28,-11.72,-11.38,-11.78,-13.12,-13.56,-11.19,-9.47,-9.78,-10.09,-8.88,-7.28,-7.91,-8.34,-7.09,-4.03,-2.72,-2.47,-0.75,2.69,5.5,7.31,9.88,14.53,18.31,18.56,17.81,17.84,17.59,14.03,9.31,6.16,4.62,1.97,-1.06,-2.0,-0.66,-0.19,-1.62,-2.94,-2.16,-1.97,-4.03,-6.03,-5.59,-4.41,-5.09,-6.22,-5.5,-2.84,-1.34,-0.56,2.0,6.28,9.22,9.66,10.22,12.28,13.16,11.56,9.47,8.59,7.62,4.62,1.41,-0.03,0.88,1.22,0.81,2.12,5.25,7.28,6.75,6.0,6.44,5.84,3.66,1.44,2.5,5.0,6.44,7.38,9.22,11.62,11.0,8.19,5.62,5.16,3.56,0.31,-2.25,-2.12,-2.22,-4.0,-5.53,-4.91,-2.72,-1.97,-1.44,0.53,4.03,5.47,5.44,6.22,9.0,11.31,11.72,12.12,13.44,13.91,10.59,5.75,2.47,0.38,-2.84,-5.94,-6.66,-5.75,-5.78,-7.16,-8.0,-6.84,-5.5,-5.81,-5.16,-1.69,2.41,4.59,6.19,8.94,12.12,13.03,12.31,12.03,12.53,11.25,7.94,5.16,5.03,5.09,3.88,3.44,5.19,7.38,6.88,5.44,5.09,5.44,4.59,2.97,2.88,5.0,5.78,4.44,3.5,4.81,5.41,4.25,3.41,4.62,5.44,3.62,1.22,0.12,0.38,-0.25,-1.5,-1.19,1.84,4.62,5.72,7.88,12.38,16.06,17.25,17.66,19.03,19.66,17.5,13.53,10.84,9.56,6.91,3.69,1.88,2.44,2.44,0.81,-0.06,1.28,2.59,1.34,0.19,1.25,3.09,2.88,2.25,2.75,4.41,4.19,2.34,1.47,2.25,2.06,0.59,-0.22,1.41,3.22,3.38,3.22,5.34,7.97,8.88,8.38,8.84,10.06,9.22,6.97,5.56,6.06,5.59,3.62,1.78,3.16,4.97,5.06,5.16,7.22,9.91,10.16,9.47,10.41,12.78,13.44,12.66,13.03,15.16,16.41,15.56,14.88,16.0,17.0,15.44,13.38,13.56,14.5,13.91,12.75,12.66,13.59,13.19,10.56,8.78,9.59,9.62,7.38,5.0,4.44,3.81,1.16,-1.72,-2.53,-2.34,-3.22,-4.41,-4.03,-1.38,1.09,2.16,4.19,8.75,12.22,12.91,13.0,14.69,16.0,15.19,13.41,13.56,14.84,14.53,13.56,14.28,16.44,17.59,16.66,15.75,16.84,17.69,16.47,15.38,16.47,17.62,16.44,14.06,13.34,13.25,11.91,9.41,8.25,8.97,9.12,7.66,7.16,9.22,11.22,12.03,12.78,16.06,19.81,21.47,22.12,24.0,26.38,26.91,25.62,24.94,26.03,26.38,24.97,23.94,24.53,24.22,20.81,16.47,14.81,14.5,13.59,12.94,14.56,17.88,19.78,20.03,21.12,23.75,25.25,24.75,24.03,25.5,26.25,24.56,21.72,21.06,20.84,19.25,17.31,17.75,19.94,21.12,20.97,21.41,23.41,24.09,22.56,21.22,22.16,23.06,22.25,20.56,20.53,20.81,19.66,17.66,17.28,18.91,19.75,19.34,19.66,21.78,22.88,21.38,19.53,20.28,21.84,21.84,21.56,23.53,25.53,25.16,23.25,22.53,23.06,22.66,21.59,21.81,24.75,28.03,29.62,30.69,33.38,35.22,34.0,31.34,30.31,29.78,28.03,25.62,25.09,26.88,27.75,27.41,27.31,29.38,31.16,30.84,30.22,31.66,33.06,31.72,28.81,4.31,5.16,6.25,9.03,11.88,13.12,14.19,16.22,17.78,17.28,15.28,14.66,14.06,12.81,10.75,9.84,10.59,10.53,9.16,8.41,9.0,9.69,9.16,8.56,10.22,12.12,12.47,11.94,11.97,12.12,10.66,7.75,6.12,6.22,5.97:4.53,2.34,-0.69,-1.34,0.19,0.81,0.06,1.44,5.0,7.72,8.69,9.22,11.59,13.22,12.25,10.81,11.72,12.97,12.22,10.5,10.41,11.38,11.12,9.44,8.94,10.5,11.19,9.28,7.94,8.69,9.09,7.47,5.16,5.19,6.41,6.28,5.75,6.88,9.81,11.28,10.75,10.72,12.66,13.09,11.41,9.75,11.22,12.81,12.91,12.38,13.69,14.97,13.81,11.0,9.56,10.06,9.38,7.81,7.56,9.66,11.25,10.72,10.97,14.22,17.81,19.72,20.91,24.09,27.62,28.41,27.41,27.28,27.75,25.94,21.72,18.47,16.47,13.75,8.97,4.62,3.62,3.66,2.81,1.56,3.06,5.47,5.97,5.44,6.31,8.88,10.44,10.22,10.69,13.34,15.34,14.66,13.25,14.09,14.53,12.25,8.97,7.56,6.53,3.56,-0.16,-2.5,-2.81,-4.19,-6.66,-7.72,-5.97,-3.91,-3.66,-2.88,0.5,3.88,5.75,6.28,8.84,12.09,13.62,13.81,15.66,19.06,20.78,19.62,18.28,18.22,16.5,12.84,9.0,7.75,7.69,5.94,3.41,3.22,3.78,2.53,0.34,0.44,3.09,5.91,7.22,9.66,13.88,16.91,17.03,16.94,18.59,20.25,19.62,17.84,17.28,17.75,16.5,14.03,12.97,13.75,14.03,12.88,12.53,14.94,16.62,15.47,13.5,13.03,13.03,11.38,9.09,9.25,10.69,10.62,8.66,7.59,8.66,8.25,6.12,5.03,6.56,8.34,8.25,8.03,9.5,10.59,9.62,7.47,7.19,8.5,8.34,6.69,6.06,7.41,7.66,5.72,4.44,5.88,7.34,7.09,6.91,8.88,11.41,12.25,11.84,13.62,16.25,17.34,16.38,16.34,17.84,18.94,17.94,16.81,18.0,18.12,15.84,12.47,11.59,11.69,10.72,9.19,9.28,10.28,10.34,8.44,8.47,10.62,12.78,12.66,12.25,13.97,15.44,14.84,14.0,15.78,17.94,17.88,16.19,16.12,17.25,17.31,15.75,15.88,17.91,19.19,17.97,17.03,18.06,18.78,17.69,15.62,15.88,16.72,16.47,15.62,16.72,19.22,20.84,20.12,19.81,21.53,22.5,21.0,19.34,19.47,19.25,17.25,14.69,14.06,14.81,13.94,11.75,10.94,11.72,11.81,10.03,10.0,12.69,15.66,16.66,17.97,21.62,24.81,25.62,25.28,26.25,26.75,25.06,21.22,17.88,15.88,12.81,7.88,4.03,3.19,3.06,1.66,1.25,4.0,7.0,8.19,8.56,10.12,12.31,12.38,10.69,10.0,11.0,11.38,10.06,9.31,10.84,12.19,10.72,9.34,10.34,11.06,10.0,8.16,8.44,10.06,10.38,9.66,10.25,12.28,13.12,11.5,10.31,10.75,10.88,8.91,6.88,7.94,9.75,9.91,9.38,10.38,11.94,11.34,8.69,7.25,7.69,8.25,7.03,6.62,8.56,10.25,9.34,7.97,8.62,9.53,8.34,6.28,5.97,6.84,6.56,4.41,3.53,4.97,5.25,3.28,1.69,2.38,3.44,2.72,2.16,3.66,5.5,5.19,3.38,3.59,4.81,5.16,3.91,3.66,5.09,5.31,2.94,0.78,0.41,0.53,-0.75,-2.03,-0.72,1.53,2.09,1.22,1.59,3.38,4.38,3.88,5.22,9.25,13.22,15.19,17.06,20.38,22.88,21.88,19.41,18.62,18.41,17.22,14.78,14.28,14.75,13.62,9.88,6.16,4.34,2.41,-1.31,-4.0,-3.69,-2.38,-2.41,-2.41,-0.19,3.19,4.84,4.97,6.75,9.28,10.97,10.66,10.75,12.28,12.56,10.56,8.44,8.31,8.97,8.03,6.72,7.28,9.06,8.91,7.44,7.09,7.31,6.38,3.56,1.56,2.09,3.31,2.59,2.75,4.78,7.66,8.31,8.22,9.56,11.62,11.81,10.28,10.25,11.91,13.28,12.56,12.44,14.09,14.66,12.31,9.19,7.94,6.97,3.94,0.69,0.03,0.81,0.75,-0.5,-0.41,1.34,2.47,1.69,1.75,4.12,5.91,5.19,4.19,4.94,6.53,6.25,5.38,6.44,8.56,9.0,7.5,6.38,6.0,4.53,0.19,-3.44,-5.09,-6.41,-9.38,-12.12,-12.09,-10.5,-10.0,-9.53,-6.72,-2.62,0.47,1.22,2.31,4.84,6.03,4.19,2.91,3.91,4.84,3.5,1.78,1.69,2.03,0.19,-2.44,-3.19,-2.31,-2.34,-3.56,-2.88,-0.22,1.72,1.59,1.81,3.84,6.19,6.78,7.44,9.88,12.78,12.78,11.06,9.47,8.72,6.31,2.56,0.38,0.88,2.34,1.97,1.78,3.44,4.0,2.03,-1.28,-2.81,-2.97,-4.41,-6.47,-6.38,-4.41,-3.19,-3.38,-2.06,1.41,5.06,6.38,7.91,11.38,14.06,13.44,11.84,11.31,11.59,10.62,9.03,9.72,12.47,14.12,13.59,13.88,14.84,15.09,12.62,10.81,10.94,12.62,12.16,10.91,11.25,12.12,10.97,8.72,8.44,10.03,11.94,12.5,14.41,17.72,20.47,19.75,18.22,17.88,17.28,14.25,10.09,7.94,6.81,4.5,1.75,1.59,3.34,4.5,3.91,4.12,6.53,9.12,9.28,9.5,11.16,12.78,11.75,9.72,9.44,10.75,10.84,9.59,9.75,11.25,11.88,10.47,9.5,10.66,11.88,10.75,9.94,10.81,12.72,12.75,11.34,10.78,10.72,8.69,4.62,1.69,1.28,1.47,0.31,0.88,4.47,8.5,10.12,11.22,13.28,15.19,14.12,11.34,9.91,9.34,7.56,4.47,2.72,3.0,2.97,1.06,-0.03,1.0,2.75,2.75,3.5,6.47,10.59,12.38,11.91,11.62,10.94,7.78,2.25,-2.16,-3.94,-5.22,-7.25,-7.91,-5.75,-2.38,-0.94,0.62,4.09,8.62,11.69,13.19,15.78,19.03,20.22,18.12,15.31,13.56,10.47,5.19,0.38,-1.25,-1.78,-3.84,-6.0,-6.34,-5.81,-7.59,-10.28,-11.72,-11.38,-11.78,-13.12,-13.56,-11.19,-9.47,-9.78,-10.09,-8.88,-7.28,-7.91,-8.34,-7.09,-4.03,-2.72,-2.47,-0.75,2.69,5.5,7.31,9.88,14.53,18.31,18.56,17.81,17.84,17.59,14.03,9.31,6.16,4.62,1.97,-1.06,-2.0,-0.66,-0.19,-1.62,-2.94,-2.16,-1.97,-4.03,-6.03,-5.59,-4.41,-5.09,-6.22,-5.5,-2.84,-1.34,-0.56,2.0,6.28,9.22,9.66,10.22,12.28,13.16,11.56,9.47,8.59,7.62,4.62,1.41,-0.03,0.88,1.22,0.81,2.12,5.25,7.28,6.75,6.0,6.44,5.84,3.66,1.44,2.5,5.0,6.44,7.38,9.22,11.62,11.0,8.19,5.62,5.16,3.56,0.31,-2.25,-2.12,-2.22,-4.0,-5.53,-4.91,-2.72,-1.97,-1.44,0.53,4.03,5.47,5.44,6.22,9.0,11.31,11.72,12.12,13.44,13.91,10.59,5.75,2.47,0.38,-2.84,-5.94,-6.66,-5.75,-5.78,-7.16,-8.0,-6.84,-5.5,-5.81,-5.16,-1.69,2.41,4.59,6.19,8.94,12.12,13.03,12.31,12.03,12.53,11.25,7.94,5.16,5.03,5.09,3.88,3.44,5.19,7.38,6.88,5.44,5.09,5.44,4.59,2.97,2.88,5.0,5.78,4.44,3.5,4.81,5.41,4.25,3.41,4.62,5.44,3.62,1.22,0.12,0.38,-0.25,-1.5,-1.19,1.84,4.62,5.72,7.88,12.38,16.06,17.25,17.66,19.03,19.66,17.5,13.53,10.84,9.56,6.91,3.69,1.88,2.44,2.44,0.81,-0.06,1.28,2.59,1.34,0.19,1.25,3.09,2.88,2.25,2.75,4.41,4.19,2.34,1.47,2.25,2.06,0.59,-0.22,1.41,3.22,3.38,3.22,5.34,7.97,8.88,8.38,8.84,10.06,9.22,6.97,5.56,6.06,5.59,3.62,1.78,3.16,4.97,5.06,5.16,7.22,9.91,10.16,9.47,10.41,12.78,13.44,12.66,13.03,15.16,16.41,15.56,14.88,16.0,17.0,15.44,13.38,13.56,14.5,13.91,12.75,12.66,13.59,13.19,10.56,8.78,9.59,9.62,7.38,5.0,4.44,3.81,1.16,-1.72,-2.53,-2.34,-3.22,-4.41,-4.03,-1.38,1.09,2.16,4.19,8.75,12.22,12.91,13.0,14.69,16.0,15.19,13.41,13.56,14.84,14.53,13.56,14.28,16.44,17.59,16.66,15.75,16.84,17.69,16.47,15.38,16.47,17.62,16.44,14.06,13.34,13.25,11.91,9.41,8.25,8.97,9.12,7.66,7.16,9.22,11.22,12.03,12.78,16.06,19.81,21.47,22.12,24.0,26.38,26.91,25.62,24.94,26.03,26.38,24.97,23.94,24.53,24.22,20.81,16.47,14.81,14.5,13.59,12.94,14.56,17.88,19.78,20.03,21.12,23.75,25.25,24.75,24.03,25.5,26.25,24.56,21.72,21.06,20.84,19.25,17.31,17.75,19.94,21.12,20.97,21.41,23.41,24.09,22.56,21.22,22.16,23.06,22.25,20.56,20.53,20.81,19.66,17.66,17.28,18.91,19.75,19.34,19.66,21.78,22.88,21.38,19.53,20.28,21.84,21.84,21.56,23.53,25.53,25.16,23.25,22.53,23.06,22.66,21.59,21.81,24.75,28.03,29.62,30.69,33.38,35.22,34.0,31.34,30.31,29.78,28.03,25.62,25.09,26.88,27.75,27.41,27.31,29.38,31.16,30.84,30.22,31.66,33.06,31.72,28.81,4.31,5.16,6.25,9.03,11.88,13.12,14.19,16.22,17.78,17.28,15.28,14.66,14.06,12.81,10.75,9.84,10.59,10.53,9.16,8.41,9.0,9.69,9.16,8.56,10.22,12.12,12.47,11.94,11.97,12.12,10.66,7.75,6.12,6.22,5.97,5.62,5.53,7.19,7.78,6.62,4.91,4.5:positivity
30.66,28.25,25.25,24.78,25.38,23.94,21.84,22.06,23.69,23.84,22.47,22.69,25.78,27.97,28.25,28.69,31.59,34.41,34.47,33.22,33.81,34.69,33.06,29.94,28.56,29.22,28.62,26.41,25.25,27.0,28.38,27.34,26.34,28.03,30.41,30.66,29.62,30.72,33.16,33.69,32.34,32.53,34.88,35.97,34.56,33.94,35.75,37.22,36.62,35.31,36.31,37.91,37.38,35.38,35.56,37.06,37.19,35.31,34.75,36.5,37.91,37.31,37.47,39.81,42.19,42.12,41.0,41.56,43.03,43.12,41.5,41.16,42.88,42.75,39.97,37.94,38.28,38.72,37.28,35.78,36.91,38.38,37.59,35.38,34.59,35.22,34.44,31.72,30.22,31.25,31.38,29.03,27.53,28.62,30.22,29.91,29.53,31.5,34.12,34.5,33.0,32.84,34.22,34.97,33.47,33.09,34.75,35.97,34.28,32.94,34.12,35.56,34.88,32.66,32.47,33.22,32.31,29.31,28.25,29.38,30.12,29.28,29.28,32.31,35.38,36.19,36.25,38.5,40.75,40.22,38.12,37.62,38.41,38.19,36.12,35.38,37.09,38.62,37.84,37.5,39.69,42.12,42.12,41.19,41.81,42.72,41.34,37.81,36.41,37.25,37.78,36.41,36.62,39.25,41.41,40.94,40.0,40.59,41.81,40.12,37.41,36.38,36.75,35.56,32.91,32.31,34.19,36.41,36.12,36.16,38.16,39.94,38.41,36.41,36.72,37.97,38.06,37.06,38.06,40.69,41.69,40.28,39.81,41.84,44.06,44.28,44.19,46.03,47.72,46.44,44.16,44.19,45.69,45.84,45.19,45.75,47.91,48.91,47.41,46.62,48.12,50.22,49.97,49.66,51.25,53.44,53.03,51.25,51.44,52.88,52.88,50.56,48.88,48.75,47.66,44.22,41.22,40.78,42.56,42.38,42.09,43.5,46.03,45.88,43.94,43.47,44.88,45.34,43.38,41.59,42.06,42.0,39.53,36.59,36.16,36.84,35.22,33.16,33.09,35.19,35.91,35.78,36.81,39.56,41.19,40.28,38.97,40.16,41.5,40.78,39.97,40.66,42.03,40.78,37.47,34.97,34.41,33.5,31.44,30.91,33.03,34.88,34.25,33.38,34.78,36.97,37.38,37.06,38.56,41.53,42.75,42.44,42.72,44.97,45.72,43.75,42.34,43.12,43.72,41.91,39.44,38.5,37.62,35.25,32.0,31.91,34.94,38.38,40.88,44.5,50.12,53.81,54.53,54.5,56.22,58.03,57.47,55.31,54.78,55.0,53.0,49.38,46.84,46.34,44.84,41.66,38.91,39.5,39.88,38.41,36.91,37.75,39.03,37.97,36.16,36.16,37.62,37.84,36.19,35.22,36.22,36.41,34.69,32.94,33.78,34.56,32.59,29.47,28.25,27.84,25.56,21.75,19.84,20.0,19.5,17.78,17.72,20.66,23.97,25.09,25.69,28.03,30.19,29.94,28.12,28.16,30.03,30.53,29.28,28.94,29.88,29.38,26.16,22.62,22.06,22.19,21.16,19.91,21.34,24.5,25.72,25.81,27.47,30.91,32.62,32.28,32.66,35.81,38.56,38.84,38.38,39.16,39.59,36.97,33.25,31.78,31.81,30.97,28.75,28.56,30.38,31.69,30.44,29.97,31.53,33.34,33.31,33.03,35.0,37.38,37.69,36.22,36.78,38.28,39.38,38.47,38.41,40.16,41.16,39.31,37.19,37.06,37.66,36.16,34.25,35.06,37.47,38.53,37.84,38.53,39.69,39.69,37.09,34.72,35.0,35.56,34.06,32.69,34.0,36.5,37.91,38.59,40.62,44.12,45.53,44.06,42.56,42.72,41.88,38.38,35.78,36.0,37.25,37.03,35.84,37.09,38.91,38.88,37.66,37.78,39.59,40.47,38.66,37.0,37.25,37.12,34.16,31.44,31.53,32.78,32.44,31.44,32.31,34.91,35.69,34.28,34.81,37.44,39.19,38.41,37.81,39.12,39.94,38.06,35.91,36.34,37.97,37.59,35.75,35.41,36.62,36.34,34.44,34.09,36.06,37.38,35.81,33.91,34.19,34.81,33.31,31.47,31.44,32.94,32.5,30.31,29.62,31.25,32.38,31.25,30.75,32.56,34.0,32.81,31.0,31.31,32.84,32.22,30.5,30.75,32.75,33.28,31.88,31.28,33.12,34.41,33.12,33.0,35.34,37.97,37.88,37.0,37.78,38.75,37.28,34.03,31.59,31.0,29.84,27.41,26.56,29.06,31.5,31.03,29.66,30.31,31.47,30.22,28.28,28.47,30.25,29.47,26.81,25.19,26.03,26.53,25.5,25.62,28.44,31.28,30.75,29.75,30.44,32.47,32.03,30.94,31.59,33.62,33.72,31.31,29.0,28.94,27.94,24.62,21.66,21.69,22.69,21.91,20.88,22.25,24.91,25.34,23.94,23.75,25.69,26.75,25.91,26.0,29.31,32.56,33.47,33.84,35.88,38.03,37.09,34.75,33.88,34.31,33.5,30.69,28.91,29.41,29.0,26.81,25.12,26.94,29.84,31.16,32.09,35.25,39.56,40.97,41.03,41.94,44.31,45.28,43.78,42.28,43.0,42.88,39.62,35.59,34.47,34.0,31.78,29.44,29.84,32.28,33.5,33.62,35.03,38.69,41.59,41.88,42.38,45.28,47.56,47.19,45.62,46.31,47.59,46.25,43.88,42.75,42.53,40.47,36.19,32.59,31.19,29.62,26.41,23.97,24.62,26.69,27.31,26.56,28.78,31.97,33.25,33.06,34.16,36.78,37.78,35.97,34.38,35.78,37.19,36.41,35.53,36.81,38.28,36.91,33.59,31.91,31.22,29.16,25.28,22.91,23.34,23.62,22.0,21.34,23.88,26.31,26.06,24.94,25.84,27.34,27.5,26.44,27.88,31.22,33.56,33.31,33.5,36.25,37.62,36.41,34.28,33.84,33.78,31.34,27.72,27.19,28.28,28.06,26.12,25.25,25.44,24.41,20.75,18.31,19.25,20.59,20.75,20.62,22.62,25.59,26.06,25.72,26.94,29.66,30.41,28.34,26.25,25.38,23.16,18.41,14.78,15.28,17.19,18.31,19.94,23.53,27.75,29.56,29.0,29.19,30.81,31.34,29.22,28.09,28.88,29.41,27.12,24.38,24.09,23.91,21.81,18.91,18.28,19.62,20.28,19.81,21.03,24.66,27.5,27.59,27.91,30.22,32.47,31.72,29.59,29.25,28.72,25.94,22.5,21.59,22.75,23.44,22.38,22.25,23.66,24.72,22.88,21.03,21.53,23.06,22.75,21.88,23.41,26.12,27.78,27.78,29.56,33.31,36.12,36.38,36.41,38.0,38.91,36.25,32.31,29.59,27.41,23.0,18.31,16.28,16.56,16.72,15.41,15.69,17.91,19.56,18.19,16.88,17.88,19.25,18.75,18.19,19.75,22.72,23.62,23.44,24.44,27.34,29.09,28.25,27.75,28.78,29.0,26.12,22.5,20.72,19.78,16.53,12.16,9.84,9.78,8.62,6.94,7.34,10.59,14.19,16.0,18.78,23.88,28.91,30.56,31.03,32.66,35.28,35.81,35.47,36.75,39.53,40.09,38.19,36.03,35.34,33.78,29.72,25.97,24.25,23.44,20.38,16.91,15.91,16.62,16.16,14.62,14.84,17.31,19.0,18.94,19.41,22.25,24.88,24.91,24.44,25.78,27.91,28.16,27.62,28.59,31.12,31.75,30.16,28.69,29.16,28.62,25.91,24.0,24.69,26.25,25.81,24.56,25.16,26.31,25.03,22.66,21.88,23.56,24.66,24.5,25.41,28.72,31.94,32.69,33.25,36.0,38.44,38.19,36.53,36.03,36.25,35.19,32.03,30.47,31.41,31.78,30.09,28.88,29.81,30.41,28.91,26.31,26.0,26.5,24.78,21.5,19.78,19.97,19.22,17.22,16.56,18.69,20.66,20.81,20.81,22.94,25.56,25.69,24.88,25.19,26.56,26.41,24.38,23.66,25.03,25.56,23.91,22.62,23.72,24.34,22.59,20.5,20.81,22.53,22.72,22.16,23.69,26.38,27.31,25.94,25.0,26.03,26.66,24.97,23.75,25.31,27.03,26.94,26.22,27.28,29.56,30.34,29.31,29.38,30.97,30.84,29.09,27.56,28.94,29.91,28.91,27.28,28.09,29.78,29.62,28.81,29.72,32.0,31.91,29.81,28.62,29.41,30.09,29.62,29.88,32.72,35.41,35.09,33.56,33.66,33.94,32.19,28.94,27.34,27.62,26.75,23.81,22.38,23.28,24.47,24.28,24.25,26.53,28.78,28.06,25.88,25.5,26.88,27.31,26.59,27.5,29.5,29.91,26.31,22.62,21.22,20.16,17.84,16.44,18.19,21.0,21.47,20.0,19.97,21.09,20.91,19.44,19.59,21.69,23.34,21.91,20.25,20.62,21.38,20.12,18.41,19.56,22.47,23.81,24.38,26.69,30.66,33.5,33.25,33.12,34.0,33.91,31.31,28.94,29.88,32.28,33.28,33.69,36.28,40.06,41.78,40.94,40.5,41.03,39.75,35.44,31.62,30.59,29.44,26.53,23.25,22.88,24.22,24.34,23.78,25.06,27.62,28.41,26.53,25.84,27.5,29.0,28.16,27.06,27.91,28.22,25.62,21.75,19.84,19.41,18.16,16.41,16.97,20.78,23.94,24.47,24.97,27.09,28.41,26.94,25.22,25.62,26.62,25.5,23.06,22.31,23.03,22.88,20.62,20.19,22.59,24.91,25.56,27.47,31.69,36.12,37.78,37.78,38.94,40.56,39.81,37.06,35.41,35.84,34.72,31.75,29.75,30.88,31.88,30.25,28.94,29.62,30.34,28.56,25.66,25.0,26.5,26.75,25.75,26.03,28.22,29.69,28.47,27.5,28.81,30.09,28.19,25.78,25.69,27.16,26.47,25.47,25.75,27.28,26.78,23.28,20.06,18.88,17.75,14.75,13.28,15.03,18.22,19.0,19.38,21.69,25.25,26.53,26.0,26.75,28.97,29.06:22.06,23.69,23.84,22.47,22.69,25.78,27.97,28.25,28.69,31.59,34.41,34.47,33.22,33.81,34.69,33.06,29.94,28.56,29.22,28.62,26.41,25.25,27.0,28.38,27.34,26.34,28.03,30.41,30.66,29.62,30.72,33.16,33.69,32.34,32.53,34.88,35.97,34.56,33.94,35.75,37.22,36.62,35.31,36.31,37.91,37.38,35.38,35.56,37.06,37.19,35.31,34.75,36.5,37.91,37.31,37.47,39.81,42.19,42.12,41.0,41.56,43.03,43.12,41.5,41.16,42.88,42.75,39.97,37.94,38.28,38.72,37.28,35.78,36.91,38.38,37.59,35.38,34.59,35.22,34.44,31.72,30.22,31.25,31.38,29.03,27.53,28.62,30.22,29.91,29.53,31.5,34.12,34.5,33.0,32.84,34.22,34.97,33.47,33.09,34.75,35.97,34.28,32.94,34.12,35.56,34.88,32.66,32.47,33.22,32.31,29.31,28.25,29.38,30.12,29.28,29.28,32.31,35.38,36.19,36.25,38.5,40.75,40.22,38.12,37.62,38.41,38.19,36.12,35.38,37.09,38.62,37.84,37.5,39.69,42.12,42.12,41.19,41.81,42.72,41.34,37.81,36.41,37.25,37.78,36.41,36.62,39.25,41.41,40.94,40.0,40.59,41.81,40.12,37.41,36.38,36.75,35.56,32.91,32.31,34.19,36.41,36.12,36.16,38.16,39.94,38.41,36.41,36.72,37.97,38.06,37.06,38.06,40.69,41.69,40.28,39.81,41.84,44.06,44.28,44.19,46.03,47.72,46.44,44.16,44.19,45.69,45.84,45.19,45.75,47.91,48.91,47.41,46.62,48.12,50.22,49.97,49.66,51.25,53.44,53.03,51.25,51.44,52.88,52.88,50.56,48.88,48.75,47.66,44.22,41.22,40.78,42.56,42.38,42.09,43.5,46.03,45.88,43.94,43.47,44.88,45.34,43.38,41.59,42.06,42.0,39.53,36.59,36.16,36.84,35.22,33.16,33.09,35.19,35.91,35.78,36.81,39.56,41.19,40.28,38.97,40.16,41.5,40.78,39.97,40.66,42.03,40.78,37.47,34.97,34.41,33.5,31.44,30.91,33.03,34.88,34.25,33.38,34.78,36.97,37.38,37.06,38.56,41.53,42.75,42.44,42.72,44.97,45.72,43.75,42.34,43.12,43.72,41.91,39.44,38.5,37.62,35.25,32.0,31.91,34.94,38.38,40.88,44.5,50.12,53.81,54.53,54.5,56.22,58.03,57.47,55.31,54.78,55.0,53.0,49.38,46.84,46.34,44.84,41.66,38.91,39.5,39.88,38.41,36.91,37.75,39.03,37.97,36.16,36.16,37.62,37.84,36.19,35.22,36.22,36.41,34.69,32.94,33.78,34.56,32.59,29.47,28.25,27.84,25.56,21.75,19.84,20.0,19.5,17.78,17.72,20.66,23.97,25.09,25.69,28.03,30.19,29.94,28.12,28.16,30.03,30.53,29.28,28.94,29.88,29.38,26.16,22.62,22.06,22.19,21.16,19.91,21.34,24.5,25.72,25.81,27.47,30.91,32.62,32.28,32.66,35.81,38.56,38.84,38.38,39.16,39.59,36.97,33.25,31.78,31.81,30.97,28.75,28.56,30.38,31.69,30.44,29.97,31.53,33.34,33.31,33.03,35.0,37.38,37.69,36.22,36.78,38.28,39.38,38.47,38.41,40.16,41.16,39.31,37.19,37.06,37.66,36.16,34.25,35.06,37.47,38.53,37.84,38.53,39.69,39.69,37.09,34.72,35.0,35.56,34.06,32.69,34.0,36.5,37.91,38.59,40.62,44.12,45.53,44.06,42.56,42.72,41.88,38.38,35.78,36.0,37.25,37.03,35.84,37.09,38.91,38.88,37.66,37.78,39.59,40.47,38.66,37.0,37.25,37.12,34.16,31.44,31.53,32.78,32.44,31.44,32.31,34.91,35.69,34.28,34.81,37.44,39.19,38.41,37.81,39.12,39.94,38.06,35.91,36.34,37.97,37.59,35.75,35.41,36.62,36.34,34.44,34.09,36.06,37.38,35.81,33.91,34.19,34.81,33.31,31.47,31.44,32.94,32.5,30.31,29.62,31.25,32.38,31.25,30.75,32.56,34.0,32.81,31.0,31.31,32.84,32.22,30.5,30.75,32.75,33.28,31.88,31.28,33.12,34.41,33.12,33.0,35.34,37.97,37.88,37.0,37.78,38.75,37.28,34.03,31.59,31.0,29.84,27.41,26.56,29.06,31.5,31.03,29.66,30.31,31.47,30.22,28.28,28.47,30.25,29.47,26.81,25.19,26.03,26.53,25.5,25.62,28.44,31.28,30.75,29.75,30.44,32.47,32.03,30.94,31.59,33.62,33.72,31.31,29.0,28.94,27.94,24.62,21.66,21.69,22.69,21.91,20.88,22.25,24.91,25.34,23.94,23.75,25.69,26.75,25.91,26.0,29.31,32.56,33.47,33.84,35.88,38.03,37.09,34.75,33.88,34.31,33.5,30.69,28.91,29.41,29.0,26.81,25.12,26.94,29.84,31.16,32.09,35.25,39.56,40.97,41.03,41.94,44.31,45.28,43.78,42.28,43.0,42.88,39.62,35.59,34.47,34.0,31.78,29.44,29.84,32.28,33.5,33.62,35.03,38.69,41.59,41.88,42.38,45.28,47.56,47.19,45.62,46.31,47.59,46.25,43.88,42.75,42.53,40.47,36.19,32.59,31.19,29.62,26.41,23.97,24.62,26.69,27.31,26.56,28.78,31.97,33.25,33.06,34.16,36.78,37.78,35.97,34.38,35.78,37.19,36.41,35.53,36.81,38.28,36.91,33.59,31.91,31.22,29.16,25.28,22.91,23.34,23.62,22.0,21.34,23.88,26.31,26.06,24.94,25.84,27.34,27.5,26.44,27.88,31.22,33.56,33.31,33.5,36.25,37.62,36.41,34.28,33.84,33.78,31.34,27.72,27.19,28.28,28.06,26.12,25.25,25.44,24.41,20.75,18.31,19.25,20.59,20.75,20.62,22.62,25.59,26.06,25.72,26.94,29.66,30.41,28.34,26.25,25.38,23.16,18.41,14.78,15.28,17.19,18.31,19.94,23.53,27.75,29.56,29.0,29.19,30.81,31.34,29.22,28.09,28.88,29.41,27.12,24.38,24.09,23.91,21.81,18.91,18.28,19.62,20.28,19.81,21.03,24.66,27.5,27.59,27.91,30.22,32.47,31.72,29.59,29.25,28.72,25.94,22.5,21.59,22.75,23.44,22.38,22.25,23.66,24.72,22.88,21.03,21.53,23.06,22.75,21.88,23.41,26.12,27.78,27.78,29.56,33.31,36.12,36.38,36.41,38.0,38.91,36.25,32.31,29.59,27.41,23.0,18.31,16.28,16.56,16.72,15.41,15.69,17.91,19.56,18.19,16.88,17.88,19.25,18.75,18.19,19.75,22.72,23.62,23.44,24.44,27.34,29.09,28.25,27.75,28.78,29.0,26.12,22.5,20.72,19.78,16.53,12.16,9.84,9.78,8.62,6.94,7.34,10.59,14.19,16.0,18.78,23.88,28.91,30.56,31.03,32.66,35.28,35.81,35.47,36.75,39.53,40.09,38.19,36.03,35.34,33.78,29.72,25.97,24.25,23.44,20.38,16.91,15.91,16.62,16.16,14.62,14.84,17.31,19.0,18.94,19.41,22.25,24.88,24.91,24.44,25.78,27.91,28.16,27.62,28.59,31.12,31.75,30.16,28.69,29.16,28.62,25.91,24.0,24.69,26.25,25.81,24.56,25.16,26.31,25.03,22.66,21.88,23.56,24.66,24.5,25.41,28.72,31.94,32.69,33.25,36.0,38.44,38.19,36.53,36.03,36.25,35.19,32.03,30.47,31.41,31.78,30.09,28.88,29.81,30.41,28.91,26.31,26.0,26.5,24.78,21.5,19.78,19.97,19.22,17.22,16.56,18.69,20.66,20.81,20.81,22.94,25.56,25.69,24.88,25.19,26.56,26.41,24.38,23.66,25.03,25.56,23.91,22.62,23.72,24.34,22.59,20.5,20.81,22.53,22.72,22.16,23.69,26.38,27.31,25.94,25.0,26.03,26.66,24.97,23.75,25.31,27.03,26.94,26.22,27.28,29.56,30.34,29.31,29.38,30.97,30.84,29.09,27.56,28.94,29.91,28.91,27.28,28.09,29.78,29.62,28.81,29.72,32.0,31.91,29.81,28.62,29.41,30.09,29.62,29.88,32.72,35.41,35.09,33.56,33.66,33.94,32.19,28.94,27.34,27.62,26.75,23.81,22.38,23.28,24.47,24.28,24.25,26.53,28.78,28.06,25.88,25.5,26.88,27.31,26.59,27.5,29.5,29.91,26.31,22.62,21.22,20.16,17.84,16.44,18.19,21.0,21.47,20.0,19.97,21.09,20.91,19.44,19.59,21.69,23.34,21.91,20.25,20.62,21.38,20.12,18.41,19.56,22.47,23.81,24.38,26.69,30.66,33.5,33.25,33.12,34.0,33.91,31.31,28.94,29.88,32.28,33.28,33.69,36.28,40.06,41.78,40.94,40.5,41.03,39.75,35.44,31.62,30.59,29.44,26.53,23.25,22.88,24.22,24.34,23.78,25.06,27.62,28.41,26.53,25.84,27.5,29.0,28.16,27.06,27.91,28.22,25.62,21.75,19.84,19.41,18.16,16.41,16.97,20.78,23.94,24.47,24.97,27.09,28.41,26.94,25.22,25.62,26.62,25.5,23.06,22.31,23.03,22.88,20.62,20.19,22.59,24.91,25.56,27.47,31.69,36.12,37.78,37.78,38.94,40.56,39.81,37.06,35.41,35.84,34.72,31.75,29.75,30.88,31.88,30.25,28.94,29.62,30.34,28.56,25.66,25.0,26.5,26.75,25.75,26.03,28.22,29.69,28.47,27.5,28.81,30.09,28.19,25.78,25.69,27.16,26.47,25.47,25.75,27.28,26.78,23.28,20.06,18.88,17.75,14.75,13.28,15.03,18.22,19.0,19.38,21.69,25.25,26.53,26.0,26.75,28.97,29.06,34.97,32.12,28.81,27.47,26.72,25.28,24.16:28.25,28.69,31.59,34.41,34.47,33.22,33.81,34.69,33.06,29.94,28.56,29.22,28.62,26.41,25.25,27.0,28.38,27.34,26.34,28.03,30.41,30.66,29.62,30.72,33.16,33.69,32.34,32.53,34.88,35.97,34.56,33.94,35.75,37.22,36.62,35.31,36.31,37.91,37.38,35.38,35.56,37.06,37.19,35.31,34.75,36.5,37.91,37.31,37.47,39.81,42.19,42.12,41.0,41.56,43.03,43.12,41.5,41.16,42.88,42.75,39.97,37.94,38.28,38.72,37.28,35.78,36.91,38.38,37.59,35.38,34.59,35.22,34.44,31.72,30.22,31.25,31.38,29.03,27.53,28.62,30.22,29.91,29.53,31.5,34.12,34.5,33.0,32.84,34.22,34.97,33.47,33.09,34.75,35.97,34.28,32.94,34.12,35.56,34.88,32.66,32.47,33.22,32.31,29.31,28.25,29.38,30.12,29.28,29.28,32.31,35.38,36.19,36.25,38.5,40.75,40.22,38.12,37.62,38.41,38.19,36.12,35.38,37.09,38.62,37.84,37.5,39.69,42.12,42.12,41.19,41.81,42.72,41.34,37.81,36.41,37.25,37.78,36.41,36.62,39.25,41.41,40.94,40.0,40.59,41.81,40.12,37.41,36.38,36.75,35.56,32.91,32.31,34.19,36.41,36.12,36.16,38.16,39.94,38.41,36.41,36.72,37.97,38.06,37.06,38.06,40.69,41.69,40.28,39.81,41.84,44.06,44.28,44.19,46.03,47.72,46.44,44.16,44.19,45.69,45.84,45.19,45.75,47.91,48.91,47.41,46.62,48.12,50.22,49.97,49.66,51.25,53.44,53.03,51.25,51.44,52.88,52.88,50.56,48.88,48.75,47.66,44.22,41.22,40.78,42.56,42.38,42.09,43.5,46.03,45.88,43.94,43.47,44.88,45.34,43.38,41.59,42.06,42.0,39.53,36.59,36.16,36.84,35.22,33.16,33.09,35.19,35.91,35.78,36.81,39.56,41.19,40.28,38.97,40.16,41.5,40.78,39.97,40.66,42.03,40.78,37.47,34.97,34.41,33.5,31.44,30.91,33.03,34.88,34.25,33.38,34.78,36.97,37.38,37.06,38.56,41.53,42.75,42.44,42.72,44.97,45.72,43.75,42.34,43.12,43.72,41.91,39.44,38.5,37.62,35.25,32.0,31.91,34.94,38.38,40.88,44.5,50.12,53.81,54.53,54.5,56.22,58.03,57.47,55.31,54.78,55.0,53.0,49.38,46.84,46.34,44.84,41.66,38.91,39.5,39.88,38.41,36.91,37.75,39.03,37.97,36.16,36.16,37.62,37.84,36.19,35.22,36.22,36.41,34.69,32.94,33.78,34.56,32.59,29.47,28.25,27.84,25.56,21.75,19.84,20.0,19.5,17.78,17.72,20.66,23.97,25.09,25.69,28.03,30.19,29.94,28.12,28.16,30.03,30.53,29.28,28.94,29.88,29.38,26.16,22.62,22.06,22.19,21.16,19.91,21.34,24.5,25.72,25.81,27.47,30.91,32.62,32.28,32.66,35.81,38.56,38.84,38.38,39.16,39.59,36.97,33.25,31.78,31.81,30.97,28.75,28.56,30.38,31.69,30.44,29.97,31.53,33.34,33.31,33.03,35.0,37.38,37.69,36.22,36.78,38.28,39.38,38.47,38.41,40.16,41.16,39.31,37.19,37.06,37.66,36.16,34.25,35.06,37.47,38.53,37.84,38.53,39.69,39.69,37.09,34.72,35.0,35.56,34.06,32.69,34.0,36.5,37.91,38.59,40.62,44.12,45.53,44.06,42.56,42.72,41.88,38.38,35.78,36.0,37.25,37.03,35.84,37.09,38.91,38.88,37.66,37.78,39.59,40.47,38.66,37.0,37.25,37.12,34.16,31.44,31.53,32.78,32.44,31.44,32.31,34.91,35.69,34.28,34.81,37.44,39.19,38.41,37.81,39.12,39.94,38.06,35.91,36.34,37.97,37.59,35.75,35.41,36.62,36.34,34.44,34.09,36.06,37.38,35.81,33.91,34.19,34.81,33.31,31.47,31.44,32.94,32.5,30.31,29.62,31.25,32.38,31.25,30.75,32.56,34.0,32.81,31.0,31.31,32.84,32.22,30.5,30.75,32.75,33.28,31.88,31.28,33.12,34.41,33.12,33.0,35.34,37.97,37.88,37.0,37.78,38.75,37.28,34.03,31.59,31.0,29.84,27.41,26.56,29.06,31.5,31.03,29.66,30.31,31.47,30.22,28.28,28.47,30.25,29.47,26.81,25.19,26.03,26.53,25.5,25.62,28.44,31.28,30.75,29.75,30.44,32.47,32.03,30.94,31.59,33.62,33.72,31.31,29.0,28.94,27.94,24.62,21.66,21.69,22.69,21.91,20.88,22.25,24.91,25.34,23.94,23.75,25.69,26.75,25.91,26.0,29.31,32.56,33.47,33.84,35.88,38.03,37.09,34.75,33.88,34.31,33.5,30.69,28.91,29.41,29.0,26.81,25.12,26.94,29.84,31.16,32.09,35.25,39.56,40.97,41.03,41.94,44.31,45.28,43.78,42.28,43.0,42.88,39.62,35.59,34.47,34.0,31.78,29.44,29.84,32.28,33.5,33.62,35.03,38.69,41.59,41.88,42.38,45.28,47.56,47.19,45.62,46.31,47.59,46.25,43.88,42.75,42.53,40.47,36.19,32.59,31.19,29.62,26.41,23.97,24.62,26.69,27.31,26.56,28.78,31.97,33.25,33.06,34.16,36.78,37.78,35.97,34.38,35.78,37.19,36.41,35.53,36.81,38.28,36.91,33.59,31.91,31.22,29.16,25.28,22.91,23.34,23.62,22.0,21.34,23.88,26.31,26.06,24.94,25.84,27.34,27.5,26.44,27.88,31.22,33.56,33.31,33.5,36.25,37.62,36.41,34.28,33.84,33.78,31.34,27.72,27.19,28.28,28.06,26.12,25.25,25.44,24.41,20.75,18.31,19.25,20.59,20.75,20.62,22.62,25.59,26.06,25.72,26.94,29.66,30.41,28.34,26.25,25.38,23.16,18.41,14.78,15.28,17.19,18.31,19.94,23.53,27.75,29.56,29.0,29.19,30.81,31.34,29.22,28.09,28.88,29.41,27.12,24.38,24.09,23.91,21.81,18.91,18.28,19.62,20.28,19.81,21.03,24.66,27.5,27.59,27.91,30.22,32.47,31.72,29.59,29.25,28.72,25.94,22.5,21.59,22.75,23.44,22.38,22.25,23.66,24.72,22.88,21.03,21.53,23.06,22.75,21.88,23.41,26.12,27.78,27.78,29.56,33.31,36.12,36.38,36.41,38.0,38.91,36.25,32.31,29.59,27.41,23.0,18.31,16.28,16.56,16.72,15.41,15.69,17.91,19.56,18.19,16.88,17.88,19.25,18.75,18.19,19.75,22.72,23.62,23.44,24.44,27.34,29.09,28.25,27.75,28.78,29.0,26.12,22.5,20.72,19.78,16.53,12.16,9.84,9.78,8.62,6.94,7.34,10.59,14.19,16.0,18.78,23.88,28.91,30.56,31.03,32.66,35.28,35.81,35.47,36.75,39.53,40.09,38.19,36.03,35.34,33.78,29.72,25.97,24.25,23.44,20.38,16.91,15.91,16.62,16.16,14.62,14.84,17.31,19.0,18.94,19.41,22.25,24.88,24.91,24.44,25.78,27.91,28.16,27.62,28.59,31.12,31.75,30.16,28.69,29.16,28.62,25.91,24.0,24.69,26.25,25.81,24.56,25.16,26.31,25.03,22.66,21.88,23.56,24.66,24.5,25.41,28.72,31.94,32.69,33.25,36.0,38.44,38.19,36.53,36.03,36.25,35.19,32.03,30.47,31.41,31.78,30.09,28.88,29.81,30.41,28.91,26.31,26.0,26.5,24.78,21.5,19.78,19.97,19.22,17.22,16.56,18.69,20.66,20.81,20.81,22.94,25.56,25.69,24.88,25.19,26.56,26.41,24.38,23.66,25.03,25.56,23.91,22.62,23.72,24.34,22.59,20.5,20.81,22.53,22.72,22.16,23.69,26.38,27.31,25.94,25.0,26.03,26.66,24.97,23.75,25.31,27.03,26.94,26.22,27.28,29.56,30.34,29.31,29.38,30.97,30.84,29.09,27.56,28.94,29.91,28.91,27.28,28.09,29.78,29.62,28.81,29.72,32.0,31.91,29.81,28.62,29.41,30.09,29.62,29.88,32.72,35.41,35.09,33.56,33.66,33.94,32.19,28.94,27.34,27.62,26.75,23.81,22.38,23.28,24.47,24.28,24.25,26.53,28.78,28.06,25.88,25.5,26.88,27.31,26.59,27.5,29.5,29.91,26.31,22.62,21.22,20.16,17.84,16.44,18.19,21.0,21.47,20.0,19.97,21.09,20.91,19.44,19.59,21.69,23.34,21.91,20.25,20.62,21.38,20.12,18.41,19.56,22.47,23.81,24.38,26.69,30.66,33.5,33.25,33.12,34.0,33.91,31.31,28.94,29.88,32.28,33.28,33.69,36.28,40.06,41.78,40.94,40.5,41.03,39.75,35.44,31.62,30.59,29.44,26.53,23.25,22.88,24.22,24.34,23.78,25.06,27.62,28.41,26.53,25.84,27.5,29.0,28.16,27.06,27.91,28.22,25.62,21.75,19.84,19.41,18.16,16.41,16.97,20.78,23.94,24.47,24.97,27.09,28.41,26.94,25.22,25.62,26.62,25.5,23.06,22.31,23.03,22.88,20.62,20.19,22.59,24.91,25.56,27.47,31.69,36.12,37.78,37.78,38.94,40.56,39.81,37.06,35.41,35.84,34.72,31.75,29.75,30.88,31.88,30.25,28.94,29.62,30.34,28.56,25.66,25.0,26.5,26.75,25.75,26.03,28.22,29.69,28.47,27.5,28.81,30.09,28.19,25.78,25.69,27.16,26.47,25.47,25.75,27.28,26.78,23.28,20.06,18.88,17.75,14.75,13.28,15.03,18.22,19.0,19.38,21.69,25.25,26.53,26.0,26.75,28.97,29.06,34.97,32.12,28.81,27.47,26.72,25.28,24.16,24.53,26.25,26.78,26.75,28.16,30.66,32.38:34.69,33.06,29.94,28.56,29.22,28.62,26.41,25.25,27.0,28.38,27.34,26.34,28.03,30.41,30.66,29.62,30.72,33.16,33.69,32.34,32.53,34.88,35.97,34.56,33.94,35.75,37.22,36.62,35.31,36.31,37.91,37.38,35.38,35.56,37.06,37.19,35.31,34.75,36.5,37.91,37.31,37.47,39.81,42.19,42.12,41.0,41.56,43.03,43.12,41.5,41.16,42.88,42.75,39.97,37.94,38.28,38.72,37.28,35.78,36.91,38.38,37.59,35.38,34.59,35.22,34.44,31.72,30.22,31.25,31.38,29.03,27.53,28.62,30.22,29.91,29.53,31.5,34.12,34.5,33.0,32.84,34.22,34.97,33.47,33.09,34.75,35.97,34.28,32.94,34.12,35.56,34.88,32.66,32.47,33.22,32.31,29.31,28.25,29.38,30.12,29.28,29.28,32.31,35.38,36.19,36.25,38.5,40.75,40.22,38.12,37.62,38.41,38.19,36.12,35.38,37.09,38.62,37.84,37.5,39.69,42.12,42.12,41.19,41.81,42.72,41.34,37.81,36.41,37.25,37.78,36.41,36.62,39.25,41.41,40.94,40.0,40.59,41.81,40.12,37.41,36.38,36.75,35.56,32.91,32.31,34.19,36.41,36.12,36.16,38.16,39.94,38.41,36.41,36.72,37.97,38.06,37.06,38.06,40.69,41.69,40.28,39.81,41.84,44.06,44.28,44.19,46.03,47.72,46.44,44.16,44.19,45.69,45.84,45.19,45.75,47.91,48.91,47.41,46.62,48.12,50.22,49.97,49.66,51.25,53.44,53.03,51.25,51.44,52.88,52.88,50.56,48.88,48.75,47.66,44.22,41.22,40.78,42.56,42.38,42.09,43.5,46.03,45.88,43.94,43.47,44.88,45.34,43.38,41.59,42.06,42.0,39.53,36.59,36.16,36.84,35.22,33.16,33.09,35.19,35.91,35.78,36.81,39.56,41.19,40.28,38.97,40.16,41.5,40.78,39.97,40.66,42.03,40.78,37.47,34.97,34.41,33.5,31.44,30.91,33.03,34.88,34.25,33.38,34.78,36.97,37.38,37.06,38.56,41.53,42.75,42.44,42.72,44.97,45.72,43.75,42.34,43.12,43.72,41.91,39.44,38.5,37.62,35.25,32.0,31.91,34.94,38.38,40.88,44.5,50.12,53.81,54.53,54.5,56.22,58.03,57.47,55.31,54.78,55.0,53.0,49.38,46.84,46.34,44.84,41.66,38.91,39.5,39.88,38.41,36.91,37.75,39.03,37.97,36.16,36.16,37.62,37.84,36.19,35.22,36.22,36.41,34.69,32.94,33.78,34.56,32.59,29.47,28.25,27.84,25.56,21.75,19.84,20.0,19.5,17.78,17.72,20.66,23.97,25.09,25.69,28.03,30.19,29.94,28.12,28.16,30.03,30.53,29.28,28.94,29.88,29.38,26.16,22.62,22.06,22.19,21.16,19.91,21.34,24.5,25.72,25.81,27.47,30.91,32.62,32.28,32.66,35.81,38.56,38.84,38.38,39.16,39.59,36.97,33.25,31.78,31.81,30.97,28.75,28.56,30.38,31.69,30.44,29.97,31.53,33.34,33.31,33.03,35.0,37.38,37.69,36.22,36.78,38.28,39.38,38.47,38.41,40.16,41.16,39.31,37.19,37.06,37.66,36.16,34.25,35.06,37.47,38.53,37.84,38.53,39.69,39.69,37.09,34.72,35.0,35.56,34.06,32.69,34.0,36.5,37.91,38.59,40.62,44.12,45.53,44.06,42.56,42.72,41.88,38.38,35.78,36.0,37.25,37.03,35.84,37.09,38.91,38.88,37.66,37.78,39.59,40.47,38.66,37.0,37.25,37.12,34.16,31.44,31.53,32.78,32.44,31.44,32.31,34.91,35.69,34.28,34.81,37.44,39.19,38.41,37.81,39.12,39.94,38.06,35.91,36.34,37.97,37.59,35.75,35.41,36.62,36.34,34.44,34.09,36.06,37.38,35.81,33.91,34.19,34.81,33.31,31.47,31.44,32.94,32.5,30.31,29.62,31.25,32.38,31.25,30.75,32.56,34.0,32.81,31.0,31.31,32.84,32.22,30.5,30.75,32.75,33.28,31.88,31.28,33.12,34.41,33.12,33.0,35.34,37.97,37.88,37.0,37.78,38.75,37.28,34.03,31.59,31.0,29.84,27.41,26.56,29.06,31.5,31.03,29.66,30.31,31.47,30.22,28.28,28.47,30.25,29.47,26.81,25.19,26.03,26.53,25.5,25.62,28.44,31.28,30.75,29.75,30.44,32.47,32.03,30.94,31.59,33.62,33.72,31.31,29.0,28.94,27.94,24.62,21.66,21.69,22.69,21.91,20.88,22.25,24.91,25.34,23.94,23.75,25.69,26.75,25.91,26.0,29.31,32.56,33.47,33.84,35.88,38.03,37.09,34.75,33.88,34.31,33.5,30.69,28.91,29.41,29.0,26.81,25.12,26.94,29.84,31.16,32.09,35.25,39.56,40.97,41.03,41.94,44.31,45.28,43.78,42.28,43.0,42.88,39.62,35.59,34.47,34.0,31.78,29.44,29.84,32.28,33.5,33.62,35.03,38.69,41.59,41.88,42.38,45.28,47.56,47.19,45.62,46.31,47.59,46.25,43.88,42.75,42.53,40.47,36.19,32.59,31.19,29.62,26.41,23.97,24.62,26.69,27.31,26.56,28.78,31.97,33.25,33.06,34.16,36.78,37.78,35.97,34.38,35.78,37.19,36.41,35.53,36.81,38.28,36.91,33.59,31.91,31.22,29.16,25.28,22.91,23.34,23.62,22.0,21.34,23.88,26.31,26.06,24.94,25.84,27.34,27.5,26.44,27.88,31.22,33.56,33.31,33.5,36.25,37.62,36.41,34.28,33.84,33.78,31.34,27.72,27.19,28.28,28.06,26.12,25.25,25.44,24.41,20.75,18.31,19.25,20.59,20.75,20.62,22.62,25.59,26.06,25.72,26.94,29.66,30.41,28.34,26.25,25.38,23.16,18.41,14.78,15.28,17.19,18.31,19.94,23.53,27.75,29.56,29.0,29.19,30.81,31.34,29.22,28.09,28.88,29.41,27.12,24.38,24.09,23.91,21.81,18.91,18.28,19.62,20.28,19.81,21.03,24.66,27.5,27.59,27.91,30.22,32.47,31.72,29.59,29.25,28.72,25.94,22.5,21.59,22.75,23.44,22.38,22.25,23.66,24.72,22.88,21.03,21.53,23.06,22.75,21.88,23.41,26.12,27.78,27.78,29.56,33.31,36.12,36.38,36.41,38.0,38.91,36.25,32.31,29.59,27.41,23.0,18.31,16.28,16.56,16.72,15.41,15.69,17.91,19.56,18.19,16.88,17.88,19.25,18.75,18.19,19.75,22.72,23.62,23.44,24.44,27.34,29.09,28.25,27.75,28.78,29.0,26.12,22.5,20.72,19.78,16.53,12.16,9.84,9.78,8.62,6.94,7.34,10.59,14.19,16.0,18.78,23.88,28.91,30.56,31.03,32.66,35.28,35.81,35.47,36.75,39.53,40.09,38.19,36.03,35.34,33.78,29.72,25.97,24.25,23.44,20.38,16.91,15.91,16.62,16.16,14.62,14.84,17.31,19.0,18.94,19.41,22.25,24.88,24.91,24.44,25.78,27.91,28.16,27.62,28.59,31.12,31.75,30.16,28.69,29.16,28.62,25.91,24.0,24.69,26.25,25.81,24.56,25.16,26.31,25.03,22.66,21.88,23.56,24.66,24.5,25.41,28.72,31.94,32.69,33.25,36.0,38.44,38.19,36.53,36.03,36.25,35.19,32.03,30.47,31.41,31.78,30.09,28.88,29.81,30.41,28.91,26.31,26.0,26.5,24.78,21.5,19.78,19.97,19.22,17.22,16.56,18.69,20.66,20.81,20.81,22.94,25.56,25.69,24.88,25.19,26.56,26.41,24.38,23.66,25.03,25.56,23.91,22.62,23.72,24.34,22.59,20.5,20.81,22.53,22.72,22.16,23.69,26.38,27.31,25.94,25.0,26.03,26.66,24.97,23.75,25.31,27.03,26.94,26.22,27.28,29.56,30.34,29.31,29.38,30.97,30.84,29.09,27.56,28.94,29.91,28.91,27.28,28.09,29.78,29.62,28.81,29.72,32.0,31.91,29.81,28.62,29.41,30.09,29.62,29.88,32.72,35.41,35.09,33.56,33.66,33.94,32.19,28.94,27.34,27.62,26.75,23.81,22.38,23.28,24.47,24.28,24.25,26.53,28.78,28.06,25.88,25.5,26.88,27.31,26.59,27.5,29.5,29.91,26.31,22.62,21.22,20.16,17.84,16.44,18.19,21.0,21.47,20.0,19.97,21.09,20.91,19.44,19.59,21.69,23.34,21.91,20.25,20.62,21.38,20.12,18.41,19.56,22.47,23.81,24.38,26.69,30.66,33.5,33.25,33.12,34.0,33.91,31.31,28.94,29.88,32.28,33.28,33.69,36.28,40.06,41.78,40.94,40.5,41.03,39.75,35.44,31.62,30.59,29.44,26.53,23.25,22.88,24.22,24.34,23.78,25.06,27.62,28.41,26.53,25.84,27.5,29.0,28.16,27.06,27.91,28.22,25.62,21.75,19.84,19.41,18.16,16.41,16.97,20.78,23.94,24.47,24.97,27.09,28.41,26.94,25.22,25.62,26.62,25.5,23.06,22.31,23.03,22.88,20.62,20.19,22.59,24.91,25.56,27.47,31.69,36.12,37.78,37.78,38.94,40.56,39.81,37.06,35.41,35.84,34.72,31.75,29.75,30.88,31.88,30.25,28.94,29.62,30.34,28.56,25.66,25.0,26.5,26.75,25.75,26.03,28.22,29.69,28.47,27.5,28.81,30.09,28.19,25.78,25.69,27.16,26.47,25.47,25.75,27.28,26.78,23.28,20.06,18.88,17.75,14.75,13.28,15.03,18.22,19.0,19.38,21.69,25.25,26.53,26.0,26.75,28.97,29.06,34.97,32.12,28.81,27.47,26.72,25.28,24.16,24.53,26.25,26.78,26.75,28.16,30.66,32.38,32.72,33.44,35.72,37.56,37.66,37.09,37.34:25.25,27.0,28.38,27.34,26.34,28.03,30.41,30.66,29.62,30.72,33.16,33.69,32.34,32.53,34.88,35.97,34.56,33.94,35.75,37.22,36.62,35.31,36.31,37.91,37.38,35.38,35.56,37.06,37.19,35.31,34.75,36.5,37.91,37.31,37.47,39.81,42.19,42.12,41.0,41.56,43.03,43.12,41.5,41.16,42.88,42.75,39.97,37.94,38.28,38.72,37.28,35.78,36.91,38.38,37.59,35.38,34.59,35.22,34.44,31.72,30.22,31.25,31.38,29.03,27.53,28.62,30.22,29.91,29.53,31.5,34.12,34.5,33.0,32.84,34.22,34.97,33.47,33.09,34.75,35.97,34.28,32.94,34.12,35.56,34.88,32.66,32.47,33.22,32.31,29.31,28.25,29.38,30.12,29.28,29.28,32.31,35.38,36.19,36.25,38.5,40.75,40.22,38.12,37.62,38.41,38.19,36.12,35.38,37.09,38.62,37.84,37.5,39.69,42.12,42.12,41.19,41.81,42.72,41.34,37.81,36.41,37.25,37.78,36.41,36.62,39.25,41.41,40.94,40.0,40.59,41.81,40.12,37.41,36.38,36.75,35.56,32.91,32.31,34.19,36.41,36.12,36.16,38.16,39.94,38.41,36.41,36.72,37.97,38.06,37.06,38.06,40.69,41.69,40.28,39.81,41.84,44.06,44.28,44.19,46.03,47.72,46.44,44.16,44.19,45.69,45.84,45.19,45.75,47.91,48.91,47.41,46.62,48.12,50.22,49.97,49.66,51.25,53.44,53.03,51.25,51.44,52.88,52.88,50.56,48.88,48.75,47.66,44.22,41.22,40.78,42.56,42.38,42.09,43.5,46.03,45.88,43.94,43.47,44.88,45.34,43.38,41.59,42.06,42.0,39.53,36.59,36.16,36.84,35.22,33.16,33.09,35.19,35.91,35.78,36.81,39.56,41.19,40.28,38.97,40.16,41.5,40.78,39.97,40.66,42.03,40.78,37.47,34.97,34.41,33.5,31.44,30.91,33.03,34.88,34.25,33.38,34.78,36.97,37.38,37.06,38.56,41.53,42.75,42.44,42.72,44.97,45.72,43.75,42.34,43.12,43.72,41.91,39.44,38.5,37.62,35.25,32.0,31.91,34.94,38.38,40.88,44.5,50.12,53.81,54.53,54.5,56.22,58.03,57.47,55.31,54.78,55.0,53.0,49.38,46.84,46.34,44.84,41.66,38.91,39.5,39.88,38.41,36.91,37.75,39.03,37.97,36.16,36.16,37.62,37.84,36.19,35.22,36.22,36.41,34.69,32.94,33.78,34.56,32.59,29.47,28.25,27.84,25.56,21.75,19.84,20.0,19.5,17.78,17.72,20.66,23.97,25.09,25.69,28.03,30.19,29.94,28.12,28.16,30.03,30.53,29.28,28.94,29.88,29.38,26.16,22.62,22.06,22.19,21.16,19.91,21.34,24.5,25.72,25.81,27.47,30.91,32.62,32.28,32.66,35.81,38.56,38.84,38.38,39.16,39.59,36.97,33.25,31.78,31.81,30.97,28.75,28.56,30.38,31.69,30.44,29.97,31.53,33.34,33.31,33.03,35.0,37.38,37.69,36.22,36.78,38.28,39.38,38.47,38.41,40.16,41.16,39.31,37.19,37.06,37.66,36.16,34.25,35.06,37.47,38.53,37.84,38.53,39.69,39.69,37.09,34.72,35.0,35.56,34.06,32.69,34.0,36.5,37.91,38.59,40.62,44.12,45.53,44.06,42.56,42.72,41.88,38.38,35.78,36.0,37.25,37.03,35.84,37.09,38.91,38.88,37.66,37.78,39.59,40.47,38.66,37.0,37.25,37.12,34.16,31.44,31.53,32.78,32.44,31.44,32.31,34.91,35.69,34.28,34.81,37.44,39.19,38.41,37.81,39.12,39.94,38.06,35.91,36.34,37.97,37.59,35.75,35.41,36.62,36.34,34.44,34.09,36.06,37.38,35.81,33.91,34.19,34.81,33.31,31.47,31.44,32.94,32.5,30.31,29.62,31.25,32.38,31.25,30.75,32.56,34.0,32.81,31.0,31.31,32.84,32.22,30.5,30.75,32.75,33.28,31.88,31.28,33.12,34.41,33.12,33.0,35.34,37.97,37.88,37.0,37.78,38.75,37.28,34.03,31.59,31.0,29.84,27.41,26.56,29.06,31.5,31.03,29.66,30.31,31.47,30.22,28.28,28.47,30.25,29.47,26.81,25.19,26.03,26.53,25.5,25.62,28.44,31.28,30.75,29.75,30.44,32.47,32.03,30.94,31.59,33.62,33.72,31.31,29.0,28.94,27.94,24.62,21.66,21.69,22.69,21.91,20.88,22.25,24.91,25.34,23.94,23.75,25.69,26.75,25.91,26.0,29.31,32.56,33.47,33.84,35.88,38.03,37.09,34.75,33.88,34.31,33.5,30.69,28.91,29.41,29.0,26.81,25.12,26.94,29.84,31.16,32.09,35.25,39.56,40.97,41.03,41.94,44.31,45.28,43.78,42.28,43.0,42.88,39.62,35.59,34.47,34.0,31.78,29.44,29.84,32.28,33.5,33.62,35.03,38.69,41.59,41.88,42.38,45.28,47.56,47.19,45.62,46.31,47.59,46.25,43.88,42.75,42.53,40.47,36.19,32.59,31.19,29.62,26.41,23.97,24.62,26.69,27.31,26.56,28.78,31.97,33.25,33.06,34.16,36.78,37.78,35.97,34.38,35.78,37.19,36.41,35.53,36.81,38.28,36.91,33.59,31.91,31.22,29.16,25.28,22.91,23.34,23.62,22.0,21.34,23.88,26.31,26.06,24.94,25.84,27.34,27.5,26.44,27.88,31.22,33.56,33.31,33.5,36.25,37.62,36.41,34.28,33.84,33.78,31.34,27.72,27.19,28.28,28.06,26.12,25.25,25.44,24.41,20.75,18.31,19.25,20.59,20.75,20.62,22.62,25.59,26.06,25.72,26.94,29.66,30.41,28.34,26.25,25.38,23.16,18.41,14.78,15.28,17.19,18.31,19.94,23.53,27.75,29.56,29.0,29.19,30.81,31.34,29.22,28.09,28.88,29.41,27.12,24.38,24.09,23.91,21.81,18.91,18.28,19.62,20.28,19.81,21.03,24.66,27.5,27.59,27.91,30.22,32.47,31.72,29.59,29.25,28.72,25.94,22.5,21.59,22.75,23.44,22.38,22.25,23.66,24.72,22.88,21.03,21.53,23.06,22.75,21.88,23.41,26.12,27.78,27.78,29.56,33.31,36.12,36.38,36.41,38.0,38.91,36.25,32.31,29.59,27.41,23.0,18.31,16.28,16.56,16.72,15.41,15.69,17.91,19.56,18.19,16.88,17.88,19.25,18.75,18.19,19.75,22.72,23.62,23.44,24.44,27.34,29.09,28.25,27.75,28.78,29.0,26.12,22.5,20.72,19.78,16.53,12.16,9.84,9.78,8.62,6.94,7.34,10.59,14.19,16.0,18.78,23.88,28.91,30.56,31.03,32.66,35.28,35.81,35.47,36.75,39.53,40.09,38.19,36.03,35.34,33.78,29.72,25.97,24.25,23.44,20.38,16.91,15.91,16.62,16.16,14.62,14.84,17.31,19.0,18.94,19.41,22.25,24.88,24.91,24.44,25.78,27.91,28.16,27.62,28.59,31.12,31.75,30.16,28.69,29.16,28.62,25.91,24.0,24.69,26.25,25.81,24.56,25.16,26.31,25.03,22.66,21.88,23.56,24.66,24.5,25.41,28.72,31.94,32.69,33.25,36.0,38.44,38.19,36.53,36.03,36.25,35.19,32.03,30.47,31.41,31.78,30.09,28.88,29.81,30.41,28.91,26.31,26.0,26.5,24.78,21.5,19.78,19.97,19.22,17.22,16.56,18.69,20.66,20.81,20.81,22.94,25.56,25.69,24.88,25.19,26.56,26.41,24.38,23.66,25.03,25.56,23.91,22.62,23.72,24.34,22.59,20.5,20.81,22.53,22.72,22.16,23.69,26.38,27.31,25.94,25.0,26.03,26.66,24.97,23.75,25.31,27.03,26.94,26.22,27.28,29.56,30.34,29.31,29.38,30.97,30.84,29.09,27.56,28.94,29.91,28.91,27.28,28.09,29.78,29.62,28.81,29.72,32.0,31.91,29.81,28.62,29.41,30.09,29.62,29.88,32.72,35.41,35.09,33.56,33.66,33.94,32.19,28.94,27.34,27.62,26.75,23.81,22.38,23.28,24.47,24.28,24.25,26.53,28.78,28.06,25.88,25.5,26.88,27.31,26.59,27.5,29.5,29.91,26.31,22.62,21.22,20.16,17.84,16.44,18.19,21.0,21.47,20.0,19.97,21.09,20.91,19.44,19.59,21.69,23.34,21.91,20.25,20.62,21.38,20.12,18.41,19.56,22.47,23.81,24.38,26.69,30.66,33.5,33.25,33.12,34.0,33.91,31.31,28.94,29.88,32.28,33.28,33.69,36.28,40.06,41.78,40.94,40.5,41.03,39.75,35.44,31.62,30.59,29.44,26.53,23.25,22.88,24.22,24.34,23.78,25.06,27.62,28.41,26.53,25.84,27.5,29.0,28.16,27.06,27.91,28.22,25.62,21.75,19.84,19.41,18.16,16.41,16.97,20.78,23.94,24.47,24.97,27.09,28.41,26.94,25.22,25.62,26.62,25.5,23.06,22.31,23.03,22.88,20.62,20.19,22.59,24.91,25.56,27.47,31.69,36.12,37.78,37.78,38.94,40.56,39.81,37.06,35.41,35.84,34.72,31.75,29.75,30.88,31.88,30.25,28.94,29.62,30.34,28.56,25.66,25.0,26.5,26.75,25.75,26.03,28.22,29.69,28.47,27.5,28.81,30.09,28.19,25.78,25.69,27.16,26.47,25.47,25.75,27.28,26.78,23.28,20.06,18.88,17.75,14.75,13.28,15.03,18.22,19.0,19.38,21.69,25.25,26.53,26.0,26.75,28.97,29.06,34.97,32.12,28.81,27.47,26.72,25.28,24.16,24.53,26.25,26.78,26.75,28.16,30.66,32.38,32.72,33.44,35.72,37.56,37.66,37.09,37.34,36.66,34.19,30.69,28.69,27.88,26.47,24.75:30.66,29.62,30.72,33.16,33.69,32.34,32.53,34.88,35.97,34.56,33.94,35.75,37.22,36.62,35.31,36.31,37.91,37.38,35.38,35.56,37.06,37.19,35.31,34.75,36.5,37.91,37.31,37.47,39.81,42.19,42.12,41.0,41.56,43.03,43.12,41.5,41.16,42.88,42.75,39.97,37.94,38.28,38.72,37.28,35.78,36.91,38.38,37.59,35.38,34.59,35.22,34.44,31.72,30.22,31.25,31.38,29.03,27.53,28.62,30.22,29.91,29.53,31.5,34.12,34.5,33.0,32.84,34.22,34.97,33.47,33.09,34.75,35.97,34.28,32.94,34.12,35.56,34.88,32.66,32.47,33.22,32.31,29.31,28.25,29.38,30.12,29.28,29.28,32.31,35.38,36.19,36.25,38.5,40.75,40.22,38.12,37.62,38.41,38.19,36.12,35.38,37.09,38.62,37.84,37.5,39.69,42.12,42.12,41.19,41.81,42.72,41.34,37.81,36.41,37.25,37.78,36.41,36.62,39.25,41.41,40.94,40.0,40.59,41.81,40.12,37.41,36.38,36.75,35.56,32.91,32.31,34.19,36.41,36.12,36.16,38.16,39.94,38.41,36.41,36.72,37.97,38.06,37.06,38.06,40.69,41.69,40.28,39.81,41.84,44.06,44.28,44.19,46.03,47.72,46.44,44.16,44.19,45.69,45.84,45.19,45.75,47.91,48.91,47.41,46.62,48.12,50.22,49.97,49.66,51.25,53.44,53.03,51.25,51.44,52.88,52.88,50.56,48.88,48.75,47.66,44.22,41.22,40.78,42.56,42.38,42.09,43.5,46.03,45.88,43.94,43.47,44.88,45.34,43.38,41.59,42.06,42.0,39.53,36.59,36.16,36.84,35.22,33.16,33.09,35.19,35.91,35.78,36.81,39.56,41.19,40.28,38.97,40.16,41.5,40.78,39.97,40.66,42.03,40.78,37.47,34.97,34.41,33.5,31.44,30.91,33.03,34.88,34.25,33.38,34.78,36.97,37.38,37.06,38.56,41.53,42.75,42.44,42.72,44.97,45.72,43.75,42.34,43.12,43.72,41.91,39.44,38.5,37.62,35.25,32.0,31.91,34.94,38.38,40.88,44.5,50.12,53.81,54.53,54.5,56.22,58.03,57.47,55.31,54.78,55.0,53.0,49.38,46.84,46.34,44.84,41.66,38.91,39.5,39.88,38.41,36.91,37.75,39.03,37.97,36.16,36.16,37.62,37.84,36.19,35.22,36.22,36.41,34.69,32.94,33.78,34.56,32.59,29.47,28.25,27.84,25.56,21.75,19.84,20.0,19.5,17.78,17.72,20.66,23.97,25.09,25.69,28.03,30.19,29.94,28.12,28.16,30.03,30.53,29.28,28.94,29.88,29.38,26.16,22.62,22.06,22.19,21.16,19.91,21.34,24.5,25.72,25.81,27.47,30.91,32.62,32.28,32.66,35.81,38.56,38.84,38.38,39.16,39.59,36.97,33.25,31.78,31.81,30.97,28.75,28.56,30.38,31.69,30.44,29.97,31.53,33.34,33.31,33.03,35.0,37.38,37.69,36.22,36.78,38.28,39.38,38.47,38.41,40.16,41.16,39.31,37.19,37.06,37.66,36.16,34.25,35.06,37.47,38.53,37.84,38.53,39.69,39.69,37.09,34.72,35.0,35.56,34.06,32.69,34.0,36.5,37.91,38.59,40.62,44.12,45.53,44.06,42.56,42.72,41.88,38.38,35.78,36.0,37.25,37.03,35.84,37.09,38.91,38.88,37.66,37.78,39.59,40.47,38.66,37.0,37.25,37.12,34.16,31.44,31.53,32.78,32.44,31.44,32.31,34.91,35.69,34.28,34.81,37.44,39.19,38.41,37.81,39.12,39.94,38.06,35.91,36.34,37.97,37.59,35.75,35.41,36.62,36.34,34.44,34.09,36.06,37.38,35.81,33.91,34.19,34.81,33.31,31.47,31.44,32.94,32.5,30.31,29.62,31.25,32.38,31.25,30.75,32.56,34.0,32.81,31.0,31.31,32.84,32.22,30.5,30.75,32.75,33.28,31.88,31.28,33.12,34.41,33.12,33.0,35.34,37.97,37.88,37.0,37.78,38.75,37.28,34.03,31.59,31.0,29.84,27.41,26.56,29.06,31.5,31.03,29.66,30.31,31.47,30.22,28.28,28.47,30.25,29.47,26.81,25.19,26.03,26.53,25.5,25.62,28.44,31.28,30.75,29.75,30.44,32.47,32.03,30.94,31.59,33.62,33.72,31.31,29.0,28.94,27.94,24.62,21.66,21.69,22.69,21.91,20.88,22.25,24.91,25.34,23.94,23.75,25.69,26.75,25.91,26.0,29.31,32.56,33.47,33.84,35.88,38.03,37.09,34.75,33.88,34.31,33.5,30.69,28.91,29.41,29.0,26.81,25.12,26.94,29.84,31.16,32.09,35.25,39.56,40.97,41.03,41.94,44.31,45.28,43.78,42.28,43.0,42.88,39.62,35.59,34.47,34.0,31.78,29.44,29.84,32.28,33.5,33.62,35.03,38.69,41.59,41.88,42.38,45.28,47.56,47.19,45.62,46.31,47.59,46.25,43.88,42.75,42.53,40.47,36.19,32.59,31.19,29.62,26.41,23.97,24.62,26.69,27.31,26.56,28.78,31.97,33.25,33.06,34.16,36.78,37.78,35.97,34.38,35.78,37.19,36.41,35.53,36.81,38.28,36.91,33.59,31.91,31.22,29.16,25.28,22.91,23.34,23.62,22.0,21.34,23.88,26.31,26.06,24.94,25.84,27.34,27.5,26.44,27.88,31.22,33.56,33.31,33.5,36.25,37.62,36.41,34.28,33.84,33.78,31.34,27.72,27.19,28.28,28.06,26.12,25.25,25.44,24.41,20.75,18.31,19.25,20.59,20.75,20.62,22.62,25.59,26.06,25.72,26.94,29.66,30.41,28.34,26.25,25.38,23.16,18.41,14.78,15.28,17.19,18.31,19.94,23.53,27.75,29.56,29.0,29.19,30.81,31.34,29.22,28.09,28.88,29.41,27.12,24.38,24.09,23.91,21.81,18.91,18.28,19.62,20.28,19.81,21.03,24.66,27.5,27.59,27.91,30.22,32.47,31.72,29.59,29.25,28.72,25.94,22.5,21.59,22.75,23.44,22.38,22.25,23.66,24.72,22.88,21.03,21.53,23.06,22.75,21.88,23.41,26.12,27.78,27.78,29.56,33.31,36.12,36.38,36.41,38.0,38.91,36.25,32.31,29.59,27.41,23.0,18.31,16.28,16.56,16.72,15.41,15.69,17.91,19.56,18.19,16.88,17.88,19.25,18.75,18.19,19.75,22.72,23.62,23.44,24.44,27.34,29.09,28.25,27.75,28.78,29.0,26.12,22.5,20.72,19.78,16.53,12.16,9.84,9.78,8.62,6.94,7.34,10.59,14.19,16.0,18.78,23.88,28.91,30.56,31.03,32.66,35.28,35.81,35.47,36.75,39.53,40.09,38.19,36.03,35.34,33.78,29.72,25.97,24.25,23.44,20.38,16.91,15.91,16.62,16.16,14.62,14.84,17.31,19.0,18.94,19.41,22.25,24.88,24.91,24.44,25.78,27.91,28.16,27.62,28.59,31.12,31.75,30.16,28.69,29.16,28.62,25.91,24.0,24.69,26.25,25.81,24.56,25.16,26.31,25.03,22.66,21.88,23.56,24.66,24.5,25.41,28.72,31.94,32.69,33.25,36.0,38.44,38.19,36.53,36.03,36.25,35.19,32.03,30.47,31.41,31.78,30.09,28.88,29.81,30.41,28.91,26.31,26.0,26.5,24.78,21.5,19.78,19.97,19.22,17.22,16.56,18.69,20.66,20.81,20.81,22.94,25.56,25.69,24.88,25.19,26.56,26.41,24.38,23.66,25.03,25.56,23.91,22.62,23.72,24.34,22.59,20.5,20.81,22.53,22.72,22.16,23.69,26.38,27.31,25.94,25.0,26.03,26.66,24.97,23.75,25.31,27.03,26.94,26.22,27.28,29.56,30.34,29.31,29.38,30.97,30.84,29.09,27.56,28.94,29.91,28.91,27.28,28.09,29.78,29.62,28.81,29.72,32.0,31.91,29.81,28.62,29.41,30.09,29.62,29.88,32.72,35.41,35.09,33.56,33.66,33.94,32.19,28.94,27.34,27.62,26.75,23.81,22.38,23.28,24.47,24.28,24.25,26.53,28.78,28.06,25.88,25.5,26.88,27.31,26.59,27.5,29.5,29.91,26.31,22.62,21.22,20.16,17.84,16.44,18.19,21.0,21.47,20.0,19.97,21.09,20.91,19.44,19.59,21.69,23.34,21.91,20.25,20.62,21.38,20.12,18.41,19.56,22.47,23.81,24.38,26.69,30.66,33.5,33.25,33.12,34.0,33.91,31.31,28.94,29.88,32.28,33.28,33.69,36.28,40.06,41.78,40.94,40.5,41.03,39.75,35.44,31.62,30.59,29.44,26.53,23.25,22.88,24.22,24.34,23.78,25.06,27.62,28.41,26.53,25.84,27.5,29.0,28.16,27.06,27.91,28.22,25.62,21.75,19.84,19.41,18.16,16.41,16.97,20.78,23.94,24.47,24.97,27.09,28.41,26.94,25.22,25.62,26.62,25.5,23.06,22.31,23.03,22.88,20.62,20.19,22.59,24.91,25.56,27.47,31.69,36.12,37.78,37.78,38.94,40.56,39.81,37.06,35.41,35.84,34.72,31.75,29.75,30.88,31.88,30.25,28.94,29.62,30.34,28.56,25.66,25.0,26.5,26.75,25.75,26.03,28.22,29.69,28.47,27.5,28.81,30.09,28.19,25.78,25.69,27.16,26.47,25.47,25.75,27.28,26.78,23.28,20.06,18.88,17.75,14.75,13.28,15.03,18.22,19.0,19.38,21.69,25.25,26.53,26.0,26.75,28.97,29.06,34.97,32.12,28.81,27.47,26.72,25.28,24.16,24.53,26.25,26.78,26.75,28.16,30.66,32.38,32.72,33.44,35.72,37.56,37.66,37.09,37.34,36.66,34.19,30.69,28.69,27.88,26.47,24.75,23.84,24.75,25.25,24.69,24.09,25.44,27.0:34.88,35.97,34.56,33.94,35.75,37.22,36.62,35.31,36.31,37.91,37.38,35.38,35.56,37.06,37.19,35.31,34.75,36.5,37.91,37.31,37.47,39.81,42.19,42.12,41.0,41.56,43.03,43.12,41.5,41.16,42.88,42.75,39.97,37.94,38.28,38.72,37.28,35.78,36.91,38.38,37.59,35.38,34.59,35.22,34.44,31.72,30.22,31.25,31.38,29.03,27.53,28.62,30.22,29.91,29.53,31.5,34.12,34.5,33.0,32.84,34.22,34.97,33.47,33.09,34.75,35.97,34.28,32.94,34.12,35.56,34.88,32.66,32.47,33.22,32.31,29.31,28.25,29.38,30.12,29.28,29.28,32.31,35.38,36.19,36.25,38.5,40.75,40.22,38.12,37.62,38.41,38.19,36.12,35.38,37.09,38.62,37.84,37.5,39.69,42.12,42.12,41.19,41.81,42.72,41.34,37.81,36.41,37.25,37.78,36.41,36.62,39.25,41.41,40.94,40.0,40.59,41.81,40.12,37.41,36.38,36.75,35.56,32.91,32.31,34.19,36.41,36.12,36.16,38.16,39.94,38.41,36.41,36.72,37.97,38.06,37.06,38.06,40.69,41.69,40.28,39.81,41.84,44.06,44.28,44.19,46.03,47.72,46.44,44.16,44.19,45.69,45.84,45.19,45.75,47.91,48.91,47.41,46.62,48.12,50.22,49.97,49.66,51.25,53.44,53.03,51.25,51.44,52.88,52.88,50.56,48.88,48.75,47.66,44.22,41.22,40.78,42.56,42.38,42.09,43.5,46.03,45.88,43.94,43.47,44.88,45.34,43.38,41.59,42.06,42.0,39.53,36.59,36.16,36.84,35.22,33.16,33.09,35.19,35.91,35.78,36.81,39.56,41.19,40.28,38.97,40.16,41.5,40.78,39.97,40.66,42.03,40.78,37.47,34.97,34.41,33.5,31.44,30.91,33.03,34.88,34.25,33.38,34.78,36.97,37.38,37.06,38.56,41.53,42.75,42.44,42.72,44.97,45.72,43.75,42.34,43.12,43.72,41.91,39.44,38.5,37.62,35.25,32.0,31.91,34.94,38.38,40.88,44.5,50.12,53.81,54.53,54.5,56.22,58.03,57.47,55.31,54.78,55.0,53.0,49.38,46.84,46.34,44.84,41.66,38.91,39.5,39.88,38.41,36.91,37.75,39.03,37.97,36.16,36.16,37.62,37.84,36.19,35.22,36.22,36.41,34.69,32.94,33.78,34.56,32.59,29.47,28.25,27.84,25.56,21.75,19.84,20.0,19.5,17.78,17.72,20.66,23.97,25.09,25.69,28.03,30.19,29.94,28.12,28.16,30.03,30.53,29.28,28.94,29.88,29.38,26.16,22.62,22.06,22.19,21.16,19.91,21.34,24.5,25.72,25.81,27.47,30.91,32.62,32.28,32.66,35.81,38.56,38.84,38.38,39.16,39.59,36.97,33.25,31.78,31.81,30.97,28.75,28.56,30.38,31.69,30.44,29.97,31.53,33.34,33.31,33.03,35.0,37.38,37.69,36.22,36.78,38.28,39.38,38.47,38.41,40.16,41.16,39.31,37.19,37.06,37.66,36.16,34.25,35.06,37.47,38.53,37.84,38.53,39.69,39.69,37.09,34.72,35.0,35.56,34.06,32.69,34.0,36.5,37.91,38.59,40.62,44.12,45.53,44.06,42.56,42.72,41.88,38.38,35.78,36.0,37.25,37.03,35.84,37.09,38.91,38.88,37.66,37.78,39.59,40.47,38.66,37.0,37.25,37.12,34.16,31.44,31.53,32.78,32.44,31.44,32.31,34.91,35.69,34.28,34.81,37.44,39.19,38.41,37.81,39.12,39.94,38.06,35.91,36.34,37.97,37.59,35.75,35.41,36.62,36.34,34.44,34.09,36.06,37.38,35.81,33.91,34.19,34.81,33.31,31.47,31.44,32.94,32.5,30.31,29.62,31.25,32.38,31.25,30.75,32.56,34.0,32.81,31.0,31.31,32.84,32.22,30.5,30.75,32.75,33.28,31.88,31.28,33.12,34.41,33.12,33.0,35.34,37.97,37.88,37.0,37.78,38.75,37.28,34.03,31.59,31.0,29.84,27.41,26.56,29.06,31.5,31.03,29.66,30.31,31.47,30.22,28.28,28.47,30.25,29.47,26.81,25.19,26.03,26.53,25.5,25.62,28.44,31.28,30.75,29.75,30.44,32.47,32.03,30.94,31.59,33.62,33.72,31.31,29.0,28.94,27.94,24.62,21.66,21.69,22.69,21.91,20.88,22.25,24.91,25.34,23.94,23.75,25.69,26.75,25.91,26.0,29.31,32.56,33.47,33.84,35.88,38.03,37.09,34.75,33.88,34.31,33.5,30.69,28.91,29.41,29.0,26.81,25.12,26.94,29.84,31.16,32.09,35.25,39.56,40.97,41.03,41.94,44.31,45.28,43.78,42.28,43.0,42.88,39.62,35.59,34.47,34.0,31.78,29.44,29.84,32.28,33.5,33.62,35.03,38.69,41.59,41.88,42.38,45.28,47.56,47.19,45.62,46.31,47.59,46.25,43.88,42.75,42.53,40.47,36.19,32.59,31.19,29.62,26.41,23.97,24.62,26.69,27.31,26.56,28.78,31.97,33.25,33.06,34.16,36.78,37.78,35.97,34.38,35.78,37.19,36.41,35.53,36.81,38.28,36.91,33.59,31.91,31.22,29.16,25.28,22.91,23.34,23.62,22.0,21.34,23.88,26.31,26.06,24.94,25.84,27.34,27.5,26.44,27.88,31.22,33.56,33.31,33.5,36.25,37.62,36.41,34.28,33.84,33.78,31.34,27.72,27.19,28.28,28.06,26.12,25.25,25.44,24.41,20.75,18.31,19.25,20.59,20.75,20.62,22.62,25.59,26.06,25.72,26.94,29.66,30.41,28.34,26.25,25.38,23.16,18.41,14.78,15.28,17.19,18.31,19.94,23.53,27.75,29.56,29.0,29.19,30.81,31.34,29.22,28.09,28.88,29.41,27.12,24.38,24.09,23.91,21.81,18.91,18.28,19.62,20.28,19.81,21.03,24.66,27.5,27.59,27.91,30.22,32.47,31.72,29.59,29.25,28.72,25.94,22.5,21.59,22.75,23.44,22.38,22.25,23.66,24.72,22.88,21.03,21.53,23.06,22.75,21.88,23.41,26.12,27.78,27.78,29.56,33.31,36.12,36.38,36.41,38.0,38.91,36.25,32.31,29.59,27.41,23.0,18.31,16.28,16.56,16.72,15.41,15.69,17.91,19.56,18.19,16.88,17.88,19.25,18.75,18.19,19.75,22.72,23.62,23.44,24.44,27.34,29.09,28.25,27.75,28.78,29.0,26.12,22.5,20.72,19.78,16.53,12.16,9.84,9.78,8.62,6.94,7.34,10.59,14.19,16.0,18.78,23.88,28.91,30.56,31.03,32.66,35.28,35.81,35.47,36.75,39.53,40.09,38.19,36.03,35.34,33.78,29.72,25.97,24.25,23.44,20.38,16.91,15.91,16.62,16.16,14.62,14.84,17.31,19.0,18.94,19.41,22.25,24.88,24.91,24.44,25.78,27.91,28.16,27.62,28.59,31.12,31.75,30.16,28.69,29.16,28.62,25.91,24.0,24.69,26.25,25.81,24.56,25.16,26.31,25.03,22.66,21.88,23.56,24.66,24.5,25.41,28.72,31.94,32.69,33.25,36.0,38.44,38.19,36.53,36.03,36.25,35.19,32.03,30.47,31.41,31.78,30.09,28.88,29.81,30.41,28.91,26.31,26.0,26.5,24.78,21.5,19.78,19.97,19.22,17.22,16.56,18.69,20.66,20.81,20.81,22.94,25.56,25.69,24.88,25.19,26.56,26.41,24.38,23.66,25.03,25.56,23.91,22.62,23.72,24.34,22.59,20.5,20.81,22.53,22.72,22.16,23.69,26.38,27.31,25.94,25.0,26.03,26.66,24.97,23.75,25.31,27.03,26.94,26.22,27.28,29.56,30.34,29.31,29.38,30.97,30.84,29.09,27.56,28.94,29.91,28.91,27.28,28.09,29.78,29.62,28.81,29.72,32.0,31.91,29.81,28.62,29.41,30.09,29.62,29.88,32.72,35.41,35.09,33.56,33.66,33.94,32.19,28.94,27.34,27.62,26.75,23.81,22.38,23.28,24.47,24.28,24.25,26.53,28.78,28.06,25.88,25.5,26.88,27.31,26.59,27.5,29.5,29.91,26.31,22.62,21.22,20.16,17.84,16.44,18.19,21.0,21.47,20.0,19.97,21.09,20.91,19.44,19.59,21.69,23.34,21.91,20.25,20.62,21.38,20.12,18.41,19.56,22.47,23.81,24.38,26.69,30.66,33.5,33.25,33.12,34.0,33.91,31.31,28.94,29.88,32.28,33.28,33.69,36.28,40.06,41.78,40.94,40.5,41.03,39.75,35.44,31.62,30.59,29.44,26.53,23.25,22.88,24.22,24.34,23.78,25.06,27.62,28.41,26.53,25.84,27.5,29.0,28.16,27.06,27.91,28.22,25.62,21.75,19.84,19.41,18.16,16.41,16.97,20.78,23.94,24.47,24.97,27.09,28.41,26.94,25.22,25.62,26.62,25.5,23.06,22.31,23.03,22.88,20.62,20.19,22.59,24.91,25.56,27.47,31.69,36.12,37.78,37.78,38.94,40.56,39.81,37.06,35.41,35.84,34.72,31.75,29.75,30.88,31.88,30.25,28.94,29.62,30.34,28.56,25.66,25.0,26.5,26.75,25.75,26.03,28.22,29.69,28.47,27.5,28.81,30.09,28.19,25.78,25.69,27.16,26.47,25.47,25.75,27.28,26.78,23.28,20.06,18.88,17.75,14.75,13.28,15.03,18.22,19.0,19.38,21.69,25.25,26.53,26.0,26.75,28.97,29.06,34.97,32.12,28.81,27.47,26.72,25.28,24.16,24.53,26.25,26.78,26.75,28.16,30.66,32.38,32.72,33.44,35.72,37.56,37.66,37.09,37.34,36.66,34.19,30.69,28.69,27.88,26.47,24.75,23.84,24.75,25.25,24.69,24.09,25.44,27.0,27.56,27.78,29.44,31.62,32.44,32.12,32.44:negativity
3.94,3.62,1.78,0.91,0.31,-2.16,-5.97,-8.66,-9.47,-10.69,-13.09,-14.03,-12.25,-10.47,-10.12,-9.47,-6.72,-2.94,-0.91,0.09,2.84,6.34,7.97,7.81,7.97,9.22,9.59,7.75,5.94,6.12,6.28,4.25,1.25,0.19,-0.06,-2.03,-4.62,-4.75,-3.06,-2.22,-3.09,-2.91,-1.06,0.16,-0.31,-0.78,1.47,3.88,4.0,3.56,4.56,6.09,5.88,4.28,4.03,4.91,4.53,2.25,0.12,0.28,0.59,-1.06,-2.53,-1.56,-0.28,-0.94,-2.66,-2.75,-1.81,-1.72,-2.75,-1.88,1.44,4.16,4.88,5.62,8.22,10.09,9.22,7.97,9.25,10.91,10.69,9.75,10.69,12.97,13.88,13.56,14.16,15.62,15.69,12.91,9.94,8.81,7.78,5.53,3.28,3.16,3.97,3.03,0.78,-0.44,-0.09,-1.0,-3.12,-4.16,-3.0,-2.12,-2.91,-3.66,-2.0,0.31,0.0,-1.06,-0.62,0.56,-0.09,-2.41,-2.75,-1.72,-1.5,-3.09,-3.62,-1.91,-0.41,-1.03,-2.0,-1.28,-0.62,-2.25,-4.62,-5.16,-4.56,-5.0,-6.62,-7.25,-6.16,-5.88,-7.88,-9.25,-8.16,-6.97,-7.81,-8.53,-6.72,-3.94,-2.97,-3.44,-2.75,-1.41,-1.53,-3.75,-4.31,-2.97,-2.34,-3.44,-4.22,-2.47,-0.34,0.22,0.19,1.78,3.59,3.0,1.03,-0.03,0.03,-0.88,-3.53,-5.06,-4.22,-3.59,-4.78,-5.56,-4.31,-3.03,-4.62,-7.22,-8.09,-8.06,-9.06,-10.66,-10.03,-7.41,-5.75,-6.56,-6.84,-5.78,-4.91,-6.56,-7.62,-6.34,-3.84,-2.94,-2.81,-1.34,0.12,-0.53,-3.53,-5.19,-4.97,-4.81,-6.5,-6.62,-4.59,-2.75,-2.75,-2.72,-1.03,1.16,1.25,0.09,0.44,2.09,2.25,0.38,-0.03,1.38,2.16,0.97,0.38,1.16,1.53,-0.78,-4.0,-4.62,-4.44,-6.06,-8.72,-10.12,-10.56,-12.09,-15.5,-17.47,-17.25,-16.97,-18.06,-17.94,-15.31,-11.81,-10.81,-10.62,-9.47,-8.44,-9.69,-12.72,-14.34,-14.41,-14.81,-16.44,-17.12,-15.75,-14.56,-16.06,-17.81,-17.09,-15.69,-15.97,-16.16,-14.22,-11.19,-9.47,-9.0,-7.16,-3.53,-0.59,0.44,1.75,4.53,6.72,5.34,3.0,2.25,2.28,0.38,-1.44,-0.78,1.94,4.12,4.72,6.91,10.62,13.31,12.94,12.31,12.91,12.5,9.0,4.66,1.44,-0.75,-4.66,-8.19,-9.0,-6.94,-4.97,-4.31,-2.81,-0.06,1.62,0.41,-0.69,0.59,2.19,1.94,1.22,2.25,4.0,3.59,2.31,2.12,3.78,4.0,1.72,-0.31,-0.84,-2.19,-5.88,-9.88,-11.91,-13.53,-17.56,-21.44,-22.78,-21.91,-21.88,-21.88,-20.22,-15.94,-12.78,-11.91,-10.53,-7.38,-4.44,-3.59,-2.84,-0.06,3.03,3.5,2.5,2.47,3.53,2.78,0.84,-0.12,1.0,1.69,0.41,-0.66,-0.25,-0.03,-2.81,-6.25,-7.22,-7.09,-8.25,-9.47,-9.31,-7.41,-7.38,-9.03,-10.47,-9.5,-9.03,-10.28,-11.53,-10.12,-8.16,-8.66,-9.44,-7.94,-5.38,-4.72,-4.75,-3.28,-0.38,0.78,-0.38,-1.19,-0.09,0.62,-1.41,-3.47,-3.5,-3.44,-5.56,-8.22,-8.44,-7.31,-7.53,-8.81,-8.81,-6.81,-6.03,-7.06,-7.09,-4.84,-3.22,-3.59,-4.47,-4.03,-3.16,-4.47,-5.91,-5.5,-3.34,-2.41,-3.03,-3.34,-1.81,-1.75,-3.88,-5.38,-4.44,-3.41,-4.66,-6.12,-5.09,-3.19,-3.31,-4.41,-4.16,-2.34,-2.41,-3.75,-3.91,-1.84,-0.97,-2.31,-3.62,-2.69,-1.5,-1.84,-3.03,-2.16,-0.56,-0.72,-2.69,-2.97,-1.91,-2.78,-5.44,-7.62,-7.31,-7.34,-8.28,-8.31,-5.34,-1.78,-0.53,-0.75,0.09,0.81,-0.69,-3.75,-5.38,-4.88,-5.0,-6.91,-7.97,-6.72,-6.0,-7.5,-9.19,-8.5,-7.53,-8.56,-10.0,-9.47,-7.44,-7.28,-8.47,-8.28,-6.25,-5.25,-6.44,-7.12,-5.28,-4.06,-4.94,-5.94,-4.97,-3.81,-4.91,-7.28,-8.41,-8.22,-9.38,-12.22,-13.78,-13.38,-14.03,-16.34,-17.97,-16.19,-14.03,-13.44,-13.75,-12.69,-11.09,-11.56,-12.81,-12.16,-8.91,-6.59,-5.78,-4.91,-2.72,-1.66,-3.59,-5.94,-5.81,-5.53,-6.91,-8.81,-8.5,-7.25,-7.5,-8.88,-9.03,-7.34,-6.84,-8.31,-8.91,-7.66,-7.0,-8.72,-10.12,-9.25,-8.12,-9.12,-11.22,-11.72,-11.78,-12.75,-15.19,-16.06,-14.84,-13.66,-14.0,-13.31,-10.12,-7.31,-7.16,-8.09,-7.56,-7.06,-8.59,-11.56,-12.38,-11.72,-11.91,-12.69,-11.59,-8.44,-6.38,-6.66,-7.5,-6.19,-5.28,-6.72,-8.38,-8.25,-7.56,-8.28,-10.19,-10.34,-8.94,-8.53,-9.66,-9.28,-6.72,-4.91,-4.72,-4.69,-2.53,-0.5,-0.97,-2.69,-2.78,-2.28,-3.91,-6.59,-8.25,-8.59,-9.75,-12.56,-14.0,-12.62,-11.41,-11.88,-12.12,-10.19,-8.25,-8.38,-9.53,-8.69,-7.03,-6.81,-8.0,-8.06,-7.03,-6.41,-7.47,-7.38,-4.56,-1.47,-0.34,0.59,3.47,6.81,7.88,7.06,7.44,7.78,6.06,1.88,-1.41,-3.25,-5.09,-8.34,-10.47,-9.5,-8.06,-7.94,-8.41,-6.41,-4.09,-3.62,-4.47,-4.28,-2.91,-2.81,-4.62,-5.09,-3.44,-2.19,-3.16,-4.53,-4.03,-4.0,-6.09,-8.81,-9.19,-8.09,-8.25,-9.19,-8.88,-7.56,-7.31,-9.94,-12.22,-13.09,-13.84,-16.09,-17.41,-16.0,-13.62,-13.12,-13.31,-11.59,-9.16,-7.72,-7.72,-6.62,-4.09,-2.84,-3.53,-4.03,-2.81,-1.88,-3.5,-5.53,-5.94,-6.34,-8.81,-11.97,-13.41,-13.56,-14.56,-16.66,-17.5,-16.25,-15.47,-17.0,-18.22,-17.38,-16.81,-18.03,-19.81,-19.59,-18.81,-20.12,-22.69,-23.91,-23.72,-24.25,-26.34,-26.88,-25.22,-23.59,-23.75,-23.12,-20.19,-16.53,-14.72,-13.5,-10.47,-6.56,-4.69,-4.53,-2.94,-0.78,0.0,-1.5,-3.22,-3.28,-4.38,-7.44,-9.84,-9.66,-8.59,-8.75,-9.62,-8.97,-7.62,-8.16,-9.94,-10.0,-8.47,-7.22,-7.94,-7.94,-6.38,-5.0,-6.22,-8.06,-8.06,-7.44,-8.94,-10.84,-10.78,-9.25,-8.75,-9.97,-9.91,-8.5,-7.88,-9.16,-10.88,-10.75,-10.5,-11.97,-13.41,-12.34,-9.94,-9.0,-8.62,-6.91,-4.28,-2.94,-3.84,-3.91,-2.31,-1.34,-3.19,-5.72,-6.72,-7.91,-10.66,-13.19,-13.31,-11.72,-11.34,-11.91,-11.06,-8.31,-6.56,-6.16,-5.34,-2.62,-0.19,-0.5,-1.72,-1.62,-1.84,-4.91,-9.09,-11.62,-12.41,-14.0,-15.97,-16.72,-15.94,-16.53,-19.78,-22.84,-24.12,-25.09,-27.91,-29.91,-29.03,-27.0,-26.03,-25.66,-23.84,-20.84,-19.09,-18.28,-15.88,-10.53,-4.78,-0.34,4.56,10.62,15.22,15.81,14.66,13.5,12.31,8.62,3.81,-0.41,-3.12,-6.91,-12.16,-16.19,-17.75,-18.81,-21.25,-22.28,-21.25,-19.97,-21.16,-23.59,-24.22,-23.41,-23.12,-22.75,-20.06,-15.09,-10.88,-9.06,-7.06,-4.03,-2.19,-3.66,-5.94,-6.81,-7.12,-9.31,-11.22,-11.19,-9.53,-9.38,-10.88,-11.66,-11.38,-12.44,-16.0,-19.91,-21.75,-23.16,-25.84,-28.06,-27.44,-26.09,-26.66,-27.78,-27.69,-25.62,-24.78,-24.88,-24.5,-22.06,-20.16,-20.16,-20.06,-18.03,-16.12,-16.22,-17.31,-17.06,-15.91,-16.88,-19.09,-20.31,-20.19,-20.94,-22.47,-22.5,-19.53,-16.31,-14.53,-13.34,-9.97,-7.25,-7.0,-8.25,-8.41,-8.09,-9.44,-12.28,-14.16,-14.0,-14.44,-16.12,-16.22,-13.38,-10.34,-9.06,-8.09,-5.41,-2.59,-2.47,-3.69,-4.25,-3.84,-5.53,-8.53,-10.31,-9.88,-9.91,-11.38,-11.97,-10.19,-8.44,-8.44,-8.84,-7.47,-4.97,-4.06,-4.19,-2.78,-0.31,0.31,-0.84,-1.78,-0.97,-0.72,-2.62,-3.94,-2.88,-1.66,-1.84,-2.41,-0.59,1.78,2.09,1.28,0.91,1.47,0.44,-2.31,-4.53,-4.31,-4.31,-5.81,-7.47,-6.62,-5.91,-6.81,-8.28,-7.97,-6.22,-6.03,-6.88,-6.56,-4.38,-2.88,-3.41,-3.84,-2.91,-3.09,-5.38,-8.22,-8.88,-8.47,-9.38,-11.12,-11.03,-9.91,-9.78,-11.31,-11.38,-9.84,-9.19,-10.44,-12.5,-12.88,-14.06,-17.03,-20.0,-19.44,-17.09,-15.28,-13.94,-10.91,-7.12,-4.84,-4.78,-4.56,-2.84,-2.19,-3.59,-5.06,-4.03,-2.28,-2.56,-2.81,-1.41,0.06,-0.62,-3.03,-4.91,-5.66,-6.94,-9.75,-11.44,-10.62,-9.81,-10.84,-11.72,-10.44,-8.19,-7.66,-8.06,-7.12,-5.78,-6.03,-7.94,-8.91,-8.12,-7.88,-9.09,-9.81,-8.72,-7.34,-7.5,-8.09,-6.0,-2.84,-1.59,-1.84,-0.88,0.97,1.34,0.03,-0.22,0.97,1.31,-0.5,-2.47,-2.62,-3.06,-5.06,-7.56,-7.69,-6.38,-6.72,-7.81,-7.44,-5.28,-3.81,-3.75,-2.62,0.25,2.53,2.12,1.91,3.53,5.72,6.0,5.34,6.47,7.56,6.56,2.94,0.66,-0.47,-2.16,-5.5,-7.66,-7.94,-8.31,-10.62,-12.78,-13.06,-12.5,-13.12,-14.72,-14.03,-11.16,-8.53,-7.16,-4.06,0.88,4.69,5.81,6.59,8.84,10.44,9.0,6.91,6.38,6.0,3.78,-0.03,-1.88,-2.62,-4.0,-7.0,-8.16,-7.12,-5.94,-6.75,-6.66,-4.06,-1.34,-0.47,-0.25,1.97,4.19,4.44,3.22,3.12,3.88,4.31,2.69,2.03,3.81,4.84,3.44,1.53,1.62,2.16,0.78,-1.62,-1.66,-0.44,-0.94,-3.16,-3.94,-3.5,-3.59,-5.38,-5.5,-2.84,0.03,1.06,2.12,4.81:-8.66,-9.47,-10.69,-13.09,-14.03,-12.25,-10.47,-10.12,-9.47,-6.72,-2.94,-0.91,0.09,2.84,6.34,7.97,7.81,7.97,9.22,9.59,7.75,5.94,6.12,6.28,4.25,1.25,0.19,-0.06,-2.03,-4.62,-4.75,-3.06,-2.22,-3.09,-2.91,-1.06,0.16,-0.31,-0.78,1.47,3.88,4.0,3.56,4.56,6.09,5.88,4.28,4.03,4.91,4.53,2.25,0.12,0.28,0.59,-1.06,-2.53,-1.56,-0.28,-0.94,-2.66,-2.75,-1.81,-1.72,-2.75,-1.88,1.44,4.16,4.88,5.62,8.22,10.09,9.22,7.97,9.25,10.91,10.69,9.75,10.69,12.97,13.88,13.56,14.16,15.62,15.69,12.91,9.94,8.81,7.78,5.53,3.28,3.16,3.97,3.03,0.78,-0.44,-0.09,-1.0,-3.12,-4.16,-3.0,-2.12,-2.91,-3.66,-2.0,0.31,0.0,-1.06,-0.62,0.56,-0.09,-2.41,-2.75,-1.72,-1.5,-3.09,-3.62,-1.91,-0.41,-1.03,-2.0,-1.28,-0.62,-2.25,-4.62,-5.16,-4.56,-5.0,-6.62,-7.25,-6.16,-5.88,-7.88,-9.25,-8.16,-6.97,-7.81,-8.53,-6.72,-3.94,-2.97,-3.44,-2.75,-1.41,-1.53,-3.75,-4.31,-2.97,-2.34,-3.44,-4.22,-2.47,-0.34,0.22,0.19,1.78,3.59,3.0,1.03,-0.03,0.03,-0.88,-3.53,-5.06,-4.22,-3.59,-4.78,-5.56,-4.31,-3.03,-4.62,-7.22,-8.09,-8.06,-9.06,-10.66,-10.03,-7.41,-5.75,-6.56,-6.84,-5.78,-4.91,-6.56,-7.62,-6.34,-3.84,-2.94,-2.81,-1.34,0.12,-0.53,-3.53,-5.19,-4.97,-4.81,-6.5,-6.62,-4.59,-2.75,-2.75,-2.72,-1.03,1.16,1.25,0.09,0.44,2.09,2.25,0.38,-0.03,1.38,2.16,0.97,0.38,1.16,1.53,-0.78,-4.0,-4.62,-4.44,-6.06,-8.72,-10.12,-10.56,-12.09,-15.5,-17.47,-17.25,-16.97,-18.06,-17.94,-15.31,-11.81,-10.81,-10.62,-9.47,-8.44,-9.69,-12.72,-14.34,-14.41,-14.81,-16.44,-17.12,-15.75,-14.56,-16.06,-17.81,-17.09,-15.69,-15.97,-16.16,-14.22,-11.19,-9.47,-9.0,-7.16,-3.53,-0.59,0.44,1.75,4.53,6.72,5.34,3.0,2.25,2.28,0.38,-1.44,-0.78,1.94,4.12,4.72,6.91,10.62,13.31,12.94,12.31,12.91,12.5,9.0,4.66,1.44,-0.75,-4.66,-8.19,-9.0,-6.94,-4.97,-4.31,-2.81,-0.06,1.62,0.41,-0.69,0.59,2.19,1.94,1.22,2.25,4.0,3.59,2.31,2.12,3.78,4.0,1.72,-0.31,-0.84,-2.19,-5.88,-9.88,-11.91,-13.53,-17.56,-21.44,-22.78,-21.91,-21.88,-21.88,-20.22,-15.94,-12.78,-11.91,-10.53,-7.38,-4.44,-3.59,-2.84,-0.06,3.03,3.5,2.5,2.47,3.53,2.78,0.84,-0.12,1.0,1.69,0.41,-0.66,-0.25,-0.03,-2.81,-6.25,-7.22,-7.09,-8.25,-9.47,-9.31,-7.41,-7.38,-9.03,-10.47,-9.5,-9.03,-10.28,-11.53,-10.12,-8.16,-8.66,-9.44,-7.94,-5.38,-4.72,-4.75,-3.28,-0.38,0.78,-0.38,-1.19,-0.09,0.62,-1.41,-3.47,-3.5,-3.44,-5.56,-8.22,-8.44,-7.31,-7.53,-8.81,-8.81,-6.81,-6.03,-7.06,-7.09,-4.84,-3.22,-3.59,-4.47,-4.03,-3.16,-4.47,-5.91,-5.5,-3.34,-2.41,-3.03,-3.34,-1.81,-1.75,-3.88,-5.38,-4.44,-3.41,-4.66,-6.12,-5.09,-3.19,-3.31,-4.41,-4.16,-2.34,-2.41,-3.75,-3.91,-1.84,-0.97,-2.31,-3.62,-2.69,-1.5,-1.84,-3.03,-2.16,-0.56,-0.72,-2.69,-2.97,-1.91,-2.78,-5.44,-7.62,-7.31,-7.34,-8.28,-8.31,-5.34,-1.78,-0.53,-0.75,0.09,0.81,-0.69,-3.75,-5.38,-4.88,-5.0,-6.91,-7.97,-6.72,-6.0,-7.5,-9.19,-8.5,-7.53,-8.56,-10.0,-9.47,-7.44,-7.28,-8.47,-8.28,-6.25,-5.25,-6.44,-7.12,-5.28,-4.06,-4.94,-5.94,-4.97,-3.81,-4.91,-7.28,-8.41,-8.22,-9.38,-12.22,-13.78,-13.38,-14.03,-16.34,-17.97,-16.19,-14.03,-13.44,-13.75,-12.69,-11.09,-11.56,-12.81,-12.16,-8.91,-6.59,-5.78,-4.91,-2.72,-1.66,-3.59,-5.94,-5.81,-5.53,-6.91,-8.81,-8.5,-7.25,-7.5,-8.88,-9.03,-7.34,-6.84,-8.31,-8.91,-7.66,-7.0,-8.72,-10.12,-9.25,-8.12,-9.12,-11.22,-11.72,-11.78,-12.75,-15.19,-16.06,-14.84,-13.66,-14.0,-13.31,-10.12,-7.31,-7.16,-8.09,-7.56,-7.06,-8.59,-11.56,-12.38,-11.72,-11.91,-12.69,-11.59,-8.44,-6.38,-6.66,-7.5,-6.19,-5.28,-6.72,-8.38,-8.25,-7.56,-8.28,-10.19,-10.34,-8.94,-8.53,-9.66,-9.28,-6.72,-4.91,-4.72,-4.69,-2.53,-0.5,-0.97,-2.69,-2.78,-2.28,-3.91,-6.59,-8.25,-8.59,-9.75,-12.56,-14.0,-12.62,-11.41,-11.88,-12.12,-10.19,-8.25,-8.38,-9.53,-8.69,-7.03,-6.81,-8.0,-8.06,-7.03,-6.41,-7.47,-7.38,-4.56,-1.47,-0.34,0.59,3.47,6.81,7.88,7.06,7.44,7.78,6.06,1.88,-1.41,-3.25,-5.09,-8.34,-10.47,-9.5,-8.06,-7.94,-8.41,-6.41,-4.09,-3.62,-4.47,-4.28,-2.91,-2.81,-4.62,-5.09,-3.44,-2.19,-3.16,-4.53,-4.03,-4.0,-6.09,-8.81,-9.19,-8.09,-8.25,-9.19,-8.88,-7.56,-7.31,-9.94,-12.22,-13.09,-13.84,-16.09,-17.41,-16.0,-13.62,-13.12,-13.31,-11.59,-9.16,-7.72,-7.72,-6.62,-4.09,-2.84,-3.53,-4.03,-2.81,-1.88,-3.5,-5.53,-5.94,-6.34,-8.81,-11.97,-13.41,-13.56,-14.56,-16.66,-17.5,-16.25,-15.47,-17.0,-18.22,-17.38,-16.81,-18.03,-19.81,-19.59,-18.81,-20.12,-22.69,-23.91,-23.72,-24.25,-26.34,-26.88,-25.22,-23.59,-23.75,-23.12,-20.19,-16.53,-14.72,-13.5,-10.47,-6.56,-4.69,-4.53,-2.94,-0.78,0.0,-1.5,-3.22,-3.28,-4.38,-7.44,-9.84,-9.66,-8.59,-8.75,-9.62,-8.97,-7.62,-8.16,-9.94,-10.0,-8.47,-7.22,-7.94,-7.94,-6.38,-5.0,-6.22,-8.06,-8.06,-7.44,-8.94,-10.84,-10.78,-9.25,-8.75,-9.97,-9.91,-8.5,-7.88,-9.16,-10.88,-10.75,-10.5,-11.97,-13.41,-12.34,-9.94,-9.0,-8.62,-6.91,-4.28,-2.94,-3.84,-3.91,-2.31,-1.34,-3.19,-5.72,-6.72,-7.91,-10.66,-13.19,-13.31,-11.72,-11.34,-11.91,-11.06,-8.31,-6.56,-6.16,-5.34,-2.62,-0.19,-0.5,-1.72,-1.62,-1.84,-4.91,-9.09,-11.62,-12.41,-14.0,-15.97,-16.72,-15.94,-16.53,-19.78,-22.84,-24.12,-25.09,-27.91,-29.91,-29.03,-27.0,-26.03,-25.66,-23.84,-20.84,-19.09,-18.28,-15.88,-10.53,-4.78,-0.34,4.56,10.62,15.22,15.81,14.66,13.5,12.31,8.62,3.81,-0.41,-3.12,-6.91,-12.16,-16.19,-17.75,-18.81,-21.25,-22.28,-21.25,-19.97,-21.16,-23.59,-24.22,-23.41,-23.12,-22.75,-20.06,-15.09,-10.88,-9.06,-7.06,-4.03,-2.19,-3.66,-5.94,-6.81,-7.12,-9.31,-11.22,-11.19,-9.53,-9.38,-10.88,-11.66,-11.38,-12.44,-16.0,-19.91,-21.75,-23.16,-25.84,-28.06,-27.44,-26.09,-26.66,-27.78,-27.69,-25.62,-24.78,-24.88,-24.5,-22.06,-20.16,-20.16,-20.06,-18.03,-16.12,-16.22,-17.31,-17.06,-15.91,-16.88,-19.09,-20.31,-20.19,-20.94,-22.47,-22.5,-19.53,-16.31,-14.53,-13.34,-9.97,-7.25,-7.0,-8.25,-8.41,-8.09,-9.44,-12.28,-14.16,-14.0,-14.44,-16.12,-16.22,-13.38,-10.34,-9.06,-8.09,-5.41,-2.59,-2.47,-3.69,-4.25,-3.84,-5.53,-8.53,-10.31,-9.88,-9.91,-11.38,-11.97,-10.19,-8.44,-8.44,-8.84,-7.47,-4.97,-4.06,-4.19,-2.78,-0.31,0.31,-0.84,-1.78,-0.97,-0.72,-2.62,-3.94,-2.88,-1.66,-1.84,-2.41,-0.59,1.78,2.09,1.28,0.91,1.47,0.44,-2.31,-4.53,-4.31,-4.31,-5.81,-7.47,-6.62,-5.91,-6.81,-8.28,-7.97,-6.22,-6.03,-6.88,-6.56,-4.38,-2.88,-3.41,-3.84,-2.91,-3.09,-5.38,-8.22,-8.88,-8.47,-9.38,-11.12,-11.03,-9.91,-9.78,-11.31,-11.38,-9.84,-9.19,-10.44,-12.5,-12.88,-14.06,-17.03,-20.0,-19.44,-17.09,-15.28,-13.94,-10.91,-7.12,-4.84,-4.78,-4.56,-2.84,-2.19,-3.59,-5.06,-4.03,-2.28,-2.56,-2.81,-1.41,0.06,-0.62,-3.03,-4.91,-5.66,-6.94,-9.75,-11.44,-10.62,-9.81,-10.84,-11.72,-10.44,-8.19,-7.66,-8.06,-7.12,-5.78,-6.03,-7.94,-8.91,-8.12,-7.88,-9.09,-9.81,-8.72,-7.34,-7.5,-8.09,-6.0,-2.84,-1.59,-1.84,-0.88,0.97,1.34,0.03,-0.22,0.97,1.31,-0.5,-2.47,-2.62,-3.06,-5.06,-7.56,-7.69,-6.38,-6.72,-7.81,-7.44,-5.28,-3.81,-3.75,-2.62,0.25,2.53,2.12,1.91,3.53,5.72,6.0,5.34,6.47,7.56,6.56,2.94,0.66,-0.47,-2.16,-5.5,-7.66,-7.94,-8.31,-10.62,-12.78,-13.06,-12.5,-13.12,-14.72,-14.03,-11.16,-8.53,-7.16,-4.06,0.88,4.69,5.81,6.59,8.84,10.44,9.0,6.91,6.38,6.0,3.78,-0.03,-1.88,-2.62,-4.0,-7.0,-8.16,-7.12,-5.94,-6.75,-6.66,-4.06,-1.34,-0.47,-0.25,1.97,4.19,4.44,3.22,3.12,3.88,4.31,2.69,2.03,3.81,4.84,3.44,1.53,1.62,2.16,0.78,-1.62,-1.66,-0.44,-0.94,-3.16,-3.94,-3.5,-3.59,-5.38,-5.5,-2.84,0.03,1.06,2.12,4.81,30.16,30.22,29.5,28.88,27.5,25.06,22.41:-10.12,-9.47,-6.72,-2.94,-0.91,0.09,2.84,6.34,7.97,7.81,7.97,9.22,9.59,7.75,5.94,6.12,6.28,4.25,1.25,0.19,-0.06,-2.03,-4.62,-4.75,-3.06,-2.22,-3.09,-2.91,-1.06,0.16,-0.31,-0.78,1.47,3.88,4.0,3.56,4.56,6.09,5.88,4.28,4.03,4.91,4.53,2.25,0.12,0.28,0.59,-1.06,-2.53,-1.56,-0.28,-0.94,-2.66,-2.75,-1.81,-1.72,-2.75,-1.88,1.44,4.16,4.88,5.62,8.22,10.09,9.22,7.97,9.25,10.91,10.69,9.75,10.69,12.97,13.88,13.56,14.16,15.62,15.69,12.91,9.94,8.81,7.78,5.53,3.28,3.16,3.97,3.03,0.78,-0.44,-0.09,-1.0,-3.12,-4.16,-3.0,-2.12,-2.91,-3.66,-2.0,0.31,0.0,-1.06,-0.62,0.56,-0.09,-2.41,-2.75,-1.72,-1.5,-3.09,-3.62,-1.91,-0.41,-1.03,-2.0,-1.28,-0.62,-2.25,-4.62,-5.16,-4.56,-5.0,-6.62,-7.25,-6.16,-5.88,-7.88,-9.25,-8.16,-6.97,-7.81,-8.53,-6.72,-3.94,-2.97,-3.44,-2.75,-1.41,-1.53,-3.75,-4.31,-2.97,-2.34,-3.44,-4.22,-2.47,-0.34,0.22,0.19,1.78,3.59,3.0,1.03,-0.03,0.03,-0.88,-3.53,-5.06,-4.22,-3.59,-4.78,-5.56,-4.31,-3.03,-4.62,-7.22,-8.09,-8.06,-9.06,-10.66,-10.03,-7.41,-5.75,-6.56,-6.84,-5.78,-4.91,-6.56,-7.62,-6.34,-3.84,-2.94,-2.81,-1.34,0.12,-0.53,-3.53,-5.19,-4.97,-4.81,-6.5,-6.62,-4.59,-2.75,-2.75,-2.72,-1.03,1.16,1.25,0.09,0.44,2.09,2.25,0.38,-0.03,1.38,2.16,0.97,0.38,1.16,1.53,-0.78,-4.0,-4.62,-4.44,-6.06,-8.72,-10.12,-10.56,-12.09,-15.5,-17.47,-17.25,-16.97,-18.06,-17.94,-15.31,-11.81,-10.81,-10.62,-9.47,-8.44,-9.69,-12.72,-14.34,-14.41,-14.81,-16.44,-17.12,-15.75,-14.56,-16.06,-17.81,-17.09,-15.69,-15.97,-16.16,-14.22,-11.19,-9.47,-9.0,-7.16,-3.53,-0.59,0.44,1.75,4.53,6.72,5.34,3.0,2.25,2.28,0.38,-1.44,-0.78,1.94,4.12,4.72,6.91,10.62,13.31,12.94,12.31,12.91,12.5,9.0,4.66,1.44,-0.75,-4.66,-8.19,-9.0,-6.94,-4.97,-4.31,-2.81,-0.06,1.62,0.41,-0.69,0.59,2.19,1.94,1.22,2.25,4.0,3.59,2.31,2.12,3.78,4.0,1.72,-0.31,-0.84,-2.19,-5.88,-9.88,-11.91,-13.53,-17.56,-21.44,-22.78,-21.91,-21.88,-21.88,-20.22,-15.94,-12.78,-11.91,-10.53,-7.38,-4.44,-3.59,-2.84,-0.06,3.03,3.5,2.5,2.47,3.53,2.78,0.84,-0.12,1.0,1.69,0.41,-0.66,-0.25,-0.03,-2.81,-6.25,-7.22,-7.09,-8.25,-9.47,-9.31,-7.41,-7.38,-9.03,-10.47,-9.5,-9.03,-10.28,-11.53,-10.12,-8.16,-8.66,-9.44,-7.94,-5.38,-4.72,-4.75,-3.28,-0.38,0.78,-0.38,-1.19,-0.09,0.62,-1.41,-3.47,-3.5,-3.44,-5.56,-8.22,-8.44,-7.31,-7.53,-8.81,-8.81,-6.81,-6.03,-7.06,-7.09,-4.84,-3.22,-3.59,-4.47,-4.03,-3.16,-4.47,-5.91,-5.5,-3.34,-2.41,-3.03,-3.34,-1.81,-1.75,-3.88,-5.38,-4.44,-3.41,-4.66,-6.12,-5.09,-3.19,-3.31,-4.41,-4.16,-2.34,-2.41,-3.75,-3.91,-1.84,-0.97,-2.31,-3.62,-2.69,-1.5,-1.84,-3.03,-2.16,-0.56,-0.72,-2.69,-2.97,-1.91,-2.78,-5.44,-7.62,-7.31,-7.34,-8.28,-8.31,-5.34,-1.78,-0.53,-0.75,0.09,0.81,-0.69,-3.75,-5.38,-4.88,-5.0,-6.91,-7.97,-6.72,-6.0,-7.5,-9.19,-8.5,-7.53,-8.56,-10.0,-9.47,-7.44,-7.28,-8.47,-8.28,-6.25,-5.25,-6.44,-7.12,-5.28,-4.06,-4.94,-5.94,-4.97,-3.81,-4.91,-7.28,-8.41,-8.22,-9.38,-12.22,-13.78,-13.38,-14.03,-16.34,-17.97,-16.19,-14.03,-13.44,-13.75,-12.69,-11.09,-11.56,-12.81,-12.16,-8.91,-6.59,-5.78,-4.91,-2.72,-1.66,-3.59,-5.94,-5.81,-5.53,-6.91,-8.81,-8.5,-7.25,-7.5,-8.88,-9.03,-7.34,-6.84,-8.31,-8.91,-7.66,-7.0,-8.72,-10.12,-9.25,-8.12,-9.12,-11.22,-11.72,-11.78,-12.75,-15.19,-16.06,-14.84,-13.66,-14.0,-13.31,-10.12,-7.31,-7.16,-8.09,-7.56,-7.06,-8.59,-11.56,-12.38,-11.72,-11.91,-12.69,-11.59,-8.44,-6.38,-6.66,-7.5,-6.19,-5.28,-6.72,-8.38,-8.25,-7.56,-8.28,-10.19,-10.34,-8.94,-8.53,-9.66,-9.28,-6.72,-4.91,-4.72,-4.69,-2.53,-0.5,-0.97,-2.69,-2.78,-2.28,-3.91,-6.59,-8.25,-8.59,-9.75,-12.56,-14.0,-12.62,-11.41,-11.88,-12.12,-10.19,-8.25,-8.38,-9.53,-8.69,-7.03,-6.81,-8.0,-8.06,-7.03,-6.41,-7.47,-7.38,-4.56,-1.47,-0.34,0.59,3.47,6.81,7.88,7.06,7.44,7.78,6.06,1.88,-1.41,-3.25,-5.09,-8.34,-10.47,-9.5,-8.06,-7.94,-8.41,-6.41,-4.09,-3.62,-4.47,-4.28,-2.91,-2.81,-4.62,-5.09,-3.44,-2.19,-3.16,-4.53,-4.03,-4.0,-6.09,-8.81,-9.19,-8.09,-8.25,-9.19,-8.88,-7.56,-7.31,-9.94,-12.22,-13.09,-13.84,-16.09,-17.41,-16.0,-13.62,-13.12,-13.31,-11.59,-9.16,-7.72,-7.72,-6.62,-4.09,-2.84,-3.53,-4.03,-2.81,-1.88,-3.5,-5.53,-5.94,-6.34,-8.81,-11.97,-13.41,-13.56,-14.56,-16.66,-17.5,-16.25,-15.47,-17.0,-18.22,-17.38,-16.81,-18.03,-19.81,-19.59,-18.81,-20.12,-22.69,-23.91,-23.72,-24.25,-26.34,-26.88,-25.22,-23.59,-23.75,-23.12,-20.19,-16.53,-14.72,-13.5,-10.47,-6.56,-4.69,-4.53,-2.94,-0.78,0.0,-1.5,-3.22,-3.28,-4.38,-7.44,-9.84,-9.66,-8.59,-8.75,-9.62,-8.97,-7.62,-8.16,-9.94,-10.0,-8.47,-7.22,-7.94,-7.94,-6.38,-5.0,-6.22,-8.06,-8.06,-7.44,-8.94,-10.84,-10.78,-9.25,-8.75,-9.97,-9.91,-8.5,-7.88,-9.16,-10.88,-10.75,-10.5,-11.97,-13.41,-12.34,-9.94,-9.0,-8.62,-6.91,-4.28,-2.94,-3.84,-3.91,-2.31,-1.34,-3.19,-5.72,-6.72,-7.91,-10.66,-13.19,-13.31,-11.72,-11.34,-11.91,-11.06,-8.31,-6.56,-6.16,-5.34,-2.62,-0.19,-0.5,-1.72,-1.62,-1.84,-4.91,-9.09,-11.62,-12.41,-14.0,-15.97,-16.72,-15.94,-16.53,-19.78,-22.84,-24.12,-25.09,-27.91,-29.91,-29.03,-27.0,-26.03,-25.66,-23.84,-20.84,-19.09,-18.28,-15.88,-10.53,-4.78,-0.34,4.56,10.62,15.22,15.81,14.66,13.5,12.31,8.62,3.81,-0.41,-3.12,-6.91,-12.16,-16.19,-17.75,-18.81,-21.25,-22.28,-21.25,-19.97,-21.16,-23.59,-24.22,-23.41,-23.12,-22.75,-20.06,-15.09,-10.88,-9.06,-7.06,-4.03,-2.19,-3.66,-5.94,-6.81,-7.12,-9.31,-11.22,-11.19,-9.53,-9.38,-10.88,-11.66,-11.38,-12.44,-16.0,-19.91,-21.75,-23.16,-25.84,-28.06,-27.44,-26.09,-26.66,-27.78,-27.69,-25.62,-24.78,-24.88,-24.5,-22.06,-20.16,-20.16,-20.06,-18.03,-16.12,-16.22,-17.31,-17.06,-15.91,-16.88,-19.09,-20.31,-20.19,-20.94,-22.47,-22.5,-19.53,-16.31,-14.53,-13.34,-9.97,-7.25,-7.0,-8.25,-8.41,-8.09,-9.44,-12.28,-14.16,-14.0,-14.44,-16.12,-16.22,-13.38,-10.34,-9.06,-8.09,-5.41,-2.59,-2.47,-3.69,-4.25,-3.84,-5.53,-8.53,-10.31,-9.88,-9.91,-11.38,-11.97,-10.19,-8.44,-8.44,-8.84,-7.47,-4.97,-4.06,-4.19,-2.78,-0.31,0.31,-0.84,-1.78,-0.97,-0.72,-2.62,-3.94,-2.88,-1.66,-1.84,-2.41,-0.59,1.78,2.09,1.28,0.91,1.47,0.44,-2.31,-4.53,-4.31,-4.31,-5.81,-7.47,-6.62,-5.91,-6.81,-8.28,-7.97,-6.22,-6.03,-6.88,-6.56,-4.38,-2.88,-3.41,-3.84,-2.91,-3.09,-5.38,-8.22,-8.88,-8.47,-9.38,-11.12,-11.03,-9.91,-9.78,-11.31,-11.38,-9.84,-9.19,-10.44,-12.5,-12.88,-14.06,-17.03,-20.0,-19.44,-17.09,-15.28,-13.94,-10.91,-7.12,-4.84,-4.78,-4.56,-2.84,-2.19,-3.59,-5.06,-4.03,-2.28,-2.56,-2.81,-1.41,0.06,-0.62,-3.03,-4.91,-5.66,-6.94,-9.75,-11.44,-10.62,-9.81,-10.84,-11.72,-10.44,-8.19,-7.66,-8.06,-7.12,-5.78,-6.03,-7.94,-8.91,-8.12,-7.88,-9.09,-9.81,-8.72,-7.34,-7.5,-8.09,-6.0,-2.84,-1.59,-1.84,-0.88,0.97,1.34,0.03,-0.22,0.97,1.31,-0.5,-2.47,-2.62,-3.06,-5.06,-7.56,-7.69,-6.38,-6.72,-7.81,-7.44,-5.28,-3.81,-3.75,-2.62,0.25,2.53,2.12,1.91,3.53,5.72,6.0,5.34,6.47,7.56,6.56,2.94,0.66,-0.47,-2.16,-5.5,-7.66,-7.94,-8.31,-10.62,-12.78,-13.06,-12.5,-13.12,-14.72,-14.03,-11.16,-8.53,-7.16,-4.06,0.88,4.69,5.81,6.59,8.84,10.44,9.0,6.91,6.38,6.0,3.78,-0.03,-1.88,-2.62,-4.0,-7.0,-8.16,-7.12,-5.94,-6.75,-6.66,-4.06,-1.34,-0.47,-0.25,1.97,4.19,4.44,3.22,3.12,3.88,4.31,2.69,2.03,3.81,4.84,3.44,1.53,1.62,2.16,0.78,-1.62,-1.66,-0.44,-0.94,-3.16,-3.94,-3.5,-3.59,-5.38,-5.5,-2.84,0.03,1.06,2.12,4.81,30.16,30.22,29.5,28.88,27.5,25.06,22.41,20.47,19.62,18.12,16.56,15.81,15.97,16.44:6.34,7.97,7.81,7.97,9.22,9.59,7.75,5.94,6.12,6.28,4.25,1.25,0.19,-0.06,-2.03,-4.62,-4.75,-3.06,-2.22,-3.09,-2.91,-1.06,0.16,-0.31,-0.78,1.47,3.88,4.0,3.56,4.56,6.09,5.88,4.28,4.03,4.91,4.53,2.25,0.12,0.28,0.59,-1.06,-2.53,-1.56,-0.28,-0.94,-2.66,-2.75,-1.81,-1.72,-2.75,-1.88,1.44,4.16,4.88,5.62,8.22,10.09,9.22,7.97,9.25,10.91,10.69,9.75,10.69,12.97,13.88,13.56,14.16,15.62,15.69,12.91,9.94,8.81,7.78,5.53,3.28,3.16,3.97,3.03,0.78,-0.44,-0.09,-1.0,-3.12,-4.16,-3.0,-2.12,-2.91,-3.66,-2.0,0.31,0.0,-1.06,-0.62,0.56,-0.09,-2.41,-2.75,-1.72,-1.5,-3.09,-3.62,-1.91,-0.41,-1.03,-2.0,-1.28,-0.62,-2.25,-4.62,-5.16,-4.56,-5.0,-6.62,-7.25,-6.16,-5.88,-7.88,-9.25,-8.16,-6.97,-7.81,-8.53,-6.72,-3.94,-2.97,-3.44,-2.75,-1.41,-1.53,-3.75,-4.31,-2.97,-2.34,-3.44,-4.22,-2.47,-0.34,0.22,0.19,1.78,3.59,3.0,1.03,-0.03,0.03,-0.88,-3.53,-5.06,-4.22,-3.59,-4.78,-5.56,-4.31,-3.03,-4.62,-7.22,-8.09,-8.06,-9.06,-10.66,-10.03,-7.41,-5.75,-6.56,-6.84,-5.78,-4.91,-6.56,-7.62,-6.34,-3.84,-2.94,-2.81,-1.34,0.12,-0.53,-3.53,-5.19,-4.97,-4.81,-6.5,-6.62,-4.59,-2.75,-2.75,-2.72,-1.03,1.16,1.25,0.09,0.44,2.09,2.25,0.38,-0.03,1.38,2.16,0.97,0.38,1.16,1.53,-0.78,-4.0,-4.62,-4.44,-6.06,-8.72,-10.12,-10.56,-12.09,-15.5,-17.47,-17.25,-16.97,-18.06,-17.94,-15.31,-11.81,-10.81,-10.62,-9.47,-8.44,-9.69,-12.72,-14.34,-14.41,-14.81,-16.44,-17.12,-15.75,-14.56,-16.06,-17.81,-17.09,-15.69,-15.97,-16.16,-14.22,-11.19,-9.47,-9.0,-7.16,-3.53,-0.59,0.44,1.75,4.53,6.72,5.34,3.0,2.25,2.28,0.38,-1.44,-0.78,1.94,4.12,4.72,6.91,10.62,13.31,12.94,12.31,12.91,12.5,9.0,4.66,1.44,-0.75,-4.66,-8.19,-9.0,-6.94,-4.97,-4.31,-2.81,-0.06,1.62,0.41,-0.69,0.59,2.19,1.94,1.22,2.25,4.0,3.59,2.31,2.12,3.78,4.0,1.72,-0.31,-0.84,-2.19,-5.88,-9.88,-11.91,-13.53,-17.56,-21.44,-22.78,-21.91,-21.88,-21.88,-20.22,-15.94,-12.78,-11.91,-10.53,-7.38,-4.44,-3.59,-2.84,-0.06,3.03,3.5,2.5,2.47,3.53,2.78,0.84,-0.12,1.0,1.69,0.41,-0.66,-0.25,-0.03,-2.81,-6.25,-7.22,-7.09,-8.25,-9.47,-9.31,-7.41,-7.38,-9.03,-10.47,-9.5,-9.03,-10.28,-11.53,-10.12,-8.16,-8.66,-9.44,-7.94,-5.38,-4.72,-4.75,-3.28,-0.38,0.78,-0.38,-1.19,-0.09,0.62,-1.41,-3.47,-3.5,-3.44,-5.56,-8.22,-8.44,-7.31,-7.53,-8.81,-8.81,-6.81,-6.03,-7.06,-7.09,-4.84,-3.22,-3.59,-4.47,-4.03,-3.16,-4.47,-5.91,-5.5,-3.34,-2.41,-3.03,-3.34,-1.81,-1.75,-3.88,-5.38,-4.44,-3.41,-4.66,-6.12,-5.09,-3.19,-3.31,-4.41,-4.16,-2.34,-2.41,-3.75,-3.91,-1.84,-0.97,-2.31,-3.62,-2.69,-1.5,-1.84,-3.03,-2.16,-0.56,-0.72,-2.69,-2.97,-1.91,-2.78,-5.44,-7.62,-7.31,-7.34,-8.28,-8.31,-5.34,-1.78,-0.53,-0.75,0.09,0.81,-0.69,-3.75,-5.38,-4.88,-5.0,-6.91,-7.97,-6.72,-6.0,-7.5,-9.19,-8.5,-7.53,-8.56,-10.0,-9.47,-7.44,-7.28,-8.47,-8.28,-6.25,-5.25,-6.44,-7.12,-5.28,-4.06,-4.94,-5.94,-4.97,-3.81,-4.91,-7.28,-8.41,-8.22,-9.38,-12.22,-13.78,-13.38,-14.03,-16.34,-17.97,-16.19,-14.03,-13.44,-13.75,-12.69,-11.09,-11.56,-12.81,-12.16,-8.91,-6.59,-5.78,-4.91,-2.72,-1.66,-3.59,-5.94,-5.81,-5.53,-6.91,-8.81,-8.5,-7.25,-7.5,-8.88,-9.03,-7.34,-6.84,-8.31,-8.91,-7.66,-7.0,-8.72,-10.12,-9.25,-8.12,-9.12,-11.22,-11.72,-11.78,-12.75,-15.19,-16.06,-14.84,-13.66,-14.0,-13.31,-10.12,-7.31,-7.16,-8.09,-7.56,-7.06,-8.59,-11.56,-12.38,-11.72,-11.91,-12.69,-11.59,-8.44,-6.38,-6.66,-7.5,-6.19,-5.28,-6.72,-8.38,-8.25,-7.56,-8.28,-10.19,-10.34,-8.94,-8.53,-9.66,-9.28,-6.72,-4.91,-4.72,-4.69,-2.53,-0.5,-0.97,-2.69,-2.78,-2.28,-3.91,-6.59,-8.25,-8.59,-9.75,-12.56,-14.0,-12.62,-11.41,-11.88,-12.12,-10.19,-8.25,-8.38,-9.53,-8.69,-7.03,-6.81,-8.0,-8.06,-7.03,-6.41,-7.47,-7.38,-4.56,-1.47,-0.34,0.59,3.47,6.81,7.88,7.06,7.44,7.78,6.06,1.88,-1.41,-3.25,-5.09,-8.34,-10.47,-9.5,-8.06,-7.94,-8.41,-6.41,-4.09,-3.62,-4.47,-4.28,-2.91,-2.81,-4.62,-5.09,-3.44,-2.19,-3.16,-4.53,-4.03,-4.0,-6.09,-8.81,-9.19,-8.09,-8.25,-9.19,-8.88,-7.56,-7.31,-9.94,-12.22,-13.09,-13.84,-16.09,-17.41,-16.0,-13.62,-13.12,-13.31,-11.59,-9.16,-7.72,-7.72,-6.62,-4.09,-2.84,-3.53,-4.03,-2.81,-1.88,-3.5,-5.53,-5.94,-6.34,-8.81,-11.97,-13.41,-13.56,-14.56,-16.66,-17.5,-16.25,-15.47,-17.0,-18.22,-17.38,-16.81,-18.03,-19.81,-19.59,-18.81,-20.12,-22.69,-23.91,-23.72,-24.25,-26.34,-26.88,-25.22,-23.59,-23.75,-23.12,-20.19,-16.53,-14.72,-13.5,-10.47,-6.56,-4.69,-4.53,-2.94,-0.78,0.0,-1.5,-3.22,-3.28,-4.38,-7.44,-9.84,-9.66,-8.59,-8.75,-9.62,-8.97,-7.62,-8.16,-9.94,-10.0,-8.47,-7.22,-7.94,-7.94,-6.38,-5.0,-6.22,-8.06,-8.06,-7.44,-8.94,-10.84,-10.78,-9.25,-8.75,-9.97,-9.91,-8.5,-7.88,-9.16,-10.88,-10.75,-10.5,-11.97,-13.41,-12.34,-9.94,-9.0,-8.62,-6.91,-4.28,-2.94,-3.84,-3.91,-2.31,-1.34,-3.19,-5.72,-6.72,-7.91,-10.66,-13.19,-13.31,-11.72,-11.34,-11.91,-11.06,-8.31,-6.56,-6.16,-5.34,-2.62,-0.19,-0.5,-1.72,-1.62,-1.84,-4.91,-9.09,-11.62,-12.41,-14.0,-15.97,-16.72,-15.94,-16.53,-19.78,-22.84,-24.12,-25.09,-27.91,-29.91,-29.03,-27.0,-26.03,-25.66,-23.84,-20.84,-19.09,-18.28,-15.88,-10.53,-4.78,-0.34,4.56,10.62,15.22,15.81,14.66,13.5,12.31,8.62,3.81,-0.41,-3.12,-6.91,-12.16,-16.19,-17.75,-18.81,-21.25,-22.28,-21.25,-19.97,-21.16,-23.59,-24.22,-23.41,-23.12,-22.75,-20.06,-15.09,-10.88,-9.06,-7.06,-4.03,-2.19,-3.66,-5.94,-6.81,-7.12,-9.31,-11.22,-11.19,-9.53,-9.38,-10.88,-11.66,-11.38,-12.44,-16.0,-19.91,-21.75,-23.16,-25.84,-28.06,-27.44,-26.09,-26.66,-27.78,-27.69,-25.62,-24.78,-24.88,-24.5,-22.06,-20.16,-20.16,-20.06,-18.03,-16.12,-16.22,-17.31,-17.06,-15.91,-16.88,-19.09,-20.31,-20.19,-20.94,-22.47,-22.5,-19.53,-16.31,-14.53,-13.34,-9.97,-7.25,-7.0,-8.25,-8.41,-8.09,-9.44,-12.28,-14.16,-14.0,-14.44,-16.12,-16.22,-13.38,-10.34,-9.06,-8.09,-5.41,-2.59,-2.47,-3.69,-4.25,-3.84,-5.53,-8.53,-10.31,-9.88,-9.91,-11.38,-11.97,-10.19,-8.44,-8.44,-8.84,-7.47,-4.97,-4.06,-4.19,-2.78,-0.31,0.31,-0.84,-1.78,-0.97,-0.72,-2.62,-3.94,-2.88,-1.66,-1.84,-2.41,-0.59,1.78,2.09,1.28,0.91,1.47,0.44,-2.31,-4.53,-4.31,-4.31,-5.81,-7.47,-6.62,-5.91,-6.81,-8.28,-7.97,-6.22,-6.03,-6.88,-6.56,-4.38,-2.88,-3.41,-3.84,-2.91,-3.09,-5.38,-8.22,-8.88,-8.47,-9.38,-11.12,-11.03,-9.91,-9.78,-11.31,-11.38,-9.84,-9.19,-10.44,-12.5,-12.88,-14.06,-17.03,-20.0,-19.44,-17.09,-15.28,-13.94,-10.91,-7.12,-4.84,-4.78,-4.56,-2.84,-2.19,-3.59,-5.06,-4.03,-2.28,-2.56,-2.81,-1.41,0.06,-0.62,-3.03,-4.91,-5.66,-6.94,-9.75,-11.44,-10.62,-9.81,-10.84,-11.72,-10.44,-8.19,-7.66,-8.06,-7.12,-5.78,-6.03,-7.94,-8.91,-8.12,-7.88,-9.09,-9.81,-8.72,-7.34,-7.5,-8.09,-6.0,-2.84,-1.59,-1.84,-0.88,0.97,1.34,0.03,-0.22,0.97,1.31,-0.5,-2.47,-2.62,-3.06,-5.06,-7.56,-7.69,-6.38,-6.72,-7.81,-7.44,-5.28,-3.81,-3.75,-2.62,0.25,2.53,2.12,1.91,3.53,5.72,6.0,5.34,6.47,7.56,6.56,2.94,0.66,-0.47,-2.16,-5.5,-7.66,-7.94,-8.31,-10.62,-12.78,-13.06,-12.5,-13.12,-14.72,-14.03,-11.16,-8.53,-7.16,-4.06,0.88,4.69,5.81,6.59,8.84,10.44,9.0,6.91,6.38,6.0,3.78,-0.03,-1.88,-2.62,-4.0,-7.0,-8.16,-7.12,-5.94,-6.75,-6.66,-4.06,-1.34,-0.47,-0.25,1.97,4.19,4.44,3.22,3.12,3.88,4.31,2.69,2.03,3.81,4.84,3.44,1.53,1.62,2.16,0.78,-1.62,-1.66,-0.44,-0.94,-3.16,-3.94,-3.5,-3.59,-5.38,-5.5,-2.84,0.03,1.06,2.12,4.81,30.16,30.22,29.5,28.88,27.5,25.06,22.41,20.47,19.62,18.12,16.56,15.81,15.97,16.44,16.06,16.69,18.62,20.88,22.38,23.09,25.03:5.94,6.12,6.28,4.25,1.25,0.19,-0.06,-2.03,-4.62,-4.75,-3.06,-2.22,-3.09,-2.91,-1.06,0.16,-0.31,-0.78,1.47,3.88,4.0,3.56,4.56,6.09,5.88,4.28,4.03,4.91,4.53,2.25,0.12,0.28,0.59,-1.06,-2.53,-1.56,-0.28,-0.94,-2.66,-2.75,-1.81,-1.72,-2.75,-1.88,1.44,4.16,4.88,5.62,8.22,10.09,9.22,7.97,9.25,10.91,10.69,9.75,10.69,12.97,13.88,13.56,14.16,15.62,15.69,12.91,9.94,8.81,7.78,5.53,3.28,3.16,3.97,3.03,0.78,-0.44,-0.09,-1.0,-3.12,-4.16,-3.0,-2.12,-2.91,-3.66,-2.0,0.31,0.0,-1.06,-0.62,0.56,-0.09,-2.41,-2.75,-1.72,-1.5,-3.09,-3.62,-1.91,-0.41,-1.03,-2.0,-1.28,-0.62,-2.25,-4.62,-5.16,-4.56,-5.0,-6.62,-7.25,-6.16,-5.88,-7.88,-9.25,-8.16,-6.97,-7.81,-8.53,-6.72,-3.94,-2.97,-3.44,-2.75,-1.41,-1.53,-3.75,-4.31,-2.97,-2.34,-3.44,-4.22,-2.47,-0.34,0.22,0.19,1.78,3.59,3.0,1.03,-0.03,0.03,-0.88,-3.53,-5.06,-4.22,-3.59,-4.78,-5.56,-4.31,-3.03,-4.62,-7.22,-8.09,-8.06,-9.06,-10.66,-10.03,-7.41,-5.75,-6.56,-6.84,-5.78,-4.91,-6.56,-7.62,-6.34,-3.84,-2.94,-2.81,-1.34,0.12,-0.53,-3.53,-5.19,-4.97,-4.81,-6.5,-6.62,-4.59,-2.75,-2.75,-2.72,-1.03,1.16,1.25,0.09,0.44,2.09,2.25,0.38,-0.03,1.38,2.16,0.97,0.38,1.16,1.53,-0.78,-4.0,-4.62,-4.44,-6.06,-8.72,-10.12,-10.56,-12.09,-15.5,-17.47,-17.25,-16.97,-18.06,-17.94,-15.31,-11.81,-10.81,-10.62,-9.47,-8.44,-9.69,-12.72,-14.34,-14.41,-14.81,-16.44,-17.12,-15.75,-14.56,-16.06,-17.81,-17.09,-15.69,-15.97,-16.16,-14.22,-11.19,-9.47,-9.0,-7.16,-3.53,-0.59,0.44,1.75,4.53,6.72,5.34,3.0,2.25,2.28,0.38,-1.44,-0.78,1.94,4.12,4.72,6.91,10.62,13.31,12.94,12.31,12.91,12.5,9.0,4.66,1.44,-0.75,-4.66,-8.19,-9.0,-6.94,-4.97,-4.31,-2.81,-0.06,1.62,0.41,-0.69,0.59,2.19,1.94,1.22,2.25,4.0,3.59,2.31,2.12,3.78,4.0,1.72,-0.31,-0.84,-2.19,-5.88,-9.88,-11.91,-13.53,-17.56,-21.44,-22.78,-21.91,-21.88,-21.88,-20.22,-15.94,-12.78,-11.91,-10.53,-7.38,-4.44,-3.59,-2.84,-0.06,3.03,3.5,2.5,2.47,3.53,2.78,0.84,-0.12,1.0,1.69,0.41,-0.66,-0.25,-0.03,-2.81,-6.25,-7.22,-7.09,-8.25,-9.47,-9.31,-7.41,-7.38,-9.03,-10.47,-9.5,-9.03,-10.28,-11.53,-10.12,-8.16,-8.66,-9.44,-7.94,-5.38,-4.72,-4.75,-3.28,-0.38,0.78,-0.38,-1.19,-0.09,0.62,-1.41,-3.47,-3.5,-3.44,-5.56,-8.22,-8.44,-7.31,-7.53,-8.81,-8.81,-6.81,-6.03,-7.06,-7.09,-4.84,-3.22,-3.59,-4.47,-4.03,-3.16,-4.47,-5.91,-5.5,-3.34,-2.41,-3.03,-3.34,-1.81,-1.75,-3.88,-5.38,-4.44,-3.41,-4.66,-6.12,-5.09,-3.19,-3.31,-4.41,-4.16,-2.34,-2.41,-3.75,-3.91,-1.84,-0.97,-2.31,-3.62,-2.69,-1.5,-1.84,-3.03,-2.16,-0.56,-0.72,-2.69,-2.97,-1.91,-2.78,-5.44,-7.62,-7.31,-7.34,-8.28,-8.31,-5.34,-1.78,-0.53,-0.75,0.09,0.81,-0.69,-3.75,-5.38,-4.88,-5.0,-6.91,-7.97,-6.72,-6.0,-7.5,-9.19,-8.5,-7.53,-8.56,-10.0,-9.47,-7.44,-7.28,-8.47,-8.28,-6.25,-5.25,-6.44,-7.12,-5.28,-4.06,-4.94,-5.94,-4.97,-3.81,-4.91,-7.28,-8.41,-8.22,-9.38,-12.22,-13.78,-13.38,-14.03,-16.34,-17.97,-16.19,-14.03,-13.44,-13.75,-12.69,-11.09,-11.56,-12.81,-12.16,-8.91,-6.59,-5.78,-4.91,-2.72,-1.66,-3.59,-5.94,-5.81,-5.53,-6.91,-8.81,-8.5,-7.25,-7.5,-8.88,-9.03,-7.34,-6.84,-8.31,-8.91,-7.66,-7.0,-8.72,-10.12,-9.25,-8.12,-9.12,-11.22,-11.72,-11.78,-12.75,-15.19,-16.06,-14.84,-13.66,-14.0,-13.31,-10.12,-7.31,-7.16,-8.09,-7.56,-7.06,-8.59,-11.56,-12.38,-11.72,-11.91,-12.69,-11.59,-8.44,-6.38,-6.66,-7.5,-6.19,-5.28,-6.72,-8.38,-8.25,-7.56,-8.28,-10.19,-10.34,-8.94,-8.53,-9.66,-9.28,-6.72,-4.91,-4.72,-4.69,-2.53,-0.5,-0.97,-2.69,-2.78,-2.28,-3.91,-6.59,-8.25,-8.59,-9.75,-12.56,-14.0,-12.62,-11.41,-11.88,-12.12,-10.19,-8.25,-8.38,-9.53,-8.69,-7.03,-6.81,-8.0,-8.06,-7.03,-6.41,-7.47,-7.38,-4.56,-1.47,-0.34,0.59,3.47,6.81,7.88,7.06,7.44,7.78,6.06,1.88,-1.41,-3.25,-5.09,-8.34,-10.47,-9.5,-8.06,-7.94,-8.41,-6.41,-4.09,-3.62,-4.47,-4.28,-2.91,-2.81,-4.62,-5.09,-3.44,-2.19,-3.16,-4.53,-4.03,-4.0,-6.09,-8.81,-9.19,-8.09,-8.25,-9.19,-8.88,-7.56,-7.31,-9.94,-12.22,-13.09,-13.84,-16.09,-17.41,-16.0,-13.62,-13.12,-13.31,-11.59,-9.16,-7.72,-7.72,-6.62,-4.09,-2.84,-3.53,-4.03,-2.81,-1.88,-3.5,-5.53,-5.94,-6.34,-8.81,-11.97,-13.41,-13.56,-14.56,-16.66,-17.5,-16.25,-15.47,-17.0,-18.22,-17.38,-16.81,-18.03,-19.81,-19.59,-18.81,-20.12,-22.69,-23.91,-23.72,-24.25,-26.34,-26.88,-25.22,-23.59,-23.75,-23.12,-20.19,-16.53,-14.72,-13.5,-10.47,-6.56,-4.69,-4.53,-2.94,-0.78,0.0,-1.5,-3.22,-3.28,-4.38,-7.44,-9.84,-9.66,-8.59,-8.75,-9.62,-8.97,-7.62,-8.16,-9.94,-10.0,-8.47,-7.22,-7.94,-7.94,-6.38,-5.0,-6.22,-8.06,-8.06,-7.44,-8.94,-10.84,-10.78,-9.25,-8.75,-9.97,-9.91,-8.5,-7.88,-9.16,-10.88,-10.75,-10.5,-11.97,-13.41,-12.34,-9.94,-9.0,-8.62,-6.91,-4.28,-2.94,-3.84,-3.91,-2.31,-1.34,-3.19,-5.72,-6.72,-7.91,-10.66,-13.19,-13.31,-11.72,-11.34,-11.91,-11.06,-8.31,-6.56,-6.16,-5.34,-2.62,-0.19,-0.5,-1.72,-1.62,-1.84,-4.91,-9.09,-11.62,-12.41,-14.0,-15.97,-16.72,-15.94,-16.53,-19.78,-22.84,-24.12,-25.09,-27.91,-29.91,-29.03,-27.0,-26.03,-25.66,-23.84,-20.84,-19.09,-18.28,-15.88,-10.53,-4.78,-0.34,4.56,10.62,15.22,15.81,14.66,13.5,12.31,8.62,3.81,-0.41,-3.12,-6.91,-12.16,-16.19,-17.75,-18.81,-21.25,-22.28,-21.25,-19.97,-21.16,-23.59,-24.22,-23.41,-23.12,-22.75,-20.06,-15.09,-10.88,-9.06,-7.06,-4.03,-2.19,-3.66,-5.94,-6.81,-7.12,-9.31,-11.22,-11.19,-9.53,-9.38,-10.88,-11.66,-11.38,-12.44,-16.0,-19.91,-21.75,-23.16,-25.84,-28.06,-27.44,-26.09,-26.66,-27.78,-27.69,-25.62,-24.78,-24.88,-24.5,-22.06,-20.16,-20.16,-20.06,-18.03,-16.12,-16.22,-17.31,-17.06,-15.91,-16.88,-19.09,-20.31,-20.19,-20.94,-22.47,-22.5,-19.53,-16.31,-14.53,-13.34,-9.97,-7.25,-7.0,-8.25,-8.41,-8.09,-9.44,-12.28,-14.16,-14.0,-14.44,-16.12,-16.22,-13.38,-10.34,-9.06,-8.09,-5.41,-2.59,-2.47,-3.69,-4.25,-3.84,-5.53,-8.53,-10.31,-9.88,-9.91,-11.38,-11.97,-10.19,-8.44,-8.44,-8.84,-7.47,-4.97,-4.06,-4.19,-2.78,-0.31,0.31,-0.84,-1.78,-0.97,-0.72,-2.62,-3.94,-2.88,-1.66,-1.84,-2.41,-0.59,1.78,2.09,1.28,0.91,1.47,0.44,-2.31,-4.53,-4.31,-4.31,-5.81,-7.47,-6.62,-5.91,-6.81,-8.28,-7.97,-6.22,-6.03,-6.88,-6.56,-4.38,-2.88,-3.41,-3.84,-2.91,-3.09,-5.38,-8.22,-8.88,-8.47,-9.38,-11.12,-11.03,-9.91,-9.78,-11.31,-11.38,-9.84,-9.19,-10.44,-12.5,-12.88,-14.06,-17.03,-20.0,-19.44,-17.09,-15.28,-13.94,-10.91,-7.12,-4.84,-4.78,-4.56,-2.84,-2.19,-3.59,-5.06,-4.03,-2.28,-2.56,-2.81,-1.41,0.06,-0.62,-3.03,-4.91,-5.66,-6.94,-9.75,-11.44,-10.62,-9.81,-10.84,-11.72,-10.44,-8.19,-7.66,-8.06,-7.12,-5.78,-6.03,-7.94,-8.91,-8.12,-7.88,-9.09,-9.81,-8.72,-7.34,-7.5,-8.09,-6.0,-2.84,-1.59,-1.84,-0.88,0.97,1.34,0.03,-0.22,0.97,1.31,-0.5,-2.47,-2.62,-3.06,-5.06,-7.56,-7.69,-6.38,-6.72,-7.81,-7.44,-5.28,-3.81,-3.75,-2.62,0.25,2.53,2.12,1.91,3.53,5.72,6.0,5.34,6.47,7.56,6.56,2.94,0.66,-0.47,-2.16,-5.5,-7.66,-7.94,-8.31,-10.62,-12.78,-13.06,-12.5,-13.12,-14.72,-14.03,-11.16,-8.53,-7.16,-4.06,0.88,4.69,5.81,6.59,8.84,10.44,9.0,6.91,6.38,6.0,3.78,-0.03,-1.88,-2.62,-4.0,-7.0,-8.16,-7.12,-5.94,-6.75,-6.66,-4.06,-1.34,-0.47,-0.25,1.97,4.19,4.44,3.22,3.12,3.88,4.31,2.69,2.03,3.81,4.84,3.44,1.53,1.62,2.16,0.78,-1.62,-1.66,-0.44,-0.94,-3.16,-3.94,-3.5,-3.59,-5.38,-5.5,-2.84,0.03,1.06,2.12,4.81,30.16,30.22,29.5,28.88,27.5,25.06,22.41,20.47,19.62,18.12,16.56,15.81,15.97,16.44,16.06,16.69,18.62,20.88,22.38,23.09,25.03,26.31,26.47,25.75,25.59,26.03,25.78,25.0:-2.03,-4.62,-4.75,-3.06,-2.22,-3.09,-2.91,-1.06,0.16,-0.31,-0.78,1.47,3.88,4.0,3.56,4.56,6.09,5.88,4.28,4.03,4.91,4.53,2.25,0.12,0.28,0.59,-1.06,-2.53,-1.56,-0.28,-0.94,-2.66,-2.75,-1.81,-1.72,-2.75,-1.88,1.44,4.16,4.88,5.62,8.22,10.09,9.22,7.97,9.25,10.91,10.69,9.75,10.69,12.97,13.88,13.56,14.16,15.62,15.69,12.91,9.94,8.81,7.78,5.53,3.28,3.16,3.97,3.03,0.78,-0.44,-0.09,-1.0,-3.12,-4.16,-3.0,-2.12,-2.91,-3.66,-2.0,0.31,0.0,-1.06,-0.62,0.56,-0.09,-2.41,-2.75,-1.72,-1.5,-3.09,-3.62,-1.91,-0.41,-1.03,-2.0,-1.28,-0.62,-2.25,-4.62,-5.16,-4.56,-5.0,-6.62,-7.25,-6.16,-5.88,-7.88,-9.25,-8.16,-6.97,-7.81,-8.53,-6.72,-3.94,-2.97,-3.44,-2.75,-1.41,-1.53,-3.75,-4.31,-2.97,-2.34,-3.44,-4.22,-2.47,-0.34,0.22,0.19,1.78,3.59,3.0,1.03,-0.03,0.03,-0.88,-3.53,-5.06,-4.22,-3.59,-4.78,-5.56,-4.31,-3.03,-4.62,-7.22,-8.09,-8.06,-9.06,-10.66,-10.03,-7.41,-5.75,-6.56,-6.84,-5.78,-4.91,-6.56,-7.62,-6.34,-3.84,-2.94,-2.81,-1.34,0.12,-0.53,-3.53,-5.19,-4.97,-4.81,-6.5,-6.62,-4.59,-2.75,-2.75,-2.72,-1.03,1.16,1.25,0.09,0.44,2.09,2.25,0.38,-0.03,1.38,2.16,0.97,0.38,1.16,1.53,-0.78,-4.0,-4.62,-4.44,-6.06,-8.72,-10.12,-10.56,-12.09,-15.5,-17.47,-17.25,-16.97,-18.06,-17.94,-15.31,-11.81,-10.81,-10.62,-9.47,-8.44,-9.69,-12.72,-14.34,-14.41,-14.81,-16.44,-17.12,-15.75,-14.56,-16.06,-17.81,-17.09,-15.69,-15.97,-16.16,-14.22,-11.19,-9.47,-9.0,-7.16,-3.53,-0.59,0.44,1.75,4.53,6.72,5.34,3.0,2.25,2.28,0.38,-1.44,-0.78,1.94,4.12,4.72,6.91,10.62,13.31,12.94,12.31,12.91,12.5,9.0,4.66,1.44,-0.75,-4.66,-8.19,-9.0,-6.94,-4.97,-4.31,-2.81,-0.06,1.62,0.41,-0.69,0.59,2.19,1.94,1.22,2.25,4.0,3.59,2.31,2.12,3.78,4.0,1.72,-0.31,-0.84,-2.19,-5.88,-9.88,-11.91,-13.53,-17.56,-21.44,-22.78,-21.91,-21.88,-21.88,-20.22,-15.94,-12.78,-11.91,-10.53,-7.38,-4.44,-3.59,-2.84,-0.06,3.03,3.5,2.5,2.47,3.53,2.78,0.84,-0.12,1.0,1.69,0.41,-0.66,-0.25,-0.03,-2.81,-6.25,-7.22,-7.09,-8.25,-9.47,-9.31,-7.41,-7.38,-9.03,-10.47,-9.5,-9.03,-10.28,-11.53,-10.12,-8.16,-8.66,-9.44,-7.94,-5.38,-4.72,-4.75,-3.28,-0.38,0.78,-0.38,-1.19,-0.09,0.62,-1.41,-3.47,-3.5,-3.44,-5.56,-8.22,-8.44,-7.31,-7.53,-8.81,-8.81,-6.81,-6.03,-7.06,-7.09,-4.84,-3.22,-3.59,-4.47,-4.03,-3.16,-4.47,-5.91,-5.5,-3.34,-2.41,-3.03,-3.34,-1.81,-1.75,-3.88,-5.38,-4.44,-3.41,-4.66,-6.12,-5.09,-3.19,-3.31,-4.41,-4.16,-2.34,-2.41,-3.75,-3.91,-1.84,-0.97,-2.31,-3.62,-2.69,-1.5,-1.84,-3.03,-2.16,-0.56,-0.72,-2.69,-2.97,-1.91,-2.78,-5.44,-7.62,-7.31,-7.34,-8.28,-8.31,-5.34,-1.78,-0.53,-0.75,0.09,0.81,-0.69,-3.75,-5.38,-4.88,-5.0,-6.91,-7.97,-6.72,-6.0,-7.5,-9.19,-8.5,-7.53,-8.56,-10.0,-9.47,-7.44,-7.28,-8.47,-8.28,-6.25,-5.25,-6.44,-7.12,-5.28,-4.06,-4.94,-5.94,-4.97,-3.81,-4.91,-7.28,-8.41,-8.22,-9.38,-12.22,-13.78,-13.38,-14.03,-16.34,-17.97,-16.19,-14.03,-13.44,-13.75,-12.69,-11.09,-11.56,-12.81,-12.16,-8.91,-6.59,-5.78,-4.91,-2.72,-1.66,-3.59,-5.94,-5.81,-5.53,-6.91,-8.81,-8.5,-7.25,-7.5,-8.88,-9.03,-7.34,-6.84,-8.31,-8.91,-7.66,-7.0,-8.72,-10.12,-9.25,-8.12,-9.12,-11.22,-11.72,-11.78,-12.75,-15.19,-16.06,-14.84,-13.66,-14.0,-13.31,-10.12,-7.31,-7.16,-8.09,-7.56,-7.06,-8.59,-11.56,-12.38,-11.72,-11.91,-12.69,-11.59,-8.44,-6.38,-6.66,-7.5,-6.19,-5.28,-6.72,-8.38,-8.25,-7.56,-8.28,-10.19,-10.34,-8.94,-8.53,-9.66,-9.28,-6.72,-4.91,-4.72,-4.69,-2.53,-0.5,-0.97,-2.69,-2.78,-2.28,-3.91,-6.59,-8.25,-8.59,-9.75,-12.56,-14.0,-12.62,-11.41,-11.88,-12.12,-10.19,-8.25,-8.38,-9.53,-8.69,-7.03,-6.81,-8.0,-8.06,-7.03,-6.41,-7.47,-7.38,-4.56,-1.47,-0.34,0.59,3.47,6.81,7.88,7.06,7.44,7.78,6.06,1.88,-1.41,-3.25,-5.09,-8.34,-10.47,-9.5,-8.06,-7.94,-8.41,-6.41,-4.09,-3.62,-4.47,-4.28,-2.91,-2.81,-4.62,-5.09,-3.44,-2.19,-3.16,-4.53,-4.03,-4.0,-6.09,-8.81,-9.19,-8.09,-8.25,-9.19,-8.88,-7.56,-7.31,-9.94,-12.22,-13.09,-13.84,-16.09,-17.41,-16.0,-13.62,-13.12,-13.31,-11.59,-9.16,-7.72,-7.72,-6.62,-4.09,-2.84,-3.53,-4.03,-2.81,-1.88,-3.5,-5.53,-5.94,-6.34,-8.81,-11.97,-13.41,-13.56,-14.56,-16.66,-17.5,-16.25,-15.47,-17.0,-18.22,-17.38,-16.81,-18.03,-19.81,-19.59,-18.81,-20.12,-22.69,-23.91,-23.72,-24.25,-26.34,-26.88,-25.22,-23.59,-23.75,-23.12,-20.19,-16.53,-14.72,-13.5,-10.47,-6.56,-4.69,-4.53,-2.94,-0.78,0.0,-1.5,-3.22,-3.28,-4.38,-7.44,-9.84,-9.66,-8.59,-8.75,-9.62,-8.97,-7.62,-8.16,-9.94,-10.0,-8.47,-7.22,-7.94,-7.94,-6.38,-5.0,-6.22,-8.06,-8.06,-7.44,-8.94,-10.84,-10.78,-9.25,-8.75,-9.97,-9.91,-8.5,-7.88,-9.16,-10.88,-10.75,-10.5,-11.97,-13.41,-12.34,-9.94,-9.0,-8.62,-6.91,-4.28,-2.94,-3.84,-3.91,-2.31,-1.34,-3.19,-5.72,-6.72,-7.91,-10.66,-13.19,-13.31,-11.72,-11.34,-11.91,-11.06,-8.31,-6.56,-6.16,-5.34,-2.62,-0.19,-0.5,-1.72,-1.62,-1.84,-4.91,-9.09,-11.62,-12.41,-14.0,-15.97,-16.72,-15.94,-16.53,-19.78,-22.84,-24.12,-25.09,-27.91,-29.91,-29.03,-27.0,-26.03,-25.66,-23.84,-20.84,-19.09,-18.28,-15.88,-10.53,-4.78,-0.34,4.56,10.62,15.22,15.81,14.66,13.5,12.31,8.62,3.81,-0.41,-3.12,-6.91,-12.16,-16.19,-17.75,-18.81,-21.25,-22.28,-21.25,-19.97,-21.16,-23.59,-24.22,-23.41,-23.12,-22.75,-20.06,-15.09,-10.88,-9.06,-7.06,-4.03,-2.19,-3.66,-5.94,-6.81,-7.12,-9.31,-11.22,-11.19,-9.53,-9.38,-10.88,-11.66,-11.38,-12.44,-16.0,-19.91,-21.75,-23.16,-25.84,-28.06,-27.44,-26.09,-26.66,-27.78,-27.69,-25.62,-24.78,-24.88,-24.5,-22.06,-20.16,-20.16,-20.06,-18.03,-16.12,-16.22,-17.31,-17.06,-15.91,-16.88,-19.09,-20.31,-20.19,-20.94,-22.47,-22.5,-19.53,-16.31,-14.53,-13.34,-9.97,-7.25,-7.0,-8.25,-8.41,-8.09,-9.44,-12.28,-14.16,-14.0,-14.44,-16.12,-16.22,-13.38,-10.34,-9.06,-8.09,-5.41,-2.59,-2.47,-3.69,-4.25,-3.84,-5.53,-8.53,-10.31,-9.88,-9.91,-11.38,-11.97,-10.19,-8.44,-8.44,-8.84,-7.47,-4.97,-4.06,-4.19,-2.78,-0.31,0.31,-0.84,-1.78,-0.97,-0.72,-2.62,-3.94,-2.88,-1.66,-1.84,-2.41,-0.59,1.78,2.09,1.28,0.91,1.47,0.44,-2.31,-4.53,-4.31,-4.31,-5.81,-7.47,-6.62,-5.91,-6.81,-8.28,-7.97,-6.22,-6.03,-6.88,-6.56,-4.38,-2.88,-3.41,-3.84,-2.91,-3.09,-5.38,-8.22,-8.88,-8.47,-9.38,-11.12,-11.03,-9.91,-9.78,-11.31,-11.38,-9.84,-9.19,-10.44,-12.5,-12.88,-14.06,-17.03,-20.0,-19.44,-17.09,-15.28,-13.94,-10.91,-7.12,-4.84,-4.78,-4.56,-2.84,-2.19,-3.59,-5.06,-4.03,-2.28,-2.56,-2.81,-1.41,0.06,-0.62,-3.03,-4.91,-5.66,-6.94,-9.75,-11.44,-10.62,-9.81,-10.84,-11.72,-10.44,-8.19,-7.66,-8.06,-7.12,-5.78,-6.03,-7.94,-8.91,-8.12,-7.88,-9.09,-9.81,-8.72,-7.34,-7.5,-8.09,-6.0,-2.84,-1.59,-1.84,-0.88,0.97,1.34,0.03,-0.22,0.97,1.31,-0.5,-2.47,-2.62,-3.06,-5.06,-7.56,-7.69,-6.38,-6.72,-7.81,-7.44,-5.28,-3.81,-3.75,-2.62,0.25,2.53,2.12,1.91,3.53,5.72,6.0,5.34,6.47,7.56,6.56,2.94,0.66,-0.47,-2.16,-5.5,-7.66,-7.94,-8.31,-10.62,-12.78,-13.06,-12.5,-13.12,-14.72,-14.03,-11.16,-8.53,-7.16,-4.06,0.88,4.69,5.81,6.59,8.84,10.44,9.0,6.91,6.38,6.0,3.78,-0.03,-1.88,-2.62,-4.0,-7.0,-8.16,-7.12,-5.94,-6.75,-6.66,-4.06,-1.34,-0.47,-0.25,1.97,4.19,4.44,3.22,3.12,3.88,4.31,2.69,2.03,3.81,4.84,3.44,1.53,1.62,2.16,0.78,-1.62,-1.66,-0.44,-0.94,-3.16,-3.94,-3.5,-3.59,-5.38,-5.5,-2.84,0.03,1.06,2.12,4.81,30.16,30.22,29.5,28.88,27.5,25.06,22.41,20.47,19.62,18.12,16.56,15.81,15.97,16.44,16.06,16.69,18.62,20.88,22.38,23.09,25.03,26.31,26.47,25.75,25.59,26.03,25.78,25.0,24.25,24.5,24.44,22.72,20.78,19.53,18.16:-1.06,0.16,-0.31,-0.78,1.47,3.88,4.0,3.56,4.56,6.09,5.88,4.28,4.03,4.91,4.53,2.25,0.12,0.28,0.59,-1.06,-2.53,-1.56,-0.28,-0.94,-2.66,-2.75,-1.81,-1.72,-2.75,-1.88,1.44,4.16,4.88,5.62,8.22,10.09,9.22,7.97,9.25,10.91,10.69,9.75,10.69,12.97,13.88,13.56,14.16,15.62,15.69,12.91,9.94,8.81,7.78,5.53,3.28,3.16,3.97,3.03,0.78,-0.44,-0.09,-1.0,-3.12,-4.16,-3.0,-2.12,-2.91,-3.66,-2.0,0.31,0.0,-1.06,-0.62,0.56,-0.09,-2.41,-2.75,-1.72,-1.5,-3.09,-3.62,-1.91,-0.41,-1.03,-2.0,-1.28,-0.62,-2.25,-4.62,-5.16,-4.56,-5.0,-6.62,-7.25,-6.16,-5.88,-7.88,-9.25,-8.16,-6.97,-7.81,-8.53,-6.72,-3.94,-2.97,-3.44,-2.75,-1.41,-1.53,-3.75,-4.31,-2.97,-2.34,-3.44,-4.22,-2.47,-0.34,0.22,0.19,1.78,3.59,3.0,1.03,-0.03,0.03,-0.88,-3.53,-5.06,-4.22,-3.59,-4.78,-5.56,-4.31,-3.03,-4.62,-7.22,-8.09,-8.06,-9.06,-10.66,-10.03,-7.41,-5.75,-6.56,-6.84,-5.78,-4.91,-6.56,-7.62,-6.34,-3.84,-2.94,-2.81,-1.34,0.12,-0.53,-3.53,-5.19,-4.97,-4.81,-6.5,-6.62,-4.59,-2.75,-2.75,-2.72,-1.03,1.16,1.25,0.09,0.44,2.09,2.25,0.38,-0.03,1.38,2.16,0.97,0.38,1.16,1.53,-0.78,-4.0,-4.62,-4.44,-6.06,-8.72,-10.12,-10.56,-12.09,-15.5,-17.47,-17.25,-16.97,-18.06,-17.94,-15.31,-11.81,-10.81,-10.62,-9.47,-8.44,-9.69,-12.72,-14.34,-14.41,-14.81,-16.44,-17.12,-15.75,-14.56,-16.06,-17.81,-17.09,-15.69,-15.97,-16.16,-14.22,-11.19,-9.47,-9.0,-7.16,-3.53,-0.59,0.44,1.75,4.53,6.72,5.34,3.0,2.25,2.28,0.38,-1.44,-0.78,1.94,4.12,4.72,6.91,10.62,13.31,12.94,12.31,12.91,12.5,9.0,4.66,1.44,-0.75,-4.66,-8.19,-9.0,-6.94,-4.97,-4.31,-2.81,-0.06,1.62,0.41,-0.69,0.59,2.19,1.94,1.22,2.25,4.0,3.59,2.31,2.12,3.78,4.0,1.72,-0.31,-0.84,-2.19,-5.88,-9.88,-11.91,-13.53,-17.56,-21.44,-22.78,-21.91,-21.88,-21.88,-20.22,-15.94,-12.78,-11.91,-10.53,-7.38,-4.44,-3.59,-2.84,-0.06,3.03,3.5,2.5,2.47,3.53,2.78,0.84,-0.12,1.0,1.69,0.41,-0.66,-0.25,-0.03,-2.81,-6.25,-7.22,-7.09,-8.25,-9.47,-9.31,-7.41,-7.38,-9.03,-10.47,-9.5,-9.03,-10.28,-11.53,-10.12,-8.16,-8.66,-9.44,-7.94,-5.38,-4.72,-4.75,-3.28,-0.38,0.78,-0.38,-1.19,-0.09,0.62,-1.41,-3.47,-3.5,-3.44,-5.56,-8.22,-8.44,-7.31,-7.53,-8.81,-8.81,-6.81,-6.03,-7.06,-7.09,-4.84,-3.22,-3.59,-4.47,-4.03,-3.16,-4.47,-5.91,-5.5,-3.34,-2.41,-3.03,-3.34,-1.81,-1.75,-3.88,-5.38,-4.44,-3.41,-4.66,-6.12,-5.09,-3.19,-3.31,-4.41,-4.16,-2.34,-2.41,-3.75,-3.91,-1.84,-0.97,-2.31,-3.62,-2.69,-1.5,-1.84,-3.03,-2.16,-0.56,-0.72,-2.69,-2.97,-1.91,-2.78,-5.44,-7.62,-7.31,-7.34,-8.28,-8.31,-5.34,-1.78,-0.53,-0.75,0.09,0.81,-0.69,-3.75,-5.38,-4.88,-5.0,-6.91,-7.97,-6.72,-6.0,-7.5,-9.19,-8.5,-7.53,-8.56,-10.0,-9.47,-7.44,-7.28,-8.47,-8.28,-6.25,-5.25,-6.44,-7.12,-5.28,-4.06,-4.94,-5.94,-4.97,-3.81,-4.91,-7.28,-8.41,-8.22,-9.38,-12.22,-13.78,-13.38,-14.03,-16.34,-17.97,-16.19,-14.03,-13.44,-13.75,-12.69,-11.09,-11.56,-12.81,-12.16,-8.91,-6.59,-5.78,-4.91,-2.72,-1.66,-3.59,-5.94,-5.81,-5.53,-6.91,-8.81,-8.5,-7.25,-7.5,-8.88,-9.03,-7.34,-6.84,-8.31,-8.91,-7.66,-7.0,-8.72,-10.12,-9.25,-8.12,-9.12,-11.22,-11.72,-11.78,-12.75,-15.19,-16.06,-14.84,-13.66,-14.0,-13.31,-10.12,-7.31,-7.16,-8.09,-7.56,-7.06,-8.59,-11.56,-12.38,-11.72,-11.91,-12.69,-11.59,-8.44,-6.38,-6.66,-7.5,-6.19,-5.28,-6.72,-8.38,-8.25,-7.56,-8.28,-10.19,-10.34,-8.94,-8.53,-9.66,-9.28,-6.72,-4.91,-4.72,-4.69,-2.53,-0.5,-0.97,-2.69,-2.78,-2.28,-3.91,-6.59,-8.25,-8.59,-9.75,-12.56,-14.0,-12.62,-11.41,-11.88,-12.12,-10.19,-8.25,-8.38,-9.53,-8.69,-7.03,-6.81,-8.0,-8.06,-7.03,-6.41,-7.47,-7.38,-4.56,-1.47,-0.34,0.59,3.47,6.81,7.88,7.06,7.44,7.78,6.06,1.88,-1.41,-3.25,-5.09,-8.34,-10.47,-9.5,-8.06,-7.94,-8.41,-6.41,-4.09,-3.62,-4.47,-4.28,-2.91,-2.81,-4.62,-5.09,-3.44,-2.19,-3.16,-4.53,-4.03,-4.0,-6.09,-8.81,-9.19,-8.09,-8.25,-9.19,-8.88,-7.56,-7.31,-9.94,-12.22,-13.09,-13.84,-16.09,-17.41,-16.0,-13.62,-13.12,-13.31,-11.59,-9.16,-7.72,-7.72,-6.62,-4.09,-2.84,-3.53,-4.03,-2.81,-1.88,-3.5,-5.53,-5.94,-6.34,-8.81,-11.97,-13.41,-13.56,-14.56,-16.66,-17.5,-16.25,-15.47,-17.0,-18.22,-17.38,-16.81,-18.03,-19.81,-19.59,-18.81,-20.12,-22.69,-23.91,-23.72,-24.25,-26.34,-26.88,-25.22,-23.59,-23.75,-23.12,-20.19,-16.53,-14.72,-13.5,-10.47,-6.56,-4.69,-4.53,-2.94,-0.78,0.0,-1.5,-3.22,-3.28,-4.38,-7.44,-9.84,-9.66,-8.59,-8.75,-9.62,-8.97,-7.62,-8.16,-9.94,-10.0,-8.47,-7.22,-7.94,-7.94,-6.38,-5.0,-6.22,-8.06,-8.06,-7.44,-8.94,-10.84,-10.78,-9.25,-8.75,-9.97,-9.91,-8.5,-7.88,-9.16,-10.88,-10.75,-10.5,-11.97,-13.41,-12.34,-9.94,-9.0,-8.62,-6.91,-4.28,-2.94,-3.84,-3.91,-2.31,-1.34,-3.19,-5.72,-6.72,-7.91,-10.66,-13.19,-13.31,-11.72,-11.34,-11.91,-11.06,-8.31,-6.56,-6.16,-5.34,-2.62,-0.19,-0.5,-1.72,-1.62,-1.84,-4.91,-9.09,-11.62,-12.41,-14.0,-15.97,-16.72,-15.94,-16.53,-19.78,-22.84,-24.12,-25.09,-27.91,-29.91,-29.03,-27.0,-26.03,-25.66,-23.84,-20.84,-19.09,-18.28,-15.88,-10.53,-4.78,-0.34,4.56,10.62,15.22,15.81,14.66,13.5,12.31,8.62,3.81,-0.41,-3.12,-6.91,-12.16,-16.19,-17.75,-18.81,-21.25,-22.28,-21.25,-19.97,-21.16,-23.59,-24.22,-23.41,-23.12,-22.75,-20.06,-15.09,-10.88,-9.06,-7.06,-4.03,-2.19,-3.66,-5.94,-6.81,-7.12,-9.31,-11.22,-11.19,-9.53,-9.38,-10.88,-11.66,-11.38,-12.44,-16.0,-19.91,-21.75,-23.16,-25.84,-28.06,-27.44,-26.09,-26.66,-27.78,-27.69,-25.62,-24.78,-24.88,-24.5,-22.06,-20.16,-20.16,-20.06,-18.03,-16.12,-16.22,-17.31,-17.06,-15.91,-16.88,-19.09,-20.31,-20.19,-20.94,-22.47,-22.5,-19.53,-16.31,-14.53,-13.34,-9.97,-7.25,-7.0,-8.25,-8.41,-8.09,-9.44,-12.28,-14.16,-14.0,-14.44,-16.12,-16.22,-13.38,-10.34,-9.06,-8.09,-5.41,-2.59,-2.47,-3.69,-4.25,-3.84,-5.53,-8.53,-10.31,-9.88,-9.91,-11.38,-11.97,-10.19,-8.44,-8.44,-8.84,-7.47,-4.97,-4.06,-4.19,-2.78,-0.31,0.31,-0.84,-1.78,-0.97,-0.72,-2.62,-3.94,-2.88,-1.66,-1.84,-2.41,-0.59,1.78,2.09,1.28,0.91,1.47,0.44,-2.31,-4.53,-4.31,-4.31,-5.81,-7.47,-6.62,-5.91,-6.81,-8.28,-7.97,-6.22,-6.03,-6.88,-6.56,-4.38,-2.88,-3.41,-3.84,-2.91,-3.09,-5.38,-8.22,-8.88,-8.47,-9.38,-11.12,-11.03,-9.91,-9.78,-11.31,-11.38,-9.84,-9.19,-10.44,-12.5,-12.88,-14.06,-17.03,-20.0,-19.44,-17.09,-15.28,-13.94,-10.91,-7.12,-4.84,-4.78,-4.56,-2.84,-2.19,-3.59,-5.06,-4.03,-2.28,-2.56,-2.81,-1.41,0.06,-0.62,-3.03,-4.91,-5.66,-6.94,-9.75,-11.44,-10.62,-9.81,-10.84,-11.72,-10.44,-8.19,-7.66,-8.06,-7.12,-5.78,-6.03,-7.94,-8.91,-8.12,-7.88,-9.09,-9.81,-8.72,-7.34,-7.5,-8.09,-6.0,-2.84,-1.59,-1.84,-0.88,0.97,1.34,0.03,-0.22,0.97,1.31,-0.5,-2.47,-2.62,-3.06,-5.06,-7.56,-7.69,-6.38,-6.72,-7.81,-7.44,-5.28,-3.81,-3.75,-2.62,0.25,2.53,2.12,1.91,3.53,5.72,6.0,5.34,6.47,7.56,6.56,2.94,0.66,-0.47,-2.16,-5.5,-7.66,-7.94,-8.31,-10.62,-12.78,-13.06,-12.5,-13.12,-14.72,-14.03,-11.16,-8.53,-7.16,-4.06,0.88,4.69,5.81,6.59,8.84,10.44,9.0,6.91,6.38,6.0,3.78,-0.03,-1.88,-2.62,-4.0,-7.0,-8.16,-7.12,-5.94,-6.75,-6.66,-4.06,-1.34,-0.47,-0.25,1.97,4.19,4.44,3.22,3.12,3.88,4.31,2.69,2.03,3.81,4.84,3.44,1.53,1.62,2.16,0.78,-1.62,-1.66,-0.44,-0.94,-3.16,-3.94,-3.5,-3.59,-5.38,-5.5,-2.84,0.03,1.06,2.12,4.81,30.16,30.22,29.5,28.88,27.5,25.06,22.41,20.47,19.62,18.12,16.56,15.81,15.97,16.44,16.06,16.69,18.62,20.88,22.38,23.09,25.03,26.31,26.47,25.75,25.59,26.03,25.78,25.0,24.25,24.5,24.44,22.72,20.78,19.53,18.16,16.28,14.28,14.38,15.56,16.38,16.81,17.81:positivity
21.44,21.84,22.97,22.16,21.38,22.19,24.34,25.03,24.25,24.34,26.28,27.28,26.78,26.78,29.12,31.22,30.88,29.84,30.81,31.72,30.41,28.03,26.81,26.41,24.59,21.25,19.22,19.78,20.53,20.78,21.94,26.22,29.91,30.91,29.97,30.03,29.94,27.22,24.41,23.66,25.12,25.44,25.31,25.47,27.03,27.56,25.66,24.0,24.47,25.5,25.25,24.66,26.09,28.0,27.69,26.25,26.41,28.19,29.84,30.41,31.5,34.28,36.03,34.84,33.12,33.56,34.09,32.62,30.09,29.31,29.0,26.66,23.28,21.47,21.72,21.41,20.09,20.0,22.41,24.53,24.78,24.31,25.53,26.44,25.25,22.94,22.34,23.16,22.41,21.03,21.19,23.28,24.72,24.97,25.59,27.5,28.88,27.69,25.59,25.19,25.47,23.75,21.56,21.59,22.91,23.25,22.62,23.19,25.78,27.34,27.41,27.62,29.72,31.5,31.03,29.94,30.94,32.22,31.69,30.12,30.56,32.03,32.44,31.31,30.59,31.31,31.03,28.53,26.41,26.59,27.06,25.94,24.84,26.22,27.44,26.75,24.44,22.72,22.25,20.91,17.78,15.81,16.62,16.84,16.0,15.44,17.91,21.03,21.97,22.66,25.22,27.75,28.34,27.25,27.31,28.03,27.66,25.28,23.62,24.38,24.5,22.62,20.28,19.56,19.19,16.91,13.94,13.53,14.44,14.09,12.53,12.59,14.62,15.66,14.78,14.66,16.66,18.47,18.91,19.28,21.5,24.12,23.97,21.78,20.56,20.03,18.31,15.91,15.06,16.56,17.66,16.81,16.5,18.53,20.62,20.56,20.22,21.84,23.31,22.47,19.75,18.62,18.31,16.66,13.97,13.12,14.59,15.5,14.78,13.94,15.44,16.69,16.16,15.66,17.44,19.81,20.0,18.06,17.12,16.78,14.69,11.12,9.22,9.97,11.03,10.44,10.53,13.0,15.88,16.66,17.16,19.41,21.84,21.62,19.44,18.66,19.62,19.59,18.19,18.47,20.47,22.25,21.66,21.06,22.28,23.06,21.81,19.25,18.78,19.34,18.44,16.28,15.84,16.88,16.53,14.34,13.09,13.47,14.0,13.0,11.91,13.31,15.62,16.09,16.0,17.91,20.41,20.69,18.91,17.91,18.59,18.66,17.06,16.84,18.81,20.81,20.28,19.5,20.53,21.59,20.16,17.84,17.19,17.69,17.16,15.44,15.03,16.84,17.47,15.44,14.0,14.5,15.25,14.0,12.94,14.5,16.59,16.94,15.69,16.28,18.38,19.0,17.88,18.22,20.34,21.31,20.22,19.25,19.84,19.53,16.66,13.09,11.75,11.5,10.44,8.91,9.16,11.09,11.91,11.03,11.78,14.84,18.06,19.0,20.12,23.19,25.75,26.0,26.0,27.66,29.97,29.84,27.22,25.28,23.88,20.75,15.28,10.94,9.31,7.91,5.12,3.25,4.47,5.97,5.53,4.44,5.25,6.84,6.72,5.34,6.19,9.03,11.34,12.09,13.69,16.66,18.88,18.5,18.12,20.0,21.91,21.53,20.31,20.47,21.62,21.41,20.38,21.03,23.59,24.94,24.19,23.25,23.72,23.62,20.19,16.56,15.41,15.62,14.34,13.25,14.31,16.25,16.44,14.72,14.38,15.88,16.88,15.75,15.25,16.69,17.44,15.19,12.25,10.81,10.09,7.53,4.97,5.12,7.56,9.5,9.78,11.34,14.19,15.75,14.31,13.19,14.03,14.81,12.84,10.59,10.34,10.97,9.94,8.59,9.25,11.69,13.06,12.91,13.88,16.72,19.12,19.31,19.34,21.75,23.78,23.25,22.0,22.34,23.31,22.66,20.53,19.75,20.38,19.78,17.25,15.41,15.72,15.69,13.0,10.69,10.56,11.25,9.84,8.69,9.78,12.44,12.94,12.03,11.69,13.06,13.06,11.88,11.81,14.53,17.19,17.28,16.94,18.16,19.25,17.09,13.47,11.38,10.34,7.94,5.53,4.75,6.5,7.78,6.91,6.78,8.47,9.84,8.47,6.62,6.53,7.0,5.31,3.41,3.41,5.0,4.84,3.62,3.41,5.25,6.62,6.0,6.03,8.06,10.22,9.72,8.94,9.5,10.34,8.75,6.31,5.47,6.56,6.56,5.66,5.59,7.91,9.06,7.97,7.06,8.09,9.41,8.16,6.59,7.5,9.47,9.69,8.75,9.06,10.31,9.97,7.28,6.09,6.81,6.88,4.97,3.38,3.84,4.78,3.5,1.91,2.44,3.81,3.28,1.75,2.09,4.44,5.94,6.09,7.34,11.41,15.06,16.72,17.69,20.16,21.38,18.84,14.97,12.38,11.0,7.97,3.75,1.53,1.59,0.66,-1.31,-1.94,-0.09,1.44,1.19,1.12,3.31,6.28,7.34,8.03,11.16,15.5,18.09,18.91,20.0,22.0,22.16,19.62,17.06,16.66,16.03,13.03,9.94,8.69,8.28,5.53,2.28,0.59,1.09,0.41,-0.88,-0.16,2.72,4.88,4.94,5.06,7.06,9.28,9.12,9.06,10.44,12.62,12.12,10.56,10.72,12.06,11.78,10.03,9.5,10.75,11.84,11.28,11.19,13.41,15.16,14.53,13.59,14.34,16.22,15.84,14.41,14.5,15.62,15.28,13.56,12.69,14.19,15.19,14.25,13.62,14.88,15.69,14.0,11.38,10.97,11.88,10.78,8.38,7.34,7.78,6.47,3.88,2.5,3.59,4.69,4.03,3.25,4.72,6.5,6.31,5.41,6.56,8.88,9.25,8.34,8.47,10.06,10.25,8.34,7.28,8.56,9.56,8.72,8.75,11.12,14.0,14.72,13.88,13.94,13.56,10.62,6.03,2.72,1.88,0.53,-1.84,-3.28,-2.44,-2.0,-3.47,-4.5,-2.94,-0.12,1.12,1.22,2.94,5.31,5.75,4.88,4.81,7.09,8.41,7.97,7.47,8.34,8.94,6.88,4.06,3.66,4.0,2.78,0.62,0.31,1.41,0.91,-0.84,-1.09,1.28,3.59,3.75,4.66,7.31,9.06,8.06,6.16,6.03,6.59,5.69,3.78,3.84,5.62,6.09,5.03,4.84,6.25,6.66,4.84,3.41,4.34,5.38,4.81,3.69,4.31,5.25,3.94,0.88,-0.59,0.03,-0.09,-1.5,-1.25,1.59,4.62,5.91,7.56,11.38,14.78,14.84,13.0,12.03,11.47,9.0,5.41,3.78,4.19,3.19,0.75,-1.16,-0.62,0.25,-0.44,-0.66,2.34,6.09,7.84,8.62,10.78,13.03,12.69,10.62,9.19,8.97,7.66,4.31,1.59,1.47,1.34,-0.72,-2.94,-2.72,-2.09,-2.72,-3.72,-1.97,1.75,4.69,6.12,7.91,9.84,9.59,6.44,3.28,2.78,3.0,2.44,2.31,4.81,7.88,8.59,7.19,7.16,7.94,7.25,5.62,5.56,7.31,8.5,7.12,5.56,5.91,5.88,3.72,1.16,1.06,2.03,1.84,0.91,1.78,3.5,3.75,1.44,0.12,1.22,2.84,3.62,5.16,9.5,13.44,14.19,13.25,13.34,13.44,11.22,7.97,6.81,7.75,8.5,8.16,8.84,11.66,13.22,11.97,10.34,11.16,12.06,10.69,8.56,8.12,7.81,6.16,3.47,3.0,4.94,6.28,5.88,5.72,6.78,7.19,5.19,3.44,4.81,6.75,6.66,5.25,4.84,4.69,2.56,-0.75,-2.09,-0.94,0.19,-0.34,-0.78,0.31,0.0,-3.25,-6.75,-7.94,-7.62,-8.66,-9.34,-7.78,-4.91,-3.22,-3.38,-3.09,-1.53,-0.41,-1.28,-1.56,1.16,3.16,2.94,1.81,2.25,3.0,1.44,-1.25,-1.94,-1.06,-1.16,-2.22,-2.06,0.81,3.09,3.16,3.31,5.5,7.62,7.47,6.62,7.91,9.69,9.28,7.25,6.69,6.81,5.44,2.31,0.0,-0.12,0.16,-1.31,-1.81,0.5,3.38,4.09,4.34,6.47,9.09,9.69,8.44,8.62,9.69,9.56,7.66,6.84,8.5,10.06,10.25,10.31,12.5,14.69,14.16,12.47,11.62,11.28,8.94,5.38,3.47,3.69,3.75,2.31,1.88,3.75,5.62,5.09,4.69,6.06,7.81,6.72,5.0,5.19,6.06,6.09,4.62,4.5,5.53,5.19,2.84,1.09,1.88,3.16,2.91,2.66,5.0,7.66,7.62,6.12,5.22,4.66,2.88,-0.22,-1.41,-0.22,0.97,0.19,-0.03,1.88,3.75,3.75,3.59,5.03,7.22,6.59,4.41,3.84,5.0,5.31,4.84,6.12,9.09,11.75,11.53,11.69,13.28,14.91,14.47,13.66,15.28,17.41,17.16,14.91,13.31,11.78,8.69,3.78,0.94,1.0,2.53,3.03,4.41,8.34,12.06,13.19,13.09,14.84,16.97,17.62,16.78,17.59,19.0,18.84,16.44,14.0,13.56,13.0,10.91,9.62,11.25,13.62,14.41,14.28,15.62,17.44,17.12,15.28,14.34,15.41,15.75,14.44,14.41,16.12,17.12,15.75,13.91,13.59,13.94,12.62,11.31,12.34,15.16,16.72,17.03,18.22,20.28,20.56,17.75,15.09,14.25,13.44,11.22,9.56,10.16,11.31,10.56,8.5,8.03,8.88,9.31,9.0,10.06,13.81,16.66,17.06,17.31,18.53,18.91,16.94,14.44,13.94,14.12,12.81,11.06,10.84,12.44,13.0,11.78,11.44,12.38,13.03,11.47,10.53,11.59,13.03,12.31,11.19,12.03,13.75,13.81,12.72,13.22,14.56,15.03,13.41,12.5,13.25,13.78,12.34,11.69,13.16,15.03,14.5,13.09,12.69,12.59,10.53,6.91,5.06,5.44,5.25,3.75,3.59,5.62,7.06,6.16,5.16,5.94,6.78,5.44,3.56,4.03,5.72,6.66,6.22,8.09,11.62,14.5,15.38,16.72,19.84,21.75,21.19,19.75,19.19,19.12,17.03,13.69,11.75,10.81,8.41,4.38,1.91:25.03,24.25,24.34,26.28,27.28,26.78,26.78,29.12,31.22,30.88,29.84,30.81,31.72,30.41,28.03,26.81,26.41,24.59,21.25,19.22,19.78,20.53,20.78,21.94,26.22,29.91,30.91,29.97,30.03,29.94,27.22,24.41,23.66,25.12,25.44,25.31,25.47,27.03,27.56,25.66,24.0,24.47,25.5,25.25,24.66,26.09,28.0,27.69,26.25,26.41,28.19,29.84,30.41,31.5,34.28,36.03,34.84,33.12,33.56,34.09,32.62,30.09,29.31,29.0,26.66,23.28,21.47,21.72,21.41,20.09,20.0,22.41,24.53,24.78,24.31,25.53,26.44,25.25,22.94,22.34,23.16,22.41,21.03,21.19,23.28,24.72,24.97,25.59,27.5,28.88,27.69,25.59,25.19,25.47,23.75,21.56,21.59,22.91,23.25,22.62,23.19,25.78,27.34,27.41,27.62,29.72,31.5,31.03,29.94,30.94,32.22,31.69,30.12,30.56,32.03,32.44,31.31,30.59,31.31,31.03,28.53,26.41,26.59,27.06,25.94,24.84,26.22,27.44,26.75,24.44,22.72,22.25,20.91,17.78,15.81,16.62,16.84,16.0,15.44,17.91,21.03,21.97,22.66,25.22,27.75,28.34,27.25,27.31,28.03,27.66,25.28,23.62,24.38,24.5,22.62,20.28,19.56,19.19,16.91,13.94,13.53,14.44,14.09,12.53,12.59,14.62,15.66,14.78,14.66,16.66,18.47,18.91,19.28,21.5,24.12,23.97,21.78,20.56,20.03,18.31,15.91,15.06,16.56,17.66,16.81,16.5,18.53,20.62,20.56,20.22,21.84,23.31,22.47,19.75,18.62,18.31,16.66,13.97,13.12,14.59,15.5,14.78,13.94,15.44,16.69,16.16,15.66,17.44,19.81,20.0,18.06,17.12,16.78,14.69,11.12,9.22,9.97,11.03,10.44,10.53,13.0,15.88,16.66,17.16,19.41,21.84,21.62,19.44,18.66,19.62,19.59,18.19,18.47,20.47,22.25,21.66,21.06,22.28,23.06,21.81,19.25,18.78,19.34,18.44,16.28,15.84,16.88,16.53,14.34,13.09,13.47,14.0,13.0,11.91,13.31,15.62,16.09,16.0,17.91,20.41,20.69,18.91,17.91,18.59,18.66,17.06,16.84,18.81,20.81,20.28,19.5,20.53,21.59,20.16,17.84,17.19,17.69,17.16,15.44,15.03,16.84,17.47,15.44,14.0,14.5,15.25,14.0,12.94,14.5,16.59,16.94,15.69,16.28,18.38,19.0,17.88,18.22,20.34,21.31,20.22,19.25,19.84,19.53,16.66,13.09,11.75,11.5,10.44,8.91,9.16,11.09,11.91,11.03,11.78,14.84,18.06,19.0,20.12,23.19,25.75,26.0,26.0,27.66,29.97,29.84,27.22,25.28,23.88,20.75,15.28,10.94,9.31,7.91,5.12,3.25,4.47,5.97,5.53,4.44,5.25,6.84,6.72,5.34,6.19,9.03,11.34,12.09,13.69,16.66,18.88,18.5,18.12,20.0,21.91,21.53,20.31,20.47,21.62,21.41,20.38,21.03,23.59,24.94,24.19,23.25,23.72,23.62,20.19,16.56,15.41,15.62,14.34,13.25,14.31,16.25,16.44,14.72,14.38,15.88,16.88,15.75,15.25,16.69,17.44,15.19,12.25,10.81,10.09,7.53,4.97,5.12,7.56,9.5,9.78,11.34,14.19,15.75,14.31,13.19,14.03,14.81,12.84,10.59,10.34,10.97,9.94,8.59,9.25,11.69,13.06,12.91,13.88,16.72,19.12,19.31,19.34,21.75,23.78,23.25,22.0,22.34,23.31,22.66,20.53,19.75,20.38,19.78,17.25,15.41,15.72,15.69,13.0,10.69,10.56,11.25,9.84,8.69,9.78,12.44,12.94,12.03,11.69,13.06,13.06,11.88,11.81,14.53,17.19,17.28,16.94,18.16,19.25,17.09,13.47,11.38,10.34,7.94,5.53,4.75,6.5,7.78,6.91,6.78,8.47,9.84,8.47,6.62,6.53,7.0,5.31,3.41,3.41,5.0,4.84,3.62,3.41,5.25,6.62,6.0,6.03,8.06,10.22,9.72,8.94,9.5,10.34,8.75,6.31,5.47,6.56,6.56,5.66,5.59,7.91,9.06,7.97,7.06,8.09,9.41,8.16,6.59,7.5,9.47,9.69,8.75,9.06,10.31,9.97,7.28,6.09,6.81,6.88,4.97,3.38,3.84,4.78,3.5,1.91,2.44,3.81,3.28,1.75,2.09,4.44,5.94,6.09,7.34,11.41,15.06,16.72,17.69,20.16,21.38,18.84,14.97,12.38,11.0,7.97,3.75,1.53,1.59,0.66,-1.31,-1.94,-0.09,1.44,1.19,1.12,3.31,6.28,7.34,8.03,11.16,15.5,18.09,18.91,20.0,22.0,22.16,19.62,17.06,16.66,16.03,13.03,9.94,8.69,8.28,5.53,2.28,0.59,1.09,0.41,-0.88,-0.16,2.72,4.88,4.94,5.06,7.06,9.28,9.12,9.06,10.44,12.62,12.12,10.56,10.72,12.06,11.78,10.03,9.5,10.75,11.84,11.28,11.19,13.41,15.16,14.53,13.59,14.34,16.22,15.84,14.41,14.5,15.62,15.28,13.56,12.69,14.19,15.19,14.25,13.62,14.88,15.69,14.0,11.38,10.97,11.88,10.78,8.38,7.34,7.78,6.47,3.88,2.5,3.59,4.69,4.03,3.25,4.72,6.5,6.31,5.41,6.56,8.88,9.25,8.34,8.47,10.06,10.25,8.34,7.28,8.56,9.56,8.72,8.75,11.12,14.0,14.72,13.88,13.94,13.56,10.62,6.03,2.72,1.88,0.53,-1.84,-3.28,-2.44,-2.0,-3.47,-4.5,-2.94,-0.12,1.12,1.22,2.94,5.31,5.75,4.88,4.81,7.09,8.41,7.97,7.47,8.34,8.94,6.88,4.06,3.66,4.0,2.78,0.62,0.31,1.41,0.91,-0.84,-1.09,1.28,3.59,3.75,4.66,7.31,9.06,8.06,6.16,6.03,6.59,5.69,3.78,3.84,5.62,6.09,5.03,4.84,6.25,6.66,4.84,3.41,4.34,5.38,4.81,3.69,4.31,5.25,3.94,0.88,-0.59,0.03,-0.09,-1.5,-1.25,1.59,4.62,5.91,7.56,11.38,14.78,14.84,13.0,12.03,11.47,9.0,5.41,3.78,4.19,3.19,0.75,-1.16,-0.62,0.25,-0.44,-0.66,2.34,6.09,7.84,8.62,10.78,13.03,12.69,10.62,9.19,8.97,7.66,4.31,1.59,1.47,1.34,-0.72,-2.94,-2.72,-2.09,-2.72,-3.72,-1.97,1.75,4.69,6.12,7.91,9.84,9.59,6.44,3.28,2.78,3.0,2.44,2.31,4.81,7.88,8.59,7.19,7.16,7.94,7.25,5.62,5.56,7.31,8.5,7.12,5.56,5.91,5.88,3.72,1.16,1.06,2.03,1.84,0.91,1.78,3.5,3.75,1.44,0.12,1.22,2.84,3.62,5.16,9.5,13.44,14.19,13.25,13.34,13.44,11.22,7.97,6.81,7.75,8.5,8.16,8.84,11.66,13.22,11.97,10.34,11.16,12.06,10.69,8.56,8.12,7.81,6.16,3.47,3.0,4.94,6.28,5.88,5.72,6.78,7.19,5.19,3.44,4.81,6.75,6.66,5.25,4.84,4.69,2.56,-0.75,-2.09,-0.94,0.19,-0.34,-0.78,0.31,0.0,-3.25,-6.75,-7.94,-7.62,-8.66,-9.34,-7.78,-4.91,-3.22,-3.38,-3.09,-1.53,-0.41,-1.28,-1.56,1.16,3.16,2.94,1.81,2.25,3.0,1.44,-1.25,-1.94,-1.06,-1.16,-2.22,-2.06,0.81,3.09,3.16,3.31,5.5,7.62,7.47,6.62,7.91,9.69,9.28,7.25,6.69,6.81,5.44,2.31,0.0,-0.12,0.16,-1.31,-1.81,0.5,3.38,4.09,4.34,6.47,9.09,9.69,8.44,8.62,9.69,9.56,7.66,6.84,8.5,10.06,10.25,10.31,12.5,14.69,14.16,12.47,11.62,11.28,8.94,5.38,3.47,3.69,3.75,2.31,1.88,3.75,5.62,5.09,4.69,6.06,7.81,6.72,5.0,5.19,6.06,6.09,4.62,4.5,5.53,5.19,2.84,1.09,1.88,3.16,2.91,2.66,5.0,7.66,7.62,6.12,5.22,4.66,2.88,-0.22,-1.41,-0.22,0.97,0.19,-0.03,1.88,3.75,3.75,3.59,5.03,7.22,6.59,4.41,3.84,5.0,5.31,4.84,6.12,9.09,11.75,11.53,11.69,13.28,14.91,14.47,13.66,15.28,17.41,17.16,14.91,13.31,11.78,8.69,3.78,0.94,1.0,2.53,3.03,4.41,8.34,12.06,13.19,13.09,14.84,16.97,17.62,16.78,17.59,19.0,18.84,16.44,14.0,13.56,13.0,10.91,9.62,11.25,13.62,14.41,14.28,15.62,17.44,17.12,15.28,14.34,15.41,15.75,14.44,14.41,16.12,17.12,15.75,13.91,13.59,13.94,12.62,11.31,12.34,15.16,16.72,17.03,18.22,20.28,20.56,17.75,15.09,14.25,13.44,11.22,9.56,10.16,11.31,10.56,8.5,8.03,8.88,9.31,9.0,10.06,13.81,16.66,17.06,17.31,18.53,18.91,16.94,14.44,13.94,14.12,12.81,11.06,10.84,12.44,13.0,11.78,11.44,12.38,13.03,11.47,10.53,11.59,13.03,12.31,11.19,12.03,13.75,13.81,12.72,13.22,14.56,15.03,13.41,12.5,13.25,13.78,12.34,11.69,13.16,15.03,14.5,13.09,12.69,12.59,10.53,6.91,5.06,5.44,5.25,3.75,3.59,5.62,7.06,6.16,5.16,5.94,6.78,5.44,3.56,4.03,5.72,6.66,6.22,8.09,11.62,14.5,15.38,16.72,19.84,21.75,21.19,19.75,19.19,19.12,17.03,13.69,11.75,10.81,8.41,4.38,1.91,25.91,26.34,26.62,26.22,26.19,27.44,29.12:29.12,31.22,30.88,29.84,30.81,31.72,30.41,28.03,26.81,26.41,24.59,21.25,19.22,19.78,20.53,20.78,21.94,26.22,29.91,30.91,29.97,30.03,29.94,27.22,24.41,23.66,25.12,25.44,25.31,25.47,27.03,27.56,25.66,24.0,24.47,25.5,25.25,24.66,26.09,28.0,27.69,26.25,26.41,28.19,29.84,30.41,31.5,34.28,36.03,34.84,33.12,33.56,34.09,32.62,30.09,29.31,29.0,26.66,23.28,21.47,21.72,21.41,20.09,20.0,22.41,24.53,24.78,24.31,25.53,26.44,25.25,22.94,22.34,23.16,22.41,21.03,21.19,23.28,24.72,24.97,25.59,27.5,28.88,27.69,25.59,25.19,25.47,23.75,21.56,21.59,22.91,23.25,22.62,23.19,25.78,27.34,27.41,27.62,29.72,31.5,31.03,29.94,30.94,32.22,31.69,30.12,30.56,32.03,32.44,31.31,30.59,31.31,31.03,28.53,26.41,26.59,27.06,25.94,24.84,26.22,27.44,26.75,24.44,22.72,22.25,20.91,17.78,15.81,16.62,16.84,16.0,15.44,17.91,21.03,21.97,22.66,25.22,27.75,28.34,27.25,27.31,28.03,27.66,25.28,23.62,24.38,24.5,22.62,20.28,19.56,19.19,16.91,13.94,13.53,14.44,14.09,12.53,12.59,14.62,15.66,14.78,14.66,16.66,18.47,18.91,19.28,21.5,24.12,23.97,21.78,20.56,20.03,18.31,15.91,15.06,16.56,17.66,16.81,16.5,18.53,20.62,20.56,20.22,21.84,23.31,22.47,19.75,18.62,18.31,16.66,13.97,13.12,14.59,15.5,14.78,13.94,15.44,16.69,16.16,15.66,17.44,19.81,20.0,18.06,17.12,16.78,14.69,11.12,9.22,9.97,11.03,10.44,10.53,13.0,15.88,16.66,17.16,19.41,21.84,21.62,19.44,18.66,19.62,19.59,18.19,18.47,20.47,22.25,21.66,21.06,22.28,23.06,21.81,19.25,18.78,19.34,18.44,16.28,15.84,16.88,16.53,14.34,13.09,13.47,14.0,13.0,11.91,13.31,15.62,16.09,16.0,17.91,20.41,20.69,18.91,17.91,18.59,18.66,17.06,16.84,18.81,20.81,20.28,19.5,20.53,21.59,20.16,17.84,17.19,17.69,17.16,15.44,15.03,16.84,17.47,15.44,14.0,14.5,15.25,14.0,12.94,14.5,16.59,16.94,15.69,16.28,18.38,19.0,17.88,18.22,20.34,21.31,20.22,19.25,19.84,19.53,16.66,13.09,11.75,11.5,10.44,8.91,9.16,11.09,11.91,11.03,11.78,14.84,18.06,19.0,20.12,23.19,25.75,26.0,26.0,27.66,29.97,29.84,27.22,25.28,23.88,20.75,15.28,10.94,9.31,7.91,5.12,3.25,4.47,5.97,5.53,4.44,5.25,6.84,6.72,5.34,6.19,9.03,11.34,12.09,13.69,16.66,18.88,18.5,18.12,20.0,21.91,21.53,20.31,20.47,21.62,21.41,20.38,21.03,23.59,24.94,24.19,23.25,23.72,23.62,20.19,16.56,15.41,15.62,14.34,13.25,14.31,16.25,16.44,14.72,14.38,15.88,16.88,15.75,15.25,16.69,17.44,15.19,12.25,10.81,10.09,7.53,4.97,5.12,7.56,9.5,9.78,11.34,14.19,15.75,14.31,13.19,14.03,14.81,12.84,10.59,10.34,10.97,9.94,8.59,9.25,11.69,13.06,12.91,13.88,16.72,19.12,19.31,19.34,21.75,23.78,23.25,22.0,22.34,23.31,22.66,20.53,19.75,20.38,19.78,17.25,15.41,15.72,15.69,13.0,10.69,10.56,11.25,9.84,8.69,9.78,12.44,12.94,12.03,11.69,13.06,13.06,11.88,11.81,14.53,17.19,17.28,16.94,18.16,19.25,17.09,13.47,11.38,10.34,7.94,5.53,4.75,6.5,7.78,6.91,6.78,8.47,9.84,8.47,6.62,6.53,7.0,5.31,3.41,3.41,5.0,4.84,3.62,3.41,5.25,6.62,6.0,6.03,8.06,10.22,9.72,8.94,9.5,10.34,8.75,6.31,5.47,6.56,6.56,5.66,5.59,7.91,9.06,7.97,7.06,8.09,9.41,8.16,6.59,7.5,9.47,9.69,8.75,9.06,10.31,9.97,7.28,6.09,6.81,6.88,4.97,3.38,3.84,4.78,3.5,1.91,2.44,3.81,3.28,1.75,2.09,4.44,5.94,6.09,7.34,11.41,15.06,16.72,17.69,20.16,21.38,18.84,14.97,12.38,11.0,7.97,3.75,1.53,1.59,0.66,-1.31,-1.94,-0.09,1.44,1.19,1.12,3.31,6.28,7.34,8.03,11.16,15.5,18.09,18.91,20.0,22.0,22.16,19.62,17.06,16.66,16.03,13.03,9.94,8.69,8.28,5.53,2.28,0.59,1.09,0.41,-0.88,-0.16,2.72,4.88,4.94,5.06,7.06,9.28,9.12,9.06,10.44,12.62,12.12,10.56,10.72,12.06,11.78,10.03,9.5,10.75,11.84,11.28,11.19,13.41,15.16,14.53,13.59,14.34,16.22,15.84,14.41,14.5,15.62,15.28,13.56,12.69,14.19,15.19,14.25,13.62,14.88,15.69,14.0,11.38,10.97,11.88,10.78,8.38,7.34,7.78,6.47,3.88,2.5,3.59,4.69,4.03,3.25,4.72,6.5,6.31,5.41,6.56,8.88,9.25,8.34,8.47,10.06,10.25,8.34,7.28,8.56,9.56,8.72,8.75,11.12,14.0,14.72,13.88,13.94,13.56,10.62,6.03,2.72,1.88,0.53,-1.84,-3.28,-2.44,-2.0,-3.47,-4.5,-2.94,-0.12,1.12,1.22,2.94,5.31,5.75,4.88,4.81,7.09,8.41,7.97,7.47,8.34,8.94,6.88,4.06,3.66,4.0,2.78,0.62,0.31,1.41,0.91,-0.84,-1.09,1.28,3.59,3.75,4.66,7.31,9.06,8.06,6.16,6.03,6.59,5.69,3.78,3.84,5.62,6.09,5.03,4.84,6.25,6.66,4.84,3.41,4.34,5.38,4.81,3.69,4.31,5.25,3.94,0.88,-0.59,0.03,-0.09,-1.5,-1.25,1.59,4.62,5.91,7.56,11.38,14.78,14.84,13.0,12.03,11.47,9.0,5.41,3.78,4.19,3.19,0.75,-1.16,-0.62,0.25,-0.44,-0.66,2.34,6.09,7.84,8.62,10.78,13.03,12.69,10.62,9.19,8.97,7.66,4.31,1.59,1.47,1.34,-0.72,-2.94,-2.72,-2.09,-2.72,-3.72,-1.97,1.75,4.69,6.12,7.91,9.84,9.59,6.44,3.28,2.78,3.0,2.44,2.31,4.81,7.88,8.59,7.19,7.16,7.94,7.25,5.62,5.56,7.31,8.5,7.12,5.56,5.91,5.88,3.72,1.16,1.06,2.03,1.84,0.91,1.78,3.5,3.75,1.44,0.12,1.22,2.84,3.62,5.16,9.5,13.44,14.19,13.25,13.34,13.44,11.22,7.97,6.81,7.75,8.5,8.16,8.84,11.66,13.22,11.97,10.34,11.16,12.06,10.69,8.56,8.12,7.81,6.16,3.47,3.0,4.94,6.28,5.88,5.72,6.78,7.19,5.19,3.44,4.81,6.75,6.66,5.25,4.84,4.69,2.56,-0.75,-2.09,-0.94,0.19,-0.34,-0.78,0.31,0.0,-3.25,-6.75,-7.94,-7.62,-8.66,-9.34,-7.78,-4.91,-3.22,-3.38,-3.09,-1.53,-0.41,-1.28,-1.56,1.16,3.16,2.94,1.81,2.25,3.0,1.44,-1.25,-1.94,-1.06,-1.16,-2.22,-2.06,0.81,3.09,3.16,3.31,5.5,7.62,7.47,6.62,7.91,9.69,9.28,7.25,6.69,6.81,5.44,2.31,0.0,-0.12,0.16,-1.31,-1.81,0.5,3.38,4.09,4.34,6.47,9.09,9.69,8.44,8.62,9.69,9.56,7.66,6.84,8.5,10.06,10.25,10.31,12.5,14.69,14.16,12.47,11.62,11.28,8.94,5.38,3.47,3.69,3.75,2.31,1.88,3.75,5.62,5.09,4.69,6.06,7.81,6.72,5.0,5.19,6.06,6.09,4.62,4.5,5.53,5.19,2.84,1.09,1.88,3.16,2.91,2.66,5.0,7.66,7.62,6.12,5.22,4.66,2.88,-0.22,-1.41,-0.22,0.97,0.19,-0.03,1.88,3.75,3.75,3.59,5.03,7.22,6.59,4.41,3.84,5.0,5.31,4.84,6.12,9.09,11.75,11.53,11.69,13.28,14.91,14.47,13.66,15.28,17.41,17.16,14.91,13.31,11.78,8.69,3.78,0.94,1.0,2.53,3.03,4.41,8.34,12.06,13.19,13.09,14.84,16.97,17.62,16.78,17.59,19.0,18.84,16.44,14.0,13.56,13.0,10.91,9.62,11.25,13.62,14.41,14.28,15.62,17.44,17.12,15.28,14.34,15.41,15.75,14.44,14.41,16.12,17.12,15.75,13.91,13.59,13.94,12.62,11.31,12.34,15.16,16.72,17.03,18.22,20.28,20.56,17.75,15.09,14.25,13.44,11.22,9.56,10.16,11.31,10.56,8.5,8.03,8.88,9.31,9.0,10.06,13.81,16.66,17.06,17.31,18.53,18.91,16.94,14.44,13.94,14.12,12.81,11.06,10.84,12.44,13.0,11.78,11.44,12.38,13.03,11.47,10.53,11.59,13.03,12.31,11.19,12.03,13.75,13.81,12.72,13.22,14.56,15.03,13.41,12.5,13.25,13.78,12.34,11.69,13.16,15.03,14.5,13.09,12.69,12.59,10.53,6.91,5.06,5.44,5.25,3.75,3.59,5.62,7.06,6.16,5.16,5.94,6.78,5.44,3.56,4.03,5.72,6.66,6.22,8.09,11.62,14.5,15.38,16.72,19.84,21.75,21.19,19.75,19.19,19.12,17.03,13.69,11.75,10.81,8.41,4.38,1.91,25.91,26.34,26.62,26.22,26.19,27.44,29.12,30.12,30.59,31.78,32.94,33.38,32.88,32.5:28.03,26.81,26.41,24.59,21.25,19.22,19.78,20.53,20.78,21.94,26.22,29.91,30.91,29.97,30.03,29.94,27.22,24.41,23.66,25.12,25.44,25.31,25.47,27.03,27.56,25.66,24.0,24.47,25.5,25.25,24.66,26.09,28.0,27.69,26.25,26.41,28.19,29.84,30.41,31.5,34.28,36.03,34.84,33.12,33.56,34.09,32.62,30.09,29.31,29.0,26.66,23.28,21.47,21.72,21.41,20.09,20.0,22.41,24.53,24.78,24.31,25.53,26.44,25.25,22.94,22.34,23.16,22.41,21.03,21.19,23.28,24.72,24.97,25.59,27.5,28.88,27.69,25.59,25.19,25.47,23.75,21.56,21.59,22.91,23.25,22.62,23.19,25.78,27.34,27.41,27.62,29.72,31.5,31.03,29.94,30.94,32.22,31.69,30.12,30.56,32.03,32.44,31.31,30.59,31.31,31.03,28.53,26.41,26.59,27.06,25.94,24.84,26.22,27.44,26.75,24.44,22.72,22.25,20.91,17.78,15.81,16.62,16.84,16.0,15.44,17.91,21.03,21.97,22.66,25.22,27.75,28.34,27.25,27.31,28.03,27.66,25.28,23.62,24.38,24.5,22.62,20.28,19.56,19.19,16.91,13.94,13.53,14.44,14.09,12.53,12.59,14.62,15.66,14.78,14.66,16.66,18.47,18.91,19.28,21.5,24.12,23.97,21.78,20.56,20.03,18.31,15.91,15.06,16.56,17.66,16.81,16.5,18.53,20.62,20.56,20.22,21.84,23.31,22.47,19.75,18.62,18.31,16.66,13.97,13.12,14.59,15.5,14.78,13.94,15.44,16.69,16.16,15.66,17.44,19.81,20.0,18.06,17.12,16.78,14.69,11.12,9.22,9.97,11.03,10.44,10.53,13.0,15.88,16.66,17.16,19.41,21.84,21.62,19.44,18.66,19.62,19.59,18.19,18.47,20.47,22.25,21.66,21.06,22.28,23.06,21.81,19.25,18.78,19.34,18.44,16.28,15.84,16.88,16.53,14.34,13.09,13.47,14.0,13.0,11.91,13.31,15.62,16.09,16.0,17.91,20.41,20.69,18.91,17.91,18.59,18.66,17.06,16.84,18.81,20.81,20.28,19.5,20.53,21.59,20.16,17.84,17.19,17.69,17.16,15.44,15.03,16.84,17.47,15.44,14.0,14.5,15.25,14.0,12.94,14.5,16.59,16.94,15.69,16.28,18.38,19.0,17.88,18.22,20.34,21.31,20.22,19.25,19.84,19.53,16.66,13.09,11.75,11.5,10.44,8.91,9.16,11.09,11.91,11.03,11.78,14.84,18.06,19.0,20.12,23.19,25.75,26.0,26.0,27.66,29.97,29.84,27.22,25.28,23.88,20.75,15.28,10.94,9.31,7.91,5.12,3.25,4.47,5.97,5.53,4.44,5.25,6.84,6.72,5.34,6.19,9.03,11.34,12.09,13.69,16.66,18.88,18.5,18.12,20.0,21.91,21.53,20.31,20.47,21.62,21.41,20.38,21.03,23.59,24.94,24.19,23.25,23.72,23.62,20.19,16.56,15.41,15.62,14.34,13.25,14.31,16.25,16.44,14.72,14.38,15.88,16.88,15.75,15.25,16.69,17.44,15.19,12.25,10.81,10.09,7.53,4.97,5.12,7.56,9.5,9.78,11.34,14.19,15.75,14.31,13.19,14.03,14.81,12.84,10.59,10.34,10.97,9.94,8.59,9.25,11.69,13.06,12.91,13.88,16.72,19.12,19.31,19.34,21.75,23.78,23.25,22.0,22.34,23.31,22.66,20.53,19.75,20.38,19.78,17.25,15.41,15.72,15.69,13.0,10.69,10.56,11.25,9.84,8.69,9.78,12.44,12.94,12.03,11.69,13.06,13.06,11.88,11.81,14.53,17.19,17.28,16.94,18.16,19.25,17.09,13.47,11.38,10.34,7.94,5.53,4.75,6.5,7.78,6.91,6.78,8.47,9.84,8.47,6.62,6.53,7.0,5.31,3.41,3.41,5.0,4.84,3.62,3.41,5.25,6.62,6.0,6.03,8.06,10.22,9.72,8.94,9.5,10.34,8.75,6.31,5.47,6.56,6.56,5.66,5.59,7.91,9.06,7.97,7.06,8.09,9.41,8.16,6.59,7.5,9.47,9.69,8.75,9.06,10.31,9.97,7.28,6.09,6.81,6.88,4.97,3.38,3.84,4.78,3.5,1.91,2.44,3.81,3.28,1.75,2.09,4.44,5.94,6.09,7.34,11.41,15.06,16.72,17.69,20.16,21.38,18.84,14.97,12.38,11.0,7.97,3.75,1.53,1.59,0.66,-1.31,-1.94,-0.09,1.44,1.19,1.12,3.31,6.28,7.34,8.03,11.16,15.5,18.09,18.91,20.0,22.0,22.16,19.62,17.06,16.66,16.03,13.03,9.94,8.69,8.28,5.53,2.28,0.59,1.09,0.41,-0.88,-0.16,2.72,4.88,4.94,5.06,7.06,9.28,9.12,9.06,10.44,12.62,12.12,10.56,10.72,12.06,11.78,10.03,9.5,10.75,11.84,11.28,11.19,13.41,15.16,14.53,13.59,14.34,16.22,15.84,14.41,14.5,15.62,15.28,13.56,12.69,14.19,15.19,14.25,13.62,14.88,15.69,14.0,11.38,10.97,11.88,10.78,8.38,7.34,7.78,6.47,3.88,2.5,3.59,4.69,4.03,3.25,4.72,6.5,6.31,5.41,6.56,8.88,9.25,8.34,8.47,10.06,10.25,8.34,7.28,8.56,9.56,8.72,8.75,11.12,14.0,14.72,13.88,13.94,13.56,10.62,6.03,2.72,1.88,0.53,-1.84,-3.28,-2.44,-2.0,-3.47,-4.5,-2.94,-0.12,1.12,1.22,2.94,5.31,5.75,4.88,4.81,7.09,8.41,7.97,7.47,8.34,8.94,6.88,4.06,3.66,4.0,2.78,0.62,0.31,1.41,0.91,-0.84,-1.09,1.28,3.59,3.75,4.66,7.31,9.06,8.06,6.16,6.03,6.59,5.69,3.78,3.84,5.62,6.09,5.03,4.84,6.25,6.66,4.84,3.41,4.34,5.38,4.81,3.69,4.31,5.25,3.94,0.88,-0.59,0.03,-0.09,-1.5,-1.25,1.59,4.62,5.91,7.56,11.38,14.78,14.84,13.0,12.03,11.47,9.0,5.41,3.78,4.19,3.19,0.75,-1.16,-0.62,0.25,-0.44,-0.66,2.34,6.09,7.84,8.62,10.78,13.03,12.69,10.62,9.19,8.97,7.66,4.31,1.59,1.47,1.34,-0.72,-2.94,-2.72,-2.09,-2.72,-3.72,-1.97,1.75,4.69,6.12,7.91,9.84,9.59,6.44,3.28,2.78,3.0,2.44,2.31,4.81,7.88,8.59,7.19,7.16,7.94,7.25,5.62,5.56,7.31,8.5,7.12,5.56,5.91,5.88,3.72,1.16,1.06,2.03,1.84,0.91,1.78,3.5,3.75,1.44,0.12,1.22,2.84,3.62,5.16,9.5,13.44,14.19,13.25,13.34,13.44,11.22,7.97,6.81,7.75,8.5,8.16,8.84,11.66,13.22,11.97,10.34,11.16,12.06,10.69,8.56,8.12,7.81,6.16,3.47,3.0,4.94,6.28,5.88,5.72,6.78,7.19,5.19,3.44,4.81,6.75,6.66,5.25,4.84,4.69,2.56,-0.75,-2.09,-0.94,0.19,-0.34,-0.78,0.31,0.0,-3.25,-6.75,-7.94,-7.62,-8.66,-9.34,-7.78,-4.91,-3.22,-3.38,-3.09,-1.53,-0.41,-1.28,-1.56,1.16,3.16,2.94,1.81,2.25,3.0,1.44,-1.25,-1.94,-1.06,-1.16,-2.22,-2.06,0.81,3.09,3.16,3.31,5.5,7.62,7.47,6.62,7.91,9.69,9.28,7.25,6.69,6.81,5.44,2.31,0.0,-0.12,0.16,-1.31,-1.81,0.5,3.38,4.09,4.34,6.47,9.09,9.69,8.44,8.62,9.69,9.56,7.66,6.84,8.5,10.06,10.25,10.31,12.5,14.69,14.16,12.47,11.62,11.28,8.94,5.38,3.47,3.69,3.75,2.31,1.88,3.75,5.62,5.09,4.69,6.06,7.81,6.72,5.0,5.19,6.06,6.09,4.62,4.5,5.53,5.19,2.84,1.09,1.88,3.16,2.91,2.66,5.0,7.66,7.62,6.12,5.22,4.66,2.88,-0.22,-1.41,-0.22,0.97,0.19,-0.03,1.88,3.75,3.75,3.59,5.03,7.22,6.59,4.41,3.84,5.0,5.31,4.84,6.12,9.09,11.75,11.53,11.69,13.28,14.91,14.47,13.66,15.28,17.41,17.16,14.91,13.31,11.78,8.69,3.78,0.94,1.0,2.53,3.03,4.41,8.34,12.06,13.19,13.09,14.84,16.97,17.62,16.78,17.59,19.0,18.84,16.44,14.0,13.56,13.0,10.91,9.62,11.25,13.62,14.41,14.28,15.62,17.44,17.12,15.28,14.34,15.41,15.75,14.44,14.41,16.12,17.12,15.75,13.91,13.59,13.94,12.62,11.31,12.34,15.16,16.72,17.03,18.22,20.28,20.56,17.75,15.09,14.25,13.44,11.22,9.56,10.16,11.31,10.56,8.5,8.03,8.88,9.31,9.0,10.06,13.81,16.66,17.06,17.31,18.53,18.91,16.94,14.44,13.94,14.12,12.81,11.06,10.84,12.44,13.0,11.78,11.44,12.38,13.03,11.47,10.53,11.59,13.03,12.31,11.19,12.03,13.75,13.81,12.72,13.22,14.56,15.03,13.41,12.5,13.25,13.78,12.34,11.69,13.16,15.03,14.5,13.09,12.69,12.59,10.53,6.91,5.06,5.44,5.25,3.75,3.59,5.62,7.06,6.16,5.16,5.94,6.78,5.44,3.56,4.03,5.72,6.66,6.22,8.09,11.62,14.5,15.38,16.72,19.84,21.75,21.19,19.75,19.19,19.12,17.03,13.69,11.75,10.81,8.41,4.38,1.91,25.91,26.34,26.62,26.22,26.19,27.44,29.12,30.12,30.59,31.78,32.94,33.38,32.88,32.5,33.44,34.09,33.25,32.56,33.0,32.81,31.47:20.53,20.78,21.94,26.22,29.91,30.91,29.97,30.03,29.94,27.22,24.41,23.66,25.12,25.44,25.31,25.47,27.03,27.56,25.66,24.0,24.47,25.5,25.25,24.66,26.09,28.0,27.69,26.25,26.41,28.19,29.84,30.41,31.5,34.28,36.03,34.84,33.12,33.56,34.09,32.62,30.09,29.31,29.0,26.66,23.28,21.47,21.72,21.41,20.09,20.0,22.41,24.53,24.78,24.31,25.53,26.44,25.25,22.94,22.34,23.16,22.41,21.03,21.19,23.28,24.72,24.97,25.59,27.5,28.88,27.69,25.59,25.19,25.47,23.75,21.56,21.59,22.91,23.25,22.62,23.19,25.78,27.34,27.41,27.62,29.72,31.5,31.03,29.94,30.94,32.22,31.69,30.12,30.56,32.03,32.44,31.31,30.59,31.31,31.03,28.53,26.41,26.59,27.06,25.94,24.84,26.22,27.44,26.75,24.44,22.72,22.25,20.91,17.78,15.81,16.62,16.84,16.0,15.44,17.91,21.03,21.97,22.66,25.22,27.75,28.34,27.25,27.31,28.03,27.66,25.28,23.62,24.38,24.5,22.62,20.28,19.56,19.19,16.91,13.94,13.53,14.44,14.09,12.53,12.59,14.62,15.66,14.78,14.66,16.66,18.47,18.91,19.28,21.5,24.12,23.97,21.78,20.56,20.03,18.31,15.91,15.06,16.56,17.66,16.81,16.5,18.53,20.62,20.56,20.22,21.84,23.31,22.47,19.75,18.62,18.31,16.66,13.97,13.12,14.59,15.5,14.78,13.94,15.44,16.69,16.16,15.66,17.44,19.81,20.0,18.06,17.12,16.78,14.69,11.12,9.22,9.97,11.03,10.44,10.53,13.0,15.88,16.66,17.16,19.41,21.84,21.62,19.44,18.66,19.62,19.59,18.19,18.47,20.47,22.25,21.66,21.06,22.28,23.06,21.81,19.25,18.78,19.34,18.44,16.28,15.84,16.88,16.53,14.34,13.09,13.47,14.0,13.0,11.91,13.31,15.62,16.09,16.0,17.91,20.41,20.69,18.91,17.91,18.59,18.66,17.06,16.84,18.81,20.81,20.28,19.5,20.53,21.59,20.16,17.84,17.19,17.69,17.16,15.44,15.03,16.84,17.47,15.44,14.0,14.5,15.25,14.0,12.94,14.5,16.59,16.94,15.69,16.28,18.38,19.0,17.88,18.22,20.34,21.31,20.22,19.25,19.84,19.53,16.66,13.09,11.75,11.5,10.44,8.91,9.16,11.09,11.91,11.03,11.78,14.84,18.06,19.0,20.12,23.19,25.75,26.0,26.0,27.66,29.97,29.84,27.22,25.28,23.88,20.75,15.28,10.94,9.31,7.91,5.12,3.25,4.47,5.97,5.53,4.44,5.25,6.84,6.72,5.34,6.19,9.03,11.34,12.09,13.69,16.66,18.88,18.5,18.12,20.0,21.91,21.53,20.31,20.47,21.62,21.41,20.38,21.03,23.59,24.94,24.19,23.25,23.72,23.62,20.19,16.56,15.41,15.62,14.34,13.25,14.31,16.25,16.44,14.72,14.38,15.88,16.88,15.75,15.25,16.69,17.44,15.19,12.25,10.81,10.09,7.53,4.97,5.12,7.56,9.5,9.78,11.34,14.19,15.75,14.31,13.19,14.03,14.81,12.84,10.59,10.34,10.97,9.94,8.59,9.25,11.69,13.06,12.91,13.88,16.72,19.12,19.31,19.34,21.75,23.78,23.25,22.0,22.34,23.31,22.66,20.53,19.75,20.38,19.78,17.25,15.41,15.72,15.69,13.0,10.69,10.56,11.25,9.84,8.69,9.78,12.44,12.94,12.03,11.69,13.06,13.06,11.88,11.81,14.53,17.19,17.28,16.94,18.16,19.25,17.09,13.47,11.38,10.34,7.94,5.53,4.75,6.5,7.78,6.91,6.78,8.47,9.84,8.47,6.62,6.53,7.0,5.31,3.41,3.41,5.0,4.84,3.62,3.41,5.25,6.62,6.0,6.03,8.06,10.22,9.72,8.94,9.5,10.34,8.75,6.31,5.47,6.56,6.56,5.66,5.59,7.91,9.06,7.97,7.06,8.09,9.41,8.16,6.59,7.5,9.47,9.69,8.75,9.06,10.31,9.97,7.28,6.09,6.81,6.88,4.97,3.38,3.84,4.78,3.5,1.91,2.44,3.81,3.28,1.75,2.09,4.44,5.94,6.09,7.34,11.41,15.06,16.72,17.69,20.16,21.38,18.84,14.97,12.38,11.0,7.97,3.75,1.53,1.59,0.66,-1.31,-1.94,-0.09,1.44,1.19,1.12,3.31,6.28,7.34,8.03,11.16,15.5,18.09,18.91,20.0,22.0,22.16,19.62,17.06,16.66,16.03,13.03,9.94,8.69,8.28,5.53,2.28,0.59,1.09,0.41,-0.88,-0.16,2.72,4.88,4.94,5.06,7.06,9.28,9.12,9.06,10.44,12.62,12.12,10.56,10.72,12.06,11.78,10.03,9.5,10.75,11.84,11.28,11.19,13.41,15.16,14.53,13.59,14.34,16.22,15.84,14.41,14.5,15.62,15.28,13.56,12.69,14.19,15.19,14.25,13.62,14.88,15.69,14.0,11.38,10.97,11.88,10.78,8.38,7.34,7.78,6.47,3.88,2.5,3.59,4.69,4.03,3.25,4.72,6.5,6.31,5.41,6.56,8.88,9.25,8.34,8.47,10.06,10.25,8.34,7.28,8.56,9.56,8.72,8.75,11.12,14.0,14.72,13.88,13.94,13.56,10.62,6.03,2.72,1.88,0.53,-1.84,-3.28,-2.44,-2.0,-3.47,-4.5,-2.94,-0.12,1.12,1.22,2.94,5.31,5.75,4.88,4.81,7.09,8.41,7.97,7.47,8.34,8.94,6.88,4.06,3.66,4.0,2.78,0.62,0.31,1.41,0.91,-0.84,-1.09,1.28,3.59,3.75,4.66,7.31,9.06,8.06,6.16,6.03,6.59,5.69,3.78,3.84,5.62,6.09,5.03,4.84,6.25,6.66,4.84,3.41,4.34,5.38,4.81,3.69,4.31,5.25,3.94,0.88,-0.59,0.03,-0.09,-1.5,-1.25,1.59,4.62,5.91,7.56,11.38,14.78,14.84,13.0,12.03,11.47,9.0,5.41,3.78,4.19,3.19,0.75,-1.16,-0.62,0.25,-0.44,-0.66,2.34,6.09,7.84,8.62,10.78,13.03,12.69,10.62,9.19,8.97,7.66,4.31,1.59,1.47,1.34,-0.72,-2.94,-2.72,-2.09,-2.72,-3.72,-1.97,1.75,4.69,6.12,7.91,9.84,9.59,6.44,3.28,2.78,3.0,2.44,2.31,4.81,7.88,8.59,7.19,7.16,7.94,7.25,5.62,5.56,7.31,8.5,7.12,5.56,5.91,5.88,3.72,1.16,1.06,2.03,1.84,0.91,1.78,3.5,3.75,1.44,0.12,1.22,2.84,3.62,5.16,9.5,13.44,14.19,13.25,13.34,13.44,11.22,7.97,6.81,7.75,8.5,8.16,8.84,11.66,13.22,11.97,10.34,11.16,12.06,10.69,8.56,8.12,7.81,6.16,3.47,3.0,4.94,6.28,5.88,5.72,6.78,7.19,5.19,3.44,4.81,6.75,6.66,5.25,4.84,4.69,2.56,-0.75,-2.09,-0.94,0.19,-0.34,-0.78,0.31,0.0,-3.25,-6.75,-7.94,-7.62,-8.66,-9.34,-7.78,-4.91,-3.22,-3.38,-3.09,-1.53,-0.41,-1.28,-1.56,1.16,3.16,2.94,1.81,2.25,3.0,1.44,-1.25,-1.94,-1.06,-1.16,-2.22,-2.06,0.81,3.09,3.16,3.31,5.5,7.62,7.47,6.62,7.91,9.69,9.28,7.25,6.69,6.81,5.44,2.31,0.0,-0.12,0.16,-1.31,-1.81,0.5,3.38,4.09,4.34,6.47,9.09,9.69,8.44,8.62,9.69,9.56,7.66,6.84,8.5,10.06,10.25,10.31,12.5,14.69,14.16,12.47,11.62,11.28,8.94,5.38,3.47,3.69,3.75,2.31,1.88,3.75,5.62,5.09,4.69,6.06,7.81,6.72,5.0,5.19,6.06,6.09,4.62,4.5,5.53,5.19,2.84,1.09,1.88,3.16,2.91,2.66,5.0,7.66,7.62,6.12,5.22,4.66,2.88,-0.22,-1.41,-0.22,0.97,0.19,-0.03,1.88,3.75,3.75,3.59,5.03,7.22,6.59,4.41,3.84,5.0,5.31,4.84,6.12,9.09,11.75,11.53,11.69,13.28,14.91,14.47,13.66,15.28,17.41,17.16,14.91,13.31,11.78,8.69,3.78,0.94,1.0,2.53,3.03,4.41,8.34,12.06,13.19,13.09,14.84,16.97,17.62,16.78,17.59,19.0,18.84,16.44,14.0,13.56,13.0,10.91,9.62,11.25,13.62,14.41,14.28,15.62,17.44,17.12,15.28,14.34,15.41,15.75,14.44,14.41,16.12,17.12,15.75,13.91,13.59,13.94,12.62,11.31,12.34,15.16,16.72,17.03,18.22,20.28,20.56,17.75,15.09,14.25,13.44,11.22,9.56,10.16,11.31,10.56,8.5,8.03,8.88,9.31,9.0,10.06,13.81,16.66,17.06,17.31,18.53,18.91,16.94,14.44,13.94,14.12,12.81,11.06,10.84,12.44,13.0,11.78,11.44,12.38,13.03,11.47,10.53,11.59,13.03,12.31,11.19,12.03,13.75,13.81,12.72,13.22,14.56,15.03,13.41,12.5,13.25,13.78,12.34,11.69,13.16,15.03,14.5,13.09,12.69,12.59,10.53,6.91,5.06,5.44,5.25,3.75,3.59,5.62,7.06,6.16,5.16,5.94,6.78,5.44,3.56,4.03,5.72,6.66,6.22,8.09,11.62,14.5,15.38,16.72,19.84,21.75,21.19,19.75,19.19,19.12,17.03,13.69,11.75,10.81,8.41,4.38,1.91,25.91,26.34,26.62,26.22,26.19,27.44,29.12,30.12,30.59,31.78,32.94,33.38,32.88,32.5,33.44,34.09,33.25,32.56,33.0,32.81,31.47,30.41,29.75,29.41,28.56,26.91,26.59,27.5:30.03,29.94,27.22,24.41,23.66,25.12,25.44,25.31,25.47,27.03,27.56,25.66,24.0,24.47,25.5,25.25,24.66,26.09,28.0,27.69,26.25,26.41,28.19,29.84,30.41,31.5,34.28,36.03,34.84,33.12,33.56,34.09,32.62,30.09,29.31,29.0,26.66,23.28,21.47,21.72,21.41,20.09,20.0,22.41,24.53,24.78,24.31,25.53,26.44,25.25,22.94,22.34,23.16,22.41,21.03,21.19,23.28,24.72,24.97,25.59,27.5,28.88,27.69,25.59,25.19,25.47,23.75,21.56,21.59,22.91,23.25,22.62,23.19,25.78,27.34,27.41,27.62,29.72,31.5,31.03,29.94,30.94,32.22,31.69,30.12,30.56,32.03,32.44,31.31,30.59,31.31,31.03,28.53,26.41,26.59,27.06,25.94,24.84,26.22,27.44,26.75,24.44,22.72,22.25,20.91,17.78,15.81,16.62,16.84,16.0,15.44,17.91,21.03,21.97,22.66,25.22,27.75,28.34,27.25,27.31,28.03,27.66,25.28,23.62,24.38,24.5,22.62,20.28,19.56,19.19,16.91,13.94,13.53,14.44,14.09,12.53,12.59,14.62,15.66,14.78,14.66,16.66,18.47,18.91,19.28,21.5,24.12,23.97,21.78,20.56,20.03,18.31,15.91,15.06,16.56,17.66,16.81,16.5,18.53,20.62,20.56,20.22,21.84,23.31,22.47,19.75,18.62,18.31,16.66,13.97,13.12,14.59,15.5,14.78,13.94,15.44,16.69,16.16,15.66,17.44,19.81,20.0,18.06,17.12,16.78,14.69,11.12,9.22,9.97,11.03,10.44,10.53,13.0,15.88,16.66,17.16,19.41,21.84,21.62,19.44,18.66,19.62,19.59,18.19,18.47,20.47,22.25,21.66,21.06,22.28,23.06,21.81,19.25,18.78,19.34,18.44,16.28,15.84,16.88,16.53,14.34,13.09,13.47,14.0,13.0,11.91,13.31,15.62,16.09,16.0,17.91,20.41,20.69,18.91,17.91,18.59,18.66,17.06,16.84,18.81,20.81,20.28,19.5,20.53,21.59,20.16,17.84,17.19,17.69,17.16,15.44,15.03,16.84,17.47,15.44,14.0,14.5,15.25,14.0,12.94,14.5,16.59,16.94,15.69,16.28,18.38,19.0,17.88,18.22,20.34,21.31,20.22,19.25,19.84,19.53,16.66,13.09,11.75,11.5,10.44,8.91,9.16,11.09,11.91,11.03,11.78,14.84,18.06,19.0,20.12,23.19,25.75,26.0,26.0,27.66,29.97,29.84,27.22,25.28,23.88,20.75,15.28,10.94,9.31,7.91,5.12,3.25,4.47,5.97,5.53,4.44,5.25,6.84,6.72,5.34,6.19,9.03,11.34,12.09,13.69,16.66,18.88,18.5,18.12,20.0,21.91,21.53,20.31,20.47,21.62,21.41,20.38,21.03,23.59,24.94,24.19,23.25,23.72,23.62,20.19,16.56,15.41,15.62,14.34,13.25,14.31,16.25,16.44,14.72,14.38,15.88,16.88,15.75,15.25,16.69,17.44,15.19,12.25,10.81,10.09,7.53,4.97,5.12,7.56,9.5,9.78,11.34,14.19,15.75,14.31,13.19,14.03,14.81,12.84,10.59,10.34,10.97,9.94,8.59,9.25,11.69,13.06,12.91,13.88,16.72,19.12,19.31,19.34,21.75,23.78,23.25,22.0,22.34,23.31,22.66,20.53,19.75,20.38,19.78,17.25,15.41,15.72,15.69,13.0,10.69,10.56,11.25,9.84,8.69,9.78,12.44,12.94,12.03,11.69,13.06,13.06,11.88,11.81,14.53,17.19,17.28,16.94,18.16,19.25,17.09,13.47,11.38,10.34,7.94,5.53,4.75,6.5,7.78,6.91,6.78,8.47,9.84,8.47,6.62,6.53,7.0,5.31,3.41,3.41,5.0,4.84,3.62,3.41,5.25,6.62,6.0,6.03,8.06,10.22,9.72,8.94,9.5,10.34,8.75,6.31,5.47,6.56,6.56,5.66,5.59,7.91,9.06,7.97,7.06,8.09,9.41,8.16,6.59,7.5,9.47,9.69,8.75,9.06,10.31,9.97,7.28,6.09,6.81,6.88,4.97,3.38,3.84,4.78,3.5,1.91,2.44,3.81,3.28,1.75,2.09,4.44,5.94,6.09,7.34,11.41,15.06,16.72,17.69,20.16,21.38,18.84,14.97,12.38,11.0,7.97,3.75,1.53,1.59,0.66,-1.31,-1.94,-0.09,1.44,1.19,1.12,3.31,6.28,7.34,8.03,11.16,15.5,18.09,18.91,20.0,22.0,22.16,19.62,17.06,16.66,16.03,13.03,9.94,8.69,8.28,5.53,2.28,0.59,1.09,0.41,-0.88,-0.16,2.72,4.88,4.94,5.06,7.06,9.28,9.12,9.06,10.44,12.62,12.12,10.56,10.72,12.06,11.78,10.03,9.5,10.75,11.84,11.28,11.19,13.41,15.16,14.53,13.59,14.34,16.22,15.84,14.41,14.5,15.62,15.28,13.56,12.69,14.19,15.19,14.25,13.62,14.88,15.69,14.0,11.38,10.97,11.88,10.78,8.38,7.34,7.78,6.47,3.88,2.5,3.59,4.69,4.03,3.25,4.72,6.5,6.31,5.41,6.56,8.88,9.25,8.34,8.47,10.06,10.25,8.34,7.28,8.56,9.56,8.72,8.75,11.12,14.0,14.72,13.88,13.94,13.56,10.62,6.03,2.72,1.88,0.53,-1.84,-3.28,-2.44,-2.0,-3.47,-4.5,-2.94,-0.12,1.12,1.22,2.94,5.31,5.75,4.88,4.81,7.09,8.41,7.97,7.47,8.34,8.94,6.88,4.06,3.66,4.0,2.78,0.62,0.31,1.41,0.91,-0.84,-1.09,1.28,3.59,3.75,4.66,7.31,9.06,8.06,6.16,6.03,6.59,5.69,3.78,3.84,5.62,6.09,5.03,4.84,6.25,6.66,4.84,3.41,4.34,5.38,4.81,3.69,4.31,5.25,3.94,0.88,-0.59,0.03,-0.09,-1.5,-1.25,1.59,4.62,5.91,7.56,11.38,14.78,14.84,13.0,12.03,11.47,9.0,5.41,3.78,4.19,3.19,0.75,-1.16,-0.62,0.25,-0.44,-0.66,2.34,6.09,7.84,8.62,10.78,13.03,12.69,10.62,9.19,8.97,7.66,4.31,1.59,1.47,1.34,-0.72,-2.94,-2.72,-2.09,-2.72,-3.72,-1.97,1.75,4.69,6.12,7.91,9.84,9.59,6.44,3.28,2.78,3.0,2.44,2.31,4.81,7.88,8.59,7.19,7.16,7.94,7.25,5.62,5.56,7.31,8.5,7.12,5.56,5.91,5.88,3.72,1.16,1.06,2.03,1.84,0.91,1.78,3.5,3.75,1.44,0.12,1.22,2.84,3.62,5.16,9.5,13.44,14.19,13.25,13.34,13.44,11.22,7.97,6.81,7.75,8.5,8.16,8.84,11.66,13.22,11.97,10.34,11.16,12.06,10.69,8.56,8.12,7.81,6.16,3.47,3.0,4.94,6.28,5.88,5.72,6.78,7.19,5.19,3.44,4.81,6.75,6.66,5.25,4.84,4.69,2.56,-0.75,-2.09,-0.94,0.19,-0.34,-0.78,0.31,0.0,-3.25,-6.75,-7.94,-7.62,-8.66,-9.34,-7.78,-4.91,-3.22,-3.38,-3.09,-1.53,-0.41,-1.28,-1.56,1.16,3.16,2.94,1.81,2.25,3.0,1.44,-1.25,-1.94,-1.06,-1.16,-2.22,-2.06,0.81,3.09,3.16,3.31,5.5,7.62,7.47,6.62,7.91,9.69,9.28,7.25,6.69,6.81,5.44,2.31,0.0,-0.12,0.16,-1.31,-1.81,0.5,3.38,4.09,4.34,6.47,9.09,9.69,8.44,8.62,9.69,9.56,7.66,6.84,8.5,10.06,10.25,10.31,12.5,14.69,14.16,12.47,11.62,11.28,8.94,5.38,3.47,3.69,3.75,2.31,1.88,3.75,5.62,5.09,4.69,6.06,7.81,6.72,5.0,5.19,6.06,6.09,4.62,4.5,5.53,5.19,2.84,1.09,1.88,3.16,2.91,2.66,5.0,7.66,7.62,6.12,5.22,4.66,2.88,-0.22,-1.41,-0.22,0.97,0.19,-0.03,1.88,3.75,3.75,3.59,5.03,7.22,6.59,4.41,3.84,5.0,5.31,4.84,6.12,9.09,11.75,11.53,11.69,13.28,14.91,14.47,13.66,15.28,17.41,17.16,14.91,13.31,11.78,8.69,3.78,0.94,1.0,2.53,3.03,4.41,8.34,12.06,13.19,13.09,14.84,16.97,17.62,16.78,17.59,19.0,18.84,16.44,14.0,13.56,13.0,10.91,9.62,11.25,13.62,14.41,14.28,15.62,17.44,17.12,15.28,14.34,15.41,15.75,14.44,14.41,16.12,17.12,15.75,13.91,13.59,13.94,12.62,11.31,12.34,15.16,16.72,17.03,18.22,20.28,20.56,17.75,15.09,14.25,13.44,11.22,9.56,10.16,11.31,10.56,8.5,8.03,8.88,9.31,9.0,10.06,13.81,16.66,17.06,17.31,18.53,18.91,16.94,14.44,13.94,14.12,12.81,11.06,10.84,12.44,13.0,11.78,11.44,12.38,13.03,11.47,10.53,11.59,13.03,12.31,11.19,12.03,13.75,13.81,12.72,13.22,14.56,15.03,13.41,12.5,13.25,13.78,12.34,11.69,13.16,15.03,14.5,13.09,12.69,12.59,10.53,6.91,5.06,5.44,5.25,3.75,3.59,5.62,7.06,6.16,5.16,5.94,6.78,5.44,3.56,4.03,5.72,6.66,6.22,8.09,11.62,14.5,15.38,16.72,19.84,21.75,21.19,19.75,19.19,19.12,17.03,13.69,11.75,10.81,8.41,4.38,1.91,25.91,26.34,26.62,26.22,26.19,27.44,29.12,30.12,30.59,31.78,32.94,33.38,32.88,32.5,33.44,34.09,33.25,32.56,33.0,32.81,31.47,30.41,29.75,29.41,28.56,26.91,26.59,27.5,28.47,30.03,32.06,35.53,38.09,38.38,37.59:25.31,25.47,27.03,27.56,25.66,24.0,24.47,25.5,25.25,24.66,26.09,28.0,27.69,26.25,26.41,28.19,29.84,30.41,31.5,34.28,36.03,34.84,33.12,33.56,34.09,32.62,30.09,29.31,29.0,26.66,23.28,21.47,21.72,21.41,20.09,20.0,22.41,24.53,24.78,24.31,25.53,26.44,25.25,22.94,22.34,23.16,22.41,21.03,21.19,23.28,24.72,24.97,25.59,27.5,28.88,27.69,25.59,25.19,25.47,23.75,21.56,21.59,22.91,23.25,22.62,23.19,25.78,27.34,27.41,27.62,29.72,31.5,31.03,29.94,30.94,32.22,31.69,30.12,30.56,32.03,32.44,31.31,30.59,31.31,31.03,28.53,26.41,26.59,27.06,25.94,24.84,26.22,27.44,26.75,24.44,22.72,22.25,20.91,17.78,15.81,16.62,16.84,16.0,15.44,17.91,21.03,21.97,22.66,25.22,27.75,28.34,27.25,27.31,28.03,27.66,25.28,23.62,24.38,24.5,22.62,20.28,19.56,19.19,16.91,13.94,13.53,14.44,14.09,12.53,12.59,14.62,15.66,14.78,14.66,16.66,18.47,18.91,19.28,21.5,24.12,23.97,21.78,20.56,20.03,18.31,15.91,15.06,16.56,17.66,16.81,16.5,18.53,20.62,20.56,20.22,21.84,23.31,22.47,19.75,18.62,18.31,16.66,13.97,13.12,14.59,15.5,14.78,13.94,15.44,16.69,16.16,15.66,17.44,19.81,20.0,18.06,17.12,16.78,14.69,11.12,9.22,9.97,11.03,10.44,10.53,13.0,15.88,16.66,17.16,19.41,21.84,21.62,19.44,18.66,19.62,19.59,18.19,18.47,20.47,22.25,21.66,21.06,22.28,23.06,21.81,19.25,18.78,19.34,18.44,16.28,15.84,16.88,16.53,14.34,13.09,13.47,14.0,13.0,11.91,13.31,15.62,16.09,16.0,17.91,20.41,20.69,18.91,17.91,18.59,18.66,17.06,16.84,18.81,20.81,20.28,19.5,20.53,21.59,20.16,17.84,17.19,17.69,17.16,15.44,15.03,16.84,17.47,15.44,14.0,14.5,15.25,14.0,12.94,14.5,16.59,16.94,15.69,16.28,18.38,19.0,17.88,18.22,20.34,21.31,20.22,19.25,19.84,19.53,16.66,13.09,11.75,11.5,10.44,8.91,9.16,11.09,11.91,11.03,11.78,14.84,18.06,19.0,20.12,23.19,25.75,26.0,26.0,27.66,29.97,29.84,27.22,25.28,23.88,20.75,15.28,10.94,9.31,7.91,5.12,3.25,4.47,5.97,5.53,4.44,5.25,6.84,6.72,5.34,6.19,9.03,11.34,12.09,13.69,16.66,18.88,18.5,18.12,20.0,21.91,21.53,20.31,20.47,21.62,21.41,20.38,21.03,23.59,24.94,24.19,23.25,23.72,23.62,20.19,16.56,15.41,15.62,14.34,13.25,14.31,16.25,16.44,14.72,14.38,15.88,16.88,15.75,15.25,16.69,17.44,15.19,12.25,10.81,10.09,7.53,4.97,5.12,7.56,9.5,9.78,11.34,14.19,15.75,14.31,13.19,14.03,14.81,12.84,10.59,10.34,10.97,9.94,8.59,9.25,11.69,13.06,12.91,13.88,16.72,19.12,19.31,19.34,21.75,23.78,23.25,22.0,22.34,23.31,22.66,20.53,19.75,20.38,19.78,17.25,15.41,15.72,15.69,13.0,10.69,10.56,11.25,9.84,8.69,9.78,12.44,12.94,12.03,11.69,13.06,13.06,11.88,11.81,14.53,17.19,17.28,16.94,18.16,19.25,17.09,13.47,11.38,10.34,7.94,5.53,4.75,6.5,7.78,6.91,6.78,8.47,9.84,8.47,6.62,6.53,7.0,5.31,3.41,3.41,5.0,4.84,3.62,3.41,5.25,6.62,6.0,6.03,8.06,10.22,9.72,8.94,9.5,10.34,8.75,6.31,5.47,6.56,6.56,5.66,5.59,7.91,9.06,7.97,7.06,8.09,9.41,8.16,6.59,7.5,9.47,9.69,8.75,9.06,10.31,9.97,7.28,6.09,6.81,6.88,4.97,3.38,3.84,4.78,3.5,1.91,2.44,3.81,3.28,1.75,2.09,4.44,5.94,6.09,7.34,11.41,15.06,16.72,17.69,20.16,21.38,18.84,14.97,12.38,11.0,7.97,3.75,1.53,1.59,0.66,-1.31,-1.94,-0.09,1.44,1.19,1.12,3.31,6.28,7.34,8.03,11.16,15.5,18.09,18.91,20.0,22.0,22.16,19.62,17.06,16.66,16.03,13.03,9.94,8.69,8.28,5.53,2.28,0.59,1.09,0.41,-0.88,-0.16,2.72,4.88,4.94,5.06,7.06,9.28,9.12,9.06,10.44,12.62,12.12,10.56,10.72,12.06,11.78,10.03,9.5,10.75,11.84,11.28,11.19,13.41,15.16,14.53,13.59,14.34,16.22,15.84,14.41,14.5,15.62,15.28,13.56,12.69,14.19,15.19,14.25,13.62,14.88,15.69,14.0,11.38,10.97,11.88,10.78,8.38,7.34,7.78,6.47,3.88,2.5,3.59,4.69,4.03,3.25,4.72,6.5,6.31,5.41,6.56,8.88,9.25,8.34,8.47,10.06,10.25,8.34,7.28,8.56,9.56,8.72,8.75,11.12,14.0,14.72,13.88,13.94,13.56,10.62,6.03,2.72,1.88,0.53,-1.84,-3.28,-2.44,-2.0,-3.47,-4.5,-2.94,-0.12,1.12,1.22,2.94,5.31,5.75,4.88,4.81,7.09,8.41,7.97,7.47,8.34,8.94,6.88,4.06,3.66,4.0,2.78,0.62,0.31,1.41,0.91,-0.84,-1.09,1.28,3.59,3.75,4.66,7.31,9.06,8.06,6.16,6.03,6.59,5.69,3.78,3.84,5.62,6.09,5.03,4.84,6.25,6.66,4.84,3.41,4.34,5.38,4.81,3.69,4.31,5.25,3.94,0.88,-0.59,0.03,-0.09,-1.5,-1.25,1.59,4.62,5.91,7.56,11.38,14.78,14.84,13.0,12.03,11.47,9.0,5.41,3.78,4.19,3.19,0.75,-1.16,-0.62,0.25,-0.44,-0.66,2.34,6.09,7.84,8.62,10.78,13.03,12.69,10.62,9.19,8.97,7.66,4.31,1.59,1.47,1.34,-0.72,-2.94,-2.72,-2.09,-2.72,-3.72,-1.97,1.75,4.69,6.12,7.91,9.84,9.59,6.44,3.28,2.78,3.0,2.44,2.31,4.81,7.88,8.59,7.19,7.16,7.94,7.25,5.62,5.56,7.31,8.5,7.12,5.56,5.91,5.88,3.72,1.16,1.06,2.03,1.84,0.91,1.78,3.5,3.75,1.44,0.12,1.22,2.84,3.62,5.16,9.5,13.44,14.19,13.25,13.34,13.44,11.22,7.97,6.81,7.75,8.5,8.16,8.84,11.66,13.22,11.97,10.34,11.16,12.06,10.69,8.56,8.12,7.81,6.16,3.47,3.0,4.94,6.28,5.88,5.72,6.78,7.19,5.19,3.44,4.81,6.75,6.66,5.25,4.84,4.69,2.56,-0.75,-2.09,-0.94,0.19,-0.34,-0.78,0.31,0.0,-3.25,-6.75,-7.94,-7.62,-8.66,-9.34,-7.78,-4.91,-3.22,-3.38,-3.09,-1.53,-0.41,-1.28,-1.56,1.16,3.16,2.94,1.81,2.25,3.0,1.44,-1.25,-1.94,-1.06,-1.16,-2.22,-2.06,0.81,3.09,3.16,3.31,5.5,7.62,7.47,6.62,7.91,9.69,9.28,7.25,6.69,6.81,5.44,2.31,0.0,-0.12,0.16,-1.31,-1.81,0.5,3.38,4.09,4.34,6.47,9.09,9.69,8.44,8.62,9.69,9.56,7.66,6.84,8.5,10.06,10.25,10.31,12.5,14.69,14.16,12.47,11.62,11.28,8.94,5.38,3.47,3.69,3.75,2.31,1.88,3.75,5.62,5.09,4.69,6.06,7.81,6.72,5.0,5.19,6.06,6.09,4.62,4.5,5.53,5.19,2.84,1.09,1.88,3.16,2.91,2.66,5.0,7.66,7.62,6.12,5.22,4.66,2.88,-0.22,-1.41,-0.22,0.97,0.19,-0.03,1.88,3.75,3.75,3.59,5.03,7.22,6.59,4.41,3.84,5.0,5.31,4.84,6.12,9.09,11.75,11.53,11.69,13.28,14.91,14.47,13.66,15.28,17.41,17.16,14.91,13.31,11.78,8.69,3.78,0.94,1.0,2.53,3.03,4.41,8.34,12.06,13.19,13.09,14.84,16.97,17.62,16.78,17.59,19.0,18.84,16.44,14.0,13.56,13.0,10.91,9.62,11.25,13.62,14.41,14.28,15.62,17.44,17.12,15.28,14.34,15.41,15.75,14.44,14.41,16.12,17.12,15.75,13.91,13.59,13.94,12.62,11.31,12.34,15.16,16.72,17.03,18.22,20.28,20.56,17.75,15.09,14.25,13.44,11.22,9.56,10.16,11.31,10.56,8.5,8.03,8.88,9.31,9.0,10.06,13.81,16.66,17.06,17.31,18.53,18.91,16.94,14.44,13.94,14.12,12.81,11.06,10.84,12.44,13.0,11.78,11.44,12.38,13.03,11.47,10.53,11.59,13.03,12.31,11.19,12.03,13.75,13.81,12.72,13.22,14.56,15.03,13.41,12.5,13.25,13.78,12.34,11.69,13.16,15.03,14.5,13.09,12.69,12.59,10.53,6.91,5.06,5.44,5.25,3.75,3.59,5.62,7.06,6.16,5.16,5.94,6.78,5.44,3.56,4.03,5.72,6.66,6.22,8.09,11.62,14.5,15.38,16.72,19.84,21.75,21.19,19.75,19.19,19.12,17.03,13.69,11.75,10.81,8.41,4.38,1.91,25.91,26.34,26.62,26.22,26.19,27.44,29.12,30.12,30.59,31.78,32.94,33.38,32.88,32.5,33.44,34.09,33.25,32.56,33.0,32.81,31.47,30.41,29.75,29.41,28.56,26.91,26.59,27.5,28.47,30.03,32.06,35.53,38.09,38.38,37.59,37.03,35.66,33.47,31.84,31.94,33.28,34.34:positivity
21.62,20.62,18.62,18.28,19.59,20.22,18.41,17.06,17.78,18.19,16.28,14.69,15.59,17.06,16.41,15.06,15.78,17.25,17.22,16.25,16.81,19.44,22.0,22.31,23.44,26.69,29.06,28.34,27.0,27.69,28.34,26.91,24.38,23.97,24.94,24.41,22.75,22.38,24.09,25.31,24.47,24.78,27.34,30.19,30.53,30.5,32.38,33.94,32.97,29.88,27.94,26.75,24.34,20.72,18.72,19.78,21.22,21.38,22.91,27.09,31.47,33.09,33.41,34.91,36.38,35.72,33.28,32.81,33.25,32.5,29.94,28.5,28.88,28.44,25.38,21.97,20.88,20.5,18.16,15.94,16.34,17.78,17.5,16.5,16.94,19.22,20.56,19.53,19.34,20.88,22.16,21.12,20.03,21.66,23.44,22.91,21.31,21.25,21.5,19.88,17.0,15.59,16.38,16.91,15.31,14.53,16.0,16.78,15.19,13.19,13.56,14.47,14.38,13.78,14.97,17.44,17.84,16.88,17.09,18.94,20.28,19.97,19.25,20.53,21.53,20.16,17.97,17.47,17.81,16.09,13.81,13.81,15.69,16.78,16.44,17.25,19.81,22.44,22.69,23.34,25.84,28.44,28.0,26.72,26.44,26.88,24.78,20.94,18.25,16.62,14.28,10.59,8.81,10.19,11.56,11.28,10.75,12.25,13.91,13.62,13.16,15.25,18.91,21.41,22.56,24.81,28.0,29.59,28.47,27.69,28.38,28.62,26.31,24.22,24.41,25.53,24.5,23.34,24.16,25.72,25.06,22.0,19.22,17.25,13.94,8.78,4.97,3.97,4.47,3.66,3.75,6.41,10.03,11.31,11.34,13.03,15.59,16.44,15.5,15.91,18.12,19.34,18.78,19.19,21.41,23.47,23.06,22.06,22.59,24.09,23.69,22.59,23.31,25.97,27.28,27.44,28.34,31.19,32.41,30.88,28.53,27.16,26.28,23.0,20.25,20.16,21.91,21.59,20.44,20.34,21.25,20.91,19.06,18.47,20.03,21.56,20.84,20.44,21.5,22.28,20.66,18.0,16.78,16.59,15.12,11.94,9.94,10.03,8.94,6.38,4.72,6.06,6.81,5.56,4.62,5.84,8.34,9.31,10.12,12.78,16.59,17.56,16.28,15.12,15.28,14.78,12.38,10.94,12.41,14.12,13.59,13.44,15.31,18.19,18.59,18.31,18.97,20.94,21.22,19.59,19.06,20.12,20.19,17.78,15.59,15.22,14.75,11.75,9.34,8.81,10.06,10.25,9.81,10.66,13.06,14.44,14.22,15.06,18.0,20.16,19.5,18.34,18.94,19.59,18.22,16.25,16.19,17.16,16.31,14.38,13.59,14.97,15.12,13.75,12.94,14.34,15.53,15.09,14.81,17.53,20.91,22.12,22.12,22.78,24.03,22.78,20.0,18.81,19.59,19.91,17.84,16.47,16.97,16.88,14.34,11.91,12.25,13.75,13.59,13.41,15.09,18.25,19.62,19.22,19.47,21.56,22.94,22.66,23.38,26.56,28.84,29.06,28.09,29.03,30.47,30.12,28.19,27.47,27.84,26.66,24.03,22.88,24.31,24.84,23.28,21.94,22.25,22.5,20.44,17.53,16.81,16.94,15.59,13.84,13.5,15.31,16.09,15.84,16.25,19.34,22.31,22.12,21.88,22.91,23.97,22.78,20.72,21.09,22.12,21.12,18.44,16.5,16.12,15.09,13.09,11.66,13.16,14.25,12.91,11.31,12.12,13.94,14.03,13.5,14.97,17.44,18.19,17.59,18.34,20.88,22.28,21.88,21.78,23.69,25.0,23.91,22.16,22.34,22.91,21.38,19.28,19.09,20.69,21.31,20.44,20.53,22.31,22.88,21.19,19.69,20.75,21.75,20.5,18.59,18.59,19.09,17.88,15.53,15.56,17.0,17.34,16.0,15.28,16.88,17.44,15.97,15.06,16.88,18.91,18.78,18.16,19.19,20.59,19.81,17.41,16.06,16.19,15.44,13.44,12.81,14.84,16.25,15.72,14.97,16.72,18.47,18.56,17.94,19.03,20.97,21.06,19.25,18.19,18.53,17.62,14.5,12.44,12.56,12.84,11.28,9.69,10.88,12.66,12.72,11.84,12.47,14.34,15.06,14.44,15.16,17.75,18.78,17.25,15.53,16.09,15.84,13.72,10.78,10.5,10.41,9.06,6.81,7.06,8.88,9.5,8.34,8.03,9.78,10.75,9.44,9.12,11.12,12.62,12.19,10.56,10.69,10.88,9.56,7.03,6.5,7.88,8.22,7.06,7.41,9.91,11.97,11.69,11.06,12.16,13.25,11.91,9.97,10.34,11.81,11.88,10.38,10.53,11.94,12.47,10.78,9.56,10.56,11.16,9.84,8.53,10.06,11.66,11.31,9.53,9.69,10.59,9.88,7.78,7.12,8.5,8.84,7.47,6.78,8.62,10.22,9.12,7.94,8.72,9.91,9.19,7.16,7.5,9.31,10.0,9.62,11.0,14.09,16.28,16.22,16.16,18.56,20.56,20.03,18.41,18.31,17.72,14.94,10.75,8.66,8.0,6.69,4.12,3.28,4.84,6.16,5.16,4.81,6.41,7.75,7.06,5.59,6.53,7.81,7.53,5.88,6.41,8.03,8.19,6.53,5.31,6.09,6.78,5.44,4.66,6.28,8.53,8.56,7.97,9.09,11.19,11.28,10.19,11.16,14.44,17.28,17.91,19.38,21.84,22.97,20.5,17.28,15.97,15.75,14.03,11.88,11.94,13.0,12.5,9.62,8.38,8.19,7.44,3.53,0.5,-0.41,-0.56,-2.91,-4.66,-3.47,-1.38,-1.56,-2.66,-1.97,-0.19,0.41,-0.47,0.75,4.81,8.09,9.38,10.28,12.38,13.22,10.25,5.88,3.16,1.88,-0.75,-3.31,-2.94,-0.41,0.72,-0.5,-0.47,1.28,2.91,1.94,1.59,3.5,5.44,4.78,3.44,4.03,5.72,5.81,4.84,5.94,8.69,10.44,10.16,10.62,13.19,15.53,15.16,14.34,15.22,16.25,14.97,13.31,14.78,17.81,19.5,19.78,21.22,23.97,25.38,23.94,22.91,23.62,23.5,20.25,17.16,15.91,15.38,11.91,7.53,4.94,3.75,1.44,-1.22,-1.34,1.28,4.06,5.19,7.53,11.69,15.88,16.19,15.66,16.31,16.78,14.59,11.28,10.09,10.16,9.38,6.91,5.47,5.91,5.19,2.0,-0.44,-0.19,0.69,0.19,-0.31,1.97,5.62,7.31,7.44,8.56,10.66,10.16,7.19,5.0,4.94,4.75,2.59,1.47,3.12,5.25,4.22,2.44,2.0,1.69,-0.84,-4.41,-5.62,-4.31,-3.47,-4.28,-3.59,-0.47,2.66,3.31,4.53,8.0,11.72,12.38,12.0,13.44,15.19,14.84,12.84,11.56,11.69,10.19,6.47,4.0,4.53,5.56,5.62,5.78,7.91,9.94,8.53,5.59,3.94,4.0,2.66,0.75,0.72,3.22,5.03,4.81,5.22,7.81,9.88,9.09,8.0,8.78,10.75,10.53,10.12,11.78,15.34,17.25,17.62,18.66,21.38,22.75,21.16,19.06,19.28,19.25,16.38,13.84,13.69,14.12,12.75,9.88,9.16,10.09,10.28,9.16,9.69,12.38,15.16,15.34,15.84,18.25,20.59,19.31,16.56,15.75,15.94,14.25,11.84,11.25,12.62,13.09,11.69,10.69,11.59,12.06,10.0,7.91,8.56,9.97,9.34,8.47,9.91,12.59,12.72,11.03,10.19,11.06,11.12,9.59,9.19,11.75,13.84,13.19,12.34,13.56,15.19,14.56,13.38,13.94,15.25,15.06,12.91,11.81,12.78,12.72,10.62,9.12,10.09,11.0,9.69,7.59,7.5,8.06,6.62,3.62,2.97,4.31,4.69,3.56,3.84,6.94,9.34,9.78,10.94,13.97,16.66,16.41,14.81,14.97,15.88,14.5,12.0,11.34,12.0,11.19,8.94,7.41,8.59,9.59,8.5,7.75,9.5,11.56,10.91,9.47,9.75,11.12,10.28,7.47,6.0,5.97,4.38,0.78,-1.28,0.03,1.19,0.53,0.16,1.91,4.09,4.41,3.91,5.41,7.97,8.19,6.28,5.5,6.5,6.25,4.0,2.53,4.22,5.75,5.38,4.66,6.0,7.5,6.03,3.53,3.09,4.91,5.22,4.38,4.91,7.44,8.41,7.12,6.12,6.97,7.5,5.91,4.25,4.97,6.75,6.75,5.69,6.34,8.53,9.53,9.03,9.72,12.81,14.38,13.38,11.88,12.0,11.81,9.19,6.34,6.06,6.72,5.91,4.28,4.38,6.84,7.97,7.69,8.53,11.34,12.88,11.78,10.22,10.88,11.75,10.53,8.31,8.22,8.94,7.97,6.0,5.84,8.06,9.03,7.62,6.34,6.94,6.91,5.0,2.88,4.53,6.88,7.5,6.94,8.53,11.25,12.12,11.31,12.06,14.44,15.53,14.16,13.28,14.16,14.66,12.78,10.25,9.94,9.88,7.91,4.31,2.69,2.78,2.19,1.16,1.97,5.94,8.91,9.59,10.0,12.31,13.59,11.94,9.03,7.62,6.78,4.59,2.06,2.41,5.0,6.72,6.12,6.16,8.06,8.81,7.78,7.09,8.81,10.31,9.22,7.25,7.12,7.97,7.53,6.12,6.41,8.28,8.38,6.12,4.03,3.62,2.84,0.16,-1.81,-0.75,1.06,1.56,1.47,3.19,5.66,6.28,5.09,4.97,6.53,6.75,5.0,3.81,4.78,4.78,2.41,-0.16,-0.44,0.09,-0.25,-0.75,1.25,5.22,7.69,8.31,9.69,12.38,13.47,12.16,11.28,12.81,13.94,12.81,10.72,10.47,10.69,9.06,6.25,5.75,6.72,6.91,5.69,5.88,8.0,9.16,7.78,6.81,8.03,9.47,9.09,8.12,8.72,9.53,7.91,4.75,3.19,3.81,4.0,3.06,3.47,6.28,7.59,5.62,3.19,2.53,2.16,0.78,-0.44,0.75,3.38,4.66,4.75,5.97,9.06:17.06,17.78,18.19,16.28,14.69,15.59,17.06,16.41,15.06,15.78,17.25,17.22,16.25,16.81,19.44,22.0,22.31,23.44,26.69,29.06,28.34,27.0,27.69,28.34,26.91,24.38,23.97,24.94,24.41,22.75,22.38,24.09,25.31,24.47,24.78,27.34,30.19,30.53,30.5,32.38,33.94,32.97,29.88,27.94,26.75,24.34,20.72,18.72,19.78,21.22,21.38,22.91,27.09,31.47,33.09,33.41,34.91,36.38,35.72,33.28,32.81,33.25,32.5,29.94,28.5,28.88,28.44,25.38,21.97,20.88,20.5,18.16,15.94,16.34,17.78,17.5,16.5,16.94,19.22,20.56,19.53,19.34,20.88,22.16,21.12,20.03,21.66,23.44,22.91,21.31,21.25,21.5,19.88,17.0,15.59,16.38,16.91,15.31,14.53,16.0,16.78,15.19,13.19,13.56,14.47,14.38,13.78,14.97,17.44,17.84,16.88,17.09,18.94,20.28,19.97,19.25,20.53,21.53,20.16,17.97,17.47,17.81,16.09,13.81,13.81,15.69,16.78,16.44,17.25,19.81,22.44,22.69,23.34,25.84,28.44,28.0,26.72,26.44,26.88,24.78,20.94,18.25,16.62,14.28,10.59,8.81,10.19,11.56,11.28,10.75,12.25,13.91,13.62,13.16,15.25,18.91,21.41,22.56,24.81,28.0,29.59,28.47,27.69,28.38,28.62,26.31,24.22,24.41,25.53,24.5,23.34,24.16,25.72,25.06,22.0,19.22,17.25,13.94,8.78,4.97,3.97,4.47,3.66,3.75,6.41,10.03,11.31,11.34,13.03,15.59,16.44,15.5,15.91,18.12,19.34,18.78,19.19,21.41,23.47,23.06,22.06,22.59,24.09,23.69,22.59,23.31,25.97,27.28,27.44,28.34,31.19,32.41,30.88,28.53,27.16,26.28,23.0,20.25,20.16,21.91,21.59,20.44,20.34,21.25,20.91,19.06,18.47,20.03,21.56,20.84,20.44,21.5,22.28,20.66,18.0,16.78,16.59,15.12,11.94,9.94,10.03,8.94,6.38,4.72,6.06,6.81,5.56,4.62,5.84,8.34,9.31,10.12,12.78,16.59,17.56,16.28,15.12,15.28,14.78,12.38,10.94,12.41,14.12,13.59,13.44,15.31,18.19,18.59,18.31,18.97,20.94,21.22,19.59,19.06,20.12,20.19,17.78,15.59,15.22,14.75,11.75,9.34,8.81,10.06,10.25,9.81,10.66,13.06,14.44,14.22,15.06,18.0,20.16,19.5,18.34,18.94,19.59,18.22,16.25,16.19,17.16,16.31,14.38,13.59,14.97,15.12,13.75,12.94,14.34,15.53,15.09,14.81,17.53,20.91,22.12,22.12,22.78,24.03,22.78,20.0,18.81,19.59,19.91,17.84,16.47,16.97,16.88,14.34,11.91,12.25,13.75,13.59,13.41,15.09,18.25,19.62,19.22,19.47,21.56,22.94,22.66,23.38,26.56,28.84,29.06,28.09,29.03,30.47,30.12,28.19,27.47,27.84,26.66,24.03,22.88,24.31,24.84,23.28,21.94,22.25,22.5,20.44,17.53,16.81,16.94,15.59,13.84,13.5,15.31,16.09,15.84,16.25,19.34,22.31,22.12,21.88,22.91,23.97,22.78,20.72,21.09,22.12,21.12,18.44,16.5,16.12,15.09,13.09,11.66,13.16,14.25,12.91,11.31,12.12,13.94,14.03,13.5,14.97,17.44,18.19,17.59,18.34,20.88,22.28,21.88,21.78,23.69,25.0,23.91,22.16,22.34,22.91,21.38,19.28,19.09,20.69,21.31,20.44,20.53,22.31,22.88,21.19,19.69,20.75,21.75,20.5,18.59,18.59,19.09,17.88,15.53,15.56,17.0,17.34,16.0,15.28,16.88,17.44,15.97,15.06,16.88,18.91,18.78,18.16,19.19,20.59,19.81,17.41,16.06,16.19,15.44,13.44,12.81,14.84,16.25,15.72,14.97,16.72,18.47,18.56,17.94,19.03,20.97,21.06,19.25,18.19,18.53,17.62,14.5,12.44,12.56,12.84,11.28,9.69,10.88,12.66,12.72,11.84,12.47,14.34,15.06,14.44,15.16,17.75,18.78,17.25,15.53,16.09,15.84,13.72,10.78,10.5,10.41,9.06,6.81,7.06,8.88,9.5,8.34,8.03,9.78,10.75,9.44,9.12,11.12,12.62,12.19,10.56,10.69,10.88,9.56,7.03,6.5,7.88,8.22,7.06,7.41,9.91,11.97,11.69,11.06,12.16,13.25,11.91,9.97,10.34,11.81,11.88,10.38,10.53,11.94,12.47,10.78,9.56,10.56,11.16,9.84,8.53,10.06,11.66,11.31,9.53,9.69,10.59,9.88,7.78,7.12,8.5,8.84,7.47,6.78,8.62,10.22,9.12,7.94,8.72,9.91,9.19,7.16,7.5,9.31,10.0,9.62,11.0,14.09,16.28,16.22,16.16,18.56,20.56,20.03,18.41,18.31,17.72,14.94,10.75,8.66,8.0,6.69,4.12,3.28,4.84,6.16,5.16,4.81,6.41,7.75,7.06,5.59,6.53,7.81,7.53,5.88,6.41,8.03,8.19,6.53,5.31,6.09,6.78,5.44,4.66,6.28,8.53,8.56,7.97,9.09,11.19,11.28,10.19,11.16,14.44,17.28,17.91,19.38,21.84,22.97,20.5,17.28,15.97,15.75,14.03,11.88,11.94,13.0,12.5,9.62,8.38,8.19,7.44,3.53,0.5,-0.41,-0.56,-2.91,-4.66,-3.47,-1.38,-1.56,-2.66,-1.97,-0.19,0.41,-0.47,0.75,4.81,8.09,9.38,10.28,12.38,13.22,10.25,5.88,3.16,1.88,-0.75,-3.31,-2.94,-0.41,0.72,-0.5,-0.47,1.28,2.91,1.94,1.59,3.5,5.44,4.78,3.44,4.03,5.72,5.81,4.84,5.94,8.69,10.44,10.16,10.62,13.19,15.53,15.16,14.34,15.22,16.25,14.97,13.31,14.78,17.81,19.5,19.78,21.22,23.97,25.38,23.94,22.91,23.62,23.5,20.25,17.16,15.91,15.38,11.91,7.53,4.94,3.75,1.44,-1.22,-1.34,1.28,4.06,5.19,7.53,11.69,15.88,16.19,15.66,16.31,16.78,14.59,11.28,10.09,10.16,9.38,6.91,5.47,5.91,5.19,2.0,-0.44,-0.19,0.69,0.19,-0.31,1.97,5.62,7.31,7.44,8.56,10.66,10.16,7.19,5.0,4.94,4.75,2.59,1.47,3.12,5.25,4.22,2.44,2.0,1.69,-0.84,-4.41,-5.62,-4.31,-3.47,-4.28,-3.59,-0.47,2.66,3.31,4.53,8.0,11.72,12.38,12.0,13.44,15.19,14.84,12.84,11.56,11.69,10.19,6.47,4.0,4.53,5.56,5.62,5.78,7.91,9.94,8.53,5.59,3.94,4.0,2.66,0.75,0.72,3.22,5.03,4.81,5.22,7.81,9.88,9.09,8.0,8.78,10.75,10.53,10.12,11.78,15.34,17.25,17.62,18.66,21.38,22.75,21.16,19.06,19.28,19.25,16.38,13.84,13.69,14.12,12.75,9.88,9.16,10.09,10.28,9.16,9.69,12.38,15.16,15.34,15.84,18.25,20.59,19.31,16.56,15.75,15.94,14.25,11.84,11.25,12.62,13.09,11.69,10.69,11.59,12.06,10.0,7.91,8.56,9.97,9.34,8.47,9.91,12.59,12.72,11.03,10.19,11.06,11.12,9.59,9.19,11.75,13.84,13.19,12.34,13.56,15.19,14.56,13.38,13.94,15.25,15.06,12.91,11.81,12.78,12.72,10.62,9.12,10.09,11.0,9.69,7.59,7.5,8.06,6.62,3.62,2.97,4.31,4.69,3.56,3.84,6.94,9.34,9.78,10.94,13.97,16.66,16.41,14.81,14.97,15.88,14.5,12.0,11.34,12.0,11.19,8.94,7.41,8.59,9.59,8.5,7.75,9.5,11.56,10.91,9.47,9.75,11.12,10.28,7.47,6.0,5.97,4.38,0.78,-1.28,0.03,1.19,0.53,0.16,1.91,4.09,4.41,3.91,5.41,7.97,8.19,6.28,5.5,6.5,6.25,4.0,2.53,4.22,5.75,5.38,4.66,6.0,7.5,6.03,3.53,3.09,4.91,5.22,4.38,4.91,7.44,8.41,7.12,6.12,6.97,7.5,5.91,4.25,4.97,6.75,6.75,5.69,6.34,8.53,9.53,9.03,9.72,12.81,14.38,13.38,11.88,12.0,11.81,9.19,6.34,6.06,6.72,5.91,4.28,4.38,6.84,7.97,7.69,8.53,11.34,12.88,11.78,10.22,10.88,11.75,10.53,8.31,8.22,8.94,7.97,6.0,5.84,8.06,9.03,7.62,6.34,6.94,6.91,5.0,2.88,4.53,6.88,7.5,6.94,8.53,11.25,12.12,11.31,12.06,14.44,15.53,14.16,13.28,14.16,14.66,12.78,10.25,9.94,9.88,7.91,4.31,2.69,2.78,2.19,1.16,1.97,5.94,8.91,9.59,10.0,12.31,13.59,11.94,9.03,7.62,6.78,4.59,2.06,2.41,5.0,6.72,6.12,6.16,8.06,8.81,7.78,7.09,8.81,10.31,9.22,7.25,7.12,7.97,7.53,6.12,6.41,8.28,8.38,6.12,4.03,3.62,2.84,0.16,-1.81,-0.75,1.06,1.56,1.47,3.19,5.66,6.28,5.09,4.97,6.53,6.75,5.0,3.81,4.78,4.78,2.41,-0.16,-0.44,0.09,-0.25,-0.75,1.25,5.22,7.69,8.31,9.69,12.38,13.47,12.16,11.28,12.81,13.94,12.81,10.72,10.47,10.69,9.06,6.25,5.75,6.72,6.91,5.69,5.88,8.0,9.16,7.78,6.81,8.03,9.47,9.09,8.12,8.72,9.53,7.91,4.75,3.19,3.81,4.0,3.06,3.47,6.28,7.59,5.62,3.19,2.53,2.16,0.78,-0.44,0.75,3.38,4.66,4.75,5.97,9.06,35.12,33.62,31.91,31.47,31.84,32.19,31.53:16.41,15.06,15.78,17.25,17.22,16.25,16.81,19.44,22.0,22.31,23.44,26.69,29.06,28.34,27.0,27.69,28.34,26.91,24.38,23.97,24.94,24.41,22.75,22.38,24.09,25.31,24.47,24.78,27.34,30.19,30.53,30.5,32.38,33.94,32.97,29.88,27.94,26.75,24.34,20.72,18.72,19.78,21.22,21.38,22.91,27.09,31.47,33.09,33.41,34.91,36.38,35.72,33.28,32.81,33.25,32.5,29.94,28.5,28.88,28.44,25.38,21.97,20.88,20.5,18.16,15.94,16.34,17.78,17.5,16.5,16.94,19.22,20.56,19.53,19.34,20.88,22.16,21.12,20.03,21.66,23.44,22.91,21.31,21.25,21.5,19.88,17.0,15.59,16.38,16.91,15.31,14.53,16.0,16.78,15.19,13.19,13.56,14.47,14.38,13.78,14.97,17.44,17.84,16.88,17.09,18.94,20.28,19.97,19.25,20.53,21.53,20.16,17.97,17.47,17.81,16.09,13.81,13.81,15.69,16.78,16.44,17.25,19.81,22.44,22.69,23.34,25.84,28.44,28.0,26.72,26.44,26.88,24.78,20.94,18.25,16.62,14.28,10.59,8.81,10.19,11.56,11.28,10.75,12.25,13.91,13.62,13.16,15.25,18.91,21.41,22.56,24.81,28.0,29.59,28.47,27.69,28.38,28.62,26.31,24.22,24.41,25.53,24.5,23.34,24.16,25.72,25.06,22.0,19.22,17.25,13.94,8.78,4.97,3.97,4.47,3.66,3.75,6.41,10.03,11.31,11.34,13.03,15.59,16.44,15.5,15.91,18.12,19.34,18.78,19.19,21.41,23.47,23.06,22.06,22.59,24.09,23.69,22.59,23.31,25.97,27.28,27.44,28.34,31.19,32.41,30.88,28.53,27.16,26.28,23.0,20.25,20.16,21.91,21.59,20.44,20.34,21.25,20.91,19.06,18.47,20.03,21.56,20.84,20.44,21.5,22.28,20.66,18.0,16.78,16.59,15.12,11.94,9.94,10.03,8.94,6.38,4.72,6.06,6.81,5.56,4.62,5.84,8.34,9.31,10.12,12.78,16.59,17.56,16.28,15.12,15.28,14.78,12.38,10.94,12.41,14.12,13.59,13.44,15.31,18.19,18.59,18.31,18.97,20.94,21.22,19.59,19.06,20.12,20.19,17.78,15.59,15.22,14.75,11.75,9.34,8.81,10.06,10.25,9.81,10.66,13.06,14.44,14.22,15.06,18.0,20.16,19.5,18.34,18.94,19.59,18.22,16.25,16.19,17.16,16.31,14.38,13.59,14.97,15.12,13.75,12.94,14.34,15.53,15.09,14.81,17.53,20.91,22.12,22.12,22.78,24.03,22.78,20.0,18.81,19.59,19.91,17.84,16.47,16.97,16.88,14.34,11.91,12.25,13.75,13.59,13.41,15.09,18.25,19.62,19.22,19.47,21.56,22.94,22.66,23.38,26.56,28.84,29.06,28.09,29.03,30.47,30.12,28.19,27.47,27.84,26.66,24.03,22.88,24.31,24.84,23.28,21.94,22.25,22.5,20.44,17.53,16.81,16.94,15.59,13.84,13.5,15.31,16.09,15.84,16.25,19.34,22.31,22.12,21.88,22.91,23.97,22.78,20.72,21.09,22.12,21.12,18.44,16.5,16.12,15.09,13.09,11.66,13.16,14.25,12.91,11.31,12.12,13.94,14.03,13.5,14.97,17.44,18.19,17.59,18.34,20.88,22.28,21.88,21.78,23.69,25.0,23.91,22.16,22.34,22.91,21.38,19.28,19.09,20.69,21.31,20.44,20.53,22.31,22.88,21.19,19.69,20.75,21.75,20.5,18.59,18.59,19.09,17.88,15.53,15.56,17.0,17.34,16.0,15.28,16.88,17.44,15.97,15.06,16.88,18.91,18.78,18.16,19.19,20.59,19.81,17.41,16.06,16.19,15.44,13.44,12.81,14.84,16.25,15.72,14.97,16.72,18.47,18.56,17.94,19.03,20.97,21.06,19.25,18.19,18.53,17.62,14.5,12.44,12.56,12.84,11.28,9.69,10.88,12.66,12.72,11.84,12.47,14.34,15.06,14.44,15.16,17.75,18.78,17.25,15.53,16.09,15.84,13.72,10.78,10.5,10.41,9.06,6.81,7.06,8.88,9.5,8.34,8.03,9.78,10.75,9.44,9.12,11.12,12.62,12.19,10.56,10.69,10.88,9.56,7.03,6.5,7.88,8.22,7.06,7.41,9.91,11.97,11.69,11.06,12.16,13.25,11.91,9.97,10.34,11.81,11.88,10.38,10.53,11.94,12.47,10.78,9.56,10.56,11.16,9.84,8.53,10.06,11.66,11.31,9.53,9.69,10.59,9.88,7.78,7.12,8.5,8.84,7.47,6.78,8.62,10.22,9.12,7.94,8.72,9.91,9.19,7.16,7.5,9.31,10.0,9.62,11.0,14.09,16.28,16.22,16.16,18.56,20.56,20.03,18.41,18.31,17.72,14.94,10.75,8.66,8.0,6.69,4.12,3.28,4.84,6.16,5.16,4.81,6.41,7.75,7.06,5.59,6.53,7.81,7.53,5.88,6.41,8.03,8.19,6.53,5.31,6.09,6.78,5.44,4.66,6.28,8.53,8.56,7.97,9.09,11.19,11.28,10.19,11.16,14.44,17.28,17.91,19.38,21.84,22.97,20.5,17.28,15.97,15.75,14.03,11.88,11.94,13.0,12.5,9.62,8.38,8.19,7.44,3.53,0.5,-0.41,-0.56,-2.91,-4.66,-3.47,-1.38,-1.56,-2.66,-1.97,-0.19,0.41,-0.47,0.75,4.81,8.09,9.38,10.28,12.38,13.22,10.25,5.88,3.16,1.88,-0.75,-3.31,-2.94,-0.41,0.72,-0.5,-0.47,1.28,2.91,1.94,1.59,3.5,5.44,4.78,3.44,4.03,5.72,5.81,4.84,5.94,8.69,10.44,10.16,10.62,13.19,15.53,15.16,14.34,15.22,16.25,14.97,13.31,14.78,17.81,19.5,19.78,21.22,23.97,25.38,23.94,22.91,23.62,23.5,20.25,17.16,15.91,15.38,11.91,7.53,4.94,3.75,1.44,-1.22,-1.34,1.28,4.06,5.19,7.53,11.69,15.88,16.19,15.66,16.31,16.78,14.59,11.28,10.09,10.16,9.38,6.91,5.47,5.91,5.19,2.0,-0.44,-0.19,0.69,0.19,-0.31,1.97,5.62,7.31,7.44,8.56,10.66,10.16,7.19,5.0,4.94,4.75,2.59,1.47,3.12,5.25,4.22,2.44,2.0,1.69,-0.84,-4.41,-5.62,-4.31,-3.47,-4.28,-3.59,-0.47,2.66,3.31,4.53,8.0,11.72,12.38,12.0,13.44,15.19,14.84,12.84,11.56,11.69,10.19,6.47,4.0,4.53,5.56,5.62,5.78,7.91,9.94,8.53,5.59,3.94,4.0,2.66,0.75,0.72,3.22,5.03,4.81,5.22,7.81,9.88,9.09,8.0,8.78,10.75,10.53,10.12,11.78,15.34,17.25,17.62,18.66,21.38,22.75,21.16,19.06,19.28,19.25,16.38,13.84,13.69,14.12,12.75,9.88,9.16,10.09,10.28,9.16,9.69,12.38,15.16,15.34,15.84,18.25,20.59,19.31,16.56,15.75,15.94,14.25,11.84,11.25,12.62,13.09,11.69,10.69,11.59,12.06,10.0,7.91,8.56,9.97,9.34,8.47,9.91,12.59,12.72,11.03,10.19,11.06,11.12,9.59,9.19,11.75,13.84,13.19,12.34,13.56,15.19,14.56,13.38,13.94,15.25,15.06,12.91,11.81,12.78,12.72,10.62,9.12,10.09,11.0,9.69,7.59,7.5,8.06,6.62,3.62,2.97,4.31,4.69,3.56,3.84,6.94,9.34,9.78,10.94,13.97,16.66,16.41,14.81,14.97,15.88,14.5,12.0,11.34,12.0,11.19,8.94,7.41,8.59,9.59,8.5,7.75,9.5,11.56,10.91,9.47,9.75,11.12,10.28,7.47,6.0,5.97,4.38,0.78,-1.28,0.03,1.19,0.53,0.16,1.91,4.09,4.41,3.91,5.41,7.97,8.19,6.28,5.5,6.5,6.25,4.0,2.53,4.22,5.75,5.38,4.66,6.0,7.5,6.03,3.53,3.09,4.91,5.22,4.38,4.91,7.44,8.41,7.12,6.12,6.97,7.5,5.91,4.25,4.97,6.75,6.75,5.69,6.34,8.53,9.53,9.03,9.72,12.81,14.38,13.38,11.88,12.0,11.81,9.19,6.34,6.06,6.72,5.91,4.28,4.38,6.84,7.97,7.69,8.53,11.34,12.88,11.78,10.22,10.88,11.75,10.53,8.31,8.22,8.94,7.97,6.0,5.84,8.06,9.03,7.62,6.34,6.94,6.91,5.0,2.88,4.53,6.88,7.5,6.94,8.53,11.25,12.12,11.31,12.06,14.44,15.53,14.16,13.28,14.16,14.66,12.78,10.25,9.94,9.88,7.91,4.31,2.69,2.78,2.19,1.16,1.97,5.94,8.91,9.59,10.0,12.31,13.59,11.94,9.03,7.62,6.78,4.59,2.06,2.41,5.0,6.72,6.12,6.16,8.06,8.81,7.78,7.09,8.81,10.31,9.22,7.25,7.12,7.97,7.53,6.12,6.41,8.28,8.38,6.12,4.03,3.62,2.84,0.16,-1.81,-0.75,1.06,1.56,1.47,3.19,5.66,6.28,5.09,4.97,6.53,6.75,5.0,3.81,4.78,4.78,2.41,-0.16,-0.44,0.09,-0.25,-0.75,1.25,5.22,7.69,8.31,9.69,12.38,13.47,12.16,11.28,12.81,13.94,12.81,10.72,10.47,10.69,9.06,6.25,5.75,6.72,6.91,5.69,5.88,8.0,9.16,7.78,6.81,8.03,9.47,9.09,8.12,8.72,9.53,7.91,4.75,3.19,3.81,4.0,3.06,3.47,6.28,7.59,5.62,3.19,2.53,2.16,0.78,-0.44,0.75,3.38,4.66,4.75,5.97,9.06,35.12,33.62,31.91,31.47,31.84,32.19,31.53,31.16,31.69,31.47,29.75,28.09,28.34,28.75:19.44,22.0,22.31,23.44,26.69,29.06,28.34,27.0,27.69,28.34,26.91,24.38,23.97,24.94,24.41,22.75,22.38,24.09,25.31,24.47,24.78,27.34,30.19,30.53,30.5,32.38,33.94,32.97,29.88,27.94,26.75,24.34,20.72,18.72,19.78,21.22,21.38,22.91,27.09,31.47,33.09,33.41,34.91,36.38,35.72,33.28,32.81,33.25,32.5,29.94,28.5,28.88,28.44,25.38,21.97,20.88,20.5,18.16,15.94,16.34,17.78,17.5,16.5,16.94,19.22,20.56,19.53,19.34,20.88,22.16,21.12,20.03,21.66,23.44,22.91,21.31,21.25,21.5,19.88,17.0,15.59,16.38,16.91,15.31,14.53,16.0,16.78,15.19,13.19,13.56,14.47,14.38,13.78,14.97,17.44,17.84,16.88,17.09,18.94,20.28,19.97,19.25,20.53,21.53,20.16,17.97,17.47,17.81,16.09,13.81,13.81,15.69,16.78,16.44,17.25,19.81,22.44,22.69,23.34,25.84,28.44,28.0,26.72,26.44,26.88,24.78,20.94,18.25,16.62,14.28,10.59,8.81,10.19,11.56,11.28,10.75,12.25,13.91,13.62,13.16,15.25,18.91,21.41,22.56,24.81,28.0,29.59,28.47,27.69,28.38,28.62,26.31,24.22,24.41,25.53,24.5,23.34,24.16,25.72,25.06,22.0,19.22,17.25,13.94,8.78,4.97,3.97,4.47,3.66,3.75,6.41,10.03,11.31,11.34,13.03,15.59,16.44,15.5,15.91,18.12,19.34,18.78,19.19,21.41,23.47,23.06,22.06,22.59,24.09,23.69,22.59,23.31,25.97,27.28,27.44,28.34,31.19,32.41,30.88,28.53,27.16,26.28,23.0,20.25,20.16,21.91,21.59,20.44,20.34,21.25,20.91,19.06,18.47,20.03,21.56,20.84,20.44,21.5,22.28,20.66,18.0,16.78,16.59,15.12,11.94,9.94,10.03,8.94,6.38,4.72,6.06,6.81,5.56,4.62,5.84,8.34,9.31,10.12,12.78,16.59,17.56,16.28,15.12,15.28,14.78,12.38,10.94,12.41,14.12,13.59,13.44,15.31,18.19,18.59,18.31,18.97,20.94,21.22,19.59,19.06,20.12,20.19,17.78,15.59,15.22,14.75,11.75,9.34,8.81,10.06,10.25,9.81,10.66,13.06,14.44,14.22,15.06,18.0,20.16,19.5,18.34,18.94,19.59,18.22,16.25,16.19,17.16,16.31,14.38,13.59,14.97,15.12,13.75,12.94,14.34,15.53,15.09,14.81,17.53,20.91,22.12,22.12,22.78,24.03,22.78,20.0,18.81,19.59,19.91,17.84,16.47,16.97,16.88,14.34,11.91,12.25,13.75,13.59,13.41,15.09,18.25,19.62,19.22,19.47,21.56,22.94,22.66,23.38,26.56,28.84,29.06,28.09,29.03,30.47,30.12,28.19,27.47,27.84,26.66,24.03,22.88,24.31,24.84,23.28,21.94,22.25,22.5,20.44,17.53,16.81,16.94,15.59,13.84,13.5,15.31,16.09,15.84,16.25,19.34,22.31,22.12,21.88,22.91,23.97,22.78,20.72,21.09,22.12,21.12,18.44,16.5,16.12,15.09,13.09,11.66,13.16,14.25,12.91,11.31,12.12,13.94,14.03,13.5,14.97,17.44,18.19,17.59,18.34,20.88,22.28,21.88,21.78,23.69,25.0,23.91,22.16,22.34,22.91,21.38,19.28,19.09,20.69,21.31,20.44,20.53,22.31,22.88,21.19,19.69,20.75,21.75,20.5,18.59,18.59,19.09,17.88,15.53,15.56,17.0,17.34,16.0,15.28,16.88,17.44,15.97,15.06,16.88,18.91,18.78,18.16,19.19,20.59,19.81,17.41,16.06,16.19,15.44,13.44,12.81,14.84,16.25,15.72,14.97,16.72,18.47,18.56,17.94,19.03,20.97,21.06,19.25,18.19,18.53,17.62,14.5,12.44,12.56,12.84,11.28,9.69,10.88,12.66,12.72,11.84,12.47,14.34,15.06,14.44,15.16,17.75,18.78,17.25,15.53,16.09,15.84,13.72,10.78,10.5,10.41,9.06,6.81,7.06,8.88,9.5,8.34,8.03,9.78,10.75,9.44,9.12,11.12,12.62,12.19,10.56,10.69,10.88,9.56,7.03,6.5,7.88,8.22,7.06,7.41,9.91,11.97,11.69,11.06,12.16,13.25,11.91,9.97,10.34,11.81,11.88,10.38,10.53,11.94,12.47,10.78,9.56,10.56,11.16,9.84,8.53,10.06,11.66,11.31,9.53,9.69,10.59,9.88,7.78,7.12,8.5,8.84,7.47,6.78,8.62,10.22,9.12,7.94,8.72,9.91,9.19,7.16,7.5,9.31,10.0,9.62,11.0,14.09,16.28,16.22,16.16,18.56,20.56,20.03,18.41,18.31,17.72,14.94,10.75,8.66,8.0,6.69,4.12,3.28,4.84,6.16,5.16,4.81,6.41,7.75,7.06,5.59,6.53,7.81,7.53,5.88,6.41,8.03,8.19,6.53,5.31,6.09,6.78,5.44,4.66,6.28,8.53,8.56,7.97,9.09,11.19,11.28,10.19,11.16,14.44,17.28,17.91,19.38,21.84,22.97,20.5,17.28,15.97,15.75,14.03,11.88,11.94,13.0,12.5,9.62,8.38,8.19,7.44,3.53,0.5,-0.41,-0.56,-2.91,-4.66,-3.47,-1.38,-1.56,-2.66,-1.97,-0.19,0.41,-0.47,0.75,4.81,8.09,9.38,10.28,12.38,13.22,10.25,5.88,3.16,1.88,-0.75,-3.31,-2.94,-0.41,0.72,-0.5,-0.47,1.28,2.91,1.94,1.59,3.5,5.44,4.78,3.44,4.03,5.72,5.81,4.84,5.94,8.69,10.44,10.16,10.62,13.19,15.53,15.16,14.34,15.22,16.25,14.97,13.31,14.78,17.81,19.5,19.78,21.22,23.97,25.38,23.94,22.91,23.62,23.5,20.25,17.16,15.91,15.38,11.91,7.53,4.94,3.75,1.44,-1.22,-1.34,1.28,4.06,5.19,7.53,11.69,15.88,16.19,15.66,16.31,16.78,14.59,11.28,10.09,10.16,9.38,6.91,5.47,5.91,5.19,2.0,-0.44,-0.19,0.69,0.19,-0.31,1.97,5.62,7.31,7.44,8.56,10.66,10.16,7.19,5.0,4.94,4.75,2.59,1.47,3.12,5.25,4.22,2.44,2.0,1.69,-0.84,-4.41,-5.62,-4.31,-3.47,-4.28,-3.59,-0.47,2.66,3.31,4.53,8.0,11.72,12.38,12.0,13.44,15.19,14.84,12.84,11.56,11.69,10.19,6.47,4.0,4.53,5.56,5.62,5.78,7.91,9.94,8.53,5.59,3.94,4.0,2.66,0.75,0.72,3.22,5.03,4.81,5.22,7.81,9.88,9.09,8.0,8.78,10.75,10.53,10.12,11.78,15.34,17.25,17.62,18.66,21.38,22.75,21.16,19.06,19.28,19.25,16.38,13.84,13.69,14.12,12.75,9.88,9.16,10.09,10.28,9.16,9.69,12.38,15.16,15.34,15.84,18.25,20.59,19.31,16.56,15.75,15.94,14.25,11.84,11.25,12.62,13.09,11.69,10.69,11.59,12.06,10.0,7.91,8.56,9.97,9.34,8.47,9.91,12.59,12.72,11.03,10.19,11.06,11.12,9.59,9.19,11.75,13.84,13.19,12.34,13.56,15.19,14.56,13.38,13.94,15.25,15.06,12.91,11.81,12.78,12.72,10.62,9.12,10.09,11.0,9.69,7.59,7.5,8.06,6.62,3.62,2.97,4.31,4.69,3.56,3.84,6.94,9.34,9.78,10.94,13.97,16.66,16.41,14.81,14.97,15.88,14.5,12.0,11.34,12.0,11.19,8.94,7.41,8.59,9.59,8.5,7.75,9.5,11.56,10.91,9.47,9.75,11.12,10.28,7.47,6.0,5.97,4.38,0.78,-1.28,0.03,1.19,0.53,0.16,1.91,4.09,4.41,3.91,5.41,7.97,8.19,6.28,5.5,6.5,6.25,4.0,2.53,4.22,5.75,5.38,4.66,6.0,7.5,6.03,3.53,3.09,4.91,5.22,4.38,4.91,7.44,8.41,7.12,6.12,6.97,7.5,5.91,4.25,4.97,6.75,6.75,5.69,6.34,8.53,9.53,9.03,9.72,12.81,14.38,13.38,11.88,12.0,11.81,9.19,6.34,6.06,6.72,5.91,4.28,4.38,6.84,7.97,7.69,8.53,11.34,12.88,11.78,10.22,10.88,11.75,10.53,8.31,8.22,8.94,7.97,6.0,5.84,8.06,9.03,7.62,6.34,6.94,6.91,5.0,2.88,4.53,6.88,7.5,6.94,8.53,11.25,12.12,11.31,12.06,14.44,15.53,14.16,13.28,14.16,14.66,12.78,10.25,9.94,9.88,7.91,4.31,2.69,2.78,2.19,1.16,1.97,5.94,8.91,9.59,10.0,12.31,13.59,11.94,9.03,7.62,6.78,4.59,2.06,2.41,5.0,6.72,6.12,6.16,8.06,8.81,7.78,7.09,8.81,10.31,9.22,7.25,7.12,7.97,7.53,6.12,6.41,8.28,8.38,6.12,4.03,3.62,2.84,0.16,-1.81,-0.75,1.06,1.56,1.47,3.19,5.66,6.28,5.09,4.97,6.53,6.75,5.0,3.81,4.78,4.78,2.41,-0.16,-0.44,0.09,-0.25,-0.75,1.25,5.22,7.69,8.31,9.69,12.38,13.47,12.16,11.28,12.81,13.94,12.81,10.72,10.47,10.69,9.06,6.25,5.75,6.72,6.91,5.69,5.88,8.0,9.16,7.78,6.81,8.03,9.47,9.09,8.12,8.72,9.53,7.91,4.75,3.19,3.81,4.0,3.06,3.47,6.28,7.59,5.62,3.19,2.53,2.16,0.78,-0.44,0.75,3.38,4.66,4.75,5.97,9.06,35.12,33.62,31.91,31.47,31.84,32.19,31.53,31.16,31.69,31.47,29.75,28.09,28.34,28.75,27.88,27.28,28.34,29.28,29.34,28.94,29.97:27.0,27.69,28.34,26.91,24.38,23.97,24.94,24.41,22.75,22.38,24.09,25.31,24.47,24.78,27.34,30.19,30.53,30.5,32.38,33.94,32.97,29.88,27.94,26.75,24.34,20.72,18.72,19.78,21.22,21.38,22.91,27.09,31.47,33.09,33.41,34.91,36.38,35.72,33.28,32.81,33.25,32.5,29.94,28.5,28.88,28.44,25.38,21.97,20.88,20.5,18.16,15.94,16.34,17.78,17.5,16.5,16.94,19.22,20.56,19.53,19.34,20.88,22.16,21.12,20.03,21.66,23.44,22.91,21.31,21.25,21.5,19.88,17.0,15.59,16.38,16.91,15.31,14.53,16.0,16.78,15.19,13.19,13.56,14.47,14.38,13.78,14.97,17.44,17.84,16.88,17.09,18.94,20.28,19.97,19.25,20.53,21.53,20.16,17.97,17.47,17.81,16.09,13.81,13.81,15.69,16.78,16.44,17.25,19.81,22.44,22.69,23.34,25.84,28.44,28.0,26.72,26.44,26.88,24.78,20.94,18.25,16.62,14.28,10.59,8.81,10.19,11.56,11.28,10.75,12.25,13.91,13.62,13.16,15