# SRT: Super-Resolution for Time Series via Disentangled Rectified Flow

This repository contains the implementation for the paper **"SRT: Super-Resolution for Time Series via Disentangled Rectified Flow."**

## Quick Start

- The demo script [`demo_srt.sh`](demo_srt.sh) showcases our SRT algorithm.
    - Use the `dataset` parameter to select among public datasets.
    - Adjust the `task_type` parameter to switch between the two TSSR subtasks.
- To modify other parameters, please refer to [`set_param.py`](set_param.py).

## Environment

- To prevent incompatibility issues, all dependency packages and their versions have been exported to [`requirements.txt`](requirements.txt).
- If you encounter environment compatibility problems when running the demo, please refer to this file for the required package versions.

## Note

- **Note:** The parameter size of SRT-large is too large to be provided as supplementary material. It will be uploaded to Github in the camera-ready stage.
- The original MotorImagery and PEMS-SF datasets are also relatively large; please download them yourself from the [UEA time series classification archive](http://www.timeseriesclassification.com). Afterwards, you can process the raw data by running [`preprocessing.py`](preprocessing.py).