#SelfRegulationSCP1.
#
#from 
#http://bbci.de/competition/ii/tuebingen_desc_i.html
#
#Data set Ia: Self-regulation of Slow Cortical Potentials
#
#Datasets provided by University of Tuebingen. 
#Correspondence to Thilo Hinterberger <thilo.Hinterberger@uni-tuebingen.de> 
# 
#Description of Experiments:
#The datasets were taken from a healthy subject. 
#The subject was asked to move a cursor up and down on a computer screen, while his cortical potentials were taken. During the recording, the subject received visual feedback of his slow cortical potentials (Cz-Mastoids).  Cortical positivity lead to a downward movement of the cursor on the screen.  Cortical negativity lead to an upward movement of the cursor.  Each trial lasted 6s. 
#During every trial, the task was visually presented by a highlighted goal at either the top or bottom of the screen to indicate negativity or positivity from second 0.5 until the end of the trial. The visual feedback was presented from second 2 to second 5.5. Only this 3.5 second interval of every trial is provided for training and testing. The sampling rate of 256 Hz and the recording length of 3.5s results in 896 samples per channel for every trial.
#Trial structure overview: 
#Duration: 6 s, no inter trial intervals 
#Task presentation: from 0.5 s to 6.0 s 
#Feedback period: from 2.0 s to 5.5 s 
# 
#
#Data:
#Amplifier: PsyLab EEG8 
#A/D-converter: Computer Boards PCIM-DAS1602/16 bit 
#Amplitude range: +/-1000 �V 
#Sampling rate: 256 S/s 
#EEG data was taken from the following positions: 
#Channel 1: A1-Cz (10/20 system) (A1 = left mastoid) 
#Channel 2: A2-Cz 
#Channel 3: 2 cm frontal of C3 
#Channel 4: 2 cm parietal of C3 
#Channel 5: 2 cm frontal of C4 
#Channel 6: 2 cm parietal of C4 
#All values are in �Volt. 
# 
#The train data consists of 268 trials recorded on two different days and mixed randomly. 168 of the overall 268 trials origin from day 1, the remaining 100 trials from day 2. 
#The data is derived from the two train files Traindata_0.txt and Traindata_1.txt. 
#Each instance has six dimensions (EEG channels above) of length 896. Class labels are negativity or positivity. There are 293 test data, the labels of which were released after the competition. 
#Results are here
#http://bbci.de/competition/ii/results/index.html
#best has an error rate of 11.3% on the test data (presumably 33 incorrect). 
#Reference:
#Birbaumer, N., Flor, H., Ghanayim, N., Hinterberger, T., Iverson, I., Taub, E., Kotchoubey, B., K�bler, A., & Perelmouter, J, A Brain-Controlled Spelling Device for the Completely Paralyzed, Nature, 398, 297-298.
#
# 
@problemName SelfRegulationSCP1
@timeStamps false
@missing false
@univariate false
@dimensions 6
@equalLength true
@seriesLength 896
@classLabel true negativity positivity
@data
23.0,21.66,20.84,20.41,19.94,19.44,19.03,19.19,21.5,22.25,25.0,28.31,32.19,36.81,40.16,43.38,43.78,44.84,43.66,41.22,39.69,37.44,34.97,33.0,30.72,31.81,31.69,34.94,35.81,36.94,39.09,39.53,40.59,41.0,41.44,42.78,42.69,42.88,43.44,43.81,44.44,45.5,46.34,45.69,48.16,48.56,48.28,48.47,48.0,47.34,47.19,45.84,45.41,43.41,43.94,42.56,42.0,39.06,41.66,40.47,41.06,41.75,41.03,40.88,39.12,36.0,34.62,32.44,32.0,30.84,28.78,27.84,24.0,21.88,19.78,19.41,20.78,23.06,25.53,28.19,29.75,31.38,32.41,32.16,31.91,31.22,30.16,27.88,26.44,24.62,23.03,21.59,21.72,22.81,25.0,24.94,27.09,26.53,25.38,24.41,22.62,23.16,22.28,21.25,21.09,18.22,15.94,16.19,15.44,19.25,21.62,24.41,25.09,25.28,23.94,23.44,21.91,21.06,20.22,18.5,17.5,17.16,16.19,16.62,18.34,20.12,21.34,23.75,26.44,28.38,30.38,32.72,32.75,31.16,29.28,28.56,25.16,24.66,24.81,24.75,26.22,26.41,26.41,25.5,23.44,23.25,21.72,20.59,22.72,22.19,25.16,27.31,29.25,32.78,32.84,34.19,33.62,31.66,30.44,26.72,25.75,23.19,21.16,19.91,18.28,18.78,18.75,19.78,20.25,21.38,18.62,20.59,22.31,26.03,30.38,35.25,37.12,37.31,35.44,31.56,29.44,28.19,27.22,26.81,26.41,25.69,23.53,22.06,21.81,21.88,21.97,23.09,24.56,25.16,26.44,27.06,29.34,31.0,32.06,32.16,32.19,28.56,28.06,26.03,24.88,25.84,26.5,26.97,26.34,22.78,21.5,18.94,16.59,17.06,16.88,17.44,18.78,19.53,21.59,22.06,23.91,25.56,25.94,27.78,26.81,27.16,28.5,28.88,29.94,32.5,36.5,38.19,41.16,42.12,40.66,36.12,34.12,31.09,29.28,30.34,33.56,36.53,37.5,38.94,39.91,38.03,36.66,34.25,34.44,33.81,33.41,32.56,31.88,29.91,27.97,25.53,25.69,24.41,24.38,23.28,22.72,22.47,22.0,23.19,24.09,25.78,26.84,26.16,26.69,26.0,25.41,24.97,25.5,27.0,27.12,28.38,29.06,30.53,29.19,31.38,33.41,34.06,36.0,36.38,37.66,39.62,41.25,43.44,44.0,44.75,44.44,41.75,40.62,37.59,36.56,36.41,35.31,38.06,39.78,40.25,40.44,39.31,38.34,35.72,32.94,30.31,27.25,25.81,25.97,27.56,29.41,32.94,34.31,35.0,35.44,34.41,34.69,35.16,34.56,34.62,34.75,34.19,33.84,31.91,29.94,27.94,25.03,22.19,20.41,19.06,18.56,18.59,19.41,21.03,23.69,26.38,28.16,29.44,30.0,28.56,25.62,23.88,21.03,17.44,15.03,13.41,11.81,12.44,13.56,16.03,18.03,20.84,25.41,27.16,29.81,33.47,34.56,35.62,37.38,37.59,39.0,40.25,41.16,41.44,41.72,42.22,42.62,42.16,42.56,42.62,41.81,40.56,39.12,37.69,36.91,37.06,36.88,39.25,38.25,38.5,37.81,34.75,33.06,31.56,29.72,28.56,26.41,26.41,25.41,24.84,25.34,25.47,25.56,25.5,26.5,28.09,29.12,31.62,32.12,33.97,34.03,35.78,34.59,32.94,32.59,30.12,28.91,29.28,29.0,30.31,31.75,32.81,32.31,31.25,29.66,27.66,27.03,26.72,28.16,30.03,31.66,34.19,35.44,35.53,35.91,36.31,33.88,33.53,31.19,27.59,25.47,23.06,19.84,22.59,22.09,23.69,26.0,26.75,27.62,27.81,27.0,26.84,25.28,24.78,24.81,25.0,25.47,27.62,27.78,29.09,31.34,33.0,34.72,38.31,41.0,41.78,41.91,42.5,39.91,36.91,34.78,33.38,33.59,33.0,34.0,33.81,33.16,33.22,32.41,32.84,32.69,35.62,36.84,38.69,41.19,42.31,42.94,41.44,40.0,37.47,34.31,31.81,31.0,30.31,30.75,31.19,30.94,30.94,31.56,32.12,31.72,32.69,32.16,32.06,31.47,31.62,32.53,32.69,34.44,37.22,38.0,40.31,41.5,40.94,41.56,40.75,41.66,40.31,40.31,39.75,38.22,37.38,37.0,35.81,34.56,34.66,32.72,30.59,28.81,28.09,28.12,30.09,33.34,36.0,37.78,38.88,39.34,39.41,38.38,38.84,36.84,37.06,36.31,35.06,35.94,34.84,33.72,33.66,32.16,30.69,29.66,30.28,30.06,30.94,31.06,32.0,32.41,31.94,32.06,31.0,30.19,29.03,26.91,25.22,25.03,22.81,23.12,23.31,24.88,25.0,25.5,25.88,27.09,27.56,28.12,29.22,31.66,32.41,34.62,34.06,34.34,32.44,30.62,29.16,25.38,24.75,24.81,25.16,27.69,30.94,32.66,34.69,35.0,34.94,34.28,33.88,32.72,31.06,31.81,33.31,32.69,34.69,36.47,37.72,38.41,39.72,40.66,39.47,37.94,37.19,35.62,35.75,34.09,34.78,34.88,34.25,34.0,33.69,33.06,33.28,33.16,33.06,32.41,32.31,31.91,30.72,30.66,30.69,30.97,31.34,32.09,32.38,32.31,32.31,28.69,30.84,28.12,27.5,27.53,26.5,26.28,25.66,24.97,23.59,23.66,23.59,22.31,23.28,23.28,24.12,26.41,26.62,27.34,28.41,27.31,27.12,26.28,27.84,29.44,31.12,35.44,37.44,39.97,40.06,41.22,40.28,41.56,40.31,40.84,41.41,43.62,42.12,42.56,41.62,39.03,37.44,36.06,35.0,34.06,34.16,33.03,32.94,31.84,30.72,30.19,29.19,28.0,26.94,27.72,27.5,29.81,30.34,30.44,31.44,30.31,30.12,29.84,29.5,28.22,28.31,26.69,27.53,26.41,28.62,29.41,31.09,32.59,33.53,32.81,33.09,33.16,34.72,35.31,35.38,34.78,37.91,38.31,39.12,40.62,39.62,37.78,35.56,33.19,31.81,31.12,30.28,30.16,29.31,28.41,28.03,28.81,29.94,31.09,34.0,36.84,39.25,39.38,41.25,40.31,38.44,39.41,38.16,37.69,38.88,37.44,37.56,36.25,35.62,34.53,31.91,29.75,27.31,26.06,25.12,26.03,25.69,26.19,24.31,25.53,24.25,24.78,26.75,27.56,29.44,31.81,32.5,34.75,37.38,38.0,38.5,38.19,37.56,36.12,34.97,33.16,29.62,26.94,23.25,21.62,19.66,18.66,18.47,19.28,18.66,18.0,18.5,17.69,15.75,15.72,15.94,15.38,16.81,18.19,19.28,20.38,19.81,19.97,20.19,19.16,19.72,18.91,19.19,19.38,19.22,19.81,19.81,19.94,20.34,19.69,20.06,20.59,20.88,21.53,22.06,22.19,21.56,23.03,22.03,21.53,22.12,23.12,23.19,24.75,25.25,24.81,25.0,23.56,23.09,22.31,25.03,25.25,25.56,25.06,23.22,20.59,18.16,16.69,14.41,14.38,13.72,13.34,14.53,15.31,16.84,18.41,18.16,18.66,17.06,16.62,15.06,13.69,10.66,9.34,6.81,4.5,2.91,3.31,5.31,8.59,13.12,18.12,23.0,25.19,27.81,29.97,28.81,29.72,29.69,30.5,29.41,31.28,30.25,29.19,27.31,24.5,21.47,16.62,16.22,15.59,15.31,18.72,20.75,22.56,23.53,23.56,23.53,21.66,19.75,17.66,17.97,16.84,17.44,17.97,19.19,19.94,20.62,21.78,21.53,22.62,23.78,24.31,23.94,22.84,21.84,22.62,21.5:19.03,19.19,21.5,22.25,25.0,28.31,32.19,36.81,40.16,43.38,43.78,44.84,43.66,41.22,39.69,37.44,34.97,33.0,30.72,31.81,31.69,34.94,35.81,36.94,39.09,39.53,40.59,41.0,41.44,42.78,42.69,42.88,43.44,43.81,44.44,45.5,46.34,45.69,48.16,48.56,48.28,48.47,48.0,47.34,47.19,45.84,45.41,43.41,43.94,42.56,42.0,39.06,41.66,40.47,41.06,41.75,41.03,40.88,39.12,36.0,34.62,32.44,32.0,30.84,28.78,27.84,24.0,21.88,19.78,19.41,20.78,23.06,25.53,28.19,29.75,31.38,32.41,32.16,31.91,31.22,30.16,27.88,26.44,24.62,23.03,21.59,21.72,22.81,25.0,24.94,27.09,26.53,25.38,24.41,22.62,23.16,22.28,21.25,21.09,18.22,15.94,16.19,15.44,19.25,21.62,24.41,25.09,25.28,23.94,23.44,21.91,21.06,20.22,18.5,17.5,17.16,16.19,16.62,18.34,20.12,21.34,23.75,26.44,28.38,30.38,32.72,32.75,31.16,29.28,28.56,25.16,24.66,24.81,24.75,26.22,26.41,26.41,25.5,23.44,23.25,21.72,20.59,22.72,22.19,25.16,27.31,29.25,32.78,32.84,34.19,33.62,31.66,30.44,26.72,25.75,23.19,21.16,19.91,18.28,18.78,18.75,19.78,20.25,21.38,18.62,20.59,22.31,26.03,30.38,35.25,37.12,37.31,35.44,31.56,29.44,28.19,27.22,26.81,26.41,25.69,23.53,22.06,21.81,21.88,21.97,23.09,24.56,25.16,26.44,27.06,29.34,31.0,32.06,32.16,32.19,28.56,28.06,26.03,24.88,25.84,26.5,26.97,26.34,22.78,21.5,18.94,16.59,17.06,16.88,17.44,18.78,19.53,21.59,22.06,23.91,25.56,25.94,27.78,26.81,27.16,28.5,28.88,29.94,32.5,36.5,38.19,41.16,42.12,40.66,36.12,34.12,31.09,29.28,30.34,33.56,36.53,37.5,38.94,39.91,38.03,36.66,34.25,34.44,33.81,33.41,32.56,31.88,29.91,27.97,25.53,25.69,24.41,24.38,23.28,22.72,22.47,22.0,23.19,24.09,25.78,26.84,26.16,26.69,26.0,25.41,24.97,25.5,27.0,27.12,28.38,29.06,30.53,29.19,31.38,33.41,34.06,36.0,36.38,37.66,39.62,41.25,43.44,44.0,44.75,44.44,41.75,40.62,37.59,36.56,36.41,35.31,38.06,39.78,40.25,40.44,39.31,38.34,35.72,32.94,30.31,27.25,25.81,25.97,27.56,29.41,32.94,34.31,35.0,35.44,34.41,34.69,35.16,34.56,34.62,34.75,34.19,33.84,31.91,29.94,27.94,25.03,22.19,20.41,19.06,18.56,18.59,19.41,21.03,23.69,26.38,28.16,29.44,30.0,28.56,25.62,23.88,21.03,17.44,15.03,13.41,11.81,12.44,13.56,16.03,18.03,20.84,25.41,27.16,29.81,33.47,34.56,35.62,37.38,37.59,39.0,40.25,41.16,41.44,41.72,42.22,42.62,42.16,42.56,42.62,41.81,40.56,39.12,37.69,36.91,37.06,36.88,39.25,38.25,38.5,37.81,34.75,33.06,31.56,29.72,28.56,26.41,26.41,25.41,24.84,25.34,25.47,25.56,25.5,26.5,28.09,29.12,31.62,32.12,33.97,34.03,35.78,34.59,32.94,32.59,30.12,28.91,29.28,29.0,30.31,31.75,32.81,32.31,31.25,29.66,27.66,27.03,26.72,28.16,30.03,31.66,34.19,35.44,35.53,35.91,36.31,33.88,33.53,31.19,27.59,25.47,23.06,19.84,22.59,22.09,23.69,26.0,26.75,27.62,27.81,27.0,26.84,25.28,24.78,24.81,25.0,25.47,27.62,27.78,29.09,31.34,33.0,34.72,38.31,41.0,41.78,41.91,42.5,39.91,36.91,34.78,33.38,33.59,33.0,34.0,33.81,33.16,33.22,32.41,32.84,32.69,35.62,36.84,38.69,41.19,42.31,42.94,41.44,40.0,37.47,34.31,31.81,31.0,30.31,30.75,31.19,30.94,30.94,31.56,32.12,31.72,32.69,32.16,32.06,31.47,31.62,32.53,32.69,34.44,37.22,38.0,40.31,41.5,40.94,41.56,40.75,41.66,40.31,40.31,39.75,38.22,37.38,37.0,35.81,34.56,34.66,32.72,30.59,28.81,28.09,28.12,30.09,33.34,36.0,37.78,38.88,39.34,39.41,38.38,38.84,36.84,37.06,36.31,35.06,35.94,34.84,33.72,33.66,32.16,30.69,29.66,30.28,30.06,30.94,31.06,32.0,32.41,31.94,32.06,31.0,30.19,29.03,26.91,25.22,25.03,22.81,23.12,23.31,24.88,25.0,25.5,25.88,27.09,27.56,28.12,29.22,31.66,32.41,34.62,34.06,34.34,32.44,30.62,29.16,25.38,24.75,24.81,25.16,27.69,30.94,32.66,34.69,35.0,34.94,34.28,33.88,32.72,31.06,31.81,33.31,32.69,34.69,36.47,37.72,38.41,39.72,40.66,39.47,37.94,37.19,35.62,35.75,34.09,34.78,34.88,34.25,34.0,33.69,33.06,33.28,33.16,33.06,32.41,32.31,31.91,30.72,30.66,30.69,30.97,31.34,32.09,32.38,32.31,32.31,28.69,30.84,28.12,27.5,27.53,26.5,26.28,25.66,24.97,23.59,23.66,23.59,22.31,23.28,23.28,24.12,26.41,26.62,27.34,28.41,27.31,27.12,26.28,27.84,29.44,31.12,35.44,37.44,39.97,40.06,41.22,40.28,41.56,40.31,40.84,41.41,43.62,42.12,42.56,41.62,39.03,37.44,36.06,35.0,34.06,34.16,33.03,32.94,31.84,30.72,30.19,29.19,28.0,26.94,27.72,27.5,29.81,30.34,30.44,31.44,30.31,30.12,29.84,29.5,28.22,28.31,26.69,27.53,26.41,28.62,29.41,31.09,32.59,33.53,32.81,33.09,33.16,34.72,35.31,35.38,34.78,37.91,38.31,39.12,40.62,39.62,37.78,35.56,33.19,31.81,31.12,30.28,30.16,29.31,28.41,28.03,28.81,29.94,31.09,34.0,36.84,39.25,39.38,41.25,40.31,38.44,39.41,38.16,37.69,38.88,37.44,37.56,36.25,35.62,34.53,31.91,29.75,27.31,26.06,25.12,26.03,25.69,26.19,24.31,25.53,24.25,24.78,26.75,27.56,29.44,31.81,32.5,34.75,37.38,38.0,38.5,38.19,37.56,36.12,34.97,33.16,29.62,26.94,23.25,21.62,19.66,18.66,18.47,19.28,18.66,18.0,18.5,17.69,15.75,15.72,15.94,15.38,16.81,18.19,19.28,20.38,19.81,19.97,20.19,19.16,19.72,18.91,19.19,19.38,19.22,19.81,19.81,19.94,20.34,19.69,20.06,20.59,20.88,21.53,22.06,22.19,21.56,23.03,22.03,21.53,22.12,23.12,23.19,24.75,25.25,24.81,25.0,23.56,23.09,22.31,25.03,25.25,25.56,25.06,23.22,20.59,18.16,16.69,14.41,14.38,13.72,13.34,14.53,15.31,16.84,18.41,18.16,18.66,17.06,16.62,15.06,13.69,10.66,9.34,6.81,4.5,2.91,3.31,5.31,8.59,13.12,18.12,23.0,25.19,27.81,29.97,28.81,29.72,29.69,30.5,29.41,31.28,30.25,29.19,27.31,24.5,21.47,16.62,16.22,15.59,15.31,18.72,20.75,22.56,23.53,23.56,23.53,21.66,19.75,17.66,17.97,16.84,17.44,17.97,19.19,19.94,20.62,21.78,21.53,22.62,23.78,24.31,23.94,22.84,21.84,22.62,21.5,23.69,24.53,25.78,27.03,26.78,28.94:32.19,36.81,40.16,43.38,43.78,44.84,43.66,41.22,39.69,37.44,34.97,33.0,30.72,31.81,31.69,34.94,35.81,36.94,39.09,39.53,40.59,41.0,41.44,42.78,42.69,42.88,43.44,43.81,44.44,45.5,46.34,45.69,48.16,48.56,48.28,48.47,48.0,47.34,47.19,45.84,45.41,43.41,43.94,42.56,42.0,39.06,41.66,40.47,41.06,41.75,41.03,40.88,39.12,36.0,34.62,32.44,32.0,30.84,28.78,27.84,24.0,21.88,19.78,19.41,20.78,23.06,25.53,28.19,29.75,31.38,32.41,32.16,31.91,31.22,30.16,27.88,26.44,24.62,23.03,21.59,21.72,22.81,25.0,24.94,27.09,26.53,25.38,24.41,22.62,23.16,22.28,21.25,21.09,18.22,15.94,16.19,15.44,19.25,21.62,24.41,25.09,25.28,23.94,23.44,21.91,21.06,20.22,18.5,17.5,17.16,16.19,16.62,18.34,20.12,21.34,23.75,26.44,28.38,30.38,32.72,32.75,31.16,29.28,28.56,25.16,24.66,24.81,24.75,26.22,26.41,26.41,25.5,23.44,23.25,21.72,20.59,22.72,22.19,25.16,27.31,29.25,32.78,32.84,34.19,33.62,31.66,30.44,26.72,25.75,23.19,21.16,19.91,18.28,18.78,18.75,19.78,20.25,21.38,18.62,20.59,22.31,26.03,30.38,35.25,37.12,37.31,35.44,31.56,29.44,28.19,27.22,26.81,26.41,25.69,23.53,22.06,21.81,21.88,21.97,23.09,24.56,25.16,26.44,27.06,29.34,31.0,32.06,32.16,32.19,28.56,28.06,26.03,24.88,25.84,26.5,26.97,26.34,22.78,21.5,18.94,16.59,17.06,16.88,17.44,18.78,19.53,21.59,22.06,23.91,25.56,25.94,27.78,26.81,27.16,28.5,28.88,29.94,32.5,36.5,38.19,41.16,42.12,40.66,36.12,34.12,31.09,29.28,30.34,33.56,36.53,37.5,38.94,39.91,38.03,36.66,34.25,34.44,33.81,33.41,32.56,31.88,29.91,27.97,25.53,25.69,24.41,24.38,23.28,22.72,22.47,22.0,23.19,24.09,25.78,26.84,26.16,26.69,26.0,25.41,24.97,25.5,27.0,27.12,28.38,29.06,30.53,29.19,31.38,33.41,34.06,36.0,36.38,37.66,39.62,41.25,43.44,44.0,44.75,44.44,41.75,40.62,37.59,36.56,36.41,35.31,38.06,39.78,40.25,40.44,39.31,38.34,35.72,32.94,30.31,27.25,25.81,25.97,27.56,29.41,32.94,34.31,35.0,35.44,34.41,34.69,35.16,34.56,34.62,34.75,34.19,33.84,31.91,29.94,27.94,25.03,22.19,20.41,19.06,18.56,18.59,19.41,21.03,23.69,26.38,28.16,29.44,30.0,28.56,25.62,23.88,21.03,17.44,15.03,13.41,11.81,12.44,13.56,16.03,18.03,20.84,25.41,27.16,29.81,33.47,34.56,35.62,37.38,37.59,39.0,40.25,41.16,41.44,41.72,42.22,42.62,42.16,42.56,42.62,41.81,40.56,39.12,37.69,36.91,37.06,36.88,39.25,38.25,38.5,37.81,34.75,33.06,31.56,29.72,28.56,26.41,26.41,25.41,24.84,25.34,25.47,25.56,25.5,26.5,28.09,29.12,31.62,32.12,33.97,34.03,35.78,34.59,32.94,32.59,30.12,28.91,29.28,29.0,30.31,31.75,32.81,32.31,31.25,29.66,27.66,27.03,26.72,28.16,30.03,31.66,34.19,35.44,35.53,35.91,36.31,33.88,33.53,31.19,27.59,25.47,23.06,19.84,22.59,22.09,23.69,26.0,26.75,27.62,27.81,27.0,26.84,25.28,24.78,24.81,25.0,25.47,27.62,27.78,29.09,31.34,33.0,34.72,38.31,41.0,41.78,41.91,42.5,39.91,36.91,34.78,33.38,33.59,33.0,34.0,33.81,33.16,33.22,32.41,32.84,32.69,35.62,36.84,38.69,41.19,42.31,42.94,41.44,40.0,37.47,34.31,31.81,31.0,30.31,30.75,31.19,30.94,30.94,31.56,32.12,31.72,32.69,32.16,32.06,31.47,31.62,32.53,32.69,34.44,37.22,38.0,40.31,41.5,40.94,41.56,40.75,41.66,40.31,40.31,39.75,38.22,37.38,37.0,35.81,34.56,34.66,32.72,30.59,28.81,28.09,28.12,30.09,33.34,36.0,37.78,38.88,39.34,39.41,38.38,38.84,36.84,37.06,36.31,35.06,35.94,34.84,33.72,33.66,32.16,30.69,29.66,30.28,30.06,30.94,31.06,32.0,32.41,31.94,32.06,31.0,30.19,29.03,26.91,25.22,25.03,22.81,23.12,23.31,24.88,25.0,25.5,25.88,27.09,27.56,28.12,29.22,31.66,32.41,34.62,34.06,34.34,32.44,30.62,29.16,25.38,24.75,24.81,25.16,27.69,30.94,32.66,34.69,35.0,34.94,34.28,33.88,32.72,31.06,31.81,33.31,32.69,34.69,36.47,37.72,38.41,39.72,40.66,39.47,37.94,37.19,35.62,35.75,34.09,34.78,34.88,34.25,34.0,33.69,33.06,33.28,33.16,33.06,32.41,32.31,31.91,30.72,30.66,30.69,30.97,31.34,32.09,32.38,32.31,32.31,28.69,30.84,28.12,27.5,27.53,26.5,26.28,25.66,24.97,23.59,23.66,23.59,22.31,23.28,23.28,24.12,26.41,26.62,27.34,28.41,27.31,27.12,26.28,27.84,29.44,31.12,35.44,37.44,39.97,40.06,41.22,40.28,41.56,40.31,40.84,41.41,43.62,42.12,42.56,41.62,39.03,37.44,36.06,35.0,34.06,34.16,33.03,32.94,31.84,30.72,30.19,29.19,28.0,26.94,27.72,27.5,29.81,30.34,30.44,31.44,30.31,30.12,29.84,29.5,28.22,28.31,26.69,27.53,26.41,28.62,29.41,31.09,32.59,33.53,32.81,33.09,33.16,34.72,35.31,35.38,34.78,37.91,38.31,39.12,40.62,39.62,37.78,35.56,33.19,31.81,31.12,30.28,30.16,29.31,28.41,28.03,28.81,29.94,31.09,34.0,36.84,39.25,39.38,41.25,40.31,38.44,39.41,38.16,37.69,38.88,37.44,37.56,36.25,35.62,34.53,31.91,29.75,27.31,26.06,25.12,26.03,25.69,26.19,24.31,25.53,24.25,24.78,26.75,27.56,29.44,31.81,32.5,34.75,37.38,38.0,38.5,38.19,37.56,36.12,34.97,33.16,29.62,26.94,23.25,21.62,19.66,18.66,18.47,19.28,18.66,18.0,18.5,17.69,15.75,15.72,15.94,15.38,16.81,18.19,19.28,20.38,19.81,19.97,20.19,19.16,19.72,18.91,19.19,19.38,19.22,19.81,19.81,19.94,20.34,19.69,20.06,20.59,20.88,21.53,22.06,22.19,21.56,23.03,22.03,21.53,22.12,23.12,23.19,24.75,25.25,24.81,25.0,23.56,23.09,22.31,25.03,25.25,25.56,25.06,23.22,20.59,18.16,16.69,14.41,14.38,13.72,13.34,14.53,15.31,16.84,18.41,18.16,18.66,17.06,16.62,15.06,13.69,10.66,9.34,6.81,4.5,2.91,3.31,5.31,8.59,13.12,18.12,23.0,25.19,27.81,29.97,28.81,29.72,29.69,30.5,29.41,31.28,30.25,29.19,27.31,24.5,21.47,16.62,16.22,15.59,15.31,18.72,20.75,22.56,23.53,23.56,23.53,21.66,19.75,17.66,17.97,16.84,17.44,17.97,19.19,19.94,20.62,21.78,21.53,22.62,23.78,24.31,23.94,22.84,21.84,22.62,21.5,23.69,24.53,25.78,27.03,26.78,28.94,29.41,30.72,31.44,32.5,34.53,37.12:43.66,41.22,39.69,37.44,34.97,33.0,30.72,31.81,31.69,34.94,35.81,36.94,39.09,39.53,40.59,41.0,41.44,42.78,42.69,42.88,43.44,43.81,44.44,45.5,46.34,45.69,48.16,48.56,48.28,48.47,48.0,47.34,47.19,45.84,45.41,43.41,43.94,42.56,42.0,39.06,41.66,40.47,41.06,41.75,41.03,40.88,39.12,36.0,34.62,32.44,32.0,30.84,28.78,27.84,24.0,21.88,19.78,19.41,20.78,23.06,25.53,28.19,29.75,31.38,32.41,32.16,31.91,31.22,30.16,27.88,26.44,24.62,23.03,21.59,21.72,22.81,25.0,24.94,27.09,26.53,25.38,24.41,22.62,23.16,22.28,21.25,21.09,18.22,15.94,16.19,15.44,19.25,21.62,24.41,25.09,25.28,23.94,23.44,21.91,21.06,20.22,18.5,17.5,17.16,16.19,16.62,18.34,20.12,21.34,23.75,26.44,28.38,30.38,32.72,32.75,31.16,29.28,28.56,25.16,24.66,24.81,24.75,26.22,26.41,26.41,25.5,23.44,23.25,21.72,20.59,22.72,22.19,25.16,27.31,29.25,32.78,32.84,34.19,33.62,31.66,30.44,26.72,25.75,23.19,21.16,19.91,18.28,18.78,18.75,19.78,20.25,21.38,18.62,20.59,22.31,26.03,30.38,35.25,37.12,37.31,35.44,31.56,29.44,28.19,27.22,26.81,26.41,25.69,23.53,22.06,21.81,21.88,21.97,23.09,24.56,25.16,26.44,27.06,29.34,31.0,32.06,32.16,32.19,28.56,28.06,26.03,24.88,25.84,26.5,26.97,26.34,22.78,21.5,18.94,16.59,17.06,16.88,17.44,18.78,19.53,21.59,22.06,23.91,25.56,25.94,27.78,26.81,27.16,28.5,28.88,29.94,32.5,36.5,38.19,41.16,42.12,40.66,36.12,34.12,31.09,29.28,30.34,33.56,36.53,37.5,38.94,39.91,38.03,36.66,34.25,34.44,33.81,33.41,32.56,31.88,29.91,27.97,25.53,25.69,24.41,24.38,23.28,22.72,22.47,22.0,23.19,24.09,25.78,26.84,26.16,26.69,26.0,25.41,24.97,25.5,27.0,27.12,28.38,29.06,30.53,29.19,31.38,33.41,34.06,36.0,36.38,37.66,39.62,41.25,43.44,44.0,44.75,44.44,41.75,40.62,37.59,36.56,36.41,35.31,38.06,39.78,40.25,40.44,39.31,38.34,35.72,32.94,30.31,27.25,25.81,25.97,27.56,29.41,32.94,34.31,35.0,35.44,34.41,34.69,35.16,34.56,34.62,34.75,34.19,33.84,31.91,29.94,27.94,25.03,22.19,20.41,19.06,18.56,18.59,19.41,21.03,23.69,26.38,28.16,29.44,30.0,28.56,25.62,23.88,21.03,17.44,15.03,13.41,11.81,12.44,13.56,16.03,18.03,20.84,25.41,27.16,29.81,33.47,34.56,35.62,37.38,37.59,39.0,40.25,41.16,41.44,41.72,42.22,42.62,42.16,42.56,42.62,41.81,40.56,39.12,37.69,36.91,37.06,36.88,39.25,38.25,38.5,37.81,34.75,33.06,31.56,29.72,28.56,26.41,26.41,25.41,24.84,25.34,25.47,25.56,25.5,26.5,28.09,29.12,31.62,32.12,33.97,34.03,35.78,34.59,32.94,32.59,30.12,28.91,29.28,29.0,30.31,31.75,32.81,32.31,31.25,29.66,27.66,27.03,26.72,28.16,30.03,31.66,34.19,35.44,35.53,35.91,36.31,33.88,33.53,31.19,27.59,25.47,23.06,19.84,22.59,22.09,23.69,26.0,26.75,27.62,27.81,27.0,26.84,25.28,24.78,24.81,25.0,25.47,27.62,27.78,29.09,31.34,33.0,34.72,38.31,41.0,41.78,41.91,42.5,39.91,36.91,34.78,33.38,33.59,33.0,34.0,33.81,33.16,33.22,32.41,32.84,32.69,35.62,36.84,38.69,41.19,42.31,42.94,41.44,40.0,37.47,34.31,31.81,31.0,30.31,30.75,31.19,30.94,30.94,31.56,32.12,31.72,32.69,32.16,32.06,31.47,31.62,32.53,32.69,34.44,37.22,38.0,40.31,41.5,40.94,41.56,40.75,41.66,40.31,40.31,39.75,38.22,37.38,37.0,35.81,34.56,34.66,32.72,30.59,28.81,28.09,28.12,30.09,33.34,36.0,37.78,38.88,39.34,39.41,38.38,38.84,36.84,37.06,36.31,35.06,35.94,34.84,33.72,33.66,32.16,30.69,29.66,30.28,30.06,30.94,31.06,32.0,32.41,31.94,32.06,31.0,30.19,29.03,26.91,25.22,25.03,22.81,23.12,23.31,24.88,25.0,25.5,25.88,27.09,27.56,28.12,29.22,31.66,32.41,34.62,34.06,34.34,32.44,30.62,29.16,25.38,24.75,24.81,25.16,27.69,30.94,32.66,34.69,35.0,34.94,34.28,33.88,32.72,31.06,31.81,33.31,32.69,34.69,36.47,37.72,38.41,39.72,40.66,39.47,37.94,37.19,35.62,35.75,34.09,34.78,34.88,34.25,34.0,33.69,33.06,33.28,33.16,33.06,32.41,32.31,31.91,30.72,30.66,30.69,30.97,31.34,32.09,32.38,32.31,32.31,28.69,30.84,28.12,27.5,27.53,26.5,26.28,25.66,24.97,23.59,23.66,23.59,22.31,23.28,23.28,24.12,26.41,26.62,27.34,28.41,27.31,27.12,26.28,27.84,29.44,31.12,35.44,37.44,39.97,40.06,41.22,40.28,41.56,40.31,40.84,41.41,43.62,42.12,42.56,41.62,39.03,37.44,36.06,35.0,34.06,34.16,33.03,32.94,31.84,30.72,30.19,29.19,28.0,26.94,27.72,27.5,29.81,30.34,30.44,31.44,30.31,30.12,29.84,29.5,28.22,28.31,26.69,27.53,26.41,28.62,29.41,31.09,32.59,33.53,32.81,33.09,33.16,34.72,35.31,35.38,34.78,37.91,38.31,39.12,40.62,39.62,37.78,35.56,33.19,31.81,31.12,30.28,30.16,29.31,28.41,28.03,28.81,29.94,31.09,34.0,36.84,39.25,39.38,41.25,40.31,38.44,39.41,38.16,37.69,38.88,37.44,37.56,36.25,35.62,34.53,31.91,29.75,27.31,26.06,25.12,26.03,25.69,26.19,24.31,25.53,24.25,24.78,26.75,27.56,29.44,31.81,32.5,34.75,37.38,38.0,38.5,38.19,37.56,36.12,34.97,33.16,29.62,26.94,23.25,21.62,19.66,18.66,18.47,19.28,18.66,18.0,18.5,17.69,15.75,15.72,15.94,15.38,16.81,18.19,19.28,20.38,19.81,19.97,20.19,19.16,19.72,18.91,19.19,19.38,19.22,19.81,19.81,19.94,20.34,19.69,20.06,20.59,20.88,21.53,22.06,22.19,21.56,23.03,22.03,21.53,22.12,23.12,23.19,24.75,25.25,24.81,25.0,23.56,23.09,22.31,25.03,25.25,25.56,25.06,23.22,20.59,18.16,16.69,14.41,14.38,13.72,13.34,14.53,15.31,16.84,18.41,18.16,18.66,17.06,16.62,15.06,13.69,10.66,9.34,6.81,4.5,2.91,3.31,5.31,8.59,13.12,18.12,23.0,25.19,27.81,29.97,28.81,29.72,29.69,30.5,29.41,31.28,30.25,29.19,27.31,24.5,21.47,16.62,16.22,15.59,15.31,18.72,20.75,22.56,23.53,23.56,23.53,21.66,19.75,17.66,17.97,16.84,17.44,17.97,19.19,19.94,20.62,21.78,21.53,22.62,23.78,24.31,23.94,22.84,21.84,22.62,21.5,23.69,24.53,25.78,27.03,26.78,28.94,29.41,30.72,31.44,32.5,34.53,37.12,41.06,43.78,47.69,50.06,50.84,50.75:30.72,31.81,31.69,34.94,35.81,36.94,39.09,39.53,40.59,41.0,41.44,42.78,42.69,42.88,43.44,43.81,44.44,45.5,46.34,45.69,48.16,48.56,48.28,48.47,48.0,47.34,47.19,45.84,45.41,43.41,43.94,42.56,42.0,39.06,41.66,40.47,41.06,41.75,41.03,40.88,39.12,36.0,34.62,32.44,32.0,30.84,28.78,27.84,24.0,21.88,19.78,19.41,20.78,23.06,25.53,28.19,29.75,31.38,32.41,32.16,31.91,31.22,30.16,27.88,26.44,24.62,23.03,21.59,21.72,22.81,25.0,24.94,27.09,26.53,25.38,24.41,22.62,23.16,22.28,21.25,21.09,18.22,15.94,16.19,15.44,19.25,21.62,24.41,25.09,25.28,23.94,23.44,21.91,21.06,20.22,18.5,17.5,17.16,16.19,16.62,18.34,20.12,21.34,23.75,26.44,28.38,30.38,32.72,32.75,31.16,29.28,28.56,25.16,24.66,24.81,24.75,26.22,26.41,26.41,25.5,23.44,23.25,21.72,20.59,22.72,22.19,25.16,27.31,29.25,32.78,32.84,34.19,33.62,31.66,30.44,26.72,25.75,23.19,21.16,19.91,18.28,18.78,18.75,19.78,20.25,21.38,18.62,20.59,22.31,26.03,30.38,35.25,37.12,37.31,35.44,31.56,29.44,28.19,27.22,26.81,26.41,25.69,23.53,22.06,21.81,21.88,21.97,23.09,24.56,25.16,26.44,27.06,29.34,31.0,32.06,32.16,32.19,28.56,28.06,26.03,24.88,25.84,26.5,26.97,26.34,22.78,21.5,18.94,16.59,17.06,16.88,17.44,18.78,19.53,21.59,22.06,23.91,25.56,25.94,27.78,26.81,27.16,28.5,28.88,29.94,32.5,36.5,38.19,41.16,42.12,40.66,36.12,34.12,31.09,29.28,30.34,33.56,36.53,37.5,38.94,39.91,38.03,36.66,34.25,34.44,33.81,33.41,32.56,31.88,29.91,27.97,25.53,25.69,24.41,24.38,23.28,22.72,22.47,22.0,23.19,24.09,25.78,26.84,26.16,26.69,26.0,25.41,24.97,25.5,27.0,27.12,28.38,29.06,30.53,29.19,31.38,33.41,34.06,36.0,36.38,37.66,39.62,41.25,43.44,44.0,44.75,44.44,41.75,40.62,37.59,36.56,36.41,35.31,38.06,39.78,40.25,40.44,39.31,38.34,35.72,32.94,30.31,27.25,25.81,25.97,27.56,29.41,32.94,34.31,35.0,35.44,34.41,34.69,35.16,34.56,34.62,34.75,34.19,33.84,31.91,29.94,27.94,25.03,22.19,20.41,19.06,18.56,18.59,19.41,21.03,23.69,26.38,28.16,29.44,30.0,28.56,25.62,23.88,21.03,17.44,15.03,13.41,11.81,12.44,13.56,16.03,18.03,20.84,25.41,27.16,29.81,33.47,34.56,35.62,37.38,37.59,39.0,40.25,41.16,41.44,41.72,42.22,42.62,42.16,42.56,42.62,41.81,40.56,39.12,37.69,36.91,37.06,36.88,39.25,38.25,38.5,37.81,34.75,33.06,31.56,29.72,28.56,26.41,26.41,25.41,24.84,25.34,25.47,25.56,25.5,26.5,28.09,29.12,31.62,32.12,33.97,34.03,35.78,34.59,32.94,32.59,30.12,28.91,29.28,29.0,30.31,31.75,32.81,32.31,31.25,29.66,27.66,27.03,26.72,28.16,30.03,31.66,34.19,35.44,35.53,35.91,36.31,33.88,33.53,31.19,27.59,25.47,23.06,19.84,22.59,22.09,23.69,26.0,26.75,27.62,27.81,27.0,26.84,25.28,24.78,24.81,25.0,25.47,27.62,27.78,29.09,31.34,33.0,34.72,38.31,41.0,41.78,41.91,42.5,39.91,36.91,34.78,33.38,33.59,33.0,34.0,33.81,33.16,33.22,32.41,32.84,32.69,35.62,36.84,38.69,41.19,42.31,42.94,41.44,40.0,37.47,34.31,31.81,31.0,30.31,30.75,31.19,30.94,30.94,31.56,32.12,31.72,32.69,32.16,32.06,31.47,31.62,32.53,32.69,34.44,37.22,38.0,40.31,41.5,40.94,41.56,40.75,41.66,40.31,40.31,39.75,38.22,37.38,37.0,35.81,34.56,34.66,32.72,30.59,28.81,28.09,28.12,30.09,33.34,36.0,37.78,38.88,39.34,39.41,38.38,38.84,36.84,37.06,36.31,35.06,35.94,34.84,33.72,33.66,32.16,30.69,29.66,30.28,30.06,30.94,31.06,32.0,32.41,31.94,32.06,31.0,30.19,29.03,26.91,25.22,25.03,22.81,23.12,23.31,24.88,25.0,25.5,25.88,27.09,27.56,28.12,29.22,31.66,32.41,34.62,34.06,34.34,32.44,30.62,29.16,25.38,24.75,24.81,25.16,27.69,30.94,32.66,34.69,35.0,34.94,34.28,33.88,32.72,31.06,31.81,33.31,32.69,34.69,36.47,37.72,38.41,39.72,40.66,39.47,37.94,37.19,35.62,35.75,34.09,34.78,34.88,34.25,34.0,33.69,33.06,33.28,33.16,33.06,32.41,32.31,31.91,30.72,30.66,30.69,30.97,31.34,32.09,32.38,32.31,32.31,28.69,30.84,28.12,27.5,27.53,26.5,26.28,25.66,24.97,23.59,23.66,23.59,22.31,23.28,23.28,24.12,26.41,26.62,27.34,28.41,27.31,27.12,26.28,27.84,29.44,31.12,35.44,37.44,39.97,40.06,41.22,40.28,41.56,40.31,40.84,41.41,43.62,42.12,42.56,41.62,39.03,37.44,36.06,35.0,34.06,34.16,33.03,32.94,31.84,30.72,30.19,29.19,28.0,26.94,27.72,27.5,29.81,30.34,30.44,31.44,30.31,30.12,29.84,29.5,28.22,28.31,26.69,27.53,26.41,28.62,29.41,31.09,32.59,33.53,32.81,33.09,33.16,34.72,35.31,35.38,34.78,37.91,38.31,39.12,40.62,39.62,37.78,35.56,33.19,31.81,31.12,30.28,30.16,29.31,28.41,28.03,28.81,29.94,31.09,34.0,36.84,39.25,39.38,41.25,40.31,38.44,39.41,38.16,37.69,38.88,37.44,37.56,36.25,35.62,34.53,31.91,29.75,27.31,26.06,25.12,26.03,25.69,26.19,24.31,25.53,24.25,24.78,26.75,27.56,29.44,31.81,32.5,34.75,37.38,38.0,38.5,38.19,37.56,36.12,34.97,33.16,29.62,26.94,23.25,21.62,19.66,18.66,18.47,19.28,18.66,18.0,18.5,17.69,15.75,15.72,15.94,15.38,16.81,18.19,19.28,20.38,19.81,19.97,20.19,19.16,19.72,18.91,19.19,19.38,19.22,19.81,19.81,19.94,20.34,19.69,20.06,20.59,20.88,21.53,22.06,22.19,21.56,23.03,22.03,21.53,22.12,23.12,23.19,24.75,25.25,24.81,25.0,23.56,23.09,22.31,25.03,25.25,25.56,25.06,23.22,20.59,18.16,16.69,14.41,14.38,13.72,13.34,14.53,15.31,16.84,18.41,18.16,18.66,17.06,16.62,15.06,13.69,10.66,9.34,6.81,4.5,2.91,3.31,5.31,8.59,13.12,18.12,23.0,25.19,27.81,29.97,28.81,29.72,29.69,30.5,29.41,31.28,30.25,29.19,27.31,24.5,21.47,16.62,16.22,15.59,15.31,18.72,20.75,22.56,23.53,23.56,23.53,21.66,19.75,17.66,17.97,16.84,17.44,17.97,19.19,19.94,20.62,21.78,21.53,22.62,23.78,24.31,23.94,22.84,21.84,22.62,21.5,23.69,24.53,25.78,27.03,26.78,28.94,29.41,30.72,31.44,32.5,34.53,37.12,41.06,43.78,47.69,50.06,50.84,50.75,50.53,48.44,46.81,44.69,43.69,41.88:39.09,39.53,40.59,41.0,41.44,42.78,42.69,42.88,43.44,43.81,44.44,45.5,46.34,45.69,48.16,48.56,48.28,48.47,48.0,47.34,47.19,45.84,45.41,43.41,43.94,42.56,42.0,39.06,41.66,40.47,41.06,41.75,41.03,40.88,39.12,36.0,34.62,32.44,32.0,30.84,28.78,27.84,24.0,21.88,19.78,19.41,20.78,23.06,25.53,28.19,29.75,31.38,32.41,32.16,31.91,31.22,30.16,27.88,26.44,24.62,23.03,21.59,21.72,22.81,25.0,24.94,27.09,26.53,25.38,24.41,22.62,23.16,22.28,21.25,21.09,18.22,15.94,16.19,15.44,19.25,21.62,24.41,25.09,25.28,23.94,23.44,21.91,21.06,20.22,18.5,17.5,17.16,16.19,16.62,18.34,20.12,21.34,23.75,26.44,28.38,30.38,32.72,32.75,31.16,29.28,28.56,25.16,24.66,24.81,24.75,26.22,26.41,26.41,25.5,23.44,23.25,21.72,20.59,22.72,22.19,25.16,27.31,29.25,32.78,32.84,34.19,33.62,31.66,30.44,26.72,25.75,23.19,21.16,19.91,18.28,18.78,18.75,19.78,20.25,21.38,18.62,20.59,22.31,26.03,30.38,35.25,37.12,37.31,35.44,31.56,29.44,28.19,27.22,26.81,26.41,25.69,23.53,22.06,21.81,21.88,21.97,23.09,24.56,25.16,26.44,27.06,29.34,31.0,32.06,32.16,32.19,28.56,28.06,26.03,24.88,25.84,26.5,26.97,26.34,22.78,21.5,18.94,16.59,17.06,16.88,17.44,18.78,19.53,21.59,22.06,23.91,25.56,25.94,27.78,26.81,27.16,28.5,28.88,29.94,32.5,36.5,38.19,41.16,42.12,40.66,36.12,34.12,31.09,29.28,30.34,33.56,36.53,37.5,38.94,39.91,38.03,36.66,34.25,34.44,33.81,33.41,32.56,31.88,29.91,27.97,25.53,25.69,24.41,24.38,23.28,22.72,22.47,22.0,23.19,24.09,25.78,26.84,26.16,26.69,26.0,25.41,24.97,25.5,27.0,27.12,28.38,29.06,30.53,29.19,31.38,33.41,34.06,36.0,36.38,37.66,39.62,41.25,43.44,44.0,44.75,44.44,41.75,40.62,37.59,36.56,36.41,35.31,38.06,39.78,40.25,40.44,39.31,38.34,35.72,32.94,30.31,27.25,25.81,25.97,27.56,29.41,32.94,34.31,35.0,35.44,34.41,34.69,35.16,34.56,34.62,34.75,34.19,33.84,31.91,29.94,27.94,25.03,22.19,20.41,19.06,18.56,18.59,19.41,21.03,23.69,26.38,28.16,29.44,30.0,28.56,25.62,23.88,21.03,17.44,15.03,13.41,11.81,12.44,13.56,16.03,18.03,20.84,25.41,27.16,29.81,33.47,34.56,35.62,37.38,37.59,39.0,40.25,41.16,41.44,41.72,42.22,42.62,42.16,42.56,42.62,41.81,40.56,39.12,37.69,36.91,37.06,36.88,39.25,38.25,38.5,37.81,34.75,33.06,31.56,29.72,28.56,26.41,26.41,25.41,24.84,25.34,25.47,25.56,25.5,26.5,28.09,29.12,31.62,32.12,33.97,34.03,35.78,34.59,32.94,32.59,30.12,28.91,29.28,29.0,30.31,31.75,32.81,32.31,31.25,29.66,27.66,27.03,26.72,28.16,30.03,31.66,34.19,35.44,35.53,35.91,36.31,33.88,33.53,31.19,27.59,25.47,23.06,19.84,22.59,22.09,23.69,26.0,26.75,27.62,27.81,27.0,26.84,25.28,24.78,24.81,25.0,25.47,27.62,27.78,29.09,31.34,33.0,34.72,38.31,41.0,41.78,41.91,42.5,39.91,36.91,34.78,33.38,33.59,33.0,34.0,33.81,33.16,33.22,32.41,32.84,32.69,35.62,36.84,38.69,41.19,42.31,42.94,41.44,40.0,37.47,34.31,31.81,31.0,30.31,30.75,31.19,30.94,30.94,31.56,32.12,31.72,32.69,32.16,32.06,31.47,31.62,32.53,32.69,34.44,37.22,38.0,40.31,41.5,40.94,41.56,40.75,41.66,40.31,40.31,39.75,38.22,37.38,37.0,35.81,34.56,34.66,32.72,30.59,28.81,28.09,28.12,30.09,33.34,36.0,37.78,38.88,39.34,39.41,38.38,38.84,36.84,37.06,36.31,35.06,35.94,34.84,33.72,33.66,32.16,30.69,29.66,30.28,30.06,30.94,31.06,32.0,32.41,31.94,32.06,31.0,30.19,29.03,26.91,25.22,25.03,22.81,23.12,23.31,24.88,25.0,25.5,25.88,27.09,27.56,28.12,29.22,31.66,32.41,34.62,34.06,34.34,32.44,30.62,29.16,25.38,24.75,24.81,25.16,27.69,30.94,32.66,34.69,35.0,34.94,34.28,33.88,32.72,31.06,31.81,33.31,32.69,34.69,36.47,37.72,38.41,39.72,40.66,39.47,37.94,37.19,35.62,35.75,34.09,34.78,34.88,34.25,34.0,33.69,33.06,33.28,33.16,33.06,32.41,32.31,31.91,30.72,30.66,30.69,30.97,31.34,32.09,32.38,32.31,32.31,28.69,30.84,28.12,27.5,27.53,26.5,26.28,25.66,24.97,23.59,23.66,23.59,22.31,23.28,23.28,24.12,26.41,26.62,27.34,28.41,27.31,27.12,26.28,27.84,29.44,31.12,35.44,37.44,39.97,40.06,41.22,40.28,41.56,40.31,40.84,41.41,43.62,42.12,42.56,41.62,39.03,37.44,36.06,35.0,34.06,34.16,33.03,32.94,31.84,30.72,30.19,29.19,28.0,26.94,27.72,27.5,29.81,30.34,30.44,31.44,30.31,30.12,29.84,29.5,28.22,28.31,26.69,27.53,26.41,28.62,29.41,31.09,32.59,33.53,32.81,33.09,33.16,34.72,35.31,35.38,34.78,37.91,38.31,39.12,40.62,39.62,37.78,35.56,33.19,31.81,31.12,30.28,30.16,29.31,28.41,28.03,28.81,29.94,31.09,34.0,36.84,39.25,39.38,41.25,40.31,38.44,39.41,38.16,37.69,38.88,37.44,37.56,36.25,35.62,34.53,31.91,29.75,27.31,26.06,25.12,26.03,25.69,26.19,24.31,25.53,24.25,24.78,26.75,27.56,29.44,31.81,32.5,34.75,37.38,38.0,38.5,38.19,37.56,36.12,34.97,33.16,29.62,26.94,23.25,21.62,19.66,18.66,18.47,19.28,18.66,18.0,18.5,17.69,15.75,15.72,15.94,15.38,16.81,18.19,19.28,20.38,19.81,19.97,20.19,19.16,19.72,18.91,19.19,19.38,19.22,19.81,19.81,19.94,20.34,19.69,20.06,20.59,20.88,21.53,22.06,22.19,21.56,23.03,22.03,21.53,22.12,23.12,23.19,24.75,25.25,24.81,25.0,23.56,23.09,22.31,25.03,25.25,25.56,25.06,23.22,20.59,18.16,16.69,14.41,14.38,13.72,13.34,14.53,15.31,16.84,18.41,18.16,18.66,17.06,16.62,15.06,13.69,10.66,9.34,6.81,4.5,2.91,3.31,5.31,8.59,13.12,18.12,23.0,25.19,27.81,29.97,28.81,29.72,29.69,30.5,29.41,31.28,30.25,29.19,27.31,24.5,21.47,16.62,16.22,15.59,15.31,18.72,20.75,22.56,23.53,23.56,23.53,21.66,19.75,17.66,17.97,16.84,17.44,17.97,19.19,19.94,20.62,21.78,21.53,22.62,23.78,24.31,23.94,22.84,21.84,22.62,21.5,23.69,24.53,25.78,27.03,26.78,28.94,29.41,30.72,31.44,32.5,34.53,37.12,41.06,43.78,47.69,50.06,50.84,50.75,50.53,48.44,46.81,44.69,43.69,41.88,40.91,41.19,40.69,44.03,44.75,46.19:negativity
29.62,29.0,28.66,28.5,27.62,27.12,27.19,27.56,27.91,28.94,29.59,29.56,27.94,26.19,23.94,20.66,19.62,19.28,19.38,20.66,22.78,25.56,27.94,32.75,35.44,38.81,40.41,40.25,38.5,35.66,32.25,30.16,29.44,29.81,31.62,34.16,33.97,34.03,33.0,31.19,30.5,29.16,29.47,29.78,30.53,31.03,31.97,32.81,34.5,35.31,36.0,35.38,35.31,34.06,32.72,32.44,30.59,29.97,30.19,30.16,29.22,28.91,28.25,27.66,26.97,26.62,27.56,26.47,26.81,26.69,25.75,25.28,23.72,22.75,19.28,16.78,14.06,13.22,13.56,16.31,19.94,24.81,28.75,32.12,35.34,36.84,38.12,38.81,39.28,39.09,39.91,39.97,40.94,42.03,43.12,44.25,44.03,45.12,43.56,43.84,43.16,42.59,41.06,40.09,39.03,37.88,37.53,36.53,37.12,36.94,36.53,35.22,34.19,31.97,30.88,29.97,28.88,29.03,29.94,29.97,30.84,31.03,30.19,30.25,28.62,29.41,29.81,30.5,33.66,34.53,35.47,36.59,36.5,35.97,35.5,35.19,34.44,33.78,33.62,32.25,31.91,31.56,32.31,32.16,33.56,34.09,35.62,35.12,36.84,36.97,38.44,40.06,40.66,42.34,41.97,42.69,42.91,41.66,41.66,40.75,40.62,39.75,39.88,39.16,39.19,38.38,38.94,39.06,39.03,39.38,39.66,39.5,38.56,37.88,36.97,34.5,33.34,32.0,30.5,29.41,28.5,27.66,26.97,27.81,28.94,29.44,31.06,31.41,31.12,30.38,28.97,28.09,28.12,28.12,28.88,29.91,31.44,33.75,34.94,36.22,37.0,38.0,37.19,37.31,38.59,38.81,39.03,40.75,40.72,41.19,40.94,40.34,38.75,36.91,35.06,34.47,34.03,36.41,38.12,41.22,43.09,45.31,45.16,43.53,42.12,38.06,34.97,32.09,30.44,28.75,29.03,28.62,30.16,29.81,29.78,29.28,27.91,26.62,25.53,25.0,25.28,26.19,28.34,30.75,31.19,31.19,31.88,30.38,29.41,28.0,26.19,24.72,24.09,24.19,26.94,30.59,35.31,39.09,44.12,45.12,44.72,44.19,41.19,39.19,37.94,37.12,37.28,37.47,38.28,36.75,37.59,37.16,36.88,36.78,36.56,36.25,36.69,36.88,38.41,39.59,39.5,39.69,38.94,39.41,39.53,39.81,40.78,40.56,40.78,41.34,41.09,41.62,42.66,41.12,41.41,40.25,38.44,39.03,38.84,38.84,38.94,38.66,38.47,38.0,38.56,40.25,41.25,41.66,42.5,42.22,41.12,39.44,39.66,38.84,39.5,39.66,40.66,41.06,40.62,40.31,40.81,39.44,39.16,39.16,39.25,39.44,40.06,42.5,44.47,46.28,47.78,48.94,49.66,49.75,50.28,49.19,47.47,44.81,42.19,38.22,35.81,32.19,30.03,28.44,26.88,27.16,28.09,28.62,30.75,31.34,32.53,32.69,34.72,35.0,36.66,38.88,40.06,41.81,41.56,40.72,40.06,39.0,36.34,35.84,34.28,33.09,31.88,31.41,30.19,30.5,30.53,30.56,30.97,31.03,31.16,32.06,34.91,37.25,39.91,43.31,43.44,43.31,40.75,38.25,34.09,31.06,28.53,26.31,24.84,24.0,22.28,22.47,21.53,21.62,22.88,24.28,25.91,27.84,29.28,30.31,31.69,33.94,34.91,36.88,39.06,38.25,38.84,38.19,36.84,36.16,34.5,33.38,32.5,31.41,31.0,30.53,31.47,32.03,32.66,32.66,33.28,33.25,32.59,32.06,33.19,33.56,34.06,35.56,35.41,35.12,34.44,32.75,33.19,32.56,33.44,33.84,34.25,34.34,33.81,33.38,32.81,31.12,30.88,29.44,28.25,27.41,26.25,26.66,27.72,29.84,31.81,34.81,37.16,38.34,38.31,38.25,38.25,37.19,38.84,40.16,41.81,43.84,44.84,45.44,45.31,44.06,42.66,42.09,40.16,40.06,40.0,39.62,39.84,40.56,39.78,39.41,38.5,38.31,38.94,39.5,40.28,40.25,40.56,39.34,37.12,35.81,33.75,32.19,31.56,31.78,31.94,33.81,35.19,37.62,39.94,41.31,41.28,41.94,42.31,41.56,40.53,41.06,39.84,38.5,37.88,38.06,38.12,38.66,39.69,40.91,41.72,42.91,42.19,41.5,42.41,40.41,40.03,41.28,39.59,41.12,40.78,40.31,40.69,40.38,40.94,42.16,42.59,44.5,45.19,45.62,46.59,46.84,47.31,46.75,47.56,46.81,46.41,44.5,41.81,39.25,36.41,34.53,32.94,32.94,34.47,35.12,36.38,39.56,41.41,43.94,46.16,46.22,47.03,44.03,40.94,38.91,34.56,32.53,31.56,31.25,32.12,32.78,35.44,36.62,37.03,39.03,39.06,39.25,38.5,37.44,37.12,34.22,34.75,34.75,35.25,36.81,39.5,40.41,40.84,41.5,40.19,39.56,38.81,37.44,36.25,36.34,35.31,34.5,34.06,33.56,32.38,31.41,30.62,29.81,28.31,28.56,28.25,26.81,26.25,25.28,23.97,24.22,23.78,24.94,26.78,28.41,29.78,30.81,31.25,32.31,31.53,32.19,32.62,32.62,32.53,31.5,31.56,30.0,28.88,28.94,28.34,28.5,29.31,30.44,32.19,33.34,34.62,35.81,35.5,35.38,34.59,35.06,35.78,36.12,36.31,36.75,35.31,35.03,34.03,34.19,33.22,33.44,35.12,33.31,34.09,32.31,31.62,30.56,30.84,31.22,31.97,33.19,34.78,34.69,35.66,36.22,36.69,36.56,37.31,39.25,41.75,42.69,45.31,47.34,48.25,47.94,47.12,45.72,42.97,38.94,36.56,34.03,31.5,31.38,29.41,29.69,29.44,27.78,28.56,27.72,27.69,27.91,28.91,29.56,30.19,30.16,29.84,28.91,27.59,26.84,25.91,26.84,26.66,27.47,27.78,27.56,28.06,28.0,28.06,28.56,28.44,28.72,29.0,29.19,29.25,29.47,29.19,30.38,31.59,32.84,32.84,32.03,30.56,28.88,27.03,26.94,27.81,28.94,31.72,34.69,36.66,39.0,39.81,38.75,37.47,35.81,32.09,31.31,29.97,28.97,31.03,32.25,34.09,36.5,38.81,40.69,42.12,43.66,44.88,45.16,46.16,46.72,46.78,44.44,41.81,37.78,32.0,27.78,24.06,22.81,23.06,24.75,26.94,29.53,31.19,32.94,34.72,35.88,36.5,39.25,39.66,40.47,40.44,39.47,37.84,36.31,34.53,33.53,32.31,31.44,30.25,29.88,27.97,27.91,27.25,27.25,28.28,28.41,29.38,29.16,29.16,28.66,27.69,27.75,27.81,28.19,28.88,29.5,29.81,30.62,32.25,33.38,33.91,33.84,33.47,32.38,31.03,30.56,29.5,29.81,30.31,30.69,31.0,31.41,32.09,31.22,31.62,32.66,33.59,34.38,36.03,36.28,35.16,34.56,32.75,30.31,28.88,27.72,27.47,26.31,27.16,28.62,28.78,30.78,32.03,33.31,35.62,35.88,36.94,37.0,35.62,34.94,34.12,32.06,30.44,28.47,27.38,24.94,24.44,24.72,24.47,23.59,25.12,25.5,25.81,27.91,29.25,31.19,31.69,32.31,32.16,32.25,32.28,31.41,30.31,29.41,26.88,25.59,23.81,22.56,24.06,24.94,27.06,28.88,30.59,32.0,33.44,34.16,34.47,34.5,33.91,32.66,31.5,30.66,29.44,28.16,26.28,25.72,25.44,25.16,25.75,25.91,27.44,28.16,27.84,29.69,31.38,34.41,38.34,42.38,44.81,45.56,44.69,42.09,38.0,34.97:27.19,27.56,27.91,28.94,29.59,29.56,27.94,26.19,23.94,20.66,19.62,19.28,19.38,20.66,22.78,25.56,27.94,32.75,35.44,38.81,40.41,40.25,38.5,35.66,32.25,30.16,29.44,29.81,31.62,34.16,33.97,34.03,33.0,31.19,30.5,29.16,29.47,29.78,30.53,31.03,31.97,32.81,34.5,35.31,36.0,35.38,35.31,34.06,32.72,32.44,30.59,29.97,30.19,30.16,29.22,28.91,28.25,27.66,26.97,26.62,27.56,26.47,26.81,26.69,25.75,25.28,23.72,22.75,19.28,16.78,14.06,13.22,13.56,16.31,19.94,24.81,28.75,32.12,35.34,36.84,38.12,38.81,39.28,39.09,39.91,39.97,40.94,42.03,43.12,44.25,44.03,45.12,43.56,43.84,43.16,42.59,41.06,40.09,39.03,37.88,37.53,36.53,37.12,36.94,36.53,35.22,34.19,31.97,30.88,29.97,28.88,29.03,29.94,29.97,30.84,31.03,30.19,30.25,28.62,29.41,29.81,30.5,33.66,34.53,35.47,36.59,36.5,35.97,35.5,35.19,34.44,33.78,33.62,32.25,31.91,31.56,32.31,32.16,33.56,34.09,35.62,35.12,36.84,36.97,38.44,40.06,40.66,42.34,41.97,42.69,42.91,41.66,41.66,40.75,40.62,39.75,39.88,39.16,39.19,38.38,38.94,39.06,39.03,39.38,39.66,39.5,38.56,37.88,36.97,34.5,33.34,32.0,30.5,29.41,28.5,27.66,26.97,27.81,28.94,29.44,31.06,31.41,31.12,30.38,28.97,28.09,28.12,28.12,28.88,29.91,31.44,33.75,34.94,36.22,37.0,38.0,37.19,37.31,38.59,38.81,39.03,40.75,40.72,41.19,40.94,40.34,38.75,36.91,35.06,34.47,34.03,36.41,38.12,41.22,43.09,45.31,45.16,43.53,42.12,38.06,34.97,32.09,30.44,28.75,29.03,28.62,30.16,29.81,29.78,29.28,27.91,26.62,25.53,25.0,25.28,26.19,28.34,30.75,31.19,31.19,31.88,30.38,29.41,28.0,26.19,24.72,24.09,24.19,26.94,30.59,35.31,39.09,44.12,45.12,44.72,44.19,41.19,39.19,37.94,37.12,37.28,37.47,38.28,36.75,37.59,37.16,36.88,36.78,36.56,36.25,36.69,36.88,38.41,39.59,39.5,39.69,38.94,39.41,39.53,39.81,40.78,40.56,40.78,41.34,41.09,41.62,42.66,41.12,41.41,40.25,38.44,39.03,38.84,38.84,38.94,38.66,38.47,38.0,38.56,40.25,41.25,41.66,42.5,42.22,41.12,39.44,39.66,38.84,39.5,39.66,40.66,41.06,40.62,40.31,40.81,39.44,39.16,39.16,39.25,39.44,40.06,42.5,44.47,46.28,47.78,48.94,49.66,49.75,50.28,49.19,47.47,44.81,42.19,38.22,35.81,32.19,30.03,28.44,26.88,27.16,28.09,28.62,30.75,31.34,32.53,32.69,34.72,35.0,36.66,38.88,40.06,41.81,41.56,40.72,40.06,39.0,36.34,35.84,34.28,33.09,31.88,31.41,30.19,30.5,30.53,30.56,30.97,31.03,31.16,32.06,34.91,37.25,39.91,43.31,43.44,43.31,40.75,38.25,34.09,31.06,28.53,26.31,24.84,24.0,22.28,22.47,21.53,21.62,22.88,24.28,25.91,27.84,29.28,30.31,31.69,33.94,34.91,36.88,39.06,38.25,38.84,38.19,36.84,36.16,34.5,33.38,32.5,31.41,31.0,30.53,31.47,32.03,32.66,32.66,33.28,33.25,32.59,32.06,33.19,33.56,34.06,35.56,35.41,35.12,34.44,32.75,33.19,32.56,33.44,33.84,34.25,34.34,33.81,33.38,32.81,31.12,30.88,29.44,28.25,27.41,26.25,26.66,27.72,29.84,31.81,34.81,37.16,38.34,38.31,38.25,38.25,37.19,38.84,40.16,41.81,43.84,44.84,45.44,45.31,44.06,42.66,42.09,40.16,40.06,40.0,39.62,39.84,40.56,39.78,39.41,38.5,38.31,38.94,39.5,40.28,40.25,40.56,39.34,37.12,35.81,33.75,32.19,31.56,31.78,31.94,33.81,35.19,37.62,39.94,41.31,41.28,41.94,42.31,41.56,40.53,41.06,39.84,38.5,37.88,38.06,38.12,38.66,39.69,40.91,41.72,42.91,42.19,41.5,42.41,40.41,40.03,41.28,39.59,41.12,40.78,40.31,40.69,40.38,40.94,42.16,42.59,44.5,45.19,45.62,46.59,46.84,47.31,46.75,47.56,46.81,46.41,44.5,41.81,39.25,36.41,34.53,32.94,32.94,34.47,35.12,36.38,39.56,41.41,43.94,46.16,46.22,47.03,44.03,40.94,38.91,34.56,32.53,31.56,31.25,32.12,32.78,35.44,36.62,37.03,39.03,39.06,39.25,38.5,37.44,37.12,34.22,34.75,34.75,35.25,36.81,39.5,40.41,40.84,41.5,40.19,39.56,38.81,37.44,36.25,36.34,35.31,34.5,34.06,33.56,32.38,31.41,30.62,29.81,28.31,28.56,28.25,26.81,26.25,25.28,23.97,24.22,23.78,24.94,26.78,28.41,29.78,30.81,31.25,32.31,31.53,32.19,32.62,32.62,32.53,31.5,31.56,30.0,28.88,28.94,28.34,28.5,29.31,30.44,32.19,33.34,34.62,35.81,35.5,35.38,34.59,35.06,35.78,36.12,36.31,36.75,35.31,35.03,34.03,34.19,33.22,33.44,35.12,33.31,34.09,32.31,31.62,30.56,30.84,31.22,31.97,33.19,34.78,34.69,35.66,36.22,36.69,36.56,37.31,39.25,41.75,42.69,45.31,47.34,48.25,47.94,47.12,45.72,42.97,38.94,36.56,34.03,31.5,31.38,29.41,29.69,29.44,27.78,28.56,27.72,27.69,27.91,28.91,29.56,30.19,30.16,29.84,28.91,27.59,26.84,25.91,26.84,26.66,27.47,27.78,27.56,28.06,28.0,28.06,28.56,28.44,28.72,29.0,29.19,29.25,29.47,29.19,30.38,31.59,32.84,32.84,32.03,30.56,28.88,27.03,26.94,27.81,28.94,31.72,34.69,36.66,39.0,39.81,38.75,37.47,35.81,32.09,31.31,29.97,28.97,31.03,32.25,34.09,36.5,38.81,40.69,42.12,43.66,44.88,45.16,46.16,46.72,46.78,44.44,41.81,37.78,32.0,27.78,24.06,22.81,23.06,24.75,26.94,29.53,31.19,32.94,34.72,35.88,36.5,39.25,39.66,40.47,40.44,39.47,37.84,36.31,34.53,33.53,32.31,31.44,30.25,29.88,27.97,27.91,27.25,27.25,28.28,28.41,29.38,29.16,29.16,28.66,27.69,27.75,27.81,28.19,28.88,29.5,29.81,30.62,32.25,33.38,33.91,33.84,33.47,32.38,31.03,30.56,29.5,29.81,30.31,30.69,31.0,31.41,32.09,31.22,31.62,32.66,33.59,34.38,36.03,36.28,35.16,34.56,32.75,30.31,28.88,27.72,27.47,26.31,27.16,28.62,28.78,30.78,32.03,33.31,35.62,35.88,36.94,37.0,35.62,34.94,34.12,32.06,30.44,28.47,27.38,24.94,24.44,24.72,24.47,23.59,25.12,25.5,25.81,27.91,29.25,31.19,31.69,32.31,32.16,32.25,32.28,31.41,30.31,29.41,26.88,25.59,23.81,22.56,24.06,24.94,27.06,28.88,30.59,32.0,33.44,34.16,34.47,34.5,33.91,32.66,31.5,30.66,29.44,28.16,26.28,25.72,25.44,25.16,25.75,25.91,27.44,28.16,27.84,29.69,31.38,34.41,38.34,42.38,44.81,45.56,44.69,42.09,38.0,34.97,-9.53,-10.81,-10.66,-10.78,-10.28,-9.03:27.94,26.19,23.94,20.66,19.62,19.28,19.38,20.66,22.78,25.56,27.94,32.75,35.44,38.81,40.41,40.25,38.5,35.66,32.25,30.16,29.44,29.81,31.62,34.16,33.97,34.03,33.0,31.19,30.5,29.16,29.47,29.78,30.53,31.03,31.97,32.81,34.5,35.31,36.0,35.38,35.31,34.06,32.72,32.44,30.59,29.97,30.19,30.16,29.22,28.91,28.25,27.66,26.97,26.62,27.56,26.47,26.81,26.69,25.75,25.28,23.72,22.75,19.28,16.78,14.06,13.22,13.56,16.31,19.94,24.81,28.75,32.12,35.34,36.84,38.12,38.81,39.28,39.09,39.91,39.97,40.94,42.03,43.12,44.25,44.03,45.12,43.56,43.84,43.16,42.59,41.06,40.09,39.03,37.88,37.53,36.53,37.12,36.94,36.53,35.22,34.19,31.97,30.88,29.97,28.88,29.03,29.94,29.97,30.84,31.03,30.19,30.25,28.62,29.41,29.81,30.5,33.66,34.53,35.47,36.59,36.5,35.97,35.5,35.19,34.44,33.78,33.62,32.25,31.91,31.56,32.31,32.16,33.56,34.09,35.62,35.12,36.84,36.97,38.44,40.06,40.66,42.34,41.97,42.69,42.91,41.66,41.66,40.75,40.62,39.75,39.88,39.16,39.19,38.38,38.94,39.06,39.03,39.38,39.66,39.5,38.56,37.88,36.97,34.5,33.34,32.0,30.5,29.41,28.5,27.66,26.97,27.81,28.94,29.44,31.06,31.41,31.12,30.38,28.97,28.09,28.12,28.12,28.88,29.91,31.44,33.75,34.94,36.22,37.0,38.0,37.19,37.31,38.59,38.81,39.03,40.75,40.72,41.19,40.94,40.34,38.75,36.91,35.06,34.47,34.03,36.41,38.12,41.22,43.09,45.31,45.16,43.53,42.12,38.06,34.97,32.09,30.44,28.75,29.03,28.62,30.16,29.81,29.78,29.28,27.91,26.62,25.53,25.0,25.28,26.19,28.34,30.75,31.19,31.19,31.88,30.38,29.41,28.0,26.19,24.72,24.09,24.19,26.94,30.59,35.31,39.09,44.12,45.12,44.72,44.19,41.19,39.19,37.94,37.12,37.28,37.47,38.28,36.75,37.59,37.16,36.88,36.78,36.56,36.25,36.69,36.88,38.41,39.59,39.5,39.69,38.94,39.41,39.53,39.81,40.78,40.56,40.78,41.34,41.09,41.62,42.66,41.12,41.41,40.25,38.44,39.03,38.84,38.84,38.94,38.66,38.47,38.0,38.56,40.25,41.25,41.66,42.5,42.22,41.12,39.44,39.66,38.84,39.5,39.66,40.66,41.06,40.62,40.31,40.81,39.44,39.16,39.16,39.25,39.44,40.06,42.5,44.47,46.28,47.78,48.94,49.66,49.75,50.28,49.19,47.47,44.81,42.19,38.22,35.81,32.19,30.03,28.44,26.88,27.16,28.09,28.62,30.75,31.34,32.53,32.69,34.72,35.0,36.66,38.88,40.06,41.81,41.56,40.72,40.06,39.0,36.34,35.84,34.28,33.09,31.88,31.41,30.19,30.5,30.53,30.56,30.97,31.03,31.16,32.06,34.91,37.25,39.91,43.31,43.44,43.31,40.75,38.25,34.09,31.06,28.53,26.31,24.84,24.0,22.28,22.47,21.53,21.62,22.88,24.28,25.91,27.84,29.28,30.31,31.69,33.94,34.91,36.88,39.06,38.25,38.84,38.19,36.84,36.16,34.5,33.38,32.5,31.41,31.0,30.53,31.47,32.03,32.66,32.66,33.28,33.25,32.59,32.06,33.19,33.56,34.06,35.56,35.41,35.12,34.44,32.75,33.19,32.56,33.44,33.84,34.25,34.34,33.81,33.38,32.81,31.12,30.88,29.44,28.25,27.41,26.25,26.66,27.72,29.84,31.81,34.81,37.16,38.34,38.31,38.25,38.25,37.19,38.84,40.16,41.81,43.84,44.84,45.44,45.31,44.06,42.66,42.09,40.16,40.06,40.0,39.62,39.84,40.56,39.78,39.41,38.5,38.31,38.94,39.5,40.28,40.25,40.56,39.34,37.12,35.81,33.75,32.19,31.56,31.78,31.94,33.81,35.19,37.62,39.94,41.31,41.28,41.94,42.31,41.56,40.53,41.06,39.84,38.5,37.88,38.06,38.12,38.66,39.69,40.91,41.72,42.91,42.19,41.5,42.41,40.41,40.03,41.28,39.59,41.12,40.78,40.31,40.69,40.38,40.94,42.16,42.59,44.5,45.19,45.62,46.59,46.84,47.31,46.75,47.56,46.81,46.41,44.5,41.81,39.25,36.41,34.53,32.94,32.94,34.47,35.12,36.38,39.56,41.41,43.94,46.16,46.22,47.03,44.03,40.94,38.91,34.56,32.53,31.56,31.25,32.12,32.78,35.44,36.62,37.03,39.03,39.06,39.25,38.5,37.44,37.12,34.22,34.75,34.75,35.25,36.81,39.5,40.41,40.84,41.5,40.19,39.56,38.81,37.44,36.25,36.34,35.31,34.5,34.06,33.56,32.38,31.41,30.62,29.81,28.31,28.56,28.25,26.81,26.25,25.28,23.97,24.22,23.78,24.94,26.78,28.41,29.78,30.81,31.25,32.31,31.53,32.19,32.62,32.62,32.53,31.5,31.56,30.0,28.88,28.94,28.34,28.5,29.31,30.44,32.19,33.34,34.62,35.81,35.5,35.38,34.59,35.06,35.78,36.12,36.31,36.75,35.31,35.03,34.03,34.19,33.22,33.44,35.12,33.31,34.09,32.31,31.62,30.56,30.84,31.22,31.97,33.19,34.78,34.69,35.66,36.22,36.69,36.56,37.31,39.25,41.75,42.69,45.31,47.34,48.25,47.94,47.12,45.72,42.97,38.94,36.56,34.03,31.5,31.38,29.41,29.69,29.44,27.78,28.56,27.72,27.69,27.91,28.91,29.56,30.19,30.16,29.84,28.91,27.59,26.84,25.91,26.84,26.66,27.47,27.78,27.56,28.06,28.0,28.06,28.56,28.44,28.72,29.0,29.19,29.25,29.47,29.19,30.38,31.59,32.84,32.84,32.03,30.56,28.88,27.03,26.94,27.81,28.94,31.72,34.69,36.66,39.0,39.81,38.75,37.47,35.81,32.09,31.31,29.97,28.97,31.03,32.25,34.09,36.5,38.81,40.69,42.12,43.66,44.88,45.16,46.16,46.72,46.78,44.44,41.81,37.78,32.0,27.78,24.06,22.81,23.06,24.75,26.94,29.53,31.19,32.94,34.72,35.88,36.5,39.25,39.66,40.47,40.44,39.47,37.84,36.31,34.53,33.53,32.31,31.44,30.25,29.88,27.97,27.91,27.25,27.25,28.28,28.41,29.38,29.16,29.16,28.66,27.69,27.75,27.81,28.19,28.88,29.5,29.81,30.62,32.25,33.38,33.91,33.84,33.47,32.38,31.03,30.56,29.5,29.81,30.31,30.69,31.0,31.41,32.09,31.22,31.62,32.66,33.59,34.38,36.03,36.28,35.16,34.56,32.75,30.31,28.88,27.72,27.47,26.31,27.16,28.62,28.78,30.78,32.03,33.31,35.62,35.88,36.94,37.0,35.62,34.94,34.12,32.06,30.44,28.47,27.38,24.94,24.44,24.72,24.47,23.59,25.12,25.5,25.81,27.91,29.25,31.19,31.69,32.31,32.16,32.25,32.28,31.41,30.31,29.41,26.88,25.59,23.81,22.56,24.06,24.94,27.06,28.88,30.59,32.0,33.44,34.16,34.47,34.5,33.91,32.66,31.5,30.66,29.44,28.16,26.28,25.72,25.44,25.16,25.75,25.91,27.44,28.16,27.84,29.69,31.38,34.41,38.34,42.38,44.81,45.56,44.69,42.09,38.0,34.97,-9.53,-10.81,-10.66,-10.78,-10.28,-9.03,-7.72,-6.84,-6.22,-3.97,-2.66,-2.38:19.38,20.66,22.78,25.56,27.94,32.75,35.44,38.81,40.41,40.25,38.5,35.66,32.25,30.16,29.44,29.81,31.62,34.16,33.97,34.03,33.0,31.19,30.5,29.16,29.47,29.78,30.53,31.03,31.97,32.81,34.5,35.31,36.0,35.38,35.31,34.06,32.72,32.44,30.59,29.97,30.19,30.16,29.22,28.91,28.25,27.66,26.97,26.62,27.56,26.47,26.81,26.69,25.75,25.28,23.72,22.75,19.28,16.78,14.06,13.22,13.56,16.31,19.94,24.81,28.75,32.12,35.34,36.84,38.12,38.81,39.28,39.09,39.91,39.97,40.94,42.03,43.12,44.25,44.03,45.12,43.56,43.84,43.16,42.59,41.06,40.09,39.03,37.88,37.53,36.53,37.12,36.94,36.53,35.22,34.19,31.97,30.88,29.97,28.88,29.03,29.94,29.97,30.84,31.03,30.19,30.25,28.62,29.41,29.81,30.5,33.66,34.53,35.47,36.59,36.5,35.97,35.5,35.19,34.44,33.78,33.62,32.25,31.91,31.56,32.31,32.16,33.56,34.09,35.62,35.12,36.84,36.97,38.44,40.06,40.66,42.34,41.97,42.69,42.91,41.66,41.66,40.75,40.62,39.75,39.88,39.16,39.19,38.38,38.94,39.06,39.03,39.38,39.66,39.5,38.56,37.88,36.97,34.5,33.34,32.0,30.5,29.41,28.5,27.66,26.97,27.81,28.94,29.44,31.06,31.41,31.12,30.38,28.97,28.09,28.12,28.12,28.88,29.91,31.44,33.75,34.94,36.22,37.0,38.0,37.19,37.31,38.59,38.81,39.03,40.75,40.72,41.19,40.94,40.34,38.75,36.91,35.06,34.47,34.03,36.41,38.12,41.22,43.09,45.31,45.16,43.53,42.12,38.06,34.97,32.09,30.44,28.75,29.03,28.62,30.16,29.81,29.78,29.28,27.91,26.62,25.53,25.0,25.28,26.19,28.34,30.75,31.19,31.19,31.88,30.38,29.41,28.0,26.19,24.72,24.09,24.19,26.94,30.59,35.31,39.09,44.12,45.12,44.72,44.19,41.19,39.19,37.94,37.12,37.28,37.47,38.28,36.75,37.59,37.16,36.88,36.78,36.56,36.25,36.69,36.88,38.41,39.59,39.5,39.69,38.94,39.41,39.53,39.81,40.78,40.56,40.78,41.34,41.09,41.62,42.66,41.12,41.41,40.25,38.44,39.03,38.84,38.84,38.94,38.66,38.47,38.0,38.56,40.25,41.25,41.66,42.5,42.22,41.12,39.44,39.66,38.84,39.5,39.66,40.66,41.06,40.62,40.31,40.81,39.44,39.16,39.16,39.25,39.44,40.06,42.5,44.47,46.28,47.78,48.94,49.66,49.75,50.28,49.19,47.47,44.81,42.19,38.22,35.81,32.19,30.03,28.44,26.88,27.16,28.09,28.62,30.75,31.34,32.53,32.69,34.72,35.0,36.66,38.88,40.06,41.81,41.56,40.72,40.06,39.0,36.34,35.84,34.28,33.09,31.88,31.41,30.19,30.5,30.53,30.56,30.97,31.03,31.16,32.06,34.91,37.25,39.91,43.31,43.44,43.31,40.75,38.25,34.09,31.06,28.53,26.31,24.84,24.0,22.28,22.47,21.53,21.62,22.88,24.28,25.91,27.84,29.28,30.31,31.69,33.94,34.91,36.88,39.06,38.25,38.84,38.19,36.84,36.16,34.5,33.38,32.5,31.41,31.0,30.53,31.47,32.03,32.66,32.66,33.28,33.25,32.59,32.06,33.19,33.56,34.06,35.56,35.41,35.12,34.44,32.75,33.19,32.56,33.44,33.84,34.25,34.34,33.81,33.38,32.81,31.12,30.88,29.44,28.25,27.41,26.25,26.66,27.72,29.84,31.81,34.81,37.16,38.34,38.31,38.25,38.25,37.19,38.84,40.16,41.81,43.84,44.84,45.44,45.31,44.06,42.66,42.09,40.16,40.06,40.0,39.62,39.84,40.56,39.78,39.41,38.5,38.31,38.94,39.5,40.28,40.25,40.56,39.34,37.12,35.81,33.75,32.19,31.56,31.78,31.94,33.81,35.19,37.62,39.94,41.31,41.28,41.94,42.31,41.56,40.53,41.06,39.84,38.5,37.88,38.06,38.12,38.66,39.69,40.91,41.72,42.91,42.19,41.5,42.41,40.41,40.03,41.28,39.59,41.12,40.78,40.31,40.69,40.38,40.94,42.16,42.59,44.5,45.19,45.62,46.59,46.84,47.31,46.75,47.56,46.81,46.41,44.5,41.81,39.25,36.41,34.53,32.94,32.94,34.47,35.12,36.38,39.56,41.41,43.94,46.16,46.22,47.03,44.03,40.94,38.91,34.56,32.53,31.56,31.25,32.12,32.78,35.44,36.62,37.03,39.03,39.06,39.25,38.5,37.44,37.12,34.22,34.75,34.75,35.25,36.81,39.5,40.41,40.84,41.5,40.19,39.56,38.81,37.44,36.25,36.34,35.31,34.5,34.06,33.56,32.38,31.41,30.62,29.81,28.31,28.56,28.25,26.81,26.25,25.28,23.97,24.22,23.78,24.94,26.78,28.41,29.78,30.81,31.25,32.31,31.53,32.19,32.62,32.62,32.53,31.5,31.56,30.0,28.88,28.94,28.34,28.5,29.31,30.44,32.19,33.34,34.62,35.81,35.5,35.38,34.59,35.06,35.78,36.12,36.31,36.75,35.31,35.03,34.03,34.19,33.22,33.44,35.12,33.31,34.09,32.31,31.62,30.56,30.84,31.22,31.97,33.19,34.78,34.69,35.66,36.22,36.69,36.56,37.31,39.25,41.75,42.69,45.31,47.34,48.25,47.94,47.12,45.72,42.97,38.94,36.56,34.03,31.5,31.38,29.41,29.69,29.44,27.78,28.56,27.72,27.69,27.91,28.91,29.56,30.19,30.16,29.84,28.91,27.59,26.84,25.91,26.84,26.66,27.47,27.78,27.56,28.06,28.0,28.06,28.56,28.44,28.72,29.0,29.19,29.25,29.47,29.19,30.38,31.59,32.84,32.84,32.03,30.56,28.88,27.03,26.94,27.81,28.94,31.72,34.69,36.66,39.0,39.81,38.75,37.47,35.81,32.09,31.31,29.97,28.97,31.03,32.25,34.09,36.5,38.81,40.69,42.12,43.66,44.88,45.16,46.16,46.72,46.78,44.44,41.81,37.78,32.0,27.78,24.06,22.81,23.06,24.75,26.94,29.53,31.19,32.94,34.72,35.88,36.5,39.25,39.66,40.47,40.44,39.47,37.84,36.31,34.53,33.53,32.31,31.44,30.25,29.88,27.97,27.91,27.25,27.25,28.28,28.41,29.38,29.16,29.16,28.66,27.69,27.75,27.81,28.19,28.88,29.5,29.81,30.62,32.25,33.38,33.91,33.84,33.47,32.38,31.03,30.56,29.5,29.81,30.31,30.69,31.0,31.41,32.09,31.22,31.62,32.66,33.59,34.38,36.03,36.28,35.16,34.56,32.75,30.31,28.88,27.72,27.47,26.31,27.16,28.62,28.78,30.78,32.03,33.31,35.62,35.88,36.94,37.0,35.62,34.94,34.12,32.06,30.44,28.47,27.38,24.94,24.44,24.72,24.47,23.59,25.12,25.5,25.81,27.91,29.25,31.19,31.69,32.31,32.16,32.25,32.28,31.41,30.31,29.41,26.88,25.59,23.81,22.56,24.06,24.94,27.06,28.88,30.59,32.0,33.44,34.16,34.47,34.5,33.91,32.66,31.5,30.66,29.44,28.16,26.28,25.72,25.44,25.16,25.75,25.91,27.44,28.16,27.84,29.69,31.38,34.41,38.34,42.38,44.81,45.56,44.69,42.09,38.0,34.97,-9.53,-10.81,-10.66,-10.78,-10.28,-9.03,-7.72,-6.84,-6.22,-3.97,-2.66,-2.38,-1.47,-2.22,-3.41,-4.84,-5.47,-5.78:35.44,38.81,40.41,40.25,38.5,35.66,32.25,30.16,29.44,29.81,31.62,34.16,33.97,34.03,33.0,31.19,30.5,29.16,29.47,29.78,30.53,31.03,31.97,32.81,34.5,35.31,36.0,35.38,35.31,34.06,32.72,32.44,30.59,29.97,30.19,30.16,29.22,28.91,28.25,27.66,26.97,26.62,27.56,26.47,26.81,26.69,25.75,25.28,23.72,22.75,19.28,16.78,14.06,13.22,13.56,16.31,19.94,24.81,28.75,32.12,35.34,36.84,38.12,38.81,39.28,39.09,39.91,39.97,40.94,42.03,43.12,44.25,44.03,45.12,43.56,43.84,43.16,42.59,41.06,40.09,39.03,37.88,37.53,36.53,37.12,36.94,36.53,35.22,34.19,31.97,30.88,29.97,28.88,29.03,29.94,29.97,30.84,31.03,30.19,30.25,28.62,29.41,29.81,30.5,33.66,34.53,35.47,36.59,36.5,35.97,35.5,35.19,34.44,33.78,33.62,32.25,31.91,31.56,32.31,32.16,33.56,34.09,35.62,35.12,36.84,36.97,38.44,40.06,40.66,42.34,41.97,42.69,42.91,41.66,41.66,40.75,40.62,39.75,39.88,39.16,39.19,38.38,38.94,39.06,39.03,39.38,39.66,39.5,38.56,37.88,36.97,34.5,33.34,32.0,30.5,29.41,28.5,27.66,26.97,27.81,28.94,29.44,31.06,31.41,31.12,30.38,28.97,28.09,28.12,28.12,28.88,29.91,31.44,33.75,34.94,36.22,37.0,38.0,37.19,37.31,38.59,38.81,39.03,40.75,40.72,41.19,40.94,40.34,38.75,36.91,35.06,34.47,34.03,36.41,38.12,41.22,43.09,45.31,45.16,43.53,42.12,38.06,34.97,32.09,30.44,28.75,29.03,28.62,30.16,29.81,29.78,29.28,27.91,26.62,25.53,25.0,25.28,26.19,28.34,30.75,31.19,31.19,31.88,30.38,29.41,28.0,26.19,24.72,24.09,24.19,26.94,30.59,35.31,39.09,44.12,45.12,44.72,44.19,41.19,39.19,37.94,37.12,37.28,37.47,38.28,36.75,37.59,37.16,36.88,36.78,36.56,36.25,36.69,36.88,38.41,39.59,39.5,39.69,38.94,39.41,39.53,39.81,40.78,40.56,40.78,41.34,41.09,41.62,42.66,41.12,41.41,40.25,38.44,39.03,38.84,38.84,38.94,38.66,38.47,38.0,38.56,40.25,41.25,41.66,42.5,42.22,41.12,39.44,39.66,38.84,39.5,39.66,40.66,41.06,40.62,40.31,40.81,39.44,39.16,39.16,39.25,39.44,40.06,42.5,44.47,46.28,47.78,48.94,49.66,49.75,50.28,49.19,47.47,44.81,42.19,38.22,35.81,32.19,30.03,28.44,26.88,27.16,28.09,28.62,30.75,31.34,32.53,32.69,34.72,35.0,36.66,38.88,40.06,41.81,41.56,40.72,40.06,39.0,36.34,35.84,34.28,33.09,31.88,31.41,30.19,30.5,30.53,30.56,30.97,31.03,31.16,32.06,34.91,37.25,39.91,43.31,43.44,43.31,40.75,38.25,34.09,31.06,28.53,26.31,24.84,24.0,22.28,22.47,21.53,21.62,22.88,24.28,25.91,27.84,29.28,30.31,31.69,33.94,34.91,36.88,39.06,38.25,38.84,38.19,36.84,36.16,34.5,33.38,32.5,31.41,31.0,30.53,31.47,32.03,32.66,32.66,33.28,33.25,32.59,32.06,33.19,33.56,34.06,35.56,35.41,35.12,34.44,32.75,33.19,32.56,33.44,33.84,34.25,34.34,33.81,33.38,32.81,31.12,30.88,29.44,28.25,27.41,26.25,26.66,27.72,29.84,31.81,34.81,37.16,38.34,38.31,38.25,38.25,37.19,38.84,40.16,41.81,43.84,44.84,45.44,45.31,44.06,42.66,42.09,40.16,40.06,40.0,39.62,39.84,40.56,39.78,39.41,38.5,38.31,38.94,39.5,40.28,40.25,40.56,39.34,37.12,35.81,33.75,32.19,31.56,31.78,31.94,33.81,35.19,37.62,39.94,41.31,41.28,41.94,42.31,41.56,40.53,41.06,39.84,38.5,37.88,38.06,38.12,38.66,39.69,40.91,41.72,42.91,42.19,41.5,42.41,40.41,40.03,41.28,39.59,41.12,40.78,40.31,40.69,40.38,40.94,42.16,42.59,44.5,45.19,45.62,46.59,46.84,47.31,46.75,47.56,46.81,46.41,44.5,41.81,39.25,36.41,34.53,32.94,32.94,34.47,35.12,36.38,39.56,41.41,43.94,46.16,46.22,47.03,44.03,40.94,38.91,34.56,32.53,31.56,31.25,32.12,32.78,35.44,36.62,37.03,39.03,39.06,39.25,38.5,37.44,37.12,34.22,34.75,34.75,35.25,36.81,39.5,40.41,40.84,41.5,40.19,39.56,38.81,37.44,36.25,36.34,35.31,34.5,34.06,33.56,32.38,31.41,30.62,29.81,28.31,28.56,28.25,26.81,26.25,25.28,23.97,24.22,23.78,24.94,26.78,28.41,29.78,30.81,31.25,32.31,31.53,32.19,32.62,32.62,32.53,31.5,31.56,30.0,28.88,28.94,28.34,28.5,29.31,30.44,32.19,33.34,34.62,35.81,35.5,35.38,34.59,35.06,35.78,36.12,36.31,36.75,35.31,35.03,34.03,34.19,33.22,33.44,35.12,33.31,34.09,32.31,31.62,30.56,30.84,31.22,31.97,33.19,34.78,34.69,35.66,36.22,36.69,36.56,37.31,39.25,41.75,42.69,45.31,47.34,48.25,47.94,47.12,45.72,42.97,38.94,36.56,34.03,31.5,31.38,29.41,29.69,29.44,27.78,28.56,27.72,27.69,27.91,28.91,29.56,30.19,30.16,29.84,28.91,27.59,26.84,25.91,26.84,26.66,27.47,27.78,27.56,28.06,28.0,28.06,28.56,28.44,28.72,29.0,29.19,29.25,29.47,29.19,30.38,31.59,32.84,32.84,32.03,30.56,28.88,27.03,26.94,27.81,28.94,31.72,34.69,36.66,39.0,39.81,38.75,37.47,35.81,32.09,31.31,29.97,28.97,31.03,32.25,34.09,36.5,38.81,40.69,42.12,43.66,44.88,45.16,46.16,46.72,46.78,44.44,41.81,37.78,32.0,27.78,24.06,22.81,23.06,24.75,26.94,29.53,31.19,32.94,34.72,35.88,36.5,39.25,39.66,40.47,40.44,39.47,37.84,36.31,34.53,33.53,32.31,31.44,30.25,29.88,27.97,27.91,27.25,27.25,28.28,28.41,29.38,29.16,29.16,28.66,27.69,27.75,27.81,28.19,28.88,29.5,29.81,30.62,32.25,33.38,33.91,33.84,33.47,32.38,31.03,30.56,29.5,29.81,30.31,30.69,31.0,31.41,32.09,31.22,31.62,32.66,33.59,34.38,36.03,36.28,35.16,34.56,32.75,30.31,28.88,27.72,27.47,26.31,27.16,28.62,28.78,30.78,32.03,33.31,35.62,35.88,36.94,37.0,35.62,34.94,34.12,32.06,30.44,28.47,27.38,24.94,24.44,24.72,24.47,23.59,25.12,25.5,25.81,27.91,29.25,31.19,31.69,32.31,32.16,32.25,32.28,31.41,30.31,29.41,26.88,25.59,23.81,22.56,24.06,24.94,27.06,28.88,30.59,32.0,33.44,34.16,34.47,34.5,33.91,32.66,31.5,30.66,29.44,28.16,26.28,25.72,25.44,25.16,25.75,25.91,27.44,28.16,27.84,29.69,31.38,34.41,38.34,42.38,44.81,45.56,44.69,42.09,38.0,34.97,-9.53,-10.81,-10.66,-10.78,-10.28,-9.03,-7.72,-6.84,-6.22,-3.97,-2.66,-2.38,-1.47,-2.22,-3.41,-4.84,-5.47,-5.78,-5.53,-5.34,-4.72,-3.66,-1.84,1.62:32.25,30.16,29.44,29.81,31.62,34.16,33.97,34.03,33.0,31.19,30.5,29.16,29.47,29.78,30.53,31.03,31.97,32.81,34.5,35.31,36.0,35.38,35.31,34.06,32.72,32.44,30.59,29.97,30.19,30.16,29.22,28.91,28.25,27.66,26.97,26.62,27.56,26.47,26.81,26.69,25.75,25.28,23.72,22.75,19.28,16.78,14.06,13.22,13.56,16.31,19.94,24.81,28.75,32.12,35.34,36.84,38.12,38.81,39.28,39.09,39.91,39.97,40.94,42.03,43.12,44.25,44.03,45.12,43.56,43.84,43.16,42.59,41.06,40.09,39.03,37.88,37.53,36.53,37.12,36.94,36.53,35.22,34.19,31.97,30.88,29.97,28.88,29.03,29.94,29.97,30.84,31.03,30.19,30.25,28.62,29.41,29.81,30.5,33.66,34.53,35.47,36.59,36.5,35.97,35.5,35.19,34.44,33.78,33.62,32.25,31.91,31.56,32.31,32.16,33.56,34.09,35.62,35.12,36.84,36.97,38.44,40.06,40.66,42.34,41.97,42.69,42.91,41.66,41.66,40.75,40.62,39.75,39.88,39.16,39.19,38.38,38.94,39.06,39.03,39.38,39.66,39.5,38.56,37.88,36.97,34.5,33.34,32.0,30.5,29.41,28.5,27.66,26.97,27.81,28.94,29.44,31.06,31.41,31.12,30.38,28.97,28.09,28.12,28.12,28.88,29.91,31.44,33.75,34.94,36.22,37.0,38.0,37.19,37.31,38.59,38.81,39.03,40.75,40.72,41.19,40.94,40.34,38.75,36.91,35.06,34.47,34.03,36.41,38.12,41.22,43.09,45.31,45.16,43.53,42.12,38.06,34.97,32.09,30.44,28.75,29.03,28.62,30.16,29.81,29.78,29.28,27.91,26.62,25.53,25.0,25.28,26.19,28.34,30.75,31.19,31.19,31.88,30.38,29.41,28.0,26.19,24.72,24.09,24.19,26.94,30.59,35.31,39.09,44.12,45.12,44.72,44.19,41.19,39.19,37.94,37.12,37.28,37.47,38.28,36.75,37.59,37.16,36.88,36.78,36.56,36.25,36.69,36.88,38.41,39.59,39.5,39.69,38.94,39.41,39.53,39.81,40.78,40.56,40.78,41.34,41.09,41.62,42.66,41.12,41.41,40.25,38.44,39.03,38.84,38.84,38.94,38.66,38.47,38.0,38.56,40.25,41.25,41.66,42.5,42.22,41.12,39.44,39.66,38.84,39.5,39.66,40.66,41.06,40.62,40.31,40.81,39.44,39.16,39.16,39.25,39.44,40.06,42.5,44.47,46.28,47.78,48.94,49.66,49.75,50.28,49.19,47.47,44.81,42.19,38.22,35.81,32.19,30.03,28.44,26.88,27.16,28.09,28.62,30.75,31.34,32.53,32.69,34.72,35.0,36.66,38.88,40.06,41.81,41.56,40.72,40.06,39.0,36.34,35.84,34.28,33.09,31.88,31.41,30.19,30.5,30.53,30.56,30.97,31.03,31.16,32.06,34.91,37.25,39.91,43.31,43.44,43.31,40.75,38.25,34.09,31.06,28.53,26.31,24.84,24.0,22.28,22.47,21.53,21.62,22.88,24.28,25.91,27.84,29.28,30.31,31.69,33.94,34.91,36.88,39.06,38.25,38.84,38.19,36.84,36.16,34.5,33.38,32.5,31.41,31.0,30.53,31.47,32.03,32.66,32.66,33.28,33.25,32.59,32.06,33.19,33.56,34.06,35.56,35.41,35.12,34.44,32.75,33.19,32.56,33.44,33.84,34.25,34.34,33.81,33.38,32.81,31.12,30.88,29.44,28.25,27.41,26.25,26.66,27.72,29.84,31.81,34.81,37.16,38.34,38.31,38.25,38.25,37.19,38.84,40.16,41.81,43.84,44.84,45.44,45.31,44.06,42.66,42.09,40.16,40.06,40.0,39.62,39.84,40.56,39.78,39.41,38.5,38.31,38.94,39.5,40.28,40.25,40.56,39.34,37.12,35.81,33.75,32.19,31.56,31.78,31.94,33.81,35.19,37.62,39.94,41.31,41.28,41.94,42.31,41.56,40.53,41.06,39.84,38.5,37.88,38.06,38.12,38.66,39.69,40.91,41.72,42.91,42.19,41.5,42.41,40.41,40.03,41.28,39.59,41.12,40.78,40.31,40.69,40.38,40.94,42.16,42.59,44.5,45.19,45.62,46.59,46.84,47.31,46.75,47.56,46.81,46.41,44.5,41.81,39.25,36.41,34.53,32.94,32.94,34.47,35.12,36.38,39.56,41.41,43.94,46.16,46.22,47.03,44.03,40.94,38.91,34.56,32.53,31.56,31.25,32.12,32.78,35.44,36.62,37.03,39.03,39.06,39.25,38.5,37.44,37.12,34.22,34.75,34.75,35.25,36.81,39.5,40.41,40.84,41.5,40.19,39.56,38.81,37.44,36.25,36.34,35.31,34.5,34.06,33.56,32.38,31.41,30.62,29.81,28.31,28.56,28.25,26.81,26.25,25.28,23.97,24.22,23.78,24.94,26.78,28.41,29.78,30.81,31.25,32.31,31.53,32.19,32.62,32.62,32.53,31.5,31.56,30.0,28.88,28.94,28.34,28.5,29.31,30.44,32.19,33.34,34.62,35.81,35.5,35.38,34.59,35.06,35.78,36.12,36.31,36.75,35.31,35.03,34.03,34.19,33.22,33.44,35.12,33.31,34.09,32.31,31.62,30.56,30.84,31.22,31.97,33.19,34.78,34.69,35.66,36.22,36.69,36.56,37.31,39.25,41.75,42.69,45.31,47.34,48.25,47.94,47.12,45.72,42.97,38.94,36.56,34.03,31.5,31.38,29.41,29.69,29.44,27.78,28.56,27.72,27.69,27.91,28.91,29.56,30.19,30.16,29.84,28.91,27.59,26.84,25.91,26.84,26.66,27.47,27.78,27.56,28.06,28.0,28.06,28.56,28.44,28.72,29.0,29.19,29.25,29.47,29.19,30.38,31.59,32.84,32.84,32.03,30.56,28.88,27.03,26.94,27.81,28.94,31.72,34.69,36.66,39.0,39.81,38.75,37.47,35.81,32.09,31.31,29.97,28.97,31.03,32.25,34.09,36.5,38.81,40.69,42.12,43.66,44.88,45.16,46.16,46.72,46.78,44.44,41.81,37.78,32.0,27.78,24.06,22.81,23.06,24.75,26.94,29.53,31.19,32.94,34.72,35.88,36.5,39.25,39.66,40.47,40.44,39.47,37.84,36.31,34.53,33.53,32.31,31.44,30.25,29.88,27.97,27.91,27.25,27.25,28.28,28.41,29.38,29.16,29.16,28.66,27.69,27.75,27.81,28.19,28.88,29.5,29.81,30.62,32.25,33.38,33.91,33.84,33.47,32.38,31.03,30.56,29.5,29.81,30.31,30.69,31.0,31.41,32.09,31.22,31.62,32.66,33.59,34.38,36.03,36.28,35.16,34.56,32.75,30.31,28.88,27.72,27.47,26.31,27.16,28.62,28.78,30.78,32.03,33.31,35.62,35.88,36.94,37.0,35.62,34.94,34.12,32.06,30.44,28.47,27.38,24.94,24.44,24.72,24.47,23.59,25.12,25.5,25.81,27.91,29.25,31.19,31.69,32.31,32.16,32.25,32.28,31.41,30.31,29.41,26.88,25.59,23.81,22.56,24.06,24.94,27.06,28.88,30.59,32.0,33.44,34.16,34.47,34.5,33.91,32.66,31.5,30.66,29.44,28.16,26.28,25.72,25.44,25.16,25.75,25.91,27.44,28.16,27.84,29.69,31.38,34.41,38.34,42.38,44.81,45.56,44.69,42.09,38.0,34.97,-9.53,-10.81,-10.66,-10.78,-10.28,-9.03,-7.72,-6.84,-6.22,-3.97,-2.66,-2.38,-1.47,-2.22,-3.41,-4.84,-5.47,-5.78,-5.53,-5.34,-4.72,-3.66,-1.84,1.62,5.25,8.62,11.38,12.88,11.81,9.75:negativity
24.41,25.12,26.06,27.31,28.31,28.91,29.41,30.31,30.53,31.62,31.72,29.69,28.69,24.62,21.72,18.56,15.75,14.34,15.31,15.41,17.44,19.19,20.62,20.53,20.5,20.66,21.38,22.31,25.06,26.19,28.06,29.91,31.09,32.34,34.72,36.75,39.78,42.94,46.19,47.47,49.28,49.0,48.06,48.09,48.53,48.62,48.38,47.59,46.53,43.62,41.62,40.16,39.12,37.97,36.94,36.19,34.66,33.41,32.72,30.69,29.88,29.0,27.69,27.72,28.28,29.19,30.53,30.81,29.41,27.81,24.97,22.38,20.0,17.81,17.22,18.62,20.91,22.78,26.31,28.69,30.12,31.28,31.44,30.19,29.22,27.94,26.94,27.19,28.31,30.81,32.81,35.72,38.72,40.25,41.66,41.84,41.91,39.19,37.12,34.41,32.31,31.12,31.25,31.72,34.66,37.22,40.84,44.06,47.22,46.59,46.41,44.06,41.91,38.84,36.81,37.09,36.0,37.0,37.5,38.25,37.81,37.16,37.12,35.0,33.81,32.53,31.78,31.56,32.53,36.81,38.09,40.5,41.09,39.78,37.03,34.12,31.62,29.25,27.41,26.44,25.06,24.06,24.25,24.03,23.91,24.41,24.5,25.31,25.81,25.53,25.78,26.09,26.0,26.72,27.31,28.06,29.59,29.88,30.62,30.78,30.09,30.31,30.62,31.25,32.03,33.81,33.19,33.38,32.66,32.81,31.84,33.59,33.34,35.09,36.62,36.38,37.44,39.44,41.25,44.0,46.41,48.34,48.66,47.78,48.06,46.19,44.94,44.44,43.44,43.0,42.28,41.91,42.28,43.56,44.69,45.28,47.28,48.06,48.09,48.78,49.25,49.09,48.84,48.31,47.44,46.5,44.16,41.84,39.19,36.5,33.84,31.06,28.84,27.38,27.16,25.88,26.5,26.94,27.03,28.5,29.0,30.88,32.66,34.41,35.75,36.41,38.0,39.16,39.81,40.66,40.0,37.84,35.16,31.16,28.94,26.25,24.19,22.53,21.44,20.38,20.94,21.06,22.34,24.41,27.16,29.56,31.25,33.34,35.16,35.66,37.25,38.84,42.5,46.03,49.25,51.94,52.44,50.88,47.47,45.19,42.31,40.66,38.66,38.31,37.97,38.06,38.0,37.41,38.59,36.84,37.88,37.88,38.84,39.19,40.34,40.62,41.47,42.41,42.78,42.91,42.66,41.56,39.03,36.31,32.44,29.47,26.84,25.31,23.62,24.0,25.53,26.72,29.28,33.0,35.34,38.09,40.25,41.78,42.66,43.84,44.78,45.88,46.84,47.78,47.41,46.75,46.03,44.38,41.94,39.38,38.12,37.78,38.47,40.31,42.69,46.16,48.62,50.47,52.12,53.34,53.5,53.28,52.56,51.09,50.5,48.25,47.41,46.97,46.91,48.19,47.94,47.81,47.88,47.66,45.34,44.53,43.66,42.31,41.81,41.12,41.5,42.0,41.84,41.12,41.56,41.0,40.25,40.0,39.34,38.88,38.19,36.75,36.31,35.09,33.59,32.56,32.12,32.44,34.91,35.84,39.12,41.47,43.69,44.47,45.69,45.25,44.06,43.88,42.81,41.94,41.66,41.44,41.5,40.44,39.38,39.19,37.62,37.16,36.62,36.19,35.91,36.12,36.78,38.06,39.81,41.81,44.12,46.91,48.47,49.84,48.53,46.06,42.06,37.66,33.69,29.78,27.56,26.5,27.03,29.0,32.31,35.62,39.03,41.5,43.41,44.62,45.41,45.94,45.78,46.31,46.12,45.28,43.34,42.22,40.28,38.53,37.91,36.34,35.78,35.28,34.41,34.06,34.38,35.03,37.81,39.16,40.06,42.34,41.22,41.06,40.31,40.0,39.38,39.09,39.25,39.75,39.41,39.44,38.31,36.59,35.41,31.72,29.31,28.44,27.47,28.34,29.72,31.5,34.81,36.78,39.34,41.81,43.0,44.03,45.59,45.84,47.62,47.16,47.03,46.97,45.94,44.94,45.62,45.84,46.25,46.0,45.66,44.53,42.88,41.84,42.06,41.78,42.25,43.25,45.38,48.16,51.12,55.03,57.56,59.94,60.62,59.25,57.28,55.12,52.28,50.53,49.53,48.81,48.88,47.69,46.72,45.91,43.66,41.47,39.03,36.97,36.06,34.22,34.22,33.69,34.62,34.31,34.81,35.06,34.75,34.28,35.06,35.06,36.25,37.44,39.44,41.28,42.62,43.81,44.62,44.94,45.19,45.22,44.03,44.25,43.69,42.53,43.34,42.44,43.31,42.78,42.38,43.25,43.5,44.56,45.44,46.59,47.38,47.12,46.94,45.81,45.25,44.66,44.12,43.31,43.12,43.56,43.19,43.97,43.31,44.56,45.56,46.5,48.19,49.84,50.31,51.31,51.75,52.44,53.06,50.75,49.56,46.88,44.06,40.25,38.72,36.25,36.12,34.91,34.91,34.5,34.78,35.5,35.34,35.62,35.59,34.06,33.38,32.31,32.22,33.06,33.47,34.59,34.81,33.16,32.03,30.22,28.56,28.19,28.16,27.5,27.06,27.0,26.91,26.69,27.31,28.34,30.03,31.34,32.66,34.41,35.09,37.12,39.19,41.12,44.12,44.94,46.81,47.38,46.19,45.47,45.53,45.25,45.66,47.75,47.81,49.81,49.31,49.31,49.81,47.81,47.12,44.94,41.97,39.16,36.88,34.38,35.28,36.53,38.72,40.44,41.66,41.38,40.78,39.34,37.44,36.28,34.22,33.94,33.06,32.97,32.34,32.34,32.84,32.81,33.31,34.69,35.12,36.25,35.78,35.72,35.62,34.91,34.53,34.31,34.41,33.72,34.0,33.22,32.0,31.59,31.06,30.28,30.34,30.31,30.62,30.91,33.25,33.31,35.06,36.19,36.44,36.81,37.25,36.62,39.22,38.16,39.69,40.66,39.78,40.66,39.66,37.41,36.53,34.78,32.97,32.44,31.41,31.19,30.5,30.41,31.12,30.53,29.69,28.88,27.28,24.84,22.38,20.72,17.44,17.28,17.34,18.31,20.72,23.31,25.25,26.91,27.41,28.0,28.31,30.69,32.0,34.69,36.25,36.84,36.94,34.75,33.53,30.78,29.59,28.94,30.03,29.31,30.94,31.19,31.09,31.03,31.66,31.75,32.22,31.94,32.66,33.03,32.06,32.84,32.88,33.03,33.59,33.53,33.41,34.56,34.66,34.41,34.19,34.06,33.16,31.44,29.94,29.12,28.25,28.19,28.88,29.81,30.75,31.97,34.22,37.09,38.94,41.88,42.34,42.19,42.66,42.91,42.0,43.03,43.38,41.91,41.84,40.09,38.09,36.06,33.69,32.59,31.5,30.38,31.56,32.03,33.94,35.66,36.62,38.41,40.06,41.25,40.16,39.91,38.59,36.0,34.25,32.84,31.16,30.03,29.5,29.34,30.81,30.41,31.06,31.19,30.38,29.5,28.84,28.84,28.75,30.0,31.12,32.44,32.41,33.78,34.09,34.41,34.66,34.28,33.44,32.62,31.0,29.12,27.72,26.38,25.31,25.19,26.44,27.56,29.75,31.12,32.41,33.66,34.31,36.09,36.53,37.47,37.88,37.81,37.12,37.44,37.62,38.06,38.25,39.06,39.56,39.97,40.0,40.59,39.72,39.81,39.06,38.16,38.41,38.69,38.97,40.62,41.75,42.06,42.25,40.25,40.12,38.69,36.66,36.66,36.22,35.66,36.41,36.66,36.75,37.31,37.47,36.5,35.28,34.53,33.28,31.31,30.34,28.72,27.81,27.44,26.31,26.5,26.47,25.88,25.0,25.81,26.91,28.44,30.19,32.44,34.09,34.84,35.66,35.44,34.88,33.91,33.06,31.12,31.12,30.34,29.62,29.03,27.69,26.5,25.19,23.88,23.94,24.03:29.41,30.31,30.53,31.62,31.72,29.69,28.69,24.62,21.72,18.56,15.75,14.34,15.31,15.41,17.44,19.19,20.62,20.53,20.5,20.66,21.38,22.31,25.06,26.19,28.06,29.91,31.09,32.34,34.72,36.75,39.78,42.94,46.19,47.47,49.28,49.0,48.06,48.09,48.53,48.62,48.38,47.59,46.53,43.62,41.62,40.16,39.12,37.97,36.94,36.19,34.66,33.41,32.72,30.69,29.88,29.0,27.69,27.72,28.28,29.19,30.53,30.81,29.41,27.81,24.97,22.38,20.0,17.81,17.22,18.62,20.91,22.78,26.31,28.69,30.12,31.28,31.44,30.19,29.22,27.94,26.94,27.19,28.31,30.81,32.81,35.72,38.72,40.25,41.66,41.84,41.91,39.19,37.12,34.41,32.31,31.12,31.25,31.72,34.66,37.22,40.84,44.06,47.22,46.59,46.41,44.06,41.91,38.84,36.81,37.09,36.0,37.0,37.5,38.25,37.81,37.16,37.12,35.0,33.81,32.53,31.78,31.56,32.53,36.81,38.09,40.5,41.09,39.78,37.03,34.12,31.62,29.25,27.41,26.44,25.06,24.06,24.25,24.03,23.91,24.41,24.5,25.31,25.81,25.53,25.78,26.09,26.0,26.72,27.31,28.06,29.59,29.88,30.62,30.78,30.09,30.31,30.62,31.25,32.03,33.81,33.19,33.38,32.66,32.81,31.84,33.59,33.34,35.09,36.62,36.38,37.44,39.44,41.25,44.0,46.41,48.34,48.66,47.78,48.06,46.19,44.94,44.44,43.44,43.0,42.28,41.91,42.28,43.56,44.69,45.28,47.28,48.06,48.09,48.78,49.25,49.09,48.84,48.31,47.44,46.5,44.16,41.84,39.19,36.5,33.84,31.06,28.84,27.38,27.16,25.88,26.5,26.94,27.03,28.5,29.0,30.88,32.66,34.41,35.75,36.41,38.0,39.16,39.81,40.66,40.0,37.84,35.16,31.16,28.94,26.25,24.19,22.53,21.44,20.38,20.94,21.06,22.34,24.41,27.16,29.56,31.25,33.34,35.16,35.66,37.25,38.84,42.5,46.03,49.25,51.94,52.44,50.88,47.47,45.19,42.31,40.66,38.66,38.31,37.97,38.06,38.0,37.41,38.59,36.84,37.88,37.88,38.84,39.19,40.34,40.62,41.47,42.41,42.78,42.91,42.66,41.56,39.03,36.31,32.44,29.47,26.84,25.31,23.62,24.0,25.53,26.72,29.28,33.0,35.34,38.09,40.25,41.78,42.66,43.84,44.78,45.88,46.84,47.78,47.41,46.75,46.03,44.38,41.94,39.38,38.12,37.78,38.47,40.31,42.69,46.16,48.62,50.47,52.12,53.34,53.5,53.28,52.56,51.09,50.5,48.25,47.41,46.97,46.91,48.19,47.94,47.81,47.88,47.66,45.34,44.53,43.66,42.31,41.81,41.12,41.5,42.0,41.84,41.12,41.56,41.0,40.25,40.0,39.34,38.88,38.19,36.75,36.31,35.09,33.59,32.56,32.12,32.44,34.91,35.84,39.12,41.47,43.69,44.47,45.69,45.25,44.06,43.88,42.81,41.94,41.66,41.44,41.5,40.44,39.38,39.19,37.62,37.16,36.62,36.19,35.91,36.12,36.78,38.06,39.81,41.81,44.12,46.91,48.47,49.84,48.53,46.06,42.06,37.66,33.69,29.78,27.56,26.5,27.03,29.0,32.31,35.62,39.03,41.5,43.41,44.62,45.41,45.94,45.78,46.31,46.12,45.28,43.34,42.22,40.28,38.53,37.91,36.34,35.78,35.28,34.41,34.06,34.38,35.03,37.81,39.16,40.06,42.34,41.22,41.06,40.31,40.0,39.38,39.09,39.25,39.75,39.41,39.44,38.31,36.59,35.41,31.72,29.31,28.44,27.47,28.34,29.72,31.5,34.81,36.78,39.34,41.81,43.0,44.03,45.59,45.84,47.62,47.16,47.03,46.97,45.94,44.94,45.62,45.84,46.25,46.0,45.66,44.53,42.88,41.84,42.06,41.78,42.25,43.25,45.38,48.16,51.12,55.03,57.56,59.94,60.62,59.25,57.28,55.12,52.28,50.53,49.53,48.81,48.88,47.69,46.72,45.91,43.66,41.47,39.03,36.97,36.06,34.22,34.22,33.69,34.62,34.31,34.81,35.06,34.75,34.28,35.06,35.06,36.25,37.44,39.44,41.28,42.62,43.81,44.62,44.94,45.19,45.22,44.03,44.25,43.69,42.53,43.34,42.44,43.31,42.78,42.38,43.25,43.5,44.56,45.44,46.59,47.38,47.12,46.94,45.81,45.25,44.66,44.12,43.31,43.12,43.56,43.19,43.97,43.31,44.56,45.56,46.5,48.19,49.84,50.31,51.31,51.75,52.44,53.06,50.75,49.56,46.88,44.06,40.25,38.72,36.25,36.12,34.91,34.91,34.5,34.78,35.5,35.34,35.62,35.59,34.06,33.38,32.31,32.22,33.06,33.47,34.59,34.81,33.16,32.03,30.22,28.56,28.19,28.16,27.5,27.06,27.0,26.91,26.69,27.31,28.34,30.03,31.34,32.66,34.41,35.09,37.12,39.19,41.12,44.12,44.94,46.81,47.38,46.19,45.47,45.53,45.25,45.66,47.75,47.81,49.81,49.31,49.31,49.81,47.81,47.12,44.94,41.97,39.16,36.88,34.38,35.28,36.53,38.72,40.44,41.66,41.38,40.78,39.34,37.44,36.28,34.22,33.94,33.06,32.97,32.34,32.34,32.84,32.81,33.31,34.69,35.12,36.25,35.78,35.72,35.62,34.91,34.53,34.31,34.41,33.72,34.0,33.22,32.0,31.59,31.06,30.28,30.34,30.31,30.62,30.91,33.25,33.31,35.06,36.19,36.44,36.81,37.25,36.62,39.22,38.16,39.69,40.66,39.78,40.66,39.66,37.41,36.53,34.78,32.97,32.44,31.41,31.19,30.5,30.41,31.12,30.53,29.69,28.88,27.28,24.84,22.38,20.72,17.44,17.28,17.34,18.31,20.72,23.31,25.25,26.91,27.41,28.0,28.31,30.69,32.0,34.69,36.25,36.84,36.94,34.75,33.53,30.78,29.59,28.94,30.03,29.31,30.94,31.19,31.09,31.03,31.66,31.75,32.22,31.94,32.66,33.03,32.06,32.84,32.88,33.03,33.59,33.53,33.41,34.56,34.66,34.41,34.19,34.06,33.16,31.44,29.94,29.12,28.25,28.19,28.88,29.81,30.75,31.97,34.22,37.09,38.94,41.88,42.34,42.19,42.66,42.91,42.0,43.03,43.38,41.91,41.84,40.09,38.09,36.06,33.69,32.59,31.5,30.38,31.56,32.03,33.94,35.66,36.62,38.41,40.06,41.25,40.16,39.91,38.59,36.0,34.25,32.84,31.16,30.03,29.5,29.34,30.81,30.41,31.06,31.19,30.38,29.5,28.84,28.84,28.75,30.0,31.12,32.44,32.41,33.78,34.09,34.41,34.66,34.28,33.44,32.62,31.0,29.12,27.72,26.38,25.31,25.19,26.44,27.56,29.75,31.12,32.41,33.66,34.31,36.09,36.53,37.47,37.88,37.81,37.12,37.44,37.62,38.06,38.25,39.06,39.56,39.97,40.0,40.59,39.72,39.81,39.06,38.16,38.41,38.69,38.97,40.62,41.75,42.06,42.25,40.25,40.12,38.69,36.66,36.66,36.22,35.66,36.41,36.66,36.75,37.31,37.47,36.5,35.28,34.53,33.28,31.31,30.34,28.72,27.81,27.44,26.31,26.5,26.47,25.88,25.0,25.81,26.91,28.44,30.19,32.44,34.09,34.84,35.66,35.44,34.88,33.91,33.06,31.12,31.12,30.34,29.62,29.03,27.69,26.5,25.19,23.88,23.94,24.03,-19.88,-18.06,-15.31,-14.19,-12.78,-12.38:28.69,24.62,21.72,18.56,15.75,14.34,15.31,15.41,17.44,19.19,20.62,20.53,20.5,20.66,21.38,22.31,25.06,26.19,28.06,29.91,31.09,32.34,34.72,36.75,39.78,42.94,46.19,47.47,49.28,49.0,48.06,48.09,48.53,48.62,48.38,47.59,46.53,43.62,41.62,40.16,39.12,37.97,36.94,36.19,34.66,33.41,32.72,30.69,29.88,29.0,27.69,27.72,28.28,29.19,30.53,30.81,29.41,27.81,24.97,22.38,20.0,17.81,17.22,18.62,20.91,22.78,26.31,28.69,30.12,31.28,31.44,30.19,29.22,27.94,26.94,27.19,28.31,30.81,32.81,35.72,38.72,40.25,41.66,41.84,41.91,39.19,37.12,34.41,32.31,31.12,31.25,31.72,34.66,37.22,40.84,44.06,47.22,46.59,46.41,44.06,41.91,38.84,36.81,37.09,36.0,37.0,37.5,38.25,37.81,37.16,37.12,35.0,33.81,32.53,31.78,31.56,32.53,36.81,38.09,40.5,41.09,39.78,37.03,34.12,31.62,29.25,27.41,26.44,25.06,24.06,24.25,24.03,23.91,24.41,24.5,25.31,25.81,25.53,25.78,26.09,26.0,26.72,27.31,28.06,29.59,29.88,30.62,30.78,30.09,30.31,30.62,31.25,32.03,33.81,33.19,33.38,32.66,32.81,31.84,33.59,33.34,35.09,36.62,36.38,37.44,39.44,41.25,44.0,46.41,48.34,48.66,47.78,48.06,46.19,44.94,44.44,43.44,43.0,42.28,41.91,42.28,43.56,44.69,45.28,47.28,48.06,48.09,48.78,49.25,49.09,48.84,48.31,47.44,46.5,44.16,41.84,39.19,36.5,33.84,31.06,28.84,27.38,27.16,25.88,26.5,26.94,27.03,28.5,29.0,30.88,32.66,34.41,35.75,36.41,38.0,39.16,39.81,40.66,40.0,37.84,35.16,31.16,28.94,26.25,24.19,22.53,21.44,20.38,20.94,21.06,22.34,24.41,27.16,29.56,31.25,33.34,35.16,35.66,37.25,38.84,42.5,46.03,49.25,51.94,52.44,50.88,47.47,45.19,42.31,40.66,38.66,38.31,37.97,38.06,38.0,37.41,38.59,36.84,37.88,37.88,38.84,39.19,40.34,40.62,41.47,42.41,42.78,42.91,42.66,41.56,39.03,36.31,32.44,29.47,26.84,25.31,23.62,24.0,25.53,26.72,29.28,33.0,35.34,38.09,40.25,41.78,42.66,43.84,44.78,45.88,46.84,47.78,47.41,46.75,46.03,44.38,41.94,39.38,38.12,37.78,38.47,40.31,42.69,46.16,48.62,50.47,52.12,53.34,53.5,53.28,52.56,51.09,50.5,48.25,47.41,46.97,46.91,48.19,47.94,47.81,47.88,47.66,45.34,44.53,43.66,42.31,41.81,41.12,41.5,42.0,41.84,41.12,41.56,41.0,40.25,40.0,39.34,38.88,38.19,36.75,36.31,35.09,33.59,32.56,32.12,32.44,34.91,35.84,39.12,41.47,43.69,44.47,45.69,45.25,44.06,43.88,42.81,41.94,41.66,41.44,41.5,40.44,39.38,39.19,37.62,37.16,36.62,36.19,35.91,36.12,36.78,38.06,39.81,41.81,44.12,46.91,48.47,49.84,48.53,46.06,42.06,37.66,33.69,29.78,27.56,26.5,27.03,29.0,32.31,35.62,39.03,41.5,43.41,44.62,45.41,45.94,45.78,46.31,46.12,45.28,43.34,42.22,40.28,38.53,37.91,36.34,35.78,35.28,34.41,34.06,34.38,35.03,37.81,39.16,40.06,42.34,41.22,41.06,40.31,40.0,39.38,39.09,39.25,39.75,39.41,39.44,38.31,36.59,35.41,31.72,29.31,28.44,27.47,28.34,29.72,31.5,34.81,36.78,39.34,41.81,43.0,44.03,45.59,45.84,47.62,47.16,47.03,46.97,45.94,44.94,45.62,45.84,46.25,46.0,45.66,44.53,42.88,41.84,42.06,41.78,42.25,43.25,45.38,48.16,51.12,55.03,57.56,59.94,60.62,59.25,57.28,55.12,52.28,50.53,49.53,48.81,48.88,47.69,46.72,45.91,43.66,41.47,39.03,36.97,36.06,34.22,34.22,33.69,34.62,34.31,34.81,35.06,34.75,34.28,35.06,35.06,36.25,37.44,39.44,41.28,42.62,43.81,44.62,44.94,45.19,45.22,44.03,44.25,43.69,42.53,43.34,42.44,43.31,42.78,42.38,43.25,43.5,44.56,45.44,46.59,47.38,47.12,46.94,45.81,45.25,44.66,44.12,43.31,43.12,43.56,43.19,43.97,43.31,44.56,45.56,46.5,48.19,49.84,50.31,51.31,51.75,52.44,53.06,50.75,49.56,46.88,44.06,40.25,38.72,36.25,36.12,34.91,34.91,34.5,34.78,35.5,35.34,35.62,35.59,34.06,33.38,32.31,32.22,33.06,33.47,34.59,34.81,33.16,32.03,30.22,28.56,28.19,28.16,27.5,27.06,27.0,26.91,26.69,27.31,28.34,30.03,31.34,32.66,34.41,35.09,37.12,39.19,41.12,44.12,44.94,46.81,47.38,46.19,45.47,45.53,45.25,45.66,47.75,47.81,49.81,49.31,49.31,49.81,47.81,47.12,44.94,41.97,39.16,36.88,34.38,35.28,36.53,38.72,40.44,41.66,41.38,40.78,39.34,37.44,36.28,34.22,33.94,33.06,32.97,32.34,32.34,32.84,32.81,33.31,34.69,35.12,36.25,35.78,35.72,35.62,34.91,34.53,34.31,34.41,33.72,34.0,33.22,32.0,31.59,31.06,30.28,30.34,30.31,30.62,30.91,33.25,33.31,35.06,36.19,36.44,36.81,37.25,36.62,39.22,38.16,39.69,40.66,39.78,40.66,39.66,37.41,36.53,34.78,32.97,32.44,31.41,31.19,30.5,30.41,31.12,30.53,29.69,28.88,27.28,24.84,22.38,20.72,17.44,17.28,17.34,18.31,20.72,23.31,25.25,26.91,27.41,28.0,28.31,30.69,32.0,34.69,36.25,36.84,36.94,34.75,33.53,30.78,29.59,28.94,30.03,29.31,30.94,31.19,31.09,31.03,31.66,31.75,32.22,31.94,32.66,33.03,32.06,32.84,32.88,33.03,33.59,33.53,33.41,34.56,34.66,34.41,34.19,34.06,33.16,31.44,29.94,29.12,28.25,28.19,28.88,29.81,30.75,31.97,34.22,37.09,38.94,41.88,42.34,42.19,42.66,42.91,42.0,43.03,43.38,41.91,41.84,40.09,38.09,36.06,33.69,32.59,31.5,30.38,31.56,32.03,33.94,35.66,36.62,38.41,40.06,41.25,40.16,39.91,38.59,36.0,34.25,32.84,31.16,30.03,29.5,29.34,30.81,30.41,31.06,31.19,30.38,29.5,28.84,28.84,28.75,30.0,31.12,32.44,32.41,33.78,34.09,34.41,34.66,34.28,33.44,32.62,31.0,29.12,27.72,26.38,25.31,25.19,26.44,27.56,29.75,31.12,32.41,33.66,34.31,36.09,36.53,37.47,37.88,37.81,37.12,37.44,37.62,38.06,38.25,39.06,39.56,39.97,40.0,40.59,39.72,39.81,39.06,38.16,38.41,38.69,38.97,40.62,41.75,42.06,42.25,40.25,40.12,38.69,36.66,36.66,36.22,35.66,36.41,36.66,36.75,37.31,37.47,36.5,35.28,34.53,33.28,31.31,30.34,28.72,27.81,27.44,26.31,26.5,26.47,25.88,25.0,25.81,26.91,28.44,30.19,32.44,34.09,34.84,35.66,35.44,34.88,33.91,33.06,31.12,31.12,30.34,29.62,29.03,27.69,26.5,25.19,23.88,23.94,24.03,-19.88,-18.06,-15.31,-14.19,-12.78,-12.38,-11.66,-10.47,-9.97,-8.16,-8.06,-9.22:15.31,15.41,17.44,19.19,20.62,20.53,20.5,20.66,21.38,22.31,25.06,26.19,28.06,29.91,31.09,32.34,34.72,36.75,39.78,42.94,46.19,47.47,49.28,49.0,48.06,48.09,48.53,48.62,48.38,47.59,46.53,43.62,41.62,40.16,39.12,37.97,36.94,36.19,34.66,33.41,32.72,30.69,29.88,29.0,27.69,27.72,28.28,29.19,30.53,30.81,29.41,27.81,24.97,22.38,20.0,17.81,17.22,18.62,20.91,22.78,26.31,28.69,30.12,31.28,31.44,30.19,29.22,27.94,26.94,27.19,28.31,30.81,32.81,35.72,38.72,40.25,41.66,41.84,41.91,39.19,37.12,34.41,32.31,31.12,31.25,31.72,34.66,37.22,40.84,44.06,47.22,46.59,46.41,44.06,41.91,38.84,36.81,37.09,36.0,37.0,37.5,38.25,37.81,37.16,37.12,35.0,33.81,32.53,31.78,31.56,32.53,36.81,38.09,40.5,41.09,39.78,37.03,34.12,31.62,29.25,27.41,26.44,25.06,24.06,24.25,24.03,23.91,24.41,24.5,25.31,25.81,25.53,25.78,26.09,26.0,26.72,27.31,28.06,29.59,29.88,30.62,30.78,30.09,30.31,30.62,31.25,32.03,33.81,33.19,33.38,32.66,32.81,31.84,33.59,33.34,35.09,36.62,36.38,37.44,39.44,41.25,44.0,46.41,48.34,48.66,47.78,48.06,46.19,44.94,44.44,43.44,43.0,42.28,41.91,42.28,43.56,44.69,45.28,47.28,48.06,48.09,48.78,49.25,49.09,48.84,48.31,47.44,46.5,44.16,41.84,39.19,36.5,33.84,31.06,28.84,27.38,27.16,25.88,26.5,26.94,27.03,28.5,29.0,30.88,32.66,34.41,35.75,36.41,38.0,39.16,39.81,40.66,40.0,37.84,35.16,31.16,28.94,26.25,24.19,22.53,21.44,20.38,20.94,21.06,22.34,24.41,27.16,29.56,31.25,33.34,35.16,35.66,37.25,38.84,42.5,46.03,49.25,51.94,52.44,50.88,47.47,45.19,42.31,40.66,38.66,38.31,37.97,38.06,38.0,37.41,38.59,36.84,37.88,37.88,38.84,39.19,40.34,40.62,41.47,42.41,42.78,42.91,42.66,41.56,39.03,36.31,32.44,29.47,26.84,25.31,23.62,24.0,25.53,26.72,29.28,33.0,35.34,38.09,40.25,41.78,42.66,43.84,44.78,45.88,46.84,47.78,47.41,46.75,46.03,44.38,41.94,39.38,38.12,37.78,38.47,40.31,42.69,46.16,48.62,50.47,52.12,53.34,53.5,53.28,52.56,51.09,50.5,48.25,47.41,46.97,46.91,48.19,47.94,47.81,47.88,47.66,45.34,44.53,43.66,42.31,41.81,41.12,41.5,42.0,41.84,41.12,41.56,41.0,40.25,40.0,39.34,38.88,38.19,36.75,36.31,35.09,33.59,32.56,32.12,32.44,34.91,35.84,39.12,41.47,43.69,44.47,45.69,45.25,44.06,43.88,42.81,41.94,41.66,41.44,41.5,40.44,39.38,39.19,37.62,37.16,36.62,36.19,35.91,36.12,36.78,38.06,39.81,41.81,44.12,46.91,48.47,49.84,48.53,46.06,42.06,37.66,33.69,29.78,27.56,26.5,27.03,29.0,32.31,35.62,39.03,41.5,43.41,44.62,45.41,45.94,45.78,46.31,46.12,45.28,43.34,42.22,40.28,38.53,37.91,36.34,35.78,35.28,34.41,34.06,34.38,35.03,37.81,39.16,40.06,42.34,41.22,41.06,40.31,40.0,39.38,39.09,39.25,39.75,39.41,39.44,38.31,36.59,35.41,31.72,29.31,28.44,27.47,28.34,29.72,31.5,34.81,36.78,39.34,41.81,43.0,44.03,45.59,45.84,47.62,47.16,47.03,46.97,45.94,44.94,45.62,45.84,46.25,46.0,45.66,44.53,42.88,41.84,42.06,41.78,42.25,43.25,45.38,48.16,51.12,55.03,57.56,59.94,60.62,59.25,57.28,55.12,52.28,50.53,49.53,48.81,48.88,47.69,46.72,45.91,43.66,41.47,39.03,36.97,36.06,34.22,34.22,33.69,34.62,34.31,34.81,35.06,34.75,34.28,35.06,35.06,36.25,37.44,39.44,41.28,42.62,43.81,44.62,44.94,45.19,45.22,44.03,44.25,43.69,42.53,43.34,42.44,43.31,42.78,42.38,43.25,43.5,44.56,45.44,46.59,47.38,47.12,46.94,45.81,45.25,44.66,44.12,43.31,43.12,43.56,43.19,43.97,43.31,44.56,45.56,46.5,48.19,49.84,50.31,51.31,51.75,52.44,53.06,50.75,49.56,46.88,44.06,40.25,38.72,36.25,36.12,34.91,34.91,34.5,34.78,35.5,35.34,35.62,35.59,34.06,33.38,32.31,32.22,33.06,33.47,34.59,34.81,33.16,32.03,30.22,28.56,28.19,28.16,27.5,27.06,27.0,26.91,26.69,27.31,28.34,30.03,31.34,32.66,34.41,35.09,37.12,39.19,41.12,44.12,44.94,46.81,47.38,46.19,45.47,45.53,45.25,45.66,47.75,47.81,49.81,49.31,49.31,49.81,47.81,47.12,44.94,41.97,39.16,36.88,34.38,35.28,36.53,38.72,40.44,41.66,41.38,40.78,39.34,37.44,36.28,34.22,33.94,33.06,32.97,32.34,32.34,32.84,32.81,33.31,34.69,35.12,36.25,35.78,35.72,35.62,34.91,34.53,34.31,34.41,33.72,34.0,33.22,32.0,31.59,31.06,30.28,30.34,30.31,30.62,30.91,33.25,33.31,35.06,36.19,36.44,36.81,37.25,36.62,39.22,38.16,39.69,40.66,39.78,40.66,39.66,37.41,36.53,34.78,32.97,32.44,31.41,31.19,30.5,30.41,31.12,30.53,29.69,28.88,27.28,24.84,22.38,20.72,17.44,17.28,17.34,18.31,20.72,23.31,25.25,26.91,27.41,28.0,28.31,30.69,32.0,34.69,36.25,36.84,36.94,34.75,33.53,30.78,29.59,28.94,30.03,29.31,30.94,31.19,31.09,31.03,31.66,31.75,32.22,31.94,32.66,33.03,32.06,32.84,32.88,33.03,33.59,33.53,33.41,34.56,34.66,34.41,34.19,34.06,33.16,31.44,29.94,29.12,28.25,28.19,28.88,29.81,30.75,31.97,34.22,37.09,38.94,41.88,42.34,42.19,42.66,42.91,42.0,43.03,43.38,41.91,41.84,40.09,38.09,36.06,33.69,32.59,31.5,30.38,31.56,32.03,33.94,35.66,36.62,38.41,40.06,41.25,40.16,39.91,38.59,36.0,34.25,32.84,31.16,30.03,29.5,29.34,30.81,30.41,31.06,31.19,30.38,29.5,28.84,28.84,28.75,30.0,31.12,32.44,32.41,33.78,34.09,34.41,34.66,34.28,33.44,32.62,31.0,29.12,27.72,26.38,25.31,25.19,26.44,27.56,29.75,31.12,32.41,33.66,34.31,36.09,36.53,37.47,37.88,37.81,37.12,37.44,37.62,38.06,38.25,39.06,39.56,39.97,40.0,40.59,39.72,39.81,39.06,38.16,38.41,38.69,38.97,40.62,41.75,42.06,42.25,40.25,40.12,38.69,36.66,36.66,36.22,35.66,36.41,36.66,36.75,37.31,37.47,36.5,35.28,34.53,33.28,31.31,30.34,28.72,27.81,27.44,26.31,26.5,26.47,25.88,25.0,25.81,26.91,28.44,30.19,32.44,34.09,34.84,35.66,35.44,34.88,33.91,33.06,31.12,31.12,30.34,29.62,29.03,27.69,26.5,25.19,23.88,23.94,24.03,-19.88,-18.06,-15.31,-14.19,-12.78,-12.38,-11.66,-10.47,-9.97,-8.16,-8.06,-9.22,-11.75,-15.47,-19.09,-21.78,-24.78,-25.66:20.5,20.66,21.38,22.31,25.06,26.19,28.06,29.91,31.09,32.34,34.72,36.75,39.78,42.94,46.19,47.47,49.28,49.0,48.06,48.09,48.53,48.62,48.38,47.59,46.53,43.62,41.62,40.16,39.12,37.97,36.94,36.19,34.66,33.41,32.72,30.69,29.88,29.0,27.69,27.72,28.28,29.19,30.53,30.81,29.41,27.81,24.97,22.38,20.0,17.81,17.22,18.62,20.91,22.78,26.31,28.69,30.12,31.28,31.44,30.19,29.22,27.94,26.94,27.19,28.31,30.81,32.81,35.72,38.72,40.25,41.66,41.84,41.91,39.19,37.12,34.41,32.31,31.12,31.25,31.72,34.66,37.22,40.84,44.06,47.22,46.59,46.41,44.06,41.91,38.84,36.81,37.09,36.0,37.0,37.5,38.25,37.81,37.16,37.12,35.0,33.81,32.53,31.78,31.56,32.53,36.81,38.09,40.5,41.09,39.78,37.03,34.12,31.62,29.25,27.41,26.44,25.06,24.06,24.25,24.03,23.91,24.41,24.5,25.31,25.81,25.53,25.78,26.09,26.0,26.72,27.31,28.06,29.59,29.88,30.62,30.78,30.09,30.31,30.62,31.25,32.03,33.81,33.19,33.38,32.66,32.81,31.84,33.59,33.34,35.09,36.62,36.38,37.44,39.44,41.25,44.0,46.41,48.34,48.66,47.78,48.06,46.19,44.94,44.44,43.44,43.0,42.28,41.91,42.28,43.56,44.69,45.28,47.28,48.06,48.09,48.78,49.25,49.09,48.84,48.31,47.44,46.5,44.16,41.84,39.19,36.5,33.84,31.06,28.84,27.38,27.16,25.88,26.5,26.94,27.03,28.5,29.0,30.88,32.66,34.41,35.75,36.41,38.0,39.16,39.81,40.66,40.0,37.84,35.16,31.16,28.94,26.25,24.19,22.53,21.44,20.38,20.94,21.06,22.34,24.41,27.16,29.56,31.25,33.34,35.16,35.66,37.25,38.84,42.5,46.03,49.25,51.94,52.44,50.88,47.47,45.19,42.31,40.66,38.66,38.31,37.97,38.06,38.0,37.41,38.59,36.84,37.88,37.88,38.84,39.19,40.34,40.62,41.47,42.41,42.78,42.91,42.66,41.56,39.03,36.31,32.44,29.47,26.84,25.31,23.62,24.0,25.53,26.72,29.28,33.0,35.34,38.09,40.25,41.78,42.66,43.84,44.78,45.88,46.84,47.78,47.41,46.75,46.03,44.38,41.94,39.38,38.12,37.78,38.47,40.31,42.69,46.16,48.62,50.47,52.12,53.34,53.5,53.28,52.56,51.09,50.5,48.25,47.41,46.97,46.91,48.19,47.94,47.81,47.88,47.66,45.34,44.53,43.66,42.31,41.81,41.12,41.5,42.0,41.84,41.12,41.56,41.0,40.25,40.0,39.34,38.88,38.19,36.75,36.31,35.09,33.59,32.56,32.12,32.44,34.91,35.84,39.12,41.47,43.69,44.47,45.69,45.25,44.06,43.88,42.81,41.94,41.66,41.44,41.5,40.44,39.38,39.19,37.62,37.16,36.62,36.19,35.91,36.12,36.78,38.06,39.81,41.81,44.12,46.91,48.47,49.84,48.53,46.06,42.06,37.66,33.69,29.78,27.56,26.5,27.03,29.0,32.31,35.62,39.03,41.5,43.41,44.62,45.41,45.94,45.78,46.31,46.12,45.28,43.34,42.22,40.28,38.53,37.91,36.34,35.78,35.28,34.41,34.06,34.38,35.03,37.81,39.16,40.06,42.34,41.22,41.06,40.31,40.0,39.38,39.09,39.25,39.75,39.41,39.44,38.31,36.59,35.41,31.72,29.31,28.44,27.47,28.34,29.72,31.5,34.81,36.78,39.34,41.81,43.0,44.03,45.59,45.84,47.62,47.16,47.03,46.97,45.94,44.94,45.62,45.84,46.25,46.0,45.66,44.53,42.88,41.84,42.06,41.78,42.25,43.25,45.38,48.16,51.12,55.03,57.56,59.94,60.62,59.25,57.28,55.12,52.28,50.53,49.53,48.81,48.88,47.69,46.72,45.91,43.66,41.47,39.03,36.97,36.06,34.22,34.22,33.69,34.62,34.31,34.81,35.06,34.75,34.28,35.06,35.06,36.25,37.44,39.44,41.28,42.62,43.81,44.62,44.94,45.19,45.22,44.03,44.25,43.69,42.53,43.34,42.44,43.31,42.78,42.38,43.25,43.5,44.56,45.44,46.59,47.38,47.12,46.94,45.81,45.25,44.66,44.12,43.31,43.12,43.56,43.19,43.97,43.31,44.56,45.56,46.5,48.19,49.84,50.31,51.31,51.75,52.44,53.06,50.75,49.56,46.88,44.06,40.25,38.72,36.25,36.12,34.91,34.91,34.5,34.78,35.5,35.34,35.62,35.59,34.06,33.38,32.31,32.22,33.06,33.47,34.59,34.81,33.16,32.03,30.22,28.56,28.19,28.16,27.5,27.06,27.0,26.91,26.69,27.31,28.34,30.03,31.34,32.66,34.41,35.09,37.12,39.19,41.12,44.12,44.94,46.81,47.38,46.19,45.47,45.53,45.25,45.66,47.75,47.81,49.81,49.31,49.31,49.81,47.81,47.12,44.94,41.97,39.16,36.88,34.38,35.28,36.53,38.72,40.44,41.66,41.38,40.78,39.34,37.44,36.28,34.22,33.94,33.06,32.97,32.34,32.34,32.84,32.81,33.31,34.69,35.12,36.25,35.78,35.72,35.62,34.91,34.53,34.31,34.41,33.72,34.0,33.22,32.0,31.59,31.06,30.28,30.34,30.31,30.62,30.91,33.25,33.31,35.06,36.19,36.44,36.81,37.25,36.62,39.22,38.16,39.69,40.66,39.78,40.66,39.66,37.41,36.53,34.78,32.97,32.44,31.41,31.19,30.5,30.41,31.12,30.53,29.69,28.88,27.28,24.84,22.38,20.72,17.44,17.28,17.34,18.31,20.72,23.31,25.25,26.91,27.41,28.0,28.31,30.69,32.0,34.69,36.25,36.84,36.94,34.75,33.53,30.78,29.59,28.94,30.03,29.31,30.94,31.19,31.09,31.03,31.66,31.75,32.22,31.94,32.66,33.03,32.06,32.84,32.88,33.03,33.59,33.53,33.41,34.56,34.66,34.41,34.19,34.06,33.16,31.44,29.94,29.12,28.25,28.19,28.88,29.81,30.75,31.97,34.22,37.09,38.94,41.88,42.34,42.19,42.66,42.91,42.0,43.03,43.38,41.91,41.84,40.09,38.09,36.06,33.69,32.59,31.5,30.38,31.56,32.03,33.94,35.66,36.62,38.41,40.06,41.25,40.16,39.91,38.59,36.0,34.25,32.84,31.16,30.03,29.5,29.34,30.81,30.41,31.06,31.19,30.38,29.5,28.84,28.84,28.75,30.0,31.12,32.44,32.41,33.78,34.09,34.41,34.66,34.28,33.44,32.62,31.0,29.12,27.72,26.38,25.31,25.19,26.44,27.56,29.75,31.12,32.41,33.66,34.31,36.09,36.53,37.47,37.88,37.81,37.12,37.44,37.62,38.06,38.25,39.06,39.56,39.97,40.0,40.59,39.72,39.81,39.06,38.16,38.41,38.69,38.97,40.62,41.75,42.06,42.25,40.25,40.12,38.69,36.66,36.66,36.22,35.66,36.41,36.66,36.75,37.31,37.47,36.5,35.28,34.53,33.28,31.31,30.34,28.72,27.81,27.44,26.31,26.5,26.47,25.88,25.0,25.81,26.91,28.44,30.19,32.44,34.09,34.84,35.66,35.44,34.88,33.91,33.06,31.12,31.12,30.34,29.62,29.03,27.69,26.5,25.19,23.88,23.94,24.03,-19.88,-18.06,-15.31,-14.19,-12.78,-12.38,-11.66,-10.47,-9.97,-8.16,-8.06,-9.22,-11.75,-15.47,-19.09,-21.78,-24.78,-25.66,-25.09,-24.19,-23.78,-22.72,-22.66,-22.84:28.06,29.91,31.09,32.34,34.72,36.75,39.78,42.94,46.19,47.47,49.28,49.0,48.06,48.09,48.53,48.62,48.38,47.59,46.53,43.62,41.62,40.16,39.12,37.97,36.94,36.19,34.66,33.41,32.72,30.69,29.88,29.0,27.69,27.72,28.28,29.19,30.53,30.81,29.41,27.81,24.97,22.38,20.0,17.81,17.22,18.62,20.91,22.78,26.31,28.69,30.12,31.28,31.44,30.19,29.22,27.94,26.94,27.19,28.31,30.81,32.81,35.72,38.72,40.25,41.66,41.84,41.91,39.19,37.12,34.41,32.31,31.12,31.25,31.72,34.66,37.22,40.84,44.06,47.22,46.59,46.41,44.06,41.91,38.84,36.81,37.09,36.0,37.0,37.5,38.25,37.81,37.16,37.12,35.0,33.81,32.53,31.78,31.56,32.53,36.81,38.09,40.5,41.09,39.78,37.03,34.12,31.62,29.25,27.41,26.44,25.06,24.06,24.25,24.03,23.91,24.41,24.5,25.31,25.81,25.53,25.78,26.09,26.0,26.72,27.31,28.06,29.59,29.88,30.62,30.78,30.09,30.31,30.62,31.25,32.03,33.81,33.19,33.38,32.66,32.81,31.84,33.59,33.34,35.09,36.62,36.38,37.44,39.44,41.25,44.0,46.41,48.34,48.66,47.78,48.06,46.19,44.94,44.44,43.44,43.0,42.28,41.91,42.28,43.56,44.69,45.28,47.28,48.06,48.09,48.78,49.25,49.09,48.84,48.31,47.44,46.5,44.16,41.84,39.19,36.5,33.84,31.06,28.84,27.38,27.16,25.88,26.5,26.94,27.03,28.5,29.0,30.88,32.66,34.41,35.75,36.41,38.0,39.16,39.81,40.66,40.0,37.84,35.16,31.16,28.94,26.25,24.19,22.53,21.44,20.38,20.94,21.06,22.34,24.41,27.16,29.56,31.25,33.34,35.16,35.66,37.25,38.84,42.5,46.03,49.25,51.94,52.44,50.88,47.47,45.19,42.31,40.66,38.66,38.31,37.97,38.06,38.0,37.41,38.59,36.84,37.88,37.88,38.84,39.19,40.34,40.62,41.47,42.41,42.78,42.91,42.66,41.56,39.03,36.31,32.44,29.47,26.84,25.31,23.62,24.0,25.53,26.72,29.28,33.0,35.34,38.09,40.25,41.78,42.66,43.84,44.78,45.88,46.84,47.78,47.41,46.75,46.03,44.38,41.94,39.38,38.12,37.78,38.47,40.31,42.69,46.16,48.62,50.47,52.12,53.34,53.5,53.28,52.56,51.09,50.5,48.25,47.41,46.97,46.91,48.19,47.94,47.81,47.88,47.66,45.34,44.53,43.66,42.31,41.81,41.12,41.5,42.0,41.84,41.12,41.56,41.0,40.25,40.0,39.34,38.88,38.19,36.75,36.31,35.09,33.59,32.56,32.12,32.44,34.91,35.84,39.12,41.47,43.69,44.47,45.69,45.25,44.06,43.88,42.81,41.94,41.66,41.44,41.5,40.44,39.38,39.19,37.62,37.16,36.62,36.19,35.91,36.12,36.78,38.06,39.81,41.81,44.12,46.91,48.47,49.84,48.53,46.06,42.06,37.66,33.69,29.78,27.56,26.5,27.03,29.0,32.31,35.62,39.03,41.5,43.41,44.62,45.41,45.94,45.78,46.31,46.12,45.28,43.34,42.22,40.28,38.53,37.91,36.34,35.78,35.28,34.41,34.06,34.38,35.03,37.81,39.16,40.06,42.34,41.22,41.06,40.31,40.0,39.38,39.09,39.25,39.75,39.41,39.44,38.31,36.59,35.41,31.72,29.31,28.44,27.47,28.34,29.72,31.5,34.81,36.78,39.34,41.81,43.0,44.03,45.59,45.84,47.62,47.16,47.03,46.97,45.94,44.94,45.62,45.84,46.25,46.0,45.66,44.53,42.88,41.84,42.06,41.78,42.25,43.25,45.38,48.16,51.12,55.03,57.56,59.94,60.62,59.25,57.28,55.12,52.28,50.53,49.53,48.81,48.88,47.69,46.72,45.91,43.66,41.47,39.03,36.97,36.06,34.22,34.22,33.69,34.62,34.31,34.81,35.06,34.75,34.28,35.06,35.06,36.25,37.44,39.44,41.28,42.62,43.81,44.62,44.94,45.19,45.22,44.03,44.25,43.69,42.53,43.34,42.44,43.31,42.78,42.38,43.25,43.5,44.56,45.44,46.59,47.38,47.12,46.94,45.81,45.25,44.66,44.12,43.31,43.12,43.56,43.19,43.97,43.31,44.56,45.56,46.5,48.19,49.84,50.31,51.31,51.75,52.44,53.06,50.75,49.56,46.88,44.06,40.25,38.72,36.25,36.12,34.91,34.91,34.5,34.78,35.5,35.34,35.62,35.59,34.06,33.38,32.31,32.22,33.06,33.47,34.59,34.81,33.16,32.03,30.22,28.56,28.19,28.16,27.5,27.06,27.0,26.91,26.69,27.31,28.34,30.03,31.34,32.66,34.41,35.09,37.12,39.19,41.12,44.12,44.94,46.81,47.38,46.19,45.47,45.53,45.25,45.66,47.75,47.81,49.81,49.31,49.31,49.81,47.81,47.12,44.94,41.97,39.16,36.88,34.38,35.28,36.53,38.72,40.44,41.66,41.38,40.78,39.34,37.44,36.28,34.22,33.94,33.06,32.97,32.34,32.34,32.84,32.81,33.31,34.69,35.12,36.25,35.78,35.72,35.62,34.91,34.53,34.31,34.41,33.72,34.0,33.22,32.0,31.59,31.06,30.28,30.34,30.31,30.62,30.91,33.25,33.31,35.06,36.19,36.44,36.81,37.25,36.62,39.22,38.16,39.69,40.66,39.78,40.66,39.66,37.41,36.53,34.78,32.97,32.44,31.41,31.19,30.5,30.41,31.12,30.53,29.69,28.88,27.28,24.84,22.38,20.72,17.44,17.28,17.34,18.31,20.72,23.31,25.25,26.91,27.41,28.0,28.31,30.69,32.0,34.69,36.25,36.84,36.94,34.75,33.53,30.78,29.59,28.94,30.03,29.31,30.94,31.19,31.09,31.03,31.66,31.75,32.22,31.94,32.66,33.03,32.06,32.84,32.88,33.03,33.59,33.53,33.41,34.56,34.66,34.41,34.19,34.06,33.16,31.44,29.94,29.12,28.25,28.19,28.88,29.81,30.75,31.97,34.22,37.09,38.94,41.88,42.34,42.19,42.66,42.91,42.0,43.03,43.38,41.91,41.84,40.09,38.09,36.06,33.69,32.59,31.5,30.38,31.56,32.03,33.94,35.66,36.62,38.41,40.06,41.25,40.16,39.91,38.59,36.0,34.25,32.84,31.16,30.03,29.5,29.34,30.81,30.41,31.06,31.19,30.38,29.5,28.84,28.84,28.75,30.0,31.12,32.44,32.41,33.78,34.09,34.41,34.66,34.28,33.44,32.62,31.0,29.12,27.72,26.38,25.31,25.19,26.44,27.56,29.75,31.12,32.41,33.66,34.31,36.09,36.53,37.47,37.88,37.81,37.12,37.44,37.62,38.06,38.25,39.06,39.56,39.97,40.0,40.59,39.72,39.81,39.06,38.16,38.41,38.69,38.97,40.62,41.75,42.06,42.25,40.25,40.12,38.69,36.66,36.66,36.22,35.66,36.41,36.66,36.75,37.31,37.47,36.5,35.28,34.53,33.28,31.31,30.34,28.72,27.81,27.44,26.31,26.5,26.47,25.88,25.0,25.81,26.91,28.44,30.19,32.44,34.09,34.84,35.66,35.44,34.88,33.91,33.06,31.12,31.12,30.34,29.62,29.03,27.69,26.5,25.19,23.88,23.94,24.03,-19.88,-18.06,-15.31,-14.19,-12.78,-12.38,-11.66,-10.47,-9.97,-8.16,-8.06,-9.22,-11.75,-15.47,-19.09,-21.78,-24.78,-25.66,-25.09,-24.19,-23.78,-22.72,-22.66,-22.84,-23.19,-22.59,-21.22,-19.59,-16.66,-13.31:negativity
26.81,28.94,28.84,26.81,25.06,23.62,22.22,22.75,23.31,24.38,24.94,24.88,23.44,21.62,20.28,18.44,16.06,15.38,14.34,13.28,13.41,13.81,14.31,16.44,15.44,16.16,17.0,17.12,19.62,23.75,27.56,31.44,33.53,34.03,35.12,35.31,34.16,33.0,30.81,28.09,25.75,23.44,22.66,23.25,22.91,23.81,24.56,24.34,25.91,27.19,28.47,29.53,30.75,31.91,32.5,33.94,35.78,36.34,37.19,37.72,36.41,35.22,32.31,28.91,25.47,21.81,19.28,16.19,14.56,12.5,11.62,9.94,8.72,7.91,6.28,4.56,3.28,2.91,3.94,5.66,9.53,11.81,15.16,16.5,17.28,17.59,19.31,19.31,18.5,17.69,15.97,13.03,10.88,10.16,8.66,8.94,8.72,8.53,6.28,4.94,4.03,3.19,2.5,4.19,5.84,8.56,12.66,16.56,20.78,24.0,26.41,28.94,29.94,29.28,27.91,25.97,23.62,20.81,19.34,18.38,17.56,16.66,17.16,17.12,18.03,18.03,18.53,18.88,19.41,19.88,21.34,21.47,22.16,22.19,22.53,23.22,24.38,26.0,26.28,26.34,25.03,23.72,22.03,20.56,19.25,20.59,20.31,20.0,20.56,20.06,18.25,17.56,16.91,15.78,15.28,15.56,16.72,16.78,18.91,19.81,18.94,21.38,21.75,22.44,21.62,20.62,20.94,19.84,20.97,23.0,24.66,26.81,27.06,27.25,25.88,24.28,23.44,22.44,22.47,20.91,21.25,21.16,20.16,21.62,22.44,23.88,24.41,24.59,25.28,23.5,21.53,19.81,16.66,15.78,13.5,12.59,11.09,10.5,9.34,8.94,8.16,7.69,7.59,7.06,7.94,9.0,8.31,9.94,10.88,12.25,13.31,14.19,15.41,16.22,17.0,18.66,19.34,20.06,18.94,17.0,14.44,11.56,9.41,9.69,10.06,10.94,13.16,15.69,16.53,18.66,20.78,22.34,22.56,23.84,22.91,21.88,19.75,18.91,17.25,16.22,17.06,17.56,18.59,18.88,19.19,21.12,20.12,22.19,24.44,27.0,29.69,31.72,30.44,30.0,27.16,24.53,22.19,20.72,20.22,19.72,19.41,16.31,13.78,12.0,8.34,7.91,7.5,7.69,9.44,10.34,11.47,11.72,11.75,12.06,10.94,11.06,12.91,12.66,14.5,16.81,18.84,21.44,23.22,24.44,24.75,24.66,23.91,23.03,22.62,20.78,18.94,19.06,18.22,16.66,17.72,17.47,18.91,19.03,19.41,19.41,18.66,18.16,18.25,19.16,21.06,23.19,23.69,25.75,25.69,25.22,24.81,24.31,22.16,21.34,20.94,19.53,19.22,19.94,19.16,19.31,19.19,19.19,17.94,16.84,15.88,15.66,15.0,14.75,13.47,13.66,12.62,13.34,15.03,17.47,17.91,19.91,19.62,20.34,19.25,19.47,19.38,19.91,20.75,21.12,21.38,21.56,20.94,21.16,21.41,20.44,21.19,20.19,20.72,20.0,21.47,19.31,18.84,17.22,14.28,11.84,9.91,9.06,10.78,11.59,13.53,15.41,15.78,15.72,15.75,14.62,13.06,12.81,10.62,10.75,9.66,9.84,10.69,11.16,10.59,12.16,11.75,11.03,11.19,10.34,8.91,8.41,8.78,8.97,10.75,11.09,12.28,12.44,11.34,11.97,11.22,11.41,11.72,12.44,14.34,14.88,17.41,17.31,19.06,19.56,21.28,23.22,24.38,24.81,24.09,22.31,20.38,17.69,16.06,15.62,15.56,16.44,17.78,18.03,18.47,16.38,13.31,10.09,8.12,6.62,8.06,9.69,11.69,15.72,17.69,20.47,21.56,22.38,23.44,22.59,21.69,21.59,19.88,19.12,17.41,16.78,16.66,14.94,15.0,15.0,14.75,15.53,15.53,16.53,18.06,19.81,22.19,23.81,25.06,26.0,26.66,26.25,25.81,25.84,25.06,23.94,23.72,23.81,22.62,21.47,19.91,17.72,15.94,13.03,12.06,11.56,12.88,14.5,18.56,22.69,26.88,29.97,33.03,35.12,35.72,35.53,36.09,35.5,35.12,35.41,37.75,39.03,39.78,41.94,42.91,41.47,41.38,39.31,36.28,33.28,30.0,27.56,27.25,27.88,30.69,34.5,38.59,41.88,45.56,48.91,51.69,54.75,57.88,59.25,59.12,59.03,56.94,55.16,52.03,48.88,43.91,40.72,37.31,33.84,32.31,30.19,29.09,28.12,26.69,27.66,28.59,30.25,33.06,35.94,39.25,43.06,45.44,46.94,48.31,47.31,46.5,45.06,44.0,41.78,39.91,38.09,35.09,32.31,30.78,28.84,27.5,28.03,29.34,31.66,32.41,35.12,36.56,36.94,38.44,39.78,40.72,41.12,41.84,42.84,42.28,43.03,42.16,40.69,39.09,37.44,34.84,31.84,31.09,27.84,26.66,25.47,25.88,25.62,26.94,28.69,29.94,30.81,31.69,32.31,34.16,35.41,37.84,40.69,42.0,43.91,43.62,41.53,37.66,34.06,29.41,24.94,21.5,19.84,19.59,20.06,22.75,26.0,29.19,31.78,34.38,35.66,35.88,35.31,36.16,35.69,35.78,36.59,37.31,37.31,36.94,36.44,36.03,35.56,34.88,34.16,33.53,32.66,32.25,31.03,32.38,33.44,34.0,37.16,39.34,40.62,41.88,42.22,41.25,40.66,39.81,38.19,37.47,35.38,34.25,32.06,32.12,31.66,32.41,33.28,34.31,35.91,36.66,35.88,37.09,36.12,36.53,37.12,38.06,39.06,39.97,40.44,39.88,39.72,38.34,37.38,36.94,34.53,33.22,32.03,30.94,30.94,32.25,34.03,37.09,38.66,42.12,43.16,45.41,47.19,47.59,48.0,47.97,46.69,45.03,44.91,44.72,45.47,44.66,46.09,44.41,44.31,44.56,43.78,44.78,45.25,45.44,46.06,46.44,46.56,47.66,47.25,48.06,48.0,47.25,45.97,45.16,44.31,42.81,42.0,41.25,39.81,38.06,36.44,34.09,34.25,33.12,32.41,32.94,32.59,30.84,29.94,30.16,28.81,28.31,28.38,29.62,30.81,34.06,37.66,41.28,45.0,48.22,52.72,53.47,54.44,54.91,52.66,50.75,46.44,42.91,39.38,35.38,34.09,32.16,31.5,31.44,30.81,33.12,34.31,36.25,38.03,38.88,41.09,41.81,42.75,43.97,43.62,42.81,40.66,38.41,34.66,31.09,28.56,27.0,25.94,26.31,27.97,28.53,30.62,32.91,35.16,36.84,39.34,40.0,39.88,38.81,38.16,36.44,35.12,33.56,32.97,32.62,32.44,33.22,32.66,34.06,33.69,33.56,34.69,33.47,33.56,33.44,32.53,32.78,33.38,35.41,37.06,40.78,43.91,46.31,46.88,47.25,48.41,46.53,46.47,44.91,44.22,42.56,42.19,40.97,40.78,41.0,41.0,41.72,42.56,41.97,41.06,39.12,38.44,36.31,35.88,36.31,36.56,37.0,38.44,37.62,37.75,38.31,38.31,38.62,38.97,38.41,38.41,37.31,37.28,36.94,35.91,35.97,34.5,34.81,35.06,34.62,35.84,35.19,35.44,33.62,32.81,31.41,30.25,28.28,25.34,24.44,22.34,21.75,21.62,21.66,21.12,21.66,21.41,21.72,22.31,22.56,23.06,23.75,24.19,25.12,25.94,27.69,29.66,31.91,33.12,34.84,35.56,35.12,34.78,33.5,32.25,32.62,32.31,31.91,32.09,32.16,32.41,32.12,31.97,32.22,33.59,32.56,32.31,33.0,33.72,34.53,35.78,36.81,37.12,36.44,34.84,31.47,29.16,27.5,26.28,26.5,26.19,27.19,25.62,25.81,25.94:22.22,22.75,23.31,24.38,24.94,24.88,23.44,21.62,20.28,18.44,16.06,15.38,14.34,13.28,13.41,13.81,14.31,16.44,15.44,16.16,17.0,17.12,19.62,23.75,27.56,31.44,33.53,34.03,35.12,35.31,34.16,33.0,30.81,28.09,25.75,23.44,22.66,23.25,22.91,23.81,24.56,24.34,25.91,27.19,28.47,29.53,30.75,31.91,32.5,33.94,35.78,36.34,37.19,37.72,36.41,35.22,32.31,28.91,25.47,21.81,19.28,16.19,14.56,12.5,11.62,9.94,8.72,7.91,6.28,4.56,3.28,2.91,3.94,5.66,9.53,11.81,15.16,16.5,17.28,17.59,19.31,19.31,18.5,17.69,15.97,13.03,10.88,10.16,8.66,8.94,8.72,8.53,6.28,4.94,4.03,3.19,2.5,4.19,5.84,8.56,12.66,16.56,20.78,24.0,26.41,28.94,29.94,29.28,27.91,25.97,23.62,20.81,19.34,18.38,17.56,16.66,17.16,17.12,18.03,18.03,18.53,18.88,19.41,19.88,21.34,21.47,22.16,22.19,22.53,23.22,24.38,26.0,26.28,26.34,25.03,23.72,22.03,20.56,19.25,20.59,20.31,20.0,20.56,20.06,18.25,17.56,16.91,15.78,15.28,15.56,16.72,16.78,18.91,19.81,18.94,21.38,21.75,22.44,21.62,20.62,20.94,19.84,20.97,23.0,24.66,26.81,27.06,27.25,25.88,24.28,23.44,22.44,22.47,20.91,21.25,21.16,20.16,21.62,22.44,23.88,24.41,24.59,25.28,23.5,21.53,19.81,16.66,15.78,13.5,12.59,11.09,10.5,9.34,8.94,8.16,7.69,7.59,7.06,7.94,9.0,8.31,9.94,10.88,12.25,13.31,14.19,15.41,16.22,17.0,18.66,19.34,20.06,18.94,17.0,14.44,11.56,9.41,9.69,10.06,10.94,13.16,15.69,16.53,18.66,20.78,22.34,22.56,23.84,22.91,21.88,19.75,18.91,17.25,16.22,17.06,17.56,18.59,18.88,19.19,21.12,20.12,22.19,24.44,27.0,29.69,31.72,30.44,30.0,27.16,24.53,22.19,20.72,20.22,19.72,19.41,16.31,13.78,12.0,8.34,7.91,7.5,7.69,9.44,10.34,11.47,11.72,11.75,12.06,10.94,11.06,12.91,12.66,14.5,16.81,18.84,21.44,23.22,24.44,24.75,24.66,23.91,23.03,22.62,20.78,18.94,19.06,18.22,16.66,17.72,17.47,18.91,19.03,19.41,19.41,18.66,18.16,18.25,19.16,21.06,23.19,23.69,25.75,25.69,25.22,24.81,24.31,22.16,21.34,20.94,19.53,19.22,19.94,19.16,19.31,19.19,19.19,17.94,16.84,15.88,15.66,15.0,14.75,13.47,13.66,12.62,13.34,15.03,17.47,17.91,19.91,19.62,20.34,19.25,19.47,19.38,19.91,20.75,21.12,21.38,21.56,20.94,21.16,21.41,20.44,21.19,20.19,20.72,20.0,21.47,19.31,18.84,17.22,14.28,11.84,9.91,9.06,10.78,11.59,13.53,15.41,15.78,15.72,15.75,14.62,13.06,12.81,10.62,10.75,9.66,9.84,10.69,11.16,10.59,12.16,11.75,11.03,11.19,10.34,8.91,8.41,8.78,8.97,10.75,11.09,12.28,12.44,11.34,11.97,11.22,11.41,11.72,12.44,14.34,14.88,17.41,17.31,19.06,19.56,21.28,23.22,24.38,24.81,24.09,22.31,20.38,17.69,16.06,15.62,15.56,16.44,17.78,18.03,18.47,16.38,13.31,10.09,8.12,6.62,8.06,9.69,11.69,15.72,17.69,20.47,21.56,22.38,23.44,22.59,21.69,21.59,19.88,19.12,17.41,16.78,16.66,14.94,15.0,15.0,14.75,15.53,15.53,16.53,18.06,19.81,22.19,23.81,25.06,26.0,26.66,26.25,25.81,25.84,25.06,23.94,23.72,23.81,22.62,21.47,19.91,17.72,15.94,13.03,12.06,11.56,12.88,14.5,18.56,22.69,26.88,29.97,33.03,35.12,35.72,35.53,36.09,35.5,35.12,35.41,37.75,39.03,39.78,41.94,42.91,41.47,41.38,39.31,36.28,33.28,30.0,27.56,27.25,27.88,30.69,34.5,38.59,41.88,45.56,48.91,51.69,54.75,57.88,59.25,59.12,59.03,56.94,55.16,52.03,48.88,43.91,40.72,37.31,33.84,32.31,30.19,29.09,28.12,26.69,27.66,28.59,30.25,33.06,35.94,39.25,43.06,45.44,46.94,48.31,47.31,46.5,45.06,44.0,41.78,39.91,38.09,35.09,32.31,30.78,28.84,27.5,28.03,29.34,31.66,32.41,35.12,36.56,36.94,38.44,39.78,40.72,41.12,41.84,42.84,42.28,43.03,42.16,40.69,39.09,37.44,34.84,31.84,31.09,27.84,26.66,25.47,25.88,25.62,26.94,28.69,29.94,30.81,31.69,32.31,34.16,35.41,37.84,40.69,42.0,43.91,43.62,41.53,37.66,34.06,29.41,24.94,21.5,19.84,19.59,20.06,22.75,26.0,29.19,31.78,34.38,35.66,35.88,35.31,36.16,35.69,35.78,36.59,37.31,37.31,36.94,36.44,36.03,35.56,34.88,34.16,33.53,32.66,32.25,31.03,32.38,33.44,34.0,37.16,39.34,40.62,41.88,42.22,41.25,40.66,39.81,38.19,37.47,35.38,34.25,32.06,32.12,31.66,32.41,33.28,34.31,35.91,36.66,35.88,37.09,36.12,36.53,37.12,38.06,39.06,39.97,40.44,39.88,39.72,38.34,37.38,36.94,34.53,33.22,32.03,30.94,30.94,32.25,34.03,37.09,38.66,42.12,43.16,45.41,47.19,47.59,48.0,47.97,46.69,45.03,44.91,44.72,45.47,44.66,46.09,44.41,44.31,44.56,43.78,44.78,45.25,45.44,46.06,46.44,46.56,47.66,47.25,48.06,48.0,47.25,45.97,45.16,44.31,42.81,42.0,41.25,39.81,38.06,36.44,34.09,34.25,33.12,32.41,32.94,32.59,30.84,29.94,30.16,28.81,28.31,28.38,29.62,30.81,34.06,37.66,41.28,45.0,48.22,52.72,53.47,54.44,54.91,52.66,50.75,46.44,42.91,39.38,35.38,34.09,32.16,31.5,31.44,30.81,33.12,34.31,36.25,38.03,38.88,41.09,41.81,42.75,43.97,43.62,42.81,40.66,38.41,34.66,31.09,28.56,27.0,25.94,26.31,27.97,28.53,30.62,32.91,35.16,36.84,39.34,40.0,39.88,38.81,38.16,36.44,35.12,33.56,32.97,32.62,32.44,33.22,32.66,34.06,33.69,33.56,34.69,33.47,33.56,33.44,32.53,32.78,33.38,35.41,37.06,40.78,43.91,46.31,46.88,47.25,48.41,46.53,46.47,44.91,44.22,42.56,42.19,40.97,40.78,41.0,41.0,41.72,42.56,41.97,41.06,39.12,38.44,36.31,35.88,36.31,36.56,37.0,38.44,37.62,37.75,38.31,38.31,38.62,38.97,38.41,38.41,37.31,37.28,36.94,35.91,35.97,34.5,34.81,35.06,34.62,35.84,35.19,35.44,33.62,32.81,31.41,30.25,28.28,25.34,24.44,22.34,21.75,21.62,21.66,21.12,21.66,21.41,21.72,22.31,22.56,23.06,23.75,24.19,25.12,25.94,27.69,29.66,31.91,33.12,34.84,35.56,35.12,34.78,33.5,32.25,32.62,32.31,31.91,32.09,32.16,32.41,32.12,31.97,32.22,33.59,32.56,32.31,33.0,33.72,34.53,35.78,36.81,37.12,36.44,34.84,31.47,29.16,27.5,26.28,26.5,26.19,27.19,25.62,25.81,25.94,-24.97,-23.81,-25.16,-24.0,-21.53,-18.91:23.44,21.62,20.28,18.44,16.06,15.38,14.34,13.28,13.41,13.81,14.31,16.44,15.44,16.16,17.0,17.12,19.62,23.75,27.56,31.44,33.53,34.03,35.12,35.31,34.16,33.0,30.81,28.09,25.75,23.44,22.66,23.25,22.91,23.81,24.56,24.34,25.91,27.19,28.47,29.53,30.75,31.91,32.5,33.94,35.78,36.34,37.19,37.72,36.41,35.22,32.31,28.91,25.47,21.81,19.28,16.19,14.56,12.5,11.62,9.94,8.72,7.91,6.28,4.56,3.28,2.91,3.94,5.66,9.53,11.81,15.16,16.5,17.28,17.59,19.31,19.31,18.5,17.69,15.97,13.03,10.88,10.16,8.66,8.94,8.72,8.53,6.28,4.94,4.03,3.19,2.5,4.19,5.84,8.56,12.66,16.56,20.78,24.0,26.41,28.94,29.94,29.28,27.91,25.97,23.62,20.81,19.34,18.38,17.56,16.66,17.16,17.12,18.03,18.03,18.53,18.88,19.41,19.88,21.34,21.47,22.16,22.19,22.53,23.22,24.38,26.0,26.28,26.34,25.03,23.72,22.03,20.56,19.25,20.59,20.31,20.0,20.56,20.06,18.25,17.56,16.91,15.78,15.28,15.56,16.72,16.78,18.91,19.81,18.94,21.38,21.75,22.44,21.62,20.62,20.94,19.84,20.97,23.0,24.66,26.81,27.06,27.25,25.88,24.28,23.44,22.44,22.47,20.91,21.25,21.16,20.16,21.62,22.44,23.88,24.41,24.59,25.28,23.5,21.53,19.81,16.66,15.78,13.5,12.59,11.09,10.5,9.34,8.94,8.16,7.69,7.59,7.06,7.94,9.0,8.31,9.94,10.88,12.25,13.31,14.19,15.41,16.22,17.0,18.66,19.34,20.06,18.94,17.0,14.44,11.56,9.41,9.69,10.06,10.94,13.16,15.69,16.53,18.66,20.78,22.34,22.56,23.84,22.91,21.88,19.75,18.91,17.25,16.22,17.06,17.56,18.59,18.88,19.19,21.12,20.12,22.19,24.44,27.0,29.69,31.72,30.44,30.0,27.16,24.53,22.19,20.72,20.22,19.72,19.41,16.31,13.78,12.0,8.34,7.91,7.5,7.69,9.44,10.34,11.47,11.72,11.75,12.06,10.94,11.06,12.91,12.66,14.5,16.81,18.84,21.44,23.22,24.44,24.75,24.66,23.91,23.03,22.62,20.78,18.94,19.06,18.22,16.66,17.72,17.47,18.91,19.03,19.41,19.41,18.66,18.16,18.25,19.16,21.06,23.19,23.69,25.75,25.69,25.22,24.81,24.31,22.16,21.34,20.94,19.53,19.22,19.94,19.16,19.31,19.19,19.19,17.94,16.84,15.88,15.66,15.0,14.75,13.47,13.66,12.62,13.34,15.03,17.47,17.91,19.91,19.62,20.34,19.25,19.47,19.38,19.91,20.75,21.12,21.38,21.56,20.94,21.16,21.41,20.44,21.19,20.19,20.72,20.0,21.47,19.31,18.84,17.22,14.28,11.84,9.91,9.06,10.78,11.59,13.53,15.41,15.78,15.72,15.75,14.62,13.06,12.81,10.62,10.75,9.66,9.84,10.69,11.16,10.59,12.16,11.75,11.03,11.19,10.34,8.91,8.41,8.78,8.97,10.75,11.09,12.28,12.44,11.34,11.97,11.22,11.41,11.72,12.44,14.34,14.88,17.41,17.31,19.06,19.56,21.28,23.22,24.38,24.81,24.09,22.31,20.38,17.69,16.06,15.62,15.56,16.44,17.78,18.03,18.47,16.38,13.31,10.09,8.12,6.62,8.06,9.69,11.69,15.72,17.69,20.47,21.56,22.38,23.44,22.59,21.69,21.59,19.88,19.12,17.41,16.78,16.66,14.94,15.0,15.0,14.75,15.53,15.53,16.53,18.06,19.81,22.19,23.81,25.06,26.0,26.66,26.25,25.81,25.84,25.06,23.94,23.72,23.81,22.62,21.47,19.91,17.72,15.94,13.03,12.06,11.56,12.88,14.5,18.56,22.69,26.88,29.97,33.03,35.12,35.72,35.53,36.09,35.5,35.12,35.41,37.75,39.03,39.78,41.94,42.91,41.47,41.38,39.31,36.28,33.28,30.0,27.56,27.25,27.88,30.69,34.5,38.59,41.88,45.56,48.91,51.69,54.75,57.88,59.25,59.12,59.03,56.94,55.16,52.03,48.88,43.91,40.72,37.31,33.84,32.31,30.19,29.09,28.12,26.69,27.66,28.59,30.25,33.06,35.94,39.25,43.06,45.44,46.94,48.31,47.31,46.5,45.06,44.0,41.78,39.91,38.09,35.09,32.31,30.78,28.84,27.5,28.03,29.34,31.66,32.41,35.12,36.56,36.94,38.44,39.78,40.72,41.12,41.84,42.84,42.28,43.03,42.16,40.69,39.09,37.44,34.84,31.84,31.09,27.84,26.66,25.47,25.88,25.62,26.94,28.69,29.94,30.81,31.69,32.31,34.16,35.41,37.84,40.69,42.0,43.91,43.62,41.53,37.66,34.06,29.41,24.94,21.5,19.84,19.59,20.06,22.75,26.0,29.19,31.78,34.38,35.66,35.88,35.31,36.16,35.69,35.78,36.59,37.31,37.31,36.94,36.44,36.03,35.56,34.88,34.16,33.53,32.66,32.25,31.03,32.38,33.44,34.0,37.16,39.34,40.62,41.88,42.22,41.25,40.66,39.81,38.19,37.47,35.38,34.25,32.06,32.12,31.66,32.41,33.28,34.31,35.91,36.66,35.88,37.09,36.12,36.53,37.12,38.06,39.06,39.97,40.44,39.88,39.72,38.34,37.38,36.94,34.53,33.22,32.03,30.94,30.94,32.25,34.03,37.09,38.66,42.12,43.16,45.41,47.19,47.59,48.0,47.97,46.69,45.03,44.91,44.72,45.47,44.66,46.09,44.41,44.31,44.56,43.78,44.78,45.25,45.44,46.06,46.44,46.56,47.66,47.25,48.06,48.0,47.25,45.97,45.16,44.31,42.81,42.0,41.25,39.81,38.06,36.44,34.09,34.25,33.12,32.41,32.94,32.59,30.84,29.94,30.16,28.81,28.31,28.38,29.62,30.81,34.06,37.66,41.28,45.0,48.22,52.72,53.47,54.44,54.91,52.66,50.75,46.44,42.91,39.38,35.38,34.09,32.16,31.5,31.44,30.81,33.12,34.31,36.25,38.03,38.88,41.09,41.81,42.75,43.97,43.62,42.81,40.66,38.41,34.66,31.09,28.56,27.0,25.94,26.31,27.97,28.53,30.62,32.91,35.16,36.84,39.34,40.0,39.88,38.81,38.16,36.44,35.12,33.56,32.97,32.62,32.44,33.22,32.66,34.06,33.69,33.56,34.69,33.47,33.56,33.44,32.53,32.78,33.38,35.41,37.06,40.78,43.91,46.31,46.88,47.25,48.41,46.53,46.47,44.91,44.22,42.56,42.19,40.97,40.78,41.0,41.0,41.72,42.56,41.97,41.06,39.12,38.44,36.31,35.88,36.31,36.56,37.0,38.44,37.62,37.75,38.31,38.31,38.62,38.97,38.41,38.41,37.31,37.28,36.94,35.91,35.97,34.5,34.81,35.06,34.62,35.84,35.19,35.44,33.62,32.81,31.41,30.25,28.28,25.34,24.44,22.34,21.75,21.62,21.66,21.12,21.66,21.41,21.72,22.31,22.56,23.06,23.75,24.19,25.12,25.94,27.69,29.66,31.91,33.12,34.84,35.56,35.12,34.78,33.5,32.25,32.62,32.31,31.91,32.09,32.16,32.41,32.12,31.97,32.22,33.59,32.56,32.31,33.0,33.72,34.53,35.78,36.81,37.12,36.44,34.84,31.47,29.16,27.5,26.28,26.5,26.19,27.19,25.62,25.81,25.94,-24.97,-23.81,-25.16,-24.0,-21.53,-18.91,-16.06,-12.84,-9.41,-8.06,-6.88,-6.97:14.34,13.28,13.41,13.81,14.31,16.44,15.44,16.16,17.0,17.12,19.62,23.75,27.56,31.44,33.53,34.03,35.12,35.31,34.16,33.0,30.81,28.09,25.75,23.44,22.66,23.25,22.91,23.81,24.56,24.34,25.91,27.19,28.47,29.53,30.75,31.91,32.5,33.94,35.78,36.34,37.19,37.72,36.41,35.22,32.31,28.91,25.47,21.81,19.28,16.19,14.56,12.5,11.62,9.94,8.72,7.91,6.28,4.56,3.28,2.91,3.94,5.66,9.53,11.81,15.16,16.5,17.28,17.59,19.31,19.31,18.5,17.69,15.97,13.03,10.88,10.16,8.66,8.94,8.72,8.53,6.28,4.94,4.03,3.19,2.5,4.19,5.84,8.56,12.66,16.56,20.78,24.0,26.41,28.94,29.94,29.28,27.91,25.97,23.62,20.81,19.34,18.38,17.56,16.66,17.16,17.12,18.03,18.03,18.53,18.88,19.41,19.88,21.34,21.47,22.16,22.19,22.53,23.22,24.38,26.0,26.28,26.34,25.03,23.72,22.03,20.56,19.25,20.59,20.31,20.0,20.56,20.06,18.25,17.56,16.91,15.78,15.28,15.56,16.72,16.78,18.91,19.81,18.94,21.38,21.75,22.44,21.62,20.62,20.94,19.84,20.97,23.0,24.66,26.81,27.06,27.25,25.88,24.28,23.44,22.44,22.47,20.91,21.25,21.16,20.16,21.62,22.44,23.88,24.41,24.59,25.28,23.5,21.53,19.81,16.66,15.78,13.5,12.59,11.09,10.5,9.34,8.94,8.16,7.69,7.59,7.06,7.94,9.0,8.31,9.94,10.88,12.25,13.31,14.19,15.41,16.22,17.0,18.66,19.34,20.06,18.94,17.0,14.44,11.56,9.41,9.69,10.06,10.94,13.16,15.69,16.53,18.66,20.78,22.34,22.56,23.84,22.91,21.88,19.75,18.91,17.25,16.22,17.06,17.56,18.59,18.88,19.19,21.12,20.12,22.19,24.44,27.0,29.69,31.72,30.44,30.0,27.16,24.53,22.19,20.72,20.22,19.72,19.41,16.31,13.78,12.0,8.34,7.91,7.5,7.69,9.44,10.34,11.47,11.72,11.75,12.06,10.94,11.06,12.91,12.66,14.5,16.81,18.84,21.44,23.22,24.44,24.75,24.66,23.91,23.03,22.62,20.78,18.94,19.06,18.22,16.66,17.72,17.47,18.91,19.03,19.41,19.41,18.66,18.16,18.25,19.16,21.06,23.19,23.69,25.75,25.69,25.22,24.81,24.31,22.16,21.34,20.94,19.53,19.22,19.94,19.16,19.31,19.19,19.19,17.94,16.84,15.88,15.66,15.0,14.75,13.47,13.66,12.62,13.34,15.03,17.47,17.91,19.91,19.62,20.34,19.25,19.47,19.38,19.91,20.75,21.12,21.38,21.56,20.94,21.16,21.41,20.44,21.19,20.19,20.72,20.0,21.47,19.31,18.84,17.22,14.28,11.84,9.91,9.06,10.78,11.59,13.53,15.41,15.78,15.72,15.75,14.62,13.06,12.81,10.62,10.75,9.66,9.84,10.69,11.16,10.59,12.16,11.75,11.03,11.19,10.34,8.91,8.41,8.78,8.97,10.75,11.09,12.28,12.44,11.34,11.97,11.22,11.41,11.72,12.44,14.34,14.88,17.41,17.31,19.06,19.56,21.28,23.22,24.38,24.81,24.09,22.31,20.38,17.69,16.06,15.62,15.56,16.44,17.78,18.03,18.47,16.38,13.31,10.09,8.12,6.62,8.06,9.69,11.69,15.72,17.69,20.47,21.56,22.38,23.44,22.59,21.69,21.59,19.88,19.12,17.41,16.78,16.66,14.94,15.0,15.0,14.75,15.53,15.53,16.53,18.06,19.81,22.19,23.81,25.06,26.0,26.66,26.25,25.81,25.84,25.06,23.94,23.72,23.81,22.62,21.47,19.91,17.72,15.94,13.03,12.06,11.56,12.88,14.5,18.56,22.69,26.88,29.97,33.03,35.12,35.72,35.53,36.09,35.5,35.12,35.41,37.75,39.03,39.78,41.94,42.91,41.47,41.38,39.31,36.28,33.28,30.0,27.56,27.25,27.88,30.69,34.5,38.59,41.88,45.56,48.91,51.69,54.75,57.88,59.25,59.12,59.03,56.94,55.16,52.03,48.88,43.91,40.72,37.31,33.84,32.31,30.19,29.09,28.12,26.69,27.66,28.59,30.25,33.06,35.94,39.25,43.06,45.44,46.94,48.31,47.31,46.5,45.06,44.0,41.78,39.91,38.09,35.09,32.31,30.78,28.84,27.5,28.03,29.34,31.66,32.41,35.12,36.56,36.94,38.44,39.78,40.72,41.12,41.84,42.84,42.28,43.03,42.16,40.69,39.09,37.44,34.84,31.84,31.09,27.84,26.66,25.47,25.88,25.62,26.94,28.69,29.94,30.81,31.69,32.31,34.16,35.41,37.84,40.69,42.0,43.91,43.62,41.53,37.66,34.06,29.41,24.94,21.5,19.84,19.59,20.06,22.75,26.0,29.19,31.78,34.38,35.66,35.88,35.31,36.16,35.69,35.78,36.59,37.31,37.31,36.94,36.44,36.03,35.56,34.88,34.16,33.53,32.66,32.25,31.03,32.38,33.44,34.0,37.16,39.34,40.62,41.88,42.22,41.25,40.66,39.81,38.19,37.47,35.38,34.25,32.06,32.12,31.66,32.41,33.28,34.31,35.91,36.66,35.88,37.09,36.12,36.53,37.12,38.06,39.06,39.97,40.44,39.88,39.72,38.34,37.38,36.94,34.53,33.22,32.03,30.94,30.94,32.25,34.03,37.09,38.66,42.12,43.16,45.41,47.19,47.59,48.0,47.97,46.69,45.03,44.91,44.72,45.47,44.66,46.09,44.41,44.31,44.56,43.78,44.78,45.25,45.44,46.06,46.44,46.56,47.66,47.25,48.06,48.0,47.25,45.97,45.16,44.31,42.81,42.0,41.25,39.81,38.06,36.44,34.09,34.25,33.12,32.41,32.94,32.59,30.84,29.94,30.16,28.81,28.31,28.38,29.62,30.81,34.06,37.66,41.28,45.0,48.22,52.72,53.47,54.44,54.91,52.66,50.75,46.44,42.91,39.38,35.38,34.09,32.16,31.5,31.44,30.81,33.12,34.31,36.25,38.03,38.88,41.09,41.81,42.75,43.97,43.62,42.81,40.66,38.41,34.66,31.09,28.56,27.0,25.94,26.31,27.97,28.53,30.62,32.91,35.16,36.84,39.34,40.0,39.88,38.81,38.16,36.44,35.12,33.56,32.97,32.62,32.44,33.22,32.66,34.06,33.69,33.56,34.69,33.47,33.56,33.44,32.53,32.78,33.38,35.41,37.06,40.78,43.91,46.31,46.88,47.25,48.41,46.53,46.47,44.91,44.22,42.56,42.19,40.97,40.78,41.0,41.0,41.72,42.56,41.97,41.06,39.12,38.44,36.31,35.88,36.31,36.56,37.0,38.44,37.62,37.75,38.31,38.31,38.62,38.97,38.41,38.41,37.31,37.28,36.94,35.91,35.97,34.5,34.81,35.06,34.62,35.84,35.19,35.44,33.62,32.81,31.41,30.25,28.28,25.34,24.44,22.34,21.75,21.62,21.66,21.12,21.66,21.41,21.72,22.31,22.56,23.06,23.75,24.19,25.12,25.94,27.69,29.66,31.91,33.12,34.84,35.56,35.12,34.78,33.5,32.25,32.62,32.31,31.91,32.09,32.16,32.41,32.12,31.97,32.22,33.59,32.56,32.31,33.0,33.72,34.53,35.78,36.81,37.12,36.44,34.84,31.47,29.16,27.5,26.28,26.5,26.19,27.19,25.62,25.81,25.94,-24.97,-23.81,-25.16,-24.0,-21.53,-18.91,-16.06,-12.84,-9.41,-8.06,-6.88,-6.97,-8.09,-10.97,-12.59,-15.28,-18.47,-19.75:15.44,16.16,17.0,17.12,19.62,23.75,27.56,31.44,33.53,34.03,35.12,35.31,34.16,33.0,30.81,28.09,25.75,23.44,22.66,23.25,22.91,23.81,24.56,24.34,25.91,27.19,28.47,29.53,30.75,31.91,32.5,33.94,35.78,36.34,37.19,37.72,36.41,35.22,32.31,28.91,25.47,21.81,19.28,16.19,14.56,12.5,11.62,9.94,8.72,7.91,6.28,4.56,3.28,2.91,3.94,5.66,9.53,11.81,15.16,16.5,17.28,17.59,19.31,19.31,18.5,17.69,15.97,13.03,10.88,10.16,8.66,8.94,8.72,8.53,6.28,4.94,4.03,3.19,2.5,4.19,5.84,8.56,12.66,16.56,20.78,24.0,26.41,28.94,29.94,29.28,27.91,25.97,23.62,20.81,19.34,18.38,17.56,16.66,17.16,17.12,18.03,18.03,18.53,18.88,19.41,19.88,21.34,21.47,22.16,22.19,22.53,23.22,24.38,26.0,26.28,26.34,25.03,23.72,22.03,20.56,19.25,20.59,20.31,20.0,20.56,20.06,18.25,17.56,16.91,15.78,15.28,15.56,16.72,16.78,18.91,19.81,18.94,21.38,21.75,22.44,21.62,20.62,20.94,19.84,20.97,23.0,24.66,26.81,27.06,27.25,25.88,24.28,23.44,22.44,22.47,20.91,21.25,21.16,20.16,21.62,22.44,23.88,24.41,24.59,25.28,23.5,21.53,19.81,16.66,15.78,13.5,12.59,11.09,10.5,9.34,8.94,8.16,7.69,7.59,7.06,7.94,9.0,8.31,9.94,10.88,12.25,13.31,14.19,15.41,16.22,17.0,18.66,19.34,20.06,18.94,17.0,14.44,11.56,9.41,9.69,10.06,10.94,13.16,15.69,16.53,18.66,20.78,22.34,22.56,23.84,22.91,21.88,19.75,18.91,17.25,16.22,17.06,17.56,18.59,18.88,19.19,21.12,20.12,22.19,24.44,27.0,29.69,31.72,30.44,30.0,27.16,24.53,22.19,20.72,20.22,19.72,19.41,16.31,13.78,12.0,8.34,7.91,7.5,7.69,9.44,10.34,11.47,11.72,11.75,12.06,10.94,11.06,12.91,12.66,14.5,16.81,18.84,21.44,23.22,24.44,24.75,24.66,23.91,23.03,22.62,20.78,18.94,19.06,18.22,16.66,17.72,17.47,18.91,19.03,19.41,19.41,18.66,18.16,18.25,19.16,21.06,23.19,23.69,25.75,25.69,25.22,24.81,24.31,22.16,21.34,20.94,19.53,19.22,19.94,19.16,19.31,19.19,19.19,17.94,16.84,15.88,15.66,15.0,14.75,13.47,13.66,12.62,13.34,15.03,17.47,17.91,19.91,19.62,20.34,19.25,19.47,19.38,19.91,20.75,21.12,21.38,21.56,20.94,21.16,21.41,20.44,21.19,20.19,20.72,20.0,21.47,19.31,18.84,17.22,14.28,11.84,9.91,9.06,10.78,11.59,13.53,15.41,15.78,15.72,15.75,14.62,13.06,12.81,10.62,10.75,9.66,9.84,10.69,11.16,10.59,12.16,11.75,11.03,11.19,10.34,8.91,8.41,8.78,8.97,10.75,11.09,12.28,12.44,11.34,11.97,11.22,11.41,11.72,12.44,14.34,14.88,17.41,17.31,19.06,19.56,21.28,23.22,24.38,24.81,24.09,22.31,20.38,17.69,16.06,15.62,15.56,16.44,17.78,18.03,18.47,16.38,13.31,10.09,8.12,6.62,8.06,9.69,11.69,15.72,17.69,20.47,21.56,22.38,23.44,22.59,21.69,21.59,19.88,19.12,17.41,16.78,16.66,14.94,15.0,15.0,14.75,15.53,15.53,16.53,18.06,19.81,22.19,23.81,25.06,26.0,26.66,26.25,25.81,25.84,25.06,23.94,23.72,23.81,22.62,21.47,19.91,17.72,15.94,13.03,12.06,11.56,12.88,14.5,18.56,22.69,26.88,29.97,33.03,35.12,35.72,35.53,36.09,35.5,35.12,35.41,37.75,39.03,39.78,41.94,42.91,41.47,41.38,39.31,36.28,33.28,30.0,27.56,27.25,27.88,30.69,34.5,38.59,41.88,45.56,48.91,51.69,54.75,57.88,59.25,59.12,59.03,56.94,55.16,52.03,48.88,43.91,40.72,37.31,33.84,32.31,30.19,29.09,28.12,26.69,27.66,28.59,30.25,33.06,35.94,39.25,43.06,45.44,46.94,48.31,47.31,46.5,45.06,44.0,41.78,39.91,38.09,35.09,32.31,30.78,28.84,27.5,28.03,29.34,31.66,32.41,35.12,36.56,36.94,38.44,39.78,40.72,41.12,41.84,42.84,42.28,43.03,42.16,40.69,39.09,37.44,34.84,31.84,31.09,27.84,26.66,25.47,25.88,25.62,26.94,28.69,29.94,30.81,31.69,32.31,34.16,35.41,37.84,40.69,42.0,43.91,43.62,41.53,37.66,34.06,29.41,24.94,21.5,19.84,19.59,20.06,22.75,26.0,29.19,31.78,34.38,35.66,35.88,35.31,36.16,35.69,35.78,36.59,37.31,37.31,36.94,36.44,36.03,35.56,34.88,34.16,33.53,32.66,32.25,31.03,32.38,33.44,34.0,37.16,39.34,40.62,41.88,42.22,41.25,40.66,39.81,38.19,37.47,35.38,34.25,32.06,32.12,31.66,32.41,33.28,34.31,35.91,36.66,35.88,37.09,36.12,36.53,37.12,38.06,39.06,39.97,40.44,39.88,39.72,38.34,37.38,36.94,34.53,33.22,32.03,30.94,30.94,32.25,34.03,37.09,38.66,42.12,43.16,45.41,47.19,47.59,48.0,47.97,46.69,45.03,44.91,44.72,45.47,44.66,46.09,44.41,44.31,44.56,43.78,44.78,45.25,45.44,46.06,46.44,46.56,47.66,47.25,48.06,48.0,47.25,45.97,45.16,44.31,42.81,42.0,41.25,39.81,38.06,36.44,34.09,34.25,33.12,32.41,32.94,32.59,30.84,29.94,30.16,28.81,28.31,28.38,29.62,30.81,34.06,37.66,41.28,45.0,48.22,52.72,53.47,54.44,54.91,52.66,50.75,46.44,42.91,39.38,35.38,34.09,32.16,31.5,31.44,30.81,33.12,34.31,36.25,38.03,38.88,41.09,41.81,42.75,43.97,43.62,42.81,40.66,38.41,34.66,31.09,28.56,27.0,25.94,26.31,27.97,28.53,30.62,32.91,35.16,36.84,39.34,40.0,39.88,38.81,38.16,36.44,35.12,33.56,32.97,32.62,32.44,33.22,32.66,34.06,33.69,33.56,34.69,33.47,33.56,33.44,32.53,32.78,33.38,35.41,37.06,40.78,43.91,46.31,46.88,47.25,48.41,46.53,46.47,44.91,44.22,42.56,42.19,40.97,40.78,41.0,41.0,41.72,42.56,41.97,41.06,39.12,38.44,36.31,35.88,36.31,36.56,37.0,38.44,37.62,37.75,38.31,38.31,38.62,38.97,38.41,38.41,37.31,37.28,36.94,35.91,35.97,34.5,34.81,35.06,34.62,35.84,35.19,35.44,33.62,32.81,31.41,30.25,28.28,25.34,24.44,22.34,21.75,21.62,21.66,21.12,21.66,21.41,21.72,22.31,22.56,23.06,23.75,24.19,25.12,25.94,27.69,29.66,31.91,33.12,34.84,35.56,35.12,34.78,33.5,32.25,32.62,32.31,31.91,32.09,32.16,32.41,32.12,31.97,32.22,33.59,32.56,32.31,33.0,33.72,34.53,35.78,36.81,37.12,36.44,34.84,31.47,29.16,27.5,26.28,26.5,26.19,27.19,25.62,25.81,25.94,-24.97,-23.81,-25.16,-24.0,-21.53,-18.91,-16.06,-12.84,-9.41,-8.06,-6.88,-6.97,-8.09,-10.97,-12.59,-15.28,-18.47,-19.75,-21.34,-22.66,-22.5,-23.16,-21.78,-21.41:27.56,31.44,33.53,34.03,35.12,35.31,34.16,33.0,30.81,28.09,25.75,23.44,22.66,23.25,22.91,23.81,24.56,24.34,25.91,27.19,28.47,29.53,30.75,31.91,32.5,33.94,35.78,36.34,37.19,37.72,36.41,35.22,32.31,28.91,25.47,21.81,19.28,16.19,14.56,12.5,11.62,9.94,8.72,7.91,6.28,4.56,3.28,2.91,3.94,5.66,9.53,11.81,15.16,16.5,17.28,17.59,19.31,19.31,18.5,17.69,15.97,13.03,10.88,10.16,8.66,8.94,8.72,8.53,6.28,4.94,4.03,3.19,2.5,4.19,5.84,8.56,12.66,16.56,20.78,24.0,26.41,28.94,29.94,29.28,27.91,25.97,23.62,20.81,19.34,18.38,17.56,16.66,17.16,17.12,18.03,18.03,18.53,18.88,19.41,19.88,21.34,21.47,22.16,22.19,22.53,23.22,24.38,26.0,26.28,26.34,25.03,23.72,22.03,20.56,19.25,20.59,20.31,20.0,20.56,20.06,18.25,17.56,16.91,15.78,15.28,15.56,16.72,16.78,18.91,19.81,18.94,21.38,21.75,22.44,21.62,20.62,20.94,19.84,20.97,23.0,24.66,26.81,27.06,27.25,25.88,24.28,23.44,22.44,22.47,20.91,21.25,21.16,20.16,21.62,22.44,23.88,24.41,24.59,25.28,23.5,21.53,19.81,16.66,15.78,13.5,12.59,11.09,10.5,9.34,8.94,8.16,7.69,7.59,7.06,7.94,9.0,8.31,9.94,10.88,12.25,13.31,14.19,15.41,16.22,17.0,18.66,19.34,20.06,18.94,17.0,14.44,11.56,9.41,9.69,10.06,10.94,13.16,15.69,16.53,18.66,20.78,22.34,22.56,23.84,22.91,21.88,19.75,18.91,17.25,16.22,17.06,17.56,18.59,18.88,19.19,21.12,20.12,22.19,24.44,27.0,29.69,31.72,30.44,30.0,27.16,24.53,22.19,20.72,20.22,19.72,19.41,16.31,13.78,12.0,8.34,7.91,7.5,7.69,9.44,10.34,11.47,11.72,11.75,12.06,10.94,11.06,12.91,12.66,14.5,16.81,18.84,21.44,23.22,24.44,24.75,24.66,23.91,23.03,22.62,20.78,18.94,19.06,18.22,16.66,17.72,17.47,18.91,19.03,19.41,19.41,18.66,18.16,18.25,19.16,21.06,23.19,23.69,25.75,25.69,25.22,24.81,24.31,22.16,21.34,20.94,19.53,19.22,19.94,19.16,19.31,19.19,19.19,17.94,16.84,15.88,15.66,15.0,14.75,13.47,13.66,12.62,13.34,15.03,17.47,17.91,19.91,19.62,20.34,19.25,19.47,19.38,19.91,20.75,21.12,21.38,21.56,20.94,21.16,21.41,20.44,21.19,20.19,20.72,20.0,21.47,19.31,18.84,17.22,14.28,11.84,9.91,9.06,10.78,11.59,13.53,15.41,15.78,15.72,15.75,14.62,13.06,12.81,10.62,10.75,9.66,9.84,10.69,11.16,10.59,12.16,11.75,11.03,11.19,10.34,8.91,8.41,8.78,8.97,10.75,11.09,12.28,12.44,11.34,11.97,11.22,11.41,11.72,12.44,14.34,14.88,17.41,17.31,19.06,19.56,21.28,23.22,24.38,24.81,24.09,22.31,20.38,17.69,16.06,15.62,15.56,16.44,17.78,18.03,18.47,16.38,13.31,10.09,8.12,6.62,8.06,9.69,11.69,15.72,17.69,20.47,21.56,22.38,23.44,22.59,21.69,21.59,19.88,19.12,17.41,16.78,16.66,14.94,15.0,15.0,14.75,15.53,15.53,16.53,18.06,19.81,22.19,23.81,25.06,26.0,26.66,26.25,25.81,25.84,25.06,23.94,23.72,23.81,22.62,21.47,19.91,17.72,15.94,13.03,12.06,11.56,12.88,14.5,18.56,22.69,26.88,29.97,33.03,35.12,35.72,35.53,36.09,35.5,35.12,35.41,37.75,39.03,39.78,41.94,42.91,41.47,41.38,39.31,36.28,33.28,30.0,27.56,27.25,27.88,30.69,34.5,38.59,41.88,45.56,48.91,51.69,54.75,57.88,59.25,59.12,59.03,56.94,55.16,52.03,48.88,43.91,40.72,37.31,33.84,32.31,30.19,29.09,28.12,26.69,27.66,28.59,30.25,33.06,35.94,39.25,43.06,45.44,46.94,48.31,47.31,46.5,45.06,44.0,41.78,39.91,38.09,35.09,32.31,30.78,28.84,27.5,28.03,29.34,31.66,32.41,35.12,36.56,36.94,38.44,39.78,40.72,41.12,41.84,42.84,42.28,43.03,42.16,40.69,39.09,37.44,34.84,31.84,31.09,27.84,26.66,25.47,25.88,25.62,26.94,28.69,29.94,30.81,31.69,32.31,34.16,35.41,37.84,40.69,42.0,43.91,43.62,41.53,37.66,34.06,29.41,24.94,21.5,19.84,19.59,20.06,22.75,26.0,29.19,31.78,34.38,35.66,35.88,35.31,36.16,35.69,35.78,36.59,37.31,37.31,36.94,36.44,36.03,35.56,34.88,34.16,33.53,32.66,32.25,31.03,32.38,33.44,34.0,37.16,39.34,40.62,41.88,42.22,41.25,40.66,39.81,38.19,37.47,35.38,34.25,32.06,32.12,31.66,32.41,33.28,34.31,35.91,36.66,35.88,37.09,36.12,36.53,37.12,38.06,39.06,39.97,40.44,39.88,39.72,38.34,37.38,36.94,34.53,33.22,32.03,30.94,30.94,32.25,34.03,37.09,38.66,42.12,43.16,45.41,47.19,47.59,48.0,47.97,46.69,45.03,44.91,44.72,45.47,44.66,46.09,44.41,44.31,44.56,43.78,44.78,45.25,45.44,46.06,46.44,46.56,47.66,47.25,48.06,48.0,47.25,45.97,45.16,44.31,42.81,42.0,41.25,39.81,38.06,36.44,34.09,34.25,33.12,32.41,32.94,32.59,30.84,29.94,30.16,28.81,28.31,28.38,29.62,30.81,34.06,37.66,41.28,45.0,48.22,52.72,53.47,54.44,54.91,52.66,50.75,46.44,42.91,39.38,35.38,34.09,32.16,31.5,31.44,30.81,33.12,34.31,36.25,38.03,38.88,41.09,41.81,42.75,43.97,43.62,42.81,40.66,38.41,34.66,31.09,28.56,27.0,25.94,26.31,27.97,28.53,30.62,32.91,35.16,36.84,39.34,40.0,39.88,38.81,38.16,36.44,35.12,33.56,32.97,32.62,32.44,33.22,32.66,34.06,33.69,33.56,34.69,33.47,33.56,33.44,32.53,32.78,33.38,35.41,37.06,40.78,43.91,46.31,46.88,47.25,48.41,46.53,46.47,44.91,44.22,42.56,42.19,40.97,40.78,41.0,41.0,41.72,42.56,41.97,41.06,39.12,38.44,36.31,35.88,36.31,36.56,37.0,38.44,37.62,37.75,38.31,38.31,38.62,38.97,38.41,38.41,37.31,37.28,36.94,35.91,35.97,34.5,34.81,35.06,34.62,35.84,35.19,35.44,33.62,32.81,31.41,30.25,28.28,25.34,24.44,22.34,21.75,21.62,21.66,21.12,21.66,21.41,21.72,22.31,22.56,23.06,23.75,24.19,25.12,25.94,27.69,29.66,31.91,33.12,34.84,35.56,35.12,34.78,33.5,32.25,32.62,32.31,31.91,32.09,32.16,32.41,32.12,31.97,32.22,33.59,32.56,32.31,33.0,33.72,34.53,35.78,36.81,37.12,36.44,34.84,31.47,29.16,27.5,26.28,26.5,26.19,27.19,25.62,25.81,25.94,-24.97,-23.81,-25.16,-24.0,-21.53,-18.91,-16.06,-12.84,-9.41,-8.06,-6.88,-6.97,-8.09,-10.97,-12.59,-15.28,-18.47,-19.75,-21.34,-22.66,-22.5,-23.16,-21.78,-21.41,-21.09,-19.12,-17.78,-15.34,-11.84,-7.09:negativity
21.56,24.09,23.44,20.44,17.03,12.75,11.0,9.19,9.88,10.91,12.91,14.97,15.78,17.78,18.78,20.5,20.25,20.16,19.97,18.91,17.47,17.31,17.66,18.22,20.12,20.69,21.62,22.06,22.19,22.0,23.03,24.44,26.84,28.47,30.44,32.19,33.44,33.38,33.47,33.06,32.94,33.28,33.81,34.44,34.94,36.62,35.28,35.81,35.91,34.81,33.47,31.16,29.38,26.91,25.12,24.06,23.34,22.75,23.38,23.75,24.16,24.66,24.97,24.16,22.19,19.34,15.5,12.66,9.62,7.19,6.31,5.81,6.81,10.25,13.53,16.5,19.47,19.19,17.91,15.44,12.88,10.09,10.03,9.91,9.88,10.78,9.44,9.59,10.72,10.0,11.75,12.66,13.94,15.91,18.09,20.31,22.88,25.84,28.56,32.03,34.34,35.16,35.69,33.91,29.75,26.56,22.81,18.31,15.38,12.41,9.0,6.62,5.28,3.69,3.81,3.09,2.94,3.22,3.78,3.88,6.25,7.75,9.88,12.44,15.62,18.38,21.06,22.44,22.94,22.41,23.19,20.81,21.34,22.25,22.03,22.53,23.19,23.78,24.69,26.0,27.69,27.81,29.12,28.09,27.66,28.25,28.31,28.38,29.25,30.56,31.34,32.56,33.69,34.5,35.12,35.34,35.41,34.56,33.94,33.06,32.75,31.78,30.91,29.44,28.59,27.16,25.91,26.66,26.56,28.66,30.75,30.94,30.88,30.09,29.0,27.97,27.53,28.12,27.62,28.06,28.06,26.44,25.56,24.31,24.03,23.81,25.31,25.94,25.25,25.66,25.97,26.75,28.44,31.75,35.06,36.91,39.12,39.84,39.41,38.5,36.53,36.03,33.97,33.25,32.12,31.31,30.56,30.69,29.44,29.28,29.69,28.12,28.41,27.59,26.66,27.75,27.97,29.53,30.12,30.5,31.03,30.56,30.0,30.31,30.06,28.22,27.75,26.78,26.34,27.25,28.38,30.12,32.66,31.75,32.69,32.44,32.47,32.53,33.5,34.91,36.44,37.91,38.06,37.28,35.91,33.56,32.06,29.25,28.78,26.94,25.19,23.44,23.19,22.41,22.06,22.09,22.41,21.09,20.66,20.03,18.91,18.31,18.16,18.28,17.72,17.56,17.47,16.56,15.91,14.62,13.38,12.56,12.41,13.56,13.41,12.06,11.41,9.53,6.19,3.78,2.0,0.66,1.0,1.0,1.59,3.44,4.44,4.16,5.09,5.91,7.19,8.56,12.41,15.62,18.06,20.12,20.5,20.41,18.62,16.59,13.0,10.19,7.28,4.94,4.09,4.41,4.59,5.38,6.62,8.5,9.41,11.28,11.31,12.44,13.12,13.41,15.28,17.22,18.44,18.47,17.34,15.56,12.06,10.75,8.88,7.94,8.69,7.41,7.19,6.81,6.53,6.94,6.19,5.97,6.06,3.53,2.56,0.94,-0.53,0.25,1.12,2.88,4.97,6.12,7.19,8.5,8.06,8.25,9.81,10.59,12.12,12.81,13.34,12.75,12.06,9.97,8.41,5.41,4.25,1.97,1.03,0.53,1.12,1.38,3.12,4.84,6.25,7.81,9.09,9.28,10.88,10.69,11.44,13.31,15.47,18.5,20.53,22.56,22.88,23.19,23.47,23.25,24.94,24.62,25.81,25.16,24.28,22.81,22.38,21.38,21.38,22.16,22.0,20.78,18.91,16.53,13.59,10.81,8.91,8.06,6.41,7.97,8.09,7.94,8.06,7.06,6.16,4.59,2.03,1.06,0.19,0.34,0.75,2.91,5.03,6.19,8.16,9.62,9.38,10.06,9.81,9.66,10.5,10.81,12.19,14.41,15.94,17.47,17.0,18.91,17.12,16.78,15.09,13.19,11.44,9.88,8.66,8.5,9.47,10.94,12.19,14.25,14.56,15.19,15.91,16.34,17.5,18.0,19.78,18.94,21.56,21.25,22.88,23.78,24.25,23.88,22.97,21.53,21.47,21.44,18.28,22.44,23.53,27.25,29.0,31.19,30.62,27.25,23.66,19.94,16.03,14.03,13.16,13.12,14.16,15.78,16.5,17.72,18.34,18.28,17.75,17.72,18.59,18.84,20.56,21.09,22.69,22.72,23.34,24.19,24.88,25.0,25.34,23.69,21.5,17.5,13.94,11.12,9.69,9.31,10.31,12.31,14.16,17.66,19.56,19.66,21.41,20.5,19.09,18.66,18.81,18.09,19.19,20.19,19.97,20.31,20.28,19.34,19.25,18.97,19.38,19.16,19.84,19.38,18.09,20.03,19.28,21.5,23.97,26.94,27.66,29.12,26.88,29.25,25.28,26.5,25.59,24.16,22.53,21.25,18.44,17.56,17.38,18.38,20.0,24.25,25.91,27.84,27.62,26.0,25.06,21.31,20.41,18.53,17.75,18.62,17.28,17.94,16.78,16.91,17.03,15.06,14.5,12.53,10.47,8.03,6.94,6.94,8.75,10.62,13.09,16.31,19.53,21.81,24.16,25.34,25.56,23.72,21.38,19.94,18.66,18.62,19.72,21.25,21.97,22.41,22.44,21.72,20.19,19.81,18.38,17.94,17.97,19.12,20.16,22.56,25.09,26.38,28.91,29.78,30.66,32.66,32.5,31.62,31.69,30.5,28.59,28.03,26.59,25.84,24.44,24.09,23.72,23.94,24.75,25.62,27.22,27.31,28.19,27.78,28.38,28.0,27.75,26.28,25.81,24.69,22.06,21.19,19.16,17.19,15.0,14.53,14.12,15.31,17.66,20.12,22.94,26.09,27.22,27.56,27.56,26.5,24.78,22.56,19.81,17.94,16.22,14.47,13.69,13.16,14.0,13.06,14.09,14.34,15.06,15.66,16.91,17.5,17.91,18.25,18.56,18.81,21.31,21.84,23.06,24.56,24.56,23.66,25.25,25.94,25.94,27.5,27.5,27.12,26.22,24.94,23.81,23.41,21.0,18.56,16.81,14.19,12.16,12.31,12.78,13.16,13.34,14.12,13.88,14.38,15.41,16.41,18.81,18.91,19.28,17.12,16.38,13.0,11.59,9.62,7.94,6.88,5.47,4.69,3.81,4.38,5.09,5.09,5.88,5.78,4.97,5.69,5.41,6.06,7.0,7.06,6.56,6.75,4.75,3.94,2.5,0.91,-0.78,-1.38,-2.03,-2.59,-4.0,-3.66,-3.22,-3.34,-1.69,0.31,2.53,6.12,8.06,10.62,13.09,14.69,16.44,18.16,17.78,15.91,13.5,8.44,4.66,0.88,-2.34,-4.56,-7.06,-9.91,-12.75,-14.66,-15.44,-15.94,-12.78,-9.44,-6.34,-2.62,0.28,3.56,4.81,6.19,7.31,8.19,8.0,7.38,7.47,7.34,6.62,6.25,6.12,6.06,5.69,6.16,8.16,9.5,10.81,10.94,8.75,5.47,0.53,-4.94,-9.59,-13.81,-16.72,-18.19,-18.09,-17.0,-16.19,-15.28,-14.66,-16.03,-17.16,-19.53,-21.22,-23.59,-25.97,-27.84,-30.5,-32.03,-31.72,-30.38,-27.84,-25.03,-22.91,-20.72,-21.5,-22.19,-22.84,-22.72,-21.28,-18.84,-16.34,-13.69,-11.72,-10.47,-9.81,-7.91,-6.09,-4.75,-2.47,-0.72,-1.09,-0.97,-1.5,-2.84,-3.97,-4.0,-5.28,-6.09,-6.47,-7.06,-7.22,-6.66,-6.03,-4.81,-2.72,-1.78,-0.28,1.03,2.53,3.44,5.16,7.66,9.0,8.91,9.69,7.72,5.41,2.56,0.06,-1.16,-1.84,-2.97,-1.84,-2.0,-0.28,0.44,3.59,5.0,6.91,7.66,7.19,5.62,3.94,1.34,-0.38,-2.03,-3.22,-3.38,-3.66,-2.47,-1.94,-0.53,-0.06,1.03,1.38,1.31,0.28,-0.72,-1.72,-3.22,-3.16,-2.03,-0.72,1.44,3.62,6.12,7.31,6.66,7.59,7.28,6.53,6.88,7.41,7.66:11.0,9.19,9.88,10.91,12.91,14.97,15.78,17.78,18.78,20.5,20.25,20.16,19.97,18.91,17.47,17.31,17.66,18.22,20.12,20.69,21.62,22.06,22.19,22.0,23.03,24.44,26.84,28.47,30.44,32.19,33.44,33.38,33.47,33.06,32.94,33.28,33.81,34.44,34.94,36.62,35.28,35.81,35.91,34.81,33.47,31.16,29.38,26.91,25.12,24.06,23.34,22.75,23.38,23.75,24.16,24.66,24.97,24.16,22.19,19.34,15.5,12.66,9.62,7.19,6.31,5.81,6.81,10.25,13.53,16.5,19.47,19.19,17.91,15.44,12.88,10.09,10.03,9.91,9.88,10.78,9.44,9.59,10.72,10.0,11.75,12.66,13.94,15.91,18.09,20.31,22.88,25.84,28.56,32.03,34.34,35.16,35.69,33.91,29.75,26.56,22.81,18.31,15.38,12.41,9.0,6.62,5.28,3.69,3.81,3.09,2.94,3.22,3.78,3.88,6.25,7.75,9.88,12.44,15.62,18.38,21.06,22.44,22.94,22.41,23.19,20.81,21.34,22.25,22.03,22.53,23.19,23.78,24.69,26.0,27.69,27.81,29.12,28.09,27.66,28.25,28.31,28.38,29.25,30.56,31.34,32.56,33.69,34.5,35.12,35.34,35.41,34.56,33.94,33.06,32.75,31.78,30.91,29.44,28.59,27.16,25.91,26.66,26.56,28.66,30.75,30.94,30.88,30.09,29.0,27.97,27.53,28.12,27.62,28.06,28.06,26.44,25.56,24.31,24.03,23.81,25.31,25.94,25.25,25.66,25.97,26.75,28.44,31.75,35.06,36.91,39.12,39.84,39.41,38.5,36.53,36.03,33.97,33.25,32.12,31.31,30.56,30.69,29.44,29.28,29.69,28.12,28.41,27.59,26.66,27.75,27.97,29.53,30.12,30.5,31.03,30.56,30.0,30.31,30.06,28.22,27.75,26.78,26.34,27.25,28.38,30.12,32.66,31.75,32.69,32.44,32.47,32.53,33.5,34.91,36.44,37.91,38.06,37.28,35.91,33.56,32.06,29.25,28.78,26.94,25.19,23.44,23.19,22.41,22.06,22.09,22.41,21.09,20.66,20.03,18.91,18.31,18.16,18.28,17.72,17.56,17.47,16.56,15.91,14.62,13.38,12.56,12.41,13.56,13.41,12.06,11.41,9.53,6.19,3.78,2.0,0.66,1.0,1.0,1.59,3.44,4.44,4.16,5.09,5.91,7.19,8.56,12.41,15.62,18.06,20.12,20.5,20.41,18.62,16.59,13.0,10.19,7.28,4.94,4.09,4.41,4.59,5.38,6.62,8.5,9.41,11.28,11.31,12.44,13.12,13.41,15.28,17.22,18.44,18.47,17.34,15.56,12.06,10.75,8.88,7.94,8.69,7.41,7.19,6.81,6.53,6.94,6.19,5.97,6.06,3.53,2.56,0.94,-0.53,0.25,1.12,2.88,4.97,6.12,7.19,8.5,8.06,8.25,9.81,10.59,12.12,12.81,13.34,12.75,12.06,9.97,8.41,5.41,4.25,1.97,1.03,0.53,1.12,1.38,3.12,4.84,6.25,7.81,9.09,9.28,10.88,10.69,11.44,13.31,15.47,18.5,20.53,22.56,22.88,23.19,23.47,23.25,24.94,24.62,25.81,25.16,24.28,22.81,22.38,21.38,21.38,22.16,22.0,20.78,18.91,16.53,13.59,10.81,8.91,8.06,6.41,7.97,8.09,7.94,8.06,7.06,6.16,4.59,2.03,1.06,0.19,0.34,0.75,2.91,5.03,6.19,8.16,9.62,9.38,10.06,9.81,9.66,10.5,10.81,12.19,14.41,15.94,17.47,17.0,18.91,17.12,16.78,15.09,13.19,11.44,9.88,8.66,8.5,9.47,10.94,12.19,14.25,14.56,15.19,15.91,16.34,17.5,18.0,19.78,18.94,21.56,21.25,22.88,23.78,24.25,23.88,22.97,21.53,21.47,21.44,18.28,22.44,23.53,27.25,29.0,31.19,30.62,27.25,23.66,19.94,16.03,14.03,13.16,13.12,14.16,15.78,16.5,17.72,18.34,18.28,17.75,17.72,18.59,18.84,20.56,21.09,22.69,22.72,23.34,24.19,24.88,25.0,25.34,23.69,21.5,17.5,13.94,11.12,9.69,9.31,10.31,12.31,14.16,17.66,19.56,19.66,21.41,20.5,19.09,18.66,18.81,18.09,19.19,20.19,19.97,20.31,20.28,19.34,19.25,18.97,19.38,19.16,19.84,19.38,18.09,20.03,19.28,21.5,23.97,26.94,27.66,29.12,26.88,29.25,25.28,26.5,25.59,24.16,22.53,21.25,18.44,17.56,17.38,18.38,20.0,24.25,25.91,27.84,27.62,26.0,25.06,21.31,20.41,18.53,17.75,18.62,17.28,17.94,16.78,16.91,17.03,15.06,14.5,12.53,10.47,8.03,6.94,6.94,8.75,10.62,13.09,16.31,19.53,21.81,24.16,25.34,25.56,23.72,21.38,19.94,18.66,18.62,19.72,21.25,21.97,22.41,22.44,21.72,20.19,19.81,18.38,17.94,17.97,19.12,20.16,22.56,25.09,26.38,28.91,29.78,30.66,32.66,32.5,31.62,31.69,30.5,28.59,28.03,26.59,25.84,24.44,24.09,23.72,23.94,24.75,25.62,27.22,27.31,28.19,27.78,28.38,28.0,27.75,26.28,25.81,24.69,22.06,21.19,19.16,17.19,15.0,14.53,14.12,15.31,17.66,20.12,22.94,26.09,27.22,27.56,27.56,26.5,24.78,22.56,19.81,17.94,16.22,14.47,13.69,13.16,14.0,13.06,14.09,14.34,15.06,15.66,16.91,17.5,17.91,18.25,18.56,18.81,21.31,21.84,23.06,24.56,24.56,23.66,25.25,25.94,25.94,27.5,27.5,27.12,26.22,24.94,23.81,23.41,21.0,18.56,16.81,14.19,12.16,12.31,12.78,13.16,13.34,14.12,13.88,14.38,15.41,16.41,18.81,18.91,19.28,17.12,16.38,13.0,11.59,9.62,7.94,6.88,5.47,4.69,3.81,4.38,5.09,5.09,5.88,5.78,4.97,5.69,5.41,6.06,7.0,7.06,6.56,6.75,4.75,3.94,2.5,0.91,-0.78,-1.38,-2.03,-2.59,-4.0,-3.66,-3.22,-3.34,-1.69,0.31,2.53,6.12,8.06,10.62,13.09,14.69,16.44,18.16,17.78,15.91,13.5,8.44,4.66,0.88,-2.34,-4.56,-7.06,-9.91,-12.75,-14.66,-15.44,-15.94,-12.78,-9.44,-6.34,-2.62,0.28,3.56,4.81,6.19,7.31,8.19,8.0,7.38,7.47,7.34,6.62,6.25,6.12,6.06,5.69,6.16,8.16,9.5,10.81,10.94,8.75,5.47,0.53,-4.94,-9.59,-13.81,-16.72,-18.19,-18.09,-17.0,-16.19,-15.28,-14.66,-16.03,-17.16,-19.53,-21.22,-23.59,-25.97,-27.84,-30.5,-32.03,-31.72,-30.38,-27.84,-25.03,-22.91,-20.72,-21.5,-22.19,-22.84,-22.72,-21.28,-18.84,-16.34,-13.69,-11.72,-10.47,-9.81,-7.91,-6.09,-4.75,-2.47,-0.72,-1.09,-0.97,-1.5,-2.84,-3.97,-4.0,-5.28,-6.09,-6.47,-7.06,-7.22,-6.66,-6.03,-4.81,-2.72,-1.78,-0.28,1.03,2.53,3.44,5.16,7.66,9.0,8.91,9.69,7.72,5.41,2.56,0.06,-1.16,-1.84,-2.97,-1.84,-2.0,-0.28,0.44,3.59,5.0,6.91,7.66,7.19,5.62,3.94,1.34,-0.38,-2.03,-3.22,-3.38,-3.66,-2.47,-1.94,-0.53,-0.06,1.03,1.38,1.31,0.28,-0.72,-1.72,-3.22,-3.16,-2.03,-0.72,1.44,3.62,6.12,7.31,6.66,7.59,7.28,6.53,6.88,7.41,7.66,-22.06,-18.22,-17.47,-18.06,-20.22,-22.81:15.78,17.78,18.78,20.5,20.25,20.16,19.97,18.91,17.47,17.31,17.66,18.22,20.12,20.69,21.62,22.06,22.19,22.0,23.03,24.44,26.84,28.47,30.44,32.19,33.44,33.38,33.47,33.06,32.94,33.28,33.81,34.44,34.94,36.62,35.28,35.81,35.91,34.81,33.47,31.16,29.38,26.91,25.12,24.06,23.34,22.75,23.38,23.75,24.16,24.66,24.97,24.16,22.19,19.34,15.5,12.66,9.62,7.19,6.31,5.81,6.81,10.25,13.53,16.5,19.47,19.19,17.91,15.44,12.88,10.09,10.03,9.91,9.88,10.78,9.44,9.59,10.72,10.0,11.75,12.66,13.94,15.91,18.09,20.31,22.88,25.84,28.56,32.03,34.34,35.16,35.69,33.91,29.75,26.56,22.81,18.31,15.38,12.41,9.0,6.62,5.28,3.69,3.81,3.09,2.94,3.22,3.78,3.88,6.25,7.75,9.88,12.44,15.62,18.38,21.06,22.44,22.94,22.41,23.19,20.81,21.34,22.25,22.03,22.53,23.19,23.78,24.69,26.0,27.69,27.81,29.12,28.09,27.66,28.25,28.31,28.38,29.25,30.56,31.34,32.56,33.69,34.5,35.12,35.34,35.41,34.56,33.94,33.06,32.75,31.78,30.91,29.44,28.59,27.16,25.91,26.66,26.56,28.66,30.75,30.94,30.88,30.09,29.0,27.97,27.53,28.12,27.62,28.06,28.06,26.44,25.56,24.31,24.03,23.81,25.31,25.94,25.25,25.66,25.97,26.75,28.44,31.75,35.06,36.91,39.12,39.84,39.41,38.5,36.53,36.03,33.97,33.25,32.12,31.31,30.56,30.69,29.44,29.28,29.69,28.12,28.41,27.59,26.66,27.75,27.97,29.53,30.12,30.5,31.03,30.56,30.0,30.31,30.06,28.22,27.75,26.78,26.34,27.25,28.38,30.12,32.66,31.75,32.69,32.44,32.47,32.53,33.5,34.91,36.44,37.91,38.06,37.28,35.91,33.56,32.06,29.25,28.78,26.94,25.19,23.44,23.19,22.41,22.06,22.09,22.41,21.09,20.66,20.03,18.91,18.31,18.16,18.28,17.72,17.56,17.47,16.56,15.91,14.62,13.38,12.56,12.41,13.56,13.41,12.06,11.41,9.53,6.19,3.78,2.0,0.66,1.0,1.0,1.59,3.44,4.44,4.16,5.09,5.91,7.19,8.56,12.41,15.62,18.06,20.12,20.5,20.41,18.62,16.59,13.0,10.19,7.28,4.94,4.09,4.41,4.59,5.38,6.62,8.5,9.41,11.28,11.31,12.44,13.12,13.41,15.28,17.22,18.44,18.47,17.34,15.56,12.06,10.75,8.88,7.94,8.69,7.41,7.19,6.81,6.53,6.94,6.19,5.97,6.06,3.53,2.56,0.94,-0.53,0.25,1.12,2.88,4.97,6.12,7.19,8.5,8.06,8.25,9.81,10.59,12.12,12.81,13.34,12.75,12.06,9.97,8.41,5.41,4.25,1.97,1.03,0.53,1.12,1.38,3.12,4.84,6.25,7.81,9.09,9.28,10.88,10.69,11.44,13.31,15.47,18.5,20.53,22.56,22.88,23.19,23.47,23.25,24.94,24.62,25.81,25.16,24.28,22.81,22.38,21.38,21.38,22.16,22.0,20.78,18.91,16.53,13.59,10.81,8.91,8.06,6.41,7.97,8.09,7.94,8.06,7.06,6.16,4.59,2.03,1.06,0.19,0.34,0.75,2.91,5.03,6.19,8.16,9.62,9.38,10.06,9.81,9.66,10.5,10.81,12.19,14.41,15.94,17.47,17.0,18.91,17.12,16.78,15.09,13.19,11.44,9.88,8.66,8.5,9.47,10.94,12.19,14.25,14.56,15.19,15.91,16.34,17.5,18.0,19.78,18.94,21.56,21.25,22.88,23.78,24.25,23.88,22.97,21.53,21.47,21.44,18.28,22.44,23.53,27.25,29.0,31.19,30.62,27.25,23.66,19.94,16.03,14.03,13.16,13.12,14.16,15.78,16.5,17.72,18.34,18.28,17.75,17.72,18.59,18.84,20.56,21.09,22.69,22.72,23.34,24.19,24.88,25.0,25.34,23.69,21.5,17.5,13.94,11.12,9.69,9.31,10.31,12.31,14.16,17.66,19.56,19.66,21.41,20.5,19.09,18.66,18.81,18.09,19.19,20.19,19.97,20.31,20.28,19.34,19.25,18.97,19.38,19.16,19.84,19.38,18.09,20.03,19.28,21.5,23.97,26.94,27.66,29.12,26.88,29.25,25.28,26.5,25.59,24.16,22.53,21.25,18.44,17.56,17.38,18.38,20.0,24.25,25.91,27.84,27.62,26.0,25.06,21.31,20.41,18.53,17.75,18.62,17.28,17.94,16.78,16.91,17.03,15.06,14.5,12.53,10.47,8.03,6.94,6.94,8.75,10.62,13.09,16.31,19.53,21.81,24.16,25.34,25.56,23.72,21.38,19.94,18.66,18.62,19.72,21.25,21.97,22.41,22.44,21.72,20.19,19.81,18.38,17.94,17.97,19.12,20.16,22.56,25.09,26.38,28.91,29.78,30.66,32.66,32.5,31.62,31.69,30.5,28.59,28.03,26.59,25.84,24.44,24.09,23.72,23.94,24.75,25.62,27.22,27.31,28.19,27.78,28.38,28.0,27.75,26.28,25.81,24.69,22.06,21.19,19.16,17.19,15.0,14.53,14.12,15.31,17.66,20.12,22.94,26.09,27.22,27.56,27.56,26.5,24.78,22.56,19.81,17.94,16.22,14.47,13.69,13.16,14.0,13.06,14.09,14.34,15.06,15.66,16.91,17.5,17.91,18.25,18.56,18.81,21.31,21.84,23.06,24.56,24.56,23.66,25.25,25.94,25.94,27.5,27.5,27.12,26.22,24.94,23.81,23.41,21.0,18.56,16.81,14.19,12.16,12.31,12.78,13.16,13.34,14.12,13.88,14.38,15.41,16.41,18.81,18.91,19.28,17.12,16.38,13.0,11.59,9.62,7.94,6.88,5.47,4.69,3.81,4.38,5.09,5.09,5.88,5.78,4.97,5.69,5.41,6.06,7.0,7.06,6.56,6.75,4.75,3.94,2.5,0.91,-0.78,-1.38,-2.03,-2.59,-4.0,-3.66,-3.22,-3.34,-1.69,0.31,2.53,6.12,8.06,10.62,13.09,14.69,16.44,18.16,17.78,15.91,13.5,8.44,4.66,0.88,-2.34,-4.56,-7.06,-9.91,-12.75,-14.66,-15.44,-15.94,-12.78,-9.44,-6.34,-2.62,0.28,3.56,4.81,6.19,7.31,8.19,8.0,7.38,7.47,7.34,6.62,6.25,6.12,6.06,5.69,6.16,8.16,9.5,10.81,10.94,8.75,5.47,0.53,-4.94,-9.59,-13.81,-16.72,-18.19,-18.09,-17.0,-16.19,-15.28,-14.66,-16.03,-17.16,-19.53,-21.22,-23.59,-25.97,-27.84,-30.5,-32.03,-31.72,-30.38,-27.84,-25.03,-22.91,-20.72,-21.5,-22.19,-22.84,-22.72,-21.28,-18.84,-16.34,-13.69,-11.72,-10.47,-9.81,-7.91,-6.09,-4.75,-2.47,-0.72,-1.09,-0.97,-1.5,-2.84,-3.97,-4.0,-5.28,-6.09,-6.47,-7.06,-7.22,-6.66,-6.03,-4.81,-2.72,-1.78,-0.28,1.03,2.53,3.44,5.16,7.66,9.0,8.91,9.69,7.72,5.41,2.56,0.06,-1.16,-1.84,-2.97,-1.84,-2.0,-0.28,0.44,3.59,5.0,6.91,7.66,7.19,5.62,3.94,1.34,-0.38,-2.03,-3.22,-3.38,-3.66,-2.47,-1.94,-0.53,-0.06,1.03,1.38,1.31,0.28,-0.72,-1.72,-3.22,-3.16,-2.03,-0.72,1.44,3.62,6.12,7.31,6.66,7.59,7.28,6.53,6.88,7.41,7.66,-22.06,-18.22,-17.47,-18.06,-20.22,-22.81,-24.78,-25.69,-26.47,-26.59,-26.59,-26.28:19.97,18.91,17.47,17.31,17.66,18.22,20.12,20.69,21.62,22.06,22.19,22.0,23.03,24.44,26.84,28.47,30.44,32.19,33.44,33.38,33.47,33.06,32.94,33.28,33.81,34.44,34.94,36.62,35.28,35.81,35.91,34.81,33.47,31.16,29.38,26.91,25.12,24.06,23.34,22.75,23.38,23.75,24.16,24.66,24.97,24.16,22.19,19.34,15.5,12.66,9.62,7.19,6.31,5.81,6.81,10.25,13.53,16.5,19.47,19.19,17.91,15.44,12.88,10.09,10.03,9.91,9.88,10.78,9.44,9.59,10.72,10.0,11.75,12.66,13.94,15.91,18.09,20.31,22.88,25.84,28.56,32.03,34.34,35.16,35.69,33.91,29.75,26.56,22.81,18.31,15.38,12.41,9.0,6.62,5.28,3.69,3.81,3.09,2.94,3.22,3.78,3.88,6.25,7.75,9.88,12.44,15.62,18.38,21.06,22.44,22.94,22.41,23.19,20.81,21.34,22.25,22.03,22.53,23.19,23.78,24.69,26.0,27.69,27.81,29.12,28.09,27.66,28.25,28.31,28.38,29.25,30.56,31.34,32.56,33.69,34.5,35.12,35.34,35.41,34.56,33.94,33.06,32.75,31.78,30.91,29.44,28.59,27.16,25.91,26.66,26.56,28.66,30.75,30.94,30.88,30.09,29.0,27.97,27.53,28.12,27.62,28.06,28.06,26.44,25.56,24.31,24.03,23.81,25.31,25.94,25.25,25.66,25.97,26.75,28.44,31.75,35.06,36.91,39.12,39.84,39.41,38.5,36.53,36.03,33.97,33.25,32.12,31.31,30.56,30.69,29.44,29.28,29.69,28.12,28.41,27.59,26.66,27.75,27.97,29.53,30.12,30.5,31.03,30.56,30.0,30.31,30.06,28.22,27.75,26.78,26.34,27.25,28.38,30.12,32.66,31.75,32.69,32.44,32.47,32.53,33.5,34.91,36.44,37.91,38.06,37.28,35.91,33.56,32.06,29.25,28.78,26.94,25.19,23.44,23.19,22.41,22.06,22.09,22.41,21.09,20.66,20.03,18.91,18.31,18.16,18.28,17.72,17.56,17.47,16.56,15.91,14.62,13.38,12.56,12.41,13.56,13.41,12.06,11.41,9.53,6.19,3.78,2.0,0.66,1.0,1.0,1.59,3.44,4.44,4.16,5.09,5.91,7.19,8.56,12.41,15.62,18.06,20.12,20.5,20.41,18.62,16.59,13.0,10.19,7.28,4.94,4.09,4.41,4.59,5.38,6.62,8.5,9.41,11.28,11.31,12.44,13.12,13.41,15.28,17.22,18.44,18.47,17.34,15.56,12.06,10.75,8.88,7.94,8.69,7.41,7.19,6.81,6.53,6.94,6.19,5.97,6.06,3.53,2.56,0.94,-0.53,0.25,1.12,2.88,4.97,6.12,7.19,8.5,8.06,8.25,9.81,10.59,12.12,12.81,13.34,12.75,12.06,9.97,8.41,5.41,4.25,1.97,1.03,0.53,1.12,1.38,3.12,4.84,6.25,7.81,9.09,9.28,10.88,10.69,11.44,13.31,15.47,18.5,20.53,22.56,22.88,23.19,23.47,23.25,24.94,24.62,25.81,25.16,24.28,22.81,22.38,21.38,21.38,22.16,22.0,20.78,18.91,16.53,13.59,10.81,8.91,8.06,6.41,7.97,8.09,7.94,8.06,7.06,6.16,4.59,2.03,1.06,0.19,0.34,0.75,2.91,5.03,6.19,8.16,9.62,9.38,10.06,9.81,9.66,10.5,10.81,12.19,14.41,15.94,17.47,17.0,18.91,17.12,16.78,15.09,13.19,11.44,9.88,8.66,8.5,9.47,10.94,12.19,14.25,14.56,15.19,15.91,16.34,17.5,18.0,19.78,18.94,21.56,21.25,22.88,23.78,24.25,23.88,22.97,21.53,21.47,21.44,18.28,22.44,23.53,27.25,29.0,31.19,30.62,27.25,23.66,19.94,16.03,14.03,13.16,13.12,14.16,15.78,16.5,17.72,18.34,18.28,17.75,17.72,18.59,18.84,20.56,21.09,22.69,22.72,23.34,24.19,24.88,25.0,25.34,23.69,21.5,17.5,13.94,11.12,9.69,9.31,10.31,12.31,14.16,17.66,19.56,19.66,21.41,20.5,19.09,18.66,18.81,18.09,19.19,20.19,19.97,20.31,20.28,19.34,19.25,18.97,19.38,19.16,19.84,19.38,18.09,20.03,19.28,21.5,23.97,26.94,27.66,29.12,26.88,29.25,25.28,26.5,25.59,24.16,22.53,21.25,18.44,17.56,17.38,18.38,20.0,24.25,25.91,27.84,27.62,26.0,25.06,21.31,20.41,18.53,17.75,18.62,17.28,17.94,16.78,16.91,17.03,15.06,14.5,12.53,10.47,8.03,6.94,6.94,8.75,10.62,13.09,16.31,19.53,21.81,24.16,25.34,25.56,23.72,21.38,19.94,18.66,18.62,19.72,21.25,21.97,22.41,22.44,21.72,20.19,19.81,18.38,17.94,17.97,19.12,20.16,22.56,25.09,26.38,28.91,29.78,30.66,32.66,32.5,31.62,31.69,30.5,28.59,28.03,26.59,25.84,24.44,24.09,23.72,23.94,24.75,25.62,27.22,27.31,28.19,27.78,28.38,28.0,27.75,26.28,25.81,24.69,22.06,21.19,19.16,17.19,15.0,14.53,14.12,15.31,17.66,20.12,22.94,26.09,27.22,27.56,27.56,26.5,24.78,22.56,19.81,17.94,16.22,14.47,13.69,13.16,14.0,13.06,14.09,14.34,15.06,15.66,16.91,17.5,17.91,18.25,18.56,18.81,21.31,21.84,23.06,24.56,24.56,23.66,25.25,25.94,25.94,27.5,27.5,27.12,26.22,24.94,23.81,23.41,21.0,18.56,16.81,14.19,12.16,12.31,12.78,13.16,13.34,14.12,13.88,14.38,15.41,16.41,18.81,18.91,19.28,17.12,16.38,13.0,11.59,9.62,7.94,6.88,5.47,4.69,3.81,4.38,5.09,5.09,5.88,5.78,4.97,5.69,5.41,6.06,7.0,7.06,6.56,6.75,4.75,3.94,2.5,0.91,-0.78,-1.38,-2.03,-2.59,-4.0,-3.66,-3.22,-3.34,-1.69,0.31,2.53,6.12,8.06,10.62,13.09,14.69,16.44,18.16,17.78,15.91,13.5,8.44,4.66,0.88,-2.34,-4.56,-7.06,-9.91,-12.75,-14.66,-15.44,-15.94,-12.78,-9.44,-6.34,-2.62,0.28,3.56,4.81,6.19,7.31,8.19,8.0,7.38,7.47,7.34,6.62,6.25,6.12,6.06,5.69,6.16,8.16,9.5,10.81,10.94,8.75,5.47,0.53,-4.94,-9.59,-13.81,-16.72,-18.19,-18.09,-17.0,-16.19,-15.28,-14.66,-16.03,-17.16,-19.53,-21.22,-23.59,-25.97,-27.84,-30.5,-32.03,-31.72,-30.38,-27.84,-25.03,-22.91,-20.72,-21.5,-22.19,-22.84,-22.72,-21.28,-18.84,-16.34,-13.69,-11.72,-10.47,-9.81,-7.91,-6.09,-4.75,-2.47,-0.72,-1.09,-0.97,-1.5,-2.84,-3.97,-4.0,-5.28,-6.09,-6.47,-7.06,-7.22,-6.66,-6.03,-4.81,-2.72,-1.78,-0.28,1.03,2.53,3.44,5.16,7.66,9.0,8.91,9.69,7.72,5.41,2.56,0.06,-1.16,-1.84,-2.97,-1.84,-2.0,-0.28,0.44,3.59,5.0,6.91,7.66,7.19,5.62,3.94,1.34,-0.38,-2.03,-3.22,-3.38,-3.66,-2.47,-1.94,-0.53,-0.06,1.03,1.38,1.31,0.28,-0.72,-1.72,-3.22,-3.16,-2.03,-0.72,1.44,3.62,6.12,7.31,6.66,7.59,7.28,6.53,6.88,7.41,7.66,-22.06,-18.22,-17.47,-18.06,-20.22,-22.81,-24.78,-25.69,-26.47,-26.59,-26.59,-26.28,-24.84,-24.44,-23.78,-22.84,-22.66,-23.19:20.12,20.69,21.62,22.06,22.19,22.0,23.03,24.44,26.84,28.47,30.44,32.19,33.44,33.38,33.47,33.06,32.94,33.28,33.81,34.44,34.94,36.62,35.28,35.81,35.91,34.81,33.47,31.16,29.38,26.91,25.12,24.06,23.34,22.75,23.38,23.75,24.16,24.66,24.97,24.16,22.19,19.34,15.5,12.66,9.62,7.19,6.31,5.81,6.81,10.25,13.53,16.5,19.47,19.19,17.91,15.44,12.88,10.09,10.03,9.91,9.88,10.78,9.44,9.59,10.72,10.0,11.75,12.66,13.94,15.91,18.09,20.31,22.88,25.84,28.56,32.03,34.34,35.16,35.69,33.91,29.75,26.56,22.81,18.31,15.38,12.41,9.0,6.62,5.28,3.69,3.81,3.09,2.94,3.22,3.78,3.88,6.25,7.75,9.88,12.44,15.62,18.38,21.06,22.44,22.94,22.41,23.19,20.81,21.34,22.25,22.03,22.53,23.19,23.78,24.69,26.0,27.69,27.81,29.12,28.09,27.66,28.25,28.31,28.38,29.25,30.56,31.34,32.56,33.69,34.5,35.12,35.34,35.41,34.56,33.94,33.06,32.75,31.78,30.91,29.44,28.59,27.16,25.91,26.66,26.56,28.66,30.75,30.94,30.88,30.09,29.0,27.97,27.53,28.12,27.62,28.06,28.06,26.44,25.56,24.31,24.03,23.81,25.31,25.94,25.25,25.66,25.97,26.75,28.44,31.75,35.06,36.91,39.12,39.84,39.41,38.5,36.53,36.03,33.97,33.25,32.12,31.31,30.56,30.69,29.44,29.28,29.69,28.12,28.41,27.59,26.66,27.75,27.97,29.53,30.12,30.5,31.03,30.56,30.0,30.31,30.06,28.22,27.75,26.78,26.34,27.25,28.38,30.12,32.66,31.75,32.69,32.44,32.47,32.53,33.5,34.91,36.44,37.91,38.06,37.28,35.91,33.56,32.06,29.25,28.78,26.94,25.19,23.44,23.19,22.41,22.06,22.09,22.41,21.09,20.66,20.03,18.91,18.31,18.16,18.28,17.72,17.56,17.47,16.56,15.91,14.62,13.38,12.56,12.41,13.56,13.41,12.06,11.41,9.53,6.19,3.78,2.0,0.66,1.0,1.0,1.59,3.44,4.44,4.16,5.09,5.91,7.19,8.56,12.41,15.62,18.06,20.12,20.5,20.41,18.62,16.59,13.0,10.19,7.28,4.94,4.09,4.41,4.59,5.38,6.62,8.5,9.41,11.28,11.31,12.44,13.12,13.41,15.28,17.22,18.44,18.47,17.34,15.56,12.06,10.75,8.88,7.94,8.69,7.41,7.19,6.81,6.53,6.94,6.19,5.97,6.06,3.53,2.56,0.94,-0.53,0.25,1.12,2.88,4.97,6.12,7.19,8.5,8.06,8.25,9.81,10.59,12.12,12.81,13.34,12.75,12.06,9.97,8.41,5.41,4.25,1.97,1.03,0.53,1.12,1.38,3.12,4.84,6.25,7.81,9.09,9.28,10.88,10.69,11.44,13.31,15.47,18.5,20.53,22.56,22.88,23.19,23.47,23.25,24.94,24.62,25.81,25.16,24.28,22.81,22.38,21.38,21.38,22.16,22.0,20.78,18.91,16.53,13.59,10.81,8.91,8.06,6.41,7.97,8.09,7.94,8.06,7.06,6.16,4.59,2.03,1.06,0.19,0.34,0.75,2.91,5.03,6.19,8.16,9.62,9.38,10.06,9.81,9.66,10.5,10.81,12.19,14.41,15.94,17.47,17.0,18.91,17.12,16.78,15.09,13.19,11.44,9.88,8.66,8.5,9.47,10.94,12.19,14.25,14.56,15.19,15.91,16.34,17.5,18.0,19.78,18.94,21.56,21.25,22.88,23.78,24.25,23.88,22.97,21.53,21.47,21.44,18.28,22.44,23.53,27.25,29.0,31.19,30.62,27.25,23.66,19.94,16.03,14.03,13.16,13.12,14.16,15.78,16.5,17.72,18.34,18.28,17.75,17.72,18.59,18.84,20.56,21.09,22.69,22.72,23.34,24.19,24.88,25.0,25.34,23.69,21.5,17.5,13.94,11.12,9.69,9.31,10.31,12.31,14.16,17.66,19.56,19.66,21.41,20.5,19.09,18.66,18.81,18.09,19.19,20.19,19.97,20.31,20.28,19.34,19.25,18.97,19.38,19.16,19.84,19.38,18.09,20.03,19.28,21.5,23.97,26.94,27.66,29.12,26.88,29.25,25.28,26.5,25.59,24.16,22.53,21.25,18.44,17.56,17.38,18.38,20.0,24.25,25.91,27.84,27.62,26.0,25.06,21.31,20.41,18.53,17.75,18.62,17.28,17.94,16.78,16.91,17.03,15.06,14.5,12.53,10.47,8.03,6.94,6.94,8.75,10.62,13.09,16.31,19.53,21.81,24.16,25.34,25.56,23.72,21.38,19.94,18.66,18.62,19.72,21.25,21.97,22.41,22.44,21.72,20.19,19.81,18.38,17.94,17.97,19.12,20.16,22.56,25.09,26.38,28.91,29.78,30.66,32.66,32.5,31.62,31.69,30.5,28.59,28.03,26.59,25.84,24.44,24.09,23.72,23.94,24.75,25.62,27.22,27.31,28.19,27.78,28.38,28.0,27.75,26.28,25.81,24.69,22.06,21.19,19.16,17.19,15.0,14.53,14.12,15.31,17.66,20.12,22.94,26.09,27.22,27.56,27.56,26.5,24.78,22.56,19.81,17.94,16.22,14.47,13.69,13.16,14.0,13.06,14.09,14.34,15.06,15.66,16.91,17.5,17.91,18.25,18.56,18.81,21.31,21.84,23.06,24.56,24.56,23.66,25.25,25.94,25.94,27.5,27.5,27.12,26.22,24.94,23.81,23.41,21.0,18.56,16.81,14.19,12.16,12.31,12.78,13.16,13.34,14.12,13.88,14.38,15.41,16.41,18.81,18.91,19.28,17.12,16.38,13.0,11.59,9.62,7.94,6.88,5.47,4.69,3.81,4.38,5.09,5.09,5.88,5.78,4.97,5.69,5.41,6.06,7.0,7.06,6.56,6.75,4.75,3.94,2.5,0.91,-0.78,-1.38,-2.03,-2.59,-4.0,-3.66,-3.22,-3.34,-1.69,0.31,2.53,6.12,8.06,10.62,13.09,14.69,16.44,18.16,17.78,15.91,13.5,8.44,4.66,0.88,-2.34,-4.56,-7.06,-9.91,-12.75,-14.66,-15.44,-15.94,-12.78,-9.44,-6.34,-2.62,0.28,3.56,4.81,6.19,7.31,8.19,8.0,7.38,7.47,7.34,6.62,6.25,6.12,6.06,5.69,6.16,8.16,9.5,10.81,10.94,8.75,5.47,0.53,-4.94,-9.59,-13.81,-16.72,-18.19,-18.09,-17.0,-16.19,-15.28,-14.66,-16.03,-17.16,-19.53,-21.22,-23.59,-25.97,-27.84,-30.5,-32.03,-31.72,-30.38,-27.84,-25.03,-22.91,-20.72,-21.5,-22.19,-22.84,-22.72,-21.28,-18.84,-16.34,-13.69,-11.72,-10.47,-9.81,-7.91,-6.09,-4.75,-2.47,-0.72,-1.09,-0.97,-1.5,-2.84,-3.97,-4.0,-5.28,-6.09,-6.47,-7.06,-7.22,-6.66,-6.03,-4.81,-2.72,-1.78,-0.28,1.03,2.53,3.44,5.16,7.66,9.0,8.91,9.69,7.72,5.41,2.56,0.06,-1.16,-1.84,-2.97,-1.84,-2.0,-0.28,0.44,3.59,5.0,6.91,7.66,7.19,5.62,3.94,1.34,-0.38,-2.03,-3.22,-3.38,-3.66,-2.47,-1.94,-0.53,-0.06,1.03,1.38,1.31,0.28,-0.72,-1.72,-3.22,-3.16,-2.03,-0.72,1.44,3.62,6.12,7.31,6.66,7.59,7.28,6.53,6.88,7.41,7.66,-22.06,-18.22,-17.47,-18.06,-20.22,-22.81,-24.78,-25.69,-26.47,-26.59,-26.59,-26.28,-24.84,-24.44,-23.78,-22.84,-22.66,-23.19,-23.22,-24.53,-25.22,-25.72,-24.84,-24.25:23.03,24.44,26.84,28.47,30.44,32.19,33.44,33.38,33.47,33.06,32.94,33.28,33.81,34.44,34.94,36.62,35.28,35.81,35.91,34.81,33.47,31.16,29.38,26.91,25.12,24.06,23.34,22.75,23.38,23.75,24.16,24.66,24.97,24.16,22.19,19.34,15.5,12.66,9.62,7.19,6.31,5.81,6.81,10.25,13.53,16.5,19.47,19.19,17.91,15.44,12.88,10.09,10.03,9.91,9.88,10.78,9.44,9.59,10.72,10.0,11.75,12.66,13.94,15.91,18.09,20.31,22.88,25.84,28.56,32.03,34.34,35.16,35.69,33.91,29.75,26.56,22.81,18.31,15.38,12.41,9.0,6.62,5.28,3.69,3.81,3.09,2.94,3.22,3.78,3.88,6.25,7.75,9.88,12.44,15.62,18.38,21.06,22.44,22.94,22.41,23.19,20.81,21.34,22.25,22.03,22.53,23.19,23.78,24.69,26.0,27.69,27.81,29.12,28.09,27.66,28.25,28.31,28.38,29.25,30.56,31.34,32.56,33.69,34.5,35.12,35.34,35.41,34.56,33.94,33.06,32.75,31.78,30.91,29.44,28.59,27.16,25.91,26.66,26.56,28.66,30.75,30.94,30.88,30.09,29.0,27.97,27.53,28.12,27.62,28.06,28.06,26.44,25.56,24.31,24.03,23.81,25.31,25.94,25.25,25.66,25.97,26.75,28.44,31.75,35.06,36.91,39.12,39.84,39.41,38.5,36.53,36.03,33.97,33.25,32.12,31.31,30.56,30.69,29.44,29.28,29.69,28.12,28.41,27.59,26.66,27.75,27.97,29.53,30.12,30.5,31.03,30.56,30.0,30.31,30.06,28.22,27.75,26.78,26.34,27.25,28.38,30.12,32.66,31.75,32.69,32.44,32.47,32.53,33.5,34.91,36.44,37.91,38.06,37.28,35.91,33.56,32.06,29.25,28.78,26.94,25.19,23.44,23.19,22.41,22.06,22.09,22.41,21.09,20.66,20.03,18.91,18.31,18.16,18.28,17.72,17.56,17.47,16.56,15.91,14.62,13.38,12.56,12.41,13.56,13.41,12.06,11.41,9.53,6.19,3.78,2.0,0.66,1.0,1.0,1.59,3.44,4.44,4.16,5.09,5.91,7.19,8.56,12.41,15.62,18.06,20.12,20.5,20.41,18.62,16.59,13.0,10.19,7.28,4.94,4.09,4.41,4.59,5.38,6.62,8.5,9.41,11.28,11.31,12.44,13.12,13.41,15.28,17.22,18.44,18.47,17.34,15.56,12.06,10.75,8.88,7.94,8.69,7.41,7.19,6.81,6.53,6.94,6.19,5.97,6.06,3.53,2.56,0.94,-0.53,0.25,1.12,2.88,4.97,6.12,7.19,8.5,8.06,8.25,9.81,10.59,12.12,12.81,13.34,12.75,12.06,9.97,8.41,5.41,4.25,1.97,1.03,0.53,1.12,1.38,3.12,4.84,6.25,7.81,9.09,9.28,10.88,10.69,11.44,13.31,15.47,18.5,20.53,22.56,22.88,23.19,23.47,23.25,24.94,24.62,25.81,25.16,24.28,22.81,22.38,21.38,21.38,22.16,22.0,20.78,18.91,16.53,13.59,10.81,8.91,8.06,6.41,7.97,8.09,7.94,8.06,7.06,6.16,4.59,2.03,1.06,0.19,0.34,0.75,2.91,5.03,6.19,8.16,9.62,9.38,10.06,9.81,9.66,10.5,10.81,12.19,14.41,15.94,17.47,17.0,18.91,17.12,16.78,15.09,13.19,11.44,9.88,8.66,8.5,9.47,10.94,12.19,14.25,14.56,15.19,15.91,16.34,17.5,18.0,19.78,18.94,21.56,21.25,22.88,23.78,24.25,23.88,22.97,21.53,21.47,21.44,18.28,22.44,23.53,27.25,29.0,31.19,30.62,27.25,23.66,19.94,16.03,14.03,13.16,13.12,14.16,15.78,16.5,17.72,18.34,18.28,17.75,17.72,18.59,18.84,20.56,21.09,22.69,22.72,23.34,24.19,24.88,25.0,25.34,23.69,21.5,17.5,13.94,11.12,9.69,9.31,10.31,12.31,14.16,17.66,19.56,19.66,21.41,20.5,19.09,18.66,18.81,18.09,19.19,20.19,19.97,20.31,20.28,19.34,19.25,18.97,19.38,19.16,19.84,19.38,18.09,20.03,19.28,21.5,23.97,26.94,27.66,29.12,26.88,29.25,25.28,26.5,25.59,24.16,22.53,21.25,18.44,17.56,17.38,18.38,20.0,24.25,25.91,27.84,27.62,26.0,25.06,21.31,20.41,18.53,17.75,18.62,17.28,17.94,16.78,16.91,17.03,15.06,14.5,12.53,10.47,8.03,6.94,6.94,8.75,10.62,13.09,16.31,19.53,21.81,24.16,25.34,25.56,23.72,21.38,19.94,18.66,18.62,19.72,21.25,21.97,22.41,22.44,21.72,20.19,19.81,18.38,17.94,17.97,19.12,20.16,22.56,25.09,26.38,28.91,29.78,30.66,32.66,32.5,31.62,31.69,30.5,28.59,28.03,26.59,25.84,24.44,24.09,23.72,23.94,24.75,25.62,27.22,27.31,28.19,27.78,28.38,28.0,27.75,26.28,25.81,24.69,22.06,21.19,19.16,17.19,15.0,14.53,14.12,15.31,17.66,20.12,22.94,26.09,27.22,27.56,27.56,26.5,24.78,22.56,19.81,17.94,16.22,14.47,13.69,13.16,14.0,13.06,14.09,14.34,15.06,15.66,16.91,17.5,17.91,18.25,18.56,18.81,21.31,21.84,23.06,24.56,24.56,23.66,25.25,25.94,25.94,27.5,27.5,27.12,26.22,24.94,23.81,23.41,21.0,18.56,16.81,14.19,12.16,12.31,12.78,13.16,13.34,14.12,13.88,14.38,15.41,16.41,18.81,18.91,19.28,17.12,16.38,13.0,11.59,9.62,7.94,6.88,5.47,4.69,3.81,4.38,5.09,5.09,5.88,5.78,4.97,5.69,5.41,6.06,7.0,7.06,6.56,6.75,4.75,3.94,2.5,0.91,-0.78,-1.38,-2.03,-2.59,-4.0,-3.66,-3.22,-3.34,-1.69,0.31,2.53,6.12,8.06,10.62,13.09,14.69,16.44,18.16,17.78,15.91,13.5,8.44,4.66,0.88,-2.34,-4.56,-7.06,-9.91,-12.75,-14.66,-15.44,-15.94,-12.78,-9.44,-6.34,-2.62,0.28,3.56,4.81,6.19,7.31,8.19,8.0,7.38,7.47,7.34,6.62,6.25,6.12,6.06,5.69,6.16,8.16,9.5,10.81,10.94,8.75,5.47,0.53,-4.94,-9.59,-13.81,-16.72,-18.19,-18.09,-17.0,-16.19,-15.28,-14.66,-16.03,-17.16,-19.53,-21.22,-23.59,-25.97,-27.84,-30.5,-32.03,-31.72,-30.38,-27.84,-25.03,-22.91,-20.72,-21.5,-22.19,-22.84,-22.72,-21.28,-18.84,-16.34,-13.69,-11.72,-10.47,-9.81,-7.91,-6.09,-4.75,-2.47,-0.72,-1.09,-0.97,-1.5,-2.84,-3.97,-4.0,-5.28,-6.09,-6.47,-7.06,-7.22,-6.66,-6.03,-4.81,-2.72,-1.78,-0.28,1.03,2.53,3.44,5.16,7.66,9.0,8.91,9.69,7.72,5.41,2.56,0.06,-1.16,-1.84,-2.97,-1.84,-2.0,-0.28,0.44,3.59,5.0,6.91,7.66,7.19,5.62,3.94,1.34,-0.38,-2.03,-3.22,-3.38,-3.66,-2.47,-1.94,-0.53,-0.06,1.03,1.38,1.31,0.28,-0.72,-1.72,-3.22,-3.16,-2.03,-0.72,1.44,3.62,6.12,7.31,6.66,7.59,7.28,6.53,6.88,7.41,7.66,-22.06,-18.22,-17.47,-18.06,-20.22,-22.81,-24.78,-25.69,-26.47,-26.59,-26.59,-26.28,-24.84,-24.44,-23.78,-22.84,-22.66,-23.19,-23.22,-24.53,-25.22,-25.72,-24.84,-24.25,-22.31,-19.44,-18.09,-16.66,-15.09,-14.81:negativity
7.16,7.72,8.41,9.66,14.53,17.53,20.62,26.03,26.75,30.38,29.53,28.16,25.59,22.06,19.19,16.19,12.62,13.28,13.56,14.56,16.97,15.72,16.5,12.09,12.47,13.91,15.62,20.5,23.31,25.44,26.41,24.47,22.72,21.16,19.16,17.31,15.28,16.38,15.94,16.5,18.25,20.22,22.31,24.53,26.06,29.84,28.09,31.81,31.72,27.53,29.72,27.06,24.03,24.97,23.31,22.03,19.97,17.25,17.09,16.22,16.16,17.06,15.62,16.31,14.75,14.47,14.94,13.59,14.5,13.12,13.91,13.47,14.0,10.78,12.16,9.5,9.5,8.97,9.53,10.81,11.38,12.06,13.88,12.28,14.97,14.53,15.69,16.84,18.41,18.88,21.03,23.59,25.62,27.56,25.28,27.62,23.56,20.12,22.16,21.78,23.72,26.69,29.81,31.66,32.75,29.94,32.12,29.44,29.66,28.94,28.12,26.44,24.09,23.19,22.56,21.72,25.56,25.81,28.66,29.44,31.28,30.81,31.0,31.19,31.66,34.28,33.62,37.88,38.31,38.09,40.16,38.47,37.97,37.84,37.31,37.06,36.91,34.25,38.44,38.09,39.66,41.44,41.25,38.56,36.69,35.28,32.62,30.81,33.28,31.47,32.81,33.94,33.41,32.66,32.06,30.06,29.03,27.06,27.16,27.12,27.06,26.12,29.72,30.66,31.62,33.84,34.12,34.22,32.25,31.0,29.06,28.12,30.62,30.09,34.31,37.16,40.09,42.84,42.91,41.22,36.81,33.16,28.56,24.03,25.47,24.75,27.84,33.06,35.69,37.81,39.03,38.56,36.41,34.06,32.19,29.56,28.19,29.5,26.81,28.34,27.06,23.41,27.94,25.56,27.03,30.44,30.62,31.03,30.88,30.94,28.88,31.5,30.94,34.97,36.5,37.72,40.03,39.72,37.09,37.25,36.03,35.75,37.38,38.59,36.38,38.5,37.41,37.19,38.44,37.72,37.03,37.12,36.06,35.78,34.06,33.41,30.78,29.56,31.44,30.56,32.84,33.28,33.5,35.66,37.69,39.59,43.59,47.12,48.0,48.81,48.25,47.16,47.56,43.94,45.78,44.28,41.75,42.38,43.25,43.31,43.84,46.88,46.28,46.22,46.28,45.66,43.72,44.44,40.94,40.91,37.56,35.81,35.69,31.56,34.41,34.03,34.19,33.81,35.97,34.78,36.72,38.22,38.62,39.47,36.81,37.59,36.19,35.56,35.91,37.06,35.41,34.47,36.41,37.38,38.19,40.09,41.16,40.22,39.0,37.94,34.06,32.91,29.66,25.94,28.03,25.97,27.97,29.44,31.5,32.78,33.66,35.62,33.0,34.81,34.09,34.56,34.44,36.19,35.53,33.84,33.38,31.22,30.19,26.91,29.16,29.0,28.06,32.53,34.88,37.47,41.5,42.62,41.34,39.81,38.56,35.72,35.09,35.06,35.09,35.34,34.12,34.38,35.53,36.19,38.44,41.19,39.16,40.81,38.53,37.22,37.44,35.97,35.06,34.84,32.03,25.16,26.0,21.56,21.91,23.91,26.94,31.0,33.78,32.25,32.62,32.06,30.81,26.06,28.84,27.94,26.56,28.0,29.16,30.19,27.78,28.47,28.19,27.34,27.25,28.72,28.06,26.09,25.16,23.72,23.56,25.94,26.91,27.94,27.78,26.53,26.88,25.94,25.06,26.44,24.81,22.44,24.88,25.5,28.66,31.81,33.47,37.12,37.47,38.16,39.09,38.62,35.84,33.91,33.38,32.06,31.75,34.69,36.41,36.59,37.09,38.09,37.25,40.06,41.59,44.09,43.0,44.09,41.97,38.16,34.78,32.69,29.94,28.12,27.31,30.06,30.91,32.72,36.03,38.19,36.28,39.19,39.16,38.12,39.69,36.69,34.25,33.12,27.44,27.72,26.5,26.41,23.94,27.44,26.38,28.59,31.47,34.69,39.03,42.41,42.62,46.56,47.91,48.81,50.75,50.31,49.75,47.81,44.03,41.12,38.47,31.09,31.53,28.31,30.66,32.97,36.38,40.31,41.41,43.31,44.56,45.91,46.66,46.41,46.03,39.31,44.03,42.62,47.09,51.81,56.22,57.5,58.12,55.88,52.16,50.88,48.09,45.25,43.72,43.09,38.62,37.81,34.34,30.97,31.31,28.34,26.34,21.78,23.44,22.78,25.88,30.5,37.19,40.78,41.84,39.28,37.59,36.19,33.25,34.12,35.44,35.12,32.62,32.03,26.66,27.75,26.53,26.38,25.69,25.97,27.16,26.62,28.91,31.75,33.09,32.66,35.72,37.31,39.19,42.91,45.84,46.06,47.94,43.69,45.47,46.56,48.25,47.78,51.62,50.78,49.56,48.56,47.16,46.16,44.47,42.31,40.34,37.88,36.97,35.28,36.44,38.06,38.94,40.66,41.28,42.72,41.62,43.56,43.31,44.03,43.62,41.34,40.12,33.56,32.66,29.16,27.0,26.81,27.06,24.38,26.59,25.91,27.44,28.06,28.62,32.56,33.97,33.78,37.06,38.69,38.16,36.59,37.38,34.56,31.19,32.62,31.25,29.94,30.72,32.44,32.91,32.88,35.44,35.41,35.0,33.03,33.31,34.84,33.78,38.31,39.62,42.97,44.16,45.28,43.25,44.34,41.81,40.53,43.25,45.03,48.75,52.19,54.72,53.91,52.06,50.97,48.91,45.34,46.38,46.81,46.19,47.88,48.91,50.44,49.94,49.81,48.44,46.5,46.41,46.19,45.34,47.31,48.62,51.19,52.81,53.81,54.69,52.03,50.56,46.66,45.81,45.44,45.03,45.81,44.88,44.53,41.62,39.56,35.91,39.06,38.12,40.5,41.28,40.19,39.69,38.19,36.41,33.66,35.5,34.19,30.16,31.66,31.75,30.78,31.62,34.84,34.84,36.03,37.94,39.31,40.44,38.31,35.78,39.31,36.75,37.84,39.28,40.81,41.47,40.75,40.0,39.66,37.53,30.59,34.28,31.47,32.0,35.34,35.12,36.69,35.09,35.16,36.06,36.62,38.41,37.53,40.31,39.03,37.78,35.53,35.16,32.5,30.91,29.47,27.28,23.97,25.66,23.31,26.69,29.06,33.81,36.88,37.94,38.06,36.5,34.28,31.69,31.66,27.31,29.94,30.03,30.44,29.81,30.06,31.5,29.78,29.19,30.16,28.34,27.31,24.25,27.31,26.53,27.16,31.94,34.66,37.81,40.44,43.19,42.28,42.56,39.84,37.81,33.53,30.66,29.62,28.72,29.62,30.19,31.31,35.44,35.38,38.25,39.38,41.38,41.06,40.5,35.19,35.41,31.62,27.28,27.06,25.94,26.94,27.62,30.56,32.0,31.88,32.31,34.19,31.91,34.75,33.28,32.25,32.81,30.69,30.94,29.72,29.22,29.03,29.06,29.81,31.06,33.69,33.41,35.12,35.94,36.03,37.34,37.06,38.31,36.69,34.88,33.94,32.72,28.94,30.72,29.88,30.31,32.31,33.81,32.88,32.56,31.06,29.56,27.66,26.88,27.12,27.69,27.44,27.41,28.38,26.09,28.62,29.56,29.94,32.38,35.62,36.53,39.53,40.53,39.62,41.28,38.44,34.94,37.19,32.16,32.41,32.56,31.53,30.44,30.62,29.59,29.59,28.66,25.44,28.94,28.06,30.44,33.53,36.53,36.94,35.44,32.31,28.81,25.75,25.31,25.91,29.28,32.09,34.34,34.91,32.59,34.41,31.44,29.78,28.0,24.0,23.94,22.16,22.38,24.0,26.12,27.19,28.59,29.53,31.62,30.25,32.5,33.53,32.62,33.53,33.09,31.91,31.0,31.25,30.0,30.16,29.69,29.97,29.59,30.84,29.44,29.94,30.12,27.97,28.22,28.19,27.91,29.44,28.69,29.94:20.62,26.03,26.75,30.38,29.53,28.16,25.59,22.06,19.19,16.19,12.62,13.28,13.56,14.56,16.97,15.72,16.5,12.09,12.47,13.91,15.62,20.5,23.31,25.44,26.41,24.47,22.72,21.16,19.16,17.31,15.28,16.38,15.94,16.5,18.25,20.22,22.31,24.53,26.06,29.84,28.09,31.81,31.72,27.53,29.72,27.06,24.03,24.97,23.31,22.03,19.97,17.25,17.09,16.22,16.16,17.06,15.62,16.31,14.75,14.47,14.94,13.59,14.5,13.12,13.91,13.47,14.0,10.78,12.16,9.5,9.5,8.97,9.53,10.81,11.38,12.06,13.88,12.28,14.97,14.53,15.69,16.84,18.41,18.88,21.03,23.59,25.62,27.56,25.28,27.62,23.56,20.12,22.16,21.78,23.72,26.69,29.81,31.66,32.75,29.94,32.12,29.44,29.66,28.94,28.12,26.44,24.09,23.19,22.56,21.72,25.56,25.81,28.66,29.44,31.28,30.81,31.0,31.19,31.66,34.28,33.62,37.88,38.31,38.09,40.16,38.47,37.97,37.84,37.31,37.06,36.91,34.25,38.44,38.09,39.66,41.44,41.25,38.56,36.69,35.28,32.62,30.81,33.28,31.47,32.81,33.94,33.41,32.66,32.06,30.06,29.03,27.06,27.16,27.12,27.06,26.12,29.72,30.66,31.62,33.84,34.12,34.22,32.25,31.0,29.06,28.12,30.62,30.09,34.31,37.16,40.09,42.84,42.91,41.22,36.81,33.16,28.56,24.03,25.47,24.75,27.84,33.06,35.69,37.81,39.03,38.56,36.41,34.06,32.19,29.56,28.19,29.5,26.81,28.34,27.06,23.41,27.94,25.56,27.03,30.44,30.62,31.03,30.88,30.94,28.88,31.5,30.94,34.97,36.5,37.72,40.03,39.72,37.09,37.25,36.03,35.75,37.38,38.59,36.38,38.5,37.41,37.19,38.44,37.72,37.03,37.12,36.06,35.78,34.06,33.41,30.78,29.56,31.44,30.56,32.84,33.28,33.5,35.66,37.69,39.59,43.59,47.12,48.0,48.81,48.25,47.16,47.56,43.94,45.78,44.28,41.75,42.38,43.25,43.31,43.84,46.88,46.28,46.22,46.28,45.66,43.72,44.44,40.94,40.91,37.56,35.81,35.69,31.56,34.41,34.03,34.19,33.81,35.97,34.78,36.72,38.22,38.62,39.47,36.81,37.59,36.19,35.56,35.91,37.06,35.41,34.47,36.41,37.38,38.19,40.09,41.16,40.22,39.0,37.94,34.06,32.91,29.66,25.94,28.03,25.97,27.97,29.44,31.5,32.78,33.66,35.62,33.0,34.81,34.09,34.56,34.44,36.19,35.53,33.84,33.38,31.22,30.19,26.91,29.16,29.0,28.06,32.53,34.88,37.47,41.5,42.62,41.34,39.81,38.56,35.72,35.09,35.06,35.09,35.34,34.12,34.38,35.53,36.19,38.44,41.19,39.16,40.81,38.53,37.22,37.44,35.97,35.06,34.84,32.03,25.16,26.0,21.56,21.91,23.91,26.94,31.0,33.78,32.25,32.62,32.06,30.81,26.06,28.84,27.94,26.56,28.0,29.16,30.19,27.78,28.47,28.19,27.34,27.25,28.72,28.06,26.09,25.16,23.72,23.56,25.94,26.91,27.94,27.78,26.53,26.88,25.94,25.06,26.44,24.81,22.44,24.88,25.5,28.66,31.81,33.47,37.12,37.47,38.16,39.09,38.62,35.84,33.91,33.38,32.06,31.75,34.69,36.41,36.59,37.09,38.09,37.25,40.06,41.59,44.09,43.0,44.09,41.97,38.16,34.78,32.69,29.94,28.12,27.31,30.06,30.91,32.72,36.03,38.19,36.28,39.19,39.16,38.12,39.69,36.69,34.25,33.12,27.44,27.72,26.5,26.41,23.94,27.44,26.38,28.59,31.47,34.69,39.03,42.41,42.62,46.56,47.91,48.81,50.75,50.31,49.75,47.81,44.03,41.12,38.47,31.09,31.53,28.31,30.66,32.97,36.38,40.31,41.41,43.31,44.56,45.91,46.66,46.41,46.03,39.31,44.03,42.62,47.09,51.81,56.22,57.5,58.12,55.88,52.16,50.88,48.09,45.25,43.72,43.09,38.62,37.81,34.34,30.97,31.31,28.34,26.34,21.78,23.44,22.78,25.88,30.5,37.19,40.78,41.84,39.28,37.59,36.19,33.25,34.12,35.44,35.12,32.62,32.03,26.66,27.75,26.53,26.38,25.69,25.97,27.16,26.62,28.91,31.75,33.09,32.66,35.72,37.31,39.19,42.91,45.84,46.06,47.94,43.69,45.47,46.56,48.25,47.78,51.62,50.78,49.56,48.56,47.16,46.16,44.47,42.31,40.34,37.88,36.97,35.28,36.44,38.06,38.94,40.66,41.28,42.72,41.62,43.56,43.31,44.03,43.62,41.34,40.12,33.56,32.66,29.16,27.0,26.81,27.06,24.38,26.59,25.91,27.44,28.06,28.62,32.56,33.97,33.78,37.06,38.69,38.16,36.59,37.38,34.56,31.19,32.62,31.25,29.94,30.72,32.44,32.91,32.88,35.44,35.41,35.0,33.03,33.31,34.84,33.78,38.31,39.62,42.97,44.16,45.28,43.25,44.34,41.81,40.53,43.25,45.03,48.75,52.19,54.72,53.91,52.06,50.97,48.91,45.34,46.38,46.81,46.19,47.88,48.91,50.44,49.94,49.81,48.44,46.5,46.41,46.19,45.34,47.31,48.62,51.19,52.81,53.81,54.69,52.03,50.56,46.66,45.81,45.44,45.03,45.81,44.88,44.53,41.62,39.56,35.91,39.06,38.12,40.5,41.28,40.19,39.69,38.19,36.41,33.66,35.5,34.19,30.16,31.66,31.75,30.78,31.62,34.84,34.84,36.03,37.94,39.31,40.44,38.31,35.78,39.31,36.75,37.84,39.28,40.81,41.47,40.75,40.0,39.66,37.53,30.59,34.28,31.47,32.0,35.34,35.12,36.69,35.09,35.16,36.06,36.62,38.41,37.53,40.31,39.03,37.78,35.53,35.16,32.5,30.91,29.47,27.28,23.97,25.66,23.31,26.69,29.06,33.81,36.88,37.94,38.06,36.5,34.28,31.69,31.66,27.31,29.94,30.03,30.44,29.81,30.06,31.5,29.78,29.19,30.16,28.34,27.31,24.25,27.31,26.53,27.16,31.94,34.66,37.81,40.44,43.19,42.28,42.56,39.84,37.81,33.53,30.66,29.62,28.72,29.62,30.19,31.31,35.44,35.38,38.25,39.38,41.38,41.06,40.5,35.19,35.41,31.62,27.28,27.06,25.94,26.94,27.62,30.56,32.0,31.88,32.31,34.19,31.91,34.75,33.28,32.25,32.81,30.69,30.94,29.72,29.22,29.03,29.06,29.81,31.06,33.69,33.41,35.12,35.94,36.03,37.34,37.06,38.31,36.69,34.88,33.94,32.72,28.94,30.72,29.88,30.31,32.31,33.81,32.88,32.56,31.06,29.56,27.66,26.88,27.12,27.69,27.44,27.41,28.38,26.09,28.62,29.56,29.94,32.38,35.62,36.53,39.53,40.53,39.62,41.28,38.44,34.94,37.19,32.16,32.41,32.56,31.53,30.44,30.62,29.59,29.59,28.66,25.44,28.94,28.06,30.44,33.53,36.53,36.94,35.44,32.31,28.81,25.75,25.31,25.91,29.28,32.09,34.34,34.91,32.59,34.41,31.44,29.78,28.0,24.0,23.94,22.16,22.38,24.0,26.12,27.19,28.59,29.53,31.62,30.25,32.5,33.53,32.62,33.53,33.09,31.91,31.0,31.25,30.0,30.16,29.69,29.97,29.59,30.84,29.44,29.94,30.12,27.97,28.22,28.19,27.91,29.44,28.69,29.94,-58.59,-59.34,-58.44,-56.66,-56.59,-50.09:25.59,22.06,19.19,16.19,12.62,13.28,13.56,14.56,16.97,15.72,16.5,12.09,12.47,13.91,15.62,20.5,23.31,25.44,26.41,24.47,22.72,21.16,19.16,17.31,15.28,16.38,15.94,16.5,18.25,20.22,22.31,24.53,26.06,29.84,28.09,31.81,31.72,27.53,29.72,27.06,24.03,24.97,23.31,22.03,19.97,17.25,17.09,16.22,16.16,17.06,15.62,16.31,14.75,14.47,14.94,13.59,14.5,13.12,13.91,13.47,14.0,10.78,12.16,9.5,9.5,8.97,9.53,10.81,11.38,12.06,13.88,12.28,14.97,14.53,15.69,16.84,18.41,18.88,21.03,23.59,25.62,27.56,25.28,27.62,23.56,20.12,22.16,21.78,23.72,26.69,29.81,31.66,32.75,29.94,32.12,29.44,29.66,28.94,28.12,26.44,24.09,23.19,22.56,21.72,25.56,25.81,28.66,29.44,31.28,30.81,31.0,31.19,31.66,34.28,33.62,37.88,38.31,38.09,40.16,38.47,37.97,37.84,37.31,37.06,36.91,34.25,38.44,38.09,39.66,41.44,41.25,38.56,36.69,35.28,32.62,30.81,33.28,31.47,32.81,33.94,33.41,32.66,32.06,30.06,29.03,27.06,27.16,27.12,27.06,26.12,29.72,30.66,31.62,33.84,34.12,34.22,32.25,31.0,29.06,28.12,30.62,30.09,34.31,37.16,40.09,42.84,42.91,41.22,36.81,33.16,28.56,24.03,25.47,24.75,27.84,33.06,35.69,37.81,39.03,38.56,36.41,34.06,32.19,29.56,28.19,29.5,26.81,28.34,27.06,23.41,27.94,25.56,27.03,30.44,30.62,31.03,30.88,30.94,28.88,31.5,30.94,34.97,36.5,37.72,40.03,39.72,37.09,37.25,36.03,35.75,37.38,38.59,36.38,38.5,37.41,37.19,38.44,37.72,37.03,37.12,36.06,35.78,34.06,33.41,30.78,29.56,31.44,30.56,32.84,33.28,33.5,35.66,37.69,39.59,43.59,47.12,48.0,48.81,48.25,47.16,47.56,43.94,45.78,44.28,41.75,42.38,43.25,43.31,43.84,46.88,46.28,46.22,46.28,45.66,43.72,44.44,40.94,40.91,37.56,35.81,35.69,31.56,34.41,34.03,34.19,33.81,35.97,34.78,36.72,38.22,38.62,39.47,36.81,37.59,36.19,35.56,35.91,37.06,35.41,34.47,36.41,37.38,38.19,40.09,41.16,40.22,39.0,37.94,34.06,32.91,29.66,25.94,28.03,25.97,27.97,29.44,31.5,32.78,33.66,35.62,33.0,34.81,34.09,34.56,34.44,36.19,35.53,33.84,33.38,31.22,30.19,26.91,29.16,29.0,28.06,32.53,34.88,37.47,41.5,42.62,41.34,39.81,38.56,35.72,35.09,35.06,35.09,35.34,34.12,34.38,35.53,36.19,38.44,41.19,39.16,40.81,38.53,37.22,37.44,35.97,35.06,34.84,32.03,25.16,26.0,21.56,21.91,23.91,26.94,31.0,33.78,32.25,32.62,32.06,30.81,26.06,28.84,27.94,26.56,28.0,29.16,30.19,27.78,28.47,28.19,27.34,27.25,28.72,28.06,26.09,25.16,23.72,23.56,25.94,26.91,27.94,27.78,26.53,26.88,25.94,25.06,26.44,24.81,22.44,24.88,25.5,28.66,31.81,33.47,37.12,37.47,38.16,39.09,38.62,35.84,33.91,33.38,32.06,31.75,34.69,36.41,36.59,37.09,38.09,37.25,40.06,41.59,44.09,43.0,44.09,41.97,38.16,34.78,32.69,29.94,28.12,27.31,30.06,30.91,32.72,36.03,38.19,36.28,39.19,39.16,38.12,39.69,36.69,34.25,33.12,27.44,27.72,26.5,26.41,23.94,27.44,26.38,28.59,31.47,34.69,39.03,42.41,42.62,46.56,47.91,48.81,50.75,50.31,49.75,47.81,44.03,41.12,38.47,31.09,31.53,28.31,30.66,32.97,36.38,40.31,41.41,43.31,44.56,45.91,46.66,46.41,46.03,39.31,44.03,42.62,47.09,51.81,56.22,57.5,58.12,55.88,52.16,50.88,48.09,45.25,43.72,43.09,38.62,37.81,34.34,30.97,31.31,28.34,26.34,21.78,23.44,22.78,25.88,30.5,37.19,40.78,41.84,39.28,37.59,36.19,33.25,34.12,35.44,35.12,32.62,32.03,26.66,27.75,26.53,26.38,25.69,25.97,27.16,26.62,28.91,31.75,33.09,32.66,35.72,37.31,39.19,42.91,45.84,46.06,47.94,43.69,45.47,46.56,48.25,47.78,51.62,50.78,49.56,48.56,47.16,46.16,44.47,42.31,40.34,37.88,36.97,35.28,36.44,38.06,38.94,40.66,41.28,42.72,41.62,43.56,43.31,44.03,43.62,41.34,40.12,33.56,32.66,29.16,27.0,26.81,27.06,24.38,26.59,25.91,27.44,28.06,28.62,32.56,33.97,33.78,37.06,38.69,38.16,36.59,37.38,34.56,31.19,32.62,31.25,29.94,30.72,32.44,32.91,32.88,35.44,35.41,35.0,33.03,33.31,34.84,33.78,38.31,39.62,42.97,44.16,45.28,43.25,44.34,41.81,40.53,43.25,45.03,48.75,52.19,54.72,53.91,52.06,50.97,48.91,45.34,46.38,46.81,46.19,47.88,48.91,50.44,49.94,49.81,48.44,46.5,46.41,46.19,45.34,47.31,48.62,51.19,52.81,53.81,54.69,52.03,50.56,46.66,45.81,45.44,45.03,45.81,44.88,44.53,41.62,39.56,35.91,39.06,38.12,40.5,41.28,40.19,39.69,38.19,36.41,33.66,35.5,34.19,30.16,31.66,31.75,30.78,31.62,34.84,34.84,36.03,37.94,39.31,40.44,38.31,35.78,39.31,36.75,37.84,39.28,40.81,41.47,40.75,40.0,39.66,37.53,30.59,34.28,31.47,32.0,35.34,35.12,36.69,35.09,35.16,36.06,36.62,38.41,37.53,40.31,39.03,37.78,35.53,35.16,32.5,30.91,29.47,27.28,23.97,25.66,23.31,26.69,29.06,33.81,36.88,37.94,38.06,36.5,34.28,31.69,31.66,27.31,29.94,30.03,30.44,29.81,30.06,31.5,29.78,29.19,30.16,28.34,27.31,24.25,27.31,26.53,27.16,31.94,34.66,37.81,40.44,43.19,42.28,42.56,39.84,37.81,33.53,30.66,29.62,28.72,29.62,30.19,31.31,35.44,35.38,38.25,39.38,41.38,41.06,40.5,35.19,35.41,31.62,27.28,27.06,25.94,26.94,27.62,30.56,32.0,31.88,32.31,34.19,31.91,34.75,33.28,32.25,32.81,30.69,30.94,29.72,29.22,29.03,29.06,29.81,31.06,33.69,33.41,35.12,35.94,36.03,37.34,37.06,38.31,36.69,34.88,33.94,32.72,28.94,30.72,29.88,30.31,32.31,33.81,32.88,32.56,31.06,29.56,27.66,26.88,27.12,27.69,27.44,27.41,28.38,26.09,28.62,29.56,29.94,32.38,35.62,36.53,39.53,40.53,39.62,41.28,38.44,34.94,37.19,32.16,32.41,32.56,31.53,30.44,30.62,29.59,29.59,28.66,25.44,28.94,28.06,30.44,33.53,36.53,36.94,35.44,32.31,28.81,25.75,25.31,25.91,29.28,32.09,34.34,34.91,32.59,34.41,31.44,29.78,28.0,24.0,23.94,22.16,22.38,24.0,26.12,27.19,28.59,29.53,31.62,30.25,32.5,33.53,32.62,33.53,33.09,31.91,31.0,31.25,30.0,30.16,29.69,29.97,29.59,30.84,29.44,29.94,30.12,27.97,28.22,28.19,27.91,29.44,28.69,29.94,-58.59,-59.34,-58.44,-56.66,-56.59,-50.09,-45.16,-39.41,-32.44,-27.62,-27.19,-29.22:13.56,14.56,16.97,15.72,16.5,12.09,12.47,13.91,15.62,20.5,23.31,25.44,26.41,24.47,22.72,21.16,19.16,17.31,15.28,16.38,15.94,16.5,18.25,20.22,22.31,24.53,26.06,29.84,28.09,31.81,31.72,27.53,29.72,27.06,24.03,24.97,23.31,22.03,19.97,17.25,17.09,16.22,16.16,17.06,15.62,16.31,14.75,14.47,14.94,13.59,14.5,13.12,13.91,13.47,14.0,10.78,12.16,9.5,9.5,8.97,9.53,10.81,11.38,12.06,13.88,12.28,14.97,14.53,15.69,16.84,18.41,18.88,21.03,23.59,25.62,27.56,25.28,27.62,23.56,20.12,22.16,21.78,23.72,26.69,29.81,31.66,32.75,29.94,32.12,29.44,29.66,28.94,28.12,26.44,24.09,23.19,22.56,21.72,25.56,25.81,28.66,29.44,31.28,30.81,31.0,31.19,31.66,34.28,33.62,37.88,38.31,38.09,40.16,38.47,37.97,37.84,37.31,37.06,36.91,34.25,38.44,38.09,39.66,41.44,41.25,38.56,36.69,35.28,32.62,30.81,33.28,31.47,32.81,33.94,33.41,32.66,32.06,30.06,29.03,27.06,27.16,27.12,27.06,26.12,29.72,30.66,31.62,33.84,34.12,34.22,32.25,31.0,29.06,28.12,30.62,30.09,34.31,37.16,40.09,42.84,42.91,41.22,36.81,33.16,28.56,24.03,25.47,24.75,27.84,33.06,35.69,37.81,39.03,38.56,36.41,34.06,32.19,29.56,28.19,29.5,26.81,28.34,27.06,23.41,27.94,25.56,27.03,30.44,30.62,31.03,30.88,30.94,28.88,31.5,30.94,34.97,36.5,37.72,40.03,39.72,37.09,37.25,36.03,35.75,37.38,38.59,36.38,38.5,37.41,37.19,38.44,37.72,37.03,37.12,36.06,35.78,34.06,33.41,30.78,29.56,31.44,30.56,32.84,33.28,33.5,35.66,37.69,39.59,43.59,47.12,48.0,48.81,48.25,47.16,47.56,43.94,45.78,44.28,41.75,42.38,43.25,43.31,43.84,46.88,46.28,46.22,46.28,45.66,43.72,44.44,40.94,40.91,37.56,35.81,35.69,31.56,34.41,34.03,34.19,33.81,35.97,34.78,36.72,38.22,38.62,39.47,36.81,37.59,36.19,35.56,35.91,37.06,35.41,34.47,36.41,37.38,38.19,40.09,41.16,40.22,39.0,37.94,34.06,32.91,29.66,25.94,28.03,25.97,27.97,29.44,31.5,32.78,33.66,35.62,33.0,34.81,34.09,34.56,34.44,36.19,35.53,33.84,33.38,31.22,30.19,26.91,29.16,29.0,28.06,32.53,34.88,37.47,41.5,42.62,41.34,39.81,38.56,35.72,35.09,35.06,35.09,35.34,34.12,34.38,35.53,36.19,38.44,41.19,39.16,40.81,38.53,37.22,37.44,35.97,35.06,34.84,32.03,25.16,26.0,21.56,21.91,23.91,26.94,31.0,33.78,32.25,32.62,32.06,30.81,26.06,28.84,27.94,26.56,28.0,29.16,30.19,27.78,28.47,28.19,27.34,27.25,28.72,28.06,26.09,25.16,23.72,23.56,25.94,26.91,27.94,27.78,26.53,26.88,25.94,25.06,26.44,24.81,22.44,24.88,25.5,28.66,31.81,33.47,37.12,37.47,38.16,39.09,38.62,35.84,33.91,33.38,32.06,31.75,34.69,36.41,36.59,37.09,38.09,37.25,40.06,41.59,44.09,43.0,44.09,41.97,38.16,34.78,32.69,29.94,28.12,27.31,30.06,30.91,32.72,36.03,38.19,36.28,39.19,39.16,38.12,39.69,36.69,34.25,33.12,27.44,27.72,26.5,26.41,23.94,27.44,26.38,28.59,31.47,34.69,39.03,42.41,42.62,46.56,47.91,48.81,50.75,50.31,49.75,47.81,44.03,41.12,38.47,31.09,31.53,28.31,30.66,32.97,36.38,40.31,41.41,43.31,44.56,45.91,46.66,46.41,46.03,39.31,44.03,42.62,47.09,51.81,56.22,57.5,58.12,55.88,52.16,50.88,48.09,45.25,43.72,43.09,38.62,37.81,34.34,30.97,31.31,28.34,26.34,21.78,23.44,22.78,25.88,30.5,37.19,40.78,41.84,39.28,37.59,36.19,33.25,34.12,35.44,35.12,32.62,32.03,26.66,27.75,26.53,26.38,25.69,25.97,27.16,26.62,28.91,31.75,33.09,32.66,35.72,37.31,39.19,42.91,45.84,46.06,47.94,43.69,45.47,46.56,48.25,47.78,51.62,50.78,49.56,48.56,47.16,46.16,44.47,42.31,40.34,37.88,36.97,35.28,36.44,38.06,38.94,40.66,41.28,42.72,41.62,43.56,43.31,44.03,43.62,41.34,40.12,33.56,32.66,29.16,27.0,26.81,27.06,24.38,26.59,25.91,27.44,28.06,28.62,32.56,33.97,33.78,37.06,38.69,38.16,36.59,37.38,34.56,31.19,32.62,31.25,29.94,30.72,32.44,32.91,32.88,35.44,35.41,35.0,33.03,33.31,34.84,33.78,38.31,39.62,42.97,44.16,45.28,43.25,44.34,41.81,40.53,43.25,45.03,48.75,52.19,54.72,53.91,52.06,50.97,48.91,45.34,46.38,46.81,46.19,47.88,48.91,50.44,49.94,49.81,48.44,46.5,46.41,46.19,45.34,47.31,48.62,51.19,52.81,53.81,54.69,52.03,50.56,46.66,45.81,45.44,45.03,45.81,44.88,44.53,41.62,39.56,35.91,39.06,38.12,40.5,41.28,40.19,39.69,38.19,36.41,33.66,35.5,34.19,30.16,31.66,31.75,30.78,31.62,34.84,34.84,36.03,37.94,39.31,40.44,38.31,35.78,39.31,36.75,37.84,39.28,40.81,41.47,40.75,40.0,39.66,37.53,30.59,34.28,31.47,32.0,35.34,35.12,36.69,35.09,35.16,36.06,36.62,38.41,37.53,40.31,39.03,37.78,35.53,35.16,32.5,30.91,29.47,27.28,23.97,25.66,23.31,26.69,29.06,33.81,36.88,37.94,38.06,36.5,34.28,31.69,31.66,27.31,29.94,30.03,30.44,29.81,30.06,31.5,29.78,29.19,30.16,28.34,27.31,24.25,27.31,26.53,27.16,31.94,34.66,37.81,40.44,43.19,42.28,42.56,39.84,37.81,33.53,30.66,29.62,28.72,29.62,30.19,31.31,35.44,35.38,38.25,39.38,41.38,41.06,40.5,35.19,35.41,31.62,27.28,27.06,25.94,26.94,27.62,30.56,32.0,31.88,32.31,34.19,31.91,34.75,33.28,32.25,32.81,30.69,30.94,29.72,29.22,29.03,29.06,29.81,31.06,33.69,33.41,35.12,35.94,36.03,37.34,37.06,38.31,36.69,34.88,33.94,32.72,28.94,30.72,29.88,30.31,32.31,33.81,32.88,32.56,31.06,29.56,27.66,26.88,27.12,27.69,27.44,27.41,28.38,26.09,28.62,29.56,29.94,32.38,35.62,36.53,39.53,40.53,39.62,41.28,38.44,34.94,37.19,32.16,32.41,32.56,31.53,30.44,30.62,29.59,29.59,28.66,25.44,28.94,28.06,30.44,33.53,36.53,36.94,35.44,32.31,28.81,25.75,25.31,25.91,29.28,32.09,34.34,34.91,32.59,34.41,31.44,29.78,28.0,24.0,23.94,22.16,22.38,24.0,26.12,27.19,28.59,29.53,31.62,30.25,32.5,33.53,32.62,33.53,33.09,31.91,31.0,31.25,30.0,30.16,29.69,29.97,29.59,30.84,29.44,29.94,30.12,27.97,28.22,28.19,27.91,29.44,28.69,29.94,-58.59,-59.34,-58.44,-56.66,-56.59,-50.09,-45.16,-39.41,-32.44,-27.62,-27.19,-29.22,-30.09,-34.53,-38.12,-40.84,-41.44,-44.22:12.47,13.91,15.62,20.5,23.31,25.44,26.41,24.47,22.72,21.16,19.16,17.31,15.28,16.38,15.94,16.5,18.25,20.22,22.31,24.53,26.06,29.84,28.09,31.81,31.72,27.53,29.72,27.06,24.03,24.97,23.31,22.03,19.97,17.25,17.09,16.22,16.16,17.06,15.62,16.31,14.75,14.47,14.94,13.59,14.5,13.12,13.91,13.47,14.0,10.78,12.16,9.5,9.5,8.97,9.53,10.81,11.38,12.06,13.88,12.28,14.97,14.53,15.69,16.84,18.41,18.88,21.03,23.59,25.62,27.56,25.28,27.62,23.56,20.12,22.16,21.78,23.72,26.69,29.81,31.66,32.75,29.94,32.12,29.44,29.66,28.94,28.12,26.44,24.09,23.19,22.56,21.72,25.56,25.81,28.66,29.44,31.28,30.81,31.0,31.19,31.66,34.28,33.62,37.88,38.31,38.09,40.16,38.47,37.97,37.84,37.31,37.06,36.91,34.25,38.44,38.09,39.66,41.44,41.25,38.56,36.69,35.28,32.62,30.81,33.28,31.47,32.81,33.94,33.41,32.66,32.06,30.06,29.03,27.06,27.16,27.12,27.06,26.12,29.72,30.66,31.62,33.84,34.12,34.22,32.25,31.0,29.06,28.12,30.62,30.09,34.31,37.16,40.09,42.84,42.91,41.22,36.81,33.16,28.56,24.03,25.47,24.75,27.84,33.06,35.69,37.81,39.03,38.56,36.41,34.06,32.19,29.56,28.19,29.5,26.81,28.34,27.06,23.41,27.94,25.56,27.03,30.44,30.62,31.03,30.88,30.94,28.88,31.5,30.94,34.97,36.5,37.72,40.03,39.72,37.09,37.25,36.03,35.75,37.38,38.59,36.38,38.5,37.41,37.19,38.44,37.72,37.03,37.12,36.06,35.78,34.06,33.41,30.78,29.56,31.44,30.56,32.84,33.28,33.5,35.66,37.69,39.59,43.59,47.12,48.0,48.81,48.25,47.16,47.56,43.94,45.78,44.28,41.75,42.38,43.25,43.31,43.84,46.88,46.28,46.22,46.28,45.66,43.72,44.44,40.94,40.91,37.56,35.81,35.69,31.56,34.41,34.03,34.19,33.81,35.97,34.78,36.72,38.22,38.62,39.47,36.81,37.59,36.19,35.56,35.91,37.06,35.41,34.47,36.41,37.38,38.19,40.09,41.16,40.22,39.0,37.94,34.06,32.91,29.66,25.94,28.03,25.97,27.97,29.44,31.5,32.78,33.66,35.62,33.0,34.81,34.09,34.56,34.44,36.19,35.53,33.84,33.38,31.22,30.19,26.91,29.16,29.0,28.06,32.53,34.88,37.47,41.5,42.62,41.34,39.81,38.56,35.72,35.09,35.06,35.09,35.34,34.12,34.38,35.53,36.19,38.44,41.19,39.16,40.81,38.53,37.22,37.44,35.97,35.06,34.84,32.03,25.16,26.0,21.56,21.91,23.91,26.94,31.0,33.78,32.25,32.62,32.06,30.81,26.06,28.84,27.94,26.56,28.0,29.16,30.19,27.78,28.47,28.19,27.34,27.25,28.72,28.06,26.09,25.16,23.72,23.56,25.94,26.91,27.94,27.78,26.53,26.88,25.94,25.06,26.44,24.81,22.44,24.88,25.5,28.66,31.81,33.47,37.12,37.47,38.16,39.09,38.62,35.84,33.91,33.38,32.06,31.75,34.69,36.41,36.59,37.09,38.09,37.25,40.06,41.59,44.09,43.0,44.09,41.97,38.16,34.78,32.69,29.94,28.12,27.31,30.06,30.91,32.72,36.03,38.19,36.28,39.19,39.16,38.12,39.69,36.69,34.25,33.12,27.44,27.72,26.5,26.41,23.94,27.44,26.38,28.59,31.47,34.69,39.03,42.41,42.62,46.56,47.91,48.81,50.75,50.31,49.75,47.81,44.03,41.12,38.47,31.09,31.53,28.31,30.66,32.97,36.38,40.31,41.41,43.31,44.56,45.91,46.66,46.41,46.03,39.31,44.03,42.62,47.09,51.81,56.22,57.5,58.12,55.88,52.16,50.88,48.09,45.25,43.72,43.09,38.62,37.81,34.34,30.97,31.31,28.34,26.34,21.78,23.44,22.78,25.88,30.5,37.19,40.78,41.84,39.28,37.59,36.19,33.25,34.12,35.44,35.12,32.62,32.03,26.66,27.75,26.53,26.38,25.69,25.97,27.16,26.62,28.91,31.75,33.09,32.66,35.72,37.31,39.19,42.91,45.84,46.06,47.94,43.69,45.47,46.56,48.25,47.78,51.62,50.78,49.56,48.56,47.16,46.16,44.47,42.31,40.34,37.88,36.97,35.28,36.44,38.06,38.94,40.66,41.28,42.72,41.62,43.56,43.31,44.03,43.62,41.34,40.12,33.56,32.66,29.16,27.0,26.81,27.06,24.38,26.59,25.91,27.44,28.06,28.62,32.56,33.97,33.78,37.06,38.69,38.16,36.59,37.38,34.56,31.19,32.62,31.25,29.94,30.72,32.44,32.91,32.88,35.44,35.41,35.0,33.03,33.31,34.84,33.78,38.31,39.62,42.97,44.16,45.28,43.25,44.34,41.81,40.53,43.25,45.03,48.75,52.19,54.72,53.91,52.06,50.97,48.91,45.34,46.38,46.81,46.19,47.88,48.91,50.44,49.94,49.81,48.44,46.5,46.41,46.19,45.34,47.31,48.62,51.19,52.81,53.81,54.69,52.03,50.56,46.66,45.81,45.44,45.03,45.81,44.88,44.53,41.62,39.56,35.91,39.06,38.12,40.5,41.28,40.19,39.69,38.19,36.41,33.66,35.5,34.19,30.16,31.66,31.75,30.78,31.62,34.84,34.84,36.03,37.94,39.31,40.44,38.31,35.78,39.31,36.75,37.84,39.28,40.81,41.47,40.75,40.0,39.66,37.53,30.59,34.28,31.47,32.0,35.34,35.12,36.69,35.09,35.16,36.06,36.62,38.41,37.53,40.31,39.03,37.78,35.53,35.16,32.5,30.91,29.47,27.28,23.97,25.66,23.31,26.69,29.06,33.81,36.88,37.94,38.06,36.5,34.28,31.69,31.66,27.31,29.94,30.03,30.44,29.81,30.06,31.5,29.78,29.19,30.16,28.34,27.31,24.25,27.31,26.53,27.16,31.94,34.66,37.81,40.44,43.19,42.28,42.56,39.84,37.81,33.53,30.66,29.62,28.72,29.62,30.19,31.31,35.44,35.38,38.25,39.38,41.38,41.06,40.5,35.19,35.41,31.62,27.28,27.06,25.94,26.94,27.62,30.56,32.0,31.88,32.31,34.19,31.91,34.75,33.28,32.25,32.81,30.69,30.94,29.72,29.22,29.03,29.06,29.81,31.06,33.69,33.41,35.12,35.94,36.03,37.34,37.06,38.31,36.69,34.88,33.94,32.72,28.94,30.72,29.88,30.31,32.31,33.81,32.88,32.56,31.06,29.56,27.66,26.88,27.12,27.69,27.44,27.41,28.38,26.09,28.62,29.56,29.94,32.38,35.62,36.53,39.53,40.53,39.62,41.28,38.44,34.94,37.19,32.16,32.41,32.56,31.53,30.44,30.62,29.59,29.59,28.66,25.44,28.94,28.06,30.44,33.53,36.53,36.94,35.44,32.31,28.81,25.75,25.31,25.91,29.28,32.09,34.34,34.91,32.59,34.41,31.44,29.78,28.0,24.0,23.94,22.16,22.38,24.0,26.12,27.19,28.59,29.53,31.62,30.25,32.5,33.53,32.62,33.53,33.09,31.91,31.0,31.25,30.0,30.16,29.69,29.97,29.59,30.84,29.44,29.94,30.12,27.97,28.22,28.19,27.91,29.44,28.69,29.94,-58.59,-59.34,-58.44,-56.66,-56.59,-50.09,-45.16,-39.41,-32.44,-27.62,-27.19,-29.22,-30.09,-34.53,-38.12,-40.84,-41.44,-44.22,-45.47,-46.66,-46.94,-48.53,-48.88,-48.91:26.41,24.47,22.72,21.16,19.16,17.31,15.28,16.38,15.94,16.5,18.25,20.22,22.31,24.53,26.06,29.84,28.09,31.81,31.72,27.53,29.72,27.06,24.03,24.97,23.31,22.03,19.97,17.25,17.09,16.22,16.16,17.06,15.62,16.31,14.75,14.47,14.94,13.59,14.5,13.12,13.91,13.47,14.0,10.78,12.16,9.5,9.5,8.97,9.53,10.81,11.38,12.06,13.88,12.28,14.97,14.53,15.69,16.84,18.41,18.88,21.03,23.59,25.62,27.56,25.28,27.62,23.56,20.12,22.16,21.78,23.72,26.69,29.81,31.66,32.75,29.94,32.12,29.44,29.66,28.94,28.12,26.44,24.09,23.19,22.56,21.72,25.56,25.81,28.66,29.44,31.28,30.81,31.0,31.19,31.66,34.28,33.62,37.88,38.31,38.09,40.16,38.47,37.97,37.84,37.31,37.06,36.91,34.25,38.44,38.09,39.66,41.44,41.25,38.56,36.69,35.28,32.62,30.81,33.28,31.47,32.81,33.94,33.41,32.66,32.06,30.06,29.03,27.06,27.16,27.12,27.06,26.12,29.72,30.66,31.62,33.84,34.12,34.22,32.25,31.0,29.06,28.12,30.62,30.09,34.31,37.16,40.09,42.84,42.91,41.22,36.81,33.16,28.56,24.03,25.47,24.75,27.84,33.06,35.69,37.81,39.03,38.56,36.41,34.06,32.19,29.56,28.19,29.5,26.81,28.34,27.06,23.41,27.94,25.56,27.03,30.44,30.62,31.03,30.88,30.94,28.88,31.5,30.94,34.97,36.5,37.72,40.03,39.72,37.09,37.25,36.03,35.75,37.38,38.59,36.38,38.5,37.41,37.19,38.44,37.72,37.03,37.12,36.06,35.78,34.06,33.41,30.78,29.56,31.44,30.56,32.84,33.28,33.5,35.66,37.69,39.59,43.59,47.12,48.0,48.81,48.25,47.16,47.56,43.94,45.78,44.28,41.75,42.38,43.25,43.31,43.84,46.88,46.28,46.22,46.28,45.66,43.72,44.44,40.94,40.91,37.56,35.81,35.69,31.56,34.41,34.03,34.19,33.81,35.97,34.78,36.72,38.22,38.62,39.47,36.81,37.59,36.19,35.56,35.91,37.06,35.41,34.47,36.41,37.38,38.19,40.09,41.16,40.22,39.0,37.94,34.06,32.91,29.66,25.94,28.03,25.97,27.97,29.44,31.5,32.78,33.66,35.62,33.0,34.81,34.09,34.56,34.44,36.19,35.53,33.84,33.38,31.22,30.19,26.91,29.16,29.0,28.06,32.53,34.88,37.47,41.5,42.62,41.34,39.81,38.56,35.72,35.09,35.06,35.09,35.34,34.12,34.38,35.53,36.19,38.44,41.19,39.16,40.81,38.53,37.22,37.44,35.97,35.06,34.84,32.03,25.16,26.0,21.56,21.91,23.91,26.94,31.0,33.78,32.25,32.62,32.06,30.81,26.06,28.84,27.94,26.56,28.0,29.16,30.19,27.78,28.47,28.19,27.34,27.25,28.72,28.06,26.09,25.16,23.72,23.56,25.94,26.91,27.94,27.78,26.53,26.88,25.94,25.06,26.44,24.81,22.44,24.88,25.5,28.66,31.81,33.47,37.12,37.47,38.16,39.09,38.62,35.84,33.91,33.38,32.06,31.75,34.69,36.41,36.59,37.09,38.09,37.25,40.06,41.59,44.09,43.0,44.09,41.97,38.16,34.78,32.69,29.94,28.12,27.31,30.06,30.91,32.72,36.03,38.19,36.28,39.19,39.16,38.12,39.69,36.69,34.25,33.12,27.44,27.72,26.5,26.41,23.94,27.44,26.38,28.59,31.47,34.69,39.03,42.41,42.62,46.56,47.91,48.81,50.75,50.31,49.75,47.81,44.03,41.12,38.47,31.09,31.53,28.31,30.66,32.97,36.38,40.31,41.41,43.31,44.56,45.91,46.66,46.41,46.03,39.31,44.03,42.62,47.09,51.81,56.22,57.5,58.12,55.88,52.16,50.88,48.09,45.25,43.72,43.09,38.62,37.81,34.34,30.97,31.31,28.34,26.34,21.78,23.44,22.78,25.88,30.5,37.19,40.78,41.84,39.28,37.59,36.19,33.25,34.12,35.44,35.12,32.62,32.03,26.66,27.75,26.53,26.38,25.69,25.97,27.16,26.62,28.91,31.75,33.09,32.66,35.72,37.31,39.19,42.91,45.84,46.06,47.94,43.69,45.47,46.56,48.25,47.78,51.62,50.78,49.56,48.56,47.16,46.16,44.47,42.31,40.34,37.88,36.97,35.28,36.44,38.06,38.94,40.66,41.28,42.72,41.62,43.56,43.31,44.03,43.62,41.34,40.12,33.56,32.66,29.16,27.0,26.81,27.06,24.38,26.59,25.91,27.44,28.06,28.62,32.56,33.97,33.78,37.06,38.69,38.16,36.59,37.38,34.56,31.19,32.62,31.25,29.94,30.72,32.44,32.91,32.88,35.44,35.41,35.0,33.03,33.31,34.84,33.78,38.31,39.62,42.97,44.16,45.28,43.25,44.34,41.81,40.53,43.25,45.03,48.75,52.19,54.72,53.91,52.06,50.97,48.91,45.34,46.38,46.81,46.19,47.88,48.91,50.44,49.94,49.81,48.44,46.5,46.41,46.19,45.34,47.31,48.62,51.19,52.81,53.81,54.69,52.03,50.56,46.66,45.81,45.44,45.03,45.81,44.88,44.53,41.62,39.56,35.91,39.06,38.12,40.5,41.28,40.19,39.69,38.19,36.41,33.66,35.5,34.19,30.16,31.66,31.75,30.78,31.62,34.84,34.84,36.03,37.94,39.31,40.44,38.31,35.78,39.31,36.75,37.84,39.28,40.81,41.47,40.75,40.0,39.66,37.53,30.59,34.28,31.47,32.0,35.34,35.12,36.69,35.09,35.16,36.06,36.62,38.41,37.53,40.31,39.03,37.78,35.53,35.16,32.5,30.91,29.47,27.28,23.97,25.66,23.31,26.69,29.06,33.81,36.88,37.94,38.06,36.5,34.28,31.69,31.66,27.31,29.94,30.03,30.44,29.81,30.06,31.5,29.78,29.19,30.16,28.34,27.31,24.25,27.31,26.53,27.16,31.94,34.66,37.81,40.44,43.19,42.28,42.56,39.84,37.81,33.53,30.66,29.62,28.72,29.62,30.19,31.31,35.44,35.38,38.25,39.38,41.38,41.06,40.5,35.19,35.41,31.62,27.28,27.06,25.94,26.94,27.62,30.56,32.0,31.88,32.31,34.19,31.91,34.75,33.28,32.25,32.81,30.69,30.94,29.72,29.22,29.03,29.06,29.81,31.06,33.69,33.41,35.12,35.94,36.03,37.34,37.06,38.31,36.69,34.88,33.94,32.72,28.94,30.72,29.88,30.31,32.31,33.81,32.88,32.56,31.06,29.56,27.66,26.88,27.12,27.69,27.44,27.41,28.38,26.09,28.62,29.56,29.94,32.38,35.62,36.53,39.53,40.53,39.62,41.28,38.44,34.94,37.19,32.16,32.41,32.56,31.53,30.44,30.62,29.59,29.59,28.66,25.44,28.94,28.06,30.44,33.53,36.53,36.94,35.44,32.31,28.81,25.75,25.31,25.91,29.28,32.09,34.34,34.91,32.59,34.41,31.44,29.78,28.0,24.0,23.94,22.16,22.38,24.0,26.12,27.19,28.59,29.53,31.62,30.25,32.5,33.53,32.62,33.53,33.09,31.91,31.0,31.25,30.0,30.16,29.69,29.97,29.59,30.84,29.44,29.94,30.12,27.97,28.22,28.19,27.91,29.44,28.69,29.94,-58.59,-59.34,-58.44,-56.66,-56.59,-50.09,-45.16,-39.41,-32.44,-27.62,-27.19,-29.22,-30.09,-34.53,-38.12,-40.84,-41.44,-44.22,-45.47,-46.66,-46.94,-48.53,-48.88,-48.91,-50.94,-49.59,-48.34,-47.16,-44.69,-41.75:negativity
26.62,28.34,30.56,33.62,36.62,37.28,38.94,38.19,36.53,36.19,33.12,32.19,30.16,29.78,30.5,31.31,33.34,34.59,36.66,39.03,38.81,40.66,42.62,42.59,42.69,42.5,42.78,43.0,43.94,44.84,46.38,45.69,48.5,49.22,50.81,52.78,54.25,55.06,54.44,53.69,51.66,49.34,46.97,44.31,43.06,42.94,41.62,45.06,46.41,48.66,51.47,54.88,56.44,59.28,59.59,60.56,60.28,58.41,55.88,54.25,50.12,48.75,44.84,43.66,45.59,45.44,48.81,51.41,52.5,54.66,53.56,52.91,52.12,51.25,48.09,46.53,44.62,44.81,44.16,44.22,45.31,46.28,45.09,46.5,47.97,48.25,50.53,51.81,53.75,55.31,57.31,57.06,56.06,56.69,54.88,54.22,53.84,53.62,54.0,55.53,55.62,56.41,56.56,55.5,54.38,52.59,51.44,52.25,53.19,53.31,54.78,54.25,53.84,52.47,52.75,51.66,50.78,50.41,48.97,47.56,47.53,47.66,49.25,50.69,50.91,52.56,52.5,53.41,53.28,54.78,55.09,55.31,54.84,54.91,54.06,52.19,51.62,49.88,48.56,48.19,47.47,48.38,50.06,52.62,53.78,55.25,54.97,55.44,55.66,56.25,56.56,57.06,56.69,55.81,53.41,51.72,49.81,48.72,47.5,49.06,51.53,54.41,58.94,62.41,64.84,64.69,64.78,60.84,57.22,51.94,47.25,43.75,41.69,41.03,40.94,42.81,44.03,46.41,48.34,49.91,52.38,54.0,54.06,54.16,52.56,50.25,49.5,47.66,47.56,48.59,47.44,46.81,47.97,46.12,46.34,47.34,48.03,49.12,50.81,52.66,54.25,55.59,58.0,58.53,58.84,57.53,57.16,55.88,54.88,56.72,57.44,58.66,58.62,57.53,56.19,53.25,53.34,53.84,54.41,55.06,57.31,57.41,57.25,59.06,58.16,57.31,56.91,55.53,55.84,56.59,58.56,59.66,60.66,60.19,57.81,54.47,51.19,47.47,43.81,44.0,43.41,44.94,45.81,47.06,48.25,47.91,47.38,46.25,45.44,44.69,43.97,43.69,42.69,42.06,40.88,40.97,41.53,42.06,44.19,45.59,46.66,48.0,47.69,48.56,48.78,49.19,48.56,47.84,46.03,43.97,42.25,40.91,40.5,39.5,39.22,38.66,37.91,38.97,41.56,44.06,48.62,51.31,51.81,52.16,50.69,48.69,47.44,46.62,46.91,47.84,49.16,50.66,52.12,52.81,53.19,54.88,54.59,55.16,54.12,51.81,47.25,44.25,43.16,41.84,43.12,46.22,49.38,53.81,57.0,59.72,60.56,62.19,61.59,61.59,60.53,61.06,60.12,60.0,60.41,59.25,61.03,61.06,60.5,60.78,60.91,61.19,60.97,59.25,59.94,57.34,55.41,55.38,54.12,55.31,55.5,54.03,54.44,54.38,52.88,52.75,51.06,49.19,47.34,45.84,45.31,44.53,43.66,46.41,46.44,48.59,50.53,51.28,53.16,53.81,54.72,56.03,56.78,56.88,56.06,54.19,51.34,50.59,49.44,49.16,50.28,51.44,52.28,53.75,54.12,54.06,52.62,49.56,47.31,45.62,43.16,40.72,40.97,40.38,38.94,39.91,40.19,41.81,43.25,45.53,46.12,46.19,46.28,45.12,42.97,43.34,43.31,44.81,47.25,50.06,53.53,56.0,59.19,60.66,60.91,60.66,57.88,56.94,54.84,53.5,53.91,52.56,52.31,52.03,50.94,49.16,49.44,48.5,49.44,50.25,50.69,51.56,51.25,51.0,50.06,49.62,47.97,47.94,47.66,48.12,48.09,48.31,47.59,47.34,46.06,47.28,46.97,47.22,47.69,47.69,45.81,45.66,43.97,43.88,44.41,44.84,47.03,48.62,51.28,51.81,51.91,54.0,53.03,52.59,53.28,51.78,50.41,49.78,48.38,47.53,47.53,47.34,48.75,49.41,49.5,52.03,51.62,51.12,50.34,49.62,47.78,46.19,45.59,45.12,44.81,45.5,47.06,48.28,49.47,49.88,48.44,46.91,45.84,43.78,42.38,42.12,42.84,43.34,45.22,45.09,45.56,45.62,43.94,44.56,43.47,43.09,43.97,44.19,45.34,46.25,46.81,46.72,46.16,44.38,43.59,42.12,41.94,44.28,45.09,47.88,50.03,50.5,52.34,50.88,49.34,49.47,48.69,49.81,49.81,50.44,49.78,49.25,47.69,46.62,45.16,44.38,42.62,43.5,43.81,44.62,45.12,47.5,48.5,49.56,48.62,47.91,48.19,47.31,47.91,48.56,49.25,49.56,49.84,50.72,51.62,51.72,53.62,51.53,53.25,51.28,51.34,51.5,51.94,54.12,55.38,58.56,60.47,61.0,60.34,60.91,60.0,59.16,58.97,58.0,57.09,57.5,58.25,59.56,61.56,62.28,62.0,61.38,60.78,58.16,58.53,58.06,55.72,56.06,55.38,53.81,53.94,53.25,52.88,52.09,50.16,49.34,48.84,48.66,49.56,51.31,53.28,54.53,56.09,56.75,58.22,59.66,60.59,61.59,63.06,63.06,62.5,62.06,60.56,59.81,56.81,56.19,53.81,53.56,52.56,53.12,52.94,53.16,52.53,53.25,53.19,53.03,51.72,49.72,47.78,46.78,45.97,47.53,48.31,48.59,50.66,50.34,50.38,49.88,49.12,48.94,47.06,47.62,47.62,50.19,54.0,57.41,57.56,61.09,59.06,57.81,56.53,55.5,53.94,52.41,52.53,52.44,53.44,52.97,53.34,53.12,51.94,50.5,51.03,49.5,48.94,48.12,46.03,45.62,44.78,44.72,43.72,44.0,44.06,43.12,43.41,43.31,43.84,44.69,45.84,47.91,49.47,51.03,52.0,52.88,52.97,52.03,50.81,49.5,48.88,48.34,49.38,50.75,51.72,52.84,53.56,55.22,55.06,56.25,56.66,55.53,54.75,55.25,54.38,53.94,54.56,54.81,54.0,54.16,54.31,53.94,55.28,55.28,54.78,55.28,55.19,54.38,55.81,56.66,56.91,57.28,57.44,57.69,56.81,57.94,58.41,58.56,57.91,58.09,57.69,55.81,56.06,56.09,54.12,54.03,53.31,51.81,52.53,51.44,51.34,52.28,51.72,53.28,54.53,55.25,57.09,57.16,55.88,54.78,52.91,54.03,53.0,53.06,53.44,52.34,51.41,52.16,52.72,53.78,56.25,57.88,58.31,58.5,58.22,58.38,57.38,58.25,57.69,58.25,58.38,58.25,57.06,58.56,57.16,56.84,57.22,57.34,56.41,56.06,54.91,54.06,53.0,51.94,51.16,53.06,53.69,55.47,55.69,55.56,53.88,52.06,50.31,49.53,48.31,49.16,49.53,49.66,49.59,47.81,48.38,48.66,49.47,51.59,53.5,55.25,55.75,56.66,54.97,54.44,53.88,53.16,52.75,52.09,51.66,51.19,49.88,49.81,50.59,51.03,51.62,51.28,53.06,53.06,53.0,53.09,54.25,53.84,52.88,51.88,51.12,49.59,49.5,51.75,53.66,51.0,54.44,53.16,50.81,52.19,52.78,54.19,55.0,54.53,52.97,49.5,49.31,49.19,49.84,51.16,53.41,52.56,51.72,50.5,49.03,47.41,46.69,45.38,44.34,42.62,41.62,40.69,38.75,38.06,38.12,38.06,38.94,39.31,40.06,40.28,40.72,41.41,42.41,41.69,42.0,41.69,40.66,40.91,40.78,39.91,39.69,39.81,40.12,41.97,45.19,49.25,53.12,55.59,56.53,56.81,53.09,51.5,48.38,46.69,45.94,46.56,48.03,47.84,48.81,49.12,49.84,49.62,50.62,51.5,51.41,52.44,52.28,51.56,51.16,50.91,50.25,49.97,48.16,48.78:38.94,38.19,36.53,36.19,33.12,32.19,30.16,29.78,30.5,31.31,33.34,34.59,36.66,39.03,38.81,40.66,42.62,42.59,42.69,42.5,42.78,43.0,43.94,44.84,46.38,45.69,48.5,49.22,50.81,52.78,54.25,55.06,54.44,53.69,51.66,49.34,46.97,44.31,43.06,42.94,41.62,45.06,46.41,48.66,51.47,54.88,56.44,59.28,59.59,60.56,60.28,58.41,55.88,54.25,50.12,48.75,44.84,43.66,45.59,45.44,48.81,51.41,52.5,54.66,53.56,52.91,52.12,51.25,48.09,46.53,44.62,44.81,44.16,44.22,45.31,46.28,45.09,46.5,47.97,48.25,50.53,51.81,53.75,55.31,57.31,57.06,56.06,56.69,54.88,54.22,53.84,53.62,54.0,55.53,55.62,56.41,56.56,55.5,54.38,52.59,51.44,52.25,53.19,53.31,54.78,54.25,53.84,52.47,52.75,51.66,50.78,50.41,48.97,47.56,47.53,47.66,49.25,50.69,50.91,52.56,52.5,53.41,53.28,54.78,55.09,55.31,54.84,54.91,54.06,52.19,51.62,49.88,48.56,48.19,47.47,48.38,50.06,52.62,53.78,55.25,54.97,55.44,55.66,56.25,56.56,57.06,56.69,55.81,53.41,51.72,49.81,48.72,47.5,49.06,51.53,54.41,58.94,62.41,64.84,64.69,64.78,60.84,57.22,51.94,47.25,43.75,41.69,41.03,40.94,42.81,44.03,46.41,48.34,49.91,52.38,54.0,54.06,54.16,52.56,50.25,49.5,47.66,47.56,48.59,47.44,46.81,47.97,46.12,46.34,47.34,48.03,49.12,50.81,52.66,54.25,55.59,58.0,58.53,58.84,57.53,57.16,55.88,54.88,56.72,57.44,58.66,58.62,57.53,56.19,53.25,53.34,53.84,54.41,55.06,57.31,57.41,57.25,59.06,58.16,57.31,56.91,55.53,55.84,56.59,58.56,59.66,60.66,60.19,57.81,54.47,51.19,47.47,43.81,44.0,43.41,44.94,45.81,47.06,48.25,47.91,47.38,46.25,45.44,44.69,43.97,43.69,42.69,42.06,40.88,40.97,41.53,42.06,44.19,45.59,46.66,48.0,47.69,48.56,48.78,49.19,48.56,47.84,46.03,43.97,42.25,40.91,40.5,39.5,39.22,38.66,37.91,38.97,41.56,44.06,48.62,51.31,51.81,52.16,50.69,48.69,47.44,46.62,46.91,47.84,49.16,50.66,52.12,52.81,53.19,54.88,54.59,55.16,54.12,51.81,47.25,44.25,43.16,41.84,43.12,46.22,49.38,53.81,57.0,59.72,60.56,62.19,61.59,61.59,60.53,61.06,60.12,60.0,60.41,59.25,61.03,61.06,60.5,60.78,60.91,61.19,60.97,59.25,59.94,57.34,55.41,55.38,54.12,55.31,55.5,54.03,54.44,54.38,52.88,52.75,51.06,49.19,47.34,45.84,45.31,44.53,43.66,46.41,46.44,48.59,50.53,51.28,53.16,53.81,54.72,56.03,56.78,56.88,56.06,54.19,51.34,50.59,49.44,49.16,50.28,51.44,52.28,53.75,54.12,54.06,52.62,49.56,47.31,45.62,43.16,40.72,40.97,40.38,38.94,39.91,40.19,41.81,43.25,45.53,46.12,46.19,46.28,45.12,42.97,43.34,43.31,44.81,47.25,50.06,53.53,56.0,59.19,60.66,60.91,60.66,57.88,56.94,54.84,53.5,53.91,52.56,52.31,52.03,50.94,49.16,49.44,48.5,49.44,50.25,50.69,51.56,51.25,51.0,50.06,49.62,47.97,47.94,47.66,48.12,48.09,48.31,47.59,47.34,46.06,47.28,46.97,47.22,47.69,47.69,45.81,45.66,43.97,43.88,44.41,44.84,47.03,48.62,51.28,51.81,51.91,54.0,53.03,52.59,53.28,51.78,50.41,49.78,48.38,47.53,47.53,47.34,48.75,49.41,49.5,52.03,51.62,51.12,50.34,49.62,47.78,46.19,45.59,45.12,44.81,45.5,47.06,48.28,49.47,49.88,48.44,46.91,45.84,43.78,42.38,42.12,42.84,43.34,45.22,45.09,45.56,45.62,43.94,44.56,43.47,43.09,43.97,44.19,45.34,46.25,46.81,46.72,46.16,44.38,43.59,42.12,41.94,44.28,45.09,47.88,50.03,50.5,52.34,50.88,49.34,49.47,48.69,49.81,49.81,50.44,49.78,49.25,47.69,46.62,45.16,44.38,42.62,43.5,43.81,44.62,45.12,47.5,48.5,49.56,48.62,47.91,48.19,47.31,47.91,48.56,49.25,49.56,49.84,50.72,51.62,51.72,53.62,51.53,53.25,51.28,51.34,51.5,51.94,54.12,55.38,58.56,60.47,61.0,60.34,60.91,60.0,59.16,58.97,58.0,57.09,57.5,58.25,59.56,61.56,62.28,62.0,61.38,60.78,58.16,58.53,58.06,55.72,56.06,55.38,53.81,53.94,53.25,52.88,52.09,50.16,49.34,48.84,48.66,49.56,51.31,53.28,54.53,56.09,56.75,58.22,59.66,60.59,61.59,63.06,63.06,62.5,62.06,60.56,59.81,56.81,56.19,53.81,53.56,52.56,53.12,52.94,53.16,52.53,53.25,53.19,53.03,51.72,49.72,47.78,46.78,45.97,47.53,48.31,48.59,50.66,50.34,50.38,49.88,49.12,48.94,47.06,47.62,47.62,50.19,54.0,57.41,57.56,61.09,59.06,57.81,56.53,55.5,53.94,52.41,52.53,52.44,53.44,52.97,53.34,53.12,51.94,50.5,51.03,49.5,48.94,48.12,46.03,45.62,44.78,44.72,43.72,44.0,44.06,43.12,43.41,43.31,43.84,44.69,45.84,47.91,49.47,51.03,52.0,52.88,52.97,52.03,50.81,49.5,48.88,48.34,49.38,50.75,51.72,52.84,53.56,55.22,55.06,56.25,56.66,55.53,54.75,55.25,54.38,53.94,54.56,54.81,54.0,54.16,54.31,53.94,55.28,55.28,54.78,55.28,55.19,54.38,55.81,56.66,56.91,57.28,57.44,57.69,56.81,57.94,58.41,58.56,57.91,58.09,57.69,55.81,56.06,56.09,54.12,54.03,53.31,51.81,52.53,51.44,51.34,52.28,51.72,53.28,54.53,55.25,57.09,57.16,55.88,54.78,52.91,54.03,53.0,53.06,53.44,52.34,51.41,52.16,52.72,53.78,56.25,57.88,58.31,58.5,58.22,58.38,57.38,58.25,57.69,58.25,58.38,58.25,57.06,58.56,57.16,56.84,57.22,57.34,56.41,56.06,54.91,54.06,53.0,51.94,51.16,53.06,53.69,55.47,55.69,55.56,53.88,52.06,50.31,49.53,48.31,49.16,49.53,49.66,49.59,47.81,48.38,48.66,49.47,51.59,53.5,55.25,55.75,56.66,54.97,54.44,53.88,53.16,52.75,52.09,51.66,51.19,49.88,49.81,50.59,51.03,51.62,51.28,53.06,53.06,53.0,53.09,54.25,53.84,52.88,51.88,51.12,49.59,49.5,51.75,53.66,51.0,54.44,53.16,50.81,52.19,52.78,54.19,55.0,54.53,52.97,49.5,49.31,49.19,49.84,51.16,53.41,52.56,51.72,50.5,49.03,47.41,46.69,45.38,44.34,42.62,41.62,40.69,38.75,38.06,38.12,38.06,38.94,39.31,40.06,40.28,40.72,41.41,42.41,41.69,42.0,41.69,40.66,40.91,40.78,39.91,39.69,39.81,40.12,41.97,45.19,49.25,53.12,55.59,56.53,56.81,53.09,51.5,48.38,46.69,45.94,46.56,48.03,47.84,48.81,49.12,49.84,49.62,50.62,51.5,51.41,52.44,52.28,51.56,51.16,50.91,50.25,49.97,48.16,48.78,-12.5,-10.53,-8.41,-4.62,-1.12,1.06:30.16,29.78,30.5,31.31,33.34,34.59,36.66,39.03,38.81,40.66,42.62,42.59,42.69,42.5,42.78,43.0,43.94,44.84,46.38,45.69,48.5,49.22,50.81,52.78,54.25,55.06,54.44,53.69,51.66,49.34,46.97,44.31,43.06,42.94,41.62,45.06,46.41,48.66,51.47,54.88,56.44,59.28,59.59,60.56,60.28,58.41,55.88,54.25,50.12,48.75,44.84,43.66,45.59,45.44,48.81,51.41,52.5,54.66,53.56,52.91,52.12,51.25,48.09,46.53,44.62,44.81,44.16,44.22,45.31,46.28,45.09,46.5,47.97,48.25,50.53,51.81,53.75,55.31,57.31,57.06,56.06,56.69,54.88,54.22,53.84,53.62,54.0,55.53,55.62,56.41,56.56,55.5,54.38,52.59,51.44,52.25,53.19,53.31,54.78,54.25,53.84,52.47,52.75,51.66,50.78,50.41,48.97,47.56,47.53,47.66,49.25,50.69,50.91,52.56,52.5,53.41,53.28,54.78,55.09,55.31,54.84,54.91,54.06,52.19,51.62,49.88,48.56,48.19,47.47,48.38,50.06,52.62,53.78,55.25,54.97,55.44,55.66,56.25,56.56,57.06,56.69,55.81,53.41,51.72,49.81,48.72,47.5,49.06,51.53,54.41,58.94,62.41,64.84,64.69,64.78,60.84,57.22,51.94,47.25,43.75,41.69,41.03,40.94,42.81,44.03,46.41,48.34,49.91,52.38,54.0,54.06,54.16,52.56,50.25,49.5,47.66,47.56,48.59,47.44,46.81,47.97,46.12,46.34,47.34,48.03,49.12,50.81,52.66,54.25,55.59,58.0,58.53,58.84,57.53,57.16,55.88,54.88,56.72,57.44,58.66,58.62,57.53,56.19,53.25,53.34,53.84,54.41,55.06,57.31,57.41,57.25,59.06,58.16,57.31,56.91,55.53,55.84,56.59,58.56,59.66,60.66,60.19,57.81,54.47,51.19,47.47,43.81,44.0,43.41,44.94,45.81,47.06,48.25,47.91,47.38,46.25,45.44,44.69,43.97,43.69,42.69,42.06,40.88,40.97,41.53,42.06,44.19,45.59,46.66,48.0,47.69,48.56,48.78,49.19,48.56,47.84,46.03,43.97,42.25,40.91,40.5,39.5,39.22,38.66,37.91,38.97,41.56,44.06,48.62,51.31,51.81,52.16,50.69,48.69,47.44,46.62,46.91,47.84,49.16,50.66,52.12,52.81,53.19,54.88,54.59,55.16,54.12,51.81,47.25,44.25,43.16,41.84,43.12,46.22,49.38,53.81,57.0,59.72,60.56,62.19,61.59,61.59,60.53,61.06,60.12,60.0,60.41,59.25,61.03,61.06,60.5,60.78,60.91,61.19,60.97,59.25,59.94,57.34,55.41,55.38,54.12,55.31,55.5,54.03,54.44,54.38,52.88,52.75,51.06,49.19,47.34,45.84,45.31,44.53,43.66,46.41,46.44,48.59,50.53,51.28,53.16,53.81,54.72,56.03,56.78,56.88,56.06,54.19,51.34,50.59,49.44,49.16,50.28,51.44,52.28,53.75,54.12,54.06,52.62,49.56,47.31,45.62,43.16,40.72,40.97,40.38,38.94,39.91,40.19,41.81,43.25,45.53,46.12,46.19,46.28,45.12,42.97,43.34,43.31,44.81,47.25,50.06,53.53,56.0,59.19,60.66,60.91,60.66,57.88,56.94,54.84,53.5,53.91,52.56,52.31,52.03,50.94,49.16,49.44,48.5,49.44,50.25,50.69,51.56,51.25,51.0,50.06,49.62,47.97,47.94,47.66,48.12,48.09,48.31,47.59,47.34,46.06,47.28,46.97,47.22,47.69,47.69,45.81,45.66,43.97,43.88,44.41,44.84,47.03,48.62,51.28,51.81,51.91,54.0,53.03,52.59,53.28,51.78,50.41,49.78,48.38,47.53,47.53,47.34,48.75,49.41,49.5,52.03,51.62,51.12,50.34,49.62,47.78,46.19,45.59,45.12,44.81,45.5,47.06,48.28,49.47,49.88,48.44,46.91,45.84,43.78,42.38,42.12,42.84,43.34,45.22,45.09,45.56,45.62,43.94,44.56,43.47,43.09,43.97,44.19,45.34,46.25,46.81,46.72,46.16,44.38,43.59,42.12,41.94,44.28,45.09,47.88,50.03,50.5,52.34,50.88,49.34,49.47,48.69,49.81,49.81,50.44,49.78,49.25,47.69,46.62,45.16,44.38,42.62,43.5,43.81,44.62,45.12,47.5,48.5,49.56,48.62,47.91,48.19,47.31,47.91,48.56,49.25,49.56,49.84,50.72,51.62,51.72,53.62,51.53,53.25,51.28,51.34,51.5,51.94,54.12,55.38,58.56,60.47,61.0,60.34,60.91,60.0,59.16,58.97,58.0,57.09,57.5,58.25,59.56,61.56,62.28,62.0,61.38,60.78,58.16,58.53,58.06,55.72,56.06,55.38,53.81,53.94,53.25,52.88,52.09,50.16,49.34,48.84,48.66,49.56,51.31,53.28,54.53,56.09,56.75,58.22,59.66,60.59,61.59,63.06,63.06,62.5,62.06,60.56,59.81,56.81,56.19,53.81,53.56,52.56,53.12,52.94,53.16,52.53,53.25,53.19,53.03,51.72,49.72,47.78,46.78,45.97,47.53,48.31,48.59,50.66,50.34,50.38,49.88,49.12,48.94,47.06,47.62,47.62,50.19,54.0,57.41,57.56,61.09,59.06,57.81,56.53,55.5,53.94,52.41,52.53,52.44,53.44,52.97,53.34,53.12,51.94,50.5,51.03,49.5,48.94,48.12,46.03,45.62,44.78,44.72,43.72,44.0,44.06,43.12,43.41,43.31,43.84,44.69,45.84,47.91,49.47,51.03,52.0,52.88,52.97,52.03,50.81,49.5,48.88,48.34,49.38,50.75,51.72,52.84,53.56,55.22,55.06,56.25,56.66,55.53,54.75,55.25,54.38,53.94,54.56,54.81,54.0,54.16,54.31,53.94,55.28,55.28,54.78,55.28,55.19,54.38,55.81,56.66,56.91,57.28,57.44,57.69,56.81,57.94,58.41,58.56,57.91,58.09,57.69,55.81,56.06,56.09,54.12,54.03,53.31,51.81,52.53,51.44,51.34,52.28,51.72,53.28,54.53,55.25,57.09,57.16,55.88,54.78,52.91,54.03,53.0,53.06,53.44,52.34,51.41,52.16,52.72,53.78,56.25,57.88,58.31,58.5,58.22,58.38,57.38,58.25,57.69,58.25,58.38,58.25,57.06,58.56,57.16,56.84,57.22,57.34,56.41,56.06,54.91,54.06,53.0,51.94,51.16,53.06,53.69,55.47,55.69,55.56,53.88,52.06,50.31,49.53,48.31,49.16,49.53,49.66,49.59,47.81,48.38,48.66,49.47,51.59,53.5,55.25,55.75,56.66,54.97,54.44,53.88,53.16,52.75,52.09,51.66,51.19,49.88,49.81,50.59,51.03,51.62,51.28,53.06,53.06,53.0,53.09,54.25,53.84,52.88,51.88,51.12,49.59,49.5,51.75,53.66,51.0,54.44,53.16,50.81,52.19,52.78,54.19,55.0,54.53,52.97,49.5,49.31,49.19,49.84,51.16,53.41,52.56,51.72,50.5,49.03,47.41,46.69,45.38,44.34,42.62,41.62,40.69,38.75,38.06,38.12,38.06,38.94,39.31,40.06,40.28,40.72,41.41,42.41,41.69,42.0,41.69,40.66,40.91,40.78,39.91,39.69,39.81,40.12,41.97,45.19,49.25,53.12,55.59,56.53,56.81,53.09,51.5,48.38,46.69,45.94,46.56,48.03,47.84,48.81,49.12,49.84,49.62,50.62,51.5,51.41,52.44,52.28,51.56,51.16,50.91,50.25,49.97,48.16,48.78,-12.5,-10.53,-8.41,-4.62,-1.12,1.06,4.62,4.84,5.62,4.78,2.69,1.81:36.66,39.03,38.81,40.66,42.62,42.59,42.69,42.5,42.78,43.0,43.94,44.84,46.38,45.69,48.5,49.22,50.81,52.78,54.25,55.06,54.44,53.69,51.66,49.34,46.97,44.31,43.06,42.94,41.62,45.06,46.41,48.66,51.47,54.88,56.44,59.28,59.59,60.56,60.28,58.41,55.88,54.25,50.12,48.75,44.84,43.66,45.59,45.44,48.81,51.41,52.5,54.66,53.56,52.91,52.12,51.25,48.09,46.53,44.62,44.81,44.16,44.22,45.31,46.28,45.09,46.5,47.97,48.25,50.53,51.81,53.75,55.31,57.31,57.06,56.06,56.69,54.88,54.22,53.84,53.62,54.0,55.53,55.62,56.41,56.56,55.5,54.38,52.59,51.44,52.25,53.19,53.31,54.78,54.25,53.84,52.47,52.75,51.66,50.78,50.41,48.97,47.56,47.53,47.66,49.25,50.69,50.91,52.56,52.5,53.41,53.28,54.78,55.09,55.31,54.84,54.91,54.06,52.19,51.62,49.88,48.56,48.19,47.47,48.38,50.06,52.62,53.78,55.25,54.97,55.44,55.66,56.25,56.56,57.06,56.69,55.81,53.41,51.72,49.81,48.72,47.5,49.06,51.53,54.41,58.94,62.41,64.84,64.69,64.78,60.84,57.22,51.94,47.25,43.75,41.69,41.03,40.94,42.81,44.03,46.41,48.34,49.91,52.38,54.0,54.06,54.16,52.56,50.25,49.5,47.66,47.56,48.59,47.44,46.81,47.97,46.12,46.34,47.34,48.03,49.12,50.81,52.66,54.25,55.59,58.0,58.53,58.84,57.53,57.16,55.88,54.88,56.72,57.44,58.66,58.62,57.53,56.19,53.25,53.34,53.84,54.41,55.06,57.31,57.41,57.25,59.06,58.16,57.31,56.91,55.53,55.84,56.59,58.56,59.66,60.66,60.19,57.81,54.47,51.19,47.47,43.81,44.0,43.41,44.94,45.81,47.06,48.25,47.91,47.38,46.25,45.44,44.69,43.97,43.69,42.69,42.06,40.88,40.97,41.53,42.06,44.19,45.59,46.66,48.0,47.69,48.56,48.78,49.19,48.56,47.84,46.03,43.97,42.25,40.91,40.5,39.5,39.22,38.66,37.91,38.97,41.56,44.06,48.62,51.31,51.81,52.16,50.69,48.69,47.44,46.62,46.91,47.84,49.16,50.66,52.12,52.81,53.19,54.88,54.59,55.16,54.12,51.81,47.25,44.25,43.16,41.84,43.12,46.22,49.38,53.81,57.0,59.72,60.56,62.19,61.59,61.59,60.53,61.06,60.12,60.0,60.41,59.25,61.03,61.06,60.5,60.78,60.91,61.19,60.97,59.25,59.94,57.34,55.41,55.38,54.12,55.31,55.5,54.03,54.44,54.38,52.88,52.75,51.06,49.19,47.34,45.84,45.31,44.53,43.66,46.41,46.44,48.59,50.53,51.28,53.16,53.81,54.72,56.03,56.78,56.88,56.06,54.19,51.34,50.59,49.44,49.16,50.28,51.44,52.28,53.75,54.12,54.06,52.62,49.56,47.31,45.62,43.16,40.72,40.97,40.38,38.94,39.91,40.19,41.81,43.25,45.53,46.12,46.19,46.28,45.12,42.97,43.34,43.31,44.81,47.25,50.06,53.53,56.0,59.19,60.66,60.91,60.66,57.88,56.94,54.84,53.5,53.91,52.56,52.31,52.03,50.94,49.16,49.44,48.5,49.44,50.25,50.69,51.56,51.25,51.0,50.06,49.62,47.97,47.94,47.66,48.12,48.09,48.31,47.59,47.34,46.06,47.28,46.97,47.22,47.69,47.69,45.81,45.66,43.97,43.88,44.41,44.84,47.03,48.62,51.28,51.81,51.91,54.0,53.03,52.59,53.28,51.78,50.41,49.78,48.38,47.53,47.53,47.34,48.75,49.41,49.5,52.03,51.62,51.12,50.34,49.62,47.78,46.19,45.59,45.12,44.81,45.5,47.06,48.28,49.47,49.88,48.44,46.91,45.84,43.78,42.38,42.12,42.84,43.34,45.22,45.09,45.56,45.62,43.94,44.56,43.47,43.09,43.97,44.19,45.34,46.25,46.81,46.72,46.16,44.38,43.59,42.12,41.94,44.28,45.09,47.88,50.03,50.5,52.34,50.88,49.34,49.47,48.69,49.81,49.81,50.44,49.78,49.25,47.69,46.62,45.16,44.38,42.62,43.5,43.81,44.62,45.12,47.5,48.5,49.56,48.62,47.91,48.19,47.31,47.91,48.56,49.25,49.56,49.84,50.72,51.62,51.72,53.62,51.53,53.25,51.28,51.34,51.5,51.94,54.12,55.38,58.56,60.47,61.0,60.34,60.91,60.0,59.16,58.97,58.0,57.09,57.5,58.25,59.56,61.56,62.28,62.0,61.38,60.78,58.16,58.53,58.06,55.72,56.06,55.38,53.81,53.94,53.25,52.88,52.09,50.16,49.34,48.84,48.66,49.56,51.31,53.28,54.53,56.09,56.75,58.22,59.66,60.59,61.59,63.06,63.06,62.5,62.06,60.56,59.81,56.81,56.19,53.81,53.56,52.56,53.12,52.94,53.16,52.53,53.25,53.19,53.03,51.72,49.72,47.78,46.78,45.97,47.53,48.31,48.59,50.66,50.34,50.38,49.88,49.12,48.94,47.06,47.62,47.62,50.19,54.0,57.41,57.56,61.09,59.06,57.81,56.53,55.5,53.94,52.41,52.53,52.44,53.44,52.97,53.34,53.12,51.94,50.5,51.03,49.5,48.94,48.12,46.03,45.62,44.78,44.72,43.72,44.0,44.06,43.12,43.41,43.31,43.84,44.69,45.84,47.91,49.47,51.03,52.0,52.88,52.97,52.03,50.81,49.5,48.88,48.34,49.38,50.75,51.72,52.84,53.56,55.22,55.06,56.25,56.66,55.53,54.75,55.25,54.38,53.94,54.56,54.81,54.0,54.16,54.31,53.94,55.28,55.28,54.78,55.28,55.19,54.38,55.81,56.66,56.91,57.28,57.44,57.69,56.81,57.94,58.41,58.56,57.91,58.09,57.69,55.81,56.06,56.09,54.12,54.03,53.31,51.81,52.53,51.44,51.34,52.28,51.72,53.28,54.53,55.25,57.09,57.16,55.88,54.78,52.91,54.03,53.0,53.06,53.44,52.34,51.41,52.16,52.72,53.78,56.25,57.88,58.31,58.5,58.22,58.38,57.38,58.25,57.69,58.25,58.38,58.25,57.06,58.56,57.16,56.84,57.22,57.34,56.41,56.06,54.91,54.06,53.0,51.94,51.16,53.06,53.69,55.47,55.69,55.56,53.88,52.06,50.31,49.53,48.31,49.16,49.53,49.66,49.59,47.81,48.38,48.66,49.47,51.59,53.5,55.25,55.75,56.66,54.97,54.44,53.88,53.16,52.75,52.09,51.66,51.19,49.88,49.81,50.59,51.03,51.62,51.28,53.06,53.06,53.0,53.09,54.25,53.84,52.88,51.88,51.12,49.59,49.5,51.75,53.66,51.0,54.44,53.16,50.81,52.19,52.78,54.19,55.0,54.53,52.97,49.5,49.31,49.19,49.84,51.16,53.41,52.56,51.72,50.5,49.03,47.41,46.69,45.38,44.34,42.62,41.62,40.69,38.75,38.06,38.12,38.06,38.94,39.31,40.06,40.28,40.72,41.41,42.41,41.69,42.0,41.69,40.66,40.91,40.78,39.91,39.69,39.81,40.12,41.97,45.19,49.25,53.12,55.59,56.53,56.81,53.09,51.5,48.38,46.69,45.94,46.56,48.03,47.84,48.81,49.12,49.84,49.62,50.62,51.5,51.41,52.44,52.28,51.56,51.16,50.91,50.25,49.97,48.16,48.78,-12.5,-10.53,-8.41,-4.62,-1.12,1.06,4.62,4.84,5.62,4.78,2.69,1.81,-0.22,0.81,1.16,1.41,3.81,4.5:42.69,42.5,42.78,43.0,43.94,44.84,46.38,45.69,48.5,49.22,50.81,52.78,54.25,55.06,54.44,53.69,51.66,49.34,46.97,44.31,43.06,42.94,41.62,45.06,46.41,48.66,51.47,54.88,56.44,59.28,59.59,60.56,60.28,58.41,55.88,54.25,50.12,48.75,44.84,43.66,45.59,45.44,48.81,51.41,52.5,54.66,53.56,52.91,52.12,51.25,48.09,46.53,44.62,44.81,44.16,44.22,45.31,46.28,45.09,46.5,47.97,48.25,50.53,51.81,53.75,55.31,57.31,57.06,56.06,56.69,54.88,54.22,53.84,53.62,54.0,55.53,55.62,56.41,56.56,55.5,54.38,52.59,51.44,52.25,53.19,53.31,54.78,54.25,53.84,52.47,52.75,51.66,50.78,50.41,48.97,47.56,47.53,47.66,49.25,50.69,50.91,52.56,52.5,53.41,53.28,54.78,55.09,55.31,54.84,54.91,54.06,52.19,51.62,49.88,48.56,48.19,47.47,48.38,50.06,52.62,53.78,55.25,54.97,55.44,55.66,56.25,56.56,57.06,56.69,55.81,53.41,51.72,49.81,48.72,47.5,49.06,51.53,54.41,58.94,62.41,64.84,64.69,64.78,60.84,57.22,51.94,47.25,43.75,41.69,41.03,40.94,42.81,44.03,46.41,48.34,49.91,52.38,54.0,54.06,54.16,52.56,50.25,49.5,47.66,47.56,48.59,47.44,46.81,47.97,46.12,46.34,47.34,48.03,49.12,50.81,52.66,54.25,55.59,58.0,58.53,58.84,57.53,57.16,55.88,54.88,56.72,57.44,58.66,58.62,57.53,56.19,53.25,53.34,53.84,54.41,55.06,57.31,57.41,57.25,59.06,58.16,57.31,56.91,55.53,55.84,56.59,58.56,59.66,60.66,60.19,57.81,54.47,51.19,47.47,43.81,44.0,43.41,44.94,45.81,47.06,48.25,47.91,47.38,46.25,45.44,44.69,43.97,43.69,42.69,42.06,40.88,40.97,41.53,42.06,44.19,45.59,46.66,48.0,47.69,48.56,48.78,49.19,48.56,47.84,46.03,43.97,42.25,40.91,40.5,39.5,39.22,38.66,37.91,38.97,41.56,44.06,48.62,51.31,51.81,52.16,50.69,48.69,47.44,46.62,46.91,47.84,49.16,50.66,52.12,52.81,53.19,54.88,54.59,55.16,54.12,51.81,47.25,44.25,43.16,41.84,43.12,46.22,49.38,53.81,57.0,59.72,60.56,62.19,61.59,61.59,60.53,61.06,60.12,60.0,60.41,59.25,61.03,61.06,60.5,60.78,60.91,61.19,60.97,59.25,59.94,57.34,55.41,55.38,54.12,55.31,55.5,54.03,54.44,54.38,52.88,52.75,51.06,49.19,47.34,45.84,45.31,44.53,43.66,46.41,46.44,48.59,50.53,51.28,53.16,53.81,54.72,56.03,56.78,56.88,56.06,54.19,51.34,50.59,49.44,49.16,50.28,51.44,52.28,53.75,54.12,54.06,52.62,49.56,47.31,45.62,43.16,40.72,40.97,40.38,38.94,39.91,40.19,41.81,43.25,45.53,46.12,46.19,46.28,45.12,42.97,43.34,43.31,44.81,47.25,50.06,53.53,56.0,59.19,60.66,60.91,60.66,57.88,56.94,54.84,53.5,53.91,52.56,52.31,52.03,50.94,49.16,49.44,48.5,49.44,50.25,50.69,51.56,51.25,51.0,50.06,49.62,47.97,47.94,47.66,48.12,48.09,48.31,47.59,47.34,46.06,47.28,46.97,47.22,47.69,47.69,45.81,45.66,43.97,43.88,44.41,44.84,47.03,48.62,51.28,51.81,51.91,54.0,53.03,52.59,53.28,51.78,50.41,49.78,48.38,47.53,47.53,47.34,48.75,49.41,49.5,52.03,51.62,51.12,50.34,49.62,47.78,46.19,45.59,45.12,44.81,45.5,47.06,48.28,49.47,49.88,48.44,46.91,45.84,43.78,42.38,42.12,42.84,43.34,45.22,45.09,45.56,45.62,43.94,44.56,43.47,43.09,43.97,44.19,45.34,46.25,46.81,46.72,46.16,44.38,43.59,42.12,41.94,44.28,45.09,47.88,50.03,50.5,52.34,50.88,49.34,49.47,48.69,49.81,49.81,50.44,49.78,49.25,47.69,46.62,45.16,44.38,42.62,43.5,43.81,44.62,45.12,47.5,48.5,49.56,48.62,47.91,48.19,47.31,47.91,48.56,49.25,49.56,49.84,50.72,51.62,51.72,53.62,51.53,53.25,51.28,51.34,51.5,51.94,54.12,55.38,58.56,60.47,61.0,60.34,60.91,60.0,59.16,58.97,58.0,57.09,57.5,58.25,59.56,61.56,62.28,62.0,61.38,60.78,58.16,58.53,58.06,55.72,56.06,55.38,53.81,53.94,53.25,52.88,52.09,50.16,49.34,48.84,48.66,49.56,51.31,53.28,54.53,56.09,56.75,58.22,59.66,60.59,61.59,63.06,63.06,62.5,62.06,60.56,59.81,56.81,56.19,53.81,53.56,52.56,53.12,52.94,53.16,52.53,53.25,53.19,53.03,51.72,49.72,47.78,46.78,45.97,47.53,48.31,48.59,50.66,50.34,50.38,49.88,49.12,48.94,47.06,47.62,47.62,50.19,54.0,57.41,57.56,61.09,59.06,57.81,56.53,55.5,53.94,52.41,52.53,52.44,53.44,52.97,53.34,53.12,51.94,50.5,51.03,49.5,48.94,48.12,46.03,45.62,44.78,44.72,43.72,44.0,44.06,43.12,43.41,43.31,43.84,44.69,45.84,47.91,49.47,51.03,52.0,52.88,52.97,52.03,50.81,49.5,48.88,48.34,49.38,50.75,51.72,52.84,53.56,55.22,55.06,56.25,56.66,55.53,54.75,55.25,54.38,53.94,54.56,54.81,54.0,54.16,54.31,53.94,55.28,55.28,54.78,55.28,55.19,54.38,55.81,56.66,56.91,57.28,57.44,57.69,56.81,57.94,58.41,58.56,57.91,58.09,57.69,55.81,56.06,56.09,54.12,54.03,53.31,51.81,52.53,51.44,51.34,52.28,51.72,53.28,54.53,55.25,57.09,57.16,55.88,54.78,52.91,54.03,53.0,53.06,53.44,52.34,51.41,52.16,52.72,53.78,56.25,57.88,58.31,58.5,58.22,58.38,57.38,58.25,57.69,58.25,58.38,58.25,57.06,58.56,57.16,56.84,57.22,57.34,56.41,56.06,54.91,54.06,53.0,51.94,51.16,53.06,53.69,55.47,55.69,55.56,53.88,52.06,50.31,49.53,48.31,49.16,49.53,49.66,49.59,47.81,48.38,48.66,49.47,51.59,53.5,55.25,55.75,56.66,54.97,54.44,53.88,53.16,52.75,52.09,51.66,51.19,49.88,49.81,50.59,51.03,51.62,51.28,53.06,53.06,53.0,53.09,54.25,53.84,52.88,51.88,51.12,49.59,49.5,51.75,53.66,51.0,54.44,53.16,50.81,52.19,52.78,54.19,55.0,54.53,52.97,49.5,49.31,49.19,49.84,51.16,53.41,52.56,51.72,50.5,49.03,47.41,46.69,45.38,44.34,42.62,41.62,40.69,38.75,38.06,38.12,38.06,38.94,39.31,40.06,40.28,40.72,41.41,42.41,41.69,42.0,41.69,40.66,40.91,40.78,39.91,39.69,39.81,40.12,41.97,45.19,49.25,53.12,55.59,56.53,56.81,53.09,51.5,48.38,46.69,45.94,46.56,48.03,47.84,48.81,49.12,49.84,49.62,50.62,51.5,51.41,52.44,52.28,51.56,51.16,50.91,50.25,49.97,48.16,48.78,-12.5,-10.53,-8.41,-4.62,-1.12,1.06,4.62,4.84,5.62,4.78,2.69,1.81,-0.22,0.81,1.16,1.41,3.81,4.5,5.34,7.31,8.53,9.97,13.03,14.25:46.38,45.69,48.5,49.22,50.81,52.78,54.25,55.06,54.44,53.69,51.66,49.34,46.97,44.31,43.06,42.94,41.62,45.06,46.41,48.66,51.47,54.88,56.44,59.28,59.59,60.56,60.28,58.41,55.88,54.25,50.12,48.75,44.84,43.66,45.59,45.44,48.81,51.41,52.5,54.66,53.56,52.91,52.12,51.25,48.09,46.53,44.62,44.81,44.16,44.22,45.31,46.28,45.09,46.5,47.97,48.25,50.53,51.81,53.75,55.31,57.31,57.06,56.06,56.69,54.88,54.22,53.84,53.62,54.0,55.53,55.62,56.41,56.56,55.5,54.38,52.59,51.44,52.25,53.19,53.31,54.78,54.25,53.84,52.47,52.75,51.66,50.78,50.41,48.97,47.56,47.53,47.66,49.25,50.69,50.91,52.56,52.5,53.41,53.28,54.78,55.09,55.31,54.84,54.91,54.06,52.19,51.62,49.88,48.56,48.19,47.47,48.38,50.06,52.62,53.78,55.25,54.97,55.44,55.66,56.25,56.56,57.06,56.69,55.81,53.41,51.72,49.81,48.72,47.5,49.06,51.53,54.41,58.94,62.41,64.84,64.69,64.78,60.84,57.22,51.94,47.25,43.75,41.69,41.03,40.94,42.81,44.03,46.41,48.34,49.91,52.38,54.0,54.06,54.16,52.56,50.25,49.5,47.66,47.56,48.59,47.44,46.81,47.97,46.12,46.34,47.34,48.03,49.12,50.81,52.66,54.25,55.59,58.0,58.53,58.84,57.53,57.16,55.88,54.88,56.72,57.44,58.66,58.62,57.53,56.19,53.25,53.34,53.84,54.41,55.06,57.31,57.41,57.25,59.06,58.16,57.31,56.91,55.53,55.84,56.59,58.56,59.66,60.66,60.19,57.81,54.47,51.19,47.47,43.81,44.0,43.41,44.94,45.81,47.06,48.25,47.91,47.38,46.25,45.44,44.69,43.97,43.69,42.69,42.06,40.88,40.97,41.53,42.06,44.19,45.59,46.66,48.0,47.69,48.56,48.78,49.19,48.56,47.84,46.03,43.97,42.25,40.91,40.5,39.5,39.22,38.66,37.91,38.97,41.56,44.06,48.62,51.31,51.81,52.16,50.69,48.69,47.44,46.62,46.91,47.84,49.16,50.66,52.12,52.81,53.19,54.88,54.59,55.16,54.12,51.81,47.25,44.25,43.16,41.84,43.12,46.22,49.38,53.81,57.0,59.72,60.56,62.19,61.59,61.59,60.53,61.06,60.12,60.0,60.41,59.25,61.03,61.06,60.5,60.78,60.91,61.19,60.97,59.25,59.94,57.34,55.41,55.38,54.12,55.31,55.5,54.03,54.44,54.38,52.88,52.75,51.06,49.19,47.34,45.84,45.31,44.53,43.66,46.41,46.44,48.59,50.53,51.28,53.16,53.81,54.72,56.03,56.78,56.88,56.06,54.19,51.34,50.59,49.44,49.16,50.28,51.44,52.28,53.75,54.12,54.06,52.62,49.56,47.31,45.62,43.16,40.72,40.97,40.38,38.94,39.91,40.19,41.81,43.25,45.53,46.12,46.19,46.28,45.12,42.97,43.34,43.31,44.81,47.25,50.06,53.53,56.0,59.19,60.66,60.91,60.66,57.88,56.94,54.84,53.5,53.91,52.56,52.31,52.03,50.94,49.16,49.44,48.5,49.44,50.25,50.69,51.56,51.25,51.0,50.06,49.62,47.97,47.94,47.66,48.12,48.09,48.31,47.59,47.34,46.06,47.28,46.97,47.22,47.69,47.69,45.81,45.66,43.97,43.88,44.41,44.84,47.03,48.62,51.28,51.81,51.91,54.0,53.03,52.59,53.28,51.78,50.41,49.78,48.38,47.53,47.53,47.34,48.75,49.41,49.5,52.03,51.62,51.12,50.34,49.62,47.78,46.19,45.59,45.12,44.81,45.5,47.06,48.28,49.47,49.88,48.44,46.91,45.84,43.78,42.38,42.12,42.84,43.34,45.22,45.09,45.56,45.62,43.94,44.56,43.47,43.09,43.97,44.19,45.34,46.25,46.81,46.72,46.16,44.38,43.59,42.12,41.94,44.28,45.09,47.88,50.03,50.5,52.34,50.88,49.34,49.47,48.69,49.81,49.81,50.44,49.78,49.25,47.69,46.62,45.16,44.38,42.62,43.5,43.81,44.62,45.12,47.5,48.5,49.56,48.62,47.91,48.19,47.31,47.91,48.56,49.25,49.56,49.84,50.72,51.62,51.72,53.62,51.53,53.25,51.28,51.34,51.5,51.94,54.12,55.38,58.56,60.47,61.0,60.34,60.91,60.0,59.16,58.97,58.0,57.09,57.5,58.25,59.56,61.56,62.28,62.0,61.38,60.78,58.16,58.53,58.06,55.72,56.06,55.38,53.81,53.94,53.25,52.88,52.09,50.16,49.34,48.84,48.66,49.56,51.31,53.28,54.53,56.09,56.75,58.22,59.66,60.59,61.59,63.06,63.06,62.5,62.06,60.56,59.81,56.81,56.19,53.81,53.56,52.56,53.12,52.94,53.16,52.53,53.25,53.19,53.03,51.72,49.72,47.78,46.78,45.97,47.53,48.31,48.59,50.66,50.34,50.38,49.88,49.12,48.94,47.06,47.62,47.62,50.19,54.0,57.41,57.56,61.09,59.06,57.81,56.53,55.5,53.94,52.41,52.53,52.44,53.44,52.97,53.34,53.12,51.94,50.5,51.03,49.5,48.94,48.12,46.03,45.62,44.78,44.72,43.72,44.0,44.06,43.12,43.41,43.31,43.84,44.69,45.84,47.91,49.47,51.03,52.0,52.88,52.97,52.03,50.81,49.5,48.88,48.34,49.38,50.75,51.72,52.84,53.56,55.22,55.06,56.25,56.66,55.53,54.75,55.25,54.38,53.94,54.56,54.81,54.0,54.16,54.31,53.94,55.28,55.28,54.78,55.28,55.19,54.38,55.81,56.66,56.91,57.28,57.44,57.69,56.81,57.94,58.41,58.56,57.91,58.09,57.69,55.81,56.06,56.09,54.12,54.03,53.31,51.81,52.53,51.44,51.34,52.28,51.72,53.28,54.53,55.25,57.09,57.16,55.88,54.78,52.91,54.03,53.0,53.06,53.44,52.34,51.41,52.16,52.72,53.78,56.25,57.88,58.31,58.5,58.22,58.38,57.38,58.25,57.69,58.25,58.38,58.25,57.06,58.56,57.16,56.84,57.22,57.34,56.41,56.06,54.91,54.06,53.0,51.94,51.16,53.06,53.69,55.47,55.69,55.56,53.88,52.06,50.31,49.53,48.31,49.16,49.53,49.66,49.59,47.81,48.38,48.66,49.47,51.59,53.5,55.25,55.75,56.66,54.97,54.44,53.88,53.16,52.75,52.09,51.66,51.19,49.88,49.81,50.59,51.03,51.62,51.28,53.06,53.06,53.0,53.09,54.25,53.84,52.88,51.88,51.12,49.59,49.5,51.75,53.66,51.0,54.44,53.16,50.81,52.19,52.78,54.19,55.0,54.53,52.97,49.5,49.31,49.19,49.84,51.16,53.41,52.56,51.72,50.5,49.03,47.41,46.69,45.38,44.34,42.62,41.62,40.69,38.75,38.06,38.12,38.06,38.94,39.31,40.06,40.28,40.72,41.41,42.41,41.69,42.0,41.69,40.66,40.91,40.78,39.91,39.69,39.81,40.12,41.97,45.19,49.25,53.12,55.59,56.53,56.81,53.09,51.5,48.38,46.69,45.94,46.56,48.03,47.84,48.81,49.12,49.84,49.62,50.62,51.5,51.41,52.44,52.28,51.56,51.16,50.91,50.25,49.97,48.16,48.78,-12.5,-10.53,-8.41,-4.62,-1.12,1.06,4.62,4.84,5.62,4.78,2.69,1.81,-0.22,0.81,1.16,1.41,3.81,4.5,5.34,7.31,8.53,9.97,13.03,14.25,15.25,16.41,17.31,17.81,19.56,20.38:negativity
25.0,26.94,28.03,28.69,28.56,27.16,27.34,26.91,24.69,25.19,27.56,30.06,33.78,38.19,40.94,41.59,40.69,37.44,35.0,31.94,29.72,28.41,27.22,26.53,27.84,29.28,31.06,33.28,34.56,36.0,36.81,38.06,38.88,38.34,39.66,40.41,40.69,41.03,41.5,41.56,41.25,41.69,40.62,39.62,37.16,34.81,31.75,30.06,28.19,28.22,29.34,28.44,29.62,29.94,30.38,30.0,29.97,30.0,29.28,28.59,28.31,27.69,27.56,25.94,25.84,24.56,23.06,20.56,17.91,15.56,13.31,11.03,10.19,9.0,7.56,8.19,8.62,10.0,11.75,15.12,17.72,21.59,26.09,31.34,36.12,38.06,41.44,41.19,40.22,39.25,37.78,37.62,35.53,33.91,32.12,29.16,27.0,24.41,22.94,21.81,20.06,19.56,19.16,18.06,19.06,18.72,20.56,23.38,23.88,25.53,26.09,25.56,25.88,24.94,24.56,23.75,23.12,24.44,25.06,26.34,27.16,27.66,27.44,26.91,25.94,25.91,26.56,26.84,27.97,30.31,31.47,32.94,34.59,35.5,36.25,37.56,38.44,38.28,38.28,36.81,35.62,33.53,32.06,31.12,30.53,29.38,28.66,28.03,28.56,28.41,29.28,30.38,30.75,30.62,30.47,31.06,31.34,32.62,32.53,31.94,31.66,30.84,30.5,31.31,32.75,32.25,33.44,33.91,34.91,34.66,34.38,35.75,35.75,36.69,37.97,38.44,38.88,39.03,37.84,37.97,38.12,37.91,37.78,39.53,39.19,38.75,36.53,35.38,31.78,29.19,28.34,28.06,27.19,28.66,29.38,29.81,30.31,30.62,31.91,32.38,32.28,32.41,32.16,31.72,31.53,30.75,30.97,30.22,29.12,28.03,25.34,21.78,18.75,16.31,13.5,11.97,12.91,13.19,15.53,17.06,19.94,21.78,24.5,25.12,25.88,26.31,25.28,23.97,22.94,24.19,25.19,26.53,30.12,31.78,33.5,34.28,33.03,31.44,30.38,28.25,27.47,27.38,28.56,28.41,28.31,29.72,28.09,28.62,27.34,29.03,30.56,32.72,34.0,33.75,34.25,32.28,30.31,29.53,27.69,26.53,24.78,23.44,22.44,22.03,21.41,21.56,22.16,22.0,22.66,22.59,22.19,22.22,20.62,21.06,20.5,19.88,20.53,20.66,20.22,20.84,21.09,22.72,23.94,26.34,28.56,30.38,31.72,31.09,31.0,30.09,29.62,30.06,31.0,32.75,35.12,36.53,38.72,39.59,38.5,37.62,35.91,35.06,34.91,35.66,36.28,37.25,37.88,39.0,36.72,38.16,38.06,37.12,37.06,36.34,36.59,34.62,34.41,33.94,33.62,33.38,32.56,33.38,34.25,34.44,35.94,36.72,37.41,36.56,34.97,33.94,32.06,30.56,28.0,26.16,25.56,23.34,22.91,23.91,24.69,25.91,27.72,28.91,30.28,29.34,28.75,26.81,25.38,24.75,23.88,24.22,26.19,27.94,29.0,32.28,32.69,33.56,33.62,33.78,32.31,32.56,31.78,31.56,31.25,32.28,32.56,32.88,33.12,33.0,33.44,32.5,33.78,31.94,32.16,32.56,31.19,31.78,32.5,32.44,33.75,33.78,33.78,33.31,31.84,31.5,31.16,30.16,30.69,30.56,31.28,30.28,29.78,29.56,27.62,26.94,24.88,24.62,24.44,25.38,26.62,27.97,28.5,29.69,30.03,30.22,29.94,30.0,29.19,28.88,29.06,28.81,29.31,28.28,28.5,27.34,26.97,26.72,26.09,26.09,26.72,25.41,25.22,23.81,21.88,20.06,19.78,18.88,19.12,19.78,21.5,23.16,25.16,29.25,30.94,32.75,34.75,35.12,33.91,33.19,30.78,28.28,26.53,23.5,23.41,23.03,24.03,25.19,25.56,26.81,27.47,28.16,28.5,29.25,29.5,29.47,29.25,30.38,29.53,29.5,30.25,31.38,33.75,35.06,36.78,39.41,39.91,39.66,39.72,39.56,37.25,37.16,37.28,37.22,38.5,38.38,38.72,38.28,36.5,34.59,32.25,31.34,31.16,30.84,31.56,32.16,31.28,29.84,27.72,26.56,25.62,24.34,24.22,24.81,25.38,25.53,25.94,26.19,28.09,26.19,26.81,25.91,24.62,23.91,22.78,22.78,21.81,21.0,20.28,20.16,20.19,21.78,23.62,25.53,27.56,28.06,29.69,29.91,31.22,30.56,31.12,30.03,27.56,28.31,26.59,27.31,28.72,30.94,32.62,35.47,36.25,37.56,38.03,38.03,37.94,37.62,37.06,35.59,34.09,33.22,32.5,31.59,31.19,30.94,30.5,29.31,29.5,28.66,28.5,27.84,27.44,26.03,25.81,24.78,23.81,23.12,21.25,20.47,20.03,19.66,19.78,20.41,19.75,19.19,20.62,19.41,21.81,23.25,25.12,26.53,27.75,29.28,28.69,28.97,29.91,30.06,29.03,29.06,28.78,27.97,28.03,27.53,28.19,27.59,29.28,29.19,30.0,30.69,30.5,30.0,30.31,31.28,31.38,31.59,31.81,30.66,28.66,25.81,25.06,21.53,20.66,19.22,20.28,20.94,22.5,25.97,26.56,28.88,30.5,30.94,32.19,32.09,31.31,30.22,29.84,28.16,28.16,29.19,28.84,29.0,29.28,28.31,28.25,28.44,28.81,29.53,30.16,29.38,29.5,28.75,26.88,27.44,26.84,27.25,27.75,29.19,30.88,31.34,32.5,32.81,32.03,32.75,32.16,31.81,29.88,28.34,25.69,23.91,22.5,22.03,24.12,26.03,29.28,31.53,34.41,35.75,37.09,37.59,38.22,38.91,39.78,39.78,39.41,37.06,36.19,32.72,31.41,30.06,29.66,28.88,29.16,28.44,28.47,26.75,26.31,26.16,24.69,25.31,24.94,24.5,23.97,24.19,25.41,26.34,29.31,30.94,31.75,34.16,35.16,35.56,37.28,38.22,39.31,39.31,39.06,38.03,35.41,32.31,30.28,28.31,27.91,28.03,28.22,28.53,28.06,26.53,25.53,24.62,24.03,22.31,23.75,21.91,22.16,21.91,20.81,20.5,21.25,20.19,21.72,21.44,21.16,20.75,21.09,20.72,22.16,21.94,23.34,23.34,21.88,23.16,21.62,20.31,19.94,18.66,17.72,16.97,17.66,16.22,18.19,19.28,21.25,22.97,26.56,27.25,28.44,29.09,29.66,30.47,30.06,31.81,29.94,29.56,27.62,26.69,24.16,22.94,21.56,20.25,18.91,19.53,18.84,18.72,19.66,20.75,21.66,22.94,24.62,25.84,25.41,25.75,24.41,23.66,22.28,20.56,19.72,18.38,16.94,16.5,15.44,13.94,13.5,11.81,9.91,8.78,7.25,6.19,5.94,6.59,7.94,11.38,13.97,16.5,17.81,19.09,18.94,18.0,15.28,13.62,11.41,10.81,9.53,10.03,10.81,11.5,11.88,12.09,11.72,11.94,11.56,10.59,11.31,10.78,11.84,12.84,14.69,16.03,16.31,16.81,15.69,14.69,12.44,12.19,11.03,11.41,12.09,12.38,13.91,15.28,13.88,13.94,13.03,11.81,11.75,11.16,10.81,11.5,11.66,12.5,12.34,15.22,15.75,15.84,15.41,14.12,10.84,8.53,6.31,4.53,3.97,4.31,5.12,7.94,9.69,10.94,12.06,13.19,12.53,12.22,11.62,12.94,12.12,13.0,14.5,15.66,17.66,19.78,20.44,22.97,22.62,23.12,22.72,22.69,21.56,21.0,19.16,17.88,15.81,14.75,12.19,10.97,9.34,9.75,8.94,8.81,10.09,10.97,10.81,11.69,13.56,15.69,18.22,21.38,22.22,23.56,22.56,19.72,18.34,16.16:27.34,26.91,24.69,25.19,27.56,30.06,33.78,38.19,40.94,41.59,40.69,37.44,35.0,31.94,29.72,28.41,27.22,26.53,27.84,29.28,31.06,33.28,34.56,36.0,36.81,38.06,38.88,38.34,39.66,40.41,40.69,41.03,41.5,41.56,41.25,41.69,40.62,39.62,37.16,34.81,31.75,30.06,28.19,28.22,29.34,28.44,29.62,29.94,30.38,30.0,29.97,30.0,29.28,28.59,28.31,27.69,27.56,25.94,25.84,24.56,23.06,20.56,17.91,15.56,13.31,11.03,10.19,9.0,7.56,8.19,8.62,10.0,11.75,15.12,17.72,21.59,26.09,31.34,36.12,38.06,41.44,41.19,40.22,39.25,37.78,37.62,35.53,33.91,32.12,29.16,27.0,24.41,22.94,21.81,20.06,19.56,19.16,18.06,19.06,18.72,20.56,23.38,23.88,25.53,26.09,25.56,25.88,24.94,24.56,23.75,23.12,24.44,25.06,26.34,27.16,27.66,27.44,26.91,25.94,25.91,26.56,26.84,27.97,30.31,31.47,32.94,34.59,35.5,36.25,37.56,38.44,38.28,38.28,36.81,35.62,33.53,32.06,31.12,30.53,29.38,28.66,28.03,28.56,28.41,29.28,30.38,30.75,30.62,30.47,31.06,31.34,32.62,32.53,31.94,31.66,30.84,30.5,31.31,32.75,32.25,33.44,33.91,34.91,34.66,34.38,35.75,35.75,36.69,37.97,38.44,38.88,39.03,37.84,37.97,38.12,37.91,37.78,39.53,39.19,38.75,36.53,35.38,31.78,29.19,28.34,28.06,27.19,28.66,29.38,29.81,30.31,30.62,31.91,32.38,32.28,32.41,32.16,31.72,31.53,30.75,30.97,30.22,29.12,28.03,25.34,21.78,18.75,16.31,13.5,11.97,12.91,13.19,15.53,17.06,19.94,21.78,24.5,25.12,25.88,26.31,25.28,23.97,22.94,24.19,25.19,26.53,30.12,31.78,33.5,34.28,33.03,31.44,30.38,28.25,27.47,27.38,28.56,28.41,28.31,29.72,28.09,28.62,27.34,29.03,30.56,32.72,34.0,33.75,34.25,32.28,30.31,29.53,27.69,26.53,24.78,23.44,22.44,22.03,21.41,21.56,22.16,22.0,22.66,22.59,22.19,22.22,20.62,21.06,20.5,19.88,20.53,20.66,20.22,20.84,21.09,22.72,23.94,26.34,28.56,30.38,31.72,31.09,31.0,30.09,29.62,30.06,31.0,32.75,35.12,36.53,38.72,39.59,38.5,37.62,35.91,35.06,34.91,35.66,36.28,37.25,37.88,39.0,36.72,38.16,38.06,37.12,37.06,36.34,36.59,34.62,34.41,33.94,33.62,33.38,32.56,33.38,34.25,34.44,35.94,36.72,37.41,36.56,34.97,33.94,32.06,30.56,28.0,26.16,25.56,23.34,22.91,23.91,24.69,25.91,27.72,28.91,30.28,29.34,28.75,26.81,25.38,24.75,23.88,24.22,26.19,27.94,29.0,32.28,32.69,33.56,33.62,33.78,32.31,32.56,31.78,31.56,31.25,32.28,32.56,32.88,33.12,33.0,33.44,32.5,33.78,31.94,32.16,32.56,31.19,31.78,32.5,32.44,33.75,33.78,33.78,33.31,31.84,31.5,31.16,30.16,30.69,30.56,31.28,30.28,29.78,29.56,27.62,26.94,24.88,24.62,24.44,25.38,26.62,27.97,28.5,29.69,30.03,30.22,29.94,30.0,29.19,28.88,29.06,28.81,29.31,28.28,28.5,27.34,26.97,26.72,26.09,26.09,26.72,25.41,25.22,23.81,21.88,20.06,19.78,18.88,19.12,19.78,21.5,23.16,25.16,29.25,30.94,32.75,34.75,35.12,33.91,33.19,30.78,28.28,26.53,23.5,23.41,23.03,24.03,25.19,25.56,26.81,27.47,28.16,28.5,29.25,29.5,29.47,29.25,30.38,29.53,29.5,30.25,31.38,33.75,35.06,36.78,39.41,39.91,39.66,39.72,39.56,37.25,37.16,37.28,37.22,38.5,38.38,38.72,38.28,36.5,34.59,32.25,31.34,31.16,30.84,31.56,32.16,31.28,29.84,27.72,26.56,25.62,24.34,24.22,24.81,25.38,25.53,25.94,26.19,28.09,26.19,26.81,25.91,24.62,23.91,22.78,22.78,21.81,21.0,20.28,20.16,20.19,21.78,23.62,25.53,27.56,28.06,29.69,29.91,31.22,30.56,31.12,30.03,27.56,28.31,26.59,27.31,28.72,30.94,32.62,35.47,36.25,37.56,38.03,38.03,37.94,37.62,37.06,35.59,34.09,33.22,32.5,31.59,31.19,30.94,30.5,29.31,29.5,28.66,28.5,27.84,27.44,26.03,25.81,24.78,23.81,23.12,21.25,20.47,20.03,19.66,19.78,20.41,19.75,19.19,20.62,19.41,21.81,23.25,25.12,26.53,27.75,29.28,28.69,28.97,29.91,30.06,29.03,29.06,28.78,27.97,28.03,27.53,28.19,27.59,29.28,29.19,30.0,30.69,30.5,30.0,30.31,31.28,31.38,31.59,31.81,30.66,28.66,25.81,25.06,21.53,20.66,19.22,20.28,20.94,22.5,25.97,26.56,28.88,30.5,30.94,32.19,32.09,31.31,30.22,29.84,28.16,28.16,29.19,28.84,29.0,29.28,28.31,28.25,28.44,28.81,29.53,30.16,29.38,29.5,28.75,26.88,27.44,26.84,27.25,27.75,29.19,30.88,31.34,32.5,32.81,32.03,32.75,32.16,31.81,29.88,28.34,25.69,23.91,22.5,22.03,24.12,26.03,29.28,31.53,34.41,35.75,37.09,37.59,38.22,38.91,39.78,39.78,39.41,37.06,36.19,32.72,31.41,30.06,29.66,28.88,29.16,28.44,28.47,26.75,26.31,26.16,24.69,25.31,24.94,24.5,23.97,24.19,25.41,26.34,29.31,30.94,31.75,34.16,35.16,35.56,37.28,38.22,39.31,39.31,39.06,38.03,35.41,32.31,30.28,28.31,27.91,28.03,28.22,28.53,28.06,26.53,25.53,24.62,24.03,22.31,23.75,21.91,22.16,21.91,20.81,20.5,21.25,20.19,21.72,21.44,21.16,20.75,21.09,20.72,22.16,21.94,23.34,23.34,21.88,23.16,21.62,20.31,19.94,18.66,17.72,16.97,17.66,16.22,18.19,19.28,21.25,22.97,26.56,27.25,28.44,29.09,29.66,30.47,30.06,31.81,29.94,29.56,27.62,26.69,24.16,22.94,21.56,20.25,18.91,19.53,18.84,18.72,19.66,20.75,21.66,22.94,24.62,25.84,25.41,25.75,24.41,23.66,22.28,20.56,19.72,18.38,16.94,16.5,15.44,13.94,13.5,11.81,9.91,8.78,7.25,6.19,5.94,6.59,7.94,11.38,13.97,16.5,17.81,19.09,18.94,18.0,15.28,13.62,11.41,10.81,9.53,10.03,10.81,11.5,11.88,12.09,11.72,11.94,11.56,10.59,11.31,10.78,11.84,12.84,14.69,16.03,16.31,16.81,15.69,14.69,12.44,12.19,11.03,11.41,12.09,12.38,13.91,15.28,13.88,13.94,13.03,11.81,11.75,11.16,10.81,11.5,11.66,12.5,12.34,15.22,15.75,15.84,15.41,14.12,10.84,8.53,6.31,4.53,3.97,4.31,5.12,7.94,9.69,10.94,12.06,13.19,12.53,12.22,11.62,12.94,12.12,13.0,14.5,15.66,17.66,19.78,20.44,22.97,22.62,23.12,22.72,22.69,21.56,21.0,19.16,17.88,15.81,14.75,12.19,10.97,9.34,9.75,8.94,8.81,10.09,10.97,10.81,11.69,13.56,15.69,18.22,21.38,22.22,23.56,22.56,19.72,18.34,16.16,-5.81,-4.03,-2.78,-1.5,-1.22,-2.0:33.78,38.19,40.94,41.59,40.69,37.44,35.0,31.94,29.72,28.41,27.22,26.53,27.84,29.28,31.06,33.28,34.56,36.0,36.81,38.06,38.88,38.34,39.66,40.41,40.69,41.03,41.5,41.56,41.25,41.69,40.62,39.62,37.16,34.81,31.75,30.06,28.19,28.22,29.34,28.44,29.62,29.94,30.38,30.0,29.97,30.0,29.28,28.59,28.31,27.69,27.56,25.94,25.84,24.56,23.06,20.56,17.91,15.56,13.31,11.03,10.19,9.0,7.56,8.19,8.62,10.0,11.75,15.12,17.72,21.59,26.09,31.34,36.12,38.06,41.44,41.19,40.22,39.25,37.78,37.62,35.53,33.91,32.12,29.16,27.0,24.41,22.94,21.81,20.06,19.56,19.16,18.06,19.06,18.72,20.56,23.38,23.88,25.53,26.09,25.56,25.88,24.94,24.56,23.75,23.12,24.44,25.06,26.34,27.16,27.66,27.44,26.91,25.94,25.91,26.56,26.84,27.97,30.31,31.47,32.94,34.59,35.5,36.25,37.56,38.44,38.28,38.28,36.81,35.62,33.53,32.06,31.12,30.53,29.38,28.66,28.03,28.56,28.41,29.28,30.38,30.75,30.62,30.47,31.06,31.34,32.62,32.53,31.94,31.66,30.84,30.5,31.31,32.75,32.25,33.44,33.91,34.91,34.66,34.38,35.75,35.75,36.69,37.97,38.44,38.88,39.03,37.84,37.97,38.12,37.91,37.78,39.53,39.19,38.75,36.53,35.38,31.78,29.19,28.34,28.06,27.19,28.66,29.38,29.81,30.31,30.62,31.91,32.38,32.28,32.41,32.16,31.72,31.53,30.75,30.97,30.22,29.12,28.03,25.34,21.78,18.75,16.31,13.5,11.97,12.91,13.19,15.53,17.06,19.94,21.78,24.5,25.12,25.88,26.31,25.28,23.97,22.94,24.19,25.19,26.53,30.12,31.78,33.5,34.28,33.03,31.44,30.38,28.25,27.47,27.38,28.56,28.41,28.31,29.72,28.09,28.62,27.34,29.03,30.56,32.72,34.0,33.75,34.25,32.28,30.31,29.53,27.69,26.53,24.78,23.44,22.44,22.03,21.41,21.56,22.16,22.0,22.66,22.59,22.19,22.22,20.62,21.06,20.5,19.88,20.53,20.66,20.22,20.84,21.09,22.72,23.94,26.34,28.56,30.38,31.72,31.09,31.0,30.09,29.62,30.06,31.0,32.75,35.12,36.53,38.72,39.59,38.5,37.62,35.91,35.06,34.91,35.66,36.28,37.25,37.88,39.0,36.72,38.16,38.06,37.12,37.06,36.34,36.59,34.62,34.41,33.94,33.62,33.38,32.56,33.38,34.25,34.44,35.94,36.72,37.41,36.56,34.97,33.94,32.06,30.56,28.0,26.16,25.56,23.34,22.91,23.91,24.69,25.91,27.72,28.91,30.28,29.34,28.75,26.81,25.38,24.75,23.88,24.22,26.19,27.94,29.0,32.28,32.69,33.56,33.62,33.78,32.31,32.56,31.78,31.56,31.25,32.28,32.56,32.88,33.12,33.0,33.44,32.5,33.78,31.94,32.16,32.56,31.19,31.78,32.5,32.44,33.75,33.78,33.78,33.31,31.84,31.5,31.16,30.16,30.69,30.56,31.28,30.28,29.78,29.56,27.62,26.94,24.88,24.62,24.44,25.38,26.62,27.97,28.5,29.69,30.03,30.22,29.94,30.0,29.19,28.88,29.06,28.81,29.31,28.28,28.5,27.34,26.97,26.72,26.09,26.09,26.72,25.41,25.22,23.81,21.88,20.06,19.78,18.88,19.12,19.78,21.5,23.16,25.16,29.25,30.94,32.75,34.75,35.12,33.91,33.19,30.78,28.28,26.53,23.5,23.41,23.03,24.03,25.19,25.56,26.81,27.47,28.16,28.5,29.25,29.5,29.47,29.25,30.38,29.53,29.5,30.25,31.38,33.75,35.06,36.78,39.41,39.91,39.66,39.72,39.56,37.25,37.16,37.28,37.22,38.5,38.38,38.72,38.28,36.5,34.59,32.25,31.34,31.16,30.84,31.56,32.16,31.28,29.84,27.72,26.56,25.62,24.34,24.22,24.81,25.38,25.53,25.94,26.19,28.09,26.19,26.81,25.91,24.62,23.91,22.78,22.78,21.81,21.0,20.28,20.16,20.19,21.78,23.62,25.53,27.56,28.06,29.69,29.91,31.22,30.56,31.12,30.03,27.56,28.31,26.59,27.31,28.72,30.94,32.62,35.47,36.25,37.56,38.03,38.03,37.94,37.62,37.06,35.59,34.09,33.22,32.5,31.59,31.19,30.94,30.5,29.31,29.5,28.66,28.5,27.84,27.44,26.03,25.81,24.78,23.81,23.12,21.25,20.47,20.03,19.66,19.78,20.41,19.75,19.19,20.62,19.41,21.81,23.25,25.12,26.53,27.75,29.28,28.69,28.97,29.91,30.06,29.03,29.06,28.78,27.97,28.03,27.53,28.19,27.59,29.28,29.19,30.0,30.69,30.5,30.0,30.31,31.28,31.38,31.59,31.81,30.66,28.66,25.81,25.06,21.53,20.66,19.22,20.28,20.94,22.5,25.97,26.56,28.88,30.5,30.94,32.19,32.09,31.31,30.22,29.84,28.16,28.16,29.19,28.84,29.0,29.28,28.31,28.25,28.44,28.81,29.53,30.16,29.38,29.5,28.75,26.88,27.44,26.84,27.25,27.75,29.19,30.88,31.34,32.5,32.81,32.03,32.75,32.16,31.81,29.88,28.34,25.69,23.91,22.5,22.03,24.12,26.03,29.28,31.53,34.41,35.75,37.09,37.59,38.22,38.91,39.78,39.78,39.41,37.06,36.19,32.72,31.41,30.06,29.66,28.88,29.16,28.44,28.47,26.75,26.31,26.16,24.69,25.31,24.94,24.5,23.97,24.19,25.41,26.34,29.31,30.94,31.75,34.16,35.16,35.56,37.28,38.22,39.31,39.31,39.06,38.03,35.41,32.31,30.28,28.31,27.91,28.03,28.22,28.53,28.06,26.53,25.53,24.62,24.03,22.31,23.75,21.91,22.16,21.91,20.81,20.5,21.25,20.19,21.72,21.44,21.16,20.75,21.09,20.72,22.16,21.94,23.34,23.34,21.88,23.16,21.62,20.31,19.94,18.66,17.72,16.97,17.66,16.22,18.19,19.28,21.25,22.97,26.56,27.25,28.44,29.09,29.66,30.47,30.06,31.81,29.94,29.56,27.62,26.69,24.16,22.94,21.56,20.25,18.91,19.53,18.84,18.72,19.66,20.75,21.66,22.94,24.62,25.84,25.41,25.75,24.41,23.66,22.28,20.56,19.72,18.38,16.94,16.5,15.44,13.94,13.5,11.81,9.91,8.78,7.25,6.19,5.94,6.59,7.94,11.38,13.97,16.5,17.81,19.09,18.94,18.0,15.28,13.62,11.41,10.81,9.53,10.03,10.81,11.5,11.88,12.09,11.72,11.94,11.56,10.59,11.31,10.78,11.84,12.84,14.69,16.03,16.31,16.81,15.69,14.69,12.44,12.19,11.03,11.41,12.09,12.38,13.91,15.28,13.88,13.94,13.03,11.81,11.75,11.16,10.81,11.5,11.66,12.5,12.34,15.22,15.75,15.84,15.41,14.12,10.84,8.53,6.31,4.53,3.97,4.31,5.12,7.94,9.69,10.94,12.06,13.19,12.53,12.22,11.62,12.94,12.12,13.0,14.5,15.66,17.66,19.78,20.44,22.97,22.62,23.12,22.72,22.69,21.56,21.0,19.16,17.88,15.81,14.75,12.19,10.97,9.34,9.75,8.94,8.81,10.09,10.97,10.81,11.69,13.56,15.69,18.22,21.38,22.22,23.56,22.56,19.72,18.34,16.16,-5.81,-4.03,-2.78,-1.5,-1.22,-2.0,-2.19,-4.84,-7.66,-10.66,-12.03,-14.56:35.0,31.94,29.72,28.41,27.22,26.53,27.84,29.28,31.06,33.28,34.56,36.0,36.81,38.06,38.88,38.34,39.66,40.41,40.69,41.03,41.5,41.56,41.25,41.69,40.62,39.62,37.16,34.81,31.75,30.06,28.19,28.22,29.34,28.44,29.62,29.94,30.38,30.0,29.97,30.0,29.28,28.59,28.31,27.69,27.56,25.94,25.84,24.56,23.06,20.56,17.91,15.56,13.31,11.03,10.19,9.0,7.56,8.19,8.62,10.0,11.75,15.12,17.72,21.59,26.09,31.34,36.12,38.06,41.44,41.19,40.22,39.25,37.78,37.62,35.53,33.91,32.12,29.16,27.0,24.41,22.94,21.81,20.06,19.56,19.16,18.06,19.06,18.72,20.56,23.38,23.88,25.53,26.09,25.56,25.88,24.94,24.56,23.75,23.12,24.44,25.06,26.34,27.16,27.66,27.44,26.91,25.94,25.91,26.56,26.84,27.97,30.31,31.47,32.94,34.59,35.5,36.25,37.56,38.44,38.28,38.28,36.81,35.62,33.53,32.06,31.12,30.53,29.38,28.66,28.03,28.56,28.41,29.28,30.38,30.75,30.62,30.47,31.06,31.34,32.62,32.53,31.94,31.66,30.84,30.5,31.31,32.75,32.25,33.44,33.91,34.91,34.66,34.38,35.75,35.75,36.69,37.97,38.44,38.88,39.03,37.84,37.97,38.12,37.91,37.78,39.53,39.19,38.75,36.53,35.38,31.78,29.19,28.34,28.06,27.19,28.66,29.38,29.81,30.31,30.62,31.91,32.38,32.28,32.41,32.16,31.72,31.53,30.75,30.97,30.22,29.12,28.03,25.34,21.78,18.75,16.31,13.5,11.97,12.91,13.19,15.53,17.06,19.94,21.78,24.5,25.12,25.88,26.31,25.28,23.97,22.94,24.19,25.19,26.53,30.12,31.78,33.5,34.28,33.03,31.44,30.38,28.25,27.47,27.38,28.56,28.41,28.31,29.72,28.09,28.62,27.34,29.03,30.56,32.72,34.0,33.75,34.25,32.28,30.31,29.53,27.69,26.53,24.78,23.44,22.44,22.03,21.41,21.56,22.16,22.0,22.66,22.59,22.19,22.22,20.62,21.06,20.5,19.88,20.53,20.66,20.22,20.84,21.09,22.72,23.94,26.34,28.56,30.38,31.72,31.09,31.0,30.09,29.62,30.06,31.0,32.75,35.12,36.53,38.72,39.59,38.5,37.62,35.91,35.06,34.91,35.66,36.28,37.25,37.88,39.0,36.72,38.16,38.06,37.12,37.06,36.34,36.59,34.62,34.41,33.94,33.62,33.38,32.56,33.38,34.25,34.44,35.94,36.72,37.41,36.56,34.97,33.94,32.06,30.56,28.0,26.16,25.56,23.34,22.91,23.91,24.69,25.91,27.72,28.91,30.28,29.34,28.75,26.81,25.38,24.75,23.88,24.22,26.19,27.94,29.0,32.28,32.69,33.56,33.62,33.78,32.31,32.56,31.78,31.56,31.25,32.28,32.56,32.88,33.12,33.0,33.44,32.5,33.78,31.94,32.16,32.56,31.19,31.78,32.5,32.44,33.75,33.78,33.78,33.31,31.84,31.5,31.16,30.16,30.69,30.56,31.28,30.28,29.78,29.56,27.62,26.94,24.88,24.62,24.44,25.38,26.62,27.97,28.5,29.69,30.03,30.22,29.94,30.0,29.19,28.88,29.06,28.81,29.31,28.28,28.5,27.34,26.97,26.72,26.09,26.09,26.72,25.41,25.22,23.81,21.88,20.06,19.78,18.88,19.12,19.78,21.5,23.16,25.16,29.25,30.94,32.75,34.75,35.12,33.91,33.19,30.78,28.28,26.53,23.5,23.41,23.03,24.03,25.19,25.56,26.81,27.47,28.16,28.5,29.25,29.5,29.47,29.25,30.38,29.53,29.5,30.25,31.38,33.75,35.06,36.78,39.41,39.91,39.66,39.72,39.56,37.25,37.16,37.28,37.22,38.5,38.38,38.72,38.28,36.5,34.59,32.25,31.34,31.16,30.84,31.56,32.16,31.28,29.84,27.72,26.56,25.62,24.34,24.22,24.81,25.38,25.53,25.94,26.19,28.09,26.19,26.81,25.91,24.62,23.91,22.78,22.78,21.81,21.0,20.28,20.16,20.19,21.78,23.62,25.53,27.56,28.06,29.69,29.91,31.22,30.56,31.12,30.03,27.56,28.31,26.59,27.31,28.72,30.94,32.62,35.47,36.25,37.56,38.03,38.03,37.94,37.62,37.06,35.59,34.09,33.22,32.5,31.59,31.19,30.94,30.5,29.31,29.5,28.66,28.5,27.84,27.44,26.03,25.81,24.78,23.81,23.12,21.25,20.47,20.03,19.66,19.78,20.41,19.75,19.19,20.62,19.41,21.81,23.25,25.12,26.53,27.75,29.28,28.69,28.97,29.91,30.06,29.03,29.06,28.78,27.97,28.03,27.53,28.19,27.59,29.28,29.19,30.0,30.69,30.5,30.0,30.31,31.28,31.38,31.59,31.81,30.66,28.66,25.81,25.06,21.53,20.66,19.22,20.28,20.94,22.5,25.97,26.56,28.88,30.5,30.94,32.19,32.09,31.31,30.22,29.84,28.16,28.16,29.19,28.84,29.0,29.28,28.31,28.25,28.44,28.81,29.53,30.16,29.38,29.5,28.75,26.88,27.44,26.84,27.25,27.75,29.19,30.88,31.34,32.5,32.81,32.03,32.75,32.16,31.81,29.88,28.34,25.69,23.91,22.5,22.03,24.12,26.03,29.28,31.53,34.41,35.75,37.09,37.59,38.22,38.91,39.78,39.78,39.41,37.06,36.19,32.72,31.41,30.06,29.66,28.88,29.16,28.44,28.47,26.75,26.31,26.16,24.69,25.31,24.94,24.5,23.97,24.19,25.41,26.34,29.31,30.94,31.75,34.16,35.16,35.56,37.28,38.22,39.31,39.31,39.06,38.03,35.41,32.31,30.28,28.31,27.91,28.03,28.22,28.53,28.06,26.53,25.53,24.62,24.03,22.31,23.75,21.91,22.16,21.91,20.81,20.5,21.25,20.19,21.72,21.44,21.16,20.75,21.09,20.72,22.16,21.94,23.34,23.34,21.88,23.16,21.62,20.31,19.94,18.66,17.72,16.97,17.66,16.22,18.19,19.28,21.25,22.97,26.56,27.25,28.44,29.09,29.66,30.47,30.06,31.81,29.94,29.56,27.62,26.69,24.16,22.94,21.56,20.25,18.91,19.53,18.84,18.72,19.66,20.75,21.66,22.94,24.62,25.84,25.41,25.75,24.41,23.66,22.28,20.56,19.72,18.38,16.94,16.5,15.44,13.94,13.5,11.81,9.91,8.78,7.25,6.19,5.94,6.59,7.94,11.38,13.97,16.5,17.81,19.09,18.94,18.0,15.28,13.62,11.41,10.81,9.53,10.03,10.81,11.5,11.88,12.09,11.72,11.94,11.56,10.59,11.31,10.78,11.84,12.84,14.69,16.03,16.31,16.81,15.69,14.69,12.44,12.19,11.03,11.41,12.09,12.38,13.91,15.28,13.88,13.94,13.03,11.81,11.75,11.16,10.81,11.5,11.66,12.5,12.34,15.22,15.75,15.84,15.41,14.12,10.84,8.53,6.31,4.53,3.97,4.31,5.12,7.94,9.69,10.94,12.06,13.19,12.53,12.22,11.62,12.94,12.12,13.0,14.5,15.66,17.66,19.78,20.44,22.97,22.62,23.12,22.72,22.69,21.56,21.0,19.16,17.88,15.81,14.75,12.19,10.97,9.34,9.75,8.94,8.81,10.09,10.97,10.81,11.69,13.56,15.69,18.22,21.38,22.22,23.56,22.56,19.72,18.34,16.16,-5.81,-4.03,-2.78,-1.5,-1.22,-2.0,-2.19,-4.84,-7.66,-10.66,-12.03,-14.56,-12.88,-10.66,-6.22,-3.03,1.53,3.34:27.84,29.28,31.06,33.28,34.56,36.0,36.81,38.06,38.88,38.34,39.66,40.41,40.69,41.03,41.5,41.56,41.25,41.69,40.62,39.62,37.16,34.81,31.75,30.06,28.19,28.22,29.34,28.44,29.62,29.94,30.38,30.0,29.97,30.0,29.28,28.59,28.31,27.69,27.56,25.94,25.84,24.56,23.06,20.56,17.91,15.56,13.31,11.03,10.19,9.0,7.56,8.19,8.62,10.0,11.75,15.12,17.72,21.59,26.09,31.34,36.12,38.06,41.44,41.19,40.22,39.25,37.78,37.62,35.53,33.91,32.12,29.16,27.0,24.41,22.94,21.81,20.06,19.56,19.16,18.06,19.06,18.72,20.56,23.38,23.88,25.53,26.09,25.56,25.88,24.94,24.56,23.75,23.12,24.44,25.06,26.34,27.16,27.66,27.44,26.91,25.94,25.91,26.56,26.84,27.97,30.31,31.47,32.94,34.59,35.5,36.25,37.56,38.44,38.28,38.28,36.81,35.62,33.53,32.06,31.12,30.53,29.38,28.66,28.03,28.56,28.41,29.28,30.38,30.75,30.62,30.47,31.06,31.34,32.62,32.53,31.94,31.66,30.84,30.5,31.31,32.75,32.25,33.44,33.91,34.91,34.66,34.38,35.75,35.75,36.69,37.97,38.44,38.88,39.03,37.84,37.97,38.12,37.91,37.78,39.53,39.19,38.75,36.53,35.38,31.78,29.19,28.34,28.06,27.19,28.66,29.38,29.81,30.31,30.62,31.91,32.38,32.28,32.41,32.16,31.72,31.53,30.75,30.97,30.22,29.12,28.03,25.34,21.78,18.75,16.31,13.5,11.97,12.91,13.19,15.53,17.06,19.94,21.78,24.5,25.12,25.88,26.31,25.28,23.97,22.94,24.19,25.19,26.53,30.12,31.78,33.5,34.28,33.03,31.44,30.38,28.25,27.47,27.38,28.56,28.41,28.31,29.72,28.09,28.62,27.34,29.03,30.56,32.72,34.0,33.75,34.25,32.28,30.31,29.53,27.69,26.53,24.78,23.44,22.44,22.03,21.41,21.56,22.16,22.0,22.66,22.59,22.19,22.22,20.62,21.06,20.5,19.88,20.53,20.66,20.22,20.84,21.09,22.72,23.94,26.34,28.56,30.38,31.72,31.09,31.0,30.09,29.62,30.06,31.0,32.75,35.12,36.53,38.72,39.59,38.5,37.62,35.91,35.06,34.91,35.66,36.28,37.25,37.88,39.0,36.72,38.16,38.06,37.12,37.06,36.34,36.59,34.62,34.41,33.94,33.62,33.38,32.56,33.38,34.25,34.44,35.94,36.72,37.41,36.56,34.97,33.94,32.06,30.56,28.0,26.16,25.56,23.34,22.91,23.91,24.69,25.91,27.72,28.91,30.28,29.34,28.75,26.81,25.38,24.75,23.88,24.22,26.19,27.94,29.0,32.28,32.69,33.56,33.62,33.78,32.31,32.56,31.78,31.56,31.25,32.28,32.56,32.88,33.12,33.0,33.44,32.5,33.78,31.94,32.16,32.56,31.19,31.78,32.5,32.44,33.75,33.78,33.78,33.31,31.84,31.5,31.16,30.16,30.69,30.56,31.28,30.28,29.78,29.56,27.62,26.94,24.88,24.62,24.44,25.38,26.62,27.97,28.5,29.69,30.03,30.22,29.94,30.0,29.19,28.88,29.06,28.81,29.31,28.28,28.5,27.34,26.97,26.72,26.09,26.09,26.72,25.41,25.22,23.81,21.88,20.06,19.78,18.88,19.12,19.78,21.5,23.16,25.16,29.25,30.94,32.75,34.75,35.12,33.91,33.19,30.78,28.28,26.53,23.5,23.41,23.03,24.03,25.19,25.56,26.81,27.47,28.16,28.5,29.25,29.5,29.47,29.25,30.38,29.53,29.5,30.25,31.38,33.75,35.06,36.78,39.41,39.91,39.66,39.72,39.56,37.25,37.16,37.28,37.22,38.5,38.38,38.72,38.28,36.5,34.59,32.25,31.34,31.16,30.84,31.56,32.16,31.28,29.84,27.72,26.56,25.62,24.34,24.22,24.81,25.38,25.53,25.94,26.19,28.09,26.19,26.81,25.91,24.62,23.91,22.78,22.78,21.81,21.0,20.28,20.16,20.19,21.78,23.62,25.53,27.56,28.06,29.69,29.91,31.22,30.56,31.12,30.03,27.56,28.31,26.59,27.31,28.72,30.94,32.62,35.47,36.25,37.56,38.03,38.03,37.94,37.62,37.06,35.59,34.09,33.22,32.5,31.59,31.19,30.94,30.5,29.31,29.5,28.66,28.5,27.84,27.44,26.03,25.81,24.78,23.81,23.12,21.25,20.47,20.03,19.66,19.78,20.41,19.75,19.19,20.62,19.41,21.81,23.25,25.12,26.53,27.75,29.28,28.69,28.97,29.91,30.06,29.03,29.06,28.78,27.97,28.03,27.53,28.19,27.59,29.28,29.19,30.0,30.69,30.5,30.0,30.31,31.28,31.38,31.59,31.81,30.66,28.66,25.81,25.06,21.53,20.66,19.22,20.28,20.94,22.5,25.97,26.56,28.88,30.5,30.94,32.19,32.09,31.31,30.22,29.84,28.16,28.16,29.19,28.84,29.0,29.28,28.31,28.25,28.44,28.81,29.53,30.16,29.38,29.5,28.75,26.88,27.44,26.84,27.25,27.75,29.19,30.88,31.34,32.5,32.81,32.03,32.75,32.16,31.81,29.88,28.34,25.69,23.91,22.5,22.03,24.12,26.03,29.28,31.53,34.41,35.75,37.09,37.59,38.22,38.91,39.78,39.78,39.41,37.06,36.19,32.72,31.41,30.06,29.66,28.88,29.16,28.44,28.47,26.75,26.31,26.16,24.69,25.31,24.94,24.5,23.97,24.19,25.41,26.34,29.31,30.94,31.75,34.16,35.16,35.56,37.28,38.22,39.31,39.31,39.06,38.03,35.41,32.31,30.28,28.31,27.91,28.03,28.22,28.53,28.06,26.53,25.53,24.62,24.03,22.31,23.75,21.91,22.16,21.91,20.81,20.5,21.25,20.19,21.72,21.44,21.16,20.75,21.09,20.72,22.16,21.94,23.34,23.34,21.88,23.16,21.62,20.31,19.94,18.66,17.72,16.97,17.66,16.22,18.19,19.28,21.25,22.97,26.56,27.25,28.44,29.09,29.66,30.47,30.06,31.81,29.94,29.56,27.62,26.69,24.16,22.94,21.56,20.25,18.91,19.53,18.84,18.72,19.66,20.75,21.66,22.94,24.62,25.84,25.41,25.75,24.41,23.66,22.28,20.56,19.72,18.38,16.94,16.5,15.44,13.94,13.5,11.81,9.91,8.78,7.25,6.19,5.94,6.59,7.94,11.38,13.97,16.5,17.81,19.09,18.94,18.0,15.28,13.62,11.41,10.81,9.53,10.03,10.81,11.5,11.88,12.09,11.72,11.94,11.56,10.59,11.31,10.78,11.84,12.84,14.69,16.03,16.31,16.81,15.69,14.69,12.44,12.19,11.03,11.41,12.09,12.38,13.91,15.28,13.88,13.94,13.03,11.81,11.75,11.16,10.81,11.5,11.66,12.5,12.34,15.22,15.75,15.84,15.41,14.12,10.84,8.53,6.31,4.53,3.97,4.31,5.12,7.94,9.69,10.94,12.06,13.19,12.53,12.22,11.62,12.94,12.12,13.0,14.5,15.66,17.66,19.78,20.44,22.97,22.62,23.12,22.72,22.69,21.56,21.0,19.16,17.88,15.81,14.75,12.19,10.97,9.34,9.75,8.94,8.81,10.09,10.97,10.81,11.69,13.56,15.69,18.22,21.38,22.22,23.56,22.56,19.72,18.34,16.16,-5.81,-4.03,-2.78,-1.5,-1.22,-2.0,-2.19,-4.84,-7.66,-10.66,-12.03,-14.56,-12.88,-10.66,-6.22,-3.03,1.53,3.34,1.69,1.09,-1.84,-5.28,-7.47,-7.94:36.81,38.06,38.88,38.34,39.66,40.41,40.69,41.03,41.5,41.56,41.25,41.69,40.62,39.62,37.16,34.81,31.75,30.06,28.19,28.22,29.34,28.44,29.62,29.94,30.38,30.0,29.97,30.0,29.28,28.59,28.31,27.69,27.56,25.94,25.84,24.56,23.06,20.56,17.91,15.56,13.31,11.03,10.19,9.0,7.56,8.19,8.62,10.0,11.75,15.12,17.72,21.59,26.09,31.34,36.12,38.06,41.44,41.19,40.22,39.25,37.78,37.62,35.53,33.91,32.12,29.16,27.0,24.41,22.94,21.81,20.06,19.56,19.16,18.06,19.06,18.72,20.56,23.38,23.88,25.53,26.09,25.56,25.88,24.94,24.56,23.75,23.12,24.44,25.06,26.34,27.16,27.66,27.44,26.91,25.94,25.91,26.56,26.84,27.97,30.31,31.47,32.94,34.59,35.5,36.25,37.56,38.44,38.28,38.28,36.81,35.62,33.53,32.06,31.12,30.53,29.38,28.66,28.03,28.56,28.41,29.28,30.38,30.75,30.62,30.47,31.06,31.34,32.62,32.53,31.94,31.66,30.84,30.5,31.31,32.75,32.25,33.44,33.91,34.91,34.66,34.38,35.75,35.75,36.69,37.97,38.44,38.88,39.03,37.84,37.97,38.12,37.91,37.78,39.53,39.19,38.75,36.53,35.38,31.78,29.19,28.34,28.06,27.19,28.66,29.38,29.81,30.31,30.62,31.91,32.38,32.28,32.41,32.16,31.72,31.53,30.75,30.97,30.22,29.12,28.03,25.34,21.78,18.75,16.31,13.5,11.97,12.91,13.19,15.53,17.06,19.94,21.78,24.5,25.12,25.88,26.31,25.28,23.97,22.94,24.19,25.19,26.53,30.12,31.78,33.5,34.28,33.03,31.44,30.38,28.25,27.47,27.38,28.56,28.41,28.31,29.72,28.09,28.62,27.34,29.03,30.56,32.72,34.0,33.75,34.25,32.28,30.31,29.53,27.69,26.53,24.78,23.44,22.44,22.03,21.41,21.56,22.16,22.0,22.66,22.59,22.19,22.22,20.62,21.06,20.5,19.88,20.53,20.66,20.22,20.84,21.09,22.72,23.94,26.34,28.56,30.38,31.72,31.09,31.0,30.09,29.62,30.06,31.0,32.75,35.12,36.53,38.72,39.59,38.5,37.62,35.91,35.06,34.91,35.66,36.28,37.25,37.88,39.0,36.72,38.16,38.06,37.12,37.06,36.34,36.59,34.62,34.41,33.94,33.62,33.38,32.56,33.38,34.25,34.44,35.94,36.72,37.41,36.56,34.97,33.94,32.06,30.56,28.0,26.16,25.56,23.34,22.91,23.91,24.69,25.91,27.72,28.91,30.28,29.34,28.75,26.81,25.38,24.75,23.88,24.22,26.19,27.94,29.0,32.28,32.69,33.56,33.62,33.78,32.31,32.56,31.78,31.56,31.25,32.28,32.56,32.88,33.12,33.0,33.44,32.5,33.78,31.94,32.16,32.56,31.19,31.78,32.5,32.44,33.75,33.78,33.78,33.31,31.84,31.5,31.16,30.16,30.69,30.56,31.28,30.28,29.78,29.56,27.62,26.94,24.88,24.62,24.44,25.38,26.62,27.97,28.5,29.69,30.03,30.22,29.94,30.0,29.19,28.88,29.06,28.81,29.31,28.28,28.5,27.34,26.97,26.72,26.09,26.09,26.72,25.41,25.22,23.81,21.88,20.06,19.78,18.88,19.12,19.78,21.5,23.16,25.16,29.25,30.94,32.75,34.75,35.12,33.91,33.19,30.78,28.28,26.53,23.5,23.41,23.03,24.03,25.19,25.56,26.81,27.47,28.16,28.5,29.25,29.5,29.47,29.25,30.38,29.53,29.5,30.25,31.38,33.75,35.06,36.78,39.41,39.91,39.66,39.72,39.56,37.25,37.16,37.28,37.22,38.5,38.38,38.72,38.28,36.5,34.59,32.25,31.34,31.16,30.84,31.56,32.16,31.28,29.84,27.72,26.56,25.62,24.34,24.22,24.81,25.38,25.53,25.94,26.19,28.09,26.19,26.81,25.91,24.62,23.91,22.78,22.78,21.81,21.0,20.28,20.16,20.19,21.78,23.62,25.53,27.56,28.06,29.69,29.91,31.22,30.56,31.12,30.03,27.56,28.31,26.59,27.31,28.72,30.94,32.62,35.47,36.25,37.56,38.03,38.03,37.94,37.62,37.06,35.59,34.09,33.22,32.5,31.59,31.19,30.94,30.5,29.31,29.5,28.66,28.5,27.84,27.44,26.03,25.81,24.78,23.81,23.12,21.25,20.47,20.03,19.66,19.78,20.41,19.75,19.19,20.62,19.41,21.81,23.25,25.12,26.53,27.75,29.28,28.69,28.97,29.91,30.06,29.03,29.06,28.78,27.97,28.03,27.53,28.19,27.59,29.28,29.19,30.0,30.69,30.5,30.0,30.31,31.28,31.38,31.59,31.81,30.66,28.66,25.81,25.06,21.53,20.66,19.22,20.28,20.94,22.5,25.97,26.56,28.88,30.5,30.94,32.19,32.09,31.31,30.22,29.84,28.16,28.16,29.19,28.84,29.0,29.28,28.31,28.25,28.44,28.81,29.53,30.16,29.38,29.5,28.75,26.88,27.44,26.84,27.25,27.75,29.19,30.88,31.34,32.5,32.81,32.03,32.75,32.16,31.81,29.88,28.34,25.69,23.91,22.5,22.03,24.12,26.03,29.28,31.53,34.41,35.75,37.09,37.59,38.22,38.91,39.78,39.78,39.41,37.06,36.19,32.72,31.41,30.06,29.66,28.88,29.16,28.44,28.47,26.75,26.31,26.16,24.69,25.31,24.94,24.5,23.97,24.19,25.41,26.34,29.31,30.94,31.75,34.16,35.16,35.56,37.28,38.22,39.31,39.31,39.06,38.03,35.41,32.31,30.28,28.31,27.91,28.03,28.22,28.53,28.06,26.53,25.53,24.62,24.03,22.31,23.75,21.91,22.16,21.91,20.81,20.5,21.25,20.19,21.72,21.44,21.16,20.75,21.09,20.72,22.16,21.94,23.34,23.34,21.88,23.16,21.62,20.31,19.94,18.66,17.72,16.97,17.66,16.22,18.19,19.28,21.25,22.97,26.56,27.25,28.44,29.09,29.66,30.47,30.06,31.81,29.94,29.56,27.62,26.69,24.16,22.94,21.56,20.25,18.91,19.53,18.84,18.72,19.66,20.75,21.66,22.94,24.62,25.84,25.41,25.75,24.41,23.66,22.28,20.56,19.72,18.38,16.94,16.5,15.44,13.94,13.5,11.81,9.91,8.78,7.25,6.19,5.94,6.59,7.94,11.38,13.97,16.5,17.81,19.09,18.94,18.0,15.28,13.62,11.41,10.81,9.53,10.03,10.81,11.5,11.88,12.09,11.72,11.94,11.56,10.59,11.31,10.78,11.84,12.84,14.69,16.03,16.31,16.81,15.69,14.69,12.44,12.19,11.03,11.41,12.09,12.38,13.91,15.28,13.88,13.94,13.03,11.81,11.75,11.16,10.81,11.5,11.66,12.5,12.34,15.22,15.75,15.84,15.41,14.12,10.84,8.53,6.31,4.53,3.97,4.31,5.12,7.94,9.69,10.94,12.06,13.19,12.53,12.22,11.62,12.94,12.12,13.0,14.5,15.66,17.66,19.78,20.44,22.97,22.62,23.12,22.72,22.69,21.56,21.0,19.16,17.88,15.81,14.75,12.19,10.97,9.34,9.75,8.94,8.81,10.09,10.97,10.81,11.69,13.56,15.69,18.22,21.38,22.22,23.56,22.56,19.72,18.34,16.16,-5.81,-4.03,-2.78,-1.5,-1.22,-2.0,-2.19,-4.84,-7.66,-10.66,-12.03,-14.56,-12.88,-10.66,-6.22,-3.03,1.53,3.34,1.69,1.09,-1.84,-5.28,-7.47,-7.94,-8.16,-6.16,-4.16,-1.88,0.06,2.5:negativity
-1.25,-3.66,-6.34,-7.47,-7.97,-6.5,-4.38,-2.59,0.22,0.78,2.56,1.72,2.28,3.06,3.81,4.28,4.75,5.25,5.66,3.72,2.28,0.69,-1.5,-3.28,-3.66,-3.59,-3.28,-1.03,-0.09,1.47,2.69,4.12,3.03,2.56,2.62,1.5,3.41,4.19,5.66,6.16,4.72,6.0,4.91,3.28,5.19,3.0,2.12,1.06,-0.41,-0.72,-0.12,1.66,1.94,2.31,3.28,3.56,4.28,4.06,4.97,6.28,4.72,4.94,4.31,1.28,0.03,-2.47,-6.34,-10.5,-12.53,-16.28,-19.69,-21.47,-23.59,-24.94,-25.41,-24.69,-23.47,-20.06,-17.66,-14.75,-11.09,-8.84,-4.91,-1.72,1.38,3.69,4.44,3.62,3.81,2.0,2.25,3.0,3.06,2.5,2.44,2.5,1.25,0.53,0.69,-0.34,-0.47,-2.28,-1.94,-2.53,-1.69,-0.66,1.12,1.31,2.75,2.72,1.69,1.38,-0.69,-2.75,-4.31,-6.25,-8.03,-8.59,-8.72,-8.47,-6.84,-6.75,-5.16,-4.66,-3.69,-3.16,-3.19,-2.81,-2.75,-3.84,-4.59,-3.41,-3.97,-2.91,-3.28,-0.66,0.12,2.0,6.22,8.94,10.88,13.81,14.19,12.56,11.12,8.81,7.62,5.81,4.28,2.03,2.28,1.44,1.41,1.91,1.66,0.31,0.47,-1.34,-2.91,-2.47,-3.38,-4.03,-2.97,-1.78,-0.97,0.16,0.09,-0.41,-0.06,-0.47,0.0,1.75,2.62,3.62,4.22,3.81,4.09,6.25,6.22,6.12,5.94,5.47,6.66,6.56,8.31,10.09,11.56,11.44,9.41,8.88,6.31,4.88,3.03,2.66,2.84,3.31,3.41,4.78,5.41,5.94,6.03,7.47,6.88,6.34,5.28,5.94,3.94,4.0,3.94,3.09,2.47,1.94,1.31,1.44,-0.88,-1.84,-2.31,-3.88,-4.84,-4.53,-4.88,-3.69,-2.56,-1.78,-0.47,-0.97,-1.28,-3.12,-4.34,-6.28,-6.94,-7.16,-6.31,-5.22,-3.47,-2.72,-3.06,-3.28,-3.22,-5.19,-5.34,-5.03,-4.53,-4.25,-2.34,-1.06,-2.22,-0.5,-1.22,-1.31,-1.47,-2.22,-3.31,-3.94,-4.97,-5.84,-6.97,-6.97,-7.16,-7.34,-7.34,-8.06,-8.44,-8.16,-8.56,-8.66,-8.97,-11.47,-12.69,-14.34,-17.06,-17.12,-16.81,-17.84,-17.09,-17.47,-17.78,-18.62,-19.19,-19.09,-19.16,-18.44,-18.84,-17.81,-16.28,-15.84,-14.19,-11.47,-9.03,-6.34,-3.41,-1.22,-0.34,-0.66,-0.84,-2.66,-4.44,-5.41,-7.56,-8.78,-6.53,-5.81,-3.22,-0.72,2.78,2.88,3.16,2.38,0.72,-0.59,-0.75,-0.97,0.47,1.97,4.75,6.91,10.66,12.66,14.38,15.34,16.41,14.09,12.78,11.56,9.0,8.38,8.03,8.47,9.5,9.22,9.97,10.03,11.31,11.06,12.28,12.75,12.75,13.81,12.44,12.34,11.78,10.22,8.34,7.28,5.78,4.19,3.16,2.72,1.41,0.28,-0.12,-0.16,-1.28,-2.62,-3.06,-4.03,-3.38,-3.03,-0.97,-0.81,0.75,-0.09,-0.47,-1.47,-2.09,-1.91,-1.06,0.06,1.03,1.28,2.06,3.97,4.59,5.94,7.25,8.03,7.47,7.03,7.06,5.31,5.44,5.12,5.53,6.44,6.5,5.44,5.66,2.75,1.53,2.19,2.12,3.47,5.62,7.06,8.0,8.09,9.06,10.03,12.0,12.88,13.28,12.28,10.5,7.5,5.41,1.84,-0.56,-0.72,-1.81,-3.03,-2.94,-2.62,-1.41,-1.47,-1.28,-1.72,-2.22,-3.88,-7.28,-8.62,-9.62,-10.5,-9.34,-7.16,-4.47,-0.12,2.34,5.28,6.94,6.91,6.41,5.19,4.66,3.56,1.88,0.41,-0.34,-2.16,-2.38,-2.91,-2.19,-1.97,0.78,1.81,3.25,5.06,5.38,6.94,7.34,6.69,8.12,9.25,11.12,13.72,16.28,19.0,21.31,21.62,22.38,22.41,20.91,19.78,18.19,16.12,14.88,13.88,13.56,13.56,13.41,14.41,15.38,15.66,16.75,18.69,18.34,18.78,18.5,17.12,16.25,16.31,14.56,13.16,12.41,10.91,8.41,6.25,3.88,1.31,0.12,-0.88,-1.47,-0.69,0.34,0.44,1.91,1.94,2.44,2.06,2.38,2.41,2.47,3.72,4.53,5.25,7.62,9.19,11.09,13.66,14.56,16.44,15.81,15.06,14.09,11.88,10.38,8.44,6.38,5.53,4.03,2.94,3.19,3.38,3.25,2.56,3.69,3.41,4.44,5.16,6.84,8.75,9.41,10.75,11.28,11.06,10.12,10.0,7.66,4.59,3.59,2.41,1.72,2.41,3.41,4.0,4.44,3.41,2.78,1.88,0.66,0.62,-0.34,-0.69,-0.94,0.44,-0.09,0.81,2.47,3.69,6.12,7.41,9.75,10.41,10.25,10.94,10.31,9.41,10.44,8.44,6.62,4.06,1.88,-0.09,-0.5,-2.44,-1.47,-0.72,-0.34,1.91,3.19,4.09,6.22,6.03,6.03,4.53,3.78,-0.09,0.03,-2.28,-3.06,-3.72,-4.31,-4.16,-5.66,-7.94,-7.59,-8.44,-8.81,-7.97,-7.66,-7.72,-9.09,-9.09,-8.0,-8.34,-5.59,-4.78,-2.94,-0.59,0.09,1.31,2.69,2.28,2.97,2.03,-0.22,-1.75,-3.34,-5.34,-4.97,-4.78,-4.19,-1.16,1.22,2.31,5.06,4.06,3.53,2.78,0.28,-1.22,-3.31,-5.94,-7.69,-9.31,-10.0,-10.16,-8.03,-5.16,-2.91,-0.03,2.81,3.53,3.91,3.41,2.78,0.56,0.0,-0.53,-3.06,-4.97,-3.09,-2.09,0.44,3.78,7.97,8.91,8.12,8.16,7.25,4.91,4.19,-0.06,-1.44,-6.19,-6.31,-7.19,-5.47,-3.09,-1.03,-0.06,-0.34,-0.19,-0.62,-1.66,-0.91,-4.72,-4.84,-6.88,-8.16,-9.44,-9.59,-10.34,-11.03,-9.47,-8.69,-7.34,-5.56,-4.28,-2.91,-3.12,-1.66,-1.69,-0.75,-0.34,-0.75,-0.09,-1.91,-4.25,-6.16,-8.62,-10.53,-11.03,-10.44,-9.03,-7.62,-7.03,-5.25,-4.38,-4.09,-4.03,-3.62,-3.19,-2.91,-2.66,-1.22,-1.97,-0.84,-4.28,-4.72,-6.59,-8.22,-9.53,-10.56,-10.97,-12.97,-14.28,-15.06,-15.56,-15.22,-13.75,-14.22,-13.66,-13.59,-14.59,-14.78,-15.03,-15.25,-16.0,-16.72,-19.41,-21.47,-23.22,-23.66,-25.19,-23.66,-23.0,-21.97,-20.44,-19.66,-19.72,-18.94,-19.59,-19.59,-22.19,-23.91,-24.88,-27.28,-28.47,-26.59,-26.97,-24.94,-23.94,-21.31,-20.81,-19.47,-16.59,-13.84,-12.03,-8.88,-6.34,-4.44,-2.81,-1.28,0.06,0.81,1.88,2.28,2.78,2.34,2.5,1.75,0.06,-1.03,-3.56,-5.16,-4.59,-4.69,-4.47,-3.25,-2.22,-1.09,-0.69,1.09,2.66,3.31,2.56,1.84,0.31,-1.88,-2.72,-4.56,-5.06,-4.97,-5.0,-4.41,-4.03,-3.06,-1.09,-1.81,-1.16,-0.91,-1.91,-2.0,-1.97,-2.44,-2.09,-0.81,-0.69,-1.47,-1.34,-1.34,-1.44,-1.5,-0.34,-0.16,-1.25,-1.41,-2.0,-3.91,-4.59,-5.97,-6.47,-7.56,-8.41,-8.19,-7.94,-8.72,-6.97,-6.56,-5.47,-5.19,-4.25,-3.84,-3.72,-3.34,-2.5,-2.69,-1.91,-3.03,-1.97,-3.94,-4.84,-4.69,-6.41,-6.88,-6.56,-7.28,-5.81,-6.0,-6.41,-6.66,-7.78,-7.09,-7.69,-9.72,-9.03,-10.62,-11.69,-11.22,-11.53,-10.16,-10.72,-9.59,-9.91,-10.03,-8.16,-8.09,-6.78,-6.44,-7.38,-7.81,-9.25,-10.72,-10.78,-10.84,-9.78,-7.0,-5.47,-4.44,-3.31,-3.97,-5.91,-9.75,-12.09,-15.22,-18.97:-4.38,-2.59,0.22,0.78,2.56,1.72,2.28,3.06,3.81,4.28,4.75,5.25,5.66,3.72,2.28,0.69,-1.5,-3.28,-3.66,-3.59,-3.28,-1.03,-0.09,1.47,2.69,4.12,3.03,2.56,2.62,1.5,3.41,4.19,5.66,6.16,4.72,6.0,4.91,3.28,5.19,3.0,2.12,1.06,-0.41,-0.72,-0.12,1.66,1.94,2.31,3.28,3.56,4.28,4.06,4.97,6.28,4.72,4.94,4.31,1.28,0.03,-2.47,-6.34,-10.5,-12.53,-16.28,-19.69,-21.47,-23.59,-24.94,-25.41,-24.69,-23.47,-20.06,-17.66,-14.75,-11.09,-8.84,-4.91,-1.72,1.38,3.69,4.44,3.62,3.81,2.0,2.25,3.0,3.06,2.5,2.44,2.5,1.25,0.53,0.69,-0.34,-0.47,-2.28,-1.94,-2.53,-1.69,-0.66,1.12,1.31,2.75,2.72,1.69,1.38,-0.69,-2.75,-4.31,-6.25,-8.03,-8.59,-8.72,-8.47,-6.84,-6.75,-5.16,-4.66,-3.69,-3.16,-3.19,-2.81,-2.75,-3.84,-4.59,-3.41,-3.97,-2.91,-3.28,-0.66,0.12,2.0,6.22,8.94,10.88,13.81,14.19,12.56,11.12,8.81,7.62,5.81,4.28,2.03,2.28,1.44,1.41,1.91,1.66,0.31,0.47,-1.34,-2.91,-2.47,-3.38,-4.03,-2.97,-1.78,-0.97,0.16,0.09,-0.41,-0.06,-0.47,0.0,1.75,2.62,3.62,4.22,3.81,4.09,6.25,6.22,6.12,5.94,5.47,6.66,6.56,8.31,10.09,11.56,11.44,9.41,8.88,6.31,4.88,3.03,2.66,2.84,3.31,3.41,4.78,5.41,5.94,6.03,7.47,6.88,6.34,5.28,5.94,3.94,4.0,3.94,3.09,2.47,1.94,1.31,1.44,-0.88,-1.84,-2.31,-3.88,-4.84,-4.53,-4.88,-3.69,-2.56,-1.78,-0.47,-0.97,-1.28,-3.12,-4.34,-6.28,-6.94,-7.16,-6.31,-5.22,-3.47,-2.72,-3.06,-3.28,-3.22,-5.19,-5.34,-5.03,-4.53,-4.25,-2.34,-1.06,-2.22,-0.5,-1.22,-1.31,-1.47,-2.22,-3.31,-3.94,-4.97,-5.84,-6.97,-6.97,-7.16,-7.34,-7.34,-8.06,-8.44,-8.16,-8.56,-8.66,-8.97,-11.47,-12.69,-14.34,-17.06,-17.12,-16.81,-17.84,-17.09,-17.47,-17.78,-18.62,-19.19,-19.09,-19.16,-18.44,-18.84,-17.81,-16.28,-15.84,-14.19,-11.47,-9.03,-6.34,-3.41,-1.22,-0.34,-0.66,-0.84,-2.66,-4.44,-5.41,-7.56,-8.78,-6.53,-5.81,-3.22,-0.72,2.78,2.88,3.16,2.38,0.72,-0.59,-0.75,-0.97,0.47,1.97,4.75,6.91,10.66,12.66,14.38,15.34,16.41,14.09,12.78,11.56,9.0,8.38,8.03,8.47,9.5,9.22,9.97,10.03,11.31,11.06,12.28,12.75,12.75,13.81,12.44,12.34,11.78,10.22,8.34,7.28,5.78,4.19,3.16,2.72,1.41,0.28,-0.12,-0.16,-1.28,-2.62,-3.06,-4.03,-3.38,-3.03,-0.97,-0.81,0.75,-0.09,-0.47,-1.47,-2.09,-1.91,-1.06,0.06,1.03,1.28,2.06,3.97,4.59,5.94,7.25,8.03,7.47,7.03,7.06,5.31,5.44,5.12,5.53,6.44,6.5,5.44,5.66,2.75,1.53,2.19,2.12,3.47,5.62,7.06,8.0,8.09,9.06,10.03,12.0,12.88,13.28,12.28,10.5,7.5,5.41,1.84,-0.56,-0.72,-1.81,-3.03,-2.94,-2.62,-1.41,-1.47,-1.28,-1.72,-2.22,-3.88,-7.28,-8.62,-9.62,-10.5,-9.34,-7.16,-4.47,-0.12,2.34,5.28,6.94,6.91,6.41,5.19,4.66,3.56,1.88,0.41,-0.34,-2.16,-2.38,-2.91,-2.19,-1.97,0.78,1.81,3.25,5.06,5.38,6.94,7.34,6.69,8.12,9.25,11.12,13.72,16.28,19.0,21.31,21.62,22.38,22.41,20.91,19.78,18.19,16.12,14.88,13.88,13.56,13.56,13.41,14.41,15.38,15.66,16.75,18.69,18.34,18.78,18.5,17.12,16.25,16.31,14.56,13.16,12.41,10.91,8.41,6.25,3.88,1.31,0.12,-0.88,-1.47,-0.69,0.34,0.44,1.91,1.94,2.44,2.06,2.38,2.41,2.47,3.72,4.53,5.25,7.62,9.19,11.09,13.66,14.56,16.44,15.81,15.06,14.09,11.88,10.38,8.44,6.38,5.53,4.03,2.94,3.19,3.38,3.25,2.56,3.69,3.41,4.44,5.16,6.84,8.75,9.41,10.75,11.28,11.06,10.12,10.0,7.66,4.59,3.59,2.41,1.72,2.41,3.41,4.0,4.44,3.41,2.78,1.88,0.66,0.62,-0.34,-0.69,-0.94,0.44,-0.09,0.81,2.47,3.69,6.12,7.41,9.75,10.41,10.25,10.94,10.31,9.41,10.44,8.44,6.62,4.06,1.88,-0.09,-0.5,-2.44,-1.47,-0.72,-0.34,1.91,3.19,4.09,6.22,6.03,6.03,4.53,3.78,-0.09,0.03,-2.28,-3.06,-3.72,-4.31,-4.16,-5.66,-7.94,-7.59,-8.44,-8.81,-7.97,-7.66,-7.72,-9.09,-9.09,-8.0,-8.34,-5.59,-4.78,-2.94,-0.59,0.09,1.31,2.69,2.28,2.97,2.03,-0.22,-1.75,-3.34,-5.34,-4.97,-4.78,-4.19,-1.16,1.22,2.31,5.06,4.06,3.53,2.78,0.28,-1.22,-3.31,-5.94,-7.69,-9.31,-10.0,-10.16,-8.03,-5.16,-2.91,-0.03,2.81,3.53,3.91,3.41,2.78,0.56,0.0,-0.53,-3.06,-4.97,-3.09,-2.09,0.44,3.78,7.97,8.91,8.12,8.16,7.25,4.91,4.19,-0.06,-1.44,-6.19,-6.31,-7.19,-5.47,-3.09,-1.03,-0.06,-0.34,-0.19,-0.62,-1.66,-0.91,-4.72,-4.84,-6.88,-8.16,-9.44,-9.59,-10.34,-11.03,-9.47,-8.69,-7.34,-5.56,-4.28,-2.91,-3.12,-1.66,-1.69,-0.75,-0.34,-0.75,-0.09,-1.91,-4.25,-6.16,-8.62,-10.53,-11.03,-10.44,-9.03,-7.62,-7.03,-5.25,-4.38,-4.09,-4.03,-3.62,-3.19,-2.91,-2.66,-1.22,-1.97,-0.84,-4.28,-4.72,-6.59,-8.22,-9.53,-10.56,-10.97,-12.97,-14.28,-15.06,-15.56,-15.22,-13.75,-14.22,-13.66,-13.59,-14.59,-14.78,-15.03,-15.25,-16.0,-16.72,-19.41,-21.47,-23.22,-23.66,-25.19,-23.66,-23.0,-21.97,-20.44,-19.66,-19.72,-18.94,-19.59,-19.59,-22.19,-23.91,-24.88,-27.28,-28.47,-26.59,-26.97,-24.94,-23.94,-21.31,-20.81,-19.47,-16.59,-13.84,-12.03,-8.88,-6.34,-4.44,-2.81,-1.28,0.06,0.81,1.88,2.28,2.78,2.34,2.5,1.75,0.06,-1.03,-3.56,-5.16,-4.59,-4.69,-4.47,-3.25,-2.22,-1.09,-0.69,1.09,2.66,3.31,2.56,1.84,0.31,-1.88,-2.72,-4.56,-5.06,-4.97,-5.0,-4.41,-4.03,-3.06,-1.09,-1.81,-1.16,-0.91,-1.91,-2.0,-1.97,-2.44,-2.09,-0.81,-0.69,-1.47,-1.34,-1.34,-1.44,-1.5,-0.34,-0.16,-1.25,-1.41,-2.0,-3.91,-4.59,-5.97,-6.47,-7.56,-8.41,-8.19,-7.94,-8.72,-6.97,-6.56,-5.47,-5.19,-4.25,-3.84,-3.72,-3.34,-2.5,-2.69,-1.91,-3.03,-1.97,-3.94,-4.84,-4.69,-6.41,-6.88,-6.56,-7.28,-5.81,-6.0,-6.41,-6.66,-7.78,-7.09,-7.69,-9.72,-9.03,-10.62,-11.69,-11.22,-11.53,-10.16,-10.72,-9.59,-9.91,-10.03,-8.16,-8.09,-6.78,-6.44,-7.38,-7.81,-9.25,-10.72,-10.78,-10.84,-9.78,-7.0,-5.47,-4.44,-3.31,-3.97,-5.91,-9.75,-12.09,-15.22,-18.97,-50.12,-51.91,-53.12,-53.22,-51.84,-50.47:2.28,3.06,3.81,4.28,4.75,5.25,5.66,3.72,2.28,0.69,-1.5,-3.28,-3.66,-3.59,-3.28,-1.03,-0.09,1.47,2.69,4.12,3.03,2.56,2.62,1.5,3.41,4.19,5.66,6.16,4.72,6.0,4.91,3.28,5.19,3.0,2.12,1.06,-0.41,-0.72,-0.12,1.66,1.94,2.31,3.28,3.56,4.28,4.06,4.97,6.28,4.72,4.94,4.31,1.28,0.03,-2.47,-6.34,-10.5,-12.53,-16.28,-19.69,-21.47,-23.59,-24.94,-25.41,-24.69,-23.47,-20.06,-17.66,-14.75,-11.09,-8.84,-4.91,-1.72,1.38,3.69,4.44,3.62,3.81,2.0,2.25,3.0,3.06,2.5,2.44,2.5,1.25,0.53,0.69,-0.34,-0.47,-2.28,-1.94,-2.53,-1.69,-0.66,1.12,1.31,2.75,2.72,1.69,1.38,-0.69,-2.75,-4.31,-6.25,-8.03,-8.59,-8.72,-8.47,-6.84,-6.75,-5.16,-4.66,-3.69,-3.16,-3.19,-2.81,-2.75,-3.84,-4.59,-3.41,-3.97,-2.91,-3.28,-0.66,0.12,2.0,6.22,8.94,10.88,13.81,14.19,12.56,11.12,8.81,7.62,5.81,4.28,2.03,2.28,1.44,1.41,1.91,1.66,0.31,0.47,-1.34,-2.91,-2.47,-3.38,-4.03,-2.97,-1.78,-0.97,0.16,0.09,-0.41,-0.06,-0.47,0.0,1.75,2.62,3.62,4.22,3.81,4.09,6.25,6.22,6.12,5.94,5.47,6.66,6.56,8.31,10.09,11.56,11.44,9.41,8.88,6.31,4.88,3.03,2.66,2.84,3.31,3.41,4.78,5.41,5.94,6.03,7.47,6.88,6.34,5.28,5.94,3.94,4.0,3.94,3.09,2.47,1.94,1.31,1.44,-0.88,-1.84,-2.31,-3.88,-4.84,-4.53,-4.88,-3.69,-2.56,-1.78,-0.47,-0.97,-1.28,-3.12,-4.34,-6.28,-6.94,-7.16,-6.31,-5.22,-3.47,-2.72,-3.06,-3.28,-3.22,-5.19,-5.34,-5.03,-4.53,-4.25,-2.34,-1.06,-2.22,-0.5,-1.22,-1.31,-1.47,-2.22,-3.31,-3.94,-4.97,-5.84,-6.97,-6.97,-7.16,-7.34,-7.34,-8.06,-8.44,-8.16,-8.56,-8.66,-8.97,-11.47,-12.69,-14.34,-17.06,-17.12,-16.81,-17.84,-17.09,-17.47,-17.78,-18.62,-19.19,-19.09,-19.16,-18.44,-18.84,-17.81,-16.28,-15.84,-14.19,-11.47,-9.03,-6.34,-3.41,-1.22,-0.34,-0.66,-0.84,-2.66,-4.44,-5.41,-7.56,-8.78,-6.53,-5.81,-3.22,-0.72,2.78,2.88,3.16,2.38,0.72,-0.59,-0.75,-0.97,0.47,1.97,4.75,6.91,10.66,12.66,14.38,15.34,16.41,14.09,12.78,11.56,9.0,8.38,8.03,8.47,9.5,9.22,9.97,10.03,11.31,11.06,12.28,12.75,12.75,13.81,12.44,12.34,11.78,10.22,8.34,7.28,5.78,4.19,3.16,2.72,1.41,0.28,-0.12,-0.16,-1.28,-2.62,-3.06,-4.03,-3.38,-3.03,-0.97,-0.81,0.75,-0.09,-0.47,-1.47,-2.09,-1.91,-1.06,0.06,1.03,1.28,2.06,3.97,4.59,5.94,7.25,8.03,7.47,7.03,7.06,5.31,5.44,5.12,5.53,6.44,6.5,5.44,5.66,2.75,1.53,2.19,2.12,3.47,5.62,7.06,8.0,8.09,9.06,10.03,12.0,12.88,13.28,12.28,10.5,7.5,5.41,1.84,-0.56,-0.72,-1.81,-3.03,-2.94,-2.62,-1.41,-1.47,-1.28,-1.72,-2.22,-3.88,-7.28,-8.62,-9.62,-10.5,-9.34,-7.16,-4.47,-0.12,2.34,5.28,6.94,6.91,6.41,5.19,4.66,3.56,1.88,0.41,-0.34,-2.16,-2.38,-2.91,-2.19,-1.97,0.78,1.81,3.25,5.06,5.38,6.94,7.34,6.69,8.12,9.25,11.12,13.72,16.28,19.0,21.31,21.62,22.38,22.41,20.91,19.78,18.19,16.12,14.88,13.88,13.56,13.56,13.41,14.41,15.38,15.66,16.75,18.69,18.34,18.78,18.5,17.12,16.25,16.31,14.56,13.16,12.41,10.91,8.41,6.25,3.88,1.31,0.12,-0.88,-1.47,-0.69,0.34,0.44,1.91,1.94,2.44,2.06,2.38,2.41,2.47,3.72,4.53,5.25,7.62,9.19,11.09,13.66,14.56,16.44,15.81,15.06,14.09,11.88,10.38,8.44,6.38,5.53,4.03,2.94,3.19,3.38,3.25,2.56,3.69,3.41,4.44,5.16,6.84,8.75,9.41,10.75,11.28,11.06,10.12,10.0,7.66,4.59,3.59,2.41,1.72,2.41,3.41,4.0,4.44,3.41,2.78,1.88,0.66,0.62,-0.34,-0.69,-0.94,0.44,-0.09,0.81,2.47,3.69,6.12,7.41,9.75,10.41,10.25,10.94,10.31,9.41,10.44,8.44,6.62,4.06,1.88,-0.09,-0.5,-2.44,-1.47,-0.72,-0.34,1.91,3.19,4.09,6.22,6.03,6.03,4.53,3.78,-0.09,0.03,-2.28,-3.06,-3.72,-4.31,-4.16,-5.66,-7.94,-7.59,-8.44,-8.81,-7.97,-7.66,-7.72,-9.09,-9.09,-8.0,-8.34,-5.59,-4.78,-2.94,-0.59,0.09,1.31,2.69,2.28,2.97,2.03,-0.22,-1.75,-3.34,-5.34,-4.97,-4.78,-4.19,-1.16,1.22,2.31,5.06,4.06,3.53,2.78,0.28,-1.22,-3.31,-5.94,-7.69,-9.31,-10.0,-10.16,-8.03,-5.16,-2.91,-0.03,2.81,3.53,3.91,3.41,2.78,0.56,0.0,-0.53,-3.06,-4.97,-3.09,-2.09,0.44,3.78,7.97,8.91,8.12,8.16,7.25,4.91,4.19,-0.06,-1.44,-6.19,-6.31,-7.19,-5.47,-3.09,-1.03,-0.06,-0.34,-0.19,-0.62,-1.66,-0.91,-4.72,-4.84,-6.88,-8.16,-9.44,-9.59,-10.34,-11.03,-9.47,-8.69,-7.34,-5.56,-4.28,-2.91,-3.12,-1.66,-1.69,-0.75,-0.34,-0.75,-0.09,-1.91,-4.25,-6.16,-8.62,-10.53,-11.03,-10.44,-9.03,-7.62,-7.03,-5.25,-4.38,-4.09,-4.03,-3.62,-3.19,-2.91,-2.66,-1.22,-1.97,-0.84,-4.28,-4.72,-6.59,-8.22,-9.53,-10.56,-10.97,-12.97,-14.28,-15.06,-15.56,-15.22,-13.75,-14.22,-13.66,-13.59,-14.59,-14.78,-15.03,-15.25,-16.0,-16.72,-19.41,-21.47,-23.22,-23.66,-25.19,-23.66,-23.0,-21.97,-20.44,-19.66,-19.72,-18.94,-19.59,-19.59,-22.19,-23.91,-24.88,-27.28,-28.47,-26.59,-26.97,-24.94,-23.94,-21.31,-20.81,-19.47,-16.59,-13.84,-12.03,-8.88,-6.34,-4.44,-2.81,-1.28,0.06,0.81,1.88,2.28,2.78,2.34,2.5,1.75,0.06,-1.03,-3.56,-5.16,-4.59,-4.69,-4.47,-3.25,-2.22,-1.09,-0.69,1.09,2.66,3.31,2.56,1.84,0.31,-1.88,-2.72,-4.56,-5.06,-4.97,-5.0,-4.41,-4.03,-3.06,-1.09,-1.81,-1.16,-0.91,-1.91,-2.0,-1.97,-2.44,-2.09,-0.81,-0.69,-1.47,-1.34,-1.34,-1.44,-1.5,-0.34,-0.16,-1.25,-1.41,-2.0,-3.91,-4.59,-5.97,-6.47,-7.56,-8.41,-8.19,-7.94,-8.72,-6.97,-6.56,-5.47,-5.19,-4.25,-3.84,-3.72,-3.34,-2.5,-2.69,-1.91,-3.03,-1.97,-3.94,-4.84,-4.69,-6.41,-6.88,-6.56,-7.28,-5.81,-6.0,-6.41,-6.66,-7.78,-7.09,-7.69,-9.72,-9.03,-10.62,-11.69,-11.22,-11.53,-10.16,-10.72,-9.59,-9.91,-10.03,-8.16,-8.09,-6.78,-6.44,-7.38,-7.81,-9.25,-10.72,-10.78,-10.84,-9.78,-7.0,-5.47,-4.44,-3.31,-3.97,-5.91,-9.75,-12.09,-15.22,-18.97,-50.12,-51.91,-53.12,-53.22,-51.84,-50.47,-48.34,-45.16,-43.03,-42.09,-41.34,-40.91:5.66,3.72,2.28,0.69,-1.5,-3.28,-3.66,-3.59,-3.28,-1.03,-0.09,1.47,2.69,4.12,3.03,2.56,2.62,1.5,3.41,4.19,5.66,6.16,4.72,6.0,4.91,3.28,5.19,3.0,2.12,1.06,-0.41,-0.72,-0.12,1.66,1.94,2.31,3.28,3.56,4.28,4.06,4.97,6.28,4.72,4.94,4.31,1.28,0.03,-2.47,-6.34,-10.5,-12.53,-16.28,-19.69,-21.47,-23.59,-24.94,-25.41,-24.69,-23.47,-20.06,-17.66,-14.75,-11.09,-8.84,-4.91,-1.72,1.38,3.69,4.44,3.62,3.81,2.0,2.25,3.0,3.06,2.5,2.44,2.5,1.25,0.53,0.69,-0.34,-0.47,-2.28,-1.94,-2.53,-1.69,-0.66,1.12,1.31,2.75,2.72,1.69,1.38,-0.69,-2.75,-4.31,-6.25,-8.03,-8.59,-8.72,-8.47,-6.84,-6.75,-5.16,-4.66,-3.69,-3.16,-3.19,-2.81,-2.75,-3.84,-4.59,-3.41,-3.97,-2.91,-3.28,-0.66,0.12,2.0,6.22,8.94,10.88,13.81,14.19,12.56,11.12,8.81,7.62,5.81,4.28,2.03,2.28,1.44,1.41,1.91,1.66,0.31,0.47,-1.34,-2.91,-2.47,-3.38,-4.03,-2.97,-1.78,-0.97,0.16,0.09,-0.41,-0.06,-0.47,0.0,1.75,2.62,3.62,4.22,3.81,4.09,6.25,6.22,6.12,5.94,5.47,6.66,6.56,8.31,10.09,11.56,11.44,9.41,8.88,6.31,4.88,3.03,2.66,2.84,3.31,3.41,4.78,5.41,5.94,6.03,7.47,6.88,6.34,5.28,5.94,3.94,4.0,3.94,3.09,2.47,1.94,1.31,1.44,-0.88,-1.84,-2.31,-3.88,-4.84,-4.53,-4.88,-3.69,-2.56,-1.78,-0.47,-0.97,-1.28,-3.12,-4.34,-6.28,-6.94,-7.16,-6.31,-5.22,-3.47,-2.72,-3.06,-3.28,-3.22,-5.19,-5.34,-5.03,-4.53,-4.25,-2.34,-1.06,-2.22,-0.5,-1.22,-1.31,-1.47,-2.22,-3.31,-3.94,-4.97,-5.84,-6.97,-6.97,-7.16,-7.34,-7.34,-8.06,-8.44,-8.16,-8.56,-8.66,-8.97,-11.47,-12.69,-14.34,-17.06,-17.12,-16.81,-17.84,-17.09,-17.47,-17.78,-18.62,-19.19,-19.09,-19.16,-18.44,-18.84,-17.81,-16.28,-15.84,-14.19,-11.47,-9.03,-6.34,-3.41,-1.22,-0.34,-0.66,-0.84,-2.66,-4.44,-5.41,-7.56,-8.78,-6.53,-5.81,-3.22,-0.72,2.78,2.88,3.16,2.38,0.72,-0.59,-0.75,-0.97,0.47,1.97,4.75,6.91,10.66,12.66,14.38,15.34,16.41,14.09,12.78,11.56,9.0,8.38,8.03,8.47,9.5,9.22,9.97,10.03,11.31,11.06,12.28,12.75,12.75,13.81,12.44,12.34,11.78,10.22,8.34,7.28,5.78,4.19,3.16,2.72,1.41,0.28,-0.12,-0.16,-1.28,-2.62,-3.06,-4.03,-3.38,-3.03,-0.97,-0.81,0.75,-0.09,-0.47,-1.47,-2.09,-1.91,-1.06,0.06,1.03,1.28,2.06,3.97,4.59,5.94,7.25,8.03,7.47,7.03,7.06,5.31,5.44,5.12,5.53,6.44,6.5,5.44,5.66,2.75,1.53,2.19,2.12,3.47,5.62,7.06,8.0,8.09,9.06,10.03,12.0,12.88,13.28,12.28,10.5,7.5,5.41,1.84,-0.56,-0.72,-1.81,-3.03,-2.94,-2.62,-1.41,-1.47,-1.28,-1.72,-2.22,-3.88,-7.28,-8.62,-9.62,-10.5,-9.34,-7.16,-4.47,-0.12,2.34,5.28,6.94,6.91,6.41,5.19,4.66,3.56,1.88,0.41,-0.34,-2.16,-2.38,-2.91,-2.19,-1.97,0.78,1.81,3.25,5.06,5.38,6.94,7.34,6.69,8.12,9.25,11.12,13.72,16.28,19.0,21.31,21.62,22.38,22.41,20.91,19.78,18.19,16.12,14.88,13.88,13.56,13.56,13.41,14.41,15.38,15.66,16.75,18.69,18.34,18.78,18.5,17.12,16.25,16.31,14.56,13.16,12.41,10.91,8.41,6.25,3.88,1.31,0.12,-0.88,-1.47,-0.69,0.34,0.44,1.91,1.94,2.44,2.06,2.38,2.41,2.47,3.72,4.53,5.25,7.62,9.19,11.09,13.66,14.56,16.44,15.81,15.06,14.09,11.88,10.38,8.44,6.38,5.53,4.03,2.94,3.19,3.38,3.25,2.56,3.69,3.41,4.44,5.16,6.84,8.75,9.41,10.75,11.28,11.06,10.12,10.0,7.66,4.59,3.59,2.41,1.72,2.41,3.41,4.0,4.44,3.41,2.78,1.88,0.66,0.62,-0.34,-0.69,-0.94,0.44,-0.09,0.81,2.47,3.69,6.12,7.41,9.75,10.41,10.25,10.94,10.31,9.41,10.44,8.44,6.62,4.06,1.88,-0.09,-0.5,-2.44,-1.47,-0.72,-0.34,1.91,3.19,4.09,6.22,6.03,6.03,4.53,3.78,-0.09,0.03,-2.28,-3.06,-3.72,-4.31,-4.16,-5.66,-7.94,-7.59,-8.44,-8.81,-7.97,-7.66,-7.72,-9.09,-9.09,-8.0,-8.34,-5.59,-4.78,-2.94,-0.59,0.09,1.31,2.69,2.28,2.97,2.03,-0.22,-1.75,-3.34,-5.34,-4.97,-4.78,-4.19,-1.16,1.22,2.31,5.06,4.06,3.53,2.78,0.28,-1.22,-3.31,-5.94,-7.69,-9.31,-10.0,-10.16,-8.03,-5.16,-2.91,-0.03,2.81,3.53,3.91,3.41,2.78,0.56,0.0,-0.53,-3.06,-4.97,-3.09,-2.09,0.44,3.78,7.97,8.91,8.12,8.16,7.25,4.91,4.19,-0.06,-1.44,-6.19,-6.31,-7.19,-5.47,-3.09,-1.03,-0.06,-0.34,-0.19,-0.62,-1.66,-0.91,-4.72,-4.84,-6.88,-8.16,-9.44,-9.59,-10.34,-11.03,-9.47,-8.69,-7.34,-5.56,-4.28,-2.91,-3.12,-1.66,-1.69,-0.75,-0.34,-0.75,-0.09,-1.91,-4.25,-6.16,-8.62,-10.53,-11.03,-10.44,-9.03,-7.62,-7.03,-5.25,-4.38,-4.09,-4.03,-3.62,-3.19,-2.91,-2.66,-1.22,-1.97,-0.84,-4.28,-4.72,-6.59,-8.22,-9.53,-10.56,-10.97,-12.97,-14.28,-15.06,-15.56,-15.22,-13.75,-14.22,-13.66,-13.59,-14.59,-14.78,-15.03,-15.25,-16.0,-16.72,-19.41,-21.47,-23.22,-23.66,-25.19,-23.66,-23.0,-21.97,-20.44,-19.66,-19.72,-18.94,-19.59,-19.59,-22.19,-23.91,-24.88,-27.28,-28.47,-26.59,-26.97,-24.94,-23.94,-21.31,-20.81,-19.47,-16.59,-13.84,-12.03,-8.88,-6.34,-4.44,-2.81,-1.28,0.06,0.81,1.88,2.28,2.78,2.34,2.5,1.75,0.06,-1.03,-3.56,-5.16,-4.59,-4.69,-4.47,-3.25,-2.22,-1.09,-0.69,1.09,2.66,3.31,2.56,1.84,0.31,-1.88,-2.72,-4.56,-5.06,-4.97,-5.0,-4.41,-4.03,-3.06,-1.09,-1.81,-1.16,-0.91,-1.91,-2.0,-1.97,-2.44,-2.09,-0.81,-0.69,-1.47,-1.34,-1.34,-1.44,-1.5,-0.34,-0.16,-1.25,-1.41,-2.0,-3.91,-4.59,-5.97,-6.47,-7.56,-8.41,-8.19,-7.94,-8.72,-6.97,-6.56,-5.47,-5.19,-4.25,-3.84,-3.72,-3.34,-2.5,-2.69,-1.91,-3.03,-1.97,-3.94,-4.84,-4.69,-6.41,-6.88,-6.56,-7.28,-5.81,-6.0,-6.41,-6.66,-7.78,-7.09,-7.69,-9.72,-9.03,-10.62,-11.69,-11.22,-11.53,-10.16,-10.72,-9.59,-9.91,-10.03,-8.16,-8.09,-6.78,-6.44,-7.38,-7.81,-9.25,-10.72,-10.78,-10.84,-9.78,-7.0,-5.47,-4.44,-3.31,-3.97,-5.91,-9.75,-12.09,-15.22,-18.97,-50.12,-51.91,-53.12,-53.22,-51.84,-50.47,-48.34,-45.16,-43.03,-42.09,-41.34,-40.91,-40.12,-40.12,-38.94,-38.5,-38.72,-38.84:-3.66,-3.59,-3.28,-1.03,-0.09,1.47,2.69,4.12,3.03,2.56,2.62,1.5,3.41,4.19,5.66,6.16,4.72,6.0,4.91,3.28,5.19,3.0,2.12,1.06,-0.41,-0.72,-0.12,1.66,1.94,2.31,3.28,3.56,4.28,4.06,4.97,6.28,4.72,4.94,4.31,1.28,0.03,-2.47,-6.34,-10.5,-12.53,-16.28,-19.69,-21.47,-23.59,-24.94,-25.41,-24.69,-23.47,-20.06,-17.66,-14.75,-11.09,-8.84,-4.91,-1.72,1.38,3.69,4.44,3.62,3.81,2.0,2.25,3.0,3.06,2.5,2.44,2.5,1.25,0.53,0.69,-0.34,-0.47,-2.28,-1.94,-2.53,-1.69,-0.66,1.12,1.31,2.75,2.72,1.69,1.38,-0.69,-2.75,-4.31,-6.25,-8.03,-8.59,-8.72,-8.47,-6.84,-6.75,-5.16,-4.66,-3.69,-3.16,-3.19,-2.81,-2.75,-3.84,-4.59,-3.41,-3.97,-2.91,-3.28,-0.66,0.12,2.0,6.22,8.94,10.88,13.81,14.19,12.56,11.12,8.81,7.62,5.81,4.28,2.03,2.28,1.44,1.41,1.91,1.66,0.31,0.47,-1.34,-2.91,-2.47,-3.38,-4.03,-2.97,-1.78,-0.97,0.16,0.09,-0.41,-0.06,-0.47,0.0,1.75,2.62,3.62,4.22,3.81,4.09,6.25,6.22,6.12,5.94,5.47,6.66,6.56,8.31,10.09,11.56,11.44,9.41,8.88,6.31,4.88,3.03,2.66,2.84,3.31,3.41,4.78,5.41,5.94,6.03,7.47,6.88,6.34,5.28,5.94,3.94,4.0,3.94,3.09,2.47,1.94,1.31,1.44,-0.88,-1.84,-2.31,-3.88,-4.84,-4.53,-4.88,-3.69,-2.56,-1.78,-0.47,-0.97,-1.28,-3.12,-4.34,-6.28,-6.94,-7.16,-6.31,-5.22,-3.47,-2.72,-3.06,-3.28,-3.22,-5.19,-5.34,-5.03,-4.53,-4.25,-2.34,-1.06,-2.22,-0.5,-1.22,-1.31,-1.47,-2.22,-3.31,-3.94,-4.97,-5.84,-6.97,-6.97,-7.16,-7.34,-7.34,-8.06,-8.44,-8.16,-8.56,-8.66,-8.97,-11.47,-12.69,-14.34,-17.06,-17.12,-16.81,-17.84,-17.09,-17.47,-17.78,-18.62,-19.19,-19.09,-19.16,-18.44,-18.84,-17.81,-16.28,-15.84,-14.19,-11.47,-9.03,-6.34,-3.41,-1.22,-0.34,-0.66,-0.84,-2.66,-4.44,-5.41,-7.56,-8.78,-6.53,-5.81,-3.22,-0.72,2.78,2.88,3.16,2.38,0.72,-0.59,-0.75,-0.97,0.47,1.97,4.75,6.91,10.66,12.66,14.38,15.34,16.41,14.09,12.78,11.56,9.0,8.38,8.03,8.47,9.5,9.22,9.97,10.03,11.31,11.06,12.28,12.75,12.75,13.81,12.44,12.34,11.78,10.22,8.34,7.28,5.78,4.19,3.16,2.72,1.41,0.28,-0.12,-0.16,-1.28,-2.62,-3.06,-4.03,-3.38,-3.03,-0.97,-0.81,0.75,-0.09,-0.47,-1.47,-2.09,-1.91,-1.06,0.06,1.03,1.28,2.06,3.97,4.59,5.94,7.25,8.03,7.47,7.03,7.06,5.31,5.44,5.12,5.53,6.44,6.5,5.44,5.66,2.75,1.53,2.19,2.12,3.47,5.62,7.06,8.0,8.09,9.06,10.03,12.0,12.88,13.28,12.28,10.5,7.5,5.41,1.84,-0.56,-0.72,-1.81,-3.03,-2.94,-2.62,-1.41,-1.47,-1.28,-1.72,-2.22,-3.88,-7.28,-8.62,-9.62,-10.5,-9.34,-7.16,-4.47,-0.12,2.34,5.28,6.94,6.91,6.41,5.19,4.66,3.56,1.88,0.41,-0.34,-2.16,-2.38,-2.91,-2.19,-1.97,0.78,1.81,3.25,5.06,5.38,6.94,7.34,6.69,8.12,9.25,11.12,13.72,16.28,19.0,21.31,21.62,22.38,22.41,20.91,19.78,18.19,16.12,14.88,13.88,13.56,13.56,13.41,14.41,15.38,15.66,16.75,18.69,18.34,18.78,18.5,17.12,16.25,16.31,14.56,13.16,12.41,10.91,8.41,6.25,3.88,1.31,0.12,-0.88,-1.47,-0.69,0.34,0.44,1.91,1.94,2.44,2.06,2.38,2.41,2.47,3.72,4.53,5.25,7.62,9.19,11.09,13.66,14.56,16.44,15.81,15.06,14.09,11.88,10.38,8.44,6.38,5.53,4.03,2.94,3.19,3.38,3.25,2.56,3.69,3.41,4.44,5.16,6.84,8.75,9.41,10.75,11.28,11.06,10.12,10.0,7.66,4.59,3.59,2.41,1.72,2.41,3.41,4.0,4.44,3.41,2.78,1.88,0.66,0.62,-0.34,-0.69,-0.94,0.44,-0.09,0.81,2.47,3.69,6.12,7.41,9.75,10.41,10.25,10.94,10.31,9.41,10.44,8.44,6.62,4.06,1.88,-0.09,-0.5,-2.44,-1.47,-0.72,-0.34,1.91,3.19,4.09,6.22,6.03,6.03,4.53,3.78,-0.09,0.03,-2.28,-3.06,-3.72,-4.31,-4.16,-5.66,-7.94,-7.59,-8.44,-8.81,-7.97,-7.66,-7.72,-9.09,-9.09,-8.0,-8.34,-5.59,-4.78,-2.94,-0.59,0.09,1.31,2.69,2.28,2.97,2.03,-0.22,-1.75,-3.34,-5.34,-4.97,-4.78,-4.19,-1.16,1.22,2.31,5.06,4.06,3.53,2.78,0.28,-1.22,-3.31,-5.94,-7.69,-9.31,-10.0,-10.16,-8.03,-5.16,-2.91,-0.03,2.81,3.53,3.91,3.41,2.78,0.56,0.0,-0.53,-3.06,-4.97,-3.09,-2.09,0.44,3.78,7.97,8.91,8.12,8.16,7.25,4.91,4.19,-0.06,-1.44,-6.19,-6.31,-7.19,-5.47,-3.09,-1.03,-0.06,-0.34,-0.19,-0.62,-1.66,-0.91,-4.72,-4.84,-6.88,-8.16,-9.44,-9.59,-10.34,-11.03,-9.47,-8.69,-7.34,-5.56,-4.28,-2.91,-3.12,-1.66,-1.69,-0.75,-0.34,-0.75,-0.09,-1.91,-4.25,-6.16,-8.62,-10.53,-11.03,-10.44,-9.03,-7.62,-7.03,-5.25,-4.38,-4.09,-4.03,-3.62,-3.19,-2.91,-2.66,-1.22,-1.97,-0.84,-4.28,-4.72,-6.59,-8.22,-9.53,-10.56,-10.97,-12.97,-14.28,-15.06,-15.56,-15.22,-13.75,-14.22,-13.66,-13.59,-14.59,-14.78,-15.03,-15.25,-16.0,-16.72,-19.41,-21.47,-23.22,-23.66,-25.19,-23.66,-23.0,-21.97,-20.44,-19.66,-19.72,-18.94,-19.59,-19.59,-22.19,-23.91,-24.88,-27.28,-28.47,-26.59,-26.97,-24.94,-23.94,-21.31,-20.81,-19.47,-16.59,-13.84,-12.03,-8.88,-6.34,-4.44,-2.81,-1.28,0.06,0.81,1.88,2.28,2.78,2.34,2.5,1.75,0.06,-1.03,-3.56,-5.16,-4.59,-4.69,-4.47,-3.25,-2.22,-1.09,-0.69,1.09,2.66,3.31,2.56,1.84,0.31,-1.88,-2.72,-4.56,-5.06,-4.97,-5.0,-4.41,-4.03,-3.06,-1.09,-1.81,-1.16,-0.91,-1.91,-2.0,-1.97,-2.44,-2.09,-0.81,-0.69,-1.47,-1.34,-1.34,-1.44,-1.5,-0.34,-0.16,-1.25,-1.41,-2.0,-3.91,-4.59,-5.97,-6.47,-7.56,-8.41,-8.19,-7.94,-8.72,-6.97,-6.56,-5.47,-5.19,-4.25,-3.84,-3.72,-3.34,-2.5,-2.69,-1.91,-3.03,-1.97,-3.94,-4.84,-4.69,-6.41,-6.88,-6.56,-7.28,-5.81,-6.0,-6.41,-6.66,-7.78,-7.09,-7.69,-9.72,-9.03,-10.62,-11.69,-11.22,-11.53,-10.16,-10.72,-9.59,-9.91,-10.03,-8.16,-8.09,-6.78,-6.44,-7.38,-7.81,-9.25,-10.72,-10.78,-10.84,-9.78,-7.0,-5.47,-4.44,-3.31,-3.97,-5.91,-9.75,-12.09,-15.22,-18.97,-50.12,-51.91,-53.12,-53.22,-51.84,-50.47,-48.34,-45.16,-43.03,-42.09,-41.34,-40.91,-40.12,-40.12,-38.94,-38.5,-38.72,-38.84,-40.31,-41.72,-43.78,-44.81,-46.78,-46.31:2.69,4.12,3.03,2.56,2.62,1.5,3.41,4.19,5.66,6.16,4.72,6.0,4.91,3.28,5.19,3.0,2.12,1.06,-0.41,-0.72,-0.12,1.66,1.94,2.31,3.28,3.56,4.28,4.06,4.97,6.28,4.72,4.94,4.31,1.28,0.03,-2.47,-6.34,-10.5,-12.53,-16.28,-19.69,-21.47,-23.59,-24.94,-25.41,-24.69,-23.47,-20.06,-17.66,-14.75,-11.09,-8.84,-4.91,-1.72,1.38,3.69,4.44,3.62,3.81,2.0,2.25,3.0,3.06,2.5,2.44,2.5,1.25,0.53,0.69,-0.34,-0.47,-2.28,-1.94,-2.53,-1.69,-0.66,1.12,1.31,2.75,2.72,1.69,1.38,-0.69,-2.75,-4.31,-6.25,-8.03,-8.59,-8.72,-8.47,-6.84,-6.75,-5.16,-4.66,-3.69,-3.16,-3.19,-2.81,-2.75,-3.84,-4.59,-3.41,-3.97,-2.91,-3.28,-0.66,0.12,2.0,6.22,8.94,10.88,13.81,14.19,12.56,11.12,8.81,7.62,5.81,4.28,2.03,2.28,1.44,1.41,1.91,1.66,0.31,0.47,-1.34,-2.91,-2.47,-3.38,-4.03,-2.97,-1.78,-0.97,0.16,0.09,-0.41,-0.06,-0.47,0.0,1.75,2.62,3.62,4.22,3.81,4.09,6.25,6.22,6.12,5.94,5.47,6.66,6.56,8.31,10.09,11.56,11.44,9.41,8.88,6.31,4.88,3.03,2.66,2.84,3.31,3.41,4.78,5.41,5.94,6.03,7.47,6.88,6.34,5.28,5.94,3.94,4.0,3.94,3.09,2.47,1.94,1.31,1.44,-0.88,-1.84,-2.31,-3.88,-4.84,-4.53,-4.88,-3.69,-2.56,-1.78,-0.47,-0.97,-1.28,-3.12,-4.34,-6.28,-6.94,-7.16,-6.31,-5.22,-3.47,-2.72,-3.06,-3.28,-3.22,-5.19,-5.34,-5.03,-4.53,-4.25,-2.34,-1.06,-2.22,-0.5,-1.22,-1.31,-1.47,-2.22,-3.31,-3.94,-4.97,-5.84,-6.97,-6.97,-7.16,-7.34,-7.34,-8.06,-8.44,-8.16,-8.56,-8.66,-8.97,-11.47,-12.69,-14.34,-17.06,-17.12,-16.81,-17.84,-17.09,-17.47,-17.78,-18.62,-19.19,-19.09,-19.16,-18.44,-18.84,-17.81,-16.28,-15.84,-14.19,-11.47,-9.03,-6.34,-3.41,-1.22,-0.34,-0.66,-0.84,-2.66,-4.44,-5.41,-7.56,-8.78,-6.53,-5.81,-3.22,-0.72,2.78,2.88,3.16,2.38,0.72,-0.59,-0.75,-0.97,0.47,1.97,4.75,6.91,10.66,12.66,14.38,15.34,16.41,14.09,12.78,11.56,9.0,8.38,8.03,8.47,9.5,9.22,9.97,10.03,11.31,11.06,12.28,12.75,12.75,13.81,12.44,12.34,11.78,10.22,8.34,7.28,5.78,4.19,3.16,2.72,1.41,0.28,-0.12,-0.16,-1.28,-2.62,-3.06,-4.03,-3.38,-3.03,-0.97,-0.81,0.75,-0.09,-0.47,-1.47,-2.09,-1.91,-1.06,0.06,1.03,1.28,2.06,3.97,4.59,5.94,7.25,8.03,7.47,7.03,7.06,5.31,5.44,5.12,5.53,6.44,6.5,5.44,5.66,2.75,1.53,2.19,2.12,3.47,5.62,7.06,8.0,8.09,9.06,10.03,12.0,12.88,13.28,12.28,10.5,7.5,5.41,1.84,-0.56,-0.72,-1.81,-3.03,-2.94,-2.62,-1.41,-1.47,-1.28,-1.72,-2.22,-3.88,-7.28,-8.62,-9.62,-10.5,-9.34,-7.16,-4.47,-0.12,2.34,5.28,6.94,6.91,6.41,5.19,4.66,3.56,1.88,0.41,-0.34,-2.16,-2.38,-2.91,-2.19,-1.97,0.78,1.81,3.25,5.06,5.38,6.94,7.34,6.69,8.12,9.25,11.12,13.72,16.28,19.0,21.31,21.62,22.38,22.41,20.91,19.78,18.19,16.12,14.88,13.88,13.56,13.56,13.41,14.41,15.38,15.66,16.75,18.69,18.34,18.78,18.5,17.12,16.25,16.31,14.56,13.16,12.41,10.91,8.41,6.25,3.88,1.31,0.12,-0.88,-1.47,-0.69,0.34,0.44,1.91,1.94,2.44,2.06,2.38,2.41,2.47,3.72,4.53,5.25,7.62,9.19,11.09,13.66,14.56,16.44,15.81,15.06,14.09,11.88,10.38,8.44,6.38,5.53,4.03,2.94,3.19,3.38,3.25,2.56,3.69,3.41,4.44,5.16,6.84,8.75,9.41,10.75,11.28,11.06,10.12,10.0,7.66,4.59,3.59,2.41,1.72,2.41,3.41,4.0,4.44,3.41,2.78,1.88,0.66,0.62,-0.34,-0.69,-0.94,0.44,-0.09,0.81,2.47,3.69,6.12,7.41,9.75,10.41,10.25,10.94,10.31,9.41,10.44,8.44,6.62,4.06,1.88,-0.09,-0.5,-2.44,-1.47,-0.72,-0.34,1.91,3.19,4.09,6.22,6.03,6.03,4.53,3.78,-0.09,0.03,-2.28,-3.06,-3.72,-4.31,-4.16,-5.66,-7.94,-7.59,-8.44,-8.81,-7.97,-7.66,-7.72,-9.09,-9.09,-8.0,-8.34,-5.59,-4.78,-2.94,-0.59,0.09,1.31,2.69,2.28,2.97,2.03,-0.22,-1.75,-3.34,-5.34,-4.97,-4.78,-4.19,-1.16,1.22,2.31,5.06,4.06,3.53,2.78,0.28,-1.22,-3.31,-5.94,-7.69,-9.31,-10.0,-10.16,-8.03,-5.16,-2.91,-0.03,2.81,3.53,3.91,3.41,2.78,0.56,0.0,-0.53,-3.06,-4.97,-3.09,-2.09,0.44,3.78,7.97,8.91,8.12,8.16,7.25,4.91,4.19,-0.06,-1.44,-6.19,-6.31,-7.19,-5.47,-3.09,-1.03,-0.06,-0.34,-0.19,-0.62,-1.66,-0.91,-4.72,-4.84,-6.88,-8.16,-9.44,-9.59,-10.34,-11.03,-9.47,-8.69,-7.34,-5.56,-4.28,-2.91,-3.12,-1.66,-1.69,-0.75,-0.34,-0.75,-0.09,-1.91,-4.25,-6.16,-8.62,-10.53,-11.03,-10.44,-9.03,-7.62,-7.03,-5.25,-4.38,-4.09,-4.03,-3.62,-3.19,-2.91,-2.66,-1.22,-1.97,-0.84,-4.28,-4.72,-6.59,-8.22,-9.53,-10.56,-10.97,-12.97,-14.28,-15.06,-15.56,-15.22,-13.75,-14.22,-13.66,-13.59,-14.59,-14.78,-15.03,-15.25,-16.0,-16.72,-19.41,-21.47,-23.22,-23.66,-25.19,-23.66,-23.0,-21.97,-20.44,-19.66,-19.72,-18.94,-19.59,-19.59,-22.19,-23.91,-24.88,-27.28,-28.47,-26.59,-26.97,-24.94,-23.94,-21.31,-20.81,-19.47,-16.59,-13.84,-12.03,-8.88,-6.34,-4.44,-2.81,-1.28,0.06,0.81,1.88,2.28,2.78,2.34,2.5,1.75,0.06,-1.03,-3.56,-5.16,-4.59,-4.69,-4.47,-3.25,-2.22,-1.09,-0.69,1.09,2.66,3.31,2.56,1.84,0.31,-1.88,-2.72,-4.56,-5.06,-4.97,-5.0,-4.41,-4.03,-3.06,-1.09,-1.81,-1.16,-0.91,-1.91,-2.0,-1.97,-2.44,-2.09,-0.81,-0.69,-1.47,-1.34,-1.34,-1.44,-1.5,-0.34,-0.16,-1.25,-1.41,-2.0,-3.91,-4.59,-5.97,-6.47,-7.56,-8.41,-8.19,-7.94,-8.72,-6.97,-6.56,-5.47,-5.19,-4.25,-3.84,-3.72,-3.34,-2.5,-2.69,-1.91,-3.03,-1.97,-3.94,-4.84,-4.69,-6.41,-6.88,-6.56,-7.28,-5.81,-6.0,-6.41,-6.66,-7.78,-7.09,-7.69,-9.72,-9.03,-10.62,-11.69,-11.22,-11.53,-10.16,-10.72,-9.59,-9.91,-10.03,-8.16,-8.09,-6.78,-6.44,-7.38,-7.81,-9.25,-10.72,-10.78,-10.84,-9.78,-7.0,-5.47,-4.44,-3.31,-3.97,-5.91,-9.75,-12.09,-15.22,-18.97,-50.12,-51.91,-53.12,-53.22,-51.84,-50.47,-48.34,-45.16,-43.03,-42.09,-41.34,-40.91,-40.12,-40.12,-38.94,-38.5,-38.72,-38.84,-40.31,-41.72,-43.78,-44.81,-46.78,-46.31,-46.47,-45.69,-44.34,-42.62,-40.09,-38.31:negativity
19.41,17.56,17.84,18.09,14.88,16.5,14.56,14.53,14.47,15.06,16.44,17.88,19.38,20.81,20.41,23.31,21.69,23.47,24.38,24.94,26.16,26.16,25.47,23.84,19.25,19.31,16.81,14.16,17.03,17.69,18.84,21.28,20.88,21.66,21.53,21.03,21.31,21.44,22.5,23.06,23.75,25.06,25.88,27.56,26.0,25.97,23.34,21.97,17.0,17.78,17.06,18.56,19.25,21.91,23.0,23.25,20.81,24.12,24.94,27.12,29.12,30.44,30.56,27.12,25.22,17.03,18.31,14.34,14.41,15.56,15.19,16.03,14.03,14.31,14.66,15.19,15.31,16.62,16.31,20.09,18.94,21.03,20.41,20.38,21.12,19.53,19.34,19.66,18.31,17.44,20.78,22.53,25.47,29.16,31.84,33.09,33.09,34.75,33.16,31.66,26.81,24.84,23.47,21.38,24.72,24.41,27.22,28.19,30.38,31.38,30.69,30.62,29.34,25.84,27.19,27.66,27.72,28.94,28.19,28.34,28.28,26.0,25.97,29.56,30.53,33.91,36.78,38.16,38.03,36.91,35.5,34.06,32.44,33.38,32.31,33.28,34.78,35.31,35.47,35.34,33.38,31.28,31.94,30.12,31.06,33.41,34.72,35.97,35.72,36.69,35.22,35.44,37.19,35.66,39.97,40.81,44.81,46.44,47.91,47.56,44.88,45.25,41.81,40.22,40.78,39.5,35.44,36.19,32.62,31.56,30.81,31.34,33.31,34.84,37.25,39.62,39.0,40.25,38.19,34.62,33.41,31.16,27.56,26.5,24.5,23.25,21.78,22.06,19.88,22.41,23.5,24.34,25.34,26.62,25.41,25.16,27.31,29.41,32.16,35.81,37.69,40.41,40.06,39.91,41.06,41.34,40.5,40.94,40.78,38.22,38.75,39.56,40.81,41.47,43.47,47.31,48.0,47.25,50.69,49.69,49.53,47.94,45.75,43.94,39.88,37.94,36.25,34.53,31.78,32.53,34.25,35.72,38.53,41.72,43.34,44.81,44.62,40.66,41.25,39.53,37.31,36.66,37.16,37.28,36.0,36.56,35.81,38.06,39.75,41.88,44.84,46.56,48.56,50.25,50.25,49.66,50.5,47.5,45.28,43.44,43.19,42.66,39.69,40.44,37.38,34.31,32.78,28.28,26.56,27.5,27.34,30.5,32.97,35.84,37.03,37.53,36.94,37.69,40.47,40.41,40.59,42.91,43.28,41.56,38.31,40.88,38.81,38.53,38.12,38.28,33.94,33.72,32.97,33.94,36.5,41.0,43.28,45.53,47.56,47.72,46.0,46.25,43.72,42.19,41.28,41.66,39.19,37.25,36.0,35.78,35.75,37.66,42.0,44.06,47.06,48.62,48.94,48.56,46.94,43.53,46.09,44.16,44.78,46.31,45.41,44.19,41.66,39.5,36.59,36.56,36.28,38.28,40.72,44.12,45.44,46.53,46.88,45.12,42.56,44.44,42.97,43.66,43.88,44.31,42.59,41.41,40.44,38.59,36.09,36.56,35.78,37.03,40.34,42.66,45.28,49.62,47.81,50.56,49.59,49.44,49.53,47.44,48.09,47.81,44.81,42.69,40.53,35.5,31.62,28.62,25.0,24.12,21.69,22.0,24.97,28.38,33.88,39.78,43.22,47.12,47.94,46.03,45.94,45.66,42.06,41.06,38.91,35.78,32.72,28.75,27.88,28.19,24.56,30.69,32.19,35.88,38.09,42.44,40.66,43.62,43.81,45.53,47.12,45.47,48.72,47.31,47.25,47.78,49.44,49.91,48.56,49.81,47.91,41.69,42.94,36.0,37.19,35.97,36.94,36.69,35.47,35.81,34.66,34.12,33.34,34.5,34.09,33.38,34.44,35.62,33.78,33.72,31.81,26.81,21.94,19.38,14.91,13.16,11.78,13.91,16.66,19.78,22.22,25.94,27.66,29.72,27.19,30.19,29.31,27.19,28.81,29.06,32.28,34.66,35.62,38.91,40.94,41.31,40.38,40.31,37.94,34.62,32.06,29.75,27.62,23.59,24.41,22.81,21.56,22.88,22.72,21.84,22.06,20.75,19.5,17.12,19.25,19.22,23.75,28.53,32.94,34.5,36.38,35.69,32.56,27.91,27.53,25.56,24.0,24.5,21.59,21.06,19.47,15.66,15.69,15.34,16.66,18.06,19.25,23.75,25.78,25.84,25.91,26.81,27.62,27.34,29.12,30.19,28.25,27.12,24.47,22.12,22.69,22.25,22.59,24.41,26.47,26.59,26.69,24.56,24.69,22.44,22.59,24.31,28.78,32.12,33.75,40.69,43.94,48.31,51.19,53.28,51.31,47.97,42.25,33.91,29.91,24.41,20.31,23.03,23.44,27.31,29.91,30.62,31.53,32.59,30.31,28.62,32.03,29.81,31.06,31.31,33.06,32.81,32.56,31.62,32.31,29.56,30.34,29.34,29.47,30.75,31.44,31.03,31.94,31.56,31.12,30.53,27.38,26.5,26.28,24.31,25.59,26.19,25.06,25.72,26.22,27.53,31.06,32.94,34.62,32.53,32.28,32.62,31.44,30.69,33.34,33.12,31.19,30.88,30.69,30.0,31.75,32.56,34.03,34.53,35.12,33.91,33.47,33.78,32.66,33.09,31.53,35.03,35.72,37.78,40.25,41.41,41.66,41.03,39.59,36.5,36.16,35.28,33.84,31.38,33.16,30.59,29.56,28.59,27.84,28.31,28.81,30.22,32.62,34.5,34.09,38.72,36.81,36.38,36.88,35.88,33.09,32.22,28.81,28.81,29.25,30.34,33.5,35.66,36.12,34.31,33.38,31.5,29.78,28.34,30.16,27.56,30.94,30.28,31.09,31.56,30.62,29.12,26.09,24.44,19.97,21.72,23.56,24.06,28.31,29.16,30.81,31.09,27.81,28.0,27.28,26.0,25.78,26.06,27.41,28.06,28.78,31.31,33.78,34.56,38.03,39.06,39.66,39.81,37.81,38.09,35.44,34.91,34.91,33.44,34.72,36.16,35.69,34.47,32.69,30.31,27.91,26.5,23.38,25.09,23.75,25.47,29.81,31.62,34.06,37.47,38.81,40.0,41.66,42.25,42.69,41.84,40.56,44.0,43.06,45.12,47.56,47.31,46.94,46.66,44.31,42.75,40.41,39.03,39.56,39.31,41.0,42.31,42.53,39.97,38.0,35.44,32.97,31.25,26.03,27.84,25.25,25.69,25.69,26.31,27.31,25.47,25.72,26.62,27.16,26.75,30.91,31.94,34.97,36.34,37.34,36.88,35.56,34.81,34.25,32.28,33.69,33.81,31.19,35.75,34.53,35.38,37.25,36.22,36.22,34.5,34.56,34.72,34.62,36.16,37.19,36.84,33.72,36.22,35.12,34.56,34.38,33.78,32.16,30.5,28.72,27.62,28.12,28.81,27.62,31.16,33.22,34.78,38.34,40.47,41.44,43.16,44.84,46.91,49.09,51.03,53.0,51.56,48.69,43.38,40.94,36.88,33.81,32.5,30.66,30.94,29.25,30.81,31.91,32.41,31.19,32.5,31.84,29.12,31.34,32.41,33.12,32.66,34.34,35.38,34.81,35.72,35.47,33.06,30.12,31.62,29.47,30.22,30.84,29.72,29.19,28.25,26.44,26.44,24.94,27.22,25.5,27.38,27.22,28.91,30.16,32.19,33.38,34.28,34.06,32.25,30.5,28.28,27.22,27.31,28.88,30.62,32.62,33.81,33.91,33.41,33.34,32.38,30.12,28.84,25.06,25.16,23.53,22.59,22.66,24.69,25.75,26.81,27.44,29.56,29.41,29.44,28.53,28.44,28.88,26.72,28.88,27.69,26.31,26.53,25.0,22.81,22.31,21.19,20.0,19.97,18.91,16.81,16.66,15.78,17.0,16.81,18.59,18.41,18.5,17.56,15.53,15.53,14.81,14.56:14.56,14.53,14.47,15.06,16.44,17.88,19.38,20.81,20.41,23.31,21.69,23.47,24.38,24.94,26.16,26.16,25.47,23.84,19.25,19.31,16.81,14.16,17.03,17.69,18.84,21.28,20.88,21.66,21.53,21.03,21.31,21.44,22.5,23.06,23.75,25.06,25.88,27.56,26.0,25.97,23.34,21.97,17.0,17.78,17.06,18.56,19.25,21.91,23.0,23.25,20.81,24.12,24.94,27.12,29.12,30.44,30.56,27.12,25.22,17.03,18.31,14.34,14.41,15.56,15.19,16.03,14.03,14.31,14.66,15.19,15.31,16.62,16.31,20.09,18.94,21.03,20.41,20.38,21.12,19.53,19.34,19.66,18.31,17.44,20.78,22.53,25.47,29.16,31.84,33.09,33.09,34.75,33.16,31.66,26.81,24.84,23.47,21.38,24.72,24.41,27.22,28.19,30.38,31.38,30.69,30.62,29.34,25.84,27.19,27.66,27.72,28.94,28.19,28.34,28.28,26.0,25.97,29.56,30.53,33.91,36.78,38.16,38.03,36.91,35.5,34.06,32.44,33.38,32.31,33.28,34.78,35.31,35.47,35.34,33.38,31.28,31.94,30.12,31.06,33.41,34.72,35.97,35.72,36.69,35.22,35.44,37.19,35.66,39.97,40.81,44.81,46.44,47.91,47.56,44.88,45.25,41.81,40.22,40.78,39.5,35.44,36.19,32.62,31.56,30.81,31.34,33.31,34.84,37.25,39.62,39.0,40.25,38.19,34.62,33.41,31.16,27.56,26.5,24.5,23.25,21.78,22.06,19.88,22.41,23.5,24.34,25.34,26.62,25.41,25.16,27.31,29.41,32.16,35.81,37.69,40.41,40.06,39.91,41.06,41.34,40.5,40.94,40.78,38.22,38.75,39.56,40.81,41.47,43.47,47.31,48.0,47.25,50.69,49.69,49.53,47.94,45.75,43.94,39.88,37.94,36.25,34.53,31.78,32.53,34.25,35.72,38.53,41.72,43.34,44.81,44.62,40.66,41.25,39.53,37.31,36.66,37.16,37.28,36.0,36.56,35.81,38.06,39.75,41.88,44.84,46.56,48.56,50.25,50.25,49.66,50.5,47.5,45.28,43.44,43.19,42.66,39.69,40.44,37.38,34.31,32.78,28.28,26.56,27.5,27.34,30.5,32.97,35.84,37.03,37.53,36.94,37.69,40.47,40.41,40.59,42.91,43.28,41.56,38.31,40.88,38.81,38.53,38.12,38.28,33.94,33.72,32.97,33.94,36.5,41.0,43.28,45.53,47.56,47.72,46.0,46.25,43.72,42.19,41.28,41.66,39.19,37.25,36.0,35.78,35.75,37.66,42.0,44.06,47.06,48.62,48.94,48.56,46.94,43.53,46.09,44.16,44.78,46.31,45.41,44.19,41.66,39.5,36.59,36.56,36.28,38.28,40.72,44.12,45.44,46.53,46.88,45.12,42.56,44.44,42.97,43.66,43.88,44.31,42.59,41.41,40.44,38.59,36.09,36.56,35.78,37.03,40.34,42.66,45.28,49.62,47.81,50.56,49.59,49.44,49.53,47.44,48.09,47.81,44.81,42.69,40.53,35.5,31.62,28.62,25.0,24.12,21.69,22.0,24.97,28.38,33.88,39.78,43.22,47.12,47.94,46.03,45.94,45.66,42.06,41.06,38.91,35.78,32.72,28.75,27.88,28.19,24.56,30.69,32.19,35.88,38.09,42.44,40.66,43.62,43.81,45.53,47.12,45.47,48.72,47.31,47.25,47.78,49.44,49.91,48.56,49.81,47.91,41.69,42.94,36.0,37.19,35.97,36.94,36.69,35.47,35.81,34.66,34.12,33.34,34.5,34.09,33.38,34.44,35.62,33.78,33.72,31.81,26.81,21.94,19.38,14.91,13.16,11.78,13.91,16.66,19.78,22.22,25.94,27.66,29.72,27.19,30.19,29.31,27.19,28.81,29.06,32.28,34.66,35.62,38.91,40.94,41.31,40.38,40.31,37.94,34.62,32.06,29.75,27.62,23.59,24.41,22.81,21.56,22.88,22.72,21.84,22.06,20.75,19.5,17.12,19.25,19.22,23.75,28.53,32.94,34.5,36.38,35.69,32.56,27.91,27.53,25.56,24.0,24.5,21.59,21.06,19.47,15.66,15.69,15.34,16.66,18.06,19.25,23.75,25.78,25.84,25.91,26.81,27.62,27.34,29.12,30.19,28.25,27.12,24.47,22.12,22.69,22.25,22.59,24.41,26.47,26.59,26.69,24.56,24.69,22.44,22.59,24.31,28.78,32.12,33.75,40.69,43.94,48.31,51.19,53.28,51.31,47.97,42.25,33.91,29.91,24.41,20.31,23.03,23.44,27.31,29.91,30.62,31.53,32.59,30.31,28.62,32.03,29.81,31.06,31.31,33.06,32.81,32.56,31.62,32.31,29.56,30.34,29.34,29.47,30.75,31.44,31.03,31.94,31.56,31.12,30.53,27.38,26.5,26.28,24.31,25.59,26.19,25.06,25.72,26.22,27.53,31.06,32.94,34.62,32.53,32.28,32.62,31.44,30.69,33.34,33.12,31.19,30.88,30.69,30.0,31.75,32.56,34.03,34.53,35.12,33.91,33.47,33.78,32.66,33.09,31.53,35.03,35.72,37.78,40.25,41.41,41.66,41.03,39.59,36.5,36.16,35.28,33.84,31.38,33.16,30.59,29.56,28.59,27.84,28.31,28.81,30.22,32.62,34.5,34.09,38.72,36.81,36.38,36.88,35.88,33.09,32.22,28.81,28.81,29.25,30.34,33.5,35.66,36.12,34.31,33.38,31.5,29.78,28.34,30.16,27.56,30.94,30.28,31.09,31.56,30.62,29.12,26.09,24.44,19.97,21.72,23.56,24.06,28.31,29.16,30.81,31.09,27.81,28.0,27.28,26.0,25.78,26.06,27.41,28.06,28.78,31.31,33.78,34.56,38.03,39.06,39.66,39.81,37.81,38.09,35.44,34.91,34.91,33.44,34.72,36.16,35.69,34.47,32.69,30.31,27.91,26.5,23.38,25.09,23.75,25.47,29.81,31.62,34.06,37.47,38.81,40.0,41.66,42.25,42.69,41.84,40.56,44.0,43.06,45.12,47.56,47.31,46.94,46.66,44.31,42.75,40.41,39.03,39.56,39.31,41.0,42.31,42.53,39.97,38.0,35.44,32.97,31.25,26.03,27.84,25.25,25.69,25.69,26.31,27.31,25.47,25.72,26.62,27.16,26.75,30.91,31.94,34.97,36.34,37.34,36.88,35.56,34.81,34.25,32.28,33.69,33.81,31.19,35.75,34.53,35.38,37.25,36.22,36.22,34.5,34.56,34.72,34.62,36.16,37.19,36.84,33.72,36.22,35.12,34.56,34.38,33.78,32.16,30.5,28.72,27.62,28.12,28.81,27.62,31.16,33.22,34.78,38.34,40.47,41.44,43.16,44.84,46.91,49.09,51.03,53.0,51.56,48.69,43.38,40.94,36.88,33.81,32.5,30.66,30.94,29.25,30.81,31.91,32.41,31.19,32.5,31.84,29.12,31.34,32.41,33.12,32.66,34.34,35.38,34.81,35.72,35.47,33.06,30.12,31.62,29.47,30.22,30.84,29.72,29.19,28.25,26.44,26.44,24.94,27.22,25.5,27.38,27.22,28.91,30.16,32.19,33.38,34.28,34.06,32.25,30.5,28.28,27.22,27.31,28.88,30.62,32.62,33.81,33.91,33.41,33.34,32.38,30.12,28.84,25.06,25.16,23.53,22.59,22.66,24.69,25.75,26.81,27.44,29.56,29.41,29.44,28.53,28.44,28.88,26.72,28.88,27.69,26.31,26.53,25.0,22.81,22.31,21.19,20.0,19.97,18.91,16.81,16.66,15.78,17.0,16.81,18.59,18.41,18.5,17.56,15.53,15.53,14.81,14.56,-24.91,-25.56,-26.03,-24.38,-24.47,-24.88:19.38,20.81,20.41,23.31,21.69,23.47,24.38,24.94,26.16,26.16,25.47,23.84,19.25,19.31,16.81,14.16,17.03,17.69,18.84,21.28,20.88,21.66,21.53,21.03,21.31,21.44,22.5,23.06,23.75,25.06,25.88,27.56,26.0,25.97,23.34,21.97,17.0,17.78,17.06,18.56,19.25,21.91,23.0,23.25,20.81,24.12,24.94,27.12,29.12,30.44,30.56,27.12,25.22,17.03,18.31,14.34,14.41,15.56,15.19,16.03,14.03,14.31,14.66,15.19,15.31,16.62,16.31,20.09,18.94,21.03,20.41,20.38,21.12,19.53,19.34,19.66,18.31,17.44,20.78,22.53,25.47,29.16,31.84,33.09,33.09,34.75,33.16,31.66,26.81,24.84,23.47,21.38,24.72,24.41,27.22,28.19,30.38,31.38,30.69,30.62,29.34,25.84,27.19,27.66,27.72,28.94,28.19,28.34,28.28,26.0,25.97,29.56,30.53,33.91,36.78,38.16,38.03,36.91,35.5,34.06,32.44,33.38,32.31,33.28,34.78,35.31,35.47,35.34,33.38,31.28,31.94,30.12,31.06,33.41,34.72,35.97,35.72,36.69,35.22,35.44,37.19,35.66,39.97,40.81,44.81,46.44,47.91,47.56,44.88,45.25,41.81,40.22,40.78,39.5,35.44,36.19,32.62,31.56,30.81,31.34,33.31,34.84,37.25,39.62,39.0,40.25,38.19,34.62,33.41,31.16,27.56,26.5,24.5,23.25,21.78,22.06,19.88,22.41,23.5,24.34,25.34,26.62,25.41,25.16,27.31,29.41,32.16,35.81,37.69,40.41,40.06,39.91,41.06,41.34,40.5,40.94,40.78,38.22,38.75,39.56,40.81,41.47,43.47,47.31,48.0,47.25,50.69,49.69,49.53,47.94,45.75,43.94,39.88,37.94,36.25,34.53,31.78,32.53,34.25,35.72,38.53,41.72,43.34,44.81,44.62,40.66,41.25,39.53,37.31,36.66,37.16,37.28,36.0,36.56,35.81,38.06,39.75,41.88,44.84,46.56,48.56,50.25,50.25,49.66,50.5,47.5,45.28,43.44,43.19,42.66,39.69,40.44,37.38,34.31,32.78,28.28,26.56,27.5,27.34,30.5,32.97,35.84,37.03,37.53,36.94,37.69,40.47,40.41,40.59,42.91,43.28,41.56,38.31,40.88,38.81,38.53,38.12,38.28,33.94,33.72,32.97,33.94,36.5,41.0,43.28,45.53,47.56,47.72,46.0,46.25,43.72,42.19,41.28,41.66,39.19,37.25,36.0,35.78,35.75,37.66,42.0,44.06,47.06,48.62,48.94,48.56,46.94,43.53,46.09,44.16,44.78,46.31,45.41,44.19,41.66,39.5,36.59,36.56,36.28,38.28,40.72,44.12,45.44,46.53,46.88,45.12,42.56,44.44,42.97,43.66,43.88,44.31,42.59,41.41,40.44,38.59,36.09,36.56,35.78,37.03,40.34,42.66,45.28,49.62,47.81,50.56,49.59,49.44,49.53,47.44,48.09,47.81,44.81,42.69,40.53,35.5,31.62,28.62,25.0,24.12,21.69,22.0,24.97,28.38,33.88,39.78,43.22,47.12,47.94,46.03,45.94,45.66,42.06,41.06,38.91,35.78,32.72,28.75,27.88,28.19,24.56,30.69,32.19,35.88,38.09,42.44,40.66,43.62,43.81,45.53,47.12,45.47,48.72,47.31,47.25,47.78,49.44,49.91,48.56,49.81,47.91,41.69,42.94,36.0,37.19,35.97,36.94,36.69,35.47,35.81,34.66,34.12,33.34,34.5,34.09,33.38,34.44,35.62,33.78,33.72,31.81,26.81,21.94,19.38,14.91,13.16,11.78,13.91,16.66,19.78,22.22,25.94,27.66,29.72,27.19,30.19,29.31,27.19,28.81,29.06,32.28,34.66,35.62,38.91,40.94,41.31,40.38,40.31,37.94,34.62,32.06,29.75,27.62,23.59,24.41,22.81,21.56,22.88,22.72,21.84,22.06,20.75,19.5,17.12,19.25,19.22,23.75,28.53,32.94,34.5,36.38,35.69,32.56,27.91,27.53,25.56,24.0,24.5,21.59,21.06,19.47,15.66,15.69,15.34,16.66,18.06,19.25,23.75,25.78,25.84,25.91,26.81,27.62,27.34,29.12,30.19,28.25,27.12,24.47,22.12,22.69,22.25,22.59,24.41,26.47,26.59,26.69,24.56,24.69,22.44,22.59,24.31,28.78,32.12,33.75,40.69,43.94,48.31,51.19,53.28,51.31,47.97,42.25,33.91,29.91,24.41,20.31,23.03,23.44,27.31,29.91,30.62,31.53,32.59,30.31,28.62,32.03,29.81,31.06,31.31,33.06,32.81,32.56,31.62,32.31,29.56,30.34,29.34,29.47,30.75,31.44,31.03,31.94,31.56,31.12,30.53,27.38,26.5,26.28,24.31,25.59,26.19,25.06,25.72,26.22,27.53,31.06,32.94,34.62,32.53,32.28,32.62,31.44,30.69,33.34,33.12,31.19,30.88,30.69,30.0,31.75,32.56,34.03,34.53,35.12,33.91,33.47,33.78,32.66,33.09,31.53,35.03,35.72,37.78,40.25,41.41,41.66,41.03,39.59,36.5,36.16,35.28,33.84,31.38,33.16,30.59,29.56,28.59,27.84,28.31,28.81,30.22,32.62,34.5,34.09,38.72,36.81,36.38,36.88,35.88,33.09,32.22,28.81,28.81,29.25,30.34,33.5,35.66,36.12,34.31,33.38,31.5,29.78,28.34,30.16,27.56,30.94,30.28,31.09,31.56,30.62,29.12,26.09,24.44,19.97,21.72,23.56,24.06,28.31,29.16,30.81,31.09,27.81,28.0,27.28,26.0,25.78,26.06,27.41,28.06,28.78,31.31,33.78,34.56,38.03,39.06,39.66,39.81,37.81,38.09,35.44,34.91,34.91,33.44,34.72,36.16,35.69,34.47,32.69,30.31,27.91,26.5,23.38,25.09,23.75,25.47,29.81,31.62,34.06,37.47,38.81,40.0,41.66,42.25,42.69,41.84,40.56,44.0,43.06,45.12,47.56,47.31,46.94,46.66,44.31,42.75,40.41,39.03,39.56,39.31,41.0,42.31,42.53,39.97,38.0,35.44,32.97,31.25,26.03,27.84,25.25,25.69,25.69,26.31,27.31,25.47,25.72,26.62,27.16,26.75,30.91,31.94,34.97,36.34,37.34,36.88,35.56,34.81,34.25,32.28,33.69,33.81,31.19,35.75,34.53,35.38,37.25,36.22,36.22,34.5,34.56,34.72,34.62,36.16,37.19,36.84,33.72,36.22,35.12,34.56,34.38,33.78,32.16,30.5,28.72,27.62,28.12,28.81,27.62,31.16,33.22,34.78,38.34,40.47,41.44,43.16,44.84,46.91,49.09,51.03,53.0,51.56,48.69,43.38,40.94,36.88,33.81,32.5,30.66,30.94,29.25,30.81,31.91,32.41,31.19,32.5,31.84,29.12,31.34,32.41,33.12,32.66,34.34,35.38,34.81,35.72,35.47,33.06,30.12,31.62,29.47,30.22,30.84,29.72,29.19,28.25,26.44,26.44,24.94,27.22,25.5,27.38,27.22,28.91,30.16,32.19,33.38,34.28,34.06,32.25,30.5,28.28,27.22,27.31,28.88,30.62,32.62,33.81,33.91,33.41,33.34,32.38,30.12,28.84,25.06,25.16,23.53,22.59,22.66,24.69,25.75,26.81,27.44,29.56,29.41,29.44,28.53,28.44,28.88,26.72,28.88,27.69,26.31,26.53,25.0,22.81,22.31,21.19,20.0,19.97,18.91,16.81,16.66,15.78,17.0,16.81,18.59,18.41,18.5,17.56,15.53,15.53,14.81,14.56,-24.91,-25.56,-26.03,-24.38,-24.47,-24.88,-24.09,-23.84,-24.84,-24.44,-23.69,-22.81:24.38,24.94,26.16,26.16,25.47,23.84,19.25,19.31,16.81,14.16,17.03,17.69,18.84,21.28,20.88,21.66,21.53,21.03,21.31,21.44,22.5,23.06,23.75,25.06,25.88,27.56,26.0,25.97,23.34,21.97,17.0,17.78,17.06,18.56,19.25,21.91,23.0,23.25,20.81,24.12,24.94,27.12,29.12,30.44,30.56,27.12,25.22,17.03,18.31,14.34,14.41,15.56,15.19,16.03,14.03,14.31,14.66,15.19,15.31,16.62,16.31,20.09,18.94,21.03,20.41,20.38,21.12,19.53,19.34,19.66,18.31,17.44,20.78,22.53,25.47,29.16,31.84,33.09,33.09,34.75,33.16,31.66,26.81,24.84,23.47,21.38,24.72,24.41,27.22,28.19,30.38,31.38,30.69,30.62,29.34,25.84,27.19,27.66,27.72,28.94,28.19,28.34,28.28,26.0,25.97,29.56,30.53,33.91,36.78,38.16,38.03,36.91,35.5,34.06,32.44,33.38,32.31,33.28,34.78,35.31,35.47,35.34,33.38,31.28,31.94,30.12,31.06,33.41,34.72,35.97,35.72,36.69,35.22,35.44,37.19,35.66,39.97,40.81,44.81,46.44,47.91,47.56,44.88,45.25,41.81,40.22,40.78,39.5,35.44,36.19,32.62,31.56,30.81,31.34,33.31,34.84,37.25,39.62,39.0,40.25,38.19,34.62,33.41,31.16,27.56,26.5,24.5,23.25,21.78,22.06,19.88,22.41,23.5,24.34,25.34,26.62,25.41,25.16,27.31,29.41,32.16,35.81,37.69,40.41,40.06,39.91,41.06,41.34,40.5,40.94,40.78,38.22,38.75,39.56,40.81,41.47,43.47,47.31,48.0,47.25,50.69,49.69,49.53,47.94,45.75,43.94,39.88,37.94,36.25,34.53,31.78,32.53,34.25,35.72,38.53,41.72,43.34,44.81,44.62,40.66,41.25,39.53,37.31,36.66,37.16,37.28,36.0,36.56,35.81,38.06,39.75,41.88,44.84,46.56,48.56,50.25,50.25,49.66,50.5,47.5,45.28,43.44,43.19,42.66,39.69,40.44,37.38,34.31,32.78,28.28,26.56,27.5,27.34,30.5,32.97,35.84,37.03,37.53,36.94,37.69,40.47,40.41,40.59,42.91,43.28,41.56,38.31,40.88,38.81,38.53,38.12,38.28,33.94,33.72,32.97,33.94,36.5,41.0,43.28,45.53,47.56,47.72,46.0,46.25,43.72,42.19,41.28,41.66,39.19,37.25,36.0,35.78,35.75,37.66,42.0,44.06,47.06,48.62,48.94,48.56,46.94,43.53,46.09,44.16,44.78,46.31,45.41,44.19,41.66,39.5,36.59,36.56,36.28,38.28,40.72,44.12,45.44,46.53,46.88,45.12,42.56,44.44,42.97,43.66,43.88,44.31,42.59,41.41,40.44,38.59,36.09,36.56,35.78,37.03,40.34,42.66,45.28,49.62,47.81,50.56,49.59,49.44,49.53,47.44,48.09,47.81,44.81,42.69,40.53,35.5,31.62,28.62,25.0,24.12,21.69,22.0,24.97,28.38,33.88,39.78,43.22,47.12,47.94,46.03,45.94,45.66,42.06,41.06,38.91,35.78,32.72,28.75,27.88,28.19,24.56,30.69,32.19,35.88,38.09,42.44,40.66,43.62,43.81,45.53,47.12,45.47,48.72,47.31,47.25,47.78,49.44,49.91,48.56,49.81,47.91,41.69,42.94,36.0,37.19,35.97,36.94,36.69,35.47,35.81,34.66,34.12,33.34,34.5,34.09,33.38,34.44,35.62,33.78,33.72,31.81,26.81,21.94,19.38,14.91,13.16,11.78,13.91,16.66,19.78,22.22,25.94,27.66,29.72,27.19,30.19,29.31,27.19,28.81,29.06,32.28,34.66,35.62,38.91,40.94,41.31,40.38,40.31,37.94,34.62,32.06,29.75,27.62,23.59,24.41,22.81,21.56,22.88,22.72,21.84,22.06,20.75,19.5,17.12,19.25,19.22,23.75,28.53,32.94,34.5,36.38,35.69,32.56,27.91,27.53,25.56,24.0,24.5,21.59,21.06,19.47,15.66,15.69,15.34,16.66,18.06,19.25,23.75,25.78,25.84,25.91,26.81,27.62,27.34,29.12,30.19,28.25,27.12,24.47,22.12,22.69,22.25,22.59,24.41,26.47,26.59,26.69,24.56,24.69,22.44,22.59,24.31,28.78,32.12,33.75,40.69,43.94,48.31,51.19,53.28,51.31,47.97,42.25,33.91,29.91,24.41,20.31,23.03,23.44,27.31,29.91,30.62,31.53,32.59,30.31,28.62,32.03,29.81,31.06,31.31,33.06,32.81,32.56,31.62,32.31,29.56,30.34,29.34,29.47,30.75,31.44,31.03,31.94,31.56,31.12,30.53,27.38,26.5,26.28,24.31,25.59,26.19,25.06,25.72,26.22,27.53,31.06,32.94,34.62,32.53,32.28,32.62,31.44,30.69,33.34,33.12,31.19,30.88,30.69,30.0,31.75,32.56,34.03,34.53,35.12,33.91,33.47,33.78,32.66,33.09,31.53,35.03,35.72,37.78,40.25,41.41,41.66,41.03,39.59,36.5,36.16,35.28,33.84,31.38,33.16,30.59,29.56,28.59,27.84,28.31,28.81,30.22,32.62,34.5,34.09,38.72,36.81,36.38,36.88,35.88,33.09,32.22,28.81,28.81,29.25,30.34,33.5,35.66,36.12,34.31,33.38,31.5,29.78,28.34,30.16,27.56,30.94,30.28,31.09,31.56,30.62,29.12,26.09,24.44,19.97,21.72,23.56,24.06,28.31,29.16,30.81,31.09,27.81,28.0,27.28,26.0,25.78,26.06,27.41,28.06,28.78,31.31,33.78,34.56,38.03,39.06,39.66,39.81,37.81,38.09,35.44,34.91,34.91,33.44,34.72,36.16,35.69,34.47,32.69,30.31,27.91,26.5,23.38,25.09,23.75,25.47,29.81,31.62,34.06,37.47,38.81,40.0,41.66,42.25,42.69,41.84,40.56,44.0,43.06,45.12,47.56,47.31,46.94,46.66,44.31,42.75,40.41,39.03,39.56,39.31,41.0,42.31,42.53,39.97,38.0,35.44,32.97,31.25,26.03,27.84,25.25,25.69,25.69,26.31,27.31,25.47,25.72,26.62,27.16,26.75,30.91,31.94,34.97,36.34,37.34,36.88,35.56,34.81,34.25,32.28,33.69,33.81,31.19,35.75,34.53,35.38,37.25,36.22,36.22,34.5,34.56,34.72,34.62,36.16,37.19,36.84,33.72,36.22,35.12,34.56,34.38,33.78,32.16,30.5,28.72,27.62,28.12,28.81,27.62,31.16,33.22,34.78,38.34,40.47,41.44,43.16,44.84,46.91,49.09,51.03,53.0,51.56,48.69,43.38,40.94,36.88,33.81,32.5,30.66,30.94,29.25,30.81,31.91,32.41,31.19,32.5,31.84,29.12,31.34,32.41,33.12,32.66,34.34,35.38,34.81,35.72,35.47,33.06,30.12,31.62,29.47,30.22,30.84,29.72,29.19,28.25,26.44,26.44,24.94,27.22,25.5,27.38,27.22,28.91,30.16,32.19,33.38,34.28,34.06,32.25,30.5,28.28,27.22,27.31,28.88,30.62,32.62,33.81,33.91,33.41,33.34,32.38,30.12,28.84,25.06,25.16,23.53,22.59,22.66,24.69,25.75,26.81,27.44,29.56,29.41,29.44,28.53,28.44,28.88,26.72,28.88,27.69,26.31,26.53,25.0,22.81,22.31,21.19,20.0,19.97,18.91,16.81,16.66,15.78,17.0,16.81,18.59,18.41,18.5,17.56,15.53,15.53,14.81,14.56,-24.91,-25.56,-26.03,-24.38,-24.47,-24.88,-24.09,-23.84,-24.84,-24.44,-23.69,-22.81,-22.22,-20.03,-20.91,-19.94,-17.59,-16.38:19.25,19.31,16.81,14.16,17.03,17.69,18.84,21.28,20.88,21.66,21.53,21.03,21.31,21.44,22.5,23.06,23.75,25.06,25.88,27.56,26.0,25.97,23.34,21.97,17.0,17.78,17.06,18.56,19.25,21.91,23.0,23.25,20.81,24.12,24.94,27.12,29.12,30.44,30.56,27.12,25.22,17.03,18.31,14.34,14.41,15.56,15.19,16.03,14.03,14.31,14.66,15.19,15.31,16.62,16.31,20.09,18.94,21.03,20.41,20.38,21.12,19.53,19.34,19.66,18.31,17.44,20.78,22.53,25.47,29.16,31.84,33.09,33.09,34.75,33.16,31.66,26.81,24.84,23.47,21.38,24.72,24.41,27.22,28.19,30.38,31.38,30.69,30.62,29.34,25.84,27.19,27.66,27.72,28.94,28.19,28.34,28.28,26.0,25.97,29.56,30.53,33.91,36.78,38.16,38.03,36.91,35.5,34.06,32.44,33.38,32.31,33.28,34.78,35.31,35.47,35.34,33.38,31.28,31.94,30.12,31.06,33.41,34.72,35.97,35.72,36.69,35.22,35.44,37.19,35.66,39.97,40.81,44.81,46.44,47.91,47.56,44.88,45.25,41.81,40.22,40.78,39.5,35.44,36.19,32.62,31.56,30.81,31.34,33.31,34.84,37.25,39.62,39.0,40.25,38.19,34.62,33.41,31.16,27.56,26.5,24.5,23.25,21.78,22.06,19.88,22.41,23.5,24.34,25.34,26.62,25.41,25.16,27.31,29.41,32.16,35.81,37.69,40.41,40.06,39.91,41.06,41.34,40.5,40.94,40.78,38.22,38.75,39.56,40.81,41.47,43.47,47.31,48.0,47.25,50.69,49.69,49.53,47.94,45.75,43.94,39.88,37.94,36.25,34.53,31.78,32.53,34.25,35.72,38.53,41.72,43.34,44.81,44.62,40.66,41.25,39.53,37.31,36.66,37.16,37.28,36.0,36.56,35.81,38.06,39.75,41.88,44.84,46.56,48.56,50.25,50.25,49.66,50.5,47.5,45.28,43.44,43.19,42.66,39.69,40.44,37.38,34.31,32.78,28.28,26.56,27.5,27.34,30.5,32.97,35.84,37.03,37.53,36.94,37.69,40.47,40.41,40.59,42.91,43.28,41.56,38.31,40.88,38.81,38.53,38.12,38.28,33.94,33.72,32.97,33.94,36.5,41.0,43.28,45.53,47.56,47.72,46.0,46.25,43.72,42.19,41.28,41.66,39.19,37.25,36.0,35.78,35.75,37.66,42.0,44.06,47.06,48.62,48.94,48.56,46.94,43.53,46.09,44.16,44.78,46.31,45.41,44.19,41.66,39.5,36.59,36.56,36.28,38.28,40.72,44.12,45.44,46.53,46.88,45.12,42.56,44.44,42.97,43.66,43.88,44.31,42.59,41.41,40.44,38.59,36.09,36.56,35.78,37.03,40.34,42.66,45.28,49.62,47.81,50.56,49.59,49.44,49.53,47.44,48.09,47.81,44.81,42.69,40.53,35.5,31.62,28.62,25.0,24.12,21.69,22.0,24.97,28.38,33.88,39.78,43.22,47.12,47.94,46.03,45.94,45.66,42.06,41.06,38.91,35.78,32.72,28.75,27.88,28.19,24.56,30.69,32.19,35.88,38.09,42.44,40.66,43.62,43.81,45.53,47.12,45.47,48.72,47.31,47.25,47.78,49.44,49.91,48.56,49.81,47.91,41.69,42.94,36.0,37.19,35.97,36.94,36.69,35.47,35.81,34.66,34.12,33.34,34.5,34.09,33.38,34.44,35.62,33.78,33.72,31.81,26.81,21.94,19.38,14.91,13.16,11.78,13.91,16.66,19.78,22.22,25.94,27.66,29.72,27.19,30.19,29.31,27.19,28.81,29.06,32.28,34.66,35.62,38.91,40.94,41.31,40.38,40.31,37.94,34.62,32.06,29.75,27.62,23.59,24.41,22.81,21.56,22.88,22.72,21.84,22.06,20.75,19.5,17.12,19.25,19.22,23.75,28.53,32.94,34.5,36.38,35.69,32.56,27.91,27.53,25.56,24.0,24.5,21.59,21.06,19.47,15.66,15.69,15.34,16.66,18.06,19.25,23.75,25.78,25.84,25.91,26.81,27.62,27.34,29.12,30.19,28.25,27.12,24.47,22.12,22.69,22.25,22.59,24.41,26.47,26.59,26.69,24.56,24.69,22.44,22.59,24.31,28.78,32.12,33.75,40.69,43.94,48.31,51.19,53.28,51.31,47.97,42.25,33.91,29.91,24.41,20.31,23.03,23.44,27.31,29.91,30.62,31.53,32.59,30.31,28.62,32.03,29.81,31.06,31.31,33.06,32.81,32.56,31.62,32.31,29.56,30.34,29.34,29.47,30.75,31.44,31.03,31.94,31.56,31.12,30.53,27.38,26.5,26.28,24.31,25.59,26.19,25.06,25.72,26.22,27.53,31.06,32.94,34.62,32.53,32.28,32.62,31.44,30.69,33.34,33.12,31.19,30.88,30.69,30.0,31.75,32.56,34.03,34.53,35.12,33.91,33.47,33.78,32.66,33.09,31.53,35.03,35.72,37.78,40.25,41.41,41.66,41.03,39.59,36.5,36.16,35.28,33.84,31.38,33.16,30.59,29.56,28.59,27.84,28.31,28.81,30.22,32.62,34.5,34.09,38.72,36.81,36.38,36.88,35.88,33.09,32.22,28.81,28.81,29.25,30.34,33.5,35.66,36.12,34.31,33.38,31.5,29.78,28.34,30.16,27.56,30.94,30.28,31.09,31.56,30.62,29.12,26.09,24.44,19.97,21.72,23.56,24.06,28.31,29.16,30.81,31.09,27.81,28.0,27.28,26.0,25.78,26.06,27.41,28.06,28.78,31.31,33.78,34.56,38.03,39.06,39.66,39.81,37.81,38.09,35.44,34.91,34.91,33.44,34.72,36.16,35.69,34.47,32.69,30.31,27.91,26.5,23.38,25.09,23.75,25.47,29.81,31.62,34.06,37.47,38.81,40.0,41.66,42.25,42.69,41.84,40.56,44.0,43.06,45.12,47.56,47.31,46.94,46.66,44.31,42.75,40.41,39.03,39.56,39.31,41.0,42.31,42.53,39.97,38.0,35.44,32.97,31.25,26.03,27.84,25.25,25.69,25.69,26.31,27.31,25.47,25.72,26.62,27.16,26.75,30.91,31.94,34.97,36.34,37.34,36.88,35.56,34.81,34.25,32.28,33.69,33.81,31.19,35.75,34.53,35.38,37.25,36.22,36.22,34.5,34.56,34.72,34.62,36.16,37.19,36.84,33.72,36.22,35.12,34.56,34.38,33.78,32.16,30.5,28.72,27.62,28.12,28.81,27.62,31.16,33.22,34.78,38.34,40.47,41.44,43.16,44.84,46.91,49.09,51.03,53.0,51.56,48.69,43.38,40.94,36.88,33.81,32.5,30.66,30.94,29.25,30.81,31.91,32.41,31.19,32.5,31.84,29.12,31.34,32.41,33.12,32.66,34.34,35.38,34.81,35.72,35.47,33.06,30.12,31.62,29.47,30.22,30.84,29.72,29.19,28.25,26.44,26.44,24.94,27.22,25.5,27.38,27.22,28.91,30.16,32.19,33.38,34.28,34.06,32.25,30.5,28.28,27.22,27.31,28.88,30.62,32.62,33.81,33.91,33.41,33.34,32.38,30.12,28.84,25.06,25.16,23.53,22.59,22.66,24.69,25.75,26.81,27.44,29.56,29.41,29.44,28.53,28.44,28.88,26.72,28.88,27.69,26.31,26.53,25.0,22.81,22.31,21.19,20.0,19.97,18.91,16.81,16.66,15.78,17.0,16.81,18.59,18.41,18.5,17.56,15.53,15.53,14.81,14.56,-24.91,-25.56,-26.03,-24.38,-24.47,-24.88,-24.09,-23.84,-24.84,-24.44,-23.69,-22.81,-22.22,-20.03,-20.91,-19.94,-17.59,-16.38,-16.09,-15.59,-15.34,-17.97,-21.75,-20.91:18.84,21.28,20.88,21.66,21.53,21.03,21.31,21.44,22.5,23.06,23.75,25.06,25.88,27.56,26.0,25.97,23.34,21.97,17.0,17.78,17.06,18.56,19.25,21.91,23.0,23.25,20.81,24.12,24.94,27.12,29.12,30.44,30.56,27.12,25.22,17.03,18.31,14.34,14.41,15.56,15.19,16.03,14.03,14.31,14.66,15.19,15.31,16.62,16.31,20.09,18.94,21.03,20.41,20.38,21.12,19.53,19.34,19.66,18.31,17.44,20.78,22.53,25.47,29.16,31.84,33.09,33.09,34.75,33.16,31.66,26.81,24.84,23.47,21.38,24.72,24.41,27.22,28.19,30.38,31.38,30.69,30.62,29.34,25.84,27.19,27.66,27.72,28.94,28.19,28.34,28.28,26.0,25.97,29.56,30.53,33.91,36.78,38.16,38.03,36.91,35.5,34.06,32.44,33.38,32.31,33.28,34.78,35.31,35.47,35.34,33.38,31.28,31.94,30.12,31.06,33.41,34.72,35.97,35.72,36.69,35.22,35.44,37.19,35.66,39.97,40.81,44.81,46.44,47.91,47.56,44.88,45.25,41.81,40.22,40.78,39.5,35.44,36.19,32.62,31.56,30.81,31.34,33.31,34.84,37.25,39.62,39.0,40.25,38.19,34.62,33.41,31.16,27.56,26.5,24.5,23.25,21.78,22.06,19.88,22.41,23.5,24.34,25.34,26.62,25.41,25.16,27.31,29.41,32.16,35.81,37.69,40.41,40.06,39.91,41.06,41.34,40.5,40.94,40.78,38.22,38.75,39.56,40.81,41.47,43.47,47.31,48.0,47.25,50.69,49.69,49.53,47.94,45.75,43.94,39.88,37.94,36.25,34.53,31.78,32.53,34.25,35.72,38.53,41.72,43.34,44.81,44.62,40.66,41.25,39.53,37.31,36.66,37.16,37.28,36.0,36.56,35.81,38.06,39.75,41.88,44.84,46.56,48.56,50.25,50.25,49.66,50.5,47.5,45.28,43.44,43.19,42.66,39.69,40.44,37.38,34.31,32.78,28.28,26.56,27.5,27.34,30.5,32.97,35.84,37.03,37.53,36.94,37.69,40.47,40.41,40.59,42.91,43.28,41.56,38.31,40.88,38.81,38.53,38.12,38.28,33.94,33.72,32.97,33.94,36.5,41.0,43.28,45.53,47.56,47.72,46.0,46.25,43.72,42.19,41.28,41.66,39.19,37.25,36.0,35.78,35.75,37.66,42.0,44.06,47.06,48.62,48.94,48.56,46.94,43.53,46.09,44.16,44.78,46.31,45.41,44.19,41.66,39.5,36.59,36.56,36.28,38.28,40.72,44.12,45.44,46.53,46.88,45.12,42.56,44.44,42.97,43.66,43.88,44.31,42.59,41.41,40.44,38.59,36.09,36.56,35.78,37.03,40.34,42.66,45.28,49.62,47.81,50.56,49.59,49.44,49.53,47.44,48.09,47.81,44.81,42.69,40.53,35.5,31.62,28.62,25.0,24.12,21.69,22.0,24.97,28.38,33.88,39.78,43.22,47.12,47.94,46.03,45.94,45.66,42.06,41.06,38.91,35.78,32.72,28.75,27.88,28.19,24.56,30.69,32.19,35.88,38.09,42.44,40.66,43.62,43.81,45.53,47.12,45.47,48.72,47.31,47.25,47.78,49.44,49.91,48.56,49.81,47.91,41.69,42.94,36.0,37.19,35.97,36.94,36.69,35.47,35.81,34.66,34.12,33.34,34.5,34.09,33.38,34.44,35.62,33.78,33.72,31.81,26.81,21.94,19.38,14.91,13.16,11.78,13.91,16.66,19.78,22.22,25.94,27.66,29.72,27.19,30.19,29.31,27.19,28.81,29.06,32.28,34.66,35.62,38.91,40.94,41.31,40.38,40.31,37.94,34.62,32.06,29.75,27.62,23.59,24.41,22.81,21.56,22.88,22.72,21.84,22.06,20.75,19.5,17.12,19.25,19.22,23.75,28.53,32.94,34.5,36.38,35.69,32.56,27.91,27.53,25.56,24.0,24.5,21.59,21.06,19.47,15.66,15.69,15.34,16.66,18.06,19.25,23.75,25.78,25.84,25.91,26.81,27.62,27.34,29.12,30.19,28.25,27.12,24.47,22.12,22.69,22.25,22.59,24.41,26.47,26.59,26.69,24.56,24.69,22.44,22.59,24.31,28.78,32.12,33.75,40.69,43.94,48.31,51.19,53.28,51.31,47.97,42.25,33.91,29.91,24.41,20.31,23.03,23.44,27.31,29.91,30.62,31.53,32.59,30.31,28.62,32.03,29.81,31.06,31.31,33.06,32.81,32.56,31.62,32.31,29.56,30.34,29.34,29.47,30.75,31.44,31.03,31.94,31.56,31.12,30.53,27.38,26.5,26.28,24.31,25.59,26.19,25.06,25.72,26.22,27.53,31.06,32.94,34.62,32.53,32.28,32.62,31.44,30.69,33.34,33.12,31.19,30.88,30.69,30.0,31.75,32.56,34.03,34.53,35.12,33.91,33.47,33.78,32.66,33.09,31.53,35.03,35.72,37.78,40.25,41.41,41.66,41.03,39.59,36.5,36.16,35.28,33.84,31.38,33.16,30.59,29.56,28.59,27.84,28.31,28.81,30.22,32.62,34.5,34.09,38.72,36.81,36.38,36.88,35.88,33.09,32.22,28.81,28.81,29.25,30.34,33.5,35.66,36.12,34.31,33.38,31.5,29.78,28.34,30.16,27.56,30.94,30.28,31.09,31.56,30.62,29.12,26.09,24.44,19.97,21.72,23.56,24.06,28.31,29.16,30.81,31.09,27.81,28.0,27.28,26.0,25.78,26.06,27.41,28.06,28.78,31.31,33.78,34.56,38.03,39.06,39.66,39.81,37.81,38.09,35.44,34.91,34.91,33.44,34.72,36.16,35.69,34.47,32.69,30.31,27.91,26.5,23.38,25.09,23.75,25.47,29.81,31.62,34.06,37.47,38.81,40.0,41.66,42.25,42.69,41.84,40.56,44.0,43.06,45.12,47.56,47.31,46.94,46.66,44.31,42.75,40.41,39.03,39.56,39.31,41.0,42.31,42.53,39.97,38.0,35.44,32.97,31.25,26.03,27.84,25.25,25.69,25.69,26.31,27.31,25.47,25.72,26.62,27.16,26.75,30.91,31.94,34.97,36.34,37.34,36.88,35.56,34.81,34.25,32.28,33.69,33.81,31.19,35.75,34.53,35.38,37.25,36.22,36.22,34.5,34.56,34.72,34.62,36.16,37.19,36.84,33.72,36.22,35.12,34.56,34.38,33.78,32.16,30.5,28.72,27.62,28.12,28.81,27.62,31.16,33.22,34.78,38.34,40.47,41.44,43.16,44.84,46.91,49.09,51.03,53.0,51.56,48.69,43.38,40.94,36.88,33.81,32.5,30.66,30.94,29.25,30.81,31.91,32.41,31.19,32.5,31.84,29.12,31.34,32.41,33.12,32.66,34.34,35.38,34.81,35.72,35.47,33.06,30.12,31.62,29.47,30.22,30.84,29.72,29.19,28.25,26.44,26.44,24.94,27.22,25.5,27.38,27.22,28.91,30.16,32.19,33.38,34.28,34.06,32.25,30.5,28.28,27.22,27.31,28.88,30.62,32.62,33.81,33.91,33.41,33.34,32.38,30.12,28.84,25.06,25.16,23.53,22.59,22.66,24.69,25.75,26.81,27.44,29.56,29.41,29.44,28.53,28.44,28.88,26.72,28.88,27.69,26.31,26.53,25.0,22.81,22.31,21.19,20.0,19.97,18.91,16.81,16.66,15.78,17.0,16.81,18.59,18.41,18.5,17.56,15.53,15.53,14.81,14.56,-24.91,-25.56,-26.03,-24.38,-24.47,-24.88,-24.09,-23.84,-24.84,-24.44,-23.69,-22.81,-22.22,-20.03,-20.91,-19.94,-17.59,-16.38,-16.09,-15.59,-15.34,-17.97,-21.75,-20.91,-22.97,-23.84,-22.72,-21.84,-20.84,-20.94:negativity
98.06,96.66,97.81,99.25,99.62,101.56,104.0,105.06,107.88,110.91,111.94,114.75,114.0,113.44,111.28,110.66,108.31,107.5,106.19,105.56,104.19,103.06,101.56,101.75,103.62,105.06,107.31,108.75,107.19,103.06,102.06,98.44,97.31,99.31,101.81,105.0,108.22,109.12,112.06,112.81,113.75,115.69,118.06,119.28,119.56,118.31,117.03,112.34,111.5,110.0,109.06,110.5,111.56,111.69,113.06,113.69,113.88,113.5,113.59,112.25,111.75,110.38,108.75,106.5,104.28,102.31,101.03,99.19,97.81,95.69,94.19,91.69,89.84,88.66,89.09,88.78,89.69,91.12,92.5,92.91,93.66,93.81,94.62,94.56,97.56,97.81,99.28,98.91,99.5,99.81,100.12,100.88,101.75,101.38,100.66,99.75,100.66,99.56,98.75,97.28,97.44,96.38,96.03,96.94,98.12,98.19,99.5,100.44,100.56,98.94,101.31,101.22,103.0,106.03,110.5,113.81,116.5,116.62,117.12,115.06,112.75,110.12,106.69,104.78,103.0,100.38,99.81,98.12,96.88,95.28,95.94,96.06,98.12,99.0,99.66,99.62,98.94,98.19,96.56,96.88,98.75,98.06,97.44,100.81,98.56,98.31,99.12,99.12,101.12,102.31,104.41,106.41,106.69,107.03,107.19,105.0,105.25,104.06,103.06,103.25,103.12,102.81,104.38,104.12,104.38,103.69,103.5,102.62,101.72,101.81,103.69,104.88,106.56,107.94,107.19,107.12,106.81,107.69,107.44,109.91,111.31,110.88,111.88,110.81,109.41,110.0,108.31,107.34,106.22,105.56,103.62,102.5,101.5,99.94,98.81,97.88,100.03,101.0,102.16,102.81,103.91,104.5,102.69,103.97,104.06,103.69,104.47,104.91,106.5,105.06,103.94,101.81,100.0,96.5,95.06,95.94,95.19,95.69,96.66,95.34,96.19,94.81,93.62,93.31,92.06,92.62,91.5,93.5,93.56,92.31,92.12,91.69,91.06,91.56,93.5,95.69,98.06,99.19,101.72,102.31,102.44,101.31,101.53,100.25,98.0,97.44,96.34,94.56,96.91,97.19,98.94,101.44,102.62,101.25,103.0,101.94,100.88,101.69,100.69,99.12,98.5,95.44,93.62,93.0,93.06,94.06,96.75,99.0,101.31,102.38,102.94,101.44,99.94,97.09,94.31,92.25,90.56,89.94,90.0,89.34,91.44,92.62,94.81,95.38,96.28,96.5,97.16,96.94,99.0,100.88,101.62,102.0,102.12,101.0,100.0,101.25,100.88,101.56,101.62,103.25,102.56,102.0,100.25,97.28,94.06,92.62,92.0,92.47,93.62,95.62,96.81,97.44,97.94,99.38,98.03,98.28,96.66,96.44,95.78,95.0,95.12,94.16,95.5,96.25,97.62,100.94,102.62,105.56,110.62,112.88,116.81,120.31,121.25,120.28,119.25,117.78,114.62,113.66,112.94,112.56,109.75,109.81,108.44,107.62,107.53,108.66,109.69,111.25,112.34,112.72,113.94,113.0,112.56,113.12,113.5,114.0,116.06,115.5,113.81,111.44,109.31,106.75,105.12,103.81,103.31,101.94,102.0,102.0,104.31,106.03,108.25,109.53,110.56,110.41,109.62,108.94,108.94,108.25,107.31,106.5,106.75,107.66,108.91,110.31,112.62,113.81,115.62,114.31,114.16,114.38,112.41,111.69,112.12,110.69,111.97,111.59,112.0,111.06,110.94,110.19,109.94,109.0,108.56,109.12,108.94,109.44,108.84,109.69,106.81,105.44,101.47,99.06,98.78,97.25,97.19,96.91,94.84,92.97,90.16,88.12,87.19,86.94,88.91,90.44,91.81,91.81,92.81,91.19,91.69,92.12,93.5,95.59,96.84,98.31,98.56,98.25,97.94,98.31,97.47,97.56,97.16,97.84,96.78,97.62,97.25,98.78,97.81,99.56,100.06,101.47,101.62,101.06,102.25,102.56,101.41,102.44,104.09,104.19,104.5,105.88,105.72,104.5,103.25,101.44,100.59,99.75,99.38,99.19,98.91,97.75,96.62,95.16,95.12,93.12,91.03,89.88,87.44,85.31,85.09,84.31,84.56,86.19,88.0,88.5,89.81,92.12,92.28,94.06,97.25,98.12,98.62,96.28,95.62,92.94,90.41,90.81,90.38,90.0,89.84,88.91,90.25,90.19,91.12,92.25,93.0,94.38,95.19,95.84,95.31,97.81,97.12,98.34,97.66,98.19,97.06,97.44,95.88,97.62,98.19,99.41,101.62,102.75,103.56,104.81,104.12,103.06,103.66,100.28,100.66,100.03,98.31,98.41,98.34,100.5,101.47,103.28,105.75,108.34,110.38,110.81,111.59,110.53,108.06,105.75,102.56,100.41,101.19,99.0,98.41,98.56,96.75,95.16,93.97,93.25,92.0,90.38,90.38,89.94,89.38,90.25,92.0,93.62,95.06,97.34,98.53,99.28,99.84,97.91,99.06,95.0,94.31,94.25,92.06,90.81,91.53,90.75,91.0,91.06,91.88,92.94,93.53,95.03,95.66,95.81,95.97,96.0,96.19,96.69,97.81,97.56,99.25,98.88,98.88,100.06,100.38,100.16,100.0,100.88,100.5,99.06,99.94,101.19,102.75,105.03,108.5,110.03,110.41,110.56,109.06,109.38,107.12,106.94,105.5,104.56,103.44,102.94,103.97,104.56,105.31,105.81,105.88,104.69,104.19,103.06,104.06,101.69,102.0,100.56,99.31,97.25,94.62,93.44,92.69,90.81,92.31,93.0,93.06,95.19,95.69,98.06,97.94,97.56,96.03,94.41,90.81,89.47,89.12,88.16,88.75,89.56,88.19,86.25,84.94,83.16,81.94,82.81,83.91,86.25,86.16,87.69,89.56,90.44,90.75,93.44,94.53,95.72,95.94,96.69,96.94,97.41,97.62,98.22,97.66,97.62,97.19,97.78,98.06,99.75,99.88,99.38,99.31,96.75,97.31,96.69,96.12,97.12,97.41,98.56,97.5,97.72,98.12,97.81,97.81,97.16,98.16,98.44,96.62,97.75,97.56,98.56,98.19,99.94,100.0,99.75,99.66,96.59,95.75,94.25,92.62,93.47,93.25,94.62,95.31,96.16,96.5,97.47,98.31,99.56,100.19,100.78,102.88,103.0,104.31,105.06,104.94,105.72,104.12,103.44,103.41,102.94,101.88,102.31,100.12,100.69,99.94,98.38,99.75,99.59,98.28,98.16,97.38,97.75,97.0,99.31,101.56,103.12,106.78,108.06,108.16,105.5,103.44,99.38,96.12,93.5,91.03,88.25,84.88,79.88,73.81,67.25,61.0,55.81,50.91,47.0,45.06,42.69,42.25,41.78,44.09,46.78,49.81,52.84,56.19,58.09,60.56,61.44,62.94,64.5,65.44,66.41,67.25,66.88,66.34,65.06,64.0,63.44,66.19,69.25,72.97,76.69,79.75,80.25,78.81,79.44,77.88,78.03,78.69,79.56,80.81,82.0,82.38,84.56,86.16,88.25,89.94,93.56,96.0,98.94,100.38,101.78,103.78,103.44,105.25,104.56,106.12,105.31,105.31,105.62,104.75,105.12,105.25,105.12,104.25,103.25,100.94,100.19,98.91,98.28,98.44,96.0,95.69,93.16,91.12,89.56,88.12,87.5,87.06,88.31,90.94,92.09,94.47,95.69,95.19,95.88,95.38,95.81,95.12,95.31,95.56,94.88,94.19,93.06,90.69,87.88,85.56,81.81,80.94,80.69,79.44,80.44,81.62,81.88,82.5,83.06,83.81,82.97,82.59,81.56,82.12,80.94,81.81,83.66,84.69,86.0,85.44,86.69,86.0,86.12,86.94,87.09,87.91,87.56,87.0,86.41,84.81,84.16,84.69,84.5,84.94,86.19,86.88,87.06,88.56,89.81,90.06,90.56:104.0,105.06,107.88,110.91,111.94,114.75,114.0,113.44,111.28,110.66,108.31,107.5,106.19,105.56,104.19,103.06,101.56,101.75,103.62,105.06,107.31,108.75,107.19,103.06,102.06,98.44,97.31,99.31,101.81,105.0,108.22,109.12,112.06,112.81,113.75,115.69,118.06,119.28,119.56,118.31,117.03,112.34,111.5,110.0,109.06,110.5,111.56,111.69,113.06,113.69,113.88,113.5,113.59,112.25,111.75,110.38,108.75,106.5,104.28,102.31,101.03,99.19,97.81,95.69,94.19,91.69,89.84,88.66,89.09,88.78,89.69,91.12,92.5,92.91,93.66,93.81,94.62,94.56,97.56,97.81,99.28,98.91,99.5,99.81,100.12,100.88,101.75,101.38,100.66,99.75,100.66,99.56,98.75,97.28,97.44,96.38,96.03,96.94,98.12,98.19,99.5,100.44,100.56,98.94,101.31,101.22,103.0,106.03,110.5,113.81,116.5,116.62,117.12,115.06,112.75,110.12,106.69,104.78,103.0,100.38,99.81,98.12,96.88,95.28,95.94,96.06,98.12,99.0,99.66,99.62,98.94,98.19,96.56,96.88,98.75,98.06,97.44,100.81,98.56,98.31,99.12,99.12,101.12,102.31,104.41,106.41,106.69,107.03,107.19,105.0,105.25,104.06,103.06,103.25,103.12,102.81,104.38,104.12,104.38,103.69,103.5,102.62,101.72,101.81,103.69,104.88,106.56,107.94,107.19,107.12,106.81,107.69,107.44,109.91,111.31,110.88,111.88,110.81,109.41,110.0,108.31,107.34,106.22,105.56,103.62,102.5,101.5,99.94,98.81,97.88,100.03,101.0,102.16,102.81,103.91,104.5,102.69,103.97,104.06,103.69,104.47,104.91,106.5,105.06,103.94,101.81,100.0,96.5,95.06,95.94,95.19,95.69,96.66,95.34,96.19,94.81,93.62,93.31,92.06,92.62,91.5,93.5,93.56,92.31,92.12,91.69,91.06,91.56,93.5,95.69,98.06,99.19,101.72,102.31,102.44,101.31,101.53,100.25,98.0,97.44,96.34,94.56,96.91,97.19,98.94,101.44,102.62,101.25,103.0,101.94,100.88,101.69,100.69,99.12,98.5,95.44,93.62,93.0,93.06,94.06,96.75,99.0,101.31,102.38,102.94,101.44,99.94,97.09,94.31,92.25,90.56,89.94,90.0,89.34,91.44,92.62,94.81,95.38,96.28,96.5,97.16,96.94,99.0,100.88,101.62,102.0,102.12,101.0,100.0,101.25,100.88,101.56,101.62,103.25,102.56,102.0,100.25,97.28,94.06,92.62,92.0,92.47,93.62,95.62,96.81,97.44,97.94,99.38,98.03,98.28,96.66,96.44,95.78,95.0,95.12,94.16,95.5,96.25,97.62,100.94,102.62,105.56,110.62,112.88,116.81,120.31,121.25,120.28,119.25,117.78,114.62,113.66,112.94,112.56,109.75,109.81,108.44,107.62,107.53,108.66,109.69,111.25,112.34,112.72,113.94,113.0,112.56,113.12,113.5,114.0,116.06,115.5,113.81,111.44,109.31,106.75,105.12,103.81,103.31,101.94,102.0,102.0,104.31,106.03,108.25,109.53,110.56,110.41,109.62,108.94,108.94,108.25,107.31,106.5,106.75,107.66,108.91,110.31,112.62,113.81,115.62,114.31,114.16,114.38,112.41,111.69,112.12,110.69,111.97,111.59,112.0,111.06,110.94,110.19,109.94,109.0,108.56,109.12,108.94,109.44,108.84,109.69,106.81,105.44,101.47,99.06,98.78,97.25,97.19,96.91,94.84,92.97,90.16,88.12,87.19,86.94,88.91,90.44,91.81,91.81,92.81,91.19,91.69,92.12,93.5,95.59,96.84,98.31,98.56,98.25,97.94,98.31,97.47,97.56,97.16,97.84,96.78,97.62,97.25,98.78,97.81,99.56,100.06,101.47,101.62,101.06,102.25,102.56,101.41,102.44,104.09,104.19,104.5,105.88,105.72,104.5,103.25,101.44,100.59,99.75,99.38,99.19,98.91,97.75,96.62,95.16,95.12,93.12,91.03,89.88,87.44,85.31,85.09,84.31,84.56,86.19,88.0,88.5,89.81,92.12,92.28,94.06,97.25,98.12,98.62,96.28,95.62,92.94,90.41,90.81,90.38,90.0,89.84,88.91,90.25,90.19,91.12,92.25,93.0,94.38,95.19,95.84,95.31,97.81,97.12,98.34,97.66,98.19,97.06,97.44,95.88,97.62,98.19,99.41,101.62,102.75,103.56,104.81,104.12,103.06,103.66,100.28,100.66,100.03,98.31,98.41,98.34,100.5,101.47,103.28,105.75,108.34,110.38,110.81,111.59,110.53,108.06,105.75,102.56,100.41,101.19,99.0,98.41,98.56,96.75,95.16,93.97,93.25,92.0,90.38,90.38,89.94,89.38,90.25,92.0,93.62,95.06,97.34,98.53,99.28,99.84,97.91,99.06,95.0,94.31,94.25,92.06,90.81,91.53,90.75,91.0,91.06,91.88,92.94,93.53,95.03,95.66,95.81,95.97,96.0,96.19,96.69,97.81,97.56,99.25,98.88,98.88,100.06,100.38,100.16,100.0,100.88,100.5,99.06,99.94,101.19,102.75,105.03,108.5,110.03,110.41,110.56,109.06,109.38,107.12,106.94,105.5,104.56,103.44,102.94,103.97,104.56,105.31,105.81,105.88,104.69,104.19,103.06,104.06,101.69,102.0,100.56,99.31,97.25,94.62,93.44,92.69,90.81,92.31,93.0,93.06,95.19,95.69,98.06,97.94,97.56,96.03,94.41,90.81,89.47,89.12,88.16,88.75,89.56,88.19,86.25,84.94,83.16,81.94,82.81,83.91,86.25,86.16,87.69,89.56,90.44,90.75,93.44,94.53,95.72,95.94,96.69,96.94,97.41,97.62,98.22,97.66,97.62,97.19,97.78,98.06,99.75,99.88,99.38,99.31,96.75,97.31,96.69,96.12,97.12,97.41,98.56,97.5,97.72,98.12,97.81,97.81,97.16,98.16,98.44,96.62,97.75,97.56,98.56,98.19,99.94,100.0,99.75,99.66,96.59,95.75,94.25,92.62,93.47,93.25,94.62,95.31,96.16,96.5,97.47,98.31,99.56,100.19,100.78,102.88,103.0,104.31,105.06,104.94,105.72,104.12,103.44,103.41,102.94,101.88,102.31,100.12,100.69,99.94,98.38,99.75,99.59,98.28,98.16,97.38,97.75,97.0,99.31,101.56,103.12,106.78,108.06,108.16,105.5,103.44,99.38,96.12,93.5,91.03,88.25,84.88,79.88,73.81,67.25,61.0,55.81,50.91,47.0,45.06,42.69,42.25,41.78,44.09,46.78,49.81,52.84,56.19,58.09,60.56,61.44,62.94,64.5,65.44,66.41,67.25,66.88,66.34,65.06,64.0,63.44,66.19,69.25,72.97,76.69,79.75,80.25,78.81,79.44,77.88,78.03,78.69,79.56,80.81,82.0,82.38,84.56,86.16,88.25,89.94,93.56,96.0,98.94,100.38,101.78,103.78,103.44,105.25,104.56,106.12,105.31,105.31,105.62,104.75,105.12,105.25,105.12,104.25,103.25,100.94,100.19,98.91,98.28,98.44,96.0,95.69,93.16,91.12,89.56,88.12,87.5,87.06,88.31,90.94,92.09,94.47,95.69,95.19,95.88,95.38,95.81,95.12,95.31,95.56,94.88,94.19,93.06,90.69,87.88,85.56,81.81,80.94,80.69,79.44,80.44,81.62,81.88,82.5,83.06,83.81,82.97,82.59,81.56,82.12,80.94,81.81,83.66,84.69,86.0,85.44,86.69,86.0,86.12,86.94,87.09,87.91,87.56,87.0,86.41,84.81,84.16,84.69,84.5,84.94,86.19,86.88,87.06,88.56,89.81,90.06,90.56,62.41,61.16,62.03,62.75,64.0,65.94:114.0,113.44,111.28,110.66,108.31,107.5,106.19,105.56,104.19,103.06,101.56,101.75,103.62,105.06,107.31,108.75,107.19,103.06,102.06,98.44,97.31,99.31,101.81,105.0,108.22,109.12,112.06,112.81,113.75,115.69,118.06,119.28,119.56,118.31,117.03,112.34,111.5,110.0,109.06,110.5,111.56,111.69,113.06,113.69,113.88,113.5,113.59,112.25,111.75,110.38,108.75,106.5,104.28,102.31,101.03,99.19,97.81,95.69,94.19,91.69,89.84,88.66,89.09,88.78,89.69,91.12,92.5,92.91,93.66,93.81,94.62,94.56,97.56,97.81,99.28,98.91,99.5,99.81,100.12,100.88,101.75,101.38,100.66,99.75,100.66,99.56,98.75,97.28,97.44,96.38,96.03,96.94,98.12,98.19,99.5,100.44,100.56,98.94,101.31,101.22,103.0,106.03,110.5,113.81,116.5,116.62,117.12,115.06,112.75,110.12,106.69,104.78,103.0,100.38,99.81,98.12,96.88,95.28,95.94,96.06,98.12,99.0,99.66,99.62,98.94,98.19,96.56,96.88,98.75,98.06,97.44,100.81,98.56,98.31,99.12,99.12,101.12,102.31,104.41,106.41,106.69,107.03,107.19,105.0,105.25,104.06,103.06,103.25,103.12,102.81,104.38,104.12,104.38,103.69,103.5,102.62,101.72,101.81,103.69,104.88,106.56,107.94,107.19,107.12,106.81,107.69,107.44,109.91,111.31,110.88,111.88,110.81,109.41,110.0,108.31,107.34,106.22,105.56,103.62,102.5,101.5,99.94,98.81,97.88,100.03,101.0,102.16,102.81,103.91,104.5,102.69,103.97,104.06,103.69,104.47,104.91,106.5,105.06,103.94,101.81,100.0,96.5,95.06,95.94,95.19,95.69,96.66,95.34,96.19,94.81,93.62,93.31,92.06,92.62,91.5,93.5,93.56,92.31,92.12,91.69,91.06,91.56,93.5,95.69,98.06,99.19,101.72,102.31,102.44,101.31,101.53,100.25,98.0,97.44,96.34,94.56,96.91,97.19,98.94,101.44,102.62,101.25,103.0,101.94,100.88,101.69,100.69,99.12,98.5,95.44,93.62,93.0,93.06,94.06,96.75,99.0,101.31,102.38,102.94,101.44,99.94,97.09,94.31,92.25,90.56,89.94,90.0,89.34,91.44,92.62,94.81,95.38,96.28,96.5,97.16,96.94,99.0,100.88,101.62,102.0,102.12,101.0,100.0,101.25,100.88,101.56,101.62,103.25,102.56,102.0,100.25,97.28,94.06,92.62,92.0,92.47,93.62,95.62,96.81,97.44,97.94,99.38,98.03,98.28,96.66,96.44,95.78,95.0,95.12,94.16,95.5,96.25,97.62,100.94,102.62,105.56,110.62,112.88,116.81,120.31,121.25,120.28,119.25,117.78,114.62,113.66,112.94,112.56,109.75,109.81,108.44,107.62,107.53,108.66,109.69,111.25,112.34,112.72,113.94,113.0,112.56,113.12,113.5,114.0,116.06,115.5,113.81,111.44,109.31,106.75,105.12,103.81,103.31,101.94,102.0,102.0,104.31,106.03,108.25,109.53,110.56,110.41,109.62,108.94,108.94,108.25,107.31,106.5,106.75,107.66,108.91,110.31,112.62,113.81,115.62,114.31,114.16,114.38,112.41,111.69,112.12,110.69,111.97,111.59,112.0,111.06,110.94,110.19,109.94,109.0,108.56,109.12,108.94,109.44,108.84,109.69,106.81,105.44,101.47,99.06,98.78,97.25,97.19,96.91,94.84,92.97,90.16,88.12,87.19,86.94,88.91,90.44,91.81,91.81,92.81,91.19,91.69,92.12,93.5,95.59,96.84,98.31,98.56,98.25,97.94,98.31,97.47,97.56,97.16,97.84,96.78,97.62,97.25,98.78,97.81,99.56,100.06,101.47,101.62,101.06,102.25,102.56,101.41,102.44,104.09,104.19,104.5,105.88,105.72,104.5,103.25,101.44,100.59,99.75,99.38,99.19,98.91,97.75,96.62,95.16,95.12,93.12,91.03,89.88,87.44,85.31,85.09,84.31,84.56,86.19,88.0,88.5,89.81,92.12,92.28,94.06,97.25,98.12,98.62,96.28,95.62,92.94,90.41,90.81,90.38,90.0,89.84,88.91,90.25,90.19,91.12,92.25,93.0,94.38,95.19,95.84,95.31,97.81,97.12,98.34,97.66,98.19,97.06,97.44,95.88,97.62,98.19,99.41,101.62,102.75,103.56,104.81,104.12,103.06,103.66,100.28,100.66,100.03,98.31,98.41,98.34,100.5,101.47,103.28,105.75,108.34,110.38,110.81,111.59,110.53,108.06,105.75,102.56,100.41,101.19,99.0,98.41,98.56,96.75,95.16,93.97,93.25,92.0,90.38,90.38,89.94,89.38,90.25,92.0,93.62,95.06,97.34,98.53,99.28,99.84,97.91,99.06,95.0,94.31,94.25,92.06,90.81,91.53,90.75,91.0,91.06,91.88,92.94,93.53,95.03,95.66,95.81,95.97,96.0,96.19,96.69,97.81,97.56,99.25,98.88,98.88,100.06,100.38,100.16,100.0,100.88,100.5,99.06,99.94,101.19,102.75,105.03,108.5,110.03,110.41,110.56,109.06,109.38,107.12,106.94,105.5,104.56,103.44,102.94,103.97,104.56,105.31,105.81,105.88,104.69,104.19,103.06,104.06,101.69,102.0,100.56,99.31,97.25,94.62,93.44,92.69,90.81,92.31,93.0,93.06,95.19,95.69,98.06,97.94,97.56,96.03,94.41,90.81,89.47,89.12,88.16,88.75,89.56,88.19,86.25,84.94,83.16,81.94,82.81,83.91,86.25,86.16,87.69,89.56,90.44,90.75,93.44,94.53,95.72,95.94,96.69,96.94,97.41,97.62,98.22,97.66,97.62,97.19,97.78,98.06,99.75,99.88,99.38,99.31,96.75,97.31,96.69,96.12,97.12,97.41,98.56,97.5,97.72,98.12,97.81,97.81,97.16,98.16,98.44,96.62,97.75,97.56,98.56,98.19,99.94,100.0,99.75,99.66,96.59,95.75,94.25,92.62,93.47,93.25,94.62,95.31,96.16,96.5,97.47,98.31,99.56,100.19,100.78,102.88,103.0,104.31,105.06,104.94,105.72,104.12,103.44,103.41,102.94,101.88,102.31,100.12,100.69,99.94,98.38,99.75,99.59,98.28,98.16,97.38,97.75,97.0,99.31,101.56,103.12,106.78,108.06,108.16,105.5,103.44,99.38,96.12,93.5,91.03,88.25,84.88,79.88,73.81,67.25,61.0,55.81,50.91,47.0,45.06,42.69,42.25,41.78,44.09,46.78,49.81,52.84,56.19,58.09,60.56,61.44,62.94,64.5,65.44,66.41,67.25,66.88,66.34,65.06,64.0,63.44,66.19,69.25,72.97,76.69,79.75,80.25,78.81,79.44,77.88,78.03,78.69,79.56,80.81,82.0,82.38,84.56,86.16,88.25,89.94,93.56,96.0,98.94,100.38,101.78,103.78,103.44,105.25,104.56,106.12,105.31,105.31,105.62,104.75,105.12,105.25,105.12,104.25,103.25,100.94,100.19,98.91,98.28,98.44,96.0,95.69,93.16,91.12,89.56,88.12,87.5,87.06,88.31,90.94,92.09,94.47,95.69,95.19,95.88,95.38,95.81,95.12,95.31,95.56,94.88,94.19,93.06,90.69,87.88,85.56,81.81,80.94,80.69,79.44,80.44,81.62,81.88,82.5,83.06,83.81,82.97,82.59,81.56,82.12,80.94,81.81,83.66,84.69,86.0,85.44,86.69,86.0,86.12,86.94,87.09,87.91,87.56,87.0,86.41,84.81,84.16,84.69,84.5,84.94,86.19,86.88,87.06,88.56,89.81,90.06,90.56,62.41,61.16,62.03,62.75,64.0,65.94,67.72,70.56,72.25,74.34,74.66,77.41:106.19,105.56,104.19,103.06,101.56,101.75,103.62,105.06,107.31,108.75,107.19,103.06,102.06,98.44,97.31,99.31,101.81,105.0,108.22,109.12,112.06,112.81,113.75,115.69,118.06,119.28,119.56,118.31,117.03,112.34,111.5,110.0,109.06,110.5,111.56,111.69,113.06,113.69,113.88,113.5,113.59,112.25,111.75,110.38,108.75,106.5,104.28,102.31,101.03,99.19,97.81,95.69,94.19,91.69,89.84,88.66,89.09,88.78,89.69,91.12,92.5,92.91,93.66,93.81,94.62,94.56,97.56,97.81,99.28,98.91,99.5,99.81,100.12,100.88,101.75,101.38,100.66,99.75,100.66,99.56,98.75,97.28,97.44,96.38,96.03,96.94,98.12,98.19,99.5,100.44,100.56,98.94,101.31,101.22,103.0,106.03,110.5,113.81,116.5,116.62,117.12,115.06,112.75,110.12,106.69,104.78,103.0,100.38,99.81,98.12,96.88,95.28,95.94,96.06,98.12,99.0,99.66,99.62,98.94,98.19,96.56,96.88,98.75,98.06,97.44,100.81,98.56,98.31,99.12,99.12,101.12,102.31,104.41,106.41,106.69,107.03,107.19,105.0,105.25,104.06,103.06,103.25,103.12,102.81,104.38,104.12,104.38,103.69,103.5,102.62,101.72,101.81,103.69,104.88,106.56,107.94,107.19,107.12,106.81,107.69,107.44,109.91,111.31,110.88,111.88,110.81,109.41,110.0,108.31,107.34,106.22,105.56,103.62,102.5,101.5,99.94,98.81,97.88,100.03,101.0,102.16,102.81,103.91,104.5,102.69,103.97,104.06,103.69,104.47,104.91,106.5,105.06,103.94,101.81,100.0,96.5,95.06,95.94,95.19,95.69,96.66,95.34,96.19,94.81,93.62,93.31,92.06,92.62,91.5,93.5,93.56,92.31,92.12,91.69,91.06,91.56,93.5,95.69,98.06,99.19,101.72,102.31,102.44,101.31,101.53,100.25,98.0,97.44,96.34,94.56,96.91,97.19,98.94,101.44,102.62,101.25,103.0,101.94,100.88,101.69,100.69,99.12,98.5,95.44,93.62,93.0,93.06,94.06,96.75,99.0,101.31,102.38,102.94,101.44,99.94,97.09,94.31,92.25,90.56,89.94,90.0,89.34,91.44,92.62,94.81,95.38,96.28,96.5,97.16,96.94,99.0,100.88,101.62,102.0,102.12,101.0,100.0,101.25,100.88,101.56,101.62,103.25,102.56,102.0,100.25,97.28,94.06,92.62,92.0,92.47,93.62,95.62,96.81,97.44,97.94,99.38,98.03,98.28,96.66,96.44,95.78,95.0,95.12,94.16,95.5,96.25,97.62,100.94,102.62,105.56,110.62,112.88,116.81,120.31,121.25,120.28,119.25,117.78,114.62,113.66,112.94,112.56,109.75,109.81,108.44,107.62,107.53,108.66,109.69,111.25,112.34,112.72,113.94,113.0,112.56,113.12,113.5,114.0,116.06,115.5,113.81,111.44,109.31,106.75,105.12,103.81,103.31,101.94,102.0,102.0,104.31,106.03,108.25,109.53,110.56,110.41,109.62,108.94,108.94,108.25,107.31,106.5,106.75,107.66,108.91,110.31,112.62,113.81,115.62,114.31,114.16,114.38,112.41,111.69,112.12,110.69,111.97,111.59,112.0,111.06,110.94,110.19,109.94,109.0,108.56,109.12,108.94,109.44,108.84,109.69,106.81,105.44,101.47,99.06,98.78,97.25,97.19,96.91,94.84,92.97,90.16,88.12,87.19,86.94,88.91,90.44,91.81,91.81,92.81,91.19,91.69,92.12,93.5,95.59,96.84,98.31,98.56,98.25,97.94,98.31,97.47,97.56,97.16,97.84,96.78,97.62,97.25,98.78,97.81,99.56,100.06,101.47,101.62,101.06,102.25,102.56,101.41,102.44,104.09,104.19,104.5,105.88,105.72,104.5,103.25,101.44,100.59,99.75,99.38,99.19,98.91,97.75,96.62,95.16,95.12,93.12,91.03,89.88,87.44,85.31,85.09,84.31,84.56,86.19,88.0,88.5,89.81,92.12,92.28,94.06,97.25,98.12,98.62,96.28,95.62,92.94,90.41,90.81,90.38,90.0,89.84,88.91,90.25,90.19,91.12,92.25,93.0,94.38,95.19,95.84,95.31,97.81,97.12,98.34,97.66,98.19,97.06,97.44,95.88,97.62,98.19,99.41,101.62,102.75,103.56,104.81,104.12,103.06,103.66,100.28,100.66,100.03,98.31,98.41,98.34,100.5,101.47,103.28,105.75,108.34,110.38,110.81,111.59,110.53,108.06,105.75,102.56,100.41,101.19,99.0,98.41,98.56,96.75,95.16,93.97,93.25,92.0,90.38,90.38,89.94,89.38,90.25,92.0,93.62,95.06,97.34,98.53,99.28,99.84,97.91,99.06,95.0,94.31,94.25,92.06,90.81,91.53,90.75,91.0,91.06,91.88,92.94,93.53,95.03,95.66,95.81,95.97,96.0,96.19,96.69,97.81,97.56,99.25,98.88,98.88,100.06,100.38,100.16,100.0,100.88,100.5,99.06,99.94,101.19,102.75,105.03,108.5,110.03,110.41,110.56,109.06,109.38,107.12,106.94,105.5,104.56,103.44,102.94,103.97,104.56,105.31,105.81,105.88,104.69,104.19,103.06,104.06,101.69,102.0,100.56,99.31,97.25,94.62,93.44,92.69,90.81,92.31,93.0,93.06,95.19,95.69,98.06,97.94,97.56,96.03,94.41,90.81,89.47,89.12,88.16,88.75,89.56,88.19,86.25,84.94,83.16,81.94,82.81,83.91,86.25,86.16,87.69,89.56,90.44,90.75,93.44,94.53,95.72,95.94,96.69,96.94,97.41,97.62,98.22,97.66,97.62,97.19,97.78,98.06,99.75,99.88,99.38,99.31,96.75,97.31,96.69,96.12,97.12,97.41,98.56,97.5,97.72,98.12,97.81,97.81,97.16,98.16,98.44,96.62,97.75,97.56,98.56,98.19,99.94,100.0,99.75,99.66,96.59,95.75,94.25,92.62,93.47,93.25,94.62,95.31,96.16,96.5,97.47,98.31,99.56,100.19,100.78,102.88,103.0,104.31,105.06,104.94,105.72,104.12,103.44,103.41,102.94,101.88,102.31,100.12,100.69,99.94,98.38,99.75,99.59,98.28,98.16,97.38,97.75,97.0,99.31,101.56,103.12,106.78,108.06,108.16,105.5,103.44,99.38,96.12,93.5,91.03,88.25,84.88,79.88,73.81,67.25,61.0,55.81,50.91,47.0,45.06,42.69,42.25,41.78,44.09,46.78,49.81,52.84,56.19,58.09,60.56,61.44,62.94,64.5,65.44,66.41,67.25,66.88,66.34,65.06,64.0,63.44,66.19,69.25,72.97,76.69,79.75,80.25,78.81,79.44,77.88,78.03,78.69,79.56,80.81,82.0,82.38,84.56,86.16,88.25,89.94,93.56,96.0,98.94,100.38,101.78,103.78,103.44,105.25,104.56,106.12,105.31,105.31,105.62,104.75,105.12,105.25,105.12,104.25,103.25,100.94,100.19,98.91,98.28,98.44,96.0,95.69,93.16,91.12,89.56,88.12,87.5,87.06,88.31,90.94,92.09,94.47,95.69,95.19,95.88,95.38,95.81,95.12,95.31,95.56,94.88,94.19,93.06,90.69,87.88,85.56,81.81,80.94,80.69,79.44,80.44,81.62,81.88,82.5,83.06,83.81,82.97,82.59,81.56,82.12,80.94,81.81,83.66,84.69,86.0,85.44,86.69,86.0,86.12,86.94,87.09,87.91,87.56,87.0,86.41,84.81,84.16,84.69,84.5,84.94,86.19,86.88,87.06,88.56,89.81,90.06,90.56,62.41,61.16,62.03,62.75,64.0,65.94,67.72,70.56,72.25,74.34,74.66,77.41,76.88,77.66,76.25,75.91,75.22,73.19:103.62,105.06,107.31,108.75,107.19,103.06,102.06,98.44,97.31,99.31,101.81,105.0,108.22,109.12,112.06,112.81,113.75,115.69,118.06,119.28,119.56,118.31,117.03,112.34,111.5,110.0,109.06,110.5,111.56,111.69,113.06,113.69,113.88,113.5,113.59,112.25,111.75,110.38,108.75,106.5,104.28,102.31,101.03,99.19,97.81,95.69,94.19,91.69,89.84,88.66,89.09,88.78,89.69,91.12,92.5,92.91,93.66,93.81,94.62,94.56,97.56,97.81,99.28,98.91,99.5,99.81,100.12,100.88,101.75,101.38,100.66,99.75,100.66,99.56,98.75,97.28,97.44,96.38,96.03,96.94,98.12,98.19,99.5,100.44,100.56,98.94,101.31,101.22,103.0,106.03,110.5,113.81,116.5,116.62,117.12,115.06,112.75,110.12,106.69,104.78,103.0,100.38,99.81,98.12,96.88,95.28,95.94,96.06,98.12,99.0,99.66,99.62,98.94,98.19,96.56,96.88,98.75,98.06,97.44,100.81,98.56,98.31,99.12,99.12,101.12,102.31,104.41,106.41,106.69,107.03,107.19,105.0,105.25,104.06,103.06,103.25,103.12,102.81,104.38,104.12,104.38,103.69,103.5,102.62,101.72,101.81,103.69,104.88,106.56,107.94,107.19,107.12,106.81,107.69,107.44,109.91,111.31,110.88,111.88,110.81,109.41,110.0,108.31,107.34,106.22,105.56,103.62,102.5,101.5,99.94,98.81,97.88,100.03,101.0,102.16,102.81,103.91,104.5,102.69,103.97,104.06,103.69,104.47,104.91,106.5,105.06,103.94,101.81,100.0,96.5,95.06,95.94,95.19,95.69,96.66,95.34,96.19,94.81,93.62,93.31,92.06,92.62,91.5,93.5,93.56,92.31,92.12,91.69,91.06,91.56,93.5,95.69,98.06,99.19,101.72,102.31,102.44,101.31,101.53,100.25,98.0,97.44,96.34,94.56,96.91,97.19,98.94,101.44,102.62,101.25,103.0,101.94,100.88,101.69,100.69,99.12,98.5,95.44,93.62,93.0,93.06,94.06,96.75,99.0,101.31,102.38,102.94,101.44,99.94,97.09,94.31,92.25,90.56,89.94,90.0,89.34,91.44,92.62,94.81,95.38,96.28,96.5,97.16,96.94,99.0,100.88,101.62,102.0,102.12,101.0,100.0,101.25,100.88,101.56,101.62,103.25,102.56,102.0,100.25,97.28,94.06,92.62,92.0,92.47,93.62,95.62,96.81,97.44,97.94,99.38,98.03,98.28,96.66,96.44,95.78,95.0,95.12,94.16,95.5,96.25,97.62,100.94,102.62,105.56,110.62,112.88,116.81,120.31,121.25,120.28,119.25,117.78,114.62,113.66,112.94,112.56,109.75,109.81,108.44,107.62,107.53,108.66,109.69,111.25,112.34,112.72,113.94,113.0,112.56,113.12,113.5,114.0,116.06,115.5,113.81,111.44,109.31,106.75,105.12,103.81,103.31,101.94,102.0,102.0,104.31,106.03,108.25,109.53,110.56,110.41,109.62,108.94,108.94,108.25,107.31,106.5,106.75,107.66,108.91,110.31,112.62,113.81,115.62,114.31,114.16,114.38,112.41,111.69,112.12,110.69,111.97,111.59,112.0,111.06,110.94,110.19,109.94,109.0,108.56,109.12,108.94,109.44,108.84,109.69,106.81,105.44,101.47,99.06,98.78,97.25,97.19,96.91,94.84,92.97,90.16,88.12,87.19,86.94,88.91,90.44,91.81,91.81,92.81,91.19,91.69,92.12,93.5,95.59,96.84,98.31,98.56,98.25,97.94,98.31,97.47,97.56,97.16,97.84,96.78,97.62,97.25,98.78,97.81,99.56,100.06,101.47,101.62,101.06,102.25,102.56,101.41,102.44,104.09,104.19,104.5,105.88,105.72,104.5,103.25,101.44,100.59,99.75,99.38,99.19,98.91,97.75,96.62,95.16,95.12,93.12,91.03,89.88,87.44,85.31,85.09,84.31,84.56,86.19,88.0,88.5,89.81,92.12,92.28,94.06,97.25,98.12,98.62,96.28,95.62,92.94,90.41,90.81,90.38,90.0,89.84,88.91,90.25,90.19,91.12,92.25,93.0,94.38,95.19,95.84,95.31,97.81,97.12,98.34,97.66,98.19,97.06,97.44,95.88,97.62,98.19,99.41,101.62,102.75,103.56,104.81,104.12,103.06,103.66,100.28,100.66,100.03,98.31,98.41,98.34,100.5,101.47,103.28,105.75,108.34,110.38,110.81,111.59,110.53,108.06,105.75,102.56,100.41,101.19,99.0,98.41,98.56,96.75,95.16,93.97,93.25,92.0,90.38,90.38,89.94,89.38,90.25,92.0,93.62,95.06,97.34,98.53,99.28,99.84,97.91,99.06,95.0,94.31,94.25,92.06,90.81,91.53,90.75,91.0,91.06,91.88,92.94,93.53,95.03,95.66,95.81,95.97,96.0,96.19,96.69,97.81,97.56,99.25,98.88,98.88,100.06,100.38,100.16,100.0,100.88,100.5,99.06,99.94,101.19,102.75,105.03,108.5,110.03,110.41,110.56,109.06,109.38,107.12,106.94,105.5,104.56,103.44,102.94,103.97,104.56,105.31,105.81,105.88,104.69,104.19,103.06,104.06,101.69,102.0,100.56,99.31,97.25,94.62,93.44,92.69,90.81,92.31,93.0,93.06,95.19,95.69,98.06,97.94,97.56,96.03,94.41,90.81,89.47,89.12,88.16,88.75,89.56,88.19,86.25,84.94,83.16,81.94,82.81,83.91,86.25,86.16,87.69,89.56,90.44,90.75,93.44,94.53,95.72,95.94,96.69,96.94,97.41,97.62,98.22,97.66,97.62,97.19,97.78,98.06,99.75,99.88,99.38,99.31,96.75,97.31,96.69,96.12,97.12,97.41,98.56,97.5,97.72,98.12,97.81,97.81,97.16,98.16,98.44,96.62,97.75,97.56,98.56,98.19,99.94,100.0,99.75,99.66,96.59,95.75,94.25,92.62,93.47,93.25,94.62,95.31,96.16,96.5,97.47,98.31,99.56,100.19,100.78,102.88,103.0,104.31,105.06,104.94,105.72,104.12,103.44,103.41,102.94,101.88,102.31,100.12,100.69,99.94,98.38,99.75,99.59,98.28,98.16,97.38,97.75,97.0,99.31,101.56,103.12,106.78,108.06,108.16,105.5,103.44,99.38,96.12,93.5,91.03,88.25,84.88,79.88,73.81,67.25,61.0,55.81,50.91,47.0,45.06,42.69,42.25,41.78,44.09,46.78,49.81,52.84,56.19,58.09,60.56,61.44,62.94,64.5,65.44,66.41,67.25,66.88,66.34,65.06,64.0,63.44,66.19,69.25,72.97,76.69,79.75,80.25,78.81,79.44,77.88,78.03,78.69,79.56,80.81,82.0,82.38,84.56,86.16,88.25,89.94,93.56,96.0,98.94,100.38,101.78,103.78,103.44,105.25,104.56,106.12,105.31,105.31,105.62,104.75,105.12,105.25,105.12,104.25,103.25,100.94,100.19,98.91,98.28,98.44,96.0,95.69,93.16,91.12,89.56,88.12,87.5,87.06,88.31,90.94,92.09,94.47,95.69,95.19,95.88,95.38,95.81,95.12,95.31,95.56,94.88,94.19,93.06,90.69,87.88,85.56,81.81,80.94,80.69,79.44,80.44,81.62,81.88,82.5,83.06,83.81,82.97,82.59,81.56,82.12,80.94,81.81,83.66,84.69,86.0,85.44,86.69,86.0,86.12,86.94,87.09,87.91,87.56,87.0,86.41,84.81,84.16,84.69,84.5,84.94,86.19,86.88,87.06,88.56,89.81,90.06,90.56,62.41,61.16,62.03,62.75,64.0,65.94,67.72,70.56,72.25,74.34,74.66,77.41,76.88,77.66,76.25,75.91,75.22,73.19,72.56,70.44,67.75,65.59,64.59,64.41:102.06,98.44,97.31,99.31,101.81,105.0,108.22,109.12,112.06,112.81,113.75,115.69,118.06,119.28,119.56,118.31,117.03,112.34,111.5,110.0,109.06,110.5,111.56,111.69,113.06,113.69,113.88,113.5,113.59,112.25,111.75,110.38,108.75,106.5,104.28,102.31,101.03,99.19,97.81,95.69,94.19,91.69,89.84,88.66,89.09,88.78,89.69,91.12,92.5,92.91,93.66,93.81,94.62,94.56,97.56,97.81,99.28,98.91,99.5,99.81,100.12,100.88,101.75,101.38,100.66,99.75,100.66,99.56,98.75,97.28,97.44,96.38,96.03,96.94,98.12,98.19,99.5,100.44,100.56,98.94,101.31,101.22,103.0,106.03,110.5,113.81,116.5,116.62,117.12,115.06,112.75,110.12,106.69,104.78,103.0,100.38,99.81,98.12,96.88,95.28,95.94,96.06,98.12,99.0,99.66,99.62,98.94,98.19,96.56,96.88,98.75,98.06,97.44,100.81,98.56,98.31,99.12,99.12,101.12,102.31,104.41,106.41,106.69,107.03,107.19,105.0,105.25,104.06,103.06,103.25,103.12,102.81,104.38,104.12,104.38,103.69,103.5,102.62,101.72,101.81,103.69,104.88,106.56,107.94,107.19,107.12,106.81,107.69,107.44,109.91,111.31,110.88,111.88,110.81,109.41,110.0,108.31,107.34,106.22,105.56,103.62,102.5,101.5,99.94,98.81,97.88,100.03,101.0,102.16,102.81,103.91,104.5,102.69,103.97,104.06,103.69,104.47,104.91,106.5,105.06,103.94,101.81,100.0,96.5,95.06,95.94,95.19,95.69,96.66,95.34,96.19,94.81,93.62,93.31,92.06,92.62,91.5,93.5,93.56,92.31,92.12,91.69,91.06,91.56,93.5,95.69,98.06,99.19,101.72,102.31,102.44,101.31,101.53,100.25,98.0,97.44,96.34,94.56,96.91,97.19,98.94,101.44,102.62,101.25,103.0,101.94,100.88,101.69,100.69,99.12,98.5,95.44,93.62,93.0,93.06,94.06,96.75,99.0,101.31,102.38,102.94,101.44,99.94,97.09,94.31,92.25,90.56,89.94,90.0,89.34,91.44,92.62,94.81,95.38,96.28,96.5,97.16,96.94,99.0,100.88,101.62,102.0,102.12,101.0,100.0,101.25,100.88,101.56,101.62,103.25,102.56,102.0,100.25,97.28,94.06,92.62,92.0,92.47,93.62,95.62,96.81,97.44,97.94,99.38,98.03,98.28,96.66,96.44,95.78,95.0,95.12,94.16,95.5,96.25,97.62,100.94,102.62,105.56,110.62,112.88,116.81,120.31,121.25,120.28,119.25,117.78,114.62,113.66,112.94,112.56,109.75,109.81,108.44,107.62,107.53,108.66,109.69,111.25,112.34,112.72,113.94,113.0,112.56,113.12,113.5,114.0,116.06,115.5,113.81,111.44,109.31,106.75,105.12,103.81,103.31,101.94,102.0,102.0,104.31,106.03,108.25,109.53,110.56,110.41,109.62,108.94,108.94,108.25,107.31,106.5,106.75,107.66,108.91,110.31,112.62,113.81,115.62,114.31,114.16,114.38,112.41,111.69,112.12,110.69,111.97,111.59,112.0,111.06,110.94,110.19,109.94,109.0,108.56,109.12,108.94,109.44,108.84,109.69,106.81,105.44,101.47,99.06,98.78,97.25,97.19,96.91,94.84,92.97,90.16,88.12,87.19,86.94,88.91,90.44,91.81,91.81,92.81,91.19,91.69,92.12,93.5,95.59,96.84,98.31,98.56,98.25,97.94,98.31,97.47,97.56,97.16,97.84,96.78,97.62,97.25,98.78,97.81,99.56,100.06,101.47,101.62,101.06,102.25,102.56,101.41,102.44,104.09,104.19,104.5,105.88,105.72,104.5,103.25,101.44,100.59,99.75,99.38,99.19,98.91,97.75,96.62,95.16,95.12,93.12,91.03,89.88,87.44,85.31,85.09,84.31,84.56,86.19,88.0,88.5,89.81,92.12,92.28,94.06,97.25,98.12,98.62,96.28,95.62,92.94,90.41,90.81,90.38,90.0,89.84,88.91,90.25,90.19,91.12,92.25,93.0,94.38,95.19,95.84,95.31,97.81,97.12,98.34,97.66,98.19,97.06,97.44,95.88,97.62,98.19,99.41,101.62,102.75,103.56,104.81,104.12,103.06,103.66,100.28,100.66,100.03,98.31,98.41,98.34,100.5,101.47,103.28,105.75,108.34,110.38,110.81,111.59,110.53,108.06,105.75,102.56,100.41,101.19,99.0,98.41,98.56,96.75,95.16,93.97,93.25,92.0,90.38,90.38,89.94,89.38,90.25,92.0,93.62,95.06,97.34,98.53,99.28,99.84,97.91,99.06,95.0,94.31,94.25,92.06,90.81,91.53,90.75,91.0,91.06,91.88,92.94,93.53,95.03,95.66,95.81,95.97,96.0,96.19,96.69,97.81,97.56,99.25,98.88,98.88,100.06,100.38,100.16,100.0,100.88,100.5,99.06,99.94,101.19,102.75,105.03,108.5,110.03,110.41,110.56,109.06,109.38,107.12,106.94,105.5,104.56,103.44,102.94,103.97,104.56,105.31,105.81,105.88,104.69,104.19,103.06,104.06,101.69,102.0,100.56,99.31,97.25,94.62,93.44,92.69,90.81,92.31,93.0,93.06,95.19,95.69,98.06,97.94,97.56,96.03,94.41,90.81,89.47,89.12,88.16,88.75,89.56,88.19,86.25,84.94,83.16,81.94,82.81,83.91,86.25,86.16,87.69,89.56,90.44,90.75,93.44,94.53,95.72,95.94,96.69,96.94,97.41,97.62,98.22,97.66,97.62,97.19,97.78,98.06,99.75,99.88,99.38,99.31,96.75,97.31,96.69,96.12,97.12,97.41,98.56,97.5,97.72,98.12,97.81,97.81,97.16,98.16,98.44,96.62,97.75,97.56,98.56,98.19,99.94,100.0,99.75,99.66,96.59,95.75,94.25,92.62,93.47,93.25,94.62,95.31,96.16,96.5,97.47,98.31,99.56,100.19,100.78,102.88,103.0,104.31,105.06,104.94,105.72,104.12,103.44,103.41,102.94,101.88,102.31,100.12,100.69,99.94,98.38,99.75,99.59,98.28,98.16,97.38,97.75,97.0,99.31,101.56,103.12,106.78,108.06,108.16,105.5,103.44,99.38,96.12,93.5,91.03,88.25,84.88,79.88,73.81,67.25,61.0,55.81,50.91,47.0,45.06,42.69,42.25,41.78,44.09,46.78,49.81,52.84,56.19,58.09,60.56,61.44,62.94,64.5,65.44,66.41,67.25,66.88,66.34,65.06,64.0,63.44,66.19,69.25,72.97,76.69,79.75,80.25,78.81,79.44,77.88,78.03,78.69,79.56,80.81,82.0,82.38,84.56,86.16,88.25,89.94,93.56,96.0,98.94,100.38,101.78,103.78,103.44,105.25,104.56,106.12,105.31,105.31,105.62,104.75,105.12,105.25,105.12,104.25,103.25,100.94,100.19,98.91,98.28,98.44,96.0,95.69,93.16,91.12,89.56,88.12,87.5,87.06,88.31,90.94,92.09,94.47,95.69,95.19,95.88,95.38,95.81,95.12,95.31,95.56,94.88,94.19,93.06,90.69,87.88,85.56,81.81,80.94,80.69,79.44,80.44,81.62,81.88,82.5,83.06,83.81,82.97,82.59,81.56,82.12,80.94,81.81,83.66,84.69,86.0,85.44,86.69,86.0,86.12,86.94,87.09,87.91,87.56,87.0,86.41,84.81,84.16,84.69,84.5,84.94,86.19,86.88,87.06,88.56,89.81,90.06,90.56,62.41,61.16,62.03,62.75,64.0,65.94,67.72,70.56,72.25,74.34,74.66,77.41,76.88,77.66,76.25,75.91,75.22,73.19,72.56,70.44,67.75,65.59,64.59,64.41,66.44,69.66,71.72,72.53,72.81,69.31:negativity
36.53,40.06,42.09,44.12,44.66,44.66,42.44,40.78,39.28,37.31,39.03,40.12,40.81,42.28,43.06,42.72,42.94,44.0,43.38,44.25,43.69,42.56,41.19,38.31,35.84,34.09,31.31,30.09,29.91,30.72,31.44,33.16,35.69,37.41,38.06,38.53,38.5,37.38,36.59,35.0,36.09,36.88,36.84,38.47,37.91,37.44,38.78,39.69,39.69,40.5,40.81,39.5,37.94,37.56,35.75,35.31,34.56,34.16,32.62,32.16,31.03,29.59,27.78,26.44,24.03,21.69,21.03,20.5,20.91,22.38,22.53,23.38,23.94,25.34,25.81,27.12,27.47,28.78,30.28,30.44,31.59,32.56,33.12,32.66,34.06,34.62,34.81,34.5,35.41,35.12,34.62,35.03,35.12,34.84,34.72,34.16,33.16,32.03,33.25,33.09,33.84,34.53,34.78,35.31,36.31,35.84,35.78,36.12,36.66,36.38,37.38,38.12,38.81,40.25,42.19,44.31,47.72,50.5,54.16,56.56,58.16,59.06,57.47,55.0,52.91,50.06,48.28,47.5,46.12,45.69,44.66,43.12,41.97,40.56,40.44,39.31,40.34,41.19,41.69,42.66,43.44,43.41,42.62,41.56,40.47,40.53,41.0,42.06,42.34,42.56,43.81,43.19,43.03,43.5,42.91,41.75,42.31,42.03,42.97,43.56,45.03,47.12,49.03,51.69,53.81,56.06,55.88,55.69,55.88,55.0,54.62,55.47,57.34,58.47,60.84,63.34,62.81,63.41,62.38,60.44,59.28,58.47,57.44,58.38,58.06,57.66,58.0,58.25,58.38,58.25,58.66,57.88,56.97,56.59,54.41,52.56,51.25,49.78,48.88,48.16,47.34,46.94,46.31,46.28,45.31,45.19,44.44,43.22,41.81,41.19,42.25,42.06,43.31,44.5,45.06,45.72,46.25,46.81,46.53,46.72,46.78,45.5,47.41,47.91,48.59,51.53,51.28,50.38,49.31,47.66,46.81,45.59,44.56,44.88,42.34,40.19,36.47,33.81,30.22,28.22,27.91,27.81,29.09,29.81,30.53,31.19,29.03,27.47,26.69,25.94,27.25,28.59,31.03,34.5,37.09,39.62,41.25,42.88,42.91,41.47,40.12,38.31,36.31,35.62,35.34,34.41,35.19,34.66,36.12,37.31,37.59,40.0,40.44,39.66,39.97,39.72,39.44,40.62,42.03,41.66,42.91,41.88,41.62,41.25,39.81,39.28,38.75,36.09,35.31,35.12,34.31,33.66,33.56,32.78,31.59,31.0,29.88,29.28,28.41,28.81,29.5,30.38,30.94,32.16,34.09,34.12,34.91,35.28,34.5,32.56,33.78,31.88,32.34,33.47,34.25,34.28,33.44,34.53,33.44,34.5,35.06,35.16,36.41,35.94,35.25,35.41,35.22,34.12,33.81,34.28,33.53,32.81,31.94,30.91,28.0,26.62,25.16,24.28,24.19,25.06,27.16,28.5,31.06,34.94,37.84,41.56,45.97,48.75,49.69,48.53,47.66,44.03,40.22,36.84,34.53,32.78,30.5,29.66,30.25,28.62,29.81,29.94,29.53,30.5,30.56,30.81,30.25,31.03,31.31,30.81,31.72,32.28,32.25,32.16,31.06,31.0,30.12,28.81,27.94,27.41,28.0,28.06,28.69,30.66,30.78,30.41,30.69,30.78,29.91,31.72,32.28,34.66,34.88,35.72,35.38,35.75,36.28,37.81,40.66,41.94,45.25,46.28,46.91,47.28,48.03,48.94,48.75,49.31,51.0,50.47,50.38,51.38,52.5,53.28,53.62,53.31,53.03,51.78,51.25,49.5,49.09,47.34,45.69,43.12,42.94,41.06,40.47,40.78,40.12,38.06,37.97,36.81,36.03,35.47,33.66,34.94,32.91,32.62,33.19,33.31,33.28,33.91,35.31,34.06,34.56,33.0,31.06,31.97,30.53,30.0,30.0,29.88,29.81,30.62,32.16,34.38,35.88,38.66,39.91,39.41,39.03,37.69,36.81,36.25,36.06,35.56,34.5,32.81,29.5,29.69,27.12,26.69,26.06,26.66,25.88,26.75,26.06,25.69,27.66,26.91,28.19,27.84,28.28,27.81,27.75,27.75,26.88,26.31,25.41,26.75,26.16,27.41,28.97,29.47,32.0,32.22,33.94,33.12,31.03,27.75,25.22,21.75,20.47,19.53,20.22,19.56,19.69,21.06,21.62,23.81,26.09,27.69,29.97,29.75,30.84,30.31,30.81,30.81,31.31,31.88,31.78,32.28,32.62,33.06,34.78,35.75,37.12,36.44,36.56,37.12,36.44,36.03,36.38,36.78,36.56,34.44,34.62,34.06,32.75,32.78,32.06,32.28,32.66,33.5,34.25,35.28,35.69,35.75,36.12,35.91,35.44,35.16,34.75,33.62,31.97,31.75,30.84,30.41,31.06,30.94,30.19,28.91,26.84,25.25,22.06,20.56,20.75,20.06,23.09,26.31,30.16,33.56,35.75,35.81,35.34,32.78,30.94,29.03,27.78,27.62,27.91,28.81,29.06,30.5,31.41,31.06,32.78,31.56,31.25,31.78,30.97,31.5,31.09,30.91,29.78,28.69,28.09,26.31,27.25,27.41,28.22,30.72,33.28,35.12,36.12,39.25,40.12,40.84,39.94,38.62,37.34,35.44,34.62,33.34,32.66,32.84,31.06,30.84,29.25,27.34,25.66,24.28,22.5,23.06,24.0,24.56,24.62,26.88,26.56,27.5,28.22,27.25,30.06,30.88,33.12,36.38,37.88,40.03,40.69,41.66,42.62,43.44,43.38,43.62,43.31,41.69,41.12,41.0,41.47,42.19,42.97,43.34,43.28,42.38,41.16,41.12,40.16,37.0,35.81,34.66,32.72,31.44,32.16,31.47,30.28,29.25,27.78,25.56,24.03,23.91,23.34,22.53,23.47,23.44,22.78,24.44,25.62,26.53,27.38,28.03,27.94,27.62,27.19,28.53,29.81,32.19,35.06,35.03,36.16,34.69,33.12,33.31,33.41,34.78,35.28,36.28,36.56,36.72,35.53,35.66,35.12,33.94,33.75,33.75,34.0,34.31,36.88,38.69,41.16,43.03,45.5,46.72,47.09,47.31,47.09,46.34,45.81,43.91,42.88,40.03,38.72,38.44,39.06,39.94,40.84,41.66,41.94,40.81,40.19,38.91,36.81,36.09,35.41,35.5,37.31,38.62,39.84,41.12,41.53,41.78,40.81,41.41,41.06,38.81,38.75,38.97,38.91,39.03,41.12,42.62,43.31,45.31,44.56,45.03,44.31,43.5,43.12,42.41,42.62,43.12,42.94,43.62,42.03,41.66,39.88,38.5,39.41,39.81,41.91,43.62,45.12,44.88,44.34,43.44,41.16,39.91,38.19,36.88,37.19,35.31,35.19,34.44,34.5,33.53,32.47,32.69,31.5,31.72,31.59,30.41,29.28,27.06,26.81,24.19,24.16,24.03,25.38,27.0,29.62,33.03,35.19,36.5,36.53,35.81,34.41,32.94,34.28,33.56,33.06,32.44,31.31,30.16,28.19,28.19,27.78,27.84,28.25,29.81,31.38,32.91,34.47,35.5,34.44,32.94,31.41,28.94,27.34,25.78,25.31,24.94,24.69,24.03,26.53,26.19,27.31,28.69,29.62,30.25,30.94,31.53,32.31,31.81,33.31,33.81,34.28,33.78,33.62,33.22,31.88,31.97,32.25,32.31,32.75,33.31,32.5,32.34,30.88,29.56,26.91,24.97,21.94,18.09,15.5,12.69,11.34,8.81,8.94,9.16,8.91,10.62,12.06,14.03,15.16,15.94,15.81,14.12,12.94,11.69,11.0,11.16,11.31,11.59,12.31,13.38,11.66,11.16,9.91,8.53,6.84,5.31,4.66,4.31,3.94,4.91,4.94,6.06:42.44,40.78,39.28,37.31,39.03,40.12,40.81,42.28,43.06,42.72,42.94,44.0,43.38,44.25,43.69,42.56,41.19,38.31,35.84,34.09,31.31,30.09,29.91,30.72,31.44,33.16,35.69,37.41,38.06,38.53,38.5,37.38,36.59,35.0,36.09,36.88,36.84,38.47,37.91,37.44,38.78,39.69,39.69,40.5,40.81,39.5,37.94,37.56,35.75,35.31,34.56,34.16,32.62,32.16,31.03,29.59,27.78,26.44,24.03,21.69,21.03,20.5,20.91,22.38,22.53,23.38,23.94,25.34,25.81,27.12,27.47,28.78,30.28,30.44,31.59,32.56,33.12,32.66,34.06,34.62,34.81,34.5,35.41,35.12,34.62,35.03,35.12,34.84,34.72,34.16,33.16,32.03,33.25,33.09,33.84,34.53,34.78,35.31,36.31,35.84,35.78,36.12,36.66,36.38,37.38,38.12,38.81,40.25,42.19,44.31,47.72,50.5,54.16,56.56,58.16,59.06,57.47,55.0,52.91,50.06,48.28,47.5,46.12,45.69,44.66,43.12,41.97,40.56,40.44,39.31,40.34,41.19,41.69,42.66,43.44,43.41,42.62,41.56,40.47,40.53,41.0,42.06,42.34,42.56,43.81,43.19,43.03,43.5,42.91,41.75,42.31,42.03,42.97,43.56,45.03,47.12,49.03,51.69,53.81,56.06,55.88,55.69,55.88,55.0,54.62,55.47,57.34,58.47,60.84,63.34,62.81,63.41,62.38,60.44,59.28,58.47,57.44,58.38,58.06,57.66,58.0,58.25,58.38,58.25,58.66,57.88,56.97,56.59,54.41,52.56,51.25,49.78,48.88,48.16,47.34,46.94,46.31,46.28,45.31,45.19,44.44,43.22,41.81,41.19,42.25,42.06,43.31,44.5,45.06,45.72,46.25,46.81,46.53,46.72,46.78,45.5,47.41,47.91,48.59,51.53,51.28,50.38,49.31,47.66,46.81,45.59,44.56,44.88,42.34,40.19,36.47,33.81,30.22,28.22,27.91,27.81,29.09,29.81,30.53,31.19,29.03,27.47,26.69,25.94,27.25,28.59,31.03,34.5,37.09,39.62,41.25,42.88,42.91,41.47,40.12,38.31,36.31,35.62,35.34,34.41,35.19,34.66,36.12,37.31,37.59,40.0,40.44,39.66,39.97,39.72,39.44,40.62,42.03,41.66,42.91,41.88,41.62,41.25,39.81,39.28,38.75,36.09,35.31,35.12,34.31,33.66,33.56,32.78,31.59,31.0,29.88,29.28,28.41,28.81,29.5,30.38,30.94,32.16,34.09,34.12,34.91,35.28,34.5,32.56,33.78,31.88,32.34,33.47,34.25,34.28,33.44,34.53,33.44,34.5,35.06,35.16,36.41,35.94,35.25,35.41,35.22,34.12,33.81,34.28,33.53,32.81,31.94,30.91,28.0,26.62,25.16,24.28,24.19,25.06,27.16,28.5,31.06,34.94,37.84,41.56,45.97,48.75,49.69,48.53,47.66,44.03,40.22,36.84,34.53,32.78,30.5,29.66,30.25,28.62,29.81,29.94,29.53,30.5,30.56,30.81,30.25,31.03,31.31,30.81,31.72,32.28,32.25,32.16,31.06,31.0,30.12,28.81,27.94,27.41,28.0,28.06,28.69,30.66,30.78,30.41,30.69,30.78,29.91,31.72,32.28,34.66,34.88,35.72,35.38,35.75,36.28,37.81,40.66,41.94,45.25,46.28,46.91,47.28,48.03,48.94,48.75,49.31,51.0,50.47,50.38,51.38,52.5,53.28,53.62,53.31,53.03,51.78,51.25,49.5,49.09,47.34,45.69,43.12,42.94,41.06,40.47,40.78,40.12,38.06,37.97,36.81,36.03,35.47,33.66,34.94,32.91,32.62,33.19,33.31,33.28,33.91,35.31,34.06,34.56,33.0,31.06,31.97,30.53,30.0,30.0,29.88,29.81,30.62,32.16,34.38,35.88,38.66,39.91,39.41,39.03,37.69,36.81,36.25,36.06,35.56,34.5,32.81,29.5,29.69,27.12,26.69,26.06,26.66,25.88,26.75,26.06,25.69,27.66,26.91,28.19,27.84,28.28,27.81,27.75,27.75,26.88,26.31,25.41,26.75,26.16,27.41,28.97,29.47,32.0,32.22,33.94,33.12,31.03,27.75,25.22,21.75,20.47,19.53,20.22,19.56,19.69,21.06,21.62,23.81,26.09,27.69,29.97,29.75,30.84,30.31,30.81,30.81,31.31,31.88,31.78,32.28,32.62,33.06,34.78,35.75,37.12,36.44,36.56,37.12,36.44,36.03,36.38,36.78,36.56,34.44,34.62,34.06,32.75,32.78,32.06,32.28,32.66,33.5,34.25,35.28,35.69,35.75,36.12,35.91,35.44,35.16,34.75,33.62,31.97,31.75,30.84,30.41,31.06,30.94,30.19,28.91,26.84,25.25,22.06,20.56,20.75,20.06,23.09,26.31,30.16,33.56,35.75,35.81,35.34,32.78,30.94,29.03,27.78,27.62,27.91,28.81,29.06,30.5,31.41,31.06,32.78,31.56,31.25,31.78,30.97,31.5,31.09,30.91,29.78,28.69,28.09,26.31,27.25,27.41,28.22,30.72,33.28,35.12,36.12,39.25,40.12,40.84,39.94,38.62,37.34,35.44,34.62,33.34,32.66,32.84,31.06,30.84,29.25,27.34,25.66,24.28,22.5,23.06,24.0,24.56,24.62,26.88,26.56,27.5,28.22,27.25,30.06,30.88,33.12,36.38,37.88,40.03,40.69,41.66,42.62,43.44,43.38,43.62,43.31,41.69,41.12,41.0,41.47,42.19,42.97,43.34,43.28,42.38,41.16,41.12,40.16,37.0,35.81,34.66,32.72,31.44,32.16,31.47,30.28,29.25,27.78,25.56,24.03,23.91,23.34,22.53,23.47,23.44,22.78,24.44,25.62,26.53,27.38,28.03,27.94,27.62,27.19,28.53,29.81,32.19,35.06,35.03,36.16,34.69,33.12,33.31,33.41,34.78,35.28,36.28,36.56,36.72,35.53,35.66,35.12,33.94,33.75,33.75,34.0,34.31,36.88,38.69,41.16,43.03,45.5,46.72,47.09,47.31,47.09,46.34,45.81,43.91,42.88,40.03,38.72,38.44,39.06,39.94,40.84,41.66,41.94,40.81,40.19,38.91,36.81,36.09,35.41,35.5,37.31,38.62,39.84,41.12,41.53,41.78,40.81,41.41,41.06,38.81,38.75,38.97,38.91,39.03,41.12,42.62,43.31,45.31,44.56,45.03,44.31,43.5,43.12,42.41,42.62,43.12,42.94,43.62,42.03,41.66,39.88,38.5,39.41,39.81,41.91,43.62,45.12,44.88,44.34,43.44,41.16,39.91,38.19,36.88,37.19,35.31,35.19,34.44,34.5,33.53,32.47,32.69,31.5,31.72,31.59,30.41,29.28,27.06,26.81,24.19,24.16,24.03,25.38,27.0,29.62,33.03,35.19,36.5,36.53,35.81,34.41,32.94,34.28,33.56,33.06,32.44,31.31,30.16,28.19,28.19,27.78,27.84,28.25,29.81,31.38,32.91,34.47,35.5,34.44,32.94,31.41,28.94,27.34,25.78,25.31,24.94,24.69,24.03,26.53,26.19,27.31,28.69,29.62,30.25,30.94,31.53,32.31,31.81,33.31,33.81,34.28,33.78,33.62,33.22,31.88,31.97,32.25,32.31,32.75,33.31,32.5,32.34,30.88,29.56,26.91,24.97,21.94,18.09,15.5,12.69,11.34,8.81,8.94,9.16,8.91,10.62,12.06,14.03,15.16,15.94,15.81,14.12,12.94,11.69,11.0,11.16,11.31,11.59,12.31,13.38,11.66,11.16,9.91,8.53,6.84,5.31,4.66,4.31,3.94,4.91,4.94,6.06,31.44,35.5,37.62,39.16,40.69,40.28:40.81,42.28,43.06,42.72,42.94,44.0,43.38,44.25,43.69,42.56,41.19,38.31,35.84,34.09,31.31,30.09,29.91,30.72,31.44,33.16,35.69,37.41,38.06,38.53,38.5,37.38,36.59,35.0,36.09,36.88,36.84,38.47,37.91,37.44,38.78,39.69,39.69,40.5,40.81,39.5,37.94,37.56,35.75,35.31,34.56,34.16,32.62,32.16,31.03,29.59,27.78,26.44,24.03,21.69,21.03,20.5,20.91,22.38,22.53,23.38,23.94,25.34,25.81,27.12,27.47,28.78,30.28,30.44,31.59,32.56,33.12,32.66,34.06,34.62,34.81,34.5,35.41,35.12,34.62,35.03,35.12,34.84,34.72,34.16,33.16,32.03,33.25,33.09,33.84,34.53,34.78,35.31,36.31,35.84,35.78,36.12,36.66,36.38,37.38,38.12,38.81,40.25,42.19,44.31,47.72,50.5,54.16,56.56,58.16,59.06,57.47,55.0,52.91,50.06,48.28,47.5,46.12,45.69,44.66,43.12,41.97,40.56,40.44,39.31,40.34,41.19,41.69,42.66,43.44,43.41,42.62,41.56,40.47,40.53,41.0,42.06,42.34,42.56,43.81,43.19,43.03,43.5,42.91,41.75,42.31,42.03,42.97,43.56,45.03,47.12,49.03,51.69,53.81,56.06,55.88,55.69,55.88,55.0,54.62,55.47,57.34,58.47,60.84,63.34,62.81,63.41,62.38,60.44,59.28,58.47,57.44,58.38,58.06,57.66,58.0,58.25,58.38,58.25,58.66,57.88,56.97,56.59,54.41,52.56,51.25,49.78,48.88,48.16,47.34,46.94,46.31,46.28,45.31,45.19,44.44,43.22,41.81,41.19,42.25,42.06,43.31,44.5,45.06,45.72,46.25,46.81,46.53,46.72,46.78,45.5,47.41,47.91,48.59,51.53,51.28,50.38,49.31,47.66,46.81,45.59,44.56,44.88,42.34,40.19,36.47,33.81,30.22,28.22,27.91,27.81,29.09,29.81,30.53,31.19,29.03,27.47,26.69,25.94,27.25,28.59,31.03,34.5,37.09,39.62,41.25,42.88,42.91,41.47,40.12,38.31,36.31,35.62,35.34,34.41,35.19,34.66,36.12,37.31,37.59,40.0,40.44,39.66,39.97,39.72,39.44,40.62,42.03,41.66,42.91,41.88,41.62,41.25,39.81,39.28,38.75,36.09,35.31,35.12,34.31,33.66,33.56,32.78,31.59,31.0,29.88,29.28,28.41,28.81,29.5,30.38,30.94,32.16,34.09,34.12,34.91,35.28,34.5,32.56,33.78,31.88,32.34,33.47,34.25,34.28,33.44,34.53,33.44,34.5,35.06,35.16,36.41,35.94,35.25,35.41,35.22,34.12,33.81,34.28,33.53,32.81,31.94,30.91,28.0,26.62,25.16,24.28,24.19,25.06,27.16,28.5,31.06,34.94,37.84,41.56,45.97,48.75,49.69,48.53,47.66,44.03,40.22,36.84,34.53,32.78,30.5,29.66,30.25,28.62,29.81,29.94,29.53,30.5,30.56,30.81,30.25,31.03,31.31,30.81,31.72,32.28,32.25,32.16,31.06,31.0,30.12,28.81,27.94,27.41,28.0,28.06,28.69,30.66,30.78,30.41,30.69,30.78,29.91,31.72,32.28,34.66,34.88,35.72,35.38,35.75,36.28,37.81,40.66,41.94,45.25,46.28,46.91,47.28,48.03,48.94,48.75,49.31,51.0,50.47,50.38,51.38,52.5,53.28,53.62,53.31,53.03,51.78,51.25,49.5,49.09,47.34,45.69,43.12,42.94,41.06,40.47,40.78,40.12,38.06,37.97,36.81,36.03,35.47,33.66,34.94,32.91,32.62,33.19,33.31,33.28,33.91,35.31,34.06,34.56,33.0,31.06,31.97,30.53,30.0,30.0,29.88,29.81,30.62,32.16,34.38,35.88,38.66,39.91,39.41,39.03,37.69,36.81,36.25,36.06,35.56,34.5,32.81,29.5,29.69,27.12,26.69,26.06,26.66,25.88,26.75,26.06,25.69,27.66,26.91,28.19,27.84,28.28,27.81,27.75,27.75,26.88,26.31,25.41,26.75,26.16,27.41,28.97,29.47,32.0,32.22,33.94,33.12,31.03,27.75,25.22,21.75,20.47,19.53,20.22,19.56,19.69,21.06,21.62,23.81,26.09,27.69,29.97,29.75,30.84,30.31,30.81,30.81,31.31,31.88,31.78,32.28,32.62,33.06,34.78,35.75,37.12,36.44,36.56,37.12,36.44,36.03,36.38,36.78,36.56,34.44,34.62,34.06,32.75,32.78,32.06,32.28,32.66,33.5,34.25,35.28,35.69,35.75,36.12,35.91,35.44,35.16,34.75,33.62,31.97,31.75,30.84,30.41,31.06,30.94,30.19,28.91,26.84,25.25,22.06,20.56,20.75,20.06,23.09,26.31,30.16,33.56,35.75,35.81,35.34,32.78,30.94,29.03,27.78,27.62,27.91,28.81,29.06,30.5,31.41,31.06,32.78,31.56,31.25,31.78,30.97,31.5,31.09,30.91,29.78,28.69,28.09,26.31,27.25,27.41,28.22,30.72,33.28,35.12,36.12,39.25,40.12,40.84,39.94,38.62,37.34,35.44,34.62,33.34,32.66,32.84,31.06,30.84,29.25,27.34,25.66,24.28,22.5,23.06,24.0,24.56,24.62,26.88,26.56,27.5,28.22,27.25,30.06,30.88,33.12,36.38,37.88,40.03,40.69,41.66,42.62,43.44,43.38,43.62,43.31,41.69,41.12,41.0,41.47,42.19,42.97,43.34,43.28,42.38,41.16,41.12,40.16,37.0,35.81,34.66,32.72,31.44,32.16,31.47,30.28,29.25,27.78,25.56,24.03,23.91,23.34,22.53,23.47,23.44,22.78,24.44,25.62,26.53,27.38,28.03,27.94,27.62,27.19,28.53,29.81,32.19,35.06,35.03,36.16,34.69,33.12,33.31,33.41,34.78,35.28,36.28,36.56,36.72,35.53,35.66,35.12,33.94,33.75,33.75,34.0,34.31,36.88,38.69,41.16,43.03,45.5,46.72,47.09,47.31,47.09,46.34,45.81,43.91,42.88,40.03,38.72,38.44,39.06,39.94,40.84,41.66,41.94,40.81,40.19,38.91,36.81,36.09,35.41,35.5,37.31,38.62,39.84,41.12,41.53,41.78,40.81,41.41,41.06,38.81,38.75,38.97,38.91,39.03,41.12,42.62,43.31,45.31,44.56,45.03,44.31,43.5,43.12,42.41,42.62,43.12,42.94,43.62,42.03,41.66,39.88,38.5,39.41,39.81,41.91,43.62,45.12,44.88,44.34,43.44,41.16,39.91,38.19,36.88,37.19,35.31,35.19,34.44,34.5,33.53,32.47,32.69,31.5,31.72,31.59,30.41,29.28,27.06,26.81,24.19,24.16,24.03,25.38,27.0,29.62,33.03,35.19,36.5,36.53,35.81,34.41,32.94,34.28,33.56,33.06,32.44,31.31,30.16,28.19,28.19,27.78,27.84,28.25,29.81,31.38,32.91,34.47,35.5,34.44,32.94,31.41,28.94,27.34,25.78,25.31,24.94,24.69,24.03,26.53,26.19,27.31,28.69,29.62,30.25,30.94,31.53,32.31,31.81,33.31,33.81,34.28,33.78,33.62,33.22,31.88,31.97,32.25,32.31,32.75,33.31,32.5,32.34,30.88,29.56,26.91,24.97,21.94,18.09,15.5,12.69,11.34,8.81,8.94,9.16,8.91,10.62,12.06,14.03,15.16,15.94,15.81,14.12,12.94,11.69,11.0,11.16,11.31,11.59,12.31,13.38,11.66,11.16,9.91,8.53,6.84,5.31,4.66,4.31,3.94,4.91,4.94,6.06,31.44,35.5,37.62,39.16,40.69,40.28,39.62,37.81,36.22,36.22,36.25,36.59:43.38,44.25,43.69,42.56,41.19,38.31,35.84,34.09,31.31,30.09,29.91,30.72,31.44,33.16,35.69,37.41,38.06,38.53,38.5,37.38,36.59,35.0,36.09,36.88,36.84,38.47,37.91,37.44,38.78,39.69,39.69,40.5,40.81,39.5,37.94,37.56,35.75,35.31,34.56,34.16,32.62,32.16,31.03,29.59,27.78,26.44,24.03,21.69,21.03,20.5,20.91,22.38,22.53,23.38,23.94,25.34,25.81,27.12,27.47,28.78,30.28,30.44,31.59,32.56,33.12,32.66,34.06,34.62,34.81,34.5,35.41,35.12,34.62,35.03,35.12,34.84,34.72,34.16,33.16,32.03,33.25,33.09,33.84,34.53,34.78,35.31,36.31,35.84,35.78,36.12,36.66,36.38,37.38,38.12,38.81,40.25,42.19,44.31,47.72,50.5,54.16,56.56,58.16,59.06,57.47,55.0,52.91,50.06,48.28,47.5,46.12,45.69,44.66,43.12,41.97,40.56,40.44,39.31,40.34,41.19,41.69,42.66,43.44,43.41,42.62,41.56,40.47,40.53,41.0,42.06,42.34,42.56,43.81,43.19,43.03,43.5,42.91,41.75,42.31,42.03,42.97,43.56,45.03,47.12,49.03,51.69,53.81,56.06,55.88,55.69,55.88,55.0,54.62,55.47,57.34,58.47,60.84,63.34,62.81,63.41,62.38,60.44,59.28,58.47,57.44,58.38,58.06,57.66,58.0,58.25,58.38,58.25,58.66,57.88,56.97,56.59,54.41,52.56,51.25,49.78,48.88,48.16,47.34,46.94,46.31,46.28,45.31,45.19,44.44,43.22,41.81,41.19,42.25,42.06,43.31,44.5,45.06,45.72,46.25,46.81,46.53,46.72,46.78,45.5,47.41,47.91,48.59,51.53,51.28,50.38,49.31,47.66,46.81,45.59,44.56,44.88,42.34,40.19,36.47,33.81,30.22,28.22,27.91,27.81,29.09,29.81,30.53,31.19,29.03,27.47,26.69,25.94,27.25,28.59,31.03,34.5,37.09,39.62,41.25,42.88,42.91,41.47,40.12,38.31,36.31,35.62,35.34,34.41,35.19,34.66,36.12,37.31,37.59,40.0,40.44,39.66,39.97,39.72,39.44,40.62,42.03,41.66,42.91,41.88,41.62,41.25,39.81,39.28,38.75,36.09,35.31,35.12,34.31,33.66,33.56,32.78,31.59,31.0,29.88,29.28,28.41,28.81,29.5,30.38,30.94,32.16,34.09,34.12,34.91,35.28,34.5,32.56,33.78,31.88,32.34,33.47,34.25,34.28,33.44,34.53,33.44,34.5,35.06,35.16,36.41,35.94,35.25,35.41,35.22,34.12,33.81,34.28,33.53,32.81,31.94,30.91,28.0,26.62,25.16,24.28,24.19,25.06,27.16,28.5,31.06,34.94,37.84,41.56,45.97,48.75,49.69,48.53,47.66,44.03,40.22,36.84,34.53,32.78,30.5,29.66,30.25,28.62,29.81,29.94,29.53,30.5,30.56,30.81,30.25,31.03,31.31,30.81,31.72,32.28,32.25,32.16,31.06,31.0,30.12,28.81,27.94,27.41,28.0,28.06,28.69,30.66,30.78,30.41,30.69,30.78,29.91,31.72,32.28,34.66,34.88,35.72,35.38,35.75,36.28,37.81,40.66,41.94,45.25,46.28,46.91,47.28,48.03,48.94,48.75,49.31,51.0,50.47,50.38,51.38,52.5,53.28,53.62,53.31,53.03,51.78,51.25,49.5,49.09,47.34,45.69,43.12,42.94,41.06,40.47,40.78,40.12,38.06,37.97,36.81,36.03,35.47,33.66,34.94,32.91,32.62,33.19,33.31,33.28,33.91,35.31,34.06,34.56,33.0,31.06,31.97,30.53,30.0,30.0,29.88,29.81,30.62,32.16,34.38,35.88,38.66,39.91,39.41,39.03,37.69,36.81,36.25,36.06,35.56,34.5,32.81,29.5,29.69,27.12,26.69,26.06,26.66,25.88,26.75,26.06,25.69,27.66,26.91,28.19,27.84,28.28,27.81,27.75,27.75,26.88,26.31,25.41,26.75,26.16,27.41,28.97,29.47,32.0,32.22,33.94,33.12,31.03,27.75,25.22,21.75,20.47,19.53,20.22,19.56,19.69,21.06,21.62,23.81,26.09,27.69,29.97,29.75,30.84,30.31,30.81,30.81,31.31,31.88,31.78,32.28,32.62,33.06,34.78,35.75,37.12,36.44,36.56,37.12,36.44,36.03,36.38,36.78,36.56,34.44,34.62,34.06,32.75,32.78,32.06,32.28,32.66,33.5,34.25,35.28,35.69,35.75,36.12,35.91,35.44,35.16,34.75,33.62,31.97,31.75,30.84,30.41,31.06,30.94,30.19,28.91,26.84,25.25,22.06,20.56,20.75,20.06,23.09,26.31,30.16,33.56,35.75,35.81,35.34,32.78,30.94,29.03,27.78,27.62,27.91,28.81,29.06,30.5,31.41,31.06,32.78,31.56,31.25,31.78,30.97,31.5,31.09,30.91,29.78,28.69,28.09,26.31,27.25,27.41,28.22,30.72,33.28,35.12,36.12,39.25,40.12,40.84,39.94,38.62,37.34,35.44,34.62,33.34,32.66,32.84,31.06,30.84,29.25,27.34,25.66,24.28,22.5,23.06,24.0,24.56,24.62,26.88,26.56,27.5,28.22,27.25,30.06,30.88,33.12,36.38,37.88,40.03,40.69,41.66,42.62,43.44,43.38,43.62,43.31,41.69,41.12,41.0,41.47,42.19,42.97,43.34,43.28,42.38,41.16,41.12,40.16,37.0,35.81,34.66,32.72,31.44,32.16,31.47,30.28,29.25,27.78,25.56,24.03,23.91,23.34,22.53,23.47,23.44,22.78,24.44,25.62,26.53,27.38,28.03,27.94,27.62,27.19,28.53,29.81,32.19,35.06,35.03,36.16,34.69,33.12,33.31,33.41,34.78,35.28,36.28,36.56,36.72,35.53,35.66,35.12,33.94,33.75,33.75,34.0,34.31,36.88,38.69,41.16,43.03,45.5,46.72,47.09,47.31,47.09,46.34,45.81,43.91,42.88,40.03,38.72,38.44,39.06,39.94,40.84,41.66,41.94,40.81,40.19,38.91,36.81,36.09,35.41,35.5,37.31,38.62,39.84,41.12,41.53,41.78,40.81,41.41,41.06,38.81,38.75,38.97,38.91,39.03,41.12,42.62,43.31,45.31,44.56,45.03,44.31,43.5,43.12,42.41,42.62,43.12,42.94,43.62,42.03,41.66,39.88,38.5,39.41,39.81,41.91,43.62,45.12,44.88,44.34,43.44,41.16,39.91,38.19,36.88,37.19,35.31,35.19,34.44,34.5,33.53,32.47,32.69,31.5,31.72,31.59,30.41,29.28,27.06,26.81,24.19,24.16,24.03,25.38,27.0,29.62,33.03,35.19,36.5,36.53,35.81,34.41,32.94,34.28,33.56,33.06,32.44,31.31,30.16,28.19,28.19,27.78,27.84,28.25,29.81,31.38,32.91,34.47,35.5,34.44,32.94,31.41,28.94,27.34,25.78,25.31,24.94,24.69,24.03,26.53,26.19,27.31,28.69,29.62,30.25,30.94,31.53,32.31,31.81,33.31,33.81,34.28,33.78,33.62,33.22,31.88,31.97,32.25,32.31,32.75,33.31,32.5,32.34,30.88,29.56,26.91,24.97,21.94,18.09,15.5,12.69,11.34,8.81,8.94,9.16,8.91,10.62,12.06,14.03,15.16,15.94,15.81,14.12,12.94,11.69,11.0,11.16,11.31,11.59,12.31,13.38,11.66,11.16,9.91,8.53,6.84,5.31,4.66,4.31,3.94,4.91,4.94,6.06,31.44,35.5,37.62,39.16,40.69,40.28,39.62,37.81,36.22,36.22,36.25,36.59,37.44,37.09,36.66,36.66,36.12,37.56:35.84,34.09,31.31,30.09,29.91,30.72,31.44,33.16,35.69,37.41,38.06,38.53,38.5,37.38,36.59,35.0,36.09,36.88,36.84,38.47,37.91,37.44,38.78,39.69,39.69,40.5,40.81,39.5,37.94,37.56,35.75,35.31,34.56,34.16,32.62,32.16,31.03,29.59,27.78,26.44,24.03,21.69,21.03,20.5,20.91,22.38,22.53,23.38,23.94,25.34,25.81,27.12,27.47,28.78,30.28,30.44,31.59,32.56,33.12,32.66,34.06,34.62,34.81,34.5,35.41,35.12,34.62,35.03,35.12,34.84,34.72,34.16,33.16,32.03,33.25,33.09,33.84,34.53,34.78,35.31,36.31,35.84,35.78,36.12,36.66,36.38,37.38,38.12,38.81,40.25,42.19,44.31,47.72,50.5,54.16,56.56,58.16,59.06,57.47,55.0,52.91,50.06,48.28,47.5,46.12,45.69,44.66,43.12,41.97,40.56,40.44,39.31,40.34,41.19,41.69,42.66,43.44,43.41,42.62,41.56,40.47,40.53,41.0,42.06,42.34,42.56,43.81,43.19,43.03,43.5,42.91,41.75,42.31,42.03,42.97,43.56,45.03,47.12,49.03,51.69,53.81,56.06,55.88,55.69,55.88,55.0,54.62,55.47,57.34,58.47,60.84,63.34,62.81,63.41,62.38,60.44,59.28,58.47,57.44,58.38,58.06,57.66,58.0,58.25,58.38,58.25,58.66,57.88,56.97,56.59,54.41,52.56,51.25,49.78,48.88,48.16,47.34,46.94,46.31,46.28,45.31,45.19,44.44,43.22,41.81,41.19,42.25,42.06,43.31,44.5,45.06,45.72,46.25,46.81,46.53,46.72,46.78,45.5,47.41,47.91,48.59,51.53,51.28,50.38,49.31,47.66,46.81,45.59,44.56,44.88,42.34,40.19,36.47,33.81,30.22,28.22,27.91,27.81,29.09,29.81,30.53,31.19,29.03,27.47,26.69,25.94,27.25,28.59,31.03,34.5,37.09,39.62,41.25,42.88,42.91,41.47,40.12,38.31,36.31,35.62,35.34,34.41,35.19,34.66,36.12,37.31,37.59,40.0,40.44,39.66,39.97,39.72,39.44,40.62,42.03,41.66,42.91,41.88,41.62,41.25,39.81,39.28,38.75,36.09,35.31,35.12,34.31,33.66,33.56,32.78,31.59,31.0,29.88,29.28,28.41,28.81,29.5,30.38,30.94,32.16,34.09,34.12,34.91,35.28,34.5,32.56,33.78,31.88,32.34,33.47,34.25,34.28,33.44,34.53,33.44,34.5,35.06,35.16,36.41,35.94,35.25,35.41,35.22,34.12,33.81,34.28,33.53,32.81,31.94,30.91,28.0,26.62,25.16,24.28,24.19,25.06,27.16,28.5,31.06,34.94,37.84,41.56,45.97,48.75,49.69,48.53,47.66,44.03,40.22,36.84,34.53,32.78,30.5,29.66,30.25,28.62,29.81,29.94,29.53,30.5,30.56,30.81,30.25,31.03,31.31,30.81,31.72,32.28,32.25,32.16,31.06,31.0,30.12,28.81,27.94,27.41,28.0,28.06,28.69,30.66,30.78,30.41,30.69,30.78,29.91,31.72,32.28,34.66,34.88,35.72,35.38,35.75,36.28,37.81,40.66,41.94,45.25,46.28,46.91,47.28,48.03,48.94,48.75,49.31,51.0,50.47,50.38,51.38,52.5,53.28,53.62,53.31,53.03,51.78,51.25,49.5,49.09,47.34,45.69,43.12,42.94,41.06,40.47,40.78,40.12,38.06,37.97,36.81,36.03,35.47,33.66,34.94,32.91,32.62,33.19,33.31,33.28,33.91,35.31,34.06,34.56,33.0,31.06,31.97,30.53,30.0,30.0,29.88,29.81,30.62,32.16,34.38,35.88,38.66,39.91,39.41,39.03,37.69,36.81,36.25,36.06,35.56,34.5,32.81,29.5,29.69,27.12,26.69,26.06,26.66,25.88,26.75,26.06,25.69,27.66,26.91,28.19,27.84,28.28,27.81,27.75,27.75,26.88,26.31,25.41,26.75,26.16,27.41,28.97,29.47,32.0,32.22,33.94,33.12,31.03,27.75,25.22,21.75,20.47,19.53,20.22,19.56,19.69,21.06,21.62,23.81,26.09,27.69,29.97,29.75,30.84,30.31,30.81,30.81,31.31,31.88,31.78,32.28,32.62,33.06,34.78,35.75,37.12,36.44,36.56,37.12,36.44,36.03,36.38,36.78,36.56,34.44,34.62,34.06,32.75,32.78,32.06,32.28,32.66,33.5,34.25,35.28,35.69,35.75,36.12,35.91,35.44,35.16,34.75,33.62,31.97,31.75,30.84,30.41,31.06,30.94,30.19,28.91,26.84,25.25,22.06,20.56,20.75,20.06,23.09,26.31,30.16,33.56,35.75,35.81,35.34,32.78,30.94,29.03,27.78,27.62,27.91,28.81,29.06,30.5,31.41,31.06,32.78,31.56,31.25,31.78,30.97,31.5,31.09,30.91,29.78,28.69,28.09,26.31,27.25,27.41,28.22,30.72,33.28,35.12,36.12,39.25,40.12,40.84,39.94,38.62,37.34,35.44,34.62,33.34,32.66,32.84,31.06,30.84,29.25,27.34,25.66,24.28,22.5,23.06,24.0,24.56,24.62,26.88,26.56,27.5,28.22,27.25,30.06,30.88,33.12,36.38,37.88,40.03,40.69,41.66,42.62,43.44,43.38,43.62,43.31,41.69,41.12,41.0,41.47,42.19,42.97,43.34,43.28,42.38,41.16,41.12,40.16,37.0,35.81,34.66,32.72,31.44,32.16,31.47,30.28,29.25,27.78,25.56,24.03,23.91,23.34,22.53,23.47,23.44,22.78,24.44,25.62,26.53,27.38,28.03,27.94,27.62,27.19,28.53,29.81,32.19,35.06,35.03,36.16,34.69,33.12,33.31,33.41,34.78,35.28,36.28,36.56,36.72,35.53,35.66,35.12,33.94,33.75,33.75,34.0,34.31,36.88,38.69,41.16,43.03,45.5,46.72,47.09,47.31,47.09,46.34,45.81,43.91,42.88,40.03,38.72,38.44,39.06,39.94,40.84,41.66,41.94,40.81,40.19,38.91,36.81,36.09,35.41,35.5,37.31,38.62,39.84,41.12,41.53,41.78,40.81,41.41,41.06,38.81,38.75,38.97,38.91,39.03,41.12,42.62,43.31,45.31,44.56,45.03,44.31,43.5,43.12,42.41,42.62,43.12,42.94,43.62,42.03,41.66,39.88,38.5,39.41,39.81,41.91,43.62,45.12,44.88,44.34,43.44,41.16,39.91,38.19,36.88,37.19,35.31,35.19,34.44,34.5,33.53,32.47,32.69,31.5,31.72,31.59,30.41,29.28,27.06,26.81,24.19,24.16,24.03,25.38,27.0,29.62,33.03,35.19,36.5,36.53,35.81,34.41,32.94,34.28,33.56,33.06,32.44,31.31,30.16,28.19,28.19,27.78,27.84,28.25,29.81,31.38,32.91,34.47,35.5,34.44,32.94,31.41,28.94,27.34,25.78,25.31,24.94,24.69,24.03,26.53,26.19,27.31,28.69,29.62,30.25,30.94,31.53,32.31,31.81,33.31,33.81,34.28,33.78,33.62,33.22,31.88,31.97,32.25,32.31,32.75,33.31,32.5,32.34,30.88,29.56,26.91,24.97,21.94,18.09,15.5,12.69,11.34,8.81,8.94,9.16,8.91,10.62,12.06,14.03,15.16,15.94,15.81,14.12,12.94,11.69,11.0,11.16,11.31,11.59,12.31,13.38,11.66,11.16,9.91,8.53,6.84,5.31,4.66,4.31,3.94,4.91,4.94,6.06,31.44,35.5,37.62,39.16,40.69,40.28,39.62,37.81,36.22,36.22,36.25,36.59,37.44,37.09,36.66,36.66,36.12,37.56,37.19,38.09,38.03,37.34,36.81,34.34:31.44,33.16,35.69,37.41,38.06,38.53,38.5,37.38,36.59,35.0,36.09,36.88,36.84,38.47,37.91,37.44,38.78,39.69,39.69,40.5,40.81,39.5,37.94,37.56,35.75,35.31,34.56,34.16,32.62,32.16,31.03,29.59,27.78,26.44,24.03,21.69,21.03,20.5,20.91,22.38,22.53,23.38,23.94,25.34,25.81,27.12,27.47,28.78,30.28,30.44,31.59,32.56,33.12,32.66,34.06,34.62,34.81,34.5,35.41,35.12,34.62,35.03,35.12,34.84,34.72,34.16,33.16,32.03,33.25,33.09,33.84,34.53,34.78,35.31,36.31,35.84,35.78,36.12,36.66,36.38,37.38,38.12,38.81,40.25,42.19,44.31,47.72,50.5,54.16,56.56,58.16,59.06,57.47,55.0,52.91,50.06,48.28,47.5,46.12,45.69,44.66,43.12,41.97,40.56,40.44,39.31,40.34,41.19,41.69,42.66,43.44,43.41,42.62,41.56,40.47,40.53,41.0,42.06,42.34,42.56,43.81,43.19,43.03,43.5,42.91,41.75,42.31,42.03,42.97,43.56,45.03,47.12,49.03,51.69,53.81,56.06,55.88,55.69,55.88,55.0,54.62,55.47,57.34,58.47,60.84,63.34,62.81,63.41,62.38,60.44,59.28,58.47,57.44,58.38,58.06,57.66,58.0,58.25,58.38,58.25,58.66,57.88,56.97,56.59,54.41,52.56,51.25,49.78,48.88,48.16,47.34,46.94,46.31,46.28,45.31,45.19,44.44,43.22,41.81,41.19,42.25,42.06,43.31,44.5,45.06,45.72,46.25,46.81,46.53,46.72,46.78,45.5,47.41,47.91,48.59,51.53,51.28,50.38,49.31,47.66,46.81,45.59,44.56,44.88,42.34,40.19,36.47,33.81,30.22,28.22,27.91,27.81,29.09,29.81,30.53,31.19,29.03,27.47,26.69,25.94,27.25,28.59,31.03,34.5,37.09,39.62,41.25,42.88,42.91,41.47,40.12,38.31,36.31,35.62,35.34,34.41,35.19,34.66,36.12,37.31,37.59,40.0,40.44,39.66,39.97,39.72,39.44,40.62,42.03,41.66,42.91,41.88,41.62,41.25,39.81,39.28,38.75,36.09,35.31,35.12,34.31,33.66,33.56,32.78,31.59,31.0,29.88,29.28,28.41,28.81,29.5,30.38,30.94,32.16,34.09,34.12,34.91,35.28,34.5,32.56,33.78,31.88,32.34,33.47,34.25,34.28,33.44,34.53,33.44,34.5,35.06,35.16,36.41,35.94,35.25,35.41,35.22,34.12,33.81,34.28,33.53,32.81,31.94,30.91,28.0,26.62,25.16,24.28,24.19,25.06,27.16,28.5,31.06,34.94,37.84,41.56,45.97,48.75,49.69,48.53,47.66,44.03,40.22,36.84,34.53,32.78,30.5,29.66,30.25,28.62,29.81,29.94,29.53,30.5,30.56,30.81,30.25,31.03,31.31,30.81,31.72,32.28,32.25,32.16,31.06,31.0,30.12,28.81,27.94,27.41,28.0,28.06,28.69,30.66,30.78,30.41,30.69,30.78,29.91,31.72,32.28,34.66,34.88,35.72,35.38,35.75,36.28,37.81,40.66,41.94,45.25,46.28,46.91,47.28,48.03,48.94,48.75,49.31,51.0,50.47,50.38,51.38,52.5,53.28,53.62,53.31,53.03,51.78,51.25,49.5,49.09,47.34,45.69,43.12,42.94,41.06,40.47,40.78,40.12,38.06,37.97,36.81,36.03,35.47,33.66,34.94,32.91,32.62,33.19,33.31,33.28,33.91,35.31,34.06,34.56,33.0,31.06,31.97,30.53,30.0,30.0,29.88,29.81,30.62,32.16,34.38,35.88,38.66,39.91,39.41,39.03,37.69,36.81,36.25,36.06,35.56,34.5,32.81,29.5,29.69,27.12,26.69,26.06,26.66,25.88,26.75,26.06,25.69,27.66,26.91,28.19,27.84,28.28,27.81,27.75,27.75,26.88,26.31,25.41,26.75,26.16,27.41,28.97,29.47,32.0,32.22,33.94,33.12,31.03,27.75,25.22,21.75,20.47,19.53,20.22,19.56,19.69,21.06,21.62,23.81,26.09,27.69,29.97,29.75,30.84,30.31,30.81,30.81,31.31,31.88,31.78,32.28,32.62,33.06,34.78,35.75,37.12,36.44,36.56,37.12,36.44,36.03,36.38,36.78,36.56,34.44,34.62,34.06,32.75,32.78,32.06,32.28,32.66,33.5,34.25,35.28,35.69,35.75,36.12,35.91,35.44,35.16,34.75,33.62,31.97,31.75,30.84,30.41,31.06,30.94,30.19,28.91,26.84,25.25,22.06,20.56,20.75,20.06,23.09,26.31,30.16,33.56,35.75,35.81,35.34,32.78,30.94,29.03,27.78,27.62,27.91,28.81,29.06,30.5,31.41,31.06,32.78,31.56,31.25,31.78,30.97,31.5,31.09,30.91,29.78,28.69,28.09,26.31,27.25,27.41,28.22,30.72,33.28,35.12,36.12,39.25,40.12,40.84,39.94,38.62,37.34,35.44,34.62,33.34,32.66,32.84,31.06,30.84,29.25,27.34,25.66,24.28,22.5,23.06,24.0,24.56,24.62,26.88,26.56,27.5,28.22,27.25,30.06,30.88,33.12,36.38,37.88,40.03,40.69,41.66,42.62,43.44,43.38,43.62,43.31,41.69,41.12,41.0,41.47,42.19,42.97,43.34,43.28,42.38,41.16,41.12,40.16,37.0,35.81,34.66,32.72,31.44,32.16,31.47,30.28,29.25,27.78,25.56,24.03,23.91,23.34,22.53,23.47,23.44,22.78,24.44,25.62,26.53,27.38,28.03,27.94,27.62,27.19,28.53,29.81,32.19,35.06,35.03,36.16,34.69,33.12,33.31,33.41,34.78,35.28,36.28,36.56,36.72,35.53,35.66,35.12,33.94,33.75,33.75,34.0,34.31,36.88,38.69,41.16,43.03,45.5,46.72,47.09,47.31,47.09,46.34,45.81,43.91,42.88,40.03,38.72,38.44,39.06,39.94,40.84,41.66,41.94,40.81,40.19,38.91,36.81,36.09,35.41,35.5,37.31,38.62,39.84,41.12,41.53,41.78,40.81,41.41,41.06,38.81,38.75,38.97,38.91,39.03,41.12,42.62,43.31,45.31,44.56,45.03,44.31,43.5,43.12,42.41,42.62,43.12,42.94,43.62,42.03,41.66,39.88,38.5,39.41,39.81,41.91,43.62,45.12,44.88,44.34,43.44,41.16,39.91,38.19,36.88,37.19,35.31,35.19,34.44,34.5,33.53,32.47,32.69,31.5,31.72,31.59,30.41,29.28,27.06,26.81,24.19,24.16,24.03,25.38,27.0,29.62,33.03,35.19,36.5,36.53,35.81,34.41,32.94,34.28,33.56,33.06,32.44,31.31,30.16,28.19,28.19,27.78,27.84,28.25,29.81,31.38,32.91,34.47,35.5,34.44,32.94,31.41,28.94,27.34,25.78,25.31,24.94,24.69,24.03,26.53,26.19,27.31,28.69,29.62,30.25,30.94,31.53,32.31,31.81,33.31,33.81,34.28,33.78,33.62,33.22,31.88,31.97,32.25,32.31,32.75,33.31,32.5,32.34,30.88,29.56,26.91,24.97,21.94,18.09,15.5,12.69,11.34,8.81,8.94,9.16,8.91,10.62,12.06,14.03,15.16,15.94,15.81,14.12,12.94,11.69,11.0,11.16,11.31,11.59,12.31,13.38,11.66,11.16,9.91,8.53,6.84,5.31,4.66,4.31,3.94,4.91,4.94,6.06,31.44,35.5,37.62,39.16,40.69,40.28,39.62,37.81,36.22,36.22,36.25,36.59,37.44,37.09,36.66,36.66,36.12,37.56,37.19,38.09,38.03,37.34,36.81,34.34,32.47,30.5,27.91,25.44,24.97,24.84:negativity
26.94,28.44,30.78,31.94,34.34,36.19,37.81,39.5,38.22,37.66,35.47,32.53,29.47,26.97,27.16,26.44,28.03,29.03,30.41,31.81,32.41,31.91,31.34,29.91,28.44,27.44,26.31,25.69,25.91,26.72,27.44,29.19,28.88,29.69,29.31,28.69,28.41,29.97,31.31,32.53,35.16,35.56,36.22,36.19,36.09,36.5,36.34,37.06,35.75,34.91,33.12,33.75,32.81,34.41,35.53,37.62,38.25,38.5,37.69,36.09,34.66,33.91,31.88,29.03,27.0,24.06,21.34,18.56,17.81,16.84,16.59,18.31,19.06,21.16,23.97,24.5,24.31,24.53,24.31,24.16,26.06,28.19,30.12,31.81,32.12,32.5,31.03,29.31,27.75,26.19,24.19,23.0,23.53,23.78,24.5,25.66,28.31,28.94,32.03,33.28,33.06,34.0,33.41,33.16,32.91,34.44,35.06,35.28,34.03,33.44,32.19,31.59,30.75,30.88,29.53,28.06,25.0,23.81,22.34,21.97,22.69,24.25,27.03,29.78,32.59,35.62,36.62,37.41,38.44,38.56,38.03,37.84,38.19,37.03,36.34,36.53,37.06,36.38,37.25,38.62,39.06,40.56,42.69,44.16,44.09,44.0,43.34,43.09,42.19,42.94,43.88,46.0,45.28,45.72,44.09,42.59,38.97,37.25,36.88,37.56,39.38,41.84,44.75,46.28,46.94,46.62,45.12,44.28,42.53,41.75,41.25,39.84,39.94,41.12,42.66,43.5,45.06,44.5,42.84,41.81,39.19,37.94,36.97,36.19,36.31,35.59,35.5,37.03,37.44,39.34,41.03,42.06,43.56,43.16,41.94,40.91,38.19,35.47,34.25,30.81,30.44,29.78,29.88,31.25,33.75,35.81,37.69,39.81,40.69,41.03,38.84,38.56,36.25,34.0,32.19,29.84,27.56,26.88,26.16,26.53,28.16,28.53,29.34,30.25,29.06,29.53,28.34,27.16,26.12,26.81,27.0,29.62,30.5,32.06,34.19,34.53,34.66,35.06,34.19,33.38,32.34,31.19,29.06,27.53,26.81,26.09,25.94,26.41,26.78,27.91,28.19,27.69,28.28,26.19,25.91,24.94,24.19,22.97,23.56,24.41,25.16,29.12,31.34,35.78,38.84,40.31,41.31,42.06,41.31,40.81,40.06,39.41,37.53,37.16,36.0,35.03,34.94,33.72,32.28,32.25,31.31,32.44,33.34,34.88,36.16,36.16,36.38,36.56,35.81,36.44,34.0,33.62,32.97,31.09,31.62,31.28,35.31,37.03,38.81,40.72,40.91,42.06,42.09,41.0,42.06,39.53,39.56,38.22,36.81,36.5,36.78,34.84,35.88,35.16,35.91,36.84,38.66,40.34,43.03,45.97,49.72,50.69,53.16,51.44,51.0,49.28,48.09,48.41,47.53,46.94,46.41,44.31,43.06,42.16,43.97,42.47,44.28,46.34,46.19,46.59,47.0,47.94,49.56,49.59,49.75,51.72,50.0,49.97,49.03,47.22,45.53,43.53,41.53,41.28,40.41,41.5,41.41,42.59,43.84,44.44,44.78,45.75,46.03,46.88,47.62,50.94,52.5,54.81,56.31,53.97,53.31,50.66,47.06,45.59,44.5,41.59,41.0,39.62,39.31,38.66,38.66,38.81,39.78,38.03,37.19,35.31,32.81,29.66,28.78,27.56,26.41,26.94,27.25,27.75,27.94,27.5,24.84,23.06,20.69,19.72,20.06,22.09,24.97,28.5,30.88,33.0,33.62,34.16,34.31,34.62,34.41,33.81,33.31,32.06,30.84,31.81,33.56,33.56,35.19,37.09,35.38,35.44,34.78,33.16,32.41,31.34,30.69,29.91,29.03,28.41,28.91,28.28,29.12,30.12,31.44,31.81,32.72,32.91,34.12,36.34,38.19,39.5,40.88,41.38,40.31,39.5,37.41,35.44,33.53,32.81,31.53,31.25,32.66,32.75,32.66,33.5,33.31,31.69,31.31,29.53,29.0,28.72,29.47,29.78,31.31,33.56,35.34,37.38,39.28,40.44,40.41,39.31,37.47,36.59,33.31,31.25,30.0,28.81,29.16,30.12,31.56,33.34,34.84,35.38,35.62,35.47,35.56,34.16,33.41,32.25,33.06,32.0,31.53,33.53,33.97,34.91,37.12,38.31,39.31,39.88,39.78,39.56,39.31,38.31,37.72,37.0,37.81,38.28,39.69,40.31,40.88,42.5,42.97,44.5,46.22,45.94,45.84,44.31,42.69,40.69,39.69,39.47,40.59,43.03,46.22,49.53,51.16,51.91,49.66,46.81,44.28,42.31,39.72,39.22,37.56,37.84,37.19,36.66,38.28,37.94,38.66,38.62,37.25,35.56,32.78,29.88,27.91,25.72,26.06,25.28,25.75,25.38,25.16,24.91,25.03,26.31,27.88,30.59,31.28,33.81,34.59,36.56,38.28,40.03,39.59,39.41,38.41,35.28,32.91,31.16,29.53,28.44,29.25,30.09,32.31,33.88,34.66,35.72,35.47,34.19,32.69,31.0,29.75,27.5,26.78,26.28,26.75,27.12,27.94,28.5,30.25,31.16,32.22,34.69,34.78,36.62,36.81,35.84,35.41,34.44,32.5,30.31,29.25,29.0,27.94,27.91,27.12,27.62,26.41,27.59,27.88,30.59,31.62,33.12,34.56,35.22,34.19,34.06,34.34,33.72,34.44,35.16,35.41,37.66,37.56,34.91,37.0,35.12,33.91,33.69,34.06,33.44,34.31,34.81,35.72,38.0,37.66,38.78,40.53,40.19,40.56,42.28,41.03,40.16,40.41,38.94,38.53,38.62,37.53,37.56,36.38,35.31,34.09,32.5,31.0,27.34,26.81,25.56,23.56,23.72,24.72,26.03,27.44,30.03,31.44,33.81,31.84,32.03,31.41,30.56,32.03,31.84,33.22,34.31,33.78,33.84,32.62,32.41,31.47,30.44,30.53,30.78,31.06,32.66,33.19,35.25,36.69,37.91,39.41,38.81,40.19,38.28,36.53,37.22,35.06,34.94,35.97,36.25,36.25,36.25,35.81,34.41,33.72,32.0,31.25,30.25,31.09,31.97,33.53,36.41,37.44,39.62,40.03,39.88,38.22,37.44,35.22,33.53,33.5,33.84,34.44,34.5,34.78,34.84,33.84,33.0,34.12,34.88,35.81,36.97,38.0,40.19,40.56,41.78,42.78,43.69,42.28,41.53,39.19,37.34,34.0,31.72,30.56,29.72,29.31,29.06,30.31,31.47,31.88,32.31,32.31,33.06,33.19,33.62,32.56,33.25,33.72,34.06,34.47,36.78,37.78,37.88,38.25,36.16,35.03,33.53,32.03,32.41,33.97,35.06,37.81,39.0,39.47,38.06,35.53,33.84,31.06,30.91,31.84,31.66,33.59,34.03,33.69,33.28,33.16,31.81,31.19,28.91,27.38,25.81,24.59,23.91,24.06,26.5,26.91,27.47,28.16,28.09,28.66,29.41,29.81,31.75,31.59,31.12,31.56,30.75,30.16,29.69,29.97,29.81,29.75,29.97,29.5,29.09,29.56,28.84,28.56,29.5,29.78,29.25,28.94,28.31,26.41,25.72,26.59,26.94,27.28,28.69,29.06,29.38,29.56,31.03,32.66,35.34,37.84,38.91,41.03,41.12,41.5,41.12,39.09,38.38,36.5,34.34,34.34,34.06,34.41,35.75,36.94,38.81,40.38,40.56,40.53,40.03,38.69,37.78,37.78,37.81,36.38,35.56,35.06,33.56,33.38,33.34,33.56,34.88,34.62,35.72,36.06,37.06,37.59,37.38,37.81,37.69,36.97,35.47,34.72,31.41,29.56,28.06,26.31,25.06,24.66,25.31,26.0,27.69,29.47,30.19,30.81,31.12,29.44,27.97,25.81,23.31,21.97,20.5:37.81,39.5,38.22,37.66,35.47,32.53,29.47,26.97,27.16,26.44,28.03,29.03,30.41,31.81,32.41,31.91,31.34,29.91,28.44,27.44,26.31,25.69,25.91,26.72,27.44,29.19,28.88,29.69,29.31,28.69,28.41,29.97,31.31,32.53,35.16,35.56,36.22,36.19,36.09,36.5,36.34,37.06,35.75,34.91,33.12,33.75,32.81,34.41,35.53,37.62,38.25,38.5,37.69,36.09,34.66,33.91,31.88,29.03,27.0,24.06,21.34,18.56,17.81,16.84,16.59,18.31,19.06,21.16,23.97,24.5,24.31,24.53,24.31,24.16,26.06,28.19,30.12,31.81,32.12,32.5,31.03,29.31,27.75,26.19,24.19,23.0,23.53,23.78,24.5,25.66,28.31,28.94,32.03,33.28,33.06,34.0,33.41,33.16,32.91,34.44,35.06,35.28,34.03,33.44,32.19,31.59,30.75,30.88,29.53,28.06,25.0,23.81,22.34,21.97,22.69,24.25,27.03,29.78,32.59,35.62,36.62,37.41,38.44,38.56,38.03,37.84,38.19,37.03,36.34,36.53,37.06,36.38,37.25,38.62,39.06,40.56,42.69,44.16,44.09,44.0,43.34,43.09,42.19,42.94,43.88,46.0,45.28,45.72,44.09,42.59,38.97,37.25,36.88,37.56,39.38,41.84,44.75,46.28,46.94,46.62,45.12,44.28,42.53,41.75,41.25,39.84,39.94,41.12,42.66,43.5,45.06,44.5,42.84,41.81,39.19,37.94,36.97,36.19,36.31,35.59,35.5,37.03,37.44,39.34,41.03,42.06,43.56,43.16,41.94,40.91,38.19,35.47,34.25,30.81,30.44,29.78,29.88,31.25,33.75,35.81,37.69,39.81,40.69,41.03,38.84,38.56,36.25,34.0,32.19,29.84,27.56,26.88,26.16,26.53,28.16,28.53,29.34,30.25,29.06,29.53,28.34,27.16,26.12,26.81,27.0,29.62,30.5,32.06,34.19,34.53,34.66,35.06,34.19,33.38,32.34,31.19,29.06,27.53,26.81,26.09,25.94,26.41,26.78,27.91,28.19,27.69,28.28,26.19,25.91,24.94,24.19,22.97,23.56,24.41,25.16,29.12,31.34,35.78,38.84,40.31,41.31,42.06,41.31,40.81,40.06,39.41,37.53,37.16,36.0,35.03,34.94,33.72,32.28,32.25,31.31,32.44,33.34,34.88,36.16,36.16,36.38,36.56,35.81,36.44,34.0,33.62,32.97,31.09,31.62,31.28,35.31,37.03,38.81,40.72,40.91,42.06,42.09,41.0,42.06,39.53,39.56,38.22,36.81,36.5,36.78,34.84,35.88,35.16,35.91,36.84,38.66,40.34,43.03,45.97,49.72,50.69,53.16,51.44,51.0,49.28,48.09,48.41,47.53,46.94,46.41,44.31,43.06,42.16,43.97,42.47,44.28,46.34,46.19,46.59,47.0,47.94,49.56,49.59,49.75,51.72,50.0,49.97,49.03,47.22,45.53,43.53,41.53,41.28,40.41,41.5,41.41,42.59,43.84,44.44,44.78,45.75,46.03,46.88,47.62,50.94,52.5,54.81,56.31,53.97,53.31,50.66,47.06,45.59,44.5,41.59,41.0,39.62,39.31,38.66,38.66,38.81,39.78,38.03,37.19,35.31,32.81,29.66,28.78,27.56,26.41,26.94,27.25,27.75,27.94,27.5,24.84,23.06,20.69,19.72,20.06,22.09,24.97,28.5,30.88,33.0,33.62,34.16,34.31,34.62,34.41,33.81,33.31,32.06,30.84,31.81,33.56,33.56,35.19,37.09,35.38,35.44,34.78,33.16,32.41,31.34,30.69,29.91,29.03,28.41,28.91,28.28,29.12,30.12,31.44,31.81,32.72,32.91,34.12,36.34,38.19,39.5,40.88,41.38,40.31,39.5,37.41,35.44,33.53,32.81,31.53,31.25,32.66,32.75,32.66,33.5,33.31,31.69,31.31,29.53,29.0,28.72,29.47,29.78,31.31,33.56,35.34,37.38,39.28,40.44,40.41,39.31,37.47,36.59,33.31,31.25,30.0,28.81,29.16,30.12,31.56,33.34,34.84,35.38,35.62,35.47,35.56,34.16,33.41,32.25,33.06,32.0,31.53,33.53,33.97,34.91,37.12,38.31,39.31,39.88,39.78,39.56,39.31,38.31,37.72,37.0,37.81,38.28,39.69,40.31,40.88,42.5,42.97,44.5,46.22,45.94,45.84,44.31,42.69,40.69,39.69,39.47,40.59,43.03,46.22,49.53,51.16,51.91,49.66,46.81,44.28,42.31,39.72,39.22,37.56,37.84,37.19,36.66,38.28,37.94,38.66,38.62,37.25,35.56,32.78,29.88,27.91,25.72,26.06,25.28,25.75,25.38,25.16,24.91,25.03,26.31,27.88,30.59,31.28,33.81,34.59,36.56,38.28,40.03,39.59,39.41,38.41,35.28,32.91,31.16,29.53,28.44,29.25,30.09,32.31,33.88,34.66,35.72,35.47,34.19,32.69,31.0,29.75,27.5,26.78,26.28,26.75,27.12,27.94,28.5,30.25,31.16,32.22,34.69,34.78,36.62,36.81,35.84,35.41,34.44,32.5,30.31,29.25,29.0,27.94,27.91,27.12,27.62,26.41,27.59,27.88,30.59,31.62,33.12,34.56,35.22,34.19,34.06,34.34,33.72,34.44,35.16,35.41,37.66,37.56,34.91,37.0,35.12,33.91,33.69,34.06,33.44,34.31,34.81,35.72,38.0,37.66,38.78,40.53,40.19,40.56,42.28,41.03,40.16,40.41,38.94,38.53,38.62,37.53,37.56,36.38,35.31,34.09,32.5,31.0,27.34,26.81,25.56,23.56,23.72,24.72,26.03,27.44,30.03,31.44,33.81,31.84,32.03,31.41,30.56,32.03,31.84,33.22,34.31,33.78,33.84,32.62,32.41,31.47,30.44,30.53,30.78,31.06,32.66,33.19,35.25,36.69,37.91,39.41,38.81,40.19,38.28,36.53,37.22,35.06,34.94,35.97,36.25,36.25,36.25,35.81,34.41,33.72,32.0,31.25,30.25,31.09,31.97,33.53,36.41,37.44,39.62,40.03,39.88,38.22,37.44,35.22,33.53,33.5,33.84,34.44,34.5,34.78,34.84,33.84,33.0,34.12,34.88,35.81,36.97,38.0,40.19,40.56,41.78,42.78,43.69,42.28,41.53,39.19,37.34,34.0,31.72,30.56,29.72,29.31,29.06,30.31,31.47,31.88,32.31,32.31,33.06,33.19,33.62,32.56,33.25,33.72,34.06,34.47,36.78,37.78,37.88,38.25,36.16,35.03,33.53,32.03,32.41,33.97,35.06,37.81,39.0,39.47,38.06,35.53,33.84,31.06,30.91,31.84,31.66,33.59,34.03,33.69,33.28,33.16,31.81,31.19,28.91,27.38,25.81,24.59,23.91,24.06,26.5,26.91,27.47,28.16,28.09,28.66,29.41,29.81,31.75,31.59,31.12,31.56,30.75,30.16,29.69,29.97,29.81,29.75,29.97,29.5,29.09,29.56,28.84,28.56,29.5,29.78,29.25,28.94,28.31,26.41,25.72,26.59,26.94,27.28,28.69,29.06,29.38,29.56,31.03,32.66,35.34,37.84,38.91,41.03,41.12,41.5,41.12,39.09,38.38,36.5,34.34,34.34,34.06,34.41,35.75,36.94,38.81,40.38,40.56,40.53,40.03,38.69,37.78,37.78,37.81,36.38,35.56,35.06,33.56,33.38,33.34,33.56,34.88,34.62,35.72,36.06,37.06,37.59,37.38,37.81,37.69,36.97,35.47,34.72,31.41,29.56,28.06,26.31,25.06,24.66,25.31,26.0,27.69,29.47,30.19,30.81,31.12,29.44,27.97,25.81,23.31,21.97,20.5,-2.25,-0.47,2.44,4.41,6.97,9.41:29.47,26.97,27.16,26.44,28.03,29.03,30.41,31.81,32.41,31.91,31.34,29.91,28.44,27.44,26.31,25.69,25.91,26.72,27.44,29.19,28.88,29.69,29.31,28.69,28.41,29.97,31.31,32.53,35.16,35.56,36.22,36.19,36.09,36.5,36.34,37.06,35.75,34.91,33.12,33.75,32.81,34.41,35.53,37.62,38.25,38.5,37.69,36.09,34.66,33.91,31.88,29.03,27.0,24.06,21.34,18.56,17.81,16.84,16.59,18.31,19.06,21.16,23.97,24.5,24.31,24.53,24.31,24.16,26.06,28.19,30.12,31.81,32.12,32.5,31.03,29.31,27.75,26.19,24.19,23.0,23.53,23.78,24.5,25.66,28.31,28.94,32.03,33.28,33.06,34.0,33.41,33.16,32.91,34.44,35.06,35.28,34.03,33.44,32.19,31.59,30.75,30.88,29.53,28.06,25.0,23.81,22.34,21.97,22.69,24.25,27.03,29.78,32.59,35.62,36.62,37.41,38.44,38.56,38.03,37.84,38.19,37.03,36.34,36.53,37.06,36.38,37.25,38.62,39.06,40.56,42.69,44.16,44.09,44.0,43.34,43.09,42.19,42.94,43.88,46.0,45.28,45.72,44.09,42.59,38.97,37.25,36.88,37.56,39.38,41.84,44.75,46.28,46.94,46.62,45.12,44.28,42.53,41.75,41.25,39.84,39.94,41.12,42.66,43.5,45.06,44.5,42.84,41.81,39.19,37.94,36.97,36.19,36.31,35.59,35.5,37.03,37.44,39.34,41.03,42.06,43.56,43.16,41.94,40.91,38.19,35.47,34.25,30.81,30.44,29.78,29.88,31.25,33.75,35.81,37.69,39.81,40.69,41.03,38.84,38.56,36.25,34.0,32.19,29.84,27.56,26.88,26.16,26.53,28.16,28.53,29.34,30.25,29.06,29.53,28.34,27.16,26.12,26.81,27.0,29.62,30.5,32.06,34.19,34.53,34.66,35.06,34.19,33.38,32.34,31.19,29.06,27.53,26.81,26.09,25.94,26.41,26.78,27.91,28.19,27.69,28.28,26.19,25.91,24.94,24.19,22.97,23.56,24.41,25.16,29.12,31.34,35.78,38.84,40.31,41.31,42.06,41.31,40.81,40.06,39.41,37.53,37.16,36.0,35.03,34.94,33.72,32.28,32.25,31.31,32.44,33.34,34.88,36.16,36.16,36.38,36.56,35.81,36.44,34.0,33.62,32.97,31.09,31.62,31.28,35.31,37.03,38.81,40.72,40.91,42.06,42.09,41.0,42.06,39.53,39.56,38.22,36.81,36.5,36.78,34.84,35.88,35.16,35.91,36.84,38.66,40.34,43.03,45.97,49.72,50.69,53.16,51.44,51.0,49.28,48.09,48.41,47.53,46.94,46.41,44.31,43.06,42.16,43.97,42.47,44.28,46.34,46.19,46.59,47.0,47.94,49.56,49.59,49.75,51.72,50.0,49.97,49.03,47.22,45.53,43.53,41.53,41.28,40.41,41.5,41.41,42.59,43.84,44.44,44.78,45.75,46.03,46.88,47.62,50.94,52.5,54.81,56.31,53.97,53.31,50.66,47.06,45.59,44.5,41.59,41.0,39.62,39.31,38.66,38.66,38.81,39.78,38.03,37.19,35.31,32.81,29.66,28.78,27.56,26.41,26.94,27.25,27.75,27.94,27.5,24.84,23.06,20.69,19.72,20.06,22.09,24.97,28.5,30.88,33.0,33.62,34.16,34.31,34.62,34.41,33.81,33.31,32.06,30.84,31.81,33.56,33.56,35.19,37.09,35.38,35.44,34.78,33.16,32.41,31.34,30.69,29.91,29.03,28.41,28.91,28.28,29.12,30.12,31.44,31.81,32.72,32.91,34.12,36.34,38.19,39.5,40.88,41.38,40.31,39.5,37.41,35.44,33.53,32.81,31.53,31.25,32.66,32.75,32.66,33.5,33.31,31.69,31.31,29.53,29.0,28.72,29.47,29.78,31.31,33.56,35.34,37.38,39.28,40.44,40.41,39.31,37.47,36.59,33.31,31.25,30.0,28.81,29.16,30.12,31.56,33.34,34.84,35.38,35.62,35.47,35.56,34.16,33.41,32.25,33.06,32.0,31.53,33.53,33.97,34.91,37.12,38.31,39.31,39.88,39.78,39.56,39.31,38.31,37.72,37.0,37.81,38.28,39.69,40.31,40.88,42.5,42.97,44.5,46.22,45.94,45.84,44.31,42.69,40.69,39.69,39.47,40.59,43.03,46.22,49.53,51.16,51.91,49.66,46.81,44.28,42.31,39.72,39.22,37.56,37.84,37.19,36.66,38.28,37.94,38.66,38.62,37.25,35.56,32.78,29.88,27.91,25.72,26.06,25.28,25.75,25.38,25.16,24.91,25.03,26.31,27.88,30.59,31.28,33.81,34.59,36.56,38.28,40.03,39.59,39.41,38.41,35.28,32.91,31.16,29.53,28.44,29.25,30.09,32.31,33.88,34.66,35.72,35.47,34.19,32.69,31.0,29.75,27.5,26.78,26.28,26.75,27.12,27.94,28.5,30.25,31.16,32.22,34.69,34.78,36.62,36.81,35.84,35.41,34.44,32.5,30.31,29.25,29.0,27.94,27.91,27.12,27.62,26.41,27.59,27.88,30.59,31.62,33.12,34.56,35.22,34.19,34.06,34.34,33.72,34.44,35.16,35.41,37.66,37.56,34.91,37.0,35.12,33.91,33.69,34.06,33.44,34.31,34.81,35.72,38.0,37.66,38.78,40.53,40.19,40.56,42.28,41.03,40.16,40.41,38.94,38.53,38.62,37.53,37.56,36.38,35.31,34.09,32.5,31.0,27.34,26.81,25.56,23.56,23.72,24.72,26.03,27.44,30.03,31.44,33.81,31.84,32.03,31.41,30.56,32.03,31.84,33.22,34.31,33.78,33.84,32.62,32.41,31.47,30.44,30.53,30.78,31.06,32.66,33.19,35.25,36.69,37.91,39.41,38.81,40.19,38.28,36.53,37.22,35.06,34.94,35.97,36.25,36.25,36.25,35.81,34.41,33.72,32.0,31.25,30.25,31.09,31.97,33.53,36.41,37.44,39.62,40.03,39.88,38.22,37.44,35.22,33.53,33.5,33.84,34.44,34.5,34.78,34.84,33.84,33.0,34.12,34.88,35.81,36.97,38.0,40.19,40.56,41.78,42.78,43.69,42.28,41.53,39.19,37.34,34.0,31.72,30.56,29.72,29.31,29.06,30.31,31.47,31.88,32.31,32.31,33.06,33.19,33.62,32.56,33.25,33.72,34.06,34.47,36.78,37.78,37.88,38.25,36.16,35.03,33.53,32.03,32.41,33.97,35.06,37.81,39.0,39.47,38.06,35.53,33.84,31.06,30.91,31.84,31.66,33.59,34.03,33.69,33.28,33.16,31.81,31.19,28.91,27.38,25.81,24.59,23.91,24.06,26.5,26.91,27.47,28.16,28.09,28.66,29.41,29.81,31.75,31.59,31.12,31.56,30.75,30.16,29.69,29.97,29.81,29.75,29.97,29.5,29.09,29.56,28.84,28.56,29.5,29.78,29.25,28.94,28.31,26.41,25.72,26.59,26.94,27.28,28.69,29.06,29.38,29.56,31.03,32.66,35.34,37.84,38.91,41.03,41.12,41.5,41.12,39.09,38.38,36.5,34.34,34.34,34.06,34.41,35.75,36.94,38.81,40.38,40.56,40.53,40.03,38.69,37.78,37.78,37.81,36.38,35.56,35.06,33.56,33.38,33.34,33.56,34.88,34.62,35.72,36.06,37.06,37.59,37.38,37.81,37.69,36.97,35.47,34.72,31.41,29.56,28.06,26.31,25.06,24.66,25.31,26.0,27.69,29.47,30.19,30.81,31.12,29.44,27.97,25.81,23.31,21.97,20.5,-2.25,-0.47,2.44,4.41,6.97,9.41,10.81,12.03,13.34,12.53,11.81,9.53:30.41,31.81,32.41,31.91,31.34,29.91,28.44,27.44,26.31,25.69,25.91,26.72,27.44,29.19,28.88,29.69,29.31,28.69,28.41,29.97,31.31,32.53,35.16,35.56,36.22,36.19,36.09,36.5,36.34,37.06,35.75,34.91,33.12,33.75,32.81,34.41,35.53,37.62,38.25,38.5,37.69,36.09,34.66,33.91,31.88,29.03,27.0,24.06,21.34,18.56,17.81,16.84,16.59,18.31,19.06,21.16,23.97,24.5,24.31,24.53,24.31,24.16,26.06,28.19,30.12,31.81,32.12,32.5,31.03,29.31,27.75,26.19,24.19,23.0,23.53,23.78,24.5,25.66,28.31,28.94,32.03,33.28,33.06,34.0,33.41,33.16,32.91,34.44,35.06,35.28,34.03,33.44,32.19,31.59,30.75,30.88,29.53,28.06,25.0,23.81,22.34,21.97,22.69,24.25,27.03,29.78,32.59,35.62,36.62,37.41,38.44,38.56,38.03,37.84,38.19,37.03,36.34,36.53,37.06,36.38,37.25,38.62,39.06,40.56,42.69,44.16,44.09,44.0,43.34,43.09,42.19,42.94,43.88,46.0,45.28,45.72,44.09,42.59,38.97,37.25,36.88,37.56,39.38,41.84,44.75,46.28,46.94,46.62,45.12,44.28,42.53,41.75,41.25,39.84,39.94,41.12,42.66,43.5,45.06,44.5,42.84,41.81,39.19,37.94,36.97,36.19,36.31,35.59,35.5,37.03,37.44,39.34,41.03,42.06,43.56,43.16,41.94,40.91,38.19,35.47,34.25,30.81,30.44,29.78,29.88,31.25,33.75,35.81,37.69,39.81,40.69,41.03,38.84,38.56,36.25,34.0,32.19,29.84,27.56,26.88,26.16,26.53,28.16,28.53,29.34,30.25,29.06,29.53,28.34,27.16,26.12,26.81,27.0,29.62,30.5,32.06,34.19,34.53,34.66,35.06,34.19,33.38,32.34,31.19,29.06,27.53,26.81,26.09,25.94,26.41,26.78,27.91,28.19,27.69,28.28,26.19,25.91,24.94,24.19,22.97,23.56,24.41,25.16,29.12,31.34,35.78,38.84,40.31,41.31,42.06,41.31,40.81,40.06,39.41,37.53,37.16,36.0,35.03,34.94,33.72,32.28,32.25,31.31,32.44,33.34,34.88,36.16,36.16,36.38,36.56,35.81,36.44,34.0,33.62,32.97,31.09,31.62,31.28,35.31,37.03,38.81,40.72,40.91,42.06,42.09,41.0,42.06,39.53,39.56,38.22,36.81,36.5,36.78,34.84,35.88,35.16,35.91,36.84,38.66,40.34,43.03,45.97,49.72,50.69,53.16,51.44,51.0,49.28,48.09,48.41,47.53,46.94,46.41,44.31,43.06,42.16,43.97,42.47,44.28,46.34,46.19,46.59,47.0,47.94,49.56,49.59,49.75,51.72,50.0,49.97,49.03,47.22,45.53,43.53,41.53,41.28,40.41,41.5,41.41,42.59,43.84,44.44,44.78,45.75,46.03,46.88,47.62,50.94,52.5,54.81,56.31,53.97,53.31,50.66,47.06,45.59,44.5,41.59,41.0,39.62,39.31,38.66,38.66,38.81,39.78,38.03,37.19,35.31,32.81,29.66,28.78,27.56,26.41,26.94,27.25,27.75,27.94,27.5,24.84,23.06,20.69,19.72,20.06,22.09,24.97,28.5,30.88,33.0,33.62,34.16,34.31,34.62,34.41,33.81,33.31,32.06,30.84,31.81,33.56,33.56,35.19,37.09,35.38,35.44,34.78,33.16,32.41,31.34,30.69,29.91,29.03,28.41,28.91,28.28,29.12,30.12,31.44,31.81,32.72,32.91,34.12,36.34,38.19,39.5,40.88,41.38,40.31,39.5,37.41,35.44,33.53,32.81,31.53,31.25,32.66,32.75,32.66,33.5,33.31,31.69,31.31,29.53,29.0,28.72,29.47,29.78,31.31,33.56,35.34,37.38,39.28,40.44,40.41,39.31,37.47,36.59,33.31,31.25,30.0,28.81,29.16,30.12,31.56,33.34,34.84,35.38,35.62,35.47,35.56,34.16,33.41,32.25,33.06,32.0,31.53,33.53,33.97,34.91,37.12,38.31,39.31,39.88,39.78,39.56,39.31,38.31,37.72,37.0,37.81,38.28,39.69,40.31,40.88,42.5,42.97,44.5,46.22,45.94,45.84,44.31,42.69,40.69,39.69,39.47,40.59,43.03,46.22,49.53,51.16,51.91,49.66,46.81,44.28,42.31,39.72,39.22,37.56,37.84,37.19,36.66,38.28,37.94,38.66,38.62,37.25,35.56,32.78,29.88,27.91,25.72,26.06,25.28,25.75,25.38,25.16,24.91,25.03,26.31,27.88,30.59,31.28,33.81,34.59,36.56,38.28,40.03,39.59,39.41,38.41,35.28,32.91,31.16,29.53,28.44,29.25,30.09,32.31,33.88,34.66,35.72,35.47,34.19,32.69,31.0,29.75,27.5,26.78,26.28,26.75,27.12,27.94,28.5,30.25,31.16,32.22,34.69,34.78,36.62,36.81,35.84,35.41,34.44,32.5,30.31,29.25,29.0,27.94,27.91,27.12,27.62,26.41,27.59,27.88,30.59,31.62,33.12,34.56,35.22,34.19,34.06,34.34,33.72,34.44,35.16,35.41,37.66,37.56,34.91,37.0,35.12,33.91,33.69,34.06,33.44,34.31,34.81,35.72,38.0,37.66,38.78,40.53,40.19,40.56,42.28,41.03,40.16,40.41,38.94,38.53,38.62,37.53,37.56,36.38,35.31,34.09,32.5,31.0,27.34,26.81,25.56,23.56,23.72,24.72,26.03,27.44,30.03,31.44,33.81,31.84,32.03,31.41,30.56,32.03,31.84,33.22,34.31,33.78,33.84,32.62,32.41,31.47,30.44,30.53,30.78,31.06,32.66,33.19,35.25,36.69,37.91,39.41,38.81,40.19,38.28,36.53,37.22,35.06,34.94,35.97,36.25,36.25,36.25,35.81,34.41,33.72,32.0,31.25,30.25,31.09,31.97,33.53,36.41,37.44,39.62,40.03,39.88,38.22,37.44,35.22,33.53,33.5,33.84,34.44,34.5,34.78,34.84,33.84,33.0,34.12,34.88,35.81,36.97,38.0,40.19,40.56,41.78,42.78,43.69,42.28,41.53,39.19,37.34,34.0,31.72,30.56,29.72,29.31,29.06,30.31,31.47,31.88,32.31,32.31,33.06,33.19,33.62,32.56,33.25,33.72,34.06,34.47,36.78,37.78,37.88,38.25,36.16,35.03,33.53,32.03,32.41,33.97,35.06,37.81,39.0,39.47,38.06,35.53,33.84,31.06,30.91,31.84,31.66,33.59,34.03,33.69,33.28,33.16,31.81,31.19,28.91,27.38,25.81,24.59,23.91,24.06,26.5,26.91,27.47,28.16,28.09,28.66,29.41,29.81,31.75,31.59,31.12,31.56,30.75,30.16,29.69,29.97,29.81,29.75,29.97,29.5,29.09,29.56,28.84,28.56,29.5,29.78,29.25,28.94,28.31,26.41,25.72,26.59,26.94,27.28,28.69,29.06,29.38,29.56,31.03,32.66,35.34,37.84,38.91,41.03,41.12,41.5,41.12,39.09,38.38,36.5,34.34,34.34,34.06,34.41,35.75,36.94,38.81,40.38,40.56,40.53,40.03,38.69,37.78,37.78,37.81,36.38,35.56,35.06,33.56,33.38,33.34,33.56,34.88,34.62,35.72,36.06,37.06,37.59,37.38,37.81,37.69,36.97,35.47,34.72,31.41,29.56,28.06,26.31,25.06,24.66,25.31,26.0,27.69,29.47,30.19,30.81,31.12,29.44,27.97,25.81,23.31,21.97,20.5,-2.25,-0.47,2.44,4.41,6.97,9.41,10.81,12.03,13.34,12.53,11.81,9.53,7.19,4.69,3.41,3.59,5.44,5.5:28.44,27.44,26.31,25.69,25.91,26.72,27.44,29.19,28.88,29.69,29.31,28.69,28.41,29.97,31.31,32.53,35.16,35.56,36.22,36.19,36.09,36.5,36.34,37.06,35.75,34.91,33.12,33.75,32.81,34.41,35.53,37.62,38.25,38.5,37.69,36.09,34.66,33.91,31.88,29.03,27.0,24.06,21.34,18.56,17.81,16.84,16.59,18.31,19.06,21.16,23.97,24.5,24.31,24.53,24.31,24.16,26.06,28.19,30.12,31.81,32.12,32.5,31.03,29.31,27.75,26.19,24.19,23.0,23.53,23.78,24.5,25.66,28.31,28.94,32.03,33.28,33.06,34.0,33.41,33.16,32.91,34.44,35.06,35.28,34.03,33.44,32.19,31.59,30.75,30.88,29.53,28.06,25.0,23.81,22.34,21.97,22.69,24.25,27.03,29.78,32.59,35.62,36.62,37.41,38.44,38.56,38.03,37.84,38.19,37.03,36.34,36.53,37.06,36.38,37.25,38.62,39.06,40.56,42.69,44.16,44.09,44.0,43.34,43.09,42.19,42.94,43.88,46.0,45.28,45.72,44.09,42.59,38.97,37.25,36.88,37.56,39.38,41.84,44.75,46.28,46.94,46.62,45.12,44.28,42.53,41.75,41.25,39.84,39.94,41.12,42.66,43.5,45.06,44.5,42.84,41.81,39.19,37.94,36.97,36.19,36.31,35.59,35.5,37.03,37.44,39.34,41.03,42.06,43.56,43.16,41.94,40.91,38.19,35.47,34.25,30.81,30.44,29.78,29.88,31.25,33.75,35.81,37.69,39.81,40.69,41.03,38.84,38.56,36.25,34.0,32.19,29.84,27.56,26.88,26.16,26.53,28.16,28.53,29.34,30.25,29.06,29.53,28.34,27.16,26.12,26.81,27.0,29.62,30.5,32.06,34.19,34.53,34.66,35.06,34.19,33.38,32.34,31.19,29.06,27.53,26.81,26.09,25.94,26.41,26.78,27.91,28.19,27.69,28.28,26.19,25.91,24.94,24.19,22.97,23.56,24.41,25.16,29.12,31.34,35.78,38.84,40.31,41.31,42.06,41.31,40.81,40.06,39.41,37.53,37.16,36.0,35.03,34.94,33.72,32.28,32.25,31.31,32.44,33.34,34.88,36.16,36.16,36.38,36.56,35.81,36.44,34.0,33.62,32.97,31.09,31.62,31.28,35.31,37.03,38.81,40.72,40.91,42.06,42.09,41.0,42.06,39.53,39.56,38.22,36.81,36.5,36.78,34.84,35.88,35.16,35.91,36.84,38.66,40.34,43.03,45.97,49.72,50.69,53.16,51.44,51.0,49.28,48.09,48.41,47.53,46.94,46.41,44.31,43.06,42.16,43.97,42.47,44.28,46.34,46.19,46.59,47.0,47.94,49.56,49.59,49.75,51.72,50.0,49.97,49.03,47.22,45.53,43.53,41.53,41.28,40.41,41.5,41.41,42.59,43.84,44.44,44.78,45.75,46.03,46.88,47.62,50.94,52.5,54.81,56.31,53.97,53.31,50.66,47.06,45.59,44.5,41.59,41.0,39.62,39.31,38.66,38.66,38.81,39.78,38.03,37.19,35.31,32.81,29.66,28.78,27.56,26.41,26.94,27.25,27.75,27.94,27.5,24.84,23.06,20.69,19.72,20.06,22.09,24.97,28.5,30.88,33.0,33.62,34.16,34.31,34.62,34.41,33.81,33.31,32.06,30.84,31.81,33.56,33.56,35.19,37.09,35.38,35.44,34.78,33.16,32.41,31.34,30.69,29.91,29.03,28.41,28.91,28.28,29.12,30.12,31.44,31.81,32.72,32.91,34.12,36.34,38.19,39.5,40.88,41.38,40.31,39.5,37.41,35.44,33.53,32.81,31.53,31.25,32.66,32.75,32.66,33.5,33.31,31.69,31.31,29.53,29.0,28.72,29.47,29.78,31.31,33.56,35.34,37.38,39.28,40.44,40.41,39.31,37.47,36.59,33.31,31.25,30.0,28.81,29.16,30.12,31.56,33.34,34.84,35.38,35.62,35.47,35.56,34.16,33.41,32.25,33.06,32.0,31.53,33.53,33.97,34.91,37.12,38.31,39.31,39.88,39.78,39.56,39.31,38.31,37.72,37.0,37.81,38.28,39.69,40.31,40.88,42.5,42.97,44.5,46.22,45.94,45.84,44.31,42.69,40.69,39.69,39.47,40.59,43.03,46.22,49.53,51.16,51.91,49.66,46.81,44.28,42.31,39.72,39.22,37.56,37.84,37.19,36.66,38.28,37.94,38.66,38.62,37.25,35.56,32.78,29.88,27.91,25.72,26.06,25.28,25.75,25.38,25.16,24.91,25.03,26.31,27.88,30.59,31.28,33.81,34.59,36.56,38.28,40.03,39.59,39.41,38.41,35.28,32.91,31.16,29.53,28.44,29.25,30.09,32.31,33.88,34.66,35.72,35.47,34.19,32.69,31.0,29.75,27.5,26.78,26.28,26.75,27.12,27.94,28.5,30.25,31.16,32.22,34.69,34.78,36.62,36.81,35.84,35.41,34.44,32.5,30.31,29.25,29.0,27.94,27.91,27.12,27.62,26.41,27.59,27.88,30.59,31.62,33.12,34.56,35.22,34.19,34.06,34.34,33.72,34.44,35.16,35.41,37.66,37.56,34.91,37.0,35.12,33.91,33.69,34.06,33.44,34.31,34.81,35.72,38.0,37.66,38.78,40.53,40.19,40.56,42.28,41.03,40.16,40.41,38.94,38.53,38.62,37.53,37.56,36.38,35.31,34.09,32.5,31.0,27.34,26.81,25.56,23.56,23.72,24.72,26.03,27.44,30.03,31.44,33.81,31.84,32.03,31.41,30.56,32.03,31.84,33.22,34.31,33.78,33.84,32.62,32.41,31.47,30.44,30.53,30.78,31.06,32.66,33.19,35.25,36.69,37.91,39.41,38.81,40.19,38.28,36.53,37.22,35.06,34.94,35.97,36.25,36.25,36.25,35.81,34.41,33.72,32.0,31.25,30.25,31.09,31.97,33.53,36.41,37.44,39.62,40.03,39.88,38.22,37.44,35.22,33.53,33.5,33.84,34.44,34.5,34.78,34.84,33.84,33.0,34.12,34.88,35.81,36.97,38.0,40.19,40.56,41.78,42.78,43.69,42.28,41.53,39.19,37.34,34.0,31.72,30.56,29.72,29.31,29.06,30.31,31.47,31.88,32.31,32.31,33.06,33.19,33.62,32.56,33.25,33.72,34.06,34.47,36.78,37.78,37.88,38.25,36.16,35.03,33.53,32.03,32.41,33.97,35.06,37.81,39.0,39.47,38.06,35.53,33.84,31.06,30.91,31.84,31.66,33.59,34.03,33.69,33.28,33.16,31.81,31.19,28.91,27.38,25.81,24.59,23.91,24.06,26.5,26.91,27.47,28.16,28.09,28.66,29.41,29.81,31.75,31.59,31.12,31.56,30.75,30.16,29.69,29.97,29.81,29.75,29.97,29.5,29.09,29.56,28.84,28.56,29.5,29.78,29.25,28.94,28.31,26.41,25.72,26.59,26.94,27.28,28.69,29.06,29.38,29.56,31.03,32.66,35.34,37.84,38.91,41.03,41.12,41.5,41.12,39.09,38.38,36.5,34.34,34.34,34.06,34.41,35.75,36.94,38.81,40.38,40.56,40.53,40.03,38.69,37.78,37.78,37.81,36.38,35.56,35.06,33.56,33.38,33.34,33.56,34.88,34.62,35.72,36.06,37.06,37.59,37.38,37.81,37.69,36.97,35.47,34.72,31.41,29.56,28.06,26.31,25.06,24.66,25.31,26.0,27.69,29.47,30.19,30.81,31.12,29.44,27.97,25.81,23.31,21.97,20.5,-2.25,-0.47,2.44,4.41,6.97,9.41,10.81,12.03,13.34,12.53,11.81,9.53,7.19,4.69,3.41,3.59,5.44,5.5,6.47,6.84,6.38,5.22,4.88,3.69:27.44,29.19,28.88,29.69,29.31,28.69,28.41,29.97,31.31,32.53,35.16,35.56,36.22,36.19,36.09,36.5,36.34,37.06,35.75,34.91,33.12,33.75,32.81,34.41,35.53,37.62,38.25,38.5,37.69,36.09,34.66,33.91,31.88,29.03,27.0,24.06,21.34,18.56,17.81,16.84,16.59,18.31,19.06,21.16,23.97,24.5,24.31,24.53,24.31,24.16,26.06,28.19,30.12,31.81,32.12,32.5,31.03,29.31,27.75,26.19,24.19,23.0,23.53,23.78,24.5,25.66,28.31,28.94,32.03,33.28,33.06,34.0,33.41,33.16,32.91,34.44,35.06,35.28,34.03,33.44,32.19,31.59,30.75,30.88,29.53,28.06,25.0,23.81,22.34,21.97,22.69,24.25,27.03,29.78,32.59,35.62,36.62,37.41,38.44,38.56,38.03,37.84,38.19,37.03,36.34,36.53,37.06,36.38,37.25,38.62,39.06,40.56,42.69,44.16,44.09,44.0,43.34,43.09,42.19,42.94,43.88,46.0,45.28,45.72,44.09,42.59,38.97,37.25,36.88,37.56,39.38,41.84,44.75,46.28,46.94,46.62,45.12,44.28,42.53,41.75,41.25,39.84,39.94,41.12,42.66,43.5,45.06,44.5,42.84,41.81,39.19,37.94,36.97,36.19,36.31,35.59,35.5,37.03,37.44,39.34,41.03,42.06,43.56,43.16,41.94,40.91,38.19,35.47,34.25,30.81,30.44,29.78,29.88,31.25,33.75,35.81,37.69,39.81,40.69,41.03,38.84,38.56,36.25,34.0,32.19,29.84,27.56,26.88,26.16,26.53,28.16,28.53,29.34,30.25,29.06,29.53,28.34,27.16,26.12,26.81,27.0,29.62,30.5,32.06,34.19,34.53,34.66,35.06,34.19,33.38,32.34,31.19,29.06,27.53,26.81,26.09,25.94,26.41,26.78,27.91,28.19,27.69,28.28,26.19,25.91,24.94,24.19,22.97,23.56,24.41,25.16,29.12,31.34,35.78,38.84,40.31,41.31,42.06,41.31,40.81,40.06,39.41,37.53,37.16,36.0,35.03,34.94,33.72,32.28,32.25,31.31,32.44,33.34,34.88,36.16,36.16,36.38,36.56,35.81,36.44,34.0,33.62,32.97,31.09,31.62,31.28,35.31,37.03,38.81,40.72,40.91,42.06,42.09,41.0,42.06,39.53,39.56,38.22,36.81,36.5,36.78,34.84,35.88,35.16,35.91,36.84,38.66,40.34,43.03,45.97,49.72,50.69,53.16,51.44,51.0,49.28,48.09,48.41,47.53,46.94,46.41,44.31,43.06,42.16,43.97,42.47,44.28,46.34,46.19,46.59,47.0,47.94,49.56,49.59,49.75,51.72,50.0,49.97,49.03,47.22,45.53,43.53,41.53,41.28,40.41,41.5,41.41,42.59,43.84,44.44,44.78,45.75,46.03,46.88,47.62,50.94,52.5,54.81,56.31,53.97,53.31,50.66,47.06,45.59,44.5,41.59,41.0,39.62,39.31,38.66,38.66,38.81,39.78,38.03,37.19,35.31,32.81,29.66,28.78,27.56,26.41,26.94,27.25,27.75,27.94,27.5,24.84,23.06,20.69,19.72,20.06,22.09,24.97,28.5,30.88,33.0,33.62,34.16,34.31,34.62,34.41,33.81,33.31,32.06,30.84,31.81,33.56,33.56,35.19,37.09,35.38,35.44,34.78,33.16,32.41,31.34,30.69,29.91,29.03,28.41,28.91,28.28,29.12,30.12,31.44,31.81,32.72,32.91,34.12,36.34,38.19,39.5,40.88,41.38,40.31,39.5,37.41,35.44,33.53,32.81,31.53,31.25,32.66,32.75,32.66,33.5,33.31,31.69,31.31,29.53,29.0,28.72,29.47,29.78,31.31,33.56,35.34,37.38,39.28,40.44,40.41,39.31,37.47,36.59,33.31,31.25,30.0,28.81,29.16,30.12,31.56,33.34,34.84,35.38,35.62,35.47,35.56,34.16,33.41,32.25,33.06,32.0,31.53,33.53,33.97,34.91,37.12,38.31,39.31,39.88,39.78,39.56,39.31,38.31,37.72,37.0,37.81,38.28,39.69,40.31,40.88,42.5,42.97,44.5,46.22,45.94,45.84,44.31,42.69,40.69,39.69,39.47,40.59,43.03,46.22,49.53,51.16,51.91,49.66,46.81,44.28,42.31,39.72,39.22,37.56,37.84,37.19,36.66,38.28,37.94,38.66,38.62,37.25,35.56,32.78,29.88,27.91,25.72,26.06,25.28,25.75,25.38,25.16,24.91,25.03,26.31,27.88,30.59,31.28,33.81,34.59,36.56,38.28,40.03,39.59,39.41,38.41,35.28,32.91,31.16,29.53,28.44,29.25,30.09,32.31,33.88,34.66,35.72,35.47,34.19,32.69,31.0,29.75,27.5,26.78,26.28,26.75,27.12,27.94,28.5,30.25,31.16,32.22,34.69,34.78,36.62,36.81,35.84,35.41,34.44,32.5,30.31,29.25,29.0,27.94,27.91,27.12,27.62,26.41,27.59,27.88,30.59,31.62,33.12,34.56,35.22,34.19,34.06,34.34,33.72,34.44,35.16,35.41,37.66,37.56,34.91,37.0,35.12,33.91,33.69,34.06,33.44,34.31,34.81,35.72,38.0,37.66,38.78,40.53,40.19,40.56,42.28,41.03,40.16,40.41,38.94,38.53,38.62,37.53,37.56,36.38,35.31,34.09,32.5,31.0,27.34,26.81,25.56,23.56,23.72,24.72,26.03,27.44,30.03,31.44,33.81,31.84,32.03,31.41,30.56,32.03,31.84,33.22,34.31,33.78,33.84,32.62,32.41,31.47,30.44,30.53,30.78,31.06,32.66,33.19,35.25,36.69,37.91,39.41,38.81,40.19,38.28,36.53,37.22,35.06,34.94,35.97,36.25,36.25,36.25,35.81,34.41,33.72,32.0,31.25,30.25,31.09,31.97,33.53,36.41,37.44,39.62,40.03,39.88,38.22,37.44,35.22,33.53,33.5,33.84,34.44,34.5,34.78,34.84,33.84,33.0,34.12,34.88,35.81,36.97,38.0,40.19,40.56,41.78,42.78,43.69,42.28,41.53,39.19,37.34,34.0,31.72,30.56,29.72,29.31,29.06,30.31,31.47,31.88,32.31,32.31,33.06,33.19,33.62,32.56,33.25,33.72,34.06,34.47,36.78,37.78,37.88,38.25,36.16,35.03,33.53,32.03,32.41,33.97,35.06,37.81,39.0,39.47,38.06,35.53,33.84,31.06,30.91,31.84,31.66,33.59,34.03,33.69,33.28,33.16,31.81,31.19,28.91,27.38,25.81,24.59,23.91,24.06,26.5,26.91,27.47,28.16,28.09,28.66,29.41,29.81,31.75,31.59,31.12,31.56,30.75,30.16,29.69,29.97,29.81,29.75,29.97,29.5,29.09,29.56,28.84,28.56,29.5,29.78,29.25,28.94,28.31,26.41,25.72,26.59,26.94,27.28,28.69,29.06,29.38,29.56,31.03,32.66,35.34,37.84,38.91,41.03,41.12,41.5,41.12,39.09,38.38,36.5,34.34,34.34,34.06,34.41,35.75,36.94,38.81,40.38,40.56,40.53,40.03,38.69,37.78,37.78,37.81,36.38,35.56,35.06,33.56,33.38,33.34,33.56,34.88,34.62,35.72,36.06,37.06,37.59,37.38,37.81,37.69,36.97,35.47,34.72,31.41,29.56,28.06,26.31,25.06,24.66,25.31,26.0,27.69,29.47,30.19,30.81,31.12,29.44,27.97,25.81,23.31,21.97,20.5,-2.25,-0.47,2.44,4.41,6.97,9.41,10.81,12.03,13.34,12.53,11.81,9.53,7.19,4.69,3.41,3.59,5.44,5.5,6.47,6.84,6.38,5.22,4.88,3.69,3.72,3.09,1.38,0.28,-0.66,-1.06:negativity
12.16,11.0,10.47,11.06,13.12,15.56,17.69,20.28,22.56,24.56,25.75,24.41,24.56,23.25,20.69,18.94,16.16,13.69,12.19,10.56,10.84,12.84,14.56,17.16,19.81,22.44,24.66,26.91,28.38,30.19,31.19,31.38,31.34,31.06,30.59,29.78,28.84,28.06,28.06,28.06,28.28,30.19,31.66,33.31,33.81,33.19,32.81,31.0,29.62,29.12,30.38,31.19,32.09,32.59,32.66,31.91,31.84,30.81,30.47,30.16,29.56,28.69,28.81,28.03,28.94,28.25,27.94,27.5,26.03,24.5,22.06,20.84,19.0,17.88,17.34,17.03,17.72,18.62,18.72,20.31,21.06,22.12,23.0,23.81,23.75,25.03,25.25,26.34,26.16,25.41,23.97,22.28,20.81,19.56,19.69,19.88,20.97,22.47,24.81,26.31,27.69,28.94,28.69,26.41,24.16,20.28,16.03,13.03,10.0,7.38,5.5,2.53,1.56,-0.91,-1.97,-2.22,-1.72,-1.22,-0.28,0.75,2.62,3.22,5.28,7.03,7.56,8.75,8.72,9.53,10.31,10.38,11.16,12.34,15.03,17.47,19.72,22.53,23.69,23.47,23.47,22.03,20.34,19.91,19.81,20.72,21.41,22.38,21.5,20.75,19.03,15.84,13.19,11.09,9.03,6.94,5.69,5.81,6.16,7.44,9.31,10.28,11.19,10.5,8.31,6.78,5.31,4.91,5.69,7.91,10.88,12.88,15.03,17.78,18.06,18.97,19.16,17.91,16.31,13.44,12.0,11.16,10.44,11.09,12.38,13.06,13.75,13.59,12.56,10.62,9.25,7.16,6.53,5.72,6.16,6.44,7.38,7.25,8.12,8.5,8.31,8.72,8.88,8.62,8.94,8.41,9.41,10.62,12.0,12.84,13.34,13.25,12.16,11.75,10.94,10.66,11.56,12.72,13.81,14.94,15.56,16.5,17.34,17.31,19.62,21.19,22.78,25.25,26.84,28.94,31.34,33.12,35.34,36.38,37.09,35.62,34.72,32.81,30.66,28.34,26.47,25.78,26.06,25.66,25.69,26.34,26.03,26.53,25.56,25.56,24.59,22.31,20.06,18.0,16.06,14.31,13.38,12.78,13.31,14.19,14.53,15.06,16.84,17.56,17.38,17.66,18.38,19.34,18.88,19.25,19.06,18.81,18.16,17.91,17.34,16.5,14.75,13.75,12.0,9.81,9.81,9.72,10.28,11.06,12.22,12.84,12.94,13.0,13.03,13.91,14.22,15.44,15.06,16.03,15.06,14.06,12.41,10.72,10.44,9.91,10.91,12.94,15.03,17.72,20.94,23.56,26.0,26.62,25.59,25.25,22.12,20.91,19.91,19.09,19.62,19.12,18.34,18.25,17.22,16.19,15.06,15.06,13.5,11.94,11.28,10.28,10.59,12.16,15.81,19.62,23.56,27.06,28.84,29.62,29.47,28.41,26.53,25.41,24.06,23.0,22.91,22.5,21.72,20.47,18.44,16.44,13.97,13.12,14.59,16.19,19.34,22.72,25.66,27.5,29.19,29.25,29.09,28.81,27.53,27.0,27.31,27.38,27.94,28.09,29.31,30.0,30.41,30.56,29.88,28.06,26.16,22.78,20.28,18.94,18.59,19.91,21.94,24.59,27.25,28.84,29.56,29.94,29.91,28.97,28.84,28.69,28.81,28.25,26.62,24.88,22.19,19.84,17.16,15.03,14.5,14.28,14.56,15.19,15.53,15.78,17.31,18.25,20.19,22.09,24.25,24.84,25.0,23.78,23.56,22.12,19.84,19.25,18.69,18.78,19.91,21.66,24.69,25.28,25.31,24.03,21.22,18.03,15.06,13.44,11.62,10.94,10.31,10.5,9.88,10.19,9.88,9.78,9.81,9.66,8.94,8.75,8.81,8.78,9.19,9.84,10.16,11.78,12.34,13.56,14.34,15.47,16.19,16.34,16.38,17.62,17.41,17.91,18.22,18.22,17.81,17.66,17.5,18.34,19.91,21.25,22.16,22.84,22.69,22.28,20.75,18.0,15.38,13.44,11.06,9.75,9.31,10.5,11.12,12.56,13.88,15.69,17.66,18.69,19.12,19.81,19.31,19.19,18.5,19.06,17.81,18.0,17.44,17.72,19.03,20.16,21.47,22.03,23.09,23.03,22.0,21.0,20.75,18.91,18.06,16.59,15.06,13.97,11.66,11.03,10.75,11.0,12.75,13.31,15.25,16.31,17.75,18.22,18.34,17.59,16.62,14.28,11.91,10.75,10.28,10.81,10.78,12.31,13.06,14.06,13.97,14.5,14.28,14.44,14.53,14.19,14.19,13.69,13.44,11.75,12.0,12.19,12.19,12.41,12.69,13.75,13.97,14.5,14.41,14.34,14.59,14.12,14.94,16.47,17.5,19.12,19.69,19.69,18.72,16.81,15.06,14.41,12.81,13.16,13.06,13.75,15.03,16.16,16.75,17.56,17.5,17.88,17.72,17.78,18.59,19.34,20.06,20.56,20.62,20.16,20.12,19.94,20.59,21.62,22.28,22.25,22.22,21.38,20.53,19.53,19.31,19.16,19.56,18.75,18.78,17.81,17.06,16.94,16.41,16.47,16.38,15.53,14.81,13.72,12.81,12.41,13.0,13.84,14.06,15.12,14.75,14.44,14.0,14.0,13.75,14.22,15.03,16.12,16.06,16.66,16.12,16.06,15.94,15.47,15.59,14.88,14.38,13.44,11.84,11.0,9.81,8.31,8.03,6.94,6.81,6.5,7.0,8.22,9.06,10.16,11.38,11.25,11.47,11.72,11.47,12.03,12.75,13.38,14.69,14.53,15.03,15.84,15.62,15.94,16.34,15.72,14.28,13.81,12.09,10.41,9.19,7.66,6.53,6.03,4.75,5.81,6.47,8.75,12.0,14.91,18.44,21.19,23.81,24.84,25.69,26.44,26.38,24.62,24.22,22.56,20.72,19.19,17.25,17.38,17.88,18.81,20.16,23.16,26.03,27.06,27.41,27.09,25.31,22.94,21.19,19.25,18.81,18.16,18.88,18.78,20.31,21.31,22.06,22.62,22.78,21.12,19.88,16.66,14.78,13.03,11.53,10.72,11.56,11.62,12.84,13.47,14.5,14.66,14.81,14.59,14.53,14.16,14.69,13.84,13.75,13.44,13.69,12.91,11.81,11.62,10.25,8.94,8.16,6.81,6.44,6.03,4.44,4.34,4.97,6.41,8.78,9.72,10.75,11.44,11.25,10.5,11.12,12.44,14.12,15.28,16.84,17.94,18.47,19.59,20.56,22.06,23.62,24.38,24.81,24.22,22.91,22.25,21.03,21.06,21.25,22.5,23.5,23.53,24.12,23.44,23.12,21.72,20.66,20.38,19.59,17.38,16.94,14.56,12.0,9.5,7.41,6.25,5.03,5.28,6.31,6.94,9.47,10.56,11.44,11.59,11.06,8.81,6.38,1.62,-1.16,-4.16,-6.12,-6.16,-4.16,-2.59,0.19,2.81,4.62,5.53,6.31,6.72,6.91,7.56,8.44,8.59,8.69,8.38,7.59,6.5,6.41,6.22,5.69,6.03,5.78,6.5,6.66,7.28,8.31,9.16,10.44,12.69,14.72,17.06,19.06,19.62,19.41,18.25,17.09,15.5,13.81,12.34,11.12,9.75,8.31,6.91,6.53,5.0,5.03,4.75,5.41,5.34,5.53,6.38,7.06,8.0,9.84,12.06,14.69,15.84,16.69,16.88,16.22,15.09,13.16,10.94,8.41,5.56,4.03,3.16,2.69,3.34,4.22,4.81,6.25,8.06,10.41,13.38,16.44,18.78,21.31,21.78,21.5,20.34,19.59,17.19,15.41,14.31,14.16,14.69,15.12,15.97,16.12,15.0,13.44,12.0,11.16,10.72,11.16,12.81,14.06,14.78,16.12,16.81,16.81,17.5,17.5,16.78,15.81,14.56:17.69,20.28,22.56,24.56,25.75,24.41,24.56,23.25,20.69,18.94,16.16,13.69,12.19,10.56,10.84,12.84,14.56,17.16,19.81,22.44,24.66,26.91,28.38,30.19,31.19,31.38,31.34,31.06,30.59,29.78,28.84,28.06,28.06,28.06,28.28,30.19,31.66,33.31,33.81,33.19,32.81,31.0,29.62,29.12,30.38,31.19,32.09,32.59,32.66,31.91,31.84,30.81,30.47,30.16,29.56,28.69,28.81,28.03,28.94,28.25,27.94,27.5,26.03,24.5,22.06,20.84,19.0,17.88,17.34,17.03,17.72,18.62,18.72,20.31,21.06,22.12,23.0,23.81,23.75,25.03,25.25,26.34,26.16,25.41,23.97,22.28,20.81,19.56,19.69,19.88,20.97,22.47,24.81,26.31,27.69,28.94,28.69,26.41,24.16,20.28,16.03,13.03,10.0,7.38,5.5,2.53,1.56,-0.91,-1.97,-2.22,-1.72,-1.22,-0.28,0.75,2.62,3.22,5.28,7.03,7.56,8.75,8.72,9.53,10.31,10.38,11.16,12.34,15.03,17.47,19.72,22.53,23.69,23.47,23.47,22.03,20.34,19.91,19.81,20.72,21.41,22.38,21.5,20.75,19.03,15.84,13.19,11.09,9.03,6.94,5.69,5.81,6.16,7.44,9.31,10.28,11.19,10.5,8.31,6.78,5.31,4.91,5.69,7.91,10.88,12.88,15.03,17.78,18.06,18.97,19.16,17.91,16.31,13.44,12.0,11.16,10.44,11.09,12.38,13.06,13.75,13.59,12.56,10.62,9.25,7.16,6.53,5.72,6.16,6.44,7.38,7.25,8.12,8.5,8.31,8.72,8.88,8.62,8.94,8.41,9.41,10.62,12.0,12.84,13.34,13.25,12.16,11.75,10.94,10.66,11.56,12.72,13.81,14.94,15.56,16.5,17.34,17.31,19.62,21.19,22.78,25.25,26.84,28.94,31.34,33.12,35.34,36.38,37.09,35.62,34.72,32.81,30.66,28.34,26.47,25.78,26.06,25.66,25.69,26.34,26.03,26.53,25.56,25.56,24.59,22.31,20.06,18.0,16.06,14.31,13.38,12.78,13.31,14.19,14.53,15.06,16.84,17.56,17.38,17.66,18.38,19.34,18.88,19.25,19.06,18.81,18.16,17.91,17.34,16.5,14.75,13.75,12.0,9.81,9.81,9.72,10.28,11.06,12.22,12.84,12.94,13.0,13.03,13.91,14.22,15.44,15.06,16.03,15.06,14.06,12.41,10.72,10.44,9.91,10.91,12.94,15.03,17.72,20.94,23.56,26.0,26.62,25.59,25.25,22.12,20.91,19.91,19.09,19.62,19.12,18.34,18.25,17.22,16.19,15.06,15.06,13.5,11.94,11.28,10.28,10.59,12.16,15.81,19.62,23.56,27.06,28.84,29.62,29.47,28.41,26.53,25.41,24.06,23.0,22.91,22.5,21.72,20.47,18.44,16.44,13.97,13.12,14.59,16.19,19.34,22.72,25.66,27.5,29.19,29.25,29.09,28.81,27.53,27.0,27.31,27.38,27.94,28.09,29.31,30.0,30.41,30.56,29.88,28.06,26.16,22.78,20.28,18.94,18.59,19.91,21.94,24.59,27.25,28.84,29.56,29.94,29.91,28.97,28.84,28.69,28.81,28.25,26.62,24.88,22.19,19.84,17.16,15.03,14.5,14.28,14.56,15.19,15.53,15.78,17.31,18.25,20.19,22.09,24.25,24.84,25.0,23.78,23.56,22.12,19.84,19.25,18.69,18.78,19.91,21.66,24.69,25.28,25.31,24.03,21.22,18.03,15.06,13.44,11.62,10.94,10.31,10.5,9.88,10.19,9.88,9.78,9.81,9.66,8.94,8.75,8.81,8.78,9.19,9.84,10.16,11.78,12.34,13.56,14.34,15.47,16.19,16.34,16.38,17.62,17.41,17.91,18.22,18.22,17.81,17.66,17.5,18.34,19.91,21.25,22.16,22.84,22.69,22.28,20.75,18.0,15.38,13.44,11.06,9.75,9.31,10.5,11.12,12.56,13.88,15.69,17.66,18.69,19.12,19.81,19.31,19.19,18.5,19.06,17.81,18.0,17.44,17.72,19.03,20.16,21.47,22.03,23.09,23.03,22.0,21.0,20.75,18.91,18.06,16.59,15.06,13.97,11.66,11.03,10.75,11.0,12.75,13.31,15.25,16.31,17.75,18.22,18.34,17.59,16.62,14.28,11.91,10.75,10.28,10.81,10.78,12.31,13.06,14.06,13.97,14.5,14.28,14.44,14.53,14.19,14.19,13.69,13.44,11.75,12.0,12.19,12.19,12.41,12.69,13.75,13.97,14.5,14.41,14.34,14.59,14.12,14.94,16.47,17.5,19.12,19.69,19.69,18.72,16.81,15.06,14.41,12.81,13.16,13.06,13.75,15.03,16.16,16.75,17.56,17.5,17.88,17.72,17.78,18.59,19.34,20.06,20.56,20.62,20.16,20.12,19.94,20.59,21.62,22.28,22.25,22.22,21.38,20.53,19.53,19.31,19.16,19.56,18.75,18.78,17.81,17.06,16.94,16.41,16.47,16.38,15.53,14.81,13.72,12.81,12.41,13.0,13.84,14.06,15.12,14.75,14.44,14.0,14.0,13.75,14.22,15.03,16.12,16.06,16.66,16.12,16.06,15.94,15.47,15.59,14.88,14.38,13.44,11.84,11.0,9.81,8.31,8.03,6.94,6.81,6.5,7.0,8.22,9.06,10.16,11.38,11.25,11.47,11.72,11.47,12.03,12.75,13.38,14.69,14.53,15.03,15.84,15.62,15.94,16.34,15.72,14.28,13.81,12.09,10.41,9.19,7.66,6.53,6.03,4.75,5.81,6.47,8.75,12.0,14.91,18.44,21.19,23.81,24.84,25.69,26.44,26.38,24.62,24.22,22.56,20.72,19.19,17.25,17.38,17.88,18.81,20.16,23.16,26.03,27.06,27.41,27.09,25.31,22.94,21.19,19.25,18.81,18.16,18.88,18.78,20.31,21.31,22.06,22.62,22.78,21.12,19.88,16.66,14.78,13.03,11.53,10.72,11.56,11.62,12.84,13.47,14.5,14.66,14.81,14.59,14.53,14.16,14.69,13.84,13.75,13.44,13.69,12.91,11.81,11.62,10.25,8.94,8.16,6.81,6.44,6.03,4.44,4.34,4.97,6.41,8.78,9.72,10.75,11.44,11.25,10.5,11.12,12.44,14.12,15.28,16.84,17.94,18.47,19.59,20.56,22.06,23.62,24.38,24.81,24.22,22.91,22.25,21.03,21.06,21.25,22.5,23.5,23.53,24.12,23.44,23.12,21.72,20.66,20.38,19.59,17.38,16.94,14.56,12.0,9.5,7.41,6.25,5.03,5.28,6.31,6.94,9.47,10.56,11.44,11.59,11.06,8.81,6.38,1.62,-1.16,-4.16,-6.12,-6.16,-4.16,-2.59,0.19,2.81,4.62,5.53,6.31,6.72,6.91,7.56,8.44,8.59,8.69,8.38,7.59,6.5,6.41,6.22,5.69,6.03,5.78,6.5,6.66,7.28,8.31,9.16,10.44,12.69,14.72,17.06,19.06,19.62,19.41,18.25,17.09,15.5,13.81,12.34,11.12,9.75,8.31,6.91,6.53,5.0,5.03,4.75,5.41,5.34,5.53,6.38,7.06,8.0,9.84,12.06,14.69,15.84,16.69,16.88,16.22,15.09,13.16,10.94,8.41,5.56,4.03,3.16,2.69,3.34,4.22,4.81,6.25,8.06,10.41,13.38,16.44,18.78,21.31,21.78,21.5,20.34,19.59,17.19,15.41,14.31,14.16,14.69,15.12,15.97,16.12,15.0,13.44,12.0,11.16,10.72,11.16,12.81,14.06,14.78,16.12,16.81,16.81,17.5,17.5,16.78,15.81,14.56,-30.78,-32.78,-32.09,-30.78,-28.0,-23.97:24.56,23.25,20.69,18.94,16.16,13.69,12.19,10.56,10.84,12.84,14.56,17.16,19.81,22.44,24.66,26.91,28.38,30.19,31.19,31.38,31.34,31.06,30.59,29.78,28.84,28.06,28.06,28.06,28.28,30.19,31.66,33.31,33.81,33.19,32.81,31.0,29.62,29.12,30.38,31.19,32.09,32.59,32.66,31.91,31.84,30.81,30.47,30.16,29.56,28.69,28.81,28.03,28.94,28.25,27.94,27.5,26.03,24.5,22.06,20.84,19.0,17.88,17.34,17.03,17.72,18.62,18.72,20.31,21.06,22.12,23.0,23.81,23.75,25.03,25.25,26.34,26.16,25.41,23.97,22.28,20.81,19.56,19.69,19.88,20.97,22.47,24.81,26.31,27.69,28.94,28.69,26.41,24.16,20.28,16.03,13.03,10.0,7.38,5.5,2.53,1.56,-0.91,-1.97,-2.22,-1.72,-1.22,-0.28,0.75,2.62,3.22,5.28,7.03,7.56,8.75,8.72,9.53,10.31,10.38,11.16,12.34,15.03,17.47,19.72,22.53,23.69,23.47,23.47,22.03,20.34,19.91,19.81,20.72,21.41,22.38,21.5,20.75,19.03,15.84,13.19,11.09,9.03,6.94,5.69,5.81,6.16,7.44,9.31,10.28,11.19,10.5,8.31,6.78,5.31,4.91,5.69,7.91,10.88,12.88,15.03,17.78,18.06,18.97,19.16,17.91,16.31,13.44,12.0,11.16,10.44,11.09,12.38,13.06,13.75,13.59,12.56,10.62,9.25,7.16,6.53,5.72,6.16,6.44,7.38,7.25,8.12,8.5,8.31,8.72,8.88,8.62,8.94,8.41,9.41,10.62,12.0,12.84,13.34,13.25,12.16,11.75,10.94,10.66,11.56,12.72,13.81,14.94,15.56,16.5,17.34,17.31,19.62,21.19,22.78,25.25,26.84,28.94,31.34,33.12,35.34,36.38,37.09,35.62,34.72,32.81,30.66,28.34,26.47,25.78,26.06,25.66,25.69,26.34,26.03,26.53,25.56,25.56,24.59,22.31,20.06,18.0,16.06,14.31,13.38,12.78,13.31,14.19,14.53,15.06,16.84,17.56,17.38,17.66,18.38,19.34,18.88,19.25,19.06,18.81,18.16,17.91,17.34,16.5,14.75,13.75,12.0,9.81,9.81,9.72,10.28,11.06,12.22,12.84,12.94,13.0,13.03,13.91,14.22,15.44,15.06,16.03,15.06,14.06,12.41,10.72,10.44,9.91,10.91,12.94,15.03,17.72,20.94,23.56,26.0,26.62,25.59,25.25,22.12,20.91,19.91,19.09,19.62,19.12,18.34,18.25,17.22,16.19,15.06,15.06,13.5,11.94,11.28,10.28,10.59,12.16,15.81,19.62,23.56,27.06,28.84,29.62,29.47,28.41,26.53,25.41,24.06,23.0,22.91,22.5,21.72,20.47,18.44,16.44,13.97,13.12,14.59,16.19,19.34,22.72,25.66,27.5,29.19,29.25,29.09,28.81,27.53,27.0,27.31,27.38,27.94,28.09,29.31,30.0,30.41,30.56,29.88,28.06,26.16,22.78,20.28,18.94,18.59,19.91,21.94,24.59,27.25,28.84,29.56,29.94,29.91,28.97,28.84,28.69,28.81,28.25,26.62,24.88,22.19,19.84,17.16,15.03,14.5,14.28,14.56,15.19,15.53,15.78,17.31,18.25,20.19,22.09,24.25,24.84,25.0,23.78,23.56,22.12,19.84,19.25,18.69,18.78,19.91,21.66,24.69,25.28,25.31,24.03,21.22,18.03,15.06,13.44,11.62,10.94,10.31,10.5,9.88,10.19,9.88,9.78,9.81,9.66,8.94,8.75,8.81,8.78,9.19,9.84,10.16,11.78,12.34,13.56,14.34,15.47,16.19,16.34,16.38,17.62,17.41,17.91,18.22,18.22,17.81,17.66,17.5,18.34,19.91,21.25,22.16,22.84,22.69,22.28,20.75,18.0,15.38,13.44,11.06,9.75,9.31,10.5,11.12,12.56,13.88,15.69,17.66,18.69,19.12,19.81,19.31,19.19,18.5,19.06,17.81,18.0,17.44,17.72,19.03,20.16,21.47,22.03,23.09,23.03,22.0,21.0,20.75,18.91,18.06,16.59,15.06,13.97,11.66,11.03,10.75,11.0,12.75,13.31,15.25,16.31,17.75,18.22,18.34,17.59,16.62,14.28,11.91,10.75,10.28,10.81,10.78,12.31,13.06,14.06,13.97,14.5,14.28,14.44,14.53,14.19,14.19,13.69,13.44,11.75,12.0,12.19,12.19,12.41,12.69,13.75,13.97,14.5,14.41,14.34,14.59,14.12,14.94,16.47,17.5,19.12,19.69,19.69,18.72,16.81,15.06,14.41,12.81,13.16,13.06,13.75,15.03,16.16,16.75,17.56,17.5,17.88,17.72,17.78,18.59,19.34,20.06,20.56,20.62,20.16,20.12,19.94,20.59,21.62,22.28,22.25,22.22,21.38,20.53,19.53,19.31,19.16,19.56,18.75,18.78,17.81,17.06,16.94,16.41,16.47,16.38,15.53,14.81,13.72,12.81,12.41,13.0,13.84,14.06,15.12,14.75,14.44,14.0,14.0,13.75,14.22,15.03,16.12,16.06,16.66,16.12,16.06,15.94,15.47,15.59,14.88,14.38,13.44,11.84,11.0,9.81,8.31,8.03,6.94,6.81,6.5,7.0,8.22,9.06,10.16,11.38,11.25,11.47,11.72,11.47,12.03,12.75,13.38,14.69,14.53,15.03,15.84,15.62,15.94,16.34,15.72,14.28,13.81,12.09,10.41,9.19,7.66,6.53,6.03,4.75,5.81,6.47,8.75,12.0,14.91,18.44,21.19,23.81,24.84,25.69,26.44,26.38,24.62,24.22,22.56,20.72,19.19,17.25,17.38,17.88,18.81,20.16,23.16,26.03,27.06,27.41,27.09,25.31,22.94,21.19,19.25,18.81,18.16,18.88,18.78,20.31,21.31,22.06,22.62,22.78,21.12,19.88,16.66,14.78,13.03,11.53,10.72,11.56,11.62,12.84,13.47,14.5,14.66,14.81,14.59,14.53,14.16,14.69,13.84,13.75,13.44,13.69,12.91,11.81,11.62,10.25,8.94,8.16,6.81,6.44,6.03,4.44,4.34,4.97,6.41,8.78,9.72,10.75,11.44,11.25,10.5,11.12,12.44,14.12,15.28,16.84,17.94,18.47,19.59,20.56,22.06,23.62,24.38,24.81,24.22,22.91,22.25,21.03,21.06,21.25,22.5,23.5,23.53,24.12,23.44,23.12,21.72,20.66,20.38,19.59,17.38,16.94,14.56,12.0,9.5,7.41,6.25,5.03,5.28,6.31,6.94,9.47,10.56,11.44,11.59,11.06,8.81,6.38,1.62,-1.16,-4.16,-6.12,-6.16,-4.16,-2.59,0.19,2.81,4.62,5.53,6.31,6.72,6.91,7.56,8.44,8.59,8.69,8.38,7.59,6.5,6.41,6.22,5.69,6.03,5.78,6.5,6.66,7.28,8.31,9.16,10.44,12.69,14.72,17.06,19.06,19.62,19.41,18.25,17.09,15.5,13.81,12.34,11.12,9.75,8.31,6.91,6.53,5.0,5.03,4.75,5.41,5.34,5.53,6.38,7.06,8.0,9.84,12.06,14.69,15.84,16.69,16.88,16.22,15.09,13.16,10.94,8.41,5.56,4.03,3.16,2.69,3.34,4.22,4.81,6.25,8.06,10.41,13.38,16.44,18.78,21.31,21.78,21.5,20.34,19.59,17.19,15.41,14.31,14.16,14.69,15.12,15.97,16.12,15.0,13.44,12.0,11.16,10.72,11.16,12.81,14.06,14.78,16.12,16.81,16.81,17.5,17.5,16.78,15.81,14.56,-30.78,-32.78,-32.09,-30.78,-28.0,-23.97,-19.47,-15.53,-11.47,-7.66,-5.66,-6.53:12.19,10.56,10.84,12.84,14.56,17.16,19.81,22.44,24.66,26.91,28.38,30.19,31.19,31.38,31.34,31.06,30.59,29.78,28.84,28.06,28.06,28.06,28.28,30.19,31.66,33.31,33.81,33.19,32.81,31.0,29.62,29.12,30.38,31.19,32.09,32.59,32.66,31.91,31.84,30.81,30.47,30.16,29.56,28.69,28.81,28.03,28.94,28.25,27.94,27.5,26.03,24.5,22.06,20.84,19.0,17.88,17.34,17.03,17.72,18.62,18.72,20.31,21.06,22.12,23.0,23.81,23.75,25.03,25.25,26.34,26.16,25.41,23.97,22.28,20.81,19.56,19.69,19.88,20.97,22.47,24.81,26.31,27.69,28.94,28.69,26.41,24.16,20.28,16.03,13.03,10.0,7.38,5.5,2.53,1.56,-0.91,-1.97,-2.22,-1.72,-1.22,-0.28,0.75,2.62,3.22,5.28,7.03,7.56,8.75,8.72,9.53,10.31,10.38,11.16,12.34,15.03,17.47,19.72,22.53,23.69,23.47,23.47,22.03,20.34,19.91,19.81,20.72,21.41,22.38,21.5,20.75,19.03,15.84,13.19,11.09,9.03,6.94,5.69,5.81,6.16,7.44,9.31,10.28,11.19,10.5,8.31,6.78,5.31,4.91,5.69,7.91,10.88,12.88,15.03,17.78,18.06,18.97,19.16,17.91,16.31,13.44,12.0,11.16,10.44,11.09,12.38,13.06,13.75,13.59,12.56,10.62,9.25,7.16,6.53,5.72,6.16,6.44,7.38,7.25,8.12,8.5,8.31,8.72,8.88,8.62,8.94,8.41,9.41,10.62,12.0,12.84,13.34,13.25,12.16,11.75,10.94,10.66,11.56,12.72,13.81,14.94,15.56,16.5,17.34,17.31,19.62,21.19,22.78,25.25,26.84,28.94,31.34,33.12,35.34,36.38,37.09,35.62,34.72,32.81,30.66,28.34,26.47,25.78,26.06,25.66,25.69,26.34,26.03,26.53,25.56,25.56,24.59,22.31,20.06,18.0,16.06,14.31,13.38,12.78,13.31,14.19,14.53,15.06,16.84,17.56,17.38,17.66,18.38,19.34,18.88,19.25,19.06,18.81,18.16,17.91,17.34,16.5,14.75,13.75,12.0,9.81,9.81,9.72,10.28,11.06,12.22,12.84,12.94,13.0,13.03,13.91,14.22,15.44,15.06,16.03,15.06,14.06,12.41,10.72,10.44,9.91,10.91,12.94,15.03,17.72,20.94,23.56,26.0,26.62,25.59,25.25,22.12,20.91,19.91,19.09,19.62,19.12,18.34,18.25,17.22,16.19,15.06,15.06,13.5,11.94,11.28,10.28,10.59,12.16,15.81,19.62,23.56,27.06,28.84,29.62,29.47,28.41,26.53,25.41,24.06,23.0,22.91,22.5,21.72,20.47,18.44,16.44,13.97,13.12,14.59,16.19,19.34,22.72,25.66,27.5,29.19,29.25,29.09,28.81,27.53,27.0,27.31,27.38,27.94,28.09,29.31,30.0,30.41,30.56,29.88,28.06,26.16,22.78,20.28,18.94,18.59,19.91,21.94,24.59,27.25,28.84,29.56,29.94,29.91,28.97,28.84,28.69,28.81,28.25,26.62,24.88,22.19,19.84,17.16,15.03,14.5,14.28,14.56,15.19,15.53,15.78,17.31,18.25,20.19,22.09,24.25,24.84,25.0,23.78,23.56,22.12,19.84,19.25,18.69,18.78,19.91,21.66,24.69,25.28,25.31,24.03,21.22,18.03,15.06,13.44,11.62,10.94,10.31,10.5,9.88,10.19,9.88,9.78,9.81,9.66,8.94,8.75,8.81,8.78,9.19,9.84,10.16,11.78,12.34,13.56,14.34,15.47,16.19,16.34,16.38,17.62,17.41,17.91,18.22,18.22,17.81,17.66,17.5,18.34,19.91,21.25,22.16,22.84,22.69,22.28,20.75,18.0,15.38,13.44,11.06,9.75,9.31,10.5,11.12,12.56,13.88,15.69,17.66,18.69,19.12,19.81,19.31,19.19,18.5,19.06,17.81,18.0,17.44,17.72,19.03,20.16,21.47,22.03,23.09,23.03,22.0,21.0,20.75,18.91,18.06,16.59,15.06,13.97,11.66,11.03,10.75,11.0,12.75,13.31,15.25,16.31,17.75,18.22,18.34,17.59,16.62,14.28,11.91,10.75,10.28,10.81,10.78,12.31,13.06,14.06,13.97,14.5,14.28,14.44,14.53,14.19,14.19,13.69,13.44,11.75,12.0,12.19,12.19,12.41,12.69,13.75,13.97,14.5,14.41,14.34,14.59,14.12,14.94,16.47,17.5,19.12,19.69,19.69,18.72,16.81,15.06,14.41,12.81,13.16,13.06,13.75,15.03,16.16,16.75,17.56,17.5,17.88,17.72,17.78,18.59,19.34,20.06,20.56,20.62,20.16,20.12,19.94,20.59,21.62,22.28,22.25,22.22,21.38,20.53,19.53,19.31,19.16,19.56,18.75,18.78,17.81,17.06,16.94,16.41,16.47,16.38,15.53,14.81,13.72,12.81,12.41,13.0,13.84,14.06,15.12,14.75,14.44,14.0,14.0,13.75,14.22,15.03,16.12,16.06,16.66,16.12,16.06,15.94,15.47,15.59,14.88,14.38,13.44,11.84,11.0,9.81,8.31,8.03,6.94,6.81,6.5,7.0,8.22,9.06,10.16,11.38,11.25,11.47,11.72,11.47,12.03,12.75,13.38,14.69,14.53,15.03,15.84,15.62,15.94,16.34,15.72,14.28,13.81,12.09,10.41,9.19,7.66,6.53,6.03,4.75,5.81,6.47,8.75,12.0,14.91,18.44,21.19,23.81,24.84,25.69,26.44,26.38,24.62,24.22,22.56,20.72,19.19,17.25,17.38,17.88,18.81,20.16,23.16,26.03,27.06,27.41,27.09,25.31,22.94,21.19,19.25,18.81,18.16,18.88,18.78,20.31,21.31,22.06,22.62,22.78,21.12,19.88,16.66,14.78,13.03,11.53,10.72,11.56,11.62,12.84,13.47,14.5,14.66,14.81,14.59,14.53,14.16,14.69,13.84,13.75,13.44,13.69,12.91,11.81,11.62,10.25,8.94,8.16,6.81,6.44,6.03,4.44,4.34,4.97,6.41,8.78,9.72,10.75,11.44,11.25,10.5,11.12,12.44,14.12,15.28,16.84,17.94,18.47,19.59,20.56,22.06,23.62,24.38,24.81,24.22,22.91,22.25,21.03,21.06,21.25,22.5,23.5,23.53,24.12,23.44,23.12,21.72,20.66,20.38,19.59,17.38,16.94,14.56,12.0,9.5,7.41,6.25,5.03,5.28,6.31,6.94,9.47,10.56,11.44,11.59,11.06,8.81,6.38,1.62,-1.16,-4.16,-6.12,-6.16,-4.16,-2.59,0.19,2.81,4.62,5.53,6.31,6.72,6.91,7.56,8.44,8.59,8.69,8.38,7.59,6.5,6.41,6.22,5.69,6.03,5.78,6.5,6.66,7.28,8.31,9.16,10.44,12.69,14.72,17.06,19.06,19.62,19.41,18.25,17.09,15.5,13.81,12.34,11.12,9.75,8.31,6.91,6.53,5.0,5.03,4.75,5.41,5.34,5.53,6.38,7.06,8.0,9.84,12.06,14.69,15.84,16.69,16.88,16.22,15.09,13.16,10.94,8.41,5.56,4.03,3.16,2.69,3.34,4.22,4.81,6.25,8.06,10.41,13.38,16.44,18.78,21.31,21.78,21.5,20.34,19.59,17.19,15.41,14.31,14.16,14.69,15.12,15.97,16.12,15.0,13.44,12.0,11.16,10.72,11.16,12.81,14.06,14.78,16.12,16.81,16.81,17.5,17.5,16.78,15.81,14.56,-30.78,-32.78,-32.09,-30.78,-28.0,-23.97,-19.47,-15.53,-11.47,-7.66,-5.66,-6.53,-6.84,-8.47,-12.06,-14.78,-19.19,-22.38:19.81,22.44,24.66,26.91,28.38,30.19,31.19,31.38,31.34,31.06,30.59,29.78,28.84,28.06,28.06,28.06,28.28,30.19,31.66,33.31,33.81,33.19,32.81,31.0,29.62,29.12,30.38,31.19,32.09,32.59,32.66,31.91,31.84,30.81,30.47,30.16,29.56,28.69,28.81,28.03,28.94,28.25,27.94,27.5,26.03,24.5,22.06,20.84,19.0,17.88,17.34,17.03,17.72,18.62,18.72,20.31,21.06,22.12,23.0,23.81,23.75,25.03,25.25,26.34,26.16,25.41,23.97,22.28,20.81,19.56,19.69,19.88,20.97,22.47,24.81,26.31,27.69,28.94,28.69,26.41,24.16,20.28,16.03,13.03,10.0,7.38,5.5,2.53,1.56,-0.91,-1.97,-2.22,-1.72,-1.22,-0.28,0.75,2.62,3.22,5.28,7.03,7.56,8.75,8.72,9.53,10.31,10.38,11.16,12.34,15.03,17.47,19.72,22.53,23.69,23.47,23.47,22.03,20.34,19.91,19.81,20.72,21.41,22.38,21.5,20.75,19.03,15.84,13.19,11.09,9.03,6.94,5.69,5.81,6.16,7.44,9.31,10.28,11.19,10.5,8.31,6.78,5.31,4.91,5.69,7.91,10.88,12.88,15.03,17.78,18.06,18.97,19.16,17.91,16.31,13.44,12.0,11.16,10.44,11.09,12.38,13.06,13.75,13.59,12.56,10.62,9.25,7.16,6.53,5.72,6.16,6.44,7.38,7.25,8.12,8.5,8.31,8.72,8.88,8.62,8.94,8.41,9.41,10.62,12.0,12.84,13.34,13.25,12.16,11.75,10.94,10.66,11.56,12.72,13.81,14.94,15.56,16.5,17.34,17.31,19.62,21.19,22.78,25.25,26.84,28.94,31.34,33.12,35.34,36.38,37.09,35.62,34.72,32.81,30.66,28.34,26.47,25.78,26.06,25.66,25.69,26.34,26.03,26.53,25.56,25.56,24.59,22.31,20.06,18.0,16.06,14.31,13.38,12.78,13.31,14.19,14.53,15.06,16.84,17.56,17.38,17.66,18.38,19.34,18.88,19.25,19.06,18.81,18.16,17.91,17.34,16.5,14.75,13.75,12.0,9.81,9.81,9.72,10.28,11.06,12.22,12.84,12.94,13.0,13.03,13.91,14.22,15.44,15.06,16.03,15.06,14.06,12.41,10.72,10.44,9.91,10.91,12.94,15.03,17.72,20.94,23.56,26.0,26.62,25.59,25.25,22.12,20.91,19.91,19.09,19.62,19.12,18.34,18.25,17.22,16.19,15.06,15.06,13.5,11.94,11.28,10.28,10.59,12.16,15.81,19.62,23.56,27.06,28.84,29.62,29.47,28.41,26.53,25.41,24.06,23.0,22.91,22.5,21.72,20.47,18.44,16.44,13.97,13.12,14.59,16.19,19.34,22.72,25.66,27.5,29.19,29.25,29.09,28.81,27.53,27.0,27.31,27.38,27.94,28.09,29.31,30.0,30.41,30.56,29.88,28.06,26.16,22.78,20.28,18.94,18.59,19.91,21.94,24.59,27.25,28.84,29.56,29.94,29.91,28.97,28.84,28.69,28.81,28.25,26.62,24.88,22.19,19.84,17.16,15.03,14.5,14.28,14.56,15.19,15.53,15.78,17.31,18.25,20.19,22.09,24.25,24.84,25.0,23.78,23.56,22.12,19.84,19.25,18.69,18.78,19.91,21.66,24.69,25.28,25.31,24.03,21.22,18.03,15.06,13.44,11.62,10.94,10.31,10.5,9.88,10.19,9.88,9.78,9.81,9.66,8.94,8.75,8.81,8.78,9.19,9.84,10.16,11.78,12.34,13.56,14.34,15.47,16.19,16.34,16.38,17.62,17.41,17.91,18.22,18.22,17.81,17.66,17.5,18.34,19.91,21.25,22.16,22.84,22.69,22.28,20.75,18.0,15.38,13.44,11.06,9.75,9.31,10.5,11.12,12.56,13.88,15.69,17.66,18.69,19.12,19.81,19.31,19.19,18.5,19.06,17.81,18.0,17.44,17.72,19.03,20.16,21.47,22.03,23.09,23.03,22.0,21.0,20.75,18.91,18.06,16.59,15.06,13.97,11.66,11.03,10.75,11.0,12.75,13.31,15.25,16.31,17.75,18.22,18.34,17.59,16.62,14.28,11.91,10.75,10.28,10.81,10.78,12.31,13.06,14.06,13.97,14.5,14.28,14.44,14.53,14.19,14.19,13.69,13.44,11.75,12.0,12.19,12.19,12.41,12.69,13.75,13.97,14.5,14.41,14.34,14.59,14.12,14.94,16.47,17.5,19.12,19.69,19.69,18.72,16.81,15.06,14.41,12.81,13.16,13.06,13.75,15.03,16.16,16.75,17.56,17.5,17.88,17.72,17.78,18.59,19.34,20.06,20.56,20.62,20.16,20.12,19.94,20.59,21.62,22.28,22.25,22.22,21.38,20.53,19.53,19.31,19.16,19.56,18.75,18.78,17.81,17.06,16.94,16.41,16.47,16.38,15.53,14.81,13.72,12.81,12.41,13.0,13.84,14.06,15.12,14.75,14.44,14.0,14.0,13.75,14.22,15.03,16.12,16.06,16.66,16.12,16.06,15.94,15.47,15.59,14.88,14.38,13.44,11.84,11.0,9.81,8.31,8.03,6.94,6.81,6.5,7.0,8.22,9.06,10.16,11.38,11.25,11.47,11.72,11.47,12.03,12.75,13.38,14.69,14.53,15.03,15.84,15.62,15.94,16.34,15.72,14.28,13.81,12.09,10.41,9.19,7.66,6.53,6.03,4.75,5.81,6.47,8.75,12.0,14.91,18.44,21.19,23.81,24.84,25.69,26.44,26.38,24.62,24.22,22.56,20.72,19.19,17.25,17.38,17.88,18.81,20.16,23.16,26.03,27.06,27.41,27.09,25.31,22.94,21.19,19.25,18.81,18.16,18.88,18.78,20.31,21.31,22.06,22.62,22.78,21.12,19.88,16.66,14.78,13.03,11.53,10.72,11.56,11.62,12.84,13.47,14.5,14.66,14.81,14.59,14.53,14.16,14.69,13.84,13.75,13.44,13.69,12.91,11.81,11.62,10.25,8.94,8.16,6.81,6.44,6.03,4.44,4.34,4.97,6.41,8.78,9.72,10.75,11.44,11.25,10.5,11.12,12.44,14.12,15.28,16.84,17.94,18.47,19.59,20.56,22.06,23.62,24.38,24.81,24.22,22.91,22.25,21.03,21.06,21.25,22.5,23.5,23.53,24.12,23.44,23.12,21.72,20.66,20.38,19.59,17.38,16.94,14.56,12.0,9.5,7.41,6.25,5.03,5.28,6.31,6.94,9.47,10.56,11.44,11.59,11.06,8.81,6.38,1.62,-1.16,-4.16,-6.12,-6.16,-4.16,-2.59,0.19,2.81,4.62,5.53,6.31,6.72,6.91,7.56,8.44,8.59,8.69,8.38,7.59,6.5,6.41,6.22,5.69,6.03,5.78,6.5,6.66,7.28,8.31,9.16,10.44,12.69,14.72,17.06,19.06,19.62,19.41,18.25,17.09,15.5,13.81,12.34,11.12,9.75,8.31,6.91,6.53,5.0,5.03,4.75,5.41,5.34,5.53,6.38,7.06,8.0,9.84,12.06,14.69,15.84,16.69,16.88,16.22,15.09,13.16,10.94,8.41,5.56,4.03,3.16,2.69,3.34,4.22,4.81,6.25,8.06,10.41,13.38,16.44,18.78,21.31,21.78,21.5,20.34,19.59,17.19,15.41,14.31,14.16,14.69,15.12,15.97,16.12,15.0,13.44,12.0,11.16,10.72,11.16,12.81,14.06,14.78,16.12,16.81,16.81,17.5,17.5,16.78,15.81,14.56,-30.78,-32.78,-32.09,-30.78,-28.0,-23.97,-19.47,-15.53,-11.47,-7.66,-5.66,-6.53,-6.84,-8.47,-12.06,-14.78,-19.19,-22.38,-24.72,-26.78,-26.03,-24.19,-21.53,-17.12:31.19,31.38,31.34,31.06,30.59,29.78,28.84,28.06,28.06,28.06,28.28,30.19,31.66,33.31,33.81,33.19,32.81,31.0,29.62,29.12,30.38,31.19,32.09,32.59,32.66,31.91,31.84,30.81,30.47,30.16,29.56,28.69,28.81,28.03,28.94,28.25,27.94,27.5,26.03,24.5,22.06,20.84,19.0,17.88,17.34,17.03,17.72,18.62,18.72,20.31,21.06,22.12,23.0,23.81,23.75,25.03,25.25,26.34,26.16,25.41,23.97,22.28,20.81,19.56,19.69,19.88,20.97,22.47,24.81,26.31,27.69,28.94,28.69,26.41,24.16,20.28,16.03,13.03,10.0,7.38,5.5,2.53,1.56,-0.91,-1.97,-2.22,-1.72,-1.22,-0.28,0.75,2.62,3.22,5.28,7.03,7.56,8.75,8.72,9.53,10.31,10.38,11.16,12.34,15.03,17.47,19.72,22.53,23.69,23.47,23.47,22.03,20.34,19.91,19.81,20.72,21.41,22.38,21.5,20.75,19.03,15.84,13.19,11.09,9.03,6.94,5.69,5.81,6.16,7.44,9.31,10.28,11.19,10.5,8.31,6.78,5.31,4.91,5.69,7.91,10.88,12.88,15.03,17.78,18.06,18.97,19.16,17.91,16.31,13.44,12.0,11.16,10.44,11.09,12.38,13.06,13.75,13.59,12.56,10.62,9.25,7.16,6.53,5.72,6.16,6.44,7.38,7.25,8.12,8.5,8.31,8.72,8.88,8.62,8.94,8.41,9.41,10.62,12.0,12.84,13.34,13.25,12.16,11.75,10.94,10.66,11.56,12.72,13.81,14.94,15.56,16.5,17.34,17.31,19.62,21.19,22.78,25.25,26.84,28.94,31.34,33.12,35.34,36.38,37.09,35.62,34.72,32.81,30.66,28.34,26.47,25.78,26.06,25.66,25.69,26.34,26.03,26.53,25.56,25.56,24.59,22.31,20.06,18.0,16.06,14.31,13.38,12.78,13.31,14.19,14.53,15.06,16.84,17.56,17.38,17.66,18.38,19.34,18.88,19.25,19.06,18.81,18.16,17.91,17.34,16.5,14.75,13.75,12.0,9.81,9.81,9.72,10.28,11.06,12.22,12.84,12.94,13.0,13.03,13.91,14.22,15.44,15.06,16.03,15.06,14.06,12.41,10.72,10.44,9.91,10.91,12.94,15.03,17.72,20.94,23.56,26.0,26.62,25.59,25.25,22.12,20.91,19.91,19.09,19.62,19.12,18.34,18.25,17.22,16.19,15.06,15.06,13.5,11.94,11.28,10.28,10.59,12.16,15.81,19.62,23.56,27.06,28.84,29.62,29.47,28.41,26.53,25.41,24.06,23.0,22.91,22.5,21.72,20.47,18.44,16.44,13.97,13.12,14.59,16.19,19.34,22.72,25.66,27.5,29.19,29.25,29.09,28.81,27.53,27.0,27.31,27.38,27.94,28.09,29.31,30.0,30.41,30.56,29.88,28.06,26.16,22.78,20.28,18.94,18.59,19.91,21.94,24.59,27.25,28.84,29.56,29.94,29.91,28.97,28.84,28.69,28.81,28.25,26.62,24.88,22.19,19.84,17.16,15.03,14.5,14.28,14.56,15.19,15.53,15.78,17.31,18.25,20.19,22.09,24.25,24.84,25.0,23.78,23.56,22.12,19.84,19.25,18.69,18.78,19.91,21.66,24.69,25.28,25.31,24.03,21.22,18.03,15.06,13.44,11.62,10.94,10.31,10.5,9.88,10.19,9.88,9.78,9.81,9.66,8.94,8.75,8.81,8.78,9.19,9.84,10.16,11.78,12.34,13.56,14.34,15.47,16.19,16.34,16.38,17.62,17.41,17.91,18.22,18.22,17.81,17.66,17.5,18.34,19.91,21.25,22.16,22.84,22.69,22.28,20.75,18.0,15.38,13.44,11.06,9.75,9.31,10.5,11.12,12.56,13.88,15.69,17.66,18.69,19.12,19.81,19.31,19.19,18.5,19.06,17.81,18.0,17.44,17.72,19.03,20.16,21.47,22.03,23.09,23.03,22.0,21.0,20.75,18.91,18.06,16.59,15.06,13.97,11.66,11.03,10.75,11.0,12.75,13.31,15.25,16.31,17.75,18.22,18.34,17.59,16.62,14.28,11.91,10.75,10.28,10.81,10.78,12.31,13.06,14.06,13.97,14.5,14.28,14.44,14.53,14.19,14.19,13.69,13.44,11.75,12.0,12.19,12.19,12.41,12.69,13.75,13.97,14.5,14.41,14.34,14.59,14.12,14.94,16.47,17.5,19.12,19.69,19.69,18.72,16.81,15.06,14.41,12.81,13.16,13.06,13.75,15.03,16.16,16.75,17.56,17.5,17.88,17.72,17.78,18.59,19.34,20.06,20.56,20.62,20.16,20.12,19.94,20.59,21.62,22.28,22.25,22.22,21.38,20.53,19.53,19.31,19.16,19.56,18.75,18.78,17.81,17.06,16.94,16.41,16.47,16.38,15.53,14.81,13.72,12.81,12.41,13.0,13.84,14.06,15.12,14.75,14.44,14.0,14.0,13.75,14.22,15.03,16.12,16.06,16.66,16.12,16.06,15.94,15.47,15.59,14.88,14.38,13.44,11.84,11.0,9.81,8.31,8.03,6.94,6.81,6.5,7.0,8.22,9.06,10.16,11.38,11.25,11.47,11.72,11.47,12.03,12.75,13.38,14.69,14.53,15.03,15.84,15.62,15.94,16.34,15.72,14.28,13.81,12.09,10.41,9.19,7.66,6.53,6.03,4.75,5.81,6.47,8.75,12.0,14.91,18.44,21.19,23.81,24.84,25.69,26.44,26.38,24.62,24.22,22.56,20.72,19.19,17.25,17.38,17.88,18.81,20.16,23.16,26.03,27.06,27.41,27.09,25.31,22.94,21.19,19.25,18.81,18.16,18.88,18.78,20.31,21.31,22.06,22.62,22.78,21.12,19.88,16.66,14.78,13.03,11.53,10.72,11.56,11.62,12.84,13.47,14.5,14.66,14.81,14.59,14.53,14.16,14.69,13.84,13.75,13.44,13.69,12.91,11.81,11.62,10.25,8.94,8.16,6.81,6.44,6.03,4.44,4.34,4.97,6.41,8.78,9.72,10.75,11.44,11.25,10.5,11.12,12.44,14.12,15.28,16.84,17.94,18.47,19.59,20.56,22.06,23.62,24.38,24.81,24.22,22.91,22.25,21.03,21.06,21.25,22.5,23.5,23.53,24.12,23.44,23.12,21.72,20.66,20.38,19.59,17.38,16.94,14.56,12.0,9.5,7.41,6.25,5.03,5.28,6.31,6.94,9.47,10.56,11.44,11.59,11.06,8.81,6.38,1.62,-1.16,-4.16,-6.12,-6.16,-4.16,-2.59,0.19,2.81,4.62,5.53,6.31,6.72,6.91,7.56,8.44,8.59,8.69,8.38,7.59,6.5,6.41,6.22,5.69,6.03,5.78,6.5,6.66,7.28,8.31,9.16,10.44,12.69,14.72,17.06,19.06,19.62,19.41,18.25,17.09,15.5,13.81,12.34,11.12,9.75,8.31,6.91,6.53,5.0,5.03,4.75,5.41,5.34,5.53,6.38,7.06,8.0,9.84,12.06,14.69,15.84,16.69,16.88,16.22,15.09,13.16,10.94,8.41,5.56,4.03,3.16,2.69,3.34,4.22,4.81,6.25,8.06,10.41,13.38,16.44,18.78,21.31,21.78,21.5,20.34,19.59,17.19,15.41,14.31,14.16,14.69,15.12,15.97,16.12,15.0,13.44,12.0,11.16,10.72,11.16,12.81,14.06,14.78,16.12,16.81,16.81,17.5,17.5,16.78,15.81,14.56,-30.78,-32.78,-32.09,-30.78,-28.0,-23.97,-19.47,-15.53,-11.47,-7.66,-5.66,-6.53,-6.84,-8.47,-12.06,-14.78,-19.19,-22.38,-24.72,-26.78,-26.03,-24.19,-21.53,-17.12,-13.22,-9.47,-6.0,-2.84,-0.97,1.12:negativity
12.19,15.62,18.19,21.31,23.38,24.41,24.28,23.66,22.62,21.69,21.06,20.47,19.78,18.22,16.66,14.97,12.88,11.81,11.84,10.84,11.06,10.28,9.84,8.19,7.62,7.25,8.62,9.41,12.16,15.84,19.31,23.41,28.12,32.06,35.94,38.44,40.91,40.53,40.69,39.5,38.72,38.0,38.31,38.88,38.41,37.44,35.19,32.97,29.44,26.5,25.44,24.53,24.88,26.19,29.03,32.19,36.31,40.44,44.38,47.03,47.16,46.72,43.69,38.78,33.41,28.72,23.66,20.12,17.41,14.28,11.41,8.06,5.03,2.5,-0.53,-0.88,-0.84,0.72,3.44,7.34,11.41,15.06,18.28,21.31,23.41,23.47,23.62,22.25,21.38,20.31,20.31,21.22,23.22,26.0,28.81,31.47,33.41,34.47,33.22,29.69,25.34,20.81,17.16,14.66,13.72,14.84,15.78,17.09,18.91,20.0,20.91,21.94,22.06,22.19,21.69,21.56,21.19,21.16,21.72,21.47,22.78,22.0,20.5,18.91,16.34,13.5,11.41,10.16,9.88,10.62,11.66,14.16,15.53,17.81,19.75,21.28,22.19,23.03,23.81,23.66,24.53,25.19,24.47,24.38,24.53,22.59,20.72,18.62,16.78,15.25,14.22,14.53,14.81,15.03,16.44,17.16,18.19,19.28,20.78,22.44,23.72,25.31,27.12,28.25,30.0,31.06,32.62,34.16,34.25,34.34,33.41,30.28,28.28,24.0,20.5,17.56,14.38,12.16,11.09,10.72,12.03,14.81,17.31,20.53,22.84,24.38,24.91,25.28,24.25,23.31,22.19,21.28,18.62,17.06,16.06,15.62,15.78,15.62,16.84,16.62,16.44,16.34,16.12,16.44,15.78,16.81,18.06,19.34,20.78,23.16,24.94,27.0,28.94,30.91,32.12,32.91,33.91,33.03,31.72,29.97,28.31,26.72,25.34,24.47,23.25,22.38,21.94,20.91,20.19,19.84,18.78,18.38,17.09,15.91,14.25,13.41,12.97,13.31,14.47,16.56,19.38,22.31,25.5,28.5,30.78,31.94,32.28,31.62,30.38,28.0,25.0,23.56,21.81,20.5,21.0,20.44,20.38,19.53,17.75,15.62,13.41,11.81,11.19,11.12,10.81,11.75,11.81,12.81,13.41,14.34,15.38,15.84,16.0,15.62,14.69,14.69,15.31,16.81,18.28,20.12,21.91,23.28,23.25,23.41,23.03,22.03,20.75,20.56,18.91,19.28,18.78,18.06,17.12,16.44,15.12,14.06,13.25,12.66,13.31,13.81,14.94,16.28,17.81,19.44,19.47,20.78,21.16,22.03,22.91,22.28,22.12,20.91,19.81,19.31,18.56,18.12,18.62,16.91,18.09,17.94,18.38,18.97,19.0,19.56,18.19,17.81,16.91,15.81,14.81,14.0,12.78,12.5,11.41,10.66,11.62,12.56,13.44,15.19,17.25,18.12,18.09,18.41,18.09,17.91,18.75,19.16,19.53,20.06,20.53,19.88,19.09,19.53,21.03,22.06,24.12,25.94,27.28,26.34,25.28,23.62,21.44,19.25,17.41,16.81,17.47,18.62,20.31,21.91,23.62,25.59,27.34,29.53,31.31,32.69,32.81,31.84,30.53,30.25,28.56,29.59,29.78,29.31,28.59,26.38,24.91,23.56,21.28,20.81,20.84,20.03,19.78,19.59,19.03,18.62,19.0,20.44,21.66,24.0,25.81,27.25,28.12,28.69,28.34,27.31,26.62,26.5,25.47,25.47,25.44,24.81,24.5,22.44,21.78,20.94,20.0,20.66,21.31,21.0,21.91,22.0,22.16,21.94,22.06,21.47,21.62,22.84,23.59,24.5,24.91,24.84,23.81,22.91,20.81,20.06,19.12,18.34,18.0,18.19,18.06,18.78,19.25,19.31,18.69,17.91,16.81,15.78,16.19,17.22,19.19,21.31,24.5,27.91,29.88,32.5,33.88,33.75,33.06,30.53,27.94,24.41,21.41,19.78,18.72,18.5,19.06,19.0,18.59,18.5,17.25,17.06,17.41,17.75,19.06,21.0,21.72,22.0,22.16,22.06,20.41,19.56,20.19,21.38,22.81,24.88,26.44,26.41,25.66,23.59,20.19,17.16,15.56,12.5,11.91,11.44,10.94,10.5,10.94,12.06,13.0,14.59,16.59,18.5,20.41,21.66,22.94,24.81,25.5,25.91,26.06,24.94,24.28,22.53,22.81,23.5,23.62,23.88,24.16,23.94,23.09,22.44,21.81,20.84,21.06,19.84,19.91,19.34,19.78,19.5,18.56,18.31,18.06,16.31,15.44,15.31,13.94,13.31,12.62,12.28,11.91,11.81,12.06,11.66,10.5,9.38,6.88,4.25,2.94,1.03,1.66,2.69,4.84,8.91,12.53,17.19,21.28,23.09,23.38,22.56,19.06,15.81,12.09,8.69,5.88,3.56,2.31,1.12,0.69,0.19,0.22,1.19,1.19,2.19,3.44,5.75,8.06,11.03,13.56,15.91,17.06,17.56,16.78,16.31,14.91,14.09,13.34,12.84,12.84,13.06,13.5,14.12,14.28,13.66,12.19,10.62,8.38,6.06,4.88,3.19,2.28,1.38,1.16,1.94,3.41,5.88,7.88,11.56,14.06,16.06,17.84,19.25,19.69,19.06,17.91,15.53,13.34,11.03,8.25,6.78,5.53,4.44,4.22,4.41,5.16,6.31,6.47,7.31,7.28,6.47,5.69,3.31,1.62,-0.03,-1.38,-2.16,-1.94,0.62,3.16,5.09,7.38,8.25,9.25,8.16,6.62,6.44,4.91,4.72,6.44,8.06,10.62,13.28,16.25,18.44,19.19,19.78,18.94,17.44,16.09,14.56,13.69,13.72,13.81,14.84,14.78,14.78,14.16,12.31,9.84,7.0,4.69,2.47,1.56,1.72,1.94,2.22,2.84,3.19,4.03,4.94,5.34,6.44,5.78,4.03,2.47,0.09,-1.09,-1.75,-0.69,1.25,2.75,4.25,4.81,5.03,5.19,5.31,4.59,4.81,4.28,4.38,4.03,4.0,4.97,5.81,7.53,8.91,10.75,12.72,14.22,15.84,16.09,16.31,15.0,12.81,10.84,7.94,5.41,2.94,0.62,-1.09,-2.59,-3.34,-2.59,-1.38,0.12,2.84,5.97,8.0,9.88,11.66,12.56,12.25,11.44,10.56,8.62,7.0,5.25,2.97,0.75,0.28,-0.03,-0.59,0.75,1.75,2.59,3.94,3.91,5.0,4.66,4.81,4.53,4.75,4.59,4.66,5.06,5.56,4.56,4.06,2.91,2.62,2.53,4.69,6.38,9.0,10.56,12.06,12.88,12.44,12.81,12.94,13.0,12.34,13.66,14.0,14.53,15.0,15.66,15.34,14.91,13.84,12.09,11.38,9.81,8.81,8.81,8.56,9.34,9.59,9.16,8.88,8.56,8.09,7.03,6.62,5.62,4.44,4.19,3.34,3.94,5.16,6.84,8.78,9.97,11.12,11.38,10.75,9.56,9.0,8.44,7.56,7.69,7.94,8.28,9.25,9.69,10.44,9.94,9.56,8.84,7.53,6.06,5.38,4.44,4.25,4.81,6.72,9.75,12.06,14.69,17.56,19.25,20.91,22.47,21.88,21.34,19.31,16.12,13.25,11.19,9.81,10.12,10.12,10.75,10.88,10.53,9.69,9.81,10.66,12.22,14.94,17.97,20.81,23.34,25.12,24.94,24.53,23.62,22.0,20.81,18.62,17.38,15.19,13.41,12.44,11.25,11.31,11.28,12.28,12.62,12.16,11.53,9.81,7.94,6.62,5.75,6.44,7.78,9.41,11.56,13.25,13.91,14.06,14.62,15.03,15.72,16.53,16.56,16.16,15.31,14.44,12.66,12.66,12.16,11.62,11.28,10.84,9.97,9.5:24.28,23.66,22.62,21.69,21.06,20.47,19.78,18.22,16.66,14.97,12.88,11.81,11.84,10.84,11.06,10.28,9.84,8.19,7.62,7.25,8.62,9.41,12.16,15.84,19.31,23.41,28.12,32.06,35.94,38.44,40.91,40.53,40.69,39.5,38.72,38.0,38.31,38.88,38.41,37.44,35.19,32.97,29.44,26.5,25.44,24.53,24.88,26.19,29.03,32.19,36.31,40.44,44.38,47.03,47.16,46.72,43.69,38.78,33.41,28.72,23.66,20.12,17.41,14.28,11.41,8.06,5.03,2.5,-0.53,-0.88,-0.84,0.72,3.44,7.34,11.41,15.06,18.28,21.31,23.41,23.47,23.62,22.25,21.38,20.31,20.31,21.22,23.22,26.0,28.81,31.47,33.41,34.47,33.22,29.69,25.34,20.81,17.16,14.66,13.72,14.84,15.78,17.09,18.91,20.0,20.91,21.94,22.06,22.19,21.69,21.56,21.19,21.16,21.72,21.47,22.78,22.0,20.5,18.91,16.34,13.5,11.41,10.16,9.88,10.62,11.66,14.16,15.53,17.81,19.75,21.28,22.19,23.03,23.81,23.66,24.53,25.19,24.47,24.38,24.53,22.59,20.72,18.62,16.78,15.25,14.22,14.53,14.81,15.03,16.44,17.16,18.19,19.28,20.78,22.44,23.72,25.31,27.12,28.25,30.0,31.06,32.62,34.16,34.25,34.34,33.41,30.28,28.28,24.0,20.5,17.56,14.38,12.16,11.09,10.72,12.03,14.81,17.31,20.53,22.84,24.38,24.91,25.28,24.25,23.31,22.19,21.28,18.62,17.06,16.06,15.62,15.78,15.62,16.84,16.62,16.44,16.34,16.12,16.44,15.78,16.81,18.06,19.34,20.78,23.16,24.94,27.0,28.94,30.91,32.12,32.91,33.91,33.03,31.72,29.97,28.31,26.72,25.34,24.47,23.25,22.38,21.94,20.91,20.19,19.84,18.78,18.38,17.09,15.91,14.25,13.41,12.97,13.31,14.47,16.56,19.38,22.31,25.5,28.5,30.78,31.94,32.28,31.62,30.38,28.0,25.0,23.56,21.81,20.5,21.0,20.44,20.38,19.53,17.75,15.62,13.41,11.81,11.19,11.12,10.81,11.75,11.81,12.81,13.41,14.34,15.38,15.84,16.0,15.62,14.69,14.69,15.31,16.81,18.28,20.12,21.91,23.28,23.25,23.41,23.03,22.03,20.75,20.56,18.91,19.28,18.78,18.06,17.12,16.44,15.12,14.06,13.25,12.66,13.31,13.81,14.94,16.28,17.81,19.44,19.47,20.78,21.16,22.03,22.91,22.28,22.12,20.91,19.81,19.31,18.56,18.12,18.62,16.91,18.09,17.94,18.38,18.97,19.0,19.56,18.19,17.81,16.91,15.81,14.81,14.0,12.78,12.5,11.41,10.66,11.62,12.56,13.44,15.19,17.25,18.12,18.09,18.41,18.09,17.91,18.75,19.16,19.53,20.06,20.53,19.88,19.09,19.53,21.03,22.06,24.12,25.94,27.28,26.34,25.28,23.62,21.44,19.25,17.41,16.81,17.47,18.62,20.31,21.91,23.62,25.59,27.34,29.53,31.31,32.69,32.81,31.84,30.53,30.25,28.56,29.59,29.78,29.31,28.59,26.38,24.91,23.56,21.28,20.81,20.84,20.03,19.78,19.59,19.03,18.62,19.0,20.44,21.66,24.0,25.81,27.25,28.12,28.69,28.34,27.31,26.62,26.5,25.47,25.47,25.44,24.81,24.5,22.44,21.78,20.94,20.0,20.66,21.31,21.0,21.91,22.0,22.16,21.94,22.06,21.47,21.62,22.84,23.59,24.5,24.91,24.84,23.81,22.91,20.81,20.06,19.12,18.34,18.0,18.19,18.06,18.78,19.25,19.31,18.69,17.91,16.81,15.78,16.19,17.22,19.19,21.31,24.5,27.91,29.88,32.5,33.88,33.75,33.06,30.53,27.94,24.41,21.41,19.78,18.72,18.5,19.06,19.0,18.59,18.5,17.25,17.06,17.41,17.75,19.06,21.0,21.72,22.0,22.16,22.06,20.41,19.56,20.19,21.38,22.81,24.88,26.44,26.41,25.66,23.59,20.19,17.16,15.56,12.5,11.91,11.44,10.94,10.5,10.94,12.06,13.0,14.59,16.59,18.5,20.41,21.66,22.94,24.81,25.5,25.91,26.06,24.94,24.28,22.53,22.81,23.5,23.62,23.88,24.16,23.94,23.09,22.44,21.81,20.84,21.06,19.84,19.91,19.34,19.78,19.5,18.56,18.31,18.06,16.31,15.44,15.31,13.94,13.31,12.62,12.28,11.91,11.81,12.06,11.66,10.5,9.38,6.88,4.25,2.94,1.03,1.66,2.69,4.84,8.91,12.53,17.19,21.28,23.09,23.38,22.56,19.06,15.81,12.09,8.69,5.88,3.56,2.31,1.12,0.69,0.19,0.22,1.19,1.19,2.19,3.44,5.75,8.06,11.03,13.56,15.91,17.06,17.56,16.78,16.31,14.91,14.09,13.34,12.84,12.84,13.06,13.5,14.12,14.28,13.66,12.19,10.62,8.38,6.06,4.88,3.19,2.28,1.38,1.16,1.94,3.41,5.88,7.88,11.56,14.06,16.06,17.84,19.25,19.69,19.06,17.91,15.53,13.34,11.03,8.25,6.78,5.53,4.44,4.22,4.41,5.16,6.31,6.47,7.31,7.28,6.47,5.69,3.31,1.62,-0.03,-1.38,-2.16,-1.94,0.62,3.16,5.09,7.38,8.25,9.25,8.16,6.62,6.44,4.91,4.72,6.44,8.06,10.62,13.28,16.25,18.44,19.19,19.78,18.94,17.44,16.09,14.56,13.69,13.72,13.81,14.84,14.78,14.78,14.16,12.31,9.84,7.0,4.69,2.47,1.56,1.72,1.94,2.22,2.84,3.19,4.03,4.94,5.34,6.44,5.78,4.03,2.47,0.09,-1.09,-1.75,-0.69,1.25,2.75,4.25,4.81,5.03,5.19,5.31,4.59,4.81,4.28,4.38,4.03,4.0,4.97,5.81,7.53,8.91,10.75,12.72,14.22,15.84,16.09,16.31,15.0,12.81,10.84,7.94,5.41,2.94,0.62,-1.09,-2.59,-3.34,-2.59,-1.38,0.12,2.84,5.97,8.0,9.88,11.66,12.56,12.25,11.44,10.56,8.62,7.0,5.25,2.97,0.75,0.28,-0.03,-0.59,0.75,1.75,2.59,3.94,3.91,5.0,4.66,4.81,4.53,4.75,4.59,4.66,5.06,5.56,4.56,4.06,2.91,2.62,2.53,4.69,6.38,9.0,10.56,12.06,12.88,12.44,12.81,12.94,13.0,12.34,13.66,14.0,14.53,15.0,15.66,15.34,14.91,13.84,12.09,11.38,9.81,8.81,8.81,8.56,9.34,9.59,9.16,8.88,8.56,8.09,7.03,6.62,5.62,4.44,4.19,3.34,3.94,5.16,6.84,8.78,9.97,11.12,11.38,10.75,9.56,9.0,8.44,7.56,7.69,7.94,8.28,9.25,9.69,10.44,9.94,9.56,8.84,7.53,6.06,5.38,4.44,4.25,4.81,6.72,9.75,12.06,14.69,17.56,19.25,20.91,22.47,21.88,21.34,19.31,16.12,13.25,11.19,9.81,10.12,10.12,10.75,10.88,10.53,9.69,9.81,10.66,12.22,14.94,17.97,20.81,23.34,25.12,24.94,24.53,23.62,22.0,20.81,18.62,17.38,15.19,13.41,12.44,11.25,11.31,11.28,12.28,12.62,12.16,11.53,9.81,7.94,6.62,5.75,6.44,7.78,9.41,11.56,13.25,13.91,14.06,14.62,15.03,15.72,16.53,16.56,16.16,15.31,14.44,12.66,12.66,12.16,11.62,11.28,10.84,9.97,9.5,-25.03,-23.25,-22.28,-20.59,-20.47,-19.88:19.78,18.22,16.66,14.97,12.88,11.81,11.84,10.84,11.06,10.28,9.84,8.19,7.62,7.25,8.62,9.41,12.16,15.84,19.31,23.41,28.12,32.06,35.94,38.44,40.91,40.53,40.69,39.5,38.72,38.0,38.31,38.88,38.41,37.44,35.19,32.97,29.44,26.5,25.44,24.53,24.88,26.19,29.03,32.19,36.31,40.44,44.38,47.03,47.16,46.72,43.69,38.78,33.41,28.72,23.66,20.12,17.41,14.28,11.41,8.06,5.03,2.5,-0.53,-0.88,-0.84,0.72,3.44,7.34,11.41,15.06,18.28,21.31,23.41,23.47,23.62,22.25,21.38,20.31,20.31,21.22,23.22,26.0,28.81,31.47,33.41,34.47,33.22,29.69,25.34,20.81,17.16,14.66,13.72,14.84,15.78,17.09,18.91,20.0,20.91,21.94,22.06,22.19,21.69,21.56,21.19,21.16,21.72,21.47,22.78,22.0,20.5,18.91,16.34,13.5,11.41,10.16,9.88,10.62,11.66,14.16,15.53,17.81,19.75,21.28,22.19,23.03,23.81,23.66,24.53,25.19,24.47,24.38,24.53,22.59,20.72,18.62,16.78,15.25,14.22,14.53,14.81,15.03,16.44,17.16,18.19,19.28,20.78,22.44,23.72,25.31,27.12,28.25,30.0,31.06,32.62,34.16,34.25,34.34,33.41,30.28,28.28,24.0,20.5,17.56,14.38,12.16,11.09,10.72,12.03,14.81,17.31,20.53,22.84,24.38,24.91,25.28,24.25,23.31,22.19,21.28,18.62,17.06,16.06,15.62,15.78,15.62,16.84,16.62,16.44,16.34,16.12,16.44,15.78,16.81,18.06,19.34,20.78,23.16,24.94,27.0,28.94,30.91,32.12,32.91,33.91,33.03,31.72,29.97,28.31,26.72,25.34,24.47,23.25,22.38,21.94,20.91,20.19,19.84,18.78,18.38,17.09,15.91,14.25,13.41,12.97,13.31,14.47,16.56,19.38,22.31,25.5,28.5,30.78,31.94,32.28,31.62,30.38,28.0,25.0,23.56,21.81,20.5,21.0,20.44,20.38,19.53,17.75,15.62,13.41,11.81,11.19,11.12,10.81,11.75,11.81,12.81,13.41,14.34,15.38,15.84,16.0,15.62,14.69,14.69,15.31,16.81,18.28,20.12,21.91,23.28,23.25,23.41,23.03,22.03,20.75,20.56,18.91,19.28,18.78,18.06,17.12,16.44,15.12,14.06,13.25,12.66,13.31,13.81,14.94,16.28,17.81,19.44,19.47,20.78,21.16,22.03,22.91,22.28,22.12,20.91,19.81,19.31,18.56,18.12,18.62,16.91,18.09,17.94,18.38,18.97,19.0,19.56,18.19,17.81,16.91,15.81,14.81,14.0,12.78,12.5,11.41,10.66,11.62,12.56,13.44,15.19,17.25,18.12,18.09,18.41,18.09,17.91,18.75,19.16,19.53,20.06,20.53,19.88,19.09,19.53,21.03,22.06,24.12,25.94,27.28,26.34,25.28,23.62,21.44,19.25,17.41,16.81,17.47,18.62,20.31,21.91,23.62,25.59,27.34,29.53,31.31,32.69,32.81,31.84,30.53,30.25,28.56,29.59,29.78,29.31,28.59,26.38,24.91,23.56,21.28,20.81,20.84,20.03,19.78,19.59,19.03,18.62,19.0,20.44,21.66,24.0,25.81,27.25,28.12,28.69,28.34,27.31,26.62,26.5,25.47,25.47,25.44,24.81,24.5,22.44,21.78,20.94,20.0,20.66,21.31,21.0,21.91,22.0,22.16,21.94,22.06,21.47,21.62,22.84,23.59,24.5,24.91,24.84,23.81,22.91,20.81,20.06,19.12,18.34,18.0,18.19,18.06,18.78,19.25,19.31,18.69,17.91,16.81,15.78,16.19,17.22,19.19,21.31,24.5,27.91,29.88,32.5,33.88,33.75,33.06,30.53,27.94,24.41,21.41,19.78,18.72,18.5,19.06,19.0,18.59,18.5,17.25,17.06,17.41,17.75,19.06,21.0,21.72,22.0,22.16,22.06,20.41,19.56,20.19,21.38,22.81,24.88,26.44,26.41,25.66,23.59,20.19,17.16,15.56,12.5,11.91,11.44,10.94,10.5,10.94,12.06,13.0,14.59,16.59,18.5,20.41,21.66,22.94,24.81,25.5,25.91,26.06,24.94,24.28,22.53,22.81,23.5,23.62,23.88,24.16,23.94,23.09,22.44,21.81,20.84,21.06,19.84,19.91,19.34,19.78,19.5,18.56,18.31,18.06,16.31,15.44,15.31,13.94,13.31,12.62,12.28,11.91,11.81,12.06,11.66,10.5,9.38,6.88,4.25,2.94,1.03,1.66,2.69,4.84,8.91,12.53,17.19,21.28,23.09,23.38,22.56,19.06,15.81,12.09,8.69,5.88,3.56,2.31,1.12,0.69,0.19,0.22,1.19,1.19,2.19,3.44,5.75,8.06,11.03,13.56,15.91,17.06,17.56,16.78,16.31,14.91,14.09,13.34,12.84,12.84,13.06,13.5,14.12,14.28,13.66,12.19,10.62,8.38,6.06,4.88,3.19,2.28,1.38,1.16,1.94,3.41,5.88,7.88,11.56,14.06,16.06,17.84,19.25,19.69,19.06,17.91,15.53,13.34,11.03,8.25,6.78,5.53,4.44,4.22,4.41,5.16,6.31,6.47,7.31,7.28,6.47,5.69,3.31,1.62,-0.03,-1.38,-2.16,-1.94,0.62,3.16,5.09,7.38,8.25,9.25,8.16,6.62,6.44,4.91,4.72,6.44,8.06,10.62,13.28,16.25,18.44,19.19,19.78,18.94,17.44,16.09,14.56,13.69,13.72,13.81,14.84,14.78,14.78,14.16,12.31,9.84,7.0,4.69,2.47,1.56,1.72,1.94,2.22,2.84,3.19,4.03,4.94,5.34,6.44,5.78,4.03,2.47,0.09,-1.09,-1.75,-0.69,1.25,2.75,4.25,4.81,5.03,5.19,5.31,4.59,4.81,4.28,4.38,4.03,4.0,4.97,5.81,7.53,8.91,10.75,12.72,14.22,15.84,16.09,16.31,15.0,12.81,10.84,7.94,5.41,2.94,0.62,-1.09,-2.59,-3.34,-2.59,-1.38,0.12,2.84,5.97,8.0,9.88,11.66,12.56,12.25,11.44,10.56,8.62,7.0,5.25,2.97,0.75,0.28,-0.03,-0.59,0.75,1.75,2.59,3.94,3.91,5.0,4.66,4.81,4.53,4.75,4.59,4.66,5.06,5.56,4.56,4.06,2.91,2.62,2.53,4.69,6.38,9.0,10.56,12.06,12.88,12.44,12.81,12.94,13.0,12.34,13.66,14.0,14.53,15.0,15.66,15.34,14.91,13.84,12.09,11.38,9.81,8.81,8.81,8.56,9.34,9.59,9.16,8.88,8.56,8.09,7.03,6.62,5.62,4.44,4.19,3.34,3.94,5.16,6.84,8.78,9.97,11.12,11.38,10.75,9.56,9.0,8.44,7.56,7.69,7.94,8.28,9.25,9.69,10.44,9.94,9.56,8.84,7.53,6.06,5.38,4.44,4.25,4.81,6.72,9.75,12.06,14.69,17.56,19.25,20.91,22.47,21.88,21.34,19.31,16.12,13.25,11.19,9.81,10.12,10.12,10.75,10.88,10.53,9.69,9.81,10.66,12.22,14.94,17.97,20.81,23.34,25.12,24.94,24.53,23.62,22.0,20.81,18.62,17.38,15.19,13.41,12.44,11.25,11.31,11.28,12.28,12.62,12.16,11.53,9.81,7.94,6.62,5.75,6.44,7.78,9.41,11.56,13.25,13.91,14.06,14.62,15.03,15.72,16.53,16.56,16.16,15.31,14.44,12.66,12.66,12.16,11.62,11.28,10.84,9.97,9.5,-25.03,-23.25,-22.28,-20.59,-20.47,-19.88,-19.25,-19.47,-18.75,-16.75,-15.66,-13.47:11.84,10.84,11.06,10.28,9.84,8.19,7.62,7.25,8.62,9.41,12.16,15.84,19.31,23.41,28.12,32.06,35.94,38.44,40.91,40.53,40.69,39.5,38.72,38.0,38.31,38.88,38.41,37.44,35.19,32.97,29.44,26.5,25.44,24.53,24.88,26.19,29.03,32.19,36.31,40.44,44.38,47.03,47.16,46.72,43.69,38.78,33.41,28.72,23.66,20.12,17.41,14.28,11.41,8.06,5.03,2.5,-0.53,-0.88,-0.84,0.72,3.44,7.34,11.41,15.06,18.28,21.31,23.41,23.47,23.62,22.25,21.38,20.31,20.31,21.22,23.22,26.0,28.81,31.47,33.41,34.47,33.22,29.69,25.34,20.81,17.16,14.66,13.72,14.84,15.78,17.09,18.91,20.0,20.91,21.94,22.06,22.19,21.69,21.56,21.19,21.16,21.72,21.47,22.78,22.0,20.5,18.91,16.34,13.5,11.41,10.16,9.88,10.62,11.66,14.16,15.53,17.81,19.75,21.28,22.19,23.03,23.81,23.66,24.53,25.19,24.47,24.38,24.53,22.59,20.72,18.62,16.78,15.25,14.22,14.53,14.81,15.03,16.44,17.16,18.19,19.28,20.78,22.44,23.72,25.31,27.12,28.25,30.0,31.06,32.62,34.16,34.25,34.34,33.41,30.28,28.28,24.0,20.5,17.56,14.38,12.16,11.09,10.72,12.03,14.81,17.31,20.53,22.84,24.38,24.91,25.28,24.25,23.31,22.19,21.28,18.62,17.06,16.06,15.62,15.78,15.62,16.84,16.62,16.44,16.34,16.12,16.44,15.78,16.81,18.06,19.34,20.78,23.16,24.94,27.0,28.94,30.91,32.12,32.91,33.91,33.03,31.72,29.97,28.31,26.72,25.34,24.47,23.25,22.38,21.94,20.91,20.19,19.84,18.78,18.38,17.09,15.91,14.25,13.41,12.97,13.31,14.47,16.56,19.38,22.31,25.5,28.5,30.78,31.94,32.28,31.62,30.38,28.0,25.0,23.56,21.81,20.5,21.0,20.44,20.38,19.53,17.75,15.62,13.41,11.81,11.19,11.12,10.81,11.75,11.81,12.81,13.41,14.34,15.38,15.84,16.0,15.62,14.69,14.69,15.31,16.81,18.28,20.12,21.91,23.28,23.25,23.41,23.03,22.03,20.75,20.56,18.91,19.28,18.78,18.06,17.12,16.44,15.12,14.06,13.25,12.66,13.31,13.81,14.94,16.28,17.81,19.44,19.47,20.78,21.16,22.03,22.91,22.28,22.12,20.91,19.81,19.31,18.56,18.12,18.62,16.91,18.09,17.94,18.38,18.97,19.0,19.56,18.19,17.81,16.91,15.81,14.81,14.0,12.78,12.5,11.41,10.66,11.62,12.56,13.44,15.19,17.25,18.12,18.09,18.41,18.09,17.91,18.75,19.16,19.53,20.06,20.53,19.88,19.09,19.53,21.03,22.06,24.12,25.94,27.28,26.34,25.28,23.62,21.44,19.25,17.41,16.81,17.47,18.62,20.31,21.91,23.62,25.59,27.34,29.53,31.31,32.69,32.81,31.84,30.53,30.25,28.56,29.59,29.78,29.31,28.59,26.38,24.91,23.56,21.28,20.81,20.84,20.03,19.78,19.59,19.03,18.62,19.0,20.44,21.66,24.0,25.81,27.25,28.12,28.69,28.34,27.31,26.62,26.5,25.47,25.47,25.44,24.81,24.5,22.44,21.78,20.94,20.0,20.66,21.31,21.0,21.91,22.0,22.16,21.94,22.06,21.47,21.62,22.84,23.59,24.5,24.91,24.84,23.81,22.91,20.81,20.06,19.12,18.34,18.0,18.19,18.06,18.78,19.25,19.31,18.69,17.91,16.81,15.78,16.19,17.22,19.19,21.31,24.5,27.91,29.88,32.5,33.88,33.75,33.06,30.53,27.94,24.41,21.41,19.78,18.72,18.5,19.06,19.0,18.59,18.5,17.25,17.06,17.41,17.75,19.06,21.0,21.72,22.0,22.16,22.06,20.41,19.56,20.19,21.38,22.81,24.88,26.44,26.41,25.66,23.59,20.19,17.16,15.56,12.5,11.91,11.44,10.94,10.5,10.94,12.06,13.0,14.59,16.59,18.5,20.41,21.66,22.94,24.81,25.5,25.91,26.06,24.94,24.28,22.53,22.81,23.5,23.62,23.88,24.16,23.94,23.09,22.44,21.81,20.84,21.06,19.84,19.91,19.34,19.78,19.5,18.56,18.31,18.06,16.31,15.44,15.31,13.94,13.31,12.62,12.28,11.91,11.81,12.06,11.66,10.5,9.38,6.88,4.25,2.94,1.03,1.66,2.69,4.84,8.91,12.53,17.19,21.28,23.09,23.38,22.56,19.06,15.81,12.09,8.69,5.88,3.56,2.31,1.12,0.69,0.19,0.22,1.19,1.19,2.19,3.44,5.75,8.06,11.03,13.56,15.91,17.06,17.56,16.78,16.31,14.91,14.09,13.34,12.84,12.84,13.06,13.5,14.12,14.28,13.66,12.19,10.62,8.38,6.06,4.88,3.19,2.28,1.38,1.16,1.94,3.41,5.88,7.88,11.56,14.06,16.06,17.84,19.25,19.69,19.06,17.91,15.53,13.34,11.03,8.25,6.78,5.53,4.44,4.22,4.41,5.16,6.31,6.47,7.31,7.28,6.47,5.69,3.31,1.62,-0.03,-1.38,-2.16,-1.94,0.62,3.16,5.09,7.38,8.25,9.25,8.16,6.62,6.44,4.91,4.72,6.44,8.06,10.62,13.28,16.25,18.44,19.19,19.78,18.94,17.44,16.09,14.56,13.69,13.72,13.81,14.84,14.78,14.78,14.16,12.31,9.84,7.0,4.69,2.47,1.56,1.72,1.94,2.22,2.84,3.19,4.03,4.94,5.34,6.44,5.78,4.03,2.47,0.09,-1.09,-1.75,-0.69,1.25,2.75,4.25,4.81,5.03,5.19,5.31,4.59,4.81,4.28,4.38,4.03,4.0,4.97,5.81,7.53,8.91,10.75,12.72,14.22,15.84,16.09,16.31,15.0,12.81,10.84,7.94,5.41,2.94,0.62,-1.09,-2.59,-3.34,-2.59,-1.38,0.12,2.84,5.97,8.0,9.88,11.66,12.56,12.25,11.44,10.56,8.62,7.0,5.25,2.97,0.75,0.28,-0.03,-0.59,0.75,1.75,2.59,3.94,3.91,5.0,4.66,4.81,4.53,4.75,4.59,4.66,5.06,5.56,4.56,4.06,2.91,2.62,2.53,4.69,6.38,9.0,10.56,12.06,12.88,12.44,12.81,12.94,13.0,12.34,13.66,14.0,14.53,15.0,15.66,15.34,14.91,13.84,12.09,11.38,9.81,8.81,8.81,8.56,9.34,9.59,9.16,8.88,8.56,8.09,7.03,6.62,5.62,4.44,4.19,3.34,3.94,5.16,6.84,8.78,9.97,11.12,11.38,10.75,9.56,9.0,8.44,7.56,7.69,7.94,8.28,9.25,9.69,10.44,9.94,9.56,8.84,7.53,6.06,5.38,4.44,4.25,4.81,6.72,9.75,12.06,14.69,17.56,19.25,20.91,22.47,21.88,21.34,19.31,16.12,13.25,11.19,9.81,10.12,10.12,10.75,10.88,10.53,9.69,9.81,10.66,12.22,14.94,17.97,20.81,23.34,25.12,24.94,24.53,23.62,22.0,20.81,18.62,17.38,15.19,13.41,12.44,11.25,11.31,11.28,12.28,12.62,12.16,11.53,9.81,7.94,6.62,5.75,6.44,7.78,9.41,11.56,13.25,13.91,14.06,14.62,15.03,15.72,16.53,16.56,16.16,15.31,14.44,12.66,12.66,12.16,11.62,11.28,10.84,9.97,9.5,-25.03,-23.25,-22.28,-20.59,-20.47,-19.88,-19.25,-19.47,-18.75,-16.75,-15.66,-13.47,-12.84,-14.03,-15.84,-18.28,-21.16,-23.16:7.62,7.25,8.62,9.41,12.16,15.84,19.31,23.41,28.12,32.06,35.94,38.44,40.91,40.53,40.69,39.5,38.72,38.0,38.31,38.88,38.41,37.44,35.19,32.97,29.44,26.5,25.44,24.53,24.88,26.19,29.03,32.19,36.31,40.44,44.38,47.03,47.16,46.72,43.69,38.78,33.41,28.72,23.66,20.12,17.41,14.28,11.41,8.06,5.03,2.5,-0.53,-0.88,-0.84,0.72,3.44,7.34,11.41,15.06,18.28,21.31,23.41,23.47,23.62,22.25,21.38,20.31,20.31,21.22,23.22,26.0,28.81,31.47,33.41,34.47,33.22,29.69,25.34,20.81,17.16,14.66,13.72,14.84,15.78,17.09,18.91,20.0,20.91,21.94,22.06,22.19,21.69,21.56,21.19,21.16,21.72,21.47,22.78,22.0,20.5,18.91,16.34,13.5,11.41,10.16,9.88,10.62,11.66,14.16,15.53,17.81,19.75,21.28,22.19,23.03,23.81,23.66,24.53,25.19,24.47,24.38,24.53,22.59,20.72,18.62,16.78,15.25,14.22,14.53,14.81,15.03,16.44,17.16,18.19,19.28,20.78,22.44,23.72,25.31,27.12,28.25,30.0,31.06,32.62,34.16,34.25,34.34,33.41,30.28,28.28,24.0,20.5,17.56,14.38,12.16,11.09,10.72,12.03,14.81,17.31,20.53,22.84,24.38,24.91,25.28,24.25,23.31,22.19,21.28,18.62,17.06,16.06,15.62,15.78,15.62,16.84,16.62,16.44,16.34,16.12,16.44,15.78,16.81,18.06,19.34,20.78,23.16,24.94,27.0,28.94,30.91,32.12,32.91,33.91,33.03,31.72,29.97,28.31,26.72,25.34,24.47,23.25,22.38,21.94,20.91,20.19,19.84,18.78,18.38,17.09,15.91,14.25,13.41,12.97,13.31,14.47,16.56,19.38,22.31,25.5,28.5,30.78,31.94,32.28,31.62,30.38,28.0,25.0,23.56,21.81,20.5,21.0,20.44,20.38,19.53,17.75,15.62,13.41,11.81,11.19,11.12,10.81,11.75,11.81,12.81,13.41,14.34,15.38,15.84,16.0,15.62,14.69,14.69,15.31,16.81,18.28,20.12,21.91,23.28,23.25,23.41,23.03,22.03,20.75,20.56,18.91,19.28,18.78,18.06,17.12,16.44,15.12,14.06,13.25,12.66,13.31,13.81,14.94,16.28,17.81,19.44,19.47,20.78,21.16,22.03,22.91,22.28,22.12,20.91,19.81,19.31,18.56,18.12,18.62,16.91,18.09,17.94,18.38,18.97,19.0,19.56,18.19,17.81,16.91,15.81,14.81,14.0,12.78,12.5,11.41,10.66,11.62,12.56,13.44,15.19,17.25,18.12,18.09,18.41,18.09,17.91,18.75,19.16,19.53,20.06,20.53,19.88,19.09,19.53,21.03,22.06,24.12,25.94,27.28,26.34,25.28,23.62,21.44,19.25,17.41,16.81,17.47,18.62,20.31,21.91,23.62,25.59,27.34,29.53,31.31,32.69,32.81,31.84,30.53,30.25,28.56,29.59,29.78,29.31,28.59,26.38,24.91,23.56,21.28,20.81,20.84,20.03,19.78,19.59,19.03,18.62,19.0,20.44,21.66,24.0,25.81,27.25,28.12,28.69,28.34,27.31,26.62,26.5,25.47,25.47,25.44,24.81,24.5,22.44,21.78,20.94,20.0,20.66,21.31,21.0,21.91,22.0,22.16,21.94,22.06,21.47,21.62,22.84,23.59,24.5,24.91,24.84,23.81,22.91,20.81,20.06,19.12,18.34,18.0,18.19,18.06,18.78,19.25,19.31,18.69,17.91,16.81,15.78,16.19,17.22,19.19,21.31,24.5,27.91,29.88,32.5,33.88,33.75,33.06,30.53,27.94,24.41,21.41,19.78,18.72,18.5,19.06,19.0,18.59,18.5,17.25,17.06,17.41,17.75,19.06,21.0,21.72,22.0,22.16,22.06,20.41,19.56,20.19,21.38,22.81,24.88,26.44,26.41,25.66,23.59,20.19,17.16,15.56,12.5,11.91,11.44,10.94,10.5,10.94,12.06,13.0,14.59,16.59,18.5,20.41,21.66,22.94,24.81,25.5,25.91,26.06,24.94,24.28,22.53,22.81,23.5,23.62,23.88,24.16,23.94,23.09,22.44,21.81,20.84,21.06,19.84,19.91,19.34,19.78,19.5,18.56,18.31,18.06,16.31,15.44,15.31,13.94,13.31,12.62,12.28,11.91,11.81,12.06,11.66,10.5,9.38,6.88,4.25,2.94,1.03,1.66,2.69,4.84,8.91,12.53,17.19,21.28,23.09,23.38,22.56,19.06,15.81,12.09,8.69,5.88,3.56,2.31,1.12,0.69,0.19,0.22,1.19,1.19,2.19,3.44,5.75,8.06,11.03,13.56,15.91,17.06,17.56,16.78,16.31,14.91,14.09,13.34,12.84,12.84,13.06,13.5,14.12,14.28,13.66,12.19,10.62,8.38,6.06,4.88,3.19,2.28,1.38,1.16,1.94,3.41,5.88,7.88,11.56,14.06,16.06,17.84,19.25,19.69,19.06,17.91,15.53,13.34,11.03,8.25,6.78,5.53,4.44,4.22,4.41,5.16,6.31,6.47,7.31,7.28,6.47,5.69,3.31,1.62,-0.03,-1.38,-2.16,-1.94,0.62,3.16,5.09,7.38,8.25,9.25,8.16,6.62,6.44,4.91,4.72,6.44,8.06,10.62,13.28,16.25,18.44,19.19,19.78,18.94,17.44,16.09,14.56,13.69,13.72,13.81,14.84,14.78,14.78,14.16,12.31,9.84,7.0,4.69,2.47,1.56,1.72,1.94,2.22,2.84,3.19,4.03,4.94,5.34,6.44,5.78,4.03,2.47,0.09,-1.09,-1.75,-0.69,1.25,2.75,4.25,4.81,5.03,5.19,5.31,4.59,4.81,4.28,4.38,4.03,4.0,4.97,5.81,7.53,8.91,10.75,12.72,14.22,15.84,16.09,16.31,15.0,12.81,10.84,7.94,5.41,2.94,0.62,-1.09,-2.59,-3.34,-2.59,-1.38,0.12,2.84,5.97,8.0,9.88,11.66,12.56,12.25,11.44,10.56,8.62,7.0,5.25,2.97,0.75,0.28,-0.03,-0.59,0.75,1.75,2.59,3.94,3.91,5.0,4.66,4.81,4.53,4.75,4.59,4.66,5.06,5.56,4.56,4.06,2.91,2.62,2.53,4.69,6.38,9.0,10.56,12.06,12.88,12.44,12.81,12.94,13.0,12.34,13.66,14.0,14.53,15.0,15.66,15.34,14.91,13.84,12.09,11.38,9.81,8.81,8.81,8.56,9.34,9.59,9.16,8.88,8.56,8.09,7.03,6.62,5.62,4.44,4.19,3.34,3.94,5.16,6.84,8.78,9.97,11.12,11.38,10.75,9.56,9.0,8.44,7.56,7.69,7.94,8.28,9.25,9.69,10.44,9.94,9.56,8.84,7.53,6.06,5.38,4.44,4.25,4.81,6.72,9.75,12.06,14.69,17.56,19.25,20.91,22.47,21.88,21.34,19.31,16.12,13.25,11.19,9.81,10.12,10.12,10.75,10.88,10.53,9.69,9.81,10.66,12.22,14.94,17.97,20.81,23.34,25.12,24.94,24.53,23.62,22.0,20.81,18.62,17.38,15.19,13.41,12.44,11.25,11.31,11.28,12.28,12.62,12.16,11.53,9.81,7.94,6.62,5.75,6.44,7.78,9.41,11.56,13.25,13.91,14.06,14.62,15.03,15.72,16.53,16.56,16.16,15.31,14.44,12.66,12.66,12.16,11.62,11.28,10.84,9.97,9.5,-25.03,-23.25,-22.28,-20.59,-20.47,-19.88,-19.25,-19.47,-18.75,-16.75,-15.66,-13.47,-12.84,-14.03,-15.84,-18.28,-21.16,-23.16,-24.31,-25.66,-26.22,-26.34,-27.62,-28.66:19.31,23.41,28.12,32.06,35.94,38.44,40.91,40.53,40.69,39.5,38.72,38.0,38.31,38.88,38.41,37.44,35.19,32.97,29.44,26.5,25.44,24.53,24.88,26.19,29.03,32.19,36.31,40.44,44.38,47.03,47.16,46.72,43.69,38.78,33.41,28.72,23.66,20.12,17.41,14.28,11.41,8.06,5.03,2.5,-0.53,-0.88,-0.84,0.72,3.44,7.34,11.41,15.06,18.28,21.31,23.41,23.47,23.62,22.25,21.38,20.31,20.31,21.22,23.22,26.0,28.81,31.47,33.41,34.47,33.22,29.69,25.34,20.81,17.16,14.66,13.72,14.84,15.78,17.09,18.91,20.0,20.91,21.94,22.06,22.19,21.69,21.56,21.19,21.16,21.72,21.47,22.78,22.0,20.5,18.91,16.34,13.5,11.41,10.16,9.88,10.62,11.66,14.16,15.53,17.81,19.75,21.28,22.19,23.03,23.81,23.66,24.53,25.19,24.47,24.38,24.53,22.59,20.72,18.62,16.78,15.25,14.22,14.53,14.81,15.03,16.44,17.16,18.19,19.28,20.78,22.44,23.72,25.31,27.12,28.25,30.0,31.06,32.62,34.16,34.25,34.34,33.41,30.28,28.28,24.0,20.5,17.56,14.38,12.16,11.09,10.72,12.03,14.81,17.31,20.53,22.84,24.38,24.91,25.28,24.25,23.31,22.19,21.28,18.62,17.06,16.06,15.62,15.78,15.62,16.84,16.62,16.44,16.34,16.12,16.44,15.78,16.81,18.06,19.34,20.78,23.16,24.94,27.0,28.94,30.91,32.12,32.91,33.91,33.03,31.72,29.97,28.31,26.72,25.34,24.47,23.25,22.38,21.94,20.91,20.19,19.84,18.78,18.38,17.09,15.91,14.25,13.41,12.97,13.31,14.47,16.56,19.38,22.31,25.5,28.5,30.78,31.94,32.28,31.62,30.38,28.0,25.0,23.56,21.81,20.5,21.0,20.44,20.38,19.53,17.75,15.62,13.41,11.81,11.19,11.12,10.81,11.75,11.81,12.81,13.41,14.34,15.38,15.84,16.0,15.62,14.69,14.69,15.31,16.81,18.28,20.12,21.91,23.28,23.25,23.41,23.03,22.03,20.75,20.56,18.91,19.28,18.78,18.06,17.12,16.44,15.12,14.06,13.25,12.66,13.31,13.81,14.94,16.28,17.81,19.44,19.47,20.78,21.16,22.03,22.91,22.28,22.12,20.91,19.81,19.31,18.56,18.12,18.62,16.91,18.09,17.94,18.38,18.97,19.0,19.56,18.19,17.81,16.91,15.81,14.81,14.0,12.78,12.5,11.41,10.66,11.62,12.56,13.44,15.19,17.25,18.12,18.09,18.41,18.09,17.91,18.75,19.16,19.53,20.06,20.53,19.88,19.09,19.53,21.03,22.06,24.12,25.94,27.28,26.34,25.28,23.62,21.44,19.25,17.41,16.81,17.47,18.62,20.31,21.91,23.62,25.59,27.34,29.53,31.31,32.69,32.81,31.84,30.53,30.25,28.56,29.59,29.78,29.31,28.59,26.38,24.91,23.56,21.28,20.81,20.84,20.03,19.78,19.59,19.03,18.62,19.0,20.44,21.66,24.0,25.81,27.25,28.12,28.69,28.34,27.31,26.62,26.5,25.47,25.47,25.44,24.81,24.5,22.44,21.78,20.94,20.0,20.66,21.31,21.0,21.91,22.0,22.16,21.94,22.06,21.47,21.62,22.84,23.59,24.5,24.91,24.84,23.81,22.91,20.81,20.06,19.12,18.34,18.0,18.19,18.06,18.78,19.25,19.31,18.69,17.91,16.81,15.78,16.19,17.22,19.19,21.31,24.5,27.91,29.88,32.5,33.88,33.75,33.06,30.53,27.94,24.41,21.41,19.78,18.72,18.5,19.06,19.0,18.59,18.5,17.25,17.06,17.41,17.75,19.06,21.0,21.72,22.0,22.16,22.06,20.41,19.56,20.19,21.38,22.81,24.88,26.44,26.41,25.66,23.59,20.19,17.16,15.56,12.5,11.91,11.44,10.94,10.5,10.94,12.06,13.0,14.59,16.59,18.5,20.41,21.66,22.94,24.81,25.5,25.91,26.06,24.94,24.28,22.53,22.81,23.5,23.62,23.88,24.16,23.94,23.09,22.44,21.81,20.84,21.06,19.84,19.91,19.34,19.78,19.5,18.56,18.31,18.06,16.31,15.44,15.31,13.94,13.31,12.62,12.28,11.91,11.81,12.06,11.66,10.5,9.38,6.88,4.25,2.94,1.03,1.66,2.69,4.84,8.91,12.53,17.19,21.28,23.09,23.38,22.56,19.06,15.81,12.09,8.69,5.88,3.56,2.31,1.12,0.69,0.19,0.22,1.19,1.19,2.19,3.44,5.75,8.06,11.03,13.56,15.91,17.06,17.56,16.78,16.31,14.91,14.09,13.34,12.84,12.84,13.06,13.5,14.12,14.28,13.66,12.19,10.62,8.38,6.06,4.88,3.19,2.28,1.38,1.16,1.94,3.41,5.88,7.88,11.56,14.06,16.06,17.84,19.25,19.69,19.06,17.91,15.53,13.34,11.03,8.25,6.78,5.53,4.44,4.22,4.41,5.16,6.31,6.47,7.31,7.28,6.47,5.69,3.31,1.62,-0.03,-1.38,-2.16,-1.94,0.62,3.16,5.09,7.38,8.25,9.25,8.16,6.62,6.44,4.91,4.72,6.44,8.06,10.62,13.28,16.25,18.44,19.19,19.78,18.94,17.44,16.09,14.56,13.69,13.72,13.81,14.84,14.78,14.78,14.16,12.31,9.84,7.0,4.69,2.47,1.56,1.72,1.94,2.22,2.84,3.19,4.03,4.94,5.34,6.44,5.78,4.03,2.47,0.09,-1.09,-1.75,-0.69,1.25,2.75,4.25,4.81,5.03,5.19,5.31,4.59,4.81,4.28,4.38,4.03,4.0,4.97,5.81,7.53,8.91,10.75,12.72,14.22,15.84,16.09,16.31,15.0,12.81,10.84,7.94,5.41,2.94,0.62,-1.09,-2.59,-3.34,-2.59,-1.38,0.12,2.84,5.97,8.0,9.88,11.66,12.56,12.25,11.44,10.56,8.62,7.0,5.25,2.97,0.75,0.28,-0.03,-0.59,0.75,1.75,2.59,3.94,3.91,5.0,4.66,4.81,4.53,4.75,4.59,4.66,5.06,5.56,4.56,4.06,2.91,2.62,2.53,4.69,6.38,9.0,10.56,12.06,12.88,12.44,12.81,12.94,13.0,12.34,13.66,14.0,14.53,15.0,15.66,15.34,14.91,13.84,12.09,11.38,9.81,8.81,8.81,8.56,9.34,9.59,9.16,8.88,8.56,8.09,7.03,6.62,5.62,4.44,4.19,3.34,3.94,5.16,6.84,8.78,9.97,11.12,11.38,10.75,9.56,9.0,8.44,7.56,7.69,7.94,8.28,9.25,9.69,10.44,9.94,9.56,8.84,7.53,6.06,5.38,4.44,4.25,4.81,6.72,9.75,12.06,14.69,17.56,19.25,20.91,22.47,21.88,21.34,19.31,16.12,13.25,11.19,9.81,10.12,10.12,10.75,10.88,10.53,9.69,9.81,10.66,12.22,14.94,17.97,20.81,23.34,25.12,24.94,24.53,23.62,22.0,20.81,18.62,17.38,15.19,13.41,12.44,11.25,11.31,11.28,12.28,12.62,12.16,11.53,9.81,7.94,6.62,5.75,6.44,7.78,9.41,11.56,13.25,13.91,14.06,14.62,15.03,15.72,16.53,16.56,16.16,15.31,14.44,12.66,12.66,12.16,11.62,11.28,10.84,9.97,9.5,-25.03,-23.25,-22.28,-20.59,-20.47,-19.88,-19.25,-19.47,-18.75,-16.75,-15.66,-13.47,-12.84,-14.03,-15.84,-18.28,-21.16,-23.16,-24.31,-25.66,-26.22,-26.34,-27.62,-28.66,-28.91,-29.12,-27.56,-26.16,-23.72,-20.09:negativity
120.53,118.31,116.31,115.28,115.75,113.59,114.69,112.41,112.06,112.16,111.62,112.69,112.62,113.19,111.75,112.91,111.72,112.81,112.12,111.94,112.78,111.66,111.03,113.28,114.41,115.72,117.91,119.53,119.94,118.28,117.5,114.81,114.25,111.56,112.12,112.06,111.09,112.94,114.09,115.62,119.06,121.03,123.53,125.78,125.84,125.25,124.19,121.03,118.62,115.56,114.94,113.81,114.38,116.34,118.91,120.78,123.75,124.66,125.59,123.59,120.53,117.88,114.91,113.56,114.47,117.25,120.19,122.53,122.25,121.34,117.5,114.34,109.78,106.12,103.5,100.75,98.59,98.16,97.94,97.97,100.16,101.88,104.38,106.62,107.22,110.09,112.0,111.81,113.88,113.44,112.94,113.66,113.03,114.12,114.16,114.84,115.44,115.25,114.78,114.66,113.88,113.38,112.53,110.94,110.62,109.41,109.16,108.22,107.62,106.5,106.03,104.5,103.5,103.84,104.31,105.66,107.47,110.81,112.94,114.56,116.25,116.12,116.0,114.5,113.06,111.34,108.88,107.78,106.56,104.75,104.41,105.16,105.69,106.66,108.31,108.78,109.75,111.75,112.22,114.0,115.94,116.53,116.34,117.03,115.72,116.38,115.31,115.5,115.19,115.03,115.19,115.0,115.0,116.06,117.84,118.66,121.22,123.06,122.62,121.69,118.25,115.06,110.81,107.19,104.12,103.38,103.19,104.0,105.94,107.31,109.53,108.59,107.94,106.88,105.41,104.56,105.19,106.94,108.03,108.88,108.56,108.56,108.22,106.91,106.34,106.0,107.06,107.25,108.03,109.66,110.56,111.88,112.19,111.44,112.84,111.81,110.56,111.94,111.75,112.62,112.62,113.62,112.97,110.44,110.66,110.28,110.19,111.5,111.94,114.38,114.84,116.91,118.03,119.94,122.22,122.62,122.59,121.84,119.56,115.81,111.81,108.94,107.19,104.94,107.12,110.0,111.06,114.38,116.81,118.09,117.44,119.53,119.47,120.91,122.19,122.31,122.5,122.81,120.31,120.38,119.34,119.41,119.19,118.69,118.56,118.56,117.34,116.81,117.12,116.25,114.88,113.56,112.81,111.06,112.0,112.88,114.94,119.44,122.19,124.16,124.56,122.53,118.25,113.0,109.31,105.81,105.19,105.41,106.06,108.0,109.59,110.75,112.59,115.66,116.88,118.22,118.41,116.72,117.19,114.06,114.12,115.19,113.12,114.12,114.84,113.72,114.75,115.0,112.44,114.31,115.34,113.81,115.91,115.94,114.16,111.81,107.97,103.94,100.62,98.06,97.28,96.62,97.31,98.31,99.44,98.0,100.09,102.41,103.03,105.81,108.16,107.69,108.94,108.38,107.28,109.56,109.88,111.78,112.69,113.62,115.44,115.78,115.56,116.38,115.56,115.53,116.56,116.88,118.19,119.5,120.19,121.78,122.28,123.19,124.19,124.12,123.84,123.25,123.66,123.62,123.62,125.16,124.62,124.88,123.94,122.22,121.06,118.69,117.12,115.81,113.41,112.78,111.88,111.12,110.25,108.81,107.25,105.91,104.03,103.06,101.91,99.91,97.91,95.94,94.41,94.16,94.47,95.75,97.47,97.97,97.16,97.5,95.47,95.0,95.0,96.78,97.81,99.41,100.66,100.56,101.94,101.69,102.5,104.0,103.12,103.12,103.62,103.59,102.69,104.41,103.09,102.75,102.47,101.56,100.94,99.56,98.91,98.03,97.19,97.56,97.94,96.97,96.75,95.56,95.62,93.88,95.69,95.28,95.22,95.25,95.12,94.97,95.84,96.56,98.0,98.44,99.22,100.25,100.25,100.88,102.56,101.75,101.69,100.59,99.25,98.06,95.59,94.62,95.31,95.94,97.41,99.66,102.0,101.81,104.75,107.28,107.41,109.03,110.06,109.38,109.06,106.44,105.81,104.19,101.88,102.03,103.81,105.69,109.34,111.66,114.53,114.09,114.41,114.69,114.25,114.56,113.66,114.44,112.62,111.59,111.62,110.19,110.59,111.09,110.44,110.69,109.31,107.72,106.94,106.72,105.44,107.03,107.84,109.06,109.72,110.03,112.06,110.66,111.84,112.81,115.06,117.09,119.03,121.16,121.03,122.19,121.12,120.81,119.81,116.69,116.97,115.69,114.72,112.81,112.5,109.53,107.66,105.25,105.06,104.72,105.41,106.91,107.69,107.84,111.59,112.75,115.62,116.78,118.44,118.31,117.69,117.5,115.62,115.88,113.31,111.94,110.81,109.09,109.06,108.91,109.97,110.81,111.38,111.5,114.28,115.16,116.91,117.59,117.09,114.22,111.41,107.19,105.94,105.34,106.91,108.97,112.34,114.62,115.06,114.88,114.34,112.84,112.06,109.91,108.38,106.06,104.31,102.34,101.38,100.41,98.44,99.19,97.47,97.69,98.34,100.31,101.38,104.97,104.53,108.03,109.91,111.28,114.69,114.28,114.09,112.03,109.56,107.91,106.75,106.34,105.06,103.66,103.41,102.69,102.28,104.03,105.0,105.81,106.34,105.53,103.56,103.5,101.22,101.5,101.41,101.47,101.44,102.5,103.12,103.19,104.53,103.66,103.72,103.84,104.28,104.94,106.22,107.5,107.75,108.31,109.41,108.66,107.56,107.22,106.12,105.56,104.5,103.41,102.75,102.5,102.12,102.66,104.94,105.31,106.59,105.44,105.06,105.62,104.56,104.88,105.62,106.28,105.91,106.22,106.59,106.16,106.84,107.38,106.66,106.28,109.19,107.38,109.81,110.94,109.41,110.0,110.31,108.91,107.78,107.91,107.28,105.19,105.97,105.53,107.38,108.16,108.94,109.41,111.25,111.31,111.88,112.09,113.0,113.75,113.28,112.5,113.44,114.0,115.34,116.97,119.06,121.31,122.16,121.62,119.44,118.56,114.59,112.0,110.84,108.44,106.12,103.25,101.72,98.56,96.94,97.81,97.38,97.53,98.69,98.84,100.06,102.06,102.25,102.81,102.88,103.28,103.84,105.38,105.56,105.81,104.5,103.41,103.28,101.16,101.56,102.28,102.78,103.88,106.59,108.25,110.25,111.0,112.12,111.5,111.44,111.91,112.69,113.78,114.75,116.38,117.25,118.06,117.66,117.16,116.69,115.12,113.91,113.12,111.34,108.56,109.12,107.16,107.38,108.56,111.56,111.94,115.41,116.41,117.41,117.22,116.41,115.97,114.0,114.38,113.66,112.56,112.19,110.88,109.16,106.03,104.19,102.78,101.03,99.41,98.94,98.31,98.16,98.03,96.56,98.06,97.56,98.91,100.19,102.06,102.69,100.94,101.88,100.62,100.06,99.75,100.28,99.88,97.72,97.94,97.88,97.69,97.94,99.41,99.97,99.94,102.19,101.88,103.38,102.59,103.06,102.81,102.31,102.16,101.97,101.59,101.53,101.34,100.66,101.53,101.78,101.97,101.97,102.69,102.34,101.97,102.25,102.16,101.66,102.25,102.62,102.22,102.56,101.69,102.78,103.16,103.94,105.56,105.84,107.31,108.28,110.41,111.62,110.91,112.84,111.16,108.34,105.34,104.0,102.0,103.12,104.88,107.75,110.28,113.0,113.44,113.53,114.41,113.03,113.59,113.81,113.78,113.25,112.25,111.88,110.19,111.81,111.12,113.75,115.09,117.0,118.12,117.81,118.75,118.84,117.81,117.44,115.62,112.41,108.34,107.19,104.94,102.72,103.84,104.19,104.31,104.66,106.94,107.44,107.69,109.97,110.56,111.56,112.62,111.94,110.28,108.44,104.53,101.56,100.31,97.06,96.5,95.56,93.62,91.31,89.41,87.62,85.09,83.28,81.84,80.25,76.69,74.44,72.53,70.31,68.69,68.28,68.47,68.69,69.56,70.56,72.5,73.72,74.5,73.62,72.75,71.56,68.91,67.88,66.91,66.53,66.38:114.69,112.41,112.06,112.16,111.62,112.69,112.62,113.19,111.75,112.91,111.72,112.81,112.12,111.94,112.78,111.66,111.03,113.28,114.41,115.72,117.91,119.53,119.94,118.28,117.5,114.81,114.25,111.56,112.12,112.06,111.09,112.94,114.09,115.62,119.06,121.03,123.53,125.78,125.84,125.25,124.19,121.03,118.62,115.56,114.94,113.81,114.38,116.34,118.91,120.78,123.75,124.66,125.59,123.59,120.53,117.88,114.91,113.56,114.47,117.25,120.19,122.53,122.25,121.34,117.5,114.34,109.78,106.12,103.5,100.75,98.59,98.16,97.94,97.97,100.16,101.88,104.38,106.62,107.22,110.09,112.0,111.81,113.88,113.44,112.94,113.66,113.03,114.12,114.16,114.84,115.44,115.25,114.78,114.66,113.88,113.38,112.53,110.94,110.62,109.41,109.16,108.22,107.62,106.5,106.03,104.5,103.5,103.84,104.31,105.66,107.47,110.81,112.94,114.56,116.25,116.12,116.0,114.5,113.06,111.34,108.88,107.78,106.56,104.75,104.41,105.16,105.69,106.66,108.31,108.78,109.75,111.75,112.22,114.0,115.94,116.53,116.34,117.03,115.72,116.38,115.31,115.5,115.19,115.03,115.19,115.0,115.0,116.06,117.84,118.66,121.22,123.06,122.62,121.69,118.25,115.06,110.81,107.19,104.12,103.38,103.19,104.0,105.94,107.31,109.53,108.59,107.94,106.88,105.41,104.56,105.19,106.94,108.03,108.88,108.56,108.56,108.22,106.91,106.34,106.0,107.06,107.25,108.03,109.66,110.56,111.88,112.19,111.44,112.84,111.81,110.56,111.94,111.75,112.62,112.62,113.62,112.97,110.44,110.66,110.28,110.19,111.5,111.94,114.38,114.84,116.91,118.03,119.94,122.22,122.62,122.59,121.84,119.56,115.81,111.81,108.94,107.19,104.94,107.12,110.0,111.06,114.38,116.81,118.09,117.44,119.53,119.47,120.91,122.19,122.31,122.5,122.81,120.31,120.38,119.34,119.41,119.19,118.69,118.56,118.56,117.34,116.81,117.12,116.25,114.88,113.56,112.81,111.06,112.0,112.88,114.94,119.44,122.19,124.16,124.56,122.53,118.25,113.0,109.31,105.81,105.19,105.41,106.06,108.0,109.59,110.75,112.59,115.66,116.88,118.22,118.41,116.72,117.19,114.06,114.12,115.19,113.12,114.12,114.84,113.72,114.75,115.0,112.44,114.31,115.34,113.81,115.91,115.94,114.16,111.81,107.97,103.94,100.62,98.06,97.28,96.62,97.31,98.31,99.44,98.0,100.09,102.41,103.03,105.81,108.16,107.69,108.94,108.38,107.28,109.56,109.88,111.78,112.69,113.62,115.44,115.78,115.56,116.38,115.56,115.53,116.56,116.88,118.19,119.5,120.19,121.78,122.28,123.19,124.19,124.12,123.84,123.25,123.66,123.62,123.62,125.16,124.62,124.88,123.94,122.22,121.06,118.69,117.12,115.81,113.41,112.78,111.88,111.12,110.25,108.81,107.25,105.91,104.03,103.06,101.91,99.91,97.91,95.94,94.41,94.16,94.47,95.75,97.47,97.97,97.16,97.5,95.47,95.0,95.0,96.78,97.81,99.41,100.66,100.56,101.94,101.69,102.5,104.0,103.12,103.12,103.62,103.59,102.69,104.41,103.09,102.75,102.47,101.56,100.94,99.56,98.91,98.03,97.19,97.56,97.94,96.97,96.75,95.56,95.62,93.88,95.69,95.28,95.22,95.25,95.12,94.97,95.84,96.56,98.0,98.44,99.22,100.25,100.25,100.88,102.56,101.75,101.69,100.59,99.25,98.06,95.59,94.62,95.31,95.94,97.41,99.66,102.0,101.81,104.75,107.28,107.41,109.03,110.06,109.38,109.06,106.44,105.81,104.19,101.88,102.03,103.81,105.69,109.34,111.66,114.53,114.09,114.41,114.69,114.25,114.56,113.66,114.44,112.62,111.59,111.62,110.19,110.59,111.09,110.44,110.69,109.31,107.72,106.94,106.72,105.44,107.03,107.84,109.06,109.72,110.03,112.06,110.66,111.84,112.81,115.06,117.09,119.03,121.16,121.03,122.19,121.12,120.81,119.81,116.69,116.97,115.69,114.72,112.81,112.5,109.53,107.66,105.25,105.06,104.72,105.41,106.91,107.69,107.84,111.59,112.75,115.62,116.78,118.44,118.31,117.69,117.5,115.62,115.88,113.31,111.94,110.81,109.09,109.06,108.91,109.97,110.81,111.38,111.5,114.28,115.16,116.91,117.59,117.09,114.22,111.41,107.19,105.94,105.34,106.91,108.97,112.34,114.62,115.06,114.88,114.34,112.84,112.06,109.91,108.38,106.06,104.31,102.34,101.38,100.41,98.44,99.19,97.47,97.69,98.34,100.31,101.38,104.97,104.53,108.03,109.91,111.28,114.69,114.28,114.09,112.03,109.56,107.91,106.75,106.34,105.06,103.66,103.41,102.69,102.28,104.03,105.0,105.81,106.34,105.53,103.56,103.5,101.22,101.5,101.41,101.47,101.44,102.5,103.12,103.19,104.53,103.66,103.72,103.84,104.28,104.94,106.22,107.5,107.75,108.31,109.41,108.66,107.56,107.22,106.12,105.56,104.5,103.41,102.75,102.5,102.12,102.66,104.94,105.31,106.59,105.44,105.06,105.62,104.56,104.88,105.62,106.28,105.91,106.22,106.59,106.16,106.84,107.38,106.66,106.28,109.19,107.38,109.81,110.94,109.41,110.0,110.31,108.91,107.78,107.91,107.28,105.19,105.97,105.53,107.38,108.16,108.94,109.41,111.25,111.31,111.88,112.09,113.0,113.75,113.28,112.5,113.44,114.0,115.34,116.97,119.06,121.31,122.16,121.62,119.44,118.56,114.59,112.0,110.84,108.44,106.12,103.25,101.72,98.56,96.94,97.81,97.38,97.53,98.69,98.84,100.06,102.06,102.25,102.81,102.88,103.28,103.84,105.38,105.56,105.81,104.5,103.41,103.28,101.16,101.56,102.28,102.78,103.88,106.59,108.25,110.25,111.0,112.12,111.5,111.44,111.91,112.69,113.78,114.75,116.38,117.25,118.06,117.66,117.16,116.69,115.12,113.91,113.12,111.34,108.56,109.12,107.16,107.38,108.56,111.56,111.94,115.41,116.41,117.41,117.22,116.41,115.97,114.0,114.38,113.66,112.56,112.19,110.88,109.16,106.03,104.19,102.78,101.03,99.41,98.94,98.31,98.16,98.03,96.56,98.06,97.56,98.91,100.19,102.06,102.69,100.94,101.88,100.62,100.06,99.75,100.28,99.88,97.72,97.94,97.88,97.69,97.94,99.41,99.97,99.94,102.19,101.88,103.38,102.59,103.06,102.81,102.31,102.16,101.97,101.59,101.53,101.34,100.66,101.53,101.78,101.97,101.97,102.69,102.34,101.97,102.25,102.16,101.66,102.25,102.62,102.22,102.56,101.69,102.78,103.16,103.94,105.56,105.84,107.31,108.28,110.41,111.62,110.91,112.84,111.16,108.34,105.34,104.0,102.0,103.12,104.88,107.75,110.28,113.0,113.44,113.53,114.41,113.03,113.59,113.81,113.78,113.25,112.25,111.88,110.19,111.81,111.12,113.75,115.09,117.0,118.12,117.81,118.75,118.84,117.81,117.44,115.62,112.41,108.34,107.19,104.94,102.72,103.84,104.19,104.31,104.66,106.94,107.44,107.69,109.97,110.56,111.56,112.62,111.94,110.28,108.44,104.53,101.56,100.31,97.06,96.5,95.56,93.62,91.31,89.41,87.62,85.09,83.28,81.84,80.25,76.69,74.44,72.53,70.31,68.69,68.28,68.47,68.69,69.56,70.56,72.5,73.72,74.5,73.62,72.75,71.56,68.91,67.88,66.91,66.53,66.38,64.72,62.66,60.25,59.25,57.47,55.84:112.62,113.19,111.75,112.91,111.72,112.81,112.12,111.94,112.78,111.66,111.03,113.28,114.41,115.72,117.91,119.53,119.94,118.28,117.5,114.81,114.25,111.56,112.12,112.06,111.09,112.94,114.09,115.62,119.06,121.03,123.53,125.78,125.84,125.25,124.19,121.03,118.62,115.56,114.94,113.81,114.38,116.34,118.91,120.78,123.75,124.66,125.59,123.59,120.53,117.88,114.91,113.56,114.47,117.25,120.19,122.53,122.25,121.34,117.5,114.34,109.78,106.12,103.5,100.75,98.59,98.16,97.94,97.97,100.16,101.88,104.38,106.62,107.22,110.09,112.0,111.81,113.88,113.44,112.94,113.66,113.03,114.12,114.16,114.84,115.44,115.25,114.78,114.66,113.88,113.38,112.53,110.94,110.62,109.41,109.16,108.22,107.62,106.5,106.03,104.5,103.5,103.84,104.31,105.66,107.47,110.81,112.94,114.56,116.25,116.12,116.0,114.5,113.06,111.34,108.88,107.78,106.56,104.75,104.41,105.16,105.69,106.66,108.31,108.78,109.75,111.75,112.22,114.0,115.94,116.53,116.34,117.03,115.72,116.38,115.31,115.5,115.19,115.03,115.19,115.0,115.0,116.06,117.84,118.66,121.22,123.06,122.62,121.69,118.25,115.06,110.81,107.19,104.12,103.38,103.19,104.0,105.94,107.31,109.53,108.59,107.94,106.88,105.41,104.56,105.19,106.94,108.03,108.88,108.56,108.56,108.22,106.91,106.34,106.0,107.06,107.25,108.03,109.66,110.56,111.88,112.19,111.44,112.84,111.81,110.56,111.94,111.75,112.62,112.62,113.62,112.97,110.44,110.66,110.28,110.19,111.5,111.94,114.38,114.84,116.91,118.03,119.94,122.22,122.62,122.59,121.84,119.56,115.81,111.81,108.94,107.19,104.94,107.12,110.0,111.06,114.38,116.81,118.09,117.44,119.53,119.47,120.91,122.19,122.31,122.5,122.81,120.31,120.38,119.34,119.41,119.19,118.69,118.56,118.56,117.34,116.81,117.12,116.25,114.88,113.56,112.81,111.06,112.0,112.88,114.94,119.44,122.19,124.16,124.56,122.53,118.25,113.0,109.31,105.81,105.19,105.41,106.06,108.0,109.59,110.75,112.59,115.66,116.88,118.22,118.41,116.72,117.19,114.06,114.12,115.19,113.12,114.12,114.84,113.72,114.75,115.0,112.44,114.31,115.34,113.81,115.91,115.94,114.16,111.81,107.97,103.94,100.62,98.06,97.28,96.62,97.31,98.31,99.44,98.0,100.09,102.41,103.03,105.81,108.16,107.69,108.94,108.38,107.28,109.56,109.88,111.78,112.69,113.62,115.44,115.78,115.56,116.38,115.56,115.53,116.56,116.88,118.19,119.5,120.19,121.78,122.28,123.19,124.19,124.12,123.84,123.25,123.66,123.62,123.62,125.16,124.62,124.88,123.94,122.22,121.06,118.69,117.12,115.81,113.41,112.78,111.88,111.12,110.25,108.81,107.25,105.91,104.03,103.06,101.91,99.91,97.91,95.94,94.41,94.16,94.47,95.75,97.47,97.97,97.16,97.5,95.47,95.0,95.0,96.78,97.81,99.41,100.66,100.56,101.94,101.69,102.5,104.0,103.12,103.12,103.62,103.59,102.69,104.41,103.09,102.75,102.47,101.56,100.94,99.56,98.91,98.03,97.19,97.56,97.94,96.97,96.75,95.56,95.62,93.88,95.69,95.28,95.22,95.25,95.12,94.97,95.84,96.56,98.0,98.44,99.22,100.25,100.25,100.88,102.56,101.75,101.69,100.59,99.25,98.06,95.59,94.62,95.31,95.94,97.41,99.66,102.0,101.81,104.75,107.28,107.41,109.03,110.06,109.38,109.06,106.44,105.81,104.19,101.88,102.03,103.81,105.69,109.34,111.66,114.53,114.09,114.41,114.69,114.25,114.56,113.66,114.44,112.62,111.59,111.62,110.19,110.59,111.09,110.44,110.69,109.31,107.72,106.94,106.72,105.44,107.03,107.84,109.06,109.72,110.03,112.06,110.66,111.84,112.81,115.06,117.09,119.03,121.16,121.03,122.19,121.12,120.81,119.81,116.69,116.97,115.69,114.72,112.81,112.5,109.53,107.66,105.25,105.06,104.72,105.41,106.91,107.69,107.84,111.59,112.75,115.62,116.78,118.44,118.31,117.69,117.5,115.62,115.88,113.31,111.94,110.81,109.09,109.06,108.91,109.97,110.81,111.38,111.5,114.28,115.16,116.91,117.59,117.09,114.22,111.41,107.19,105.94,105.34,106.91,108.97,112.34,114.62,115.06,114.88,114.34,112.84,112.06,109.91,108.38,106.06,104.31,102.34,101.38,100.41,98.44,99.19,97.47,97.69,98.34,100.31,101.38,104.97,104.53,108.03,109.91,111.28,114.69,114.28,114.09,112.03,109.56,107.91,106.75,106.34,105.06,103.66,103.41,102.69,102.28,104.03,105.0,105.81,106.34,105.53,103.56,103.5,101.22,101.5,101.41,101.47,101.44,102.5,103.12,103.19,104.53,103.66,103.72,103.84,104.28,104.94,106.22,107.5,107.75,108.31,109.41,108.66,107.56,107.22,106.12,105.56,104.5,103.41,102.75,102.5,102.12,102.66,104.94,105.31,106.59,105.44,105.06,105.62,104.56,104.88,105.62,106.28,105.91,106.22,106.59,106.16,106.84,107.38,106.66,106.28,109.19,107.38,109.81,110.94,109.41,110.0,110.31,108.91,107.78,107.91,107.28,105.19,105.97,105.53,107.38,108.16,108.94,109.41,111.25,111.31,111.88,112.09,113.0,113.75,113.28,112.5,113.44,114.0,115.34,116.97,119.06,121.31,122.16,121.62,119.44,118.56,114.59,112.0,110.84,108.44,106.12,103.25,101.72,98.56,96.94,97.81,97.38,97.53,98.69,98.84,100.06,102.06,102.25,102.81,102.88,103.28,103.84,105.38,105.56,105.81,104.5,103.41,103.28,101.16,101.56,102.28,102.78,103.88,106.59,108.25,110.25,111.0,112.12,111.5,111.44,111.91,112.69,113.78,114.75,116.38,117.25,118.06,117.66,117.16,116.69,115.12,113.91,113.12,111.34,108.56,109.12,107.16,107.38,108.56,111.56,111.94,115.41,116.41,117.41,117.22,116.41,115.97,114.0,114.38,113.66,112.56,112.19,110.88,109.16,106.03,104.19,102.78,101.03,99.41,98.94,98.31,98.16,98.03,96.56,98.06,97.56,98.91,100.19,102.06,102.69,100.94,101.88,100.62,100.06,99.75,100.28,99.88,97.72,97.94,97.88,97.69,97.94,99.41,99.97,99.94,102.19,101.88,103.38,102.59,103.06,102.81,102.31,102.16,101.97,101.59,101.53,101.34,100.66,101.53,101.78,101.97,101.97,102.69,102.34,101.97,102.25,102.16,101.66,102.25,102.62,102.22,102.56,101.69,102.78,103.16,103.94,105.56,105.84,107.31,108.28,110.41,111.62,110.91,112.84,111.16,108.34,105.34,104.0,102.0,103.12,104.88,107.75,110.28,113.0,113.44,113.53,114.41,113.03,113.59,113.81,113.78,113.25,112.25,111.88,110.19,111.81,111.12,113.75,115.09,117.0,118.12,117.81,118.75,118.84,117.81,117.44,115.62,112.41,108.34,107.19,104.94,102.72,103.84,104.19,104.31,104.66,106.94,107.44,107.69,109.97,110.56,111.56,112.62,111.94,110.28,108.44,104.53,101.56,100.31,97.06,96.5,95.56,93.62,91.31,89.41,87.62,85.09,83.28,81.84,80.25,76.69,74.44,72.53,70.31,68.69,68.28,68.47,68.69,69.56,70.56,72.5,73.72,74.5,73.62,72.75,71.56,68.91,67.88,66.91,66.53,66.38,64.72,62.66,60.25,59.25,57.47,55.84,55.81,54.91,54.06,53.06,53.03,52.5:112.12,111.94,112.78,111.66,111.03,113.28,114.41,115.72,117.91,119.53,119.94,118.28,117.5,114.81,114.25,111.56,112.12,112.06,111.09,112.94,114.09,115.62,119.06,121.03,123.53,125.78,125.84,125.25,124.19,121.03,118.62,115.56,114.94,113.81,114.38,116.34,118.91,120.78,123.75,124.66,125.59,123.59,120.53,117.88,114.91,113.56,114.47,117.25,120.19,122.53,122.25,121.34,117.5,114.34,109.78,106.12,103.5,100.75,98.59,98.16,97.94,97.97,100.16,101.88,104.38,106.62,107.22,110.09,112.0,111.81,113.88,113.44,112.94,113.66,113.03,114.12,114.16,114.84,115.44,115.25,114.78,114.66,113.88,113.38,112.53,110.94,110.62,109.41,109.16,108.22,107.62,106.5,106.03,104.5,103.5,103.84,104.31,105.66,107.47,110.81,112.94,114.56,116.25,116.12,116.0,114.5,113.06,111.34,108.88,107.78,106.56,104.75,104.41,105.16,105.69,106.66,108.31,108.78,109.75,111.75,112.22,114.0,115.94,116.53,116.34,117.03,115.72,116.38,115.31,115.5,115.19,115.03,115.19,115.0,115.0,116.06,117.84,118.66,121.22,123.06,122.62,121.69,118.25,115.06,110.81,107.19,104.12,103.38,103.19,104.0,105.94,107.31,109.53,108.59,107.94,106.88,105.41,104.56,105.19,106.94,108.03,108.88,108.56,108.56,108.22,106.91,106.34,106.0,107.06,107.25,108.03,109.66,110.56,111.88,112.19,111.44,112.84,111.81,110.56,111.94,111.75,112.62,112.62,113.62,112.97,110.44,110.66,110.28,110.19,111.5,111.94,114.38,114.84,116.91,118.03,119.94,122.22,122.62,122.59,121.84,119.56,115.81,111.81,108.94,107.19,104.94,107.12,110.0,111.06,114.38,116.81,118.09,117.44,119.53,119.47,120.91,122.19,122.31,122.5,122.81,120.31,120.38,119.34,119.41,119.19,118.69,118.56,118.56,117.34,116.81,117.12,116.25,114.88,113.56,112.81,111.06,112.0,112.88,114.94,119.44,122.19,124.16,124.56,122.53,118.25,113.0,109.31,105.81,105.19,105.41,106.06,108.0,109.59,110.75,112.59,115.66,116.88,118.22,118.41,116.72,117.19,114.06,114.12,115.19,113.12,114.12,114.84,113.72,114.75,115.0,112.44,114.31,115.34,113.81,115.91,115.94,114.16,111.81,107.97,103.94,100.62,98.06,97.28,96.62,97.31,98.31,99.44,98.0,100.09,102.41,103.03,105.81,108.16,107.69,108.94,108.38,107.28,109.56,109.88,111.78,112.69,113.62,115.44,115.78,115.56,116.38,115.56,115.53,116.56,116.88,118.19,119.5,120.19,121.78,122.28,123.19,124.19,124.12,123.84,123.25,123.66,123.62,123.62,125.16,124.62,124.88,123.94,122.22,121.06,118.69,117.12,115.81,113.41,112.78,111.88,111.12,110.25,108.81,107.25,105.91,104.03,103.06,101.91,99.91,97.91,95.94,94.41,94.16,94.47,95.75,97.47,97.97,97.16,97.5,95.47,95.0,95.0,96.78,97.81,99.41,100.66,100.56,101.94,101.69,102.5,104.0,103.12,103.12,103.62,103.59,102.69,104.41,103.09,102.75,102.47,101.56,100.94,99.56,98.91,98.03,97.19,97.56,97.94,96.97,96.75,95.56,95.62,93.88,95.69,95.28,95.22,95.25,95.12,94.97,95.84,96.56,98.0,98.44,99.22,100.25,100.25,100.88,102.56,101.75,101.69,100.59,99.25,98.06,95.59,94.62,95.31,95.94,97.41,99.66,102.0,101.81,104.75,107.28,107.41,109.03,110.06,109.38,109.06,106.44,105.81,104.19,101.88,102.03,103.81,105.69,109.34,111.66,114.53,114.09,114.41,114.69,114.25,114.56,113.66,114.44,112.62,111.59,111.62,110.19,110.59,111.09,110.44,110.69,109.31,107.72,106.94,106.72,105.44,107.03,107.84,109.06,109.72,110.03,112.06,110.66,111.84,112.81,115.06,117.09,119.03,121.16,121.03,122.19,121.12,120.81,119.81,116.69,116.97,115.69,114.72,112.81,112.5,109.53,107.66,105.25,105.06,104.72,105.41,106.91,107.69,107.84,111.59,112.75,115.62,116.78,118.44,118.31,117.69,117.5,115.62,115.88,113.31,111.94,110.81,109.09,109.06,108.91,109.97,110.81,111.38,111.5,114.28,115.16,116.91,117.59,117.09,114.22,111.41,107.19,105.94,105.34,106.91,108.97,112.34,114.62,115.06,114.88,114.34,112.84,112.06,109.91,108.38,106.06,104.31,102.34,101.38,100.41,98.44,99.19,97.47,97.69,98.34,100.31,101.38,104.97,104.53,108.03,109.91,111.28,114.69,114.28,114.09,112.03,109.56,107.91,106.75,106.34,105.06,103.66,103.41,102.69,102.28,104.03,105.0,105.81,106.34,105.53,103.56,103.5,101.22,101.5,101.41,101.47,101.44,102.5,103.12,103.19,104.53,103.66,103.72,103.84,104.28,104.94,106.22,107.5,107.75,108.31,109.41,108.66,107.56,107.22,106.12,105.56,104.5,103.41,102.75,102.5,102.12,102.66,104.94,105.31,106.59,105.44,105.06,105.62,104.56,104.88,105.62,106.28,105.91,106.22,106.59,106.16,106.84,107.38,106.66,106.28,109.19,107.38,109.81,110.94,109.41,110.0,110.31,108.91,107.78,107.91,107.28,105.19,105.97,105.53,107.38,108.16,108.94,109.41,111.25,111.31,111.88,112.09,113.0,113.75,113.28,112.5,113.44,114.0,115.34,116.97,119.06,121.31,122.16,121.62,119.44,118.56,114.59,112.0,110.84,108.44,106.12,103.25,101.72,98.56,96.94,97.81,97.38,97.53,98.69,98.84,100.06,102.06,102.25,102.81,102.88,103.28,103.84,105.38,105.56,105.81,104.5,103.41,103.28,101.16,101.56,102.28,102.78,103.88,106.59,108.25,110.25,111.0,112.12,111.5,111.44,111.91,112.69,113.78,114.75,116.38,117.25,118.06,117.66,117.16,116.69,115.12,113.91,113.12,111.34,108.56,109.12,107.16,107.38,108.56,111.56,111.94,115.41,116.41,117.41,117.22,116.41,115.97,114.0,114.38,113.66,112.56,112.19,110.88,109.16,106.03,104.19,102.78,101.03,99.41,98.94,98.31,98.16,98.03,96.56,98.06,97.56,98.91,100.19,102.06,102.69,100.94,101.88,100.62,100.06,99.75,100.28,99.88,97.72,97.94,97.88,97.69,97.94,99.41,99.97,99.94,102.19,101.88,103.38,102.59,103.06,102.81,102.31,102.16,101.97,101.59,101.53,101.34,100.66,101.53,101.78,101.97,101.97,102.69,102.34,101.97,102.25,102.16,101.66,102.25,102.62,102.22,102.56,101.69,102.78,103.16,103.94,105.56,105.84,107.31,108.28,110.41,111.62,110.91,112.84,111.16,108.34,105.34,104.0,102.0,103.12,104.88,107.75,110.28,113.0,113.44,113.53,114.41,113.03,113.59,113.81,113.78,113.25,112.25,111.88,110.19,111.81,111.12,113.75,115.09,117.0,118.12,117.81,118.75,118.84,117.81,117.44,115.62,112.41,108.34,107.19,104.94,102.72,103.84,104.19,104.31,104.66,106.94,107.44,107.69,109.97,110.56,111.56,112.62,111.94,110.28,108.44,104.53,101.56,100.31,97.06,96.5,95.56,93.62,91.31,89.41,87.62,85.09,83.28,81.84,80.25,76.69,74.44,72.53,70.31,68.69,68.28,68.47,68.69,69.56,70.56,72.5,73.72,74.5,73.62,72.75,71.56,68.91,67.88,66.91,66.53,66.38,64.72,62.66,60.25,59.25,57.47,55.84,55.81,54.91,54.06,53.06,53.03,52.5,51.81,51.88,51.53,52.34,53.03,53.66:114.41,115.72,117.91,119.53,119.94,118.28,117.5,114.81,114.25,111.56,112.12,112.06,111.09,112.94,114.09,115.62,119.06,121.03,123.53,125.78,125.84,125.25,124.19,121.03,118.62,115.56,114.94,113.81,114.38,116.34,118.91,120.78,123.75,124.66,125.59,123.59,120.53,117.88,114.91,113.56,114.47,117.25,120.19,122.53,122.25,121.34,117.5,114.34,109.78,106.12,103.5,100.75,98.59,98.16,97.94,97.97,100.16,101.88,104.38,106.62,107.22,110.09,112.0,111.81,113.88,113.44,112.94,113.66,113.03,114.12,114.16,114.84,115.44,115.25,114.78,114.66,113.88,113.38,112.53,110.94,110.62,109.41,109.16,108.22,107.62,106.5,106.03,104.5,103.5,103.84,104.31,105.66,107.47,110.81,112.94,114.56,116.25,116.12,116.0,114.5,113.06,111.34,108.88,107.78,106.56,104.75,104.41,105.16,105.69,106.66,108.31,108.78,109.75,111.75,112.22,114.0,115.94,116.53,116.34,117.03,115.72,116.38,115.31,115.5,115.19,115.03,115.19,115.0,115.0,116.06,117.84,118.66,121.22,123.06,122.62,121.69,118.25,115.06,110.81,107.19,104.12,103.38,103.19,104.0,105.94,107.31,109.53,108.59,107.94,106.88,105.41,104.56,105.19,106.94,108.03,108.88,108.56,108.56,108.22,106.91,106.34,106.0,107.06,107.25,108.03,109.66,110.56,111.88,112.19,111.44,112.84,111.81,110.56,111.94,111.75,112.62,112.62,113.62,112.97,110.44,110.66,110.28,110.19,111.5,111.94,114.38,114.84,116.91,118.03,119.94,122.22,122.62,122.59,121.84,119.56,115.81,111.81,108.94,107.19,104.94,107.12,110.0,111.06,114.38,116.81,118.09,117.44,119.53,119.47,120.91,122.19,122.31,122.5,122.81,120.31,120.38,119.34,119.41,119.19,118.69,118.56,118.56,117.34,116.81,117.12,116.25,114.88,113.56,112.81,111.06,112.0,112.88,114.94,119.44,122.19,124.16,124.56,122.53,118.25,113.0,109.31,105.81,105.19,105.41,106.06,108.0,109.59,110.75,112.59,115.66,116.88,118.22,118.41,116.72,117.19,114.06,114.12,115.19,113.12,114.12,114.84,113.72,114.75,115.0,112.44,114.31,115.34,113.81,115.91,115.94,114.16,111.81,107.97,103.94,100.62,98.06,97.28,96.62,97.31,98.31,99.44,98.0,100.09,102.41,103.03,105.81,108.16,107.69,108.94,108.38,107.28,109.56,109.88,111.78,112.69,113.62,115.44,115.78,115.56,116.38,115.56,115.53,116.56,116.88,118.19,119.5,120.19,121.78,122.28,123.19,124.19,124.12,123.84,123.25,123.66,123.62,123.62,125.16,124.62,124.88,123.94,122.22,121.06,118.69,117.12,115.81,113.41,112.78,111.88,111.12,110.25,108.81,107.25,105.91,104.03,103.06,101.91,99.91,97.91,95.94,94.41,94.16,94.47,95.75,97.47,97.97,97.16,97.5,95.47,95.0,95.0,96.78,97.81,99.41,100.66,100.56,101.94,101.69,102.5,104.0,103.12,103.12,103.62,103.59,102.69,104.41,103.09,102.75,102.47,101.56,100.94,99.56,98.91,98.03,97.19,97.56,97.94,96.97,96.75,95.56,95.62,93.88,95.69,95.28,95.22,95.25,95.12,94.97,95.84,96.56,98.0,98.44,99.22,100.25,100.25,100.88,102.56,101.75,101.69,100.59,99.25,98.06,95.59,94.62,95.31,95.94,97.41,99.66,102.0,101.81,104.75,107.28,107.41,109.03,110.06,109.38,109.06,106.44,105.81,104.19,101.88,102.03,103.81,105.69,109.34,111.66,114.53,114.09,114.41,114.69,114.25,114.56,113.66,114.44,112.62,111.59,111.62,110.19,110.59,111.09,110.44,110.69,109.31,107.72,106.94,106.72,105.44,107.03,107.84,109.06,109.72,110.03,112.06,110.66,111.84,112.81,115.06,117.09,119.03,121.16,121.03,122.19,121.12,120.81,119.81,116.69,116.97,115.69,114.72,112.81,112.5,109.53,107.66,105.25,105.06,104.72,105.41,106.91,107.69,107.84,111.59,112.75,115.62,116.78,118.44,118.31,117.69,117.5,115.62,115.88,113.31,111.94,110.81,109.09,109.06,108.91,109.97,110.81,111.38,111.5,114.28,115.16,116.91,117.59,117.09,114.22,111.41,107.19,105.94,105.34,106.91,108.97,112.34,114.62,115.06,114.88,114.34,112.84,112.06,109.91,108.38,106.06,104.31,102.34,101.38,100.41,98.44,99.19,97.47,97.69,98.34,100.31,101.38,104.97,104.53,108.03,109.91,111.28,114.69,114.28,114.09,112.03,109.56,107.91,106.75,106.34,105.06,103.66,103.41,102.69,102.28,104.03,105.0,105.81,106.34,105.53,103.56,103.5,101.22,101.5,101.41,101.47,101.44,102.5,103.12,103.19,104.53,103.66,103.72,103.84,104.28,104.94,106.22,107.5,107.75,108.31,109.41,108.66,107.56,107.22,106.12,105.56,104.5,103.41,102.75,102.5,102.12,102.66,104.94,105.31,106.59,105.44,105.06,105.62,104.56,104.88,105.62,106.28,105.91,106.22,106.59,106.16,106.84,107.38,106.66,106.28,109.19,107.38,109.81,110.94,109.41,110.0,110.31,108.91,107.78,107.91,107.28,105.19,105.97,105.53,107.38,108.16,108.94,109.41,111.25,111.31,111.88,112.09,113.0,113.75,113.28,112.5,113.44,114.0,115.34,116.97,119.06,121.31,122.16,121.62,119.44,118.56,114.59,112.0,110.84,108.44,106.12,103.25,101.72,98.56,96.94,97.81,97.38,97.53,98.69,98.84,100.06,102.06,102.25,102.81,102.88,103.28,103.84,105.38,105.56,105.81,104.5,103.41,103.28,101.16,101.56,102.28,102.78,103.88,106.59,108.25,110.25,111.0,112.12,111.5,111.44,111.91,112.69,113.78,114.75,116.38,117.25,118.06,117.66,117.16,116.69,115.12,113.91,113.12,111.34,108.56,109.12,107.16,107.38,108.56,111.56,111.94,115.41,116.41,117.41,117.22,116.41,115.97,114.0,114.38,113.66,112.56,112.19,110.88,109.16,106.03,104.19,102.78,101.03,99.41,98.94,98.31,98.16,98.03,96.56,98.06,97.56,98.91,100.19,102.06,102.69,100.94,101.88,100.62,100.06,99.75,100.28,99.88,97.72,97.94,97.88,97.69,97.94,99.41,99.97,99.94,102.19,101.88,103.38,102.59,103.06,102.81,102.31,102.16,101.97,101.59,101.53,101.34,100.66,101.53,101.78,101.97,101.97,102.69,102.34,101.97,102.25,102.16,101.66,102.25,102.62,102.22,102.56,101.69,102.78,103.16,103.94,105.56,105.84,107.31,108.28,110.41,111.62,110.91,112.84,111.16,108.34,105.34,104.0,102.0,103.12,104.88,107.75,110.28,113.0,113.44,113.53,114.41,113.03,113.59,113.81,113.78,113.25,112.25,111.88,110.19,111.81,111.12,113.75,115.09,117.0,118.12,117.81,118.75,118.84,117.81,117.44,115.62,112.41,108.34,107.19,104.94,102.72,103.84,104.19,104.31,104.66,106.94,107.44,107.69,109.97,110.56,111.56,112.62,111.94,110.28,108.44,104.53,101.56,100.31,97.06,96.5,95.56,93.62,91.31,89.41,87.62,85.09,83.28,81.84,80.25,76.69,74.44,72.53,70.31,68.69,68.28,68.47,68.69,69.56,70.56,72.5,73.72,74.5,73.62,72.75,71.56,68.91,67.88,66.91,66.53,66.38,64.72,62.66,60.25,59.25,57.47,55.84,55.81,54.91,54.06,53.06,53.03,52.5,51.81,51.88,51.53,52.34,53.03,53.66,54.44,54.66,55.12,55.31,55.25,56.25:117.5,114.81,114.25,111.56,112.12,112.06,111.09,112.94,114.09,115.62,119.06,121.03,123.53,125.78,125.84,125.25,124.19,121.03,118.62,115.56,114.94,113.81,114.38,116.34,118.91,120.78,123.75,124.66,125.59,123.59,120.53,117.88,114.91,113.56,114.47,117.25,120.19,122.53,122.25,121.34,117.5,114.34,109.78,106.12,103.5,100.75,98.59,98.16,97.94,97.97,100.16,101.88,104.38,106.62,107.22,110.09,112.0,111.81,113.88,113.44,112.94,113.66,113.03,114.12,114.16,114.84,115.44,115.25,114.78,114.66,113.88,113.38,112.53,110.94,110.62,109.41,109.16,108.22,107.62,106.5,106.03,104.5,103.5,103.84,104.31,105.66,107.47,110.81,112.94,114.56,116.25,116.12,116.0,114.5,113.06,111.34,108.88,107.78,106.56,104.75,104.41,105.16,105.69,106.66,108.31,108.78,109.75,111.75,112.22,114.0,115.94,116.53,116.34,117.03,115.72,116.38,115.31,115.5,115.19,115.03,115.19,115.0,115.0,116.06,117.84,118.66,121.22,123.06,122.62,121.69,118.25,115.06,110.81,107.19,104.12,103.38,103.19,104.0,105.94,107.31,109.53,108.59,107.94,106.88,105.41,104.56,105.19,106.94,108.03,108.88,108.56,108.56,108.22,106.91,106.34,106.0,107.06,107.25,108.03,109.66,110.56,111.88,112.19,111.44,112.84,111.81,110.56,111.94,111.75,112.62,112.62,113.62,112.97,110.44,110.66,110.28,110.19,111.5,111.94,114.38,114.84,116.91,118.03,119.94,122.22,122.62,122.59,121.84,119.56,115.81,111.81,108.94,107.19,104.94,107.12,110.0,111.06,114.38,116.81,118.09,117.44,119.53,119.47,120.91,122.19,122.31,122.5,122.81,120.31,120.38,119.34,119.41,119.19,118.69,118.56,118.56,117.34,116.81,117.12,116.25,114.88,113.56,112.81,111.06,112.0,112.88,114.94,119.44,122.19,124.16,124.56,122.53,118.25,113.0,109.31,105.81,105.19,105.41,106.06,108.0,109.59,110.75,112.59,115.66,116.88,118.22,118.41,116.72,117.19,114.06,114.12,115.19,113.12,114.12,114.84,113.72,114.75,115.0,112.44,114.31,115.34,113.81,115.91,115.94,114.16,111.81,107.97,103.94,100.62,98.06,97.28,96.62,97.31,98.31,99.44,98.0,100.09,102.41,103.03,105.81,108.16,107.69,108.94,108.38,107.28,109.56,109.88,111.78,112.69,113.62,115.44,115.78,115.56,116.38,115.56,115.53,116.56,116.88,118.19,119.5,120.19,121.78,122.28,123.19,124.19,124.12,123.84,123.25,123.66,123.62,123.62,125.16,124.62,124.88,123.94,122.22,121.06,118.69,117.12,115.81,113.41,112.78,111.88,111.12,110.25,108.81,107.25,105.91,104.03,103.06,101.91,99.91,97.91,95.94,94.41,94.16,94.47,95.75,97.47,97.97,97.16,97.5,95.47,95.0,95.0,96.78,97.81,99.41,100.66,100.56,101.94,101.69,102.5,104.0,103.12,103.12,103.62,103.59,102.69,104.41,103.09,102.75,102.47,101.56,100.94,99.56,98.91,98.03,97.19,97.56,97.94,96.97,96.75,95.56,95.62,93.88,95.69,95.28,95.22,95.25,95.12,94.97,95.84,96.56,98.0,98.44,99.22,100.25,100.25,100.88,102.56,101.75,101.69,100.59,99.25,98.06,95.59,94.62,95.31,95.94,97.41,99.66,102.0,101.81,104.75,107.28,107.41,109.03,110.06,109.38,109.06,106.44,105.81,104.19,101.88,102.03,103.81,105.69,109.34,111.66,114.53,114.09,114.41,114.69,114.25,114.56,113.66,114.44,112.62,111.59,111.62,110.19,110.59,111.09,110.44,110.69,109.31,107.72,106.94,106.72,105.44,107.03,107.84,109.06,109.72,110.03,112.06,110.66,111.84,112.81,115.06,117.09,119.03,121.16,121.03,122.19,121.12,120.81,119.81,116.69,116.97,115.69,114.72,112.81,112.5,109.53,107.66,105.25,105.06,104.72,105.41,106.91,107.69,107.84,111.59,112.75,115.62,116.78,118.44,118.31,117.69,117.5,115.62,115.88,113.31,111.94,110.81,109.09,109.06,108.91,109.97,110.81,111.38,111.5,114.28,115.16,116.91,117.59,117.09,114.22,111.41,107.19,105.94,105.34,106.91,108.97,112.34,114.62,115.06,114.88,114.34,112.84,112.06,109.91,108.38,106.06,104.31,102.34,101.38,100.41,98.44,99.19,97.47,97.69,98.34,100.31,101.38,104.97,104.53,108.03,109.91,111.28,114.69,114.28,114.09,112.03,109.56,107.91,106.75,106.34,105.06,103.66,103.41,102.69,102.28,104.03,105.0,105.81,106.34,105.53,103.56,103.5,101.22,101.5,101.41,101.47,101.44,102.5,103.12,103.19,104.53,103.66,103.72,103.84,104.28,104.94,106.22,107.5,107.75,108.31,109.41,108.66,107.56,107.22,106.12,105.56,104.5,103.41,102.75,102.5,102.12,102.66,104.94,105.31,106.59,105.44,105.06,105.62,104.56,104.88,105.62,106.28,105.91,106.22,106.59,106.16,106.84,107.38,106.66,106.28,109.19,107.38,109.81,110.94,109.41,110.0,110.31,108.91,107.78,107.91,107.28,105.19,105.97,105.53,107.38,108.16,108.94,109.41,111.25,111.31,111.88,112.09,113.0,113.75,113.28,112.5,113.44,114.0,115.34,116.97,119.06,121.31,122.16,121.62,119.44,118.56,114.59,112.0,110.84,108.44,106.12,103.25,101.72,98.56,96.94,97.81,97.38,97.53,98.69,98.84,100.06,102.06,102.25,102.81,102.88,103.28,103.84,105.38,105.56,105.81,104.5,103.41,103.28,101.16,101.56,102.28,102.78,103.88,106.59,108.25,110.25,111.0,112.12,111.5,111.44,111.91,112.69,113.78,114.75,116.38,117.25,118.06,117.66,117.16,116.69,115.12,113.91,113.12,111.34,108.56,109.12,107.16,107.38,108.56,111.56,111.94,115.41,116.41,117.41,117.22,116.41,115.97,114.0,114.38,113.66,112.56,112.19,110.88,109.16,106.03,104.19,102.78,101.03,99.41,98.94,98.31,98.16,98.03,96.56,98.06,97.56,98.91,100.19,102.06,102.69,100.94,101.88,100.62,100.06,99.75,100.28,99.88,97.72,97.94,97.88,97.69,97.94,99.41,99.97,99.94,102.19,101.88,103.38,102.59,103.06,102.81,102.31,102.16,101.97,101.59,101.53,101.34,100.66,101.53,101.78,101.97,101.97,102.69,102.34,101.97,102.25,102.16,101.66,102.25,102.62,102.22,102.56,101.69,102.78,103.16,103.94,105.56,105.84,107.31,108.28,110.41,111.62,110.91,112.84,111.16,108.34,105.34,104.0,102.0,103.12,104.88,107.75,110.28,113.0,113.44,113.53,114.41,113.03,113.59,113.81,113.78,113.25,112.25,111.88,110.19,111.81,111.12,113.75,115.09,117.0,118.12,117.81,118.75,118.84,117.81,117.44,115.62,112.41,108.34,107.19,104.94,102.72,103.84,104.19,104.31,104.66,106.94,107.44,107.69,109.97,110.56,111.56,112.62,111.94,110.28,108.44,104.53,101.56,100.31,97.06,96.5,95.56,93.62,91.31,89.41,87.62,85.09,83.28,81.84,80.25,76.69,74.44,72.53,70.31,68.69,68.28,68.47,68.69,69.56,70.56,72.5,73.72,74.5,73.62,72.75,71.56,68.91,67.88,66.91,66.53,66.38,64.72,62.66,60.25,59.25,57.47,55.84,55.81,54.91,54.06,53.06,53.03,52.5,51.81,51.88,51.53,52.34,53.03,53.66,54.44,54.66,55.12,55.31,55.25,56.25,57.75,58.5,59.94,60.19,60.59,59.81:negativity
34.72,35.47,35.41,36.41,37.44,38.94,37.31,40.91,40.59,41.41,43.25,44.97,44.31,43.84,42.38,40.03,39.44,38.81,39.72,37.38,39.94,38.81,39.06,38.41,38.66,36.09,35.0,32.31,33.59,32.84,33.81,37.03,38.66,40.84,40.5,42.0,42.81,41.62,42.19,41.25,40.38,39.78,39.5,39.38,38.69,38.56,36.25,36.06,34.12,33.44,33.09,33.56,33.53,33.16,32.81,32.06,33.84,35.28,37.41,39.97,43.75,44.5,44.34,44.0,42.44,38.25,35.41,32.84,28.78,22.69,21.56,16.69,13.44,12.0,10.38,8.94,8.5,9.91,11.94,14.59,17.41,20.38,23.66,24.25,29.56,31.72,35.69,38.62,41.66,44.44,44.62,44.66,43.62,42.72,39.84,37.72,37.81,36.41,38.19,39.56,40.62,43.12,43.75,45.25,45.19,45.0,43.75,42.38,38.19,39.0,38.28,39.62,42.16,44.5,43.81,40.78,40.16,37.12,35.19,35.62,34.12,33.0,31.16,29.34,28.75,28.5,29.88,31.53,32.0,35.69,37.81,39.88,43.56,46.28,50.19,53.0,54.81,57.59,58.25,61.41,62.5,63.22,63.72,61.62,59.25,55.44,50.44,46.41,43.81,39.19,36.28,34.91,34.31,33.94,36.75,39.94,43.62,45.53,46.09,48.38,47.72,46.06,43.44,44.88,43.0,44.53,46.22,47.41,49.31,49.09,48.56,44.94,46.22,42.56,42.5,42.53,43.44,44.19,44.81,46.38,45.94,45.12,42.5,40.56,35.12,37.66,36.94,38.62,42.19,45.16,48.28,50.0,51.38,52.94,52.5,49.06,47.94,44.5,39.69,36.16,33.94,31.38,30.56,30.91,32.44,31.44,36.09,37.25,39.31,43.38,45.53,46.84,47.88,47.91,48.03,45.38,46.84,45.47,43.5,43.31,41.06,38.59,36.38,34.56,33.25,34.0,34.16,34.44,38.06,38.28,40.88,44.34,46.53,48.94,51.72,51.25,55.28,56.28,56.44,58.22,58.12,57.41,55.12,53.81,52.31,50.06,49.03,47.19,48.31,48.31,49.78,53.12,57.19,60.22,61.81,63.41,63.03,60.91,59.31,54.53,53.69,52.66,51.06,52.44,54.31,54.41,55.44,56.03,54.31,57.34,56.31,58.28,58.91,60.0,59.56,59.03,57.97,58.31,55.94,58.66,58.31,57.84,56.97,55.47,52.28,49.38,44.53,46.19,45.78,47.94,50.59,52.06,52.5,53.0,52.62,52.38,52.94,51.84,50.81,53.03,52.91,56.09,59.16,61.31,61.5,61.62,59.78,59.53,59.88,58.66,62.53,62.91,64.44,65.94,66.09,64.78,61.59,59.38,58.25,55.47,52.53,55.12,54.91,57.19,59.62,63.94,67.06,67.78,68.41,68.5,66.62,63.25,60.12,60.44,58.03,59.88,62.06,62.31,63.69,63.81,62.81,62.03,58.81,60.47,60.12,60.88,61.53,63.56,62.66,63.72,64.19,64.16,63.5,63.59,61.78,60.62,58.56,57.0,54.94,51.84,53.47,52.28,51.81,52.41,52.88,51.97,51.56,51.34,52.12,54.06,56.81,59.31,60.88,60.94,60.94,60.28,59.5,58.62,59.31,58.41,57.06,54.91,53.44,51.81,50.38,50.31,46.53,48.81,46.72,45.81,46.44,47.12,47.31,47.53,47.66,49.56,50.62,52.69,53.28,52.81,52.75,50.31,47.31,45.06,42.31,41.41,40.38,40.06,41.56,42.78,45.84,50.0,52.91,54.16,58.19,57.78,57.78,57.38,56.72,56.06,54.97,54.91,54.0,54.5,53.16,51.81,49.38,47.06,43.25,40.44,37.12,34.44,33.59,30.91,31.59,33.31,34.28,37.75,41.53,44.62,47.16,48.22,47.66,50.25,50.31,49.94,50.69,50.75,49.25,46.56,44.69,40.56,36.84,35.72,33.38,31.81,33.09,34.03,33.72,34.69,36.66,38.03,39.69,40.72,40.81,42.81,41.59,43.41,43.84,45.03,44.75,42.28,44.44,43.03,43.66,45.56,46.41,47.0,47.62,47.22,47.56,45.62,44.75,45.31,44.88,45.69,46.88,46.72,46.62,45.19,41.19,41.22,39.91,39.16,41.16,42.78,44.38,45.28,45.78,45.31,43.03,42.72,40.81,42.47,43.97,45.41,49.25,52.31,54.56,54.41,56.09,52.91,55.44,54.12,54.81,57.12,58.16,58.5,58.62,59.38,58.34,58.03,57.91,55.66,52.88,51.12,48.41,46.47,45.75,44.66,43.44,41.88,40.16,39.69,39.59,37.97,40.06,41.47,42.56,45.25,46.91,46.75,47.12,45.66,41.84,44.62,42.5,44.0,45.62,46.53,47.69,46.28,45.66,41.88,40.31,37.03,34.56,35.03,35.25,37.31,38.72,39.81,40.38,40.16,40.12,36.38,39.69,38.31,40.28,43.41,45.94,48.53,48.16,49.22,47.62,44.0,44.41,41.84,40.34,39.44,39.53,38.56,37.41,35.94,33.47,35.66,33.84,34.16,34.41,34.19,33.53,33.16,34.56,34.78,39.91,42.19,45.31,48.25,49.19,48.88,48.16,45.19,43.72,41.31,38.0,37.94,37.66,35.81,37.72,38.53,39.34,40.41,42.0,43.25,43.81,45.06,45.38,43.75,46.91,47.62,50.69,54.28,56.06,57.31,57.41,56.91,56.53,53.06,52.44,49.47,45.72,44.28,42.66,42.88,42.25,43.94,46.38,48.78,50.59,52.28,51.84,48.66,49.56,47.59,46.78,48.44,49.34,50.16,48.97,48.44,48.34,43.91,46.84,44.88,44.69,45.06,45.34,43.88,42.06,39.66,37.5,36.22,35.69,34.47,37.19,39.81,42.66,46.84,49.97,51.66,52.16,51.53,46.06,47.69,44.25,43.03,44.12,44.06,44.0,44.66,45.47,46.19,46.06,46.81,46.56,45.66,42.34,45.16,43.41,44.41,46.44,46.88,48.66,49.81,50.25,50.84,49.12,52.78,51.97,53.78,55.0,54.62,54.72,51.53,48.97,47.03,43.0,41.84,40.75,37.34,37.81,37.34,37.47,39.34,41.78,42.41,43.19,43.41,42.25,42.81,41.53,39.94,40.34,39.81,39.16,38.88,39.16,37.66,38.41,37.34,38.0,39.25,40.75,40.19,44.31,44.38,44.88,46.81,46.62,47.81,47.88,46.66,47.72,47.5,46.31,46.62,46.56,45.75,45.12,42.19,43.66,41.69,40.78,40.59,41.16,41.31,40.84,43.06,44.28,44.94,46.5,46.69,47.38,48.12,45.75,49.94,48.03,47.78,47.81,45.75,43.66,41.16,38.56,34.38,32.72,30.91,29.09,30.34,32.0,33.16,35.38,36.84,37.94,38.09,39.28,40.5,40.0,41.25,43.62,44.81,47.12,48.0,50.22,50.38,50.38,51.0,50.59,49.91,49.0,48.06,46.03,46.59,46.06,46.81,48.56,49.78,50.12,49.84,49.38,48.75,48.78,48.28,50.09,51.69,52.03,54.03,54.31,53.25,52.47,51.44,51.28,51.88,52.81,53.47,53.75,55.66,54.81,55.03,52.94,50.78,47.81,45.41,43.53,41.94,42.34,43.34,43.75,42.12,46.19,44.88,44.09,44.78,43.31,41.81,41.28,40.5,41.16,42.03,44.66,45.84,47.5,49.44,48.78,46.5,43.91,40.5,37.41,33.62,32.41,32.47,29.06,34.25,36.12,39.81,45.03,48.47,52.56,53.91,53.31,52.5,50.0,46.72,45.5,43.75,43.19,43.44,43.47,42.62,44.81,44.0,44.31,46.94,47.41,48.59,46.41,50.06,49.22,49.12,49.16,47.69,45.78,41.75,39.69,36.12,35.0,33.19:37.31,40.91,40.59,41.41,43.25,44.97,44.31,43.84,42.38,40.03,39.44,38.81,39.72,37.38,39.94,38.81,39.06,38.41,38.66,36.09,35.0,32.31,33.59,32.84,33.81,37.03,38.66,40.84,40.5,42.0,42.81,41.62,42.19,41.25,40.38,39.78,39.5,39.38,38.69,38.56,36.25,36.06,34.12,33.44,33.09,33.56,33.53,33.16,32.81,32.06,33.84,35.28,37.41,39.97,43.75,44.5,44.34,44.0,42.44,38.25,35.41,32.84,28.78,22.69,21.56,16.69,13.44,12.0,10.38,8.94,8.5,9.91,11.94,14.59,17.41,20.38,23.66,24.25,29.56,31.72,35.69,38.62,41.66,44.44,44.62,44.66,43.62,42.72,39.84,37.72,37.81,36.41,38.19,39.56,40.62,43.12,43.75,45.25,45.19,45.0,43.75,42.38,38.19,39.0,38.28,39.62,42.16,44.5,43.81,40.78,40.16,37.12,35.19,35.62,34.12,33.0,31.16,29.34,28.75,28.5,29.88,31.53,32.0,35.69,37.81,39.88,43.56,46.28,50.19,53.0,54.81,57.59,58.25,61.41,62.5,63.22,63.72,61.62,59.25,55.44,50.44,46.41,43.81,39.19,36.28,34.91,34.31,33.94,36.75,39.94,43.62,45.53,46.09,48.38,47.72,46.06,43.44,44.88,43.0,44.53,46.22,47.41,49.31,49.09,48.56,44.94,46.22,42.56,42.5,42.53,43.44,44.19,44.81,46.38,45.94,45.12,42.5,40.56,35.12,37.66,36.94,38.62,42.19,45.16,48.28,50.0,51.38,52.94,52.5,49.06,47.94,44.5,39.69,36.16,33.94,31.38,30.56,30.91,32.44,31.44,36.09,37.25,39.31,43.38,45.53,46.84,47.88,47.91,48.03,45.38,46.84,45.47,43.5,43.31,41.06,38.59,36.38,34.56,33.25,34.0,34.16,34.44,38.06,38.28,40.88,44.34,46.53,48.94,51.72,51.25,55.28,56.28,56.44,58.22,58.12,57.41,55.12,53.81,52.31,50.06,49.03,47.19,48.31,48.31,49.78,53.12,57.19,60.22,61.81,63.41,63.03,60.91,59.31,54.53,53.69,52.66,51.06,52.44,54.31,54.41,55.44,56.03,54.31,57.34,56.31,58.28,58.91,60.0,59.56,59.03,57.97,58.31,55.94,58.66,58.31,57.84,56.97,55.47,52.28,49.38,44.53,46.19,45.78,47.94,50.59,52.06,52.5,53.0,52.62,52.38,52.94,51.84,50.81,53.03,52.91,56.09,59.16,61.31,61.5,61.62,59.78,59.53,59.88,58.66,62.53,62.91,64.44,65.94,66.09,64.78,61.59,59.38,58.25,55.47,52.53,55.12,54.91,57.19,59.62,63.94,67.06,67.78,68.41,68.5,66.62,63.25,60.12,60.44,58.03,59.88,62.06,62.31,63.69,63.81,62.81,62.03,58.81,60.47,60.12,60.88,61.53,63.56,62.66,63.72,64.19,64.16,63.5,63.59,61.78,60.62,58.56,57.0,54.94,51.84,53.47,52.28,51.81,52.41,52.88,51.97,51.56,51.34,52.12,54.06,56.81,59.31,60.88,60.94,60.94,60.28,59.5,58.62,59.31,58.41,57.06,54.91,53.44,51.81,50.38,50.31,46.53,48.81,46.72,45.81,46.44,47.12,47.31,47.53,47.66,49.56,50.62,52.69,53.28,52.81,52.75,50.31,47.31,45.06,42.31,41.41,40.38,40.06,41.56,42.78,45.84,50.0,52.91,54.16,58.19,57.78,57.78,57.38,56.72,56.06,54.97,54.91,54.0,54.5,53.16,51.81,49.38,47.06,43.25,40.44,37.12,34.44,33.59,30.91,31.59,33.31,34.28,37.75,41.53,44.62,47.16,48.22,47.66,50.25,50.31,49.94,50.69,50.75,49.25,46.56,44.69,40.56,36.84,35.72,33.38,31.81,33.09,34.03,33.72,34.69,36.66,38.03,39.69,40.72,40.81,42.81,41.59,43.41,43.84,45.03,44.75,42.28,44.44,43.03,43.66,45.56,46.41,47.0,47.62,47.22,47.56,45.62,44.75,45.31,44.88,45.69,46.88,46.72,46.62,45.19,41.19,41.22,39.91,39.16,41.16,42.78,44.38,45.28,45.78,45.31,43.03,42.72,40.81,42.47,43.97,45.41,49.25,52.31,54.56,54.41,56.09,52.91,55.44,54.12,54.81,57.12,58.16,58.5,58.62,59.38,58.34,58.03,57.91,55.66,52.88,51.12,48.41,46.47,45.75,44.66,43.44,41.88,40.16,39.69,39.59,37.97,40.06,41.47,42.56,45.25,46.91,46.75,47.12,45.66,41.84,44.62,42.5,44.0,45.62,46.53,47.69,46.28,45.66,41.88,40.31,37.03,34.56,35.03,35.25,37.31,38.72,39.81,40.38,40.16,40.12,36.38,39.69,38.31,40.28,43.41,45.94,48.53,48.16,49.22,47.62,44.0,44.41,41.84,40.34,39.44,39.53,38.56,37.41,35.94,33.47,35.66,33.84,34.16,34.41,34.19,33.53,33.16,34.56,34.78,39.91,42.19,45.31,48.25,49.19,48.88,48.16,45.19,43.72,41.31,38.0,37.94,37.66,35.81,37.72,38.53,39.34,40.41,42.0,43.25,43.81,45.06,45.38,43.75,46.91,47.62,50.69,54.28,56.06,57.31,57.41,56.91,56.53,53.06,52.44,49.47,45.72,44.28,42.66,42.88,42.25,43.94,46.38,48.78,50.59,52.28,51.84,48.66,49.56,47.59,46.78,48.44,49.34,50.16,48.97,48.44,48.34,43.91,46.84,44.88,44.69,45.06,45.34,43.88,42.06,39.66,37.5,36.22,35.69,34.47,37.19,39.81,42.66,46.84,49.97,51.66,52.16,51.53,46.06,47.69,44.25,43.03,44.12,44.06,44.0,44.66,45.47,46.19,46.06,46.81,46.56,45.66,42.34,45.16,43.41,44.41,46.44,46.88,48.66,49.81,50.25,50.84,49.12,52.78,51.97,53.78,55.0,54.62,54.72,51.53,48.97,47.03,43.0,41.84,40.75,37.34,37.81,37.34,37.47,39.34,41.78,42.41,43.19,43.41,42.25,42.81,41.53,39.94,40.34,39.81,39.16,38.88,39.16,37.66,38.41,37.34,38.0,39.25,40.75,40.19,44.31,44.38,44.88,46.81,46.62,47.81,47.88,46.66,47.72,47.5,46.31,46.62,46.56,45.75,45.12,42.19,43.66,41.69,40.78,40.59,41.16,41.31,40.84,43.06,44.28,44.94,46.5,46.69,47.38,48.12,45.75,49.94,48.03,47.78,47.81,45.75,43.66,41.16,38.56,34.38,32.72,30.91,29.09,30.34,32.0,33.16,35.38,36.84,37.94,38.09,39.28,40.5,40.0,41.25,43.62,44.81,47.12,48.0,50.22,50.38,50.38,51.0,50.59,49.91,49.0,48.06,46.03,46.59,46.06,46.81,48.56,49.78,50.12,49.84,49.38,48.75,48.78,48.28,50.09,51.69,52.03,54.03,54.31,53.25,52.47,51.44,51.28,51.88,52.81,53.47,53.75,55.66,54.81,55.03,52.94,50.78,47.81,45.41,43.53,41.94,42.34,43.34,43.75,42.12,46.19,44.88,44.09,44.78,43.31,41.81,41.28,40.5,41.16,42.03,44.66,45.84,47.5,49.44,48.78,46.5,43.91,40.5,37.41,33.62,32.41,32.47,29.06,34.25,36.12,39.81,45.03,48.47,52.56,53.91,53.31,52.5,50.0,46.72,45.5,43.75,43.19,43.44,43.47,42.62,44.81,44.0,44.31,46.94,47.41,48.59,46.41,50.06,49.22,49.12,49.16,47.69,45.78,41.75,39.69,36.12,35.0,33.19,-9.56,-8.34,-8.03,-6.53,-4.69,-2.91:44.31,43.84,42.38,40.03,39.44,38.81,39.72,37.38,39.94,38.81,39.06,38.41,38.66,36.09,35.0,32.31,33.59,32.84,33.81,37.03,38.66,40.84,40.5,42.0,42.81,41.62,42.19,41.25,40.38,39.78,39.5,39.38,38.69,38.56,36.25,36.06,34.12,33.44,33.09,33.56,33.53,33.16,32.81,32.06,33.84,35.28,37.41,39.97,43.75,44.5,44.34,44.0,42.44,38.25,35.41,32.84,28.78,22.69,21.56,16.69,13.44,12.0,10.38,8.94,8.5,9.91,11.94,14.59,17.41,20.38,23.66,24.25,29.56,31.72,35.69,38.62,41.66,44.44,44.62,44.66,43.62,42.72,39.84,37.72,37.81,36.41,38.19,39.56,40.62,43.12,43.75,45.25,45.19,45.0,43.75,42.38,38.19,39.0,38.28,39.62,42.16,44.5,43.81,40.78,40.16,37.12,35.19,35.62,34.12,33.0,31.16,29.34,28.75,28.5,29.88,31.53,32.0,35.69,37.81,39.88,43.56,46.28,50.19,53.0,54.81,57.59,58.25,61.41,62.5,63.22,63.72,61.62,59.25,55.44,50.44,46.41,43.81,39.19,36.28,34.91,34.31,33.94,36.75,39.94,43.62,45.53,46.09,48.38,47.72,46.06,43.44,44.88,43.0,44.53,46.22,47.41,49.31,49.09,48.56,44.94,46.22,42.56,42.5,42.53,43.44,44.19,44.81,46.38,45.94,45.12,42.5,40.56,35.12,37.66,36.94,38.62,42.19,45.16,48.28,50.0,51.38,52.94,52.5,49.06,47.94,44.5,39.69,36.16,33.94,31.38,30.56,30.91,32.44,31.44,36.09,37.25,39.31,43.38,45.53,46.84,47.88,47.91,48.03,45.38,46.84,45.47,43.5,43.31,41.06,38.59,36.38,34.56,33.25,34.0,34.16,34.44,38.06,38.28,40.88,44.34,46.53,48.94,51.72,51.25,55.28,56.28,56.44,58.22,58.12,57.41,55.12,53.81,52.31,50.06,49.03,47.19,48.31,48.31,49.78,53.12,57.19,60.22,61.81,63.41,63.03,60.91,59.31,54.53,53.69,52.66,51.06,52.44,54.31,54.41,55.44,56.03,54.31,57.34,56.31,58.28,58.91,60.0,59.56,59.03,57.97,58.31,55.94,58.66,58.31,57.84,56.97,55.47,52.28,49.38,44.53,46.19,45.78,47.94,50.59,52.06,52.5,53.0,52.62,52.38,52.94,51.84,50.81,53.03,52.91,56.09,59.16,61.31,61.5,61.62,59.78,59.53,59.88,58.66,62.53,62.91,64.44,65.94,66.09,64.78,61.59,59.38,58.25,55.47,52.53,55.12,54.91,57.19,59.62,63.94,67.06,67.78,68.41,68.5,66.62,63.25,60.12,60.44,58.03,59.88,62.06,62.31,63.69,63.81,62.81,62.03,58.81,60.47,60.12,60.88,61.53,63.56,62.66,63.72,64.19,64.16,63.5,63.59,61.78,60.62,58.56,57.0,54.94,51.84,53.47,52.28,51.81,52.41,52.88,51.97,51.56,51.34,52.12,54.06,56.81,59.31,60.88,60.94,60.94,60.28,59.5,58.62,59.31,58.41,57.06,54.91,53.44,51.81,50.38,50.31,46.53,48.81,46.72,45.81,46.44,47.12,47.31,47.53,47.66,49.56,50.62,52.69,53.28,52.81,52.75,50.31,47.31,45.06,42.31,41.41,40.38,40.06,41.56,42.78,45.84,50.0,52.91,54.16,58.19,57.78,57.78,57.38,56.72,56.06,54.97,54.91,54.0,54.5,53.16,51.81,49.38,47.06,43.25,40.44,37.12,34.44,33.59,30.91,31.59,33.31,34.28,37.75,41.53,44.62,47.16,48.22,47.66,50.25,50.31,49.94,50.69,50.75,49.25,46.56,44.69,40.56,36.84,35.72,33.38,31.81,33.09,34.03,33.72,34.69,36.66,38.03,39.69,40.72,40.81,42.81,41.59,43.41,43.84,45.03,44.75,42.28,44.44,43.03,43.66,45.56,46.41,47.0,47.62,47.22,47.56,45.62,44.75,45.31,44.88,45.69,46.88,46.72,46.62,45.19,41.19,41.22,39.91,39.16,41.16,42.78,44.38,45.28,45.78,45.31,43.03,42.72,40.81,42.47,43.97,45.41,49.25,52.31,54.56,54.41,56.09,52.91,55.44,54.12,54.81,57.12,58.16,58.5,58.62,59.38,58.34,58.03,57.91,55.66,52.88,51.12,48.41,46.47,45.75,44.66,43.44,41.88,40.16,39.69,39.59,37.97,40.06,41.47,42.56,45.25,46.91,46.75,47.12,45.66,41.84,44.62,42.5,44.0,45.62,46.53,47.69,46.28,45.66,41.88,40.31,37.03,34.56,35.03,35.25,37.31,38.72,39.81,40.38,40.16,40.12,36.38,39.69,38.31,40.28,43.41,45.94,48.53,48.16,49.22,47.62,44.0,44.41,41.84,40.34,39.44,39.53,38.56,37.41,35.94,33.47,35.66,33.84,34.16,34.41,34.19,33.53,33.16,34.56,34.78,39.91,42.19,45.31,48.25,49.19,48.88,48.16,45.19,43.72,41.31,38.0,37.94,37.66,35.81,37.72,38.53,39.34,40.41,42.0,43.25,43.81,45.06,45.38,43.75,46.91,47.62,50.69,54.28,56.06,57.31,57.41,56.91,56.53,53.06,52.44,49.47,45.72,44.28,42.66,42.88,42.25,43.94,46.38,48.78,50.59,52.28,51.84,48.66,49.56,47.59,46.78,48.44,49.34,50.16,48.97,48.44,48.34,43.91,46.84,44.88,44.69,45.06,45.34,43.88,42.06,39.66,37.5,36.22,35.69,34.47,37.19,39.81,42.66,46.84,49.97,51.66,52.16,51.53,46.06,47.69,44.25,43.03,44.12,44.06,44.0,44.66,45.47,46.19,46.06,46.81,46.56,45.66,42.34,45.16,43.41,44.41,46.44,46.88,48.66,49.81,50.25,50.84,49.12,52.78,51.97,53.78,55.0,54.62,54.72,51.53,48.97,47.03,43.0,41.84,40.75,37.34,37.81,37.34,37.47,39.34,41.78,42.41,43.19,43.41,42.25,42.81,41.53,39.94,40.34,39.81,39.16,38.88,39.16,37.66,38.41,37.34,38.0,39.25,40.75,40.19,44.31,44.38,44.88,46.81,46.62,47.81,47.88,46.66,47.72,47.5,46.31,46.62,46.56,45.75,45.12,42.19,43.66,41.69,40.78,40.59,41.16,41.31,40.84,43.06,44.28,44.94,46.5,46.69,47.38,48.12,45.75,49.94,48.03,47.78,47.81,45.75,43.66,41.16,38.56,34.38,32.72,30.91,29.09,30.34,32.0,33.16,35.38,36.84,37.94,38.09,39.28,40.5,40.0,41.25,43.62,44.81,47.12,48.0,50.22,50.38,50.38,51.0,50.59,49.91,49.0,48.06,46.03,46.59,46.06,46.81,48.56,49.78,50.12,49.84,49.38,48.75,48.78,48.28,50.09,51.69,52.03,54.03,54.31,53.25,52.47,51.44,51.28,51.88,52.81,53.47,53.75,55.66,54.81,55.03,52.94,50.78,47.81,45.41,43.53,41.94,42.34,43.34,43.75,42.12,46.19,44.88,44.09,44.78,43.31,41.81,41.28,40.5,41.16,42.03,44.66,45.84,47.5,49.44,48.78,46.5,43.91,40.5,37.41,33.62,32.41,32.47,29.06,34.25,36.12,39.81,45.03,48.47,52.56,53.91,53.31,52.5,50.0,46.72,45.5,43.75,43.19,43.44,43.47,42.62,44.81,44.0,44.31,46.94,47.41,48.59,46.41,50.06,49.22,49.12,49.16,47.69,45.78,41.75,39.69,36.12,35.0,33.19,-9.56,-8.34,-8.03,-6.53,-4.69,-2.91,-2.0,1.44,2.91,5.19,6.81,9.09:39.72,37.38,39.94,38.81,39.06,38.41,38.66,36.09,35.0,32.31,33.59,32.84,33.81,37.03,38.66,40.84,40.5,42.0,42.81,41.62,42.19,41.25,40.38,39.78,39.5,39.38,38.69,38.56,36.25,36.06,34.12,33.44,33.09,33.56,33.53,33.16,32.81,32.06,33.84,35.28,37.41,39.97,43.75,44.5,44.34,44.0,42.44,38.25,35.41,32.84,28.78,22.69,21.56,16.69,13.44,12.0,10.38,8.94,8.5,9.91,11.94,14.59,17.41,20.38,23.66,24.25,29.56,31.72,35.69,38.62,41.66,44.44,44.62,44.66,43.62,42.72,39.84,37.72,37.81,36.41,38.19,39.56,40.62,43.12,43.75,45.25,45.19,45.0,43.75,42.38,38.19,39.0,38.28,39.62,42.16,44.5,43.81,40.78,40.16,37.12,35.19,35.62,34.12,33.0,31.16,29.34,28.75,28.5,29.88,31.53,32.0,35.69,37.81,39.88,43.56,46.28,50.19,53.0,54.81,57.59,58.25,61.41,62.5,63.22,63.72,61.62,59.25,55.44,50.44,46.41,43.81,39.19,36.28,34.91,34.31,33.94,36.75,39.94,43.62,45.53,46.09,48.38,47.72,46.06,43.44,44.88,43.0,44.53,46.22,47.41,49.31,49.09,48.56,44.94,46.22,42.56,42.5,42.53,43.44,44.19,44.81,46.38,45.94,45.12,42.5,40.56,35.12,37.66,36.94,38.62,42.19,45.16,48.28,50.0,51.38,52.94,52.5,49.06,47.94,44.5,39.69,36.16,33.94,31.38,30.56,30.91,32.44,31.44,36.09,37.25,39.31,43.38,45.53,46.84,47.88,47.91,48.03,45.38,46.84,45.47,43.5,43.31,41.06,38.59,36.38,34.56,33.25,34.0,34.16,34.44,38.06,38.28,40.88,44.34,46.53,48.94,51.72,51.25,55.28,56.28,56.44,58.22,58.12,57.41,55.12,53.81,52.31,50.06,49.03,47.19,48.31,48.31,49.78,53.12,57.19,60.22,61.81,63.41,63.03,60.91,59.31,54.53,53.69,52.66,51.06,52.44,54.31,54.41,55.44,56.03,54.31,57.34,56.31,58.28,58.91,60.0,59.56,59.03,57.97,58.31,55.94,58.66,58.31,57.84,56.97,55.47,52.28,49.38,44.53,46.19,45.78,47.94,50.59,52.06,52.5,53.0,52.62,52.38,52.94,51.84,50.81,53.03,52.91,56.09,59.16,61.31,61.5,61.62,59.78,59.53,59.88,58.66,62.53,62.91,64.44,65.94,66.09,64.78,61.59,59.38,58.25,55.47,52.53,55.12,54.91,57.19,59.62,63.94,67.06,67.78,68.41,68.5,66.62,63.25,60.12,60.44,58.03,59.88,62.06,62.31,63.69,63.81,62.81,62.03,58.81,60.47,60.12,60.88,61.53,63.56,62.66,63.72,64.19,64.16,63.5,63.59,61.78,60.62,58.56,57.0,54.94,51.84,53.47,52.28,51.81,52.41,52.88,51.97,51.56,51.34,52.12,54.06,56.81,59.31,60.88,60.94,60.94,60.28,59.5,58.62,59.31,58.41,57.06,54.91,53.44,51.81,50.38,50.31,46.53,48.81,46.72,45.81,46.44,47.12,47.31,47.53,47.66,49.56,50.62,52.69,53.28,52.81,52.75,50.31,47.31,45.06,42.31,41.41,40.38,40.06,41.56,42.78,45.84,50.0,52.91,54.16,58.19,57.78,57.78,57.38,56.72,56.06,54.97,54.91,54.0,54.5,53.16,51.81,49.38,47.06,43.25,40.44,37.12,34.44,33.59,30.91,31.59,33.31,34.28,37.75,41.53,44.62,47.16,48.22,47.66,50.25,50.31,49.94,50.69,50.75,49.25,46.56,44.69,40.56,36.84,35.72,33.38,31.81,33.09,34.03,33.72,34.69,36.66,38.03,39.69,40.72,40.81,42.81,41.59,43.41,43.84,45.03,44.75,42.28,44.44,43.03,43.66,45.56,46.41,47.0,47.62,47.22,47.56,45.62,44.75,45.31,44.88,45.69,46.88,46.72,46.62,45.19,41.19,41.22,39.91,39.16,41.16,42.78,44.38,45.28,45.78,45.31,43.03,42.72,40.81,42.47,43.97,45.41,49.25,52.31,54.56,54.41,56.09,52.91,55.44,54.12,54.81,57.12,58.16,58.5,58.62,59.38,58.34,58.03,57.91,55.66,52.88,51.12,48.41,46.47,45.75,44.66,43.44,41.88,40.16,39.69,39.59,37.97,40.06,41.47,42.56,45.25,46.91,46.75,47.12,45.66,41.84,44.62,42.5,44.0,45.62,46.53,47.69,46.28,45.66,41.88,40.31,37.03,34.56,35.03,35.25,37.31,38.72,39.81,40.38,40.16,40.12,36.38,39.69,38.31,40.28,43.41,45.94,48.53,48.16,49.22,47.62,44.0,44.41,41.84,40.34,39.44,39.53,38.56,37.41,35.94,33.47,35.66,33.84,34.16,34.41,34.19,33.53,33.16,34.56,34.78,39.91,42.19,45.31,48.25,49.19,48.88,48.16,45.19,43.72,41.31,38.0,37.94,37.66,35.81,37.72,38.53,39.34,40.41,42.0,43.25,43.81,45.06,45.38,43.75,46.91,47.62,50.69,54.28,56.06,57.31,57.41,56.91,56.53,53.06,52.44,49.47,45.72,44.28,42.66,42.88,42.25,43.94,46.38,48.78,50.59,52.28,51.84,48.66,49.56,47.59,46.78,48.44,49.34,50.16,48.97,48.44,48.34,43.91,46.84,44.88,44.69,45.06,45.34,43.88,42.06,39.66,37.5,36.22,35.69,34.47,37.19,39.81,42.66,46.84,49.97,51.66,52.16,51.53,46.06,47.69,44.25,43.03,44.12,44.06,44.0,44.66,45.47,46.19,46.06,46.81,46.56,45.66,42.34,45.16,43.41,44.41,46.44,46.88,48.66,49.81,50.25,50.84,49.12,52.78,51.97,53.78,55.0,54.62,54.72,51.53,48.97,47.03,43.0,41.84,40.75,37.34,37.81,37.34,37.47,39.34,41.78,42.41,43.19,43.41,42.25,42.81,41.53,39.94,40.34,39.81,39.16,38.88,39.16,37.66,38.41,37.34,38.0,39.25,40.75,40.19,44.31,44.38,44.88,46.81,46.62,47.81,47.88,46.66,47.72,47.5,46.31,46.62,46.56,45.75,45.12,42.19,43.66,41.69,40.78,40.59,41.16,41.31,40.84,43.06,44.28,44.94,46.5,46.69,47.38,48.12,45.75,49.94,48.03,47.78,47.81,45.75,43.66,41.16,38.56,34.38,32.72,30.91,29.09,30.34,32.0,33.16,35.38,36.84,37.94,38.09,39.28,40.5,40.0,41.25,43.62,44.81,47.12,48.0,50.22,50.38,50.38,51.0,50.59,49.91,49.0,48.06,46.03,46.59,46.06,46.81,48.56,49.78,50.12,49.84,49.38,48.75,48.78,48.28,50.09,51.69,52.03,54.03,54.31,53.25,52.47,51.44,51.28,51.88,52.81,53.47,53.75,55.66,54.81,55.03,52.94,50.78,47.81,45.41,43.53,41.94,42.34,43.34,43.75,42.12,46.19,44.88,44.09,44.78,43.31,41.81,41.28,40.5,41.16,42.03,44.66,45.84,47.5,49.44,48.78,46.5,43.91,40.5,37.41,33.62,32.41,32.47,29.06,34.25,36.12,39.81,45.03,48.47,52.56,53.91,53.31,52.5,50.0,46.72,45.5,43.75,43.19,43.44,43.47,42.62,44.81,44.0,44.31,46.94,47.41,48.59,46.41,50.06,49.22,49.12,49.16,47.69,45.78,41.75,39.69,36.12,35.0,33.19,-9.56,-8.34,-8.03,-6.53,-4.69,-2.91,-2.0,1.44,2.91,5.19,6.81,9.09,9.78,9.56,10.03,8.94,8.97,8.84:38.66,36.09,35.0,32.31,33.59,32.84,33.81,37.03,38.66,40.84,40.5,42.0,42.81,41.62,42.19,41.25,40.38,39.78,39.5,39.38,38.69,38.56,36.25,36.06,34.12,33.44,33.09,33.56,33.53,33.16,32.81,32.06,33.84,35.28,37.41,39.97,43.75,44.5,44.34,44.0,42.44,38.25,35.41,32.84,28.78,22.69,21.56,16.69,13.44,12.0,10.38,8.94,8.5,9.91,11.94,14.59,17.41,20.38,23.66,24.25,29.56,31.72,35.69,38.62,41.66,44.44,44.62,44.66,43.62,42.72,39.84,37.72,37.81,36.41,38.19,39.56,40.62,43.12,43.75,45.25,45.19,45.0,43.75,42.38,38.19,39.0,38.28,39.62,42.16,44.5,43.81,40.78,40.16,37.12,35.19,35.62,34.12,33.0,31.16,29.34,28.75,28.5,29.88,31.53,32.0,35.69,37.81,39.88,43.56,46.28,50.19,53.0,54.81,57.59,58.25,61.41,62.5,63.22,63.72,61.62,59.25,55.44,50.44,46.41,43.81,39.19,36.28,34.91,34.31,33.94,36.75,39.94,43.62,45.53,46.09,48.38,47.72,46.06,43.44,44.88,43.0,44.53,46.22,47.41,49.31,49.09,48.56,44.94,46.22,42.56,42.5,42.53,43.44,44.19,44.81,46.38,45.94,45.12,42.5,40.56,35.12,37.66,36.94,38.62,42.19,45.16,48.28,50.0,51.38,52.94,52.5,49.06,47.94,44.5,39.69,36.16,33.94,31.38,30.56,30.91,32.44,31.44,36.09,37.25,39.31,43.38,45.53,46.84,47.88,47.91,48.03,45.38,46.84,45.47,43.5,43.31,41.06,38.59,36.38,34.56,33.25,34.0,34.16,34.44,38.06,38.28,40.88,44.34,46.53,48.94,51.72,51.25,55.28,56.28,56.44,58.22,58.12,57.41,55.12,53.81,52.31,50.06,49.03,47.19,48.31,48.31,49.78,53.12,57.19,60.22,61.81,63.41,63.03,60.91,59.31,54.53,53.69,52.66,51.06,52.44,54.31,54.41,55.44,56.03,54.31,57.34,56.31,58.28,58.91,60.0,59.56,59.03,57.97,58.31,55.94,58.66,58.31,57.84,56.97,55.47,52.28,49.38,44.53,46.19,45.78,47.94,50.59,52.06,52.5,53.0,52.62,52.38,52.94,51.84,50.81,53.03,52.91,56.09,59.16,61.31,61.5,61.62,59.78,59.53,59.88,58.66,62.53,62.91,64.44,65.94,66.09,64.78,61.59,59.38,58.25,55.47,52.53,55.12,54.91,57.19,59.62,63.94,67.06,67.78,68.41,68.5,66.62,63.25,60.12,60.44,58.03,59.88,62.06,62.31,63.69,63.81,62.81,62.03,58.81,60.47,60.12,60.88,61.53,63.56,62.66,63.72,64.19,64.16,63.5,63.59,61.78,60.62,58.56,57.0,54.94,51.84,53.47,52.28,51.81,52.41,52.88,51.97,51.56,51.34,52.12,54.06,56.81,59.31,60.88,60.94,60.94,60.28,59.5,58.62,59.31,58.41,57.06,54.91,53.44,51.81,50.38,50.31,46.53,48.81,46.72,45.81,46.44,47.12,47.31,47.53,47.66,49.56,50.62,52.69,53.28,52.81,52.75,50.31,47.31,45.06,42.31,41.41,40.38,40.06,41.56,42.78,45.84,50.0,52.91,54.16,58.19,57.78,57.78,57.38,56.72,56.06,54.97,54.91,54.0,54.5,53.16,51.81,49.38,47.06,43.25,40.44,37.12,34.44,33.59,30.91,31.59,33.31,34.28,37.75,41.53,44.62,47.16,48.22,47.66,50.25,50.31,49.94,50.69,50.75,49.25,46.56,44.69,40.56,36.84,35.72,33.38,31.81,33.09,34.03,33.72,34.69,36.66,38.03,39.69,40.72,40.81,42.81,41.59,43.41,43.84,45.03,44.75,42.28,44.44,43.03,43.66,45.56,46.41,47.0,47.62,47.22,47.56,45.62,44.75,45.31,44.88,45.69,46.88,46.72,46.62,45.19,41.19,41.22,39.91,39.16,41.16,42.78,44.38,45.28,45.78,45.31,43.03,42.72,40.81,42.47,43.97,45.41,49.25,52.31,54.56,54.41,56.09,52.91,55.44,54.12,54.81,57.12,58.16,58.5,58.62,59.38,58.34,58.03,57.91,55.66,52.88,51.12,48.41,46.47,45.75,44.66,43.44,41.88,40.16,39.69,39.59,37.97,40.06,41.47,42.56,45.25,46.91,46.75,47.12,45.66,41.84,44.62,42.5,44.0,45.62,46.53,47.69,46.28,45.66,41.88,40.31,37.03,34.56,35.03,35.25,37.31,38.72,39.81,40.38,40.16,40.12,36.38,39.69,38.31,40.28,43.41,45.94,48.53,48.16,49.22,47.62,44.0,44.41,41.84,40.34,39.44,39.53,38.56,37.41,35.94,33.47,35.66,33.84,34.16,34.41,34.19,33.53,33.16,34.56,34.78,39.91,42.19,45.31,48.25,49.19,48.88,48.16,45.19,43.72,41.31,38.0,37.94,37.66,35.81,37.72,38.53,39.34,40.41,42.0,43.25,43.81,45.06,45.38,43.75,46.91,47.62,50.69,54.28,56.06,57.31,57.41,56.91,56.53,53.06,52.44,49.47,45.72,44.28,42.66,42.88,42.25,43.94,46.38,48.78,50.59,52.28,51.84,48.66,49.56,47.59,46.78,48.44,49.34,50.16,48.97,48.44,48.34,43.91,46.84,44.88,44.69,45.06,45.34,43.88,42.06,39.66,37.5,36.22,35.69,34.47,37.19,39.81,42.66,46.84,49.97,51.66,52.16,51.53,46.06,47.69,44.25,43.03,44.12,44.06,44.0,44.66,45.47,46.19,46.06,46.81,46.56,45.66,42.34,45.16,43.41,44.41,46.44,46.88,48.66,49.81,50.25,50.84,49.12,52.78,51.97,53.78,55.0,54.62,54.72,51.53,48.97,47.03,43.0,41.84,40.75,37.34,37.81,37.34,37.47,39.34,41.78,42.41,43.19,43.41,42.25,42.81,41.53,39.94,40.34,39.81,39.16,38.88,39.16,37.66,38.41,37.34,38.0,39.25,40.75,40.19,44.31,44.38,44.88,46.81,46.62,47.81,47.88,46.66,47.72,47.5,46.31,46.62,46.56,45.75,45.12,42.19,43.66,41.69,40.78,40.59,41.16,41.31,40.84,43.06,44.28,44.94,46.5,46.69,47.38,48.12,45.75,49.94,48.03,47.78,47.81,45.75,43.66,41.16,38.56,34.38,32.72,30.91,29.09,30.34,32.0,33.16,35.38,36.84,37.94,38.09,39.28,40.5,40.0,41.25,43.62,44.81,47.12,48.0,50.22,50.38,50.38,51.0,50.59,49.91,49.0,48.06,46.03,46.59,46.06,46.81,48.56,49.78,50.12,49.84,49.38,48.75,48.78,48.28,50.09,51.69,52.03,54.03,54.31,53.25,52.47,51.44,51.28,51.88,52.81,53.47,53.75,55.66,54.81,55.03,52.94,50.78,47.81,45.41,43.53,41.94,42.34,43.34,43.75,42.12,46.19,44.88,44.09,44.78,43.31,41.81,41.28,40.5,41.16,42.03,44.66,45.84,47.5,49.44,48.78,46.5,43.91,40.5,37.41,33.62,32.41,32.47,29.06,34.25,36.12,39.81,45.03,48.47,52.56,53.91,53.31,52.5,50.0,46.72,45.5,43.75,43.19,43.44,43.47,42.62,44.81,44.0,44.31,46.94,47.41,48.59,46.41,50.06,49.22,49.12,49.16,47.69,45.78,41.75,39.69,36.12,35.0,33.19,-9.56,-8.34,-8.03,-6.53,-4.69,-2.91,-2.0,1.44,2.91,5.19,6.81,9.09,9.78,9.56,10.03,8.94,8.97,8.84,7.84,8.81,8.88,8.41,8.0,7.91:33.81,37.03,38.66,40.84,40.5,42.0,42.81,41.62,42.19,41.25,40.38,39.78,39.5,39.38,38.69,38.56,36.25,36.06,34.12,33.44,33.09,33.56,33.53,33.16,32.81,32.06,33.84,35.28,37.41,39.97,43.75,44.5,44.34,44.0,42.44,38.25,35.41,32.84,28.78,22.69,21.56,16.69,13.44,12.0,10.38,8.94,8.5,9.91,11.94,14.59,17.41,20.38,23.66,24.25,29.56,31.72,35.69,38.62,41.66,44.44,44.62,44.66,43.62,42.72,39.84,37.72,37.81,36.41,38.19,39.56,40.62,43.12,43.75,45.25,45.19,45.0,43.75,42.38,38.19,39.0,38.28,39.62,42.16,44.5,43.81,40.78,40.16,37.12,35.19,35.62,34.12,33.0,31.16,29.34,28.75,28.5,29.88,31.53,32.0,35.69,37.81,39.88,43.56,46.28,50.19,53.0,54.81,57.59,58.25,61.41,62.5,63.22,63.72,61.62,59.25,55.44,50.44,46.41,43.81,39.19,36.28,34.91,34.31,33.94,36.75,39.94,43.62,45.53,46.09,48.38,47.72,46.06,43.44,44.88,43.0,44.53,46.22,47.41,49.31,49.09,48.56,44.94,46.22,42.56,42.5,42.53,43.44,44.19,44.81,46.38,45.94,45.12,42.5,40.56,35.12,37.66,36.94,38.62,42.19,45.16,48.28,50.0,51.38,52.94,52.5,49.06,47.94,44.5,39.69,36.16,33.94,31.38,30.56,30.91,32.44,31.44,36.09,37.25,39.31,43.38,45.53,46.84,47.88,47.91,48.03,45.38,46.84,45.47,43.5,43.31,41.06,38.59,36.38,34.56,33.25,34.0,34.16,34.44,38.06,38.28,40.88,44.34,46.53,48.94,51.72,51.25,55.28,56.28,56.44,58.22,58.12,57.41,55.12,53.81,52.31,50.06,49.03,47.19,48.31,48.31,49.78,53.12,57.19,60.22,61.81,63.41,63.03,60.91,59.31,54.53,53.69,52.66,51.06,52.44,54.31,54.41,55.44,56.03,54.31,57.34,56.31,58.28,58.91,60.0,59.56,59.03,57.97,58.31,55.94,58.66,58.31,57.84,56.97,55.47,52.28,49.38,44.53,46.19,45.78,47.94,50.59,52.06,52.5,53.0,52.62,52.38,52.94,51.84,50.81,53.03,52.91,56.09,59.16,61.31,61.5,61.62,59.78,59.53,59.88,58.66,62.53,62.91,64.44,65.94,66.09,64.78,61.59,59.38,58.25,55.47,52.53,55.12,54.91,57.19,59.62,63.94,67.06,67.78,68.41,68.5,66.62,63.25,60.12,60.44,58.03,59.88,62.06,62.31,63.69,63.81,62.81,62.03,58.81,60.47,60.12,60.88,61.53,63.56,62.66,63.72,64.19,64.16,63.5,63.59,61.78,60.62,58.56,57.0,54.94,51.84,53.47,52.28,51.81,52.41,52.88,51.97,51.56,51.34,52.12,54.06,56.81,59.31,60.88,60.94,60.94,60.28,59.5,58.62,59.31,58.41,57.06,54.91,53.44,51.81,50.38,50.31,46.53,48.81,46.72,45.81,46.44,47.12,47.31,47.53,47.66,49.56,50.62,52.69,53.28,52.81,52.75,50.31,47.31,45.06,42.31,41.41,40.38,40.06,41.56,42.78,45.84,50.0,52.91,54.16,58.19,57.78,57.78,57.38,56.72,56.06,54.97,54.91,54.0,54.5,53.16,51.81,49.38,47.06,43.25,40.44,37.12,34.44,33.59,30.91,31.59,33.31,34.28,37.75,41.53,44.62,47.16,48.22,47.66,50.25,50.31,49.94,50.69,50.75,49.25,46.56,44.69,40.56,36.84,35.72,33.38,31.81,33.09,34.03,33.72,34.69,36.66,38.03,39.69,40.72,40.81,42.81,41.59,43.41,43.84,45.03,44.75,42.28,44.44,43.03,43.66,45.56,46.41,47.0,47.62,47.22,47.56,45.62,44.75,45.31,44.88,45.69,46.88,46.72,46.62,45.19,41.19,41.22,39.91,39.16,41.16,42.78,44.38,45.28,45.78,45.31,43.03,42.72,40.81,42.47,43.97,45.41,49.25,52.31,54.56,54.41,56.09,52.91,55.44,54.12,54.81,57.12,58.16,58.5,58.62,59.38,58.34,58.03,57.91,55.66,52.88,51.12,48.41,46.47,45.75,44.66,43.44,41.88,40.16,39.69,39.59,37.97,40.06,41.47,42.56,45.25,46.91,46.75,47.12,45.66,41.84,44.62,42.5,44.0,45.62,46.53,47.69,46.28,45.66,41.88,40.31,37.03,34.56,35.03,35.25,37.31,38.72,39.81,40.38,40.16,40.12,36.38,39.69,38.31,40.28,43.41,45.94,48.53,48.16,49.22,47.62,44.0,44.41,41.84,40.34,39.44,39.53,38.56,37.41,35.94,33.47,35.66,33.84,34.16,34.41,34.19,33.53,33.16,34.56,34.78,39.91,42.19,45.31,48.25,49.19,48.88,48.16,45.19,43.72,41.31,38.0,37.94,37.66,35.81,37.72,38.53,39.34,40.41,42.0,43.25,43.81,45.06,45.38,43.75,46.91,47.62,50.69,54.28,56.06,57.31,57.41,56.91,56.53,53.06,52.44,49.47,45.72,44.28,42.66,42.88,42.25,43.94,46.38,48.78,50.59,52.28,51.84,48.66,49.56,47.59,46.78,48.44,49.34,50.16,48.97,48.44,48.34,43.91,46.84,44.88,44.69,45.06,45.34,43.88,42.06,39.66,37.5,36.22,35.69,34.47,37.19,39.81,42.66,46.84,49.97,51.66,52.16,51.53,46.06,47.69,44.25,43.03,44.12,44.06,44.0,44.66,45.47,46.19,46.06,46.81,46.56,45.66,42.34,45.16,43.41,44.41,46.44,46.88,48.66,49.81,50.25,50.84,49.12,52.78,51.97,53.78,55.0,54.62,54.72,51.53,48.97,47.03,43.0,41.84,40.75,37.34,37.81,37.34,37.47,39.34,41.78,42.41,43.19,43.41,42.25,42.81,41.53,39.94,40.34,39.81,39.16,38.88,39.16,37.66,38.41,37.34,38.0,39.25,40.75,40.19,44.31,44.38,44.88,46.81,46.62,47.81,47.88,46.66,47.72,47.5,46.31,46.62,46.56,45.75,45.12,42.19,43.66,41.69,40.78,40.59,41.16,41.31,40.84,43.06,44.28,44.94,46.5,46.69,47.38,48.12,45.75,49.94,48.03,47.78,47.81,45.75,43.66,41.16,38.56,34.38,32.72,30.91,29.09,30.34,32.0,33.16,35.38,36.84,37.94,38.09,39.28,40.5,40.0,41.25,43.62,44.81,47.12,48.0,50.22,50.38,50.38,51.0,50.59,49.91,49.0,48.06,46.03,46.59,46.06,46.81,48.56,49.78,50.12,49.84,49.38,48.75,48.78,48.28,50.09,51.69,52.03,54.03,54.31,53.25,52.47,51.44,51.28,51.88,52.81,53.47,53.75,55.66,54.81,55.03,52.94,50.78,47.81,45.41,43.53,41.94,42.34,43.34,43.75,42.12,46.19,44.88,44.09,44.78,43.31,41.81,41.28,40.5,41.16,42.03,44.66,45.84,47.5,49.44,48.78,46.5,43.91,40.5,37.41,33.62,32.41,32.47,29.06,34.25,36.12,39.81,45.03,48.47,52.56,53.91,53.31,52.5,50.0,46.72,45.5,43.75,43.19,43.44,43.47,42.62,44.81,44.0,44.31,46.94,47.41,48.59,46.41,50.06,49.22,49.12,49.16,47.69,45.78,41.75,39.69,36.12,35.0,33.19,-9.56,-8.34,-8.03,-6.53,-4.69,-2.91,-2.0,1.44,2.91,5.19,6.81,9.09,9.78,9.56,10.03,8.94,8.97,8.84,7.84,8.81,8.88,8.41,8.0,7.91,6.09,5.19,4.5,3.31,2.78,3.16:negativity
70.81,70.94,70.03,68.41,66.66,65.41,65.62,66.44,68.44,71.06,73.12,73.94,74.62,72.66,71.25,68.56,66.44,64.25,64.06,62.5,65.38,65.94,67.75,69.56,69.56,69.62,69.06,67.62,65.88,65.09,64.06,64.94,65.31,67.66,69.06,70.19,70.94,72.34,71.12,73.0,73.41,73.28,71.25,70.25,66.5,64.16,63.5,63.28,66.0,68.84,72.94,78.0,81.38,84.81,88.38,89.88,92.31,92.88,91.69,89.69,87.25,81.16,77.25,73.5,70.69,67.31,66.0,66.0,65.19,64.75,65.56,64.78,63.66,63.16,62.38,62.0,61.5,62.41,62.62,62.56,64.44,66.0,66.44,68.12,67.91,68.81,68.19,68.19,66.75,65.06,64.28,63.28,62.94,64.5,66.81,69.62,72.69,75.19,77.56,77.75,77.88,76.62,74.81,73.56,71.66,69.69,67.31,63.44,60.88,58.06,55.81,54.91,55.25,55.31,57.06,59.31,61.31,64.81,69.19,72.19,74.81,76.38,75.75,73.81,70.5,67.19,65.56,63.41,62.88,63.06,62.62,62.53,64.88,65.94,68.06,70.41,71.62,70.81,70.84,68.34,67.31,66.84,67.94,68.94,71.25,71.75,72.38,72.12,72.0,71.75,73.19,73.38,73.69,72.75,71.47,70.0,68.66,67.56,65.75,64.62,64.56,63.56,65.44,66.75,69.44,72.0,73.62,74.62,76.0,76.88,75.88,76.0,74.81,73.06,71.38,68.94,66.56,65.94,64.62,64.0,65.25,65.25,65.5,65.88,65.88,66.56,65.75,67.31,68.19,67.25,67.69,65.44,63.34,61.91,59.75,59.62,57.56,59.31,58.53,58.25,60.25,61.19,61.75,63.91,64.44,65.62,65.25,64.56,64.28,61.38,61.62,60.31,59.38,59.62,61.34,63.19,65.5,67.06,68.88,70.81,70.25,70.31,70.31,68.81,66.44,65.25,62.81,60.41,57.56,56.19,54.34,52.25,52.5,53.19,54.62,56.06,57.5,58.06,58.06,57.44,56.25,56.12,54.47,53.44,52.25,50.94,49.25,48.12,48.94,48.94,50.38,51.53,52.94,53.19,54.5,54.41,55.25,56.41,56.22,56.31,55.94,54.69,53.25,50.94,50.0,48.69,48.0,47.88,47.0,48.25,49.12,50.16,51.12,52.41,53.38,53.75,54.12,54.44,54.19,54.69,55.0,56.34,56.81,57.81,60.81,59.81,61.06,62.41,62.06,62.97,62.25,63.16,62.69,63.31,64.72,65.31,66.62,67.06,67.31,67.31,66.19,65.75,65.81,65.38,66.69,67.06,68.75,69.94,69.38,69.0,68.88,67.12,65.81,65.44,62.59,60.12,59.12,57.62,56.12,55.44,54.38,53.41,51.38,49.38,49.47,48.88,50.06,49.53,51.44,52.69,53.81,56.31,58.66,60.5,61.62,62.38,61.19,60.88,59.25,58.75,57.69,56.31,54.84,53.25,52.12,52.62,52.56,53.75,55.81,55.5,56.81,56.5,56.34,55.88,56.0,57.69,58.66,60.62,63.44,64.25,65.66,66.25,67.06,67.62,67.38,67.69,68.19,68.5,68.31,66.88,65.88,65.06,64.62,65.12,67.0,67.75,67.62,66.12,65.88,63.25,63.62,63.56,64.19,65.62,68.19,70.44,71.59,73.81,75.12,76.62,77.94,79.06,79.12,79.44,78.0,78.78,77.72,78.12,78.47,78.5,78.69,78.62,77.38,76.56,75.69,74.62,72.91,73.38,72.62,72.81,73.12,73.94,73.31,73.53,72.12,71.44,70.44,72.0,72.88,74.75,76.06,76.0,76.12,74.16,72.56,71.25,69.59,66.62,66.94,66.5,67.16,69.19,70.81,72.38,72.91,73.81,73.56,73.38,73.44,73.88,72.25,71.81,71.94,70.88,69.5,69.25,67.75,67.44,69.19,70.53,71.47,73.5,73.31,72.47,71.38,70.31,68.0,67.97,66.0,66.62,67.19,68.81,69.44,71.78,74.81,74.25,75.62,77.31,76.88,77.0,75.44,75.41,76.12,75.62,77.75,77.75,78.03,79.97,79.12,79.88,81.34,81.75,82.25,81.84,81.81,81.72,80.69,80.72,80.25,79.75,79.56,79.38,78.31,76.78,76.12,75.66,75.62,76.25,79.31,80.19,80.0,80.31,78.69,76.62,73.88,73.44,70.56,69.12,68.62,67.47,67.75,67.66,67.28,68.31,68.06,67.75,67.91,66.75,68.31,68.12,68.88,68.31,68.56,64.5,64.72,62.56,62.69,64.81,66.0,66.88,67.62,68.31,67.69,67.25,66.25,64.16,62.56,60.88,59.12,60.19,62.31,65.56,69.56,71.81,73.94,73.47,72.38,70.38,66.69,63.94,61.56,58.91,57.25,55.91,54.66,54.44,53.5,54.62,54.94,54.97,56.69,56.88,56.94,56.94,57.75,58.38,58.75,60.78,61.44,62.78,63.41,63.19,63.12,60.75,60.5,59.75,59.0,58.56,59.88,59.19,60.0,60.97,61.12,61.31,62.19,61.41,61.06,60.62,60.56,59.31,59.53,58.62,57.0,55.62,54.38,53.62,52.06,53.66,53.94,55.38,57.25,57.56,58.44,56.69,57.41,56.25,56.31,57.5,57.78,58.25,59.12,60.56,59.81,62.94,64.06,65.31,66.28,66.12,64.75,62.38,60.56,58.94,58.94,60.88,62.88,64.91,65.19,65.31,63.69,62.44,60.75,57.94,57.81,56.12,55.03,55.25,54.81,54.25,52.56,53.69,53.78,54.25,57.69,58.75,60.31,60.34,59.75,59.47,57.91,57.25,56.81,56.03,54.44,54.0,54.34,54.0,54.81,56.44,56.0,55.75,54.81,54.12,52.94,52.62,53.06,54.0,54.06,54.56,53.62,53.75,52.12,51.19,52.19,51.03,51.91,51.66,52.5,51.38,52.31,53.75,54.56,55.69,56.94,56.62,57.03,57.75,58.25,58.81,59.12,58.81,57.66,56.94,57.06,55.66,57.0,56.12,57.91,58.12,58.5,57.25,56.75,56.38,55.31,56.03,59.12,60.0,61.0,62.88,61.94,60.03,60.22,58.62,58.5,58.38,58.69,59.44,59.0,59.97,60.5,61.19,63.19,64.12,66.06,68.19,69.59,69.5,69.47,69.19,69.19,69.06,70.31,71.56,71.97,70.56,70.75,69.78,69.44,70.56,71.81,71.59,71.44,70.62,70.31,70.69,71.44,73.47,74.06,74.91,75.31,74.06,73.12,72.22,70.81,69.12,69.12,68.31,67.88,69.0,69.81,70.19,68.62,68.81,66.06,62.88,60.91,59.19,58.75,56.72,56.75,56.94,55.88,55.62,56.75,57.91,58.91,59.81,59.0,59.69,59.12,58.56,59.12,59.66,60.31,60.69,60.56,61.66,59.19,59.88,56.81,55.81,54.97,55.06,55.81,56.03,56.75,56.59,56.22,57.31,57.44,58.38,59.12,60.5,61.06,62.69,63.44,64.62,65.88,65.38,66.19,65.12,66.5,65.69,65.88,66.44,64.69,65.66,64.19,64.97,66.0,66.56,67.62,68.03,67.62,66.38,65.62,63.88,62.72,60.81,59.69,58.94,56.62,55.06,53.94,54.41,54.38,55.0,55.28,55.38,55.88,56.25,56.62,59.81,61.5,63.5,64.62,66.0,66.56,67.03,67.81,67.94,67.31,67.5,67.5,66.19,65.34,65.75,64.19,63.94,63.69,64.69,64.88,65.5,64.5,62.81,60.25,57.56,55.41,53.94,54.12,53.59,54.38,54.53,54.06,54.72,54.31,53.69,54.19,53.97,54.19,53.75,53.25,54.62,53.25,53.78,53.72,53.5,54.06,53.06,52.75,53.25,51.94,51.81,49.88,48.88,45.81,42.94:65.62,66.44,68.44,71.06,73.12,73.94,74.62,72.66,71.25,68.56,66.44,64.25,64.06,62.5,65.38,65.94,67.75,69.56,69.56,69.62,69.06,67.62,65.88,65.09,64.06,64.94,65.31,67.66,69.06,70.19,70.94,72.34,71.12,73.0,73.41,73.28,71.25,70.25,66.5,64.16,63.5,63.28,66.0,68.84,72.94,78.0,81.38,84.81,88.38,89.88,92.31,92.88,91.69,89.69,87.25,81.16,77.25,73.5,70.69,67.31,66.0,66.0,65.19,64.75,65.56,64.78,63.66,63.16,62.38,62.0,61.5,62.41,62.62,62.56,64.44,66.0,66.44,68.12,67.91,68.81,68.19,68.19,66.75,65.06,64.28,63.28,62.94,64.5,66.81,69.62,72.69,75.19,77.56,77.75,77.88,76.62,74.81,73.56,71.66,69.69,67.31,63.44,60.88,58.06,55.81,54.91,55.25,55.31,57.06,59.31,61.31,64.81,69.19,72.19,74.81,76.38,75.75,73.81,70.5,67.19,65.56,63.41,62.88,63.06,62.62,62.53,64.88,65.94,68.06,70.41,71.62,70.81,70.84,68.34,67.31,66.84,67.94,68.94,71.25,71.75,72.38,72.12,72.0,71.75,73.19,73.38,73.69,72.75,71.47,70.0,68.66,67.56,65.75,64.62,64.56,63.56,65.44,66.75,69.44,72.0,73.62,74.62,76.0,76.88,75.88,76.0,74.81,73.06,71.38,68.94,66.56,65.94,64.62,64.0,65.25,65.25,65.5,65.88,65.88,66.56,65.75,67.31,68.19,67.25,67.69,65.44,63.34,61.91,59.75,59.62,57.56,59.31,58.53,58.25,60.25,61.19,61.75,63.91,64.44,65.62,65.25,64.56,64.28,61.38,61.62,60.31,59.38,59.62,61.34,63.19,65.5,67.06,68.88,70.81,70.25,70.31,70.31,68.81,66.44,65.25,62.81,60.41,57.56,56.19,54.34,52.25,52.5,53.19,54.62,56.06,57.5,58.06,58.06,57.44,56.25,56.12,54.47,53.44,52.25,50.94,49.25,48.12,48.94,48.94,50.38,51.53,52.94,53.19,54.5,54.41,55.25,56.41,56.22,56.31,55.94,54.69,53.25,50.94,50.0,48.69,48.0,47.88,47.0,48.25,49.12,50.16,51.12,52.41,53.38,53.75,54.12,54.44,54.19,54.69,55.0,56.34,56.81,57.81,60.81,59.81,61.06,62.41,62.06,62.97,62.25,63.16,62.69,63.31,64.72,65.31,66.62,67.06,67.31,67.31,66.19,65.75,65.81,65.38,66.69,67.06,68.75,69.94,69.38,69.0,68.88,67.12,65.81,65.44,62.59,60.12,59.12,57.62,56.12,55.44,54.38,53.41,51.38,49.38,49.47,48.88,50.06,49.53,51.44,52.69,53.81,56.31,58.66,60.5,61.62,62.38,61.19,60.88,59.25,58.75,57.69,56.31,54.84,53.25,52.12,52.62,52.56,53.75,55.81,55.5,56.81,56.5,56.34,55.88,56.0,57.69,58.66,60.62,63.44,64.25,65.66,66.25,67.06,67.62,67.38,67.69,68.19,68.5,68.31,66.88,65.88,65.06,64.62,65.12,67.0,67.75,67.62,66.12,65.88,63.25,63.62,63.56,64.19,65.62,68.19,70.44,71.59,73.81,75.12,76.62,77.94,79.06,79.12,79.44,78.0,78.78,77.72,78.12,78.47,78.5,78.69,78.62,77.38,76.56,75.69,74.62,72.91,73.38,72.62,72.81,73.12,73.94,73.31,73.53,72.12,71.44,70.44,72.0,72.88,74.75,76.06,76.0,76.12,74.16,72.56,71.25,69.59,66.62,66.94,66.5,67.16,69.19,70.81,72.38,72.91,73.81,73.56,73.38,73.44,73.88,72.25,71.81,71.94,70.88,69.5,69.25,67.75,67.44,69.19,70.53,71.47,73.5,73.31,72.47,71.38,70.31,68.0,67.97,66.0,66.62,67.19,68.81,69.44,71.78,74.81,74.25,75.62,77.31,76.88,77.0,75.44,75.41,76.12,75.62,77.75,77.75,78.03,79.97,79.12,79.88,81.34,81.75,82.25,81.84,81.81,81.72,80.69,80.72,80.25,79.75,79.56,79.38,78.31,76.78,76.12,75.66,75.62,76.25,79.31,80.19,80.0,80.31,78.69,76.62,73.88,73.44,70.56,69.12,68.62,67.47,67.75,67.66,67.28,68.31,68.06,67.75,67.91,66.75,68.31,68.12,68.88,68.31,68.56,64.5,64.72,62.56,62.69,64.81,66.0,66.88,67.62,68.31,67.69,67.25,66.25,64.16,62.56,60.88,59.12,60.19,62.31,65.56,69.56,71.81,73.94,73.47,72.38,70.38,66.69,63.94,61.56,58.91,57.25,55.91,54.66,54.44,53.5,54.62,54.94,54.97,56.69,56.88,56.94,56.94,57.75,58.38,58.75,60.78,61.44,62.78,63.41,63.19,63.12,60.75,60.5,59.75,59.0,58.56,59.88,59.19,60.0,60.97,61.12,61.31,62.19,61.41,61.06,60.62,60.56,59.31,59.53,58.62,57.0,55.62,54.38,53.62,52.06,53.66,53.94,55.38,57.25,57.56,58.44,56.69,57.41,56.25,56.31,57.5,57.78,58.25,59.12,60.56,59.81,62.94,64.06,65.31,66.28,66.12,64.75,62.38,60.56,58.94,58.94,60.88,62.88,64.91,65.19,65.31,63.69,62.44,60.75,57.94,57.81,56.12,55.03,55.25,54.81,54.25,52.56,53.69,53.78,54.25,57.69,58.75,60.31,60.34,59.75,59.47,57.91,57.25,56.81,56.03,54.44,54.0,54.34,54.0,54.81,56.44,56.0,55.75,54.81,54.12,52.94,52.62,53.06,54.0,54.06,54.56,53.62,53.75,52.12,51.19,52.19,51.03,51.91,51.66,52.5,51.38,52.31,53.75,54.56,55.69,56.94,56.62,57.03,57.75,58.25,58.81,59.12,58.81,57.66,56.94,57.06,55.66,57.0,56.12,57.91,58.12,58.5,57.25,56.75,56.38,55.31,56.03,59.12,60.0,61.0,62.88,61.94,60.03,60.22,58.62,58.5,58.38,58.69,59.44,59.0,59.97,60.5,61.19,63.19,64.12,66.06,68.19,69.59,69.5,69.47,69.19,69.19,69.06,70.31,71.56,71.97,70.56,70.75,69.78,69.44,70.56,71.81,71.59,71.44,70.62,70.31,70.69,71.44,73.47,74.06,74.91,75.31,74.06,73.12,72.22,70.81,69.12,69.12,68.31,67.88,69.0,69.81,70.19,68.62,68.81,66.06,62.88,60.91,59.19,58.75,56.72,56.75,56.94,55.88,55.62,56.75,57.91,58.91,59.81,59.0,59.69,59.12,58.56,59.12,59.66,60.31,60.69,60.56,61.66,59.19,59.88,56.81,55.81,54.97,55.06,55.81,56.03,56.75,56.59,56.22,57.31,57.44,58.38,59.12,60.5,61.06,62.69,63.44,64.62,65.88,65.38,66.19,65.12,66.5,65.69,65.88,66.44,64.69,65.66,64.19,64.97,66.0,66.56,67.62,68.03,67.62,66.38,65.62,63.88,62.72,60.81,59.69,58.94,56.62,55.06,53.94,54.41,54.38,55.0,55.28,55.38,55.88,56.25,56.62,59.81,61.5,63.5,64.62,66.0,66.56,67.03,67.81,67.94,67.31,67.5,67.5,66.19,65.34,65.75,64.19,63.94,63.69,64.69,64.88,65.5,64.5,62.81,60.25,57.56,55.41,53.94,54.12,53.59,54.38,54.53,54.06,54.72,54.31,53.69,54.19,53.97,54.19,53.75,53.25,54.62,53.25,53.78,53.72,53.5,54.06,53.06,52.75,53.25,51.94,51.81,49.88,48.88,45.81,42.94,32.31,30.94,28.5,26.5,23.84,21.72:74.62,72.66,71.25,68.56,66.44,64.25,64.06,62.5,65.38,65.94,67.75,69.56,69.56,69.62,69.06,67.62,65.88,65.09,64.06,64.94,65.31,67.66,69.06,70.19,70.94,72.34,71.12,73.0,73.41,73.28,71.25,70.25,66.5,64.16,63.5,63.28,66.0,68.84,72.94,78.0,81.38,84.81,88.38,89.88,92.31,92.88,91.69,89.69,87.25,81.16,77.25,73.5,70.69,67.31,66.0,66.0,65.19,64.75,65.56,64.78,63.66,63.16,62.38,62.0,61.5,62.41,62.62,62.56,64.44,66.0,66.44,68.12,67.91,68.81,68.19,68.19,66.75,65.06,64.28,63.28,62.94,64.5,66.81,69.62,72.69,75.19,77.56,77.75,77.88,76.62,74.81,73.56,71.66,69.69,67.31,63.44,60.88,58.06,55.81,54.91,55.25,55.31,57.06,59.31,61.31,64.81,69.19,72.19,74.81,76.38,75.75,73.81,70.5,67.19,65.56,63.41,62.88,63.06,62.62,62.53,64.88,65.94,68.06,70.41,71.62,70.81,70.84,68.34,67.31,66.84,67.94,68.94,71.25,71.75,72.38,72.12,72.0,71.75,73.19,73.38,73.69,72.75,71.47,70.0,68.66,67.56,65.75,64.62,64.56,63.56,65.44,66.75,69.44,72.0,73.62,74.62,76.0,76.88,75.88,76.0,74.81,73.06,71.38,68.94,66.56,65.94,64.62,64.0,65.25,65.25,65.5,65.88,65.88,66.56,65.75,67.31,68.19,67.25,67.69,65.44,63.34,61.91,59.75,59.62,57.56,59.31,58.53,58.25,60.25,61.19,61.75,63.91,64.44,65.62,65.25,64.56,64.28,61.38,61.62,60.31,59.38,59.62,61.34,63.19,65.5,67.06,68.88,70.81,70.25,70.31,70.31,68.81,66.44,65.25,62.81,60.41,57.56,56.19,54.34,52.25,52.5,53.19,54.62,56.06,57.5,58.06,58.06,57.44,56.25,56.12,54.47,53.44,52.25,50.94,49.25,48.12,48.94,48.94,50.38,51.53,52.94,53.19,54.5,54.41,55.25,56.41,56.22,56.31,55.94,54.69,53.25,50.94,50.0,48.69,48.0,47.88,47.0,48.25,49.12,50.16,51.12,52.41,53.38,53.75,54.12,54.44,54.19,54.69,55.0,56.34,56.81,57.81,60.81,59.81,61.06,62.41,62.06,62.97,62.25,63.16,62.69,63.31,64.72,65.31,66.62,67.06,67.31,67.31,66.19,65.75,65.81,65.38,66.69,67.06,68.75,69.94,69.38,69.0,68.88,67.12,65.81,65.44,62.59,60.12,59.12,57.62,56.12,55.44,54.38,53.41,51.38,49.38,49.47,48.88,50.06,49.53,51.44,52.69,53.81,56.31,58.66,60.5,61.62,62.38,61.19,60.88,59.25,58.75,57.69,56.31,54.84,53.25,52.12,52.62,52.56,53.75,55.81,55.5,56.81,56.5,56.34,55.88,56.0,57.69,58.66,60.62,63.44,64.25,65.66,66.25,67.06,67.62,67.38,67.69,68.19,68.5,68.31,66.88,65.88,65.06,64.62,65.12,67.0,67.75,67.62,66.12,65.88,63.25,63.62,63.56,64.19,65.62,68.19,70.44,71.59,73.81,75.12,76.62,77.94,79.06,79.12,79.44,78.0,78.78,77.72,78.12,78.47,78.5,78.69,78.62,77.38,76.56,75.69,74.62,72.91,73.38,72.62,72.81,73.12,73.94,73.31,73.53,72.12,71.44,70.44,72.0,72.88,74.75,76.06,76.0,76.12,74.16,72.56,71.25,69.59,66.62,66.94,66.5,67.16,69.19,70.81,72.38,72.91,73.81,73.56,73.38,73.44,73.88,72.25,71.81,71.94,70.88,69.5,69.25,67.75,67.44,69.19,70.53,71.47,73.5,73.31,72.47,71.38,70.31,68.0,67.97,66.0,66.62,67.19,68.81,69.44,71.78,74.81,74.25,75.62,77.31,76.88,77.0,75.44,75.41,76.12,75.62,77.75,77.75,78.03,79.97,79.12,79.88,81.34,81.75,82.25,81.84,81.81,81.72,80.69,80.72,80.25,79.75,79.56,79.38,78.31,76.78,76.12,75.66,75.62,76.25,79.31,80.19,80.0,80.31,78.69,76.62,73.88,73.44,70.56,69.12,68.62,67.47,67.75,67.66,67.28,68.31,68.06,67.75,67.91,66.75,68.31,68.12,68.88,68.31,68.56,64.5,64.72,62.56,62.69,64.81,66.0,66.88,67.62,68.31,67.69,67.25,66.25,64.16,62.56,60.88,59.12,60.19,62.31,65.56,69.56,71.81,73.94,73.47,72.38,70.38,66.69,63.94,61.56,58.91,57.25,55.91,54.66,54.44,53.5,54.62,54.94,54.97,56.69,56.88,56.94,56.94,57.75,58.38,58.75,60.78,61.44,62.78,63.41,63.19,63.12,60.75,60.5,59.75,59.0,58.56,59.88,59.19,60.0,60.97,61.12,61.31,62.19,61.41,61.06,60.62,60.56,59.31,59.53,58.62,57.0,55.62,54.38,53.62,52.06,53.66,53.94,55.38,57.25,57.56,58.44,56.69,57.41,56.25,56.31,57.5,57.78,58.25,59.12,60.56,59.81,62.94,64.06,65.31,66.28,66.12,64.75,62.38,60.56,58.94,58.94,60.88,62.88,64.91,65.19,65.31,63.69,62.44,60.75,57.94,57.81,56.12,55.03,55.25,54.81,54.25,52.56,53.69,53.78,54.25,57.69,58.75,60.31,60.34,59.75,59.47,57.91,57.25,56.81,56.03,54.44,54.0,54.34,54.0,54.81,56.44,56.0,55.75,54.81,54.12,52.94,52.62,53.06,54.0,54.06,54.56,53.62,53.75,52.12,51.19,52.19,51.03,51.91,51.66,52.5,51.38,52.31,53.75,54.56,55.69,56.94,56.62,57.03,57.75,58.25,58.81,59.12,58.81,57.66,56.94,57.06,55.66,57.0,56.12,57.91,58.12,58.5,57.25,56.75,56.38,55.31,56.03,59.12,60.0,61.0,62.88,61.94,60.03,60.22,58.62,58.5,58.38,58.69,59.44,59.0,59.97,60.5,61.19,63.19,64.12,66.06,68.19,69.59,69.5,69.47,69.19,69.19,69.06,70.31,71.56,71.97,70.56,70.75,69.78,69.44,70.56,71.81,71.59,71.44,70.62,70.31,70.69,71.44,73.47,74.06,74.91,75.31,74.06,73.12,72.22,70.81,69.12,69.12,68.31,67.88,69.0,69.81,70.19,68.62,68.81,66.06,62.88,60.91,59.19,58.75,56.72,56.75,56.94,55.88,55.62,56.75,57.91,58.91,59.81,59.0,59.69,59.12,58.56,59.12,59.66,60.31,60.69,60.56,61.66,59.19,59.88,56.81,55.81,54.97,55.06,55.81,56.03,56.75,56.59,56.22,57.31,57.44,58.38,59.12,60.5,61.06,62.69,63.44,64.62,65.88,65.38,66.19,65.12,66.5,65.69,65.88,66.44,64.69,65.66,64.19,64.97,66.0,66.56,67.62,68.03,67.62,66.38,65.62,63.88,62.72,60.81,59.69,58.94,56.62,55.06,53.94,54.41,54.38,55.0,55.28,55.38,55.88,56.25,56.62,59.81,61.5,63.5,64.62,66.0,66.56,67.03,67.81,67.94,67.31,67.5,67.5,66.19,65.34,65.75,64.19,63.94,63.69,64.69,64.88,65.5,64.5,62.81,60.25,57.56,55.41,53.94,54.12,53.59,54.38,54.53,54.06,54.72,54.31,53.69,54.19,53.97,54.19,53.75,53.25,54.62,53.25,53.78,53.72,53.5,54.06,53.06,52.75,53.25,51.94,51.81,49.88,48.88,45.81,42.94,32.31,30.94,28.5,26.5,23.84,21.72,22.31,24.25,27.0,29.66,33.09,35.09:64.06,62.5,65.38,65.94,67.75,69.56,69.56,69.62,69.06,67.62,65.88,65.09,64.06,64.94,65.31,67.66,69.06,70.19,70.94,72.34,71.12,73.0,73.41,73.28,71.25,70.25,66.5,64.16,63.5,63.28,66.0,68.84,72.94,78.0,81.38,84.81,88.38,89.88,92.31,92.88,91.69,89.69,87.25,81.16,77.25,73.5,70.69,67.31,66.0,66.0,65.19,64.75,65.56,64.78,63.66,63.16,62.38,62.0,61.5,62.41,62.62,62.56,64.44,66.0,66.44,68.12,67.91,68.81,68.19,68.19,66.75,65.06,64.28,63.28,62.94,64.5,66.81,69.62,72.69,75.19,77.56,77.75,77.88,76.62,74.81,73.56,71.66,69.69,67.31,63.44,60.88,58.06,55.81,54.91,55.25,55.31,57.06,59.31,61.31,64.81,69.19,72.19,74.81,76.38,75.75,73.81,70.5,67.19,65.56,63.41,62.88,63.06,62.62,62.53,64.88,65.94,68.06,70.41,71.62,70.81,70.84,68.34,67.31,66.84,67.94,68.94,71.25,71.75,72.38,72.12,72.0,71.75,73.19,73.38,73.69,72.75,71.47,70.0,68.66,67.56,65.75,64.62,64.56,63.56,65.44,66.75,69.44,72.0,73.62,74.62,76.0,76.88,75.88,76.0,74.81,73.06,71.38,68.94,66.56,65.94,64.62,64.0,65.25,65.25,65.5,65.88,65.88,66.56,65.75,67.31,68.19,67.25,67.69,65.44,63.34,61.91,59.75,59.62,57.56,59.31,58.53,58.25,60.25,61.19,61.75,63.91,64.44,65.62,65.25,64.56,64.28,61.38,61.62,60.31,59.38,59.62,61.34,63.19,65.5,67.06,68.88,70.81,70.25,70.31,70.31,68.81,66.44,65.25,62.81,60.41,57.56,56.19,54.34,52.25,52.5,53.19,54.62,56.06,57.5,58.06,58.06,57.44,56.25,56.12,54.47,53.44,52.25,50.94,49.25,48.12,48.94,48.94,50.38,51.53,52.94,53.19,54.5,54.41,55.25,56.41,56.22,56.31,55.94,54.69,53.25,50.94,50.0,48.69,48.0,47.88,47.0,48.25,49.12,50.16,51.12,52.41,53.38,53.75,54.12,54.44,54.19,54.69,55.0,56.34,56.81,57.81,60.81,59.81,61.06,62.41,62.06,62.97,62.25,63.16,62.69,63.31,64.72,65.31,66.62,67.06,67.31,67.31,66.19,65.75,65.81,65.38,66.69,67.06,68.75,69.94,69.38,69.0,68.88,67.12,65.81,65.44,62.59,60.12,59.12,57.62,56.12,55.44,54.38,53.41,51.38,49.38,49.47,48.88,50.06,49.53,51.44,52.69,53.81,56.31,58.66,60.5,61.62,62.38,61.19,60.88,59.25,58.75,57.69,56.31,54.84,53.25,52.12,52.62,52.56,53.75,55.81,55.5,56.81,56.5,56.34,55.88,56.0,57.69,58.66,60.62,63.44,64.25,65.66,66.25,67.06,67.62,67.38,67.69,68.19,68.5,68.31,66.88,65.88,65.06,64.62,65.12,67.0,67.75,67.62,66.12,65.88,63.25,63.62,63.56,64.19,65.62,68.19,70.44,71.59,73.81,75.12,76.62,77.94,79.06,79.12,79.44,78.0,78.78,77.72,78.12,78.47,78.5,78.69,78.62,77.38,76.56,75.69,74.62,72.91,73.38,72.62,72.81,73.12,73.94,73.31,73.53,72.12,71.44,70.44,72.0,72.88,74.75,76.06,76.0,76.12,74.16,72.56,71.25,69.59,66.62,66.94,66.5,67.16,69.19,70.81,72.38,72.91,73.81,73.56,73.38,73.44,73.88,72.25,71.81,71.94,70.88,69.5,69.25,67.75,67.44,69.19,70.53,71.47,73.5,73.31,72.47,71.38,70.31,68.0,67.97,66.0,66.62,67.19,68.81,69.44,71.78,74.81,74.25,75.62,77.31,76.88,77.0,75.44,75.41,76.12,75.62,77.75,77.75,78.03,79.97,79.12,79.88,81.34,81.75,82.25,81.84,81.81,81.72,80.69,80.72,80.25,79.75,79.56,79.38,78.31,76.78,76.12,75.66,75.62,76.25,79.31,80.19,80.0,80.31,78.69,76.62,73.88,73.44,70.56,69.12,68.62,67.47,67.75,67.66,67.28,68.31,68.06,67.75,67.91,66.75,68.31,68.12,68.88,68.31,68.56,64.5,64.72,62.56,62.69,64.81,66.0,66.88,67.62,68.31,67.69,67.25,66.25,64.16,62.56,60.88,59.12,60.19,62.31,65.56,69.56,71.81,73.94,73.47,72.38,70.38,66.69,63.94,61.56,58.91,57.25,55.91,54.66,54.44,53.5,54.62,54.94,54.97,56.69,56.88,56.94,56.94,57.75,58.38,58.75,60.78,61.44,62.78,63.41,63.19,63.12,60.75,60.5,59.75,59.0,58.56,59.88,59.19,60.0,60.97,61.12,61.31,62.19,61.41,61.06,60.62,60.56,59.31,59.53,58.62,57.0,55.62,54.38,53.62,52.06,53.66,53.94,55.38,57.25,57.56,58.44,56.69,57.41,56.25,56.31,57.5,57.78,58.25,59.12,60.56,59.81,62.94,64.06,65.31,66.28,66.12,64.75,62.38,60.56,58.94,58.94,60.88,62.88,64.91,65.19,65.31,63.69,62.44,60.75,57.94,57.81,56.12,55.03,55.25,54.81,54.25,52.56,53.69,53.78,54.25,57.69,58.75,60.31,60.34,59.75,59.47,57.91,57.25,56.81,56.03,54.44,54.0,54.34,54.0,54.81,56.44,56.0,55.75,54.81,54.12,52.94,52.62,53.06,54.0,54.06,54.56,53.62,53.75,52.12,51.19,52.19,51.03,51.91,51.66,52.5,51.38,52.31,53.75,54.56,55.69,56.94,56.62,57.03,57.75,58.25,58.81,59.12,58.81,57.66,56.94,57.06,55.66,57.0,56.12,57.91,58.12,58.5,57.25,56.75,56.38,55.31,56.03,59.12,60.0,61.0,62.88,61.94,60.03,60.22,58.62,58.5,58.38,58.69,59.44,59.0,59.97,60.5,61.19,63.19,64.12,66.06,68.19,69.59,69.5,69.47,69.19,69.19,69.06,70.31,71.56,71.97,70.56,70.75,69.78,69.44,70.56,71.81,71.59,71.44,70.62,70.31,70.69,71.44,73.47,74.06,74.91,75.31,74.06,73.12,72.22,70.81,69.12,69.12,68.31,67.88,69.0,69.81,70.19,68.62,68.81,66.06,62.88,60.91,59.19,58.75,56.72,56.75,56.94,55.88,55.62,56.75,57.91,58.91,59.81,59.0,59.69,59.12,58.56,59.12,59.66,60.31,60.69,60.56,61.66,59.19,59.88,56.81,55.81,54.97,55.06,55.81,56.03,56.75,56.59,56.22,57.31,57.44,58.38,59.12,60.5,61.06,62.69,63.44,64.62,65.88,65.38,66.19,65.12,66.5,65.69,65.88,66.44,64.69,65.66,64.19,64.97,66.0,66.56,67.62,68.03,67.62,66.38,65.62,63.88,62.72,60.81,59.69,58.94,56.62,55.06,53.94,54.41,54.38,55.0,55.28,55.38,55.88,56.25,56.62,59.81,61.5,63.5,64.62,66.0,66.56,67.03,67.81,67.94,67.31,67.5,67.5,66.19,65.34,65.75,64.19,63.94,63.69,64.69,64.88,65.5,64.5,62.81,60.25,57.56,55.41,53.94,54.12,53.59,54.38,54.53,54.06,54.72,54.31,53.69,54.19,53.97,54.19,53.75,53.25,54.62,53.25,53.78,53.72,53.5,54.06,53.06,52.75,53.25,51.94,51.81,49.88,48.88,45.81,42.94,32.31,30.94,28.5,26.5,23.84,21.72,22.31,24.25,27.0,29.66,33.09,35.09,36.53,35.19,33.78,31.28,28.75,25.75:69.56,69.62,69.06,67.62,65.88,65.09,64.06,64.94,65.31,67.66,69.06,70.19,70.94,72.34,71.12,73.0,73.41,73.28,71.25,70.25,66.5,64.16,63.5,63.28,66.0,68.84,72.94,78.0,81.38,84.81,88.38,89.88,92.31,92.88,91.69,89.69,87.25,81.16,77.25,73.5,70.69,67.31,66.0,66.0,65.19,64.75,65.56,64.78,63.66,63.16,62.38,62.0,61.5,62.41,62.62,62.56,64.44,66.0,66.44,68.12,67.91,68.81,68.19,68.19,66.75,65.06,64.28,63.28,62.94,64.5,66.81,69.62,72.69,75.19,77.56,77.75,77.88,76.62,74.81,73.56,71.66,69.69,67.31,63.44,60.88,58.06,55.81,54.91,55.25,55.31,57.06,59.31,61.31,64.81,69.19,72.19,74.81,76.38,75.75,73.81,70.5,67.19,65.56,63.41,62.88,63.06,62.62,62.53,64.88,65.94,68.06,70.41,71.62,70.81,70.84,68.34,67.31,66.84,67.94,68.94,71.25,71.75,72.38,72.12,72.0,71.75,73.19,73.38,73.69,72.75,71.47,70.0,68.66,67.56,65.75,64.62,64.56,63.56,65.44,66.75,69.44,72.0,73.62,74.62,76.0,76.88,75.88,76.0,74.81,73.06,71.38,68.94,66.56,65.94,64.62,64.0,65.25,65.25,65.5,65.88,65.88,66.56,65.75,67.31,68.19,67.25,67.69,65.44,63.34,61.91,59.75,59.62,57.56,59.31,58.53,58.25,60.25,61.19,61.75,63.91,64.44,65.62,65.25,64.56,64.28,61.38,61.62,60.31,59.38,59.62,61.34,63.19,65.5,67.06,68.88,70.81,70.25,70.31,70.31,68.81,66.44,65.25,62.81,60.41,57.56,56.19,54.34,52.25,52.5,53.19,54.62,56.06,57.5,58.06,58.06,57.44,56.25,56.12,54.47,53.44,52.25,50.94,49.25,48.12,48.94,48.94,50.38,51.53,52.94,53.19,54.5,54.41,55.25,56.41,56.22,56.31,55.94,54.69,53.25,50.94,50.0,48.69,48.0,47.88,47.0,48.25,49.12,50.16,51.12,52.41,53.38,53.75,54.12,54.44,54.19,54.69,55.0,56.34,56.81,57.81,60.81,59.81,61.06,62.41,62.06,62.97,62.25,63.16,62.69,63.31,64.72,65.31,66.62,67.06,67.31,67.31,66.19,65.75,65.81,65.38,66.69,67.06,68.75,69.94,69.38,69.0,68.88,67.12,65.81,65.44,62.59,60.12,59.12,57.62,56.12,55.44,54.38,53.41,51.38,49.38,49.47,48.88,50.06,49.53,51.44,52.69,53.81,56.31,58.66,60.5,61.62,62.38,61.19,60.88,59.25,58.75,57.69,56.31,54.84,53.25,52.12,52.62,52.56,53.75,55.81,55.5,56.81,56.5,56.34,55.88,56.0,57.69,58.66,60.62,63.44,64.25,65.66,66.25,67.06,67.62,67.38,67.69,68.19,68.5,68.31,66.88,65.88,65.06,64.62,65.12,67.0,67.75,67.62,66.12,65.88,63.25,63.62,63.56,64.19,65.62,68.19,70.44,71.59,73.81,75.12,76.62,77.94,79.06,79.12,79.44,78.0,78.78,77.72,78.12,78.47,78.5,78.69,78.62,77.38,76.56,75.69,74.62,72.91,73.38,72.62,72.81,73.12,73.94,73.31,73.53,72.12,71.44,70.44,72.0,72.88,74.75,76.06,76.0,76.12,74.16,72.56,71.25,69.59,66.62,66.94,66.5,67.16,69.19,70.81,72.38,72.91,73.81,73.56,73.38,73.44,73.88,72.25,71.81,71.94,70.88,69.5,69.25,67.75,67.44,69.19,70.53,71.47,73.5,73.31,72.47,71.38,70.31,68.0,67.97,66.0,66.62,67.19,68.81,69.44,71.78,74.81,74.25,75.62,77.31,76.88,77.0,75.44,75.41,76.12,75.62,77.75,77.75,78.03,79.97,79.12,79.88,81.34,81.75,82.25,81.84,81.81,81.72,80.69,80.72,80.25,79.75,79.56,79.38,78.31,76.78,76.12,75.66,75.62,76.25,79.31,80.19,80.0,80.31,78.69,76.62,73.88,73.44,70.56,69.12,68.62,67.47,67.75,67.66,67.28,68.31,68.06,67.75,67.91,66.75,68.31,68.12,68.88,68.31,68.56,64.5,64.72,62.56,62.69,64.81,66.0,66.88,67.62,68.31,67.69,67.25,66.25,64.16,62.56,60.88,59.12,60.19,62.31,65.56,69.56,71.81,73.94,73.47,72.38,70.38,66.69,63.94,61.56,58.91,57.25,55.91,54.66,54.44,53.5,54.62,54.94,54.97,56.69,56.88,56.94,56.94,57.75,58.38,58.75,60.78,61.44,62.78,63.41,63.19,63.12,60.75,60.5,59.75,59.0,58.56,59.88,59.19,60.0,60.97,61.12,61.31,62.19,61.41,61.06,60.62,60.56,59.31,59.53,58.62,57.0,55.62,54.38,53.62,52.06,53.66,53.94,55.38,57.25,57.56,58.44,56.69,57.41,56.25,56.31,57.5,57.78,58.25,59.12,60.56,59.81,62.94,64.06,65.31,66.28,66.12,64.75,62.38,60.56,58.94,58.94,60.88,62.88,64.91,65.19,65.31,63.69,62.44,60.75,57.94,57.81,56.12,55.03,55.25,54.81,54.25,52.56,53.69,53.78,54.25,57.69,58.75,60.31,60.34,59.75,59.47,57.91,57.25,56.81,56.03,54.44,54.0,54.34,54.0,54.81,56.44,56.0,55.75,54.81,54.12,52.94,52.62,53.06,54.0,54.06,54.56,53.62,53.75,52.12,51.19,52.19,51.03,51.91,51.66,52.5,51.38,52.31,53.75,54.56,55.69,56.94,56.62,57.03,57.75,58.25,58.81,59.12,58.81,57.66,56.94,57.06,55.66,57.0,56.12,57.91,58.12,58.5,57.25,56.75,56.38,55.31,56.03,59.12,60.0,61.0,62.88,61.94,60.03,60.22,58.62,58.5,58.38,58.69,59.44,59.0,59.97,60.5,61.19,63.19,64.12,66.06,68.19,69.59,69.5,69.47,69.19,69.19,69.06,70.31,71.56,71.97,70.56,70.75,69.78,69.44,70.56,71.81,71.59,71.44,70.62,70.31,70.69,71.44,73.47,74.06,74.91,75.31,74.06,73.12,72.22,70.81,69.12,69.12,68.31,67.88,69.0,69.81,70.19,68.62,68.81,66.06,62.88,60.91,59.19,58.75,56.72,56.75,56.94,55.88,55.62,56.75,57.91,58.91,59.81,59.0,59.69,59.12,58.56,59.12,59.66,60.31,60.69,60.56,61.66,59.19,59.88,56.81,55.81,54.97,55.06,55.81,56.03,56.75,56.59,56.22,57.31,57.44,58.38,59.12,60.5,61.06,62.69,63.44,64.62,65.88,65.38,66.19,65.12,66.5,65.69,65.88,66.44,64.69,65.66,64.19,64.97,66.0,66.56,67.62,68.03,67.62,66.38,65.62,63.88,62.72,60.81,59.69,58.94,56.62,55.06,53.94,54.41,54.38,55.0,55.28,55.38,55.88,56.25,56.62,59.81,61.5,63.5,64.62,66.0,66.56,67.03,67.81,67.94,67.31,67.5,67.5,66.19,65.34,65.75,64.19,63.94,63.69,64.69,64.88,65.5,64.5,62.81,60.25,57.56,55.41,53.94,54.12,53.59,54.38,54.53,54.06,54.72,54.31,53.69,54.19,53.97,54.19,53.75,53.25,54.62,53.25,53.78,53.72,53.5,54.06,53.06,52.75,53.25,51.94,51.81,49.88,48.88,45.81,42.94,32.31,30.94,28.5,26.5,23.84,21.72,22.31,24.25,27.0,29.66,33.09,35.09,36.53,35.19,33.78,31.28,28.75,25.75,24.84,22.44,22.47,22.59,24.38,24.72:64.06,64.94,65.31,67.66,69.06,70.19,70.94,72.34,71.12,73.0,73.41,73.28,71.25,70.25,66.5,64.16,63.5,63.28,66.0,68.84,72.94,78.0,81.38,84.81,88.38,89.88,92.31,92.88,91.69,89.69,87.25,81.16,77.25,73.5,70.69,67.31,66.0,66.0,65.19,64.75,65.56,64.78,63.66,63.16,62.38,62.0,61.5,62.41,62.62,62.56,64.44,66.0,66.44,68.12,67.91,68.81,68.19,68.19,66.75,65.06,64.28,63.28,62.94,64.5,66.81,69.62,72.69,75.19,77.56,77.75,77.88,76.62,74.81,73.56,71.66,69.69,67.31,63.44,60.88,58.06,55.81,54.91,55.25,55.31,57.06,59.31,61.31,64.81,69.19,72.19,74.81,76.38,75.75,73.81,70.5,67.19,65.56,63.41,62.88,63.06,62.62,62.53,64.88,65.94,68.06,70.41,71.62,70.81,70.84,68.34,67.31,66.84,67.94,68.94,71.25,71.75,72.38,72.12,72.0,71.75,73.19,73.38,73.69,72.75,71.47,70.0,68.66,67.56,65.75,64.62,64.56,63.56,65.44,66.75,69.44,72.0,73.62,74.62,76.0,76.88,75.88,76.0,74.81,73.06,71.38,68.94,66.56,65.94,64.62,64.0,65.25,65.25,65.5,65.88,65.88,66.56,65.75,67.31,68.19,67.25,67.69,65.44,63.34,61.91,59.75,59.62,57.56,59.31,58.53,58.25,60.25,61.19,61.75,63.91,64.44,65.62,65.25,64.56,64.28,61.38,61.62,60.31,59.38,59.62,61.34,63.19,65.5,67.06,68.88,70.81,70.25,70.31,70.31,68.81,66.44,65.25,62.81,60.41,57.56,56.19,54.34,52.25,52.5,53.19,54.62,56.06,57.5,58.06,58.06,57.44,56.25,56.12,54.47,53.44,52.25,50.94,49.25,48.12,48.94,48.94,50.38,51.53,52.94,53.19,54.5,54.41,55.25,56.41,56.22,56.31,55.94,54.69,53.25,50.94,50.0,48.69,48.0,47.88,47.0,48.25,49.12,50.16,51.12,52.41,53.38,53.75,54.12,54.44,54.19,54.69,55.0,56.34,56.81,57.81,60.81,59.81,61.06,62.41,62.06,62.97,62.25,63.16,62.69,63.31,64.72,65.31,66.62,67.06,67.31,67.31,66.19,65.75,65.81,65.38,66.69,67.06,68.75,69.94,69.38,69.0,68.88,67.12,65.81,65.44,62.59,60.12,59.12,57.62,56.12,55.44,54.38,53.41,51.38,49.38,49.47,48.88,50.06,49.53,51.44,52.69,53.81,56.31,58.66,60.5,61.62,62.38,61.19,60.88,59.25,58.75,57.69,56.31,54.84,53.25,52.12,52.62,52.56,53.75,55.81,55.5,56.81,56.5,56.34,55.88,56.0,57.69,58.66,60.62,63.44,64.25,65.66,66.25,67.06,67.62,67.38,67.69,68.19,68.5,68.31,66.88,65.88,65.06,64.62,65.12,67.0,67.75,67.62,66.12,65.88,63.25,63.62,63.56,64.19,65.62,68.19,70.44,71.59,73.81,75.12,76.62,77.94,79.06,79.12,79.44,78.0,78.78,77.72,78.12,78.47,78.5,78.69,78.62,77.38,76.56,75.69,74.62,72.91,73.38,72.62,72.81,73.12,73.94,73.31,73.53,72.12,71.44,70.44,72.0,72.88,74.75,76.06,76.0,76.12,74.16,72.56,71.25,69.59,66.62,66.94,66.5,67.16,69.19,70.81,72.38,72.91,73.81,73.56,73.38,73.44,73.88,72.25,71.81,71.94,70.88,69.5,69.25,67.75,67.44,69.19,70.53,71.47,73.5,73.31,72.47,71.38,70.31,68.0,67.97,66.0,66.62,67.19,68.81,69.44,71.78,74.81,74.25,75.62,77.31,76.88,77.0,75.44,75.41,76.12,75.62,77.75,77.75,78.03,79.97,79.12,79.88,81.34,81.75,82.25,81.84,81.81,81.72,80.69,80.72,80.25,79.75,79.56,79.38,78.31,76.78,76.12,75.66,75.62,76.25,79.31,80.19,80.0,80.31,78.69,76.62,73.88,73.44,70.56,69.12,68.62,67.47,67.75,67.66,67.28,68.31,68.06,67.75,67.91,66.75,68.31,68.12,68.88,68.31,68.56,64.5,64.72,62.56,62.69,64.81,66.0,66.88,67.62,68.31,67.69,67.25,66.25,64.16,62.56,60.88,59.12,60.19,62.31,65.56,69.56,71.81,73.94,73.47,72.38,70.38,66.69,63.94,61.56,58.91,57.25,55.91,54.66,54.44,53.5,54.62,54.94,54.97,56.69,56.88,56.94,56.94,57.75,58.38,58.75,60.78,61.44,62.78,63.41,63.19,63.12,60.75,60.5,59.75,59.0,58.56,59.88,59.19,60.0,60.97,61.12,61.31,62.19,61.41,61.06,60.62,60.56,59.31,59.53,58.62,57.0,55.62,54.38,53.62,52.06,53.66,53.94,55.38,57.25,57.56,58.44,56.69,57.41,56.25,56.31,57.5,57.78,58.25,59.12,60.56,59.81,62.94,64.06,65.31,66.28,66.12,64.75,62.38,60.56,58.94,58.94,60.88,62.88,64.91,65.19,65.31,63.69,62.44,60.75,57.94,57.81,56.12,55.03,55.25,54.81,54.25,52.56,53.69,53.78,54.25,57.69,58.75,60.31,60.34,59.75,59.47,57.91,57.25,56.81,56.03,54.44,54.0,54.34,54.0,54.81,56.44,56.0,55.75,54.81,54.12,52.94,52.62,53.06,54.0,54.06,54.56,53.62,53.75,52.12,51.19,52.19,51.03,51.91,51.66,52.5,51.38,52.31,53.75,54.56,55.69,56.94,56.62,57.03,57.75,58.25,58.81,59.12,58.81,57.66,56.94,57.06,55.66,57.0,56.12,57.91,58.12,58.5,57.25,56.75,56.38,55.31,56.03,59.12,60.0,61.0,62.88,61.94,60.03,60.22,58.62,58.5,58.38,58.69,59.44,59.0,59.97,60.5,61.19,63.19,64.12,66.06,68.19,69.59,69.5,69.47,69.19,69.19,69.06,70.31,71.56,71.97,70.56,70.75,69.78,69.44,70.56,71.81,71.59,71.44,70.62,70.31,70.69,71.44,73.47,74.06,74.91,75.31,74.06,73.12,72.22,70.81,69.12,69.12,68.31,67.88,69.0,69.81,70.19,68.62,68.81,66.06,62.88,60.91,59.19,58.75,56.72,56.75,56.94,55.88,55.62,56.75,57.91,58.91,59.81,59.0,59.69,59.12,58.56,59.12,59.66,60.31,60.69,60.56,61.66,59.19,59.88,56.81,55.81,54.97,55.06,55.81,56.03,56.75,56.59,56.22,57.31,57.44,58.38,59.12,60.5,61.06,62.69,63.44,64.62,65.88,65.38,66.19,65.12,66.5,65.69,65.88,66.44,64.69,65.66,64.19,64.97,66.0,66.56,67.62,68.03,67.62,66.38,65.62,63.88,62.72,60.81,59.69,58.94,56.62,55.06,53.94,54.41,54.38,55.0,55.28,55.38,55.88,56.25,56.62,59.81,61.5,63.5,64.62,66.0,66.56,67.03,67.81,67.94,67.31,67.5,67.5,66.19,65.34,65.75,64.19,63.94,63.69,64.69,64.88,65.5,64.5,62.81,60.25,57.56,55.41,53.94,54.12,53.59,54.38,54.53,54.06,54.72,54.31,53.69,54.19,53.97,54.19,53.75,53.25,54.62,53.25,53.78,53.72,53.5,54.06,53.06,52.75,53.25,51.94,51.81,49.88,48.88,45.81,42.94,32.31,30.94,28.5,26.5,23.84,21.72,22.31,24.25,27.0,29.66,33.09,35.09,36.53,35.19,33.78,31.28,28.75,25.75,24.84,22.44,22.47,22.59,24.38,24.72,26.41,27.34,27.88,26.59,25.19,24.75:negativity
23.12,21.31,22.81,23.88,25.53,27.56,28.5,28.56,27.81,25.44,25.94,24.5,23.84,24.62,23.44,21.38,20.75,17.25,18.62,17.62,19.41,20.22,22.22,23.53,24.56,25.81,26.28,28.06,28.38,29.12,30.62,29.75,28.62,28.59,26.94,25.25,23.12,22.5,23.16,23.66,26.78,31.03,34.81,38.56,41.62,41.03,43.56,42.94,43.0,43.81,44.62,46.31,46.94,48.16,48.06,47.41,48.97,46.78,46.31,44.19,40.56,36.75,33.12,31.19,28.59,29.16,28.34,28.38,28.28,27.69,28.09,27.25,26.03,26.28,24.62,23.59,23.53,25.66,27.41,31.06,33.72,35.75,36.41,35.69,34.41,32.5,30.25,30.69,29.09,29.38,30.56,29.25,31.41,32.94,35.41,37.91,40.59,42.62,42.28,42.0,39.12,37.31,35.06,32.25,31.28,30.31,28.44,27.0,25.56,24.31,23.03,22.97,21.91,24.19,26.59,27.53,31.69,33.0,32.94,33.25,31.94,31.25,30.88,30.19,30.97,30.56,29.88,29.66,30.06,29.06,30.72,31.72,31.28,31.66,31.62,29.41,28.5,26.78,24.34,24.31,22.81,23.56,20.91,23.44,25.25,26.31,30.41,32.56,32.78,34.34,32.53,32.72,33.16,33.03,33.91,32.91,32.69,32.12,32.19,31.28,31.84,31.94,32.03,31.28,29.38,27.66,26.28,24.94,26.09,26.28,27.25,26.5,28.81,28.59,28.56,28.28,28.09,24.44,21.22,21.03,18.56,18.91,20.25,21.75,22.34,23.69,23.06,22.34,22.66,22.38,23.22,25.31,27.53,29.41,32.16,32.41,31.09,30.75,29.62,27.75,27.72,28.75,28.47,25.66,27.78,24.75,26.09,28.25,29.25,30.75,32.88,32.19,31.06,31.34,27.34,26.62,24.66,24.16,26.53,28.91,31.41,35.06,36.69,36.81,37.06,36.31,35.69,34.94,35.25,33.78,33.34,31.94,29.56,29.56,26.91,28.53,27.44,28.81,31.53,34.03,38.66,44.12,49.31,53.19,53.31,52.78,48.94,43.38,38.88,33.41,29.66,28.88,26.84,27.94,28.47,29.28,30.31,28.81,27.16,29.88,27.78,28.44,31.62,33.0,35.41,37.62,38.53,39.28,37.78,36.22,33.62,31.94,29.69,31.12,30.03,32.56,33.84,33.91,35.72,35.31,35.78,33.88,34.38,32.31,30.62,30.34,30.44,32.78,34.62,36.56,38.25,39.91,39.81,40.09,40.69,39.62,40.28,39.28,39.28,37.72,37.16,35.31,34.69,33.91,34.31,35.81,37.78,40.0,43.38,44.88,44.81,45.91,45.78,43.59,41.78,39.66,38.06,34.62,32.59,32.22,30.91,31.22,28.94,27.28,27.03,25.38,24.06,24.28,24.53,23.16,22.72,22.66,22.09,21.88,25.31,27.94,31.41,33.19,34.66,33.09,31.69,30.69,28.88,28.56,29.75,30.03,31.53,30.84,32.16,30.84,31.91,32.34,33.12,33.91,33.34,30.81,28.34,28.75,27.66,29.62,31.34,33.0,34.22,34.72,34.47,32.56,33.69,33.44,31.97,31.34,31.91,29.19,30.09,29.41,29.16,30.44,30.16,32.41,33.81,34.66,36.22,37.34,37.91,37.69,39.0,39.97,38.69,38.91,38.38,37.19,34.81,35.16,34.62,33.19,32.38,31.78,29.09,29.94,30.78,30.91,31.81,31.03,30.62,30.62,30.34,30.09,30.66,33.31,32.12,33.59,31.97,32.31,30.56,28.47,27.19,27.53,27.78,28.06,28.84,30.0,29.97,29.69,28.31,26.75,25.59,26.12,26.38,26.94,29.28,30.53,30.34,30.34,32.31,31.56,31.22,29.56,31.12,29.38,29.81,28.84,29.66,29.31,27.25,26.78,28.38,26.75,28.31,29.78,30.91,32.53,33.19,32.94,33.62,33.59,32.41,32.19,31.12,30.19,26.25,25.75,22.72,21.12,20.53,20.03,20.16,19.25,19.16,16.97,16.41,20.28,21.84,26.91,34.69,38.38,42.19,45.91,45.44,45.19,44.28,43.56,41.81,41.66,38.97,36.56,34.28,31.06,29.69,29.69,29.72,30.72,31.69,34.0,34.94,34.69,37.06,38.0,38.69,39.0,39.66,38.41,35.44,34.62,31.19,29.5,26.88,26.81,25.62,25.69,26.06,27.41,27.12,28.88,28.91,27.25,27.62,25.19,23.19,22.56,22.5,23.19,25.31,27.69,30.53,34.0,36.44,38.53,38.66,38.38,37.25,36.06,33.25,33.0,34.28,33.59,34.06,35.94,36.41,34.88,32.56,31.84,28.5,27.44,25.53,24.06,24.0,22.66,22.62,23.16,25.06,25.72,27.34,27.0,27.56,26.19,23.81,22.41,22.16,19.06,17.78,16.66,15.44,13.81,15.47,14.69,16.31,17.31,18.47,17.88,13.81,16.81,15.88,17.28,19.38,22.59,21.97,21.41,18.94,17.38,15.56,13.78,13.66,14.62,13.44,14.03,13.53,13.16,8.91,10.41,11.0,12.06,13.56,17.41,17.56,17.62,19.81,19.62,20.0,20.84,19.94,20.31,20.81,21.34,22.06,24.97,25.81,27.06,28.62,28.69,28.53,28.41,28.5,29.16,30.31,31.81,33.84,36.66,35.53,35.5,35.31,33.09,31.0,29.91,27.88,27.44,26.12,24.72,25.06,24.75,24.75,25.66,28.69,29.78,31.75,34.81,35.31,36.53,36.47,34.78,33.69,31.91,30.53,30.69,30.31,31.25,30.22,27.22,26.16,21.91,20.28,19.12,18.06,18.28,17.06,17.19,17.81,15.38,14.34,15.16,12.44,13.44,12.12,14.38,15.72,18.69,20.81,24.16,24.94,26.16,25.97,24.53,24.44,24.78,23.25,26.41,27.81,30.12,33.12,36.5,35.75,34.69,33.25,29.06,23.62,17.94,19.12,16.72,19.47,24.78,28.03,31.69,33.44,34.06,35.06,34.0,32.72,31.25,30.53,27.62,27.41,26.5,27.16,24.12,26.03,26.19,26.91,30.0,29.62,32.28,32.47,33.03,32.09,32.84,32.62,32.62,30.19,30.88,30.0,30.31,30.59,30.69,31.25,30.88,29.5,30.06,29.5,31.53,31.31,33.38,32.38,33.28,33.41,33.75,35.56,36.41,37.53,37.97,39.91,39.25,39.66,40.94,40.44,39.94,38.19,36.78,35.22,33.88,30.94,29.44,26.56,24.94,23.44,22.81,21.72,22.34,23.25,24.19,24.72,27.88,29.31,31.25,30.75,29.44,28.38,25.66,23.62,22.59,22.16,19.94,18.56,18.56,17.53,18.28,18.56,19.44,20.66,19.81,17.78,19.81,19.69,19.88,19.78,19.91,18.06,16.25,15.12,13.25,13.78,13.62,13.41,15.44,18.0,18.81,22.38,24.41,25.94,27.53,29.78,30.88,31.91,33.38,33.41,32.94,31.44,30.56,28.81,27.28,26.44,25.75,23.62,22.69,21.47,20.47,22.62,23.16,23.78,29.56,27.91,30.34,29.28,29.16,27.47,26.16,24.5,22.56,23.38,21.84,23.72,24.97,26.03,29.69,29.94,29.72,30.16,28.0,25.66,23.53,22.44,20.16,18.94,18.62,18.06,18.91,20.06,20.88,22.38,22.47,22.06,21.94,21.66,22.12,21.62,23.34,24.09,24.03,25.47,25.19,25.06,24.91,23.38,21.28,20.44,18.31,16.69,16.59,14.59,15.12,14.81,16.16,17.91,20.19,21.09,23.78,24.06,26.59,26.34,28.09,30.56,31.47,34.0,35.91,36.25,35.94,33.31,30.56,28.5,25.16,24.81,24.03,24.0,24.34,25.91,24.84,24.97,26.56,25.69,25.94:28.5,28.56,27.81,25.44,25.94,24.5,23.84,24.62,23.44,21.38,20.75,17.25,18.62,17.62,19.41,20.22,22.22,23.53,24.56,25.81,26.28,28.06,28.38,29.12,30.62,29.75,28.62,28.59,26.94,25.25,23.12,22.5,23.16,23.66,26.78,31.03,34.81,38.56,41.62,41.03,43.56,42.94,43.0,43.81,44.62,46.31,46.94,48.16,48.06,47.41,48.97,46.78,46.31,44.19,40.56,36.75,33.12,31.19,28.59,29.16,28.34,28.38,28.28,27.69,28.09,27.25,26.03,26.28,24.62,23.59,23.53,25.66,27.41,31.06,33.72,35.75,36.41,35.69,34.41,32.5,30.25,30.69,29.09,29.38,30.56,29.25,31.41,32.94,35.41,37.91,40.59,42.62,42.28,42.0,39.12,37.31,35.06,32.25,31.28,30.31,28.44,27.0,25.56,24.31,23.03,22.97,21.91,24.19,26.59,27.53,31.69,33.0,32.94,33.25,31.94,31.25,30.88,30.19,30.97,30.56,29.88,29.66,30.06,29.06,30.72,31.72,31.28,31.66,31.62,29.41,28.5,26.78,24.34,24.31,22.81,23.56,20.91,23.44,25.25,26.31,30.41,32.56,32.78,34.34,32.53,32.72,33.16,33.03,33.91,32.91,32.69,32.12,32.19,31.28,31.84,31.94,32.03,31.28,29.38,27.66,26.28,24.94,26.09,26.28,27.25,26.5,28.81,28.59,28.56,28.28,28.09,24.44,21.22,21.03,18.56,18.91,20.25,21.75,22.34,23.69,23.06,22.34,22.66,22.38,23.22,25.31,27.53,29.41,32.16,32.41,31.09,30.75,29.62,27.75,27.72,28.75,28.47,25.66,27.78,24.75,26.09,28.25,29.25,30.75,32.88,32.19,31.06,31.34,27.34,26.62,24.66,24.16,26.53,28.91,31.41,35.06,36.69,36.81,37.06,36.31,35.69,34.94,35.25,33.78,33.34,31.94,29.56,29.56,26.91,28.53,27.44,28.81,31.53,34.03,38.66,44.12,49.31,53.19,53.31,52.78,48.94,43.38,38.88,33.41,29.66,28.88,26.84,27.94,28.47,29.28,30.31,28.81,27.16,29.88,27.78,28.44,31.62,33.0,35.41,37.62,38.53,39.28,37.78,36.22,33.62,31.94,29.69,31.12,30.03,32.56,33.84,33.91,35.72,35.31,35.78,33.88,34.38,32.31,30.62,30.34,30.44,32.78,34.62,36.56,38.25,39.91,39.81,40.09,40.69,39.62,40.28,39.28,39.28,37.72,37.16,35.31,34.69,33.91,34.31,35.81,37.78,40.0,43.38,44.88,44.81,45.91,45.78,43.59,41.78,39.66,38.06,34.62,32.59,32.22,30.91,31.22,28.94,27.28,27.03,25.38,24.06,24.28,24.53,23.16,22.72,22.66,22.09,21.88,25.31,27.94,31.41,33.19,34.66,33.09,31.69,30.69,28.88,28.56,29.75,30.03,31.53,30.84,32.16,30.84,31.91,32.34,33.12,33.91,33.34,30.81,28.34,28.75,27.66,29.62,31.34,33.0,34.22,34.72,34.47,32.56,33.69,33.44,31.97,31.34,31.91,29.19,30.09,29.41,29.16,30.44,30.16,32.41,33.81,34.66,36.22,37.34,37.91,37.69,39.0,39.97,38.69,38.91,38.38,37.19,34.81,35.16,34.62,33.19,32.38,31.78,29.09,29.94,30.78,30.91,31.81,31.03,30.62,30.62,30.34,30.09,30.66,33.31,32.12,33.59,31.97,32.31,30.56,28.47,27.19,27.53,27.78,28.06,28.84,30.0,29.97,29.69,28.31,26.75,25.59,26.12,26.38,26.94,29.28,30.53,30.34,30.34,32.31,31.56,31.22,29.56,31.12,29.38,29.81,28.84,29.66,29.31,27.25,26.78,28.38,26.75,28.31,29.78,30.91,32.53,33.19,32.94,33.62,33.59,32.41,32.19,31.12,30.19,26.25,25.75,22.72,21.12,20.53,20.03,20.16,19.25,19.16,16.97,16.41,20.28,21.84,26.91,34.69,38.38,42.19,45.91,45.44,45.19,44.28,43.56,41.81,41.66,38.97,36.56,34.28,31.06,29.69,29.69,29.72,30.72,31.69,34.0,34.94,34.69,37.06,38.0,38.69,39.0,39.66,38.41,35.44,34.62,31.19,29.5,26.88,26.81,25.62,25.69,26.06,27.41,27.12,28.88,28.91,27.25,27.62,25.19,23.19,22.56,22.5,23.19,25.31,27.69,30.53,34.0,36.44,38.53,38.66,38.38,37.25,36.06,33.25,33.0,34.28,33.59,34.06,35.94,36.41,34.88,32.56,31.84,28.5,27.44,25.53,24.06,24.0,22.66,22.62,23.16,25.06,25.72,27.34,27.0,27.56,26.19,23.81,22.41,22.16,19.06,17.78,16.66,15.44,13.81,15.47,14.69,16.31,17.31,18.47,17.88,13.81,16.81,15.88,17.28,19.38,22.59,21.97,21.41,18.94,17.38,15.56,13.78,13.66,14.62,13.44,14.03,13.53,13.16,8.91,10.41,11.0,12.06,13.56,17.41,17.56,17.62,19.81,19.62,20.0,20.84,19.94,20.31,20.81,21.34,22.06,24.97,25.81,27.06,28.62,28.69,28.53,28.41,28.5,29.16,30.31,31.81,33.84,36.66,35.53,35.5,35.31,33.09,31.0,29.91,27.88,27.44,26.12,24.72,25.06,24.75,24.75,25.66,28.69,29.78,31.75,34.81,35.31,36.53,36.47,34.78,33.69,31.91,30.53,30.69,30.31,31.25,30.22,27.22,26.16,21.91,20.28,19.12,18.06,18.28,17.06,17.19,17.81,15.38,14.34,15.16,12.44,13.44,12.12,14.38,15.72,18.69,20.81,24.16,24.94,26.16,25.97,24.53,24.44,24.78,23.25,26.41,27.81,30.12,33.12,36.5,35.75,34.69,33.25,29.06,23.62,17.94,19.12,16.72,19.47,24.78,28.03,31.69,33.44,34.06,35.06,34.0,32.72,31.25,30.53,27.62,27.41,26.5,27.16,24.12,26.03,26.19,26.91,30.0,29.62,32.28,32.47,33.03,32.09,32.84,32.62,32.62,30.19,30.88,30.0,30.31,30.59,30.69,31.25,30.88,29.5,30.06,29.5,31.53,31.31,33.38,32.38,33.28,33.41,33.75,35.56,36.41,37.53,37.97,39.91,39.25,39.66,40.94,40.44,39.94,38.19,36.78,35.22,33.88,30.94,29.44,26.56,24.94,23.44,22.81,21.72,22.34,23.25,24.19,24.72,27.88,29.31,31.25,30.75,29.44,28.38,25.66,23.62,22.59,22.16,19.94,18.56,18.56,17.53,18.28,18.56,19.44,20.66,19.81,17.78,19.81,19.69,19.88,19.78,19.91,18.06,16.25,15.12,13.25,13.78,13.62,13.41,15.44,18.0,18.81,22.38,24.41,25.94,27.53,29.78,30.88,31.91,33.38,33.41,32.94,31.44,30.56,28.81,27.28,26.44,25.75,23.62,22.69,21.47,20.47,22.62,23.16,23.78,29.56,27.91,30.34,29.28,29.16,27.47,26.16,24.5,22.56,23.38,21.84,23.72,24.97,26.03,29.69,29.94,29.72,30.16,28.0,25.66,23.53,22.44,20.16,18.94,18.62,18.06,18.91,20.06,20.88,22.38,22.47,22.06,21.94,21.66,22.12,21.62,23.34,24.09,24.03,25.47,25.19,25.06,24.91,23.38,21.28,20.44,18.31,16.69,16.59,14.59,15.12,14.81,16.16,17.91,20.19,21.09,23.78,24.06,26.59,26.34,28.09,30.56,31.47,34.0,35.91,36.25,35.94,33.31,30.56,28.5,25.16,24.81,24.03,24.0,24.34,25.91,24.84,24.97,26.56,25.69,25.94,-14.03,-13.28,-10.62,-8.75,-7.47,-5.84:23.84,24.62,23.44,21.38,20.75,17.25,18.62,17.62,19.41,20.22,22.22,23.53,24.56,25.81,26.28,28.06,28.38,29.12,30.62,29.75,28.62,28.59,26.94,25.25,23.12,22.5,23.16,23.66,26.78,31.03,34.81,38.56,41.62,41.03,43.56,42.94,43.0,43.81,44.62,46.31,46.94,48.16,48.06,47.41,48.97,46.78,46.31,44.19,40.56,36.75,33.12,31.19,28.59,29.16,28.34,28.38,28.28,27.69,28.09,27.25,26.03,26.28,24.62,23.59,23.53,25.66,27.41,31.06,33.72,35.75,36.41,35.69,34.41,32.5,30.25,30.69,29.09,29.38,30.56,29.25,31.41,32.94,35.41,37.91,40.59,42.62,42.28,42.0,39.12,37.31,35.06,32.25,31.28,30.31,28.44,27.0,25.56,24.31,23.03,22.97,21.91,24.19,26.59,27.53,31.69,33.0,32.94,33.25,31.94,31.25,30.88,30.19,30.97,30.56,29.88,29.66,30.06,29.06,30.72,31.72,31.28,31.66,31.62,29.41,28.5,26.78,24.34,24.31,22.81,23.56,20.91,23.44,25.25,26.31,30.41,32.56,32.78,34.34,32.53,32.72,33.16,33.03,33.91,32.91,32.69,32.12,32.19,31.28,31.84,31.94,32.03,31.28,29.38,27.66,26.28,24.94,26.09,26.28,27.25,26.5,28.81,28.59,28.56,28.28,28.09,24.44,21.22,21.03,18.56,18.91,20.25,21.75,22.34,23.69,23.06,22.34,22.66,22.38,23.22,25.31,27.53,29.41,32.16,32.41,31.09,30.75,29.62,27.75,27.72,28.75,28.47,25.66,27.78,24.75,26.09,28.25,29.25,30.75,32.88,32.19,31.06,31.34,27.34,26.62,24.66,24.16,26.53,28.91,31.41,35.06,36.69,36.81,37.06,36.31,35.69,34.94,35.25,33.78,33.34,31.94,29.56,29.56,26.91,28.53,27.44,28.81,31.53,34.03,38.66,44.12,49.31,53.19,53.31,52.78,48.94,43.38,38.88,33.41,29.66,28.88,26.84,27.94,28.47,29.28,30.31,28.81,27.16,29.88,27.78,28.44,31.62,33.0,35.41,37.62,38.53,39.28,37.78,36.22,33.62,31.94,29.69,31.12,30.03,32.56,33.84,33.91,35.72,35.31,35.78,33.88,34.38,32.31,30.62,30.34,30.44,32.78,34.62,36.56,38.25,39.91,39.81,40.09,40.69,39.62,40.28,39.28,39.28,37.72,37.16,35.31,34.69,33.91,34.31,35.81,37.78,40.0,43.38,44.88,44.81,45.91,45.78,43.59,41.78,39.66,38.06,34.62,32.59,32.22,30.91,31.22,28.94,27.28,27.03,25.38,24.06,24.28,24.53,23.16,22.72,22.66,22.09,21.88,25.31,27.94,31.41,33.19,34.66,33.09,31.69,30.69,28.88,28.56,29.75,30.03,31.53,30.84,32.16,30.84,31.91,32.34,33.12,33.91,33.34,30.81,28.34,28.75,27.66,29.62,31.34,33.0,34.22,34.72,34.47,32.56,33.69,33.44,31.97,31.34,31.91,29.19,30.09,29.41,29.16,30.44,30.16,32.41,33.81,34.66,36.22,37.34,37.91,37.69,39.0,39.97,38.69,38.91,38.38,37.19,34.81,35.16,34.62,33.19,32.38,31.78,29.09,29.94,30.78,30.91,31.81,31.03,30.62,30.62,30.34,30.09,30.66,33.31,32.12,33.59,31.97,32.31,30.56,28.47,27.19,27.53,27.78,28.06,28.84,30.0,29.97,29.69,28.31,26.75,25.59,26.12,26.38,26.94,29.28,30.53,30.34,30.34,32.31,31.56,31.22,29.56,31.12,29.38,29.81,28.84,29.66,29.31,27.25,26.78,28.38,26.75,28.31,29.78,30.91,32.53,33.19,32.94,33.62,33.59,32.41,32.19,31.12,30.19,26.25,25.75,22.72,21.12,20.53,20.03,20.16,19.25,19.16,16.97,16.41,20.28,21.84,26.91,34.69,38.38,42.19,45.91,45.44,45.19,44.28,43.56,41.81,41.66,38.97,36.56,34.28,31.06,29.69,29.69,29.72,30.72,31.69,34.0,34.94,34.69,37.06,38.0,38.69,39.0,39.66,38.41,35.44,34.62,31.19,29.5,26.88,26.81,25.62,25.69,26.06,27.41,27.12,28.88,28.91,27.25,27.62,25.19,23.19,22.56,22.5,23.19,25.31,27.69,30.53,34.0,36.44,38.53,38.66,38.38,37.25,36.06,33.25,33.0,34.28,33.59,34.06,35.94,36.41,34.88,32.56,31.84,28.5,27.44,25.53,24.06,24.0,22.66,22.62,23.16,25.06,25.72,27.34,27.0,27.56,26.19,23.81,22.41,22.16,19.06,17.78,16.66,15.44,13.81,15.47,14.69,16.31,17.31,18.47,17.88,13.81,16.81,15.88,17.28,19.38,22.59,21.97,21.41,18.94,17.38,15.56,13.78,13.66,14.62,13.44,14.03,13.53,13.16,8.91,10.41,11.0,12.06,13.56,17.41,17.56,17.62,19.81,19.62,20.0,20.84,19.94,20.31,20.81,21.34,22.06,24.97,25.81,27.06,28.62,28.69,28.53,28.41,28.5,29.16,30.31,31.81,33.84,36.66,35.53,35.5,35.31,33.09,31.0,29.91,27.88,27.44,26.12,24.72,25.06,24.75,24.75,25.66,28.69,29.78,31.75,34.81,35.31,36.53,36.47,34.78,33.69,31.91,30.53,30.69,30.31,31.25,30.22,27.22,26.16,21.91,20.28,19.12,18.06,18.28,17.06,17.19,17.81,15.38,14.34,15.16,12.44,13.44,12.12,14.38,15.72,18.69,20.81,24.16,24.94,26.16,25.97,24.53,24.44,24.78,23.25,26.41,27.81,30.12,33.12,36.5,35.75,34.69,33.25,29.06,23.62,17.94,19.12,16.72,19.47,24.78,28.03,31.69,33.44,34.06,35.06,34.0,32.72,31.25,30.53,27.62,27.41,26.5,27.16,24.12,26.03,26.19,26.91,30.0,29.62,32.28,32.47,33.03,32.09,32.84,32.62,32.62,30.19,30.88,30.0,30.31,30.59,30.69,31.25,30.88,29.5,30.06,29.5,31.53,31.31,33.38,32.38,33.28,33.41,33.75,35.56,36.41,37.53,37.97,39.91,39.25,39.66,40.94,40.44,39.94,38.19,36.78,35.22,33.88,30.94,29.44,26.56,24.94,23.44,22.81,21.72,22.34,23.25,24.19,24.72,27.88,29.31,31.25,30.75,29.44,28.38,25.66,23.62,22.59,22.16,19.94,18.56,18.56,17.53,18.28,18.56,19.44,20.66,19.81,17.78,19.81,19.69,19.88,19.78,19.91,18.06,16.25,15.12,13.25,13.78,13.62,13.41,15.44,18.0,18.81,22.38,24.41,25.94,27.53,29.78,30.88,31.91,33.38,33.41,32.94,31.44,30.56,28.81,27.28,26.44,25.75,23.62,22.69,21.47,20.47,22.62,23.16,23.78,29.56,27.91,30.34,29.28,29.16,27.47,26.16,24.5,22.56,23.38,21.84,23.72,24.97,26.03,29.69,29.94,29.72,30.16,28.0,25.66,23.53,22.44,20.16,18.94,18.62,18.06,18.91,20.06,20.88,22.38,22.47,22.06,21.94,21.66,22.12,21.62,23.34,24.09,24.03,25.47,25.19,25.06,24.91,23.38,21.28,20.44,18.31,16.69,16.59,14.59,15.12,14.81,16.16,17.91,20.19,21.09,23.78,24.06,26.59,26.34,28.09,30.56,31.47,34.0,35.91,36.25,35.94,33.31,30.56,28.5,25.16,24.81,24.03,24.0,24.34,25.91,24.84,24.97,26.56,25.69,25.94,-14.03,-13.28,-10.62,-8.75,-7.47,-5.84,-5.47,-5.34,-5.78,-7.38,-6.78,-7.16:18.62,17.62,19.41,20.22,22.22,23.53,24.56,25.81,26.28,28.06,28.38,29.12,30.62,29.75,28.62,28.59,26.94,25.25,23.12,22.5,23.16,23.66,26.78,31.03,34.81,38.56,41.62,41.03,43.56,42.94,43.0,43.81,44.62,46.31,46.94,48.16,48.06,47.41,48.97,46.78,46.31,44.19,40.56,36.75,33.12,31.19,28.59,29.16,28.34,28.38,28.28,27.69,28.09,27.25,26.03,26.28,24.62,23.59,23.53,25.66,27.41,31.06,33.72,35.75,36.41,35.69,34.41,32.5,30.25,30.69,29.09,29.38,30.56,29.25,31.41,32.94,35.41,37.91,40.59,42.62,42.28,42.0,39.12,37.31,35.06,32.25,31.28,30.31,28.44,27.0,25.56,24.31,23.03,22.97,21.91,24.19,26.59,27.53,31.69,33.0,32.94,33.25,31.94,31.25,30.88,30.19,30.97,30.56,29.88,29.66,30.06,29.06,30.72,31.72,31.28,31.66,31.62,29.41,28.5,26.78,24.34,24.31,22.81,23.56,20.91,23.44,25.25,26.31,30.41,32.56,32.78,34.34,32.53,32.72,33.16,33.03,33.91,32.91,32.69,32.12,32.19,31.28,31.84,31.94,32.03,31.28,29.38,27.66,26.28,24.94,26.09,26.28,27.25,26.5,28.81,28.59,28.56,28.28,28.09,24.44,21.22,21.03,18.56,18.91,20.25,21.75,22.34,23.69,23.06,22.34,22.66,22.38,23.22,25.31,27.53,29.41,32.16,32.41,31.09,30.75,29.62,27.75,27.72,28.75,28.47,25.66,27.78,24.75,26.09,28.25,29.25,30.75,32.88,32.19,31.06,31.34,27.34,26.62,24.66,24.16,26.53,28.91,31.41,35.06,36.69,36.81,37.06,36.31,35.69,34.94,35.25,33.78,33.34,31.94,29.56,29.56,26.91,28.53,27.44,28.81,31.53,34.03,38.66,44.12,49.31,53.19,53.31,52.78,48.94,43.38,38.88,33.41,29.66,28.88,26.84,27.94,28.47,29.28,30.31,28.81,27.16,29.88,27.78,28.44,31.62,33.0,35.41,37.62,38.53,39.28,37.78,36.22,33.62,31.94,29.69,31.12,30.03,32.56,33.84,33.91,35.72,35.31,35.78,33.88,34.38,32.31,30.62,30.34,30.44,32.78,34.62,36.56,38.25,39.91,39.81,40.09,40.69,39.62,40.28,39.28,39.28,37.72,37.16,35.31,34.69,33.91,34.31,35.81,37.78,40.0,43.38,44.88,44.81,45.91,45.78,43.59,41.78,39.66,38.06,34.62,32.59,32.22,30.91,31.22,28.94,27.28,27.03,25.38,24.06,24.28,24.53,23.16,22.72,22.66,22.09,21.88,25.31,27.94,31.41,33.19,34.66,33.09,31.69,30.69,28.88,28.56,29.75,30.03,31.53,30.84,32.16,30.84,31.91,32.34,33.12,33.91,33.34,30.81,28.34,28.75,27.66,29.62,31.34,33.0,34.22,34.72,34.47,32.56,33.69,33.44,31.97,31.34,31.91,29.19,30.09,29.41,29.16,30.44,30.16,32.41,33.81,34.66,36.22,37.34,37.91,37.69,39.0,39.97,38.69,38.91,38.38,37.19,34.81,35.16,34.62,33.19,32.38,31.78,29.09,29.94,30.78,30.91,31.81,31.03,30.62,30.62,30.34,30.09,30.66,33.31,32.12,33.59,31.97,32.31,30.56,28.47,27.19,27.53,27.78,28.06,28.84,30.0,29.97,29.69,28.31,26.75,25.59,26.12,26.38,26.94,29.28,30.53,30.34,30.34,32.31,31.56,31.22,29.56,31.12,29.38,29.81,28.84,29.66,29.31,27.25,26.78,28.38,26.75,28.31,29.78,30.91,32.53,33.19,32.94,33.62,33.59,32.41,32.19,31.12,30.19,26.25,25.75,22.72,21.12,20.53,20.03,20.16,19.25,19.16,16.97,16.41,20.28,21.84,26.91,34.69,38.38,42.19,45.91,45.44,45.19,44.28,43.56,41.81,41.66,38.97,36.56,34.28,31.06,29.69,29.69,29.72,30.72,31.69,34.0,34.94,34.69,37.06,38.0,38.69,39.0,39.66,38.41,35.44,34.62,31.19,29.5,26.88,26.81,25.62,25.69,26.06,27.41,27.12,28.88,28.91,27.25,27.62,25.19,23.19,22.56,22.5,23.19,25.31,27.69,30.53,34.0,36.44,38.53,38.66,38.38,37.25,36.06,33.25,33.0,34.28,33.59,34.06,35.94,36.41,34.88,32.56,31.84,28.5,27.44,25.53,24.06,24.0,22.66,22.62,23.16,25.06,25.72,27.34,27.0,27.56,26.19,23.81,22.41,22.16,19.06,17.78,16.66,15.44,13.81,15.47,14.69,16.31,17.31,18.47,17.88,13.81,16.81,15.88,17.28,19.38,22.59,21.97,21.41,18.94,17.38,15.56,13.78,13.66,14.62,13.44,14.03,13.53,13.16,8.91,10.41,11.0,12.06,13.56,17.41,17.56,17.62,19.81,19.62,20.0,20.84,19.94,20.31,20.81,21.34,22.06,24.97,25.81,27.06,28.62,28.69,28.53,28.41,28.5,29.16,30.31,31.81,33.84,36.66,35.53,35.5,35.31,33.09,31.0,29.91,27.88,27.44,26.12,24.72,25.06,24.75,24.75,25.66,28.69,29.78,31.75,34.81,35.31,36.53,36.47,34.78,33.69,31.91,30.53,30.69,30.31,31.25,30.22,27.22,26.16,21.91,20.28,19.12,18.06,18.28,17.06,17.19,17.81,15.38,14.34,15.16,12.44,13.44,12.12,14.38,15.72,18.69,20.81,24.16,24.94,26.16,25.97,24.53,24.44,24.78,23.25,26.41,27.81,30.12,33.12,36.5,35.75,34.69,33.25,29.06,23.62,17.94,19.12,16.72,19.47,24.78,28.03,31.69,33.44,34.06,35.06,34.0,32.72,31.25,30.53,27.62,27.41,26.5,27.16,24.12,26.03,26.19,26.91,30.0,29.62,32.28,32.47,33.03,32.09,32.84,32.62,32.62,30.19,30.88,30.0,30.31,30.59,30.69,31.25,30.88,29.5,30.06,29.5,31.53,31.31,33.38,32.38,33.28,33.41,33.75,35.56,36.41,37.53,37.97,39.91,39.25,39.66,40.94,40.44,39.94,38.19,36.78,35.22,33.88,30.94,29.44,26.56,24.94,23.44,22.81,21.72,22.34,23.25,24.19,24.72,27.88,29.31,31.25,30.75,29.44,28.38,25.66,23.62,22.59,22.16,19.94,18.56,18.56,17.53,18.28,18.56,19.44,20.66,19.81,17.78,19.81,19.69,19.88,19.78,19.91,18.06,16.25,15.12,13.25,13.78,13.62,13.41,15.44,18.0,18.81,22.38,24.41,25.94,27.53,29.78,30.88,31.91,33.38,33.41,32.94,31.44,30.56,28.81,27.28,26.44,25.75,23.62,22.69,21.47,20.47,22.62,23.16,23.78,29.56,27.91,30.34,29.28,29.16,27.47,26.16,24.5,22.56,23.38,21.84,23.72,24.97,26.03,29.69,29.94,29.72,30.16,28.0,25.66,23.53,22.44,20.16,18.94,18.62,18.06,18.91,20.06,20.88,22.38,22.47,22.06,21.94,21.66,22.12,21.62,23.34,24.09,24.03,25.47,25.19,25.06,24.91,23.38,21.28,20.44,18.31,16.69,16.59,14.59,15.12,14.81,16.16,17.91,20.19,21.09,23.78,24.06,26.59,26.34,28.09,30.56,31.47,34.0,35.91,36.25,35.94,33.31,30.56,28.5,25.16,24.81,24.03,24.0,24.34,25.91,24.84,24.97,26.56,25.69,25.94,-14.03,-13.28,-10.62,-8.75,-7.47,-5.84,-5.47,-5.34,-5.78,-7.38,-6.78,-7.16,-7.81,-7.72,-8.84,-11.25,-12.59,-16.34:24.56,25.81,26.28,28.06,28.38,29.12,30.62,29.75,28.62,28.59,26.94,25.25,23.12,22.5,23.16,23.66,26.78,31.03,34.81,38.56,41.62,41.03,43.56,42.94,43.0,43.81,44.62,46.31,46.94,48.16,48.06,47.41,48.97,46.78,46.31,44.19,40.56,36.75,33.12,31.19,28.59,29.16,28.34,28.38,28.28,27.69,28.09,27.25,26.03,26.28,24.62,23.59,23.53,25.66,27.41,31.06,33.72,35.75,36.41,35.69,34.41,32.5,30.25,30.69,29.09,29.38,30.56,29.25,31.41,32.94,35.41,37.91,40.59,42.62,42.28,42.0,39.12,37.31,35.06,32.25,31.28,30.31,28.44,27.0,25.56,24.31,23.03,22.97,21.91,24.19,26.59,27.53,31.69,33.0,32.94,33.25,31.94,31.25,30.88,30.19,30.97,30.56,29.88,29.66,30.06,29.06,30.72,31.72,31.28,31.66,31.62,29.41,28.5,26.78,24.34,24.31,22.81,23.56,20.91,23.44,25.25,26.31,30.41,32.56,32.78,34.34,32.53,32.72,33.16,33.03,33.91,32.91,32.69,32.12,32.19,31.28,31.84,31.94,32.03,31.28,29.38,27.66,26.28,24.94,26.09,26.28,27.25,26.5,28.81,28.59,28.56,28.28,28.09,24.44,21.22,21.03,18.56,18.91,20.25,21.75,22.34,23.69,23.06,22.34,22.66,22.38,23.22,25.31,27.53,29.41,32.16,32.41,31.09,30.75,29.62,27.75,27.72,28.75,28.47,25.66,27.78,24.75,26.09,28.25,29.25,30.75,32.88,32.19,31.06,31.34,27.34,26.62,24.66,24.16,26.53,28.91,31.41,35.06,36.69,36.81,37.06,36.31,35.69,34.94,35.25,33.78,33.34,31.94,29.56,29.56,26.91,28.53,27.44,28.81,31.53,34.03,38.66,44.12,49.31,53.19,53.31,52.78,48.94,43.38,38.88,33.41,29.66,28.88,26.84,27.94,28.47,29.28,30.31,28.81,27.16,29.88,27.78,28.44,31.62,33.0,35.41,37.62,38.53,39.28,37.78,36.22,33.62,31.94,29.69,31.12,30.03,32.56,33.84,33.91,35.72,35.31,35.78,33.88,34.38,32.31,30.62,30.34,30.44,32.78,34.62,36.56,38.25,39.91,39.81,40.09,40.69,39.62,40.28,39.28,39.28,37.72,37.16,35.31,34.69,33.91,34.31,35.81,37.78,40.0,43.38,44.88,44.81,45.91,45.78,43.59,41.78,39.66,38.06,34.62,32.59,32.22,30.91,31.22,28.94,27.28,27.03,25.38,24.06,24.28,24.53,23.16,22.72,22.66,22.09,21.88,25.31,27.94,31.41,33.19,34.66,33.09,31.69,30.69,28.88,28.56,29.75,30.03,31.53,30.84,32.16,30.84,31.91,32.34,33.12,33.91,33.34,30.81,28.34,28.75,27.66,29.62,31.34,33.0,34.22,34.72,34.47,32.56,33.69,33.44,31.97,31.34,31.91,29.19,30.09,29.41,29.16,30.44,30.16,32.41,33.81,34.66,36.22,37.34,37.91,37.69,39.0,39.97,38.69,38.91,38.38,37.19,34.81,35.16,34.62,33.19,32.38,31.78,29.09,29.94,30.78,30.91,31.81,31.03,30.62,30.62,30.34,30.09,30.66,33.31,32.12,33.59,31.97,32.31,30.56,28.47,27.19,27.53,27.78,28.06,28.84,30.0,29.97,29.69,28.31,26.75,25.59,26.12,26.38,26.94,29.28,30.53,30.34,30.34,32.31,31.56,31.22,29.56,31.12,29.38,29.81,28.84,29.66,29.31,27.25,26.78,28.38,26.75,28.31,29.78,30.91,32.53,33.19,32.94,33.62,33.59,32.41,32.19,31.12,30.19,26.25,25.75,22.72,21.12,20.53,20.03,20.16,19.25,19.16,16.97,16.41,20.28,21.84,26.91,34.69,38.38,42.19,45.91,45.44,45.19,44.28,43.56,41.81,41.66,38.97,36.56,34.28,31.06,29.69,29.69,29.72,30.72,31.69,34.0,34.94,34.69,37.06,38.0,38.69,39.0,39.66,38.41,35.44,34.62,31.19,29.5,26.88,26.81,25.62,25.69,26.06,27.41,27.12,28.88,28.91,27.25,27.62,25.19,23.19,22.56,22.5,23.19,25.31,27.69,30.53,34.0,36.44,38.53,38.66,38.38,37.25,36.06,33.25,33.0,34.28,33.59,34.06,35.94,36.41,34.88,32.56,31.84,28.5,27.44,25.53,24.06,24.0,22.66,22.62,23.16,25.06,25.72,27.34,27.0,27.56,26.19,23.81,22.41,22.16,19.06,17.78,16.66,15.44,13.81,15.47,14.69,16.31,17.31,18.47,17.88,13.81,16.81,15.88,17.28,19.38,22.59,21.97,21.41,18.94,17.38,15.56,13.78,13.66,14.62,13.44,14.03,13.53,13.16,8.91,10.41,11.0,12.06,13.56,17.41,17.56,17.62,19.81,19.62,20.0,20.84,19.94,20.31,20.81,21.34,22.06,24.97,25.81,27.06,28.62,28.69,28.53,28.41,28.5,29.16,30.31,31.81,33.84,36.66,35.53,35.5,35.31,33.09,31.0,29.91,27.88,27.44,26.12,24.72,25.06,24.75,24.75,25.66,28.69,29.78,31.75,34.81,35.31,36.53,36.47,34.78,33.69,31.91,30.53,30.69,30.31,31.25,30.22,27.22,26.16,21.91,20.28,19.12,18.06,18.28,17.06,17.19,17.81,15.38,14.34,15.16,12.44,13.44,12.12,14.38,15.72,18.69,20.81,24.16,24.94,26.16,25.97,24.53,24.44,24.78,23.25,26.41,27.81,30.12,33.12,36.5,35.75,34.69,33.25,29.06,23.62,17.94,19.12,16.72,19.47,24.78,28.03,31.69,33.44,34.06,35.06,34.0,32.72,31.25,30.53,27.62,27.41,26.5,27.16,24.12,26.03,26.19,26.91,30.0,29.62,32.28,32.47,33.03,32.09,32.84,32.62,32.62,30.19,30.88,30.0,30.31,30.59,30.69,31.25,30.88,29.5,30.06,29.5,31.53,31.31,33.38,32.38,33.28,33.41,33.75,35.56,36.41,37.53,37.97,39.91,39.25,39.66,40.94,40.44,39.94,38.19,36.78,35.22,33.88,30.94,29.44,26.56,24.94,23.44,22.81,21.72,22.34,23.25,24.19,24.72,27.88,29.31,31.25,30.75,29.44,28.38,25.66,23.62,22.59,22.16,19.94,18.56,18.56,17.53,18.28,18.56,19.44,20.66,19.81,17.78,19.81,19.69,19.88,19.78,19.91,18.06,16.25,15.12,13.25,13.78,13.62,13.41,15.44,18.0,18.81,22.38,24.41,25.94,27.53,29.78,30.88,31.91,33.38,33.41,32.94,31.44,30.56,28.81,27.28,26.44,25.75,23.62,22.69,21.47,20.47,22.62,23.16,23.78,29.56,27.91,30.34,29.28,29.16,27.47,26.16,24.5,22.56,23.38,21.84,23.72,24.97,26.03,29.69,29.94,29.72,30.16,28.0,25.66,23.53,22.44,20.16,18.94,18.62,18.06,18.91,20.06,20.88,22.38,22.47,22.06,21.94,21.66,22.12,21.62,23.34,24.09,24.03,25.47,25.19,25.06,24.91,23.38,21.28,20.44,18.31,16.69,16.59,14.59,15.12,14.81,16.16,17.91,20.19,21.09,23.78,24.06,26.59,26.34,28.09,30.56,31.47,34.0,35.91,36.25,35.94,33.31,30.56,28.5,25.16,24.81,24.03,24.0,24.34,25.91,24.84,24.97,26.56,25.69,25.94,-14.03,-13.28,-10.62,-8.75,-7.47,-5.84,-5.47,-5.34,-5.78,-7.38,-6.78,-7.16,-7.81,-7.72,-8.84,-11.25,-12.59,-16.34,-15.44,-15.78,-14.53,-12.34,-11.41,-9.22:30.62,29.75,28.62,28.59,26.94,25.25,23.12,22.5,23.16,23.66,26.78,31.03,34.81,38.56,41.62,41.03,43.56,42.94,43.0,43.81,44.62,46.31,46.94,48.16,48.06,47.41,48.97,46.78,46.31,44.19,40.56,36.75,33.12,31.19,28.59,29.16,28.34,28.38,28.28,27.69,28.09,27.25,26.03,26.28,24.62,23.59,23.53,25.66,27.41,31.06,33.72,35.75,36.41,35.69,34.41,32.5,30.25,30.69,29.09,29.38,30.56,29.25,31.41,32.94,35.41,37.91,40.59,42.62,42.28,42.0,39.12,37.31,35.06,32.25,31.28,30.31,28.44,27.0,25.56,24.31,23.03,22.97,21.91,24.19,26.59,27.53,31.69,33.0,32.94,33.25,31.94,31.25,30.88,30.19,30.97,30.56,29.88,29.66,30.06,29.06,30.72,31.72,31.28,31.66,31.62,29.41,28.5,26.78,24.34,24.31,22.81,23.56,20.91,23.44,25.25,26.31,30.41,32.56,32.78,34.34,32.53,32.72,33.16,33.03,33.91,32.91,32.69,32.12,32.19,31.28,31.84,31.94,32.03,31.28,29.38,27.66,26.28,24.94,26.09,26.28,27.25,26.5,28.81,28.59,28.56,28.28,28.09,24.44,21.22,21.03,18.56,18.91,20.25,21.75,22.34,23.69,23.06,22.34,22.66,22.38,23.22,25.31,27.53,29.41,32.16,32.41,31.09,30.75,29.62,27.75,27.72,28.75,28.47,25.66,27.78,24.75,26.09,28.25,29.25,30.75,32.88,32.19,31.06,31.34,27.34,26.62,24.66,24.16,26.53,28.91,31.41,35.06,36.69,36.81,37.06,36.31,35.69,34.94,35.25,33.78,33.34,31.94,29.56,29.56,26.91,28.53,27.44,28.81,31.53,34.03,38.66,44.12,49.31,53.19,53.31,52.78,48.94,43.38,38.88,33.41,29.66,28.88,26.84,27.94,28.47,29.28,30.31,28.81,27.16,29.88,27.78,28.44,31.62,33.0,35.41,37.62,38.53,39.28,37.78,36.22,33.62,31.94,29.69,31.12,30.03,32.56,33.84,33.91,35.72,35.31,35.78,33.88,34.38,32.31,30.62,30.34,30.44,32.78,34.62,36.56,38.25,39.91,39.81,40.09,40.69,39.62,40.28,39.28,39.28,37.72,37.16,35.31,34.69,33.91,34.31,35.81,37.78,40.0,43.38,44.88,44.81,45.91,45.78,43.59,41.78,39.66,38.06,34.62,32.59,32.22,30.91,31.22,28.94,27.28,27.03,25.38,24.06,24.28,24.53,23.16,22.72,22.66,22.09,21.88,25.31,27.94,31.41,33.19,34.66,33.09,31.69,30.69,28.88,28.56,29.75,30.03,31.53,30.84,32.16,30.84,31.91,32.34,33.12,33.91,33.34,30.81,28.34,28.75,27.66,29.62,31.34,33.0,34.22,34.72,34.47,32.56,33.69,33.44,31.97,31.34,31.91,29.19,30.09,29.41,29.16,30.44,30.16,32.41,33.81,34.66,36.22,37.34,37.91,37.69,39.0,39.97,38.69,38.91,38.38,37.19,34.81,35.16,34.62,33.19,32.38,31.78,29.09,29.94,30.78,30.91,31.81,31.03,30.62,30.62,30.34,30.09,30.66,33.31,32.12,33.59,31.97,32.31,30.56,28.47,27.19,27.53,27.78,28.06,28.84,30.0,29.97,29.69,28.31,26.75,25.59,26.12,26.38,26.94,29.28,30.53,30.34,30.34,32.31,31.56,31.22,29.56,31.12,29.38,29.81,28.84,29.66,29.31,27.25,26.78,28.38,26.75,28.31,29.78,30.91,32.53,33.19,32.94,33.62,33.59,32.41,32.19,31.12,30.19,26.25,25.75,22.72,21.12,20.53,20.03,20.16,19.25,19.16,16.97,16.41,20.28,21.84,26.91,34.69,38.38,42.19,45.91,45.44,45.19,44.28,43.56,41.81,41.66,38.97,36.56,34.28,31.06,29.69,29.69,29.72,30.72,31.69,34.0,34.94,34.69,37.06,38.0,38.69,39.0,39.66,38.41,35.44,34.62,31.19,29.5,26.88,26.81,25.62,25.69,26.06,27.41,27.12,28.88,28.91,27.25,27.62,25.19,23.19,22.56,22.5,23.19,25.31,27.69,30.53,34.0,36.44,38.53,38.66,38.38,37.25,36.06,33.25,33.0,34.28,33.59,34.06,35.94,36.41,34.88,32.56,31.84,28.5,27.44,25.53,24.06,24.0,22.66,22.62,23.16,25.06,25.72,27.34,27.0,27.56,26.19,23.81,22.41,22.16,19.06,17.78,16.66,15.44,13.81,15.47,14.69,16.31,17.31,18.47,17.88,13.81,16.81,15.88,17.28,19.38,22.59,21.97,21.41,18.94,17.38,15.56,13.78,13.66,14.62,13.44,14.03,13.53,13.16,8.91,10.41,11.0,12.06,13.56,17.41,17.56,17.62,19.81,19.62,20.0,20.84,19.94,20.31,20.81,21.34,22.06,24.97,25.81,27.06,28.62,28.69,28.53,28.41,28.5,29.16,30.31,31.81,33.84,36.66,35.53,35.5,35.31,33.09,31.0,29.91,27.88,27.44,26.12,24.72,25.06,24.75,24.75,25.66,28.69,29.78,31.75,34.81,35.31,36.53,36.47,34.78,33.69,31.91,30.53,30.69,30.31,31.25,30.22,27.22,26.16,21.91,20.28,19.12,18.06,18.28,17.06,17.19,17.81,15.38,14.34,15.16,12.44,13.44,12.12,14.38,15.72,18.69,20.81,24.16,24.94,26.16,25.97,24.53,24.44,24.78,23.25,26.41,27.81,30.12,33.12,36.5,35.75,34.69,33.25,29.06,23.62,17.94,19.12,16.72,19.47,24.78,28.03,31.69,33.44,34.06,35.06,34.0,32.72,31.25,30.53,27.62,27.41,26.5,27.16,24.12,26.03,26.19,26.91,30.0,29.62,32.28,32.47,33.03,32.09,32.84,32.62,32.62,30.19,30.88,30.0,30.31,30.59,30.69,31.25,30.88,29.5,30.06,29.5,31.53,31.31,33.38,32.38,33.28,33.41,33.75,35.56,36.41,37.53,37.97,39.91,39.25,39.66,40.94,40.44,39.94,38.19,36.78,35.22,33.88,30.94,29.44,26.56,24.94,23.44,22.81,21.72,22.34,23.25,24.19,24.72,27.88,29.31,31.25,30.75,29.44,28.38,25.66,23.62,22.59,22.16,19.94,18.56,18.56,17.53,18.28,18.56,19.44,20.66,19.81,17.78,19.81,19.69,19.88,19.78,19.91,18.06,16.25,15.12,13.25,13.78,13.62,13.41,15.44,18.0,18.81,22.38,24.41,25.94,27.53,29.78,30.88,31.91,33.38,33.41,32.94,31.44,30.56,28.81,27.28,26.44,25.75,23.62,22.69,21.47,20.47,22.62,23.16,23.78,29.56,27.91,30.34,29.28,29.16,27.47,26.16,24.5,22.56,23.38,21.84,23.72,24.97,26.03,29.69,29.94,29.72,30.16,28.0,25.66,23.53,22.44,20.16,18.94,18.62,18.06,18.91,20.06,20.88,22.38,22.47,22.06,21.94,21.66,22.12,21.62,23.34,24.09,24.03,25.47,25.19,25.06,24.91,23.38,21.28,20.44,18.31,16.69,16.59,14.59,15.12,14.81,16.16,17.91,20.19,21.09,23.78,24.06,26.59,26.34,28.09,30.56,31.47,34.0,35.91,36.25,35.94,33.31,30.56,28.5,25.16,24.81,24.03,24.0,24.34,25.91,24.84,24.97,26.56,25.69,25.94,-14.03,-13.28,-10.62,-8.75,-7.47,-5.84,-5.47,-5.34,-5.78,-7.38,-6.78,-7.16,-7.81,-7.72,-8.84,-11.25,-12.59,-16.34,-15.44,-15.78,-14.53,-12.34,-11.41,-9.22,-9.34,-9.34,-9.53,-8.12,-8.44,-7.16:negativity
27.81,27.5,26.06,25.78,26.25,27.19,28.88,29.38,30.44,29.84,27.88,24.72,23.06,19.44,16.94,15.88,15.41,15.25,16.12,18.56,21.31,23.69,25.69,26.56,26.38,25.78,23.94,23.97,24.88,26.16,27.94,30.0,31.53,32.28,32.84,32.28,31.72,31.69,29.97,28.66,27.41,26.22,25.06,24.38,24.06,22.12,22.53,21.69,23.59,24.41,27.69,30.72,33.69,35.41,37.22,38.34,36.91,37.06,37.25,35.34,34.19,32.34,30.81,27.56,25.78,23.12,21.03,19.19,16.12,13.31,11.03,6.94,5.5,4.69,3.62,3.22,3.25,3.34,4.34,5.31,6.31,8.41,11.47,14.31,17.28,20.31,24.53,25.84,28.06,30.34,31.5,30.94,32.5,33.78,35.16,36.12,38.44,40.34,39.75,40.25,38.69,37.28,35.44,32.62,31.25,29.78,29.12,28.78,28.44,28.59,28.12,27.5,26.56,25.12,24.38,23.44,21.44,22.41,22.34,23.19,23.22,23.44,23.06,22.03,21.28,19.69,18.12,17.84,16.38,17.62,15.94,15.25,14.91,13.38,12.94,12.66,14.22,14.44,14.91,16.16,15.62,15.31,15.53,15.41,16.16,17.09,17.12,16.44,15.34,13.69,10.66,9.31,7.44,7.75,6.84,7.47,8.34,10.62,12.03,14.38,17.78,19.84,20.91,22.91,24.44,25.81,27.34,29.06,29.66,27.19,25.47,23.34,19.31,18.03,16.0,15.56,15.34,15.25,15.44,17.06,19.81,22.41,25.94,29.81,30.56,31.72,29.31,27.5,24.56,21.44,18.94,18.19,19.06,20.31,21.53,23.06,25.34,25.69,26.31,27.12,26.31,26.19,23.03,23.5,21.97,20.56,20.62,19.41,17.5,16.03,14.84,14.81,14.22,14.44,15.53,16.12,17.38,18.78,21.25,22.44,24.44,26.69,27.31,25.94,26.62,25.81,25.0,24.91,23.34,22.5,22.56,22.16,22.81,23.0,26.31,26.25,26.94,28.16,27.88,25.06,24.19,22.75,21.12,21.31,22.09,23.81,26.81,29.5,31.81,33.25,33.03,31.91,29.12,26.91,25.19,23.56,23.38,23.66,23.62,23.81,22.72,22.28,22.12,20.06,20.03,18.91,18.12,18.22,18.84,19.94,23.03,23.06,25.97,26.81,27.94,28.66,29.03,27.38,24.69,22.16,17.56,15.03,11.97,10.94,10.38,9.06,9.47,9.84,10.66,11.09,12.03,13.44,14.88,17.34,17.81,21.28,23.34,25.47,27.97,29.38,31.62,29.94,28.19,27.0,25.53,25.03,25.38,27.78,29.56,30.22,30.78,30.69,30.53,31.28,31.78,31.91,32.69,33.47,34.72,35.25,36.91,37.06,36.69,37.09,35.66,34.75,34.16,35.19,34.94,36.06,38.5,39.97,40.78,42.25,41.44,41.28,40.41,38.91,37.84,36.16,33.72,32.62,31.62,30.44,31.75,31.81,31.34,32.19,31.53,30.81,30.94,29.91,29.81,28.47,27.41,26.03,24.97,23.28,22.44,22.41,21.78,21.91,23.31,24.16,25.78,28.81,29.78,32.22,34.44,36.0,36.56,36.25,34.94,31.31,27.47,22.81,18.78,15.53,13.19,13.44,13.34,14.62,15.5,17.0,15.72,16.69,16.09,16.16,16.09,18.16,18.19,17.34,18.03,17.03,15.66,16.12,14.91,14.5,14.38,14.12,14.25,13.53,13.12,12.84,11.38,10.25,9.72,8.16,7.34,4.81,4.69,5.81,7.34,10.31,13.81,15.66,16.94,15.78,14.84,13.19,12.5,12.09,12.25,12.84,13.62,13.75,14.41,14.16,14.75,16.44,16.31,20.31,21.47,23.41,23.34,20.0,22.12,19.31,20.81,22.06,23.0,23.41,21.84,19.91,17.69,15.75,14.16,13.19,13.12,13.16,13.31,14.03,13.47,14.84,14.62,15.75,17.5,20.75,19.31,23.81,24.25,24.81,25.12,24.91,23.16,20.53,18.19,16.16,13.38,12.84,11.28,11.44,11.38,12.06,12.69,13.5,12.72,13.94,13.34,13.12,12.25,12.12,11.72,9.66,10.47,10.59,11.06,12.56,13.75,13.47,15.12,16.16,18.16,21.03,21.81,25.0,25.16,26.25,26.56,27.06,26.81,25.91,24.09,21.59,19.22,17.5,16.44,15.69,15.06,18.12,19.31,22.16,25.06,26.91,26.91,26.53,23.0,21.5,19.94,17.94,19.0,19.19,19.12,20.78,19.19,17.75,15.72,13.41,11.03,10.69,10.81,13.06,14.91,18.06,20.72,23.56,23.84,24.44,25.16,22.97,20.94,19.06,18.56,16.56,16.78,15.88,14.91,13.19,9.44,7.19,6.5,4.62,5.88,7.44,9.19,10.91,13.28,14.81,15.94,15.72,15.81,15.19,12.38,11.16,9.97,8.41,7.66,7.88,7.31,6.12,5.41,5.12,3.31,3.44,3.59,4.5,5.34,5.56,5.75,6.0,4.91,6.16,6.41,7.09,8.62,8.84,9.06,10.53,10.38,12.06,13.16,14.28,16.06,16.5,13.75,14.12,11.56,9.38,8.94,9.12,9.91,8.41,9.84,8.31,8.72,8.47,6.78,6.62,7.28,7.16,10.09,8.94,13.69,15.03,15.19,17.12,17.0,15.66,14.81,14.06,12.59,13.03,12.72,13.38,14.06,16.09,17.34,17.34,18.72,16.53,15.78,15.03,14.03,14.0,14.53,14.28,13.19,13.31,11.38,8.38,8.34,3.44,4.41,2.75,4.94,6.62,10.16,13.34,15.16,18.5,18.25,18.0,17.5,15.94,15.25,14.94,15.81,17.09,17.84,16.94,16.75,14.31,13.78,10.41,13.91,15.12,18.34,20.91,23.75,24.19,23.19,22.5,20.94,21.41,21.59,22.12,22.94,24.28,23.84,21.66,22.31,19.25,19.16,17.31,15.97,11.91,11.69,9.84,9.78,11.25,13.28,14.34,14.34,15.22,14.81,15.72,14.5,16.81,16.12,14.53,14.56,12.41,11.78,11.19,10.25,9.62,5.66,7.59,6.41,6.69,9.0,10.41,9.56,11.41,9.25,10.0,11.16,12.91,15.16,17.34,20.31,20.59,20.25,19.25,15.78,12.25,8.72,6.91,6.25,6.22,7.81,7.88,10.06,10.03,10.94,12.06,11.66,11.25,10.5,9.72,9.44,9.62,9.16,11.59,12.72,13.22,14.94,15.0,15.84,13.78,13.38,12.0,10.44,10.28,11.12,12.06,14.19,15.5,17.62,17.41,17.44,17.62,16.38,16.12,14.88,14.69,14.06,13.97,15.56,17.66,19.84,22.56,22.44,22.28,21.69,20.88,20.38,20.78,20.84,21.69,21.69,21.41,21.16,20.12,18.28,15.88,12.88,12.06,11.16,10.81,12.66,15.19,16.66,20.69,23.59,26.0,28.0,28.47,27.19,25.25,22.03,18.25,15.78,13.06,11.62,10.62,9.31,8.06,6.69,6.06,7.03,8.53,11.28,14.25,16.72,18.94,20.28,21.12,21.25,20.5,19.72,18.09,16.09,14.97,13.66,13.53,12.81,13.03,13.97,14.47,15.16,15.53,15.69,14.19,12.5,12.06,10.72,10.06,10.59,11.0,11.06,11.78,10.91,10.66,8.53,7.72,6.5,5.81,5.25,5.06,6.19,6.88,8.56,10.06,12.09,12.56,12.47,12.31,10.69,9.94,10.03,9.56,9.72,11.12,12.72,13.75,16.16,17.5,17.75,18.62,18.41,18.69,19.41,20.84,21.84,22.12,22.28,20.16,18.59,15.94,13.97,12.12,10.44,9.66,8.62,8.31,5.81,6.12,5.62,5.28,5.88,7.12,8.31,7.03,5.25,3.97:28.88,29.38,30.44,29.84,27.88,24.72,23.06,19.44,16.94,15.88,15.41,15.25,16.12,18.56,21.31,23.69,25.69,26.56,26.38,25.78,23.94,23.97,24.88,26.16,27.94,30.0,31.53,32.28,32.84,32.28,31.72,31.69,29.97,28.66,27.41,26.22,25.06,24.38,24.06,22.12,22.53,21.69,23.59,24.41,27.69,30.72,33.69,35.41,37.22,38.34,36.91,37.06,37.25,35.34,34.19,32.34,30.81,27.56,25.78,23.12,21.03,19.19,16.12,13.31,11.03,6.94,5.5,4.69,3.62,3.22,3.25,3.34,4.34,5.31,6.31,8.41,11.47,14.31,17.28,20.31,24.53,25.84,28.06,30.34,31.5,30.94,32.5,33.78,35.16,36.12,38.44,40.34,39.75,40.25,38.69,37.28,35.44,32.62,31.25,29.78,29.12,28.78,28.44,28.59,28.12,27.5,26.56,25.12,24.38,23.44,21.44,22.41,22.34,23.19,23.22,23.44,23.06,22.03,21.28,19.69,18.12,17.84,16.38,17.62,15.94,15.25,14.91,13.38,12.94,12.66,14.22,14.44,14.91,16.16,15.62,15.31,15.53,15.41,16.16,17.09,17.12,16.44,15.34,13.69,10.66,9.31,7.44,7.75,6.84,7.47,8.34,10.62,12.03,14.38,17.78,19.84,20.91,22.91,24.44,25.81,27.34,29.06,29.66,27.19,25.47,23.34,19.31,18.03,16.0,15.56,15.34,15.25,15.44,17.06,19.81,22.41,25.94,29.81,30.56,31.72,29.31,27.5,24.56,21.44,18.94,18.19,19.06,20.31,21.53,23.06,25.34,25.69,26.31,27.12,26.31,26.19,23.03,23.5,21.97,20.56,20.62,19.41,17.5,16.03,14.84,14.81,14.22,14.44,15.53,16.12,17.38,18.78,21.25,22.44,24.44,26.69,27.31,25.94,26.62,25.81,25.0,24.91,23.34,22.5,22.56,22.16,22.81,23.0,26.31,26.25,26.94,28.16,27.88,25.06,24.19,22.75,21.12,21.31,22.09,23.81,26.81,29.5,31.81,33.25,33.03,31.91,29.12,26.91,25.19,23.56,23.38,23.66,23.62,23.81,22.72,22.28,22.12,20.06,20.03,18.91,18.12,18.22,18.84,19.94,23.03,23.06,25.97,26.81,27.94,28.66,29.03,27.38,24.69,22.16,17.56,15.03,11.97,10.94,10.38,9.06,9.47,9.84,10.66,11.09,12.03,13.44,14.88,17.34,17.81,21.28,23.34,25.47,27.97,29.38,31.62,29.94,28.19,27.0,25.53,25.03,25.38,27.78,29.56,30.22,30.78,30.69,30.53,31.28,31.78,31.91,32.69,33.47,34.72,35.25,36.91,37.06,36.69,37.09,35.66,34.75,34.16,35.19,34.94,36.06,38.5,39.97,40.78,42.25,41.44,41.28,40.41,38.91,37.84,36.16,33.72,32.62,31.62,30.44,31.75,31.81,31.34,32.19,31.53,30.81,30.94,29.91,29.81,28.47,27.41,26.03,24.97,23.28,22.44,22.41,21.78,21.91,23.31,24.16,25.78,28.81,29.78,32.22,34.44,36.0,36.56,36.25,34.94,31.31,27.47,22.81,18.78,15.53,13.19,13.44,13.34,14.62,15.5,17.0,15.72,16.69,16.09,16.16,16.09,18.16,18.19,17.34,18.03,17.03,15.66,16.12,14.91,14.5,14.38,14.12,14.25,13.53,13.12,12.84,11.38,10.25,9.72,8.16,7.34,4.81,4.69,5.81,7.34,10.31,13.81,15.66,16.94,15.78,14.84,13.19,12.5,12.09,12.25,12.84,13.62,13.75,14.41,14.16,14.75,16.44,16.31,20.31,21.47,23.41,23.34,20.0,22.12,19.31,20.81,22.06,23.0,23.41,21.84,19.91,17.69,15.75,14.16,13.19,13.12,13.16,13.31,14.03,13.47,14.84,14.62,15.75,17.5,20.75,19.31,23.81,24.25,24.81,25.12,24.91,23.16,20.53,18.19,16.16,13.38,12.84,11.28,11.44,11.38,12.06,12.69,13.5,12.72,13.94,13.34,13.12,12.25,12.12,11.72,9.66,10.47,10.59,11.06,12.56,13.75,13.47,15.12,16.16,18.16,21.03,21.81,25.0,25.16,26.25,26.56,27.06,26.81,25.91,24.09,21.59,19.22,17.5,16.44,15.69,15.06,18.12,19.31,22.16,25.06,26.91,26.91,26.53,23.0,21.5,19.94,17.94,19.0,19.19,19.12,20.78,19.19,17.75,15.72,13.41,11.03,10.69,10.81,13.06,14.91,18.06,20.72,23.56,23.84,24.44,25.16,22.97,20.94,19.06,18.56,16.56,16.78,15.88,14.91,13.19,9.44,7.19,6.5,4.62,5.88,7.44,9.19,10.91,13.28,14.81,15.94,15.72,15.81,15.19,12.38,11.16,9.97,8.41,7.66,7.88,7.31,6.12,5.41,5.12,3.31,3.44,3.59,4.5,5.34,5.56,5.75,6.0,4.91,6.16,6.41,7.09,8.62,8.84,9.06,10.53,10.38,12.06,13.16,14.28,16.06,16.5,13.75,14.12,11.56,9.38,8.94,9.12,9.91,8.41,9.84,8.31,8.72,8.47,6.78,6.62,7.28,7.16,10.09,8.94,13.69,15.03,15.19,17.12,17.0,15.66,14.81,14.06,12.59,13.03,12.72,13.38,14.06,16.09,17.34,17.34,18.72,16.53,15.78,15.03,14.03,14.0,14.53,14.28,13.19,13.31,11.38,8.38,8.34,3.44,4.41,2.75,4.94,6.62,10.16,13.34,15.16,18.5,18.25,18.0,17.5,15.94,15.25,14.94,15.81,17.09,17.84,16.94,16.75,14.31,13.78,10.41,13.91,15.12,18.34,20.91,23.75,24.19,23.19,22.5,20.94,21.41,21.59,22.12,22.94,24.28,23.84,21.66,22.31,19.25,19.16,17.31,15.97,11.91,11.69,9.84,9.78,11.25,13.28,14.34,14.34,15.22,14.81,15.72,14.5,16.81,16.12,14.53,14.56,12.41,11.78,11.19,10.25,9.62,5.66,7.59,6.41,6.69,9.0,10.41,9.56,11.41,9.25,10.0,11.16,12.91,15.16,17.34,20.31,20.59,20.25,19.25,15.78,12.25,8.72,6.91,6.25,6.22,7.81,7.88,10.06,10.03,10.94,12.06,11.66,11.25,10.5,9.72,9.44,9.62,9.16,11.59,12.72,13.22,14.94,15.0,15.84,13.78,13.38,12.0,10.44,10.28,11.12,12.06,14.19,15.5,17.62,17.41,17.44,17.62,16.38,16.12,14.88,14.69,14.06,13.97,15.56,17.66,19.84,22.56,22.44,22.28,21.69,20.88,20.38,20.78,20.84,21.69,21.69,21.41,21.16,20.12,18.28,15.88,12.88,12.06,11.16,10.81,12.66,15.19,16.66,20.69,23.59,26.0,28.0,28.47,27.19,25.25,22.03,18.25,15.78,13.06,11.62,10.62,9.31,8.06,6.69,6.06,7.03,8.53,11.28,14.25,16.72,18.94,20.28,21.12,21.25,20.5,19.72,18.09,16.09,14.97,13.66,13.53,12.81,13.03,13.97,14.47,15.16,15.53,15.69,14.19,12.5,12.06,10.72,10.06,10.59,11.0,11.06,11.78,10.91,10.66,8.53,7.72,6.5,5.81,5.25,5.06,6.19,6.88,8.56,10.06,12.09,12.56,12.47,12.31,10.69,9.94,10.03,9.56,9.72,11.12,12.72,13.75,16.16,17.5,17.75,18.62,18.41,18.69,19.41,20.84,21.84,22.12,22.28,20.16,18.59,15.94,13.97,12.12,10.44,9.66,8.62,8.31,5.81,6.12,5.62,5.28,5.88,7.12,8.31,7.03,5.25,3.97,-21.03,-20.16,-21.22,-21.47,-21.44,-21.22:23.06,19.44,16.94,15.88,15.41,15.25,16.12,18.56,21.31,23.69,25.69,26.56,26.38,25.78,23.94,23.97,24.88,26.16,27.94,30.0,31.53,32.28,32.84,32.28,31.72,31.69,29.97,28.66,27.41,26.22,25.06,24.38,24.06,22.12,22.53,21.69,23.59,24.41,27.69,30.72,33.69,35.41,37.22,38.34,36.91,37.06,37.25,35.34,34.19,32.34,30.81,27.56,25.78,23.12,21.03,19.19,16.12,13.31,11.03,6.94,5.5,4.69,3.62,3.22,3.25,3.34,4.34,5.31,6.31,8.41,11.47,14.31,17.28,20.31,24.53,25.84,28.06,30.34,31.5,30.94,32.5,33.78,35.16,36.12,38.44,40.34,39.75,40.25,38.69,37.28,35.44,32.62,31.25,29.78,29.12,28.78,28.44,28.59,28.12,27.5,26.56,25.12,24.38,23.44,21.44,22.41,22.34,23.19,23.22,23.44,23.06,22.03,21.28,19.69,18.12,17.84,16.38,17.62,15.94,15.25,14.91,13.38,12.94,12.66,14.22,14.44,14.91,16.16,15.62,15.31,15.53,15.41,16.16,17.09,17.12,16.44,15.34,13.69,10.66,9.31,7.44,7.75,6.84,7.47,8.34,10.62,12.03,14.38,17.78,19.84,20.91,22.91,24.44,25.81,27.34,29.06,29.66,27.19,25.47,23.34,19.31,18.03,16.0,15.56,15.34,15.25,15.44,17.06,19.81,22.41,25.94,29.81,30.56,31.72,29.31,27.5,24.56,21.44,18.94,18.19,19.06,20.31,21.53,23.06,25.34,25.69,26.31,27.12,26.31,26.19,23.03,23.5,21.97,20.56,20.62,19.41,17.5,16.03,14.84,14.81,14.22,14.44,15.53,16.12,17.38,18.78,21.25,22.44,24.44,26.69,27.31,25.94,26.62,25.81,25.0,24.91,23.34,22.5,22.56,22.16,22.81,23.0,26.31,26.25,26.94,28.16,27.88,25.06,24.19,22.75,21.12,21.31,22.09,23.81,26.81,29.5,31.81,33.25,33.03,31.91,29.12,26.91,25.19,23.56,23.38,23.66,23.62,23.81,22.72,22.28,22.12,20.06,20.03,18.91,18.12,18.22,18.84,19.94,23.03,23.06,25.97,26.81,27.94,28.66,29.03,27.38,24.69,22.16,17.56,15.03,11.97,10.94,10.38,9.06,9.47,9.84,10.66,11.09,12.03,13.44,14.88,17.34,17.81,21.28,23.34,25.47,27.97,29.38,31.62,29.94,28.19,27.0,25.53,25.03,25.38,27.78,29.56,30.22,30.78,30.69,30.53,31.28,31.78,31.91,32.69,33.47,34.72,35.25,36.91,37.06,36.69,37.09,35.66,34.75,34.16,35.19,34.94,36.06,38.5,39.97,40.78,42.25,41.44,41.28,40.41,38.91,37.84,36.16,33.72,32.62,31.62,30.44,31.75,31.81,31.34,32.19,31.53,30.81,30.94,29.91,29.81,28.47,27.41,26.03,24.97,23.28,22.44,22.41,21.78,21.91,23.31,24.16,25.78,28.81,29.78,32.22,34.44,36.0,36.56,36.25,34.94,31.31,27.47,22.81,18.78,15.53,13.19,13.44,13.34,14.62,15.5,17.0,15.72,16.69,16.09,16.16,16.09,18.16,18.19,17.34,18.03,17.03,15.66,16.12,14.91,14.5,14.38,14.12,14.25,13.53,13.12,12.84,11.38,10.25,9.72,8.16,7.34,4.81,4.69,5.81,7.34,10.31,13.81,15.66,16.94,15.78,14.84,13.19,12.5,12.09,12.25,12.84,13.62,13.75,14.41,14.16,14.75,16.44,16.31,20.31,21.47,23.41,23.34,20.0,22.12,19.31,20.81,22.06,23.0,23.41,21.84,19.91,17.69,15.75,14.16,13.19,13.12,13.16,13.31,14.03,13.47,14.84,14.62,15.75,17.5,20.75,19.31,23.81,24.25,24.81,25.12,24.91,23.16,20.53,18.19,16.16,13.38,12.84,11.28,11.44,11.38,12.06,12.69,13.5,12.72,13.94,13.34,13.12,12.25,12.12,11.72,9.66,10.47,10.59,11.06,12.56,13.75,13.47,15.12,16.16,18.16,21.03,21.81,25.0,25.16,26.25,26.56,27.06,26.81,25.91,24.09,21.59,19.22,17.5,16.44,15.69,15.06,18.12,19.31,22.16,25.06,26.91,26.91,26.53,23.0,21.5,19.94,17.94,19.0,19.19,19.12,20.78,19.19,17.75,15.72,13.41,11.03,10.69,10.81,13.06,14.91,18.06,20.72,23.56,23.84,24.44,25.16,22.97,20.94,19.06,18.56,16.56,16.78,15.88,14.91,13.19,9.44,7.19,6.5,4.62,5.88,7.44,9.19,10.91,13.28,14.81,15.94,15.72,15.81,15.19,12.38,11.16,9.97,8.41,7.66,7.88,7.31,6.12,5.41,5.12,3.31,3.44,3.59,4.5,5.34,5.56,5.75,6.0,4.91,6.16,6.41,7.09,8.62,8.84,9.06,10.53,10.38,12.06,13.16,14.28,16.06,16.5,13.75,14.12,11.56,9.38,8.94,9.12,9.91,8.41,9.84,8.31,8.72,8.47,6.78,6.62,7.28,7.16,10.09,8.94,13.69,15.03,15.19,17.12,17.0,15.66,14.81,14.06,12.59,13.03,12.72,13.38,14.06,16.09,17.34,17.34,18.72,16.53,15.78,15.03,14.03,14.0,14.53,14.28,13.19,13.31,11.38,8.38,8.34,3.44,4.41,2.75,4.94,6.62,10.16,13.34,15.16,18.5,18.25,18.0,17.5,15.94,15.25,14.94,15.81,17.09,17.84,16.94,16.75,14.31,13.78,10.41,13.91,15.12,18.34,20.91,23.75,24.19,23.19,22.5,20.94,21.41,21.59,22.12,22.94,24.28,23.84,21.66,22.31,19.25,19.16,17.31,15.97,11.91,11.69,9.84,9.78,11.25,13.28,14.34,14.34,15.22,14.81,15.72,14.5,16.81,16.12,14.53,14.56,12.41,11.78,11.19,10.25,9.62,5.66,7.59,6.41,6.69,9.0,10.41,9.56,11.41,9.25,10.0,11.16,12.91,15.16,17.34,20.31,20.59,20.25,19.25,15.78,12.25,8.72,6.91,6.25,6.22,7.81,7.88,10.06,10.03,10.94,12.06,11.66,11.25,10.5,9.72,9.44,9.62,9.16,11.59,12.72,13.22,14.94,15.0,15.84,13.78,13.38,12.0,10.44,10.28,11.12,12.06,14.19,15.5,17.62,17.41,17.44,17.62,16.38,16.12,14.88,14.69,14.06,13.97,15.56,17.66,19.84,22.56,22.44,22.28,21.69,20.88,20.38,20.78,20.84,21.69,21.69,21.41,21.16,20.12,18.28,15.88,12.88,12.06,11.16,10.81,12.66,15.19,16.66,20.69,23.59,26.0,28.0,28.47,27.19,25.25,22.03,18.25,15.78,13.06,11.62,10.62,9.31,8.06,6.69,6.06,7.03,8.53,11.28,14.25,16.72,18.94,20.28,21.12,21.25,20.5,19.72,18.09,16.09,14.97,13.66,13.53,12.81,13.03,13.97,14.47,15.16,15.53,15.69,14.19,12.5,12.06,10.72,10.06,10.59,11.0,11.06,11.78,10.91,10.66,8.53,7.72,6.5,5.81,5.25,5.06,6.19,6.88,8.56,10.06,12.09,12.56,12.47,12.31,10.69,9.94,10.03,9.56,9.72,11.12,12.72,13.75,16.16,17.5,17.75,18.62,18.41,18.69,19.41,20.84,21.84,22.12,22.28,20.16,18.59,15.94,13.97,12.12,10.44,9.66,8.62,8.31,5.81,6.12,5.62,5.28,5.88,7.12,8.31,7.03,5.25,3.97,-21.03,-20.16,-21.22,-21.47,-21.44,-21.22,-20.97,-19.94,-20.19,-20.56,-23.0,-25.25:16.12,18.56,21.31,23.69,25.69,26.56,26.38,25.78,23.94,23.97,24.88,26.16,27.94,30.0,31.53,32.28,32.84,32.28,31.72,31.69,29.97,28.66,27.41,26.22,25.06,24.38,24.06,22.12,22.53,21.69,23.59,24.41,27.69,30.72,33.69,35.41,37.22,38.34,36.91,37.06,37.25,35.34,34.19,32.34,30.81,27.56,25.78,23.12,21.03,19.19,16.12,13.31,11.03,6.94,5.5,4.69,3.62,3.22,3.25,3.34,4.34,5.31,6.31,8.41,11.47,14.31,17.28,20.31,24.53,25.84,28.06,30.34,31.5,30.94,32.5,33.78,35.16,36.12,38.44,40.34,39.75,40.25,38.69,37.28,35.44,32.62,31.25,29.78,29.12,28.78,28.44,28.59,28.12,27.5,26.56,25.12,24.38,23.44,21.44,22.41,22.34,23.19,23.22,23.44,23.06,22.03,21.28,19.69,18.12,17.84,16.38,17.62,15.94,15.25,14.91,13.38,12.94,12.66,14.22,14.44,14.91,16.16,15.62,15.31,15.53,15.41,16.16,17.09,17.12,16.44,15.34,13.69,10.66,9.31,7.44,7.75,6.84,7.47,8.34,10.62,12.03,14.38,17.78,19.84,20.91,22.91,24.44,25.81,27.34,29.06,29.66,27.19,25.47,23.34,19.31,18.03,16.0,15.56,15.34,15.25,15.44,17.06,19.81,22.41,25.94,29.81,30.56,31.72,29.31,27.5,24.56,21.44,18.94,18.19,19.06,20.31,21.53,23.06,25.34,25.69,26.31,27.12,26.31,26.19,23.03,23.5,21.97,20.56,20.62,19.41,17.5,16.03,14.84,14.81,14.22,14.44,15.53,16.12,17.38,18.78,21.25,22.44,24.44,26.69,27.31,25.94,26.62,25.81,25.0,24.91,23.34,22.5,22.56,22.16,22.81,23.0,26.31,26.25,26.94,28.16,27.88,25.06,24.19,22.75,21.12,21.31,22.09,23.81,26.81,29.5,31.81,33.25,33.03,31.91,29.12,26.91,25.19,23.56,23.38,23.66,23.62,23.81,22.72,22.28,22.12,20.06,20.03,18.91,18.12,18.22,18.84,19.94,23.03,23.06,25.97,26.81,27.94,28.66,29.03,27.38,24.69,22.16,17.56,15.03,11.97,10.94,10.38,9.06,9.47,9.84,10.66,11.09,12.03,13.44,14.88,17.34,17.81,21.28,23.34,25.47,27.97,29.38,31.62,29.94,28.19,27.0,25.53,25.03,25.38,27.78,29.56,30.22,30.78,30.69,30.53,31.28,31.78,31.91,32.69,33.47,34.72,35.25,36.91,37.06,36.69,37.09,35.66,34.75,34.16,35.19,34.94,36.06,38.5,39.97,40.78,42.25,41.44,41.28,40.41,38.91,37.84,36.16,33.72,32.62,31.62,30.44,31.75,31.81,31.34,32.19,31.53,30.81,30.94,29.91,29.81,28.47,27.41,26.03,24.97,23.28,22.44,22.41,21.78,21.91,23.31,24.16,25.78,28.81,29.78,32.22,34.44,36.0,36.56,36.25,34.94,31.31,27.47,22.81,18.78,15.53,13.19,13.44,13.34,14.62,15.5,17.0,15.72,16.69,16.09,16.16,16.09,18.16,18.19,17.34,18.03,17.03,15.66,16.12,14.91,14.5,14.38,14.12,14.25,13.53,13.12,12.84,11.38,10.25,9.72,8.16,7.34,4.81,4.69,5.81,7.34,10.31,13.81,15.66,16.94,15.78,14.84,13.19,12.5,12.09,12.25,12.84,13.62,13.75,14.41,14.16,14.75,16.44,16.31,20.31,21.47,23.41,23.34,20.0,22.12,19.31,20.81,22.06,23.0,23.41,21.84,19.91,17.69,15.75,14.16,13.19,13.12,13.16,13.31,14.03,13.47,14.84,14.62,15.75,17.5,20.75,19.31,23.81,24.25,24.81,25.12,24.91,23.16,20.53,18.19,16.16,13.38,12.84,11.28,11.44,11.38,12.06,12.69,13.5,12.72,13.94,13.34,13.12,12.25,12.12,11.72,9.66,10.47,10.59,11.06,12.56,13.75,13.47,15.12,16.16,18.16,21.03,21.81,25.0,25.16,26.25,26.56,27.06,26.81,25.91,24.09,21.59,19.22,17.5,16.44,15.69,15.06,18.12,19.31,22.16,25.06,26.91,26.91,26.53,23.0,21.5,19.94,17.94,19.0,19.19,19.12,20.78,19.19,17.75,15.72,13.41,11.03,10.69,10.81,13.06,14.91,18.06,20.72,23.56,23.84,24.44,25.16,22.97,20.94,19.06,18.56,16.56,16.78,15.88,14.91,13.19,9.44,7.19,6.5,4.62,5.88,7.44,9.19,10.91,13.28,14.81,15.94,15.72,15.81,15.19,12.38,11.16,9.97,8.41,7.66,7.88,7.31,6.12,5.41,5.12,3.31,3.44,3.59,4.5,5.34,5.56,5.75,6.0,4.91,6.16,6.41,7.09,8.62,8.84,9.06,10.53,10.38,12.06,13.16,14.28,16.06,16.5,13.75,14.12,11.56,9.38,8.94,9.12,9.91,8.41,9.84,8.31,8.72,8.47,6.78,6.62,7.28,7.16,10.09,8.94,13.69,15.03,15.19,17.12,17.0,15.66,14.81,14.06,12.59,13.03,12.72,13.38,14.06,16.09,17.34,17.34,18.72,16.53,15.78,15.03,14.03,14.0,14.53,14.28,13.19,13.31,11.38,8.38,8.34,3.44,4.41,2.75,4.94,6.62,10.16,13.34,15.16,18.5,18.25,18.0,17.5,15.94,15.25,14.94,15.81,17.09,17.84,16.94,16.75,14.31,13.78,10.41,13.91,15.12,18.34,20.91,23.75,24.19,23.19,22.5,20.94,21.41,21.59,22.12,22.94,24.28,23.84,21.66,22.31,19.25,19.16,17.31,15.97,11.91,11.69,9.84,9.78,11.25,13.28,14.34,14.34,15.22,14.81,15.72,14.5,16.81,16.12,14.53,14.56,12.41,11.78,11.19,10.25,9.62,5.66,7.59,6.41,6.69,9.0,10.41,9.56,11.41,9.25,10.0,11.16,12.91,15.16,17.34,20.31,20.59,20.25,19.25,15.78,12.25,8.72,6.91,6.25,6.22,7.81,7.88,10.06,10.03,10.94,12.06,11.66,11.25,10.5,9.72,9.44,9.62,9.16,11.59,12.72,13.22,14.94,15.0,15.84,13.78,13.38,12.0,10.44,10.28,11.12,12.06,14.19,15.5,17.62,17.41,17.44,17.62,16.38,16.12,14.88,14.69,14.06,13.97,15.56,17.66,19.84,22.56,22.44,22.28,21.69,20.88,20.38,20.78,20.84,21.69,21.69,21.41,21.16,20.12,18.28,15.88,12.88,12.06,11.16,10.81,12.66,15.19,16.66,20.69,23.59,26.0,28.0,28.47,27.19,25.25,22.03,18.25,15.78,13.06,11.62,10.62,9.31,8.06,6.69,6.06,7.03,8.53,11.28,14.25,16.72,18.94,20.28,21.12,21.25,20.5,19.72,18.09,16.09,14.97,13.66,13.53,12.81,13.03,13.97,14.47,15.16,15.53,15.69,14.19,12.5,12.06,10.72,10.06,10.59,11.0,11.06,11.78,10.91,10.66,8.53,7.72,6.5,5.81,5.25,5.06,6.19,6.88,8.56,10.06,12.09,12.56,12.47,12.31,10.69,9.94,10.03,9.56,9.72,11.12,12.72,13.75,16.16,17.5,17.75,18.62,18.41,18.69,19.41,20.84,21.84,22.12,22.28,20.16,18.59,15.94,13.97,12.12,10.44,9.66,8.62,8.31,5.81,6.12,5.62,5.28,5.88,7.12,8.31,7.03,5.25,3.97,-21.03,-20.16,-21.22,-21.47,-21.44,-21.22,-20.97,-19.94,-20.19,-20.56,-23.0,-25.25,-26.84,-28.78,-29.03,-29.25,-28.28,-28.78:26.38,25.78,23.94,23.97,24.88,26.16,27.94,30.0,31.53,32.28,32.84,32.28,31.72,31.69,29.97,28.66,27.41,26.22,25.06,24.38,24.06,22.12,22.53,21.69,23.59,24.41,27.69,30.72,33.69,35.41,37.22,38.34,36.91,37.06,37.25,35.34,34.19,32.34,30.81,27.56,25.78,23.12,21.03,19.19,16.12,13.31,11.03,6.94,5.5,4.69,3.62,3.22,3.25,3.34,4.34,5.31,6.31,8.41,11.47,14.31,17.28,20.31,24.53,25.84,28.06,30.34,31.5,30.94,32.5,33.78,35.16,36.12,38.44,40.34,39.75,40.25,38.69,37.28,35.44,32.62,31.25,29.78,29.12,28.78,28.44,28.59,28.12,27.5,26.56,25.12,24.38,23.44,21.44,22.41,22.34,23.19,23.22,23.44,23.06,22.03,21.28,19.69,18.12,17.84,16.38,17.62,15.94,15.25,14.91,13.38,12.94,12.66,14.22,14.44,14.91,16.16,15.62,15.31,15.53,15.41,16.16,17.09,17.12,16.44,15.34,13.69,10.66,9.31,7.44,7.75,6.84,7.47,8.34,10.62,12.03,14.38,17.78,19.84,20.91,22.91,24.44,25.81,27.34,29.06,29.66,27.19,25.47,23.34,19.31,18.03,16.0,15.56,15.34,15.25,15.44,17.06,19.81,22.41,25.94,29.81,30.56,31.72,29.31,27.5,24.56,21.44,18.94,18.19,19.06,20.31,21.53,23.06,25.34,25.69,26.31,27.12,26.31,26.19,23.03,23.5,21.97,20.56,20.62,19.41,17.5,16.03,14.84,14.81,14.22,14.44,15.53,16.12,17.38,18.78,21.25,22.44,24.44,26.69,27.31,25.94,26.62,25.81,25.0,24.91,23.34,22.5,22.56,22.16,22.81,23.0,26.31,26.25,26.94,28.16,27.88,25.06,24.19,22.75,21.12,21.31,22.09,23.81,26.81,29.5,31.81,33.25,33.03,31.91,29.12,26.91,25.19,23.56,23.38,23.66,23.62,23.81,22.72,22.28,22.12,20.06,20.03,18.91,18.12,18.22,18.84,19.94,23.03,23.06,25.97,26.81,27.94,28.66,29.03,27.38,24.69,22.16,17.56,15.03,11.97,10.94,10.38,9.06,9.47,9.84,10.66,11.09,12.03,13.44,14.88,17.34,17.81,21.28,23.34,25.47,27.97,29.38,31.62,29.94,28.19,27.0,25.53,25.03,25.38,27.78,29.56,30.22,30.78,30.69,30.53,31.28,31.78,31.91,32.69,33.47,34.72,35.25,36.91,37.06,36.69,37.09,35.66,34.75,34.16,35.19,34.94,36.06,38.5,39.97,40.78,42.25,41.44,41.28,40.41,38.91,37.84,36.16,33.72,32.62,31.62,30.44,31.75,31.81,31.34,32.19,31.53,30.81,30.94,29.91,29.81,28.47,27.41,26.03,24.97,23.28,22.44,22.41,21.78,21.91,23.31,24.16,25.78,28.81,29.78,32.22,34.44,36.0,36.56,36.25,34.94,31.31,27.47,22.81,18.78,15.53,13.19,13.44,13.34,14.62,15.5,17.0,15.72,16.69,16.09,16.16,16.09,18.16,18.19,17.34,18.03,17.03,15.66,16.12,14.91,14.5,14.38,14.12,14.25,13.53,13.12,12.84,11.38,10.25,9.72,8.16,7.34,4.81,4.69,5.81,7.34,10.31,13.81,15.66,16.94,15.78,14.84,13.19,12.5,12.09,12.25,12.84,13.62,13.75,14.41,14.16,14.75,16.44,16.31,20.31,21.47,23.41,23.34,20.0,22.12,19.31,20.81,22.06,23.0,23.41,21.84,19.91,17.69,15.75,14.16,13.19,13.12,13.16,13.31,14.03,13.47,14.84,14.62,15.75,17.5,20.75,19.31,23.81,24.25,24.81,25.12,24.91,23.16,20.53,18.19,16.16,13.38,12.84,11.28,11.44,11.38,12.06,12.69,13.5,12.72,13.94,13.34,13.12,12.25,12.12,11.72,9.66,10.47,10.59,11.06,12.56,13.75,13.47,15.12,16.16,18.16,21.03,21.81,25.0,25.16,26.25,26.56,27.06,26.81,25.91,24.09,21.59,19.22,17.5,16.44,15.69,15.06,18.12,19.31,22.16,25.06,26.91,26.91,26.53,23.0,21.5,19.94,17.94,19.0,19.19,19.12,20.78,19.19,17.75,15.72,13.41,11.03,10.69,10.81,13.06,14.91,18.06,20.72,23.56,23.84,24.44,25.16,22.97,20.94,19.06,18.56,16.56,16.78,15.88,14.91,13.19,9.44,7.19,6.5,4.62,5.88,7.44,9.19,10.91,13.28,14.81,15.94,15.72,15.81,15.19,12.38,11.16,9.97,8.41,7.66,7.88,7.31,6.12,5.41,5.12,3.31,3.44,3.59,4.5,5.34,5.56,5.75,6.0,4.91,6.16,6.41,7.09,8.62,8.84,9.06,10.53,10.38,12.06,13.16,14.28,16.06,16.5,13.75,14.12,11.56,9.38,8.94,9.12,9.91,8.41,9.84,8.31,8.72,8.47,6.78,6.62,7.28,7.16,10.09,8.94,13.69,15.03,15.19,17.12,17.0,15.66,14.81,14.06,12.59,13.03,12.72,13.38,14.06,16.09,17.34,17.34,18.72,16.53,15.78,15.03,14.03,14.0,14.53,14.28,13.19,13.31,11.38,8.38,8.34,3.44,4.41,2.75,4.94,6.62,10.16,13.34,15.16,18.5,18.25,18.0,17.5,15.94,15.25,14.94,15.81,17.09,17.84,16.94,16.75,14.31,13.78,10.41,13.91,15.12,18.34,20.91,23.75,24.19,23.19,22.5,20.94,21.41,21.59,22.12,22.94,24.28,23.84,21.66,22.31,19.25,19.16,17.31,15.97,11.91,11.69,9.84,9.78,11.25,13.28,14.34,14.34,15.22,14.81,15.72,14.5,16.81,16.12,14.53,14.56,12.41,11.78,11.19,10.25,9.62,5.66,7.59,6.41,6.69,9.0,10.41,9.56,11.41,9.25,10.0,11.16,12.91,15.16,17.34,20.31,20.59,20.25,19.25,15.78,12.25,8.72,6.91,6.25,6.22,7.81,7.88,10.06,10.03,10.94,12.06,11.66,11.25,10.5,9.72,9.44,9.62,9.16,11.59,12.72,13.22,14.94,15.0,15.84,13.78,13.38,12.0,10.44,10.28,11.12,12.06,14.19,15.5,17.62,17.41,17.44,17.62,16.38,16.12,14.88,14.69,14.06,13.97,15.56,17.66,19.84,22.56,22.44,22.28,21.69,20.88,20.38,20.78,20.84,21.69,21.69,21.41,21.16,20.12,18.28,15.88,12.88,12.06,11.16,10.81,12.66,15.19,16.66,20.69,23.59,26.0,28.0,28.47,27.19,25.25,22.03,18.25,15.78,13.06,11.62,10.62,9.31,8.06,6.69,6.06,7.03,8.53,11.28,14.25,16.72,18.94,20.28,21.12,21.25,20.5,19.72,18.09,16.09,14.97,13.66,13.53,12.81,13.03,13.97,14.47,15.16,15.53,15.69,14.19,12.5,12.06,10.72,10.06,10.59,11.0,11.06,11.78,10.91,10.66,8.53,7.72,6.5,5.81,5.25,5.06,6.19,6.88,8.56,10.06,12.09,12.56,12.47,12.31,10.69,9.94,10.03,9.56,9.72,11.12,12.72,13.75,16.16,17.5,17.75,18.62,18.41,18.69,19.41,20.84,21.84,22.12,22.28,20.16,18.59,15.94,13.97,12.12,10.44,9.66,8.62,8.31,5.81,6.12,5.62,5.28,5.88,7.12,8.31,7.03,5.25,3.97,-21.03,-20.16,-21.22,-21.47,-21.44,-21.22,-20.97,-19.94,-20.19,-20.56,-23.0,-25.25,-26.84,-28.78,-29.03,-29.25,-28.28,-28.78,-29.09,-29.28,-31.44,-33.03,-34.22,-35.62:27.94,30.0,31.53,32.28,32.84,32.28,31.72,31.69,29.97,28.66,27.41,26.22,25.06,24.38,24.06,22.12,22.53,21.69,23.59,24.41,27.69,30.72,33.69,35.41,37.22,38.34,36.91,37.06,37.25,35.34,34.19,32.34,30.81,27.56,25.78,23.12,21.03,19.19,16.12,13.31,11.03,6.94,5.5,4.69,3.62,3.22,3.25,3.34,4.34,5.31,6.31,8.41,11.47,14.31,17.28,20.31,24.53,25.84,28.06,30.34,31.5,30.94,32.5,33.78,35.16,36.12,38.44,40.34,39.75,40.25,38.69,37.28,35.44,32.62,31.25,29.78,29.12,28.78,28.44,28.59,28.12,27.5,26.56,25.12,24.38,23.44,21.44,22.41,22.34,23.19,23.22,23.44,23.06,22.03,21.28,19.69,18.12,17.84,16.38,17.62,15.94,15.25,14.91,13.38,12.94,12.66,14.22,14.44,14.91,16.16,15.62,15.31,15.53,15.41,16.16,17.09,17.12,16.44,15.34,13.69,10.66,9.31,7.44,7.75,6.84,7.47,8.34,10.62,12.03,14.38,17.78,19.84,20.91,22.91,24.44,25.81,27.34,29.06,29.66,27.19,25.47,23.34,19.31,18.03,16.0,15.56,15.34,15.25,15.44,17.06,19.81,22.41,25.94,29.81,30.56,31.72,29.31,27.5,24.56,21.44,18.94,18.19,19.06,20.31,21.53,23.06,25.34,25.69,26.31,27.12,26.31,26.19,23.03,23.5,21.97,20.56,20.62,19.41,17.5,16.03,14.84,14.81,14.22,14.44,15.53,16.12,17.38,18.78,21.25,22.44,24.44,26.69,27.31,25.94,26.62,25.81,25.0,24.91,23.34,22.5,22.56,22.16,22.81,23.0,26.31,26.25,26.94,28.16,27.88,25.06,24.19,22.75,21.12,21.31,22.09,23.81,26.81,29.5,31.81,33.25,33.03,31.91,29.12,26.91,25.19,23.56,23.38,23.66,23.62,23.81,22.72,22.28,22.12,20.06,20.03,18.91,18.12,18.22,18.84,19.94,23.03,23.06,25.97,26.81,27.94,28.66,29.03,27.38,24.69,22.16,17.56,15.03,11.97,10.94,10.38,9.06,9.47,9.84,10.66,11.09,12.03,13.44,14.88,17.34,17.81,21.28,23.34,25.47,27.97,29.38,31.62,29.94,28.19,27.0,25.53,25.03,25.38,27.78,29.56,30.22,30.78,30.69,30.53,31.28,31.78,31.91,32.69,33.47,34.72,35.25,36.91,37.06,36.69,37.09,35.66,34.75,34.16,35.19,34.94,36.06,38.5,39.97,40.78,42.25,41.44,41.28,40.41,38.91,37.84,36.16,33.72,32.62,31.62,30.44,31.75,31.81,31.34,32.19,31.53,30.81,30.94,29.91,29.81,28.47,27.41,26.03,24.97,23.28,22.44,22.41,21.78,21.91,23.31,24.16,25.78,28.81,29.78,32.22,34.44,36.0,36.56,36.25,34.94,31.31,27.47,22.81,18.78,15.53,13.19,13.44,13.34,14.62,15.5,17.0,15.72,16.69,16.09,16.16,16.09,18.16,18.19,17.34,18.03,17.03,15.66,16.12,14.91,14.5,14.38,14.12,14.25,13.53,13.12,12.84,11.38,10.25,9.72,8.16,7.34,4.81,4.69,5.81,7.34,10.31,13.81,15.66,16.94,15.78,14.84,13.19,12.5,12.09,12.25,12.84,13.62,13.75,14.41,14.16,14.75,16.44,16.31,20.31,21.47,23.41,23.34,20.0,22.12,19.31,20.81,22.06,23.0,23.41,21.84,19.91,17.69,15.75,14.16,13.19,13.12,13.16,13.31,14.03,13.47,14.84,14.62,15.75,17.5,20.75,19.31,23.81,24.25,24.81,25.12,24.91,23.16,20.53,18.19,16.16,13.38,12.84,11.28,11.44,11.38,12.06,12.69,13.5,12.72,13.94,13.34,13.12,12.25,12.12,11.72,9.66,10.47,10.59,11.06,12.56,13.75,13.47,15.12,16.16,18.16,21.03,21.81,25.0,25.16,26.25,26.56,27.06,26.81,25.91,24.09,21.59,19.22,17.5,16.44,15.69,15.06,18.12,19.31,22.16,25.06,26.91,26.91,26.53,23.0,21.5,19.94,17.94,19.0,19.19,19.12,20.78,19.19,17.75,15.72,13.41,11.03,10.69,10.81,13.06,14.91,18.06,20.72,23.56,23.84,24.44,25.16,22.97,20.94,19.06,18.56,16.56,16.78,15.88,14.91,13.19,9.44,7.19,6.5,4.62,5.88,7.44,9.19,10.91,13.28,14.81,15.94,15.72,15.81,15.19,12.38,11.16,9.97,8.41,7.66,7.88,7.31,6.12,5.41,5.12,3.31,3.44,3.59,4.5,5.34,5.56,5.75,6.0,4.91,6.16,6.41,7.09,8.62,8.84,9.06,10.53,10.38,12.06,13.16,14.28,16.06,16.5,13.75,14.12,11.56,9.38,8.94,9.12,9.91,8.41,9.84,8.31,8.72,8.47,6.78,6.62,7.28,7.16,10.09,8.94,13.69,15.03,15.19,17.12,17.0,15.66,14.81,14.06,12.59,13.03,12.72,13.38,14.06,16.09,17.34,17.34,18.72,16.53,15.78,15.03,14.03,14.0,14.53,14.28,13.19,13.31,11.38,8.38,8.34,3.44,4.41,2.75,4.94,6.62,10.16,13.34,15.16,18.5,18.25,18.0,17.5,15.94,15.25,14.94,15.81,17.09,17.84,16.94,16.75,14.31,13.78,10.41,13.91,15.12,18.34,20.91,23.75,24.19,23.19,22.5,20.94,21.41,21.59,22.12,22.94,24.28,23.84,21.66,22.31,19.25,19.16,17.31,15.97,11.91,11.69,9.84,9.78,11.25,13.28,14.34,14.34,15.22,14.81,15.72,14.5,16.81,16.12,14.53,14.56,12.41,11.78,11.19,10.25,9.62,5.66,7.59,6.41,6.69,9.0,10.41,9.56,11.41,9.25,10.0,11.16,12.91,15.16,17.34,20.31,20.59,20.25,19.25,15.78,12.25,8.72,6.91,6.25,6.22,7.81,7.88,10.06,10.03,10.94,12.06,11.66,11.25,10.5,9.72,9.44,9.62,9.16,11.59,12.72,13.22,14.94,15.0,15.84,13.78,13.38,12.0,10.44,10.28,11.12,12.06,14.19,15.5,17.62,17.41,17.44,17.62,16.38,16.12,14.88,14.69,14.06,13.97,15.56,17.66,19.84,22.56,22.44,22.28,21.69,20.88,20.38,20.78,20.84,21.69,21.69,21.41,21.16,20.12,18.28,15.88,12.88,12.06,11.16,10.81,12.66,15.19,16.66,20.69,23.59,26.0,28.0,28.47,27.19,25.25,22.03,18.25,15.78,13.06,11.62,10.62,9.31,8.06,6.69,6.06,7.03,8.53,11.28,14.25,16.72,18.94,20.28,21.12,21.25,20.5,19.72,18.09,16.09,14.97,13.66,13.53,12.81,13.03,13.97,14.47,15.16,15.53,15.69,14.19,12.5,12.06,10.72,10.06,10.59,11.0,11.06,11.78,10.91,10.66,8.53,7.72,6.5,5.81,5.25,5.06,6.19,6.88,8.56,10.06,12.09,12.56,12.47,12.31,10.69,9.94,10.03,9.56,9.72,11.12,12.72,13.75,16.16,17.5,17.75,18.62,18.41,18.69,19.41,20.84,21.84,22.12,22.28,20.16,18.59,15.94,13.97,12.12,10.44,9.66,8.62,8.31,5.81,6.12,5.62,5.28,5.88,7.12,8.31,7.03,5.25,3.97,-21.03,-20.16,-21.22,-21.47,-21.44,-21.22,-20.97,-19.94,-20.19,-20.56,-23.0,-25.25,-26.84,-28.78,-29.03,-29.25,-28.28,-28.78,-29.09,-29.28,-31.44,-33.03,-34.22,-35.62,-36.19,-35.5,-34.19,-32.31,-29.97,-27.91:negativity
31.44,33.38,35.28,38.19,39.53,39.28,40.22,38.38,38.25,37.28,35.75,35.12,35.88,36.44,36.31,37.28,37.75,37.69,40.25,43.75,46.19,50.53,53.53,53.84,54.03,50.09,47.28,42.84,38.62,38.0,36.81,39.06,40.31,42.88,44.62,46.91,48.66,48.81,50.56,51.34,49.81,52.0,51.09,50.5,49.09,48.03,42.31,38.69,37.44,33.91,32.03,31.62,31.66,31.78,33.62,35.12,39.66,41.56,45.25,46.78,49.66,51.69,50.72,54.56,55.19,56.44,57.47,57.28,53.97,53.56,48.25,44.03,42.56,42.03,40.5,42.53,45.84,45.16,47.12,47.41,47.66,48.22,49.47,50.53,51.69,52.03,52.06,52.75,51.28,51.62,53.06,54.53,54.5,57.28,59.62,60.0,58.78,60.06,58.53,56.66,57.5,58.22,57.94,57.31,58.16,58.81,55.34,55.53,55.72,53.34,53.62,52.97,53.44,54.16,53.84,54.31,53.94,54.66,54.91,54.56,55.91,55.56,55.56,56.53,54.53,55.06,55.06,54.12,54.78,53.41,54.5,52.53,50.91,51.25,49.81,48.44,48.0,46.44,45.81,42.81,42.91,41.31,39.81,37.06,36.19,35.06,32.69,31.0,31.25,29.41,29.03,30.5,30.69,33.38,34.81,39.31,43.66,47.0,50.75,51.81,52.66,50.72,48.12,47.56,46.16,45.44,44.69,44.56,43.66,42.75,41.88,43.19,43.12,44.38,46.0,44.81,46.16,45.38,46.22,46.84,49.47,50.38,53.59,55.31,56.94,58.25,58.56,57.56,57.38,58.25,57.03,58.66,58.91,58.56,59.0,58.56,56.12,54.34,53.09,51.56,51.34,52.41,55.41,57.59,57.62,62.0,60.88,61.34,63.34,64.12,64.16,64.66,64.5,64.31,63.34,63.94,63.34,62.53,62.62,60.59,58.75,60.06,58.38,58.78,59.06,59.31,58.31,58.25,58.34,58.44,57.06,57.44,56.75,55.03,55.44,55.16,54.91,53.34,54.06,53.69,55.19,58.81,60.16,64.09,65.56,63.88,62.75,62.19,60.5,61.44,60.0,56.84,56.5,55.91,56.06,56.94,59.53,61.53,62.16,63.34,65.22,63.88,65.69,66.66,65.34,66.88,67.25,66.72,67.94,69.25,70.31,70.81,70.44,70.69,69.75,70.81,68.94,68.38,67.44,66.66,66.03,65.69,65.19,67.25,66.78,65.66,67.75,69.72,71.94,72.03,73.09,72.81,71.31,68.94,67.09,67.28,67.12,66.75,68.53,70.34,71.69,72.81,73.19,72.97,72.16,71.06,66.97,65.88,64.97,62.5,64.56,64.31,64.28,65.44,63.94,61.5,59.09,58.16,57.09,57.19,58.25,60.06,61.66,61.31,61.62,62.66,59.97,58.62,57.62,55.53,54.44,53.25,53.88,54.84,56.16,58.28,61.41,62.69,64.62,63.81,63.12,60.09,58.94,56.75,55.84,57.72,58.78,61.84,64.78,66.5,67.06,64.34,60.41,57.06,53.25,51.41,49.62,49.94,50.56,50.62,50.06,51.84,53.16,49.81,48.91,49.5,48.34,49.38,52.31,55.09,55.72,57.03,58.34,58.94,61.25,61.25,62.91,62.06,60.75,57.78,58.88,57.19,55.88,56.41,57.91,55.34,56.94,58.0,58.53,61.34,61.28,64.41,64.69,64.5,63.53,64.06,62.62,62.06,62.19,63.09,63.5,65.88,66.41,66.53,65.16,62.56,60.16,57.69,55.53,57.0,57.66,57.69,59.81,62.22,61.16,61.97,60.94,60.81,60.59,59.91,58.78,61.0,60.22,60.66,63.06,62.44,61.97,62.53,61.12,59.28,59.12,58.91,56.66,57.47,55.16,54.5,55.06,56.03,55.78,58.62,58.84,59.44,59.94,58.47,57.34,56.22,54.56,53.84,52.31,52.66,51.47,52.5,52.16,55.38,56.19,57.53,58.62,61.06,61.16,63.69,64.31,66.16,66.16,66.91,64.5,63.91,62.62,61.94,62.06,61.22,62.56,62.78,63.69,63.41,64.69,64.19,64.5,65.34,64.53,68.0,64.75,65.28,63.94,61.81,58.38,57.0,55.94,55.5,56.0,58.03,57.88,59.41,58.66,57.56,58.19,57.84,57.72,57.66,58.0,57.78,57.62,58.16,58.0,58.5,58.66,57.09,57.19,56.97,54.28,55.19,53.88,53.31,54.0,54.88,55.56,57.25,58.06,58.78,59.62,58.59,58.56,60.5,61.03,62.47,65.25,66.47,66.66,64.78,65.12,64.44,61.09,61.53,61.41,60.09,60.72,61.66,61.97,64.59,63.75,65.84,66.94,67.94,68.28,69.31,68.41,68.09,67.69,67.09,66.31,65.31,63.56,62.69,61.12,62.5,64.12,65.5,65.19,67.41,66.56,64.53,66.03,65.66,68.06,71.28,75.62,80.16,83.41,83.62,82.5,78.94,74.56,72.19,68.66,65.53,65.75,65.78,67.06,66.91,67.94,66.5,66.91,64.31,62.25,61.81,59.75,58.84,58.34,58.16,60.69,62.19,64.44,65.34,67.88,66.72,67.5,66.5,67.75,67.47,67.31,67.25,66.84,65.66,64.12,63.72,61.91,60.78,58.09,58.62,57.28,56.78,57.62,56.75,55.94,55.56,54.88,56.12,58.41,60.47,63.34,65.81,68.03,67.47,68.31,68.56,69.19,67.97,67.41,68.31,67.41,67.53,70.06,71.28,72.25,72.5,73.88,73.06,73.44,73.31,72.34,70.69,68.56,66.31,64.22,61.75,61.03,60.62,59.31,59.12,58.84,58.44,56.56,55.06,52.97,51.19,47.47,47.28,47.0,47.97,49.03,49.97,50.34,49.41,49.5,48.0,49.56,50.69,50.25,51.97,53.34,54.75,56.28,57.28,59.06,59.59,59.81,60.59,62.06,61.75,62.66,62.88,64.03,64.0,66.41,67.28,66.81,68.31,67.56,68.5,70.0,71.16,72.44,74.25,74.62,74.25,73.28,71.19,69.62,66.5,63.91,62.19,59.69,58.5,56.41,55.41,53.66,52.53,53.44,54.31,56.56,57.81,60.22,60.66,60.28,59.12,58.47,57.28,57.84,57.78,59.25,59.19,58.69,57.66,57.41,57.81,58.28,59.97,62.0,62.78,62.69,62.25,61.34,59.94,57.66,56.62,55.91,54.66,53.81,53.41,53.28,52.84,53.5,53.91,54.81,56.31,56.81,59.09,60.09,62.12,64.69,67.06,69.28,70.28,70.78,70.09,69.81,69.53,68.41,67.94,67.62,68.03,68.53,68.75,69.0,68.19,67.44,66.72,65.81,67.94,68.56,69.53,70.09,70.47,70.0,71.06,70.94,70.62,72.09,72.38,72.12,72.03,72.56,71.19,69.88,68.03,67.31,66.16,65.91,66.69,67.19,68.41,70.22,70.62,72.12,71.84,73.0,73.31,74.66,75.75,77.34,76.62,76.34,75.62,75.31,75.28,75.12,75.72,77.22,76.09,76.47,76.69,77.53,78.09,79.94,81.69,80.69,79.19,76.97,74.41,70.94,68.28,67.47,65.69,64.5,65.31,64.56,64.69,64.56,63.34,62.5,61.62,60.75,60.41,60.0,60.69,61.0,62.31,65.06,68.38,69.41,71.06,71.59,69.69,67.78,66.31,62.69,62.69,61.97,62.69,62.81,64.69,63.91,63.72,62.44,62.28,62.66,63.0,63.56,63.66,62.34,59.97,58.78,56.78,56.06,55.53,56.69,57.25,57.38,58.47,58.75,59.41,58.0,57.28,57.28,55.81,55.69,55.97,57.12,58.06,57.91,57.53,57.34,57.09,57.53,58.56,58.44,58.66,57.66,55.78,54.97,54.16,53.69,54.28,55.03,55.91,57.78,57.94:40.22,38.38,38.25,37.28,35.75,35.12,35.88,36.44,36.31,37.28,37.75,37.69,40.25,43.75,46.19,50.53,53.53,53.84,54.03,50.09,47.28,42.84,38.62,38.0,36.81,39.06,40.31,42.88,44.62,46.91,48.66,48.81,50.56,51.34,49.81,52.0,51.09,50.5,49.09,48.03,42.31,38.69,37.44,33.91,32.03,31.62,31.66,31.78,33.62,35.12,39.66,41.56,45.25,46.78,49.66,51.69,50.72,54.56,55.19,56.44,57.47,57.28,53.97,53.56,48.25,44.03,42.56,42.03,40.5,42.53,45.84,45.16,47.12,47.41,47.66,48.22,49.47,50.53,51.69,52.03,52.06,52.75,51.28,51.62,53.06,54.53,54.5,57.28,59.62,60.0,58.78,60.06,58.53,56.66,57.5,58.22,57.94,57.31,58.16,58.81,55.34,55.53,55.72,53.34,53.62,52.97,53.44,54.16,53.84,54.31,53.94,54.66,54.91,54.56,55.91,55.56,55.56,56.53,54.53,55.06,55.06,54.12,54.78,53.41,54.5,52.53,50.91,51.25,49.81,48.44,48.0,46.44,45.81,42.81,42.91,41.31,39.81,37.06,36.19,35.06,32.69,31.0,31.25,29.41,29.03,30.5,30.69,33.38,34.81,39.31,43.66,47.0,50.75,51.81,52.66,50.72,48.12,47.56,46.16,45.44,44.69,44.56,43.66,42.75,41.88,43.19,43.12,44.38,46.0,44.81,46.16,45.38,46.22,46.84,49.47,50.38,53.59,55.31,56.94,58.25,58.56,57.56,57.38,58.25,57.03,58.66,58.91,58.56,59.0,58.56,56.12,54.34,53.09,51.56,51.34,52.41,55.41,57.59,57.62,62.0,60.88,61.34,63.34,64.12,64.16,64.66,64.5,64.31,63.34,63.94,63.34,62.53,62.62,60.59,58.75,60.06,58.38,58.78,59.06,59.31,58.31,58.25,58.34,58.44,57.06,57.44,56.75,55.03,55.44,55.16,54.91,53.34,54.06,53.69,55.19,58.81,60.16,64.09,65.56,63.88,62.75,62.19,60.5,61.44,60.0,56.84,56.5,55.91,56.06,56.94,59.53,61.53,62.16,63.34,65.22,63.88,65.69,66.66,65.34,66.88,67.25,66.72,67.94,69.25,70.31,70.81,70.44,70.69,69.75,70.81,68.94,68.38,67.44,66.66,66.03,65.69,65.19,67.25,66.78,65.66,67.75,69.72,71.94,72.03,73.09,72.81,71.31,68.94,67.09,67.28,67.12,66.75,68.53,70.34,71.69,72.81,73.19,72.97,72.16,71.06,66.97,65.88,64.97,62.5,64.56,64.31,64.28,65.44,63.94,61.5,59.09,58.16,57.09,57.19,58.25,60.06,61.66,61.31,61.62,62.66,59.97,58.62,57.62,55.53,54.44,53.25,53.88,54.84,56.16,58.28,61.41,62.69,64.62,63.81,63.12,60.09,58.94,56.75,55.84,57.72,58.78,61.84,64.78,66.5,67.06,64.34,60.41,57.06,53.25,51.41,49.62,49.94,50.56,50.62,50.06,51.84,53.16,49.81,48.91,49.5,48.34,49.38,52.31,55.09,55.72,57.03,58.34,58.94,61.25,61.25,62.91,62.06,60.75,57.78,58.88,57.19,55.88,56.41,57.91,55.34,56.94,58.0,58.53,61.34,61.28,64.41,64.69,64.5,63.53,64.06,62.62,62.06,62.19,63.09,63.5,65.88,66.41,66.53,65.16,62.56,60.16,57.69,55.53,57.0,57.66,57.69,59.81,62.22,61.16,61.97,60.94,60.81,60.59,59.91,58.78,61.0,60.22,60.66,63.06,62.44,61.97,62.53,61.12,59.28,59.12,58.91,56.66,57.47,55.16,54.5,55.06,56.03,55.78,58.62,58.84,59.44,59.94,58.47,57.34,56.22,54.56,53.84,52.31,52.66,51.47,52.5,52.16,55.38,56.19,57.53,58.62,61.06,61.16,63.69,64.31,66.16,66.16,66.91,64.5,63.91,62.62,61.94,62.06,61.22,62.56,62.78,63.69,63.41,64.69,64.19,64.5,65.34,64.53,68.0,64.75,65.28,63.94,61.81,58.38,57.0,55.94,55.5,56.0,58.03,57.88,59.41,58.66,57.56,58.19,57.84,57.72,57.66,58.0,57.78,57.62,58.16,58.0,58.5,58.66,57.09,57.19,56.97,54.28,55.19,53.88,53.31,54.0,54.88,55.56,57.25,58.06,58.78,59.62,58.59,58.56,60.5,61.03,62.47,65.25,66.47,66.66,64.78,65.12,64.44,61.09,61.53,61.41,60.09,60.72,61.66,61.97,64.59,63.75,65.84,66.94,67.94,68.28,69.31,68.41,68.09,67.69,67.09,66.31,65.31,63.56,62.69,61.12,62.5,64.12,65.5,65.19,67.41,66.56,64.53,66.03,65.66,68.06,71.28,75.62,80.16,83.41,83.62,82.5,78.94,74.56,72.19,68.66,65.53,65.75,65.78,67.06,66.91,67.94,66.5,66.91,64.31,62.25,61.81,59.75,58.84,58.34,58.16,60.69,62.19,64.44,65.34,67.88,66.72,67.5,66.5,67.75,67.47,67.31,67.25,66.84,65.66,64.12,63.72,61.91,60.78,58.09,58.62,57.28,56.78,57.62,56.75,55.94,55.56,54.88,56.12,58.41,60.47,63.34,65.81,68.03,67.47,68.31,68.56,69.19,67.97,67.41,68.31,67.41,67.53,70.06,71.28,72.25,72.5,73.88,73.06,73.44,73.31,72.34,70.69,68.56,66.31,64.22,61.75,61.03,60.62,59.31,59.12,58.84,58.44,56.56,55.06,52.97,51.19,47.47,47.28,47.0,47.97,49.03,49.97,50.34,49.41,49.5,48.0,49.56,50.69,50.25,51.97,53.34,54.75,56.28,57.28,59.06,59.59,59.81,60.59,62.06,61.75,62.66,62.88,64.03,64.0,66.41,67.28,66.81,68.31,67.56,68.5,70.0,71.16,72.44,74.25,74.62,74.25,73.28,71.19,69.62,66.5,63.91,62.19,59.69,58.5,56.41,55.41,53.66,52.53,53.44,54.31,56.56,57.81,60.22,60.66,60.28,59.12,58.47,57.28,57.84,57.78,59.25,59.19,58.69,57.66,57.41,57.81,58.28,59.97,62.0,62.78,62.69,62.25,61.34,59.94,57.66,56.62,55.91,54.66,53.81,53.41,53.28,52.84,53.5,53.91,54.81,56.31,56.81,59.09,60.09,62.12,64.69,67.06,69.28,70.28,70.78,70.09,69.81,69.53,68.41,67.94,67.62,68.03,68.53,68.75,69.0,68.19,67.44,66.72,65.81,67.94,68.56,69.53,70.09,70.47,70.0,71.06,70.94,70.62,72.09,72.38,72.12,72.03,72.56,71.19,69.88,68.03,67.31,66.16,65.91,66.69,67.19,68.41,70.22,70.62,72.12,71.84,73.0,73.31,74.66,75.75,77.34,76.62,76.34,75.62,75.31,75.28,75.12,75.72,77.22,76.09,76.47,76.69,77.53,78.09,79.94,81.69,80.69,79.19,76.97,74.41,70.94,68.28,67.47,65.69,64.5,65.31,64.56,64.69,64.56,63.34,62.5,61.62,60.75,60.41,60.0,60.69,61.0,62.31,65.06,68.38,69.41,71.06,71.59,69.69,67.78,66.31,62.69,62.69,61.97,62.69,62.81,64.69,63.91,63.72,62.44,62.28,62.66,63.0,63.56,63.66,62.34,59.97,58.78,56.78,56.06,55.53,56.69,57.25,57.38,58.47,58.75,59.41,58.0,57.28,57.28,55.81,55.69,55.97,57.12,58.06,57.91,57.53,57.34,57.09,57.53,58.56,58.44,58.66,57.66,55.78,54.97,54.16,53.69,54.28,55.03,55.91,57.78,57.94,-10.22,-7.91,-6.66,-4.28,-3.28,-4.03:35.88,36.44,36.31,37.28,37.75,37.69,40.25,43.75,46.19,50.53,53.53,53.84,54.03,50.09,47.28,42.84,38.62,38.0,36.81,39.06,40.31,42.88,44.62,46.91,48.66,48.81,50.56,51.34,49.81,52.0,51.09,50.5,49.09,48.03,42.31,38.69,37.44,33.91,32.03,31.62,31.66,31.78,33.62,35.12,39.66,41.56,45.25,46.78,49.66,51.69,50.72,54.56,55.19,56.44,57.47,57.28,53.97,53.56,48.25,44.03,42.56,42.03,40.5,42.53,45.84,45.16,47.12,47.41,47.66,48.22,49.47,50.53,51.69,52.03,52.06,52.75,51.28,51.62,53.06,54.53,54.5,57.28,59.62,60.0,58.78,60.06,58.53,56.66,57.5,58.22,57.94,57.31,58.16,58.81,55.34,55.53,55.72,53.34,53.62,52.97,53.44,54.16,53.84,54.31,53.94,54.66,54.91,54.56,55.91,55.56,55.56,56.53,54.53,55.06,55.06,54.12,54.78,53.41,54.5,52.53,50.91,51.25,49.81,48.44,48.0,46.44,45.81,42.81,42.91,41.31,39.81,37.06,36.19,35.06,32.69,31.0,31.25,29.41,29.03,30.5,30.69,33.38,34.81,39.31,43.66,47.0,50.75,51.81,52.66,50.72,48.12,47.56,46.16,45.44,44.69,44.56,43.66,42.75,41.88,43.19,43.12,44.38,46.0,44.81,46.16,45.38,46.22,46.84,49.47,50.38,53.59,55.31,56.94,58.25,58.56,57.56,57.38,58.25,57.03,58.66,58.91,58.56,59.0,58.56,56.12,54.34,53.09,51.56,51.34,52.41,55.41,57.59,57.62,62.0,60.88,61.34,63.34,64.12,64.16,64.66,64.5,64.31,63.34,63.94,63.34,62.53,62.62,60.59,58.75,60.06,58.38,58.78,59.06,59.31,58.31,58.25,58.34,58.44,57.06,57.44,56.75,55.03,55.44,55.16,54.91,53.34,54.06,53.69,55.19,58.81,60.16,64.09,65.56,63.88,62.75,62.19,60.5,61.44,60.0,56.84,56.5,55.91,56.06,56.94,59.53,61.53,62.16,63.34,65.22,63.88,65.69,66.66,65.34,66.88,67.25,66.72,67.94,69.25,70.31,70.81,70.44,70.69,69.75,70.81,68.94,68.38,67.44,66.66,66.03,65.69,65.19,67.25,66.78,65.66,67.75,69.72,71.94,72.03,73.09,72.81,71.31,68.94,67.09,67.28,67.12,66.75,68.53,70.34,71.69,72.81,73.19,72.97,72.16,71.06,66.97,65.88,64.97,62.5,64.56,64.31,64.28,65.44,63.94,61.5,59.09,58.16,57.09,57.19,58.25,60.06,61.66,61.31,61.62,62.66,59.97,58.62,57.62,55.53,54.44,53.25,53.88,54.84,56.16,58.28,61.41,62.69,64.62,63.81,63.12,60.09,58.94,56.75,55.84,57.72,58.78,61.84,64.78,66.5,67.06,64.34,60.41,57.06,53.25,51.41,49.62,49.94,50.56,50.62,50.06,51.84,53.16,49.81,48.91,49.5,48.34,49.38,52.31,55.09,55.72,57.03,58.34,58.94,61.25,61.25,62.91,62.06,60.75,57.78,58.88,57.19,55.88,56.41,57.91,55.34,56.94,58.0,58.53,61.34,61.28,64.41,64.69,64.5,63.53,64.06,62.62,62.06,62.19,63.09,63.5,65.88,66.41,66.53,65.16,62.56,60.16,57.69,55.53,57.0,57.66,57.69,59.81,62.22,61.16,61.97,60.94,60.81,60.59,59.91,58.78,61.0,60.22,60.66,63.06,62.44,61.97,62.53,61.12,59.28,59.12,58.91,56.66,57.47,55.16,54.5,55.06,56.03,55.78,58.62,58.84,59.44,59.94,58.47,57.34,56.22,54.56,53.84,52.31,52.66,51.47,52.5,52.16,55.38,56.19,57.53,58.62,61.06,61.16,63.69,64.31,66.16,66.16,66.91,64.5,63.91,62.62,61.94,62.06,61.22,62.56,62.78,63.69,63.41,64.69,64.19,64.5,65.34,64.53,68.0,64.75,65.28,63.94,61.81,58.38,57.0,55.94,55.5,56.0,58.03,57.88,59.41,58.66,57.56,58.19,57.84,57.72,57.66,58.0,57.78,57.62,58.16,58.0,58.5,58.66,57.09,57.19,56.97,54.28,55.19,53.88,53.31,54.0,54.88,55.56,57.25,58.06,58.78,59.62,58.59,58.56,60.5,61.03,62.47,65.25,66.47,66.66,64.78,65.12,64.44,61.09,61.53,61.41,60.09,60.72,61.66,61.97,64.59,63.75,65.84,66.94,67.94,68.28,69.31,68.41,68.09,67.69,67.09,66.31,65.31,63.56,62.69,61.12,62.5,64.12,65.5,65.19,67.41,66.56,64.53,66.03,65.66,68.06,71.28,75.62,80.16,83.41,83.62,82.5,78.94,74.56,72.19,68.66,65.53,65.75,65.78,67.06,66.91,67.94,66.5,66.91,64.31,62.25,61.81,59.75,58.84,58.34,58.16,60.69,62.19,64.44,65.34,67.88,66.72,67.5,66.5,67.75,67.47,67.31,67.25,66.84,65.66,64.12,63.72,61.91,60.78,58.09,58.62,57.28,56.78,57.62,56.75,55.94,55.56,54.88,56.12,58.41,60.47,63.34,65.81,68.03,67.47,68.31,68.56,69.19,67.97,67.41,68.31,67.41,67.53,70.06,71.28,72.25,72.5,73.88,73.06,73.44,73.31,72.34,70.69,68.56,66.31,64.22,61.75,61.03,60.62,59.31,59.12,58.84,58.44,56.56,55.06,52.97,51.19,47.47,47.28,47.0,47.97,49.03,49.97,50.34,49.41,49.5,48.0,49.56,50.69,50.25,51.97,53.34,54.75,56.28,57.28,59.06,59.59,59.81,60.59,62.06,61.75,62.66,62.88,64.03,64.0,66.41,67.28,66.81,68.31,67.56,68.5,70.0,71.16,72.44,74.25,74.62,74.25,73.28,71.19,69.62,66.5,63.91,62.19,59.69,58.5,56.41,55.41,53.66,52.53,53.44,54.31,56.56,57.81,60.22,60.66,60.28,59.12,58.47,57.28,57.84,57.78,59.25,59.19,58.69,57.66,57.41,57.81,58.28,59.97,62.0,62.78,62.69,62.25,61.34,59.94,57.66,56.62,55.91,54.66,53.81,53.41,53.28,52.84,53.5,53.91,54.81,56.31,56.81,59.09,60.09,62.12,64.69,67.06,69.28,70.28,70.78,70.09,69.81,69.53,68.41,67.94,67.62,68.03,68.53,68.75,69.0,68.19,67.44,66.72,65.81,67.94,68.56,69.53,70.09,70.47,70.0,71.06,70.94,70.62,72.09,72.38,72.12,72.03,72.56,71.19,69.88,68.03,67.31,66.16,65.91,66.69,67.19,68.41,70.22,70.62,72.12,71.84,73.0,73.31,74.66,75.75,77.34,76.62,76.34,75.62,75.31,75.28,75.12,75.72,77.22,76.09,76.47,76.69,77.53,78.09,79.94,81.69,80.69,79.19,76.97,74.41,70.94,68.28,67.47,65.69,64.5,65.31,64.56,64.69,64.56,63.34,62.5,61.62,60.75,60.41,60.0,60.69,61.0,62.31,65.06,68.38,69.41,71.06,71.59,69.69,67.78,66.31,62.69,62.69,61.97,62.69,62.81,64.69,63.91,63.72,62.44,62.28,62.66,63.0,63.56,63.66,62.34,59.97,58.78,56.78,56.06,55.53,56.69,57.25,57.38,58.47,58.75,59.41,58.0,57.28,57.28,55.81,55.69,55.97,57.12,58.06,57.91,57.53,57.34,57.09,57.53,58.56,58.44,58.66,57.66,55.78,54.97,54.16,53.69,54.28,55.03,55.91,57.78,57.94,-10.22,-7.91,-6.66,-4.28,-3.28,-4.03,-3.5,-4.31,-4.09,-3.44,-4.22,-3.38:40.25,43.75,46.19,50.53,53.53,53.84,54.03,50.09,47.28,42.84,38.62,38.0,36.81,39.06,40.31,42.88,44.62,46.91,48.66,48.81,50.56,51.34,49.81,52.0,51.09,50.5,49.09,48.03,42.31,38.69,37.44,33.91,32.03,31.62,31.66,31.78,33.62,35.12,39.66,41.56,45.25,46.78,49.66,51.69,50.72,54.56,55.19,56.44,57.47,57.28,53.97,53.56,48.25,44.03,42.56,42.03,40.5,42.53,45.84,45.16,47.12,47.41,47.66,48.22,49.47,50.53,51.69,52.03,52.06,52.75,51.28,51.62,53.06,54.53,54.5,57.28,59.62,60.0,58.78,60.06,58.53,56.66,57.5,58.22,57.94,57.31,58.16,58.81,55.34,55.53,55.72,53.34,53.62,52.97,53.44,54.16,53.84,54.31,53.94,54.66,54.91,54.56,55.91,55.56,55.56,56.53,54.53,55.06,55.06,54.12,54.78,53.41,54.5,52.53,50.91,51.25,49.81,48.44,48.0,46.44,45.81,42.81,42.91,41.31,39.81,37.06,36.19,35.06,32.69,31.0,31.25,29.41,29.03,30.5,30.69,33.38,34.81,39.31,43.66,47.0,50.75,51.81,52.66,50.72,48.12,47.56,46.16,45.44,44.69,44.56,43.66,42.75,41.88,43.19,43.12,44.38,46.0,44.81,46.16,45.38,46.22,46.84,49.47,50.38,53.59,55.31,56.94,58.25,58.56,57.56,57.38,58.25,57.03,58.66,58.91,58.56,59.0,58.56,56.12,54.34,53.09,51.56,51.34,52.41,55.41,57.59,57.62,62.0,60.88,61.34,63.34,64.12,64.16,64.66,64.5,64.31,63.34,63.94,63.34,62.53,62.62,60.59,58.75,60.06,58.38,58.78,59.06,59.31,58.31,58.25,58.34,58.44,57.06,57.44,56.75,55.03,55.44,55.16,54.91,53.34,54.06,53.69,55.19,58.81,60.16,64.09,65.56,63.88,62.75,62.19,60.5,61.44,60.0,56.84,56.5,55.91,56.06,56.94,59.53,61.53,62.16,63.34,65.22,63.88,65.69,66.66,65.34,66.88,67.25,66.72,67.94,69.25,70.31,70.81,70.44,70.69,69.75,70.81,68.94,68.38,67.44,66.66,66.03,65.69,65.19,67.25,66.78,65.66,67.75,69.72,71.94,72.03,73.09,72.81,71.31,68.94,67.09,67.28,67.12,66.75,68.53,70.34,71.69,72.81,73.19,72.97,72.16,71.06,66.97,65.88,64.97,62.5,64.56,64.31,64.28,65.44,63.94,61.5,59.09,58.16,57.09,57.19,58.25,60.06,61.66,61.31,61.62,62.66,59.97,58.62,57.62,55.53,54.44,53.25,53.88,54.84,56.16,58.28,61.41,62.69,64.62,63.81,63.12,60.09,58.94,56.75,55.84,57.72,58.78,61.84,64.78,66.5,67.06,64.34,60.41,57.06,53.25,51.41,49.62,49.94,50.56,50.62,50.06,51.84,53.16,49.81,48.91,49.5,48.34,49.38,52.31,55.09,55.72,57.03,58.34,58.94,61.25,61.25,62.91,62.06,60.75,57.78,58.88,57.19,55.88,56.41,57.91,55.34,56.94,58.0,58.53,61.34,61.28,64.41,64.69,64.5,63.53,64.06,62.62,62.06,62.19,63.09,63.5,65.88,66.41,66.53,65.16,62.56,60.16,57.69,55.53,57.0,57.66,57.69,59.81,62.22,61.16,61.97,60.94,60.81,60.59,59.91,58.78,61.0,60.22,60.66,63.06,62.44,61.97,62.53,61.12,59.28,59.12,58.91,56.66,57.47,55.16,54.5,55.06,56.03,55.78,58.62,58.84,59.44,59.94,58.47,57.34,56.22,54.56,53.84,52.31,52.66,51.47,52.5,52.16,55.38,56.19,57.53,58.62,61.06,61.16,63.69,64.31,66.16,66.16,66.91,64.5,63.91,62.62,61.94,62.06,61.22,62.56,62.78,63.69,63.41,64.69,64.19,64.5,65.34,64.53,68.0,64.75,65.28,63.94,61.81,58.38,57.0,55.94,55.5,56.0,58.03,57.88,59.41,58.66,57.56,58.19,57.84,57.72,57.66,58.0,57.78,57.62,58.16,58.0,58.5,58.66,57.09,57.19,56.97,54.28,55.19,53.88,53.31,54.0,54.88,55.56,57.25,58.06,58.78,59.62,58.59,58.56,60.5,61.03,62.47,65.25,66.47,66.66,64.78,65.12,64.44,61.09,61.53,61.41,60.09,60.72,61.66,61.97,64.59,63.75,65.84,66.94,67.94,68.28,69.31,68.41,68.09,67.69,67.09,66.31,65.31,63.56,62.69,61.12,62.5,64.12,65.5,65.19,67.41,66.56,64.53,66.03,65.66,68.06,71.28,75.62,80.16,83.41,83.62,82.5,78.94,74.56,72.19,68.66,65.53,65.75,65.78,67.06,66.91,67.94,66.5,66.91,64.31,62.25,61.81,59.75,58.84,58.34,58.16,60.69,62.19,64.44,65.34,67.88,66.72,67.5,66.5,67.75,67.47,67.31,67.25,66.84,65.66,64.12,63.72,61.91,60.78,58.09,58.62,57.28,56.78,57.62,56.75,55.94,55.56,54.88,56.12,58.41,60.47,63.34,65.81,68.03,67.47,68.31,68.56,69.19,67.97,67.41,68.31,67.41,67.53,70.06,71.28,72.25,72.5,73.88,73.06,73.44,73.31,72.34,70.69,68.56,66.31,64.22,61.75,61.03,60.62,59.31,59.12,58.84,58.44,56.56,55.06,52.97,51.19,47.47,47.28,47.0,47.97,49.03,49.97,50.34,49.41,49.5,48.0,49.56,50.69,50.25,51.97,53.34,54.75,56.28,57.28,59.06,59.59,59.81,60.59,62.06,61.75,62.66,62.88,64.03,64.0,66.41,67.28,66.81,68.31,67.56,68.5,70.0,71.16,72.44,74.25,74.62,74.25,73.28,71.19,69.62,66.5,63.91,62.19,59.69,58.5,56.41,55.41,53.66,52.53,53.44,54.31,56.56,57.81,60.22,60.66,60.28,59.12,58.47,57.28,57.84,57.78,59.25,59.19,58.69,57.66,57.41,57.81,58.28,59.97,62.0,62.78,62.69,62.25,61.34,59.94,57.66,56.62,55.91,54.66,53.81,53.41,53.28,52.84,53.5,53.91,54.81,56.31,56.81,59.09,60.09,62.12,64.69,67.06,69.28,70.28,70.78,70.09,69.81,69.53,68.41,67.94,67.62,68.03,68.53,68.75,69.0,68.19,67.44,66.72,65.81,67.94,68.56,69.53,70.09,70.47,70.0,71.06,70.94,70.62,72.09,72.38,72.12,72.03,72.56,71.19,69.88,68.03,67.31,66.16,65.91,66.69,67.19,68.41,70.22,70.62,72.12,71.84,73.0,73.31,74.66,75.75,77.34,76.62,76.34,75.62,75.31,75.28,75.12,75.72,77.22,76.09,76.47,76.69,77.53,78.09,79.94,81.69,80.69,79.19,76.97,74.41,70.94,68.28,67.47,65.69,64.5,65.31,64.56,64.69,64.56,63.34,62.5,61.62,60.75,60.41,60.0,60.69,61.0,62.31,65.06,68.38,69.41,71.06,71.59,69.69,67.78,66.31,62.69,62.69,61.97,62.69,62.81,64.69,63.91,63.72,62.44,62.28,62.66,63.0,63.56,63.66,62.34,59.97,58.78,56.78,56.06,55.53,56.69,57.25,57.38,58.47,58.75,59.41,58.0,57.28,57.28,55.81,55.69,55.97,57.12,58.06,57.91,57.53,57.34,57.09,57.53,58.56,58.44,58.66,57.66,55.78,54.97,54.16,53.69,54.28,55.03,55.91,57.78,57.94,-10.22,-7.91,-6.66,-4.28,-3.28,-4.03,-3.5,-4.31,-4.09,-3.44,-4.22,-3.38,-3.94,-4.22,-3.38,-3.06,-2.22,-0.47:54.03,50.09,47.28,42.84,38.62,38.0,36.81,39.06,40.31,42.88,44.62,46.91,48.66,48.81,50.56,51.34,49.81,52.0,51.09,50.5,49.09,48.03,42.31,38.69,37.44,33.91,32.03,31.62,31.66,31.78,33.62,35.12,39.66,41.56,45.25,46.78,49.66,51.69,50.72,54.56,55.19,56.44,57.47,57.28,53.97,53.56,48.25,44.03,42.56,42.03,40.5,42.53,45.84,45.16,47.12,47.41,47.66,48.22,49.47,50.53,51.69,52.03,52.06,52.75,51.28,51.62,53.06,54.53,54.5,57.28,59.62,60.0,58.78,60.06,58.53,56.66,57.5,58.22,57.94,57.31,58.16,58.81,55.34,55.53,55.72,53.34,53.62,52.97,53.44,54.16,53.84,54.31,53.94,54.66,54.91,54.56,55.91,55.56,55.56,56.53,54.53,55.06,55.06,54.12,54.78,53.41,54.5,52.53,50.91,51.25,49.81,48.44,48.0,46.44,45.81,42.81,42.91,41.31,39.81,37.06,36.19,35.06,32.69,31.0,31.25,29.41,29.03,30.5,30.69,33.38,34.81,39.31,43.66,47.0,50.75,51.81,52.66,50.72,48.12,47.56,46.16,45.44,44.69,44.56,43.66,42.75,41.88,43.19,43.12,44.38,46.0,44.81,46.16,45.38,46.22,46.84,49.47,50.38,53.59,55.31,56.94,58.25,58.56,57.56,57.38,58.25,57.03,58.66,58.91,58.56,59.0,58.56,56.12,54.34,53.09,51.56,51.34,52.41,55.41,57.59,57.62,62.0,60.88,61.34,63.34,64.12,64.16,64.66,64.5,64.31,63.34,63.94,63.34,62.53,62.62,60.59,58.75,60.06,58.38,58.78,59.06,59.31,58.31,58.25,58.34,58.44,57.06,57.44,56.75,55.03,55.44,55.16,54.91,53.34,54.06,53.69,55.19,58.81,60.16,64.09,65.56,63.88,62.75,62.19,60.5,61.44,60.0,56.84,56.5,55.91,56.06,56.94,59.53,61.53,62.16,63.34,65.22,63.88,65.69,66.66,65.34,66.88,67.25,66.72,67.94,69.25,70.31,70.81,70.44,70.69,69.75,70.81,68.94,68.38,67.44,66.66,66.03,65.69,65.19,67.25,66.78,65.66,67.75,69.72,71.94,72.03,73.09,72.81,71.31,68.94,67.09,67.28,67.12,66.75,68.53,70.34,71.69,72.81,73.19,72.97,72.16,71.06,66.97,65.88,64.97,62.5,64.56,64.31,64.28,65.44,63.94,61.5,59.09,58.16,57.09,57.19,58.25,60.06,61.66,61.31,61.62,62.66,59.97,58.62,57.62,55.53,54.44,53.25,53.88,54.84,56.16,58.28,61.41,62.69,64.62,63.81,63.12,60.09,58.94,56.75,55.84,57.72,58.78,61.84,64.78,66.5,67.06,64.34,60.41,57.06,53.25,51.41,49.62,49.94,50.56,50.62,50.06,51.84,53.16,49.81,48.91,49.5,48.34,49.38,52.31,55.09,55.72,57.03,58.34,58.94,61.25,61.25,62.91,62.06,60.75,57.78,58.88,57.19,55.88,56.41,57.91,55.34,56.94,58.0,58.53,61.34,61.28,64.41,64.69,64.5,63.53,64.06,62.62,62.06,62.19,63.09,63.5,65.88,66.41,66.53,65.16,62.56,60.16,57.69,55.53,57.0,57.66,57.69,59.81,62.22,61.16,61.97,60.94,60.81,60.59,59.91,58.78,61.0,60.22,60.66,63.06,62.44,61.97,62.53,61.12,59.28,59.12,58.91,56.66,57.47,55.16,54.5,55.06,56.03,55.78,58.62,58.84,59.44,59.94,58.47,57.34,56.22,54.56,53.84,52.31,52.66,51.47,52.5,52.16,55.38,56.19,57.53,58.62,61.06,61.16,63.69,64.31,66.16,66.16,66.91,64.5,63.91,62.62,61.94,62.06,61.22,62.56,62.78,63.69,63.41,64.69,64.19,64.5,65.34,64.53,68.0,64.75,65.28,63.94,61.81,58.38,57.0,55.94,55.5,56.0,58.03,57.88,59.41,58.66,57.56,58.19,57.84,57.72,57.66,58.0,57.78,57.62,58.16,58.0,58.5,58.66,57.09,57.19,56.97,54.28,55.19,53.88,53.31,54.0,54.88,55.56,57.25,58.06,58.78,59.62,58.59,58.56,60.5,61.03,62.47,65.25,66.47,66.66,64.78,65.12,64.44,61.09,61.53,61.41,60.09,60.72,61.66,61.97,64.59,63.75,65.84,66.94,67.94,68.28,69.31,68.41,68.09,67.69,67.09,66.31,65.31,63.56,62.69,61.12,62.5,64.12,65.5,65.19,67.41,66.56,64.53,66.03,65.66,68.06,71.28,75.62,80.16,83.41,83.62,82.5,78.94,74.56,72.19,68.66,65.53,65.75,65.78,67.06,66.91,67.94,66.5,66.91,64.31,62.25,61.81,59.75,58.84,58.34,58.16,60.69,62.19,64.44,65.34,67.88,66.72,67.5,66.5,67.75,67.47,67.31,67.25,66.84,65.66,64.12,63.72,61.91,60.78,58.09,58.62,57.28,56.78,57.62,56.75,55.94,55.56,54.88,56.12,58.41,60.47,63.34,65.81,68.03,67.47,68.31,68.56,69.19,67.97,67.41,68.31,67.41,67.53,70.06,71.28,72.25,72.5,73.88,73.06,73.44,73.31,72.34,70.69,68.56,66.31,64.22,61.75,61.03,60.62,59.31,59.12,58.84,58.44,56.56,55.06,52.97,51.19,47.47,47.28,47.0,47.97,49.03,49.97,50.34,49.41,49.5,48.0,49.56,50.69,50.25,51.97,53.34,54.75,56.28,57.28,59.06,59.59,59.81,60.59,62.06,61.75,62.66,62.88,64.03,64.0,66.41,67.28,66.81,68.31,67.56,68.5,70.0,71.16,72.44,74.25,74.62,74.25,73.28,71.19,69.62,66.5,63.91,62.19,59.69,58.5,56.41,55.41,53.66,52.53,53.44,54.31,56.56,57.81,60.22,60.66,60.28,59.12,58.47,57.28,57.84,57.78,59.25,59.19,58.69,57.66,57.41,57.81,58.28,59.97,62.0,62.78,62.69,62.25,61.34,59.94,57.66,56.62,55.91,54.66,53.81,53.41,53.28,52.84,53.5,53.91,54.81,56.31,56.81,59.09,60.09,62.12,64.69,67.06,69.28,70.28,70.78,70.09,69.81,69.53,68.41,67.94,67.62,68.03,68.53,68.75,69.0,68.19,67.44,66.72,65.81,67.94,68.56,69.53,70.09,70.47,70.0,71.06,70.94,70.62,72.09,72.38,72.12,72.03,72.56,71.19,69.88,68.03,67.31,66.16,65.91,66.69,67.19,68.41,70.22,70.62,72.12,71.84,73.0,73.31,74.66,75.75,77.34,76.62,76.34,75.62,75.31,75.28,75.12,75.72,77.22,76.09,76.47,76.69,77.53,78.09,79.94,81.69,80.69,79.19,76.97,74.41,70.94,68.28,67.47,65.69,64.5,65.31,64.56,64.69,64.56,63.34,62.5,61.62,60.75,60.41,60.0,60.69,61.0,62.31,65.06,68.38,69.41,71.06,71.59,69.69,67.78,66.31,62.69,62.69,61.97,62.69,62.81,64.69,63.91,63.72,62.44,62.28,62.66,63.0,63.56,63.66,62.34,59.97,58.78,56.78,56.06,55.53,56.69,57.25,57.38,58.47,58.75,59.41,58.0,57.28,57.28,55.81,55.69,55.97,57.12,58.06,57.91,57.53,57.34,57.09,57.53,58.56,58.44,58.66,57.66,55.78,54.97,54.16,53.69,54.28,55.03,55.91,57.78,57.94,-10.22,-7.91,-6.66,-4.28,-3.28,-4.03,-3.5,-4.31,-4.09,-3.44,-4.22,-3.38,-3.94,-4.22,-3.38,-3.06,-2.22,-0.47,0.12,2.56,5.06,9.31,11.78,13.69:36.81,39.06,40.31,42.88,44.62,46.91,48.66,48.81,50.56,51.34,49.81,52.0,51.09,50.5,49.09,48.03,42.31,38.69,37.44,33.91,32.03,31.62,31.66,31.78,33.62,35.12,39.66,41.56,45.25,46.78,49.66,51.69,50.72,54.56,55.19,56.44,57.47,57.28,53.97,53.56,48.25,44.03,42.56,42.03,40.5,42.53,45.84,45.16,47.12,47.41,47.66,48.22,49.47,50.53,51.69,52.03,52.06,52.75,51.28,51.62,53.06,54.53,54.5,57.28,59.62,60.0,58.78,60.06,58.53,56.66,57.5,58.22,57.94,57.31,58.16,58.81,55.34,55.53,55.72,53.34,53.62,52.97,53.44,54.16,53.84,54.31,53.94,54.66,54.91,54.56,55.91,55.56,55.56,56.53,54.53,55.06,55.06,54.12,54.78,53.41,54.5,52.53,50.91,51.25,49.81,48.44,48.0,46.44,45.81,42.81,42.91,41.31,39.81,37.06,36.19,35.06,32.69,31.0,31.25,29.41,29.03,30.5,30.69,33.38,34.81,39.31,43.66,47.0,50.75,51.81,52.66,50.72,48.12,47.56,46.16,45.44,44.69,44.56,43.66,42.75,41.88,43.19,43.12,44.38,46.0,44.81,46.16,45.38,46.22,46.84,49.47,50.38,53.59,55.31,56.94,58.25,58.56,57.56,57.38,58.25,57.03,58.66,58.91,58.56,59.0,58.56,56.12,54.34,53.09,51.56,51.34,52.41,55.41,57.59,57.62,62.0,60.88,61.34,63.34,64.12,64.16,64.66,64.5,64.31,63.34,63.94,63.34,62.53,62.62,60.59,58.75,60.06,58.38,58.78,59.06,59.31,58.31,58.25,58.34,58.44,57.06,57.44,56.75,55.03,55.44,55.16,54.91,53.34,54.06,53.69,55.19,58.81,60.16,64.09,65.56,63.88,62.75,62.19,60.5,61.44,60.0,56.84,56.5,55.91,56.06,56.94,59.53,61.53,62.16,63.34,65.22,63.88,65.69,66.66,65.34,66.88,67.25,66.72,67.94,69.25,70.31,70.81,70.44,70.69,69.75,70.81,68.94,68.38,67.44,66.66,66.03,65.69,65.19,67.25,66.78,65.66,67.75,69.72,71.94,72.03,73.09,72.81,71.31,68.94,67.09,67.28,67.12,66.75,68.53,70.34,71.69,72.81,73.19,72.97,72.16,71.06,66.97,65.88,64.97,62.5,64.56,64.31,64.28,65.44,63.94,61.5,59.09,58.16,57.09,57.19,58.25,60.06,61.66,61.31,61.62,62.66,59.97,58.62,57.62,55.53,54.44,53.25,53.88,54.84,56.16,58.28,61.41,62.69,64.62,63.81,63.12,60.09,58.94,56.75,55.84,57.72,58.78,61.84,64.78,66.5,67.06,64.34,60.41,57.06,53.25,51.41,49.62,49.94,50.56,50.62,50.06,51.84,53.16,49.81,48.91,49.5,48.34,49.38,52.31,55.09,55.72,57.03,58.34,58.94,61.25,61.25,62.91,62.06,60.75,57.78,58.88,57.19,55.88,56.41,57.91,55.34,56.94,58.0,58.53,61.34,61.28,64.41,64.69,64.5,63.53,64.06,62.62,62.06,62.19,63.09,63.5,65.88,66.41,66.53,65.16,62.56,60.16,57.69,55.53,57.0,57.66,57.69,59.81,62.22,61.16,61.97,60.94,60.81,60.59,59.91,58.78,61.0,60.22,60.66,63.06,62.44,61.97,62.53,61.12,59.28,59.12,58.91,56.66,57.47,55.16,54.5,55.06,56.03,55.78,58.62,58.84,59.44,59.94,58.47,57.34,56.22,54.56,53.84,52.31,52.66,51.47,52.5,52.16,55.38,56.19,57.53,58.62,61.06,61.16,63.69,64.31,66.16,66.16,66.91,64.5,63.91,62.62,61.94,62.06,61.22,62.56,62.78,63.69,63.41,64.69,64.19,64.5,65.34,64.53,68.0,64.75,65.28,63.94,61.81,58.38,57.0,55.94,55.5,56.0,58.03,57.88,59.41,58.66,57.56,58.19,57.84,57.72,57.66,58.0,57.78,57.62,58.16,58.0,58.5,58.66,57.09,57.19,56.97,54.28,55.19,53.88,53.31,54.0,54.88,55.56,57.25,58.06,58.78,59.62,58.59,58.56,60.5,61.03,62.47,65.25,66.47,66.66,64.78,65.12,64.44,61.09,61.53,61.41,60.09,60.72,61.66,61.97,64.59,63.75,65.84,66.94,67.94,68.28,69.31,68.41,68.09,67.69,67.09,66.31,65.31,63.56,62.69,61.12,62.5,64.12,65.5,65.19,67.41,66.56,64.53,66.03,65.66,68.06,71.28,75.62,80.16,83.41,83.62,82.5,78.94,74.56,72.19,68.66,65.53,65.75,65.78,67.06,66.91,67.94,66.5,66.91,64.31,62.25,61.81,59.75,58.84,58.34,58.16,60.69,62.19,64.44,65.34,67.88,66.72,67.5,66.5,67.75,67.47,67.31,67.25,66.84,65.66,64.12,63.72,61.91,60.78,58.09,58.62,57.28,56.78,57.62,56.75,55.94,55.56,54.88,56.12,58.41,60.47,63.34,65.81,68.03,67.47,68.31,68.56,69.19,67.97,67.41,68.31,67.41,67.53,70.06,71.28,72.25,72.5,73.88,73.06,73.44,73.31,72.34,70.69,68.56,66.31,64.22,61.75,61.03,60.62,59.31,59.12,58.84,58.44,56.56,55.06,52.97,51.19,47.47,47.28,47.0,47.97,49.03,49.97,50.34,49.41,49.5,48.0,49.56,50.69,50.25,51.97,53.34,54.75,56.28,57.28,59.06,59.59,59.81,60.59,62.06,61.75,62.66,62.88,64.03,64.0,66.41,67.28,66.81,68.31,67.56,68.5,70.0,71.16,72.44,74.25,74.62,74.25,73.28,71.19,69.62,66.5,63.91,62.19,59.69,58.5,56.41,55.41,53.66,52.53,53.44,54.31,56.56,57.81,60.22,60.66,60.28,59.12,58.47,57.28,57.84,57.78,59.25,59.19,58.69,57.66,57.41,57.81,58.28,59.97,62.0,62.78,62.69,62.25,61.34,59.94,57.66,56.62,55.91,54.66,53.81,53.41,53.28,52.84,53.5,53.91,54.81,56.31,56.81,59.09,60.09,62.12,64.69,67.06,69.28,70.28,70.78,70.09,69.81,69.53,68.41,67.94,67.62,68.03,68.53,68.75,69.0,68.19,67.44,66.72,65.81,67.94,68.56,69.53,70.09,70.47,70.0,71.06,70.94,70.62,72.09,72.38,72.12,72.03,72.56,71.19,69.88,68.03,67.31,66.16,65.91,66.69,67.19,68.41,70.22,70.62,72.12,71.84,73.0,73.31,74.66,75.75,77.34,76.62,76.34,75.62,75.31,75.28,75.12,75.72,77.22,76.09,76.47,76.69,77.53,78.09,79.94,81.69,80.69,79.19,76.97,74.41,70.94,68.28,67.47,65.69,64.5,65.31,64.56,64.69,64.56,63.34,62.5,61.62,60.75,60.41,60.0,60.69,61.0,62.31,65.06,68.38,69.41,71.06,71.59,69.69,67.78,66.31,62.69,62.69,61.97,62.69,62.81,64.69,63.91,63.72,62.44,62.28,62.66,63.0,63.56,63.66,62.34,59.97,58.78,56.78,56.06,55.53,56.69,57.25,57.38,58.47,58.75,59.41,58.0,57.28,57.28,55.81,55.69,55.97,57.12,58.06,57.91,57.53,57.34,57.09,57.53,58.56,58.44,58.66,57.66,55.78,54.97,54.16,53.69,54.28,55.03,55.91,57.78,57.94,-10.22,-7.91,-6.66,-4.28,-3.28,-4.03,-3.5,-4.31,-4.09,-3.44,-4.22,-3.38,-3.94,-4.22,-3.38,-3.06,-2.22,-0.47,0.12,2.56,5.06,9.31,11.78,13.69,14.0,11.16,7.25,2.06,-1.47,-4.22:negativity
6.38,6.44,5.03,3.84,7.22,8.38,7.5,9.56,8.78,8.91,9.62,10.31,10.0,11.66,9.94,8.75,9.31,8.03,7.16,7.78,7.44,8.75,9.62,8.03,12.16,8.62,12.31,13.44,13.09,14.44,13.22,12.53,9.56,9.16,6.97,7.31,3.75,5.97,6.75,8.06,10.56,11.56,11.09,8.69,5.34,5.19,4.44,5.19,7.56,7.81,8.19,8.12,7.38,10.59,11.56,13.81,15.66,15.12,14.66,8.62,6.75,2.0,-3.09,-4.03,-4.28,-6.22,-6.97,-5.78,-4.81,-4.66,-4.44,3.09,4.5,8.88,14.25,13.25,12.38,9.19,4.59,1.5,-1.53,-2.09,-4.22,-6.03,-5.41,-6.47,-4.66,-1.84,-0.41,2.69,6.0,8.28,8.94,8.44,14.53,14.06,18.41,20.44,20.69,21.28,11.56,10.31,8.28,6.62,6.94,9.0,11.72,10.81,11.94,11.06,8.84,6.19,6.31,6.53,8.22,12.56,15.84,19.03,18.09,20.91,19.06,22.5,21.41,21.44,20.5,18.88,17.66,15.28,14.16,13.06,12.34,9.94,10.72,10.12,9.62,12.38,15.84,18.41,16.62,20.72,24.0,23.41,26.28,27.44,22.94,21.56,18.91,15.56,12.88,12.12,9.78,7.19,5.28,4.19,4.0,5.94,6.97,7.91,7.66,5.41,4.72,4.19,4.66,8.22,5.03,11.47,9.88,12.44,14.5,16.62,15.06,16.53,14.59,12.75,11.19,7.03,3.56,3.44,0.09,2.38,5.19,9.47,12.03,15.28,18.97,19.09,23.34,20.91,22.0,23.25,22.47,22.06,23.12,21.84,20.41,21.66,17.84,21.56,21.94,23.47,23.19,27.56,28.25,29.66,30.09,32.0,31.56,29.66,28.56,28.47,25.84,25.69,25.06,24.41,25.0,25.19,23.56,28.81,25.53,30.09,29.31,32.44,33.84,34.84,37.47,38.25,37.0,35.97,34.94,32.03,31.44,31.28,31.03,30.91,30.62,29.75,28.59,27.72,25.28,27.19,25.94,28.09,28.66,30.31,29.66,29.06,30.62,30.16,31.69,26.31,29.25,29.66,28.34,31.34,35.06,37.41,38.0,37.91,33.94,33.66,29.06,28.25,26.5,26.91,26.94,27.06,27.94,28.69,29.44,24.53,31.62,29.25,30.53,34.69,35.91,33.03,33.12,32.25,27.59,27.59,28.72,26.25,28.19,31.69,32.66,35.75,37.16,37.53,36.88,36.56,33.16,30.44,28.81,25.41,28.56,31.44,35.78,41.19,43.91,44.75,46.38,41.88,41.88,37.84,36.72,36.16,35.81,31.5,32.62,28.91,28.0,29.59,28.72,30.66,32.41,32.31,31.69,32.0,28.19,27.78,23.84,24.53,29.0,33.41,37.41,43.06,49.06,49.75,54.88,53.25,52.59,50.56,48.25,47.34,46.19,45.62,44.09,38.84,36.97,34.59,32.41,30.78,32.03,31.41,31.22,31.34,26.0,27.97,25.12,25.03,26.34,33.94,35.12,39.88,43.25,45.12,46.59,45.06,43.38,41.16,37.25,37.69,37.88,37.75,34.5,35.19,30.69,28.72,25.91,27.69,26.03,27.16,27.41,26.69,25.88,28.41,31.5,32.16,35.47,34.91,35.66,35.28,35.91,36.16,36.94,37.88,41.53,41.94,42.16,41.66,39.19,34.19,32.69,30.03,28.03,27.97,26.19,26.75,25.47,27.09,26.28,26.25,22.38,25.75,23.09,21.28,25.0,25.62,24.5,26.59,27.81,29.44,29.38,32.5,31.47,31.5,30.41,26.66,21.31,20.81,16.19,14.59,19.03,19.56,22.88,23.5,24.03,23.06,21.72,21.81,19.34,17.88,19.41,20.34,18.34,24.75,24.84,25.53,28.94,29.31,26.25,27.53,28.81,25.12,28.31,29.28,29.53,29.81,27.47,24.94,19.94,19.91,16.06,16.84,17.53,17.84,15.34,14.31,14.06,10.25,14.09,16.03,17.25,20.56,18.09,18.81,17.81,18.03,18.06,22.75,21.72,23.56,23.81,23.19,21.94,24.5,22.19,18.94,22.19,22.56,21.78,22.28,21.31,18.78,17.59,16.19,16.31,17.31,22.78,24.56,30.41,34.59,34.78,38.47,41.16,39.41,39.06,37.94,35.84,34.06,29.53,29.91,30.59,28.25,28.22,27.62,27.34,24.56,22.19,23.66,22.44,24.34,25.97,28.5,31.62,30.62,31.34,34.44,34.03,34.78,34.28,34.38,33.72,31.22,30.25,33.34,31.16,31.12,28.78,29.28,28.44,25.78,25.88,21.25,22.81,19.62,22.66,26.06,26.53,26.94,27.41,25.12,25.88,25.78,26.16,24.22,30.66,30.03,32.03,32.28,32.66,28.69,30.75,28.62,28.06,27.72,24.94,23.91,21.09,23.06,25.22,29.44,35.44,36.5,43.44,44.38,46.22,44.31,42.81,38.91,35.94,33.69,30.38,31.31,29.44,29.44,31.38,32.53,31.81,36.06,35.25,32.5,35.28,34.0,33.16,35.66,39.12,41.22,39.59,46.44,45.03,48.03,46.44,44.91,40.91,34.19,29.91,27.53,25.78,24.31,23.91,23.5,24.41,25.53,26.41,30.53,31.38,34.12,36.19,39.41,39.81,42.91,42.62,43.72,44.25,43.09,43.41,39.53,36.66,32.31,29.03,27.34,25.66,25.5,24.44,24.84,20.88,20.12,20.84,18.91,21.25,23.62,25.19,26.84,27.12,27.0,24.03,29.5,29.16,30.06,33.5,32.66,32.06,30.72,26.69,24.12,21.78,22.5,21.19,23.44,25.06,24.72,24.62,21.38,20.28,17.69,16.69,14.81,14.41,12.41,12.25,14.66,17.84,20.38,26.03,28.66,30.41,31.69,33.47,32.97,34.03,34.66,34.69,34.62,34.69,32.5,34.41,32.75,30.19,27.56,24.16,24.19,21.28,21.06,23.28,24.25,24.38,24.81,26.97,25.78,28.78,30.28,32.22,35.84,37.59,39.12,36.69,34.25,28.19,27.69,23.81,19.78,20.75,20.75,20.25,20.25,22.12,24.53,25.41,27.66,28.34,29.44,29.03,26.47,30.31,29.44,30.78,29.25,31.16,29.25,24.78,25.75,23.81,21.94,20.44,19.03,19.03,15.72,13.94,15.62,14.81,15.31,15.91,17.78,17.88,19.91,20.47,20.53,20.28,17.5,19.0,19.41,23.72,28.38,31.66,35.06,34.81,32.81,31.12,28.94,29.06,28.78,30.0,32.62,31.44,30.09,32.12,32.28,29.53,31.38,31.25,29.31,27.38,24.19,22.72,19.81,17.56,19.03,19.0,16.28,21.38,21.66,23.47,23.97,25.31,24.0,23.0,22.44,23.12,25.38,27.25,31.38,32.56,34.97,33.56,34.25,33.62,32.38,31.06,27.97,28.09,25.62,25.5,26.0,28.41,29.06,27.97,27.31,23.78,20.25,19.53,17.88,19.47,19.72,21.59,22.91,20.09,22.41,20.66,20.16,21.09,22.81,21.12,21.25,22.25,21.59,23.69,26.56,30.53,34.56,34.38,38.44,40.44,40.88,41.72,42.47,42.53,42.31,38.47,39.5,37.66,37.66,37.66,36.5,37.41,33.47,30.69,28.81,24.34,23.34,23.62,26.41,25.53,32.19,32.94,35.56,37.16,37.75,36.81,36.31,34.78,31.31,30.0,27.94,27.25,27.62,28.44,28.75,27.22,26.88,26.28,22.91,25.56,27.31,27.0,26.44,28.81,28.62,27.66,31.56,31.25,31.94,31.59,31.78,30.94,30.97,30.62,31.12,30.88,29.81,28.78,28.09,26.09,25.78,25.94,26.25,24.41,23.28,20.25,18.03,16.94,15.91,14.72,14.62,12.5,9.28:7.5,9.56,8.78,8.91,9.62,10.31,10.0,11.66,9.94,8.75,9.31,8.03,7.16,7.78,7.44,8.75,9.62,8.03,12.16,8.62,12.31,13.44,13.09,14.44,13.22,12.53,9.56,9.16,6.97,7.31,3.75,5.97,6.75,8.06,10.56,11.56,11.09,8.69,5.34,5.19,4.44,5.19,7.56,7.81,8.19,8.12,7.38,10.59,11.56,13.81,15.66,15.12,14.66,8.62,6.75,2.0,-3.09,-4.03,-4.28,-6.22,-6.97,-5.78,-4.81,-4.66,-4.44,3.09,4.5,8.88,14.25,13.25,12.38,9.19,4.59,1.5,-1.53,-2.09,-4.22,-6.03,-5.41,-6.47,-4.66,-1.84,-0.41,2.69,6.0,8.28,8.94,8.44,14.53,14.06,18.41,20.44,20.69,21.28,11.56,10.31,8.28,6.62,6.94,9.0,11.72,10.81,11.94,11.06,8.84,6.19,6.31,6.53,8.22,12.56,15.84,19.03,18.09,20.91,19.06,22.5,21.41,21.44,20.5,18.88,17.66,15.28,14.16,13.06,12.34,9.94,10.72,10.12,9.62,12.38,15.84,18.41,16.62,20.72,24.0,23.41,26.28,27.44,22.94,21.56,18.91,15.56,12.88,12.12,9.78,7.19,5.28,4.19,4.0,5.94,6.97,7.91,7.66,5.41,4.72,4.19,4.66,8.22,5.03,11.47,9.88,12.44,14.5,16.62,15.06,16.53,14.59,12.75,11.19,7.03,3.56,3.44,0.09,2.38,5.19,9.47,12.03,15.28,18.97,19.09,23.34,20.91,22.0,23.25,22.47,22.06,23.12,21.84,20.41,21.66,17.84,21.56,21.94,23.47,23.19,27.56,28.25,29.66,30.09,32.0,31.56,29.66,28.56,28.47,25.84,25.69,25.06,24.41,25.0,25.19,23.56,28.81,25.53,30.09,29.31,32.44,33.84,34.84,37.47,38.25,37.0,35.97,34.94,32.03,31.44,31.28,31.03,30.91,30.62,29.75,28.59,27.72,25.28,27.19,25.94,28.09,28.66,30.31,29.66,29.06,30.62,30.16,31.69,26.31,29.25,29.66,28.34,31.34,35.06,37.41,38.0,37.91,33.94,33.66,29.06,28.25,26.5,26.91,26.94,27.06,27.94,28.69,29.44,24.53,31.62,29.25,30.53,34.69,35.91,33.03,33.12,32.25,27.59,27.59,28.72,26.25,28.19,31.69,32.66,35.75,37.16,37.53,36.88,36.56,33.16,30.44,28.81,25.41,28.56,31.44,35.78,41.19,43.91,44.75,46.38,41.88,41.88,37.84,36.72,36.16,35.81,31.5,32.62,28.91,28.0,29.59,28.72,30.66,32.41,32.31,31.69,32.0,28.19,27.78,23.84,24.53,29.0,33.41,37.41,43.06,49.06,49.75,54.88,53.25,52.59,50.56,48.25,47.34,46.19,45.62,44.09,38.84,36.97,34.59,32.41,30.78,32.03,31.41,31.22,31.34,26.0,27.97,25.12,25.03,26.34,33.94,35.12,39.88,43.25,45.12,46.59,45.06,43.38,41.16,37.25,37.69,37.88,37.75,34.5,35.19,30.69,28.72,25.91,27.69,26.03,27.16,27.41,26.69,25.88,28.41,31.5,32.16,35.47,34.91,35.66,35.28,35.91,36.16,36.94,37.88,41.53,41.94,42.16,41.66,39.19,34.19,32.69,30.03,28.03,27.97,26.19,26.75,25.47,27.09,26.28,26.25,22.38,25.75,23.09,21.28,25.0,25.62,24.5,26.59,27.81,29.44,29.38,32.5,31.47,31.5,30.41,26.66,21.31,20.81,16.19,14.59,19.03,19.56,22.88,23.5,24.03,23.06,21.72,21.81,19.34,17.88,19.41,20.34,18.34,24.75,24.84,25.53,28.94,29.31,26.25,27.53,28.81,25.12,28.31,29.28,29.53,29.81,27.47,24.94,19.94,19.91,16.06,16.84,17.53,17.84,15.34,14.31,14.06,10.25,14.09,16.03,17.25,20.56,18.09,18.81,17.81,18.03,18.06,22.75,21.72,23.56,23.81,23.19,21.94,24.5,22.19,18.94,22.19,22.56,21.78,22.28,21.31,18.78,17.59,16.19,16.31,17.31,22.78,24.56,30.41,34.59,34.78,38.47,41.16,39.41,39.06,37.94,35.84,34.06,29.53,29.91,30.59,28.25,28.22,27.62,27.34,24.56,22.19,23.66,22.44,24.34,25.97,28.5,31.62,30.62,31.34,34.44,34.03,34.78,34.28,34.38,33.72,31.22,30.25,33.34,31.16,31.12,28.78,29.28,28.44,25.78,25.88,21.25,22.81,19.62,22.66,26.06,26.53,26.94,27.41,25.12,25.88,25.78,26.16,24.22,30.66,30.03,32.03,32.28,32.66,28.69,30.75,28.62,28.06,27.72,24.94,23.91,21.09,23.06,25.22,29.44,35.44,36.5,43.44,44.38,46.22,44.31,42.81,38.91,35.94,33.69,30.38,31.31,29.44,29.44,31.38,32.53,31.81,36.06,35.25,32.5,35.28,34.0,33.16,35.66,39.12,41.22,39.59,46.44,45.03,48.03,46.44,44.91,40.91,34.19,29.91,27.53,25.78,24.31,23.91,23.5,24.41,25.53,26.41,30.53,31.38,34.12,36.19,39.41,39.81,42.91,42.62,43.72,44.25,43.09,43.41,39.53,36.66,32.31,29.03,27.34,25.66,25.5,24.44,24.84,20.88,20.12,20.84,18.91,21.25,23.62,25.19,26.84,27.12,27.0,24.03,29.5,29.16,30.06,33.5,32.66,32.06,30.72,26.69,24.12,21.78,22.5,21.19,23.44,25.06,24.72,24.62,21.38,20.28,17.69,16.69,14.81,14.41,12.41,12.25,14.66,17.84,20.38,26.03,28.66,30.41,31.69,33.47,32.97,34.03,34.66,34.69,34.62,34.69,32.5,34.41,32.75,30.19,27.56,24.16,24.19,21.28,21.06,23.28,24.25,24.38,24.81,26.97,25.78,28.78,30.28,32.22,35.84,37.59,39.12,36.69,34.25,28.19,27.69,23.81,19.78,20.75,20.75,20.25,20.25,22.12,24.53,25.41,27.66,28.34,29.44,29.03,26.47,30.31,29.44,30.78,29.25,31.16,29.25,24.78,25.75,23.81,21.94,20.44,19.03,19.03,15.72,13.94,15.62,14.81,15.31,15.91,17.78,17.88,19.91,20.47,20.53,20.28,17.5,19.0,19.41,23.72,28.38,31.66,35.06,34.81,32.81,31.12,28.94,29.06,28.78,30.0,32.62,31.44,30.09,32.12,32.28,29.53,31.38,31.25,29.31,27.38,24.19,22.72,19.81,17.56,19.03,19.0,16.28,21.38,21.66,23.47,23.97,25.31,24.0,23.0,22.44,23.12,25.38,27.25,31.38,32.56,34.97,33.56,34.25,33.62,32.38,31.06,27.97,28.09,25.62,25.5,26.0,28.41,29.06,27.97,27.31,23.78,20.25,19.53,17.88,19.47,19.72,21.59,22.91,20.09,22.41,20.66,20.16,21.09,22.81,21.12,21.25,22.25,21.59,23.69,26.56,30.53,34.56,34.38,38.44,40.44,40.88,41.72,42.47,42.53,42.31,38.47,39.5,37.66,37.66,37.66,36.5,37.41,33.47,30.69,28.81,24.34,23.34,23.62,26.41,25.53,32.19,32.94,35.56,37.16,37.75,36.81,36.31,34.78,31.31,30.0,27.94,27.25,27.62,28.44,28.75,27.22,26.88,26.28,22.91,25.56,27.31,27.0,26.44,28.81,28.62,27.66,31.56,31.25,31.94,31.59,31.78,30.94,30.97,30.62,31.12,30.88,29.81,28.78,28.09,26.09,25.78,25.94,26.25,24.41,23.28,20.25,18.03,16.94,15.91,14.72,14.62,12.5,9.28,-40.38,-40.84,-41.16,-43.41,-38.38,-36.19:10.0,11.66,9.94,8.75,9.31,8.03,7.16,7.78,7.44,8.75,9.62,8.03,12.16,8.62,12.31,13.44,13.09,14.44,13.22,12.53,9.56,9.16,6.97,7.31,3.75,5.97,6.75,8.06,10.56,11.56,11.09,8.69,5.34,5.19,4.44,5.19,7.56,7.81,8.19,8.12,7.38,10.59,11.56,13.81,15.66,15.12,14.66,8.62,6.75,2.0,-3.09,-4.03,-4.28,-6.22,-6.97,-5.78,-4.81,-4.66,-4.44,3.09,4.5,8.88,14.25,13.25,12.38,9.19,4.59,1.5,-1.53,-2.09,-4.22,-6.03,-5.41,-6.47,-4.66,-1.84,-0.41,2.69,6.0,8.28,8.94,8.44,14.53,14.06,18.41,20.44,20.69,21.28,11.56,10.31,8.28,6.62,6.94,9.0,11.72,10.81,11.94,11.06,8.84,6.19,6.31,6.53,8.22,12.56,15.84,19.03,18.09,20.91,19.06,22.5,21.41,21.44,20.5,18.88,17.66,15.28,14.16,13.06,12.34,9.94,10.72,10.12,9.62,12.38,15.84,18.41,16.62,20.72,24.0,23.41,26.28,27.44,22.94,21.56,18.91,15.56,12.88,12.12,9.78,7.19,5.28,4.19,4.0,5.94,6.97,7.91,7.66,5.41,4.72,4.19,4.66,8.22,5.03,11.47,9.88,12.44,14.5,16.62,15.06,16.53,14.59,12.75,11.19,7.03,3.56,3.44,0.09,2.38,5.19,9.47,12.03,15.28,18.97,19.09,23.34,20.91,22.0,23.25,22.47,22.06,23.12,21.84,20.41,21.66,17.84,21.56,21.94,23.47,23.19,27.56,28.25,29.66,30.09,32.0,31.56,29.66,28.56,28.47,25.84,25.69,25.06,24.41,25.0,25.19,23.56,28.81,25.53,30.09,29.31,32.44,33.84,34.84,37.47,38.25,37.0,35.97,34.94,32.03,31.44,31.28,31.03,30.91,30.62,29.75,28.59,27.72,25.28,27.19,25.94,28.09,28.66,30.31,29.66,29.06,30.62,30.16,31.69,26.31,29.25,29.66,28.34,31.34,35.06,37.41,38.0,37.91,33.94,33.66,29.06,28.25,26.5,26.91,26.94,27.06,27.94,28.69,29.44,24.53,31.62,29.25,30.53,34.69,35.91,33.03,33.12,32.25,27.59,27.59,28.72,26.25,28.19,31.69,32.66,35.75,37.16,37.53,36.88,36.56,33.16,30.44,28.81,25.41,28.56,31.44,35.78,41.19,43.91,44.75,46.38,41.88,41.88,37.84,36.72,36.16,35.81,31.5,32.62,28.91,28.0,29.59,28.72,30.66,32.41,32.31,31.69,32.0,28.19,27.78,23.84,24.53,29.0,33.41,37.41,43.06,49.06,49.75,54.88,53.25,52.59,50.56,48.25,47.34,46.19,45.62,44.09,38.84,36.97,34.59,32.41,30.78,32.03,31.41,31.22,31.34,26.0,27.97,25.12,25.03,26.34,33.94,35.12,39.88,43.25,45.12,46.59,45.06,43.38,41.16,37.25,37.69,37.88,37.75,34.5,35.19,30.69,28.72,25.91,27.69,26.03,27.16,27.41,26.69,25.88,28.41,31.5,32.16,35.47,34.91,35.66,35.28,35.91,36.16,36.94,37.88,41.53,41.94,42.16,41.66,39.19,34.19,32.69,30.03,28.03,27.97,26.19,26.75,25.47,27.09,26.28,26.25,22.38,25.75,23.09,21.28,25.0,25.62,24.5,26.59,27.81,29.44,29.38,32.5,31.47,31.5,30.41,26.66,21.31,20.81,16.19,14.59,19.03,19.56,22.88,23.5,24.03,23.06,21.72,21.81,19.34,17.88,19.41,20.34,18.34,24.75,24.84,25.53,28.94,29.31,26.25,27.53,28.81,25.12,28.31,29.28,29.53,29.81,27.47,24.94,19.94,19.91,16.06,16.84,17.53,17.84,15.34,14.31,14.06,10.25,14.09,16.03,17.25,20.56,18.09,18.81,17.81,18.03,18.06,22.75,21.72,23.56,23.81,23.19,21.94,24.5,22.19,18.94,22.19,22.56,21.78,22.28,21.31,18.78,17.59,16.19,16.31,17.31,22.78,24.56,30.41,34.59,34.78,38.47,41.16,39.41,39.06,37.94,35.84,34.06,29.53,29.91,30.59,28.25,28.22,27.62,27.34,24.56,22.19,23.66,22.44,24.34,25.97,28.5,31.62,30.62,31.34,34.44,34.03,34.78,34.28,34.38,33.72,31.22,30.25,33.34,31.16,31.12,28.78,29.28,28.44,25.78,25.88,21.25,22.81,19.62,22.66,26.06,26.53,26.94,27.41,25.12,25.88,25.78,26.16,24.22,30.66,30.03,32.03,32.28,32.66,28.69,30.75,28.62,28.06,27.72,24.94,23.91,21.09,23.06,25.22,29.44,35.44,36.5,43.44,44.38,46.22,44.31,42.81,38.91,35.94,33.69,30.38,31.31,29.44,29.44,31.38,32.53,31.81,36.06,35.25,32.5,35.28,34.0,33.16,35.66,39.12,41.22,39.59,46.44,45.03,48.03,46.44,44.91,40.91,34.19,29.91,27.53,25.78,24.31,23.91,23.5,24.41,25.53,26.41,30.53,31.38,34.12,36.19,39.41,39.81,42.91,42.62,43.72,44.25,43.09,43.41,39.53,36.66,32.31,29.03,27.34,25.66,25.5,24.44,24.84,20.88,20.12,20.84,18.91,21.25,23.62,25.19,26.84,27.12,27.0,24.03,29.5,29.16,30.06,33.5,32.66,32.06,30.72,26.69,24.12,21.78,22.5,21.19,23.44,25.06,24.72,24.62,21.38,20.28,17.69,16.69,14.81,14.41,12.41,12.25,14.66,17.84,20.38,26.03,28.66,30.41,31.69,33.47,32.97,34.03,34.66,34.69,34.62,34.69,32.5,34.41,32.75,30.19,27.56,24.16,24.19,21.28,21.06,23.28,24.25,24.38,24.81,26.97,25.78,28.78,30.28,32.22,35.84,37.59,39.12,36.69,34.25,28.19,27.69,23.81,19.78,20.75,20.75,20.25,20.25,22.12,24.53,25.41,27.66,28.34,29.44,29.03,26.47,30.31,29.44,30.78,29.25,31.16,29.25,24.78,25.75,23.81,21.94,20.44,19.03,19.03,15.72,13.94,15.62,14.81,15.31,15.91,17.78,17.88,19.91,20.47,20.53,20.28,17.5,19.0,19.41,23.72,28.38,31.66,35.06,34.81,32.81,31.12,28.94,29.06,28.78,30.0,32.62,31.44,30.09,32.12,32.28,29.53,31.38,31.25,29.31,27.38,24.19,22.72,19.81,17.56,19.03,19.0,16.28,21.38,21.66,23.47,23.97,25.31,24.0,23.0,22.44,23.12,25.38,27.25,31.38,32.56,34.97,33.56,34.25,33.62,32.38,31.06,27.97,28.09,25.62,25.5,26.0,28.41,29.06,27.97,27.31,23.78,20.25,19.53,17.88,19.47,19.72,21.59,22.91,20.09,22.41,20.66,20.16,21.09,22.81,21.12,21.25,22.25,21.59,23.69,26.56,30.53,34.56,34.38,38.44,40.44,40.88,41.72,42.47,42.53,42.31,38.47,39.5,37.66,37.66,37.66,36.5,37.41,33.47,30.69,28.81,24.34,23.34,23.62,26.41,25.53,32.19,32.94,35.56,37.16,37.75,36.81,36.31,34.78,31.31,30.0,27.94,27.25,27.62,28.44,28.75,27.22,26.88,26.28,22.91,25.56,27.31,27.0,26.44,28.81,28.62,27.66,31.56,31.25,31.94,31.59,31.78,30.94,30.97,30.62,31.12,30.88,29.81,28.78,28.09,26.09,25.78,25.94,26.25,24.41,23.28,20.25,18.03,16.94,15.91,14.72,14.62,12.5,9.28,-40.38,-40.84,-41.16,-43.41,-38.38,-36.19,-35.28,-35.22,-32.72,-34.03,-31.59,-29.69:7.16,7.78,7.44,8.75,9.62,8.03,12.16,8.62,12.31,13.44,13.09,14.44,13.22,12.53,9.56,9.16,6.97,7.31,3.75,5.97,6.75,8.06,10.56,11.56,11.09,8.69,5.34,5.19,4.44,5.19,7.56,7.81,8.19,8.12,7.38,10.59,11.56,13.81,15.66,15.12,14.66,8.62,6.75,2.0,-3.09,-4.03,-4.28,-6.22,-6.97,-5.78,-4.81,-4.66,-4.44,3.09,4.5,8.88,14.25,13.25,12.38,9.19,4.59,1.5,-1.53,-2.09,-4.22,-6.03,-5.41,-6.47,-4.66,-1.84,-0.41,2.69,6.0,8.28,8.94,8.44,14.53,14.06,18.41,20.44,20.69,21.28,11.56,10.31,8.28,6.62,6.94,9.0,11.72,10.81,11.94,11.06,8.84,6.19,6.31,6.53,8.22,12.56,15.84,19.03,18.09,20.91,19.06,22.5,21.41,21.44,20.5,18.88,17.66,15.28,14.16,13.06,12.34,9.94,10.72,10.12,9.62,12.38,15.84,18.41,16.62,20.72,24.0,23.41,26.28,27.44,22.94,21.56,18.91,15.56,12.88,12.12,9.78,7.19,5.28,4.19,4.0,5.94,6.97,7.91,7.66,5.41,4.72,4.19,4.66,8.22,5.03,11.47,9.88,12.44,14.5,16.62,15.06,16.53,14.59,12.75,11.19,7.03,3.56,3.44,0.09,2.38,5.19,9.47,12.03,15.28,18.97,19.09,23.34,20.91,22.0,23.25,22.47,22.06,23.12,21.84,20.41,21.66,17.84,21.56,21.94,23.47,23.19,27.56,28.25,29.66,30.09,32.0,31.56,29.66,28.56,28.47,25.84,25.69,25.06,24.41,25.0,25.19,23.56,28.81,25.53,30.09,29.31,32.44,33.84,34.84,37.47,38.25,37.0,35.97,34.94,32.03,31.44,31.28,31.03,30.91,30.62,29.75,28.59,27.72,25.28,27.19,25.94,28.09,28.66,30.31,29.66,29.06,30.62,30.16,31.69,26.31,29.25,29.66,28.34,31.34,35.06,37.41,38.0,37.91,33.94,33.66,29.06,28.25,26.5,26.91,26.94,27.06,27.94,28.69,29.44,24.53,31.62,29.25,30.53,34.69,35.91,33.03,33.12,32.25,27.59,27.59,28.72,26.25,28.19,31.69,32.66,35.75,37.16,37.53,36.88,36.56,33.16,30.44,28.81,25.41,28.56,31.44,35.78,41.19,43.91,44.75,46.38,41.88,41.88,37.84,36.72,36.16,35.81,31.5,32.62,28.91,28.0,29.59,28.72,30.66,32.41,32.31,31.69,32.0,28.19,27.78,23.84,24.53,29.0,33.41,37.41,43.06,49.06,49.75,54.88,53.25,52.59,50.56,48.25,47.34,46.19,45.62,44.09,38.84,36.97,34.59,32.41,30.78,32.03,31.41,31.22,31.34,26.0,27.97,25.12,25.03,26.34,33.94,35.12,39.88,43.25,45.12,46.59,45.06,43.38,41.16,37.25,37.69,37.88,37.75,34.5,35.19,30.69,28.72,25.91,27.69,26.03,27.16,27.41,26.69,25.88,28.41,31.5,32.16,35.47,34.91,35.66,35.28,35.91,36.16,36.94,37.88,41.53,41.94,42.16,41.66,39.19,34.19,32.69,30.03,28.03,27.97,26.19,26.75,25.47,27.09,26.28,26.25,22.38,25.75,23.09,21.28,25.0,25.62,24.5,26.59,27.81,29.44,29.38,32.5,31.47,31.5,30.41,26.66,21.31,20.81,16.19,14.59,19.03,19.56,22.88,23.5,24.03,23.06,21.72,21.81,19.34,17.88,19.41,20.34,18.34,24.75,24.84,25.53,28.94,29.31,26.25,27.53,28.81,25.12,28.31,29.28,29.53,29.81,27.47,24.94,19.94,19.91,16.06,16.84,17.53,17.84,15.34,14.31,14.06,10.25,14.09,16.03,17.25,20.56,18.09,18.81,17.81,18.03,18.06,22.75,21.72,23.56,23.81,23.19,21.94,24.5,22.19,18.94,22.19,22.56,21.78,22.28,21.31,18.78,17.59,16.19,16.31,17.31,22.78,24.56,30.41,34.59,34.78,38.47,41.16,39.41,39.06,37.94,35.84,34.06,29.53,29.91,30.59,28.25,28.22,27.62,27.34,24.56,22.19,23.66,22.44,24.34,25.97,28.5,31.62,30.62,31.34,34.44,34.03,34.78,34.28,34.38,33.72,31.22,30.25,33.34,31.16,31.12,28.78,29.28,28.44,25.78,25.88,21.25,22.81,19.62,22.66,26.06,26.53,26.94,27.41,25.12,25.88,25.78,26.16,24.22,30.66,30.03,32.03,32.28,32.66,28.69,30.75,28.62,28.06,27.72,24.94,23.91,21.09,23.06,25.22,29.44,35.44,36.5,43.44,44.38,46.22,44.31,42.81,38.91,35.94,33.69,30.38,31.31,29.44,29.44,31.38,32.53,31.81,36.06,35.25,32.5,35.28,34.0,33.16,35.66,39.12,41.22,39.59,46.44,45.03,48.03,46.44,44.91,40.91,34.19,29.91,27.53,25.78,24.31,23.91,23.5,24.41,25.53,26.41,30.53,31.38,34.12,36.19,39.41,39.81,42.91,42.62,43.72,44.25,43.09,43.41,39.53,36.66,32.31,29.03,27.34,25.66,25.5,24.44,24.84,20.88,20.12,20.84,18.91,21.25,23.62,25.19,26.84,27.12,27.0,24.03,29.5,29.16,30.06,33.5,32.66,32.06,30.72,26.69,24.12,21.78,22.5,21.19,23.44,25.06,24.72,24.62,21.38,20.28,17.69,16.69,14.81,14.41,12.41,12.25,14.66,17.84,20.38,26.03,28.66,30.41,31.69,33.47,32.97,34.03,34.66,34.69,34.62,34.69,32.5,34.41,32.75,30.19,27.56,24.16,24.19,21.28,21.06,23.28,24.25,24.38,24.81,26.97,25.78,28.78,30.28,32.22,35.84,37.59,39.12,36.69,34.25,28.19,27.69,23.81,19.78,20.75,20.75,20.25,20.25,22.12,24.53,25.41,27.66,28.34,29.44,29.03,26.47,30.31,29.44,30.78,29.25,31.16,29.25,24.78,25.75,23.81,21.94,20.44,19.03,19.03,15.72,13.94,15.62,14.81,15.31,15.91,17.78,17.88,19.91,20.47,20.53,20.28,17.5,19.0,19.41,23.72,28.38,31.66,35.06,34.81,32.81,31.12,28.94,29.06,28.78,30.0,32.62,31.44,30.09,32.12,32.28,29.53,31.38,31.25,29.31,27.38,24.19,22.72,19.81,17.56,19.03,19.0,16.28,21.38,21.66,23.47,23.97,25.31,24.0,23.0,22.44,23.12,25.38,27.25,31.38,32.56,34.97,33.56,34.25,33.62,32.38,31.06,27.97,28.09,25.62,25.5,26.0,28.41,29.06,27.97,27.31,23.78,20.25,19.53,17.88,19.47,19.72,21.59,22.91,20.09,22.41,20.66,20.16,21.09,22.81,21.12,21.25,22.25,21.59,23.69,26.56,30.53,34.56,34.38,38.44,40.44,40.88,41.72,42.47,42.53,42.31,38.47,39.5,37.66,37.66,37.66,36.5,37.41,33.47,30.69,28.81,24.34,23.34,23.62,26.41,25.53,32.19,32.94,35.56,37.16,37.75,36.81,36.31,34.78,31.31,30.0,27.94,27.25,27.62,28.44,28.75,27.22,26.88,26.28,22.91,25.56,27.31,27.0,26.44,28.81,28.62,27.66,31.56,31.25,31.94,31.59,31.78,30.94,30.97,30.62,31.12,30.88,29.81,28.78,28.09,26.09,25.78,25.94,26.25,24.41,23.28,20.25,18.03,16.94,15.91,14.72,14.62,12.5,9.28,-40.38,-40.84,-41.16,-43.41,-38.38,-36.19,-35.28,-35.22,-32.72,-34.03,-31.59,-29.69,-27.94,-26.78,-28.5,-29.09,-28.97,-30.44:12.16,8.62,12.31,13.44,13.09,14.44,13.22,12.53,9.56,9.16,6.97,7.31,3.75,5.97,6.75,8.06,10.56,11.56,11.09,8.69,5.34,5.19,4.44,5.19,7.56,7.81,8.19,8.12,7.38,10.59,11.56,13.81,15.66,15.12,14.66,8.62,6.75,2.0,-3.09,-4.03,-4.28,-6.22,-6.97,-5.78,-4.81,-4.66,-4.44,3.09,4.5,8.88,14.25,13.25,12.38,9.19,4.59,1.5,-1.53,-2.09,-4.22,-6.03,-5.41,-6.47,-4.66,-1.84,-0.41,2.69,6.0,8.28,8.94,8.44,14.53,14.06,18.41,20.44,20.69,21.28,11.56,10.31,8.28,6.62,6.94,9.0,11.72,10.81,11.94,11.06,8.84,6.19,6.31,6.53,8.22,12.56,15.84,19.03,18.09,20.91,19.06,22.5,21.41,21.44,20.5,18.88,17.66,15.28,14.16,13.06,12.34,9.94,10.72,10.12,9.62,12.38,15.84,18.41,16.62,20.72,24.0,23.41,26.28,27.44,22.94,21.56,18.91,15.56,12.88,12.12,9.78,7.19,5.28,4.19,4.0,5.94,6.97,7.91,7.66,5.41,4.72,4.19,4.66,8.22,5.03,11.47,9.88,12.44,14.5,16.62,15.06,16.53,14.59,12.75,11.19,7.03,3.56,3.44,0.09,2.38,5.19,9.47,12.03,15.28,18.97,19.09,23.34,20.91,22.0,23.25,22.47,22.06,23.12,21.84,20.41,21.66,17.84,21.56,21.94,23.47,23.19,27.56,28.25,29.66,30.09,32.0,31.56,29.66,28.56,28.47,25.84,25.69,25.06,24.41,25.0,25.19,23.56,28.81,25.53,30.09,29.31,32.44,33.84,34.84,37.47,38.25,37.0,35.97,34.94,32.03,31.44,31.28,31.03,30.91,30.62,29.75,28.59,27.72,25.28,27.19,25.94,28.09,28.66,30.31,29.66,29.06,30.62,30.16,31.69,26.31,29.25,29.66,28.34,31.34,35.06,37.41,38.0,37.91,33.94,33.66,29.06,28.25,26.5,26.91,26.94,27.06,27.94,28.69,29.44,24.53,31.62,29.25,30.53,34.69,35.91,33.03,33.12,32.25,27.59,27.59,28.72,26.25,28.19,31.69,32.66,35.75,37.16,37.53,36.88,36.56,33.16,30.44,28.81,25.41,28.56,31.44,35.78,41.19,43.91,44.75,46.38,41.88,41.88,37.84,36.72,36.16,35.81,31.5,32.62,28.91,28.0,29.59,28.72,30.66,32.41,32.31,31.69,32.0,28.19,27.78,23.84,24.53,29.0,33.41,37.41,43.06,49.06,49.75,54.88,53.25,52.59,50.56,48.25,47.34,46.19,45.62,44.09,38.84,36.97,34.59,32.41,30.78,32.03,31.41,31.22,31.34,26.0,27.97,25.12,25.03,26.34,33.94,35.12,39.88,43.25,45.12,46.59,45.06,43.38,41.16,37.25,37.69,37.88,37.75,34.5,35.19,30.69,28.72,25.91,27.69,26.03,27.16,27.41,26.69,25.88,28.41,31.5,32.16,35.47,34.91,35.66,35.28,35.91,36.16,36.94,37.88,41.53,41.94,42.16,41.66,39.19,34.19,32.69,30.03,28.03,27.97,26.19,26.75,25.47,27.09,26.28,26.25,22.38,25.75,23.09,21.28,25.0,25.62,24.5,26.59,27.81,29.44,29.38,32.5,31.47,31.5,30.41,26.66,21.31,20.81,16.19,14.59,19.03,19.56,22.88,23.5,24.03,23.06,21.72,21.81,19.34,17.88,19.41,20.34,18.34,24.75,24.84,25.53,28.94,29.31,26.25,27.53,28.81,25.12,28.31,29.28,29.53,29.81,27.47,24.94,19.94,19.91,16.06,16.84,17.53,17.84,15.34,14.31,14.06,10.25,14.09,16.03,17.25,20.56,18.09,18.81,17.81,18.03,18.06,22.75,21.72,23.56,23.81,23.19,21.94,24.5,22.19,18.94,22.19,22.56,21.78,22.28,21.31,18.78,17.59,16.19,16.31,17.31,22.78,24.56,30.41,34.59,34.78,38.47,41.16,39.41,39.06,37.94,35.84,34.06,29.53,29.91,30.59,28.25,28.22,27.62,27.34,24.56,22.19,23.66,22.44,24.34,25.97,28.5,31.62,30.62,31.34,34.44,34.03,34.78,34.28,34.38,33.72,31.22,30.25,33.34,31.16,31.12,28.78,29.28,28.44,25.78,25.88,21.25,22.81,19.62,22.66,26.06,26.53,26.94,27.41,25.12,25.88,25.78,26.16,24.22,30.66,30.03,32.03,32.28,32.66,28.69,30.75,28.62,28.06,27.72,24.94,23.91,21.09,23.06,25.22,29.44,35.44,36.5,43.44,44.38,46.22,44.31,42.81,38.91,35.94,33.69,30.38,31.31,29.44,29.44,31.38,32.53,31.81,36.06,35.25,32.5,35.28,34.0,33.16,35.66,39.12,41.22,39.59,46.44,45.03,48.03,46.44,44.91,40.91,34.19,29.91,27.53,25.78,24.31,23.91,23.5,24.41,25.53,26.41,30.53,31.38,34.12,36.19,39.41,39.81,42.91,42.62,43.72,44.25,43.09,43.41,39.53,36.66,32.31,29.03,27.34,25.66,25.5,24.44,24.84,20.88,20.12,20.84,18.91,21.25,23.62,25.19,26.84,27.12,27.0,24.03,29.5,29.16,30.06,33.5,32.66,32.06,30.72,26.69,24.12,21.78,22.5,21.19,23.44,25.06,24.72,24.62,21.38,20.28,17.69,16.69,14.81,14.41,12.41,12.25,14.66,17.84,20.38,26.03,28.66,30.41,31.69,33.47,32.97,34.03,34.66,34.69,34.62,34.69,32.5,34.41,32.75,30.19,27.56,24.16,24.19,21.28,21.06,23.28,24.25,24.38,24.81,26.97,25.78,28.78,30.28,32.22,35.84,37.59,39.12,36.69,34.25,28.19,27.69,23.81,19.78,20.75,20.75,20.25,20.25,22.12,24.53,25.41,27.66,28.34,29.44,29.03,26.47,30.31,29.44,30.78,29.25,31.16,29.25,24.78,25.75,23.81,21.94,20.44,19.03,19.03,15.72,13.94,15.62,14.81,15.31,15.91,17.78,17.88,19.91,20.47,20.53,20.28,17.5,19.0,19.41,23.72,28.38,31.66,35.06,34.81,32.81,31.12,28.94,29.06,28.78,30.0,32.62,31.44,30.09,32.12,32.28,29.53,31.38,31.25,29.31,27.38,24.19,22.72,19.81,17.56,19.03,19.0,16.28,21.38,21.66,23.47,23.97,25.31,24.0,23.0,22.44,23.12,25.38,27.25,31.38,32.56,34.97,33.56,34.25,33.62,32.38,31.06,27.97,28.09,25.62,25.5,26.0,28.41,29.06,27.97,27.31,23.78,20.25,19.53,17.88,19.47,19.72,21.59,22.91,20.09,22.41,20.66,20.16,21.09,22.81,21.12,21.25,22.25,21.59,23.69,26.56,30.53,34.56,34.38,38.44,40.44,40.88,41.72,42.47,42.53,42.31,38.47,39.5,37.66,37.66,37.66,36.5,37.41,33.47,30.69,28.81,24.34,23.34,23.62,26.41,25.53,32.19,32.94,35.56,37.16,37.75,36.81,36.31,34.78,31.31,30.0,27.94,27.25,27.62,28.44,28.75,27.22,26.88,26.28,22.91,25.56,27.31,27.0,26.44,28.81,28.62,27.66,31.56,31.25,31.94,31.59,31.78,30.94,30.97,30.62,31.12,30.88,29.81,28.78,28.09,26.09,25.78,25.94,26.25,24.41,23.28,20.25,18.03,16.94,15.91,14.72,14.62,12.5,9.28,-40.38,-40.84,-41.16,-43.41,-38.38,-36.19,-35.28,-35.22,-32.72,-34.03,-31.59,-29.69,-27.94,-26.78,-28.5,-29.09,-28.97,-30.44,-30.47,-29.19,-28.53,-27.84,-29.19,-28.19:13.22,12.53,9.56,9.16,6.97,7.31,3.75,5.97,6.75,8.06,10.56,11.56,11.09,8.69,5.34,5.19,4.44,5.19,7.56,7.81,8.19,8.12,7.38,10.59,11.56,13.81,15.66,15.12,14.66,8.62,6.75,2.0,-3.09,-4.03,-4.28,-6.22,-6.97,-5.78,-4.81,-4.66,-4.44,3.09,4.5,8.88,14.25,13.25,12.38,9.19,4.59,1.5,-1.53,-2.09,-4.22,-6.03,-5.41,-6.47,-4.66,-1.84,-0.41,2.69,6.0,8.28,8.94,8.44,14.53,14.06,18.41,20.44,20.69,21.28,11.56,10.31,8.28,6.62,6.94,9.0,11.72,10.81,11.94,11.06,8.84,6.19,6.31,6.53,8.22,12.56,15.84,19.03,18.09,20.91,19.06,22.5,21.41,21.44,20.5,18.88,17.66,15.28,14.16,13.06,12.34,9.94,10.72,10.12,9.62,12.38,15.84,18.41,16.62,20.72,24.0,23.41,26.28,27.44,22.94,21.56,18.91,15.56,12.88,12.12,9.78,7.19,5.28,4.19,4.0,5.94,6.97,7.91,7.66,5.41,4.72,4.19,4.66,8.22,5.03,11.47,9.88,12.44,14.5,16.62,15.06,16.53,14.59,12.75,11.19,7.03,3.56,3.44,0.09,2.38,5.19,9.47,12.03,15.28,18.97,19.09,23.34,20.91,22.0,23.25,22.47,22.06,23.12,21.84,20.41,21.66,17.84,21.56,21.94,23.47,23.19,27.56,28.25,29.66,30.09,32.0,31.56,29.66,28.56,28.47,25.84,25.69,25.06,24.41,25.0,25.19,23.56,28.81,25.53,30.09,29.31,32.44,33.84,34.84,37.47,38.25,37.0,35.97,34.94,32.03,31.44,31.28,31.03,30.91,30.62,29.75,28.59,27.72,25.28,27.19,25.94,28.09,28.66,30.31,29.66,29.06,30.62,30.16,31.69,26.31,29.25,29.66,28.34,31.34,35.06,37.41,38.0,37.91,33.94,33.66,29.06,28.25,26.5,26.91,26.94,27.06,27.94,28.69,29.44,24.53,31.62,29.25,30.53,34.69,35.91,33.03,33.12,32.25,27.59,27.59,28.72,26.25,28.19,31.69,32.66,35.75,37.16,37.53,36.88,36.56,33.16,30.44,28.81,25.41,28.56,31.44,35.78,41.19,43.91,44.75,46.38,41.88,41.88,37.84,36.72,36.16,35.81,31.5,32.62,28.91,28.0,29.59,28.72,30.66,32.41,32.31,31.69,32.0,28.19,27.78,23.84,24.53,29.0,33.41,37.41,43.06,49.06,49.75,54.88,53.25,52.59,50.56,48.25,47.34,46.19,45.62,44.09,38.84,36.97,34.59,32.41,30.78,32.03,31.41,31.22,31.34,26.0,27.97,25.12,25.03,26.34,33.94,35.12,39.88,43.25,45.12,46.59,45.06,43.38,41.16,37.25,37.69,37.88,37.75,34.5,35.19,30.69,28.72,25.91,27.69,26.03,27.16,27.41,26.69,25.88,28.41,31.5,32.16,35.47,34.91,35.66,35.28,35.91,36.16,36.94,37.88,41.53,41.94,42.16,41.66,39.19,34.19,32.69,30.03,28.03,27.97,26.19,26.75,25.47,27.09,26.28,26.25,22.38,25.75,23.09,21.28,25.0,25.62,24.5,26.59,27.81,29.44,29.38,32.5,31.47,31.5,30.41,26.66,21.31,20.81,16.19,14.59,19.03,19.56,22.88,23.5,24.03,23.06,21.72,21.81,19.34,17.88,19.41,20.34,18.34,24.75,24.84,25.53,28.94,29.31,26.25,27.53,28.81,25.12,28.31,29.28,29.53,29.81,27.47,24.94,19.94,19.91,16.06,16.84,17.53,17.84,15.34,14.31,14.06,10.25,14.09,16.03,17.25,20.56,18.09,18.81,17.81,18.03,18.06,22.75,21.72,23.56,23.81,23.19,21.94,24.5,22.19,18.94,22.19,22.56,21.78,22.28,21.31,18.78,17.59,16.19,16.31,17.31,22.78,24.56,30.41,34.59,34.78,38.47,41.16,39.41,39.06,37.94,35.84,34.06,29.53,29.91,30.59,28.25,28.22,27.62,27.34,24.56,22.19,23.66,22.44,24.34,25.97,28.5,31.62,30.62,31.34,34.44,34.03,34.78,34.28,34.38,33.72,31.22,30.25,33.34,31.16,31.12,28.78,29.28,28.44,25.78,25.88,21.25,22.81,19.62,22.66,26.06,26.53,26.94,27.41,25.12,25.88,25.78,26.16,24.22,30.66,30.03,32.03,32.28,32.66,28.69,30.75,28.62,28.06,27.72,24.94,23.91,21.09,23.06,25.22,29.44,35.44,36.5,43.44,44.38,46.22,44.31,42.81,38.91,35.94,33.69,30.38,31.31,29.44,29.44,31.38,32.53,31.81,36.06,35.25,32.5,35.28,34.0,33.16,35.66,39.12,41.22,39.59,46.44,45.03,48.03,46.44,44.91,40.91,34.19,29.91,27.53,25.78,24.31,23.91,23.5,24.41,25.53,26.41,30.53,31.38,34.12,36.19,39.41,39.81,42.91,42.62,43.72,44.25,43.09,43.41,39.53,36.66,32.31,29.03,27.34,25.66,25.5,24.44,24.84,20.88,20.12,20.84,18.91,21.25,23.62,25.19,26.84,27.12,27.0,24.03,29.5,29.16,30.06,33.5,32.66,32.06,30.72,26.69,24.12,21.78,22.5,21.19,23.44,25.06,24.72,24.62,21.38,20.28,17.69,16.69,14.81,14.41,12.41,12.25,14.66,17.84,20.38,26.03,28.66,30.41,31.69,33.47,32.97,34.03,34.66,34.69,34.62,34.69,32.5,34.41,32.75,30.19,27.56,24.16,24.19,21.28,21.06,23.28,24.25,24.38,24.81,26.97,25.78,28.78,30.28,32.22,35.84,37.59,39.12,36.69,34.25,28.19,27.69,23.81,19.78,20.75,20.75,20.25,20.25,22.12,24.53,25.41,27.66,28.34,29.44,29.03,26.47,30.31,29.44,30.78,29.25,31.16,29.25,24.78,25.75,23.81,21.94,20.44,19.03,19.03,15.72,13.94,15.62,14.81,15.31,15.91,17.78,17.88,19.91,20.47,20.53,20.28,17.5,19.0,19.41,23.72,28.38,31.66,35.06,34.81,32.81,31.12,28.94,29.06,28.78,30.0,32.62,31.44,30.09,32.12,32.28,29.53,31.38,31.25,29.31,27.38,24.19,22.72,19.81,17.56,19.03,19.0,16.28,21.38,21.66,23.47,23.97,25.31,24.0,23.0,22.44,23.12,25.38,27.25,31.38,32.56,34.97,33.56,34.25,33.62,32.38,31.06,27.97,28.09,25.62,25.5,26.0,28.41,29.06,27.97,27.31,23.78,20.25,19.53,17.88,19.47,19.72,21.59,22.91,20.09,22.41,20.66,20.16,21.09,22.81,21.12,21.25,22.25,21.59,23.69,26.56,30.53,34.56,34.38,38.44,40.44,40.88,41.72,42.47,42.53,42.31,38.47,39.5,37.66,37.66,37.66,36.5,37.41,33.47,30.69,28.81,24.34,23.34,23.62,26.41,25.53,32.19,32.94,35.56,37.16,37.75,36.81,36.31,34.78,31.31,30.0,27.94,27.25,27.62,28.44,28.75,27.22,26.88,26.28,22.91,25.56,27.31,27.0,26.44,28.81,28.62,27.66,31.56,31.25,31.94,31.59,31.78,30.94,30.97,30.62,31.12,30.88,29.81,28.78,28.09,26.09,25.78,25.94,26.25,24.41,23.28,20.25,18.03,16.94,15.91,14.72,14.62,12.5,9.28,-40.38,-40.84,-41.16,-43.41,-38.38,-36.19,-35.28,-35.22,-32.72,-34.03,-31.59,-29.69,-27.94,-26.78,-28.5,-29.09,-28.97,-30.44,-30.47,-29.19,-28.53,-27.84,-29.19,-28.19,-27.75,-28.5,-26.84,-26.84,-28.72,-31.53:negativity
14.94,17.0,18.28,21.28,24.16,27.44,28.91,29.41,28.12,25.69,24.28,22.06,20.53,20.19,19.78,19.16,17.22,16.28,14.97,13.38,12.25,10.41,10.5,8.84,8.56,9.97,11.62,13.47,17.47,20.44,22.34,24.81,26.5,28.09,29.38,30.91,32.22,32.88,33.88,32.94,33.66,33.41,34.41,34.62,36.47,37.03,36.69,37.84,38.28,37.94,39.16,41.12,40.69,41.19,40.56,39.56,38.31,37.75,37.25,36.66,37.28,36.69,36.78,36.91,35.88,33.88,31.44,25.72,23.59,18.78,16.88,15.5,15.53,15.94,15.41,15.78,15.25,15.16,16.31,18.22,19.91,21.66,24.31,25.03,23.91,25.44,25.88,24.84,22.81,24.12,23.12,23.94,26.34,27.16,31.12,32.75,33.97,34.38,35.38,34.94,32.66,30.66,28.81,27.38,26.69,26.16,26.66,26.5,27.12,24.5,24.75,24.03,23.5,23.44,24.31,25.44,25.94,26.78,28.12,27.41,29.94,32.66,32.53,35.16,34.88,33.25,29.81,27.88,23.97,20.62,19.16,18.22,18.22,19.78,21.0,21.84,21.34,21.25,19.94,20.72,19.72,20.0,21.72,21.91,23.75,24.41,25.84,25.22,25.53,26.0,26.41,27.66,28.0,29.75,29.62,29.19,29.0,27.44,25.56,23.69,22.09,20.62,20.44,21.56,23.47,24.06,26.75,27.66,28.75,29.53,29.16,29.06,27.31,27.06,25.75,25.38,26.19,26.44,26.0,25.75,26.62,26.22,26.81,28.56,27.84,27.53,27.16,25.31,25.88,25.31,26.31,25.19,25.91,26.56,27.94,28.69,29.44,31.19,30.69,31.5,31.44,31.72,31.44,32.41,30.38,31.69,32.31,32.75,33.56,35.53,36.31,35.38,36.5,35.75,34.69,33.47,32.16,30.56,29.53,28.69,27.44,27.69,26.94,26.75,25.84,23.62,21.31,19.16,16.28,15.56,18.06,20.69,24.31,29.19,32.03,34.12,32.94,32.38,30.0,28.34,27.16,27.78,28.47,28.38,28.44,28.66,26.25,24.91,24.16,24.38,24.41,24.97,26.66,27.66,29.25,30.56,32.59,33.66,31.06,31.31,30.12,27.44,27.03,27.19,27.66,28.19,28.53,28.78,26.94,25.69,22.12,20.0,18.72,18.25,18.06,19.44,21.19,22.69,24.28,24.72,25.62,25.06,25.12,25.31,24.38,25.75,27.38,28.25,30.31,33.25,34.91,37.0,38.09,39.44,40.09,41.91,42.38,42.34,43.31,42.94,41.84,42.0,41.78,41.59,41.47,40.59,39.5,37.44,35.66,33.44,32.09,31.53,31.78,31.84,33.0,32.38,32.12,29.75,27.91,24.62,22.5,20.91,20.56,22.44,23.97,25.44,26.72,27.19,25.97,25.5,24.72,24.25,24.59,23.78,24.19,24.81,24.56,25.0,24.44,23.38,22.44,21.28,21.06,19.78,18.88,18.94,17.72,18.41,19.41,20.78,21.34,21.88,21.78,21.56,19.78,19.12,17.12,15.62,14.19,12.69,12.81,13.03,13.81,15.06,16.16,17.59,16.84,16.94,16.62,14.53,14.66,14.16,13.88,14.56,13.31,13.72,13.84,13.03,12.0,12.94,13.38,12.88,14.38,14.41,14.94,13.19,12.94,11.56,9.41,8.31,7.94,7.56,6.84,8.0,8.78,7.16,6.78,8.06,8.16,9.69,10.59,12.69,12.06,11.72,12.31,12.94,12.81,13.56,13.28,12.12,9.66,9.53,7.84,8.09,10.16,10.78,13.25,16.53,18.06,21.56,23.31,24.41,25.91,24.41,23.12,22.03,19.31,17.69,14.88,14.78,14.28,14.94,15.56,17.16,17.94,16.72,16.94,16.69,15.94,17.16,17.84,18.66,19.91,18.62,18.56,16.44,14.81,14.53,13.62,14.19,14.81,15.19,14.62,14.28,12.06,11.34,10.66,9.97,9.72,10.53,8.81,7.62,6.44,4.66,4.06,4.41,3.78,4.69,4.19,4.03,4.22,4.31,4.19,3.31,3.41,3.16,2.41,3.0,3.06,3.22,3.53,2.62,4.0,5.16,8.66,14.09,18.75,23.97,25.56,25.34,23.16,19.25,15.03,13.53,11.56,11.56,12.56,12.28,14.66,15.06,15.5,15.12,15.03,14.22,12.94,13.19,13.84,13.59,15.5,15.81,16.62,18.84,19.91,20.12,20.56,20.31,18.62,17.34,16.5,16.28,16.25,16.28,16.22,17.5,16.84,16.62,17.25,16.19,16.41,14.72,14.56,14.59,15.19,16.88,18.81,22.0,23.62,25.41,28.03,27.28,28.19,28.84,27.91,27.44,25.69,23.44,21.97,20.56,18.56,17.66,17.5,15.06,13.75,13.16,11.56,11.06,10.91,11.5,11.94,13.19,13.22,13.41,13.31,13.0,12.41,12.31,11.44,10.16,10.25,9.25,9.78,8.59,10.91,10.5,11.34,13.34,13.56,14.56,15.19,15.62,15.94,16.25,16.19,17.28,16.38,16.38,16.16,15.34,14.41,13.47,12.91,12.44,13.62,14.38,14.94,16.88,16.91,16.31,16.0,15.31,13.25,12.44,11.84,11.75,11.78,13.22,13.06,14.19,14.25,13.72,13.44,12.28,12.5,14.19,15.28,17.69,19.19,20.19,19.81,19.72,18.69,18.09,17.41,16.28,16.28,15.41,14.41,15.62,16.53,17.09,16.62,17.41,16.5,16.22,15.72,16.19,15.31,14.59,13.72,12.44,12.0,10.56,9.16,9.34,9.16,8.31,9.69,10.59,10.66,11.81,13.56,14.06,15.44,15.69,16.59,16.47,16.94,17.44,17.69,19.06,18.81,20.31,21.22,20.5,21.44,20.72,20.88,20.75,20.09,20.12,19.75,19.31,17.69,17.19,16.03,15.28,14.06,14.19,13.16,12.56,11.09,9.97,8.91,7.12,7.81,7.44,7.56,8.91,9.56,10.06,11.28,11.91,12.5,13.16,13.69,14.22,13.59,13.56,13.19,12.75,12.47,12.44,12.44,11.66,11.16,9.38,7.56,7.44,6.53,7.16,7.62,8.5,8.25,6.81,5.19,2.06,-0.06,-2.56,-5.41,-6.19,-7.03,-6.59,-5.84,-4.28,-2.41,-0.94,0.84,3.69,6.56,11.03,14.66,16.5,17.25,16.5,13.94,11.66,9.69,7.22,7.38,7.5,8.38,10.59,12.56,14.16,14.69,13.72,14.94,14.19,13.53,13.28,11.41,9.31,8.25,6.16,5.62,4.62,6.91,7.31,8.88,11.19,11.94,11.69,13.81,12.5,12.31,12.78,12.59,12.78,13.38,12.66,11.56,11.69,10.75,9.91,9.5,9.03,9.69,9.59,11.56,12.12,13.41,14.5,14.09,13.5,15.78,15.09,16.59,17.19,17.47,16.72,15.25,14.88,13.06,13.41,13.31,13.06,14.66,15.31,16.25,16.31,16.12,16.34,15.28,15.16,14.06,12.25,11.28,11.12,10.56,11.12,11.56,12.44,11.88,12.97,14.06,15.41,16.66,17.06,17.03,15.75,14.03,12.81,11.0,10.75,10.06,9.22,9.56,8.69,8.09,8.94,9.69,10.78,11.41,13.62,15.47,17.25,20.19,21.06,22.69,21.53,20.69,18.16,15.97,13.66,12.19,11.41,11.41,10.25,10.22,10.0,10.12,9.06,9.16,10.09,9.91,10.78,10.88,10.84,10.75,11.41,9.78,10.0,10.06,9.06,9.28,9.75,9.84,11.25,10.81,13.12,12.88,13.94,14.81,14.66,14.41,14.28,13.16,11.06,10.28,9.0,7.78,6.47,4.69,3.25,1.03,-0.53,-1.19,-1.72,-1.62,-1.91,-2.59,-4.47,-7.22,-11.72,-14.47,-18.72:28.91,29.41,28.12,25.69,24.28,22.06,20.53,20.19,19.78,19.16,17.22,16.28,14.97,13.38,12.25,10.41,10.5,8.84,8.56,9.97,11.62,13.47,17.47,20.44,22.34,24.81,26.5,28.09,29.38,30.91,32.22,32.88,33.88,32.94,33.66,33.41,34.41,34.62,36.47,37.03,36.69,37.84,38.28,37.94,39.16,41.12,40.69,41.19,40.56,39.56,38.31,37.75,37.25,36.66,37.28,36.69,36.78,36.91,35.88,33.88,31.44,25.72,23.59,18.78,16.88,15.5,15.53,15.94,15.41,15.78,15.25,15.16,16.31,18.22,19.91,21.66,24.31,25.03,23.91,25.44,25.88,24.84,22.81,24.12,23.12,23.94,26.34,27.16,31.12,32.75,33.97,34.38,35.38,34.94,32.66,30.66,28.81,27.38,26.69,26.16,26.66,26.5,27.12,24.5,24.75,24.03,23.5,23.44,24.31,25.44,25.94,26.78,28.12,27.41,29.94,32.66,32.53,35.16,34.88,33.25,29.81,27.88,23.97,20.62,19.16,18.22,18.22,19.78,21.0,21.84,21.34,21.25,19.94,20.72,19.72,20.0,21.72,21.91,23.75,24.41,25.84,25.22,25.53,26.0,26.41,27.66,28.0,29.75,29.62,29.19,29.0,27.44,25.56,23.69,22.09,20.62,20.44,21.56,23.47,24.06,26.75,27.66,28.75,29.53,29.16,29.06,27.31,27.06,25.75,25.38,26.19,26.44,26.0,25.75,26.62,26.22,26.81,28.56,27.84,27.53,27.16,25.31,25.88,25.31,26.31,25.19,25.91,26.56,27.94,28.69,29.44,31.19,30.69,31.5,31.44,31.72,31.44,32.41,30.38,31.69,32.31,32.75,33.56,35.53,36.31,35.38,36.5,35.75,34.69,33.47,32.16,30.56,29.53,28.69,27.44,27.69,26.94,26.75,25.84,23.62,21.31,19.16,16.28,15.56,18.06,20.69,24.31,29.19,32.03,34.12,32.94,32.38,30.0,28.34,27.16,27.78,28.47,28.38,28.44,28.66,26.25,24.91,24.16,24.38,24.41,24.97,26.66,27.66,29.25,30.56,32.59,33.66,31.06,31.31,30.12,27.44,27.03,27.19,27.66,28.19,28.53,28.78,26.94,25.69,22.12,20.0,18.72,18.25,18.06,19.44,21.19,22.69,24.28,24.72,25.62,25.06,25.12,25.31,24.38,25.75,27.38,28.25,30.31,33.25,34.91,37.0,38.09,39.44,40.09,41.91,42.38,42.34,43.31,42.94,41.84,42.0,41.78,41.59,41.47,40.59,39.5,37.44,35.66,33.44,32.09,31.53,31.78,31.84,33.0,32.38,32.12,29.75,27.91,24.62,22.5,20.91,20.56,22.44,23.97,25.44,26.72,27.19,25.97,25.5,24.72,24.25,24.59,23.78,24.19,24.81,24.56,25.0,24.44,23.38,22.44,21.28,21.06,19.78,18.88,18.94,17.72,18.41,19.41,20.78,21.34,21.88,21.78,21.56,19.78,19.12,17.12,15.62,14.19,12.69,12.81,13.03,13.81,15.06,16.16,17.59,16.84,16.94,16.62,14.53,14.66,14.16,13.88,14.56,13.31,13.72,13.84,13.03,12.0,12.94,13.38,12.88,14.38,14.41,14.94,13.19,12.94,11.56,9.41,8.31,7.94,7.56,6.84,8.0,8.78,7.16,6.78,8.06,8.16,9.69,10.59,12.69,12.06,11.72,12.31,12.94,12.81,13.56,13.28,12.12,9.66,9.53,7.84,8.09,10.16,10.78,13.25,16.53,18.06,21.56,23.31,24.41,25.91,24.41,23.12,22.03,19.31,17.69,14.88,14.78,14.28,14.94,15.56,17.16,17.94,16.72,16.94,16.69,15.94,17.16,17.84,18.66,19.91,18.62,18.56,16.44,14.81,14.53,13.62,14.19,14.81,15.19,14.62,14.28,12.06,11.34,10.66,9.97,9.72,10.53,8.81,7.62,6.44,4.66,4.06,4.41,3.78,4.69,4.19,4.03,4.22,4.31,4.19,3.31,3.41,3.16,2.41,3.0,3.06,3.22,3.53,2.62,4.0,5.16,8.66,14.09,18.75,23.97,25.56,25.34,23.16,19.25,15.03,13.53,11.56,11.56,12.56,12.28,14.66,15.06,15.5,15.12,15.03,14.22,12.94,13.19,13.84,13.59,15.5,15.81,16.62,18.84,19.91,20.12,20.56,20.31,18.62,17.34,16.5,16.28,16.25,16.28,16.22,17.5,16.84,16.62,17.25,16.19,16.41,14.72,14.56,14.59,15.19,16.88,18.81,22.0,23.62,25.41,28.03,27.28,28.19,28.84,27.91,27.44,25.69,23.44,21.97,20.56,18.56,17.66,17.5,15.06,13.75,13.16,11.56,11.06,10.91,11.5,11.94,13.19,13.22,13.41,13.31,13.0,12.41,12.31,11.44,10.16,10.25,9.25,9.78,8.59,10.91,10.5,11.34,13.34,13.56,14.56,15.19,15.62,15.94,16.25,16.19,17.28,16.38,16.38,16.16,15.34,14.41,13.47,12.91,12.44,13.62,14.38,14.94,16.88,16.91,16.31,16.0,15.31,13.25,12.44,11.84,11.75,11.78,13.22,13.06,14.19,14.25,13.72,13.44,12.28,12.5,14.19,15.28,17.69,19.19,20.19,19.81,19.72,18.69,18.09,17.41,16.28,16.28,15.41,14.41,15.62,16.53,17.09,16.62,17.41,16.5,16.22,15.72,16.19,15.31,14.59,13.72,12.44,12.0,10.56,9.16,9.34,9.16,8.31,9.69,10.59,10.66,11.81,13.56,14.06,15.44,15.69,16.59,16.47,16.94,17.44,17.69,19.06,18.81,20.31,21.22,20.5,21.44,20.72,20.88,20.75,20.09,20.12,19.75,19.31,17.69,17.19,16.03,15.28,14.06,14.19,13.16,12.56,11.09,9.97,8.91,7.12,7.81,7.44,7.56,8.91,9.56,10.06,11.28,11.91,12.5,13.16,13.69,14.22,13.59,13.56,13.19,12.75,12.47,12.44,12.44,11.66,11.16,9.38,7.56,7.44,6.53,7.16,7.62,8.5,8.25,6.81,5.19,2.06,-0.06,-2.56,-5.41,-6.19,-7.03,-6.59,-5.84,-4.28,-2.41,-0.94,0.84,3.69,6.56,11.03,14.66,16.5,17.25,16.5,13.94,11.66,9.69,7.22,7.38,7.5,8.38,10.59,12.56,14.16,14.69,13.72,14.94,14.19,13.53,13.28,11.41,9.31,8.25,6.16,5.62,4.62,6.91,7.31,8.88,11.19,11.94,11.69,13.81,12.5,12.31,12.78,12.59,12.78,13.38,12.66,11.56,11.69,10.75,9.91,9.5,9.03,9.69,9.59,11.56,12.12,13.41,14.5,14.09,13.5,15.78,15.09,16.59,17.19,17.47,16.72,15.25,14.88,13.06,13.41,13.31,13.06,14.66,15.31,16.25,16.31,16.12,16.34,15.28,15.16,14.06,12.25,11.28,11.12,10.56,11.12,11.56,12.44,11.88,12.97,14.06,15.41,16.66,17.06,17.03,15.75,14.03,12.81,11.0,10.75,10.06,9.22,9.56,8.69,8.09,8.94,9.69,10.78,11.41,13.62,15.47,17.25,20.19,21.06,22.69,21.53,20.69,18.16,15.97,13.66,12.19,11.41,11.41,10.25,10.22,10.0,10.12,9.06,9.16,10.09,9.91,10.78,10.88,10.84,10.75,11.41,9.78,10.0,10.06,9.06,9.28,9.75,9.84,11.25,10.81,13.12,12.88,13.94,14.81,14.66,14.41,14.28,13.16,11.06,10.28,9.0,7.78,6.47,4.69,3.25,1.03,-0.53,-1.19,-1.72,-1.62,-1.91,-2.59,-4.47,-7.22,-11.72,-14.47,-18.72,6.41,8.28,9.44,12.19,13.62,16.41:20.53,20.19,19.78,19.16,17.22,16.28,14.97,13.38,12.25,10.41,10.5,8.84,8.56,9.97,11.62,13.47,17.47,20.44,22.34,24.81,26.5,28.09,29.38,30.91,32.22,32.88,33.88,32.94,33.66,33.41,34.41,34.62,36.47,37.03,36.69,37.84,38.28,37.94,39.16,41.12,40.69,41.19,40.56,39.56,38.31,37.75,37.25,36.66,37.28,36.69,36.78,36.91,35.88,33.88,31.44,25.72,23.59,18.78,16.88,15.5,15.53,15.94,15.41,15.78,15.25,15.16,16.31,18.22,19.91,21.66,24.31,25.03,23.91,25.44,25.88,24.84,22.81,24.12,23.12,23.94,26.34,27.16,31.12,32.75,33.97,34.38,35.38,34.94,32.66,30.66,28.81,27.38,26.69,26.16,26.66,26.5,27.12,24.5,24.75,24.03,23.5,23.44,24.31,25.44,25.94,26.78,28.12,27.41,29.94,32.66,32.53,35.16,34.88,33.25,29.81,27.88,23.97,20.62,19.16,18.22,18.22,19.78,21.0,21.84,21.34,21.25,19.94,20.72,19.72,20.0,21.72,21.91,23.75,24.41,25.84,25.22,25.53,26.0,26.41,27.66,28.0,29.75,29.62,29.19,29.0,27.44,25.56,23.69,22.09,20.62,20.44,21.56,23.47,24.06,26.75,27.66,28.75,29.53,29.16,29.06,27.31,27.06,25.75,25.38,26.19,26.44,26.0,25.75,26.62,26.22,26.81,28.56,27.84,27.53,27.16,25.31,25.88,25.31,26.31,25.19,25.91,26.56,27.94,28.69,29.44,31.19,30.69,31.5,31.44,31.72,31.44,32.41,30.38,31.69,32.31,32.75,33.56,35.53,36.31,35.38,36.5,35.75,34.69,33.47,32.16,30.56,29.53,28.69,27.44,27.69,26.94,26.75,25.84,23.62,21.31,19.16,16.28,15.56,18.06,20.69,24.31,29.19,32.03,34.12,32.94,32.38,30.0,28.34,27.16,27.78,28.47,28.38,28.44,28.66,26.25,24.91,24.16,24.38,24.41,24.97,26.66,27.66,29.25,30.56,32.59,33.66,31.06,31.31,30.12,27.44,27.03,27.19,27.66,28.19,28.53,28.78,26.94,25.69,22.12,20.0,18.72,18.25,18.06,19.44,21.19,22.69,24.28,24.72,25.62,25.06,25.12,25.31,24.38,25.75,27.38,28.25,30.31,33.25,34.91,37.0,38.09,39.44,40.09,41.91,42.38,42.34,43.31,42.94,41.84,42.0,41.78,41.59,41.47,40.59,39.5,37.44,35.66,33.44,32.09,31.53,31.78,31.84,33.0,32.38,32.12,29.75,27.91,24.62,22.5,20.91,20.56,22.44,23.97,25.44,26.72,27.19,25.97,25.5,24.72,24.25,24.59,23.78,24.19,24.81,24.56,25.0,24.44,23.38,22.44,21.28,21.06,19.78,18.88,18.94,17.72,18.41,19.41,20.78,21.34,21.88,21.78,21.56,19.78,19.12,17.12,15.62,14.19,12.69,12.81,13.03,13.81,15.06,16.16,17.59,16.84,16.94,16.62,14.53,14.66,14.16,13.88,14.56,13.31,13.72,13.84,13.03,12.0,12.94,13.38,12.88,14.38,14.41,14.94,13.19,12.94,11.56,9.41,8.31,7.94,7.56,6.84,8.0,8.78,7.16,6.78,8.06,8.16,9.69,10.59,12.69,12.06,11.72,12.31,12.94,12.81,13.56,13.28,12.12,9.66,9.53,7.84,8.09,10.16,10.78,13.25,16.53,18.06,21.56,23.31,24.41,25.91,24.41,23.12,22.03,19.31,17.69,14.88,14.78,14.28,14.94,15.56,17.16,17.94,16.72,16.94,16.69,15.94,17.16,17.84,18.66,19.91,18.62,18.56,16.44,14.81,14.53,13.62,14.19,14.81,15.19,14.62,14.28,12.06,11.34,10.66,9.97,9.72,10.53,8.81,7.62,6.44,4.66,4.06,4.41,3.78,4.69,4.19,4.03,4.22,4.31,4.19,3.31,3.41,3.16,2.41,3.0,3.06,3.22,3.53,2.62,4.0,5.16,8.66,14.09,18.75,23.97,25.56,25.34,23.16,19.25,15.03,13.53,11.56,11.56,12.56,12.28,14.66,15.06,15.5,15.12,15.03,14.22,12.94,13.19,13.84,13.59,15.5,15.81,16.62,18.84,19.91,20.12,20.56,20.31,18.62,17.34,16.5,16.28,16.25,16.28,16.22,17.5,16.84,16.62,17.25,16.19,16.41,14.72,14.56,14.59,15.19,16.88,18.81,22.0,23.62,25.41,28.03,27.28,28.19,28.84,27.91,27.44,25.69,23.44,21.97,20.56,18.56,17.66,17.5,15.06,13.75,13.16,11.56,11.06,10.91,11.5,11.94,13.19,13.22,13.41,13.31,13.0,12.41,12.31,11.44,10.16,10.25,9.25,9.78,8.59,10.91,10.5,11.34,13.34,13.56,14.56,15.19,15.62,15.94,16.25,16.19,17.28,16.38,16.38,16.16,15.34,14.41,13.47,12.91,12.44,13.62,14.38,14.94,16.88,16.91,16.31,16.0,15.31,13.25,12.44,11.84,11.75,11.78,13.22,13.06,14.19,14.25,13.72,13.44,12.28,12.5,14.19,15.28,17.69,19.19,20.19,19.81,19.72,18.69,18.09,17.41,16.28,16.28,15.41,14.41,15.62,16.53,17.09,16.62,17.41,16.5,16.22,15.72,16.19,15.31,14.59,13.72,12.44,12.0,10.56,9.16,9.34,9.16,8.31,9.69,10.59,10.66,11.81,13.56,14.06,15.44,15.69,16.59,16.47,16.94,17.44,17.69,19.06,18.81,20.31,21.22,20.5,21.44,20.72,20.88,20.75,20.09,20.12,19.75,19.31,17.69,17.19,16.03,15.28,14.06,14.19,13.16,12.56,11.09,9.97,8.91,7.12,7.81,7.44,7.56,8.91,9.56,10.06,11.28,11.91,12.5,13.16,13.69,14.22,13.59,13.56,13.19,12.75,12.47,12.44,12.44,11.66,11.16,9.38,7.56,7.44,6.53,7.16,7.62,8.5,8.25,6.81,5.19,2.06,-0.06,-2.56,-5.41,-6.19,-7.03,-6.59,-5.84,-4.28,-2.41,-0.94,0.84,3.69,6.56,11.03,14.66,16.5,17.25,16.5,13.94,11.66,9.69,7.22,7.38,7.5,8.38,10.59,12.56,14.16,14.69,13.72,14.94,14.19,13.53,13.28,11.41,9.31,8.25,6.16,5.62,4.62,6.91,7.31,8.88,11.19,11.94,11.69,13.81,12.5,12.31,12.78,12.59,12.78,13.38,12.66,11.56,11.69,10.75,9.91,9.5,9.03,9.69,9.59,11.56,12.12,13.41,14.5,14.09,13.5,15.78,15.09,16.59,17.19,17.47,16.72,15.25,14.88,13.06,13.41,13.31,13.06,14.66,15.31,16.25,16.31,16.12,16.34,15.28,15.16,14.06,12.25,11.28,11.12,10.56,11.12,11.56,12.44,11.88,12.97,14.06,15.41,16.66,17.06,17.03,15.75,14.03,12.81,11.0,10.75,10.06,9.22,9.56,8.69,8.09,8.94,9.69,10.78,11.41,13.62,15.47,17.25,20.19,21.06,22.69,21.53,20.69,18.16,15.97,13.66,12.19,11.41,11.41,10.25,10.22,10.0,10.12,9.06,9.16,10.09,9.91,10.78,10.88,10.84,10.75,11.41,9.78,10.0,10.06,9.06,9.28,9.75,9.84,11.25,10.81,13.12,12.88,13.94,14.81,14.66,14.41,14.28,13.16,11.06,10.28,9.0,7.78,6.47,4.69,3.25,1.03,-0.53,-1.19,-1.72,-1.62,-1.91,-2.59,-4.47,-7.22,-11.72,-14.47,-18.72,6.41,8.28,9.44,12.19,13.62,16.41,16.91,17.19,16.03,14.66,12.91,12.22:14.97,13.38,12.25,10.41,10.5,8.84,8.56,9.97,11.62,13.47,17.47,20.44,22.34,24.81,26.5,28.09,29.38,30.91,32.22,32.88,33.88,32.94,33.66,33.41,34.41,34.62,36.47,37.03,36.69,37.84,38.28,37.94,39.16,41.12,40.69,41.19,40.56,39.56,38.31,37.75,37.25,36.66,37.28,36.69,36.78,36.91,35.88,33.88,31.44,25.72,23.59,18.78,16.88,15.5,15.53,15.94,15.41,15.78,15.25,15.16,16.31,18.22,19.91,21.66,24.31,25.03,23.91,25.44,25.88,24.84,22.81,24.12,23.12,23.94,26.34,27.16,31.12,32.75,33.97,34.38,35.38,34.94,32.66,30.66,28.81,27.38,26.69,26.16,26.66,26.5,27.12,24.5,24.75,24.03,23.5,23.44,24.31,25.44,25.94,26.78,28.12,27.41,29.94,32.66,32.53,35.16,34.88,33.25,29.81,27.88,23.97,20.62,19.16,18.22,18.22,19.78,21.0,21.84,21.34,21.25,19.94,20.72,19.72,20.0,21.72,21.91,23.75,24.41,25.84,25.22,25.53,26.0,26.41,27.66,28.0,29.75,29.62,29.19,29.0,27.44,25.56,23.69,22.09,20.62,20.44,21.56,23.47,24.06,26.75,27.66,28.75,29.53,29.16,29.06,27.31,27.06,25.75,25.38,26.19,26.44,26.0,25.75,26.62,26.22,26.81,28.56,27.84,27.53,27.16,25.31,25.88,25.31,26.31,25.19,25.91,26.56,27.94,28.69,29.44,31.19,30.69,31.5,31.44,31.72,31.44,32.41,30.38,31.69,32.31,32.75,33.56,35.53,36.31,35.38,36.5,35.75,34.69,33.47,32.16,30.56,29.53,28.69,27.44,27.69,26.94,26.75,25.84,23.62,21.31,19.16,16.28,15.56,18.06,20.69,24.31,29.19,32.03,34.12,32.94,32.38,30.0,28.34,27.16,27.78,28.47,28.38,28.44,28.66,26.25,24.91,24.16,24.38,24.41,24.97,26.66,27.66,29.25,30.56,32.59,33.66,31.06,31.31,30.12,27.44,27.03,27.19,27.66,28.19,28.53,28.78,26.94,25.69,22.12,20.0,18.72,18.25,18.06,19.44,21.19,22.69,24.28,24.72,25.62,25.06,25.12,25.31,24.38,25.75,27.38,28.25,30.31,33.25,34.91,37.0,38.09,39.44,40.09,41.91,42.38,42.34,43.31,42.94,41.84,42.0,41.78,41.59,41.47,40.59,39.5,37.44,35.66,33.44,32.09,31.53,31.78,31.84,33.0,32.38,32.12,29.75,27.91,24.62,22.5,20.91,20.56,22.44,23.97,25.44,26.72,27.19,25.97,25.5,24.72,24.25,24.59,23.78,24.19,24.81,24.56,25.0,24.44,23.38,22.44,21.28,21.06,19.78,18.88,18.94,17.72,18.41,19.41,20.78,21.34,21.88,21.78,21.56,19.78,19.12,17.12,15.62,14.19,12.69,12.81,13.03,13.81,15.06,16.16,17.59,16.84,16.94,16.62,14.53,14.66,14.16,13.88,14.56,13.31,13.72,13.84,13.03,12.0,12.94,13.38,12.88,14.38,14.41,14.94,13.19,12.94,11.56,9.41,8.31,7.94,7.56,6.84,8.0,8.78,7.16,6.78,8.06,8.16,9.69,10.59,12.69,12.06,11.72,12.31,12.94,12.81,13.56,13.28,12.12,9.66,9.53,7.84,8.09,10.16,10.78,13.25,16.53,18.06,21.56,23.31,24.41,25.91,24.41,23.12,22.03,19.31,17.69,14.88,14.78,14.28,14.94,15.56,17.16,17.94,16.72,16.94,16.69,15.94,17.16,17.84,18.66,19.91,18.62,18.56,16.44,14.81,14.53,13.62,14.19,14.81,15.19,14.62,14.28,12.06,11.34,10.66,9.97,9.72,10.53,8.81,7.62,6.44,4.66,4.06,4.41,3.78,4.69,4.19,4.03,4.22,4.31,4.19,3.31,3.41,3.16,2.41,3.0,3.06,3.22,3.53,2.62,4.0,5.16,8.66,14.09,18.75,23.97,25.56,25.34,23.16,19.25,15.03,13.53,11.56,11.56,12.56,12.28,14.66,15.06,15.5,15.12,15.03,14.22,12.94,13.19,13.84,13.59,15.5,15.81,16.62,18.84,19.91,20.12,20.56,20.31,18.62,17.34,16.5,16.28,16.25,16.28,16.22,17.5,16.84,16.62,17.25,16.19,16.41,14.72,14.56,14.59,15.19,16.88,18.81,22.0,23.62,25.41,28.03,27.28,28.19,28.84,27.91,27.44,25.69,23.44,21.97,20.56,18.56,17.66,17.5,15.06,13.75,13.16,11.56,11.06,10.91,11.5,11.94,13.19,13.22,13.41,13.31,13.0,12.41,12.31,11.44,10.16,10.25,9.25,9.78,8.59,10.91,10.5,11.34,13.34,13.56,14.56,15.19,15.62,15.94,16.25,16.19,17.28,16.38,16.38,16.16,15.34,14.41,13.47,12.91,12.44,13.62,14.38,14.94,16.88,16.91,16.31,16.0,15.31,13.25,12.44,11.84,11.75,11.78,13.22,13.06,14.19,14.25,13.72,13.44,12.28,12.5,14.19,15.28,17.69,19.19,20.19,19.81,19.72,18.69,18.09,17.41,16.28,16.28,15.41,14.41,15.62,16.53,17.09,16.62,17.41,16.5,16.22,15.72,16.19,15.31,14.59,13.72,12.44,12.0,10.56,9.16,9.34,9.16,8.31,9.69,10.59,10.66,11.81,13.56,14.06,15.44,15.69,16.59,16.47,16.94,17.44,17.69,19.06,18.81,20.31,21.22,20.5,21.44,20.72,20.88,20.75,20.09,20.12,19.75,19.31,17.69,17.19,16.03,15.28,14.06,14.19,13.16,12.56,11.09,9.97,8.91,7.12,7.81,7.44,7.56,8.91,9.56,10.06,11.28,11.91,12.5,13.16,13.69,14.22,13.59,13.56,13.19,12.75,12.47,12.44,12.44,11.66,11.16,9.38,7.56,7.44,6.53,7.16,7.62,8.5,8.25,6.81,5.19,2.06,-0.06,-2.56,-5.41,-6.19,-7.03,-6.59,-5.84,-4.28,-2.41,-0.94,0.84,3.69,6.56,11.03,14.66,16.5,17.25,16.5,13.94,11.66,9.69,7.22,7.38,7.5,8.38,10.59,12.56,14.16,14.69,13.72,14.94,14.19,13.53,13.28,11.41,9.31,8.25,6.16,5.62,4.62,6.91,7.31,8.88,11.19,11.94,11.69,13.81,12.5,12.31,12.78,12.59,12.78,13.38,12.66,11.56,11.69,10.75,9.91,9.5,9.03,9.69,9.59,11.56,12.12,13.41,14.5,14.09,13.5,15.78,15.09,16.59,17.19,17.47,16.72,15.25,14.88,13.06,13.41,13.31,13.06,14.66,15.31,16.25,16.31,16.12,16.34,15.28,15.16,14.06,12.25,11.28,11.12,10.56,11.12,11.56,12.44,11.88,12.97,14.06,15.41,16.66,17.06,17.03,15.75,14.03,12.81,11.0,10.75,10.06,9.22,9.56,8.69,8.09,8.94,9.69,10.78,11.41,13.62,15.47,17.25,20.19,21.06,22.69,21.53,20.69,18.16,15.97,13.66,12.19,11.41,11.41,10.25,10.22,10.0,10.12,9.06,9.16,10.09,9.91,10.78,10.88,10.84,10.75,11.41,9.78,10.0,10.06,9.06,9.28,9.75,9.84,11.25,10.81,13.12,12.88,13.94,14.81,14.66,14.41,14.28,13.16,11.06,10.28,9.0,7.78,6.47,4.69,3.25,1.03,-0.53,-1.19,-1.72,-1.62,-1.91,-2.59,-4.47,-7.22,-11.72,-14.47,-18.72,6.41,8.28,9.44,12.19,13.62,16.41,16.91,17.19,16.03,14.66,12.91,12.22,10.81,11.41,10.88,10.41,8.59,6.88:8.56,9.97,11.62,13.47,17.47,20.44,22.34,24.81,26.5,28.09,29.38,30.91,32.22,32.88,33.88,32.94,33.66,33.41,34.41,34.62,36.47,37.03,36.69,37.84,38.28,37.94,39.16,41.12,40.69,41.19,40.56,39.56,38.31,37.75,37.25,36.66,37.28,36.69,36.78,36.91,35.88,33.88,31.44,25.72,23.59,18.78,16.88,15.5,15.53,15.94,15.41,15.78,15.25,15.16,16.31,18.22,19.91,21.66,24.31,25.03,23.91,25.44,25.88,24.84,22.81,24.12,23.12,23.94,26.34,27.16,31.12,32.75,33.97,34.38,35.38,34.94,32.66,30.66,28.81,27.38,26.69,26.16,26.66,26.5,27.12,24.5,24.75,24.03,23.5,23.44,24.31,25.44,25.94,26.78,28.12,27.41,29.94,32.66,32.53,35.16,34.88,33.25,29.81,27.88,23.97,20.62,19.16,18.22,18.22,19.78,21.0,21.84,21.34,21.25,19.94,20.72,19.72,20.0,21.72,21.91,23.75,24.41,25.84,25.22,25.53,26.0,26.41,27.66,28.0,29.75,29.62,29.19,29.0,27.44,25.56,23.69,22.09,20.62,20.44,21.56,23.47,24.06,26.75,27.66,28.75,29.53,29.16,29.06,27.31,27.06,25.75,25.38,26.19,26.44,26.0,25.75,26.62,26.22,26.81,28.56,27.84,27.53,27.16,25.31,25.88,25.31,26.31,25.19,25.91,26.56,27.94,28.69,29.44,31.19,30.69,31.5,31.44,31.72,31.44,32.41,30.38,31.69,32.31,32.75,33.56,35.53,36.31,35.38,36.5,35.75,34.69,33.47,32.16,30.56,29.53,28.69,27.44,27.69,26.94,26.75,25.84,23.62,21.31,19.16,16.28,15.56,18.06,20.69,24.31,29.19,32.03,34.12,32.94,32.38,30.0,28.34,27.16,27.78,28.47,28.38,28.44,28.66,26.25,24.91,24.16,24.38,24.41,24.97,26.66,27.66,29.25,30.56,32.59,33.66,31.06,31.31,30.12,27.44,27.03,27.19,27.66,28.19,28.53,28.78,26.94,25.69,22.12,20.0,18.72,18.25,18.06,19.44,21.19,22.69,24.28,24.72,25.62,25.06,25.12,25.31,24.38,25.75,27.38,28.25,30.31,33.25,34.91,37.0,38.09,39.44,40.09,41.91,42.38,42.34,43.31,42.94,41.84,42.0,41.78,41.59,41.47,40.59,39.5,37.44,35.66,33.44,32.09,31.53,31.78,31.84,33.0,32.38,32.12,29.75,27.91,24.62,22.5,20.91,20.56,22.44,23.97,25.44,26.72,27.19,25.97,25.5,24.72,24.25,24.59,23.78,24.19,24.81,24.56,25.0,24.44,23.38,22.44,21.28,21.06,19.78,18.88,18.94,17.72,18.41,19.41,20.78,21.34,21.88,21.78,21.56,19.78,19.12,17.12,15.62,14.19,12.69,12.81,13.03,13.81,15.06,16.16,17.59,16.84,16.94,16.62,14.53,14.66,14.16,13.88,14.56,13.31,13.72,13.84,13.03,12.0,12.94,13.38,12.88,14.38,14.41,14.94,13.19,12.94,11.56,9.41,8.31,7.94,7.56,6.84,8.0,8.78,7.16,6.78,8.06,8.16,9.69,10.59,12.69,12.06,11.72,12.31,12.94,12.81,13.56,13.28,12.12,9.66,9.53,7.84,8.09,10.16,10.78,13.25,16.53,18.06,21.56,23.31,24.41,25.91,24.41,23.12,22.03,19.31,17.69,14.88,14.78,14.28,14.94,15.56,17.16,17.94,16.72,16.94,16.69,15.94,17.16,17.84,18.66,19.91,18.62,18.56,16.44,14.81,14.53,13.62,14.19,14.81,15.19,14.62,14.28,12.06,11.34,10.66,9.97,9.72,10.53,8.81,7.62,6.44,4.66,4.06,4.41,3.78,4.69,4.19,4.03,4.22,4.31,4.19,3.31,3.41,3.16,2.41,3.0,3.06,3.22,3.53,2.62,4.0,5.16,8.66,14.09,18.75,23.97,25.56,25.34,23.16,19.25,15.03,13.53,11.56,11.56,12.56,12.28,14.66,15.06,15.5,15.12,15.03,14.22,12.94,13.19,13.84,13.59,15.5,15.81,16.62,18.84,19.91,20.12,20.56,20.31,18.62,17.34,16.5,16.28,16.25,16.28,16.22,17.5,16.84,16.62,17.25,16.19,16.41,14.72,14.56,14.59,15.19,16.88,18.81,22.0,23.62,25.41,28.03,27.28,28.19,28.84,27.91,27.44,25.69,23.44,21.97,20.56,18.56,17.66,17.5,15.06,13.75,13.16,11.56,11.06,10.91,11.5,11.94,13.19,13.22,13.41,13.31,13.0,12.41,12.31,11.44,10.16,10.25,9.25,9.78,8.59,10.91,10.5,11.34,13.34,13.56,14.56,15.19,15.62,15.94,16.25,16.19,17.28,16.38,16.38,16.16,15.34,14.41,13.47,12.91,12.44,13.62,14.38,14.94,16.88,16.91,16.31,16.0,15.31,13.25,12.44,11.84,11.75,11.78,13.22,13.06,14.19,14.25,13.72,13.44,12.28,12.5,14.19,15.28,17.69,19.19,20.19,19.81,19.72,18.69,18.09,17.41,16.28,16.28,15.41,14.41,15.62,16.53,17.09,16.62,17.41,16.5,16.22,15.72,16.19,15.31,14.59,13.72,12.44,12.0,10.56,9.16,9.34,9.16,8.31,9.69,10.59,10.66,11.81,13.56,14.06,15.44,15.69,16.59,16.47,16.94,17.44,17.69,19.06,18.81,20.31,21.22,20.5,21.44,20.72,20.88,20.75,20.09,20.12,19.75,19.31,17.69,17.19,16.03,15.28,14.06,14.19,13.16,12.56,11.09,9.97,8.91,7.12,7.81,7.44,7.56,8.91,9.56,10.06,11.28,11.91,12.5,13.16,13.69,14.22,13.59,13.56,13.19,12.75,12.47,12.44,12.44,11.66,11.16,9.38,7.56,7.44,6.53,7.16,7.62,8.5,8.25,6.81,5.19,2.06,-0.06,-2.56,-5.41,-6.19,-7.03,-6.59,-5.84,-4.28,-2.41,-0.94,0.84,3.69,6.56,11.03,14.66,16.5,17.25,16.5,13.94,11.66,9.69,7.22,7.38,7.5,8.38,10.59,12.56,14.16,14.69,13.72,14.94,14.19,13.53,13.28,11.41,9.31,8.25,6.16,5.62,4.62,6.91,7.31,8.88,11.19,11.94,11.69,13.81,12.5,12.31,12.78,12.59,12.78,13.38,12.66,11.56,11.69,10.75,9.91,9.5,9.03,9.69,9.59,11.56,12.12,13.41,14.5,14.09,13.5,15.78,15.09,16.59,17.19,17.47,16.72,15.25,14.88,13.06,13.41,13.31,13.06,14.66,15.31,16.25,16.31,16.12,16.34,15.28,15.16,14.06,12.25,11.28,11.12,10.56,11.12,11.56,12.44,11.88,12.97,14.06,15.41,16.66,17.06,17.03,15.75,14.03,12.81,11.0,10.75,10.06,9.22,9.56,8.69,8.09,8.94,9.69,10.78,11.41,13.62,15.47,17.25,20.19,21.06,22.69,21.53,20.69,18.16,15.97,13.66,12.19,11.41,11.41,10.25,10.22,10.0,10.12,9.06,9.16,10.09,9.91,10.78,10.88,10.84,10.75,11.41,9.78,10.0,10.06,9.06,9.28,9.75,9.84,11.25,10.81,13.12,12.88,13.94,14.81,14.66,14.41,14.28,13.16,11.06,10.28,9.0,7.78,6.47,4.69,3.25,1.03,-0.53,-1.19,-1.72,-1.62,-1.91,-2.59,-4.47,-7.22,-11.72,-14.47,-18.72,6.41,8.28,9.44,12.19,13.62,16.41,16.91,17.19,16.03,14.66,12.91,12.22,10.81,11.41,10.88,10.41,8.59,6.88,6.34,3.81,2.03,0.94,-0.25,-1.28:22.34,24.81,26.5,28.09,29.38,30.91,32.22,32.88,33.88,32.94,33.66,33.41,34.41,34.62,36.47,37.03,36.69,37.84,38.28,37.94,39.16,41.12,40.69,41.19,40.56,39.56,38.31,37.75,37.25,36.66,37.28,36.69,36.78,36.91,35.88,33.88,31.44,25.72,23.59,18.78,16.88,15.5,15.53,15.94,15.41,15.78,15.25,15.16,16.31,18.22,19.91,21.66,24.31,25.03,23.91,25.44,25.88,24.84,22.81,24.12,23.12,23.94,26.34,27.16,31.12,32.75,33.97,34.38,35.38,34.94,32.66,30.66,28.81,27.38,26.69,26.16,26.66,26.5,27.12,24.5,24.75,24.03,23.5,23.44,24.31,25.44,25.94,26.78,28.12,27.41,29.94,32.66,32.53,35.16,34.88,33.25,29.81,27.88,23.97,20.62,19.16,18.22,18.22,19.78,21.0,21.84,21.34,21.25,19.94,20.72,19.72,20.0,21.72,21.91,23.75,24.41,25.84,25.22,25.53,26.0,26.41,27.66,28.0,29.75,29.62,29.19,29.0,27.44,25.56,23.69,22.09,20.62,20.44,21.56,23.47,24.06,26.75,27.66,28.75,29.53,29.16,29.06,27.31,27.06,25.75,25.38,26.19,26.44,26.0,25.75,26.62,26.22,26.81,28.56,27.84,27.53,27.16,25.31,25.88,25.31,26.31,25.19,25.91,26.56,27.94,28.69,29.44,31.19,30.69,31.5,31.44,31.72,31.44,32.41,30.38,31.69,32.31,32.75,33.56,35.53,36.31,35.38,36.5,35.75,34.69,33.47,32.16,30.56,29.53,28.69,27.44,27.69,26.94,26.75,25.84,23.62,21.31,19.16,16.28,15.56,18.06,20.69,24.31,29.19,32.03,34.12,32.94,32.38,30.0,28.34,27.16,27.78,28.47,28.38,28.44,28.66,26.25,24.91,24.16,24.38,24.41,24.97,26.66,27.66,29.25,30.56,32.59,33.66,31.06,31.31,30.12,27.44,27.03,27.19,27.66,28.19,28.53,28.78,26.94,25.69,22.12,20.0,18.72,18.25,18.06,19.44,21.19,22.69,24.28,24.72,25.62,25.06,25.12,25.31,24.38,25.75,27.38,28.25,30.31,33.25,34.91,37.0,38.09,39.44,40.09,41.91,42.38,42.34,43.31,42.94,41.84,42.0,41.78,41.59,41.47,40.59,39.5,37.44,35.66,33.44,32.09,31.53,31.78,31.84,33.0,32.38,32.12,29.75,27.91,24.62,22.5,20.91,20.56,22.44,23.97,25.44,26.72,27.19,25.97,25.5,24.72,24.25,24.59,23.78,24.19,24.81,24.56,25.0,24.44,23.38,22.44,21.28,21.06,19.78,18.88,18.94,17.72,18.41,19.41,20.78,21.34,21.88,21.78,21.56,19.78,19.12,17.12,15.62,14.19,12.69,12.81,13.03,13.81,15.06,16.16,17.59,16.84,16.94,16.62,14.53,14.66,14.16,13.88,14.56,13.31,13.72,13.84,13.03,12.0,12.94,13.38,12.88,14.38,14.41,14.94,13.19,12.94,11.56,9.41,8.31,7.94,7.56,6.84,8.0,8.78,7.16,6.78,8.06,8.16,9.69,10.59,12.69,12.06,11.72,12.31,12.94,12.81,13.56,13.28,12.12,9.66,9.53,7.84,8.09,10.16,10.78,13.25,16.53,18.06,21.56,23.31,24.41,25.91,24.41,23.12,22.03,19.31,17.69,14.88,14.78,14.28,14.94,15.56,17.16,17.94,16.72,16.94,16.69,15.94,17.16,17.84,18.66,19.91,18.62,18.56,16.44,14.81,14.53,13.62,14.19,14.81,15.19,14.62,14.28,12.06,11.34,10.66,9.97,9.72,10.53,8.81,7.62,6.44,4.66,4.06,4.41,3.78,4.69,4.19,4.03,4.22,4.31,4.19,3.31,3.41,3.16,2.41,3.0,3.06,3.22,3.53,2.62,4.0,5.16,8.66,14.09,18.75,23.97,25.56,25.34,23.16,19.25,15.03,13.53,11.56,11.56,12.56,12.28,14.66,15.06,15.5,15.12,15.03,14.22,12.94,13.19,13.84,13.59,15.5,15.81,16.62,18.84,19.91,20.12,20.56,20.31,18.62,17.34,16.5,16.28,16.25,16.28,16.22,17.5,16.84,16.62,17.25,16.19,16.41,14.72,14.56,14.59,15.19,16.88,18.81,22.0,23.62,25.41,28.03,27.28,28.19,28.84,27.91,27.44,25.69,23.44,21.97,20.56,18.56,17.66,17.5,15.06,13.75,13.16,11.56,11.06,10.91,11.5,11.94,13.19,13.22,13.41,13.31,13.0,12.41,12.31,11.44,10.16,10.25,9.25,9.78,8.59,10.91,10.5,11.34,13.34,13.56,14.56,15.19,15.62,15.94,16.25,16.19,17.28,16.38,16.38,16.16,15.34,14.41,13.47,12.91,12.44,13.62,14.38,14.94,16.88,16.91,16.31,16.0,15.31,13.25,12.44,11.84,11.75,11.78,13.22,13.06,14.19,14.25,13.72,13.44,12.28,12.5,14.19,15.28,17.69,19.19,20.19,19.81,19.72,18.69,18.09,17.41,16.28,16.28,15.41,14.41,15.62,16.53,17.09,16.62,17.41,16.5,16.22,15.72,16.19,15.31,14.59,13.72,12.44,12.0,10.56,9.16,9.34,9.16,8.31,9.69,10.59,10.66,11.81,13.56,14.06,15.44,15.69,16.59,16.47,16.94,17.44,17.69,19.06,18.81,20.31,21.22,20.5,21.44,20.72,20.88,20.75,20.09,20.12,19.75,19.31,17.69,17.19,16.03,15.28,14.06,14.19,13.16,12.56,11.09,9.97,8.91,7.12,7.81,7.44,7.56,8.91,9.56,10.06,11.28,11.91,12.5,13.16,13.69,14.22,13.59,13.56,13.19,12.75,12.47,12.44,12.44,11.66,11.16,9.38,7.56,7.44,6.53,7.16,7.62,8.5,8.25,6.81,5.19,2.06,-0.06,-2.56,-5.41,-6.19,-7.03,-6.59,-5.84,-4.28,-2.41,-0.94,0.84,3.69,6.56,11.03,14.66,16.5,17.25,16.5,13.94,11.66,9.69,7.22,7.38,7.5,8.38,10.59,12.56,14.16,14.69,13.72,14.94,14.19,13.53,13.28,11.41,9.31,8.25,6.16,5.62,4.62,6.91,7.31,8.88,11.19,11.94,11.69,13.81,12.5,12.31,12.78,12.59,12.78,13.38,12.66,11.56,11.69,10.75,9.91,9.5,9.03,9.69,9.59,11.56,12.12,13.41,14.5,14.09,13.5,15.78,15.09,16.59,17.19,17.47,16.72,15.25,14.88,13.06,13.41,13.31,13.06,14.66,15.31,16.25,16.31,16.12,16.34,15.28,15.16,14.06,12.25,11.28,11.12,10.56,11.12,11.56,12.44,11.88,12.97,14.06,15.41,16.66,17.06,17.03,15.75,14.03,12.81,11.0,10.75,10.06,9.22,9.56,8.69,8.09,8.94,9.69,10.78,11.41,13.62,15.47,17.25,20.19,21.06,22.69,21.53,20.69,18.16,15.97,13.66,12.19,11.41,11.41,10.25,10.22,10.0,10.12,9.06,9.16,10.09,9.91,10.78,10.88,10.84,10.75,11.41,9.78,10.0,10.06,9.06,9.28,9.75,9.84,11.25,10.81,13.12,12.88,13.94,14.81,14.66,14.41,14.28,13.16,11.06,10.28,9.0,7.78,6.47,4.69,3.25,1.03,-0.53,-1.19,-1.72,-1.62,-1.91,-2.59,-4.47,-7.22,-11.72,-14.47,-18.72,6.41,8.28,9.44,12.19,13.62,16.41,16.91,17.19,16.03,14.66,12.91,12.22,10.81,11.41,10.88,10.41,8.59,6.88,6.34,3.81,2.03,0.94,-0.25,-1.28,-0.94,-0.53,0.88,3.28,5.66,8.0:negativity
70.47,72.56,73.84,74.59,76.84,78.25,79.62,81.38,81.22,82.22,80.53,78.53,76.19,74.69,72.94,70.41,69.25,68.56,70.44,71.47,74.75,75.62,78.41,79.22,79.16,80.56,82.38,83.28,83.28,83.91,83.0,80.91,78.12,75.06,72.06,70.56,68.5,68.5,68.69,71.0,74.28,77.88,83.69,88.44,90.62,93.09,91.81,90.28,89.84,87.94,87.12,86.44,87.16,84.94,84.28,83.28,84.19,84.56,85.94,87.31,86.94,86.06,82.94,79.28,75.72,72.66,68.59,66.28,64.28,62.12,60.62,61.03,62.91,65.19,64.88,68.5,69.34,69.38,70.53,70.78,71.31,70.75,69.44,68.56,67.94,67.62,66.88,67.31,67.31,67.25,67.97,68.03,68.31,70.5,72.06,74.41,78.69,82.12,84.97,86.97,89.91,90.31,90.0,89.72,88.28,86.0,83.44,81.44,80.44,79.97,80.62,80.53,80.16,80.22,76.44,76.62,75.84,75.44,76.56,79.09,81.09,82.88,86.38,89.06,90.41,91.75,91.41,89.94,86.91,84.53,81.41,77.66,75.66,75.06,74.0,75.88,77.62,79.03,79.44,77.81,76.31,75.06,73.91,72.72,72.31,72.22,71.25,70.19,69.56,68.16,68.19,66.41,68.09,66.59,68.53,70.34,71.5,71.31,71.69,73.91,73.0,72.44,75.53,76.16,77.41,77.81,77.5,75.03,74.81,73.94,73.78,75.31,75.5,76.31,76.31,77.16,78.12,78.94,80.03,78.44,81.41,80.47,82.03,84.12,85.84,88.03,88.78,88.44,88.16,86.94,85.53,83.94,84.12,82.75,83.94,83.41,83.69,83.56,83.66,83.16,82.12,82.09,80.28,79.81,79.88,78.72,79.0,77.97,78.62,77.88,79.53,80.06,80.91,81.62,81.72,81.81,82.09,82.38,83.53,83.25,83.78,84.44,84.94,85.56,87.19,86.19,86.12,86.84,87.16,87.0,86.88,87.12,85.09,82.56,80.78,78.22,75.94,74.88,73.53,72.84,72.97,73.66,73.88,73.31,73.38,73.56,70.66,72.47,72.44,72.03,73.88,73.34,72.66,73.09,73.16,72.06,73.12,73.56,72.84,75.09,76.56,78.25,79.47,79.38,78.84,76.56,75.59,75.09,74.56,74.0,74.31,72.12,71.12,71.56,70.78,69.19,69.75,68.06,67.22,66.06,65.06,64.78,62.81,60.56,58.28,57.34,57.72,58.91,61.41,63.75,67.19,69.12,71.25,72.19,74.22,74.62,75.38,76.09,76.06,74.81,73.62,74.28,75.06,76.66,78.88,80.97,81.28,81.47,80.19,80.75,81.22,80.0,81.88,80.28,79.94,80.5,79.09,78.69,79.28,76.47,75.16,75.38,72.31,72.56,74.19,73.12,72.44,70.62,70.22,70.62,69.62,70.75,73.41,74.31,74.78,78.19,81.75,84.53,87.62,90.16,90.62,89.53,88.06,85.28,81.34,81.0,79.34,77.06,77.28,76.66,75.59,74.44,73.97,74.75,75.25,76.31,76.09,77.62,77.72,76.41,77.56,76.31,75.47,71.75,72.12,70.72,70.44,70.12,71.31,71.56,71.91,71.75,74.0,74.69,75.91,78.66,79.19,80.16,79.84,78.62,77.22,76.38,74.88,75.12,73.31,72.31,72.5,70.16,68.91,68.81,65.62,65.41,64.0,63.06,60.66,61.69,60.09,58.94,60.0,61.94,63.5,66.12,66.53,68.16,69.28,69.41,69.75,70.69,71.56,71.94,74.06,77.62,79.09,81.19,80.91,81.0,79.78,78.62,79.56,78.66,79.53,79.38,78.19,74.16,73.16,70.69,67.66,66.22,65.94,64.47,64.75,64.69,65.53,67.03,69.78,71.81,72.97,75.94,76.81,78.28,78.56,79.0,77.84,77.66,76.81,77.16,78.69,78.94,79.25,79.56,80.53,80.25,81.78,82.41,83.91,83.72,83.12,84.56,84.66,83.75,84.44,83.44,80.78,80.28,80.41,78.78,79.12,79.31,78.06,77.34,74.66,73.16,71.19,71.56,70.94,70.62,71.34,70.44,70.66,70.0,70.75,70.81,71.62,69.94,69.28,68.84,66.75,65.03,64.91,64.22,64.28,66.06,64.62,65.56,65.31,64.69,62.16,63.28,61.94,60.69,60.78,60.0,60.88,62.28,63.09,64.31,64.09,64.94,65.72,64.09,64.16,64.0,61.56,61.19,60.19,59.0,58.91,59.38,61.53,61.84,65.03,66.62,67.16,67.47,68.44,69.0,67.81,67.72,66.34,67.31,66.44,66.78,66.53,65.5,63.12,62.25,63.69,65.25,67.03,69.5,71.5,71.66,70.75,69.12,70.06,66.69,69.0,71.03,72.78,76.44,76.78,77.81,75.41,74.03,70.34,68.16,66.66,63.81,63.88,62.03,63.09,64.91,65.91,69.53,71.69,75.25,76.16,77.44,78.59,76.81,76.66,75.94,74.12,73.84,70.59,69.25,66.41,63.16,62.5,62.72,63.16,63.62,64.75,65.53,66.22,68.62,68.78,72.31,73.72,74.91,75.88,76.0,77.06,77.0,77.28,77.88,77.0,77.25,74.31,74.53,74.84,74.59,75.5,76.44,76.59,75.09,75.44,75.38,74.34,75.0,75.19,74.5,75.78,76.75,76.53,77.0,77.81,78.41,79.94,80.94,81.94,82.88,81.44,80.62,78.28,76.94,74.66,74.81,73.62,73.62,74.88,74.5,75.94,75.78,75.44,76.06,74.91,75.66,75.94,75.78,74.19,72.81,70.88,67.16,64.69,63.12,60.31,58.72,57.62,57.97,57.97,59.28,62.38,63.41,65.59,67.25,68.38,70.06,68.88,68.88,67.69,66.31,64.12,62.56,61.28,58.91,58.88,57.56,54.19,56.25,55.06,53.53,55.72,55.34,55.78,58.12,59.03,59.75,61.25,61.41,60.38,58.09,56.94,56.66,56.28,57.84,58.06,59.59,60.31,59.91,61.88,61.28,61.78,62.0,63.53,63.41,64.22,66.31,68.0,67.53,69.91,70.47,70.78,70.34,69.38,66.69,66.19,63.94,63.0,61.44,61.41,61.44,60.56,62.69,63.25,62.88,62.91,61.94,62.0,56.84,57.31,57.12,57.56,59.44,63.78,66.28,68.06,69.84,69.19,69.47,68.38,69.44,69.38,69.12,68.81,67.34,65.53,62.84,62.5,60.34,61.81,62.22,64.53,65.72,67.97,69.19,69.53,69.47,68.91,66.88,64.78,63.69,61.78,60.47,62.16,61.09,61.88,63.06,62.84,62.91,63.0,60.72,60.59,60.22,60.59,61.53,64.06,67.84,70.0,74.16,77.91,80.44,81.59,81.62,79.31,77.0,73.56,72.16,70.38,68.81,67.81,66.19,64.91,63.94,63.94,64.94,65.66,66.69,67.62,67.28,68.44,68.22,67.91,66.88,64.88,63.81,60.56,58.66,56.34,54.31,52.19,51.34,52.38,53.44,54.16,56.78,57.81,58.31,58.0,58.03,57.41,57.81,57.88,58.69,58.84,60.28,59.91,61.78,62.06,63.75,65.69,65.44,67.25,67.38,67.19,68.78,69.56,70.75,72.22,72.78,73.44,72.91,71.31,69.66,67.47,66.19,65.91,65.69,65.91,66.28,66.06,64.31,61.78,59.97,58.38,56.47,55.69,55.84,54.91,55.81,54.31,54.28,54.0,53.44,52.19,52.31,52.84,52.69,53.66,53.62,53.62,52.75,50.97,50.56,49.84,50.16,50.81,50.59,50.25,48.66,46.09,45.97,43.38,43.44,46.56,47.31,49.31,52.12,52.84,53.47,52.72,52.25,49.88,48.47,46.81,44.41,42.59,41.12,39.62,37.56,37.12,34.94,35.97,36.72,37.34,38.81:79.62,81.38,81.22,82.22,80.53,78.53,76.19,74.69,72.94,70.41,69.25,68.56,70.44,71.47,74.75,75.62,78.41,79.22,79.16,80.56,82.38,83.28,83.28,83.91,83.0,80.91,78.12,75.06,72.06,70.56,68.5,68.5,68.69,71.0,74.28,77.88,83.69,88.44,90.62,93.09,91.81,90.28,89.84,87.94,87.12,86.44,87.16,84.94,84.28,83.28,84.19,84.56,85.94,87.31,86.94,86.06,82.94,79.28,75.72,72.66,68.59,66.28,64.28,62.12,60.62,61.03,62.91,65.19,64.88,68.5,69.34,69.38,70.53,70.78,71.31,70.75,69.44,68.56,67.94,67.62,66.88,67.31,67.31,67.25,67.97,68.03,68.31,70.5,72.06,74.41,78.69,82.12,84.97,86.97,89.91,90.31,90.0,89.72,88.28,86.0,83.44,81.44,80.44,79.97,80.62,80.53,80.16,80.22,76.44,76.62,75.84,75.44,76.56,79.09,81.09,82.88,86.38,89.06,90.41,91.75,91.41,89.94,86.91,84.53,81.41,77.66,75.66,75.06,74.0,75.88,77.62,79.03,79.44,77.81,76.31,75.06,73.91,72.72,72.31,72.22,71.25,70.19,69.56,68.16,68.19,66.41,68.09,66.59,68.53,70.34,71.5,71.31,71.69,73.91,73.0,72.44,75.53,76.16,77.41,77.81,77.5,75.03,74.81,73.94,73.78,75.31,75.5,76.31,76.31,77.16,78.12,78.94,80.03,78.44,81.41,80.47,82.03,84.12,85.84,88.03,88.78,88.44,88.16,86.94,85.53,83.94,84.12,82.75,83.94,83.41,83.69,83.56,83.66,83.16,82.12,82.09,80.28,79.81,79.88,78.72,79.0,77.97,78.62,77.88,79.53,80.06,80.91,81.62,81.72,81.81,82.09,82.38,83.53,83.25,83.78,84.44,84.94,85.56,87.19,86.19,86.12,86.84,87.16,87.0,86.88,87.12,85.09,82.56,80.78,78.22,75.94,74.88,73.53,72.84,72.97,73.66,73.88,73.31,73.38,73.56,70.66,72.47,72.44,72.03,73.88,73.34,72.66,73.09,73.16,72.06,73.12,73.56,72.84,75.09,76.56,78.25,79.47,79.38,78.84,76.56,75.59,75.09,74.56,74.0,74.31,72.12,71.12,71.56,70.78,69.19,69.75,68.06,67.22,66.06,65.06,64.78,62.81,60.56,58.28,57.34,57.72,58.91,61.41,63.75,67.19,69.12,71.25,72.19,74.22,74.62,75.38,76.09,76.06,74.81,73.62,74.28,75.06,76.66,78.88,80.97,81.28,81.47,80.19,80.75,81.22,80.0,81.88,80.28,79.94,80.5,79.09,78.69,79.28,76.47,75.16,75.38,72.31,72.56,74.19,73.12,72.44,70.62,70.22,70.62,69.62,70.75,73.41,74.31,74.78,78.19,81.75,84.53,87.62,90.16,90.62,89.53,88.06,85.28,81.34,81.0,79.34,77.06,77.28,76.66,75.59,74.44,73.97,74.75,75.25,76.31,76.09,77.62,77.72,76.41,77.56,76.31,75.47,71.75,72.12,70.72,70.44,70.12,71.31,71.56,71.91,71.75,74.0,74.69,75.91,78.66,79.19,80.16,79.84,78.62,77.22,76.38,74.88,75.12,73.31,72.31,72.5,70.16,68.91,68.81,65.62,65.41,64.0,63.06,60.66,61.69,60.09,58.94,60.0,61.94,63.5,66.12,66.53,68.16,69.28,69.41,69.75,70.69,71.56,71.94,74.06,77.62,79.09,81.19,80.91,81.0,79.78,78.62,79.56,78.66,79.53,79.38,78.19,74.16,73.16,70.69,67.66,66.22,65.94,64.47,64.75,64.69,65.53,67.03,69.78,71.81,72.97,75.94,76.81,78.28,78.56,79.0,77.84,77.66,76.81,77.16,78.69,78.94,79.25,79.56,80.53,80.25,81.78,82.41,83.91,83.72,83.12,84.56,84.66,83.75,84.44,83.44,80.78,80.28,80.41,78.78,79.12,79.31,78.06,77.34,74.66,73.16,71.19,71.56,70.94,70.62,71.34,70.44,70.66,70.0,70.75,70.81,71.62,69.94,69.28,68.84,66.75,65.03,64.91,64.22,64.28,66.06,64.62,65.56,65.31,64.69,62.16,63.28,61.94,60.69,60.78,60.0,60.88,62.28,63.09,64.31,64.09,64.94,65.72,64.09,64.16,64.0,61.56,61.19,60.19,59.0,58.91,59.38,61.53,61.84,65.03,66.62,67.16,67.47,68.44,69.0,67.81,67.72,66.34,67.31,66.44,66.78,66.53,65.5,63.12,62.25,63.69,65.25,67.03,69.5,71.5,71.66,70.75,69.12,70.06,66.69,69.0,71.03,72.78,76.44,76.78,77.81,75.41,74.03,70.34,68.16,66.66,63.81,63.88,62.03,63.09,64.91,65.91,69.53,71.69,75.25,76.16,77.44,78.59,76.81,76.66,75.94,74.12,73.84,70.59,69.25,66.41,63.16,62.5,62.72,63.16,63.62,64.75,65.53,66.22,68.62,68.78,72.31,73.72,74.91,75.88,76.0,77.06,77.0,77.28,77.88,77.0,77.25,74.31,74.53,74.84,74.59,75.5,76.44,76.59,75.09,75.44,75.38,74.34,75.0,75.19,74.5,75.78,76.75,76.53,77.0,77.81,78.41,79.94,80.94,81.94,82.88,81.44,80.62,78.28,76.94,74.66,74.81,73.62,73.62,74.88,74.5,75.94,75.78,75.44,76.06,74.91,75.66,75.94,75.78,74.19,72.81,70.88,67.16,64.69,63.12,60.31,58.72,57.62,57.97,57.97,59.28,62.38,63.41,65.59,67.25,68.38,70.06,68.88,68.88,67.69,66.31,64.12,62.56,61.28,58.91,58.88,57.56,54.19,56.25,55.06,53.53,55.72,55.34,55.78,58.12,59.03,59.75,61.25,61.41,60.38,58.09,56.94,56.66,56.28,57.84,58.06,59.59,60.31,59.91,61.88,61.28,61.78,62.0,63.53,63.41,64.22,66.31,68.0,67.53,69.91,70.47,70.78,70.34,69.38,66.69,66.19,63.94,63.0,61.44,61.41,61.44,60.56,62.69,63.25,62.88,62.91,61.94,62.0,56.84,57.31,57.12,57.56,59.44,63.78,66.28,68.06,69.84,69.19,69.47,68.38,69.44,69.38,69.12,68.81,67.34,65.53,62.84,62.5,60.34,61.81,62.22,64.53,65.72,67.97,69.19,69.53,69.47,68.91,66.88,64.78,63.69,61.78,60.47,62.16,61.09,61.88,63.06,62.84,62.91,63.0,60.72,60.59,60.22,60.59,61.53,64.06,67.84,70.0,74.16,77.91,80.44,81.59,81.62,79.31,77.0,73.56,72.16,70.38,68.81,67.81,66.19,64.91,63.94,63.94,64.94,65.66,66.69,67.62,67.28,68.44,68.22,67.91,66.88,64.88,63.81,60.56,58.66,56.34,54.31,52.19,51.34,52.38,53.44,54.16,56.78,57.81,58.31,58.0,58.03,57.41,57.81,57.88,58.69,58.84,60.28,59.91,61.78,62.06,63.75,65.69,65.44,67.25,67.38,67.19,68.78,69.56,70.75,72.22,72.78,73.44,72.91,71.31,69.66,67.47,66.19,65.91,65.69,65.91,66.28,66.06,64.31,61.78,59.97,58.38,56.47,55.69,55.84,54.91,55.81,54.31,54.28,54.0,53.44,52.19,52.31,52.84,52.69,53.66,53.62,53.62,52.75,50.97,50.56,49.84,50.16,50.81,50.59,50.25,48.66,46.09,45.97,43.38,43.44,46.56,47.31,49.31,52.12,52.84,53.47,52.72,52.25,49.88,48.47,46.81,44.41,42.59,41.12,39.62,37.56,37.12,34.94,35.97,36.72,37.34,38.81,24.88,26.22,26.97,28.56,30.91,32.94:76.19,74.69,72.94,70.41,69.25,68.56,70.44,71.47,74.75,75.62,78.41,79.22,79.16,80.56,82.38,83.28,83.28,83.91,83.0,80.91,78.12,75.06,72.06,70.56,68.5,68.5,68.69,71.0,74.28,77.88,83.69,88.44,90.62,93.09,91.81,90.28,89.84,87.94,87.12,86.44,87.16,84.94,84.28,83.28,84.19,84.56,85.94,87.31,86.94,86.06,82.94,79.28,75.72,72.66,68.59,66.28,64.28,62.12,60.62,61.03,62.91,65.19,64.88,68.5,69.34,69.38,70.53,70.78,71.31,70.75,69.44,68.56,67.94,67.62,66.88,67.31,67.31,67.25,67.97,68.03,68.31,70.5,72.06,74.41,78.69,82.12,84.97,86.97,89.91,90.31,90.0,89.72,88.28,86.0,83.44,81.44,80.44,79.97,80.62,80.53,80.16,80.22,76.44,76.62,75.84,75.44,76.56,79.09,81.09,82.88,86.38,89.06,90.41,91.75,91.41,89.94,86.91,84.53,81.41,77.66,75.66,75.06,74.0,75.88,77.62,79.03,79.44,77.81,76.31,75.06,73.91,72.72,72.31,72.22,71.25,70.19,69.56,68.16,68.19,66.41,68.09,66.59,68.53,70.34,71.5,71.31,71.69,73.91,73.0,72.44,75.53,76.16,77.41,77.81,77.5,75.03,74.81,73.94,73.78,75.31,75.5,76.31,76.31,77.16,78.12,78.94,80.03,78.44,81.41,80.47,82.03,84.12,85.84,88.03,88.78,88.44,88.16,86.94,85.53,83.94,84.12,82.75,83.94,83.41,83.69,83.56,83.66,83.16,82.12,82.09,80.28,79.81,79.88,78.72,79.0,77.97,78.62,77.88,79.53,80.06,80.91,81.62,81.72,81.81,82.09,82.38,83.53,83.25,83.78,84.44,84.94,85.56,87.19,86.19,86.12,86.84,87.16,87.0,86.88,87.12,85.09,82.56,80.78,78.22,75.94,74.88,73.53,72.84,72.97,73.66,73.88,73.31,73.38,73.56,70.66,72.47,72.44,72.03,73.88,73.34,72.66,73.09,73.16,72.06,73.12,73.56,72.84,75.09,76.56,78.25,79.47,79.38,78.84,76.56,75.59,75.09,74.56,74.0,74.31,72.12,71.12,71.56,70.78,69.19,69.75,68.06,67.22,66.06,65.06,64.78,62.81,60.56,58.28,57.34,57.72,58.91,61.41,63.75,67.19,69.12,71.25,72.19,74.22,74.62,75.38,76.09,76.06,74.81,73.62,74.28,75.06,76.66,78.88,80.97,81.28,81.47,80.19,80.75,81.22,80.0,81.88,80.28,79.94,80.5,79.09,78.69,79.28,76.47,75.16,75.38,72.31,72.56,74.19,73.12,72.44,70.62,70.22,70.62,69.62,70.75,73.41,74.31,74.78,78.19,81.75,84.53,87.62,90.16,90.62,89.53,88.06,85.28,81.34,81.0,79.34,77.06,77.28,76.66,75.59,74.44,73.97,74.75,75.25,76.31,76.09,77.62,77.72,76.41,77.56,76.31,75.47,71.75,72.12,70.72,70.44,70.12,71.31,71.56,71.91,71.75,74.0,74.69,75.91,78.66,79.19,80.16,79.84,78.62,77.22,76.38,74.88,75.12,73.31,72.31,72.5,70.16,68.91,68.81,65.62,65.41,64.0,63.06,60.66,61.69,60.09,58.94,60.0,61.94,63.5,66.12,66.53,68.16,69.28,69.41,69.75,70.69,71.56,71.94,74.06,77.62,79.09,81.19,80.91,81.0,79.78,78.62,79.56,78.66,79.53,79.38,78.19,74.16,73.16,70.69,67.66,66.22,65.94,64.47,64.75,64.69,65.53,67.03,69.78,71.81,72.97,75.94,76.81,78.28,78.56,79.0,77.84,77.66,76.81,77.16,78.69,78.94,79.25,79.56,80.53,80.25,81.78,82.41,83.91,83.72,83.12,84.56,84.66,83.75,84.44,83.44,80.78,80.28,80.41,78.78,79.12,79.31,78.06,77.34,74.66,73.16,71.19,71.56,70.94,70.62,71.34,70.44,70.66,70.0,70.75,70.81,71.62,69.94,69.28,68.84,66.75,65.03,64.91,64.22,64.28,66.06,64.62,65.56,65.31,64.69,62.16,63.28,61.94,60.69,60.78,60.0,60.88,62.28,63.09,64.31,64.09,64.94,65.72,64.09,64.16,64.0,61.56,61.19,60.19,59.0,58.91,59.38,61.53,61.84,65.03,66.62,67.16,67.47,68.44,69.0,67.81,67.72,66.34,67.31,66.44,66.78,66.53,65.5,63.12,62.25,63.69,65.25,67.03,69.5,71.5,71.66,70.75,69.12,70.06,66.69,69.0,71.03,72.78,76.44,76.78,77.81,75.41,74.03,70.34,68.16,66.66,63.81,63.88,62.03,63.09,64.91,65.91,69.53,71.69,75.25,76.16,77.44,78.59,76.81,76.66,75.94,74.12,73.84,70.59,69.25,66.41,63.16,62.5,62.72,63.16,63.62,64.75,65.53,66.22,68.62,68.78,72.31,73.72,74.91,75.88,76.0,77.06,77.0,77.28,77.88,77.0,77.25,74.31,74.53,74.84,74.59,75.5,76.44,76.59,75.09,75.44,75.38,74.34,75.0,75.19,74.5,75.78,76.75,76.53,77.0,77.81,78.41,79.94,80.94,81.94,82.88,81.44,80.62,78.28,76.94,74.66,74.81,73.62,73.62,74.88,74.5,75.94,75.78,75.44,76.06,74.91,75.66,75.94,75.78,74.19,72.81,70.88,67.16,64.69,63.12,60.31,58.72,57.62,57.97,57.97,59.28,62.38,63.41,65.59,67.25,68.38,70.06,68.88,68.88,67.69,66.31,64.12,62.56,61.28,58.91,58.88,57.56,54.19,56.25,55.06,53.53,55.72,55.34,55.78,58.12,59.03,59.75,61.25,61.41,60.38,58.09,56.94,56.66,56.28,57.84,58.06,59.59,60.31,59.91,61.88,61.28,61.78,62.0,63.53,63.41,64.22,66.31,68.0,67.53,69.91,70.47,70.78,70.34,69.38,66.69,66.19,63.94,63.0,61.44,61.41,61.44,60.56,62.69,63.25,62.88,62.91,61.94,62.0,56.84,57.31,57.12,57.56,59.44,63.78,66.28,68.06,69.84,69.19,69.47,68.38,69.44,69.38,69.12,68.81,67.34,65.53,62.84,62.5,60.34,61.81,62.22,64.53,65.72,67.97,69.19,69.53,69.47,68.91,66.88,64.78,63.69,61.78,60.47,62.16,61.09,61.88,63.06,62.84,62.91,63.0,60.72,60.59,60.22,60.59,61.53,64.06,67.84,70.0,74.16,77.91,80.44,81.59,81.62,79.31,77.0,73.56,72.16,70.38,68.81,67.81,66.19,64.91,63.94,63.94,64.94,65.66,66.69,67.62,67.28,68.44,68.22,67.91,66.88,64.88,63.81,60.56,58.66,56.34,54.31,52.19,51.34,52.38,53.44,54.16,56.78,57.81,58.31,58.0,58.03,57.41,57.81,57.88,58.69,58.84,60.28,59.91,61.78,62.06,63.75,65.69,65.44,67.25,67.38,67.19,68.78,69.56,70.75,72.22,72.78,73.44,72.91,71.31,69.66,67.47,66.19,65.91,65.69,65.91,66.28,66.06,64.31,61.78,59.97,58.38,56.47,55.69,55.84,54.91,55.81,54.31,54.28,54.0,53.44,52.19,52.31,52.84,52.69,53.66,53.62,53.62,52.75,50.97,50.56,49.84,50.16,50.81,50.59,50.25,48.66,46.09,45.97,43.38,43.44,46.56,47.31,49.31,52.12,52.84,53.47,52.72,52.25,49.88,48.47,46.81,44.41,42.59,41.12,39.62,37.56,37.12,34.94,35.97,36.72,37.34,38.81,24.88,26.22,26.97,28.56,30.91,32.94,36.22,39.0,40.56,41.66,40.94,39.41:70.44,71.47,74.75,75.62,78.41,79.22,79.16,80.56,82.38,83.28,83.28,83.91,83.0,80.91,78.12,75.06,72.06,70.56,68.5,68.5,68.69,71.0,74.28,77.88,83.69,88.44,90.62,93.09,91.81,90.28,89.84,87.94,87.12,86.44,87.16,84.94,84.28,83.28,84.19,84.56,85.94,87.31,86.94,86.06,82.94,79.28,75.72,72.66,68.59,66.28,64.28,62.12,60.62,61.03,62.91,65.19,64.88,68.5,69.34,69.38,70.53,70.78,71.31,70.75,69.44,68.56,67.94,67.62,66.88,67.31,67.31,67.25,67.97,68.03,68.31,70.5,72.06,74.41,78.69,82.12,84.97,86.97,89.91,90.31,90.0,89.72,88.28,86.0,83.44,81.44,80.44,79.97,80.62,80.53,80.16,80.22,76.44,76.62,75.84,75.44,76.56,79.09,81.09,82.88,86.38,89.06,90.41,91.75,91.41,89.94,86.91,84.53,81.41,77.66,75.66,75.06,74.0,75.88,77.62,79.03,79.44,77.81,76.31,75.06,73.91,72.72,72.31,72.22,71.25,70.19,69.56,68.16,68.19,66.41,68.09,66.59,68.53,70.34,71.5,71.31,71.69,73.91,73.0,72.44,75.53,76.16,77.41,77.81,77.5,75.03,74.81,73.94,73.78,75.31,75.5,76.31,76.31,77.16,78.12,78.94,80.03,78.44,81.41,80.47,82.03,84.12,85.84,88.03,88.78,88.44,88.16,86.94,85.53,83.94,84.12,82.75,83.94,83.41,83.69,83.56,83.66,83.16,82.12,82.09,80.28,79.81,79.88,78.72,79.0,77.97,78.62,77.88,79.53,80.06,80.91,81.62,81.72,81.81,82.09,82.38,83.53,83.25,83.78,84.44,84.94,85.56,87.19,86.19,86.12,86.84,87.16,87.0,86.88,87.12,85.09,82.56,80.78,78.22,75.94,74.88,73.53,72.84,72.97,73.66,73.88,73.31,73.38,73.56,70.66,72.47,72.44,72.03,73.88,73.34,72.66,73.09,73.16,72.06,73.12,73.56,72.84,75.09,76.56,78.25,79.47,79.38,78.84,76.56,75.59,75.09,74.56,74.0,74.31,72.12,71.12,71.56,70.78,69.19,69.75,68.06,67.22,66.06,65.06,64.78,62.81,60.56,58.28,57.34,57.72,58.91,61.41,63.75,67.19,69.12,71.25,72.19,74.22,74.62,75.38,76.09,76.06,74.81,73.62,74.28,75.06,76.66,78.88,80.97,81.28,81.47,80.19,80.75,81.22,80.0,81.88,80.28,79.94,80.5,79.09,78.69,79.28,76.47,75.16,75.38,72.31,72.56,74.19,73.12,72.44,70.62,70.22,70.62,69.62,70.75,73.41,74.31,74.78,78.19,81.75,84.53,87.62,90.16,90.62,89.53,88.06,85.28,81.34,81.0,79.34,77.06,77.28,76.66,75.59,74.44,73.97,74.75,75.25,76.31,76.09,77.62,77.72,76.41,77.56,76.31,75.47,71.75,72.12,70.72,70.44,70.12,71.31,71.56,71.91,71.75,74.0,74.69,75.91,78.66,79.19,80.16,79.84,78.62,77.22,76.38,74.88,75.12,73.31,72.31,72.5,70.16,68.91,68.81,65.62,65.41,64.0,63.06,60.66,61.69,60.09,58.94,60.0,61.94,63.5,66.12,66.53,68.16,69.28,69.41,69.75,70.69,71.56,71.94,74.06,77.62,79.09,81.19,80.91,81.0,79.78,78.62,79.56,78.66,79.53,79.38,78.19,74.16,73.16,70.69,67.66,66.22,65.94,64.47,64.75,64.69,65.53,67.03,69.78,71.81,72.97,75.94,76.81,78.28,78.56,79.0,77.84,77.66,76.81,77.16,78.69,78.94,79.25,79.56,80.53,80.25,81.78,82.41,83.91,83.72,83.12,84.56,84.66,83.75,84.44,83.44,80.78,80.28,80.41,78.78,79.12,79.31,78.06,77.34,74.66,73.16,71.19,71.56,70.94,70.62,71.34,70.44,70.66,70.0,70.75,70.81,71.62,69.94,69.28,68.84,66.75,65.03,64.91,64.22,64.28,66.06,64.62,65.56,65.31,64.69,62.16,63.28,61.94,60.69,60.78,60.0,60.88,62.28,63.09,64.31,64.09,64.94,65.72,64.09,64.16,64.0,61.56,61.19,60.19,59.0,58.91,59.38,61.53,61.84,65.03,66.62,67.16,67.47,68.44,69.0,67.81,67.72,66.34,67.31,66.44,66.78,66.53,65.5,63.12,62.25,63.69,65.25,67.03,69.5,71.5,71.66,70.75,69.12,70.06,66.69,69.0,71.03,72.78,76.44,76.78,77.81,75.41,74.03,70.34,68.16,66.66,63.81,63.88,62.03,63.09,64.91,65.91,69.53,71.69,75.25,76.16,77.44,78.59,76.81,76.66,75.94,74.12,73.84,70.59,69.25,66.41,63.16,62.5,62.72,63.16,63.62,64.75,65.53,66.22,68.62,68.78,72.31,73.72,74.91,75.88,76.0,77.06,77.0,77.28,77.88,77.0,77.25,74.31,74.53,74.84,74.59,75.5,76.44,76.59,75.09,75.44,75.38,74.34,75.0,75.19,74.5,75.78,76.75,76.53,77.0,77.81,78.41,79.94,80.94,81.94,82.88,81.44,80.62,78.28,76.94,74.66,74.81,73.62,73.62,74.88,74.5,75.94,75.78,75.44,76.06,74.91,75.66,75.94,75.78,74.19,72.81,70.88,67.16,64.69,63.12,60.31,58.72,57.62,57.97,57.97,59.28,62.38,63.41,65.59,67.25,68.38,70.06,68.88,68.88,67.69,66.31,64.12,62.56,61.28,58.91,58.88,57.56,54.19,56.25,55.06,53.53,55.72,55.34,55.78,58.12,59.03,59.75,61.25,61.41,60.38,58.09,56.94,56.66,56.28,57.84,58.06,59.59,60.31,59.91,61.88,61.28,61.78,62.0,63.53,63.41,64.22,66.31,68.0,67.53,69.91,70.47,70.78,70.34,69.38,66.69,66.19,63.94,63.0,61.44,61.41,61.44,60.56,62.69,63.25,62.88,62.91,61.94,62.0,56.84,57.31,57.12,57.56,59.44,63.78,66.28,68.06,69.84,69.19,69.47,68.38,69.44,69.38,69.12,68.81,67.34,65.53,62.84,62.5,60.34,61.81,62.22,64.53,65.72,67.97,69.19,69.53,69.47,68.91,66.88,64.78,63.69,61.78,60.47,62.16,61.09,61.88,63.06,62.84,62.91,63.0,60.72,60.59,60.22,60.59,61.53,64.06,67.84,70.0,74.16,77.91,80.44,81.59,81.62,79.31,77.0,73.56,72.16,70.38,68.81,67.81,66.19,64.91,63.94,63.94,64.94,65.66,66.69,67.62,67.28,68.44,68.22,67.91,66.88,64.88,63.81,60.56,58.66,56.34,54.31,52.19,51.34,52.38,53.44,54.16,56.78,57.81,58.31,58.0,58.03,57.41,57.81,57.88,58.69,58.84,60.28,59.91,61.78,62.06,63.75,65.69,65.44,67.25,67.38,67.19,68.78,69.56,70.75,72.22,72.78,73.44,72.91,71.31,69.66,67.47,66.19,65.91,65.69,65.91,66.28,66.06,64.31,61.78,59.97,58.38,56.47,55.69,55.84,54.91,55.81,54.31,54.28,54.0,53.44,52.19,52.31,52.84,52.69,53.66,53.62,53.62,52.75,50.97,50.56,49.84,50.16,50.81,50.59,50.25,48.66,46.09,45.97,43.38,43.44,46.56,47.31,49.31,52.12,52.84,53.47,52.72,52.25,49.88,48.47,46.81,44.41,42.59,41.12,39.62,37.56,37.12,34.94,35.97,36.72,37.34,38.81,24.88,26.22,26.97,28.56,30.91,32.94,36.22,39.0,40.56,41.66,40.94,39.41,36.84,34.0,31.97,28.66,25.62,24.31:79.16,80.56,82.38,83.28,83.28,83.91,83.0,80.91,78.12,75.06,72.06,70.56,68.5,68.5,68.69,71.0,74.28,77.88,83.69,88.44,90.62,93.09,91.81,90.28,89.84,87.94,87.12,86.44,87.16,84.94,84.28,83.28,84.19,84.56,85.94,87.31,86.94,86.06,82.94,79.28,75.72,72.66,68.59,66.28,64.28,62.12,60.62,61.03,62.91,65.19,64.88,68.5,69.34,69.38,70.53,70.78,71.31,70.75,69.44,68.56,67.94,67.62,66.88,67.31,67.31,67.25,67.97,68.03,68.31,70.5,72.06,74.41,78.69,82.12,84.97,86.97,89.91,90.31,90.0,89.72,88.28,86.0,83.44,81.44,80.44,79.97,80.62,80.53,80.16,80.22,76.44,76.62,75.84,75.44,76.56,79.09,81.09,82.88,86.38,89.06,90.41,91.75,91.41,89.94,86.91,84.53,81.41,77.66,75.66,75.06,74.0,75.88,77.62,79.03,79.44,77.81,76.31,75.06,73.91,72.72,72.31,72.22,71.25,70.19,69.56,68.16,68.19,66.41,68.09,66.59,68.53,70.34,71.5,71.31,71.69,73.91,73.0,72.44,75.53,76.16,77.41,77.81,77.5,75.03,74.81,73.94,73.78,75.31,75.5,76.31,76.31,77.16,78.12,78.94,80.03,78.44,81.41,80.47,82.03,84.12,85.84,88.03,88.78,88.44,88.16,86.94,85.53,83.94,84.12,82.75,83.94,83.41,83.69,83.56,83.66,83.16,82.12,82.09,80.28,79.81,79.88,78.72,79.0,77.97,78.62,77.88,79.53,80.06,80.91,81.62,81.72,81.81,82.09,82.38,83.53,83.25,83.78,84.44,84.94,85.56,87.19,86.19,86.12,86.84,87.16,87.0,86.88,87.12,85.09,82.56,80.78,78.22,75.94,74.88,73.53,72.84,72.97,73.66,73.88,73.31,73.38,73.56,70.66,72.47,72.44,72.03,73.88,73.34,72.66,73.09,73.16,72.06,73.12,73.56,72.84,75.09,76.56,78.25,79.47,79.38,78.84,76.56,75.59,75.09,74.56,74.0,74.31,72.12,71.12,71.56,70.78,69.19,69.75,68.06,67.22,66.06,65.06,64.78,62.81,60.56,58.28,57.34,57.72,58.91,61.41,63.75,67.19,69.12,71.25,72.19,74.22,74.62,75.38,76.09,76.06,74.81,73.62,74.28,75.06,76.66,78.88,80.97,81.28,81.47,80.19,80.75,81.22,80.0,81.88,80.28,79.94,80.5,79.09,78.69,79.28,76.47,75.16,75.38,72.31,72.56,74.19,73.12,72.44,70.62,70.22,70.62,69.62,70.75,73.41,74.31,74.78,78.19,81.75,84.53,87.62,90.16,90.62,89.53,88.06,85.28,81.34,81.0,79.34,77.06,77.28,76.66,75.59,74.44,73.97,74.75,75.25,76.31,76.09,77.62,77.72,76.41,77.56,76.31,75.47,71.75,72.12,70.72,70.44,70.12,71.31,71.56,71.91,71.75,74.0,74.69,75.91,78.66,79.19,80.16,79.84,78.62,77.22,76.38,74.88,75.12,73.31,72.31,72.5,70.16,68.91,68.81,65.62,65.41,64.0,63.06,60.66,61.69,60.09,58.94,60.0,61.94,63.5,66.12,66.53,68.16,69.28,69.41,69.75,70.69,71.56,71.94,74.06,77.62,79.09,81.19,80.91,81.0,79.78,78.62,79.56,78.66,79.53,79.38,78.19,74.16,73.16,70.69,67.66,66.22,65.94,64.47,64.75,64.69,65.53,67.03,69.78,71.81,72.97,75.94,76.81,78.28,78.56,79.0,77.84,77.66,76.81,77.16,78.69,78.94,79.25,79.56,80.53,80.25,81.78,82.41,83.91,83.72,83.12,84.56,84.66,83.75,84.44,83.44,80.78,80.28,80.41,78.78,79.12,79.31,78.06,77.34,74.66,73.16,71.19,71.56,70.94,70.62,71.34,70.44,70.66,70.0,70.75,70.81,71.62,69.94,69.28,68.84,66.75,65.03,64.91,64.22,64.28,66.06,64.62,65.56,65.31,64.69,62.16,63.28,61.94,60.69,60.78,60.0,60.88,62.28,63.09,64.31,64.09,64.94,65.72,64.09,64.16,64.0,61.56,61.19,60.19,59.0,58.91,59.38,61.53,61.84,65.03,66.62,67.16,67.47,68.44,69.0,67.81,67.72,66.34,67.31,66.44,66.78,66.53,65.5,63.12,62.25,63.69,65.25,67.03,69.5,71.5,71.66,70.75,69.12,70.06,66.69,69.0,71.03,72.78,76.44,76.78,77.81,75.41,74.03,70.34,68.16,66.66,63.81,63.88,62.03,63.09,64.91,65.91,69.53,71.69,75.25,76.16,77.44,78.59,76.81,76.66,75.94,74.12,73.84,70.59,69.25,66.41,63.16,62.5,62.72,63.16,63.62,64.75,65.53,66.22,68.62,68.78,72.31,73.72,74.91,75.88,76.0,77.06,77.0,77.28,77.88,77.0,77.25,74.31,74.53,74.84,74.59,75.5,76.44,76.59,75.09,75.44,75.38,74.34,75.0,75.19,74.5,75.78,76.75,76.53,77.0,77.81,78.41,79.94,80.94,81.94,82.88,81.44,80.62,78.28,76.94,74.66,74.81,73.62,73.62,74.88,74.5,75.94,75.78,75.44,76.06,74.91,75.66,75.94,75.78,74.19,72.81,70.88,67.16,64.69,63.12,60.31,58.72,57.62,57.97,57.97,59.28,62.38,63.41,65.59,67.25,68.38,70.06,68.88,68.88,67.69,66.31,64.12,62.56,61.28,58.91,58.88,57.56,54.19,56.25,55.06,53.53,55.72,55.34,55.78,58.12,59.03,59.75,61.25,61.41,60.38,58.09,56.94,56.66,56.28,57.84,58.06,59.59,60.31,59.91,61.88,61.28,61.78,62.0,63.53,63.41,64.22,66.31,68.0,67.53,69.91,70.47,70.78,70.34,69.38,66.69,66.19,63.94,63.0,61.44,61.41,61.44,60.56,62.69,63.25,62.88,62.91,61.94,62.0,56.84,57.31,57.12,57.56,59.44,63.78,66.28,68.06,69.84,69.19,69.47,68.38,69.44,69.38,69.12,68.81,67.34,65.53,62.84,62.5,60.34,61.81,62.22,64.53,65.72,67.97,69.19,69.53,69.47,68.91,66.88,64.78,63.69,61.78,60.47,62.16,61.09,61.88,63.06,62.84,62.91,63.0,60.72,60.59,60.22,60.59,61.53,64.06,67.84,70.0,74.16,77.91,80.44,81.59,81.62,79.31,77.0,73.56,72.16,70.38,68.81,67.81,66.19,64.91,63.94,63.94,64.94,65.66,66.69,67.62,67.28,68.44,68.22,67.91,66.88,64.88,63.81,60.56,58.66,56.34,54.31,52.19,51.34,52.38,53.44,54.16,56.78,57.81,58.31,58.0,58.03,57.41,57.81,57.88,58.69,58.84,60.28,59.91,61.78,62.06,63.75,65.69,65.44,67.25,67.38,67.19,68.78,69.56,70.75,72.22,72.78,73.44,72.91,71.31,69.66,67.47,66.19,65.91,65.69,65.91,66.28,66.06,64.31,61.78,59.97,58.38,56.47,55.69,55.84,54.91,55.81,54.31,54.28,54.0,53.44,52.19,52.31,52.84,52.69,53.66,53.62,53.62,52.75,50.97,50.56,49.84,50.16,50.81,50.59,50.25,48.66,46.09,45.97,43.38,43.44,46.56,47.31,49.31,52.12,52.84,53.47,52.72,52.25,49.88,48.47,46.81,44.41,42.59,41.12,39.62,37.56,37.12,34.94,35.97,36.72,37.34,38.81,24.88,26.22,26.97,28.56,30.91,32.94,36.22,39.0,40.56,41.66,40.94,39.41,36.84,34.0,31.97,28.66,25.62,24.31,25.72,24.75,27.41,29.06,32.62,33.75:83.0,80.91,78.12,75.06,72.06,70.56,68.5,68.5,68.69,71.0,74.28,77.88,83.69,88.44,90.62,93.09,91.81,90.28,89.84,87.94,87.12,86.44,87.16,84.94,84.28,83.28,84.19,84.56,85.94,87.31,86.94,86.06,82.94,79.28,75.72,72.66,68.59,66.28,64.28,62.12,60.62,61.03,62.91,65.19,64.88,68.5,69.34,69.38,70.53,70.78,71.31,70.75,69.44,68.56,67.94,67.62,66.88,67.31,67.31,67.25,67.97,68.03,68.31,70.5,72.06,74.41,78.69,82.12,84.97,86.97,89.91,90.31,90.0,89.72,88.28,86.0,83.44,81.44,80.44,79.97,80.62,80.53,80.16,80.22,76.44,76.62,75.84,75.44,76.56,79.09,81.09,82.88,86.38,89.06,90.41,91.75,91.41,89.94,86.91,84.53,81.41,77.66,75.66,75.06,74.0,75.88,77.62,79.03,79.44,77.81,76.31,75.06,73.91,72.72,72.31,72.22,71.25,70.19,69.56,68.16,68.19,66.41,68.09,66.59,68.53,70.34,71.5,71.31,71.69,73.91,73.0,72.44,75.53,76.16,77.41,77.81,77.5,75.03,74.81,73.94,73.78,75.31,75.5,76.31,76.31,77.16,78.12,78.94,80.03,78.44,81.41,80.47,82.03,84.12,85.84,88.03,88.78,88.44,88.16,86.94,85.53,83.94,84.12,82.75,83.94,83.41,83.69,83.56,83.66,83.16,82.12,82.09,80.28,79.81,79.88,78.72,79.0,77.97,78.62,77.88,79.53,80.06,80.91,81.62,81.72,81.81,82.09,82.38,83.53,83.25,83.78,84.44,84.94,85.56,87.19,86.19,86.12,86.84,87.16,87.0,86.88,87.12,85.09,82.56,80.78,78.22,75.94,74.88,73.53,72.84,72.97,73.66,73.88,73.31,73.38,73.56,70.66,72.47,72.44,72.03,73.88,73.34,72.66,73.09,73.16,72.06,73.12,73.56,72.84,75.09,76.56,78.25,79.47,79.38,78.84,76.56,75.59,75.09,74.56,74.0,74.31,72.12,71.12,71.56,70.78,69.19,69.75,68.06,67.22,66.06,65.06,64.78,62.81,60.56,58.28,57.34,57.72,58.91,61.41,63.75,67.19,69.12,71.25,72.19,74.22,74.62,75.38,76.09,76.06,74.81,73.62,74.28,75.06,76.66,78.88,80.97,81.28,81.47,80.19,80.75,81.22,80.0,81.88,80.28,79.94,80.5,79.09,78.69,79.28,76.47,75.16,75.38,72.31,72.56,74.19,73.12,72.44,70.62,70.22,70.62,69.62,70.75,73.41,74.31,74.78,78.19,81.75,84.53,87.62,90.16,90.62,89.53,88.06,85.28,81.34,81.0,79.34,77.06,77.28,76.66,75.59,74.44,73.97,74.75,75.25,76.31,76.09,77.62,77.72,76.41,77.56,76.31,75.47,71.75,72.12,70.72,70.44,70.12,71.31,71.56,71.91,71.75,74.0,74.69,75.91,78.66,79.19,80.16,79.84,78.62,77.22,76.38,74.88,75.12,73.31,72.31,72.5,70.16,68.91,68.81,65.62,65.41,64.0,63.06,60.66,61.69,60.09,58.94,60.0,61.94,63.5,66.12,66.53,68.16,69.28,69.41,69.75,70.69,71.56,71.94,74.06,77.62,79.09,81.19,80.91,81.0,79.78,78.62,79.56,78.66,79.53,79.38,78.19,74.16,73.16,70.69,67.66,66.22,65.94,64.47,64.75,64.69,65.53,67.03,69.78,71.81,72.97,75.94,76.81,78.28,78.56,79.0,77.84,77.66,76.81,77.16,78.69,78.94,79.25,79.56,80.53,80.25,81.78,82.41,83.91,83.72,83.12,84.56,84.66,83.75,84.44,83.44,80.78,80.28,80.41,78.78,79.12,79.31,78.06,77.34,74.66,73.16,71.19,71.56,70.94,70.62,71.34,70.44,70.66,70.0,70.75,70.81,71.62,69.94,69.28,68.84,66.75,65.03,64.91,64.22,64.28,66.06,64.62,65.56,65.31,64.69,62.16,63.28,61.94,60.69,60.78,60.0,60.88,62.28,63.09,64.31,64.09,64.94,65.72,64.09,64.16,64.0,61.56,61.19,60.19,59.0,58.91,59.38,61.53,61.84,65.03,66.62,67.16,67.47,68.44,69.0,67.81,67.72,66.34,67.31,66.44,66.78,66.53,65.5,63.12,62.25,63.69,65.25,67.03,69.5,71.5,71.66,70.75,69.12,70.06,66.69,69.0,71.03,72.78,76.44,76.78,77.81,75.41,74.03,70.34,68.16,66.66,63.81,63.88,62.03,63.09,64.91,65.91,69.53,71.69,75.25,76.16,77.44,78.59,76.81,76.66,75.94,74.12,73.84,70.59,69.25,66.41,63.16,62.5,62.72,63.16,63.62,64.75,65.53,66.22,68.62,68.78,72.31,73.72,74.91,75.88,76.0,77.06,77.0,77.28,77.88,77.0,77.25,74.31,74.53,74.84,74.59,75.5,76.44,76.59,75.09,75.44,75.38,74.34,75.0,75.19,74.5,75.78,76.75,76.53,77.0,77.81,78.41,79.94,80.94,81.94,82.88,81.44,80.62,78.28,76.94,74.66,74.81,73.62,73.62,74.88,74.5,75.94,75.78,75.44,76.06,74.91,75.66,75.94,75.78,74.19,72.81,70.88,67.16,64.69,63.12,60.31,58.72,57.62,57.97,57.97,59.28,62.38,63.41,65.59,67.25,68.38,70.06,68.88,68.88,67.69,66.31,64.12,62.56,61.28,58.91,58.88,57.56,54.19,56.25,55.06,53.53,55.72,55.34,55.78,58.12,59.03,59.75,61.25,61.41,60.38,58.09,56.94,56.66,56.28,57.84,58.06,59.59,60.31,59.91,61.88,61.28,61.78,62.0,63.53,63.41,64.22,66.31,68.0,67.53,69.91,70.47,70.78,70.34,69.38,66.69,66.19,63.94,63.0,61.44,61.41,61.44,60.56,62.69,63.25,62.88,62.91,61.94,62.0,56.84,57.31,57.12,57.56,59.44,63.78,66.28,68.06,69.84,69.19,69.47,68.38,69.44,69.38,69.12,68.81,67.34,65.53,62.84,62.5,60.34,61.81,62.22,64.53,65.72,67.97,69.19,69.53,69.47,68.91,66.88,64.78,63.69,61.78,60.47,62.16,61.09,61.88,63.06,62.84,62.91,63.0,60.72,60.59,60.22,60.59,61.53,64.06,67.84,70.0,74.16,77.91,80.44,81.59,81.62,79.31,77.0,73.56,72.16,70.38,68.81,67.81,66.19,64.91,63.94,63.94,64.94,65.66,66.69,67.62,67.28,68.44,68.22,67.91,66.88,64.88,63.81,60.56,58.66,56.34,54.31,52.19,51.34,52.38,53.44,54.16,56.78,57.81,58.31,58.0,58.03,57.41,57.81,57.88,58.69,58.84,60.28,59.91,61.78,62.06,63.75,65.69,65.44,67.25,67.38,67.19,68.78,69.56,70.75,72.22,72.78,73.44,72.91,71.31,69.66,67.47,66.19,65.91,65.69,65.91,66.28,66.06,64.31,61.78,59.97,58.38,56.47,55.69,55.84,54.91,55.81,54.31,54.28,54.0,53.44,52.19,52.31,52.84,52.69,53.66,53.62,53.62,52.75,50.97,50.56,49.84,50.16,50.81,50.59,50.25,48.66,46.09,45.97,43.38,43.44,46.56,47.31,49.31,52.12,52.84,53.47,52.72,52.25,49.88,48.47,46.81,44.41,42.59,41.12,39.62,37.56,37.12,34.94,35.97,36.72,37.34,38.81,24.88,26.22,26.97,28.56,30.91,32.94,36.22,39.0,40.56,41.66,40.94,39.41,36.84,34.0,31.97,28.66,25.62,24.31,25.72,24.75,27.41,29.06,32.62,33.75,35.19,37.16,39.44,39.56,40.03,41.25:negativity
35.56,37.91,38.66,41.12,42.56,41.81,41.62,38.91,38.19,38.19,37.62,38.62,39.22,39.41,39.16,40.03,42.03,42.31,45.06,46.53,46.59,47.53,45.75,44.25,42.62,39.44,37.72,36.34,34.28,34.06,33.81,34.59,36.38,39.0,43.44,45.62,46.91,48.0,47.16,46.19,47.81,47.31,48.31,47.47,48.62,48.09,47.75,47.88,48.88,50.66,52.94,53.62,54.81,54.53,53.47,51.0,48.97,46.06,44.56,43.03,41.44,41.16,39.75,39.16,38.69,36.66,35.12,32.53,28.75,25.81,24.78,24.0,25.59,28.34,29.81,31.41,32.22,32.97,34.62,35.31,37.09,38.97,40.88,41.06,40.66,39.19,38.44,35.72,34.56,34.22,33.62,33.88,33.25,32.84,33.94,34.38,36.38,37.66,40.72,42.31,44.0,46.19,48.16,48.44,49.53,50.03,49.03,48.38,47.75,46.69,45.66,44.5,44.03,41.91,41.41,40.25,39.12,38.44,36.78,36.0,34.69,34.56,34.59,32.72,32.97,31.72,30.88,30.41,32.34,34.03,35.78,37.81,39.44,40.03,40.91,41.06,40.66,40.34,38.69,38.56,38.34,38.41,40.78,41.94,41.94,43.12,41.69,41.03,37.56,34.19,32.53,30.0,30.38,33.41,36.34,39.69,44.31,46.66,49.25,50.12,48.91,47.44,43.72,40.31,36.34,33.16,31.03,29.66,28.97,28.19,28.91,28.28,28.69,28.56,28.28,28.34,28.5,28.91,30.78,30.44,31.75,32.16,33.34,34.31,34.25,34.56,36.91,36.22,39.72,41.16,43.56,46.16,48.0,49.31,49.78,50.56,49.81,47.97,47.19,44.66,43.69,42.31,41.34,39.91,38.94,39.16,38.66,39.88,40.72,40.84,43.62,44.25,43.97,45.81,46.53,46.03,46.75,46.62,46.62,46.41,47.0,47.44,46.78,48.94,48.75,47.41,45.62,43.62,41.84,40.25,39.34,39.19,39.78,39.75,41.34,40.88,40.47,41.16,40.84,42.16,44.06,46.91,49.91,52.09,54.09,55.28,55.81,55.66,54.62,52.34,49.19,45.75,43.03,38.84,37.19,36.81,36.72,37.94,39.31,41.78,43.81,45.41,47.31,47.19,48.03,47.47,46.62,46.38,46.25,46.56,46.12,44.38,42.5,38.91,36.56,34.12,31.66,31.5,31.81,32.56,34.66,38.44,42.31,45.72,47.69,49.69,49.19,47.78,45.94,44.56,43.84,43.09,42.22,41.78,39.84,37.69,36.81,34.81,33.28,32.84,31.16,32.31,31.78,32.56,33.66,34.53,34.31,32.38,32.16,31.09,30.5,31.06,30.75,31.19,31.34,31.62,33.78,34.38,35.88,37.06,38.06,38.22,38.16,38.44,39.16,39.81,41.41,42.31,42.94,44.22,44.62,44.5,46.16,47.47,48.41,49.22,50.41,50.78,49.94,50.06,48.53,47.38,46.81,44.66,44.91,44.94,45.34,45.44,46.75,47.34,48.97,50.34,53.06,54.81,54.66,55.62,52.78,51.22,48.0,45.47,44.31,42.94,42.91,41.84,40.5,39.44,37.09,35.81,34.28,34.53,34.62,33.66,35.0,34.06,34.91,35.0,35.31,36.59,37.75,39.81,41.44,43.88,45.75,47.59,49.16,49.0,51.06,52.56,53.94,57.12,57.69,58.97,59.12,58.31,57.09,55.84,54.12,53.38,52.25,51.5,49.84,49.16,49.25,48.78,47.28,47.72,48.72,47.31,47.62,46.94,45.38,44.91,43.28,42.0,42.06,40.84,40.19,40.53,41.19,40.56,41.44,42.56,42.91,43.69,44.41,43.38,42.78,40.88,38.94,38.25,39.06,39.25,40.44,41.72,41.41,40.72,40.78,39.88,41.03,41.94,41.59,43.53,43.28,42.91,42.97,44.19,44.62,45.25,46.62,48.16,48.22,48.5,49.25,49.28,48.09,49.41,49.34,49.53,50.31,50.41,50.31,50.03,49.84,49.66,49.34,49.28,48.31,46.25,43.19,42.44,41.16,40.31,40.5,41.09,40.66,40.78,40.47,39.38,38.75,38.19,37.56,36.06,35.53,36.06,35.19,37.16,38.09,37.91,38.97,39.84,39.41,38.69,37.91,35.78,33.16,32.34,30.31,28.81,28.44,27.81,27.66,27.16,26.84,26.38,25.91,27.47,28.72,30.69,34.56,35.94,37.94,38.38,37.47,35.12,33.56,31.12,30.34,27.81,28.62,27.91,29.09,30.34,31.44,31.91,33.09,34.5,33.88,33.84,35.16,34.34,33.91,34.16,34.59,35.19,36.91,37.59,39.72,39.16,39.97,39.31,38.5,39.16,39.0,39.81,40.0,38.53,37.81,36.44,36.19,35.75,36.78,38.19,39.41,41.25,42.31,43.34,45.56,45.81,46.03,47.47,47.12,47.06,48.81,49.19,48.34,48.66,49.06,49.56,49.62,50.62,50.62,49.56,50.56,50.38,51.25,50.66,50.19,49.94,48.69,47.09,48.78,46.41,46.5,46.16,45.53,44.19,43.94,42.56,40.56,39.31,37.34,37.19,37.34,36.94,38.75,37.75,38.38,38.31,37.16,36.5,34.56,33.25,30.66,30.81,31.31,32.91,34.94,38.56,40.12,40.5,40.0,37.72,35.19,31.88,31.03,29.53,30.22,30.91,32.56,33.12,34.06,33.12,32.09,32.28,32.53,33.06,33.53,34.78,34.94,35.56,36.06,36.12,36.72,37.66,36.72,37.06,36.56,36.5,37.5,37.03,37.53,37.81,37.31,37.69,36.94,36.47,36.53,35.59,37.34,38.44,38.53,40.81,41.81,42.66,42.62,42.75,43.97,44.16,43.59,45.12,44.25,42.91,41.34,39.06,37.09,35.44,34.03,32.12,30.62,30.81,28.69,28.66,29.81,29.94,29.91,31.12,31.28,32.16,34.0,35.59,37.28,39.28,41.31,43.16,44.09,45.16,43.91,43.31,42.53,41.91,40.22,39.38,38.09,34.66,31.81,31.06,29.81,29.69,30.75,32.09,33.56,34.44,36.44,37.84,39.0,40.16,40.75,39.38,37.84,36.97,36.56,36.91,37.28,38.78,37.34,37.56,35.59,33.16,30.31,26.69,23.97,22.38,20.09,21.12,22.44,24.81,29.44,32.75,36.62,41.0,40.91,41.91,41.06,38.19,36.75,34.94,32.28,30.88,30.25,30.53,31.0,32.66,33.72,34.59,34.91,34.69,33.0,32.09,30.72,31.69,32.31,34.72,36.28,37.81,38.38,37.41,35.94,34.91,32.16,30.78,28.28,27.72,26.88,26.94,26.5,26.12,26.31,26.12,26.41,26.38,27.28,28.38,30.25,31.22,32.81,34.0,35.06,35.75,36.88,35.5,35.12,34.06,32.81,31.84,31.16,31.41,31.81,33.91,35.53,37.31,39.41,40.66,41.81,41.16,40.44,40.16,39.47,38.56,38.66,39.78,41.09,42.06,42.75,43.44,42.91,41.88,39.91,38.25,35.97,33.69,31.91,30.19,29.0,29.0,28.0,28.03,28.0,28.28,29.78,30.38,32.38,33.16,33.59,32.5,31.38,29.0,27.12,25.12,25.81,26.16,26.75,28.88,29.69,30.62,31.38,31.28,31.06,30.81,31.53,31.75,32.25,33.34,35.31,36.88,37.78,39.25,38.66,39.19,39.38,38.81,38.44,38.03,36.72,36.94,35.31,34.12,33.16,31.72,31.5,30.03,28.84,29.0,28.0,27.5,28.66,29.16,31.25,33.19,34.75,35.84,36.22,35.94,35.28,33.25,34.16,34.69,34.62,36.5,37.25,36.91,37.22,37.38,36.31,35.84,35.59,35.31,35.28,35.75,35.56,36.22,37.34,38.25,39.41,40.56,42.81,43.34:41.62,38.91,38.19,38.19,37.62,38.62,39.22,39.41,39.16,40.03,42.03,42.31,45.06,46.53,46.59,47.53,45.75,44.25,42.62,39.44,37.72,36.34,34.28,34.06,33.81,34.59,36.38,39.0,43.44,45.62,46.91,48.0,47.16,46.19,47.81,47.31,48.31,47.47,48.62,48.09,47.75,47.88,48.88,50.66,52.94,53.62,54.81,54.53,53.47,51.0,48.97,46.06,44.56,43.03,41.44,41.16,39.75,39.16,38.69,36.66,35.12,32.53,28.75,25.81,24.78,24.0,25.59,28.34,29.81,31.41,32.22,32.97,34.62,35.31,37.09,38.97,40.88,41.06,40.66,39.19,38.44,35.72,34.56,34.22,33.62,33.88,33.25,32.84,33.94,34.38,36.38,37.66,40.72,42.31,44.0,46.19,48.16,48.44,49.53,50.03,49.03,48.38,47.75,46.69,45.66,44.5,44.03,41.91,41.41,40.25,39.12,38.44,36.78,36.0,34.69,34.56,34.59,32.72,32.97,31.72,30.88,30.41,32.34,34.03,35.78,37.81,39.44,40.03,40.91,41.06,40.66,40.34,38.69,38.56,38.34,38.41,40.78,41.94,41.94,43.12,41.69,41.03,37.56,34.19,32.53,30.0,30.38,33.41,36.34,39.69,44.31,46.66,49.25,50.12,48.91,47.44,43.72,40.31,36.34,33.16,31.03,29.66,28.97,28.19,28.91,28.28,28.69,28.56,28.28,28.34,28.5,28.91,30.78,30.44,31.75,32.16,33.34,34.31,34.25,34.56,36.91,36.22,39.72,41.16,43.56,46.16,48.0,49.31,49.78,50.56,49.81,47.97,47.19,44.66,43.69,42.31,41.34,39.91,38.94,39.16,38.66,39.88,40.72,40.84,43.62,44.25,43.97,45.81,46.53,46.03,46.75,46.62,46.62,46.41,47.0,47.44,46.78,48.94,48.75,47.41,45.62,43.62,41.84,40.25,39.34,39.19,39.78,39.75,41.34,40.88,40.47,41.16,40.84,42.16,44.06,46.91,49.91,52.09,54.09,55.28,55.81,55.66,54.62,52.34,49.19,45.75,43.03,38.84,37.19,36.81,36.72,37.94,39.31,41.78,43.81,45.41,47.31,47.19,48.03,47.47,46.62,46.38,46.25,46.56,46.12,44.38,42.5,38.91,36.56,34.12,31.66,31.5,31.81,32.56,34.66,38.44,42.31,45.72,47.69,49.69,49.19,47.78,45.94,44.56,43.84,43.09,42.22,41.78,39.84,37.69,36.81,34.81,33.28,32.84,31.16,32.31,31.78,32.56,33.66,34.53,34.31,32.38,32.16,31.09,30.5,31.06,30.75,31.19,31.34,31.62,33.78,34.38,35.88,37.06,38.06,38.22,38.16,38.44,39.16,39.81,41.41,42.31,42.94,44.22,44.62,44.5,46.16,47.47,48.41,49.22,50.41,50.78,49.94,50.06,48.53,47.38,46.81,44.66,44.91,44.94,45.34,45.44,46.75,47.34,48.97,50.34,53.06,54.81,54.66,55.62,52.78,51.22,48.0,45.47,44.31,42.94,42.91,41.84,40.5,39.44,37.09,35.81,34.28,34.53,34.62,33.66,35.0,34.06,34.91,35.0,35.31,36.59,37.75,39.81,41.44,43.88,45.75,47.59,49.16,49.0,51.06,52.56,53.94,57.12,57.69,58.97,59.12,58.31,57.09,55.84,54.12,53.38,52.25,51.5,49.84,49.16,49.25,48.78,47.28,47.72,48.72,47.31,47.62,46.94,45.38,44.91,43.28,42.0,42.06,40.84,40.19,40.53,41.19,40.56,41.44,42.56,42.91,43.69,44.41,43.38,42.78,40.88,38.94,38.25,39.06,39.25,40.44,41.72,41.41,40.72,40.78,39.88,41.03,41.94,41.59,43.53,43.28,42.91,42.97,44.19,44.62,45.25,46.62,48.16,48.22,48.5,49.25,49.28,48.09,49.41,49.34,49.53,50.31,50.41,50.31,50.03,49.84,49.66,49.34,49.28,48.31,46.25,43.19,42.44,41.16,40.31,40.5,41.09,40.66,40.78,40.47,39.38,38.75,38.19,37.56,36.06,35.53,36.06,35.19,37.16,38.09,37.91,38.97,39.84,39.41,38.69,37.91,35.78,33.16,32.34,30.31,28.81,28.44,27.81,27.66,27.16,26.84,26.38,25.91,27.47,28.72,30.69,34.56,35.94,37.94,38.38,37.47,35.12,33.56,31.12,30.34,27.81,28.62,27.91,29.09,30.34,31.44,31.91,33.09,34.5,33.88,33.84,35.16,34.34,33.91,34.16,34.59,35.19,36.91,37.59,39.72,39.16,39.97,39.31,38.5,39.16,39.0,39.81,40.0,38.53,37.81,36.44,36.19,35.75,36.78,38.19,39.41,41.25,42.31,43.34,45.56,45.81,46.03,47.47,47.12,47.06,48.81,49.19,48.34,48.66,49.06,49.56,49.62,50.62,50.62,49.56,50.56,50.38,51.25,50.66,50.19,49.94,48.69,47.09,48.78,46.41,46.5,46.16,45.53,44.19,43.94,42.56,40.56,39.31,37.34,37.19,37.34,36.94,38.75,37.75,38.38,38.31,37.16,36.5,34.56,33.25,30.66,30.81,31.31,32.91,34.94,38.56,40.12,40.5,40.0,37.72,35.19,31.88,31.03,29.53,30.22,30.91,32.56,33.12,34.06,33.12,32.09,32.28,32.53,33.06,33.53,34.78,34.94,35.56,36.06,36.12,36.72,37.66,36.72,37.06,36.56,36.5,37.5,37.03,37.53,37.81,37.31,37.69,36.94,36.47,36.53,35.59,37.34,38.44,38.53,40.81,41.81,42.66,42.62,42.75,43.97,44.16,43.59,45.12,44.25,42.91,41.34,39.06,37.09,35.44,34.03,32.12,30.62,30.81,28.69,28.66,29.81,29.94,29.91,31.12,31.28,32.16,34.0,35.59,37.28,39.28,41.31,43.16,44.09,45.16,43.91,43.31,42.53,41.91,40.22,39.38,38.09,34.66,31.81,31.06,29.81,29.69,30.75,32.09,33.56,34.44,36.44,37.84,39.0,40.16,40.75,39.38,37.84,36.97,36.56,36.91,37.28,38.78,37.34,37.56,35.59,33.16,30.31,26.69,23.97,22.38,20.09,21.12,22.44,24.81,29.44,32.75,36.62,41.0,40.91,41.91,41.06,38.19,36.75,34.94,32.28,30.88,30.25,30.53,31.0,32.66,33.72,34.59,34.91,34.69,33.0,32.09,30.72,31.69,32.31,34.72,36.28,37.81,38.38,37.41,35.94,34.91,32.16,30.78,28.28,27.72,26.88,26.94,26.5,26.12,26.31,26.12,26.41,26.38,27.28,28.38,30.25,31.22,32.81,34.0,35.06,35.75,36.88,35.5,35.12,34.06,32.81,31.84,31.16,31.41,31.81,33.91,35.53,37.31,39.41,40.66,41.81,41.16,40.44,40.16,39.47,38.56,38.66,39.78,41.09,42.06,42.75,43.44,42.91,41.88,39.91,38.25,35.97,33.69,31.91,30.19,29.0,29.0,28.0,28.03,28.0,28.28,29.78,30.38,32.38,33.16,33.59,32.5,31.38,29.0,27.12,25.12,25.81,26.16,26.75,28.88,29.69,30.62,31.38,31.28,31.06,30.81,31.53,31.75,32.25,33.34,35.31,36.88,37.78,39.25,38.66,39.19,39.38,38.81,38.44,38.03,36.72,36.94,35.31,34.12,33.16,31.72,31.5,30.03,28.84,29.0,28.0,27.5,28.66,29.16,31.25,33.19,34.75,35.84,36.22,35.94,35.28,33.25,34.16,34.69,34.62,36.5,37.25,36.91,37.22,37.38,36.31,35.84,35.59,35.31,35.28,35.75,35.56,36.22,37.34,38.25,39.41,40.56,42.81,43.34,-10.69,-9.78,-8.78,-5.97,-6.91,-6.59:39.22,39.41,39.16,40.03,42.03,42.31,45.06,46.53,46.59,47.53,45.75,44.25,42.62,39.44,37.72,36.34,34.28,34.06,33.81,34.59,36.38,39.0,43.44,45.62,46.91,48.0,47.16,46.19,47.81,47.31,48.31,47.47,48.62,48.09,47.75,47.88,48.88,50.66,52.94,53.62,54.81,54.53,53.47,51.0,48.97,46.06,44.56,43.03,41.44,41.16,39.75,39.16,38.69,36.66,35.12,32.53,28.75,25.81,24.78,24.0,25.59,28.34,29.81,31.41,32.22,32.97,34.62,35.31,37.09,38.97,40.88,41.06,40.66,39.19,38.44,35.72,34.56,34.22,33.62,33.88,33.25,32.84,33.94,34.38,36.38,37.66,40.72,42.31,44.0,46.19,48.16,48.44,49.53,50.03,49.03,48.38,47.75,46.69,45.66,44.5,44.03,41.91,41.41,40.25,39.12,38.44,36.78,36.0,34.69,34.56,34.59,32.72,32.97,31.72,30.88,30.41,32.34,34.03,35.78,37.81,39.44,40.03,40.91,41.06,40.66,40.34,38.69,38.56,38.34,38.41,40.78,41.94,41.94,43.12,41.69,41.03,37.56,34.19,32.53,30.0,30.38,33.41,36.34,39.69,44.31,46.66,49.25,50.12,48.91,47.44,43.72,40.31,36.34,33.16,31.03,29.66,28.97,28.19,28.91,28.28,28.69,28.56,28.28,28.34,28.5,28.91,30.78,30.44,31.75,32.16,33.34,34.31,34.25,34.56,36.91,36.22,39.72,41.16,43.56,46.16,48.0,49.31,49.78,50.56,49.81,47.97,47.19,44.66,43.69,42.31,41.34,39.91,38.94,39.16,38.66,39.88,40.72,40.84,43.62,44.25,43.97,45.81,46.53,46.03,46.75,46.62,46.62,46.41,47.0,47.44,46.78,48.94,48.75,47.41,45.62,43.62,41.84,40.25,39.34,39.19,39.78,39.75,41.34,40.88,40.47,41.16,40.84,42.16,44.06,46.91,49.91,52.09,54.09,55.28,55.81,55.66,54.62,52.34,49.19,45.75,43.03,38.84,37.19,36.81,36.72,37.94,39.31,41.78,43.81,45.41,47.31,47.19,48.03,47.47,46.62,46.38,46.25,46.56,46.12,44.38,42.5,38.91,36.56,34.12,31.66,31.5,31.81,32.56,34.66,38.44,42.31,45.72,47.69,49.69,49.19,47.78,45.94,44.56,43.84,43.09,42.22,41.78,39.84,37.69,36.81,34.81,33.28,32.84,31.16,32.31,31.78,32.56,33.66,34.53,34.31,32.38,32.16,31.09,30.5,31.06,30.75,31.19,31.34,31.62,33.78,34.38,35.88,37.06,38.06,38.22,38.16,38.44,39.16,39.81,41.41,42.31,42.94,44.22,44.62,44.5,46.16,47.47,48.41,49.22,50.41,50.78,49.94,50.06,48.53,47.38,46.81,44.66,44.91,44.94,45.34,45.44,46.75,47.34,48.97,50.34,53.06,54.81,54.66,55.62,52.78,51.22,48.0,45.47,44.31,42.94,42.91,41.84,40.5,39.44,37.09,35.81,34.28,34.53,34.62,33.66,35.0,34.06,34.91,35.0,35.31,36.59,37.75,39.81,41.44,43.88,45.75,47.59,49.16,49.0,51.06,52.56,53.94,57.12,57.69,58.97,59.12,58.31,57.09,55.84,54.12,53.38,52.25,51.5,49.84,49.16,49.25,48.78,47.28,47.72,48.72,47.31,47.62,46.94,45.38,44.91,43.28,42.0,42.06,40.84,40.19,40.53,41.19,40.56,41.44,42.56,42.91,43.69,44.41,43.38,42.78,40.88,38.94,38.25,39.06,39.25,40.44,41.72,41.41,40.72,40.78,39.88,41.03,41.94,41.59,43.53,43.28,42.91,42.97,44.19,44.62,45.25,46.62,48.16,48.22,48.5,49.25,49.28,48.09,49.41,49.34,49.53,50.31,50.41,50.31,50.03,49.84,49.66,49.34,49.28,48.31,46.25,43.19,42.44,41.16,40.31,40.5,41.09,40.66,40.78,40.47,39.38,38.75,38.19,37.56,36.06,35.53,36.06,35.19,37.16,38.09,37.91,38.97,39.84,39.41,38.69,37.91,35.78,33.16,32.34,30.31,28.81,28.44,27.81,27.66,27.16,26.84,26.38,25.91,27.47,28.72,30.69,34.56,35.94,37.94,38.38,37.47,35.12,33.56,31.12,30.34,27.81,28.62,27.91,29.09,30.34,31.44,31.91,33.09,34.5,33.88,33.84,35.16,34.34,33.91,34.16,34.59,35.19,36.91,37.59,39.72,39.16,39.97,39.31,38.5,39.16,39.0,39.81,40.0,38.53,37.81,36.44,36.19,35.75,36.78,38.19,39.41,41.25,42.31,43.34,45.56,45.81,46.03,47.47,47.12,47.06,48.81,49.19,48.34,48.66,49.06,49.56,49.62,50.62,50.62,49.56,50.56,50.38,51.25,50.66,50.19,49.94,48.69,47.09,48.78,46.41,46.5,46.16,45.53,44.19,43.94,42.56,40.56,39.31,37.34,37.19,37.34,36.94,38.75,37.75,38.38,38.31,37.16,36.5,34.56,33.25,30.66,30.81,31.31,32.91,34.94,38.56,40.12,40.5,40.0,37.72,35.19,31.88,31.03,29.53,30.22,30.91,32.56,33.12,34.06,33.12,32.09,32.28,32.53,33.06,33.53,34.78,34.94,35.56,36.06,36.12,36.72,37.66,36.72,37.06,36.56,36.5,37.5,37.03,37.53,37.81,37.31,37.69,36.94,36.47,36.53,35.59,37.34,38.44,38.53,40.81,41.81,42.66,42.62,42.75,43.97,44.16,43.59,45.12,44.25,42.91,41.34,39.06,37.09,35.44,34.03,32.12,30.62,30.81,28.69,28.66,29.81,29.94,29.91,31.12,31.28,32.16,34.0,35.59,37.28,39.28,41.31,43.16,44.09,45.16,43.91,43.31,42.53,41.91,40.22,39.38,38.09,34.66,31.81,31.06,29.81,29.69,30.75,32.09,33.56,34.44,36.44,37.84,39.0,40.16,40.75,39.38,37.84,36.97,36.56,36.91,37.28,38.78,37.34,37.56,35.59,33.16,30.31,26.69,23.97,22.38,20.09,21.12,22.44,24.81,29.44,32.75,36.62,41.0,40.91,41.91,41.06,38.19,36.75,34.94,32.28,30.88,30.25,30.53,31.0,32.66,33.72,34.59,34.91,34.69,33.0,32.09,30.72,31.69,32.31,34.72,36.28,37.81,38.38,37.41,35.94,34.91,32.16,30.78,28.28,27.72,26.88,26.94,26.5,26.12,26.31,26.12,26.41,26.38,27.28,28.38,30.25,31.22,32.81,34.0,35.06,35.75,36.88,35.5,35.12,34.06,32.81,31.84,31.16,31.41,31.81,33.91,35.53,37.31,39.41,40.66,41.81,41.16,40.44,40.16,39.47,38.56,38.66,39.78,41.09,42.06,42.75,43.44,42.91,41.88,39.91,38.25,35.97,33.69,31.91,30.19,29.0,29.0,28.0,28.03,28.0,28.28,29.78,30.38,32.38,33.16,33.59,32.5,31.38,29.0,27.12,25.12,25.81,26.16,26.75,28.88,29.69,30.62,31.38,31.28,31.06,30.81,31.53,31.75,32.25,33.34,35.31,36.88,37.78,39.25,38.66,39.19,39.38,38.81,38.44,38.03,36.72,36.94,35.31,34.12,33.16,31.72,31.5,30.03,28.84,29.0,28.0,27.5,28.66,29.16,31.25,33.19,34.75,35.84,36.22,35.94,35.28,33.25,34.16,34.69,34.62,36.5,37.25,36.91,37.22,37.38,36.31,35.84,35.59,35.31,35.28,35.75,35.56,36.22,37.34,38.25,39.41,40.56,42.81,43.34,-10.69,-9.78,-8.78,-5.97,-6.91,-6.59,-7.5,-9.19,-10.31,-10.91,-11.25,-10.38:45.06,46.53,46.59,47.53,45.75,44.25,42.62,39.44,37.72,36.34,34.28,34.06,33.81,34.59,36.38,39.0,43.44,45.62,46.91,48.0,47.16,46.19,47.81,47.31,48.31,47.47,48.62,48.09,47.75,47.88,48.88,50.66,52.94,53.62,54.81,54.53,53.47,51.0,48.97,46.06,44.56,43.03,41.44,41.16,39.75,39.16,38.69,36.66,35.12,32.53,28.75,25.81,24.78,24.0,25.59,28.34,29.81,31.41,32.22,32.97,34.62,35.31,37.09,38.97,40.88,41.06,40.66,39.19,38.44,35.72,34.56,34.22,33.62,33.88,33.25,32.84,33.94,34.38,36.38,37.66,40.72,42.31,44.0,46.19,48.16,48.44,49.53,50.03,49.03,48.38,47.75,46.69,45.66,44.5,44.03,41.91,41.41,40.25,39.12,38.44,36.78,36.0,34.69,34.56,34.59,32.72,32.97,31.72,30.88,30.41,32.34,34.03,35.78,37.81,39.44,40.03,40.91,41.06,40.66,40.34,38.69,38.56,38.34,38.41,40.78,41.94,41.94,43.12,41.69,41.03,37.56,34.19,32.53,30.0,30.38,33.41,36.34,39.69,44.31,46.66,49.25,50.12,48.91,47.44,43.72,40.31,36.34,33.16,31.03,29.66,28.97,28.19,28.91,28.28,28.69,28.56,28.28,28.34,28.5,28.91,30.78,30.44,31.75,32.16,33.34,34.31,34.25,34.56,36.91,36.22,39.72,41.16,43.56,46.16,48.0,49.31,49.78,50.56,49.81,47.97,47.19,44.66,43.69,42.31,41.34,39.91,38.94,39.16,38.66,39.88,40.72,40.84,43.62,44.25,43.97,45.81,46.53,46.03,46.75,46.62,46.62,46.41,47.0,47.44,46.78,48.94,48.75,47.41,45.62,43.62,41.84,40.25,39.34,39.19,39.78,39.75,41.34,40.88,40.47,41.16,40.84,42.16,44.06,46.91,49.91,52.09,54.09,55.28,55.81,55.66,54.62,52.34,49.19,45.75,43.03,38.84,37.19,36.81,36.72,37.94,39.31,41.78,43.81,45.41,47.31,47.19,48.03,47.47,46.62,46.38,46.25,46.56,46.12,44.38,42.5,38.91,36.56,34.12,31.66,31.5,31.81,32.56,34.66,38.44,42.31,45.72,47.69,49.69,49.19,47.78,45.94,44.56,43.84,43.09,42.22,41.78,39.84,37.69,36.81,34.81,33.28,32.84,31.16,32.31,31.78,32.56,33.66,34.53,34.31,32.38,32.16,31.09,30.5,31.06,30.75,31.19,31.34,31.62,33.78,34.38,35.88,37.06,38.06,38.22,38.16,38.44,39.16,39.81,41.41,42.31,42.94,44.22,44.62,44.5,46.16,47.47,48.41,49.22,50.41,50.78,49.94,50.06,48.53,47.38,46.81,44.66,44.91,44.94,45.34,45.44,46.75,47.34,48.97,50.34,53.06,54.81,54.66,55.62,52.78,51.22,48.0,45.47,44.31,42.94,42.91,41.84,40.5,39.44,37.09,35.81,34.28,34.53,34.62,33.66,35.0,34.06,34.91,35.0,35.31,36.59,37.75,39.81,41.44,43.88,45.75,47.59,49.16,49.0,51.06,52.56,53.94,57.12,57.69,58.97,59.12,58.31,57.09,55.84,54.12,53.38,52.25,51.5,49.84,49.16,49.25,48.78,47.28,47.72,48.72,47.31,47.62,46.94,45.38,44.91,43.28,42.0,42.06,40.84,40.19,40.53,41.19,40.56,41.44,42.56,42.91,43.69,44.41,43.38,42.78,40.88,38.94,38.25,39.06,39.25,40.44,41.72,41.41,40.72,40.78,39.88,41.03,41.94,41.59,43.53,43.28,42.91,42.97,44.19,44.62,45.25,46.62,48.16,48.22,48.5,49.25,49.28,48.09,49.41,49.34,49.53,50.31,50.41,50.31,50.03,49.84,49.66,49.34,49.28,48.31,46.25,43.19,42.44,41.16,40.31,40.5,41.09,40.66,40.78,40.47,39.38,38.75,38.19,37.56,36.06,35.53,36.06,35.19,37.16,38.09,37.91,38.97,39.84,39.41,38.69,37.91,35.78,33.16,32.34,30.31,28.81,28.44,27.81,27.66,27.16,26.84,26.38,25.91,27.47,28.72,30.69,34.56,35.94,37.94,38.38,37.47,35.12,33.56,31.12,30.34,27.81,28.62,27.91,29.09,30.34,31.44,31.91,33.09,34.5,33.88,33.84,35.16,34.34,33.91,34.16,34.59,35.19,36.91,37.59,39.72,39.16,39.97,39.31,38.5,39.16,39.0,39.81,40.0,38.53,37.81,36.44,36.19,35.75,36.78,38.19,39.41,41.25,42.31,43.34,45.56,45.81,46.03,47.47,47.12,47.06,48.81,49.19,48.34,48.66,49.06,49.56,49.62,50.62,50.62,49.56,50.56,50.38,51.25,50.66,50.19,49.94,48.69,47.09,48.78,46.41,46.5,46.16,45.53,44.19,43.94,42.56,40.56,39.31,37.34,37.19,37.34,36.94,38.75,37.75,38.38,38.31,37.16,36.5,34.56,33.25,30.66,30.81,31.31,32.91,34.94,38.56,40.12,40.5,40.0,37.72,35.19,31.88,31.03,29.53,30.22,30.91,32.56,33.12,34.06,33.12,32.09,32.28,32.53,33.06,33.53,34.78,34.94,35.56,36.06,36.12,36.72,37.66,36.72,37.06,36.56,36.5,37.5,37.03,37.53,37.81,37.31,37.69,36.94,36.47,36.53,35.59,37.34,38.44,38.53,40.81,41.81,42.66,42.62,42.75,43.97,44.16,43.59,45.12,44.25,42.91,41.34,39.06,37.09,35.44,34.03,32.12,30.62,30.81,28.69,28.66,29.81,29.94,29.91,31.12,31.28,32.16,34.0,35.59,37.28,39.28,41.31,43.16,44.09,45.16,43.91,43.31,42.53,41.91,40.22,39.38,38.09,34.66,31.81,31.06,29.81,29.69,30.75,32.09,33.56,34.44,36.44,37.84,39.0,40.16,40.75,39.38,37.84,36.97,36.56,36.91,37.28,38.78,37.34,37.56,35.59,33.16,30.31,26.69,23.97,22.38,20.09,21.12,22.44,24.81,29.44,32.75,36.62,41.0,40.91,41.91,41.06,38.19,36.75,34.94,32.28,30.88,30.25,30.53,31.0,32.66,33.72,34.59,34.91,34.69,33.0,32.09,30.72,31.69,32.31,34.72,36.28,37.81,38.38,37.41,35.94,34.91,32.16,30.78,28.28,27.72,26.88,26.94,26.5,26.12,26.31,26.12,26.41,26.38,27.28,28.38,30.25,31.22,32.81,34.0,35.06,35.75,36.88,35.5,35.12,34.06,32.81,31.84,31.16,31.41,31.81,33.91,35.53,37.31,39.41,40.66,41.81,41.16,40.44,40.16,39.47,38.56,38.66,39.78,41.09,42.06,42.75,43.44,42.91,41.88,39.91,38.25,35.97,33.69,31.91,30.19,29.0,29.0,28.0,28.03,28.0,28.28,29.78,30.38,32.38,33.16,33.59,32.5,31.38,29.0,27.12,25.12,25.81,26.16,26.75,28.88,29.69,30.62,31.38,31.28,31.06,30.81,31.53,31.75,32.25,33.34,35.31,36.88,37.78,39.25,38.66,39.19,39.38,38.81,38.44,38.03,36.72,36.94,35.31,34.12,33.16,31.72,31.5,30.03,28.84,29.0,28.0,27.5,28.66,29.16,31.25,33.19,34.75,35.84,36.22,35.94,35.28,33.25,34.16,34.69,34.62,36.5,37.25,36.91,37.22,37.38,36.31,35.84,35.59,35.31,35.28,35.75,35.56,36.22,37.34,38.25,39.41,40.56,42.81,43.34,-10.69,-9.78,-8.78,-5.97,-6.91,-6.59,-7.5,-9.19,-10.31,-10.91,-11.25,-10.38,-11.03,-10.12,-10.66,-10.44,-9.28,-9.59:42.62,39.44,37.72,36.34,34.28,34.06,33.81,34.59,36.38,39.0,43.44,45.62,46.91,48.0,47.16,46.19,47.81,47.31,48.31,47.47,48.62,48.09,47.75,47.88,48.88,50.66,52.94,53.62,54.81,54.53,53.47,51.0,48.97,46.06,44.56,43.03,41.44,41.16,39.75,39.16,38.69,36.66,35.12,32.53,28.75,25.81,24.78,24.0,25.59,28.34,29.81,31.41,32.22,32.97,34.62,35.31,37.09,38.97,40.88,41.06,40.66,39.19,38.44,35.72,34.56,34.22,33.62,33.88,33.25,32.84,33.94,34.38,36.38,37.66,40.72,42.31,44.0,46.19,48.16,48.44,49.53,50.03,49.03,48.38,47.75,46.69,45.66,44.5,44.03,41.91,41.41,40.25,39.12,38.44,36.78,36.0,34.69,34.56,34.59,32.72,32.97,31.72,30.88,30.41,32.34,34.03,35.78,37.81,39.44,40.03,40.91,41.06,40.66,40.34,38.69,38.56,38.34,38.41,40.78,41.94,41.94,43.12,41.69,41.03,37.56,34.19,32.53,30.0,30.38,33.41,36.34,39.69,44.31,46.66,49.25,50.12,48.91,47.44,43.72,40.31,36.34,33.16,31.03,29.66,28.97,28.19,28.91,28.28,28.69,28.56,28.28,28.34,28.5,28.91,30.78,30.44,31.75,32.16,33.34,34.31,34.25,34.56,36.91,36.22,39.72,41.16,43.56,46.16,48.0,49.31,49.78,50.56,49.81,47.97,47.19,44.66,43.69,42.31,41.34,39.91,38.94,39.16,38.66,39.88,40.72,40.84,43.62,44.25,43.97,45.81,46.53,46.03,46.75,46.62,46.62,46.41,47.0,47.44,46.78,48.94,48.75,47.41,45.62,43.62,41.84,40.25,39.34,39.19,39.78,39.75,41.34,40.88,40.47,41.16,40.84,42.16,44.06,46.91,49.91,52.09,54.09,55.28,55.81,55.66,54.62,52.34,49.19,45.75,43.03,38.84,37.19,36.81,36.72,37.94,39.31,41.78,43.81,45.41,47.31,47.19,48.03,47.47,46.62,46.38,46.25,46.56,46.12,44.38,42.5,38.91,36.56,34.12,31.66,31.5,31.81,32.56,34.66,38.44,42.31,45.72,47.69,49.69,49.19,47.78,45.94,44.56,43.84,43.09,42.22,41.78,39.84,37.69,36.81,34.81,33.28,32.84,31.16,32.31,31.78,32.56,33.66,34.53,34.31,32.38,32.16,31.09,30.5,31.06,30.75,31.19,31.34,31.62,33.78,34.38,35.88,37.06,38.06,38.22,38.16,38.44,39.16,39.81,41.41,42.31,42.94,44.22,44.62,44.5,46.16,47.47,48.41,49.22,50.41,50.78,49.94,50.06,48.53,47.38,46.81,44.66,44.91,44.94,45.34,45.44,46.75,47.34,48.97,50.34,53.06,54.81,54.66,55.62,52.78,51.22,48.0,45.47,44.31,42.94,42.91,41.84,40.5,39.44,37.09,35.81,34.28,34.53,34.62,33.66,35.0,34.06,34.91,35.0,35.31,36.59,37.75,39.81,41.44,43.88,45.75,47.59,49.16,49.0,51.06,52.56,53.94,57.12,57.69,58.97,59.12,58.31,57.09,55.84,54.12,53.38,52.25,51.5,49.84,49.16,49.25,48.78,47.28,47.72,48.72,47.31,47.62,46.94,45.38,44.91,43.28,42.0,42.06,40.84,40.19,40.53,41.19,40.56,41.44,42.56,42.91,43.69,44.41,43.38,42.78,40.88,38.94,38.25,39.06,39.25,40.44,41.72,41.41,40.72,40.78,39.88,41.03,41.94,41.59,43.53,43.28,42.91,42.97,44.19,44.62,45.25,46.62,48.16,48.22,48.5,49.25,49.28,48.09,49.41,49.34,49.53,50.31,50.41,50.31,50.03,49.84,49.66,49.34,49.28,48.31,46.25,43.19,42.44,41.16,40.31,40.5,41.09,40.66,40.78,40.47,39.38,38.75,38.19,37.56,36.06,35.53,36.06,35.19,37.16,38.09,37.91,38.97,39.84,39.41,38.69,37.91,35.78,33.16,32.34,30.31,28.81,28.44,27.81,27.66,27.16,26.84,26.38,25.91,27.47,28.72,30.69,34.56,35.94,37.94,38.38,37.47,35.12,33.56,31.12,30.34,27.81,28.62,27.91,29.09,30.34,31.44,31.91,33.09,34.5,33.88,33.84,35.16,34.34,33.91,34.16,34.59,35.19,36.91,37.59,39.72,39.16,39.97,39.31,38.5,39.16,39.0,39.81,40.0,38.53,37.81,36.44,36.19,35.75,36.78,38.19,39.41,41.25,42.31,43.34,45.56,45.81,46.03,47.47,47.12,47.06,48.81,49.19,48.34,48.66,49.06,49.56,49.62,50.62,50.62,49.56,50.56,50.38,51.25,50.66,50.19,49.94,48.69,47.09,48.78,46.41,46.5,46.16,45.53,44.19,43.94,42.56,40.56,39.31,37.34,37.19,37.34,36.94,38.75,37.75,38.38,38.31,37.16,36.5,34.56,33.25,30.66,30.81,31.31,32.91,34.94,38.56,40.12,40.5,40.0,37.72,35.19,31.88,31.03,29.53,30.22,30.91,32.56,33.12,34.06,33.12,32.09,32.28,32.53,33.06,33.53,34.78,34.94,35.56,36.06,36.12,36.72,37.66,36.72,37.06,36.56,36.5,37.5,37.03,37.53,37.81,37.31,37.69,36.94,36.47,36.53,35.59,37.34,38.44,38.53,40.81,41.81,42.66,42.62,42.75,43.97,44.16,43.59,45.12,44.25,42.91,41.34,39.06,37.09,35.44,34.03,32.12,30.62,30.81,28.69,28.66,29.81,29.94,29.91,31.12,31.28,32.16,34.0,35.59,37.28,39.28,41.31,43.16,44.09,45.16,43.91,43.31,42.53,41.91,40.22,39.38,38.09,34.66,31.81,31.06,29.81,29.69,30.75,32.09,33.56,34.44,36.44,37.84,39.0,40.16,40.75,39.38,37.84,36.97,36.56,36.91,37.28,38.78,37.34,37.56,35.59,33.16,30.31,26.69,23.97,22.38,20.09,21.12,22.44,24.81,29.44,32.75,36.62,41.0,40.91,41.91,41.06,38.19,36.75,34.94,32.28,30.88,30.25,30.53,31.0,32.66,33.72,34.59,34.91,34.69,33.0,32.09,30.72,31.69,32.31,34.72,36.28,37.81,38.38,37.41,35.94,34.91,32.16,30.78,28.28,27.72,26.88,26.94,26.5,26.12,26.31,26.12,26.41,26.38,27.28,28.38,30.25,31.22,32.81,34.0,35.06,35.75,36.88,35.5,35.12,34.06,32.81,31.84,31.16,31.41,31.81,33.91,35.53,37.31,39.41,40.66,41.81,41.16,40.44,40.16,39.47,38.56,38.66,39.78,41.09,42.06,42.75,43.44,42.91,41.88,39.91,38.25,35.97,33.69,31.91,30.19,29.0,29.0,28.0,28.03,28.0,28.28,29.78,30.38,32.38,33.16,33.59,32.5,31.38,29.0,27.12,25.12,25.81,26.16,26.75,28.88,29.69,30.62,31.38,31.28,31.06,30.81,31.53,31.75,32.25,33.34,35.31,36.88,37.78,39.25,38.66,39.19,39.38,38.81,38.44,38.03,36.72,36.94,35.31,34.12,33.16,31.72,31.5,30.03,28.84,29.0,28.0,27.5,28.66,29.16,31.25,33.19,34.75,35.84,36.22,35.94,35.28,33.25,34.16,34.69,34.62,36.5,37.25,36.91,37.22,37.38,36.31,35.84,35.59,35.31,35.28,35.75,35.56,36.22,37.34,38.25,39.41,40.56,42.81,43.34,-10.69,-9.78,-8.78,-5.97,-6.91,-6.59,-7.5,-9.19,-10.31,-10.91,-11.25,-10.38,-11.03,-10.12,-10.66,-10.44,-9.28,-9.59,-8.03,-6.22,-4.72,-4.06,-4.84,-5.16:33.81,34.59,36.38,39.0,43.44,45.62,46.91,48.0,47.16,46.19,47.81,47.31,48.31,47.47,48.62,48.09,47.75,47.88,48.88,50.66,52.94,53.62,54.81,54.53,53.47,51.0,48.97,46.06,44.56,43.03,41.44,41.16,39.75,39.16,38.69,36.66,35.12,32.53,28.75,25.81,24.78,24.0,25.59,28.34,29.81,31.41,32.22,32.97,34.62,35.31,37.09,38.97,40.88,41.06,40.66,39.19,38.44,35.72,34.56,34.22,33.62,33.88,33.25,32.84,33.94,34.38,36.38,37.66,40.72,42.31,44.0,46.19,48.16,48.44,49.53,50.03,49.03,48.38,47.75,46.69,45.66,44.5,44.03,41.91,41.41,40.25,39.12,38.44,36.78,36.0,34.69,34.56,34.59,32.72,32.97,31.72,30.88,30.41,32.34,34.03,35.78,37.81,39.44,40.03,40.91,41.06,40.66,40.34,38.69,38.56,38.34,38.41,40.78,41.94,41.94,43.12,41.69,41.03,37.56,34.19,32.53,30.0,30.38,33.41,36.34,39.69,44.31,46.66,49.25,50.12,48.91,47.44,43.72,40.31,36.34,33.16,31.03,29.66,28.97,28.19,28.91,28.28,28.69,28.56,28.28,28.34,28.5,28.91,30.78,30.44,31.75,32.16,33.34,34.31,34.25,34.56,36.91,36.22,39.72,41.16,43.56,46.16,48.0,49.31,49.78,50.56,49.81,47.97,47.19,44.66,43.69,42.31,41.34,39.91,38.94,39.16,38.66,39.88,40.72,40.84,43.62,44.25,43.97,45.81,46.53,46.03,46.75,46.62,46.62,46.41,47.0,47.44,46.78,48.94,48.75,47.41,45.62,43.62,41.84,40.25,39.34,39.19,39.78,39.75,41.34,40.88,40.47,41.16,40.84,42.16,44.06,46.91,49.91,52.09,54.09,55.28,55.81,55.66,54.62,52.34,49.19,45.75,43.03,38.84,37.19,36.81,36.72,37.94,39.31,41.78,43.81,45.41,47.31,47.19,48.03,47.47,46.62,46.38,46.25,46.56,46.12,44.38,42.5,38.91,36.56,34.12,31.66,31.5,31.81,32.56,34.66,38.44,42.31,45.72,47.69,49.69,49.19,47.78,45.94,44.56,43.84,43.09,42.22,41.78,39.84,37.69,36.81,34.81,33.28,32.84,31.16,32.31,31.78,32.56,33.66,34.53,34.31,32.38,32.16,31.09,30.5,31.06,30.75,31.19,31.34,31.62,33.78,34.38,35.88,37.06,38.06,38.22,38.16,38.44,39.16,39.81,41.41,42.31,42.94,44.22,44.62,44.5,46.16,47.47,48.41,49.22,50.41,50.78,49.94,50.06,48.53,47.38,46.81,44.66,44.91,44.94,45.34,45.44,46.75,47.34,48.97,50.34,53.06,54.81,54.66,55.62,52.78,51.22,48.0,45.47,44.31,42.94,42.91,41.84,40.5,39.44,37.09,35.81,34.28,34.53,34.62,33.66,35.0,34.06,34.91,35.0,35.31,36.59,37.75,39.81,41.44,43.88,45.75,47.59,49.16,49.0,51.06,52.56,53.94,57.12,57.69,58.97,59.12,58.31,57.09,55.84,54.12,53.38,52.25,51.5,49.84,49.16,49.25,48.78,47.28,47.72,48.72,47.31,47.62,46.94,45.38,44.91,43.28,42.0,42.06,40.84,40.19,40.53,41.19,40.56,41.44,42.56,42.91,43.69,44.41,43.38,42.78,40.88,38.94,38.25,39.06,39.25,40.44,41.72,41.41,40.72,40.78,39.88,41.03,41.94,41.59,43.53,43.28,42.91,42.97,44.19,44.62,45.25,46.62,48.16,48.22,48.5,49.25,49.28,48.09,49.41,49.34,49.53,50.31,50.41,50.31,50.03,49.84,49.66,49.34,49.28,48.31,46.25,43.19,42.44,41.16,40.31,40.5,41.09,40.66,40.78,40.47,39.38,38.75,38.19,37.56,36.06,35.53,36.06,35.19,37.16,38.09,37.91,38.97,39.84,39.41,38.69,37.91,35.78,33.16,32.34,30.31,28.81,28.44,27.81,27.66,27.16,26.84,26.38,25.91,27.47,28.72,30.69,34.56,35.94,37.94,38.38,37.47,35.12,33.56,31.12,30.34,27.81,28.62,27.91,29.09,30.34,31.44,31.91,33.09,34.5,33.88,33.84,35.16,34.34,33.91,34.16,34.59,35.19,36.91,37.59,39.72,39.16,39.97,39.31,38.5,39.16,39.0,39.81,40.0,38.53,37.81,36.44,36.19,35.75,36.78,38.19,39.41,41.25,42.31,43.34,45.56,45.81,46.03,47.47,47.12,47.06,48.81,49.19,48.34,48.66,49.06,49.56,49.62,50.62,50.62,49.56,50.56,50.38,51.25,50.66,50.19,49.94,48.69,47.09,48.78,46.41,46.5,46.16,45.53,44.19,43.94,42.56,40.56,39.31,37.34,37.19,37.34,36.94,38.75,37.75,38.38,38.31,37.16,36.5,34.56,33.25,30.66,30.81,31.31,32.91,34.94,38.56,40.12,40.5,40.0,37.72,35.19,31.88,31.03,29.53,30.22,30.91,32.56,33.12,34.06,33.12,32.09,32.28,32.53,33.06,33.53,34.78,34.94,35.56,36.06,36.12,36.72,37.66,36.72,37.06,36.56,36.5,37.5,37.03,37.53,37.81,37.31,37.69,36.94,36.47,36.53,35.59,37.34,38.44,38.53,40.81,41.81,42.66,42.62,42.75,43.97,44.16,43.59,45.12,44.25,42.91,41.34,39.06,37.09,35.44,34.03,32.12,30.62,30.81,28.69,28.66,29.81,29.94,29.91,31.12,31.28,32.16,34.0,35.59,37.28,39.28,41.31,43.16,44.09,45.16,43.91,43.31,42.53,41.91,40.22,39.38,38.09,34.66,31.81,31.06,29.81,29.69,30.75,32.09,33.56,34.44,36.44,37.84,39.0,40.16,40.75,39.38,37.84,36.97,36.56,36.91,37.28,38.78,37.34,37.56,35.59,33.16,30.31,26.69,23.97,22.38,20.09,21.12,22.44,24.81,29.44,32.75,36.62,41.0,40.91,41.91,41.06,38.19,36.75,34.94,32.28,30.88,30.25,30.53,31.0,32.66,33.72,34.59,34.91,34.69,33.0,32.09,30.72,31.69,32.31,34.72,36.28,37.81,38.38,37.41,35.94,34.91,32.16,30.78,28.28,27.72,26.88,26.94,26.5,26.12,26.31,26.12,26.41,26.38,27.28,28.38,30.25,31.22,32.81,34.0,35.06,35.75,36.88,35.5,35.12,34.06,32.81,31.84,31.16,31.41,31.81,33.91,35.53,37.31,39.41,40.66,41.81,41.16,40.44,40.16,39.47,38.56,38.66,39.78,41.09,42.06,42.75,43.44,42.91,41.88,39.91,38.25,35.97,33.69,31.91,30.19,29.0,29.0,28.0,28.03,28.0,28.28,29.78,30.38,32.38,33.16,33.59,32.5,31.38,29.0,27.12,25.12,25.81,26.16,26.75,28.88,29.69,30.62,31.38,31.28,31.06,30.81,31.53,31.75,32.25,33.34,35.31,36.88,37.78,39.25,38.66,39.19,39.38,38.81,38.44,38.03,36.72,36.94,35.31,34.12,33.16,31.72,31.5,30.03,28.84,29.0,28.0,27.5,28.66,29.16,31.25,33.19,34.75,35.84,36.22,35.94,35.28,33.25,34.16,34.69,34.62,36.5,37.25,36.91,37.22,37.38,36.31,35.84,35.59,35.31,35.28,35.75,35.56,36.22,37.34,38.25,39.41,40.56,42.81,43.34,-10.69,-9.78,-8.78,-5.97,-6.91,-6.59,-7.5,-9.19,-10.31,-10.91,-11.25,-10.38,-11.03,-10.12,-10.66,-10.44,-9.28,-9.59,-8.03,-6.22,-4.72,-4.06,-4.84,-5.16,-7.09,-9.16,-10.5,-12.16,-14.06,-14.12:negativity
23.84,25.78,25.38,25.88,25.72,24.84,24.03,22.81,21.88,20.59,19.53,18.88,19.03,19.53,20.75,24.03,26.19,29.81,31.53,32.5,34.56,33.84,33.12,30.59,29.38,29.03,27.97,28.47,28.94,28.91,28.66,28.34,28.69,27.19,27.94,27.38,26.41,26.56,26.72,28.25,28.72,31.12,32.72,33.44,34.56,34.97,33.53,33.41,33.03,32.44,30.81,31.22,30.41,29.59,28.56,27.31,26.91,24.81,23.97,24.31,23.53,22.94,22.81,22.75,20.16,19.94,18.28,17.81,17.81,17.44,16.5,15.06,13.66,12.31,11.03,9.56,10.31,9.91,9.94,9.88,7.03,8.28,6.59,7.56,9.03,8.41,10.47,10.31,10.53,11.59,13.19,14.66,15.34,17.22,17.94,19.16,20.94,23.44,25.97,28.53,30.41,31.47,30.03,28.38,26.16,22.59,20.5,18.41,17.12,15.0,10.59,11.12,7.75,5.94,5.25,4.19,4.72,5.16,5.06,8.03,9.19,11.03,13.72,13.12,12.94,12.25,9.94,8.88,7.44,7.88,6.88,6.31,6.88,7.31,7.97,9.12,10.75,10.81,10.44,10.41,10.56,8.81,9.62,9.56,9.66,9.62,9.19,11.16,12.25,13.69,15.41,18.09,18.69,20.88,22.38,21.94,23.25,22.38,22.09,20.97,21.19,19.62,19.09,18.38,16.19,16.69,16.53,16.66,17.38,17.94,19.19,19.25,18.28,19.25,18.62,18.62,17.56,15.5,15.34,14.25,11.09,8.5,7.91,4.22,2.66,2.75,1.25,4.28,4.88,7.41,8.59,11.66,12.34,13.06,13.31,12.88,12.56,11.5,8.78,8.62,7.16,6.91,6.31,5.72,5.31,4.44,4.31,4.97,5.19,7.38,8.56,10.56,10.5,10.53,11.31,10.56,9.28,10.84,12.0,13.66,14.53,15.16,14.56,13.12,11.66,10.5,8.81,7.44,6.16,5.84,5.31,6.69,6.97,9.12,9.72,9.78,10.28,10.81,10.81,11.94,11.84,13.53,14.28,13.94,13.25,8.53,9.66,7.62,7.31,9.94,11.66,13.25,15.41,14.56,14.66,15.06,13.31,12.56,11.38,8.0,6.53,2.78,1.22,0.19,-0.22,1.09,1.28,2.72,5.0,5.06,7.69,8.84,8.69,9.5,9.03,10.81,12.53,14.31,17.34,19.41,18.53,18.84,15.19,13.91,8.06,7.94,6.44,4.62,5.78,7.03,6.53,8.41,10.53,13.25,15.12,16.94,18.69,17.81,18.47,17.31,16.28,15.44,14.53,13.81,13.03,11.09,9.94,6.28,7.25,5.41,6.56,8.84,11.5,14.16,17.41,19.03,21.09,21.19,20.56,20.91,20.12,19.78,15.81,16.69,13.03,9.44,7.97,4.31,3.28,0.53,0.34,0.31,1.97,4.56,6.44,10.41,12.91,14.88,17.47,17.12,18.66,17.44,16.72,16.53,15.62,13.19,11.75,9.41,8.94,8.28,10.62,10.94,12.91,12.81,14.09,13.53,14.41,15.97,17.59,18.28,20.06,20.25,19.06,17.25,12.91,10.91,7.66,5.75,4.94,5.09,6.31,7.53,9.75,12.5,12.16,16.44,15.44,17.0,14.94,13.66,11.12,7.66,4.72,3.56,1.09,1.66,-0.12,-2.72,1.25,1.47,5.53,10.06,13.44,15.84,18.0,16.94,18.25,19.75,21.09,20.06,21.06,18.06,13.12,7.12,4.16,1.97,0.84,2.19,3.41,5.12,5.28,6.03,7.78,9.03,10.5,13.25,15.69,19.41,22.12,24.59,24.44,22.78,20.5,18.38,17.47,18.5,20.5,23.16,24.84,24.81,22.66,22.19,20.44,18.44,16.81,15.44,13.88,11.91,10.78,9.69,8.53,8.12,8.81,9.09,10.03,9.28,12.69,10.62,9.84,8.5,6.88,4.28,3.0,2.34,5.38,6.47,10.53,12.41,13.59,14.44,13.56,13.62,11.56,11.81,10.03,8.91,8.94,8.88,9.69,9.66,9.62,11.16,12.25,11.41,14.59,15.25,16.78,20.0,21.31,22.53,23.12,22.03,20.53,18.75,15.47,13.69,10.94,9.75,10.81,11.66,13.03,16.44,18.53,21.31,22.06,22.03,22.19,21.28,21.66,21.62,21.78,21.34,19.31,18.03,13.0,13.38,9.88,8.81,8.19,6.56,8.19,9.19,10.66,14.75,17.62,21.0,24.38,25.06,29.28,29.81,28.5,25.66,24.19,19.47,15.16,11.69,9.06,6.91,5.84,6.72,6.97,7.31,7.44,10.41,10.03,11.38,13.69,14.5,14.72,14.97,14.66,14.56,15.5,14.12,14.62,13.5,12.81,9.91,11.94,10.28,11.66,12.34,12.88,13.88,15.47,15.0,15.91,15.81,14.88,16.41,16.72,15.56,18.16,16.75,17.84,16.5,15.31,14.69,12.66,12.06,11.06,8.75,8.97,7.69,5.47,2.88,5.28,2.91,3.25,5.31,4.53,5.5,5.41,4.75,3.81,4.38,3.78,2.03,2.25,3.12,4.38,4.06,7.44,8.41,9.34,11.91,13.41,13.75,14.56,15.34,15.81,16.88,17.19,16.56,15.12,13.25,9.75,6.62,3.81,4.72,3.34,5.25,7.16,8.41,9.47,9.84,10.69,10.66,10.5,10.88,9.88,10.0,9.41,8.19,8.28,5.91,8.53,7.66,7.94,9.5,9.91,10.91,10.66,11.72,11.69,12.88,13.84,14.5,12.94,16.34,16.31,18.19,20.12,21.12,21.12,18.34,16.09,13.28,11.22,10.19,11.16,8.78,12.22,10.91,11.25,12.5,12.78,13.0,13.53,14.44,14.75,16.34,16.34,16.81,16.5,16.56,17.81,18.66,18.81,22.28,22.5,22.66,22.97,19.66,19.62,17.56,15.19,16.19,15.78,15.16,14.94,14.41,14.12,13.12,13.69,12.25,11.94,12.0,11.0,13.41,14.88,15.31,18.81,18.72,21.84,23.53,23.91,25.28,24.38,22.91,20.38,18.94,17.25,16.66,17.19,15.56,15.22,12.81,15.56,12.78,14.72,14.97,14.53,14.28,14.06,14.03,14.25,15.44,17.34,17.31,17.88,17.97,17.53,15.09,13.69,11.78,9.03,7.03,5.19,4.62,3.28,4.66,5.62,5.06,9.97,10.06,11.16,12.94,13.38,12.19,12.91,12.0,10.62,11.03,10.25,9.84,8.31,11.16,10.28,13.06,13.81,14.5,13.94,11.0,10.22,9.09,7.66,9.03,9.44,11.41,12.91,14.25,15.5,15.56,17.47,16.78,15.72,15.44,13.94,13.06,12.06,11.44,11.69,12.22,12.88,13.12,13.62,11.06,12.84,10.03,11.16,11.66,12.91,14.91,17.38,20.0,21.47,22.94,23.06,22.5,21.81,20.5,19.06,18.12,16.72,15.94,13.06,14.19,12.5,13.03,14.0,13.69,13.78,13.5,12.22,12.0,10.53,8.69,6.91,4.69,1.78,0.34,-0.56,-0.84,0.41,2.31,4.94,7.44,8.56,13.81,16.62,19.56,23.72,25.53,25.81,25.41,22.88,19.66,17.25,14.16,12.69,11.94,11.72,11.47,13.16,14.91,16.12,17.19,21.06,20.91,21.69,21.28,18.81,16.88,14.94,13.91,13.31,12.78,12.88,11.69,9.75,9.38,7.12,5.78,4.91,4.28,3.59,2.56,2.19,4.66,5.16,8.34,11.12,11.25,11.53,10.88,10.12,10.12,10.06,10.16,8.5,8.31,6.81,5.25,4.53,4.69,4.75,5.47,5.94,6.72,5.91,5.41,6.0,5.47,6.41,8.81,10.88,12.69,14.56,15.62,15.06,15.25,15.94,16.56,17.12,18.06:24.03,22.81,21.88,20.59,19.53,18.88,19.03,19.53,20.75,24.03,26.19,29.81,31.53,32.5,34.56,33.84,33.12,30.59,29.38,29.03,27.97,28.47,28.94,28.91,28.66,28.34,28.69,27.19,27.94,27.38,26.41,26.56,26.72,28.25,28.72,31.12,32.72,33.44,34.56,34.97,33.53,33.41,33.03,32.44,30.81,31.22,30.41,29.59,28.56,27.31,26.91,24.81,23.97,24.31,23.53,22.94,22.81,22.75,20.16,19.94,18.28,17.81,17.81,17.44,16.5,15.06,13.66,12.31,11.03,9.56,10.31,9.91,9.94,9.88,7.03,8.28,6.59,7.56,9.03,8.41,10.47,10.31,10.53,11.59,13.19,14.66,15.34,17.22,17.94,19.16,20.94,23.44,25.97,28.53,30.41,31.47,30.03,28.38,26.16,22.59,20.5,18.41,17.12,15.0,10.59,11.12,7.75,5.94,5.25,4.19,4.72,5.16,5.06,8.03,9.19,11.03,13.72,13.12,12.94,12.25,9.94,8.88,7.44,7.88,6.88,6.31,6.88,7.31,7.97,9.12,10.75,10.81,10.44,10.41,10.56,8.81,9.62,9.56,9.66,9.62,9.19,11.16,12.25,13.69,15.41,18.09,18.69,20.88,22.38,21.94,23.25,22.38,22.09,20.97,21.19,19.62,19.09,18.38,16.19,16.69,16.53,16.66,17.38,17.94,19.19,19.25,18.28,19.25,18.62,18.62,17.56,15.5,15.34,14.25,11.09,8.5,7.91,4.22,2.66,2.75,1.25,4.28,4.88,7.41,8.59,11.66,12.34,13.06,13.31,12.88,12.56,11.5,8.78,8.62,7.16,6.91,6.31,5.72,5.31,4.44,4.31,4.97,5.19,7.38,8.56,10.56,10.5,10.53,11.31,10.56,9.28,10.84,12.0,13.66,14.53,15.16,14.56,13.12,11.66,10.5,8.81,7.44,6.16,5.84,5.31,6.69,6.97,9.12,9.72,9.78,10.28,10.81,10.81,11.94,11.84,13.53,14.28,13.94,13.25,8.53,9.66,7.62,7.31,9.94,11.66,13.25,15.41,14.56,14.66,15.06,13.31,12.56,11.38,8.0,6.53,2.78,1.22,0.19,-0.22,1.09,1.28,2.72,5.0,5.06,7.69,8.84,8.69,9.5,9.03,10.81,12.53,14.31,17.34,19.41,18.53,18.84,15.19,13.91,8.06,7.94,6.44,4.62,5.78,7.03,6.53,8.41,10.53,13.25,15.12,16.94,18.69,17.81,18.47,17.31,16.28,15.44,14.53,13.81,13.03,11.09,9.94,6.28,7.25,5.41,6.56,8.84,11.5,14.16,17.41,19.03,21.09,21.19,20.56,20.91,20.12,19.78,15.81,16.69,13.03,9.44,7.97,4.31,3.28,0.53,0.34,0.31,1.97,4.56,6.44,10.41,12.91,14.88,17.47,17.12,18.66,17.44,16.72,16.53,15.62,13.19,11.75,9.41,8.94,8.28,10.62,10.94,12.91,12.81,14.09,13.53,14.41,15.97,17.59,18.28,20.06,20.25,19.06,17.25,12.91,10.91,7.66,5.75,4.94,5.09,6.31,7.53,9.75,12.5,12.16,16.44,15.44,17.0,14.94,13.66,11.12,7.66,4.72,3.56,1.09,1.66,-0.12,-2.72,1.25,1.47,5.53,10.06,13.44,15.84,18.0,16.94,18.25,19.75,21.09,20.06,21.06,18.06,13.12,7.12,4.16,1.97,0.84,2.19,3.41,5.12,5.28,6.03,7.78,9.03,10.5,13.25,15.69,19.41,22.12,24.59,24.44,22.78,20.5,18.38,17.47,18.5,20.5,23.16,24.84,24.81,22.66,22.19,20.44,18.44,16.81,15.44,13.88,11.91,10.78,9.69,8.53,8.12,8.81,9.09,10.03,9.28,12.69,10.62,9.84,8.5,6.88,4.28,3.0,2.34,5.38,6.47,10.53,12.41,13.59,14.44,13.56,13.62,11.56,11.81,10.03,8.91,8.94,8.88,9.69,9.66,9.62,11.16,12.25,11.41,14.59,15.25,16.78,20.0,21.31,22.53,23.12,22.03,20.53,18.75,15.47,13.69,10.94,9.75,10.81,11.66,13.03,16.44,18.53,21.31,22.06,22.03,22.19,21.28,21.66,21.62,21.78,21.34,19.31,18.03,13.0,13.38,9.88,8.81,8.19,6.56,8.19,9.19,10.66,14.75,17.62,21.0,24.38,25.06,29.28,29.81,28.5,25.66,24.19,19.47,15.16,11.69,9.06,6.91,5.84,6.72,6.97,7.31,7.44,10.41,10.03,11.38,13.69,14.5,14.72,14.97,14.66,14.56,15.5,14.12,14.62,13.5,12.81,9.91,11.94,10.28,11.66,12.34,12.88,13.88,15.47,15.0,15.91,15.81,14.88,16.41,16.72,15.56,18.16,16.75,17.84,16.5,15.31,14.69,12.66,12.06,11.06,8.75,8.97,7.69,5.47,2.88,5.28,2.91,3.25,5.31,4.53,5.5,5.41,4.75,3.81,4.38,3.78,2.03,2.25,3.12,4.38,4.06,7.44,8.41,9.34,11.91,13.41,13.75,14.56,15.34,15.81,16.88,17.19,16.56,15.12,13.25,9.75,6.62,3.81,4.72,3.34,5.25,7.16,8.41,9.47,9.84,10.69,10.66,10.5,10.88,9.88,10.0,9.41,8.19,8.28,5.91,8.53,7.66,7.94,9.5,9.91,10.91,10.66,11.72,11.69,12.88,13.84,14.5,12.94,16.34,16.31,18.19,20.12,21.12,21.12,18.34,16.09,13.28,11.22,10.19,11.16,8.78,12.22,10.91,11.25,12.5,12.78,13.0,13.53,14.44,14.75,16.34,16.34,16.81,16.5,16.56,17.81,18.66,18.81,22.28,22.5,22.66,22.97,19.66,19.62,17.56,15.19,16.19,15.78,15.16,14.94,14.41,14.12,13.12,13.69,12.25,11.94,12.0,11.0,13.41,14.88,15.31,18.81,18.72,21.84,23.53,23.91,25.28,24.38,22.91,20.38,18.94,17.25,16.66,17.19,15.56,15.22,12.81,15.56,12.78,14.72,14.97,14.53,14.28,14.06,14.03,14.25,15.44,17.34,17.31,17.88,17.97,17.53,15.09,13.69,11.78,9.03,7.03,5.19,4.62,3.28,4.66,5.62,5.06,9.97,10.06,11.16,12.94,13.38,12.19,12.91,12.0,10.62,11.03,10.25,9.84,8.31,11.16,10.28,13.06,13.81,14.5,13.94,11.0,10.22,9.09,7.66,9.03,9.44,11.41,12.91,14.25,15.5,15.56,17.47,16.78,15.72,15.44,13.94,13.06,12.06,11.44,11.69,12.22,12.88,13.12,13.62,11.06,12.84,10.03,11.16,11.66,12.91,14.91,17.38,20.0,21.47,22.94,23.06,22.5,21.81,20.5,19.06,18.12,16.72,15.94,13.06,14.19,12.5,13.03,14.0,13.69,13.78,13.5,12.22,12.0,10.53,8.69,6.91,4.69,1.78,0.34,-0.56,-0.84,0.41,2.31,4.94,7.44,8.56,13.81,16.62,19.56,23.72,25.53,25.81,25.41,22.88,19.66,17.25,14.16,12.69,11.94,11.72,11.47,13.16,14.91,16.12,17.19,21.06,20.91,21.69,21.28,18.81,16.88,14.94,13.91,13.31,12.78,12.88,11.69,9.75,9.38,7.12,5.78,4.91,4.28,3.59,2.56,2.19,4.66,5.16,8.34,11.12,11.25,11.53,10.88,10.12,10.12,10.06,10.16,8.5,8.31,6.81,5.25,4.53,4.69,4.75,5.47,5.94,6.72,5.91,5.41,6.0,5.47,6.41,8.81,10.88,12.69,14.56,15.62,15.06,15.25,15.94,16.56,17.12,18.06,-16.19,-13.25,-11.53,-10.72,-8.66,-8.59:19.03,19.53,20.75,24.03,26.19,29.81,31.53,32.5,34.56,33.84,33.12,30.59,29.38,29.03,27.97,28.47,28.94,28.91,28.66,28.34,28.69,27.19,27.94,27.38,26.41,26.56,26.72,28.25,28.72,31.12,32.72,33.44,34.56,34.97,33.53,33.41,33.03,32.44,30.81,31.22,30.41,29.59,28.56,27.31,26.91,24.81,23.97,24.31,23.53,22.94,22.81,22.75,20.16,19.94,18.28,17.81,17.81,17.44,16.5,15.06,13.66,12.31,11.03,9.56,10.31,9.91,9.94,9.88,7.03,8.28,6.59,7.56,9.03,8.41,10.47,10.31,10.53,11.59,13.19,14.66,15.34,17.22,17.94,19.16,20.94,23.44,25.97,28.53,30.41,31.47,30.03,28.38,26.16,22.59,20.5,18.41,17.12,15.0,10.59,11.12,7.75,5.94,5.25,4.19,4.72,5.16,5.06,8.03,9.19,11.03,13.72,13.12,12.94,12.25,9.94,8.88,7.44,7.88,6.88,6.31,6.88,7.31,7.97,9.12,10.75,10.81,10.44,10.41,10.56,8.81,9.62,9.56,9.66,9.62,9.19,11.16,12.25,13.69,15.41,18.09,18.69,20.88,22.38,21.94,23.25,22.38,22.09,20.97,21.19,19.62,19.09,18.38,16.19,16.69,16.53,16.66,17.38,17.94,19.19,19.25,18.28,19.25,18.62,18.62,17.56,15.5,15.34,14.25,11.09,8.5,7.91,4.22,2.66,2.75,1.25,4.28,4.88,7.41,8.59,11.66,12.34,13.06,13.31,12.88,12.56,11.5,8.78,8.62,7.16,6.91,6.31,5.72,5.31,4.44,4.31,4.97,5.19,7.38,8.56,10.56,10.5,10.53,11.31,10.56,9.28,10.84,12.0,13.66,14.53,15.16,14.56,13.12,11.66,10.5,8.81,7.44,6.16,5.84,5.31,6.69,6.97,9.12,9.72,9.78,10.28,10.81,10.81,11.94,11.84,13.53,14.28,13.94,13.25,8.53,9.66,7.62,7.31,9.94,11.66,13.25,15.41,14.56,14.66,15.06,13.31,12.56,11.38,8.0,6.53,2.78,1.22,0.19,-0.22,1.09,1.28,2.72,5.0,5.06,7.69,8.84,8.69,9.5,9.03,10.81,12.53,14.31,17.34,19.41,18.53,18.84,15.19,13.91,8.06,7.94,6.44,4.62,5.78,7.03,6.53,8.41,10.53,13.25,15.12,16.94,18.69,17.81,18.47,17.31,16.28,15.44,14.53,13.81,13.03,11.09,9.94,6.28,7.25,5.41,6.56,8.84,11.5,14.16,17.41,19.03,21.09,21.19,20.56,20.91,20.12,19.78,15.81,16.69,13.03,9.44,7.97,4.31,3.28,0.53,0.34,0.31,1.97,4.56,6.44,10.41,12.91,14.88,17.47,17.12,18.66,17.44,16.72,16.53,15.62,13.19,11.75,9.41,8.94,8.28,10.62,10.94,12.91,12.81,14.09,13.53,14.41,15.97,17.59,18.28,20.06,20.25,19.06,17.25,12.91,10.91,7.66,5.75,4.94,5.09,6.31,7.53,9.75,12.5,12.16,16.44,15.44,17.0,14.94,13.66,11.12,7.66,4.72,3.56,1.09,1.66,-0.12,-2.72,1.25,1.47,5.53,10.06,13.44,15.84,18.0,16.94,18.25,19.75,21.09,20.06,21.06,18.06,13.12,7.12,4.16,1.97,0.84,2.19,3.41,5.12,5.28,6.03,7.78,9.03,10.5,13.25,15.69,19.41,22.12,24.59,24.44,22.78,20.5,18.38,17.47,18.5,20.5,23.16,24.84,24.81,22.66,22.19,20.44,18.44,16.81,15.44,13.88,11.91,10.78,9.69,8.53,8.12,8.81,9.09,10.03,9.28,12.69,10.62,9.84,8.5,6.88,4.28,3.0,2.34,5.38,6.47,10.53,12.41,13.59,14.44,13.56,13.62,11.56,11.81,10.03,8.91,8.94,8.88,9.69,9.66,9.62,11.16,12.25,11.41,14.59,15.25,16.78,20.0,21.31,22.53,23.12,22.03,20.53,18.75,15.47,13.69,10.94,9.75,10.81,11.66,13.03,16.44,18.53,21.31,22.06,22.03,22.19,21.28,21.66,21.62,21.78,21.34,19.31,18.03,13.0,13.38,9.88,8.81,8.19,6.56,8.19,9.19,10.66,14.75,17.62,21.0,24.38,25.06,29.28,29.81,28.5,25.66,24.19,19.47,15.16,11.69,9.06,6.91,5.84,6.72,6.97,7.31,7.44,10.41,10.03,11.38,13.69,14.5,14.72,14.97,14.66,14.56,15.5,14.12,14.62,13.5,12.81,9.91,11.94,10.28,11.66,12.34,12.88,13.88,15.47,15.0,15.91,15.81,14.88,16.41,16.72,15.56,18.16,16.75,17.84,16.5,15.31,14.69,12.66,12.06,11.06,8.75,8.97,7.69,5.47,2.88,5.28,2.91,3.25,5.31,4.53,5.5,5.41,4.75,3.81,4.38,3.78,2.03,2.25,3.12,4.38,4.06,7.44,8.41,9.34,11.91,13.41,13.75,14.56,15.34,15.81,16.88,17.19,16.56,15.12,13.25,9.75,6.62,3.81,4.72,3.34,5.25,7.16,8.41,9.47,9.84,10.69,10.66,10.5,10.88,9.88,10.0,9.41,8.19,8.28,5.91,8.53,7.66,7.94,9.5,9.91,10.91,10.66,11.72,11.69,12.88,13.84,14.5,12.94,16.34,16.31,18.19,20.12,21.12,21.12,18.34,16.09,13.28,11.22,10.19,11.16,8.78,12.22,10.91,11.25,12.5,12.78,13.0,13.53,14.44,14.75,16.34,16.34,16.81,16.5,16.56,17.81,18.66,18.81,22.28,22.5,22.66,22.97,19.66,19.62,17.56,15.19,16.19,15.78,15.16,14.94,14.41,14.12,13.12,13.69,12.25,11.94,12.0,11.0,13.41,14.88,15.31,18.81,18.72,21.84,23.53,23.91,25.28,24.38,22.91,20.38,18.94,17.25,16.66,17.19,15.56,15.22,12.81,15.56,12.78,14.72,14.97,14.53,14.28,14.06,14.03,14.25,15.44,17.34,17.31,17.88,17.97,17.53,15.09,13.69,11.78,9.03,7.03,5.19,4.62,3.28,4.66,5.62,5.06,9.97,10.06,11.16,12.94,13.38,12.19,12.91,12.0,10.62,11.03,10.25,9.84,8.31,11.16,10.28,13.06,13.81,14.5,13.94,11.0,10.22,9.09,7.66,9.03,9.44,11.41,12.91,14.25,15.5,15.56,17.47,16.78,15.72,15.44,13.94,13.06,12.06,11.44,11.69,12.22,12.88,13.12,13.62,11.06,12.84,10.03,11.16,11.66,12.91,14.91,17.38,20.0,21.47,22.94,23.06,22.5,21.81,20.5,19.06,18.12,16.72,15.94,13.06,14.19,12.5,13.03,14.0,13.69,13.78,13.5,12.22,12.0,10.53,8.69,6.91,4.69,1.78,0.34,-0.56,-0.84,0.41,2.31,4.94,7.44,8.56,13.81,16.62,19.56,23.72,25.53,25.81,25.41,22.88,19.66,17.25,14.16,12.69,11.94,11.72,11.47,13.16,14.91,16.12,17.19,21.06,20.91,21.69,21.28,18.81,16.88,14.94,13.91,13.31,12.78,12.88,11.69,9.75,9.38,7.12,5.78,4.91,4.28,3.59,2.56,2.19,4.66,5.16,8.34,11.12,11.25,11.53,10.88,10.12,10.12,10.06,10.16,8.5,8.31,6.81,5.25,4.53,4.69,4.75,5.47,5.94,6.72,5.91,5.41,6.0,5.47,6.41,8.81,10.88,12.69,14.56,15.62,15.06,15.25,15.94,16.56,17.12,18.06,-16.19,-13.25,-11.53,-10.72,-8.66,-8.59,-8.53,-7.69,-8.91,-9.09,-9.59,-10.53:31.53,32.5,34.56,33.84,33.12,30.59,29.38,29.03,27.97,28.47,28.94,28.91,28.66,28.34,28.69,27.19,27.94,27.38,26.41,26.56,26.72,28.25,28.72,31.12,32.72,33.44,34.56,34.97,33.53,33.41,33.03,32.44,30.81,31.22,30.41,29.59,28.56,27.31,26.91,24.81,23.97,24.31,23.53,22.94,22.81,22.75,20.16,19.94,18.28,17.81,17.81,17.44,16.5,15.06,13.66,12.31,11.03,9.56,10.31,9.91,9.94,9.88,7.03,8.28,6.59,7.56,9.03,8.41,10.47,10.31,10.53,11.59,13.19,14.66,15.34,17.22,17.94,19.16,20.94,23.44,25.97,28.53,30.41,31.47,30.03,28.38,26.16,22.59,20.5,18.41,17.12,15.0,10.59,11.12,7.75,5.94,5.25,4.19,4.72,5.16,5.06,8.03,9.19,11.03,13.72,13.12,12.94,12.25,9.94,8.88,7.44,7.88,6.88,6.31,6.88,7.31,7.97,9.12,10.75,10.81,10.44,10.41,10.56,8.81,9.62,9.56,9.66,9.62,9.19,11.16,12.25,13.69,15.41,18.09,18.69,20.88,22.38,21.94,23.25,22.38,22.09,20.97,21.19,19.62,19.09,18.38,16.19,16.69,16.53,16.66,17.38,17.94,19.19,19.25,18.28,19.25,18.62,18.62,17.56,15.5,15.34,14.25,11.09,8.5,7.91,4.22,2.66,2.75,1.25,4.28,4.88,7.41,8.59,11.66,12.34,13.06,13.31,12.88,12.56,11.5,8.78,8.62,7.16,6.91,6.31,5.72,5.31,4.44,4.31,4.97,5.19,7.38,8.56,10.56,10.5,10.53,11.31,10.56,9.28,10.84,12.0,13.66,14.53,15.16,14.56,13.12,11.66,10.5,8.81,7.44,6.16,5.84,5.31,6.69,6.97,9.12,9.72,9.78,10.28,10.81,10.81,11.94,11.84,13.53,14.28,13.94,13.25,8.53,9.66,7.62,7.31,9.94,11.66,13.25,15.41,14.56,14.66,15.06,13.31,12.56,11.38,8.0,6.53,2.78,1.22,0.19,-0.22,1.09,1.28,2.72,5.0,5.06,7.69,8.84,8.69,9.5,9.03,10.81,12.53,14.31,17.34,19.41,18.53,18.84,15.19,13.91,8.06,7.94,6.44,4.62,5.78,7.03,6.53,8.41,10.53,13.25,15.12,16.94,18.69,17.81,18.47,17.31,16.28,15.44,14.53,13.81,13.03,11.09,9.94,6.28,7.25,5.41,6.56,8.84,11.5,14.16,17.41,19.03,21.09,21.19,20.56,20.91,20.12,19.78,15.81,16.69,13.03,9.44,7.97,4.31,3.28,0.53,0.34,0.31,1.97,4.56,6.44,10.41,12.91,14.88,17.47,17.12,18.66,17.44,16.72,16.53,15.62,13.19,11.75,9.41,8.94,8.28,10.62,10.94,12.91,12.81,14.09,13.53,14.41,15.97,17.59,18.28,20.06,20.25,19.06,17.25,12.91,10.91,7.66,5.75,4.94,5.09,6.31,7.53,9.75,12.5,12.16,16.44,15.44,17.0,14.94,13.66,11.12,7.66,4.72,3.56,1.09,1.66,-0.12,-2.72,1.25,1.47,5.53,10.06,13.44,15.84,18.0,16.94,18.25,19.75,21.09,20.06,21.06,18.06,13.12,7.12,4.16,1.97,0.84,2.19,3.41,5.12,5.28,6.03,7.78,9.03,10.5,13.25,15.69,19.41,22.12,24.59,24.44,22.78,20.5,18.38,17.47,18.5,20.5,23.16,24.84,24.81,22.66,22.19,20.44,18.44,16.81,15.44,13.88,11.91,10.78,9.69,8.53,8.12,8.81,9.09,10.03,9.28,12.69,10.62,9.84,8.5,6.88,4.28,3.0,2.34,5.38,6.47,10.53,12.41,13.59,14.44,13.56,13.62,11.56,11.81,10.03,8.91,8.94,8.88,9.69,9.66,9.62,11.16,12.25,11.41,14.59,15.25,16.78,20.0,21.31,22.53,23.12,22.03,20.53,18.75,15.47,13.69,10.94,9.75,10.81,11.66,13.03,16.44,18.53,21.31,22.06,22.03,22.19,21.28,21.66,21.62,21.78,21.34,19.31,18.03,13.0,13.38,9.88,8.81,8.19,6.56,8.19,9.19,10.66,14.75,17.62,21.0,24.38,25.06,29.28,29.81,28.5,25.66,24.19,19.47,15.16,11.69,9.06,6.91,5.84,6.72,6.97,7.31,7.44,10.41,10.03,11.38,13.69,14.5,14.72,14.97,14.66,14.56,15.5,14.12,14.62,13.5,12.81,9.91,11.94,10.28,11.66,12.34,12.88,13.88,15.47,15.0,15.91,15.81,14.88,16.41,16.72,15.56,18.16,16.75,17.84,16.5,15.31,14.69,12.66,12.06,11.06,8.75,8.97,7.69,5.47,2.88,5.28,2.91,3.25,5.31,4.53,5.5,5.41,4.75,3.81,4.38,3.78,2.03,2.25,3.12,4.38,4.06,7.44,8.41,9.34,11.91,13.41,13.75,14.56,15.34,15.81,16.88,17.19,16.56,15.12,13.25,9.75,6.62,3.81,4.72,3.34,5.25,7.16,8.41,9.47,9.84,10.69,10.66,10.5,10.88,9.88,10.0,9.41,8.19,8.28,5.91,8.53,7.66,7.94,9.5,9.91,10.91,10.66,11.72,11.69,12.88,13.84,14.5,12.94,16.34,16.31,18.19,20.12,21.12,21.12,18.34,16.09,13.28,11.22,10.19,11.16,8.78,12.22,10.91,11.25,12.5,12.78,13.0,13.53,14.44,14.75,16.34,16.34,16.81,16.5,16.56,17.81,18.66,18.81,22.28,22.5,22.66,22.97,19.66,19.62,17.56,15.19,16.19,15.78,15.16,14.94,14.41,14.12,13.12,13.69,12.25,11.94,12.0,11.0,13.41,14.88,15.31,18.81,18.72,21.84,23.53,23.91,25.28,24.38,22.91,20.38,18.94,17.25,16.66,17.19,15.56,15.22,12.81,15.56,12.78,14.72,14.97,14.53,14.28,14.06,14.03,14.25,15.44,17.34,17.31,17.88,17.97,17.53,15.09,13.69,11.78,9.03,7.03,5.19,4.62,3.28,4.66,5.62,5.06,9.97,10.06,11.16,12.94,13.38,12.19,12.91,12.0,10.62,11.03,10.25,9.84,8.31,11.16,10.28,13.06,13.81,14.5,13.94,11.0,10.22,9.09,7.66,9.03,9.44,11.41,12.91,14.25,15.5,15.56,17.47,16.78,15.72,15.44,13.94,13.06,12.06,11.44,11.69,12.22,12.88,13.12,13.62,11.06,12.84,10.03,11.16,11.66,12.91,14.91,17.38,20.0,21.47,22.94,23.06,22.5,21.81,20.5,19.06,18.12,16.72,15.94,13.06,14.19,12.5,13.03,14.0,13.69,13.78,13.5,12.22,12.0,10.53,8.69,6.91,4.69,1.78,0.34,-0.56,-0.84,0.41,2.31,4.94,7.44,8.56,13.81,16.62,19.56,23.72,25.53,25.81,25.41,22.88,19.66,17.25,14.16,12.69,11.94,11.72,11.47,13.16,14.91,16.12,17.19,21.06,20.91,21.69,21.28,18.81,16.88,14.94,13.91,13.31,12.78,12.88,11.69,9.75,9.38,7.12,5.78,4.91,4.28,3.59,2.56,2.19,4.66,5.16,8.34,11.12,11.25,11.53,10.88,10.12,10.12,10.06,10.16,8.5,8.31,6.81,5.25,4.53,4.69,4.75,5.47,5.94,6.72,5.91,5.41,6.0,5.47,6.41,8.81,10.88,12.69,14.56,15.62,15.06,15.25,15.94,16.56,17.12,18.06,-16.19,-13.25,-11.53,-10.72,-8.66,-8.59,-8.53,-7.69,-8.91,-9.09,-9.59,-10.53,-11.66,-12.78,-14.0,-12.91,-12.72,-10.53:29.38,29.03,27.97,28.47,28.94,28.91,28.66,28.34,28.69,27.19,27.94,27.38,26.41,26.56,26.72,28.25,28.72,31.12,32.72,33.44,34.56,34.97,33.53,33.41,33.03,32.44,30.81,31.22,30.41,29.59,28.56,27.31,26.91,24.81,23.97,24.31,23.53,22.94,22.81,22.75,20.16,19.94,18.28,17.81,17.81,17.44,16.5,15.06,13.66,12.31,11.03,9.56,10.31,9.91,9.94,9.88,7.03,8.28,6.59,7.56,9.03,8.41,10.47,10.31,10.53,11.59,13.19,14.66,15.34,17.22,17.94,19.16,20.94,23.44,25.97,28.53,30.41,31.47,30.03,28.38,26.16,22.59,20.5,18.41,17.12,15.0,10.59,11.12,7.75,5.94,5.25,4.19,4.72,5.16,5.06,8.03,9.19,11.03,13.72,13.12,12.94,12.25,9.94,8.88,7.44,7.88,6.88,6.31,6.88,7.31,7.97,9.12,10.75,10.81,10.44,10.41,10.56,8.81,9.62,9.56,9.66,9.62,9.19,11.16,12.25,13.69,15.41,18.09,18.69,20.88,22.38,21.94,23.25,22.38,22.09,20.97,21.19,19.62,19.09,18.38,16.19,16.69,16.53,16.66,17.38,17.94,19.19,19.25,18.28,19.25,18.62,18.62,17.56,15.5,15.34,14.25,11.09,8.5,7.91,4.22,2.66,2.75,1.25,4.28,4.88,7.41,8.59,11.66,12.34,13.06,13.31,12.88,12.56,11.5,8.78,8.62,7.16,6.91,6.31,5.72,5.31,4.44,4.31,4.97,5.19,7.38,8.56,10.56,10.5,10.53,11.31,10.56,9.28,10.84,12.0,13.66,14.53,15.16,14.56,13.12,11.66,10.5,8.81,7.44,6.16,5.84,5.31,6.69,6.97,9.12,9.72,9.78,10.28,10.81,10.81,11.94,11.84,13.53,14.28,13.94,13.25,8.53,9.66,7.62,7.31,9.94,11.66,13.25,15.41,14.56,14.66,15.06,13.31,12.56,11.38,8.0,6.53,2.78,1.22,0.19,-0.22,1.09,1.28,2.72,5.0,5.06,7.69,8.84,8.69,9.5,9.03,10.81,12.53,14.31,17.34,19.41,18.53,18.84,15.19,13.91,8.06,7.94,6.44,4.62,5.78,7.03,6.53,8.41,10.53,13.25,15.12,16.94,18.69,17.81,18.47,17.31,16.28,15.44,14.53,13.81,13.03,11.09,9.94,6.28,7.25,5.41,6.56,8.84,11.5,14.16,17.41,19.03,21.09,21.19,20.56,20.91,20.12,19.78,15.81,16.69,13.03,9.44,7.97,4.31,3.28,0.53,0.34,0.31,1.97,4.56,6.44,10.41,12.91,14.88,17.47,17.12,18.66,17.44,16.72,16.53,15.62,13.19,11.75,9.41,8.94,8.28,10.62,10.94,12.91,12.81,14.09,13.53,14.41,15.97,17.59,18.28,20.06,20.25,19.06,17.25,12.91,10.91,7.66,5.75,4.94,5.09,6.31,7.53,9.75,12.5,12.16,16.44,15.44,17.0,14.94,13.66,11.12,7.66,4.72,3.56,1.09,1.66,-0.12,-2.72,1.25,1.47,5.53,10.06,13.44,15.84,18.0,16.94,18.25,19.75,21.09,20.06,21.06,18.06,13.12,7.12,4.16,1.97,0.84,2.19,3.41,5.12,5.28,6.03,7.78,9.03,10.5,13.25,15.69,19.41,22.12,24.59,24.44,22.78,20.5,18.38,17.47,18.5,20.5,23.16,24.84,24.81,22.66,22.19,20.44,18.44,16.81,15.44,13.88,11.91,10.78,9.69,8.53,8.12,8.81,9.09,10.03,9.28,12.69,10.62,9.84,8.5,6.88,4.28,3.0,2.34,5.38,6.47,10.53,12.41,13.59,14.44,13.56,13.62,11.56,11.81,10.03,8.91,8.94,8.88,9.69,9.66,9.62,11.16,12.25,11.41,14.59,15.25,16.78,20.0,21.31,22.53,23.12,22.03,20.53,18.75,15.47,13.69,10.94,9.75,10.81,11.66,13.03,16.44,18.53,21.31,22.06,22.03,22.19,21.28,21.66,21.62,21.78,21.34,19.31,18.03,13.0,13.38,9.88,8.81,8.19,6.56,8.19,9.19,10.66,14.75,17.62,21.0,24.38,25.06,29.28,29.81,28.5,25.66,24.19,19.47,15.16,11.69,9.06,6.91,5.84,6.72,6.97,7.31,7.44,10.41,10.03,11.38,13.69,14.5,14.72,14.97,14.66,14.56,15.5,14.12,14.62,13.5,12.81,9.91,11.94,10.28,11.66,12.34,12.88,13.88,15.47,15.0,15.91,15.81,14.88,16.41,16.72,15.56,18.16,16.75,17.84,16.5,15.31,14.69,12.66,12.06,11.06,8.75,8.97,7.69,5.47,2.88,5.28,2.91,3.25,5.31,4.53,5.5,5.41,4.75,3.81,4.38,3.78,2.03,2.25,3.12,4.38,4.06,7.44,8.41,9.34,11.91,13.41,13.75,14.56,15.34,15.81,16.88,17.19,16.56,15.12,13.25,9.75,6.62,3.81,4.72,3.34,5.25,7.16,8.41,9.47,9.84,10.69,10.66,10.5,10.88,9.88,10.0,9.41,8.19,8.28,5.91,8.53,7.66,7.94,9.5,9.91,10.91,10.66,11.72,11.69,12.88,13.84,14.5,12.94,16.34,16.31,18.19,20.12,21.12,21.12,18.34,16.09,13.28,11.22,10.19,11.16,8.78,12.22,10.91,11.25,12.5,12.78,13.0,13.53,14.44,14.75,16.34,16.34,16.81,16.5,16.56,17.81,18.66,18.81,22.28,22.5,22.66,22.97,19.66,19.62,17.56,15.19,16.19,15.78,15.16,14.94,14.41,14.12,13.12,13.69,12.25,11.94,12.0,11.0,13.41,14.88,15.31,18.81,18.72,21.84,23.53,23.91,25.28,24.38,22.91,20.38,18.94,17.25,16.66,17.19,15.56,15.22,12.81,15.56,12.78,14.72,14.97,14.53,14.28,14.06,14.03,14.25,15.44,17.34,17.31,17.88,17.97,17.53,15.09,13.69,11.78,9.03,7.03,5.19,4.62,3.28,4.66,5.62,5.06,9.97,10.06,11.16,12.94,13.38,12.19,12.91,12.0,10.62,11.03,10.25,9.84,8.31,11.16,10.28,13.06,13.81,14.5,13.94,11.0,10.22,9.09,7.66,9.03,9.44,11.41,12.91,14.25,15.5,15.56,17.47,16.78,15.72,15.44,13.94,13.06,12.06,11.44,11.69,12.22,12.88,13.12,13.62,11.06,12.84,10.03,11.16,11.66,12.91,14.91,17.38,20.0,21.47,22.94,23.06,22.5,21.81,20.5,19.06,18.12,16.72,15.94,13.06,14.19,12.5,13.03,14.0,13.69,13.78,13.5,12.22,12.0,10.53,8.69,6.91,4.69,1.78,0.34,-0.56,-0.84,0.41,2.31,4.94,7.44,8.56,13.81,16.62,19.56,23.72,25.53,25.81,25.41,22.88,19.66,17.25,14.16,12.69,11.94,11.72,11.47,13.16,14.91,16.12,17.19,21.06,20.91,21.69,21.28,18.81,16.88,14.94,13.91,13.31,12.78,12.88,11.69,9.75,9.38,7.12,5.78,4.91,4.28,3.59,2.56,2.19,4.66,5.16,8.34,11.12,11.25,11.53,10.88,10.12,10.12,10.06,10.16,8.5,8.31,6.81,5.25,4.53,4.69,4.75,5.47,5.94,6.72,5.91,5.41,6.0,5.47,6.41,8.81,10.88,12.69,14.56,15.62,15.06,15.25,15.94,16.56,17.12,18.06,-16.19,-13.25,-11.53,-10.72,-8.66,-8.59,-8.53,-7.69,-8.91,-9.09,-9.59,-10.53,-11.66,-12.78,-14.0,-12.91,-12.72,-10.53,-8.38,-6.81,-5.03,-3.84,-4.31,-4.66:28.66,28.34,28.69,27.19,27.94,27.38,26.41,26.56,26.72,28.25,28.72,31.12,32.72,33.44,34.56,34.97,33.53,33.41,33.03,32.44,30.81,31.22,30.41,29.59,28.56,27.31,26.91,24.81,23.97,24.31,23.53,22.94,22.81,22.75,20.16,19.94,18.28,17.81,17.81,17.44,16.5,15.06,13.66,12.31,11.03,9.56,10.31,9.91,9.94,9.88,7.03,8.28,6.59,7.56,9.03,8.41,10.47,10.31,10.53,11.59,13.19,14.66,15.34,17.22,17.94,19.16,20.94,23.44,25.97,28.53,30.41,31.47,30.03,28.38,26.16,22.59,20.5,18.41,17.12,15.0,10.59,11.12,7.75,5.94,5.25,4.19,4.72,5.16,5.06,8.03,9.19,11.03,13.72,13.12,12.94,12.25,9.94,8.88,7.44,7.88,6.88,6.31,6.88,7.31,7.97,9.12,10.75,10.81,10.44,10.41,10.56,8.81,9.62,9.56,9.66,9.62,9.19,11.16,12.25,13.69,15.41,18.09,18.69,20.88,22.38,21.94,23.25,22.38,22.09,20.97,21.19,19.62,19.09,18.38,16.19,16.69,16.53,16.66,17.38,17.94,19.19,19.25,18.28,19.25,18.62,18.62,17.56,15.5,15.34,14.25,11.09,8.5,7.91,4.22,2.66,2.75,1.25,4.28,4.88,7.41,8.59,11.66,12.34,13.06,13.31,12.88,12.56,11.5,8.78,8.62,7.16,6.91,6.31,5.72,5.31,4.44,4.31,4.97,5.19,7.38,8.56,10.56,10.5,10.53,11.31,10.56,9.28,10.84,12.0,13.66,14.53,15.16,14.56,13.12,11.66,10.5,8.81,7.44,6.16,5.84,5.31,6.69,6.97,9.12,9.72,9.78,10.28,10.81,10.81,11.94,11.84,13.53,14.28,13.94,13.25,8.53,9.66,7.62,7.31,9.94,11.66,13.25,15.41,14.56,14.66,15.06,13.31,12.56,11.38,8.0,6.53,2.78,1.22,0.19,-0.22,1.09,1.28,2.72,5.0,5.06,7.69,8.84,8.69,9.5,9.03,10.81,12.53,14.31,17.34,19.41,18.53,18.84,15.19,13.91,8.06,7.94,6.44,4.62,5.78,7.03,6.53,8.41,10.53,13.25,15.12,16.94,18.69,17.81,18.47,17.31,16.28,15.44,14.53,13.81,13.03,11.09,9.94,6.28,7.25,5.41,6.56,8.84,11.5,14.16,17.41,19.03,21.09,21.19,20.56,20.91,20.12,19.78,15.81,16.69,13.03,9.44,7.97,4.31,3.28,0.53,0.34,0.31,1.97,4.56,6.44,10.41,12.91,14.88,17.47,17.12,18.66,17.44,16.72,16.53,15.62,13.19,11.75,9.41,8.94,8.28,10.62,10.94,12.91,12.81,14.09,13.53,14.41,15.97,17.59,18.28,20.06,20.25,19.06,17.25,12.91,10.91,7.66,5.75,4.94,5.09,6.31,7.53,9.75,12.5,12.16,16.44,15.44,17.0,14.94,13.66,11.12,7.66,4.72,3.56,1.09,1.66,-0.12,-2.72,1.25,1.47,5.53,10.06,13.44,15.84,18.0,16.94,18.25,19.75,21.09,20.06,21.06,18.06,13.12,7.12,4.16,1.97,0.84,2.19,3.41,5.12,5.28,6.03,7.78,9.03,10.5,13.25,15.69,19.41,22.12,24.59,24.44,22.78,20.5,18.38,17.47,18.5,20.5,23.16,24.84,24.81,22.66,22.19,20.44,18.44,16.81,15.44,13.88,11.91,10.78,9.69,8.53,8.12,8.81,9.09,10.03,9.28,12.69,10.62,9.84,8.5,6.88,4.28,3.0,2.34,5.38,6.47,10.53,12.41,13.59,14.44,13.56,13.62,11.56,11.81,10.03,8.91,8.94,8.88,9.69,9.66,9.62,11.16,12.25,11.41,14.59,15.25,16.78,20.0,21.31,22.53,23.12,22.03,20.53,18.75,15.47,13.69,10.94,9.75,10.81,11.66,13.03,16.44,18.53,21.31,22.06,22.03,22.19,21.28,21.66,21.62,21.78,21.34,19.31,18.03,13.0,13.38,9.88,8.81,8.19,6.56,8.19,9.19,10.66,14.75,17.62,21.0,24.38,25.06,29.28,29.81,28.5,25.66,24.19,19.47,15.16,11.69,9.06,6.91,5.84,6.72,6.97,7.31,7.44,10.41,10.03,11.38,13.69,14.5,14.72,14.97,14.66,14.56,15.5,14.12,14.62,13.5,12.81,9.91,11.94,10.28,11.66,12.34,12.88,13.88,15.47,15.0,15.91,15.81,14.88,16.41,16.72,15.56,18.16,16.75,17.84,16.5,15.31,14.69,12.66,12.06,11.06,8.75,8.97,7.69,5.47,2.88,5.28,2.91,3.25,5.31,4.53,5.5,5.41,4.75,3.81,4.38,3.78,2.03,2.25,3.12,4.38,4.06,7.44,8.41,9.34,11.91,13.41,13.75,14.56,15.34,15.81,16.88,17.19,16.56,15.12,13.25,9.75,6.62,3.81,4.72,3.34,5.25,7.16,8.41,9.47,9.84,10.69,10.66,10.5,10.88,9.88,10.0,9.41,8.19,8.28,5.91,8.53,7.66,7.94,9.5,9.91,10.91,10.66,11.72,11.69,12.88,13.84,14.5,12.94,16.34,16.31,18.19,20.12,21.12,21.12,18.34,16.09,13.28,11.22,10.19,11.16,8.78,12.22,10.91,11.25,12.5,12.78,13.0,13.53,14.44,14.75,16.34,16.34,16.81,16.5,16.56,17.81,18.66,18.81,22.28,22.5,22.66,22.97,19.66,19.62,17.56,15.19,16.19,15.78,15.16,14.94,14.41,14.12,13.12,13.69,12.25,11.94,12.0,11.0,13.41,14.88,15.31,18.81,18.72,21.84,23.53,23.91,25.28,24.38,22.91,20.38,18.94,17.25,16.66,17.19,15.56,15.22,12.81,15.56,12.78,14.72,14.97,14.53,14.28,14.06,14.03,14.25,15.44,17.34,17.31,17.88,17.97,17.53,15.09,13.69,11.78,9.03,7.03,5.19,4.62,3.28,4.66,5.62,5.06,9.97,10.06,11.16,12.94,13.38,12.19,12.91,12.0,10.62,11.03,10.25,9.84,8.31,11.16,10.28,13.06,13.81,14.5,13.94,11.0,10.22,9.09,7.66,9.03,9.44,11.41,12.91,14.25,15.5,15.56,17.47,16.78,15.72,15.44,13.94,13.06,12.06,11.44,11.69,12.22,12.88,13.12,13.62,11.06,12.84,10.03,11.16,11.66,12.91,14.91,17.38,20.0,21.47,22.94,23.06,22.5,21.81,20.5,19.06,18.12,16.72,15.94,13.06,14.19,12.5,13.03,14.0,13.69,13.78,13.5,12.22,12.0,10.53,8.69,6.91,4.69,1.78,0.34,-0.56,-0.84,0.41,2.31,4.94,7.44,8.56,13.81,16.62,19.56,23.72,25.53,25.81,25.41,22.88,19.66,17.25,14.16,12.69,11.94,11.72,11.47,13.16,14.91,16.12,17.19,21.06,20.91,21.69,21.28,18.81,16.88,14.94,13.91,13.31,12.78,12.88,11.69,9.75,9.38,7.12,5.78,4.91,4.28,3.59,2.56,2.19,4.66,5.16,8.34,11.12,11.25,11.53,10.88,10.12,10.12,10.06,10.16,8.5,8.31,6.81,5.25,4.53,4.69,4.75,5.47,5.94,6.72,5.91,5.41,6.0,5.47,6.41,8.81,10.88,12.69,14.56,15.62,15.06,15.25,15.94,16.56,17.12,18.06,-16.19,-13.25,-11.53,-10.72,-8.66,-8.59,-8.53,-7.69,-8.91,-9.09,-9.59,-10.53,-11.66,-12.78,-14.0,-12.91,-12.72,-10.53,-8.38,-6.81,-5.03,-3.84,-4.31,-4.66,-5.19,-5.12,-4.09,-3.88,-4.03,-3.91:negativity
25.5,26.06,28.19,27.75,27.25,25.62,24.56,22.56,21.56,20.88,19.25,16.47,14.72,11.47,9.81,6.62,6.75,7.62,7.84,9.03,9.91,11.0,10.84,10.25,8.5,6.81,3.94,2.12,1.56,1.34,1.12,1.91,1.72,3.06,2.62,5.59,7.09,9.66,10.81,11.88,10.0,10.47,8.5,7.53,8.25,7.88,7.62,6.88,7.44,7.44,6.44,6.44,7.69,5.94,5.47,2.94,2.38,-0.06,-0.09,0.0,-0.34,-1.66,-2.78,-4.34,-5.59,-7.22,-6.25,-6.72,-6.94,-8.97,-9.78,-12.12,-13.38,-13.34,-13.72,-11.69,-12.34,-10.66,-9.31,-6.72,-5.16,-2.47,-2.09,-1.34,-1.97,-1.91,-1.19,-0.19,-0.09,2.66,4.0,5.47,7.06,9.72,10.91,12.03,13.28,13.16,14.84,13.88,14.56,14.0,13.88,14.31,15.34,16.38,18.66,20.78,21.38,23.56,24.12,21.12,23.12,23.97,23.31,23.69,23.78,23.19,20.31,18.56,17.81,15.56,15.44,15.97,15.06,13.94,15.81,16.03,16.12,17.12,17.91,18.25,18.12,17.97,20.41,23.09,26.25,29.69,29.44,28.91,26.25,23.34,22.53,21.16,20.09,21.69,19.59,17.0,14.75,12.31,10.09,9.12,7.88,7.12,9.31,8.38,8.75,10.19,12.19,13.22,16.72,20.53,22.28,21.75,22.53,22.16,20.47,20.38,20.94,20.31,20.03,20.75,20.44,19.31,16.78,17.38,16.16,15.94,15.78,15.62,16.16,15.66,15.0,15.31,15.47,12.62,11.94,11.25,14.22,16.97,18.94,22.38,23.0,21.12,21.88,22.25,22.06,22.34,23.28,23.03,24.41,24.66,25.66,24.59,26.94,24.41,24.44,24.41,24.94,24.12,23.75,20.53,22.0,18.19,20.5,20.91,19.53,19.84,17.31,15.5,14.38,12.69,12.75,13.84,15.31,15.69,15.25,14.5,14.09,14.34,14.5,16.91,20.44,22.78,23.72,24.84,24.44,23.94,23.66,21.78,22.19,21.75,20.69,20.16,20.16,20.09,19.28,18.56,19.31,18.56,17.44,19.69,19.56,22.12,25.53,28.47,30.53,32.28,34.38,31.69,32.31,30.78,28.28,27.59,25.69,23.0,21.47,18.75,15.66,14.84,12.59,12.22,15.44,16.94,19.72,23.31,24.91,25.19,22.59,19.66,20.0,17.0,15.94,17.0,15.59,15.34,13.62,13.47,10.69,10.41,10.12,8.91,9.38,10.5,12.53,12.5,15.66,17.94,18.78,18.25,22.25,21.72,23.06,25.19,26.44,27.16,27.84,28.44,27.62,27.03,22.81,21.84,20.34,16.12,16.81,15.81,14.28,14.41,15.0,16.06,19.31,20.81,23.25,25.12,26.44,25.66,24.09,20.97,21.66,18.88,18.47,18.16,15.72,11.81,13.09,12.19,15.22,21.38,24.5,25.69,25.44,23.44,20.38,17.38,16.69,17.03,16.5,14.84,16.75,14.62,14.94,13.66,14.78,14.22,15.44,17.12,16.31,17.25,18.84,18.06,16.59,19.66,18.38,18.41,19.84,19.81,21.5,22.38,24.25,26.12,30.06,32.66,33.41,35.97,37.38,35.38,33.81,33.03,28.56,27.56,25.09,22.75,22.06,21.0,19.91,18.28,18.06,17.34,16.41,18.16,19.12,19.69,20.19,20.66,17.19,17.16,15.53,16.97,17.78,21.59,21.78,22.56,22.91,23.0,23.56,22.97,24.28,24.44,24.31,26.81,27.09,28.22,28.25,28.0,25.28,23.19,22.38,20.19,20.25,19.56,17.66,18.22,19.06,20.06,23.06,25.03,25.72,25.81,27.03,26.69,25.31,26.16,25.81,25.19,23.72,21.78,19.84,19.12,17.09,16.25,16.12,16.31,14.38,18.91,17.34,20.25,22.5,22.56,22.53,22.09,20.97,18.34,17.34,18.44,16.62,16.06,16.06,11.81,11.06,11.44,10.25,15.19,17.69,22.53,25.78,26.94,27.66,28.78,28.62,27.78,28.16,28.16,26.0,24.41,22.94,19.97,18.44,17.94,16.03,18.88,19.5,21.06,22.41,24.66,24.75,25.25,24.91,25.97,23.5,22.59,22.81,23.69,24.53,24.75,25.78,24.62,24.53,24.19,22.38,23.0,22.06,20.81,18.75,16.75,16.44,16.03,14.69,15.69,15.19,16.12,16.03,16.78,18.06,17.16,18.5,18.06,18.38,19.28,19.03,18.81,18.81,17.53,17.88,15.91,15.81,14.91,13.66,14.0,13.16,14.03,14.78,15.0,19.41,18.09,19.5,19.66,18.03,13.0,14.88,13.16,13.16,14.94,17.12,17.31,18.69,19.56,19.5,20.97,22.25,23.72,25.56,28.56,29.88,31.88,33.5,32.31,31.44,28.41,26.69,23.78,22.25,21.72,22.19,22.25,22.38,23.56,26.09,26.12,27.06,28.59,28.84,29.06,28.03,27.06,27.31,24.47,23.75,25.12,23.25,22.81,23.25,23.06,21.47,19.44,17.81,14.44,11.88,11.53,10.69,10.44,10.69,8.75,10.44,8.44,10.31,10.34,12.69,13.97,14.31,16.25,14.81,16.06,16.31,15.0,14.28,16.69,16.94,17.78,19.41,21.19,22.81,25.5,26.62,27.84,28.06,27.94,28.31,28.75,29.38,27.56,28.78,26.47,26.5,25.31,24.78,23.84,22.44,19.91,17.75,16.56,15.72,16.03,17.81,18.25,17.44,17.44,18.03,15.81,16.62,16.5,14.72,14.09,14.0,13.03,13.88,14.66,14.81,16.31,15.53,16.12,13.91,14.16,12.06,12.12,11.38,11.91,12.5,13.19,13.78,16.75,18.31,21.28,24.19,25.28,26.53,26.56,26.94,25.81,25.94,24.84,24.22,22.69,21.91,20.88,21.56,21.34,23.47,23.72,24.53,24.91,26.12,26.0,26.47,26.59,25.44,25.88,24.19,24.56,23.5,22.66,25.56,27.25,29.16,31.25,33.31,34.0,32.31,31.81,27.75,26.75,23.69,20.56,19.69,17.41,17.47,16.03,15.81,14.69,15.94,15.44,15.5,15.81,14.16,9.94,8.53,7.31,6.03,5.06,6.31,4.16,3.19,0.81,-1.06,-3.16,-2.66,-4.44,-4.47,-6.16,-4.06,-3.94,-1.97,-0.16,1.94,3.44,5.25,7.34,7.72,9.81,10.78,9.47,9.09,8.53,7.88,8.62,9.69,10.84,11.38,11.25,12.94,13.16,14.19,15.41,16.16,16.19,17.34,15.59,17.66,18.16,18.25,19.56,19.69,19.81,18.84,19.72,20.12,22.09,23.53,24.91,25.44,26.0,25.62,26.12,24.94,25.94,25.47,26.19,27.28,27.06,28.69,30.09,31.12,30.72,31.03,31.31,31.0,30.56,31.34,30.38,29.16,28.16,27.19,26.28,25.59,26.72,26.62,26.34,26.94,25.97,24.72,24.84,23.12,22.56,19.78,18.06,17.41,16.97,16.09,18.28,21.94,25.09,29.78,31.56,33.59,32.59,29.81,25.66,22.62,20.16,18.12,18.34,18.16,19.0,18.75,18.0,17.62,16.84,16.69,16.19,17.06,17.12,17.16,17.31,16.44,16.44,16.62,16.0,15.88,17.34,18.81,20.84,22.38,24.56,25.31,26.62,26.03,26.44,25.44,24.38,24.31,22.97,23.78,24.31,25.41,27.09,27.84,29.41,30.0,31.41,32.81,33.97,33.06,33.28,32.28,31.66,32.09,33.16,34.34,36.16,37.66,37.22,39.22,39.12,39.41,39.47,39.31,39.06,37.81,36.28,35.81,34.44,33.69,33.94,34.16,34.12,33.22,32.78,31.69,30.91,28.34,26.06,23.38,19.75,16.38,13.53,11.62,10.62:24.56,22.56,21.56,20.88,19.25,16.47,14.72,11.47,9.81,6.62,6.75,7.62,7.84,9.03,9.91,11.0,10.84,10.25,8.5,6.81,3.94,2.12,1.56,1.34,1.12,1.91,1.72,3.06,2.62,5.59,7.09,9.66,10.81,11.88,10.0,10.47,8.5,7.53,8.25,7.88,7.62,6.88,7.44,7.44,6.44,6.44,7.69,5.94,5.47,2.94,2.38,-0.06,-0.09,0.0,-0.34,-1.66,-2.78,-4.34,-5.59,-7.22,-6.25,-6.72,-6.94,-8.97,-9.78,-12.12,-13.38,-13.34,-13.72,-11.69,-12.34,-10.66,-9.31,-6.72,-5.16,-2.47,-2.09,-1.34,-1.97,-1.91,-1.19,-0.19,-0.09,2.66,4.0,5.47,7.06,9.72,10.91,12.03,13.28,13.16,14.84,13.88,14.56,14.0,13.88,14.31,15.34,16.38,18.66,20.78,21.38,23.56,24.12,21.12,23.12,23.97,23.31,23.69,23.78,23.19,20.31,18.56,17.81,15.56,15.44,15.97,15.06,13.94,15.81,16.03,16.12,17.12,17.91,18.25,18.12,17.97,20.41,23.09,26.25,29.69,29.44,28.91,26.25,23.34,22.53,21.16,20.09,21.69,19.59,17.0,14.75,12.31,10.09,9.12,7.88,7.12,9.31,8.38,8.75,10.19,12.19,13.22,16.72,20.53,22.28,21.75,22.53,22.16,20.47,20.38,20.94,20.31,20.03,20.75,20.44,19.31,16.78,17.38,16.16,15.94,15.78,15.62,16.16,15.66,15.0,15.31,15.47,12.62,11.94,11.25,14.22,16.97,18.94,22.38,23.0,21.12,21.88,22.25,22.06,22.34,23.28,23.03,24.41,24.66,25.66,24.59,26.94,24.41,24.44,24.41,24.94,24.12,23.75,20.53,22.0,18.19,20.5,20.91,19.53,19.84,17.31,15.5,14.38,12.69,12.75,13.84,15.31,15.69,15.25,14.5,14.09,14.34,14.5,16.91,20.44,22.78,23.72,24.84,24.44,23.94,23.66,21.78,22.19,21.75,20.69,20.16,20.16,20.09,19.28,18.56,19.31,18.56,17.44,19.69,19.56,22.12,25.53,28.47,30.53,32.28,34.38,31.69,32.31,30.78,28.28,27.59,25.69,23.0,21.47,18.75,15.66,14.84,12.59,12.22,15.44,16.94,19.72,23.31,24.91,25.19,22.59,19.66,20.0,17.0,15.94,17.0,15.59,15.34,13.62,13.47,10.69,10.41,10.12,8.91,9.38,10.5,12.53,12.5,15.66,17.94,18.78,18.25,22.25,21.72,23.06,25.19,26.44,27.16,27.84,28.44,27.62,27.03,22.81,21.84,20.34,16.12,16.81,15.81,14.28,14.41,15.0,16.06,19.31,20.81,23.25,25.12,26.44,25.66,24.09,20.97,21.66,18.88,18.47,18.16,15.72,11.81,13.09,12.19,15.22,21.38,24.5,25.69,25.44,23.44,20.38,17.38,16.69,17.03,16.5,14.84,16.75,14.62,14.94,13.66,14.78,14.22,15.44,17.12,16.31,17.25,18.84,18.06,16.59,19.66,18.38,18.41,19.84,19.81,21.5,22.38,24.25,26.12,30.06,32.66,33.41,35.97,37.38,35.38,33.81,33.03,28.56,27.56,25.09,22.75,22.06,21.0,19.91,18.28,18.06,17.34,16.41,18.16,19.12,19.69,20.19,20.66,17.19,17.16,15.53,16.97,17.78,21.59,21.78,22.56,22.91,23.0,23.56,22.97,24.28,24.44,24.31,26.81,27.09,28.22,28.25,28.0,25.28,23.19,22.38,20.19,20.25,19.56,17.66,18.22,19.06,20.06,23.06,25.03,25.72,25.81,27.03,26.69,25.31,26.16,25.81,25.19,23.72,21.78,19.84,19.12,17.09,16.25,16.12,16.31,14.38,18.91,17.34,20.25,22.5,22.56,22.53,22.09,20.97,18.34,17.34,18.44,16.62,16.06,16.06,11.81,11.06,11.44,10.25,15.19,17.69,22.53,25.78,26.94,27.66,28.78,28.62,27.78,28.16,28.16,26.0,24.41,22.94,19.97,18.44,17.94,16.03,18.88,19.5,21.06,22.41,24.66,24.75,25.25,24.91,25.97,23.5,22.59,22.81,23.69,24.53,24.75,25.78,24.62,24.53,24.19,22.38,23.0,22.06,20.81,18.75,16.75,16.44,16.03,14.69,15.69,15.19,16.12,16.03,16.78,18.06,17.16,18.5,18.06,18.38,19.28,19.03,18.81,18.81,17.53,17.88,15.91,15.81,14.91,13.66,14.0,13.16,14.03,14.78,15.0,19.41,18.09,19.5,19.66,18.03,13.0,14.88,13.16,13.16,14.94,17.12,17.31,18.69,19.56,19.5,20.97,22.25,23.72,25.56,28.56,29.88,31.88,33.5,32.31,31.44,28.41,26.69,23.78,22.25,21.72,22.19,22.25,22.38,23.56,26.09,26.12,27.06,28.59,28.84,29.06,28.03,27.06,27.31,24.47,23.75,25.12,23.25,22.81,23.25,23.06,21.47,19.44,17.81,14.44,11.88,11.53,10.69,10.44,10.69,8.75,10.44,8.44,10.31,10.34,12.69,13.97,14.31,16.25,14.81,16.06,16.31,15.0,14.28,16.69,16.94,17.78,19.41,21.19,22.81,25.5,26.62,27.84,28.06,27.94,28.31,28.75,29.38,27.56,28.78,26.47,26.5,25.31,24.78,23.84,22.44,19.91,17.75,16.56,15.72,16.03,17.81,18.25,17.44,17.44,18.03,15.81,16.62,16.5,14.72,14.09,14.0,13.03,13.88,14.66,14.81,16.31,15.53,16.12,13.91,14.16,12.06,12.12,11.38,11.91,12.5,13.19,13.78,16.75,18.31,21.28,24.19,25.28,26.53,26.56,26.94,25.81,25.94,24.84,24.22,22.69,21.91,20.88,21.56,21.34,23.47,23.72,24.53,24.91,26.12,26.0,26.47,26.59,25.44,25.88,24.19,24.56,23.5,22.66,25.56,27.25,29.16,31.25,33.31,34.0,32.31,31.81,27.75,26.75,23.69,20.56,19.69,17.41,17.47,16.03,15.81,14.69,15.94,15.44,15.5,15.81,14.16,9.94,8.53,7.31,6.03,5.06,6.31,4.16,3.19,0.81,-1.06,-3.16,-2.66,-4.44,-4.47,-6.16,-4.06,-3.94,-1.97,-0.16,1.94,3.44,5.25,7.34,7.72,9.81,10.78,9.47,9.09,8.53,7.88,8.62,9.69,10.84,11.38,11.25,12.94,13.16,14.19,15.41,16.16,16.19,17.34,15.59,17.66,18.16,18.25,19.56,19.69,19.81,18.84,19.72,20.12,22.09,23.53,24.91,25.44,26.0,25.62,26.12,24.94,25.94,25.47,26.19,27.28,27.06,28.69,30.09,31.12,30.72,31.03,31.31,31.0,30.56,31.34,30.38,29.16,28.16,27.19,26.28,25.59,26.72,26.62,26.34,26.94,25.97,24.72,24.84,23.12,22.56,19.78,18.06,17.41,16.97,16.09,18.28,21.94,25.09,29.78,31.56,33.59,32.59,29.81,25.66,22.62,20.16,18.12,18.34,18.16,19.0,18.75,18.0,17.62,16.84,16.69,16.19,17.06,17.12,17.16,17.31,16.44,16.44,16.62,16.0,15.88,17.34,18.81,20.84,22.38,24.56,25.31,26.62,26.03,26.44,25.44,24.38,24.31,22.97,23.78,24.31,25.41,27.09,27.84,29.41,30.0,31.41,32.81,33.97,33.06,33.28,32.28,31.66,32.09,33.16,34.34,36.16,37.66,37.22,39.22,39.12,39.41,39.47,39.31,39.06,37.81,36.28,35.81,34.44,33.69,33.94,34.16,34.12,33.22,32.78,31.69,30.91,28.34,26.06,23.38,19.75,16.38,13.53,11.62,10.62,7.31,7.38,7.72,8.44,7.78,6.5:14.72,11.47,9.81,6.62,6.75,7.62,7.84,9.03,9.91,11.0,10.84,10.25,8.5,6.81,3.94,2.12,1.56,1.34,1.12,1.91,1.72,3.06,2.62,5.59,7.09,9.66,10.81,11.88,10.0,10.47,8.5,7.53,8.25,7.88,7.62,6.88,7.44,7.44,6.44,6.44,7.69,5.94,5.47,2.94,2.38,-0.06,-0.09,0.0,-0.34,-1.66,-2.78,-4.34,-5.59,-7.22,-6.25,-6.72,-6.94,-8.97,-9.78,-12.12,-13.38,-13.34,-13.72,-11.69,-12.34,-10.66,-9.31,-6.72,-5.16,-2.47,-2.09,-1.34,-1.97,-1.91,-1.19,-0.19,-0.09,2.66,4.0,5.47,7.06,9.72,10.91,12.03,13.28,13.16,14.84,13.88,14.56,14.0,13.88,14.31,15.34,16.38,18.66,20.78,21.38,23.56,24.12,21.12,23.12,23.97,23.31,23.69,23.78,23.19,20.31,18.56,17.81,15.56,15.44,15.97,15.06,13.94,15.81,16.03,16.12,17.12,17.91,18.25,18.12,17.97,20.41,23.09,26.25,29.69,29.44,28.91,26.25,23.34,22.53,21.16,20.09,21.69,19.59,17.0,14.75,12.31,10.09,9.12,7.88,7.12,9.31,8.38,8.75,10.19,12.19,13.22,16.72,20.53,22.28,21.75,22.53,22.16,20.47,20.38,20.94,20.31,20.03,20.75,20.44,19.31,16.78,17.38,16.16,15.94,15.78,15.62,16.16,15.66,15.0,15.31,15.47,12.62,11.94,11.25,14.22,16.97,18.94,22.38,23.0,21.12,21.88,22.25,22.06,22.34,23.28,23.03,24.41,24.66,25.66,24.59,26.94,24.41,24.44,24.41,24.94,24.12,23.75,20.53,22.0,18.19,20.5,20.91,19.53,19.84,17.31,15.5,14.38,12.69,12.75,13.84,15.31,15.69,15.25,14.5,14.09,14.34,14.5,16.91,20.44,22.78,23.72,24.84,24.44,23.94,23.66,21.78,22.19,21.75,20.69,20.16,20.16,20.09,19.28,18.56,19.31,18.56,17.44,19.69,19.56,22.12,25.53,28.47,30.53,32.28,34.38,31.69,32.31,30.78,28.28,27.59,25.69,23.0,21.47,18.75,15.66,14.84,12.59,12.22,15.44,16.94,19.72,23.31,24.91,25.19,22.59,19.66,20.0,17.0,15.94,17.0,15.59,15.34,13.62,13.47,10.69,10.41,10.12,8.91,9.38,10.5,12.53,12.5,15.66,17.94,18.78,18.25,22.25,21.72,23.06,25.19,26.44,27.16,27.84,28.44,27.62,27.03,22.81,21.84,20.34,16.12,16.81,15.81,14.28,14.41,15.0,16.06,19.31,20.81,23.25,25.12,26.44,25.66,24.09,20.97,21.66,18.88,18.47,18.16,15.72,11.81,13.09,12.19,15.22,21.38,24.5,25.69,25.44,23.44,20.38,17.38,16.69,17.03,16.5,14.84,16.75,14.62,14.94,13.66,14.78,14.22,15.44,17.12,16.31,17.25,18.84,18.06,16.59,19.66,18.38,18.41,19.84,19.81,21.5,22.38,24.25,26.12,30.06,32.66,33.41,35.97,37.38,35.38,33.81,33.03,28.56,27.56,25.09,22.75,22.06,21.0,19.91,18.28,18.06,17.34,16.41,18.16,19.12,19.69,20.19,20.66,17.19,17.16,15.53,16.97,17.78,21.59,21.78,22.56,22.91,23.0,23.56,22.97,24.28,24.44,24.31,26.81,27.09,28.22,28.25,28.0,25.28,23.19,22.38,20.19,20.25,19.56,17.66,18.22,19.06,20.06,23.06,25.03,25.72,25.81,27.03,26.69,25.31,26.16,25.81,25.19,23.72,21.78,19.84,19.12,17.09,16.25,16.12,16.31,14.38,18.91,17.34,20.25,22.5,22.56,22.53,22.09,20.97,18.34,17.34,18.44,16.62,16.06,16.06,11.81,11.06,11.44,10.25,15.19,17.69,22.53,25.78,26.94,27.66,28.78,28.62,27.78,28.16,28.16,26.0,24.41,22.94,19.97,18.44,17.94,16.03,18.88,19.5,21.06,22.41,24.66,24.75,25.25,24.91,25.97,23.5,22.59,22.81,23.69,24.53,24.75,25.78,24.62,24.53,24.19,22.38,23.0,22.06,20.81,18.75,16.75,16.44,16.03,14.69,15.69,15.19,16.12,16.03,16.78,18.06,17.16,18.5,18.06,18.38,19.28,19.03,18.81,18.81,17.53,17.88,15.91,15.81,14.91,13.66,14.0,13.16,14.03,14.78,15.0,19.41,18.09,19.5,19.66,18.03,13.0,14.88,13.16,13.16,14.94,17.12,17.31,18.69,19.56,19.5,20.97,22.25,23.72,25.56,28.56,29.88,31.88,33.5,32.31,31.44,28.41,26.69,23.78,22.25,21.72,22.19,22.25,22.38,23.56,26.09,26.12,27.06,28.59,28.84,29.06,28.03,27.06,27.31,24.47,23.75,25.12,23.25,22.81,23.25,23.06,21.47,19.44,17.81,14.44,11.88,11.53,10.69,10.44,10.69,8.75,10.44,8.44,10.31,10.34,12.69,13.97,14.31,16.25,14.81,16.06,16.31,15.0,14.28,16.69,16.94,17.78,19.41,21.19,22.81,25.5,26.62,27.84,28.06,27.94,28.31,28.75,29.38,27.56,28.78,26.47,26.5,25.31,24.78,23.84,22.44,19.91,17.75,16.56,15.72,16.03,17.81,18.25,17.44,17.44,18.03,15.81,16.62,16.5,14.72,14.09,14.0,13.03,13.88,14.66,14.81,16.31,15.53,16.12,13.91,14.16,12.06,12.12,11.38,11.91,12.5,13.19,13.78,16.75,18.31,21.28,24.19,25.28,26.53,26.56,26.94,25.81,25.94,24.84,24.22,22.69,21.91,20.88,21.56,21.34,23.47,23.72,24.53,24.91,26.12,26.0,26.47,26.59,25.44,25.88,24.19,24.56,23.5,22.66,25.56,27.25,29.16,31.25,33.31,34.0,32.31,31.81,27.75,26.75,23.69,20.56,19.69,17.41,17.47,16.03,15.81,14.69,15.94,15.44,15.5,15.81,14.16,9.94,8.53,7.31,6.03,5.06,6.31,4.16,3.19,0.81,-1.06,-3.16,-2.66,-4.44,-4.47,-6.16,-4.06,-3.94,-1.97,-0.16,1.94,3.44,5.25,7.34,7.72,9.81,10.78,9.47,9.09,8.53,7.88,8.62,9.69,10.84,11.38,11.25,12.94,13.16,14.19,15.41,16.16,16.19,17.34,15.59,17.66,18.16,18.25,19.56,19.69,19.81,18.84,19.72,20.12,22.09,23.53,24.91,25.44,26.0,25.62,26.12,24.94,25.94,25.47,26.19,27.28,27.06,28.69,30.09,31.12,30.72,31.03,31.31,31.0,30.56,31.34,30.38,29.16,28.16,27.19,26.28,25.59,26.72,26.62,26.34,26.94,25.97,24.72,24.84,23.12,22.56,19.78,18.06,17.41,16.97,16.09,18.28,21.94,25.09,29.78,31.56,33.59,32.59,29.81,25.66,22.62,20.16,18.12,18.34,18.16,19.0,18.75,18.0,17.62,16.84,16.69,16.19,17.06,17.12,17.16,17.31,16.44,16.44,16.62,16.0,15.88,17.34,18.81,20.84,22.38,24.56,25.31,26.62,26.03,26.44,25.44,24.38,24.31,22.97,23.78,24.31,25.41,27.09,27.84,29.41,30.0,31.41,32.81,33.97,33.06,33.28,32.28,31.66,32.09,33.16,34.34,36.16,37.66,37.22,39.22,39.12,39.41,39.47,39.31,39.06,37.81,36.28,35.81,34.44,33.69,33.94,34.16,34.12,33.22,32.78,31.69,30.91,28.34,26.06,23.38,19.75,16.38,13.53,11.62,10.62,7.31,7.38,7.72,8.44,7.78,6.5,5.28,3.94,3.28,2.34,0.56,-0.66:7.84,9.03,9.91,11.0,10.84,10.25,8.5,6.81,3.94,2.12,1.56,1.34,1.12,1.91,1.72,3.06,2.62,5.59,7.09,9.66,10.81,11.88,10.0,10.47,8.5,7.53,8.25,7.88,7.62,6.88,7.44,7.44,6.44,6.44,7.69,5.94,5.47,2.94,2.38,-0.06,-0.09,0.0,-0.34,-1.66,-2.78,-4.34,-5.59,-7.22,-6.25,-6.72,-6.94,-8.97,-9.78,-12.12,-13.38,-13.34,-13.72,-11.69,-12.34,-10.66,-9.31,-6.72,-5.16,-2.47,-2.09,-1.34,-1.97,-1.91,-1.19,-0.19,-0.09,2.66,4.0,5.47,7.06,9.72,10.91,12.03,13.28,13.16,14.84,13.88,14.56,14.0,13.88,14.31,15.34,16.38,18.66,20.78,21.38,23.56,24.12,21.12,23.12,23.97,23.31,23.69,23.78,23.19,20.31,18.56,17.81,15.56,15.44,15.97,15.06,13.94,15.81,16.03,16.12,17.12,17.91,18.25,18.12,17.97,20.41,23.09,26.25,29.69,29.44,28.91,26.25,23.34,22.53,21.16,20.09,21.69,19.59,17.0,14.75,12.31,10.09,9.12,7.88,7.12,9.31,8.38,8.75,10.19,12.19,13.22,16.72,20.53,22.28,21.75,22.53,22.16,20.47,20.38,20.94,20.31,20.03,20.75,20.44,19.31,16.78,17.38,16.16,15.94,15.78,15.62,16.16,15.66,15.0,15.31,15.47,12.62,11.94,11.25,14.22,16.97,18.94,22.38,23.0,21.12,21.88,22.25,22.06,22.34,23.28,23.03,24.41,24.66,25.66,24.59,26.94,24.41,24.44,24.41,24.94,24.12,23.75,20.53,22.0,18.19,20.5,20.91,19.53,19.84,17.31,15.5,14.38,12.69,12.75,13.84,15.31,15.69,15.25,14.5,14.09,14.34,14.5,16.91,20.44,22.78,23.72,24.84,24.44,23.94,23.66,21.78,22.19,21.75,20.69,20.16,20.16,20.09,19.28,18.56,19.31,18.56,17.44,19.69,19.56,22.12,25.53,28.47,30.53,32.28,34.38,31.69,32.31,30.78,28.28,27.59,25.69,23.0,21.47,18.75,15.66,14.84,12.59,12.22,15.44,16.94,19.72,23.31,24.91,25.19,22.59,19.66,20.0,17.0,15.94,17.0,15.59,15.34,13.62,13.47,10.69,10.41,10.12,8.91,9.38,10.5,12.53,12.5,15.66,17.94,18.78,18.25,22.25,21.72,23.06,25.19,26.44,27.16,27.84,28.44,27.62,27.03,22.81,21.84,20.34,16.12,16.81,15.81,14.28,14.41,15.0,16.06,19.31,20.81,23.25,25.12,26.44,25.66,24.09,20.97,21.66,18.88,18.47,18.16,15.72,11.81,13.09,12.19,15.22,21.38,24.5,25.69,25.44,23.44,20.38,17.38,16.69,17.03,16.5,14.84,16.75,14.62,14.94,13.66,14.78,14.22,15.44,17.12,16.31,17.25,18.84,18.06,16.59,19.66,18.38,18.41,19.84,19.81,21.5,22.38,24.25,26.12,30.06,32.66,33.41,35.97,37.38,35.38,33.81,33.03,28.56,27.56,25.09,22.75,22.06,21.0,19.91,18.28,18.06,17.34,16.41,18.16,19.12,19.69,20.19,20.66,17.19,17.16,15.53,16.97,17.78,21.59,21.78,22.56,22.91,23.0,23.56,22.97,24.28,24.44,24.31,26.81,27.09,28.22,28.25,28.0,25.28,23.19,22.38,20.19,20.25,19.56,17.66,18.22,19.06,20.06,23.06,25.03,25.72,25.81,27.03,26.69,25.31,26.16,25.81,25.19,23.72,21.78,19.84,19.12,17.09,16.25,16.12,16.31,14.38,18.91,17.34,20.25,22.5,22.56,22.53,22.09,20.97,18.34,17.34,18.44,16.62,16.06,16.06,11.81,11.06,11.44,10.25,15.19,17.69,22.53,25.78,26.94,27.66,28.78,28.62,27.78,28.16,28.16,26.0,24.41,22.94,19.97,18.44,17.94,16.03,18.88,19.5,21.06,22.41,24.66,24.75,25.25,24.91,25.97,23.5,22.59,22.81,23.69,24.53,24.75,25.78,24.62,24.53,24.19,22.38,23.0,22.06,20.81,18.75,16.75,16.44,16.03,14.69,15.69,15.19,16.12,16.03,16.78,18.06,17.16,18.5,18.06,18.38,19.28,19.03,18.81,18.81,17.53,17.88,15.91,15.81,14.91,13.66,14.0,13.16,14.03,14.78,15.0,19.41,18.09,19.5,19.66,18.03,13.0,14.88,13.16,13.16,14.94,17.12,17.31,18.69,19.56,19.5,20.97,22.25,23.72,25.56,28.56,29.88,31.88,33.5,32.31,31.44,28.41,26.69,23.78,22.25,21.72,22.19,22.25,22.38,23.56,26.09,26.12,27.06,28.59,28.84,29.06,28.03,27.06,27.31,24.47,23.75,25.12,23.25,22.81,23.25,23.06,21.47,19.44,17.81,14.44,11.88,11.53,10.69,10.44,10.69,8.75,10.44,8.44,10.31,10.34,12.69,13.97,14.31,16.25,14.81,16.06,16.31,15.0,14.28,16.69,16.94,17.78,19.41,21.19,22.81,25.5,26.62,27.84,28.06,27.94,28.31,28.75,29.38,27.56,28.78,26.47,26.5,25.31,24.78,23.84,22.44,19.91,17.75,16.56,15.72,16.03,17.81,18.25,17.44,17.44,18.03,15.81,16.62,16.5,14.72,14.09,14.0,13.03,13.88,14.66,14.81,16.31,15.53,16.12,13.91,14.16,12.06,12.12,11.38,11.91,12.5,13.19,13.78,16.75,18.31,21.28,24.19,25.28,26.53,26.56,26.94,25.81,25.94,24.84,24.22,22.69,21.91,20.88,21.56,21.34,23.47,23.72,24.53,24.91,26.12,26.0,26.47,26.59,25.44,25.88,24.19,24.56,23.5,22.66,25.56,27.25,29.16,31.25,33.31,34.0,32.31,31.81,27.75,26.75,23.69,20.56,19.69,17.41,17.47,16.03,15.81,14.69,15.94,15.44,15.5,15.81,14.16,9.94,8.53,7.31,6.03,5.06,6.31,4.16,3.19,0.81,-1.06,-3.16,-2.66,-4.44,-4.47,-6.16,-4.06,-3.94,-1.97,-0.16,1.94,3.44,5.25,7.34,7.72,9.81,10.78,9.47,9.09,8.53,7.88,8.62,9.69,10.84,11.38,11.25,12.94,13.16,14.19,15.41,16.16,16.19,17.34,15.59,17.66,18.16,18.25,19.56,19.69,19.81,18.84,19.72,20.12,22.09,23.53,24.91,25.44,26.0,25.62,26.12,24.94,25.94,25.47,26.19,27.28,27.06,28.69,30.09,31.12,30.72,31.03,31.31,31.0,30.56,31.34,30.38,29.16,28.16,27.19,26.28,25.59,26.72,26.62,26.34,26.94,25.97,24.72,24.84,23.12,22.56,19.78,18.06,17.41,16.97,16.09,18.28,21.94,25.09,29.78,31.56,33.59,32.59,29.81,25.66,22.62,20.16,18.12,18.34,18.16,19.0,18.75,18.0,17.62,16.84,16.69,16.19,17.06,17.12,17.16,17.31,16.44,16.44,16.62,16.0,15.88,17.34,18.81,20.84,22.38,24.56,25.31,26.62,26.03,26.44,25.44,24.38,24.31,22.97,23.78,24.31,25.41,27.09,27.84,29.41,30.0,31.41,32.81,33.97,33.06,33.28,32.28,31.66,32.09,33.16,34.34,36.16,37.66,37.22,39.22,39.12,39.41,39.47,39.31,39.06,37.81,36.28,35.81,34.44,33.69,33.94,34.16,34.12,33.22,32.78,31.69,30.91,28.34,26.06,23.38,19.75,16.38,13.53,11.62,10.62,7.31,7.38,7.72,8.44,7.78,6.5,5.28,3.94,3.28,2.34,0.56,-0.66,-1.97,-3.28,-3.94,-5.34,-5.44,-4.97:8.5,6.81,3.94,2.12,1.56,1.34,1.12,1.91,1.72,3.06,2.62,5.59,7.09,9.66,10.81,11.88,10.0,10.47,8.5,7.53,8.25,7.88,7.62,6.88,7.44,7.44,6.44,6.44,7.69,5.94,5.47,2.94,2.38,-0.06,-0.09,0.0,-0.34,-1.66,-2.78,-4.34,-5.59,-7.22,-6.25,-6.72,-6.94,-8.97,-9.78,-12.12,-13.38,-13.34,-13.72,-11.69,-12.34,-10.66,-9.31,-6.72,-5.16,-2.47,-2.09,-1.34,-1.97,-1.91,-1.19,-0.19,-0.09,2.66,4.0,5.47,7.06,9.72,10.91,12.03,13.28,13.16,14.84,13.88,14.56,14.0,13.88,14.31,15.34,16.38,18.66,20.78,21.38,23.56,24.12,21.12,23.12,23.97,23.31,23.69,23.78,23.19,20.31,18.56,17.81,15.56,15.44,15.97,15.06,13.94,15.81,16.03,16.12,17.12,17.91,18.25,18.12,17.97,20.41,23.09,26.25,29.69,29.44,28.91,26.25,23.34,22.53,21.16,20.09,21.69,19.59,17.0,14.75,12.31,10.09,9.12,7.88,7.12,9.31,8.38,8.75,10.19,12.19,13.22,16.72,20.53,22.28,21.75,22.53,22.16,20.47,20.38,20.94,20.31,20.03,20.75,20.44,19.31,16.78,17.38,16.16,15.94,15.78,15.62,16.16,15.66,15.0,15.31,15.47,12.62,11.94,11.25,14.22,16.97,18.94,22.38,23.0,21.12,21.88,22.25,22.06,22.34,23.28,23.03,24.41,24.66,25.66,24.59,26.94,24.41,24.44,24.41,24.94,24.12,23.75,20.53,22.0,18.19,20.5,20.91,19.53,19.84,17.31,15.5,14.38,12.69,12.75,13.84,15.31,15.69,15.25,14.5,14.09,14.34,14.5,16.91,20.44,22.78,23.72,24.84,24.44,23.94,23.66,21.78,22.19,21.75,20.69,20.16,20.16,20.09,19.28,18.56,19.31,18.56,17.44,19.69,19.56,22.12,25.53,28.47,30.53,32.28,34.38,31.69,32.31,30.78,28.28,27.59,25.69,23.0,21.47,18.75,15.66,14.84,12.59,12.22,15.44,16.94,19.72,23.31,24.91,25.19,22.59,19.66,20.0,17.0,15.94,17.0,15.59,15.34,13.62,13.47,10.69,10.41,10.12,8.91,9.38,10.5,12.53,12.5,15.66,17.94,18.78,18.25,22.25,21.72,23.06,25.19,26.44,27.16,27.84,28.44,27.62,27.03,22.81,21.84,20.34,16.12,16.81,15.81,14.28,14.41,15.0,16.06,19.31,20.81,23.25,25.12,26.44,25.66,24.09,20.97,21.66,18.88,18.47,18.16,15.72,11.81,13.09,12.19,15.22,21.38,24.5,25.69,25.44,23.44,20.38,17.38,16.69,17.03,16.5,14.84,16.75,14.62,14.94,13.66,14.78,14.22,15.44,17.12,16.31,17.25,18.84,18.06,16.59,19.66,18.38,18.41,19.84,19.81,21.5,22.38,24.25,26.12,30.06,32.66,33.41,35.97,37.38,35.38,33.81,33.03,28.56,27.56,25.09,22.75,22.06,21.0,19.91,18.28,18.06,17.34,16.41,18.16,19.12,19.69,20.19,20.66,17.19,17.16,15.53,16.97,17.78,21.59,21.78,22.56,22.91,23.0,23.56,22.97,24.28,24.44,24.31,26.81,27.09,28.22,28.25,28.0,25.28,23.19,22.38,20.19,20.25,19.56,17.66,18.22,19.06,20.06,23.06,25.03,25.72,25.81,27.03,26.69,25.31,26.16,25.81,25.19,23.72,21.78,19.84,19.12,17.09,16.25,16.12,16.31,14.38,18.91,17.34,20.25,22.5,22.56,22.53,22.09,20.97,18.34,17.34,18.44,16.62,16.06,16.06,11.81,11.06,11.44,10.25,15.19,17.69,22.53,25.78,26.94,27.66,28.78,28.62,27.78,28.16,28.16,26.0,24.41,22.94,19.97,18.44,17.94,16.03,18.88,19.5,21.06,22.41,24.66,24.75,25.25,24.91,25.97,23.5,22.59,22.81,23.69,24.53,24.75,25.78,24.62,24.53,24.19,22.38,23.0,22.06,20.81,18.75,16.75,16.44,16.03,14.69,15.69,15.19,16.12,16.03,16.78,18.06,17.16,18.5,18.06,18.38,19.28,19.03,18.81,18.81,17.53,17.88,15.91,15.81,14.91,13.66,14.0,13.16,14.03,14.78,15.0,19.41,18.09,19.5,19.66,18.03,13.0,14.88,13.16,13.16,14.94,17.12,17.31,18.69,19.56,19.5,20.97,22.25,23.72,25.56,28.56,29.88,31.88,33.5,32.31,31.44,28.41,26.69,23.78,22.25,21.72,22.19,22.25,22.38,23.56,26.09,26.12,27.06,28.59,28.84,29.06,28.03,27.06,27.31,24.47,23.75,25.12,23.25,22.81,23.25,23.06,21.47,19.44,17.81,14.44,11.88,11.53,10.69,10.44,10.69,8.75,10.44,8.44,10.31,10.34,12.69,13.97,14.31,16.25,14.81,16.06,16.31,15.0,14.28,16.69,16.94,17.78,19.41,21.19,22.81,25.5,26.62,27.84,28.06,27.94,28.31,28.75,29.38,27.56,28.78,26.47,26.5,25.31,24.78,23.84,22.44,19.91,17.75,16.56,15.72,16.03,17.81,18.25,17.44,17.44,18.03,15.81,16.62,16.5,14.72,14.09,14.0,13.03,13.88,14.66,14.81,16.31,15.53,16.12,13.91,14.16,12.06,12.12,11.38,11.91,12.5,13.19,13.78,16.75,18.31,21.28,24.19,25.28,26.53,26.56,26.94,25.81,25.94,24.84,24.22,22.69,21.91,20.88,21.56,21.34,23.47,23.72,24.53,24.91,26.12,26.0,26.47,26.59,25.44,25.88,24.19,24.56,23.5,22.66,25.56,27.25,29.16,31.25,33.31,34.0,32.31,31.81,27.75,26.75,23.69,20.56,19.69,17.41,17.47,16.03,15.81,14.69,15.94,15.44,15.5,15.81,14.16,9.94,8.53,7.31,6.03,5.06,6.31,4.16,3.19,0.81,-1.06,-3.16,-2.66,-4.44,-4.47,-6.16,-4.06,-3.94,-1.97,-0.16,1.94,3.44,5.25,7.34,7.72,9.81,10.78,9.47,9.09,8.53,7.88,8.62,9.69,10.84,11.38,11.25,12.94,13.16,14.19,15.41,16.16,16.19,17.34,15.59,17.66,18.16,18.25,19.56,19.69,19.81,18.84,19.72,20.12,22.09,23.53,24.91,25.44,26.0,25.62,26.12,24.94,25.94,25.47,26.19,27.28,27.06,28.69,30.09,31.12,30.72,31.03,31.31,31.0,30.56,31.34,30.38,29.16,28.16,27.19,26.28,25.59,26.72,26.62,26.34,26.94,25.97,24.72,24.84,23.12,22.56,19.78,18.06,17.41,16.97,16.09,18.28,21.94,25.09,29.78,31.56,33.59,32.59,29.81,25.66,22.62,20.16,18.12,18.34,18.16,19.0,18.75,18.0,17.62,16.84,16.69,16.19,17.06,17.12,17.16,17.31,16.44,16.44,16.62,16.0,15.88,17.34,18.81,20.84,22.38,24.56,25.31,26.62,26.03,26.44,25.44,24.38,24.31,22.97,23.78,24.31,25.41,27.09,27.84,29.41,30.0,31.41,32.81,33.97,33.06,33.28,32.28,31.66,32.09,33.16,34.34,36.16,37.66,37.22,39.22,39.12,39.41,39.47,39.31,39.06,37.81,36.28,35.81,34.44,33.69,33.94,34.16,34.12,33.22,32.78,31.69,30.91,28.34,26.06,23.38,19.75,16.38,13.53,11.62,10.62,7.31,7.38,7.72,8.44,7.78,6.5,5.28,3.94,3.28,2.34,0.56,-0.66,-1.97,-3.28,-3.94,-5.34,-5.44,-4.97,-5.38,-3.94,-2.38,-1.06,0.75,1.88:1.12,1.91,1.72,3.06,2.62,5.59,7.09,9.66,10.81,11.88,10.0,10.47,8.5,7.53,8.25,7.88,7.62,6.88,7.44,7.44,6.44,6.44,7.69,5.94,5.47,2.94,2.38,-0.06,-0.09,0.0,-0.34,-1.66,-2.78,-4.34,-5.59,-7.22,-6.25,-6.72,-6.94,-8.97,-9.78,-12.12,-13.38,-13.34,-13.72,-11.69,-12.34,-10.66,-9.31,-6.72,-5.16,-2.47,-2.09,-1.34,-1.97,-1.91,-1.19,-0.19,-0.09,2.66,4.0,5.47,7.06,9.72,10.91,12.03,13.28,13.16,14.84,13.88,14.56,14.0,13.88,14.31,15.34,16.38,18.66,20.78,21.38,23.56,24.12,21.12,23.12,23.97,23.31,23.69,23.78,23.19,20.31,18.56,17.81,15.56,15.44,15.97,15.06,13.94,15.81,16.03,16.12,17.12,17.91,18.25,18.12,17.97,20.41,23.09,26.25,29.69,29.44,28.91,26.25,23.34,22.53,21.16,20.09,21.69,19.59,17.0,14.75,12.31,10.09,9.12,7.88,7.12,9.31,8.38,8.75,10.19,12.19,13.22,16.72,20.53,22.28,21.75,22.53,22.16,20.47,20.38,20.94,20.31,20.03,20.75,20.44,19.31,16.78,17.38,16.16,15.94,15.78,15.62,16.16,15.66,15.0,15.31,15.47,12.62,11.94,11.25,14.22,16.97,18.94,22.38,23.0,21.12,21.88,22.25,22.06,22.34,23.28,23.03,24.41,24.66,25.66,24.59,26.94,24.41,24.44,24.41,24.94,24.12,23.75,20.53,22.0,18.19,20.5,20.91,19.53,19.84,17.31,15.5,14.38,12.69,12.75,13.84,15.31,15.69,15.25,14.5,14.09,14.34,14.5,16.91,20.44,22.78,23.72,24.84,24.44,23.94,23.66,21.78,22.19,21.75,20.69,20.16,20.16,20.09,19.28,18.56,19.31,18.56,17.44,19.69,19.56,22.12,25.53,28.47,30.53,32.28,34.38,31.69,32.31,30.78,28.28,27.59,25.69,23.0,21.47,18.75,15.66,14.84,12.59,12.22,15.44,16.94,19.72,23.31,24.91,25.19,22.59,19.66,20.0,17.0,15.94,17.0,15.59,15.34,13.62,13.47,10.69,10.41,10.12,8.91,9.38,10.5,12.53,12.5,15.66,17.94,18.78,18.25,22.25,21.72,23.06,25.19,26.44,27.16,27.84,28.44,27.62,27.03,22.81,21.84,20.34,16.12,16.81,15.81,14.28,14.41,15.0,16.06,19.31,20.81,23.25,25.12,26.44,25.66,24.09,20.97,21.66,18.88,18.47,18.16,15.72,11.81,13.09,12.19,15.22,21.38,24.5,25.69,25.44,23.44,20.38,17.38,16.69,17.03,16.5,14.84,16.75,14.62,14.94,13.66,14.78,14.22,15.44,17.12,16.31,17.25,18.84,18.06,16.59,19.66,18.38,18.41,19.84,19.81,21.5,22.38,24.25,26.12,30.06,32.66,33.41,35.97,37.38,35.38,33.81,33.03,28.56,27.56,25.09,22.75,22.06,21.0,19.91,18.28,18.06,17.34,16.41,18.16,19.12,19.69,20.19,20.66,17.19,17.16,15.53,16.97,17.78,21.59,21.78,22.56,22.91,23.0,23.56,22.97,24.28,24.44,24.31,26.81,27.09,28.22,28.25,28.0,25.28,23.19,22.38,20.19,20.25,19.56,17.66,18.22,19.06,20.06,23.06,25.03,25.72,25.81,27.03,26.69,25.31,26.16,25.81,25.19,23.72,21.78,19.84,19.12,17.09,16.25,16.12,16.31,14.38,18.91,17.34,20.25,22.5,22.56,22.53,22.09,20.97,18.34,17.34,18.44,16.62,16.06,16.06,11.81,11.06,11.44,10.25,15.19,17.69,22.53,25.78,26.94,27.66,28.78,28.62,27.78,28.16,28.16,26.0,24.41,22.94,19.97,18.44,17.94,16.03,18.88,19.5,21.06,22.41,24.66,24.75,25.25,24.91,25.97,23.5,22.59,22.81,23.69,24.53,24.75,25.78,24.62,24.53,24.19,22.38,23.0,22.06,20.81,18.75,16.75,16.44,16.03,14.69,15.69,15.19,16.12,16.03,16.78,18.06,17.16,18.5,18.06,18.38,19.28,19.03,18.81,18.81,17.53,17.88,15.91,15.81,14.91,13.66,14.0,13.16,14.03,14.78,15.0,19.41,18.09,19.5,19.66,18.03,13.0,14.88,13.16,13.16,14.94,17.12,17.31,18.69,19.56,19.5,20.97,22.25,23.72,25.56,28.56,29.88,31.88,33.5,32.31,31.44,28.41,26.69,23.78,22.25,21.72,22.19,22.25,22.38,23.56,26.09,26.12,27.06,28.59,28.84,29.06,28.03,27.06,27.31,24.47,23.75,25.12,23.25,22.81,23.25,23.06,21.47,19.44,17.81,14.44,11.88,11.53,10.69,10.44,10.69,8.75,10.44,8.44,10.31,10.34,12.69,13.97,14.31,16.25,14.81,16.06,16.31,15.0,14.28,16.69,16.94,17.78,19.41,21.19,22.81,25.5,26.62,27.84,28.06,27.94,28.31,28.75,29.38,27.56,28.78,26.47,26.5,25.31,24.78,23.84,22.44,19.91,17.75,16.56,15.72,16.03,17.81,18.25,17.44,17.44,18.03,15.81,16.62,16.5,14.72,14.09,14.0,13.03,13.88,14.66,14.81,16.31,15.53,16.12,13.91,14.16,12.06,12.12,11.38,11.91,12.5,13.19,13.78,16.75,18.31,21.28,24.19,25.28,26.53,26.56,26.94,25.81,25.94,24.84,24.22,22.69,21.91,20.88,21.56,21.34,23.47,23.72,24.53,24.91,26.12,26.0,26.47,26.59,25.44,25.88,24.19,24.56,23.5,22.66,25.56,27.25,29.16,31.25,33.31,34.0,32.31,31.81,27.75,26.75,23.69,20.56,19.69,17.41,17.47,16.03,15.81,14.69,15.94,15.44,15.5,15.81,14.16,9.94,8.53,7.31,6.03,5.06,6.31,4.16,3.19,0.81,-1.06,-3.16,-2.66,-4.44,-4.47,-6.16,-4.06,-3.94,-1.97,-0.16,1.94,3.44,5.25,7.34,7.72,9.81,10.78,9.47,9.09,8.53,7.88,8.62,9.69,10.84,11.38,11.25,12.94,13.16,14.19,15.41,16.16,16.19,17.34,15.59,17.66,18.16,18.25,19.56,19.69,19.81,18.84,19.72,20.12,22.09,23.53,24.91,25.44,26.0,25.62,26.12,24.94,25.94,25.47,26.19,27.28,27.06,28.69,30.09,31.12,30.72,31.03,31.31,31.0,30.56,31.34,30.38,29.16,28.16,27.19,26.28,25.59,26.72,26.62,26.34,26.94,25.97,24.72,24.84,23.12,22.56,19.78,18.06,17.41,16.97,16.09,18.28,21.94,25.09,29.78,31.56,33.59,32.59,29.81,25.66,22.62,20.16,18.12,18.34,18.16,19.0,18.75,18.0,17.62,16.84,16.69,16.19,17.06,17.12,17.16,17.31,16.44,16.44,16.62,16.0,15.88,17.34,18.81,20.84,22.38,24.56,25.31,26.62,26.03,26.44,25.44,24.38,24.31,22.97,23.78,24.31,25.41,27.09,27.84,29.41,30.0,31.41,32.81,33.97,33.06,33.28,32.28,31.66,32.09,33.16,34.34,36.16,37.66,37.22,39.22,39.12,39.41,39.47,39.31,39.06,37.81,36.28,35.81,34.44,33.69,33.94,34.16,34.12,33.22,32.78,31.69,30.91,28.34,26.06,23.38,19.75,16.38,13.53,11.62,10.62,7.31,7.38,7.72,8.44,7.78,6.5,5.28,3.94,3.28,2.34,0.56,-0.66,-1.97,-3.28,-3.94,-5.34,-5.44,-4.97,-5.38,-3.94,-2.38,-1.06,0.75,1.88,2.16,1.25,0.28,-2.94,-3.28,-4.09:negativity
36.12,36.66,36.47,34.0,32.72,29.03,29.28,27.81,27.16,28.12,31.25,33.19,35.81,38.81,42.5,43.75,43.69,43.59,41.12,38.91,37.28,34.84,33.78,30.97,32.0,29.94,30.0,30.59,30.97,29.97,30.44,29.81,28.19,27.81,27.38,27.84,28.94,31.5,33.34,35.12,35.91,35.09,33.28,30.78,28.88,24.62,26.34,25.91,27.34,29.59,31.0,31.56,32.28,33.12,32.31,32.22,31.22,29.78,29.84,29.12,29.03,28.44,26.94,28.22,25.72,24.81,25.97,23.94,24.5,22.44,21.44,21.56,20.66,20.5,20.66,21.06,21.31,19.66,23.69,24.47,28.34,33.03,36.94,40.62,43.38,43.53,43.53,42.38,42.09,42.16,41.19,39.28,40.09,37.16,38.31,38.16,39.12,41.28,41.91,42.34,41.03,40.03,39.56,38.25,39.34,40.19,40.88,42.56,43.31,45.69,46.06,47.03,47.19,46.81,45.66,44.53,42.5,40.66,38.75,37.28,38.09,39.53,41.72,44.5,47.06,49.31,50.66,51.06,50.94,48.69,47.28,43.0,42.94,42.03,39.81,41.16,41.41,39.5,37.66,35.56,34.03,31.47,30.0,28.81,26.94,26.5,26.12,22.84,26.81,25.94,27.22,28.94,29.12,29.38,28.44,25.03,24.38,23.09,22.62,20.44,25.0,25.44,26.56,29.19,28.62,28.09,25.12,19.69,19.28,14.41,12.84,12.78,13.66,14.62,16.84,18.28,21.44,21.97,22.34,23.19,22.91,19.91,22.0,21.5,21.69,22.47,23.75,26.0,27.75,29.75,31.62,30.59,30.53,28.84,27.31,27.94,29.81,30.09,30.94,32.03,32.25,32.84,32.84,33.56,34.44,30.75,32.94,31.75,31.34,33.12,33.78,34.5,35.34,33.69,32.19,30.75,29.0,26.0,26.5,25.91,27.12,30.44,33.12,33.84,33.88,32.53,30.47,26.56,24.66,24.97,23.28,24.94,28.03,28.97,29.94,31.31,30.28,31.94,31.72,31.97,30.12,32.38,30.41,31.0,32.41,33.91,35.34,36.69,37.75,33.5,35.0,32.41,30.53,30.41,29.06,27.84,24.56,23.56,23.31,24.38,28.28,28.44,35.56,37.12,37.91,37.84,36.44,33.56,30.53,28.25,26.75,25.69,24.75,23.47,23.09,24.5,24.53,27.81,28.81,29.28,29.22,27.53,27.16,27.16,28.84,28.78,32.0,33.78,35.31,36.69,38.0,37.66,37.34,36.5,35.16,32.56,33.5,31.78,30.0,28.84,25.31,22.12,18.97,16.91,16.84,18.06,21.06,23.56,24.19,30.12,31.19,35.09,38.59,41.38,43.0,43.28,43.88,42.78,40.94,40.28,37.97,36.03,35.19,32.03,30.19,30.25,27.78,27.28,27.66,28.41,28.75,29.44,31.06,32.44,33.03,31.78,34.31,32.25,33.72,33.53,34.62,35.25,33.91,31.91,29.69,28.38,26.81,26.94,27.38,29.06,31.38,30.12,32.06,31.88,31.91,33.44,35.34,36.88,37.84,37.53,37.03,33.19,33.66,31.62,32.03,32.94,33.72,35.66,35.66,35.28,34.34,31.22,31.75,29.12,28.81,29.59,30.34,29.44,31.0,30.53,31.66,32.09,31.41,32.91,29.78,33.12,32.34,33.16,34.91,34.44,33.78,32.91,31.53,31.22,30.0,33.78,34.66,36.06,40.0,40.84,41.53,41.69,39.91,38.97,34.0,35.94,34.81,35.5,37.03,39.0,39.72,40.31,39.03,38.5,37.66,36.03,34.81,31.72,33.66,32.44,34.09,37.31,40.94,43.56,46.84,49.06,50.62,50.19,48.41,41.88,40.91,37.91,36.44,37.56,39.75,40.44,40.25,40.31,40.25,39.25,40.28,40.62,38.03,39.31,37.53,37.91,38.06,38.81,38.25,37.53,36.66,36.06,35.5,34.31,36.56,36.44,38.53,40.06,41.75,42.5,43.66,43.25,43.47,42.84,42.19,41.31,41.28,41.28,37.94,40.0,38.5,37.66,38.69,37.31,37.28,35.53,33.25,31.88,32.34,30.06,32.88,33.47,35.09,37.88,39.44,40.06,39.44,37.78,37.06,34.12,30.5,30.41,29.41,29.72,32.06,35.09,39.31,41.03,41.66,42.75,41.25,39.56,38.34,37.16,35.44,36.03,35.84,35.41,36.38,35.94,35.12,33.69,32.69,31.66,30.41,27.56,29.31,28.62,29.5,32.25,34.34,36.28,38.5,41.62,44.56,47.06,48.69,48.78,49.31,47.31,45.06,43.66,40.5,37.09,34.5,30.81,28.31,26.16,24.97,23.88,26.16,26.69,30.34,32.34,33.84,35.34,34.0,31.81,29.41,25.66,23.44,22.06,21.16,21.56,23.0,25.0,27.03,29.03,30.88,32.53,30.69,27.5,26.53,23.41,23.0,25.28,26.28,28.0,29.97,31.75,33.81,36.03,36.91,34.56,36.62,33.75,32.31,31.78,30.5,27.84,28.06,26.44,26.06,26.97,27.5,28.31,29.06,29.34,28.56,28.94,30.41,29.97,30.09,34.88,34.69,36.44,38.56,38.59,38.06,37.31,35.59,34.38,32.28,30.53,28.31,27.56,25.06,29.69,28.97,31.69,33.38,34.03,34.16,33.94,34.0,31.97,34.12,33.47,32.81,32.91,33.16,33.19,33.12,33.56,34.72,35.38,35.81,35.44,36.06,35.56,35.47,32.62,34.59,33.19,34.53,34.81,37.56,39.03,39.97,41.28,40.69,40.94,39.81,36.59,35.97,33.47,30.94,30.38,28.69,28.66,26.91,25.41,24.72,23.31,22.56,22.06,23.25,25.12,26.06,30.19,32.19,33.31,33.53,32.81,30.62,28.25,25.53,24.0,22.16,20.69,20.41,20.28,17.78,22.06,21.16,22.5,25.25,26.47,27.62,27.12,28.5,27.16,27.12,23.94,24.91,25.16,24.94,27.19,27.62,27.5,27.47,25.44,26.0,27.03,27.31,29.5,31.25,32.69,32.38,29.91,30.66,26.62,26.09,25.31,24.78,24.19,23.81,23.88,22.91,25.78,26.09,28.69,30.31,32.91,32.78,33.41,32.81,32.09,33.16,32.69,33.0,32.84,31.69,31.53,30.66,29.56,26.62,26.66,23.94,24.25,24.06,25.72,27.81,29.28,31.5,31.53,32.25,31.03,29.75,28.81,27.41,22.38,23.88,20.62,19.34,19.53,19.06,19.84,21.12,21.88,22.59,24.0,23.47,24.25,23.53,22.78,26.62,28.66,31.28,35.38,38.03,38.91,38.0,35.81,34.19,32.25,30.88,31.91,32.03,33.28,31.34,34.38,34.0,33.94,34.94,34.28,30.81,28.06,25.28,23.91,23.16,23.5,24.5,22.41,25.34,25.41,26.09,28.38,29.62,29.78,29.91,30.19,28.78,30.03,30.25,30.31,31.06,31.16,29.81,28.41,26.56,25.56,24.97,25.22,25.06,28.28,31.16,33.16,36.03,38.22,38.16,37.25,34.31,31.94,27.66,25.19,25.78,24.06,25.03,27.47,27.69,29.38,30.22,31.81,32.62,33.72,34.47,34.22,34.75,35.41,33.72,38.19,38.91,40.25,43.0,42.19,42.03,39.75,38.19,36.69,35.75,34.72,34.75,33.41,32.94,29.06,30.03,29.06,27.12,29.19,29.66,29.44,29.41,29.0,28.59,27.56,27.41,28.31,28.56,28.88,30.84,29.34,30.06,30.56,30.0,30.5,31.19,30.53,29.06,27.81,26.25,25.41,25.44,25.66,25.56,26.09,27.0,28.28,28.66,27.81,31.0,31.25,31.94,33.75,33.28,33.12,31.66,29.72,29.09,28.38,28.56,28.28,28.94,29.47,28.81,29.5:29.28,27.81,27.16,28.12,31.25,33.19,35.81,38.81,42.5,43.75,43.69,43.59,41.12,38.91,37.28,34.84,33.78,30.97,32.0,29.94,30.0,30.59,30.97,29.97,30.44,29.81,28.19,27.81,27.38,27.84,28.94,31.5,33.34,35.12,35.91,35.09,33.28,30.78,28.88,24.62,26.34,25.91,27.34,29.59,31.0,31.56,32.28,33.12,32.31,32.22,31.22,29.78,29.84,29.12,29.03,28.44,26.94,28.22,25.72,24.81,25.97,23.94,24.5,22.44,21.44,21.56,20.66,20.5,20.66,21.06,21.31,19.66,23.69,24.47,28.34,33.03,36.94,40.62,43.38,43.53,43.53,42.38,42.09,42.16,41.19,39.28,40.09,37.16,38.31,38.16,39.12,41.28,41.91,42.34,41.03,40.03,39.56,38.25,39.34,40.19,40.88,42.56,43.31,45.69,46.06,47.03,47.19,46.81,45.66,44.53,42.5,40.66,38.75,37.28,38.09,39.53,41.72,44.5,47.06,49.31,50.66,51.06,50.94,48.69,47.28,43.0,42.94,42.03,39.81,41.16,41.41,39.5,37.66,35.56,34.03,31.47,30.0,28.81,26.94,26.5,26.12,22.84,26.81,25.94,27.22,28.94,29.12,29.38,28.44,25.03,24.38,23.09,22.62,20.44,25.0,25.44,26.56,29.19,28.62,28.09,25.12,19.69,19.28,14.41,12.84,12.78,13.66,14.62,16.84,18.28,21.44,21.97,22.34,23.19,22.91,19.91,22.0,21.5,21.69,22.47,23.75,26.0,27.75,29.75,31.62,30.59,30.53,28.84,27.31,27.94,29.81,30.09,30.94,32.03,32.25,32.84,32.84,33.56,34.44,30.75,32.94,31.75,31.34,33.12,33.78,34.5,35.34,33.69,32.19,30.75,29.0,26.0,26.5,25.91,27.12,30.44,33.12,33.84,33.88,32.53,30.47,26.56,24.66,24.97,23.28,24.94,28.03,28.97,29.94,31.31,30.28,31.94,31.72,31.97,30.12,32.38,30.41,31.0,32.41,33.91,35.34,36.69,37.75,33.5,35.0,32.41,30.53,30.41,29.06,27.84,24.56,23.56,23.31,24.38,28.28,28.44,35.56,37.12,37.91,37.84,36.44,33.56,30.53,28.25,26.75,25.69,24.75,23.47,23.09,24.5,24.53,27.81,28.81,29.28,29.22,27.53,27.16,27.16,28.84,28.78,32.0,33.78,35.31,36.69,38.0,37.66,37.34,36.5,35.16,32.56,33.5,31.78,30.0,28.84,25.31,22.12,18.97,16.91,16.84,18.06,21.06,23.56,24.19,30.12,31.19,35.09,38.59,41.38,43.0,43.28,43.88,42.78,40.94,40.28,37.97,36.03,35.19,32.03,30.19,30.25,27.78,27.28,27.66,28.41,28.75,29.44,31.06,32.44,33.03,31.78,34.31,32.25,33.72,33.53,34.62,35.25,33.91,31.91,29.69,28.38,26.81,26.94,27.38,29.06,31.38,30.12,32.06,31.88,31.91,33.44,35.34,36.88,37.84,37.53,37.03,33.19,33.66,31.62,32.03,32.94,33.72,35.66,35.66,35.28,34.34,31.22,31.75,29.12,28.81,29.59,30.34,29.44,31.0,30.53,31.66,32.09,31.41,32.91,29.78,33.12,32.34,33.16,34.91,34.44,33.78,32.91,31.53,31.22,30.0,33.78,34.66,36.06,40.0,40.84,41.53,41.69,39.91,38.97,34.0,35.94,34.81,35.5,37.03,39.0,39.72,40.31,39.03,38.5,37.66,36.03,34.81,31.72,33.66,32.44,34.09,37.31,40.94,43.56,46.84,49.06,50.62,50.19,48.41,41.88,40.91,37.91,36.44,37.56,39.75,40.44,40.25,40.31,40.25,39.25,40.28,40.62,38.03,39.31,37.53,37.91,38.06,38.81,38.25,37.53,36.66,36.06,35.5,34.31,36.56,36.44,38.53,40.06,41.75,42.5,43.66,43.25,43.47,42.84,42.19,41.31,41.28,41.28,37.94,40.0,38.5,37.66,38.69,37.31,37.28,35.53,33.25,31.88,32.34,30.06,32.88,33.47,35.09,37.88,39.44,40.06,39.44,37.78,37.06,34.12,30.5,30.41,29.41,29.72,32.06,35.09,39.31,41.03,41.66,42.75,41.25,39.56,38.34,37.16,35.44,36.03,35.84,35.41,36.38,35.94,35.12,33.69,32.69,31.66,30.41,27.56,29.31,28.62,29.5,32.25,34.34,36.28,38.5,41.62,44.56,47.06,48.69,48.78,49.31,47.31,45.06,43.66,40.5,37.09,34.5,30.81,28.31,26.16,24.97,23.88,26.16,26.69,30.34,32.34,33.84,35.34,34.0,31.81,29.41,25.66,23.44,22.06,21.16,21.56,23.0,25.0,27.03,29.03,30.88,32.53,30.69,27.5,26.53,23.41,23.0,25.28,26.28,28.0,29.97,31.75,33.81,36.03,36.91,34.56,36.62,33.75,32.31,31.78,30.5,27.84,28.06,26.44,26.06,26.97,27.5,28.31,29.06,29.34,28.56,28.94,30.41,29.97,30.09,34.88,34.69,36.44,38.56,38.59,38.06,37.31,35.59,34.38,32.28,30.53,28.31,27.56,25.06,29.69,28.97,31.69,33.38,34.03,34.16,33.94,34.0,31.97,34.12,33.47,32.81,32.91,33.16,33.19,33.12,33.56,34.72,35.38,35.81,35.44,36.06,35.56,35.47,32.62,34.59,33.19,34.53,34.81,37.56,39.03,39.97,41.28,40.69,40.94,39.81,36.59,35.97,33.47,30.94,30.38,28.69,28.66,26.91,25.41,24.72,23.31,22.56,22.06,23.25,25.12,26.06,30.19,32.19,33.31,33.53,32.81,30.62,28.25,25.53,24.0,22.16,20.69,20.41,20.28,17.78,22.06,21.16,22.5,25.25,26.47,27.62,27.12,28.5,27.16,27.12,23.94,24.91,25.16,24.94,27.19,27.62,27.5,27.47,25.44,26.0,27.03,27.31,29.5,31.25,32.69,32.38,29.91,30.66,26.62,26.09,25.31,24.78,24.19,23.81,23.88,22.91,25.78,26.09,28.69,30.31,32.91,32.78,33.41,32.81,32.09,33.16,32.69,33.0,32.84,31.69,31.53,30.66,29.56,26.62,26.66,23.94,24.25,24.06,25.72,27.81,29.28,31.5,31.53,32.25,31.03,29.75,28.81,27.41,22.38,23.88,20.62,19.34,19.53,19.06,19.84,21.12,21.88,22.59,24.0,23.47,24.25,23.53,22.78,26.62,28.66,31.28,35.38,38.03,38.91,38.0,35.81,34.19,32.25,30.88,31.91,32.03,33.28,31.34,34.38,34.0,33.94,34.94,34.28,30.81,28.06,25.28,23.91,23.16,23.5,24.5,22.41,25.34,25.41,26.09,28.38,29.62,29.78,29.91,30.19,28.78,30.03,30.25,30.31,31.06,31.16,29.81,28.41,26.56,25.56,24.97,25.22,25.06,28.28,31.16,33.16,36.03,38.22,38.16,37.25,34.31,31.94,27.66,25.19,25.78,24.06,25.03,27.47,27.69,29.38,30.22,31.81,32.62,33.72,34.47,34.22,34.75,35.41,33.72,38.19,38.91,40.25,43.0,42.19,42.03,39.75,38.19,36.69,35.75,34.72,34.75,33.41,32.94,29.06,30.03,29.06,27.12,29.19,29.66,29.44,29.41,29.0,28.59,27.56,27.41,28.31,28.56,28.88,30.84,29.34,30.06,30.56,30.0,30.5,31.19,30.53,29.06,27.81,26.25,25.41,25.44,25.66,25.56,26.09,27.0,28.28,28.66,27.81,31.0,31.25,31.94,33.75,33.28,33.12,31.66,29.72,29.09,28.38,28.56,28.28,28.94,29.47,28.81,29.5,3.12,3.97,2.94,0.0,-2.06,-4.0:35.81,38.81,42.5,43.75,43.69,43.59,41.12,38.91,37.28,34.84,33.78,30.97,32.0,29.94,30.0,30.59,30.97,29.97,30.44,29.81,28.19,27.81,27.38,27.84,28.94,31.5,33.34,35.12,35.91,35.09,33.28,30.78,28.88,24.62,26.34,25.91,27.34,29.59,31.0,31.56,32.28,33.12,32.31,32.22,31.22,29.78,29.84,29.12,29.03,28.44,26.94,28.22,25.72,24.81,25.97,23.94,24.5,22.44,21.44,21.56,20.66,20.5,20.66,21.06,21.31,19.66,23.69,24.47,28.34,33.03,36.94,40.62,43.38,43.53,43.53,42.38,42.09,42.16,41.19,39.28,40.09,37.16,38.31,38.16,39.12,41.28,41.91,42.34,41.03,40.03,39.56,38.25,39.34,40.19,40.88,42.56,43.31,45.69,46.06,47.03,47.19,46.81,45.66,44.53,42.5,40.66,38.75,37.28,38.09,39.53,41.72,44.5,47.06,49.31,50.66,51.06,50.94,48.69,47.28,43.0,42.94,42.03,39.81,41.16,41.41,39.5,37.66,35.56,34.03,31.47,30.0,28.81,26.94,26.5,26.12,22.84,26.81,25.94,27.22,28.94,29.12,29.38,28.44,25.03,24.38,23.09,22.62,20.44,25.0,25.44,26.56,29.19,28.62,28.09,25.12,19.69,19.28,14.41,12.84,12.78,13.66,14.62,16.84,18.28,21.44,21.97,22.34,23.19,22.91,19.91,22.0,21.5,21.69,22.47,23.75,26.0,27.75,29.75,31.62,30.59,30.53,28.84,27.31,27.94,29.81,30.09,30.94,32.03,32.25,32.84,32.84,33.56,34.44,30.75,32.94,31.75,31.34,33.12,33.78,34.5,35.34,33.69,32.19,30.75,29.0,26.0,26.5,25.91,27.12,30.44,33.12,33.84,33.88,32.53,30.47,26.56,24.66,24.97,23.28,24.94,28.03,28.97,29.94,31.31,30.28,31.94,31.72,31.97,30.12,32.38,30.41,31.0,32.41,33.91,35.34,36.69,37.75,33.5,35.0,32.41,30.53,30.41,29.06,27.84,24.56,23.56,23.31,24.38,28.28,28.44,35.56,37.12,37.91,37.84,36.44,33.56,30.53,28.25,26.75,25.69,24.75,23.47,23.09,24.5,24.53,27.81,28.81,29.28,29.22,27.53,27.16,27.16,28.84,28.78,32.0,33.78,35.31,36.69,38.0,37.66,37.34,36.5,35.16,32.56,33.5,31.78,30.0,28.84,25.31,22.12,18.97,16.91,16.84,18.06,21.06,23.56,24.19,30.12,31.19,35.09,38.59,41.38,43.0,43.28,43.88,42.78,40.94,40.28,37.97,36.03,35.19,32.03,30.19,30.25,27.78,27.28,27.66,28.41,28.75,29.44,31.06,32.44,33.03,31.78,34.31,32.25,33.72,33.53,34.62,35.25,33.91,31.91,29.69,28.38,26.81,26.94,27.38,29.06,31.38,30.12,32.06,31.88,31.91,33.44,35.34,36.88,37.84,37.53,37.03,33.19,33.66,31.62,32.03,32.94,33.72,35.66,35.66,35.28,34.34,31.22,31.75,29.12,28.81,29.59,30.34,29.44,31.0,30.53,31.66,32.09,31.41,32.91,29.78,33.12,32.34,33.16,34.91,34.44,33.78,32.91,31.53,31.22,30.0,33.78,34.66,36.06,40.0,40.84,41.53,41.69,39.91,38.97,34.0,35.94,34.81,35.5,37.03,39.0,39.72,40.31,39.03,38.5,37.66,36.03,34.81,31.72,33.66,32.44,34.09,37.31,40.94,43.56,46.84,49.06,50.62,50.19,48.41,41.88,40.91,37.91,36.44,37.56,39.75,40.44,40.25,40.31,40.25,39.25,40.28,40.62,38.03,39.31,37.53,37.91,38.06,38.81,38.25,37.53,36.66,36.06,35.5,34.31,36.56,36.44,38.53,40.06,41.75,42.5,43.66,43.25,43.47,42.84,42.19,41.31,41.28,41.28,37.94,40.0,38.5,37.66,38.69,37.31,37.28,35.53,33.25,31.88,32.34,30.06,32.88,33.47,35.09,37.88,39.44,40.06,39.44,37.78,37.06,34.12,30.5,30.41,29.41,29.72,32.06,35.09,39.31,41.03,41.66,42.75,41.25,39.56,38.34,37.16,35.44,36.03,35.84,35.41,36.38,35.94,35.12,33.69,32.69,31.66,30.41,27.56,29.31,28.62,29.5,32.25,34.34,36.28,38.5,41.62,44.56,47.06,48.69,48.78,49.31,47.31,45.06,43.66,40.5,37.09,34.5,30.81,28.31,26.16,24.97,23.88,26.16,26.69,30.34,32.34,33.84,35.34,34.0,31.81,29.41,25.66,23.44,22.06,21.16,21.56,23.0,25.0,27.03,29.03,30.88,32.53,30.69,27.5,26.53,23.41,23.0,25.28,26.28,28.0,29.97,31.75,33.81,36.03,36.91,34.56,36.62,33.75,32.31,31.78,30.5,27.84,28.06,26.44,26.06,26.97,27.5,28.31,29.06,29.34,28.56,28.94,30.41,29.97,30.09,34.88,34.69,36.44,38.56,38.59,38.06,37.31,35.59,34.38,32.28,30.53,28.31,27.56,25.06,29.69,28.97,31.69,33.38,34.03,34.16,33.94,34.0,31.97,34.12,33.47,32.81,32.91,33.16,33.19,33.12,33.56,34.72,35.38,35.81,35.44,36.06,35.56,35.47,32.62,34.59,33.19,34.53,34.81,37.56,39.03,39.97,41.28,40.69,40.94,39.81,36.59,35.97,33.47,30.94,30.38,28.69,28.66,26.91,25.41,24.72,23.31,22.56,22.06,23.25,25.12,26.06,30.19,32.19,33.31,33.53,32.81,30.62,28.25,25.53,24.0,22.16,20.69,20.41,20.28,17.78,22.06,21.16,22.5,25.25,26.47,27.62,27.12,28.5,27.16,27.12,23.94,24.91,25.16,24.94,27.19,27.62,27.5,27.47,25.44,26.0,27.03,27.31,29.5,31.25,32.69,32.38,29.91,30.66,26.62,26.09,25.31,24.78,24.19,23.81,23.88,22.91,25.78,26.09,28.69,30.31,32.91,32.78,33.41,32.81,32.09,33.16,32.69,33.0,32.84,31.69,31.53,30.66,29.56,26.62,26.66,23.94,24.25,24.06,25.72,27.81,29.28,31.5,31.53,32.25,31.03,29.75,28.81,27.41,22.38,23.88,20.62,19.34,19.53,19.06,19.84,21.12,21.88,22.59,24.0,23.47,24.25,23.53,22.78,26.62,28.66,31.28,35.38,38.03,38.91,38.0,35.81,34.19,32.25,30.88,31.91,32.03,33.28,31.34,34.38,34.0,33.94,34.94,34.28,30.81,28.06,25.28,23.91,23.16,23.5,24.5,22.41,25.34,25.41,26.09,28.38,29.62,29.78,29.91,30.19,28.78,30.03,30.25,30.31,31.06,31.16,29.81,28.41,26.56,25.56,24.97,25.22,25.06,28.28,31.16,33.16,36.03,38.22,38.16,37.25,34.31,31.94,27.66,25.19,25.78,24.06,25.03,27.47,27.69,29.38,30.22,31.81,32.62,33.72,34.47,34.22,34.75,35.41,33.72,38.19,38.91,40.25,43.0,42.19,42.03,39.75,38.19,36.69,35.75,34.72,34.75,33.41,32.94,29.06,30.03,29.06,27.12,29.19,29.66,29.44,29.41,29.0,28.59,27.56,27.41,28.31,28.56,28.88,30.84,29.34,30.06,30.56,30.0,30.5,31.19,30.53,29.06,27.81,26.25,25.41,25.44,25.66,25.56,26.09,27.0,28.28,28.66,27.81,31.0,31.25,31.94,33.75,33.28,33.12,31.66,29.72,29.09,28.38,28.56,28.28,28.94,29.47,28.81,29.5,3.12,3.97,2.94,0.0,-2.06,-4.0,-6.34,-8.16,-9.19,-10.12,-11.44,-12.69:41.12,38.91,37.28,34.84,33.78,30.97,32.0,29.94,30.0,30.59,30.97,29.97,30.44,29.81,28.19,27.81,27.38,27.84,28.94,31.5,33.34,35.12,35.91,35.09,33.28,30.78,28.88,24.62,26.34,25.91,27.34,29.59,31.0,31.56,32.28,33.12,32.31,32.22,31.22,29.78,29.84,29.12,29.03,28.44,26.94,28.22,25.72,24.81,25.97,23.94,24.5,22.44,21.44,21.56,20.66,20.5,20.66,21.06,21.31,19.66,23.69,24.47,28.34,33.03,36.94,40.62,43.38,43.53,43.53,42.38,42.09,42.16,41.19,39.28,40.09,37.16,38.31,38.16,39.12,41.28,41.91,42.34,41.03,40.03,39.56,38.25,39.34,40.19,40.88,42.56,43.31,45.69,46.06,47.03,47.19,46.81,45.66,44.53,42.5,40.66,38.75,37.28,38.09,39.53,41.72,44.5,47.06,49.31,50.66,51.06,50.94,48.69,47.28,43.0,42.94,42.03,39.81,41.16,41.41,39.5,37.66,35.56,34.03,31.47,30.0,28.81,26.94,26.5,26.12,22.84,26.81,25.94,27.22,28.94,29.12,29.38,28.44,25.03,24.38,23.09,22.62,20.44,25.0,25.44,26.56,29.19,28.62,28.09,25.12,19.69,19.28,14.41,12.84,12.78,13.66,14.62,16.84,18.28,21.44,21.97,22.34,23.19,22.91,19.91,22.0,21.5,21.69,22.47,23.75,26.0,27.75,29.75,31.62,30.59,30.53,28.84,27.31,27.94,29.81,30.09,30.94,32.03,32.25,32.84,32.84,33.56,34.44,30.75,32.94,31.75,31.34,33.12,33.78,34.5,35.34,33.69,32.19,30.75,29.0,26.0,26.5,25.91,27.12,30.44,33.12,33.84,33.88,32.53,30.47,26.56,24.66,24.97,23.28,24.94,28.03,28.97,29.94,31.31,30.28,31.94,31.72,31.97,30.12,32.38,30.41,31.0,32.41,33.91,35.34,36.69,37.75,33.5,35.0,32.41,30.53,30.41,29.06,27.84,24.56,23.56,23.31,24.38,28.28,28.44,35.56,37.12,37.91,37.84,36.44,33.56,30.53,28.25,26.75,25.69,24.75,23.47,23.09,24.5,24.53,27.81,28.81,29.28,29.22,27.53,27.16,27.16,28.84,28.78,32.0,33.78,35.31,36.69,38.0,37.66,37.34,36.5,35.16,32.56,33.5,31.78,30.0,28.84,25.31,22.12,18.97,16.91,16.84,18.06,21.06,23.56,24.19,30.12,31.19,35.09,38.59,41.38,43.0,43.28,43.88,42.78,40.94,40.28,37.97,36.03,35.19,32.03,30.19,30.25,27.78,27.28,27.66,28.41,28.75,29.44,31.06,32.44,33.03,31.78,34.31,32.25,33.72,33.53,34.62,35.25,33.91,31.91,29.69,28.38,26.81,26.94,27.38,29.06,31.38,30.12,32.06,31.88,31.91,33.44,35.34,36.88,37.84,37.53,37.03,33.19,33.66,31.62,32.03,32.94,33.72,35.66,35.66,35.28,34.34,31.22,31.75,29.12,28.81,29.59,30.34,29.44,31.0,30.53,31.66,32.09,31.41,32.91,29.78,33.12,32.34,33.16,34.91,34.44,33.78,32.91,31.53,31.22,30.0,33.78,34.66,36.06,40.0,40.84,41.53,41.69,39.91,38.97,34.0,35.94,34.81,35.5,37.03,39.0,39.72,40.31,39.03,38.5,37.66,36.03,34.81,31.72,33.66,32.44,34.09,37.31,40.94,43.56,46.84,49.06,50.62,50.19,48.41,41.88,40.91,37.91,36.44,37.56,39.75,40.44,40.25,40.31,40.25,39.25,40.28,40.62,38.03,39.31,37.53,37.91,38.06,38.81,38.25,37.53,36.66,36.06,35.5,34.31,36.56,36.44,38.53,40.06,41.75,42.5,43.66,43.25,43.47,42.84,42.19,41.31,41.28,41.28,37.94,40.0,38.5,37.66,38.69,37.31,37.28,35.53,33.25,31.88,32.34,30.06,32.88,33.47,35.09,37.88,39.44,40.06,39.44,37.78,37.06,34.12,30.5,30.41,29.41,29.72,32.06,35.09,39.31,41.03,41.66,42.75,41.25,39.56,38.34,37.16,35.44,36.03,35.84,35.41,36.38,35.94,35.12,33.69,32.69,31.66,30.41,27.56,29.31,28.62,29.5,32.25,34.34,36.28,38.5,41.62,44.56,47.06,48.69,48.78,49.31,47.31,45.06,43.66,40.5,37.09,34.5,30.81,28.31,26.16,24.97,23.88,26.16,26.69,30.34,32.34,33.84,35.34,34.0,31.81,29.41,25.66,23.44,22.06,21.16,21.56,23.0,25.0,27.03,29.03,30.88,32.53,30.69,27.5,26.53,23.41,23.0,25.28,26.28,28.0,29.97,31.75,33.81,36.03,36.91,34.56,36.62,33.75,32.31,31.78,30.5,27.84,28.06,26.44,26.06,26.97,27.5,28.31,29.06,29.34,28.56,28.94,30.41,29.97,30.09,34.88,34.69,36.44,38.56,38.59,38.06,37.31,35.59,34.38,32.28,30.53,28.31,27.56,25.06,29.69,28.97,31.69,33.38,34.03,34.16,33.94,34.0,31.97,34.12,33.47,32.81,32.91,33.16,33.19,33.12,33.56,34.72,35.38,35.81,35.44,36.06,35.56,35.47,32.62,34.59,33.19,34.53,34.81,37.56,39.03,39.97,41.28,40.69,40.94,39.81,36.59,35.97,33.47,30.94,30.38,28.69,28.66,26.91,25.41,24.72,23.31,22.56,22.06,23.25,25.12,26.06,30.19,32.19,33.31,33.53,32.81,30.62,28.25,25.53,24.0,22.16,20.69,20.41,20.28,17.78,22.06,21.16,22.5,25.25,26.47,27.62,27.12,28.5,27.16,27.12,23.94,24.91,25.16,24.94,27.19,27.62,27.5,27.47,25.44,26.0,27.03,27.31,29.5,31.25,32.69,32.38,29.91,30.66,26.62,26.09,25.31,24.78,24.19,23.81,23.88,22.91,25.78,26.09,28.69,30.31,32.91,32.78,33.41,32.81,32.09,33.16,32.69,33.0,32.84,31.69,31.53,30.66,29.56,26.62,26.66,23.94,24.25,24.06,25.72,27.81,29.28,31.5,31.53,32.25,31.03,29.75,28.81,27.41,22.38,23.88,20.62,19.34,19.53,19.06,19.84,21.12,21.88,22.59,24.0,23.47,24.25,23.53,22.78,26.62,28.66,31.28,35.38,38.03,38.91,38.0,35.81,34.19,32.25,30.88,31.91,32.03,33.28,31.34,34.38,34.0,33.94,34.94,34.28,30.81,28.06,25.28,23.91,23.16,23.5,24.5,22.41,25.34,25.41,26.09,28.38,29.62,29.78,29.91,30.19,28.78,30.03,30.25,30.31,31.06,31.16,29.81,28.41,26.56,25.56,24.97,25.22,25.06,28.28,31.16,33.16,36.03,38.22,38.16,37.25,34.31,31.94,27.66,25.19,25.78,24.06,25.03,27.47,27.69,29.38,30.22,31.81,32.62,33.72,34.47,34.22,34.75,35.41,33.72,38.19,38.91,40.25,43.0,42.19,42.03,39.75,38.19,36.69,35.75,34.72,34.75,33.41,32.94,29.06,30.03,29.06,27.12,29.19,29.66,29.44,29.41,29.0,28.59,27.56,27.41,28.31,28.56,28.88,30.84,29.34,30.06,30.56,30.0,30.5,31.19,30.53,29.06,27.81,26.25,25.41,25.44,25.66,25.56,26.09,27.0,28.28,28.66,27.81,31.0,31.25,31.94,33.75,33.28,33.12,31.66,29.72,29.09,28.38,28.56,28.28,28.94,29.47,28.81,29.5,3.12,3.97,2.94,0.0,-2.06,-4.0,-6.34,-8.16,-9.19,-10.12,-11.44,-12.69,-13.56,-14.91,-16.22,-16.84,-16.78,-16.5:32.0,29.94,30.0,30.59,30.97,29.97,30.44,29.81,28.19,27.81,27.38,27.84,28.94,31.5,33.34,35.12,35.91,35.09,33.28,30.78,28.88,24.62,26.34,25.91,27.34,29.59,31.0,31.56,32.28,33.12,32.31,32.22,31.22,29.78,29.84,29.12,29.03,28.44,26.94,28.22,25.72,24.81,25.97,23.94,24.5,22.44,21.44,21.56,20.66,20.5,20.66,21.06,21.31,19.66,23.69,24.47,28.34,33.03,36.94,40.62,43.38,43.53,43.53,42.38,42.09,42.16,41.19,39.28,40.09,37.16,38.31,38.16,39.12,41.28,41.91,42.34,41.03,40.03,39.56,38.25,39.34,40.19,40.88,42.56,43.31,45.69,46.06,47.03,47.19,46.81,45.66,44.53,42.5,40.66,38.75,37.28,38.09,39.53,41.72,44.5,47.06,49.31,50.66,51.06,50.94,48.69,47.28,43.0,42.94,42.03,39.81,41.16,41.41,39.5,37.66,35.56,34.03,31.47,30.0,28.81,26.94,26.5,26.12,22.84,26.81,25.94,27.22,28.94,29.12,29.38,28.44,25.03,24.38,23.09,22.62,20.44,25.0,25.44,26.56,29.19,28.62,28.09,25.12,19.69,19.28,14.41,12.84,12.78,13.66,14.62,16.84,18.28,21.44,21.97,22.34,23.19,22.91,19.91,22.0,21.5,21.69,22.47,23.75,26.0,27.75,29.75,31.62,30.59,30.53,28.84,27.31,27.94,29.81,30.09,30.94,32.03,32.25,32.84,32.84,33.56,34.44,30.75,32.94,31.75,31.34,33.12,33.78,34.5,35.34,33.69,32.19,30.75,29.0,26.0,26.5,25.91,27.12,30.44,33.12,33.84,33.88,32.53,30.47,26.56,24.66,24.97,23.28,24.94,28.03,28.97,29.94,31.31,30.28,31.94,31.72,31.97,30.12,32.38,30.41,31.0,32.41,33.91,35.34,36.69,37.75,33.5,35.0,32.41,30.53,30.41,29.06,27.84,24.56,23.56,23.31,24.38,28.28,28.44,35.56,37.12,37.91,37.84,36.44,33.56,30.53,28.25,26.75,25.69,24.75,23.47,23.09,24.5,24.53,27.81,28.81,29.28,29.22,27.53,27.16,27.16,28.84,28.78,32.0,33.78,35.31,36.69,38.0,37.66,37.34,36.5,35.16,32.56,33.5,31.78,30.0,28.84,25.31,22.12,18.97,16.91,16.84,18.06,21.06,23.56,24.19,30.12,31.19,35.09,38.59,41.38,43.0,43.28,43.88,42.78,40.94,40.28,37.97,36.03,35.19,32.03,30.19,30.25,27.78,27.28,27.66,28.41,28.75,29.44,31.06,32.44,33.03,31.78,34.31,32.25,33.72,33.53,34.62,35.25,33.91,31.91,29.69,28.38,26.81,26.94,27.38,29.06,31.38,30.12,32.06,31.88,31.91,33.44,35.34,36.88,37.84,37.53,37.03,33.19,33.66,31.62,32.03,32.94,33.72,35.66,35.66,35.28,34.34,31.22,31.75,29.12,28.81,29.59,30.34,29.44,31.0,30.53,31.66,32.09,31.41,32.91,29.78,33.12,32.34,33.16,34.91,34.44,33.78,32.91,31.53,31.22,30.0,33.78,34.66,36.06,40.0,40.84,41.53,41.69,39.91,38.97,34.0,35.94,34.81,35.5,37.03,39.0,39.72,40.31,39.03,38.5,37.66,36.03,34.81,31.72,33.66,32.44,34.09,37.31,40.94,43.56,46.84,49.06,50.62,50.19,48.41,41.88,40.91,37.91,36.44,37.56,39.75,40.44,40.25,40.31,40.25,39.25,40.28,40.62,38.03,39.31,37.53,37.91,38.06,38.81,38.25,37.53,36.66,36.06,35.5,34.31,36.56,36.44,38.53,40.06,41.75,42.5,43.66,43.25,43.47,42.84,42.19,41.31,41.28,41.28,37.94,40.0,38.5,37.66,38.69,37.31,37.28,35.53,33.25,31.88,32.34,30.06,32.88,33.47,35.09,37.88,39.44,40.06,39.44,37.78,37.06,34.12,30.5,30.41,29.41,29.72,32.06,35.09,39.31,41.03,41.66,42.75,41.25,39.56,38.34,37.16,35.44,36.03,35.84,35.41,36.38,35.94,35.12,33.69,32.69,31.66,30.41,27.56,29.31,28.62,29.5,32.25,34.34,36.28,38.5,41.62,44.56,47.06,48.69,48.78,49.31,47.31,45.06,43.66,40.5,37.09,34.5,30.81,28.31,26.16,24.97,23.88,26.16,26.69,30.34,32.34,33.84,35.34,34.0,31.81,29.41,25.66,23.44,22.06,21.16,21.56,23.0,25.0,27.03,29.03,30.88,32.53,30.69,27.5,26.53,23.41,23.0,25.28,26.28,28.0,29.97,31.75,33.81,36.03,36.91,34.56,36.62,33.75,32.31,31.78,30.5,27.84,28.06,26.44,26.06,26.97,27.5,28.31,29.06,29.34,28.56,28.94,30.41,29.97,30.09,34.88,34.69,36.44,38.56,38.59,38.06,37.31,35.59,34.38,32.28,30.53,28.31,27.56,25.06,29.69,28.97,31.69,33.38,34.03,34.16,33.94,34.0,31.97,34.12,33.47,32.81,32.91,33.16,33.19,33.12,33.56,34.72,35.38,35.81,35.44,36.06,35.56,35.47,32.62,34.59,33.19,34.53,34.81,37.56,39.03,39.97,41.28,40.69,40.94,39.81,36.59,35.97,33.47,30.94,30.38,28.69,28.66,26.91,25.41,24.72,23.31,22.56,22.06,23.25,25.12,26.06,30.19,32.19,33.31,33.53,32.81,30.62,28.25,25.53,24.0,22.16,20.69,20.41,20.28,17.78,22.06,21.16,22.5,25.25,26.47,27.62,27.12,28.5,27.16,27.12,23.94,24.91,25.16,24.94,27.19,27.62,27.5,27.47,25.44,26.0,27.03,27.31,29.5,31.25,32.69,32.38,29.91,30.66,26.62,26.09,25.31,24.78,24.19,23.81,23.88,22.91,25.78,26.09,28.69,30.31,32.91,32.78,33.41,32.81,32.09,33.16,32.69,33.0,32.84,31.69,31.53,30.66,29.56,26.62,26.66,23.94,24.25,24.06,25.72,27.81,29.28,31.5,31.53,32.25,31.03,29.75,28.81,27.41,22.38,23.88,20.62,19.34,19.53,19.06,19.84,21.12,21.88,22.59,24.0,23.47,24.25,23.53,22.78,26.62,28.66,31.28,35.38,38.03,38.91,38.0,35.81,34.19,32.25,30.88,31.91,32.03,33.28,31.34,34.38,34.0,33.94,34.94,34.28,30.81,28.06,25.28,23.91,23.16,23.5,24.5,22.41,25.34,25.41,26.09,28.38,29.62,29.78,29.91,30.19,28.78,30.03,30.25,30.31,31.06,31.16,29.81,28.41,26.56,25.56,24.97,25.22,25.06,28.28,31.16,33.16,36.03,38.22,38.16,37.25,34.31,31.94,27.66,25.19,25.78,24.06,25.03,27.47,27.69,29.38,30.22,31.81,32.62,33.72,34.47,34.22,34.75,35.41,33.72,38.19,38.91,40.25,43.0,42.19,42.03,39.75,38.19,36.69,35.75,34.72,34.75,33.41,32.94,29.06,30.03,29.06,27.12,29.19,29.66,29.44,29.41,29.0,28.59,27.56,27.41,28.31,28.56,28.88,30.84,29.34,30.06,30.56,30.0,30.5,31.19,30.53,29.06,27.81,26.25,25.41,25.44,25.66,25.56,26.09,27.0,28.28,28.66,27.81,31.0,31.25,31.94,33.75,33.28,33.12,31.66,29.72,29.09,28.38,28.56,28.28,28.94,29.47,28.81,29.5,3.12,3.97,2.94,0.0,-2.06,-4.0,-6.34,-8.16,-9.19,-10.12,-11.44,-12.69,-13.56,-14.91,-16.22,-16.84,-16.78,-16.5,-15.06,-12.66,-11.72,-9.88,-8.69,-8.03:30.44,29.81,28.19,27.81,27.38,27.84,28.94,31.5,33.34,35.12,35.91,35.09,33.28,30.78,28.88,24.62,26.34,25.91,27.34,29.59,31.0,31.56,32.28,33.12,32.31,32.22,31.22,29.78,29.84,29.12,29.03,28.44,26.94,28.22,25.72,24.81,25.97,23.94,24.5,22.44,21.44,21.56,20.66,20.5,20.66,21.06,21.31,19.66,23.69,24.47,28.34,33.03,36.94,40.62,43.38,43.53,43.53,42.38,42.09,42.16,41.19,39.28,40.09,37.16,38.31,38.16,39.12,41.28,41.91,42.34,41.03,40.03,39.56,38.25,39.34,40.19,40.88,42.56,43.31,45.69,46.06,47.03,47.19,46.81,45.66,44.53,42.5,40.66,38.75,37.28,38.09,39.53,41.72,44.5,47.06,49.31,50.66,51.06,50.94,48.69,47.28,43.0,42.94,42.03,39.81,41.16,41.41,39.5,37.66,35.56,34.03,31.47,30.0,28.81,26.94,26.5,26.12,22.84,26.81,25.94,27.22,28.94,29.12,29.38,28.44,25.03,24.38,23.09,22.62,20.44,25.0,25.44,26.56,29.19,28.62,28.09,25.12,19.69,19.28,14.41,12.84,12.78,13.66,14.62,16.84,18.28,21.44,21.97,22.34,23.19,22.91,19.91,22.0,21.5,21.69,22.47,23.75,26.0,27.75,29.75,31.62,30.59,30.53,28.84,27.31,27.94,29.81,30.09,30.94,32.03,32.25,32.84,32.84,33.56,34.44,30.75,32.94,31.75,31.34,33.12,33.78,34.5,35.34,33.69,32.19,30.75,29.0,26.0,26.5,25.91,27.12,30.44,33.12,33.84,33.88,32.53,30.47,26.56,24.66,24.97,23.28,24.94,28.03,28.97,29.94,31.31,30.28,31.94,31.72,31.97,30.12,32.38,30.41,31.0,32.41,33.91,35.34,36.69,37.75,33.5,35.0,32.41,30.53,30.41,29.06,27.84,24.56,23.56,23.31,24.38,28.28,28.44,35.56,37.12,37.91,37.84,36.44,33.56,30.53,28.25,26.75,25.69,24.75,23.47,23.09,24.5,24.53,27.81,28.81,29.28,29.22,27.53,27.16,27.16,28.84,28.78,32.0,33.78,35.31,36.69,38.0,37.66,37.34,36.5,35.16,32.56,33.5,31.78,30.0,28.84,25.31,22.12,18.97,16.91,16.84,18.06,21.06,23.56,24.19,30.12,31.19,35.09,38.59,41.38,43.0,43.28,43.88,42.78,40.94,40.28,37.97,36.03,35.19,32.03,30.19,30.25,27.78,27.28,27.66,28.41,28.75,29.44,31.06,32.44,33.03,31.78,34.31,32.25,33.72,33.53,34.62,35.25,33.91,31.91,29.69,28.38,26.81,26.94,27.38,29.06,31.38,30.12,32.06,31.88,31.91,33.44,35.34,36.88,37.84,37.53,37.03,33.19,33.66,31.62,32.03,32.94,33.72,35.66,35.66,35.28,34.34,31.22,31.75,29.12,28.81,29.59,30.34,29.44,31.0,30.53,31.66,32.09,31.41,32.91,29.78,33.12,32.34,33.16,34.91,34.44,33.78,32.91,31.53,31.22,30.0,33.78,34.66,36.06,40.0,40.84,41.53,41.69,39.91,38.97,34.0,35.94,34.81,35.5,37.03,39.0,39.72,40.31,39.03,38.5,37.66,36.03,34.81,31.72,33.66,32.44,34.09,37.31,40.94,43.56,46.84,49.06,50.62,50.19,48.41,41.88,40.91,37.91,36.44,37.56,39.75,40.44,40.25,40.31,40.25,39.25,40.28,40.62,38.03,39.31,37.53,37.91,38.06,38.81,38.25,37.53,36.66,36.06,35.5,34.31,36.56,36.44,38.53,40.06,41.75,42.5,43.66,43.25,43.47,42.84,42.19,41.31,41.28,41.28,37.94,40.0,38.5,37.66,38.69,37.31,37.28,35.53,33.25,31.88,32.34,30.06,32.88,33.47,35.09,37.88,39.44,40.06,39.44,37.78,37.06,34.12,30.5,30.41,29.41,29.72,32.06,35.09,39.31,41.03,41.66,42.75,41.25,39.56,38.34,37.16,35.44,36.03,35.84,35.41,36.38,35.94,35.12,33.69,32.69,31.66,30.41,27.56,29.31,28.62,29.5,32.25,34.34,36.28,38.5,41.62,44.56,47.06,48.69,48.78,49.31,47.31,45.06,43.66,40.5,37.09,34.5,30.81,28.31,26.16,24.97,23.88,26.16,26.69,30.34,32.34,33.84,35.34,34.0,31.81,29.41,25.66,23.44,22.06,21.16,21.56,23.0,25.0,27.03,29.03,30.88,32.53,30.69,27.5,26.53,23.41,23.0,25.28,26.28,28.0,29.97,31.75,33.81,36.03,36.91,34.56,36.62,33.75,32.31,31.78,30.5,27.84,28.06,26.44,26.06,26.97,27.5,28.31,29.06,29.34,28.56,28.94,30.41,29.97,30.09,34.88,34.69,36.44,38.56,38.59,38.06,37.31,35.59,34.38,32.28,30.53,28.31,27.56,25.06,29.69,28.97,31.69,33.38,34.03,34.16,33.94,34.0,31.97,34.12,33.47,32.81,32.91,33.16,33.19,33.12,33.56,34.72,35.38,35.81,35.44,36.06,35.56,35.47,32.62,34.59,33.19,34.53,34.81,37.56,39.03,39.97,41.28,40.69,40.94,39.81,36.59,35.97,33.47,30.94,30.38,28.69,28.66,26.91,25.41,24.72,23.31,22.56,22.06,23.25,25.12,26.06,30.19,32.19,33.31,33.53,32.81,30.62,28.25,25.53,24.0,22.16,20.69,20.41,20.28,17.78,22.06,21.16,22.5,25.25,26.47,27.62,27.12,28.5,27.16,27.12,23.94,24.91,25.16,24.94,27.19,27.62,27.5,27.47,25.44,26.0,27.03,27.31,29.5,31.25,32.69,32.38,29.91,30.66,26.62,26.09,25.31,24.78,24.19,23.81,23.88,22.91,25.78,26.09,28.69,30.31,32.91,32.78,33.41,32.81,32.09,33.16,32.69,33.0,32.84,31.69,31.53,30.66,29.56,26.62,26.66,23.94,24.25,24.06,25.72,27.81,29.28,31.5,31.53,32.25,31.03,29.75,28.81,27.41,22.38,23.88,20.62,19.34,19.53,19.06,19.84,21.12,21.88,22.59,24.0,23.47,24.25,23.53,22.78,26.62,28.66,31.28,35.38,38.03,38.91,38.0,35.81,34.19,32.25,30.88,31.91,32.03,33.28,31.34,34.38,34.0,33.94,34.94,34.28,30.81,28.06,25.28,23.91,23.16,23.5,24.5,22.41,25.34,25.41,26.09,28.38,29.62,29.78,29.91,30.19,28.78,30.03,30.25,30.31,31.06,31.16,29.81,28.41,26.56,25.56,24.97,25.22,25.06,28.28,31.16,33.16,36.03,38.22,38.16,37.25,34.31,31.94,27.66,25.19,25.78,24.06,25.03,27.47,27.69,29.38,30.22,31.81,32.62,33.72,34.47,34.22,34.75,35.41,33.72,38.19,38.91,40.25,43.0,42.19,42.03,39.75,38.19,36.69,35.75,34.72,34.75,33.41,32.94,29.06,30.03,29.06,27.12,29.19,29.66,29.44,29.41,29.0,28.59,27.56,27.41,28.31,28.56,28.88,30.84,29.34,30.06,30.56,30.0,30.5,31.19,30.53,29.06,27.81,26.25,25.41,25.44,25.66,25.56,26.09,27.0,28.28,28.66,27.81,31.0,31.25,31.94,33.75,33.28,33.12,31.66,29.72,29.09,28.38,28.56,28.28,28.94,29.47,28.81,29.5,3.12,3.97,2.94,0.0,-2.06,-4.0,-6.34,-8.16,-9.19,-10.12,-11.44,-12.69,-13.56,-14.91,-16.22,-16.84,-16.78,-16.5,-15.06,-12.66,-11.72,-9.88,-8.69,-8.03,-9.94,-8.91,-8.69,-8.16,-6.69,-5.22:negativity
29.0,28.81,32.16,32.12,35.38,37.28,38.91,39.28,42.25,43.97,43.78,47.75,47.06,49.0,47.31,46.06,45.66,43.56,41.94,42.19,40.66,40.94,41.84,43.19,40.91,41.5,41.84,39.59,40.78,40.19,40.44,40.62,39.62,40.25,40.28,41.69,42.78,43.69,44.44,49.94,51.78,55.94,59.47,61.34,60.66,59.03,55.53,54.69,54.31,53.16,52.69,55.19,54.66,53.06,53.72,51.94,49.53,47.38,45.09,40.53,39.53,38.88,39.41,38.06,42.12,41.16,41.25,38.94,35.94,34.59,31.97,29.47,31.47,27.69,31.81,33.03,36.16,38.69,41.34,42.22,41.81,42.06,40.91,39.72,39.88,39.5,38.62,39.06,41.84,42.5,44.22,46.81,48.25,48.16,44.59,44.28,40.81,37.38,35.78,33.59,32.0,34.16,34.19,37.03,39.19,40.06,38.53,36.16,33.16,30.5,26.56,23.69,25.19,23.84,25.31,26.41,27.44,27.94,28.38,25.94,23.06,22.56,21.03,20.44,24.47,28.84,32.06,33.28,34.34,33.81,33.59,31.16,28.69,28.28,27.88,28.62,32.53,35.62,38.19,41.31,42.66,44.12,44.84,45.62,49.31,47.94,49.78,50.16,47.75,43.81,42.34,37.19,37.25,37.16,38.0,40.66,42.84,43.28,45.41,45.81,46.62,47.72,48.03,44.94,48.09,45.59,48.19,50.88,51.47,52.91,50.31,48.28,46.25,41.5,42.38,41.75,43.12,45.06,43.59,45.41,41.91,43.09,43.84,44.97,47.28,47.62,49.38,50.47,50.62,50.88,49.06,50.38,45.34,39.12,41.56,36.5,34.78,35.66,35.44,35.22,34.94,32.44,33.47,31.16,30.84,31.59,32.12,32.47,34.41,32.31,32.5,32.62,32.59,33.22,34.16,36.94,37.31,40.75,42.12,43.56,42.53,40.84,38.5,36.94,34.62,34.31,33.41,32.56,33.88,34.53,36.0,38.62,40.12,43.06,40.59,45.0,43.88,47.62,48.5,50.16,49.56,46.91,44.81,39.91,39.19,36.19,34.5,33.56,33.38,30.84,28.19,28.28,25.28,26.59,27.81,29.28,30.41,34.5,35.56,38.25,41.41,41.91,45.19,43.47,43.38,39.25,37.28,31.0,28.94,26.56,23.88,25.03,24.5,24.91,22.41,25.41,25.41,26.28,31.41,32.09,33.25,34.34,32.88,32.25,32.56,33.44,35.78,40.88,45.41,49.28,50.19,50.84,45.5,43.31,39.56,36.78,34.78,33.09,30.47,30.28,28.66,26.62,25.81,22.28,20.72,16.56,15.12,14.44,14.94,18.44,22.0,25.28,29.91,31.59,33.62,30.56,31.38,28.84,26.59,24.75,24.88,22.44,19.66,20.09,19.06,19.34,17.56,19.41,17.94,20.94,23.88,28.09,32.94,37.31,40.31,37.53,42.41,39.78,38.41,36.22,36.44,33.66,32.34,30.78,30.66,30.06,31.88,33.19,34.62,36.81,38.53,38.56,36.06,38.0,36.47,36.94,37.28,37.62,36.31,31.41,31.84,29.12,29.94,30.81,33.62,37.59,37.88,40.31,41.81,41.94,42.25,42.59,44.91,45.03,45.69,45.75,44.03,41.81,37.47,35.31,31.84,29.31,29.25,27.66,27.06,29.25,30.5,31.69,33.19,34.16,34.66,37.38,36.88,37.09,40.44,39.78,41.72,42.75,39.81,40.06,36.81,34.22,31.09,26.69,24.0,23.66,22.22,25.78,27.44,28.56,28.06,27.28,27.09,25.66,28.5,28.56,30.16,31.94,33.03,31.97,34.66,32.81,34.25,34.91,36.78,35.56,35.78,33.12,29.5,25.81,23.69,22.44,23.19,23.66,24.69,24.16,22.62,21.88,20.44,19.88,18.97,22.38,24.22,25.97,29.12,32.75,32.88,34.28,34.66,35.72,35.91,35.69,34.69,31.5,31.19,28.62,27.31,28.84,31.31,30.75,31.19,32.28,31.09,31.88,30.69,31.62,29.16,24.59,25.25,26.5,26.84,32.5,38.09,41.19,44.69,47.12,48.53,49.0,49.69,50.75,47.91,45.16,46.78,43.94,45.34,45.25,46.16,44.41,44.22,44.0,44.0,42.31,40.59,37.91,35.03,30.5,33.03,31.53,33.97,34.69,34.78,33.78,33.34,31.69,30.31,31.56,31.47,29.84,30.03,29.06,28.81,29.16,30.28,32.31,33.66,33.88,35.56,33.66,32.47,32.69,31.28,31.47,30.53,33.97,35.59,37.94,42.47,46.31,48.38,50.44,53.16,53.78,53.25,53.88,54.28,51.25,50.53,48.62,46.97,44.78,44.44,44.47,41.88,42.19,39.69,38.53,37.16,34.25,34.41,33.69,33.06,34.03,34.94,34.5,35.69,36.06,36.53,37.72,39.59,39.31,38.72,39.34,41.22,43.72,47.53,50.81,54.94,54.94,54.66,52.84,46.03,45.31,40.12,35.56,36.31,35.56,35.56,35.5,35.97,36.28,37.06,36.56,39.12,41.16,44.31,48.47,53.41,56.56,58.28,57.38,56.72,54.88,51.0,47.28,42.69,40.25,37.03,36.75,38.38,39.81,42.78,46.38,48.66,50.91,53.66,53.88,54.94,53.25,55.72,53.41,51.91,49.41,49.59,48.5,47.44,49.66,51.06,52.34,54.16,55.03,55.06,53.44,51.53,48.03,42.94,40.28,37.34,35.09,35.53,31.78,33.03,31.69,32.56,32.44,32.78,34.16,34.03,33.91,34.5,32.72,32.06,30.59,29.19,28.0,24.12,25.66,25.25,25.16,27.66,30.19,31.06,31.12,31.72,31.81,32.03,34.97,32.81,37.41,37.09,37.94,39.56,40.25,40.47,41.62,40.34,38.69,38.31,38.34,37.84,38.56,38.91,40.31,38.53,38.0,37.56,37.16,36.31,37.78,38.09,36.22,40.38,40.31,41.66,44.06,45.91,47.22,47.03,46.22,46.84,45.72,43.62,41.16,38.0,38.0,36.16,37.0,39.0,37.69,36.25,33.16,33.41,33.78,36.72,39.69,43.34,45.19,43.16,44.38,42.69,43.56,43.75,43.06,44.59,44.53,43.22,41.88,39.44,37.34,35.56,33.09,32.62,30.28,32.0,30.5,30.97,32.34,31.28,31.88,30.41,27.47,29.69,28.41,30.09,31.16,35.38,36.06,36.59,36.94,34.5,36.62,37.03,40.38,42.78,43.91,42.03,41.75,39.03,37.72,39.06,40.09,39.66,39.19,39.03,39.91,38.72,40.97,41.91,45.16,45.53,46.53,47.38,47.06,45.28,42.19,42.69,39.62,41.28,41.59,42.38,41.91,42.72,43.47,42.53,42.91,44.69,45.41,44.44,42.91,44.62,42.81,41.56,40.12,40.62,37.47,37.16,37.16,38.28,40.34,41.12,42.19,40.41,40.5,39.0,38.22,35.88,36.16,35.19,33.0,34.56,33.06,33.44,32.22,34.41,34.19,34.56,37.25,39.06,37.16,37.25,35.62,32.78,33.06,30.72,30.0,29.0,29.56,32.31,34.81,37.66,38.06,40.44,38.34,38.59,39.47,39.56,38.69,39.34,35.53,37.62,35.66,38.19,39.81,41.81,42.03,42.41,40.28,39.0,35.94,33.91,30.75,29.81,30.78,29.56,31.31,30.69,30.25,26.34,28.56,26.53,28.44,31.44,33.34,35.91,37.78,39.56,39.69,40.19,40.25,37.47,39.0,37.72,36.53,38.34,40.78,40.78,42.12,41.47,40.19,38.31,37.03,34.75,32.88,33.81,33.5,33.88,35.66,36.19,37.56,37.91,35.19,38.06,34.12,33.91,34.91,33.78,35.25,35.5,35.97,36.41,36.62,35.53,34.31,33.19,32.5,30.69,31.16:38.91,39.28,42.25,43.97,43.78,47.75,47.06,49.0,47.31,46.06,45.66,43.56,41.94,42.19,40.66,40.94,41.84,43.19,40.91,41.5,41.84,39.59,40.78,40.19,40.44,40.62,39.62,40.25,40.28,41.69,42.78,43.69,44.44,49.94,51.78,55.94,59.47,61.34,60.66,59.03,55.53,54.69,54.31,53.16,52.69,55.19,54.66,53.06,53.72,51.94,49.53,47.38,45.09,40.53,39.53,38.88,39.41,38.06,42.12,41.16,41.25,38.94,35.94,34.59,31.97,29.47,31.47,27.69,31.81,33.03,36.16,38.69,41.34,42.22,41.81,42.06,40.91,39.72,39.88,39.5,38.62,39.06,41.84,42.5,44.22,46.81,48.25,48.16,44.59,44.28,40.81,37.38,35.78,33.59,32.0,34.16,34.19,37.03,39.19,40.06,38.53,36.16,33.16,30.5,26.56,23.69,25.19,23.84,25.31,26.41,27.44,27.94,28.38,25.94,23.06,22.56,21.03,20.44,24.47,28.84,32.06,33.28,34.34,33.81,33.59,31.16,28.69,28.28,27.88,28.62,32.53,35.62,38.19,41.31,42.66,44.12,44.84,45.62,49.31,47.94,49.78,50.16,47.75,43.81,42.34,37.19,37.25,37.16,38.0,40.66,42.84,43.28,45.41,45.81,46.62,47.72,48.03,44.94,48.09,45.59,48.19,50.88,51.47,52.91,50.31,48.28,46.25,41.5,42.38,41.75,43.12,45.06,43.59,45.41,41.91,43.09,43.84,44.97,47.28,47.62,49.38,50.47,50.62,50.88,49.06,50.38,45.34,39.12,41.56,36.5,34.78,35.66,35.44,35.22,34.94,32.44,33.47,31.16,30.84,31.59,32.12,32.47,34.41,32.31,32.5,32.62,32.59,33.22,34.16,36.94,37.31,40.75,42.12,43.56,42.53,40.84,38.5,36.94,34.62,34.31,33.41,32.56,33.88,34.53,36.0,38.62,40.12,43.06,40.59,45.0,43.88,47.62,48.5,50.16,49.56,46.91,44.81,39.91,39.19,36.19,34.5,33.56,33.38,30.84,28.19,28.28,25.28,26.59,27.81,29.28,30.41,34.5,35.56,38.25,41.41,41.91,45.19,43.47,43.38,39.25,37.28,31.0,28.94,26.56,23.88,25.03,24.5,24.91,22.41,25.41,25.41,26.28,31.41,32.09,33.25,34.34,32.88,32.25,32.56,33.44,35.78,40.88,45.41,49.28,50.19,50.84,45.5,43.31,39.56,36.78,34.78,33.09,30.47,30.28,28.66,26.62,25.81,22.28,20.72,16.56,15.12,14.44,14.94,18.44,22.0,25.28,29.91,31.59,33.62,30.56,31.38,28.84,26.59,24.75,24.88,22.44,19.66,20.09,19.06,19.34,17.56,19.41,17.94,20.94,23.88,28.09,32.94,37.31,40.31,37.53,42.41,39.78,38.41,36.22,36.44,33.66,32.34,30.78,30.66,30.06,31.88,33.19,34.62,36.81,38.53,38.56,36.06,38.0,36.47,36.94,37.28,37.62,36.31,31.41,31.84,29.12,29.94,30.81,33.62,37.59,37.88,40.31,41.81,41.94,42.25,42.59,44.91,45.03,45.69,45.75,44.03,41.81,37.47,35.31,31.84,29.31,29.25,27.66,27.06,29.25,30.5,31.69,33.19,34.16,34.66,37.38,36.88,37.09,40.44,39.78,41.72,42.75,39.81,40.06,36.81,34.22,31.09,26.69,24.0,23.66,22.22,25.78,27.44,28.56,28.06,27.28,27.09,25.66,28.5,28.56,30.16,31.94,33.03,31.97,34.66,32.81,34.25,34.91,36.78,35.56,35.78,33.12,29.5,25.81,23.69,22.44,23.19,23.66,24.69,24.16,22.62,21.88,20.44,19.88,18.97,22.38,24.22,25.97,29.12,32.75,32.88,34.28,34.66,35.72,35.91,35.69,34.69,31.5,31.19,28.62,27.31,28.84,31.31,30.75,31.19,32.28,31.09,31.88,30.69,31.62,29.16,24.59,25.25,26.5,26.84,32.5,38.09,41.19,44.69,47.12,48.53,49.0,49.69,50.75,47.91,45.16,46.78,43.94,45.34,45.25,46.16,44.41,44.22,44.0,44.0,42.31,40.59,37.91,35.03,30.5,33.03,31.53,33.97,34.69,34.78,33.78,33.34,31.69,30.31,31.56,31.47,29.84,30.03,29.06,28.81,29.16,30.28,32.31,33.66,33.88,35.56,33.66,32.47,32.69,31.28,31.47,30.53,33.97,35.59,37.94,42.47,46.31,48.38,50.44,53.16,53.78,53.25,53.88,54.28,51.25,50.53,48.62,46.97,44.78,44.44,44.47,41.88,42.19,39.69,38.53,37.16,34.25,34.41,33.69,33.06,34.03,34.94,34.5,35.69,36.06,36.53,37.72,39.59,39.31,38.72,39.34,41.22,43.72,47.53,50.81,54.94,54.94,54.66,52.84,46.03,45.31,40.12,35.56,36.31,35.56,35.56,35.5,35.97,36.28,37.06,36.56,39.12,41.16,44.31,48.47,53.41,56.56,58.28,57.38,56.72,54.88,51.0,47.28,42.69,40.25,37.03,36.75,38.38,39.81,42.78,46.38,48.66,50.91,53.66,53.88,54.94,53.25,55.72,53.41,51.91,49.41,49.59,48.5,47.44,49.66,51.06,52.34,54.16,55.03,55.06,53.44,51.53,48.03,42.94,40.28,37.34,35.09,35.53,31.78,33.03,31.69,32.56,32.44,32.78,34.16,34.03,33.91,34.5,32.72,32.06,30.59,29.19,28.0,24.12,25.66,25.25,25.16,27.66,30.19,31.06,31.12,31.72,31.81,32.03,34.97,32.81,37.41,37.09,37.94,39.56,40.25,40.47,41.62,40.34,38.69,38.31,38.34,37.84,38.56,38.91,40.31,38.53,38.0,37.56,37.16,36.31,37.78,38.09,36.22,40.38,40.31,41.66,44.06,45.91,47.22,47.03,46.22,46.84,45.72,43.62,41.16,38.0,38.0,36.16,37.0,39.0,37.69,36.25,33.16,33.41,33.78,36.72,39.69,43.34,45.19,43.16,44.38,42.69,43.56,43.75,43.06,44.59,44.53,43.22,41.88,39.44,37.34,35.56,33.09,32.62,30.28,32.0,30.5,30.97,32.34,31.28,31.88,30.41,27.47,29.69,28.41,30.09,31.16,35.38,36.06,36.59,36.94,34.5,36.62,37.03,40.38,42.78,43.91,42.03,41.75,39.03,37.72,39.06,40.09,39.66,39.19,39.03,39.91,38.72,40.97,41.91,45.16,45.53,46.53,47.38,47.06,45.28,42.19,42.69,39.62,41.28,41.59,42.38,41.91,42.72,43.47,42.53,42.91,44.69,45.41,44.44,42.91,44.62,42.81,41.56,40.12,40.62,37.47,37.16,37.16,38.28,40.34,41.12,42.19,40.41,40.5,39.0,38.22,35.88,36.16,35.19,33.0,34.56,33.06,33.44,32.22,34.41,34.19,34.56,37.25,39.06,37.16,37.25,35.62,32.78,33.06,30.72,30.0,29.0,29.56,32.31,34.81,37.66,38.06,40.44,38.34,38.59,39.47,39.56,38.69,39.34,35.53,37.62,35.66,38.19,39.81,41.81,42.03,42.41,40.28,39.0,35.94,33.91,30.75,29.81,30.78,29.56,31.31,30.69,30.25,26.34,28.56,26.53,28.44,31.44,33.34,35.91,37.78,39.56,39.69,40.19,40.25,37.47,39.0,37.72,36.53,38.34,40.78,40.78,42.12,41.47,40.19,38.31,37.03,34.75,32.88,33.81,33.5,33.88,35.66,36.19,37.56,37.91,35.19,38.06,34.12,33.91,34.91,33.78,35.25,35.5,35.97,36.41,36.62,35.53,34.31,33.19,32.5,30.69,31.16,-17.94,-17.72,-16.16,-15.41,-10.53,-7.03:47.06,49.0,47.31,46.06,45.66,43.56,41.94,42.19,40.66,40.94,41.84,43.19,40.91,41.5,41.84,39.59,40.78,40.19,40.44,40.62,39.62,40.25,40.28,41.69,42.78,43.69,44.44,49.94,51.78,55.94,59.47,61.34,60.66,59.03,55.53,54.69,54.31,53.16,52.69,55.19,54.66,53.06,53.72,51.94,49.53,47.38,45.09,40.53,39.53,38.88,39.41,38.06,42.12,41.16,41.25,38.94,35.94,34.59,31.97,29.47,31.47,27.69,31.81,33.03,36.16,38.69,41.34,42.22,41.81,42.06,40.91,39.72,39.88,39.5,38.62,39.06,41.84,42.5,44.22,46.81,48.25,48.16,44.59,44.28,40.81,37.38,35.78,33.59,32.0,34.16,34.19,37.03,39.19,40.06,38.53,36.16,33.16,30.5,26.56,23.69,25.19,23.84,25.31,26.41,27.44,27.94,28.38,25.94,23.06,22.56,21.03,20.44,24.47,28.84,32.06,33.28,34.34,33.81,33.59,31.16,28.69,28.28,27.88,28.62,32.53,35.62,38.19,41.31,42.66,44.12,44.84,45.62,49.31,47.94,49.78,50.16,47.75,43.81,42.34,37.19,37.25,37.16,38.0,40.66,42.84,43.28,45.41,45.81,46.62,47.72,48.03,44.94,48.09,45.59,48.19,50.88,51.47,52.91,50.31,48.28,46.25,41.5,42.38,41.75,43.12,45.06,43.59,45.41,41.91,43.09,43.84,44.97,47.28,47.62,49.38,50.47,50.62,50.88,49.06,50.38,45.34,39.12,41.56,36.5,34.78,35.66,35.44,35.22,34.94,32.44,33.47,31.16,30.84,31.59,32.12,32.47,34.41,32.31,32.5,32.62,32.59,33.22,34.16,36.94,37.31,40.75,42.12,43.56,42.53,40.84,38.5,36.94,34.62,34.31,33.41,32.56,33.88,34.53,36.0,38.62,40.12,43.06,40.59,45.0,43.88,47.62,48.5,50.16,49.56,46.91,44.81,39.91,39.19,36.19,34.5,33.56,33.38,30.84,28.19,28.28,25.28,26.59,27.81,29.28,30.41,34.5,35.56,38.25,41.41,41.91,45.19,43.47,43.38,39.25,37.28,31.0,28.94,26.56,23.88,25.03,24.5,24.91,22.41,25.41,25.41,26.28,31.41,32.09,33.25,34.34,32.88,32.25,32.56,33.44,35.78,40.88,45.41,49.28,50.19,50.84,45.5,43.31,39.56,36.78,34.78,33.09,30.47,30.28,28.66,26.62,25.81,22.28,20.72,16.56,15.12,14.44,14.94,18.44,22.0,25.28,29.91,31.59,33.62,30.56,31.38,28.84,26.59,24.75,24.88,22.44,19.66,20.09,19.06,19.34,17.56,19.41,17.94,20.94,23.88,28.09,32.94,37.31,40.31,37.53,42.41,39.78,38.41,36.22,36.44,33.66,32.34,30.78,30.66,30.06,31.88,33.19,34.62,36.81,38.53,38.56,36.06,38.0,36.47,36.94,37.28,37.62,36.31,31.41,31.84,29.12,29.94,30.81,33.62,37.59,37.88,40.31,41.81,41.94,42.25,42.59,44.91,45.03,45.69,45.75,44.03,41.81,37.47,35.31,31.84,29.31,29.25,27.66,27.06,29.25,30.5,31.69,33.19,34.16,34.66,37.38,36.88,37.09,40.44,39.78,41.72,42.75,39.81,40.06,36.81,34.22,31.09,26.69,24.0,23.66,22.22,25.78,27.44,28.56,28.06,27.28,27.09,25.66,28.5,28.56,30.16,31.94,33.03,31.97,34.66,32.81,34.25,34.91,36.78,35.56,35.78,33.12,29.5,25.81,23.69,22.44,23.19,23.66,24.69,24.16,22.62,21.88,20.44,19.88,18.97,22.38,24.22,25.97,29.12,32.75,32.88,34.28,34.66,35.72,35.91,35.69,34.69,31.5,31.19,28.62,27.31,28.84,31.31,30.75,31.19,32.28,31.09,31.88,30.69,31.62,29.16,24.59,25.25,26.5,26.84,32.5,38.09,41.19,44.69,47.12,48.53,49.0,49.69,50.75,47.91,45.16,46.78,43.94,45.34,45.25,46.16,44.41,44.22,44.0,44.0,42.31,40.59,37.91,35.03,30.5,33.03,31.53,33.97,34.69,34.78,33.78,33.34,31.69,30.31,31.56,31.47,29.84,30.03,29.06,28.81,29.16,30.28,32.31,33.66,33.88,35.56,33.66,32.47,32.69,31.28,31.47,30.53,33.97,35.59,37.94,42.47,46.31,48.38,50.44,53.16,53.78,53.25,53.88,54.28,51.25,50.53,48.62,46.97,44.78,44.44,44.47,41.88,42.19,39.69,38.53,37.16,34.25,34.41,33.69,33.06,34.03,34.94,34.5,35.69,36.06,36.53,37.72,39.59,39.31,38.72,39.34,41.22,43.72,47.53,50.81,54.94,54.94,54.66,52.84,46.03,45.31,40.12,35.56,36.31,35.56,35.56,35.5,35.97,36.28,37.06,36.56,39.12,41.16,44.31,48.47,53.41,56.56,58.28,57.38,56.72,54.88,51.0,47.28,42.69,40.25,37.03,36.75,38.38,39.81,42.78,46.38,48.66,50.91,53.66,53.88,54.94,53.25,55.72,53.41,51.91,49.41,49.59,48.5,47.44,49.66,51.06,52.34,54.16,55.03,55.06,53.44,51.53,48.03,42.94,40.28,37.34,35.09,35.53,31.78,33.03,31.69,32.56,32.44,32.78,34.16,34.03,33.91,34.5,32.72,32.06,30.59,29.19,28.0,24.12,25.66,25.25,25.16,27.66,30.19,31.06,31.12,31.72,31.81,32.03,34.97,32.81,37.41,37.09,37.94,39.56,40.25,40.47,41.62,40.34,38.69,38.31,38.34,37.84,38.56,38.91,40.31,38.53,38.0,37.56,37.16,36.31,37.78,38.09,36.22,40.38,40.31,41.66,44.06,45.91,47.22,47.03,46.22,46.84,45.72,43.62,41.16,38.0,38.0,36.16,37.0,39.0,37.69,36.25,33.16,33.41,33.78,36.72,39.69,43.34,45.19,43.16,44.38,42.69,43.56,43.75,43.06,44.59,44.53,43.22,41.88,39.44,37.34,35.56,33.09,32.62,30.28,32.0,30.5,30.97,32.34,31.28,31.88,30.41,27.47,29.69,28.41,30.09,31.16,35.38,36.06,36.59,36.94,34.5,36.62,37.03,40.38,42.78,43.91,42.03,41.75,39.03,37.72,39.06,40.09,39.66,39.19,39.03,39.91,38.72,40.97,41.91,45.16,45.53,46.53,47.38,47.06,45.28,42.19,42.69,39.62,41.28,41.59,42.38,41.91,42.72,43.47,42.53,42.91,44.69,45.41,44.44,42.91,44.62,42.81,41.56,40.12,40.62,37.47,37.16,37.16,38.28,40.34,41.12,42.19,40.41,40.5,39.0,38.22,35.88,36.16,35.19,33.0,34.56,33.06,33.44,32.22,34.41,34.19,34.56,37.25,39.06,37.16,37.25,35.62,32.78,33.06,30.72,30.0,29.0,29.56,32.31,34.81,37.66,38.06,40.44,38.34,38.59,39.47,39.56,38.69,39.34,35.53,37.62,35.66,38.19,39.81,41.81,42.03,42.41,40.28,39.0,35.94,33.91,30.75,29.81,30.78,29.56,31.31,30.69,30.25,26.34,28.56,26.53,28.44,31.44,33.34,35.91,37.78,39.56,39.69,40.19,40.25,37.47,39.0,37.72,36.53,38.34,40.78,40.78,42.12,41.47,40.19,38.31,37.03,34.75,32.88,33.81,33.5,33.88,35.66,36.19,37.56,37.91,35.19,38.06,34.12,33.91,34.91,33.78,35.25,35.5,35.97,36.41,36.62,35.53,34.31,33.19,32.5,30.69,31.16,-17.94,-17.72,-16.16,-15.41,-10.53,-7.03,-5.97,-3.84,-1.72,1.12,2.25,5.66:41.94,42.19,40.66,40.94,41.84,43.19,40.91,41.5,41.84,39.59,40.78,40.19,40.44,40.62,39.62,40.25,40.28,41.69,42.78,43.69,44.44,49.94,51.78,55.94,59.47,61.34,60.66,59.03,55.53,54.69,54.31,53.16,52.69,55.19,54.66,53.06,53.72,51.94,49.53,47.38,45.09,40.53,39.53,38.88,39.41,38.06,42.12,41.16,41.25,38.94,35.94,34.59,31.97,29.47,31.47,27.69,31.81,33.03,36.16,38.69,41.34,42.22,41.81,42.06,40.91,39.72,39.88,39.5,38.62,39.06,41.84,42.5,44.22,46.81,48.25,48.16,44.59,44.28,40.81,37.38,35.78,33.59,32.0,34.16,34.19,37.03,39.19,40.06,38.53,36.16,33.16,30.5,26.56,23.69,25.19,23.84,25.31,26.41,27.44,27.94,28.38,25.94,23.06,22.56,21.03,20.44,24.47,28.84,32.06,33.28,34.34,33.81,33.59,31.16,28.69,28.28,27.88,28.62,32.53,35.62,38.19,41.31,42.66,44.12,44.84,45.62,49.31,47.94,49.78,50.16,47.75,43.81,42.34,37.19,37.25,37.16,38.0,40.66,42.84,43.28,45.41,45.81,46.62,47.72,48.03,44.94,48.09,45.59,48.19,50.88,51.47,52.91,50.31,48.28,46.25,41.5,42.38,41.75,43.12,45.06,43.59,45.41,41.91,43.09,43.84,44.97,47.28,47.62,49.38,50.47,50.62,50.88,49.06,50.38,45.34,39.12,41.56,36.5,34.78,35.66,35.44,35.22,34.94,32.44,33.47,31.16,30.84,31.59,32.12,32.47,34.41,32.31,32.5,32.62,32.59,33.22,34.16,36.94,37.31,40.75,42.12,43.56,42.53,40.84,38.5,36.94,34.62,34.31,33.41,32.56,33.88,34.53,36.0,38.62,40.12,43.06,40.59,45.0,43.88,47.62,48.5,50.16,49.56,46.91,44.81,39.91,39.19,36.19,34.5,33.56,33.38,30.84,28.19,28.28,25.28,26.59,27.81,29.28,30.41,34.5,35.56,38.25,41.41,41.91,45.19,43.47,43.38,39.25,37.28,31.0,28.94,26.56,23.88,25.03,24.5,24.91,22.41,25.41,25.41,26.28,31.41,32.09,33.25,34.34,32.88,32.25,32.56,33.44,35.78,40.88,45.41,49.28,50.19,50.84,45.5,43.31,39.56,36.78,34.78,33.09,30.47,30.28,28.66,26.62,25.81,22.28,20.72,16.56,15.12,14.44,14.94,18.44,22.0,25.28,29.91,31.59,33.62,30.56,31.38,28.84,26.59,24.75,24.88,22.44,19.66,20.09,19.06,19.34,17.56,19.41,17.94,20.94,23.88,28.09,32.94,37.31,40.31,37.53,42.41,39.78,38.41,36.22,36.44,33.66,32.34,30.78,30.66,30.06,31.88,33.19,34.62,36.81,38.53,38.56,36.06,38.0,36.47,36.94,37.28,37.62,36.31,31.41,31.84,29.12,29.94,30.81,33.62,37.59,37.88,40.31,41.81,41.94,42.25,42.59,44.91,45.03,45.69,45.75,44.03,41.81,37.47,35.31,31.84,29.31,29.25,27.66,27.06,29.25,30.5,31.69,33.19,34.16,34.66,37.38,36.88,37.09,40.44,39.78,41.72,42.75,39.81,40.06,36.81,34.22,31.09,26.69,24.0,23.66,22.22,25.78,27.44,28.56,28.06,27.28,27.09,25.66,28.5,28.56,30.16,31.94,33.03,31.97,34.66,32.81,34.25,34.91,36.78,35.56,35.78,33.12,29.5,25.81,23.69,22.44,23.19,23.66,24.69,24.16,22.62,21.88,20.44,19.88,18.97,22.38,24.22,25.97,29.12,32.75,32.88,34.28,34.66,35.72,35.91,35.69,34.69,31.5,31.19,28.62,27.31,28.84,31.31,30.75,31.19,32.28,31.09,31.88,30.69,31.62,29.16,24.59,25.25,26.5,26.84,32.5,38.09,41.19,44.69,47.12,48.53,49.0,49.69,50.75,47.91,45.16,46.78,43.94,45.34,45.25,46.16,44.41,44.22,44.0,44.0,42.31,40.59,37.91,35.03,30.5,33.03,31.53,33.97,34.69,34.78,33.78,33.34,31.69,30.31,31.56,31.47,29.84,30.03,29.06,28.81,29.16,30.28,32.31,33.66,33.88,35.56,33.66,32.47,32.69,31.28,31.47,30.53,33.97,35.59,37.94,42.47,46.31,48.38,50.44,53.16,53.78,53.25,53.88,54.28,51.25,50.53,48.62,46.97,44.78,44.44,44.47,41.88,42.19,39.69,38.53,37.16,34.25,34.41,33.69,33.06,34.03,34.94,34.5,35.69,36.06,36.53,37.72,39.59,39.31,38.72,39.34,41.22,43.72,47.53,50.81,54.94,54.94,54.66,52.84,46.03,45.31,40.12,35.56,36.31,35.56,35.56,35.5,35.97,36.28,37.06,36.56,39.12,41.16,44.31,48.47,53.41,56.56,58.28,57.38,56.72,54.88,51.0,47.28,42.69,40.25,37.03,36.75,38.38,39.81,42.78,46.38,48.66,50.91,53.66,53.88,54.94,53.25,55.72,53.41,51.91,49.41,49.59,48.5,47.44,49.66,51.06,52.34,54.16,55.03,55.06,53.44,51.53,48.03,42.94,40.28,37.34,35.09,35.53,31.78,33.03,31.69,32.56,32.44,32.78,34.16,34.03,33.91,34.5,32.72,32.06,30.59,29.19,28.0,24.12,25.66,25.25,25.16,27.66,30.19,31.06,31.12,31.72,31.81,32.03,34.97,32.81,37.41,37.09,37.94,39.56,40.25,40.47,41.62,40.34,38.69,38.31,38.34,37.84,38.56,38.91,40.31,38.53,38.0,37.56,37.16,36.31,37.78,38.09,36.22,40.38,40.31,41.66,44.06,45.91,47.22,47.03,46.22,46.84,45.72,43.62,41.16,38.0,38.0,36.16,37.0,39.0,37.69,36.25,33.16,33.41,33.78,36.72,39.69,43.34,45.19,43.16,44.38,42.69,43.56,43.75,43.06,44.59,44.53,43.22,41.88,39.44,37.34,35.56,33.09,32.62,30.28,32.0,30.5,30.97,32.34,31.28,31.88,30.41,27.47,29.69,28.41,30.09,31.16,35.38,36.06,36.59,36.94,34.5,36.62,37.03,40.38,42.78,43.91,42.03,41.75,39.03,37.72,39.06,40.09,39.66,39.19,39.03,39.91,38.72,40.97,41.91,45.16,45.53,46.53,47.38,47.06,45.28,42.19,42.69,39.62,41.28,41.59,42.38,41.91,42.72,43.47,42.53,42.91,44.69,45.41,44.44,42.91,44.62,42.81,41.56,40.12,40.62,37.47,37.16,37.16,38.28,40.34,41.12,42.19,40.41,40.5,39.0,38.22,35.88,36.16,35.19,33.0,34.56,33.06,33.44,32.22,34.41,34.19,34.56,37.25,39.06,37.16,37.25,35.62,32.78,33.06,30.72,30.0,29.0,29.56,32.31,34.81,37.66,38.06,40.44,38.34,38.59,39.47,39.56,38.69,39.34,35.53,37.62,35.66,38.19,39.81,41.81,42.03,42.41,40.28,39.0,35.94,33.91,30.75,29.81,30.78,29.56,31.31,30.69,30.25,26.34,28.56,26.53,28.44,31.44,33.34,35.91,37.78,39.56,39.69,40.19,40.25,37.47,39.0,37.72,36.53,38.34,40.78,40.78,42.12,41.47,40.19,38.31,37.03,34.75,32.88,33.81,33.5,33.88,35.66,36.19,37.56,37.91,35.19,38.06,34.12,33.91,34.91,33.78,35.25,35.5,35.97,36.41,36.62,35.53,34.31,33.19,32.5,30.69,31.16,-17.94,-17.72,-16.16,-15.41,-10.53,-7.03,-5.97,-3.84,-1.72,1.12,2.25,5.66,7.53,7.78,6.31,5.41,3.88,1.97:40.91,41.5,41.84,39.59,40.78,40.19,40.44,40.62,39.62,40.25,40.28,41.69,42.78,43.69,44.44,49.94,51.78,55.94,59.47,61.34,60.66,59.03,55.53,54.69,54.31,53.16,52.69,55.19,54.66,53.06,53.72,51.94,49.53,47.38,45.09,40.53,39.53,38.88,39.41,38.06,42.12,41.16,41.25,38.94,35.94,34.59,31.97,29.47,31.47,27.69,31.81,33.03,36.16,38.69,41.34,42.22,41.81,42.06,40.91,39.72,39.88,39.5,38.62,39.06,41.84,42.5,44.22,46.81,48.25,48.16,44.59,44.28,40.81,37.38,35.78,33.59,32.0,34.16,34.19,37.03,39.19,40.06,38.53,36.16,33.16,30.5,26.56,23.69,25.19,23.84,25.31,26.41,27.44,27.94,28.38,25.94,23.06,22.56,21.03,20.44,24.47,28.84,32.06,33.28,34.34,33.81,33.59,31.16,28.69,28.28,27.88,28.62,32.53,35.62,38.19,41.31,42.66,44.12,44.84,45.62,49.31,47.94,49.78,50.16,47.75,43.81,42.34,37.19,37.25,37.16,38.0,40.66,42.84,43.28,45.41,45.81,46.62,47.72,48.03,44.94,48.09,45.59,48.19,50.88,51.47,52.91,50.31,48.28,46.25,41.5,42.38,41.75,43.12,45.06,43.59,45.41,41.91,43.09,43.84,44.97,47.28,47.62,49.38,50.47,50.62,50.88,49.06,50.38,45.34,39.12,41.56,36.5,34.78,35.66,35.44,35.22,34.94,32.44,33.47,31.16,30.84,31.59,32.12,32.47,34.41,32.31,32.5,32.62,32.59,33.22,34.16,36.94,37.31,40.75,42.12,43.56,42.53,40.84,38.5,36.94,34.62,34.31,33.41,32.56,33.88,34.53,36.0,38.62,40.12,43.06,40.59,45.0,43.88,47.62,48.5,50.16,49.56,46.91,44.81,39.91,39.19,36.19,34.5,33.56,33.38,30.84,28.19,28.28,25.28,26.59,27.81,29.28,30.41,34.5,35.56,38.25,41.41,41.91,45.19,43.47,43.38,39.25,37.28,31.0,28.94,26.56,23.88,25.03,24.5,24.91,22.41,25.41,25.41,26.28,31.41,32.09,33.25,34.34,32.88,32.25,32.56,33.44,35.78,40.88,45.41,49.28,50.19,50.84,45.5,43.31,39.56,36.78,34.78,33.09,30.47,30.28,28.66,26.62,25.81,22.28,20.72,16.56,15.12,14.44,14.94,18.44,22.0,25.28,29.91,31.59,33.62,30.56,31.38,28.84,26.59,24.75,24.88,22.44,19.66,20.09,19.06,19.34,17.56,19.41,17.94,20.94,23.88,28.09,32.94,37.31,40.31,37.53,42.41,39.78,38.41,36.22,36.44,33.66,32.34,30.78,30.66,30.06,31.88,33.19,34.62,36.81,38.53,38.56,36.06,38.0,36.47,36.94,37.28,37.62,36.31,31.41,31.84,29.12,29.94,30.81,33.62,37.59,37.88,40.31,41.81,41.94,42.25,42.59,44.91,45.03,45.69,45.75,44.03,41.81,37.47,35.31,31.84,29.31,29.25,27.66,27.06,29.25,30.5,31.69,33.19,34.16,34.66,37.38,36.88,37.09,40.44,39.78,41.72,42.75,39.81,40.06,36.81,34.22,31.09,26.69,24.0,23.66,22.22,25.78,27.44,28.56,28.06,27.28,27.09,25.66,28.5,28.56,30.16,31.94,33.03,31.97,34.66,32.81,34.25,34.91,36.78,35.56,35.78,33.12,29.5,25.81,23.69,22.44,23.19,23.66,24.69,24.16,22.62,21.88,20.44,19.88,18.97,22.38,24.22,25.97,29.12,32.75,32.88,34.28,34.66,35.72,35.91,35.69,34.69,31.5,31.19,28.62,27.31,28.84,31.31,30.75,31.19,32.28,31.09,31.88,30.69,31.62,29.16,24.59,25.25,26.5,26.84,32.5,38.09,41.19,44.69,47.12,48.53,49.0,49.69,50.75,47.91,45.16,46.78,43.94,45.34,45.25,46.16,44.41,44.22,44.0,44.0,42.31,40.59,37.91,35.03,30.5,33.03,31.53,33.97,34.69,34.78,33.78,33.34,31.69,30.31,31.56,31.47,29.84,30.03,29.06,28.81,29.16,30.28,32.31,33.66,33.88,35.56,33.66,32.47,32.69,31.28,31.47,30.53,33.97,35.59,37.94,42.47,46.31,48.38,50.44,53.16,53.78,53.25,53.88,54.28,51.25,50.53,48.62,46.97,44.78,44.44,44.47,41.88,42.19,39.69,38.53,37.16,34.25,34.41,33.69,33.06,34.03,34.94,34.5,35.69,36.06,36.53,37.72,39.59,39.31,38.72,39.34,41.22,43.72,47.53,50.81,54.94,54.94,54.66,52.84,46.03,45.31,40.12,35.56,36.31,35.56,35.56,35.5,35.97,36.28,37.06,36.56,39.12,41.16,44.31,48.47,53.41,56.56,58.28,57.38,56.72,54.88,51.0,47.28,42.69,40.25,37.03,36.75,38.38,39.81,42.78,46.38,48.66,50.91,53.66,53.88,54.94,53.25,55.72,53.41,51.91,49.41,49.59,48.5,47.44,49.66,51.06,52.34,54.16,55.03,55.06,53.44,51.53,48.03,42.94,40.28,37.34,35.09,35.53,31.78,33.03,31.69,32.56,32.44,32.78,34.16,34.03,33.91,34.5,32.72,32.06,30.59,29.19,28.0,24.12,25.66,25.25,25.16,27.66,30.19,31.06,31.12,31.72,31.81,32.03,34.97,32.81,37.41,37.09,37.94,39.56,40.25,40.47,41.62,40.34,38.69,38.31,38.34,37.84,38.56,38.91,40.31,38.53,38.0,37.56,37.16,36.31,37.78,38.09,36.22,40.38,40.31,41.66,44.06,45.91,47.22,47.03,46.22,46.84,45.72,43.62,41.16,38.0,38.0,36.16,37.0,39.0,37.69,36.25,33.16,33.41,33.78,36.72,39.69,43.34,45.19,43.16,44.38,42.69,43.56,43.75,43.06,44.59,44.53,43.22,41.88,39.44,37.34,35.56,33.09,32.62,30.28,32.0,30.5,30.97,32.34,31.28,31.88,30.41,27.47,29.69,28.41,30.09,31.16,35.38,36.06,36.59,36.94,34.5,36.62,37.03,40.38,42.78,43.91,42.03,41.75,39.03,37.72,39.06,40.09,39.66,39.19,39.03,39.91,38.72,40.97,41.91,45.16,45.53,46.53,47.38,47.06,45.28,42.19,42.69,39.62,41.28,41.59,42.38,41.91,42.72,43.47,42.53,42.91,44.69,45.41,44.44,42.91,44.62,42.81,41.56,40.12,40.62,37.47,37.16,37.16,38.28,40.34,41.12,42.19,40.41,40.5,39.0,38.22,35.88,36.16,35.19,33.0,34.56,33.06,33.44,32.22,34.41,34.19,34.56,37.25,39.06,37.16,37.25,35.62,32.78,33.06,30.72,30.0,29.0,29.56,32.31,34.81,37.66,38.06,40.44,38.34,38.59,39.47,39.56,38.69,39.34,35.53,37.62,35.66,38.19,39.81,41.81,42.03,42.41,40.28,39.0,35.94,33.91,30.75,29.81,30.78,29.56,31.31,30.69,30.25,26.34,28.56,26.53,28.44,31.44,33.34,35.91,37.78,39.56,39.69,40.19,40.25,37.47,39.0,37.72,36.53,38.34,40.78,40.78,42.12,41.47,40.19,38.31,37.03,34.75,32.88,33.81,33.5,33.88,35.66,36.19,37.56,37.91,35.19,38.06,34.12,33.91,34.91,33.78,35.25,35.5,35.97,36.41,36.62,35.53,34.31,33.19,32.5,30.69,31.16,-17.94,-17.72,-16.16,-15.41,-10.53,-7.03,-5.97,-3.84,-1.72,1.12,2.25,5.66,7.53,7.78,6.31,5.41,3.88,1.97,1.41,-0.47,-0.94,-2.59,-0.66,-1.81:40.44,40.62,39.62,40.25,40.28,41.69,42.78,43.69,44.44,49.94,51.78,55.94,59.47,61.34,60.66,59.03,55.53,54.69,54.31,53.16,52.69,55.19,54.66,53.06,53.72,51.94,49.53,47.38,45.09,40.53,39.53,38.88,39.41,38.06,42.12,41.16,41.25,38.94,35.94,34.59,31.97,29.47,31.47,27.69,31.81,33.03,36.16,38.69,41.34,42.22,41.81,42.06,40.91,39.72,39.88,39.5,38.62,39.06,41.84,42.5,44.22,46.81,48.25,48.16,44.59,44.28,40.81,37.38,35.78,33.59,32.0,34.16,34.19,37.03,39.19,40.06,38.53,36.16,33.16,30.5,26.56,23.69,25.19,23.84,25.31,26.41,27.44,27.94,28.38,25.94,23.06,22.56,21.03,20.44,24.47,28.84,32.06,33.28,34.34,33.81,33.59,31.16,28.69,28.28,27.88,28.62,32.53,35.62,38.19,41.31,42.66,44.12,44.84,45.62,49.31,47.94,49.78,50.16,47.75,43.81,42.34,37.19,37.25,37.16,38.0,40.66,42.84,43.28,45.41,45.81,46.62,47.72,48.03,44.94,48.09,45.59,48.19,50.88,51.47,52.91,50.31,48.28,46.25,41.5,42.38,41.75,43.12,45.06,43.59,45.41,41.91,43.09,43.84,44.97,47.28,47.62,49.38,50.47,50.62,50.88,49.06,50.38,45.34,39.12,41.56,36.5,34.78,35.66,35.44,35.22,34.94,32.44,33.47,31.16,30.84,31.59,32.12,32.47,34.41,32.31,32.5,32.62,32.59,33.22,34.16,36.94,37.31,40.75,42.12,43.56,42.53,40.84,38.5,36.94,34.62,34.31,33.41,32.56,33.88,34.53,36.0,38.62,40.12,43.06,40.59,45.0,43.88,47.62,48.5,50.16,49.56,46.91,44.81,39.91,39.19,36.19,34.5,33.56,33.38,30.84,28.19,28.28,25.28,26.59,27.81,29.28,30.41,34.5,35.56,38.25,41.41,41.91,45.19,43.47,43.38,39.25,37.28,31.0,28.94,26.56,23.88,25.03,24.5,24.91,22.41,25.41,25.41,26.28,31.41,32.09,33.25,34.34,32.88,32.25,32.56,33.44,35.78,40.88,45.41,49.28,50.19,50.84,45.5,43.31,39.56,36.78,34.78,33.09,30.47,30.28,28.66,26.62,25.81,22.28,20.72,16.56,15.12,14.44,14.94,18.44,22.0,25.28,29.91,31.59,33.62,30.56,31.38,28.84,26.59,24.75,24.88,22.44,19.66,20.09,19.06,19.34,17.56,19.41,17.94,20.94,23.88,28.09,32.94,37.31,40.31,37.53,42.41,39.78,38.41,36.22,36.44,33.66,32.34,30.78,30.66,30.06,31.88,33.19,34.62,36.81,38.53,38.56,36.06,38.0,36.47,36.94,37.28,37.62,36.31,31.41,31.84,29.12,29.94,30.81,33.62,37.59,37.88,40.31,41.81,41.94,42.25,42.59,44.91,45.03,45.69,45.75,44.03,41.81,37.47,35.31,31.84,29.31,29.25,27.66,27.06,29.25,30.5,31.69,33.19,34.16,34.66,37.38,36.88,37.09,40.44,39.78,41.72,42.75,39.81,40.06,36.81,34.22,31.09,26.69,24.0,23.66,22.22,25.78,27.44,28.56,28.06,27.28,27.09,25.66,28.5,28.56,30.16,31.94,33.03,31.97,34.66,32.81,34.25,34.91,36.78,35.56,35.78,33.12,29.5,25.81,23.69,22.44,23.19,23.66,24.69,24.16,22.62,21.88,20.44,19.88,18.97,22.38,24.22,25.97,29.12,32.75,32.88,34.28,34.66,35.72,35.91,35.69,34.69,31.5,31.19,28.62,27.31,28.84,31.31,30.75,31.19,32.28,31.09,31.88,30.69,31.62,29.16,24.59,25.25,26.5,26.84,32.5,38.09,41.19,44.69,47.12,48.53,49.0,49.69,50.75,47.91,45.16,46.78,43.94,45.34,45.25,46.16,44.41,44.22,44.0,44.0,42.31,40.59,37.91,35.03,30.5,33.03,31.53,33.97,34.69,34.78,33.78,33.34,31.69,30.31,31.56,31.47,29.84,30.03,29.06,28.81,29.16,30.28,32.31,33.66,33.88,35.56,33.66,32.47,32.69,31.28,31.47,30.53,33.97,35.59,37.94,42.47,46.31,48.38,50.44,53.16,53.78,53.25,53.88,54.28,51.25,50.53,48.62,46.97,44.78,44.44,44.47,41.88,42.19,39.69,38.53,37.16,34.25,34.41,33.69,33.06,34.03,34.94,34.5,35.69,36.06,36.53,37.72,39.59,39.31,38.72,39.34,41.22,43.72,47.53,50.81,54.94,54.94,54.66,52.84,46.03,45.31,40.12,35.56,36.31,35.56,35.56,35.5,35.97,36.28,37.06,36.56,39.12,41.16,44.31,48.47,53.41,56.56,58.28,57.38,56.72,54.88,51.0,47.28,42.69,40.25,37.03,36.75,38.38,39.81,42.78,46.38,48.66,50.91,53.66,53.88,54.94,53.25,55.72,53.41,51.91,49.41,49.59,48.5,47.44,49.66,51.06,52.34,54.16,55.03,55.06,53.44,51.53,48.03,42.94,40.28,37.34,35.09,35.53,31.78,33.03,31.69,32.56,32.44,32.78,34.16,34.03,33.91,34.5,32.72,32.06,30.59,29.19,28.0,24.12,25.66,25.25,25.16,27.66,30.19,31.06,31.12,31.72,31.81,32.03,34.97,32.81,37.41,37.09,37.94,39.56,40.25,40.47,41.62,40.34,38.69,38.31,38.34,37.84,38.56,38.91,40.31,38.53,38.0,37.56,37.16,36.31,37.78,38.09,36.22,40.38,40.31,41.66,44.06,45.91,47.22,47.03,46.22,46.84,45.72,43.62,41.16,38.0,38.0,36.16,37.0,39.0,37.69,36.25,33.16,33.41,33.78,36.72,39.69,43.34,45.19,43.16,44.38,42.69,43.56,43.75,43.06,44.59,44.53,43.22,41.88,39.44,37.34,35.56,33.09,32.62,30.28,32.0,30.5,30.97,32.34,31.28,31.88,30.41,27.47,29.69,28.41,30.09,31.16,35.38,36.06,36.59,36.94,34.5,36.62,37.03,40.38,42.78,43.91,42.03,41.75,39.03,37.72,39.06,40.09,39.66,39.19,39.03,39.91,38.72,40.97,41.91,45.16,45.53,46.53,47.38,47.06,45.28,42.19,42.69,39.62,41.28,41.59,42.38,41.91,42.72,43.47,42.53,42.91,44.69,45.41,44.44,42.91,44.62,42.81,41.56,40.12,40.62,37.47,37.16,37.16,38.28,40.34,41.12,42.19,40.41,40.5,39.0,38.22,35.88,36.16,35.19,33.0,34.56,33.06,33.44,32.22,34.41,34.19,34.56,37.25,39.06,37.16,37.25,35.62,32.78,33.06,30.72,30.0,29.0,29.56,32.31,34.81,37.66,38.06,40.44,38.34,38.59,39.47,39.56,38.69,39.34,35.53,37.62,35.66,38.19,39.81,41.81,42.03,42.41,40.28,39.0,35.94,33.91,30.75,29.81,30.78,29.56,31.31,30.69,30.25,26.34,28.56,26.53,28.44,31.44,33.34,35.91,37.78,39.56,39.69,40.19,40.25,37.47,39.0,37.72,36.53,38.34,40.78,40.78,42.12,41.47,40.19,38.31,37.03,34.75,32.88,33.81,33.5,33.88,35.66,36.19,37.56,37.91,35.19,38.06,34.12,33.91,34.91,33.78,35.25,35.5,35.97,36.41,36.62,35.53,34.31,33.19,32.5,30.69,31.16,-17.94,-17.72,-16.16,-15.41,-10.53,-7.03,-5.97,-3.84,-1.72,1.12,2.25,5.66,7.53,7.78,6.31,5.41,3.88,1.97,1.41,-0.47,-0.94,-2.59,-0.66,-1.81,-0.16,-1.09,-1.47,-0.72,-1.34,-1.88:negativity
42.56,44.66,45.44,44.38,44.34,43.12,40.56,37.97,36.62,34.81,32.69,32.94,32.44,32.91,35.12,36.28,36.0,34.62,35.09,32.03,31.31,30.91,31.44,31.28,29.66,29.91,31.62,34.78,37.44,41.69,43.59,43.28,42.62,42.06,39.97,40.0,39.91,38.25,39.0,39.69,41.28,43.06,44.03,45.06,44.5,44.31,44.62,46.0,47.16,49.88,50.28,51.91,49.12,47.75,41.84,38.09,37.06,32.69,33.25,33.72,35.19,35.69,36.28,37.25,35.12,33.16,33.88,32.53,32.41,33.31,34.66,34.56,35.19,34.91,33.75,32.44,29.34,27.19,25.03,23.91,23.44,24.75,28.06,29.44,30.75,30.62,30.66,30.31,30.34,32.22,34.59,36.5,38.06,36.66,38.53,38.41,39.19,41.19,41.31,44.53,44.44,44.78,43.56,42.69,40.34,38.06,35.31,32.19,29.5,25.75,24.03,22.81,21.06,20.16,19.91,20.81,20.97,23.56,26.47,28.69,32.19,34.0,35.72,35.81,37.5,35.94,35.0,33.44,31.81,31.84,28.94,30.16,27.25,27.09,27.16,25.31,24.06,23.44,19.53,20.31,19.31,20.81,22.12,26.19,26.91,28.81,29.16,27.81,27.06,24.81,23.56,21.44,19.66,19.34,18.56,17.12,17.31,16.34,17.25,18.16,19.66,23.06,25.66,26.91,29.19,30.94,32.97,37.25,41.41,43.84,44.81,47.06,43.81,43.16,41.34,40.0,39.25,39.12,37.78,37.72,36.69,38.81,40.12,39.56,41.31,43.19,41.78,42.28,41.19,40.03,38.97,37.16,36.94,38.38,39.69,37.97,40.94,39.47,40.31,38.72,39.5,40.0,38.03,38.12,38.56,37.94,38.12,40.28,40.72,43.22,43.78,45.66,45.62,43.66,42.5,38.72,36.81,37.31,36.22,38.44,39.72,40.72,41.59,40.12,42.12,41.88,40.66,44.09,45.88,46.78,49.75,52.88,54.38,54.56,53.62,51.84,43.84,44.94,42.19,41.56,43.69,44.94,45.12,43.56,40.38,37.47,34.28,30.5,26.5,25.31,24.69,25.06,27.81,30.19,31.62,33.81,35.56,35.06,36.22,35.53,31.44,28.94,24.06,21.12,19.78,20.0,21.78,22.06,22.09,21.59,19.03,18.62,17.0,20.06,22.31,24.84,29.12,31.53,34.78,38.03,39.34,42.22,43.34,42.41,42.31,38.97,37.66,33.94,32.88,32.5,31.84,29.75,31.69,30.38,30.81,32.31,33.75,35.53,35.84,36.19,37.56,39.78,41.12,43.03,45.56,44.09,41.53,41.62,36.38,33.72,32.09,28.94,30.5,30.41,32.62,34.75,35.72,37.69,38.38,39.88,43.03,44.84,46.88,49.12,49.69,50.56,50.06,49.09,47.62,46.62,45.09,43.97,45.06,45.31,46.44,47.75,47.91,47.5,46.84,45.53,43.47,44.19,42.75,44.03,43.38,46.41,48.31,49.84,52.12,54.22,54.66,53.69,52.56,49.66,44.94,43.47,42.28,40.53,40.53,43.69,44.53,45.34,47.09,46.31,46.09,45.56,45.69,46.09,47.25,46.5,47.59,47.12,48.0,49.81,50.5,51.0,51.91,49.66,49.41,48.44,47.81,46.56,46.94,44.66,45.69,46.62,47.16,47.75,49.97,48.56,49.03,49.56,49.41,48.44,49.22,47.62,46.91,46.12,45.03,43.91,42.81,43.16,43.44,44.22,46.44,45.03,42.94,43.66,39.41,39.09,38.56,40.31,40.03,39.97,42.16,40.75,41.44,40.62,41.03,40.69,41.25,40.78,40.19,41.19,40.62,39.25,40.56,38.53,37.31,36.62,35.5,33.53,36.31,37.0,38.34,40.53,42.81,44.25,44.75,45.84,49.41,50.34,50.53,49.81,47.69,43.38,39.62,34.66,32.72,30.16,28.19,28.16,28.38,27.59,26.72,26.66,27.75,26.28,29.03,30.34,31.47,33.28,36.59,38.41,39.97,41.56,44.59,42.53,43.56,43.31,41.06,41.31,39.78,39.38,37.31,37.28,35.94,38.25,38.47,39.56,41.03,43.0,42.19,43.5,44.5,43.25,42.38,42.09,42.75,42.47,42.25,41.47,40.56,39.31,38.06,37.91,35.31,36.0,35.31,34.91,35.62,34.84,35.06,35.16,32.31,33.12,33.41,32.5,34.78,35.75,37.69,39.5,40.53,40.66,41.06,40.12,38.94,38.16,36.94,39.66,40.53,42.44,45.41,48.5,48.53,51.19,50.44,50.03,49.34,46.62,45.81,44.53,42.53,40.5,37.09,31.94,29.12,25.03,22.19,21.59,22.97,23.62,25.16,27.28,29.25,30.75,31.56,30.5,29.44,27.09,24.75,22.88,23.97,23.94,24.31,31.19,33.31,36.69,41.94,42.75,43.94,43.62,42.31,42.12,40.25,38.5,38.09,38.56,40.66,41.06,43.41,44.16,44.19,43.16,42.69,41.0,40.69,40.69,40.31,41.72,42.38,39.41,39.0,35.84,32.81,34.09,34.91,34.59,37.66,39.25,39.81,41.12,40.31,40.12,39.0,37.41,36.88,35.03,31.94,32.94,31.97,30.31,33.19,34.16,32.47,35.19,34.38,35.03,35.75,36.06,36.56,35.12,34.16,34.66,33.31,35.16,37.84,37.88,41.56,39.34,40.09,40.22,39.12,40.56,40.59,42.12,41.5,42.12,42.38,43.94,43.78,44.69,43.31,42.56,40.22,39.16,37.62,38.62,38.03,39.75,38.12,40.97,42.03,43.34,44.28,45.5,45.19,44.09,41.94,41.22,40.47,37.31,35.72,33.81,32.72,32.81,34.78,36.94,40.81,43.12,43.06,44.78,45.53,44.75,45.56,47.19,45.91,46.28,43.59,45.81,44.06,44.5,45.19,47.44,46.78,48.41,49.59,49.0,50.19,50.16,50.56,47.94,49.41,46.59,46.34,45.75,44.25,47.09,47.5,49.03,51.12,51.12,50.03,49.81,47.06,44.69,44.44,43.81,44.5,45.59,46.62,49.06,49.44,49.66,48.91,50.81,48.53,49.94,51.47,52.31,54.0,54.41,54.75,53.5,51.81,51.78,49.12,47.34,47.88,44.94,43.41,42.5,42.44,41.72,43.12,43.41,45.28,44.69,42.38,42.84,39.31,39.72,35.88,35.03,33.62,32.09,30.25,31.06,31.84,33.25,33.28,36.44,35.38,35.88,34.78,34.31,34.75,33.56,34.31,33.75,34.34,35.16,34.81,34.69,34.81,34.22,33.75,31.47,33.59,32.28,33.28,35.56,39.25,40.38,40.69,38.91,39.25,37.62,38.28,40.5,40.34,42.62,42.84,42.5,43.88,44.78,46.78,47.0,47.34,48.25,45.78,43.41,43.53,41.84,41.53,42.44,41.0,39.69,38.31,37.0,35.38,35.62,34.19,33.84,34.38,34.75,34.22,36.16,37.0,36.88,38.56,39.28,38.56,37.59,34.53,32.91,33.22,34.0,36.62,38.84,41.81,39.69,39.81,37.97,37.69,37.03,37.97,38.5,39.81,40.91,39.69,40.94,40.31,38.31,40.31,39.0,39.75,41.72,41.0,36.75,39.56,37.91,39.31,42.88,44.31,45.25,46.12,46.03,47.44,48.69,51.5,54.03,54.56,53.81,53.19,50.47,45.81,43.28,39.5,33.88,32.06,30.81,30.28,32.0,32.41,33.22,32.88,30.84,29.31,29.09,28.91,30.56,32.69,34.81,35.94,37.34,37.78,39.5,39.06,40.19,36.69,37.72,35.91,33.66,34.69,34.72,33.91,36.12,36.06,37.75,40.69,43.41,44.56,42.97,45.12,42.97,43.06,43.34,42.25,42.03,40.22,38.47,39.34,38.16,36.31,37.19:40.56,37.97,36.62,34.81,32.69,32.94,32.44,32.91,35.12,36.28,36.0,34.62,35.09,32.03,31.31,30.91,31.44,31.28,29.66,29.91,31.62,34.78,37.44,41.69,43.59,43.28,42.62,42.06,39.97,40.0,39.91,38.25,39.0,39.69,41.28,43.06,44.03,45.06,44.5,44.31,44.62,46.0,47.16,49.88,50.28,51.91,49.12,47.75,41.84,38.09,37.06,32.69,33.25,33.72,35.19,35.69,36.28,37.25,35.12,33.16,33.88,32.53,32.41,33.31,34.66,34.56,35.19,34.91,33.75,32.44,29.34,27.19,25.03,23.91,23.44,24.75,28.06,29.44,30.75,30.62,30.66,30.31,30.34,32.22,34.59,36.5,38.06,36.66,38.53,38.41,39.19,41.19,41.31,44.53,44.44,44.78,43.56,42.69,40.34,38.06,35.31,32.19,29.5,25.75,24.03,22.81,21.06,20.16,19.91,20.81,20.97,23.56,26.47,28.69,32.19,34.0,35.72,35.81,37.5,35.94,35.0,33.44,31.81,31.84,28.94,30.16,27.25,27.09,27.16,25.31,24.06,23.44,19.53,20.31,19.31,20.81,22.12,26.19,26.91,28.81,29.16,27.81,27.06,24.81,23.56,21.44,19.66,19.34,18.56,17.12,17.31,16.34,17.25,18.16,19.66,23.06,25.66,26.91,29.19,30.94,32.97,37.25,41.41,43.84,44.81,47.06,43.81,43.16,41.34,40.0,39.25,39.12,37.78,37.72,36.69,38.81,40.12,39.56,41.31,43.19,41.78,42.28,41.19,40.03,38.97,37.16,36.94,38.38,39.69,37.97,40.94,39.47,40.31,38.72,39.5,40.0,38.03,38.12,38.56,37.94,38.12,40.28,40.72,43.22,43.78,45.66,45.62,43.66,42.5,38.72,36.81,37.31,36.22,38.44,39.72,40.72,41.59,40.12,42.12,41.88,40.66,44.09,45.88,46.78,49.75,52.88,54.38,54.56,53.62,51.84,43.84,44.94,42.19,41.56,43.69,44.94,45.12,43.56,40.38,37.47,34.28,30.5,26.5,25.31,24.69,25.06,27.81,30.19,31.62,33.81,35.56,35.06,36.22,35.53,31.44,28.94,24.06,21.12,19.78,20.0,21.78,22.06,22.09,21.59,19.03,18.62,17.0,20.06,22.31,24.84,29.12,31.53,34.78,38.03,39.34,42.22,43.34,42.41,42.31,38.97,37.66,33.94,32.88,32.5,31.84,29.75,31.69,30.38,30.81,32.31,33.75,35.53,35.84,36.19,37.56,39.78,41.12,43.03,45.56,44.09,41.53,41.62,36.38,33.72,32.09,28.94,30.5,30.41,32.62,34.75,35.72,37.69,38.38,39.88,43.03,44.84,46.88,49.12,49.69,50.56,50.06,49.09,47.62,46.62,45.09,43.97,45.06,45.31,46.44,47.75,47.91,47.5,46.84,45.53,43.47,44.19,42.75,44.03,43.38,46.41,48.31,49.84,52.12,54.22,54.66,53.69,52.56,49.66,44.94,43.47,42.28,40.53,40.53,43.69,44.53,45.34,47.09,46.31,46.09,45.56,45.69,46.09,47.25,46.5,47.59,47.12,48.0,49.81,50.5,51.0,51.91,49.66,49.41,48.44,47.81,46.56,46.94,44.66,45.69,46.62,47.16,47.75,49.97,48.56,49.03,49.56,49.41,48.44,49.22,47.62,46.91,46.12,45.03,43.91,42.81,43.16,43.44,44.22,46.44,45.03,42.94,43.66,39.41,39.09,38.56,40.31,40.03,39.97,42.16,40.75,41.44,40.62,41.03,40.69,41.25,40.78,40.19,41.19,40.62,39.25,40.56,38.53,37.31,36.62,35.5,33.53,36.31,37.0,38.34,40.53,42.81,44.25,44.75,45.84,49.41,50.34,50.53,49.81,47.69,43.38,39.62,34.66,32.72,30.16,28.19,28.16,28.38,27.59,26.72,26.66,27.75,26.28,29.03,30.34,31.47,33.28,36.59,38.41,39.97,41.56,44.59,42.53,43.56,43.31,41.06,41.31,39.78,39.38,37.31,37.28,35.94,38.25,38.47,39.56,41.03,43.0,42.19,43.5,44.5,43.25,42.38,42.09,42.75,42.47,42.25,41.47,40.56,39.31,38.06,37.91,35.31,36.0,35.31,34.91,35.62,34.84,35.06,35.16,32.31,33.12,33.41,32.5,34.78,35.75,37.69,39.5,40.53,40.66,41.06,40.12,38.94,38.16,36.94,39.66,40.53,42.44,45.41,48.5,48.53,51.19,50.44,50.03,49.34,46.62,45.81,44.53,42.53,40.5,37.09,31.94,29.12,25.03,22.19,21.59,22.97,23.62,25.16,27.28,29.25,30.75,31.56,30.5,29.44,27.09,24.75,22.88,23.97,23.94,24.31,31.19,33.31,36.69,41.94,42.75,43.94,43.62,42.31,42.12,40.25,38.5,38.09,38.56,40.66,41.06,43.41,44.16,44.19,43.16,42.69,41.0,40.69,40.69,40.31,41.72,42.38,39.41,39.0,35.84,32.81,34.09,34.91,34.59,37.66,39.25,39.81,41.12,40.31,40.12,39.0,37.41,36.88,35.03,31.94,32.94,31.97,30.31,33.19,34.16,32.47,35.19,34.38,35.03,35.75,36.06,36.56,35.12,34.16,34.66,33.31,35.16,37.84,37.88,41.56,39.34,40.09,40.22,39.12,40.56,40.59,42.12,41.5,42.12,42.38,43.94,43.78,44.69,43.31,42.56,40.22,39.16,37.62,38.62,38.03,39.75,38.12,40.97,42.03,43.34,44.28,45.5,45.19,44.09,41.94,41.22,40.47,37.31,35.72,33.81,32.72,32.81,34.78,36.94,40.81,43.12,43.06,44.78,45.53,44.75,45.56,47.19,45.91,46.28,43.59,45.81,44.06,44.5,45.19,47.44,46.78,48.41,49.59,49.0,50.19,50.16,50.56,47.94,49.41,46.59,46.34,45.75,44.25,47.09,47.5,49.03,51.12,51.12,50.03,49.81,47.06,44.69,44.44,43.81,44.5,45.59,46.62,49.06,49.44,49.66,48.91,50.81,48.53,49.94,51.47,52.31,54.0,54.41,54.75,53.5,51.81,51.78,49.12,47.34,47.88,44.94,43.41,42.5,42.44,41.72,43.12,43.41,45.28,44.69,42.38,42.84,39.31,39.72,35.88,35.03,33.62,32.09,30.25,31.06,31.84,33.25,33.28,36.44,35.38,35.88,34.78,34.31,34.75,33.56,34.31,33.75,34.34,35.16,34.81,34.69,34.81,34.22,33.75,31.47,33.59,32.28,33.28,35.56,39.25,40.38,40.69,38.91,39.25,37.62,38.28,40.5,40.34,42.62,42.84,42.5,43.88,44.78,46.78,47.0,47.34,48.25,45.78,43.41,43.53,41.84,41.53,42.44,41.0,39.69,38.31,37.0,35.38,35.62,34.19,33.84,34.38,34.75,34.22,36.16,37.0,36.88,38.56,39.28,38.56,37.59,34.53,32.91,33.22,34.0,36.62,38.84,41.81,39.69,39.81,37.97,37.69,37.03,37.97,38.5,39.81,40.91,39.69,40.94,40.31,38.31,40.31,39.0,39.75,41.72,41.0,36.75,39.56,37.91,39.31,42.88,44.31,45.25,46.12,46.03,47.44,48.69,51.5,54.03,54.56,53.81,53.19,50.47,45.81,43.28,39.5,33.88,32.06,30.81,30.28,32.0,32.41,33.22,32.88,30.84,29.31,29.09,28.91,30.56,32.69,34.81,35.94,37.34,37.78,39.5,39.06,40.19,36.69,37.72,35.91,33.66,34.69,34.72,33.91,36.12,36.06,37.75,40.69,43.41,44.56,42.97,45.12,42.97,43.06,43.34,42.25,42.03,40.22,38.47,39.34,38.16,36.31,37.19,29.06,30.5,32.28,33.06,33.59,32.91:32.44,32.91,35.12,36.28,36.0,34.62,35.09,32.03,31.31,30.91,31.44,31.28,29.66,29.91,31.62,34.78,37.44,41.69,43.59,43.28,42.62,42.06,39.97,40.0,39.91,38.25,39.0,39.69,41.28,43.06,44.03,45.06,44.5,44.31,44.62,46.0,47.16,49.88,50.28,51.91,49.12,47.75,41.84,38.09,37.06,32.69,33.25,33.72,35.19,35.69,36.28,37.25,35.12,33.16,33.88,32.53,32.41,33.31,34.66,34.56,35.19,34.91,33.75,32.44,29.34,27.19,25.03,23.91,23.44,24.75,28.06,29.44,30.75,30.62,30.66,30.31,30.34,32.22,34.59,36.5,38.06,36.66,38.53,38.41,39.19,41.19,41.31,44.53,44.44,44.78,43.56,42.69,40.34,38.06,35.31,32.19,29.5,25.75,24.03,22.81,21.06,20.16,19.91,20.81,20.97,23.56,26.47,28.69,32.19,34.0,35.72,35.81,37.5,35.94,35.0,33.44,31.81,31.84,28.94,30.16,27.25,27.09,27.16,25.31,24.06,23.44,19.53,20.31,19.31,20.81,22.12,26.19,26.91,28.81,29.16,27.81,27.06,24.81,23.56,21.44,19.66,19.34,18.56,17.12,17.31,16.34,17.25,18.16,19.66,23.06,25.66,26.91,29.19,30.94,32.97,37.25,41.41,43.84,44.81,47.06,43.81,43.16,41.34,40.0,39.25,39.12,37.78,37.72,36.69,38.81,40.12,39.56,41.31,43.19,41.78,42.28,41.19,40.03,38.97,37.16,36.94,38.38,39.69,37.97,40.94,39.47,40.31,38.72,39.5,40.0,38.03,38.12,38.56,37.94,38.12,40.28,40.72,43.22,43.78,45.66,45.62,43.66,42.5,38.72,36.81,37.31,36.22,38.44,39.72,40.72,41.59,40.12,42.12,41.88,40.66,44.09,45.88,46.78,49.75,52.88,54.38,54.56,53.62,51.84,43.84,44.94,42.19,41.56,43.69,44.94,45.12,43.56,40.38,37.47,34.28,30.5,26.5,25.31,24.69,25.06,27.81,30.19,31.62,33.81,35.56,35.06,36.22,35.53,31.44,28.94,24.06,21.12,19.78,20.0,21.78,22.06,22.09,21.59,19.03,18.62,17.0,20.06,22.31,24.84,29.12,31.53,34.78,38.03,39.34,42.22,43.34,42.41,42.31,38.97,37.66,33.94,32.88,32.5,31.84,29.75,31.69,30.38,30.81,32.31,33.75,35.53,35.84,36.19,37.56,39.78,41.12,43.03,45.56,44.09,41.53,41.62,36.38,33.72,32.09,28.94,30.5,30.41,32.62,34.75,35.72,37.69,38.38,39.88,43.03,44.84,46.88,49.12,49.69,50.56,50.06,49.09,47.62,46.62,45.09,43.97,45.06,45.31,46.44,47.75,47.91,47.5,46.84,45.53,43.47,44.19,42.75,44.03,43.38,46.41,48.31,49.84,52.12,54.22,54.66,53.69,52.56,49.66,44.94,43.47,42.28,40.53,40.53,43.69,44.53,45.34,47.09,46.31,46.09,45.56,45.69,46.09,47.25,46.5,47.59,47.12,48.0,49.81,50.5,51.0,51.91,49.66,49.41,48.44,47.81,46.56,46.94,44.66,45.69,46.62,47.16,47.75,49.97,48.56,49.03,49.56,49.41,48.44,49.22,47.62,46.91,46.12,45.03,43.91,42.81,43.16,43.44,44.22,46.44,45.03,42.94,43.66,39.41,39.09,38.56,40.31,40.03,39.97,42.16,40.75,41.44,40.62,41.03,40.69,41.25,40.78,40.19,41.19,40.62,39.25,40.56,38.53,37.31,36.62,35.5,33.53,36.31,37.0,38.34,40.53,42.81,44.25,44.75,45.84,49.41,50.34,50.53,49.81,47.69,43.38,39.62,34.66,32.72,30.16,28.19,28.16,28.38,27.59,26.72,26.66,27.75,26.28,29.03,30.34,31.47,33.28,36.59,38.41,39.97,41.56,44.59,42.53,43.56,43.31,41.06,41.31,39.78,39.38,37.31,37.28,35.94,38.25,38.47,39.56,41.03,43.0,42.19,43.5,44.5,43.25,42.38,42.09,42.75,42.47,42.25,41.47,40.56,39.31,38.06,37.91,35.31,36.0,35.31,34.91,35.62,34.84,35.06,35.16,32.31,33.12,33.41,32.5,34.78,35.75,37.69,39.5,40.53,40.66,41.06,40.12,38.94,38.16,36.94,39.66,40.53,42.44,45.41,48.5,48.53,51.19,50.44,50.03,49.34,46.62,45.81,44.53,42.53,40.5,37.09,31.94,29.12,25.03,22.19,21.59,22.97,23.62,25.16,27.28,29.25,30.75,31.56,30.5,29.44,27.09,24.75,22.88,23.97,23.94,24.31,31.19,33.31,36.69,41.94,42.75,43.94,43.62,42.31,42.12,40.25,38.5,38.09,38.56,40.66,41.06,43.41,44.16,44.19,43.16,42.69,41.0,40.69,40.69,40.31,41.72,42.38,39.41,39.0,35.84,32.81,34.09,34.91,34.59,37.66,39.25,39.81,41.12,40.31,40.12,39.0,37.41,36.88,35.03,31.94,32.94,31.97,30.31,33.19,34.16,32.47,35.19,34.38,35.03,35.75,36.06,36.56,35.12,34.16,34.66,33.31,35.16,37.84,37.88,41.56,39.34,40.09,40.22,39.12,40.56,40.59,42.12,41.5,42.12,42.38,43.94,43.78,44.69,43.31,42.56,40.22,39.16,37.62,38.62,38.03,39.75,38.12,40.97,42.03,43.34,44.28,45.5,45.19,44.09,41.94,41.22,40.47,37.31,35.72,33.81,32.72,32.81,34.78,36.94,40.81,43.12,43.06,44.78,45.53,44.75,45.56,47.19,45.91,46.28,43.59,45.81,44.06,44.5,45.19,47.44,46.78,48.41,49.59,49.0,50.19,50.16,50.56,47.94,49.41,46.59,46.34,45.75,44.25,47.09,47.5,49.03,51.12,51.12,50.03,49.81,47.06,44.69,44.44,43.81,44.5,45.59,46.62,49.06,49.44,49.66,48.91,50.81,48.53,49.94,51.47,52.31,54.0,54.41,54.75,53.5,51.81,51.78,49.12,47.34,47.88,44.94,43.41,42.5,42.44,41.72,43.12,43.41,45.28,44.69,42.38,42.84,39.31,39.72,35.88,35.03,33.62,32.09,30.25,31.06,31.84,33.25,33.28,36.44,35.38,35.88,34.78,34.31,34.75,33.56,34.31,33.75,34.34,35.16,34.81,34.69,34.81,34.22,33.75,31.47,33.59,32.28,33.28,35.56,39.25,40.38,40.69,38.91,39.25,37.62,38.28,40.5,40.34,42.62,42.84,42.5,43.88,44.78,46.78,47.0,47.34,48.25,45.78,43.41,43.53,41.84,41.53,42.44,41.0,39.69,38.31,37.0,35.38,35.62,34.19,33.84,34.38,34.75,34.22,36.16,37.0,36.88,38.56,39.28,38.56,37.59,34.53,32.91,33.22,34.0,36.62,38.84,41.81,39.69,39.81,37.97,37.69,37.03,37.97,38.5,39.81,40.91,39.69,40.94,40.31,38.31,40.31,39.0,39.75,41.72,41.0,36.75,39.56,37.91,39.31,42.88,44.31,45.25,46.12,46.03,47.44,48.69,51.5,54.03,54.56,53.81,53.19,50.47,45.81,43.28,39.5,33.88,32.06,30.81,30.28,32.0,32.41,33.22,32.88,30.84,29.31,29.09,28.91,30.56,32.69,34.81,35.94,37.34,37.78,39.5,39.06,40.19,36.69,37.72,35.91,33.66,34.69,34.72,33.91,36.12,36.06,37.75,40.69,43.41,44.56,42.97,45.12,42.97,43.06,43.34,42.25,42.03,40.22,38.47,39.34,38.16,36.31,37.19,29.06,30.5,32.28,33.06,33.59,32.91,31.91,30.66,29.25,27.91,27.19,26.88:35.09,32.03,31.31,30.91,31.44,31.28,29.66,29.91,31.62,34.78,37.44,41.69,43.59,43.28,42.62,42.06,39.97,40.0,39.91,38.25,39.0,39.69,41.28,43.06,44.03,45.06,44.5,44.31,44.62,46.0,47.16,49.88,50.28,51.91,49.12,47.75,41.84,38.09,37.06,32.69,33.25,33.72,35.19,35.69,36.28,37.25,35.12,33.16,33.88,32.53,32.41,33.31,34.66,34.56,35.19,34.91,33.75,32.44,29.34,27.19,25.03,23.91,23.44,24.75,28.06,29.44,30.75,30.62,30.66,30.31,30.34,32.22,34.59,36.5,38.06,36.66,38.53,38.41,39.19,41.19,41.31,44.53,44.44,44.78,43.56,42.69,40.34,38.06,35.31,32.19,29.5,25.75,24.03,22.81,21.06,20.16,19.91,20.81,20.97,23.56,26.47,28.69,32.19,34.0,35.72,35.81,37.5,35.94,35.0,33.44,31.81,31.84,28.94,30.16,27.25,27.09,27.16,25.31,24.06,23.44,19.53,20.31,19.31,20.81,22.12,26.19,26.91,28.81,29.16,27.81,27.06,24.81,23.56,21.44,19.66,19.34,18.56,17.12,17.31,16.34,17.25,18.16,19.66,23.06,25.66,26.91,29.19,30.94,32.97,37.25,41.41,43.84,44.81,47.06,43.81,43.16,41.34,40.0,39.25,39.12,37.78,37.72,36.69,38.81,40.12,39.56,41.31,43.19,41.78,42.28,41.19,40.03,38.97,37.16,36.94,38.38,39.69,37.97,40.94,39.47,40.31,38.72,39.5,40.0,38.03,38.12,38.56,37.94,38.12,40.28,40.72,43.22,43.78,45.66,45.62,43.66,42.5,38.72,36.81,37.31,36.22,38.44,39.72,40.72,41.59,40.12,42.12,41.88,40.66,44.09,45.88,46.78,49.75,52.88,54.38,54.56,53.62,51.84,43.84,44.94,42.19,41.56,43.69,44.94,45.12,43.56,40.38,37.47,34.28,30.5,26.5,25.31,24.69,25.06,27.81,30.19,31.62,33.81,35.56,35.06,36.22,35.53,31.44,28.94,24.06,21.12,19.78,20.0,21.78,22.06,22.09,21.59,19.03,18.62,17.0,20.06,22.31,24.84,29.12,31.53,34.78,38.03,39.34,42.22,43.34,42.41,42.31,38.97,37.66,33.94,32.88,32.5,31.84,29.75,31.69,30.38,30.81,32.31,33.75,35.53,35.84,36.19,37.56,39.78,41.12,43.03,45.56,44.09,41.53,41.62,36.38,33.72,32.09,28.94,30.5,30.41,32.62,34.75,35.72,37.69,38.38,39.88,43.03,44.84,46.88,49.12,49.69,50.56,50.06,49.09,47.62,46.62,45.09,43.97,45.06,45.31,46.44,47.75,47.91,47.5,46.84,45.53,43.47,44.19,42.75,44.03,43.38,46.41,48.31,49.84,52.12,54.22,54.66,53.69,52.56,49.66,44.94,43.47,42.28,40.53,40.53,43.69,44.53,45.34,47.09,46.31,46.09,45.56,45.69,46.09,47.25,46.5,47.59,47.12,48.0,49.81,50.5,51.0,51.91,49.66,49.41,48.44,47.81,46.56,46.94,44.66,45.69,46.62,47.16,47.75,49.97,48.56,49.03,49.56,49.41,48.44,49.22,47.62,46.91,46.12,45.03,43.91,42.81,43.16,43.44,44.22,46.44,45.03,42.94,43.66,39.41,39.09,38.56,40.31,40.03,39.97,42.16,40.75,41.44,40.62,41.03,40.69,41.25,40.78,40.19,41.19,40.62,39.25,40.56,38.53,37.31,36.62,35.5,33.53,36.31,37.0,38.34,40.53,42.81,44.25,44.75,45.84,49.41,50.34,50.53,49.81,47.69,43.38,39.62,34.66,32.72,30.16,28.19,28.16,28.38,27.59,26.72,26.66,27.75,26.28,29.03,30.34,31.47,33.28,36.59,38.41,39.97,41.56,44.59,42.53,43.56,43.31,41.06,41.31,39.78,39.38,37.31,37.28,35.94,38.25,38.47,39.56,41.03,43.0,42.19,43.5,44.5,43.25,42.38,42.09,42.75,42.47,42.25,41.47,40.56,39.31,38.06,37.91,35.31,36.0,35.31,34.91,35.62,34.84,35.06,35.16,32.31,33.12,33.41,32.5,34.78,35.75,37.69,39.5,40.53,40.66,41.06,40.12,38.94,38.16,36.94,39.66,40.53,42.44,45.41,48.5,48.53,51.19,50.44,50.03,49.34,46.62,45.81,44.53,42.53,40.5,37.09,31.94,29.12,25.03,22.19,21.59,22.97,23.62,25.16,27.28,29.25,30.75,31.56,30.5,29.44,27.09,24.75,22.88,23.97,23.94,24.31,31.19,33.31,36.69,41.94,42.75,43.94,43.62,42.31,42.12,40.25,38.5,38.09,38.56,40.66,41.06,43.41,44.16,44.19,43.16,42.69,41.0,40.69,40.69,40.31,41.72,42.38,39.41,39.0,35.84,32.81,34.09,34.91,34.59,37.66,39.25,39.81,41.12,40.31,40.12,39.0,37.41,36.88,35.03,31.94,32.94,31.97,30.31,33.19,34.16,32.47,35.19,34.38,35.03,35.75,36.06,36.56,35.12,34.16,34.66,33.31,35.16,37.84,37.88,41.56,39.34,40.09,40.22,39.12,40.56,40.59,42.12,41.5,42.12,42.38,43.94,43.78,44.69,43.31,42.56,40.22,39.16,37.62,38.62,38.03,39.75,38.12,40.97,42.03,43.34,44.28,45.5,45.19,44.09,41.94,41.22,40.47,37.31,35.72,33.81,32.72,32.81,34.78,36.94,40.81,43.12,43.06,44.78,45.53,44.75,45.56,47.19,45.91,46.28,43.59,45.81,44.06,44.5,45.19,47.44,46.78,48.41,49.59,49.0,50.19,50.16,50.56,47.94,49.41,46.59,46.34,45.75,44.25,47.09,47.5,49.03,51.12,51.12,50.03,49.81,47.06,44.69,44.44,43.81,44.5,45.59,46.62,49.06,49.44,49.66,48.91,50.81,48.53,49.94,51.47,52.31,54.0,54.41,54.75,53.5,51.81,51.78,49.12,47.34,47.88,44.94,43.41,42.5,42.44,41.72,43.12,43.41,45.28,44.69,42.38,42.84,39.31,39.72,35.88,35.03,33.62,32.09,30.25,31.06,31.84,33.25,33.28,36.44,35.38,35.88,34.78,34.31,34.75,33.56,34.31,33.75,34.34,35.16,34.81,34.69,34.81,34.22,33.75,31.47,33.59,32.28,33.28,35.56,39.25,40.38,40.69,38.91,39.25,37.62,38.28,40.5,40.34,42.62,42.84,42.5,43.88,44.78,46.78,47.0,47.34,48.25,45.78,43.41,43.53,41.84,41.53,42.44,41.0,39.69,38.31,37.0,35.38,35.62,34.19,33.84,34.38,34.75,34.22,36.16,37.0,36.88,38.56,39.28,38.56,37.59,34.53,32.91,33.22,34.0,36.62,38.84,41.81,39.69,39.81,37.97,37.69,37.03,37.97,38.5,39.81,40.91,39.69,40.94,40.31,38.31,40.31,39.0,39.75,41.72,41.0,36.75,39.56,37.91,39.31,42.88,44.31,45.25,46.12,46.03,47.44,48.69,51.5,54.03,54.56,53.81,53.19,50.47,45.81,43.28,39.5,33.88,32.06,30.81,30.28,32.0,32.41,33.22,32.88,30.84,29.31,29.09,28.91,30.56,32.69,34.81,35.94,37.34,37.78,39.5,39.06,40.19,36.69,37.72,35.91,33.66,34.69,34.72,33.91,36.12,36.06,37.75,40.69,43.41,44.56,42.97,45.12,42.97,43.06,43.34,42.25,42.03,40.22,38.47,39.34,38.16,36.31,37.19,29.06,30.5,32.28,33.06,33.59,32.91,31.91,30.66,29.25,27.91,27.19,26.88,26.28,26.09,27.31,26.78,26.0,23.66:29.66,29.91,31.62,34.78,37.44,41.69,43.59,43.28,42.62,42.06,39.97,40.0,39.91,38.25,39.0,39.69,41.28,43.06,44.03,45.06,44.5,44.31,44.62,46.0,47.16,49.88,50.28,51.91,49.12,47.75,41.84,38.09,37.06,32.69,33.25,33.72,35.19,35.69,36.28,37.25,35.12,33.16,33.88,32.53,32.41,33.31,34.66,34.56,35.19,34.91,33.75,32.44,29.34,27.19,25.03,23.91,23.44,24.75,28.06,29.44,30.75,30.62,30.66,30.31,30.34,32.22,34.59,36.5,38.06,36.66,38.53,38.41,39.19,41.19,41.31,44.53,44.44,44.78,43.56,42.69,40.34,38.06,35.31,32.19,29.5,25.75,24.03,22.81,21.06,20.16,19.91,20.81,20.97,23.56,26.47,28.69,32.19,34.0,35.72,35.81,37.5,35.94,35.0,33.44,31.81,31.84,28.94,30.16,27.25,27.09,27.16,25.31,24.06,23.44,19.53,20.31,19.31,20.81,22.12,26.19,26.91,28.81,29.16,27.81,27.06,24.81,23.56,21.44,19.66,19.34,18.56,17.12,17.31,16.34,17.25,18.16,19.66,23.06,25.66,26.91,29.19,30.94,32.97,37.25,41.41,43.84,44.81,47.06,43.81,43.16,41.34,40.0,39.25,39.12,37.78,37.72,36.69,38.81,40.12,39.56,41.31,43.19,41.78,42.28,41.19,40.03,38.97,37.16,36.94,38.38,39.69,37.97,40.94,39.47,40.31,38.72,39.5,40.0,38.03,38.12,38.56,37.94,38.12,40.28,40.72,43.22,43.78,45.66,45.62,43.66,42.5,38.72,36.81,37.31,36.22,38.44,39.72,40.72,41.59,40.12,42.12,41.88,40.66,44.09,45.88,46.78,49.75,52.88,54.38,54.56,53.62,51.84,43.84,44.94,42.19,41.56,43.69,44.94,45.12,43.56,40.38,37.47,34.28,30.5,26.5,25.31,24.69,25.06,27.81,30.19,31.62,33.81,35.56,35.06,36.22,35.53,31.44,28.94,24.06,21.12,19.78,20.0,21.78,22.06,22.09,21.59,19.03,18.62,17.0,20.06,22.31,24.84,29.12,31.53,34.78,38.03,39.34,42.22,43.34,42.41,42.31,38.97,37.66,33.94,32.88,32.5,31.84,29.75,31.69,30.38,30.81,32.31,33.75,35.53,35.84,36.19,37.56,39.78,41.12,43.03,45.56,44.09,41.53,41.62,36.38,33.72,32.09,28.94,30.5,30.41,32.62,34.75,35.72,37.69,38.38,39.88,43.03,44.84,46.88,49.12,49.69,50.56,50.06,49.09,47.62,46.62,45.09,43.97,45.06,45.31,46.44,47.75,47.91,47.5,46.84,45.53,43.47,44.19,42.75,44.03,43.38,46.41,48.31,49.84,52.12,54.22,54.66,53.69,52.56,49.66,44.94,43.47,42.28,40.53,40.53,43.69,44.53,45.34,47.09,46.31,46.09,45.56,45.69,46.09,47.25,46.5,47.59,47.12,48.0,49.81,50.5,51.0,51.91,49.66,49.41,48.44,47.81,46.56,46.94,44.66,45.69,46.62,47.16,47.75,49.97,48.56,49.03,49.56,49.41,48.44,49.22,47.62,46.91,46.12,45.03,43.91,42.81,43.16,43.44,44.22,46.44,45.03,42.94,43.66,39.41,39.09,38.56,40.31,40.03,39.97,42.16,40.75,41.44,40.62,41.03,40.69,41.25,40.78,40.19,41.19,40.62,39.25,40.56,38.53,37.31,36.62,35.5,33.53,36.31,37.0,38.34,40.53,42.81,44.25,44.75,45.84,49.41,50.34,50.53,49.81,47.69,43.38,39.62,34.66,32.72,30.16,28.19,28.16,28.38,27.59,26.72,26.66,27.75,26.28,29.03,30.34,31.47,33.28,36.59,38.41,39.97,41.56,44.59,42.53,43.56,43.31,41.06,41.31,39.78,39.38,37.31,37.28,35.94,38.25,38.47,39.56,41.03,43.0,42.19,43.5,44.5,43.25,42.38,42.09,42.75,42.47,42.25,41.47,40.56,39.31,38.06,37.91,35.31,36.0,35.31,34.91,35.62,34.84,35.06,35.16,32.31,33.12,33.41,32.5,34.78,35.75,37.69,39.5,40.53,40.66,41.06,40.12,38.94,38.16,36.94,39.66,40.53,42.44,45.41,48.5,48.53,51.19,50.44,50.03,49.34,46.62,45.81,44.53,42.53,40.5,37.09,31.94,29.12,25.03,22.19,21.59,22.97,23.62,25.16,27.28,29.25,30.75,31.56,30.5,29.44,27.09,24.75,22.88,23.97,23.94,24.31,31.19,33.31,36.69,41.94,42.75,43.94,43.62,42.31,42.12,40.25,38.5,38.09,38.56,40.66,41.06,43.41,44.16,44.19,43.16,42.69,41.0,40.69,40.69,40.31,41.72,42.38,39.41,39.0,35.84,32.81,34.09,34.91,34.59,37.66,39.25,39.81,41.12,40.31,40.12,39.0,37.41,36.88,35.03,31.94,32.94,31.97,30.31,33.19,34.16,32.47,35.19,34.38,35.03,35.75,36.06,36.56,35.12,34.16,34.66,33.31,35.16,37.84,37.88,41.56,39.34,40.09,40.22,39.12,40.56,40.59,42.12,41.5,42.12,42.38,43.94,43.78,44.69,43.31,42.56,40.22,39.16,37.62,38.62,38.03,39.75,38.12,40.97,42.03,43.34,44.28,45.5,45.19,44.09,41.94,41.22,40.47,37.31,35.72,33.81,32.72,32.81,34.78,36.94,40.81,43.12,43.06,44.78,45.53,44.75,45.56,47.19,45.91,46.28,43.59,45.81,44.06,44.5,45.19,47.44,46.78,48.41,49.59,49.0,50.19,50.16,50.56,47.94,49.41,46.59,46.34,45.75,44.25,47.09,47.5,49.03,51.12,51.12,50.03,49.81,47.06,44.69,44.44,43.81,44.5,45.59,46.62,49.06,49.44,49.66,48.91,50.81,48.53,49.94,51.47,52.31,54.0,54.41,54.75,53.5,51.81,51.78,49.12,47.34,47.88,44.94,43.41,42.5,42.44,41.72,43.12,43.41,45.28,44.69,42.38,42.84,39.31,39.72,35.88,35.03,33.62,32.09,30.25,31.06,31.84,33.25,33.28,36.44,35.38,35.88,34.78,34.31,34.75,33.56,34.31,33.75,34.34,35.16,34.81,34.69,34.81,34.22,33.75,31.47,33.59,32.28,33.28,35.56,39.25,40.38,40.69,38.91,39.25,37.62,38.28,40.5,40.34,42.62,42.84,42.5,43.88,44.78,46.78,47.0,47.34,48.25,45.78,43.41,43.53,41.84,41.53,42.44,41.0,39.69,38.31,37.0,35.38,35.62,34.19,33.84,34.38,34.75,34.22,36.16,37.0,36.88,38.56,39.28,38.56,37.59,34.53,32.91,33.22,34.0,36.62,38.84,41.81,39.69,39.81,37.97,37.69,37.03,37.97,38.5,39.81,40.91,39.69,40.94,40.31,38.31,40.31,39.0,39.75,41.72,41.0,36.75,39.56,37.91,39.31,42.88,44.31,45.25,46.12,46.03,47.44,48.69,51.5,54.03,54.56,53.81,53.19,50.47,45.81,43.28,39.5,33.88,32.06,30.81,30.28,32.0,32.41,33.22,32.88,30.84,29.31,29.09,28.91,30.56,32.69,34.81,35.94,37.34,37.78,39.5,39.06,40.19,36.69,37.72,35.91,33.66,34.69,34.72,33.91,36.12,36.06,37.75,40.69,43.41,44.56,42.97,45.12,42.97,43.06,43.34,42.25,42.03,40.22,38.47,39.34,38.16,36.31,37.19,29.06,30.5,32.28,33.06,33.59,32.91,31.91,30.66,29.25,27.91,27.19,26.88,26.28,26.09,27.31,26.78,26.0,23.66,23.16,21.03,19.44,19.78,19.44,20.44:43.59,43.28,42.62,42.06,39.97,40.0,39.91,38.25,39.0,39.69,41.28,43.06,44.03,45.06,44.5,44.31,44.62,46.0,47.16,49.88,50.28,51.91,49.12,47.75,41.84,38.09,37.06,32.69,33.25,33.72,35.19,35.69,36.28,37.25,35.12,33.16,33.88,32.53,32.41,33.31,34.66,34.56,35.19,34.91,33.75,32.44,29.34,27.19,25.03,23.91,23.44,24.75,28.06,29.44,30.75,30.62,30.66,30.31,30.34,32.22,34.59,36.5,38.06,36.66,38.53,38.41,39.19,41.19,41.31,44.53,44.44,44.78,43.56,42.69,40.34,38.06,35.31,32.19,29.5,25.75,24.03,22.81,21.06,20.16,19.91,20.81,20.97,23.56,26.47,28.69,32.19,34.0,35.72,35.81,37.5,35.94,35.0,33.44,31.81,31.84,28.94,30.16,27.25,27.09,27.16,25.31,24.06,23.44,19.53,20.31,19.31,20.81,22.12,26.19,26.91,28.81,29.16,27.81,27.06,24.81,23.56,21.44,19.66,19.34,18.56,17.12,17.31,16.34,17.25,18.16,19.66,23.06,25.66,26.91,29.19,30.94,32.97,37.25,41.41,43.84,44.81,47.06,43.81,43.16,41.34,40.0,39.25,39.12,37.78,37.72,36.69,38.81,40.12,39.56,41.31,43.19,41.78,42.28,41.19,40.03,38.97,37.16,36.94,38.38,39.69,37.97,40.94,39.47,40.31,38.72,39.5,40.0,38.03,38.12,38.56,37.94,38.12,40.28,40.72,43.22,43.78,45.66,45.62,43.66,42.5,38.72,36.81,37.31,36.22,38.44,39.72,40.72,41.59,40.12,42.12,41.88,40.66,44.09,45.88,46.78,49.75,52.88,54.38,54.56,53.62,51.84,43.84,44.94,42.19,41.56,43.69,44.94,45.12,43.56,40.38,37.47,34.28,30.5,26.5,25.31,24.69,25.06,27.81,30.19,31.62,33.81,35.56,35.06,36.22,35.53,31.44,28.94,24.06,21.12,19.78,20.0,21.78,22.06,22.09,21.59,19.03,18.62,17.0,20.06,22.31,24.84,29.12,31.53,34.78,38.03,39.34,42.22,43.34,42.41,42.31,38.97,37.66,33.94,32.88,32.5,31.84,29.75,31.69,30.38,30.81,32.31,33.75,35.53,35.84,36.19,37.56,39.78,41.12,43.03,45.56,44.09,41.53,41.62,36.38,33.72,32.09,28.94,30.5,30.41,32.62,34.75,35.72,37.69,38.38,39.88,43.03,44.84,46.88,49.12,49.69,50.56,50.06,49.09,47.62,46.62,45.09,43.97,45.06,45.31,46.44,47.75,47.91,47.5,46.84,45.53,43.47,44.19,42.75,44.03,43.38,46.41,48.31,49.84,52.12,54.22,54.66,53.69,52.56,49.66,44.94,43.47,42.28,40.53,40.53,43.69,44.53,45.34,47.09,46.31,46.09,45.56,45.69,46.09,47.25,46.5,47.59,47.12,48.0,49.81,50.5,51.0,51.91,49.66,49.41,48.44,47.81,46.56,46.94,44.66,45.69,46.62,47.16,47.75,49.97,48.56,49.03,49.56,49.41,48.44,49.22,47.62,46.91,46.12,45.03,43.91,42.81,43.16,43.44,44.22,46.44,45.03,42.94,43.66,39.41,39.09,38.56,40.31,40.03,39.97,42.16,40.75,41.44,40.62,41.03,40.69,41.25,40.78,40.19,41.19,40.62,39.25,40.56,38.53,37.31,36.62,35.5,33.53,36.31,37.0,38.34,40.53,42.81,44.25,44.75,45.84,49.41,50.34,50.53,49.81,47.69,43.38,39.62,34.66,32.72,30.16,28.19,28.16,28.38,27.59,26.72,26.66,27.75,26.28,29.03,30.34,31.47,33.28,36.59,38.41,39.97,41.56,44.59,42.53,43.56,43.31,41.06,41.31,39.78,39.38,37.31,37.28,35.94,38.25,38.47,39.56,41.03,43.0,42.19,43.5,44.5,43.25,42.38,42.09,42.75,42.47,42.25,41.47,40.56,39.31,38.06,37.91,35.31,36.0,35.31,34.91,35.62,34.84,35.06,35.16,32.31,33.12,33.41,32.5,34.78,35.75,37.69,39.5,40.53,40.66,41.06,40.12,38.94,38.16,36.94,39.66,40.53,42.44,45.41,48.5,48.53,51.19,50.44,50.03,49.34,46.62,45.81,44.53,42.53,40.5,37.09,31.94,29.12,25.03,22.19,21.59,22.97,23.62,25.16,27.28,29.25,30.75,31.56,30.5,29.44,27.09,24.75,22.88,23.97,23.94,24.31,31.19,33.31,36.69,41.94,42.75,43.94,43.62,42.31,42.12,40.25,38.5,38.09,38.56,40.66,41.06,43.41,44.16,44.19,43.16,42.69,41.0,40.69,40.69,40.31,41.72,42.38,39.41,39.0,35.84,32.81,34.09,34.91,34.59,37.66,39.25,39.81,41.12,40.31,40.12,39.0,37.41,36.88,35.03,31.94,32.94,31.97,30.31,33.19,34.16,32.47,35.19,34.38,35.03,35.75,36.06,36.56,35.12,34.16,34.66,33.31,35.16,37.84,37.88,41.56,39.34,40.09,40.22,39.12,40.56,40.59,42.12,41.5,42.12,42.38,43.94,43.78,44.69,43.31,42.56,40.22,39.16,37.62,38.62,38.03,39.75,38.12,40.97,42.03,43.34,44.28,45.5,45.19,44.09,41.94,41.22,40.47,37.31,35.72,33.81,32.72,32.81,34.78,36.94,40.81,43.12,43.06,44.78,45.53,44.75,45.56,47.19,45.91,46.28,43.59,45.81,44.06,44.5,45.19,47.44,46.78,48.41,49.59,49.0,50.19,50.16,50.56,47.94,49.41,46.59,46.34,45.75,44.25,47.09,47.5,49.03,51.12,51.12,50.03,49.81,47.06,44.69,44.44,43.81,44.5,45.59,46.62,49.06,49.44,49.66,48.91,50.81,48.53,49.94,51.47,52.31,54.0,54.41,54.75,53.5,51.81,51.78,49.12,47.34,47.88,44.94,43.41,42.5,42.44,41.72,43.12,43.41,45.28,44.69,42.38,42.84,39.31,39.72,35.88,35.03,33.62,32.09,30.25,31.06,31.84,33.25,33.28,36.44,35.38,35.88,34.78,34.31,34.75,33.56,34.31,33.75,34.34,35.16,34.81,34.69,34.81,34.22,33.75,31.47,33.59,32.28,33.28,35.56,39.25,40.38,40.69,38.91,39.25,37.62,38.28,40.5,40.34,42.62,42.84,42.5,43.88,44.78,46.78,47.0,47.34,48.25,45.78,43.41,43.53,41.84,41.53,42.44,41.0,39.69,38.31,37.0,35.38,35.62,34.19,33.84,34.38,34.75,34.22,36.16,37.0,36.88,38.56,39.28,38.56,37.59,34.53,32.91,33.22,34.0,36.62,38.84,41.81,39.69,39.81,37.97,37.69,37.03,37.97,38.5,39.81,40.91,39.69,40.94,40.31,38.31,40.31,39.0,39.75,41.72,41.0,36.75,39.56,37.91,39.31,42.88,44.31,45.25,46.12,46.03,47.44,48.69,51.5,54.03,54.56,53.81,53.19,50.47,45.81,43.28,39.5,33.88,32.06,30.81,30.28,32.0,32.41,33.22,32.88,30.84,29.31,29.09,28.91,30.56,32.69,34.81,35.94,37.34,37.78,39.5,39.06,40.19,36.69,37.72,35.91,33.66,34.69,34.72,33.91,36.12,36.06,37.75,40.69,43.41,44.56,42.97,45.12,42.97,43.06,43.34,42.25,42.03,40.22,38.47,39.34,38.16,36.31,37.19,29.06,30.5,32.28,33.06,33.59,32.91,31.91,30.66,29.25,27.91,27.19,26.88,26.28,26.09,27.31,26.78,26.0,23.66,23.16,21.03,19.44,19.78,19.44,20.44,19.16,19.91,21.06,23.88,25.97,28.62:negativity
6.66,8.0,9.03,9.41,10.16,9.53,8.66,7.62,7.0,4.44,3.94,3.22,2.31,3.22,4.0,5.31,7.19,7.41,8.28,9.19,8.59,8.16,7.38,7.84,7.09,5.78,5.19,4.38,3.28,2.69,2.28,1.91,1.09,0.25,-0.19,-0.31,0.16,1.31,2.66,4.41,5.94,7.66,8.72,9.28,10.19,10.94,11.41,12.16,12.5,14.19,13.88,13.94,14.72,13.31,11.66,10.34,6.78,5.12,3.03,0.94,0.03,-1.97,-1.56,-2.41,-1.84,-1.03,-1.47,-1.53,-2.59,-4.34,-5.09,-6.19,-6.66,-6.59,-5.56,-5.62,-5.38,-5.59,-6.09,-7.19,-7.56,-7.97,-7.34,-6.19,-6.0,-5.78,-4.97,-4.78,-3.16,-1.66,0.12,1.53,1.88,1.94,1.03,0.47,0.0,-1.19,-2.09,-2.72,-4.06,-4.12,-3.81,-2.66,-1.91,-2.03,-1.28,-2.09,-3.97,-5.66,-7.06,-7.09,-7.19,-5.84,-4.88,-2.81,-2.03,-2.03,-1.81,-0.72,-1.22,0.88,1.56,4.53,5.97,7.03,8.06,8.22,7.38,8.31,7.47,8.09,7.66,6.28,6.19,5.69,5.88,6.88,7.91,9.75,11.78,12.91,14.72,16.69,17.5,17.94,18.12,19.56,18.97,18.31,18.19,16.69,15.12,12.72,11.31,10.0,9.47,9.38,9.41,11.22,10.5,11.19,12.47,13.62,15.34,17.19,18.38,19.19,18.19,18.66,18.25,18.94,19.66,20.38,20.84,21.03,19.81,19.06,17.47,16.78,16.19,16.81,17.06,16.72,17.91,17.88,17.75,17.16,17.0,15.19,13.0,10.56,9.25,8.47,8.34,10.44,12.62,14.34,17.47,20.03,21.12,21.44,22.28,20.91,18.81,16.44,14.66,12.91,12.06,11.69,13.12,14.81,16.31,18.66,21.12,21.38,21.12,20.16,17.06,14.06,10.91,8.38,8.56,9.12,12.78,16.28,20.19,24.44,26.62,28.25,28.31,27.94,25.97,24.59,23.28,21.88,20.69,19.94,19.16,17.84,16.53,14.16,14.0,14.12,14.88,16.03,17.44,18.31,18.19,17.94,18.31,18.56,18.88,18.72,18.91,18.91,18.81,19.62,19.88,20.59,20.41,19.88,17.69,16.44,14.25,12.47,11.38,10.5,10.22,11.31,11.66,12.62,14.88,15.56,16.78,18.12,19.5,20.44,21.62,23.31,23.31,23.69,22.75,22.69,22.31,22.31,22.53,23.84,24.0,23.66,24.47,24.09,24.31,23.75,22.91,21.38,19.44,18.19,18.47,18.47,18.25,19.0,19.28,18.56,18.25,18.06,17.38,17.31,16.94,17.19,16.66,16.56,15.81,15.91,14.62,14.69,14.56,14.34,15.75,16.31,17.94,19.53,19.69,19.75,19.47,18.62,17.34,16.53,15.25,14.31,13.97,13.28,13.94,13.47,14.19,13.97,14.44,13.88,14.12,13.94,13.88,13.19,13.47,14.22,14.62,15.78,18.47,19.78,22.06,22.41,22.38,21.84,21.22,19.5,17.78,16.41,13.59,10.62,7.69,4.91,1.5,-0.44,-1.5,-2.66,-1.91,-0.06,2.09,5.0,6.66,9.66,10.88,12.72,14.75,15.53,16.38,16.75,15.88,16.25,15.31,14.16,14.91,13.75,13.91,15.06,16.22,18.06,20.56,21.81,21.19,20.56,17.94,15.75,13.59,13.03,11.56,12.25,12.69,13.44,14.56,14.94,15.56,14.97,14.12,13.69,12.75,12.53,12.06,12.19,13.47,13.53,14.53,16.84,18.19,17.91,18.31,17.97,16.72,15.88,16.09,16.75,18.16,19.69,21.47,23.12,24.44,24.78,25.12,23.91,24.19,23.62,23.66,24.59,24.94,26.44,26.69,27.41,27.31,27.06,27.44,25.88,25.69,24.53,23.0,21.28,19.97,19.34,19.34,19.25,21.16,22.53,22.97,22.78,22.16,20.59,19.31,17.56,17.25,17.81,17.81,19.41,20.69,23.25,23.97,25.25,26.62,26.69,26.88,26.0,25.34,24.34,22.41,21.75,21.06,19.97,19.31,19.53,19.22,19.44,20.0,20.41,20.75,20.81,20.31,19.66,19.31,17.59,15.62,14.62,13.38,11.94,11.06,11.41,12.62,13.06,14.38,17.81,19.25,21.41,23.84,25.16,26.38,26.53,25.81,25.22,24.69,23.19,22.59,21.97,20.56,18.91,19.16,19.12,19.12,20.38,20.88,22.09,22.19,22.25,22.41,21.0,20.03,17.59,15.38,14.75,12.56,12.06,11.25,10.34,9.06,9.06,7.94,8.59,8.06,8.25,9.47,11.41,13.47,16.59,19.28,19.81,21.06,20.78,20.19,20.34,20.19,19.19,19.03,18.56,18.75,19.56,19.94,19.41,20.09,19.12,19.41,19.03,19.84,20.16,19.47,18.81,16.91,16.56,15.03,14.75,15.38,15.66,15.81,17.19,16.28,15.72,15.06,14.06,13.94,13.56,14.31,14.56,14.44,14.56,14.38,14.0,14.22,13.75,14.28,14.59,15.09,15.31,15.56,14.44,14.0,14.38,15.19,16.38,18.09,19.06,19.97,20.19,19.59,19.31,18.94,18.69,17.91,18.16,18.31,19.25,18.78,20.34,22.06,23.38,24.12,25.66,25.91,24.06,23.53,21.53,20.44,21.0,21.28,22.78,23.34,23.56,23.12,21.47,20.81,20.44,19.56,19.19,19.31,19.66,19.69,19.59,20.47,20.53,19.72,19.19,17.69,14.94,12.44,10.62,8.88,8.59,8.34,8.75,9.69,11.81,13.78,15.12,17.16,18.81,20.19,22.0,23.81,26.12,27.16,26.62,26.69,26.62,26.28,26.72,26.75,27.34,28.06,28.5,30.34,31.94,34.34,35.81,36.66,37.34,37.09,36.03,34.41,32.91,32.25,31.62,31.56,32.75,33.22,32.69,32.41,31.16,29.53,27.38,25.91,23.59,21.75,19.88,19.06,17.78,17.12,17.06,16.94,17.19,17.62,18.62,20.5,21.78,23.19,23.75,23.31,21.88,20.38,18.34,16.69,15.62,14.06,13.44,11.84,10.44,10.62,10.09,10.09,10.66,10.34,9.56,9.41,8.72,9.66,10.66,12.47,12.75,14.59,15.78,15.81,17.75,18.69,19.38,20.62,20.16,19.06,17.28,15.75,13.62,11.44,10.41,8.81,7.81,6.94,6.88,6.31,6.16,6.47,7.31,7.41,9.41,9.75,10.44,10.5,10.12,9.84,9.41,8.84,8.56,8.91,8.94,9.56,9.31,8.94,8.44,7.12,6.12,5.12,5.31,4.72,4.59,4.31,3.59,3.09,3.22,3.75,4.19,4.88,5.78,6.78,7.16,7.56,7.78,7.25,6.84,5.97,5.69,6.0,6.12,6.84,8.0,9.62,9.97,11.62,13.16,14.03,14.81,16.44,16.94,16.97,16.09,14.34,12.59,10.66,9.16,7.78,8.12,7.19,7.12,7.16,6.66,5.03,4.09,3.41,2.59,2.91,3.03,4.62,5.16,6.44,7.16,8.0,9.12,8.81,8.97,8.06,7.12,5.91,4.41,4.56,4.19,4.03,4.31,5.34,5.19,6.44,7.41,9.56,9.72,9.0,8.06,5.91,3.03,1.91,0.78,-0.12,-0.56,-0.97,-1.66,-2.19,-3.12,-3.69,-3.72,-3.06,-2.44,-0.03,1.66,3.0,3.91,4.5,5.25,5.84,5.62,5.56,5.44,4.44,2.81,2.03,1.09,0.53,0.47,1.41,1.94,3.62,4.72,6.09,7.38,7.56,6.84,5.94,5.09,4.38,4.41,5.28,5.88,7.41,8.94,9.84,11.31,12.91,13.03,13.81,14.03,14.06,13.91,14.16,14.72,14.69,15.0,15.31,13.81,14.41,14.78:8.66,7.62,7.0,4.44,3.94,3.22,2.31,3.22,4.0,5.31,7.19,7.41,8.28,9.19,8.59,8.16,7.38,7.84,7.09,5.78,5.19,4.38,3.28,2.69,2.28,1.91,1.09,0.25,-0.19,-0.31,0.16,1.31,2.66,4.41,5.94,7.66,8.72,9.28,10.19,10.94,11.41,12.16,12.5,14.19,13.88,13.94,14.72,13.31,11.66,10.34,6.78,5.12,3.03,0.94,0.03,-1.97,-1.56,-2.41,-1.84,-1.03,-1.47,-1.53,-2.59,-4.34,-5.09,-6.19,-6.66,-6.59,-5.56,-5.62,-5.38,-5.59,-6.09,-7.19,-7.56,-7.97,-7.34,-6.19,-6.0,-5.78,-4.97,-4.78,-3.16,-1.66,0.12,1.53,1.88,1.94,1.03,0.47,0.0,-1.19,-2.09,-2.72,-4.06,-4.12,-3.81,-2.66,-1.91,-2.03,-1.28,-2.09,-3.97,-5.66,-7.06,-7.09,-7.19,-5.84,-4.88,-2.81,-2.03,-2.03,-1.81,-0.72,-1.22,0.88,1.56,4.53,5.97,7.03,8.06,8.22,7.38,8.31,7.47,8.09,7.66,6.28,6.19,5.69,5.88,6.88,7.91,9.75,11.78,12.91,14.72,16.69,17.5,17.94,18.12,19.56,18.97,18.31,18.19,16.69,15.12,12.72,11.31,10.0,9.47,9.38,9.41,11.22,10.5,11.19,12.47,13.62,15.34,17.19,18.38,19.19,18.19,18.66,18.25,18.94,19.66,20.38,20.84,21.03,19.81,19.06,17.47,16.78,16.19,16.81,17.06,16.72,17.91,17.88,17.75,17.16,17.0,15.19,13.0,10.56,9.25,8.47,8.34,10.44,12.62,14.34,17.47,20.03,21.12,21.44,22.28,20.91,18.81,16.44,14.66,12.91,12.06,11.69,13.12,14.81,16.31,18.66,21.12,21.38,21.12,20.16,17.06,14.06,10.91,8.38,8.56,9.12,12.78,16.28,20.19,24.44,26.62,28.25,28.31,27.94,25.97,24.59,23.28,21.88,20.69,19.94,19.16,17.84,16.53,14.16,14.0,14.12,14.88,16.03,17.44,18.31,18.19,17.94,18.31,18.56,18.88,18.72,18.91,18.91,18.81,19.62,19.88,20.59,20.41,19.88,17.69,16.44,14.25,12.47,11.38,10.5,10.22,11.31,11.66,12.62,14.88,15.56,16.78,18.12,19.5,20.44,21.62,23.31,23.31,23.69,22.75,22.69,22.31,22.31,22.53,23.84,24.0,23.66,24.47,24.09,24.31,23.75,22.91,21.38,19.44,18.19,18.47,18.47,18.25,19.0,19.28,18.56,18.25,18.06,17.38,17.31,16.94,17.19,16.66,16.56,15.81,15.91,14.62,14.69,14.56,14.34,15.75,16.31,17.94,19.53,19.69,19.75,19.47,18.62,17.34,16.53,15.25,14.31,13.97,13.28,13.94,13.47,14.19,13.97,14.44,13.88,14.12,13.94,13.88,13.19,13.47,14.22,14.62,15.78,18.47,19.78,22.06,22.41,22.38,21.84,21.22,19.5,17.78,16.41,13.59,10.62,7.69,4.91,1.5,-0.44,-1.5,-2.66,-1.91,-0.06,2.09,5.0,6.66,9.66,10.88,12.72,14.75,15.53,16.38,16.75,15.88,16.25,15.31,14.16,14.91,13.75,13.91,15.06,16.22,18.06,20.56,21.81,21.19,20.56,17.94,15.75,13.59,13.03,11.56,12.25,12.69,13.44,14.56,14.94,15.56,14.97,14.12,13.69,12.75,12.53,12.06,12.19,13.47,13.53,14.53,16.84,18.19,17.91,18.31,17.97,16.72,15.88,16.09,16.75,18.16,19.69,21.47,23.12,24.44,24.78,25.12,23.91,24.19,23.62,23.66,24.59,24.94,26.44,26.69,27.41,27.31,27.06,27.44,25.88,25.69,24.53,23.0,21.28,19.97,19.34,19.34,19.25,21.16,22.53,22.97,22.78,22.16,20.59,19.31,17.56,17.25,17.81,17.81,19.41,20.69,23.25,23.97,25.25,26.62,26.69,26.88,26.0,25.34,24.34,22.41,21.75,21.06,19.97,19.31,19.53,19.22,19.44,20.0,20.41,20.75,20.81,20.31,19.66,19.31,17.59,15.62,14.62,13.38,11.94,11.06,11.41,12.62,13.06,14.38,17.81,19.25,21.41,23.84,25.16,26.38,26.53,25.81,25.22,24.69,23.19,22.59,21.97,20.56,18.91,19.16,19.12,19.12,20.38,20.88,22.09,22.19,22.25,22.41,21.0,20.03,17.59,15.38,14.75,12.56,12.06,11.25,10.34,9.06,9.06,7.94,8.59,8.06,8.25,9.47,11.41,13.47,16.59,19.28,19.81,21.06,20.78,20.19,20.34,20.19,19.19,19.03,18.56,18.75,19.56,19.94,19.41,20.09,19.12,19.41,19.03,19.84,20.16,19.47,18.81,16.91,16.56,15.03,14.75,15.38,15.66,15.81,17.19,16.28,15.72,15.06,14.06,13.94,13.56,14.31,14.56,14.44,14.56,14.38,14.0,14.22,13.75,14.28,14.59,15.09,15.31,15.56,14.44,14.0,14.38,15.19,16.38,18.09,19.06,19.97,20.19,19.59,19.31,18.94,18.69,17.91,18.16,18.31,19.25,18.78,20.34,22.06,23.38,24.12,25.66,25.91,24.06,23.53,21.53,20.44,21.0,21.28,22.78,23.34,23.56,23.12,21.47,20.81,20.44,19.56,19.19,19.31,19.66,19.69,19.59,20.47,20.53,19.72,19.19,17.69,14.94,12.44,10.62,8.88,8.59,8.34,8.75,9.69,11.81,13.78,15.12,17.16,18.81,20.19,22.0,23.81,26.12,27.16,26.62,26.69,26.62,26.28,26.72,26.75,27.34,28.06,28.5,30.34,31.94,34.34,35.81,36.66,37.34,37.09,36.03,34.41,32.91,32.25,31.62,31.56,32.75,33.22,32.69,32.41,31.16,29.53,27.38,25.91,23.59,21.75,19.88,19.06,17.78,17.12,17.06,16.94,17.19,17.62,18.62,20.5,21.78,23.19,23.75,23.31,21.88,20.38,18.34,16.69,15.62,14.06,13.44,11.84,10.44,10.62,10.09,10.09,10.66,10.34,9.56,9.41,8.72,9.66,10.66,12.47,12.75,14.59,15.78,15.81,17.75,18.69,19.38,20.62,20.16,19.06,17.28,15.75,13.62,11.44,10.41,8.81,7.81,6.94,6.88,6.31,6.16,6.47,7.31,7.41,9.41,9.75,10.44,10.5,10.12,9.84,9.41,8.84,8.56,8.91,8.94,9.56,9.31,8.94,8.44,7.12,6.12,5.12,5.31,4.72,4.59,4.31,3.59,3.09,3.22,3.75,4.19,4.88,5.78,6.78,7.16,7.56,7.78,7.25,6.84,5.97,5.69,6.0,6.12,6.84,8.0,9.62,9.97,11.62,13.16,14.03,14.81,16.44,16.94,16.97,16.09,14.34,12.59,10.66,9.16,7.78,8.12,7.19,7.12,7.16,6.66,5.03,4.09,3.41,2.59,2.91,3.03,4.62,5.16,6.44,7.16,8.0,9.12,8.81,8.97,8.06,7.12,5.91,4.41,4.56,4.19,4.03,4.31,5.34,5.19,6.44,7.41,9.56,9.72,9.0,8.06,5.91,3.03,1.91,0.78,-0.12,-0.56,-0.97,-1.66,-2.19,-3.12,-3.69,-3.72,-3.06,-2.44,-0.03,1.66,3.0,3.91,4.5,5.25,5.84,5.62,5.56,5.44,4.44,2.81,2.03,1.09,0.53,0.47,1.41,1.94,3.62,4.72,6.09,7.38,7.56,6.84,5.94,5.09,4.38,4.41,5.28,5.88,7.41,8.94,9.84,11.31,12.91,13.03,13.81,14.03,14.06,13.91,14.16,14.72,14.69,15.0,15.31,13.81,14.41,14.78,-7.06,-6.53,-6.31,-5.31,-4.81,-4.66:2.31,3.22,4.0,5.31,7.19,7.41,8.28,9.19,8.59,8.16,7.38,7.84,7.09,5.78,5.19,4.38,3.28,2.69,2.28,1.91,1.09,0.25,-0.19,-0.31,0.16,1.31,2.66,4.41,5.94,7.66,8.72,9.28,10.19,10.94,11.41,12.16,12.5,14.19,13.88,13.94,14.72,13.31,11.66,10.34,6.78,5.12,3.03,0.94,0.03,-1.97,-1.56,-2.41,-1.84,-1.03,-1.47,-1.53,-2.59,-4.34,-5.09,-6.19,-6.66,-6.59,-5.56,-5.62,-5.38,-5.59,-6.09,-7.19,-7.56,-7.97,-7.34,-6.19,-6.0,-5.78,-4.97,-4.78,-3.16,-1.66,0.12,1.53,1.88,1.94,1.03,0.47,0.0,-1.19,-2.09,-2.72,-4.06,-4.12,-3.81,-2.66,-1.91,-2.03,-1.28,-2.09,-3.97,-5.66,-7.06,-7.09,-7.19,-5.84,-4.88,-2.81,-2.03,-2.03,-1.81,-0.72,-1.22,0.88,1.56,4.53,5.97,7.03,8.06,8.22,7.38,8.31,7.47,8.09,7.66,6.28,6.19,5.69,5.88,6.88,7.91,9.75,11.78,12.91,14.72,16.69,17.5,17.94,18.12,19.56,18.97,18.31,18.19,16.69,15.12,12.72,11.31,10.0,9.47,9.38,9.41,11.22,10.5,11.19,12.47,13.62,15.34,17.19,18.38,19.19,18.19,18.66,18.25,18.94,19.66,20.38,20.84,21.03,19.81,19.06,17.47,16.78,16.19,16.81,17.06,16.72,17.91,17.88,17.75,17.16,17.0,15.19,13.0,10.56,9.25,8.47,8.34,10.44,12.62,14.34,17.47,20.03,21.12,21.44,22.28,20.91,18.81,16.44,14.66,12.91,12.06,11.69,13.12,14.81,16.31,18.66,21.12,21.38,21.12,20.16,17.06,14.06,10.91,8.38,8.56,9.12,12.78,16.28,20.19,24.44,26.62,28.25,28.31,27.94,25.97,24.59,23.28,21.88,20.69,19.94,19.16,17.84,16.53,14.16,14.0,14.12,14.88,16.03,17.44,18.31,18.19,17.94,18.31,18.56,18.88,18.72,18.91,18.91,18.81,19.62,19.88,20.59,20.41,19.88,17.69,16.44,14.25,12.47,11.38,10.5,10.22,11.31,11.66,12.62,14.88,15.56,16.78,18.12,19.5,20.44,21.62,23.31,23.31,23.69,22.75,22.69,22.31,22.31,22.53,23.84,24.0,23.66,24.47,24.09,24.31,23.75,22.91,21.38,19.44,18.19,18.47,18.47,18.25,19.0,19.28,18.56,18.25,18.06,17.38,17.31,16.94,17.19,16.66,16.56,15.81,15.91,14.62,14.69,14.56,14.34,15.75,16.31,17.94,19.53,19.69,19.75,19.47,18.62,17.34,16.53,15.25,14.31,13.97,13.28,13.94,13.47,14.19,13.97,14.44,13.88,14.12,13.94,13.88,13.19,13.47,14.22,14.62,15.78,18.47,19.78,22.06,22.41,22.38,21.84,21.22,19.5,17.78,16.41,13.59,10.62,7.69,4.91,1.5,-0.44,-1.5,-2.66,-1.91,-0.06,2.09,5.0,6.66,9.66,10.88,12.72,14.75,15.53,16.38,16.75,15.88,16.25,15.31,14.16,14.91,13.75,13.91,15.06,16.22,18.06,20.56,21.81,21.19,20.56,17.94,15.75,13.59,13.03,11.56,12.25,12.69,13.44,14.56,14.94,15.56,14.97,14.12,13.69,12.75,12.53,12.06,12.19,13.47,13.53,14.53,16.84,18.19,17.91,18.31,17.97,16.72,15.88,16.09,16.75,18.16,19.69,21.47,23.12,24.44,24.78,25.12,23.91,24.19,23.62,23.66,24.59,24.94,26.44,26.69,27.41,27.31,27.06,27.44,25.88,25.69,24.53,23.0,21.28,19.97,19.34,19.34,19.25,21.16,22.53,22.97,22.78,22.16,20.59,19.31,17.56,17.25,17.81,17.81,19.41,20.69,23.25,23.97,25.25,26.62,26.69,26.88,26.0,25.34,24.34,22.41,21.75,21.06,19.97,19.31,19.53,19.22,19.44,20.0,20.41,20.75,20.81,20.31,19.66,19.31,17.59,15.62,14.62,13.38,11.94,11.06,11.41,12.62,13.06,14.38,17.81,19.25,21.41,23.84,25.16,26.38,26.53,25.81,25.22,24.69,23.19,22.59,21.97,20.56,18.91,19.16,19.12,19.12,20.38,20.88,22.09,22.19,22.25,22.41,21.0,20.03,17.59,15.38,14.75,12.56,12.06,11.25,10.34,9.06,9.06,7.94,8.59,8.06,8.25,9.47,11.41,13.47,16.59,19.28,19.81,21.06,20.78,20.19,20.34,20.19,19.19,19.03,18.56,18.75,19.56,19.94,19.41,20.09,19.12,19.41,19.03,19.84,20.16,19.47,18.81,16.91,16.56,15.03,14.75,15.38,15.66,15.81,17.19,16.28,15.72,15.06,14.06,13.94,13.56,14.31,14.56,14.44,14.56,14.38,14.0,14.22,13.75,14.28,14.59,15.09,15.31,15.56,14.44,14.0,14.38,15.19,16.38,18.09,19.06,19.97,20.19,19.59,19.31,18.94,18.69,17.91,18.16,18.31,19.25,18.78,20.34,22.06,23.38,24.12,25.66,25.91,24.06,23.53,21.53,20.44,21.0,21.28,22.78,23.34,23.56,23.12,21.47,20.81,20.44,19.56,19.19,19.31,19.66,19.69,19.59,20.47,20.53,19.72,19.19,17.69,14.94,12.44,10.62,8.88,8.59,8.34,8.75,9.69,11.81,13.78,15.12,17.16,18.81,20.19,22.0,23.81,26.12,27.16,26.62,26.69,26.62,26.28,26.72,26.75,27.34,28.06,28.5,30.34,31.94,34.34,35.81,36.66,37.34,37.09,36.03,34.41,32.91,32.25,31.62,31.56,32.75,33.22,32.69,32.41,31.16,29.53,27.38,25.91,23.59,21.75,19.88,19.06,17.78,17.12,17.06,16.94,17.19,17.62,18.62,20.5,21.78,23.19,23.75,23.31,21.88,20.38,18.34,16.69,15.62,14.06,13.44,11.84,10.44,10.62,10.09,10.09,10.66,10.34,9.56,9.41,8.72,9.66,10.66,12.47,12.75,14.59,15.78,15.81,17.75,18.69,19.38,20.62,20.16,19.06,17.28,15.75,13.62,11.44,10.41,8.81,7.81,6.94,6.88,6.31,6.16,6.47,7.31,7.41,9.41,9.75,10.44,10.5,10.12,9.84,9.41,8.84,8.56,8.91,8.94,9.56,9.31,8.94,8.44,7.12,6.12,5.12,5.31,4.72,4.59,4.31,3.59,3.09,3.22,3.75,4.19,4.88,5.78,6.78,7.16,7.56,7.78,7.25,6.84,5.97,5.69,6.0,6.12,6.84,8.0,9.62,9.97,11.62,13.16,14.03,14.81,16.44,16.94,16.97,16.09,14.34,12.59,10.66,9.16,7.78,8.12,7.19,7.12,7.16,6.66,5.03,4.09,3.41,2.59,2.91,3.03,4.62,5.16,6.44,7.16,8.0,9.12,8.81,8.97,8.06,7.12,5.91,4.41,4.56,4.19,4.03,4.31,5.34,5.19,6.44,7.41,9.56,9.72,9.0,8.06,5.91,3.03,1.91,0.78,-0.12,-0.56,-0.97,-1.66,-2.19,-3.12,-3.69,-3.72,-3.06,-2.44,-0.03,1.66,3.0,3.91,4.5,5.25,5.84,5.62,5.56,5.44,4.44,2.81,2.03,1.09,0.53,0.47,1.41,1.94,3.62,4.72,6.09,7.38,7.56,6.84,5.94,5.09,4.38,4.41,5.28,5.88,7.41,8.94,9.84,11.31,12.91,13.03,13.81,14.03,14.06,13.91,14.16,14.72,14.69,15.0,15.31,13.81,14.41,14.78,-7.06,-6.53,-6.31,-5.31,-4.81,-4.66,-5.22,-6.16,-6.69,-8.28,-9.0,-9.0:8.28,9.19,8.59,8.16,7.38,7.84,7.09,5.78,5.19,4.38,3.28,2.69,2.28,1.91,1.09,0.25,-0.19,-0.31,0.16,1.31,2.66,4.41,5.94,7.66,8.72,9.28,10.19,10.94,11.41,12.16,12.5,14.19,13.88,13.94,14.72,13.31,11.66,10.34,6.78,5.12,3.03,0.94,0.03,-1.97,-1.56,-2.41,-1.84,-1.03,-1.47,-1.53,-2.59,-4.34,-5.09,-6.19,-6.66,-6.59,-5.56,-5.62,-5.38,-5.59,-6.09,-7.19,-7.56,-7.97,-7.34,-6.19,-6.0,-5.78,-4.97,-4.78,-3.16,-1.66,0.12,1.53,1.88,1.94,1.03,0.47,0.0,-1.19,-2.09,-2.72,-4.06,-4.12,-3.81,-2.66,-1.91,-2.03,-1.28,-2.09,-3.97,-5.66,-7.06,-7.09,-7.19,-5.84,-4.88,-2.81,-2.03,-2.03,-1.81,-0.72,-1.22,0.88,1.56,4.53,5.97,7.03,8.06,8.22,7.38,8.31,7.47,8.09,7.66,6.28,6.19,5.69,5.88,6.88,7.91,9.75,11.78,12.91,14.72,16.69,17.5,17.94,18.12,19.56,18.97,18.31,18.19,16.69,15.12,12.72,11.31,10.0,9.47,9.38,9.41,11.22,10.5,11.19,12.47,13.62,15.34,17.19,18.38,19.19,18.19,18.66,18.25,18.94,19.66,20.38,20.84,21.03,19.81,19.06,17.47,16.78,16.19,16.81,17.06,16.72,17.91,17.88,17.75,17.16,17.0,15.19,13.0,10.56,9.25,8.47,8.34,10.44,12.62,14.34,17.47,20.03,21.12,21.44,22.28,20.91,18.81,16.44,14.66,12.91,12.06,11.69,13.12,14.81,16.31,18.66,21.12,21.38,21.12,20.16,17.06,14.06,10.91,8.38,8.56,9.12,12.78,16.28,20.19,24.44,26.62,28.25,28.31,27.94,25.97,24.59,23.28,21.88,20.69,19.94,19.16,17.84,16.53,14.16,14.0,14.12,14.88,16.03,17.44,18.31,18.19,17.94,18.31,18.56,18.88,18.72,18.91,18.91,18.81,19.62,19.88,20.59,20.41,19.88,17.69,16.44,14.25,12.47,11.38,10.5,10.22,11.31,11.66,12.62,14.88,15.56,16.78,18.12,19.5,20.44,21.62,23.31,23.31,23.69,22.75,22.69,22.31,22.31,22.53,23.84,24.0,23.66,24.47,24.09,24.31,23.75,22.91,21.38,19.44,18.19,18.47,18.47,18.25,19.0,19.28,18.56,18.25,18.06,17.38,17.31,16.94,17.19,16.66,16.56,15.81,15.91,14.62,14.69,14.56,14.34,15.75,16.31,17.94,19.53,19.69,19.75,19.47,18.62,17.34,16.53,15.25,14.31,13.97,13.28,13.94,13.47,14.19,13.97,14.44,13.88,14.12,13.94,13.88,13.19,13.47,14.22,14.62,15.78,18.47,19.78,22.06,22.41,22.38,21.84,21.22,19.5,17.78,16.41,13.59,10.62,7.69,4.91,1.5,-0.44,-1.5,-2.66,-1.91,-0.06,2.09,5.0,6.66,9.66,10.88,12.72,14.75,15.53,16.38,16.75,15.88,16.25,15.31,14.16,14.91,13.75,13.91,15.06,16.22,18.06,20.56,21.81,21.19,20.56,17.94,15.75,13.59,13.03,11.56,12.25,12.69,13.44,14.56,14.94,15.56,14.97,14.12,13.69,12.75,12.53,12.06,12.19,13.47,13.53,14.53,16.84,18.19,17.91,18.31,17.97,16.72,15.88,16.09,16.75,18.16,19.69,21.47,23.12,24.44,24.78,25.12,23.91,24.19,23.62,23.66,24.59,24.94,26.44,26.69,27.41,27.31,27.06,27.44,25.88,25.69,24.53,23.0,21.28,19.97,19.34,19.34,19.25,21.16,22.53,22.97,22.78,22.16,20.59,19.31,17.56,17.25,17.81,17.81,19.41,20.69,23.25,23.97,25.25,26.62,26.69,26.88,26.0,25.34,24.34,22.41,21.75,21.06,19.97,19.31,19.53,19.22,19.44,20.0,20.41,20.75,20.81,20.31,19.66,19.31,17.59,15.62,14.62,13.38,11.94,11.06,11.41,12.62,13.06,14.38,17.81,19.25,21.41,23.84,25.16,26.38,26.53,25.81,25.22,24.69,23.19,22.59,21.97,20.56,18.91,19.16,19.12,19.12,20.38,20.88,22.09,22.19,22.25,22.41,21.0,20.03,17.59,15.38,14.75,12.56,12.06,11.25,10.34,9.06,9.06,7.94,8.59,8.06,8.25,9.47,11.41,13.47,16.59,19.28,19.81,21.06,20.78,20.19,20.34,20.19,19.19,19.03,18.56,18.75,19.56,19.94,19.41,20.09,19.12,19.41,19.03,19.84,20.16,19.47,18.81,16.91,16.56,15.03,14.75,15.38,15.66,15.81,17.19,16.28,15.72,15.06,14.06,13.94,13.56,14.31,14.56,14.44,14.56,14.38,14.0,14.22,13.75,14.28,14.59,15.09,15.31,15.56,14.44,14.0,14.38,15.19,16.38,18.09,19.06,19.97,20.19,19.59,19.31,18.94,18.69,17.91,18.16,18.31,19.25,18.78,20.34,22.06,23.38,24.12,25.66,25.91,24.06,23.53,21.53,20.44,21.0,21.28,22.78,23.34,23.56,23.12,21.47,20.81,20.44,19.56,19.19,19.31,19.66,19.69,19.59,20.47,20.53,19.72,19.19,17.69,14.94,12.44,10.62,8.88,8.59,8.34,8.75,9.69,11.81,13.78,15.12,17.16,18.81,20.19,22.0,23.81,26.12,27.16,26.62,26.69,26.62,26.28,26.72,26.75,27.34,28.06,28.5,30.34,31.94,34.34,35.81,36.66,37.34,37.09,36.03,34.41,32.91,32.25,31.62,31.56,32.75,33.22,32.69,32.41,31.16,29.53,27.38,25.91,23.59,21.75,19.88,19.06,17.78,17.12,17.06,16.94,17.19,17.62,18.62,20.5,21.78,23.19,23.75,23.31,21.88,20.38,18.34,16.69,15.62,14.06,13.44,11.84,10.44,10.62,10.09,10.09,10.66,10.34,9.56,9.41,8.72,9.66,10.66,12.47,12.75,14.59,15.78,15.81,17.75,18.69,19.38,20.62,20.16,19.06,17.28,15.75,13.62,11.44,10.41,8.81,7.81,6.94,6.88,6.31,6.16,6.47,7.31,7.41,9.41,9.75,10.44,10.5,10.12,9.84,9.41,8.84,8.56,8.91,8.94,9.56,9.31,8.94,8.44,7.12,6.12,5.12,5.31,4.72,4.59,4.31,3.59,3.09,3.22,3.75,4.19,4.88,5.78,6.78,7.16,7.56,7.78,7.25,6.84,5.97,5.69,6.0,6.12,6.84,8.0,9.62,9.97,11.62,13.16,14.03,14.81,16.44,16.94,16.97,16.09,14.34,12.59,10.66,9.16,7.78,8.12,7.19,7.12,7.16,6.66,5.03,4.09,3.41,2.59,2.91,3.03,4.62,5.16,6.44,7.16,8.0,9.12,8.81,8.97,8.06,7.12,5.91,4.41,4.56,4.19,4.03,4.31,5.34,5.19,6.44,7.41,9.56,9.72,9.0,8.06,5.91,3.03,1.91,0.78,-0.12,-0.56,-0.97,-1.66,-2.19,-3.12,-3.69,-3.72,-3.06,-2.44,-0.03,1.66,3.0,3.91,4.5,5.25,5.84,5.62,5.56,5.44,4.44,2.81,2.03,1.09,0.53,0.47,1.41,1.94,3.62,4.72,6.09,7.38,7.56,6.84,5.94,5.09,4.38,4.41,5.28,5.88,7.41,8.94,9.84,11.31,12.91,13.03,13.81,14.03,14.06,13.91,14.16,14.72,14.69,15.0,15.31,13.81,14.41,14.78,-7.06,-6.53,-6.31,-5.31,-4.81,-4.66,-5.22,-6.16,-6.69,-8.28,-9.0,-9.0,-8.62,-7.47,-5.06,-2.22,-0.28,1.28:7.09,5.78,5.19,4.38,3.28,2.69,2.28,1.91,1.09,0.25,-0.19,-0.31,0.16,1.31,2.66,4.41,5.94,7.66,8.72,9.28,10.19,10.94,11.41,12.16,12.5,14.19,13.88,13.94,14.72,13.31,11.66,10.34,6.78,5.12,3.03,0.94,0.03,-1.97,-1.56,-2.41,-1.84,-1.03,-1.47,-1.53,-2.59,-4.34,-5.09,-6.19,-6.66,-6.59,-5.56,-5.62,-5.38,-5.59,-6.09,-7.19,-7.56,-7.97,-7.34,-6.19,-6.0,-5.78,-4.97,-4.78,-3.16,-1.66,0.12,1.53,1.88,1.94,1.03,0.47,0.0,-1.19,-2.09,-2.72,-4.06,-4.12,-3.81,-2.66,-1.91,-2.03,-1.28,-2.09,-3.97,-5.66,-7.06,-7.09,-7.19,-5.84,-4.88,-2.81,-2.03,-2.03,-1.81,-0.72,-1.22,0.88,1.56,4.53,5.97,7.03,8.06,8.22,7.38,8.31,7.47,8.09,7.66,6.28,6.19,5.69,5.88,6.88,7.91,9.75,11.78,12.91,14.72,16.69,17.5,17.94,18.12,19.56,18.97,18.31,18.19,16.69,15.12,12.72,11.31,10.0,9.47,9.38,9.41,11.22,10.5,11.19,12.47,13.62,15.34,17.19,18.38,19.19,18.19,18.66,18.25,18.94,19.66,20.38,20.84,21.03,19.81,19.06,17.47,16.78,16.19,16.81,17.06,16.72,17.91,17.88,17.75,17.16,17.0,15.19,13.0,10.56,9.25,8.47,8.34,10.44,12.62,14.34,17.47,20.03,21.12,21.44,22.28,20.91,18.81,16.44,14.66,12.91,12.06,11.69,13.12,14.81,16.31,18.66,21.12,21.38,21.12,20.16,17.06,14.06,10.91,8.38,8.56,9.12,12.78,16.28,20.19,24.44,26.62,28.25,28.31,27.94,25.97,24.59,23.28,21.88,20.69,19.94,19.16,17.84,16.53,14.16,14.0,14.12,14.88,16.03,17.44,18.31,18.19,17.94,18.31,18.56,18.88,18.72,18.91,18.91,18.81,19.62,19.88,20.59,20.41,19.88,17.69,16.44,14.25,12.47,11.38,10.5,10.22,11.31,11.66,12.62,14.88,15.56,16.78,18.12,19.5,20.44,21.62,23.31,23.31,23.69,22.75,22.69,22.31,22.31,22.53,23.84,24.0,23.66,24.47,24.09,24.31,23.75,22.91,21.38,19.44,18.19,18.47,18.47,18.25,19.0,19.28,18.56,18.25,18.06,17.38,17.31,16.94,17.19,16.66,16.56,15.81,15.91,14.62,14.69,14.56,14.34,15.75,16.31,17.94,19.53,19.69,19.75,19.47,18.62,17.34,16.53,15.25,14.31,13.97,13.28,13.94,13.47,14.19,13.97,14.44,13.88,14.12,13.94,13.88,13.19,13.47,14.22,14.62,15.78,18.47,19.78,22.06,22.41,22.38,21.84,21.22,19.5,17.78,16.41,13.59,10.62,7.69,4.91,1.5,-0.44,-1.5,-2.66,-1.91,-0.06,2.09,5.0,6.66,9.66,10.88,12.72,14.75,15.53,16.38,16.75,15.88,16.25,15.31,14.16,14.91,13.75,13.91,15.06,16.22,18.06,20.56,21.81,21.19,20.56,17.94,15.75,13.59,13.03,11.56,12.25,12.69,13.44,14.56,14.94,15.56,14.97,14.12,13.69,12.75,12.53,12.06,12.19,13.47,13.53,14.53,16.84,18.19,17.91,18.31,17.97,16.72,15.88,16.09,16.75,18.16,19.69,21.47,23.12,24.44,24.78,25.12,23.91,24.19,23.62,23.66,24.59,24.94,26.44,26.69,27.41,27.31,27.06,27.44,25.88,25.69,24.53,23.0,21.28,19.97,19.34,19.34,19.25,21.16,22.53,22.97,22.78,22.16,20.59,19.31,17.56,17.25,17.81,17.81,19.41,20.69,23.25,23.97,25.25,26.62,26.69,26.88,26.0,25.34,24.34,22.41,21.75,21.06,19.97,19.31,19.53,19.22,19.44,20.0,20.41,20.75,20.81,20.31,19.66,19.31,17.59,15.62,14.62,13.38,11.94,11.06,11.41,12.62,13.06,14.38,17.81,19.25,21.41,23.84,25.16,26.38,26.53,25.81,25.22,24.69,23.19,22.59,21.97,20.56,18.91,19.16,19.12,19.12,20.38,20.88,22.09,22.19,22.25,22.41,21.0,20.03,17.59,15.38,14.75,12.56,12.06,11.25,10.34,9.06,9.06,7.94,8.59,8.06,8.25,9.47,11.41,13.47,16.59,19.28,19.81,21.06,20.78,20.19,20.34,20.19,19.19,19.03,18.56,18.75,19.56,19.94,19.41,20.09,19.12,19.41,19.03,19.84,20.16,19.47,18.81,16.91,16.56,15.03,14.75,15.38,15.66,15.81,17.19,16.28,15.72,15.06,14.06,13.94,13.56,14.31,14.56,14.44,14.56,14.38,14.0,14.22,13.75,14.28,14.59,15.09,15.31,15.56,14.44,14.0,14.38,15.19,16.38,18.09,19.06,19.97,20.19,19.59,19.31,18.94,18.69,17.91,18.16,18.31,19.25,18.78,20.34,22.06,23.38,24.12,25.66,25.91,24.06,23.53,21.53,20.44,21.0,21.28,22.78,23.34,23.56,23.12,21.47,20.81,20.44,19.56,19.19,19.31,19.66,19.69,19.59,20.47,20.53,19.72,19.19,17.69,14.94,12.44,10.62,8.88,8.59,8.34,8.75,9.69,11.81,13.78,15.12,17.16,18.81,20.19,22.0,23.81,26.12,27.16,26.62,26.69,26.62,26.28,26.72,26.75,27.34,28.06,28.5,30.34,31.94,34.34,35.81,36.66,37.34,37.09,36.03,34.41,32.91,32.25,31.62,31.56,32.75,33.22,32.69,32.41,31.16,29.53,27.38,25.91,23.59,21.75,19.88,19.06,17.78,17.12,17.06,16.94,17.19,17.62,18.62,20.5,21.78,23.19,23.75,23.31,21.88,20.38,18.34,16.69,15.62,14.06,13.44,11.84,10.44,10.62,10.09,10.09,10.66,10.34,9.56,9.41,8.72,9.66,10.66,12.47,12.75,14.59,15.78,15.81,17.75,18.69,19.38,20.62,20.16,19.06,17.28,15.75,13.62,11.44,10.41,8.81,7.81,6.94,6.88,6.31,6.16,6.47,7.31,7.41,9.41,9.75,10.44,10.5,10.12,9.84,9.41,8.84,8.56,8.91,8.94,9.56,9.31,8.94,8.44,7.12,6.12,5.12,5.31,4.72,4.59,4.31,3.59,3.09,3.22,3.75,4.19,4.88,5.78,6.78,7.16,7.56,7.78,7.25,6.84,5.97,5.69,6.0,6.12,6.84,8.0,9.62,9.97,11.62,13.16,14.03,14.81,16.44,16.94,16.97,16.09,14.34,12.59,10.66,9.16,7.78,8.12,7.19,7.12,7.16,6.66,5.03,4.09,3.41,2.59,2.91,3.03,4.62,5.16,6.44,7.16,8.0,9.12,8.81,8.97,8.06,7.12,5.91,4.41,4.56,4.19,4.03,4.31,5.34,5.19,6.44,7.41,9.56,9.72,9.0,8.06,5.91,3.03,1.91,0.78,-0.12,-0.56,-0.97,-1.66,-2.19,-3.12,-3.69,-3.72,-3.06,-2.44,-0.03,1.66,3.0,3.91,4.5,5.25,5.84,5.62,5.56,5.44,4.44,2.81,2.03,1.09,0.53,0.47,1.41,1.94,3.62,4.72,6.09,7.38,7.56,6.84,5.94,5.09,4.38,4.41,5.28,5.88,7.41,8.94,9.84,11.31,12.91,13.03,13.81,14.03,14.06,13.91,14.16,14.72,14.69,15.0,15.31,13.81,14.41,14.78,-7.06,-6.53,-6.31,-5.31,-4.81,-4.66,-5.22,-6.16,-6.69,-8.28,-9.0,-9.0,-8.62,-7.47,-5.06,-2.22,-0.28,1.28,2.06,2.12,1.25,0.47,-0.31,0.0:2.28,1.91,1.09,0.25,-0.19,-0.31,0.16,1.31,2.66,4.41,5.94,7.66,8.72,9.28,10.19,10.94,11.41,12.16,12.5,14.19,13.88,13.94,14.72,13.31,11.66,10.34,6.78,5.12,3.03,0.94,0.03,-1.97,-1.56,-2.41,-1.84,-1.03,-1.47,-1.53,-2.59,-4.34,-5.09,-6.19,-6.66,-6.59,-5.56,-5.62,-5.38,-5.59,-6.09,-7.19,-7.56,-7.97,-7.34,-6.19,-6.0,-5.78,-4.97,-4.78,-3.16,-1.66,0.12,1.53,1.88,1.94,1.03,0.47,0.0,-1.19,-2.09,-2.72,-4.06,-4.12,-3.81,-2.66,-1.91,-2.03,-1.28,-2.09,-3.97,-5.66,-7.06,-7.09,-7.19,-5.84,-4.88,-2.81,-2.03,-2.03,-1.81,-0.72,-1.22,0.88,1.56,4.53,5.97,7.03,8.06,8.22,7.38,8.31,7.47,8.09,7.66,6.28,6.19,5.69,5.88,6.88,7.91,9.75,11.78,12.91,14.72,16.69,17.5,17.94,18.12,19.56,18.97,18.31,18.19,16.69,15.12,12.72,11.31,10.0,9.47,9.38,9.41,11.22,10.5,11.19,12.47,13.62,15.34,17.19,18.38,19.19,18.19,18.66,18.25,18.94,19.66,20.38,20.84,21.03,19.81,19.06,17.47,16.78,16.19,16.81,17.06,16.72,17.91,17.88,17.75,17.16,17.0,15.19,13.0,10.56,9.25,8.47,8.34,10.44,12.62,14.34,17.47,20.03,21.12,21.44,22.28,20.91,18.81,16.44,14.66,12.91,12.06,11.69,13.12,14.81,16.31,18.66,21.12,21.38,21.12,20.16,17.06,14.06,10.91,8.38,8.56,9.12,12.78,16.28,20.19,24.44,26.62,28.25,28.31,27.94,25.97,24.59,23.28,21.88,20.69,19.94,19.16,17.84,16.53,14.16,14.0,14.12,14.88,16.03,17.44,18.31,18.19,17.94,18.31,18.56,18.88,18.72,18.91,18.91,18.81,19.62,19.88,20.59,20.41,19.88,17.69,16.44,14.25,12.47,11.38,10.5,10.22,11.31,11.66,12.62,14.88,15.56,16.78,18.12,19.5,20.44,21.62,23.31,23.31,23.69,22.75,22.69,22.31,22.31,22.53,23.84,24.0,23.66,24.47,24.09,24.31,23.75,22.91,21.38,19.44,18.19,18.47,18.47,18.25,19.0,19.28,18.56,18.25,18.06,17.38,17.31,16.94,17.19,16.66,16.56,15.81,15.91,14.62,14.69,14.56,14.34,15.75,16.31,17.94,19.53,19.69,19.75,19.47,18.62,17.34,16.53,15.25,14.31,13.97,13.28,13.94,13.47,14.19,13.97,14.44,13.88,14.12,13.94,13.88,13.19,13.47,14.22,14.62,15.78,18.47,19.78,22.06,22.41,22.38,21.84,21.22,19.5,17.78,16.41,13.59,10.62,7.69,4.91,1.5,-0.44,-1.5,-2.66,-1.91,-0.06,2.09,5.0,6.66,9.66,10.88,12.72,14.75,15.53,16.38,16.75,15.88,16.25,15.31,14.16,14.91,13.75,13.91,15.06,16.22,18.06,20.56,21.81,21.19,20.56,17.94,15.75,13.59,13.03,11.56,12.25,12.69,13.44,14.56,14.94,15.56,14.97,14.12,13.69,12.75,12.53,12.06,12.19,13.47,13.53,14.53,16.84,18.19,17.91,18.31,17.97,16.72,15.88,16.09,16.75,18.16,19.69,21.47,23.12,24.44,24.78,25.12,23.91,24.19,23.62,23.66,24.59,24.94,26.44,26.69,27.41,27.31,27.06,27.44,25.88,25.69,24.53,23.0,21.28,19.97,19.34,19.34,19.25,21.16,22.53,22.97,22.78,22.16,20.59,19.31,17.56,17.25,17.81,17.81,19.41,20.69,23.25,23.97,25.25,26.62,26.69,26.88,26.0,25.34,24.34,22.41,21.75,21.06,19.97,19.31,19.53,19.22,19.44,20.0,20.41,20.75,20.81,20.31,19.66,19.31,17.59,15.62,14.62,13.38,11.94,11.06,11.41,12.62,13.06,14.38,17.81,19.25,21.41,23.84,25.16,26.38,26.53,25.81,25.22,24.69,23.19,22.59,21.97,20.56,18.91,19.16,19.12,19.12,20.38,20.88,22.09,22.19,22.25,22.41,21.0,20.03,17.59,15.38,14.75,12.56,12.06,11.25,10.34,9.06,9.06,7.94,8.59,8.06,8.25,9.47,11.41,13.47,16.59,19.28,19.81,21.06,20.78,20.19,20.34,20.19,19.19,19.03,18.56,18.75,19.56,19.94,19.41,20.09,19.12,19.41,19.03,19.84,20.16,19.47,18.81,16.91,16.56,15.03,14.75,15.38,15.66,15.81,17.19,16.28,15.72,15.06,14.06,13.94,13.56,14.31,14.56,14.44,14.56,14.38,14.0,14.22,13.75,14.28,14.59,15.09,15.31,15.56,14.44,14.0,14.38,15.19,16.38,18.09,19.06,19.97,20.19,19.59,19.31,18.94,18.69,17.91,18.16,18.31,19.25,18.78,20.34,22.06,23.38,24.12,25.66,25.91,24.06,23.53,21.53,20.44,21.0,21.28,22.78,23.34,23.56,23.12,21.47,20.81,20.44,19.56,19.19,19.31,19.66,19.69,19.59,20.47,20.53,19.72,19.19,17.69,14.94,12.44,10.62,8.88,8.59,8.34,8.75,9.69,11.81,13.78,15.12,17.16,18.81,20.19,22.0,23.81,26.12,27.16,26.62,26.69,26.62,26.28,26.72,26.75,27.34,28.06,28.5,30.34,31.94,34.34,35.81,36.66,37.34,37.09,36.03,34.41,32.91,32.25,31.62,31.56,32.75,33.22,32.69,32.41,31.16,29.53,27.38,25.91,23.59,21.75,19.88,19.06,17.78,17.12,17.06,16.94,17.19,17.62,18.62,20.5,21.78,23.19,23.75,23.31,21.88,20.38,18.34,16.69,15.62,14.06,13.44,11.84,10.44,10.62,10.09,10.09,10.66,10.34,9.56,9.41,8.72,9.66,10.66,12.47,12.75,14.59,15.78,15.81,17.75,18.69,19.38,20.62,20.16,19.06,17.28,15.75,13.62,11.44,10.41,8.81,7.81,6.94,6.88,6.31,6.16,6.47,7.31,7.41,9.41,9.75,10.44,10.5,10.12,9.84,9.41,8.84,8.56,8.91,8.94,9.56,9.31,8.94,8.44,7.12,6.12,5.12,5.31,4.72,4.59,4.31,3.59,3.09,3.22,3.75,4.19,4.88,5.78,6.78,7.16,7.56,7.78,7.25,6.84,5.97,5.69,6.0,6.12,6.84,8.0,9.62,9.97,11.62,13.16,14.03,14.81,16.44,16.94,16.97,16.09,14.34,12.59,10.66,9.16,7.78,8.12,7.19,7.12,7.16,6.66,5.03,4.09,3.41,2.59,2.91,3.03,4.62,5.16,6.44,7.16,8.0,9.12,8.81,8.97,8.06,7.12,5.91,4.41,4.56,4.19,4.03,4.31,5.34,5.19,6.44,7.41,9.56,9.72,9.0,8.06,5.91,3.03,1.91,0.78,-0.12,-0.56,-0.97,-1.66,-2.19,-3.12,-3.69,-3.72,-3.06,-2.44,-0.03,1.66,3.0,3.91,4.5,5.25,5.84,5.62,5.56,5.44,4.44,2.81,2.03,1.09,0.53,0.47,1.41,1.94,3.62,4.72,6.09,7.38,7.56,6.84,5.94,5.09,4.38,4.41,5.28,5.88,7.41,8.94,9.84,11.31,12.91,13.03,13.81,14.03,14.06,13.91,14.16,14.72,14.69,15.0,15.31,13.81,14.41,14.78,-7.06,-6.53,-6.31,-5.31,-4.81,-4.66,-5.22,-6.16,-6.69,-8.28,-9.0,-9.0,-8.62,-7.47,-5.06,-2.22,-0.28,1.28,2.06,2.12,1.25,0.47,-0.31,0.0,-0.03,-1.56,-1.78,-1.84,-2.72,-2.62:negativity
26.22,23.91,23.16,22.19,20.91,21.41,20.0,19.62,20.5,21.5,22.22,22.91,23.62,23.62,23.72,25.03,25.28,26.31,28.81,28.78,30.5,29.31,28.75,27.81,27.72,26.94,26.72,26.91,26.69,26.12,25.5,25.72,25.5,25.94,26.53,28.06,29.88,31.66,33.66,35.84,37.44,38.38,37.94,37.91,36.09,35.44,34.31,35.34,35.97,37.22,39.03,39.28,39.28,36.88,34.06,31.12,28.25,26.0,23.41,23.16,21.62,21.81,19.66,19.25,17.34,16.09,14.88,14.16,12.81,11.28,11.53,11.66,11.88,13.59,13.56,15.0,14.88,13.81,12.69,11.09,10.19,10.75,11.78,14.41,17.97,19.66,22.81,25.09,25.94,26.53,27.31,27.41,26.28,25.34,25.78,24.38,24.81,26.91,27.75,28.78,30.03,31.31,30.91,28.81,28.31,25.16,23.06,21.22,17.53,16.78,15.91,15.06,16.84,18.78,19.97,22.0,21.66,20.69,20.53,19.97,20.75,21.0,21.84,23.25,22.69,21.97,23.09,22.81,24.28,26.0,26.66,26.88,26.84,27.41,25.84,26.81,27.59,28.06,28.91,30.03,28.94,28.19,26.25,25.09,24.03,24.38,23.81,24.66,25.47,24.62,26.0,25.5,27.53,28.66,30.16,30.5,31.47,29.41,27.91,24.84,22.84,20.81,19.75,19.97,19.25,19.94,21.53,22.25,24.38,27.44,27.62,27.5,27.12,25.34,23.41,21.41,19.62,18.91,16.59,16.34,16.53,17.62,19.28,20.88,23.81,23.94,26.09,25.84,27.06,28.5,29.03,30.5,31.94,32.91,34.88,36.94,38.81,39.5,41.0,40.69,40.62,37.91,36.91,35.78,34.25,34.38,33.62,34.69,34.81,34.0,33.25,32.28,31.12,30.28,29.19,28.94,28.38,27.97,26.94,26.06,25.38,26.44,27.41,28.47,31.66,34.31,35.09,35.12,34.62,31.53,29.5,27.16,23.53,22.44,21.31,19.31,19.69,19.06,18.84,19.38,21.69,23.31,25.88,29.28,31.78,33.53,33.28,33.31,31.88,29.56,28.84,28.53,27.53,27.97,26.78,25.69,26.34,24.59,24.81,24.66,24.62,24.53,23.16,22.53,22.44,22.22,20.81,21.81,24.16,25.34,29.38,32.53,34.28,35.94,35.72,35.19,33.69,32.28,30.88,30.0,28.69,27.53,27.0,26.69,25.06,25.84,25.69,25.94,26.97,30.0,29.44,31.84,32.22,32.78,32.56,33.19,33.91,35.25,36.53,37.66,38.19,38.12,37.12,36.62,35.62,34.81,35.34,34.41,32.0,30.19,28.84,27.47,27.06,27.06,27.59,27.25,27.09,28.53,29.38,29.84,30.22,30.91,31.0,29.94,30.12,30.16,29.56,28.56,28.81,27.75,27.59,26.34,26.25,25.75,24.97,25.66,26.0,27.03,27.5,26.03,24.59,24.22,22.5,21.62,21.69,22.66,22.0,22.09,22.03,22.62,23.91,25.38,26.53,28.59,29.31,28.94,29.62,30.69,31.91,33.34,34.69,35.56,33.62,33.41,30.59,29.28,26.19,25.06,25.25,24.5,24.5,24.22,24.34,23.72,23.03,23.66,25.19,25.16,26.81,28.75,29.56,32.16,34.28,35.38,36.97,36.28,34.31,31.84,30.5,29.62,29.41,30.62,31.66,32.22,32.28,33.41,33.62,33.72,33.88,34.66,33.16,31.66,33.09,32.03,32.5,34.72,36.75,38.44,39.88,40.62,41.94,39.81,37.25,35.06,31.78,29.88,29.12,28.66,30.31,31.91,33.91,36.25,36.78,37.06,36.94,35.56,33.03,32.94,33.25,33.12,34.66,35.75,34.84,34.59,33.5,32.09,30.84,29.78,28.81,26.66,27.34,26.22,27.09,27.44,28.28,29.66,32.16,33.41,35.84,37.09,37.28,36.06,35.16,33.41,30.34,27.47,25.31,22.78,21.84,23.0,24.84,27.72,29.97,32.56,33.28,33.03,32.97,30.69,28.94,27.44,27.66,26.53,27.19,27.59,27.5,28.12,28.31,27.66,28.28,26.41,25.84,24.81,23.03,23.53,24.53,26.22,27.56,30.06,31.97,34.16,35.25,36.16,36.62,36.53,35.66,34.16,32.88,33.0,32.5,31.44,30.62,30.19,29.69,29.34,29.66,29.81,29.06,28.59,25.53,25.12,24.28,25.16,26.56,26.94,28.16,27.66,26.47,25.75,24.81,23.78,24.81,25.06,27.47,29.59,31.81,34.0,35.88,36.09,37.19,36.66,35.81,34.47,34.12,32.38,33.06,33.34,32.94,34.16,35.38,35.84,37.44,37.19,38.19,37.59,35.75,33.94,32.91,30.62,30.03,28.59,27.84,27.38,27.41,28.69,29.28,30.88,31.16,33.31,33.75,35.59,36.41,35.84,37.19,35.5,35.03,34.25,33.81,34.25,34.06,34.41,33.53,34.28,33.31,33.34,34.59,35.34,36.16,37.12,38.72,38.38,37.91,37.38,36.28,36.41,36.91,37.66,38.78,39.81,40.12,41.0,40.34,39.97,38.66,36.59,34.88,32.75,31.59,31.19,30.09,31.06,30.53,30.22,29.81,29.78,29.56,26.78,27.31,26.91,27.06,28.0,28.81,30.06,30.12,29.56,29.19,28.03,27.84,27.06,25.97,25.38,24.59,23.84,23.56,23.34,24.44,25.09,23.88,23.91,22.03,20.78,20.19,21.06,23.12,25.25,28.53,31.28,32.75,33.81,33.94,32.91,32.5,31.06,29.72,28.94,27.69,27.03,26.94,25.81,25.31,23.84,21.38,19.5,18.25,16.81,17.16,19.12,20.44,21.91,22.94,25.59,27.06,29.44,32.66,35.03,36.06,36.53,36.34,35.0,33.06,32.56,31.88,30.81,29.81,28.66,27.25,25.03,24.97,24.62,24.94,26.91,27.97,28.28,30.56,30.44,31.72,33.06,34.59,35.03,35.75,36.56,35.31,35.41,34.16,33.78,33.25,33.69,34.66,34.59,34.62,33.47,32.03,30.12,28.69,27.78,28.88,29.56,30.03,33.16,32.56,33.78,34.44,34.97,37.31,38.28,39.41,41.38,41.06,40.62,38.12,37.31,34.66,33.06,31.88,29.78,29.25,29.12,29.0,29.19,29.88,31.94,31.41,33.0,33.19,33.88,33.41,31.84,31.06,30.81,28.84,27.88,27.47,25.31,24.25,24.28,23.53,23.44,24.06,24.03,22.75,23.31,22.34,20.59,20.62,20.25,18.78,19.38,19.12,20.28,21.47,22.84,23.72,25.94,25.81,26.09,25.31,24.62,23.44,23.66,24.12,26.06,27.12,27.72,27.81,27.94,25.97,24.66,22.91,21.91,19.81,18.5,16.56,16.72,17.22,17.75,17.66,19.66,20.66,21.72,23.41,24.97,26.16,26.91,27.84,27.78,28.66,29.53,30.0,29.56,30.31,31.03,29.91,29.75,29.44,29.06,30.19,28.47,28.97,28.84,27.62,26.47,25.44,23.66,22.62,20.84,19.91,19.53,18.16,16.59,16.94,14.97,13.44,14.78,14.12,12.94,13.47,13.16,12.44,12.56,12.12,13.19,13.06,13.47,14.19,14.28,14.5,15.0,15.44,17.47,19.25,22.41,25.03,27.91,29.47,31.62,32.72,32.44,32.56,31.88,31.16,31.09,30.94,30.5,30.59,29.47,29.25,27.19,25.34,23.84,22.53,20.72,19.56,20.31,19.19,19.28,19.5,18.59,17.88,17.03,16.41,15.91,15.88,15.69,14.59,14.59,14.94,16.41,17.31,19.81,20.91,21.62,20.84,20.12,19.94,19.16,19.47,21.31,22.62,24.72,25.72,28.56,29.66,30.06,31.12,30.59,30.09,29.31:20.0,19.62,20.5,21.5,22.22,22.91,23.62,23.62,23.72,25.03,25.28,26.31,28.81,28.78,30.5,29.31,28.75,27.81,27.72,26.94,26.72,26.91,26.69,26.12,25.5,25.72,25.5,25.94,26.53,28.06,29.88,31.66,33.66,35.84,37.44,38.38,37.94,37.91,36.09,35.44,34.31,35.34,35.97,37.22,39.03,39.28,39.28,36.88,34.06,31.12,28.25,26.0,23.41,23.16,21.62,21.81,19.66,19.25,17.34,16.09,14.88,14.16,12.81,11.28,11.53,11.66,11.88,13.59,13.56,15.0,14.88,13.81,12.69,11.09,10.19,10.75,11.78,14.41,17.97,19.66,22.81,25.09,25.94,26.53,27.31,27.41,26.28,25.34,25.78,24.38,24.81,26.91,27.75,28.78,30.03,31.31,30.91,28.81,28.31,25.16,23.06,21.22,17.53,16.78,15.91,15.06,16.84,18.78,19.97,22.0,21.66,20.69,20.53,19.97,20.75,21.0,21.84,23.25,22.69,21.97,23.09,22.81,24.28,26.0,26.66,26.88,26.84,27.41,25.84,26.81,27.59,28.06,28.91,30.03,28.94,28.19,26.25,25.09,24.03,24.38,23.81,24.66,25.47,24.62,26.0,25.5,27.53,28.66,30.16,30.5,31.47,29.41,27.91,24.84,22.84,20.81,19.75,19.97,19.25,19.94,21.53,22.25,24.38,27.44,27.62,27.5,27.12,25.34,23.41,21.41,19.62,18.91,16.59,16.34,16.53,17.62,19.28,20.88,23.81,23.94,26.09,25.84,27.06,28.5,29.03,30.5,31.94,32.91,34.88,36.94,38.81,39.5,41.0,40.69,40.62,37.91,36.91,35.78,34.25,34.38,33.62,34.69,34.81,34.0,33.25,32.28,31.12,30.28,29.19,28.94,28.38,27.97,26.94,26.06,25.38,26.44,27.41,28.47,31.66,34.31,35.09,35.12,34.62,31.53,29.5,27.16,23.53,22.44,21.31,19.31,19.69,19.06,18.84,19.38,21.69,23.31,25.88,29.28,31.78,33.53,33.28,33.31,31.88,29.56,28.84,28.53,27.53,27.97,26.78,25.69,26.34,24.59,24.81,24.66,24.62,24.53,23.16,22.53,22.44,22.22,20.81,21.81,24.16,25.34,29.38,32.53,34.28,35.94,35.72,35.19,33.69,32.28,30.88,30.0,28.69,27.53,27.0,26.69,25.06,25.84,25.69,25.94,26.97,30.0,29.44,31.84,32.22,32.78,32.56,33.19,33.91,35.25,36.53,37.66,38.19,38.12,37.12,36.62,35.62,34.81,35.34,34.41,32.0,30.19,28.84,27.47,27.06,27.06,27.59,27.25,27.09,28.53,29.38,29.84,30.22,30.91,31.0,29.94,30.12,30.16,29.56,28.56,28.81,27.75,27.59,26.34,26.25,25.75,24.97,25.66,26.0,27.03,27.5,26.03,24.59,24.22,22.5,21.62,21.69,22.66,22.0,22.09,22.03,22.62,23.91,25.38,26.53,28.59,29.31,28.94,29.62,30.69,31.91,33.34,34.69,35.56,33.62,33.41,30.59,29.28,26.19,25.06,25.25,24.5,24.5,24.22,24.34,23.72,23.03,23.66,25.19,25.16,26.81,28.75,29.56,32.16,34.28,35.38,36.97,36.28,34.31,31.84,30.5,29.62,29.41,30.62,31.66,32.22,32.28,33.41,33.62,33.72,33.88,34.66,33.16,31.66,33.09,32.03,32.5,34.72,36.75,38.44,39.88,40.62,41.94,39.81,37.25,35.06,31.78,29.88,29.12,28.66,30.31,31.91,33.91,36.25,36.78,37.06,36.94,35.56,33.03,32.94,33.25,33.12,34.66,35.75,34.84,34.59,33.5,32.09,30.84,29.78,28.81,26.66,27.34,26.22,27.09,27.44,28.28,29.66,32.16,33.41,35.84,37.09,37.28,36.06,35.16,33.41,30.34,27.47,25.31,22.78,21.84,23.0,24.84,27.72,29.97,32.56,33.28,33.03,32.97,30.69,28.94,27.44,27.66,26.53,27.19,27.59,27.5,28.12,28.31,27.66,28.28,26.41,25.84,24.81,23.03,23.53,24.53,26.22,27.56,30.06,31.97,34.16,35.25,36.16,36.62,36.53,35.66,34.16,32.88,33.0,32.5,31.44,30.62,30.19,29.69,29.34,29.66,29.81,29.06,28.59,25.53,25.12,24.28,25.16,26.56,26.94,28.16,27.66,26.47,25.75,24.81,23.78,24.81,25.06,27.47,29.59,31.81,34.0,35.88,36.09,37.19,36.66,35.81,34.47,34.12,32.38,33.06,33.34,32.94,34.16,35.38,35.84,37.44,37.19,38.19,37.59,35.75,33.94,32.91,30.62,30.03,28.59,27.84,27.38,27.41,28.69,29.28,30.88,31.16,33.31,33.75,35.59,36.41,35.84,37.19,35.5,35.03,34.25,33.81,34.25,34.06,34.41,33.53,34.28,33.31,33.34,34.59,35.34,36.16,37.12,38.72,38.38,37.91,37.38,36.28,36.41,36.91,37.66,38.78,39.81,40.12,41.0,40.34,39.97,38.66,36.59,34.88,32.75,31.59,31.19,30.09,31.06,30.53,30.22,29.81,29.78,29.56,26.78,27.31,26.91,27.06,28.0,28.81,30.06,30.12,29.56,29.19,28.03,27.84,27.06,25.97,25.38,24.59,23.84,23.56,23.34,24.44,25.09,23.88,23.91,22.03,20.78,20.19,21.06,23.12,25.25,28.53,31.28,32.75,33.81,33.94,32.91,32.5,31.06,29.72,28.94,27.69,27.03,26.94,25.81,25.31,23.84,21.38,19.5,18.25,16.81,17.16,19.12,20.44,21.91,22.94,25.59,27.06,29.44,32.66,35.03,36.06,36.53,36.34,35.0,33.06,32.56,31.88,30.81,29.81,28.66,27.25,25.03,24.97,24.62,24.94,26.91,27.97,28.28,30.56,30.44,31.72,33.06,34.59,35.03,35.75,36.56,35.31,35.41,34.16,33.78,33.25,33.69,34.66,34.59,34.62,33.47,32.03,30.12,28.69,27.78,28.88,29.56,30.03,33.16,32.56,33.78,34.44,34.97,37.31,38.28,39.41,41.38,41.06,40.62,38.12,37.31,34.66,33.06,31.88,29.78,29.25,29.12,29.0,29.19,29.88,31.94,31.41,33.0,33.19,33.88,33.41,31.84,31.06,30.81,28.84,27.88,27.47,25.31,24.25,24.28,23.53,23.44,24.06,24.03,22.75,23.31,22.34,20.59,20.62,20.25,18.78,19.38,19.12,20.28,21.47,22.84,23.72,25.94,25.81,26.09,25.31,24.62,23.44,23.66,24.12,26.06,27.12,27.72,27.81,27.94,25.97,24.66,22.91,21.91,19.81,18.5,16.56,16.72,17.22,17.75,17.66,19.66,20.66,21.72,23.41,24.97,26.16,26.91,27.84,27.78,28.66,29.53,30.0,29.56,30.31,31.03,29.91,29.75,29.44,29.06,30.19,28.47,28.97,28.84,27.62,26.47,25.44,23.66,22.62,20.84,19.91,19.53,18.16,16.59,16.94,14.97,13.44,14.78,14.12,12.94,13.47,13.16,12.44,12.56,12.12,13.19,13.06,13.47,14.19,14.28,14.5,15.0,15.44,17.47,19.25,22.41,25.03,27.91,29.47,31.62,32.72,32.44,32.56,31.88,31.16,31.09,30.94,30.5,30.59,29.47,29.25,27.19,25.34,23.84,22.53,20.72,19.56,20.31,19.19,19.28,19.5,18.59,17.88,17.03,16.41,15.91,15.88,15.69,14.59,14.59,14.94,16.41,17.31,19.81,20.91,21.62,20.84,20.12,19.94,19.16,19.47,21.31,22.62,24.72,25.72,28.56,29.66,30.06,31.12,30.59,30.09,29.31,-2.62,-4.97,-7.0,-9.53,-11.91,-12.84:23.62,23.62,23.72,25.03,25.28,26.31,28.81,28.78,30.5,29.3