#SelfRegulationSCP2.
#
#from 
#http://bbci.de/competition/ii/tuebingen_desc_i.html
#
#Data set 1b: Self-regulation of Slow Cortical Potentials
#
#Datasets provided by University of Tuebingen. 
#Correspondence to Thilo Hinterberger <thilo.Hinterberger@uni-tuebingen.de> 
# 
#Description of Experiments:
#The datasets were taken from an artificially respirated ALS patient. The subject was asked to move a cursor up and down on a computer screen, while his cortical potentials were taken. During the recording, the subject received auditory and visual feedback of his slow cortical potentials (Cz-Mastoids).  Cortical positivity lead to a downward movement of the cursor on the screen.  Cortical negativity lead to an upward movement of the cursor.  Each trial lasted 8s. 
#During every trial, the task was visually and auditorily presented by a highlighed goal at the top (for negativity) or bottom (for positivity) of the screen from second 0.5 until second 7.5 of every trial.  In addition, the task ("up" or "down") was vocalised at second 0.5. 
#The visual feedback was presented from second 2 to second 6.5. Only this 4.5 second interval of every trial is provided for training and testing. The sampling rate of 256 Hz and the recording length of 4.5s results in 1152 samples per channel for every trial.
#Trial structure overview: 
#Duration: 8 s, no inter trial intervals 
#task presentation: from 0.5 s to 7.5 s 
#feedback period: from 2.0 s to 6.5 s 
#  
# 
#
#Data:
#Amplifier: PsyLab EEG8 
#A/D-converter: Computer Boards PCIM-DAS1602/16 bit 
#Amplitude range: +/-1000 �V 
#Sampling rate: 256 S/s 
#EEG data was taken from the following positions: 
#Channel 1: A1-Cz (10/20 system) (A1 = left mastoid) 
#Channel 2: A2-Cz 
#Channel 3: 2 cm frontal of C3 
#Channel 4: 2 cm parietal of C3 
#Channel 5: vEOG artifact channel to detect vertical eye movements 
#Channel 6: 2 cm frontal of C4 
#Channel 7: 2 cm parietal of C4 
#All values are in �Volt. 
#The EEG-values are not EOG-corrected.
#Traindata_0.txt and Traindata_1.txt:
#
#The train data contains  200 trials, 100 of each class which were recorded on the same day and permuted randomly.
#There are 7 dimensions and the series are length 1152. 
#
#Test data contains 180 trials of test data.  This test data was recorded after the train data (during the same day) day.  The 180 trials belong to either class 0 or class 1.  
#
#Note that it is not clear if there is any information contained in this data set that is useful for the classification task. A view on the result suggests that it is not. 
#
#http://bbci.de/competition/ii/results/index.html
#The best has error 45.5%.  
#
#Reference:
#Birbaumer, N., Flor, H., Ghanayim, N., Hinterberger, T., Iverson, I., Taub, E., Kotchoubey, B., K�bler, A., & Perelmouter, J, A Brain-Controlled Spelling Device for the Completely Paralyzed, Nature, 398, 297-298.
@problemName SelfRegulationSCP2
@timeStamps false
@missing false
@univariate false
@dimensions 7
@equalLength true
@seriesLength 1152
@classLabel true negativity positivity
@data
-1.75,-1.44,-1.53,-1.09,-1.28,-1.75,-2.62,-3.06,-3.19,-3.75,-5.41,-7.03,-8.19,-9.09,-10.56,-10.97,-10.47,-9.69,-9.66,-10.03,-10.09,-9.38,-8.84,-8.34,-6.91,-4.94,-2.94,-1.78,-1.09,-0.38,-0.03,-0.72,-1.91,-2.44,-2.72,-3.59,-5.03,-5.97,-7.19,-8.81,-11.38,-13.75,-15.12,-16.22,-16.94,-16.84,-15.34,-12.91,-10.69,-8.66,-6.28,-3.5,-1.69,-0.59,0.69,2.25,3.56,3.88,3.97,4.59,5.31,4.97,4.22,4.16,3.97,2.75,1.25,0.19,-0.5,-1.62,-3.31,-4.78,-5.5,-5.66,-6.34,-6.62,-6.19,-5.38,-5.53,-5.88,-5.53,-5.12,-5.19,-6.12,-6.5,-6.78,-6.94,-7.88,-8.25,-8.03,-8.06,-9.41,-10.38,-10.78,-10.34,-9.81,-9.19,-7.44,-5.16,-3.25,-2.31,-1.12,0.16,0.47,-0.88,-2.66,-4.53,-6.28,-8.75,-10.84,-11.66,-11.69,-11.97,-12.97,-13.56,-13.34,-13.78,-14.66,-15.19,-15.06,-15.22,-16.44,-17.38,-17.47,-17.53,-18.09,-18.38,-18.53,-17.91,-17.94,-18.78,-19.25,-19.38,-19.94,-21.16,-21.47,-20.28,-18.62,-17.22,-15.81,-13.81,-11.81,-10.72,-10.0,-9.28,-7.59,-6.53,-6.16,-5.62,-4.31,-3.28,-4.03,-5.25,-6.12,-7.38,-9.28,-10.72,-11.59,-11.53,-11.81,-12.44,-12.97,-12.31,-11.91,-12.09,-11.69,-10.53,-9.84,-10.19,-10.97,-11.09,-11.16,-12.25,-13.31,-13.94,-13.44,-13.25,-13.16,-12.72,-11.62,-11.03,-12.0,-13.31,-13.72,-13.84,-15.16,-15.88,-15.53,-14.91,-15.22,-15.69,-16.12,-16.09,-16.59,-17.16,-17.5,-16.66,-16.34,-17.0,-18.22,-19.38,-20.47,-22.59,-24.22,-24.72,-24.06,-23.31,-21.84,-19.56,-16.0,-12.28,-9.78,-7.53,-5.47,-4.06,-3.88,-4.31,-4.41,-4.75,-6.88,-9.56,-12.22,-14.06,-16.28,-18.72,-20.41,-20.69,-20.91,-21.12,-21.25,-19.88,-18.31,-16.81,-15.72,-13.41,-10.69,-9.47,-9.06,-8.81,-9.03,-9.91,-12.06,-14.22,-14.97,-15.47,-16.22,-16.56,-15.78,-15.03,-15.53,-16.56,-17.22,-17.34,-17.94,-19.25,-20.59,-21.0,-22.06,-24.22,-25.66,-25.78,-26.16,-27.06,-28.56,-28.56,-28.66,-28.88,-28.78,-27.88,-26.25,-25.31,-25.06,-24.31,-22.62,-20.59,-18.72,-16.0,-11.62,-7.28,-3.59,-1.22,1.41,2.91,2.34,0.09,-2.88,-5.31,-8.91,-12.53,-15.09,-16.03,-16.34,-17.19,-18.25,-17.88,-17.75,-18.66,-19.78,-20.59,-20.78,-21.19,-21.75,-21.09,-18.69,-16.53,-14.56,-13.19,-11.56,-10.78,-11.72,-13.62,-14.53,-15.09,-16.97,-19.59,-21.38,-22.94,-24.66,-26.44,-27.19,-27.06,-27.75,-29.19,-31.03,-31.72,-32.31,-33.25,-34.56,-35.09,-34.91,-35.0,-35.41,-34.69,-33.41,-32.19,-31.34,-30.06,-27.66,-25.31,-23.62,-22.5,-20.72,-18.88,-17.59,-16.78,-15.88,-14.88,-14.81,-15.97,-17.28,-18.12,-19.09,-21.56,-23.47,-23.84,-23.88,-24.38,-24.56,-23.62,-22.59,-22.31,-22.47,-22.75,-23.03,-23.88,-26.0,-27.56,-28.22,-28.25,-28.59,-28.53,-26.56,-24.31,-23.19,-22.44,-21.16,-20.25,-19.88,-20.06,-20.09,-19.5,-19.12,-20.12,-21.0,-21.59,-22.28,-24.22,-26.06,-27.44,-28.59,-29.44,-30.03,-29.12,-27.47,-25.31,-23.44,-21.59,-18.72,-16.0,-14.47,-12.56,-10.28,-7.81,-6.69,-6.28,-6.41,-7.03,-8.84,-11.78,-13.97,-15.25,-15.94,-17.06,-17.5,-16.62,-16.03,-16.53,-16.88,-16.5,-15.97,-16.34,-16.88,-16.66,-16.12,-16.25,-17.19,-18.09,-18.56,-19.56,-21.31,-22.62,-22.94,-22.75,-23.12,-23.25,-22.66,-21.44,-20.78,-20.53,-19.56,-17.19,-15.28,-14.09,-12.84,-11.28,-10.53,-11.0,-11.59,-12.22,-12.38,-13.31,-14.34,-14.09,-12.84,-12.06,-11.12,-9.72,-8.0,-6.81,-7.19,-8.03,-9.12,-10.5,-12.53,-14.09,-14.59,-14.09,-14.59,-15.19,-15.28,-14.53,-14.31,-13.38,-12.25,-10.25,-8.25,-8.0,-7.88,-7.62,-7.94,-9.19,-10.53,-11.81,-13.22,-15.78,-18.97,-22.0,-24.03,-25.44,-26.75,-27.31,-26.69,-26.44,-26.84,-27.22,-26.31,-24.69,-23.28,-21.69,-19.81,-17.97,-17.53,-17.78,-18.69,-18.56,-19.0,-19.78,-20.25,-19.44,-18.47,-18.41,-18.25,-17.38,-16.56,-16.41,-17.06,-17.19,-17.06,-17.19,-17.22,-16.56,-14.69,-13.09,-12.78,-12.41,-12.0,-11.31,-10.91,-10.41,-9.97,-9.22,-10.38,-12.69,-15.44,-18.25,-21.56,-24.94,-27.81,-28.97,-29.16,-28.97,-28.03,-25.97,-23.19,-20.75,-18.75,-16.84,-14.69,-13.81,-14.12,-14.19,-13.19,-12.03,-10.59,-8.94,-6.22,-3.62,-1.88,-0.94,0.22,1.06,0.75,-0.28,-1.66,-2.66,-3.94,-6.09,-8.44,-9.97,-11.91,-14.38,-16.41,-17.06,-16.81,-16.22,-15.0,-12.97,-10.75,-9.03,-8.69,-9.12,-9.0,-9.12,-9.84,-10.06,-9.25,-8.31,-8.41,-9.06,-9.34,-10.28,-12.25,-16.0,-19.47,-22.62,-25.66,-28.47,-30.0,-30.12,-29.94,-30.16,-29.97,-28.28,-25.84,-23.28,-20.75,-17.5,-14.53,-12.62,-11.59,-10.62,-9.31,-8.31,-8.03,-8.41,-8.62,-9.22,-10.53,-12.75,-13.47,-14.0,-15.06,-15.97,-16.47,-16.88,-17.34,-18.22,-18.53,-17.94,-16.53,-15.81,-14.84,-13.06,-11.34,-10.62,-10.28,-9.34,-8.0,-7.56,-7.41,-7.72,-7.56,-8.06,-9.78,-11.91,-13.5,-15.56,-18.47,-21.53,-23.72,-24.88,-25.94,-26.78,-26.34,-25.34,-24.41,-24.56,-24.62,-24.5,-24.53,-25.06,-24.97,-24.03,-22.59,-21.5,-21.47,-20.94,-20.56,-20.78,-22.12,-22.81,-23.59,-24.0,-24.41,-24.38,-23.06,-21.34,-19.97,-19.06,-17.12,-15.06,-13.69,-12.53,-10.94,-9.72,-9.34,-10.59,-11.62,-11.94,-12.28,-12.97,-12.66,-12.06,-11.38,-12.0,-12.97,-13.62,-14.0,-14.84,-16.47,-17.56,-18.84,-20.66,-23.12,-24.91,-25.25,-24.72,-23.94,-22.47,-19.44,-16.25,-13.88,-11.97,-10.09,-8.56,-7.66,-7.34,-6.81,-6.25,-6.09,-7.5,-9.53,-11.47,-13.62,-16.59,-19.44,-21.12,-22.16,-23.44,-24.38,-24.78,-24.59,-24.16,-24.44,-24.56,-24.09,-23.72,-24.47,-25.34,-26.06,-26.0,-27.19,-28.16,-27.91,-27.16,-26.09,-25.09,-23.66,-21.34,-18.97,-17.72,-16.56,-15.38,-14.78,-15.69,-16.94,-17.28,-16.81,-17.16,-17.38,-17.31,-17.41,-17.91,-19.0,-19.75,-19.72,-20.0,-21.16,-22.22,-22.66,-22.62,-22.78,-22.41,-21.0,-18.97,-17.69,-17.5,-17.38,-17.31,-17.94,-19.16,-19.97,-19.88,-19.88,-21.06,-22.53,-22.94,-23.31,-24.16,-24.34,-23.28,-21.06,-19.31,-18.12,-17.38,-16.78,-17.16,-18.66,-20.09,-20.16,-19.72,-20.31,-20.78,-20.56,-20.38,-21.03,-21.66,-21.19,-19.66,-18.44,-17.31,-16.62,-15.88,-16.22,-18.12,-20.44,-21.19,-21.34,-21.25,-20.97,-19.5,-17.69,-16.59,-16.22,-15.53,-14.5,-14.69,-15.88,-17.0,-17.66,-18.53,-19.78,-21.25,-22.03,-22.47,-23.44,-24.56,-24.47,-23.31,-22.62,-22.5,-22.66,-22.59,-23.06,-24.19,-25.19,-25.06,-24.84,-25.53,-26.66,-26.66,-26.25,-26.59,-26.94,-26.44,-24.88,-23.88,-23.69,-23.12,-22.25,-22.56,-23.94,-25.78,-26.53,-27.25,-28.31,-28.94,-28.09,-26.66,-25.88,-25.62,-25.22,-24.31,-24.12,-24.59,-25.0,-24.5,-24.44,-25.31,-26.09,-26.19,-25.62,-25.38,-25.19,-24.22,-22.84,-22.22,-22.53,-23.12,-23.0,-23.25,-24.66,-25.56,-25.81,-26.19,-27.31,-29.03,-29.75,-30.16,-31.19,-32.0,-32.34,-31.5,-30.75,-30.94,-30.53,-28.97,-28.38,-28.84,-29.84,-30.38,-30.97,-32.59,-34.5,-34.88,-34.22,-33.88,-33.88,-32.97,-31.59,-30.59,-30.12,-29.56,-28.16,-26.59,-26.31,-27.12,-27.06,-27.5,-28.41,-29.53,-29.34,-27.59,-26.09,-25.31,-24.44,-23.75,-24.16,-26.25,-28.41,-29.88,-30.81,-32.22,-33.0,-32.56,-31.59,-31.12,-31.25,-30.75,-30.06,-30.06,-31.19,-32.19,-32.34,-32.75,-33.91,-34.59,-34.22,-33.28,-32.69,-32.69,-31.94,-31.09,-30.81,-31.38,-31.25,-30.75,-30.62,-31.41,-32.22,-32.03,-31.81,-32.19,-32.47,-31.66,-30.72,-30.25,-30.5,-30.34,-30.09,-30.97,-32.41,-33.41,-32.88,-31.69,-30.41,-28.59,-25.94,-23.62,-23.75,-25.03,-26.66,-28.81,-31.44,-33.84,-34.34,-33.94,-32.88,-32.31,-31.88,-31.0,-30.25,-30.66,-30.97,-30.44,-29.44,-29.66,-30.0,-29.5,-29.19,-28.97,-29.25,-28.97,-28.16,-27.62,-28.44,-29.06,-28.97,-28.81,-29.38,-30.19,-30.5,-30.84,-32.47,-34.19,-35.34,-35.72,-36.16,-37.25,-37.53,-37.22,-36.72,-36.97,-37.03,-36.56,-35.78,-35.88,-36.0,-35.38,-34.31,-34.06,-34.16,-33.94,-32.5,-31.31,-30.78,-29.88,-28.5,-27.34,-27.66,-28.41,-28.72,-29.03,-30.38,-32.38,-33.72,-34.56,-35.62,-37.06,-38.03,-37.88,-37.59,-38.12,-37.62,-35.66,-33.12,-31.19,-29.12,-26.75,-25.16,-25.31,-27.16,-29.59,-32.19,-35.0,-37.84,-39.38,-39.25,-38.66,-38.62,-37.97,-36.72,-34.84,-34.0,-33.06,-32.0,-30.84,-30.88,-31.56,-32.38,-32.62,-32.84,-33.72,-34.0,-32.91,-31.62,-31.41,-30.88,-30.0,-29.28,-29.44,-30.44,-31.25,-31.97,-33.47,-35.84,-37.91,-39.31,-41.09,-43.25,-44.81,-44.94,-44.59,-44.62,-44.19,-42.78,-40.81,-39.75,-38.41,-37.25,-35.12,-34.0,-33.5,-32.81,-32.03,-32.16,-33.62,-35.09,-36.38,-37.78,-39.97,-42.28,-43.78,-44.5,-45.38,-45.72,-45.56,-44.47,-43.62,-44.0,-44.53,-44.59,-44.56,-44.97,-44.53,-42.75,-40.41,-38.19,-36.41,-34.94,-33.28,-33.0:-3.06,-3.19,-3.75,-5.41,-7.03,-8.19,-9.09,-10.56,-10.97,-10.47,-9.69,-9.66,-10.03,-10.09,-9.38,-8.84,-8.34,-6.91,-4.94,-2.94,-1.78,-1.09,-0.38,-0.03,-0.72,-1.91,-2.44,-2.72,-3.59,-5.03,-5.97,-7.19,-8.81,-11.38,-13.75,-15.12,-16.22,-16.94,-16.84,-15.34,-12.91,-10.69,-8.66,-6.28,-3.5,-1.69,-0.59,0.69,2.25,3.56,3.88,3.97,4.59,5.31,4.97,4.22,4.16,3.97,2.75,1.25,0.19,-0.5,-1.62,-3.31,-4.78,-5.5,-5.66,-6.34,-6.62,-6.19,-5.38,-5.53,-5.88,-5.53,-5.12,-5.19,-6.12,-6.5,-6.78,-6.94,-7.88,-8.25,-8.03,-8.06,-9.41,-10.38,-10.78,-10.34,-9.81,-9.19,-7.44,-5.16,-3.25,-2.31,-1.12,0.16,0.47,-0.88,-2.66,-4.53,-6.28,-8.75,-10.84,-11.66,-11.69,-11.97,-12.97,-13.56,-13.34,-13.78,-14.66,-15.19,-15.06,-15.22,-16.44,-17.38,-17.47,-17.53,-18.09,-18.38,-18.53,-17.91,-17.94,-18.78,-19.25,-19.38,-19.94,-21.16,-21.47,-20.28,-18.62,-17.22,-15.81,-13.81,-11.81,-10.72,-10.0,-9.28,-7.59,-6.53,-6.16,-5.62,-4.31,-3.28,-4.03,-5.25,-6.12,-7.38,-9.28,-10.72,-11.59,-11.53,-11.81,-12.44,-12.97,-12.31,-11.91,-12.09,-11.69,-10.53,-9.84,-10.19,-10.97,-11.09,-11.16,-12.25,-13.31,-13.94,-13.44,-13.25,-13.16,-12.72,-11.62,-11.03,-12.0,-13.31,-13.72,-13.84,-15.16,-15.88,-15.53,-14.91,-15.22,-15.69,-16.12,-16.09,-16.59,-17.16,-17.5,-16.66,-16.34,-17.0,-18.22,-19.38,-20.47,-22.59,-24.22,-24.72,-24.06,-23.31,-21.84,-19.56,-16.0,-12.28,-9.78,-7.53,-5.47,-4.06,-3.88,-4.31,-4.41,-4.75,-6.88,-9.56,-12.22,-14.06,-16.28,-18.72,-20.41,-20.69,-20.91,-21.12,-21.25,-19.88,-18.31,-16.81,-15.72,-13.41,-10.69,-9.47,-9.06,-8.81,-9.03,-9.91,-12.06,-14.22,-14.97,-15.47,-16.22,-16.56,-15.78,-15.03,-15.53,-16.56,-17.22,-17.34,-17.94,-19.25,-20.59,-21.0,-22.06,-24.22,-25.66,-25.78,-26.16,-27.06,-28.56,-28.56,-28.66,-28.88,-28.78,-27.88,-26.25,-25.31,-25.06,-24.31,-22.62,-20.59,-18.72,-16.0,-11.62,-7.28,-3.59,-1.22,1.41,2.91,2.34,0.09,-2.88,-5.31,-8.91,-12.53,-15.09,-16.03,-16.34,-17.19,-18.25,-17.88,-17.75,-18.66,-19.78,-20.59,-20.78,-21.19,-21.75,-21.09,-18.69,-16.53,-14.56,-13.19,-11.56,-10.78,-11.72,-13.62,-14.53,-15.09,-16.97,-19.59,-21.38,-22.94,-24.66,-26.44,-27.19,-27.06,-27.75,-29.19,-31.03,-31.72,-32.31,-33.25,-34.56,-35.09,-34.91,-35.0,-35.41,-34.69,-33.41,-32.19,-31.34,-30.06,-27.66,-25.31,-23.62,-22.5,-20.72,-18.88,-17.59,-16.78,-15.88,-14.88,-14.81,-15.97,-17.28,-18.12,-19.09,-21.56,-23.47,-23.84,-23.88,-24.38,-24.56,-23.62,-22.59,-22.31,-22.47,-22.75,-23.03,-23.88,-26.0,-27.56,-28.22,-28.25,-28.59,-28.53,-26.56,-24.31,-23.19,-22.44,-21.16,-20.25,-19.88,-20.06,-20.09,-19.5,-19.12,-20.12,-21.0,-21.59,-22.28,-24.22,-26.06,-27.44,-28.59,-29.44,-30.03,-29.12,-27.47,-25.31,-23.44,-21.59,-18.72,-16.0,-14.47,-12.56,-10.28,-7.81,-6.69,-6.28,-6.41,-7.03,-8.84,-11.78,-13.97,-15.25,-15.94,-17.06,-17.5,-16.62,-16.03,-16.53,-16.88,-16.5,-15.97,-16.34,-16.88,-16.66,-16.12,-16.25,-17.19,-18.09,-18.56,-19.56,-21.31,-22.62,-22.94,-22.75,-23.12,-23.25,-22.66,-21.44,-20.78,-20.53,-19.56,-17.19,-15.28,-14.09,-12.84,-11.28,-10.53,-11.0,-11.59,-12.22,-12.38,-13.31,-14.34,-14.09,-12.84,-12.06,-11.12,-9.72,-8.0,-6.81,-7.19,-8.03,-9.12,-10.5,-12.53,-14.09,-14.59,-14.09,-14.59,-15.19,-15.28,-14.53,-14.31,-13.38,-12.25,-10.25,-8.25,-8.0,-7.88,-7.62,-7.94,-9.19,-10.53,-11.81,-13.22,-15.78,-18.97,-22.0,-24.03,-25.44,-26.75,-27.31,-26.69,-26.44,-26.84,-27.22,-26.31,-24.69,-23.28,-21.69,-19.81,-17.97,-17.53,-17.78,-18.69,-18.56,-19.0,-19.78,-20.25,-19.44,-18.47,-18.41,-18.25,-17.38,-16.56,-16.41,-17.06,-17.19,-17.06,-17.19,-17.22,-16.56,-14.69,-13.09,-12.78,-12.41,-12.0,-11.31,-10.91,-10.41,-9.97,-9.22,-10.38,-12.69,-15.44,-18.25,-21.56,-24.94,-27.81,-28.97,-29.16,-28.97,-28.03,-25.97,-23.19,-20.75,-18.75,-16.84,-14.69,-13.81,-14.12,-14.19,-13.19,-12.03,-10.59,-8.94,-6.22,-3.62,-1.88,-0.94,0.22,1.06,0.75,-0.28,-1.66,-2.66,-3.94,-6.09,-8.44,-9.97,-11.91,-14.38,-16.41,-17.06,-16.81,-16.22,-15.0,-12.97,-10.75,-9.03,-8.69,-9.12,-9.0,-9.12,-9.84,-10.06,-9.25,-8.31,-8.41,-9.06,-9.34,-10.28,-12.25,-16.0,-19.47,-22.62,-25.66,-28.47,-30.0,-30.12,-29.94,-30.16,-29.97,-28.28,-25.84,-23.28,-20.75,-17.5,-14.53,-12.62,-11.59,-10.62,-9.31,-8.31,-8.03,-8.41,-8.62,-9.22,-10.53,-12.75,-13.47,-14.0,-15.06,-15.97,-16.47,-16.88,-17.34,-18.22,-18.53,-17.94,-16.53,-15.81,-14.84,-13.06,-11.34,-10.62,-10.28,-9.34,-8.0,-7.56,-7.41,-7.72,-7.56,-8.06,-9.78,-11.91,-13.5,-15.56,-18.47,-21.53,-23.72,-24.88,-25.94,-26.78,-26.34,-25.34,-24.41,-24.56,-24.62,-24.5,-24.53,-25.06,-24.97,-24.03,-22.59,-21.5,-21.47,-20.94,-20.56,-20.78,-22.12,-22.81,-23.59,-24.0,-24.41,-24.38,-23.06,-21.34,-19.97,-19.06,-17.12,-15.06,-13.69,-12.53,-10.94,-9.72,-9.34,-10.59,-11.62,-11.94,-12.28,-12.97,-12.66,-12.06,-11.38,-12.0,-12.97,-13.62,-14.0,-14.84,-16.47,-17.56,-18.84,-20.66,-23.12,-24.91,-25.25,-24.72,-23.94,-22.47,-19.44,-16.25,-13.88,-11.97,-10.09,-8.56,-7.66,-7.34,-6.81,-6.25,-6.09,-7.5,-9.53,-11.47,-13.62,-16.59,-19.44,-21.12,-22.16,-23.44,-24.38,-24.78,-24.59,-24.16,-24.44,-24.56,-24.09,-23.72,-24.47,-25.34,-26.06,-26.0,-27.19,-28.16,-27.91,-27.16,-26.09,-25.09,-23.66,-21.34,-18.97,-17.72,-16.56,-15.38,-14.78,-15.69,-16.94,-17.28,-16.81,-17.16,-17.38,-17.31,-17.41,-17.91,-19.0,-19.75,-19.72,-20.0,-21.16,-22.22,-22.66,-22.62,-22.78,-22.41,-21.0,-18.97,-17.69,-17.5,-17.38,-17.31,-17.94,-19.16,-19.97,-19.88,-19.88,-21.06,-22.53,-22.94,-23.31,-24.16,-24.34,-23.28,-21.06,-19.31,-18.12,-17.38,-16.78,-17.16,-18.66,-20.09,-20.16,-19.72,-20.31,-20.78,-20.56,-20.38,-21.03,-21.66,-21.19,-19.66,-18.44,-17.31,-16.62,-15.88,-16.22,-18.12,-20.44,-21.19,-21.34,-21.25,-20.97,-19.5,-17.69,-16.59,-16.22,-15.53,-14.5,-14.69,-15.88,-17.0,-17.66,-18.53,-19.78,-21.25,-22.03,-22.47,-23.44,-24.56,-24.47,-23.31,-22.62,-22.5,-22.66,-22.59,-23.06,-24.19,-25.19,-25.06,-24.84,-25.53,-26.66,-26.66,-26.25,-26.59,-26.94,-26.44,-24.88,-23.88,-23.69,-23.12,-22.25,-22.56,-23.94,-25.78,-26.53,-27.25,-28.31,-28.94,-28.09,-26.66,-25.88,-25.62,-25.22,-24.31,-24.12,-24.59,-25.0,-24.5,-24.44,-25.31,-26.09,-26.19,-25.62,-25.38,-25.19,-24.22,-22.84,-22.22,-22.53,-23.12,-23.0,-23.25,-24.66,-25.56,-25.81,-26.19,-27.31,-29.03,-29.75,-30.16,-31.19,-32.0,-32.34,-31.5,-30.75,-30.94,-30.53,-28.97,-28.38,-28.84,-29.84,-30.38,-30.97,-32.59,-34.5,-34.88,-34.22,-33.88,-33.88,-32.97,-31.59,-30.59,-30.12,-29.56,-28.16,-26.59,-26.31,-27.12,-27.06,-27.5,-28.41,-29.53,-29.34,-27.59,-26.09,-25.31,-24.44,-23.75,-24.16,-26.25,-28.41,-29.88,-30.81,-32.22,-33.0,-32.56,-31.59,-31.12,-31.25,-30.75,-30.06,-30.06,-31.19,-32.19,-32.34,-32.75,-33.91,-34.59,-34.22,-33.28,-32.69,-32.69,-31.94,-31.09,-30.81,-31.38,-31.25,-30.75,-30.62,-31.41,-32.22,-32.03,-31.81,-32.19,-32.47,-31.66,-30.72,-30.25,-30.5,-30.34,-30.09,-30.97,-32.41,-33.41,-32.88,-31.69,-30.41,-28.59,-25.94,-23.62,-23.75,-25.03,-26.66,-28.81,-31.44,-33.84,-34.34,-33.94,-32.88,-32.31,-31.88,-31.0,-30.25,-30.66,-30.97,-30.44,-29.44,-29.66,-30.0,-29.5,-29.19,-28.97,-29.25,-28.97,-28.16,-27.62,-28.44,-29.06,-28.97,-28.81,-29.38,-30.19,-30.5,-30.84,-32.47,-34.19,-35.34,-35.72,-36.16,-37.25,-37.53,-37.22,-36.72,-36.97,-37.03,-36.56,-35.78,-35.88,-36.0,-35.38,-34.31,-34.06,-34.16,-33.94,-32.5,-31.31,-30.78,-29.88,-28.5,-27.34,-27.66,-28.41,-28.72,-29.03,-30.38,-32.38,-33.72,-34.56,-35.62,-37.06,-38.03,-37.88,-37.59,-38.12,-37.62,-35.66,-33.12,-31.19,-29.12,-26.75,-25.16,-25.31,-27.16,-29.59,-32.19,-35.0,-37.84,-39.38,-39.25,-38.66,-38.62,-37.97,-36.72,-34.84,-34.0,-33.06,-32.0,-30.84,-30.88,-31.56,-32.38,-32.62,-32.84,-33.72,-34.0,-32.91,-31.62,-31.41,-30.88,-30.0,-29.28,-29.44,-30.44,-31.25,-31.97,-33.47,-35.84,-37.91,-39.31,-41.09,-43.25,-44.81,-44.94,-44.59,-44.62,-44.19,-42.78,-40.81,-39.75,-38.41,-37.25,-35.12,-34.0,-33.5,-32.81,-32.03,-32.16,-33.62,-35.09,-36.38,-37.78,-39.97,-42.28,-43.78,-44.5,-45.38,-45.72,-45.56,-44.47,-43.62,-44.0,-44.53,-44.59,-44.56,-44.97,-44.53,-42.75,-40.41,-38.19,-36.41,-34.94,-33.28,-33.0,1.41,2.97,4.5,5.72,6.59,7.41,7.66:-10.56,-10.97,-10.47,-9.69,-9.66,-10.03,-10.09,-9.38,-8.84,-8.34,-6.91,-4.94,-2.94,-1.78,-1.09,-0.38,-0.03,-0.72,-1.91,-2.44,-2.72,-3.59,-5.03,-5.97,-7.19,-8.81,-11.38,-13.75,-15.12,-16.22,-16.94,-16.84,-15.34,-12.91,-10.69,-8.66,-6.28,-3.5,-1.69,-0.59,0.69,2.25,3.56,3.88,3.97,4.59,5.31,4.97,4.22,4.16,3.97,2.75,1.25,0.19,-0.5,-1.62,-3.31,-4.78,-5.5,-5.66,-6.34,-6.62,-6.19,-5.38,-5.53,-5.88,-5.53,-5.12,-5.19,-6.12,-6.5,-6.78,-6.94,-7.88,-8.25,-8.03,-8.06,-9.41,-10.38,-10.78,-10.34,-9.81,-9.19,-7.44,-5.16,-3.25,-2.31,-1.12,0.16,0.47,-0.88,-2.66,-4.53,-6.28,-8.75,-10.84,-11.66,-11.69,-11.97,-12.97,-13.56,-13.34,-13.78,-14.66,-15.19,-15.06,-15.22,-16.44,-17.38,-17.47,-17.53,-18.09,-18.38,-18.53,-17.91,-17.94,-18.78,-19.25,-19.38,-19.94,-21.16,-21.47,-20.28,-18.62,-17.22,-15.81,-13.81,-11.81,-10.72,-10.0,-9.28,-7.59,-6.53,-6.16,-5.62,-4.31,-3.28,-4.03,-5.25,-6.12,-7.38,-9.28,-10.72,-11.59,-11.53,-11.81,-12.44,-12.97,-12.31,-11.91,-12.09,-11.69,-10.53,-9.84,-10.19,-10.97,-11.09,-11.16,-12.25,-13.31,-13.94,-13.44,-13.25,-13.16,-12.72,-11.62,-11.03,-12.0,-13.31,-13.72,-13.84,-15.16,-15.88,-15.53,-14.91,-15.22,-15.69,-16.12,-16.09,-16.59,-17.16,-17.5,-16.66,-16.34,-17.0,-18.22,-19.38,-20.47,-22.59,-24.22,-24.72,-24.06,-23.31,-21.84,-19.56,-16.0,-12.28,-9.78,-7.53,-5.47,-4.06,-3.88,-4.31,-4.41,-4.75,-6.88,-9.56,-12.22,-14.06,-16.28,-18.72,-20.41,-20.69,-20.91,-21.12,-21.25,-19.88,-18.31,-16.81,-15.72,-13.41,-10.69,-9.47,-9.06,-8.81,-9.03,-9.91,-12.06,-14.22,-14.97,-15.47,-16.22,-16.56,-15.78,-15.03,-15.53,-16.56,-17.22,-17.34,-17.94,-19.25,-20.59,-21.0,-22.06,-24.22,-25.66,-25.78,-26.16,-27.06,-28.56,-28.56,-28.66,-28.88,-28.78,-27.88,-26.25,-25.31,-25.06,-24.31,-22.62,-20.59,-18.72,-16.0,-11.62,-7.28,-3.59,-1.22,1.41,2.91,2.34,0.09,-2.88,-5.31,-8.91,-12.53,-15.09,-16.03,-16.34,-17.19,-18.25,-17.88,-17.75,-18.66,-19.78,-20.59,-20.78,-21.19,-21.75,-21.09,-18.69,-16.53,-14.56,-13.19,-11.56,-10.78,-11.72,-13.62,-14.53,-15.09,-16.97,-19.59,-21.38,-22.94,-24.66,-26.44,-27.19,-27.06,-27.75,-29.19,-31.03,-31.72,-32.31,-33.25,-34.56,-35.09,-34.91,-35.0,-35.41,-34.69,-33.41,-32.19,-31.34,-30.06,-27.66,-25.31,-23.62,-22.5,-20.72,-18.88,-17.59,-16.78,-15.88,-14.88,-14.81,-15.97,-17.28,-18.12,-19.09,-21.56,-23.47,-23.84,-23.88,-24.38,-24.56,-23.62,-22.59,-22.31,-22.47,-22.75,-23.03,-23.88,-26.0,-27.56,-28.22,-28.25,-28.59,-28.53,-26.56,-24.31,-23.19,-22.44,-21.16,-20.25,-19.88,-20.06,-20.09,-19.5,-19.12,-20.12,-21.0,-21.59,-22.28,-24.22,-26.06,-27.44,-28.59,-29.44,-30.03,-29.12,-27.47,-25.31,-23.44,-21.59,-18.72,-16.0,-14.47,-12.56,-10.28,-7.81,-6.69,-6.28,-6.41,-7.03,-8.84,-11.78,-13.97,-15.25,-15.94,-17.06,-17.5,-16.62,-16.03,-16.53,-16.88,-16.5,-15.97,-16.34,-16.88,-16.66,-16.12,-16.25,-17.19,-18.09,-18.56,-19.56,-21.31,-22.62,-22.94,-22.75,-23.12,-23.25,-22.66,-21.44,-20.78,-20.53,-19.56,-17.19,-15.28,-14.09,-12.84,-11.28,-10.53,-11.0,-11.59,-12.22,-12.38,-13.31,-14.34,-14.09,-12.84,-12.06,-11.12,-9.72,-8.0,-6.81,-7.19,-8.03,-9.12,-10.5,-12.53,-14.09,-14.59,-14.09,-14.59,-15.19,-15.28,-14.53,-14.31,-13.38,-12.25,-10.25,-8.25,-8.0,-7.88,-7.62,-7.94,-9.19,-10.53,-11.81,-13.22,-15.78,-18.97,-22.0,-24.03,-25.44,-26.75,-27.31,-26.69,-26.44,-26.84,-27.22,-26.31,-24.69,-23.28,-21.69,-19.81,-17.97,-17.53,-17.78,-18.69,-18.56,-19.0,-19.78,-20.25,-19.44,-18.47,-18.41,-18.25,-17.38,-16.56,-16.41,-17.06,-17.19,-17.06,-17.19,-17.22,-16.56,-14.69,-13.09,-12.78,-12.41,-12.0,-11.31,-10.91,-10.41,-9.97,-9.22,-10.38,-12.69,-15.44,-18.25,-21.56,-24.94,-27.81,-28.97,-29.16,-28.97,-28.03,-25.97,-23.19,-20.75,-18.75,-16.84,-14.69,-13.81,-14.12,-14.19,-13.19,-12.03,-10.59,-8.94,-6.22,-3.62,-1.88,-0.94,0.22,1.06,0.75,-0.28,-1.66,-2.66,-3.94,-6.09,-8.44,-9.97,-11.91,-14.38,-16.41,-17.06,-16.81,-16.22,-15.0,-12.97,-10.75,-9.03,-8.69,-9.12,-9.0,-9.12,-9.84,-10.06,-9.25,-8.31,-8.41,-9.06,-9.34,-10.28,-12.25,-16.0,-19.47,-22.62,-25.66,-28.47,-30.0,-30.12,-29.94,-30.16,-29.97,-28.28,-25.84,-23.28,-20.75,-17.5,-14.53,-12.62,-11.59,-10.62,-9.31,-8.31,-8.03,-8.41,-8.62,-9.22,-10.53,-12.75,-13.47,-14.0,-15.06,-15.97,-16.47,-16.88,-17.34,-18.22,-18.53,-17.94,-16.53,-15.81,-14.84,-13.06,-11.34,-10.62,-10.28,-9.34,-8.0,-7.56,-7.41,-7.72,-7.56,-8.06,-9.78,-11.91,-13.5,-15.56,-18.47,-21.53,-23.72,-24.88,-25.94,-26.78,-26.34,-25.34,-24.41,-24.56,-24.62,-24.5,-24.53,-25.06,-24.97,-24.03,-22.59,-21.5,-21.47,-20.94,-20.56,-20.78,-22.12,-22.81,-23.59,-24.0,-24.41,-24.38,-23.06,-21.34,-19.97,-19.06,-17.12,-15.06,-13.69,-12.53,-10.94,-9.72,-9.34,-10.59,-11.62,-11.94,-12.28,-12.97,-12.66,-12.06,-11.38,-12.0,-12.97,-13.62,-14.0,-14.84,-16.47,-17.56,-18.84,-20.66,-23.12,-24.91,-25.25,-24.72,-23.94,-22.47,-19.44,-16.25,-13.88,-11.97,-10.09,-8.56,-7.66,-7.34,-6.81,-6.25,-6.09,-7.5,-9.53,-11.47,-13.62,-16.59,-19.44,-21.12,-22.16,-23.44,-24.38,-24.78,-24.59,-24.16,-24.44,-24.56,-24.09,-23.72,-24.47,-25.34,-26.06,-26.0,-27.19,-28.16,-27.91,-27.16,-26.09,-25.09,-23.66,-21.34,-18.97,-17.72,-16.56,-15.38,-14.78,-15.69,-16.94,-17.28,-16.81,-17.16,-17.38,-17.31,-17.41,-17.91,-19.0,-19.75,-19.72,-20.0,-21.16,-22.22,-22.66,-22.62,-22.78,-22.41,-21.0,-18.97,-17.69,-17.5,-17.38,-17.31,-17.94,-19.16,-19.97,-19.88,-19.88,-21.06,-22.53,-22.94,-23.31,-24.16,-24.34,-23.28,-21.06,-19.31,-18.12,-17.38,-16.78,-17.16,-18.66,-20.09,-20.16,-19.72,-20.31,-20.78,-20.56,-20.38,-21.03,-21.66,-21.19,-19.66,-18.44,-17.31,-16.62,-15.88,-16.22,-18.12,-20.44,-21.19,-21.34,-21.25,-20.97,-19.5,-17.69,-16.59,-16.22,-15.53,-14.5,-14.69,-15.88,-17.0,-17.66,-18.53,-19.78,-21.25,-22.03,-22.47,-23.44,-24.56,-24.47,-23.31,-22.62,-22.5,-22.66,-22.59,-23.06,-24.19,-25.19,-25.06,-24.84,-25.53,-26.66,-26.66,-26.25,-26.59,-26.94,-26.44,-24.88,-23.88,-23.69,-23.12,-22.25,-22.56,-23.94,-25.78,-26.53,-27.25,-28.31,-28.94,-28.09,-26.66,-25.88,-25.62,-25.22,-24.31,-24.12,-24.59,-25.0,-24.5,-24.44,-25.31,-26.09,-26.19,-25.62,-25.38,-25.19,-24.22,-22.84,-22.22,-22.53,-23.12,-23.0,-23.25,-24.66,-25.56,-25.81,-26.19,-27.31,-29.03,-29.75,-30.16,-31.19,-32.0,-32.34,-31.5,-30.75,-30.94,-30.53,-28.97,-28.38,-28.84,-29.84,-30.38,-30.97,-32.59,-34.5,-34.88,-34.22,-33.88,-33.88,-32.97,-31.59,-30.59,-30.12,-29.56,-28.16,-26.59,-26.31,-27.12,-27.06,-27.5,-28.41,-29.53,-29.34,-27.59,-26.09,-25.31,-24.44,-23.75,-24.16,-26.25,-28.41,-29.88,-30.81,-32.22,-33.0,-32.56,-31.59,-31.12,-31.25,-30.75,-30.06,-30.06,-31.19,-32.19,-32.34,-32.75,-33.91,-34.59,-34.22,-33.28,-32.69,-32.69,-31.94,-31.09,-30.81,-31.38,-31.25,-30.75,-30.62,-31.41,-32.22,-32.03,-31.81,-32.19,-32.47,-31.66,-30.72,-30.25,-30.5,-30.34,-30.09,-30.97,-32.41,-33.41,-32.88,-31.69,-30.41,-28.59,-25.94,-23.62,-23.75,-25.03,-26.66,-28.81,-31.44,-33.84,-34.34,-33.94,-32.88,-32.31,-31.88,-31.0,-30.25,-30.66,-30.97,-30.44,-29.44,-29.66,-30.0,-29.5,-29.19,-28.97,-29.25,-28.97,-28.16,-27.62,-28.44,-29.06,-28.97,-28.81,-29.38,-30.19,-30.5,-30.84,-32.47,-34.19,-35.34,-35.72,-36.16,-37.25,-37.53,-37.22,-36.72,-36.97,-37.03,-36.56,-35.78,-35.88,-36.0,-35.38,-34.31,-34.06,-34.16,-33.94,-32.5,-31.31,-30.78,-29.88,-28.5,-27.34,-27.66,-28.41,-28.72,-29.03,-30.38,-32.38,-33.72,-34.56,-35.62,-37.06,-38.03,-37.88,-37.59,-38.12,-37.62,-35.66,-33.12,-31.19,-29.12,-26.75,-25.16,-25.31,-27.16,-29.59,-32.19,-35.0,-37.84,-39.38,-39.25,-38.66,-38.62,-37.97,-36.72,-34.84,-34.0,-33.06,-32.0,-30.84,-30.88,-31.56,-32.38,-32.62,-32.84,-33.72,-34.0,-32.91,-31.62,-31.41,-30.88,-30.0,-29.28,-29.44,-30.44,-31.25,-31.97,-33.47,-35.84,-37.91,-39.31,-41.09,-43.25,-44.81,-44.94,-44.59,-44.62,-44.19,-42.78,-40.81,-39.75,-38.41,-37.25,-35.12,-34.0,-33.5,-32.81,-32.03,-32.16,-33.62,-35.09,-36.38,-37.78,-39.97,-42.28,-43.78,-44.5,-45.38,-45.72,-45.56,-44.47,-43.62,-44.0,-44.53,-44.59,-44.56,-44.97,-44.53,-42.75,-40.41,-38.19,-36.41,-34.94,-33.28,-33.0,1.41,2.97,4.5,5.72,6.59,7.41,7.66,7.44,6.75,5.44,3.38,0.84,-1.62,-3.59:-9.38,-8.84,-8.34,-6.91,-4.94,-2.94,-1.78,-1.09,-0.38,-0.03,-0.72,-1.91,-2.44,-2.72,-3.59,-5.03,-5.97,-7.19,-8.81,-11.38,-13.75,-15.12,-16.22,-16.94,-16.84,-15.34,-12.91,-10.69,-8.66,-6.28,-3.5,-1.69,-0.59,0.69,2.25,3.56,3.88,3.97,4.59,5.31,4.97,4.22,4.16,3.97,2.75,1.25,0.19,-0.5,-1.62,-3.31,-4.78,-5.5,-5.66,-6.34,-6.62,-6.19,-5.38,-5.53,-5.88,-5.53,-5.12,-5.19,-6.12,-6.5,-6.78,-6.94,-7.88,-8.25,-8.03,-8.06,-9.41,-10.38,-10.78,-10.34,-9.81,-9.19,-7.44,-5.16,-3.25,-2.31,-1.12,0.16,0.47,-0.88,-2.66,-4.53,-6.28,-8.75,-10.84,-11.66,-11.69,-11.97,-12.97,-13.56,-13.34,-13.78,-14.66,-15.19,-15.06,-15.22,-16.44,-17.38,-17.47,-17.53,-18.09,-18.38,-18.53,-17.91,-17.94,-18.78,-19.25,-19.38,-19.94,-21.16,-21.47,-20.28,-18.62,-17.22,-15.81,-13.81,-11.81,-10.72,-10.0,-9.28,-7.59,-6.53,-6.16,-5.62,-4.31,-3.28,-4.03,-5.25,-6.12,-7.38,-9.28,-10.72,-11.59,-11.53,-11.81,-12.44,-12.97,-12.31,-11.91,-12.09,-11.69,-10.53,-9.84,-10.19,-10.97,-11.09,-11.16,-12.25,-13.31,-13.94,-13.44,-13.25,-13.16,-12.72,-11.62,-11.03,-12.0,-13.31,-13.72,-13.84,-15.16,-15.88,-15.53,-14.91,-15.22,-15.69,-16.12,-16.09,-16.59,-17.16,-17.5,-16.66,-16.34,-17.0,-18.22,-19.38,-20.47,-22.59,-24.22,-24.72,-24.06,-23.31,-21.84,-19.56,-16.0,-12.28,-9.78,-7.53,-5.47,-4.06,-3.88,-4.31,-4.41,-4.75,-6.88,-9.56,-12.22,-14.06,-16.28,-18.72,-20.41,-20.69,-20.91,-21.12,-21.25,-19.88,-18.31,-16.81,-15.72,-13.41,-10.69,-9.47,-9.06,-8.81,-9.03,-9.91,-12.06,-14.22,-14.97,-15.47,-16.22,-16.56,-15.78,-15.03,-15.53,-16.56,-17.22,-17.34,-17.94,-19.25,-20.59,-21.0,-22.06,-24.22,-25.66,-25.78,-26.16,-27.06,-28.56,-28.56,-28.66,-28.88,-28.78,-27.88,-26.25,-25.31,-25.06,-24.31,-22.62,-20.59,-18.72,-16.0,-11.62,-7.28,-3.59,-1.22,1.41,2.91,2.34,0.09,-2.88,-5.31,-8.91,-12.53,-15.09,-16.03,-16.34,-17.19,-18.25,-17.88,-17.75,-18.66,-19.78,-20.59,-20.78,-21.19,-21.75,-21.09,-18.69,-16.53,-14.56,-13.19,-11.56,-10.78,-11.72,-13.62,-14.53,-15.09,-16.97,-19.59,-21.38,-22.94,-24.66,-26.44,-27.19,-27.06,-27.75,-29.19,-31.03,-31.72,-32.31,-33.25,-34.56,-35.09,-34.91,-35.0,-35.41,-34.69,-33.41,-32.19,-31.34,-30.06,-27.66,-25.31,-23.62,-22.5,-20.72,-18.88,-17.59,-16.78,-15.88,-14.88,-14.81,-15.97,-17.28,-18.12,-19.09,-21.56,-23.47,-23.84,-23.88,-24.38,-24.56,-23.62,-22.59,-22.31,-22.47,-22.75,-23.03,-23.88,-26.0,-27.56,-28.22,-28.25,-28.59,-28.53,-26.56,-24.31,-23.19,-22.44,-21.16,-20.25,-19.88,-20.06,-20.09,-19.5,-19.12,-20.12,-21.0,-21.59,-22.28,-24.22,-26.06,-27.44,-28.59,-29.44,-30.03,-29.12,-27.47,-25.31,-23.44,-21.59,-18.72,-16.0,-14.47,-12.56,-10.28,-7.81,-6.69,-6.28,-6.41,-7.03,-8.84,-11.78,-13.97,-15.25,-15.94,-17.06,-17.5,-16.62,-16.03,-16.53,-16.88,-16.5,-15.97,-16.34,-16.88,-16.66,-16.12,-16.25,-17.19,-18.09,-18.56,-19.56,-21.31,-22.62,-22.94,-22.75,-23.12,-23.25,-22.66,-21.44,-20.78,-20.53,-19.56,-17.19,-15.28,-14.09,-12.84,-11.28,-10.53,-11.0,-11.59,-12.22,-12.38,-13.31,-14.34,-14.09,-12.84,-12.06,-11.12,-9.72,-8.0,-6.81,-7.19,-8.03,-9.12,-10.5,-12.53,-14.09,-14.59,-14.09,-14.59,-15.19,-15.28,-14.53,-14.31,-13.38,-12.25,-10.25,-8.25,-8.0,-7.88,-7.62,-7.94,-9.19,-10.53,-11.81,-13.22,-15.78,-18.97,-22.0,-24.03,-25.44,-26.75,-27.31,-26.69,-26.44,-26.84,-27.22,-26.31,-24.69,-23.28,-21.69,-19.81,-17.97,-17.53,-17.78,-18.69,-18.56,-19.0,-19.78,-20.25,-19.44,-18.47,-18.41,-18.25,-17.38,-16.56,-16.41,-17.06,-17.19,-17.06,-17.19,-17.22,-16.56,-14.69,-13.09,-12.78,-12.41,-12.0,-11.31,-10.91,-10.41,-9.97,-9.22,-10.38,-12.69,-15.44,-18.25,-21.56,-24.94,-27.81,-28.97,-29.16,-28.97,-28.03,-25.97,-23.19,-20.75,-18.75,-16.84,-14.69,-13.81,-14.12,-14.19,-13.19,-12.03,-10.59,-8.94,-6.22,-3.62,-1.88,-0.94,0.22,1.06,0.75,-0.28,-1.66,-2.66,-3.94,-6.09,-8.44,-9.97,-11.91,-14.38,-16.41,-17.06,-16.81,-16.22,-15.0,-12.97,-10.75,-9.03,-8.69,-9.12,-9.0,-9.12,-9.84,-10.06,-9.25,-8.31,-8.41,-9.06,-9.34,-10.28,-12.25,-16.0,-19.47,-22.62,-25.66,-28.47,-30.0,-30.12,-29.94,-30.16,-29.97,-28.28,-25.84,-23.28,-20.75,-17.5,-14.53,-12.62,-11.59,-10.62,-9.31,-8.31,-8.03,-8.41,-8.62,-9.22,-10.53,-12.75,-13.47,-14.0,-15.06,-15.97,-16.47,-16.88,-17.34,-18.22,-18.53,-17.94,-16.53,-15.81,-14.84,-13.06,-11.34,-10.62,-10.28,-9.34,-8.0,-7.56,-7.41,-7.72,-7.56,-8.06,-9.78,-11.91,-13.5,-15.56,-18.47,-21.53,-23.72,-24.88,-25.94,-26.78,-26.34,-25.34,-24.41,-24.56,-24.62,-24.5,-24.53,-25.06,-24.97,-24.03,-22.59,-21.5,-21.47,-20.94,-20.56,-20.78,-22.12,-22.81,-23.59,-24.0,-24.41,-24.38,-23.06,-21.34,-19.97,-19.06,-17.12,-15.06,-13.69,-12.53,-10.94,-9.72,-9.34,-10.59,-11.62,-11.94,-12.28,-12.97,-12.66,-12.06,-11.38,-12.0,-12.97,-13.62,-14.0,-14.84,-16.47,-17.56,-18.84,-20.66,-23.12,-24.91,-25.25,-24.72,-23.94,-22.47,-19.44,-16.25,-13.88,-11.97,-10.09,-8.56,-7.66,-7.34,-6.81,-6.25,-6.09,-7.5,-9.53,-11.47,-13.62,-16.59,-19.44,-21.12,-22.16,-23.44,-24.38,-24.78,-24.59,-24.16,-24.44,-24.56,-24.09,-23.72,-24.47,-25.34,-26.06,-26.0,-27.19,-28.16,-27.91,-27.16,-26.09,-25.09,-23.66,-21.34,-18.97,-17.72,-16.56,-15.38,-14.78,-15.69,-16.94,-17.28,-16.81,-17.16,-17.38,-17.31,-17.41,-17.91,-19.0,-19.75,-19.72,-20.0,-21.16,-22.22,-22.66,-22.62,-22.78,-22.41,-21.0,-18.97,-17.69,-17.5,-17.38,-17.31,-17.94,-19.16,-19.97,-19.88,-19.88,-21.06,-22.53,-22.94,-23.31,-24.16,-24.34,-23.28,-21.06,-19.31,-18.12,-17.38,-16.78,-17.16,-18.66,-20.09,-20.16,-19.72,-20.31,-20.78,-20.56,-20.38,-21.03,-21.66,-21.19,-19.66,-18.44,-17.31,-16.62,-15.88,-16.22,-18.12,-20.44,-21.19,-21.34,-21.25,-20.97,-19.5,-17.69,-16.59,-16.22,-15.53,-14.5,-14.69,-15.88,-17.0,-17.66,-18.53,-19.78,-21.25,-22.03,-22.47,-23.44,-24.56,-24.47,-23.31,-22.62,-22.5,-22.66,-22.59,-23.06,-24.19,-25.19,-25.06,-24.84,-25.53,-26.66,-26.66,-26.25,-26.59,-26.94,-26.44,-24.88,-23.88,-23.69,-23.12,-22.25,-22.56,-23.94,-25.78,-26.53,-27.25,-28.31,-28.94,-28.09,-26.66,-25.88,-25.62,-25.22,-24.31,-24.12,-24.59,-25.0,-24.5,-24.44,-25.31,-26.09,-26.19,-25.62,-25.38,-25.19,-24.22,-22.84,-22.22,-22.53,-23.12,-23.0,-23.25,-24.66,-25.56,-25.81,-26.19,-27.31,-29.03,-29.75,-30.16,-31.19,-32.0,-32.34,-31.5,-30.75,-30.94,-30.53,-28.97,-28.38,-28.84,-29.84,-30.38,-30.97,-32.59,-34.5,-34.88,-34.22,-33.88,-33.88,-32.97,-31.59,-30.59,-30.12,-29.56,-28.16,-26.59,-26.31,-27.12,-27.06,-27.5,-28.41,-29.53,-29.34,-27.59,-26.09,-25.31,-24.44,-23.75,-24.16,-26.25,-28.41,-29.88,-30.81,-32.22,-33.0,-32.56,-31.59,-31.12,-31.25,-30.75,-30.06,-30.06,-31.19,-32.19,-32.34,-32.75,-33.91,-34.59,-34.22,-33.28,-32.69,-32.69,-31.94,-31.09,-30.81,-31.38,-31.25,-30.75,-30.62,-31.41,-32.22,-32.03,-31.81,-32.19,-32.47,-31.66,-30.72,-30.25,-30.5,-30.34,-30.09,-30.97,-32.41,-33.41,-32.88,-31.69,-30.41,-28.59,-25.94,-23.62,-23.75,-25.03,-26.66,-28.81,-31.44,-33.84,-34.34,-33.94,-32.88,-32.31,-31.88,-31.0,-30.25,-30.66,-30.97,-30.44,-29.44,-29.66,-30.0,-29.5,-29.19,-28.97,-29.25,-28.97,-28.16,-27.62,-28.44,-29.06,-28.97,-28.81,-29.38,-30.19,-30.5,-30.84,-32.47,-34.19,-35.34,-35.72,-36.16,-37.25,-37.53,-37.22,-36.72,-36.97,-37.03,-36.56,-35.78,-35.88,-36.0,-35.38,-34.31,-34.06,-34.16,-33.94,-32.5,-31.31,-30.78,-29.88,-28.5,-27.34,-27.66,-28.41,-28.72,-29.03,-30.38,-32.38,-33.72,-34.56,-35.62,-37.06,-38.03,-37.88,-37.59,-38.12,-37.62,-35.66,-33.12,-31.19,-29.12,-26.75,-25.16,-25.31,-27.16,-29.59,-32.19,-35.0,-37.84,-39.38,-39.25,-38.66,-38.62,-37.97,-36.72,-34.84,-34.0,-33.06,-32.0,-30.84,-30.88,-31.56,-32.38,-32.62,-32.84,-33.72,-34.0,-32.91,-31.62,-31.41,-30.88,-30.0,-29.28,-29.44,-30.44,-31.25,-31.97,-33.47,-35.84,-37.91,-39.31,-41.09,-43.25,-44.81,-44.94,-44.59,-44.62,-44.19,-42.78,-40.81,-39.75,-38.41,-37.25,-35.12,-34.0,-33.5,-32.81,-32.03,-32.16,-33.62,-35.09,-36.38,-37.78,-39.97,-42.28,-43.78,-44.5,-45.38,-45.72,-45.56,-44.47,-43.62,-44.0,-44.53,-44.59,-44.56,-44.97,-44.53,-42.75,-40.41,-38.19,-36.41,-34.94,-33.28,-33.0,1.41,2.97,4.5,5.72,6.59,7.41,7.66,7.44,6.75,5.44,3.38,0.84,-1.62,-3.59,-4.56,-4.66,-4.25,-3.31,-2.03,-1.34,-1.31:-1.09,-0.38,-0.03,-0.72,-1.91,-2.44,-2.72,-3.59,-5.03,-5.97,-7.19,-8.81,-11.38,-13.75,-15.12,-16.22,-16.94,-16.84,-15.34,-12.91,-10.69,-8.66,-6.28,-3.5,-1.69,-0.59,0.69,2.25,3.56,3.88,3.97,4.59,5.31,4.97,4.22,4.16,3.97,2.75,1.25,0.19,-0.5,-1.62,-3.31,-4.78,-5.5,-5.66,-6.34,-6.62,-6.19,-5.38,-5.53,-5.88,-5.53,-5.12,-5.19,-6.12,-6.5,-6.78,-6.94,-7.88,-8.25,-8.03,-8.06,-9.41,-10.38,-10.78,-10.34,-9.81,-9.19,-7.44,-5.16,-3.25,-2.31,-1.12,0.16,0.47,-0.88,-2.66,-4.53,-6.28,-8.75,-10.84,-11.66,-11.69,-11.97,-12.97,-13.56,-13.34,-13.78,-14.66,-15.19,-15.06,-15.22,-16.44,-17.38,-17.47,-17.53,-18.09,-18.38,-18.53,-17.91,-17.94,-18.78,-19.25,-19.38,-19.94,-21.16,-21.47,-20.28,-18.62,-17.22,-15.81,-13.81,-11.81,-10.72,-10.0,-9.28,-7.59,-6.53,-6.16,-5.62,-4.31,-3.28,-4.03,-5.25,-6.12,-7.38,-9.28,-10.72,-11.59,-11.53,-11.81,-12.44,-12.97,-12.31,-11.91,-12.09,-11.69,-10.53,-9.84,-10.19,-10.97,-11.09,-11.16,-12.25,-13.31,-13.94,-13.44,-13.25,-13.16,-12.72,-11.62,-11.03,-12.0,-13.31,-13.72,-13.84,-15.16,-15.88,-15.53,-14.91,-15.22,-15.69,-16.12,-16.09,-16.59,-17.16,-17.5,-16.66,-16.34,-17.0,-18.22,-19.38,-20.47,-22.59,-24.22,-24.72,-24.06,-23.31,-21.84,-19.56,-16.0,-12.28,-9.78,-7.53,-5.47,-4.06,-3.88,-4.31,-4.41,-4.75,-6.88,-9.56,-12.22,-14.06,-16.28,-18.72,-20.41,-20.69,-20.91,-21.12,-21.25,-19.88,-18.31,-16.81,-15.72,-13.41,-10.69,-9.47,-9.06,-8.81,-9.03,-9.91,-12.06,-14.22,-14.97,-15.47,-16.22,-16.56,-15.78,-15.03,-15.53,-16.56,-17.22,-17.34,-17.94,-19.25,-20.59,-21.0,-22.06,-24.22,-25.66,-25.78,-26.16,-27.06,-28.56,-28.56,-28.66,-28.88,-28.78,-27.88,-26.25,-25.31,-25.06,-24.31,-22.62,-20.59,-18.72,-16.0,-11.62,-7.28,-3.59,-1.22,1.41,2.91,2.34,0.09,-2.88,-5.31,-8.91,-12.53,-15.09,-16.03,-16.34,-17.19,-18.25,-17.88,-17.75,-18.66,-19.78,-20.59,-20.78,-21.19,-21.75,-21.09,-18.69,-16.53,-14.56,-13.19,-11.56,-10.78,-11.72,-13.62,-14.53,-15.09,-16.97,-19.59,-21.38,-22.94,-24.66,-26.44,-27.19,-27.06,-27.75,-29.19,-31.03,-31.72,-32.31,-33.25,-34.56,-35.09,-34.91,-35.0,-35.41,-34.69,-33.41,-32.19,-31.34,-30.06,-27.66,-25.31,-23.62,-22.5,-20.72,-18.88,-17.59,-16.78,-15.88,-14.88,-14.81,-15.97,-17.28,-18.12,-19.09,-21.56,-23.47,-23.84,-23.88,-24.38,-24.56,-23.62,-22.59,-22.31,-22.47,-22.75,-23.03,-23.88,-26.0,-27.56,-28.22,-28.25,-28.59,-28.53,-26.56,-24.31,-23.19,-22.44,-21.16,-20.25,-19.88,-20.06,-20.09,-19.5,-19.12,-20.12,-21.0,-21.59,-22.28,-24.22,-26.06,-27.44,-28.59,-29.44,-30.03,-29.12,-27.47,-25.31,-23.44,-21.59,-18.72,-16.0,-14.47,-12.56,-10.28,-7.81,-6.69,-6.28,-6.41,-7.03,-8.84,-11.78,-13.97,-15.25,-15.94,-17.06,-17.5,-16.62,-16.03,-16.53,-16.88,-16.5,-15.97,-16.34,-16.88,-16.66,-16.12,-16.25,-17.19,-18.09,-18.56,-19.56,-21.31,-22.62,-22.94,-22.75,-23.12,-23.25,-22.66,-21.44,-20.78,-20.53,-19.56,-17.19,-15.28,-14.09,-12.84,-11.28,-10.53,-11.0,-11.59,-12.22,-12.38,-13.31,-14.34,-14.09,-12.84,-12.06,-11.12,-9.72,-8.0,-6.81,-7.19,-8.03,-9.12,-10.5,-12.53,-14.09,-14.59,-14.09,-14.59,-15.19,-15.28,-14.53,-14.31,-13.38,-12.25,-10.25,-8.25,-8.0,-7.88,-7.62,-7.94,-9.19,-10.53,-11.81,-13.22,-15.78,-18.97,-22.0,-24.03,-25.44,-26.75,-27.31,-26.69,-26.44,-26.84,-27.22,-26.31,-24.69,-23.28,-21.69,-19.81,-17.97,-17.53,-17.78,-18.69,-18.56,-19.0,-19.78,-20.25,-19.44,-18.47,-18.41,-18.25,-17.38,-16.56,-16.41,-17.06,-17.19,-17.06,-17.19,-17.22,-16.56,-14.69,-13.09,-12.78,-12.41,-12.0,-11.31,-10.91,-10.41,-9.97,-9.22,-10.38,-12.69,-15.44,-18.25,-21.56,-24.94,-27.81,-28.97,-29.16,-28.97,-28.03,-25.97,-23.19,-20.75,-18.75,-16.84,-14.69,-13.81,-14.12,-14.19,-13.19,-12.03,-10.59,-8.94,-6.22,-3.62,-1.88,-0.94,0.22,1.06,0.75,-0.28,-1.66,-2.66,-3.94,-6.09,-8.44,-9.97,-11.91,-14.38,-16.41,-17.06,-16.81,-16.22,-15.0,-12.97,-10.75,-9.03,-8.69,-9.12,-9.0,-9.12,-9.84,-10.06,-9.25,-8.31,-8.41,-9.06,-9.34,-10.28,-12.25,-16.0,-19.47,-22.62,-25.66,-28.47,-30.0,-30.12,-29.94,-30.16,-29.97,-28.28,-25.84,-23.28,-20.75,-17.5,-14.53,-12.62,-11.59,-10.62,-9.31,-8.31,-8.03,-8.41,-8.62,-9.22,-10.53,-12.75,-13.47,-14.0,-15.06,-15.97,-16.47,-16.88,-17.34,-18.22,-18.53,-17.94,-16.53,-15.81,-14.84,-13.06,-11.34,-10.62,-10.28,-9.34,-8.0,-7.56,-7.41,-7.72,-7.56,-8.06,-9.78,-11.91,-13.5,-15.56,-18.47,-21.53,-23.72,-24.88,-25.94,-26.78,-26.34,-25.34,-24.41,-24.56,-24.62,-24.5,-24.53,-25.06,-24.97,-24.03,-22.59,-21.5,-21.47,-20.94,-20.56,-20.78,-22.12,-22.81,-23.59,-24.0,-24.41,-24.38,-23.06,-21.34,-19.97,-19.06,-17.12,-15.06,-13.69,-12.53,-10.94,-9.72,-9.34,-10.59,-11.62,-11.94,-12.28,-12.97,-12.66,-12.06,-11.38,-12.0,-12.97,-13.62,-14.0,-14.84,-16.47,-17.56,-18.84,-20.66,-23.12,-24.91,-25.25,-24.72,-23.94,-22.47,-19.44,-16.25,-13.88,-11.97,-10.09,-8.56,-7.66,-7.34,-6.81,-6.25,-6.09,-7.5,-9.53,-11.47,-13.62,-16.59,-19.44,-21.12,-22.16,-23.44,-24.38,-24.78,-24.59,-24.16,-24.44,-24.56,-24.09,-23.72,-24.47,-25.34,-26.06,-26.0,-27.19,-28.16,-27.91,-27.16,-26.09,-25.09,-23.66,-21.34,-18.97,-17.72,-16.56,-15.38,-14.78,-15.69,-16.94,-17.28,-16.81,-17.16,-17.38,-17.31,-17.41,-17.91,-19.0,-19.75,-19.72,-20.0,-21.16,-22.22,-22.66,-22.62,-22.78,-22.41,-21.0,-18.97,-17.69,-17.5,-17.38,-17.31,-17.94,-19.16,-19.97,-19.88,-19.88,-21.06,-22.53,-22.94,-23.31,-24.16,-24.34,-23.28,-21.06,-19.31,-18.12,-17.38,-16.78,-17.16,-18.66,-20.09,-20.16,-19.72,-20.31,-20.78,-20.56,-20.38,-21.03,-21.66,-21.19,-19.66,-18.44,-17.31,-16.62,-15.88,-16.22,-18.12,-20.44,-21.19,-21.34,-21.25,-20.97,-19.5,-17.69,-16.59,-16.22,-15.53,-14.5,-14.69,-15.88,-17.0,-17.66,-18.53,-19.78,-21.25,-22.03,-22.47,-23.44,-24.56,-24.47,-23.31,-22.62,-22.5,-22.66,-22.59,-23.06,-24.19,-25.19,-25.06,-24.84,-25.53,-26.66,-26.66,-26.25,-26.59,-26.94,-26.44,-24.88,-23.88,-23.69,-23.12,-22.25,-22.56,-23.94,-25.78,-26.53,-27.25,-28.31,-28.94,-28.09,-26.66,-25.88,-25.62,-25.22,-24.31,-24.12,-24.59,-25.0,-24.5,-24.44,-25.31,-26.09,-26.19,-25.62,-25.38,-25.19,-24.22,-22.84,-22.22,-22.53,-23.12,-23.0,-23.25,-24.66,-25.56,-25.81,-26.19,-27.31,-29.03,-29.75,-30.16,-31.19,-32.0,-32.34,-31.5,-30.75,-30.94,-30.53,-28.97,-28.38,-28.84,-29.84,-30.38,-30.97,-32.59,-34.5,-34.88,-34.22,-33.88,-33.88,-32.97,-31.59,-30.59,-30.12,-29.56,-28.16,-26.59,-26.31,-27.12,-27.06,-27.5,-28.41,-29.53,-29.34,-27.59,-26.09,-25.31,-24.44,-23.75,-24.16,-26.25,-28.41,-29.88,-30.81,-32.22,-33.0,-32.56,-31.59,-31.12,-31.25,-30.75,-30.06,-30.06,-31.19,-32.19,-32.34,-32.75,-33.91,-34.59,-34.22,-33.28,-32.69,-32.69,-31.94,-31.09,-30.81,-31.38,-31.25,-30.75,-30.62,-31.41,-32.22,-32.03,-31.81,-32.19,-32.47,-31.66,-30.72,-30.25,-30.5,-30.34,-30.09,-30.97,-32.41,-33.41,-32.88,-31.69,-30.41,-28.59,-25.94,-23.62,-23.75,-25.03,-26.66,-28.81,-31.44,-33.84,-34.34,-33.94,-32.88,-32.31,-31.88,-31.0,-30.25,-30.66,-30.97,-30.44,-29.44,-29.66,-30.0,-29.5,-29.19,-28.97,-29.25,-28.97,-28.16,-27.62,-28.44,-29.06,-28.97,-28.81,-29.38,-30.19,-30.5,-30.84,-32.47,-34.19,-35.34,-35.72,-36.16,-37.25,-37.53,-37.22,-36.72,-36.97,-37.03,-36.56,-35.78,-35.88,-36.0,-35.38,-34.31,-34.06,-34.16,-33.94,-32.5,-31.31,-30.78,-29.88,-28.5,-27.34,-27.66,-28.41,-28.72,-29.03,-30.38,-32.38,-33.72,-34.56,-35.62,-37.06,-38.03,-37.88,-37.59,-38.12,-37.62,-35.66,-33.12,-31.19,-29.12,-26.75,-25.16,-25.31,-27.16,-29.59,-32.19,-35.0,-37.84,-39.38,-39.25,-38.66,-38.62,-37.97,-36.72,-34.84,-34.0,-33.06,-32.0,-30.84,-30.88,-31.56,-32.38,-32.62,-32.84,-33.72,-34.0,-32.91,-31.62,-31.41,-30.88,-30.0,-29.28,-29.44,-30.44,-31.25,-31.97,-33.47,-35.84,-37.91,-39.31,-41.09,-43.25,-44.81,-44.94,-44.59,-44.62,-44.19,-42.78,-40.81,-39.75,-38.41,-37.25,-35.12,-34.0,-33.5,-32.81,-32.03,-32.16,-33.62,-35.09,-36.38,-37.78,-39.97,-42.28,-43.78,-44.5,-45.38,-45.72,-45.56,-44.47,-43.62,-44.0,-44.53,-44.59,-44.56,-44.97,-44.53,-42.75,-40.41,-38.19,-36.41,-34.94,-33.28,-33.0,1.41,2.97,4.5,5.72,6.59,7.41,7.66,7.44,6.75,5.44,3.38,0.84,-1.62,-3.59,-4.56,-4.66,-4.25,-3.31,-2.03,-1.34,-1.31,-1.16,-0.84,-0.59,0.12,1.03,2.09,3.0:-3.59,-5.03,-5.97,-7.19,-8.81,-11.38,-13.75,-15.12,-16.22,-16.94,-16.84,-15.34,-12.91,-10.69,-8.66,-6.28,-3.5,-1.69,-0.59,0.69,2.25,3.56,3.88,3.97,4.59,5.31,4.97,4.22,4.16,3.97,2.75,1.25,0.19,-0.5,-1.62,-3.31,-4.78,-5.5,-5.66,-6.34,-6.62,-6.19,-5.38,-5.53,-5.88,-5.53,-5.12,-5.19,-6.12,-6.5,-6.78,-6.94,-7.88,-8.25,-8.03,-8.06,-9.41,-10.38,-10.78,-10.34,-9.81,-9.19,-7.44,-5.16,-3.25,-2.31,-1.12,0.16,0.47,-0.88,-2.66,-4.53,-6.28,-8.75,-10.84,-11.66,-11.69,-11.97,-12.97,-13.56,-13.34,-13.78,-14.66,-15.19,-15.06,-15.22,-16.44,-17.38,-17.47,-17.53,-18.09,-18.38,-18.53,-17.91,-17.94,-18.78,-19.25,-19.38,-19.94,-21.16,-21.47,-20.28,-18.62,-17.22,-15.81,-13.81,-11.81,-10.72,-10.0,-9.28,-7.59,-6.53,-6.16,-5.62,-4.31,-3.28,-4.03,-5.25,-6.12,-7.38,-9.28,-10.72,-11.59,-11.53,-11.81,-12.44,-12.97,-12.31,-11.91,-12.09,-11.69,-10.53,-9.84,-10.19,-10.97,-11.09,-11.16,-12.25,-13.31,-13.94,-13.44,-13.25,-13.16,-12.72,-11.62,-11.03,-12.0,-13.31,-13.72,-13.84,-15.16,-15.88,-15.53,-14.91,-15.22,-15.69,-16.12,-16.09,-16.59,-17.16,-17.5,-16.66,-16.34,-17.0,-18.22,-19.38,-20.47,-22.59,-24.22,-24.72,-24.06,-23.31,-21.84,-19.56,-16.0,-12.28,-9.78,-7.53,-5.47,-4.06,-3.88,-4.31,-4.41,-4.75,-6.88,-9.56,-12.22,-14.06,-16.28,-18.72,-20.41,-20.69,-20.91,-21.12,-21.25,-19.88,-18.31,-16.81,-15.72,-13.41,-10.69,-9.47,-9.06,-8.81,-9.03,-9.91,-12.06,-14.22,-14.97,-15.47,-16.22,-16.56,-15.78,-15.03,-15.53,-16.56,-17.22,-17.34,-17.94,-19.25,-20.59,-21.0,-22.06,-24.22,-25.66,-25.78,-26.16,-27.06,-28.56,-28.56,-28.66,-28.88,-28.78,-27.88,-26.25,-25.31,-25.06,-24.31,-22.62,-20.59,-18.72,-16.0,-11.62,-7.28,-3.59,-1.22,1.41,2.91,2.34,0.09,-2.88,-5.31,-8.91,-12.53,-15.09,-16.03,-16.34,-17.19,-18.25,-17.88,-17.75,-18.66,-19.78,-20.59,-20.78,-21.19,-21.75,-21.09,-18.69,-16.53,-14.56,-13.19,-11.56,-10.78,-11.72,-13.62,-14.53,-15.09,-16.97,-19.59,-21.38,-22.94,-24.66,-26.44,-27.19,-27.06,-27.75,-29.19,-31.03,-31.72,-32.31,-33.25,-34.56,-35.09,-34.91,-35.0,-35.41,-34.69,-33.41,-32.19,-31.34,-30.06,-27.66,-25.31,-23.62,-22.5,-20.72,-18.88,-17.59,-16.78,-15.88,-14.88,-14.81,-15.97,-17.28,-18.12,-19.09,-21.56,-23.47,-23.84,-23.88,-24.38,-24.56,-23.62,-22.59,-22.31,-22.47,-22.75,-23.03,-23.88,-26.0,-27.56,-28.22,-28.25,-28.59,-28.53,-26.56,-24.31,-23.19,-22.44,-21.16,-20.25,-19.88,-20.06,-20.09,-19.5,-19.12,-20.12,-21.0,-21.59,-22.28,-24.22,-26.06,-27.44,-28.59,-29.44,-30.03,-29.12,-27.47,-25.31,-23.44,-21.59,-18.72,-16.0,-14.47,-12.56,-10.28,-7.81,-6.69,-6.28,-6.41,-7.03,-8.84,-11.78,-13.97,-15.25,-15.94,-17.06,-17.5,-16.62,-16.03,-16.53,-16.88,-16.5,-15.97,-16.34,-16.88,-16.66,-16.12,-16.25,-17.19,-18.09,-18.56,-19.56,-21.31,-22.62,-22.94,-22.75,-23.12,-23.25,-22.66,-21.44,-20.78,-20.53,-19.56,-17.19,-15.28,-14.09,-12.84,-11.28,-10.53,-11.0,-11.59,-12.22,-12.38,-13.31,-14.34,-14.09,-12.84,-12.06,-11.12,-9.72,-8.0,-6.81,-7.19,-8.03,-9.12,-10.5,-12.53,-14.09,-14.59,-14.09,-14.59,-15.19,-15.28,-14.53,-14.31,-13.38,-12.25,-10.25,-8.25,-8.0,-7.88,-7.62,-7.94,-9.19,-10.53,-11.81,-13.22,-15.78,-18.97,-22.0,-24.03,-25.44,-26.75,-27.31,-26.69,-26.44,-26.84,-27.22,-26.31,-24.69,-23.28,-21.69,-19.81,-17.97,-17.53,-17.78,-18.69,-18.56,-19.0,-19.78,-20.25,-19.44,-18.47,-18.41,-18.25,-17.38,-16.56,-16.41,-17.06,-17.19,-17.06,-17.19,-17.22,-16.56,-14.69,-13.09,-12.78,-12.41,-12.0,-11.31,-10.91,-10.41,-9.97,-9.22,-10.38,-12.69,-15.44,-18.25,-21.56,-24.94,-27.81,-28.97,-29.16,-28.97,-28.03,-25.97,-23.19,-20.75,-18.75,-16.84,-14.69,-13.81,-14.12,-14.19,-13.19,-12.03,-10.59,-8.94,-6.22,-3.62,-1.88,-0.94,0.22,1.06,0.75,-0.28,-1.66,-2.66,-3.94,-6.09,-8.44,-9.97,-11.91,-14.38,-16.41,-17.06,-16.81,-16.22,-15.0,-12.97,-10.75,-9.03,-8.69,-9.12,-9.0,-9.12,-9.84,-10.06,-9.25,-8.31,-8.41,-9.06,-9.34,-10.28,-12.25,-16.0,-19.47,-22.62,-25.66,-28.47,-30.0,-30.12,-29.94,-30.16,-29.97,-28.28,-25.84,-23.28,-20.75,-17.5,-14.53,-12.62,-11.59,-10.62,-9.31,-8.31,-8.03,-8.41,-8.62,-9.22,-10.53,-12.75,-13.47,-14.0,-15.06,-15.97,-16.47,-16.88,-17.34,-18.22,-18.53,-17.94,-16.53,-15.81,-14.84,-13.06,-11.34,-10.62,-10.28,-9.34,-8.0,-7.56,-7.41,-7.72,-7.56,-8.06,-9.78,-11.91,-13.5,-15.56,-18.47,-21.53,-23.72,-24.88,-25.94,-26.78,-26.34,-25.34,-24.41,-24.56,-24.62,-24.5,-24.53,-25.06,-24.97,-24.03,-22.59,-21.5,-21.47,-20.94,-20.56,-20.78,-22.12,-22.81,-23.59,-24.0,-24.41,-24.38,-23.06,-21.34,-19.97,-19.06,-17.12,-15.06,-13.69,-12.53,-10.94,-9.72,-9.34,-10.59,-11.62,-11.94,-12.28,-12.97,-12.66,-12.06,-11.38,-12.0,-12.97,-13.62,-14.0,-14.84,-16.47,-17.56,-18.84,-20.66,-23.12,-24.91,-25.25,-24.72,-23.94,-22.47,-19.44,-16.25,-13.88,-11.97,-10.09,-8.56,-7.66,-7.34,-6.81,-6.25,-6.09,-7.5,-9.53,-11.47,-13.62,-16.59,-19.44,-21.12,-22.16,-23.44,-24.38,-24.78,-24.59,-24.16,-24.44,-24.56,-24.09,-23.72,-24.47,-25.34,-26.06,-26.0,-27.19,-28.16,-27.91,-27.16,-26.09,-25.09,-23.66,-21.34,-18.97,-17.72,-16.56,-15.38,-14.78,-15.69,-16.94,-17.28,-16.81,-17.16,-17.38,-17.31,-17.41,-17.91,-19.0,-19.75,-19.72,-20.0,-21.16,-22.22,-22.66,-22.62,-22.78,-22.41,-21.0,-18.97,-17.69,-17.5,-17.38,-17.31,-17.94,-19.16,-19.97,-19.88,-19.88,-21.06,-22.53,-22.94,-23.31,-24.16,-24.34,-23.28,-21.06,-19.31,-18.12,-17.38,-16.78,-17.16,-18.66,-20.09,-20.16,-19.72,-20.31,-20.78,-20.56,-20.38,-21.03,-21.66,-21.19,-19.66,-18.44,-17.31,-16.62,-15.88,-16.22,-18.12,-20.44,-21.19,-21.34,-21.25,-20.97,-19.5,-17.69,-16.59,-16.22,-15.53,-14.5,-14.69,-15.88,-17.0,-17.66,-18.53,-19.78,-21.25,-22.03,-22.47,-23.44,-24.56,-24.47,-23.31,-22.62,-22.5,-22.66,-22.59,-23.06,-24.19,-25.19,-25.06,-24.84,-25.53,-26.66,-26.66,-26.25,-26.59,-26.94,-26.44,-24.88,-23.88,-23.69,-23.12,-22.25,-22.56,-23.94,-25.78,-26.53,-27.25,-28.31,-28.94,-28.09,-26.66,-25.88,-25.62,-25.22,-24.31,-24.12,-24.59,-25.0,-24.5,-24.44,-25.31,-26.09,-26.19,-25.62,-25.38,-25.19,-24.22,-22.84,-22.22,-22.53,-23.12,-23.0,-23.25,-24.66,-25.56,-25.81,-26.19,-27.31,-29.03,-29.75,-30.16,-31.19,-32.0,-32.34,-31.5,-30.75,-30.94,-30.53,-28.97,-28.38,-28.84,-29.84,-30.38,-30.97,-32.59,-34.5,-34.88,-34.22,-33.88,-33.88,-32.97,-31.59,-30.59,-30.12,-29.56,-28.16,-26.59,-26.31,-27.12,-27.06,-27.5,-28.41,-29.53,-29.34,-27.59,-26.09,-25.31,-24.44,-23.75,-24.16,-26.25,-28.41,-29.88,-30.81,-32.22,-33.0,-32.56,-31.59,-31.12,-31.25,-30.75,-30.06,-30.06,-31.19,-32.19,-32.34,-32.75,-33.91,-34.59,-34.22,-33.28,-32.69,-32.69,-31.94,-31.09,-30.81,-31.38,-31.25,-30.75,-30.62,-31.41,-32.22,-32.03,-31.81,-32.19,-32.47,-31.66,-30.72,-30.25,-30.5,-30.34,-30.09,-30.97,-32.41,-33.41,-32.88,-31.69,-30.41,-28.59,-25.94,-23.62,-23.75,-25.03,-26.66,-28.81,-31.44,-33.84,-34.34,-33.94,-32.88,-32.31,-31.88,-31.0,-30.25,-30.66,-30.97,-30.44,-29.44,-29.66,-30.0,-29.5,-29.19,-28.97,-29.25,-28.97,-28.16,-27.62,-28.44,-29.06,-28.97,-28.81,-29.38,-30.19,-30.5,-30.84,-32.47,-34.19,-35.34,-35.72,-36.16,-37.25,-37.53,-37.22,-36.72,-36.97,-37.03,-36.56,-35.78,-35.88,-36.0,-35.38,-34.31,-34.06,-34.16,-33.94,-32.5,-31.31,-30.78,-29.88,-28.5,-27.34,-27.66,-28.41,-28.72,-29.03,-30.38,-32.38,-33.72,-34.56,-35.62,-37.06,-38.03,-37.88,-37.59,-38.12,-37.62,-35.66,-33.12,-31.19,-29.12,-26.75,-25.16,-25.31,-27.16,-29.59,-32.19,-35.0,-37.84,-39.38,-39.25,-38.66,-38.62,-37.97,-36.72,-34.84,-34.0,-33.06,-32.0,-30.84,-30.88,-31.56,-32.38,-32.62,-32.84,-33.72,-34.0,-32.91,-31.62,-31.41,-30.88,-30.0,-29.28,-29.44,-30.44,-31.25,-31.97,-33.47,-35.84,-37.91,-39.31,-41.09,-43.25,-44.81,-44.94,-44.59,-44.62,-44.19,-42.78,-40.81,-39.75,-38.41,-37.25,-35.12,-34.0,-33.5,-32.81,-32.03,-32.16,-33.62,-35.09,-36.38,-37.78,-39.97,-42.28,-43.78,-44.5,-45.38,-45.72,-45.56,-44.47,-43.62,-44.0,-44.53,-44.59,-44.56,-44.97,-44.53,-42.75,-40.41,-38.19,-36.41,-34.94,-33.28,-33.0,1.41,2.97,4.5,5.72,6.59,7.41,7.66,7.44,6.75,5.44,3.38,0.84,-1.62,-3.59,-4.56,-4.66,-4.25,-3.31,-2.03,-1.34,-1.31,-1.16,-0.84,-0.59,0.12,1.03,2.09,3.0,3.19,3.03,2.84,2.56,2.22,2.28,2.5:-15.12,-16.22,-16.94,-16.84,-15.34,-12.91,-10.69,-8.66,-6.28,-3.5,-1.69,-0.59,0.69,2.25,3.56,3.88,3.97,4.59,5.31,4.97,4.22,4.16,3.97,2.75,1.25,0.19,-0.5,-1.62,-3.31,-4.78,-5.5,-5.66,-6.34,-6.62,-6.19,-5.38,-5.53,-5.88,-5.53,-5.12,-5.19,-6.12,-6.5,-6.78,-6.94,-7.88,-8.25,-8.03,-8.06,-9.41,-10.38,-10.78,-10.34,-9.81,-9.19,-7.44,-5.16,-3.25,-2.31,-1.12,0.16,0.47,-0.88,-2.66,-4.53,-6.28,-8.75,-10.84,-11.66,-11.69,-11.97,-12.97,-13.56,-13.34,-13.78,-14.66,-15.19,-15.06,-15.22,-16.44,-17.38,-17.47,-17.53,-18.09,-18.38,-18.53,-17.91,-17.94,-18.78,-19.25,-19.38,-19.94,-21.16,-21.47,-20.28,-18.62,-17.22,-15.81,-13.81,-11.81,-10.72,-10.0,-9.28,-7.59,-6.53,-6.16,-5.62,-4.31,-3.28,-4.03,-5.25,-6.12,-7.38,-9.28,-10.72,-11.59,-11.53,-11.81,-12.44,-12.97,-12.31,-11.91,-12.09,-11.69,-10.53,-9.84,-10.19,-10.97,-11.09,-11.16,-12.25,-13.31,-13.94,-13.44,-13.25,-13.16,-12.72,-11.62,-11.03,-12.0,-13.31,-13.72,-13.84,-15.16,-15.88,-15.53,-14.91,-15.22,-15.69,-16.12,-16.09,-16.59,-17.16,-17.5,-16.66,-16.34,-17.0,-18.22,-19.38,-20.47,-22.59,-24.22,-24.72,-24.06,-23.31,-21.84,-19.56,-16.0,-12.28,-9.78,-7.53,-5.47,-4.06,-3.88,-4.31,-4.41,-4.75,-6.88,-9.56,-12.22,-14.06,-16.28,-18.72,-20.41,-20.69,-20.91,-21.12,-21.25,-19.88,-18.31,-16.81,-15.72,-13.41,-10.69,-9.47,-9.06,-8.81,-9.03,-9.91,-12.06,-14.22,-14.97,-15.47,-16.22,-16.56,-15.78,-15.03,-15.53,-16.56,-17.22,-17.34,-17.94,-19.25,-20.59,-21.0,-22.06,-24.22,-25.66,-25.78,-26.16,-27.06,-28.56,-28.56,-28.66,-28.88,-28.78,-27.88,-26.25,-25.31,-25.06,-24.31,-22.62,-20.59,-18.72,-16.0,-11.62,-7.28,-3.59,-1.22,1.41,2.91,2.34,0.09,-2.88,-5.31,-8.91,-12.53,-15.09,-16.03,-16.34,-17.19,-18.25,-17.88,-17.75,-18.66,-19.78,-20.59,-20.78,-21.19,-21.75,-21.09,-18.69,-16.53,-14.56,-13.19,-11.56,-10.78,-11.72,-13.62,-14.53,-15.09,-16.97,-19.59,-21.38,-22.94,-24.66,-26.44,-27.19,-27.06,-27.75,-29.19,-31.03,-31.72,-32.31,-33.25,-34.56,-35.09,-34.91,-35.0,-35.41,-34.69,-33.41,-32.19,-31.34,-30.06,-27.66,-25.31,-23.62,-22.5,-20.72,-18.88,-17.59,-16.78,-15.88,-14.88,-14.81,-15.97,-17.28,-18.12,-19.09,-21.56,-23.47,-23.84,-23.88,-24.38,-24.56,-23.62,-22.59,-22.31,-22.47,-22.75,-23.03,-23.88,-26.0,-27.56,-28.22,-28.25,-28.59,-28.53,-26.56,-24.31,-23.19,-22.44,-21.16,-20.25,-19.88,-20.06,-20.09,-19.5,-19.12,-20.12,-21.0,-21.59,-22.28,-24.22,-26.06,-27.44,-28.59,-29.44,-30.03,-29.12,-27.47,-25.31,-23.44,-21.59,-18.72,-16.0,-14.47,-12.56,-10.28,-7.81,-6.69,-6.28,-6.41,-7.03,-8.84,-11.78,-13.97,-15.25,-15.94,-17.06,-17.5,-16.62,-16.03,-16.53,-16.88,-16.5,-15.97,-16.34,-16.88,-16.66,-16.12,-16.25,-17.19,-18.09,-18.56,-19.56,-21.31,-22.62,-22.94,-22.75,-23.12,-23.25,-22.66,-21.44,-20.78,-20.53,-19.56,-17.19,-15.28,-14.09,-12.84,-11.28,-10.53,-11.0,-11.59,-12.22,-12.38,-13.31,-14.34,-14.09,-12.84,-12.06,-11.12,-9.72,-8.0,-6.81,-7.19,-8.03,-9.12,-10.5,-12.53,-14.09,-14.59,-14.09,-14.59,-15.19,-15.28,-14.53,-14.31,-13.38,-12.25,-10.25,-8.25,-8.0,-7.88,-7.62,-7.94,-9.19,-10.53,-11.81,-13.22,-15.78,-18.97,-22.0,-24.03,-25.44,-26.75,-27.31,-26.69,-26.44,-26.84,-27.22,-26.31,-24.69,-23.28,-21.69,-19.81,-17.97,-17.53,-17.78,-18.69,-18.56,-19.0,-19.78,-20.25,-19.44,-18.47,-18.41,-18.25,-17.38,-16.56,-16.41,-17.06,-17.19,-17.06,-17.19,-17.22,-16.56,-14.69,-13.09,-12.78,-12.41,-12.0,-11.31,-10.91,-10.41,-9.97,-9.22,-10.38,-12.69,-15.44,-18.25,-21.56,-24.94,-27.81,-28.97,-29.16,-28.97,-28.03,-25.97,-23.19,-20.75,-18.75,-16.84,-14.69,-13.81,-14.12,-14.19,-13.19,-12.03,-10.59,-8.94,-6.22,-3.62,-1.88,-0.94,0.22,1.06,0.75,-0.28,-1.66,-2.66,-3.94,-6.09,-8.44,-9.97,-11.91,-14.38,-16.41,-17.06,-16.81,-16.22,-15.0,-12.97,-10.75,-9.03,-8.69,-9.12,-9.0,-9.12,-9.84,-10.06,-9.25,-8.31,-8.41,-9.06,-9.34,-10.28,-12.25,-16.0,-19.47,-22.62,-25.66,-28.47,-30.0,-30.12,-29.94,-30.16,-29.97,-28.28,-25.84,-23.28,-20.75,-17.5,-14.53,-12.62,-11.59,-10.62,-9.31,-8.31,-8.03,-8.41,-8.62,-9.22,-10.53,-12.75,-13.47,-14.0,-15.06,-15.97,-16.47,-16.88,-17.34,-18.22,-18.53,-17.94,-16.53,-15.81,-14.84,-13.06,-11.34,-10.62,-10.28,-9.34,-8.0,-7.56,-7.41,-7.72,-7.56,-8.06,-9.78,-11.91,-13.5,-15.56,-18.47,-21.53,-23.72,-24.88,-25.94,-26.78,-26.34,-25.34,-24.41,-24.56,-24.62,-24.5,-24.53,-25.06,-24.97,-24.03,-22.59,-21.5,-21.47,-20.94,-20.56,-20.78,-22.12,-22.81,-23.59,-24.0,-24.41,-24.38,-23.06,-21.34,-19.97,-19.06,-17.12,-15.06,-13.69,-12.53,-10.94,-9.72,-9.34,-10.59,-11.62,-11.94,-12.28,-12.97,-12.66,-12.06,-11.38,-12.0,-12.97,-13.62,-14.0,-14.84,-16.47,-17.56,-18.84,-20.66,-23.12,-24.91,-25.25,-24.72,-23.94,-22.47,-19.44,-16.25,-13.88,-11.97,-10.09,-8.56,-7.66,-7.34,-6.81,-6.25,-6.09,-7.5,-9.53,-11.47,-13.62,-16.59,-19.44,-21.12,-22.16,-23.44,-24.38,-24.78,-24.59,-24.16,-24.44,-24.56,-24.09,-23.72,-24.47,-25.34,-26.06,-26.0,-27.19,-28.16,-27.91,-27.16,-26.09,-25.09,-23.66,-21.34,-18.97,-17.72,-16.56,-15.38,-14.78,-15.69,-16.94,-17.28,-16.81,-17.16,-17.38,-17.31,-17.41,-17.91,-19.0,-19.75,-19.72,-20.0,-21.16,-22.22,-22.66,-22.62,-22.78,-22.41,-21.0,-18.97,-17.69,-17.5,-17.38,-17.31,-17.94,-19.16,-19.97,-19.88,-19.88,-21.06,-22.53,-22.94,-23.31,-24.16,-24.34,-23.28,-21.06,-19.31,-18.12,-17.38,-16.78,-17.16,-18.66,-20.09,-20.16,-19.72,-20.31,-20.78,-20.56,-20.38,-21.03,-21.66,-21.19,-19.66,-18.44,-17.31,-16.62,-15.88,-16.22,-18.12,-20.44,-21.19,-21.34,-21.25,-20.97,-19.5,-17.69,-16.59,-16.22,-15.53,-14.5,-14.69,-15.88,-17.0,-17.66,-18.53,-19.78,-21.25,-22.03,-22.47,-23.44,-24.56,-24.47,-23.31,-22.62,-22.5,-22.66,-22.59,-23.06,-24.19,-25.19,-25.06,-24.84,-25.53,-26.66,-26.66,-26.25,-26.59,-26.94,-26.44,-24.88,-23.88,-23.69,-23.12,-22.25,-22.56,-23.94,-25.78,-26.53,-27.25,-28.31,-28.94,-28.09,-26.66,-25.88,-25.62,-25.22,-24.31,-24.12,-24.59,-25.0,-24.5,-24.44,-25.31,-26.09,-26.19,-25.62,-25.38,-25.19,-24.22,-22.84,-22.22,-22.53,-23.12,-23.0,-23.25,-24.66,-25.56,-25.81,-26.19,-27.31,-29.03,-29.75,-30.16,-31.19,-32.0,-32.34,-31.5,-30.75,-30.94,-30.53,-28.97,-28.38,-28.84,-29.84,-30.38,-30.97,-32.59,-34.5,-34.88,-34.22,-33.88,-33.88,-32.97,-31.59,-30.59,-30.12,-29.56,-28.16,-26.59,-26.31,-27.12,-27.06,-27.5,-28.41,-29.53,-29.34,-27.59,-26.09,-25.31,-24.44,-23.75,-24.16,-26.25,-28.41,-29.88,-30.81,-32.22,-33.0,-32.56,-31.59,-31.12,-31.25,-30.75,-30.06,-30.06,-31.19,-32.19,-32.34,-32.75,-33.91,-34.59,-34.22,-33.28,-32.69,-32.69,-31.94,-31.09,-30.81,-31.38,-31.25,-30.75,-30.62,-31.41,-32.22,-32.03,-31.81,-32.19,-32.47,-31.66,-30.72,-30.25,-30.5,-30.34,-30.09,-30.97,-32.41,-33.41,-32.88,-31.69,-30.41,-28.59,-25.94,-23.62,-23.75,-25.03,-26.66,-28.81,-31.44,-33.84,-34.34,-33.94,-32.88,-32.31,-31.88,-31.0,-30.25,-30.66,-30.97,-30.44,-29.44,-29.66,-30.0,-29.5,-29.19,-28.97,-29.25,-28.97,-28.16,-27.62,-28.44,-29.06,-28.97,-28.81,-29.38,-30.19,-30.5,-30.84,-32.47,-34.19,-35.34,-35.72,-36.16,-37.25,-37.53,-37.22,-36.72,-36.97,-37.03,-36.56,-35.78,-35.88,-36.0,-35.38,-34.31,-34.06,-34.16,-33.94,-32.5,-31.31,-30.78,-29.88,-28.5,-27.34,-27.66,-28.41,-28.72,-29.03,-30.38,-32.38,-33.72,-34.56,-35.62,-37.06,-38.03,-37.88,-37.59,-38.12,-37.62,-35.66,-33.12,-31.19,-29.12,-26.75,-25.16,-25.31,-27.16,-29.59,-32.19,-35.0,-37.84,-39.38,-39.25,-38.66,-38.62,-37.97,-36.72,-34.84,-34.0,-33.06,-32.0,-30.84,-30.88,-31.56,-32.38,-32.62,-32.84,-33.72,-34.0,-32.91,-31.62,-31.41,-30.88,-30.0,-29.28,-29.44,-30.44,-31.25,-31.97,-33.47,-35.84,-37.91,-39.31,-41.09,-43.25,-44.81,-44.94,-44.59,-44.62,-44.19,-42.78,-40.81,-39.75,-38.41,-37.25,-35.12,-34.0,-33.5,-32.81,-32.03,-32.16,-33.62,-35.09,-36.38,-37.78,-39.97,-42.28,-43.78,-44.5,-45.38,-45.72,-45.56,-44.47,-43.62,-44.0,-44.53,-44.59,-44.56,-44.97,-44.53,-42.75,-40.41,-38.19,-36.41,-34.94,-33.28,-33.0,1.41,2.97,4.5,5.72,6.59,7.41,7.66,7.44,6.75,5.44,3.38,0.84,-1.62,-3.59,-4.56,-4.66,-4.25,-3.31,-2.03,-1.34,-1.31,-1.16,-0.84,-0.59,0.12,1.03,2.09,3.0,3.19,3.03,2.84,2.56,2.22,2.28,2.5,3.16,3.53,3.69,3.44,2.91,1.81,0.53:negativity
22.69,22.41,20.56,19.28,20.16,20.75,20.06,19.34,21.25,24.5,25.66,25.41,25.72,26.03,24.31,20.72,17.97,18.03,17.88,16.44,15.75,17.66,20.41,21.69,22.97,26.56,30.72,32.28,31.59,30.91,30.31,28.12,23.94,20.97,21.16,22.66,22.94,23.78,27.53,31.47,32.97,33.12,34.41,36.0,36.03,33.81,32.41,32.22,31.09,27.62,24.97,25.31,26.09,25.84,25.44,27.38,29.22,28.78,26.72,26.0,26.56,26.97,26.56,27.34,30.41,32.72,32.66,32.34,34.09,36.47,36.84,36.38,37.66,39.09,37.94,34.19,31.06,28.72,25.62,21.22,18.59,19.03,21.19,21.66,22.5,25.56,28.94,30.16,29.66,30.72,32.12,32.31,31.19,31.19,32.97,34.31,33.34,31.91,32.31,32.38,31.09,29.31,29.75,31.19,30.66,28.09,26.69,26.31,24.91,22.44,21.12,22.41,23.62,22.91,21.97,22.59,23.69,22.47,20.44,20.41,21.59,21.12,19.22,18.75,19.88,20.56,19.34,19.12,20.78,22.16,20.59,18.41,18.09,18.28,16.88,13.75,12.75,12.94,11.75,8.88,7.44,8.28,9.41,9.31,10.5,14.78,19.78,22.81,24.72,27.66,30.38,30.06,27.91,25.81,24.75,22.34,17.97,14.25,13.28,13.09,11.16,9.84,11.28,13.47,13.53,13.0,14.47,17.75,19.5,20.16,21.59,24.69,26.41,25.56,25.91,28.66,31.88,32.97,33.44,34.5,35.0,32.28,27.59,24.47,23.22,21.75,19.09,18.47,20.69,22.59,22.75,23.34,25.72,28.38,28.41,26.88,27.41,28.66,28.31,26.94,27.31,29.56,30.47,28.94,27.72,28.59,28.84,27.44,26.53,27.81,30.09,30.12,29.16,29.19,30.03,29.22,26.81,25.69,26.47,27.0,25.5,25.53,27.53,29.53,29.28,28.22,28.62,29.72,28.59,26.53,25.69,26.09,25.5,23.25,22.09,23.34,24.25,22.78,21.44,22.75,24.69,25.16,24.5,25.31,26.84,26.0,23.94,23.19,24.72,25.5,24.62,23.94,25.25,25.78,23.56,21.22,21.31,22.16,21.06,19.5,19.66,21.91,22.78,22.75,23.69,26.59,29.0,28.41,27.72,28.81,29.47,27.69,25.62,26.5,29.66,31.44,32.38,34.56,37.75,38.72,36.94,34.59,33.06,29.59,23.16,16.97,14.22,12.88,10.62,8.91,9.72,12.06,13.12,13.91,16.22,20.25,22.47,21.91,20.59,21.34,21.59,19.66,17.88,18.78,21.0,21.41,21.25,22.78,25.09,25.19,22.84,21.0,20.75,19.59,15.97,12.38,11.5,11.25,9.38,7.84,9.53,12.47,14.09,14.5,16.38,19.22,20.34,18.19,16.25,16.0,15.88,14.34,13.28,15.72,19.28,20.72,21.25,23.31,26.59,27.66,26.69,26.25,26.72,25.59,21.91,18.38,17.56,17.0,15.06,13.56,14.91,17.16,17.53,17.0,18.25,20.5,21.12,19.97,20.22,22.28,24.69,25.47,26.56,30.03,32.78,32.25,29.75,28.44,27.44,24.28,20.53,18.81,19.56,19.72,17.53,16.31,16.44,15.47,12.44,8.97,8.28,8.0,6.16,3.62,3.53,5.28,5.69,5.47,6.84,10.88,14.28,16.19,18.62,23.12,27.94,30.41,32.19,35.38,38.0,37.81,35.06,33.12,32.69,30.78,27.56,25.66,26.28,26.03,23.34,21.12,20.97,20.88,19.12,16.75,17.25,18.88,19.19,18.38,19.66,22.44,24.0,23.19,22.34,22.62,21.56,18.12,13.97,12.5,11.47,8.53,5.31,4.44,5.0,4.94,3.56,3.69,5.97,7.31,6.78,7.16,10.06,13.16,14.25,15.31,18.44,21.59,22.69,22.72,24.16,26.25,27.12,25.31,23.88,24.25,24.28,22.09,20.47,21.28,22.06,20.06,17.66,17.19,17.44,16.34,14.12,13.5,14.56,14.97,13.41,12.84,14.38,15.88,15.94,16.34,19.41,22.84,24.03,23.88,24.56,25.75,24.75,21.28,18.78,17.84,16.62,13.81,11.84,12.97,14.12,13.53,13.03,14.75,17.28,18.44,19.31,22.47,27.0,29.97,30.09,29.75,29.94,28.91,25.16,22.19,21.62,21.62,19.47,16.72,16.12,16.84,16.22,15.34,16.38,19.41,21.59,21.03,20.22,20.75,20.69,18.0,15.72,16.03,17.88,18.03,17.72,18.81,20.78,21.0,19.38,18.97,20.62,21.84,21.06,20.84,22.47,24.06,23.19,22.31,23.28,25.0,24.66,23.12,23.06,23.72,23.38,21.34,20.19,21.09,21.88,20.75,19.94,21.5,23.5,23.25,22.28,23.12,24.75,24.72,23.47,23.72,25.47,25.44,23.19,21.06,20.59,20.09,17.53,15.94,17.06,19.22,19.75,19.53,20.81,23.16,23.16,21.53,20.5,20.59,19.81,17.12,14.88,15.16,16.31,15.72,15.56,17.78,20.97,22.19,22.59,23.81,26.62,28.34,28.34,28.91,30.91,32.06,30.97,29.84,30.72,31.94,30.88,29.25,29.53,30.69,30.38,28.88,28.47,29.72,29.59,27.78,26.66,27.59,28.16,26.5,24.91,25.38,26.19,25.72,24.91,25.28,27.47,27.5,26.09,25.31,26.34,26.81,26.09,25.38,26.5,27.97,26.62,24.75,24.5,25.47,24.22,22.66,22.03,23.03,22.59,20.16,18.28,18.0,17.62,15.5,14.12,15.06,16.81,16.34,14.78,14.59,15.03,14.12,12.0,11.28,12.62,13.53,12.06,11.25,12.41,13.47,12.75,11.94,13.97,16.03,16.44,15.56,15.72,17.25,17.44,16.75,16.66,18.88,20.34,19.59,18.41,18.91,19.56,18.0,16.41,17.25,19.5,19.88,19.31,19.59,21.22,21.75,20.31,19.59,20.56,20.69,18.31,15.69,15.56,15.75,14.31,12.69,13.16,15.31,16.28,16.12,16.97,18.84,19.16,17.28,15.94,17.03,18.06,17.0,15.22,15.22,15.19,13.69,11.5,11.84,13.94,15.06,14.72,15.16,17.0,18.25,17.44,16.97,19.0,21.31,21.66,21.03,22.06,22.78,21.47,18.78,17.69,18.69,18.94,17.59,16.41,17.0,16.75,14.59,12.81,13.34,15.12,15.16,14.09,15.09,17.19,18.06,17.38,18.25,20.25,20.88,18.66,16.25,16.5,16.62,15.41,14.28,15.56,17.44,17.19,15.69,15.94,17.19,16.53,13.97,12.31,12.84,12.94,11.28,9.91,10.72,11.5,10.97,10.25,11.66,14.78,16.38,16.66,18.84,22.34,24.72,25.09,25.78,28.0,30.0,29.62,29.34,31.12,33.12,33.09,31.72,31.91,33.25,33.72,32.5,33.06,35.41,36.78,35.88,35.38,36.78,38.12,37.56,36.53,37.88,39.5,39.16,37.09,36.38,36.25,34.88,31.66,28.59,27.53,25.31,21.34,18.5,18.88,20.22,20.12,19.34,19.78,21.03,20.16,17.59,16.75,17.5,17.19,15.19,14.38,15.53,16.34,14.66,13.0,13.28,14.56,13.81,12.5,12.84,14.34,14.5,12.91,12.84,14.31,14.84,13.25,11.81,12.53,13.47,12.22,10.5,11.22,12.91,12.56,10.94,10.59,11.0,10.44,8.12,7.25,8.84,10.31,9.66,9.62,11.72,14.22,14.16,13.75,14.66,16.56,16.97,15.94,16.41,18.44,19.62,18.97,19.28,21.59,23.34,22.28,20.72,20.62,21.19,19.28,16.84,16.06,16.84,16.78,15.34,15.91,18.22,20.69,20.53,21.28,23.97,26.53,26.44,25.47,26.12,27.41,26.91,25.5,25.69,27.22,27.03,24.72,22.62,22.0,20.62,16.94,14.09,14.25,15.59,16.03,16.62,18.94,22.5,23.91,24.12,25.81,29.75,32.22,32.88,33.19,34.34,34.69,31.25,27.56,25.94,25.19,22.66,20.25,20.03,21.66,21.88,20.84,21.06,23.0,23.94,22.41,21.56,22.59,23.66,22.72,21.62,22.09,23.69,23.38,21.69,22.09,24.25,25.19,24.5,24.31,26.5,27.34,25.53,22.88,22.28,21.44,17.78,14.09,12.62,12.62,11.78,10.5,11.03,14.16,16.22,15.81,15.19,16.19,16.66,14.78,13.28,14.62,17.66,18.5,18.78,20.34,23.06,24.03,23.47,24.19,26.31,26.91,24.22,21.97,21.28,20.88,18.66,16.91,17.75,19.47,19.25,17.59,17.12,17.94,17.44,14.72,12.91,14.06,15.09,14.88,14.97,18.19,21.38,21.91,21.34,22.84,24.88,24.41,22.38,20.78,20.69,19.09,15.88,13.12,13.28,13.12,11.56,10.28,12.09,15.19,16.72,18.0,20.75,24.69,25.94,25.41,25.0,26.44,26.88,24.84,23.12,23.53,23.69,21.47,19.22,19.16,20.12,18.75,16.09,14.75,14.47,13.03,10.09,9.0,10.44,11.53,10.97,10.75,14.03,17.56,19.31,20.84,23.69,26.62,27.0,25.41,24.69,25.44,24.22,21.09,18.56,18.72,18.72,17.59,16.91,18.78,21.53,21.69,20.94,21.66,23.19,22.25,19.16,16.78,16.16,15.34,13.41,12.66,15.66,18.78,19.47,19.69,21.66,23.84,23.72,22.03,22.16,23.22,22.78,19.88,18.06,18.25,17.88,15.59,13.81,14.66,15.78,14.69,13.06,13.72,15.5,15.56,14.59,15.38,17.56,18.38,17.53,17.03,19.0,19.69,18.09,16.03,16.06,16.69,15.09,12.84,12.38,13.0,12.03,10.41,10.72,13.41,15.22,14.78,14.28,15.44,15.78,13.41,10.66,10.78,11.53,11.41,11.03,12.75,15.91,17.59,16.91,17.22,19.25,20.69,19.81,19.81,22.12,24.25,23.97,23.09,24.31,26.19,26.31:19.34,21.25,24.5,25.66,25.41,25.72,26.03,24.31,20.72,17.97,18.03,17.88,16.44,15.75,17.66,20.41,21.69,22.97,26.56,30.72,32.28,31.59,30.91,30.31,28.12,23.94,20.97,21.16,22.66,22.94,23.78,27.53,31.47,32.97,33.12,34.41,36.0,36.03,33.81,32.41,32.22,31.09,27.62,24.97,25.31,26.09,25.84,25.44,27.38,29.22,28.78,26.72,26.0,26.56,26.97,26.56,27.34,30.41,32.72,32.66,32.34,34.09,36.47,36.84,36.38,37.66,39.09,37.94,34.19,31.06,28.72,25.62,21.22,18.59,19.03,21.19,21.66,22.5,25.56,28.94,30.16,29.66,30.72,32.12,32.31,31.19,31.19,32.97,34.31,33.34,31.91,32.31,32.38,31.09,29.31,29.75,31.19,30.66,28.09,26.69,26.31,24.91,22.44,21.12,22.41,23.62,22.91,21.97,22.59,23.69,22.47,20.44,20.41,21.59,21.12,19.22,18.75,19.88,20.56,19.34,19.12,20.78,22.16,20.59,18.41,18.09,18.28,16.88,13.75,12.75,12.94,11.75,8.88,7.44,8.28,9.41,9.31,10.5,14.78,19.78,22.81,24.72,27.66,30.38,30.06,27.91,25.81,24.75,22.34,17.97,14.25,13.28,13.09,11.16,9.84,11.28,13.47,13.53,13.0,14.47,17.75,19.5,20.16,21.59,24.69,26.41,25.56,25.91,28.66,31.88,32.97,33.44,34.5,35.0,32.28,27.59,24.47,23.22,21.75,19.09,18.47,20.69,22.59,22.75,23.34,25.72,28.38,28.41,26.88,27.41,28.66,28.31,26.94,27.31,29.56,30.47,28.94,27.72,28.59,28.84,27.44,26.53,27.81,30.09,30.12,29.16,29.19,30.03,29.22,26.81,25.69,26.47,27.0,25.5,25.53,27.53,29.53,29.28,28.22,28.62,29.72,28.59,26.53,25.69,26.09,25.5,23.25,22.09,23.34,24.25,22.78,21.44,22.75,24.69,25.16,24.5,25.31,26.84,26.0,23.94,23.19,24.72,25.5,24.62,23.94,25.25,25.78,23.56,21.22,21.31,22.16,21.06,19.5,19.66,21.91,22.78,22.75,23.69,26.59,29.0,28.41,27.72,28.81,29.47,27.69,25.62,26.5,29.66,31.44,32.38,34.56,37.75,38.72,36.94,34.59,33.06,29.59,23.16,16.97,14.22,12.88,10.62,8.91,9.72,12.06,13.12,13.91,16.22,20.25,22.47,21.91,20.59,21.34,21.59,19.66,17.88,18.78,21.0,21.41,21.25,22.78,25.09,25.19,22.84,21.0,20.75,19.59,15.97,12.38,11.5,11.25,9.38,7.84,9.53,12.47,14.09,14.5,16.38,19.22,20.34,18.19,16.25,16.0,15.88,14.34,13.28,15.72,19.28,20.72,21.25,23.31,26.59,27.66,26.69,26.25,26.72,25.59,21.91,18.38,17.56,17.0,15.06,13.56,14.91,17.16,17.53,17.0,18.25,20.5,21.12,19.97,20.22,22.28,24.69,25.47,26.56,30.03,32.78,32.25,29.75,28.44,27.44,24.28,20.53,18.81,19.56,19.72,17.53,16.31,16.44,15.47,12.44,8.97,8.28,8.0,6.16,3.62,3.53,5.28,5.69,5.47,6.84,10.88,14.28,16.19,18.62,23.12,27.94,30.41,32.19,35.38,38.0,37.81,35.06,33.12,32.69,30.78,27.56,25.66,26.28,26.03,23.34,21.12,20.97,20.88,19.12,16.75,17.25,18.88,19.19,18.38,19.66,22.44,24.0,23.19,22.34,22.62,21.56,18.12,13.97,12.5,11.47,8.53,5.31,4.44,5.0,4.94,3.56,3.69,5.97,7.31,6.78,7.16,10.06,13.16,14.25,15.31,18.44,21.59,22.69,22.72,24.16,26.25,27.12,25.31,23.88,24.25,24.28,22.09,20.47,21.28,22.06,20.06,17.66,17.19,17.44,16.34,14.12,13.5,14.56,14.97,13.41,12.84,14.38,15.88,15.94,16.34,19.41,22.84,24.03,23.88,24.56,25.75,24.75,21.28,18.78,17.84,16.62,13.81,11.84,12.97,14.12,13.53,13.03,14.75,17.28,18.44,19.31,22.47,27.0,29.97,30.09,29.75,29.94,28.91,25.16,22.19,21.62,21.62,19.47,16.72,16.12,16.84,16.22,15.34,16.38,19.41,21.59,21.03,20.22,20.75,20.69,18.0,15.72,16.03,17.88,18.03,17.72,18.81,20.78,21.0,19.38,18.97,20.62,21.84,21.06,20.84,22.47,24.06,23.19,22.31,23.28,25.0,24.66,23.12,23.06,23.72,23.38,21.34,20.19,21.09,21.88,20.75,19.94,21.5,23.5,23.25,22.28,23.12,24.75,24.72,23.47,23.72,25.47,25.44,23.19,21.06,20.59,20.09,17.53,15.94,17.06,19.22,19.75,19.53,20.81,23.16,23.16,21.53,20.5,20.59,19.81,17.12,14.88,15.16,16.31,15.72,15.56,17.78,20.97,22.19,22.59,23.81,26.62,28.34,28.34,28.91,30.91,32.06,30.97,29.84,30.72,31.94,30.88,29.25,29.53,30.69,30.38,28.88,28.47,29.72,29.59,27.78,26.66,27.59,28.16,26.5,24.91,25.38,26.19,25.72,24.91,25.28,27.47,27.5,26.09,25.31,26.34,26.81,26.09,25.38,26.5,27.97,26.62,24.75,24.5,25.47,24.22,22.66,22.03,23.03,22.59,20.16,18.28,18.0,17.62,15.5,14.12,15.06,16.81,16.34,14.78,14.59,15.03,14.12,12.0,11.28,12.62,13.53,12.06,11.25,12.41,13.47,12.75,11.94,13.97,16.03,16.44,15.56,15.72,17.25,17.44,16.75,16.66,18.88,20.34,19.59,18.41,18.91,19.56,18.0,16.41,17.25,19.5,19.88,19.31,19.59,21.22,21.75,20.31,19.59,20.56,20.69,18.31,15.69,15.56,15.75,14.31,12.69,13.16,15.31,16.28,16.12,16.97,18.84,19.16,17.28,15.94,17.03,18.06,17.0,15.22,15.22,15.19,13.69,11.5,11.84,13.94,15.06,14.72,15.16,17.0,18.25,17.44,16.97,19.0,21.31,21.66,21.03,22.06,22.78,21.47,18.78,17.69,18.69,18.94,17.59,16.41,17.0,16.75,14.59,12.81,13.34,15.12,15.16,14.09,15.09,17.19,18.06,17.38,18.25,20.25,20.88,18.66,16.25,16.5,16.62,15.41,14.28,15.56,17.44,17.19,15.69,15.94,17.19,16.53,13.97,12.31,12.84,12.94,11.28,9.91,10.72,11.5,10.97,10.25,11.66,14.78,16.38,16.66,18.84,22.34,24.72,25.09,25.78,28.0,30.0,29.62,29.34,31.12,33.12,33.09,31.72,31.91,33.25,33.72,32.5,33.06,35.41,36.78,35.88,35.38,36.78,38.12,37.56,36.53,37.88,39.5,39.16,37.09,36.38,36.25,34.88,31.66,28.59,27.53,25.31,21.34,18.5,18.88,20.22,20.12,19.34,19.78,21.03,20.16,17.59,16.75,17.5,17.19,15.19,14.38,15.53,16.34,14.66,13.0,13.28,14.56,13.81,12.5,12.84,14.34,14.5,12.91,12.84,14.31,14.84,13.25,11.81,12.53,13.47,12.22,10.5,11.22,12.91,12.56,10.94,10.59,11.0,10.44,8.12,7.25,8.84,10.31,9.66,9.62,11.72,14.22,14.16,13.75,14.66,16.56,16.97,15.94,16.41,18.44,19.62,18.97,19.28,21.59,23.34,22.28,20.72,20.62,21.19,19.28,16.84,16.06,16.84,16.78,15.34,15.91,18.22,20.69,20.53,21.28,23.97,26.53,26.44,25.47,26.12,27.41,26.91,25.5,25.69,27.22,27.03,24.72,22.62,22.0,20.62,16.94,14.09,14.25,15.59,16.03,16.62,18.94,22.5,23.91,24.12,25.81,29.75,32.22,32.88,33.19,34.34,34.69,31.25,27.56,25.94,25.19,22.66,20.25,20.03,21.66,21.88,20.84,21.06,23.0,23.94,22.41,21.56,22.59,23.66,22.72,21.62,22.09,23.69,23.38,21.69,22.09,24.25,25.19,24.5,24.31,26.5,27.34,25.53,22.88,22.28,21.44,17.78,14.09,12.62,12.62,11.78,10.5,11.03,14.16,16.22,15.81,15.19,16.19,16.66,14.78,13.28,14.62,17.66,18.5,18.78,20.34,23.06,24.03,23.47,24.19,26.31,26.91,24.22,21.97,21.28,20.88,18.66,16.91,17.75,19.47,19.25,17.59,17.12,17.94,17.44,14.72,12.91,14.06,15.09,14.88,14.97,18.19,21.38,21.91,21.34,22.84,24.88,24.41,22.38,20.78,20.69,19.09,15.88,13.12,13.28,13.12,11.56,10.28,12.09,15.19,16.72,18.0,20.75,24.69,25.94,25.41,25.0,26.44,26.88,24.84,23.12,23.53,23.69,21.47,19.22,19.16,20.12,18.75,16.09,14.75,14.47,13.03,10.09,9.0,10.44,11.53,10.97,10.75,14.03,17.56,19.31,20.84,23.69,26.62,27.0,25.41,24.69,25.44,24.22,21.09,18.56,18.72,18.72,17.59,16.91,18.78,21.53,21.69,20.94,21.66,23.19,22.25,19.16,16.78,16.16,15.34,13.41,12.66,15.66,18.78,19.47,19.69,21.66,23.84,23.72,22.03,22.16,23.22,22.78,19.88,18.06,18.25,17.88,15.59,13.81,14.66,15.78,14.69,13.06,13.72,15.5,15.56,14.59,15.38,17.56,18.38,17.53,17.03,19.0,19.69,18.09,16.03,16.06,16.69,15.09,12.84,12.38,13.0,12.03,10.41,10.72,13.41,15.22,14.78,14.28,15.44,15.78,13.41,10.66,10.78,11.53,11.41,11.03,12.75,15.91,17.59,16.91,17.22,19.25,20.69,19.81,19.81,22.12,24.25,23.97,23.09,24.31,26.19,26.31,31.41,31.41,30.38,29.69,30.03,30.03,29.38:24.31,20.72,17.97,18.03,17.88,16.44,15.75,17.66,20.41,21.69,22.97,26.56,30.72,32.28,31.59,30.91,30.31,28.12,23.94,20.97,21.16,22.66,22.94,23.78,27.53,31.47,32.97,33.12,34.41,36.0,36.03,33.81,32.41,32.22,31.09,27.62,24.97,25.31,26.09,25.84,25.44,27.38,29.22,28.78,26.72,26.0,26.56,26.97,26.56,27.34,30.41,32.72,32.66,32.34,34.09,36.47,36.84,36.38,37.66,39.09,37.94,34.19,31.06,28.72,25.62,21.22,18.59,19.03,21.19,21.66,22.5,25.56,28.94,30.16,29.66,30.72,32.12,32.31,31.19,31.19,32.97,34.31,33.34,31.91,32.31,32.38,31.09,29.31,29.75,31.19,30.66,28.09,26.69,26.31,24.91,22.44,21.12,22.41,23.62,22.91,21.97,22.59,23.69,22.47,20.44,20.41,21.59,21.12,19.22,18.75,19.88,20.56,19.34,19.12,20.78,22.16,20.59,18.41,18.09,18.28,16.88,13.75,12.75,12.94,11.75,8.88,7.44,8.28,9.41,9.31,10.5,14.78,19.78,22.81,24.72,27.66,30.38,30.06,27.91,25.81,24.75,22.34,17.97,14.25,13.28,13.09,11.16,9.84,11.28,13.47,13.53,13.0,14.47,17.75,19.5,20.16,21.59,24.69,26.41,25.56,25.91,28.66,31.88,32.97,33.44,34.5,35.0,32.28,27.59,24.47,23.22,21.75,19.09,18.47,20.69,22.59,22.75,23.34,25.72,28.38,28.41,26.88,27.41,28.66,28.31,26.94,27.31,29.56,30.47,28.94,27.72,28.59,28.84,27.44,26.53,27.81,30.09,30.12,29.16,29.19,30.03,29.22,26.81,25.69,26.47,27.0,25.5,25.53,27.53,29.53,29.28,28.22,28.62,29.72,28.59,26.53,25.69,26.09,25.5,23.25,22.09,23.34,24.25,22.78,21.44,22.75,24.69,25.16,24.5,25.31,26.84,26.0,23.94,23.19,24.72,25.5,24.62,23.94,25.25,25.78,23.56,21.22,21.31,22.16,21.06,19.5,19.66,21.91,22.78,22.75,23.69,26.59,29.0,28.41,27.72,28.81,29.47,27.69,25.62,26.5,29.66,31.44,32.38,34.56,37.75,38.72,36.94,34.59,33.06,29.59,23.16,16.97,14.22,12.88,10.62,8.91,9.72,12.06,13.12,13.91,16.22,20.25,22.47,21.91,20.59,21.34,21.59,19.66,17.88,18.78,21.0,21.41,21.25,22.78,25.09,25.19,22.84,21.0,20.75,19.59,15.97,12.38,11.5,11.25,9.38,7.84,9.53,12.47,14.09,14.5,16.38,19.22,20.34,18.19,16.25,16.0,15.88,14.34,13.28,15.72,19.28,20.72,21.25,23.31,26.59,27.66,26.69,26.25,26.72,25.59,21.91,18.38,17.56,17.0,15.06,13.56,14.91,17.16,17.53,17.0,18.25,20.5,21.12,19.97,20.22,22.28,24.69,25.47,26.56,30.03,32.78,32.25,29.75,28.44,27.44,24.28,20.53,18.81,19.56,19.72,17.53,16.31,16.44,15.47,12.44,8.97,8.28,8.0,6.16,3.62,3.53,5.28,5.69,5.47,6.84,10.88,14.28,16.19,18.62,23.12,27.94,30.41,32.19,35.38,38.0,37.81,35.06,33.12,32.69,30.78,27.56,25.66,26.28,26.03,23.34,21.12,20.97,20.88,19.12,16.75,17.25,18.88,19.19,18.38,19.66,22.44,24.0,23.19,22.34,22.62,21.56,18.12,13.97,12.5,11.47,8.53,5.31,4.44,5.0,4.94,3.56,3.69,5.97,7.31,6.78,7.16,10.06,13.16,14.25,15.31,18.44,21.59,22.69,22.72,24.16,26.25,27.12,25.31,23.88,24.25,24.28,22.09,20.47,21.28,22.06,20.06,17.66,17.19,17.44,16.34,14.12,13.5,14.56,14.97,13.41,12.84,14.38,15.88,15.94,16.34,19.41,22.84,24.03,23.88,24.56,25.75,24.75,21.28,18.78,17.84,16.62,13.81,11.84,12.97,14.12,13.53,13.03,14.75,17.28,18.44,19.31,22.47,27.0,29.97,30.09,29.75,29.94,28.91,25.16,22.19,21.62,21.62,19.47,16.72,16.12,16.84,16.22,15.34,16.38,19.41,21.59,21.03,20.22,20.75,20.69,18.0,15.72,16.03,17.88,18.03,17.72,18.81,20.78,21.0,19.38,18.97,20.62,21.84,21.06,20.84,22.47,24.06,23.19,22.31,23.28,25.0,24.66,23.12,23.06,23.72,23.38,21.34,20.19,21.09,21.88,20.75,19.94,21.5,23.5,23.25,22.28,23.12,24.75,24.72,23.47,23.72,25.47,25.44,23.19,21.06,20.59,20.09,17.53,15.94,17.06,19.22,19.75,19.53,20.81,23.16,23.16,21.53,20.5,20.59,19.81,17.12,14.88,15.16,16.31,15.72,15.56,17.78,20.97,22.19,22.59,23.81,26.62,28.34,28.34,28.91,30.91,32.06,30.97,29.84,30.72,31.94,30.88,29.25,29.53,30.69,30.38,28.88,28.47,29.72,29.59,27.78,26.66,27.59,28.16,26.5,24.91,25.38,26.19,25.72,24.91,25.28,27.47,27.5,26.09,25.31,26.34,26.81,26.09,25.38,26.5,27.97,26.62,24.75,24.5,25.47,24.22,22.66,22.03,23.03,22.59,20.16,18.28,18.0,17.62,15.5,14.12,15.06,16.81,16.34,14.78,14.59,15.03,14.12,12.0,11.28,12.62,13.53,12.06,11.25,12.41,13.47,12.75,11.94,13.97,16.03,16.44,15.56,15.72,17.25,17.44,16.75,16.66,18.88,20.34,19.59,18.41,18.91,19.56,18.0,16.41,17.25,19.5,19.88,19.31,19.59,21.22,21.75,20.31,19.59,20.56,20.69,18.31,15.69,15.56,15.75,14.31,12.69,13.16,15.31,16.28,16.12,16.97,18.84,19.16,17.28,15.94,17.03,18.06,17.0,15.22,15.22,15.19,13.69,11.5,11.84,13.94,15.06,14.72,15.16,17.0,18.25,17.44,16.97,19.0,21.31,21.66,21.03,22.06,22.78,21.47,18.78,17.69,18.69,18.94,17.59,16.41,17.0,16.75,14.59,12.81,13.34,15.12,15.16,14.09,15.09,17.19,18.06,17.38,18.25,20.25,20.88,18.66,16.25,16.5,16.62,15.41,14.28,15.56,17.44,17.19,15.69,15.94,17.19,16.53,13.97,12.31,12.84,12.94,11.28,9.91,10.72,11.5,10.97,10.25,11.66,14.78,16.38,16.66,18.84,22.34,24.72,25.09,25.78,28.0,30.0,29.62,29.34,31.12,33.12,33.09,31.72,31.91,33.25,33.72,32.5,33.06,35.41,36.78,35.88,35.38,36.78,38.12,37.56,36.53,37.88,39.5,39.16,37.09,36.38,36.25,34.88,31.66,28.59,27.53,25.31,21.34,18.5,18.88,20.22,20.12,19.34,19.78,21.03,20.16,17.59,16.75,17.5,17.19,15.19,14.38,15.53,16.34,14.66,13.0,13.28,14.56,13.81,12.5,12.84,14.34,14.5,12.91,12.84,14.31,14.84,13.25,11.81,12.53,13.47,12.22,10.5,11.22,12.91,12.56,10.94,10.59,11.0,10.44,8.12,7.25,8.84,10.31,9.66,9.62,11.72,14.22,14.16,13.75,14.66,16.56,16.97,15.94,16.41,18.44,19.62,18.97,19.28,21.59,23.34,22.28,20.72,20.62,21.19,19.28,16.84,16.06,16.84,16.78,15.34,15.91,18.22,20.69,20.53,21.28,23.97,26.53,26.44,25.47,26.12,27.41,26.91,25.5,25.69,27.22,27.03,24.72,22.62,22.0,20.62,16.94,14.09,14.25,15.59,16.03,16.62,18.94,22.5,23.91,24.12,25.81,29.75,32.22,32.88,33.19,34.34,34.69,31.25,27.56,25.94,25.19,22.66,20.25,20.03,21.66,21.88,20.84,21.06,23.0,23.94,22.41,21.56,22.59,23.66,22.72,21.62,22.09,23.69,23.38,21.69,22.09,24.25,25.19,24.5,24.31,26.5,27.34,25.53,22.88,22.28,21.44,17.78,14.09,12.62,12.62,11.78,10.5,11.03,14.16,16.22,15.81,15.19,16.19,16.66,14.78,13.28,14.62,17.66,18.5,18.78,20.34,23.06,24.03,23.47,24.19,26.31,26.91,24.22,21.97,21.28,20.88,18.66,16.91,17.75,19.47,19.25,17.59,17.12,17.94,17.44,14.72,12.91,14.06,15.09,14.88,14.97,18.19,21.38,21.91,21.34,22.84,24.88,24.41,22.38,20.78,20.69,19.09,15.88,13.12,13.28,13.12,11.56,10.28,12.09,15.19,16.72,18.0,20.75,24.69,25.94,25.41,25.0,26.44,26.88,24.84,23.12,23.53,23.69,21.47,19.22,19.16,20.12,18.75,16.09,14.75,14.47,13.03,10.09,9.0,10.44,11.53,10.97,10.75,14.03,17.56,19.31,20.84,23.69,26.62,27.0,25.41,24.69,25.44,24.22,21.09,18.56,18.72,18.72,17.59,16.91,18.78,21.53,21.69,20.94,21.66,23.19,22.25,19.16,16.78,16.16,15.34,13.41,12.66,15.66,18.78,19.47,19.69,21.66,23.84,23.72,22.03,22.16,23.22,22.78,19.88,18.06,18.25,17.88,15.59,13.81,14.66,15.78,14.69,13.06,13.72,15.5,15.56,14.59,15.38,17.56,18.38,17.53,17.03,19.0,19.69,18.09,16.03,16.06,16.69,15.09,12.84,12.38,13.0,12.03,10.41,10.72,13.41,15.22,14.78,14.28,15.44,15.78,13.41,10.66,10.78,11.53,11.41,11.03,12.75,15.91,17.59,16.91,17.22,19.25,20.69,19.81,19.81,22.12,24.25,23.97,23.09,24.31,26.19,26.31,31.41,31.41,30.38,29.69,30.03,30.03,29.38,28.06,29.25,31.12,31.94,31.94,32.53,32.91:17.66,20.41,21.69,22.97,26.56,30.72,32.28,31.59,30.91,30.31,28.12,23.94,20.97,21.16,22.66,22.94,23.78,27.53,31.47,32.97,33.12,34.41,36.0,36.03,33.81,32.41,32.22,31.09,27.62,24.97,25.31,26.09,25.84,25.44,27.38,29.22,28.78,26.72,26.0,26.56,26.97,26.56,27.34,30.41,32.72,32.66,32.34,34.09,36.47,36.84,36.38,37.66,39.09,37.94,34.19,31.06,28.72,25.62,21.22,18.59,19.03,21.19,21.66,22.5,25.56,28.94,30.16,29.66,30.72,32.12,32.31,31.19,31.19,32.97,34.31,33.34,31.91,32.31,32.38,31.09,29.31,29.75,31.19,30.66,28.09,26.69,26.31,24.91,22.44,21.12,22.41,23.62,22.91,21.97,22.59,23.69,22.47,20.44,20.41,21.59,21.12,19.22,18.75,19.88,20.56,19.34,19.12,20.78,22.16,20.59,18.41,18.09,18.28,16.88,13.75,12.75,12.94,11.75,8.88,7.44,8.28,9.41,9.31,10.5,14.78,19.78,22.81,24.72,27.66,30.38,30.06,27.91,25.81,24.75,22.34,17.97,14.25,13.28,13.09,11.16,9.84,11.28,13.47,13.53,13.0,14.47,17.75,19.5,20.16,21.59,24.69,26.41,25.56,25.91,28.66,31.88,32.97,33.44,34.5,35.0,32.28,27.59,24.47,23.22,21.75,19.09,18.47,20.69,22.59,22.75,23.34,25.72,28.38,28.41,26.88,27.41,28.66,28.31,26.94,27.31,29.56,30.47,28.94,27.72,28.59,28.84,27.44,26.53,27.81,30.09,30.12,29.16,29.19,30.03,29.22,26.81,25.69,26.47,27.0,25.5,25.53,27.53,29.53,29.28,28.22,28.62,29.72,28.59,26.53,25.69,26.09,25.5,23.25,22.09,23.34,24.25,22.78,21.44,22.75,24.69,25.16,24.5,25.31,26.84,26.0,23.94,23.19,24.72,25.5,24.62,23.94,25.25,25.78,23.56,21.22,21.31,22.16,21.06,19.5,19.66,21.91,22.78,22.75,23.69,26.59,29.0,28.41,27.72,28.81,29.47,27.69,25.62,26.5,29.66,31.44,32.38,34.56,37.75,38.72,36.94,34.59,33.06,29.59,23.16,16.97,14.22,12.88,10.62,8.91,9.72,12.06,13.12,13.91,16.22,20.25,22.47,21.91,20.59,21.34,21.59,19.66,17.88,18.78,21.0,21.41,21.25,22.78,25.09,25.19,22.84,21.0,20.75,19.59,15.97,12.38,11.5,11.25,9.38,7.84,9.53,12.47,14.09,14.5,16.38,19.22,20.34,18.19,16.25,16.0,15.88,14.34,13.28,15.72,19.28,20.72,21.25,23.31,26.59,27.66,26.69,26.25,26.72,25.59,21.91,18.38,17.56,17.0,15.06,13.56,14.91,17.16,17.53,17.0,18.25,20.5,21.12,19.97,20.22,22.28,24.69,25.47,26.56,30.03,32.78,32.25,29.75,28.44,27.44,24.28,20.53,18.81,19.56,19.72,17.53,16.31,16.44,15.47,12.44,8.97,8.28,8.0,6.16,3.62,3.53,5.28,5.69,5.47,6.84,10.88,14.28,16.19,18.62,23.12,27.94,30.41,32.19,35.38,38.0,37.81,35.06,33.12,32.69,30.78,27.56,25.66,26.28,26.03,23.34,21.12,20.97,20.88,19.12,16.75,17.25,18.88,19.19,18.38,19.66,22.44,24.0,23.19,22.34,22.62,21.56,18.12,13.97,12.5,11.47,8.53,5.31,4.44,5.0,4.94,3.56,3.69,5.97,7.31,6.78,7.16,10.06,13.16,14.25,15.31,18.44,21.59,22.69,22.72,24.16,26.25,27.12,25.31,23.88,24.25,24.28,22.09,20.47,21.28,22.06,20.06,17.66,17.19,17.44,16.34,14.12,13.5,14.56,14.97,13.41,12.84,14.38,15.88,15.94,16.34,19.41,22.84,24.03,23.88,24.56,25.75,24.75,21.28,18.78,17.84,16.62,13.81,11.84,12.97,14.12,13.53,13.03,14.75,17.28,18.44,19.31,22.47,27.0,29.97,30.09,29.75,29.94,28.91,25.16,22.19,21.62,21.62,19.47,16.72,16.12,16.84,16.22,15.34,16.38,19.41,21.59,21.03,20.22,20.75,20.69,18.0,15.72,16.03,17.88,18.03,17.72,18.81,20.78,21.0,19.38,18.97,20.62,21.84,21.06,20.84,22.47,24.06,23.19,22.31,23.28,25.0,24.66,23.12,23.06,23.72,23.38,21.34,20.19,21.09,21.88,20.75,19.94,21.5,23.5,23.25,22.28,23.12,24.75,24.72,23.47,23.72,25.47,25.44,23.19,21.06,20.59,20.09,17.53,15.94,17.06,19.22,19.75,19.53,20.81,23.16,23.16,21.53,20.5,20.59,19.81,17.12,14.88,15.16,16.31,15.72,15.56,17.78,20.97,22.19,22.59,23.81,26.62,28.34,28.34,28.91,30.91,32.06,30.97,29.84,30.72,31.94,30.88,29.25,29.53,30.69,30.38,28.88,28.47,29.72,29.59,27.78,26.66,27.59,28.16,26.5,24.91,25.38,26.19,25.72,24.91,25.28,27.47,27.5,26.09,25.31,26.34,26.81,26.09,25.38,26.5,27.97,26.62,24.75,24.5,25.47,24.22,22.66,22.03,23.03,22.59,20.16,18.28,18.0,17.62,15.5,14.12,15.06,16.81,16.34,14.78,14.59,15.03,14.12,12.0,11.28,12.62,13.53,12.06,11.25,12.41,13.47,12.75,11.94,13.97,16.03,16.44,15.56,15.72,17.25,17.44,16.75,16.66,18.88,20.34,19.59,18.41,18.91,19.56,18.0,16.41,17.25,19.5,19.88,19.31,19.59,21.22,21.75,20.31,19.59,20.56,20.69,18.31,15.69,15.56,15.75,14.31,12.69,13.16,15.31,16.28,16.12,16.97,18.84,19.16,17.28,15.94,17.03,18.06,17.0,15.22,15.22,15.19,13.69,11.5,11.84,13.94,15.06,14.72,15.16,17.0,18.25,17.44,16.97,19.0,21.31,21.66,21.03,22.06,22.78,21.47,18.78,17.69,18.69,18.94,17.59,16.41,17.0,16.75,14.59,12.81,13.34,15.12,15.16,14.09,15.09,17.19,18.06,17.38,18.25,20.25,20.88,18.66,16.25,16.5,16.62,15.41,14.28,15.56,17.44,17.19,15.69,15.94,17.19,16.53,13.97,12.31,12.84,12.94,11.28,9.91,10.72,11.5,10.97,10.25,11.66,14.78,16.38,16.66,18.84,22.34,24.72,25.09,25.78,28.0,30.0,29.62,29.34,31.12,33.12,33.09,31.72,31.91,33.25,33.72,32.5,33.06,35.41,36.78,35.88,35.38,36.78,38.12,37.56,36.53,37.88,39.5,39.16,37.09,36.38,36.25,34.88,31.66,28.59,27.53,25.31,21.34,18.5,18.88,20.22,20.12,19.34,19.78,21.03,20.16,17.59,16.75,17.5,17.19,15.19,14.38,15.53,16.34,14.66,13.0,13.28,14.56,13.81,12.5,12.84,14.34,14.5,12.91,12.84,14.31,14.84,13.25,11.81,12.53,13.47,12.22,10.5,11.22,12.91,12.56,10.94,10.59,11.0,10.44,8.12,7.25,8.84,10.31,9.66,9.62,11.72,14.22,14.16,13.75,14.66,16.56,16.97,15.94,16.41,18.44,19.62,18.97,19.28,21.59,23.34,22.28,20.72,20.62,21.19,19.28,16.84,16.06,16.84,16.78,15.34,15.91,18.22,20.69,20.53,21.28,23.97,26.53,26.44,25.47,26.12,27.41,26.91,25.5,25.69,27.22,27.03,24.72,22.62,22.0,20.62,16.94,14.09,14.25,15.59,16.03,16.62,18.94,22.5,23.91,24.12,25.81,29.75,32.22,32.88,33.19,34.34,34.69,31.25,27.56,25.94,25.19,22.66,20.25,20.03,21.66,21.88,20.84,21.06,23.0,23.94,22.41,21.56,22.59,23.66,22.72,21.62,22.09,23.69,23.38,21.69,22.09,24.25,25.19,24.5,24.31,26.5,27.34,25.53,22.88,22.28,21.44,17.78,14.09,12.62,12.62,11.78,10.5,11.03,14.16,16.22,15.81,15.19,16.19,16.66,14.78,13.28,14.62,17.66,18.5,18.78,20.34,23.06,24.03,23.47,24.19,26.31,26.91,24.22,21.97,21.28,20.88,18.66,16.91,17.75,19.47,19.25,17.59,17.12,17.94,17.44,14.72,12.91,14.06,15.09,14.88,14.97,18.19,21.38,21.91,21.34,22.84,24.88,24.41,22.38,20.78,20.69,19.09,15.88,13.12,13.28,13.12,11.56,10.28,12.09,15.19,16.72,18.0,20.75,24.69,25.94,25.41,25.0,26.44,26.88,24.84,23.12,23.53,23.69,21.47,19.22,19.16,20.12,18.75,16.09,14.75,14.47,13.03,10.09,9.0,10.44,11.53,10.97,10.75,14.03,17.56,19.31,20.84,23.69,26.62,27.0,25.41,24.69,25.44,24.22,21.09,18.56,18.72,18.72,17.59,16.91,18.78,21.53,21.69,20.94,21.66,23.19,22.25,19.16,16.78,16.16,15.34,13.41,12.66,15.66,18.78,19.47,19.69,21.66,23.84,23.72,22.03,22.16,23.22,22.78,19.88,18.06,18.25,17.88,15.59,13.81,14.66,15.78,14.69,13.06,13.72,15.5,15.56,14.59,15.38,17.56,18.38,17.53,17.03,19.0,19.69,18.09,16.03,16.06,16.69,15.09,12.84,12.38,13.0,12.03,10.41,10.72,13.41,15.22,14.78,14.28,15.44,15.78,13.41,10.66,10.78,11.53,11.41,11.03,12.75,15.91,17.59,16.91,17.22,19.25,20.69,19.81,19.81,22.12,24.25,23.97,23.09,24.31,26.19,26.31,31.41,31.41,30.38,29.69,30.03,30.03,29.38,28.06,29.25,31.12,31.94,31.94,32.53,32.91,31.69,28.84,26.44,25.62,24.38,22.41,21.38:31.59,30.91,30.31,28.12,23.94,20.97,21.16,22.66,22.94,23.78,27.53,31.47,32.97,33.12,34.41,36.0,36.03,33.81,32.41,32.22,31.09,27.62,24.97,25.31,26.09,25.84,25.44,27.38,29.22,28.78,26.72,26.0,26.56,26.97,26.56,27.34,30.41,32.72,32.66,32.34,34.09,36.47,36.84,36.38,37.66,39.09,37.94,34.19,31.06,28.72,25.62,21.22,18.59,19.03,21.19,21.66,22.5,25.56,28.94,30.16,29.66,30.72,32.12,32.31,31.19,31.19,32.97,34.31,33.34,31.91,32.31,32.38,31.09,29.31,29.75,31.19,30.66,28.09,26.69,26.31,24.91,22.44,21.12,22.41,23.62,22.91,21.97,22.59,23.69,22.47,20.44,20.41,21.59,21.12,19.22,18.75,19.88,20.56,19.34,19.12,20.78,22.16,20.59,18.41,18.09,18.28,16.88,13.75,12.75,12.94,11.75,8.88,7.44,8.28,9.41,9.31,10.5,14.78,19.78,22.81,24.72,27.66,30.38,30.06,27.91,25.81,24.75,22.34,17.97,14.25,13.28,13.09,11.16,9.84,11.28,13.47,13.53,13.0,14.47,17.75,19.5,20.16,21.59,24.69,26.41,25.56,25.91,28.66,31.88,32.97,33.44,34.5,35.0,32.28,27.59,24.47,23.22,21.75,19.09,18.47,20.69,22.59,22.75,23.34,25.72,28.38,28.41,26.88,27.41,28.66,28.31,26.94,27.31,29.56,30.47,28.94,27.72,28.59,28.84,27.44,26.53,27.81,30.09,30.12,29.16,29.19,30.03,29.22,26.81,25.69,26.47,27.0,25.5,25.53,27.53,29.53,29.28,28.22,28.62,29.72,28.59,26.53,25.69,26.09,25.5,23.25,22.09,23.34,24.25,22.78,21.44,22.75,24.69,25.16,24.5,25.31,26.84,26.0,23.94,23.19,24.72,25.5,24.62,23.94,25.25,25.78,23.56,21.22,21.31,22.16,21.06,19.5,19.66,21.91,22.78,22.75,23.69,26.59,29.0,28.41,27.72,28.81,29.47,27.69,25.62,26.5,29.66,31.44,32.38,34.56,37.75,38.72,36.94,34.59,33.06,29.59,23.16,16.97,14.22,12.88,10.62,8.91,9.72,12.06,13.12,13.91,16.22,20.25,22.47,21.91,20.59,21.34,21.59,19.66,17.88,18.78,21.0,21.41,21.25,22.78,25.09,25.19,22.84,21.0,20.75,19.59,15.97,12.38,11.5,11.25,9.38,7.84,9.53,12.47,14.09,14.5,16.38,19.22,20.34,18.19,16.25,16.0,15.88,14.34,13.28,15.72,19.28,20.72,21.25,23.31,26.59,27.66,26.69,26.25,26.72,25.59,21.91,18.38,17.56,17.0,15.06,13.56,14.91,17.16,17.53,17.0,18.25,20.5,21.12,19.97,20.22,22.28,24.69,25.47,26.56,30.03,32.78,32.25,29.75,28.44,27.44,24.28,20.53,18.81,19.56,19.72,17.53,16.31,16.44,15.47,12.44,8.97,8.28,8.0,6.16,3.62,3.53,5.28,5.69,5.47,6.84,10.88,14.28,16.19,18.62,23.12,27.94,30.41,32.19,35.38,38.0,37.81,35.06,33.12,32.69,30.78,27.56,25.66,26.28,26.03,23.34,21.12,20.97,20.88,19.12,16.75,17.25,18.88,19.19,18.38,19.66,22.44,24.0,23.19,22.34,22.62,21.56,18.12,13.97,12.5,11.47,8.53,5.31,4.44,5.0,4.94,3.56,3.69,5.97,7.31,6.78,7.16,10.06,13.16,14.25,15.31,18.44,21.59,22.69,22.72,24.16,26.25,27.12,25.31,23.88,24.25,24.28,22.09,20.47,21.28,22.06,20.06,17.66,17.19,17.44,16.34,14.12,13.5,14.56,14.97,13.41,12.84,14.38,15.88,15.94,16.34,19.41,22.84,24.03,23.88,24.56,25.75,24.75,21.28,18.78,17.84,16.62,13.81,11.84,12.97,14.12,13.53,13.03,14.75,17.28,18.44,19.31,22.47,27.0,29.97,30.09,29.75,29.94,28.91,25.16,22.19,21.62,21.62,19.47,16.72,16.12,16.84,16.22,15.34,16.38,19.41,21.59,21.03,20.22,20.75,20.69,18.0,15.72,16.03,17.88,18.03,17.72,18.81,20.78,21.0,19.38,18.97,20.62,21.84,21.06,20.84,22.47,24.06,23.19,22.31,23.28,25.0,24.66,23.12,23.06,23.72,23.38,21.34,20.19,21.09,21.88,20.75,19.94,21.5,23.5,23.25,22.28,23.12,24.75,24.72,23.47,23.72,25.47,25.44,23.19,21.06,20.59,20.09,17.53,15.94,17.06,19.22,19.75,19.53,20.81,23.16,23.16,21.53,20.5,20.59,19.81,17.12,14.88,15.16,16.31,15.72,15.56,17.78,20.97,22.19,22.59,23.81,26.62,28.34,28.34,28.91,30.91,32.06,30.97,29.84,30.72,31.94,30.88,29.25,29.53,30.69,30.38,28.88,28.47,29.72,29.59,27.78,26.66,27.59,28.16,26.5,24.91,25.38,26.19,25.72,24.91,25.28,27.47,27.5,26.09,25.31,26.34,26.81,26.09,25.38,26.5,27.97,26.62,24.75,24.5,25.47,24.22,22.66,22.03,23.03,22.59,20.16,18.28,18.0,17.62,15.5,14.12,15.06,16.81,16.34,14.78,14.59,15.03,14.12,12.0,11.28,12.62,13.53,12.06,11.25,12.41,13.47,12.75,11.94,13.97,16.03,16.44,15.56,15.72,17.25,17.44,16.75,16.66,18.88,20.34,19.59,18.41,18.91,19.56,18.0,16.41,17.25,19.5,19.88,19.31,19.59,21.22,21.75,20.31,19.59,20.56,20.69,18.31,15.69,15.56,15.75,14.31,12.69,13.16,15.31,16.28,16.12,16.97,18.84,19.16,17.28,15.94,17.03,18.06,17.0,15.22,15.22,15.19,13.69,11.5,11.84,13.94,15.06,14.72,15.16,17.0,18.25,17.44,16.97,19.0,21.31,21.66,21.03,22.06,22.78,21.47,18.78,17.69,18.69,18.94,17.59,16.41,17.0,16.75,14.59,12.81,13.34,15.12,15.16,14.09,15.09,17.19,18.06,17.38,18.25,20.25,20.88,18.66,16.25,16.5,16.62,15.41,14.28,15.56,17.44,17.19,15.69,15.94,17.19,16.53,13.97,12.31,12.84,12.94,11.28,9.91,10.72,11.5,10.97,10.25,11.66,14.78,16.38,16.66,18.84,22.34,24.72,25.09,25.78,28.0,30.0,29.62,29.34,31.12,33.12,33.09,31.72,31.91,33.25,33.72,32.5,33.06,35.41,36.78,35.88,35.38,36.78,38.12,37.56,36.53,37.88,39.5,39.16,37.09,36.38,36.25,34.88,31.66,28.59,27.53,25.31,21.34,18.5,18.88,20.22,20.12,19.34,19.78,21.03,20.16,17.59,16.75,17.5,17.19,15.19,14.38,15.53,16.34,14.66,13.0,13.28,14.56,13.81,12.5,12.84,14.34,14.5,12.91,12.84,14.31,14.84,13.25,11.81,12.53,13.47,12.22,10.5,11.22,12.91,12.56,10.94,10.59,11.0,10.44,8.12,7.25,8.84,10.31,9.66,9.62,11.72,14.22,14.16,13.75,14.66,16.56,16.97,15.94,16.41,18.44,19.62,18.97,19.28,21.59,23.34,22.28,20.72,20.62,21.19,19.28,16.84,16.06,16.84,16.78,15.34,15.91,18.22,20.69,20.53,21.28,23.97,26.53,26.44,25.47,26.12,27.41,26.91,25.5,25.69,27.22,27.03,24.72,22.62,22.0,20.62,16.94,14.09,14.25,15.59,16.03,16.62,18.94,22.5,23.91,24.12,25.81,29.75,32.22,32.88,33.19,34.34,34.69,31.25,27.56,25.94,25.19,22.66,20.25,20.03,21.66,21.88,20.84,21.06,23.0,23.94,22.41,21.56,22.59,23.66,22.72,21.62,22.09,23.69,23.38,21.69,22.09,24.25,25.19,24.5,24.31,26.5,27.34,25.53,22.88,22.28,21.44,17.78,14.09,12.62,12.62,11.78,10.5,11.03,14.16,16.22,15.81,15.19,16.19,16.66,14.78,13.28,14.62,17.66,18.5,18.78,20.34,23.06,24.03,23.47,24.19,26.31,26.91,24.22,21.97,21.28,20.88,18.66,16.91,17.75,19.47,19.25,17.59,17.12,17.94,17.44,14.72,12.91,14.06,15.09,14.88,14.97,18.19,21.38,21.91,21.34,22.84,24.88,24.41,22.38,20.78,20.69,19.09,15.88,13.12,13.28,13.12,11.56,10.28,12.09,15.19,16.72,18.0,20.75,24.69,25.94,25.41,25.0,26.44,26.88,24.84,23.12,23.53,23.69,21.47,19.22,19.16,20.12,18.75,16.09,14.75,14.47,13.03,10.09,9.0,10.44,11.53,10.97,10.75,14.03,17.56,19.31,20.84,23.69,26.62,27.0,25.41,24.69,25.44,24.22,21.09,18.56,18.72,18.72,17.59,16.91,18.78,21.53,21.69,20.94,21.66,23.19,22.25,19.16,16.78,16.16,15.34,13.41,12.66,15.66,18.78,19.47,19.69,21.66,23.84,23.72,22.03,22.16,23.22,22.78,19.88,18.06,18.25,17.88,15.59,13.81,14.66,15.78,14.69,13.06,13.72,15.5,15.56,14.59,15.38,17.56,18.38,17.53,17.03,19.0,19.69,18.09,16.03,16.06,16.69,15.09,12.84,12.38,13.0,12.03,10.41,10.72,13.41,15.22,14.78,14.28,15.44,15.78,13.41,10.66,10.78,11.53,11.41,11.03,12.75,15.91,17.59,16.91,17.22,19.25,20.69,19.81,19.81,22.12,24.25,23.97,23.09,24.31,26.19,26.31,31.41,31.41,30.38,29.69,30.03,30.03,29.38,28.06,29.25,31.12,31.94,31.94,32.53,32.91,31.69,28.84,26.44,25.62,24.38,22.41,21.38,22.44,24.59,26.03,27.84,31.47,35.41,37.16:22.66,22.94,23.78,27.53,31.47,32.97,33.12,34.41,36.0,36.03,33.81,32.41,32.22,31.09,27.62,24.97,25.31,26.09,25.84,25.44,27.38,29.22,28.78,26.72,26.0,26.56,26.97,26.56,27.34,30.41,32.72,32.66,32.34,34.09,36.47,36.84,36.38,37.66,39.09,37.94,34.19,31.06,28.72,25.62,21.22,18.59,19.03,21.19,21.66,22.5,25.56,28.94,30.16,29.66,30.72,32.12,32.31,31.19,31.19,32.97,34.31,33.34,31.91,32.31,32.38,31.09,29.31,29.75,31.19,30.66,28.09,26.69,26.31,24.91,22.44,21.12,22.41,23.62,22.91,21.97,22.59,23.69,22.47,20.44,20.41,21.59,21.12,19.22,18.75,19.88,20.56,19.34,19.12,20.78,22.16,20.59,18.41,18.09,18.28,16.88,13.75,12.75,12.94,11.75,8.88,7.44,8.28,9.41,9.31,10.5,14.78,19.78,22.81,24.72,27.66,30.38,30.06,27.91,25.81,24.75,22.34,17.97,14.25,13.28,13.09,11.16,9.84,11.28,13.47,13.53,13.0,14.47,17.75,19.5,20.16,21.59,24.69,26.41,25.56,25.91,28.66,31.88,32.97,33.44,34.5,35.0,32.28,27.59,24.47,23.22,21.75,19.09,18.47,20.69,22.59,22.75,23.34,25.72,28.38,28.41,26.88,27.41,28.66,28.31,26.94,27.31,29.56,30.47,28.94,27.72,28.59,28.84,27.44,26.53,27.81,30.09,30.12,29.16,29.19,30.03,29.22,26.81,25.69,26.47,27.0,25.5,25.53,27.53,29.53,29.28,28.22,28.62,29.72,28.59,26.53,25.69,26.09,25.5,23.25,22.09,23.34,24.25,22.78,21.44,22.75,24.69,25.16,24.5,25.31,26.84,26.0,23.94,23.19,24.72,25.5,24.62,23.94,25.25,25.78,23.56,21.22,21.31,22.16,21.06,19.5,19.66,21.91,22.78,22.75,23.69,26.59,29.0,28.41,27.72,28.81,29.47,27.69,25.62,26.5,29.66,31.44,32.38,34.56,37.75,38.72,36.94,34.59,33.06,29.59,23.16,16.97,14.22,12.88,10.62,8.91,9.72,12.06,13.12,13.91,16.22,20.25,22.47,21.91,20.59,21.34,21.59,19.66,17.88,18.78,21.0,21.41,21.25,22.78,25.09,25.19,22.84,21.0,20.75,19.59,15.97,12.38,11.5,11.25,9.38,7.84,9.53,12.47,14.09,14.5,16.38,19.22,20.34,18.19,16.25,16.0,15.88,14.34,13.28,15.72,19.28,20.72,21.25,23.31,26.59,27.66,26.69,26.25,26.72,25.59,21.91,18.38,17.56,17.0,15.06,13.56,14.91,17.16,17.53,17.0,18.25,20.5,21.12,19.97,20.22,22.28,24.69,25.47,26.56,30.03,32.78,32.25,29.75,28.44,27.44,24.28,20.53,18.81,19.56,19.72,17.53,16.31,16.44,15.47,12.44,8.97,8.28,8.0,6.16,3.62,3.53,5.28,5.69,5.47,6.84,10.88,14.28,16.19,18.62,23.12,27.94,30.41,32.19,35.38,38.0,37.81,35.06,33.12,32.69,30.78,27.56,25.66,26.28,26.03,23.34,21.12,20.97,20.88,19.12,16.75,17.25,18.88,19.19,18.38,19.66,22.44,24.0,23.19,22.34,22.62,21.56,18.12,13.97,12.5,11.47,8.53,5.31,4.44,5.0,4.94,3.56,3.69,5.97,7.31,6.78,7.16,10.06,13.16,14.25,15.31,18.44,21.59,22.69,22.72,24.16,26.25,27.12,25.31,23.88,24.25,24.28,22.09,20.47,21.28,22.06,20.06,17.66,17.19,17.44,16.34,14.12,13.5,14.56,14.97,13.41,12.84,14.38,15.88,15.94,16.34,19.41,22.84,24.03,23.88,24.56,25.75,24.75,21.28,18.78,17.84,16.62,13.81,11.84,12.97,14.12,13.53,13.03,14.75,17.28,18.44,19.31,22.47,27.0,29.97,30.09,29.75,29.94,28.91,25.16,22.19,21.62,21.62,19.47,16.72,16.12,16.84,16.22,15.34,16.38,19.41,21.59,21.03,20.22,20.75,20.69,18.0,15.72,16.03,17.88,18.03,17.72,18.81,20.78,21.0,19.38,18.97,20.62,21.84,21.06,20.84,22.47,24.06,23.19,22.31,23.28,25.0,24.66,23.12,23.06,23.72,23.38,21.34,20.19,21.09,21.88,20.75,19.94,21.5,23.5,23.25,22.28,23.12,24.75,24.72,23.47,23.72,25.47,25.44,23.19,21.06,20.59,20.09,17.53,15.94,17.06,19.22,19.75,19.53,20.81,23.16,23.16,21.53,20.5,20.59,19.81,17.12,14.88,15.16,16.31,15.72,15.56,17.78,20.97,22.19,22.59,23.81,26.62,28.34,28.34,28.91,30.91,32.06,30.97,29.84,30.72,31.94,30.88,29.25,29.53,30.69,30.38,28.88,28.47,29.72,29.59,27.78,26.66,27.59,28.16,26.5,24.91,25.38,26.19,25.72,24.91,25.28,27.47,27.5,26.09,25.31,26.34,26.81,26.09,25.38,26.5,27.97,26.62,24.75,24.5,25.47,24.22,22.66,22.03,23.03,22.59,20.16,18.28,18.0,17.62,15.5,14.12,15.06,16.81,16.34,14.78,14.59,15.03,14.12,12.0,11.28,12.62,13.53,12.06,11.25,12.41,13.47,12.75,11.94,13.97,16.03,16.44,15.56,15.72,17.25,17.44,16.75,16.66,18.88,20.34,19.59,18.41,18.91,19.56,18.0,16.41,17.25,19.5,19.88,19.31,19.59,21.22,21.75,20.31,19.59,20.56,20.69,18.31,15.69,15.56,15.75,14.31,12.69,13.16,15.31,16.28,16.12,16.97,18.84,19.16,17.28,15.94,17.03,18.06,17.0,15.22,15.22,15.19,13.69,11.5,11.84,13.94,15.06,14.72,15.16,17.0,18.25,17.44,16.97,19.0,21.31,21.66,21.03,22.06,22.78,21.47,18.78,17.69,18.69,18.94,17.59,16.41,17.0,16.75,14.59,12.81,13.34,15.12,15.16,14.09,15.09,17.19,18.06,17.38,18.25,20.25,20.88,18.66,16.25,16.5,16.62,15.41,14.28,15.56,17.44,17.19,15.69,15.94,17.19,16.53,13.97,12.31,12.84,12.94,11.28,9.91,10.72,11.5,10.97,10.25,11.66,14.78,16.38,16.66,18.84,22.34,24.72,25.09,25.78,28.0,30.0,29.62,29.34,31.12,33.12,33.09,31.72,31.91,33.25,33.72,32.5,33.06,35.41,36.78,35.88,35.38,36.78,38.12,37.56,36.53,37.88,39.5,39.16,37.09,36.38,36.25,34.88,31.66,28.59,27.53,25.31,21.34,18.5,18.88,20.22,20.12,19.34,19.78,21.03,20.16,17.59,16.75,17.5,17.19,15.19,14.38,15.53,16.34,14.66,13.0,13.28,14.56,13.81,12.5,12.84,14.34,14.5,12.91,12.84,14.31,14.84,13.25,11.81,12.53,13.47,12.22,10.5,11.22,12.91,12.56,10.94,10.59,11.0,10.44,8.12,7.25,8.84,10.31,9.66,9.62,11.72,14.22,14.16,13.75,14.66,16.56,16.97,15.94,16.41,18.44,19.62,18.97,19.28,21.59,23.34,22.28,20.72,20.62,21.19,19.28,16.84,16.06,16.84,16.78,15.34,15.91,18.22,20.69,20.53,21.28,23.97,26.53,26.44,25.47,26.12,27.41,26.91,25.5,25.69,27.22,27.03,24.72,22.62,22.0,20.62,16.94,14.09,14.25,15.59,16.03,16.62,18.94,22.5,23.91,24.12,25.81,29.75,32.22,32.88,33.19,34.34,34.69,31.25,27.56,25.94,25.19,22.66,20.25,20.03,21.66,21.88,20.84,21.06,23.0,23.94,22.41,21.56,22.59,23.66,22.72,21.62,22.09,23.69,23.38,21.69,22.09,24.25,25.19,24.5,24.31,26.5,27.34,25.53,22.88,22.28,21.44,17.78,14.09,12.62,12.62,11.78,10.5,11.03,14.16,16.22,15.81,15.19,16.19,16.66,14.78,13.28,14.62,17.66,18.5,18.78,20.34,23.06,24.03,23.47,24.19,26.31,26.91,24.22,21.97,21.28,20.88,18.66,16.91,17.75,19.47,19.25,17.59,17.12,17.94,17.44,14.72,12.91,14.06,15.09,14.88,14.97,18.19,21.38,21.91,21.34,22.84,24.88,24.41,22.38,20.78,20.69,19.09,15.88,13.12,13.28,13.12,11.56,10.28,12.09,15.19,16.72,18.0,20.75,24.69,25.94,25.41,25.0,26.44,26.88,24.84,23.12,23.53,23.69,21.47,19.22,19.16,20.12,18.75,16.09,14.75,14.47,13.03,10.09,9.0,10.44,11.53,10.97,10.75,14.03,17.56,19.31,20.84,23.69,26.62,27.0,25.41,24.69,25.44,24.22,21.09,18.56,18.72,18.72,17.59,16.91,18.78,21.53,21.69,20.94,21.66,23.19,22.25,19.16,16.78,16.16,15.34,13.41,12.66,15.66,18.78,19.47,19.69,21.66,23.84,23.72,22.03,22.16,23.22,22.78,19.88,18.06,18.25,17.88,15.59,13.81,14.66,15.78,14.69,13.06,13.72,15.5,15.56,14.59,15.38,17.56,18.38,17.53,17.03,19.0,19.69,18.09,16.03,16.06,16.69,15.09,12.84,12.38,13.0,12.03,10.41,10.72,13.41,15.22,14.78,14.28,15.44,15.78,13.41,10.66,10.78,11.53,11.41,11.03,12.75,15.91,17.59,16.91,17.22,19.25,20.69,19.81,19.81,22.12,24.25,23.97,23.09,24.31,26.19,26.31,31.41,31.41,30.38,29.69,30.03,30.03,29.38,28.06,29.25,31.12,31.94,31.94,32.53,32.91,31.69,28.84,26.44,25.62,24.38,22.41,21.38,22.44,24.59,26.03,27.84,31.47,35.41,37.16,37.34,37.34,37.19,35.22,31.81,28.88,27.69:34.41,36.0,36.03,33.81,32.41,32.22,31.09,27.62,24.97,25.31,26.09,25.84,25.44,27.38,29.22,28.78,26.72,26.0,26.56,26.97,26.56,27.34,30.41,32.72,32.66,32.34,34.09,36.47,36.84,36.38,37.66,39.09,37.94,34.19,31.06,28.72,25.62,21.22,18.59,19.03,21.19,21.66,22.5,25.56,28.94,30.16,29.66,30.72,32.12,32.31,31.19,31.19,32.97,34.31,33.34,31.91,32.31,32.38,31.09,29.31,29.75,31.19,30.66,28.09,26.69,26.31,24.91,22.44,21.12,22.41,23.62,22.91,21.97,22.59,23.69,22.47,20.44,20.41,21.59,21.12,19.22,18.75,19.88,20.56,19.34,19.12,20.78,22.16,20.59,18.41,18.09,18.28,16.88,13.75,12.75,12.94,11.75,8.88,7.44,8.28,9.41,9.31,10.5,14.78,19.78,22.81,24.72,27.66,30.38,30.06,27.91,25.81,24.75,22.34,17.97,14.25,13.28,13.09,11.16,9.84,11.28,13.47,13.53,13.0,14.47,17.75,19.5,20.16,21.59,24.69,26.41,25.56,25.91,28.66,31.88,32.97,33.44,34.5,35.0,32.28,27.59,24.47,23.22,21.75,19.09,18.47,20.69,22.59,22.75,23.34,25.72,28.38,28.41,26.88,27.41,28.66,28.31,26.94,27.31,29.56,30.47,28.94,27.72,28.59,28.84,27.44,26.53,27.81,30.09,30.12,29.16,29.19,30.03,29.22,26.81,25.69,26.47,27.0,25.5,25.53,27.53,29.53,29.28,28.22,28.62,29.72,28.59,26.53,25.69,26.09,25.5,23.25,22.09,23.34,24.25,22.78,21.44,22.75,24.69,25.16,24.5,25.31,26.84,26.0,23.94,23.19,24.72,25.5,24.62,23.94,25.25,25.78,23.56,21.22,21.31,22.16,21.06,19.5,19.66,21.91,22.78,22.75,23.69,26.59,29.0,28.41,27.72,28.81,29.47,27.69,25.62,26.5,29.66,31.44,32.38,34.56,37.75,38.72,36.94,34.59,33.06,29.59,23.16,16.97,14.22,12.88,10.62,8.91,9.72,12.06,13.12,13.91,16.22,20.25,22.47,21.91,20.59,21.34,21.59,19.66,17.88,18.78,21.0,21.41,21.25,22.78,25.09,25.19,22.84,21.0,20.75,19.59,15.97,12.38,11.5,11.25,9.38,7.84,9.53,12.47,14.09,14.5,16.38,19.22,20.34,18.19,16.25,16.0,15.88,14.34,13.28,15.72,19.28,20.72,21.25,23.31,26.59,27.66,26.69,26.25,26.72,25.59,21.91,18.38,17.56,17.0,15.06,13.56,14.91,17.16,17.53,17.0,18.25,20.5,21.12,19.97,20.22,22.28,24.69,25.47,26.56,30.03,32.78,32.25,29.75,28.44,27.44,24.28,20.53,18.81,19.56,19.72,17.53,16.31,16.44,15.47,12.44,8.97,8.28,8.0,6.16,3.62,3.53,5.28,5.69,5.47,6.84,10.88,14.28,16.19,18.62,23.12,27.94,30.41,32.19,35.38,38.0,37.81,35.06,33.12,32.69,30.78,27.56,25.66,26.28,26.03,23.34,21.12,20.97,20.88,19.12,16.75,17.25,18.88,19.19,18.38,19.66,22.44,24.0,23.19,22.34,22.62,21.56,18.12,13.97,12.5,11.47,8.53,5.31,4.44,5.0,4.94,3.56,3.69,5.97,7.31,6.78,7.16,10.06,13.16,14.25,15.31,18.44,21.59,22.69,22.72,24.16,26.25,27.12,25.31,23.88,24.25,24.28,22.09,20.47,21.28,22.06,20.06,17.66,17.19,17.44,16.34,14.12,13.5,14.56,14.97,13.41,12.84,14.38,15.88,15.94,16.34,19.41,22.84,24.03,23.88,24.56,25.75,24.75,21.28,18.78,17.84,16.62,13.81,11.84,12.97,14.12,13.53,13.03,14.75,17.28,18.44,19.31,22.47,27.0,29.97,30.09,29.75,29.94,28.91,25.16,22.19,21.62,21.62,19.47,16.72,16.12,16.84,16.22,15.34,16.38,19.41,21.59,21.03,20.22,20.75,20.69,18.0,15.72,16.03,17.88,18.03,17.72,18.81,20.78,21.0,19.38,18.97,20.62,21.84,21.06,20.84,22.47,24.06,23.19,22.31,23.28,25.0,24.66,23.12,23.06,23.72,23.38,21.34,20.19,21.09,21.88,20.75,19.94,21.5,23.5,23.25,22.28,23.12,24.75,24.72,23.47,23.72,25.47,25.44,23.19,21.06,20.59,20.09,17.53,15.94,17.06,19.22,19.75,19.53,20.81,23.16,23.16,21.53,20.5,20.59,19.81,17.12,14.88,15.16,16.31,15.72,15.56,17.78,20.97,22.19,22.59,23.81,26.62,28.34,28.34,28.91,30.91,32.06,30.97,29.84,30.72,31.94,30.88,29.25,29.53,30.69,30.38,28.88,28.47,29.72,29.59,27.78,26.66,27.59,28.16,26.5,24.91,25.38,26.19,25.72,24.91,25.28,27.47,27.5,26.09,25.31,26.34,26.81,26.09,25.38,26.5,27.97,26.62,24.75,24.5,25.47,24.22,22.66,22.03,23.03,22.59,20.16,18.28,18.0,17.62,15.5,14.12,15.06,16.81,16.34,14.78,14.59,15.03,14.12,12.0,11.28,12.62,13.53,12.06,11.25,12.41,13.47,12.75,11.94,13.97,16.03,16.44,15.56,15.72,17.25,17.44,16.75,16.66,18.88,20.34,19.59,18.41,18.91,19.56,18.0,16.41,17.25,19.5,19.88,19.31,19.59,21.22,21.75,20.31,19.59,20.56,20.69,18.31,15.69,15.56,15.75,14.31,12.69,13.16,15.31,16.28,16.12,16.97,18.84,19.16,17.28,15.94,17.03,18.06,17.0,15.22,15.22,15.19,13.69,11.5,11.84,13.94,15.06,14.72,15.16,17.0,18.25,17.44,16.97,19.0,21.31,21.66,21.03,22.06,22.78,21.47,18.78,17.69,18.69,18.94,17.59,16.41,17.0,16.75,14.59,12.81,13.34,15.12,15.16,14.09,15.09,17.19,18.06,17.38,18.25,20.25,20.88,18.66,16.25,16.5,16.62,15.41,14.28,15.56,17.44,17.19,15.69,15.94,17.19,16.53,13.97,12.31,12.84,12.94,11.28,9.91,10.72,11.5,10.97,10.25,11.66,14.78,16.38,16.66,18.84,22.34,24.72,25.09,25.78,28.0,30.0,29.62,29.34,31.12,33.12,33.09,31.72,31.91,33.25,33.72,32.5,33.06,35.41,36.78,35.88,35.38,36.78,38.12,37.56,36.53,37.88,39.5,39.16,37.09,36.38,36.25,34.88,31.66,28.59,27.53,25.31,21.34,18.5,18.88,20.22,20.12,19.34,19.78,21.03,20.16,17.59,16.75,17.5,17.19,15.19,14.38,15.53,16.34,14.66,13.0,13.28,14.56,13.81,12.5,12.84,14.34,14.5,12.91,12.84,14.31,14.84,13.25,11.81,12.53,13.47,12.22,10.5,11.22,12.91,12.56,10.94,10.59,11.0,10.44,8.12,7.25,8.84,10.31,9.66,9.62,11.72,14.22,14.16,13.75,14.66,16.56,16.97,15.94,16.41,18.44,19.62,18.97,19.28,21.59,23.34,22.28,20.72,20.62,21.19,19.28,16.84,16.06,16.84,16.78,15.34,15.91,18.22,20.69,20.53,21.28,23.97,26.53,26.44,25.47,26.12,27.41,26.91,25.5,25.69,27.22,27.03,24.72,22.62,22.0,20.62,16.94,14.09,14.25,15.59,16.03,16.62,18.94,22.5,23.91,24.12,25.81,29.75,32.22,32.88,33.19,34.34,34.69,31.25,27.56,25.94,25.19,22.66,20.25,20.03,21.66,21.88,20.84,21.06,23.0,23.94,22.41,21.56,22.59,23.66,22.72,21.62,22.09,23.69,23.38,21.69,22.09,24.25,25.19,24.5,24.31,26.5,27.34,25.53,22.88,22.28,21.44,17.78,14.09,12.62,12.62,11.78,10.5,11.03,14.16,16.22,15.81,15.19,16.19,16.66,14.78,13.28,14.62,17.66,18.5,18.78,20.34,23.06,24.03,23.47,24.19,26.31,26.91,24.22,21.97,21.28,20.88,18.66,16.91,17.75,19.47,19.25,17.59,17.12,17.94,17.44,14.72,12.91,14.06,15.09,14.88,14.97,18.19,21.38,21.91,21.34,22.84,24.88,24.41,22.38,20.78,20.69,19.09,15.88,13.12,13.28,13.12,11.56,10.28,12.09,15.19,16.72,18.0,20.75,24.69,25.94,25.41,25.0,26.44,26.88,24.84,23.12,23.53,23.69,21.47,19.22,19.16,20.12,18.75,16.09,14.75,14.47,13.03,10.09,9.0,10.44,11.53,10.97,10.75,14.03,17.56,19.31,20.84,23.69,26.62,27.0,25.41,24.69,25.44,24.22,21.09,18.56,18.72,18.72,17.59,16.91,18.78,21.53,21.69,20.94,21.66,23.19,22.25,19.16,16.78,16.16,15.34,13.41,12.66,15.66,18.78,19.47,19.69,21.66,23.84,23.72,22.03,22.16,23.22,22.78,19.88,18.06,18.25,17.88,15.59,13.81,14.66,15.78,14.69,13.06,13.72,15.5,15.56,14.59,15.38,17.56,18.38,17.53,17.03,19.0,19.69,18.09,16.03,16.06,16.69,15.09,12.84,12.38,13.0,12.03,10.41,10.72,13.41,15.22,14.78,14.28,15.44,15.78,13.41,10.66,10.78,11.53,11.41,11.03,12.75,15.91,17.59,16.91,17.22,19.25,20.69,19.81,19.81,22.12,24.25,23.97,23.09,24.31,26.19,26.31,31.41,31.41,30.38,29.69,30.03,30.03,29.38,28.06,29.25,31.12,31.94,31.94,32.53,32.91,31.69,28.84,26.44,25.62,24.38,22.41,21.38,22.44,24.59,26.03,27.84,31.47,35.41,37.16,37.34,37.34,37.19,35.22,31.81,28.88,27.69,26.97,25.59,25.03,27.25,30.03,31.97,32.97:negativity
46.12,47.5,47.66,49.06,51.5,53.44,53.5,54.31,56.03,56.66,54.84,52.12,50.31,48.56,45.78,42.78,41.94,42.81,43.47,42.81,43.25,44.72,45.41,44.31,43.25,44.0,44.75,43.53,42.22,42.12,42.34,41.28,39.81,40.19,41.78,43.25,43.06,43.84,45.34,46.12,44.78,43.31,43.56,43.75,42.5,40.78,40.41,40.5,39.59,37.56,36.91,37.78,38.53,38.06,39.0,40.84,41.97,40.94,39.53,39.88,40.78,41.06,41.38,43.09,45.41,46.19,45.06,44.31,44.06,43.12,40.5,39.03,39.78,40.62,39.78,39.0,39.38,39.66,38.38,36.41,35.59,35.97,35.56,34.47,34.59,36.66,38.94,39.19,39.47,40.88,41.59,40.12,38.78,38.84,40.03,40.03,39.53,40.16,41.72,42.47,42.09,42.22,43.22,44.19,43.06,42.5,43.44,44.81,44.56,43.34,43.38,43.66,42.66,41.0,40.53,41.88,42.0,40.78,39.41,39.5,39.28,37.12,35.88,36.69,38.69,39.56,40.16,41.97,44.09,44.19,42.19,40.38,39.53,37.94,35.5,34.31,35.66,37.91,38.72,39.38,40.97,42.47,41.88,40.28,39.97,39.91,38.84,37.0,35.59,35.47,35.25,33.5,32.31,31.84,31.75,29.78,27.66,27.34,28.41,28.56,28.31,29.06,30.81,31.41,30.38,30.06,30.81,32.0,31.91,32.34,34.19,36.53,36.03,35.28,35.38,36.81,37.66,37.5,37.81,38.66,38.25,35.69,33.38,32.78,32.12,30.31,29.06,29.19,29.97,29.12,27.91,28.44,30.34,31.66,32.41,34.56,38.41,41.5,43.41,45.31,48.09,49.91,49.12,47.06,46.16,45.28,43.03,40.62,39.59,40.06,39.81,38.34,37.78,38.44,38.38,37.25,36.62,38.06,40.0,40.06,39.84,40.62,41.81,41.16,39.84,39.62,40.56,41.09,40.28,39.84,40.44,40.12,38.09,36.0,35.75,35.97,34.31,32.12,31.09,31.16,30.47,29.69,29.62,31.44,32.28,32.0,32.62,34.5,36.28,36.41,36.69,38.5,40.75,41.44,41.0,41.41,41.94,41.31,39.78,39.28,40.31,40.72,39.75,39.59,41.34,43.09,43.03,43.06,43.66,44.75,43.72,41.16,39.69,39.12,37.31,34.69,32.59,32.75,32.28,30.78,29.94,30.78,32.06,31.66,30.22,29.47,29.09,27.25,24.72,24.09,25.38,26.28,25.72,25.31,26.44,26.69,25.97,25.97,28.44,31.34,32.59,33.22,34.84,37.0,37.41,36.78,36.84,38.22,38.69,38.12,37.22,38.22,38.59,37.12,35.69,35.28,35.5,33.66,31.31,30.12,30.06,29.5,28.44,28.19,29.81,30.41,30.06,30.25,32.72,35.53,37.34,38.56,40.5,41.59,39.91,36.34,33.31,31.78,30.22,28.75,29.38,31.84,33.84,33.88,33.53,34.19,34.5,33.03,31.09,30.59,30.88,30.22,29.03,29.53,31.69,33.0,33.25,34.19,36.62,38.88,39.88,40.44,42.47,43.59,43.25,41.69,41.56,41.91,40.59,37.91,35.72,34.06,32.09,29.47,27.91,29.06,30.78,31.19,31.94,34.12,36.47,37.62,37.84,39.16,40.72,40.5,38.81,37.66,37.31,36.59,35.16,34.38,35.69,37.25,37.66,37.56,38.84,39.78,39.47,37.75,37.38,37.5,36.84,35.5,34.47,35.66,36.25,34.84,33.12,32.62,31.44,29.03,26.72,26.28,26.66,26.5,25.44,25.38,26.59,27.44,27.41,28.12,30.56,33.03,33.44,33.16,34.06,35.03,34.94,34.47,35.78,37.12,37.25,35.41,34.06,33.62,32.97,31.84,32.09,34.88,37.91,39.44,40.5,42.09,42.91,41.41,39.0,37.94,38.06,37.88,37.19,37.12,38.22,38.84,38.25,37.38,37.78,38.5,36.81,34.91,34.53,34.53,34.16,33.44,33.81,35.12,35.62,34.03,32.69,32.31,31.94,30.56,29.84,31.53,33.75,34.56,34.41,35.03,35.84,35.03,33.44,32.62,32.62,32.0,29.5,27.28,26.75,26.47,25.5,25.47,27.56,30.34,31.78,31.84,32.53,33.19,32.28,30.5,29.75,30.56,32.31,33.0,34.06,36.03,36.84,35.0,32.25,30.72,30.06,29.09,28.53,29.75,31.94,33.0,32.19,31.59,31.66,31.41,29.84,28.69,29.44,30.88,30.78,30.59,31.88,33.69,33.81,32.69,32.16,32.12,31.16,29.41,28.59,29.75,31.12,30.59,29.72,30.0,30.5,29.72,28.75,29.53,31.38,32.78,33.59,35.56,38.22,40.22,40.22,39.78,39.91,39.59,37.09,34.19,32.5,31.47,29.56,27.47,27.47,29.0,30.16,30.31,31.25,33.03,33.97,33.0,32.34,33.06,33.97,33.22,31.94,32.06,32.56,31.44,29.09,27.69,27.03,25.75,23.19,22.78,24.41,26.56,27.62,29.06,31.72,34.31,34.47,34.38,35.12,36.03,34.88,32.22,30.03,28.5,26.75,24.28,23.19,24.22,25.62,25.44,25.28,26.5,27.53,26.53,25.19,25.12,25.34,24.09,21.69,20.22,19.84,19.56,18.69,19.56,22.78,26.5,28.34,29.84,31.88,33.22,32.06,29.75,28.41,28.56,28.06,27.41,28.12,30.38,32.0,31.94,32.28,33.66,34.84,33.75,32.41,32.69,33.78,33.78,33.06,32.53,32.19,30.28,27.16,25.31,26.16,27.59,27.97,28.94,31.03,33.03,32.91,32.19,32.47,33.12,32.06,30.34,29.16,29.28,28.78,27.12,25.91,26.22,26.47,25.53,25.06,26.88,29.22,29.81,29.62,30.03,31.06,30.19,28.81,28.75,30.44,31.56,30.72,29.88,30.38,30.31,28.38,26.94,27.09,27.25,26.22,24.53,24.47,25.94,25.88,24.84,25.34,27.0,27.5,26.22,25.16,25.94,26.56,25.66,25.03,26.09,27.31,26.59,24.75,24.19,24.28,23.31,21.44,20.69,22.09,23.69,23.94,24.84,27.91,30.91,31.59,31.66,32.66,34.0,33.19,31.62,30.78,30.94,29.88,27.19,25.25,25.62,26.0,25.22,24.84,25.91,27.25,26.09,24.28,23.84,24.16,22.84,20.75,19.88,20.59,20.44,19.34,18.97,20.72,22.44,22.66,22.78,24.81,26.97,27.22,26.69,26.91,27.09,25.38,22.34,20.22,19.91,19.69,18.84,18.69,20.72,22.5,22.09,20.47,19.75,18.66,16.38,14.03,13.44,14.94,15.56,15.62,16.59,19.09,21.53,22.44,23.81,26.75,29.16,29.5,28.75,29.22,29.5,27.97,25.84,25.0,25.78,26.28,26.5,27.84,30.94,33.44,33.66,32.94,33.19,32.47,29.31,25.81,24.06,24.03,24.19,24.22,26.09,29.72,32.84,34.69,36.91,40.09,41.78,41.03,38.62,37.19,35.38,31.94,27.78,26.34,26.34,25.69,24.25,23.78,24.81,25.28,24.81,25.09,27.75,30.25,31.06,30.91,32.19,33.34,32.88,31.34,30.88,31.34,30.38,27.72,25.5,24.91,23.28,20.44,17.69,17.56,17.5,17.12,16.88,19.34,22.16,23.81,24.0,25.03,26.88,27.62,27.06,27.19,28.38,28.66,26.72,24.53,23.69,23.38,21.16,19.16,18.75,19.0,18.03,16.41,16.47,18.09,18.84,18.66,18.47,19.56,20.34,19.78,19.78,22.38,25.97,28.19,29.12,30.28,30.84,29.31,25.69,23.41,22.66,22.0,20.88,20.56,22.66,23.84,23.09,21.31,21.19,21.78,21.69,21.59,23.91,27.31,29.78,30.53,31.41,32.62,32.72,30.31,28.0,27.56,27.31,25.84,24.22,24.5,25.38,24.72,23.12,23.06,24.38,24.59,23.75,23.28,24.25,24.44,22.38,20.16,19.56,19.16,17.38,15.69,16.06,17.38,17.28,16.41,16.81,18.66,19.19,18.22,17.56,18.31,18.72,17.75,17.34,19.31,21.56,21.94,21.38,21.81,22.16,20.91,18.12,16.41,16.16,15.22,12.97,12.38,14.19,15.78,15.88,15.47,16.44,17.69,17.31,16.56,17.25,19.34,19.62,18.19,16.97,16.66,14.78,10.88,7.5,6.66,6.78,6.75,7.75,11.62,15.91,18.5,20.25,23.19,27.12,30.28,32.03,34.0,35.84,35.31,31.22,26.03,22.16,18.5,14.41,11.62,12.19,13.81,14.75,14.81,15.88,17.28,17.72,17.09,17.59,20.06,22.56,23.56,24.59,26.66,28.22,27.84,27.19,28.5,31.41,33.91,35.34,37.34,39.53,39.66,36.84,33.81,32.09,30.12,26.09,22.62,20.94,19.34,16.16,12.88,11.72,12.03,12.22,12.12,13.72,17.19,20.25,21.78,23.41,26.84,29.75,30.25,30.38,32.31,33.78,33.44,31.97,31.81,31.94,30.88,28.19,26.44,25.72,24.5,21.56,19.28,18.88,19.38,18.78,18.56,20.88,23.88,25.44,26.28,27.81,29.88,30.5,29.19,29.09,30.34,31.41,30.62,30.19,31.09,31.88,30.72,29.66,29.97,30.41,29.38,27.12,26.53,27.09,26.75,24.81,23.78,23.5,22.53,19.94,18.06,17.81,18.25,17.69,17.22,19.03,21.75,23.31,23.84,25.28,27.34,28.78,28.03,27.97,28.66,28.66,26.34,23.81,23.09,22.75,20.97,19.34,18.94,19.25,18.84,17.53,17.47,18.75,19.66,18.88,18.53,19.41,20.12,19.25,18.22,18.78,20.0,20.34,20.41,22.12,24.72,25.66,25.03,24.94,26.25,27.03,26.81,27.69,30.19,32.94,33.53,33.66,33.91,34.0,31.91,29.03,27.25,26.69,25.16,22.75,21.31,21.12,21.19,20.25,20.88,23.62,27.16,29.34,31.03,33.03:54.31,56.03,56.66,54.84,52.12,50.31,48.56,45.78,42.78,41.94,42.81,43.47,42.81,43.25,44.72,45.41,44.31,43.25,44.0,44.75,43.53,42.22,42.12,42.34,41.28,39.81,40.19,41.78,43.25,43.06,43.84,45.34,46.12,44.78,43.31,43.56,43.75,42.5,40.78,40.41,40.5,39.59,37.56,36.91,37.78,38.53,38.06,39.0,40.84,41.97,40.94,39.53,39.88,40.78,41.06,41.38,43.09,45.41,46.19,45.06,44.31,44.06,43.12,40.5,39.03,39.78,40.62,39.78,39.0,39.38,39.66,38.38,36.41,35.59,35.97,35.56,34.47,34.59,36.66,38.94,39.19,39.47,40.88,41.59,40.12,38.78,38.84,40.03,40.03,39.53,40.16,41.72,42.47,42.09,42.22,43.22,44.19,43.06,42.5,43.44,44.81,44.56,43.34,43.38,43.66,42.66,41.0,40.53,41.88,42.0,40.78,39.41,39.5,39.28,37.12,35.88,36.69,38.69,39.56,40.16,41.97,44.09,44.19,42.19,40.38,39.53,37.94,35.5,34.31,35.66,37.91,38.72,39.38,40.97,42.47,41.88,40.28,39.97,39.91,38.84,37.0,35.59,35.47,35.25,33.5,32.31,31.84,31.75,29.78,27.66,27.34,28.41,28.56,28.31,29.06,30.81,31.41,30.38,30.06,30.81,32.0,31.91,32.34,34.19,36.53,36.03,35.28,35.38,36.81,37.66,37.5,37.81,38.66,38.25,35.69,33.38,32.78,32.12,30.31,29.06,29.19,29.97,29.12,27.91,28.44,30.34,31.66,32.41,34.56,38.41,41.5,43.41,45.31,48.09,49.91,49.12,47.06,46.16,45.28,43.03,40.62,39.59,40.06,39.81,38.34,37.78,38.44,38.38,37.25,36.62,38.06,40.0,40.06,39.84,40.62,41.81,41.16,39.84,39.62,40.56,41.09,40.28,39.84,40.44,40.12,38.09,36.0,35.75,35.97,34.31,32.12,31.09,31.16,30.47,29.69,29.62,31.44,32.28,32.0,32.62,34.5,36.28,36.41,36.69,38.5,40.75,41.44,41.0,41.41,41.94,41.31,39.78,39.28,40.31,40.72,39.75,39.59,41.34,43.09,43.03,43.06,43.66,44.75,43.72,41.16,39.69,39.12,37.31,34.69,32.59,32.75,32.28,30.78,29.94,30.78,32.06,31.66,30.22,29.47,29.09,27.25,24.72,24.09,25.38,26.28,25.72,25.31,26.44,26.69,25.97,25.97,28.44,31.34,32.59,33.22,34.84,37.0,37.41,36.78,36.84,38.22,38.69,38.12,37.22,38.22,38.59,37.12,35.69,35.28,35.5,33.66,31.31,30.12,30.06,29.5,28.44,28.19,29.81,30.41,30.06,30.25,32.72,35.53,37.34,38.56,40.5,41.59,39.91,36.34,33.31,31.78,30.22,28.75,29.38,31.84,33.84,33.88,33.53,34.19,34.5,33.03,31.09,30.59,30.88,30.22,29.03,29.53,31.69,33.0,33.25,34.19,36.62,38.88,39.88,40.44,42.47,43.59,43.25,41.69,41.56,41.91,40.59,37.91,35.72,34.06,32.09,29.47,27.91,29.06,30.78,31.19,31.94,34.12,36.47,37.62,37.84,39.16,40.72,40.5,38.81,37.66,37.31,36.59,35.16,34.38,35.69,37.25,37.66,37.56,38.84,39.78,39.47,37.75,37.38,37.5,36.84,35.5,34.47,35.66,36.25,34.84,33.12,32.62,31.44,29.03,26.72,26.28,26.66,26.5,25.44,25.38,26.59,27.44,27.41,28.12,30.56,33.03,33.44,33.16,34.06,35.03,34.94,34.47,35.78,37.12,37.25,35.41,34.06,33.62,32.97,31.84,32.09,34.88,37.91,39.44,40.5,42.09,42.91,41.41,39.0,37.94,38.06,37.88,37.19,37.12,38.22,38.84,38.25,37.38,37.78,38.5,36.81,34.91,34.53,34.53,34.16,33.44,33.81,35.12,35.62,34.03,32.69,32.31,31.94,30.56,29.84,31.53,33.75,34.56,34.41,35.03,35.84,35.03,33.44,32.62,32.62,32.0,29.5,27.28,26.75,26.47,25.5,25.47,27.56,30.34,31.78,31.84,32.53,33.19,32.28,30.5,29.75,30.56,32.31,33.0,34.06,36.03,36.84,35.0,32.25,30.72,30.06,29.09,28.53,29.75,31.94,33.0,32.19,31.59,31.66,31.41,29.84,28.69,29.44,30.88,30.78,30.59,31.88,33.69,33.81,32.69,32.16,32.12,31.16,29.41,28.59,29.75,31.12,30.59,29.72,30.0,30.5,29.72,28.75,29.53,31.38,32.78,33.59,35.56,38.22,40.22,40.22,39.78,39.91,39.59,37.09,34.19,32.5,31.47,29.56,27.47,27.47,29.0,30.16,30.31,31.25,33.03,33.97,33.0,32.34,33.06,33.97,33.22,31.94,32.06,32.56,31.44,29.09,27.69,27.03,25.75,23.19,22.78,24.41,26.56,27.62,29.06,31.72,34.31,34.47,34.38,35.12,36.03,34.88,32.22,30.03,28.5,26.75,24.28,23.19,24.22,25.62,25.44,25.28,26.5,27.53,26.53,25.19,25.12,25.34,24.09,21.69,20.22,19.84,19.56,18.69,19.56,22.78,26.5,28.34,29.84,31.88,33.22,32.06,29.75,28.41,28.56,28.06,27.41,28.12,30.38,32.0,31.94,32.28,33.66,34.84,33.75,32.41,32.69,33.78,33.78,33.06,32.53,32.19,30.28,27.16,25.31,26.16,27.59,27.97,28.94,31.03,33.03,32.91,32.19,32.47,33.12,32.06,30.34,29.16,29.28,28.78,27.12,25.91,26.22,26.47,25.53,25.06,26.88,29.22,29.81,29.62,30.03,31.06,30.19,28.81,28.75,30.44,31.56,30.72,29.88,30.38,30.31,28.38,26.94,27.09,27.25,26.22,24.53,24.47,25.94,25.88,24.84,25.34,27.0,27.5,26.22,25.16,25.94,26.56,25.66,25.03,26.09,27.31,26.59,24.75,24.19,24.28,23.31,21.44,20.69,22.09,23.69,23.94,24.84,27.91,30.91,31.59,31.66,32.66,34.0,33.19,31.62,30.78,30.94,29.88,27.19,25.25,25.62,26.0,25.22,24.84,25.91,27.25,26.09,24.28,23.84,24.16,22.84,20.75,19.88,20.59,20.44,19.34,18.97,20.72,22.44,22.66,22.78,24.81,26.97,27.22,26.69,26.91,27.09,25.38,22.34,20.22,19.91,19.69,18.84,18.69,20.72,22.5,22.09,20.47,19.75,18.66,16.38,14.03,13.44,14.94,15.56,15.62,16.59,19.09,21.53,22.44,23.81,26.75,29.16,29.5,28.75,29.22,29.5,27.97,25.84,25.0,25.78,26.28,26.5,27.84,30.94,33.44,33.66,32.94,33.19,32.47,29.31,25.81,24.06,24.03,24.19,24.22,26.09,29.72,32.84,34.69,36.91,40.09,41.78,41.03,38.62,37.19,35.38,31.94,27.78,26.34,26.34,25.69,24.25,23.78,24.81,25.28,24.81,25.09,27.75,30.25,31.06,30.91,32.19,33.34,32.88,31.34,30.88,31.34,30.38,27.72,25.5,24.91,23.28,20.44,17.69,17.56,17.5,17.12,16.88,19.34,22.16,23.81,24.0,25.03,26.88,27.62,27.06,27.19,28.38,28.66,26.72,24.53,23.69,23.38,21.16,19.16,18.75,19.0,18.03,16.41,16.47,18.09,18.84,18.66,18.47,19.56,20.34,19.78,19.78,22.38,25.97,28.19,29.12,30.28,30.84,29.31,25.69,23.41,22.66,22.0,20.88,20.56,22.66,23.84,23.09,21.31,21.19,21.78,21.69,21.59,23.91,27.31,29.78,30.53,31.41,32.62,32.72,30.31,28.0,27.56,27.31,25.84,24.22,24.5,25.38,24.72,23.12,23.06,24.38,24.59,23.75,23.28,24.25,24.44,22.38,20.16,19.56,19.16,17.38,15.69,16.06,17.38,17.28,16.41,16.81,18.66,19.19,18.22,17.56,18.31,18.72,17.75,17.34,19.31,21.56,21.94,21.38,21.81,22.16,20.91,18.12,16.41,16.16,15.22,12.97,12.38,14.19,15.78,15.88,15.47,16.44,17.69,17.31,16.56,17.25,19.34,19.62,18.19,16.97,16.66,14.78,10.88,7.5,6.66,6.78,6.75,7.75,11.62,15.91,18.5,20.25,23.19,27.12,30.28,32.03,34.0,35.84,35.31,31.22,26.03,22.16,18.5,14.41,11.62,12.19,13.81,14.75,14.81,15.88,17.28,17.72,17.09,17.59,20.06,22.56,23.56,24.59,26.66,28.22,27.84,27.19,28.5,31.41,33.91,35.34,37.34,39.53,39.66,36.84,33.81,32.09,30.12,26.09,22.62,20.94,19.34,16.16,12.88,11.72,12.03,12.22,12.12,13.72,17.19,20.25,21.78,23.41,26.84,29.75,30.25,30.38,32.31,33.78,33.44,31.97,31.81,31.94,30.88,28.19,26.44,25.72,24.5,21.56,19.28,18.88,19.38,18.78,18.56,20.88,23.88,25.44,26.28,27.81,29.88,30.5,29.19,29.09,30.34,31.41,30.62,30.19,31.09,31.88,30.72,29.66,29.97,30.41,29.38,27.12,26.53,27.09,26.75,24.81,23.78,23.5,22.53,19.94,18.06,17.81,18.25,17.69,17.22,19.03,21.75,23.31,23.84,25.28,27.34,28.78,28.03,27.97,28.66,28.66,26.34,23.81,23.09,22.75,20.97,19.34,18.94,19.25,18.84,17.53,17.47,18.75,19.66,18.88,18.53,19.41,20.12,19.25,18.22,18.78,20.0,20.34,20.41,22.12,24.72,25.66,25.03,24.94,26.25,27.03,26.81,27.69,30.19,32.94,33.53,33.66,33.91,34.0,31.91,29.03,27.25,26.69,25.16,22.75,21.31,21.12,21.19,20.25,20.88,23.62,27.16,29.34,31.03,33.03,62.75,63.41,64.03,64.09,64.16,65.03,66.16:45.78,42.78,41.94,42.81,43.47,42.81,43.25,44.72,45.41,44.31,43.25,44.0,44.75,43.53,42.22,42.12,42.34,41.28,39.81,40.19,41.78,43.25,43.06,43.84,45.34,46.12,44.78,43.31,43.56,43.75,42.5,40.78,40.41,40.5,39.59,37.56,36.91,37.78,38.53,38.06,39.0,40.84,41.97,40.94,39.53,39.88,40.78,41.06,41.38,43.09,45.41,46.19,45.06,44.31,44.06,43.12,40.5,39.03,39.78,40.62,39.78,39.0,39.38,39.66,38.38,36.41,35.59,35.97,35.56,34.47,34.59,36.66,38.94,39.19,39.47,40.88,41.59,40.12,38.78,38.84,40.03,40.03,39.53,40.16,41.72,42.47,42.09,42.22,43.22,44.19,43.06,42.5,43.44,44.81,44.56,43.34,43.38,43.66,42.66,41.0,40.53,41.88,42.0,40.78,39.41,39.5,39.28,37.12,35.88,36.69,38.69,39.56,40.16,41.97,44.09,44.19,42.19,40.38,39.53,37.94,35.5,34.31,35.66,37.91,38.72,39.38,40.97,42.47,41.88,40.28,39.97,39.91,38.84,37.0,35.59,35.47,35.25,33.5,32.31,31.84,31.75,29.78,27.66,27.34,28.41,28.56,28.31,29.06,30.81,31.41,30.38,30.06,30.81,32.0,31.91,32.34,34.19,36.53,36.03,35.28,35.38,36.81,37.66,37.5,37.81,38.66,38.25,35.69,33.38,32.78,32.12,30.31,29.06,29.19,29.97,29.12,27.91,28.44,30.34,31.66,32.41,34.56,38.41,41.5,43.41,45.31,48.09,49.91,49.12,47.06,46.16,45.28,43.03,40.62,39.59,40.06,39.81,38.34,37.78,38.44,38.38,37.25,36.62,38.06,40.0,40.06,39.84,40.62,41.81,41.16,39.84,39.62,40.56,41.09,40.28,39.84,40.44,40.12,38.09,36.0,35.75,35.97,34.31,32.12,31.09,31.16,30.47,29.69,29.62,31.44,32.28,32.0,32.62,34.5,36.28,36.41,36.69,38.5,40.75,41.44,41.0,41.41,41.94,41.31,39.78,39.28,40.31,40.72,39.75,39.59,41.34,43.09,43.03,43.06,43.66,44.75,43.72,41.16,39.69,39.12,37.31,34.69,32.59,32.75,32.28,30.78,29.94,30.78,32.06,31.66,30.22,29.47,29.09,27.25,24.72,24.09,25.38,26.28,25.72,25.31,26.44,26.69,25.97,25.97,28.44,31.34,32.59,33.22,34.84,37.0,37.41,36.78,36.84,38.22,38.69,38.12,37.22,38.22,38.59,37.12,35.69,35.28,35.5,33.66,31.31,30.12,30.06,29.5,28.44,28.19,29.81,30.41,30.06,30.25,32.72,35.53,37.34,38.56,40.5,41.59,39.91,36.34,33.31,31.78,30.22,28.75,29.38,31.84,33.84,33.88,33.53,34.19,34.5,33.03,31.09,30.59,30.88,30.22,29.03,29.53,31.69,33.0,33.25,34.19,36.62,38.88,39.88,40.44,42.47,43.59,43.25,41.69,41.56,41.91,40.59,37.91,35.72,34.06,32.09,29.47,27.91,29.06,30.78,31.19,31.94,34.12,36.47,37.62,37.84,39.16,40.72,40.5,38.81,37.66,37.31,36.59,35.16,34.38,35.69,37.25,37.66,37.56,38.84,39.78,39.47,37.75,37.38,37.5,36.84,35.5,34.47,35.66,36.25,34.84,33.12,32.62,31.44,29.03,26.72,26.28,26.66,26.5,25.44,25.38,26.59,27.44,27.41,28.12,30.56,33.03,33.44,33.16,34.06,35.03,34.94,34.47,35.78,37.12,37.25,35.41,34.06,33.62,32.97,31.84,32.09,34.88,37.91,39.44,40.5,42.09,42.91,41.41,39.0,37.94,38.06,37.88,37.19,37.12,38.22,38.84,38.25,37.38,37.78,38.5,36.81,34.91,34.53,34.53,34.16,33.44,33.81,35.12,35.62,34.03,32.69,32.31,31.94,30.56,29.84,31.53,33.75,34.56,34.41,35.03,35.84,35.03,33.44,32.62,32.62,32.0,29.5,27.28,26.75,26.47,25.5,25.47,27.56,30.34,31.78,31.84,32.53,33.19,32.28,30.5,29.75,30.56,32.31,33.0,34.06,36.03,36.84,35.0,32.25,30.72,30.06,29.09,28.53,29.75,31.94,33.0,32.19,31.59,31.66,31.41,29.84,28.69,29.44,30.88,30.78,30.59,31.88,33.69,33.81,32.69,32.16,32.12,31.16,29.41,28.59,29.75,31.12,30.59,29.72,30.0,30.5,29.72,28.75,29.53,31.38,32.78,33.59,35.56,38.22,40.22,40.22,39.78,39.91,39.59,37.09,34.19,32.5,31.47,29.56,27.47,27.47,29.0,30.16,30.31,31.25,33.03,33.97,33.0,32.34,33.06,33.97,33.22,31.94,32.06,32.56,31.44,29.09,27.69,27.03,25.75,23.19,22.78,24.41,26.56,27.62,29.06,31.72,34.31,34.47,34.38,35.12,36.03,34.88,32.22,30.03,28.5,26.75,24.28,23.19,24.22,25.62,25.44,25.28,26.5,27.53,26.53,25.19,25.12,25.34,24.09,21.69,20.22,19.84,19.56,18.69,19.56,22.78,26.5,28.34,29.84,31.88,33.22,32.06,29.75,28.41,28.56,28.06,27.41,28.12,30.38,32.0,31.94,32.28,33.66,34.84,33.75,32.41,32.69,33.78,33.78,33.06,32.53,32.19,30.28,27.16,25.31,26.16,27.59,27.97,28.94,31.03,33.03,32.91,32.19,32.47,33.12,32.06,30.34,29.16,29.28,28.78,27.12,25.91,26.22,26.47,25.53,25.06,26.88,29.22,29.81,29.62,30.03,31.06,30.19,28.81,28.75,30.44,31.56,30.72,29.88,30.38,30.31,28.38,26.94,27.09,27.25,26.22,24.53,24.47,25.94,25.88,24.84,25.34,27.0,27.5,26.22,25.16,25.94,26.56,25.66,25.03,26.09,27.31,26.59,24.75,24.19,24.28,23.31,21.44,20.69,22.09,23.69,23.94,24.84,27.91,30.91,31.59,31.66,32.66,34.0,33.19,31.62,30.78,30.94,29.88,27.19,25.25,25.62,26.0,25.22,24.84,25.91,27.25,26.09,24.28,23.84,24.16,22.84,20.75,19.88,20.59,20.44,19.34,18.97,20.72,22.44,22.66,22.78,24.81,26.97,27.22,26.69,26.91,27.09,25.38,22.34,20.22,19.91,19.69,18.84,18.69,20.72,22.5,22.09,20.47,19.75,18.66,16.38,14.03,13.44,14.94,15.56,15.62,16.59,19.09,21.53,22.44,23.81,26.75,29.16,29.5,28.75,29.22,29.5,27.97,25.84,25.0,25.78,26.28,26.5,27.84,30.94,33.44,33.66,32.94,33.19,32.47,29.31,25.81,24.06,24.03,24.19,24.22,26.09,29.72,32.84,34.69,36.91,40.09,41.78,41.03,38.62,37.19,35.38,31.94,27.78,26.34,26.34,25.69,24.25,23.78,24.81,25.28,24.81,25.09,27.75,30.25,31.06,30.91,32.19,33.34,32.88,31.34,30.88,31.34,30.38,27.72,25.5,24.91,23.28,20.44,17.69,17.56,17.5,17.12,16.88,19.34,22.16,23.81,24.0,25.03,26.88,27.62,27.06,27.19,28.38,28.66,26.72,24.53,23.69,23.38,21.16,19.16,18.75,19.0,18.03,16.41,16.47,18.09,18.84,18.66,18.47,19.56,20.34,19.78,19.78,22.38,25.97,28.19,29.12,30.28,30.84,29.31,25.69,23.41,22.66,22.0,20.88,20.56,22.66,23.84,23.09,21.31,21.19,21.78,21.69,21.59,23.91,27.31,29.78,30.53,31.41,32.62,32.72,30.31,28.0,27.56,27.31,25.84,24.22,24.5,25.38,24.72,23.12,23.06,24.38,24.59,23.75,23.28,24.25,24.44,22.38,20.16,19.56,19.16,17.38,15.69,16.06,17.38,17.28,16.41,16.81,18.66,19.19,18.22,17.56,18.31,18.72,17.75,17.34,19.31,21.56,21.94,21.38,21.81,22.16,20.91,18.12,16.41,16.16,15.22,12.97,12.38,14.19,15.78,15.88,15.47,16.44,17.69,17.31,16.56,17.25,19.34,19.62,18.19,16.97,16.66,14.78,10.88,7.5,6.66,6.78,6.75,7.75,11.62,15.91,18.5,20.25,23.19,27.12,30.28,32.03,34.0,35.84,35.31,31.22,26.03,22.16,18.5,14.41,11.62,12.19,13.81,14.75,14.81,15.88,17.28,17.72,17.09,17.59,20.06,22.56,23.56,24.59,26.66,28.22,27.84,27.19,28.5,31.41,33.91,35.34,37.34,39.53,39.66,36.84,33.81,32.09,30.12,26.09,22.62,20.94,19.34,16.16,12.88,11.72,12.03,12.22,12.12,13.72,17.19,20.25,21.78,23.41,26.84,29.75,30.25,30.38,32.31,33.78,33.44,31.97,31.81,31.94,30.88,28.19,26.44,25.72,24.5,21.56,19.28,18.88,19.38,18.78,18.56,20.88,23.88,25.44,26.28,27.81,29.88,30.5,29.19,29.09,30.34,31.41,30.62,30.19,31.09,31.88,30.72,29.66,29.97,30.41,29.38,27.12,26.53,27.09,26.75,24.81,23.78,23.5,22.53,19.94,18.06,17.81,18.25,17.69,17.22,19.03,21.75,23.31,23.84,25.28,27.34,28.78,28.03,27.97,28.66,28.66,26.34,23.81,23.09,22.75,20.97,19.34,18.94,19.25,18.84,17.53,17.47,18.75,19.66,18.88,18.53,19.41,20.12,19.25,18.22,18.78,20.0,20.34,20.41,22.12,24.72,25.66,25.03,24.94,26.25,27.03,26.81,27.69,30.19,32.94,33.53,33.66,33.91,34.0,31.91,29.03,27.25,26.69,25.16,22.75,21.31,21.12,21.19,20.25,20.88,23.62,27.16,29.34,31.03,33.03,62.75,63.41,64.03,64.09,64.16,65.03,66.16,67.25,68.09,68.5,68.75,68.06,66.53,64.88:44.72,45.41,44.31,43.25,44.0,44.75,43.53,42.22,42.12,42.34,41.28,39.81,40.19,41.78,43.25,43.06,43.84,45.34,46.12,44.78,43.31,43.56,43.75,42.5,40.78,40.41,40.5,39.59,37.56,36.91,37.78,38.53,38.06,39.0,40.84,41.97,40.94,39.53,39.88,40.78,41.06,41.38,43.09,45.41,46.19,45.06,44.31,44.06,43.12,40.5,39.03,39.78,40.62,39.78,39.0,39.38,39.66,38.38,36.41,35.59,35.97,35.56,34.47,34.59,36.66,38.94,39.19,39.47,40.88,41.59,40.12,38.78,38.84,40.03,40.03,39.53,40.16,41.72,42.47,42.09,42.22,43.22,44.19,43.06,42.5,43.44,44.81,44.56,43.34,43.38,43.66,42.66,41.0,40.53,41.88,42.0,40.78,39.41,39.5,39.28,37.12,35.88,36.69,38.69,39.56,40.16,41.97,44.09,44.19,42.19,40.38,39.53,37.94,35.5,34.31,35.66,37.91,38.72,39.38,40.97,42.47,41.88,40.28,39.97,39.91,38.84,37.0,35.59,35.47,35.25,33.5,32.31,31.84,31.75,29.78,27.66,27.34,28.41,28.56,28.31,29.06,30.81,31.41,30.38,30.06,30.81,32.0,31.91,32.34,34.19,36.53,36.03,35.28,35.38,36.81,37.66,37.5,37.81,38.66,38.25,35.69,33.38,32.78,32.12,30.31,29.06,29.19,29.97,29.12,27.91,28.44,30.34,31.66,32.41,34.56,38.41,41.5,43.41,45.31,48.09,49.91,49.12,47.06,46.16,45.28,43.03,40.62,39.59,40.06,39.81,38.34,37.78,38.44,38.38,37.25,36.62,38.06,40.0,40.06,39.84,40.62,41.81,41.16,39.84,39.62,40.56,41.09,40.28,39.84,40.44,40.12,38.09,36.0,35.75,35.97,34.31,32.12,31.09,31.16,30.47,29.69,29.62,31.44,32.28,32.0,32.62,34.5,36.28,36.41,36.69,38.5,40.75,41.44,41.0,41.41,41.94,41.31,39.78,39.28,40.31,40.72,39.75,39.59,41.34,43.09,43.03,43.06,43.66,44.75,43.72,41.16,39.69,39.12,37.31,34.69,32.59,32.75,32.28,30.78,29.94,30.78,32.06,31.66,30.22,29.47,29.09,27.25,24.72,24.09,25.38,26.28,25.72,25.31,26.44,26.69,25.97,25.97,28.44,31.34,32.59,33.22,34.84,37.0,37.41,36.78,36.84,38.22,38.69,38.12,37.22,38.22,38.59,37.12,35.69,35.28,35.5,33.66,31.31,30.12,30.06,29.5,28.44,28.19,29.81,30.41,30.06,30.25,32.72,35.53,37.34,38.56,40.5,41.59,39.91,36.34,33.31,31.78,30.22,28.75,29.38,31.84,33.84,33.88,33.53,34.19,34.5,33.03,31.09,30.59,30.88,30.22,29.03,29.53,31.69,33.0,33.25,34.19,36.62,38.88,39.88,40.44,42.47,43.59,43.25,41.69,41.56,41.91,40.59,37.91,35.72,34.06,32.09,29.47,27.91,29.06,30.78,31.19,31.94,34.12,36.47,37.62,37.84,39.16,40.72,40.5,38.81,37.66,37.31,36.59,35.16,34.38,35.69,37.25,37.66,37.56,38.84,39.78,39.47,37.75,37.38,37.5,36.84,35.5,34.47,35.66,36.25,34.84,33.12,32.62,31.44,29.03,26.72,26.28,26.66,26.5,25.44,25.38,26.59,27.44,27.41,28.12,30.56,33.03,33.44,33.16,34.06,35.03,34.94,34.47,35.78,37.12,37.25,35.41,34.06,33.62,32.97,31.84,32.09,34.88,37.91,39.44,40.5,42.09,42.91,41.41,39.0,37.94,38.06,37.88,37.19,37.12,38.22,38.84,38.25,37.38,37.78,38.5,36.81,34.91,34.53,34.53,34.16,33.44,33.81,35.12,35.62,34.03,32.69,32.31,31.94,30.56,29.84,31.53,33.75,34.56,34.41,35.03,35.84,35.03,33.44,32.62,32.62,32.0,29.5,27.28,26.75,26.47,25.5,25.47,27.56,30.34,31.78,31.84,32.53,33.19,32.28,30.5,29.75,30.56,32.31,33.0,34.06,36.03,36.84,35.0,32.25,30.72,30.06,29.09,28.53,29.75,31.94,33.0,32.19,31.59,31.66,31.41,29.84,28.69,29.44,30.88,30.78,30.59,31.88,33.69,33.81,32.69,32.16,32.12,31.16,29.41,28.59,29.75,31.12,30.59,29.72,30.0,30.5,29.72,28.75,29.53,31.38,32.78,33.59,35.56,38.22,40.22,40.22,39.78,39.91,39.59,37.09,34.19,32.5,31.47,29.56,27.47,27.47,29.0,30.16,30.31,31.25,33.03,33.97,33.0,32.34,33.06,33.97,33.22,31.94,32.06,32.56,31.44,29.09,27.69,27.03,25.75,23.19,22.78,24.41,26.56,27.62,29.06,31.72,34.31,34.47,34.38,35.12,36.03,34.88,32.22,30.03,28.5,26.75,24.28,23.19,24.22,25.62,25.44,25.28,26.5,27.53,26.53,25.19,25.12,25.34,24.09,21.69,20.22,19.84,19.56,18.69,19.56,22.78,26.5,28.34,29.84,31.88,33.22,32.06,29.75,28.41,28.56,28.06,27.41,28.12,30.38,32.0,31.94,32.28,33.66,34.84,33.75,32.41,32.69,33.78,33.78,33.06,32.53,32.19,30.28,27.16,25.31,26.16,27.59,27.97,28.94,31.03,33.03,32.91,32.19,32.47,33.12,32.06,30.34,29.16,29.28,28.78,27.12,25.91,26.22,26.47,25.53,25.06,26.88,29.22,29.81,29.62,30.03,31.06,30.19,28.81,28.75,30.44,31.56,30.72,29.88,30.38,30.31,28.38,26.94,27.09,27.25,26.22,24.53,24.47,25.94,25.88,24.84,25.34,27.0,27.5,26.22,25.16,25.94,26.56,25.66,25.03,26.09,27.31,26.59,24.75,24.19,24.28,23.31,21.44,20.69,22.09,23.69,23.94,24.84,27.91,30.91,31.59,31.66,32.66,34.0,33.19,31.62,30.78,30.94,29.88,27.19,25.25,25.62,26.0,25.22,24.84,25.91,27.25,26.09,24.28,23.84,24.16,22.84,20.75,19.88,20.59,20.44,19.34,18.97,20.72,22.44,22.66,22.78,24.81,26.97,27.22,26.69,26.91,27.09,25.38,22.34,20.22,19.91,19.69,18.84,18.69,20.72,22.5,22.09,20.47,19.75,18.66,16.38,14.03,13.44,14.94,15.56,15.62,16.59,19.09,21.53,22.44,23.81,26.75,29.16,29.5,28.75,29.22,29.5,27.97,25.84,25.0,25.78,26.28,26.5,27.84,30.94,33.44,33.66,32.94,33.19,32.47,29.31,25.81,24.06,24.03,24.19,24.22,26.09,29.72,32.84,34.69,36.91,40.09,41.78,41.03,38.62,37.19,35.38,31.94,27.78,26.34,26.34,25.69,24.25,23.78,24.81,25.28,24.81,25.09,27.75,30.25,31.06,30.91,32.19,33.34,32.88,31.34,30.88,31.34,30.38,27.72,25.5,24.91,23.28,20.44,17.69,17.56,17.5,17.12,16.88,19.34,22.16,23.81,24.0,25.03,26.88,27.62,27.06,27.19,28.38,28.66,26.72,24.53,23.69,23.38,21.16,19.16,18.75,19.0,18.03,16.41,16.47,18.09,18.84,18.66,18.47,19.56,20.34,19.78,19.78,22.38,25.97,28.19,29.12,30.28,30.84,29.31,25.69,23.41,22.66,22.0,20.88,20.56,22.66,23.84,23.09,21.31,21.19,21.78,21.69,21.59,23.91,27.31,29.78,30.53,31.41,32.62,32.72,30.31,28.0,27.56,27.31,25.84,24.22,24.5,25.38,24.72,23.12,23.06,24.38,24.59,23.75,23.28,24.25,24.44,22.38,20.16,19.56,19.16,17.38,15.69,16.06,17.38,17.28,16.41,16.81,18.66,19.19,18.22,17.56,18.31,18.72,17.75,17.34,19.31,21.56,21.94,21.38,21.81,22.16,20.91,18.12,16.41,16.16,15.22,12.97,12.38,14.19,15.78,15.88,15.47,16.44,17.69,17.31,16.56,17.25,19.34,19.62,18.19,16.97,16.66,14.78,10.88,7.5,6.66,6.78,6.75,7.75,11.62,15.91,18.5,20.25,23.19,27.12,30.28,32.03,34.0,35.84,35.31,31.22,26.03,22.16,18.5,14.41,11.62,12.19,13.81,14.75,14.81,15.88,17.28,17.72,17.09,17.59,20.06,22.56,23.56,24.59,26.66,28.22,27.84,27.19,28.5,31.41,33.91,35.34,37.34,39.53,39.66,36.84,33.81,32.09,30.12,26.09,22.62,20.94,19.34,16.16,12.88,11.72,12.03,12.22,12.12,13.72,17.19,20.25,21.78,23.41,26.84,29.75,30.25,30.38,32.31,33.78,33.44,31.97,31.81,31.94,30.88,28.19,26.44,25.72,24.5,21.56,19.28,18.88,19.38,18.78,18.56,20.88,23.88,25.44,26.28,27.81,29.88,30.5,29.19,29.09,30.34,31.41,30.62,30.19,31.09,31.88,30.72,29.66,29.97,30.41,29.38,27.12,26.53,27.09,26.75,24.81,23.78,23.5,22.53,19.94,18.06,17.81,18.25,17.69,17.22,19.03,21.75,23.31,23.84,25.28,27.34,28.78,28.03,27.97,28.66,28.66,26.34,23.81,23.09,22.75,20.97,19.34,18.94,19.25,18.84,17.53,17.47,18.75,19.66,18.88,18.53,19.41,20.12,19.25,18.22,18.78,20.0,20.34,20.41,22.12,24.72,25.66,25.03,24.94,26.25,27.03,26.81,27.69,30.19,32.94,33.53,33.66,33.91,34.0,31.91,29.03,27.25,26.69,25.16,22.75,21.31,21.12,21.19,20.25,20.88,23.62,27.16,29.34,31.03,33.03,62.75,63.41,64.03,64.09,64.16,65.03,66.16,67.25,68.09,68.5,68.75,68.06,66.53,64.88,63.69,62.81,62.41,62.81,64.03,64.94,65.53:42.22,42.12,42.34,41.28,39.81,40.19,41.78,43.25,43.06,43.84,45.34,46.12,44.78,43.31,43.56,43.75,42.5,40.78,40.41,40.5,39.59,37.56,36.91,37.78,38.53,38.06,39.0,40.84,41.97,40.94,39.53,39.88,40.78,41.06,41.38,43.09,45.41,46.19,45.06,44.31,44.06,43.12,40.5,39.03,39.78,40.62,39.78,39.0,39.38,39.66,38.38,36.41,35.59,35.97,35.56,34.47,34.59,36.66,38.94,39.19,39.47,40.88,41.59,40.12,38.78,38.84,40.03,40.03,39.53,40.16,41.72,42.47,42.09,42.22,43.22,44.19,43.06,42.5,43.44,44.81,44.56,43.34,43.38,43.66,42.66,41.0,40.53,41.88,42.0,40.78,39.41,39.5,39.28,37.12,35.88,36.69,38.69,39.56,40.16,41.97,44.09,44.19,42.19,40.38,39.53,37.94,35.5,34.31,35.66,37.91,38.72,39.38,40.97,42.47,41.88,40.28,39.97,39.91,38.84,37.0,35.59,35.47,35.25,33.5,32.31,31.84,31.75,29.78,27.66,27.34,28.41,28.56,28.31,29.06,30.81,31.41,30.38,30.06,30.81,32.0,31.91,32.34,34.19,36.53,36.03,35.28,35.38,36.81,37.66,37.5,37.81,38.66,38.25,35.69,33.38,32.78,32.12,30.31,29.06,29.19,29.97,29.12,27.91,28.44,30.34,31.66,32.41,34.56,38.41,41.5,43.41,45.31,48.09,49.91,49.12,47.06,46.16,45.28,43.03,40.62,39.59,40.06,39.81,38.34,37.78,38.44,38.38,37.25,36.62,38.06,40.0,40.06,39.84,40.62,41.81,41.16,39.84,39.62,40.56,41.09,40.28,39.84,40.44,40.12,38.09,36.0,35.75,35.97,34.31,32.12,31.09,31.16,30.47,29.69,29.62,31.44,32.28,32.0,32.62,34.5,36.28,36.41,36.69,38.5,40.75,41.44,41.0,41.41,41.94,41.31,39.78,39.28,40.31,40.72,39.75,39.59,41.34,43.09,43.03,43.06,43.66,44.75,43.72,41.16,39.69,39.12,37.31,34.69,32.59,32.75,32.28,30.78,29.94,30.78,32.06,31.66,30.22,29.47,29.09,27.25,24.72,24.09,25.38,26.28,25.72,25.31,26.44,26.69,25.97,25.97,28.44,31.34,32.59,33.22,34.84,37.0,37.41,36.78,36.84,38.22,38.69,38.12,37.22,38.22,38.59,37.12,35.69,35.28,35.5,33.66,31.31,30.12,30.06,29.5,28.44,28.19,29.81,30.41,30.06,30.25,32.72,35.53,37.34,38.56,40.5,41.59,39.91,36.34,33.31,31.78,30.22,28.75,29.38,31.84,33.84,33.88,33.53,34.19,34.5,33.03,31.09,30.59,30.88,30.22,29.03,29.53,31.69,33.0,33.25,34.19,36.62,38.88,39.88,40.44,42.47,43.59,43.25,41.69,41.56,41.91,40.59,37.91,35.72,34.06,32.09,29.47,27.91,29.06,30.78,31.19,31.94,34.12,36.47,37.62,37.84,39.16,40.72,40.5,38.81,37.66,37.31,36.59,35.16,34.38,35.69,37.25,37.66,37.56,38.84,39.78,39.47,37.75,37.38,37.5,36.84,35.5,34.47,35.66,36.25,34.84,33.12,32.62,31.44,29.03,26.72,26.28,26.66,26.5,25.44,25.38,26.59,27.44,27.41,28.12,30.56,33.03,33.44,33.16,34.06,35.03,34.94,34.47,35.78,37.12,37.25,35.41,34.06,33.62,32.97,31.84,32.09,34.88,37.91,39.44,40.5,42.09,42.91,41.41,39.0,37.94,38.06,37.88,37.19,37.12,38.22,38.84,38.25,37.38,37.78,38.5,36.81,34.91,34.53,34.53,34.16,33.44,33.81,35.12,35.62,34.03,32.69,32.31,31.94,30.56,29.84,31.53,33.75,34.56,34.41,35.03,35.84,35.03,33.44,32.62,32.62,32.0,29.5,27.28,26.75,26.47,25.5,25.47,27.56,30.34,31.78,31.84,32.53,33.19,32.28,30.5,29.75,30.56,32.31,33.0,34.06,36.03,36.84,35.0,32.25,30.72,30.06,29.09,28.53,29.75,31.94,33.0,32.19,31.59,31.66,31.41,29.84,28.69,29.44,30.88,30.78,30.59,31.88,33.69,33.81,32.69,32.16,32.12,31.16,29.41,28.59,29.75,31.12,30.59,29.72,30.0,30.5,29.72,28.75,29.53,31.38,32.78,33.59,35.56,38.22,40.22,40.22,39.78,39.91,39.59,37.09,34.19,32.5,31.47,29.56,27.47,27.47,29.0,30.16,30.31,31.25,33.03,33.97,33.0,32.34,33.06,33.97,33.22,31.94,32.06,32.56,31.44,29.09,27.69,27.03,25.75,23.19,22.78,24.41,26.56,27.62,29.06,31.72,34.31,34.47,34.38,35.12,36.03,34.88,32.22,30.03,28.5,26.75,24.28,23.19,24.22,25.62,25.44,25.28,26.5,27.53,26.53,25.19,25.12,25.34,24.09,21.69,20.22,19.84,19.56,18.69,19.56,22.78,26.5,28.34,29.84,31.88,33.22,32.06,29.75,28.41,28.56,28.06,27.41,28.12,30.38,32.0,31.94,32.28,33.66,34.84,33.75,32.41,32.69,33.78,33.78,33.06,32.53,32.19,30.28,27.16,25.31,26.16,27.59,27.97,28.94,31.03,33.03,32.91,32.19,32.47,33.12,32.06,30.34,29.16,29.28,28.78,27.12,25.91,26.22,26.47,25.53,25.06,26.88,29.22,29.81,29.62,30.03,31.06,30.19,28.81,28.75,30.44,31.56,30.72,29.88,30.38,30.31,28.38,26.94,27.09,27.25,26.22,24.53,24.47,25.94,25.88,24.84,25.34,27.0,27.5,26.22,25.16,25.94,26.56,25.66,25.03,26.09,27.31,26.59,24.75,24.19,24.28,23.31,21.44,20.69,22.09,23.69,23.94,24.84,27.91,30.91,31.59,31.66,32.66,34.0,33.19,31.62,30.78,30.94,29.88,27.19,25.25,25.62,26.0,25.22,24.84,25.91,27.25,26.09,24.28,23.84,24.16,22.84,20.75,19.88,20.59,20.44,19.34,18.97,20.72,22.44,22.66,22.78,24.81,26.97,27.22,26.69,26.91,27.09,25.38,22.34,20.22,19.91,19.69,18.84,18.69,20.72,22.5,22.09,20.47,19.75,18.66,16.38,14.03,13.44,14.94,15.56,15.62,16.59,19.09,21.53,22.44,23.81,26.75,29.16,29.5,28.75,29.22,29.5,27.97,25.84,25.0,25.78,26.28,26.5,27.84,30.94,33.44,33.66,32.94,33.19,32.47,29.31,25.81,24.06,24.03,24.19,24.22,26.09,29.72,32.84,34.69,36.91,40.09,41.78,41.03,38.62,37.19,35.38,31.94,27.78,26.34,26.34,25.69,24.25,23.78,24.81,25.28,24.81,25.09,27.75,30.25,31.06,30.91,32.19,33.34,32.88,31.34,30.88,31.34,30.38,27.72,25.5,24.91,23.28,20.44,17.69,17.56,17.5,17.12,16.88,19.34,22.16,23.81,24.0,25.03,26.88,27.62,27.06,27.19,28.38,28.66,26.72,24.53,23.69,23.38,21.16,19.16,18.75,19.0,18.03,16.41,16.47,18.09,18.84,18.66,18.47,19.56,20.34,19.78,19.78,22.38,25.97,28.19,29.12,30.28,30.84,29.31,25.69,23.41,22.66,22.0,20.88,20.56,22.66,23.84,23.09,21.31,21.19,21.78,21.69,21.59,23.91,27.31,29.78,30.53,31.41,32.62,32.72,30.31,28.0,27.56,27.31,25.84,24.22,24.5,25.38,24.72,23.12,23.06,24.38,24.59,23.75,23.28,24.25,24.44,22.38,20.16,19.56,19.16,17.38,15.69,16.06,17.38,17.28,16.41,16.81,18.66,19.19,18.22,17.56,18.31,18.72,17.75,17.34,19.31,21.56,21.94,21.38,21.81,22.16,20.91,18.12,16.41,16.16,15.22,12.97,12.38,14.19,15.78,15.88,15.47,16.44,17.69,17.31,16.56,17.25,19.34,19.62,18.19,16.97,16.66,14.78,10.88,7.5,6.66,6.78,6.75,7.75,11.62,15.91,18.5,20.25,23.19,27.12,30.28,32.03,34.0,35.84,35.31,31.22,26.03,22.16,18.5,14.41,11.62,12.19,13.81,14.75,14.81,15.88,17.28,17.72,17.09,17.59,20.06,22.56,23.56,24.59,26.66,28.22,27.84,27.19,28.5,31.41,33.91,35.34,37.34,39.53,39.66,36.84,33.81,32.09,30.12,26.09,22.62,20.94,19.34,16.16,12.88,11.72,12.03,12.22,12.12,13.72,17.19,20.25,21.78,23.41,26.84,29.75,30.25,30.38,32.31,33.78,33.44,31.97,31.81,31.94,30.88,28.19,26.44,25.72,24.5,21.56,19.28,18.88,19.38,18.78,18.56,20.88,23.88,25.44,26.28,27.81,29.88,30.5,29.19,29.09,30.34,31.41,30.62,30.19,31.09,31.88,30.72,29.66,29.97,30.41,29.38,27.12,26.53,27.09,26.75,24.81,23.78,23.5,22.53,19.94,18.06,17.81,18.25,17.69,17.22,19.03,21.75,23.31,23.84,25.28,27.34,28.78,28.03,27.97,28.66,28.66,26.34,23.81,23.09,22.75,20.97,19.34,18.94,19.25,18.84,17.53,17.47,18.75,19.66,18.88,18.53,19.41,20.12,19.25,18.22,18.78,20.0,20.34,20.41,22.12,24.72,25.66,25.03,24.94,26.25,27.03,26.81,27.69,30.19,32.94,33.53,33.66,33.91,34.0,31.91,29.03,27.25,26.69,25.16,22.75,21.31,21.12,21.19,20.25,20.88,23.62,27.16,29.34,31.03,33.03,62.75,63.41,64.03,64.09,64.16,65.03,66.16,67.25,68.09,68.5,68.75,68.06,66.53,64.88,63.69,62.81,62.41,62.81,64.03,64.94,65.53,65.31,64.88,63.94,62.66,61.16,59.88,58.56:43.25,43.06,43.84,45.34,46.12,44.78,43.31,43.56,43.75,42.5,40.78,40.41,40.5,39.59,37.56,36.91,37.78,38.53,38.06,39.0,40.84,41.97,40.94,39.53,39.88,40.78,41.06,41.38,43.09,45.41,46.19,45.06,44.31,44.06,43.12,40.5,39.03,39.78,40.62,39.78,39.0,39.38,39.66,38.38,36.41,35.59,35.97,35.56,34.47,34.59,36.66,38.94,39.19,39.47,40.88,41.59,40.12,38.78,38.84,40.03,40.03,39.53,40.16,41.72,42.47,42.09,42.22,43.22,44.19,43.06,42.5,43.44,44.81,44.56,43.34,43.38,43.66,42.66,41.0,40.53,41.88,42.0,40.78,39.41,39.5,39.28,37.12,35.88,36.69,38.69,39.56,40.16,41.97,44.09,44.19,42.19,40.38,39.53,37.94,35.5,34.31,35.66,37.91,38.72,39.38,40.97,42.47,41.88,40.28,39.97,39.91,38.84,37.0,35.59,35.47,35.25,33.5,32.31,31.84,31.75,29.78,27.66,27.34,28.41,28.56,28.31,29.06,30.81,31.41,30.38,30.06,30.81,32.0,31.91,32.34,34.19,36.53,36.03,35.28,35.38,36.81,37.66,37.5,37.81,38.66,38.25,35.69,33.38,32.78,32.12,30.31,29.06,29.19,29.97,29.12,27.91,28.44,30.34,31.66,32.41,34.56,38.41,41.5,43.41,45.31,48.09,49.91,49.12,47.06,46.16,45.28,43.03,40.62,39.59,40.06,39.81,38.34,37.78,38.44,38.38,37.25,36.62,38.06,40.0,40.06,39.84,40.62,41.81,41.16,39.84,39.62,40.56,41.09,40.28,39.84,40.44,40.12,38.09,36.0,35.75,35.97,34.31,32.12,31.09,31.16,30.47,29.69,29.62,31.44,32.28,32.0,32.62,34.5,36.28,36.41,36.69,38.5,40.75,41.44,41.0,41.41,41.94,41.31,39.78,39.28,40.31,40.72,39.75,39.59,41.34,43.09,43.03,43.06,43.66,44.75,43.72,41.16,39.69,39.12,37.31,34.69,32.59,32.75,32.28,30.78,29.94,30.78,32.06,31.66,30.22,29.47,29.09,27.25,24.72,24.09,25.38,26.28,25.72,25.31,26.44,26.69,25.97,25.97,28.44,31.34,32.59,33.22,34.84,37.0,37.41,36.78,36.84,38.22,38.69,38.12,37.22,38.22,38.59,37.12,35.69,35.28,35.5,33.66,31.31,30.12,30.06,29.5,28.44,28.19,29.81,30.41,30.06,30.25,32.72,35.53,37.34,38.56,40.5,41.59,39.91,36.34,33.31,31.78,30.22,28.75,29.38,31.84,33.84,33.88,33.53,34.19,34.5,33.03,31.09,30.59,30.88,30.22,29.03,29.53,31.69,33.0,33.25,34.19,36.62,38.88,39.88,40.44,42.47,43.59,43.25,41.69,41.56,41.91,40.59,37.91,35.72,34.06,32.09,29.47,27.91,29.06,30.78,31.19,31.94,34.12,36.47,37.62,37.84,39.16,40.72,40.5,38.81,37.66,37.31,36.59,35.16,34.38,35.69,37.25,37.66,37.56,38.84,39.78,39.47,37.75,37.38,37.5,36.84,35.5,34.47,35.66,36.25,34.84,33.12,32.62,31.44,29.03,26.72,26.28,26.66,26.5,25.44,25.38,26.59,27.44,27.41,28.12,30.56,33.03,33.44,33.16,34.06,35.03,34.94,34.47,35.78,37.12,37.25,35.41,34.06,33.62,32.97,31.84,32.09,34.88,37.91,39.44,40.5,42.09,42.91,41.41,39.0,37.94,38.06,37.88,37.19,37.12,38.22,38.84,38.25,37.38,37.78,38.5,36.81,34.91,34.53,34.53,34.16,33.44,33.81,35.12,35.62,34.03,32.69,32.31,31.94,30.56,29.84,31.53,33.75,34.56,34.41,35.03,35.84,35.03,33.44,32.62,32.62,32.0,29.5,27.28,26.75,26.47,25.5,25.47,27.56,30.34,31.78,31.84,32.53,33.19,32.28,30.5,29.75,30.56,32.31,33.0,34.06,36.03,36.84,35.0,32.25,30.72,30.06,29.09,28.53,29.75,31.94,33.0,32.19,31.59,31.66,31.41,29.84,28.69,29.44,30.88,30.78,30.59,31.88,33.69,33.81,32.69,32.16,32.12,31.16,29.41,28.59,29.75,31.12,30.59,29.72,30.0,30.5,29.72,28.75,29.53,31.38,32.78,33.59,35.56,38.22,40.22,40.22,39.78,39.91,39.59,37.09,34.19,32.5,31.47,29.56,27.47,27.47,29.0,30.16,30.31,31.25,33.03,33.97,33.0,32.34,33.06,33.97,33.22,31.94,32.06,32.56,31.44,29.09,27.69,27.03,25.75,23.19,22.78,24.41,26.56,27.62,29.06,31.72,34.31,34.47,34.38,35.12,36.03,34.88,32.22,30.03,28.5,26.75,24.28,23.19,24.22,25.62,25.44,25.28,26.5,27.53,26.53,25.19,25.12,25.34,24.09,21.69,20.22,19.84,19.56,18.69,19.56,22.78,26.5,28.34,29.84,31.88,33.22,32.06,29.75,28.41,28.56,28.06,27.41,28.12,30.38,32.0,31.94,32.28,33.66,34.84,33.75,32.41,32.69,33.78,33.78,33.06,32.53,32.19,30.28,27.16,25.31,26.16,27.59,27.97,28.94,31.03,33.03,32.91,32.19,32.47,33.12,32.06,30.34,29.16,29.28,28.78,27.12,25.91,26.22,26.47,25.53,25.06,26.88,29.22,29.81,29.62,30.03,31.06,30.19,28.81,28.75,30.44,31.56,30.72,29.88,30.38,30.31,28.38,26.94,27.09,27.25,26.22,24.53,24.47,25.94,25.88,24.84,25.34,27.0,27.5,26.22,25.16,25.94,26.56,25.66,25.03,26.09,27.31,26.59,24.75,24.19,24.28,23.31,21.44,20.69,22.09,23.69,23.94,24.84,27.91,30.91,31.59,31.66,32.66,34.0,33.19,31.62,30.78,30.94,29.88,27.19,25.25,25.62,26.0,25.22,24.84,25.91,27.25,26.09,24.28,23.84,24.16,22.84,20.75,19.88,20.59,20.44,19.34,18.97,20.72,22.44,22.66,22.78,24.81,26.97,27.22,26.69,26.91,27.09,25.38,22.34,20.22,19.91,19.69,18.84,18.69,20.72,22.5,22.09,20.47,19.75,18.66,16.38,14.03,13.44,14.94,15.56,15.62,16.59,19.09,21.53,22.44,23.81,26.75,29.16,29.5,28.75,29.22,29.5,27.97,25.84,25.0,25.78,26.28,26.5,27.84,30.94,33.44,33.66,32.94,33.19,32.47,29.31,25.81,24.06,24.03,24.19,24.22,26.09,29.72,32.84,34.69,36.91,40.09,41.78,41.03,38.62,37.19,35.38,31.94,27.78,26.34,26.34,25.69,24.25,23.78,24.81,25.28,24.81,25.09,27.75,30.25,31.06,30.91,32.19,33.34,32.88,31.34,30.88,31.34,30.38,27.72,25.5,24.91,23.28,20.44,17.69,17.56,17.5,17.12,16.88,19.34,22.16,23.81,24.0,25.03,26.88,27.62,27.06,27.19,28.38,28.66,26.72,24.53,23.69,23.38,21.16,19.16,18.75,19.0,18.03,16.41,16.47,18.09,18.84,18.66,18.47,19.56,20.34,19.78,19.78,22.38,25.97,28.19,29.12,30.28,30.84,29.31,25.69,23.41,22.66,22.0,20.88,20.56,22.66,23.84,23.09,21.31,21.19,21.78,21.69,21.59,23.91,27.31,29.78,30.53,31.41,32.62,32.72,30.31,28.0,27.56,27.31,25.84,24.22,24.5,25.38,24.72,23.12,23.06,24.38,24.59,23.75,23.28,24.25,24.44,22.38,20.16,19.56,19.16,17.38,15.69,16.06,17.38,17.28,16.41,16.81,18.66,19.19,18.22,17.56,18.31,18.72,17.75,17.34,19.31,21.56,21.94,21.38,21.81,22.16,20.91,18.12,16.41,16.16,15.22,12.97,12.38,14.19,15.78,15.88,15.47,16.44,17.69,17.31,16.56,17.25,19.34,19.62,18.19,16.97,16.66,14.78,10.88,7.5,6.66,6.78,6.75,7.75,11.62,15.91,18.5,20.25,23.19,27.12,30.28,32.03,34.0,35.84,35.31,31.22,26.03,22.16,18.5,14.41,11.62,12.19,13.81,14.75,14.81,15.88,17.28,17.72,17.09,17.59,20.06,22.56,23.56,24.59,26.66,28.22,27.84,27.19,28.5,31.41,33.91,35.34,37.34,39.53,39.66,36.84,33.81,32.09,30.12,26.09,22.62,20.94,19.34,16.16,12.88,11.72,12.03,12.22,12.12,13.72,17.19,20.25,21.78,23.41,26.84,29.75,30.25,30.38,32.31,33.78,33.44,31.97,31.81,31.94,30.88,28.19,26.44,25.72,24.5,21.56,19.28,18.88,19.38,18.78,18.56,20.88,23.88,25.44,26.28,27.81,29.88,30.5,29.19,29.09,30.34,31.41,30.62,30.19,31.09,31.88,30.72,29.66,29.97,30.41,29.38,27.12,26.53,27.09,26.75,24.81,23.78,23.5,22.53,19.94,18.06,17.81,18.25,17.69,17.22,19.03,21.75,23.31,23.84,25.28,27.34,28.78,28.03,27.97,28.66,28.66,26.34,23.81,23.09,22.75,20.97,19.34,18.94,19.25,18.84,17.53,17.47,18.75,19.66,18.88,18.53,19.41,20.12,19.25,18.22,18.78,20.0,20.34,20.41,22.12,24.72,25.66,25.03,24.94,26.25,27.03,26.81,27.69,30.19,32.94,33.53,33.66,33.91,34.0,31.91,29.03,27.25,26.69,25.16,22.75,21.31,21.12,21.19,20.25,20.88,23.62,27.16,29.34,31.03,33.03,62.75,63.41,64.03,64.09,64.16,65.03,66.16,67.25,68.09,68.5,68.75,68.06,66.53,64.88,63.69,62.81,62.41,62.81,64.03,64.94,65.53,65.31,64.88,63.94,62.66,61.16,59.88,58.56,57.38,55.69,54.0,52.94,52.06,51.88,52.34:43.56,43.75,42.5,40.78,40.41,40.5,39.59,37.56,36.91,37.78,38.53,38.06,39.0,40.84,41.97,40.94,39.53,39.88,40.78,41.06,41.38,43.09,45.41,46.19,45.06,44.31,44.06,43.12,40.5,39.03,39.78,40.62,39.78,39.0,39.38,39.66,38.38,36.41,35.59,35.97,35.56,34.47,34.59,36.66,38.94,39.19,39.47,40.88,41.59,40.12,38.78,38.84,40.03,40.03,39.53,40.16,41.72,42.47,42.09,42.22,43.22,44.19,43.06,42.5,43.44,44.81,44.56,43.34,43.38,43.66,42.66,41.0,40.53,41.88,42.0,40.78,39.41,39.5,39.28,37.12,35.88,36.69,38.69,39.56,40.16,41.97,44.09,44.19,42.19,40.38,39.53,37.94,35.5,34.31,35.66,37.91,38.72,39.38,40.97,42.47,41.88,40.28,39.97,39.91,38.84,37.0,35.59,35.47,35.25,33.5,32.31,31.84,31.75,29.78,27.66,27.34,28.41,28.56,28.31,29.06,30.81,31.41,30.38,30.06,30.81,32.0,31.91,32.34,34.19,36.53,36.03,35.28,35.38,36.81,37.66,37.5,37.81,38.66,38.25,35.69,33.38,32.78,32.12,30.31,29.06,29.19,29.97,29.12,27.91,28.44,30.34,31.66,32.41,34.56,38.41,41.5,43.41,45.31,48.09,49.91,49.12,47.06,46.16,45.28,43.03,40.62,39.59,40.06,39.81,38.34,37.78,38.44,38.38,37.25,36.62,38.06,40.0,40.06,39.84,40.62,41.81,41.16,39.84,39.62,40.56,41.09,40.28,39.84,40.44,40.12,38.09,36.0,35.75,35.97,34.31,32.12,31.09,31.16,30.47,29.69,29.62,31.44,32.28,32.0,32.62,34.5,36.28,36.41,36.69,38.5,40.75,41.44,41.0,41.41,41.94,41.31,39.78,39.28,40.31,40.72,39.75,39.59,41.34,43.09,43.03,43.06,43.66,44.75,43.72,41.16,39.69,39.12,37.31,34.69,32.59,32.75,32.28,30.78,29.94,30.78,32.06,31.66,30.22,29.47,29.09,27.25,24.72,24.09,25.38,26.28,25.72,25.31,26.44,26.69,25.97,25.97,28.44,31.34,32.59,33.22,34.84,37.0,37.41,36.78,36.84,38.22,38.69,38.12,37.22,38.22,38.59,37.12,35.69,35.28,35.5,33.66,31.31,30.12,30.06,29.5,28.44,28.19,29.81,30.41,30.06,30.25,32.72,35.53,37.34,38.56,40.5,41.59,39.91,36.34,33.31,31.78,30.22,28.75,29.38,31.84,33.84,33.88,33.53,34.19,34.5,33.03,31.09,30.59,30.88,30.22,29.03,29.53,31.69,33.0,33.25,34.19,36.62,38.88,39.88,40.44,42.47,43.59,43.25,41.69,41.56,41.91,40.59,37.91,35.72,34.06,32.09,29.47,27.91,29.06,30.78,31.19,31.94,34.12,36.47,37.62,37.84,39.16,40.72,40.5,38.81,37.66,37.31,36.59,35.16,34.38,35.69,37.25,37.66,37.56,38.84,39.78,39.47,37.75,37.38,37.5,36.84,35.5,34.47,35.66,36.25,34.84,33.12,32.62,31.44,29.03,26.72,26.28,26.66,26.5,25.44,25.38,26.59,27.44,27.41,28.12,30.56,33.03,33.44,33.16,34.06,35.03,34.94,34.47,35.78,37.12,37.25,35.41,34.06,33.62,32.97,31.84,32.09,34.88,37.91,39.44,40.5,42.09,42.91,41.41,39.0,37.94,38.06,37.88,37.19,37.12,38.22,38.84,38.25,37.38,37.78,38.5,36.81,34.91,34.53,34.53,34.16,33.44,33.81,35.12,35.62,34.03,32.69,32.31,31.94,30.56,29.84,31.53,33.75,34.56,34.41,35.03,35.84,35.03,33.44,32.62,32.62,32.0,29.5,27.28,26.75,26.47,25.5,25.47,27.56,30.34,31.78,31.84,32.53,33.19,32.28,30.5,29.75,30.56,32.31,33.0,34.06,36.03,36.84,35.0,32.25,30.72,30.06,29.09,28.53,29.75,31.94,33.0,32.19,31.59,31.66,31.41,29.84,28.69,29.44,30.88,30.78,30.59,31.88,33.69,33.81,32.69,32.16,32.12,31.16,29.41,28.59,29.75,31.12,30.59,29.72,30.0,30.5,29.72,28.75,29.53,31.38,32.78,33.59,35.56,38.22,40.22,40.22,39.78,39.91,39.59,37.09,34.19,32.5,31.47,29.56,27.47,27.47,29.0,30.16,30.31,31.25,33.03,33.97,33.0,32.34,33.06,33.97,33.22,31.94,32.06,32.56,31.44,29.09,27.69,27.03,25.75,23.19,22.78,24.41,26.56,27.62,29.06,31.72,34.31,34.47,34.38,35.12,36.03,34.88,32.22,30.03,28.5,26.75,24.28,23.19,24.22,25.62,25.44,25.28,26.5,27.53,26.53,25.19,25.12,25.34,24.09,21.69,20.22,19.84,19.56,18.69,19.56,22.78,26.5,28.34,29.84,31.88,33.22,32.06,29.75,28.41,28.56,28.06,27.41,28.12,30.38,32.0,31.94,32.28,33.66,34.84,33.75,32.41,32.69,33.78,33.78,33.06,32.53,32.19,30.28,27.16,25.31,26.16,27.59,27.97,28.94,31.03,33.03,32.91,32.19,32.47,33.12,32.06,30.34,29.16,29.28,28.78,27.12,25.91,26.22,26.47,25.53,25.06,26.88,29.22,29.81,29.62,30.03,31.06,30.19,28.81,28.75,30.44,31.56,30.72,29.88,30.38,30.31,28.38,26.94,27.09,27.25,26.22,24.53,24.47,25.94,25.88,24.84,25.34,27.0,27.5,26.22,25.16,25.94,26.56,25.66,25.03,26.09,27.31,26.59,24.75,24.19,24.28,23.31,21.44,20.69,22.09,23.69,23.94,24.84,27.91,30.91,31.59,31.66,32.66,34.0,33.19,31.62,30.78,30.94,29.88,27.19,25.25,25.62,26.0,25.22,24.84,25.91,27.25,26.09,24.28,23.84,24.16,22.84,20.75,19.88,20.59,20.44,19.34,18.97,20.72,22.44,22.66,22.78,24.81,26.97,27.22,26.69,26.91,27.09,25.38,22.34,20.22,19.91,19.69,18.84,18.69,20.72,22.5,22.09,20.47,19.75,18.66,16.38,14.03,13.44,14.94,15.56,15.62,16.59,19.09,21.53,22.44,23.81,26.75,29.16,29.5,28.75,29.22,29.5,27.97,25.84,25.0,25.78,26.28,26.5,27.84,30.94,33.44,33.66,32.94,33.19,32.47,29.31,25.81,24.06,24.03,24.19,24.22,26.09,29.72,32.84,34.69,36.91,40.09,41.78,41.03,38.62,37.19,35.38,31.94,27.78,26.34,26.34,25.69,24.25,23.78,24.81,25.28,24.81,25.09,27.75,30.25,31.06,30.91,32.19,33.34,32.88,31.34,30.88,31.34,30.38,27.72,25.5,24.91,23.28,20.44,17.69,17.56,17.5,17.12,16.88,19.34,22.16,23.81,24.0,25.03,26.88,27.62,27.06,27.19,28.38,28.66,26.72,24.53,23.69,23.38,21.16,19.16,18.75,19.0,18.03,16.41,16.47,18.09,18.84,18.66,18.47,19.56,20.34,19.78,19.78,22.38,25.97,28.19,29.12,30.28,30.84,29.31,25.69,23.41,22.66,22.0,20.88,20.56,22.66,23.84,23.09,21.31,21.19,21.78,21.69,21.59,23.91,27.31,29.78,30.53,31.41,32.62,32.72,30.31,28.0,27.56,27.31,25.84,24.22,24.5,25.38,24.72,23.12,23.06,24.38,24.59,23.75,23.28,24.25,24.44,22.38,20.16,19.56,19.16,17.38,15.69,16.06,17.38,17.28,16.41,16.81,18.66,19.19,18.22,17.56,18.31,18.72,17.75,17.34,19.31,21.56,21.94,21.38,21.81,22.16,20.91,18.12,16.41,16.16,15.22,12.97,12.38,14.19,15.78,15.88,15.47,16.44,17.69,17.31,16.56,17.25,19.34,19.62,18.19,16.97,16.66,14.78,10.88,7.5,6.66,6.78,6.75,7.75,11.62,15.91,18.5,20.25,23.19,27.12,30.28,32.03,34.0,35.84,35.31,31.22,26.03,22.16,18.5,14.41,11.62,12.19,13.81,14.75,14.81,15.88,17.28,17.72,17.09,17.59,20.06,22.56,23.56,24.59,26.66,28.22,27.84,27.19,28.5,31.41,33.91,35.34,37.34,39.53,39.66,36.84,33.81,32.09,30.12,26.09,22.62,20.94,19.34,16.16,12.88,11.72,12.03,12.22,12.12,13.72,17.19,20.25,21.78,23.41,26.84,29.75,30.25,30.38,32.31,33.78,33.44,31.97,31.81,31.94,30.88,28.19,26.44,25.72,24.5,21.56,19.28,18.88,19.38,18.78,18.56,20.88,23.88,25.44,26.28,27.81,29.88,30.5,29.19,29.09,30.34,31.41,30.62,30.19,31.09,31.88,30.72,29.66,29.97,30.41,29.38,27.12,26.53,27.09,26.75,24.81,23.78,23.5,22.53,19.94,18.06,17.81,18.25,17.69,17.22,19.03,21.75,23.31,23.84,25.28,27.34,28.78,28.03,27.97,28.66,28.66,26.34,23.81,23.09,22.75,20.97,19.34,18.94,19.25,18.84,17.53,17.47,18.75,19.66,18.88,18.53,19.41,20.12,19.25,18.22,18.78,20.0,20.34,20.41,22.12,24.72,25.66,25.03,24.94,26.25,27.03,26.81,27.69,30.19,32.94,33.53,33.66,33.91,34.0,31.91,29.03,27.25,26.69,25.16,22.75,21.31,21.12,21.19,20.25,20.88,23.62,27.16,29.34,31.03,33.03,62.75,63.41,64.03,64.09,64.16,65.03,66.16,67.25,68.09,68.5,68.75,68.06,66.53,64.88,63.69,62.81,62.41,62.81,64.03,64.94,65.53,65.31,64.88,63.94,62.66,61.16,59.88,58.56,57.38,55.69,54.0,52.94,52.06,51.88,52.34,54.03,55.91,57.81,58.81,60.19,61.34,62.0:negativity
5.16,6.19,7.47,9.44,11.31,12.31,13.31,14.88,15.69,14.97,13.28,11.97,11.16,10.41,10.0,10.69,12.78,14.22,14.94,15.69,16.44,16.53,15.06,13.56,12.88,12.16,11.12,9.69,8.75,7.69,6.47,5.5,6.25,8.5,11.53,14.09,16.25,18.91,20.53,21.34,21.94,23.5,25.56,26.53,26.66,26.88,25.84,23.84,21.03,18.81,17.91,17.25,16.06,14.94,14.12,13.09,10.47,7.94,6.69,5.59,4.97,4.34,5.06,6.78,8.09,8.66,8.72,9.59,9.84,9.34,9.16,10.78,12.62,13.41,13.91,14.5,13.88,12.03,9.22,7.0,5.53,4.09,2.0,0.38,0.0,-0.38,-1.16,-1.62,-0.88,0.03,0.12,-0.09,0.06,0.38,0.5,0.03,0.5,2.12,3.75,4.22,5.22,6.91,8.31,8.38,8.16,8.12,7.75,6.09,4.28,3.31,3.34,3.16,2.84,3.38,4.06,3.88,2.44,0.53,-0.09,-1.06,-2.66,-3.72,-3.56,-3.03,-2.59,-2.97,-2.31,-1.19,-0.97,-1.28,-1.09,-0.59,-0.16,-0.72,-0.97,0.12,1.78,2.47,3.38,4.97,6.41,6.72,6.28,6.0,6.25,6.25,5.69,6.03,7.22,8.16,8.28,8.41,9.53,11.22,12.5,13.78,15.94,18.41,19.97,20.75,21.88,23.22,23.97,23.38,22.66,21.78,20.16,16.78,13.06,10.03,7.94,5.75,3.97,4.28,5.47,6.72,7.72,9.38,11.72,14.0,14.91,15.88,16.66,17.5,16.41,15.06,14.03,13.38,11.72,10.28,9.47,8.84,7.69,5.66,4.56,3.91,4.09,3.19,3.19,3.34,3.56,3.03,2.69,2.81,3.31,2.94,1.94,1.09,0.69,0.12,-0.31,-0.25,1.12,2.78,3.16,3.31,3.75,4.5,4.59,4.84,6.0,7.72,8.72,8.84,8.38,8.09,6.97,4.53,2.72,1.5,0.47,-1.19,-2.91,-3.81,-3.69,-4.03,-4.22,-3.78,-2.56,-1.69,-1.19,0.09,2.38,4.5,5.59,5.88,6.53,7.69,8.25,9.47,11.47,13.72,14.28,13.81,12.19,10.97,9.31,7.28,5.94,5.47,5.22,3.97,2.94,2.28,1.69,0.38,-0.34,-0.06,1.59,3.28,4.94,6.44,8.19,8.75,8.16,7.5,7.84,8.09,7.84,7.97,8.78,10.25,11.66,12.66,14.03,15.16,15.44,14.62,13.62,13.47,12.84,11.28,9.56,8.22,6.94,5.09,3.78,3.5,3.81,4.34,4.56,5.0,7.09,9.16,10.75,12.59,14.72,16.0,16.19,16.12,17.06,18.5,19.28,19.91,20.47,21.06,20.75,19.84,18.56,17.62,16.38,14.44,13.12,13.16,13.72,13.66,13.41,13.88,14.31,13.88,13.12,12.84,13.56,13.5,12.97,12.5,12.5,11.59,9.97,7.81,6.53,5.78,5.06,4.78,6.34,9.03,11.25,13.22,14.91,16.28,16.19,15.53,14.91,15.44,16.19,16.0,16.09,15.88,15.38,13.78,12.09,11.62,11.69,12.34,12.56,13.16,13.81,13.88,13.12,12.12,11.88,11.16,10.31,9.72,10.19,11.12,11.81,11.97,12.12,12.34,12.0,11.19,10.62,11.03,11.16,10.12,8.88,8.62,8.81,8.62,8.41,9.53,11.0,11.75,12.59,13.56,15.28,16.12,16.12,16.44,17.31,18.41,19.12,19.16,19.84,20.66,20.75,20.66,21.78,22.91,23.53,23.09,22.19,21.25,19.41,16.75,14.41,13.22,12.91,12.25,12.41,13.91,15.41,16.12,15.69,15.56,15.34,15.28,15.34,16.41,18.62,20.78,22.09,22.69,23.34,23.0,21.03,18.34,16.25,14.22,12.84,12.12,12.31,13.41,14.69,14.78,14.59,15.19,15.97,16.38,17.06,18.53,19.75,19.5,18.44,18.0,17.44,16.91,16.12,15.47,15.16,13.97,12.25,10.09,8.94,7.75,6.03,4.47,3.75,4.06,3.97,3.84,5.0,6.94,8.59,9.12,10.19,11.25,12.28,12.34,12.44,12.97,13.16,12.5,11.97,12.72,14.19,15.62,16.38,17.0,17.09,15.69,12.38,9.38,6.53,4.69,2.91,2.06,3.0,4.47,5.72,6.62,8.75,11.25,13.47,15.19,16.94,18.66,19.75,18.91,17.5,16.12,14.75,12.28,9.84,8.44,7.66,6.66,5.12,4.56,4.44,3.66,2.09,0.84,0.53,0.56,0.16,0.16,1.28,2.5,2.59,2.47,3.22,4.31,5.09,5.44,6.44,7.38,7.56,7.03,6.81,7.19,8.41,9.19,10.19,11.81,13.91,14.66,14.38,14.84,15.44,15.88,15.88,16.47,17.75,18.75,18.5,17.97,17.75,17.41,15.97,14.97,14.31,14.44,14.0,13.28,12.91,12.94,12.06,10.44,9.19,8.84,9.0,9.16,9.97,12.0,13.88,14.81,15.5,16.09,17.12,17.22,16.41,16.16,16.38,16.38,15.97,15.88,17.06,18.38,18.69,18.53,18.56,18.12,16.44,14.16,12.5,11.56,10.88,10.0,9.81,10.56,10.78,10.12,9.44,9.47,9.88,9.91,10.75,12.84,15.44,17.16,18.16,18.72,19.19,18.5,17.53,16.81,16.81,16.53,15.38,14.41,13.59,13.38,12.0,10.72,10.59,10.91,10.47,9.62,8.94,8.84,8.91,8.78,9.03,10.84,12.34,12.59,12.44,12.72,13.34,12.66,11.81,11.59,12.0,11.78,11.47,11.44,12.5,12.94,12.44,11.81,11.75,11.78,10.53,10.0,10.66,12.5,13.31,14.19,14.91,15.72,15.09,13.97,13.0,12.94,12.59,10.91,9.03,7.66,6.31,3.81,1.72,1.47,2.72,3.94,5.66,8.12,11.34,13.56,14.97,16.59,18.84,20.31,20.78,20.97,21.94,22.69,21.97,21.62,22.25,23.16,23.16,22.78,21.84,20.66,18.56,15.62,13.19,12.56,12.56,12.41,12.81,14.31,15.94,16.56,16.84,17.19,18.12,17.91,17.16,16.25,16.0,15.94,14.88,14.66,16.5,18.66,19.72,20.06,20.94,21.0,20.12,18.44,17.66,17.62,17.12,15.81,15.03,15.16,14.88,13.53,12.38,12.53,12.91,12.84,12.53,13.53,14.81,14.91,14.66,14.34,14.91,15.09,14.5,14.25,14.5,13.84,12.19,10.28,9.0,8.06,6.62,5.34,5.03,5.34,4.91,4.69,4.0,4.19,4.03,3.62,3.5,4.62,6.28,7.25,8.38,10.28,12.38,13.31,13.38,14.06,14.28,13.5,11.62,9.47,8.19,6.5,4.75,3.75,4.34,5.38,5.62,5.69,6.75,7.91,8.09,7.72,8.25,9.34,9.47,8.88,8.25,8.09,7.5,6.03,4.97,5.34,6.59,7.44,8.03,9.09,10.5,11.03,9.88,9.25,8.69,7.94,6.5,5.59,6.25,7.09,7.5,7.59,8.75,9.47,9.06,7.56,6.88,7.03,7.41,8.25,10.78,14.38,17.88,20.44,22.84,26.19,29.09,31.25,33.06,34.91,35.75,34.41,31.31,27.69,24.03,20.12,15.75,12.75,11.53,11.12,10.56,9.59,9.31,8.31,5.53,1.66,-1.16,-3.19,-4.69,-5.44,-4.31,-1.44,1.72,4.28,7.19,10.69,13.28,14.53,14.78,15.59,15.88,15.19,14.09,13.47,13.34,12.5,10.97,9.53,8.19,6.69,3.97,1.75,0.53,-0.66,-2.75,-5.12,-6.25,-6.78,-7.16,-7.22,-5.97,-3.69,-1.53,-0.19,1.0,2.84,4.31,3.97,3.38,3.56,3.88,3.47,3.38,4.41,5.97,7.09,7.66,8.66,9.66,9.97,8.62,7.78,7.06,6.44,4.53,3.19,2.62,2.53,2.03,1.97,2.56,3.66,4.34,4.12,4.38,5.56,6.97,7.84,9.12,11.47,13.47,14.41,14.81,15.72,16.28,15.81,14.69,13.97,14.16,14.19,13.75,13.5,14.0,13.81,12.72,12.0,12.19,12.88,13.38,13.5,15.12,16.59,17.19,17.47,18.16,19.25,20.5,21.25,22.06,23.69,25.12,25.06,24.38,24.03,23.59,21.47,18.91,16.94,15.75,14.75,13.78,14.03,15.47,17.53,18.5,19.84,21.97,23.5,23.5,22.72,22.06,21.47,19.62,17.66,16.56,15.62,14.03,11.88,9.72,8.41,7.06,4.84,3.28,3.19,3.62,3.47,3.59,4.44,5.47,5.41,5.12,5.5,6.62,8.06,9.34,11.72,14.91,18.22,20.38,22.31,24.12,25.78,26.25,26.03,26.25,26.81,26.34,25.28,24.19,23.34,21.94,19.31,16.72,14.31,11.94,8.75,5.53,3.62,2.41,0.53,-0.97,-1.41,-0.62,0.38,1.59,3.75,6.91,9.41,10.91,12.22,13.22,13.66,12.72,11.41,10.25,9.62,8.47,7.56,7.62,9.25,11.34,13.5,16.28,19.44,22.0,22.06,21.06,19.72,18.03,15.59,13.56,12.91,13.5,13.81,13.75,14.22,14.88,14.91,14.25,13.5,13.66,13.53,12.66,11.81,11.47,10.97,9.62,8.06,7.31,7.38,6.84,6.12,5.53,5.12,4.62,3.66,3.03,3.91,4.66,4.91,5.09,5.56,7.03,8.34,9.81,12.25,15.38,18.16,19.72,20.78,21.88,22.5,22.31,22.44,23.81,25.31,25.97,26.03,25.75,25.53,24.5,23.28,23.0,23.78,24.47,24.91,25.31,26.03,26.09,24.5,21.91,19.66,16.88,14.41,12.47,12.03,13.66,15.19,16.81,18.38,20.62,22.19,23.12,23.75,25.12,26.31,26.53,25.94,25.91,25.81,24.91,23.5,22.47,21.62,20.31,18.25,15.91,14.56,13.0,10.88,8.97,8.09,8.12,8.44,8.53,9.59,10.66,10.72,9.59,9.09:14.88,15.69,14.97,13.28,11.97,11.16,10.41,10.0,10.69,12.78,14.22,14.94,15.69,16.44,16.53,15.06,13.56,12.88,12.16,11.12,9.69,8.75,7.69,6.47,5.5,6.25,8.5,11.53,14.09,16.25,18.91,20.53,21.34,21.94,23.5,25.56,26.53,26.66,26.88,25.84,23.84,21.03,18.81,17.91,17.25,16.06,14.94,14.12,13.09,10.47,7.94,6.69,5.59,4.97,4.34,5.06,6.78,8.09,8.66,8.72,9.59,9.84,9.34,9.16,10.78,12.62,13.41,13.91,14.5,13.88,12.03,9.22,7.0,5.53,4.09,2.0,0.38,0.0,-0.38,-1.16,-1.62,-0.88,0.03,0.12,-0.09,0.06,0.38,0.5,0.03,0.5,2.12,3.75,4.22,5.22,6.91,8.31,8.38,8.16,8.12,7.75,6.09,4.28,3.31,3.34,3.16,2.84,3.38,4.06,3.88,2.44,0.53,-0.09,-1.06,-2.66,-3.72,-3.56,-3.03,-2.59,-2.97,-2.31,-1.19,-0.97,-1.28,-1.09,-0.59,-0.16,-0.72,-0.97,0.12,1.78,2.47,3.38,4.97,6.41,6.72,6.28,6.0,6.25,6.25,5.69,6.03,7.22,8.16,8.28,8.41,9.53,11.22,12.5,13.78,15.94,18.41,19.97,20.75,21.88,23.22,23.97,23.38,22.66,21.78,20.16,16.78,13.06,10.03,7.94,5.75,3.97,4.28,5.47,6.72,7.72,9.38,11.72,14.0,14.91,15.88,16.66,17.5,16.41,15.06,14.03,13.38,11.72,10.28,9.47,8.84,7.69,5.66,4.56,3.91,4.09,3.19,3.19,3.34,3.56,3.03,2.69,2.81,3.31,2.94,1.94,1.09,0.69,0.12,-0.31,-0.25,1.12,2.78,3.16,3.31,3.75,4.5,4.59,4.84,6.0,7.72,8.72,8.84,8.38,8.09,6.97,4.53,2.72,1.5,0.47,-1.19,-2.91,-3.81,-3.69,-4.03,-4.22,-3.78,-2.56,-1.69,-1.19,0.09,2.38,4.5,5.59,5.88,6.53,7.69,8.25,9.47,11.47,13.72,14.28,13.81,12.19,10.97,9.31,7.28,5.94,5.47,5.22,3.97,2.94,2.28,1.69,0.38,-0.34,-0.06,1.59,3.28,4.94,6.44,8.19,8.75,8.16,7.5,7.84,8.09,7.84,7.97,8.78,10.25,11.66,12.66,14.03,15.16,15.44,14.62,13.62,13.47,12.84,11.28,9.56,8.22,6.94,5.09,3.78,3.5,3.81,4.34,4.56,5.0,7.09,9.16,10.75,12.59,14.72,16.0,16.19,16.12,17.06,18.5,19.28,19.91,20.47,21.06,20.75,19.84,18.56,17.62,16.38,14.44,13.12,13.16,13.72,13.66,13.41,13.88,14.31,13.88,13.12,12.84,13.56,13.5,12.97,12.5,12.5,11.59,9.97,7.81,6.53,5.78,5.06,4.78,6.34,9.03,11.25,13.22,14.91,16.28,16.19,15.53,14.91,15.44,16.19,16.0,16.09,15.88,15.38,13.78,12.09,11.62,11.69,12.34,12.56,13.16,13.81,13.88,13.12,12.12,11.88,11.16,10.31,9.72,10.19,11.12,11.81,11.97,12.12,12.34,12.0,11.19,10.62,11.03,11.16,10.12,8.88,8.62,8.81,8.62,8.41,9.53,11.0,11.75,12.59,13.56,15.28,16.12,16.12,16.44,17.31,18.41,19.12,19.16,19.84,20.66,20.75,20.66,21.78,22.91,23.53,23.09,22.19,21.25,19.41,16.75,14.41,13.22,12.91,12.25,12.41,13.91,15.41,16.12,15.69,15.56,15.34,15.28,15.34,16.41,18.62,20.78,22.09,22.69,23.34,23.0,21.03,18.34,16.25,14.22,12.84,12.12,12.31,13.41,14.69,14.78,14.59,15.19,15.97,16.38,17.06,18.53,19.75,19.5,18.44,18.0,17.44,16.91,16.12,15.47,15.16,13.97,12.25,10.09,8.94,7.75,6.03,4.47,3.75,4.06,3.97,3.84,5.0,6.94,8.59,9.12,10.19,11.25,12.28,12.34,12.44,12.97,13.16,12.5,11.97,12.72,14.19,15.62,16.38,17.0,17.09,15.69,12.38,9.38,6.53,4.69,2.91,2.06,3.0,4.47,5.72,6.62,8.75,11.25,13.47,15.19,16.94,18.66,19.75,18.91,17.5,16.12,14.75,12.28,9.84,8.44,7.66,6.66,5.12,4.56,4.44,3.66,2.09,0.84,0.53,0.56,0.16,0.16,1.28,2.5,2.59,2.47,3.22,4.31,5.09,5.44,6.44,7.38,7.56,7.03,6.81,7.19,8.41,9.19,10.19,11.81,13.91,14.66,14.38,14.84,15.44,15.88,15.88,16.47,17.75,18.75,18.5,17.97,17.75,17.41,15.97,14.97,14.31,14.44,14.0,13.28,12.91,12.94,12.06,10.44,9.19,8.84,9.0,9.16,9.97,12.0,13.88,14.81,15.5,16.09,17.12,17.22,16.41,16.16,16.38,16.38,15.97,15.88,17.06,18.38,18.69,18.53,18.56,18.12,16.44,14.16,12.5,11.56,10.88,10.0,9.81,10.56,10.78,10.12,9.44,9.47,9.88,9.91,10.75,12.84,15.44,17.16,18.16,18.72,19.19,18.5,17.53,16.81,16.81,16.53,15.38,14.41,13.59,13.38,12.0,10.72,10.59,10.91,10.47,9.62,8.94,8.84,8.91,8.78,9.03,10.84,12.34,12.59,12.44,12.72,13.34,12.66,11.81,11.59,12.0,11.78,11.47,11.44,12.5,12.94,12.44,11.81,11.75,11.78,10.53,10.0,10.66,12.5,13.31,14.19,14.91,15.72,15.09,13.97,13.0,12.94,12.59,10.91,9.03,7.66,6.31,3.81,1.72,1.47,2.72,3.94,5.66,8.12,11.34,13.56,14.97,16.59,18.84,20.31,20.78,20.97,21.94,22.69,21.97,21.62,22.25,23.16,23.16,22.78,21.84,20.66,18.56,15.62,13.19,12.56,12.56,12.41,12.81,14.31,15.94,16.56,16.84,17.19,18.12,17.91,17.16,16.25,16.0,15.94,14.88,14.66,16.5,18.66,19.72,20.06,20.94,21.0,20.12,18.44,17.66,17.62,17.12,15.81,15.03,15.16,14.88,13.53,12.38,12.53,12.91,12.84,12.53,13.53,14.81,14.91,14.66,14.34,14.91,15.09,14.5,14.25,14.5,13.84,12.19,10.28,9.0,8.06,6.62,5.34,5.03,5.34,4.91,4.69,4.0,4.19,4.03,3.62,3.5,4.62,6.28,7.25,8.38,10.28,12.38,13.31,13.38,14.06,14.28,13.5,11.62,9.47,8.19,6.5,4.75,3.75,4.34,5.38,5.62,5.69,6.75,7.91,8.09,7.72,8.25,9.34,9.47,8.88,8.25,8.09,7.5,6.03,4.97,5.34,6.59,7.44,8.03,9.09,10.5,11.03,9.88,9.25,8.69,7.94,6.5,5.59,6.25,7.09,7.5,7.59,8.75,9.47,9.06,7.56,6.88,7.03,7.41,8.25,10.78,14.38,17.88,20.44,22.84,26.19,29.09,31.25,33.06,34.91,35.75,34.41,31.31,27.69,24.03,20.12,15.75,12.75,11.53,11.12,10.56,9.59,9.31,8.31,5.53,1.66,-1.16,-3.19,-4.69,-5.44,-4.31,-1.44,1.72,4.28,7.19,10.69,13.28,14.53,14.78,15.59,15.88,15.19,14.09,13.47,13.34,12.5,10.97,9.53,8.19,6.69,3.97,1.75,0.53,-0.66,-2.75,-5.12,-6.25,-6.78,-7.16,-7.22,-5.97,-3.69,-1.53,-0.19,1.0,2.84,4.31,3.97,3.38,3.56,3.88,3.47,3.38,4.41,5.97,7.09,7.66,8.66,9.66,9.97,8.62,7.78,7.06,6.44,4.53,3.19,2.62,2.53,2.03,1.97,2.56,3.66,4.34,4.12,4.38,5.56,6.97,7.84,9.12,11.47,13.47,14.41,14.81,15.72,16.28,15.81,14.69,13.97,14.16,14.19,13.75,13.5,14.0,13.81,12.72,12.0,12.19,12.88,13.38,13.5,15.12,16.59,17.19,17.47,18.16,19.25,20.5,21.25,22.06,23.69,25.12,25.06,24.38,24.03,23.59,21.47,18.91,16.94,15.75,14.75,13.78,14.03,15.47,17.53,18.5,19.84,21.97,23.5,23.5,22.72,22.06,21.47,19.62,17.66,16.56,15.62,14.03,11.88,9.72,8.41,7.06,4.84,3.28,3.19,3.62,3.47,3.59,4.44,5.47,5.41,5.12,5.5,6.62,8.06,9.34,11.72,14.91,18.22,20.38,22.31,24.12,25.78,26.25,26.03,26.25,26.81,26.34,25.28,24.19,23.34,21.94,19.31,16.72,14.31,11.94,8.75,5.53,3.62,2.41,0.53,-0.97,-1.41,-0.62,0.38,1.59,3.75,6.91,9.41,10.91,12.22,13.22,13.66,12.72,11.41,10.25,9.62,8.47,7.56,7.62,9.25,11.34,13.5,16.28,19.44,22.0,22.06,21.06,19.72,18.03,15.59,13.56,12.91,13.5,13.81,13.75,14.22,14.88,14.91,14.25,13.5,13.66,13.53,12.66,11.81,11.47,10.97,9.62,8.06,7.31,7.38,6.84,6.12,5.53,5.12,4.62,3.66,3.03,3.91,4.66,4.91,5.09,5.56,7.03,8.34,9.81,12.25,15.38,18.16,19.72,20.78,21.88,22.5,22.31,22.44,23.81,25.31,25.97,26.03,25.75,25.53,24.5,23.28,23.0,23.78,24.47,24.91,25.31,26.03,26.09,24.5,21.91,19.66,16.88,14.41,12.47,12.03,13.66,15.19,16.81,18.38,20.62,22.19,23.12,23.75,25.12,26.31,26.53,25.94,25.91,25.81,24.91,23.5,22.47,21.62,20.31,18.25,15.91,14.56,13.0,10.88,8.97,8.09,8.12,8.44,8.53,9.59,10.66,10.72,9.59,9.09,44.06,43.97,43.38,42.75,41.88,41.41,41.34:10.0,10.69,12.78,14.22,14.94,15.69,16.44,16.53,15.06,13.56,12.88,12.16,11.12,9.69,8.75,7.69,6.47,5.5,6.25,8.5,11.53,14.09,16.25,18.91,20.53,21.34,21.94,23.5,25.56,26.53,26.66,26.88,25.84,23.84,21.03,18.81,17.91,17.25,16.06,14.94,14.12,13.09,10.47,7.94,6.69,5.59,4.97,4.34,5.06,6.78,8.09,8.66,8.72,9.59,9.84,9.34,9.16,10.78,12.62,13.41,13.91,14.5,13.88,12.03,9.22,7.0,5.53,4.09,2.0,0.38,0.0,-0.38,-1.16,-1.62,-0.88,0.03,0.12,-0.09,0.06,0.38,0.5,0.03,0.5,2.12,3.75,4.22,5.22,6.91,8.31,8.38,8.16,8.12,7.75,6.09,4.28,3.31,3.34,3.16,2.84,3.38,4.06,3.88,2.44,0.53,-0.09,-1.06,-2.66,-3.72,-3.56,-3.03,-2.59,-2.97,-2.31,-1.19,-0.97,-1.28,-1.09,-0.59,-0.16,-0.72,-0.97,0.12,1.78,2.47,3.38,4.97,6.41,6.72,6.28,6.0,6.25,6.25,5.69,6.03,7.22,8.16,8.28,8.41,9.53,11.22,12.5,13.78,15.94,18.41,19.97,20.75,21.88,23.22,23.97,23.38,22.66,21.78,20.16,16.78,13.06,10.03,7.94,5.75,3.97,4.28,5.47,6.72,7.72,9.38,11.72,14.0,14.91,15.88,16.66,17.5,16.41,15.06,14.03,13.38,11.72,10.28,9.47,8.84,7.69,5.66,4.56,3.91,4.09,3.19,3.19,3.34,3.56,3.03,2.69,2.81,3.31,2.94,1.94,1.09,0.69,0.12,-0.31,-0.25,1.12,2.78,3.16,3.31,3.75,4.5,4.59,4.84,6.0,7.72,8.72,8.84,8.38,8.09,6.97,4.53,2.72,1.5,0.47,-1.19,-2.91,-3.81,-3.69,-4.03,-4.22,-3.78,-2.56,-1.69,-1.19,0.09,2.38,4.5,5.59,5.88,6.53,7.69,8.25,9.47,11.47,13.72,14.28,13.81,12.19,10.97,9.31,7.28,5.94,5.47,5.22,3.97,2.94,2.28,1.69,0.38,-0.34,-0.06,1.59,3.28,4.94,6.44,8.19,8.75,8.16,7.5,7.84,8.09,7.84,7.97,8.78,10.25,11.66,12.66,14.03,15.16,15.44,14.62,13.62,13.47,12.84,11.28,9.56,8.22,6.94,5.09,3.78,3.5,3.81,4.34,4.56,5.0,7.09,9.16,10.75,12.59,14.72,16.0,16.19,16.12,17.06,18.5,19.28,19.91,20.47,21.06,20.75,19.84,18.56,17.62,16.38,14.44,13.12,13.16,13.72,13.66,13.41,13.88,14.31,13.88,13.12,12.84,13.56,13.5,12.97,12.5,12.5,11.59,9.97,7.81,6.53,5.78,5.06,4.78,6.34,9.03,11.25,13.22,14.91,16.28,16.19,15.53,14.91,15.44,16.19,16.0,16.09,15.88,15.38,13.78,12.09,11.62,11.69,12.34,12.56,13.16,13.81,13.88,13.12,12.12,11.88,11.16,10.31,9.72,10.19,11.12,11.81,11.97,12.12,12.34,12.0,11.19,10.62,11.03,11.16,10.12,8.88,8.62,8.81,8.62,8.41,9.53,11.0,11.75,12.59,13.56,15.28,16.12,16.12,16.44,17.31,18.41,19.12,19.16,19.84,20.66,20.75,20.66,21.78,22.91,23.53,23.09,22.19,21.25,19.41,16.75,14.41,13.22,12.91,12.25,12.41,13.91,15.41,16.12,15.69,15.56,15.34,15.28,15.34,16.41,18.62,20.78,22.09,22.69,23.34,23.0,21.03,18.34,16.25,14.22,12.84,12.12,12.31,13.41,14.69,14.78,14.59,15.19,15.97,16.38,17.06,18.53,19.75,19.5,18.44,18.0,17.44,16.91,16.12,15.47,15.16,13.97,12.25,10.09,8.94,7.75,6.03,4.47,3.75,4.06,3.97,3.84,5.0,6.94,8.59,9.12,10.19,11.25,12.28,12.34,12.44,12.97,13.16,12.5,11.97,12.72,14.19,15.62,16.38,17.0,17.09,15.69,12.38,9.38,6.53,4.69,2.91,2.06,3.0,4.47,5.72,6.62,8.75,11.25,13.47,15.19,16.94,18.66,19.75,18.91,17.5,16.12,14.75,12.28,9.84,8.44,7.66,6.66,5.12,4.56,4.44,3.66,2.09,0.84,0.53,0.56,0.16,0.16,1.28,2.5,2.59,2.47,3.22,4.31,5.09,5.44,6.44,7.38,7.56,7.03,6.81,7.19,8.41,9.19,10.19,11.81,13.91,14.66,14.38,14.84,15.44,15.88,15.88,16.47,17.75,18.75,18.5,17.97,17.75,17.41,15.97,14.97,14.31,14.44,14.0,13.28,12.91,12.94,12.06,10.44,9.19,8.84,9.0,9.16,9.97,12.0,13.88,14.81,15.5,16.09,17.12,17.22,16.41,16.16,16.38,16.38,15.97,15.88,17.06,18.38,18.69,18.53,18.56,18.12,16.44,14.16,12.5,11.56,10.88,10.0,9.81,10.56,10.78,10.12,9.44,9.47,9.88,9.91,10.75,12.84,15.44,17.16,18.16,18.72,19.19,18.5,17.53,16.81,16.81,16.53,15.38,14.41,13.59,13.38,12.0,10.72,10.59,10.91,10.47,9.62,8.94,8.84,8.91,8.78,9.03,10.84,12.34,12.59,12.44,12.72,13.34,12.66,11.81,11.59,12.0,11.78,11.47,11.44,12.5,12.94,12.44,11.81,11.75,11.78,10.53,10.0,10.66,12.5,13.31,14.19,14.91,15.72,15.09,13.97,13.0,12.94,12.59,10.91,9.03,7.66,6.31,3.81,1.72,1.47,2.72,3.94,5.66,8.12,11.34,13.56,14.97,16.59,18.84,20.31,20.78,20.97,21.94,22.69,21.97,21.62,22.25,23.16,23.16,22.78,21.84,20.66,18.56,15.62,13.19,12.56,12.56,12.41,12.81,14.31,15.94,16.56,16.84,17.19,18.12,17.91,17.16,16.25,16.0,15.94,14.88,14.66,16.5,18.66,19.72,20.06,20.94,21.0,20.12,18.44,17.66,17.62,17.12,15.81,15.03,15.16,14.88,13.53,12.38,12.53,12.91,12.84,12.53,13.53,14.81,14.91,14.66,14.34,14.91,15.09,14.5,14.25,14.5,13.84,12.19,10.28,9.0,8.06,6.62,5.34,5.03,5.34,4.91,4.69,4.0,4.19,4.03,3.62,3.5,4.62,6.28,7.25,8.38,10.28,12.38,13.31,13.38,14.06,14.28,13.5,11.62,9.47,8.19,6.5,4.75,3.75,4.34,5.38,5.62,5.69,6.75,7.91,8.09,7.72,8.25,9.34,9.47,8.88,8.25,8.09,7.5,6.03,4.97,5.34,6.59,7.44,8.03,9.09,10.5,11.03,9.88,9.25,8.69,7.94,6.5,5.59,6.25,7.09,7.5,7.59,8.75,9.47,9.06,7.56,6.88,7.03,7.41,8.25,10.78,14.38,17.88,20.44,22.84,26.19,29.09,31.25,33.06,34.91,35.75,34.41,31.31,27.69,24.03,20.12,15.75,12.75,11.53,11.12,10.56,9.59,9.31,8.31,5.53,1.66,-1.16,-3.19,-4.69,-5.44,-4.31,-1.44,1.72,4.28,7.19,10.69,13.28,14.53,14.78,15.59,15.88,15.19,14.09,13.47,13.34,12.5,10.97,9.53,8.19,6.69,3.97,1.75,0.53,-0.66,-2.75,-5.12,-6.25,-6.78,-7.16,-7.22,-5.97,-3.69,-1.53,-0.19,1.0,2.84,4.31,3.97,3.38,3.56,3.88,3.47,3.38,4.41,5.97,7.09,7.66,8.66,9.66,9.97,8.62,7.78,7.06,6.44,4.53,3.19,2.62,2.53,2.03,1.97,2.56,3.66,4.34,4.12,4.38,5.56,6.97,7.84,9.12,11.47,13.47,14.41,14.81,15.72,16.28,15.81,14.69,13.97,14.16,14.19,13.75,13.5,14.0,13.81,12.72,12.0,12.19,12.88,13.38,13.5,15.12,16.59,17.19,17.47,18.16,19.25,20.5,21.25,22.06,23.69,25.12,25.06,24.38,24.03,23.59,21.47,18.91,16.94,15.75,14.75,13.78,14.03,15.47,17.53,18.5,19.84,21.97,23.5,23.5,22.72,22.06,21.47,19.62,17.66,16.56,15.62,14.03,11.88,9.72,8.41,7.06,4.84,3.28,3.19,3.62,3.47,3.59,4.44,5.47,5.41,5.12,5.5,6.62,8.06,9.34,11.72,14.91,18.22,20.38,22.31,24.12,25.78,26.25,26.03,26.25,26.81,26.34,25.28,24.19,23.34,21.94,19.31,16.72,14.31,11.94,8.75,5.53,3.62,2.41,0.53,-0.97,-1.41,-0.62,0.38,1.59,3.75,6.91,9.41,10.91,12.22,13.22,13.66,12.72,11.41,10.25,9.62,8.47,7.56,7.62,9.25,11.34,13.5,16.28,19.44,22.0,22.06,21.06,19.72,18.03,15.59,13.56,12.91,13.5,13.81,13.75,14.22,14.88,14.91,14.25,13.5,13.66,13.53,12.66,11.81,11.47,10.97,9.62,8.06,7.31,7.38,6.84,6.12,5.53,5.12,4.62,3.66,3.03,3.91,4.66,4.91,5.09,5.56,7.03,8.34,9.81,12.25,15.38,18.16,19.72,20.78,21.88,22.5,22.31,22.44,23.81,25.31,25.97,26.03,25.75,25.53,24.5,23.28,23.0,23.78,24.47,24.91,25.31,26.03,26.09,24.5,21.91,19.66,16.88,14.41,12.47,12.03,13.66,15.19,16.81,18.38,20.62,22.19,23.12,23.75,25.12,26.31,26.53,25.94,25.91,25.81,24.91,23.5,22.47,21.62,20.31,18.25,15.91,14.56,13.0,10.88,8.97,8.09,8.12,8.44,8.53,9.59,10.66,10.72,9.59,9.09,44.06,43.97,43.38,42.75,41.88,41.41,41.34,41.44,42.0,42.47,42.62,42.41,42.97,43.88:16.53,15.06,13.56,12.88,12.16,11.12,9.69,8.75,7.69,6.47,5.5,6.25,8.5,11.53,14.09,16.25,18.91,20.53,21.34,21.94,23.5,25.56,26.53,26.66,26.88,25.84,23.84,21.03,18.81,17.91,17.25,16.06,14.94,14.12,13.09,10.47,7.94,6.69,5.59,4.97,4.34,5.06,6.78,8.09,8.66,8.72,9.59,9.84,9.34,9.16,10.78,12.62,13.41,13.91,14.5,13.88,12.03,9.22,7.0,5.53,4.09,2.0,0.38,0.0,-0.38,-1.16,-1.62,-0.88,0.03,0.12,-0.09,0.06,0.38,0.5,0.03,0.5,2.12,3.75,4.22,5.22,6.91,8.31,8.38,8.16,8.12,7.75,6.09,4.28,3.31,3.34,3.16,2.84,3.38,4.06,3.88,2.44,0.53,-0.09,-1.06,-2.66,-3.72,-3.56,-3.03,-2.59,-2.97,-2.31,-1.19,-0.97,-1.28,-1.09,-0.59,-0.16,-0.72,-0.97,0.12,1.78,2.47,3.38,4.97,6.41,6.72,6.28,6.0,6.25,6.25,5.69,6.03,7.22,8.16,8.28,8.41,9.53,11.22,12.5,13.78,15.94,18.41,19.97,20.75,21.88,23.22,23.97,23.38,22.66,21.78,20.16,16.78,13.06,10.03,7.94,5.75,3.97,4.28,5.47,6.72,7.72,9.38,11.72,14.0,14.91,15.88,16.66,17.5,16.41,15.06,14.03,13.38,11.72,10.28,9.47,8.84,7.69,5.66,4.56,3.91,4.09,3.19,3.19,3.34,3.56,3.03,2.69,2.81,3.31,2.94,1.94,1.09,0.69,0.12,-0.31,-0.25,1.12,2.78,3.16,3.31,3.75,4.5,4.59,4.84,6.0,7.72,8.72,8.84,8.38,8.09,6.97,4.53,2.72,1.5,0.47,-1.19,-2.91,-3.81,-3.69,-4.03,-4.22,-3.78,-2.56,-1.69,-1.19,0.09,2.38,4.5,5.59,5.88,6.53,7.69,8.25,9.47,11.47,13.72,14.28,13.81,12.19,10.97,9.31,7.28,5.94,5.47,5.22,3.97,2.94,2.28,1.69,0.38,-0.34,-0.06,1.59,3.28,4.94,6.44,8.19,8.75,8.16,7.5,7.84,8.09,7.84,7.97,8.78,10.25,11.66,12.66,14.03,15.16,15.44,14.62,13.62,13.47,12.84,11.28,9.56,8.22,6.94,5.09,3.78,3.5,3.81,4.34,4.56,5.0,7.09,9.16,10.75,12.59,14.72,16.0,16.19,16.12,17.06,18.5,19.28,19.91,20.47,21.06,20.75,19.84,18.56,17.62,16.38,14.44,13.12,13.16,13.72,13.66,13.41,13.88,14.31,13.88,13.12,12.84,13.56,13.5,12.97,12.5,12.5,11.59,9.97,7.81,6.53,5.78,5.06,4.78,6.34,9.03,11.25,13.22,14.91,16.28,16.19,15.53,14.91,15.44,16.19,16.0,16.09,15.88,15.38,13.78,12.09,11.62,11.69,12.34,12.56,13.16,13.81,13.88,13.12,12.12,11.88,11.16,10.31,9.72,10.19,11.12,11.81,11.97,12.12,12.34,12.0,11.19,10.62,11.03,11.16,10.12,8.88,8.62,8.81,8.62,8.41,9.53,11.0,11.75,12.59,13.56,15.28,16.12,16.12,16.44,17.31,18.41,19.12,19.16,19.84,20.66,20.75,20.66,21.78,22.91,23.53,23.09,22.19,21.25,19.41,16.75,14.41,13.22,12.91,12.25,12.41,13.91,15.41,16.12,15.69,15.56,15.34,15.28,15.34,16.41,18.62,20.78,22.09,22.69,23.34,23.0,21.03,18.34,16.25,14.22,12.84,12.12,12.31,13.41,14.69,14.78,14.59,15.19,15.97,16.38,17.06,18.53,19.75,19.5,18.44,18.0,17.44,16.91,16.12,15.47,15.16,13.97,12.25,10.09,8.94,7.75,6.03,4.47,3.75,4.06,3.97,3.84,5.0,6.94,8.59,9.12,10.19,11.25,12.28,12.34,12.44,12.97,13.16,12.5,11.97,12.72,14.19,15.62,16.38,17.0,17.09,15.69,12.38,9.38,6.53,4.69,2.91,2.06,3.0,4.47,5.72,6.62,8.75,11.25,13.47,15.19,16.94,18.66,19.75,18.91,17.5,16.12,14.75,12.28,9.84,8.44,7.66,6.66,5.12,4.56,4.44,3.66,2.09,0.84,0.53,0.56,0.16,0.16,1.28,2.5,2.59,2.47,3.22,4.31,5.09,5.44,6.44,7.38,7.56,7.03,6.81,7.19,8.41,9.19,10.19,11.81,13.91,14.66,14.38,14.84,15.44,15.88,15.88,16.47,17.75,18.75,18.5,17.97,17.75,17.41,15.97,14.97,14.31,14.44,14.0,13.28,12.91,12.94,12.06,10.44,9.19,8.84,9.0,9.16,9.97,12.0,13.88,14.81,15.5,16.09,17.12,17.22,16.41,16.16,16.38,16.38,15.97,15.88,17.06,18.38,18.69,18.53,18.56,18.12,16.44,14.16,12.5,11.56,10.88,10.0,9.81,10.56,10.78,10.12,9.44,9.47,9.88,9.91,10.75,12.84,15.44,17.16,18.16,18.72,19.19,18.5,17.53,16.81,16.81,16.53,15.38,14.41,13.59,13.38,12.0,10.72,10.59,10.91,10.47,9.62,8.94,8.84,8.91,8.78,9.03,10.84,12.34,12.59,12.44,12.72,13.34,12.66,11.81,11.59,12.0,11.78,11.47,11.44,12.5,12.94,12.44,11.81,11.75,11.78,10.53,10.0,10.66,12.5,13.31,14.19,14.91,15.72,15.09,13.97,13.0,12.94,12.59,10.91,9.03,7.66,6.31,3.81,1.72,1.47,2.72,3.94,5.66,8.12,11.34,13.56,14.97,16.59,18.84,20.31,20.78,20.97,21.94,22.69,21.97,21.62,22.25,23.16,23.16,22.78,21.84,20.66,18.56,15.62,13.19,12.56,12.56,12.41,12.81,14.31,15.94,16.56,16.84,17.19,18.12,17.91,17.16,16.25,16.0,15.94,14.88,14.66,16.5,18.66,19.72,20.06,20.94,21.0,20.12,18.44,17.66,17.62,17.12,15.81,15.03,15.16,14.88,13.53,12.38,12.53,12.91,12.84,12.53,13.53,14.81,14.91,14.66,14.34,14.91,15.09,14.5,14.25,14.5,13.84,12.19,10.28,9.0,8.06,6.62,5.34,5.03,5.34,4.91,4.69,4.0,4.19,4.03,3.62,3.5,4.62,6.28,7.25,8.38,10.28,12.38,13.31,13.38,14.06,14.28,13.5,11.62,9.47,8.19,6.5,4.75,3.75,4.34,5.38,5.62,5.69,6.75,7.91,8.09,7.72,8.25,9.34,9.47,8.88,8.25,8.09,7.5,6.03,4.97,5.34,6.59,7.44,8.03,9.09,10.5,11.03,9.88,9.25,8.69,7.94,6.5,5.59,6.25,7.09,7.5,7.59,8.75,9.47,9.06,7.56,6.88,7.03,7.41,8.25,10.78,14.38,17.88,20.44,22.84,26.19,29.09,31.25,33.06,34.91,35.75,34.41,31.31,27.69,24.03,20.12,15.75,12.75,11.53,11.12,10.56,9.59,9.31,8.31,5.53,1.66,-1.16,-3.19,-4.69,-5.44,-4.31,-1.44,1.72,4.28,7.19,10.69,13.28,14.53,14.78,15.59,15.88,15.19,14.09,13.47,13.34,12.5,10.97,9.53,8.19,6.69,3.97,1.75,0.53,-0.66,-2.75,-5.12,-6.25,-6.78,-7.16,-7.22,-5.97,-3.69,-1.53,-0.19,1.0,2.84,4.31,3.97,3.38,3.56,3.88,3.47,3.38,4.41,5.97,7.09,7.66,8.66,9.66,9.97,8.62,7.78,7.06,6.44,4.53,3.19,2.62,2.53,2.03,1.97,2.56,3.66,4.34,4.12,4.38,5.56,6.97,7.84,9.12,11.47,13.47,14.41,14.81,15.72,16.28,15.81,14.69,13.97,14.16,14.19,13.75,13.5,14.0,13.81,12.72,12.0,12.19,12.88,13.38,13.5,15.12,16.59,17.19,17.47,18.16,19.25,20.5,21.25,22.06,23.69,25.12,25.06,24.38,24.03,23.59,21.47,18.91,16.94,15.75,14.75,13.78,14.03,15.47,17.53,18.5,19.84,21.97,23.5,23.5,22.72,22.06,21.47,19.62,17.66,16.56,15.62,14.03,11.88,9.72,8.41,7.06,4.84,3.28,3.19,3.62,3.47,3.59,4.44,5.47,5.41,5.12,5.5,6.62,8.06,9.34,11.72,14.91,18.22,20.38,22.31,24.12,25.78,26.25,26.03,26.25,26.81,26.34,25.28,24.19,23.34,21.94,19.31,16.72,14.31,11.94,8.75,5.53,3.62,2.41,0.53,-0.97,-1.41,-0.62,0.38,1.59,3.75,6.91,9.41,10.91,12.22,13.22,13.66,12.72,11.41,10.25,9.62,8.47,7.56,7.62,9.25,11.34,13.5,16.28,19.44,22.0,22.06,21.06,19.72,18.03,15.59,13.56,12.91,13.5,13.81,13.75,14.22,14.88,14.91,14.25,13.5,13.66,13.53,12.66,11.81,11.47,10.97,9.62,8.06,7.31,7.38,6.84,6.12,5.53,5.12,4.62,3.66,3.03,3.91,4.66,4.91,5.09,5.56,7.03,8.34,9.81,12.25,15.38,18.16,19.72,20.78,21.88,22.5,22.31,22.44,23.81,25.31,25.97,26.03,25.75,25.53,24.5,23.28,23.0,23.78,24.47,24.91,25.31,26.03,26.09,24.5,21.91,19.66,16.88,14.41,12.47,12.03,13.66,15.19,16.81,18.38,20.62,22.19,23.12,23.75,25.12,26.31,26.53,25.94,25.91,25.81,24.91,23.5,22.47,21.62,20.31,18.25,15.91,14.56,13.0,10.88,8.97,8.09,8.12,8.44,8.53,9.59,10.66,10.72,9.59,9.09,44.06,43.97,43.38,42.75,41.88,41.41,41.34,41.44,42.0,42.47,42.62,42.41,42.97,43.88,45.19,46.56,48.72,50.41,51.62,52.25,52.5:8.75,7.69,6.47,5.5,6.25,8.5,11.53,14.09,16.25,18.91,20.53,21.34,21.94,23.5,25.56,26.53,26.66,26.88,25.84,23.84,21.03,18.81,17.91,17.25,16.06,14.94,14.12,13.09,10.47,7.94,6.69,5.59,4.97,4.34,5.06,6.78,8.09,8.66,8.72,9.59,9.84,9.34,9.16,10.78,12.62,13.41,13.91,14.5,13.88,12.03,9.22,7.0,5.53,4.09,2.0,0.38,0.0,-0.38,-1.16,-1.62,-0.88,0.03,0.12,-0.09,0.06,0.38,0.5,0.03,0.5,2.12,3.75,4.22,5.22,6.91,8.31,8.38,8.16,8.12,7.75,6.09,4.28,3.31,3.34,3.16,2.84,3.38,4.06,3.88,2.44,0.53,-0.09,-1.06,-2.66,-3.72,-3.56,-3.03,-2.59,-2.97,-2.31,-1.19,-0.97,-1.28,-1.09,-0.59,-0.16,-0.72,-0.97,0.12,1.78,2.47,3.38,4.97,6.41,6.72,6.28,6.0,6.25,6.25,5.69,6.03,7.22,8.16,8.28,8.41,9.53,11.22,12.5,13.78,15.94,18.41,19.97,20.75,21.88,23.22,23.97,23.38,22.66,21.78,20.16,16.78,13.06,10.03,7.94,5.75,3.97,4.28,5.47,6.72,7.72,9.38,11.72,14.0,14.91,15.88,16.66,17.5,16.41,15.06,14.03,13.38,11.72,10.28,9.47,8.84,7.69,5.66,4.56,3.91,4.09,3.19,3.19,3.34,3.56,3.03,2.69,2.81,3.31,2.94,1.94,1.09,0.69,0.12,-0.31,-0.25,1.12,2.78,3.16,3.31,3.75,4.5,4.59,4.84,6.0,7.72,8.72,8.84,8.38,8.09,6.97,4.53,2.72,1.5,0.47,-1.19,-2.91,-3.81,-3.69,-4.03,-4.22,-3.78,-2.56,-1.69,-1.19,0.09,2.38,4.5,5.59,5.88,6.53,7.69,8.25,9.47,11.47,13.72,14.28,13.81,12.19,10.97,9.31,7.28,5.94,5.47,5.22,3.97,2.94,2.28,1.69,0.38,-0.34,-0.06,1.59,3.28,4.94,6.44,8.19,8.75,8.16,7.5,7.84,8.09,7.84,7.97,8.78,10.25,11.66,12.66,14.03,15.16,15.44,14.62,13.62,13.47,12.84,11.28,9.56,8.22,6.94,5.09,3.78,3.5,3.81,4.34,4.56,5.0,7.09,9.16,10.75,12.59,14.72,16.0,16.19,16.12,17.06,18.5,19.28,19.91,20.47,21.06,20.75,19.84,18.56,17.62,16.38,14.44,13.12,13.16,13.72,13.66,13.41,13.88,14.31,13.88,13.12,12.84,13.56,13.5,12.97,12.5,12.5,11.59,9.97,7.81,6.53,5.78,5.06,4.78,6.34,9.03,11.25,13.22,14.91,16.28,16.19,15.53,14.91,15.44,16.19,16.0,16.09,15.88,15.38,13.78,12.09,11.62,11.69,12.34,12.56,13.16,13.81,13.88,13.12,12.12,11.88,11.16,10.31,9.72,10.19,11.12,11.81,11.97,12.12,12.34,12.0,11.19,10.62,11.03,11.16,10.12,8.88,8.62,8.81,8.62,8.41,9.53,11.0,11.75,12.59,13.56,15.28,16.12,16.12,16.44,17.31,18.41,19.12,19.16,19.84,20.66,20.75,20.66,21.78,22.91,23.53,23.09,22.19,21.25,19.41,16.75,14.41,13.22,12.91,12.25,12.41,13.91,15.41,16.12,15.69,15.56,15.34,15.28,15.34,16.41,18.62,20.78,22.09,22.69,23.34,23.0,21.03,18.34,16.25,14.22,12.84,12.12,12.31,13.41,14.69,14.78,14.59,15.19,15.97,16.38,17.06,18.53,19.75,19.5,18.44,18.0,17.44,16.91,16.12,15.47,15.16,13.97,12.25,10.09,8.94,7.75,6.03,4.47,3.75,4.06,3.97,3.84,5.0,6.94,8.59,9.12,10.19,11.25,12.28,12.34,12.44,12.97,13.16,12.5,11.97,12.72,14.19,15.62,16.38,17.0,17.09,15.69,12.38,9.38,6.53,4.69,2.91,2.06,3.0,4.47,5.72,6.62,8.75,11.25,13.47,15.19,16.94,18.66,19.75,18.91,17.5,16.12,14.75,12.28,9.84,8.44,7.66,6.66,5.12,4.56,4.44,3.66,2.09,0.84,0.53,0.56,0.16,0.16,1.28,2.5,2.59,2.47,3.22,4.31,5.09,5.44,6.44,7.38,7.56,7.03,6.81,7.19,8.41,9.19,10.19,11.81,13.91,14.66,14.38,14.84,15.44,15.88,15.88,16.47,17.75,18.75,18.5,17.97,17.75,17.41,15.97,14.97,14.31,14.44,14.0,13.28,12.91,12.94,12.06,10.44,9.19,8.84,9.0,9.16,9.97,12.0,13.88,14.81,15.5,16.09,17.12,17.22,16.41,16.16,16.38,16.38,15.97,15.88,17.06,18.38,18.69,18.53,18.56,18.12,16.44,14.16,12.5,11.56,10.88,10.0,9.81,10.56,10.78,10.12,9.44,9.47,9.88,9.91,10.75,12.84,15.44,17.16,18.16,18.72,19.19,18.5,17.53,16.81,16.81,16.53,15.38,14.41,13.59,13.38,12.0,10.72,10.59,10.91,10.47,9.62,8.94,8.84,8.91,8.78,9.03,10.84,12.34,12.59,12.44,12.72,13.34,12.66,11.81,11.59,12.0,11.78,11.47,11.44,12.5,12.94,12.44,11.81,11.75,11.78,10.53,10.0,10.66,12.5,13.31,14.19,14.91,15.72,15.09,13.97,13.0,12.94,12.59,10.91,9.03,7.66,6.31,3.81,1.72,1.47,2.72,3.94,5.66,8.12,11.34,13.56,14.97,16.59,18.84,20.31,20.78,20.97,21.94,22.69,21.97,21.62,22.25,23.16,23.16,22.78,21.84,20.66,18.56,15.62,13.19,12.56,12.56,12.41,12.81,14.31,15.94,16.56,16.84,17.19,18.12,17.91,17.16,16.25,16.0,15.94,14.88,14.66,16.5,18.66,19.72,20.06,20.94,21.0,20.12,18.44,17.66,17.62,17.12,15.81,15.03,15.16,14.88,13.53,12.38,12.53,12.91,12.84,12.53,13.53,14.81,14.91,14.66,14.34,14.91,15.09,14.5,14.25,14.5,13.84,12.19,10.28,9.0,8.06,6.62,5.34,5.03,5.34,4.91,4.69,4.0,4.19,4.03,3.62,3.5,4.62,6.28,7.25,8.38,10.28,12.38,13.31,13.38,14.06,14.28,13.5,11.62,9.47,8.19,6.5,4.75,3.75,4.34,5.38,5.62,5.69,6.75,7.91,8.09,7.72,8.25,9.34,9.47,8.88,8.25,8.09,7.5,6.03,4.97,5.34,6.59,7.44,8.03,9.09,10.5,11.03,9.88,9.25,8.69,7.94,6.5,5.59,6.25,7.09,7.5,7.59,8.75,9.47,9.06,7.56,6.88,7.03,7.41,8.25,10.78,14.38,17.88,20.44,22.84,26.19,29.09,31.25,33.06,34.91,35.75,34.41,31.31,27.69,24.03,20.12,15.75,12.75,11.53,11.12,10.56,9.59,9.31,8.31,5.53,1.66,-1.16,-3.19,-4.69,-5.44,-4.31,-1.44,1.72,4.28,7.19,10.69,13.28,14.53,14.78,15.59,15.88,15.19,14.09,13.47,13.34,12.5,10.97,9.53,8.19,6.69,3.97,1.75,0.53,-0.66,-2.75,-5.12,-6.25,-6.78,-7.16,-7.22,-5.97,-3.69,-1.53,-0.19,1.0,2.84,4.31,3.97,3.38,3.56,3.88,3.47,3.38,4.41,5.97,7.09,7.66,8.66,9.66,9.97,8.62,7.78,7.06,6.44,4.53,3.19,2.62,2.53,2.03,1.97,2.56,3.66,4.34,4.12,4.38,5.56,6.97,7.84,9.12,11.47,13.47,14.41,14.81,15.72,16.28,15.81,14.69,13.97,14.16,14.19,13.75,13.5,14.0,13.81,12.72,12.0,12.19,12.88,13.38,13.5,15.12,16.59,17.19,17.47,18.16,19.25,20.5,21.25,22.06,23.69,25.12,25.06,24.38,24.03,23.59,21.47,18.91,16.94,15.75,14.75,13.78,14.03,15.47,17.53,18.5,19.84,21.97,23.5,23.5,22.72,22.06,21.47,19.62,17.66,16.56,15.62,14.03,11.88,9.72,8.41,7.06,4.84,3.28,3.19,3.62,3.47,3.59,4.44,5.47,5.41,5.12,5.5,6.62,8.06,9.34,11.72,14.91,18.22,20.38,22.31,24.12,25.78,26.25,26.03,26.25,26.81,26.34,25.28,24.19,23.34,21.94,19.31,16.72,14.31,11.94,8.75,5.53,3.62,2.41,0.53,-0.97,-1.41,-0.62,0.38,1.59,3.75,6.91,9.41,10.91,12.22,13.22,13.66,12.72,11.41,10.25,9.62,8.47,7.56,7.62,9.25,11.34,13.5,16.28,19.44,22.0,22.06,21.06,19.72,18.03,15.59,13.56,12.91,13.5,13.81,13.75,14.22,14.88,14.91,14.25,13.5,13.66,13.53,12.66,11.81,11.47,10.97,9.62,8.06,7.31,7.38,6.84,6.12,5.53,5.12,4.62,3.66,3.03,3.91,4.66,4.91,5.09,5.56,7.03,8.34,9.81,12.25,15.38,18.16,19.72,20.78,21.88,22.5,22.31,22.44,23.81,25.31,25.97,26.03,25.75,25.53,24.5,23.28,23.0,23.78,24.47,24.91,25.31,26.03,26.09,24.5,21.91,19.66,16.88,14.41,12.47,12.03,13.66,15.19,16.81,18.38,20.62,22.19,23.12,23.75,25.12,26.31,26.53,25.94,25.91,25.81,24.91,23.5,22.47,21.62,20.31,18.25,15.91,14.56,13.0,10.88,8.97,8.09,8.12,8.44,8.53,9.59,10.66,10.72,9.59,9.09,44.06,43.97,43.38,42.75,41.88,41.41,41.34,41.44,42.0,42.47,42.62,42.41,42.97,43.88,45.19,46.56,48.72,50.41,51.62,52.25,52.5,52.12,51.41,50.19,49.28,48.69,48.38,47.59:14.09,16.25,18.91,20.53,21.34,21.94,23.5,25.56,26.53,26.66,26.88,25.84,23.84,21.03,18.81,17.91,17.25,16.06,14.94,14.12,13.09,10.47,7.94,6.69,5.59,4.97,4.34,5.06,6.78,8.09,8.66,8.72,9.59,9.84,9.34,9.16,10.78,12.62,13.41,13.91,14.5,13.88,12.03,9.22,7.0,5.53,4.09,2.0,0.38,0.0,-0.38,-1.16,-1.62,-0.88,0.03,0.12,-0.09,0.06,0.38,0.5,0.03,0.5,2.12,3.75,4.22,5.22,6.91,8.31,8.38,8.16,8.12,7.75,6.09,4.28,3.31,3.34,3.16,2.84,3.38,4.06,3.88,2.44,0.53,-0.09,-1.06,-2.66,-3.72,-3.56,-3.03,-2.59,-2.97,-2.31,-1.19,-0.97,-1.28,-1.09,-0.59,-0.16,-0.72,-0.97,0.12,1.78,2.47,3.38,4.97,6.41,6.72,6.28,6.0,6.25,6.25,5.69,6.03,7.22,8.16,8.28,8.41,9.53,11.22,12.5,13.78,15.94,18.41,19.97,20.75,21.88,23.22,23.97,23.38,22.66,21.78,20.16,16.78,13.06,10.03,7.94,5.75,3.97,4.28,5.47,6.72,7.72,9.38,11.72,14.0,14.91,15.88,16.66,17.5,16.41,15.06,14.03,13.38,11.72,10.28,9.47,8.84,7.69,5.66,4.56,3.91,4.09,3.19,3.19,3.34,3.56,3.03,2.69,2.81,3.31,2.94,1.94,1.09,0.69,0.12,-0.31,-0.25,1.12,2.78,3.16,3.31,3.75,4.5,4.59,4.84,6.0,7.72,8.72,8.84,8.38,8.09,6.97,4.53,2.72,1.5,0.47,-1.19,-2.91,-3.81,-3.69,-4.03,-4.22,-3.78,-2.56,-1.69,-1.19,0.09,2.38,4.5,5.59,5.88,6.53,7.69,8.25,9.47,11.47,13.72,14.28,13.81,12.19,10.97,9.31,7.28,5.94,5.47,5.22,3.97,2.94,2.28,1.69,0.38,-0.34,-0.06,1.59,3.28,4.94,6.44,8.19,8.75,8.16,7.5,7.84,8.09,7.84,7.97,8.78,10.25,11.66,12.66,14.03,15.16,15.44,14.62,13.62,13.47,12.84,11.28,9.56,8.22,6.94,5.09,3.78,3.5,3.81,4.34,4.56,5.0,7.09,9.16,10.75,12.59,14.72,16.0,16.19,16.12,17.06,18.5,19.28,19.91,20.47,21.06,20.75,19.84,18.56,17.62,16.38,14.44,13.12,13.16,13.72,13.66,13.41,13.88,14.31,13.88,13.12,12.84,13.56,13.5,12.97,12.5,12.5,11.59,9.97,7.81,6.53,5.78,5.06,4.78,6.34,9.03,11.25,13.22,14.91,16.28,16.19,15.53,14.91,15.44,16.19,16.0,16.09,15.88,15.38,13.78,12.09,11.62,11.69,12.34,12.56,13.16,13.81,13.88,13.12,12.12,11.88,11.16,10.31,9.72,10.19,11.12,11.81,11.97,12.12,12.34,12.0,11.19,10.62,11.03,11.16,10.12,8.88,8.62,8.81,8.62,8.41,9.53,11.0,11.75,12.59,13.56,15.28,16.12,16.12,16.44,17.31,18.41,19.12,19.16,19.84,20.66,20.75,20.66,21.78,22.91,23.53,23.09,22.19,21.25,19.41,16.75,14.41,13.22,12.91,12.25,12.41,13.91,15.41,16.12,15.69,15.56,15.34,15.28,15.34,16.41,18.62,20.78,22.09,22.69,23.34,23.0,21.03,18.34,16.25,14.22,12.84,12.12,12.31,13.41,14.69,14.78,14.59,15.19,15.97,16.38,17.06,18.53,19.75,19.5,18.44,18.0,17.44,16.91,16.12,15.47,15.16,13.97,12.25,10.09,8.94,7.75,6.03,4.47,3.75,4.06,3.97,3.84,5.0,6.94,8.59,9.12,10.19,11.25,12.28,12.34,12.44,12.97,13.16,12.5,11.97,12.72,14.19,15.62,16.38,17.0,17.09,15.69,12.38,9.38,6.53,4.69,2.91,2.06,3.0,4.47,5.72,6.62,8.75,11.25,13.47,15.19,16.94,18.66,19.75,18.91,17.5,16.12,14.75,12.28,9.84,8.44,7.66,6.66,5.12,4.56,4.44,3.66,2.09,0.84,0.53,0.56,0.16,0.16,1.28,2.5,2.59,2.47,3.22,4.31,5.09,5.44,6.44,7.38,7.56,7.03,6.81,7.19,8.41,9.19,10.19,11.81,13.91,14.66,14.38,14.84,15.44,15.88,15.88,16.47,17.75,18.75,18.5,17.97,17.75,17.41,15.97,14.97,14.31,14.44,14.0,13.28,12.91,12.94,12.06,10.44,9.19,8.84,9.0,9.16,9.97,12.0,13.88,14.81,15.5,16.09,17.12,17.22,16.41,16.16,16.38,16.38,15.97,15.88,17.06,18.38,18.69,18.53,18.56,18.12,16.44,14.16,12.5,11.56,10.88,10.0,9.81,10.56,10.78,10.12,9.44,9.47,9.88,9.91,10.75,12.84,15.44,17.16,18.16,18.72,19.19,18.5,17.53,16.81,16.81,16.53,15.38,14.41,13.59,13.38,12.0,10.72,10.59,10.91,10.47,9.62,8.94,8.84,8.91,8.78,9.03,10.84,12.34,12.59,12.44,12.72,13.34,12.66,11.81,11.59,12.0,11.78,11.47,11.44,12.5,12.94,12.44,11.81,11.75,11.78,10.53,10.0,10.66,12.5,13.31,14.19,14.91,15.72,15.09,13.97,13.0,12.94,12.59,10.91,9.03,7.66,6.31,3.81,1.72,1.47,2.72,3.94,5.66,8.12,11.34,13.56,14.97,16.59,18.84,20.31,20.78,20.97,21.94,22.69,21.97,21.62,22.25,23.16,23.16,22.78,21.84,20.66,18.56,15.62,13.19,12.56,12.56,12.41,12.81,14.31,15.94,16.56,16.84,17.19,18.12,17.91,17.16,16.25,16.0,15.94,14.88,14.66,16.5,18.66,19.72,20.06,20.94,21.0,20.12,18.44,17.66,17.62,17.12,15.81,15.03,15.16,14.88,13.53,12.38,12.53,12.91,12.84,12.53,13.53,14.81,14.91,14.66,14.34,14.91,15.09,14.5,14.25,14.5,13.84,12.19,10.28,9.0,8.06,6.62,5.34,5.03,5.34,4.91,4.69,4.0,4.19,4.03,3.62,3.5,4.62,6.28,7.25,8.38,10.28,12.38,13.31,13.38,14.06,14.28,13.5,11.62,9.47,8.19,6.5,4.75,3.75,4.34,5.38,5.62,5.69,6.75,7.91,8.09,7.72,8.25,9.34,9.47,8.88,8.25,8.09,7.5,6.03,4.97,5.34,6.59,7.44,8.03,9.09,10.5,11.03,9.88,9.25,8.69,7.94,6.5,5.59,6.25,7.09,7.5,7.59,8.75,9.47,9.06,7.56,6.88,7.03,7.41,8.25,10.78,14.38,17.88,20.44,22.84,26.19,29.09,31.25,33.06,34.91,35.75,34.41,31.31,27.69,24.03,20.12,15.75,12.75,11.53,11.12,10.56,9.59,9.31,8.31,5.53,1.66,-1.16,-3.19,-4.69,-5.44,-4.31,-1.44,1.72,4.28,7.19,10.69,13.28,14.53,14.78,15.59,15.88,15.19,14.09,13.47,13.34,12.5,10.97,9.53,8.19,6.69,3.97,1.75,0.53,-0.66,-2.75,-5.12,-6.25,-6.78,-7.16,-7.22,-5.97,-3.69,-1.53,-0.19,1.0,2.84,4.31,3.97,3.38,3.56,3.88,3.47,3.38,4.41,5.97,7.09,7.66,8.66,9.66,9.97,8.62,7.78,7.06,6.44,4.53,3.19,2.62,2.53,2.03,1.97,2.56,3.66,4.34,4.12,4.38,5.56,6.97,7.84,9.12,11.47,13.47,14.41,14.81,15.72,16.28,15.81,14.69,13.97,14.16,14.19,13.75,13.5,14.0,13.81,12.72,12.0,12.19,12.88,13.38,13.5,15.12,16.59,17.19,17.47,18.16,19.25,20.5,21.25,22.06,23.69,25.12,25.06,24.38,24.03,23.59,21.47,18.91,16.94,15.75,14.75,13.78,14.03,15.47,17.53,18.5,19.84,21.97,23.5,23.5,22.72,22.06,21.47,19.62,17.66,16.56,15.62,14.03,11.88,9.72,8.41,7.06,4.84,3.28,3.19,3.62,3.47,3.59,4.44,5.47,5.41,5.12,5.5,6.62,8.06,9.34,11.72,14.91,18.22,20.38,22.31,24.12,25.78,26.25,26.03,26.25,26.81,26.34,25.28,24.19,23.34,21.94,19.31,16.72,14.31,11.94,8.75,5.53,3.62,2.41,0.53,-0.97,-1.41,-0.62,0.38,1.59,3.75,6.91,9.41,10.91,12.22,13.22,13.66,12.72,11.41,10.25,9.62,8.47,7.56,7.62,9.25,11.34,13.5,16.28,19.44,22.0,22.06,21.06,19.72,18.03,15.59,13.56,12.91,13.5,13.81,13.75,14.22,14.88,14.91,14.25,13.5,13.66,13.53,12.66,11.81,11.47,10.97,9.62,8.06,7.31,7.38,6.84,6.12,5.53,5.12,4.62,3.66,3.03,3.91,4.66,4.91,5.09,5.56,7.03,8.34,9.81,12.25,15.38,18.16,19.72,20.78,21.88,22.5,22.31,22.44,23.81,25.31,25.97,26.03,25.75,25.53,24.5,23.28,23.0,23.78,24.47,24.91,25.31,26.03,26.09,24.5,21.91,19.66,16.88,14.41,12.47,12.03,13.66,15.19,16.81,18.38,20.62,22.19,23.12,23.75,25.12,26.31,26.53,25.94,25.91,25.81,24.91,23.5,22.47,21.62,20.31,18.25,15.91,14.56,13.0,10.88,8.97,8.09,8.12,8.44,8.53,9.59,10.66,10.72,9.59,9.09,44.06,43.97,43.38,42.75,41.88,41.41,41.34,41.44,42.0,42.47,42.62,42.41,42.97,43.88,45.19,46.56,48.72,50.41,51.62,52.25,52.5,52.12,51.41,50.19,49.28,48.69,48.38,47.59,46.62,45.66,44.56,44.06,44.12,44.91,46.28:25.56,26.53,26.66,26.88,25.84,23.84,21.03,18.81,17.91,17.25,16.06,14.94,14.12,13.09,10.47,7.94,6.69,5.59,4.97,4.34,5.06,6.78,8.09,8.66,8.72,9.59,9.84,9.34,9.16,10.78,12.62,13.41,13.91,14.5,13.88,12.03,9.22,7.0,5.53,4.09,2.0,0.38,0.0,-0.38,-1.16,-1.62,-0.88,0.03,0.12,-0.09,0.06,0.38,0.5,0.03,0.5,2.12,3.75,4.22,5.22,6.91,8.31,8.38,8.16,8.12,7.75,6.09,4.28,3.31,3.34,3.16,2.84,3.38,4.06,3.88,2.44,0.53,-0.09,-1.06,-2.66,-3.72,-3.56,-3.03,-2.59,-2.97,-2.31,-1.19,-0.97,-1.28,-1.09,-0.59,-0.16,-0.72,-0.97,0.12,1.78,2.47,3.38,4.97,6.41,6.72,6.28,6.0,6.25,6.25,5.69,6.03,7.22,8.16,8.28,8.41,9.53,11.22,12.5,13.78,15.94,18.41,19.97,20.75,21.88,23.22,23.97,23.38,22.66,21.78,20.16,16.78,13.06,10.03,7.94,5.75,3.97,4.28,5.47,6.72,7.72,9.38,11.72,14.0,14.91,15.88,16.66,17.5,16.41,15.06,14.03,13.38,11.72,10.28,9.47,8.84,7.69,5.66,4.56,3.91,4.09,3.19,3.19,3.34,3.56,3.03,2.69,2.81,3.31,2.94,1.94,1.09,0.69,0.12,-0.31,-0.25,1.12,2.78,3.16,3.31,3.75,4.5,4.59,4.84,6.0,7.72,8.72,8.84,8.38,8.09,6.97,4.53,2.72,1.5,0.47,-1.19,-2.91,-3.81,-3.69,-4.03,-4.22,-3.78,-2.56,-1.69,-1.19,0.09,2.38,4.5,5.59,5.88,6.53,7.69,8.25,9.47,11.47,13.72,14.28,13.81,12.19,10.97,9.31,7.28,5.94,5.47,5.22,3.97,2.94,2.28,1.69,0.38,-0.34,-0.06,1.59,3.28,4.94,6.44,8.19,8.75,8.16,7.5,7.84,8.09,7.84,7.97,8.78,10.25,11.66,12.66,14.03,15.16,15.44,14.62,13.62,13.47,12.84,11.28,9.56,8.22,6.94,5.09,3.78,3.5,3.81,4.34,4.56,5.0,7.09,9.16,10.75,12.59,14.72,16.0,16.19,16.12,17.06,18.5,19.28,19.91,20.47,21.06,20.75,19.84,18.56,17.62,16.38,14.44,13.12,13.16,13.72,13.66,13.41,13.88,14.31,13.88,13.12,12.84,13.56,13.5,12.97,12.5,12.5,11.59,9.97,7.81,6.53,5.78,5.06,4.78,6.34,9.03,11.25,13.22,14.91,16.28,16.19,15.53,14.91,15.44,16.19,16.0,16.09,15.88,15.38,13.78,12.09,11.62,11.69,12.34,12.56,13.16,13.81,13.88,13.12,12.12,11.88,11.16,10.31,9.72,10.19,11.12,11.81,11.97,12.12,12.34,12.0,11.19,10.62,11.03,11.16,10.12,8.88,8.62,8.81,8.62,8.41,9.53,11.0,11.75,12.59,13.56,15.28,16.12,16.12,16.44,17.31,18.41,19.12,19.16,19.84,20.66,20.75,20.66,21.78,22.91,23.53,23.09,22.19,21.25,19.41,16.75,14.41,13.22,12.91,12.25,12.41,13.91,15.41,16.12,15.69,15.56,15.34,15.28,15.34,16.41,18.62,20.78,22.09,22.69,23.34,23.0,21.03,18.34,16.25,14.22,12.84,12.12,12.31,13.41,14.69,14.78,14.59,15.19,15.97,16.38,17.06,18.53,19.75,19.5,18.44,18.0,17.44,16.91,16.12,15.47,15.16,13.97,12.25,10.09,8.94,7.75,6.03,4.47,3.75,4.06,3.97,3.84,5.0,6.94,8.59,9.12,10.19,11.25,12.28,12.34,12.44,12.97,13.16,12.5,11.97,12.72,14.19,15.62,16.38,17.0,17.09,15.69,12.38,9.38,6.53,4.69,2.91,2.06,3.0,4.47,5.72,6.62,8.75,11.25,13.47,15.19,16.94,18.66,19.75,18.91,17.5,16.12,14.75,12.28,9.84,8.44,7.66,6.66,5.12,4.56,4.44,3.66,2.09,0.84,0.53,0.56,0.16,0.16,1.28,2.5,2.59,2.47,3.22,4.31,5.09,5.44,6.44,7.38,7.56,7.03,6.81,7.19,8.41,9.19,10.19,11.81,13.91,14.66,14.38,14.84,15.44,15.88,15.88,16.47,17.75,18.75,18.5,17.97,17.75,17.41,15.97,14.97,14.31,14.44,14.0,13.28,12.91,12.94,12.06,10.44,9.19,8.84,9.0,9.16,9.97,12.0,13.88,14.81,15.5,16.09,17.12,17.22,16.41,16.16,16.38,16.38,15.97,15.88,17.06,18.38,18.69,18.53,18.56,18.12,16.44,14.16,12.5,11.56,10.88,10.0,9.81,10.56,10.78,10.12,9.44,9.47,9.88,9.91,10.75,12.84,15.44,17.16,18.16,18.72,19.19,18.5,17.53,16.81,16.81,16.53,15.38,14.41,13.59,13.38,12.0,10.72,10.59,10.91,10.47,9.62,8.94,8.84,8.91,8.78,9.03,10.84,12.34,12.59,12.44,12.72,13.34,12.66,11.81,11.59,12.0,11.78,11.47,11.44,12.5,12.94,12.44,11.81,11.75,11.78,10.53,10.0,10.66,12.5,13.31,14.19,14.91,15.72,15.09,13.97,13.0,12.94,12.59,10.91,9.03,7.66,6.31,3.81,1.72,1.47,2.72,3.94,5.66,8.12,11.34,13.56,14.97,16.59,18.84,20.31,20.78,20.97,21.94,22.69,21.97,21.62,22.25,23.16,23.16,22.78,21.84,20.66,18.56,15.62,13.19,12.56,12.56,12.41,12.81,14.31,15.94,16.56,16.84,17.19,18.12,17.91,17.16,16.25,16.0,15.94,14.88,14.66,16.5,18.66,19.72,20.06,20.94,21.0,20.12,18.44,17.66,17.62,17.12,15.81,15.03,15.16,14.88,13.53,12.38,12.53,12.91,12.84,12.53,13.53,14.81,14.91,14.66,14.34,14.91,15.09,14.5,14.25,14.5,13.84,12.19,10.28,9.0,8.06,6.62,5.34,5.03,5.34,4.91,4.69,4.0,4.19,4.03,3.62,3.5,4.62,6.28,7.25,8.38,10.28,12.38,13.31,13.38,14.06,14.28,13.5,11.62,9.47,8.19,6.5,4.75,3.75,4.34,5.38,5.62,5.69,6.75,7.91,8.09,7.72,8.25,9.34,9.47,8.88,8.25,8.09,7.5,6.03,4.97,5.34,6.59,7.44,8.03,9.09,10.5,11.03,9.88,9.25,8.69,7.94,6.5,5.59,6.25,7.09,7.5,7.59,8.75,9.47,9.06,7.56,6.88,7.03,7.41,8.25,10.78,14.38,17.88,20.44,22.84,26.19,29.09,31.25,33.06,34.91,35.75,34.41,31.31,27.69,24.03,20.12,15.75,12.75,11.53,11.12,10.56,9.59,9.31,8.31,5.53,1.66,-1.16,-3.19,-4.69,-5.44,-4.31,-1.44,1.72,4.28,7.19,10.69,13.28,14.53,14.78,15.59,15.88,15.19,14.09,13.47,13.34,12.5,10.97,9.53,8.19,6.69,3.97,1.75,0.53,-0.66,-2.75,-5.12,-6.25,-6.78,-7.16,-7.22,-5.97,-3.69,-1.53,-0.19,1.0,2.84,4.31,3.97,3.38,3.56,3.88,3.47,3.38,4.41,5.97,7.09,7.66,8.66,9.66,9.97,8.62,7.78,7.06,6.44,4.53,3.19,2.62,2.53,2.03,1.97,2.56,3.66,4.34,4.12,4.38,5.56,6.97,7.84,9.12,11.47,13.47,14.41,14.81,15.72,16.28,15.81,14.69,13.97,14.16,14.19,13.75,13.5,14.0,13.81,12.72,12.0,12.19,12.88,13.38,13.5,15.12,16.59,17.19,17.47,18.16,19.25,20.5,21.25,22.06,23.69,25.12,25.06,24.38,24.03,23.59,21.47,18.91,16.94,15.75,14.75,13.78,14.03,15.47,17.53,18.5,19.84,21.97,23.5,23.5,22.72,22.06,21.47,19.62,17.66,16.56,15.62,14.03,11.88,9.72,8.41,7.06,4.84,3.28,3.19,3.62,3.47,3.59,4.44,5.47,5.41,5.12,5.5,6.62,8.06,9.34,11.72,14.91,18.22,20.38,22.31,24.12,25.78,26.25,26.03,26.25,26.81,26.34,25.28,24.19,23.34,21.94,19.31,16.72,14.31,11.94,8.75,5.53,3.62,2.41,0.53,-0.97,-1.41,-0.62,0.38,1.59,3.75,6.91,9.41,10.91,12.22,13.22,13.66,12.72,11.41,10.25,9.62,8.47,7.56,7.62,9.25,11.34,13.5,16.28,19.44,22.0,22.06,21.06,19.72,18.03,15.59,13.56,12.91,13.5,13.81,13.75,14.22,14.88,14.91,14.25,13.5,13.66,13.53,12.66,11.81,11.47,10.97,9.62,8.06,7.31,7.38,6.84,6.12,5.53,5.12,4.62,3.66,3.03,3.91,4.66,4.91,5.09,5.56,7.03,8.34,9.81,12.25,15.38,18.16,19.72,20.78,21.88,22.5,22.31,22.44,23.81,25.31,25.97,26.03,25.75,25.53,24.5,23.28,23.0,23.78,24.47,24.91,25.31,26.03,26.09,24.5,21.91,19.66,16.88,14.41,12.47,12.03,13.66,15.19,16.81,18.38,20.62,22.19,23.12,23.75,25.12,26.31,26.53,25.94,25.91,25.81,24.91,23.5,22.47,21.62,20.31,18.25,15.91,14.56,13.0,10.88,8.97,8.09,8.12,8.44,8.53,9.59,10.66,10.72,9.59,9.09,44.06,43.97,43.38,42.75,41.88,41.41,41.34,41.44,42.0,42.47,42.62,42.41,42.97,43.88,45.19,46.56,48.72,50.41,51.62,52.25,52.5,52.12,51.41,50.19,49.28,48.69,48.38,47.59,46.62,45.66,44.56,44.06,44.12,44.91,46.28,47.38,47.81,48.03,47.84,47.84,47.88,48.66:negativity
23.53,24.25,24.34,24.84,25.0,23.0,20.41,19.19,19.25,18.72,17.84,18.19,20.03,21.66,22.12,23.72,26.72,29.66,30.53,30.62,30.97,31.28,29.53,27.12,25.5,24.88,23.34,20.62,19.03,19.34,19.78,19.53,20.41,22.91,25.22,25.34,24.81,24.84,25.75,25.06,23.5,22.91,22.81,21.66,19.38,17.84,17.94,18.5,18.44,19.25,22.09,25.66,27.66,28.56,29.56,29.97,28.12,25.0,22.72,22.03,21.38,20.75,20.78,22.56,24.25,24.56,24.5,26.31,28.44,29.47,29.81,30.94,32.53,31.97,30.09,28.53,28.0,26.75,24.47,22.81,23.09,23.75,23.5,23.78,25.75,28.34,29.94,30.5,31.28,32.28,31.53,30.09,29.19,30.09,30.84,30.0,29.06,29.03,28.56,26.69,24.72,24.62,25.56,25.41,24.72,24.53,25.28,24.66,22.81,21.75,21.75,21.59,20.12,18.59,18.81,19.22,18.44,17.53,17.84,19.53,20.34,20.06,20.25,21.47,21.72,20.84,20.38,21.69,23.0,22.53,21.5,21.88,22.09,20.97,19.81,20.28,21.81,22.75,23.22,24.19,26.0,27.16,26.59,25.94,26.16,25.62,22.94,20.16,18.62,17.59,16.12,14.75,14.84,16.31,17.25,17.44,18.69,21.16,22.78,23.12,23.38,25.16,26.56,26.5,25.69,26.03,26.53,25.12,22.75,21.59,20.78,19.78,18.38,18.16,20.12,22.19,22.44,22.12,22.91,23.19,21.56,19.31,18.78,18.94,18.84,18.31,18.97,20.53,21.44,20.28,19.72,20.75,21.69,21.44,21.22,22.38,23.84,23.41,22.75,23.28,23.91,23.69,22.62,22.53,23.34,24.06,24.0,23.69,24.91,25.97,25.53,24.62,25.0,25.34,24.38,22.69,22.38,23.28,23.41,22.31,22.25,23.0,23.38,22.44,22.06,23.06,23.69,22.62,21.22,21.41,22.44,22.91,23.62,25.25,27.69,28.16,26.78,25.19,24.19,23.62,22.16,21.22,22.44,23.69,23.38,22.5,23.03,23.59,23.28,22.41,21.66,21.78,20.97,19.09,17.38,17.5,17.78,16.91,16.44,17.31,18.69,19.09,18.78,20.0,22.41,23.5,23.75,24.88,26.41,26.59,25.03,23.69,23.59,23.31,21.0,18.88,17.75,17.38,16.25,15.19,15.81,17.28,17.94,17.09,17.0,17.78,18.16,16.88,15.72,16.78,18.5,19.62,21.06,24.34,27.84,29.0,28.62,28.41,28.25,27.44,25.78,25.47,26.97,28.41,28.59,28.88,30.53,31.97,31.03,29.81,29.16,28.75,26.88,24.47,23.47,23.97,24.59,24.88,26.41,29.59,32.09,32.59,32.19,32.16,32.09,30.5,28.91,28.94,30.25,31.44,31.53,32.84,34.75,35.47,34.06,32.78,32.31,32.09,30.5,29.25,29.44,30.28,29.56,28.09,27.5,27.75,26.84,24.78,24.16,24.66,25.38,25.22,25.44,26.81,27.69,27.16,26.22,27.09,28.78,29.28,28.94,30.09,31.47,31.72,31.16,30.88,31.41,31.5,30.03,29.0,29.5,29.72,28.69,26.94,26.5,27.06,26.28,25.12,25.03,26.28,26.78,26.34,26.94,28.75,30.03,29.19,28.22,28.44,28.91,28.19,26.72,26.81,27.03,26.25,24.62,23.53,24.03,23.62,21.97,21.25,22.06,23.22,23.09,22.66,23.12,23.5,22.47,20.72,20.44,21.56,22.09,21.72,21.84,22.44,20.94,17.5,14.0,11.81,10.47,8.75,8.09,9.16,11.19,11.62,11.06,11.53,12.47,12.69,11.66,11.25,11.81,11.75,9.94,8.53,8.34,8.66,8.03,7.59,8.88,10.94,11.88,11.88,12.44,13.47,13.5,12.56,12.03,12.66,13.16,12.5,11.91,12.84,14.34,14.31,13.66,14.03,14.91,13.81,12.19,11.5,12.16,12.38,11.59,11.19,12.19,12.66,11.28,10.06,10.16,10.75,10.0,9.19,10.0,11.75,12.88,13.62,15.75,19.28,22.28,23.62,24.28,25.81,26.25,24.56,22.84,21.91,21.12,18.78,16.03,14.41,14.16,14.09,13.94,15.78,19.56,23.84,26.78,29.41,32.69,35.09,35.16,33.97,34.12,34.16,31.75,28.12,24.78,22.06,18.66,14.59,11.81,11.5,11.56,10.75,11.06,13.59,16.66,18.28,19.69,21.88,24.03,24.25,23.41,23.78,25.56,27.06,27.22,27.94,29.03,28.59,25.75,22.78,21.09,20.03,17.5,14.88,13.31,12.56,10.91,8.97,8.62,10.41,12.34,13.47,15.56,19.12,23.0,25.06,27.19,30.72,34.34,36.03,35.94,35.12,34.03,29.97,24.19,19.47,17.06,15.22,13.38,12.62,14.09,15.56,15.56,14.84,15.41,16.16,15.12,13.69,13.53,14.94,15.78,16.47,18.19,21.66,24.41,24.81,24.72,25.59,25.66,23.88,22.0,21.78,22.72,22.62,21.75,22.12,23.16,22.5,20.34,18.44,18.44,18.34,17.22,16.34,17.09,18.09,17.78,17.03,18.25,20.12,20.34,19.12,18.19,18.03,16.38,14.16,13.0,13.72,14.81,14.75,14.78,15.97,17.41,17.09,16.19,16.88,18.12,18.47,18.56,19.75,22.09,23.59,23.5,23.25,24.16,24.56,22.84,20.69,19.75,19.09,16.84,13.44,11.94,11.88,11.03,10.06,10.56,12.16,12.94,12.06,11.03,12.25,13.38,13.34,13.34,15.09,17.31,18.28,18.06,19.09,20.56,20.75,19.34,18.31,18.44,17.88,16.0,14.47,14.66,14.88,13.69,11.75,11.12,10.81,9.22,6.72,5.12,5.06,4.53,3.0,2.94,5.28,7.19,8.34,9.03,11.38,13.72,14.34,14.0,14.88,16.81,17.19,16.38,16.44,17.56,17.97,17.62,18.41,21.09,24.12,24.75,24.31,24.22,23.72,21.0,18.03,16.84,16.81,16.22,14.69,13.97,14.22,14.06,12.56,11.72,12.72,14.0,14.5,14.84,16.97,19.56,20.12,19.25,18.53,17.97,16.28,13.34,11.88,12.44,13.41,13.22,13.09,14.94,16.78,16.69,16.53,17.53,18.81,18.56,16.91,15.88,16.06,15.5,14.19,14.0,15.94,17.31,16.53,15.09,14.75,14.81,14.06,13.16,15.03,17.47,18.62,18.0,17.5,17.38,16.22,13.47,11.81,12.28,12.78,12.06,11.31,12.25,13.28,12.5,11.03,11.06,11.72,11.81,10.81,10.62,11.78,11.53,9.84,8.38,8.97,9.88,9.81,10.09,12.19,14.5,15.22,14.62,15.34,16.5,17.03,16.66,17.53,19.53,21.0,20.25,18.91,18.28,17.25,14.28,11.78,11.44,12.22,12.5,12.41,13.5,15.09,15.97,15.25,14.84,15.88,16.53,15.12,14.66,15.97,17.69,17.53,16.5,16.47,16.09,14.44,12.16,11.62,12.72,13.53,13.72,14.91,17.16,19.19,19.06,18.72,19.66,20.47,19.53,18.22,18.47,19.78,19.62,18.66,18.38,18.88,18.88,17.53,17.25,19.03,20.66,20.91,20.41,21.22,21.66,20.66,18.88,18.19,18.06,16.97,14.47,13.38,14.25,15.41,15.94,17.31,19.72,21.84,21.25,19.19,18.22,17.19,14.72,11.56,10.31,10.22,9.88,9.06,10.06,13.28,16.88,18.41,20.12,22.22,23.41,22.66,21.34,21.59,22.5,21.44,18.78,16.12,13.28,9.41,4.97,2.41,2.91,4.5,4.97,6.41,8.94,11.03,11.34,10.69,11.34,12.88,13.88,14.84,17.22,21.22,24.66,26.16,27.72,30.0,31.12,29.53,27.38,25.41,23.0,18.25,12.53,7.81,4.34,0.78,-2.72,-3.97,-3.12,-2.5,-3.19,-2.91,-1.19,0.88,1.81,3.06,6.09,9.56,11.84,13.69,16.72,20.16,22.56,23.25,24.25,25.31,25.34,23.12,20.25,18.31,17.09,13.91,11.06,9.66,9.09,7.25,5.09,4.84,5.91,7.22,7.88,9.22,11.47,12.47,10.97,8.97,8.41,8.22,7.47,7.03,8.19,9.81,9.81,8.81,8.72,9.78,10.47,10.09,10.62,12.28,13.72,13.69,13.38,14.78,16.12,15.62,14.56,14.03,13.41,11.47,8.75,7.38,7.91,8.5,8.91,10.38,13.38,16.44,17.72,18.69,20.47,22.5,22.91,23.03,24.56,27.25,28.72,29.38,30.72,32.28,32.88,31.12,29.12,28.0,26.34,23.03,19.66,17.69,16.72,14.59,12.31,11.88,12.78,13.12,12.69,12.94,14.16,15.19,14.91,15.38,17.56,20.56,22.25,23.25,25.38,27.91,28.16,27.31,27.34,28.72,29.5,29.12,29.0,29.53,28.62,25.84,22.66,21.16,20.88,19.94,19.34,20.69,22.84,23.81,23.53,23.5,24.34,24.5,23.19,22.28,22.12,22.12,20.0,17.75,16.66,16.47,15.19,14.06,14.62,15.97,16.38,16.22,16.59,18.34,19.72,19.75,20.06,21.56,22.78,22.44,21.62,21.94,22.66,21.47,19.84,19.12,19.5,19.06,17.88,16.97,17.75,18.25,16.88,15.81,17.03,18.78,19.5,20.38,22.22,24.41,24.5,23.62,23.03,23.38,23.34,22.38,22.5,24.5,26.53,27.16,27.59,28.94,30.28,29.53,28.16,27.72,27.59,26.44,24.66,23.59,24.34,24.62,23.94,23.41,24.44,24.53,22.75,20.38,19.19,18.72,17.09,15.56,15.91,17.5,17.88,17.5,16.91,17.28,17.25,15.97,15.5,17.19,19.09,19.59,19.62,20.22,20.66,19.97,18.53,18.31,19.66,20.56,20.62,20.97,22.16,22.53,21.41,19.91,20.62,21.88,22.34,22.78,24.72,26.97,27.28,26.19,25.69,26.06:19.19,19.25,18.72,17.84,18.19,20.03,21.66,22.12,23.72,26.72,29.66,30.53,30.62,30.97,31.28,29.53,27.12,25.5,24.88,23.34,20.62,19.03,19.34,19.78,19.53,20.41,22.91,25.22,25.34,24.81,24.84,25.75,25.06,23.5,22.91,22.81,21.66,19.38,17.84,17.94,18.5,18.44,19.25,22.09,25.66,27.66,28.56,29.56,29.97,28.12,25.0,22.72,22.03,21.38,20.75,20.78,22.56,24.25,24.56,24.5,26.31,28.44,29.47,29.81,30.94,32.53,31.97,30.09,28.53,28.0,26.75,24.47,22.81,23.09,23.75,23.5,23.78,25.75,28.34,29.94,30.5,31.28,32.28,31.53,30.09,29.19,30.09,30.84,30.0,29.06,29.03,28.56,26.69,24.72,24.62,25.56,25.41,24.72,24.53,25.28,24.66,22.81,21.75,21.75,21.59,20.12,18.59,18.81,19.22,18.44,17.53,17.84,19.53,20.34,20.06,20.25,21.47,21.72,20.84,20.38,21.69,23.0,22.53,21.5,21.88,22.09,20.97,19.81,20.28,21.81,22.75,23.22,24.19,26.0,27.16,26.59,25.94,26.16,25.62,22.94,20.16,18.62,17.59,16.12,14.75,14.84,16.31,17.25,17.44,18.69,21.16,22.78,23.12,23.38,25.16,26.56,26.5,25.69,26.03,26.53,25.12,22.75,21.59,20.78,19.78,18.38,18.16,20.12,22.19,22.44,22.12,22.91,23.19,21.56,19.31,18.78,18.94,18.84,18.31,18.97,20.53,21.44,20.28,19.72,20.75,21.69,21.44,21.22,22.38,23.84,23.41,22.75,23.28,23.91,23.69,22.62,22.53,23.34,24.06,24.0,23.69,24.91,25.97,25.53,24.62,25.0,25.34,24.38,22.69,22.38,23.28,23.41,22.31,22.25,23.0,23.38,22.44,22.06,23.06,23.69,22.62,21.22,21.41,22.44,22.91,23.62,25.25,27.69,28.16,26.78,25.19,24.19,23.62,22.16,21.22,22.44,23.69,23.38,22.5,23.03,23.59,23.28,22.41,21.66,21.78,20.97,19.09,17.38,17.5,17.78,16.91,16.44,17.31,18.69,19.09,18.78,20.0,22.41,23.5,23.75,24.88,26.41,26.59,25.03,23.69,23.59,23.31,21.0,18.88,17.75,17.38,16.25,15.19,15.81,17.28,17.94,17.09,17.0,17.78,18.16,16.88,15.72,16.78,18.5,19.62,21.06,24.34,27.84,29.0,28.62,28.41,28.25,27.44,25.78,25.47,26.97,28.41,28.59,28.88,30.53,31.97,31.03,29.81,29.16,28.75,26.88,24.47,23.47,23.97,24.59,24.88,26.41,29.59,32.09,32.59,32.19,32.16,32.09,30.5,28.91,28.94,30.25,31.44,31.53,32.84,34.75,35.47,34.06,32.78,32.31,32.09,30.5,29.25,29.44,30.28,29.56,28.09,27.5,27.75,26.84,24.78,24.16,24.66,25.38,25.22,25.44,26.81,27.69,27.16,26.22,27.09,28.78,29.28,28.94,30.09,31.47,31.72,31.16,30.88,31.41,31.5,30.03,29.0,29.5,29.72,28.69,26.94,26.5,27.06,26.28,25.12,25.03,26.28,26.78,26.34,26.94,28.75,30.03,29.19,28.22,28.44,28.91,28.19,26.72,26.81,27.03,26.25,24.62,23.53,24.03,23.62,21.97,21.25,22.06,23.22,23.09,22.66,23.12,23.5,22.47,20.72,20.44,21.56,22.09,21.72,21.84,22.44,20.94,17.5,14.0,11.81,10.47,8.75,8.09,9.16,11.19,11.62,11.06,11.53,12.47,12.69,11.66,11.25,11.81,11.75,9.94,8.53,8.34,8.66,8.03,7.59,8.88,10.94,11.88,11.88,12.44,13.47,13.5,12.56,12.03,12.66,13.16,12.5,11.91,12.84,14.34,14.31,13.66,14.03,14.91,13.81,12.19,11.5,12.16,12.38,11.59,11.19,12.19,12.66,11.28,10.06,10.16,10.75,10.0,9.19,10.0,11.75,12.88,13.62,15.75,19.28,22.28,23.62,24.28,25.81,26.25,24.56,22.84,21.91,21.12,18.78,16.03,14.41,14.16,14.09,13.94,15.78,19.56,23.84,26.78,29.41,32.69,35.09,35.16,33.97,34.12,34.16,31.75,28.12,24.78,22.06,18.66,14.59,11.81,11.5,11.56,10.75,11.06,13.59,16.66,18.28,19.69,21.88,24.03,24.25,23.41,23.78,25.56,27.06,27.22,27.94,29.03,28.59,25.75,22.78,21.09,20.03,17.5,14.88,13.31,12.56,10.91,8.97,8.62,10.41,12.34,13.47,15.56,19.12,23.0,25.06,27.19,30.72,34.34,36.03,35.94,35.12,34.03,29.97,24.19,19.47,17.06,15.22,13.38,12.62,14.09,15.56,15.56,14.84,15.41,16.16,15.12,13.69,13.53,14.94,15.78,16.47,18.19,21.66,24.41,24.81,24.72,25.59,25.66,23.88,22.0,21.78,22.72,22.62,21.75,22.12,23.16,22.5,20.34,18.44,18.44,18.34,17.22,16.34,17.09,18.09,17.78,17.03,18.25,20.12,20.34,19.12,18.19,18.03,16.38,14.16,13.0,13.72,14.81,14.75,14.78,15.97,17.41,17.09,16.19,16.88,18.12,18.47,18.56,19.75,22.09,23.59,23.5,23.25,24.16,24.56,22.84,20.69,19.75,19.09,16.84,13.44,11.94,11.88,11.03,10.06,10.56,12.16,12.94,12.06,11.03,12.25,13.38,13.34,13.34,15.09,17.31,18.28,18.06,19.09,20.56,20.75,19.34,18.31,18.44,17.88,16.0,14.47,14.66,14.88,13.69,11.75,11.12,10.81,9.22,6.72,5.12,5.06,4.53,3.0,2.94,5.28,7.19,8.34,9.03,11.38,13.72,14.34,14.0,14.88,16.81,17.19,16.38,16.44,17.56,17.97,17.62,18.41,21.09,24.12,24.75,24.31,24.22,23.72,21.0,18.03,16.84,16.81,16.22,14.69,13.97,14.22,14.06,12.56,11.72,12.72,14.0,14.5,14.84,16.97,19.56,20.12,19.25,18.53,17.97,16.28,13.34,11.88,12.44,13.41,13.22,13.09,14.94,16.78,16.69,16.53,17.53,18.81,18.56,16.91,15.88,16.06,15.5,14.19,14.0,15.94,17.31,16.53,15.09,14.75,14.81,14.06,13.16,15.03,17.47,18.62,18.0,17.5,17.38,16.22,13.47,11.81,12.28,12.78,12.06,11.31,12.25,13.28,12.5,11.03,11.06,11.72,11.81,10.81,10.62,11.78,11.53,9.84,8.38,8.97,9.88,9.81,10.09,12.19,14.5,15.22,14.62,15.34,16.5,17.03,16.66,17.53,19.53,21.0,20.25,18.91,18.28,17.25,14.28,11.78,11.44,12.22,12.5,12.41,13.5,15.09,15.97,15.25,14.84,15.88,16.53,15.12,14.66,15.97,17.69,17.53,16.5,16.47,16.09,14.44,12.16,11.62,12.72,13.53,13.72,14.91,17.16,19.19,19.06,18.72,19.66,20.47,19.53,18.22,18.47,19.78,19.62,18.66,18.38,18.88,18.88,17.53,17.25,19.03,20.66,20.91,20.41,21.22,21.66,20.66,18.88,18.19,18.06,16.97,14.47,13.38,14.25,15.41,15.94,17.31,19.72,21.84,21.25,19.19,18.22,17.19,14.72,11.56,10.31,10.22,9.88,9.06,10.06,13.28,16.88,18.41,20.12,22.22,23.41,22.66,21.34,21.59,22.5,21.44,18.78,16.12,13.28,9.41,4.97,2.41,2.91,4.5,4.97,6.41,8.94,11.03,11.34,10.69,11.34,12.88,13.88,14.84,17.22,21.22,24.66,26.16,27.72,30.0,31.12,29.53,27.38,25.41,23.0,18.25,12.53,7.81,4.34,0.78,-2.72,-3.97,-3.12,-2.5,-3.19,-2.91,-1.19,0.88,1.81,3.06,6.09,9.56,11.84,13.69,16.72,20.16,22.56,23.25,24.25,25.31,25.34,23.12,20.25,18.31,17.09,13.91,11.06,9.66,9.09,7.25,5.09,4.84,5.91,7.22,7.88,9.22,11.47,12.47,10.97,8.97,8.41,8.22,7.47,7.03,8.19,9.81,9.81,8.81,8.72,9.78,10.47,10.09,10.62,12.28,13.72,13.69,13.38,14.78,16.12,15.62,14.56,14.03,13.41,11.47,8.75,7.38,7.91,8.5,8.91,10.38,13.38,16.44,17.72,18.69,20.47,22.5,22.91,23.03,24.56,27.25,28.72,29.38,30.72,32.28,32.88,31.12,29.12,28.0,26.34,23.03,19.66,17.69,16.72,14.59,12.31,11.88,12.78,13.12,12.69,12.94,14.16,15.19,14.91,15.38,17.56,20.56,22.25,23.25,25.38,27.91,28.16,27.31,27.34,28.72,29.5,29.12,29.0,29.53,28.62,25.84,22.66,21.16,20.88,19.94,19.34,20.69,22.84,23.81,23.53,23.5,24.34,24.5,23.19,22.28,22.12,22.12,20.0,17.75,16.66,16.47,15.19,14.06,14.62,15.97,16.38,16.22,16.59,18.34,19.72,19.75,20.06,21.56,22.78,22.44,21.62,21.94,22.66,21.47,19.84,19.12,19.5,19.06,17.88,16.97,17.75,18.25,16.88,15.81,17.03,18.78,19.5,20.38,22.22,24.41,24.5,23.62,23.03,23.38,23.34,22.38,22.5,24.5,26.53,27.16,27.59,28.94,30.28,29.53,28.16,27.72,27.59,26.44,24.66,23.59,24.34,24.62,23.94,23.41,24.44,24.53,22.75,20.38,19.19,18.72,17.09,15.56,15.91,17.5,17.88,17.5,16.91,17.28,17.25,15.97,15.5,17.19,19.09,19.59,19.62,20.22,20.66,19.97,18.53,18.31,19.66,20.56,20.62,20.97,22.16,22.53,21.41,19.91,20.62,21.88,22.34,22.78,24.72,26.97,27.28,26.19,25.69,26.06,37.06,38.75,39.75,39.28,38.53,37.5,36.62:22.12,23.72,26.72,29.66,30.53,30.62,30.97,31.28,29.53,27.12,25.5,24.88,23.34,20.62,19.03,19.34,19.78,19.53,20.41,22.91,25.22,25.34,24.81,24.84,25.75,25.06,23.5,22.91,22.81,21.66,19.38,17.84,17.94,18.5,18.44,19.25,22.09,25.66,27.66,28.56,29.56,29.97,28.12,25.0,22.72,22.03,21.38,20.75,20.78,22.56,24.25,24.56,24.5,26.31,28.44,29.47,29.81,30.94,32.53,31.97,30.09,28.53,28.0,26.75,24.47,22.81,23.09,23.75,23.5,23.78,25.75,28.34,29.94,30.5,31.28,32.28,31.53,30.09,29.19,30.09,30.84,30.0,29.06,29.03,28.56,26.69,24.72,24.62,25.56,25.41,24.72,24.53,25.28,24.66,22.81,21.75,21.75,21.59,20.12,18.59,18.81,19.22,18.44,17.53,17.84,19.53,20.34,20.06,20.25,21.47,21.72,20.84,20.38,21.69,23.0,22.53,21.5,21.88,22.09,20.97,19.81,20.28,21.81,22.75,23.22,24.19,26.0,27.16,26.59,25.94,26.16,25.62,22.94,20.16,18.62,17.59,16.12,14.75,14.84,16.31,17.25,17.44,18.69,21.16,22.78,23.12,23.38,25.16,26.56,26.5,25.69,26.03,26.53,25.12,22.75,21.59,20.78,19.78,18.38,18.16,20.12,22.19,22.44,22.12,22.91,23.19,21.56,19.31,18.78,18.94,18.84,18.31,18.97,20.53,21.44,20.28,19.72,20.75,21.69,21.44,21.22,22.38,23.84,23.41,22.75,23.28,23.91,23.69,22.62,22.53,23.34,24.06,24.0,23.69,24.91,25.97,25.53,24.62,25.0,25.34,24.38,22.69,22.38,23.28,23.41,22.31,22.25,23.0,23.38,22.44,22.06,23.06,23.69,22.62,21.22,21.41,22.44,22.91,23.62,25.25,27.69,28.16,26.78,25.19,24.19,23.62,22.16,21.22,22.44,23.69,23.38,22.5,23.03,23.59,23.28,22.41,21.66,21.78,20.97,19.09,17.38,17.5,17.78,16.91,16.44,17.31,18.69,19.09,18.78,20.0,22.41,23.5,23.75,24.88,26.41,26.59,25.03,23.69,23.59,23.31,21.0,18.88,17.75,17.38,16.25,15.19,15.81,17.28,17.94,17.09,17.0,17.78,18.16,16.88,15.72,16.78,18.5,19.62,21.06,24.34,27.84,29.0,28.62,28.41,28.25,27.44,25.78,25.47,26.97,28.41,28.59,28.88,30.53,31.97,31.03,29.81,29.16,28.75,26.88,24.47,23.47,23.97,24.59,24.88,26.41,29.59,32.09,32.59,32.19,32.16,32.09,30.5,28.91,28.94,30.25,31.44,31.53,32.84,34.75,35.47,34.06,32.78,32.31,32.09,30.5,29.25,29.44,30.28,29.56,28.09,27.5,27.75,26.84,24.78,24.16,24.66,25.38,25.22,25.44,26.81,27.69,27.16,26.22,27.09,28.78,29.28,28.94,30.09,31.47,31.72,31.16,30.88,31.41,31.5,30.03,29.0,29.5,29.72,28.69,26.94,26.5,27.06,26.28,25.12,25.03,26.28,26.78,26.34,26.94,28.75,30.03,29.19,28.22,28.44,28.91,28.19,26.72,26.81,27.03,26.25,24.62,23.53,24.03,23.62,21.97,21.25,22.06,23.22,23.09,22.66,23.12,23.5,22.47,20.72,20.44,21.56,22.09,21.72,21.84,22.44,20.94,17.5,14.0,11.81,10.47,8.75,8.09,9.16,11.19,11.62,11.06,11.53,12.47,12.69,11.66,11.25,11.81,11.75,9.94,8.53,8.34,8.66,8.03,7.59,8.88,10.94,11.88,11.88,12.44,13.47,13.5,12.56,12.03,12.66,13.16,12.5,11.91,12.84,14.34,14.31,13.66,14.03,14.91,13.81,12.19,11.5,12.16,12.38,11.59,11.19,12.19,12.66,11.28,10.06,10.16,10.75,10.0,9.19,10.0,11.75,12.88,13.62,15.75,19.28,22.28,23.62,24.28,25.81,26.25,24.56,22.84,21.91,21.12,18.78,16.03,14.41,14.16,14.09,13.94,15.78,19.56,23.84,26.78,29.41,32.69,35.09,35.16,33.97,34.12,34.16,31.75,28.12,24.78,22.06,18.66,14.59,11.81,11.5,11.56,10.75,11.06,13.59,16.66,18.28,19.69,21.88,24.03,24.25,23.41,23.78,25.56,27.06,27.22,27.94,29.03,28.59,25.75,22.78,21.09,20.03,17.5,14.88,13.31,12.56,10.91,8.97,8.62,10.41,12.34,13.47,15.56,19.12,23.0,25.06,27.19,30.72,34.34,36.03,35.94,35.12,34.03,29.97,24.19,19.47,17.06,15.22,13.38,12.62,14.09,15.56,15.56,14.84,15.41,16.16,15.12,13.69,13.53,14.94,15.78,16.47,18.19,21.66,24.41,24.81,24.72,25.59,25.66,23.88,22.0,21.78,22.72,22.62,21.75,22.12,23.16,22.5,20.34,18.44,18.44,18.34,17.22,16.34,17.09,18.09,17.78,17.03,18.25,20.12,20.34,19.12,18.19,18.03,16.38,14.16,13.0,13.72,14.81,14.75,14.78,15.97,17.41,17.09,16.19,16.88,18.12,18.47,18.56,19.75,22.09,23.59,23.5,23.25,24.16,24.56,22.84,20.69,19.75,19.09,16.84,13.44,11.94,11.88,11.03,10.06,10.56,12.16,12.94,12.06,11.03,12.25,13.38,13.34,13.34,15.09,17.31,18.28,18.06,19.09,20.56,20.75,19.34,18.31,18.44,17.88,16.0,14.47,14.66,14.88,13.69,11.75,11.12,10.81,9.22,6.72,5.12,5.06,4.53,3.0,2.94,5.28,7.19,8.34,9.03,11.38,13.72,14.34,14.0,14.88,16.81,17.19,16.38,16.44,17.56,17.97,17.62,18.41,21.09,24.12,24.75,24.31,24.22,23.72,21.0,18.03,16.84,16.81,16.22,14.69,13.97,14.22,14.06,12.56,11.72,12.72,14.0,14.5,14.84,16.97,19.56,20.12,19.25,18.53,17.97,16.28,13.34,11.88,12.44,13.41,13.22,13.09,14.94,16.78,16.69,16.53,17.53,18.81,18.56,16.91,15.88,16.06,15.5,14.19,14.0,15.94,17.31,16.53,15.09,14.75,14.81,14.06,13.16,15.03,17.47,18.62,18.0,17.5,17.38,16.22,13.47,11.81,12.28,12.78,12.06,11.31,12.25,13.28,12.5,11.03,11.06,11.72,11.81,10.81,10.62,11.78,11.53,9.84,8.38,8.97,9.88,9.81,10.09,12.19,14.5,15.22,14.62,15.34,16.5,17.03,16.66,17.53,19.53,21.0,20.25,18.91,18.28,17.25,14.28,11.78,11.44,12.22,12.5,12.41,13.5,15.09,15.97,15.25,14.84,15.88,16.53,15.12,14.66,15.97,17.69,17.53,16.5,16.47,16.09,14.44,12.16,11.62,12.72,13.53,13.72,14.91,17.16,19.19,19.06,18.72,19.66,20.47,19.53,18.22,18.47,19.78,19.62,18.66,18.38,18.88,18.88,17.53,17.25,19.03,20.66,20.91,20.41,21.22,21.66,20.66,18.88,18.19,18.06,16.97,14.47,13.38,14.25,15.41,15.94,17.31,19.72,21.84,21.25,19.19,18.22,17.19,14.72,11.56,10.31,10.22,9.88,9.06,10.06,13.28,16.88,18.41,20.12,22.22,23.41,22.66,21.34,21.59,22.5,21.44,18.78,16.12,13.28,9.41,4.97,2.41,2.91,4.5,4.97,6.41,8.94,11.03,11.34,10.69,11.34,12.88,13.88,14.84,17.22,21.22,24.66,26.16,27.72,30.0,31.12,29.53,27.38,25.41,23.0,18.25,12.53,7.81,4.34,0.78,-2.72,-3.97,-3.12,-2.5,-3.19,-2.91,-1.19,0.88,1.81,3.06,6.09,9.56,11.84,13.69,16.72,20.16,22.56,23.25,24.25,25.31,25.34,23.12,20.25,18.31,17.09,13.91,11.06,9.66,9.09,7.25,5.09,4.84,5.91,7.22,7.88,9.22,11.47,12.47,10.97,8.97,8.41,8.22,7.47,7.03,8.19,9.81,9.81,8.81,8.72,9.78,10.47,10.09,10.62,12.28,13.72,13.69,13.38,14.78,16.12,15.62,14.56,14.03,13.41,11.47,8.75,7.38,7.91,8.5,8.91,10.38,13.38,16.44,17.72,18.69,20.47,22.5,22.91,23.03,24.56,27.25,28.72,29.38,30.72,32.28,32.88,31.12,29.12,28.0,26.34,23.03,19.66,17.69,16.72,14.59,12.31,11.88,12.78,13.12,12.69,12.94,14.16,15.19,14.91,15.38,17.56,20.56,22.25,23.25,25.38,27.91,28.16,27.31,27.34,28.72,29.5,29.12,29.0,29.53,28.62,25.84,22.66,21.16,20.88,19.94,19.34,20.69,22.84,23.81,23.53,23.5,24.34,24.5,23.19,22.28,22.12,22.12,20.0,17.75,16.66,16.47,15.19,14.06,14.62,15.97,16.38,16.22,16.59,18.34,19.72,19.75,20.06,21.56,22.78,22.44,21.62,21.94,22.66,21.47,19.84,19.12,19.5,19.06,17.88,16.97,17.75,18.25,16.88,15.81,17.03,18.78,19.5,20.38,22.22,24.41,24.5,23.62,23.03,23.38,23.34,22.38,22.5,24.5,26.53,27.16,27.59,28.94,30.28,29.53,28.16,27.72,27.59,26.44,24.66,23.59,24.34,24.62,23.94,23.41,24.44,24.53,22.75,20.38,19.19,18.72,17.09,15.56,15.91,17.5,17.88,17.5,16.91,17.28,17.25,15.97,15.5,17.19,19.09,19.59,19.62,20.22,20.66,19.97,18.53,18.31,19.66,20.56,20.62,20.97,22.16,22.53,21.41,19.91,20.62,21.88,22.34,22.78,24.72,26.97,27.28,26.19,25.69,26.06,37.06,38.75,39.75,39.28,38.53,37.5,36.62,35.56,35.41,36.0,36.69,37.31,37.59,37.81:31.28,29.53,27.12,25.5,24.88,23.34,20.62,19.03,19.34,19.78,19.53,20.41,22.91,25.22,25.34,24.81,24.84,25.75,25.06,23.5,22.91,22.81,21.66,19.38,17.84,17.94,18.5,18.44,19.25,22.09,25.66,27.66,28.56,29.56,29.97,28.12,25.0,22.72,22.03,21.38,20.75,20.78,22.56,24.25,24.56,24.5,26.31,28.44,29.47,29.81,30.94,32.53,31.97,30.09,28.53,28.0,26.75,24.47,22.81,23.09,23.75,23.5,23.78,25.75,28.34,29.94,30.5,31.28,32.28,31.53,30.09,29.19,30.09,30.84,30.0,29.06,29.03,28.56,26.69,24.72,24.62,25.56,25.41,24.72,24.53,25.28,24.66,22.81,21.75,21.75,21.59,20.12,18.59,18.81,19.22,18.44,17.53,17.84,19.53,20.34,20.06,20.25,21.47,21.72,20.84,20.38,21.69,23.0,22.53,21.5,21.88,22.09,20.97,19.81,20.28,21.81,22.75,23.22,24.19,26.0,27.16,26.59,25.94,26.16,25.62,22.94,20.16,18.62,17.59,16.12,14.75,14.84,16.31,17.25,17.44,18.69,21.16,22.78,23.12,23.38,25.16,26.56,26.5,25.69,26.03,26.53,25.12,22.75,21.59,20.78,19.78,18.38,18.16,20.12,22.19,22.44,22.12,22.91,23.19,21.56,19.31,18.78,18.94,18.84,18.31,18.97,20.53,21.44,20.28,19.72,20.75,21.69,21.44,21.22,22.38,23.84,23.41,22.75,23.28,23.91,23.69,22.62,22.53,23.34,24.06,24.0,23.69,24.91,25.97,25.53,24.62,25.0,25.34,24.38,22.69,22.38,23.28,23.41,22.31,22.25,23.0,23.38,22.44,22.06,23.06,23.69,22.62,21.22,21.41,22.44,22.91,23.62,25.25,27.69,28.16,26.78,25.19,24.19,23.62,22.16,21.22,22.44,23.69,23.38,22.5,23.03,23.59,23.28,22.41,21.66,21.78,20.97,19.09,17.38,17.5,17.78,16.91,16.44,17.31,18.69,19.09,18.78,20.0,22.41,23.5,23.75,24.88,26.41,26.59,25.03,23.69,23.59,23.31,21.0,18.88,17.75,17.38,16.25,15.19,15.81,17.28,17.94,17.09,17.0,17.78,18.16,16.88,15.72,16.78,18.5,19.62,21.06,24.34,27.84,29.0,28.62,28.41,28.25,27.44,25.78,25.47,26.97,28.41,28.59,28.88,30.53,31.97,31.03,29.81,29.16,28.75,26.88,24.47,23.47,23.97,24.59,24.88,26.41,29.59,32.09,32.59,32.19,32.16,32.09,30.5,28.91,28.94,30.25,31.44,31.53,32.84,34.75,35.47,34.06,32.78,32.31,32.09,30.5,29.25,29.44,30.28,29.56,28.09,27.5,27.75,26.84,24.78,24.16,24.66,25.38,25.22,25.44,26.81,27.69,27.16,26.22,27.09,28.78,29.28,28.94,30.09,31.47,31.72,31.16,30.88,31.41,31.5,30.03,29.0,29.5,29.72,28.69,26.94,26.5,27.06,26.28,25.12,25.03,26.28,26.78,26.34,26.94,28.75,30.03,29.19,28.22,28.44,28.91,28.19,26.72,26.81,27.03,26.25,24.62,23.53,24.03,23.62,21.97,21.25,22.06,23.22,23.09,22.66,23.12,23.5,22.47,20.72,20.44,21.56,22.09,21.72,21.84,22.44,20.94,17.5,14.0,11.81,10.47,8.75,8.09,9.16,11.19,11.62,11.06,11.53,12.47,12.69,11.66,11.25,11.81,11.75,9.94,8.53,8.34,8.66,8.03,7.59,8.88,10.94,11.88,11.88,12.44,13.47,13.5,12.56,12.03,12.66,13.16,12.5,11.91,12.84,14.34,14.31,13.66,14.03,14.91,13.81,12.19,11.5,12.16,12.38,11.59,11.19,12.19,12.66,11.28,10.06,10.16,10.75,10.0,9.19,10.0,11.75,12.88,13.62,15.75,19.28,22.28,23.62,24.28,25.81,26.25,24.56,22.84,21.91,21.12,18.78,16.03,14.41,14.16,14.09,13.94,15.78,19.56,23.84,26.78,29.41,32.69,35.09,35.16,33.97,34.12,34.16,31.75,28.12,24.78,22.06,18.66,14.59,11.81,11.5,11.56,10.75,11.06,13.59,16.66,18.28,19.69,21.88,24.03,24.25,23.41,23.78,25.56,27.06,27.22,27.94,29.03,28.59,25.75,22.78,21.09,20.03,17.5,14.88,13.31,12.56,10.91,8.97,8.62,10.41,12.34,13.47,15.56,19.12,23.0,25.06,27.19,30.72,34.34,36.03,35.94,35.12,34.03,29.97,24.19,19.47,17.06,15.22,13.38,12.62,14.09,15.56,15.56,14.84,15.41,16.16,15.12,13.69,13.53,14.94,15.78,16.47,18.19,21.66,24.41,24.81,24.72,25.59,25.66,23.88,22.0,21.78,22.72,22.62,21.75,22.12,23.16,22.5,20.34,18.44,18.44,18.34,17.22,16.34,17.09,18.09,17.78,17.03,18.25,20.12,20.34,19.12,18.19,18.03,16.38,14.16,13.0,13.72,14.81,14.75,14.78,15.97,17.41,17.09,16.19,16.88,18.12,18.47,18.56,19.75,22.09,23.59,23.5,23.25,24.16,24.56,22.84,20.69,19.75,19.09,16.84,13.44,11.94,11.88,11.03,10.06,10.56,12.16,12.94,12.06,11.03,12.25,13.38,13.34,13.34,15.09,17.31,18.28,18.06,19.09,20.56,20.75,19.34,18.31,18.44,17.88,16.0,14.47,14.66,14.88,13.69,11.75,11.12,10.81,9.22,6.72,5.12,5.06,4.53,3.0,2.94,5.28,7.19,8.34,9.03,11.38,13.72,14.34,14.0,14.88,16.81,17.19,16.38,16.44,17.56,17.97,17.62,18.41,21.09,24.12,24.75,24.31,24.22,23.72,21.0,18.03,16.84,16.81,16.22,14.69,13.97,14.22,14.06,12.56,11.72,12.72,14.0,14.5,14.84,16.97,19.56,20.12,19.25,18.53,17.97,16.28,13.34,11.88,12.44,13.41,13.22,13.09,14.94,16.78,16.69,16.53,17.53,18.81,18.56,16.91,15.88,16.06,15.5,14.19,14.0,15.94,17.31,16.53,15.09,14.75,14.81,14.06,13.16,15.03,17.47,18.62,18.0,17.5,17.38,16.22,13.47,11.81,12.28,12.78,12.06,11.31,12.25,13.28,12.5,11.03,11.06,11.72,11.81,10.81,10.62,11.78,11.53,9.84,8.38,8.97,9.88,9.81,10.09,12.19,14.5,15.22,14.62,15.34,16.5,17.03,16.66,17.53,19.53,21.0,20.25,18.91,18.28,17.25,14.28,11.78,11.44,12.22,12.5,12.41,13.5,15.09,15.97,15.25,14.84,15.88,16.53,15.12,14.66,15.97,17.69,17.53,16.5,16.47,16.09,14.44,12.16,11.62,12.72,13.53,13.72,14.91,17.16,19.19,19.06,18.72,19.66,20.47,19.53,18.22,18.47,19.78,19.62,18.66,18.38,18.88,18.88,17.53,17.25,19.03,20.66,20.91,20.41,21.22,21.66,20.66,18.88,18.19,18.06,16.97,14.47,13.38,14.25,15.41,15.94,17.31,19.72,21.84,21.25,19.19,18.22,17.19,14.72,11.56,10.31,10.22,9.88,9.06,10.06,13.28,16.88,18.41,20.12,22.22,23.41,22.66,21.34,21.59,22.5,21.44,18.78,16.12,13.28,9.41,4.97,2.41,2.91,4.5,4.97,6.41,8.94,11.03,11.34,10.69,11.34,12.88,13.88,14.84,17.22,21.22,24.66,26.16,27.72,30.0,31.12,29.53,27.38,25.41,23.0,18.25,12.53,7.81,4.34,0.78,-2.72,-3.97,-3.12,-2.5,-3.19,-2.91,-1.19,0.88,1.81,3.06,6.09,9.56,11.84,13.69,16.72,20.16,22.56,23.25,24.25,25.31,25.34,23.12,20.25,18.31,17.09,13.91,11.06,9.66,9.09,7.25,5.09,4.84,5.91,7.22,7.88,9.22,11.47,12.47,10.97,8.97,8.41,8.22,7.47,7.03,8.19,9.81,9.81,8.81,8.72,9.78,10.47,10.09,10.62,12.28,13.72,13.69,13.38,14.78,16.12,15.62,14.56,14.03,13.41,11.47,8.75,7.38,7.91,8.5,8.91,10.38,13.38,16.44,17.72,18.69,20.47,22.5,22.91,23.03,24.56,27.25,28.72,29.38,30.72,32.28,32.88,31.12,29.12,28.0,26.34,23.03,19.66,17.69,16.72,14.59,12.31,11.88,12.78,13.12,12.69,12.94,14.16,15.19,14.91,15.38,17.56,20.56,22.25,23.25,25.38,27.91,28.16,27.31,27.34,28.72,29.5,29.12,29.0,29.53,28.62,25.84,22.66,21.16,20.88,19.94,19.34,20.69,22.84,23.81,23.53,23.5,24.34,24.5,23.19,22.28,22.12,22.12,20.0,17.75,16.66,16.47,15.19,14.06,14.62,15.97,16.38,16.22,16.59,18.34,19.72,19.75,20.06,21.56,22.78,22.44,21.62,21.94,22.66,21.47,19.84,19.12,19.5,19.06,17.88,16.97,17.75,18.25,16.88,15.81,17.03,18.78,19.5,20.38,22.22,24.41,24.5,23.62,23.03,23.38,23.34,22.38,22.5,24.5,26.53,27.16,27.59,28.94,30.28,29.53,28.16,27.72,27.59,26.44,24.66,23.59,24.34,24.62,23.94,23.41,24.44,24.53,22.75,20.38,19.19,18.72,17.09,15.56,15.91,17.5,17.88,17.5,16.91,17.28,17.25,15.97,15.5,17.19,19.09,19.59,19.62,20.22,20.66,19.97,18.53,18.31,19.66,20.56,20.62,20.97,22.16,22.53,21.41,19.91,20.62,21.88,22.34,22.78,24.72,26.97,27.28,26.19,25.69,26.06,37.06,38.75,39.75,39.28,38.53,37.5,36.62,35.56,35.41,36.0,36.69,37.31,37.59,37.81,38.16,38.75,38.88,39.97,41.16,41.75,41.72:19.03,19.34,19.78,19.53,20.41,22.91,25.22,25.34,24.81,24.84,25.75,25.06,23.5,22.91,22.81,21.66,19.38,17.84,17.94,18.5,18.44,19.25,22.09,25.66,27.66,28.56,29.56,29.97,28.12,25.0,22.72,22.03,21.38,20.75,20.78,22.56,24.25,24.56,24.5,26.31,28.44,29.47,29.81,30.94,32.53,31.97,30.09,28.53,28.0,26.75,24.47,22.81,23.09,23.75,23.5,23.78,25.75,28.34,29.94,30.5,31.28,32.28,31.53,30.09,29.19,30.09,30.84,30.0,29.06,29.03,28.56,26.69,24.72,24.62,25.56,25.41,24.72,24.53,25.28,24.66,22.81,21.75,21.75,21.59,20.12,18.59,18.81,19.22,18.44,17.53,17.84,19.53,20.34,20.06,20.25,21.47,21.72,20.84,20.38,21.69,23.0,22.53,21.5,21.88,22.09,20.97,19.81,20.28,21.81,22.75,23.22,24.19,26.0,27.16,26.59,25.94,26.16,25.62,22.94,20.16,18.62,17.59,16.12,14.75,14.84,16.31,17.25,17.44,18.69,21.16,22.78,23.12,23.38,25.16,26.56,26.5,25.69,26.03,26.53,25.12,22.75,21.59,20.78,19.78,18.38,18.16,20.12,22.19,22.44,22.12,22.91,23.19,21.56,19.31,18.78,18.94,18.84,18.31,18.97,20.53,21.44,20.28,19.72,20.75,21.69,21.44,21.22,22.38,23.84,23.41,22.75,23.28,23.91,23.69,22.62,22.53,23.34,24.06,24.0,23.69,24.91,25.97,25.53,24.62,25.0,25.34,24.38,22.69,22.38,23.28,23.41,22.31,22.25,23.0,23.38,22.44,22.06,23.06,23.69,22.62,21.22,21.41,22.44,22.91,23.62,25.25,27.69,28.16,26.78,25.19,24.19,23.62,22.16,21.22,22.44,23.69,23.38,22.5,23.03,23.59,23.28,22.41,21.66,21.78,20.97,19.09,17.38,17.5,17.78,16.91,16.44,17.31,18.69,19.09,18.78,20.0,22.41,23.5,23.75,24.88,26.41,26.59,25.03,23.69,23.59,23.31,21.0,18.88,17.75,17.38,16.25,15.19,15.81,17.28,17.94,17.09,17.0,17.78,18.16,16.88,15.72,16.78,18.5,19.62,21.06,24.34,27.84,29.0,28.62,28.41,28.25,27.44,25.78,25.47,26.97,28.41,28.59,28.88,30.53,31.97,31.03,29.81,29.16,28.75,26.88,24.47,23.47,23.97,24.59,24.88,26.41,29.59,32.09,32.59,32.19,32.16,32.09,30.5,28.91,28.94,30.25,31.44,31.53,32.84,34.75,35.47,34.06,32.78,32.31,32.09,30.5,29.25,29.44,30.28,29.56,28.09,27.5,27.75,26.84,24.78,24.16,24.66,25.38,25.22,25.44,26.81,27.69,27.16,26.22,27.09,28.78,29.28,28.94,30.09,31.47,31.72,31.16,30.88,31.41,31.5,30.03,29.0,29.5,29.72,28.69,26.94,26.5,27.06,26.28,25.12,25.03,26.28,26.78,26.34,26.94,28.75,30.03,29.19,28.22,28.44,28.91,28.19,26.72,26.81,27.03,26.25,24.62,23.53,24.03,23.62,21.97,21.25,22.06,23.22,23.09,22.66,23.12,23.5,22.47,20.72,20.44,21.56,22.09,21.72,21.84,22.44,20.94,17.5,14.0,11.81,10.47,8.75,8.09,9.16,11.19,11.62,11.06,11.53,12.47,12.69,11.66,11.25,11.81,11.75,9.94,8.53,8.34,8.66,8.03,7.59,8.88,10.94,11.88,11.88,12.44,13.47,13.5,12.56,12.03,12.66,13.16,12.5,11.91,12.84,14.34,14.31,13.66,14.03,14.91,13.81,12.19,11.5,12.16,12.38,11.59,11.19,12.19,12.66,11.28,10.06,10.16,10.75,10.0,9.19,10.0,11.75,12.88,13.62,15.75,19.28,22.28,23.62,24.28,25.81,26.25,24.56,22.84,21.91,21.12,18.78,16.03,14.41,14.16,14.09,13.94,15.78,19.56,23.84,26.78,29.41,32.69,35.09,35.16,33.97,34.12,34.16,31.75,28.12,24.78,22.06,18.66,14.59,11.81,11.5,11.56,10.75,11.06,13.59,16.66,18.28,19.69,21.88,24.03,24.25,23.41,23.78,25.56,27.06,27.22,27.94,29.03,28.59,25.75,22.78,21.09,20.03,17.5,14.88,13.31,12.56,10.91,8.97,8.62,10.41,12.34,13.47,15.56,19.12,23.0,25.06,27.19,30.72,34.34,36.03,35.94,35.12,34.03,29.97,24.19,19.47,17.06,15.22,13.38,12.62,14.09,15.56,15.56,14.84,15.41,16.16,15.12,13.69,13.53,14.94,15.78,16.47,18.19,21.66,24.41,24.81,24.72,25.59,25.66,23.88,22.0,21.78,22.72,22.62,21.75,22.12,23.16,22.5,20.34,18.44,18.44,18.34,17.22,16.34,17.09,18.09,17.78,17.03,18.25,20.12,20.34,19.12,18.19,18.03,16.38,14.16,13.0,13.72,14.81,14.75,14.78,15.97,17.41,17.09,16.19,16.88,18.12,18.47,18.56,19.75,22.09,23.59,23.5,23.25,24.16,24.56,22.84,20.69,19.75,19.09,16.84,13.44,11.94,11.88,11.03,10.06,10.56,12.16,12.94,12.06,11.03,12.25,13.38,13.34,13.34,15.09,17.31,18.28,18.06,19.09,20.56,20.75,19.34,18.31,18.44,17.88,16.0,14.47,14.66,14.88,13.69,11.75,11.12,10.81,9.22,6.72,5.12,5.06,4.53,3.0,2.94,5.28,7.19,8.34,9.03,11.38,13.72,14.34,14.0,14.88,16.81,17.19,16.38,16.44,17.56,17.97,17.62,18.41,21.09,24.12,24.75,24.31,24.22,23.72,21.0,18.03,16.84,16.81,16.22,14.69,13.97,14.22,14.06,12.56,11.72,12.72,14.0,14.5,14.84,16.97,19.56,20.12,19.25,18.53,17.97,16.28,13.34,11.88,12.44,13.41,13.22,13.09,14.94,16.78,16.69,16.53,17.53,18.81,18.56,16.91,15.88,16.06,15.5,14.19,14.0,15.94,17.31,16.53,15.09,14.75,14.81,14.06,13.16,15.03,17.47,18.62,18.0,17.5,17.38,16.22,13.47,11.81,12.28,12.78,12.06,11.31,12.25,13.28,12.5,11.03,11.06,11.72,11.81,10.81,10.62,11.78,11.53,9.84,8.38,8.97,9.88,9.81,10.09,12.19,14.5,15.22,14.62,15.34,16.5,17.03,16.66,17.53,19.53,21.0,20.25,18.91,18.28,17.25,14.28,11.78,11.44,12.22,12.5,12.41,13.5,15.09,15.97,15.25,14.84,15.88,16.53,15.12,14.66,15.97,17.69,17.53,16.5,16.47,16.09,14.44,12.16,11.62,12.72,13.53,13.72,14.91,17.16,19.19,19.06,18.72,19.66,20.47,19.53,18.22,18.47,19.78,19.62,18.66,18.38,18.88,18.88,17.53,17.25,19.03,20.66,20.91,20.41,21.22,21.66,20.66,18.88,18.19,18.06,16.97,14.47,13.38,14.25,15.41,15.94,17.31,19.72,21.84,21.25,19.19,18.22,17.19,14.72,11.56,10.31,10.22,9.88,9.06,10.06,13.28,16.88,18.41,20.12,22.22,23.41,22.66,21.34,21.59,22.5,21.44,18.78,16.12,13.28,9.41,4.97,2.41,2.91,4.5,4.97,6.41,8.94,11.03,11.34,10.69,11.34,12.88,13.88,14.84,17.22,21.22,24.66,26.16,27.72,30.0,31.12,29.53,27.38,25.41,23.0,18.25,12.53,7.81,4.34,0.78,-2.72,-3.97,-3.12,-2.5,-3.19,-2.91,-1.19,0.88,1.81,3.06,6.09,9.56,11.84,13.69,16.72,20.16,22.56,23.25,24.25,25.31,25.34,23.12,20.25,18.31,17.09,13.91,11.06,9.66,9.09,7.25,5.09,4.84,5.91,7.22,7.88,9.22,11.47,12.47,10.97,8.97,8.41,8.22,7.47,7.03,8.19,9.81,9.81,8.81,8.72,9.78,10.47,10.09,10.62,12.28,13.72,13.69,13.38,14.78,16.12,15.62,14.56,14.03,13.41,11.47,8.75,7.38,7.91,8.5,8.91,10.38,13.38,16.44,17.72,18.69,20.47,22.5,22.91,23.03,24.56,27.25,28.72,29.38,30.72,32.28,32.88,31.12,29.12,28.0,26.34,23.03,19.66,17.69,16.72,14.59,12.31,11.88,12.78,13.12,12.69,12.94,14.16,15.19,14.91,15.38,17.56,20.56,22.25,23.25,25.38,27.91,28.16,27.31,27.34,28.72,29.5,29.12,29.0,29.53,28.62,25.84,22.66,21.16,20.88,19.94,19.34,20.69,22.84,23.81,23.53,23.5,24.34,24.5,23.19,22.28,22.12,22.12,20.0,17.75,16.66,16.47,15.19,14.06,14.62,15.97,16.38,16.22,16.59,18.34,19.72,19.75,20.06,21.56,22.78,22.44,21.62,21.94,22.66,21.47,19.84,19.12,19.5,19.06,17.88,16.97,17.75,18.25,16.88,15.81,17.03,18.78,19.5,20.38,22.22,24.41,24.5,23.62,23.03,23.38,23.34,22.38,22.5,24.5,26.53,27.16,27.59,28.94,30.28,29.53,28.16,27.72,27.59,26.44,24.66,23.59,24.34,24.62,23.94,23.41,24.44,24.53,22.75,20.38,19.19,18.72,17.09,15.56,15.91,17.5,17.88,17.5,16.91,17.28,17.25,15.97,15.5,17.19,19.09,19.59,19.62,20.22,20.66,19.97,18.53,18.31,19.66,20.56,20.62,20.97,22.16,22.53,21.41,19.91,20.62,21.88,22.34,22.78,24.72,26.97,27.28,26.19,25.69,26.06,37.06,38.75,39.75,39.28,38.53,37.5,36.62,35.56,35.41,36.0,36.69,37.31,37.59,37.81,38.16,38.75,38.88,39.97,41.16,41.75,41.72,41.59,41.56,41.47,40.94,40.47,39.62,38.59:25.34,24.81,24.84,25.75,25.06,23.5,22.91,22.81,21.66,19.38,17.84,17.94,18.5,18.44,19.25,22.09,25.66,27.66,28.56,29.56,29.97,28.12,25.0,22.72,22.03,21.38,20.75,20.78,22.56,24.25,24.56,24.5,26.31,28.44,29.47,29.81,30.94,32.53,31.97,30.09,28.53,28.0,26.75,24.47,22.81,23.09,23.75,23.5,23.78,25.75,28.34,29.94,30.5,31.28,32.28,31.53,30.09,29.19,30.09,30.84,30.0,29.06,29.03,28.56,26.69,24.72,24.62,25.56,25.41,24.72,24.53,25.28,24.66,22.81,21.75,21.75,21.59,20.12,18.59,18.81,19.22,18.44,17.53,17.84,19.53,20.34,20.06,20.25,21.47,21.72,20.84,20.38,21.69,23.0,22.53,21.5,21.88,22.09,20.97,19.81,20.28,21.81,22.75,23.22,24.19,26.0,27.16,26.59,25.94,26.16,25.62,22.94,20.16,18.62,17.59,16.12,14.75,14.84,16.31,17.25,17.44,18.69,21.16,22.78,23.12,23.38,25.16,26.56,26.5,25.69,26.03,26.53,25.12,22.75,21.59,20.78,19.78,18.38,18.16,20.12,22.19,22.44,22.12,22.91,23.19,21.56,19.31,18.78,18.94,18.84,18.31,18.97,20.53,21.44,20.28,19.72,20.75,21.69,21.44,21.22,22.38,23.84,23.41,22.75,23.28,23.91,23.69,22.62,22.53,23.34,24.06,24.0,23.69,24.91,25.97,25.53,24.62,25.0,25.34,24.38,22.69,22.38,23.28,23.41,22.31,22.25,23.0,23.38,22.44,22.06,23.06,23.69,22.62,21.22,21.41,22.44,22.91,23.62,25.25,27.69,28.16,26.78,25.19,24.19,23.62,22.16,21.22,22.44,23.69,23.38,22.5,23.03,23.59,23.28,22.41,21.66,21.78,20.97,19.09,17.38,17.5,17.78,16.91,16.44,17.31,18.69,19.09,18.78,20.0,22.41,23.5,23.75,24.88,26.41,26.59,25.03,23.69,23.59,23.31,21.0,18.88,17.75,17.38,16.25,15.19,15.81,17.28,17.94,17.09,17.0,17.78,18.16,16.88,15.72,16.78,18.5,19.62,21.06,24.34,27.84,29.0,28.62,28.41,28.25,27.44,25.78,25.47,26.97,28.41,28.59,28.88,30.53,31.97,31.03,29.81,29.16,28.75,26.88,24.47,23.47,23.97,24.59,24.88,26.41,29.59,32.09,32.59,32.19,32.16,32.09,30.5,28.91,28.94,30.25,31.44,31.53,32.84,34.75,35.47,34.06,32.78,32.31,32.09,30.5,29.25,29.44,30.28,29.56,28.09,27.5,27.75,26.84,24.78,24.16,24.66,25.38,25.22,25.44,26.81,27.69,27.16,26.22,27.09,28.78,29.28,28.94,30.09,31.47,31.72,31.16,30.88,31.41,31.5,30.03,29.0,29.5,29.72,28.69,26.94,26.5,27.06,26.28,25.12,25.03,26.28,26.78,26.34,26.94,28.75,30.03,29.19,28.22,28.44,28.91,28.19,26.72,26.81,27.03,26.25,24.62,23.53,24.03,23.62,21.97,21.25,22.06,23.22,23.09,22.66,23.12,23.5,22.47,20.72,20.44,21.56,22.09,21.72,21.84,22.44,20.94,17.5,14.0,11.81,10.47,8.75,8.09,9.16,11.19,11.62,11.06,11.53,12.47,12.69,11.66,11.25,11.81,11.75,9.94,8.53,8.34,8.66,8.03,7.59,8.88,10.94,11.88,11.88,12.44,13.47,13.5,12.56,12.03,12.66,13.16,12.5,11.91,12.84,14.34,14.31,13.66,14.03,14.91,13.81,12.19,11.5,12.16,12.38,11.59,11.19,12.19,12.66,11.28,10.06,10.16,10.75,10.0,9.19,10.0,11.75,12.88,13.62,15.75,19.28,22.28,23.62,24.28,25.81,26.25,24.56,22.84,21.91,21.12,18.78,16.03,14.41,14.16,14.09,13.94,15.78,19.56,23.84,26.78,29.41,32.69,35.09,35.16,33.97,34.12,34.16,31.75,28.12,24.78,22.06,18.66,14.59,11.81,11.5,11.56,10.75,11.06,13.59,16.66,18.28,19.69,21.88,24.03,24.25,23.41,23.78,25.56,27.06,27.22,27.94,29.03,28.59,25.75,22.78,21.09,20.03,17.5,14.88,13.31,12.56,10.91,8.97,8.62,10.41,12.34,13.47,15.56,19.12,23.0,25.06,27.19,30.72,34.34,36.03,35.94,35.12,34.03,29.97,24.19,19.47,17.06,15.22,13.38,12.62,14.09,15.56,15.56,14.84,15.41,16.16,15.12,13.69,13.53,14.94,15.78,16.47,18.19,21.66,24.41,24.81,24.72,25.59,25.66,23.88,22.0,21.78,22.72,22.62,21.75,22.12,23.16,22.5,20.34,18.44,18.44,18.34,17.22,16.34,17.09,18.09,17.78,17.03,18.25,20.12,20.34,19.12,18.19,18.03,16.38,14.16,13.0,13.72,14.81,14.75,14.78,15.97,17.41,17.09,16.19,16.88,18.12,18.47,18.56,19.75,22.09,23.59,23.5,23.25,24.16,24.56,22.84,20.69,19.75,19.09,16.84,13.44,11.94,11.88,11.03,10.06,10.56,12.16,12.94,12.06,11.03,12.25,13.38,13.34,13.34,15.09,17.31,18.28,18.06,19.09,20.56,20.75,19.34,18.31,18.44,17.88,16.0,14.47,14.66,14.88,13.69,11.75,11.12,10.81,9.22,6.72,5.12,5.06,4.53,3.0,2.94,5.28,7.19,8.34,9.03,11.38,13.72,14.34,14.0,14.88,16.81,17.19,16.38,16.44,17.56,17.97,17.62,18.41,21.09,24.12,24.75,24.31,24.22,23.72,21.0,18.03,16.84,16.81,16.22,14.69,13.97,14.22,14.06,12.56,11.72,12.72,14.0,14.5,14.84,16.97,19.56,20.12,19.25,18.53,17.97,16.28,13.34,11.88,12.44,13.41,13.22,13.09,14.94,16.78,16.69,16.53,17.53,18.81,18.56,16.91,15.88,16.06,15.5,14.19,14.0,15.94,17.31,16.53,15.09,14.75,14.81,14.06,13.16,15.03,17.47,18.62,18.0,17.5,17.38,16.22,13.47,11.81,12.28,12.78,12.06,11.31,12.25,13.28,12.5,11.03,11.06,11.72,11.81,10.81,10.62,11.78,11.53,9.84,8.38,8.97,9.88,9.81,10.09,12.19,14.5,15.22,14.62,15.34,16.5,17.03,16.66,17.53,19.53,21.0,20.25,18.91,18.28,17.25,14.28,11.78,11.44,12.22,12.5,12.41,13.5,15.09,15.97,15.25,14.84,15.88,16.53,15.12,14.66,15.97,17.69,17.53,16.5,16.47,16.09,14.44,12.16,11.62,12.72,13.53,13.72,14.91,17.16,19.19,19.06,18.72,19.66,20.47,19.53,18.22,18.47,19.78,19.62,18.66,18.38,18.88,18.88,17.53,17.25,19.03,20.66,20.91,20.41,21.22,21.66,20.66,18.88,18.19,18.06,16.97,14.47,13.38,14.25,15.41,15.94,17.31,19.72,21.84,21.25,19.19,18.22,17.19,14.72,11.56,10.31,10.22,9.88,9.06,10.06,13.28,16.88,18.41,20.12,22.22,23.41,22.66,21.34,21.59,22.5,21.44,18.78,16.12,13.28,9.41,4.97,2.41,2.91,4.5,4.97,6.41,8.94,11.03,11.34,10.69,11.34,12.88,13.88,14.84,17.22,21.22,24.66,26.16,27.72,30.0,31.12,29.53,27.38,25.41,23.0,18.25,12.53,7.81,4.34,0.78,-2.72,-3.97,-3.12,-2.5,-3.19,-2.91,-1.19,0.88,1.81,3.06,6.09,9.56,11.84,13.69,16.72,20.16,22.56,23.25,24.25,25.31,25.34,23.12,20.25,18.31,17.09,13.91,11.06,9.66,9.09,7.25,5.09,4.84,5.91,7.22,7.88,9.22,11.47,12.47,10.97,8.97,8.41,8.22,7.47,7.03,8.19,9.81,9.81,8.81,8.72,9.78,10.47,10.09,10.62,12.28,13.72,13.69,13.38,14.78,16.12,15.62,14.56,14.03,13.41,11.47,8.75,7.38,7.91,8.5,8.91,10.38,13.38,16.44,17.72,18.69,20.47,22.5,22.91,23.03,24.56,27.25,28.72,29.38,30.72,32.28,32.88,31.12,29.12,28.0,26.34,23.03,19.66,17.69,16.72,14.59,12.31,11.88,12.78,13.12,12.69,12.94,14.16,15.19,14.91,15.38,17.56,20.56,22.25,23.25,25.38,27.91,28.16,27.31,27.34,28.72,29.5,29.12,29.0,29.53,28.62,25.84,22.66,21.16,20.88,19.94,19.34,20.69,22.84,23.81,23.53,23.5,24.34,24.5,23.19,22.28,22.12,22.12,20.0,17.75,16.66,16.47,15.19,14.06,14.62,15.97,16.38,16.22,16.59,18.34,19.72,19.75,20.06,21.56,22.78,22.44,21.62,21.94,22.66,21.47,19.84,19.12,19.5,19.06,17.88,16.97,17.75,18.25,16.88,15.81,17.03,18.78,19.5,20.38,22.22,24.41,24.5,23.62,23.03,23.38,23.34,22.38,22.5,24.5,26.53,27.16,27.59,28.94,30.28,29.53,28.16,27.72,27.59,26.44,24.66,23.59,24.34,24.62,23.94,23.41,24.44,24.53,22.75,20.38,19.19,18.72,17.09,15.56,15.91,17.5,17.88,17.5,16.91,17.28,17.25,15.97,15.5,17.19,19.09,19.59,19.62,20.22,20.66,19.97,18.53,18.31,19.66,20.56,20.62,20.97,22.16,22.53,21.41,19.91,20.62,21.88,22.34,22.78,24.72,26.97,27.28,26.19,25.69,26.06,37.06,38.75,39.75,39.28,38.53,37.5,36.62,35.56,35.41,36.0,36.69,37.31,37.59,37.81,38.16,38.75,38.88,39.97,41.16,41.75,41.72,41.59,41.56,41.47,40.94,40.47,39.62,38.59,37.06,35.44,34.62,34.66,35.16,35.62,36.59:22.81,21.66,19.38,17.84,17.94,18.5,18.44,19.25,22.09,25.66,27.66,28.56,29.56,29.97,28.12,25.0,22.72,22.03,21.38,20.75,20.78,22.56,24.25,24.56,24.5,26.31,28.44,29.47,29.81,30.94,32.53,31.97,30.09,28.53,28.0,26.75,24.47,22.81,23.09,23.75,23.5,23.78,25.75,28.34,29.94,30.5,31.28,32.28,31.53,30.09,29.19,30.09,30.84,30.0,29.06,29.03,28.56,26.69,24.72,24.62,25.56,25.41,24.72,24.53,25.28,24.66,22.81,21.75,21.75,21.59,20.12,18.59,18.81,19.22,18.44,17.53,17.84,19.53,20.34,20.06,20.25,21.47,21.72,20.84,20.38,21.69,23.0,22.53,21.5,21.88,22.09,20.97,19.81,20.28,21.81,22.75,23.22,24.19,26.0,27.16,26.59,25.94,26.16,25.62,22.94,20.16,18.62,17.59,16.12,14.75,14.84,16.31,17.25,17.44,18.69,21.16,22.78,23.12,23.38,25.16,26.56,26.5,25.69,26.03,26.53,25.12,22.75,21.59,20.78,19.78,18.38,18.16,20.12,22.19,22.44,22.12,22.91,23.19,21.56,19.31,18.78,18.94,18.84,18.31,18.97,20.53,21.44,20.28,19.72,20.75,21.69,21.44,21.22,22.38,23.84,23.41,22.75,23.28,23.91,23.69,22.62,22.53,23.34,24.06,24.0,23.69,24.91,25.97,25.53,24.62,25.0,25.34,24.38,22.69,22.38,23.28,23.41,22.31,22.25,23.0,23.38,22.44,22.06,23.06,23.69,22.62,21.22,21.41,22.44,22.91,23.62,25.25,27.69,28.16,26.78,25.19,24.19,23.62,22.16,21.22,22.44,23.69,23.38,22.5,23.03,23.59,23.28,22.41,21.66,21.78,20.97,19.09,17.38,17.5,17.78,16.91,16.44,17.31,18.69,19.09,18.78,20.0,22.41,23.5,23.75,24.88,26.41,26.59,25.03,23.69,23.59,23.31,21.0,18.88,17.75,17.38,16.25,15.19,15.81,17.28,17.94,17.09,17.0,17.78,18.16,16.88,15.72,16.78,18.5,19.62,21.06,24.34,27.84,29.0,28.62,28.41,28.25,27.44,25.78,25.47,26.97,28.41,28.59,28.88,30.53,31.97,31.03,29.81,29.16,28.75,26.88,24.47,23.47,23.97,24.59,24.88,26.41,29.59,32.09,32.59,32.19,32.16,32.09,30.5,28.91,28.94,30.25,31.44,31.53,32.84,34.75,35.47,34.06,32.78,32.31,32.09,30.5,29.25,29.44,30.28,29.56,28.09,27.5,27.75,26.84,24.78,24.16,24.66,25.38,25.22,25.44,26.81,27.69,27.16,26.22,27.09,28.78,29.28,28.94,30.09,31.47,31.72,31.16,30.88,31.41,31.5,30.03,29.0,29.5,29.72,28.69,26.94,26.5,27.06,26.28,25.12,25.03,26.28,26.78,26.34,26.94,28.75,30.03,29.19,28.22,28.44,28.91,28.19,26.72,26.81,27.03,26.25,24.62,23.53,24.03,23.62,21.97,21.25,22.06,23.22,23.09,22.66,23.12,23.5,22.47,20.72,20.44,21.56,22.09,21.72,21.84,22.44,20.94,17.5,14.0,11.81,10.47,8.75,8.09,9.16,11.19,11.62,11.06,11.53,12.47,12.69,11.66,11.25,11.81,11.75,9.94,8.53,8.34,8.66,8.03,7.59,8.88,10.94,11.88,11.88,12.44,13.47,13.5,12.56,12.03,12.66,13.16,12.5,11.91,12.84,14.34,14.31,13.66,14.03,14.91,13.81,12.19,11.5,12.16,12.38,11.59,11.19,12.19,12.66,11.28,10.06,10.16,10.75,10.0,9.19,10.0,11.75,12.88,13.62,15.75,19.28,22.28,23.62,24.28,25.81,26.25,24.56,22.84,21.91,21.12,18.78,16.03,14.41,14.16,14.09,13.94,15.78,19.56,23.84,26.78,29.41,32.69,35.09,35.16,33.97,34.12,34.16,31.75,28.12,24.78,22.06,18.66,14.59,11.81,11.5,11.56,10.75,11.06,13.59,16.66,18.28,19.69,21.88,24.03,24.25,23.41,23.78,25.56,27.06,27.22,27.94,29.03,28.59,25.75,22.78,21.09,20.03,17.5,14.88,13.31,12.56,10.91,8.97,8.62,10.41,12.34,13.47,15.56,19.12,23.0,25.06,27.19,30.72,34.34,36.03,35.94,35.12,34.03,29.97,24.19,19.47,17.06,15.22,13.38,12.62,14.09,15.56,15.56,14.84,15.41,16.16,15.12,13.69,13.53,14.94,15.78,16.47,18.19,21.66,24.41,24.81,24.72,25.59,25.66,23.88,22.0,21.78,22.72,22.62,21.75,22.12,23.16,22.5,20.34,18.44,18.44,18.34,17.22,16.34,17.09,18.09,17.78,17.03,18.25,20.12,20.34,19.12,18.19,18.03,16.38,14.16,13.0,13.72,14.81,14.75,14.78,15.97,17.41,17.09,16.19,16.88,18.12,18.47,18.56,19.75,22.09,23.59,23.5,23.25,24.16,24.56,22.84,20.69,19.75,19.09,16.84,13.44,11.94,11.88,11.03,10.06,10.56,12.16,12.94,12.06,11.03,12.25,13.38,13.34,13.34,15.09,17.31,18.28,18.06,19.09,20.56,20.75,19.34,18.31,18.44,17.88,16.0,14.47,14.66,14.88,13.69,11.75,11.12,10.81,9.22,6.72,5.12,5.06,4.53,3.0,2.94,5.28,7.19,8.34,9.03,11.38,13.72,14.34,14.0,14.88,16.81,17.19,16.38,16.44,17.56,17.97,17.62,18.41,21.09,24.12,24.75,24.31,24.22,23.72,21.0,18.03,16.84,16.81,16.22,14.69,13.97,14.22,14.06,12.56,11.72,12.72,14.0,14.5,14.84,16.97,19.56,20.12,19.25,18.53,17.97,16.28,13.34,11.88,12.44,13.41,13.22,13.09,14.94,16.78,16.69,16.53,17.53,18.81,18.56,16.91,15.88,16.06,15.5,14.19,14.0,15.94,17.31,16.53,15.09,14.75,14.81,14.06,13.16,15.03,17.47,18.62,18.0,17.5,17.38,16.22,13.47,11.81,12.28,12.78,12.06,11.31,12.25,13.28,12.5,11.03,11.06,11.72,11.81,10.81,10.62,11.78,11.53,9.84,8.38,8.97,9.88,9.81,10.09,12.19,14.5,15.22,14.62,15.34,16.5,17.03,16.66,17.53,19.53,21.0,20.25,18.91,18.28,17.25,14.28,11.78,11.44,12.22,12.5,12.41,13.5,15.09,15.97,15.25,14.84,15.88,16.53,15.12,14.66,15.97,17.69,17.53,16.5,16.47,16.09,14.44,12.16,11.62,12.72,13.53,13.72,14.91,17.16,19.19,19.06,18.72,19.66,20.47,19.53,18.22,18.47,19.78,19.62,18.66,18.38,18.88,18.88,17.53,17.25,19.03,20.66,20.91,20.41,21.22,21.66,20.66,18.88,18.19,18.06,16.97,14.47,13.38,14.25,15.41,15.94,17.31,19.72,21.84,21.25,19.19,18.22,17.19,14.72,11.56,10.31,10.22,9.88,9.06,10.06,13.28,16.88,18.41,20.12,22.22,23.41,22.66,21.34,21.59,22.5,21.44,18.78,16.12,13.28,9.41,4.97,2.41,2.91,4.5,4.97,6.41,8.94,11.03,11.34,10.69,11.34,12.88,13.88,14.84,17.22,21.22,24.66,26.16,27.72,30.0,31.12,29.53,27.38,25.41,23.0,18.25,12.53,7.81,4.34,0.78,-2.72,-3.97,-3.12,-2.5,-3.19,-2.91,-1.19,0.88,1.81,3.06,6.09,9.56,11.84,13.69,16.72,20.16,22.56,23.25,24.25,25.31,25.34,23.12,20.25,18.31,17.09,13.91,11.06,9.66,9.09,7.25,5.09,4.84,5.91,7.22,7.88,9.22,11.47,12.47,10.97,8.97,8.41,8.22,7.47,7.03,8.19,9.81,9.81,8.81,8.72,9.78,10.47,10.09,10.62,12.28,13.72,13.69,13.38,14.78,16.12,15.62,14.56,14.03,13.41,11.47,8.75,7.38,7.91,8.5,8.91,10.38,13.38,16.44,17.72,18.69,20.47,22.5,22.91,23.03,24.56,27.25,28.72,29.38,30.72,32.28,32.88,31.12,29.12,28.0,26.34,23.03,19.66,17.69,16.72,14.59,12.31,11.88,12.78,13.12,12.69,12.94,14.16,15.19,14.91,15.38,17.56,20.56,22.25,23.25,25.38,27.91,28.16,27.31,27.34,28.72,29.5,29.12,29.0,29.53,28.62,25.84,22.66,21.16,20.88,19.94,19.34,20.69,22.84,23.81,23.53,23.5,24.34,24.5,23.19,22.28,22.12,22.12,20.0,17.75,16.66,16.47,15.19,14.06,14.62,15.97,16.38,16.22,16.59,18.34,19.72,19.75,20.06,21.56,22.78,22.44,21.62,21.94,22.66,21.47,19.84,19.12,19.5,19.06,17.88,16.97,17.75,18.25,16.88,15.81,17.03,18.78,19.5,20.38,22.22,24.41,24.5,23.62,23.03,23.38,23.34,22.38,22.5,24.5,26.53,27.16,27.59,28.94,30.28,29.53,28.16,27.72,27.59,26.44,24.66,23.59,24.34,24.62,23.94,23.41,24.44,24.53,22.75,20.38,19.19,18.72,17.09,15.56,15.91,17.5,17.88,17.5,16.91,17.28,17.25,15.97,15.5,17.19,19.09,19.59,19.62,20.22,20.66,19.97,18.53,18.31,19.66,20.56,20.62,20.97,22.16,22.53,21.41,19.91,20.62,21.88,22.34,22.78,24.72,26.97,27.28,26.19,25.69,26.06,37.06,38.75,39.75,39.28,38.53,37.5,36.62,35.56,35.41,36.0,36.69,37.31,37.59,37.81,38.16,38.75,38.88,39.97,41.16,41.75,41.72,41.59,41.56,41.47,40.94,40.47,39.62,38.59,37.06,35.44,34.62,34.66,35.16,35.62,36.59,37.34,37.84,37.66,37.59,37.81,38.09,38.06:negativity
36.59,36.44,36.03,35.28,33.78,32.66,32.5,33.59,35.22,36.44,37.19,37.47,36.59,34.0,31.12,29.62,28.66,28.44,28.78,30.16,31.72,32.59,32.88,32.69,32.66,32.06,30.75,29.75,29.75,29.84,29.38,28.91,28.72,28.22,26.62,24.47,22.91,22.0,21.53,21.44,23.03,25.94,29.53,32.53,35.66,39.31,42.59,44.69,46.03,47.69,49.09,49.25,47.75,46.53,45.09,43.28,41.25,40.31,40.44,41.0,41.31,41.38,41.62,41.66,40.78,39.25,38.28,37.34,36.66,35.69,35.88,37.5,39.97,42.25,44.81,48.28,51.16,51.94,51.0,50.31,49.0,47.12,45.38,45.03,45.28,45.25,44.5,44.12,44.38,44.59,44.09,44.06,45.19,46.34,46.97,47.25,48.28,49.22,49.88,49.66,49.75,50.47,49.97,48.72,46.88,45.41,43.41,40.38,37.59,36.12,35.09,34.25,32.94,33.06,33.34,32.66,31.5,30.88,30.44,29.81,29.0,29.12,29.94,31.31,31.78,31.75,31.81,31.84,31.12,30.0,29.62,29.97,29.69,29.25,29.09,29.44,29.56,28.97,28.38,28.09,28.22,27.66,26.88,26.84,26.94,27.12,26.72,26.72,26.88,26.53,25.34,25.03,25.69,27.31,28.66,30.06,31.75,33.28,33.31,32.75,33.16,34.19,35.28,36.0,37.34,39.0,39.81,39.28,38.53,38.09,37.97,37.59,37.38,38.38,40.09,40.5,40.28,40.03,40.0,39.25,38.12,37.47,37.34,37.53,36.84,36.12,36.19,36.44,36.0,35.47,35.75,36.19,35.78,34.97,34.75,34.84,34.91,34.25,34.09,34.66,35.47,35.62,35.69,36.66,37.97,38.5,39.44,40.66,42.53,42.97,42.72,42.41,42.16,42.0,41.06,40.47,41.06,41.75,41.62,41.66,42.28,43.25,43.34,43.38,43.66,44.31,44.84,44.0,43.56,43.47,42.59,40.69,39.03,38.09,38.06,37.41,37.75,38.94,40.84,42.12,43.0,43.66,44.56,44.12,42.81,41.19,40.34,39.16,36.78,34.53,33.44,33.03,32.41,32.16,32.47,33.34,33.31,32.38,31.75,31.97,32.38,33.03,34.28,36.34,38.59,39.19,39.25,39.25,39.38,38.81,38.06,37.66,38.16,38.62,39.06,39.59,41.28,43.34,43.91,44.78,45.75,47.0,46.94,46.59,46.53,46.66,45.28,43.16,41.31,40.41,39.72,39.03,39.25,40.84,42.56,43.88,45.16,47.22,48.53,48.0,46.28,44.28,42.59,40.62,38.91,37.94,38.47,38.88,39.0,39.31,40.62,41.94,42.38,41.88,42.25,42.59,42.12,41.16,40.72,40.44,38.69,36.06,33.41,31.69,29.97,28.84,28.53,30.12,32.31,34.06,35.5,37.97,40.34,41.62,42.12,42.38,42.66,41.66,40.06,38.69,38.59,38.62,38.03,37.38,37.59,37.78,37.06,36.16,36.31,36.72,36.66,36.16,35.81,36.25,36.16,35.81,35.84,36.62,37.69,37.34,36.66,36.91,37.56,38.16,39.12,41.31,44.28,46.09,46.81,47.47,48.34,48.41,47.0,44.69,42.78,40.28,37.09,34.38,33.06,33.22,33.72,33.88,35.38,37.31,38.62,39.19,38.91,39.0,38.56,37.06,35.16,34.94,35.16,34.75,33.91,33.81,33.69,33.25,32.28,32.75,33.72,34.47,34.16,33.34,33.38,32.78,31.88,31.16,32.16,33.69,33.94,33.78,33.75,34.09,33.62,33.06,32.81,33.72,34.53,35.09,36.25,38.62,40.44,41.25,40.81,40.41,39.41,37.53,35.59,34.97,35.34,35.88,36.03,36.62,37.41,37.44,36.47,35.06,34.78,34.5,34.25,33.94,34.59,35.19,35.28,34.38,33.78,33.78,33.5,33.12,33.5,34.66,36.03,36.59,36.31,36.84,37.47,37.75,38.12,39.38,41.34,43.22,43.75,44.41,45.69,46.22,45.91,45.44,45.41,45.09,43.5,40.78,38.41,35.72,32.53,29.47,28.12,28.06,28.94,29.59,30.91,33.16,35.31,36.34,37.16,38.62,40.03,40.38,40.41,40.75,40.81,39.84,37.62,36.16,35.28,34.53,33.66,32.81,32.81,32.72,31.62,31.03,31.5,32.78,33.59,34.81,36.41,38.62,40.5,41.5,42.59,43.62,43.28,41.34,39.34,38.06,37.25,36.34,36.03,36.59,37.44,37.28,36.81,36.69,36.84,36.5,35.5,35.06,35.38,36.28,36.88,37.31,39.06,40.66,40.94,41.06,41.47,42.19,42.28,42.5,43.31,44.66,45.16,44.31,43.28,42.31,41.41,39.56,38.06,37.88,37.94,38.03,37.62,37.75,37.88,37.34,35.88,35.47,35.84,36.81,37.06,37.47,38.53,39.22,39.03,39.03,40.22,41.38,41.69,41.25,40.56,40.31,39.69,38.75,38.44,38.59,38.84,37.5,36.31,35.69,35.5,34.72,34.0,34.41,35.12,35.72,36.0,36.84,38.25,39.12,39.19,39.38,39.97,40.53,40.12,39.66,39.09,39.09,38.09,36.97,37.41,38.5,39.66,40.53,41.62,43.03,43.81,43.47,42.97,43.31,43.81,43.31,42.25,41.59,41.16,39.88,38.34,38.38,39.25,39.97,39.88,39.91,39.97,39.19,37.78,36.06,35.31,35.06,34.47,33.91,34.34,35.84,37.28,38.28,39.56,40.94,41.09,39.84,38.75,38.81,39.03,39.0,38.91,38.56,38.38,36.91,35.31,34.44,35.12,35.88,37.16,38.78,41.22,43.19,43.84,43.91,43.94,43.47,42.19,40.91,39.97,40.59,40.62,41.31,42.53,44.19,44.94,44.84,44.41,44.19,43.66,42.41,41.41,41.19,41.09,40.84,40.56,40.84,41.84,42.47,43.0,43.09,44.19,44.44,43.84,43.34,43.34,43.59,42.97,42.53,43.28,44.28,44.44,44.44,44.66,45.12,45.31,45.16,44.69,45.09,45.16,44.44,43.78,44.19,44.59,44.06,42.75,41.5,39.72,37.69,35.06,33.5,33.44,33.78,33.78,34.06,35.12,35.41,34.72,34.16,34.5,34.94,35.38,35.72,36.88,38.44,39.81,40.19,40.62,41.53,41.59,40.88,40.09,40.25,40.12,39.53,38.62,38.34,38.31,37.56,36.56,36.03,36.53,36.38,35.66,34.69,33.78,32.72,31.0,29.44,29.62,30.38,31.0,31.25,32.69,34.25,34.94,34.88,34.88,35.09,35.25,34.81,34.81,35.69,36.94,37.09,37.09,37.88,38.5,38.78,38.94,39.56,40.31,40.19,39.06,37.56,35.94,34.69,32.97,31.22,31.0,31.47,31.31,30.78,31.44,32.25,32.94,33.31,34.66,36.78,38.66,39.88,41.0,41.81,41.88,40.62,38.62,37.0,35.47,33.25,30.91,29.78,29.34,29.22,28.62,28.03,28.16,28.03,27.28,27.19,28.62,30.75,32.38,33.72,35.56,37.09,37.88,37.84,38.34,39.22,40.28,40.53,40.94,41.84,42.78,42.62,42.44,42.88,43.66,43.69,43.53,43.62,44.03,43.75,42.5,41.12,39.66,37.75,35.81,34.5,34.94,36.16,36.91,37.88,39.75,41.16,41.75,41.97,41.91,41.94,41.28,40.31,39.56,39.97,40.81,40.81,40.56,40.78,40.81,39.53,37.53,36.09,34.56,32.62,30.19,28.78,28.38,28.22,28.38,29.03,30.72,32.81,34.62,36.84,39.62,42.94,45.38,46.56,47.84,48.38,47.94,46.94,45.88,45.62,46.16,46.22,47.16,48.88,50.5,50.75,50.38,50.0,49.69,48.09,45.97,43.66,41.44,38.69,35.19,32.25,30.97,30.47,30.31,30.94,33.41,36.72,38.78,40.5,41.69,42.59,42.28,40.81,39.97,40.0,39.84,38.53,37.44,36.5,36.0,34.59,33.62,33.59,34.28,33.66,33.0,32.06,31.56,30.47,29.0,28.19,28.81,29.59,29.56,29.62,30.19,30.31,29.5,28.31,28.28,28.56,28.41,28.41,29.25,31.0,32.25,32.88,33.22,33.75,34.06,33.59,32.91,33.25,33.59,33.0,32.09,31.44,31.19,30.31,29.59,29.12,29.44,28.78,26.91,25.38,24.69,24.66,24.66,25.16,26.84,28.69,29.56,30.12,30.66,31.44,30.88,29.28,27.81,26.91,26.0,25.12,24.78,25.69,26.91,27.41,27.84,29.0,30.62,31.69,32.16,32.97,33.72,33.38,31.06,27.53,24.16,20.66,16.97,14.25,13.94,15.09,15.91,17.06,18.78,21.03,22.69,23.53,24.22,25.28,25.69,24.91,23.94,24.25,25.0,25.44,26.47,28.5,31.34,32.75,33.28,33.91,34.75,34.75,34.19,33.75,33.78,33.03,30.78,28.34,26.84,25.81,24.94,24.66,26.66,29.34,31.38,33.38,35.5,37.69,39.09,39.28,39.25,39.25,38.69,36.69,34.41,33.66,33.16,32.69,32.47,33.22,34.38,34.25,32.97,31.5,29.78,27.5,24.44,21.75,20.59,20.31,19.94,19.41,20.38,21.66,22.84,24.16,26.19,29.25,31.47,33.03,34.72,36.97,38.91,39.47,39.69,40.28,40.0,38.94,37.75,37.06,37.16,36.56,35.72,34.91,34.53,33.59,31.62,30.12,30.0,29.69,29.44,29.19,30.09,31.44,32.09,31.75,32.31,33.19,33.31,33.34,33.88,35.06,35.81,35.56,34.91,35.06,35.34,34.66,33.62,33.47,34.31,34.41,33.78,34.16,34.78,34.69,33.59,32.84,33.03,32.75,32.06,31.44,31.97,32.81,32.88,32.72,33.97,35.12,35.91,36.19,37.12,38.47,39.41,39.06,38.31,38.06,36.84,34.34,31.66,30.19,29.75,29.34,29.25,31.25,33.66,35.38,36.16,36.59,37.06,36.53,34.94,33.56:33.59,35.22,36.44,37.19,37.47,36.59,34.0,31.12,29.62,28.66,28.44,28.78,30.16,31.72,32.59,32.88,32.69,32.66,32.06,30.75,29.75,29.75,29.84,29.38,28.91,28.72,28.22,26.62,24.47,22.91,22.0,21.53,21.44,23.03,25.94,29.53,32.53,35.66,39.31,42.59,44.69,46.03,47.69,49.09,49.25,47.75,46.53,45.09,43.28,41.25,40.31,40.44,41.0,41.31,41.38,41.62,41.66,40.78,39.25,38.28,37.34,36.66,35.69,35.88,37.5,39.97,42.25,44.81,48.28,51.16,51.94,51.0,50.31,49.0,47.12,45.38,45.03,45.28,45.25,44.5,44.12,44.38,44.59,44.09,44.06,45.19,46.34,46.97,47.25,48.28,49.22,49.88,49.66,49.75,50.47,49.97,48.72,46.88,45.41,43.41,40.38,37.59,36.12,35.09,34.25,32.94,33.06,33.34,32.66,31.5,30.88,30.44,29.81,29.0,29.12,29.94,31.31,31.78,31.75,31.81,31.84,31.12,30.0,29.62,29.97,29.69,29.25,29.09,29.44,29.56,28.97,28.38,28.09,28.22,27.66,26.88,26.84,26.94,27.12,26.72,26.72,26.88,26.53,25.34,25.03,25.69,27.31,28.66,30.06,31.75,33.28,33.31,32.75,33.16,34.19,35.28,36.0,37.34,39.0,39.81,39.28,38.53,38.09,37.97,37.59,37.38,38.38,40.09,40.5,40.28,40.03,40.0,39.25,38.12,37.47,37.34,37.53,36.84,36.12,36.19,36.44,36.0,35.47,35.75,36.19,35.78,34.97,34.75,34.84,34.91,34.25,34.09,34.66,35.47,35.62,35.69,36.66,37.97,38.5,39.44,40.66,42.53,42.97,42.72,42.41,42.16,42.0,41.06,40.47,41.06,41.75,41.62,41.66,42.28,43.25,43.34,43.38,43.66,44.31,44.84,44.0,43.56,43.47,42.59,40.69,39.03,38.09,38.06,37.41,37.75,38.94,40.84,42.12,43.0,43.66,44.56,44.12,42.81,41.19,40.34,39.16,36.78,34.53,33.44,33.03,32.41,32.16,32.47,33.34,33.31,32.38,31.75,31.97,32.38,33.03,34.28,36.34,38.59,39.19,39.25,39.25,39.38,38.81,38.06,37.66,38.16,38.62,39.06,39.59,41.28,43.34,43.91,44.78,45.75,47.0,46.94,46.59,46.53,46.66,45.28,43.16,41.31,40.41,39.72,39.03,39.25,40.84,42.56,43.88,45.16,47.22,48.53,48.0,46.28,44.28,42.59,40.62,38.91,37.94,38.47,38.88,39.0,39.31,40.62,41.94,42.38,41.88,42.25,42.59,42.12,41.16,40.72,40.44,38.69,36.06,33.41,31.69,29.97,28.84,28.53,30.12,32.31,34.06,35.5,37.97,40.34,41.62,42.12,42.38,42.66,41.66,40.06,38.69,38.59,38.62,38.03,37.38,37.59,37.78,37.06,36.16,36.31,36.72,36.66,36.16,35.81,36.25,36.16,35.81,35.84,36.62,37.69,37.34,36.66,36.91,37.56,38.16,39.12,41.31,44.28,46.09,46.81,47.47,48.34,48.41,47.0,44.69,42.78,40.28,37.09,34.38,33.06,33.22,33.72,33.88,35.38,37.31,38.62,39.19,38.91,39.0,38.56,37.06,35.16,34.94,35.16,34.75,33.91,33.81,33.69,33.25,32.28,32.75,33.72,34.47,34.16,33.34,33.38,32.78,31.88,31.16,32.16,33.69,33.94,33.78,33.75,34.09,33.62,33.06,32.81,33.72,34.53,35.09,36.25,38.62,40.44,41.25,40.81,40.41,39.41,37.53,35.59,34.97,35.34,35.88,36.03,36.62,37.41,37.44,36.47,35.06,34.78,34.5,34.25,33.94,34.59,35.19,35.28,34.38,33.78,33.78,33.5,33.12,33.5,34.66,36.03,36.59,36.31,36.84,37.47,37.75,38.12,39.38,41.34,43.22,43.75,44.41,45.69,46.22,45.91,45.44,45.41,45.09,43.5,40.78,38.41,35.72,32.53,29.47,28.12,28.06,28.94,29.59,30.91,33.16,35.31,36.34,37.16,38.62,40.03,40.38,40.41,40.75,40.81,39.84,37.62,36.16,35.28,34.53,33.66,32.81,32.81,32.72,31.62,31.03,31.5,32.78,33.59,34.81,36.41,38.62,40.5,41.5,42.59,43.62,43.28,41.34,39.34,38.06,37.25,36.34,36.03,36.59,37.44,37.28,36.81,36.69,36.84,36.5,35.5,35.06,35.38,36.28,36.88,37.31,39.06,40.66,40.94,41.06,41.47,42.19,42.28,42.5,43.31,44.66,45.16,44.31,43.28,42.31,41.41,39.56,38.06,37.88,37.94,38.03,37.62,37.75,37.88,37.34,35.88,35.47,35.84,36.81,37.06,37.47,38.53,39.22,39.03,39.03,40.22,41.38,41.69,41.25,40.56,40.31,39.69,38.75,38.44,38.59,38.84,37.5,36.31,35.69,35.5,34.72,34.0,34.41,35.12,35.72,36.0,36.84,38.25,39.12,39.19,39.38,39.97,40.53,40.12,39.66,39.09,39.09,38.09,36.97,37.41,38.5,39.66,40.53,41.62,43.03,43.81,43.47,42.97,43.31,43.81,43.31,42.25,41.59,41.16,39.88,38.34,38.38,39.25,39.97,39.88,39.91,39.97,39.19,37.78,36.06,35.31,35.06,34.47,33.91,34.34,35.84,37.28,38.28,39.56,40.94,41.09,39.84,38.75,38.81,39.03,39.0,38.91,38.56,38.38,36.91,35.31,34.44,35.12,35.88,37.16,38.78,41.22,43.19,43.84,43.91,43.94,43.47,42.19,40.91,39.97,40.59,40.62,41.31,42.53,44.19,44.94,44.84,44.41,44.19,43.66,42.41,41.41,41.19,41.09,40.84,40.56,40.84,41.84,42.47,43.0,43.09,44.19,44.44,43.84,43.34,43.34,43.59,42.97,42.53,43.28,44.28,44.44,44.44,44.66,45.12,45.31,45.16,44.69,45.09,45.16,44.44,43.78,44.19,44.59,44.06,42.75,41.5,39.72,37.69,35.06,33.5,33.44,33.78,33.78,34.06,35.12,35.41,34.72,34.16,34.5,34.94,35.38,35.72,36.88,38.44,39.81,40.19,40.62,41.53,41.59,40.88,40.09,40.25,40.12,39.53,38.62,38.34,38.31,37.56,36.56,36.03,36.53,36.38,35.66,34.69,33.78,32.72,31.0,29.44,29.62,30.38,31.0,31.25,32.69,34.25,34.94,34.88,34.88,35.09,35.25,34.81,34.81,35.69,36.94,37.09,37.09,37.88,38.5,38.78,38.94,39.56,40.31,40.19,39.06,37.56,35.94,34.69,32.97,31.22,31.0,31.47,31.31,30.78,31.44,32.25,32.94,33.31,34.66,36.78,38.66,39.88,41.0,41.81,41.88,40.62,38.62,37.0,35.47,33.25,30.91,29.78,29.34,29.22,28.62,28.03,28.16,28.03,27.28,27.19,28.62,30.75,32.38,33.72,35.56,37.09,37.88,37.84,38.34,39.22,40.28,40.53,40.94,41.84,42.78,42.62,42.44,42.88,43.66,43.69,43.53,43.62,44.03,43.75,42.5,41.12,39.66,37.75,35.81,34.5,34.94,36.16,36.91,37.88,39.75,41.16,41.75,41.97,41.91,41.94,41.28,40.31,39.56,39.97,40.81,40.81,40.56,40.78,40.81,39.53,37.53,36.09,34.56,32.62,30.19,28.78,28.38,28.22,28.38,29.03,30.72,32.81,34.62,36.84,39.62,42.94,45.38,46.56,47.84,48.38,47.94,46.94,45.88,45.62,46.16,46.22,47.16,48.88,50.5,50.75,50.38,50.0,49.69,48.09,45.97,43.66,41.44,38.69,35.19,32.25,30.97,30.47,30.31,30.94,33.41,36.72,38.78,40.5,41.69,42.59,42.28,40.81,39.97,40.0,39.84,38.53,37.44,36.5,36.0,34.59,33.62,33.59,34.28,33.66,33.0,32.06,31.56,30.47,29.0,28.19,28.81,29.59,29.56,29.62,30.19,30.31,29.5,28.31,28.28,28.56,28.41,28.41,29.25,31.0,32.25,32.88,33.22,33.75,34.06,33.59,32.91,33.25,33.59,33.0,32.09,31.44,31.19,30.31,29.59,29.12,29.44,28.78,26.91,25.38,24.69,24.66,24.66,25.16,26.84,28.69,29.56,30.12,30.66,31.44,30.88,29.28,27.81,26.91,26.0,25.12,24.78,25.69,26.91,27.41,27.84,29.0,30.62,31.69,32.16,32.97,33.72,33.38,31.06,27.53,24.16,20.66,16.97,14.25,13.94,15.09,15.91,17.06,18.78,21.03,22.69,23.53,24.22,25.28,25.69,24.91,23.94,24.25,25.0,25.44,26.47,28.5,31.34,32.75,33.28,33.91,34.75,34.75,34.19,33.75,33.78,33.03,30.78,28.34,26.84,25.81,24.94,24.66,26.66,29.34,31.38,33.38,35.5,37.69,39.09,39.28,39.25,39.25,38.69,36.69,34.41,33.66,33.16,32.69,32.47,33.22,34.38,34.25,32.97,31.5,29.78,27.5,24.44,21.75,20.59,20.31,19.94,19.41,20.38,21.66,22.84,24.16,26.19,29.25,31.47,33.03,34.72,36.97,38.91,39.47,39.69,40.28,40.0,38.94,37.75,37.06,37.16,36.56,35.72,34.91,34.53,33.59,31.62,30.12,30.0,29.69,29.44,29.19,30.09,31.44,32.09,31.75,32.31,33.19,33.31,33.34,33.88,35.06,35.81,35.56,34.91,35.06,35.34,34.66,33.62,33.47,34.31,34.41,33.78,34.16,34.78,34.69,33.59,32.84,33.03,32.75,32.06,31.44,31.97,32.81,32.88,32.72,33.97,35.12,35.91,36.19,37.12,38.47,39.41,39.06,38.31,38.06,36.84,34.34,31.66,30.19,29.75,29.34,29.25,31.25,33.66,35.38,36.16,36.59,37.06,36.53,34.94,33.56,89.69,90.34,89.88,88.47,86.78,85.22,83.78:31.12,29.62,28.66,28.44,28.78,30.16,31.72,32.59,32.88,32.69,32.66,32.06,30.75,29.75,29.75,29.84,29.38,28.91,28.72,28.22,26.62,24.47,22.91,22.0,21.53,21.44,23.03,25.94,29.53,32.53,35.66,39.31,42.59,44.69,46.03,47.69,49.09,49.25,47.75,46.53,45.09,43.28,41.25,40.31,40.44,41.0,41.31,41.38,41.62,41.66,40.78,39.25,38.28,37.34,36.66,35.69,35.88,37.5,39.97,42.25,44.81,48.28,51.16,51.94,51.0,50.31,49.0,47.12,45.38,45.03,45.28,45.25,44.5,44.12,44.38,44.59,44.09,44.06,45.19,46.34,46.97,47.25,48.28,49.22,49.88,49.66,49.75,50.47,49.97,48.72,46.88,45.41,43.41,40.38,37.59,36.12,35.09,34.25,32.94,33.06,33.34,32.66,31.5,30.88,30.44,29.81,29.0,29.12,29.94,31.31,31.78,31.75,31.81,31.84,31.12,30.0,29.62,29.97,29.69,29.25,29.09,29.44,29.56,28.97,28.38,28.09,28.22,27.66,26.88,26.84,26.94,27.12,26.72,26.72,26.88,26.53,25.34,25.03,25.69,27.31,28.66,30.06,31.75,33.28,33.31,32.75,33.16,34.19,35.28,36.0,37.34,39.0,39.81,39.28,38.53,38.09,37.97,37.59,37.38,38.38,40.09,40.5,40.28,40.03,40.0,39.25,38.12,37.47,37.34,37.53,36.84,36.12,36.19,36.44,36.0,35.47,35.75,36.19,35.78,34.97,34.75,34.84,34.91,34.25,34.09,34.66,35.47,35.62,35.69,36.66,37.97,38.5,39.44,40.66,42.53,42.97,42.72,42.41,42.16,42.0,41.06,40.47,41.06,41.75,41.62,41.66,42.28,43.25,43.34,43.38,43.66,44.31,44.84,44.0,43.56,43.47,42.59,40.69,39.03,38.09,38.06,37.41,37.75,38.94,40.84,42.12,43.0,43.66,44.56,44.12,42.81,41.19,40.34,39.16,36.78,34.53,33.44,33.03,32.41,32.16,32.47,33.34,33.31,32.38,31.75,31.97,32.38,33.03,34.28,36.34,38.59,39.19,39.25,39.25,39.38,38.81,38.06,37.66,38.16,38.62,39.06,39.59,41.28,43.34,43.91,44.78,45.75,47.0,46.94,46.59,46.53,46.66,45.28,43.16,41.31,40.41,39.72,39.03,39.25,40.84,42.56,43.88,45.16,47.22,48.53,48.0,46.28,44.28,42.59,40.62,38.91,37.94,38.47,38.88,39.0,39.31,40.62,41.94,42.38,41.88,42.25,42.59,42.12,41.16,40.72,40.44,38.69,36.06,33.41,31.69,29.97,28.84,28.53,30.12,32.31,34.06,35.5,37.97,40.34,41.62,42.12,42.38,42.66,41.66,40.06,38.69,38.59,38.62,38.03,37.38,37.59,37.78,37.06,36.16,36.31,36.72,36.66,36.16,35.81,36.25,36.16,35.81,35.84,36.62,37.69,37.34,36.66,36.91,37.56,38.16,39.12,41.31,44.28,46.09,46.81,47.47,48.34,48.41,47.0,44.69,42.78,40.28,37.09,34.38,33.06,33.22,33.72,33.88,35.38,37.31,38.62,39.19,38.91,39.0,38.56,37.06,35.16,34.94,35.16,34.75,33.91,33.81,33.69,33.25,32.28,32.75,33.72,34.47,34.16,33.34,33.38,32.78,31.88,31.16,32.16,33.69,33.94,33.78,33.75,34.09,33.62,33.06,32.81,33.72,34.53,35.09,36.25,38.62,40.44,41.25,40.81,40.41,39.41,37.53,35.59,34.97,35.34,35.88,36.03,36.62,37.41,37.44,36.47,35.06,34.78,34.5,34.25,33.94,34.59,35.19,35.28,34.38,33.78,33.78,33.5,33.12,33.5,34.66,36.03,36.59,36.31,36.84,37.47,37.75,38.12,39.38,41.34,43.22,43.75,44.41,45.69,46.22,45.91,45.44,45.41,45.09,43.5,40.78,38.41,35.72,32.53,29.47,28.12,28.06,28.94,29.59,30.91,33.16,35.31,36.34,37.16,38.62,40.03,40.38,40.41,40.75,40.81,39.84,37.62,36.16,35.28,34.53,33.66,32.81,32.81,32.72,31.62,31.03,31.5,32.78,33.59,34.81,36.41,38.62,40.5,41.5,42.59,43.62,43.28,41.34,39.34,38.06,37.25,36.34,36.03,36.59,37.44,37.28,36.81,36.69,36.84,36.5,35.5,35.06,35.38,36.28,36.88,37.31,39.06,40.66,40.94,41.06,41.47,42.19,42.28,42.5,43.31,44.66,45.16,44.31,43.28,42.31,41.41,39.56,38.06,37.88,37.94,38.03,37.62,37.75,37.88,37.34,35.88,35.47,35.84,36.81,37.06,37.47,38.53,39.22,39.03,39.03,40.22,41.38,41.69,41.25,40.56,40.31,39.69,38.75,38.44,38.59,38.84,37.5,36.31,35.69,35.5,34.72,34.0,34.41,35.12,35.72,36.0,36.84,38.25,39.12,39.19,39.38,39.97,40.53,40.12,39.66,39.09,39.09,38.09,36.97,37.41,38.5,39.66,40.53,41.62,43.03,43.81,43.47,42.97,43.31,43.81,43.31,42.25,41.59,41.16,39.88,38.34,38.38,39.25,39.97,39.88,39.91,39.97,39.19,37.78,36.06,35.31,35.06,34.47,33.91,34.34,35.84,37.28,38.28,39.56,40.94,41.09,39.84,38.75,38.81,39.03,39.0,38.91,38.56,38.38,36.91,35.31,34.44,35.12,35.88,37.16,38.78,41.22,43.19,43.84,43.91,43.94,43.47,42.19,40.91,39.97,40.59,40.62,41.31,42.53,44.19,44.94,44.84,44.41,44.19,43.66,42.41,41.41,41.19,41.09,40.84,40.56,40.84,41.84,42.47,43.0,43.09,44.19,44.44,43.84,43.34,43.34,43.59,42.97,42.53,43.28,44.28,44.44,44.44,44.66,45.12,45.31,45.16,44.69,45.09,45.16,44.44,43.78,44.19,44.59,44.06,42.75,41.5,39.72,37.69,35.06,33.5,33.44,33.78,33.78,34.06,35.12,35.41,34.72,34.16,34.5,34.94,35.38,35.72,36.88,38.44,39.81,40.19,40.62,41.53,41.59,40.88,40.09,40.25,40.12,39.53,38.62,38.34,38.31,37.56,36.56,36.03,36.53,36.38,35.66,34.69,33.78,32.72,31.0,29.44,29.62,30.38,31.0,31.25,32.69,34.25,34.94,34.88,34.88,35.09,35.25,34.81,34.81,35.69,36.94,37.09,37.09,37.88,38.5,38.78,38.94,39.56,40.31,40.19,39.06,37.56,35.94,34.69,32.97,31.22,31.0,31.47,31.31,30.78,31.44,32.25,32.94,33.31,34.66,36.78,38.66,39.88,41.0,41.81,41.88,40.62,38.62,37.0,35.47,33.25,30.91,29.78,29.34,29.22,28.62,28.03,28.16,28.03,27.28,27.19,28.62,30.75,32.38,33.72,35.56,37.09,37.88,37.84,38.34,39.22,40.28,40.53,40.94,41.84,42.78,42.62,42.44,42.88,43.66,43.69,43.53,43.62,44.03,43.75,42.5,41.12,39.66,37.75,35.81,34.5,34.94,36.16,36.91,37.88,39.75,41.16,41.75,41.97,41.91,41.94,41.28,40.31,39.56,39.97,40.81,40.81,40.56,40.78,40.81,39.53,37.53,36.09,34.56,32.62,30.19,28.78,28.38,28.22,28.38,29.03,30.72,32.81,34.62,36.84,39.62,42.94,45.38,46.56,47.84,48.38,47.94,46.94,45.88,45.62,46.16,46.22,47.16,48.88,50.5,50.75,50.38,50.0,49.69,48.09,45.97,43.66,41.44,38.69,35.19,32.25,30.97,30.47,30.31,30.94,33.41,36.72,38.78,40.5,41.69,42.59,42.28,40.81,39.97,40.0,39.84,38.53,37.44,36.5,36.0,34.59,33.62,33.59,34.28,33.66,33.0,32.06,31.56,30.47,29.0,28.19,28.81,29.59,29.56,29.62,30.19,30.31,29.5,28.31,28.28,28.56,28.41,28.41,29.25,31.0,32.25,32.88,33.22,33.75,34.06,33.59,32.91,33.25,33.59,33.0,32.09,31.44,31.19,30.31,29.59,29.12,29.44,28.78,26.91,25.38,24.69,24.66,24.66,25.16,26.84,28.69,29.56,30.12,30.66,31.44,30.88,29.28,27.81,26.91,26.0,25.12,24.78,25.69,26.91,27.41,27.84,29.0,30.62,31.69,32.16,32.97,33.72,33.38,31.06,27.53,24.16,20.66,16.97,14.25,13.94,15.09,15.91,17.06,18.78,21.03,22.69,23.53,24.22,25.28,25.69,24.91,23.94,24.25,25.0,25.44,26.47,28.5,31.34,32.75,33.28,33.91,34.75,34.75,34.19,33.75,33.78,33.03,30.78,28.34,26.84,25.81,24.94,24.66,26.66,29.34,31.38,33.38,35.5,37.69,39.09,39.28,39.25,39.25,38.69,36.69,34.41,33.66,33.16,32.69,32.47,33.22,34.38,34.25,32.97,31.5,29.78,27.5,24.44,21.75,20.59,20.31,19.94,19.41,20.38,21.66,22.84,24.16,26.19,29.25,31.47,33.03,34.72,36.97,38.91,39.47,39.69,40.28,40.0,38.94,37.75,37.06,37.16,36.56,35.72,34.91,34.53,33.59,31.62,30.12,30.0,29.69,29.44,29.19,30.09,31.44,32.09,31.75,32.31,33.19,33.31,33.34,33.88,35.06,35.81,35.56,34.91,35.06,35.34,34.66,33.62,33.47,34.31,34.41,33.78,34.16,34.78,34.69,33.59,32.84,33.03,32.75,32.06,31.44,31.97,32.81,32.88,32.72,33.97,35.12,35.91,36.19,37.12,38.47,39.41,39.06,38.31,38.06,36.84,34.34,31.66,30.19,29.75,29.34,29.25,31.25,33.66,35.38,36.16,36.59,37.06,36.53,34.94,33.56,89.69,90.34,89.88,88.47,86.78,85.22,83.78,83.25,83.34,83.41,83.28,82.84,81.91,80.81:32.59,32.88,32.69,32.66,32.06,30.75,29.75,29.75,29.84,29.38,28.91,28.72,28.22,26.62,24.47,22.91,22.0,21.53,21.44,23.03,25.94,29.53,32.53,35.66,39.31,42.59,44.69,46.03,47.69,49.09,49.25,47.75,46.53,45.09,43.28,41.25,40.31,40.44,41.0,41.31,41.38,41.62,41.66,40.78,39.25,38.28,37.34,36.66,35.69,35.88,37.5,39.97,42.25,44.81,48.28,51.16,51.94,51.0,50.31,49.0,47.12,45.38,45.03,45.28,45.25,44.5,44.12,44.38,44.59,44.09,44.06,45.19,46.34,46.97,47.25,48.28,49.22,49.88,49.66,49.75,50.47,49.97,48.72,46.88,45.41,43.41,40.38,37.59,36.12,35.09,34.25,32.94,33.06,33.34,32.66,31.5,30.88,30.44,29.81,29.0,29.12,29.94,31.31,31.78,31.75,31.81,31.84,31.12,30.0,29.62,29.97,29.69,29.25,29.09,29.44,29.56,28.97,28.38,28.09,28.22,27.66,26.88,26.84,26.94,27.12,26.72,26.72,26.88,26.53,25.34,25.03,25.69,27.31,28.66,30.06,31.75,33.28,33.31,32.75,33.16,34.19,35.28,36.0,37.34,39.0,39.81,39.28,38.53,38.09,37.97,37.59,37.38,38.38,40.09,40.5,40.28,40.03,40.0,39.25,38.12,37.47,37.34,37.53,36.84,36.12,36.19,36.44,36.0,35.47,35.75,36.19,35.78,34.97,34.75,34.84,34.91,34.25,34.09,34.66,35.47,35.62,35.69,36.66,37.97,38.5,39.44,40.66,42.53,42.97,42.72,42.41,42.16,42.0,41.06,40.47,41.06,41.75,41.62,41.66,42.28,43.25,43.34,43.38,43.66,44.31,44.84,44.0,43.56,43.47,42.59,40.69,39.03,38.09,38.06,37.41,37.75,38.94,40.84,42.12,43.0,43.66,44.56,44.12,42.81,41.19,40.34,39.16,36.78,34.53,33.44,33.03,32.41,32.16,32.47,33.34,33.31,32.38,31.75,31.97,32.38,33.03,34.28,36.34,38.59,39.19,39.25,39.25,39.38,38.81,38.06,37.66,38.16,38.62,39.06,39.59,41.28,43.34,43.91,44.78,45.75,47.0,46.94,46.59,46.53,46.66,45.28,43.16,41.31,40.41,39.72,39.03,39.25,40.84,42.56,43.88,45.16,47.22,48.53,48.0,46.28,44.28,42.59,40.62,38.91,37.94,38.47,38.88,39.0,39.31,40.62,41.94,42.38,41.88,42.25,42.59,42.12,41.16,40.72,40.44,38.69,36.06,33.41,31.69,29.97,28.84,28.53,30.12,32.31,34.06,35.5,37.97,40.34,41.62,42.12,42.38,42.66,41.66,40.06,38.69,38.59,38.62,38.03,37.38,37.59,37.78,37.06,36.16,36.31,36.72,36.66,36.16,35.81,36.25,36.16,35.81,35.84,36.62,37.69,37.34,36.66,36.91,37.56,38.16,39.12,41.31,44.28,46.09,46.81,47.47,48.34,48.41,47.0,44.69,42.78,40.28,37.09,34.38,33.06,33.22,33.72,33.88,35.38,37.31,38.62,39.19,38.91,39.0,38.56,37.06,35.16,34.94,35.16,34.75,33.91,33.81,33.69,33.25,32.28,32.75,33.72,34.47,34.16,33.34,33.38,32.78,31.88,31.16,32.16,33.69,33.94,33.78,33.75,34.09,33.62,33.06,32.81,33.72,34.53,35.09,36.25,38.62,40.44,41.25,40.81,40.41,39.41,37.53,35.59,34.97,35.34,35.88,36.03,36.62,37.41,37.44,36.47,35.06,34.78,34.5,34.25,33.94,34.59,35.19,35.28,34.38,33.78,33.78,33.5,33.12,33.5,34.66,36.03,36.59,36.31,36.84,37.47,37.75,38.12,39.38,41.34,43.22,43.75,44.41,45.69,46.22,45.91,45.44,45.41,45.09,43.5,40.78,38.41,35.72,32.53,29.47,28.12,28.06,28.94,29.59,30.91,33.16,35.31,36.34,37.16,38.62,40.03,40.38,40.41,40.75,40.81,39.84,37.62,36.16,35.28,34.53,33.66,32.81,32.81,32.72,31.62,31.03,31.5,32.78,33.59,34.81,36.41,38.62,40.5,41.5,42.59,43.62,43.28,41.34,39.34,38.06,37.25,36.34,36.03,36.59,37.44,37.28,36.81,36.69,36.84,36.5,35.5,35.06,35.38,36.28,36.88,37.31,39.06,40.66,40.94,41.06,41.47,42.19,42.28,42.5,43.31,44.66,45.16,44.31,43.28,42.31,41.41,39.56,38.06,37.88,37.94,38.03,37.62,37.75,37.88,37.34,35.88,35.47,35.84,36.81,37.06,37.47,38.53,39.22,39.03,39.03,40.22,41.38,41.69,41.25,40.56,40.31,39.69,38.75,38.44,38.59,38.84,37.5,36.31,35.69,35.5,34.72,34.0,34.41,35.12,35.72,36.0,36.84,38.25,39.12,39.19,39.38,39.97,40.53,40.12,39.66,39.09,39.09,38.09,36.97,37.41,38.5,39.66,40.53,41.62,43.03,43.81,43.47,42.97,43.31,43.81,43.31,42.25,41.59,41.16,39.88,38.34,38.38,39.25,39.97,39.88,39.91,39.97,39.19,37.78,36.06,35.31,35.06,34.47,33.91,34.34,35.84,37.28,38.28,39.56,40.94,41.09,39.84,38.75,38.81,39.03,39.0,38.91,38.56,38.38,36.91,35.31,34.44,35.12,35.88,37.16,38.78,41.22,43.19,43.84,43.91,43.94,43.47,42.19,40.91,39.97,40.59,40.62,41.31,42.53,44.19,44.94,44.84,44.41,44.19,43.66,42.41,41.41,41.19,41.09,40.84,40.56,40.84,41.84,42.47,43.0,43.09,44.19,44.44,43.84,43.34,43.34,43.59,42.97,42.53,43.28,44.28,44.44,44.44,44.66,45.12,45.31,45.16,44.69,45.09,45.16,44.44,43.78,44.19,44.59,44.06,42.75,41.5,39.72,37.69,35.06,33.5,33.44,33.78,33.78,34.06,35.12,35.41,34.72,34.16,34.5,34.94,35.38,35.72,36.88,38.44,39.81,40.19,40.62,41.53,41.59,40.88,40.09,40.25,40.12,39.53,38.62,38.34,38.31,37.56,36.56,36.03,36.53,36.38,35.66,34.69,33.78,32.72,31.0,29.44,29.62,30.38,31.0,31.25,32.69,34.25,34.94,34.88,34.88,35.09,35.25,34.81,34.81,35.69,36.94,37.09,37.09,37.88,38.5,38.78,38.94,39.56,40.31,40.19,39.06,37.56,35.94,34.69,32.97,31.22,31.0,31.47,31.31,30.78,31.44,32.25,32.94,33.31,34.66,36.78,38.66,39.88,41.0,41.81,41.88,40.62,38.62,37.0,35.47,33.25,30.91,29.78,29.34,29.22,28.62,28.03,28.16,28.03,27.28,27.19,28.62,30.75,32.38,33.72,35.56,37.09,37.88,37.84,38.34,39.22,40.28,40.53,40.94,41.84,42.78,42.62,42.44,42.88,43.66,43.69,43.53,43.62,44.03,43.75,42.5,41.12,39.66,37.75,35.81,34.5,34.94,36.16,36.91,37.88,39.75,41.16,41.75,41.97,41.91,41.94,41.28,40.31,39.56,39.97,40.81,40.81,40.56,40.78,40.81,39.53,37.53,36.09,34.56,32.62,30.19,28.78,28.38,28.22,28.38,29.03,30.72,32.81,34.62,36.84,39.62,42.94,45.38,46.56,47.84,48.38,47.94,46.94,45.88,45.62,46.16,46.22,47.16,48.88,50.5,50.75,50.38,50.0,49.69,48.09,45.97,43.66,41.44,38.69,35.19,32.25,30.97,30.47,30.31,30.94,33.41,36.72,38.78,40.5,41.69,42.59,42.28,40.81,39.97,40.0,39.84,38.53,37.44,36.5,36.0,34.59,33.62,33.59,34.28,33.66,33.0,32.06,31.56,30.47,29.0,28.19,28.81,29.59,29.56,29.62,30.19,30.31,29.5,28.31,28.28,28.56,28.41,28.41,29.25,31.0,32.25,32.88,33.22,33.75,34.06,33.59,32.91,33.25,33.59,33.0,32.09,31.44,31.19,30.31,29.59,29.12,29.44,28.78,26.91,25.38,24.69,24.66,24.66,25.16,26.84,28.69,29.56,30.12,30.66,31.44,30.88,29.28,27.81,26.91,26.0,25.12,24.78,25.69,26.91,27.41,27.84,29.0,30.62,31.69,32.16,32.97,33.72,33.38,31.06,27.53,24.16,20.66,16.97,14.25,13.94,15.09,15.91,17.06,18.78,21.03,22.69,23.53,24.22,25.28,25.69,24.91,23.94,24.25,25.0,25.44,26.47,28.5,31.34,32.75,33.28,33.91,34.75,34.75,34.19,33.75,33.78,33.03,30.78,28.34,26.84,25.81,24.94,24.66,26.66,29.34,31.38,33.38,35.5,37.69,39.09,39.28,39.25,39.25,38.69,36.69,34.41,33.66,33.16,32.69,32.47,33.22,34.38,34.25,32.97,31.5,29.78,27.5,24.44,21.75,20.59,20.31,19.94,19.41,20.38,21.66,22.84,24.16,26.19,29.25,31.47,33.03,34.72,36.97,38.91,39.47,39.69,40.28,40.0,38.94,37.75,37.06,37.16,36.56,35.72,34.91,34.53,33.59,31.62,30.12,30.0,29.69,29.44,29.19,30.09,31.44,32.09,31.75,32.31,33.19,33.31,33.34,33.88,35.06,35.81,35.56,34.91,35.06,35.34,34.66,33.62,33.47,34.31,34.41,33.78,34.16,34.78,34.69,33.59,32.84,33.03,32.75,32.06,31.44,31.97,32.81,32.88,32.72,33.97,35.12,35.91,36.19,37.12,38.47,39.41,39.06,38.31,38.06,36.84,34.34,31.66,30.19,29.75,29.34,29.25,31.25,33.66,35.38,36.16,36.59,37.06,36.53,34.94,33.56,89.69,90.34,89.88,88.47,86.78,85.22,83.78,83.25,83.34,83.41,83.28,82.84,81.91,80.81,79.47,78.75,78.16,78.5,79.41,80.09,80.94:29.75,29.84,29.38,28.91,28.72,28.22,26.62,24.47,22.91,22.0,21.53,21.44,23.03,25.94,29.53,32.53,35.66,39.31,42.59,44.69,46.03,47.69,49.09,49.25,47.75,46.53,45.09,43.28,41.25,40.31,40.44,41.0,41.31,41.38,41.62,41.66,40.78,39.25,38.28,37.34,36.66,35.69,35.88,37.5,39.97,42.25,44.81,48.28,51.16,51.94,51.0,50.31,49.0,47.12,45.38,45.03,45.28,45.25,44.5,44.12,44.38,44.59,44.09,44.06,45.19,46.34,46.97,47.25,48.28,49.22,49.88,49.66,49.75,50.47,49.97,48.72,46.88,45.41,43.41,40.38,37.59,36.12,35.09,34.25,32.94,33.06,33.34,32.66,31.5,30.88,30.44,29.81,29.0,29.12,29.94,31.31,31.78,31.75,31.81,31.84,31.12,30.0,29.62,29.97,29.69,29.25,29.09,29.44,29.56,28.97,28.38,28.09,28.22,27.66,26.88,26.84,26.94,27.12,26.72,26.72,26.88,26.53,25.34,25.03,25.69,27.31,28.66,30.06,31.75,33.28,33.31,32.75,33.16,34.19,35.28,36.0,37.34,39.0,39.81,39.28,38.53,38.09,37.97,37.59,37.38,38.38,40.09,40.5,40.28,40.03,40.0,39.25,38.12,37.47,37.34,37.53,36.84,36.12,36.19,36.44,36.0,35.47,35.75,36.19,35.78,34.97,34.75,34.84,34.91,34.25,34.09,34.66,35.47,35.62,35.69,36.66,37.97,38.5,39.44,40.66,42.53,42.97,42.72,42.41,42.16,42.0,41.06,40.47,41.06,41.75,41.62,41.66,42.28,43.25,43.34,43.38,43.66,44.31,44.84,44.0,43.56,43.47,42.59,40.69,39.03,38.09,38.06,37.41,37.75,38.94,40.84,42.12,43.0,43.66,44.56,44.12,42.81,41.19,40.34,39.16,36.78,34.53,33.44,33.03,32.41,32.16,32.47,33.34,33.31,32.38,31.75,31.97,32.38,33.03,34.28,36.34,38.59,39.19,39.25,39.25,39.38,38.81,38.06,37.66,38.16,38.62,39.06,39.59,41.28,43.34,43.91,44.78,45.75,47.0,46.94,46.59,46.53,46.66,45.28,43.16,41.31,40.41,39.72,39.03,39.25,40.84,42.56,43.88,45.16,47.22,48.53,48.0,46.28,44.28,42.59,40.62,38.91,37.94,38.47,38.88,39.0,39.31,40.62,41.94,42.38,41.88,42.25,42.59,42.12,41.16,40.72,40.44,38.69,36.06,33.41,31.69,29.97,28.84,28.53,30.12,32.31,34.06,35.5,37.97,40.34,41.62,42.12,42.38,42.66,41.66,40.06,38.69,38.59,38.62,38.03,37.38,37.59,37.78,37.06,36.16,36.31,36.72,36.66,36.16,35.81,36.25,36.16,35.81,35.84,36.62,37.69,37.34,36.66,36.91,37.56,38.16,39.12,41.31,44.28,46.09,46.81,47.47,48.34,48.41,47.0,44.69,42.78,40.28,37.09,34.38,33.06,33.22,33.72,33.88,35.38,37.31,38.62,39.19,38.91,39.0,38.56,37.06,35.16,34.94,35.16,34.75,33.91,33.81,33.69,33.25,32.28,32.75,33.72,34.47,34.16,33.34,33.38,32.78,31.88,31.16,32.16,33.69,33.94,33.78,33.75,34.09,33.62,33.06,32.81,33.72,34.53,35.09,36.25,38.62,40.44,41.25,40.81,40.41,39.41,37.53,35.59,34.97,35.34,35.88,36.03,36.62,37.41,37.44,36.47,35.06,34.78,34.5,34.25,33.94,34.59,35.19,35.28,34.38,33.78,33.78,33.5,33.12,33.5,34.66,36.03,36.59,36.31,36.84,37.47,37.75,38.12,39.38,41.34,43.22,43.75,44.41,45.69,46.22,45.91,45.44,45.41,45.09,43.5,40.78,38.41,35.72,32.53,29.47,28.12,28.06,28.94,29.59,30.91,33.16,35.31,36.34,37.16,38.62,40.03,40.38,40.41,40.75,40.81,39.84,37.62,36.16,35.28,34.53,33.66,32.81,32.81,32.72,31.62,31.03,31.5,32.78,33.59,34.81,36.41,38.62,40.5,41.5,42.59,43.62,43.28,41.34,39.34,38.06,37.25,36.34,36.03,36.59,37.44,37.28,36.81,36.69,36.84,36.5,35.5,35.06,35.38,36.28,36.88,37.31,39.06,40.66,40.94,41.06,41.47,42.19,42.28,42.5,43.31,44.66,45.16,44.31,43.28,42.31,41.41,39.56,38.06,37.88,37.94,38.03,37.62,37.75,37.88,37.34,35.88,35.47,35.84,36.81,37.06,37.47,38.53,39.22,39.03,39.03,40.22,41.38,41.69,41.25,40.56,40.31,39.69,38.75,38.44,38.59,38.84,37.5,36.31,35.69,35.5,34.72,34.0,34.41,35.12,35.72,36.0,36.84,38.25,39.12,39.19,39.38,39.97,40.53,40.12,39.66,39.09,39.09,38.09,36.97,37.41,38.5,39.66,40.53,41.62,43.03,43.81,43.47,42.97,43.31,43.81,43.31,42.25,41.59,41.16,39.88,38.34,38.38,39.25,39.97,39.88,39.91,39.97,39.19,37.78,36.06,35.31,35.06,34.47,33.91,34.34,35.84,37.28,38.28,39.56,40.94,41.09,39.84,38.75,38.81,39.03,39.0,38.91,38.56,38.38,36.91,35.31,34.44,35.12,35.88,37.16,38.78,41.22,43.19,43.84,43.91,43.94,43.47,42.19,40.91,39.97,40.59,40.62,41.31,42.53,44.19,44.94,44.84,44.41,44.19,43.66,42.41,41.41,41.19,41.09,40.84,40.56,40.84,41.84,42.47,43.0,43.09,44.19,44.44,43.84,43.34,43.34,43.59,42.97,42.53,43.28,44.28,44.44,44.44,44.66,45.12,45.31,45.16,44.69,45.09,45.16,44.44,43.78,44.19,44.59,44.06,42.75,41.5,39.72,37.69,35.06,33.5,33.44,33.78,33.78,34.06,35.12,35.41,34.72,34.16,34.5,34.94,35.38,35.72,36.88,38.44,39.81,40.19,40.62,41.53,41.59,40.88,40.09,40.25,40.12,39.53,38.62,38.34,38.31,37.56,36.56,36.03,36.53,36.38,35.66,34.69,33.78,32.72,31.0,29.44,29.62,30.38,31.0,31.25,32.69,34.25,34.94,34.88,34.88,35.09,35.25,34.81,34.81,35.69,36.94,37.09,37.09,37.88,38.5,38.78,38.94,39.56,40.31,40.19,39.06,37.56,35.94,34.69,32.97,31.22,31.0,31.47,31.31,30.78,31.44,32.25,32.94,33.31,34.66,36.78,38.66,39.88,41.0,41.81,41.88,40.62,38.62,37.0,35.47,33.25,30.91,29.78,29.34,29.22,28.62,28.03,28.16,28.03,27.28,27.19,28.62,30.75,32.38,33.72,35.56,37.09,37.88,37.84,38.34,39.22,40.28,40.53,40.94,41.84,42.78,42.62,42.44,42.88,43.66,43.69,43.53,43.62,44.03,43.75,42.5,41.12,39.66,37.75,35.81,34.5,34.94,36.16,36.91,37.88,39.75,41.16,41.75,41.97,41.91,41.94,41.28,40.31,39.56,39.97,40.81,40.81,40.56,40.78,40.81,39.53,37.53,36.09,34.56,32.62,30.19,28.78,28.38,28.22,28.38,29.03,30.72,32.81,34.62,36.84,39.62,42.94,45.38,46.56,47.84,48.38,47.94,46.94,45.88,45.62,46.16,46.22,47.16,48.88,50.5,50.75,50.38,50.0,49.69,48.09,45.97,43.66,41.44,38.69,35.19,32.25,30.97,30.47,30.31,30.94,33.41,36.72,38.78,40.5,41.69,42.59,42.28,40.81,39.97,40.0,39.84,38.53,37.44,36.5,36.0,34.59,33.62,33.59,34.28,33.66,33.0,32.06,31.56,30.47,29.0,28.19,28.81,29.59,29.56,29.62,30.19,30.31,29.5,28.31,28.28,28.56,28.41,28.41,29.25,31.0,32.25,32.88,33.22,33.75,34.06,33.59,32.91,33.25,33.59,33.0,32.09,31.44,31.19,30.31,29.59,29.12,29.44,28.78,26.91,25.38,24.69,24.66,24.66,25.16,26.84,28.69,29.56,30.12,30.66,31.44,30.88,29.28,27.81,26.91,26.0,25.12,24.78,25.69,26.91,27.41,27.84,29.0,30.62,31.69,32.16,32.97,33.72,33.38,31.06,27.53,24.16,20.66,16.97,14.25,13.94,15.09,15.91,17.06,18.78,21.03,22.69,23.53,24.22,25.28,25.69,24.91,23.94,24.25,25.0,25.44,26.47,28.5,31.34,32.75,33.28,33.91,34.75,34.75,34.19,33.75,33.78,33.03,30.78,28.34,26.84,25.81,24.94,24.66,26.66,29.34,31.38,33.38,35.5,37.69,39.09,39.28,39.25,39.25,38.69,36.69,34.41,33.66,33.16,32.69,32.47,33.22,34.38,34.25,32.97,31.5,29.78,27.5,24.44,21.75,20.59,20.31,19.94,19.41,20.38,21.66,22.84,24.16,26.19,29.25,31.47,33.03,34.72,36.97,38.91,39.47,39.69,40.28,40.0,38.94,37.75,37.06,37.16,36.56,35.72,34.91,34.53,33.59,31.62,30.12,30.0,29.69,29.44,29.19,30.09,31.44,32.09,31.75,32.31,33.19,33.31,33.34,33.88,35.06,35.81,35.56,34.91,35.06,35.34,34.66,33.62,33.47,34.31,34.41,33.78,34.16,34.78,34.69,33.59,32.84,33.03,32.75,32.06,31.44,31.97,32.81,32.88,32.72,33.97,35.12,35.91,36.19,37.12,38.47,39.41,39.06,38.31,38.06,36.84,34.34,31.66,30.19,29.75,29.34,29.25,31.25,33.66,35.38,36.16,36.59,37.06,36.53,34.94,33.56,89.69,90.34,89.88,88.47,86.78,85.22,83.78,83.25,83.34,83.41,83.28,82.84,81.91,80.81,79.47,78.75,78.16,78.5,79.41,80.09,80.94,81.62,81.94,81.53,81.62,81.41,81.03,80.69:24.47,22.91,22.0,21.53,21.44,23.03,25.94,29.53,32.53,35.66,39.31,42.59,44.69,46.03,47.69,49.09,49.25,47.75,46.53,45.09,43.28,41.25,40.31,40.44,41.0,41.31,41.38,41.62,41.66,40.78,39.25,38.28,37.34,36.66,35.69,35.88,37.5,39.97,42.25,44.81,48.28,51.16,51.94,51.0,50.31,49.0,47.12,45.38,45.03,45.28,45.25,44.5,44.12,44.38,44.59,44.09,44.06,45.19,46.34,46.97,47.25,48.28,49.22,49.88,49.66,49.75,50.47,49.97,48.72,46.88,45.41,43.41,40.38,37.59,36.12,35.09,34.25,32.94,33.06,33.34,32.66,31.5,30.88,30.44,29.81,29.0,29.12,29.94,31.31,31.78,31.75,31.81,31.84,31.12,30.0,29.62,29.97,29.69,29.25,29.09,29.44,29.56,28.97,28.38,28.09,28.22,27.66,26.88,26.84,26.94,27.12,26.72,26.72,26.88,26.53,25.34,25.03,25.69,27.31,28.66,30.06,31.75,33.28,33.31,32.75,33.16,34.19,35.28,36.0,37.34,39.0,39.81,39.28,38.53,38.09,37.97,37.59,37.38,38.38,40.09,40.5,40.28,40.03,40.0,39.25,38.12,37.47,37.34,37.53,36.84,36.12,36.19,36.44,36.0,35.47,35.75,36.19,35.78,34.97,34.75,34.84,34.91,34.25,34.09,34.66,35.47,35.62,35.69,36.66,37.97,38.5,39.44,40.66,42.53,42.97,42.72,42.41,42.16,42.0,41.06,40.47,41.06,41.75,41.62,41.66,42.28,43.25,43.34,43.38,43.66,44.31,44.84,44.0,43.56,43.47,42.59,40.69,39.03,38.09,38.06,37.41,37.75,38.94,40.84,42.12,43.0,43.66,44.56,44.12,42.81,41.19,40.34,39.16,36.78,34.53,33.44,33.03,32.41,32.16,32.47,33.34,33.31,32.38,31.75,31.97,32.38,33.03,34.28,36.34,38.59,39.19,39.25,39.25,39.38,38.81,38.06,37.66,38.16,38.62,39.06,39.59,41.28,43.34,43.91,44.78,45.75,47.0,46.94,46.59,46.53,46.66,45.28,43.16,41.31,40.41,39.72,39.03,39.25,40.84,42.56,43.88,45.16,47.22,48.53,48.0,46.28,44.28,42.59,40.62,38.91,37.94,38.47,38.88,39.0,39.31,40.62,41.94,42.38,41.88,42.25,42.59,42.12,41.16,40.72,40.44,38.69,36.06,33.41,31.69,29.97,28.84,28.53,30.12,32.31,34.06,35.5,37.97,40.34,41.62,42.12,42.38,42.66,41.66,40.06,38.69,38.59,38.62,38.03,37.38,37.59,37.78,37.06,36.16,36.31,36.72,36.66,36.16,35.81,36.25,36.16,35.81,35.84,36.62,37.69,37.34,36.66,36.91,37.56,38.16,39.12,41.31,44.28,46.09,46.81,47.47,48.34,48.41,47.0,44.69,42.78,40.28,37.09,34.38,33.06,33.22,33.72,33.88,35.38,37.31,38.62,39.19,38.91,39.0,38.56,37.06,35.16,34.94,35.16,34.75,33.91,33.81,33.69,33.25,32.28,32.75,33.72,34.47,34.16,33.34,33.38,32.78,31.88,31.16,32.16,33.69,33.94,33.78,33.75,34.09,33.62,33.06,32.81,33.72,34.53,35.09,36.25,38.62,40.44,41.25,40.81,40.41,39.41,37.53,35.59,34.97,35.34,35.88,36.03,36.62,37.41,37.44,36.47,35.06,34.78,34.5,34.25,33.94,34.59,35.19,35.28,34.38,33.78,33.78,33.5,33.12,33.5,34.66,36.03,36.59,36.31,36.84,37.47,37.75,38.12,39.38,41.34,43.22,43.75,44.41,45.69,46.22,45.91,45.44,45.41,45.09,43.5,40.78,38.41,35.72,32.53,29.47,28.12,28.06,28.94,29.59,30.91,33.16,35.31,36.34,37.16,38.62,40.03,40.38,40.41,40.75,40.81,39.84,37.62,36.16,35.28,34.53,33.66,32.81,32.81,32.72,31.62,31.03,31.5,32.78,33.59,34.81,36.41,38.62,40.5,41.5,42.59,43.62,43.28,41.34,39.34,38.06,37.25,36.34,36.03,36.59,37.44,37.28,36.81,36.69,36.84,36.5,35.5,35.06,35.38,36.28,36.88,37.31,39.06,40.66,40.94,41.06,41.47,42.19,42.28,42.5,43.31,44.66,45.16,44.31,43.28,42.31,41.41,39.56,38.06,37.88,37.94,38.03,37.62,37.75,37.88,37.34,35.88,35.47,35.84,36.81,37.06,37.47,38.53,39.22,39.03,39.03,40.22,41.38,41.69,41.25,40.56,40.31,39.69,38.75,38.44,38.59,38.84,37.5,36.31,35.69,35.5,34.72,34.0,34.41,35.12,35.72,36.0,36.84,38.25,39.12,39.19,39.38,39.97,40.53,40.12,39.66,39.09,39.09,38.09,36.97,37.41,38.5,39.66,40.53,41.62,43.03,43.81,43.47,42.97,43.31,43.81,43.31,42.25,41.59,41.16,39.88,38.34,38.38,39.25,39.97,39.88,39.91,39.97,39.19,37.78,36.06,35.31,35.06,34.47,33.91,34.34,35.84,37.28,38.28,39.56,40.94,41.09,39.84,38.75,38.81,39.03,39.0,38.91,38.56,38.38,36.91,35.31,34.44,35.12,35.88,37.16,38.78,41.22,43.19,43.84,43.91,43.94,43.47,42.19,40.91,39.97,40.59,40.62,41.31,42.53,44.19,44.94,44.84,44.41,44.19,43.66,42.41,41.41,41.19,41.09,40.84,40.56,40.84,41.84,42.47,43.0,43.09,44.19,44.44,43.84,43.34,43.34,43.59,42.97,42.53,43.28,44.28,44.44,44.44,44.66,45.12,45.31,45.16,44.69,45.09,45.16,44.44,43.78,44.19,44.59,44.06,42.75,41.5,39.72,37.69,35.06,33.5,33.44,33.78,33.78,34.06,35.12,35.41,34.72,34.16,34.5,34.94,35.38,35.72,36.88,38.44,39.81,40.19,40.62,41.53,41.59,40.88,40.09,40.25,40.12,39.53,38.62,38.34,38.31,37.56,36.56,36.03,36.53,36.38,35.66,34.69,33.78,32.72,31.0,29.44,29.62,30.38,31.0,31.25,32.69,34.25,34.94,34.88,34.88,35.09,35.25,34.81,34.81,35.69,36.94,37.09,37.09,37.88,38.5,38.78,38.94,39.56,40.31,40.19,39.06,37.56,35.94,34.69,32.97,31.22,31.0,31.47,31.31,30.78,31.44,32.25,32.94,33.31,34.66,36.78,38.66,39.88,41.0,41.81,41.88,40.62,38.62,37.0,35.47,33.25,30.91,29.78,29.34,29.22,28.62,28.03,28.16,28.03,27.28,27.19,28.62,30.75,32.38,33.72,35.56,37.09,37.88,37.84,38.34,39.22,40.28,40.53,40.94,41.84,42.78,42.62,42.44,42.88,43.66,43.69,43.53,43.62,44.03,43.75,42.5,41.12,39.66,37.75,35.81,34.5,34.94,36.16,36.91,37.88,39.75,41.16,41.75,41.97,41.91,41.94,41.28,40.31,39.56,39.97,40.81,40.81,40.56,40.78,40.81,39.53,37.53,36.09,34.56,32.62,30.19,28.78,28.38,28.22,28.38,29.03,30.72,32.81,34.62,36.84,39.62,42.94,45.38,46.56,47.84,48.38,47.94,46.94,45.88,45.62,46.16,46.22,47.16,48.88,50.5,50.75,50.38,50.0,49.69,48.09,45.97,43.66,41.44,38.69,35.19,32.25,30.97,30.47,30.31,30.94,33.41,36.72,38.78,40.5,41.69,42.59,42.28,40.81,39.97,40.0,39.84,38.53,37.44,36.5,36.0,34.59,33.62,33.59,34.28,33.66,33.0,32.06,31.56,30.47,29.0,28.19,28.81,29.59,29.56,29.62,30.19,30.31,29.5,28.31,28.28,28.56,28.41,28.41,29.25,31.0,32.25,32.88,33.22,33.75,34.06,33.59,32.91,33.25,33.59,33.0,32.09,31.44,31.19,30.31,29.59,29.12,29.44,28.78,26.91,25.38,24.69,24.66,24.66,25.16,26.84,28.69,29.56,30.12,30.66,31.44,30.88,29.28,27.81,26.91,26.0,25.12,24.78,25.69,26.91,27.41,27.84,29.0,30.62,31.69,32.16,32.97,33.72,33.38,31.06,27.53,24.16,20.66,16.97,14.25,13.94,15.09,15.91,17.06,18.78,21.03,22.69,23.53,24.22,25.28,25.69,24.91,23.94,24.25,25.0,25.44,26.47,28.5,31.34,32.75,33.28,33.91,34.75,34.75,34.19,33.75,33.78,33.03,30.78,28.34,26.84,25.81,24.94,24.66,26.66,29.34,31.38,33.38,35.5,37.69,39.09,39.28,39.25,39.25,38.69,36.69,34.41,33.66,33.16,32.69,32.47,33.22,34.38,34.25,32.97,31.5,29.78,27.5,24.44,21.75,20.59,20.31,19.94,19.41,20.38,21.66,22.84,24.16,26.19,29.25,31.47,33.03,34.72,36.97,38.91,39.47,39.69,40.28,40.0,38.94,37.75,37.06,37.16,36.56,35.72,34.91,34.53,33.59,31.62,30.12,30.0,29.69,29.44,29.19,30.09,31.44,32.09,31.75,32.31,33.19,33.31,33.34,33.88,35.06,35.81,35.56,34.91,35.06,35.34,34.66,33.62,33.47,34.31,34.41,33.78,34.16,34.78,34.69,33.59,32.84,33.03,32.75,32.06,31.44,31.97,32.81,32.88,32.72,33.97,35.12,35.91,36.19,37.12,38.47,39.41,39.06,38.31,38.06,36.84,34.34,31.66,30.19,29.75,29.34,29.25,31.25,33.66,35.38,36.16,36.59,37.06,36.53,34.94,33.56,89.69,90.34,89.88,88.47,86.78,85.22,83.78,83.25,83.34,83.41,83.28,82.84,81.91,80.81,79.47,78.75,78.16,78.5,79.41,80.09,80.94,81.62,81.94,81.53,81.62,81.41,81.03,80.69,80.78,80.81,81.25,81.34,81.31,80.75,79.5:29.53,32.53,35.66,39.31,42.59,44.69,46.03,47.69,49.09,49.25,47.75,46.53,45.09,43.28,41.25,40.31,40.44,41.0,41.31,41.38,41.62,41.66,40.78,39.25,38.28,37.34,36.66,35.69,35.88,37.5,39.97,42.25,44.81,48.28,51.16,51.94,51.0,50.31,49.0,47.12,45.38,45.03,45.28,45.25,44.5,44.12,44.38,44.59,44.09,44.06,45.19,46.34,46.97,47.25,48.28,49.22,49.88,49.66,49.75,50.47,49.97,48.72,46.88,45.41,43.41,40.38,37.59,36.12,35.09,34.25,32.94,33.06,33.34,32.66,31.5,30.88,30.44,29.81,29.0,29.12,29.94,31.31,31.78,31.75,31.81,31.84,31.12,30.0,29.62,29.97,29.69,29.25,29.09,29.44,29.56,28.97,28.38,28.09,28.22,27.66,26.88,26.84,26.94,27.12,26.72,26.72,26.88,26.53,25.34,25.03,25.69,27.31,28.66,30.06,31.75,33.28,33.31,32.75,33.16,34.19,35.28,36.0,37.34,39.0,39.81,39.28,38.53,38.09,37.97,37.59,37.38,38.38,40.09,40.5,40.28,40.03,40.0,39.25,38.12,37.47,37.34,37.53,36.84,36.12,36.19,36.44,36.0,35.47,35.75,36.19,35.78,34.97,34.75,34.84,34.91,34.25,34.09,34.66,35.47,35.62,35.69,36.66,37.97,38.5,39.44,40.66,42.53,42.97,42.72,42.41,42.16,42.0,41.06,40.47,41.06,41.75,41.62,41.66,42.28,43.25,43.34,43.38,43.66,44.31,44.84,44.0,43.56,43.47,42.59,40.69,39.03,38.09,38.06,37.41,37.75,38.94,40.84,42.12,43.0,43.66,44.56,44.12,42.81,41.19,40.34,39.16,36.78,34.53,33.44,33.03,32.41,32.16,32.47,33.34,33.31,32.38,31.75,31.97,32.38,33.03,34.28,36.34,38.59,39.19,39.25,39.25,39.38,38.81,38.06,37.66,38.16,38.62,39.06,39.59,41.28,43.34,43.91,44.78,45.75,47.0,46.94,46.59,46.53,46.66,45.28,43.16,41.31,40.41,39.72,39.03,39.25,40.84,42.56,43.88,45.16,47.22,48.53,48.0,46.28,44.28,42.59,40.62,38.91,37.94,38.47,38.88,39.0,39.31,40.62,41.94,42.38,41.88,42.25,42.59,42.12,41.16,40.72,40.44,38.69,36.06,33.41,31.69,29.97,28.84,28.53,30.12,32.31,34.06,35.5,37.97,40.34,41.62,42.12,42.38,42.66,41.66,40.06,38.69,38.59,38.62,38.03,37.38,37.59,37.78,37.06,36.16,36.31,36.72,36.66,36.16,35.81,36.25,36.16,35.81,35.84,36.62,37.69,37.34,36.66,36.91,37.56,38.16,39.12,41.31,44.28,46.09,46.81,47.47,48.34,48.41,47.0,44.69,42.78,40.28,37.09,34.38,33.06,33.22,33.72,33.88,35.38,37.31,38.62,39.19,38.91,39.0,38.56,37.06,35.16,34.94,35.16,34.75,33.91,33.81,33.69,33.25,32.28,32.75,33.72,34.47,34.16,33.34,33.38,32.78,31.88,31.16,32.16,33.69,33.94,33.78,33.75,34.09,33.62,33.06,32.81,33.72,34.53,35.09,36.25,38.62,40.44,41.25,40.81,40.41,39.41,37.53,35.59,34.97,35.34,35.88,36.03,36.62,37.41,37.44,36.47,35.06,34.78,34.5,34.25,33.94,34.59,35.19,35.28,34.38,33.78,33.78,33.5,33.12,33.5,34.66,36.03,36.59,36.31,36.84,37.47,37.75,38.12,39.38,41.34,43.22,43.75,44.41,45.69,46.22,45.91,45.44,45.41,45.09,43.5,40.78,38.41,35.72,32.53,29.47,28.12,28.06,28.94,29.59,30.91,33.16,35.31,36.34,37.16,38.62,40.03,40.38,40.41,40.75,40.81,39.84,37.62,36.16,35.28,34.53,33.66,32.81,32.81,32.72,31.62,31.03,31.5,32.78,33.59,34.81,36.41,38.62,40.5,41.5,42.59,43.62,43.28,41.34,39.34,38.06,37.25,36.34,36.03,36.59,37.44,37.28,36.81,36.69,36.84,36.5,35.5,35.06,35.38,36.28,36.88,37.31,39.06,40.66,40.94,41.06,41.47,42.19,42.28,42.5,43.31,44.66,45.16,44.31,43.28,42.31,41.41,39.56,38.06,37.88,37.94,38.03,37.62,37.75,37.88,37.34,35.88,35.47,35.84,36.81,37.06,37.47,38.53,39.22,39.03,39.03,40.22,41.38,41.69,41.25,40.56,40.31,39.69,38.75,38.44,38.59,38.84,37.5,36.31,35.69,35.5,34.72,34.0,34.41,35.12,35.72,36.0,36.84,38.25,39.12,39.19,39.38,39.97,40.53,40.12,39.66,39.09,39.09,38.09,36.97,37.41,38.5,39.66,40.53,41.62,43.03,43.81,43.47,42.97,43.31,43.81,43.31,42.25,41.59,41.16,39.88,38.34,38.38,39.25,39.97,39.88,39.91,39.97,39.19,37.78,36.06,35.31,35.06,34.47,33.91,34.34,35.84,37.28,38.28,39.56,40.94,41.09,39.84,38.75,38.81,39.03,39.0,38.91,38.56,38.38,36.91,35.31,34.44,35.12,35.88,37.16,38.78,41.22,43.19,43.84,43.91,43.94,43.47,42.19,40.91,39.97,40.59,40.62,41.31,42.53,44.19,44.94,44.84,44.41,44.19,43.66,42.41,41.41,41.19,41.09,40.84,40.56,40.84,41.84,42.47,43.0,43.09,44.19,44.44,43.84,43.34,43.34,43.59,42.97,42.53,43.28,44.28,44.44,44.44,44.66,45.12,45.31,45.16,44.69,45.09,45.16,44.44,43.78,44.19,44.59,44.06,42.75,41.5,39.72,37.69,35.06,33.5,33.44,33.78,33.78,34.06,35.12,35.41,34.72,34.16,34.5,34.94,35.38,35.72,36.88,38.44,39.81,40.19,40.62,41.53,41.59,40.88,40.09,40.25,40.12,39.53,38.62,38.34,38.31,37.56,36.56,36.03,36.53,36.38,35.66,34.69,33.78,32.72,31.0,29.44,29.62,30.38,31.0,31.25,32.69,34.25,34.94,34.88,34.88,35.09,35.25,34.81,34.81,35.69,36.94,37.09,37.09,37.88,38.5,38.78,38.94,39.56,40.31,40.19,39.06,37.56,35.94,34.69,32.97,31.22,31.0,31.47,31.31,30.78,31.44,32.25,32.94,33.31,34.66,36.78,38.66,39.88,41.0,41.81,41.88,40.62,38.62,37.0,35.47,33.25,30.91,29.78,29.34,29.22,28.62,28.03,28.16,28.03,27.28,27.19,28.62,30.75,32.38,33.72,35.56,37.09,37.88,37.84,38.34,39.22,40.28,40.53,40.94,41.84,42.78,42.62,42.44,42.88,43.66,43.69,43.53,43.62,44.03,43.75,42.5,41.12,39.66,37.75,35.81,34.5,34.94,36.16,36.91,37.88,39.75,41.16,41.75,41.97,41.91,41.94,41.28,40.31,39.56,39.97,40.81,40.81,40.56,40.78,40.81,39.53,37.53,36.09,34.56,32.62,30.19,28.78,28.38,28.22,28.38,29.03,30.72,32.81,34.62,36.84,39.62,42.94,45.38,46.56,47.84,48.38,47.94,46.94,45.88,45.62,46.16,46.22,47.16,48.88,50.5,50.75,50.38,50.0,49.69,48.09,45.97,43.66,41.44,38.69,35.19,32.25,30.97,30.47,30.31,30.94,33.41,36.72,38.78,40.5,41.69,42.59,42.28,40.81,39.97,40.0,39.84,38.53,37.44,36.5,36.0,34.59,33.62,33.59,34.28,33.66,33.0,32.06,31.56,30.47,29.0,28.19,28.81,29.59,29.56,29.62,30.19,30.31,29.5,28.31,28.28,28.56,28.41,28.41,29.25,31.0,32.25,32.88,33.22,33.75,34.06,33.59,32.91,33.25,33.59,33.0,32.09,31.44,31.19,30.31,29.59,29.12,29.44,28.78,26.91,25.38,24.69,24.66,24.66,25.16,26.84,28.69,29.56,30.12,30.66,31.44,30.88,29.28,27.81,26.91,26.0,25.12,24.78,25.69,26.91,27.41,27.84,29.0,30.62,31.69,32.16,32.97,33.72,33.38,31.06,27.53,24.16,20.66,16.97,14.25,13.94,15.09,15.91,17.06,18.78,21.03,22.69,23.53,24.22,25.28,25.69,24.91,23.94,24.25,25.0,25.44,26.47,28.5,31.34,32.75,33.28,33.91,34.75,34.75,34.19,33.75,33.78,33.03,30.78,28.34,26.84,25.81,24.94,24.66,26.66,29.34,31.38,33.38,35.5,37.69,39.09,39.28,39.25,39.25,38.69,36.69,34.41,33.66,33.16,32.69,32.47,33.22,34.38,34.25,32.97,31.5,29.78,27.5,24.44,21.75,20.59,20.31,19.94,19.41,20.38,21.66,22.84,24.16,26.19,29.25,31.47,33.03,34.72,36.97,38.91,39.47,39.69,40.28,40.0,38.94,37.75,37.06,37.16,36.56,35.72,34.91,34.53,33.59,31.62,30.12,30.0,29.69,29.44,29.19,30.09,31.44,32.09,31.75,32.31,33.19,33.31,33.34,33.88,35.06,35.81,35.56,34.91,35.06,35.34,34.66,33.62,33.47,34.31,34.41,33.78,34.16,34.78,34.69,33.59,32.84,33.03,32.75,32.06,31.44,31.97,32.81,32.88,32.72,33.97,35.12,35.91,36.19,37.12,38.47,39.41,39.06,38.31,38.06,36.84,34.34,31.66,30.19,29.75,29.34,29.25,31.25,33.66,35.38,36.16,36.59,37.06,36.53,34.94,33.56,89.69,90.34,89.88,88.47,86.78,85.22,83.78,83.25,83.34,83.41,83.28,82.84,81.91,80.81,79.47,78.75,78.16,78.5,79.41,80.09,80.94,81.62,81.94,81.53,81.62,81.41,81.03,80.69,80.78,80.81,81.25,81.34,81.31,80.75,79.5,77.91,75.78,74.16,73.06,72.75,73.38,74.72:negativity
7.69,8.41,7.16,6.12,7.94,10.22,10.06,8.88,8.72,9.47,8.44,6.06,5.62,7.53,8.59,7.78,6.94,9.03,10.12,9.0,7.44,8.47,10.0,9.5,8.19,9.22,11.34,11.94,10.59,10.28,11.56,11.5,9.06,7.34,8.34,8.91,7.19,4.72,4.72,4.88,3.16,1.09,1.28,3.38,4.69,4.72,5.94,9.28,11.53,10.94,10.78,12.84,14.53,14.53,13.62,14.53,15.38,13.94,10.66,9.41,10.28,10.19,8.69,8.59,10.25,11.0,9.47,7.81,8.69,9.19,8.03,6.28,7.62,10.0,10.56,10.12,10.56,11.88,11.31,8.31,6.56,6.69,6.31,4.19,3.06,5.12,8.03,9.38,9.75,12.44,15.31,16.31,16.34,17.88,20.41,21.75,21.16,20.81,22.62,23.72,22.38,21.09,21.88,22.25,20.03,16.78,15.88,16.19,15.5,14.06,14.28,16.16,16.56,14.62,13.47,14.28,15.12,13.78,13.06,14.69,16.09,15.34,12.75,11.78,11.72,10.59,8.62,8.75,11.06,12.56,12.16,11.84,13.22,14.09,12.47,10.66,11.53,13.0,12.47,10.59,10.78,11.5,10.84,8.59,8.56,10.66,12.84,13.38,15.22,19.19,22.44,22.78,22.38,23.66,24.47,23.84,22.06,22.47,24.34,25.16,23.88,23.5,24.06,23.47,20.19,17.09,16.69,16.88,15.5,14.12,15.75,17.59,17.59,16.22,16.47,17.78,18.16,16.56,16.22,18.03,19.03,17.25,16.06,16.62,16.88,14.59,11.53,11.22,12.03,11.44,9.97,10.59,11.75,11.78,9.94,9.62,11.34,12.78,12.38,12.75,15.5,18.28,18.53,17.78,18.12,18.59,16.91,13.38,11.97,11.91,11.0,8.66,7.84,9.25,10.47,9.47,8.84,10.56,12.78,12.59,12.12,13.72,16.09,16.41,15.09,15.31,16.72,16.66,14.22,12.66,12.41,11.53,8.28,5.78,6.19,7.59,7.62,7.12,9.03,11.59,12.28,11.31,11.97,13.81,14.78,13.91,14.12,16.69,18.56,18.41,17.97,19.69,20.78,19.28,16.47,15.25,15.12,13.75,11.38,11.44,13.53,14.84,13.69,12.91,13.81,14.0,12.06,10.19,11.09,12.84,12.69,11.81,12.75,14.12,13.94,12.03,11.78,12.88,13.69,12.03,10.88,11.78,12.56,10.72,9.12,9.53,10.44,9.84,8.53,9.25,11.56,12.5,11.88,12.09,13.91,15.19,13.41,12.41,13.16,13.78,12.19,10.62,11.5,13.62,13.75,13.06,14.28,16.66,17.62,16.88,17.38,19.28,20.12,18.34,16.62,17.25,17.91,15.91,14.12,14.59,15.78,14.88,13.12,13.25,14.03,13.88,12.03,11.53,12.81,14.25,13.75,13.84,16.03,18.25,17.72,16.31,16.94,17.81,17.34,15.31,15.09,15.72,14.91,12.0,10.34,10.94,11.69,10.59,10.56,12.72,15.12,15.38,14.5,15.56,17.25,16.78,15.12,14.66,15.66,15.44,12.75,11.28,12.03,12.62,10.78,9.34,10.12,11.0,9.81,8.59,9.75,12.03,12.69,11.38,11.91,13.34,14.19,12.81,12.25,13.47,14.06,12.03,9.94,9.84,10.22,8.56,6.66,7.09,8.88,9.53,8.97,9.41,11.56,12.0,10.09,8.84,10.0,11.09,9.81,8.69,9.47,11.03,9.78,7.78,7.78,8.41,7.5,5.31,4.69,6.0,6.62,5.56,5.75,8.31,10.41,9.91,9.16,10.28,12.16,12.28,12.34,14.31,16.72,17.25,15.69,15.03,15.72,15.75,13.41,11.91,12.5,13.38,12.44,11.72,12.88,15.0,15.34,14.78,15.91,18.38,19.03,17.25,16.41,17.59,17.81,16.25,15.72,17.62,19.94,19.66,19.44,21.09,23.56,24.09,23.66,24.94,27.25,28.06,26.47,25.12,25.0,23.75,20.31,18.06,18.22,19.22,18.06,16.47,16.81,17.53,16.53,15.44,16.72,19.97,22.59,23.25,24.34,26.28,27.38,25.84,24.47,24.81,25.5,23.72,21.69,21.59,22.81,22.47,21.16,21.31,23.0,23.41,22.12,21.59,23.44,24.44,22.5,20.81,20.88,21.38,20.03,19.03,19.91,22.19,22.62,21.94,22.44,24.12,24.66,22.94,22.03,22.84,23.0,20.72,18.53,18.56,19.41,18.78,17.78,18.5,20.19,20.38,18.62,18.47,19.72,20.47,19.31,18.56,19.72,20.47,18.72,16.81,17.12,17.97,16.62,14.81,14.53,15.59,14.94,13.25,12.94,14.0,14.16,12.62,11.97,13.62,15.69,15.75,15.34,17.19,19.28,19.0,18.28,19.25,22.22,23.78,23.38,23.56,24.62,24.0,20.81,18.25,18.19,18.78,17.56,16.72,18.19,20.03,19.91,18.44,18.38,19.47,18.97,16.5,14.94,15.38,15.06,12.78,11.78,13.53,15.53,15.31,14.69,15.47,16.78,15.88,13.91,13.25,14.25,13.75,11.62,11.06,12.88,14.56,14.28,14.47,16.47,18.0,16.75,14.72,14.06,14.53,13.47,11.66,11.66,13.06,13.09,11.06,9.97,11.12,11.56,10.19,9.38,10.84,12.5,12.41,11.53,12.69,14.03,13.38,11.53,10.81,11.44,11.25,9.91,9.66,11.62,13.62,13.38,12.66,13.88,15.31,14.69,13.75,15.28,17.56,18.69,18.06,18.28,20.12,20.53,19.59,19.25,20.88,22.12,20.56,18.84,18.66,18.84,17.5,15.78,16.28,18.09,18.12,16.97,17.66,20.06,21.56,21.47,21.62,23.28,24.06,21.69,19.06,18.34,17.66,15.0,11.97,10.88,10.97,10.16,8.5,8.25,10.16,11.41,11.03,11.59,14.94,17.53,18.34,18.97,20.56,22.94,22.97,22.44,23.62,25.88,26.66,25.53,25.19,26.19,26.22,24.38,23.12,23.81,24.38,22.53,19.69,18.53,17.66,14.88,11.69,10.47,11.34,11.81,11.19,12.12,14.72,16.28,15.59,14.53,15.56,16.53,15.16,13.56,14.31,15.97,16.5,16.06,17.25,19.31,19.75,18.31,17.31,17.88,17.31,14.31,11.19,10.5,10.25,8.56,6.84,6.78,7.22,5.56,2.16,0.62,1.16,1.88,1.66,3.22,7.28,10.47,11.44,12.03,14.84,17.56,17.84,17.53,18.75,21.19,22.25,22.0,22.75,24.41,23.69,20.59,17.97,17.91,17.84,16.56,15.09,16.34,17.44,16.38,14.72,14.94,17.19,17.94,17.69,18.94,21.53,22.91,21.44,20.25,20.66,20.34,17.81,15.69,16.12,17.56,17.38,16.34,16.38,17.31,16.0,13.06,11.5,12.28,12.66,11.47,11.47,13.5,15.34,15.16,14.66,16.5,18.69,19.16,18.28,19.28,20.78,20.38,18.03,16.5,16.19,15.19,12.25,10.28,10.69,11.28,9.81,8.59,9.88,12.03,12.84,12.62,13.88,15.66,15.38,13.09,12.28,13.91,15.41,15.03,14.94,15.88,15.41,12.16,8.41,7.09,7.69,7.84,7.25,9.0,12.0,13.22,12.25,11.62,12.72,13.19,11.91,11.59,14.22,16.78,17.16,16.62,17.44,18.34,17.06,14.06,12.0,10.78,8.84,5.75,4.34,5.44,6.56,6.47,7.03,10.31,13.88,15.5,15.78,17.47,19.34,19.28,17.97,18.09,19.59,20.38,18.88,17.91,18.75,18.91,16.56,13.84,13.5,12.91,10.53,7.44,7.03,7.91,7.75,6.38,6.88,8.78,9.59,9.03,9.56,12.59,15.5,16.69,17.59,20.66,23.28,22.97,21.38,21.28,21.75,20.59,18.03,16.5,16.22,14.84,11.22,8.53,8.94,9.84,9.38,9.53,11.91,14.47,14.28,12.66,12.81,13.62,13.53,12.25,12.5,14.72,16.59,16.28,16.47,18.25,18.94,16.59,12.62,11.16,9.66,6.56,3.28,2.16,2.47,1.94,0.69,1.19,3.53,4.97,4.31,3.78,5.41,6.62,5.72,4.22,5.66,7.5,7.62,7.09,8.81,10.91,11.88,10.5,10.0,10.94,11.28,9.75,8.47,9.88,11.41,10.97,10.25,11.91,13.53,12.75,9.94,8.44,8.44,7.5,5.47,5.0,6.59,7.56,6.69,6.25,8.69,11.06,11.41,10.62,11.56,12.34,10.88,7.47,5.5,4.62,3.28,0.81,0.16,2.25,4.44,5.0,5.41,7.97,9.75,9.16,7.28,7.38,8.25,7.94,6.56,6.88,8.66,9.31,7.81,6.81,7.53,7.97,6.44,4.81,6.22,8.0,7.47,6.06,6.56,7.88,7.31,5.72,6.0,8.0,9.22,8.31,7.84,9.16,9.44,7.31,4.91,4.44,4.47,3.12,1.53,2.31,4.81,5.91,5.41,5.75,7.34,7.47,5.34,3.41,3.44,3.44,1.47,0.03,1.41,3.62,4.62,4.88,7.25,10.69,12.16,12.25,13.28,15.62,16.84,15.97,15.66,17.34,18.84,18.28,17.16,18.38,19.78,19.12,17.16,16.88,17.75,17.44,16.38,16.41,18.41,19.28,17.84,16.28,16.84,17.44,15.72,13.72,13.69,13.75,11.75,8.44,6.44,5.56,3.34,0.22,-0.31,2.03,4.62,5.25,5.47,6.78,6.53,2.78,-1.59,-4.41,-5.97,-8.69,-11.75,-12.69,-11.47,-10.81,-11.56,-10.88,-7.78,-5.5,-5.56,-5.25,-3.06,-0.03,1.19,2.81,6.78,11.97,14.72,15.25,16.41,16.91,15.12,10.16,5.38,2.22,-1.47,-7.34,-12.69,-15.06,-16.41,-18.84,-20.66,-19.12,-15.28,-12.31,-9.62,-4.84,1.47,6.69,9.22,11.56,14.34,15.66,13.31,10.31,9.19,8.16,4.94,1.19,-0.78,-1.75,-4.47,-7.66,-8.69,-7.47,-6.09:8.88,8.72,9.47,8.44,6.06,5.62,7.53,8.59,7.78,6.94,9.03,10.12,9.0,7.44,8.47,10.0,9.5,8.19,9.22,11.34,11.94,10.59,10.28,11.56,11.5,9.06,7.34,8.34,8.91,7.19,4.72,4.72,4.88,3.16,1.09,1.28,3.38,4.69,4.72,5.94,9.28,11.53,10.94,10.78,12.84,14.53,14.53,13.62,14.53,15.38,13.94,10.66,9.41,10.28,10.19,8.69,8.59,10.25,11.0,9.47,7.81,8.69,9.19,8.03,6.28,7.62,10.0,10.56,10.12,10.56,11.88,11.31,8.31,6.56,6.69,6.31,4.19,3.06,5.12,8.03,9.38,9.75,12.44,15.31,16.31,16.34,17.88,20.41,21.75,21.16,20.81,22.62,23.72,22.38,21.09,21.88,22.25,20.03,16.78,15.88,16.19,15.5,14.06,14.28,16.16,16.56,14.62,13.47,14.28,15.12,13.78,13.06,14.69,16.09,15.34,12.75,11.78,11.72,10.59,8.62,8.75,11.06,12.56,12.16,11.84,13.22,14.09,12.47,10.66,11.53,13.0,12.47,10.59,10.78,11.5,10.84,8.59,8.56,10.66,12.84,13.38,15.22,19.19,22.44,22.78,22.38,23.66,24.47,23.84,22.06,22.47,24.34,25.16,23.88,23.5,24.06,23.47,20.19,17.09,16.69,16.88,15.5,14.12,15.75,17.59,17.59,16.22,16.47,17.78,18.16,16.56,16.22,18.03,19.03,17.25,16.06,16.62,16.88,14.59,11.53,11.22,12.03,11.44,9.97,10.59,11.75,11.78,9.94,9.62,11.34,12.78,12.38,12.75,15.5,18.28,18.53,17.78,18.12,18.59,16.91,13.38,11.97,11.91,11.0,8.66,7.84,9.25,10.47,9.47,8.84,10.56,12.78,12.59,12.12,13.72,16.09,16.41,15.09,15.31,16.72,16.66,14.22,12.66,12.41,11.53,8.28,5.78,6.19,7.59,7.62,7.12,9.03,11.59,12.28,11.31,11.97,13.81,14.78,13.91,14.12,16.69,18.56,18.41,17.97,19.69,20.78,19.28,16.47,15.25,15.12,13.75,11.38,11.44,13.53,14.84,13.69,12.91,13.81,14.0,12.06,10.19,11.09,12.84,12.69,11.81,12.75,14.12,13.94,12.03,11.78,12.88,13.69,12.03,10.88,11.78,12.56,10.72,9.12,9.53,10.44,9.84,8.53,9.25,11.56,12.5,11.88,12.09,13.91,15.19,13.41,12.41,13.16,13.78,12.19,10.62,11.5,13.62,13.75,13.06,14.28,16.66,17.62,16.88,17.38,19.28,20.12,18.34,16.62,17.25,17.91,15.91,14.12,14.59,15.78,14.88,13.12,13.25,14.03,13.88,12.03,11.53,12.81,14.25,13.75,13.84,16.03,18.25,17.72,16.31,16.94,17.81,17.34,15.31,15.09,15.72,14.91,12.0,10.34,10.94,11.69,10.59,10.56,12.72,15.12,15.38,14.5,15.56,17.25,16.78,15.12,14.66,15.66,15.44,12.75,11.28,12.03,12.62,10.78,9.34,10.12,11.0,9.81,8.59,9.75,12.03,12.69,11.38,11.91,13.34,14.19,12.81,12.25,13.47,14.06,12.03,9.94,9.84,10.22,8.56,6.66,7.09,8.88,9.53,8.97,9.41,11.56,12.0,10.09,8.84,10.0,11.09,9.81,8.69,9.47,11.03,9.78,7.78,7.78,8.41,7.5,5.31,4.69,6.0,6.62,5.56,5.75,8.31,10.41,9.91,9.16,10.28,12.16,12.28,12.34,14.31,16.72,17.25,15.69,15.03,15.72,15.75,13.41,11.91,12.5,13.38,12.44,11.72,12.88,15.0,15.34,14.78,15.91,18.38,19.03,17.25,16.41,17.59,17.81,16.25,15.72,17.62,19.94,19.66,19.44,21.09,23.56,24.09,23.66,24.94,27.25,28.06,26.47,25.12,25.0,23.75,20.31,18.06,18.22,19.22,18.06,16.47,16.81,17.53,16.53,15.44,16.72,19.97,22.59,23.25,24.34,26.28,27.38,25.84,24.47,24.81,25.5,23.72,21.69,21.59,22.81,22.47,21.16,21.31,23.0,23.41,22.12,21.59,23.44,24.44,22.5,20.81,20.88,21.38,20.03,19.03,19.91,22.19,22.62,21.94,22.44,24.12,24.66,22.94,22.03,22.84,23.0,20.72,18.53,18.56,19.41,18.78,17.78,18.5,20.19,20.38,18.62,18.47,19.72,20.47,19.31,18.56,19.72,20.47,18.72,16.81,17.12,17.97,16.62,14.81,14.53,15.59,14.94,13.25,12.94,14.0,14.16,12.62,11.97,13.62,15.69,15.75,15.34,17.19,19.28,19.0,18.28,19.25,22.22,23.78,23.38,23.56,24.62,24.0,20.81,18.25,18.19,18.78,17.56,16.72,18.19,20.03,19.91,18.44,18.38,19.47,18.97,16.5,14.94,15.38,15.06,12.78,11.78,13.53,15.53,15.31,14.69,15.47,16.78,15.88,13.91,13.25,14.25,13.75,11.62,11.06,12.88,14.56,14.28,14.47,16.47,18.0,16.75,14.72,14.06,14.53,13.47,11.66,11.66,13.06,13.09,11.06,9.97,11.12,11.56,10.19,9.38,10.84,12.5,12.41,11.53,12.69,14.03,13.38,11.53,10.81,11.44,11.25,9.91,9.66,11.62,13.62,13.38,12.66,13.88,15.31,14.69,13.75,15.28,17.56,18.69,18.06,18.28,20.12,20.53,19.59,19.25,20.88,22.12,20.56,18.84,18.66,18.84,17.5,15.78,16.28,18.09,18.12,16.97,17.66,20.06,21.56,21.47,21.62,23.28,24.06,21.69,19.06,18.34,17.66,15.0,11.97,10.88,10.97,10.16,8.5,8.25,10.16,11.41,11.03,11.59,14.94,17.53,18.34,18.97,20.56,22.94,22.97,22.44,23.62,25.88,26.66,25.53,25.19,26.19,26.22,24.38,23.12,23.81,24.38,22.53,19.69,18.53,17.66,14.88,11.69,10.47,11.34,11.81,11.19,12.12,14.72,16.28,15.59,14.53,15.56,16.53,15.16,13.56,14.31,15.97,16.5,16.06,17.25,19.31,19.75,18.31,17.31,17.88,17.31,14.31,11.19,10.5,10.25,8.56,6.84,6.78,7.22,5.56,2.16,0.62,1.16,1.88,1.66,3.22,7.28,10.47,11.44,12.03,14.84,17.56,17.84,17.53,18.75,21.19,22.25,22.0,22.75,24.41,23.69,20.59,17.97,17.91,17.84,16.56,15.09,16.34,17.44,16.38,14.72,14.94,17.19,17.94,17.69,18.94,21.53,22.91,21.44,20.25,20.66,20.34,17.81,15.69,16.12,17.56,17.38,16.34,16.38,17.31,16.0,13.06,11.5,12.28,12.66,11.47,11.47,13.5,15.34,15.16,14.66,16.5,18.69,19.16,18.28,19.28,20.78,20.38,18.03,16.5,16.19,15.19,12.25,10.28,10.69,11.28,9.81,8.59,9.88,12.03,12.84,12.62,13.88,15.66,15.38,13.09,12.28,13.91,15.41,15.03,14.94,15.88,15.41,12.16,8.41,7.09,7.69,7.84,7.25,9.0,12.0,13.22,12.25,11.62,12.72,13.19,11.91,11.59,14.22,16.78,17.16,16.62,17.44,18.34,17.06,14.06,12.0,10.78,8.84,5.75,4.34,5.44,6.56,6.47,7.03,10.31,13.88,15.5,15.78,17.47,19.34,19.28,17.97,18.09,19.59,20.38,18.88,17.91,18.75,18.91,16.56,13.84,13.5,12.91,10.53,7.44,7.03,7.91,7.75,6.38,6.88,8.78,9.59,9.03,9.56,12.59,15.5,16.69,17.59,20.66,23.28,22.97,21.38,21.28,21.75,20.59,18.03,16.5,16.22,14.84,11.22,8.53,8.94,9.84,9.38,9.53,11.91,14.47,14.28,12.66,12.81,13.62,13.53,12.25,12.5,14.72,16.59,16.28,16.47,18.25,18.94,16.59,12.62,11.16,9.66,6.56,3.28,2.16,2.47,1.94,0.69,1.19,3.53,4.97,4.31,3.78,5.41,6.62,5.72,4.22,5.66,7.5,7.62,7.09,8.81,10.91,11.88,10.5,10.0,10.94,11.28,9.75,8.47,9.88,11.41,10.97,10.25,11.91,13.53,12.75,9.94,8.44,8.44,7.5,5.47,5.0,6.59,7.56,6.69,6.25,8.69,11.06,11.41,10.62,11.56,12.34,10.88,7.47,5.5,4.62,3.28,0.81,0.16,2.25,4.44,5.0,5.41,7.97,9.75,9.16,7.28,7.38,8.25,7.94,6.56,6.88,8.66,9.31,7.81,6.81,7.53,7.97,6.44,4.81,6.22,8.0,7.47,6.06,6.56,7.88,7.31,5.72,6.0,8.0,9.22,8.31,7.84,9.16,9.44,7.31,4.91,4.44,4.47,3.12,1.53,2.31,4.81,5.91,5.41,5.75,7.34,7.47,5.34,3.41,3.44,3.44,1.47,0.03,1.41,3.62,4.62,4.88,7.25,10.69,12.16,12.25,13.28,15.62,16.84,15.97,15.66,17.34,18.84,18.28,17.16,18.38,19.78,19.12,17.16,16.88,17.75,17.44,16.38,16.41,18.41,19.28,17.84,16.28,16.84,17.44,15.72,13.72,13.69,13.75,11.75,8.44,6.44,5.56,3.34,0.22,-0.31,2.03,4.62,5.25,5.47,6.78,6.53,2.78,-1.59,-4.41,-5.97,-8.69,-11.75,-12.69,-11.47,-10.81,-11.56,-10.88,-7.78,-5.5,-5.56,-5.25,-3.06,-0.03,1.19,2.81,6.78,11.97,14.72,15.25,16.41,16.91,15.12,10.16,5.38,2.22,-1.47,-7.34,-12.69,-15.06,-16.41,-18.84,-20.66,-19.12,-15.28,-12.31,-9.62,-4.84,1.47,6.69,9.22,11.56,14.34,15.66,13.31,10.31,9.19,8.16,4.94,1.19,-0.78,-1.75,-4.47,-7.66,-8.69,-7.47,-6.09,18.44,18.44,17.0,16.06,17.34,19.06,19.56:8.59,7.78,6.94,9.03,10.12,9.0,7.44,8.47,10.0,9.5,8.19,9.22,11.34,11.94,10.59,10.28,11.56,11.5,9.06,7.34,8.34,8.91,7.19,4.72,4.72,4.88,3.16,1.09,1.28,3.38,4.69,4.72,5.94,9.28,11.53,10.94,10.78,12.84,14.53,14.53,13.62,14.53,15.38,13.94,10.66,9.41,10.28,10.19,8.69,8.59,10.25,11.0,9.47,7.81,8.69,9.19,8.03,6.28,7.62,10.0,10.56,10.12,10.56,11.88,11.31,8.31,6.56,6.69,6.31,4.19,3.06,5.12,8.03,9.38,9.75,12.44,15.31,16.31,16.34,17.88,20.41,21.75,21.16,20.81,22.62,23.72,22.38,21.09,21.88,22.25,20.03,16.78,15.88,16.19,15.5,14.06,14.28,16.16,16.56,14.62,13.47,14.28,15.12,13.78,13.06,14.69,16.09,15.34,12.75,11.78,11.72,10.59,8.62,8.75,11.06,12.56,12.16,11.84,13.22,14.09,12.47,10.66,11.53,13.0,12.47,10.59,10.78,11.5,10.84,8.59,8.56,10.66,12.84,13.38,15.22,19.19,22.44,22.78,22.38,23.66,24.47,23.84,22.06,22.47,24.34,25.16,23.88,23.5,24.06,23.47,20.19,17.09,16.69,16.88,15.5,14.12,15.75,17.59,17.59,16.22,16.47,17.78,18.16,16.56,16.22,18.03,19.03,17.25,16.06,16.62,16.88,14.59,11.53,11.22,12.03,11.44,9.97,10.59,11.75,11.78,9.94,9.62,11.34,12.78,12.38,12.75,15.5,18.28,18.53,17.78,18.12,18.59,16.91,13.38,11.97,11.91,11.0,8.66,7.84,9.25,10.47,9.47,8.84,10.56,12.78,12.59,12.12,13.72,16.09,16.41,15.09,15.31,16.72,16.66,14.22,12.66,12.41,11.53,8.28,5.78,6.19,7.59,7.62,7.12,9.03,11.59,12.28,11.31,11.97,13.81,14.78,13.91,14.12,16.69,18.56,18.41,17.97,19.69,20.78,19.28,16.47,15.25,15.12,13.75,11.38,11.44,13.53,14.84,13.69,12.91,13.81,14.0,12.06,10.19,11.09,12.84,12.69,11.81,12.75,14.12,13.94,12.03,11.78,12.88,13.69,12.03,10.88,11.78,12.56,10.72,9.12,9.53,10.44,9.84,8.53,9.25,11.56,12.5,11.88,12.09,13.91,15.19,13.41,12.41,13.16,13.78,12.19,10.62,11.5,13.62,13.75,13.06,14.28,16.66,17.62,16.88,17.38,19.28,20.12,18.34,16.62,17.25,17.91,15.91,14.12,14.59,15.78,14.88,13.12,13.25,14.03,13.88,12.03,11.53,12.81,14.25,13.75,13.84,16.03,18.25,17.72,16.31,16.94,17.81,17.34,15.31,15.09,15.72,14.91,12.0,10.34,10.94,11.69,10.59,10.56,12.72,15.12,15.38,14.5,15.56,17.25,16.78,15.12,14.66,15.66,15.44,12.75,11.28,12.03,12.62,10.78,9.34,10.12,11.0,9.81,8.59,9.75,12.03,12.69,11.38,11.91,13.34,14.19,12.81,12.25,13.47,14.06,12.03,9.94,9.84,10.22,8.56,6.66,7.09,8.88,9.53,8.97,9.41,11.56,12.0,10.09,8.84,10.0,11.09,9.81,8.69,9.47,11.03,9.78,7.78,7.78,8.41,7.5,5.31,4.69,6.0,6.62,5.56,5.75,8.31,10.41,9.91,9.16,10.28,12.16,12.28,12.34,14.31,16.72,17.25,15.69,15.03,15.72,15.75,13.41,11.91,12.5,13.38,12.44,11.72,12.88,15.0,15.34,14.78,15.91,18.38,19.03,17.25,16.41,17.59,17.81,16.25,15.72,17.62,19.94,19.66,19.44,21.09,23.56,24.09,23.66,24.94,27.25,28.06,26.47,25.12,25.0,23.75,20.31,18.06,18.22,19.22,18.06,16.47,16.81,17.53,16.53,15.44,16.72,19.97,22.59,23.25,24.34,26.28,27.38,25.84,24.47,24.81,25.5,23.72,21.69,21.59,22.81,22.47,21.16,21.31,23.0,23.41,22.12,21.59,23.44,24.44,22.5,20.81,20.88,21.38,20.03,19.03,19.91,22.19,22.62,21.94,22.44,24.12,24.66,22.94,22.03,22.84,23.0,20.72,18.53,18.56,19.41,18.78,17.78,18.5,20.19,20.38,18.62,18.47,19.72,20.47,19.31,18.56,19.72,20.47,18.72,16.81,17.12,17.97,16.62,14.81,14.53,15.59,14.94,13.25,12.94,14.0,14.16,12.62,11.97,13.62,15.69,15.75,15.34,17.19,19.28,19.0,18.28,19.25,22.22,23.78,23.38,23.56,24.62,24.0,20.81,18.25,18.19,18.78,17.56,16.72,18.19,20.03,19.91,18.44,18.38,19.47,18.97,16.5,14.94,15.38,15.06,12.78,11.78,13.53,15.53,15.31,14.69,15.47,16.78,15.88,13.91,13.25,14.25,13.75,11.62,11.06,12.88,14.56,14.28,14.47,16.47,18.0,16.75,14.72,14.06,14.53,13.47,11.66,11.66,13.06,13.09,11.06,9.97,11.12,11.56,10.19,9.38,10.84,12.5,12.41,11.53,12.69,14.03,13.38,11.53,10.81,11.44,11.25,9.91,9.66,11.62,13.62,13.38,12.66,13.88,15.31,14.69,13.75,15.28,17.56,18.69,18.06,18.28,20.12,20.53,19.59,19.25,20.88,22.12,20.56,18.84,18.66,18.84,17.5,15.78,16.28,18.09,18.12,16.97,17.66,20.06,21.56,21.47,21.62,23.28,24.06,21.69,19.06,18.34,17.66,15.0,11.97,10.88,10.97,10.16,8.5,8.25,10.16,11.41,11.03,11.59,14.94,17.53,18.34,18.97,20.56,22.94,22.97,22.44,23.62,25.88,26.66,25.53,25.19,26.19,26.22,24.38,23.12,23.81,24.38,22.53,19.69,18.53,17.66,14.88,11.69,10.47,11.34,11.81,11.19,12.12,14.72,16.28,15.59,14.53,15.56,16.53,15.16,13.56,14.31,15.97,16.5,16.06,17.25,19.31,19.75,18.31,17.31,17.88,17.31,14.31,11.19,10.5,10.25,8.56,6.84,6.78,7.22,5.56,2.16,0.62,1.16,1.88,1.66,3.22,7.28,10.47,11.44,12.03,14.84,17.56,17.84,17.53,18.75,21.19,22.25,22.0,22.75,24.41,23.69,20.59,17.97,17.91,17.84,16.56,15.09,16.34,17.44,16.38,14.72,14.94,17.19,17.94,17.69,18.94,21.53,22.91,21.44,20.25,20.66,20.34,17.81,15.69,16.12,17.56,17.38,16.34,16.38,17.31,16.0,13.06,11.5,12.28,12.66,11.47,11.47,13.5,15.34,15.16,14.66,16.5,18.69,19.16,18.28,19.28,20.78,20.38,18.03,16.5,16.19,15.19,12.25,10.28,10.69,11.28,9.81,8.59,9.88,12.03,12.84,12.62,13.88,15.66,15.38,13.09,12.28,13.91,15.41,15.03,14.94,15.88,15.41,12.16,8.41,7.09,7.69,7.84,7.25,9.0,12.0,13.22,12.25,11.62,12.72,13.19,11.91,11.59,14.22,16.78,17.16,16.62,17.44,18.34,17.06,14.06,12.0,10.78,8.84,5.75,4.34,5.44,6.56,6.47,7.03,10.31,13.88,15.5,15.78,17.47,19.34,19.28,17.97,18.09,19.59,20.38,18.88,17.91,18.75,18.91,16.56,13.84,13.5,12.91,10.53,7.44,7.03,7.91,7.75,6.38,6.88,8.78,9.59,9.03,9.56,12.59,15.5,16.69,17.59,20.66,23.28,22.97,21.38,21.28,21.75,20.59,18.03,16.5,16.22,14.84,11.22,8.53,8.94,9.84,9.38,9.53,11.91,14.47,14.28,12.66,12.81,13.62,13.53,12.25,12.5,14.72,16.59,16.28,16.47,18.25,18.94,16.59,12.62,11.16,9.66,6.56,3.28,2.16,2.47,1.94,0.69,1.19,3.53,4.97,4.31,3.78,5.41,6.62,5.72,4.22,5.66,7.5,7.62,7.09,8.81,10.91,11.88,10.5,10.0,10.94,11.28,9.75,8.47,9.88,11.41,10.97,10.25,11.91,13.53,12.75,9.94,8.44,8.44,7.5,5.47,5.0,6.59,7.56,6.69,6.25,8.69,11.06,11.41,10.62,11.56,12.34,10.88,7.47,5.5,4.62,3.28,0.81,0.16,2.25,4.44,5.0,5.41,7.97,9.75,9.16,7.28,7.38,8.25,7.94,6.56,6.88,8.66,9.31,7.81,6.81,7.53,7.97,6.44,4.81,6.22,8.0,7.47,6.06,6.56,7.88,7.31,5.72,6.0,8.0,9.22,8.31,7.84,9.16,9.44,7.31,4.91,4.44,4.47,3.12,1.53,2.31,4.81,5.91,5.41,5.75,7.34,7.47,5.34,3.41,3.44,3.44,1.47,0.03,1.41,3.62,4.62,4.88,7.25,10.69,12.16,12.25,13.28,15.62,16.84,15.97,15.66,17.34,18.84,18.28,17.16,18.38,19.78,19.12,17.16,16.88,17.75,17.44,16.38,16.41,18.41,19.28,17.84,16.28,16.84,17.44,15.72,13.72,13.69,13.75,11.75,8.44,6.44,5.56,3.34,0.22,-0.31,2.03,4.62,5.25,5.47,6.78,6.53,2.78,-1.59,-4.41,-5.97,-8.69,-11.75,-12.69,-11.47,-10.81,-11.56,-10.88,-7.78,-5.5,-5.56,-5.25,-3.06,-0.03,1.19,2.81,6.78,11.97,14.72,15.25,16.41,16.91,15.12,10.16,5.38,2.22,-1.47,-7.34,-12.69,-15.06,-16.41,-18.84,-20.66,-19.12,-15.28,-12.31,-9.62,-4.84,1.47,6.69,9.22,11.56,14.34,15.66,13.31,10.31,9.19,8.16,4.94,1.19,-0.78,-1.75,-4.47,-7.66,-8.69,-7.47,-6.09,18.44,18.44,17.0,16.06,17.34,19.06,19.56,19.28,19.88,20.59,20.12,18.59,18.69,20.03:8.47,10.0,9.5,8.19,9.22,11.34,11.94,10.59,10.28,11.56,11.5,9.06,7.34,8.34,8.91,7.19,4.72,4.72,4.88,3.16,1.09,1.28,3.38,4.69,4.72,5.94,9.28,11.53,10.94,10.78,12.84,14.53,14.53,13.62,14.53,15.38,13.94,10.66,9.41,10.28,10.19,8.69,8.59,10.25,11.0,9.47,7.81,8.69,9.19,8.03,6.28,7.62,10.0,10.56,10.12,10.56,11.88,11.31,8.31,6.56,6.69,6.31,4.19,3.06,5.12,8.03,9.38,9.75,12.44,15.31,16.31,16.34,17.88,20.41,21.75,21.16,20.81,22.62,23.72,22.38,21.09,21.88,22.25,20.03,16.78,15.88,16.19,15.5,14.06,14.28,16.16,16.56,14.62,13.47,14.28,15.12,13.78,13.06,14.69,16.09,15.34,12.75,11.78,11.72,10.59,8.62,8.75,11.06,12.56,12.16,11.84,13.22,14.09,12.47,10.66,11.53,13.0,12.47,10.59,10.78,11.5,10.84,8.59,8.56,10.66,12.84,13.38,15.22,19.19,22.44,22.78,22.38,23.66,24.47,23.84,22.06,22.47,24.34,25.16,23.88,23.5,24.06,23.47,20.19,17.09,16.69,16.88,15.5,14.12,15.75,17.59,17.59,16.22,16.47,17.78,18.16,16.56,16.22,18.03,19.03,17.25,16.06,16.62,16.88,14.59,11.53,11.22,12.03,11.44,9.97,10.59,11.75,11.78,9.94,9.62,11.34,12.78,12.38,12.75,15.5,18.28,18.53,17.78,18.12,18.59,16.91,13.38,11.97,11.91,11.0,8.66,7.84,9.25,10.47,9.47,8.84,10.56,12.78,12.59,12.12,13.72,16.09,16.41,15.09,15.31,16.72,16.66,14.22,12.66,12.41,11.53,8.28,5.78,6.19,7.59,7.62,7.12,9.03,11.59,12.28,11.31,11.97,13.81,14.78,13.91,14.12,16.69,18.56,18.41,17.97,19.69,20.78,19.28,16.47,15.25,15.12,13.75,11.38,11.44,13.53,14.84,13.69,12.91,13.81,14.0,12.06,10.19,11.09,12.84,12.69,11.81,12.75,14.12,13.94,12.03,11.78,12.88,13.69,12.03,10.88,11.78,12.56,10.72,9.12,9.53,10.44,9.84,8.53,9.25,11.56,12.5,11.88,12.09,13.91,15.19,13.41,12.41,13.16,13.78,12.19,10.62,11.5,13.62,13.75,13.06,14.28,16.66,17.62,16.88,17.38,19.28,20.12,18.34,16.62,17.25,17.91,15.91,14.12,14.59,15.78,14.88,13.12,13.25,14.03,13.88,12.03,11.53,12.81,14.25,13.75,13.84,16.03,18.25,17.72,16.31,16.94,17.81,17.34,15.31,15.09,15.72,14.91,12.0,10.34,10.94,11.69,10.59,10.56,12.72,15.12,15.38,14.5,15.56,17.25,16.78,15.12,14.66,15.66,15.44,12.75,11.28,12.03,12.62,10.78,9.34,10.12,11.0,9.81,8.59,9.75,12.03,12.69,11.38,11.91,13.34,14.19,12.81,12.25,13.47,14.06,12.03,9.94,9.84,10.22,8.56,6.66,7.09,8.88,9.53,8.97,9.41,11.56,12.0,10.09,8.84,10.0,11.09,9.81,8.69,9.47,11.03,9.78,7.78,7.78,8.41,7.5,5.31,4.69,6.0,6.62,5.56,5.75,8.31,10.41,9.91,9.16,10.28,12.16,12.28,12.34,14.31,16.72,17.25,15.69,15.03,15.72,15.75,13.41,11.91,12.5,13.38,12.44,11.72,12.88,15.0,15.34,14.78,15.91,18.38,19.03,17.25,16.41,17.59,17.81,16.25,15.72,17.62,19.94,19.66,19.44,21.09,23.56,24.09,23.66,24.94,27.25,28.06,26.47,25.12,25.0,23.75,20.31,18.06,18.22,19.22,18.06,16.47,16.81,17.53,16.53,15.44,16.72,19.97,22.59,23.25,24.34,26.28,27.38,25.84,24.47,24.81,25.5,23.72,21.69,21.59,22.81,22.47,21.16,21.31,23.0,23.41,22.12,21.59,23.44,24.44,22.5,20.81,20.88,21.38,20.03,19.03,19.91,22.19,22.62,21.94,22.44,24.12,24.66,22.94,22.03,22.84,23.0,20.72,18.53,18.56,19.41,18.78,17.78,18.5,20.19,20.38,18.62,18.47,19.72,20.47,19.31,18.56,19.72,20.47,18.72,16.81,17.12,17.97,16.62,14.81,14.53,15.59,14.94,13.25,12.94,14.0,14.16,12.62,11.97,13.62,15.69,15.75,15.34,17.19,19.28,19.0,18.28,19.25,22.22,23.78,23.38,23.56,24.62,24.0,20.81,18.25,18.19,18.78,17.56,16.72,18.19,20.03,19.91,18.44,18.38,19.47,18.97,16.5,14.94,15.38,15.06,12.78,11.78,13.53,15.53,15.31,14.69,15.47,16.78,15.88,13.91,13.25,14.25,13.75,11.62,11.06,12.88,14.56,14.28,14.47,16.47,18.0,16.75,14.72,14.06,14.53,13.47,11.66,11.66,13.06,13.09,11.06,9.97,11.12,11.56,10.19,9.38,10.84,12.5,12.41,11.53,12.69,14.03,13.38,11.53,10.81,11.44,11.25,9.91,9.66,11.62,13.62,13.38,12.66,13.88,15.31,14.69,13.75,15.28,17.56,18.69,18.06,18.28,20.12,20.53,19.59,19.25,20.88,22.12,20.56,18.84,18.66,18.84,17.5,15.78,16.28,18.09,18.12,16.97,17.66,20.06,21.56,21.47,21.62,23.28,24.06,21.69,19.06,18.34,17.66,15.0,11.97,10.88,10.97,10.16,8.5,8.25,10.16,11.41,11.03,11.59,14.94,17.53,18.34,18.97,20.56,22.94,22.97,22.44,23.62,25.88,26.66,25.53,25.19,26.19,26.22,24.38,23.12,23.81,24.38,22.53,19.69,18.53,17.66,14.88,11.69,10.47,11.34,11.81,11.19,12.12,14.72,16.28,15.59,14.53,15.56,16.53,15.16,13.56,14.31,15.97,16.5,16.06,17.25,19.31,19.75,18.31,17.31,17.88,17.31,14.31,11.19,10.5,10.25,8.56,6.84,6.78,7.22,5.56,2.16,0.62,1.16,1.88,1.66,3.22,7.28,10.47,11.44,12.03,14.84,17.56,17.84,17.53,18.75,21.19,22.25,22.0,22.75,24.41,23.69,20.59,17.97,17.91,17.84,16.56,15.09,16.34,17.44,16.38,14.72,14.94,17.19,17.94,17.69,18.94,21.53,22.91,21.44,20.25,20.66,20.34,17.81,15.69,16.12,17.56,17.38,16.34,16.38,17.31,16.0,13.06,11.5,12.28,12.66,11.47,11.47,13.5,15.34,15.16,14.66,16.5,18.69,19.16,18.28,19.28,20.78,20.38,18.03,16.5,16.19,15.19,12.25,10.28,10.69,11.28,9.81,8.59,9.88,12.03,12.84,12.62,13.88,15.66,15.38,13.09,12.28,13.91,15.41,15.03,14.94,15.88,15.41,12.16,8.41,7.09,7.69,7.84,7.25,9.0,12.0,13.22,12.25,11.62,12.72,13.19,11.91,11.59,14.22,16.78,17.16,16.62,17.44,18.34,17.06,14.06,12.0,10.78,8.84,5.75,4.34,5.44,6.56,6.47,7.03,10.31,13.88,15.5,15.78,17.47,19.34,19.28,17.97,18.09,19.59,20.38,18.88,17.91,18.75,18.91,16.56,13.84,13.5,12.91,10.53,7.44,7.03,7.91,7.75,6.38,6.88,8.78,9.59,9.03,9.56,12.59,15.5,16.69,17.59,20.66,23.28,22.97,21.38,21.28,21.75,20.59,18.03,16.5,16.22,14.84,11.22,8.53,8.94,9.84,9.38,9.53,11.91,14.47,14.28,12.66,12.81,13.62,13.53,12.25,12.5,14.72,16.59,16.28,16.47,18.25,18.94,16.59,12.62,11.16,9.66,6.56,3.28,2.16,2.47,1.94,0.69,1.19,3.53,4.97,4.31,3.78,5.41,6.62,5.72,4.22,5.66,7.5,7.62,7.09,8.81,10.91,11.88,10.5,10.0,10.94,11.28,9.75,8.47,9.88,11.41,10.97,10.25,11.91,13.53,12.75,9.94,8.44,8.44,7.5,5.47,5.0,6.59,7.56,6.69,6.25,8.69,11.06,11.41,10.62,11.56,12.34,10.88,7.47,5.5,4.62,3.28,0.81,0.16,2.25,4.44,5.0,5.41,7.97,9.75,9.16,7.28,7.38,8.25,7.94,6.56,6.88,8.66,9.31,7.81,6.81,7.53,7.97,6.44,4.81,6.22,8.0,7.47,6.06,6.56,7.88,7.31,5.72,6.0,8.0,9.22,8.31,7.84,9.16,9.44,7.31,4.91,4.44,4.47,3.12,1.53,2.31,4.81,5.91,5.41,5.75,7.34,7.47,5.34,3.41,3.44,3.44,1.47,0.03,1.41,3.62,4.62,4.88,7.25,10.69,12.16,12.25,13.28,15.62,16.84,15.97,15.66,17.34,18.84,18.28,17.16,18.38,19.78,19.12,17.16,16.88,17.75,17.44,16.38,16.41,18.41,19.28,17.84,16.28,16.84,17.44,15.72,13.72,13.69,13.75,11.75,8.44,6.44,5.56,3.34,0.22,-0.31,2.03,4.62,5.25,5.47,6.78,6.53,2.78,-1.59,-4.41,-5.97,-8.69,-11.75,-12.69,-11.47,-10.81,-11.56,-10.88,-7.78,-5.5,-5.56,-5.25,-3.06,-0.03,1.19,2.81,6.78,11.97,14.72,15.25,16.41,16.91,15.12,10.16,5.38,2.22,-1.47,-7.34,-12.69,-15.06,-16.41,-18.84,-20.66,-19.12,-15.28,-12.31,-9.62,-4.84,1.47,6.69,9.22,11.56,14.34,15.66,13.31,10.31,9.19,8.16,4.94,1.19,-0.78,-1.75,-4.47,-7.66,-8.69,-7.47,-6.09,18.44,18.44,17.0,16.06,17.34,19.06,19.56,19.28,19.88,20.59,20.12,18.59,18.69,20.03,21.19,20.91,20.59,22.09,22.88,22.06,21.03:10.59,10.28,11.56,11.5,9.06,7.34,8.34,8.91,7.19,4.72,4.72,4.88,3.16,1.09,1.28,3.38,4.69,4.72,5.94,9.28,11.53,10.94,10.78,12.84,14.53,14.53,13.62,14.53,15.38,13.94,10.66,9.41,10.28,10.19,8.69,8.59,10.25,11.0,9.47,7.81,8.69,9.19,8.03,6.28,7.62,10.0,10.56,10.12,10.56,11.88,11.31,8.31,6.56,6.69,6.31,4.19,3.06,5.12,8.03,9.38,9.75,12.44,15.31,16.31,16.34,17.88,20.41,21.75,21.16,20.81,22.62,23.72,22.38,21.09,21.88,22.25,20.03,16.78,15.88,16.19,15.5,14.06,14.28,16.16,16.56,14.62,13.47,14.28,15.12,13.78,13.06,14.69,16.09,15.34,12.75,11.78,11.72,10.59,8.62,8.75,11.06,12.56,12.16,11.84,13.22,14.09,12.47,10.66,11.53,13.0,12.47,10.59,10.78,11.5,10.84,8.59,8.56,10.66,12.84,13.38,15.22,19.19,22.44,22.78,22.38,23.66,24.47,23.84,22.06,22.47,24.34,25.16,23.88,23.5,24.06,23.47,20.19,17.09,16.69,16.88,15.5,14.12,15.75,17.59,17.59,16.22,16.47,17.78,18.16,16.56,16.22,18.03,19.03,17.25,16.06,16.62,16.88,14.59,11.53,11.22,12.03,11.44,9.97,10.59,11.75,11.78,9.94,9.62,11.34,12.78,12.38,12.75,15.5,18.28,18.53,17.78,18.12,18.59,16.91,13.38,11.97,11.91,11.0,8.66,7.84,9.25,10.47,9.47,8.84,10.56,12.78,12.59,12.12,13.72,16.09,16.41,15.09,15.31,16.72,16.66,14.22,12.66,12.41,11.53,8.28,5.78,6.19,7.59,7.62,7.12,9.03,11.59,12.28,11.31,11.97,13.81,14.78,13.91,14.12,16.69,18.56,18.41,17.97,19.69,20.78,19.28,16.47,15.25,15.12,13.75,11.38,11.44,13.53,14.84,13.69,12.91,13.81,14.0,12.06,10.19,11.09,12.84,12.69,11.81,12.75,14.12,13.94,12.03,11.78,12.88,13.69,12.03,10.88,11.78,12.56,10.72,9.12,9.53,10.44,9.84,8.53,9.25,11.56,12.5,11.88,12.09,13.91,15.19,13.41,12.41,13.16,13.78,12.19,10.62,11.5,13.62,13.75,13.06,14.28,16.66,17.62,16.88,17.38,19.28,20.12,18.34,16.62,17.25,17.91,15.91,14.12,14.59,15.78,14.88,13.12,13.25,14.03,13.88,12.03,11.53,12.81,14.25,13.75,13.84,16.03,18.25,17.72,16.31,16.94,17.81,17.34,15.31,15.09,15.72,14.91,12.0,10.34,10.94,11.69,10.59,10.56,12.72,15.12,15.38,14.5,15.56,17.25,16.78,15.12,14.66,15.66,15.44,12.75,11.28,12.03,12.62,10.78,9.34,10.12,11.0,9.81,8.59,9.75,12.03,12.69,11.38,11.91,13.34,14.19,12.81,12.25,13.47,14.06,12.03,9.94,9.84,10.22,8.56,6.66,7.09,8.88,9.53,8.97,9.41,11.56,12.0,10.09,8.84,10.0,11.09,9.81,8.69,9.47,11.03,9.78,7.78,7.78,8.41,7.5,5.31,4.69,6.0,6.62,5.56,5.75,8.31,10.41,9.91,9.16,10.28,12.16,12.28,12.34,14.31,16.72,17.25,15.69,15.03,15.72,15.75,13.41,11.91,12.5,13.38,12.44,11.72,12.88,15.0,15.34,14.78,15.91,18.38,19.03,17.25,16.41,17.59,17.81,16.25,15.72,17.62,19.94,19.66,19.44,21.09,23.56,24.09,23.66,24.94,27.25,28.06,26.47,25.12,25.0,23.75,20.31,18.06,18.22,19.22,18.06,16.47,16.81,17.53,16.53,15.44,16.72,19.97,22.59,23.25,24.34,26.28,27.38,25.84,24.47,24.81,25.5,23.72,21.69,21.59,22.81,22.47,21.16,21.31,23.0,23.41,22.12,21.59,23.44,24.44,22.5,20.81,20.88,21.38,20.03,19.03,19.91,22.19,22.62,21.94,22.44,24.12,24.66,22.94,22.03,22.84,23.0,20.72,18.53,18.56,19.41,18.78,17.78,18.5,20.19,20.38,18.62,18.47,19.72,20.47,19.31,18.56,19.72,20.47,18.72,16.81,17.12,17.97,16.62,14.81,14.53,15.59,14.94,13.25,12.94,14.0,14.16,12.62,11.97,13.62,15.69,15.75,15.34,17.19,19.28,19.0,18.28,19.25,22.22,23.78,23.38,23.56,24.62,24.0,20.81,18.25,18.19,18.78,17.56,16.72,18.19,20.03,19.91,18.44,18.38,19.47,18.97,16.5,14.94,15.38,15.06,12.78,11.78,13.53,15.53,15.31,14.69,15.47,16.78,15.88,13.91,13.25,14.25,13.75,11.62,11.06,12.88,14.56,14.28,14.47,16.47,18.0,16.75,14.72,14.06,14.53,13.47,11.66,11.66,13.06,13.09,11.06,9.97,11.12,11.56,10.19,9.38,10.84,12.5,12.41,11.53,12.69,14.03,13.38,11.53,10.81,11.44,11.25,9.91,9.66,11.62,13.62,13.38,12.66,13.88,15.31,14.69,13.75,15.28,17.56,18.69,18.06,18.28,20.12,20.53,19.59,19.25,20.88,22.12,20.56,18.84,18.66,18.84,17.5,15.78,16.28,18.09,18.12,16.97,17.66,20.06,21.56,21.47,21.62,23.28,24.06,21.69,19.06,18.34,17.66,15.0,11.97,10.88,10.97,10.16,8.5,8.25,10.16,11.41,11.03,11.59,14.94,17.53,18.34,18.97,20.56,22.94,22.97,22.44,23.62,25.88,26.66,25.53,25.19,26.19,26.22,24.38,23.12,23.81,24.38,22.53,19.69,18.53,17.66,14.88,11.69,10.47,11.34,11.81,11.19,12.12,14.72,16.28,15.59,14.53,15.56,16.53,15.16,13.56,14.31,15.97,16.5,16.06,17.25,19.31,19.75,18.31,17.31,17.88,17.31,14.31,11.19,10.5,10.25,8.56,6.84,6.78,7.22,5.56,2.16,0.62,1.16,1.88,1.66,3.22,7.28,10.47,11.44,12.03,14.84,17.56,17.84,17.53,18.75,21.19,22.25,22.0,22.75,24.41,23.69,20.59,17.97,17.91,17.84,16.56,15.09,16.34,17.44,16.38,14.72,14.94,17.19,17.94,17.69,18.94,21.53,22.91,21.44,20.25,20.66,20.34,17.81,15.69,16.12,17.56,17.38,16.34,16.38,17.31,16.0,13.06,11.5,12.28,12.66,11.47,11.47,13.5,15.34,15.16,14.66,16.5,18.69,19.16,18.28,19.28,20.78,20.38,18.03,16.5,16.19,15.19,12.25,10.28,10.69,11.28,9.81,8.59,9.88,12.03,12.84,12.62,13.88,15.66,15.38,13.09,12.28,13.91,15.41,15.03,14.94,15.88,15.41,12.16,8.41,7.09,7.69,7.84,7.25,9.0,12.0,13.22,12.25,11.62,12.72,13.19,11.91,11.59,14.22,16.78,17.16,16.62,17.44,18.34,17.06,14.06,12.0,10.78,8.84,5.75,4.34,5.44,6.56,6.47,7.03,10.31,13.88,15.5,15.78,17.47,19.34,19.28,17.97,18.09,19.59,20.38,18.88,17.91,18.75,18.91,16.56,13.84,13.5,12.91,10.53,7.44,7.03,7.91,7.75,6.38,6.88,8.78,9.59,9.03,9.56,12.59,15.5,16.69,17.59,20.66,23.28,22.97,21.38,21.28,21.75,20.59,18.03,16.5,16.22,14.84,11.22,8.53,8.94,9.84,9.38,9.53,11.91,14.47,14.28,12.66,12.81,13.62,13.53,12.25,12.5,14.72,16.59,16.28,16.47,18.25,18.94,16.59,12.62,11.16,9.66,6.56,3.28,2.16,2.47,1.94,0.69,1.19,3.53,4.97,4.31,3.78,5.41,6.62,5.72,4.22,5.66,7.5,7.62,7.09,8.81,10.91,11.88,10.5,10.0,10.94,11.28,9.75,8.47,9.88,11.41,10.97,10.25,11.91,13.53,12.75,9.94,8.44,8.44,7.5,5.47,5.0,6.59,7.56,6.69,6.25,8.69,11.06,11.41,10.62,11.56,12.34,10.88,7.47,5.5,4.62,3.28,0.81,0.16,2.25,4.44,5.0,5.41,7.97,9.75,9.16,7.28,7.38,8.25,7.94,6.56,6.88,8.66,9.31,7.81,6.81,7.53,7.97,6.44,4.81,6.22,8.0,7.47,6.06,6.56,7.88,7.31,5.72,6.0,8.0,9.22,8.31,7.84,9.16,9.44,7.31,4.91,4.44,4.47,3.12,1.53,2.31,4.81,5.91,5.41,5.75,7.34,7.47,5.34,3.41,3.44,3.44,1.47,0.03,1.41,3.62,4.62,4.88,7.25,10.69,12.16,12.25,13.28,15.62,16.84,15.97,15.66,17.34,18.84,18.28,17.16,18.38,19.78,19.12,17.16,16.88,17.75,17.44,16.38,16.41,18.41,19.28,17.84,16.28,16.84,17.44,15.72,13.72,13.69,13.75,11.75,8.44,6.44,5.56,3.34,0.22,-0.31,2.03,4.62,5.25,5.47,6.78,6.53,2.78,-1.59,-4.41,-5.97,-8.69,-11.75,-12.69,-11.47,-10.81,-11.56,-10.88,-7.78,-5.5,-5.56,-5.25,-3.06,-0.03,1.19,2.81,6.78,11.97,14.72,15.25,16.41,16.91,15.12,10.16,5.38,2.22,-1.47,-7.34,-12.69,-15.06,-16.41,-18.84,-20.66,-19.12,-15.28,-12.31,-9.62,-4.84,1.47,6.69,9.22,11.56,14.34,15.66,13.31,10.31,9.19,8.16,4.94,1.19,-0.78,-1.75,-4.47,-7.66,-8.69,-7.47,-6.09,18.44,18.44,17.0,16.06,17.34,19.06,19.56,19.28,19.88,20.59,20.12,18.59,18.69,20.03,21.19,20.91,20.59,22.09,22.88,22.06,21.03,21.59,22.34,21.78,20.47,20.66,21.5,21.31:8.91,7.19,4.72,4.72,4.88,3.16,1.09,1.28,3.38,4.69,4.72,5.94,9.28,11.53,10.94,10.78,12.84,14.53,14.53,13.62,14.53,15.38,13.94,10.66,9.41,10.28,10.19,8.69,8.59,10.25,11.0,9.47,7.81,8.69,9.19,8.03,6.28,7.62,10.0,10.56,10.12,10.56,11.88,11.31,8.31,6.56,6.69,6.31,4.19,3.06,5.12,8.03,9.38,9.75,12.44,15.31,16.31,16.34,17.88,20.41,21.75,21.16,20.81,22.62,23.72,22.38,21.09,21.88,22.25,20.03,16.78,15.88,16.19,15.5,14.06,14.28,16.16,16.56,14.62,13.47,14.28,15.12,13.78,13.06,14.69,16.09,15.34,12.75,11.78,11.72,10.59,8.62,8.75,11.06,12.56,12.16,11.84,13.22,14.09,12.47,10.66,11.53,13.0,12.47,10.59,10.78,11.5,10.84,8.59,8.56,10.66,12.84,13.38,15.22,19.19,22.44,22.78,22.38,23.66,24.47,23.84,22.06,22.47,24.34,25.16,23.88,23.5,24.06,23.47,20.19,17.09,16.69,16.88,15.5,14.12,15.75,17.59,17.59,16.22,16.47,17.78,18.16,16.56,16.22,18.03,19.03,17.25,16.06,16.62,16.88,14.59,11.53,11.22,12.03,11.44,9.97,10.59,11.75,11.78,9.94,9.62,11.34,12.78,12.38,12.75,15.5,18.28,18.53,17.78,18.12,18.59,16.91,13.38,11.97,11.91,11.0,8.66,7.84,9.25,10.47,9.47,8.84,10.56,12.78,12.59,12.12,13.72,16.09,16.41,15.09,15.31,16.72,16.66,14.22,12.66,12.41,11.53,8.28,5.78,6.19,7.59,7.62,7.12,9.03,11.59,12.28,11.31,11.97,13.81,14.78,13.91,14.12,16.69,18.56,18.41,17.97,19.69,20.78,19.28,16.47,15.25,15.12,13.75,11.38,11.44,13.53,14.84,13.69,12.91,13.81,14.0,12.06,10.19,11.09,12.84,12.69,11.81,12.75,14.12,13.94,12.03,11.78,12.88,13.69,12.03,10.88,11.78,12.56,10.72,9.12,9.53,10.44,9.84,8.53,9.25,11.56,12.5,11.88,12.09,13.91,15.19,13.41,12.41,13.16,13.78,12.19,10.62,11.5,13.62,13.75,13.06,14.28,16.66,17.62,16.88,17.38,19.28,20.12,18.34,16.62,17.25,17.91,15.91,14.12,14.59,15.78,14.88,13.12,13.25,14.03,13.88,12.03,11.53,12.81,14.25,13.75,13.84,16.03,18.25,17.72,16.31,16.94,17.81,17.34,15.31,15.09,15.72,14.91,12.0,10.34,10.94,11.69,10.59,10.56,12.72,15.12,15.38,14.5,15.56,17.25,16.78,15.12,14.66,15.66,15.44,12.75,11.28,12.03,12.62,10.78,9.34,10.12,11.0,9.81,8.59,9.75,12.03,12.69,11.38,11.91,13.34,14.19,12.81,12.25,13.47,14.06,12.03,9.94,9.84,10.22,8.56,6.66,7.09,8.88,9.53,8.97,9.41,11.56,12.0,10.09,8.84,10.0,11.09,9.81,8.69,9.47,11.03,9.78,7.78,7.78,8.41,7.5,5.31,4.69,6.0,6.62,5.56,5.75,8.31,10.41,9.91,9.16,10.28,12.16,12.28,12.34,14.31,16.72,17.25,15.69,15.03,15.72,15.75,13.41,11.91,12.5,13.38,12.44,11.72,12.88,15.0,15.34,14.78,15.91,18.38,19.03,17.25,16.41,17.59,17.81,16.25,15.72,17.62,19.94,19.66,19.44,21.09,23.56,24.09,23.66,24.94,27.25,28.06,26.47,25.12,25.0,23.75,20.31,18.06,18.22,19.22,18.06,16.47,16.81,17.53,16.53,15.44,16.72,19.97,22.59,23.25,24.34,26.28,27.38,25.84,24.47,24.81,25.5,23.72,21.69,21.59,22.81,22.47,21.16,21.31,23.0,23.41,22.12,21.59,23.44,24.44,22.5,20.81,20.88,21.38,20.03,19.03,19.91,22.19,22.62,21.94,22.44,24.12,24.66,22.94,22.03,22.84,23.0,20.72,18.53,18.56,19.41,18.78,17.78,18.5,20.19,20.38,18.62,18.47,19.72,20.47,19.31,18.56,19.72,20.47,18.72,16.81,17.12,17.97,16.62,14.81,14.53,15.59,14.94,13.25,12.94,14.0,14.16,12.62,11.97,13.62,15.69,15.75,15.34,17.19,19.28,19.0,18.28,19.25,22.22,23.78,23.38,23.56,24.62,24.0,20.81,18.25,18.19,18.78,17.56,16.72,18.19,20.03,19.91,18.44,18.38,19.47,18.97,16.5,14.94,15.38,15.06,12.78,11.78,13.53,15.53,15.31,14.69,15.47,16.78,15.88,13.91,13.25,14.25,13.75,11.62,11.06,12.88,14.56,14.28,14.47,16.47,18.0,16.75,14.72,14.06,14.53,13.47,11.66,11.66,13.06,13.09,11.06,9.97,11.12,11.56,10.19,9.38,10.84,12.5,12.41,11.53,12.69,14.03,13.38,11.53,10.81,11.44,11.25,9.91,9.66,11.62,13.62,13.38,12.66,13.88,15.31,14.69,13.75,15.28,17.56,18.69,18.06,18.28,20.12,20.53,19.59,19.25,20.88,22.12,20.56,18.84,18.66,18.84,17.5,15.78,16.28,18.09,18.12,16.97,17.66,20.06,21.56,21.47,21.62,23.28,24.06,21.69,19.06,18.34,17.66,15.0,11.97,10.88,10.97,10.16,8.5,8.25,10.16,11.41,11.03,11.59,14.94,17.53,18.34,18.97,20.56,22.94,22.97,22.44,23.62,25.88,26.66,25.53,25.19,26.19,26.22,24.38,23.12,23.81,24.38,22.53,19.69,18.53,17.66,14.88,11.69,10.47,11.34,11.81,11.19,12.12,14.72,16.28,15.59,14.53,15.56,16.53,15.16,13.56,14.31,15.97,16.5,16.06,17.25,19.31,19.75,18.31,17.31,17.88,17.31,14.31,11.19,10.5,10.25,8.56,6.84,6.78,7.22,5.56,2.16,0.62,1.16,1.88,1.66,3.22,7.28,10.47,11.44,12.03,14.84,17.56,17.84,17.53,18.75,21.19,22.25,22.0,22.75,24.41,23.69,20.59,17.97,17.91,17.84,16.56,15.09,16.34,17.44,16.38,14.72,14.94,17.19,17.94,17.69,18.94,21.53,22.91,21.44,20.25,20.66,20.34,17.81,15.69,16.12,17.56,17.38,16.34,16.38,17.31,16.0,13.06,11.5,12.28,12.66,11.47,11.47,13.5,15.34,15.16,14.66,16.5,18.69,19.16,18.28,19.28,20.78,20.38,18.03,16.5,16.19,15.19,12.25,10.28,10.69,11.28,9.81,8.59,9.88,12.03,12.84,12.62,13.88,15.66,15.38,13.09,12.28,13.91,15.41,15.03,14.94,15.88,15.41,12.16,8.41,7.09,7.69,7.84,7.25,9.0,12.0,13.22,12.25,11.62,12.72,13.19,11.91,11.59,14.22,16.78,17.16,16.62,17.44,18.34,17.06,14.06,12.0,10.78,8.84,5.75,4.34,5.44,6.56,6.47,7.03,10.31,13.88,15.5,15.78,17.47,19.34,19.28,17.97,18.09,19.59,20.38,18.88,17.91,18.75,18.91,16.56,13.84,13.5,12.91,10.53,7.44,7.03,7.91,7.75,6.38,6.88,8.78,9.59,9.03,9.56,12.59,15.5,16.69,17.59,20.66,23.28,22.97,21.38,21.28,21.75,20.59,18.03,16.5,16.22,14.84,11.22,8.53,8.94,9.84,9.38,9.53,11.91,14.47,14.28,12.66,12.81,13.62,13.53,12.25,12.5,14.72,16.59,16.28,16.47,18.25,18.94,16.59,12.62,11.16,9.66,6.56,3.28,2.16,2.47,1.94,0.69,1.19,3.53,4.97,4.31,3.78,5.41,6.62,5.72,4.22,5.66,7.5,7.62,7.09,8.81,10.91,11.88,10.5,10.0,10.94,11.28,9.75,8.47,9.88,11.41,10.97,10.25,11.91,13.53,12.75,9.94,8.44,8.44,7.5,5.47,5.0,6.59,7.56,6.69,6.25,8.69,11.06,11.41,10.62,11.56,12.34,10.88,7.47,5.5,4.62,3.28,0.81,0.16,2.25,4.44,5.0,5.41,7.97,9.75,9.16,7.28,7.38,8.25,7.94,6.56,6.88,8.66,9.31,7.81,6.81,7.53,7.97,6.44,4.81,6.22,8.0,7.47,6.06,6.56,7.88,7.31,5.72,6.0,8.0,9.22,8.31,7.84,9.16,9.44,7.31,4.91,4.44,4.47,3.12,1.53,2.31,4.81,5.91,5.41,5.75,7.34,7.47,5.34,3.41,3.44,3.44,1.47,0.03,1.41,3.62,4.62,4.88,7.25,10.69,12.16,12.25,13.28,15.62,16.84,15.97,15.66,17.34,18.84,18.28,17.16,18.38,19.78,19.12,17.16,16.88,17.75,17.44,16.38,16.41,18.41,19.28,17.84,16.28,16.84,17.44,15.72,13.72,13.69,13.75,11.75,8.44,6.44,5.56,3.34,0.22,-0.31,2.03,4.62,5.25,5.47,6.78,6.53,2.78,-1.59,-4.41,-5.97,-8.69,-11.75,-12.69,-11.47,-10.81,-11.56,-10.88,-7.78,-5.5,-5.56,-5.25,-3.06,-0.03,1.19,2.81,6.78,11.97,14.72,15.25,16.41,16.91,15.12,10.16,5.38,2.22,-1.47,-7.34,-12.69,-15.06,-16.41,-18.84,-20.66,-19.12,-15.28,-12.31,-9.62,-4.84,1.47,6.69,9.22,11.56,14.34,15.66,13.31,10.31,9.19,8.16,4.94,1.19,-0.78,-1.75,-4.47,-7.66,-8.69,-7.47,-6.09,18.44,18.44,17.0,16.06,17.34,19.06,19.56,19.28,19.88,20.59,20.12,18.59,18.69,20.03,21.19,20.91,20.59,22.09,22.88,22.06,21.03,21.59,22.34,21.78,20.47,20.66,21.5,21.31,20.03,19.62,20.5,20.47,18.62,17.75,18.19:1.28,3.38,4.69,4.72,5.94,9.28,11.53,10.94,10.78,12.84,14.53,14.53,13.62,14.53,15.38,13.94,10.66,9.41,10.28,10.19,8.69,8.59,10.25,11.0,9.47,7.81,8.69,9.19,8.03,6.28,7.62,10.0,10.56,10.12,10.56,11.88,11.31,8.31,6.56,6.69,6.31,4.19,3.06,5.12,8.03,9.38,9.75,12.44,15.31,16.31,16.34,17.88,20.41,21.75,21.16,20.81,22.62,23.72,22.38,21.09,21.88,22.25,20.03,16.78,15.88,16.19,15.5,14.06,14.28,16.16,16.56,14.62,13.47,14.28,15.12,13.78,13.06,14.69,16.09,15.34,12.75,11.78,11.72,10.59,8.62,8.75,11.06,12.56,12.16,11.84,13.22,14.09,12.47,10.66,11.53,13.0,12.47,10.59,10.78,11.5,10.84,8.59,8.56,10.66,12.84,13.38,15.22,19.19,22.44,22.78,22.38,23.66,24.47,23.84,22.06,22.47,24.34,25.16,23.88,23.5,24.06,23.47,20.19,17.09,16.69,16.88,15.5,14.12,15.75,17.59,17.59,16.22,16.47,17.78,18.16,16.56,16.22,18.03,19.03,17.25,16.06,16.62,16.88,14.59,11.53,11.22,12.03,11.44,9.97,10.59,11.75,11.78,9.94,9.62,11.34,12.78,12.38,12.75,15.5,18.28,18.53,17.78,18.12,18.59,16.91,13.38,11.97,11.91,11.0,8.66,7.84,9.25,10.47,9.47,8.84,10.56,12.78,12.59,12.12,13.72,16.09,16.41,15.09,15.31,16.72,16.66,14.22,12.66,12.41,11.53,8.28,5.78,6.19,7.59,7.62,7.12,9.03,11.59,12.28,11.31,11.97,13.81,14.78,13.91,14.12,16.69,18.56,18.41,17.97,19.69,20.78,19.28,16.47,15.25,15.12,13.75,11.38,11.44,13.53,14.84,13.69,12.91,13.81,14.0,12.06,10.19,11.09,12.84,12.69,11.81,12.75,14.12,13.94,12.03,11.78,12.88,13.69,12.03,10.88,11.78,12.56,10.72,9.12,9.53,10.44,9.84,8.53,9.25,11.56,12.5,11.88,12.09,13.91,15.19,13.41,12.41,13.16,13.78,12.19,10.62,11.5,13.62,13.75,13.06,14.28,16.66,17.62,16.88,17.38,19.28,20.12,18.34,16.62,17.25,17.91,15.91,14.12,14.59,15.78,14.88,13.12,13.25,14.03,13.88,12.03,11.53,12.81,14.25,13.75,13.84,16.03,18.25,17.72,16.31,16.94,17.81,17.34,15.31,15.09,15.72,14.91,12.0,10.34,10.94,11.69,10.59,10.56,12.72,15.12,15.38,14.5,15.56,17.25,16.78,15.12,14.66,15.66,15.44,12.75,11.28,12.03,12.62,10.78,9.34,10.12,11.0,9.81,8.59,9.75,12.03,12.69,11.38,11.91,13.34,14.19,12.81,12.25,13.47,14.06,12.03,9.94,9.84,10.22,8.56,6.66,7.09,8.88,9.53,8.97,9.41,11.56,12.0,10.09,8.84,10.0,11.09,9.81,8.69,9.47,11.03,9.78,7.78,7.78,8.41,7.5,5.31,4.69,6.0,6.62,5.56,5.75,8.31,10.41,9.91,9.16,10.28,12.16,12.28,12.34,14.31,16.72,17.25,15.69,15.03,15.72,15.75,13.41,11.91,12.5,13.38,12.44,11.72,12.88,15.0,15.34,14.78,15.91,18.38,19.03,17.25,16.41,17.59,17.81,16.25,15.72,17.62,19.94,19.66,19.44,21.09,23.56,24.09,23.66,24.94,27.25,28.06,26.47,25.12,25.0,23.75,20.31,18.06,18.22,19.22,18.06,16.47,16.81,17.53,16.53,15.44,16.72,19.97,22.59,23.25,24.34,26.28,27.38,25.84,24.47,24.81,25.5,23.72,21.69,21.59,22.81,22.47,21.16,21.31,23.0,23.41,22.12,21.59,23.44,24.44,22.5,20.81,20.88,21.38,20.03,19.03,19.91,22.19,22.62,21.94,22.44,24.12,24.66,22.94,22.03,22.84,23.0,20.72,18.53,18.56,19.41,18.78,17.78,18.5,20.19,20.38,18.62,18.47,19.72,20.47,19.31,18.56,19.72,20.47,18.72,16.81,17.12,17.97,16.62,14.81,14.53,15.59,14.94,13.25,12.94,14.0,14.16,12.62,11.97,13.62,15.69,15.75,15.34,17.19,19.28,19.0,18.28,19.25,22.22,23.78,23.38,23.56,24.62,24.0,20.81,18.25,18.19,18.78,17.56,16.72,18.19,20.03,19.91,18.44,18.38,19.47,18.97,16.5,14.94,15.38,15.06,12.78,11.78,13.53,15.53,15.31,14.69,15.47,16.78,15.88,13.91,13.25,14.25,13.75,11.62,11.06,12.88,14.56,14.28,14.47,16.47,18.0,16.75,14.72,14.06,14.53,13.47,11.66,11.66,13.06,13.09,11.06,9.97,11.12,11.56,10.19,9.38,10.84,12.5,12.41,11.53,12.69,14.03,13.38,11.53,10.81,11.44,11.25,9.91,9.66,11.62,13.62,13.38,12.66,13.88,15.31,14.69,13.75,15.28,17.56,18.69,18.06,18.28,20.12,20.53,19.59,19.25,20.88,22.12,20.56,18.84,18.66,18.84,17.5,15.78,16.28,18.09,18.12,16.97,17.66,20.06,21.56,21.47,21.62,23.28,24.06,21.69,19.06,18.34,17.66,15.0,11.97,10.88,10.97,10.16,8.5,8.25,10.16,11.41,11.03,11.59,14.94,17.53,18.34,18.97,20.56,22.94,22.97,22.44,23.62,25.88,26.66,25.53,25.19,26.19,26.22,24.38,23.12,23.81,24.38,22.53,19.69,18.53,17.66,14.88,11.69,10.47,11.34,11.81,11.19,12.12,14.72,16.28,15.59,14.53,15.56,16.53,15.16,13.56,14.31,15.97,16.5,16.06,17.25,19.31,19.75,18.31,17.31,17.88,17.31,14.31,11.19,10.5,10.25,8.56,6.84,6.78,7.22,5.56,2.16,0.62,1.16,1.88,1.66,3.22,7.28,10.47,11.44,12.03,14.84,17.56,17.84,17.53,18.75,21.19,22.25,22.0,22.75,24.41,23.69,20.59,17.97,17.91,17.84,16.56,15.09,16.34,17.44,16.38,14.72,14.94,17.19,17.94,17.69,18.94,21.53,22.91,21.44,20.25,20.66,20.34,17.81,15.69,16.12,17.56,17.38,16.34,16.38,17.31,16.0,13.06,11.5,12.28,12.66,11.47,11.47,13.5,15.34,15.16,14.66,16.5,18.69,19.16,18.28,19.28,20.78,20.38,18.03,16.5,16.19,15.19,12.25,10.28,10.69,11.28,9.81,8.59,9.88,12.03,12.84,12.62,13.88,15.66,15.38,13.09,12.28,13.91,15.41,15.03,14.94,15.88,15.41,12.16,8.41,7.09,7.69,7.84,7.25,9.0,12.0,13.22,12.25,11.62,12.72,13.19,11.91,11.59,14.22,16.78,17.16,16.62,17.44,18.34,17.06,14.06,12.0,10.78,8.84,5.75,4.34,5.44,6.56,6.47,7.03,10.31,13.88,15.5,15.78,17.47,19.34,19.28,17.97,18.09,19.59,20.38,18.88,17.91,18.75,18.91,16.56,13.84,13.5,12.91,10.53,7.44,7.03,7.91,7.75,6.38,6.88,8.78,9.59,9.03,9.56,12.59,15.5,16.69,17.59,20.66,23.28,22.97,21.38,21.28,21.75,20.59,18.03,16.5,16.22,14.84,11.22,8.53,8.94,9.84,9.38,9.53,11.91,14.47,14.28,12.66,12.81,13.62,13.53,12.25,12.5,14.72,16.59,16.28,16.47,18.25,18.94,16.59,12.62,11.16,9.66,6.56,3.28,2.16,2.47,1.94,0.69,1.19,3.53,4.97,4.31,3.78,5.41,6.62,5.72,4.22,5.66,7.5,7.62,7.09,8.81,10.91,11.88,10.5,10.0,10.94,11.28,9.75,8.47,9.88,11.41,10.97,10.25,11.91,13.53,12.75,9.94,8.44,8.44,7.5,5.47,5.0,6.59,7.56,6.69,6.25,8.69,11.06,11.41,10.62,11.56,12.34,10.88,7.47,5.5,4.62,3.28,0.81,0.16,2.25,4.44,5.0,5.41,7.97,9.75,9.16,7.28,7.38,8.25,7.94,6.56,6.88,8.66,9.31,7.81,6.81,7.53,7.97,6.44,4.81,6.22,8.0,7.47,6.06,6.56,7.88,7.31,5.72,6.0,8.0,9.22,8.31,7.84,9.16,9.44,7.31,4.91,4.44,4.47,3.12,1.53,2.31,4.81,5.91,5.41,5.75,7.34,7.47,5.34,3.41,3.44,3.44,1.47,0.03,1.41,3.62,4.62,4.88,7.25,10.69,12.16,12.25,13.28,15.62,16.84,15.97,15.66,17.34,18.84,18.28,17.16,18.38,19.78,19.12,17.16,16.88,17.75,17.44,16.38,16.41,18.41,19.28,17.84,16.28,16.84,17.44,15.72,13.72,13.69,13.75,11.75,8.44,6.44,5.56,3.34,0.22,-0.31,2.03,4.62,5.25,5.47,6.78,6.53,2.78,-1.59,-4.41,-5.97,-8.69,-11.75,-12.69,-11.47,-10.81,-11.56,-10.88,-7.78,-5.5,-5.56,-5.25,-3.06,-0.03,1.19,2.81,6.78,11.97,14.72,15.25,16.41,16.91,15.12,10.16,5.38,2.22,-1.47,-7.34,-12.69,-15.06,-16.41,-18.84,-20.66,-19.12,-15.28,-12.31,-9.62,-4.84,1.47,6.69,9.22,11.56,14.34,15.66,13.31,10.31,9.19,8.16,4.94,1.19,-0.78,-1.75,-4.47,-7.66,-8.69,-7.47,-6.09,18.44,18.44,17.0,16.06,17.34,19.06,19.56,19.28,19.88,20.59,20.12,18.59,18.69,20.03,21.19,20.91,20.59,22.09,22.88,22.06,21.03,21.59,22.34,21.78,20.47,20.66,21.5,21.31,20.03,19.62,20.5,20.47,18.62,17.75,18.19,19.0,18.31,17.47,18.31,19.16,18.62,17.53:negativity
19.22,17.97,15.53,12.31,10.91,12.78,14.78,15.44,16.5,20.38,23.91,25.28,26.0,28.38,31.38,31.66,30.66,30.09,30.66,29.31,25.72,22.84,21.94,20.41,17.06,14.5,14.56,15.25,15.19,14.62,16.66,19.84,21.75,21.62,22.22,23.69,23.91,22.34,21.53,22.88,24.03,22.94,20.41,19.66,19.56,18.94,18.06,19.44,22.38,24.25,23.91,23.94,25.78,26.69,25.09,23.16,22.84,22.69,20.53,18.38,19.12,21.81,23.94,25.03,27.38,30.06,30.94,28.66,26.19,25.53,25.0,22.78,21.03,22.28,24.91,25.91,25.62,27.19,29.31,30.31,29.53,29.16,30.56,31.31,29.06,27.0,27.38,28.03,26.62,24.5,24.0,23.78,22.47,19.81,19.81,21.16,22.47,21.41,20.88,22.5,23.44,22.66,21.16,21.97,23.25,22.31,20.16,20.03,20.97,20.22,18.66,18.34,19.62,20.16,18.31,16.97,17.0,17.84,16.72,15.91,17.5,19.81,20.5,19.22,19.88,21.75,22.81,22.25,22.75,25.0,26.19,24.91,23.44,24.25,25.38,24.19,22.22,21.94,22.28,20.84,17.75,16.28,16.56,16.53,14.5,13.5,14.16,15.56,14.47,13.97,15.88,18.47,18.81,17.25,17.09,17.91,17.47,15.69,15.28,16.81,17.75,16.62,15.41,16.88,18.88,18.75,18.22,19.16,21.5,21.88,20.88,20.53,21.88,21.53,18.62,16.16,15.81,15.66,13.41,11.59,12.19,14.0,13.5,12.5,13.28,15.59,16.88,17.28,19.16,23.06,26.16,26.59,26.56,27.44,27.25,23.69,19.69,18.03,18.19,17.16,15.84,16.38,18.47,19.03,17.53,16.72,18.38,19.66,18.66,18.31,20.22,22.19,21.88,20.22,20.19,21.28,20.53,18.69,17.47,18.0,17.31,13.81,11.38,11.41,12.16,11.41,11.22,13.44,16.69,17.75,17.94,19.03,21.41,22.03,20.34,19.59,20.75,21.34,19.72,18.91,20.41,22.03,21.62,20.62,21.78,23.88,24.81,24.94,26.81,30.31,32.62,31.75,30.44,30.31,29.06,24.62,20.53,18.28,16.66,13.75,10.69,10.69,13.09,14.28,14.25,15.25,18.38,20.5,20.78,21.69,24.72,27.0,26.34,24.56,24.41,24.25,21.97,18.66,16.97,17.0,16.41,14.44,13.72,15.22,16.16,14.91,14.09,15.59,17.44,17.03,15.78,16.03,17.44,16.66,14.22,13.38,14.78,15.69,15.53,16.31,19.72,22.53,22.78,22.06,23.16,24.16,22.88,19.97,18.69,18.62,17.38,14.88,13.94,15.59,16.28,14.47,12.38,12.47,12.47,10.69,8.75,9.66,11.5,11.75,10.62,11.0,13.53,15.06,15.22,16.19,19.0,21.53,21.44,20.44,21.34,22.06,20.25,17.03,15.25,14.62,12.5,8.91,7.22,8.59,10.0,10.69,12.94,17.97,22.91,25.25,26.28,28.78,31.03,30.72,28.88,28.22,28.72,27.56,24.28,21.75,21.16,19.47,15.41,11.72,10.75,10.41,9.25,8.22,10.38,13.78,16.06,16.91,18.5,21.47,23.22,22.62,22.59,24.91,26.78,26.53,25.66,27.0,29.0,28.28,26.22,25.19,25.06,23.19,19.75,18.25,18.38,18.25,16.16,14.81,16.03,17.75,17.94,17.19,18.38,19.44,18.28,15.62,14.31,14.66,14.31,12.34,11.31,13.06,14.97,14.75,15.0,16.97,19.09,19.38,18.78,20.34,22.94,24.03,23.03,23.03,24.5,25.84,25.16,25.22,27.25,29.03,27.66,25.34,24.88,24.84,22.75,20.22,19.44,19.91,19.34,17.03,15.78,16.94,17.78,16.34,15.38,15.91,17.22,16.09,14.34,14.81,15.75,15.28,12.97,12.22,12.97,12.88,10.75,9.53,10.91,12.5,12.66,12.62,14.59,16.5,15.44,12.88,11.78,11.69,11.06,9.84,10.25,13.09,14.81,14.12,13.22,14.12,15.38,14.88,15.19,17.66,21.12,22.53,22.25,22.53,23.62,22.88,20.19,19.09,20.16,21.69,21.72,21.62,22.84,23.22,21.06,17.31,15.19,15.03,13.72,11.78,11.66,14.16,16.34,16.47,16.72,18.78,20.44,19.47,18.16,18.88,20.66,20.62,19.38,19.69,21.19,20.75,18.44,16.81,16.62,16.16,14.0,12.78,14.06,16.12,16.34,15.94,17.06,19.0,19.06,18.0,18.5,20.41,20.78,19.09,17.31,17.12,16.56,14.0,12.03,12.12,13.62,13.72,13.12,14.41,17.03,18.19,17.75,18.56,21.22,22.75,21.66,20.31,20.16,19.78,17.06,13.81,12.44,12.5,10.91,8.66,8.44,10.44,11.94,12.38,14.38,18.81,22.41,23.59,23.25,24.03,24.41,22.5,19.78,18.78,19.59,19.69,19.12,20.25,23.28,25.25,24.97,24.62,25.5,26.38,24.31,21.5,20.81,20.81,19.34,17.69,17.28,18.62,18.53,16.91,15.97,17.19,17.78,16.06,14.59,15.16,16.31,15.5,13.78,13.66,14.16,12.41,9.59,7.84,8.0,7.53,5.25,3.94,5.22,7.12,7.81,8.88,12.28,15.88,17.22,17.0,17.59,18.59,17.84,15.5,14.09,15.22,15.62,14.72,13.97,15.31,16.78,15.19,13.0,12.22,11.97,10.25,7.97,7.06,8.25,8.53,7.47,7.84,10.53,13.0,13.28,12.84,13.91,15.41,14.47,12.47,11.94,12.19,11.03,8.56,7.53,8.56,9.0,7.78,7.0,8.19,9.31,8.72,7.69,8.94,11.06,12.03,12.0,12.88,14.59,15.09,13.34,12.41,13.59,14.59,13.41,12.38,13.56,14.62,14.03,12.66,13.41,15.12,15.34,13.75,13.28,14.22,14.19,12.62,12.12,14.06,16.5,16.62,16.53,18.25,20.16,19.91,18.5,18.47,19.38,19.0,16.94,16.0,17.19,18.59,17.91,17.22,18.41,19.53,17.91,15.47,15.34,16.19,15.97,14.03,13.94,15.62,17.03,16.91,18.19,21.09,23.12,22.53,20.97,20.78,21.06,19.81,17.31,16.91,18.06,17.44,15.12,14.0,14.91,15.66,14.56,14.22,16.09,17.75,16.28,13.78,12.69,12.38,10.75,8.69,8.97,11.22,12.81,12.44,13.12,15.81,18.0,18.19,18.09,19.34,20.38,19.12,16.94,16.47,17.22,16.75,14.66,14.09,15.19,15.81,14.78,14.69,16.62,18.47,18.31,17.97,19.34,21.31,21.47,19.78,19.34,19.97,19.22,16.75,15.81,17.91,20.19,20.78,22.09,24.81,27.06,26.25,23.62,22.66,22.88,20.91,17.88,15.75,15.28,13.94,11.06,9.41,10.94,13.28,13.56,14.16,16.41,19.22,19.38,18.31,18.81,20.31,20.34,18.84,18.66,20.62,22.12,21.75,21.47,23.25,25.16,23.97,22.56,23.25,24.97,24.94,23.84,23.75,24.78,24.31,21.59,19.94,20.53,21.12,19.56,17.78,18.78,20.47,19.59,18.25,18.78,20.22,19.88,17.91,17.44,19.12,20.28,19.44,19.47,22.34,24.81,25.38,25.66,27.62,29.94,29.16,26.44,24.66,24.09,21.94,18.47,16.22,16.59,17.19,15.91,15.44,17.62,19.75,19.06,17.38,17.34,18.84,18.97,18.44,20.09,23.84,26.09,26.31,26.69,28.66,29.56,28.34,26.31,26.62,27.31,25.47,23.31,22.78,23.47,22.34,19.81,18.62,20.0,21.12,21.16,22.34,26.31,29.72,30.19,29.62,30.03,30.72,29.28,26.47,25.88,27.31,27.59,26.09,25.03,26.09,26.34,24.16,22.59,23.75,25.44,25.25,24.19,24.69,25.72,24.56,21.31,20.16,20.91,21.5,21.25,21.88,24.53,26.56,25.25,22.78,22.25,22.41,20.72,18.38,18.72,20.44,20.06,18.12,16.75,17.59,17.69,16.94,16.72,20.06,23.56,24.91,25.66,27.75,30.16,29.88,28.59,28.38,29.91,30.09,27.97,26.53,27.0,26.88,24.66,22.69,23.19,24.91,24.81,23.75,25.09,27.44,28.12,27.12,27.22,28.88,29.34,27.66,26.5,27.03,27.56,25.84,23.75,24.0,25.0,24.03,22.09,22.19,23.91,24.44,23.31,23.22,24.81,25.28,23.34,21.97,23.38,25.47,26.19,26.25,28.28,30.28,30.09,27.44,26.19,26.84,26.56,25.12,25.44,28.47,31.56,31.91,31.88,33.16,34.19,32.66,30.16,29.91,31.59,31.94,30.75,30.91,32.06,31.38,28.22,25.59,26.0,27.12,27.03,27.38,29.97,32.59,33.34,32.28,32.88,34.25,34.25,31.88,30.53,31.19,31.38,29.62,27.84,29.0,30.34,29.38,28.16,28.53,29.84,28.84,25.72,24.34,24.28,23.84,22.22,21.97,24.28,26.72,26.28,25.16,26.0,27.09,26.22,24.88,25.69,28.03,28.91,28.0,27.72,28.66,28.47,25.12,22.31,22.03,22.88,22.16,21.94,24.06,26.91,27.41,26.84,27.56,29.53,31.28,30.84,31.88,34.97,37.16,37.03,36.09,36.84,37.03,34.78,31.44,30.25,30.34,29.91,28.88,29.81,32.53,33.75,32.19,30.31,29.69,29.03,26.59,24.66,25.47,28.06,28.97,28.69,29.59,31.22,31.41,29.81,29.53,30.91,31.84,30.59,29.19,30.34,31.56,30.22,28.22,28.25,29.28,29.09,28.75,30.53,33.56,35.34,34.31,32.78,32.34,31.25,27.5,24.44,24.09,24.84,23.81,22.81,24.09,26.31,27.66,27.19,28.03,30.31,32.0,32.06,32.81,35.56,38.59,38.84,37.97,38.5,39.56,38.09,35.84,34.78,34.97,33.91,31.16,29.16,29.03,28.72,26.03,23.91,24.03:15.44,16.5,20.38,23.91,25.28,26.0,28.38,31.38,31.66,30.66,30.09,30.66,29.31,25.72,22.84,21.94,20.41,17.06,14.5,14.56,15.25,15.19,14.62,16.66,19.84,21.75,21.62,22.22,23.69,23.91,22.34,21.53,22.88,24.03,22.94,20.41,19.66,19.56,18.94,18.06,19.44,22.38,24.25,23.91,23.94,25.78,26.69,25.09,23.16,22.84,22.69,20.53,18.38,19.12,21.81,23.94,25.03,27.38,30.06,30.94,28.66,26.19,25.53,25.0,22.78,21.03,22.28,24.91,25.91,25.62,27.19,29.31,30.31,29.53,29.16,30.56,31.31,29.06,27.0,27.38,28.03,26.62,24.5,24.0,23.78,22.47,19.81,19.81,21.16,22.47,21.41,20.88,22.5,23.44,22.66,21.16,21.97,23.25,22.31,20.16,20.03,20.97,20.22,18.66,18.34,19.62,20.16,18.31,16.97,17.0,17.84,16.72,15.91,17.5,19.81,20.5,19.22,19.88,21.75,22.81,22.25,22.75,25.0,26.19,24.91,23.44,24.25,25.38,24.19,22.22,21.94,22.28,20.84,17.75,16.28,16.56,16.53,14.5,13.5,14.16,15.56,14.47,13.97,15.88,18.47,18.81,17.25,17.09,17.91,17.47,15.69,15.28,16.81,17.75,16.62,15.41,16.88,18.88,18.75,18.22,19.16,21.5,21.88,20.88,20.53,21.88,21.53,18.62,16.16,15.81,15.66,13.41,11.59,12.19,14.0,13.5,12.5,13.28,15.59,16.88,17.28,19.16,23.06,26.16,26.59,26.56,27.44,27.25,23.69,19.69,18.03,18.19,17.16,15.84,16.38,18.47,19.03,17.53,16.72,18.38,19.66,18.66,18.31,20.22,22.19,21.88,20.22,20.19,21.28,20.53,18.69,17.47,18.0,17.31,13.81,11.38,11.41,12.16,11.41,11.22,13.44,16.69,17.75,17.94,19.03,21.41,22.03,20.34,19.59,20.75,21.34,19.72,18.91,20.41,22.03,21.62,20.62,21.78,23.88,24.81,24.94,26.81,30.31,32.62,31.75,30.44,30.31,29.06,24.62,20.53,18.28,16.66,13.75,10.69,10.69,13.09,14.28,14.25,15.25,18.38,20.5,20.78,21.69,24.72,27.0,26.34,24.56,24.41,24.25,21.97,18.66,16.97,17.0,16.41,14.44,13.72,15.22,16.16,14.91,14.09,15.59,17.44,17.03,15.78,16.03,17.44,16.66,14.22,13.38,14.78,15.69,15.53,16.31,19.72,22.53,22.78,22.06,23.16,24.16,22.88,19.97,18.69,18.62,17.38,14.88,13.94,15.59,16.28,14.47,12.38,12.47,12.47,10.69,8.75,9.66,11.5,11.75,10.62,11.0,13.53,15.06,15.22,16.19,19.0,21.53,21.44,20.44,21.34,22.06,20.25,17.03,15.25,14.62,12.5,8.91,7.22,8.59,10.0,10.69,12.94,17.97,22.91,25.25,26.28,28.78,31.03,30.72,28.88,28.22,28.72,27.56,24.28,21.75,21.16,19.47,15.41,11.72,10.75,10.41,9.25,8.22,10.38,13.78,16.06,16.91,18.5,21.47,23.22,22.62,22.59,24.91,26.78,26.53,25.66,27.0,29.0,28.28,26.22,25.19,25.06,23.19,19.75,18.25,18.38,18.25,16.16,14.81,16.03,17.75,17.94,17.19,18.38,19.44,18.28,15.62,14.31,14.66,14.31,12.34,11.31,13.06,14.97,14.75,15.0,16.97,19.09,19.38,18.78,20.34,22.94,24.03,23.03,23.03,24.5,25.84,25.16,25.22,27.25,29.03,27.66,25.34,24.88,24.84,22.75,20.22,19.44,19.91,19.34,17.03,15.78,16.94,17.78,16.34,15.38,15.91,17.22,16.09,14.34,14.81,15.75,15.28,12.97,12.22,12.97,12.88,10.75,9.53,10.91,12.5,12.66,12.62,14.59,16.5,15.44,12.88,11.78,11.69,11.06,9.84,10.25,13.09,14.81,14.12,13.22,14.12,15.38,14.88,15.19,17.66,21.12,22.53,22.25,22.53,23.62,22.88,20.19,19.09,20.16,21.69,21.72,21.62,22.84,23.22,21.06,17.31,15.19,15.03,13.72,11.78,11.66,14.16,16.34,16.47,16.72,18.78,20.44,19.47,18.16,18.88,20.66,20.62,19.38,19.69,21.19,20.75,18.44,16.81,16.62,16.16,14.0,12.78,14.06,16.12,16.34,15.94,17.06,19.0,19.06,18.0,18.5,20.41,20.78,19.09,17.31,17.12,16.56,14.0,12.03,12.12,13.62,13.72,13.12,14.41,17.03,18.19,17.75,18.56,21.22,22.75,21.66,20.31,20.16,19.78,17.06,13.81,12.44,12.5,10.91,8.66,8.44,10.44,11.94,12.38,14.38,18.81,22.41,23.59,23.25,24.03,24.41,22.5,19.78,18.78,19.59,19.69,19.12,20.25,23.28,25.25,24.97,24.62,25.5,26.38,24.31,21.5,20.81,20.81,19.34,17.69,17.28,18.62,18.53,16.91,15.97,17.19,17.78,16.06,14.59,15.16,16.31,15.5,13.78,13.66,14.16,12.41,9.59,7.84,8.0,7.53,5.25,3.94,5.22,7.12,7.81,8.88,12.28,15.88,17.22,17.0,17.59,18.59,17.84,15.5,14.09,15.22,15.62,14.72,13.97,15.31,16.78,15.19,13.0,12.22,11.97,10.25,7.97,7.06,8.25,8.53,7.47,7.84,10.53,13.0,13.28,12.84,13.91,15.41,14.47,12.47,11.94,12.19,11.03,8.56,7.53,8.56,9.0,7.78,7.0,8.19,9.31,8.72,7.69,8.94,11.06,12.03,12.0,12.88,14.59,15.09,13.34,12.41,13.59,14.59,13.41,12.38,13.56,14.62,14.03,12.66,13.41,15.12,15.34,13.75,13.28,14.22,14.19,12.62,12.12,14.06,16.5,16.62,16.53,18.25,20.16,19.91,18.5,18.47,19.38,19.0,16.94,16.0,17.19,18.59,17.91,17.22,18.41,19.53,17.91,15.47,15.34,16.19,15.97,14.03,13.94,15.62,17.03,16.91,18.19,21.09,23.12,22.53,20.97,20.78,21.06,19.81,17.31,16.91,18.06,17.44,15.12,14.0,14.91,15.66,14.56,14.22,16.09,17.75,16.28,13.78,12.69,12.38,10.75,8.69,8.97,11.22,12.81,12.44,13.12,15.81,18.0,18.19,18.09,19.34,20.38,19.12,16.94,16.47,17.22,16.75,14.66,14.09,15.19,15.81,14.78,14.69,16.62,18.47,18.31,17.97,19.34,21.31,21.47,19.78,19.34,19.97,19.22,16.75,15.81,17.91,20.19,20.78,22.09,24.81,27.06,26.25,23.62,22.66,22.88,20.91,17.88,15.75,15.28,13.94,11.06,9.41,10.94,13.28,13.56,14.16,16.41,19.22,19.38,18.31,18.81,20.31,20.34,18.84,18.66,20.62,22.12,21.75,21.47,23.25,25.16,23.97,22.56,23.25,24.97,24.94,23.84,23.75,24.78,24.31,21.59,19.94,20.53,21.12,19.56,17.78,18.78,20.47,19.59,18.25,18.78,20.22,19.88,17.91,17.44,19.12,20.28,19.44,19.47,22.34,24.81,25.38,25.66,27.62,29.94,29.16,26.44,24.66,24.09,21.94,18.47,16.22,16.59,17.19,15.91,15.44,17.62,19.75,19.06,17.38,17.34,18.84,18.97,18.44,20.09,23.84,26.09,26.31,26.69,28.66,29.56,28.34,26.31,26.62,27.31,25.47,23.31,22.78,23.47,22.34,19.81,18.62,20.0,21.12,21.16,22.34,26.31,29.72,30.19,29.62,30.03,30.72,29.28,26.47,25.88,27.31,27.59,26.09,25.03,26.09,26.34,24.16,22.59,23.75,25.44,25.25,24.19,24.69,25.72,24.56,21.31,20.16,20.91,21.5,21.25,21.88,24.53,26.56,25.25,22.78,22.25,22.41,20.72,18.38,18.72,20.44,20.06,18.12,16.75,17.59,17.69,16.94,16.72,20.06,23.56,24.91,25.66,27.75,30.16,29.88,28.59,28.38,29.91,30.09,27.97,26.53,27.0,26.88,24.66,22.69,23.19,24.91,24.81,23.75,25.09,27.44,28.12,27.12,27.22,28.88,29.34,27.66,26.5,27.03,27.56,25.84,23.75,24.0,25.0,24.03,22.09,22.19,23.91,24.44,23.31,23.22,24.81,25.28,23.34,21.97,23.38,25.47,26.19,26.25,28.28,30.28,30.09,27.44,26.19,26.84,26.56,25.12,25.44,28.47,31.56,31.91,31.88,33.16,34.19,32.66,30.16,29.91,31.59,31.94,30.75,30.91,32.06,31.38,28.22,25.59,26.0,27.12,27.03,27.38,29.97,32.59,33.34,32.28,32.88,34.25,34.25,31.88,30.53,31.19,31.38,29.62,27.84,29.0,30.34,29.38,28.16,28.53,29.84,28.84,25.72,24.34,24.28,23.84,22.22,21.97,24.28,26.72,26.28,25.16,26.0,27.09,26.22,24.88,25.69,28.03,28.91,28.0,27.72,28.66,28.47,25.12,22.31,22.03,22.88,22.16,21.94,24.06,26.91,27.41,26.84,27.56,29.53,31.28,30.84,31.88,34.97,37.16,37.03,36.09,36.84,37.03,34.78,31.44,30.25,30.34,29.91,28.88,29.81,32.53,33.75,32.19,30.31,29.69,29.03,26.59,24.66,25.47,28.06,28.97,28.69,29.59,31.22,31.41,29.81,29.53,30.91,31.84,30.59,29.19,30.34,31.56,30.22,28.22,28.25,29.28,29.09,28.75,30.53,33.56,35.34,34.31,32.78,32.34,31.25,27.5,24.44,24.09,24.84,23.81,22.81,24.09,26.31,27.66,27.19,28.03,30.31,32.0,32.06,32.81,35.56,38.59,38.84,37.97,38.5,39.56,38.09,35.84,34.78,34.97,33.91,31.16,29.16,29.03,28.72,26.03,23.91,24.03,25.91,24.88,23.19,21.94,21.94,24.19,25.66:31.38,31.66,30.66,30.09,30.66,29.31,25.72,22.84,21.94,20.41,17.06,14.5,14.56,15.25,15.19,14.62,16.66,19.84,21.75,21.62,22.22,23.69,23.91,22.34,21.53,22.88,24.03,22.94,20.41,19.66,19.56,18.94,18.06,19.44,22.38,24.25,23.91,23.94,25.78,26.69,25.09,23.16,22.84,22.69,20.53,18.38,19.12,21.81,23.94,25.03,27.38,30.06,30.94,28.66,26.19,25.53,25.0,22.78,21.03,22.28,24.91,25.91,25.62,27.19,29.31,30.31,29.53,29.16,30.56,31.31,29.06,27.0,27.38,28.03,26.62,24.5,24.0,23.78,22.47,19.81,19.81,21.16,22.47,21.41,20.88,22.5,23.44,22.66,21.16,21.97,23.25,22.31,20.16,20.03,20.97,20.22,18.66,18.34,19.62,20.16,18.31,16.97,17.0,17.84,16.72,15.91,17.5,19.81,20.5,19.22,19.88,21.75,22.81,22.25,22.75,25.0,26.19,24.91,23.44,24.25,25.38,24.19,22.22,21.94,22.28,20.84,17.75,16.28,16.56,16.53,14.5,13.5,14.16,15.56,14.47,13.97,15.88,18.47,18.81,17.25,17.09,17.91,17.47,15.69,15.28,16.81,17.75,16.62,15.41,16.88,18.88,18.75,18.22,19.16,21.5,21.88,20.88,20.53,21.88,21.53,18.62,16.16,15.81,15.66,13.41,11.59,12.19,14.0,13.5,12.5,13.28,15.59,16.88,17.28,19.16,23.06,26.16,26.59,26.56,27.44,27.25,23.69,19.69,18.03,18.19,17.16,15.84,16.38,18.47,19.03,17.53,16.72,18.38,19.66,18.66,18.31,20.22,22.19,21.88,20.22,20.19,21.28,20.53,18.69,17.47,18.0,17.31,13.81,11.38,11.41,12.16,11.41,11.22,13.44,16.69,17.75,17.94,19.03,21.41,22.03,20.34,19.59,20.75,21.34,19.72,18.91,20.41,22.03,21.62,20.62,21.78,23.88,24.81,24.94,26.81,30.31,32.62,31.75,30.44,30.31,29.06,24.62,20.53,18.28,16.66,13.75,10.69,10.69,13.09,14.28,14.25,15.25,18.38,20.5,20.78,21.69,24.72,27.0,26.34,24.56,24.41,24.25,21.97,18.66,16.97,17.0,16.41,14.44,13.72,15.22,16.16,14.91,14.09,15.59,17.44,17.03,15.78,16.03,17.44,16.66,14.22,13.38,14.78,15.69,15.53,16.31,19.72,22.53,22.78,22.06,23.16,24.16,22.88,19.97,18.69,18.62,17.38,14.88,13.94,15.59,16.28,14.47,12.38,12.47,12.47,10.69,8.75,9.66,11.5,11.75,10.62,11.0,13.53,15.06,15.22,16.19,19.0,21.53,21.44,20.44,21.34,22.06,20.25,17.03,15.25,14.62,12.5,8.91,7.22,8.59,10.0,10.69,12.94,17.97,22.91,25.25,26.28,28.78,31.03,30.72,28.88,28.22,28.72,27.56,24.28,21.75,21.16,19.47,15.41,11.72,10.75,10.41,9.25,8.22,10.38,13.78,16.06,16.91,18.5,21.47,23.22,22.62,22.59,24.91,26.78,26.53,25.66,27.0,29.0,28.28,26.22,25.19,25.06,23.19,19.75,18.25,18.38,18.25,16.16,14.81,16.03,17.75,17.94,17.19,18.38,19.44,18.28,15.62,14.31,14.66,14.31,12.34,11.31,13.06,14.97,14.75,15.0,16.97,19.09,19.38,18.78,20.34,22.94,24.03,23.03,23.03,24.5,25.84,25.16,25.22,27.25,29.03,27.66,25.34,24.88,24.84,22.75,20.22,19.44,19.91,19.34,17.03,15.78,16.94,17.78,16.34,15.38,15.91,17.22,16.09,14.34,14.81,15.75,15.28,12.97,12.22,12.97,12.88,10.75,9.53,10.91,12.5,12.66,12.62,14.59,16.5,15.44,12.88,11.78,11.69,11.06,9.84,10.25,13.09,14.81,14.12,13.22,14.12,15.38,14.88,15.19,17.66,21.12,22.53,22.25,22.53,23.62,22.88,20.19,19.09,20.16,21.69,21.72,21.62,22.84,23.22,21.06,17.31,15.19,15.03,13.72,11.78,11.66,14.16,16.34,16.47,16.72,18.78,20.44,19.47,18.16,18.88,20.66,20.62,19.38,19.69,21.19,20.75,18.44,16.81,16.62,16.16,14.0,12.78,14.06,16.12,16.34,15.94,17.06,19.0,19.06,18.0,18.5,20.41,20.78,19.09,17.31,17.12,16.56,14.0,12.03,12.12,13.62,13.72,13.12,14.41,17.03,18.19,17.75,18.56,21.22,22.75,21.66,20.31,20.16,19.78,17.06,13.81,12.44,12.5,10.91,8.66,8.44,10.44,11.94,12.38,14.38,18.81,22.41,23.59,23.25,24.03,24.41,22.5,19.78,18.78,19.59,19.69,19.12,20.25,23.28,25.25,24.97,24.62,25.5,26.38,24.31,21.5,20.81,20.81,19.34,17.69,17.28,18.62,18.53,16.91,15.97,17.19,17.78,16.06,14.59,15.16,16.31,15.5,13.78,13.66,14.16,12.41,9.59,7.84,8.0,7.53,5.25,3.94,5.22,7.12,7.81,8.88,12.28,15.88,17.22,17.0,17.59,18.59,17.84,15.5,14.09,15.22,15.62,14.72,13.97,15.31,16.78,15.19,13.0,12.22,11.97,10.25,7.97,7.06,8.25,8.53,7.47,7.84,10.53,13.0,13.28,12.84,13.91,15.41,14.47,12.47,11.94,12.19,11.03,8.56,7.53,8.56,9.0,7.78,7.0,8.19,9.31,8.72,7.69,8.94,11.06,12.03,12.0,12.88,14.59,15.09,13.34,12.41,13.59,14.59,13.41,12.38,13.56,14.62,14.03,12.66,13.41,15.12,15.34,13.75,13.28,14.22,14.19,12.62,12.12,14.06,16.5,16.62,16.53,18.25,20.16,19.91,18.5,18.47,19.38,19.0,16.94,16.0,17.19,18.59,17.91,17.22,18.41,19.53,17.91,15.47,15.34,16.19,15.97,14.03,13.94,15.62,17.03,16.91,18.19,21.09,23.12,22.53,20.97,20.78,21.06,19.81,17.31,16.91,18.06,17.44,15.12,14.0,14.91,15.66,14.56,14.22,16.09,17.75,16.28,13.78,12.69,12.38,10.75,8.69,8.97,11.22,12.81,12.44,13.12,15.81,18.0,18.19,18.09,19.34,20.38,19.12,16.94,16.47,17.22,16.75,14.66,14.09,15.19,15.81,14.78,14.69,16.62,18.47,18.31,17.97,19.34,21.31,21.47,19.78,19.34,19.97,19.22,16.75,15.81,17.91,20.19,20.78,22.09,24.81,27.06,26.25,23.62,22.66,22.88,20.91,17.88,15.75,15.28,13.94,11.06,9.41,10.94,13.28,13.56,14.16,16.41,19.22,19.38,18.31,18.81,20.31,20.34,18.84,18.66,20.62,22.12,21.75,21.47,23.25,25.16,23.97,22.56,23.25,24.97,24.94,23.84,23.75,24.78,24.31,21.59,19.94,20.53,21.12,19.56,17.78,18.78,20.47,19.59,18.25,18.78,20.22,19.88,17.91,17.44,19.12,20.28,19.44,19.47,22.34,24.81,25.38,25.66,27.62,29.94,29.16,26.44,24.66,24.09,21.94,18.47,16.22,16.59,17.19,15.91,15.44,17.62,19.75,19.06,17.38,17.34,18.84,18.97,18.44,20.09,23.84,26.09,26.31,26.69,28.66,29.56,28.34,26.31,26.62,27.31,25.47,23.31,22.78,23.47,22.34,19.81,18.62,20.0,21.12,21.16,22.34,26.31,29.72,30.19,29.62,30.03,30.72,29.28,26.47,25.88,27.31,27.59,26.09,25.03,26.09,26.34,24.16,22.59,23.75,25.44,25.25,24.19,24.69,25.72,24.56,21.31,20.16,20.91,21.5,21.25,21.88,24.53,26.56,25.25,22.78,22.25,22.41,20.72,18.38,18.72,20.44,20.06,18.12,16.75,17.59,17.69,16.94,16.72,20.06,23.56,24.91,25.66,27.75,30.16,29.88,28.59,28.38,29.91,30.09,27.97,26.53,27.0,26.88,24.66,22.69,23.19,24.91,24.81,23.75,25.09,27.44,28.12,27.12,27.22,28.88,29.34,27.66,26.5,27.03,27.56,25.84,23.75,24.0,25.0,24.03,22.09,22.19,23.91,24.44,23.31,23.22,24.81,25.28,23.34,21.97,23.38,25.47,26.19,26.25,28.28,30.28,30.09,27.44,26.19,26.84,26.56,25.12,25.44,28.47,31.56,31.91,31.88,33.16,34.19,32.66,30.16,29.91,31.59,31.94,30.75,30.91,32.06,31.38,28.22,25.59,26.0,27.12,27.03,27.38,29.97,32.59,33.34,32.28,32.88,34.25,34.25,31.88,30.53,31.19,31.38,29.62,27.84,29.0,30.34,29.38,28.16,28.53,29.84,28.84,25.72,24.34,24.28,23.84,22.22,21.97,24.28,26.72,26.28,25.16,26.0,27.09,26.22,24.88,25.69,28.03,28.91,28.0,27.72,28.66,28.47,25.12,22.31,22.03,22.88,22.16,21.94,24.06,26.91,27.41,26.84,27.56,29.53,31.28,30.84,31.88,34.97,37.16,37.03,36.09,36.84,37.03,34.78,31.44,30.25,30.34,29.91,28.88,29.81,32.53,33.75,32.19,30.31,29.69,29.03,26.59,24.66,25.47,28.06,28.97,28.69,29.59,31.22,31.41,29.81,29.53,30.91,31.84,30.59,29.19,30.34,31.56,30.22,28.22,28.25,29.28,29.09,28.75,30.53,33.56,35.34,34.31,32.78,32.34,31.25,27.5,24.44,24.09,24.84,23.81,22.81,24.09,26.31,27.66,27.19,28.03,30.31,32.0,32.06,32.81,35.56,38.59,38.84,37.97,38.5,39.56,38.09,35.84,34.78,34.97,33.91,31.16,29.16,29.03,28.72,26.03,23.91,24.03,25.91,24.88,23.19,21.94,21.94,24.19,25.66,26.12,26.81,29.28,31.56,32.41,32.91,34.5:22.84,21.94,20.41,17.06,14.5,14.56,15.25,15.19,14.62,16.66,19.84,21.75,21.62,22.22,23.69,23.91,22.34,21.53,22.88,24.03,22.94,20.41,19.66,19.56,18.94,18.06,19.44,22.38,24.25,23.91,23.94,25.78,26.69,25.09,23.16,22.84,22.69,20.53,18.38,19.12,21.81,23.94,25.03,27.38,30.06,30.94,28.66,26.19,25.53,25.0,22.78,21.03,22.28,24.91,25.91,25.62,27.19,29.31,30.31,29.53,29.16,30.56,31.31,29.06,27.0,27.38,28.03,26.62,24.5,24.0,23.78,22.47,19.81,19.81,21.16,22.47,21.41,20.88,22.5,23.44,22.66,21.16,21.97,23.25,22.31,20.16,20.03,20.97,20.22,18.66,18.34,19.62,20.16,18.31,16.97,17.0,17.84,16.72,15.91,17.5,19.81,20.5,19.22,19.88,21.75,22.81,22.25,22.75,25.0,26.19,24.91,23.44,24.25,25.38,24.19,22.22,21.94,22.28,20.84,17.75,16.28,16.56,16.53,14.5,13.5,14.16,15.56,14.47,13.97,15.88,18.47,18.81,17.25,17.09,17.91,17.47,15.69,15.28,16.81,17.75,16.62,15.41,16.88,18.88,18.75,18.22,19.16,21.5,21.88,20.88,20.53,21.88,21.53,18.62,16.16,15.81,15.66,13.41,11.59,12.19,14.0,13.5,12.5,13.28,15.59,16.88,17.28,19.16,23.06,26.16,26.59,26.56,27.44,27.25,23.69,19.69,18.03,18.19,17.16,15.84,16.38,18.47,19.03,17.53,16.72,18.38,19.66,18.66,18.31,20.22,22.19,21.88,20.22,20.19,21.28,20.53,18.69,17.47,18.0,17.31,13.81,11.38,11.41,12.16,11.41,11.22,13.44,16.69,17.75,17.94,19.03,21.41,22.03,20.34,19.59,20.75,21.34,19.72,18.91,20.41,22.03,21.62,20.62,21.78,23.88,24.81,24.94,26.81,30.31,32.62,31.75,30.44,30.31,29.06,24.62,20.53,18.28,16.66,13.75,10.69,10.69,13.09,14.28,14.25,15.25,18.38,20.5,20.78,21.69,24.72,27.0,26.34,24.56,24.41,24.25,21.97,18.66,16.97,17.0,16.41,14.44,13.72,15.22,16.16,14.91,14.09,15.59,17.44,17.03,15.78,16.03,17.44,16.66,14.22,13.38,14.78,15.69,15.53,16.31,19.72,22.53,22.78,22.06,23.16,24.16,22.88,19.97,18.69,18.62,17.38,14.88,13.94,15.59,16.28,14.47,12.38,12.47,12.47,10.69,8.75,9.66,11.5,11.75,10.62,11.0,13.53,15.06,15.22,16.19,19.0,21.53,21.44,20.44,21.34,22.06,20.25,17.03,15.25,14.62,12.5,8.91,7.22,8.59,10.0,10.69,12.94,17.97,22.91,25.25,26.28,28.78,31.03,30.72,28.88,28.22,28.72,27.56,24.28,21.75,21.16,19.47,15.41,11.72,10.75,10.41,9.25,8.22,10.38,13.78,16.06,16.91,18.5,21.47,23.22,22.62,22.59,24.91,26.78,26.53,25.66,27.0,29.0,28.28,26.22,25.19,25.06,23.19,19.75,18.25,18.38,18.25,16.16,14.81,16.03,17.75,17.94,17.19,18.38,19.44,18.28,15.62,14.31,14.66,14.31,12.34,11.31,13.06,14.97,14.75,15.0,16.97,19.09,19.38,18.78,20.34,22.94,24.03,23.03,23.03,24.5,25.84,25.16,25.22,27.25,29.03,27.66,25.34,24.88,24.84,22.75,20.22,19.44,19.91,19.34,17.03,15.78,16.94,17.78,16.34,15.38,15.91,17.22,16.09,14.34,14.81,15.75,15.28,12.97,12.22,12.97,12.88,10.75,9.53,10.91,12.5,12.66,12.62,14.59,16.5,15.44,12.88,11.78,11.69,11.06,9.84,10.25,13.09,14.81,14.12,13.22,14.12,15.38,14.88,15.19,17.66,21.12,22.53,22.25,22.53,23.62,22.88,20.19,19.09,20.16,21.69,21.72,21.62,22.84,23.22,21.06,17.31,15.19,15.03,13.72,11.78,11.66,14.16,16.34,16.47,16.72,18.78,20.44,19.47,18.16,18.88,20.66,20.62,19.38,19.69,21.19,20.75,18.44,16.81,16.62,16.16,14.0,12.78,14.06,16.12,16.34,15.94,17.06,19.0,19.06,18.0,18.5,20.41,20.78,19.09,17.31,17.12,16.56,14.0,12.03,12.12,13.62,13.72,13.12,14.41,17.03,18.19,17.75,18.56,21.22,22.75,21.66,20.31,20.16,19.78,17.06,13.81,12.44,12.5,10.91,8.66,8.44,10.44,11.94,12.38,14.38,18.81,22.41,23.59,23.25,24.03,24.41,22.5,19.78,18.78,19.59,19.69,19.12,20.25,23.28,25.25,24.97,24.62,25.5,26.38,24.31,21.5,20.81,20.81,19.34,17.69,17.28,18.62,18.53,16.91,15.97,17.19,17.78,16.06,14.59,15.16,16.31,15.5,13.78,13.66,14.16,12.41,9.59,7.84,8.0,7.53,5.25,3.94,5.22,7.12,7.81,8.88,12.28,15.88,17.22,17.0,17.59,18.59,17.84,15.5,14.09,15.22,15.62,14.72,13.97,15.31,16.78,15.19,13.0,12.22,11.97,10.25,7.97,7.06,8.25,8.53,7.47,7.84,10.53,13.0,13.28,12.84,13.91,15.41,14.47,12.47,11.94,12.19,11.03,8.56,7.53,8.56,9.0,7.78,7.0,8.19,9.31,8.72,7.69,8.94,11.06,12.03,12.0,12.88,14.59,15.09,13.34,12.41,13.59,14.59,13.41,12.38,13.56,14.62,14.03,12.66,13.41,15.12,15.34,13.75,13.28,14.22,14.19,12.62,12.12,14.06,16.5,16.62,16.53,18.25,20.16,19.91,18.5,18.47,19.38,19.0,16.94,16.0,17.19,18.59,17.91,17.22,18.41,19.53,17.91,15.47,15.34,16.19,15.97,14.03,13.94,15.62,17.03,16.91,18.19,21.09,23.12,22.53,20.97,20.78,21.06,19.81,17.31,16.91,18.06,17.44,15.12,14.0,14.91,15.66,14.56,14.22,16.09,17.75,16.28,13.78,12.69,12.38,10.75,8.69,8.97,11.22,12.81,12.44,13.12,15.81,18.0,18.19,18.09,19.34,20.38,19.12,16.94,16.47,17.22,16.75,14.66,14.09,15.19,15.81,14.78,14.69,16.62,18.47,18.31,17.97,19.34,21.31,21.47,19.78,19.34,19.97,19.22,16.75,15.81,17.91,20.19,20.78,22.09,24.81,27.06,26.25,23.62,22.66,22.88,20.91,17.88,15.75,15.28,13.94,11.06,9.41,10.94,13.28,13.56,14.16,16.41,19.22,19.38,18.31,18.81,20.31,20.34,18.84,18.66,20.62,22.12,21.75,21.47,23.25,25.16,23.97,22.56,23.25,24.97,24.94,23.84,23.75,24.78,24.31,21.59,19.94,20.53,21.12,19.56,17.78,18.78,20.47,19.59,18.25,18.78,20.22,19.88,17.91,17.44,19.12,20.28,19.44,19.47,22.34,24.81,25.38,25.66,27.62,29.94,29.16,26.44,24.66,24.09,21.94,18.47,16.22,16.59,17.19,15.91,15.44,17.62,19.75,19.06,17.38,17.34,18.84,18.97,18.44,20.09,23.84,26.09,26.31,26.69,28.66,29.56,28.34,26.31,26.62,27.31,25.47,23.31,22.78,23.47,22.34,19.81,18.62,20.0,21.12,21.16,22.34,26.31,29.72,30.19,29.62,30.03,30.72,29.28,26.47,25.88,27.31,27.59,26.09,25.03,26.09,26.34,24.16,22.59,23.75,25.44,25.25,24.19,24.69,25.72,24.56,21.31,20.16,20.91,21.5,21.25,21.88,24.53,26.56,25.25,22.78,22.25,22.41,20.72,18.38,18.72,20.44,20.06,18.12,16.75,17.59,17.69,16.94,16.72,20.06,23.56,24.91,25.66,27.75,30.16,29.88,28.59,28.38,29.91,30.09,27.97,26.53,27.0,26.88,24.66,22.69,23.19,24.91,24.81,23.75,25.09,27.44,28.12,27.12,27.22,28.88,29.34,27.66,26.5,27.03,27.56,25.84,23.75,24.0,25.0,24.03,22.09,22.19,23.91,24.44,23.31,23.22,24.81,25.28,23.34,21.97,23.38,25.47,26.19,26.25,28.28,30.28,30.09,27.44,26.19,26.84,26.56,25.12,25.44,28.47,31.56,31.91,31.88,33.16,34.19,32.66,30.16,29.91,31.59,31.94,30.75,30.91,32.06,31.38,28.22,25.59,26.0,27.12,27.03,27.38,29.97,32.59,33.34,32.28,32.88,34.25,34.25,31.88,30.53,31.19,31.38,29.62,27.84,29.0,30.34,29.38,28.16,28.53,29.84,28.84,25.72,24.34,24.28,23.84,22.22,21.97,24.28,26.72,26.28,25.16,26.0,27.09,26.22,24.88,25.69,28.03,28.91,28.0,27.72,28.66,28.47,25.12,22.31,22.03,22.88,22.16,21.94,24.06,26.91,27.41,26.84,27.56,29.53,31.28,30.84,31.88,34.97,37.16,37.03,36.09,36.84,37.03,34.78,31.44,30.25,30.34,29.91,28.88,29.81,32.53,33.75,32.19,30.31,29.69,29.03,26.59,24.66,25.47,28.06,28.97,28.69,29.59,31.22,31.41,29.81,29.53,30.91,31.84,30.59,29.19,30.34,31.56,30.22,28.22,28.25,29.28,29.09,28.75,30.53,33.56,35.34,34.31,32.78,32.34,31.25,27.5,24.44,24.09,24.84,23.81,22.81,24.09,26.31,27.66,27.19,28.03,30.31,32.0,32.06,32.81,35.56,38.59,38.84,37.97,38.5,39.56,38.09,35.84,34.78,34.97,33.91,31.16,29.16,29.03,28.72,26.03,23.91,24.03,25.91,24.88,23.19,21.94,21.94,24.19,25.66,26.12,26.81,29.28,31.56,32.41,32.91,34.5,36.25,36.69,36.41,37.12,38.56,38.75,37.41:15.19,14.62,16.66,19.84,21.75,21.62,22.22,23.69,23.91,22.34,21.53,22.88,24.03,22.94,20.41,19.66,19.56,18.94,18.06,19.44,22.38,24.25,23.91,23.94,25.78,26.69,25.09,23.16,22.84,22.69,20.53,18.38,19.12,21.81,23.94,25.03,27.38,30.06,30.94,28.66,26.19,25.53,25.0,22.78,21.03,22.28,24.91,25.91,25.62,27.19,29.31,30.31,29.53,29.16,30.56,31.31,29.06,27.0,27.38,28.03,26.62,24.5,24.0,23.78,22.47,19.81,19.81,21.16,22.47,21.41,20.88,22.5,23.44,22.66,21.16,21.97,23.25,22.31,20.16,20.03,20.97,20.22,18.66,18.34,19.62,20.16,18.31,16.97,17.0,17.84,16.72,15.91,17.5,19.81,20.5,19.22,19.88,21.75,22.81,22.25,22.75,25.0,26.19,24.91,23.44,24.25,25.38,24.19,22.22,21.94,22.28,20.84,17.75,16.28,16.56,16.53,14.5,13.5,14.16,15.56,14.47,13.97,15.88,18.47,18.81,17.25,17.09,17.91,17.47,15.69,15.28,16.81,17.75,16.62,15.41,16.88,18.88,18.75,18.22,19.16,21.5,21.88,20.88,20.53,21.88,21.53,18.62,16.16,15.81,15.66,13.41,11.59,12.19,14.0,13.5,12.5,13.28,15.59,16.88,17.28,19.16,23.06,26.16,26.59,26.56,27.44,27.25,23.69,19.69,18.03,18.19,17.16,15.84,16.38,18.47,19.03,17.53,16.72,18.38,19.66,18.66,18.31,20.22,22.19,21.88,20.22,20.19,21.28,20.53,18.69,17.47,18.0,17.31,13.81,11.38,11.41,12.16,11.41,11.22,13.44,16.69,17.75,17.94,19.03,21.41,22.03,20.34,19.59,20.75,21.34,19.72,18.91,20.41,22.03,21.62,20.62,21.78,23.88,24.81,24.94,26.81,30.31,32.62,31.75,30.44,30.31,29.06,24.62,20.53,18.28,16.66,13.75,10.69,10.69,13.09,14.28,14.25,15.25,18.38,20.5,20.78,21.69,24.72,27.0,26.34,24.56,24.41,24.25,21.97,18.66,16.97,17.0,16.41,14.44,13.72,15.22,16.16,14.91,14.09,15.59,17.44,17.03,15.78,16.03,17.44,16.66,14.22,13.38,14.78,15.69,15.53,16.31,19.72,22.53,22.78,22.06,23.16,24.16,22.88,19.97,18.69,18.62,17.38,14.88,13.94,15.59,16.28,14.47,12.38,12.47,12.47,10.69,8.75,9.66,11.5,11.75,10.62,11.0,13.53,15.06,15.22,16.19,19.0,21.53,21.44,20.44,21.34,22.06,20.25,17.03,15.25,14.62,12.5,8.91,7.22,8.59,10.0,10.69,12.94,17.97,22.91,25.25,26.28,28.78,31.03,30.72,28.88,28.22,28.72,27.56,24.28,21.75,21.16,19.47,15.41,11.72,10.75,10.41,9.25,8.22,10.38,13.78,16.06,16.91,18.5,21.47,23.22,22.62,22.59,24.91,26.78,26.53,25.66,27.0,29.0,28.28,26.22,25.19,25.06,23.19,19.75,18.25,18.38,18.25,16.16,14.81,16.03,17.75,17.94,17.19,18.38,19.44,18.28,15.62,14.31,14.66,14.31,12.34,11.31,13.06,14.97,14.75,15.0,16.97,19.09,19.38,18.78,20.34,22.94,24.03,23.03,23.03,24.5,25.84,25.16,25.22,27.25,29.03,27.66,25.34,24.88,24.84,22.75,20.22,19.44,19.91,19.34,17.03,15.78,16.94,17.78,16.34,15.38,15.91,17.22,16.09,14.34,14.81,15.75,15.28,12.97,12.22,12.97,12.88,10.75,9.53,10.91,12.5,12.66,12.62,14.59,16.5,15.44,12.88,11.78,11.69,11.06,9.84,10.25,13.09,14.81,14.12,13.22,14.12,15.38,14.88,15.19,17.66,21.12,22.53,22.25,22.53,23.62,22.88,20.19,19.09,20.16,21.69,21.72,21.62,22.84,23.22,21.06,17.31,15.19,15.03,13.72,11.78,11.66,14.16,16.34,16.47,16.72,18.78,20.44,19.47,18.16,18.88,20.66,20.62,19.38,19.69,21.19,20.75,18.44,16.81,16.62,16.16,14.0,12.78,14.06,16.12,16.34,15.94,17.06,19.0,19.06,18.0,18.5,20.41,20.78,19.09,17.31,17.12,16.56,14.0,12.03,12.12,13.62,13.72,13.12,14.41,17.03,18.19,17.75,18.56,21.22,22.75,21.66,20.31,20.16,19.78,17.06,13.81,12.44,12.5,10.91,8.66,8.44,10.44,11.94,12.38,14.38,18.81,22.41,23.59,23.25,24.03,24.41,22.5,19.78,18.78,19.59,19.69,19.12,20.25,23.28,25.25,24.97,24.62,25.5,26.38,24.31,21.5,20.81,20.81,19.34,17.69,17.28,18.62,18.53,16.91,15.97,17.19,17.78,16.06,14.59,15.16,16.31,15.5,13.78,13.66,14.16,12.41,9.59,7.84,8.0,7.53,5.25,3.94,5.22,7.12,7.81,8.88,12.28,15.88,17.22,17.0,17.59,18.59,17.84,15.5,14.09,15.22,15.62,14.72,13.97,15.31,16.78,15.19,13.0,12.22,11.97,10.25,7.97,7.06,8.25,8.53,7.47,7.84,10.53,13.0,13.28,12.84,13.91,15.41,14.47,12.47,11.94,12.19,11.03,8.56,7.53,8.56,9.0,7.78,7.0,8.19,9.31,8.72,7.69,8.94,11.06,12.03,12.0,12.88,14.59,15.09,13.34,12.41,13.59,14.59,13.41,12.38,13.56,14.62,14.03,12.66,13.41,15.12,15.34,13.75,13.28,14.22,14.19,12.62,12.12,14.06,16.5,16.62,16.53,18.25,20.16,19.91,18.5,18.47,19.38,19.0,16.94,16.0,17.19,18.59,17.91,17.22,18.41,19.53,17.91,15.47,15.34,16.19,15.97,14.03,13.94,15.62,17.03,16.91,18.19,21.09,23.12,22.53,20.97,20.78,21.06,19.81,17.31,16.91,18.06,17.44,15.12,14.0,14.91,15.66,14.56,14.22,16.09,17.75,16.28,13.78,12.69,12.38,10.75,8.69,8.97,11.22,12.81,12.44,13.12,15.81,18.0,18.19,18.09,19.34,20.38,19.12,16.94,16.47,17.22,16.75,14.66,14.09,15.19,15.81,14.78,14.69,16.62,18.47,18.31,17.97,19.34,21.31,21.47,19.78,19.34,19.97,19.22,16.75,15.81,17.91,20.19,20.78,22.09,24.81,27.06,26.25,23.62,22.66,22.88,20.91,17.88,15.75,15.28,13.94,11.06,9.41,10.94,13.28,13.56,14.16,16.41,19.22,19.38,18.31,18.81,20.31,20.34,18.84,18.66,20.62,22.12,21.75,21.47,23.25,25.16,23.97,22.56,23.25,24.97,24.94,23.84,23.75,24.78,24.31,21.59,19.94,20.53,21.12,19.56,17.78,18.78,20.47,19.59,18.25,18.78,20.22,19.88,17.91,17.44,19.12,20.28,19.44,19.47,22.34,24.81,25.38,25.66,27.62,29.94,29.16,26.44,24.66,24.09,21.94,18.47,16.22,16.59,17.19,15.91,15.44,17.62,19.75,19.06,17.38,17.34,18.84,18.97,18.44,20.09,23.84,26.09,26.31,26.69,28.66,29.56,28.34,26.31,26.62,27.31,25.47,23.31,22.78,23.47,22.34,19.81,18.62,20.0,21.12,21.16,22.34,26.31,29.72,30.19,29.62,30.03,30.72,29.28,26.47,25.88,27.31,27.59,26.09,25.03,26.09,26.34,24.16,22.59,23.75,25.44,25.25,24.19,24.69,25.72,24.56,21.31,20.16,20.91,21.5,21.25,21.88,24.53,26.56,25.25,22.78,22.25,22.41,20.72,18.38,18.72,20.44,20.06,18.12,16.75,17.59,17.69,16.94,16.72,20.06,23.56,24.91,25.66,27.75,30.16,29.88,28.59,28.38,29.91,30.09,27.97,26.53,27.0,26.88,24.66,22.69,23.19,24.91,24.81,23.75,25.09,27.44,28.12,27.12,27.22,28.88,29.34,27.66,26.5,27.03,27.56,25.84,23.75,24.0,25.0,24.03,22.09,22.19,23.91,24.44,23.31,23.22,24.81,25.28,23.34,21.97,23.38,25.47,26.19,26.25,28.28,30.28,30.09,27.44,26.19,26.84,26.56,25.12,25.44,28.47,31.56,31.91,31.88,33.16,34.19,32.66,30.16,29.91,31.59,31.94,30.75,30.91,32.06,31.38,28.22,25.59,26.0,27.12,27.03,27.38,29.97,32.59,33.34,32.28,32.88,34.25,34.25,31.88,30.53,31.19,31.38,29.62,27.84,29.0,30.34,29.38,28.16,28.53,29.84,28.84,25.72,24.34,24.28,23.84,22.22,21.97,24.28,26.72,26.28,25.16,26.0,27.09,26.22,24.88,25.69,28.03,28.91,28.0,27.72,28.66,28.47,25.12,22.31,22.03,22.88,22.16,21.94,24.06,26.91,27.41,26.84,27.56,29.53,31.28,30.84,31.88,34.97,37.16,37.03,36.09,36.84,37.03,34.78,31.44,30.25,30.34,29.91,28.88,29.81,32.53,33.75,32.19,30.31,29.69,29.03,26.59,24.66,25.47,28.06,28.97,28.69,29.59,31.22,31.41,29.81,29.53,30.91,31.84,30.59,29.19,30.34,31.56,30.22,28.22,28.25,29.28,29.09,28.75,30.53,33.56,35.34,34.31,32.78,32.34,31.25,27.5,24.44,24.09,24.84,23.81,22.81,24.09,26.31,27.66,27.19,28.03,30.31,32.0,32.06,32.81,35.56,38.59,38.84,37.97,38.5,39.56,38.09,35.84,34.78,34.97,33.91,31.16,29.16,29.03,28.72,26.03,23.91,24.03,25.91,24.88,23.19,21.94,21.94,24.19,25.66,26.12,26.81,29.28,31.56,32.41,32.91,34.5,36.25,36.69,36.41,37.12,38.56,38.75,37.41,36.47,36.25,35.03,32.53,30.16,29.22,28.84:23.69,23.91,22.34,21.53,22.88,24.03,22.94,20.41,19.66,19.56,18.94,18.06,19.44,22.38,24.25,23.91,23.94,25.78,26.69,25.09,23.16,22.84,22.69,20.53,18.38,19.12,21.81,23.94,25.03,27.38,30.06,30.94,28.66,26.19,25.53,25.0,22.78,21.03,22.28,24.91,25.91,25.62,27.19,29.31,30.31,29.53,29.16,30.56,31.31,29.06,27.0,27.38,28.03,26.62,24.5,24.0,23.78,22.47,19.81,19.81,21.16,22.47,21.41,20.88,22.5,23.44,22.66,21.16,21.97,23.25,22.31,20.16,20.03,20.97,20.22,18.66,18.34,19.62,20.16,18.31,16.97,17.0,17.84,16.72,15.91,17.5,19.81,20.5,19.22,19.88,21.75,22.81,22.25,22.75,25.0,26.19,24.91,23.44,24.25,25.38,24.19,22.22,21.94,22.28,20.84,17.75,16.28,16.56,16.53,14.5,13.5,14.16,15.56,14.47,13.97,15.88,18.47,18.81,17.25,17.09,17.91,17.47,15.69,15.28,16.81,17.75,16.62,15.41,16.88,18.88,18.75,18.22,19.16,21.5,21.88,20.88,20.53,21.88,21.53,18.62,16.16,15.81,15.66,13.41,11.59,12.19,14.0,13.5,12.5,13.28,15.59,16.88,17.28,19.16,23.06,26.16,26.59,26.56,27.44,27.25,23.69,19.69,18.03,18.19,17.16,15.84,16.38,18.47,19.03,17.53,16.72,18.38,19.66,18.66,18.31,20.22,22.19,21.88,20.22,20.19,21.28,20.53,18.69,17.47,18.0,17.31,13.81,11.38,11.41,12.16,11.41,11.22,13.44,16.69,17.75,17.94,19.03,21.41,22.03,20.34,19.59,20.75,21.34,19.72,18.91,20.41,22.03,21.62,20.62,21.78,23.88,24.81,24.94,26.81,30.31,32.62,31.75,30.44,30.31,29.06,24.62,20.53,18.28,16.66,13.75,10.69,10.69,13.09,14.28,14.25,15.25,18.38,20.5,20.78,21.69,24.72,27.0,26.34,24.56,24.41,24.25,21.97,18.66,16.97,17.0,16.41,14.44,13.72,15.22,16.16,14.91,14.09,15.59,17.44,17.03,15.78,16.03,17.44,16.66,14.22,13.38,14.78,15.69,15.53,16.31,19.72,22.53,22.78,22.06,23.16,24.16,22.88,19.97,18.69,18.62,17.38,14.88,13.94,15.59,16.28,14.47,12.38,12.47,12.47,10.69,8.75,9.66,11.5,11.75,10.62,11.0,13.53,15.06,15.22,16.19,19.0,21.53,21.44,20.44,21.34,22.06,20.25,17.03,15.25,14.62,12.5,8.91,7.22,8.59,10.0,10.69,12.94,17.97,22.91,25.25,26.28,28.78,31.03,30.72,28.88,28.22,28.72,27.56,24.28,21.75,21.16,19.47,15.41,11.72,10.75,10.41,9.25,8.22,10.38,13.78,16.06,16.91,18.5,21.47,23.22,22.62,22.59,24.91,26.78,26.53,25.66,27.0,29.0,28.28,26.22,25.19,25.06,23.19,19.75,18.25,18.38,18.25,16.16,14.81,16.03,17.75,17.94,17.19,18.38,19.44,18.28,15.62,14.31,14.66,14.31,12.34,11.31,13.06,14.97,14.75,15.0,16.97,19.09,19.38,18.78,20.34,22.94,24.03,23.03,23.03,24.5,25.84,25.16,25.22,27.25,29.03,27.66,25.34,24.88,24.84,22.75,20.22,19.44,19.91,19.34,17.03,15.78,16.94,17.78,16.34,15.38,15.91,17.22,16.09,14.34,14.81,15.75,15.28,12.97,12.22,12.97,12.88,10.75,9.53,10.91,12.5,12.66,12.62,14.59,16.5,15.44,12.88,11.78,11.69,11.06,9.84,10.25,13.09,14.81,14.12,13.22,14.12,15.38,14.88,15.19,17.66,21.12,22.53,22.25,22.53,23.62,22.88,20.19,19.09,20.16,21.69,21.72,21.62,22.84,23.22,21.06,17.31,15.19,15.03,13.72,11.78,11.66,14.16,16.34,16.47,16.72,18.78,20.44,19.47,18.16,18.88,20.66,20.62,19.38,19.69,21.19,20.75,18.44,16.81,16.62,16.16,14.0,12.78,14.06,16.12,16.34,15.94,17.06,19.0,19.06,18.0,18.5,20.41,20.78,19.09,17.31,17.12,16.56,14.0,12.03,12.12,13.62,13.72,13.12,14.41,17.03,18.19,17.75,18.56,21.22,22.75,21.66,20.31,20.16,19.78,17.06,13.81,12.44,12.5,10.91,8.66,8.44,10.44,11.94,12.38,14.38,18.81,22.41,23.59,23.25,24.03,24.41,22.5,19.78,18.78,19.59,19.69,19.12,20.25,23.28,25.25,24.97,24.62,25.5,26.38,24.31,21.5,20.81,20.81,19.34,17.69,17.28,18.62,18.53,16.91,15.97,17.19,17.78,16.06,14.59,15.16,16.31,15.5,13.78,13.66,14.16,12.41,9.59,7.84,8.0,7.53,5.25,3.94,5.22,7.12,7.81,8.88,12.28,15.88,17.22,17.0,17.59,18.59,17.84,15.5,14.09,15.22,15.62,14.72,13.97,15.31,16.78,15.19,13.0,12.22,11.97,10.25,7.97,7.06,8.25,8.53,7.47,7.84,10.53,13.0,13.28,12.84,13.91,15.41,14.47,12.47,11.94,12.19,11.03,8.56,7.53,8.56,9.0,7.78,7.0,8.19,9.31,8.72,7.69,8.94,11.06,12.03,12.0,12.88,14.59,15.09,13.34,12.41,13.59,14.59,13.41,12.38,13.56,14.62,14.03,12.66,13.41,15.12,15.34,13.75,13.28,14.22,14.19,12.62,12.12,14.06,16.5,16.62,16.53,18.25,20.16,19.91,18.5,18.47,19.38,19.0,16.94,16.0,17.19,18.59,17.91,17.22,18.41,19.53,17.91,15.47,15.34,16.19,15.97,14.03,13.94,15.62,17.03,16.91,18.19,21.09,23.12,22.53,20.97,20.78,21.06,19.81,17.31,16.91,18.06,17.44,15.12,14.0,14.91,15.66,14.56,14.22,16.09,17.75,16.28,13.78,12.69,12.38,10.75,8.69,8.97,11.22,12.81,12.44,13.12,15.81,18.0,18.19,18.09,19.34,20.38,19.12,16.94,16.47,17.22,16.75,14.66,14.09,15.19,15.81,14.78,14.69,16.62,18.47,18.31,17.97,19.34,21.31,21.47,19.78,19.34,19.97,19.22,16.75,15.81,17.91,20.19,20.78,22.09,24.81,27.06,26.25,23.62,22.66,22.88,20.91,17.88,15.75,15.28,13.94,11.06,9.41,10.94,13.28,13.56,14.16,16.41,19.22,19.38,18.31,18.81,20.31,20.34,18.84,18.66,20.62,22.12,21.75,21.47,23.25,25.16,23.97,22.56,23.25,24.97,24.94,23.84,23.75,24.78,24.31,21.59,19.94,20.53,21.12,19.56,17.78,18.78,20.47,19.59,18.25,18.78,20.22,19.88,17.91,17.44,19.12,20.28,19.44,19.47,22.34,24.81,25.38,25.66,27.62,29.94,29.16,26.44,24.66,24.09,21.94,18.47,16.22,16.59,17.19,15.91,15.44,17.62,19.75,19.06,17.38,17.34,18.84,18.97,18.44,20.09,23.84,26.09,26.31,26.69,28.66,29.56,28.34,26.31,26.62,27.31,25.47,23.31,22.78,23.47,22.34,19.81,18.62,20.0,21.12,21.16,22.34,26.31,29.72,30.19,29.62,30.03,30.72,29.28,26.47,25.88,27.31,27.59,26.09,25.03,26.09,26.34,24.16,22.59,23.75,25.44,25.25,24.19,24.69,25.72,24.56,21.31,20.16,20.91,21.5,21.25,21.88,24.53,26.56,25.25,22.78,22.25,22.41,20.72,18.38,18.72,20.44,20.06,18.12,16.75,17.59,17.69,16.94,16.72,20.06,23.56,24.91,25.66,27.75,30.16,29.88,28.59,28.38,29.91,30.09,27.97,26.53,27.0,26.88,24.66,22.69,23.19,24.91,24.81,23.75,25.09,27.44,28.12,27.12,27.22,28.88,29.34,27.66,26.5,27.03,27.56,25.84,23.75,24.0,25.0,24.03,22.09,22.19,23.91,24.44,23.31,23.22,24.81,25.28,23.34,21.97,23.38,25.47,26.19,26.25,28.28,30.28,30.09,27.44,26.19,26.84,26.56,25.12,25.44,28.47,31.56,31.91,31.88,33.16,34.19,32.66,30.16,29.91,31.59,31.94,30.75,30.91,32.06,31.38,28.22,25.59,26.0,27.12,27.03,27.38,29.97,32.59,33.34,32.28,32.88,34.25,34.25,31.88,30.53,31.19,31.38,29.62,27.84,29.0,30.34,29.38,28.16,28.53,29.84,28.84,25.72,24.34,24.28,23.84,22.22,21.97,24.28,26.72,26.28,25.16,26.0,27.09,26.22,24.88,25.69,28.03,28.91,28.0,27.72,28.66,28.47,25.12,22.31,22.03,22.88,22.16,21.94,24.06,26.91,27.41,26.84,27.56,29.53,31.28,30.84,31.88,34.97,37.16,37.03,36.09,36.84,37.03,34.78,31.44,30.25,30.34,29.91,28.88,29.81,32.53,33.75,32.19,30.31,29.69,29.03,26.59,24.66,25.47,28.06,28.97,28.69,29.59,31.22,31.41,29.81,29.53,30.91,31.84,30.59,29.19,30.34,31.56,30.22,28.22,28.25,29.28,29.09,28.75,30.53,33.56,35.34,34.31,32.78,32.34,31.25,27.5,24.44,24.09,24.84,23.81,22.81,24.09,26.31,27.66,27.19,28.03,30.31,32.0,32.06,32.81,35.56,38.59,38.84,37.97,38.5,39.56,38.09,35.84,34.78,34.97,33.91,31.16,29.16,29.03,28.72,26.03,23.91,24.03,25.91,24.88,23.19,21.94,21.94,24.19,25.66,26.12,26.81,29.28,31.56,32.41,32.91,34.5,36.25,36.69,36.41,37.12,38.56,38.75,37.41,36.47,36.25,35.03,32.53,30.16,29.22,28.84,27.78,26.72,27.78,29.84,31.38,31.69,32.59:20.41,19.66,19.56,18.94,18.06,19.44,22.38,24.25,23.91,23.94,25.78,26.69,25.09,23.16,22.84,22.69,20.53,18.38,19.12,21.81,23.94,25.03,27.38,30.06,30.94,28.66,26.19,25.53,25.0,22.78,21.03,22.28,24.91,25.91,25.62,27.19,29.31,30.31,29.53,29.16,30.56,31.31,29.06,27.0,27.38,28.03,26.62,24.5,24.0,23.78,22.47,19.81,19.81,21.16,22.47,21.41,20.88,22.5,23.44,22.66,21.16,21.97,23.25,22.31,20.16,20.03,20.97,20.22,18.66,18.34,19.62,20.16,18.31,16.97,17.0,17.84,16.72,15.91,17.5,19.81,20.5,19.22,19.88,21.75,22.81,22.25,22.75,25.0,26.19,24.91,23.44,24.25,25.38,24.19,22.22,21.94,22.28,20.84,17.75,16.28,16.56,16.53,14.5,13.5,14.16,15.56,14.47,13.97,15.88,18.47,18.81,17.25,17.09,17.91,17.47,15.69,15.28,16.81,17.75,16.62,15.41,16.88,18.88,18.75,18.22,19.16,21.5,21.88,20.88,20.53,21.88,21.53,18.62,16.16,15.81,15.66,13.41,11.59,12.19,14.0,13.5,12.5,13.28,15.59,16.88,17.28,19.16,23.06,26.16,26.59,26.56,27.44,27.25,23.69,19.69,18.03,18.19,17.16,15.84,16.38,18.47,19.03,17.53,16.72,18.38,19.66,18.66,18.31,20.22,22.19,21.88,20.22,20.19,21.28,20.53,18.69,17.47,18.0,17.31,13.81,11.38,11.41,12.16,11.41,11.22,13.44,16.69,17.75,17.94,19.03,21.41,22.03,20.34,19.59,20.75,21.34,19.72,18.91,20.41,22.03,21.62,20.62,21.78,23.88,24.81,24.94,26.81,30.31,32.62,31.75,30.44,30.31,29.06,24.62,20.53,18.28,16.66,13.75,10.69,10.69,13.09,14.28,14.25,15.25,18.38,20.5,20.78,21.69,24.72,27.0,26.34,24.56,24.41,24.25,21.97,18.66,16.97,17.0,16.41,14.44,13.72,15.22,16.16,14.91,14.09,15.59,17.44,17.03,15.78,16.03,17.44,16.66,14.22,13.38,14.78,15.69,15.53,16.31,19.72,22.53,22.78,22.06,23.16,24.16,22.88,19.97,18.69,18.62,17.38,14.88,13.94,15.59,16.28,14.47,12.38,12.47,12.47,10.69,8.75,9.66,11.5,11.75,10.62,11.0,13.53,15.06,15.22,16.19,19.0,21.53,21.44,20.44,21.34,22.06,20.25,17.03,15.25,14.62,12.5,8.91,7.22,8.59,10.0,10.69,12.94,17.97,22.91,25.25,26.28,28.78,31.03,30.72,28.88,28.22,28.72,27.56,24.28,21.75,21.16,19.47,15.41,11.72,10.75,10.41,9.25,8.22,10.38,13.78,16.06,16.91,18.5,21.47,23.22,22.62,22.59,24.91,26.78,26.53,25.66,27.0,29.0,28.28,26.22,25.19,25.06,23.19,19.75,18.25,18.38,18.25,16.16,14.81,16.03,17.75,17.94,17.19,18.38,19.44,18.28,15.62,14.31,14.66,14.31,12.34,11.31,13.06,14.97,14.75,15.0,16.97,19.09,19.38,18.78,20.34,22.94,24.03,23.03,23.03,24.5,25.84,25.16,25.22,27.25,29.03,27.66,25.34,24.88,24.84,22.75,20.22,19.44,19.91,19.34,17.03,15.78,16.94,17.78,16.34,15.38,15.91,17.22,16.09,14.34,14.81,15.75,15.28,12.97,12.22,12.97,12.88,10.75,9.53,10.91,12.5,12.66,12.62,14.59,16.5,15.44,12.88,11.78,11.69,11.06,9.84,10.25,13.09,14.81,14.12,13.22,14.12,15.38,14.88,15.19,17.66,21.12,22.53,22.25,22.53,23.62,22.88,20.19,19.09,20.16,21.69,21.72,21.62,22.84,23.22,21.06,17.31,15.19,15.03,13.72,11.78,11.66,14.16,16.34,16.47,16.72,18.78,20.44,19.47,18.16,18.88,20.66,20.62,19.38,19.69,21.19,20.75,18.44,16.81,16.62,16.16,14.0,12.78,14.06,16.12,16.34,15.94,17.06,19.0,19.06,18.0,18.5,20.41,20.78,19.09,17.31,17.12,16.56,14.0,12.03,12.12,13.62,13.72,13.12,14.41,17.03,18.19,17.75,18.56,21.22,22.75,21.66,20.31,20.16,19.78,17.06,13.81,12.44,12.5,10.91,8.66,8.44,10.44,11.94,12.38,14.38,18.81,22.41,23.59,23.25,24.03,24.41,22.5,19.78,18.78,19.59,19.69,19.12,20.25,23.28,25.25,24.97,24.62,25.5,26.38,24.31,21.5,20.81,20.81,19.34,17.69,17.28,18.62,18.53,16.91,15.97,17.19,17.78,16.06,14.59,15.16,16.31,15.5,13.78,13.66,14.16,12.41,9.59,7.84,8.0,7.53,5.25,3.94,5.22,7.12,7.81,8.88,12.28,15.88,17.22,17.0,17.59,18.59,17.84,15.5,14.09,15.22,15.62,14.72,13.97,15.31,16.78,15.19,13.0,12.22,11.97,10.25,7.97,7.06,8.25,8.53,7.47,7.84,10.53,13.0,13.28,12.84,13.91,15.41,14.47,12.47,11.94,12.19,11.03,8.56,7.53,8.56,9.0,7.78,7.0,8.19,9.31,8.72,7.69,8.94,11.06,12.03,12.0,12.88,14.59,15.09,13.34,12.41,13.59,14.59,13.41,12.38,13.56,14.62,14.03,12.66,13.41,15.12,15.34,13.75,13.28,14.22,14.19,12.62,12.12,14.06,16.5,16.62,16.53,18.25,20.16,19.91,18.5,18.47,19.38,19.0,16.94,16.0,17.19,18.59,17.91,17.22,18.41,19.53,17.91,15.47,15.34,16.19,15.97,14.03,13.94,15.62,17.03,16.91,18.19,21.09,23.12,22.53,20.97,20.78,21.06,19.81,17.31,16.91,18.06,17.44,15.12,14.0,14.91,15.66,14.56,14.22,16.09,17.75,16.28,13.78,12.69,12.38,10.75,8.69,8.97,11.22,12.81,12.44,13.12,15.81,18.0,18.19,18.09,19.34,20.38,19.12,16.94,16.47,17.22,16.75,14.66,14.09,15.19,15.81,14.78,14.69,16.62,18.47,18.31,17.97,19.34,21.31,21.47,19.78,19.34,19.97,19.22,16.75,15.81,17.91,20.19,20.78,22.09,24.81,27.06,26.25,23.62,22.66,22.88,20.91,17.88,15.75,15.28,13.94,11.06,9.41,10.94,13.28,13.56,14.16,16.41,19.22,19.38,18.31,18.81,20.31,20.34,18.84,18.66,20.62,22.12,21.75,21.47,23.25,25.16,23.97,22.56,23.25,24.97,24.94,23.84,23.75,24.78,24.31,21.59,19.94,20.53,21.12,19.56,17.78,18.78,20.47,19.59,18.25,18.78,20.22,19.88,17.91,17.44,19.12,20.28,19.44,19.47,22.34,24.81,25.38,25.66,27.62,29.94,29.16,26.44,24.66,24.09,21.94,18.47,16.22,16.59,17.19,15.91,15.44,17.62,19.75,19.06,17.38,17.34,18.84,18.97,18.44,20.09,23.84,26.09,26.31,26.69,28.66,29.56,28.34,26.31,26.62,27.31,25.47,23.31,22.78,23.47,22.34,19.81,18.62,20.0,21.12,21.16,22.34,26.31,29.72,30.19,29.62,30.03,30.72,29.28,26.47,25.88,27.31,27.59,26.09,25.03,26.09,26.34,24.16,22.59,23.75,25.44,25.25,24.19,24.69,25.72,24.56,21.31,20.16,20.91,21.5,21.25,21.88,24.53,26.56,25.25,22.78,22.25,22.41,20.72,18.38,18.72,20.44,20.06,18.12,16.75,17.59,17.69,16.94,16.72,20.06,23.56,24.91,25.66,27.75,30.16,29.88,28.59,28.38,29.91,30.09,27.97,26.53,27.0,26.88,24.66,22.69,23.19,24.91,24.81,23.75,25.09,27.44,28.12,27.12,27.22,28.88,29.34,27.66,26.5,27.03,27.56,25.84,23.75,24.0,25.0,24.03,22.09,22.19,23.91,24.44,23.31,23.22,24.81,25.28,23.34,21.97,23.38,25.47,26.19,26.25,28.28,30.28,30.09,27.44,26.19,26.84,26.56,25.12,25.44,28.47,31.56,31.91,31.88,33.16,34.19,32.66,30.16,29.91,31.59,31.94,30.75,30.91,32.06,31.38,28.22,25.59,26.0,27.12,27.03,27.38,29.97,32.59,33.34,32.28,32.88,34.25,34.25,31.88,30.53,31.19,31.38,29.62,27.84,29.0,30.34,29.38,28.16,28.53,29.84,28.84,25.72,24.34,24.28,23.84,22.22,21.97,24.28,26.72,26.28,25.16,26.0,27.09,26.22,24.88,25.69,28.03,28.91,28.0,27.72,28.66,28.47,25.12,22.31,22.03,22.88,22.16,21.94,24.06,26.91,27.41,26.84,27.56,29.53,31.28,30.84,31.88,34.97,37.16,37.03,36.09,36.84,37.03,34.78,31.44,30.25,30.34,29.91,28.88,29.81,32.53,33.75,32.19,30.31,29.69,29.03,26.59,24.66,25.47,28.06,28.97,28.69,29.59,31.22,31.41,29.81,29.53,30.91,31.84,30.59,29.19,30.34,31.56,30.22,28.22,28.25,29.28,29.09,28.75,30.53,33.56,35.34,34.31,32.78,32.34,31.25,27.5,24.44,24.09,24.84,23.81,22.81,24.09,26.31,27.66,27.19,28.03,30.31,32.0,32.06,32.81,35.56,38.59,38.84,37.97,38.5,39.56,38.09,35.84,34.78,34.97,33.91,31.16,29.16,29.03,28.72,26.03,23.91,24.03,25.91,24.88,23.19,21.94,21.94,24.19,25.66,26.12,26.81,29.28,31.56,32.41,32.91,34.5,36.25,36.69,36.41,37.12,38.56,38.75,37.41,36.47,36.25,35.03,32.53,30.16,29.22,28.84,27.78,26.72,27.78,29.84,31.38,31.69,32.59,34.06,34.41,33.81,33.62,34.84,35.69,34.75:negativity
-11.5,-13.31,-14.62,-14.56,-13.16,-11.25,-9.44,-7.38,-5.06,-3.66,-3.72,-3.78,-3.25,-2.91,-3.38,-3.53,-3.69,-3.66,-4.91,-6.88,-8.72,-9.91,-11.47,-13.19,-14.41,-14.94,-15.47,-16.34,-16.62,-15.84,-15.0,-14.59,-14.53,-14.31,-13.59,-13.47,-13.28,-12.72,-11.19,-9.84,-9.12,-8.19,-7.25,-6.75,-8.06,-9.56,-10.72,-11.69,-12.81,-13.88,-13.97,-12.84,-12.12,-11.25,-10.31,-8.94,-8.31,-8.69,-9.22,-8.88,-8.47,-8.5,-8.56,-8.09,-7.12,-7.59,-8.38,-8.41,-7.84,-7.47,-6.91,-6.31,-4.62,-3.03,-2.97,-3.16,-3.19,-3.75,-5.94,-8.34,-9.97,-11.28,-12.94,-14.41,-14.72,-13.66,-11.81,-10.09,-7.91,-5.5,-3.72,-3.91,-4.38,-4.78,-4.62,-5.78,-7.06,-7.44,-7.78,-9.0,-10.97,-12.38,-13.44,-14.91,-16.72,-17.81,-18.25,-18.22,-18.94,-19.62,-19.41,-18.84,-18.81,-18.78,-18.84,-18.12,-19.06,-20.56,-22.34,-22.88,-23.06,-23.72,-23.72,-22.75,-22.5,-23.28,-24.47,-24.78,-23.94,-23.66,-23.22,-21.69,-19.12,-17.25,-15.97,-14.88,-13.56,-12.53,-12.56,-12.28,-11.31,-10.5,-10.94,-11.72,-11.91,-11.66,-12.06,-12.97,-14.0,-14.59,-15.56,-17.09,-17.59,-16.69,-15.78,-15.0,-14.25,-12.47,-10.94,-10.69,-11.34,-12.0,-12.09,-13.06,-13.91,-13.72,-12.84,-12.12,-11.69,-11.81,-11.53,-11.59,-12.41,-14.12,-14.84,-15.28,-15.81,-16.09,-15.53,-14.16,-13.5,-13.41,-13.72,-13.53,-13.59,-14.41,-14.81,-14.28,-13.97,-14.28,-14.72,-14.25,-13.22,-12.94,-12.84,-12.66,-11.47,-10.62,-9.94,-8.66,-6.59,-5.09,-5.12,-5.72,-5.88,-6.19,-7.38,-8.97,-9.97,-10.91,-12.47,-14.0,-14.72,-13.97,-13.19,-12.16,-11.44,-10.12,-9.06,-9.34,-10.22,-10.22,-10.25,-11.19,-12.34,-12.84,-12.5,-12.5,-12.72,-12.97,-12.78,-12.47,-12.84,-13.0,-11.53,-10.12,-9.91,-10.28,-10.81,-11.69,-13.75,-16.22,-17.44,-17.25,-16.66,-15.69,-14.0,-11.44,-9.44,-8.94,-9.47,-9.31,-8.84,-9.28,-10.16,-9.69,-8.69,-8.22,-7.91,-6.94,-5.38,-4.34,-4.81,-5.66,-6.09,-7.34,-9.31,-11.22,-12.34,-13.0,-14.16,-15.59,-16.28,-16.53,-16.94,-17.19,-16.62,-15.19,-13.97,-13.72,-13.69,-13.16,-12.94,-13.25,-13.41,-12.59,-11.22,-10.56,-10.69,-10.03,-9.56,-10.0,-11.06,-12.19,-13.16,-14.31,-16.19,-18.22,-18.72,-18.34,-18.34,-17.81,-15.91,-13.41,-11.59,-11.44,-11.69,-12.38,-13.81,-16.31,-18.12,-18.25,-18.03,-18.28,-17.91,-17.0,-16.31,-16.59,-17.41,-17.22,-16.31,-15.16,-14.56,-13.09,-11.53,-11.38,-12.75,-14.72,-16.0,-17.16,-18.28,-18.72,-17.41,-15.03,-13.38,-12.25,-10.66,-9.75,-9.66,-10.69,-11.41,-11.03,-11.09,-11.84,-12.5,-12.31,-12.28,-13.03,-13.75,-13.47,-12.75,-13.19,-14.91,-16.34,-18.16,-19.94,-22.03,-22.94,-22.41,-21.38,-21.03,-20.72,-19.44,-17.72,-16.44,-15.31,-13.31,-10.94,-9.81,-9.59,-9.19,-8.66,-8.28,-8.81,-8.47,-7.31,-6.0,-5.69,-5.25,-4.31,-3.53,-3.88,-5.09,-6.47,-7.59,-9.0,-10.38,-10.53,-9.78,-9.47,-10.47,-11.81,-12.97,-14.25,-15.94,-17.19,-17.16,-16.5,-15.66,-14.72,-13.5,-11.44,-9.5,-8.53,-7.0,-5.44,-4.47,-5.62,-7.19,-8.66,-9.56,-10.91,-11.88,-11.62,-10.47,-10.12,-9.94,-9.75,-9.34,-9.28,-10.97,-12.47,-13.38,-13.75,-15.0,-15.34,-14.12,-12.41,-11.38,-10.44,-8.78,-7.28,-6.38,-6.53,-6.75,-6.84,-7.5,-9.12,-10.53,-11.16,-10.66,-10.84,-10.16,-8.34,-5.72,-4.5,-3.72,-3.12,-2.5,-2.38,-2.97,-3.12,-2.62,-2.56,-3.22,-3.88,-3.78,-2.88,-2.91,-1.78,0.09,2.53,4.03,5.16,5.81,6.12,5.25,3.06,1.03,-0.47,-1.38,-2.84,-4.16,-4.75,-4.59,-5.28,-5.53,-4.69,-2.84,-1.44,-0.19,1.5,3.47,5.03,5.41,6.0,7.69,9.22,9.94,10.03,9.97,9.31,7.47,4.78,3.12,2.66,1.91,0.75,0.06,-0.12,-0.84,-2.94,-4.78,-5.69,-6.41,-7.69,-8.41,-8.28,-6.94,-6.62,-6.5,-5.75,-4.84,-4.25,-4.12,-3.72,-2.22,-0.66,0.09,1.16,3.12,4.62,4.84,4.56,4.12,3.62,2.25,0.41,-1.25,-2.0,-3.06,-4.12,-4.25,-3.34,-2.16,-1.84,-2.0,-2.34,-2.66,-3.69,-4.62,-4.66,-3.72,-3.25,-3.09,-3.06,-2.59,-2.56,-3.16,-3.5,-2.94,-1.75,-1.47,-1.56,-1.41,-2.03,-3.56,-6.0,-8.16,-9.75,-11.53,-13.28,-14.59,-14.41,-14.16,-14.34,-14.34,-13.22,-12.25,-11.84,-11.69,-10.94,-10.5,-10.94,-11.59,-12.25,-12.41,-12.59,-13.12,-13.59,-13.03,-12.22,-11.56,-10.81,-9.19,-7.09,-5.62,-4.56,-3.72,-3.59,-4.5,-6.19,-8.22,-9.38,-9.66,-10.47,-10.69,-9.78,-8.69,-7.75,-6.84,-5.47,-3.69,-3.25,-3.16,-2.97,-2.62,-2.78,-3.66,-5.22,-6.19,-7.69,-9.53,-10.75,-9.88,-8.22,-6.34,-4.75,-3.0,-2.0,-2.47,-4.06,-5.66,-6.34,-6.72,-7.59,-7.81,-7.28,-7.19,-7.94,-8.47,-7.78,-7.09,-6.59,-6.84,-6.94,-6.81,-7.38,-7.88,-8.03,-7.53,-7.62,-8.38,-9.62,-10.38,-10.97,-12.19,-12.38,-11.25,-9.62,-8.28,-7.47,-6.75,-5.84,-5.28,-4.97,-3.91,-1.44,0.72,1.34,1.53,1.75,1.78,0.78,-0.25,-0.31,-0.59,-1.03,-2.31,-3.06,-3.19,-3.44,-4.44,-5.34,-5.69,-6.06,-6.88,-7.62,-6.75,-5.59,-4.28,-3.59,-2.53,-1.25,-0.34,-0.38,-0.06,0.81,1.19,0.69,-0.22,-0.84,-1.62,-3.38,-5.34,-6.22,-7.06,-8.06,-9.38,-9.59,-9.09,-8.12,-6.97,-5.19,-2.56,-0.31,0.66,1.25,2.03,2.44,2.12,0.81,0.0,-0.53,-1.94,-3.66,-5.19,-6.34,-7.22,-8.81,-9.84,-9.72,-9.5,-10.22,-10.97,-10.59,-9.78,-8.53,-6.84,-4.62,-1.75,0.19,0.84,1.53,1.75,1.72,0.31,-1.03,-1.41,-1.28,-1.66,-2.53,-2.66,-2.88,-3.69,-4.72,-4.75,-3.62,-2.16,-1.06,0.47,1.91,3.41,3.12,2.28,2.25,2.72,2.53,2.22,2.81,3.56,4.06,3.66,3.28,3.34,2.69,1.09,-0.41,-1.19,-1.66,-2.78,-4.31,-4.84,-4.94,-5.38,-5.97,-5.34,-4.25,-3.09,-2.44,-1.31,0.38,1.69,2.19,2.06,2.25,2.62,1.66,0.78,0.59,0.53,-0.53,-2.53,-4.16,-5.5,-6.31,-6.75,-6.0,-4.31,-2.5,-2.0,-2.28,-2.31,-2.44,-3.19,-4.22,-3.88,-2.91,-2.06,-2.0,-1.94,-1.94,-2.72,-4.66,-6.0,-6.09,-5.41,-4.66,-3.81,-2.44,-0.66,-0.25,-0.62,-0.69,-0.12,-0.16,-0.69,-0.78,-0.06,0.03,-1.16,-2.59,-3.72,-4.72,-6.03,-6.69,-5.78,-3.88,-2.66,-2.03,-1.22,-0.34,-0.22,-0.88,-1.22,-0.88,-0.5,-1.09,-1.69,-1.72,-1.5,-1.59,-1.5,-0.19,1.84,2.53,2.88,2.53,2.44,2.03,0.75,-0.34,-0.44,0.0,-0.78,-1.41,-1.38,-1.66,-2.97,-4.31,-5.34,-5.03,-4.34,-3.84,-2.69,-0.47,1.31,1.72,2.19,3.56,4.91,5.0,4.81,4.78,4.25,2.88,1.47,0.97,2.19,3.53,4.78,6.41,8.88,10.59,11.25,11.34,11.84,12.47,11.22,9.47,7.91,6.62,5.03,3.41,2.78,3.47,4.0,3.66,3.62,4.25,4.94,4.97,4.75,5.16,5.56,4.69,3.22,2.25,1.53,0.66,-0.38,-0.59,0.56,1.56,2.28,2.91,4.09,4.25,3.31,2.03,1.28,1.34,0.72,0.38,0.78,1.72,2.19,2.41,2.91,4.38,5.62,5.78,5.66,6.44,6.5,5.62,4.06,3.41,3.09,2.53,2.16,2.44,3.84,4.66,4.78,5.0,5.91,6.75,6.22,5.12,4.75,4.66,4.53,4.25,4.69,6.28,6.62,6.28,5.84,5.75,5.09,3.25,1.28,0.81,0.38,-0.91,-2.19,-2.19,-1.75,-1.66,-1.22,0.12,1.91,3.44,4.06,4.75,6.25,7.12,6.88,6.59,7.28,8.06,8.0,7.62,8.06,8.25,7.34,5.59,4.28,3.75,3.09,3.12,3.34,4.72,5.47,4.94,3.84,3.81,4.03,3.97,4.19,5.25,6.72,7.22,7.41,7.62,8.78,9.38,9.0,8.44,8.5,7.97,6.59,5.03,4.31,4.38,4.0,3.62,4.22,5.72,6.19,5.66,4.97,4.66,3.66,2.38,1.28,1.59,2.59,3.12,3.69,5.28,7.31,8.56,8.91,9.78,10.62,10.78,9.72,8.5,8.44,7.72,6.03,4.56,4.22,3.62,2.53,1.22,0.88,1.53,1.91,2.22,4.38,6.81,8.97,10.12,11.53,13.22,13.97,13.44,12.53,11.56,10.84,10.0,9.0,8.72,9.0,8.56,7.16,6.16,6.0,6.0,6.09,7.09,9.31,12.06,13.41,14.38,15.19,15.25,14.84,13.69,13.62,14.22,14.66,13.94,13.5,13.75,13.34,12.22,11.12,11.38,11.25,10.38,9.34,9.72,10.31,11.19,11.66,12.62,14.03,15.09,14.97,15.25,15.88,16.38,15.03,12.84,10.88,8.56,5.72,2.72,1.41,1.25,2.0,2.72,4.5,7.5,9.69,10.59,11.25,11.91,12.38,12.19,12.22,13.34,14.44,14.81,14.41,14.12,13.97,13.28,11.84,11.12,10.97,11.03,10.12,9.62,9.81,9.94,9.38,8.44:-7.38,-5.06,-3.66,-3.72,-3.78,-3.25,-2.91,-3.38,-3.53,-3.69,-3.66,-4.91,-6.88,-8.72,-9.91,-11.47,-13.19,-14.41,-14.94,-15.47,-16.34,-16.62,-15.84,-15.0,-14.59,-14.53,-14.31,-13.59,-13.47,-13.28,-12.72,-11.19,-9.84,-9.12,-8.19,-7.25,-6.75,-8.06,-9.56,-10.72,-11.69,-12.81,-13.88,-13.97,-12.84,-12.12,-11.25,-10.31,-8.94,-8.31,-8.69,-9.22,-8.88,-8.47,-8.5,-8.56,-8.09,-7.12,-7.59,-8.38,-8.41,-7.84,-7.47,-6.91,-6.31,-4.62,-3.03,-2.97,-3.16,-3.19,-3.75,-5.94,-8.34,-9.97,-11.28,-12.94,-14.41,-14.72,-13.66,-11.81,-10.09,-7.91,-5.5,-3.72,-3.91,-4.38,-4.78,-4.62,-5.78,-7.06,-7.44,-7.78,-9.0,-10.97,-12.38,-13.44,-14.91,-16.72,-17.81,-18.25,-18.22,-18.94,-19.62,-19.41,-18.84,-18.81,-18.78,-18.84,-18.12,-19.06,-20.56,-22.34,-22.88,-23.06,-23.72,-23.72,-22.75,-22.5,-23.28,-24.47,-24.78,-23.94,-23.66,-23.22,-21.69,-19.12,-17.25,-15.97,-14.88,-13.56,-12.53,-12.56,-12.28,-11.31,-10.5,-10.94,-11.72,-11.91,-11.66,-12.06,-12.97,-14.0,-14.59,-15.56,-17.09,-17.59,-16.69,-15.78,-15.0,-14.25,-12.47,-10.94,-10.69,-11.34,-12.0,-12.09,-13.06,-13.91,-13.72,-12.84,-12.12,-11.69,-11.81,-11.53,-11.59,-12.41,-14.12,-14.84,-15.28,-15.81,-16.09,-15.53,-14.16,-13.5,-13.41,-13.72,-13.53,-13.59,-14.41,-14.81,-14.28,-13.97,-14.28,-14.72,-14.25,-13.22,-12.94,-12.84,-12.66,-11.47,-10.62,-9.94,-8.66,-6.59,-5.09,-5.12,-5.72,-5.88,-6.19,-7.38,-8.97,-9.97,-10.91,-12.47,-14.0,-14.72,-13.97,-13.19,-12.16,-11.44,-10.12,-9.06,-9.34,-10.22,-10.22,-10.25,-11.19,-12.34,-12.84,-12.5,-12.5,-12.72,-12.97,-12.78,-12.47,-12.84,-13.0,-11.53,-10.12,-9.91,-10.28,-10.81,-11.69,-13.75,-16.22,-17.44,-17.25,-16.66,-15.69,-14.0,-11.44,-9.44,-8.94,-9.47,-9.31,-8.84,-9.28,-10.16,-9.69,-8.69,-8.22,-7.91,-6.94,-5.38,-4.34,-4.81,-5.66,-6.09,-7.34,-9.31,-11.22,-12.34,-13.0,-14.16,-15.59,-16.28,-16.53,-16.94,-17.19,-16.62,-15.19,-13.97,-13.72,-13.69,-13.16,-12.94,-13.25,-13.41,-12.59,-11.22,-10.56,-10.69,-10.03,-9.56,-10.0,-11.06,-12.19,-13.16,-14.31,-16.19,-18.22,-18.72,-18.34,-18.34,-17.81,-15.91,-13.41,-11.59,-11.44,-11.69,-12.38,-13.81,-16.31,-18.12,-18.25,-18.03,-18.28,-17.91,-17.0,-16.31,-16.59,-17.41,-17.22,-16.31,-15.16,-14.56,-13.09,-11.53,-11.38,-12.75,-14.72,-16.0,-17.16,-18.28,-18.72,-17.41,-15.03,-13.38,-12.25,-10.66,-9.75,-9.66,-10.69,-11.41,-11.03,-11.09,-11.84,-12.5,-12.31,-12.28,-13.03,-13.75,-13.47,-12.75,-13.19,-14.91,-16.34,-18.16,-19.94,-22.03,-22.94,-22.41,-21.38,-21.03,-20.72,-19.44,-17.72,-16.44,-15.31,-13.31,-10.94,-9.81,-9.59,-9.19,-8.66,-8.28,-8.81,-8.47,-7.31,-6.0,-5.69,-5.25,-4.31,-3.53,-3.88,-5.09,-6.47,-7.59,-9.0,-10.38,-10.53,-9.78,-9.47,-10.47,-11.81,-12.97,-14.25,-15.94,-17.19,-17.16,-16.5,-15.66,-14.72,-13.5,-11.44,-9.5,-8.53,-7.0,-5.44,-4.47,-5.62,-7.19,-8.66,-9.56,-10.91,-11.88,-11.62,-10.47,-10.12,-9.94,-9.75,-9.34,-9.28,-10.97,-12.47,-13.38,-13.75,-15.0,-15.34,-14.12,-12.41,-11.38,-10.44,-8.78,-7.28,-6.38,-6.53,-6.75,-6.84,-7.5,-9.12,-10.53,-11.16,-10.66,-10.84,-10.16,-8.34,-5.72,-4.5,-3.72,-3.12,-2.5,-2.38,-2.97,-3.12,-2.62,-2.56,-3.22,-3.88,-3.78,-2.88,-2.91,-1.78,0.09,2.53,4.03,5.16,5.81,6.12,5.25,3.06,1.03,-0.47,-1.38,-2.84,-4.16,-4.75,-4.59,-5.28,-5.53,-4.69,-2.84,-1.44,-0.19,1.5,3.47,5.03,5.41,6.0,7.69,9.22,9.94,10.03,9.97,9.31,7.47,4.78,3.12,2.66,1.91,0.75,0.06,-0.12,-0.84,-2.94,-4.78,-5.69,-6.41,-7.69,-8.41,-8.28,-6.94,-6.62,-6.5,-5.75,-4.84,-4.25,-4.12,-3.72,-2.22,-0.66,0.09,1.16,3.12,4.62,4.84,4.56,4.12,3.62,2.25,0.41,-1.25,-2.0,-3.06,-4.12,-4.25,-3.34,-2.16,-1.84,-2.0,-2.34,-2.66,-3.69,-4.62,-4.66,-3.72,-3.25,-3.09,-3.06,-2.59,-2.56,-3.16,-3.5,-2.94,-1.75,-1.47,-1.56,-1.41,-2.03,-3.56,-6.0,-8.16,-9.75,-11.53,-13.28,-14.59,-14.41,-14.16,-14.34,-14.34,-13.22,-12.25,-11.84,-11.69,-10.94,-10.5,-10.94,-11.59,-12.25,-12.41,-12.59,-13.12,-13.59,-13.03,-12.22,-11.56,-10.81,-9.19,-7.09,-5.62,-4.56,-3.72,-3.59,-4.5,-6.19,-8.22,-9.38,-9.66,-10.47,-10.69,-9.78,-8.69,-7.75,-6.84,-5.47,-3.69,-3.25,-3.16,-2.97,-2.62,-2.78,-3.66,-5.22,-6.19,-7.69,-9.53,-10.75,-9.88,-8.22,-6.34,-4.75,-3.0,-2.0,-2.47,-4.06,-5.66,-6.34,-6.72,-7.59,-7.81,-7.28,-7.19,-7.94,-8.47,-7.78,-7.09,-6.59,-6.84,-6.94,-6.81,-7.38,-7.88,-8.03,-7.53,-7.62,-8.38,-9.62,-10.38,-10.97,-12.19,-12.38,-11.25,-9.62,-8.28,-7.47,-6.75,-5.84,-5.28,-4.97,-3.91,-1.44,0.72,1.34,1.53,1.75,1.78,0.78,-0.25,-0.31,-0.59,-1.03,-2.31,-3.06,-3.19,-3.44,-4.44,-5.34,-5.69,-6.06,-6.88,-7.62,-6.75,-5.59,-4.28,-3.59,-2.53,-1.25,-0.34,-0.38,-0.06,0.81,1.19,0.69,-0.22,-0.84,-1.62,-3.38,-5.34,-6.22,-7.06,-8.06,-9.38,-9.59,-9.09,-8.12,-6.97,-5.19,-2.56,-0.31,0.66,1.25,2.03,2.44,2.12,0.81,0.0,-0.53,-1.94,-3.66,-5.19,-6.34,-7.22,-8.81,-9.84,-9.72,-9.5,-10.22,-10.97,-10.59,-9.78,-8.53,-6.84,-4.62,-1.75,0.19,0.84,1.53,1.75,1.72,0.31,-1.03,-1.41,-1.28,-1.66,-2.53,-2.66,-2.88,-3.69,-4.72,-4.75,-3.62,-2.16,-1.06,0.47,1.91,3.41,3.12,2.28,2.25,2.72,2.53,2.22,2.81,3.56,4.06,3.66,3.28,3.34,2.69,1.09,-0.41,-1.19,-1.66,-2.78,-4.31,-4.84,-4.94,-5.38,-5.97,-5.34,-4.25,-3.09,-2.44,-1.31,0.38,1.69,2.19,2.06,2.25,2.62,1.66,0.78,0.59,0.53,-0.53,-2.53,-4.16,-5.5,-6.31,-6.75,-6.0,-4.31,-2.5,-2.0,-2.28,-2.31,-2.44,-3.19,-4.22,-3.88,-2.91,-2.06,-2.0,-1.94,-1.94,-2.72,-4.66,-6.0,-6.09,-5.41,-4.66,-3.81,-2.44,-0.66,-0.25,-0.62,-0.69,-0.12,-0.16,-0.69,-0.78,-0.06,0.03,-1.16,-2.59,-3.72,-4.72,-6.03,-6.69,-5.78,-3.88,-2.66,-2.03,-1.22,-0.34,-0.22,-0.88,-1.22,-0.88,-0.5,-1.09,-1.69,-1.72,-1.5,-1.59,-1.5,-0.19,1.84,2.53,2.88,2.53,2.44,2.03,0.75,-0.34,-0.44,0.0,-0.78,-1.41,-1.38,-1.66,-2.97,-4.31,-5.34,-5.03,-4.34,-3.84,-2.69,-0.47,1.31,1.72,2.19,3.56,4.91,5.0,4.81,4.78,4.25,2.88,1.47,0.97,2.19,3.53,4.78,6.41,8.88,10.59,11.25,11.34,11.84,12.47,11.22,9.47,7.91,6.62,5.03,3.41,2.78,3.47,4.0,3.66,3.62,4.25,4.94,4.97,4.75,5.16,5.56,4.69,3.22,2.25,1.53,0.66,-0.38,-0.59,0.56,1.56,2.28,2.91,4.09,4.25,3.31,2.03,1.28,1.34,0.72,0.38,0.78,1.72,2.19,2.41,2.91,4.38,5.62,5.78,5.66,6.44,6.5,5.62,4.06,3.41,3.09,2.53,2.16,2.44,3.84,4.66,4.78,5.0,5.91,6.75,6.22,5.12,4.75,4.66,4.53,4.25,4.69,6.28,6.62,6.28,5.84,5.75,5.09,3.25,1.28,0.81,0.38,-0.91,-2.19,-2.19,-1.75,-1.66,-1.22,0.12,1.91,3.44,4.06,4.75,6.25,7.12,6.88,6.59,7.28,8.06,8.0,7.62,8.06,8.25,7.34,5.59,4.28,3.75,3.09,3.12,3.34,4.72,5.47,4.94,3.84,3.81,4.03,3.97,4.19,5.25,6.72,7.22,7.41,7.62,8.78,9.38,9.0,8.44,8.5,7.97,6.59,5.03,4.31,4.38,4.0,3.62,4.22,5.72,6.19,5.66,4.97,4.66,3.66,2.38,1.28,1.59,2.59,3.12,3.69,5.28,7.31,8.56,8.91,9.78,10.62,10.78,9.72,8.5,8.44,7.72,6.03,4.56,4.22,3.62,2.53,1.22,0.88,1.53,1.91,2.22,4.38,6.81,8.97,10.12,11.53,13.22,13.97,13.44,12.53,11.56,10.84,10.0,9.0,8.72,9.0,8.56,7.16,6.16,6.0,6.0,6.09,7.09,9.31,12.06,13.41,14.38,15.19,15.25,14.84,13.69,13.62,14.22,14.66,13.94,13.5,13.75,13.34,12.22,11.12,11.38,11.25,10.38,9.34,9.72,10.31,11.19,11.66,12.62,14.03,15.09,14.97,15.25,15.88,16.38,15.03,12.84,10.88,8.56,5.72,2.72,1.41,1.25,2.0,2.72,4.5,7.5,9.69,10.59,11.25,11.91,12.38,12.19,12.22,13.34,14.44,14.81,14.41,14.12,13.97,13.28,11.84,11.12,10.97,11.03,10.12,9.62,9.81,9.94,9.38,8.44,3.19,2.47,1.81,1.69,2.28,3.81,5.56:-3.38,-3.53,-3.69,-3.66,-4.91,-6.88,-8.72,-9.91,-11.47,-13.19,-14.41,-14.94,-15.47,-16.34,-16.62,-15.84,-15.0,-14.59,-14.53,-14.31,-13.59,-13.47,-13.28,-12.72,-11.19,-9.84,-9.12,-8.19,-7.25,-6.75,-8.06,-9.56,-10.72,-11.69,-12.81,-13.88,-13.97,-12.84,-12.12,-11.25,-10.31,-8.94,-8.31,-8.69,-9.22,-8.88,-8.47,-8.5,-8.56,-8.09,-7.12,-7.59,-8.38,-8.41,-7.84,-7.47,-6.91,-6.31,-4.62,-3.03,-2.97,-3.16,-3.19,-3.75,-5.94,-8.34,-9.97,-11.28,-12.94,-14.41,-14.72,-13.66,-11.81,-10.09,-7.91,-5.5,-3.72,-3.91,-4.38,-4.78,-4.62,-5.78,-7.06,-7.44,-7.78,-9.0,-10.97,-12.38,-13.44,-14.91,-16.72,-17.81,-18.25,-18.22,-18.94,-19.62,-19.41,-18.84,-18.81,-18.78,-18.84,-18.12,-19.06,-20.56,-22.34,-22.88,-23.06,-23.72,-23.72,-22.75,-22.5,-23.28,-24.47,-24.78,-23.94,-23.66,-23.22,-21.69,-19.12,-17.25,-15.97,-14.88,-13.56,-12.53,-12.56,-12.28,-11.31,-10.5,-10.94,-11.72,-11.91,-11.66,-12.06,-12.97,-14.0,-14.59,-15.56,-17.09,-17.59,-16.69,-15.78,-15.0,-14.25,-12.47,-10.94,-10.69,-11.34,-12.0,-12.09,-13.06,-13.91,-13.72,-12.84,-12.12,-11.69,-11.81,-11.53,-11.59,-12.41,-14.12,-14.84,-15.28,-15.81,-16.09,-15.53,-14.16,-13.5,-13.41,-13.72,-13.53,-13.59,-14.41,-14.81,-14.28,-13.97,-14.28,-14.72,-14.25,-13.22,-12.94,-12.84,-12.66,-11.47,-10.62,-9.94,-8.66,-6.59,-5.09,-5.12,-5.72,-5.88,-6.19,-7.38,-8.97,-9.97,-10.91,-12.47,-14.0,-14.72,-13.97,-13.19,-12.16,-11.44,-10.12,-9.06,-9.34,-10.22,-10.22,-10.25,-11.19,-12.34,-12.84,-12.5,-12.5,-12.72,-12.97,-12.78,-12.47,-12.84,-13.0,-11.53,-10.12,-9.91,-10.28,-10.81,-11.69,-13.75,-16.22,-17.44,-17.25,-16.66,-15.69,-14.0,-11.44,-9.44,-8.94,-9.47,-9.31,-8.84,-9.28,-10.16,-9.69,-8.69,-8.22,-7.91,-6.94,-5.38,-4.34,-4.81,-5.66,-6.09,-7.34,-9.31,-11.22,-12.34,-13.0,-14.16,-15.59,-16.28,-16.53,-16.94,-17.19,-16.62,-15.19,-13.97,-13.72,-13.69,-13.16,-12.94,-13.25,-13.41,-12.59,-11.22,-10.56,-10.69,-10.03,-9.56,-10.0,-11.06,-12.19,-13.16,-14.31,-16.19,-18.22,-18.72,-18.34,-18.34,-17.81,-15.91,-13.41,-11.59,-11.44,-11.69,-12.38,-13.81,-16.31,-18.12,-18.25,-18.03,-18.28,-17.91,-17.0,-16.31,-16.59,-17.41,-17.22,-16.31,-15.16,-14.56,-13.09,-11.53,-11.38,-12.75,-14.72,-16.0,-17.16,-18.28,-18.72,-17.41,-15.03,-13.38,-12.25,-10.66,-9.75,-9.66,-10.69,-11.41,-11.03,-11.09,-11.84,-12.5,-12.31,-12.28,-13.03,-13.75,-13.47,-12.75,-13.19,-14.91,-16.34,-18.16,-19.94,-22.03,-22.94,-22.41,-21.38,-21.03,-20.72,-19.44,-17.72,-16.44,-15.31,-13.31,-10.94,-9.81,-9.59,-9.19,-8.66,-8.28,-8.81,-8.47,-7.31,-6.0,-5.69,-5.25,-4.31,-3.53,-3.88,-5.09,-6.47,-7.59,-9.0,-10.38,-10.53,-9.78,-9.47,-10.47,-11.81,-12.97,-14.25,-15.94,-17.19,-17.16,-16.5,-15.66,-14.72,-13.5,-11.44,-9.5,-8.53,-7.0,-5.44,-4.47,-5.62,-7.19,-8.66,-9.56,-10.91,-11.88,-11.62,-10.47,-10.12,-9.94,-9.75,-9.34,-9.28,-10.97,-12.47,-13.38,-13.75,-15.0,-15.34,-14.12,-12.41,-11.38,-10.44,-8.78,-7.28,-6.38,-6.53,-6.75,-6.84,-7.5,-9.12,-10.53,-11.16,-10.66,-10.84,-10.16,-8.34,-5.72,-4.5,-3.72,-3.12,-2.5,-2.38,-2.97,-3.12,-2.62,-2.56,-3.22,-3.88,-3.78,-2.88,-2.91,-1.78,0.09,2.53,4.03,5.16,5.81,6.12,5.25,3.06,1.03,-0.47,-1.38,-2.84,-4.16,-4.75,-4.59,-5.28,-5.53,-4.69,-2.84,-1.44,-0.19,1.5,3.47,5.03,5.41,6.0,7.69,9.22,9.94,10.03,9.97,9.31,7.47,4.78,3.12,2.66,1.91,0.75,0.06,-0.12,-0.84,-2.94,-4.78,-5.69,-6.41,-7.69,-8.41,-8.28,-6.94,-6.62,-6.5,-5.75,-4.84,-4.25,-4.12,-3.72,-2.22,-0.66,0.09,1.16,3.12,4.62,4.84,4.56,4.12,3.62,2.25,0.41,-1.25,-2.0,-3.06,-4.12,-4.25,-3.34,-2.16,-1.84,-2.0,-2.34,-2.66,-3.69,-4.62,-4.66,-3.72,-3.25,-3.09,-3.06,-2.59,-2.56,-3.16,-3.5,-2.94,-1.75,-1.47,-1.56,-1.41,-2.03,-3.56,-6.0,-8.16,-9.75,-11.53,-13.28,-14.59,-14.41,-14.16,-14.34,-14.34,-13.22,-12.25,-11.84,-11.69,-10.94,-10.5,-10.94,-11.59,-12.25,-12.41,-12.59,-13.12,-13.59,-13.03,-12.22,-11.56,-10.81,-9.19,-7.09,-5.62,-4.56,-3.72,-3.59,-4.5,-6.19,-8.22,-9.38,-9.66,-10.47,-10.69,-9.78,-8.69,-7.75,-6.84,-5.47,-3.69,-3.25,-3.16,-2.97,-2.62,-2.78,-3.66,-5.22,-6.19,-7.69,-9.53,-10.75,-9.88,-8.22,-6.34,-4.75,-3.0,-2.0,-2.47,-4.06,-5.66,-6.34,-6.72,-7.59,-7.81,-7.28,-7.19,-7.94,-8.47,-7.78,-7.09,-6.59,-6.84,-6.94,-6.81,-7.38,-7.88,-8.03,-7.53,-7.62,-8.38,-9.62,-10.38,-10.97,-12.19,-12.38,-11.25,-9.62,-8.28,-7.47,-6.75,-5.84,-5.28,-4.97,-3.91,-1.44,0.72,1.34,1.53,1.75,1.78,0.78,-0.25,-0.31,-0.59,-1.03,-2.31,-3.06,-3.19,-3.44,-4.44,-5.34,-5.69,-6.06,-6.88,-7.62,-6.75,-5.59,-4.28,-3.59,-2.53,-1.25,-0.34,-0.38,-0.06,0.81,1.19,0.69,-0.22,-0.84,-1.62,-3.38,-5.34,-6.22,-7.06,-8.06,-9.38,-9.59,-9.09,-8.12,-6.97,-5.19,-2.56,-0.31,0.66,1.25,2.03,2.44,2.12,0.81,0.0,-0.53,-1.94,-3.66,-5.19,-6.34,-7.22,-8.81,-9.84,-9.72,-9.5,-10.22,-10.97,-10.59,-9.78,-8.53,-6.84,-4.62,-1.75,0.19,0.84,1.53,1.75,1.72,0.31,-1.03,-1.41,-1.28,-1.66,-2.53,-2.66,-2.88,-3.69,-4.72,-4.75,-3.62,-2.16,-1.06,0.47,1.91,3.41,3.12,2.28,2.25,2.72,2.53,2.22,2.81,3.56,4.06,3.66,3.28,3.34,2.69,1.09,-0.41,-1.19,-1.66,-2.78,-4.31,-4.84,-4.94,-5.38,-5.97,-5.34,-4.25,-3.09,-2.44,-1.31,0.38,1.69,2.19,2.06,2.25,2.62,1.66,0.78,0.59,0.53,-0.53,-2.53,-4.16,-5.5,-6.31,-6.75,-6.0,-4.31,-2.5,-2.0,-2.28,-2.31,-2.44,-3.19,-4.22,-3.88,-2.91,-2.06,-2.0,-1.94,-1.94,-2.72,-4.66,-6.0,-6.09,-5.41,-4.66,-3.81,-2.44,-0.66,-0.25,-0.62,-0.69,-0.12,-0.16,-0.69,-0.78,-0.06,0.03,-1.16,-2.59,-3.72,-4.72,-6.03,-6.69,-5.78,-3.88,-2.66,-2.03,-1.22,-0.34,-0.22,-0.88,-1.22,-0.88,-0.5,-1.09,-1.69,-1.72,-1.5,-1.59,-1.5,-0.19,1.84,2.53,2.88,2.53,2.44,2.03,0.75,-0.34,-0.44,0.0,-0.78,-1.41,-1.38,-1.66,-2.97,-4.31,-5.34,-5.03,-4.34,-3.84,-2.69,-0.47,1.31,1.72,2.19,3.56,4.91,5.0,4.81,4.78,4.25,2.88,1.47,0.97,2.19,3.53,4.78,6.41,8.88,10.59,11.25,11.34,11.84,12.47,11.22,9.47,7.91,6.62,5.03,3.41,2.78,3.47,4.0,3.66,3.62,4.25,4.94,4.97,4.75,5.16,5.56,4.69,3.22,2.25,1.53,0.66,-0.38,-0.59,0.56,1.56,2.28,2.91,4.09,4.25,3.31,2.03,1.28,1.34,0.72,0.38,0.78,1.72,2.19,2.41,2.91,4.38,5.62,5.78,5.66,6.44,6.5,5.62,4.06,3.41,3.09,2.53,2.16,2.44,3.84,4.66,4.78,5.0,5.91,6.75,6.22,5.12,4.75,4.66,4.53,4.25,4.69,6.28,6.62,6.28,5.84,5.75,5.09,3.25,1.28,0.81,0.38,-0.91,-2.19,-2.19,-1.75,-1.66,-1.22,0.12,1.91,3.44,4.06,4.75,6.25,7.12,6.88,6.59,7.28,8.06,8.0,7.62,8.06,8.25,7.34,5.59,4.28,3.75,3.09,3.12,3.34,4.72,5.47,4.94,3.84,3.81,4.03,3.97,4.19,5.25,6.72,7.22,7.41,7.62,8.78,9.38,9.0,8.44,8.5,7.97,6.59,5.03,4.31,4.38,4.0,3.62,4.22,5.72,6.19,5.66,4.97,4.66,3.66,2.38,1.28,1.59,2.59,3.12,3.69,5.28,7.31,8.56,8.91,9.78,10.62,10.78,9.72,8.5,8.44,7.72,6.03,4.56,4.22,3.62,2.53,1.22,0.88,1.53,1.91,2.22,4.38,6.81,8.97,10.12,11.53,13.22,13.97,13.44,12.53,11.56,10.84,10.0,9.0,8.72,9.0,8.56,7.16,6.16,6.0,6.0,6.09,7.09,9.31,12.06,13.41,14.38,15.19,15.25,14.84,13.69,13.62,14.22,14.66,13.94,13.5,13.75,13.34,12.22,11.12,11.38,11.25,10.38,9.34,9.72,10.31,11.19,11.66,12.62,14.03,15.09,14.97,15.25,15.88,16.38,15.03,12.84,10.88,8.56,5.72,2.72,1.41,1.25,2.0,2.72,4.5,7.5,9.69,10.59,11.25,11.91,12.38,12.19,12.22,13.34,14.44,14.81,14.41,14.12,13.97,13.28,11.84,11.12,10.97,11.03,10.12,9.62,9.81,9.94,9.38,8.44,3.19,2.47,1.81,1.69,2.28,3.81,5.56,7.22,8.62,9.72,10.22,10.38,10.31,10.56:-9.91,-11.47,-13.19,-14.41,-14.94,-15.47,-16.34,-16.62,-15.84,-15.0,-14.59,-14.53,-14.31,-13.59,-13.47,-13.28,-12.72,-11.19,-9.84,-9.12,-8.19,-7.25,-6.75,-8.06,-9.56,-10.72,-11.69,-12.81,-13.88,-13.97,-12.84,-12.12,-11.25,-10.31,-8.94,-8.31,-8.69,-9.22,-8.88,-8.47,-8.5,-8.56,-8.09,-7.12,-7.59,-8.38,-8.41,-7.84,-7.47,-6.91,-6.31,-4.62,-3.03,-2.97,-3.16,-3.19,-3.75,-5.94,-8.34,-9.97,-11.28,-12.94,-14.41,-14.72,-13.66,-11.81,-10.09,-7.91,-5.5,-3.72,-3.91,-4.38,-4.78,-4.62,-5.78,-7.06,-7.44,-7.78,-9.0,-10.97,-12.38,-13.44,-14.91,-16.72,-17.81,-18.25,-18.22,-18.94,-19.62,-19.41,-18.84,-18.81,-18.78,-18.84,-18.12,-19.06,-20.56,-22.34,-22.88,-23.06,-23.72,-23.72,-22.75,-22.5,-23.28,-24.47,-24.78,-23.94,-23.66,-23.22,-21.69,-19.12,-17.25,-15.97,-14.88,-13.56,-12.53,-12.56,-12.28,-11.31,-10.5,-10.94,-11.72,-11.91,-11.66,-12.06,-12.97,-14.0,-14.59,-15.56,-17.09,-17.59,-16.69,-15.78,-15.0,-14.25,-12.47,-10.94,-10.69,-11.34,-12.0,-12.09,-13.06,-13.91,-13.72,-12.84,-12.12,-11.69,-11.81,-11.53,-11.59,-12.41,-14.12,-14.84,-15.28,-15.81,-16.09,-15.53,-14.16,-13.5,-13.41,-13.72,-13.53,-13.59,-14.41,-14.81,-14.28,-13.97,-14.28,-14.72,-14.25,-13.22,-12.94,-12.84,-12.66,-11.47,-10.62,-9.94,-8.66,-6.59,-5.09,-5.12,-5.72,-5.88,-6.19,-7.38,-8.97,-9.97,-10.91,-12.47,-14.0,-14.72,-13.97,-13.19,-12.16,-11.44,-10.12,-9.06,-9.34,-10.22,-10.22,-10.25,-11.19,-12.34,-12.84,-12.5,-12.5,-12.72,-12.97,-12.78,-12.47,-12.84,-13.0,-11.53,-10.12,-9.91,-10.28,-10.81,-11.69,-13.75,-16.22,-17.44,-17.25,-16.66,-15.69,-14.0,-11.44,-9.44,-8.94,-9.47,-9.31,-8.84,-9.28,-10.16,-9.69,-8.69,-8.22,-7.91,-6.94,-5.38,-4.34,-4.81,-5.66,-6.09,-7.34,-9.31,-11.22,-12.34,-13.0,-14.16,-15.59,-16.28,-16.53,-16.94,-17.19,-16.62,-15.19,-13.97,-13.72,-13.69,-13.16,-12.94,-13.25,-13.41,-12.59,-11.22,-10.56,-10.69,-10.03,-9.56,-10.0,-11.06,-12.19,-13.16,-14.31,-16.19,-18.22,-18.72,-18.34,-18.34,-17.81,-15.91,-13.41,-11.59,-11.44,-11.69,-12.38,-13.81,-16.31,-18.12,-18.25,-18.03,-18.28,-17.91,-17.0,-16.31,-16.59,-17.41,-17.22,-16.31,-15.16,-14.56,-13.09,-11.53,-11.38,-12.75,-14.72,-16.0,-17.16,-18.28,-18.72,-17.41,-15.03,-13.38,-12.25,-10.66,-9.75,-9.66,-10.69,-11.41,-11.03,-11.09,-11.84,-12.5,-12.31,-12.28,-13.03,-13.75,-13.47,-12.75,-13.19,-14.91,-16.34,-18.16,-19.94,-22.03,-22.94,-22.41,-21.38,-21.03,-20.72,-19.44,-17.72,-16.44,-15.31,-13.31,-10.94,-9.81,-9.59,-9.19,-8.66,-8.28,-8.81,-8.47,-7.31,-6.0,-5.69,-5.25,-4.31,-3.53,-3.88,-5.09,-6.47,-7.59,-9.0,-10.38,-10.53,-9.78,-9.47,-10.47,-11.81,-12.97,-14.25,-15.94,-17.19,-17.16,-16.5,-15.66,-14.72,-13.5,-11.44,-9.5,-8.53,-7.0,-5.44,-4.47,-5.62,-7.19,-8.66,-9.56,-10.91,-11.88,-11.62,-10.47,-10.12,-9.94,-9.75,-9.34,-9.28,-10.97,-12.47,-13.38,-13.75,-15.0,-15.34,-14.12,-12.41,-11.38,-10.44,-8.78,-7.28,-6.38,-6.53,-6.75,-6.84,-7.5,-9.12,-10.53,-11.16,-10.66,-10.84,-10.16,-8.34,-5.72,-4.5,-3.72,-3.12,-2.5,-2.38,-2.97,-3.12,-2.62,-2.56,-3.22,-3.88,-3.78,-2.88,-2.91,-1.78,0.09,2.53,4.03,5.16,5.81,6.12,5.25,3.06,1.03,-0.47,-1.38,-2.84,-4.16,-4.75,-4.59,-5.28,-5.53,-4.69,-2.84,-1.44,-0.19,1.5,3.47,5.03,5.41,6.0,7.69,9.22,9.94,10.03,9.97,9.31,7.47,4.78,3.12,2.66,1.91,0.75,0.06,-0.12,-0.84,-2.94,-4.78,-5.69,-6.41,-7.69,-8.41,-8.28,-6.94,-6.62,-6.5,-5.75,-4.84,-4.25,-4.12,-3.72,-2.22,-0.66,0.09,1.16,3.12,4.62,4.84,4.56,4.12,3.62,2.25,0.41,-1.25,-2.0,-3.06,-4.12,-4.25,-3.34,-2.16,-1.84,-2.0,-2.34,-2.66,-3.69,-4.62,-4.66,-3.72,-3.25,-3.09,-3.06,-2.59,-2.56,-3.16,-3.5,-2.94,-1.75,-1.47,-1.56,-1.41,-2.03,-3.56,-6.0,-8.16,-9.75,-11.53,-13.28,-14.59,-14.41,-14.16,-14.34,-14.34,-13.22,-12.25,-11.84,-11.69,-10.94,-10.5,-10.94,-11.59,-12.25,-12.41,-12.59,-13.12,-13.59,-13.03,-12.22,-11.56,-10.81,-9.19,-7.09,-5.62,-4.56,-3.72,-3.59,-4.5,-6.19,-8.22,-9.38,-9.66,-10.47,-10.69,-9.78,-8.69,-7.75,-6.84,-5.47,-3.69,-3.25,-3.16,-2.97,-2.62,-2.78,-3.66,-5.22,-6.19,-7.69,-9.53,-10.75,-9.88,-8.22,-6.34,-4.75,-3.0,-2.0,-2.47,-4.06,-5.66,-6.34,-6.72,-7.59,-7.81,-7.28,-7.19,-7.94,-8.47,-7.78,-7.09,-6.59,-6.84,-6.94,-6.81,-7.38,-7.88,-8.03,-7.53,-7.62,-8.38,-9.62,-10.38,-10.97,-12.19,-12.38,-11.25,-9.62,-8.28,-7.47,-6.75,-5.84,-5.28,-4.97,-3.91,-1.44,0.72,1.34,1.53,1.75,1.78,0.78,-0.25,-0.31,-0.59,-1.03,-2.31,-3.06,-3.19,-3.44,-4.44,-5.34,-5.69,-6.06,-6.88,-7.62,-6.75,-5.59,-4.28,-3.59,-2.53,-1.25,-0.34,-0.38,-0.06,0.81,1.19,0.69,-0.22,-0.84,-1.62,-3.38,-5.34,-6.22,-7.06,-8.06,-9.38,-9.59,-9.09,-8.12,-6.97,-5.19,-2.56,-0.31,0.66,1.25,2.03,2.44,2.12,0.81,0.0,-0.53,-1.94,-3.66,-5.19,-6.34,-7.22,-8.81,-9.84,-9.72,-9.5,-10.22,-10.97,-10.59,-9.78,-8.53,-6.84,-4.62,-1.75,0.19,0.84,1.53,1.75,1.72,0.31,-1.03,-1.41,-1.28,-1.66,-2.53,-2.66,-2.88,-3.69,-4.72,-4.75,-3.62,-2.16,-1.06,0.47,1.91,3.41,3.12,2.28,2.25,2.72,2.53,2.22,2.81,3.56,4.06,3.66,3.28,3.34,2.69,1.09,-0.41,-1.19,-1.66,-2.78,-4.31,-4.84,-4.94,-5.38,-5.97,-5.34,-4.25,-3.09,-2.44,-1.31,0.38,1.69,2.19,2.06,2.25,2.62,1.66,0.78,0.59,0.53,-0.53,-2.53,-4.16,-5.5,-6.31,-6.75,-6.0,-4.31,-2.5,-2.0,-2.28,-2.31,-2.44,-3.19,-4.22,-3.88,-2.91,-2.06,-2.0,-1.94,-1.94,-2.72,-4.66,-6.0,-6.09,-5.41,-4.66,-3.81,-2.44,-0.66,-0.25,-0.62,-0.69,-0.12,-0.16,-0.69,-0.78,-0.06,0.03,-1.16,-2.59,-3.72,-4.72,-6.03,-6.69,-5.78,-3.88,-2.66,-2.03,-1.22,-0.34,-0.22,-0.88,-1.22,-0.88,-0.5,-1.09,-1.69,-1.72,-1.5,-1.59,-1.5,-0.19,1.84,2.53,2.88,2.53,2.44,2.03,0.75,-0.34,-0.44,0.0,-0.78,-1.41,-1.38,-1.66,-2.97,-4.31,-5.34,-5.03,-4.34,-3.84,-2.69,-0.47,1.31,1.72,2.19,3.56,4.91,5.0,4.81,4.78,4.25,2.88,1.47,0.97,2.19,3.53,4.78,6.41,8.88,10.59,11.25,11.34,11.84,12.47,11.22,9.47,7.91,6.62,5.03,3.41,2.78,3.47,4.0,3.66,3.62,4.25,4.94,4.97,4.75,5.16,5.56,4.69,3.22,2.25,1.53,0.66,-0.38,-0.59,0.56,1.56,2.28,2.91,4.09,4.25,3.31,2.03,1.28,1.34,0.72,0.38,0.78,1.72,2.19,2.41,2.91,4.38,5.62,5.78,5.66,6.44,6.5,5.62,4.06,3.41,3.09,2.53,2.16,2.44,3.84,4.66,4.78,5.0,5.91,6.75,6.22,5.12,4.75,4.66,4.53,4.25,4.69,6.28,6.62,6.28,5.84,5.75,5.09,3.25,1.28,0.81,0.38,-0.91,-2.19,-2.19,-1.75,-1.66,-1.22,0.12,1.91,3.44,4.06,4.75,6.25,7.12,6.88,6.59,7.28,8.06,8.0,7.62,8.06,8.25,7.34,5.59,4.28,3.75,3.09,3.12,3.34,4.72,5.47,4.94,3.84,3.81,4.03,3.97,4.19,5.25,6.72,7.22,7.41,7.62,8.78,9.38,9.0,8.44,8.5,7.97,6.59,5.03,4.31,4.38,4.0,3.62,4.22,5.72,6.19,5.66,4.97,4.66,3.66,2.38,1.28,1.59,2.59,3.12,3.69,5.28,7.31,8.56,8.91,9.78,10.62,10.78,9.72,8.5,8.44,7.72,6.03,4.56,4.22,3.62,2.53,1.22,0.88,1.53,1.91,2.22,4.38,6.81,8.97,10.12,11.53,13.22,13.97,13.44,12.53,11.56,10.84,10.0,9.0,8.72,9.0,8.56,7.16,6.16,6.0,6.0,6.09,7.09,9.31,12.06,13.41,14.38,15.19,15.25,14.84,13.69,13.62,14.22,14.66,13.94,13.5,13.75,13.34,12.22,11.12,11.38,11.25,10.38,9.34,9.72,10.31,11.19,11.66,12.62,14.03,15.09,14.97,15.25,15.88,16.38,15.03,12.84,10.88,8.56,5.72,2.72,1.41,1.25,2.0,2.72,4.5,7.5,9.69,10.59,11.25,11.91,12.38,12.19,12.22,13.34,14.44,14.81,14.41,14.12,13.97,13.28,11.84,11.12,10.97,11.03,10.12,9.62,9.81,9.94,9.38,8.44,3.19,2.47,1.81,1.69,2.28,3.81,5.56,7.22,8.62,9.72,10.22,10.38,10.31,10.56,10.66,10.38,9.22,8.19,6.53,4.62,2.59:-16.62,-15.84,-15.0,-14.59,-14.53,-14.31,-13.59,-13.47,-13.28,-12.72,-11.19,-9.84,-9.12,-8.19,-7.25,-6.75,-8.06,-9.56,-10.72,-11.69,-12.81,-13.88,-13.97,-12.84,-12.12,-11.25,-10.31,-8.94,-8.31,-8.69,-9.22,-8.88,-8.47,-8.5,-8.56,-8.09,-7.12,-7.59,-8.38,-8.41,-7.84,-7.47,-6.91,-6.31,-4.62,-3.03,-2.97,-3.16,-3.19,-3.75,-5.94,-8.34,-9.97,-11.28,-12.94,-14.41,-14.72,-13.66,-11.81,-10.09,-7.91,-5.5,-3.72,-3.91,-4.38,-4.78,-4.62,-5.78,-7.06,-7.44,-7.78,-9.0,-10.97,-12.38,-13.44,-14.91,-16.72,-17.81,-18.25,-18.22,-18.94,-19.62,-19.41,-18.84,-18.81,-18.78,-18.84,-18.12,-19.06,-20.56,-22.34,-22.88,-23.06,-23.72,-23.72,-22.75,-22.5,-23.28,-24.47,-24.78,-23.94,-23.66,-23.22,-21.69,-19.12,-17.25,-15.97,-14.88,-13.56,-12.53,-12.56,-12.28,-11.31,-10.5,-10.94,-11.72,-11.91,-11.66,-12.06,-12.97,-14.0,-14.59,-15.56,-17.09,-17.59,-16.69,-15.78,-15.0,-14.25,-12.47,-10.94,-10.69,-11.34,-12.0,-12.09,-13.06,-13.91,-13.72,-12.84,-12.12,-11.69,-11.81,-11.53,-11.59,-12.41,-14.12,-14.84,-15.28,-15.81,-16.09,-15.53,-14.16,-13.5,-13.41,-13.72,-13.53,-13.59,-14.41,-14.81,-14.28,-13.97,-14.28,-14.72,-14.25,-13.22,-12.94,-12.84,-12.66,-11.47,-10.62,-9.94,-8.66,-6.59,-5.09,-5.12,-5.72,-5.88,-6.19,-7.38,-8.97,-9.97,-10.91,-12.47,-14.0,-14.72,-13.97,-13.19,-12.16,-11.44,-10.12,-9.06,-9.34,-10.22,-10.22,-10.25,-11.19,-12.34,-12.84,-12.5,-12.5,-12.72,-12.97,-12.78,-12.47,-12.84,-13.0,-11.53,-10.12,-9.91,-10.28,-10.81,-11.69,-13.75,-16.22,-17.44,-17.25,-16.66,-15.69,-14.0,-11.44,-9.44,-8.94,-9.47,-9.31,-8.84,-9.28,-10.16,-9.69,-8.69,-8.22,-7.91,-6.94,-5.38,-4.34,-4.81,-5.66,-6.09,-7.34,-9.31,-11.22,-12.34,-13.0,-14.16,-15.59,-16.28,-16.53,-16.94,-17.19,-16.62,-15.19,-13.97,-13.72,-13.69,-13.16,-12.94,-13.25,-13.41,-12.59,-11.22,-10.56,-10.69,-10.03,-9.56,-10.0,-11.06,-12.19,-13.16,-14.31,-16.19,-18.22,-18.72,-18.34,-18.34,-17.81,-15.91,-13.41,-11.59,-11.44,-11.69,-12.38,-13.81,-16.31,-18.12,-18.25,-18.03,-18.28,-17.91,-17.0,-16.31,-16.59,-17.41,-17.22,-16.31,-15.16,-14.56,-13.09,-11.53,-11.38,-12.75,-14.72,-16.0,-17.16,-18.28,-18.72,-17.41,-15.03,-13.38,-12.25,-10.66,-9.75,-9.66,-10.69,-11.41,-11.03,-11.09,-11.84,-12.5,-12.31,-12.28,-13.03,-13.75,-13.47,-12.75,-13.19,-14.91,-16.34,-18.16,-19.94,-22.03,-22.94,-22.41,-21.38,-21.03,-20.72,-19.44,-17.72,-16.44,-15.31,-13.31,-10.94,-9.81,-9.59,-9.19,-8.66,-8.28,-8.81,-8.47,-7.31,-6.0,-5.69,-5.25,-4.31,-3.53,-3.88,-5.09,-6.47,-7.59,-9.0,-10.38,-10.53,-9.78,-9.47,-10.47,-11.81,-12.97,-14.25,-15.94,-17.19,-17.16,-16.5,-15.66,-14.72,-13.5,-11.44,-9.5,-8.53,-7.0,-5.44,-4.47,-5.62,-7.19,-8.66,-9.56,-10.91,-11.88,-11.62,-10.47,-10.12,-9.94,-9.75,-9.34,-9.28,-10.97,-12.47,-13.38,-13.75,-15.0,-15.34,-14.12,-12.41,-11.38,-10.44,-8.78,-7.28,-6.38,-6.53,-6.75,-6.84,-7.5,-9.12,-10.53,-11.16,-10.66,-10.84,-10.16,-8.34,-5.72,-4.5,-3.72,-3.12,-2.5,-2.38,-2.97,-3.12,-2.62,-2.56,-3.22,-3.88,-3.78,-2.88,-2.91,-1.78,0.09,2.53,4.03,5.16,5.81,6.12,5.25,3.06,1.03,-0.47,-1.38,-2.84,-4.16,-4.75,-4.59,-5.28,-5.53,-4.69,-2.84,-1.44,-0.19,1.5,3.47,5.03,5.41,6.0,7.69,9.22,9.94,10.03,9.97,9.31,7.47,4.78,3.12,2.66,1.91,0.75,0.06,-0.12,-0.84,-2.94,-4.78,-5.69,-6.41,-7.69,-8.41,-8.28,-6.94,-6.62,-6.5,-5.75,-4.84,-4.25,-4.12,-3.72,-2.22,-0.66,0.09,1.16,3.12,4.62,4.84,4.56,4.12,3.62,2.25,0.41,-1.25,-2.0,-3.06,-4.12,-4.25,-3.34,-2.16,-1.84,-2.0,-2.34,-2.66,-3.69,-4.62,-4.66,-3.72,-3.25,-3.09,-3.06,-2.59,-2.56,-3.16,-3.5,-2.94,-1.75,-1.47,-1.56,-1.41,-2.03,-3.56,-6.0,-8.16,-9.75,-11.53,-13.28,-14.59,-14.41,-14.16,-14.34,-14.34,-13.22,-12.25,-11.84,-11.69,-10.94,-10.5,-10.94,-11.59,-12.25,-12.41,-12.59,-13.12,-13.59,-13.03,-12.22,-11.56,-10.81,-9.19,-7.09,-5.62,-4.56,-3.72,-3.59,-4.5,-6.19,-8.22,-9.38,-9.66,-10.47,-10.69,-9.78,-8.69,-7.75,-6.84,-5.47,-3.69,-3.25,-3.16,-2.97,-2.62,-2.78,-3.66,-5.22,-6.19,-7.69,-9.53,-10.75,-9.88,-8.22,-6.34,-4.75,-3.0,-2.0,-2.47,-4.06,-5.66,-6.34,-6.72,-7.59,-7.81,-7.28,-7.19,-7.94,-8.47,-7.78,-7.09,-6.59,-6.84,-6.94,-6.81,-7.38,-7.88,-8.03,-7.53,-7.62,-8.38,-9.62,-10.38,-10.97,-12.19,-12.38,-11.25,-9.62,-8.28,-7.47,-6.75,-5.84,-5.28,-4.97,-3.91,-1.44,0.72,1.34,1.53,1.75,1.78,0.78,-0.25,-0.31,-0.59,-1.03,-2.31,-3.06,-3.19,-3.44,-4.44,-5.34,-5.69,-6.06,-6.88,-7.62,-6.75,-5.59,-4.28,-3.59,-2.53,-1.25,-0.34,-0.38,-0.06,0.81,1.19,0.69,-0.22,-0.84,-1.62,-3.38,-5.34,-6.22,-7.06,-8.06,-9.38,-9.59,-9.09,-8.12,-6.97,-5.19,-2.56,-0.31,0.66,1.25,2.03,2.44,2.12,0.81,0.0,-0.53,-1.94,-3.66,-5.19,-6.34,-7.22,-8.81,-9.84,-9.72,-9.5,-10.22,-10.97,-10.59,-9.78,-8.53,-6.84,-4.62,-1.75,0.19,0.84,1.53,1.75,1.72,0.31,-1.03,-1.41,-1.28,-1.66,-2.53,-2.66,-2.88,-3.69,-4.72,-4.75,-3.62,-2.16,-1.06,0.47,1.91,3.41,3.12,2.28,2.25,2.72,2.53,2.22,2.81,3.56,4.06,3.66,3.28,3.34,2.69,1.09,-0.41,-1.19,-1.66,-2.78,-4.31,-4.84,-4.94,-5.38,-5.97,-5.34,-4.25,-3.09,-2.44,-1.31,0.38,1.69,2.19,2.06,2.25,2.62,1.66,0.78,0.59,0.53,-0.53,-2.53,-4.16,-5.5,-6.31,-6.75,-6.0,-4.31,-2.5,-2.0,-2.28,-2.31,-2.44,-3.19,-4.22,-3.88,-2.91,-2.06,-2.0,-1.94,-1.94,-2.72,-4.66,-6.0,-6.09,-5.41,-4.66,-3.81,-2.44,-0.66,-0.25,-0.62,-0.69,-0.12,-0.16,-0.69,-0.78,-0.06,0.03,-1.16,-2.59,-3.72,-4.72,-6.03,-6.69,-5.78,-3.88,-2.66,-2.03,-1.22,-0.34,-0.22,-0.88,-1.22,-0.88,-0.5,-1.09,-1.69,-1.72,-1.5,-1.59,-1.5,-0.19,1.84,2.53,2.88,2.53,2.44,2.03,0.75,-0.34,-0.44,0.0,-0.78,-1.41,-1.38,-1.66,-2.97,-4.31,-5.34,-5.03,-4.34,-3.84,-2.69,-0.47,1.31,1.72,2.19,3.56,4.91,5.0,4.81,4.78,4.25,2.88,1.47,0.97,2.19,3.53,4.78,6.41,8.88,10.59,11.25,11.34,11.84,12.47,11.22,9.47,7.91,6.62,5.03,3.41,2.78,3.47,4.0,3.66,3.62,4.25,4.94,4.97,4.75,5.16,5.56,4.69,3.22,2.25,1.53,0.66,-0.38,-0.59,0.56,1.56,2.28,2.91,4.09,4.25,3.31,2.03,1.28,1.34,0.72,0.38,0.78,1.72,2.19,2.41,2.91,4.38,5.62,5.78,5.66,6.44,6.5,5.62,4.06,3.41,3.09,2.53,2.16,2.44,3.84,4.66,4.78,5.0,5.91,6.75,6.22,5.12,4.75,4.66,4.53,4.25,4.69,6.28,6.62,6.28,5.84,5.75,5.09,3.25,1.28,0.81,0.38,-0.91,-2.19,-2.19,-1.75,-1.66,-1.22,0.12,1.91,3.44,4.06,4.75,6.25,7.12,6.88,6.59,7.28,8.06,8.0,7.62,8.06,8.25,7.34,5.59,4.28,3.75,3.09,3.12,3.34,4.72,5.47,4.94,3.84,3.81,4.03,3.97,4.19,5.25,6.72,7.22,7.41,7.62,8.78,9.38,9.0,8.44,8.5,7.97,6.59,5.03,4.31,4.38,4.0,3.62,4.22,5.72,6.19,5.66,4.97,4.66,3.66,2.38,1.28,1.59,2.59,3.12,3.69,5.28,7.31,8.56,8.91,9.78,10.62,10.78,9.72,8.5,8.44,7.72,6.03,4.56,4.22,3.62,2.53,1.22,0.88,1.53,1.91,2.22,4.38,6.81,8.97,10.12,11.53,13.22,13.97,13.44,12.53,11.56,10.84,10.0,9.0,8.72,9.0,8.56,7.16,6.16,6.0,6.0,6.09,7.09,9.31,12.06,13.41,14.38,15.19,15.25,14.84,13.69,13.62,14.22,14.66,13.94,13.5,13.75,13.34,12.22,11.12,11.38,11.25,10.38,9.34,9.72,10.31,11.19,11.66,12.62,14.03,15.09,14.97,15.25,15.88,16.38,15.03,12.84,10.88,8.56,5.72,2.72,1.41,1.25,2.0,2.72,4.5,7.5,9.69,10.59,11.25,11.91,12.38,12.19,12.22,13.34,14.44,14.81,14.41,14.12,13.97,13.28,11.84,11.12,10.97,11.03,10.12,9.62,9.81,9.94,9.38,8.44,3.19,2.47,1.81,1.69,2.28,3.81,5.56,7.22,8.62,9.72,10.22,10.38,10.31,10.56,10.66,10.38,9.22,8.19,6.53,4.62,2.59,1.16,0.19,0.0,-0.22,-0.19,0.44,1.59:-13.47,-13.28,-12.72,-11.19,-9.84,-9.12,-8.19,-7.25,-6.75,-8.06,-9.56,-10.72,-11.69,-12.81,-13.88,-13.97,-12.84,-12.12,-11.25,-10.31,-8.94,-8.31,-8.69,-9.22,-8.88,-8.47,-8.5,-8.56,-8.09,-7.12,-7.59,-8.38,-8.41,-7.84,-7.47,-6.91,-6.31,-4.62,-3.03,-2.97,-3.16,-3.19,-3.75,-5.94,-8.34,-9.97,-11.28,-12.94,-14.41,-14.72,-13.66,-11.81,-10.09,-7.91,-5.5,-3.72,-3.91,-4.38,-4.78,-4.62,-5.78,-7.06,-7.44,-7.78,-9.0,-10.97,-12.38,-13.44,-14.91,-16.72,-17.81,-18.25,-18.22,-18.94,-19.62,-19.41,-18.84,-18.81,-18.78,-18.84,-18.12,-19.06,-20.56,-22.34,-22.88,-23.06,-23.72,-23.72,-22.75,-22.5,-23.28,-24.47,-24.78,-23.94,-23.66,-23.22,-21.69,-19.12,-17.25,-15.97,-14.88,-13.56,-12.53,-12.56,-12.28,-11.31,-10.5,-10.94,-11.72,-11.91,-11.66,-12.06,-12.97,-14.0,-14.59,-15.56,-17.09,-17.59,-16.69,-15.78,-15.0,-14.25,-12.47,-10.94,-10.69,-11.34,-12.0,-12.09,-13.06,-13.91,-13.72,-12.84,-12.12,-11.69,-11.81,-11.53,-11.59,-12.41,-14.12,-14.84,-15.28,-15.81,-16.09,-15.53,-14.16,-13.5,-13.41,-13.72,-13.53,-13.59,-14.41,-14.81,-14.28,-13.97,-14.28,-14.72,-14.25,-13.22,-12.94,-12.84,-12.66,-11.47,-10.62,-9.94,-8.66,-6.59,-5.09,-5.12,-5.72,-5.88,-6.19,-7.38,-8.97,-9.97,-10.91,-12.47,-14.0,-14.72,-13.97,-13.19,-12.16,-11.44,-10.12,-9.06,-9.34,-10.22,-10.22,-10.25,-11.19,-12.34,-12.84,-12.5,-12.5,-12.72,-12.97,-12.78,-12.47,-12.84,-13.0,-11.53,-10.12,-9.91,-10.28,-10.81,-11.69,-13.75,-16.22,-17.44,-17.25,-16.66,-15.69,-14.0,-11.44,-9.44,-8.94,-9.47,-9.31,-8.84,-9.28,-10.16,-9.69,-8.69,-8.22,-7.91,-6.94,-5.38,-4.34,-4.81,-5.66,-6.09,-7.34,-9.31,-11.22,-12.34,-13.0,-14.16,-15.59,-16.28,-16.53,-16.94,-17.19,-16.62,-15.19,-13.97,-13.72,-13.69,-13.16,-12.94,-13.25,-13.41,-12.59,-11.22,-10.56,-10.69,-10.03,-9.56,-10.0,-11.06,-12.19,-13.16,-14.31,-16.19,-18.22,-18.72,-18.34,-18.34,-17.81,-15.91,-13.41,-11.59,-11.44,-11.69,-12.38,-13.81,-16.31,-18.12,-18.25,-18.03,-18.28,-17.91,-17.0,-16.31,-16.59,-17.41,-17.22,-16.31,-15.16,-14.56,-13.09,-11.53,-11.38,-12.75,-14.72,-16.0,-17.16,-18.28,-18.72,-17.41,-15.03,-13.38,-12.25,-10.66,-9.75,-9.66,-10.69,-11.41,-11.03,-11.09,-11.84,-12.5,-12.31,-12.28,-13.03,-13.75,-13.47,-12.75,-13.19,-14.91,-16.34,-18.16,-19.94,-22.03,-22.94,-22.41,-21.38,-21.03,-20.72,-19.44,-17.72,-16.44,-15.31,-13.31,-10.94,-9.81,-9.59,-9.19,-8.66,-8.28,-8.81,-8.47,-7.31,-6.0,-5.69,-5.25,-4.31,-3.53,-3.88,-5.09,-6.47,-7.59,-9.0,-10.38,-10.53,-9.78,-9.47,-10.47,-11.81,-12.97,-14.25,-15.94,-17.19,-17.16,-16.5,-15.66,-14.72,-13.5,-11.44,-9.5,-8.53,-7.0,-5.44,-4.47,-5.62,-7.19,-8.66,-9.56,-10.91,-11.88,-11.62,-10.47,-10.12,-9.94,-9.75,-9.34,-9.28,-10.97,-12.47,-13.38,-13.75,-15.0,-15.34,-14.12,-12.41,-11.38,-10.44,-8.78,-7.28,-6.38,-6.53,-6.75,-6.84,-7.5,-9.12,-10.53,-11.16,-10.66,-10.84,-10.16,-8.34,-5.72,-4.5,-3.72,-3.12,-2.5,-2.38,-2.97,-3.12,-2.62,-2.56,-3.22,-3.88,-3.78,-2.88,-2.91,-1.78,0.09,2.53,4.03,5.16,5.81,6.12,5.25,3.06,1.03,-0.47,-1.38,-2.84,-4.16,-4.75,-4.59,-5.28,-5.53,-4.69,-2.84,-1.44,-0.19,1.5,3.47,5.03,5.41,6.0,7.69,9.22,9.94,10.03,9.97,9.31,7.47,4.78,3.12,2.66,1.91,0.75,0.06,-0.12,-0.84,-2.94,-4.78,-5.69,-6.41,-7.69,-8.41,-8.28,-6.94,-6.62,-6.5,-5.75,-4.84,-4.25,-4.12,-3.72,-2.22,-0.66,0.09,1.16,3.12,4.62,4.84,4.56,4.12,3.62,2.25,0.41,-1.25,-2.0,-3.06,-4.12,-4.25,-3.34,-2.16,-1.84,-2.0,-2.34,-2.66,-3.69,-4.62,-4.66,-3.72,-3.25,-3.09,-3.06,-2.59,-2.56,-3.16,-3.5,-2.94,-1.75,-1.47,-1.56,-1.41,-2.03,-3.56,-6.0,-8.16,-9.75,-11.53,-13.28,-14.59,-14.41,-14.16,-14.34,-14.34,-13.22,-12.25,-11.84,-11.69,-10.94,-10.5,-10.94,-11.59,-12.25,-12.41,-12.59,-13.12,-13.59,-13.03,-12.22,-11.56,-10.81,-9.19,-7.09,-5.62,-4.56,-3.72,-3.59,-4.5,-6.19,-8.22,-9.38,-9.66,-10.47,-10.69,-9.78,-8.69,-7.75,-6.84,-5.47,-3.69,-3.25,-3.16,-2.97,-2.62,-2.78,-3.66,-5.22,-6.19,-7.69,-9.53,-10.75,-9.88,-8.22,-6.34,-4.75,-3.0,-2.0,-2.47,-4.06,-5.66,-6.34,-6.72,-7.59,-7.81,-7.28,-7.19,-7.94,-8.47,-7.78,-7.09,-6.59,-6.84,-6.94,-6.81,-7.38,-7.88,-8.03,-7.53,-7.62,-8.38,-9.62,-10.38,-10.97,-12.19,-12.38,-11.25,-9.62,-8.28,-7.47,-6.75,-5.84,-5.28,-4.97,-3.91,-1.44,0.72,1.34,1.53,1.75,1.78,0.78,-0.25,-0.31,-0.59,-1.03,-2.31,-3.06,-3.19,-3.44,-4.44,-5.34,-5.69,-6.06,-6.88,-7.62,-6.75,-5.59,-4.28,-3.59,-2.53,-1.25,-0.34,-0.38,-0.06,0.81,1.19,0.69,-0.22,-0.84,-1.62,-3.38,-5.34,-6.22,-7.06,-8.06,-9.38,-9.59,-9.09,-8.12,-6.97,-5.19,-2.56,-0.31,0.66,1.25,2.03,2.44,2.12,0.81,0.0,-0.53,-1.94,-3.66,-5.19,-6.34,-7.22,-8.81,-9.84,-9.72,-9.5,-10.22,-10.97,-10.59,-9.78,-8.53,-6.84,-4.62,-1.75,0.19,0.84,1.53,1.75,1.72,0.31,-1.03,-1.41,-1.28,-1.66,-2.53,-2.66,-2.88,-3.69,-4.72,-4.75,-3.62,-2.16,-1.06,0.47,1.91,3.41,3.12,2.28,2.25,2.72,2.53,2.22,2.81,3.56,4.06,3.66,3.28,3.34,2.69,1.09,-0.41,-1.19,-1.66,-2.78,-4.31,-4.84,-4.94,-5.38,-5.97,-5.34,-4.25,-3.09,-2.44,-1.31,0.38,1.69,2.19,2.06,2.25,2.62,1.66,0.78,0.59,0.53,-0.53,-2.53,-4.16,-5.5,-6.31,-6.75,-6.0,-4.31,-2.5,-2.0,-2.28,-2.31,-2.44,-3.19,-4.22,-3.88,-2.91,-2.06,-2.0,-1.94,-1.94,-2.72,-4.66,-6.0,-6.09,-5.41,-4.66,-3.81,-2.44,-0.66,-0.25,-0.62,-0.69,-0.12,-0.16,-0.69,-0.78,-0.06,0.03,-1.16,-2.59,-3.72,-4.72,-6.03,-6.69,-5.78,-3.88,-2.66,-2.03,-1.22,-0.34,-0.22,-0.88,-1.22,-0.88,-0.5,-1.09,-1.69,-1.72,-1.5,-1.59,-1.5,-0.19,1.84,2.53,2.88,2.53,2.44,2.03,0.75,-0.34,-0.44,0.0,-0.78,-1.41,-1.38,-1.66,-2.97,-4.31,-5.34,-5.03,-4.34,-3.84,-2.69,-0.47,1.31,1.72,2.19,3.56,4.91,5.0,4.81,4.78,4.25,2.88,1.47,0.97,2.19,3.53,4.78,6.41,8.88,10.59,11.25,11.34,11.84,12.47,11.22,9.47,7.91,6.62,5.03,3.41,2.78,3.47,4.0,3.66,3.62,4.25,4.94,4.97,4.75,5.16,5.56,4.69,3.22,2.25,1.53,0.66,-0.38,-0.59,0.56,1.56,2.28,2.91,4.09,4.25,3.31,2.03,1.28,1.34,0.72,0.38,0.78,1.72,2.19,2.41,2.91,4.38,5.62,5.78,5.66,6.44,6.5,5.62,4.06,3.41,3.09,2.53,2.16,2.44,3.84,4.66,4.78,5.0,5.91,6.75,6.22,5.12,4.75,4.66,4.53,4.25,4.69,6.28,6.62,6.28,5.84,5.75,5.09,3.25,1.28,0.81,0.38,-0.91,-2.19,-2.19,-1.75,-1.66,-1.22,0.12,1.91,3.44,4.06,4.75,6.25,7.12,6.88,6.59,7.28,8.06,8.0,7.62,8.06,8.25,7.34,5.59,4.28,3.75,3.09,3.12,3.34,4.72,5.47,4.94,3.84,3.81,4.03,3.97,4.19,5.25,6.72,7.22,7.41,7.62,8.78,9.38,9.0,8.44,8.5,7.97,6.59,5.03,4.31,4.38,4.0,3.62,4.22,5.72,6.19,5.66,4.97,4.66,3.66,2.38,1.28,1.59,2.59,3.12,3.69,5.28,7.31,8.56,8.91,9.78,10.62,10.78,9.72,8.5,8.44,7.72,6.03,4.56,4.22,3.62,2.53,1.22,0.88,1.53,1.91,2.22,4.38,6.81,8.97,10.12,11.53,13.22,13.97,13.44,12.53,11.56,10.84,10.0,9.0,8.72,9.0,8.56,7.16,6.16,6.0,6.0,6.09,7.09,9.31,12.06,13.41,14.38,15.19,15.25,14.84,13.69,13.62,14.22,14.66,13.94,13.5,13.75,13.34,12.22,11.12,11.38,11.25,10.38,9.34,9.72,10.31,11.19,11.66,12.62,14.03,15.09,14.97,15.25,15.88,16.38,15.03,12.84,10.88,8.56,5.72,2.72,1.41,1.25,2.0,2.72,4.5,7.5,9.69,10.59,11.25,11.91,12.38,12.19,12.22,13.34,14.44,14.81,14.41,14.12,13.97,13.28,11.84,11.12,10.97,11.03,10.12,9.62,9.81,9.94,9.38,8.44,3.19,2.47,1.81,1.69,2.28,3.81,5.56,7.22,8.62,9.72,10.22,10.38,10.31,10.56,10.66,10.38,9.22,8.19,6.53,4.62,2.59,1.16,0.19,0.0,-0.22,-0.19,0.44,1.59,2.84,4.09,5.44,6.97,7.47,7.16,7.06:-7.25,-6.75,-8.06,-9.56,-10.72,-11.69,-12.81,-13.88,-13.97,-12.84,-12.12,-11.25,-10.31,-8.94,-8.31,-8.69,-9.22,-8.88,-8.47,-8.5,-8.56,-8.09,-7.12,-7.59,-8.38,-8.41,-7.84,-7.47,-6.91,-6.31,-4.62,-3.03,-2.97,-3.16,-3.19,-3.75,-5.94,-8.34,-9.97,-11.28,-12.94,-14.41,-14.72,-13.66,-11.81,-10.09,-7.91,-5.5,-3.72,-3.91,-4.38,-4.78,-4.62,-5.78,-7.06,-7.44,-7.78,-9.0,-10.97,-12.38,-13.44,-14.91,-16.72,-17.81,-18.25,-18.22,-18.94,-19.62,-19.41,-18.84,-18.81,-18.78,-18.84,-18.12,-19.06,-20.56,-22.34,-22.88,-23.06,-23.72,-23.72,-22.75,-22.5,-23.28,-24.47,-24.78,-23.94,-23.66,-23.22,-21.69,-19.12,-17.25,-15.97,-14.88,-13.56,-12.53,-12.56,-12.28,-11.31,-10.5,-10.94,-11.72,-11.91,-11.66,-12.06,-12.97,-14.0,-14.59,-15.56,-17.09,-17.59,-16.69,-15.78,-15.0,-14.25,-12.47,-10.94,-10.69,-11.34,-12.0,-12.09,-13.06,-13.91,-13.72,-12.84,-12.12,-11.69,-11.81,-11.53,-11.59,-12.41,-14.12,-14.84,-15.28,-15.81,-16.09,-15.53,-14.16,-13.5,-13.41,-13.72,-13.53,-13.59,-14.41,-14.81,-14.28,-13.97,-14.28,-14.72,-14.25,-13.22,-12.94,-12.84,-12.66,-11.47,-10.62,-9.94,-8.66,-6.59,-5.09,-5.12,-5.72,-5.88,-6.19,-7.38,-8.97,-9.97,-10.91,-12.47,-14.0,-14.72,-13.97,-13.19,-12.16,-11.44,-10.12,-9.06,-9.34,-10.22,-10.22,-10.25,-11.19,-12.34,-12.84,-12.5,-12.5,-12.72,-12.97,-12.78,-12.47,-12.84,-13.0,-11.53,-10.12,-9.91,-10.28,-10.81,-11.69,-13.75,-16.22,-17.44,-17.25,-16.66,-15.69,-14.0,-11.44,-9.44,-8.94,-9.47,-9.31,-8.84,-9.28,-10.16,-9.69,-8.69,-8.22,-7.91,-6.94,-5.38,-4.34,-4.81,-5.66,-6.09,-7.34,-9.31,-11.22,-12.34,-13.0,-14.16,-15.59,-16.28,-16.53,-16.94,-17.19,-16.62,-15.19,-13.97,-13.72,-13.69,-13.16,-12.94,-13.25,-13.41,-12.59,-11.22,-10.56,-10.69,-10.03,-9.56,-10.0,-11.06,-12.19,-13.16,-14.31,-16.19,-18.22,-18.72,-18.34,-18.34,-17.81,-15.91,-13.41,-11.59,-11.44,-11.69,-12.38,-13.81,-16.31,-18.12,-18.25,-18.03,-18.28,-17.91,-17.0,-16.31,-16.59,-17.41,-17.22,-16.31,-15.16,-14.56,-13.09,-11.53,-11.38,-12.75,-14.72,-16.0,-17.16,-18.28,-18.72,-17.41,-15.03,-13.38,-12.25,-10.66,-9.75,-9.66,-10.69,-11.41,-11.03,-11.09,-11.84,-12.5,-12.31,-12.28,-13.03,-13.75,-13.47,-12.75,-13.19,-14.91,-16.34,-18.16,-19.94,-22.03,-22.94,-22.41,-21.38,-21.03,-20.72,-19.44,-17.72,-16.44,-15.31,-13.31,-10.94,-9.81,-9.59,-9.19,-8.66,-8.28,-8.81,-8.47,-7.31,-6.0,-5.69,-5.25,-4.31,-3.53,-3.88,-5.09,-6.47,-7.59,-9.0,-10.38,-10.53,-9.78,-9.47,-10.47,-11.81,-12.97,-14.25,-15.94,-17.19,-17.16,-16.5,-15.66,-14.72,-13.5,-11.44,-9.5,-8.53,-7.0,-5.44,-4.47,-5.62,-7.19,-8.66,-9.56,-10.91,-11.88,-11.62,-10.47,-10.12,-9.94,-9.75,-9.34,-9.28,-10.97,-12.47,-13.38,-13.75,-15.0,-15.34,-14.12,-12.41,-11.38,-10.44,-8.78,-7.28,-6.38,-6.53,-6.75,-6.84,-7.5,-9.12,-10.53,-11.16,-10.66,-10.84,-10.16,-8.34,-5.72,-4.5,-3.72,-3.12,-2.5,-2.38,-2.97,-3.12,-2.62,-2.56,-3.22,-3.88,-3.78,-2.88,-2.91,-1.78,0.09,2.53,4.03,5.16,5.81,6.12,5.25,3.06,1.03,-0.47,-1.38,-2.84,-4.16,-4.75,-4.59,-5.28,-5.53,-4.69,-2.84,-1.44,-0.19,1.5,3.47,5.03,5.41,6.0,7.69,9.22,9.94,10.03,9.97,9.31,7.47,4.78,3.12,2.66,1.91,0.75,0.06,-0.12,-0.84,-2.94,-4.78,-5.69,-6.41,-7.69,-8.41,-8.28,-6.94,-6.62,-6.5,-5.75,-4.84,-4.25,-4.12,-3.72,-2.22,-0.66,0.09,1.16,3.12,4.62,4.84,4.56,4.12,3.62,2.25,0.41,-1.25,-2.0,-3.06,-4.12,-4.25,-3.34,-2.16,-1.84,-2.0,-2.34,-2.66,-3.69,-4.62,-4.66,-3.72,-3.25,-3.09,-3.06,-2.59,-2.56,-3.16,-3.5,-2.94,-1.75,-1.47,-1.56,-1.41,-2.03,-3.56,-6.0,-8.16,-9.75,-11.53,-13.28,-14.59,-14.41,-14.16,-14.34,-14.34,-13.22,-12.25,-11.84,-11.69,-10.94,-10.5,-10.94,-11.59,-12.25,-12.41,-12.59,-13.12,-13.59,-13.03,-12.22,-11.56,-10.81,-9.19,-7.09,-5.62,-4.56,-3.72,-3.59,-4.5,-6.19,-8.22,-9.38,-9.66,-10.47,-10.69,-9.78,-8.69,-7.75,-6.84,-5.47,-3.69,-3.25,-3.16,-2.97,-2.62,-2.78,-3.66,-5.22,-6.19,-7.69,-9.53,-10.75,-9.88,-8.22,-6.34,-4.75,-3.0,-2.0,-2.47,-4.06,-5.66,-6.34,-6.72,-7.59,-7.81,-7.28,-7.19,-7.94,-8.47,-7.78,-7.09,-6.59,-6.84,-6.94,-6.81,-7.38,-7.88,-8.03,-7.53,-7.62,-8.38,-9.62,-10.38,-10.97,-12.19,-12.38,-11.25,-9.62,-8.28,-7.47,-6.75,-5.84,-5.28,-4.97,-3.91,-1.44,0.72,1.34,1.53,1.75,1.78,0.78,-0.25,-0.31,-0.59,-1.03,-2.31,-3.06,-3.19,-3.44,-4.44,-5.34,-5.69,-6.06,-6.88,-7.62,-6.75,-5.59,-4.28,-3.59,-2.53,-1.25,-0.34,-0.38,-0.06,0.81,1.19,0.69,-0.22,-0.84,-1.62,-3.38,-5.34,-6.22,-7.06,-8.06,-9.38,-9.59,-9.09,-8.12,-6.97,-5.19,-2.56,-0.31,0.66,1.25,2.03,2.44,2.12,0.81,0.0,-0.53,-1.94,-3.66,-5.19,-6.34,-7.22,-8.81,-9.84,-9.72,-9.5,-10.22,-10.97,-10.59,-9.78,-8.53,-6.84,-4.62,-1.75,0.19,0.84,1.53,1.75,1.72,0.31,-1.03,-1.41,-1.28,-1.66,-2.53,-2.66,-2.88,-3.69,-4.72,-4.75,-3.62,-2.16,-1.06,0.47,1.91,3.41,3.12,2.28,2.25,2.72,2.53,2.22,2.81,3.56,4.06,3.66,3.28,3.34,2.69,1.09,-0.41,-1.19,-1.66,-2.78,-4.31,-4.84,-4.94,-5.38,-5.97,-5.34,-4.25,-3.09,-2.44,-1.31,0.38,1.69,2.19,2.06,2.25,2.62,1.66,0.78,0.59,0.53,-0.53,-2.53,-4.16,-5.5,-6.31,-6.75,-6.0,-4.31,-2.5,-2.0,-2.28,-2.31,-2.44,-3.19,-4.22,-3.88,-2.91,-2.06,-2.0,-1.94,-1.94,-2.72,-4.66,-6.0,-6.09,-5.41,-4.66,-3.81,-2.44,-0.66,-0.25,-0.62,-0.69,-0.12,-0.16,-0.69,-0.78,-0.06,0.03,-1.16,-2.59,-3.72,-4.72,-6.03,-6.69,-5.78,-3.88,-2.66,-2.03,-1.22,-0.34,-0.22,-0.88,-1.22,-0.88,-0.5,-1.09,-1.69,-1.72,-1.5,-1.59,-1.5,-0.19,1.84,2.53,2.88,2.53,2.44,2.03,0.75,-0.34,-0.44,0.0,-0.78,-1.41,-1.38,-1.66,-2.97,-4.31,-5.34,-5.03,-4.34,-3.84,-2.69,-0.47,1.31,1.72,2.19,3.56,4.91,5.0,4.81,4.78,4.25,2.88,1.47,0.97,2.19,3.53,4.78,6.41,8.88,10.59,11.25,11.34,11.84,12.47,11.22,9.47,7.91,6.62,5.03,3.41,2.78,3.47,4.0,3.66,3.62,4.25,4.94,4.97,4.75,5.16,5.56,4.69,3.22,2.25,1.53,0.66,-0.38,-0.59,0.56,1.56,2.28,2.91,4.09,4.25,3.31,2.03,1.28,1.34,0.72,0.38,0.78,1.72,2.19,2.41,2.91,4.38,5.62,5.78,5.66,6.44,6.5,5.62,4.06,3.41,3.09,2.53,2.16,2.44,3.84,4.66,4.78,5.0,5.91,6.75,6.22,5.12,4.75,4.66,4.53,4.25,4.69,6.28,6.62,6.28,5.84,5.75,5.09,3.25,1.28,0.81,0.38,-0.91,-2.19,-2.19,-1.75,-1.66,-1.22,0.12,1.91,3.44,4.06,4.75,6.25,7.12,6.88,6.59,7.28,8.06,8.0,7.62,8.06,8.25,7.34,5.59,4.28,3.75,3.09,3.12,3.34,4.72,5.47,4.94,3.84,3.81,4.03,3.97,4.19,5.25,6.72,7.22,7.41,7.62,8.78,9.38,9.0,8.44,8.5,7.97,6.59,5.03,4.31,4.38,4.0,3.62,4.22,5.72,6.19,5.66,4.97,4.66,3.66,2.38,1.28,1.59,2.59,3.12,3.69,5.28,7.31,8.56,8.91,9.78,10.62,10.78,9.72,8.5,8.44,7.72,6.03,4.56,4.22,3.62,2.53,1.22,0.88,1.53,1.91,2.22,4.38,6.81,8.97,10.12,11.53,13.22,13.97,13.44,12.53,11.56,10.84,10.0,9.0,8.72,9.0,8.56,7.16,6.16,6.0,6.0,6.09,7.09,9.31,12.06,13.41,14.38,15.19,15.25,14.84,13.69,13.62,14.22,14.66,13.94,13.5,13.75,13.34,12.22,11.12,11.38,11.25,10.38,9.34,9.72,10.31,11.19,11.66,12.62,14.03,15.09,14.97,15.25,15.88,16.38,15.03,12.84,10.88,8.56,5.72,2.72,1.41,1.25,2.0,2.72,4.5,7.5,9.69,10.59,11.25,11.91,12.38,12.19,12.22,13.34,14.44,14.81,14.41,14.12,13.97,13.28,11.84,11.12,10.97,11.03,10.12,9.62,9.81,9.94,9.38,8.44,3.19,2.47,1.81,1.69,2.28,3.81,5.56,7.22,8.62,9.72,10.22,10.38,10.31,10.56,10.66,10.38,9.22,8.19,6.53,4.62,2.59,1.16,0.19,0.0,-0.22,-0.19,0.44,1.59,2.84,4.09,5.44,6.97,7.47,7.16,7.06,6.91,6.41,5.72,5.59,5.59,5.44,5.66:negativity
24.81,23.25,21.53,19.25,18.97,20.84,23.22,24.19,24.56,26.25,27.06,26.41,24.97,25.28,26.31,26.34,24.91,23.91,23.25,21.94,19.38,17.97,18.91,20.78,21.69,22.38,23.78,24.56,24.06,22.94,23.56,26.03,27.94,28.91,30.28,31.62,32.31,31.5,31.09,31.62,32.25,31.19,28.66,27.03,26.16,24.62,23.34,24.25,26.75,28.72,29.5,30.59,31.84,32.16,30.22,28.34,27.5,27.28,26.56,25.44,26.06,27.5,27.38,26.38,26.25,26.66,26.44,24.59,23.56,24.16,24.47,23.97,23.94,25.59,27.16,26.75,25.69,25.38,25.34,24.38,22.75,22.31,23.34,23.75,23.0,22.25,21.91,20.91,17.97,15.53,14.84,15.59,15.97,15.91,17.5,19.19,19.34,17.97,17.25,17.38,16.81,15.19,14.44,15.12,16.56,17.06,17.88,20.03,22.47,22.34,20.44,18.62,16.44,12.84,8.0,4.72,3.16,1.81,-0.03,-0.5,1.19,4.19,6.44,9.16,13.84,18.75,21.28,21.88,22.16,21.41,18.66,14.12,10.56,8.34,5.88,3.06,1.22,1.56,3.31,4.44,6.38,9.69,13.03,14.34,14.28,14.69,15.59,16.0,15.53,16.19,17.91,19.19,18.75,18.66,19.34,19.91,19.31,18.12,18.12,18.5,17.5,16.22,15.97,16.5,16.41,14.69,13.84,14.19,14.06,12.56,11.25,11.28,11.56,10.19,9.12,9.78,11.84,12.66,12.5,13.44,14.47,14.78,13.72,13.81,15.78,17.47,17.47,17.53,18.28,18.72,17.31,15.94,15.81,16.41,15.88,14.78,14.53,15.19,15.75,15.31,15.75,17.69,19.53,20.03,20.34,21.41,22.75,22.12,20.5,20.19,21.19,21.62,21.69,23.0,24.94,26.59,26.0,25.28,25.56,25.69,24.19,22.69,22.66,23.5,23.22,22.84,23.44,24.91,25.03,23.72,23.25,23.69,23.72,22.66,22.59,23.91,25.19,25.25,25.53,26.97,28.75,29.38,28.94,29.12,30.28,30.28,29.03,28.25,28.12,27.16,24.66,23.0,22.94,23.75,23.31,23.0,23.97,25.09,24.81,24.0,24.12,25.28,25.66,25.38,25.62,27.12,28.59,28.56,28.5,29.88,30.44,28.59,25.91,23.97,22.75,20.81,18.91,18.78,19.91,20.25,19.62,19.41,20.53,21.53,21.03,21.03,22.53,24.53,24.94,24.94,25.91,26.94,26.69,25.97,25.88,26.53,26.09,24.19,22.19,21.34,20.75,18.81,17.25,17.5,18.12,17.84,17.41,18.28,19.78,20.12,20.06,20.69,22.16,22.72,22.0,21.19,21.91,22.72,22.5,23.09,25.12,28.09,29.75,30.5,31.91,33.16,32.47,30.59,29.41,29.81,29.75,29.56,29.88,31.75,33.47,33.72,33.91,35.09,36.75,36.69,35.66,35.69,36.22,35.22,33.34,32.41,33.06,32.94,31.97,30.62,30.16,28.91,25.28,21.5,19.53,18.91,17.31,15.97,16.72,18.31,18.91,18.38,18.0,18.62,18.44,17.12,16.56,18.28,20.75,22.06,23.69,27.0,30.34,31.91,32.09,32.78,33.94,34.34,33.88,34.22,36.0,36.62,35.09,32.88,31.75,30.53,27.81,24.84,23.34,22.53,20.53,18.28,16.88,16.84,16.25,14.12,13.12,13.91,15.0,15.34,16.5,19.72,22.47,23.22,23.72,25.09,27.06,28.03,28.09,29.16,31.22,32.44,32.5,32.69,33.44,33.44,31.78,29.53,29.34,29.03,27.16,24.88,23.94,24.0,23.34,22.34,23.22,24.88,26.19,26.47,28.16,30.94,33.47,34.25,34.5,35.72,36.25,34.56,31.97,30.06,28.47,25.22,21.59,19.5,18.53,17.53,16.12,15.84,17.38,18.81,18.47,17.38,18.03,18.88,18.12,17.88,19.09,20.72,21.28,20.38,20.38,21.5,22.06,21.25,21.19,22.5,23.47,23.12,22.44,23.88,25.97,26.97,27.38,28.44,29.62,28.91,26.47,24.06,23.47,22.75,21.03,20.31,21.41,22.62,22.41,21.5,22.06,22.91,22.16,20.66,19.91,20.12,19.62,18.41,18.06,19.59,21.0,21.56,21.91,24.0,26.0,26.28,25.47,26.19,27.22,26.41,25.69,26.41,28.44,29.88,30.28,30.75,31.28,31.44,29.72,28.25,29.03,30.25,30.06,29.03,29.19,30.06,29.47,29.0,29.75,31.81,32.53,32.22,31.72,32.34,32.34,30.78,28.69,28.28,27.78,26.03,24.25,23.97,24.88,24.81,24.78,26.03,28.94,30.88,31.12,30.91,31.28,30.62,28.0,25.12,24.22,24.03,22.81,21.31,21.53,23.06,23.56,23.31,24.19,26.19,26.94,26.53,26.09,27.44,28.12,26.81,24.94,24.44,24.09,22.53,20.78,20.19,20.91,20.22,18.38,16.97,16.69,15.72,13.66,11.69,11.66,12.09,11.56,11.5,13.22,15.31,15.75,15.47,16.25,17.69,18.44,18.25,19.34,21.16,22.28,22.5,22.38,24.19,26.25,27.09,27.88,29.97,31.88,32.09,31.12,31.19,32.12,31.97,30.5,29.94,30.59,30.16,28.22,26.19,25.94,25.75,24.78,24.22,25.66,27.94,29.06,28.97,29.75,31.12,31.47,30.41,30.12,30.97,31.12,29.91,28.47,28.31,28.06,26.47,24.28,23.53,23.16,21.97,20.16,19.56,20.5,20.25,18.66,17.56,18.44,19.19,19.28,19.56,21.88,23.88,24.44,25.06,27.28,30.03,31.59,32.0,32.84,33.81,32.88,30.22,27.25,25.84,24.88,23.44,22.72,24.12,25.12,24.91,23.28,23.03,23.25,22.47,20.81,20.38,20.88,20.56,19.03,17.91,18.34,18.31,17.06,15.88,16.62,17.25,16.84,16.03,16.38,17.38,17.09,15.69,14.91,15.12,14.44,12.47,10.69,10.47,10.34,9.38,8.25,9.34,11.31,12.41,12.97,15.34,18.5,20.5,21.16,22.5,25.0,26.56,26.28,25.88,26.31,26.41,24.78,23.16,22.94,23.22,22.72,21.69,22.19,23.5,24.25,23.69,23.38,24.41,24.69,23.34,22.06,22.09,22.0,20.41,18.38,18.03,18.5,18.69,18.66,20.12,22.88,24.72,25.19,25.69,26.84,27.16,25.19,23.38,22.69,22.34,20.88,19.16,19.03,18.78,17.25,14.91,13.62,13.91,13.91,13.47,14.25,17.06,19.22,19.75,19.97,20.81,21.16,20.16,18.66,19.25,20.62,21.59,22.03,23.06,24.88,25.72,24.91,24.44,25.5,26.56,25.91,24.91,25.03,25.03,24.0,23.09,24.03,26.0,27.72,27.62,28.38,29.97,30.09,28.62,27.66,28.31,29.0,28.06,26.88,27.12,27.09,26.12,24.53,24.81,25.59,25.62,24.66,24.28,25.03,25.69,25.0,24.75,25.66,26.22,25.16,23.66,23.62,23.69,23.0,22.12,22.47,23.75,24.72,24.72,25.25,26.66,27.53,27.12,26.62,27.47,27.59,25.88,22.94,21.38,20.09,18.34,16.41,15.66,15.94,15.53,14.09,13.19,13.5,13.66,12.91,12.16,13.31,14.97,15.5,15.84,17.75,19.59,20.38,20.0,19.78,20.25,20.03,18.62,17.72,18.38,18.66,16.97,14.69,13.94,13.06,11.88,11.16,12.97,15.94,18.41,19.06,19.97,21.53,22.0,20.69,20.09,20.75,21.09,19.53,18.5,19.56,21.16,21.72,22.09,23.34,24.84,24.16,22.19,20.47,19.5,18.06,15.09,13.34,13.38,13.56,12.5,11.56,12.28,13.94,14.34,14.41,15.91,18.72,20.84,22.25,24.53,27.34,29.19,28.5,27.0,25.53,23.22,19.06,15.0,12.72,12.03,11.22,10.62,12.03,14.19,15.53,15.78,16.47,18.56,20.25,20.88,22.06,24.66,27.12,27.94,28.38,29.72,31.22,31.44,30.72,30.88,31.59,31.41,29.31,27.53,27.06,25.81,22.69,20.06,18.97,18.5,17.0,15.91,16.38,17.38,17.09,16.16,15.97,16.97,17.25,16.66,16.84,18.72,20.56,21.09,21.81,23.59,24.97,24.53,22.78,22.44,22.34,21.0,18.94,17.62,17.53,16.88,15.5,14.62,15.44,16.66,16.53,17.12,19.38,22.66,23.66,23.69,24.12,24.69,24.0,22.12,21.19,21.16,20.69,18.91,17.5,17.88,18.41,17.38,16.5,17.25,18.66,18.88,18.72,19.5,20.84,21.0,20.47,20.91,22.09,22.78,21.66,20.41,20.34,20.56,19.47,18.22,17.88,18.09,16.62,14.59,13.56,13.59,13.19,12.41,12.78,15.41,18.38,20.22,22.34,25.91,29.19,30.38,30.78,31.56,32.0,30.47,27.41,25.38,24.25,22.59,20.38,19.22,19.69,19.88,19.0,18.19,18.91,19.97,19.41,19.03,19.47,20.34,19.91,18.75,18.34,18.78,18.38,16.72,15.81,16.28,17.56,17.56,17.94,19.72,21.47,21.78,21.56,22.59,25.12,26.5,27.12,28.12,29.53,29.72,27.66,25.56,24.28,23.06,21.06,19.62,19.91,21.5,21.59,21.0,21.03,21.62,20.69,19.31,19.0,20.16,21.59,21.66,22.62,24.81,27.16,28.12,28.62,30.5,32.47,32.94,32.75,33.25,34.03,33.75,32.28,30.91,30.53,29.56,27.19,25.47,25.47,25.59,24.81,23.53,23.28,23.72,22.84,21.0,20.38,21.0,20.97,20.66,21.31,23.72,25.25,25.12,25.38,26.34,27.12,26.31,25.25,24.88,24.78,23.5,21.88,21.12,22.06,22.28,21.66,21.91,23.5,25.16,25.53,25.84,27.31,28.59,28.44,27.47,27.59,28.16,27.5,26.0,25.22,25.81,25.53,23.97,23.12,23.94:24.19,24.56,26.25,27.06,26.41,24.97,25.28,26.31,26.34,24.91,23.91,23.25,21.94,19.38,17.97,18.91,20.78,21.69,22.38,23.78,24.56,24.06,22.94,23.56,26.03,27.94,28.91,30.28,31.62,32.31,31.5,31.09,31.62,32.25,31.19,28.66,27.03,26.16,24.62,23.34,24.25,26.75,28.72,29.5,30.59,31.84,32.16,30.22,28.34,27.5,27.28,26.56,25.44,26.06,27.5,27.38,26.38,26.25,26.66,26.44,24.59,23.56,24.16,24.47,23.97,23.94,25.59,27.16,26.75,25.69,25.38,25.34,24.38,22.75,22.31,23.34,23.75,23.0,22.25,21.91,20.91,17.97,15.53,14.84,15.59,15.97,15.91,17.5,19.19,19.34,17.97,17.25,17.38,16.81,15.19,14.44,15.12,16.56,17.06,17.88,20.03,22.47,22.34,20.44,18.62,16.44,12.84,8.0,4.72,3.16,1.81,-0.03,-0.5,1.19,4.19,6.44,9.16,13.84,18.75,21.28,21.88,22.16,21.41,18.66,14.12,10.56,8.34,5.88,3.06,1.22,1.56,3.31,4.44,6.38,9.69,13.03,14.34,14.28,14.69,15.59,16.0,15.53,16.19,17.91,19.19,18.75,18.66,19.34,19.91,19.31,18.12,18.12,18.5,17.5,16.22,15.97,16.5,16.41,14.69,13.84,14.19,14.06,12.56,11.25,11.28,11.56,10.19,9.12,9.78,11.84,12.66,12.5,13.44,14.47,14.78,13.72,13.81,15.78,17.47,17.47,17.53,18.28,18.72,17.31,15.94,15.81,16.41,15.88,14.78,14.53,15.19,15.75,15.31,15.75,17.69,19.53,20.03,20.34,21.41,22.75,22.12,20.5,20.19,21.19,21.62,21.69,23.0,24.94,26.59,26.0,25.28,25.56,25.69,24.19,22.69,22.66,23.5,23.22,22.84,23.44,24.91,25.03,23.72,23.25,23.69,23.72,22.66,22.59,23.91,25.19,25.25,25.53,26.97,28.75,29.38,28.94,29.12,30.28,30.28,29.03,28.25,28.12,27.16,24.66,23.0,22.94,23.75,23.31,23.0,23.97,25.09,24.81,24.0,24.12,25.28,25.66,25.38,25.62,27.12,28.59,28.56,28.5,29.88,30.44,28.59,25.91,23.97,22.75,20.81,18.91,18.78,19.91,20.25,19.62,19.41,20.53,21.53,21.03,21.03,22.53,24.53,24.94,24.94,25.91,26.94,26.69,25.97,25.88,26.53,26.09,24.19,22.19,21.34,20.75,18.81,17.25,17.5,18.12,17.84,17.41,18.28,19.78,20.12,20.06,20.69,22.16,22.72,22.0,21.19,21.91,22.72,22.5,23.09,25.12,28.09,29.75,30.5,31.91,33.16,32.47,30.59,29.41,29.81,29.75,29.56,29.88,31.75,33.47,33.72,33.91,35.09,36.75,36.69,35.66,35.69,36.22,35.22,33.34,32.41,33.06,32.94,31.97,30.62,30.16,28.91,25.28,21.5,19.53,18.91,17.31,15.97,16.72,18.31,18.91,18.38,18.0,18.62,18.44,17.12,16.56,18.28,20.75,22.06,23.69,27.0,30.34,31.91,32.09,32.78,33.94,34.34,33.88,34.22,36.0,36.62,35.09,32.88,31.75,30.53,27.81,24.84,23.34,22.53,20.53,18.28,16.88,16.84,16.25,14.12,13.12,13.91,15.0,15.34,16.5,19.72,22.47,23.22,23.72,25.09,27.06,28.03,28.09,29.16,31.22,32.44,32.5,32.69,33.44,33.44,31.78,29.53,29.34,29.03,27.16,24.88,23.94,24.0,23.34,22.34,23.22,24.88,26.19,26.47,28.16,30.94,33.47,34.25,34.5,35.72,36.25,34.56,31.97,30.06,28.47,25.22,21.59,19.5,18.53,17.53,16.12,15.84,17.38,18.81,18.47,17.38,18.03,18.88,18.12,17.88,19.09,20.72,21.28,20.38,20.38,21.5,22.06,21.25,21.19,22.5,23.47,23.12,22.44,23.88,25.97,26.97,27.38,28.44,29.62,28.91,26.47,24.06,23.47,22.75,21.03,20.31,21.41,22.62,22.41,21.5,22.06,22.91,22.16,20.66,19.91,20.12,19.62,18.41,18.06,19.59,21.0,21.56,21.91,24.0,26.0,26.28,25.47,26.19,27.22,26.41,25.69,26.41,28.44,29.88,30.28,30.75,31.28,31.44,29.72,28.25,29.03,30.25,30.06,29.03,29.19,30.06,29.47,29.0,29.75,31.81,32.53,32.22,31.72,32.34,32.34,30.78,28.69,28.28,27.78,26.03,24.25,23.97,24.88,24.81,24.78,26.03,28.94,30.88,31.12,30.91,31.28,30.62,28.0,25.12,24.22,24.03,22.81,21.31,21.53,23.06,23.56,23.31,24.19,26.19,26.94,26.53,26.09,27.44,28.12,26.81,24.94,24.44,24.09,22.53,20.78,20.19,20.91,20.22,18.38,16.97,16.69,15.72,13.66,11.69,11.66,12.09,11.56,11.5,13.22,15.31,15.75,15.47,16.25,17.69,18.44,18.25,19.34,21.16,22.28,22.5,22.38,24.19,26.25,27.09,27.88,29.97,31.88,32.09,31.12,31.19,32.12,31.97,30.5,29.94,30.59,30.16,28.22,26.19,25.94,25.75,24.78,24.22,25.66,27.94,29.06,28.97,29.75,31.12,31.47,30.41,30.12,30.97,31.12,29.91,28.47,28.31,28.06,26.47,24.28,23.53,23.16,21.97,20.16,19.56,20.5,20.25,18.66,17.56,18.44,19.19,19.28,19.56,21.88,23.88,24.44,25.06,27.28,30.03,31.59,32.0,32.84,33.81,32.88,30.22,27.25,25.84,24.88,23.44,22.72,24.12,25.12,24.91,23.28,23.03,23.25,22.47,20.81,20.38,20.88,20.56,19.03,17.91,18.34,18.31,17.06,15.88,16.62,17.25,16.84,16.03,16.38,17.38,17.09,15.69,14.91,15.12,14.44,12.47,10.69,10.47,10.34,9.38,8.25,9.34,11.31,12.41,12.97,15.34,18.5,20.5,21.16,22.5,25.0,26.56,26.28,25.88,26.31,26.41,24.78,23.16,22.94,23.22,22.72,21.69,22.19,23.5,24.25,23.69,23.38,24.41,24.69,23.34,22.06,22.09,22.0,20.41,18.38,18.03,18.5,18.69,18.66,20.12,22.88,24.72,25.19,25.69,26.84,27.16,25.19,23.38,22.69,22.34,20.88,19.16,19.03,18.78,17.25,14.91,13.62,13.91,13.91,13.47,14.25,17.06,19.22,19.75,19.97,20.81,21.16,20.16,18.66,19.25,20.62,21.59,22.03,23.06,24.88,25.72,24.91,24.44,25.5,26.56,25.91,24.91,25.03,25.03,24.0,23.09,24.03,26.0,27.72,27.62,28.38,29.97,30.09,28.62,27.66,28.31,29.0,28.06,26.88,27.12,27.09,26.12,24.53,24.81,25.59,25.62,24.66,24.28,25.03,25.69,25.0,24.75,25.66,26.22,25.16,23.66,23.62,23.69,23.0,22.12,22.47,23.75,24.72,24.72,25.25,26.66,27.53,27.12,26.62,27.47,27.59,25.88,22.94,21.38,20.09,18.34,16.41,15.66,15.94,15.53,14.09,13.19,13.5,13.66,12.91,12.16,13.31,14.97,15.5,15.84,17.75,19.59,20.38,20.0,19.78,20.25,20.03,18.62,17.72,18.38,18.66,16.97,14.69,13.94,13.06,11.88,11.16,12.97,15.94,18.41,19.06,19.97,21.53,22.0,20.69,20.09,20.75,21.09,19.53,18.5,19.56,21.16,21.72,22.09,23.34,24.84,24.16,22.19,20.47,19.5,18.06,15.09,13.34,13.38,13.56,12.5,11.56,12.28,13.94,14.34,14.41,15.91,18.72,20.84,22.25,24.53,27.34,29.19,28.5,27.0,25.53,23.22,19.06,15.0,12.72,12.03,11.22,10.62,12.03,14.19,15.53,15.78,16.47,18.56,20.25,20.88,22.06,24.66,27.12,27.94,28.38,29.72,31.22,31.44,30.72,30.88,31.59,31.41,29.31,27.53,27.06,25.81,22.69,20.06,18.97,18.5,17.0,15.91,16.38,17.38,17.09,16.16,15.97,16.97,17.25,16.66,16.84,18.72,20.56,21.09,21.81,23.59,24.97,24.53,22.78,22.44,22.34,21.0,18.94,17.62,17.53,16.88,15.5,14.62,15.44,16.66,16.53,17.12,19.38,22.66,23.66,23.69,24.12,24.69,24.0,22.12,21.19,21.16,20.69,18.91,17.5,17.88,18.41,17.38,16.5,17.25,18.66,18.88,18.72,19.5,20.84,21.0,20.47,20.91,22.09,22.78,21.66,20.41,20.34,20.56,19.47,18.22,17.88,18.09,16.62,14.59,13.56,13.59,13.19,12.41,12.78,15.41,18.38,20.22,22.34,25.91,29.19,30.38,30.78,31.56,32.0,30.47,27.41,25.38,24.25,22.59,20.38,19.22,19.69,19.88,19.0,18.19,18.91,19.97,19.41,19.03,19.47,20.34,19.91,18.75,18.34,18.78,18.38,16.72,15.81,16.28,17.56,17.56,17.94,19.72,21.47,21.78,21.56,22.59,25.12,26.5,27.12,28.12,29.53,29.72,27.66,25.56,24.28,23.06,21.06,19.62,19.91,21.5,21.59,21.0,21.03,21.62,20.69,19.31,19.0,20.16,21.59,21.66,22.62,24.81,27.16,28.12,28.62,30.5,32.47,32.94,32.75,33.25,34.03,33.75,32.28,30.91,30.53,29.56,27.19,25.47,25.47,25.59,24.81,23.53,23.28,23.72,22.84,21.0,20.38,21.0,20.97,20.66,21.31,23.72,25.25,25.12,25.38,26.34,27.12,26.31,25.25,24.88,24.78,23.5,21.88,21.12,22.06,22.28,21.66,21.91,23.5,25.16,25.53,25.84,27.31,28.59,28.44,27.47,27.59,28.16,27.5,26.0,25.22,25.81,25.53,23.97,23.12,23.94,42.66,41.03,39.94,40.12,40.69,41.56,43.0:26.31,26.34,24.91,23.91,23.25,21.94,19.38,17.97,18.91,20.78,21.69,22.38,23.78,24.56,24.06,22.94,23.56,26.03,27.94,28.91,30.28,31.62,32.31,31.5,31.09,31.62,32.25,31.19,28.66,27.03,26.16,24.62,23.34,24.25,26.75,28.72,29.5,30.59,31.84,32.16,30.22,28.34,27.5,27.28,26.56,25.44,26.06,27.5,27.38,26.38,26.25,26.66,26.44,24.59,23.56,24.16,24.47,23.97,23.94,25.59,27.16,26.75,25.69,25.38,25.34,24.38,22.75,22.31,23.34,23.75,23.0,22.25,21.91,20.91,17.97,15.53,14.84,15.59,15.97,15.91,17.5,19.19,19.34,17.97,17.25,17.38,16.81,15.19,14.44,15.12,16.56,17.06,17.88,20.03,22.47,22.34,20.44,18.62,16.44,12.84,8.0,4.72,3.16,1.81,-0.03,-0.5,1.19,4.19,6.44,9.16,13.84,18.75,21.28,21.88,22.16,21.41,18.66,14.12,10.56,8.34,5.88,3.06,1.22,1.56,3.31,4.44,6.38,9.69,13.03,14.34,14.28,14.69,15.59,16.0,15.53,16.19,17.91,19.19,18.75,18.66,19.34,19.91,19.31,18.12,18.12,18.5,17.5,16.22,15.97,16.5,16.41,14.69,13.84,14.19,14.06,12.56,11.25,11.28,11.56,10.19,9.12,9.78,11.84,12.66,12.5,13.44,14.47,14.78,13.72,13.81,15.78,17.47,17.47,17.53,18.28,18.72,17.31,15.94,15.81,16.41,15.88,14.78,14.53,15.19,15.75,15.31,15.75,17.69,19.53,20.03,20.34,21.41,22.75,22.12,20.5,20.19,21.19,21.62,21.69,23.0,24.94,26.59,26.0,25.28,25.56,25.69,24.19,22.69,22.66,23.5,23.22,22.84,23.44,24.91,25.03,23.72,23.25,23.69,23.72,22.66,22.59,23.91,25.19,25.25,25.53,26.97,28.75,29.38,28.94,29.12,30.28,30.28,29.03,28.25,28.12,27.16,24.66,23.0,22.94,23.75,23.31,23.0,23.97,25.09,24.81,24.0,24.12,25.28,25.66,25.38,25.62,27.12,28.59,28.56,28.5,29.88,30.44,28.59,25.91,23.97,22.75,20.81,18.91,18.78,19.91,20.25,19.62,19.41,20.53,21.53,21.03,21.03,22.53,24.53,24.94,24.94,25.91,26.94,26.69,25.97,25.88,26.53,26.09,24.19,22.19,21.34,20.75,18.81,17.25,17.5,18.12,17.84,17.41,18.28,19.78,20.12,20.06,20.69,22.16,22.72,22.0,21.19,21.91,22.72,22.5,23.09,25.12,28.09,29.75,30.5,31.91,33.16,32.47,30.59,29.41,29.81,29.75,29.56,29.88,31.75,33.47,33.72,33.91,35.09,36.75,36.69,35.66,35.69,36.22,35.22,33.34,32.41,33.06,32.94,31.97,30.62,30.16,28.91,25.28,21.5,19.53,18.91,17.31,15.97,16.72,18.31,18.91,18.38,18.0,18.62,18.44,17.12,16.56,18.28,20.75,22.06,23.69,27.0,30.34,31.91,32.09,32.78,33.94,34.34,33.88,34.22,36.0,36.62,35.09,32.88,31.75,30.53,27.81,24.84,23.34,22.53,20.53,18.28,16.88,16.84,16.25,14.12,13.12,13.91,15.0,15.34,16.5,19.72,22.47,23.22,23.72,25.09,27.06,28.03,28.09,29.16,31.22,32.44,32.5,32.69,33.44,33.44,31.78,29.53,29.34,29.03,27.16,24.88,23.94,24.0,23.34,22.34,23.22,24.88,26.19,26.47,28.16,30.94,33.47,34.25,34.5,35.72,36.25,34.56,31.97,30.06,28.47,25.22,21.59,19.5,18.53,17.53,16.12,15.84,17.38,18.81,18.47,17.38,18.03,18.88,18.12,17.88,19.09,20.72,21.28,20.38,20.38,21.5,22.06,21.25,21.19,22.5,23.47,23.12,22.44,23.88,25.97,26.97,27.38,28.44,29.62,28.91,26.47,24.06,23.47,22.75,21.03,20.31,21.41,22.62,22.41,21.5,22.06,22.91,22.16,20.66,19.91,20.12,19.62,18.41,18.06,19.59,21.0,21.56,21.91,24.0,26.0,26.28,25.47,26.19,27.22,26.41,25.69,26.41,28.44,29.88,30.28,30.75,31.28,31.44,29.72,28.25,29.03,30.25,30.06,29.03,29.19,30.06,29.47,29.0,29.75,31.81,32.53,32.22,31.72,32.34,32.34,30.78,28.69,28.28,27.78,26.03,24.25,23.97,24.88,24.81,24.78,26.03,28.94,30.88,31.12,30.91,31.28,30.62,28.0,25.12,24.22,24.03,22.81,21.31,21.53,23.06,23.56,23.31,24.19,26.19,26.94,26.53,26.09,27.44,28.12,26.81,24.94,24.44,24.09,22.53,20.78,20.19,20.91,20.22,18.38,16.97,16.69,15.72,13.66,11.69,11.66,12.09,11.56,11.5,13.22,15.31,15.75,15.47,16.25,17.69,18.44,18.25,19.34,21.16,22.28,22.5,22.38,24.19,26.25,27.09,27.88,29.97,31.88,32.09,31.12,31.19,32.12,31.97,30.5,29.94,30.59,30.16,28.22,26.19,25.94,25.75,24.78,24.22,25.66,27.94,29.06,28.97,29.75,31.12,31.47,30.41,30.12,30.97,31.12,29.91,28.47,28.31,28.06,26.47,24.28,23.53,23.16,21.97,20.16,19.56,20.5,20.25,18.66,17.56,18.44,19.19,19.28,19.56,21.88,23.88,24.44,25.06,27.28,30.03,31.59,32.0,32.84,33.81,32.88,30.22,27.25,25.84,24.88,23.44,22.72,24.12,25.12,24.91,23.28,23.03,23.25,22.47,20.81,20.38,20.88,20.56,19.03,17.91,18.34,18.31,17.06,15.88,16.62,17.25,16.84,16.03,16.38,17.38,17.09,15.69,14.91,15.12,14.44,12.47,10.69,10.47,10.34,9.38,8.25,9.34,11.31,12.41,12.97,15.34,18.5,20.5,21.16,22.5,25.0,26.56,26.28,25.88,26.31,26.41,24.78,23.16,22.94,23.22,22.72,21.69,22.19,23.5,24.25,23.69,23.38,24.41,24.69,23.34,22.06,22.09,22.0,20.41,18.38,18.03,18.5,18.69,18.66,20.12,22.88,24.72,25.19,25.69,26.84,27.16,25.19,23.38,22.69,22.34,20.88,19.16,19.03,18.78,17.25,14.91,13.62,13.91,13.91,13.47,14.25,17.06,19.22,19.75,19.97,20.81,21.16,20.16,18.66,19.25,20.62,21.59,22.03,23.06,24.88,25.72,24.91,24.44,25.5,26.56,25.91,24.91,25.03,25.03,24.0,23.09,24.03,26.0,27.72,27.62,28.38,29.97,30.09,28.62,27.66,28.31,29.0,28.06,26.88,27.12,27.09,26.12,24.53,24.81,25.59,25.62,24.66,24.28,25.03,25.69,25.0,24.75,25.66,26.22,25.16,23.66,23.62,23.69,23.0,22.12,22.47,23.75,24.72,24.72,25.25,26.66,27.53,27.12,26.62,27.47,27.59,25.88,22.94,21.38,20.09,18.34,16.41,15.66,15.94,15.53,14.09,13.19,13.5,13.66,12.91,12.16,13.31,14.97,15.5,15.84,17.75,19.59,20.38,20.0,19.78,20.25,20.03,18.62,17.72,18.38,18.66,16.97,14.69,13.94,13.06,11.88,11.16,12.97,15.94,18.41,19.06,19.97,21.53,22.0,20.69,20.09,20.75,21.09,19.53,18.5,19.56,21.16,21.72,22.09,23.34,24.84,24.16,22.19,20.47,19.5,18.06,15.09,13.34,13.38,13.56,12.5,11.56,12.28,13.94,14.34,14.41,15.91,18.72,20.84,22.25,24.53,27.34,29.19,28.5,27.0,25.53,23.22,19.06,15.0,12.72,12.03,11.22,10.62,12.03,14.19,15.53,15.78,16.47,18.56,20.25,20.88,22.06,24.66,27.12,27.94,28.38,29.72,31.22,31.44,30.72,30.88,31.59,31.41,29.31,27.53,27.06,25.81,22.69,20.06,18.97,18.5,17.0,15.91,16.38,17.38,17.09,16.16,15.97,16.97,17.25,16.66,16.84,18.72,20.56,21.09,21.81,23.59,24.97,24.53,22.78,22.44,22.34,21.0,18.94,17.62,17.53,16.88,15.5,14.62,15.44,16.66,16.53,17.12,19.38,22.66,23.66,23.69,24.12,24.69,24.0,22.12,21.19,21.16,20.69,18.91,17.5,17.88,18.41,17.38,16.5,17.25,18.66,18.88,18.72,19.5,20.84,21.0,20.47,20.91,22.09,22.78,21.66,20.41,20.34,20.56,19.47,18.22,17.88,18.09,16.62,14.59,13.56,13.59,13.19,12.41,12.78,15.41,18.38,20.22,22.34,25.91,29.19,30.38,30.78,31.56,32.0,30.47,27.41,25.38,24.25,22.59,20.38,19.22,19.69,19.88,19.0,18.19,18.91,19.97,19.41,19.03,19.47,20.34,19.91,18.75,18.34,18.78,18.38,16.72,15.81,16.28,17.56,17.56,17.94,19.72,21.47,21.78,21.56,22.59,25.12,26.5,27.12,28.12,29.53,29.72,27.66,25.56,24.28,23.06,21.06,19.62,19.91,21.5,21.59,21.0,21.03,21.62,20.69,19.31,19.0,20.16,21.59,21.66,22.62,24.81,27.16,28.12,28.62,30.5,32.47,32.94,32.75,33.25,34.03,33.75,32.28,30.91,30.53,29.56,27.19,25.47,25.47,25.59,24.81,23.53,23.28,23.72,22.84,21.0,20.38,21.0,20.97,20.66,21.31,23.72,25.25,25.12,25.38,26.34,27.12,26.31,25.25,24.88,24.78,23.5,21.88,21.12,22.06,22.28,21.66,21.91,23.5,25.16,25.53,25.84,27.31,28.59,28.44,27.47,27.59,28.16,27.5,26.0,25.22,25.81,25.53,23.97,23.12,23.94,42.66,41.03,39.94,40.12,40.69,41.56,43.0,45.0,46.03,46.06,45.5,45.31,44.62,44.19:17.97,18.91,20.78,21.69,22.38,23.78,24.56,24.06,22.94,23.56,26.03,27.94,28.91,30.28,31.62,32.31,31.5,31.09,31.62,32.25,31.19,28.66,27.03,26.16,24.62,23.34,24.25,26.75,28.72,29.5,30.59,31.84,32.16,30.22,28.34,27.5,27.28,26.56,25.44,26.06,27.5,27.38,26.38,26.25,26.66,26.44,24.59,23.56,24.16,24.47,23.97,23.94,25.59,27.16,26.75,25.69,25.38,25.34,24.38,22.75,22.31,23.34,23.75,23.0,22.25,21.91,20.91,17.97,15.53,14.84,15.59,15.97,15.91,17.5,19.19,19.34,17.97,17.25,17.38,16.81,15.19,14.44,15.12,16.56,17.06,17.88,20.03,22.47,22.34,20.44,18.62,16.44,12.84,8.0,4.72,3.16,1.81,-0.03,-0.5,1.19,4.19,6.44,9.16,13.84,18.75,21.28,21.88,22.16,21.41,18.66,14.12,10.56,8.34,5.88,3.06,1.22,1.56,3.31,4.44,6.38,9.69,13.03,14.34,14.28,14.69,15.59,16.0,15.53,16.19,17.91,19.19,18.75,18.66,19.34,19.91,19.31,18.12,18.12,18.5,17.5,16.22,15.97,16.5,16.41,14.69,13.84,14.19,14.06,12.56,11.25,11.28,11.56,10.19,9.12,9.78,11.84,12.66,12.5,13.44,14.47,14.78,13.72,13.81,15.78,17.47,17.47,17.53,18.28,18.72,17.31,15.94,15.81,16.41,15.88,14.78,14.53,15.19,15.75,15.31,15.75,17.69,19.53,20.03,20.34,21.41,22.75,22.12,20.5,20.19,21.19,21.62,21.69,23.0,24.94,26.59,26.0,25.28,25.56,25.69,24.19,22.69,22.66,23.5,23.22,22.84,23.44,24.91,25.03,23.72,23.25,23.69,23.72,22.66,22.59,23.91,25.19,25.25,25.53,26.97,28.75,29.38,28.94,29.12,30.28,30.28,29.03,28.25,28.12,27.16,24.66,23.0,22.94,23.75,23.31,23.0,23.97,25.09,24.81,24.0,24.12,25.28,25.66,25.38,25.62,27.12,28.59,28.56,28.5,29.88,30.44,28.59,25.91,23.97,22.75,20.81,18.91,18.78,19.91,20.25,19.62,19.41,20.53,21.53,21.03,21.03,22.53,24.53,24.94,24.94,25.91,26.94,26.69,25.97,25.88,26.53,26.09,24.19,22.19,21.34,20.75,18.81,17.25,17.5,18.12,17.84,17.41,18.28,19.78,20.12,20.06,20.69,22.16,22.72,22.0,21.19,21.91,22.72,22.5,23.09,25.12,28.09,29.75,30.5,31.91,33.16,32.47,30.59,29.41,29.81,29.75,29.56,29.88,31.75,33.47,33.72,33.91,35.09,36.75,36.69,35.66,35.69,36.22,35.22,33.34,32.41,33.06,32.94,31.97,30.62,30.16,28.91,25.28,21.5,19.53,18.91,17.31,15.97,16.72,18.31,18.91,18.38,18.0,18.62,18.44,17.12,16.56,18.28,20.75,22.06,23.69,27.0,30.34,31.91,32.09,32.78,33.94,34.34,33.88,34.22,36.0,36.62,35.09,32.88,31.75,30.53,27.81,24.84,23.34,22.53,20.53,18.28,16.88,16.84,16.25,14.12,13.12,13.91,15.0,15.34,16.5,19.72,22.47,23.22,23.72,25.09,27.06,28.03,28.09,29.16,31.22,32.44,32.5,32.69,33.44,33.44,31.78,29.53,29.34,29.03,27.16,24.88,23.94,24.0,23.34,22.34,23.22,24.88,26.19,26.47,28.16,30.94,33.47,34.25,34.5,35.72,36.25,34.56,31.97,30.06,28.47,25.22,21.59,19.5,18.53,17.53,16.12,15.84,17.38,18.81,18.47,17.38,18.03,18.88,18.12,17.88,19.09,20.72,21.28,20.38,20.38,21.5,22.06,21.25,21.19,22.5,23.47,23.12,22.44,23.88,25.97,26.97,27.38,28.44,29.62,28.91,26.47,24.06,23.47,22.75,21.03,20.31,21.41,22.62,22.41,21.5,22.06,22.91,22.16,20.66,19.91,20.12,19.62,18.41,18.06,19.59,21.0,21.56,21.91,24.0,26.0,26.28,25.47,26.19,27.22,26.41,25.69,26.41,28.44,29.88,30.28,30.75,31.28,31.44,29.72,28.25,29.03,30.25,30.06,29.03,29.19,30.06,29.47,29.0,29.75,31.81,32.53,32.22,31.72,32.34,32.34,30.78,28.69,28.28,27.78,26.03,24.25,23.97,24.88,24.81,24.78,26.03,28.94,30.88,31.12,30.91,31.28,30.62,28.0,25.12,24.22,24.03,22.81,21.31,21.53,23.06,23.56,23.31,24.19,26.19,26.94,26.53,26.09,27.44,28.12,26.81,24.94,24.44,24.09,22.53,20.78,20.19,20.91,20.22,18.38,16.97,16.69,15.72,13.66,11.69,11.66,12.09,11.56,11.5,13.22,15.31,15.75,15.47,16.25,17.69,18.44,18.25,19.34,21.16,22.28,22.5,22.38,24.19,26.25,27.09,27.88,29.97,31.88,32.09,31.12,31.19,32.12,31.97,30.5,29.94,30.59,30.16,28.22,26.19,25.94,25.75,24.78,24.22,25.66,27.94,29.06,28.97,29.75,31.12,31.47,30.41,30.12,30.97,31.12,29.91,28.47,28.31,28.06,26.47,24.28,23.53,23.16,21.97,20.16,19.56,20.5,20.25,18.66,17.56,18.44,19.19,19.28,19.56,21.88,23.88,24.44,25.06,27.28,30.03,31.59,32.0,32.84,33.81,32.88,30.22,27.25,25.84,24.88,23.44,22.72,24.12,25.12,24.91,23.28,23.03,23.25,22.47,20.81,20.38,20.88,20.56,19.03,17.91,18.34,18.31,17.06,15.88,16.62,17.25,16.84,16.03,16.38,17.38,17.09,15.69,14.91,15.12,14.44,12.47,10.69,10.47,10.34,9.38,8.25,9.34,11.31,12.41,12.97,15.34,18.5,20.5,21.16,22.5,25.0,26.56,26.28,25.88,26.31,26.41,24.78,23.16,22.94,23.22,22.72,21.69,22.19,23.5,24.25,23.69,23.38,24.41,24.69,23.34,22.06,22.09,22.0,20.41,18.38,18.03,18.5,18.69,18.66,20.12,22.88,24.72,25.19,25.69,26.84,27.16,25.19,23.38,22.69,22.34,20.88,19.16,19.03,18.78,17.25,14.91,13.62,13.91,13.91,13.47,14.25,17.06,19.22,19.75,19.97,20.81,21.16,20.16,18.66,19.25,20.62,21.59,22.03,23.06,24.88,25.72,24.91,24.44,25.5,26.56,25.91,24.91,25.03,25.03,24.0,23.09,24.03,26.0,27.72,27.62,28.38,29.97,30.09,28.62,27.66,28.31,29.0,28.06,26.88,27.12,27.09,26.12,24.53,24.81,25.59,25.62,24.66,24.28,25.03,25.69,25.0,24.75,25.66,26.22,25.16,23.66,23.62,23.69,23.0,22.12,22.47,23.75,24.72,24.72,25.25,26.66,27.53,27.12,26.62,27.47,27.59,25.88,22.94,21.38,20.09,18.34,16.41,15.66,15.94,15.53,14.09,13.19,13.5,13.66,12.91,12.16,13.31,14.97,15.5,15.84,17.75,19.59,20.38,20.0,19.78,20.25,20.03,18.62,17.72,18.38,18.66,16.97,14.69,13.94,13.06,11.88,11.16,12.97,15.94,18.41,19.06,19.97,21.53,22.0,20.69,20.09,20.75,21.09,19.53,18.5,19.56,21.16,21.72,22.09,23.34,24.84,24.16,22.19,20.47,19.5,18.06,15.09,13.34,13.38,13.56,12.5,11.56,12.28,13.94,14.34,14.41,15.91,18.72,20.84,22.25,24.53,27.34,29.19,28.5,27.0,25.53,23.22,19.06,15.0,12.72,12.03,11.22,10.62,12.03,14.19,15.53,15.78,16.47,18.56,20.25,20.88,22.06,24.66,27.12,27.94,28.38,29.72,31.22,31.44,30.72,30.88,31.59,31.41,29.31,27.53,27.06,25.81,22.69,20.06,18.97,18.5,17.0,15.91,16.38,17.38,17.09,16.16,15.97,16.97,17.25,16.66,16.84,18.72,20.56,21.09,21.81,23.59,24.97,24.53,22.78,22.44,22.34,21.0,18.94,17.62,17.53,16.88,15.5,14.62,15.44,16.66,16.53,17.12,19.38,22.66,23.66,23.69,24.12,24.69,24.0,22.12,21.19,21.16,20.69,18.91,17.5,17.88,18.41,17.38,16.5,17.25,18.66,18.88,18.72,19.5,20.84,21.0,20.47,20.91,22.09,22.78,21.66,20.41,20.34,20.56,19.47,18.22,17.88,18.09,16.62,14.59,13.56,13.59,13.19,12.41,12.78,15.41,18.38,20.22,22.34,25.91,29.19,30.38,30.78,31.56,32.0,30.47,27.41,25.38,24.25,22.59,20.38,19.22,19.69,19.88,19.0,18.19,18.91,19.97,19.41,19.03,19.47,20.34,19.91,18.75,18.34,18.78,18.38,16.72,15.81,16.28,17.56,17.56,17.94,19.72,21.47,21.78,21.56,22.59,25.12,26.5,27.12,28.12,29.53,29.72,27.66,25.56,24.28,23.06,21.06,19.62,19.91,21.5,21.59,21.0,21.03,21.62,20.69,19.31,19.0,20.16,21.59,21.66,22.62,24.81,27.16,28.12,28.62,30.5,32.47,32.94,32.75,33.25,34.03,33.75,32.28,30.91,30.53,29.56,27.19,25.47,25.47,25.59,24.81,23.53,23.28,23.72,22.84,21.0,20.38,21.0,20.97,20.66,21.31,23.72,25.25,25.12,25.38,26.34,27.12,26.31,25.25,24.88,24.78,23.5,21.88,21.12,22.06,22.28,21.66,21.91,23.5,25.16,25.53,25.84,27.31,28.59,28.44,27.47,27.59,28.16,27.5,26.0,25.22,25.81,25.53,23.97,23.12,23.94,42.66,41.03,39.94,40.12,40.69,41.56,43.0,45.0,46.03,46.06,45.5,45.31,44.62,44.19,44.25,44.62,44.62,44.06,42.28,40.22,38.94:24.06,22.94,23.56,26.03,27.94,28.91,30.28,31.62,32.31,31.5,31.09,31.62,32.25,31.19,28.66,27.03,26.16,24.62,23.34,24.25,26.75,28.72,29.5,30.59,31.84,32.16,30.22,28.34,27.5,27.28,26.56,25.44,26.06,27.5,27.38,26.38,26.25,26.66,26.44,24.59,23.56,24.16,24.47,23.97,23.94,25.59,27.16,26.75,25.69,25.38,25.34,24.38,22.75,22.31,23.34,23.75,23.0,22.25,21.91,20.91,17.97,15.53,14.84,15.59,15.97,15.91,17.5,19.19,19.34,17.97,17.25,17.38,16.81,15.19,14.44,15.12,16.56,17.06,17.88,20.03,22.47,22.34,20.44,18.62,16.44,12.84,8.0,4.72,3.16,1.81,-0.03,-0.5,1.19,4.19,6.44,9.16,13.84,18.75,21.28,21.88,22.16,21.41,18.66,14.12,10.56,8.34,5.88,3.06,1.22,1.56,3.31,4.44,6.38,9.69,13.03,14.34,14.28,14.69,15.59,16.0,15.53,16.19,17.91,19.19,18.75,18.66,19.34,19.91,19.31,18.12,18.12,18.5,17.5,16.22,15.97,16.5,16.41,14.69,13.84,14.19,14.06,12.56,11.25,11.28,11.56,10.19,9.12,9.78,11.84,12.66,12.5,13.44,14.47,14.78,13.72,13.81,15.78,17.47,17.47,17.53,18.28,18.72,17.31,15.94,15.81,16.41,15.88,14.78,14.53,15.19,15.75,15.31,15.75,17.69,19.53,20.03,20.34,21.41,22.75,22.12,20.5,20.19,21.19,21.62,21.69,23.0,24.94,26.59,26.0,25.28,25.56,25.69,24.19,22.69,22.66,23.5,23.22,22.84,23.44,24.91,25.03,23.72,23.25,23.69,23.72,22.66,22.59,23.91,25.19,25.25,25.53,26.97,28.75,29.38,28.94,29.12,30.28,30.28,29.03,28.25,28.12,27.16,24.66,23.0,22.94,23.75,23.31,23.0,23.97,25.09,24.81,24.0,24.12,25.28,25.66,25.38,25.62,27.12,28.59,28.56,28.5,29.88,30.44,28.59,25.91,23.97,22.75,20.81,18.91,18.78,19.91,20.25,19.62,19.41,20.53,21.53,21.03,21.03,22.53,24.53,24.94,24.94,25.91,26.94,26.69,25.97,25.88,26.53,26.09,24.19,22.19,21.34,20.75,18.81,17.25,17.5,18.12,17.84,17.41,18.28,19.78,20.12,20.06,20.69,22.16,22.72,22.0,21.19,21.91,22.72,22.5,23.09,25.12,28.09,29.75,30.5,31.91,33.16,32.47,30.59,29.41,29.81,29.75,29.56,29.88,31.75,33.47,33.72,33.91,35.09,36.75,36.69,35.66,35.69,36.22,35.22,33.34,32.41,33.06,32.94,31.97,30.62,30.16,28.91,25.28,21.5,19.53,18.91,17.31,15.97,16.72,18.31,18.91,18.38,18.0,18.62,18.44,17.12,16.56,18.28,20.75,22.06,23.69,27.0,30.34,31.91,32.09,32.78,33.94,34.34,33.88,34.22,36.0,36.62,35.09,32.88,31.75,30.53,27.81,24.84,23.34,22.53,20.53,18.28,16.88,16.84,16.25,14.12,13.12,13.91,15.0,15.34,16.5,19.72,22.47,23.22,23.72,25.09,27.06,28.03,28.09,29.16,31.22,32.44,32.5,32.69,33.44,33.44,31.78,29.53,29.34,29.03,27.16,24.88,23.94,24.0,23.34,22.34,23.22,24.88,26.19,26.47,28.16,30.94,33.47,34.25,34.5,35.72,36.25,34.56,31.97,30.06,28.47,25.22,21.59,19.5,18.53,17.53,16.12,15.84,17.38,18.81,18.47,17.38,18.03,18.88,18.12,17.88,19.09,20.72,21.28,20.38,20.38,21.5,22.06,21.25,21.19,22.5,23.47,23.12,22.44,23.88,25.97,26.97,27.38,28.44,29.62,28.91,26.47,24.06,23.47,22.75,21.03,20.31,21.41,22.62,22.41,21.5,22.06,22.91,22.16,20.66,19.91,20.12,19.62,18.41,18.06,19.59,21.0,21.56,21.91,24.0,26.0,26.28,25.47,26.19,27.22,26.41,25.69,26.41,28.44,29.88,30.28,30.75,31.28,31.44,29.72,28.25,29.03,30.25,30.06,29.03,29.19,30.06,29.47,29.0,29.75,31.81,32.53,32.22,31.72,32.34,32.34,30.78,28.69,28.28,27.78,26.03,24.25,23.97,24.88,24.81,24.78,26.03,28.94,30.88,31.12,30.91,31.28,30.62,28.0,25.12,24.22,24.03,22.81,21.31,21.53,23.06,23.56,23.31,24.19,26.19,26.94,26.53,26.09,27.44,28.12,26.81,24.94,24.44,24.09,22.53,20.78,20.19,20.91,20.22,18.38,16.97,16.69,15.72,13.66,11.69,11.66,12.09,11.56,11.5,13.22,15.31,15.75,15.47,16.25,17.69,18.44,18.25,19.34,21.16,22.28,22.5,22.38,24.19,26.25,27.09,27.88,29.97,31.88,32.09,31.12,31.19,32.12,31.97,30.5,29.94,30.59,30.16,28.22,26.19,25.94,25.75,24.78,24.22,25.66,27.94,29.06,28.97,29.75,31.12,31.47,30.41,30.12,30.97,31.12,29.91,28.47,28.31,28.06,26.47,24.28,23.53,23.16,21.97,20.16,19.56,20.5,20.25,18.66,17.56,18.44,19.19,19.28,19.56,21.88,23.88,24.44,25.06,27.28,30.03,31.59,32.0,32.84,33.81,32.88,30.22,27.25,25.84,24.88,23.44,22.72,24.12,25.12,24.91,23.28,23.03,23.25,22.47,20.81,20.38,20.88,20.56,19.03,17.91,18.34,18.31,17.06,15.88,16.62,17.25,16.84,16.03,16.38,17.38,17.09,15.69,14.91,15.12,14.44,12.47,10.69,10.47,10.34,9.38,8.25,9.34,11.31,12.41,12.97,15.34,18.5,20.5,21.16,22.5,25.0,26.56,26.28,25.88,26.31,26.41,24.78,23.16,22.94,23.22,22.72,21.69,22.19,23.5,24.25,23.69,23.38,24.41,24.69,23.34,22.06,22.09,22.0,20.41,18.38,18.03,18.5,18.69,18.66,20.12,22.88,24.72,25.19,25.69,26.84,27.16,25.19,23.38,22.69,22.34,20.88,19.16,19.03,18.78,17.25,14.91,13.62,13.91,13.91,13.47,14.25,17.06,19.22,19.75,19.97,20.81,21.16,20.16,18.66,19.25,20.62,21.59,22.03,23.06,24.88,25.72,24.91,24.44,25.5,26.56,25.91,24.91,25.03,25.03,24.0,23.09,24.03,26.0,27.72,27.62,28.38,29.97,30.09,28.62,27.66,28.31,29.0,28.06,26.88,27.12,27.09,26.12,24.53,24.81,25.59,25.62,24.66,24.28,25.03,25.69,25.0,24.75,25.66,26.22,25.16,23.66,23.62,23.69,23.0,22.12,22.47,23.75,24.72,24.72,25.25,26.66,27.53,27.12,26.62,27.47,27.59,25.88,22.94,21.38,20.09,18.34,16.41,15.66,15.94,15.53,14.09,13.19,13.5,13.66,12.91,12.16,13.31,14.97,15.5,15.84,17.75,19.59,20.38,20.0,19.78,20.25,20.03,18.62,17.72,18.38,18.66,16.97,14.69,13.94,13.06,11.88,11.16,12.97,15.94,18.41,19.06,19.97,21.53,22.0,20.69,20.09,20.75,21.09,19.53,18.5,19.56,21.16,21.72,22.09,23.34,24.84,24.16,22.19,20.47,19.5,18.06,15.09,13.34,13.38,13.56,12.5,11.56,12.28,13.94,14.34,14.41,15.91,18.72,20.84,22.25,24.53,27.34,29.19,28.5,27.0,25.53,23.22,19.06,15.0,12.72,12.03,11.22,10.62,12.03,14.19,15.53,15.78,16.47,18.56,20.25,20.88,22.06,24.66,27.12,27.94,28.38,29.72,31.22,31.44,30.72,30.88,31.59,31.41,29.31,27.53,27.06,25.81,22.69,20.06,18.97,18.5,17.0,15.91,16.38,17.38,17.09,16.16,15.97,16.97,17.25,16.66,16.84,18.72,20.56,21.09,21.81,23.59,24.97,24.53,22.78,22.44,22.34,21.0,18.94,17.62,17.53,16.88,15.5,14.62,15.44,16.66,16.53,17.12,19.38,22.66,23.66,23.69,24.12,24.69,24.0,22.12,21.19,21.16,20.69,18.91,17.5,17.88,18.41,17.38,16.5,17.25,18.66,18.88,18.72,19.5,20.84,21.0,20.47,20.91,22.09,22.78,21.66,20.41,20.34,20.56,19.47,18.22,17.88,18.09,16.62,14.59,13.56,13.59,13.19,12.41,12.78,15.41,18.38,20.22,22.34,25.91,29.19,30.38,30.78,31.56,32.0,30.47,27.41,25.38,24.25,22.59,20.38,19.22,19.69,19.88,19.0,18.19,18.91,19.97,19.41,19.03,19.47,20.34,19.91,18.75,18.34,18.78,18.38,16.72,15.81,16.28,17.56,17.56,17.94,19.72,21.47,21.78,21.56,22.59,25.12,26.5,27.12,28.12,29.53,29.72,27.66,25.56,24.28,23.06,21.06,19.62,19.91,21.5,21.59,21.0,21.03,21.62,20.69,19.31,19.0,20.16,21.59,21.66,22.62,24.81,27.16,28.12,28.62,30.5,32.47,32.94,32.75,33.25,34.03,33.75,32.28,30.91,30.53,29.56,27.19,25.47,25.47,25.59,24.81,23.53,23.28,23.72,22.84,21.0,20.38,21.0,20.97,20.66,21.31,23.72,25.25,25.12,25.38,26.34,27.12,26.31,25.25,24.88,24.78,23.5,21.88,21.12,22.06,22.28,21.66,21.91,23.5,25.16,25.53,25.84,27.31,28.59,28.44,27.47,27.59,28.16,27.5,26.0,25.22,25.81,25.53,23.97,23.12,23.94,42.66,41.03,39.94,40.12,40.69,41.56,43.0,45.0,46.03,46.06,45.5,45.31,44.62,44.19,44.25,44.62,44.62,44.06,42.28,40.22,38.94,38.06,37.91,38.94,41.06,43.22,43.97,44.0:31.62,32.31,31.5,31.09,31.62,32.25,31.19,28.66,27.03,26.16,24.62,23.34,24.25,26.75,28.72,29.5,30.59,31.84,32.16,30.22,28.34,27.5,27.28,26.56,25.44,26.06,27.5,27.38,26.38,26.25,26.66,26.44,24.59,23.56,24.16,24.47,23.97,23.94,25.59,27.16,26.75,25.69,25.38,25.34,24.38,22.75,22.31,23.34,23.75,23.0,22.25,21.91,20.91,17.97,15.53,14.84,15.59,15.97,15.91,17.5,19.19,19.34,17.97,17.25,17.38,16.81,15.19,14.44,15.12,16.56,17.06,17.88,20.03,22.47,22.34,20.44,18.62,16.44,12.84,8.0,4.72,3.16,1.81,-0.03,-0.5,1.19,4.19,6.44,9.16,13.84,18.75,21.28,21.88,22.16,21.41,18.66,14.12,10.56,8.34,5.88,3.06,1.22,1.56,3.31,4.44,6.38,9.69,13.03,14.34,14.28,14.69,15.59,16.0,15.53,16.19,17.91,19.19,18.75,18.66,19.34,19.91,19.31,18.12,18.12,18.5,17.5,16.22,15.97,16.5,16.41,14.69,13.84,14.19,14.06,12.56,11.25,11.28,11.56,10.19,9.12,9.78,11.84,12.66,12.5,13.44,14.47,14.78,13.72,13.81,15.78,17.47,17.47,17.53,18.28,18.72,17.31,15.94,15.81,16.41,15.88,14.78,14.53,15.19,15.75,15.31,15.75,17.69,19.53,20.03,20.34,21.41,22.75,22.12,20.5,20.19,21.19,21.62,21.69,23.0,24.94,26.59,26.0,25.28,25.56,25.69,24.19,22.69,22.66,23.5,23.22,22.84,23.44,24.91,25.03,23.72,23.25,23.69,23.72,22.66,22.59,23.91,25.19,25.25,25.53,26.97,28.75,29.38,28.94,29.12,30.28,30.28,29.03,28.25,28.12,27.16,24.66,23.0,22.94,23.75,23.31,23.0,23.97,25.09,24.81,24.0,24.12,25.28,25.66,25.38,25.62,27.12,28.59,28.56,28.5,29.88,30.44,28.59,25.91,23.97,22.75,20.81,18.91,18.78,19.91,20.25,19.62,19.41,20.53,21.53,21.03,21.03,22.53,24.53,24.94,24.94,25.91,26.94,26.69,25.97,25.88,26.53,26.09,24.19,22.19,21.34,20.75,18.81,17.25,17.5,18.12,17.84,17.41,18.28,19.78,20.12,20.06,20.69,22.16,22.72,22.0,21.19,21.91,22.72,22.5,23.09,25.12,28.09,29.75,30.5,31.91,33.16,32.47,30.59,29.41,29.81,29.75,29.56,29.88,31.75,33.47,33.72,33.91,35.09,36.75,36.69,35.66,35.69,36.22,35.22,33.34,32.41,33.06,32.94,31.97,30.62,30.16,28.91,25.28,21.5,19.53,18.91,17.31,15.97,16.72,18.31,18.91,18.38,18.0,18.62,18.44,17.12,16.56,18.28,20.75,22.06,23.69,27.0,30.34,31.91,32.09,32.78,33.94,34.34,33.88,34.22,36.0,36.62,35.09,32.88,31.75,30.53,27.81,24.84,23.34,22.53,20.53,18.28,16.88,16.84,16.25,14.12,13.12,13.91,15.0,15.34,16.5,19.72,22.47,23.22,23.72,25.09,27.06,28.03,28.09,29.16,31.22,32.44,32.5,32.69,33.44,33.44,31.78,29.53,29.34,29.03,27.16,24.88,23.94,24.0,23.34,22.34,23.22,24.88,26.19,26.47,28.16,30.94,33.47,34.25,34.5,35.72,36.25,34.56,31.97,30.06,28.47,25.22,21.59,19.5,18.53,17.53,16.12,15.84,17.38,18.81,18.47,17.38,18.03,18.88,18.12,17.88,19.09,20.72,21.28,20.38,20.38,21.5,22.06,21.25,21.19,22.5,23.47,23.12,22.44,23.88,25.97,26.97,27.38,28.44,29.62,28.91,26.47,24.06,23.47,22.75,21.03,20.31,21.41,22.62,22.41,21.5,22.06,22.91,22.16,20.66,19.91,20.12,19.62,18.41,18.06,19.59,21.0,21.56,21.91,24.0,26.0,26.28,25.47,26.19,27.22,26.41,25.69,26.41,28.44,29.88,30.28,30.75,31.28,31.44,29.72,28.25,29.03,30.25,30.06,29.03,29.19,30.06,29.47,29.0,29.75,31.81,32.53,32.22,31.72,32.34,32.34,30.78,28.69,28.28,27.78,26.03,24.25,23.97,24.88,24.81,24.78,26.03,28.94,30.88,31.12,30.91,31.28,30.62,28.0,25.12,24.22,24.03,22.81,21.31,21.53,23.06,23.56,23.31,24.19,26.19,26.94,26.53,26.09,27.44,28.12,26.81,24.94,24.44,24.09,22.53,20.78,20.19,20.91,20.22,18.38,16.97,16.69,15.72,13.66,11.69,11.66,12.09,11.56,11.5,13.22,15.31,15.75,15.47,16.25,17.69,18.44,18.25,19.34,21.16,22.28,22.5,22.38,24.19,26.25,27.09,27.88,29.97,31.88,32.09,31.12,31.19,32.12,31.97,30.5,29.94,30.59,30.16,28.22,26.19,25.94,25.75,24.78,24.22,25.66,27.94,29.06,28.97,29.75,31.12,31.47,30.41,30.12,30.97,31.12,29.91,28.47,28.31,28.06,26.47,24.28,23.53,23.16,21.97,20.16,19.56,20.5,20.25,18.66,17.56,18.44,19.19,19.28,19.56,21.88,23.88,24.44,25.06,27.28,30.03,31.59,32.0,32.84,33.81,32.88,30.22,27.25,25.84,24.88,23.44,22.72,24.12,25.12,24.91,23.28,23.03,23.25,22.47,20.81,20.38,20.88,20.56,19.03,17.91,18.34,18.31,17.06,15.88,16.62,17.25,16.84,16.03,16.38,17.38,17.09,15.69,14.91,15.12,14.44,12.47,10.69,10.47,10.34,9.38,8.25,9.34,11.31,12.41,12.97,15.34,18.5,20.5,21.16,22.5,25.0,26.56,26.28,25.88,26.31,26.41,24.78,23.16,22.94,23.22,22.72,21.69,22.19,23.5,24.25,23.69,23.38,24.41,24.69,23.34,22.06,22.09,22.0,20.41,18.38,18.03,18.5,18.69,18.66,20.12,22.88,24.72,25.19,25.69,26.84,27.16,25.19,23.38,22.69,22.34,20.88,19.16,19.03,18.78,17.25,14.91,13.62,13.91,13.91,13.47,14.25,17.06,19.22,19.75,19.97,20.81,21.16,20.16,18.66,19.25,20.62,21.59,22.03,23.06,24.88,25.72,24.91,24.44,25.5,26.56,25.91,24.91,25.03,25.03,24.0,23.09,24.03,26.0,27.72,27.62,28.38,29.97,30.09,28.62,27.66,28.31,29.0,28.06,26.88,27.12,27.09,26.12,24.53,24.81,25.59,25.62,24.66,24.28,25.03,25.69,25.0,24.75,25.66,26.22,25.16,23.66,23.62,23.69,23.0,22.12,22.47,23.75,24.72,24.72,25.25,26.66,27.53,27.12,26.62,27.47,27.59,25.88,22.94,21.38,20.09,18.34,16.41,15.66,15.94,15.53,14.09,13.19,13.5,13.66,12.91,12.16,13.31,14.97,15.5,15.84,17.75,19.59,20.38,20.0,19.78,20.25,20.03,18.62,17.72,18.38,18.66,16.97,14.69,13.94,13.06,11.88,11.16,12.97,15.94,18.41,19.06,19.97,21.53,22.0,20.69,20.09,20.75,21.09,19.53,18.5,19.56,21.16,21.72,22.09,23.34,24.84,24.16,22.19,20.47,19.5,18.06,15.09,13.34,13.38,13.56,12.5,11.56,12.28,13.94,14.34,14.41,15.91,18.72,20.84,22.25,24.53,27.34,29.19,28.5,27.0,25.53,23.22,19.06,15.0,12.72,12.03,11.22,10.62,12.03,14.19,15.53,15.78,16.47,18.56,20.25,20.88,22.06,24.66,27.12,27.94,28.38,29.72,31.22,31.44,30.72,30.88,31.59,31.41,29.31,27.53,27.06,25.81,22.69,20.06,18.97,18.5,17.0,15.91,16.38,17.38,17.09,16.16,15.97,16.97,17.25,16.66,16.84,18.72,20.56,21.09,21.81,23.59,24.97,24.53,22.78,22.44,22.34,21.0,18.94,17.62,17.53,16.88,15.5,14.62,15.44,16.66,16.53,17.12,19.38,22.66,23.66,23.69,24.12,24.69,24.0,22.12,21.19,21.16,20.69,18.91,17.5,17.88,18.41,17.38,16.5,17.25,18.66,18.88,18.72,19.5,20.84,21.0,20.47,20.91,22.09,22.78,21.66,20.41,20.34,20.56,19.47,18.22,17.88,18.09,16.62,14.59,13.56,13.59,13.19,12.41,12.78,15.41,18.38,20.22,22.34,25.91,29.19,30.38,30.78,31.56,32.0,30.47,27.41,25.38,24.25,22.59,20.38,19.22,19.69,19.88,19.0,18.19,18.91,19.97,19.41,19.03,19.47,20.34,19.91,18.75,18.34,18.78,18.38,16.72,15.81,16.28,17.56,17.56,17.94,19.72,21.47,21.78,21.56,22.59,25.12,26.5,27.12,28.12,29.53,29.72,27.66,25.56,24.28,23.06,21.06,19.62,19.91,21.5,21.59,21.0,21.03,21.62,20.69,19.31,19.0,20.16,21.59,21.66,22.62,24.81,27.16,28.12,28.62,30.5,32.47,32.94,32.75,33.25,34.03,33.75,32.28,30.91,30.53,29.56,27.19,25.47,25.47,25.59,24.81,23.53,23.28,23.72,22.84,21.0,20.38,21.0,20.97,20.66,21.31,23.72,25.25,25.12,25.38,26.34,27.12,26.31,25.25,24.88,24.78,23.5,21.88,21.12,22.06,22.28,21.66,21.91,23.5,25.16,25.53,25.84,27.31,28.59,28.44,27.47,27.59,28.16,27.5,26.0,25.22,25.81,25.53,23.97,23.12,23.94,42.66,41.03,39.94,40.12,40.69,41.56,43.0,45.0,46.03,46.06,45.5,45.31,44.62,44.19,44.25,44.62,44.62,44.06,42.28,40.22,38.94,38.06,37.91,38.94,41.06,43.22,43.97,44.0,44.5,44.56,44.38,45.12,46.34,48.44,49.78:28.66,27.03,26.16,24.62,23.34,24.25,26.75,28.72,29.5,30.59,31.84,32.16,30.22,28.34,27.5,27.28,26.56,25.44,26.06,27.5,27.38,26.38,26.25,26.66,26.44,24.59,23.56,24.16,24.47,23.97,23.94,25.59,27.16,26.75,25.69,25.38,25.34,24.38,22.75,22.31,23.34,23.75,23.0,22.25,21.91,20.91,17.97,15.53,14.84,15.59,15.97,15.91,17.5,19.19,19.34,17.97,17.25,17.38,16.81,15.19,14.44,15.12,16.56,17.06,17.88,20.03,22.47,22.34,20.44,18.62,16.44,12.84,8.0,4.72,3.16,1.81,-0.03,-0.5,1.19,4.19,6.44,9.16,13.84,18.75,21.28,21.88,22.16,21.41,18.66,14.12,10.56,8.34,5.88,3.06,1.22,1.56,3.31,4.44,6.38,9.69,13.03,14.34,14.28,14.69,15.59,16.0,15.53,16.19,17.91,19.19,18.75,18.66,19.34,19.91,19.31,18.12,18.12,18.5,17.5,16.22,15.97,16.5,16.41,14.69,13.84,14.19,14.06,12.56,11.25,11.28,11.56,10.19,9.12,9.78,11.84,12.66,12.5,13.44,14.47,14.78,13.72,13.81,15.78,17.47,17.47,17.53,18.28,18.72,17.31,15.94,15.81,16.41,15.88,14.78,14.53,15.19,15.75,15.31,15.75,17.69,19.53,20.03,20.34,21.41,22.75,22.12,20.5,20.19,21.19,21.62,21.69,23.0,24.94,26.59,26.0,25.28,25.56,25.69,24.19,22.69,22.66,23.5,23.22,22.84,23.44,24.91,25.03,23.72,23.25,23.69,23.72,22.66,22.59,23.91,25.19,25.25,25.53,26.97,28.75,29.38,28.94,29.12,30.28,30.28,29.03,28.25,28.12,27.16,24.66,23.0,22.94,23.75,23.31,23.0,23.97,25.09,24.81,24.0,24.12,25.28,25.66,25.38,25.62,27.12,28.59,28.56,28.5,29.88,30.44,28.59,25.91,23.97,22.75,20.81,18.91,18.78,19.91,20.25,19.62,19.41,20.53,21.53,21.03,21.03,22.53,24.53,24.94,24.94,25.91,26.94,26.69,25.97,25.88,26.53,26.09,24.19,22.19,21.34,20.75,18.81,17.25,17.5,18.12,17.84,17.41,18.28,19.78,20.12,20.06,20.69,22.16,22.72,22.0,21.19,21.91,22.72,22.5,23.09,25.12,28.09,29.75,30.5,31.91,33.16,32.47,30.59,29.41,29.81,29.75,29.56,29.88,31.75,33.47,33.72,33.91,35.09,36.75,36.69,35.66,35.69,36.22,35.22,33.34,32.41,33.06,32.94,31.97,30.62,30.16,28.91,25.28,21.5,19.53,18.91,17.31,15.97,16.72,18.31,18.91,18.38,18.0,18.62,18.44,17.12,16.56,18.28,20.75,22.06,23.69,27.0,30.34,31.91,32.09,32.78,33.94,34.34,33.88,34.22,36.0,36.62,35.09,32.88,31.75,30.53,27.81,24.84,23.34,22.53,20.53,18.28,16.88,16.84,16.25,14.12,13.12,13.91,15.0,15.34,16.5,19.72,22.47,23.22,23.72,25.09,27.06,28.03,28.09,29.16,31.22,32.44,32.5,32.69,33.44,33.44,31.78,29.53,29.34,29.03,27.16,24.88,23.94,24.0,23.34,22.34,23.22,24.88,26.19,26.47,28.16,30.94,33.47,34.25,34.5,35.72,36.25,34.56,31.97,30.06,28.47,25.22,21.59,19.5,18.53,17.53,16.12,15.84,17.38,18.81,18.47,17.38,18.03,18.88,18.12,17.88,19.09,20.72,21.28,20.38,20.38,21.5,22.06,21.25,21.19,22.5,23.47,23.12,22.44,23.88,25.97,26.97,27.38,28.44,29.62,28.91,26.47,24.06,23.47,22.75,21.03,20.31,21.41,22.62,22.41,21.5,22.06,22.91,22.16,20.66,19.91,20.12,19.62,18.41,18.06,19.59,21.0,21.56,21.91,24.0,26.0,26.28,25.47,26.19,27.22,26.41,25.69,26.41,28.44,29.88,30.28,30.75,31.28,31.44,29.72,28.25,29.03,30.25,30.06,29.03,29.19,30.06,29.47,29.0,29.75,31.81,32.53,32.22,31.72,32.34,32.34,30.78,28.69,28.28,27.78,26.03,24.25,23.97,24.88,24.81,24.78,26.03,28.94,30.88,31.12,30.91,31.28,30.62,28.0,25.12,24.22,24.03,22.81,21.31,21.53,23.06,23.56,23.31,24.19,26.19,26.94,26.53,26.09,27.44,28.12,26.81,24.94,24.44,24.09,22.53,20.78,20.19,20.91,20.22,18.38,16.97,16.69,15.72,13.66,11.69,11.66,12.09,11.56,11.5,13.22,15.31,15.75,15.47,16.25,17.69,18.44,18.25,19.34,21.16,22.28,22.5,22.38,24.19,26.25,27.09,27.88,29.97,31.88,32.09,31.12,31.19,32.12,31.97,30.5,29.94,30.59,30.16,28.22,26.19,25.94,25.75,24.78,24.22,25.66,27.94,29.06,28.97,29.75,31.12,31.47,30.41,30.12,30.97,31.12,29.91,28.47,28.31,28.06,26.47,24.28,23.53,23.16,21.97,20.16,19.56,20.5,20.25,18.66,17.56,18.44,19.19,19.28,19.56,21.88,23.88,24.44,25.06,27.28,30.03,31.59,32.0,32.84,33.81,32.88,30.22,27.25,25.84,24.88,23.44,22.72,24.12,25.12,24.91,23.28,23.03,23.25,22.47,20.81,20.38,20.88,20.56,19.03,17.91,18.34,18.31,17.06,15.88,16.62,17.25,16.84,16.03,16.38,17.38,17.09,15.69,14.91,15.12,14.44,12.47,10.69,10.47,10.34,9.38,8.25,9.34,11.31,12.41,12.97,15.34,18.5,20.5,21.16,22.5,25.0,26.56,26.28,25.88,26.31,26.41,24.78,23.16,22.94,23.22,22.72,21.69,22.19,23.5,24.25,23.69,23.38,24.41,24.69,23.34,22.06,22.09,22.0,20.41,18.38,18.03,18.5,18.69,18.66,20.12,22.88,24.72,25.19,25.69,26.84,27.16,25.19,23.38,22.69,22.34,20.88,19.16,19.03,18.78,17.25,14.91,13.62,13.91,13.91,13.47,14.25,17.06,19.22,19.75,19.97,20.81,21.16,20.16,18.66,19.25,20.62,21.59,22.03,23.06,24.88,25.72,24.91,24.44,25.5,26.56,25.91,24.91,25.03,25.03,24.0,23.09,24.03,26.0,27.72,27.62,28.38,29.97,30.09,28.62,27.66,28.31,29.0,28.06,26.88,27.12,27.09,26.12,24.53,24.81,25.59,25.62,24.66,24.28,25.03,25.69,25.0,24.75,25.66,26.22,25.16,23.66,23.62,23.69,23.0,22.12,22.47,23.75,24.72,24.72,25.25,26.66,27.53,27.12,26.62,27.47,27.59,25.88,22.94,21.38,20.09,18.34,16.41,15.66,15.94,15.53,14.09,13.19,13.5,13.66,12.91,12.16,13.31,14.97,15.5,15.84,17.75,19.59,20.38,20.0,19.78,20.25,20.03,18.62,17.72,18.38,18.66,16.97,14.69,13.94,13.06,11.88,11.16,12.97,15.94,18.41,19.06,19.97,21.53,22.0,20.69,20.09,20.75,21.09,19.53,18.5,19.56,21.16,21.72,22.09,23.34,24.84,24.16,22.19,20.47,19.5,18.06,15.09,13.34,13.38,13.56,12.5,11.56,12.28,13.94,14.34,14.41,15.91,18.72,20.84,22.25,24.53,27.34,29.19,28.5,27.0,25.53,23.22,19.06,15.0,12.72,12.03,11.22,10.62,12.03,14.19,15.53,15.78,16.47,18.56,20.25,20.88,22.06,24.66,27.12,27.94,28.38,29.72,31.22,31.44,30.72,30.88,31.59,31.41,29.31,27.53,27.06,25.81,22.69,20.06,18.97,18.5,17.0,15.91,16.38,17.38,17.09,16.16,15.97,16.97,17.25,16.66,16.84,18.72,20.56,21.09,21.81,23.59,24.97,24.53,22.78,22.44,22.34,21.0,18.94,17.62,17.53,16.88,15.5,14.62,15.44,16.66,16.53,17.12,19.38,22.66,23.66,23.69,24.12,24.69,24.0,22.12,21.19,21.16,20.69,18.91,17.5,17.88,18.41,17.38,16.5,17.25,18.66,18.88,18.72,19.5,20.84,21.0,20.47,20.91,22.09,22.78,21.66,20.41,20.34,20.56,19.47,18.22,17.88,18.09,16.62,14.59,13.56,13.59,13.19,12.41,12.78,15.41,18.38,20.22,22.34,25.91,29.19,30.38,30.78,31.56,32.0,30.47,27.41,25.38,24.25,22.59,20.38,19.22,19.69,19.88,19.0,18.19,18.91,19.97,19.41,19.03,19.47,20.34,19.91,18.75,18.34,18.78,18.38,16.72,15.81,16.28,17.56,17.56,17.94,19.72,21.47,21.78,21.56,22.59,25.12,26.5,27.12,28.12,29.53,29.72,27.66,25.56,24.28,23.06,21.06,19.62,19.91,21.5,21.59,21.0,21.03,21.62,20.69,19.31,19.0,20.16,21.59,21.66,22.62,24.81,27.16,28.12,28.62,30.5,32.47,32.94,32.75,33.25,34.03,33.75,32.28,30.91,30.53,29.56,27.19,25.47,25.47,25.59,24.81,23.53,23.28,23.72,22.84,21.0,20.38,21.0,20.97,20.66,21.31,23.72,25.25,25.12,25.38,26.34,27.12,26.31,25.25,24.88,24.78,23.5,21.88,21.12,22.06,22.28,21.66,21.91,23.5,25.16,25.53,25.84,27.31,28.59,28.44,27.47,27.59,28.16,27.5,26.0,25.22,25.81,25.53,23.97,23.12,23.94,42.66,41.03,39.94,40.12,40.69,41.56,43.0,45.0,46.03,46.06,45.5,45.31,44.62,44.19,44.25,44.62,44.62,44.06,42.28,40.22,38.94,38.06,37.91,38.94,41.06,43.22,43.97,44.0,44.5,44.56,44.38,45.12,46.34,48.44,49.78,49.97,50.25,50.81,51.16,51.22,51.22,51.44:negativity
10.44,8.91,6.34,4.75,6.06,7.84,7.69,7.53,9.53,12.22,12.53,11.31,11.06,11.47,10.34,7.62,6.56,8.44,10.19,10.0,10.31,13.06,15.91,16.66,17.19,19.59,22.69,23.28,21.66,20.22,20.0,18.0,13.62,10.75,10.28,10.12,8.06,6.47,7.28,9.0,8.62,7.66,9.31,12.72,14.34,14.62,16.44,19.88,22.09,22.0,22.44,24.66,25.75,24.03,21.38,20.62,20.16,17.72,14.56,13.91,15.38,15.97,15.59,16.31,19.06,21.0,20.03,19.72,21.41,23.25,22.5,21.03,21.03,22.16,20.72,17.88,16.59,16.75,15.62,12.44,10.75,11.78,13.09,12.31,12.31,14.59,16.78,15.66,13.59,13.19,14.19,14.03,13.28,14.59,17.78,19.84,19.56,19.09,19.88,20.09,17.91,14.91,14.53,15.12,13.62,11.09,10.44,11.0,10.0,7.0,5.12,4.75,3.5,-0.03,-2.72,-2.53,-1.91,-3.31,-4.81,-4.28,-2.38,-2.94,-4.81,-4.88,-3.44,-3.0,-3.91,-3.47,-1.09,1.0,-0.12,-1.16,-0.16,1.75,1.5,0.97,2.34,3.59,2.34,-0.97,-2.88,-2.75,-2.97,-4.09,-4.06,-1.22,1.19,1.12,0.94,2.66,4.69,4.25,2.84,3.16,4.62,4.59,2.81,1.91,3.03,2.91,0.5,-1.16,-0.41,0.81,-0.47,-1.75,-0.75,1.06,0.66,-0.41,-0.09,2.0,2.5,1.31,0.38,1.84,2.44,0.78,0.22,2.12,4.88,5.38,5.16,6.66,8.78,8.34,6.66,6.03,7.38,7.25,5.16,4.16,5.59,6.5,5.62,4.53,5.41,6.19,4.41,1.66,1.22,2.72,3.19,2.34,2.62,4.56,4.38,1.81,-0.81,-0.88,-0.47,-1.75,-2.66,-0.38,2.53,3.16,2.38,3.06,4.72,4.72,2.91,1.69,2.5,2.44,0.69,-0.81,0.81,3.03,2.5,1.5,2.09,3.34,2.34,-0.03,-0.78,0.34,0.59,-0.56,-0.97,0.88,2.19,0.94,-0.47,0.5,1.78,0.72,-1.16,-0.78,0.88,0.25,-1.62,-2.38,-1.34,-1.81,-3.84,-5.25,-3.75,-2.22,-2.22,-1.91,1.25,5.34,6.62,5.88,6.44,7.56,6.94,4.91,4.19,5.72,6.25,4.59,3.38,4.31,5.41,4.69,3.72,5.38,8.12,8.75,8.38,9.69,12.22,13.16,11.38,10.41,10.38,9.66,6.75,4.12,4.38,5.0,4.09,2.41,3.28,5.28,5.5,4.53,5.0,7.06,7.91,6.66,6.31,7.84,9.03,8.09,6.75,8.06,9.59,9.44,7.84,7.78,9.03,8.44,6.41,5.88,7.25,7.75,6.41,5.81,7.44,9.0,8.34,7.31,8.25,10.06,10.44,9.53,10.22,11.81,11.19,8.03,5.88,6.25,6.22,4.28,2.91,3.97,4.47,2.31,-0.69,-1.38,-1.41,-2.28,-4.66,-4.16,-1.81,-0.62,-1.28,-1.22,1.03,2.56,1.94,1.56,3.22,5.31,4.81,2.56,2.59,3.88,3.78,2.66,3.19,5.59,6.69,5.16,4.34,5.88,7.38,6.19,4.41,4.5,4.28,1.94,-1.59,-3.38,-3.38,-4.09,-6.12,-5.97,-3.72,-1.59,-1.91,-1.84,0.06,1.56,0.0,-1.97,-1.72,-0.47,-0.31,-1.31,-0.59,1.41,1.66,-0.91,-3.0,-2.91,-3.84,-6.81,-9.28,-8.91,-8.0,-8.84,-9.72,-8.28,-5.81,-4.62,-4.81,-3.41,-0.72,0.38,-1.28,-2.16,-1.06,0.22,-0.66,-1.47,-0.19,1.12,0.16,-1.09,-0.5,1.5,2.19,1.09,1.47,3.66,4.88,3.31,2.06,2.78,3.38,1.25,-0.53,-0.03,1.31,0.5,-1.31,-1.09,0.5,0.91,-0.09,-0.22,1.47,2.78,1.41,0.41,1.72,3.66,2.94,1.75,2.38,3.25,1.56,-1.84,-3.53,-4.09,-5.34,-8.06,-9.5,-8.25,-6.88,-7.69,-8.34,-6.62,-4.53,-4.62,-5.16,-3.78,-0.94,-0.19,-1.0,-0.69,1.12,1.84,0.81,0.38,2.25,4.38,3.81,3.38,4.78,6.28,5.09,2.41,1.34,1.72,1.47,0.41,1.25,4.53,7.31,7.59,7.97,9.78,11.16,9.75,7.28,6.91,7.59,6.41,4.5,4.66,6.19,6.81,5.84,5.47,6.91,7.59,5.72,3.41,3.31,3.81,1.59,-0.69,-1.06,-0.31,-1.53,-3.5,-3.59,-2.66,-2.66,-4.25,-5.06,-3.69,-2.34,-3.06,-4.19,-2.88,-0.88,-1.28,-1.78,-0.84,1.56,2.41,1.31,1.75,3.78,5.34,4.5,3.91,5.09,5.69,3.59,1.06,1.03,2.22,2.19,1.25,1.72,3.38,3.03,0.97,-0.16,0.81,1.53,0.34,-0.47,0.5,1.38,-0.06,-2.59,-3.16,-2.28,-3.03,-4.06,-3.25,-0.06,1.59,1.72,2.12,4.0,4.97,3.16,1.0,0.25,-0.03,-2.5,-5.44,-6.47,-5.94,-7.19,-9.41,-10.38,-9.09,-8.31,-9.06,-8.78,-5.84,-2.59,-1.81,-1.5,0.38,2.66,2.53,1.03,0.88,1.91,1.66,0.41,0.34,3.16,4.84,4.53,3.34,3.72,3.56,0.75,-2.34,-2.72,-1.53,-1.34,-1.88,-1.59,-0.03,0.28,-1.31,-2.25,-0.75,-0.03,-1.12,-1.72,-0.56,1.34,1.12,-0.03,0.88,2.84,3.12,1.62,1.47,3.12,3.31,1.06,-0.66,-0.41,-0.78,-2.72,-4.56,-3.78,-1.78,-1.75,-2.62,-1.81,-0.03,0.28,-1.34,-1.5,0.09,1.31,0.34,-0.72,0.5,1.47,0.75,-0.31,0.94,2.91,3.12,1.91,1.94,3.38,3.31,1.5,0.03,0.69,0.94,-1.06,-2.69,-1.66,-0.91,-2.5,-4.72,-5.28,-4.5,-4.75,-5.72,-4.84,-2.09,-0.28,-0.91,-0.69,1.28,2.44,1.16,-0.31,1.09,3.06,3.75,4.03,6.31,9.5,10.88,10.5,10.75,12.69,13.44,11.47,9.25,9.0,8.66,6.44,4.81,5.91,7.75,7.38,5.62,4.94,5.62,5.62,4.53,4.78,7.16,8.16,6.28,4.25,4.53,4.97,4.0,3.09,5.44,8.66,10.28,10.38,11.19,12.06,11.5,8.59,6.75,7.69,9.0,8.44,7.94,9.41,10.88,10.19,8.03,7.81,8.69,8.53,7.0,6.88,8.47,9.72,8.56,8.44,10.5,12.44,12.25,11.25,12.38,13.69,12.84,10.72,10.81,12.31,13.25,12.53,13.38,15.72,16.97,15.84,14.38,15.25,15.72,14.28,12.59,13.72,15.53,15.44,13.94,13.66,14.31,13.16,10.5,8.59,8.59,8.25,5.72,3.16,3.31,3.84,2.84,1.84,3.28,5.62,6.59,6.06,7.03,9.19,10.91,10.91,11.88,15.19,18.09,17.94,16.84,17.31,17.12,14.72,10.97,9.56,9.84,9.09,7.75,7.81,9.34,9.59,7.5,5.5,5.69,6.44,5.41,4.5,6.62,9.84,10.75,9.84,10.38,11.25,10.5,8.16,7.25,8.34,9.44,8.59,8.47,10.41,12.81,12.47,10.81,11.22,12.28,11.38,8.62,7.59,8.41,8.06,5.81,5.09,6.56,8.06,7.09,6.25,7.62,9.03,8.78,7.38,8.44,10.56,11.06,9.97,10.19,11.53,12.25,11.06,10.44,12.09,13.38,11.0,7.5,5.91,5.19,2.84,0.78,1.34,3.81,4.69,3.91,4.12,5.59,6.22,4.66,3.84,5.62,7.75,7.88,7.75,9.62,12.34,12.75,11.38,11.19,11.88,10.59,7.25,5.41,5.56,5.94,4.53,3.47,4.56,5.66,4.62,2.97,3.53,5.53,5.31,4.19,4.81,7.06,8.62,8.06,7.62,8.78,9.03,7.0,5.22,6.03,7.69,7.34,6.28,7.12,9.03,9.38,8.69,9.38,11.69,13.0,11.72,10.81,11.5,11.69,9.66,7.34,7.03,7.72,6.38,4.06,3.56,4.56,4.38,2.5,1.56,2.81,3.19,0.91,-0.56,0.47,2.84,3.75,5.41,9.06,13.31,14.69,13.31,12.66,13.47,13.41,11.56,10.75,12.25,13.03,11.22,9.59,10.28,11.44,10.62,9.09,9.69,11.62,11.72,10.16,9.78,11.22,11.62,9.97,9.75,11.81,13.72,13.38,12.91,14.81,17.44,17.72,17.66,19.19,22.0,23.16,22.0,21.38,21.47,19.78,15.16,11.06,9.53,8.34,5.47,3.53,4.16,6.03,6.38,5.72,7.12,10.78,13.38,15.28,18.28,23.44,26.84,27.25,26.56,27.25,28.09,26.19,24.19,24.22,25.5,24.28,21.53,19.72,19.62,18.75,16.19,14.88,16.47,17.44,16.09,14.72,15.5,16.94,16.03,14.0,13.66,14.0,12.75,10.25,9.5,10.84,11.62,9.97,8.53,9.41,10.62,9.38,8.69,11.03,14.12,14.62,13.62,13.5,14.16,12.81,10.22,8.81,10.38,11.88,11.31,11.56,14.59,17.5,17.34,16.53,17.75,19.22,18.22,16.31,15.28,15.91,14.69,11.41,8.97,9.31,9.22,7.78,6.81,9.03,11.84,12.16,12.28,14.56,17.81,18.66,17.72,17.34,18.25,17.47,15.62,15.0,17.84,20.62,21.12,21.19,23.41,25.41,24.38,22.53,22.41,22.84,21.44,18.19,16.5,17.03,17.06,15.91,15.5,17.97,20.34,20.28,19.25,20.34,21.53,19.66,16.34,14.84,15.0,13.78,11.56,10.88,12.62,13.75,12.53,11.66,13.19,14.81,14.66,14.34,16.66,19.97,21.16,20.66,21.47,23.53,23.59,21.84,21.0,22.22,22.84,21.56,20.38,21.69,23.12,21.72,18.97,18.41,18.69,17.81,16.38,17.81,21.66,24.91,25.81,27.25,30.53,32.69,31.75,30.41,31.12,32.12,30.88,29.28:7.53,9.53,12.22,12.53,11.31,11.06,11.47,10.34,7.62,6.56,8.44,10.19,10.0,10.31,13.06,15.91,16.66,17.19,19.59,22.69,23.28,21.66,20.22,20.0,18.0,13.62,10.75,10.28,10.12,8.06,6.47,7.28,9.0,8.62,7.66,9.31,12.72,14.34,14.62,16.44,19.88,22.09,22.0,22.44,24.66,25.75,24.03,21.38,20.62,20.16,17.72,14.56,13.91,15.38,15.97,15.59,16.31,19.06,21.0,20.03,19.72,21.41,23.25,22.5,21.03,21.03,22.16,20.72,17.88,16.59,16.75,15.62,12.44,10.75,11.78,13.09,12.31,12.31,14.59,16.78,15.66,13.59,13.19,14.19,14.03,13.28,14.59,17.78,19.84,19.56,19.09,19.88,20.09,17.91,14.91,14.53,15.12,13.62,11.09,10.44,11.0,10.0,7.0,5.12,4.75,3.5,-0.03,-2.72,-2.53,-1.91,-3.31,-4.81,-4.28,-2.38,-2.94,-4.81,-4.88,-3.44,-3.0,-3.91,-3.47,-1.09,1.0,-0.12,-1.16,-0.16,1.75,1.5,0.97,2.34,3.59,2.34,-0.97,-2.88,-2.75,-2.97,-4.09,-4.06,-1.22,1.19,1.12,0.94,2.66,4.69,4.25,2.84,3.16,4.62,4.59,2.81,1.91,3.03,2.91,0.5,-1.16,-0.41,0.81,-0.47,-1.75,-0.75,1.06,0.66,-0.41,-0.09,2.0,2.5,1.31,0.38,1.84,2.44,0.78,0.22,2.12,4.88,5.38,5.16,6.66,8.78,8.34,6.66,6.03,7.38,7.25,5.16,4.16,5.59,6.5,5.62,4.53,5.41,6.19,4.41,1.66,1.22,2.72,3.19,2.34,2.62,4.56,4.38,1.81,-0.81,-0.88,-0.47,-1.75,-2.66,-0.38,2.53,3.16,2.38,3.06,4.72,4.72,2.91,1.69,2.5,2.44,0.69,-0.81,0.81,3.03,2.5,1.5,2.09,3.34,2.34,-0.03,-0.78,0.34,0.59,-0.56,-0.97,0.88,2.19,0.94,-0.47,0.5,1.78,0.72,-1.16,-0.78,0.88,0.25,-1.62,-2.38,-1.34,-1.81,-3.84,-5.25,-3.75,-2.22,-2.22,-1.91,1.25,5.34,6.62,5.88,6.44,7.56,6.94,4.91,4.19,5.72,6.25,4.59,3.38,4.31,5.41,4.69,3.72,5.38,8.12,8.75,8.38,9.69,12.22,13.16,11.38,10.41,10.38,9.66,6.75,4.12,4.38,5.0,4.09,2.41,3.28,5.28,5.5,4.53,5.0,7.06,7.91,6.66,6.31,7.84,9.03,8.09,6.75,8.06,9.59,9.44,7.84,7.78,9.03,8.44,6.41,5.88,7.25,7.75,6.41,5.81,7.44,9.0,8.34,7.31,8.25,10.06,10.44,9.53,10.22,11.81,11.19,8.03,5.88,6.25,6.22,4.28,2.91,3.97,4.47,2.31,-0.69,-1.38,-1.41,-2.28,-4.66,-4.16,-1.81,-0.62,-1.28,-1.22,1.03,2.56,1.94,1.56,3.22,5.31,4.81,2.56,2.59,3.88,3.78,2.66,3.19,5.59,6.69,5.16,4.34,5.88,7.38,6.19,4.41,4.5,4.28,1.94,-1.59,-3.38,-3.38,-4.09,-6.12,-5.97,-3.72,-1.59,-1.91,-1.84,0.06,1.56,0.0,-1.97,-1.72,-0.47,-0.31,-1.31,-0.59,1.41,1.66,-0.91,-3.0,-2.91,-3.84,-6.81,-9.28,-8.91,-8.0,-8.84,-9.72,-8.28,-5.81,-4.62,-4.81,-3.41,-0.72,0.38,-1.28,-2.16,-1.06,0.22,-0.66,-1.47,-0.19,1.12,0.16,-1.09,-0.5,1.5,2.19,1.09,1.47,3.66,4.88,3.31,2.06,2.78,3.38,1.25,-0.53,-0.03,1.31,0.5,-1.31,-1.09,0.5,0.91,-0.09,-0.22,1.47,2.78,1.41,0.41,1.72,3.66,2.94,1.75,2.38,3.25,1.56,-1.84,-3.53,-4.09,-5.34,-8.06,-9.5,-8.25,-6.88,-7.69,-8.34,-6.62,-4.53,-4.62,-5.16,-3.78,-0.94,-0.19,-1.0,-0.69,1.12,1.84,0.81,0.38,2.25,4.38,3.81,3.38,4.78,6.28,5.09,2.41,1.34,1.72,1.47,0.41,1.25,4.53,7.31,7.59,7.97,9.78,11.16,9.75,7.28,6.91,7.59,6.41,4.5,4.66,6.19,6.81,5.84,5.47,6.91,7.59,5.72,3.41,3.31,3.81,1.59,-0.69,-1.06,-0.31,-1.53,-3.5,-3.59,-2.66,-2.66,-4.25,-5.06,-3.69,-2.34,-3.06,-4.19,-2.88,-0.88,-1.28,-1.78,-0.84,1.56,2.41,1.31,1.75,3.78,5.34,4.5,3.91,5.09,5.69,3.59,1.06,1.03,2.22,2.19,1.25,1.72,3.38,3.03,0.97,-0.16,0.81,1.53,0.34,-0.47,0.5,1.38,-0.06,-2.59,-3.16,-2.28,-3.03,-4.06,-3.25,-0.06,1.59,1.72,2.12,4.0,4.97,3.16,1.0,0.25,-0.03,-2.5,-5.44,-6.47,-5.94,-7.19,-9.41,-10.38,-9.09,-8.31,-9.06,-8.78,-5.84,-2.59,-1.81,-1.5,0.38,2.66,2.53,1.03,0.88,1.91,1.66,0.41,0.34,3.16,4.84,4.53,3.34,3.72,3.56,0.75,-2.34,-2.72,-1.53,-1.34,-1.88,-1.59,-0.03,0.28,-1.31,-2.25,-0.75,-0.03,-1.12,-1.72,-0.56,1.34,1.12,-0.03,0.88,2.84,3.12,1.62,1.47,3.12,3.31,1.06,-0.66,-0.41,-0.78,-2.72,-4.56,-3.78,-1.78,-1.75,-2.62,-1.81,-0.03,0.28,-1.34,-1.5,0.09,1.31,0.34,-0.72,0.5,1.47,0.75,-0.31,0.94,2.91,3.12,1.91,1.94,3.38,3.31,1.5,0.03,0.69,0.94,-1.06,-2.69,-1.66,-0.91,-2.5,-4.72,-5.28,-4.5,-4.75,-5.72,-4.84,-2.09,-0.28,-0.91,-0.69,1.28,2.44,1.16,-0.31,1.09,3.06,3.75,4.03,6.31,9.5,10.88,10.5,10.75,12.69,13.44,11.47,9.25,9.0,8.66,6.44,4.81,5.91,7.75,7.38,5.62,4.94,5.62,5.62,4.53,4.78,7.16,8.16,6.28,4.25,4.53,4.97,4.0,3.09,5.44,8.66,10.28,10.38,11.19,12.06,11.5,8.59,6.75,7.69,9.0,8.44,7.94,9.41,10.88,10.19,8.03,7.81,8.69,8.53,7.0,6.88,8.47,9.72,8.56,8.44,10.5,12.44,12.25,11.25,12.38,13.69,12.84,10.72,10.81,12.31,13.25,12.53,13.38,15.72,16.97,15.84,14.38,15.25,15.72,14.28,12.59,13.72,15.53,15.44,13.94,13.66,14.31,13.16,10.5,8.59,8.59,8.25,5.72,3.16,3.31,3.84,2.84,1.84,3.28,5.62,6.59,6.06,7.03,9.19,10.91,10.91,11.88,15.19,18.09,17.94,16.84,17.31,17.12,14.72,10.97,9.56,9.84,9.09,7.75,7.81,9.34,9.59,7.5,5.5,5.69,6.44,5.41,4.5,6.62,9.84,10.75,9.84,10.38,11.25,10.5,8.16,7.25,8.34,9.44,8.59,8.47,10.41,12.81,12.47,10.81,11.22,12.28,11.38,8.62,7.59,8.41,8.06,5.81,5.09,6.56,8.06,7.09,6.25,7.62,9.03,8.78,7.38,8.44,10.56,11.06,9.97,10.19,11.53,12.25,11.06,10.44,12.09,13.38,11.0,7.5,5.91,5.19,2.84,0.78,1.34,3.81,4.69,3.91,4.12,5.59,6.22,4.66,3.84,5.62,7.75,7.88,7.75,9.62,12.34,12.75,11.38,11.19,11.88,10.59,7.25,5.41,5.56,5.94,4.53,3.47,4.56,5.66,4.62,2.97,3.53,5.53,5.31,4.19,4.81,7.06,8.62,8.06,7.62,8.78,9.03,7.0,5.22,6.03,7.69,7.34,6.28,7.12,9.03,9.38,8.69,9.38,11.69,13.0,11.72,10.81,11.5,11.69,9.66,7.34,7.03,7.72,6.38,4.06,3.56,4.56,4.38,2.5,1.56,2.81,3.19,0.91,-0.56,0.47,2.84,3.75,5.41,9.06,13.31,14.69,13.31,12.66,13.47,13.41,11.56,10.75,12.25,13.03,11.22,9.59,10.28,11.44,10.62,9.09,9.69,11.62,11.72,10.16,9.78,11.22,11.62,9.97,9.75,11.81,13.72,13.38,12.91,14.81,17.44,17.72,17.66,19.19,22.0,23.16,22.0,21.38,21.47,19.78,15.16,11.06,9.53,8.34,5.47,3.53,4.16,6.03,6.38,5.72,7.12,10.78,13.38,15.28,18.28,23.44,26.84,27.25,26.56,27.25,28.09,26.19,24.19,24.22,25.5,24.28,21.53,19.72,19.62,18.75,16.19,14.88,16.47,17.44,16.09,14.72,15.5,16.94,16.03,14.0,13.66,14.0,12.75,10.25,9.5,10.84,11.62,9.97,8.53,9.41,10.62,9.38,8.69,11.03,14.12,14.62,13.62,13.5,14.16,12.81,10.22,8.81,10.38,11.88,11.31,11.56,14.59,17.5,17.34,16.53,17.75,19.22,18.22,16.31,15.28,15.91,14.69,11.41,8.97,9.31,9.22,7.78,6.81,9.03,11.84,12.16,12.28,14.56,17.81,18.66,17.72,17.34,18.25,17.47,15.62,15.0,17.84,20.62,21.12,21.19,23.41,25.41,24.38,22.53,22.41,22.84,21.44,18.19,16.5,17.03,17.06,15.91,15.5,17.97,20.34,20.28,19.25,20.34,21.53,19.66,16.34,14.84,15.0,13.78,11.56,10.88,12.62,13.75,12.53,11.66,13.19,14.81,14.66,14.34,16.66,19.97,21.16,20.66,21.47,23.53,23.59,21.84,21.0,22.22,22.84,21.56,20.38,21.69,23.12,21.72,18.97,18.41,18.69,17.81,16.38,17.81,21.66,24.91,25.81,27.25,30.53,32.69,31.75,30.41,31.12,32.12,30.88,29.28,27.75,25.97,23.47,22.31,22.69,23.56,23.25:10.34,7.62,6.56,8.44,10.19,10.0,10.31,13.06,15.91,16.66,17.19,19.59,22.69,23.28,21.66,20.22,20.0,18.0,13.62,10.75,10.28,10.12,8.06,6.47,7.28,9.0,8.62,7.66,9.31,12.72,14.34,14.62,16.44,19.88,22.09,22.0,22.44,24.66,25.75,24.03,21.38,20.62,20.16,17.72,14.56,13.91,15.38,15.97,15.59,16.31,19.06,21.0,20.03,19.72,21.41,23.25,22.5,21.03,21.03,22.16,20.72,17.88,16.59,16.75,15.62,12.44,10.75,11.78,13.09,12.31,12.31,14.59,16.78,15.66,13.59,13.19,14.19,14.03,13.28,14.59,17.78,19.84,19.56,19.09,19.88,20.09,17.91,14.91,14.53,15.12,13.62,11.09,10.44,11.0,10.0,7.0,5.12,4.75,3.5,-0.03,-2.72,-2.53,-1.91,-3.31,-4.81,-4.28,-2.38,-2.94,-4.81,-4.88,-3.44,-3.0,-3.91,-3.47,-1.09,1.0,-0.12,-1.16,-0.16,1.75,1.5,0.97,2.34,3.59,2.34,-0.97,-2.88,-2.75,-2.97,-4.09,-4.06,-1.22,1.19,1.12,0.94,2.66,4.69,4.25,2.84,3.16,4.62,4.59,2.81,1.91,3.03,2.91,0.5,-1.16,-0.41,0.81,-0.47,-1.75,-0.75,1.06,0.66,-0.41,-0.09,2.0,2.5,1.31,0.38,1.84,2.44,0.78,0.22,2.12,4.88,5.38,5.16,6.66,8.78,8.34,6.66,6.03,7.38,7.25,5.16,4.16,5.59,6.5,5.62,4.53,5.41,6.19,4.41,1.66,1.22,2.72,3.19,2.34,2.62,4.56,4.38,1.81,-0.81,-0.88,-0.47,-1.75,-2.66,-0.38,2.53,3.16,2.38,3.06,4.72,4.72,2.91,1.69,2.5,2.44,0.69,-0.81,0.81,3.03,2.5,1.5,2.09,3.34,2.34,-0.03,-0.78,0.34,0.59,-0.56,-0.97,0.88,2.19,0.94,-0.47,0.5,1.78,0.72,-1.16,-0.78,0.88,0.25,-1.62,-2.38,-1.34,-1.81,-3.84,-5.25,-3.75,-2.22,-2.22,-1.91,1.25,5.34,6.62,5.88,6.44,7.56,6.94,4.91,4.19,5.72,6.25,4.59,3.38,4.31,5.41,4.69,3.72,5.38,8.12,8.75,8.38,9.69,12.22,13.16,11.38,10.41,10.38,9.66,6.75,4.12,4.38,5.0,4.09,2.41,3.28,5.28,5.5,4.53,5.0,7.06,7.91,6.66,6.31,7.84,9.03,8.09,6.75,8.06,9.59,9.44,7.84,7.78,9.03,8.44,6.41,5.88,7.25,7.75,6.41,5.81,7.44,9.0,8.34,7.31,8.25,10.06,10.44,9.53,10.22,11.81,11.19,8.03,5.88,6.25,6.22,4.28,2.91,3.97,4.47,2.31,-0.69,-1.38,-1.41,-2.28,-4.66,-4.16,-1.81,-0.62,-1.28,-1.22,1.03,2.56,1.94,1.56,3.22,5.31,4.81,2.56,2.59,3.88,3.78,2.66,3.19,5.59,6.69,5.16,4.34,5.88,7.38,6.19,4.41,4.5,4.28,1.94,-1.59,-3.38,-3.38,-4.09,-6.12,-5.97,-3.72,-1.59,-1.91,-1.84,0.06,1.56,0.0,-1.97,-1.72,-0.47,-0.31,-1.31,-0.59,1.41,1.66,-0.91,-3.0,-2.91,-3.84,-6.81,-9.28,-8.91,-8.0,-8.84,-9.72,-8.28,-5.81,-4.62,-4.81,-3.41,-0.72,0.38,-1.28,-2.16,-1.06,0.22,-0.66,-1.47,-0.19,1.12,0.16,-1.09,-0.5,1.5,2.19,1.09,1.47,3.66,4.88,3.31,2.06,2.78,3.38,1.25,-0.53,-0.03,1.31,0.5,-1.31,-1.09,0.5,0.91,-0.09,-0.22,1.47,2.78,1.41,0.41,1.72,3.66,2.94,1.75,2.38,3.25,1.56,-1.84,-3.53,-4.09,-5.34,-8.06,-9.5,-8.25,-6.88,-7.69,-8.34,-6.62,-4.53,-4.62,-5.16,-3.78,-0.94,-0.19,-1.0,-0.69,1.12,1.84,0.81,0.38,2.25,4.38,3.81,3.38,4.78,6.28,5.09,2.41,1.34,1.72,1.47,0.41,1.25,4.53,7.31,7.59,7.97,9.78,11.16,9.75,7.28,6.91,7.59,6.41,4.5,4.66,6.19,6.81,5.84,5.47,6.91,7.59,5.72,3.41,3.31,3.81,1.59,-0.69,-1.06,-0.31,-1.53,-3.5,-3.59,-2.66,-2.66,-4.25,-5.06,-3.69,-2.34,-3.06,-4.19,-2.88,-0.88,-1.28,-1.78,-0.84,1.56,2.41,1.31,1.75,3.78,5.34,4.5,3.91,5.09,5.69,3.59,1.06,1.03,2.22,2.19,1.25,1.72,3.38,3.03,0.97,-0.16,0.81,1.53,0.34,-0.47,0.5,1.38,-0.06,-2.59,-3.16,-2.28,-3.03,-4.06,-3.25,-0.06,1.59,1.72,2.12,4.0,4.97,3.16,1.0,0.25,-0.03,-2.5,-5.44,-6.47,-5.94,-7.19,-9.41,-10.38,-9.09,-8.31,-9.06,-8.78,-5.84,-2.59,-1.81,-1.5,0.38,2.66,2.53,1.03,0.88,1.91,1.66,0.41,0.34,3.16,4.84,4.53,3.34,3.72,3.56,0.75,-2.34,-2.72,-1.53,-1.34,-1.88,-1.59,-0.03,0.28,-1.31,-2.25,-0.75,-0.03,-1.12,-1.72,-0.56,1.34,1.12,-0.03,0.88,2.84,3.12,1.62,1.47,3.12,3.31,1.06,-0.66,-0.41,-0.78,-2.72,-4.56,-3.78,-1.78,-1.75,-2.62,-1.81,-0.03,0.28,-1.34,-1.5,0.09,1.31,0.34,-0.72,0.5,1.47,0.75,-0.31,0.94,2.91,3.12,1.91,1.94,3.38,3.31,1.5,0.03,0.69,0.94,-1.06,-2.69,-1.66,-0.91,-2.5,-4.72,-5.28,-4.5,-4.75,-5.72,-4.84,-2.09,-0.28,-0.91,-0.69,1.28,2.44,1.16,-0.31,1.09,3.06,3.75,4.03,6.31,9.5,10.88,10.5,10.75,12.69,13.44,11.47,9.25,9.0,8.66,6.44,4.81,5.91,7.75,7.38,5.62,4.94,5.62,5.62,4.53,4.78,7.16,8.16,6.28,4.25,4.53,4.97,4.0,3.09,5.44,8.66,10.28,10.38,11.19,12.06,11.5,8.59,6.75,7.69,9.0,8.44,7.94,9.41,10.88,10.19,8.03,7.81,8.69,8.53,7.0,6.88,8.47,9.72,8.56,8.44,10.5,12.44,12.25,11.25,12.38,13.69,12.84,10.72,10.81,12.31,13.25,12.53,13.38,15.72,16.97,15.84,14.38,15.25,15.72,14.28,12.59,13.72,15.53,15.44,13.94,13.66,14.31,13.16,10.5,8.59,8.59,8.25,5.72,3.16,3.31,3.84,2.84,1.84,3.28,5.62,6.59,6.06,7.03,9.19,10.91,10.91,11.88,15.19,18.09,17.94,16.84,17.31,17.12,14.72,10.97,9.56,9.84,9.09,7.75,7.81,9.34,9.59,7.5,5.5,5.69,6.44,5.41,4.5,6.62,9.84,10.75,9.84,10.38,11.25,10.5,8.16,7.25,8.34,9.44,8.59,8.47,10.41,12.81,12.47,10.81,11.22,12.28,11.38,8.62,7.59,8.41,8.06,5.81,5.09,6.56,8.06,7.09,6.25,7.62,9.03,8.78,7.38,8.44,10.56,11.06,9.97,10.19,11.53,12.25,11.06,10.44,12.09,13.38,11.0,7.5,5.91,5.19,2.84,0.78,1.34,3.81,4.69,3.91,4.12,5.59,6.22,4.66,3.84,5.62,7.75,7.88,7.75,9.62,12.34,12.75,11.38,11.19,11.88,10.59,7.25,5.41,5.56,5.94,4.53,3.47,4.56,5.66,4.62,2.97,3.53,5.53,5.31,4.19,4.81,7.06,8.62,8.06,7.62,8.78,9.03,7.0,5.22,6.03,7.69,7.34,6.28,7.12,9.03,9.38,8.69,9.38,11.69,13.0,11.72,10.81,11.5,11.69,9.66,7.34,7.03,7.72,6.38,4.06,3.56,4.56,4.38,2.5,1.56,2.81,3.19,0.91,-0.56,0.47,2.84,3.75,5.41,9.06,13.31,14.69,13.31,12.66,13.47,13.41,11.56,10.75,12.25,13.03,11.22,9.59,10.28,11.44,10.62,9.09,9.69,11.62,11.72,10.16,9.78,11.22,11.62,9.97,9.75,11.81,13.72,13.38,12.91,14.81,17.44,17.72,17.66,19.19,22.0,23.16,22.0,21.38,21.47,19.78,15.16,11.06,9.53,8.34,5.47,3.53,4.16,6.03,6.38,5.72,7.12,10.78,13.38,15.28,18.28,23.44,26.84,27.25,26.56,27.25,28.09,26.19,24.19,24.22,25.5,24.28,21.53,19.72,19.62,18.75,16.19,14.88,16.47,17.44,16.09,14.72,15.5,16.94,16.03,14.0,13.66,14.0,12.75,10.25,9.5,10.84,11.62,9.97,8.53,9.41,10.62,9.38,8.69,11.03,14.12,14.62,13.62,13.5,14.16,12.81,10.22,8.81,10.38,11.88,11.31,11.56,14.59,17.5,17.34,16.53,17.75,19.22,18.22,16.31,15.28,15.91,14.69,11.41,8.97,9.31,9.22,7.78,6.81,9.03,11.84,12.16,12.28,14.56,17.81,18.66,17.72,17.34,18.25,17.47,15.62,15.0,17.84,20.62,21.12,21.19,23.41,25.41,24.38,22.53,22.41,22.84,21.44,18.19,16.5,17.03,17.06,15.91,15.5,17.97,20.34,20.28,19.25,20.34,21.53,19.66,16.34,14.84,15.0,13.78,11.56,10.88,12.62,13.75,12.53,11.66,13.19,14.81,14.66,14.34,16.66,19.97,21.16,20.66,21.47,23.53,23.59,21.84,21.0,22.22,22.84,21.56,20.38,21.69,23.12,21.72,18.97,18.41,18.69,17.81,16.38,17.81,21.66,24.91,25.81,27.25,30.53,32.69,31.75,30.41,31.12,32.12,30.88,29.28,27.75,25.97,23.47,22.31,22.69,23.56,23.25,22.75,23.94,25.16,25.47,24.66,24.09,24.12:13.06,15.91,16.66,17.19,19.59,22.69,23.28,21.66,20.22,20.0,18.0,13.62,10.75,10.28,10.12,8.06,6.47,7.28,9.0,8.62,7.66,9.31,12.72,14.34,14.62,16.44,19.88,22.09,22.0,22.44,24.66,25.75,24.03,21.38,20.62,20.16,17.72,14.56,13.91,15.38,15.97,15.59,16.31,19.06,21.0,20.03,19.72,21.41,23.25,22.5,21.03,21.03,22.16,20.72,17.88,16.59,16.75,15.62,12.44,10.75,11.78,13.09,12.31,12.31,14.59,16.78,15.66,13.59,13.19,14.19,14.03,13.28,14.59,17.78,19.84,19.56,19.09,19.88,20.09,17.91,14.91,14.53,15.12,13.62,11.09,10.44,11.0,10.0,7.0,5.12,4.75,3.5,-0.03,-2.72,-2.53,-1.91,-3.31,-4.81,-4.28,-2.38,-2.94,-4.81,-4.88,-3.44,-3.0,-3.91,-3.47,-1.09,1.0,-0.12,-1.16,-0.16,1.75,1.5,0.97,2.34,3.59,2.34,-0.97,-2.88,-2.75,-2.97,-4.09,-4.06,-1.22,1.19,1.12,0.94,2.66,4.69,4.25,2.84,3.16,4.62,4.59,2.81,1.91,3.03,2.91,0.5,-1.16,-0.41,0.81,-0.47,-1.75,-0.75,1.06,0.66,-0.41,-0.09,2.0,2.5,1.31,0.38,1.84,2.44,0.78,0.22,2.12,4.88,5.38,5.16,6.66,8.78,8.34,6.66,6.03,7.38,7.25,5.16,4.16,5.59,6.5,5.62,4.53,5.41,6.19,4.41,1.66,1.22,2.72,3.19,2.34,2.62,4.56,4.38,1.81,-0.81,-0.88,-0.47,-1.75,-2.66,-0.38,2.53,3.16,2.38,3.06,4.72,4.72,2.91,1.69,2.5,2.44,0.69,-0.81,0.81,3.03,2.5,1.5,2.09,3.34,2.34,-0.03,-0.78,0.34,0.59,-0.56,-0.97,0.88,2.19,0.94,-0.47,0.5,1.78,0.72,-1.16,-0.78,0.88,0.25,-1.62,-2.38,-1.34,-1.81,-3.84,-5.25,-3.75,-2.22,-2.22,-1.91,1.25,5.34,6.62,5.88,6.44,7.56,6.94,4.91,4.19,5.72,6.25,4.59,3.38,4.31,5.41,4.69,3.72,5.38,8.12,8.75,8.38,9.69,12.22,13.16,11.38,10.41,10.38,9.66,6.75,4.12,4.38,5.0,4.09,2.41,3.28,5.28,5.5,4.53,5.0,7.06,7.91,6.66,6.31,7.84,9.03,8.09,6.75,8.06,9.59,9.44,7.84,7.78,9.03,8.44,6.41,5.88,7.25,7.75,6.41,5.81,7.44,9.0,8.34,7.31,8.25,10.06,10.44,9.53,10.22,11.81,11.19,8.03,5.88,6.25,6.22,4.28,2.91,3.97,4.47,2.31,-0.69,-1.38,-1.41,-2.28,-4.66,-4.16,-1.81,-0.62,-1.28,-1.22,1.03,2.56,1.94,1.56,3.22,5.31,4.81,2.56,2.59,3.88,3.78,2.66,3.19,5.59,6.69,5.16,4.34,5.88,7.38,6.19,4.41,4.5,4.28,1.94,-1.59,-3.38,-3.38,-4.09,-6.12,-5.97,-3.72,-1.59,-1.91,-1.84,0.06,1.56,0.0,-1.97,-1.72,-0.47,-0.31,-1.31,-0.59,1.41,1.66,-0.91,-3.0,-2.91,-3.84,-6.81,-9.28,-8.91,-8.0,-8.84,-9.72,-8.28,-5.81,-4.62,-4.81,-3.41,-0.72,0.38,-1.28,-2.16,-1.06,0.22,-0.66,-1.47,-0.19,1.12,0.16,-1.09,-0.5,1.5,2.19,1.09,1.47,3.66,4.88,3.31,2.06,2.78,3.38,1.25,-0.53,-0.03,1.31,0.5,-1.31,-1.09,0.5,0.91,-0.09,-0.22,1.47,2.78,1.41,0.41,1.72,3.66,2.94,1.75,2.38,3.25,1.56,-1.84,-3.53,-4.09,-5.34,-8.06,-9.5,-8.25,-6.88,-7.69,-8.34,-6.62,-4.53,-4.62,-5.16,-3.78,-0.94,-0.19,-1.0,-0.69,1.12,1.84,0.81,0.38,2.25,4.38,3.81,3.38,4.78,6.28,5.09,2.41,1.34,1.72,1.47,0.41,1.25,4.53,7.31,7.59,7.97,9.78,11.16,9.75,7.28,6.91,7.59,6.41,4.5,4.66,6.19,6.81,5.84,5.47,6.91,7.59,5.72,3.41,3.31,3.81,1.59,-0.69,-1.06,-0.31,-1.53,-3.5,-3.59,-2.66,-2.66,-4.25,-5.06,-3.69,-2.34,-3.06,-4.19,-2.88,-0.88,-1.28,-1.78,-0.84,1.56,2.41,1.31,1.75,3.78,5.34,4.5,3.91,5.09,5.69,3.59,1.06,1.03,2.22,2.19,1.25,1.72,3.38,3.03,0.97,-0.16,0.81,1.53,0.34,-0.47,0.5,1.38,-0.06,-2.59,-3.16,-2.28,-3.03,-4.06,-3.25,-0.06,1.59,1.72,2.12,4.0,4.97,3.16,1.0,0.25,-0.03,-2.5,-5.44,-6.47,-5.94,-7.19,-9.41,-10.38,-9.09,-8.31,-9.06,-8.78,-5.84,-2.59,-1.81,-1.5,0.38,2.66,2.53,1.03,0.88,1.91,1.66,0.41,0.34,3.16,4.84,4.53,3.34,3.72,3.56,0.75,-2.34,-2.72,-1.53,-1.34,-1.88,-1.59,-0.03,0.28,-1.31,-2.25,-0.75,-0.03,-1.12,-1.72,-0.56,1.34,1.12,-0.03,0.88,2.84,3.12,1.62,1.47,3.12,3.31,1.06,-0.66,-0.41,-0.78,-2.72,-4.56,-3.78,-1.78,-1.75,-2.62,-1.81,-0.03,0.28,-1.34,-1.5,0.09,1.31,0.34,-0.72,0.5,1.47,0.75,-0.31,0.94,2.91,3.12,1.91,1.94,3.38,3.31,1.5,0.03,0.69,0.94,-1.06,-2.69,-1.66,-0.91,-2.5,-4.72,-5.28,-4.5,-4.75,-5.72,-4.84,-2.09,-0.28,-0.91,-0.69,1.28,2.44,1.16,-0.31,1.09,3.06,3.75,4.03,6.31,9.5,10.88,10.5,10.75,12.69,13.44,11.47,9.25,9.0,8.66,6.44,4.81,5.91,7.75,7.38,5.62,4.94,5.62,5.62,4.53,4.78,7.16,8.16,6.28,4.25,4.53,4.97,4.0,3.09,5.44,8.66,10.28,10.38,11.19,12.06,11.5,8.59,6.75,7.69,9.0,8.44,7.94,9.41,10.88,10.19,8.03,7.81,8.69,8.53,7.0,6.88,8.47,9.72,8.56,8.44,10.5,12.44,12.25,11.25,12.38,13.69,12.84,10.72,10.81,12.31,13.25,12.53,13.38,15.72,16.97,15.84,14.38,15.25,15.72,14.28,12.59,13.72,15.53,15.44,13.94,13.66,14.31,13.16,10.5,8.59,8.59,8.25,5.72,3.16,3.31,3.84,2.84,1.84,3.28,5.62,6.59,6.06,7.03,9.19,10.91,10.91,11.88,15.19,18.09,17.94,16.84,17.31,17.12,14.72,10.97,9.56,9.84,9.09,7.75,7.81,9.34,9.59,7.5,5.5,5.69,6.44,5.41,4.5,6.62,9.84,10.75,9.84,10.38,11.25,10.5,8.16,7.25,8.34,9.44,8.59,8.47,10.41,12.81,12.47,10.81,11.22,12.28,11.38,8.62,7.59,8.41,8.06,5.81,5.09,6.56,8.06,7.09,6.25,7.62,9.03,8.78,7.38,8.44,10.56,11.06,9.97,10.19,11.53,12.25,11.06,10.44,12.09,13.38,11.0,7.5,5.91,5.19,2.84,0.78,1.34,3.81,4.69,3.91,4.12,5.59,6.22,4.66,3.84,5.62,7.75,7.88,7.75,9.62,12.34,12.75,11.38,11.19,11.88,10.59,7.25,5.41,5.56,5.94,4.53,3.47,4.56,5.66,4.62,2.97,3.53,5.53,5.31,4.19,4.81,7.06,8.62,8.06,7.62,8.78,9.03,7.0,5.22,6.03,7.69,7.34,6.28,7.12,9.03,9.38,8.69,9.38,11.69,13.0,11.72,10.81,11.5,11.69,9.66,7.34,7.03,7.72,6.38,4.06,3.56,4.56,4.38,2.5,1.56,2.81,3.19,0.91,-0.56,0.47,2.84,3.75,5.41,9.06,13.31,14.69,13.31,12.66,13.47,13.41,11.56,10.75,12.25,13.03,11.22,9.59,10.28,11.44,10.62,9.09,9.69,11.62,11.72,10.16,9.78,11.22,11.62,9.97,9.75,11.81,13.72,13.38,12.91,14.81,17.44,17.72,17.66,19.19,22.0,23.16,22.0,21.38,21.47,19.78,15.16,11.06,9.53,8.34,5.47,3.53,4.16,6.03,6.38,5.72,7.12,10.78,13.38,15.28,18.28,23.44,26.84,27.25,26.56,27.25,28.09,26.19,24.19,24.22,25.5,24.28,21.53,19.72,19.62,18.75,16.19,14.88,16.47,17.44,16.09,14.72,15.5,16.94,16.03,14.0,13.66,14.0,12.75,10.25,9.5,10.84,11.62,9.97,8.53,9.41,10.62,9.38,8.69,11.03,14.12,14.62,13.62,13.5,14.16,12.81,10.22,8.81,10.38,11.88,11.31,11.56,14.59,17.5,17.34,16.53,17.75,19.22,18.22,16.31,15.28,15.91,14.69,11.41,8.97,9.31,9.22,7.78,6.81,9.03,11.84,12.16,12.28,14.56,17.81,18.66,17.72,17.34,18.25,17.47,15.62,15.0,17.84,20.62,21.12,21.19,23.41,25.41,24.38,22.53,22.41,22.84,21.44,18.19,16.5,17.03,17.06,15.91,15.5,17.97,20.34,20.28,19.25,20.34,21.53,19.66,16.34,14.84,15.0,13.78,11.56,10.88,12.62,13.75,12.53,11.66,13.19,14.81,14.66,14.34,16.66,19.97,21.16,20.66,21.47,23.53,23.59,21.84,21.0,22.22,22.84,21.56,20.38,21.69,23.12,21.72,18.97,18.41,18.69,17.81,16.38,17.81,21.66,24.91,25.81,27.25,30.53,32.69,31.75,30.41,31.12,32.12,30.88,29.28,27.75,25.97,23.47,22.31,22.69,23.56,23.25,22.75,23.94,25.16,25.47,24.66,24.09,24.12,23.38,21.44,21.25,22.75,24.66,25.0,25.81:21.66,20.22,20.0,18.0,13.62,10.75,10.28,10.12,8.06,6.47,7.28,9.0,8.62,7.66,9.31,12.72,14.34,14.62,16.44,19.88,22.09,22.0,22.44,24.66,25.75,24.03,21.38,20.62,20.16,17.72,14.56,13.91,15.38,15.97,15.59,16.31,19.06,21.0,20.03,19.72,21.41,23.25,22.5,21.03,21.03,22.16,20.72,17.88,16.59,16.75,15.62,12.44,10.75,11.78,13.09,12.31,12.31,14.59,16.78,15.66,13.59,13.19,14.19,14.03,13.28,14.59,17.78,19.84,19.56,19.09,19.88,20.09,17.91,14.91,14.53,15.12,13.62,11.09,10.44,11.0,10.0,7.0,5.12,4.75,3.5,-0.03,-2.72,-2.53,-1.91,-3.31,-4.81,-4.28,-2.38,-2.94,-4.81,-4.88,-3.44,-3.0,-3.91,-3.47,-1.09,1.0,-0.12,-1.16,-0.16,1.75,1.5,0.97,2.34,3.59,2.34,-0.97,-2.88,-2.75,-2.97,-4.09,-4.06,-1.22,1.19,1.12,0.94,2.66,4.69,4.25,2.84,3.16,4.62,4.59,2.81,1.91,3.03,2.91,0.5,-1.16,-0.41,0.81,-0.47,-1.75,-0.75,1.06,0.66,-0.41,-0.09,2.0,2.5,1.31,0.38,1.84,2.44,0.78,0.22,2.12,4.88,5.38,5.16,6.66,8.78,8.34,6.66,6.03,7.38,7.25,5.16,4.16,5.59,6.5,5.62,4.53,5.41,6.19,4.41,1.66,1.22,2.72,3.19,2.34,2.62,4.56,4.38,1.81,-0.81,-0.88,-0.47,-1.75,-2.66,-0.38,2.53,3.16,2.38,3.06,4.72,4.72,2.91,1.69,2.5,2.44,0.69,-0.81,0.81,3.03,2.5,1.5,2.09,3.34,2.34,-0.03,-0.78,0.34,0.59,-0.56,-0.97,0.88,2.19,0.94,-0.47,0.5,1.78,0.72,-1.16,-0.78,0.88,0.25,-1.62,-2.38,-1.34,-1.81,-3.84,-5.25,-3.75,-2.22,-2.22,-1.91,1.25,5.34,6.62,5.88,6.44,7.56,6.94,4.91,4.19,5.72,6.25,4.59,3.38,4.31,5.41,4.69,3.72,5.38,8.12,8.75,8.38,9.69,12.22,13.16,11.38,10.41,10.38,9.66,6.75,4.12,4.38,5.0,4.09,2.41,3.28,5.28,5.5,4.53,5.0,7.06,7.91,6.66,6.31,7.84,9.03,8.09,6.75,8.06,9.59,9.44,7.84,7.78,9.03,8.44,6.41,5.88,7.25,7.75,6.41,5.81,7.44,9.0,8.34,7.31,8.25,10.06,10.44,9.53,10.22,11.81,11.19,8.03,5.88,6.25,6.22,4.28,2.91,3.97,4.47,2.31,-0.69,-1.38,-1.41,-2.28,-4.66,-4.16,-1.81,-0.62,-1.28,-1.22,1.03,2.56,1.94,1.56,3.22,5.31,4.81,2.56,2.59,3.88,3.78,2.66,3.19,5.59,6.69,5.16,4.34,5.88,7.38,6.19,4.41,4.5,4.28,1.94,-1.59,-3.38,-3.38,-4.09,-6.12,-5.97,-3.72,-1.59,-1.91,-1.84,0.06,1.56,0.0,-1.97,-1.72,-0.47,-0.31,-1.31,-0.59,1.41,1.66,-0.91,-3.0,-2.91,-3.84,-6.81,-9.28,-8.91,-8.0,-8.84,-9.72,-8.28,-5.81,-4.62,-4.81,-3.41,-0.72,0.38,-1.28,-2.16,-1.06,0.22,-0.66,-1.47,-0.19,1.12,0.16,-1.09,-0.5,1.5,2.19,1.09,1.47,3.66,4.88,3.31,2.06,2.78,3.38,1.25,-0.53,-0.03,1.31,0.5,-1.31,-1.09,0.5,0.91,-0.09,-0.22,1.47,2.78,1.41,0.41,1.72,3.66,2.94,1.75,2.38,3.25,1.56,-1.84,-3.53,-4.09,-5.34,-8.06,-9.5,-8.25,-6.88,-7.69,-8.34,-6.62,-4.53,-4.62,-5.16,-3.78,-0.94,-0.19,-1.0,-0.69,1.12,1.84,0.81,0.38,2.25,4.38,3.81,3.38,4.78,6.28,5.09,2.41,1.34,1.72,1.47,0.41,1.25,4.53,7.31,7.59,7.97,9.78,11.16,9.75,7.28,6.91,7.59,6.41,4.5,4.66,6.19,6.81,5.84,5.47,6.91,7.59,5.72,3.41,3.31,3.81,1.59,-0.69,-1.06,-0.31,-1.53,-3.5,-3.59,-2.66,-2.66,-4.25,-5.06,-3.69,-2.34,-3.06,-4.19,-2.88,-0.88,-1.28,-1.78,-0.84,1.56,2.41,1.31,1.75,3.78,5.34,4.5,3.91,5.09,5.69,3.59,1.06,1.03,2.22,2.19,1.25,1.72,3.38,3.03,0.97,-0.16,0.81,1.53,0.34,-0.47,0.5,1.38,-0.06,-2.59,-3.16,-2.28,-3.03,-4.06,-3.25,-0.06,1.59,1.72,2.12,4.0,4.97,3.16,1.0,0.25,-0.03,-2.5,-5.44,-6.47,-5.94,-7.19,-9.41,-10.38,-9.09,-8.31,-9.06,-8.78,-5.84,-2.59,-1.81,-1.5,0.38,2.66,2.53,1.03,0.88,1.91,1.66,0.41,0.34,3.16,4.84,4.53,3.34,3.72,3.56,0.75,-2.34,-2.72,-1.53,-1.34,-1.88,-1.59,-0.03,0.28,-1.31,-2.25,-0.75,-0.03,-1.12,-1.72,-0.56,1.34,1.12,-0.03,0.88,2.84,3.12,1.62,1.47,3.12,3.31,1.06,-0.66,-0.41,-0.78,-2.72,-4.56,-3.78,-1.78,-1.75,-2.62,-1.81,-0.03,0.28,-1.34,-1.5,0.09,1.31,0.34,-0.72,0.5,1.47,0.75,-0.31,0.94,2.91,3.12,1.91,1.94,3.38,3.31,1.5,0.03,0.69,0.94,-1.06,-2.69,-1.66,-0.91,-2.5,-4.72,-5.28,-4.5,-4.75,-5.72,-4.84,-2.09,-0.28,-0.91,-0.69,1.28,2.44,1.16,-0.31,1.09,3.06,3.75,4.03,6.31,9.5,10.88,10.5,10.75,12.69,13.44,11.47,9.25,9.0,8.66,6.44,4.81,5.91,7.75,7.38,5.62,4.94,5.62,5.62,4.53,4.78,7.16,8.16,6.28,4.25,4.53,4.97,4.0,3.09,5.44,8.66,10.28,10.38,11.19,12.06,11.5,8.59,6.75,7.69,9.0,8.44,7.94,9.41,10.88,10.19,8.03,7.81,8.69,8.53,7.0,6.88,8.47,9.72,8.56,8.44,10.5,12.44,12.25,11.25,12.38,13.69,12.84,10.72,10.81,12.31,13.25,12.53,13.38,15.72,16.97,15.84,14.38,15.25,15.72,14.28,12.59,13.72,15.53,15.44,13.94,13.66,14.31,13.16,10.5,8.59,8.59,8.25,5.72,3.16,3.31,3.84,2.84,1.84,3.28,5.62,6.59,6.06,7.03,9.19,10.91,10.91,11.88,15.19,18.09,17.94,16.84,17.31,17.12,14.72,10.97,9.56,9.84,9.09,7.75,7.81,9.34,9.59,7.5,5.5,5.69,6.44,5.41,4.5,6.62,9.84,10.75,9.84,10.38,11.25,10.5,8.16,7.25,8.34,9.44,8.59,8.47,10.41,12.81,12.47,10.81,11.22,12.28,11.38,8.62,7.59,8.41,8.06,5.81,5.09,6.56,8.06,7.09,6.25,7.62,9.03,8.78,7.38,8.44,10.56,11.06,9.97,10.19,11.53,12.25,11.06,10.44,12.09,13.38,11.0,7.5,5.91,5.19,2.84,0.78,1.34,3.81,4.69,3.91,4.12,5.59,6.22,4.66,3.84,5.62,7.75,7.88,7.75,9.62,12.34,12.75,11.38,11.19,11.88,10.59,7.25,5.41,5.56,5.94,4.53,3.47,4.56,5.66,4.62,2.97,3.53,5.53,5.31,4.19,4.81,7.06,8.62,8.06,7.62,8.78,9.03,7.0,5.22,6.03,7.69,7.34,6.28,7.12,9.03,9.38,8.69,9.38,11.69,13.0,11.72,10.81,11.5,11.69,9.66,7.34,7.03,7.72,6.38,4.06,3.56,4.56,4.38,2.5,1.56,2.81,3.19,0.91,-0.56,0.47,2.84,3.75,5.41,9.06,13.31,14.69,13.31,12.66,13.47,13.41,11.56,10.75,12.25,13.03,11.22,9.59,10.28,11.44,10.62,9.09,9.69,11.62,11.72,10.16,9.78,11.22,11.62,9.97,9.75,11.81,13.72,13.38,12.91,14.81,17.44,17.72,17.66,19.19,22.0,23.16,22.0,21.38,21.47,19.78,15.16,11.06,9.53,8.34,5.47,3.53,4.16,6.03,6.38,5.72,7.12,10.78,13.38,15.28,18.28,23.44,26.84,27.25,26.56,27.25,28.09,26.19,24.19,24.22,25.5,24.28,21.53,19.72,19.62,18.75,16.19,14.88,16.47,17.44,16.09,14.72,15.5,16.94,16.03,14.0,13.66,14.0,12.75,10.25,9.5,10.84,11.62,9.97,8.53,9.41,10.62,9.38,8.69,11.03,14.12,14.62,13.62,13.5,14.16,12.81,10.22,8.81,10.38,11.88,11.31,11.56,14.59,17.5,17.34,16.53,17.75,19.22,18.22,16.31,15.28,15.91,14.69,11.41,8.97,9.31,9.22,7.78,6.81,9.03,11.84,12.16,12.28,14.56,17.81,18.66,17.72,17.34,18.25,17.47,15.62,15.0,17.84,20.62,21.12,21.19,23.41,25.41,24.38,22.53,22.41,22.84,21.44,18.19,16.5,17.03,17.06,15.91,15.5,17.97,20.34,20.28,19.25,20.34,21.53,19.66,16.34,14.84,15.0,13.78,11.56,10.88,12.62,13.75,12.53,11.66,13.19,14.81,14.66,14.34,16.66,19.97,21.16,20.66,21.47,23.53,23.59,21.84,21.0,22.22,22.84,21.56,20.38,21.69,23.12,21.72,18.97,18.41,18.69,17.81,16.38,17.81,21.66,24.91,25.81,27.25,30.53,32.69,31.75,30.41,31.12,32.12,30.88,29.28,27.75,25.97,23.47,22.31,22.69,23.56,23.25,22.75,23.94,25.16,25.47,24.66,24.09,24.12,23.38,21.44,21.25,22.75,24.66,25.0,25.81,28.19,30.41,31.28,32.28,34.38,36.81,37.59:10.12,8.06,6.47,7.28,9.0,8.62,7.66,9.31,12.72,14.34,14.62,16.44,19.88,22.09,22.0,22.44,24.66,25.75,24.03,21.38,20.62,20.16,17.72,14.56,13.91,15.38,15.97,15.59,16.31,19.06,21.0,20.03,19.72,21.41,23.25,22.5,21.03,21.03,22.16,20.72,17.88,16.59,16.75,15.62,12.44,10.75,11.78,13.09,12.31,12.31,14.59,16.78,15.66,13.59,13.19,14.19,14.03,13.28,14.59,17.78,19.84,19.56,19.09,19.88,20.09,17.91,14.91,14.53,15.12,13.62,11.09,10.44,11.0,10.0,7.0,5.12,4.75,3.5,-0.03,-2.72,-2.53,-1.91,-3.31,-4.81,-4.28,-2.38,-2.94,-4.81,-4.88,-3.44,-3.0,-3.91,-3.47,-1.09,1.0,-0.12,-1.16,-0.16,1.75,1.5,0.97,2.34,3.59,2.34,-0.97,-2.88,-2.75,-2.97,-4.09,-4.06,-1.22,1.19,1.12,0.94,2.66,4.69,4.25,2.84,3.16,4.62,4.59,2.81,1.91,3.03,2.91,0.5,-1.16,-0.41,0.81,-0.47,-1.75,-0.75,1.06,0.66,-0.41,-0.09,2.0,2.5,1.31,0.38,1.84,2.44,0.78,0.22,2.12,4.88,5.38,5.16,6.66,8.78,8.34,6.66,6.03,7.38,7.25,5.16,4.16,5.59,6.5,5.62,4.53,5.41,6.19,4.41,1.66,1.22,2.72,3.19,2.34,2.62,4.56,4.38,1.81,-0.81,-0.88,-0.47,-1.75,-2.66,-0.38,2.53,3.16,2.38,3.06,4.72,4.72,2.91,1.69,2.5,2.44,0.69,-0.81,0.81,3.03,2.5,1.5,2.09,3.34,2.34,-0.03,-0.78,0.34,0.59,-0.56,-0.97,0.88,2.19,0.94,-0.47,0.5,1.78,0.72,-1.16,-0.78,0.88,0.25,-1.62,-2.38,-1.34,-1.81,-3.84,-5.25,-3.75,-2.22,-2.22,-1.91,1.25,5.34,6.62,5.88,6.44,7.56,6.94,4.91,4.19,5.72,6.25,4.59,3.38,4.31,5.41,4.69,3.72,5.38,8.12,8.75,8.38,9.69,12.22,13.16,11.38,10.41,10.38,9.66,6.75,4.12,4.38,5.0,4.09,2.41,3.28,5.28,5.5,4.53,5.0,7.06,7.91,6.66,6.31,7.84,9.03,8.09,6.75,8.06,9.59,9.44,7.84,7.78,9.03,8.44,6.41,5.88,7.25,7.75,6.41,5.81,7.44,9.0,8.34,7.31,8.25,10.06,10.44,9.53,10.22,11.81,11.19,8.03,5.88,6.25,6.22,4.28,2.91,3.97,4.47,2.31,-0.69,-1.38,-1.41,-2.28,-4.66,-4.16,-1.81,-0.62,-1.28,-1.22,1.03,2.56,1.94,1.56,3.22,5.31,4.81,2.56,2.59,3.88,3.78,2.66,3.19,5.59,6.69,5.16,4.34,5.88,7.38,6.19,4.41,4.5,4.28,1.94,-1.59,-3.38,-3.38,-4.09,-6.12,-5.97,-3.72,-1.59,-1.91,-1.84,0.06,1.56,0.0,-1.97,-1.72,-0.47,-0.31,-1.31,-0.59,1.41,1.66,-0.91,-3.0,-2.91,-3.84,-6.81,-9.28,-8.91,-8.0,-8.84,-9.72,-8.28,-5.81,-4.62,-4.81,-3.41,-0.72,0.38,-1.28,-2.16,-1.06,0.22,-0.66,-1.47,-0.19,1.12,0.16,-1.09,-0.5,1.5,2.19,1.09,1.47,3.66,4.88,3.31,2.06,2.78,3.38,1.25,-0.53,-0.03,1.31,0.5,-1.31,-1.09,0.5,0.91,-0.09,-0.22,1.47,2.78,1.41,0.41,1.72,3.66,2.94,1.75,2.38,3.25,1.56,-1.84,-3.53,-4.09,-5.34,-8.06,-9.5,-8.25,-6.88,-7.69,-8.34,-6.62,-4.53,-4.62,-5.16,-3.78,-0.94,-0.19,-1.0,-0.69,1.12,1.84,0.81,0.38,2.25,4.38,3.81,3.38,4.78,6.28,5.09,2.41,1.34,1.72,1.47,0.41,1.25,4.53,7.31,7.59,7.97,9.78,11.16,9.75,7.28,6.91,7.59,6.41,4.5,4.66,6.19,6.81,5.84,5.47,6.91,7.59,5.72,3.41,3.31,3.81,1.59,-0.69,-1.06,-0.31,-1.53,-3.5,-3.59,-2.66,-2.66,-4.25,-5.06,-3.69,-2.34,-3.06,-4.19,-2.88,-0.88,-1.28,-1.78,-0.84,1.56,2.41,1.31,1.75,3.78,5.34,4.5,3.91,5.09,5.69,3.59,1.06,1.03,2.22,2.19,1.25,1.72,3.38,3.03,0.97,-0.16,0.81,1.53,0.34,-0.47,0.5,1.38,-0.06,-2.59,-3.16,-2.28,-3.03,-4.06,-3.25,-0.06,1.59,1.72,2.12,4.0,4.97,3.16,1.0,0.25,-0.03,-2.5,-5.44,-6.47,-5.94,-7.19,-9.41,-10.38,-9.09,-8.31,-9.06,-8.78,-5.84,-2.59,-1.81,-1.5,0.38,2.66,2.53,1.03,0.88,1.91,1.66,0.41,0.34,3.16,4.84,4.53,3.34,3.72,3.56,0.75,-2.34,-2.72,-1.53,-1.34,-1.88,-1.59,-0.03,0.28,-1.31,-2.25,-0.75,-0.03,-1.12,-1.72,-0.56,1.34,1.12,-0.03,0.88,2.84,3.12,1.62,1.47,3.12,3.31,1.06,-0.66,-0.41,-0.78,-2.72,-4.56,-3.78,-1.78,-1.75,-2.62,-1.81,-0.03,0.28,-1.34,-1.5,0.09,1.31,0.34,-0.72,0.5,1.47,0.75,-0.31,0.94,2.91,3.12,1.91,1.94,3.38,3.31,1.5,0.03,0.69,0.94,-1.06,-2.69,-1.66,-0.91,-2.5,-4.72,-5.28,-4.5,-4.75,-5.72,-4.84,-2.09,-0.28,-0.91,-0.69,1.28,2.44,1.16,-0.31,1.09,3.06,3.75,4.03,6.31,9.5,10.88,10.5,10.75,12.69,13.44,11.47,9.25,9.0,8.66,6.44,4.81,5.91,7.75,7.38,5.62,4.94,5.62,5.62,4.53,4.78,7.16,8.16,6.28,4.25,4.53,4.97,4.0,3.09,5.44,8.66,10.28,10.38,11.19,12.06,11.5,8.59,6.75,7.69,9.0,8.44,7.94,9.41,10.88,10.19,8.03,7.81,8.69,8.53,7.0,6.88,8.47,9.72,8.56,8.44,10.5,12.44,12.25,11.25,12.38,13.69,12.84,10.72,10.81,12.31,13.25,12.53,13.38,15.72,16.97,15.84,14.38,15.25,15.72,14.28,12.59,13.72,15.53,15.44,13.94,13.66,14.31,13.16,10.5,8.59,8.59,8.25,5.72,3.16,3.31,3.84,2.84,1.84,3.28,5.62,6.59,6.06,7.03,9.19,10.91,10.91,11.88,15.19,18.09,17.94,16.84,17.31,17.12,14.72,10.97,9.56,9.84,9.09,7.75,7.81,9.34,9.59,7.5,5.5,5.69,6.44,5.41,4.5,6.62,9.84,10.75,9.84,10.38,11.25,10.5,8.16,7.25,8.34,9.44,8.59,8.47,10.41,12.81,12.47,10.81,11.22,12.28,11.38,8.62,7.59,8.41,8.06,5.81,5.09,6.56,8.06,7.09,6.25,7.62,9.03,8.78,7.38,8.44,10.56,11.06,9.97,10.19,11.53,12.25,11.06,10.44,12.09,13.38,11.0,7.5,5.91,5.19,2.84,0.78,1.34,3.81,4.69,3.91,4.12,5.59,6.22,4.66,3.84,5.62,7.75,7.88,7.75,9.62,12.34,12.75,11.38,11.19,11.88,10.59,7.25,5.41,5.56,5.94,4.53,3.47,4.56,5.66,4.62,2.97,3.53,5.53,5.31,4.19,4.81,7.06,8.62,8.06,7.62,8.78,9.03,7.0,5.22,6.03,7.69,7.34,6.28,7.12,9.03,9.38,8.69,9.38,11.69,13.0,11.72,10.81,11.5,11.69,9.66,7.34,7.03,7.72,6.38,4.06,3.56,4.56,4.38,2.5,1.56,2.81,3.19,0.91,-0.56,0.47,2.84,3.75,5.41,9.06,13.31,14.69,13.31,12.66,13.47,13.41,11.56,10.75,12.25,13.03,11.22,9.59,10.28,11.44,10.62,9.09,9.69,11.62,11.72,10.16,9.78,11.22,11.62,9.97,9.75,11.81,13.72,13.38,12.91,14.81,17.44,17.72,17.66,19.19,22.0,23.16,22.0,21.38,21.47,19.78,15.16,11.06,9.53,8.34,5.47,3.53,4.16,6.03,6.38,5.72,7.12,10.78,13.38,15.28,18.28,23.44,26.84,27.25,26.56,27.25,28.09,26.19,24.19,24.22,25.5,24.28,21.53,19.72,19.62,18.75,16.19,14.88,16.47,17.44,16.09,14.72,15.5,16.94,16.03,14.0,13.66,14.0,12.75,10.25,9.5,10.84,11.62,9.97,8.53,9.41,10.62,9.38,8.69,11.03,14.12,14.62,13.62,13.5,14.16,12.81,10.22,8.81,10.38,11.88,11.31,11.56,14.59,17.5,17.34,16.53,17.75,19.22,18.22,16.31,15.28,15.91,14.69,11.41,8.97,9.31,9.22,7.78,6.81,9.03,11.84,12.16,12.28,14.56,17.81,18.66,17.72,17.34,18.25,17.47,15.62,15.0,17.84,20.62,21.12,21.19,23.41,25.41,24.38,22.53,22.41,22.84,21.44,18.19,16.5,17.03,17.06,15.91,15.5,17.97,20.34,20.28,19.25,20.34,21.53,19.66,16.34,14.84,15.0,13.78,11.56,10.88,12.62,13.75,12.53,11.66,13.19,14.81,14.66,14.34,16.66,19.97,21.16,20.66,21.47,23.53,23.59,21.84,21.0,22.22,22.84,21.56,20.38,21.69,23.12,21.72,18.97,18.41,18.69,17.81,16.38,17.81,21.66,24.91,25.81,27.25,30.53,32.69,31.75,30.41,31.12,32.12,30.88,29.28,27.75,25.97,23.47,22.31,22.69,23.56,23.25,22.75,23.94,25.16,25.47,24.66,24.09,24.12,23.38,21.44,21.25,22.75,24.66,25.0,25.81,28.19,30.41,31.28,32.28,34.38,36.81,37.59,36.62,35.66,34.94,32.91,29.34,26.53,25.25:9.31,12.72,14.34,14.62,16.44,19.88,22.09,22.0,22.44,24.66,25.75,24.03,21.38,20.62,20.16,17.72,14.56,13.91,15.38,15.97,15.59,16.31,19.06,21.0,20.03,19.72,21.41,23.25,22.5,21.03,21.03,22.16,20.72,17.88,16.59,16.75,15.62,12.44,10.75,11.78,13.09,12.31,12.31,14.59,16.78,15.66,13.59,13.19,14.19,14.03,13.28,14.59,17.78,19.84,19.56,19.09,19.88,20.09,17.91,14.91,14.53,15.12,13.62,11.09,10.44,11.0,10.0,7.0,5.12,4.75,3.5,-0.03,-2.72,-2.53,-1.91,-3.31,-4.81,-4.28,-2.38,-2.94,-4.81,-4.88,-3.44,-3.0,-3.91,-3.47,-1.09,1.0,-0.12,-1.16,-0.16,1.75,1.5,0.97,2.34,3.59,2.34,-0.97,-2.88,-2.75,-2.97,-4.09,-4.06,-1.22,1.19,1.12,0.94,2.66,4.69,4.25,2.84,3.16,4.62,4.59,2.81,1.91,3.03,2.91,0.5,-1.16,-0.41,0.81,-0.47,-1.75,-0.75,1.06,0.66,-0.41,-0.09,2.0,2.5,1.31,0.38,1.84,2.44,0.78,0.22,2.12,4.88,5.38,5.16,6.66,8.78,8.34,6.66,6.03,7.38,7.25,5.16,4.16,5.59,6.5,5.62,4.53,5.41,6.19,4.41,1.66,1.22,2.72,3.19,2.34,2.62,4.56,4.38,1.81,-0.81,-0.88,-0.47,-1.75,-2.66,-0.38,2.53,3.16,2.38,3.06,4.72,4.72,2.91,1.69,2.5,2.44,0.69,-0.81,0.81,3.03,2.5,1.5,2.09,3.34,2.34,-0.03,-0.78,0.34,0.59,-0.56,-0.97,0.88,2.19,0.94,-0.47,0.5,1.78,0.72,-1.16,-0.78,0.88,0.25,-1.62,-2.38,-1.34,-1.81,-3.84,-5.25,-3.75,-2.22,-2.22,-1.91,1.25,5.34,6.62,5.88,6.44,7.56,6.94,4.91,4.19,5.72,6.25,4.59,3.38,4.31,5.41,4.69,3.72,5.38,8.12,8.75,8.38,9.69,12.22,13.16,11.38,10.41,10.38,9.66,6.75,4.12,4.38,5.0,4.09,2.41,3.28,5.28,5.5,4.53,5.0,7.06,7.91,6.66,6.31,7.84,9.03,8.09,6.75,8.06,9.59,9.44,7.84,7.78,9.03,8.44,6.41,5.88,7.25,7.75,6.41,5.81,7.44,9.0,8.34,7.31,8.25,10.06,10.44,9.53,10.22,11.81,11.19,8.03,5.88,6.25,6.22,4.28,2.91,3.97,4.47,2.31,-0.69,-1.38,-1.41,-2.28,-4.66,-4.16,-1.81,-0.62,-1.28,-1.22,1.03,2.56,1.94,1.56,3.22,5.31,4.81,2.56,2.59,3.88,3.78,2.66,3.19,5.59,6.69,5.16,4.34,5.88,7.38,6.19,4.41,4.5,4.28,1.94,-1.59,-3.38,-3.38,-4.09,-6.12,-5.97,-3.72,-1.59,-1.91,-1.84,0.06,1.56,0.0,-1.97,-1.72,-0.47,-0.31,-1.31,-0.59,1.41,1.66,-0.91,-3.0,-2.91,-3.84,-6.81,-9.28,-8.91,-8.0,-8.84,-9.72,-8.28,-5.81,-4.62,-4.81,-3.41,-0.72,0.38,-1.28,-2.16,-1.06,0.22,-0.66,-1.47,-0.19,1.12,0.16,-1.09,-0.5,1.5,2.19,1.09,1.47,3.66,4.88,3.31,2.06,2.78,3.38,1.25,-0.53,-0.03,1.31,0.5,-1.31,-1.09,0.5,0.91,-0.09,-0.22,1.47,2.78,1.41,0.41,1.72,3.66,2.94,1.75,2.38,3.25,1.56,-1.84,-3.53,-4.09,-5.34,-8.06,-9.5,-8.25,-6.88,-7.69,-8.34,-6.62,-4.53,-4.62,-5.16,-3.78,-0.94,-0.19,-1.0,-0.69,1.12,1.84,0.81,0.38,2.25,4.38,3.81,3.38,4.78,6.28,5.09,2.41,1.34,1.72,1.47,0.41,1.25,4.53,7.31,7.59,7.97,9.78,11.16,9.75,7.28,6.91,7.59,6.41,4.5,4.66,6.19,6.81,5.84,5.47,6.91,7.59,5.72,3.41,3.31,3.81,1.59,-0.69,-1.06,-0.31,-1.53,-3.5,-3.59,-2.66,-2.66,-4.25,-5.06,-3.69,-2.34,-3.06,-4.19,-2.88,-0.88,-1.28,-1.78,-0.84,1.56,2.41,1.31,1.75,3.78,5.34,4.5,3.91,5.09,5.69,3.59,1.06,1.03,2.22,2.19,1.25,1.72,3.38,3.03,0.97,-0.16,0.81,1.53,0.34,-0.47,0.5,1.38,-0.06,-2.59,-3.16,-2.28,-3.03,-4.06,-3.25,-0.06,1.59,1.72,2.12,4.0,4.97,3.16,1.0,0.25,-0.03,-2.5,-5.44,-6.47,-5.94,-7.19,-9.41,-10.38,-9.09,-8.31,-9.06,-8.78,-5.84,-2.59,-1.81,-1.5,0.38,2.66,2.53,1.03,0.88,1.91,1.66,0.41,0.34,3.16,4.84,4.53,3.34,3.72,3.56,0.75,-2.34,-2.72,-1.53,-1.34,-1.88,-1.59,-0.03,0.28,-1.31,-2.25,-0.75,-0.03,-1.12,-1.72,-0.56,1.34,1.12,-0.03,0.88,2.84,3.12,1.62,1.47,3.12,3.31,1.06,-0.66,-0.41,-0.78,-2.72,-4.56,-3.78,-1.78,-1.75,-2.62,-1.81,-0.03,0.28,-1.34,-1.5,0.09,1.31,0.34,-0.72,0.5,1.47,0.75,-0.31,0.94,2.91,3.12,1.91,1.94,3.38,3.31,1.5,0.03,0.69,0.94,-1.06,-2.69,-1.66,-0.91,-2.5,-4.72,-5.28,-4.5,-4.75,-5.72,-4.84,-2.09,-0.28,-0.91,-0.69,1.28,2.44,1.16,-0.31,1.09,3.06,3.75,4.03,6.31,9.5,10.88,10.5,10.75,12.69,13.44,11.47,9.25,9.0,8.66,6.44,4.81,5.91,7.75,7.38,5.62,4.94,5.62,5.62,4.53,4.78,7.16,8.16,6.28,4.25,4.53,4.97,4.0,3.09,5.44,8.66,10.28,10.38,11.19,12.06,11.5,8.59,6.75,7.69,9.0,8.44,7.94,9.41,10.88,10.19,8.03,7.81,8.69,8.53,7.0,6.88,8.47,9.72,8.56,8.44,10.5,12.44,12.25,11.25,12.38,13.69,12.84,10.72,10.81,12.31,13.25,12.53,13.38,15.72,16.97,15.84,14.38,15.25,15.72,14.28,12.59,13.72,15.53,15.44,13.94,13.66,14.31,13.16,10.5,8.59,8.59,8.25,5.72,3.16,3.31,3.84,2.84,1.84,3.28,5.62,6.59,6.06,7.03,9.19,10.91,10.91,11.88,15.19,18.09,17.94,16.84,17.31,17.12,14.72,10.97,9.56,9.84,9.09,7.75,7.81,9.34,9.59,7.5,5.5,5.69,6.44,5.41,4.5,6.62,9.84,10.75,9.84,10.38,11.25,10.5,8.16,7.25,8.34,9.44,8.59,8.47,10.41,12.81,12.47,10.81,11.22,12.28,11.38,8.62,7.59,8.41,8.06,5.81,5.09,6.56,8.06,7.09,6.25,7.62,9.03,8.78,7.38,8.44,10.56,11.06,9.97,10.19,11.53,12.25,11.06,10.44,12.09,13.38,11.0,7.5,5.91,5.19,2.84,0.78,1.34,3.81,4.69,3.91,4.12,5.59,6.22,4.66,3.84,5.62,7.75,7.88,7.75,9.62,12.34,12.75,11.38,11.19,11.88,10.59,7.25,5.41,5.56,5.94,4.53,3.47,4.56,5.66,4.62,2.97,3.53,5.53,5.31,4.19,4.81,7.06,8.62,8.06,7.62,8.78,9.03,7.0,5.22,6.03,7.69,7.34,6.28,7.12,9.03,9.38,8.69,9.38,11.69,13.0,11.72,10.81,11.5,11.69,9.66,7.34,7.03,7.72,6.38,4.06,3.56,4.56,4.38,2.5,1.56,2.81,3.19,0.91,-0.56,0.47,2.84,3.75,5.41,9.06,13.31,14.69,13.31,12.66,13.47,13.41,11.56,10.75,12.25,13.03,11.22,9.59,10.28,11.44,10.62,9.09,9.69,11.62,11.72,10.16,9.78,11.22,11.62,9.97,9.75,11.81,13.72,13.38,12.91,14.81,17.44,17.72,17.66,19.19,22.0,23.16,22.0,21.38,21.47,19.78,15.16,11.06,9.53,8.34,5.47,3.53,4.16,6.03,6.38,5.72,7.12,10.78,13.38,15.28,18.28,23.44,26.84,27.25,26.56,27.25,28.09,26.19,24.19,24.22,25.5,24.28,21.53,19.72,19.62,18.75,16.19,14.88,16.47,17.44,16.09,14.72,15.5,16.94,16.03,14.0,13.66,14.0,12.75,10.25,9.5,10.84,11.62,9.97,8.53,9.41,10.62,9.38,8.69,11.03,14.12,14.62,13.62,13.5,14.16,12.81,10.22,8.81,10.38,11.88,11.31,11.56,14.59,17.5,17.34,16.53,17.75,19.22,18.22,16.31,15.28,15.91,14.69,11.41,8.97,9.31,9.22,7.78,6.81,9.03,11.84,12.16,12.28,14.56,17.81,18.66,17.72,17.34,18.25,17.47,15.62,15.0,17.84,20.62,21.12,21.19,23.41,25.41,24.38,22.53,22.41,22.84,21.44,18.19,16.5,17.03,17.06,15.91,15.5,17.97,20.34,20.28,19.25,20.34,21.53,19.66,16.34,14.84,15.0,13.78,11.56,10.88,12.62,13.75,12.53,11.66,13.19,14.81,14.66,14.34,16.66,19.97,21.16,20.66,21.47,23.53,23.59,21.84,21.0,22.22,22.84,21.56,20.38,21.69,23.12,21.72,18.97,18.41,18.69,17.81,16.38,17.81,21.66,24.91,25.81,27.25,30.53,32.69,31.75,30.41,31.12,32.12,30.88,29.28,27.75,25.97,23.47,22.31,22.69,23.56,23.25,22.75,23.94,25.16,25.47,24.66,24.09,24.12,23.38,21.44,21.25,22.75,24.66,25.0,25.81,28.19,30.41,31.28,32.28,34.38,36.81,37.59,36.62,35.66,34.94,32.91,29.34,26.53,25.25,24.38,22.53,21.47,22.0,23.69,24.06,24.41:negativity
-6.44,-6.97,-6.06,-4.88,-3.94,-2.69,-0.5,0.81,0.62,-0.06,-0.38,-0.34,-0.59,-0.56,0.75,3.09,5.69,7.0,8.66,10.75,12.31,13.09,14.19,16.41,18.41,18.91,18.25,17.34,15.69,13.0,9.09,5.75,3.69,2.16,0.72,0.88,2.94,5.62,7.66,9.56,12.5,14.62,15.47,15.59,16.22,17.38,17.84,17.66,18.31,19.5,20.41,19.84,19.44,20.03,20.5,20.56,21.19,22.88,24.66,24.91,24.31,24.06,23.59,22.56,20.88,19.81,19.09,18.19,16.59,15.5,15.44,15.84,15.91,16.47,18.53,21.53,23.75,25.84,28.16,30.31,31.38,31.28,31.16,31.66,32.06,31.28,30.56,30.41,30.12,28.94,27.03,25.88,24.81,23.34,21.41,19.88,19.59,19.06,17.31,15.75,14.69,13.25,11.16,9.31,8.66,8.78,8.28,7.25,6.5,5.56,3.34,0.28,-2.31,-3.31,-3.97,-4.5,-4.19,-2.84,-1.31,-0.22,0.53,2.06,4.62,6.94,8.69,11.47,14.69,17.19,18.22,18.69,18.91,18.16,15.94,13.56,11.94,10.38,8.12,5.53,3.41,2.12,0.53,-0.34,0.47,2.72,5.62,8.34,12.06,16.94,21.44,24.81,27.69,29.91,31.72,31.97,31.53,31.47,31.66,30.88,29.38,27.84,26.66,25.19,22.94,20.72,20.19,19.81,18.78,18.19,18.34,18.31,17.16,15.88,14.81,14.97,14.81,14.47,15.06,16.44,17.5,17.22,16.84,16.38,15.75,14.03,12.66,12.22,12.34,11.91,11.41,10.81,10.72,10.28,9.12,8.97,9.31,10.22,10.56,11.5,13.31,15.84,17.94,20.12,22.28,24.44,25.03,25.06,24.66,24.88,24.41,22.97,21.41,20.56,19.81,18.81,18.25,19.0,19.84,19.56,18.16,16.78,15.81,13.97,12.34,10.91,10.41,9.84,8.88,8.66,9.59,11.12,11.94,12.78,14.47,16.25,17.97,19.19,20.59,22.69,23.62,23.31,22.91,22.31,21.28,19.5,17.69,16.19,15.16,13.66,11.97,11.31,11.59,12.31,12.75,13.78,15.56,17.06,17.38,17.06,17.94,17.81,16.81,16.12,16.22,16.78,16.91,16.66,16.88,17.03,16.5,14.78,13.0,11.81,10.56,8.38,6.59,6.38,6.28,5.53,5.09,5.62,6.88,7.34,7.72,8.69,10.41,11.44,12.25,13.38,15.56,17.62,18.72,19.22,19.56,19.03,17.53,14.94,13.5,13.09,12.94,12.59,13.0,13.78,14.22,13.44,12.34,11.84,11.31,10.03,9.09,9.69,10.66,11.69,12.16,13.16,14.5,15.44,15.44,15.62,16.66,16.97,16.34,15.59,15.28,14.66,13.75,12.88,12.88,13.34,13.38,12.41,11.62,11.62,10.91,9.66,9.16,9.69,10.41,10.28,10.31,10.84,11.66,11.91,12.09,13.59,15.91,17.69,18.91,20.03,21.31,21.19,19.72,17.91,16.56,15.25,12.91,10.44,9.22,8.66,7.94,7.22,8.19,9.72,10.78,11.06,11.75,12.56,13.0,13.0,13.41,14.94,17.16,18.59,19.19,19.97,20.19,19.25,17.44,16.06,14.94,14.16,12.44,11.47,11.66,11.78,11.44,11.0,12.12,13.53,14.66,14.84,15.62,16.25,15.88,14.88,14.66,14.88,15.03,14.84,14.53,15.88,17.59,18.5,18.91,20.09,20.75,20.16,18.84,18.22,18.12,18.16,18.31,19.84,21.69,23.88,24.59,24.75,24.59,23.97,22.56,20.62,20.03,20.53,21.0,21.53,22.38,23.5,23.94,23.16,22.59,22.03,21.59,20.06,18.41,17.66,17.31,16.66,16.06,16.66,17.56,17.75,17.09,16.44,15.97,15.59,14.59,14.16,14.47,15.03,14.25,13.5,13.5,13.84,13.69,13.59,14.5,16.28,17.22,17.75,18.19,18.75,19.12,18.62,18.22,18.0,17.88,16.03,13.5,11.09,8.88,6.75,4.62,4.03,4.66,6.0,7.03,8.06,9.97,11.09,11.12,10.72,10.75,12.03,13.22,14.38,16.44,18.31,19.0,18.03,16.84,15.91,15.12,13.56,12.69,13.0,12.88,11.56,10.5,10.06,10.19,10.44,11.28,13.28,16.38,19.34,21.81,24.34,27.19,28.88,29.06,28.78,28.56,28.12,26.66,25.0,23.41,22.16,19.78,17.53,15.88,15.56,15.56,15.25,15.5,16.25,17.31,17.47,18.31,20.31,23.25,25.44,27.5,30.22,33.16,34.88,35.69,36.06,35.91,34.75,31.97,29.25,27.09,25.31,22.75,20.34,19.34,18.88,17.94,17.5,17.84,19.0,18.97,18.34,18.28,18.47,18.97,19.22,20.19,21.66,23.0,22.81,21.97,21.03,19.72,17.56,14.78,12.44,11.62,10.78,10.03,9.66,11.16,12.62,13.66,16.19,20.53,26.03,31.47,36.88,42.19,46.09,47.19,46.12,43.66,41.28,37.94,34.44,31.5,29.62,27.66,24.78,22.12,20.16,18.59,16.47,14.88,14.28,14.62,15.62,17.16,19.91,23.72,26.75,28.34,28.84,29.72,30.25,29.56,28.66,28.09,27.0,24.12,20.69,17.72,15.69,13.97,13.0,12.97,14.31,15.0,15.16,14.44,14.59,14.62,13.97,13.97,15.25,17.66,19.91,22.22,24.62,27.94,30.12,31.16,32.03,33.88,34.84,34.47,33.97,33.56,32.69,30.75,28.5,27.22,26.62,25.34,23.75,22.69,22.31,21.06,19.19,17.34,16.81,15.84,14.41,12.94,13.22,14.0,15.09,16.47,18.97,21.88,24.53,25.97,27.03,28.75,30.03,30.31,30.53,31.97,33.03,33.22,32.22,31.91,31.72,30.28,28.41,27.22,27.16,26.53,25.84,25.25,25.59,25.62,24.62,23.53,23.72,24.75,24.88,25.38,27.0,28.12,27.97,26.31,24.25,21.78,18.56,14.78,11.41,9.69,8.66,7.62,7.38,8.28,9.81,10.41,11.41,12.97,15.25,16.81,17.88,19.16,21.0,22.28,22.41,22.12,22.81,23.09,22.41,21.03,19.97,18.69,16.38,13.91,12.81,12.81,12.84,12.59,13.12,15.16,16.97,18.56,20.31,22.78,24.88,25.59,24.88,24.5,23.72,22.53,20.62,20.09,20.84,21.72,22.12,22.94,24.34,24.62,23.25,21.25,20.22,19.31,18.12,16.94,17.0,16.81,16.12,14.66,13.66,13.53,13.59,13.12,13.75,14.84,15.88,15.84,15.12,15.47,16.28,17.03,17.97,19.69,21.97,23.41,23.56,23.44,23.75,23.72,22.78,22.22,23.06,23.62,22.97,21.62,20.44,19.06,17.53,15.41,14.56,15.03,15.59,16.06,17.44,19.97,22.75,24.22,25.53,27.56,28.66,28.44,27.78,27.56,28.06,28.44,28.59,29.09,29.66,29.12,27.16,25.06,23.44,21.75,19.44,17.25,16.69,16.75,16.06,15.66,16.25,17.0,17.72,18.44,19.78,22.09,24.34,25.62,26.53,27.69,27.97,26.59,24.88,24.16,23.47,22.22,20.12,18.59,17.38,16.16,14.28,13.31,13.09,12.94,12.09,11.25,11.47,12.0,11.62,10.91,10.97,11.28,11.41,11.22,11.97,13.72,15.09,15.69,16.53,17.84,19.25,19.12,18.66,18.22,17.78,16.31,14.5,13.97,14.78,15.75,16.75,18.69,20.94,22.41,21.88,20.78,19.81,18.69,16.78,15.62,15.41,15.88,15.75,14.91,13.81,12.78,11.28,9.12,8.25,8.03,8.19,7.22,6.22,6.28,6.69,6.25,6.0,6.66,7.06,6.78,6.25,6.56,7.22,7.88,7.56,7.69,8.69,10.0,11.0,12.19,14.12,15.38,15.03,13.59,12.12,11.22,10.16,9.09,8.59,8.88,9.19,8.22,7.62,7.53,7.59,6.12,4.78,4.5,5.03,5.03,5.0,5.12,5.38,4.44,2.84,1.41,0.81,0.53,-0.03,-0.19,0.34,2.0,2.84,3.59,5.22,7.28,8.97,10.0,12.03,14.22,15.75,16.16,16.78,17.5,17.66,16.47,14.84,13.81,13.22,12.12,11.5,12.19,13.69,15.12,15.84,16.94,18.06,18.66,18.06,17.06,17.31,17.56,17.44,17.44,18.12,19.41,19.94,20.12,21.22,22.75,24.0,24.12,24.44,25.06,25.09,24.22,23.09,22.62,22.22,20.84,19.38,18.69,18.53,17.94,17.28,17.44,18.69,19.47,19.91,20.94,22.69,24.81,26.16,27.66,29.47,31.09,31.81,31.91,31.81,32.03,31.03,29.59,27.59,26.25,24.75,22.97,21.97,22.5,23.53,24.78,25.94,27.88,29.62,30.16,29.59,29.31,29.12,28.91,28.72,29.31,31.44,33.44,34.12,34.31,34.62,33.75,31.53,28.78,26.62,24.94,22.88,21.03,19.88,19.75,18.66,17.84,16.88,17.16,16.97,16.09,15.09,14.75,14.69,14.28,14.56,15.91,17.94,19.5,20.69,21.66,22.59,23.0,23.53,24.12,25.84,27.78,28.97,29.84,30.84,31.88,31.59,30.62,30.12,29.34,28.66,27.84,28.06,29.53,30.56,30.59,30.09,30.03,29.12,27.47,25.69,24.94,24.34,23.78,23.12,23.06,23.91,24.47,24.22,24.53,25.78,26.75,27.28,27.41,28.28,29.16,28.59,27.78,27.41,27.22,26.56,25.28,24.81,24.94,25.12,24.91,25.06,26.19,27.06,26.53,25.38,24.94,24.41,23.88,23.34,23.56,24.12,24.19,23.53,23.41,24.28,25.22,25.69,26.19,27.12,27.53,27.22,25.78,25.34,24.44,23.06,21.41,20.31,20.12,19.69,18.84,17.88,17.44,16.84,15.56,14.59,15.12,15.75,15.72,15.5,16.09,17.5,18.53,19.88,21.47,23.41:0.81,0.62,-0.06,-0.38,-0.34,-0.59,-0.56,0.75,3.09,5.69,7.0,8.66,10.75,12.31,13.09,14.19,16.41,18.41,18.91,18.25,17.34,15.69,13.0,9.09,5.75,3.69,2.16,0.72,0.88,2.94,5.62,7.66,9.56,12.5,14.62,15.47,15.59,16.22,17.38,17.84,17.66,18.31,19.5,20.41,19.84,19.44,20.03,20.5,20.56,21.19,22.88,24.66,24.91,24.31,24.06,23.59,22.56,20.88,19.81,19.09,18.19,16.59,15.5,15.44,15.84,15.91,16.47,18.53,21.53,23.75,25.84,28.16,30.31,31.38,31.28,31.16,31.66,32.06,31.28,30.56,30.41,30.12,28.94,27.03,25.88,24.81,23.34,21.41,19.88,19.59,19.06,17.31,15.75,14.69,13.25,11.16,9.31,8.66,8.78,8.28,7.25,6.5,5.56,3.34,0.28,-2.31,-3.31,-3.97,-4.5,-4.19,-2.84,-1.31,-0.22,0.53,2.06,4.62,6.94,8.69,11.47,14.69,17.19,18.22,18.69,18.91,18.16,15.94,13.56,11.94,10.38,8.12,5.53,3.41,2.12,0.53,-0.34,0.47,2.72,5.62,8.34,12.06,16.94,21.44,24.81,27.69,29.91,31.72,31.97,31.53,31.47,31.66,30.88,29.38,27.84,26.66,25.19,22.94,20.72,20.19,19.81,18.78,18.19,18.34,18.31,17.16,15.88,14.81,14.97,14.81,14.47,15.06,16.44,17.5,17.22,16.84,16.38,15.75,14.03,12.66,12.22,12.34,11.91,11.41,10.81,10.72,10.28,9.12,8.97,9.31,10.22,10.56,11.5,13.31,15.84,17.94,20.12,22.28,24.44,25.03,25.06,24.66,24.88,24.41,22.97,21.41,20.56,19.81,18.81,18.25,19.0,19.84,19.56,18.16,16.78,15.81,13.97,12.34,10.91,10.41,9.84,8.88,8.66,9.59,11.12,11.94,12.78,14.47,16.25,17.97,19.19,20.59,22.69,23.62,23.31,22.91,22.31,21.28,19.5,17.69,16.19,15.16,13.66,11.97,11.31,11.59,12.31,12.75,13.78,15.56,17.06,17.38,17.06,17.94,17.81,16.81,16.12,16.22,16.78,16.91,16.66,16.88,17.03,16.5,14.78,13.0,11.81,10.56,8.38,6.59,6.38,6.28,5.53,5.09,5.62,6.88,7.34,7.72,8.69,10.41,11.44,12.25,13.38,15.56,17.62,18.72,19.22,19.56,19.03,17.53,14.94,13.5,13.09,12.94,12.59,13.0,13.78,14.22,13.44,12.34,11.84,11.31,10.03,9.09,9.69,10.66,11.69,12.16,13.16,14.5,15.44,15.44,15.62,16.66,16.97,16.34,15.59,15.28,14.66,13.75,12.88,12.88,13.34,13.38,12.41,11.62,11.62,10.91,9.66,9.16,9.69,10.41,10.28,10.31,10.84,11.66,11.91,12.09,13.59,15.91,17.69,18.91,20.03,21.31,21.19,19.72,17.91,16.56,15.25,12.91,10.44,9.22,8.66,7.94,7.22,8.19,9.72,10.78,11.06,11.75,12.56,13.0,13.0,13.41,14.94,17.16,18.59,19.19,19.97,20.19,19.25,17.44,16.06,14.94,14.16,12.44,11.47,11.66,11.78,11.44,11.0,12.12,13.53,14.66,14.84,15.62,16.25,15.88,14.88,14.66,14.88,15.03,14.84,14.53,15.88,17.59,18.5,18.91,20.09,20.75,20.16,18.84,18.22,18.12,18.16,18.31,19.84,21.69,23.88,24.59,24.75,24.59,23.97,22.56,20.62,20.03,20.53,21.0,21.53,22.38,23.5,23.94,23.16,22.59,22.03,21.59,20.06,18.41,17.66,17.31,16.66,16.06,16.66,17.56,17.75,17.09,16.44,15.97,15.59,14.59,14.16,14.47,15.03,14.25,13.5,13.5,13.84,13.69,13.59,14.5,16.28,17.22,17.75,18.19,18.75,19.12,18.62,18.22,18.0,17.88,16.03,13.5,11.09,8.88,6.75,4.62,4.03,4.66,6.0,7.03,8.06,9.97,11.09,11.12,10.72,10.75,12.03,13.22,14.38,16.44,18.31,19.0,18.03,16.84,15.91,15.12,13.56,12.69,13.0,12.88,11.56,10.5,10.06,10.19,10.44,11.28,13.28,16.38,19.34,21.81,24.34,27.19,28.88,29.06,28.78,28.56,28.12,26.66,25.0,23.41,22.16,19.78,17.53,15.88,15.56,15.56,15.25,15.5,16.25,17.31,17.47,18.31,20.31,23.25,25.44,27.5,30.22,33.16,34.88,35.69,36.06,35.91,34.75,31.97,29.25,27.09,25.31,22.75,20.34,19.34,18.88,17.94,17.5,17.84,19.0,18.97,18.34,18.28,18.47,18.97,19.22,20.19,21.66,23.0,22.81,21.97,21.03,19.72,17.56,14.78,12.44,11.62,10.78,10.03,9.66,11.16,12.62,13.66,16.19,20.53,26.03,31.47,36.88,42.19,46.09,47.19,46.12,43.66,41.28,37.94,34.44,31.5,29.62,27.66,24.78,22.12,20.16,18.59,16.47,14.88,14.28,14.62,15.62,17.16,19.91,23.72,26.75,28.34,28.84,29.72,30.25,29.56,28.66,28.09,27.0,24.12,20.69,17.72,15.69,13.97,13.0,12.97,14.31,15.0,15.16,14.44,14.59,14.62,13.97,13.97,15.25,17.66,19.91,22.22,24.62,27.94,30.12,31.16,32.03,33.88,34.84,34.47,33.97,33.56,32.69,30.75,28.5,27.22,26.62,25.34,23.75,22.69,22.31,21.06,19.19,17.34,16.81,15.84,14.41,12.94,13.22,14.0,15.09,16.47,18.97,21.88,24.53,25.97,27.03,28.75,30.03,30.31,30.53,31.97,33.03,33.22,32.22,31.91,31.72,30.28,28.41,27.22,27.16,26.53,25.84,25.25,25.59,25.62,24.62,23.53,23.72,24.75,24.88,25.38,27.0,28.12,27.97,26.31,24.25,21.78,18.56,14.78,11.41,9.69,8.66,7.62,7.38,8.28,9.81,10.41,11.41,12.97,15.25,16.81,17.88,19.16,21.0,22.28,22.41,22.12,22.81,23.09,22.41,21.03,19.97,18.69,16.38,13.91,12.81,12.81,12.84,12.59,13.12,15.16,16.97,18.56,20.31,22.78,24.88,25.59,24.88,24.5,23.72,22.53,20.62,20.09,20.84,21.72,22.12,22.94,24.34,24.62,23.25,21.25,20.22,19.31,18.12,16.94,17.0,16.81,16.12,14.66,13.66,13.53,13.59,13.12,13.75,14.84,15.88,15.84,15.12,15.47,16.28,17.03,17.97,19.69,21.97,23.41,23.56,23.44,23.75,23.72,22.78,22.22,23.06,23.62,22.97,21.62,20.44,19.06,17.53,15.41,14.56,15.03,15.59,16.06,17.44,19.97,22.75,24.22,25.53,27.56,28.66,28.44,27.78,27.56,28.06,28.44,28.59,29.09,29.66,29.12,27.16,25.06,23.44,21.75,19.44,17.25,16.69,16.75,16.06,15.66,16.25,17.0,17.72,18.44,19.78,22.09,24.34,25.62,26.53,27.69,27.97,26.59,24.88,24.16,23.47,22.22,20.12,18.59,17.38,16.16,14.28,13.31,13.09,12.94,12.09,11.25,11.47,12.0,11.62,10.91,10.97,11.28,11.41,11.22,11.97,13.72,15.09,15.69,16.53,17.84,19.25,19.12,18.66,18.22,17.78,16.31,14.5,13.97,14.78,15.75,16.75,18.69,20.94,22.41,21.88,20.78,19.81,18.69,16.78,15.62,15.41,15.88,15.75,14.91,13.81,12.78,11.28,9.12,8.25,8.03,8.19,7.22,6.22,6.28,6.69,6.25,6.0,6.66,7.06,6.78,6.25,6.56,7.22,7.88,7.56,7.69,8.69,10.0,11.0,12.19,14.12,15.38,15.03,13.59,12.12,11.22,10.16,9.09,8.59,8.88,9.19,8.22,7.62,7.53,7.59,6.12,4.78,4.5,5.03,5.03,5.0,5.12,5.38,4.44,2.84,1.41,0.81,0.53,-0.03,-0.19,0.34,2.0,2.84,3.59,5.22,7.28,8.97,10.0,12.03,14.22,15.75,16.16,16.78,17.5,17.66,16.47,14.84,13.81,13.22,12.12,11.5,12.19,13.69,15.12,15.84,16.94,18.06,18.66,18.06,17.06,17.31,17.56,17.44,17.44,18.12,19.41,19.94,20.12,21.22,22.75,24.0,24.12,24.44,25.06,25.09,24.22,23.09,22.62,22.22,20.84,19.38,18.69,18.53,17.94,17.28,17.44,18.69,19.47,19.91,20.94,22.69,24.81,26.16,27.66,29.47,31.09,31.81,31.91,31.81,32.03,31.03,29.59,27.59,26.25,24.75,22.97,21.97,22.5,23.53,24.78,25.94,27.88,29.62,30.16,29.59,29.31,29.12,28.91,28.72,29.31,31.44,33.44,34.12,34.31,34.62,33.75,31.53,28.78,26.62,24.94,22.88,21.03,19.88,19.75,18.66,17.84,16.88,17.16,16.97,16.09,15.09,14.75,14.69,14.28,14.56,15.91,17.94,19.5,20.69,21.66,22.59,23.0,23.53,24.12,25.84,27.78,28.97,29.84,30.84,31.88,31.59,30.62,30.12,29.34,28.66,27.84,28.06,29.53,30.56,30.59,30.09,30.03,29.12,27.47,25.69,24.94,24.34,23.78,23.12,23.06,23.91,24.47,24.22,24.53,25.78,26.75,27.28,27.41,28.28,29.16,28.59,27.78,27.41,27.22,26.56,25.28,24.81,24.94,25.12,24.91,25.06,26.19,27.06,26.53,25.38,24.94,24.41,23.88,23.34,23.56,24.12,24.19,23.53,23.41,24.28,25.22,25.69,26.19,27.12,27.53,27.22,25.78,25.34,24.44,23.06,21.41,20.31,20.12,19.69,18.84,17.88,17.44,16.84,15.56,14.59,15.12,15.75,15.72,15.5,16.09,17.5,18.53,19.88,21.47,23.41,27.16,28.81,31.69,35.72,39.84,43.34,46.22:0.75,3.09,5.69,7.0,8.66,10.75,12.31,13.09,14.19,16.41,18.41,18.91,18.25,17.34,15.69,13.0,9.09,5.75,3.69,2.16,0.72,0.88,2.94,5.62,7.66,9.56,12.5,14.62,15.47,15.59,16.22,17.38,17.84,17.66,18.31,19.5,20.41,19.84,19.44,20.03,20.5,20.56,21.19,22.88,24.66,24.91,24.31,24.06,23.59,22.56,20.88,19.81,19.09,18.19,16.59,15.5,15.44,15.84,15.91,16.47,18.53,21.53,23.75,25.84,28.16,30.31,31.38,31.28,31.16,31.66,32.06,31.28,30.56,30.41,30.12,28.94,27.03,25.88,24.81,23.34,21.41,19.88,19.59,19.06,17.31,15.75,14.69,13.25,11.16,9.31,8.66,8.78,8.28,7.25,6.5,5.56,3.34,0.28,-2.31,-3.31,-3.97,-4.5,-4.19,-2.84,-1.31,-0.22,0.53,2.06,4.62,6.94,8.69,11.47,14.69,17.19,18.22,18.69,18.91,18.16,15.94,13.56,11.94,10.38,8.12,5.53,3.41,2.12,0.53,-0.34,0.47,2.72,5.62,8.34,12.06,16.94,21.44,24.81,27.69,29.91,31.72,31.97,31.53,31.47,31.66,30.88,29.38,27.84,26.66,25.19,22.94,20.72,20.19,19.81,18.78,18.19,18.34,18.31,17.16,15.88,14.81,14.97,14.81,14.47,15.06,16.44,17.5,17.22,16.84,16.38,15.75,14.03,12.66,12.22,12.34,11.91,11.41,10.81,10.72,10.28,9.12,8.97,9.31,10.22,10.56,11.5,13.31,15.84,17.94,20.12,22.28,24.44,25.03,25.06,24.66,24.88,24.41,22.97,21.41,20.56,19.81,18.81,18.25,19.0,19.84,19.56,18.16,16.78,15.81,13.97,12.34,10.91,10.41,9.84,8.88,8.66,9.59,11.12,11.94,12.78,14.47,16.25,17.97,19.19,20.59,22.69,23.62,23.31,22.91,22.31,21.28,19.5,17.69,16.19,15.16,13.66,11.97,11.31,11.59,12.31,12.75,13.78,15.56,17.06,17.38,17.06,17.94,17.81,16.81,16.12,16.22,16.78,16.91,16.66,16.88,17.03,16.5,14.78,13.0,11.81,10.56,8.38,6.59,6.38,6.28,5.53,5.09,5.62,6.88,7.34,7.72,8.69,10.41,11.44,12.25,13.38,15.56,17.62,18.72,19.22,19.56,19.03,17.53,14.94,13.5,13.09,12.94,12.59,13.0,13.78,14.22,13.44,12.34,11.84,11.31,10.03,9.09,9.69,10.66,11.69,12.16,13.16,14.5,15.44,15.44,15.62,16.66,16.97,16.34,15.59,15.28,14.66,13.75,12.88,12.88,13.34,13.38,12.41,11.62,11.62,10.91,9.66,9.16,9.69,10.41,10.28,10.31,10.84,11.66,11.91,12.09,13.59,15.91,17.69,18.91,20.03,21.31,21.19,19.72,17.91,16.56,15.25,12.91,10.44,9.22,8.66,7.94,7.22,8.19,9.72,10.78,11.06,11.75,12.56,13.0,13.0,13.41,14.94,17.16,18.59,19.19,19.97,20.19,19.25,17.44,16.06,14.94,14.16,12.44,11.47,11.66,11.78,11.44,11.0,12.12,13.53,14.66,14.84,15.62,16.25,15.88,14.88,14.66,14.88,15.03,14.84,14.53,15.88,17.59,18.5,18.91,20.09,20.75,20.16,18.84,18.22,18.12,18.16,18.31,19.84,21.69,23.88,24.59,24.75,24.59,23.97,22.56,20.62,20.03,20.53,21.0,21.53,22.38,23.5,23.94,23.16,22.59,22.03,21.59,20.06,18.41,17.66,17.31,16.66,16.06,16.66,17.56,17.75,17.09,16.44,15.97,15.59,14.59,14.16,14.47,15.03,14.25,13.5,13.5,13.84,13.69,13.59,14.5,16.28,17.22,17.75,18.19,18.75,19.12,18.62,18.22,18.0,17.88,16.03,13.5,11.09,8.88,6.75,4.62,4.03,4.66,6.0,7.03,8.06,9.97,11.09,11.12,10.72,10.75,12.03,13.22,14.38,16.44,18.31,19.0,18.03,16.84,15.91,15.12,13.56,12.69,13.0,12.88,11.56,10.5,10.06,10.19,10.44,11.28,13.28,16.38,19.34,21.81,24.34,27.19,28.88,29.06,28.78,28.56,28.12,26.66,25.0,23.41,22.16,19.78,17.53,15.88,15.56,15.56,15.25,15.5,16.25,17.31,17.47,18.31,20.31,23.25,25.44,27.5,30.22,33.16,34.88,35.69,36.06,35.91,34.75,31.97,29.25,27.09,25.31,22.75,20.34,19.34,18.88,17.94,17.5,17.84,19.0,18.97,18.34,18.28,18.47,18.97,19.22,20.19,21.66,23.0,22.81,21.97,21.03,19.72,17.56,14.78,12.44,11.62,10.78,10.03,9.66,11.16,12.62,13.66,16.19,20.53,26.03,31.47,36.88,42.19,46.09,47.19,46.12,43.66,41.28,37.94,34.44,31.5,29.62,27.66,24.78,22.12,20.16,18.59,16.47,14.88,14.28,14.62,15.62,17.16,19.91,23.72,26.75,28.34,28.84,29.72,30.25,29.56,28.66,28.09,27.0,24.12,20.69,17.72,15.69,13.97,13.0,12.97,14.31,15.0,15.16,14.44,14.59,14.62,13.97,13.97,15.25,17.66,19.91,22.22,24.62,27.94,30.12,31.16,32.03,33.88,34.84,34.47,33.97,33.56,32.69,30.75,28.5,27.22,26.62,25.34,23.75,22.69,22.31,21.06,19.19,17.34,16.81,15.84,14.41,12.94,13.22,14.0,15.09,16.47,18.97,21.88,24.53,25.97,27.03,28.75,30.03,30.31,30.53,31.97,33.03,33.22,32.22,31.91,31.72,30.28,28.41,27.22,27.16,26.53,25.84,25.25,25.59,25.62,24.62,23.53,23.72,24.75,24.88,25.38,27.0,28.12,27.97,26.31,24.25,21.78,18.56,14.78,11.41,9.69,8.66,7.62,7.38,8.28,9.81,10.41,11.41,12.97,15.25,16.81,17.88,19.16,21.0,22.28,22.41,22.12,22.81,23.09,22.41,21.03,19.97,18.69,16.38,13.91,12.81,12.81,12.84,12.59,13.12,15.16,16.97,18.56,20.31,22.78,24.88,25.59,24.88,24.5,23.72,22.53,20.62,20.09,20.84,21.72,22.12,22.94,24.34,24.62,23.25,21.25,20.22,19.31,18.12,16.94,17.0,16.81,16.12,14.66,13.66,13.53,13.59,13.12,13.75,14.84,15.88,15.84,15.12,15.47,16.28,17.03,17.97,19.69,21.97,23.41,23.56,23.44,23.75,23.72,22.78,22.22,23.06,23.62,22.97,21.62,20.44,19.06,17.53,15.41,14.56,15.03,15.59,16.06,17.44,19.97,22.75,24.22,25.53,27.56,28.66,28.44,27.78,27.56,28.06,28.44,28.59,29.09,29.66,29.12,27.16,25.06,23.44,21.75,19.44,17.25,16.69,16.75,16.06,15.66,16.25,17.0,17.72,18.44,19.78,22.09,24.34,25.62,26.53,27.69,27.97,26.59,24.88,24.16,23.47,22.22,20.12,18.59,17.38,16.16,14.28,13.31,13.09,12.94,12.09,11.25,11.47,12.0,11.62,10.91,10.97,11.28,11.41,11.22,11.97,13.72,15.09,15.69,16.53,17.84,19.25,19.12,18.66,18.22,17.78,16.31,14.5,13.97,14.78,15.75,16.75,18.69,20.94,22.41,21.88,20.78,19.81,18.69,16.78,15.62,15.41,15.88,15.75,14.91,13.81,12.78,11.28,9.12,8.25,8.03,8.19,7.22,6.22,6.28,6.69,6.25,6.0,6.66,7.06,6.78,6.25,6.56,7.22,7.88,7.56,7.69,8.69,10.0,11.0,12.19,14.12,15.38,15.03,13.59,12.12,11.22,10.16,9.09,8.59,8.88,9.19,8.22,7.62,7.53,7.59,6.12,4.78,4.5,5.03,5.03,5.0,5.12,5.38,4.44,2.84,1.41,0.81,0.53,-0.03,-0.19,0.34,2.0,2.84,3.59,5.22,7.28,8.97,10.0,12.03,14.22,15.75,16.16,16.78,17.5,17.66,16.47,14.84,13.81,13.22,12.12,11.5,12.19,13.69,15.12,15.84,16.94,18.06,18.66,18.06,17.06,17.31,17.56,17.44,17.44,18.12,19.41,19.94,20.12,21.22,22.75,24.0,24.12,24.44,25.06,25.09,24.22,23.09,22.62,22.22,20.84,19.38,18.69,18.53,17.94,17.28,17.44,18.69,19.47,19.91,20.94,22.69,24.81,26.16,27.66,29.47,31.09,31.81,31.91,31.81,32.03,31.03,29.59,27.59,26.25,24.75,22.97,21.97,22.5,23.53,24.78,25.94,27.88,29.62,30.16,29.59,29.31,29.12,28.91,28.72,29.31,31.44,33.44,34.12,34.31,34.62,33.75,31.53,28.78,26.62,24.94,22.88,21.03,19.88,19.75,18.66,17.84,16.88,17.16,16.97,16.09,15.09,14.75,14.69,14.28,14.56,15.91,17.94,19.5,20.69,21.66,22.59,23.0,23.53,24.12,25.84,27.78,28.97,29.84,30.84,31.88,31.59,30.62,30.12,29.34,28.66,27.84,28.06,29.53,30.56,30.59,30.09,30.03,29.12,27.47,25.69,24.94,24.34,23.78,23.12,23.06,23.91,24.47,24.22,24.53,25.78,26.75,27.28,27.41,28.28,29.16,28.59,27.78,27.41,27.22,26.56,25.28,24.81,24.94,25.12,24.91,25.06,26.19,27.06,26.53,25.38,24.94,24.41,23.88,23.34,23.56,24.12,24.19,23.53,23.41,24.28,25.22,25.69,26.19,27.12,27.53,27.22,25.78,25.34,24.44,23.06,21.41,20.31,20.12,19.69,18.84,17.88,17.44,16.84,15.56,14.59,15.12,15.75,15.72,15.5,16.09,17.5,18.53,19.88,21.47,23.41,27.16,28.81,31.69,35.72,39.84,43.34,46.22,47.38,47.16,46.03,44.41,42.91,42.5,42.47:13.09,14.19,16.41,18.41,18.91,18.25,17.34,15.69,13.0,9.09,5.75,3.69,2.16,0.72,0.88,2.94,5.62,7.66,9.56,12.5,14.62,15.47,15.59,16.22,17.38,17.84,17.66,18.31,19.5,20.41,19.84,19.44,20.03,20.5,20.56,21.19,22.88,24.66,24.91,24.31,24.06,23.59,22.56,20.88,19.81,19.09,18.19,16.59,15.5,15.44,15.84,15.91,16.47,18.53,21.53,23.75,25.84,28.16,30.31,31.38,31.28,31.16,31.66,32.06,31.28,30.56,30.41,30.12,28.94,27.03,25.88,24.81,23.34,21.41,19.88,19.59,19.06,17.31,15.75,14.69,13.25,11.16,9.31,8.66,8.78,8.28,7.25,6.5,5.56,3.34,0.28,-2.31,-3.31,-3.97,-4.5,-4.19,-2.84,-1.31,-0.22,0.53,2.06,4.62,6.94,8.69,11.47,14.69,17.19,18.22,18.69,18.91,18.16,15.94,13.56,11.94,10.38,8.12,5.53,3.41,2.12,0.53,-0.34,0.47,2.72,5.62,8.34,12.06,16.94,21.44,24.81,27.69,29.91,31.72,31.97,31.53,31.47,31.66,30.88,29.38,27.84,26.66,25.19,22.94,20.72,20.19,19.81,18.78,18.19,18.34,18.31,17.16,15.88,14.81,14.97,14.81,14.47,15.06,16.44,17.5,17.22,16.84,16.38,15.75,14.03,12.66,12.22,12.34,11.91,11.41,10.81,10.72,10.28,9.12,8.97,9.31,10.22,10.56,11.5,13.31,15.84,17.94,20.12,22.28,24.44,25.03,25.06,24.66,24.88,24.41,22.97,21.41,20.56,19.81,18.81,18.25,19.0,19.84,19.56,18.16,16.78,15.81,13.97,12.34,10.91,10.41,9.84,8.88,8.66,9.59,11.12,11.94,12.78,14.47,16.25,17.97,19.19,20.59,22.69,23.62,23.31,22.91,22.31,21.28,19.5,17.69,16.19,15.16,13.66,11.97,11.31,11.59,12.31,12.75,13.78,15.56,17.06,17.38,17.06,17.94,17.81,16.81,16.12,16.22,16.78,16.91,16.66,16.88,17.03,16.5,14.78,13.0,11.81,10.56,8.38,6.59,6.38,6.28,5.53,5.09,5.62,6.88,7.34,7.72,8.69,10.41,11.44,12.25,13.38,15.56,17.62,18.72,19.22,19.56,19.03,17.53,14.94,13.5,13.09,12.94,12.59,13.0,13.78,14.22,13.44,12.34,11.84,11.31,10.03,9.09,9.69,10.66,11.69,12.16,13.16,14.5,15.44,15.44,15.62,16.66,16.97,16.34,15.59,15.28,14.66,13.75,12.88,12.88,13.34,13.38,12.41,11.62,11.62,10.91,9.66,9.16,9.69,10.41,10.28,10.31,10.84,11.66,11.91,12.09,13.59,15.91,17.69,18.91,20.03,21.31,21.19,19.72,17.91,16.56,15.25,12.91,10.44,9.22,8.66,7.94,7.22,8.19,9.72,10.78,11.06,11.75,12.56,13.0,13.0,13.41,14.94,17.16,18.59,19.19,19.97,20.19,19.25,17.44,16.06,14.94,14.16,12.44,11.47,11.66,11.78,11.44,11.0,12.12,13.53,14.66,14.84,15.62,16.25,15.88,14.88,14.66,14.88,15.03,14.84,14.53,15.88,17.59,18.5,18.91,20.09,20.75,20.16,18.84,18.22,18.12,18.16,18.31,19.84,21.69,23.88,24.59,24.75,24.59,23.97,22.56,20.62,20.03,20.53,21.0,21.53,22.38,23.5,23.94,23.16,22.59,22.03,21.59,20.06,18.41,17.66,17.31,16.66,16.06,16.66,17.56,17.75,17.09,16.44,15.97,15.59,14.59,14.16,14.47,15.03,14.25,13.5,13.5,13.84,13.69,13.59,14.5,16.28,17.22,17.75,18.19,18.75,19.12,18.62,18.22,18.0,17.88,16.03,13.5,11.09,8.88,6.75,4.62,4.03,4.66,6.0,7.03,8.06,9.97,11.09,11.12,10.72,10.75,12.03,13.22,14.38,16.44,18.31,19.0,18.03,16.84,15.91,15.12,13.56,12.69,13.0,12.88,11.56,10.5,10.06,10.19,10.44,11.28,13.28,16.38,19.34,21.81,24.34,27.19,28.88,29.06,28.78,28.56,28.12,26.66,25.0,23.41,22.16,19.78,17.53,15.88,15.56,15.56,15.25,15.5,16.25,17.31,17.47,18.31,20.31,23.25,25.44,27.5,30.22,33.16,34.88,35.69,36.06,35.91,34.75,31.97,29.25,27.09,25.31,22.75,20.34,19.34,18.88,17.94,17.5,17.84,19.0,18.97,18.34,18.28,18.47,18.97,19.22,20.19,21.66,23.0,22.81,21.97,21.03,19.72,17.56,14.78,12.44,11.62,10.78,10.03,9.66,11.16,12.62,13.66,16.19,20.53,26.03,31.47,36.88,42.19,46.09,47.19,46.12,43.66,41.28,37.94,34.44,31.5,29.62,27.66,24.78,22.12,20.16,18.59,16.47,14.88,14.28,14.62,15.62,17.16,19.91,23.72,26.75,28.34,28.84,29.72,30.25,29.56,28.66,28.09,27.0,24.12,20.69,17.72,15.69,13.97,13.0,12.97,14.31,15.0,15.16,14.44,14.59,14.62,13.97,13.97,15.25,17.66,19.91,22.22,24.62,27.94,30.12,31.16,32.03,33.88,34.84,34.47,33.97,33.56,32.69,30.75,28.5,27.22,26.62,25.34,23.75,22.69,22.31,21.06,19.19,17.34,16.81,15.84,14.41,12.94,13.22,14.0,15.09,16.47,18.97,21.88,24.53,25.97,27.03,28.75,30.03,30.31,30.53,31.97,33.03,33.22,32.22,31.91,31.72,30.28,28.41,27.22,27.16,26.53,25.84,25.25,25.59,25.62,24.62,23.53,23.72,24.75,24.88,25.38,27.0,28.12,27.97,26.31,24.25,21.78,18.56,14.78,11.41,9.69,8.66,7.62,7.38,8.28,9.81,10.41,11.41,12.97,15.25,16.81,17.88,19.16,21.0,22.28,22.41,22.12,22.81,23.09,22.41,21.03,19.97,18.69,16.38,13.91,12.81,12.81,12.84,12.59,13.12,15.16,16.97,18.56,20.31,22.78,24.88,25.59,24.88,24.5,23.72,22.53,20.62,20.09,20.84,21.72,22.12,22.94,24.34,24.62,23.25,21.25,20.22,19.31,18.12,16.94,17.0,16.81,16.12,14.66,13.66,13.53,13.59,13.12,13.75,14.84,15.88,15.84,15.12,15.47,16.28,17.03,17.97,19.69,21.97,23.41,23.56,23.44,23.75,23.72,22.78,22.22,23.06,23.62,22.97,21.62,20.44,19.06,17.53,15.41,14.56,15.03,15.59,16.06,17.44,19.97,22.75,24.22,25.53,27.56,28.66,28.44,27.78,27.56,28.06,28.44,28.59,29.09,29.66,29.12,27.16,25.06,23.44,21.75,19.44,17.25,16.69,16.75,16.06,15.66,16.25,17.0,17.72,18.44,19.78,22.09,24.34,25.62,26.53,27.69,27.97,26.59,24.88,24.16,23.47,22.22,20.12,18.59,17.38,16.16,14.28,13.31,13.09,12.94,12.09,11.25,11.47,12.0,11.62,10.91,10.97,11.28,11.41,11.22,11.97,13.72,15.09,15.69,16.53,17.84,19.25,19.12,18.66,18.22,17.78,16.31,14.5,13.97,14.78,15.75,16.75,18.69,20.94,22.41,21.88,20.78,19.81,18.69,16.78,15.62,15.41,15.88,15.75,14.91,13.81,12.78,11.28,9.12,8.25,8.03,8.19,7.22,6.22,6.28,6.69,6.25,6.0,6.66,7.06,6.78,6.25,6.56,7.22,7.88,7.56,7.69,8.69,10.0,11.0,12.19,14.12,15.38,15.03,13.59,12.12,11.22,10.16,9.09,8.59,8.88,9.19,8.22,7.62,7.53,7.59,6.12,4.78,4.5,5.03,5.03,5.0,5.12,5.38,4.44,2.84,1.41,0.81,0.53,-0.03,-0.19,0.34,2.0,2.84,3.59,5.22,7.28,8.97,10.0,12.03,14.22,15.75,16.16,16.78,17.5,17.66,16.47,14.84,13.81,13.22,12.12,11.5,12.19,13.69,15.12,15.84,16.94,18.06,18.66,18.06,17.06,17.31,17.56,17.44,17.44,18.12,19.41,19.94,20.12,21.22,22.75,24.0,24.12,24.44,25.06,25.09,24.22,23.09,22.62,22.22,20.84,19.38,18.69,18.53,17.94,17.28,17.44,18.69,19.47,19.91,20.94,22.69,24.81,26.16,27.66,29.47,31.09,31.81,31.91,31.81,32.03,31.03,29.59,27.59,26.25,24.75,22.97,21.97,22.5,23.53,24.78,25.94,27.88,29.62,30.16,29.59,29.31,29.12,28.91,28.72,29.31,31.44,33.44,34.12,34.31,34.62,33.75,31.53,28.78,26.62,24.94,22.88,21.03,19.88,19.75,18.66,17.84,16.88,17.16,16.97,16.09,15.09,14.75,14.69,14.28,14.56,15.91,17.94,19.5,20.69,21.66,22.59,23.0,23.53,24.12,25.84,27.78,28.97,29.84,30.84,31.88,31.59,30.62,30.12,29.34,28.66,27.84,28.06,29.53,30.56,30.59,30.09,30.03,29.12,27.47,25.69,24.94,24.34,23.78,23.12,23.06,23.91,24.47,24.22,24.53,25.78,26.75,27.28,27.41,28.28,29.16,28.59,27.78,27.41,27.22,26.56,25.28,24.81,24.94,25.12,24.91,25.06,26.19,27.06,26.53,25.38,24.94,24.41,23.88,23.34,23.56,24.12,24.19,23.53,23.41,24.28,25.22,25.69,26.19,27.12,27.53,27.22,25.78,25.34,24.44,23.06,21.41,20.31,20.12,19.69,18.84,17.88,17.44,16.84,15.56,14.59,15.12,15.75,15.72,15.5,16.09,17.5,18.53,19.88,21.47,23.41,27.16,28.81,31.69,35.72,39.84,43.34,46.22,47.38,47.16,46.03,44.41,42.91,42.5,42.47,42.94,44.38,45.5,46.0,46.19,46.41,46.72:15.69,13.0,9.09,5.75,3.69,2.16,0.72,0.88,2.94,5.62,7.66,9.56,12.5,14.62,15.47,15.59,16.22,17.38,17.84,17.66,18.31,19.5,20.41,19.84,19.44,20.03,20.5,20.56,21.19,22.88,24.66,24.91,24.31,24.06,23.59,22.56,20.88,19.81,19.09,18.19,16.59,15.5,15.44,15.84,15.91,16.47,18.53,21.53,23.75,25.84,28.16,30.31,31.38,31.28,31.16,31.66,32.06,31.28,30.56,30.41,30.12,28.94,27.03,25.88,24.81,23.34,21.41,19.88,19.59,19.06,17.31,15.75,14.69,13.25,11.16,9.31,8.66,8.78,8.28,7.25,6.5,5.56,3.34,0.28,-2.31,-3.31,-3.97,-4.5,-4.19,-2.84,-1.31,-0.22,0.53,2.06,4.62,6.94,8.69,11.47,14.69,17.19,18.22,18.69,18.91,18.16,15.94,13.56,11.94,10.38,8.12,5.53,3.41,2.12,0.53,-0.34,0.47,2.72,5.62,8.34,12.06,16.94,21.44,24.81,27.69,29.91,31.72,31.97,31.53,31.47,31.66,30.88,29.38,27.84,26.66,25.19,22.94,20.72,20.19,19.81,18.78,18.19,18.34,18.31,17.16,15.88,14.81,14.97,14.81,14.47,15.06,16.44,17.5,17.22,16.84,16.38,15.75,14.03,12.66,12.22,12.34,11.91,11.41,10.81,10.72,10.28,9.12,8.97,9.31,10.22,10.56,11.5,13.31,15.84,17.94,20.12,22.28,24.44,25.03,25.06,24.66,24.88,24.41,22.97,21.41,20.56,19.81,18.81,18.25,19.0,19.84,19.56,18.16,16.78,15.81,13.97,12.34,10.91,10.41,9.84,8.88,8.66,9.59,11.12,11.94,12.78,14.47,16.25,17.97,19.19,20.59,22.69,23.62,23.31,22.91,22.31,21.28,19.5,17.69,16.19,15.16,13.66,11.97,11.31,11.59,12.31,12.75,13.78,15.56,17.06,17.38,17.06,17.94,17.81,16.81,16.12,16.22,16.78,16.91,16.66,16.88,17.03,16.5,14.78,13.0,11.81,10.56,8.38,6.59,6.38,6.28,5.53,5.09,5.62,6.88,7.34,7.72,8.69,10.41,11.44,12.25,13.38,15.56,17.62,18.72,19.22,19.56,19.03,17.53,14.94,13.5,13.09,12.94,12.59,13.0,13.78,14.22,13.44,12.34,11.84,11.31,10.03,9.09,9.69,10.66,11.69,12.16,13.16,14.5,15.44,15.44,15.62,16.66,16.97,16.34,15.59,15.28,14.66,13.75,12.88,12.88,13.34,13.38,12.41,11.62,11.62,10.91,9.66,9.16,9.69,10.41,10.28,10.31,10.84,11.66,11.91,12.09,13.59,15.91,17.69,18.91,20.03,21.31,21.19,19.72,17.91,16.56,15.25,12.91,10.44,9.22,8.66,7.94,7.22,8.19,9.72,10.78,11.06,11.75,12.56,13.0,13.0,13.41,14.94,17.16,18.59,19.19,19.97,20.19,19.25,17.44,16.06,14.94,14.16,12.44,11.47,11.66,11.78,11.44,11.0,12.12,13.53,14.66,14.84,15.62,16.25,15.88,14.88,14.66,14.88,15.03,14.84,14.53,15.88,17.59,18.5,18.91,20.09,20.75,20.16,18.84,18.22,18.12,18.16,18.31,19.84,21.69,23.88,24.59,24.75,24.59,23.97,22.56,20.62,20.03,20.53,21.0,21.53,22.38,23.5,23.94,23.16,22.59,22.03,21.59,20.06,18.41,17.66,17.31,16.66,16.06,16.66,17.56,17.75,17.09,16.44,15.97,15.59,14.59,14.16,14.47,15.03,14.25,13.5,13.5,13.84,13.69,13.59,14.5,16.28,17.22,17.75,18.19,18.75,19.12,18.62,18.22,18.0,17.88,16.03,13.5,11.09,8.88,6.75,4.62,4.03,4.66,6.0,7.03,8.06,9.97,11.09,11.12,10.72,10.75,12.03,13.22,14.38,16.44,18.31,19.0,18.03,16.84,15.91,15.12,13.56,12.69,13.0,12.88,11.56,10.5,10.06,10.19,10.44,11.28,13.28,16.38,19.34,21.81,24.34,27.19,28.88,29.06,28.78,28.56,28.12,26.66,25.0,23.41,22.16,19.78,17.53,15.88,15.56,15.56,15.25,15.5,16.25,17.31,17.47,18.31,20.31,23.25,25.44,27.5,30.22,33.16,34.88,35.69,36.06,35.91,34.75,31.97,29.25,27.09,25.31,22.75,20.34,19.34,18.88,17.94,17.5,17.84,19.0,18.97,18.34,18.28,18.47,18.97,19.22,20.19,21.66,23.0,22.81,21.97,21.03,19.72,17.56,14.78,12.44,11.62,10.78,10.03,9.66,11.16,12.62,13.66,16.19,20.53,26.03,31.47,36.88,42.19,46.09,47.19,46.12,43.66,41.28,37.94,34.44,31.5,29.62,27.66,24.78,22.12,20.16,18.59,16.47,14.88,14.28,14.62,15.62,17.16,19.91,23.72,26.75,28.34,28.84,29.72,30.25,29.56,28.66,28.09,27.0,24.12,20.69,17.72,15.69,13.97,13.0,12.97,14.31,15.0,15.16,14.44,14.59,14.62,13.97,13.97,15.25,17.66,19.91,22.22,24.62,27.94,30.12,31.16,32.03,33.88,34.84,34.47,33.97,33.56,32.69,30.75,28.5,27.22,26.62,25.34,23.75,22.69,22.31,21.06,19.19,17.34,16.81,15.84,14.41,12.94,13.22,14.0,15.09,16.47,18.97,21.88,24.53,25.97,27.03,28.75,30.03,30.31,30.53,31.97,33.03,33.22,32.22,31.91,31.72,30.28,28.41,27.22,27.16,26.53,25.84,25.25,25.59,25.62,24.62,23.53,23.72,24.75,24.88,25.38,27.0,28.12,27.97,26.31,24.25,21.78,18.56,14.78,11.41,9.69,8.66,7.62,7.38,8.28,9.81,10.41,11.41,12.97,15.25,16.81,17.88,19.16,21.0,22.28,22.41,22.12,22.81,23.09,22.41,21.03,19.97,18.69,16.38,13.91,12.81,12.81,12.84,12.59,13.12,15.16,16.97,18.56,20.31,22.78,24.88,25.59,24.88,24.5,23.72,22.53,20.62,20.09,20.84,21.72,22.12,22.94,24.34,24.62,23.25,21.25,20.22,19.31,18.12,16.94,17.0,16.81,16.12,14.66,13.66,13.53,13.59,13.12,13.75,14.84,15.88,15.84,15.12,15.47,16.28,17.03,17.97,19.69,21.97,23.41,23.56,23.44,23.75,23.72,22.78,22.22,23.06,23.62,22.97,21.62,20.44,19.06,17.53,15.41,14.56,15.03,15.59,16.06,17.44,19.97,22.75,24.22,25.53,27.56,28.66,28.44,27.78,27.56,28.06,28.44,28.59,29.09,29.66,29.12,27.16,25.06,23.44,21.75,19.44,17.25,16.69,16.75,16.06,15.66,16.25,17.0,17.72,18.44,19.78,22.09,24.34,25.62,26.53,27.69,27.97,26.59,24.88,24.16,23.47,22.22,20.12,18.59,17.38,16.16,14.28,13.31,13.09,12.94,12.09,11.25,11.47,12.0,11.62,10.91,10.97,11.28,11.41,11.22,11.97,13.72,15.09,15.69,16.53,17.84,19.25,19.12,18.66,18.22,17.78,16.31,14.5,13.97,14.78,15.75,16.75,18.69,20.94,22.41,21.88,20.78,19.81,18.69,16.78,15.62,15.41,15.88,15.75,14.91,13.81,12.78,11.28,9.12,8.25,8.03,8.19,7.22,6.22,6.28,6.69,6.25,6.0,6.66,7.06,6.78,6.25,6.56,7.22,7.88,7.56,7.69,8.69,10.0,11.0,12.19,14.12,15.38,15.03,13.59,12.12,11.22,10.16,9.09,8.59,8.88,9.19,8.22,7.62,7.53,7.59,6.12,4.78,4.5,5.03,5.03,5.0,5.12,5.38,4.44,2.84,1.41,0.81,0.53,-0.03,-0.19,0.34,2.0,2.84,3.59,5.22,7.28,8.97,10.0,12.03,14.22,15.75,16.16,16.78,17.5,17.66,16.47,14.84,13.81,13.22,12.12,11.5,12.19,13.69,15.12,15.84,16.94,18.06,18.66,18.06,17.06,17.31,17.56,17.44,17.44,18.12,19.41,19.94,20.12,21.22,22.75,24.0,24.12,24.44,25.06,25.09,24.22,23.09,22.62,22.22,20.84,19.38,18.69,18.53,17.94,17.28,17.44,18.69,19.47,19.91,20.94,22.69,24.81,26.16,27.66,29.47,31.09,31.81,31.91,31.81,32.03,31.03,29.59,27.59,26.25,24.75,22.97,21.97,22.5,23.53,24.78,25.94,27.88,29.62,30.16,29.59,29.31,29.12,28.91,28.72,29.31,31.44,33.44,34.12,34.31,34.62,33.75,31.53,28.78,26.62,24.94,22.88,21.03,19.88,19.75,18.66,17.84,16.88,17.16,16.97,16.09,15.09,14.75,14.69,14.28,14.56,15.91,17.94,19.5,20.69,21.66,22.59,23.0,23.53,24.12,25.84,27.78,28.97,29.84,30.84,31.88,31.59,30.62,30.12,29.34,28.66,27.84,28.06,29.53,30.56,30.59,30.09,30.03,29.12,27.47,25.69,24.94,24.34,23.78,23.12,23.06,23.91,24.47,24.22,24.53,25.78,26.75,27.28,27.41,28.28,29.16,28.59,27.78,27.41,27.22,26.56,25.28,24.81,24.94,25.12,24.91,25.06,26.19,27.06,26.53,25.38,24.94,24.41,23.88,23.34,23.56,24.12,24.19,23.53,23.41,24.28,25.22,25.69,26.19,27.12,27.53,27.22,25.78,25.34,24.44,23.06,21.41,20.31,20.12,19.69,18.84,17.88,17.44,16.84,15.56,14.59,15.12,15.75,15.72,15.5,16.09,17.5,18.53,19.88,21.47,23.41,27.16,28.81,31.69,35.72,39.84,43.34,46.22,47.38,47.16,46.03,44.41,42.91,42.5,42.47,42.94,44.38,45.5,46.0,46.19,46.41,46.72,47.38,48.56,50.62,52.62,54.06,54.66,54.38:0.88,2.94,5.62,7.66,9.56,12.5,14.62,15.47,15.59,16.22,17.38,17.84,17.66,18.31,19.5,20.41,19.84,19.44,20.03,20.5,20.56,21.19,22.88,24.66,24.91,24.31,24.06,23.59,22.56,20.88,19.81,19.09,18.19,16.59,15.5,15.44,15.84,15.91,16.47,18.53,21.53,23.75,25.84,28.16,30.31,31.38,31.28,31.16,31.66,32.06,31.28,30.56,30.41,30.12,28.94,27.03,25.88,24.81,23.34,21.41,19.88,19.59,19.06,17.31,15.75,14.69,13.25,11.16,9.31,8.66,8.78,8.28,7.25,6.5,5.56,3.34,0.28,-2.31,-3.31,-3.97,-4.5,-4.19,-2.84,-1.31,-0.22,0.53,2.06,4.62,6.94,8.69,11.47,14.69,17.19,18.22,18.69,18.91,18.16,15.94,13.56,11.94,10.38,8.12,5.53,3.41,2.12,0.53,-0.34,0.47,2.72,5.62,8.34,12.06,16.94,21.44,24.81,27.69,29.91,31.72,31.97,31.53,31.47,31.66,30.88,29.38,27.84,26.66,25.19,22.94,20.72,20.19,19.81,18.78,18.19,18.34,18.31,17.16,15.88,14.81,14.97,14.81,14.47,15.06,16.44,17.5,17.22,16.84,16.38,15.75,14.03,12.66,12.22,12.34,11.91,11.41,10.81,10.72,10.28,9.12,8.97,9.31,10.22,10.56,11.5,13.31,15.84,17.94,20.12,22.28,24.44,25.03,25.06,24.66,24.88,24.41,22.97,21.41,20.56,19.81,18.81,18.25,19.0,19.84,19.56,18.16,16.78,15.81,13.97,12.34,10.91,10.41,9.84,8.88,8.66,9.59,11.12,11.94,12.78,14.47,16.25,17.97,19.19,20.59,22.69,23.62,23.31,22.91,22.31,21.28,19.5,17.69,16.19,15.16,13.66,11.97,11.31,11.59,12.31,12.75,13.78,15.56,17.06,17.38,17.06,17.94,17.81,16.81,16.12,16.22,16.78,16.91,16.66,16.88,17.03,16.5,14.78,13.0,11.81,10.56,8.38,6.59,6.38,6.28,5.53,5.09,5.62,6.88,7.34,7.72,8.69,10.41,11.44,12.25,13.38,15.56,17.62,18.72,19.22,19.56,19.03,17.53,14.94,13.5,13.09,12.94,12.59,13.0,13.78,14.22,13.44,12.34,11.84,11.31,10.03,9.09,9.69,10.66,11.69,12.16,13.16,14.5,15.44,15.44,15.62,16.66,16.97,16.34,15.59,15.28,14.66,13.75,12.88,12.88,13.34,13.38,12.41,11.62,11.62,10.91,9.66,9.16,9.69,10.41,10.28,10.31,10.84,11.66,11.91,12.09,13.59,15.91,17.69,18.91,20.03,21.31,21.19,19.72,17.91,16.56,15.25,12.91,10.44,9.22,8.66,7.94,7.22,8.19,9.72,10.78,11.06,11.75,12.56,13.0,13.0,13.41,14.94,17.16,18.59,19.19,19.97,20.19,19.25,17.44,16.06,14.94,14.16,12.44,11.47,11.66,11.78,11.44,11.0,12.12,13.53,14.66,14.84,15.62,16.25,15.88,14.88,14.66,14.88,15.03,14.84,14.53,15.88,17.59,18.5,18.91,20.09,20.75,20.16,18.84,18.22,18.12,18.16,18.31,19.84,21.69,23.88,24.59,24.75,24.59,23.97,22.56,20.62,20.03,20.53,21.0,21.53,22.38,23.5,23.94,23.16,22.59,22.03,21.59,20.06,18.41,17.66,17.31,16.66,16.06,16.66,17.56,17.75,17.09,16.44,15.97,15.59,14.59,14.16,14.47,15.03,14.25,13.5,13.5,13.84,13.69,13.59,14.5,16.28,17.22,17.75,18.19,18.75,19.12,18.62,18.22,18.0,17.88,16.03,13.5,11.09,8.88,6.75,4.62,4.03,4.66,6.0,7.03,8.06,9.97,11.09,11.12,10.72,10.75,12.03,13.22,14.38,16.44,18.31,19.0,18.03,16.84,15.91,15.12,13.56,12.69,13.0,12.88,11.56,10.5,10.06,10.19,10.44,11.28,13.28,16.38,19.34,21.81,24.34,27.19,28.88,29.06,28.78,28.56,28.12,26.66,25.0,23.41,22.16,19.78,17.53,15.88,15.56,15.56,15.25,15.5,16.25,17.31,17.47,18.31,20.31,23.25,25.44,27.5,30.22,33.16,34.88,35.69,36.06,35.91,34.75,31.97,29.25,27.09,25.31,22.75,20.34,19.34,18.88,17.94,17.5,17.84,19.0,18.97,18.34,18.28,18.47,18.97,19.22,20.19,21.66,23.0,22.81,21.97,21.03,19.72,17.56,14.78,12.44,11.62,10.78,10.03,9.66,11.16,12.62,13.66,16.19,20.53,26.03,31.47,36.88,42.19,46.09,47.19,46.12,43.66,41.28,37.94,34.44,31.5,29.62,27.66,24.78,22.12,20.16,18.59,16.47,14.88,14.28,14.62,15.62,17.16,19.91,23.72,26.75,28.34,28.84,29.72,30.25,29.56,28.66,28.09,27.0,24.12,20.69,17.72,15.69,13.97,13.0,12.97,14.31,15.0,15.16,14.44,14.59,14.62,13.97,13.97,15.25,17.66,19.91,22.22,24.62,27.94,30.12,31.16,32.03,33.88,34.84,34.47,33.97,33.56,32.69,30.75,28.5,27.22,26.62,25.34,23.75,22.69,22.31,21.06,19.19,17.34,16.81,15.84,14.41,12.94,13.22,14.0,15.09,16.47,18.97,21.88,24.53,25.97,27.03,28.75,30.03,30.31,30.53,31.97,33.03,33.22,32.22,31.91,31.72,30.28,28.41,27.22,27.16,26.53,25.84,25.25,25.59,25.62,24.62,23.53,23.72,24.75,24.88,25.38,27.0,28.12,27.97,26.31,24.25,21.78,18.56,14.78,11.41,9.69,8.66,7.62,7.38,8.28,9.81,10.41,11.41,12.97,15.25,16.81,17.88,19.16,21.0,22.28,22.41,22.12,22.81,23.09,22.41,21.03,19.97,18.69,16.38,13.91,12.81,12.81,12.84,12.59,13.12,15.16,16.97,18.56,20.31,22.78,24.88,25.59,24.88,24.5,23.72,22.53,20.62,20.09,20.84,21.72,22.12,22.94,24.34,24.62,23.25,21.25,20.22,19.31,18.12,16.94,17.0,16.81,16.12,14.66,13.66,13.53,13.59,13.12,13.75,14.84,15.88,15.84,15.12,15.47,16.28,17.03,17.97,19.69,21.97,23.41,23.56,23.44,23.75,23.72,22.78,22.22,23.06,23.62,22.97,21.62,20.44,19.06,17.53,15.41,14.56,15.03,15.59,16.06,17.44,19.97,22.75,24.22,25.53,27.56,28.66,28.44,27.78,27.56,28.06,28.44,28.59,29.09,29.66,29.12,27.16,25.06,23.44,21.75,19.44,17.25,16.69,16.75,16.06,15.66,16.25,17.0,17.72,18.44,19.78,22.09,24.34,25.62,26.53,27.69,27.97,26.59,24.88,24.16,23.47,22.22,20.12,18.59,17.38,16.16,14.28,13.31,13.09,12.94,12.09,11.25,11.47,12.0,11.62,10.91,10.97,11.28,11.41,11.22,11.97,13.72,15.09,15.69,16.53,17.84,19.25,19.12,18.66,18.22,17.78,16.31,14.5,13.97,14.78,15.75,16.75,18.69,20.94,22.41,21.88,20.78,19.81,18.69,16.78,15.62,15.41,15.88,15.75,14.91,13.81,12.78,11.28,9.12,8.25,8.03,8.19,7.22,6.22,6.28,6.69,6.25,6.0,6.66,7.06,6.78,6.25,6.56,7.22,7.88,7.56,7.69,8.69,10.0,11.0,12.19,14.12,15.38,15.03,13.59,12.12,11.22,10.16,9.09,8.59,8.88,9.19,8.22,7.62,7.53,7.59,6.12,4.78,4.5,5.03,5.03,5.0,5.12,5.38,4.44,2.84,1.41,0.81,0.53,-0.03,-0.19,0.34,2.0,2.84,3.59,5.22,7.28,8.97,10.0,12.03,14.22,15.75,16.16,16.78,17.5,17.66,16.47,14.84,13.81,13.22,12.12,11.5,12.19,13.69,15.12,15.84,16.94,18.06,18.66,18.06,17.06,17.31,17.56,17.44,17.44,18.12,19.41,19.94,20.12,21.22,22.75,24.0,24.12,24.44,25.06,25.09,24.22,23.09,22.62,22.22,20.84,19.38,18.69,18.53,17.94,17.28,17.44,18.69,19.47,19.91,20.94,22.69,24.81,26.16,27.66,29.47,31.09,31.81,31.91,31.81,32.03,31.03,29.59,27.59,26.25,24.75,22.97,21.97,22.5,23.53,24.78,25.94,27.88,29.62,30.16,29.59,29.31,29.12,28.91,28.72,29.31,31.44,33.44,34.12,34.31,34.62,33.75,31.53,28.78,26.62,24.94,22.88,21.03,19.88,19.75,18.66,17.84,16.88,17.16,16.97,16.09,15.09,14.75,14.69,14.28,14.56,15.91,17.94,19.5,20.69,21.66,22.59,23.0,23.53,24.12,25.84,27.78,28.97,29.84,30.84,31.88,31.59,30.62,30.12,29.34,28.66,27.84,28.06,29.53,30.56,30.59,30.09,30.03,29.12,27.47,25.69,24.94,24.34,23.78,23.12,23.06,23.91,24.47,24.22,24.53,25.78,26.75,27.28,27.41,28.28,29.16,28.59,27.78,27.41,27.22,26.56,25.28,24.81,24.94,25.12,24.91,25.06,26.19,27.06,26.53,25.38,24.94,24.41,23.88,23.34,23.56,24.12,24.19,23.53,23.41,24.28,25.22,25.69,26.19,27.12,27.53,27.22,25.78,25.34,24.44,23.06,21.41,20.31,20.12,19.69,18.84,17.88,17.44,16.84,15.56,14.59,15.12,15.75,15.72,15.5,16.09,17.5,18.53,19.88,21.47,23.41,27.16,28.81,31.69,35.72,39.84,43.34,46.22,47.38,47.16,46.03,44.41,42.91,42.5,42.47,42.94,44.38,45.5,46.0,46.19,46.41,46.72,47.38,48.56,50.62,52.62,54.06,54.66,54.38,53.03,51.03,48.06,44.78,42.0,39.66,37.75:15.47,15.59,16.22,17.38,17.84,17.66,18.31,19.5,20.41,19.84,19.44,20.03,20.5,20.56,21.19,22.88,24.66,24.91,24.31,24.06,23.59,22.56,20.88,19.81,19.09,18.19,16.59,15.5,15.44,15.84,15.91,16.47,18.53,21.53,23.75,25.84,28.16,30.31,31.38,31.28,31.16,31.66,32.06,31.28,30.56,30.41,30.12,28.94,27.03,25.88,24.81,23.34,21.41,19.88,19.59,19.06,17.31,15.75,14.69,13.25,11.16,9.31,8.66,8.78,8.28,7.25,6.5,5.56,3.34,0.28,-2.31,-3.31,-3.97,-4.5,-4.19,-2.84,-1.31,-0.22,0.53,2.06,4.62,6.94,8.69,11.47,14.69,17.19,18.22,18.69,18.91,18.16,15.94,13.56,11.94,10.38,8.12,5.53,3.41,2.12,0.53,-0.34,0.47,2.72,5.62,8.34,12.06,16.94,21.44,24.81,27.69,29.91,31.72,31.97,31.53,31.47,31.66,30.88,29.38,27.84,26.66,25.19,22.94,20.72,20.19,19.81,18.78,18.19,18.34,18.31,17.16,15.88,14.81,14.97,14.81,14.47,15.06,16.44,17.5,17.22,16.84,16.38,15.75,14.03,12.66,12.22,12.34,11.91,11.41,10.81,10.72,10.28,9.12,8.97,9.31,10.22,10.56,11.5,13.31,15.84,17.94,20.12,22.28,24.44,25.03,25.06,24.66,24.88,24.41,22.97,21.41,20.56,19.81,18.81,18.25,19.0,19.84,19.56,18.16,16.78,15.81,13.97,12.34,10.91,10.41,9.84,8.88,8.66,9.59,11.12,11.94,12.78,14.47,16.25,17.97,19.19,20.59,22.69,23.62,23.31,22.91,22.31,21.28,19.5,17.69,16.19,15.16,13.66,11.97,11.31,11.59,12.31,12.75,13.78,15.56,17.06,17.38,17.06,17.94,17.81,16.81,16.12,16.22,16.78,16.91,16.66,16.88,17.03,16.5,14.78,13.0,11.81,10.56,8.38,6.59,6.38,6.28,5.53,5.09,5.62,6.88,7.34,7.72,8.69,10.41,11.44,12.25,13.38,15.56,17.62,18.72,19.22,19.56,19.03,17.53,14.94,13.5,13.09,12.94,12.59,13.0,13.78,14.22,13.44,12.34,11.84,11.31,10.03,9.09,9.69,10.66,11.69,12.16,13.16,14.5,15.44,15.44,15.62,16.66,16.97,16.34,15.59,15.28,14.66,13.75,12.88,12.88,13.34,13.38,12.41,11.62,11.62,10.91,9.66,9.16,9.69,10.41,10.28,10.31,10.84,11.66,11.91,12.09,13.59,15.91,17.69,18.91,20.03,21.31,21.19,19.72,17.91,16.56,15.25,12.91,10.44,9.22,8.66,7.94,7.22,8.19,9.72,10.78,11.06,11.75,12.56,13.0,13.0,13.41,14.94,17.16,18.59,19.19,19.97,20.19,19.25,17.44,16.06,14.94,14.16,12.44,11.47,11.66,11.78,11.44,11.0,12.12,13.53,14.66,14.84,15.62,16.25,15.88,14.88,14.66,14.88,15.03,14.84,14.53,15.88,17.59,18.5,18.91,20.09,20.75,20.16,18.84,18.22,18.12,18.16,18.31,19.84,21.69,23.88,24.59,24.75,24.59,23.97,22.56,20.62,20.03,20.53,21.0,21.53,22.38,23.5,23.94,23.16,22.59,22.03,21.59,20.06,18.41,17.66,17.31,16.66,16.06,16.66,17.56,17.75,17.09,16.44,15.97,15.59,14.59,14.16,14.47,15.03,14.25,13.5,13.5,13.84,13.69,13.59,14.5,16.28,17.22,17.75,18.19,18.75,19.12,18.62,18.22,18.0,17.88,16.03,13.5,11.09,8.88,6.75,4.62,4.03,4.66,6.0,7.03,8.06,9.97,11.09,11.12,10.72,10.75,12.03,13.22,14.38,16.44,18.31,19.0,18.03,16.84,15.91,15.12,13.56,12.69,13.0,12.88,11.56,10.5,10.06,10.19,10.44,11.28,13.28,16.38,19.34,21.81,24.34,27.19,28.88,29.06,28.78,28.56,28.12,26.66,25.0,23.41,22.16,19.78,17.53,15.88,15.56,15.56,15.25,15.5,16.25,17.31,17.47,18.31,20.31,23.25,25.44,27.5,30.22,33.16,34.88,35.69,36.06,35.91,34.75,31.97,29.25,27.09,25.31,22.75,20.34,19.34,18.88,17.94,17.5,17.84,19.0,18.97,18.34,18.28,18.47,18.97,19.22,20.19,21.66,23.0,22.81,21.97,21.03,19.72,17.56,14.78,12.44,11.62,10.78,10.03,9.66,11.16,12.62,13.66,16.19,20.53,26.03,31.47,36.88,42.19,46.09,47.19,46.12,43.66,41.28,37.94,34.44,31.5,29.62,27.66,24.78,22.12,20.16,18.59,16.47,14.88,14.28,14.62,15.62,17.16,19.91,23.72,26.75,28.34,28.84,29.72,30.25,29.56,28.66,28.09,27.0,24.12,20.69,17.72,15.69,13.97,13.0,12.97,14.31,15.0,15.16,14.44,14.59,14.62,13.97,13.97,15.25,17.66,19.91,22.22,24.62,27.94,30.12,31.16,32.03,33.88,34.84,34.47,33.97,33.56,32.69,30.75,28.5,27.22,26.62,25.34,23.75,22.69,22.31,21.06,19.19,17.34,16.81,15.84,14.41,12.94,13.22,14.0,15.09,16.47,18.97,21.88,24.53,25.97,27.03,28.75,30.03,30.31,30.53,31.97,33.03,33.22,32.22,31.91,31.72,30.28,28.41,27.22,27.16,26.53,25.84,25.25,25.59,25.62,24.62,23.53,23.72,24.75,24.88,25.38,27.0,28.12,27.97,26.31,24.25,21.78,18.56,14.78,11.41,9.69,8.66,7.62,7.38,8.28,9.81,10.41,11.41,12.97,15.25,16.81,17.88,19.16,21.0,22.28,22.41,22.12,22.81,23.09,22.41,21.03,19.97,18.69,16.38,13.91,12.81,12.81,12.84,12.59,13.12,15.16,16.97,18.56,20.31,22.78,24.88,25.59,24.88,24.5,23.72,22.53,20.62,20.09,20.84,21.72,22.12,22.94,24.34,24.62,23.25,21.25,20.22,19.31,18.12,16.94,17.0,16.81,16.12,14.66,13.66,13.53,13.59,13.12,13.75,14.84,15.88,15.84,15.12,15.47,16.28,17.03,17.97,19.69,21.97,23.41,23.56,23.44,23.75,23.72,22.78,22.22,23.06,23.62,22.97,21.62,20.44,19.06,17.53,15.41,14.56,15.03,15.59,16.06,17.44,19.97,22.75,24.22,25.53,27.56,28.66,28.44,27.78,27.56,28.06,28.44,28.59,29.09,29.66,29.12,27.16,25.06,23.44,21.75,19.44,17.25,16.69,16.75,16.06,15.66,16.25,17.0,17.72,18.44,19.78,22.09,24.34,25.62,26.53,27.69,27.97,26.59,24.88,24.16,23.47,22.22,20.12,18.59,17.38,16.16,14.28,13.31,13.09,12.94,12.09,11.25,11.47,12.0,11.62,10.91,10.97,11.28,11.41,11.22,11.97,13.72,15.09,15.69,16.53,17.84,19.25,19.12,18.66,18.22,17.78,16.31,14.5,13.97,14.78,15.75,16.75,18.69,20.94,22.41,21.88,20.78,19.81,18.69,16.78,15.62,15.41,15.88,15.75,14.91,13.81,12.78,11.28,9.12,8.25,8.03,8.19,7.22,6.22,6.28,6.69,6.25,6.0,6.66,7.06,6.78,6.25,6.56,7.22,7.88,7.56,7.69,8.69,10.0,11.0,12.19,14.12,15.38,15.03,13.59,12.12,11.22,10.16,9.09,8.59,8.88,9.19,8.22,7.62,7.53,7.59,6.12,4.78,4.5,5.03,5.03,5.0,5.12,5.38,4.44,2.84,1.41,0.81,0.53,-0.03,-0.19,0.34,2.0,2.84,3.59,5.22,7.28,8.97,10.0,12.03,14.22,15.75,16.16,16.78,17.5,17.66,16.47,14.84,13.81,13.22,12.12,11.5,12.19,13.69,15.12,15.84,16.94,18.06,18.66,18.06,17.06,17.31,17.56,17.44,17.44,18.12,19.41,19.94,20.12,21.22,22.75,24.0,24.12,24.44,25.06,25.09,24.22,23.09,22.62,22.22,20.84,19.38,18.69,18.53,17.94,17.28,17.44,18.69,19.47,19.91,20.94,22.69,24.81,26.16,27.66,29.47,31.09,31.81,31.91,31.81,32.03,31.03,29.59,27.59,26.25,24.75,22.97,21.97,22.5,23.53,24.78,25.94,27.88,29.62,30.16,29.59,29.31,29.12,28.91,28.72,29.31,31.44,33.44,34.12,34.31,34.62,33.75,31.53,28.78,26.62,24.94,22.88,21.03,19.88,19.75,18.66,17.84,16.88,17.16,16.97,16.09,15.09,14.75,14.69,14.28,14.56,15.91,17.94,19.5,20.69,21.66,22.59,23.0,23.53,24.12,25.84,27.78,28.97,29.84,30.84,31.88,31.59,30.62,30.12,29.34,28.66,27.84,28.06,29.53,30.56,30.59,30.09,30.03,29.12,27.47,25.69,24.94,24.34,23.78,23.12,23.06,23.91,24.47,24.22,24.53,25.78,26.75,27.28,27.41,28.28,29.16,28.59,27.78,27.41,27.22,26.56,25.28,24.81,24.94,25.12,24.91,25.06,26.19,27.06,26.53,25.38,24.94,24.41,23.88,23.34,23.56,24.12,24.19,23.53,23.41,24.28,25.22,25.69,26.19,27.12,27.53,27.22,25.78,25.34,24.44,23.06,21.41,20.31,20.12,19.69,18.84,17.88,17.44,16.84,15.56,14.59,15.12,15.75,15.72,15.5,16.09,17.5,18.53,19.88,21.47,23.41,27.16,28.81,31.69,35.72,39.84,43.34,46.22,47.38,47.16,46.03,44.41,42.91,42.5,42.47,42.94,44.38,45.5,46.0,46.19,46.41,46.72,47.38,48.56,50.62,52.62,54.06,54.66,54.38,53.03,51.03,48.06,44.78,42.0,39.66,37.75,36.81,36.53,36.75,37.16,37.47,37.94,38.5:negativity
39.19,40.41,40.31,40.88,42.69,44.62,45.06,45.91,48.5,50.41,49.47,47.31,46.09,45.0,43.06,40.5,39.84,40.31,40.0,38.66,38.59,39.69,40.88,40.0,39.5,40.38,41.41,41.19,40.78,41.81,43.03,42.41,40.5,39.16,38.44,37.62,35.38,34.62,35.56,36.62,36.19,36.44,37.97,39.5,39.16,38.25,38.31,39.03,38.88,38.12,39.19,41.44,43.25,43.84,44.84,46.19,46.81,45.03,42.81,41.72,41.16,39.41,37.62,37.44,38.44,38.12,36.69,36.31,37.19,37.09,35.81,35.41,36.09,36.81,35.81,34.69,35.09,35.94,35.41,34.47,35.22,36.88,38.25,38.66,40.12,42.5,44.16,44.19,44.47,46.0,47.44,46.94,46.28,46.56,46.94,45.88,44.16,43.69,44.5,45.19,44.94,45.41,46.88,47.25,45.97,44.84,44.91,44.94,43.56,42.12,41.72,42.22,41.66,40.66,40.69,41.22,40.72,38.81,36.97,36.03,34.97,33.06,31.91,32.53,34.06,34.31,34.41,35.72,37.75,38.53,38.09,38.75,39.84,40.25,39.09,38.31,38.66,38.44,36.47,34.22,33.0,32.31,29.97,27.44,26.91,27.41,27.56,27.28,28.41,30.41,31.72,31.28,31.25,32.22,33.56,33.47,33.78,35.5,37.53,37.78,37.31,37.09,37.75,37.22,36.53,36.84,38.09,38.88,37.72,36.56,36.22,35.69,33.78,32.16,32.03,32.91,32.75,32.31,32.91,34.44,34.75,34.06,34.5,35.75,36.97,36.81,37.0,38.06,39.5,39.31,39.19,40.38,42.22,42.22,41.38,40.66,40.81,39.81,38.5,38.12,39.03,39.72,38.56,37.28,36.59,36.19,33.62,30.78,29.31,29.22,28.34,27.66,28.19,30.56,32.25,32.59,33.38,35.44,37.12,36.88,36.69,37.03,37.56,36.16,34.03,33.25,33.56,33.09,31.88,31.69,32.34,32.41,31.25,30.38,30.78,31.97,31.84,32.06,34.03,36.69,37.84,37.97,39.81,42.59,44.44,45.38,46.12,47.91,47.72,45.84,43.91,43.5,43.38,42.03,40.62,40.66,41.0,40.06,38.44,37.81,38.25,37.06,34.56,32.22,31.53,31.12,30.06,30.41,32.25,34.19,34.03,33.56,34.03,35.59,36.38,36.44,37.94,40.47,41.12,40.03,38.44,37.56,35.75,33.03,31.12,31.22,31.94,31.28,30.44,31.03,32.34,32.34,31.72,32.19,33.84,34.72,34.72,35.22,37.03,38.56,38.25,38.0,39.19,40.56,40.53,40.31,41.16,42.66,42.72,41.41,40.44,40.5,40.12,38.34,37.0,37.31,36.72,34.5,31.69,30.41,29.5,27.94,26.28,26.09,26.59,26.62,26.16,26.59,29.22,32.12,34.47,36.66,40.16,42.06,42.03,40.97,40.41,40.28,38.72,37.22,37.22,38.53,39.09,38.62,38.41,38.69,38.16,36.47,34.97,35.34,35.56,34.19,32.56,32.34,32.62,31.84,30.97,31.28,33.28,34.09,34.09,34.09,34.94,35.44,34.5,34.22,35.97,37.19,36.44,34.69,33.84,33.22,31.59,30.16,29.75,30.62,30.31,28.97,27.41,27.47,27.75,27.28,27.75,30.12,32.72,33.5,33.34,34.22,35.25,35.38,34.41,33.59,33.62,32.81,30.56,28.88,29.03,29.41,28.66,27.72,28.81,30.06,30.0,29.69,30.69,32.16,32.16,31.19,30.38,30.66,29.91,28.31,27.34,27.78,28.66,28.12,27.16,27.59,28.06,27.09,25.81,25.78,26.44,25.81,24.66,24.38,25.5,26.41,26.22,25.91,26.34,26.19,24.12,21.75,20.88,20.38,18.69,16.5,16.19,17.56,18.69,19.53,21.53,24.84,27.56,28.28,28.38,29.22,28.97,26.41,23.5,22.53,22.34,21.22,19.5,18.97,19.38,18.78,17.44,16.88,18.28,19.41,19.22,18.91,20.03,21.03,20.0,18.75,18.91,19.94,20.16,19.78,20.31,22.0,23.09,23.0,23.0,24.12,24.84,23.97,22.81,23.12,24.03,23.69,22.5,22.62,23.19,22.47,20.53,19.53,19.59,18.94,17.88,17.56,19.25,21.38,22.03,22.28,23.72,24.44,23.41,21.81,21.62,22.06,21.28,19.53,18.62,18.28,17.59,15.75,14.91,16.06,17.16,17.47,17.56,19.03,20.66,20.0,18.69,18.44,18.56,17.84,16.59,16.47,17.38,17.69,16.5,15.38,16.03,16.75,16.69,16.34,18.06,19.47,19.25,17.72,17.16,17.06,16.59,15.84,16.34,18.56,20.97,21.66,22.03,23.56,24.12,22.91,21.19,20.91,21.06,20.5,19.12,18.78,19.41,19.41,18.59,18.38,19.72,20.88,20.41,19.69,19.94,20.44,19.31,17.53,17.47,18.59,18.88,18.16,17.97,18.09,17.69,15.97,15.72,17.72,20.44,21.75,22.84,24.94,26.56,26.31,25.03,24.91,25.0,24.25,22.5,21.56,21.47,21.62,20.91,21.28,23.59,26.44,27.78,28.44,30.06,31.28,30.28,28.41,27.81,27.81,27.5,26.69,26.91,28.5,29.5,29.41,29.09,29.94,31.03,29.97,29.28,30.09,31.22,31.75,31.75,32.97,34.88,36.41,36.66,36.84,37.66,37.09,33.72,30.06,26.81,24.06,20.38,17.88,18.34,20.59,22.91,25.28,29.81,34.91,39.69,43.09,46.44,49.5,50.78,49.16,46.38,43.75,40.88,36.41,31.62,28.38,26.31,23.69,20.44,19.03,19.0,19.16,18.66,20.12,23.75,27.69,30.44,33.03,36.41,39.38,39.31,38.12,37.75,37.28,35.47,32.88,30.88,29.25,27.06,23.44,20.72,19.53,18.62,17.09,16.19,17.28,18.78,18.75,18.22,18.59,19.81,20.62,21.75,24.81,29.16,32.84,34.75,36.03,37.66,38.41,37.25,35.94,35.75,35.81,33.91,31.5,30.31,29.75,28.28,25.59,23.44,21.78,18.69,14.34,11.41,10.75,11.41,11.84,13.12,15.28,17.66,18.19,17.69,18.47,20.5,22.38,23.84,26.38,29.62,32.0,31.59,31.22,31.28,31.56,30.06,28.47,28.22,28.5,27.16,24.91,23.41,22.94,21.69,19.0,17.44,17.03,16.34,14.31,13.0,13.0,13.38,12.56,11.19,11.28,12.38,11.91,11.34,11.25,12.47,12.94,12.69,14.03,17.75,22.5,25.81,28.97,31.94,33.78,32.31,30.16,29.0,28.66,27.41,25.97,25.69,26.31,25.94,24.56,23.28,22.84,22.38,20.25,18.56,18.56,19.09,18.47,17.72,18.19,19.28,19.22,18.44,18.69,20.38,21.25,20.81,20.91,21.81,22.47,21.12,19.59,19.09,19.47,18.56,17.34,17.66,19.06,19.16,18.25,18.25,20.34,21.97,21.97,22.53,24.03,25.0,23.97,23.19,24.38,26.41,26.81,26.91,27.41,27.75,26.38,23.41,20.66,19.75,19.22,17.81,18.0,20.22,22.91,23.72,23.91,24.5,25.06,23.69,21.53,21.16,22.75,24.38,25.62,27.53,30.28,31.53,30.0,27.88,26.38,25.44,22.84,20.62,20.12,20.78,20.38,19.53,20.44,22.72,23.56,23.34,22.81,23.03,22.59,20.66,19.56,20.62,22.19,22.16,21.78,22.56,23.88,23.03,21.72,21.62,22.88,23.19,22.62,22.31,22.84,22.31,19.91,18.03,17.25,17.53,16.44,15.19,15.12,15.69,14.44,12.53,11.81,12.53,13.28,13.16,13.53,15.5,16.69,15.91,15.25,15.81,16.72,15.88,14.94,15.19,16.88,17.34,16.94,17.31,18.75,19.31,18.38,17.69,19.16,19.88,19.31,18.56,18.97,20.25,19.44,18.41,18.56,19.5,19.09,17.41,15.75,14.75,13.06,10.66,8.84,9.22,9.94,9.19,8.41,9.41,11.56,12.34,13.09,14.28,15.72,15.72,14.12,13.28,14.25,15.0,14.84,15.44,17.38,18.88,17.91,16.5,15.91,15.81,14.34,13.56,13.72,15.03,15.41,14.69,14.0,14.12,13.03,10.5,8.72,9.59,11.56,12.91,14.5,17.28,20.41,21.41,21.5,21.78,23.06,22.84,21.56,21.62,23.5,25.25,25.88,25.88,27.06,27.69,25.94,24.19,23.72,24.34,23.84,23.09,23.78,25.75,26.62,26.41,26.12,26.28,25.72,22.88,19.94,19.25,19.22,18.28,17.56,18.88,21.0,21.34,21.34,21.66,23.03,23.0,21.56,20.25,20.25,19.97,18.5,17.09,17.44,18.41,17.84,17.25,18.22,20.06,20.03,19.5,18.88,19.47,19.28,18.19,17.94,19.41,20.69,20.75,20.81,21.72,23.0,22.38,20.94,20.66,21.31,20.84,19.59,19.09,19.88,19.59,18.66,18.19,19.66,21.84,22.94,24.16,27.09,30.44,31.34,31.25,31.47,31.16,28.69,24.69,20.69,18.09,15.03,11.62,9.66,10.41,12.09,12.88,14.0,17.16,21.0,23.25,25.41,28.5,32.31,34.12,34.44,34.53,35.44,35.53,33.81,32.0,31.28,30.34,28.22,25.94,25.22,25.5,24.09,21.81,21.19,21.88,21.56,20.66,20.59,21.91,23.12,23.34,23.16,24.72,26.03,25.03,23.34,22.91,23.41,22.75,21.44,21.41,22.38,22.06,20.78,19.53,20.62,20.62,19.72,19.0,20.34,21.94,22.19,22.06,23.22,24.69,24.84,24.12,24.31,25.44,25.59,24.91,24.94,26.56,27.28,26.0,23.66,22.38,21.03,18.47,16.31,16.41,17.97,18.38,17.56,17.75,18.62,18.34,17.16,16.75,18.12,19.5,18.91,18.38,19.22,20.09,18.91,17.03,16.25,16.34,15.03,13.09,12.69,13.44,13.53,12.5,12.16,13.72,15.19:45.91,48.5,50.41,49.47,47.31,46.09,45.0,43.06,40.5,39.84,40.31,40.0,38.66,38.59,39.69,40.88,40.0,39.5,40.38,41.41,41.19,40.78,41.81,43.03,42.41,40.5,39.16,38.44,37.62,35.38,34.62,35.56,36.62,36.19,36.44,37.97,39.5,39.16,38.25,38.31,39.03,38.88,38.12,39.19,41.44,43.25,43.84,44.84,46.19,46.81,45.03,42.81,41.72,41.16,39.41,37.62,37.44,38.44,38.12,36.69,36.31,37.19,37.09,35.81,35.41,36.09,36.81,35.81,34.69,35.09,35.94,35.41,34.47,35.22,36.88,38.25,38.66,40.12,42.5,44.16,44.19,44.47,46.0,47.44,46.94,46.28,46.56,46.94,45.88,44.16,43.69,44.5,45.19,44.94,45.41,46.88,47.25,45.97,44.84,44.91,44.94,43.56,42.12,41.72,42.22,41.66,40.66,40.69,41.22,40.72,38.81,36.97,36.03,34.97,33.06,31.91,32.53,34.06,34.31,34.41,35.72,37.75,38.53,38.09,38.75,39.84,40.25,39.09,38.31,38.66,38.44,36.47,34.22,33.0,32.31,29.97,27.44,26.91,27.41,27.56,27.28,28.41,30.41,31.72,31.28,31.25,32.22,33.56,33.47,33.78,35.5,37.53,37.78,37.31,37.09,37.75,37.22,36.53,36.84,38.09,38.88,37.72,36.56,36.22,35.69,33.78,32.16,32.03,32.91,32.75,32.31,32.91,34.44,34.75,34.06,34.5,35.75,36.97,36.81,37.0,38.06,39.5,39.31,39.19,40.38,42.22,42.22,41.38,40.66,40.81,39.81,38.5,38.12,39.03,39.72,38.56,37.28,36.59,36.19,33.62,30.78,29.31,29.22,28.34,27.66,28.19,30.56,32.25,32.59,33.38,35.44,37.12,36.88,36.69,37.03,37.56,36.16,34.03,33.25,33.56,33.09,31.88,31.69,32.34,32.41,31.25,30.38,30.78,31.97,31.84,32.06,34.03,36.69,37.84,37.97,39.81,42.59,44.44,45.38,46.12,47.91,47.72,45.84,43.91,43.5,43.38,42.03,40.62,40.66,41.0,40.06,38.44,37.81,38.25,37.06,34.56,32.22,31.53,31.12,30.06,30.41,32.25,34.19,34.03,33.56,34.03,35.59,36.38,36.44,37.94,40.47,41.12,40.03,38.44,37.56,35.75,33.03,31.12,31.22,31.94,31.28,30.44,31.03,32.34,32.34,31.72,32.19,33.84,34.72,34.72,35.22,37.03,38.56,38.25,38.0,39.19,40.56,40.53,40.31,41.16,42.66,42.72,41.41,40.44,40.5,40.12,38.34,37.0,37.31,36.72,34.5,31.69,30.41,29.5,27.94,26.28,26.09,26.59,26.62,26.16,26.59,29.22,32.12,34.47,36.66,40.16,42.06,42.03,40.97,40.41,40.28,38.72,37.22,37.22,38.53,39.09,38.62,38.41,38.69,38.16,36.47,34.97,35.34,35.56,34.19,32.56,32.34,32.62,31.84,30.97,31.28,33.28,34.09,34.09,34.09,34.94,35.44,34.5,34.22,35.97,37.19,36.44,34.69,33.84,33.22,31.59,30.16,29.75,30.62,30.31,28.97,27.41,27.47,27.75,27.28,27.75,30.12,32.72,33.5,33.34,34.22,35.25,35.38,34.41,33.59,33.62,32.81,30.56,28.88,29.03,29.41,28.66,27.72,28.81,30.06,30.0,29.69,30.69,32.16,32.16,31.19,30.38,30.66,29.91,28.31,27.34,27.78,28.66,28.12,27.16,27.59,28.06,27.09,25.81,25.78,26.44,25.81,24.66,24.38,25.5,26.41,26.22,25.91,26.34,26.19,24.12,21.75,20.88,20.38,18.69,16.5,16.19,17.56,18.69,19.53,21.53,24.84,27.56,28.28,28.38,29.22,28.97,26.41,23.5,22.53,22.34,21.22,19.5,18.97,19.38,18.78,17.44,16.88,18.28,19.41,19.22,18.91,20.03,21.03,20.0,18.75,18.91,19.94,20.16,19.78,20.31,22.0,23.09,23.0,23.0,24.12,24.84,23.97,22.81,23.12,24.03,23.69,22.5,22.62,23.19,22.47,20.53,19.53,19.59,18.94,17.88,17.56,19.25,21.38,22.03,22.28,23.72,24.44,23.41,21.81,21.62,22.06,21.28,19.53,18.62,18.28,17.59,15.75,14.91,16.06,17.16,17.47,17.56,19.03,20.66,20.0,18.69,18.44,18.56,17.84,16.59,16.47,17.38,17.69,16.5,15.38,16.03,16.75,16.69,16.34,18.06,19.47,19.25,17.72,17.16,17.06,16.59,15.84,16.34,18.56,20.97,21.66,22.03,23.56,24.12,22.91,21.19,20.91,21.06,20.5,19.12,18.78,19.41,19.41,18.59,18.38,19.72,20.88,20.41,19.69,19.94,20.44,19.31,17.53,17.47,18.59,18.88,18.16,17.97,18.09,17.69,15.97,15.72,17.72,20.44,21.75,22.84,24.94,26.56,26.31,25.03,24.91,25.0,24.25,22.5,21.56,21.47,21.62,20.91,21.28,23.59,26.44,27.78,28.44,30.06,31.28,30.28,28.41,27.81,27.81,27.5,26.69,26.91,28.5,29.5,29.41,29.09,29.94,31.03,29.97,29.28,30.09,31.22,31.75,31.75,32.97,34.88,36.41,36.66,36.84,37.66,37.09,33.72,30.06,26.81,24.06,20.38,17.88,18.34,20.59,22.91,25.28,29.81,34.91,39.69,43.09,46.44,49.5,50.78,49.16,46.38,43.75,40.88,36.41,31.62,28.38,26.31,23.69,20.44,19.03,19.0,19.16,18.66,20.12,23.75,27.69,30.44,33.03,36.41,39.38,39.31,38.12,37.75,37.28,35.47,32.88,30.88,29.25,27.06,23.44,20.72,19.53,18.62,17.09,16.19,17.28,18.78,18.75,18.22,18.59,19.81,20.62,21.75,24.81,29.16,32.84,34.75,36.03,37.66,38.41,37.25,35.94,35.75,35.81,33.91,31.5,30.31,29.75,28.28,25.59,23.44,21.78,18.69,14.34,11.41,10.75,11.41,11.84,13.12,15.28,17.66,18.19,17.69,18.47,20.5,22.38,23.84,26.38,29.62,32.0,31.59,31.22,31.28,31.56,30.06,28.47,28.22,28.5,27.16,24.91,23.41,22.94,21.69,19.0,17.44,17.03,16.34,14.31,13.0,13.0,13.38,12.56,11.19,11.28,12.38,11.91,11.34,11.25,12.47,12.94,12.69,14.03,17.75,22.5,25.81,28.97,31.94,33.78,32.31,30.16,29.0,28.66,27.41,25.97,25.69,26.31,25.94,24.56,23.28,22.84,22.38,20.25,18.56,18.56,19.09,18.47,17.72,18.19,19.28,19.22,18.44,18.69,20.38,21.25,20.81,20.91,21.81,22.47,21.12,19.59,19.09,19.47,18.56,17.34,17.66,19.06,19.16,18.25,18.25,20.34,21.97,21.97,22.53,24.03,25.0,23.97,23.19,24.38,26.41,26.81,26.91,27.41,27.75,26.38,23.41,20.66,19.75,19.22,17.81,18.0,20.22,22.91,23.72,23.91,24.5,25.06,23.69,21.53,21.16,22.75,24.38,25.62,27.53,30.28,31.53,30.0,27.88,26.38,25.44,22.84,20.62,20.12,20.78,20.38,19.53,20.44,22.72,23.56,23.34,22.81,23.03,22.59,20.66,19.56,20.62,22.19,22.16,21.78,22.56,23.88,23.03,21.72,21.62,22.88,23.19,22.62,22.31,22.84,22.31,19.91,18.03,17.25,17.53,16.44,15.19,15.12,15.69,14.44,12.53,11.81,12.53,13.28,13.16,13.53,15.5,16.69,15.91,15.25,15.81,16.72,15.88,14.94,15.19,16.88,17.34,16.94,17.31,18.75,19.31,18.38,17.69,19.16,19.88,19.31,18.56,18.97,20.25,19.44,18.41,18.56,19.5,19.09,17.41,15.75,14.75,13.06,10.66,8.84,9.22,9.94,9.19,8.41,9.41,11.56,12.34,13.09,14.28,15.72,15.72,14.12,13.28,14.25,15.0,14.84,15.44,17.38,18.88,17.91,16.5,15.91,15.81,14.34,13.56,13.72,15.03,15.41,14.69,14.0,14.12,13.03,10.5,8.72,9.59,11.56,12.91,14.5,17.28,20.41,21.41,21.5,21.78,23.06,22.84,21.56,21.62,23.5,25.25,25.88,25.88,27.06,27.69,25.94,24.19,23.72,24.34,23.84,23.09,23.78,25.75,26.62,26.41,26.12,26.28,25.72,22.88,19.94,19.25,19.22,18.28,17.56,18.88,21.0,21.34,21.34,21.66,23.03,23.0,21.56,20.25,20.25,19.97,18.5,17.09,17.44,18.41,17.84,17.25,18.22,20.06,20.03,19.5,18.88,19.47,19.28,18.19,17.94,19.41,20.69,20.75,20.81,21.72,23.0,22.38,20.94,20.66,21.31,20.84,19.59,19.09,19.88,19.59,18.66,18.19,19.66,21.84,22.94,24.16,27.09,30.44,31.34,31.25,31.47,31.16,28.69,24.69,20.69,18.09,15.03,11.62,9.66,10.41,12.09,12.88,14.0,17.16,21.0,23.25,25.41,28.5,32.31,34.12,34.44,34.53,35.44,35.53,33.81,32.0,31.28,30.34,28.22,25.94,25.22,25.5,24.09,21.81,21.19,21.88,21.56,20.66,20.59,21.91,23.12,23.34,23.16,24.72,26.03,25.03,23.34,22.91,23.41,22.75,21.44,21.41,22.38,22.06,20.78,19.53,20.62,20.62,19.72,19.0,20.34,21.94,22.19,22.06,23.22,24.69,24.84,24.12,24.31,25.44,25.59,24.91,24.94,26.56,27.28,26.0,23.66,22.38,21.03,18.47,16.31,16.41,17.97,18.38,17.56,17.75,18.62,18.34,17.16,16.75,18.12,19.5,18.91,18.38,19.22,20.09,18.91,17.03,16.25,16.34,15.03,13.09,12.69,13.44,13.53,12.5,12.16,13.72,15.19,104.12,105.97,107.16,106.84,106.19,105.84,105.41:43.06,40.5,39.84,40.31,40.0,38.66,38.59,39.69,40.88,40.0,39.5,40.38,41.41,41.19,40.78,41.81,43.03,42.41,40.5,39.16,38.44,37.62,35.38,34.62,35.56,36.62,36.19,36.44,37.97,39.5,39.16,38.25,38.31,39.03,38.88,38.12,39.19,41.44,43.25,43.84,44.84,46.19,46.81,45.03,42.81,41.72,41.16,39.41,37.62,37.44,38.44,38.12,36.69,36.31,37.19,37.09,35.81,35.41,36.09,36.81,35.81,34.69,35.09,35.94,35.41,34.47,35.22,36.88,38.25,38.66,40.12,42.5,44.16,44.19,44.47,46.0,47.44,46.94,46.28,46.56,46.94,45.88,44.16,43.69,44.5,45.19,44.94,45.41,46.88,47.25,45.97,44.84,44.91,44.94,43.56,42.12,41.72,42.22,41.66,40.66,40.69,41.22,40.72,38.81,36.97,36.03,34.97,33.06,31.91,32.53,34.06,34.31,34.41,35.72,37.75,38.53,38.09,38.75,39.84,40.25,39.09,38.31,38.66,38.44,36.47,34.22,33.0,32.31,29.97,27.44,26.91,27.41,27.56,27.28,28.41,30.41,31.72,31.28,31.25,32.22,33.56,33.47,33.78,35.5,37.53,37.78,37.31,37.09,37.75,37.22,36.53,36.84,38.09,38.88,37.72,36.56,36.22,35.69,33.78,32.16,32.03,32.91,32.75,32.31,32.91,34.44,34.75,34.06,34.5,35.75,36.97,36.81,37.0,38.06,39.5,39.31,39.19,40.38,42.22,42.22,41.38,40.66,40.81,39.81,38.5,38.12,39.03,39.72,38.56,37.28,36.59,36.19,33.62,30.78,29.31,29.22,28.34,27.66,28.19,30.56,32.25,32.59,33.38,35.44,37.12,36.88,36.69,37.03,37.56,36.16,34.03,33.25,33.56,33.09,31.88,31.69,32.34,32.41,31.25,30.38,30.78,31.97,31.84,32.06,34.03,36.69,37.84,37.97,39.81,42.59,44.44,45.38,46.12,47.91,47.72,45.84,43.91,43.5,43.38,42.03,40.62,40.66,41.0,40.06,38.44,37.81,38.25,37.06,34.56,32.22,31.53,31.12,30.06,30.41,32.25,34.19,34.03,33.56,34.03,35.59,36.38,36.44,37.94,40.47,41.12,40.03,38.44,37.56,35.75,33.03,31.12,31.22,31.94,31.28,30.44,31.03,32.34,32.34,31.72,32.19,33.84,34.72,34.72,35.22,37.03,38.56,38.25,38.0,39.19,40.56,40.53,40.31,41.16,42.66,42.72,41.41,40.44,40.5,40.12,38.34,37.0,37.31,36.72,34.5,31.69,30.41,29.5,27.94,26.28,26.09,26.59,26.62,26.16,26.59,29.22,32.12,34.47,36.66,40.16,42.06,42.03,40.97,40.41,40.28,38.72,37.22,37.22,38.53,39.09,38.62,38.41,38.69,38.16,36.47,34.97,35.34,35.56,34.19,32.56,32.34,32.62,31.84,30.97,31.28,33.28,34.09,34.09,34.09,34.94,35.44,34.5,34.22,35.97,37.19,36.44,34.69,33.84,33.22,31.59,30.16,29.75,30.62,30.31,28.97,27.41,27.47,27.75,27.28,27.75,30.12,32.72,33.5,33.34,34.22,35.25,35.38,34.41,33.59,33.62,32.81,30.56,28.88,29.03,29.41,28.66,27.72,28.81,30.06,30.0,29.69,30.69,32.16,32.16,31.19,30.38,30.66,29.91,28.31,27.34,27.78,28.66,28.12,27.16,27.59,28.06,27.09,25.81,25.78,26.44,25.81,24.66,24.38,25.5,26.41,26.22,25.91,26.34,26.19,24.12,21.75,20.88,20.38,18.69,16.5,16.19,17.56,18.69,19.53,21.53,24.84,27.56,28.28,28.38,29.22,28.97,26.41,23.5,22.53,22.34,21.22,19.5,18.97,19.38,18.78,17.44,16.88,18.28,19.41,19.22,18.91,20.03,21.03,20.0,18.75,18.91,19.94,20.16,19.78,20.31,22.0,23.09,23.0,23.0,24.12,24.84,23.97,22.81,23.12,24.03,23.69,22.5,22.62,23.19,22.47,20.53,19.53,19.59,18.94,17.88,17.56,19.25,21.38,22.03,22.28,23.72,24.44,23.41,21.81,21.62,22.06,21.28,19.53,18.62,18.28,17.59,15.75,14.91,16.06,17.16,17.47,17.56,19.03,20.66,20.0,18.69,18.44,18.56,17.84,16.59,16.47,17.38,17.69,16.5,15.38,16.03,16.75,16.69,16.34,18.06,19.47,19.25,17.72,17.16,17.06,16.59,15.84,16.34,18.56,20.97,21.66,22.03,23.56,24.12,22.91,21.19,20.91,21.06,20.5,19.12,18.78,19.41,19.41,18.59,18.38,19.72,20.88,20.41,19.69,19.94,20.44,19.31,17.53,17.47,18.59,18.88,18.16,17.97,18.09,17.69,15.97,15.72,17.72,20.44,21.75,22.84,24.94,26.56,26.31,25.03,24.91,25.0,24.25,22.5,21.56,21.47,21.62,20.91,21.28,23.59,26.44,27.78,28.44,30.06,31.28,30.28,28.41,27.81,27.81,27.5,26.69,26.91,28.5,29.5,29.41,29.09,29.94,31.03,29.97,29.28,30.09,31.22,31.75,31.75,32.97,34.88,36.41,36.66,36.84,37.66,37.09,33.72,30.06,26.81,24.06,20.38,17.88,18.34,20.59,22.91,25.28,29.81,34.91,39.69,43.09,46.44,49.5,50.78,49.16,46.38,43.75,40.88,36.41,31.62,28.38,26.31,23.69,20.44,19.03,19.0,19.16,18.66,20.12,23.75,27.69,30.44,33.03,36.41,39.38,39.31,38.12,37.75,37.28,35.47,32.88,30.88,29.25,27.06,23.44,20.72,19.53,18.62,17.09,16.19,17.28,18.78,18.75,18.22,18.59,19.81,20.62,21.75,24.81,29.16,32.84,34.75,36.03,37.66,38.41,37.25,35.94,35.75,35.81,33.91,31.5,30.31,29.75,28.28,25.59,23.44,21.78,18.69,14.34,11.41,10.75,11.41,11.84,13.12,15.28,17.66,18.19,17.69,18.47,20.5,22.38,23.84,26.38,29.62,32.0,31.59,31.22,31.28,31.56,30.06,28.47,28.22,28.5,27.16,24.91,23.41,22.94,21.69,19.0,17.44,17.03,16.34,14.31,13.0,13.0,13.38,12.56,11.19,11.28,12.38,11.91,11.34,11.25,12.47,12.94,12.69,14.03,17.75,22.5,25.81,28.97,31.94,33.78,32.31,30.16,29.0,28.66,27.41,25.97,25.69,26.31,25.94,24.56,23.28,22.84,22.38,20.25,18.56,18.56,19.09,18.47,17.72,18.19,19.28,19.22,18.44,18.69,20.38,21.25,20.81,20.91,21.81,22.47,21.12,19.59,19.09,19.47,18.56,17.34,17.66,19.06,19.16,18.25,18.25,20.34,21.97,21.97,22.53,24.03,25.0,23.97,23.19,24.38,26.41,26.81,26.91,27.41,27.75,26.38,23.41,20.66,19.75,19.22,17.81,18.0,20.22,22.91,23.72,23.91,24.5,25.06,23.69,21.53,21.16,22.75,24.38,25.62,27.53,30.28,31.53,30.0,27.88,26.38,25.44,22.84,20.62,20.12,20.78,20.38,19.53,20.44,22.72,23.56,23.34,22.81,23.03,22.59,20.66,19.56,20.62,22.19,22.16,21.78,22.56,23.88,23.03,21.72,21.62,22.88,23.19,22.62,22.31,22.84,22.31,19.91,18.03,17.25,17.53,16.44,15.19,15.12,15.69,14.44,12.53,11.81,12.53,13.28,13.16,13.53,15.5,16.69,15.91,15.25,15.81,16.72,15.88,14.94,15.19,16.88,17.34,16.94,17.31,18.75,19.31,18.38,17.69,19.16,19.88,19.31,18.56,18.97,20.25,19.44,18.41,18.56,19.5,19.09,17.41,15.75,14.75,13.06,10.66,8.84,9.22,9.94,9.19,8.41,9.41,11.56,12.34,13.09,14.28,15.72,15.72,14.12,13.28,14.25,15.0,14.84,15.44,17.38,18.88,17.91,16.5,15.91,15.81,14.34,13.56,13.72,15.03,15.41,14.69,14.0,14.12,13.03,10.5,8.72,9.59,11.56,12.91,14.5,17.28,20.41,21.41,21.5,21.78,23.06,22.84,21.56,21.62,23.5,25.25,25.88,25.88,27.06,27.69,25.94,24.19,23.72,24.34,23.84,23.09,23.78,25.75,26.62,26.41,26.12,26.28,25.72,22.88,19.94,19.25,19.22,18.28,17.56,18.88,21.0,21.34,21.34,21.66,23.03,23.0,21.56,20.25,20.25,19.97,18.5,17.09,17.44,18.41,17.84,17.25,18.22,20.06,20.03,19.5,18.88,19.47,19.28,18.19,17.94,19.41,20.69,20.75,20.81,21.72,23.0,22.38,20.94,20.66,21.31,20.84,19.59,19.09,19.88,19.59,18.66,18.19,19.66,21.84,22.94,24.16,27.09,30.44,31.34,31.25,31.47,31.16,28.69,24.69,20.69,18.09,15.03,11.62,9.66,10.41,12.09,12.88,14.0,17.16,21.0,23.25,25.41,28.5,32.31,34.12,34.44,34.53,35.44,35.53,33.81,32.0,31.28,30.34,28.22,25.94,25.22,25.5,24.09,21.81,21.19,21.88,21.56,20.66,20.59,21.91,23.12,23.34,23.16,24.72,26.03,25.03,23.34,22.91,23.41,22.75,21.44,21.41,22.38,22.06,20.78,19.53,20.62,20.62,19.72,19.0,20.34,21.94,22.19,22.06,23.22,24.69,24.84,24.12,24.31,25.44,25.59,24.91,24.94,26.56,27.28,26.0,23.66,22.38,21.03,18.47,16.31,16.41,17.97,18.38,17.56,17.75,18.62,18.34,17.16,16.75,18.12,19.5,18.91,18.38,19.22,20.09,18.91,17.03,16.25,16.34,15.03,13.09,12.69,13.44,13.53,12.5,12.16,13.72,15.19,104.12,105.97,107.16,106.84,106.19,105.84,105.41,104.38,103.44,102.25,100.69,98.56,95.91,93.62:39.69,40.88,40.0,39.5,40.38,41.41,41.19,40.78,41.81,43.03,42.41,40.5,39.16,38.44,37.62,35.38,34.62,35.56,36.62,36.19,36.44,37.97,39.5,39.16,38.25,38.31,39.03,38.88,38.12,39.19,41.44,43.25,43.84,44.84,46.19,46.81,45.03,42.81,41.72,41.16,39.41,37.62,37.44,38.44,38.12,36.69,36.31,37.19,37.09,35.81,35.41,36.09,36.81,35.81,34.69,35.09,35.94,35.41,34.47,35.22,36.88,38.25,38.66,40.12,42.5,44.16,44.19,44.47,46.0,47.44,46.94,46.28,46.56,46.94,45.88,44.16,43.69,44.5,45.19,44.94,45.41,46.88,47.25,45.97,44.84,44.91,44.94,43.56,42.12,41.72,42.22,41.66,40.66,40.69,41.22,40.72,38.81,36.97,36.03,34.97,33.06,31.91,32.53,34.06,34.31,34.41,35.72,37.75,38.53,38.09,38.75,39.84,40.25,39.09,38.31,38.66,38.44,36.47,34.22,33.0,32.31,29.97,27.44,26.91,27.41,27.56,27.28,28.41,30.41,31.72,31.28,31.25,32.22,33.56,33.47,33.78,35.5,37.53,37.78,37.31,37.09,37.75,37.22,36.53,36.84,38.09,38.88,37.72,36.56,36.22,35.69,33.78,32.16,32.03,32.91,32.75,32.31,32.91,34.44,34.75,34.06,34.5,35.75,36.97,36.81,37.0,38.06,39.5,39.31,39.19,40.38,42.22,42.22,41.38,40.66,40.81,39.81,38.5,38.12,39.03,39.72,38.56,37.28,36.59,36.19,33.62,30.78,29.31,29.22,28.34,27.66,28.19,30.56,32.25,32.59,33.38,35.44,37.12,36.88,36.69,37.03,37.56,36.16,34.03,33.25,33.56,33.09,31.88,31.69,32.34,32.41,31.25,30.38,30.78,31.97,31.84,32.06,34.03,36.69,37.84,37.97,39.81,42.59,44.44,45.38,46.12,47.91,47.72,45.84,43.91,43.5,43.38,42.03,40.62,40.66,41.0,40.06,38.44,37.81,38.25,37.06,34.56,32.22,31.53,31.12,30.06,30.41,32.25,34.19,34.03,33.56,34.03,35.59,36.38,36.44,37.94,40.47,41.12,40.03,38.44,37.56,35.75,33.03,31.12,31.22,31.94,31.28,30.44,31.03,32.34,32.34,31.72,32.19,33.84,34.72,34.72,35.22,37.03,38.56,38.25,38.0,39.19,40.56,40.53,40.31,41.16,42.66,42.72,41.41,40.44,40.5,40.12,38.34,37.0,37.31,36.72,34.5,31.69,30.41,29.5,27.94,26.28,26.09,26.59,26.62,26.16,26.59,29.22,32.12,34.47,36.66,40.16,42.06,42.03,40.97,40.41,40.28,38.72,37.22,37.22,38.53,39.09,38.62,38.41,38.69,38.16,36.47,34.97,35.34,35.56,34.19,32.56,32.34,32.62,31.84,30.97,31.28,33.28,34.09,34.09,34.09,34.94,35.44,34.5,34.22,35.97,37.19,36.44,34.69,33.84,33.22,31.59,30.16,29.75,30.62,30.31,28.97,27.41,27.47,27.75,27.28,27.75,30.12,32.72,33.5,33.34,34.22,35.25,35.38,34.41,33.59,33.62,32.81,30.56,28.88,29.03,29.41,28.66,27.72,28.81,30.06,30.0,29.69,30.69,32.16,32.16,31.19,30.38,30.66,29.91,28.31,27.34,27.78,28.66,28.12,27.16,27.59,28.06,27.09,25.81,25.78,26.44,25.81,24.66,24.38,25.5,26.41,26.22,25.91,26.34,26.19,24.12,21.75,20.88,20.38,18.69,16.5,16.19,17.56,18.69,19.53,21.53,24.84,27.56,28.28,28.38,29.22,28.97,26.41,23.5,22.53,22.34,21.22,19.5,18.97,19.38,18.78,17.44,16.88,18.28,19.41,19.22,18.91,20.03,21.03,20.0,18.75,18.91,19.94,20.16,19.78,20.31,22.0,23.09,23.0,23.0,24.12,24.84,23.97,22.81,23.12,24.03,23.69,22.5,22.62,23.19,22.47,20.53,19.53,19.59,18.94,17.88,17.56,19.25,21.38,22.03,22.28,23.72,24.44,23.41,21.81,21.62,22.06,21.28,19.53,18.62,18.28,17.59,15.75,14.91,16.06,17.16,17.47,17.56,19.03,20.66,20.0,18.69,18.44,18.56,17.84,16.59,16.47,17.38,17.69,16.5,15.38,16.03,16.75,16.69,16.34,18.06,19.47,19.25,17.72,17.16,17.06,16.59,15.84,16.34,18.56,20.97,21.66,22.03,23.56,24.12,22.91,21.19,20.91,21.06,20.5,19.12,18.78,19.41,19.41,18.59,18.38,19.72,20.88,20.41,19.69,19.94,20.44,19.31,17.53,17.47,18.59,18.88,18.16,17.97,18.09,17.69,15.97,15.72,17.72,20.44,21.75,22.84,24.94,26.56,26.31,25.03,24.91,25.0,24.25,22.5,21.56,21.47,21.62,20.91,21.28,23.59,26.44,27.78,28.44,30.06,31.28,30.28,28.41,27.81,27.81,27.5,26.69,26.91,28.5,29.5,29.41,29.09,29.94,31.03,29.97,29.28,30.09,31.22,31.75,31.75,32.97,34.88,36.41,36.66,36.84,37.66,37.09,33.72,30.06,26.81,24.06,20.38,17.88,18.34,20.59,22.91,25.28,29.81,34.91,39.69,43.09,46.44,49.5,50.78,49.16,46.38,43.75,40.88,36.41,31.62,28.38,26.31,23.69,20.44,19.03,19.0,19.16,18.66,20.12,23.75,27.69,30.44,33.03,36.41,39.38,39.31,38.12,37.75,37.28,35.47,32.88,30.88,29.25,27.06,23.44,20.72,19.53,18.62,17.09,16.19,17.28,18.78,18.75,18.22,18.59,19.81,20.62,21.75,24.81,29.16,32.84,34.75,36.03,37.66,38.41,37.25,35.94,35.75,35.81,33.91,31.5,30.31,29.75,28.28,25.59,23.44,21.78,18.69,14.34,11.41,10.75,11.41,11.84,13.12,15.28,17.66,18.19,17.69,18.47,20.5,22.38,23.84,26.38,29.62,32.0,31.59,31.22,31.28,31.56,30.06,28.47,28.22,28.5,27.16,24.91,23.41,22.94,21.69,19.0,17.44,17.03,16.34,14.31,13.0,13.0,13.38,12.56,11.19,11.28,12.38,11.91,11.34,11.25,12.47,12.94,12.69,14.03,17.75,22.5,25.81,28.97,31.94,33.78,32.31,30.16,29.0,28.66,27.41,25.97,25.69,26.31,25.94,24.56,23.28,22.84,22.38,20.25,18.56,18.56,19.09,18.47,17.72,18.19,19.28,19.22,18.44,18.69,20.38,21.25,20.81,20.91,21.81,22.47,21.12,19.59,19.09,19.47,18.56,17.34,17.66,19.06,19.16,18.25,18.25,20.34,21.97,21.97,22.53,24.03,25.0,23.97,23.19,24.38,26.41,26.81,26.91,27.41,27.75,26.38,23.41,20.66,19.75,19.22,17.81,18.0,20.22,22.91,23.72,23.91,24.5,25.06,23.69,21.53,21.16,22.75,24.38,25.62,27.53,30.28,31.53,30.0,27.88,26.38,25.44,22.84,20.62,20.12,20.78,20.38,19.53,20.44,22.72,23.56,23.34,22.81,23.03,22.59,20.66,19.56,20.62,22.19,22.16,21.78,22.56,23.88,23.03,21.72,21.62,22.88,23.19,22.62,22.31,22.84,22.31,19.91,18.03,17.25,17.53,16.44,15.19,15.12,15.69,14.44,12.53,11.81,12.53,13.28,13.16,13.53,15.5,16.69,15.91,15.25,15.81,16.72,15.88,14.94,15.19,16.88,17.34,16.94,17.31,18.75,19.31,18.38,17.69,19.16,19.88,19.31,18.56,18.97,20.25,19.44,18.41,18.56,19.5,19.09,17.41,15.75,14.75,13.06,10.66,8.84,9.22,9.94,9.19,8.41,9.41,11.56,12.34,13.09,14.28,15.72,15.72,14.12,13.28,14.25,15.0,14.84,15.44,17.38,18.88,17.91,16.5,15.91,15.81,14.34,13.56,13.72,15.03,15.41,14.69,14.0,14.12,13.03,10.5,8.72,9.59,11.56,12.91,14.5,17.28,20.41,21.41,21.5,21.78,23.06,22.84,21.56,21.62,23.5,25.25,25.88,25.88,27.06,27.69,25.94,24.19,23.72,24.34,23.84,23.09,23.78,25.75,26.62,26.41,26.12,26.28,25.72,22.88,19.94,19.25,19.22,18.28,17.56,18.88,21.0,21.34,21.34,21.66,23.03,23.0,21.56,20.25,20.25,19.97,18.5,17.09,17.44,18.41,17.84,17.25,18.22,20.06,20.03,19.5,18.88,19.47,19.28,18.19,17.94,19.41,20.69,20.75,20.81,21.72,23.0,22.38,20.94,20.66,21.31,20.84,19.59,19.09,19.88,19.59,18.66,18.19,19.66,21.84,22.94,24.16,27.09,30.44,31.34,31.25,31.47,31.16,28.69,24.69,20.69,18.09,15.03,11.62,9.66,10.41,12.09,12.88,14.0,17.16,21.0,23.25,25.41,28.5,32.31,34.12,34.44,34.53,35.44,35.53,33.81,32.0,31.28,30.34,28.22,25.94,25.22,25.5,24.09,21.81,21.19,21.88,21.56,20.66,20.59,21.91,23.12,23.34,23.16,24.72,26.03,25.03,23.34,22.91,23.41,22.75,21.44,21.41,22.38,22.06,20.78,19.53,20.62,20.62,19.72,19.0,20.34,21.94,22.19,22.06,23.22,24.69,24.84,24.12,24.31,25.44,25.59,24.91,24.94,26.56,27.28,26.0,23.66,22.38,21.03,18.47,16.31,16.41,17.97,18.38,17.56,17.75,18.62,18.34,17.16,16.75,18.12,19.5,18.91,18.38,19.22,20.09,18.91,17.03,16.25,16.34,15.03,13.09,12.69,13.44,13.53,12.5,12.16,13.72,15.19,104.12,105.97,107.16,106.84,106.19,105.84,105.41,104.38,103.44,102.25,100.69,98.56,95.91,93.62,92.31,91.72,91.62,91.94,92.41,92.56,92.81:40.78,41.81,43.03,42.41,40.5,39.16,38.44,37.62,35.38,34.62,35.56,36.62,36.19,36.44,37.97,39.5,39.16,38.25,38.31,39.03,38.88,38.12,39.19,41.44,43.25,43.84,44.84,46.19,46.81,45.03,42.81,41.72,41.16,39.41,37.62,37.44,38.44,38.12,36.69,36.31,37.19,37.09,35.81,35.41,36.09,36.81,35.81,34.69,35.09,35.94,35.41,34.47,35.22,36.88,38.25,38.66,40.12,42.5,44.16,44.19,44.47,46.0,47.44,46.94,46.28,46.56,46.94,45.88,44.16,43.69,44.5,45.19,44.94,45.41,46.88,47.25,45.97,44.84,44.91,44.94,43.56,42.12,41.72,42.22,41.66,40.66,40.69,41.22,40.72,38.81,36.97,36.03,34.97,33.06,31.91,32.53,34.06,34.31,34.41,35.72,37.75,38.53,38.09,38.75,39.84,40.25,39.09,38.31,38.66,38.44,36.47,34.22,33.0,32.31,29.97,27.44,26.91,27.41,27.56,27.28,28.41,30.41,31.72,31.28,31.25,32.22,33.56,33.47,33.78,35.5,37.53,37.78,37.31,37.09,37.75,37.22,36.53,36.84,38.09,38.88,37.72,36.56,36.22,35.69,33.78,32.16,32.03,32.91,32.75,32.31,32.91,34.44,34.75,34.06,34.5,35.75,36.97,36.81,37.0,38.06,39.5,39.31,39.19,40.38,42.22,42.22,41.38,40.66,40.81,39.81,38.5,38.12,39.03,39.72,38.56,37.28,36.59,36.19,33.62,30.78,29.31,29.22,28.34,27.66,28.19,30.56,32.25,32.59,33.38,35.44,37.12,36.88,36.69,37.03,37.56,36.16,34.03,33.25,33.56,33.09,31.88,31.69,32.34,32.41,31.25,30.38,30.78,31.97,31.84,32.06,34.03,36.69,37.84,37.97,39.81,42.59,44.44,45.38,46.12,47.91,47.72,45.84,43.91,43.5,43.38,42.03,40.62,40.66,41.0,40.06,38.44,37.81,38.25,37.06,34.56,32.22,31.53,31.12,30.06,30.41,32.25,34.19,34.03,33.56,34.03,35.59,36.38,36.44,37.94,40.47,41.12,40.03,38.44,37.56,35.75,33.03,31.12,31.22,31.94,31.28,30.44,31.03,32.34,32.34,31.72,32.19,33.84,34.72,34.72,35.22,37.03,38.56,38.25,38.0,39.19,40.56,40.53,40.31,41.16,42.66,42.72,41.41,40.44,40.5,40.12,38.34,37.0,37.31,36.72,34.5,31.69,30.41,29.5,27.94,26.28,26.09,26.59,26.62,26.16,26.59,29.22,32.12,34.47,36.66,40.16,42.06,42.03,40.97,40.41,40.28,38.72,37.22,37.22,38.53,39.09,38.62,38.41,38.69,38.16,36.47,34.97,35.34,35.56,34.19,32.56,32.34,32.62,31.84,30.97,31.28,33.28,34.09,34.09,34.09,34.94,35.44,34.5,34.22,35.97,37.19,36.44,34.69,33.84,33.22,31.59,30.16,29.75,30.62,30.31,28.97,27.41,27.47,27.75,27.28,27.75,30.12,32.72,33.5,33.34,34.22,35.25,35.38,34.41,33.59,33.62,32.81,30.56,28.88,29.03,29.41,28.66,27.72,28.81,30.06,30.0,29.69,30.69,32.16,32.16,31.19,30.38,30.66,29.91,28.31,27.34,27.78,28.66,28.12,27.16,27.59,28.06,27.09,25.81,25.78,26.44,25.81,24.66,24.38,25.5,26.41,26.22,25.91,26.34,26.19,24.12,21.75,20.88,20.38,18.69,16.5,16.19,17.56,18.69,19.53,21.53,24.84,27.56,28.28,28.38,29.22,28.97,26.41,23.5,22.53,22.34,21.22,19.5,18.97,19.38,18.78,17.44,16.88,18.28,19.41,19.22,18.91,20.03,21.03,20.0,18.75,18.91,19.94,20.16,19.78,20.31,22.0,23.09,23.0,23.0,24.12,24.84,23.97,22.81,23.12,24.03,23.69,22.5,22.62,23.19,22.47,20.53,19.53,19.59,18.94,17.88,17.56,19.25,21.38,22.03,22.28,23.72,24.44,23.41,21.81,21.62,22.06,21.28,19.53,18.62,18.28,17.59,15.75,14.91,16.06,17.16,17.47,17.56,19.03,20.66,20.0,18.69,18.44,18.56,17.84,16.59,16.47,17.38,17.69,16.5,15.38,16.03,16.75,16.69,16.34,18.06,19.47,19.25,17.72,17.16,17.06,16.59,15.84,16.34,18.56,20.97,21.66,22.03,23.56,24.12,22.91,21.19,20.91,21.06,20.5,19.12,18.78,19.41,19.41,18.59,18.38,19.72,20.88,20.41,19.69,19.94,20.44,19.31,17.53,17.47,18.59,18.88,18.16,17.97,18.09,17.69,15.97,15.72,17.72,20.44,21.75,22.84,24.94,26.56,26.31,25.03,24.91,25.0,24.25,22.5,21.56,21.47,21.62,20.91,21.28,23.59,26.44,27.78,28.44,30.06,31.28,30.28,28.41,27.81,27.81,27.5,26.69,26.91,28.5,29.5,29.41,29.09,29.94,31.03,29.97,29.28,30.09,31.22,31.75,31.75,32.97,34.88,36.41,36.66,36.84,37.66,37.09,33.72,30.06,26.81,24.06,20.38,17.88,18.34,20.59,22.91,25.28,29.81,34.91,39.69,43.09,46.44,49.5,50.78,49.16,46.38,43.75,40.88,36.41,31.62,28.38,26.31,23.69,20.44,19.03,19.0,19.16,18.66,20.12,23.75,27.69,30.44,33.03,36.41,39.38,39.31,38.12,37.75,37.28,35.47,32.88,30.88,29.25,27.06,23.44,20.72,19.53,18.62,17.09,16.19,17.28,18.78,18.75,18.22,18.59,19.81,20.62,21.75,24.81,29.16,32.84,34.75,36.03,37.66,38.41,37.25,35.94,35.75,35.81,33.91,31.5,30.31,29.75,28.28,25.59,23.44,21.78,18.69,14.34,11.41,10.75,11.41,11.84,13.12,15.28,17.66,18.19,17.69,18.47,20.5,22.38,23.84,26.38,29.62,32.0,31.59,31.22,31.28,31.56,30.06,28.47,28.22,28.5,27.16,24.91,23.41,22.94,21.69,19.0,17.44,17.03,16.34,14.31,13.0,13.0,13.38,12.56,11.19,11.28,12.38,11.91,11.34,11.25,12.47,12.94,12.69,14.03,17.75,22.5,25.81,28.97,31.94,33.78,32.31,30.16,29.0,28.66,27.41,25.97,25.69,26.31,25.94,24.56,23.28,22.84,22.38,20.25,18.56,18.56,19.09,18.47,17.72,18.19,19.28,19.22,18.44,18.69,20.38,21.25,20.81,20.91,21.81,22.47,21.12,19.59,19.09,19.47,18.56,17.34,17.66,19.06,19.16,18.25,18.25,20.34,21.97,21.97,22.53,24.03,25.0,23.97,23.19,24.38,26.41,26.81,26.91,27.41,27.75,26.38,23.41,20.66,19.75,19.22,17.81,18.0,20.22,22.91,23.72,23.91,24.5,25.06,23.69,21.53,21.16,22.75,24.38,25.62,27.53,30.28,31.53,30.0,27.88,26.38,25.44,22.84,20.62,20.12,20.78,20.38,19.53,20.44,22.72,23.56,23.34,22.81,23.03,22.59,20.66,19.56,20.62,22.19,22.16,21.78,22.56,23.88,23.03,21.72,21.62,22.88,23.19,22.62,22.31,22.84,22.31,19.91,18.03,17.25,17.53,16.44,15.19,15.12,15.69,14.44,12.53,11.81,12.53,13.28,13.16,13.53,15.5,16.69,15.91,15.25,15.81,16.72,15.88,14.94,15.19,16.88,17.34,16.94,17.31,18.75,19.31,18.38,17.69,19.16,19.88,19.31,18.56,18.97,20.25,19.44,18.41,18.56,19.5,19.09,17.41,15.75,14.75,13.06,10.66,8.84,9.22,9.94,9.19,8.41,9.41,11.56,12.34,13.09,14.28,15.72,15.72,14.12,13.28,14.25,15.0,14.84,15.44,17.38,18.88,17.91,16.5,15.91,15.81,14.34,13.56,13.72,15.03,15.41,14.69,14.0,14.12,13.03,10.5,8.72,9.59,11.56,12.91,14.5,17.28,20.41,21.41,21.5,21.78,23.06,22.84,21.56,21.62,23.5,25.25,25.88,25.88,27.06,27.69,25.94,24.19,23.72,24.34,23.84,23.09,23.78,25.75,26.62,26.41,26.12,26.28,25.72,22.88,19.94,19.25,19.22,18.28,17.56,18.88,21.0,21.34,21.34,21.66,23.03,23.0,21.56,20.25,20.25,19.97,18.5,17.09,17.44,18.41,17.84,17.25,18.22,20.06,20.03,19.5,18.88,19.47,19.28,18.19,17.94,19.41,20.69,20.75,20.81,21.72,23.0,22.38,20.94,20.66,21.31,20.84,19.59,19.09,19.88,19.59,18.66,18.19,19.66,21.84,22.94,24.16,27.09,30.44,31.34,31.25,31.47,31.16,28.69,24.69,20.69,18.09,15.03,11.62,9.66,10.41,12.09,12.88,14.0,17.16,21.0,23.25,25.41,28.5,32.31,34.12,34.44,34.53,35.44,35.53,33.81,32.0,31.28,30.34,28.22,25.94,25.22,25.5,24.09,21.81,21.19,21.88,21.56,20.66,20.59,21.91,23.12,23.34,23.16,24.72,26.03,25.03,23.34,22.91,23.41,22.75,21.44,21.41,22.38,22.06,20.78,19.53,20.62,20.62,19.72,19.0,20.34,21.94,22.19,22.06,23.22,24.69,24.84,24.12,24.31,25.44,25.59,24.91,24.94,26.56,27.28,26.0,23.66,22.38,21.03,18.47,16.31,16.41,17.97,18.38,17.56,17.75,18.62,18.34,17.16,16.75,18.12,19.5,18.91,18.38,19.22,20.09,18.91,17.03,16.25,16.34,15.03,13.09,12.69,13.44,13.53,12.5,12.16,13.72,15.19,104.12,105.97,107.16,106.84,106.19,105.84,105.41,104.38,103.44,102.25,100.69,98.56,95.91,93.62,92.31,91.72,91.62,91.94,92.41,92.56,92.81,92.34,92.31,92.34,92.06,91.44,91.31,91.41:37.62,35.38,34.62,35.56,36.62,36.19,36.44,37.97,39.5,39.16,38.25,38.31,39.03,38.88,38.12,39.19,41.44,43.25,43.84,44.84,46.19,46.81,45.03,42.81,41.72,41.16,39.41,37.62,37.44,38.44,38.12,36.69,36.31,37.19,37.09,35.81,35.41,36.09,36.81,35.81,34.69,35.09,35.94,35.41,34.47,35.22,36.88,38.25,38.66,40.12,42.5,44.16,44.19,44.47,46.0,47.44,46.94,46.28,46.56,46.94,45.88,44.16,43.69,44.5,45.19,44.94,45.41,46.88,47.25,45.97,44.84,44.91,44.94,43.56,42.12,41.72,42.22,41.66,40.66,40.69,41.22,40.72,38.81,36.97,36.03,34.97,33.06,31.91,32.53,34.06,34.31,34.41,35.72,37.75,38.53,38.09,38.75,39.84,40.25,39.09,38.31,38.66,38.44,36.47,34.22,33.0,32.31,29.97,27.44,26.91,27.41,27.56,27.28,28.41,30.41,31.72,31.28,31.25,32.22,33.56,33.47,33.78,35.5,37.53,37.78,37.31,37.09,37.75,37.22,36.53,36.84,38.09,38.88,37.72,36.56,36.22,35.69,33.78,32.16,32.03,32.91,32.75,32.31,32.91,34.44,34.75,34.06,34.5,35.75,36.97,36.81,37.0,38.06,39.5,39.31,39.19,40.38,42.22,42.22,41.38,40.66,40.81,39.81,38.5,38.12,39.03,39.72,38.56,37.28,36.59,36.19,33.62,30.78,29.31,29.22,28.34,27.66,28.19,30.56,32.25,32.59,33.38,35.44,37.12,36.88,36.69,37.03,37.56,36.16,34.03,33.25,33.56,33.09,31.88,31.69,32.34,32.41,31.25,30.38,30.78,31.97,31.84,32.06,34.03,36.69,37.84,37.97,39.81,42.59,44.44,45.38,46.12,47.91,47.72,45.84,43.91,43.5,43.38,42.03,40.62,40.66,41.0,40.06,38.44,37.81,38.25,37.06,34.56,32.22,31.53,31.12,30.06,30.41,32.25,34.19,34.03,33.56,34.03,35.59,36.38,36.44,37.94,40.47,41.12,40.03,38.44,37.56,35.75,33.03,31.12,31.22,31.94,31.28,30.44,31.03,32.34,32.34,31.72,32.19,33.84,34.72,34.72,35.22,37.03,38.56,38.25,38.0,39.19,40.56,40.53,40.31,41.16,42.66,42.72,41.41,40.44,40.5,40.12,38.34,37.0,37.31,36.72,34.5,31.69,30.41,29.5,27.94,26.28,26.09,26.59,26.62,26.16,26.59,29.22,32.12,34.47,36.66,40.16,42.06,42.03,40.97,40.41,40.28,38.72,37.22,37.22,38.53,39.09,38.62,38.41,38.69,38.16,36.47,34.97,35.34,35.56,34.19,32.56,32.34,32.62,31.84,30.97,31.28,33.28,34.09,34.09,34.09,34.94,35.44,34.5,34.22,35.97,37.19,36.44,34.69,33.84,33.22,31.59,30.16,29.75,30.62,30.31,28.97,27.41,27.47,27.75,27.28,27.75,30.12,32.72,33.5,33.34,34.22,35.25,35.38,34.41,33.59,33.62,32.81,30.56,28.88,29.03,29.41,28.66,27.72,28.81,30.06,30.0,29.69,30.69,32.16,32.16,31.19,30.38,30.66,29.91,28.31,27.34,27.78,28.66,28.12,27.16,27.59,28.06,27.09,25.81,25.78,26.44,25.81,24.66,24.38,25.5,26.41,26.22,25.91,26.34,26.19,24.12,21.75,20.88,20.38,18.69,16.5,16.19,17.56,18.69,19.53,21.53,24.84,27.56,28.28,28.38,29.22,28.97,26.41,23.5,22.53,22.34,21.22,19.5,18.97,19.38,18.78,17.44,16.88,18.28,19.41,19.22,18.91,20.03,21.03,20.0,18.75,18.91,19.94,20.16,19.78,20.31,22.0,23.09,23.0,23.0,24.12,24.84,23.97,22.81,23.12,24.03,23.69,22.5,22.62,23.19,22.47,20.53,19.53,19.59,18.94,17.88,17.56,19.25,21.38,22.03,22.28,23.72,24.44,23.41,21.81,21.62,22.06,21.28,19.53,18.62,18.28,17.59,15.75,14.91,16.06,17.16,17.47,17.56,19.03,20.66,20.0,18.69,18.44,18.56,17.84,16.59,16.47,17.38,17.69,16.5,15.38,16.03,16.75,16.69,16.34,18.06,19.47,19.25,17.72,17.16,17.06,16.59,15.84,16.34,18.56,20.97,21.66,22.03,23.56,24.12,22.91,21.19,20.91,21.06,20.5,19.12,18.78,19.41,19.41,18.59,18.38,19.72,20.88,20.41,19.69,19.94,20.44,19.31,17.53,17.47,18.59,18.88,18.16,17.97,18.09,17.69,15.97,15.72,17.72,20.44,21.75,22.84,24.94,26.56,26.31,25.03,24.91,25.0,24.25,22.5,21.56,21.47,21.62,20.91,21.28,23.59,26.44,27.78,28.44,30.06,31.28,30.28,28.41,27.81,27.81,27.5,26.69,26.91,28.5,29.5,29.41,29.09,29.94,31.03,29.97,29.28,30.09,31.22,31.75,31.75,32.97,34.88,36.41,36.66,36.84,37.66,37.09,33.72,30.06,26.81,24.06,20.38,17.88,18.34,20.59,22.91,25.28,29.81,34.91,39.69,43.09,46.44,49.5,50.78,49.16,46.38,43.75,40.88,36.41,31.62,28.38,26.31,23.69,20.44,19.03,19.0,19.16,18.66,20.12,23.75,27.69,30.44,33.03,36.41,39.38,39.31,38.12,37.75,37.28,35.47,32.88,30.88,29.25,27.06,23.44,20.72,19.53,18.62,17.09,16.19,17.28,18.78,18.75,18.22,18.59,19.81,20.62,21.75,24.81,29.16,32.84,34.75,36.03,37.66,38.41,37.25,35.94,35.75,35.81,33.91,31.5,30.31,29.75,28.28,25.59,23.44,21.78,18.69,14.34,11.41,10.75,11.41,11.84,13.12,15.28,17.66,18.19,17.69,18.47,20.5,22.38,23.84,26.38,29.62,32.0,31.59,31.22,31.28,31.56,30.06,28.47,28.22,28.5,27.16,24.91,23.41,22.94,21.69,19.0,17.44,17.03,16.34,14.31,13.0,13.0,13.38,12.56,11.19,11.28,12.38,11.91,11.34,11.25,12.47,12.94,12.69,14.03,17.75,22.5,25.81,28.97,31.94,33.78,32.31,30.16,29.0,28.66,27.41,25.97,25.69,26.31,25.94,24.56,23.28,22.84,22.38,20.25,18.56,18.56,19.09,18.47,17.72,18.19,19.28,19.22,18.44,18.69,20.38,21.25,20.81,20.91,21.81,22.47,21.12,19.59,19.09,19.47,18.56,17.34,17.66,19.06,19.16,18.25,18.25,20.34,21.97,21.97,22.53,24.03,25.0,23.97,23.19,24.38,26.41,26.81,26.91,27.41,27.75,26.38,23.41,20.66,19.75,19.22,17.81,18.0,20.22,22.91,23.72,23.91,24.5,25.06,23.69,21.53,21.16,22.75,24.38,25.62,27.53,30.28,31.53,30.0,27.88,26.38,25.44,22.84,20.62,20.12,20.78,20.38,19.53,20.44,22.72,23.56,23.34,22.81,23.03,22.59,20.66,19.56,20.62,22.19,22.16,21.78,22.56,23.88,23.03,21.72,21.62,22.88,23.19,22.62,22.31,22.84,22.31,19.91,18.03,17.25,17.53,16.44,15.19,15.12,15.69,14.44,12.53,11.81,12.53,13.28,13.16,13.53,15.5,16.69,15.91,15.25,15.81,16.72,15.88,14.94,15.19,16.88,17.34,16.94,17.31,18.75,19.31,18.38,17.69,19.16,19.88,19.31,18.56,18.97,20.25,19.44,18.41,18.56,19.5,19.09,17.41,15.75,14.75,13.06,10.66,8.84,9.22,9.94,9.19,8.41,9.41,11.56,12.34,13.09,14.28,15.72,15.72,14.12,13.28,14.25,15.0,14.84,15.44,17.38,18.88,17.91,16.5,15.91,15.81,14.34,13.56,13.72,15.03,15.41,14.69,14.0,14.12,13.03,10.5,8.72,9.59,11.56,12.91,14.5,17.28,20.41,21.41,21.5,21.78,23.06,22.84,21.56,21.62,23.5,25.25,25.88,25.88,27.06,27.69,25.94,24.19,23.72,24.34,23.84,23.09,23.78,25.75,26.62,26.41,26.12,26.28,25.72,22.88,19.94,19.25,19.22,18.28,17.56,18.88,21.0,21.34,21.34,21.66,23.03,23.0,21.56,20.25,20.25,19.97,18.5,17.09,17.44,18.41,17.84,17.25,18.22,20.06,20.03,19.5,18.88,19.47,19.28,18.19,17.94,19.41,20.69,20.75,20.81,21.72,23.0,22.38,20.94,20.66,21.31,20.84,19.59,19.09,19.88,19.59,18.66,18.19,19.66,21.84,22.94,24.16,27.09,30.44,31.34,31.25,31.47,31.16,28.69,24.69,20.69,18.09,15.03,11.62,9.66,10.41,12.09,12.88,14.0,17.16,21.0,23.25,25.41,28.5,32.31,34.12,34.44,34.53,35.44,35.53,33.81,32.0,31.28,30.34,28.22,25.94,25.22,25.5,24.09,21.81,21.19,21.88,21.56,20.66,20.59,21.91,23.12,23.34,23.16,24.72,26.03,25.03,23.34,22.91,23.41,22.75,21.44,21.41,22.38,22.06,20.78,19.53,20.62,20.62,19.72,19.0,20.34,21.94,22.19,22.06,23.22,24.69,24.84,24.12,24.31,25.44,25.59,24.91,24.94,26.56,27.28,26.0,23.66,22.38,21.03,18.47,16.31,16.41,17.97,18.38,17.56,17.75,18.62,18.34,17.16,16.75,18.12,19.5,18.91,18.38,19.22,20.09,18.91,17.03,16.25,16.34,15.03,13.09,12.69,13.44,13.53,12.5,12.16,13.72,15.19,104.12,105.97,107.16,106.84,106.19,105.84,105.41,104.38,103.44,102.25,100.69,98.56,95.91,93.62,92.31,91.72,91.62,91.94,92.41,92.56,92.81,92.34,92.31,92.34,92.06,91.44,91.31,91.41,92.0,92.47,93.09,93.62,94.0,93.88,93.28:37.97,39.5,39.16,38.25,38.31,39.03,38.88,38.12,39.19,41.44,43.25,43.84,44.84,46.19,46.81,45.03,42.81,41.72,41.16,39.41,37.62,37.44,38.44,38.12,36.69,36.31,37.19,37.09,35.81,35.41,36.09,36.81,35.81,34.69,35.09,35.94,35.41,34.47,35.22,36.88,38.25,38.66,40.12,42.5,44.16,44.19,44.47,46.0,47.44,46.94,46.28,46.56,46.94,45.88,44.16,43.69,44.5,45.19,44.94,45.41,46.88,47.25,45.97,44.84,44.91,44.94,43.56,42.12,41.72,42.22,41.66,40.66,40.69,41.22,40.72,38.81,36.97,36.03,34.97,33.06,31.91,32.53,34.06,34.31,34.41,35.72,37.75,38.53,38.09,38.75,39.84,40.25,39.09,38.31,38.66,38.44,36.47,34.22,33.0,32.31,29.97,27.44,26.91,27.41,27.56,27.28,28.41,30.41,31.72,31.28,31.25,32.22,33.56,33.47,33.78,35.5,37.53,37.78,37.31,37.09,37.75,37.22,36.53,36.84,38.09,38.88,37.72,36.56,36.22,35.69,33.78,32.16,32.03,32.91,32.75,32.31,32.91,34.44,34.75,34.06,34.5,35.75,36.97,36.81,37.0,38.06,39.5,39.31,39.19,40.38,42.22,42.22,41.38,40.66,40.81,39.81,38.5,38.12,39.03,39.72,38.56,37.28,36.59,36.19,33.62,30.78,29.31,29.22,28.34,27.66,28.19,30.56,32.25,32.59,33.38,35.44,37.12,36.88,36.69,37.03,37.56,36.16,34.03,33.25,33.56,33.09,31.88,31.69,32.34,32.41,31.25,30.38,30.78,31.97,31.84,32.06,34.03,36.69,37.84,37.97,39.81,42.59,44.44,45.38,46.12,47.91,47.72,45.84,43.91,43.5,43.38,42.03,40.62,40.66,41.0,40.06,38.44,37.81,38.25,37.06,34.56,32.22,31.53,31.12,30.06,30.41,32.25,34.19,34.03,33.56,34.03,35.59,36.38,36.44,37.94,40.47,41.12,40.03,38.44,37.56,35.75,33.03,31.12,31.22,31.94,31.28,30.44,31.03,32.34,32.34,31.72,32.19,33.84,34.72,34.72,35.22,37.03,38.56,38.25,38.0,39.19,40.56,40.53,40.31,41.16,42.66,42.72,41.41,40.44,40.5,40.12,38.34,37.0,37.31,36.72,34.5,31.69,30.41,29.5,27.94,26.28,26.09,26.59,26.62,26.16,26.59,29.22,32.12,34.47,36.66,40.16,42.06,42.03,40.97,40.41,40.28,38.72,37.22,37.22,38.53,39.09,38.62,38.41,38.69,38.16,36.47,34.97,35.34,35.56,34.19,32.56,32.34,32.62,31.84,30.97,31.28,33.28,34.09,34.09,34.09,34.94,35.44,34.5,34.22,35.97,37.19,36.44,34.69,33.84,33.22,31.59,30.16,29.75,30.62,30.31,28.97,27.41,27.47,27.75,27.28,27.75,30.12,32.72,33.5,33.34,34.22,35.25,35.38,34.41,33.59,33.62,32.81,30.56,28.88,29.03,29.41,28.66,27.72,28.81,30.06,30.0,29.69,30.69,32.16,32.16,31.19,30.38,30.66,29.91,28.31,27.34,27.78,28.66,28.12,27.16,27.59,28.06,27.09,25.81,25.78,26.44,25.81,24.66,24.38,25.5,26.41,26.22,25.91,26.34,26.19,24.12,21.75,20.88,20.38,18.69,16.5,16.19,17.56,18.69,19.53,21.53,24.84,27.56,28.28,28.38,29.22,28.97,26.41,23.5,22.53,22.34,21.22,19.5,18.97,19.38,18.78,17.44,16.88,18.28,19.41,19.22,18.91,20.03,21.03,20.0,18.75,18.91,19.94,20.16,19.78,20.31,22.0,23.09,23.0,23.0,24.12,24.84,23.97,22.81,23.12,24.03,23.69,22.5,22.62,23.19,22.47,20.53,19.53,19.59,18.94,17.88,17.56,19.25,21.38,22.03,22.28,23.72,24.44,23.41,21.81,21.62,22.06,21.28,19.53,18.62,18.28,17.59,15.75,14.91,16.06,17.16,17.47,17.56,19.03,20.66,20.0,18.69,18.44,18.56,17.84,16.59,16.47,17.38,17.69,16.5,15.38,16.03,16.75,16.69,16.34,18.06,19.47,19.25,17.72,17.16,17.06,16.59,15.84,16.34,18.56,20.97,21.66,22.03,23.56,24.12,22.91,21.19,20.91,21.06,20.5,19.12,18.78,19.41,19.41,18.59,18.38,19.72,20.88,20.41,19.69,19.94,20.44,19.31,17.53,17.47,18.59,18.88,18.16,17.97,18.09,17.69,15.97,15.72,17.72,20.44,21.75,22.84,24.94,26.56,26.31,25.03,24.91,25.0,24.25,22.5,21.56,21.47,21.62,20.91,21.28,23.59,26.44,27.78,28.44,30.06,31.28,30.28,28.41,27.81,27.81,27.5,26.69,26.91,28.5,29.5,29.41,29.09,29.94,31.03,29.97,29.28,30.09,31.22,31.75,31.75,32.97,34.88,36.41,36.66,36.84,37.66,37.09,33.72,30.06,26.81,24.06,20.38,17.88,18.34,20.59,22.91,25.28,29.81,34.91,39.69,43.09,46.44,49.5,50.78,49.16,46.38,43.75,40.88,36.41,31.62,28.38,26.31,23.69,20.44,19.03,19.0,19.16,18.66,20.12,23.75,27.69,30.44,33.03,36.41,39.38,39.31,38.12,37.75,37.28,35.47,32.88,30.88,29.25,27.06,23.44,20.72,19.53,18.62,17.09,16.19,17.28,18.78,18.75,18.22,18.59,19.81,20.62,21.75,24.81,29.16,32.84,34.75,36.03,37.66,38.41,37.25,35.94,35.75,35.81,33.91,31.5,30.31,29.75,28.28,25.59,23.44,21.78,18.69,14.34,11.41,10.75,11.41,11.84,13.12,15.28,17.66,18.19,17.69,18.47,20.5,22.38,23.84,26.38,29.62,32.0,31.59,31.22,31.28,31.56,30.06,28.47,28.22,28.5,27.16,24.91,23.41,22.94,21.69,19.0,17.44,17.03,16.34,14.31,13.0,13.0,13.38,12.56,11.19,11.28,12.38,11.91,11.34,11.25,12.47,12.94,12.69,14.03,17.75,22.5,25.81,28.97,31.94,33.78,32.31,30.16,29.0,28.66,27.41,25.97,25.69,26.31,25.94,24.56,23.28,22.84,22.38,20.25,18.56,18.56,19.09,18.47,17.72,18.19,19.28,19.22,18.44,18.69,20.38,21.25,20.81,20.91,21.81,22.47,21.12,19.59,19.09,19.47,18.56,17.34,17.66,19.06,19.16,18.25,18.25,20.34,21.97,21.97,22.53,24.03,25.0,23.97,23.19,24.38,26.41,26.81,26.91,27.41,27.75,26.38,23.41,20.66,19.75,19.22,17.81,18.0,20.22,22.91,23.72,23.91,24.5,25.06,23.69,21.53,21.16,22.75,24.38,25.62,27.53,30.28,31.53,30.0,27.88,26.38,25.44,22.84,20.62,20.12,20.78,20.38,19.53,20.44,22.72,23.56,23.34,22.81,23.03,22.59,20.66,19.56,20.62,22.19,22.16,21.78,22.56,23.88,23.03,21.72,21.62,22.88,23.19,22.62,22.31,22.84,22.31,19.91,18.03,17.25,17.53,16.44,15.19,15.12,15.69,14.44,12.53,11.81,12.53,13.28,13.16,13.53,15.5,16.69,15.91,15.25,15.81,16.72,15.88,14.94,15.19,16.88,17.34,16.94,17.31,18.75,19.31,18.38,17.69,19.16,19.88,19.31,18.56,18.97,20.25,19.44,18.41,18.56,19.5,19.09,17.41,15.75,14.75,13.06,10.66,8.84,9.22,9.94,9.19,8.41,9.41,11.56,12.34,13.09,14.28,15.72,15.72,14.12,13.28,14.25,15.0,14.84,15.44,17.38,18.88,17.91,16.5,15.91,15.81,14.34,13.56,13.72,15.03,15.41,14.69,14.0,14.12,13.03,10.5,8.72,9.59,11.56,12.91,14.5,17.28,20.41,21.41,21.5,21.78,23.06,22.84,21.56,21.62,23.5,25.25,25.88,25.88,27.06,27.69,25.94,24.19,23.72,24.34,23.84,23.09,23.78,25.75,26.62,26.41,26.12,26.28,25.72,22.88,19.94,19.25,19.22,18.28,17.56,18.88,21.0,21.34,21.34,21.66,23.03,23.0,21.56,20.25,20.25,19.97,18.5,17.09,17.44,18.41,17.84,17.25,18.22,20.06,20.03,19.5,18.88,19.47,19.28,18.19,17.94,19.41,20.69,20.75,20.81,21.72,23.0,22.38,20.94,20.66,21.31,20.84,19.59,19.09,19.88,19.59,18.66,18.19,19.66,21.84,22.94,24.16,27.09,30.44,31.34,31.25,31.47,31.16,28.69,24.69,20.69,18.09,15.03,11.62,9.66,10.41,12.09,12.88,14.0,17.16,21.0,23.25,25.41,28.5,32.31,34.12,34.44,34.53,35.44,35.53,33.81,32.0,31.28,30.34,28.22,25.94,25.22,25.5,24.09,21.81,21.19,21.88,21.56,20.66,20.59,21.91,23.12,23.34,23.16,24.72,26.03,25.03,23.34,22.91,23.41,22.75,21.44,21.41,22.38,22.06,20.78,19.53,20.62,20.62,19.72,19.0,20.34,21.94,22.19,22.06,23.22,24.69,24.84,24.12,24.31,25.44,25.59,24.91,24.94,26.56,27.28,26.0,23.66,22.38,21.03,18.47,16.31,16.41,17.97,18.38,17.56,17.75,18.62,18.34,17.16,16.75,18.12,19.5,18.91,18.38,19.22,20.09,18.91,17.03,16.25,16.34,15.03,13.09,12.69,13.44,13.53,12.5,12.16,13.72,15.19,104.12,105.97,107.16,106.84,106.19,105.84,105.41,104.38,103.44,102.25,100.69,98.56,95.91,93.62,92.31,91.72,91.62,91.94,92.41,92.56,92.81,92.34,92.31,92.34,92.06,91.44,91.31,91.41,92.0,92.47,93.09,93.62,94.0,93.88,93.28,93.22,93.19,93.22,93.06,92.94,93.03,93.0:negativity
32.91,33.88,34.62,34.69,36.5,39.47,42.09,43.53,44.94,46.75,47.69,46.19,43.47,41.62,40.0,37.91,35.62,35.25,36.19,36.84,36.81,37.72,39.88,41.59,41.59,41.59,42.53,43.06,41.91,39.72,38.78,38.31,36.5,34.19,33.97,34.88,35.22,34.38,34.31,35.12,35.25,34.72,34.5,36.09,38.03,38.75,38.62,39.66,41.12,40.78,39.78,39.78,40.62,40.84,39.78,39.12,39.41,39.06,37.25,35.59,35.81,37.09,37.75,38.44,40.19,42.31,43.53,42.88,42.81,43.97,44.91,44.16,44.16,45.28,46.09,44.66,42.88,42.41,41.72,38.78,35.31,33.19,32.09,31.31,31.0,32.94,36.56,39.97,41.78,43.88,46.59,48.5,48.69,48.28,48.47,48.88,47.5,45.5,44.81,44.59,44.16,43.34,43.47,45.0,45.69,44.53,43.41,43.22,42.38,40.62,39.0,38.44,38.88,38.28,36.88,36.5,37.16,36.88,35.44,34.81,35.53,35.69,34.31,33.75,34.78,35.97,36.44,36.59,38.0,39.34,38.59,36.41,34.91,34.59,33.66,32.19,31.31,31.62,31.38,29.28,27.44,27.5,28.16,28.03,28.28,29.72,32.44,34.12,35.38,37.5,40.94,43.59,44.22,44.5,45.12,45.03,42.53,39.78,38.38,36.94,34.38,31.72,30.28,30.34,29.59,28.31,28.19,29.88,31.78,32.69,34.38,37.0,39.31,39.66,39.38,39.84,40.62,39.88,37.62,36.59,36.19,34.66,31.88,29.53,28.22,26.59,24.59,23.66,25.25,27.84,29.25,30.16,31.69,33.47,33.28,32.09,32.03,33.5,34.5,35.03,37.09,40.81,43.78,45.0,46.06,47.25,47.41,44.88,41.16,38.34,36.16,32.88,29.41,27.12,25.97,24.59,22.19,20.72,21.31,22.12,22.12,22.91,26.06,29.5,31.34,32.25,33.75,35.84,36.66,36.94,38.22,40.66,41.53,40.38,39.25,39.59,39.88,38.34,37.03,36.59,36.0,34.16,31.94,31.41,32.25,32.25,31.38,30.78,30.84,29.56,26.56,23.66,22.72,22.22,21.5,21.38,23.34,26.0,26.88,26.78,27.66,29.03,29.41,28.81,28.94,30.0,30.81,30.19,29.91,31.38,32.78,33.03,32.81,33.94,35.66,35.59,35.16,35.28,36.19,36.06,34.41,33.72,33.97,33.91,32.12,31.03,31.81,33.44,34.38,35.75,38.34,41.53,42.41,42.12,42.19,43.62,44.5,43.78,43.75,44.78,44.91,43.41,41.44,41.5,42.0,41.06,40.31,41.09,42.12,41.25,39.25,37.5,36.66,35.0,32.97,31.5,32.31,33.34,32.81,32.09,33.06,34.09,33.59,33.06,33.81,35.94,37.09,37.81,38.94,41.69,42.75,41.62,39.75,38.66,37.28,34.38,31.28,29.62,27.94,24.59,20.91,18.44,17.66,16.69,15.62,15.47,17.94,19.78,20.91,22.16,24.69,27.06,27.28,26.88,27.97,29.81,30.5,30.94,32.06,33.94,34.56,33.78,33.53,35.03,35.81,35.34,34.81,35.34,35.72,34.09,31.81,30.25,29.38,27.69,25.69,25.84,27.62,28.88,29.44,30.72,33.41,35.47,36.19,36.62,37.97,39.34,38.69,37.38,36.94,36.75,34.97,32.22,30.97,31.12,31.09,30.31,29.84,30.88,31.16,29.03,26.31,24.72,23.44,20.72,18.66,19.25,21.59,23.28,24.28,25.97,28.09,28.59,27.31,26.41,27.12,28.62,28.97,29.88,32.38,34.69,34.5,32.47,31.31,30.41,29.22,27.78,28.25,30.75,32.91,33.44,33.72,34.94,35.62,34.59,33.25,33.62,34.75,34.38,32.78,32.19,31.94,30.81,28.16,26.62,26.88,26.88,25.72,24.97,26.09,27.38,27.34,27.09,28.62,31.28,32.06,32.19,32.84,34.0,33.53,31.53,30.19,29.94,29.53,28.41,27.81,29.0,30.09,29.22,27.78,27.59,28.28,27.81,26.91,27.47,28.91,29.53,28.41,27.28,26.97,26.0,23.5,21.34,21.19,21.69,20.53,18.03,17.22,17.22,16.84,16.91,18.62,22.16,24.53,24.66,24.31,24.94,24.97,23.5,22.22,23.38,24.84,25.09,23.88,23.5,23.66,22.53,20.72,20.81,22.0,22.78,21.72,21.12,22.06,22.66,21.97,20.75,21.03,21.44,20.44,19.22,19.56,20.56,21.0,20.62,21.5,23.72,25.69,25.97,25.53,25.28,24.19,21.41,18.38,17.75,19.22,20.81,22.28,25.97,30.25,33.09,34.28,35.06,36.53,37.03,35.25,33.25,32.59,31.78,29.66,27.53,27.84,29.22,30.97,32.41,35.72,39.91,42.47,42.53,41.66,41.09,39.78,37.31,35.31,35.47,35.69,34.34,32.06,31.47,30.91,30.06,28.75,28.88,30.5,31.44,31.28,31.75,33.81,35.28,35.81,36.75,39.88,43.31,45.66,47.16,48.84,49.69,48.09,43.84,39.88,36.88,33.56,29.78,27.28,27.28,27.5,26.28,25.62,27.19,29.31,30.69,31.84,34.47,38.0,40.22,41.34,43.47,46.53,48.41,48.31,47.59,47.28,45.53,41.19,36.19,32.66,30.0,27.22,24.62,24.28,25.62,26.62,26.28,26.94,28.47,29.44,28.69,27.75,28.44,29.16,28.34,26.88,26.72,26.44,24.5,21.53,19.94,20.31,21.72,22.66,24.91,28.62,30.62,30.94,30.41,31.12,31.53,30.81,29.94,30.81,32.47,33.41,33.94,35.38,37.88,39.53,39.84,40.66,42.88,44.38,43.56,41.84,40.44,38.56,34.75,30.91,28.81,27.72,25.84,23.78,23.22,24.41,26.31,27.66,30.09,34.16,37.88,39.28,40.06,42.09,43.69,43.69,42.38,42.53,42.56,41.03,37.81,35.22,33.97,32.75,30.72,29.72,30.31,31.16,30.22,29.12,29.62,30.69,30.44,29.84,30.22,31.5,31.69,30.88,30.91,32.44,33.66,33.38,33.12,34.47,35.81,35.12,33.88,33.91,34.06,33.19,31.38,30.53,30.94,30.84,29.44,29.0,30.66,32.78,33.25,34.38,36.22,37.56,36.72,35.09,34.56,34.41,33.66,32.09,32.22,33.28,33.84,33.59,33.28,33.78,34.19,32.41,31.09,31.41,32.44,31.91,30.88,30.78,31.28,30.47,28.78,28.34,29.38,29.66,29.41,29.44,30.84,31.81,30.91,29.38,29.41,29.81,28.91,27.44,27.5,28.47,28.44,27.78,28.19,29.53,30.44,30.12,29.91,31.25,32.69,32.41,32.41,33.34,35.06,35.41,35.47,36.34,38.38,39.72,39.38,39.12,39.41,38.78,36.69,34.75,34.5,34.53,33.12,31.47,30.53,30.28,28.56,26.41,26.06,27.09,27.94,27.75,28.97,31.25,32.81,32.31,31.34,31.53,31.75,30.75,30.22,31.38,33.19,33.97,33.31,33.28,34.22,34.34,33.16,32.0,31.94,31.56,29.78,28.19,28.25,29.38,29.03,28.69,29.19,30.53,30.09,28.53,27.88,28.53,28.75,28.41,28.81,30.75,32.44,32.62,32.22,32.56,32.81,31.19,28.97,27.88,27.75,26.66,25.22,24.69,25.66,26.84,26.84,27.47,29.47,31.41,31.59,31.25,32.34,33.66,33.44,33.06,33.62,35.31,35.38,34.06,32.81,32.44,31.59,30.06,29.5,30.75,32.5,32.12,30.69,29.62,29.22,27.09,24.97,24.31,25.25,24.78,23.28,22.41,22.75,22.5,21.03,19.69,19.72,20.5,19.09,18.16,18.66,20.0,21.0,21.75,23.59,26.56,28.84,29.69,31.12,33.56,35.38,35.66,35.16,35.34,35.41,33.66,31.03,29.09,28.12,26.19,23.69,22.06,22.47,21.91,20.78,20.19,21.16,22.72,22.69,22.59,24.03,25.59,25.62,25.53,26.38,27.91,28.19,27.44,26.91,27.12,26.69,24.84,23.5,24.06,24.78,24.5,24.41,25.5,26.81,26.66,25.38,24.84,25.34,24.5,23.12,22.59,23.72,24.19,23.44,22.62,23.53,24.5,24.38,24.19,24.91,26.12,25.84,24.78,24.84,26.12,26.56,26.06,25.88,26.44,26.5,24.66,23.09,23.62,24.62,24.78,25.0,26.47,28.5,29.0,28.88,29.62,31.66,32.44,32.19,31.75,32.53,32.34,30.75,29.03,28.97,29.47,29.16,29.09,30.22,31.94,32.12,31.09,30.38,30.91,30.94,29.62,28.19,27.5,26.78,24.81,23.69,25.59,28.72,31.41,33.25,35.22,36.38,35.16,31.66,28.19,26.0,23.91,22.0,21.81,23.38,25.22,24.97,24.12,23.66,23.5,22.62,21.41,21.25,22.12,21.78,20.97,20.94,23.0,25.44,27.41,30.03,33.97,37.84,40.59,42.56,45.5,47.94,47.94,45.78,43.41,40.81,36.22,30.5,25.72,22.53,19.91,17.22,15.69,16.25,17.09,16.78,16.09,17.09,18.75,20.38,21.75,24.41,28.75,32.22,33.94,35.81,38.62,40.88,41.16,41.19,42.34,43.25,42.31,40.22,39.25,38.34,36.72,33.78,32.0,32.0,31.53,30.41,29.94,31.22,32.16,31.69,30.41,30.25,30.12,28.75,26.69,26.03,26.19,26.0,25.31,25.94,28.38,30.38,30.56,30.34,30.88,30.31,28.31,26.25,25.41,25.88,25.44,24.25,24.59,26.47,27.78,28.62,30.22,33.0,34.94,35.0,34.94,36.19,37.16,37.34,37.12,37.97,38.62,37.62,35.19,33.56,32.25,30.66,28.44,27.28,27.81,28.12,28.16,28.25,29.78,31.28,31.53,31.12,31.84,33.09,33.12,32.06,31.62,31.88,31.59,29.91,28.91,29.66,30.06,29.22,28.12,28.06,28.12,26.78,25.16,24.44:43.53,44.94,46.75,47.69,46.19,43.47,41.62,40.0,37.91,35.62,35.25,36.19,36.84,36.81,37.72,39.88,41.59,41.59,41.59,42.53,43.06,41.91,39.72,38.78,38.31,36.5,34.19,33.97,34.88,35.22,34.38,34.31,35.12,35.25,34.72,34.5,36.09,38.03,38.75,38.62,39.66,41.12,40.78,39.78,39.78,40.62,40.84,39.78,39.12,39.41,39.06,37.25,35.59,35.81,37.09,37.75,38.44,40.19,42.31,43.53,42.88,42.81,43.97,44.91,44.16,44.16,45.28,46.09,44.66,42.88,42.41,41.72,38.78,35.31,33.19,32.09,31.31,31.0,32.94,36.56,39.97,41.78,43.88,46.59,48.5,48.69,48.28,48.47,48.88,47.5,45.5,44.81,44.59,44.16,43.34,43.47,45.0,45.69,44.53,43.41,43.22,42.38,40.62,39.0,38.44,38.88,38.28,36.88,36.5,37.16,36.88,35.44,34.81,35.53,35.69,34.31,33.75,34.78,35.97,36.44,36.59,38.0,39.34,38.59,36.41,34.91,34.59,33.66,32.19,31.31,31.62,31.38,29.28,27.44,27.5,28.16,28.03,28.28,29.72,32.44,34.12,35.38,37.5,40.94,43.59,44.22,44.5,45.12,45.03,42.53,39.78,38.38,36.94,34.38,31.72,30.28,30.34,29.59,28.31,28.19,29.88,31.78,32.69,34.38,37.0,39.31,39.66,39.38,39.84,40.62,39.88,37.62,36.59,36.19,34.66,31.88,29.53,28.22,26.59,24.59,23.66,25.25,27.84,29.25,30.16,31.69,33.47,33.28,32.09,32.03,33.5,34.5,35.03,37.09,40.81,43.78,45.0,46.06,47.25,47.41,44.88,41.16,38.34,36.16,32.88,29.41,27.12,25.97,24.59,22.19,20.72,21.31,22.12,22.12,22.91,26.06,29.5,31.34,32.25,33.75,35.84,36.66,36.94,38.22,40.66,41.53,40.38,39.25,39.59,39.88,38.34,37.03,36.59,36.0,34.16,31.94,31.41,32.25,32.25,31.38,30.78,30.84,29.56,26.56,23.66,22.72,22.22,21.5,21.38,23.34,26.0,26.88,26.78,27.66,29.03,29.41,28.81,28.94,30.0,30.81,30.19,29.91,31.38,32.78,33.03,32.81,33.94,35.66,35.59,35.16,35.28,36.19,36.06,34.41,33.72,33.97,33.91,32.12,31.03,31.81,33.44,34.38,35.75,38.34,41.53,42.41,42.12,42.19,43.62,44.5,43.78,43.75,44.78,44.91,43.41,41.44,41.5,42.0,41.06,40.31,41.09,42.12,41.25,39.25,37.5,36.66,35.0,32.97,31.5,32.31,33.34,32.81,32.09,33.06,34.09,33.59,33.06,33.81,35.94,37.09,37.81,38.94,41.69,42.75,41.62,39.75,38.66,37.28,34.38,31.28,29.62,27.94,24.59,20.91,18.44,17.66,16.69,15.62,15.47,17.94,19.78,20.91,22.16,24.69,27.06,27.28,26.88,27.97,29.81,30.5,30.94,32.06,33.94,34.56,33.78,33.53,35.03,35.81,35.34,34.81,35.34,35.72,34.09,31.81,30.25,29.38,27.69,25.69,25.84,27.62,28.88,29.44,30.72,33.41,35.47,36.19,36.62,37.97,39.34,38.69,37.38,36.94,36.75,34.97,32.22,30.97,31.12,31.09,30.31,29.84,30.88,31.16,29.03,26.31,24.72,23.44,20.72,18.66,19.25,21.59,23.28,24.28,25.97,28.09,28.59,27.31,26.41,27.12,28.62,28.97,29.88,32.38,34.69,34.5,32.47,31.31,30.41,29.22,27.78,28.25,30.75,32.91,33.44,33.72,34.94,35.62,34.59,33.25,33.62,34.75,34.38,32.78,32.19,31.94,30.81,28.16,26.62,26.88,26.88,25.72,24.97,26.09,27.38,27.34,27.09,28.62,31.28,32.06,32.19,32.84,34.0,33.53,31.53,30.19,29.94,29.53,28.41,27.81,29.0,30.09,29.22,27.78,27.59,28.28,27.81,26.91,27.47,28.91,29.53,28.41,27.28,26.97,26.0,23.5,21.34,21.19,21.69,20.53,18.03,17.22,17.22,16.84,16.91,18.62,22.16,24.53,24.66,24.31,24.94,24.97,23.5,22.22,23.38,24.84,25.09,23.88,23.5,23.66,22.53,20.72,20.81,22.0,22.78,21.72,21.12,22.06,22.66,21.97,20.75,21.03,21.44,20.44,19.22,19.56,20.56,21.0,20.62,21.5,23.72,25.69,25.97,25.53,25.28,24.19,21.41,18.38,17.75,19.22,20.81,22.28,25.97,30.25,33.09,34.28,35.06,36.53,37.03,35.25,33.25,32.59,31.78,29.66,27.53,27.84,29.22,30.97,32.41,35.72,39.91,42.47,42.53,41.66,41.09,39.78,37.31,35.31,35.47,35.69,34.34,32.06,31.47,30.91,30.06,28.75,28.88,30.5,31.44,31.28,31.75,33.81,35.28,35.81,36.75,39.88,43.31,45.66,47.16,48.84,49.69,48.09,43.84,39.88,36.88,33.56,29.78,27.28,27.28,27.5,26.28,25.62,27.19,29.31,30.69,31.84,34.47,38.0,40.22,41.34,43.47,46.53,48.41,48.31,47.59,47.28,45.53,41.19,36.19,32.66,30.0,27.22,24.62,24.28,25.62,26.62,26.28,26.94,28.47,29.44,28.69,27.75,28.44,29.16,28.34,26.88,26.72,26.44,24.5,21.53,19.94,20.31,21.72,22.66,24.91,28.62,30.62,30.94,30.41,31.12,31.53,30.81,29.94,30.81,32.47,33.41,33.94,35.38,37.88,39.53,39.84,40.66,42.88,44.38,43.56,41.84,40.44,38.56,34.75,30.91,28.81,27.72,25.84,23.78,23.22,24.41,26.31,27.66,30.09,34.16,37.88,39.28,40.06,42.09,43.69,43.69,42.38,42.53,42.56,41.03,37.81,35.22,33.97,32.75,30.72,29.72,30.31,31.16,30.22,29.12,29.62,30.69,30.44,29.84,30.22,31.5,31.69,30.88,30.91,32.44,33.66,33.38,33.12,34.47,35.81,35.12,33.88,33.91,34.06,33.19,31.38,30.53,30.94,30.84,29.44,29.0,30.66,32.78,33.25,34.38,36.22,37.56,36.72,35.09,34.56,34.41,33.66,32.09,32.22,33.28,33.84,33.59,33.28,33.78,34.19,32.41,31.09,31.41,32.44,31.91,30.88,30.78,31.28,30.47,28.78,28.34,29.38,29.66,29.41,29.44,30.84,31.81,30.91,29.38,29.41,29.81,28.91,27.44,27.5,28.47,28.44,27.78,28.19,29.53,30.44,30.12,29.91,31.25,32.69,32.41,32.41,33.34,35.06,35.41,35.47,36.34,38.38,39.72,39.38,39.12,39.41,38.78,36.69,34.75,34.5,34.53,33.12,31.47,30.53,30.28,28.56,26.41,26.06,27.09,27.94,27.75,28.97,31.25,32.81,32.31,31.34,31.53,31.75,30.75,30.22,31.38,33.19,33.97,33.31,33.28,34.22,34.34,33.16,32.0,31.94,31.56,29.78,28.19,28.25,29.38,29.03,28.69,29.19,30.53,30.09,28.53,27.88,28.53,28.75,28.41,28.81,30.75,32.44,32.62,32.22,32.56,32.81,31.19,28.97,27.88,27.75,26.66,25.22,24.69,25.66,26.84,26.84,27.47,29.47,31.41,31.59,31.25,32.34,33.66,33.44,33.06,33.62,35.31,35.38,34.06,32.81,32.44,31.59,30.06,29.5,30.75,32.5,32.12,30.69,29.62,29.22,27.09,24.97,24.31,25.25,24.78,23.28,22.41,22.75,22.5,21.03,19.69,19.72,20.5,19.09,18.16,18.66,20.0,21.0,21.75,23.59,26.56,28.84,29.69,31.12,33.56,35.38,35.66,35.16,35.34,35.41,33.66,31.03,29.09,28.12,26.19,23.69,22.06,22.47,21.91,20.78,20.19,21.16,22.72,22.69,22.59,24.03,25.59,25.62,25.53,26.38,27.91,28.19,27.44,26.91,27.12,26.69,24.84,23.5,24.06,24.78,24.5,24.41,25.5,26.81,26.66,25.38,24.84,25.34,24.5,23.12,22.59,23.72,24.19,23.44,22.62,23.53,24.5,24.38,24.19,24.91,26.12,25.84,24.78,24.84,26.12,26.56,26.06,25.88,26.44,26.5,24.66,23.09,23.62,24.62,24.78,25.0,26.47,28.5,29.0,28.88,29.62,31.66,32.44,32.19,31.75,32.53,32.34,30.75,29.03,28.97,29.47,29.16,29.09,30.22,31.94,32.12,31.09,30.38,30.91,30.94,29.62,28.19,27.5,26.78,24.81,23.69,25.59,28.72,31.41,33.25,35.22,36.38,35.16,31.66,28.19,26.0,23.91,22.0,21.81,23.38,25.22,24.97,24.12,23.66,23.5,22.62,21.41,21.25,22.12,21.78,20.97,20.94,23.0,25.44,27.41,30.03,33.97,37.84,40.59,42.56,45.5,47.94,47.94,45.78,43.41,40.81,36.22,30.5,25.72,22.53,19.91,17.22,15.69,16.25,17.09,16.78,16.09,17.09,18.75,20.38,21.75,24.41,28.75,32.22,33.94,35.81,38.62,40.88,41.16,41.19,42.34,43.25,42.31,40.22,39.25,38.34,36.72,33.78,32.0,32.0,31.53,30.41,29.94,31.22,32.16,31.69,30.41,30.25,30.12,28.75,26.69,26.03,26.19,26.0,25.31,25.94,28.38,30.38,30.56,30.34,30.88,30.31,28.31,26.25,25.41,25.88,25.44,24.25,24.59,26.47,27.78,28.62,30.22,33.0,34.94,35.0,34.94,36.19,37.16,37.34,37.12,37.97,38.62,37.62,35.19,33.56,32.25,30.66,28.44,27.28,27.81,28.12,28.16,28.25,29.78,31.28,31.53,31.12,31.84,33.09,33.12,32.06,31.62,31.88,31.59,29.91,28.91,29.66,30.06,29.22,28.12,28.06,28.12,26.78,25.16,24.44,48.97,48.91,50.22,51.69,53.72,55.56,57.69:40.0,37.91,35.62,35.25,36.19,36.84,36.81,37.72,39.88,41.59,41.59,41.59,42.53,43.06,41.91,39.72,38.78,38.31,36.5,34.19,33.97,34.88,35.22,34.38,34.31,35.12,35.25,34.72,34.5,36.09,38.03,38.75,38.62,39.66,41.12,40.78,39.78,39.78,40.62,40.84,39.78,39.12,39.41,39.06,37.25,35.59,35.81,37.09,37.75,38.44,40.19,42.31,43.53,42.88,42.81,43.97,44.91,44.16,44.16,45.28,46.09,44.66,42.88,42.41,41.72,38.78,35.31,33.19,32.09,31.31,31.0,32.94,36.56,39.97,41.78,43.88,46.59,48.5,48.69,48.28,48.47,48.88,47.5,45.5,44.81,44.59,44.16,43.34,43.47,45.0,45.69,44.53,43.41,43.22,42.38,40.62,39.0,38.44,38.88,38.28,36.88,36.5,37.16,36.88,35.44,34.81,35.53,35.69,34.31,33.75,34.78,35.97,36.44,36.59,38.0,39.34,38.59,36.41,34.91,34.59,33.66,32.19,31.31,31.62,31.38,29.28,27.44,27.5,28.16,28.03,28.28,29.72,32.44,34.12,35.38,37.5,40.94,43.59,44.22,44.5,45.12,45.03,42.53,39.78,38.38,36.94,34.38,31.72,30.28,30.34,29.59,28.31,28.19,29.88,31.78,32.69,34.38,37.0,39.31,39.66,39.38,39.84,40.62,39.88,37.62,36.59,36.19,34.66,31.88,29.53,28.22,26.59,24.59,23.66,25.25,27.84,29.25,30.16,31.69,33.47,33.28,32.09,32.03,33.5,34.5,35.03,37.09,40.81,43.78,45.0,46.06,47.25,47.41,44.88,41.16,38.34,36.16,32.88,29.41,27.12,25.97,24.59,22.19,20.72,21.31,22.12,22.12,22.91,26.06,29.5,31.34,32.25,33.75,35.84,36.66,36.94,38.22,40.66,41.53,40.38,39.25,39.59,39.88,38.34,37.03,36.59,36.0,34.16,31.94,31.41,32.25,32.25,31.38,30.78,30.84,29.56,26.56,23.66,22.72,22.22,21.5,21.38,23.34,26.0,26.88,26.78,27.66,29.03,29.41,28.81,28.94,30.0,30.81,30.19,29.91,31.38,32.78,33.03,32.81,33.94,35.66,35.59,35.16,35.28,36.19,36.06,34.41,33.72,33.97,33.91,32.12,31.03,31.81,33.44,34.38,35.75,38.34,41.53,42.41,42.12,42.19,43.62,44.5,43.78,43.75,44.78,44.91,43.41,41.44,41.5,42.0,41.06,40.31,41.09,42.12,41.25,39.25,37.5,36.66,35.0,32.97,31.5,32.31,33.34,32.81,32.09,33.06,34.09,33.59,33.06,33.81,35.94,37.09,37.81,38.94,41.69,42.75,41.62,39.75,38.66,37.28,34.38,31.28,29.62,27.94,24.59,20.91,18.44,17.66,16.69,15.62,15.47,17.94,19.78,20.91,22.16,24.69,27.06,27.28,26.88,27.97,29.81,30.5,30.94,32.06,33.94,34.56,33.78,33.53,35.03,35.81,35.34,34.81,35.34,35.72,34.09,31.81,30.25,29.38,27.69,25.69,25.84,27.62,28.88,29.44,30.72,33.41,35.47,36.19,36.62,37.97,39.34,38.69,37.38,36.94,36.75,34.97,32.22,30.97,31.12,31.09,30.31,29.84,30.88,31.16,29.03,26.31,24.72,23.44,20.72,18.66,19.25,21.59,23.28,24.28,25.97,28.09,28.59,27.31,26.41,27.12,28.62,28.97,29.88,32.38,34.69,34.5,32.47,31.31,30.41,29.22,27.78,28.25,30.75,32.91,33.44,33.72,34.94,35.62,34.59,33.25,33.62,34.75,34.38,32.78,32.19,31.94,30.81,28.16,26.62,26.88,26.88,25.72,24.97,26.09,27.38,27.34,27.09,28.62,31.28,32.06,32.19,32.84,34.0,33.53,31.53,30.19,29.94,29.53,28.41,27.81,29.0,30.09,29.22,27.78,27.59,28.28,27.81,26.91,27.47,28.91,29.53,28.41,27.28,26.97,26.0,23.5,21.34,21.19,21.69,20.53,18.03,17.22,17.22,16.84,16.91,18.62,22.16,24.53,24.66,24.31,24.94,24.97,23.5,22.22,23.38,24.84,25.09,23.88,23.5,23.66,22.53,20.72,20.81,22.0,22.78,21.72,21.12,22.06,22.66,21.97,20.75,21.03,21.44,20.44,19.22,19.56,20.56,21.0,20.62,21.5,23.72,25.69,25.97,25.53,25.28,24.19,21.41,18.38,17.75,19.22,20.81,22.28,25.97,30.25,33.09,34.28,35.06,36.53,37.03,35.25,33.25,32.59,31.78,29.66,27.53,27.84,29.22,30.97,32.41,35.72,39.91,42.47,42.53,41.66,41.09,39.78,37.31,35.31,35.47,35.69,34.34,32.06,31.47,30.91,30.06,28.75,28.88,30.5,31.44,31.28,31.75,33.81,35.28,35.81,36.75,39.88,43.31,45.66,47.16,48.84,49.69,48.09,43.84,39.88,36.88,33.56,29.78,27.28,27.28,27.5,26.28,25.62,27.19,29.31,30.69,31.84,34.47,38.0,40.22,41.34,43.47,46.53,48.41,48.31,47.59,47.28,45.53,41.19,36.19,32.66,30.0,27.22,24.62,24.28,25.62,26.62,26.28,26.94,28.47,29.44,28.69,27.75,28.44,29.16,28.34,26.88,26.72,26.44,24.5,21.53,19.94,20.31,21.72,22.66,24.91,28.62,30.62,30.94,30.41,31.12,31.53,30.81,29.94,30.81,32.47,33.41,33.94,35.38,37.88,39.53,39.84,40.66,42.88,44.38,43.56,41.84,40.44,38.56,34.75,30.91,28.81,27.72,25.84,23.78,23.22,24.41,26.31,27.66,30.09,34.16,37.88,39.28,40.06,42.09,43.69,43.69,42.38,42.53,42.56,41.03,37.81,35.22,33.97,32.75,30.72,29.72,30.31,31.16,30.22,29.12,29.62,30.69,30.44,29.84,30.22,31.5,31.69,30.88,30.91,32.44,33.66,33.38,33.12,34.47,35.81,35.12,33.88,33.91,34.06,33.19,31.38,30.53,30.94,30.84,29.44,29.0,30.66,32.78,33.25,34.38,36.22,37.56,36.72,35.09,34.56,34.41,33.66,32.09,32.22,33.28,33.84,33.59,33.28,33.78,34.19,32.41,31.09,31.41,32.44,31.91,30.88,30.78,31.28,30.47,28.78,28.34,29.38,29.66,29.41,29.44,30.84,31.81,30.91,29.38,29.41,29.81,28.91,27.44,27.5,28.47,28.44,27.78,28.19,29.53,30.44,30.12,29.91,31.25,32.69,32.41,32.41,33.34,35.06,35.41,35.47,36.34,38.38,39.72,39.38,39.12,39.41,38.78,36.69,34.75,34.5,34.53,33.12,31.47,30.53,30.28,28.56,26.41,26.06,27.09,27.94,27.75,28.97,31.25,32.81,32.31,31.34,31.53,31.75,30.75,30.22,31.38,33.19,33.97,33.31,33.28,34.22,34.34,33.16,32.0,31.94,31.56,29.78,28.19,28.25,29.38,29.03,28.69,29.19,30.53,30.09,28.53,27.88,28.53,28.75,28.41,28.81,30.75,32.44,32.62,32.22,32.56,32.81,31.19,28.97,27.88,27.75,26.66,25.22,24.69,25.66,26.84,26.84,27.47,29.47,31.41,31.59,31.25,32.34,33.66,33.44,33.06,33.62,35.31,35.38,34.06,32.81,32.44,31.59,30.06,29.5,30.75,32.5,32.12,30.69,29.62,29.22,27.09,24.97,24.31,25.25,24.78,23.28,22.41,22.75,22.5,21.03,19.69,19.72,20.5,19.09,18.16,18.66,20.0,21.0,21.75,23.59,26.56,28.84,29.69,31.12,33.56,35.38,35.66,35.16,35.34,35.41,33.66,31.03,29.09,28.12,26.19,23.69,22.06,22.47,21.91,20.78,20.19,21.16,22.72,22.69,22.59,24.03,25.59,25.62,25.53,26.38,27.91,28.19,27.44,26.91,27.12,26.69,24.84,23.5,24.06,24.78,24.5,24.41,25.5,26.81,26.66,25.38,24.84,25.34,24.5,23.12,22.59,23.72,24.19,23.44,22.62,23.53,24.5,24.38,24.19,24.91,26.12,25.84,24.78,24.84,26.12,26.56,26.06,25.88,26.44,26.5,24.66,23.09,23.62,24.62,24.78,25.0,26.47,28.5,29.0,28.88,29.62,31.66,32.44,32.19,31.75,32.53,32.34,30.75,29.03,28.97,29.47,29.16,29.09,30.22,31.94,32.12,31.09,30.38,30.91,30.94,29.62,28.19,27.5,26.78,24.81,23.69,25.59,28.72,31.41,33.25,35.22,36.38,35.16,31.66,28.19,26.0,23.91,22.0,21.81,23.38,25.22,24.97,24.12,23.66,23.5,22.62,21.41,21.25,22.12,21.78,20.97,20.94,23.0,25.44,27.41,30.03,33.97,37.84,40.59,42.56,45.5,47.94,47.94,45.78,43.41,40.81,36.22,30.5,25.72,22.53,19.91,17.22,15.69,16.25,17.09,16.78,16.09,17.09,18.75,20.38,21.75,24.41,28.75,32.22,33.94,35.81,38.62,40.88,41.16,41.19,42.34,43.25,42.31,40.22,39.25,38.34,36.72,33.78,32.0,32.0,31.53,30.41,29.94,31.22,32.16,31.69,30.41,30.25,30.12,28.75,26.69,26.03,26.19,26.0,25.31,25.94,28.38,30.38,30.56,30.34,30.88,30.31,28.31,26.25,25.41,25.88,25.44,24.25,24.59,26.47,27.78,28.62,30.22,33.0,34.94,35.0,34.94,36.19,37.16,37.34,37.12,37.97,38.62,37.62,35.19,33.56,32.25,30.66,28.44,27.28,27.81,28.12,28.16,28.25,29.78,31.28,31.53,31.12,31.84,33.09,33.12,32.06,31.62,31.88,31.59,29.91,28.91,29.66,30.06,29.22,28.12,28.06,28.12,26.78,25.16,24.44,48.97,48.91,50.22,51.69,53.72,55.56,57.69,60.12,61.69,61.59,61.5,61.06,59.66,57.22:37.72,39.88,41.59,41.59,41.59,42.53,43.06,41.91,39.72,38.78,38.31,36.5,34.19,33.97,34.88,35.22,34.38,34.31,35.12,35.25,34.72,34.5,36.09,38.03,38.75,38.62,39.66,41.12,40.78,39.78,39.78,40.62,40.84,39.78,39.12,39.41,39.06,37.25,35.59,35.81,37.09,37.75,38.44,40.19,42.31,43.53,42.88,42.81,43.97,44.91,44.16,44.16,45.28,46.09,44.66,42.88,42.41,41.72,38.78,35.31,33.19,32.09,31.31,31.0,32.94,36.56,39.97,41.78,43.88,46.59,48.5,48.69,48.28,48.47,48.88,47.5,45.5,44.81,44.59,44.16,43.34,43.47,45.0,45.69,44.53,43.41,43.22,42.38,40.62,39.0,38.44,38.88,38.28,36.88,36.5,37.16,36.88,35.44,34.81,35.53,35.69,34.31,33.75,34.78,35.97,36.44,36.59,38.0,39.34,38.59,36.41,34.91,34.59,33.66,32.19,31.31,31.62,31.38,29.28,27.44,27.5,28.16,28.03,28.28,29.72,32.44,34.12,35.38,37.5,40.94,43.59,44.22,44.5,45.12,45.03,42.53,39.78,38.38,36.94,34.38,31.72,30.28,30.34,29.59,28.31,28.19,29.88,31.78,32.69,34.38,37.0,39.31,39.66,39.38,39.84,40.62,39.88,37.62,36.59,36.19,34.66,31.88,29.53,28.22,26.59,24.59,23.66,25.25,27.84,29.25,30.16,31.69,33.47,33.28,32.09,32.03,33.5,34.5,35.03,37.09,40.81,43.78,45.0,46.06,47.25,47.41,44.88,41.16,38.34,36.16,32.88,29.41,27.12,25.97,24.59,22.19,20.72,21.31,22.12,22.12,22.91,26.06,29.5,31.34,32.25,33.75,35.84,36.66,36.94,38.22,40.66,41.53,40.38,39.25,39.59,39.88,38.34,37.03,36.59,36.0,34.16,31.94,31.41,32.25,32.25,31.38,30.78,30.84,29.56,26.56,23.66,22.72,22.22,21.5,21.38,23.34,26.0,26.88,26.78,27.66,29.03,29.41,28.81,28.94,30.0,30.81,30.19,29.91,31.38,32.78,33.03,32.81,33.94,35.66,35.59,35.16,35.28,36.19,36.06,34.41,33.72,33.97,33.91,32.12,31.03,31.81,33.44,34.38,35.75,38.34,41.53,42.41,42.12,42.19,43.62,44.5,43.78,43.75,44.78,44.91,43.41,41.44,41.5,42.0,41.06,40.31,41.09,42.12,41.25,39.25,37.5,36.66,35.0,32.97,31.5,32.31,33.34,32.81,32.09,33.06,34.09,33.59,33.06,33.81,35.94,37.09,37.81,38.94,41.69,42.75,41.62,39.75,38.66,37.28,34.38,31.28,29.62,27.94,24.59,20.91,18.44,17.66,16.69,15.62,15.47,17.94,19.78,20.91,22.16,24.69,27.06,27.28,26.88,27.97,29.81,30.5,30.94,32.06,33.94,34.56,33.78,33.53,35.03,35.81,35.34,34.81,35.34,35.72,34.09,31.81,30.25,29.38,27.69,25.69,25.84,27.62,28.88,29.44,30.72,33.41,35.47,36.19,36.62,37.97,39.34,38.69,37.38,36.94,36.75,34.97,32.22,30.97,31.12,31.09,30.31,29.84,30.88,31.16,29.03,26.31,24.72,23.44,20.72,18.66,19.25,21.59,23.28,24.28,25.97,28.09,28.59,27.31,26.41,27.12,28.62,28.97,29.88,32.38,34.69,34.5,32.47,31.31,30.41,29.22,27.78,28.25,30.75,32.91,33.44,33.72,34.94,35.62,34.59,33.25,33.62,34.75,34.38,32.78,32.19,31.94,30.81,28.16,26.62,26.88,26.88,25.72,24.97,26.09,27.38,27.34,27.09,28.62,31.28,32.06,32.19,32.84,34.0,33.53,31.53,30.19,29.94,29.53,28.41,27.81,29.0,30.09,29.22,27.78,27.59,28.28,27.81,26.91,27.47,28.91,29.53,28.41,27.28,26.97,26.0,23.5,21.34,21.19,21.69,20.53,18.03,17.22,17.22,16.84,16.91,18.62,22.16,24.53,24.66,24.31,24.94,24.97,23.5,22.22,23.38,24.84,25.09,23.88,23.5,23.66,22.53,20.72,20.81,22.0,22.78,21.72,21.12,22.06,22.66,21.97,20.75,21.03,21.44,20.44,19.22,19.56,20.56,21.0,20.62,21.5,23.72,25.69,25.97,25.53,25.28,24.19,21.41,18.38,17.75,19.22,20.81,22.28,25.97,30.25,33.09,34.28,35.06,36.53,37.03,35.25,33.25,32.59,31.78,29.66,27.53,27.84,29.22,30.97,32.41,35.72,39.91,42.47,42.53,41.66,41.09,39.78,37.31,35.31,35.47,35.69,34.34,32.06,31.47,30.91,30.06,28.75,28.88,30.5,31.44,31.28,31.75,33.81,35.28,35.81,36.75,39.88,43.31,45.66,47.16,48.84,49.69,48.09,43.84,39.88,36.88,33.56,29.78,27.28,27.28,27.5,26.28,25.62,27.19,29.31,30.69,31.84,34.47,38.0,40.22,41.34,43.47,46.53,48.41,48.31,47.59,47.28,45.53,41.19,36.19,32.66,30.0,27.22,24.62,24.28,25.62,26.62,26.28,26.94,28.47,29.44,28.69,27.75,28.44,29.16,28.34,26.88,26.72,26.44,24.5,21.53,19.94,20.31,21.72,22.66,24.91,28.62,30.62,30.94,30.41,31.12,31.53,30.81,29.94,30.81,32.47,33.41,33.94,35.38,37.88,39.53,39.84,40.66,42.88,44.38,43.56,41.84,40.44,38.56,34.75,30.91,28.81,27.72,25.84,23.78,23.22,24.41,26.31,27.66,30.09,34.16,37.88,39.28,40.06,42.09,43.69,43.69,42.38,42.53,42.56,41.03,37.81,35.22,33.97,32.75,30.72,29.72,30.31,31.16,30.22,29.12,29.62,30.69,30.44,29.84,30.22,31.5,31.69,30.88,30.91,32.44,33.66,33.38,33.12,34.47,35.81,35.12,33.88,33.91,34.06,33.19,31.38,30.53,30.94,30.84,29.44,29.0,30.66,32.78,33.25,34.38,36.22,37.56,36.72,35.09,34.56,34.41,33.66,32.09,32.22,33.28,33.84,33.59,33.28,33.78,34.19,32.41,31.09,31.41,32.44,31.91,30.88,30.78,31.28,30.47,28.78,28.34,29.38,29.66,29.41,29.44,30.84,31.81,30.91,29.38,29.41,29.81,28.91,27.44,27.5,28.47,28.44,27.78,28.19,29.53,30.44,30.12,29.91,31.25,32.69,32.41,32.41,33.34,35.06,35.41,35.47,36.34,38.38,39.72,39.38,39.12,39.41,38.78,36.69,34.75,34.5,34.53,33.12,31.47,30.53,30.28,28.56,26.41,26.06,27.09,27.94,27.75,28.97,31.25,32.81,32.31,31.34,31.53,31.75,30.75,30.22,31.38,33.19,33.97,33.31,33.28,34.22,34.34,33.16,32.0,31.94,31.56,29.78,28.19,28.25,29.38,29.03,28.69,29.19,30.53,30.09,28.53,27.88,28.53,28.75,28.41,28.81,30.75,32.44,32.62,32.22,32.56,32.81,31.19,28.97,27.88,27.75,26.66,25.22,24.69,25.66,26.84,26.84,27.47,29.47,31.41,31.59,31.25,32.34,33.66,33.44,33.06,33.62,35.31,35.38,34.06,32.81,32.44,31.59,30.06,29.5,30.75,32.5,32.12,30.69,29.62,29.22,27.09,24.97,24.31,25.25,24.78,23.28,22.41,22.75,22.5,21.03,19.69,19.72,20.5,19.09,18.16,18.66,20.0,21.0,21.75,23.59,26.56,28.84,29.69,31.12,33.56,35.38,35.66,35.16,35.34,35.41,33.66,31.03,29.09,28.12,26.19,23.69,22.06,22.47,21.91,20.78,20.19,21.16,22.72,22.69,22.59,24.03,25.59,25.62,25.53,26.38,27.91,28.19,27.44,26.91,27.12,26.69,24.84,23.5,24.06,24.78,24.5,24.41,25.5,26.81,26.66,25.38,24.84,25.34,24.5,23.12,22.59,23.72,24.19,23.44,22.62,23.53,24.5,24.38,24.19,24.91,26.12,25.84,24.78,24.84,26.12,26.56,26.06,25.88,26.44,26.5,24.66,23.09,23.62,24.62,24.78,25.0,26.47,28.5,29.0,28.88,29.62,31.66,32.44,32.19,31.75,32.53,32.34,30.75,29.03,28.97,29.47,29.16,29.09,30.22,31.94,32.12,31.09,30.38,30.91,30.94,29.62,28.19,27.5,26.78,24.81,23.69,25.59,28.72,31.41,33.25,35.22,36.38,35.16,31.66,28.19,26.0,23.91,22.0,21.81,23.38,25.22,24.97,24.12,23.66,23.5,22.62,21.41,21.25,22.12,21.78,20.97,20.94,23.0,25.44,27.41,30.03,33.97,37.84,40.59,42.56,45.5,47.94,47.94,45.78,43.41,40.81,36.22,30.5,25.72,22.53,19.91,17.22,15.69,16.25,17.09,16.78,16.09,17.09,18.75,20.38,21.75,24.41,28.75,32.22,33.94,35.81,38.62,40.88,41.16,41.19,42.34,43.25,42.31,40.22,39.25,38.34,36.72,33.78,32.0,32.0,31.53,30.41,29.94,31.22,32.16,31.69,30.41,30.25,30.12,28.75,26.69,26.03,26.19,26.0,25.31,25.94,28.38,30.38,30.56,30.34,30.88,30.31,28.31,26.25,25.41,25.88,25.44,24.25,24.59,26.47,27.78,28.62,30.22,33.0,34.94,35.0,34.94,36.19,37.16,37.34,37.12,37.97,38.62,37.62,35.19,33.56,32.25,30.66,28.44,27.28,27.81,28.12,28.16,28.25,29.78,31.28,31.53,31.12,31.84,33.09,33.12,32.06,31.62,31.88,31.59,29.91,28.91,29.66,30.06,29.22,28.12,28.06,28.12,26.78,25.16,24.44,48.97,48.91,50.22,51.69,53.72,55.56,57.69,60.12,61.69,61.59,61.5,61.06,59.66,57.22,55.5,54.62,53.84,53.12,53.12,53.59,54.28:41.91,39.72,38.78,38.31,36.5,34.19,33.97,34.88,35.22,34.38,34.31,35.12,35.25,34.72,34.5,36.09,38.03,38.75,38.62,39.66,41.12,40.78,39.78,39.78,40.62,40.84,39.78,39.12,39.41,39.06,37.25,35.59,35.81,37.09,37.75,38.44,40.19,42.31,43.53,42.88,42.81,43.97,44.91,44.16,44.16,45.28,46.09,44.66,42.88,42.41,41.72,38.78,35.31,33.19,32.09,31.31,31.0,32.94,36.56,39.97,41.78,43.88,46.59,48.5,48.69,48.28,48.47,48.88,47.5,45.5,44.81,44.59,44.16,43.34,43.47,45.0,45.69,44.53,43.41,43.22,42.38,40.62,39.0,38.44,38.88,38.28,36.88,36.5,37.16,36.88,35.44,34.81,35.53,35.69,34.31,33.75,34.78,35.97,36.44,36.59,38.0,39.34,38.59,36.41,34.91,34.59,33.66,32.19,31.31,31.62,31.38,29.28,27.44,27.5,28.16,28.03,28.28,29.72,32.44,34.12,35.38,37.5,40.94,43.59,44.22,44.5,45.12,45.03,42.53,39.78,38.38,36.94,34.38,31.72,30.28,30.34,29.59,28.31,28.19,29.88,31.78,32.69,34.38,37.0,39.31,39.66,39.38,39.84,40.62,39.88,37.62,36.59,36.19,34.66,31.88,29.53,28.22,26.59,24.59,23.66,25.25,27.84,29.25,30.16,31.69,33.47,33.28,32.09,32.03,33.5,34.5,35.03,37.09,40.81,43.78,45.0,46.06,47.25,47.41,44.88,41.16,38.34,36.16,32.88,29.41,27.12,25.97,24.59,22.19,20.72,21.31,22.12,22.12,22.91,26.06,29.5,31.34,32.25,33.75,35.84,36.66,36.94,38.22,40.66,41.53,40.38,39.25,39.59,39.88,38.34,37.03,36.59,36.0,34.16,31.94,31.41,32.25,32.25,31.38,30.78,30.84,29.56,26.56,23.66,22.72,22.22,21.5,21.38,23.34,26.0,26.88,26.78,27.66,29.03,29.41,28.81,28.94,30.0,30.81,30.19,29.91,31.38,32.78,33.03,32.81,33.94,35.66,35.59,35.16,35.28,36.19,36.06,34.41,33.72,33.97,33.91,32.12,31.03,31.81,33.44,34.38,35.75,38.34,41.53,42.41,42.12,42.19,43.62,44.5,43.78,43.75,44.78,44.91,43.41,41.44,41.5,42.0,41.06,40.31,41.09,42.12,41.25,39.25,37.5,36.66,35.0,32.97,31.5,32.31,33.34,32.81,32.09,33.06,34.09,33.59,33.06,33.81,35.94,37.09,37.81,38.94,41.69,42.75,41.62,39.75,38.66,37.28,34.38,31.28,29.62,27.94,24.59,20.91,18.44,17.66,16.69,15.62,15.47,17.94,19.78,20.91,22.16,24.69,27.06,27.28,26.88,27.97,29.81,30.5,30.94,32.06,33.94,34.56,33.78,33.53,35.03,35.81,35.34,34.81,35.34,35.72,34.09,31.81,30.25,29.38,27.69,25.69,25.84,27.62,28.88,29.44,30.72,33.41,35.47,36.19,36.62,37.97,39.34,38.69,37.38,36.94,36.75,34.97,32.22,30.97,31.12,31.09,30.31,29.84,30.88,31.16,29.03,26.31,24.72,23.44,20.72,18.66,19.25,21.59,23.28,24.28,25.97,28.09,28.59,27.31,26.41,27.12,28.62,28.97,29.88,32.38,34.69,34.5,32.47,31.31,30.41,29.22,27.78,28.25,30.75,32.91,33.44,33.72,34.94,35.62,34.59,33.25,33.62,34.75,34.38,32.78,32.19,31.94,30.81,28.16,26.62,26.88,26.88,25.72,24.97,26.09,27.38,27.34,27.09,28.62,31.28,32.06,32.19,32.84,34.0,33.53,31.53,30.19,29.94,29.53,28.41,27.81,29.0,30.09,29.22,27.78,27.59,28.28,27.81,26.91,27.47,28.91,29.53,28.41,27.28,26.97,26.0,23.5,21.34,21.19,21.69,20.53,18.03,17.22,17.22,16.84,16.91,18.62,22.16,24.53,24.66,24.31,24.94,24.97,23.5,22.22,23.38,24.84,25.09,23.88,23.5,23.66,22.53,20.72,20.81,22.0,22.78,21.72,21.12,22.06,22.66,21.97,20.75,21.03,21.44,20.44,19.22,19.56,20.56,21.0,20.62,21.5,23.72,25.69,25.97,25.53,25.28,24.19,21.41,18.38,17.75,19.22,20.81,22.28,25.97,30.25,33.09,34.28,35.06,36.53,37.03,35.25,33.25,32.59,31.78,29.66,27.53,27.84,29.22,30.97,32.41,35.72,39.91,42.47,42.53,41.66,41.09,39.78,37.31,35.31,35.47,35.69,34.34,32.06,31.47,30.91,30.06,28.75,28.88,30.5,31.44,31.28,31.75,33.81,35.28,35.81,36.75,39.88,43.31,45.66,47.16,48.84,49.69,48.09,43.84,39.88,36.88,33.56,29.78,27.28,27.28,27.5,26.28,25.62,27.19,29.31,30.69,31.84,34.47,38.0,40.22,41.34,43.47,46.53,48.41,48.31,47.59,47.28,45.53,41.19,36.19,32.66,30.0,27.22,24.62,24.28,25.62,26.62,26.28,26.94,28.47,29.44,28.69,27.75,28.44,29.16,28.34,26.88,26.72,26.44,24.5,21.53,19.94,20.31,21.72,22.66,24.91,28.62,30.62,30.94,30.41,31.12,31.53,30.81,29.94,30.81,32.47,33.41,33.94,35.38,37.88,39.53,39.84,40.66,42.88,44.38,43.56,41.84,40.44,38.56,34.75,30.91,28.81,27.72,25.84,23.78,23.22,24.41,26.31,27.66,30.09,34.16,37.88,39.28,40.06,42.09,43.69,43.69,42.38,42.53,42.56,41.03,37.81,35.22,33.97,32.75,30.72,29.72,30.31,31.16,30.22,29.12,29.62,30.69,30.44,29.84,30.22,31.5,31.69,30.88,30.91,32.44,33.66,33.38,33.12,34.47,35.81,35.12,33.88,33.91,34.06,33.19,31.38,30.53,30.94,30.84,29.44,29.0,30.66,32.78,33.25,34.38,36.22,37.56,36.72,35.09,34.56,34.41,33.66,32.09,32.22,33.28,33.84,33.59,33.28,33.78,34.19,32.41,31.09,31.41,32.44,31.91,30.88,30.78,31.28,30.47,28.78,28.34,29.38,29.66,29.41,29.44,30.84,31.81,30.91,29.38,29.41,29.81,28.91,27.44,27.5,28.47,28.44,27.78,28.19,29.53,30.44,30.12,29.91,31.25,32.69,32.41,32.41,33.34,35.06,35.41,35.47,36.34,38.38,39.72,39.38,39.12,39.41,38.78,36.69,34.75,34.5,34.53,33.12,31.47,30.53,30.28,28.56,26.41,26.06,27.09,27.94,27.75,28.97,31.25,32.81,32.31,31.34,31.53,31.75,30.75,30.22,31.38,33.19,33.97,33.31,33.28,34.22,34.34,33.16,32.0,31.94,31.56,29.78,28.19,28.25,29.38,29.03,28.69,29.19,30.53,30.09,28.53,27.88,28.53,28.75,28.41,28.81,30.75,32.44,32.62,32.22,32.56,32.81,31.19,28.97,27.88,27.75,26.66,25.22,24.69,25.66,26.84,26.84,27.47,29.47,31.41,31.59,31.25,32.34,33.66,33.44,33.06,33.62,35.31,35.38,34.06,32.81,32.44,31.59,30.06,29.5,30.75,32.5,32.12,30.69,29.62,29.22,27.09,24.97,24.31,25.25,24.78,23.28,22.41,22.75,22.5,21.03,19.69,19.72,20.5,19.09,18.16,18.66,20.0,21.0,21.75,23.59,26.56,28.84,29.69,31.12,33.56,35.38,35.66,35.16,35.34,35.41,33.66,31.03,29.09,28.12,26.19,23.69,22.06,22.47,21.91,20.78,20.19,21.16,22.72,22.69,22.59,24.03,25.59,25.62,25.53,26.38,27.91,28.19,27.44,26.91,27.12,26.69,24.84,23.5,24.06,24.78,24.5,24.41,25.5,26.81,26.66,25.38,24.84,25.34,24.5,23.12,22.59,23.72,24.19,23.44,22.62,23.53,24.5,24.38,24.19,24.91,26.12,25.84,24.78,24.84,26.12,26.56,26.06,25.88,26.44,26.5,24.66,23.09,23.62,24.62,24.78,25.0,26.47,28.5,29.0,28.88,29.62,31.66,32.44,32.19,31.75,32.53,32.34,30.75,29.03,28.97,29.47,29.16,29.09,30.22,31.94,32.12,31.09,30.38,30.91,30.94,29.62,28.19,27.5,26.78,24.81,23.69,25.59,28.72,31.41,33.25,35.22,36.38,35.16,31.66,28.19,26.0,23.91,22.0,21.81,23.38,25.22,24.97,24.12,23.66,23.5,22.62,21.41,21.25,22.12,21.78,20.97,20.94,23.0,25.44,27.41,30.03,33.97,37.84,40.59,42.56,45.5,47.94,47.94,45.78,43.41,40.81,36.22,30.5,25.72,22.53,19.91,17.22,15.69,16.25,17.09,16.78,16.09,17.09,18.75,20.38,21.75,24.41,28.75,32.22,33.94,35.81,38.62,40.88,41.16,41.19,42.34,43.25,42.31,40.22,39.25,38.34,36.72,33.78,32.0,32.0,31.53,30.41,29.94,31.22,32.16,31.69,30.41,30.25,30.12,28.75,26.69,26.03,26.19,26.0,25.31,25.94,28.38,30.38,30.56,30.34,30.88,30.31,28.31,26.25,25.41,25.88,25.44,24.25,24.59,26.47,27.78,28.62,30.22,33.0,34.94,35.0,34.94,36.19,37.16,37.34,37.12,37.97,38.62,37.62,35.19,33.56,32.25,30.66,28.44,27.28,27.81,28.12,28.16,28.25,29.78,31.28,31.53,31.12,31.84,33.09,33.12,32.06,31.62,31.88,31.59,29.91,28.91,29.66,30.06,29.22,28.12,28.06,28.12,26.78,25.16,24.44,48.97,48.91,50.22,51.69,53.72,55.56,57.69,60.12,61.69,61.59,61.5,61.06,59.66,57.22,55.5,54.62,53.84,53.12,53.12,53.59,54.28,55.19,55.72,56.88,57.91,58.41,58.28,57.97:34.88,35.22,34.38,34.31,35.12,35.25,34.72,34.5,36.09,38.03,38.75,38.62,39.66,41.12,40.78,39.78,39.78,40.62,40.84,39.78,39.12,39.41,39.06,37.25,35.59,35.81,37.09,37.75,38.44,40.19,42.31,43.53,42.88,42.81,43.97,44.91,44.16,44.16,45.28,46.09,44.66,42.88,42.41,41.72,38.78,35.31,33.19,32.09,31.31,31.0,32.94,36.56,39.97,41.78,43.88,46.59,48.5,48.69,48.28,48.47,48.88,47.5,45.5,44.81,44.59,44.16,43.34,43.47,45.0,45.69,44.53,43.41,43.22,42.38,40.62,39.0,38.44,38.88,38.28,36.88,36.5,37.16,36.88,35.44,34.81,35.53,35.69,34.31,33.75,34.78,35.97,36.44,36.59,38.0,39.34,38.59,36.41,34.91,34.59,33.66,32.19,31.31,31.62,31.38,29.28,27.44,27.5,28.16,28.03,28.28,29.72,32.44,34.12,35.38,37.5,40.94,43.59,44.22,44.5,45.12,45.03,42.53,39.78,38.38,36.94,34.38,31.72,30.28,30.34,29.59,28.31,28.19,29.88,31.78,32.69,34.38,37.0,39.31,39.66,39.38,39.84,40.62,39.88,37.62,36.59,36.19,34.66,31.88,29.53,28.22,26.59,24.59,23.66,25.25,27.84,29.25,30.16,31.69,33.47,33.28,32.09,32.03,33.5,34.5,35.03,37.09,40.81,43.78,45.0,46.06,47.25,47.41,44.88,41.16,38.34,36.16,32.88,29.41,27.12,25.97,24.59,22.19,20.72,21.31,22.12,22.12,22.91,26.06,29.5,31.34,32.25,33.75,35.84,36.66,36.94,38.22,40.66,41.53,40.38,39.25,39.59,39.88,38.34,37.03,36.59,36.0,34.16,31.94,31.41,32.25,32.25,31.38,30.78,30.84,29.56,26.56,23.66,22.72,22.22,21.5,21.38,23.34,26.0,26.88,26.78,27.66,29.03,29.41,28.81,28.94,30.0,30.81,30.19,29.91,31.38,32.78,33.03,32.81,33.94,35.66,35.59,35.16,35.28,36.19,36.06,34.41,33.72,33.97,33.91,32.12,31.03,31.81,33.44,34.38,35.75,38.34,41.53,42.41,42.12,42.19,43.62,44.5,43.78,43.75,44.78,44.91,43.41,41.44,41.5,42.0,41.06,40.31,41.09,42.12,41.25,39.25,37.5,36.66,35.0,32.97,31.5,32.31,33.34,32.81,32.09,33.06,34.09,33.59,33.06,33.81,35.94,37.09,37.81,38.94,41.69,42.75,41.62,39.75,38.66,37.28,34.38,31.28,29.62,27.94,24.59,20.91,18.44,17.66,16.69,15.62,15.47,17.94,19.78,20.91,22.16,24.69,27.06,27.28,26.88,27.97,29.81,30.5,30.94,32.06,33.94,34.56,33.78,33.53,35.03,35.81,35.34,34.81,35.34,35.72,34.09,31.81,30.25,29.38,27.69,25.69,25.84,27.62,28.88,29.44,30.72,33.41,35.47,36.19,36.62,37.97,39.34,38.69,37.38,36.94,36.75,34.97,32.22,30.97,31.12,31.09,30.31,29.84,30.88,31.16,29.03,26.31,24.72,23.44,20.72,18.66,19.25,21.59,23.28,24.28,25.97,28.09,28.59,27.31,26.41,27.12,28.62,28.97,29.88,32.38,34.69,34.5,32.47,31.31,30.41,29.22,27.78,28.25,30.75,32.91,33.44,33.72,34.94,35.62,34.59,33.25,33.62,34.75,34.38,32.78,32.19,31.94,30.81,28.16,26.62,26.88,26.88,25.72,24.97,26.09,27.38,27.34,27.09,28.62,31.28,32.06,32.19,32.84,34.0,33.53,31.53,30.19,29.94,29.53,28.41,27.81,29.0,30.09,29.22,27.78,27.59,28.28,27.81,26.91,27.47,28.91,29.53,28.41,27.28,26.97,26.0,23.5,21.34,21.19,21.69,20.53,18.03,17.22,17.22,16.84,16.91,18.62,22.16,24.53,24.66,24.31,24.94,24.97,23.5,22.22,23.38,24.84,25.09,23.88,23.5,23.66,22.53,20.72,20.81,22.0,22.78,21.72,21.12,22.06,22.66,21.97,20.75,21.03,21.44,20.44,19.22,19.56,20.56,21.0,20.62,21.5,23.72,25.69,25.97,25.53,25.28,24.19,21.41,18.38,17.75,19.22,20.81,22.28,25.97,30.25,33.09,34.28,35.06,36.53,37.03,35.25,33.25,32.59,31.78,29.66,27.53,27.84,29.22,30.97,32.41,35.72,39.91,42.47,42.53,41.66,41.09,39.78,37.31,35.31,35.47,35.69,34.34,32.06,31.47,30.91,30.06,28.75,28.88,30.5,31.44,31.28,31.75,33.81,35.28,35.81,36.75,39.88,43.31,45.66,47.16,48.84,49.69,48.09,43.84,39.88,36.88,33.56,29.78,27.28,27.28,27.5,26.28,25.62,27.19,29.31,30.69,31.84,34.47,38.0,40.22,41.34,43.47,46.53,48.41,48.31,47.59,47.28,45.53,41.19,36.19,32.66,30.0,27.22,24.62,24.28,25.62,26.62,26.28,26.94,28.47,29.44,28.69,27.75,28.44,29.16,28.34,26.88,26.72,26.44,24.5,21.53,19.94,20.31,21.72,22.66,24.91,28.62,30.62,30.94,30.41,31.12,31.53,30.81,29.94,30.81,32.47,33.41,33.94,35.38,37.88,39.53,39.84,40.66,42.88,44.38,43.56,41.84,40.44,38.56,34.75,30.91,28.81,27.72,25.84,23.78,23.22,24.41,26.31,27.66,30.09,34.16,37.88,39.28,40.06,42.09,43.69,43.69,42.38,42.53,42.56,41.03,37.81,35.22,33.97,32.75,30.72,29.72,30.31,31.16,30.22,29.12,29.62,30.69,30.44,29.84,30.22,31.5,31.69,30.88,30.91,32.44,33.66,33.38,33.12,34.47,35.81,35.12,33.88,33.91,34.06,33.19,31.38,30.53,30.94,30.84,29.44,29.0,30.66,32.78,33.25,34.38,36.22,37.56,36.72,35.09,34.56,34.41,33.66,32.09,32.22,33.28,33.84,33.59,33.28,33.78,34.19,32.41,31.09,31.41,32.44,31.91,30.88,30.78,31.28,30.47,28.78,28.34,29.38,29.66,29.41,29.44,30.84,31.81,30.91,29.38,29.41,29.81,28.91,27.44,27.5,28.47,28.44,27.78,28.19,29.53,30.44,30.12,29.91,31.25,32.69,32.41,32.41,33.34,35.06,35.41,35.47,36.34,38.38,39.72,39.38,39.12,39.41,38.78,36.69,34.75,34.5,34.53,33.12,31.47,30.53,30.28,28.56,26.41,26.06,27.09,27.94,27.75,28.97,31.25,32.81,32.31,31.34,31.53,31.75,30.75,30.22,31.38,33.19,33.97,33.31,33.28,34.22,34.34,33.16,32.0,31.94,31.56,29.78,28.19,28.25,29.38,29.03,28.69,29.19,30.53,30.09,28.53,27.88,28.53,28.75,28.41,28.81,30.75,32.44,32.62,32.22,32.56,32.81,31.19,28.97,27.88,27.75,26.66,25.22,24.69,25.66,26.84,26.84,27.47,29.47,31.41,31.59,31.25,32.34,33.66,33.44,33.06,33.62,35.31,35.38,34.06,32.81,32.44,31.59,30.06,29.5,30.75,32.5,32.12,30.69,29.62,29.22,27.09,24.97,24.31,25.25,24.78,23.28,22.41,22.75,22.5,21.03,19.69,19.72,20.5,19.09,18.16,18.66,20.0,21.0,21.75,23.59,26.56,28.84,29.69,31.12,33.56,35.38,35.66,35.16,35.34,35.41,33.66,31.03,29.09,28.12,26.19,23.69,22.06,22.47,21.91,20.78,20.19,21.16,22.72,22.69,22.59,24.03,25.59,25.62,25.53,26.38,27.91,28.19,27.44,26.91,27.12,26.69,24.84,23.5,24.06,24.78,24.5,24.41,25.5,26.81,26.66,25.38,24.84,25.34,24.5,23.12,22.59,23.72,24.19,23.44,22.62,23.53,24.5,24.38,24.19,24.91,26.12,25.84,24.78,24.84,26.12,26.56,26.06,25.88,26.44,26.5,24.66,23.09,23.62,24.62,24.78,25.0,26.47,28.5,29.0,28.88,29.62,31.66,32.44,32.19,31.75,32.53,32.34,30.75,29.03,28.97,29.47,29.16,29.09,30.22,31.94,32.12,31.09,30.38,30.91,30.94,29.62,28.19,27.5,26.78,24.81,23.69,25.59,28.72,31.41,33.25,35.22,36.38,35.16,31.66,28.19,26.0,23.91,22.0,21.81,23.38,25.22,24.97,24.12,23.66,23.5,22.62,21.41,21.25,22.12,21.78,20.97,20.94,23.0,25.44,27.41,30.03,33.97,37.84,40.59,42.56,45.5,47.94,47.94,45.78,43.41,40.81,36.22,30.5,25.72,22.53,19.91,17.22,15.69,16.25,17.09,16.78,16.09,17.09,18.75,20.38,21.75,24.41,28.75,32.22,33.94,35.81,38.62,40.88,41.16,41.19,42.34,43.25,42.31,40.22,39.25,38.34,36.72,33.78,32.0,32.0,31.53,30.41,29.94,31.22,32.16,31.69,30.41,30.25,30.12,28.75,26.69,26.03,26.19,26.0,25.31,25.94,28.38,30.38,30.56,30.34,30.88,30.31,28.31,26.25,25.41,25.88,25.44,24.25,24.59,26.47,27.78,28.62,30.22,33.0,34.94,35.0,34.94,36.19,37.16,37.34,37.12,37.97,38.62,37.62,35.19,33.56,32.25,30.66,28.44,27.28,27.81,28.12,28.16,28.25,29.78,31.28,31.53,31.12,31.84,33.09,33.12,32.06,31.62,31.88,31.59,29.91,28.91,29.66,30.06,29.22,28.12,28.06,28.12,26.78,25.16,24.44,48.97,48.91,50.22,51.69,53.72,55.56,57.69,60.12,61.69,61.59,61.5,61.06,59.66,57.22,55.5,54.62,53.84,53.12,53.12,53.59,54.28,55.19,55.72,56.88,57.91,58.41,58.28,57.97,57.5,56.47,54.53,52.97,51.69,50.75,50.22:34.5,36.09,38.03,38.75,38.62,39.66,41.12,40.78,39.78,39.78,40.62,40.84,39.78,39.12,39.41,39.06,37.25,35.59,35.81,37.09,37.75,38.44,40.19,42.31,43.53,42.88,42.81,43.97,44.91,44.16,44.16,45.28,46.09,44.66,42.88,42.41,41.72,38.78,35.31,33.19,32.09,31.31,31.0,32.94,36.56,39.97,41.78,43.88,46.59,48.5,48.69,48.28,48.47,48.88,47.5,45.5,44.81,44.59,44.16,43.34,43.47,45.0,45.69,44.53,43.41,43.22,42.38,40.62,39.0,38.44,38.88,38.28,36.88,36.5,37.16,36.88,35.44,34.81,35.53,35.69,34.31,33.75,34.78,35.97,36.44,36.59,38.0,39.34,38.59,36.41,34.91,34.59,33.66,32.19,31.31,31.62,31.38,29.28,27.44,27.5,28.16,28.03,28.28,29.72,32.44,34.12,35.38,37.5,40.94,43.59,44.22,44.5,45.12,45.03,42.53,39.78,38.38,36.94,34.38,31.72,30.28,30.34,29.59,28.31,28.19,29.88,31.78,32.69,34.38,37.0,39.31,39.66,39.38,39.84,40.62,39.88,37.62,36.59,36.19,34.66,31.88,29.53,28.22,26.59,24.59,23.66,25.25,27.84,29.25,30.16,31.69,33.47,33.28,32.09,32.03,33.5,34.5,35.03,37.09,40.81,43.78,45.0,46.06,47.25,47.41,44.88,41.16,38.34,36.16,32.88,29.41,27.12,25.97,24.59,22.19,20.72,21.31,22.12,22.12,22.91,26.06,29.5,31.34,32.25,33.75,35.84,36.66,36.94,38.22,40.66,41.53,40.38,39.25,39.59,39.88,38.34,37.03,36.59,36.0,34.16,31.94,31.41,32.25,32.25,31.38,30.78,30.84,29.56,26.56,23.66,22.72,22.22,21.5,21.38,23.34,26.0,26.88,26.78,27.66,29.03,29.41,28.81,28.94,30.0,30.81,30.19,29.91,31.38,32.78,33.03,32.81,33.94,35.66,35.59,35.16,35.28,36.19,36.06,34.41,33.72,33.97,33.91,32.12,31.03,31.81,33.44,34.38,35.75,38.34,41.53,42.41,42.12,42.19,43.62,44.5,43.78,43.75,44.78,44.91,43.41,41.44,41.5,42.0,41.06,40.31,41.09,42.12,41.25,39.25,37.5,36.66,35.0,32.97,31.5,32.31,33.34,32.81,32.09,33.06,34.09,33.59,33.06,33.81,35.94,37.09,37.81,38.94,41.69,42.75,41.62,39.75,38.66,37.28,34.38,31.28,29.62,27.94,24.59,20.91,18.44,17.66,16.69,15.62,15.47,17.94,19.78,20.91,22.16,24.69,27.06,27.28,26.88,27.97,29.81,30.5,30.94,32.06,33.94,34.56,33.78,33.53,35.03,35.81,35.34,34.81,35.34,35.72,34.09,31.81,30.25,29.38,27.69,25.69,25.84,27.62,28.88,29.44,30.72,33.41,35.47,36.19,36.62,37.97,39.34,38.69,37.38,36.94,36.75,34.97,32.22,30.97,31.12,31.09,30.31,29.84,30.88,31.16,29.03,26.31,24.72,23.44,20.72,18.66,19.25,21.59,23.28,24.28,25.97,28.09,28.59,27.31,26.41,27.12,28.62,28.97,29.88,32.38,34.69,34.5,32.47,31.31,30.41,29.22,27.78,28.25,30.75,32.91,33.44,33.72,34.94,35.62,34.59,33.25,33.62,34.75,34.38,32.78,32.19,31.94,30.81,28.16,26.62,26.88,26.88,25.72,24.97,26.09,27.38,27.34,27.09,28.62,31.28,32.06,32.19,32.84,34.0,33.53,31.53,30.19,29.94,29.53,28.41,27.81,29.0,30.09,29.22,27.78,27.59,28.28,27.81,26.91,27.47,28.91,29.53,28.41,27.28,26.97,26.0,23.5,21.34,21.19,21.69,20.53,18.03,17.22,17.22,16.84,16.91,18.62,22.16,24.53,24.66,24.31,24.94,24.97,23.5,22.22,23.38,24.84,25.09,23.88,23.5,23.66,22.53,20.72,20.81,22.0,22.78,21.72,21.12,22.06,22.66,21.97,20.75,21.03,21.44,20.44,19.22,19.56,20.56,21.0,20.62,21.5,23.72,25.69,25.97,25.53,25.28,24.19,21.41,18.38,17.75,19.22,20.81,22.28,25.97,30.25,33.09,34.28,35.06,36.53,37.03,35.25,33.25,32.59,31.78,29.66,27.53,27.84,29.22,30.97,32.41,35.72,39.91,42.47,42.53,41.66,41.09,39.78,37.31,35.31,35.47,35.69,34.34,32.06,31.47,30.91,30.06,28.75,28.88,30.5,31.44,31.28,31.75,33.81,35.28,35.81,36.75,39.88,43.31,45.66,47.16,48.84,49.69,48.09,43.84,39.88,36.88,33.56,29.78,27.28,27.28,27.5,26.28,25.62,27.19,29.31,30.69,31.84,34.47,38.0,40.22,41.34,43.47,46.53,48.41,48.31,47.59,47.28,45.53,41.19,36.19,32.66,30.0,27.22,24.62,24.28,25.62,26.62,26.28,26.94,28.47,29.44,28.69,27.75,28.44,29.16,28.34,26.88,26.72,26.44,24.5,21.53,19.94,20.31,21.72,22.66,24.91,28.62,30.62,30.94,30.41,31.12,31.53,30.81,29.94,30.81,32.47,33.41,33.94,35.38,37.88,39.53,39.84,40.66,42.88,44.38,43.56,41.84,40.44,38.56,34.75,30.91,28.81,27.72,25.84,23.78,23.22,24.41,26.31,27.66,30.09,34.16,37.88,39.28,40.06,42.09,43.69,43.69,42.38,42.53,42.56,41.03,37.81,35.22,33.97,32.75,30.72,29.72,30.31,31.16,30.22,29.12,29.62,30.69,30.44,29.84,30.22,31.5,31.69,30.88,30.91,32.44,33.66,33.38,33.12,34.47,35.81,35.12,33.88,33.91,34.06,33.19,31.38,30.53,30.94,30.84,29.44,29.0,30.66,32.78,33.25,34.38,36.22,37.56,36.72,35.09,34.56,34.41,33.66,32.09,32.22,33.28,33.84,33.59,33.28,33.78,34.19,32.41,31.09,31.41,32.44,31.91,30.88,30.78,31.28,30.47,28.78,28.34,29.38,29.66,29.41,29.44,30.84,31.81,30.91,29.38,29.41,29.81,28.91,27.44,27.5,28.47,28.44,27.78,28.19,29.53,30.44,30.12,29.91,31.25,32.69,32.41,32.41,33.34,35.06,35.41,35.47,36.34,38.38,39.72,39.38,39.12,39.41,38.78,36.69,34.75,34.5,34.53,33.12,31.47,30.53,30.28,28.56,26.41,26.06,27.09,27.94,27.75,28.97,31.25,32.81,32.31,31.34,31.53,31.75,30.75,30.22,31.38,33.19,33.97,33.31,33.28,34.22,34.34,33.16,32.0,31.94,31.56,29.78,28.19,28.25,29.38,29.03,28.69,29.19,30.53,30.09,28.53,27.88,28.53,28.75,28.41,28.81,30.75,32.44,32.62,32.22,32.56,32.81,31.19,28.97,27.88,27.75,26.66,25.22,24.69,25.66,26.84,26.84,27.47,29.47,31.41,31.59,31.25,32.34,33.66,33.44,33.06,33.62,35.31,35.38,34.06,32.81,32.44,31.59,30.06,29.5,30.75,32.5,32.12,30.69,29.62,29.22,27.09,24.97,24.31,25.25,24.78,23.28,22.41,22.75,22.5,21.03,19.69,19.72,20.5,19.09,18.16,18.66,20.0,21.0,21.75,23.59,26.56,28.84,29.69,31.12,33.56,35.38,35.66,35.16,35.34,35.41,33.66,31.03,29.09,28.12,26.19,23.69,22.06,22.47,21.91,20.78,20.19,21.16,22.72,22.69,22.59,24.03,25.59,25.62,25.53,26.38,27.91,28.19,27.44,26.91,27.12,26.69,24.84,23.5,24.06,24.78,24.5,24.41,25.5,26.81,26.66,25.38,24.84,25.34,24.5,23.12,22.59,23.72,24.19,23.44,22.62,23.53,24.5,24.38,24.19,24.91,26.12,25.84,24.78,24.84,26.12,26.56,26.06,25.88,26.44,26.5,24.66,23.09,23.62,24.62,24.78,25.0,26.47,28.5,29.0,28.88,29.62,31.66,32.44,32.19,31.75,32.53,32.34,30.75,29.03,28.97,29.47,29.16,29.09,30.22,31.94,32.12,31.09,30.38,30.91,30.94,29.62,28.19,27.5,26.78,24.81,23.69,25.59,28.72,31.41,33.25,35.22,36.38,35.16,31.66,28.19,26.0,23.91,22.0,21.81,23.38,25.22,24.97,24.12,23.66,23.5,22.62,21.41,21.25,22.12,21.78,20.97,20.94,23.0,25.44,27.41,30.03,33.97,37.84,40.59,42.56,45.5,47.94,47.94,45.78,43.41,40.81,36.22,30.5,25.72,22.53,19.91,17.22,15.69,16.25,17.09,16.78,16.09,17.09,18.75,20.38,21.75,24.41,28.75,32.22,33.94,35.81,38.62,40.88,41.16,41.19,42.34,43.25,42.31,40.22,39.25,38.34,36.72,33.78,32.0,32.0,31.53,30.41,29.94,31.22,32.16,31.69,30.41,30.25,30.12,28.75,26.69,26.03,26.19,26.0,25.31,25.94,28.38,30.38,30.56,30.34,30.88,30.31,28.31,26.25,25.41,25.88,25.44,24.25,24.59,26.47,27.78,28.62,30.22,33.0,34.94,35.0,34.94,36.19,37.16,37.34,37.12,37.97,38.62,37.62,35.19,33.56,32.25,30.66,28.44,27.28,27.81,28.12,28.16,28.25,29.78,31.28,31.53,31.12,31.84,33.09,33.12,32.06,31.62,31.88,31.59,29.91,28.91,29.66,30.06,29.22,28.12,28.06,28.12,26.78,25.16,24.44,48.97,48.91,50.22,51.69,53.72,55.56,57.69,60.12,61.69,61.59,61.5,61.06,59.66,57.22,55.5,54.62,53.84,53.12,53.12,53.59,54.28,55.19,55.72,56.88,57.91,58.41,58.28,57.97,57.5,56.47,54.53,52.97,51.69,50.75,50.22,50.44,51.19,52.03,52.78,52.78,53.06,53.97:negativity
-5.91,-6.47,-6.47,-6.0,-5.34,-4.38,-2.41,0.5,2.75,4.53,6.34,8.34,10.0,9.84,9.47,8.75,7.28,4.28,1.03,-1.62,-3.38,-5.22,-6.62,-6.66,-5.62,-4.44,-3.75,-2.47,-0.81,-0.19,-1.03,-2.41,-3.94,-4.94,-7.22,-9.0,-9.69,-9.41,-9.62,-9.78,-9.97,-9.59,-9.25,-9.75,-9.81,-8.69,-7.41,-6.78,-5.69,-4.03,-2.34,-1.44,-0.78,0.09,1.03,0.78,0.0,-0.41,-0.06,0.34,0.66,1.44,2.62,3.28,2.69,1.72,0.94,0.56,-0.41,-1.44,-1.5,-1.03,-1.19,-1.81,-2.59,-2.97,-3.88,-5.81,-7.47,-7.84,-8.0,-8.59,-9.03,-8.69,-7.41,-6.94,-6.41,-4.91,-3.19,-1.81,-1.25,-0.53,0.97,2.31,2.53,2.41,2.75,2.88,1.44,-0.25,-0.66,-0.88,-1.53,-2.44,-3.09,-3.22,-3.78,-5.22,-5.75,-5.16,-4.19,-3.56,-3.72,-2.97,-2.59,-3.88,-5.69,-7.16,-8.03,-9.47,-11.16,-11.75,-11.34,-11.03,-10.84,-9.78,-7.44,-4.97,-3.12,-1.97,-0.66,0.28,-0.19,-1.78,-2.59,-3.09,-4.59,-6.31,-7.78,-8.16,-8.72,-9.69,-10.12,-9.62,-8.66,-8.44,-8.59,-7.72,-6.22,-5.62,-4.84,-3.25,-1.44,-1.0,-1.22,-2.44,-3.38,-3.97,-5.25,-6.0,-5.19,-3.84,-3.12,-2.22,-0.34,1.59,2.81,3.25,3.41,3.88,3.12,1.75,0.25,-0.66,-1.31,-2.59,-3.16,-2.34,-1.19,-1.12,-1.75,-2.38,-2.97,-4.16,-5.81,-6.59,-6.66,-7.28,-8.56,-10.19,-10.56,-11.06,-12.44,-13.28,-13.12,-12.56,-12.06,-11.56,-9.78,-7.31,-5.34,-4.03,-3.0,-1.25,-0.81,-1.19,-1.62,-1.09,-0.84,-1.31,-2.25,-2.44,-2.19,-3.16,-4.19,-4.47,-3.94,-4.28,-4.59,-5.06,-5.06,-5.47,-7.06,-8.47,-9.06,-9.34,-9.78,-10.28,-9.25,-7.72,-6.69,-5.84,-4.78,-3.25,-2.41,-2.47,-1.94,-0.66,0.59,1.34,1.44,2.5,3.53,3.06,2.41,2.03,2.03,1.19,0.03,-0.62,-0.5,-0.75,-1.25,-2.03,-1.88,-2.06,-2.41,-2.75,-1.62,0.72,2.97,5.03,7.66,10.03,10.78,9.91,7.91,6.16,3.72,0.72,-2.0,-3.62,-5.03,-7.31,-9.81,-11.0,-11.31,-11.72,-12.12,-11.22,-10.03,-9.25,-9.16,-8.44,-6.72,-4.78,-3.59,-2.28,0.41,2.81,4.66,5.81,7.69,8.91,8.94,7.28,5.81,4.31,2.69,0.44,-0.66,-0.34,0.0,-0.16,-0.47,0.25,1.12,1.16,0.31,0.06,-0.25,-1.12,-2.53,-3.19,-2.97,-2.91,-3.69,-4.25,-3.84,-3.34,-3.84,-4.44,-3.25,-1.62,-0.03,1.81,4.69,7.53,9.66,10.34,10.44,10.62,9.56,7.03,4.31,2.38,0.66,-1.53,-3.75,-4.5,-4.88,-5.12,-5.19,-3.88,-1.75,0.38,2.0,4.38,7.03,9.44,10.56,11.09,11.81,11.59,9.94,7.78,6.72,6.06,5.88,6.0,7.38,9.81,11.88,12.28,12.72,13.03,12.31,10.34,8.28,7.66,6.84,5.81,4.59,4.16,4.41,4.69,4.78,5.75,7.31,8.88,9.28,9.97,12.03,13.91,14.78,14.75,14.75,14.12,12.62,10.38,8.5,7.5,5.94,4.03,3.22,4.03,5.91,7.34,9.5,12.91,15.59,16.97,17.47,18.09,18.62,18.12,16.78,15.97,14.81,13.53,11.41,9.56,8.75,8.28,6.72,5.5,5.09,4.88,3.72,3.0,3.28,4.47,5.72,7.06,8.81,10.94,12.0,11.47,10.94,10.81,11.19,10.72,11.12,12.06,12.69,12.34,11.94,12.16,12.94,13.56,13.5,13.97,14.22,14.22,13.16,12.56,12.5,13.12,12.84,13.16,13.72,13.84,12.88,10.78,9.47,8.53,7.72,6.75,6.5,6.56,6.34,5.16,3.41,3.06,2.62,1.62,1.53,2.22,3.41,4.41,5.0,6.0,7.28,8.34,8.38,8.53,9.03,9.22,8.41,7.0,6.12,5.47,4.06,3.0,2.81,3.47,3.62,3.25,3.75,5.16,6.25,6.25,6.69,7.62,8.12,6.75,5.31,4.06,2.78,0.88,-0.84,-1.38,-0.91,-0.53,-0.16,0.72,2.12,3.25,3.47,3.47,3.81,4.38,4.03,3.72,4.31,5.69,6.03,6.41,7.41,8.69,9.44,9.22,9.69,10.84,11.97,12.56,13.12,14.12,14.66,13.72,12.69,12.0,11.78,10.47,8.97,8.25,8.09,7.53,7.31,7.06,7.19,6.91,5.19,3.47,2.09,1.12,0.19,0.09,0.94,2.47,3.41,3.5,3.41,3.75,3.25,1.84,0.88,0.22,0.25,-0.06,0.19,1.53,3.12,3.56,3.28,3.38,3.72,3.91,4.12,5.19,7.19,8.84,9.06,9.19,9.12,8.69,7.03,5.94,6.0,7.38,9.22,11.31,14.0,16.62,17.59,17.0,15.41,14.06,12.91,10.84,9.56,9.56,10.19,10.09,10.03,10.41,11.12,10.72,10.03,10.22,11.44,12.53,13.53,14.91,16.72,17.94,17.69,16.91,16.25,15.06,12.94,10.5,8.62,7.31,5.41,3.22,2.0,1.56,1.22,2.03,3.69,6.78,10.22,12.59,14.69,16.59,17.94,17.44,16.41,14.84,13.38,11.16,9.0,7.0,6.75,7.38,7.81,9.28,11.75,13.78,14.44,14.19,13.75,13.75,13.0,12.03,11.16,10.66,8.81,6.19,3.88,2.72,2.41,3.0,4.31,7.25,10.06,11.75,12.78,13.47,14.03,14.22,13.84,14.53,16.09,17.09,17.25,17.16,17.03,16.34,15.09,14.06,13.97,14.12,13.88,13.09,12.56,12.38,11.5,10.31,9.75,9.97,9.91,8.94,8.38,8.66,8.88,8.62,8.56,9.19,9.84,9.72,9.19,8.94,9.09,8.84,8.62,8.56,9.78,10.59,10.5,10.53,11.38,12.19,12.97,13.28,14.31,14.97,14.62,13.44,12.66,12.59,12.16,11.62,11.31,12.19,13.03,13.28,13.94,14.88,15.31,14.75,13.69,13.59,14.09,14.94,15.81,17.25,18.94,19.28,17.88,15.66,13.25,10.69,8.34,6.84,6.94,8.06,8.69,9.12,10.34,11.59,12.66,13.31,14.25,15.81,16.94,17.41,17.31,17.06,16.22,14.0,11.28,9.31,8.31,7.06,6.03,6.34,7.22,7.84,7.75,7.97,8.81,9.34,9.53,9.75,10.62,11.22,10.88,10.19,10.09,9.91,9.56,9.09,9.03,8.91,8.34,7.38,6.69,7.41,8.5,9.47,10.25,10.81,10.72,9.28,6.75,5.22,4.81,4.53,4.41,5.66,7.28,8.19,8.53,8.75,9.53,10.41,11.03,11.75,13.75,15.59,16.38,16.53,16.31,16.44,15.56,14.19,13.34,12.88,12.41,10.94,9.5,8.5,7.53,6.0,4.84,5.28,6.59,7.47,8.0,9.19,9.78,9.75,9.19,9.16,10.22,11.53,12.47,13.53,15.41,16.72,16.69,15.69,15.06,13.91,12.47,10.59,9.88,9.81,9.91,9.19,8.69,8.53,8.31,7.47,7.41,8.47,9.94,10.97,11.19,12.06,12.47,13.09,13.44,14.53,16.19,17.78,18.19,18.16,18.5,18.47,17.28,15.72,14.84,13.91,12.53,11.03,10.69,11.47,12.41,12.81,13.19,13.62,13.0,11.34,9.81,9.5,9.81,9.97,10.75,12.22,13.44,13.78,13.5,14.0,14.78,15.91,16.56,16.72,16.78,15.84,14.03,12.25,11.78,12.16,11.97,11.62,11.28,11.31,10.59,9.03,8.09,7.81,7.19,5.59,4.47,4.06,4.03,3.81,4.38,6.53,9.47,11.47,12.72,14.12,15.03,14.69,13.75,13.72,15.03,16.28,17.03,17.81,18.53,18.44,17.09,15.72,15.0,15.0,14.44,13.31,13.06,13.56,14.12,14.25,15.53,17.19,18.66,18.81,18.97,19.53,20.44,20.53,20.25,20.5,20.94,20.59,19.47,18.69,18.72,17.88,15.97,14.84,13.97,13.31,11.84,10.88,10.62,10.53,9.75,9.25,9.62,10.66,11.72,12.59,13.97,15.72,16.69,17.22,17.53,18.56,19.62,19.97,20.34,21.0,21.88,21.41,20.34,19.88,19.38,18.47,17.69,17.59,18.38,19.38,19.44,19.34,19.19,18.88,17.59,16.0,15.72,16.47,16.59,16.47,16.5,16.69,15.91,14.94,14.53,15.94,17.81,19.25,20.88,22.59,23.5,23.0,22.0,21.59,22.03,22.09,22.0,22.59,23.91,24.28,23.88,22.78,22.25,21.09,19.47,18.09,17.66,18.03,17.41,16.91,17.22,18.12,18.56,17.84,17.91,18.81,19.69,19.88,20.44,21.62,22.22,21.16,20.25,20.12,20.38,19.88,19.5,20.0,20.5,20.41,19.97,20.31,22.06,23.41,24.03,24.59,24.56,23.88,21.59,19.38,18.22,18.03,17.47,17.31,18.12,19.5,20.31,20.28,20.41,21.34,22.09,22.31,23.06,24.53,26.09,26.53,26.62,27.47,28.47,28.84,29.41,30.12,31.41,31.62,30.44,29.28,27.84,26.44,24.47,22.91,22.78,23.41,23.78,24.38,25.94,27.97,28.72,29.16,29.56,30.41,30.12,29.31,28.56,28.97,29.78,30.31,31.44,33.78,36.03,36.81,36.69,36.03,35.5,34.09,32.47,31.59,31.78,31.78,31.12,30.62,30.5,30.25,29.44,28.12,27.78,27.88,27.22,26.62,27.06,28.25,28.28,28.03,27.59,27.72,27.69,27.97,28.78,30.53,32.44,32.62,32.66,33.28,33.84,33.88,33.5,33.44,33.75,33.34,32.31,31.47,31.06,30.88,29.72,28.81,29.47,30.22:0.5,2.75,4.53,6.34,8.34,10.0,9.84,9.47,8.75,7.28,4.28,1.03,-1.62,-3.38,-5.22,-6.62,-6.66,-5.62,-4.44,-3.75,-2.47,-0.81,-0.19,-1.03,-2.41,-3.94,-4.94,-7.22,-9.0,-9.69,-9.41,-9.62,-9.78,-9.97,-9.59,-9.25,-9.75,-9.81,-8.69,-7.41,-6.78,-5.69,-4.03,-2.34,-1.44,-0.78,0.09,1.03,0.78,0.0,-0.41,-0.06,0.34,0.66,1.44,2.62,3.28,2.69,1.72,0.94,0.56,-0.41,-1.44,-1.5,-1.03,-1.19,-1.81,-2.59,-2.97,-3.88,-5.81,-7.47,-7.84,-8.0,-8.59,-9.03,-8.69,-7.41,-6.94,-6.41,-4.91,-3.19,-1.81,-1.25,-0.53,0.97,2.31,2.53,2.41,2.75,2.88,1.44,-0.25,-0.66,-0.88,-1.53,-2.44,-3.09,-3.22,-3.78,-5.22,-5.75,-5.16,-4.19,-3.56,-3.72,-2.97,-2.59,-3.88,-5.69,-7.16,-8.03,-9.47,-11.16,-11.75,-11.34,-11.03,-10.84,-9.78,-7.44,-4.97,-3.12,-1.97,-0.66,0.28,-0.19,-1.78,-2.59,-3.09,-4.59,-6.31,-7.78,-8.16,-8.72,-9.69,-10.12,-9.62,-8.66,-8.44,-8.59,-7.72,-6.22,-5.62,-4.84,-3.25,-1.44,-1.0,-1.22,-2.44,-3.38,-3.97,-5.25,-6.0,-5.19,-3.84,-3.12,-2.22,-0.34,1.59,2.81,3.25,3.41,3.88,3.12,1.75,0.25,-0.66,-1.31,-2.59,-3.16,-2.34,-1.19,-1.12,-1.75,-2.38,-2.97,-4.16,-5.81,-6.59,-6.66,-7.28,-8.56,-10.19,-10.56,-11.06,-12.44,-13.28,-13.12,-12.56,-12.06,-11.56,-9.78,-7.31,-5.34,-4.03,-3.0,-1.25,-0.81,-1.19,-1.62,-1.09,-0.84,-1.31,-2.25,-2.44,-2.19,-3.16,-4.19,-4.47,-3.94,-4.28,-4.59,-5.06,-5.06,-5.47,-7.06,-8.47,-9.06,-9.34,-9.78,-10.28,-9.25,-7.72,-6.69,-5.84,-4.78,-3.25,-2.41,-2.47,-1.94,-0.66,0.59,1.34,1.44,2.5,3.53,3.06,2.41,2.03,2.03,1.19,0.03,-0.62,-0.5,-0.75,-1.25,-2.03,-1.88,-2.06,-2.41,-2.75,-1.62,0.72,2.97,5.03,7.66,10.03,10.78,9.91,7.91,6.16,3.72,0.72,-2.0,-3.62,-5.03,-7.31,-9.81,-11.0,-11.31,-11.72,-12.12,-11.22,-10.03,-9.25,-9.16,-8.44,-6.72,-4.78,-3.59,-2.28,0.41,2.81,4.66,5.81,7.69,8.91,8.94,7.28,5.81,4.31,2.69,0.44,-0.66,-0.34,0.0,-0.16,-0.47,0.25,1.12,1.16,0.31,0.06,-0.25,-1.12,-2.53,-3.19,-2.97,-2.91,-3.69,-4.25,-3.84,-3.34,-3.84,-4.44,-3.25,-1.62,-0.03,1.81,4.69,7.53,9.66,10.34,10.44,10.62,9.56,7.03,4.31,2.38,0.66,-1.53,-3.75,-4.5,-4.88,-5.12,-5.19,-3.88,-1.75,0.38,2.0,4.38,7.03,9.44,10.56,11.09,11.81,11.59,9.94,7.78,6.72,6.06,5.88,6.0,7.38,9.81,11.88,12.28,12.72,13.03,12.31,10.34,8.28,7.66,6.84,5.81,4.59,4.16,4.41,4.69,4.78,5.75,7.31,8.88,9.28,9.97,12.03,13.91,14.78,14.75,14.75,14.12,12.62,10.38,8.5,7.5,5.94,4.03,3.22,4.03,5.91,7.34,9.5,12.91,15.59,16.97,17.47,18.09,18.62,18.12,16.78,15.97,14.81,13.53,11.41,9.56,8.75,8.28,6.72,5.5,5.09,4.88,3.72,3.0,3.28,4.47,5.72,7.06,8.81,10.94,12.0,11.47,10.94,10.81,11.19,10.72,11.12,12.06,12.69,12.34,11.94,12.16,12.94,13.56,13.5,13.97,14.22,14.22,13.16,12.56,12.5,13.12,12.84,13.16,13.72,13.84,12.88,10.78,9.47,8.53,7.72,6.75,6.5,6.56,6.34,5.16,3.41,3.06,2.62,1.62,1.53,2.22,3.41,4.41,5.0,6.0,7.28,8.34,8.38,8.53,9.03,9.22,8.41,7.0,6.12,5.47,4.06,3.0,2.81,3.47,3.62,3.25,3.75,5.16,6.25,6.25,6.69,7.62,8.12,6.75,5.31,4.06,2.78,0.88,-0.84,-1.38,-0.91,-0.53,-0.16,0.72,2.12,3.25,3.47,3.47,3.81,4.38,4.03,3.72,4.31,5.69,6.03,6.41,7.41,8.69,9.44,9.22,9.69,10.84,11.97,12.56,13.12,14.12,14.66,13.72,12.69,12.0,11.78,10.47,8.97,8.25,8.09,7.53,7.31,7.06,7.19,6.91,5.19,3.47,2.09,1.12,0.19,0.09,0.94,2.47,3.41,3.5,3.41,3.75,3.25,1.84,0.88,0.22,0.25,-0.06,0.19,1.53,3.12,3.56,3.28,3.38,3.72,3.91,4.12,5.19,7.19,8.84,9.06,9.19,9.12,8.69,7.03,5.94,6.0,7.38,9.22,11.31,14.0,16.62,17.59,17.0,15.41,14.06,12.91,10.84,9.56,9.56,10.19,10.09,10.03,10.41,11.12,10.72,10.03,10.22,11.44,12.53,13.53,14.91,16.72,17.94,17.69,16.91,16.25,15.06,12.94,10.5,8.62,7.31,5.41,3.22,2.0,1.56,1.22,2.03,3.69,6.78,10.22,12.59,14.69,16.59,17.94,17.44,16.41,14.84,13.38,11.16,9.0,7.0,6.75,7.38,7.81,9.28,11.75,13.78,14.44,14.19,13.75,13.75,13.0,12.03,11.16,10.66,8.81,6.19,3.88,2.72,2.41,3.0,4.31,7.25,10.06,11.75,12.78,13.47,14.03,14.22,13.84,14.53,16.09,17.09,17.25,17.16,17.03,16.34,15.09,14.06,13.97,14.12,13.88,13.09,12.56,12.38,11.5,10.31,9.75,9.97,9.91,8.94,8.38,8.66,8.88,8.62,8.56,9.19,9.84,9.72,9.19,8.94,9.09,8.84,8.62,8.56,9.78,10.59,10.5,10.53,11.38,12.19,12.97,13.28,14.31,14.97,14.62,13.44,12.66,12.59,12.16,11.62,11.31,12.19,13.03,13.28,13.94,14.88,15.31,14.75,13.69,13.59,14.09,14.94,15.81,17.25,18.94,19.28,17.88,15.66,13.25,10.69,8.34,6.84,6.94,8.06,8.69,9.12,10.34,11.59,12.66,13.31,14.25,15.81,16.94,17.41,17.31,17.06,16.22,14.0,11.28,9.31,8.31,7.06,6.03,6.34,7.22,7.84,7.75,7.97,8.81,9.34,9.53,9.75,10.62,11.22,10.88,10.19,10.09,9.91,9.56,9.09,9.03,8.91,8.34,7.38,6.69,7.41,8.5,9.47,10.25,10.81,10.72,9.28,6.75,5.22,4.81,4.53,4.41,5.66,7.28,8.19,8.53,8.75,9.53,10.41,11.03,11.75,13.75,15.59,16.38,16.53,16.31,16.44,15.56,14.19,13.34,12.88,12.41,10.94,9.5,8.5,7.53,6.0,4.84,5.28,6.59,7.47,8.0,9.19,9.78,9.75,9.19,9.16,10.22,11.53,12.47,13.53,15.41,16.72,16.69,15.69,15.06,13.91,12.47,10.59,9.88,9.81,9.91,9.19,8.69,8.53,8.31,7.47,7.41,8.47,9.94,10.97,11.19,12.06,12.47,13.09,13.44,14.53,16.19,17.78,18.19,18.16,18.5,18.47,17.28,15.72,14.84,13.91,12.53,11.03,10.69,11.47,12.41,12.81,13.19,13.62,13.0,11.34,9.81,9.5,9.81,9.97,10.75,12.22,13.44,13.78,13.5,14.0,14.78,15.91,16.56,16.72,16.78,15.84,14.03,12.25,11.78,12.16,11.97,11.62,11.28,11.31,10.59,9.03,8.09,7.81,7.19,5.59,4.47,4.06,4.03,3.81,4.38,6.53,9.47,11.47,12.72,14.12,15.03,14.69,13.75,13.72,15.03,16.28,17.03,17.81,18.53,18.44,17.09,15.72,15.0,15.0,14.44,13.31,13.06,13.56,14.12,14.25,15.53,17.19,18.66,18.81,18.97,19.53,20.44,20.53,20.25,20.5,20.94,20.59,19.47,18.69,18.72,17.88,15.97,14.84,13.97,13.31,11.84,10.88,10.62,10.53,9.75,9.25,9.62,10.66,11.72,12.59,13.97,15.72,16.69,17.22,17.53,18.56,19.62,19.97,20.34,21.0,21.88,21.41,20.34,19.88,19.38,18.47,17.69,17.59,18.38,19.38,19.44,19.34,19.19,18.88,17.59,16.0,15.72,16.47,16.59,16.47,16.5,16.69,15.91,14.94,14.53,15.94,17.81,19.25,20.88,22.59,23.5,23.0,22.0,21.59,22.03,22.09,22.0,22.59,23.91,24.28,23.88,22.78,22.25,21.09,19.47,18.09,17.66,18.03,17.41,16.91,17.22,18.12,18.56,17.84,17.91,18.81,19.69,19.88,20.44,21.62,22.22,21.16,20.25,20.12,20.38,19.88,19.5,20.0,20.5,20.41,19.97,20.31,22.06,23.41,24.03,24.59,24.56,23.88,21.59,19.38,18.22,18.03,17.47,17.31,18.12,19.5,20.31,20.28,20.41,21.34,22.09,22.31,23.06,24.53,26.09,26.53,26.62,27.47,28.47,28.84,29.41,30.12,31.41,31.62,30.44,29.28,27.84,26.44,24.47,22.91,22.78,23.41,23.78,24.38,25.94,27.97,28.72,29.16,29.56,30.41,30.12,29.31,28.56,28.97,29.78,30.31,31.44,33.78,36.03,36.81,36.69,36.03,35.5,34.09,32.47,31.59,31.78,31.78,31.12,30.62,30.5,30.25,29.44,28.12,27.78,27.88,27.22,26.62,27.06,28.25,28.28,28.03,27.59,27.72,27.69,27.97,28.78,30.53,32.44,32.62,32.66,33.28,33.84,33.88,33.5,33.44,33.75,33.34,32.31,31.47,31.06,30.88,29.72,28.81,29.47,30.22,40.34,39.69,38.47,38.06,38.12,39.25,40.88:9.47,8.75,7.28,4.28,1.03,-1.62,-3.38,-5.22,-6.62,-6.66,-5.62,-4.44,-3.75,-2.47,-0.81,-0.19,-1.03,-2.41,-3.94,-4.94,-7.22,-9.0,-9.69,-9.41,-9.62,-9.78,-9.97,-9.59,-9.25,-9.75,-9.81,-8.69,-7.41,-6.78,-5.69,-4.03,-2.34,-1.44,-0.78,0.09,1.03,0.78,0.0,-0.41,-0.06,0.34,0.66,1.44,2.62,3.28,2.69,1.72,0.94,0.56,-0.41,-1.44,-1.5,-1.03,-1.19,-1.81,-2.59,-2.97,-3.88,-5.81,-7.47,-7.84,-8.0,-8.59,-9.03,-8.69,-7.41,-6.94,-6.41,-4.91,-3.19,-1.81,-1.25,-0.53,0.97,2.31,2.53,2.41,2.75,2.88,1.44,-0.25,-0.66,-0.88,-1.53,-2.44,-3.09,-3.22,-3.78,-5.22,-5.75,-5.16,-4.19,-3.56,-3.72,-2.97,-2.59,-3.88,-5.69,-7.16,-8.03,-9.47,-11.16,-11.75,-11.34,-11.03,-10.84,-9.78,-7.44,-4.97,-3.12,-1.97,-0.66,0.28,-0.19,-1.78,-2.59,-3.09,-4.59,-6.31,-7.78,-8.16,-8.72,-9.69,-10.12,-9.62,-8.66,-8.44,-8.59,-7.72,-6.22,-5.62,-4.84,-3.25,-1.44,-1.0,-1.22,-2.44,-3.38,-3.97,-5.25,-6.0,-5.19,-3.84,-3.12,-2.22,-0.34,1.59,2.81,3.25,3.41,3.88,3.12,1.75,0.25,-0.66,-1.31,-2.59,-3.16,-2.34,-1.19,-1.12,-1.75,-2.38,-2.97,-4.16,-5.81,-6.59,-6.66,-7.28,-8.56,-10.19,-10.56,-11.06,-12.44,-13.28,-13.12,-12.56,-12.06,-11.56,-9.78,-7.31,-5.34,-4.03,-3.0,-1.25,-0.81,-1.19,-1.62,-1.09,-0.84,-1.31,-2.25,-2.44,-2.19,-3.16,-4.19,-4.47,-3.94,-4.28,-4.59,-5.06,-5.06,-5.47,-7.06,-8.47,-9.06,-9.34,-9.78,-10.28,-9.25,-7.72,-6.69,-5.84,-4.78,-3.25,-2.41,-2.47,-1.94,-0.66,0.59,1.34,1.44,2.5,3.53,3.06,2.41,2.03,2.03,1.19,0.03,-0.62,-0.5,-0.75,-1.25,-2.03,-1.88,-2.06,-2.41,-2.75,-1.62,0.72,2.97,5.03,7.66,10.03,10.78,9.91,7.91,6.16,3.72,0.72,-2.0,-3.62,-5.03,-7.31,-9.81,-11.0,-11.31,-11.72,-12.12,-11.22,-10.03,-9.25,-9.16,-8.44,-6.72,-4.78,-3.59,-2.28,0.41,2.81,4.66,5.81,7.69,8.91,8.94,7.28,5.81,4.31,2.69,0.44,-0.66,-0.34,0.0,-0.16,-0.47,0.25,1.12,1.16,0.31,0.06,-0.25,-1.12,-2.53,-3.19,-2.97,-2.91,-3.69,-4.25,-3.84,-3.34,-3.84,-4.44,-3.25,-1.62,-0.03,1.81,4.69,7.53,9.66,10.34,10.44,10.62,9.56,7.03,4.31,2.38,0.66,-1.53,-3.75,-4.5,-4.88,-5.12,-5.19,-3.88,-1.75,0.38,2.0,4.38,7.03,9.44,10.56,11.09,11.81,11.59,9.94,7.78,6.72,6.06,5.88,6.0,7.38,9.81,11.88,12.28,12.72,13.03,12.31,10.34,8.28,7.66,6.84,5.81,4.59,4.16,4.41,4.69,4.78,5.75,7.31,8.88,9.28,9.97,12.03,13.91,14.78,14.75,14.75,14.12,12.62,10.38,8.5,7.5,5.94,4.03,3.22,4.03,5.91,7.34,9.5,12.91,15.59,16.97,17.47,18.09,18.62,18.12,16.78,15.97,14.81,13.53,11.41,9.56,8.75,8.28,6.72,5.5,5.09,4.88,3.72,3.0,3.28,4.47,5.72,7.06,8.81,10.94,12.0,11.47,10.94,10.81,11.19,10.72,11.12,12.06,12.69,12.34,11.94,12.16,12.94,13.56,13.5,13.97,14.22,14.22,13.16,12.56,12.5,13.12,12.84,13.16,13.72,13.84,12.88,10.78,9.47,8.53,7.72,6.75,6.5,6.56,6.34,5.16,3.41,3.06,2.62,1.62,1.53,2.22,3.41,4.41,5.0,6.0,7.28,8.34,8.38,8.53,9.03,9.22,8.41,7.0,6.12,5.47,4.06,3.0,2.81,3.47,3.62,3.25,3.75,5.16,6.25,6.25,6.69,7.62,8.12,6.75,5.31,4.06,2.78,0.88,-0.84,-1.38,-0.91,-0.53,-0.16,0.72,2.12,3.25,3.47,3.47,3.81,4.38,4.03,3.72,4.31,5.69,6.03,6.41,7.41,8.69,9.44,9.22,9.69,10.84,11.97,12.56,13.12,14.12,14.66,13.72,12.69,12.0,11.78,10.47,8.97,8.25,8.09,7.53,7.31,7.06,7.19,6.91,5.19,3.47,2.09,1.12,0.19,0.09,0.94,2.47,3.41,3.5,3.41,3.75,3.25,1.84,0.88,0.22,0.25,-0.06,0.19,1.53,3.12,3.56,3.28,3.38,3.72,3.91,4.12,5.19,7.19,8.84,9.06,9.19,9.12,8.69,7.03,5.94,6.0,7.38,9.22,11.31,14.0,16.62,17.59,17.0,15.41,14.06,12.91,10.84,9.56,9.56,10.19,10.09,10.03,10.41,11.12,10.72,10.03,10.22,11.44,12.53,13.53,14.91,16.72,17.94,17.69,16.91,16.25,15.06,12.94,10.5,8.62,7.31,5.41,3.22,2.0,1.56,1.22,2.03,3.69,6.78,10.22,12.59,14.69,16.59,17.94,17.44,16.41,14.84,13.38,11.16,9.0,7.0,6.75,7.38,7.81,9.28,11.75,13.78,14.44,14.19,13.75,13.75,13.0,12.03,11.16,10.66,8.81,6.19,3.88,2.72,2.41,3.0,4.31,7.25,10.06,11.75,12.78,13.47,14.03,14.22,13.84,14.53,16.09,17.09,17.25,17.16,17.03,16.34,15.09,14.06,13.97,14.12,13.88,13.09,12.56,12.38,11.5,10.31,9.75,9.97,9.91,8.94,8.38,8.66,8.88,8.62,8.56,9.19,9.84,9.72,9.19,8.94,9.09,8.84,8.62,8.56,9.78,10.59,10.5,10.53,11.38,12.19,12.97,13.28,14.31,14.97,14.62,13.44,12.66,12.59,12.16,11.62,11.31,12.19,13.03,13.28,13.94,14.88,15.31,14.75,13.69,13.59,14.09,14.94,15.81,17.25,18.94,19.28,17.88,15.66,13.25,10.69,8.34,6.84,6.94,8.06,8.69,9.12,10.34,11.59,12.66,13.31,14.25,15.81,16.94,17.41,17.31,17.06,16.22,14.0,11.28,9.31,8.31,7.06,6.03,6.34,7.22,7.84,7.75,7.97,8.81,9.34,9.53,9.75,10.62,11.22,10.88,10.19,10.09,9.91,9.56,9.09,9.03,8.91,8.34,7.38,6.69,7.41,8.5,9.47,10.25,10.81,10.72,9.28,6.75,5.22,4.81,4.53,4.41,5.66,7.28,8.19,8.53,8.75,9.53,10.41,11.03,11.75,13.75,15.59,16.38,16.53,16.31,16.44,15.56,14.19,13.34,12.88,12.41,10.94,9.5,8.5,7.53,6.0,4.84,5.28,6.59,7.47,8.0,9.19,9.78,9.75,9.19,9.16,10.22,11.53,12.47,13.53,15.41,16.72,16.69,15.69,15.06,13.91,12.47,10.59,9.88,9.81,9.91,9.19,8.69,8.53,8.31,7.47,7.41,8.47,9.94,10.97,11.19,12.06,12.47,13.09,13.44,14.53,16.19,17.78,18.19,18.16,18.5,18.47,17.28,15.72,14.84,13.91,12.53,11.03,10.69,11.47,12.41,12.81,13.19,13.62,13.0,11.34,9.81,9.5,9.81,9.97,10.75,12.22,13.44,13.78,13.5,14.0,14.78,15.91,16.56,16.72,16.78,15.84,14.03,12.25,11.78,12.16,11.97,11.62,11.28,11.31,10.59,9.03,8.09,7.81,7.19,5.59,4.47,4.06,4.03,3.81,4.38,6.53,9.47,11.47,12.72,14.12,15.03,14.69,13.75,13.72,15.03,16.28,17.03,17.81,18.53,18.44,17.09,15.72,15.0,15.0,14.44,13.31,13.06,13.56,14.12,14.25,15.53,17.19,18.66,18.81,18.97,19.53,20.44,20.53,20.25,20.5,20.94,20.59,19.47,18.69,18.72,17.88,15.97,14.84,13.97,13.31,11.84,10.88,10.62,10.53,9.75,9.25,9.62,10.66,11.72,12.59,13.97,15.72,16.69,17.22,17.53,18.56,19.62,19.97,20.34,21.0,21.88,21.41,20.34,19.88,19.38,18.47,17.69,17.59,18.38,19.38,19.44,19.34,19.19,18.88,17.59,16.0,15.72,16.47,16.59,16.47,16.5,16.69,15.91,14.94,14.53,15.94,17.81,19.25,20.88,22.59,23.5,23.0,22.0,21.59,22.03,22.09,22.0,22.59,23.91,24.28,23.88,22.78,22.25,21.09,19.47,18.09,17.66,18.03,17.41,16.91,17.22,18.12,18.56,17.84,17.91,18.81,19.69,19.88,20.44,21.62,22.22,21.16,20.25,20.12,20.38,19.88,19.5,20.0,20.5,20.41,19.97,20.31,22.06,23.41,24.03,24.59,24.56,23.88,21.59,19.38,18.22,18.03,17.47,17.31,18.12,19.5,20.31,20.28,20.41,21.34,22.09,22.31,23.06,24.53,26.09,26.53,26.62,27.47,28.47,28.84,29.41,30.12,31.41,31.62,30.44,29.28,27.84,26.44,24.47,22.91,22.78,23.41,23.78,24.38,25.94,27.97,28.72,29.16,29.56,30.41,30.12,29.31,28.56,28.97,29.78,30.31,31.44,33.78,36.03,36.81,36.69,36.03,35.5,34.09,32.47,31.59,31.78,31.78,31.12,30.62,30.5,30.25,29.44,28.12,27.78,27.88,27.22,26.62,27.06,28.25,28.28,28.03,27.59,27.72,27.69,27.97,28.78,30.53,32.44,32.62,32.66,33.28,33.84,33.88,33.5,33.44,33.75,33.34,32.31,31.47,31.06,30.88,29.72,28.81,29.47,30.22,40.34,39.69,38.47,38.06,38.12,39.25,40.88,43.34,46.56,49.47,52.06,54.16,55.91,56.59:-5.22,-6.62,-6.66,-5.62,-4.44,-3.75,-2.47,-0.81,-0.19,-1.03,-2.41,-3.94,-4.94,-7.22,-9.0,-9.69,-9.41,-9.62,-9.78,-9.97,-9.59,-9.25,-9.75,-9.81,-8.69,-7.41,-6.78,-5.69,-4.03,-2.34,-1.44,-0.78,0.09,1.03,0.78,0.0,-0.41,-0.06,0.34,0.66,1.44,2.62,3.28,2.69,1.72,0.94,0.56,-0.41,-1.44,-1.5,-1.03,-1.19,-1.81,-2.59,-2.97,-3.88,-5.81,-7.47,-7.84,-8.0,-8.59,-9.03,-8.69,-7.41,-6.94,-6.41,-4.91,-3.19,-1.81,-1.25,-0.53,0.97,2.31,2.53,2.41,2.75,2.88,1.44,-0.25,-0.66,-0.88,-1.53,-2.44,-3.09,-3.22,-3.78,-5.22,-5.75,-5.16,-4.19,-3.56,-3.72,-2.97,-2.59,-3.88,-5.69,-7.16,-8.03,-9.47,-11.16,-11.75,-11.34,-11.03,-10.84,-9.78,-7.44,-4.97,-3.12,-1.97,-0.66,0.28,-0.19,-1.78,-2.59,-3.09,-4.59,-6.31,-7.78,-8.16,-8.72,-9.69,-10.12,-9.62,-8.66,-8.44,-8.59,-7.72,-6.22,-5.62,-4.84,-3.25,-1.44,-1.0,-1.22,-2.44,-3.38,-3.97,-5.25,-6.0,-5.19,-3.84,-3.12,-2.22,-0.34,1.59,2.81,3.25,3.41,3.88,3.12,1.75,0.25,-0.66,-1.31,-2.59,-3.16,-2.34,-1.19,-1.12,-1.75,-2.38,-2.97,-4.16,-5.81,-6.59,-6.66,-7.28,-8.56,-10.19,-10.56,-11.06,-12.44,-13.28,-13.12,-12.56,-12.06,-11.56,-9.78,-7.31,-5.34,-4.03,-3.0,-1.25,-0.81,-1.19,-1.62,-1.09,-0.84,-1.31,-2.25,-2.44,-2.19,-3.16,-4.19,-4.47,-3.94,-4.28,-4.59,-5.06,-5.06,-5.47,-7.06,-8.47,-9.06,-9.34,-9.78,-10.28,-9.25,-7.72,-6.69,-5.84,-4.78,-3.25,-2.41,-2.47,-1.94,-0.66,0.59,1.34,1.44,2.5,3.53,3.06,2.41,2.03,2.03,1.19,0.03,-0.62,-0.5,-0.75,-1.25,-2.03,-1.88,-2.06,-2.41,-2.75,-1.62,0.72,2.97,5.03,7.66,10.03,10.78,9.91,7.91,6.16,3.72,0.72,-2.0,-3.62,-5.03,-7.31,-9.81,-11.0,-11.31,-11.72,-12.12,-11.22,-10.03,-9.25,-9.16,-8.44,-6.72,-4.78,-3.59,-2.28,0.41,2.81,4.66,5.81,7.69,8.91,8.94,7.28,5.81,4.31,2.69,0.44,-0.66,-0.34,0.0,-0.16,-0.47,0.25,1.12,1.16,0.31,0.06,-0.25,-1.12,-2.53,-3.19,-2.97,-2.91,-3.69,-4.25,-3.84,-3.34,-3.84,-4.44,-3.25,-1.62,-0.03,1.81,4.69,7.53,9.66,10.34,10.44,10.62,9.56,7.03,4.31,2.38,0.66,-1.53,-3.75,-4.5,-4.88,-5.12,-5.19,-3.88,-1.75,0.38,2.0,4.38,7.03,9.44,10.56,11.09,11.81,11.59,9.94,7.78,6.72,6.06,5.88,6.0,7.38,9.81,11.88,12.28,12.72,13.03,12.31,10.34,8.28,7.66,6.84,5.81,4.59,4.16,4.41,4.69,4.78,5.75,7.31,8.88,9.28,9.97,12.03,13.91,14.78,14.75,14.75,14.12,12.62,10.38,8.5,7.5,5.94,4.03,3.22,4.03,5.91,7.34,9.5,12.91,15.59,16.97,17.47,18.09,18.62,18.12,16.78,15.97,14.81,13.53,11.41,9.56,8.75,8.28,6.72,5.5,5.09,4.88,3.72,3.0,3.28,4.47,5.72,7.06,8.81,10.94,12.0,11.47,10.94,10.81,11.19,10.72,11.12,12.06,12.69,12.34,11.94,12.16,12.94,13.56,13.5,13.97,14.22,14.22,13.16,12.56,12.5,13.12,12.84,13.16,13.72,13.84,12.88,10.78,9.47,8.53,7.72,6.75,6.5,6.56,6.34,5.16,3.41,3.06,2.62,1.62,1.53,2.22,3.41,4.41,5.0,6.0,7.28,8.34,8.38,8.53,9.03,9.22,8.41,7.0,6.12,5.47,4.06,3.0,2.81,3.47,3.62,3.25,3.75,5.16,6.25,6.25,6.69,7.62,8.12,6.75,5.31,4.06,2.78,0.88,-0.84,-1.38,-0.91,-0.53,-0.16,0.72,2.12,3.25,3.47,3.47,3.81,4.38,4.03,3.72,4.31,5.69,6.03,6.41,7.41,8.69,9.44,9.22,9.69,10.84,11.97,12.56,13.12,14.12,14.66,13.72,12.69,12.0,11.78,10.47,8.97,8.25,8.09,7.53,7.31,7.06,7.19,6.91,5.19,3.47,2.09,1.12,0.19,0.09,0.94,2.47,3.41,3.5,3.41,3.75,3.25,1.84,0.88,0.22,0.25,-0.06,0.19,1.53,3.12,3.56,3.28,3.38,3.72,3.91,4.12,5.19,7.19,8.84,9.06,9.19,9.12,8.69,7.03,5.94,6.0,7.38,9.22,11.31,14.0,16.62,17.59,17.0,15.41,14.06,12.91,10.84,9.56,9.56,10.19,10.09,10.03,10.41,11.12,10.72,10.03,10.22,11.44,12.53,13.53,14.91,16.72,17.94,17.69,16.91,16.25,15.06,12.94,10.5,8.62,7.31,5.41,3.22,2.0,1.56,1.22,2.03,3.69,6.78,10.22,12.59,14.69,16.59,17.94,17.44,16.41,14.84,13.38,11.16,9.0,7.0,6.75,7.38,7.81,9.28,11.75,13.78,14.44,14.19,13.75,13.75,13.0,12.03,11.16,10.66,8.81,6.19,3.88,2.72,2.41,3.0,4.31,7.25,10.06,11.75,12.78,13.47,14.03,14.22,13.84,14.53,16.09,17.09,17.25,17.16,17.03,16.34,15.09,14.06,13.97,14.12,13.88,13.09,12.56,12.38,11.5,10.31,9.75,9.97,9.91,8.94,8.38,8.66,8.88,8.62,8.56,9.19,9.84,9.72,9.19,8.94,9.09,8.84,8.62,8.56,9.78,10.59,10.5,10.53,11.38,12.19,12.97,13.28,14.31,14.97,14.62,13.44,12.66,12.59,12.16,11.62,11.31,12.19,13.03,13.28,13.94,14.88,15.31,14.75,13.69,13.59,14.09,14.94,15.81,17.25,18.94,19.28,17.88,15.66,13.25,10.69,8.34,6.84,6.94,8.06,8.69,9.12,10.34,11.59,12.66,13.31,14.25,15.81,16.94,17.41,17.31,17.06,16.22,14.0,11.28,9.31,8.31,7.06,6.03,6.34,7.22,7.84,7.75,7.97,8.81,9.34,9.53,9.75,10.62,11.22,10.88,10.19,10.09,9.91,9.56,9.09,9.03,8.91,8.34,7.38,6.69,7.41,8.5,9.47,10.25,10.81,10.72,9.28,6.75,5.22,4.81,4.53,4.41,5.66,7.28,8.19,8.53,8.75,9.53,10.41,11.03,11.75,13.75,15.59,16.38,16.53,16.31,16.44,15.56,14.19,13.34,12.88,12.41,10.94,9.5,8.5,7.53,6.0,4.84,5.28,6.59,7.47,8.0,9.19,9.78,9.75,9.19,9.16,10.22,11.53,12.47,13.53,15.41,16.72,16.69,15.69,15.06,13.91,12.47,10.59,9.88,9.81,9.91,9.19,8.69,8.53,8.31,7.47,7.41,8.47,9.94,10.97,11.19,12.06,12.47,13.09,13.44,14.53,16.19,17.78,18.19,18.16,18.5,18.47,17.28,15.72,14.84,13.91,12.53,11.03,10.69,11.47,12.41,12.81,13.19,13.62,13.0,11.34,9.81,9.5,9.81,9.97,10.75,12.22,13.44,13.78,13.5,14.0,14.78,15.91,16.56,16.72,16.78,15.84,14.03,12.25,11.78,12.16,11.97,11.62,11.28,11.31,10.59,9.03,8.09,7.81,7.19,5.59,4.47,4.06,4.03,3.81,4.38,6.53,9.47,11.47,12.72,14.12,15.03,14.69,13.75,13.72,15.03,16.28,17.03,17.81,18.53,18.44,17.09,15.72,15.0,15.0,14.44,13.31,13.06,13.56,14.12,14.25,15.53,17.19,18.66,18.81,18.97,19.53,20.44,20.53,20.25,20.5,20.94,20.59,19.47,18.69,18.72,17.88,15.97,14.84,13.97,13.31,11.84,10.88,10.62,10.53,9.75,9.25,9.62,10.66,11.72,12.59,13.97,15.72,16.69,17.22,17.53,18.56,19.62,19.97,20.34,21.0,21.88,21.41,20.34,19.88,19.38,18.47,17.69,17.59,18.38,19.38,19.44,19.34,19.19,18.88,17.59,16.0,15.72,16.47,16.59,16.47,16.5,16.69,15.91,14.94,14.53,15.94,17.81,19.25,20.88,22.59,23.5,23.0,22.0,21.59,22.03,22.09,22.0,22.59,23.91,24.28,23.88,22.78,22.25,21.09,19.47,18.09,17.66,18.03,17.41,16.91,17.22,18.12,18.56,17.84,17.91,18.81,19.69,19.88,20.44,21.62,22.22,21.16,20.25,20.12,20.38,19.88,19.5,20.0,20.5,20.41,19.97,20.31,22.06,23.41,24.03,24.59,24.56,23.88,21.59,19.38,18.22,18.03,17.47,17.31,18.12,19.5,20.31,20.28,20.41,21.34,22.09,22.31,23.06,24.53,26.09,26.53,26.62,27.47,28.47,28.84,29.41,30.12,31.41,31.62,30.44,29.28,27.84,26.44,24.47,22.91,22.78,23.41,23.78,24.38,25.94,27.97,28.72,29.16,29.56,30.41,30.12,29.31,28.56,28.97,29.78,30.31,31.44,33.78,36.03,36.81,36.69,36.03,35.5,34.09,32.47,31.59,31.78,31.78,31.12,30.62,30.5,30.25,29.44,28.12,27.78,27.88,27.22,26.62,27.06,28.25,28.28,28.03,27.59,27.72,27.69,27.97,28.78,30.53,32.44,32.62,32.66,33.28,33.84,33.88,33.5,33.44,33.75,33.34,32.31,31.47,31.06,30.88,29.72,28.81,29.47,30.22,40.34,39.69,38.47,38.06,38.12,39.25,40.88,43.34,46.56,49.47,52.06,54.16,55.91,56.59,56.84,55.91,54.75,52.75,50.34,47.47,45.19:-0.81,-0.19,-1.03,-2.41,-3.94,-4.94,-7.22,-9.0,-9.69,-9.41,-9.62,-9.78,-9.97,-9.59,-9.25,-9.75,-9.81,-8.69,-7.41,-6.78,-5.69,-4.03,-2.34,-1.44,-0.78,0.09,1.03,0.78,0.0,-0.41,-0.06,0.34,0.66,1.44,2.62,3.28,2.69,1.72,0.94,0.56,-0.41,-1.44,-1.5,-1.03,-1.19,-1.81,-2.59,-2.97,-3.88,-5.81,-7.47,-7.84,-8.0,-8.59,-9.03,-8.69,-7.41,-6.94,-6.41,-4.91,-3.19,-1.81,-1.25,-0.53,0.97,2.31,2.53,2.41,2.75,2.88,1.44,-0.25,-0.66,-0.88,-1.53,-2.44,-3.09,-3.22,-3.78,-5.22,-5.75,-5.16,-4.19,-3.56,-3.72,-2.97,-2.59,-3.88,-5.69,-7.16,-8.03,-9.47,-11.16,-11.75,-11.34,-11.03,-10.84,-9.78,-7.44,-4.97,-3.12,-1.97,-0.66,0.28,-0.19,-1.78,-2.59,-3.09,-4.59,-6.31,-7.78,-8.16,-8.72,-9.69,-10.12,-9.62,-8.66,-8.44,-8.59,-7.72,-6.22,-5.62,-4.84,-3.25,-1.44,-1.0,-1.22,-2.44,-3.38,-3.97,-5.25,-6.0,-5.19,-3.84,-3.12,-2.22,-0.34,1.59,2.81,3.25,3.41,3.88,3.12,1.75,0.25,-0.66,-1.31,-2.59,-3.16,-2.34,-1.19,-1.12,-1.75,-2.38,-2.97,-4.16,-5.81,-6.59,-6.66,-7.28,-8.56,-10.19,-10.56,-11.06,-12.44,-13.28,-13.12,-12.56,-12.06,-11.56,-9.78,-7.31,-5.34,-4.03,-3.0,-1.25,-0.81,-1.19,-1.62,-1.09,-0.84,-1.31,-2.25,-2.44,-2.19,-3.16,-4.19,-4.47,-3.94,-4.28,-4.59,-5.06,-5.06,-5.47,-7.06,-8.47,-9.06,-9.34,-9.78,-10.28,-9.25,-7.72,-6.69,-5.84,-4.78,-3.25,-2.41,-2.47,-1.94,-0.66,0.59,1.34,1.44,2.5,3.53,3.06,2.41,2.03,2.03,1.19,0.03,-0.62,-0.5,-0.75,-1.25,-2.03,-1.88,-2.06,-2.41,-2.75,-1.62,0.72,2.97,5.03,7.66,10.03,10.78,9.91,7.91,6.16,3.72,0.72,-2.0,-3.62,-5.03,-7.31,-9.81,-11.0,-11.31,-11.72,-12.12,-11.22,-10.03,-9.25,-9.16,-8.44,-6.72,-4.78,-3.59,-2.28,0.41,2.81,4.66,5.81,7.69,8.91,8.94,7.28,5.81,4.31,2.69,0.44,-0.66,-0.34,0.0,-0.16,-0.47,0.25,1.12,1.16,0.31,0.06,-0.25,-1.12,-2.53,-3.19,-2.97,-2.91,-3.69,-4.25,-3.84,-3.34,-3.84,-4.44,-3.25,-1.62,-0.03,1.81,4.69,7.53,9.66,10.34,10.44,10.62,9.56,7.03,4.31,2.38,0.66,-1.53,-3.75,-4.5,-4.88,-5.12,-5.19,-3.88,-1.75,0.38,2.0,4.38,7.03,9.44,10.56,11.09,11.81,11.59,9.94,7.78,6.72,6.06,5.88,6.0,7.38,9.81,11.88,12.28,12.72,13.03,12.31,10.34,8.28,7.66,6.84,5.81,4.59,4.16,4.41,4.69,4.78,5.75,7.31,8.88,9.28,9.97,12.03,13.91,14.78,14.75,14.75,14.12,12.62,10.38,8.5,7.5,5.94,4.03,3.22,4.03,5.91,7.34,9.5,12.91,15.59,16.97,17.47,18.09,18.62,18.12,16.78,15.97,14.81,13.53,11.41,9.56,8.75,8.28,6.72,5.5,5.09,4.88,3.72,3.0,3.28,4.47,5.72,7.06,8.81,10.94,12.0,11.47,10.94,10.81,11.19,10.72,11.12,12.06,12.69,12.34,11.94,12.16,12.94,13.56,13.5,13.97,14.22,14.22,13.16,12.56,12.5,13.12,12.84,13.16,13.72,13.84,12.88,10.78,9.47,8.53,7.72,6.75,6.5,6.56,6.34,5.16,3.41,3.06,2.62,1.62,1.53,2.22,3.41,4.41,5.0,6.0,7.28,8.34,8.38,8.53,9.03,9.22,8.41,7.0,6.12,5.47,4.06,3.0,2.81,3.47,3.62,3.25,3.75,5.16,6.25,6.25,6.69,7.62,8.12,6.75,5.31,4.06,2.78,0.88,-0.84,-1.38,-0.91,-0.53,-0.16,0.72,2.12,3.25,3.47,3.47,3.81,4.38,4.03,3.72,4.31,5.69,6.03,6.41,7.41,8.69,9.44,9.22,9.69,10.84,11.97,12.56,13.12,14.12,14.66,13.72,12.69,12.0,11.78,10.47,8.97,8.25,8.09,7.53,7.31,7.06,7.19,6.91,5.19,3.47,2.09,1.12,0.19,0.09,0.94,2.47,3.41,3.5,3.41,3.75,3.25,1.84,0.88,0.22,0.25,-0.06,0.19,1.53,3.12,3.56,3.28,3.38,3.72,3.91,4.12,5.19,7.19,8.84,9.06,9.19,9.12,8.69,7.03,5.94,6.0,7.38,9.22,11.31,14.0,16.62,17.59,17.0,15.41,14.06,12.91,10.84,9.56,9.56,10.19,10.09,10.03,10.41,11.12,10.72,10.03,10.22,11.44,12.53,13.53,14.91,16.72,17.94,17.69,16.91,16.25,15.06,12.94,10.5,8.62,7.31,5.41,3.22,2.0,1.56,1.22,2.03,3.69,6.78,10.22,12.59,14.69,16.59,17.94,17.44,16.41,14.84,13.38,11.16,9.0,7.0,6.75,7.38,7.81,9.28,11.75,13.78,14.44,14.19,13.75,13.75,13.0,12.03,11.16,10.66,8.81,6.19,3.88,2.72,2.41,3.0,4.31,7.25,10.06,11.75,12.78,13.47,14.03,14.22,13.84,14.53,16.09,17.09,17.25,17.16,17.03,16.34,15.09,14.06,13.97,14.12,13.88,13.09,12.56,12.38,11.5,10.31,9.75,9.97,9.91,8.94,8.38,8.66,8.88,8.62,8.56,9.19,9.84,9.72,9.19,8.94,9.09,8.84,8.62,8.56,9.78,10.59,10.5,10.53,11.38,12.19,12.97,13.28,14.31,14.97,14.62,13.44,12.66,12.59,12.16,11.62,11.31,12.19,13.03,13.28,13.94,14.88,15.31,14.75,13.69,13.59,14.09,14.94,15.81,17.25,18.94,19.28,17.88,15.66,13.25,10.69,8.34,6.84,6.94,8.06,8.69,9.12,10.34,11.59,12.66,13.31,14.25,15.81,16.94,17.41,17.31,17.06,16.22,14.0,11.28,9.31,8.31,7.06,6.03,6.34,7.22,7.84,7.75,7.97,8.81,9.34,9.53,9.75,10.62,11.22,10.88,10.19,10.09,9.91,9.56,9.09,9.03,8.91,8.34,7.38,6.69,7.41,8.5,9.47,10.25,10.81,10.72,9.28,6.75,5.22,4.81,4.53,4.41,5.66,7.28,8.19,8.53,8.75,9.53,10.41,11.03,11.75,13.75,15.59,16.38,16.53,16.31,16.44,15.56,14.19,13.34,12.88,12.41,10.94,9.5,8.5,7.53,6.0,4.84,5.28,6.59,7.47,8.0,9.19,9.78,9.75,9.19,9.16,10.22,11.53,12.47,13.53,15.41,16.72,16.69,15.69,15.06,13.91,12.47,10.59,9.88,9.81,9.91,9.19,8.69,8.53,8.31,7.47,7.41,8.47,9.94,10.97,11.19,12.06,12.47,13.09,13.44,14.53,16.19,17.78,18.19,18.16,18.5,18.47,17.28,15.72,14.84,13.91,12.53,11.03,10.69,11.47,12.41,12.81,13.19,13.62,13.0,11.34,9.81,9.5,9.81,9.97,10.75,12.22,13.44,13.78,13.5,14.0,14.78,15.91,16.56,16.72,16.78,15.84,14.03,12.25,11.78,12.16,11.97,11.62,11.28,11.31,10.59,9.03,8.09,7.81,7.19,5.59,4.47,4.06,4.03,3.81,4.38,6.53,9.47,11.47,12.72,14.12,15.03,14.69,13.75,13.72,15.03,16.28,17.03,17.81,18.53,18.44,17.09,15.72,15.0,15.0,14.44,13.31,13.06,13.56,14.12,14.25,15.53,17.19,18.66,18.81,18.97,19.53,20.44,20.53,20.25,20.5,20.94,20.59,19.47,18.69,18.72,17.88,15.97,14.84,13.97,13.31,11.84,10.88,10.62,10.53,9.75,9.25,9.62,10.66,11.72,12.59,13.97,15.72,16.69,17.22,17.53,18.56,19.62,19.97,20.34,21.0,21.88,21.41,20.34,19.88,19.38,18.47,17.69,17.59,18.38,19.38,19.44,19.34,19.19,18.88,17.59,16.0,15.72,16.47,16.59,16.47,16.5,16.69,15.91,14.94,14.53,15.94,17.81,19.25,20.88,22.59,23.5,23.0,22.0,21.59,22.03,22.09,22.0,22.59,23.91,24.28,23.88,22.78,22.25,21.09,19.47,18.09,17.66,18.03,17.41,16.91,17.22,18.12,18.56,17.84,17.91,18.81,19.69,19.88,20.44,21.62,22.22,21.16,20.25,20.12,20.38,19.88,19.5,20.0,20.5,20.41,19.97,20.31,22.06,23.41,24.03,24.59,24.56,23.88,21.59,19.38,18.22,18.03,17.47,17.31,18.12,19.5,20.31,20.28,20.41,21.34,22.09,22.31,23.06,24.53,26.09,26.53,26.62,27.47,28.47,28.84,29.41,30.12,31.41,31.62,30.44,29.28,27.84,26.44,24.47,22.91,22.78,23.41,23.78,24.38,25.94,27.97,28.72,29.16,29.56,30.41,30.12,29.31,28.56,28.97,29.78,30.31,31.44,33.78,36.03,36.81,36.69,36.03,35.5,34.09,32.47,31.59,31.78,31.78,31.12,30.62,30.5,30.25,29.44,28.12,27.78,27.88,27.22,26.62,27.06,28.25,28.28,28.03,27.59,27.72,27.69,27.97,28.78,30.53,32.44,32.62,32.66,33.28,33.84,33.88,33.5,33.44,33.75,33.34,32.31,31.47,31.06,30.88,29.72,28.81,29.47,30.22,40.34,39.69,38.47,38.06,38.12,39.25,40.88,43.34,46.56,49.47,52.06,54.16,55.91,56.59,56.84,55.91,54.75,52.75,50.34,47.47,45.19,43.84,43.03,42.44,42.84,43.88,44.91,46.25:-9.0,-9.69,-9.41,-9.62,-9.78,-9.97,-9.59,-9.25,-9.75,-9.81,-8.69,-7.41,-6.78,-5.69,-4.03,-2.34,-1.44,-0.78,0.09,1.03,0.78,0.0,-0.41,-0.06,0.34,0.66,1.44,2.62,3.28,2.69,1.72,0.94,0.56,-0.41,-1.44,-1.5,-1.03,-1.19,-1.81,-2.59,-2.97,-3.88,-5.81,-7.47,-7.84,-8.0,-8.59,-9.03,-8.69,-7.41,-6.94,-6.41,-4.91,-3.19,-1.81,-1.25,-0.53,0.97,2.31,2.53,2.41,2.75,2.88,1.44,-0.25,-0.66,-0.88,-1.53,-2.44,-3.09,-3.22,-3.78,-5.22,-5.75,-5.16,-4.19,-3.56,-3.72,-2.97,-2.59,-3.88,-5.69,-7.16,-8.03,-9.47,-11.16,-11.75,-11.34,-11.03,-10.84,-9.78,-7.44,-4.97,-3.12,-1.97,-0.66,0.28,-0.19,-1.78,-2.59,-3.09,-4.59,-6.31,-7.78,-8.16,-8.72,-9.69,-10.12,-9.62,-8.66,-8.44,-8.59,-7.72,-6.22,-5.62,-4.84,-3.25,-1.44,-1.0,-1.22,-2.44,-3.38,-3.97,-5.25,-6.0,-5.19,-3.84,-3.12,-2.22,-0.34,1.59,2.81,3.25,3.41,3.88,3.12,1.75,0.25,-0.66,-1.31,-2.59,-3.16,-2.34,-1.19,-1.12,-1.75,-2.38,-2.97,-4.16,-5.81,-6.59,-6.66,-7.28,-8.56,-10.19,-10.56,-11.06,-12.44,-13.28,-13.12,-12.56,-12.06,-11.56,-9.78,-7.31,-5.34,-4.03,-3.0,-1.25,-0.81,-1.19,-1.62,-1.09,-0.84,-1.31,-2.25,-2.44,-2.19,-3.16,-4.19,-4.47,-3.94,-4.28,-4.59,-5.06,-5.06,-5.47,-7.06,-8.47,-9.06,-9.34,-9.78,-10.28,-9.25,-7.72,-6.69,-5.84,-4.78,-3.25,-2.41,-2.47,-1.94,-0.66,0.59,1.34,1.44,2.5,3.53,3.06,2.41,2.03,2.03,1.19,0.03,-0.62,-0.5,-0.75,-1.25,-2.03,-1.88,-2.06,-2.41,-2.75,-1.62,0.72,2.97,5.03,7.66,10.03,10.78,9.91,7.91,6.16,3.72,0.72,-2.0,-3.62,-5.03,-7.31,-9.81,-11.0,-11.31,-11.72,-12.12,-11.22,-10.03,-9.25,-9.16,-8.44,-6.72,-4.78,-3.59,-2.28,0.41,2.81,4.66,5.81,7.69,8.91,8.94,7.28,5.81,4.31,2.69,0.44,-0.66,-0.34,0.0,-0.16,-0.47,0.25,1.12,1.16,0.31,0.06,-0.25,-1.12,-2.53,-3.19,-2.97,-2.91,-3.69,-4.25,-3.84,-3.34,-3.84,-4.44,-3.25,-1.62,-0.03,1.81,4.69,7.53,9.66,10.34,10.44,10.62,9.56,7.03,4.31,2.38,0.66,-1.53,-3.75,-4.5,-4.88,-5.12,-5.19,-3.88,-1.75,0.38,2.0,4.38,7.03,9.44,10.56,11.09,11.81,11.59,9.94,7.78,6.72,6.06,5.88,6.0,7.38,9.81,11.88,12.28,12.72,13.03,12.31,10.34,8.28,7.66,6.84,5.81,4.59,4.16,4.41,4.69,4.78,5.75,7.31,8.88,9.28,9.97,12.03,13.91,14.78,14.75,14.75,14.12,12.62,10.38,8.5,7.5,5.94,4.03,3.22,4.03,5.91,7.34,9.5,12.91,15.59,16.97,17.47,18.09,18.62,18.12,16.78,15.97,14.81,13.53,11.41,9.56,8.75,8.28,6.72,5.5,5.09,4.88,3.72,3.0,3.28,4.47,5.72,7.06,8.81,10.94,12.0,11.47,10.94,10.81,11.19,10.72,11.12,12.06,12.69,12.34,11.94,12.16,12.94,13.56,13.5,13.97,14.22,14.22,13.16,12.56,12.5,13.12,12.84,13.16,13.72,13.84,12.88,10.78,9.47,8.53,7.72,6.75,6.5,6.56,6.34,5.16,3.41,3.06,2.62,1.62,1.53,2.22,3.41,4.41,5.0,6.0,7.28,8.34,8.38,8.53,9.03,9.22,8.41,7.0,6.12,5.47,4.06,3.0,2.81,3.47,3.62,3.25,3.75,5.16,6.25,6.25,6.69,7.62,8.12,6.75,5.31,4.06,2.78,0.88,-0.84,-1.38,-0.91,-0.53,-0.16,0.72,2.12,3.25,3.47,3.47,3.81,4.38,4.03,3.72,4.31,5.69,6.03,6.41,7.41,8.69,9.44,9.22,9.69,10.84,11.97,12.56,13.12,14.12,14.66,13.72,12.69,12.0,11.78,10.47,8.97,8.25,8.09,7.53,7.31,7.06,7.19,6.91,5.19,3.47,2.09,1.12,0.19,0.09,0.94,2.47,3.41,3.5,3.41,3.75,3.25,1.84,0.88,0.22,0.25,-0.06,0.19,1.53,3.12,3.56,3.28,3.38,3.72,3.91,4.12,5.19,7.19,8.84,9.06,9.19,9.12,8.69,7.03,5.94,6.0,7.38,9.22,11.31,14.0,16.62,17.59,17.0,15.41,14.06,12.91,10.84,9.56,9.56,10.19,10.09,10.03,10.41,11.12,10.72,10.03,10.22,11.44,12.53,13.53,14.91,16.72,17.94,17.69,16.91,16.25,15.06,12.94,10.5,8.62,7.31,5.41,3.22,2.0,1.56,1.22,2.03,3.69,6.78,10.22,12.59,14.69,16.59,17.94,17.44,16.41,14.84,13.38,11.16,9.0,7.0,6.75,7.38,7.81,9.28,11.75,13.78,14.44,14.19,13.75,13.75,13.0,12.03,11.16,10.66,8.81,6.19,3.88,2.72,2.41,3.0,4.31,7.25,10.06,11.75,12.78,13.47,14.03,14.22,13.84,14.53,16.09,17.09,17.25,17.16,17.03,16.34,15.09,14.06,13.97,14.12,13.88,13.09,12.56,12.38,11.5,10.31,9.75,9.97,9.91,8.94,8.38,8.66,8.88,8.62,8.56,9.19,9.84,9.72,9.19,8.94,9.09,8.84,8.62,8.56,9.78,10.59,10.5,10.53,11.38,12.19,12.97,13.28,14.31,14.97,14.62,13.44,12.66,12.59,12.16,11.62,11.31,12.19,13.03,13.28,13.94,14.88,15.31,14.75,13.69,13.59,14.09,14.94,15.81,17.25,18.94,19.28,17.88,15.66,13.25,10.69,8.34,6.84,6.94,8.06,8.69,9.12,10.34,11.59,12.66,13.31,14.25,15.81,16.94,17.41,17.31,17.06,16.22,14.0,11.28,9.31,8.31,7.06,6.03,6.34,7.22,7.84,7.75,7.97,8.81,9.34,9.53,9.75,10.62,11.22,10.88,10.19,10.09,9.91,9.56,9.09,9.03,8.91,8.34,7.38,6.69,7.41,8.5,9.47,10.25,10.81,10.72,9.28,6.75,5.22,4.81,4.53,4.41,5.66,7.28,8.19,8.53,8.75,9.53,10.41,11.03,11.75,13.75,15.59,16.38,16.53,16.31,16.44,15.56,14.19,13.34,12.88,12.41,10.94,9.5,8.5,7.53,6.0,4.84,5.28,6.59,7.47,8.0,9.19,9.78,9.75,9.19,9.16,10.22,11.53,12.47,13.53,15.41,16.72,16.69,15.69,15.06,13.91,12.47,10.59,9.88,9.81,9.91,9.19,8.69,8.53,8.31,7.47,7.41,8.47,9.94,10.97,11.19,12.06,12.47,13.09,13.44,14.53,16.19,17.78,18.19,18.16,18.5,18.47,17.28,15.72,14.84,13.91,12.53,11.03,10.69,11.47,12.41,12.81,13.19,13.62,13.0,11.34,9.81,9.5,9.81,9.97,10.75,12.22,13.44,13.78,13.5,14.0,14.78,15.91,16.56,16.72,16.78,15.84,14.03,12.25,11.78,12.16,11.97,11.62,11.28,11.31,10.59,9.03,8.09,7.81,7.19,5.59,4.47,4.06,4.03,3.81,4.38,6.53,9.47,11.47,12.72,14.12,15.03,14.69,13.75,13.72,15.03,16.28,17.03,17.81,18.53,18.44,17.09,15.72,15.0,15.0,14.44,13.31,13.06,13.56,14.12,14.25,15.53,17.19,18.66,18.81,18.97,19.53,20.44,20.53,20.25,20.5,20.94,20.59,19.47,18.69,18.72,17.88,15.97,14.84,13.97,13.31,11.84,10.88,10.62,10.53,9.75,9.25,9.62,10.66,11.72,12.59,13.97,15.72,16.69,17.22,17.53,18.56,19.62,19.97,20.34,21.0,21.88,21.41,20.34,19.88,19.38,18.47,17.69,17.59,18.38,19.38,19.44,19.34,19.19,18.88,17.59,16.0,15.72,16.47,16.59,16.47,16.5,16.69,15.91,14.94,14.53,15.94,17.81,19.25,20.88,22.59,23.5,23.0,22.0,21.59,22.03,22.09,22.0,22.59,23.91,24.28,23.88,22.78,22.25,21.09,19.47,18.09,17.66,18.03,17.41,16.91,17.22,18.12,18.56,17.84,17.91,18.81,19.69,19.88,20.44,21.62,22.22,21.16,20.25,20.12,20.38,19.88,19.5,20.0,20.5,20.41,19.97,20.31,22.06,23.41,24.03,24.59,24.56,23.88,21.59,19.38,18.22,18.03,17.47,17.31,18.12,19.5,20.31,20.28,20.41,21.34,22.09,22.31,23.06,24.53,26.09,26.53,26.62,27.47,28.47,28.84,29.41,30.12,31.41,31.62,30.44,29.28,27.84,26.44,24.47,22.91,22.78,23.41,23.78,24.38,25.94,27.97,28.72,29.16,29.56,30.41,30.12,29.31,28.56,28.97,29.78,30.31,31.44,33.78,36.03,36.81,36.69,36.03,35.5,34.09,32.47,31.59,31.78,31.78,31.12,30.62,30.5,30.25,29.44,28.12,27.78,27.88,27.22,26.62,27.06,28.25,28.28,28.03,27.59,27.72,27.69,27.97,28.78,30.53,32.44,32.62,32.66,33.28,33.84,33.88,33.5,33.44,33.75,33.34,32.31,31.47,31.06,30.88,29.72,28.81,29.47,30.22,40.34,39.69,38.47,38.06,38.12,39.25,40.88,43.34,46.56,49.47,52.06,54.16,55.91,56.59,56.84,55.91,54.75,52.75,50.34,47.47,45.19,43.84,43.03,42.44,42.84,43.88,44.91,46.25,47.12,47.91,47.53,46.38,44.47,42.81,40.88:-9.25,-9.75,-9.81,-8.69,-7.41,-6.78,-5.69,-4.03,-2.34,-1.44,-0.78,0.09,1.03,0.78,0.0,-0.41,-0.06,0.34,0.66,1.44,2.62,3.28,2.69,1.72,0.94,0.56,-0.41,-1.44,-1.5,-1.03,-1.19,-1.81,-2.59,-2.97,-3.88,-5.81,-7.47,-7.84,-8.0,-8.59,-9.03,-8.69,-7.41,-6.94,-6.41,-4.91,-3.19,-1.81,-1.25,-0.53,0.97,2.31,2.53,2.41,2.75,2.88,1.44,-0.25,-0.66,-0.88,-1.53,-2.44,-3.09,-3.22,-3.78,-5.22,-5.75,-5.16,-4.19,-3.56,-3.72,-2.97,-2.59,-3.88,-5.69,-7.16,-8.03,-9.47,-11.16,-11.75,-11.34,-11.03,-10.84,-9.78,-7.44,-4.97,-3.12,-1.97,-0.66,0.28,-0.19,-1.78,-2.59,-3.09,-4.59,-6.31,-7.78,-8.16,-8.72,-9.69,-10.12,-9.62,-8.66,-8.44,-8.59,-7.72,-6.22,-5.62,-4.84,-3.25,-1.44,-1.0,-1.22,-2.44,-3.38,-3.97,-5.25,-6.0,-5.19,-3.84,-3.12,-2.22,-0.34,1.59,2.81,3.25,3.41,3.88,3.12,1.75,0.25,-0.66,-1.31,-2.59,-3.16,-2.34,-1.19,-1.12,-1.75,-2.38,-2.97,-4.16,-5.81,-6.59,-6.66,-7.28,-8.56,-10.19,-10.56,-11.06,-12.44,-13.28,-13.12,-12.56,-12.06,-11.56,-9.78,-7.31,-5.34,-4.03,-3.0,-1.25,-0.81,-1.19,-1.62,-1.09,-0.84,-1.31,-2.25,-2.44,-2.19,-3.16,-4.19,-4.47,-3.94,-4.28,-4.59,-5.06,-5.06,-5.47,-7.06,-8.47,-9.06,-9.34,-9.78,-10.28,-9.25,-7.72,-6.69,-5.84,-4.78,-3.25,-2.41,-2.47,-1.94,-0.66,0.59,1.34,1.44,2.5,3.53,3.06,2.41,2.03,2.03,1.19,0.03,-0.62,-0.5,-0.75,-1.25,-2.03,-1.88,-2.06,-2.41,-2.75,-1.62,0.72,2.97,5.03,7.66,10.03,10.78,9.91,7.91,6.16,3.72,0.72,-2.0,-3.62,-5.03,-7.31,-9.81,-11.0,-11.31,-11.72,-12.12,-11.22,-10.03,-9.25,-9.16,-8.44,-6.72,-4.78,-3.59,-2.28,0.41,2.81,4.66,5.81,7.69,8.91,8.94,7.28,5.81,4.31,2.69,0.44,-0.66,-0.34,0.0,-0.16,-0.47,0.25,1.12,1.16,0.31,0.06,-0.25,-1.12,-2.53,-3.19,-2.97,-2.91,-3.69,-4.25,-3.84,-3.34,-3.84,-4.44,-3.25,-1.62,-0.03,1.81,4.69,7.53,9.66,10.34,10.44,10.62,9.56,7.03,4.31,2.38,0.66,-1.53,-3.75,-4.5,-4.88,-5.12,-5.19,-3.88,-1.75,0.38,2.0,4.38,7.03,9.44,10.56,11.09,11.81,11.59,9.94,7.78,6.72,6.06,5.88,6.0,7.38,9.81,11.88,12.28,12.72,13.03,12.31,10.34,8.28,7.66,6.84,5.81,4.59,4.16,4.41,4.69,4.78,5.75,7.31,8.88,9.28,9.97,12.03,13.91,14.78,14.75,14.75,14.12,12.62,10.38,8.5,7.5,5.94,4.03,3.22,4.03,5.91,7.34,9.5,12.91,15.59,16.97,17.47,18.09,18.62,18.12,16.78,15.97,14.81,13.53,11.41,9.56,8.75,8.28,6.72,5.5,5.09,4.88,3.72,3.0,3.28,4.47,5.72,7.06,8.81,10.94,12.0,11.47,10.94,10.81,11.19,10.72,11.12,12.06,12.69,12.34,11.94,12.16,12.94,13.56,13.5,13.97,14.22,14.22,13.16,12.56,12.5,13.12,12.84,13.16,13.72,13.84,12.88,10.78,9.47,8.53,7.72,6.75,6.5,6.56,6.34,5.16,3.41,3.06,2.62,1.62,1.53,2.22,3.41,4.41,5.0,6.0,7.28,8.34,8.38,8.53,9.03,9.22,8.41,7.0,6.12,5.47,4.06,3.0,2.81,3.47,3.62,3.25,3.75,5.16,6.25,6.25,6.69,7.62,8.12,6.75,5.31,4.06,2.78,0.88,-0.84,-1.38,-0.91,-0.53,-0.16,0.72,2.12,3.25,3.47,3.47,3.81,4.38,4.03,3.72,4.31,5.69,6.03,6.41,7.41,8.69,9.44,9.22,9.69,10.84,11.97,12.56,13.12,14.12,14.66,13.72,12.69,12.0,11.78,10.47,8.97,8.25,8.09,7.53,7.31,7.06,7.19,6.91,5.19,3.47,2.09,1.12,0.19,0.09,0.94,2.47,3.41,3.5,3.41,3.75,3.25,1.84,0.88,0.22,0.25,-0.06,0.19,1.53,3.12,3.56,3.28,3.38,3.72,3.91,4.12,5.19,7.19,8.84,9.06,9.19,9.12,8.69,7.03,5.94,6.0,7.38,9.22,11.31,14.0,16.62,17.59,17.0,15.41,14.06,12.91,10.84,9.56,9.56,10.19,10.09,10.03,10.41,11.12,10.72,10.03,10.22,11.44,12.53,13.53,14.91,16.72,17.94,17.69,16.91,16.25,15.06,12.94,10.5,8.62,7.31,5.41,3.22,2.0,1.56,1.22,2.03,3.69,6.78,10.22,12.59,14.69,16.59,17.94,17.44,16.41,14.84,13.38,11.16,9.0,7.0,6.75,7.38,7.81,9.28,11.75,13.78,14.44,14.19,13.75,13.75,13.0,12.03,11.16,10.66,8.81,6.19,3.88,2.72,2.41,3.0,4.31,7.25,10.06,11.75,12.78,13.47,14.03,14.22,13.84,14.53,16.09,17.09,17.25,17.16,17.03,16.34,15.09,14.06,13.97,14.12,13.88,13.09,12.56,12.38,11.5,10.31,9.75,9.97,9.91,8.94,8.38,8.66,8.88,8.62,8.56,9.19,9.84,9.72,9.19,8.94,9.09,8.84,8.62,8.56,9.78,10.59,10.5,10.53,11.38,12.19,12.97,13.28,14.31,14.97,14.62,13.44,12.66,12.59,12.16,11.62,11.31,12.19,13.03,13.28,13.94,14.88,15.31,14.75,13.69,13.59,14.09,14.94,15.81,17.25,18.94,19.28,17.88,15.66,13.25,10.69,8.34,6.84,6.94,8.06,8.69,9.12,10.34,11.59,12.66,13.31,14.25,15.81,16.94,17.41,17.31,17.06,16.22,14.0,11.28,9.31,8.31,7.06,6.03,6.34,7.22,7.84,7.75,7.97,8.81,9.34,9.53,9.75,10.62,11.22,10.88,10.19,10.09,9.91,9.56,9.09,9.03,8.91,8.34,7.38,6.69,7.41,8.5,9.47,10.25,10.81,10.72,9.28,6.75,5.22,4.81,4.53,4.41,5.66,7.28,8.19,8.53,8.75,9.53,10.41,11.03,11.75,13.75,15.59,16.38,16.53,16.31,16.44,15.56,14.19,13.34,12.88,12.41,10.94,9.5,8.5,7.53,6.0,4.84,5.28,6.59,7.47,8.0,9.19,9.78,9.75,9.19,9.16,10.22,11.53,12.47,13.53,15.41,16.72,16.69,15.69,15.06,13.91,12.47,10.59,9.88,9.81,9.91,9.19,8.69,8.53,8.31,7.47,7.41,8.47,9.94,10.97,11.19,12.06,12.47,13.09,13.44,14.53,16.19,17.78,18.19,18.16,18.5,18.47,17.28,15.72,14.84,13.91,12.53,11.03,10.69,11.47,12.41,12.81,13.19,13.62,13.0,11.34,9.81,9.5,9.81,9.97,10.75,12.22,13.44,13.78,13.5,14.0,14.78,15.91,16.56,16.72,16.78,15.84,14.03,12.25,11.78,12.16,11.97,11.62,11.28,11.31,10.59,9.03,8.09,7.81,7.19,5.59,4.47,4.06,4.03,3.81,4.38,6.53,9.47,11.47,12.72,14.12,15.03,14.69,13.75,13.72,15.03,16.28,17.03,17.81,18.53,18.44,17.09,15.72,15.0,15.0,14.44,13.31,13.06,13.56,14.12,14.25,15.53,17.19,18.66,18.81,18.97,19.53,20.44,20.53,20.25,20.5,20.94,20.59,19.47,18.69,18.72,17.88,15.97,14.84,13.97,13.31,11.84,10.88,10.62,10.53,9.75,9.25,9.62,10.66,11.72,12.59,13.97,15.72,16.69,17.22,17.53,18.56,19.62,19.97,20.34,21.0,21.88,21.41,20.34,19.88,19.38,18.47,17.69,17.59,18.38,19.38,19.44,19.34,19.19,18.88,17.59,16.0,15.72,16.47,16.59,16.47,16.5,16.69,15.91,14.94,14.53,15.94,17.81,19.25,20.88,22.59,23.5,23.0,22.0,21.59,22.03,22.09,22.0,22.59,23.91,24.28,23.88,22.78,22.25,21.09,19.47,18.09,17.66,18.03,17.41,16.91,17.22,18.12,18.56,17.84,17.91,18.81,19.69,19.88,20.44,21.62,22.22,21.16,20.25,20.12,20.38,19.88,19.5,20.0,20.5,20.41,19.97,20.31,22.06,23.41,24.03,24.59,24.56,23.88,21.59,19.38,18.22,18.03,17.47,17.31,18.12,19.5,20.31,20.28,20.41,21.34,22.09,22.31,23.06,24.53,26.09,26.53,26.62,27.47,28.47,28.84,29.41,30.12,31.41,31.62,30.44,29.28,27.84,26.44,24.47,22.91,22.78,23.41,23.78,24.38,25.94,27.97,28.72,29.16,29.56,30.41,30.12,29.31,28.56,28.97,29.78,30.31,31.44,33.78,36.03,36.81,36.69,36.03,35.5,34.09,32.47,31.59,31.78,31.78,31.12,30.62,30.5,30.25,29.44,28.12,27.78,27.88,27.22,26.62,27.06,28.25,28.28,28.03,27.59,27.72,27.69,27.97,28.78,30.53,32.44,32.62,32.66,33.28,33.84,33.88,33.5,33.44,33.75,33.34,32.31,31.47,31.06,30.88,29.72,28.81,29.47,30.22,40.34,39.69,38.47,38.06,38.12,39.25,40.88,43.34,46.56,49.47,52.06,54.16,55.91,56.59,56.84,55.91,54.75,52.75,50.34,47.47,45.19,43.84,43.03,42.44,42.84,43.88,44.91,46.25,47.12,47.91,47.53,46.38,44.47,42.81,40.88,39.62,38.53,37.78,37.62,37.16,36.34,35.91:negativity
12.25,14.19,15.81,16.84,17.81,18.91,19.09,17.81,16.34,16.44,16.5,16.34,15.88,16.41,16.97,16.75,15.62,14.62,14.0,12.97,11.53,10.94,11.97,13.22,14.34,15.69,18.0,20.25,21.25,21.19,22.03,22.62,22.38,21.81,21.91,22.53,22.5,21.75,21.16,21.25,21.44,21.06,20.91,22.0,22.84,22.75,22.41,23.12,23.97,24.41,24.09,23.72,24.12,23.97,23.28,23.31,24.81,26.28,27.47,28.88,31.38,33.5,33.97,33.47,32.56,31.53,29.56,26.84,25.03,24.69,24.53,24.38,25.06,26.97,28.47,28.78,28.59,28.69,28.41,27.16,25.47,24.66,24.5,24.25,23.94,24.78,26.94,28.5,29.22,29.88,30.72,31.06,30.22,28.88,28.53,27.91,27.0,26.09,26.31,26.75,26.84,25.94,24.84,24.19,23.34,21.78,20.09,19.47,18.41,16.94,15.69,16.19,17.34,18.41,19.0,19.66,20.59,21.09,20.78,20.25,20.31,19.97,18.59,17.34,17.44,18.41,18.94,19.31,20.62,20.91,20.19,18.56,17.59,17.59,17.66,17.31,17.62,18.19,18.28,17.72,17.09,17.47,18.28,18.28,18.0,18.69,19.09,18.81,17.47,16.81,17.0,17.31,17.47,18.09,20.0,21.12,20.94,20.34,20.47,20.59,19.78,18.62,18.91,19.62,20.41,20.72,21.47,22.62,23.16,22.75,22.53,23.5,25.0,25.62,26.06,27.31,28.5,28.75,28.75,29.53,30.47,30.72,29.72,28.69,27.69,26.25,24.16,22.59,22.53,22.88,23.06,23.12,24.16,25.16,25.5,25.31,25.91,27.28,28.44,28.81,29.62,30.66,31.28,30.78,30.03,30.06,29.78,28.03,25.41,23.47,22.0,20.88,20.03,20.47,21.72,22.84,22.88,23.09,23.81,24.31,23.94,23.78,25.09,26.47,27.44,28.41,30.03,31.84,32.84,32.94,33.0,33.06,32.12,30.34,29.09,28.66,28.69,28.41,28.5,29.44,29.41,27.97,25.69,23.16,21.34,19.47,17.59,16.56,16.66,16.66,16.22,16.88,18.84,21.62,23.59,26.06,28.91,31.03,31.34,30.34,29.06,27.72,25.72,22.94,20.91,19.75,19.12,17.78,17.59,18.38,19.75,20.06,20.19,21.09,21.81,21.91,21.44,21.97,23.25,24.09,24.19,24.47,25.91,26.88,26.97,28.06,29.53,30.97,31.28,31.62,32.25,32.84,32.47,30.62,29.0,27.5,25.47,23.31,21.59,21.0,20.53,18.94,17.84,17.72,18.5,18.66,19.28,21.09,23.62,25.5,26.78,27.69,27.62,26.44,24.0,21.44,20.38,20.0,19.38,18.94,19.44,20.34,20.16,19.72,20.5,21.75,23.25,24.5,26.47,28.84,30.41,31.72,33.19,35.22,37.19,38.0,37.97,37.59,36.94,35.16,33.19,31.62,30.97,30.66,30.22,30.16,30.78,30.72,29.16,27.25,25.78,24.94,24.06,23.22,23.28,23.81,23.56,23.19,23.66,25.22,26.34,27.19,28.38,30.28,32.25,33.44,34.91,37.16,38.69,38.88,38.16,37.69,37.66,36.34,34.69,33.69,33.06,32.59,31.91,32.72,34.78,36.94,38.19,39.16,40.19,40.94,40.75,39.56,38.62,37.5,35.56,33.25,31.53,31.31,31.12,30.72,30.34,30.69,31.06,30.31,29.09,28.78,27.97,26.06,24.16,22.44,21.84,21.09,20.72,21.22,23.16,24.59,25.06,24.41,24.22,23.88,22.56,22.31,23.66,25.75,27.09,27.84,28.25,28.75,28.25,27.31,26.88,27.09,27.19,26.28,25.59,25.56,26.53,26.03,25.97,25.78,25.69,24.75,23.25,22.12,21.84,20.75,19.69,18.97,19.53,20.38,21.12,22.53,24.56,26.72,27.84,28.94,30.25,31.72,32.5,32.03,31.72,31.44,30.69,28.91,27.31,26.06,24.62,21.91,19.22,17.62,16.59,15.69,15.28,15.88,17.41,18.72,19.47,20.78,22.91,24.34,25.41,26.06,27.22,27.78,26.91,25.59,24.88,24.5,23.81,23.0,23.0,23.25,22.25,20.59,18.44,16.81,15.41,14.44,14.34,15.97,18.19,19.53,19.97,20.72,21.09,20.16,18.84,18.0,18.38,18.59,18.78,19.56,21.5,23.09,24.03,24.97,26.78,28.19,28.28,27.56,26.44,25.44,23.06,21.0,19.66,19.5,19.16,18.38,18.06,18.06,18.0,17.44,17.62,18.94,20.88,22.16,23.28,24.72,26.81,27.81,28.44,28.84,29.72,30.34,30.56,31.72,34.12,35.78,35.97,34.69,33.16,31.56,29.59,27.94,27.47,28.41,28.91,28.97,29.69,30.78,31.44,30.88,30.0,30.22,30.06,29.59,28.97,29.31,29.22,28.66,27.38,27.16,28.03,28.44,28.5,29.03,29.97,30.31,29.38,28.88,29.34,30.09,30.31,30.59,30.69,30.28,28.47,25.88,23.41,21.25,18.44,15.62,13.12,11.69,10.81,10.16,10.03,11.41,13.53,15.75,18.44,22.0,25.88,29.5,32.09,34.19,35.88,36.03,35.16,33.72,33.34,33.41,33.09,32.44,32.38,31.78,30.0,27.72,25.47,24.03,22.78,21.47,21.06,21.78,22.31,22.19,22.12,23.0,24.0,24.22,24.62,25.5,26.34,26.03,24.91,24.41,24.34,24.03,23.53,23.41,23.84,23.91,23.69,23.5,23.78,23.69,22.38,20.47,19.0,18.5,17.97,17.06,17.16,17.53,17.56,17.0,16.41,16.88,17.25,17.56,17.56,18.94,20.34,20.72,20.94,22.53,24.47,26.03,27.44,29.5,32.09,34.25,35.09,35.44,35.81,34.56,32.22,29.5,27.53,26.19,25.19,24.56,25.03,26.22,27.19,27.81,28.81,30.09,31.12,31.34,31.22,31.88,31.72,31.09,30.16,30.31,30.94,31.03,31.25,32.0,32.62,32.44,31.41,30.38,29.28,28.12,26.09,24.38,23.44,22.53,21.16,19.91,19.28,18.84,17.5,15.94,14.75,14.12,13.69,13.59,14.62,16.5,18.66,19.91,21.09,22.38,23.31,23.78,23.56,24.59,25.69,26.34,26.34,26.25,25.72,24.38,22.12,19.84,18.47,17.94,17.03,16.75,17.81,18.56,18.28,16.78,15.5,14.19,12.59,11.0,10.31,10.47,10.19,9.28,8.5,9.06,10.16,11.09,12.56,15.06,17.69,19.25,19.91,21.31,22.38,23.06,22.75,22.41,22.0,20.88,18.78,17.03,16.41,16.34,16.0,16.28,17.75,19.5,21.09,21.66,22.31,22.75,22.19,20.66,18.75,17.88,17.34,16.41,16.25,17.56,19.31,21.0,21.81,23.41,25.38,25.22,23.75,22.31,20.94,19.0,16.94,15.78,15.59,15.66,15.16,15.88,17.91,20.75,23.34,26.38,29.81,33.59,35.69,36.5,37.44,37.38,36.72,34.94,33.66,32.66,31.69,29.81,27.91,26.66,25.41,24.09,22.84,22.78,23.53,23.69,23.5,23.44,23.59,23.53,23.44,23.94,25.31,26.97,27.75,28.0,28.5,28.38,27.34,25.56,24.22,23.5,22.81,21.56,21.0,20.53,19.75,18.25,17.0,16.78,17.28,17.34,16.78,16.94,17.25,16.62,15.47,14.66,14.62,14.16,13.34,12.91,13.19,13.44,12.94,12.38,12.28,12.47,12.19,12.31,13.62,15.44,17.0,18.06,18.91,19.75,19.84,18.88,17.69,16.72,16.31,14.66,13.41,13.03,12.91,12.25,11.53,11.81,12.78,13.41,13.78,14.56,15.69,16.12,15.25,14.16,13.62,12.94,11.34,9.88,9.12,9.0,8.09,7.25,7.41,8.41,9.28,9.81,10.88,12.84,14.31,14.94,15.44,15.97,16.31,15.19,14.12,13.94,14.22,14.22,14.06,15.0,16.72,17.66,17.88,18.47,19.22,19.06,17.78,16.56,15.69,15.0,13.72,13.16,13.12,13.62,13.25,12.66,12.06,11.91,11.22,9.84,9.19,9.44,9.91,9.94,10.34,11.66,13.34,13.97,14.62,15.22,15.97,15.25,14.22,13.97,14.66,14.94,14.22,13.38,12.94,11.91,10.25,8.94,8.72,9.28,9.06,8.69,9.09,10.12,10.44,10.81,11.28,12.44,13.62,13.97,14.91,16.31,17.38,16.81,15.47,14.31,13.34,10.97,8.09,5.75,4.38,2.72,1.44,1.06,2.03,3.16,3.59,4.12,5.56,7.03,7.06,7.0,6.69,6.75,5.59,4.25,3.53,4.16,4.53,4.84,5.78,7.5,8.97,8.97,8.81,9.09,9.41,8.72,7.97,8.62,10.19,11.12,12.91,15.41,18.66,21.0,21.97,22.44,22.88,22.44,20.81,19.06,18.25,17.12,15.31,13.62,13.0,13.12,13.16,12.31,11.12,10.0,8.16,5.44,3.19,2.19,1.84,0.91,-0.03,0.31,1.03,0.84,0.69,1.69,3.59,5.44,7.47,9.94,13.31,15.75,17.25,18.22,19.72,20.78,21.03,21.19,22.16,23.69,23.16,21.66,19.66,17.38,13.59,9.78,6.91,5.94,5.47,5.84,6.97,9.09,11.34,12.16,12.38,13.09,14.16,14.47,14.44,15.09,15.91,16.34,16.0,15.44,15.5,14.97,13.69,12.84,13.19,14.25,14.72,15.44,17.0,19.09,20.47,21.38,22.94,25.09,26.81,27.16,27.94,29.38,30.03,29.31,27.94,26.81,25.28,22.16,19.22,17.34,16.28,15.0,13.44,12.38,12.44,12.28,11.41,10.66,11.28,11.28,10.25,9.12,8.91,8.91,8.19,7.72,8.28,9.88,11.69,13.53,16.06,19.69,22.5,24.0,24.5,25.12,24.72,23.44,21.81,21.03,20.81,19.5,17.75,16.59,16.84,16.66,16.41,16.94:17.81,16.34,16.44,16.5,16.34,15.88,16.41,16.97,16.75,15.62,14.62,14.0,12.97,11.53,10.94,11.97,13.22,14.34,15.69,18.0,20.25,21.25,21.19,22.03,22.62,22.38,21.81,21.91,22.53,22.5,21.75,21.16,21.25,21.44,21.06,20.91,22.0,22.84,22.75,22.41,23.12,23.97,24.41,24.09,23.72,24.12,23.97,23.28,23.31,24.81,26.28,27.47,28.88,31.38,33.5,33.97,33.47,32.56,31.53,29.56,26.84,25.03,24.69,24.53,24.38,25.06,26.97,28.47,28.78,28.59,28.69,28.41,27.16,25.47,24.66,24.5,24.25,23.94,24.78,26.94,28.5,29.22,29.88,30.72,31.06,30.22,28.88,28.53,27.91,27.0,26.09,26.31,26.75,26.84,25.94,24.84,24.19,23.34,21.78,20.09,19.47,18.41,16.94,15.69,16.19,17.34,18.41,19.0,19.66,20.59,21.09,20.78,20.25,20.31,19.97,18.59,17.34,17.44,18.41,18.94,19.31,20.62,20.91,20.19,18.56,17.59,17.59,17.66,17.31,17.62,18.19,18.28,17.72,17.09,17.47,18.28,18.28,18.0,18.69,19.09,18.81,17.47,16.81,17.0,17.31,17.47,18.09,20.0,21.12,20.94,20.34,20.47,20.59,19.78,18.62,18.91,19.62,20.41,20.72,21.47,22.62,23.16,22.75,22.53,23.5,25.0,25.62,26.06,27.31,28.5,28.75,28.75,29.53,30.47,30.72,29.72,28.69,27.69,26.25,24.16,22.59,22.53,22.88,23.06,23.12,24.16,25.16,25.5,25.31,25.91,27.28,28.44,28.81,29.62,30.66,31.28,30.78,30.03,30.06,29.78,28.03,25.41,23.47,22.0,20.88,20.03,20.47,21.72,22.84,22.88,23.09,23.81,24.31,23.94,23.78,25.09,26.47,27.44,28.41,30.03,31.84,32.84,32.94,33.0,33.06,32.12,30.34,29.09,28.66,28.69,28.41,28.5,29.44,29.41,27.97,25.69,23.16,21.34,19.47,17.59,16.56,16.66,16.66,16.22,16.88,18.84,21.62,23.59,26.06,28.91,31.03,31.34,30.34,29.06,27.72,25.72,22.94,20.91,19.75,19.12,17.78,17.59,18.38,19.75,20.06,20.19,21.09,21.81,21.91,21.44,21.97,23.25,24.09,24.19,24.47,25.91,26.88,26.97,28.06,29.53,30.97,31.28,31.62,32.25,32.84,32.47,30.62,29.0,27.5,25.47,23.31,21.59,21.0,20.53,18.94,17.84,17.72,18.5,18.66,19.28,21.09,23.62,25.5,26.78,27.69,27.62,26.44,24.0,21.44,20.38,20.0,19.38,18.94,19.44,20.34,20.16,19.72,20.5,21.75,23.25,24.5,26.47,28.84,30.41,31.72,33.19,35.22,37.19,38.0,37.97,37.59,36.94,35.16,33.19,31.62,30.97,30.66,30.22,30.16,30.78,30.72,29.16,27.25,25.78,24.94,24.06,23.22,23.28,23.81,23.56,23.19,23.66,25.22,26.34,27.19,28.38,30.28,32.25,33.44,34.91,37.16,38.69,38.88,38.16,37.69,37.66,36.34,34.69,33.69,33.06,32.59,31.91,32.72,34.78,36.94,38.19,39.16,40.19,40.94,40.75,39.56,38.62,37.5,35.56,33.25,31.53,31.31,31.12,30.72,30.34,30.69,31.06,30.31,29.09,28.78,27.97,26.06,24.16,22.44,21.84,21.09,20.72,21.22,23.16,24.59,25.06,24.41,24.22,23.88,22.56,22.31,23.66,25.75,27.09,27.84,28.25,28.75,28.25,27.31,26.88,27.09,27.19,26.28,25.59,25.56,26.53,26.03,25.97,25.78,25.69,24.75,23.25,22.12,21.84,20.75,19.69,18.97,19.53,20.38,21.12,22.53,24.56,26.72,27.84,28.94,30.25,31.72,32.5,32.03,31.72,31.44,30.69,28.91,27.31,26.06,24.62,21.91,19.22,17.62,16.59,15.69,15.28,15.88,17.41,18.72,19.47,20.78,22.91,24.34,25.41,26.06,27.22,27.78,26.91,25.59,24.88,24.5,23.81,23.0,23.0,23.25,22.25,20.59,18.44,16.81,15.41,14.44,14.34,15.97,18.19,19.53,19.97,20.72,21.09,20.16,18.84,18.0,18.38,18.59,18.78,19.56,21.5,23.09,24.03,24.97,26.78,28.19,28.28,27.56,26.44,25.44,23.06,21.0,19.66,19.5,19.16,18.38,18.06,18.06,18.0,17.44,17.62,18.94,20.88,22.16,23.28,24.72,26.81,27.81,28.44,28.84,29.72,30.34,30.56,31.72,34.12,35.78,35.97,34.69,33.16,31.56,29.59,27.94,27.47,28.41,28.91,28.97,29.69,30.78,31.44,30.88,30.0,30.22,30.06,29.59,28.97,29.31,29.22,28.66,27.38,27.16,28.03,28.44,28.5,29.03,29.97,30.31,29.38,28.88,29.34,30.09,30.31,30.59,30.69,30.28,28.47,25.88,23.41,21.25,18.44,15.62,13.12,11.69,10.81,10.16,10.03,11.41,13.53,15.75,18.44,22.0,25.88,29.5,32.09,34.19,35.88,36.03,35.16,33.72,33.34,33.41,33.09,32.44,32.38,31.78,30.0,27.72,25.47,24.03,22.78,21.47,21.06,21.78,22.31,22.19,22.12,23.0,24.0,24.22,24.62,25.5,26.34,26.03,24.91,24.41,24.34,24.03,23.53,23.41,23.84,23.91,23.69,23.5,23.78,23.69,22.38,20.47,19.0,18.5,17.97,17.06,17.16,17.53,17.56,17.0,16.41,16.88,17.25,17.56,17.56,18.94,20.34,20.72,20.94,22.53,24.47,26.03,27.44,29.5,32.09,34.25,35.09,35.44,35.81,34.56,32.22,29.5,27.53,26.19,25.19,24.56,25.03,26.22,27.19,27.81,28.81,30.09,31.12,31.34,31.22,31.88,31.72,31.09,30.16,30.31,30.94,31.03,31.25,32.0,32.62,32.44,31.41,30.38,29.28,28.12,26.09,24.38,23.44,22.53,21.16,19.91,19.28,18.84,17.5,15.94,14.75,14.12,13.69,13.59,14.62,16.5,18.66,19.91,21.09,22.38,23.31,23.78,23.56,24.59,25.69,26.34,26.34,26.25,25.72,24.38,22.12,19.84,18.47,17.94,17.03,16.75,17.81,18.56,18.28,16.78,15.5,14.19,12.59,11.0,10.31,10.47,10.19,9.28,8.5,9.06,10.16,11.09,12.56,15.06,17.69,19.25,19.91,21.31,22.38,23.06,22.75,22.41,22.0,20.88,18.78,17.03,16.41,16.34,16.0,16.28,17.75,19.5,21.09,21.66,22.31,22.75,22.19,20.66,18.75,17.88,17.34,16.41,16.25,17.56,19.31,21.0,21.81,23.41,25.38,25.22,23.75,22.31,20.94,19.0,16.94,15.78,15.59,15.66,15.16,15.88,17.91,20.75,23.34,26.38,29.81,33.59,35.69,36.5,37.44,37.38,36.72,34.94,33.66,32.66,31.69,29.81,27.91,26.66,25.41,24.09,22.84,22.78,23.53,23.69,23.5,23.44,23.59,23.53,23.44,23.94,25.31,26.97,27.75,28.0,28.5,28.38,27.34,25.56,24.22,23.5,22.81,21.56,21.0,20.53,19.75,18.25,17.0,16.78,17.28,17.34,16.78,16.94,17.25,16.62,15.47,14.66,14.62,14.16,13.34,12.91,13.19,13.44,12.94,12.38,12.28,12.47,12.19,12.31,13.62,15.44,17.0,18.06,18.91,19.75,19.84,18.88,17.69,16.72,16.31,14.66,13.41,13.03,12.91,12.25,11.53,11.81,12.78,13.41,13.78,14.56,15.69,16.12,15.25,14.16,13.62,12.94,11.34,9.88,9.12,9.0,8.09,7.25,7.41,8.41,9.28,9.81,10.88,12.84,14.31,14.94,15.44,15.97,16.31,15.19,14.12,13.94,14.22,14.22,14.06,15.0,16.72,17.66,17.88,18.47,19.22,19.06,17.78,16.56,15.69,15.0,13.72,13.16,13.12,13.62,13.25,12.66,12.06,11.91,11.22,9.84,9.19,9.44,9.91,9.94,10.34,11.66,13.34,13.97,14.62,15.22,15.97,15.25,14.22,13.97,14.66,14.94,14.22,13.38,12.94,11.91,10.25,8.94,8.72,9.28,9.06,8.69,9.09,10.12,10.44,10.81,11.28,12.44,13.62,13.97,14.91,16.31,17.38,16.81,15.47,14.31,13.34,10.97,8.09,5.75,4.38,2.72,1.44,1.06,2.03,3.16,3.59,4.12,5.56,7.03,7.06,7.0,6.69,6.75,5.59,4.25,3.53,4.16,4.53,4.84,5.78,7.5,8.97,8.97,8.81,9.09,9.41,8.72,7.97,8.62,10.19,11.12,12.91,15.41,18.66,21.0,21.97,22.44,22.88,22.44,20.81,19.06,18.25,17.12,15.31,13.62,13.0,13.12,13.16,12.31,11.12,10.0,8.16,5.44,3.19,2.19,1.84,0.91,-0.03,0.31,1.03,0.84,0.69,1.69,3.59,5.44,7.47,9.94,13.31,15.75,17.25,18.22,19.72,20.78,21.03,21.19,22.16,23.69,23.16,21.66,19.66,17.38,13.59,9.78,6.91,5.94,5.47,5.84,6.97,9.09,11.34,12.16,12.38,13.09,14.16,14.47,14.44,15.09,15.91,16.34,16.0,15.44,15.5,14.97,13.69,12.84,13.19,14.25,14.72,15.44,17.0,19.09,20.47,21.38,22.94,25.09,26.81,27.16,27.94,29.38,30.03,29.31,27.94,26.81,25.28,22.16,19.22,17.34,16.28,15.0,13.44,12.38,12.44,12.28,11.41,10.66,11.28,11.28,10.25,9.12,8.91,8.91,8.19,7.72,8.28,9.88,11.69,13.53,16.06,19.69,22.5,24.0,24.5,25.12,24.72,23.44,21.81,21.03,20.81,19.5,17.75,16.59,16.84,16.66,16.41,16.94,12.75,14.22,16.16,17.97,19.38,20.72,21.09:16.97,16.75,15.62,14.62,14.0,12.97,11.53,10.94,11.97,13.22,14.34,15.69,18.0,20.25,21.25,21.19,22.03,22.62,22.38,21.81,21.91,22.53,22.5,21.75,21.16,21.25,21.44,21.06,20.91,22.0,22.84,22.75,22.41,23.12,23.97,24.41,24.09,23.72,24.12,23.97,23.28,23.31,24.81,26.28,27.47,28.88,31.38,33.5,33.97,33.47,32.56,31.53,29.56,26.84,25.03,24.69,24.53,24.38,25.06,26.97,28.47,28.78,28.59,28.69,28.41,27.16,25.47,24.66,24.5,24.25,23.94,24.78,26.94,28.5,29.22,29.88,30.72,31.06,30.22,28.88,28.53,27.91,27.0,26.09,26.31,26.75,26.84,25.94,24.84,24.19,23.34,21.78,20.09,19.47,18.41,16.94,15.69,16.19,17.34,18.41,19.0,19.66,20.59,21.09,20.78,20.25,20.31,19.97,18.59,17.34,17.44,18.41,18.94,19.31,20.62,20.91,20.19,18.56,17.59,17.59,17.66,17.31,17.62,18.19,18.28,17.72,17.09,17.47,18.28,18.28,18.0,18.69,19.09,18.81,17.47,16.81,17.0,17.31,17.47,18.09,20.0,21.12,20.94,20.34,20.47,20.59,19.78,18.62,18.91,19.62,20.41,20.72,21.47,22.62,23.16,22.75,22.53,23.5,25.0,25.62,26.06,27.31,28.5,28.75,28.75,29.53,30.47,30.72,29.72,28.69,27.69,26.25,24.16,22.59,22.53,22.88,23.06,23.12,24.16,25.16,25.5,25.31,25.91,27.28,28.44,28.81,29.62,30.66,31.28,30.78,30.03,30.06,29.78,28.03,25.41,23.47,22.0,20.88,20.03,20.47,21.72,22.84,22.88,23.09,23.81,24.31,23.94,23.78,25.09,26.47,27.44,28.41,30.03,31.84,32.84,32.94,33.0,33.06,32.12,30.34,29.09,28.66,28.69,28.41,28.5,29.44,29.41,27.97,25.69,23.16,21.34,19.47,17.59,16.56,16.66,16.66,16.22,16.88,18.84,21.62,23.59,26.06,28.91,31.03,31.34,30.34,29.06,27.72,25.72,22.94,20.91,19.75,19.12,17.78,17.59,18.38,19.75,20.06,20.19,21.09,21.81,21.91,21.44,21.97,23.25,24.09,24.19,24.47,25.91,26.88,26.97,28.06,29.53,30.97,31.28,31.62,32.25,32.84,32.47,30.62,29.0,27.5,25.47,23.31,21.59,21.0,20.53,18.94,17.84,17.72,18.5,18.66,19.28,21.09,23.62,25.5,26.78,27.69,27.62,26.44,24.0,21.44,20.38,20.0,19.38,18.94,19.44,20.34,20.16,19.72,20.5,21.75,23.25,24.5,26.47,28.84,30.41,31.72,33.19,35.22,37.19,38.0,37.97,37.59,36.94,35.16,33.19,31.62,30.97,30.66,30.22,30.16,30.78,30.72,29.16,27.25,25.78,24.94,24.06,23.22,23.28,23.81,23.56,23.19,23.66,25.22,26.34,27.19,28.38,30.28,32.25,33.44,34.91,37.16,38.69,38.88,38.16,37.69,37.66,36.34,34.69,33.69,33.06,32.59,31.91,32.72,34.78,36.94,38.19,39.16,40.19,40.94,40.75,39.56,38.62,37.5,35.56,33.25,31.53,31.31,31.12,30.72,30.34,30.69,31.06,30.31,29.09,28.78,27.97,26.06,24.16,22.44,21.84,21.09,20.72,21.22,23.16,24.59,25.06,24.41,24.22,23.88,22.56,22.31,23.66,25.75,27.09,27.84,28.25,28.75,28.25,27.31,26.88,27.09,27.19,26.28,25.59,25.56,26.53,26.03,25.97,25.78,25.69,24.75,23.25,22.12,21.84,20.75,19.69,18.97,19.53,20.38,21.12,22.53,24.56,26.72,27.84,28.94,30.25,31.72,32.5,32.03,31.72,31.44,30.69,28.91,27.31,26.06,24.62,21.91,19.22,17.62,16.59,15.69,15.28,15.88,17.41,18.72,19.47,20.78,22.91,24.34,25.41,26.06,27.22,27.78,26.91,25.59,24.88,24.5,23.81,23.0,23.0,23.25,22.25,20.59,18.44,16.81,15.41,14.44,14.34,15.97,18.19,19.53,19.97,20.72,21.09,20.16,18.84,18.0,18.38,18.59,18.78,19.56,21.5,23.09,24.03,24.97,26.78,28.19,28.28,27.56,26.44,25.44,23.06,21.0,19.66,19.5,19.16,18.38,18.06,18.06,18.0,17.44,17.62,18.94,20.88,22.16,23.28,24.72,26.81,27.81,28.44,28.84,29.72,30.34,30.56,31.72,34.12,35.78,35.97,34.69,33.16,31.56,29.59,27.94,27.47,28.41,28.91,28.97,29.69,30.78,31.44,30.88,30.0,30.22,30.06,29.59,28.97,29.31,29.22,28.66,27.38,27.16,28.03,28.44,28.5,29.03,29.97,30.31,29.38,28.88,29.34,30.09,30.31,30.59,30.69,30.28,28.47,25.88,23.41,21.25,18.44,15.62,13.12,11.69,10.81,10.16,10.03,11.41,13.53,15.75,18.44,22.0,25.88,29.5,32.09,34.19,35.88,36.03,35.16,33.72,33.34,33.41,33.09,32.44,32.38,31.78,30.0,27.72,25.47,24.03,22.78,21.47,21.06,21.78,22.31,22.19,22.12,23.0,24.0,24.22,24.62,25.5,26.34,26.03,24.91,24.41,24.34,24.03,23.53,23.41,23.84,23.91,23.69,23.5,23.78,23.69,22.38,20.47,19.0,18.5,17.97,17.06,17.16,17.53,17.56,17.0,16.41,16.88,17.25,17.56,17.56,18.94,20.34,20.72,20.94,22.53,24.47,26.03,27.44,29.5,32.09,34.25,35.09,35.44,35.81,34.56,32.22,29.5,27.53,26.19,25.19,24.56,25.03,26.22,27.19,27.81,28.81,30.09,31.12,31.34,31.22,31.88,31.72,31.09,30.16,30.31,30.94,31.03,31.25,32.0,32.62,32.44,31.41,30.38,29.28,28.12,26.09,24.38,23.44,22.53,21.16,19.91,19.28,18.84,17.5,15.94,14.75,14.12,13.69,13.59,14.62,16.5,18.66,19.91,21.09,22.38,23.31,23.78,23.56,24.59,25.69,26.34,26.34,26.25,25.72,24.38,22.12,19.84,18.47,17.94,17.03,16.75,17.81,18.56,18.28,16.78,15.5,14.19,12.59,11.0,10.31,10.47,10.19,9.28,8.5,9.06,10.16,11.09,12.56,15.06,17.69,19.25,19.91,21.31,22.38,23.06,22.75,22.41,22.0,20.88,18.78,17.03,16.41,16.34,16.0,16.28,17.75,19.5,21.09,21.66,22.31,22.75,22.19,20.66,18.75,17.88,17.34,16.41,16.25,17.56,19.31,21.0,21.81,23.41,25.38,25.22,23.75,22.31,20.94,19.0,16.94,15.78,15.59,15.66,15.16,15.88,17.91,20.75,23.34,26.38,29.81,33.59,35.69,36.5,37.44,37.38,36.72,34.94,33.66,32.66,31.69,29.81,27.91,26.66,25.41,24.09,22.84,22.78,23.53,23.69,23.5,23.44,23.59,23.53,23.44,23.94,25.31,26.97,27.75,28.0,28.5,28.38,27.34,25.56,24.22,23.5,22.81,21.56,21.0,20.53,19.75,18.25,17.0,16.78,17.28,17.34,16.78,16.94,17.25,16.62,15.47,14.66,14.62,14.16,13.34,12.91,13.19,13.44,12.94,12.38,12.28,12.47,12.19,12.31,13.62,15.44,17.0,18.06,18.91,19.75,19.84,18.88,17.69,16.72,16.31,14.66,13.41,13.03,12.91,12.25,11.53,11.81,12.78,13.41,13.78,14.56,15.69,16.12,15.25,14.16,13.62,12.94,11.34,9.88,9.12,9.0,8.09,7.25,7.41,8.41,9.28,9.81,10.88,12.84,14.31,14.94,15.44,15.97,16.31,15.19,14.12,13.94,14.22,14.22,14.06,15.0,16.72,17.66,17.88,18.47,19.22,19.06,17.78,16.56,15.69,15.0,13.72,13.16,13.12,13.62,13.25,12.66,12.06,11.91,11.22,9.84,9.19,9.44,9.91,9.94,10.34,11.66,13.34,13.97,14.62,15.22,15.97,15.25,14.22,13.97,14.66,14.94,14.22,13.38,12.94,11.91,10.25,8.94,8.72,9.28,9.06,8.69,9.09,10.12,10.44,10.81,11.28,12.44,13.62,13.97,14.91,16.31,17.38,16.81,15.47,14.31,13.34,10.97,8.09,5.75,4.38,2.72,1.44,1.06,2.03,3.16,3.59,4.12,5.56,7.03,7.06,7.0,6.69,6.75,5.59,4.25,3.53,4.16,4.53,4.84,5.78,7.5,8.97,8.97,8.81,9.09,9.41,8.72,7.97,8.62,10.19,11.12,12.91,15.41,18.66,21.0,21.97,22.44,22.88,22.44,20.81,19.06,18.25,17.12,15.31,13.62,13.0,13.12,13.16,12.31,11.12,10.0,8.16,5.44,3.19,2.19,1.84,0.91,-0.03,0.31,1.03,0.84,0.69,1.69,3.59,5.44,7.47,9.94,13.31,15.75,17.25,18.22,19.72,20.78,21.03,21.19,22.16,23.69,23.16,21.66,19.66,17.38,13.59,9.78,6.91,5.94,5.47,5.84,6.97,9.09,11.34,12.16,12.38,13.09,14.16,14.47,14.44,15.09,15.91,16.34,16.0,15.44,15.5,14.97,13.69,12.84,13.19,14.25,14.72,15.44,17.0,19.09,20.47,21.38,22.94,25.09,26.81,27.16,27.94,29.38,30.03,29.31,27.94,26.81,25.28,22.16,19.22,17.34,16.28,15.0,13.44,12.38,12.44,12.28,11.41,10.66,11.28,11.28,10.25,9.12,8.91,8.91,8.19,7.72,8.28,9.88,11.69,13.53,16.06,19.69,22.5,24.0,24.5,25.12,24.72,23.44,21.81,21.03,20.81,19.5,17.75,16.59,16.84,16.66,16.41,16.94,12.75,14.22,16.16,17.97,19.38,20.72,21.09,21.22,21.19,21.25,21.97,22.47,23.0,22.88:10.94,11.97,13.22,14.34,15.69,18.0,20.25,21.25,21.19,22.03,22.62,22.38,21.81,21.91,22.53,22.5,21.75,21.16,21.25,21.44,21.06,20.91,22.0,22.84,22.75,22.41,23.12,23.97,24.41,24.09,23.72,24.12,23.97,23.28,23.31,24.81,26.28,27.47,28.88,31.38,33.5,33.97,33.47,32.56,31.53,29.56,26.84,25.03,24.69,24.53,24.38,25.06,26.97,28.47,28.78,28.59,28.69,28.41,27.16,25.47,24.66,24.5,24.25,23.94,24.78,26.94,28.5,29.22,29.88,30.72,31.06,30.22,28.88,28.53,27.91,27.0,26.09,26.31,26.75,26.84,25.94,24.84,24.19,23.34,21.78,20.09,19.47,18.41,16.94,15.69,16.19,17.34,18.41,19.0,19.66,20.59,21.09,20.78,20.25,20.31,19.97,18.59,17.34,17.44,18.41,18.94,19.31,20.62,20.91,20.19,18.56,17.59,17.59,17.66,17.31,17.62,18.19,18.28,17.72,17.09,17.47,18.28,18.28,18.0,18.69,19.09,18.81,17.47,16.81,17.0,17.31,17.47,18.09,20.0,21.12,20.94,20.34,20.47,20.59,19.78,18.62,18.91,19.62,20.41,20.72,21.47,22.62,23.16,22.75,22.53,23.5,25.0,25.62,26.06,27.31,28.5,28.75,28.75,29.53,30.47,30.72,29.72,28.69,27.69,26.25,24.16,22.59,22.53,22.88,23.06,23.12,24.16,25.16,25.5,25.31,25.91,27.28,28.44,28.81,29.62,30.66,31.28,30.78,30.03,30.06,29.78,28.03,25.41,23.47,22.0,20.88,20.03,20.47,21.72,22.84,22.88,23.09,23.81,24.31,23.94,23.78,25.09,26.47,27.44,28.41,30.03,31.84,32.84,32.94,33.0,33.06,32.12,30.34,29.09,28.66,28.69,28.41,28.5,29.44,29.41,27.97,25.69,23.16,21.34,19.47,17.59,16.56,16.66,16.66,16.22,16.88,18.84,21.62,23.59,26.06,28.91,31.03,31.34,30.34,29.06,27.72,25.72,22.94,20.91,19.75,19.12,17.78,17.59,18.38,19.75,20.06,20.19,21.09,21.81,21.91,21.44,21.97,23.25,24.09,24.19,24.47,25.91,26.88,26.97,28.06,29.53,30.97,31.28,31.62,32.25,32.84,32.47,30.62,29.0,27.5,25.47,23.31,21.59,21.0,20.53,18.94,17.84,17.72,18.5,18.66,19.28,21.09,23.62,25.5,26.78,27.69,27.62,26.44,24.0,21.44,20.38,20.0,19.38,18.94,19.44,20.34,20.16,19.72,20.5,21.75,23.25,24.5,26.47,28.84,30.41,31.72,33.19,35.22,37.19,38.0,37.97,37.59,36.94,35.16,33.19,31.62,30.97,30.66,30.22,30.16,30.78,30.72,29.16,27.25,25.78,24.94,24.06,23.22,23.28,23.81,23.56,23.19,23.66,25.22,26.34,27.19,28.38,30.28,32.25,33.44,34.91,37.16,38.69,38.88,38.16,37.69,37.66,36.34,34.69,33.69,33.06,32.59,31.91,32.72,34.78,36.94,38.19,39.16,40.19,40.94,40.75,39.56,38.62,37.5,35.56,33.25,31.53,31.31,31.12,30.72,30.34,30.69,31.06,30.31,29.09,28.78,27.97,26.06,24.16,22.44,21.84,21.09,20.72,21.22,23.16,24.59,25.06,24.41,24.22,23.88,22.56,22.31,23.66,25.75,27.09,27.84,28.25,28.75,28.25,27.31,26.88,27.09,27.19,26.28,25.59,25.56,26.53,26.03,25.97,25.78,25.69,24.75,23.25,22.12,21.84,20.75,19.69,18.97,19.53,20.38,21.12,22.53,24.56,26.72,27.84,28.94,30.25,31.72,32.5,32.03,31.72,31.44,30.69,28.91,27.31,26.06,24.62,21.91,19.22,17.62,16.59,15.69,15.28,15.88,17.41,18.72,19.47,20.78,22.91,24.34,25.41,26.06,27.22,27.78,26.91,25.59,24.88,24.5,23.81,23.0,23.0,23.25,22.25,20.59,18.44,16.81,15.41,14.44,14.34,15.97,18.19,19.53,19.97,20.72,21.09,20.16,18.84,18.0,18.38,18.59,18.78,19.56,21.5,23.09,24.03,24.97,26.78,28.19,28.28,27.56,26.44,25.44,23.06,21.0,19.66,19.5,19.16,18.38,18.06,18.06,18.0,17.44,17.62,18.94,20.88,22.16,23.28,24.72,26.81,27.81,28.44,28.84,29.72,30.34,30.56,31.72,34.12,35.78,35.97,34.69,33.16,31.56,29.59,27.94,27.47,28.41,28.91,28.97,29.69,30.78,31.44,30.88,30.0,30.22,30.06,29.59,28.97,29.31,29.22,28.66,27.38,27.16,28.03,28.44,28.5,29.03,29.97,30.31,29.38,28.88,29.34,30.09,30.31,30.59,30.69,30.28,28.47,25.88,23.41,21.25,18.44,15.62,13.12,11.69,10.81,10.16,10.03,11.41,13.53,15.75,18.44,22.0,25.88,29.5,32.09,34.19,35.88,36.03,35.16,33.72,33.34,33.41,33.09,32.44,32.38,31.78,30.0,27.72,25.47,24.03,22.78,21.47,21.06,21.78,22.31,22.19,22.12,23.0,24.0,24.22,24.62,25.5,26.34,26.03,24.91,24.41,24.34,24.03,23.53,23.41,23.84,23.91,23.69,23.5,23.78,23.69,22.38,20.47,19.0,18.5,17.97,17.06,17.16,17.53,17.56,17.0,16.41,16.88,17.25,17.56,17.56,18.94,20.34,20.72,20.94,22.53,24.47,26.03,27.44,29.5,32.09,34.25,35.09,35.44,35.81,34.56,32.22,29.5,27.53,26.19,25.19,24.56,25.03,26.22,27.19,27.81,28.81,30.09,31.12,31.34,31.22,31.88,31.72,31.09,30.16,30.31,30.94,31.03,31.25,32.0,32.62,32.44,31.41,30.38,29.28,28.12,26.09,24.38,23.44,22.53,21.16,19.91,19.28,18.84,17.5,15.94,14.75,14.12,13.69,13.59,14.62,16.5,18.66,19.91,21.09,22.38,23.31,23.78,23.56,24.59,25.69,26.34,26.34,26.25,25.72,24.38,22.12,19.84,18.47,17.94,17.03,16.75,17.81,18.56,18.28,16.78,15.5,14.19,12.59,11.0,10.31,10.47,10.19,9.28,8.5,9.06,10.16,11.09,12.56,15.06,17.69,19.25,19.91,21.31,22.38,23.06,22.75,22.41,22.0,20.88,18.78,17.03,16.41,16.34,16.0,16.28,17.75,19.5,21.09,21.66,22.31,22.75,22.19,20.66,18.75,17.88,17.34,16.41,16.25,17.56,19.31,21.0,21.81,23.41,25.38,25.22,23.75,22.31,20.94,19.0,16.94,15.78,15.59,15.66,15.16,15.88,17.91,20.75,23.34,26.38,29.81,33.59,35.69,36.5,37.44,37.38,36.72,34.94,33.66,32.66,31.69,29.81,27.91,26.66,25.41,24.09,22.84,22.78,23.53,23.69,23.5,23.44,23.59,23.53,23.44,23.94,25.31,26.97,27.75,28.0,28.5,28.38,27.34,25.56,24.22,23.5,22.81,21.56,21.0,20.53,19.75,18.25,17.0,16.78,17.28,17.34,16.78,16.94,17.25,16.62,15.47,14.66,14.62,14.16,13.34,12.91,13.19,13.44,12.94,12.38,12.28,12.47,12.19,12.31,13.62,15.44,17.0,18.06,18.91,19.75,19.84,18.88,17.69,16.72,16.31,14.66,13.41,13.03,12.91,12.25,11.53,11.81,12.78,13.41,13.78,14.56,15.69,16.12,15.25,14.16,13.62,12.94,11.34,9.88,9.12,9.0,8.09,7.25,7.41,8.41,9.28,9.81,10.88,12.84,14.31,14.94,15.44,15.97,16.31,15.19,14.12,13.94,14.22,14.22,14.06,15.0,16.72,17.66,17.88,18.47,19.22,19.06,17.78,16.56,15.69,15.0,13.72,13.16,13.12,13.62,13.25,12.66,12.06,11.91,11.22,9.84,9.19,9.44,9.91,9.94,10.34,11.66,13.34,13.97,14.62,15.22,15.97,15.25,14.22,13.97,14.66,14.94,14.22,13.38,12.94,11.91,10.25,8.94,8.72,9.28,9.06,8.69,9.09,10.12,10.44,10.81,11.28,12.44,13.62,13.97,14.91,16.31,17.38,16.81,15.47,14.31,13.34,10.97,8.09,5.75,4.38,2.72,1.44,1.06,2.03,3.16,3.59,4.12,5.56,7.03,7.06,7.0,6.69,6.75,5.59,4.25,3.53,4.16,4.53,4.84,5.78,7.5,8.97,8.97,8.81,9.09,9.41,8.72,7.97,8.62,10.19,11.12,12.91,15.41,18.66,21.0,21.97,22.44,22.88,22.44,20.81,19.06,18.25,17.12,15.31,13.62,13.0,13.12,13.16,12.31,11.12,10.0,8.16,5.44,3.19,2.19,1.84,0.91,-0.03,0.31,1.03,0.84,0.69,1.69,3.59,5.44,7.47,9.94,13.31,15.75,17.25,18.22,19.72,20.78,21.03,21.19,22.16,23.69,23.16,21.66,19.66,17.38,13.59,9.78,6.91,5.94,5.47,5.84,6.97,9.09,11.34,12.16,12.38,13.09,14.16,14.47,14.44,15.09,15.91,16.34,16.0,15.44,15.5,14.97,13.69,12.84,13.19,14.25,14.72,15.44,17.0,19.09,20.47,21.38,22.94,25.09,26.81,27.16,27.94,29.38,30.03,29.31,27.94,26.81,25.28,22.16,19.22,17.34,16.28,15.0,13.44,12.38,12.44,12.28,11.41,10.66,11.28,11.28,10.25,9.12,8.91,8.91,8.19,7.72,8.28,9.88,11.69,13.53,16.06,19.69,22.5,24.0,24.5,25.12,24.72,23.44,21.81,21.03,20.81,19.5,17.75,16.59,16.84,16.66,16.41,16.94,12.75,14.22,16.16,17.97,19.38,20.72,21.09,21.22,21.19,21.25,21.97,22.47,23.0,22.88,22.84,22.81,22.31,21.09,20.19,19.22,18.41:21.25,21.19,22.03,22.62,22.38,21.81,21.91,22.53,22.5,21.75,21.16,21.25,21.44,21.06,20.91,22.0,22.84,22.75,22.41,23.12,23.97,24.41,24.09,23.72,24.12,23.97,23.28,23.31,24.81,26.28,27.47,28.88,31.38,33.5,33.97,33.47,32.56,31.53,29.56,26.84,25.03,24.69,24.53,24.38,25.06,26.97,28.47,28.78,28.59,28.69,28.41,27.16,25.47,24.66,24.5,24.25,23.94,24.78,26.94,28.5,29.22,29.88,30.72,31.06,30.22,28.88,28.53,27.91,27.0,26.09,26.31,26.75,26.84,25.94,24.84,24.19,23.34,21.78,20.09,19.47,18.41,16.94,15.69,16.19,17.34,18.41,19.0,19.66,20.59,21.09,20.78,20.25,20.31,19.97,18.59,17.34,17.44,18.41,18.94,19.31,20.62,20.91,20.19,18.56,17.59,17.59,17.66,17.31,17.62,18.19,18.28,17.72,17.09,17.47,18.28,18.28,18.0,18.69,19.09,18.81,17.47,16.81,17.0,17.31,17.47,18.09,20.0,21.12,20.94,20.34,20.47,20.59,19.78,18.62,18.91,19.62,20.41,20.72,21.47,22.62,23.16,22.75,22.53,23.5,25.0,25.62,26.06,27.31,28.5,28.75,28.75,29.53,30.47,30.72,29.72,28.69,27.69,26.25,24.16,22.59,22.53,22.88,23.06,23.12,24.16,25.16,25.5,25.31,25.91,27.28,28.44,28.81,29.62,30.66,31.28,30.78,30.03,30.06,29.78,28.03,25.41,23.47,22.0,20.88,20.03,20.47,21.72,22.84,22.88,23.09,23.81,24.31,23.94,23.78,25.09,26.47,27.44,28.41,30.03,31.84,32.84,32.94,33.0,33.06,32.12,30.34,29.09,28.66,28.69,28.41,28.5,29.44,29.41,27.97,25.69,23.16,21.34,19.47,17.59,16.56,16.66,16.66,16.22,16.88,18.84,21.62,23.59,26.06,28.91,31.03,31.34,30.34,29.06,27.72,25.72,22.94,20.91,19.75,19.12,17.78,17.59,18.38,19.75,20.06,20.19,21.09,21.81,21.91,21.44,21.97,23.25,24.09,24.19,24.47,25.91,26.88,26.97,28.06,29.53,30.97,31.28,31.62,32.25,32.84,32.47,30.62,29.0,27.5,25.47,23.31,21.59,21.0,20.53,18.94,17.84,17.72,18.5,18.66,19.28,21.09,23.62,25.5,26.78,27.69,27.62,26.44,24.0,21.44,20.38,20.0,19.38,18.94,19.44,20.34,20.16,19.72,20.5,21.75,23.25,24.5,26.47,28.84,30.41,31.72,33.19,35.22,37.19,38.0,37.97,37.59,36.94,35.16,33.19,31.62,30.97,30.66,30.22,30.16,30.78,30.72,29.16,27.25,25.78,24.94,24.06,23.22,23.28,23.81,23.56,23.19,23.66,25.22,26.34,27.19,28.38,30.28,32.25,33.44,34.91,37.16,38.69,38.88,38.16,37.69,37.66,36.34,34.69,33.69,33.06,32.59,31.91,32.72,34.78,36.94,38.19,39.16,40.19,40.94,40.75,39.56,38.62,37.5,35.56,33.25,31.53,31.31,31.12,30.72,30.34,30.69,31.06,30.31,29.09,28.78,27.97,26.06,24.16,22.44,21.84,21.09,20.72,21.22,23.16,24.59,25.06,24.41,24.22,23.88,22.56,22.31,23.66,25.75,27.09,27.84,28.25,28.75,28.25,27.31,26.88,27.09,27.19,26.28,25.59,25.56,26.53,26.03,25.97,25.78,25.69,24.75,23.25,22.12,21.84,20.75,19.69,18.97,19.53,20.38,21.12,22.53,24.56,26.72,27.84,28.94,30.25,31.72,32.5,32.03,31.72,31.44,30.69,28.91,27.31,26.06,24.62,21.91,19.22,17.62,16.59,15.69,15.28,15.88,17.41,18.72,19.47,20.78,22.91,24.34,25.41,26.06,27.22,27.78,26.91,25.59,24.88,24.5,23.81,23.0,23.0,23.25,22.25,20.59,18.44,16.81,15.41,14.44,14.34,15.97,18.19,19.53,19.97,20.72,21.09,20.16,18.84,18.0,18.38,18.59,18.78,19.56,21.5,23.09,24.03,24.97,26.78,28.19,28.28,27.56,26.44,25.44,23.06,21.0,19.66,19.5,19.16,18.38,18.06,18.06,18.0,17.44,17.62,18.94,20.88,22.16,23.28,24.72,26.81,27.81,28.44,28.84,29.72,30.34,30.56,31.72,34.12,35.78,35.97,34.69,33.16,31.56,29.59,27.94,27.47,28.41,28.91,28.97,29.69,30.78,31.44,30.88,30.0,30.22,30.06,29.59,28.97,29.31,29.22,28.66,27.38,27.16,28.03,28.44,28.5,29.03,29.97,30.31,29.38,28.88,29.34,30.09,30.31,30.59,30.69,30.28,28.47,25.88,23.41,21.25,18.44,15.62,13.12,11.69,10.81,10.16,10.03,11.41,13.53,15.75,18.44,22.0,25.88,29.5,32.09,34.19,35.88,36.03,35.16,33.72,33.34,33.41,33.09,32.44,32.38,31.78,30.0,27.72,25.47,24.03,22.78,21.47,21.06,21.78,22.31,22.19,22.12,23.0,24.0,24.22,24.62,25.5,26.34,26.03,24.91,24.41,24.34,24.03,23.53,23.41,23.84,23.91,23.69,23.5,23.78,23.69,22.38,20.47,19.0,18.5,17.97,17.06,17.16,17.53,17.56,17.0,16.41,16.88,17.25,17.56,17.56,18.94,20.34,20.72,20.94,22.53,24.47,26.03,27.44,29.5,32.09,34.25,35.09,35.44,35.81,34.56,32.22,29.5,27.53,26.19,25.19,24.56,25.03,26.22,27.19,27.81,28.81,30.09,31.12,31.34,31.22,31.88,31.72,31.09,30.16,30.31,30.94,31.03,31.25,32.0,32.62,32.44,31.41,30.38,29.28,28.12,26.09,24.38,23.44,22.53,21.16,19.91,19.28,18.84,17.5,15.94,14.75,14.12,13.69,13.59,14.62,16.5,18.66,19.91,21.09,22.38,23.31,23.78,23.56,24.59,25.69,26.34,26.34,26.25,25.72,24.38,22.12,19.84,18.47,17.94,17.03,16.75,17.81,18.56,18.28,16.78,15.5,14.19,12.59,11.0,10.31,10.47,10.19,9.28,8.5,9.06,10.16,11.09,12.56,15.06,17.69,19.25,19.91,21.31,22.38,23.06,22.75,22.41,22.0,20.88,18.78,17.03,16.41,16.34,16.0,16.28,17.75,19.5,21.09,21.66,22.31,22.75,22.19,20.66,18.75,17.88,17.34,16.41,16.25,17.56,19.31,21.0,21.81,23.41,25.38,25.22,23.75,22.31,20.94,19.0,16.94,15.78,15.59,15.66,15.16,15.88,17.91,20.75,23.34,26.38,29.81,33.59,35.69,36.5,37.44,37.38,36.72,34.94,33.66,32.66,31.69,29.81,27.91,26.66,25.41,24.09,22.84,22.78,23.53,23.69,23.5,23.44,23.59,23.53,23.44,23.94,25.31,26.97,27.75,28.0,28.5,28.38,27.34,25.56,24.22,23.5,22.81,21.56,21.0,20.53,19.75,18.25,17.0,16.78,17.28,17.34,16.78,16.94,17.25,16.62,15.47,14.66,14.62,14.16,13.34,12.91,13.19,13.44,12.94,12.38,12.28,12.47,12.19,12.31,13.62,15.44,17.0,18.06,18.91,19.75,19.84,18.88,17.69,16.72,16.31,14.66,13.41,13.03,12.91,12.25,11.53,11.81,12.78,13.41,13.78,14.56,15.69,16.12,15.25,14.16,13.62,12.94,11.34,9.88,9.12,9.0,8.09,7.25,7.41,8.41,9.28,9.81,10.88,12.84,14.31,14.94,15.44,15.97,16.31,15.19,14.12,13.94,14.22,14.22,14.06,15.0,16.72,17.66,17.88,18.47,19.22,19.06,17.78,16.56,15.69,15.0,13.72,13.16,13.12,13.62,13.25,12.66,12.06,11.91,11.22,9.84,9.19,9.44,9.91,9.94,10.34,11.66,13.34,13.97,14.62,15.22,15.97,15.25,14.22,13.97,14.66,14.94,14.22,13.38,12.94,11.91,10.25,8.94,8.72,9.28,9.06,8.69,9.09,10.12,10.44,10.81,11.28,12.44,13.62,13.97,14.91,16.31,17.38,16.81,15.47,14.31,13.34,10.97,8.09,5.75,4.38,2.72,1.44,1.06,2.03,3.16,3.59,4.12,5.56,7.03,7.06,7.0,6.69,6.75,5.59,4.25,3.53,4.16,4.53,4.84,5.78,7.5,8.97,8.97,8.81,9.09,9.41,8.72,7.97,8.62,10.19,11.12,12.91,15.41,18.66,21.0,21.97,22.44,22.88,22.44,20.81,19.06,18.25,17.12,15.31,13.62,13.0,13.12,13.16,12.31,11.12,10.0,8.16,5.44,3.19,2.19,1.84,0.91,-0.03,0.31,1.03,0.84,0.69,1.69,3.59,5.44,7.47,9.94,13.31,15.75,17.25,18.22,19.72,20.78,21.03,21.19,22.16,23.69,23.16,21.66,19.66,17.38,13.59,9.78,6.91,5.94,5.47,5.84,6.97,9.09,11.34,12.16,12.38,13.09,14.16,14.47,14.44,15.09,15.91,16.34,16.0,15.44,15.5,14.97,13.69,12.84,13.19,14.25,14.72,15.44,17.0,19.09,20.47,21.38,22.94,25.09,26.81,27.16,27.94,29.38,30.03,29.31,27.94,26.81,25.28,22.16,19.22,17.34,16.28,15.0,13.44,12.38,12.44,12.28,11.41,10.66,11.28,11.28,10.25,9.12,8.91,8.91,8.19,7.72,8.28,9.88,11.69,13.53,16.06,19.69,22.5,24.0,24.5,25.12,24.72,23.44,21.81,21.03,20.81,19.5,17.75,16.59,16.84,16.66,16.41,16.94,12.75,14.22,16.16,17.97,19.38,20.72,21.09,21.22,21.19,21.25,21.97,22.47,23.0,22.88,22.84,22.81,22.31,21.09,20.19,19.22,18.41,18.03,18.56,19.59,20.91,22.28,23.47,24.69:22.53,22.5,21.75,21.16,21.25,21.44,21.06,20.91,22.0,22.84,22.75,22.41,23.12,23.97,24.41,24.09,23.72,24.12,23.97,23.28,23.31,24.81,26.28,27.47,28.88,31.38,33.5,33.97,33.47,32.56,31.53,29.56,26.84,25.03,24.69,24.53,24.38,25.06,26.97,28.47,28.78,28.59,28.69,28.41,27.16,25.47,24.66,24.5,24.25,23.94,24.78,26.94,28.5,29.22,29.88,30.72,31.06,30.22,28.88,28.53,27.91,27.0,26.09,26.31,26.75,26.84,25.94,24.84,24.19,23.34,21.78,20.09,19.47,18.41,16.94,15.69,16.19,17.34,18.41,19.0,19.66,20.59,21.09,20.78,20.25,20.31,19.97,18.59,17.34,17.44,18.41,18.94,19.31,20.62,20.91,20.19,18.56,17.59,17.59,17.66,17.31,17.62,18.19,18.28,17.72,17.09,17.47,18.28,18.28,18.0,18.69,19.09,18.81,17.47,16.81,17.0,17.31,17.47,18.09,20.0,21.12,20.94,20.34,20.47,20.59,19.78,18.62,18.91,19.62,20.41,20.72,21.47,22.62,23.16,22.75,22.53,23.5,25.0,25.62,26.06,27.31,28.5,28.75,28.75,29.53,30.47,30.72,29.72,28.69,27.69,26.25,24.16,22.59,22.53,22.88,23.06,23.12,24.16,25.16,25.5,25.31,25.91,27.28,28.44,28.81,29.62,30.66,31.28,30.78,30.03,30.06,29.78,28.03,25.41,23.47,22.0,20.88,20.03,20.47,21.72,22.84,22.88,23.09,23.81,24.31,23.94,23.78,25.09,26.47,27.44,28.41,30.03,31.84,32.84,32.94,33.0,33.06,32.12,30.34,29.09,28.66,28.69,28.41,28.5,29.44,29.41,27.97,25.69,23.16,21.34,19.47,17.59,16.56,16.66,16.66,16.22,16.88,18.84,21.62,23.59,26.06,28.91,31.03,31.34,30.34,29.06,27.72,25.72,22.94,20.91,19.75,19.12,17.78,17.59,18.38,19.75,20.06,20.19,21.09,21.81,21.91,21.44,21.97,23.25,24.09,24.19,24.47,25.91,26.88,26.97,28.06,29.53,30.97,31.28,31.62,32.25,32.84,32.47,30.62,29.0,27.5,25.47,23.31,21.59,21.0,20.53,18.94,17.84,17.72,18.5,18.66,19.28,21.09,23.62,25.5,26.78,27.69,27.62,26.44,24.0,21.44,20.38,20.0,19.38,18.94,19.44,20.34,20.16,19.72,20.5,21.75,23.25,24.5,26.47,28.84,30.41,31.72,33.19,35.22,37.19,38.0,37.97,37.59,36.94,35.16,33.19,31.62,30.97,30.66,30.22,30.16,30.78,30.72,29.16,27.25,25.78,24.94,24.06,23.22,23.28,23.81,23.56,23.19,23.66,25.22,26.34,27.19,28.38,30.28,32.25,33.44,34.91,37.16,38.69,38.88,38.16,37.69,37.66,36.34,34.69,33.69,33.06,32.59,31.91,32.72,34.78,36.94,38.19,39.16,40.19,40.94,40.75,39.56,38.62,37.5,35.56,33.25,31.53,31.31,31.12,30.72,30.34,30.69,31.06,30.31,29.09,28.78,27.97,26.06,24.16,22.44,21.84,21.09,20.72,21.22,23.16,24.59,25.06,24.41,24.22,23.88,22.56,22.31,23.66,25.75,27.09,27.84,28.25,28.75,28.25,27.31,26.88,27.09,27.19,26.28,25.59,25.56,26.53,26.03,25.97,25.78,25.69,24.75,23.25,22.12,21.84,20.75,19.69,18.97,19.53,20.38,21.12,22.53,24.56,26.72,27.84,28.94,30.25,31.72,32.5,32.03,31.72,31.44,30.69,28.91,27.31,26.06,24.62,21.91,19.22,17.62,16.59,15.69,15.28,15.88,17.41,18.72,19.47,20.78,22.91,24.34,25.41,26.06,27.22,27.78,26.91,25.59,24.88,24.5,23.81,23.0,23.0,23.25,22.25,20.59,18.44,16.81,15.41,14.44,14.34,15.97,18.19,19.53,19.97,20.72,21.09,20.16,18.84,18.0,18.38,18.59,18.78,19.56,21.5,23.09,24.03,24.97,26.78,28.19,28.28,27.56,26.44,25.44,23.06,21.0,19.66,19.5,19.16,18.38,18.06,18.06,18.0,17.44,17.62,18.94,20.88,22.16,23.28,24.72,26.81,27.81,28.44,28.84,29.72,30.34,30.56,31.72,34.12,35.78,35.97,34.69,33.16,31.56,29.59,27.94,27.47,28.41,28.91,28.97,29.69,30.78,31.44,30.88,30.0,30.22,30.06,29.59,28.97,29.31,29.22,28.66,27.38,27.16,28.03,28.44,28.5,29.03,29.97,30.31,29.38,28.88,29.34,30.09,30.31,30.59,30.69,30.28,28.47,25.88,23.41,21.25,18.44,15.62,13.12,11.69,10.81,10.16,10.03,11.41,13.53,15.75,18.44,22.0,25.88,29.5,32.09,34.19,35.88,36.03,35.16,33.72,33.34,33.41,33.09,32.44,32.38,31.78,30.0,27.72,25.47,24.03,22.78,21.47,21.06,21.78,22.31,22.19,22.12,23.0,24.0,24.22,24.62,25.5,26.34,26.03,24.91,24.41,24.34,24.03,23.53,23.41,23.84,23.91,23.69,23.5,23.78,23.69,22.38,20.47,19.0,18.5,17.97,17.06,17.16,17.53,17.56,17.0,16.41,16.88,17.25,17.56,17.56,18.94,20.34,20.72,20.94,22.53,24.47,26.03,27.44,29.5,32.09,34.25,35.09,35.44,35.81,34.56,32.22,29.5,27.53,26.19,25.19,24.56,25.03,26.22,27.19,27.81,28.81,30.09,31.12,31.34,31.22,31.88,31.72,31.09,30.16,30.31,30.94,31.03,31.25,32.0,32.62,32.44,31.41,30.38,29.28,28.12,26.09,24.38,23.44,22.53,21.16,19.91,19.28,18.84,17.5,15.94,14.75,14.12,13.69,13.59,14.62,16.5,18.66,19.91,21.09,22.38,23.31,23.78,23.56,24.59,25.69,26.34,26.34,26.25,25.72,24.38,22.12,19.84,18.47,17.94,17.03,16.75,17.81,18.56,18.28,16.78,15.5,14.19,12.59,11.0,10.31,10.47,10.19,9.28,8.5,9.06,10.16,11.09,12.56,15.06,17.69,19.25,19.91,21.31,22.38,23.06,22.75,22.41,22.0,20.88,18.78,17.03,16.41,16.34,16.0,16.28,17.75,19.5,21.09,21.66,22.31,22.75,22.19,20.66,18.75,17.88,17.34,16.41,16.25,17.56,19.31,21.0,21.81,23.41,25.38,25.22,23.75,22.31,20.94,19.0,16.94,15.78,15.59,15.66,15.16,15.88,17.91,20.75,23.34,26.38,29.81,33.59,35.69,36.5,37.44,37.38,36.72,34.94,33.66,32.66,31.69,29.81,27.91,26.66,25.41,24.09,22.84,22.78,23.53,23.69,23.5,23.44,23.59,23.53,23.44,23.94,25.31,26.97,27.75,28.0,28.5,28.38,27.34,25.56,24.22,23.5,22.81,21.56,21.0,20.53,19.75,18.25,17.0,16.78,17.28,17.34,16.78,16.94,17.25,16.62,15.47,14.66,14.62,14.16,13.34,12.91,13.19,13.44,12.94,12.38,12.28,12.47,12.19,12.31,13.62,15.44,17.0,18.06,18.91,19.75,19.84,18.88,17.69,16.72,16.31,14.66,13.41,13.03,12.91,12.25,11.53,11.81,12.78,13.41,13.78,14.56,15.69,16.12,15.25,14.16,13.62,12.94,11.34,9.88,9.12,9.0,8.09,7.25,7.41,8.41,9.28,9.81,10.88,12.84,14.31,14.94,15.44,15.97,16.31,15.19,14.12,13.94,14.22,14.22,14.06,15.0,16.72,17.66,17.88,18.47,19.22,19.06,17.78,16.56,15.69,15.0,13.72,13.16,13.12,13.62,13.25,12.66,12.06,11.91,11.22,9.84,9.19,9.44,9.91,9.94,10.34,11.66,13.34,13.97,14.62,15.22,15.97,15.25,14.22,13.97,14.66,14.94,14.22,13.38,12.94,11.91,10.25,8.94,8.72,9.28,9.06,8.69,9.09,10.12,10.44,10.81,11.28,12.44,13.62,13.97,14.91,16.31,17.38,16.81,15.47,14.31,13.34,10.97,8.09,5.75,4.38,2.72,1.44,1.06,2.03,3.16,3.59,4.12,5.56,7.03,7.06,7.0,6.69,6.75,5.59,4.25,3.53,4.16,4.53,4.84,5.78,7.5,8.97,8.97,8.81,9.09,9.41,8.72,7.97,8.62,10.19,11.12,12.91,15.41,18.66,21.0,21.97,22.44,22.88,22.44,20.81,19.06,18.25,17.12,15.31,13.62,13.0,13.12,13.16,12.31,11.12,10.0,8.16,5.44,3.19,2.19,1.84,0.91,-0.03,0.31,1.03,0.84,0.69,1.69,3.59,5.44,7.47,9.94,13.31,15.75,17.25,18.22,19.72,20.78,21.03,21.19,22.16,23.69,23.16,21.66,19.66,17.38,13.59,9.78,6.91,5.94,5.47,5.84,6.97,9.09,11.34,12.16,12.38,13.09,14.16,14.47,14.44,15.09,15.91,16.34,16.0,15.44,15.5,14.97,13.69,12.84,13.19,14.25,14.72,15.44,17.0,19.09,20.47,21.38,22.94,25.09,26.81,27.16,27.94,29.38,30.03,29.31,27.94,26.81,25.28,22.16,19.22,17.34,16.28,15.0,13.44,12.38,12.44,12.28,11.41,10.66,11.28,11.28,10.25,9.12,8.91,8.91,8.19,7.72,8.28,9.88,11.69,13.53,16.06,19.69,22.5,24.0,24.5,25.12,24.72,23.44,21.81,21.03,20.81,19.5,17.75,16.59,16.84,16.66,16.41,16.94,12.75,14.22,16.16,17.97,19.38,20.72,21.09,21.22,21.19,21.25,21.97,22.47,23.0,22.88,22.84,22.81,22.31,21.09,20.19,19.22,18.41,18.03,18.56,19.59,20.91,22.28,23.47,24.69,25.44,25.41,25.06,24.59,23.91,23.12,22.5:20.91,22.0,22.84,22.75,22.41,23.12,23.97,24.41,24.09,23.72,24.12,23.97,23.28,23.31,24.81,26.28,27.47,28.88,31.38,33.5,33.97,33.47,32.56,31.53,29.56,26.84,25.03,24.69,24.53,24.38,25.06,26.97,28.47,28.78,28.59,28.69,28.41,27.16,25.47,24.66,24.5,24.25,23.94,24.78,26.94,28.5,29.22,29.88,30.72,31.06,30.22,28.88,28.53,27.91,27.0,26.09,26.31,26.75,26.84,25.94,24.84,24.19,23.34,21.78,20.09,19.47,18.41,16.94,15.69,16.19,17.34,18.41,19.0,19.66,20.59,21.09,20.78,20.25,20.31,19.97,18.59,17.34,17.44,18.41,18.94,19.31,20.62,20.91,20.19,18.56,17.59,17.59,17.66,17.31,17.62,18.19,18.28,17.72,17.09,17.47,18.28,18.28,18.0,18.69,19.09,18.81,17.47,16.81,17.0,17.31,17.47,18.09,20.0,21.12,20.94,20.34,20.47,20.59,19.78,18.62,18.91,19.62,20.41,20.72,21.47,22.62,23.16,22.75,22.53,23.5,25.0,25.62,26.06,27.31,28.5,28.75,28.75,29.53,30.47,30.72,29.72,28.69,27.69,26.25,24.16,22.59,22.53,22.88,23.06,23.12,24.16,25.16,25.5,25.31,25.91,27.28,28.44,28.81,29.62,30.66,31.28,30.78,30.03,30.06,29.78,28.03,25.41,23.47,22.0,20.88,20.03,20.47,21.72,22.84,22.88,23.09,23.81,24.31,23.94,23.78,25.09,26.47,27.44,28.41,30.03,31.84,32.84,32.94,33.0,33.06,32.12,30.34,29.09,28.66,28.69,28.41,28.5,29.44,29.41,27.97,25.69,23.16,21.34,19.47,17.59,16.56,16.66,16.66,16.22,16.88,18.84,21.62,23.59,26.06,28.91,31.03,31.34,30.34,29.06,27.72,25.72,22.94,20.91,19.75,19.12,17.78,17.59,18.38,19.75,20.06,20.19,21.09,21.81,21.91,21.44,21.97,23.25,24.09,24.19,24.47,25.91,26.88,26.97,28.06,29.53,30.97,31.28,31.62,32.25,32.84,32.47,30.62,29.0,27.5,25.47,23.31,21.59,21.0,20.53,18.94,17.84,17.72,18.5,18.66,19.28,21.09,23.62,25.5,26.78,27.69,27.62,26.44,24.0,21.44,20.38,20.0,19.38,18.94,19.44,20.34,20.16,19.72,20.5,21.75,23.25,24.5,26.47,28.84,30.41,31.72,33.19,35.22,37.19,38.0,37.97,37.59,36.94,35.16,33.19,31.62,30.97,30.66,30.22,30.16,30.78,30.72,29.16,27.25,25.78,24.94,24.06,23.22,23.28,23.81,23.56,23.19,23.66,25.22,26.34,27.19,28.38,30.28,32.25,33.44,34.91,37.16,38.69,38.88,38.16,37.69,37.66,36.34,34.69,33.69,33.06,32.59,31.91,32.72,34.78,36.94,38.19,39.16,40.19,40.94,40.75,39.56,38.62,37.5,35.56,33.25,31.53,31.31,31.12,30.72,30.34,30.69,31.06,30.31,29.09,28.78,27.97,26.06,24.16,22.44,21.84,21.09,20.72,21.22,23.16,24.59,25.06,24.41,24.22,23.88,22.56,22.31,23.66,25.75,27.09,27.84,28.25,28.75,28.25,27.31,26.88,27.09,27.19,26.28,25.59,25.56,26.53,26.03,25.97,25.78,25.69,24.75,23.25,22.12,21.84,20.75,19.69,18.97,19.53,20.38,21.12,22.53,24.56,26.72,27.84,28.94,30.25,31.72,32.5,32.03,31.72,31.44,30.69,28.91,27.31,26.06,24.62,21.91,19.22,17.62,16.59,15.69,15.28,15.88,17.41,18.72,19.47,20.78,22.91,24.34,25.41,26.06,27.22,27.78,26.91,25.59,24.88,24.5,23.81,23.0,23.0,23.25,22.25,20.59,18.44,16.81,15.41,14.44,14.34,15.97,18.19,19.53,19.97,20.72,21.09,20.16,18.84,18.0,18.38,18.59,18.78,19.56,21.5,23.09,24.03,24.97,26.78,28.19,28.28,27.56,26.44,25.44,23.06,21.0,19.66,19.5,19.16,18.38,18.06,18.06,18.0,17.44,17.62,18.94,20.88,22.16,23.28,24.72,26.81,27.81,28.44,28.84,29.72,30.34,30.56,31.72,34.12,35.78,35.97,34.69,33.16,31.56,29.59,27.94,27.47,28.41,28.91,28.97,29.69,30.78,31.44,30.88,30.0,30.22,30.06,29.59,28.97,29.31,29.22,28.66,27.38,27.16,28.03,28.44,28.5,29.03,29.97,30.31,29.38,28.88,29.34,30.09,30.31,30.59,30.69,30.28,28.47,25.88,23.41,21.25,18.44,15.62,13.12,11.69,10.81,10.16,10.03,11.41,13.53,15.75,18.44,22.0,25.88,29.5,32.09,34.19,35.88,36.03,35.16,33.72,33.34,33.41,33.09,32.44,32.38,31.78,30.0,27.72,25.47,24.03,22.78,21.47,21.06,21.78,22.31,22.19,22.12,23.0,24.0,24.22,24.62,25.5,26.34,26.03,24.91,24.41,24.34,24.03,23.53,23.41,23.84,23.91,23.69,23.5,23.78,23.69,22.38,20.47,19.0,18.5,17.97,17.06,17.16,17.53,17.56,17.0,16.41,16.88,17.25,17.56,17.56,18.94,20.34,20.72,20.94,22.53,24.47,26.03,27.44,29.5,32.09,34.25,35.09,35.44,35.81,34.56,32.22,29.5,27.53,26.19,25.19,24.56,25.03,26.22,27.19,27.81,28.81,30.09,31.12,31.34,31.22,31.88,31.72,31.09,30.16,30.31,30.94,31.03,31.25,32.0,32.62,32.44,31.41,30.38,29.28,28.12,26.09,24.38,23.44,22.53,21.16,19.91,19.28,18.84,17.5,15.94,14.75,14.12,13.69,13.59,14.62,16.5,18.66,19.91,21.09,22.38,23.31,23.78,23.56,24.59,25.69,26.34,26.34,26.25,25.72,24.38,22.12,19.84,18.47,17.94,17.03,16.75,17.81,18.56,18.28,16.78,15.5,14.19,12.59,11.0,10.31,10.47,10.19,9.28,8.5,9.06,10.16,11.09,12.56,15.06,17.69,19.25,19.91,21.31,22.38,23.06,22.75,22.41,22.0,20.88,18.78,17.03,16.41,16.34,16.0,16.28,17.75,19.5,21.09,21.66,22.31,22.75,22.19,20.66,18.75,17.88,17.34,16.41,16.25,17.56,19.31,21.0,21.81,23.41,25.38,25.22,23.75,22.31,20.94,19.0,16.94,15.78,15.59,15.66,15.16,15.88,17.91,20.75,23.34,26.38,29.81,33.59,35.69,36.5,37.44,37.38,36.72,34.94,33.66,32.66,31.69,29.81,27.91,26.66,25.41,24.09,22.84,22.78,23.53,23.69,23.5,23.44,23.59,23.53,23.44,23.94,25.31,26.97,27.75,28.0,28.5,28.38,27.34,25.56,24.22,23.5,22.81,21.56,21.0,20.53,19.75,18.25,17.0,16.78,17.28,17.34,16.78,16.94,17.25,16.62,15.47,14.66,14.62,14.16,13.34,12.91,13.19,13.44,12.94,12.38,12.28,12.47,12.19,12.31,13.62,15.44,17.0,18.06,18.91,19.75,19.84,18.88,17.69,16.72,16.31,14.66,13.41,13.03,12.91,12.25,11.53,11.81,12.78,13.41,13.78,14.56,15.69,16.12,15.25,14.16,13.62,12.94,11.34,9.88,9.12,9.0,8.09,7.25,7.41,8.41,9.28,9.81,10.88,12.84,14.31,14.94,15.44,15.97,16.31,15.19,14.12,13.94,14.22,14.22,14.06,15.0,16.72,17.66,17.88,18.47,19.22,19.06,17.78,16.56,15.69,15.0,13.72,13.16,13.12,13.62,13.25,12.66,12.06,11.91,11.22,9.84,9.19,9.44,9.91,9.94,10.34,11.66,13.34,13.97,14.62,15.22,15.97,15.25,14.22,13.97,14.66,14.94,14.22,13.38,12.94,11.91,10.25,8.94,8.72,9.28,9.06,8.69,9.09,10.12,10.44,10.81,11.28,12.44,13.62,13.97,14.91,16.31,17.38,16.81,15.47,14.31,13.34,10.97,8.09,5.75,4.38,2.72,1.44,1.06,2.03,3.16,3.59,4.12,5.56,7.03,7.06,7.0,6.69,6.75,5.59,4.25,3.53,4.16,4.53,4.84,5.78,7.5,8.97,8.97,8.81,9.09,9.41,8.72,7.97,8.62,10.19,11.12,12.91,15.41,18.66,21.0,21.97,22.44,22.88,22.44,20.81,19.06,18.25,17.12,15.31,13.62,13.0,13.12,13.16,12.31,11.12,10.0,8.16,5.44,3.19,2.19,1.84,0.91,-0.03,0.31,1.03,0.84,0.69,1.69,3.59,5.44,7.47,9.94,13.31,15.75,17.25,18.22,19.72,20.78,21.03,21.19,22.16,23.69,23.16,21.66,19.66,17.38,13.59,9.78,6.91,5.94,5.47,5.84,6.97,9.09,11.34,12.16,12.38,13.09,14.16,14.47,14.44,15.09,15.91,16.34,16.0,15.44,15.5,14.97,13.69,12.84,13.19,14.25,14.72,15.44,17.0,19.09,20.47,21.38,22.94,25.09,26.81,27.16,27.94,29.38,30.03,29.31,27.94,26.81,25.28,22.16,19.22,17.34,16.28,15.0,13.44,12.38,12.44,12.28,11.41,10.66,11.28,11.28,10.25,9.12,8.91,8.91,8.19,7.72,8.28,9.88,11.69,13.53,16.06,19.69,22.5,24.0,24.5,25.12,24.72,23.44,21.81,21.03,20.81,19.5,17.75,16.59,16.84,16.66,16.41,16.94,12.75,14.22,16.16,17.97,19.38,20.72,21.09,21.22,21.19,21.25,21.97,22.47,23.0,22.88,22.84,22.81,22.31,21.09,20.19,19.22,18.41,18.03,18.56,19.59,20.91,22.28,23.47,24.69,25.44,25.41,25.06,24.59,23.91,23.12,22.5,22.34,22.0,22.25,22.44,23.19,24.62,26.09:negativity
-8.16,-7.31,-8.19,-6.78,-3.16,0.12,1.81,4.75,9.62,13.09,13.69,13.66,15.25,16.38,15.16,12.66,12.16,12.69,12.09,10.22,9.97,11.56,11.84,9.62,7.66,7.88,8.19,6.66,5.88,7.75,10.38,10.31,8.97,9.03,9.38,7.78,4.19,2.03,1.91,1.56,-0.56,-1.66,-0.5,-0.03,-2.03,-4.59,-4.62,-3.69,-5.03,-7.0,-6.94,-5.91,-6.91,-9.66,-11.19,-10.59,-10.5,-11.38,-10.81,-7.5,-3.94,-2.34,-1.69,1.12,4.56,5.66,5.59,7.69,11.34,14.12,14.84,16.31,19.22,20.31,18.09,15.53,14.78,13.44,10.47,7.5,6.91,7.66,7.19,5.5,5.81,7.78,9.22,8.59,9.06,11.47,12.91,11.41,9.44,9.12,8.53,5.12,0.84,-1.09,-2.53,-5.28,-9.5,-12.22,-13.03,-14.44,-16.94,-17.22,-13.56,-9.0,-5.78,-2.12,3.5,9.19,12.25,14.19,17.41,21.41,23.41,23.22,23.25,24.5,23.53,19.38,15.25,12.88,9.97,5.03,-0.19,-3.09,-5.19,-8.41,-11.59,-11.41,-9.25,-7.16,-6.06,-3.22,1.59,6.38,9.53,13.31,19.25,24.47,26.75,27.53,28.88,29.34,26.12,20.22,15.25,11.31,6.84,1.75,-0.88,-0.59,-0.25,-1.88,-2.56,-0.44,2.16,3.25,3.88,6.69,10.72,12.81,14.09,17.22,21.5,23.88,23.34,22.66,22.78,21.62,17.5,13.5,12.19,11.84,10.0,8.16,8.56,10.53,10.59,9.44,10.12,11.97,13.09,12.31,12.91,16.28,19.72,20.62,21.31,23.59,24.81,23.12,20.19,19.09,18.66,16.94,13.81,11.94,11.56,9.97,5.81,2.5,1.88,1.84,1.19,2.38,7.5,13.66,17.91,20.34,22.97,24.81,24.19,21.34,19.41,18.91,18.5,16.09,14.53,15.34,16.62,15.62,14.72,15.88,17.88,18.03,16.53,15.72,14.88,11.91,6.84,3.41,2.94,2.91,1.34,0.75,2.06,3.22,1.5,-0.69,-1.09,-0.47,-1.31,-2.06,-0.47,3.31,6.22,7.59,9.19,12.5,15.06,15.19,15.53,18.09,20.66,20.34,18.88,18.66,18.62,17.09,13.94,12.59,13.41,13.53,12.19,11.69,13.28,13.94,12.06,9.97,10.0,10.84,9.94,8.88,10.44,13.19,14.53,14.12,14.81,16.12,16.59,14.25,12.53,12.62,12.59,10.19,8.09,8.38,9.62,9.22,8.31,8.66,10.44,10.75,9.75,9.97,12.28,14.0,13.47,12.94,13.69,14.09,11.38,8.28,7.34,7.38,5.94,4.03,4.0,5.38,5.72,4.09,3.25,4.31,5.19,4.03,3.12,4.34,5.91,4.53,2.84,3.09,4.38,4.28,3.25,4.03,6.34,7.62,6.91,7.16,9.59,11.09,9.88,8.97,9.97,10.88,9.69,8.12,8.09,9.53,9.41,8.72,9.72,12.47,14.0,13.16,12.81,13.81,14.38,12.94,11.5,12.75,14.38,13.78,12.25,11.94,12.44,10.91,8.34,7.16,7.97,8.34,7.25,7.09,9.25,11.66,12.16,13.03,15.91,19.75,21.03,21.12,22.06,23.88,23.59,21.81,20.44,20.78,20.25,17.91,16.06,16.19,16.56,14.31,12.09,12.09,13.19,13.12,12.41,13.41,15.91,16.88,16.34,15.91,17.19,17.5,15.59,14.25,14.91,16.31,15.53,13.94,14.34,15.47,14.28,11.53,9.91,9.69,8.56,6.41,6.12,8.38,11.06,11.59,12.12,14.28,16.81,16.59,15.31,15.41,17.06,16.84,15.81,16.28,18.41,19.44,18.53,17.72,19.06,19.84,18.47,16.78,17.91,20.25,20.53,19.81,20.03,20.69,18.03,13.19,9.31,7.81,6.25,4.22,3.44,5.12,6.56,5.91,4.56,4.62,5.62,5.22,3.84,4.5,7.44,9.47,10.09,11.88,15.19,17.38,16.41,15.22,15.81,16.28,14.72,12.56,12.06,12.34,10.88,8.16,6.69,7.19,6.75,5.0,4.62,7.0,9.06,9.16,8.56,9.41,10.06,8.03,5.06,4.66,5.62,4.69,3.69,4.25,6.84,9.06,9.72,10.97,13.97,16.16,15.41,14.25,14.66,15.31,13.84,11.38,10.28,10.09,8.31,5.53,3.94,4.47,4.53,3.59,3.91,7.34,10.91,12.62,13.28,15.34,17.09,16.84,15.03,14.75,16.0,16.38,15.28,15.03,16.56,16.84,14.59,12.47,12.88,13.09,11.69,10.0,10.38,11.41,10.94,9.0,8.47,9.19,9.25,8.44,9.25,12.44,15.16,15.19,14.75,15.78,16.84,15.59,13.62,13.28,13.75,12.47,10.31,10.16,12.16,13.94,14.69,15.94,19.28,21.75,21.06,19.06,19.25,19.06,16.97,14.22,13.31,13.84,13.47,11.78,12.0,14.31,15.28,13.88,12.34,13.0,13.19,11.41,9.84,10.38,11.66,11.25,9.88,10.44,12.03,12.69,12.0,12.56,15.06,17.12,16.84,17.25,19.84,22.44,22.5,21.75,22.41,23.28,21.66,18.5,16.41,15.47,13.5,9.75,7.41,7.56,7.62,6.0,4.66,6.56,8.38,8.0,6.78,7.38,8.66,8.41,7.56,8.25,10.75,12.28,11.38,11.12,12.59,13.12,11.16,8.31,8.12,8.59,7.44,5.56,6.0,6.84,5.0,1.62,-0.25,0.25,0.53,-0.03,0.22,2.88,6.06,7.12,7.91,11.03,13.91,13.66,11.91,11.47,12.03,11.66,10.19,10.56,12.38,13.81,12.94,12.56,14.16,16.06,16.0,15.12,16.75,18.84,19.34,18.69,19.69,21.31,21.72,20.28,20.38,22.16,23.75,22.91,21.66,22.03,22.28,19.84,16.53,15.5,16.0,14.72,12.81,12.94,14.53,14.75,13.75,12.94,13.94,14.53,12.41,10.62,11.16,12.19,11.44,9.88,10.25,11.62,11.75,10.84,11.72,14.22,15.84,14.97,14.75,16.53,18.03,17.19,16.06,16.53,16.88,15.0,11.72,10.41,10.28,9.25,7.25,7.0,8.59,9.97,8.97,8.56,9.94,10.81,8.84,6.22,5.22,5.5,4.25,2.69,3.78,7.06,8.88,8.97,10.12,12.41,13.69,12.28,11.03,11.59,12.41,10.5,8.38,8.5,9.44,8.78,6.62,5.97,6.16,4.84,1.62,-0.03,1.0,1.59,1.09,0.91,3.44,5.75,5.56,4.44,5.0,6.5,6.53,5.5,6.62,9.34,11.06,10.91,11.28,13.5,14.75,13.06,11.03,10.5,10.22,7.66,4.5,3.94,5.25,5.69,5.22,6.41,8.72,9.69,7.5,5.66,6.12,7.31,7.34,8.22,11.47,15.0,15.66,14.0,13.06,13.12,11.47,9.22,8.69,10.94,13.41,13.44,13.72,15.44,16.62,14.53,11.53,10.5,10.78,9.38,7.0,6.5,7.25,6.38,3.72,2.59,4.38,6.25,6.75,7.81,11.22,14.34,14.56,12.78,12.56,12.38,10.78,8.62,8.53,11.5,13.81,13.88,14.38,15.72,16.06,13.03,10.12,9.03,8.78,5.88,2.41,0.78,0.69,-0.03,-1.56,-1.28,1.16,2.12,0.84,-0.16,1.28,3.22,3.34,4.53,8.38,13.03,14.88,14.97,14.97,15.03,12.0,6.81,2.72,1.53,0.34,-1.81,-2.31,0.66,4.25,6.19,8.31,12.31,16.5,17.22,15.38,13.5,11.94,8.84,3.78,0.03,-1.28,-2.66,-5.75,-7.28,-5.69,-3.03,-2.25,-1.53,1.0,4.28,5.44,4.75,5.47,6.94,6.94,4.62,2.94,3.31,3.78,2.09,0.94,1.69,2.38,0.19,-3.03,-4.25,-3.88,-4.34,-4.97,-3.69,-0.09,2.66,3.5,4.53,7.69,9.62,8.34,5.5,3.59,1.69,-3.44,-9.84,-14.31,-17.03,-20.34,-23.88,-24.47,-21.94,-19.53,-19.34,-19.28,-16.88,-14.56,-14.16,-12.75,-8.03,-2.22,1.84,5.06,9.81,15.59,19.12,19.72,19.66,19.5,17.5,12.25,7.06,4.0,1.06,-4.25,-10.34,-14.06,-16.0,-18.84,-21.22,-20.84,-17.09,-13.91,-11.56,-8.81,-3.47,0.75,2.12,2.41,4.19,5.0,3.12,0.41,0.16,2.22,3.09,3.34,4.59,6.91,6.53,2.81,-1.16,-3.34,-5.09,-8.72,-11.97,-11.94,-11.47,-12.66,-14.78,-14.0,-11.31,-9.56,-8.78,-6.22,-2.03,1.28,2.03,2.94,5.78,7.88,6.81,5.16,5.34,5.84,4.16,1.69,0.62,1.06,0.25,-2.12,-3.09,-1.25,-0.03,-0.69,-1.84,-1.16,-1.03,-3.78,-7.06,-7.72,-6.22,-5.91,-6.06,-4.03,-0.19,2.09,1.91,2.66,5.34,6.91,6.19,5.22,6.03,6.34,3.72,-0.22,-1.78,-2.66,-4.28,-7.16,-7.34,-5.66,-5.06,-6.91,-7.84,-7.12,-7.16,-9.09,-10.5,-8.56,-4.94,-3.12,-1.88,0.91,4.38,5.56,4.47,4.91,7.09,7.88,6.22,5.03,5.84,6.31,4.72,3.09,3.94,5.97,5.28,4.0,4.59,6.75,7.34,6.5,6.62,8.78,9.91,8.88,8.22,9.66,10.78,9.75,8.03,9.16,11.44,11.75,10.5,10.5,10.81,9.12,5.06,2.03,1.56,0.97,-1.22,-2.31,-0.41,2.0,2.72,2.72,4.41,6.38,5.84,3.34,1.88,2.09,1.25,-1.12,-2.0,-0.06,1.47,0.91,0.34,1.88,4.25,4.34,3.81,5.56,8.44,8.91,8.0,7.84,9.47,9.38,7.0,5.56,6.47,6.91,5.22,3.75,4.41,5.56,4.94,3.28,3.88,5.75,6.22,5.28,5.25,6.75,7.47,5.41,3.91,4.56,5.19,3.72,1.94,2.91,4.81,5.16,5.06,6.56,9.56,11.28,11.22,11.88,13.69:4.75,9.62,13.09,13.69,13.66,15.25,16.38,15.16,12.66,12.16,12.69,12.09,10.22,9.97,11.56,11.84,9.62,7.66,7.88,8.19,6.66,5.88,7.75,10.38,10.31,8.97,9.03,9.38,7.78,4.19,2.03,1.91,1.56,-0.56,-1.66,-0.5,-0.03,-2.03,-4.59,-4.62,-3.69,-5.03,-7.0,-6.94,-5.91,-6.91,-9.66,-11.19,-10.59,-10.5,-11.38,-10.81,-7.5,-3.94,-2.34,-1.69,1.12,4.56,5.66,5.59,7.69,11.34,14.12,14.84,16.31,19.22,20.31,18.09,15.53,14.78,13.44,10.47,7.5,6.91,7.66,7.19,5.5,5.81,7.78,9.22,8.59,9.06,11.47,12.91,11.41,9.44,9.12,8.53,5.12,0.84,-1.09,-2.53,-5.28,-9.5,-12.22,-13.03,-14.44,-16.94,-17.22,-13.56,-9.0,-5.78,-2.12,3.5,9.19,12.25,14.19,17.41,21.41,23.41,23.22,23.25,24.5,23.53,19.38,15.25,12.88,9.97,5.03,-0.19,-3.09,-5.19,-8.41,-11.59,-11.41,-9.25,-7.16,-6.06,-3.22,1.59,6.38,9.53,13.31,19.25,24.47,26.75,27.53,28.88,29.34,26.12,20.22,15.25,11.31,6.84,1.75,-0.88,-0.59,-0.25,-1.88,-2.56,-0.44,2.16,3.25,3.88,6.69,10.72,12.81,14.09,17.22,21.5,23.88,23.34,22.66,22.78,21.62,17.5,13.5,12.19,11.84,10.0,8.16,8.56,10.53,10.59,9.44,10.12,11.97,13.09,12.31,12.91,16.28,19.72,20.62,21.31,23.59,24.81,23.12,20.19,19.09,18.66,16.94,13.81,11.94,11.56,9.97,5.81,2.5,1.88,1.84,1.19,2.38,7.5,13.66,17.91,20.34,22.97,24.81,24.19,21.34,19.41,18.91,18.5,16.09,14.53,15.34,16.62,15.62,14.72,15.88,17.88,18.03,16.53,15.72,14.88,11.91,6.84,3.41,2.94,2.91,1.34,0.75,2.06,3.22,1.5,-0.69,-1.09,-0.47,-1.31,-2.06,-0.47,3.31,6.22,7.59,9.19,12.5,15.06,15.19,15.53,18.09,20.66,20.34,18.88,18.66,18.62,17.09,13.94,12.59,13.41,13.53,12.19,11.69,13.28,13.94,12.06,9.97,10.0,10.84,9.94,8.88,10.44,13.19,14.53,14.12,14.81,16.12,16.59,14.25,12.53,12.62,12.59,10.19,8.09,8.38,9.62,9.22,8.31,8.66,10.44,10.75,9.75,9.97,12.28,14.0,13.47,12.94,13.69,14.09,11.38,8.28,7.34,7.38,5.94,4.03,4.0,5.38,5.72,4.09,3.25,4.31,5.19,4.03,3.12,4.34,5.91,4.53,2.84,3.09,4.38,4.28,3.25,4.03,6.34,7.62,6.91,7.16,9.59,11.09,9.88,8.97,9.97,10.88,9.69,8.12,8.09,9.53,9.41,8.72,9.72,12.47,14.0,13.16,12.81,13.81,14.38,12.94,11.5,12.75,14.38,13.78,12.25,11.94,12.44,10.91,8.34,7.16,7.97,8.34,7.25,7.09,9.25,11.66,12.16,13.03,15.91,19.75,21.03,21.12,22.06,23.88,23.59,21.81,20.44,20.78,20.25,17.91,16.06,16.19,16.56,14.31,12.09,12.09,13.19,13.12,12.41,13.41,15.91,16.88,16.34,15.91,17.19,17.5,15.59,14.25,14.91,16.31,15.53,13.94,14.34,15.47,14.28,11.53,9.91,9.69,8.56,6.41,6.12,8.38,11.06,11.59,12.12,14.28,16.81,16.59,15.31,15.41,17.06,16.84,15.81,16.28,18.41,19.44,18.53,17.72,19.06,19.84,18.47,16.78,17.91,20.25,20.53,19.81,20.03,20.69,18.03,13.19,9.31,7.81,6.25,4.22,3.44,5.12,6.56,5.91,4.56,4.62,5.62,5.22,3.84,4.5,7.44,9.47,10.09,11.88,15.19,17.38,16.41,15.22,15.81,16.28,14.72,12.56,12.06,12.34,10.88,8.16,6.69,7.19,6.75,5.0,4.62,7.0,9.06,9.16,8.56,9.41,10.06,8.03,5.06,4.66,5.62,4.69,3.69,4.25,6.84,9.06,9.72,10.97,13.97,16.16,15.41,14.25,14.66,15.31,13.84,11.38,10.28,10.09,8.31,5.53,3.94,4.47,4.53,3.59,3.91,7.34,10.91,12.62,13.28,15.34,17.09,16.84,15.03,14.75,16.0,16.38,15.28,15.03,16.56,16.84,14.59,12.47,12.88,13.09,11.69,10.0,10.38,11.41,10.94,9.0,8.47,9.19,9.25,8.44,9.25,12.44,15.16,15.19,14.75,15.78,16.84,15.59,13.62,13.28,13.75,12.47,10.31,10.16,12.16,13.94,14.69,15.94,19.28,21.75,21.06,19.06,19.25,19.06,16.97,14.22,13.31,13.84,13.47,11.78,12.0,14.31,15.28,13.88,12.34,13.0,13.19,11.41,9.84,10.38,11.66,11.25,9.88,10.44,12.03,12.69,12.0,12.56,15.06,17.12,16.84,17.25,19.84,22.44,22.5,21.75,22.41,23.28,21.66,18.5,16.41,15.47,13.5,9.75,7.41,7.56,7.62,6.0,4.66,6.56,8.38,8.0,6.78,7.38,8.66,8.41,7.56,8.25,10.75,12.28,11.38,11.12,12.59,13.12,11.16,8.31,8.12,8.59,7.44,5.56,6.0,6.84,5.0,1.62,-0.25,0.25,0.53,-0.03,0.22,2.88,6.06,7.12,7.91,11.03,13.91,13.66,11.91,11.47,12.03,11.66,10.19,10.56,12.38,13.81,12.94,12.56,14.16,16.06,16.0,15.12,16.75,18.84,19.34,18.69,19.69,21.31,21.72,20.28,20.38,22.16,23.75,22.91,21.66,22.03,22.28,19.84,16.53,15.5,16.0,14.72,12.81,12.94,14.53,14.75,13.75,12.94,13.94,14.53,12.41,10.62,11.16,12.19,11.44,9.88,10.25,11.62,11.75,10.84,11.72,14.22,15.84,14.97,14.75,16.53,18.03,17.19,16.06,16.53,16.88,15.0,11.72,10.41,10.28,9.25,7.25,7.0,8.59,9.97,8.97,8.56,9.94,10.81,8.84,6.22,5.22,5.5,4.25,2.69,3.78,7.06,8.88,8.97,10.12,12.41,13.69,12.28,11.03,11.59,12.41,10.5,8.38,8.5,9.44,8.78,6.62,5.97,6.16,4.84,1.62,-0.03,1.0,1.59,1.09,0.91,3.44,5.75,5.56,4.44,5.0,6.5,6.53,5.5,6.62,9.34,11.06,10.91,11.28,13.5,14.75,13.06,11.03,10.5,10.22,7.66,4.5,3.94,5.25,5.69,5.22,6.41,8.72,9.69,7.5,5.66,6.12,7.31,7.34,8.22,11.47,15.0,15.66,14.0,13.06,13.12,11.47,9.22,8.69,10.94,13.41,13.44,13.72,15.44,16.62,14.53,11.53,10.5,10.78,9.38,7.0,6.5,7.25,6.38,3.72,2.59,4.38,6.25,6.75,7.81,11.22,14.34,14.56,12.78,12.56,12.38,10.78,8.62,8.53,11.5,13.81,13.88,14.38,15.72,16.06,13.03,10.12,9.03,8.78,5.88,2.41,0.78,0.69,-0.03,-1.56,-1.28,1.16,2.12,0.84,-0.16,1.28,3.22,3.34,4.53,8.38,13.03,14.88,14.97,14.97,15.03,12.0,6.81,2.72,1.53,0.34,-1.81,-2.31,0.66,4.25,6.19,8.31,12.31,16.5,17.22,15.38,13.5,11.94,8.84,3.78,0.03,-1.28,-2.66,-5.75,-7.28,-5.69,-3.03,-2.25,-1.53,1.0,4.28,5.44,4.75,5.47,6.94,6.94,4.62,2.94,3.31,3.78,2.09,0.94,1.69,2.38,0.19,-3.03,-4.25,-3.88,-4.34,-4.97,-3.69,-0.09,2.66,3.5,4.53,7.69,9.62,8.34,5.5,3.59,1.69,-3.44,-9.84,-14.31,-17.03,-20.34,-23.88,-24.47,-21.94,-19.53,-19.34,-19.28,-16.88,-14.56,-14.16,-12.75,-8.03,-2.22,1.84,5.06,9.81,15.59,19.12,19.72,19.66,19.5,17.5,12.25,7.06,4.0,1.06,-4.25,-10.34,-14.06,-16.0,-18.84,-21.22,-20.84,-17.09,-13.91,-11.56,-8.81,-3.47,0.75,2.12,2.41,4.19,5.0,3.12,0.41,0.16,2.22,3.09,3.34,4.59,6.91,6.53,2.81,-1.16,-3.34,-5.09,-8.72,-11.97,-11.94,-11.47,-12.66,-14.78,-14.0,-11.31,-9.56,-8.78,-6.22,-2.03,1.28,2.03,2.94,5.78,7.88,6.81,5.16,5.34,5.84,4.16,1.69,0.62,1.06,0.25,-2.12,-3.09,-1.25,-0.03,-0.69,-1.84,-1.16,-1.03,-3.78,-7.06,-7.72,-6.22,-5.91,-6.06,-4.03,-0.19,2.09,1.91,2.66,5.34,6.91,6.19,5.22,6.03,6.34,3.72,-0.22,-1.78,-2.66,-4.28,-7.16,-7.34,-5.66,-5.06,-6.91,-7.84,-7.12,-7.16,-9.09,-10.5,-8.56,-4.94,-3.12,-1.88,0.91,4.38,5.56,4.47,4.91,7.09,7.88,6.22,5.03,5.84,6.31,4.72,3.09,3.94,5.97,5.28,4.0,4.59,6.75,7.34,6.5,6.62,8.78,9.91,8.88,8.22,9.66,10.78,9.75,8.03,9.16,11.44,11.75,10.5,10.5,10.81,9.12,5.06,2.03,1.56,0.97,-1.22,-2.31,-0.41,2.0,2.72,2.72,4.41,6.38,5.84,3.34,1.88,2.09,1.25,-1.12,-2.0,-0.06,1.47,0.91,0.34,1.88,4.25,4.34,3.81,5.56,8.44,8.91,8.0,7.84,9.47,9.38,7.0,5.56,6.47,6.91,5.22,3.75,4.41,5.56,4.94,3.28,3.88,5.75,6.22,5.28,5.25,6.75,7.47,5.41,3.91,4.56,5.19,3.72,1.94,2.91,4.81,5.16,5.06,6.56,9.56,11.28,11.22,11.88,13.69,1.19,1.06,-0.16,0.12,1.91,3.69,4.88:15.16,12.66,12.16,12.69,12.09,10.22,9.97,11.56,11.84,9.62,7.66,7.88,8.19,6.66,5.88,7.75,10.38,10.31,8.97,9.03,9.38,7.78,4.19,2.03,1.91,1.56,-0.56,-1.66,-0.5,-0.03,-2.03,-4.59,-4.62,-3.69,-5.03,-7.0,-6.94,-5.91,-6.91,-9.66,-11.19,-10.59,-10.5,-11.38,-10.81,-7.5,-3.94,-2.34,-1.69,1.12,4.56,5.66,5.59,7.69,11.34,14.12,14.84,16.31,19.22,20.31,18.09,15.53,14.78,13.44,10.47,7.5,6.91,7.66,7.19,5.5,5.81,7.78,9.22,8.59,9.06,11.47,12.91,11.41,9.44,9.12,8.53,5.12,0.84,-1.09,-2.53,-5.28,-9.5,-12.22,-13.03,-14.44,-16.94,-17.22,-13.56,-9.0,-5.78,-2.12,3.5,9.19,12.25,14.19,17.41,21.41,23.41,23.22,23.25,24.5,23.53,19.38,15.25,12.88,9.97,5.03,-0.19,-3.09,-5.19,-8.41,-11.59,-11.41,-9.25,-7.16,-6.06,-3.22,1.59,6.38,9.53,13.31,19.25,24.47,26.75,27.53,28.88,29.34,26.12,20.22,15.25,11.31,6.84,1.75,-0.88,-0.59,-0.25,-1.88,-2.56,-0.44,2.16,3.25,3.88,6.69,10.72,12.81,14.09,17.22,21.5,23.88,23.34,22.66,22.78,21.62,17.5,13.5,12.19,11.84,10.0,8.16,8.56,10.53,10.59,9.44,10.12,11.97,13.09,12.31,12.91,16.28,19.72,20.62,21.31,23.59,24.81,23.12,20.19,19.09,18.66,16.94,13.81,11.94,11.56,9.97,5.81,2.5,1.88,1.84,1.19,2.38,7.5,13.66,17.91,20.34,22.97,24.81,24.19,21.34,19.41,18.91,18.5,16.09,14.53,15.34,16.62,15.62,14.72,15.88,17.88,18.03,16.53,15.72,14.88,11.91,6.84,3.41,2.94,2.91,1.34,0.75,2.06,3.22,1.5,-0.69,-1.09,-0.47,-1.31,-2.06,-0.47,3.31,6.22,7.59,9.19,12.5,15.06,15.19,15.53,18.09,20.66,20.34,18.88,18.66,18.62,17.09,13.94,12.59,13.41,13.53,12.19,11.69,13.28,13.94,12.06,9.97,10.0,10.84,9.94,8.88,10.44,13.19,14.53,14.12,14.81,16.12,16.59,14.25,12.53,12.62,12.59,10.19,8.09,8.38,9.62,9.22,8.31,8.66,10.44,10.75,9.75,9.97,12.28,14.0,13.47,12.94,13.69,14.09,11.38,8.28,7.34,7.38,5.94,4.03,4.0,5.38,5.72,4.09,3.25,4.31,5.19,4.03,3.12,4.34,5.91,4.53,2.84,3.09,4.38,4.28,3.25,4.03,6.34,7.62,6.91,7.16,9.59,11.09,9.88,8.97,9.97,10.88,9.69,8.12,8.09,9.53,9.41,8.72,9.72,12.47,14.0,13.16,12.81,13.81,14.38,12.94,11.5,12.75,14.38,13.78,12.25,11.94,12.44,10.91,8.34,7.16,7.97,8.34,7.25,7.09,9.25,11.66,12.16,13.03,15.91,19.75,21.03,21.12,22.06,23.88,23.59,21.81,20.44,20.78,20.25,17.91,16.06,16.19,16.56,14.31,12.09,12.09,13.19,13.12,12.41,13.41,15.91,16.88,16.34,15.91,17.19,17.5,15.59,14.25,14.91,16.31,15.53,13.94,14.34,15.47,14.28,11.53,9.91,9.69,8.56,6.41,6.12,8.38,11.06,11.59,12.12,14.28,16.81,16.59,15.31,15.41,17.06,16.84,15.81,16.28,18.41,19.44,18.53,17.72,19.06,19.84,18.47,16.78,17.91,20.25,20.53,19.81,20.03,20.69,18.03,13.19,9.31,7.81,6.25,4.22,3.44,5.12,6.56,5.91,4.56,4.62,5.62,5.22,3.84,4.5,7.44,9.47,10.09,11.88,15.19,17.38,16.41,15.22,15.81,16.28,14.72,12.56,12.06,12.34,10.88,8.16,6.69,7.19,6.75,5.0,4.62,7.0,9.06,9.16,8.56,9.41,10.06,8.03,5.06,4.66,5.62,4.69,3.69,4.25,6.84,9.06,9.72,10.97,13.97,16.16,15.41,14.25,14.66,15.31,13.84,11.38,10.28,10.09,8.31,5.53,3.94,4.47,4.53,3.59,3.91,7.34,10.91,12.62,13.28,15.34,17.09,16.84,15.03,14.75,16.0,16.38,15.28,15.03,16.56,16.84,14.59,12.47,12.88,13.09,11.69,10.0,10.38,11.41,10.94,9.0,8.47,9.19,9.25,8.44,9.25,12.44,15.16,15.19,14.75,15.78,16.84,15.59,13.62,13.28,13.75,12.47,10.31,10.16,12.16,13.94,14.69,15.94,19.28,21.75,21.06,19.06,19.25,19.06,16.97,14.22,13.31,13.84,13.47,11.78,12.0,14.31,15.28,13.88,12.34,13.0,13.19,11.41,9.84,10.38,11.66,11.25,9.88,10.44,12.03,12.69,12.0,12.56,15.06,17.12,16.84,17.25,19.84,22.44,22.5,21.75,22.41,23.28,21.66,18.5,16.41,15.47,13.5,9.75,7.41,7.56,7.62,6.0,4.66,6.56,8.38,8.0,6.78,7.38,8.66,8.41,7.56,8.25,10.75,12.28,11.38,11.12,12.59,13.12,11.16,8.31,8.12,8.59,7.44,5.56,6.0,6.84,5.0,1.62,-0.25,0.25,0.53,-0.03,0.22,2.88,6.06,7.12,7.91,11.03,13.91,13.66,11.91,11.47,12.03,11.66,10.19,10.56,12.38,13.81,12.94,12.56,14.16,16.06,16.0,15.12,16.75,18.84,19.34,18.69,19.69,21.31,21.72,20.28,20.38,22.16,23.75,22.91,21.66,22.03,22.28,19.84,16.53,15.5,16.0,14.72,12.81,12.94,14.53,14.75,13.75,12.94,13.94,14.53,12.41,10.62,11.16,12.19,11.44,9.88,10.25,11.62,11.75,10.84,11.72,14.22,15.84,14.97,14.75,16.53,18.03,17.19,16.06,16.53,16.88,15.0,11.72,10.41,10.28,9.25,7.25,7.0,8.59,9.97,8.97,8.56,9.94,10.81,8.84,6.22,5.22,5.5,4.25,2.69,3.78,7.06,8.88,8.97,10.12,12.41,13.69,12.28,11.03,11.59,12.41,10.5,8.38,8.5,9.44,8.78,6.62,5.97,6.16,4.84,1.62,-0.03,1.0,1.59,1.09,0.91,3.44,5.75,5.56,4.44,5.0,6.5,6.53,5.5,6.62,9.34,11.06,10.91,11.28,13.5,14.75,13.06,11.03,10.5,10.22,7.66,4.5,3.94,5.25,5.69,5.22,6.41,8.72,9.69,7.5,5.66,6.12,7.31,7.34,8.22,11.47,15.0,15.66,14.0,13.06,13.12,11.47,9.22,8.69,10.94,13.41,13.44,13.72,15.44,16.62,14.53,11.53,10.5,10.78,9.38,7.0,6.5,7.25,6.38,3.72,2.59,4.38,6.25,6.75,7.81,11.22,14.34,14.56,12.78,12.56,12.38,10.78,8.62,8.53,11.5,13.81,13.88,14.38,15.72,16.06,13.03,10.12,9.03,8.78,5.88,2.41,0.78,0.69,-0.03,-1.56,-1.28,1.16,2.12,0.84,-0.16,1.28,3.22,3.34,4.53,8.38,13.03,14.88,14.97,14.97,15.03,12.0,6.81,2.72,1.53,0.34,-1.81,-2.31,0.66,4.25,6.19,8.31,12.31,16.5,17.22,15.38,13.5,11.94,8.84,3.78,0.03,-1.28,-2.66,-5.75,-7.28,-5.69,-3.03,-2.25,-1.53,1.0,4.28,5.44,4.75,5.47,6.94,6.94,4.62,2.94,3.31,3.78,2.09,0.94,1.69,2.38,0.19,-3.03,-4.25,-3.88,-4.34,-4.97,-3.69,-0.09,2.66,3.5,4.53,7.69,9.62,8.34,5.5,3.59,1.69,-3.44,-9.84,-14.31,-17.03,-20.34,-23.88,-24.47,-21.94,-19.53,-19.34,-19.28,-16.88,-14.56,-14.16,-12.75,-8.03,-2.22,1.84,5.06,9.81,15.59,19.12,19.72,19.66,19.5,17.5,12.25,7.06,4.0,1.06,-4.25,-10.34,-14.06,-16.0,-18.84,-21.22,-20.84,-17.09,-13.91,-11.56,-8.81,-3.47,0.75,2.12,2.41,4.19,5.0,3.12,0.41,0.16,2.22,3.09,3.34,4.59,6.91,6.53,2.81,-1.16,-3.34,-5.09,-8.72,-11.97,-11.94,-11.47,-12.66,-14.78,-14.0,-11.31,-9.56,-8.78,-6.22,-2.03,1.28,2.03,2.94,5.78,7.88,6.81,5.16,5.34,5.84,4.16,1.69,0.62,1.06,0.25,-2.12,-3.09,-1.25,-0.03,-0.69,-1.84,-1.16,-1.03,-3.78,-7.06,-7.72,-6.22,-5.91,-6.06,-4.03,-0.19,2.09,1.91,2.66,5.34,6.91,6.19,5.22,6.03,6.34,3.72,-0.22,-1.78,-2.66,-4.28,-7.16,-7.34,-5.66,-5.06,-6.91,-7.84,-7.12,-7.16,-9.09,-10.5,-8.56,-4.94,-3.12,-1.88,0.91,4.38,5.56,4.47,4.91,7.09,7.88,6.22,5.03,5.84,6.31,4.72,3.09,3.94,5.97,5.28,4.0,4.59,6.75,7.34,6.5,6.62,8.78,9.91,8.88,8.22,9.66,10.78,9.75,8.03,9.16,11.44,11.75,10.5,10.5,10.81,9.12,5.06,2.03,1.56,0.97,-1.22,-2.31,-0.41,2.0,2.72,2.72,4.41,6.38,5.84,3.34,1.88,2.09,1.25,-1.12,-2.0,-0.06,1.47,0.91,0.34,1.88,4.25,4.34,3.81,5.56,8.44,8.91,8.0,7.84,9.47,9.38,7.0,5.56,6.47,6.91,5.22,3.75,4.41,5.56,4.94,3.28,3.88,5.75,6.22,5.28,5.25,6.75,7.47,5.41,3.91,4.56,5.19,3.72,1.94,2.91,4.81,5.16,5.06,6.56,9.56,11.28,11.22,11.88,13.69,1.19,1.06,-0.16,0.12,1.91,3.69,4.88,6.62,9.47,11.56,11.03,10.0,10.0,9.44:11.56,11.84,9.62,7.66,7.88,8.19,6.66,5.88,7.75,10.38,10.31,8.97,9.03,9.38,7.78,4.19,2.03,1.91,1.56,-0.56,-1.66,-0.5,-0.03,-2.03,-4.59,-4.62,-3.69,-5.03,-7.0,-6.94,-5.91,-6.91,-9.66,-11.19,-10.59,-10.5,-11.38,-10.81,-7.5,-3.94,-2.34,-1.69,1.12,4.56,5.66,5.59,7.69,11.34,14.12,14.84,16.31,19.22,20.31,18.09,15.53,14.78,13.44,10.47,7.5,6.91,7.66,7.19,5.5,5.81,7.78,9.22,8.59,9.06,11.47,12.91,11.41,9.44,9.12,8.53,5.12,0.84,-1.09,-2.53,-5.28,-9.5,-12.22,-13.03,-14.44,-16.94,-17.22,-13.56,-9.0,-5.78,-2.12,3.5,9.19,12.25,14.19,17.41,21.41,23.41,23.22,23.25,24.5,23.53,19.38,15.25,12.88,9.97,5.03,-0.19,-3.09,-5.19,-8.41,-11.59,-11.41,-9.25,-7.16,-6.06,-3.22,1.59,6.38,9.53,13.31,19.25,24.47,26.75,27.53,28.88,29.34,26.12,20.22,15.25,11.31,6.84,1.75,-0.88,-0.59,-0.25,-1.88,-2.56,-0.44,2.16,3.25,3.88,6.69,10.72,12.81,14.09,17.22,21.5,23.88,23.34,22.66,22.78,21.62,17.5,13.5,12.19,11.84,10.0,8.16,8.56,10.53,10.59,9.44,10.12,11.97,13.09,12.31,12.91,16.28,19.72,20.62,21.31,23.59,24.81,23.12,20.19,19.09,18.66,16.94,13.81,11.94,11.56,9.97,5.81,2.5,1.88,1.84,1.19,2.38,7.5,13.66,17.91,20.34,22.97,24.81,24.19,21.34,19.41,18.91,18.5,16.09,14.53,15.34,16.62,15.62,14.72,15.88,17.88,18.03,16.53,15.72,14.88,11.91,6.84,3.41,2.94,2.91,1.34,0.75,2.06,3.22,1.5,-0.69,-1.09,-0.47,-1.31,-2.06,-0.47,3.31,6.22,7.59,9.19,12.5,15.06,15.19,15.53,18.09,20.66,20.34,18.88,18.66,18.62,17.09,13.94,12.59,13.41,13.53,12.19,11.69,13.28,13.94,12.06,9.97,10.0,10.84,9.94,8.88,10.44,13.19,14.53,14.12,14.81,16.12,16.59,14.25,12.53,12.62,12.59,10.19,8.09,8.38,9.62,9.22,8.31,8.66,10.44,10.75,9.75,9.97,12.28,14.0,13.47,12.94,13.69,14.09,11.38,8.28,7.34,7.38,5.94,4.03,4.0,5.38,5.72,4.09,3.25,4.31,5.19,4.03,3.12,4.34,5.91,4.53,2.84,3.09,4.38,4.28,3.25,4.03,6.34,7.62,6.91,7.16,9.59,11.09,9.88,8.97,9.97,10.88,9.69,8.12,8.09,9.53,9.41,8.72,9.72,12.47,14.0,13.16,12.81,13.81,14.38,12.94,11.5,12.75,14.38,13.78,12.25,11.94,12.44,10.91,8.34,7.16,7.97,8.34,7.25,7.09,9.25,11.66,12.16,13.03,15.91,19.75,21.03,21.12,22.06,23.88,23.59,21.81,20.44,20.78,20.25,17.91,16.06,16.19,16.56,14.31,12.09,12.09,13.19,13.12,12.41,13.41,15.91,16.88,16.34,15.91,17.19,17.5,15.59,14.25,14.91,16.31,15.53,13.94,14.34,15.47,14.28,11.53,9.91,9.69,8.56,6.41,6.12,8.38,11.06,11.59,12.12,14.28,16.81,16.59,15.31,15.41,17.06,16.84,15.81,16.28,18.41,19.44,18.53,17.72,19.06,19.84,18.47,16.78,17.91,20.25,20.53,19.81,20.03,20.69,18.03,13.19,9.31,7.81,6.25,4.22,3.44,5.12,6.56,5.91,4.56,4.62,5.62,5.22,3.84,4.5,7.44,9.47,10.09,11.88,15.19,17.38,16.41,15.22,15.81,16.28,14.72,12.56,12.06,12.34,10.88,8.16,6.69,7.19,6.75,5.0,4.62,7.0,9.06,9.16,8.56,9.41,10.06,8.03,5.06,4.66,5.62,4.69,3.69,4.25,6.84,9.06,9.72,10.97,13.97,16.16,15.41,14.25,14.66,15.31,13.84,11.38,10.28,10.09,8.31,5.53,3.94,4.47,4.53,3.59,3.91,7.34,10.91,12.62,13.28,15.34,17.09,16.84,15.03,14.75,16.0,16.38,15.28,15.03,16.56,16.84,14.59,12.47,12.88,13.09,11.69,10.0,10.38,11.41,10.94,9.0,8.47,9.19,9.25,8.44,9.25,12.44,15.16,15.19,14.75,15.78,16.84,15.59,13.62,13.28,13.75,12.47,10.31,10.16,12.16,13.94,14.69,15.94,19.28,21.75,21.06,19.06,19.25,19.06,16.97,14.22,13.31,13.84,13.47,11.78,12.0,14.31,15.28,13.88,12.34,13.0,13.19,11.41,9.84,10.38,11.66,11.25,9.88,10.44,12.03,12.69,12.0,12.56,15.06,17.12,16.84,17.25,19.84,22.44,22.5,21.75,22.41,23.28,21.66,18.5,16.41,15.47,13.5,9.75,7.41,7.56,7.62,6.0,4.66,6.56,8.38,8.0,6.78,7.38,8.66,8.41,7.56,8.25,10.75,12.28,11.38,11.12,12.59,13.12,11.16,8.31,8.12,8.59,7.44,5.56,6.0,6.84,5.0,1.62,-0.25,0.25,0.53,-0.03,0.22,2.88,6.06,7.12,7.91,11.03,13.91,13.66,11.91,11.47,12.03,11.66,10.19,10.56,12.38,13.81,12.94,12.56,14.16,16.06,16.0,15.12,16.75,18.84,19.34,18.69,19.69,21.31,21.72,20.28,20.38,22.16,23.75,22.91,21.66,22.03,22.28,19.84,16.53,15.5,16.0,14.72,12.81,12.94,14.53,14.75,13.75,12.94,13.94,14.53,12.41,10.62,11.16,12.19,11.44,9.88,10.25,11.62,11.75,10.84,11.72,14.22,15.84,14.97,14.75,16.53,18.03,17.19,16.06,16.53,16.88,15.0,11.72,10.41,10.28,9.25,7.25,7.0,8.59,9.97,8.97,8.56,9.94,10.81,8.84,6.22,5.22,5.5,4.25,2.69,3.78,7.06,8.88,8.97,10.12,12.41,13.69,12.28,11.03,11.59,12.41,10.5,8.38,8.5,9.44,8.78,6.62,5.97,6.16,4.84,1.62,-0.03,1.0,1.59,1.09,0.91,3.44,5.75,5.56,4.44,5.0,6.5,6.53,5.5,6.62,9.34,11.06,10.91,11.28,13.5,14.75,13.06,11.03,10.5,10.22,7.66,4.5,3.94,5.25,5.69,5.22,6.41,8.72,9.69,7.5,5.66,6.12,7.31,7.34,8.22,11.47,15.0,15.66,14.0,13.06,13.12,11.47,9.22,8.69,10.94,13.41,13.44,13.72,15.44,16.62,14.53,11.53,10.5,10.78,9.38,7.0,6.5,7.25,6.38,3.72,2.59,4.38,6.25,6.75,7.81,11.22,14.34,14.56,12.78,12.56,12.38,10.78,8.62,8.53,11.5,13.81,13.88,14.38,15.72,16.06,13.03,10.12,9.03,8.78,5.88,2.41,0.78,0.69,-0.03,-1.56,-1.28,1.16,2.12,0.84,-0.16,1.28,3.22,3.34,4.53,8.38,13.03,14.88,14.97,14.97,15.03,12.0,6.81,2.72,1.53,0.34,-1.81,-2.31,0.66,4.25,6.19,8.31,12.31,16.5,17.22,15.38,13.5,11.94,8.84,3.78,0.03,-1.28,-2.66,-5.75,-7.28,-5.69,-3.03,-2.25,-1.53,1.0,4.28,5.44,4.75,5.47,6.94,6.94,4.62,2.94,3.31,3.78,2.09,0.94,1.69,2.38,0.19,-3.03,-4.25,-3.88,-4.34,-4.97,-3.69,-0.09,2.66,3.5,4.53,7.69,9.62,8.34,5.5,3.59,1.69,-3.44,-9.84,-14.31,-17.03,-20.34,-23.88,-24.47,-21.94,-19.53,-19.34,-19.28,-16.88,-14.56,-14.16,-12.75,-8.03,-2.22,1.84,5.06,9.81,15.59,19.12,19.72,19.66,19.5,17.5,12.25,7.06,4.0,1.06,-4.25,-10.34,-14.06,-16.0,-18.84,-21.22,-20.84,-17.09,-13.91,-11.56,-8.81,-3.47,0.75,2.12,2.41,4.19,5.0,3.12,0.41,0.16,2.22,3.09,3.34,4.59,6.91,6.53,2.81,-1.16,-3.34,-5.09,-8.72,-11.97,-11.94,-11.47,-12.66,-14.78,-14.0,-11.31,-9.56,-8.78,-6.22,-2.03,1.28,2.03,2.94,5.78,7.88,6.81,5.16,5.34,5.84,4.16,1.69,0.62,1.06,0.25,-2.12,-3.09,-1.25,-0.03,-0.69,-1.84,-1.16,-1.03,-3.78,-7.06,-7.72,-6.22,-5.91,-6.06,-4.03,-0.19,2.09,1.91,2.66,5.34,6.91,6.19,5.22,6.03,6.34,3.72,-0.22,-1.78,-2.66,-4.28,-7.16,-7.34,-5.66,-5.06,-6.91,-7.84,-7.12,-7.16,-9.09,-10.5,-8.56,-4.94,-3.12,-1.88,0.91,4.38,5.56,4.47,4.91,7.09,7.88,6.22,5.03,5.84,6.31,4.72,3.09,3.94,5.97,5.28,4.0,4.59,6.75,7.34,6.5,6.62,8.78,9.91,8.88,8.22,9.66,10.78,9.75,8.03,9.16,11.44,11.75,10.5,10.5,10.81,9.12,5.06,2.03,1.56,0.97,-1.22,-2.31,-0.41,2.0,2.72,2.72,4.41,6.38,5.84,3.34,1.88,2.09,1.25,-1.12,-2.0,-0.06,1.47,0.91,0.34,1.88,4.25,4.34,3.81,5.56,8.44,8.91,8.0,7.84,9.47,9.38,7.0,5.56,6.47,6.91,5.22,3.75,4.41,5.56,4.94,3.28,3.88,5.75,6.22,5.28,5.25,6.75,7.47,5.41,3.91,4.56,5.19,3.72,1.94,2.91,4.81,5.16,5.06,6.56,9.56,11.28,11.22,11.88,13.69,1.19,1.06,-0.16,0.12,1.91,3.69,4.88,6.62,9.47,11.56,11.03,10.0,10.0,9.44,7.31,4.78,3.66,3.72,3.53,3.06,4.0:5.88,7.75,10.38,10.31,8.97,9.03,9.38,7.78,4.19,2.03,1.91,1.56,-0.56,-1.66,-0.5,-0.03,-2.03,-4.59,-4.62,-3.69,-5.03,-7.0,-6.94,-5.91,-6.91,-9.66,-11.19,-10.59,-10.5,-11.38,-10.81,-7.5,-3.94,-2.34,-1.69,1.12,4.56,5.66,5.59,7.69,11.34,14.12,14.84,16.31,19.22,20.31,18.09,15.53,14.78,13.44,10.47,7.5,6.91,7.66,7.19,5.5,5.81,7.78,9.22,8.59,9.06,11.47,12.91,11.41,9.44,9.12,8.53,5.12,0.84,-1.09,-2.53,-5.28,-9.5,-12.22,-13.03,-14.44,-16.94,-17.22,-13.56,-9.0,-5.78,-2.12,3.5,9.19,12.25,14.19,17.41,21.41,23.41,23.22,23.25,24.5,23.53,19.38,15.25,12.88,9.97,5.03,-0.19,-3.09,-5.19,-8.41,-11.59,-11.41,-9.25,-7.16,-6.06,-3.22,1.59,6.38,9.53,13.31,19.25,24.47,26.75,27.53,28.88,29.34,26.12,20.22,15.25,11.31,6.84,1.75,-0.88,-0.59,-0.25,-1.88,-2.56,-0.44,2.16,3.25,3.88,6.69,10.72,12.81,14.09,17.22,21.5,23.88,23.34,22.66,22.78,21.62,17.5,13.5,12.19,11.84,10.0,8.16,8.56,10.53,10.59,9.44,10.12,11.97,13.09,12.31,12.91,16.28,19.72,20.62,21.31,23.59,24.81,23.12,20.19,19.09,18.66,16.94,13.81,11.94,11.56,9.97,5.81,2.5,1.88,1.84,1.19,2.38,7.5,13.66,17.91,20.34,22.97,24.81,24.19,21.34,19.41,18.91,18.5,16.09,14.53,15.34,16.62,15.62,14.72,15.88,17.88,18.03,16.53,15.72,14.88,11.91,6.84,3.41,2.94,2.91,1.34,0.75,2.06,3.22,1.5,-0.69,-1.09,-0.47,-1.31,-2.06,-0.47,3.31,6.22,7.59,9.19,12.5,15.06,15.19,15.53,18.09,20.66,20.34,18.88,18.66,18.62,17.09,13.94,12.59,13.41,13.53,12.19,11.69,13.28,13.94,12.06,9.97,10.0,10.84,9.94,8.88,10.44,13.19,14.53,14.12,14.81,16.12,16.59,14.25,12.53,12.62,12.59,10.19,8.09,8.38,9.62,9.22,8.31,8.66,10.44,10.75,9.75,9.97,12.28,14.0,13.47,12.94,13.69,14.09,11.38,8.28,7.34,7.38,5.94,4.03,4.0,5.38,5.72,4.09,3.25,4.31,5.19,4.03,3.12,4.34,5.91,4.53,2.84,3.09,4.38,4.28,3.25,4.03,6.34,7.62,6.91,7.16,9.59,11.09,9.88,8.97,9.97,10.88,9.69,8.12,8.09,9.53,9.41,8.72,9.72,12.47,14.0,13.16,12.81,13.81,14.38,12.94,11.5,12.75,14.38,13.78,12.25,11.94,12.44,10.91,8.34,7.16,7.97,8.34,7.25,7.09,9.25,11.66,12.16,13.03,15.91,19.75,21.03,21.12,22.06,23.88,23.59,21.81,20.44,20.78,20.25,17.91,16.06,16.19,16.56,14.31,12.09,12.09,13.19,13.12,12.41,13.41,15.91,16.88,16.34,15.91,17.19,17.5,15.59,14.25,14.91,16.31,15.53,13.94,14.34,15.47,14.28,11.53,9.91,9.69,8.56,6.41,6.12,8.38,11.06,11.59,12.12,14.28,16.81,16.59,15.31,15.41,17.06,16.84,15.81,16.28,18.41,19.44,18.53,17.72,19.06,19.84,18.47,16.78,17.91,20.25,20.53,19.81,20.03,20.69,18.03,13.19,9.31,7.81,6.25,4.22,3.44,5.12,6.56,5.91,4.56,4.62,5.62,5.22,3.84,4.5,7.44,9.47,10.09,11.88,15.19,17.38,16.41,15.22,15.81,16.28,14.72,12.56,12.06,12.34,10.88,8.16,6.69,7.19,6.75,5.0,4.62,7.0,9.06,9.16,8.56,9.41,10.06,8.03,5.06,4.66,5.62,4.69,3.69,4.25,6.84,9.06,9.72,10.97,13.97,16.16,15.41,14.25,14.66,15.31,13.84,11.38,10.28,10.09,8.31,5.53,3.94,4.47,4.53,3.59,3.91,7.34,10.91,12.62,13.28,15.34,17.09,16.84,15.03,14.75,16.0,16.38,15.28,15.03,16.56,16.84,14.59,12.47,12.88,13.09,11.69,10.0,10.38,11.41,10.94,9.0,8.47,9.19,9.25,8.44,9.25,12.44,15.16,15.19,14.75,15.78,16.84,15.59,13.62,13.28,13.75,12.47,10.31,10.16,12.16,13.94,14.69,15.94,19.28,21.75,21.06,19.06,19.25,19.06,16.97,14.22,13.31,13.84,13.47,11.78,12.0,14.31,15.28,13.88,12.34,13.0,13.19,11.41,9.84,10.38,11.66,11.25,9.88,10.44,12.03,12.69,12.0,12.56,15.06,17.12,16.84,17.25,19.84,22.44,22.5,21.75,22.41,23.28,21.66,18.5,16.41,15.47,13.5,9.75,7.41,7.56,7.62,6.0,4.66,6.56,8.38,8.0,6.78,7.38,8.66,8.41,7.56,8.25,10.75,12.28,11.38,11.12,12.59,13.12,11.16,8.31,8.12,8.59,7.44,5.56,6.0,6.84,5.0,1.62,-0.25,0.25,0.53,-0.03,0.22,2.88,6.06,7.12,7.91,11.03,13.91,13.66,11.91,11.47,12.03,11.66,10.19,10.56,12.38,13.81,12.94,12.56,14.16,16.06,16.0,15.12,16.75,18.84,19.34,18.69,19.69,21.31,21.72,20.28,20.38,22.16,23.75,22.91,21.66,22.03,22.28,19.84,16.53,15.5,16.0,14.72,12.81,12.94,14.53,14.75,13.75,12.94,13.94,14.53,12.41,10.62,11.16,12.19,11.44,9.88,10.25,11.62,11.75,10.84,11.72,14.22,15.84,14.97,14.75,16.53,18.03,17.19,16.06,16.53,16.88,15.0,11.72,10.41,10.28,9.25,7.25,7.0,8.59,9.97,8.97,8.56,9.94,10.81,8.84,6.22,5.22,5.5,4.25,2.69,3.78,7.06,8.88,8.97,10.12,12.41,13.69,12.28,11.03,11.59,12.41,10.5,8.38,8.5,9.44,8.78,6.62,5.97,6.16,4.84,1.62,-0.03,1.0,1.59,1.09,0.91,3.44,5.75,5.56,4.44,5.0,6.5,6.53,5.5,6.62,9.34,11.06,10.91,11.28,13.5,14.75,13.06,11.03,10.5,10.22,7.66,4.5,3.94,5.25,5.69,5.22,6.41,8.72,9.69,7.5,5.66,6.12,7.31,7.34,8.22,11.47,15.0,15.66,14.0,13.06,13.12,11.47,9.22,8.69,10.94,13.41,13.44,13.72,15.44,16.62,14.53,11.53,10.5,10.78,9.38,7.0,6.5,7.25,6.38,3.72,2.59,4.38,6.25,6.75,7.81,11.22,14.34,14.56,12.78,12.56,12.38,10.78,8.62,8.53,11.5,13.81,13.88,14.38,15.72,16.06,13.03,10.12,9.03,8.78,5.88,2.41,0.78,0.69,-0.03,-1.56,-1.28,1.16,2.12,0.84,-0.16,1.28,3.22,3.34,4.53,8.38,13.03,14.88,14.97,14.97,15.03,12.0,6.81,2.72,1.53,0.34,-1.81,-2.31,0.66,4.25,6.19,8.31,12.31,16.5,17.22,15.38,13.5,11.94,8.84,3.78,0.03,-1.28,-2.66,-5.75,-7.28,-5.69,-3.03,-2.25,-1.53,1.0,4.28,5.44,4.75,5.47,6.94,6.94,4.62,2.94,3.31,3.78,2.09,0.94,1.69,2.38,0.19,-3.03,-4.25,-3.88,-4.34,-4.97,-3.69,-0.09,2.66,3.5,4.53,7.69,9.62,8.34,5.5,3.59,1.69,-3.44,-9.84,-14.31,-17.03,-20.34,-23.88,-24.47,-21.94,-19.53,-19.34,-19.28,-16.88,-14.56,-14.16,-12.75,-8.03,-2.22,1.84,5.06,9.81,15.59,19.12,19.72,19.66,19.5,17.5,12.25,7.06,4.0,1.06,-4.25,-10.34,-14.06,-16.0,-18.84,-21.22,-20.84,-17.09,-13.91,-11.56,-8.81,-3.47,0.75,2.12,2.41,4.19,5.0,3.12,0.41,0.16,2.22,3.09,3.34,4.59,6.91,6.53,2.81,-1.16,-3.34,-5.09,-8.72,-11.97,-11.94,-11.47,-12.66,-14.78,-14.0,-11.31,-9.56,-8.78,-6.22,-2.03,1.28,2.03,2.94,5.78,7.88,6.81,5.16,5.34,5.84,4.16,1.69,0.62,1.06,0.25,-2.12,-3.09,-1.25,-0.03,-0.69,-1.84,-1.16,-1.03,-3.78,-7.06,-7.72,-6.22,-5.91,-6.06,-4.03,-0.19,2.09,1.91,2.66,5.34,6.91,6.19,5.22,6.03,6.34,3.72,-0.22,-1.78,-2.66,-4.28,-7.16,-7.34,-5.66,-5.06,-6.91,-7.84,-7.12,-7.16,-9.09,-10.5,-8.56,-4.94,-3.12,-1.88,0.91,4.38,5.56,4.47,4.91,7.09,7.88,6.22,5.03,5.84,6.31,4.72,3.09,3.94,5.97,5.28,4.0,4.59,6.75,7.34,6.5,6.62,8.78,9.91,8.88,8.22,9.66,10.78,9.75,8.03,9.16,11.44,11.75,10.5,10.5,10.81,9.12,5.06,2.03,1.56,0.97,-1.22,-2.31,-0.41,2.0,2.72,2.72,4.41,6.38,5.84,3.34,1.88,2.09,1.25,-1.12,-2.0,-0.06,1.47,0.91,0.34,1.88,4.25,4.34,3.81,5.56,8.44,8.91,8.0,7.84,9.47,9.38,7.0,5.56,6.47,6.91,5.22,3.75,4.41,5.56,4.94,3.28,3.88,5.75,6.22,5.28,5.25,6.75,7.47,5.41,3.91,4.56,5.19,3.72,1.94,2.91,4.81,5.16,5.06,6.56,9.56,11.28,11.22,11.88,13.69,1.19,1.06,-0.16,0.12,1.91,3.69,4.88,6.62,9.47,11.56,11.03,10.0,10.0,9.44,7.31,4.78,3.66,3.72,3.53,3.06,4.0,5.91,6.94,6.31,5.53,6.5,7.31,7.31:7.78,4.19,2.03,1.91,1.56,-0.56,-1.66,-0.5,-0.03,-2.03,-4.59,-4.62,-3.69,-5.03,-7.0,-6.94,-5.91,-6.91,-9.66,-11.19,-10.59,-10.5,-11.38,-10.81,-7.5,-3.94,-2.34,-1.69,1.12,4.56,5.66,5.59,7.69,11.34,14.12,14.84,16.31,19.22,20.31,18.09,15.53,14.78,13.44,10.47,7.5,6.91,7.66,7.19,5.5,5.81,7.78,9.22,8.59,9.06,11.47,12.91,11.41,9.44,9.12,8.53,5.12,0.84,-1.09,-2.53,-5.28,-9.5,-12.22,-13.03,-14.44,-16.94,-17.22,-13.56,-9.0,-5.78,-2.12,3.5,9.19,12.25,14.19,17.41,21.41,23.41,23.22,23.25,24.5,23.53,19.38,15.25,12.88,9.97,5.03,-0.19,-3.09,-5.19,-8.41,-11.59,-11.41,-9.25,-7.16,-6.06,-3.22,1.59,6.38,9.53,13.31,19.25,24.47,26.75,27.53,28.88,29.34,26.12,20.22,15.25,11.31,6.84,1.75,-0.88,-0.59,-0.25,-1.88,-2.56,-0.44,2.16,3.25,3.88,6.69,10.72,12.81,14.09,17.22,21.5,23.88,23.34,22.66,22.78,21.62,17.5,13.5,12.19,11.84,10.0,8.16,8.56,10.53,10.59,9.44,10.12,11.97,13.09,12.31,12.91,16.28,19.72,20.62,21.31,23.59,24.81,23.12,20.19,19.09,18.66,16.94,13.81,11.94,11.56,9.97,5.81,2.5,1.88,1.84,1.19,2.38,7.5,13.66,17.91,20.34,22.97,24.81,24.19,21.34,19.41,18.91,18.5,16.09,14.53,15.34,16.62,15.62,14.72,15.88,17.88,18.03,16.53,15.72,14.88,11.91,6.84,3.41,2.94,2.91,1.34,0.75,2.06,3.22,1.5,-0.69,-1.09,-0.47,-1.31,-2.06,-0.47,3.31,6.22,7.59,9.19,12.5,15.06,15.19,15.53,18.09,20.66,20.34,18.88,18.66,18.62,17.09,13.94,12.59,13.41,13.53,12.19,11.69,13.28,13.94,12.06,9.97,10.0,10.84,9.94,8.88,10.44,13.19,14.53,14.12,14.81,16.12,16.59,14.25,12.53,12.62,12.59,10.19,8.09,8.38,9.62,9.22,8.31,8.66,10.44,10.75,9.75,9.97,12.28,14.0,13.47,12.94,13.69,14.09,11.38,8.28,7.34,7.38,5.94,4.03,4.0,5.38,5.72,4.09,3.25,4.31,5.19,4.03,3.12,4.34,5.91,4.53,2.84,3.09,4.38,4.28,3.25,4.03,6.34,7.62,6.91,7.16,9.59,11.09,9.88,8.97,9.97,10.88,9.69,8.12,8.09,9.53,9.41,8.72,9.72,12.47,14.0,13.16,12.81,13.81,14.38,12.94,11.5,12.75,14.38,13.78,12.25,11.94,12.44,10.91,8.34,7.16,7.97,8.34,7.25,7.09,9.25,11.66,12.16,13.03,15.91,19.75,21.03,21.12,22.06,23.88,23.59,21.81,20.44,20.78,20.25,17.91,16.06,16.19,16.56,14.31,12.09,12.09,13.19,13.12,12.41,13.41,15.91,16.88,16.34,15.91,17.19,17.5,15.59,14.25,14.91,16.31,15.53,13.94,14.34,15.47,14.28,11.53,9.91,9.69,8.56,6.41,6.12,8.38,11.06,11.59,12.12,14.28,16.81,16.59,15.31,15.41,17.06,16.84,15.81,16.28,18.41,19.44,18.53,17.72,19.06,19.84,18.47,16.78,17.91,20.25,20.53,19.81,20.03,20.69,18.03,13.19,9.31,7.81,6.25,4.22,3.44,5.12,6.56,5.91,4.56,4.62,5.62,5.22,3.84,4.5,7.44,9.47,10.09,11.88,15.19,17.38,16.41,15.22,15.81,16.28,14.72,12.56,12.06,12.34,10.88,8.16,6.69,7.19,6.75,5.0,4.62,7.0,9.06,9.16,8.56,9.41,10.06,8.03,5.06,4.66,5.62,4.69,3.69,4.25,6.84,9.06,9.72,10.97,13.97,16.16,15.41,14.25,14.66,15.31,13.84,11.38,10.28,10.09,8.31,5.53,3.94,4.47,4.53,3.59,3.91,7.34,10.91,12.62,13.28,15.34,17.09,16.84,15.03,14.75,16.0,16.38,15.28,15.03,16.56,16.84,14.59,12.47,12.88,13.09,11.69,10.0,10.38,11.41,10.94,9.0,8.47,9.19,9.25,8.44,9.25,12.44,15.16,15.19,14.75,15.78,16.84,15.59,13.62,13.28,13.75,12.47,10.31,10.16,12.16,13.94,14.69,15.94,19.28,21.75,21.06,19.06,19.25,19.06,16.97,14.22,13.31,13.84,13.47,11.78,12.0,14.31,15.28,13.88,12.34,13.0,13.19,11.41,9.84,10.38,11.66,11.25,9.88,10.44,12.03,12.69,12.0,12.56,15.06,17.12,16.84,17.25,19.84,22.44,22.5,21.75,22.41,23.28,21.66,18.5,16.41,15.47,13.5,9.75,7.41,7.56,7.62,6.0,4.66,6.56,8.38,8.0,6.78,7.38,8.66,8.41,7.56,8.25,10.75,12.28,11.38,11.12,12.59,13.12,11.16,8.31,8.12,8.59,7.44,5.56,6.0,6.84,5.0,1.62,-0.25,0.25,0.53,-0.03,0.22,2.88,6.06,7.12,7.91,11.03,13.91,13.66,11.91,11.47,12.03,11.66,10.19,10.56,12.38,13.81,12.94,12.56,14.16,16.06,16.0,15.12,16.75,18.84,19.34,18.69,19.69,21.31,21.72,20.28,20.38,22.16,23.75,22.91,21.66,22.03,22.28,19.84,16.53,15.5,16.0,14.72,12.81,12.94,14.53,14.75,13.75,12.94,13.94,14.53,12.41,10.62,11.16,12.19,11.44,9.88,10.25,11.62,11.75,10.84,11.72,14.22,15.84,14.97,14.75,16.53,18.03,17.19,16.06,16.53,16.88,15.0,11.72,10.41,10.28,9.25,7.25,7.0,8.59,9.97,8.97,8.56,9.94,10.81,8.84,6.22,5.22,5.5,4.25,2.69,3.78,7.06,8.88,8.97,10.12,12.41,13.69,12.28,11.03,11.59,12.41,10.5,8.38,8.5,9.44,8.78,6.62,5.97,6.16,4.84,1.62,-0.03,1.0,1.59,1.09,0.91,3.44,5.75,5.56,4.44,5.0,6.5,6.53,5.5,6.62,9.34,11.06,10.91,11.28,13.5,14.75,13.06,11.03,10.5,10.22,7.66,4.5,3.94,5.25,5.69,5.22,6.41,8.72,9.69,7.5,5.66,6.12,7.31,7.34,8.22,11.47,15.0,15.66,14.0,13.06,13.12,11.47,9.22,8.69,10.94,13.41,13.44,13.72,15.44,16.62,14.53,11.53,10.5,10.78,9.38,7.0,6.5,7.25,6.38,3.72,2.59,4.38,6.25,6.75,7.81,11.22,14.34,14.56,12.78,12.56,12.38,10.78,8.62,8.53,11.5,13.81,13.88,14.38,15.72,16.06,13.03,10.12,9.03,8.78,5.88,2.41,0.78,0.69,-0.03,-1.56,-1.28,1.16,2.12,0.84,-0.16,1.28,3.22,3.34,4.53,8.38,13.03,14.88,14.97,14.97,15.03,12.0,6.81,2.72,1.53,0.34,-1.81,-2.31,0.66,4.25,6.19,8.31,12.31,16.5,17.22,15.38,13.5,11.94,8.84,3.78,0.03,-1.28,-2.66,-5.75,-7.28,-5.69,-3.03,-2.25,-1.53,1.0,4.28,5.44,4.75,5.47,6.94,6.94,4.62,2.94,3.31,3.78,2.09,0.94,1.69,2.38,0.19,-3.03,-4.25,-3.88,-4.34,-4.97,-3.69,-0.09,2.66,3.5,4.53,7.69,9.62,8.34,5.5,3.59,1.69,-3.44,-9.84,-14.31,-17.03,-20.34,-23.88,-24.47,-21.94,-19.53,-19.34,-19.28,-16.88,-14.56,-14.16,-12.75,-8.03,-2.22,1.84,5.06,9.81,15.59,19.12,19.72,19.66,19.5,17.5,12.25,7.06,4.0,1.06,-4.25,-10.34,-14.06,-16.0,-18.84,-21.22,-20.84,-17.09,-13.91,-11.56,-8.81,-3.47,0.75,2.12,2.41,4.19,5.0,3.12,0.41,0.16,2.22,3.09,3.34,4.59,6.91,6.53,2.81,-1.16,-3.34,-5.09,-8.72,-11.97,-11.94,-11.47,-12.66,-14.78,-14.0,-11.31,-9.56,-8.78,-6.22,-2.03,1.28,2.03,2.94,5.78,7.88,6.81,5.16,5.34,5.84,4.16,1.69,0.62,1.06,0.25,-2.12,-3.09,-1.25,-0.03,-0.69,-1.84,-1.16,-1.03,-3.78,-7.06,-7.72,-6.22,-5.91,-6.06,-4.03,-0.19,2.09,1.91,2.66,5.34,6.91,6.19,5.22,6.03,6.34,3.72,-0.22,-1.78,-2.66,-4.28,-7.16,-7.34,-5.66,-5.06,-6.91,-7.84,-7.12,-7.16,-9.09,-10.5,-8.56,-4.94,-3.12,-1.88,0.91,4.38,5.56,4.47,4.91,7.09,7.88,6.22,5.03,5.84,6.31,4.72,3.09,3.94,5.97,5.28,4.0,4.59,6.75,7.34,6.5,6.62,8.78,9.91,8.88,8.22,9.66,10.78,9.75,8.03,9.16,11.44,11.75,10.5,10.5,10.81,9.12,5.06,2.03,1.56,0.97,-1.22,-2.31,-0.41,2.0,2.72,2.72,4.41,6.38,5.84,3.34,1.88,2.09,1.25,-1.12,-2.0,-0.06,1.47,0.91,0.34,1.88,4.25,4.34,3.81,5.56,8.44,8.91,8.0,7.84,9.47,9.38,7.0,5.56,6.47,6.91,5.22,3.75,4.41,5.56,4.94,3.28,3.88,5.75,6.22,5.28,5.25,6.75,7.47,5.41,3.91,4.56,5.19,3.72,1.94,2.91,4.81,5.16,5.06,6.56,9.56,11.28,11.22,11.88,13.69,1.19,1.06,-0.16,0.12,1.91,3.69,4.88,6.62,9.47,11.56,11.03,10.0,10.0,9.44,7.31,4.78,3.66,3.72,3.53,3.06,4.0,5.91,6.94,6.31,5.53,6.5,7.31,7.31,7.75,10.31,12.78,13.25,12.12,11.94,11.56:-0.5,-0.03,-2.03,-4.59,-4.62,-3.69,-5.03,-7.0,-6.94,-5.91,-6.91,-9.66,-11.19,-10.59,-10.5,-11.38,-10.81,-7.5,-3.94,-2.34,-1.69,1.12,4.56,5.66,5.59,7.69,11.34,14.12,14.84,16.31,19.22,20.31,18.09,15.53,14.78,13.44,10.47,7.5,6.91,7.66,7.19,5.5,5.81,7.78,9.22,8.59,9.06,11.47,12.91,11.41,9.44,9.12,8.53,5.12,0.84,-1.09,-2.53,-5.28,-9.5,-12.22,-13.03,-14.44,-16.94,-17.22,-13.56,-9.0,-5.78,-2.12,3.5,9.19,12.25,14.19,17.41,21.41,23.41,23.22,23.25,24.5,23.53,19.38,15.25,12.88,9.97,5.03,-0.19,-3.09,-5.19,-8.41,-11.59,-11.41,-9.25,-7.16,-6.06,-3.22,1.59,6.38,9.53,13.31,19.25,24.47,26.75,27.53,28.88,29.34,26.12,20.22,15.25,11.31,6.84,1.75,-0.88,-0.59,-0.25,-1.88,-2.56,-0.44,2.16,3.25,3.88,6.69,10.72,12.81,14.09,17.22,21.5,23.88,23.34,22.66,22.78,21.62,17.5,13.5,12.19,11.84,10.0,8.16,8.56,10.53,10.59,9.44,10.12,11.97,13.09,12.31,12.91,16.28,19.72,20.62,21.31,23.59,24.81,23.12,20.19,19.09,18.66,16.94,13.81,11.94,11.56,9.97,5.81,2.5,1.88,1.84,1.19,2.38,7.5,13.66,17.91,20.34,22.97,24.81,24.19,21.34,19.41,18.91,18.5,16.09,14.53,15.34,16.62,15.62,14.72,15.88,17.88,18.03,16.53,15.72,14.88,11.91,6.84,3.41,2.94,2.91,1.34,0.75,2.06,3.22,1.5,-0.69,-1.09,-0.47,-1.31,-2.06,-0.47,3.31,6.22,7.59,9.19,12.5,15.06,15.19,15.53,18.09,20.66,20.34,18.88,18.66,18.62,17.09,13.94,12.59,13.41,13.53,12.19,11.69,13.28,13.94,12.06,9.97,10.0,10.84,9.94,8.88,10.44,13.19,14.53,14.12,14.81,16.12,16.59,14.25,12.53,12.62,12.59,10.19,8.09,8.38,9.62,9.22,8.31,8.66,10.44,10.75,9.75,9.97,12.28,14.0,13.47,12.94,13.69,14.09,11.38,8.28,7.34,7.38,5.94,4.03,4.0,5.38,5.72,4.09,3.25,4.31,5.19,4.03,3.12,4.34,5.91,4.53,2.84,3.09,4.38,4.28,3.25,4.03,6.34,7.62,6.91,7.16,9.59,11.09,9.88,8.97,9.97,10.88,9.69,8.12,8.09,9.53,9.41,8.72,9.72,12.47,14.0,13.16,12.81,13.81,14.38,12.94,11.5,12.75,14.38,13.78,12.25,11.94,12.44,10.91,8.34,7.16,7.97,8.34,7.25,7.09,9.25,11.66,12.16,13.03,15.91,19.75,21.03,21.12,22.06,23.88,23.59,21.81,20.44,20.78,20.25,17.91,16.06,16.19,16.56,14.31,12.09,12.09,13.19,13.12,12.41,13.41,15.91,16.88,16.34,15.91,17.19,17.5,15.59,14.25,14.91,16.31,15.53,13.94,14.34,15.47,14.28,11.53,9.91,9.69,8.56,6.41,6.12,8.38,11.06,11.59,12.12,14.28,16.81,16.59,15.31,15.41,17.06,16.84,15.81,16.28,18.41,19.44,18.53,17.72,19.06,19.84,18.47,16.78,17.91,20.25,20.53,19.81,20.03,20.69,18.03,13.19,9.31,7.81,6.25,4.22,3.44,5.12,6.56,5.91,4.56,4.62,5.62,5.22,3.84,4.5,7.44,9.47,10.09,11.88,15.19,17.38,16.41,15.22,15.81,16.28,14.72,12.56,12.06,12.34,10.88,8.16,6.69,7.19,6.75,5.0,4.62,7.0,9.06,9.16,8.56,9.41,10.06,8.03,5.06,4.66,5.62,4.69,3.69,4.25,6.84,9.06,9.72,10.97,13.97,16.16,15.41,14.25,14.66,15.31,13.84,11.38,10.28,10.09,8.31,5.53,3.94,4.47,4.53,3.59,3.91,7.34,10.91,12.62,13.28,15.34,17.09,16.84,15.03,14.75,16.0,16.38,15.28,15.03,16.56,16.84,14.59,12.47,12.88,13.09,11.69,10.0,10.38,11.41,10.94,9.0,8.47,9.19,9.25,8.44,9.25,12.44,15.16,15.19,14.75,15.78,16.84,15.59,13.62,13.28,13.75,12.47,10.31,10.16,12.16,13.94,14.69,15.94,19.28,21.75,21.06,19.06,19.25,19.06,16.97,14.22,13.31,13.84,13.47,11.78,12.0,14.31,15.28,13.88,12.34,13.0,13.19,11.41,9.84,10.38,11.66,11.25,9.88,10.44,12.03,12.69,12.0,12.56,15.06,17.12,16.84,17.25,19.84,22.44,22.5,21.75,22.41,23.28,21.66,18.5,16.41,15.47,13.5,9.75,7.41,7.56,7.62,6.0,4.66,6.56,8.38,8.0,6.78,7.38,8.66,8.41,7.56,8.25,10.75,12.28,11.38,11.12,12.59,13.12,11.16,8.31,8.12,8.59,7.44,5.56,6.0,6.84,5.0,1.62,-0.25,0.25,0.53,-0.03,0.22,2.88,6.06,7.12,7.91,11.03,13.91,13.66,11.91,11.47,12.03,11.66,10.19,10.56,12.38,13.81,12.94,12.56,14.16,16.06,16.0,15.12,16.75,18.84,19.34,18.69,19.69,21.31,21.72,20.28,20.38,22.16,23.75,22.91,21.66,22.03,22.28,19.84,16.53,15.5,16.0,14.72,12.81,12.94,14.53,14.75,13.75,12.94,13.94,14.53,12.41,10.62,11.16,12.19,11.44,9.88,10.25,11.62,11.75,10.84,11.72,14.22,15.84,14.97,14.75,16.53,18.03,17.19,16.06,16.53,16.88,15.0,11.72,10.41,10.28,9.25,7.25,7.0,8.59,9.97,8.97,8.56,9.94,10.81,8.84,6.22,5.22,5.5,4.25,2.69,3.78,7.06,8.88,8.97,10.12,12.41,13.69,12.28,11.03,11.59,12.41,10.5,8.38,8.5,9.44,8.78,6.62,5.97,6.16,4.84,1.62,-0.03,1.0,1.59,1.09,0.91,3.44,5.75,5.56,4.44,5.0,6.5,6.53,5.5,6.62,9.34,11.06,10.91,11.28,13.5,14.75,13.06,11.03,10.5,10.22,7.66,4.5,3.94,5.25,5.69,5.22,6.41,8.72,9.69,7.5,5.66,6.12,7.31,7.34,8.22,11.47,15.0,15.66,14.0,13.06,13.12,11.47,9.22,8.69,10.94,13.41,13.44,13.72,15.44,16.62,14.53,11.53,10.5,10.78,9.38,7.0,6.5,7.25,6.38,3.72,2.59,4.38,6.25,6.75,7.81,11.22,14.34,14.56,12.78,12.56,12.38,10.78,8.62,8.53,11.5,13.81,13.88,14.38,15.72,16.06,13.03,10.12,9.03,8.78,5.88,2.41,0.78,0.69,-0.03,-1.56,-1.28,1.16,2.12,0.84,-0.16,1.28,3.22,3.34,4.53,8.38,13.03,14.88,14.97,14.97,15.03,12.0,6.81,2.72,1.53,0.34,-1.81,-2.31,0.66,4.25,6.19,8.31,12.31,16.5,17.22,15.38,13.5,11.94,8.84,3.78,0.03,-1.28,-2.66,-5.75,-7.28,-5.69,-3.03,-2.25,-1.53,1.0,4.28,5.44,4.75,5.47,6.94,6.94,4.62,2.94,3.31,3.78,2.09,0.94,1.69,2.38,0.19,-3.03,-4.25,-3.88,-4.34,-4.97,-3.69,-0.09,2.66,3.5,4.53,7.69,9.62,8.34,5.5,3.59,1.69,-3.44,-9.84,-14.31,-17.03,-20.34,-23.88,-24.47,-21.94,-19.53,-19.34,-19.28,-16.88,-14.56,-14.16,-12.75,-8.03,-2.22,1.84,5.06,9.81,15.59,19.12,19.72,19.66,19.5,17.5,12.25,7.06,4.0,1.06,-4.25,-10.34,-14.06,-16.0,-18.84,-21.22,-20.84,-17.09,-13.91,-11.56,-8.81,-3.47,0.75,2.12,2.41,4.19,5.0,3.12,0.41,0.16,2.22,3.09,3.34,4.59,6.91,6.53,2.81,-1.16,-3.34,-5.09,-8.72,-11.97,-11.94,-11.47,-12.66,-14.78,-14.0,-11.31,-9.56,-8.78,-6.22,-2.03,1.28,2.03,2.94,5.78,7.88,6.81,5.16,5.34,5.84,4.16,1.69,0.62,1.06,0.25,-2.12,-3.09,-1.25,-0.03,-0.69,-1.84,-1.16,-1.03,-3.78,-7.06,-7.72,-6.22,-5.91,-6.06,-4.03,-0.19,2.09,1.91,2.66,5.34,6.91,6.19,5.22,6.03,6.34,3.72,-0.22,-1.78,-2.66,-4.28,-7.16,-7.34,-5.66,-5.06,-6.91,-7.84,-7.12,-7.16,-9.09,-10.5,-8.56,-4.94,-3.12,-1.88,0.91,4.38,5.56,4.47,4.91,7.09,7.88,6.22,5.03,5.84,6.31,4.72,3.09,3.94,5.97,5.28,4.0,4.59,6.75,7.34,6.5,6.62,8.78,9.91,8.88,8.22,9.66,10.78,9.75,8.03,9.16,11.44,11.75,10.5,10.5,10.81,9.12,5.06,2.03,1.56,0.97,-1.22,-2.31,-0.41,2.0,2.72,2.72,4.41,6.38,5.84,3.34,1.88,2.09,1.25,-1.12,-2.0,-0.06,1.47,0.91,0.34,1.88,4.25,4.34,3.81,5.56,8.44,8.91,8.0,7.84,9.47,9.38,7.0,5.56,6.47,6.91,5.22,3.75,4.41,5.56,4.94,3.28,3.88,5.75,6.22,5.28,5.25,6.75,7.47,5.41,3.91,4.56,5.19,3.72,1.94,2.91,4.81,5.16,5.06,6.56,9.56,11.28,11.22,11.88,13.69,1.19,1.06,-0.16,0.12,1.91,3.69,4.88,6.62,9.47,11.56,11.03,10.0,10.0,9.44,7.31,4.78,3.66,3.72,3.53,3.06,4.0,5.91,6.94,6.31,5.53,6.5,7.31,7.31,7.75,10.31,12.78,13.25,12.12,11.94,11.56,9.5,6.25,4.06,2.94,1.97,-0.12,-1.19:negativity
41.25,41.25,41.59,43.44,46.09,47.62,48.0,48.81,50.19,51.22,50.0,49.28,49.78,50.34,50.16,49.84,50.62,52.22,51.75,50.0,49.66,50.12,49.47,47.72,46.78,47.53,48.09,47.56,47.88,49.38,50.34,49.12,47.0,45.62,44.53,42.19,39.53,37.78,38.03,37.47,36.28,35.97,37.28,38.59,38.78,39.06,40.91,42.72,42.44,41.56,42.06,43.47,43.84,43.53,45.0,48.06,50.28,51.41,52.91,55.03,56.88,56.06,55.31,55.97,56.97,55.72,53.41,51.88,50.94,48.84,45.5,43.88,44.5,44.75,44.0,44.25,46.78,49.12,49.56,50.03,51.28,52.62,51.75,49.56,48.31,47.91,46.28,43.56,41.66,41.84,42.09,41.19,41.62,44.41,47.72,48.94,49.91,50.84,51.41,49.69,46.62,44.69,44.25,43.12,40.81,39.09,39.0,38.62,36.62,35.22,35.47,36.09,34.97,33.69,34.12,35.47,36.19,36.22,38.0,41.47,44.56,46.72,48.66,51.84,54.19,54.62,54.53,55.75,56.94,55.56,53.09,51.5,49.97,47.03,43.06,40.06,38.5,36.94,34.03,32.44,33.0,34.31,34.41,34.69,36.44,38.75,39.25,39.16,40.19,42.41,43.25,43.03,43.06,44.31,44.84,43.53,42.72,43.81,44.84,44.56,43.75,43.81,44.0,42.28,39.72,37.75,37.34,36.25,34.0,32.84,33.0,32.56,30.75,29.59,31.22,33.75,35.31,36.31,38.31,40.78,40.59,40.09,40.47,41.88,41.84,40.41,39.28,39.22,39.28,38.19,37.25,38.16,39.16,38.47,37.06,37.19,37.72,36.53,34.25,32.16,31.62,30.31,28.69,28.66,31.44,34.38,36.06,37.59,40.16,42.94,43.66,43.22,44.03,45.09,44.59,43.38,43.47,44.94,45.72,45.25,44.59,45.44,45.16,43.31,41.19,40.56,40.47,39.41,37.56,37.34,38.0,37.5,36.53,36.31,37.91,38.84,38.72,38.72,40.06,41.69,41.38,40.88,41.47,42.69,42.41,41.69,41.94,42.91,42.66,41.03,40.03,40.53,40.78,39.78,39.41,41.38,43.5,44.0,43.94,44.84,45.75,44.88,42.75,41.78,42.25,41.78,40.22,39.47,40.72,41.25,40.5,40.16,41.47,43.09,43.16,42.38,42.72,43.47,42.94,41.25,40.59,41.25,41.19,39.66,38.25,38.59,38.75,37.91,37.12,39.09,42.03,43.75,45.0,47.22,49.66,50.22,48.78,47.69,47.62,46.5,44.56,43.25,44.38,45.84,46.28,46.41,47.75,48.88,48.0,45.38,43.97,43.69,43.25,41.97,42.12,43.19,43.75,42.06,40.47,40.28,40.44,39.5,38.25,38.88,40.44,40.84,40.16,40.47,41.19,40.41,37.91,36.03,35.78,35.53,34.25,33.5,34.44,35.62,35.06,33.53,33.62,34.66,35.09,34.53,35.53,37.5,38.72,37.81,37.38,38.03,38.47,37.25,36.44,38.0,40.19,41.19,41.5,43.03,44.88,45.78,45.25,45.81,46.75,46.75,44.72,42.41,41.72,40.88,39.19,37.22,37.19,37.44,36.28,34.0,33.0,32.88,32.44,31.06,30.84,32.69,34.06,33.88,33.91,35.56,36.91,36.81,36.59,38.41,40.62,41.5,41.69,42.44,43.62,44.16,42.91,42.16,42.78,42.62,41.19,39.91,40.91,41.97,41.56,40.34,40.47,41.03,40.53,38.72,38.22,38.66,37.66,34.88,32.59,31.88,31.0,28.88,27.75,29.12,31.09,32.25,32.81,34.94,37.22,38.44,37.88,38.19,38.94,38.75,36.5,34.75,34.91,35.16,34.38,33.88,35.25,37.03,37.22,36.81,37.88,39.56,40.41,40.34,41.81,44.56,46.56,46.69,46.28,46.34,45.41,42.06,38.16,36.0,34.66,32.59,31.03,32.12,34.47,35.94,36.44,37.22,39.12,40.88,41.09,41.0,42.25,43.0,41.66,39.81,39.56,39.78,38.62,36.25,35.53,36.16,36.91,36.53,37.06,39.16,40.5,39.88,39.38,40.16,40.88,39.53,37.59,36.62,36.5,35.56,33.81,33.72,34.72,35.25,34.31,34.09,35.09,35.5,34.22,32.69,33.28,34.22,34.25,34.31,35.41,37.22,37.16,36.09,36.12,37.25,37.97,37.12,36.75,37.19,37.75,36.16,34.78,35.16,35.91,35.12,33.88,34.06,35.66,35.97,35.56,35.75,37.22,37.66,36.72,36.5,37.53,38.28,37.41,36.19,35.88,36.44,35.28,33.34,32.5,32.28,31.19,29.16,28.69,30.47,32.59,32.97,33.47,34.62,35.69,34.06,31.72,30.97,30.53,28.38,25.41,23.75,23.0,21.59,19.06,17.66,17.47,17.5,16.25,16.25,17.84,21.16,23.09,24.69,27.47,30.0,30.84,30.12,29.81,30.72,30.91,29.59,29.06,29.97,30.94,30.25,29.69,30.69,32.0,31.84,31.19,31.53,32.56,32.38,31.75,32.09,33.56,34.75,34.78,34.97,36.94,39.12,40.0,40.97,43.19,45.91,46.44,46.38,46.34,46.22,44.47,40.97,38.28,36.84,34.81,31.72,29.19,28.38,27.75,26.22,25.03,25.28,26.59,26.72,26.31,27.31,29.5,30.62,30.88,31.53,33.28,35.28,35.19,35.19,36.44,37.59,36.72,35.59,35.53,35.94,35.0,33.38,32.78,33.53,33.78,33.41,33.59,35.09,36.53,36.12,35.88,36.81,38.06,37.69,36.88,36.97,37.38,36.28,33.88,32.53,32.25,31.38,29.25,27.97,28.53,28.91,28.16,27.78,28.91,30.41,30.75,30.72,31.56,33.06,32.72,30.97,29.34,28.69,27.22,24.44,22.84,22.91,23.31,22.88,22.47,23.97,26.41,27.88,29.25,31.69,35.28,38.03,39.88,42.41,46.47,49.0,49.25,48.59,47.88,46.44,42.97,39.44,37.25,36.53,34.91,34.0,34.72,37.19,39.09,40.03,41.09,43.12,44.53,43.66,42.66,42.56,42.12,40.19,38.03,37.47,38.34,38.44,38.22,39.09,41.0,41.84,41.38,40.56,41.0,40.56,38.75,36.62,36.47,36.75,35.91,34.31,33.72,33.53,31.97,29.38,28.0,28.19,27.97,26.16,25.0,25.69,26.41,26.12,26.19,28.0,30.25,30.88,30.78,31.66,32.75,32.75,31.78,31.47,32.47,33.19,33.03,33.38,35.66,37.16,36.78,35.56,35.0,34.16,32.31,29.56,28.25,28.19,27.84,27.09,27.19,29.25,30.75,30.59,30.16,31.41,32.5,32.5,32.34,32.72,34.16,34.12,33.19,33.31,35.19,36.53,36.69,37.5,39.06,39.88,38.69,36.81,36.38,36.31,35.16,33.91,34.0,34.88,34.56,32.69,31.44,31.59,31.38,30.0,29.5,30.97,32.28,32.34,32.25,33.78,35.44,35.91,35.88,37.06,38.97,39.5,38.81,38.22,38.78,38.41,36.78,35.66,36.28,36.91,36.34,35.78,36.81,38.31,38.94,38.91,40.16,42.41,43.75,43.38,43.19,43.97,43.78,42.16,40.75,41.19,41.47,40.28,38.34,37.91,37.84,37.5,37.03,38.0,40.22,41.31,41.09,41.22,42.34,43.16,42.47,42.16,43.06,43.84,42.59,40.81,39.94,39.41,38.5,36.97,37.0,38.56,39.62,40.09,40.62,42.75,44.22,43.75,42.88,43.06,43.09,42.16,40.84,41.06,42.38,42.75,42.75,43.41,45.12,46.22,45.62,45.25,45.88,46.0,44.16,41.75,40.34,39.19,37.16,35.22,35.16,36.84,38.28,38.75,39.72,40.97,41.19,39.69,38.06,38.47,39.12,38.81,38.0,38.66,39.88,39.91,39.16,40.03,41.62,42.12,41.28,40.59,40.75,40.03,37.66,35.22,34.03,33.19,31.62,30.25,31.22,33.47,35.59,36.88,39.47,42.25,44.41,44.59,44.97,46.16,46.5,45.31,43.66,43.97,45.0,45.03,44.75,45.38,46.25,45.41,42.84,41.25,40.94,40.19,38.16,36.81,36.75,36.84,36.03,35.47,37.12,38.91,39.41,39.0,39.38,40.09,39.56,38.16,38.06,38.91,39.31,38.09,37.47,37.94,38.34,37.19,36.0,36.47,37.25,36.91,35.59,35.53,35.56,34.66,31.94,30.09,29.53,29.09,28.0,27.78,29.69,32.38,33.81,34.56,36.78,38.91,39.38,38.44,38.62,39.69,40.19,39.69,40.06,41.53,42.38,41.56,40.06,40.12,40.38,39.19,38.0,38.44,39.94,40.81,40.66,41.03,41.69,41.44,39.75,38.78,39.47,40.34,39.5,38.53,37.97,37.41,35.34,32.84,31.94,32.38,32.38,32.09,33.25,35.22,36.62,36.44,36.75,38.06,39.62,39.5,38.91,39.25,39.38,37.81,35.75,34.97,35.41,35.16,33.84,33.81,34.88,36.06,36.44,37.5,40.22,43.38,44.78,45.84,48.19,50.59,51.09,50.12,49.84,49.94,48.69,46.28,44.72,44.75,45.0,44.03,43.47,44.09,44.47,42.47,39.75,38.31,37.81,36.53,34.88,34.75,35.66,35.69,34.5,34.44,36.28,37.84,38.09,38.34,39.62,40.75,40.0,39.03,39.69,41.38,41.81,41.59,42.38,43.91,44.62,43.78,43.34,44.44,45.34,44.66,44.03,44.22,44.34,42.62,40.56,40.22,41.38,41.5,40.62,40.69,41.22,41.09,39.75,39.41,41.0,42.25,41.84,41.16,41.31,41.78,40.38,38.38,37.44,37.28,35.91,33.12,31.94,32.19,32.41,31.53,31.31,32.81,34.78,35.03,35.47,37.16,39.28,39.47,38.91,39.28,41.03,41.81,41.47,41.66,42.81,43.25,41.84,40.78,41.0,41.97,41.22,39.88,40.38,40.97,40.56,39.62,39.41,40.41:48.81,50.19,51.22,50.0,49.28,49.78,50.34,50.16,49.84,50.62,52.22,51.75,50.0,49.66,50.12,49.47,47.72,46.78,47.53,48.09,47.56,47.88,49.38,50.34,49.12,47.0,45.62,44.53,42.19,39.53,37.78,38.03,37.47,36.28,35.97,37.28,38.59,38.78,39.06,40.91,42.72,42.44,41.56,42.06,43.47,43.84,43.53,45.0,48.06,50.28,51.41,52.91,55.03,56.88,56.06,55.31,55.97,56.97,55.72,53.41,51.88,50.94,48.84,45.5,43.88,44.5,44.75,44.0,44.25,46.78,49.12,49.56,50.03,51.28,52.62,51.75,49.56,48.31,47.91,46.28,43.56,41.66,41.84,42.09,41.19,41.62,44.41,47.72,48.94,49.91,50.84,51.41,49.69,46.62,44.69,44.25,43.12,40.81,39.09,39.0,38.62,36.62,35.22,35.47,36.09,34.97,33.69,34.12,35.47,36.19,36.22,38.0,41.47,44.56,46.72,48.66,51.84,54.19,54.62,54.53,55.75,56.94,55.56,53.09,51.5,49.97,47.03,43.06,40.06,38.5,36.94,34.03,32.44,33.0,34.31,34.41,34.69,36.44,38.75,39.25,39.16,40.19,42.41,43.25,43.03,43.06,44.31,44.84,43.53,42.72,43.81,44.84,44.56,43.75,43.81,44.0,42.28,39.72,37.75,37.34,36.25,34.0,32.84,33.0,32.56,30.75,29.59,31.22,33.75,35.31,36.31,38.31,40.78,40.59,40.09,40.47,41.88,41.84,40.41,39.28,39.22,39.28,38.19,37.25,38.16,39.16,38.47,37.06,37.19,37.72,36.53,34.25,32.16,31.62,30.31,28.69,28.66,31.44,34.38,36.06,37.59,40.16,42.94,43.66,43.22,44.03,45.09,44.59,43.38,43.47,44.94,45.72,45.25,44.59,45.44,45.16,43.31,41.19,40.56,40.47,39.41,37.56,37.34,38.0,37.5,36.53,36.31,37.91,38.84,38.72,38.72,40.06,41.69,41.38,40.88,41.47,42.69,42.41,41.69,41.94,42.91,42.66,41.03,40.03,40.53,40.78,39.78,39.41,41.38,43.5,44.0,43.94,44.84,45.75,44.88,42.75,41.78,42.25,41.78,40.22,39.47,40.72,41.25,40.5,40.16,41.47,43.09,43.16,42.38,42.72,43.47,42.94,41.25,40.59,41.25,41.19,39.66,38.25,38.59,38.75,37.91,37.12,39.09,42.03,43.75,45.0,47.22,49.66,50.22,48.78,47.69,47.62,46.5,44.56,43.25,44.38,45.84,46.28,46.41,47.75,48.88,48.0,45.38,43.97,43.69,43.25,41.97,42.12,43.19,43.75,42.06,40.47,40.28,40.44,39.5,38.25,38.88,40.44,40.84,40.16,40.47,41.19,40.41,37.91,36.03,35.78,35.53,34.25,33.5,34.44,35.62,35.06,33.53,33.62,34.66,35.09,34.53,35.53,37.5,38.72,37.81,37.38,38.03,38.47,37.25,36.44,38.0,40.19,41.19,41.5,43.03,44.88,45.78,45.25,45.81,46.75,46.75,44.72,42.41,41.72,40.88,39.19,37.22,37.19,37.44,36.28,34.0,33.0,32.88,32.44,31.06,30.84,32.69,34.06,33.88,33.91,35.56,36.91,36.81,36.59,38.41,40.62,41.5,41.69,42.44,43.62,44.16,42.91,42.16,42.78,42.62,41.19,39.91,40.91,41.97,41.56,40.34,40.47,41.03,40.53,38.72,38.22,38.66,37.66,34.88,32.59,31.88,31.0,28.88,27.75,29.12,31.09,32.25,32.81,34.94,37.22,38.44,37.88,38.19,38.94,38.75,36.5,34.75,34.91,35.16,34.38,33.88,35.25,37.03,37.22,36.81,37.88,39.56,40.41,40.34,41.81,44.56,46.56,46.69,46.28,46.34,45.41,42.06,38.16,36.0,34.66,32.59,31.03,32.12,34.47,35.94,36.44,37.22,39.12,40.88,41.09,41.0,42.25,43.0,41.66,39.81,39.56,39.78,38.62,36.25,35.53,36.16,36.91,36.53,37.06,39.16,40.5,39.88,39.38,40.16,40.88,39.53,37.59,36.62,36.5,35.56,33.81,33.72,34.72,35.25,34.31,34.09,35.09,35.5,34.22,32.69,33.28,34.22,34.25,34.31,35.41,37.22,37.16,36.09,36.12,37.25,37.97,37.12,36.75,37.19,37.75,36.16,34.78,35.16,35.91,35.12,33.88,34.06,35.66,35.97,35.56,35.75,37.22,37.66,36.72,36.5,37.53,38.28,37.41,36.19,35.88,36.44,35.28,33.34,32.5,32.28,31.19,29.16,28.69,30.47,32.59,32.97,33.47,34.62,35.69,34.06,31.72,30.97,30.53,28.38,25.41,23.75,23.0,21.59,19.06,17.66,17.47,17.5,16.25,16.25,17.84,21.16,23.09,24.69,27.47,30.0,30.84,30.12,29.81,30.72,30.91,29.59,29.06,29.97,30.94,30.25,29.69,30.69,32.0,31.84,31.19,31.53,32.56,32.38,31.75,32.09,33.56,34.75,34.78,34.97,36.94,39.12,40.0,40.97,43.19,45.91,46.44,46.38,46.34,46.22,44.47,40.97,38.28,36.84,34.81,31.72,29.19,28.38,27.75,26.22,25.03,25.28,26.59,26.72,26.31,27.31,29.5,30.62,30.88,31.53,33.28,35.28,35.19,35.19,36.44,37.59,36.72,35.59,35.53,35.94,35.0,33.38,32.78,33.53,33.78,33.41,33.59,35.09,36.53,36.12,35.88,36.81,38.06,37.69,36.88,36.97,37.38,36.28,33.88,32.53,32.25,31.38,29.25,27.97,28.53,28.91,28.16,27.78,28.91,30.41,30.75,30.72,31.56,33.06,32.72,30.97,29.34,28.69,27.22,24.44,22.84,22.91,23.31,22.88,22.47,23.97,26.41,27.88,29.25,31.69,35.28,38.03,39.88,42.41,46.47,49.0,49.25,48.59,47.88,46.44,42.97,39.44,37.25,36.53,34.91,34.0,34.72,37.19,39.09,40.03,41.09,43.12,44.53,43.66,42.66,42.56,42.12,40.19,38.03,37.47,38.34,38.44,38.22,39.09,41.0,41.84,41.38,40.56,41.0,40.56,38.75,36.62,36.47,36.75,35.91,34.31,33.72,33.53,31.97,29.38,28.0,28.19,27.97,26.16,25.0,25.69,26.41,26.12,26.19,28.0,30.25,30.88,30.78,31.66,32.75,32.75,31.78,31.47,32.47,33.19,33.03,33.38,35.66,37.16,36.78,35.56,35.0,34.16,32.31,29.56,28.25,28.19,27.84,27.09,27.19,29.25,30.75,30.59,30.16,31.41,32.5,32.5,32.34,32.72,34.16,34.12,33.19,33.31,35.19,36.53,36.69,37.5,39.06,39.88,38.69,36.81,36.38,36.31,35.16,33.91,34.0,34.88,34.56,32.69,31.44,31.59,31.38,30.0,29.5,30.97,32.28,32.34,32.25,33.78,35.44,35.91,35.88,37.06,38.97,39.5,38.81,38.22,38.78,38.41,36.78,35.66,36.28,36.91,36.34,35.78,36.81,38.31,38.94,38.91,40.16,42.41,43.75,43.38,43.19,43.97,43.78,42.16,40.75,41.19,41.47,40.28,38.34,37.91,37.84,37.5,37.03,38.0,40.22,41.31,41.09,41.22,42.34,43.16,42.47,42.16,43.06,43.84,42.59,40.81,39.94,39.41,38.5,36.97,37.0,38.56,39.62,40.09,40.62,42.75,44.22,43.75,42.88,43.06,43.09,42.16,40.84,41.06,42.38,42.75,42.75,43.41,45.12,46.22,45.62,45.25,45.88,46.0,44.16,41.75,40.34,39.19,37.16,35.22,35.16,36.84,38.28,38.75,39.72,40.97,41.19,39.69,38.06,38.47,39.12,38.81,38.0,38.66,39.88,39.91,39.16,40.03,41.62,42.12,41.28,40.59,40.75,40.03,37.66,35.22,34.03,33.19,31.62,30.25,31.22,33.47,35.59,36.88,39.47,42.25,44.41,44.59,44.97,46.16,46.5,45.31,43.66,43.97,45.0,45.03,44.75,45.38,46.25,45.41,42.84,41.25,40.94,40.19,38.16,36.81,36.75,36.84,36.03,35.47,37.12,38.91,39.41,39.0,39.38,40.09,39.56,38.16,38.06,38.91,39.31,38.09,37.47,37.94,38.34,37.19,36.0,36.47,37.25,36.91,35.59,35.53,35.56,34.66,31.94,30.09,29.53,29.09,28.0,27.78,29.69,32.38,33.81,34.56,36.78,38.91,39.38,38.44,38.62,39.69,40.19,39.69,40.06,41.53,42.38,41.56,40.06,40.12,40.38,39.19,38.0,38.44,39.94,40.81,40.66,41.03,41.69,41.44,39.75,38.78,39.47,40.34,39.5,38.53,37.97,37.41,35.34,32.84,31.94,32.38,32.38,32.09,33.25,35.22,36.62,36.44,36.75,38.06,39.62,39.5,38.91,39.25,39.38,37.81,35.75,34.97,35.41,35.16,33.84,33.81,34.88,36.06,36.44,37.5,40.22,43.38,44.78,45.84,48.19,50.59,51.09,50.12,49.84,49.94,48.69,46.28,44.72,44.75,45.0,44.03,43.47,44.09,44.47,42.47,39.75,38.31,37.81,36.53,34.88,34.75,35.66,35.69,34.5,34.44,36.28,37.84,38.09,38.34,39.62,40.75,40.0,39.03,39.69,41.38,41.81,41.59,42.38,43.91,44.62,43.78,43.34,44.44,45.34,44.66,44.03,44.22,44.34,42.62,40.56,40.22,41.38,41.5,40.62,40.69,41.22,41.09,39.75,39.41,41.0,42.25,41.84,41.16,41.31,41.78,40.38,38.38,37.44,37.28,35.91,33.12,31.94,32.19,32.41,31.53,31.31,32.81,34.78,35.03,35.47,37.16,39.28,39.47,38.91,39.28,41.03,41.81,41.47,41.66,42.81,43.25,41.84,40.78,41.0,41.97,41.22,39.88,40.38,40.97,40.56,39.62,39.41,40.41,71.62,72.84,74.44,76.34,78.03,79.97,81.12:50.16,49.84,50.62,52.22,51.75,50.0,49.66,50.12,49.47,47.72,46.78,47.53,48.09,47.56,47.88,49.38,50.34,49.12,47.0,45.62,44.53,42.19,39.53,37.78,38.03,37.47,36.28,35.97,37.28,38.59,38.78,39.06,40.91,42.72,42.44,41.56,42.06,43.47,43.84,43.53,45.0,48.06,50.28,51.41,52.91,55.03,56.88,56.06,55.31,55.97,56.97,55.72,53.41,51.88,50.94,48.84,45.5,43.88,44.5,44.75,44.0,44.25,46.78,49.12,49.56,50.03,51.28,52.62,51.75,49.56,48.31,47.91,46.28,43.56,41.66,41.84,42.09,41.19,41.62,44.41,47.72,48.94,49.91,50.84,51.41,49.69,46.62,44.69,44.25,43.12,40.81,39.09,39.0,38.62,36.62,35.22,35.47,36.09,34.97,33.69,34.12,35.47,36.19,36.22,38.0,41.47,44.56,46.72,48.66,51.84,54.19,54.62,54.53,55.75,56.94,55.56,53.09,51.5,49.97,47.03,43.06,40.06,38.5,36.94,34.03,32.44,33.0,34.31,34.41,34.69,36.44,38.75,39.25,39.16,40.19,42.41,43.25,43.03,43.06,44.31,44.84,43.53,42.72,43.81,44.84,44.56,43.75,43.81,44.0,42.28,39.72,37.75,37.34,36.25,34.0,32.84,33.0,32.56,30.75,29.59,31.22,33.75,35.31,36.31,38.31,40.78,40.59,40.09,40.47,41.88,41.84,40.41,39.28,39.22,39.28,38.19,37.25,38.16,39.16,38.47,37.06,37.19,37.72,36.53,34.25,32.16,31.62,30.31,28.69,28.66,31.44,34.38,36.06,37.59,40.16,42.94,43.66,43.22,44.03,45.09,44.59,43.38,43.47,44.94,45.72,45.25,44.59,45.44,45.16,43.31,41.19,40.56,40.47,39.41,37.56,37.34,38.0,37.5,36.53,36.31,37.91,38.84,38.72,38.72,40.06,41.69,41.38,40.88,41.47,42.69,42.41,41.69,41.94,42.91,42.66,41.03,40.03,40.53,40.78,39.78,39.41,41.38,43.5,44.0,43.94,44.84,45.75,44.88,42.75,41.78,42.25,41.78,40.22,39.47,40.72,41.25,40.5,40.16,41.47,43.09,43.16,42.38,42.72,43.47,42.94,41.25,40.59,41.25,41.19,39.66,38.25,38.59,38.75,37.91,37.12,39.09,42.03,43.75,45.0,47.22,49.66,50.22,48.78,47.69,47.62,46.5,44.56,43.25,44.38,45.84,46.28,46.41,47.75,48.88,48.0,45.38,43.97,43.69,43.25,41.97,42.12,43.19,43.75,42.06,40.47,40.28,40.44,39.5,38.25,38.88,40.44,40.84,40.16,40.47,41.19,40.41,37.91,36.03,35.78,35.53,34.25,33.5,34.44,35.62,35.06,33.53,33.62,34.66,35.09,34.53,35.53,37.5,38.72,37.81,37.38,38.03,38.47,37.25,36.44,38.0,40.19,41.19,41.5,43.03,44.88,45.78,45.25,45.81,46.75,46.75,44.72,42.41,41.72,40.88,39.19,37.22,37.19,37.44,36.28,34.0,33.0,32.88,32.44,31.06,30.84,32.69,34.06,33.88,33.91,35.56,36.91,36.81,36.59,38.41,40.62,41.5,41.69,42.44,43.62,44.16,42.91,42.16,42.78,42.62,41.19,39.91,40.91,41.97,41.56,40.34,40.47,41.03,40.53,38.72,38.22,38.66,37.66,34.88,32.59,31.88,31.0,28.88,27.75,29.12,31.09,32.25,32.81,34.94,37.22,38.44,37.88,38.19,38.94,38.75,36.5,34.75,34.91,35.16,34.38,33.88,35.25,37.03,37.22,36.81,37.88,39.56,40.41,40.34,41.81,44.56,46.56,46.69,46.28,46.34,45.41,42.06,38.16,36.0,34.66,32.59,31.03,32.12,34.47,35.94,36.44,37.22,39.12,40.88,41.09,41.0,42.25,43.0,41.66,39.81,39.56,39.78,38.62,36.25,35.53,36.16,36.91,36.53,37.06,39.16,40.5,39.88,39.38,40.16,40.88,39.53,37.59,36.62,36.5,35.56,33.81,33.72,34.72,35.25,34.31,34.09,35.09,35.5,34.22,32.69,33.28,34.22,34.25,34.31,35.41,37.22,37.16,36.09,36.12,37.25,37.97,37.12,36.75,37.19,37.75,36.16,34.78,35.16,35.91,35.12,33.88,34.06,35.66,35.97,35.56,35.75,37.22,37.66,36.72,36.5,37.53,38.28,37.41,36.19,35.88,36.44,35.28,33.34,32.5,32.28,31.19,29.16,28.69,30.47,32.59,32.97,33.47,34.62,35.69,34.06,31.72,30.97,30.53,28.38,25.41,23.75,23.0,21.59,19.06,17.66,17.47,17.5,16.25,16.25,17.84,21.16,23.09,24.69,27.47,30.0,30.84,30.12,29.81,30.72,30.91,29.59,29.06,29.97,30.94,30.25,29.69,30.69,32.0,31.84,31.19,31.53,32.56,32.38,31.75,32.09,33.56,34.75,34.78,34.97,36.94,39.12,40.0,40.97,43.19,45.91,46.44,46.38,46.34,46.22,44.47,40.97,38.28,36.84,34.81,31.72,29.19,28.38,27.75,26.22,25.03,25.28,26.59,26.72,26.31,27.31,29.5,30.62,30.88,31.53,33.28,35.28,35.19,35.19,36.44,37.59,36.72,35.59,35.53,35.94,35.0,33.38,32.78,33.53,33.78,33.41,33.59,35.09,36.53,36.12,35.88,36.81,38.06,37.69,36.88,36.97,37.38,36.28,33.88,32.53,32.25,31.38,29.25,27.97,28.53,28.91,28.16,27.78,28.91,30.41,30.75,30.72,31.56,33.06,32.72,30.97,29.34,28.69,27.22,24.44,22.84,22.91,23.31,22.88,22.47,23.97,26.41,27.88,29.25,31.69,35.28,38.03,39.88,42.41,46.47,49.0,49.25,48.59,47.88,46.44,42.97,39.44,37.25,36.53,34.91,34.0,34.72,37.19,39.09,40.03,41.09,43.12,44.53,43.66,42.66,42.56,42.12,40.19,38.03,37.47,38.34,38.44,38.22,39.09,41.0,41.84,41.38,40.56,41.0,40.56,38.75,36.62,36.47,36.75,35.91,34.31,33.72,33.53,31.97,29.38,28.0,28.19,27.97,26.16,25.0,25.69,26.41,26.12,26.19,28.0,30.25,30.88,30.78,31.66,32.75,32.75,31.78,31.47,32.47,33.19,33.03,33.38,35.66,37.16,36.78,35.56,35.0,34.16,32.31,29.56,28.25,28.19,27.84,27.09,27.19,29.25,30.75,30.59,30.16,31.41,32.5,32.5,32.34,32.72,34.16,34.12,33.19,33.31,35.19,36.53,36.69,37.5,39.06,39.88,38.69,36.81,36.38,36.31,35.16,33.91,34.0,34.88,34.56,32.69,31.44,31.59,31.38,30.0,29.5,30.97,32.28,32.34,32.25,33.78,35.44,35.91,35.88,37.06,38.97,39.5,38.81,38.22,38.78,38.41,36.78,35.66,36.28,36.91,36.34,35.78,36.81,38.31,38.94,38.91,40.16,42.41,43.75,43.38,43.19,43.97,43.78,42.16,40.75,41.19,41.47,40.28,38.34,37.91,37.84,37.5,37.03,38.0,40.22,41.31,41.09,41.22,42.34,43.16,42.47,42.16,43.06,43.84,42.59,40.81,39.94,39.41,38.5,36.97,37.0,38.56,39.62,40.09,40.62,42.75,44.22,43.75,42.88,43.06,43.09,42.16,40.84,41.06,42.38,42.75,42.75,43.41,45.12,46.22,45.62,45.25,45.88,46.0,44.16,41.75,40.34,39.19,37.16,35.22,35.16,36.84,38.28,38.75,39.72,40.97,41.19,39.69,38.06,38.47,39.12,38.81,38.0,38.66,39.88,39.91,39.16,40.03,41.62,42.12,41.28,40.59,40.75,40.03,37.66,35.22,34.03,33.19,31.62,30.25,31.22,33.47,35.59,36.88,39.47,42.25,44.41,44.59,44.97,46.16,46.5,45.31,43.66,43.97,45.0,45.03,44.75,45.38,46.25,45.41,42.84,41.25,40.94,40.19,38.16,36.81,36.75,36.84,36.03,35.47,37.12,38.91,39.41,39.0,39.38,40.09,39.56,38.16,38.06,38.91,39.31,38.09,37.47,37.94,38.34,37.19,36.0,36.47,37.25,36.91,35.59,35.53,35.56,34.66,31.94,30.09,29.53,29.09,28.0,27.78,29.69,32.38,33.81,34.56,36.78,38.91,39.38,38.44,38.62,39.69,40.19,39.69,40.06,41.53,42.38,41.56,40.06,40.12,40.38,39.19,38.0,38.44,39.94,40.81,40.66,41.03,41.69,41.44,39.75,38.78,39.47,40.34,39.5,38.53,37.97,37.41,35.34,32.84,31.94,32.38,32.38,32.09,33.25,35.22,36.62,36.44,36.75,38.06,39.62,39.5,38.91,39.25,39.38,37.81,35.75,34.97,35.41,35.16,33.84,33.81,34.88,36.06,36.44,37.5,40.22,43.38,44.78,45.84,48.19,50.59,51.09,50.12,49.84,49.94,48.69,46.28,44.72,44.75,45.0,44.03,43.47,44.09,44.47,42.47,39.75,38.31,37.81,36.53,34.88,34.75,35.66,35.69,34.5,34.44,36.28,37.84,38.09,38.34,39.62,40.75,40.0,39.03,39.69,41.38,41.81,41.59,42.38,43.91,44.62,43.78,43.34,44.44,45.34,44.66,44.03,44.22,44.34,42.62,40.56,40.22,41.38,41.5,40.62,40.69,41.22,41.09,39.75,39.41,41.0,42.25,41.84,41.16,41.31,41.78,40.38,38.38,37.44,37.28,35.91,33.12,31.94,32.19,32.41,31.53,31.31,32.81,34.78,35.03,35.47,37.16,39.28,39.47,38.91,39.28,41.03,41.81,41.47,41.66,42.81,43.25,41.84,40.78,41.0,41.97,41.22,39.88,40.38,40.97,40.56,39.62,39.41,40.41,71.62,72.84,74.44,76.34,78.03,79.97,81.12,81.84,82.03,82.53,82.41,81.97,80.69,80.03:50.12,49.47,47.72,46.78,47.53,48.09,47.56,47.88,49.38,50.34,49.12,47.0,45.62,44.53,42.19,39.53,37.78,38.03,37.47,36.28,35.97,37.28,38.59,38.78,39.06,40.91,42.72,42.44,41.56,42.06,43.47,43.84,43.53,45.0,48.06,50.28,51.41,52.91,55.03,56.88,56.06,55.31,55.97,56.97,55.72,53.41,51.88,50.94,48.84,45.5,43.88,44.5,44.75,44.0,44.25,46.78,49.12,49.56,50.03,51.28,52.62,51.75,49.56,48.31,47.91,46.28,43.56,41.66,41.84,42.09,41.19,41.62,44.41,47.72,48.94,49.91,50.84,51.41,49.69,46.62,44.69,44.25,43.12,40.81,39.09,39.0,38.62,36.62,35.22,35.47,36.09,34.97,33.69,34.12,35.47,36.19,36.22,38.0,41.47,44.56,46.72,48.66,51.84,54.19,54.62,54.53,55.75,56.94,55.56,53.09,51.5,49.97,47.03,43.06,40.06,38.5,36.94,34.03,32.44,33.0,34.31,34.41,34.69,36.44,38.75,39.25,39.16,40.19,42.41,43.25,43.03,43.06,44.31,44.84,43.53,42.72,43.81,44.84,44.56,43.75,43.81,44.0,42.28,39.72,37.75,37.34,36.25,34.0,32.84,33.0,32.56,30.75,29.59,31.22,33.75,35.31,36.31,38.31,40.78,40.59,40.09,40.47,41.88,41.84,40.41,39.28,39.22,39.28,38.19,37.25,38.16,39.16,38.47,37.06,37.19,37.72,36.53,34.25,32.16,31.62,30.31,28.69,28.66,31.44,34.38,36.06,37.59,40.16,42.94,43.66,43.22,44.03,45.09,44.59,43.38,43.47,44.94,45.72,45.25,44.59,45.44,45.16,43.31,41.19,40.56,40.47,39.41,37.56,37.34,38.0,37.5,36.53,36.31,37.91,38.84,38.72,38.72,40.06,41.69,41.38,40.88,41.47,42.69,42.41,41.69,41.94,42.91,42.66,41.03,40.03,40.53,40.78,39.78,39.41,41.38,43.5,44.0,43.94,44.84,45.75,44.88,42.75,41.78,42.25,41.78,40.22,39.47,40.72,41.25,40.5,40.16,41.47,43.09,43.16,42.38,42.72,43.47,42.94,41.25,40.59,41.25,41.19,39.66,38.25,38.59,38.75,37.91,37.12,39.09,42.03,43.75,45.0,47.22,49.66,50.22,48.78,47.69,47.62,46.5,44.56,43.25,44.38,45.84,46.28,46.41,47.75,48.88,48.0,45.38,43.97,43.69,43.25,41.97,42.12,43.19,43.75,42.06,40.47,40.28,40.44,39.5,38.25,38.88,40.44,40.84,40.16,40.47,41.19,40.41,37.91,36.03,35.78,35.53,34.25,33.5,34.44,35.62,35.06,33.53,33.62,34.66,35.09,34.53,35.53,37.5,38.72,37.81,37.38,38.03,38.47,37.25,36.44,38.0,40.19,41.19,41.5,43.03,44.88,45.78,45.25,45.81,46.75,46.75,44.72,42.41,41.72,40.88,39.19,37.22,37.19,37.44,36.28,34.0,33.0,32.88,32.44,31.06,30.84,32.69,34.06,33.88,33.91,35.56,36.91,36.81,36.59,38.41,40.62,41.5,41.69,42.44,43.62,44.16,42.91,42.16,42.78,42.62,41.19,39.91,40.91,41.97,41.56,40.34,40.47,41.03,40.53,38.72,38.22,38.66,37.66,34.88,32.59,31.88,31.0,28.88,27.75,29.12,31.09,32.25,32.81,34.94,37.22,38.44,37.88,38.19,38.94,38.75,36.5,34.75,34.91,35.16,34.38,33.88,35.25,37.03,37.22,36.81,37.88,39.56,40.41,40.34,41.81,44.56,46.56,46.69,46.28,46.34,45.41,42.06,38.16,36.0,34.66,32.59,31.03,32.12,34.47,35.94,36.44,37.22,39.12,40.88,41.09,41.0,42.25,43.0,41.66,39.81,39.56,39.78,38.62,36.25,35.53,36.16,36.91,36.53,37.06,39.16,40.5,39.88,39.38,40.16,40.88,39.53,37.59,36.62,36.5,35.56,33.81,33.72,34.72,35.25,34.31,34.09,35.09,35.5,34.22,32.69,33.28,34.22,34.25,34.31,35.41,37.22,37.16,36.09,36.12,37.25,37.97,37.12,36.75,37.19,37.75,36.16,34.78,35.16,35.91,35.12,33.88,34.06,35.66,35.97,35.56,35.75,37.22,37.66,36.72,36.5,37.53,38.28,37.41,36.19,35.88,36.44,35.28,33.34,32.5,32.28,31.19,29.16,28.69,30.47,32.59,32.97,33.47,34.62,35.69,34.06,31.72,30.97,30.53,28.38,25.41,23.75,23.0,21.59,19.06,17.66,17.47,17.5,16.25,16.25,17.84,21.16,23.09,24.69,27.47,30.0,30.84,30.12,29.81,30.72,30.91,29.59,29.06,29.97,30.94,30.25,29.69,30.69,32.0,31.84,31.19,31.53,32.56,32.38,31.75,32.09,33.56,34.75,34.78,34.97,36.94,39.12,40.0,40.97,43.19,45.91,46.44,46.38,46.34,46.22,44.47,40.97,38.28,36.84,34.81,31.72,29.19,28.38,27.75,26.22,25.03,25.28,26.59,26.72,26.31,27.31,29.5,30.62,30.88,31.53,33.28,35.28,35.19,35.19,36.44,37.59,36.72,35.59,35.53,35.94,35.0,33.38,32.78,33.53,33.78,33.41,33.59,35.09,36.53,36.12,35.88,36.81,38.06,37.69,36.88,36.97,37.38,36.28,33.88,32.53,32.25,31.38,29.25,27.97,28.53,28.91,28.16,27.78,28.91,30.41,30.75,30.72,31.56,33.06,32.72,30.97,29.34,28.69,27.22,24.44,22.84,22.91,23.31,22.88,22.47,23.97,26.41,27.88,29.25,31.69,35.28,38.03,39.88,42.41,46.47,49.0,49.25,48.59,47.88,46.44,42.97,39.44,37.25,36.53,34.91,34.0,34.72,37.19,39.09,40.03,41.09,43.12,44.53,43.66,42.66,42.56,42.12,40.19,38.03,37.47,38.34,38.44,38.22,39.09,41.0,41.84,41.38,40.56,41.0,40.56,38.75,36.62,36.47,36.75,35.91,34.31,33.72,33.53,31.97,29.38,28.0,28.19,27.97,26.16,25.0,25.69,26.41,26.12,26.19,28.0,30.25,30.88,30.78,31.66,32.75,32.75,31.78,31.47,32.47,33.19,33.03,33.38,35.66,37.16,36.78,35.56,35.0,34.16,32.31,29.56,28.25,28.19,27.84,27.09,27.19,29.25,30.75,30.59,30.16,31.41,32.5,32.5,32.34,32.72,34.16,34.12,33.19,33.31,35.19,36.53,36.69,37.5,39.06,39.88,38.69,36.81,36.38,36.31,35.16,33.91,34.0,34.88,34.56,32.69,31.44,31.59,31.38,30.0,29.5,30.97,32.28,32.34,32.25,33.78,35.44,35.91,35.88,37.06,38.97,39.5,38.81,38.22,38.78,38.41,36.78,35.66,36.28,36.91,36.34,35.78,36.81,38.31,38.94,38.91,40.16,42.41,43.75,43.38,43.19,43.97,43.78,42.16,40.75,41.19,41.47,40.28,38.34,37.91,37.84,37.5,37.03,38.0,40.22,41.31,41.09,41.22,42.34,43.16,42.47,42.16,43.06,43.84,42.59,40.81,39.94,39.41,38.5,36.97,37.0,38.56,39.62,40.09,40.62,42.75,44.22,43.75,42.88,43.06,43.09,42.16,40.84,41.06,42.38,42.75,42.75,43.41,45.12,46.22,45.62,45.25,45.88,46.0,44.16,41.75,40.34,39.19,37.16,35.22,35.16,36.84,38.28,38.75,39.72,40.97,41.19,39.69,38.06,38.47,39.12,38.81,38.0,38.66,39.88,39.91,39.16,40.03,41.62,42.12,41.28,40.59,40.75,40.03,37.66,35.22,34.03,33.19,31.62,30.25,31.22,33.47,35.59,36.88,39.47,42.25,44.41,44.59,44.97,46.16,46.5,45.31,43.66,43.97,45.0,45.03,44.75,45.38,46.25,45.41,42.84,41.25,40.94,40.19,38.16,36.81,36.75,36.84,36.03,35.47,37.12,38.91,39.41,39.0,39.38,40.09,39.56,38.16,38.06,38.91,39.31,38.09,37.47,37.94,38.34,37.19,36.0,36.47,37.25,36.91,35.59,35.53,35.56,34.66,31.94,30.09,29.53,29.09,28.0,27.78,29.69,32.38,33.81,34.56,36.78,38.91,39.38,38.44,38.62,39.69,40.19,39.69,40.06,41.53,42.38,41.56,40.06,40.12,40.38,39.19,38.0,38.44,39.94,40.81,40.66,41.03,41.69,41.44,39.75,38.78,39.47,40.34,39.5,38.53,37.97,37.41,35.34,32.84,31.94,32.38,32.38,32.09,33.25,35.22,36.62,36.44,36.75,38.06,39.62,39.5,38.91,39.25,39.38,37.81,35.75,34.97,35.41,35.16,33.84,33.81,34.88,36.06,36.44,37.5,40.22,43.38,44.78,45.84,48.19,50.59,51.09,50.12,49.84,49.94,48.69,46.28,44.72,44.75,45.0,44.03,43.47,44.09,44.47,42.47,39.75,38.31,37.81,36.53,34.88,34.75,35.66,35.69,34.5,34.44,36.28,37.84,38.09,38.34,39.62,40.75,40.0,39.03,39.69,41.38,41.81,41.59,42.38,43.91,44.62,43.78,43.34,44.44,45.34,44.66,44.03,44.22,44.34,42.62,40.56,40.22,41.38,41.5,40.62,40.69,41.22,41.09,39.75,39.41,41.0,42.25,41.84,41.16,41.31,41.78,40.38,38.38,37.44,37.28,35.91,33.12,31.94,32.19,32.41,31.53,31.31,32.81,34.78,35.03,35.47,37.16,39.28,39.47,38.91,39.28,41.03,41.81,41.47,41.66,42.81,43.25,41.84,40.78,41.0,41.97,41.22,39.88,40.38,40.97,40.56,39.62,39.41,40.41,71.62,72.84,74.44,76.34,78.03,79.97,81.12,81.84,82.03,82.53,82.41,81.97,80.69,80.03,79.91,79.53,79.12,79.31,79.66,79.41,79.06:47.88,49.38,50.34,49.12,47.0,45.62,44.53,42.19,39.53,37.78,38.03,37.47,36.28,35.97,37.28,38.59,38.78,39.06,40.91,42.72,42.44,41.56,42.06,43.47,43.84,43.53,45.0,48.06,50.28,51.41,52.91,55.03,56.88,56.06,55.31,55.97,56.97,55.72,53.41,51.88,50.94,48.84,45.5,43.88,44.5,44.75,44.0,44.25,46.78,49.12,49.56,50.03,51.28,52.62,51.75,49.56,48.31,47.91,46.28,43.56,41.66,41.84,42.09,41.19,41.62,44.41,47.72,48.94,49.91,50.84,51.41,49.69,46.62,44.69,44.25,43.12,40.81,39.09,39.0,38.62,36.62,35.22,35.47,36.09,34.97,33.69,34.12,35.47,36.19,36.22,38.0,41.47,44.56,46.72,48.66,51.84,54.19,54.62,54.53,55.75,56.94,55.56,53.09,51.5,49.97,47.03,43.06,40.06,38.5,36.94,34.03,32.44,33.0,34.31,34.41,34.69,36.44,38.75,39.25,39.16,40.19,42.41,43.25,43.03,43.06,44.31,44.84,43.53,42.72,43.81,44.84,44.56,43.75,43.81,44.0,42.28,39.72,37.75,37.34,36.25,34.0,32.84,33.0,32.56,30.75,29.59,31.22,33.75,35.31,36.31,38.31,40.78,40.59,40.09,40.47,41.88,41.84,40.41,39.28,39.22,39.28,38.19,37.25,38.16,39.16,38.47,37.06,37.19,37.72,36.53,34.25,32.16,31.62,30.31,28.69,28.66,31.44,34.38,36.06,37.59,40.16,42.94,43.66,43.22,44.03,45.09,44.59,43.38,43.47,44.94,45.72,45.25,44.59,45.44,45.16,43.31,41.19,40.56,40.47,39.41,37.56,37.34,38.0,37.5,36.53,36.31,37.91,38.84,38.72,38.72,40.06,41.69,41.38,40.88,41.47,42.69,42.41,41.69,41.94,42.91,42.66,41.03,40.03,40.53,40.78,39.78,39.41,41.38,43.5,44.0,43.94,44.84,45.75,44.88,42.75,41.78,42.25,41.78,40.22,39.47,40.72,41.25,40.5,40.16,41.47,43.09,43.16,42.38,42.72,43.47,42.94,41.25,40.59,41.25,41.19,39.66,38.25,38.59,38.75,37.91,37.12,39.09,42.03,43.75,45.0,47.22,49.66,50.22,48.78,47.69,47.62,46.5,44.56,43.25,44.38,45.84,46.28,46.41,47.75,48.88,48.0,45.38,43.97,43.69,43.25,41.97,42.12,43.19,43.75,42.06,40.47,40.28,40.44,39.5,38.25,38.88,40.44,40.84,40.16,40.47,41.19,40.41,37.91,36.03,35.78,35.53,34.25,33.5,34.44,35.62,35.06,33.53,33.62,34.66,35.09,34.53,35.53,37.5,38.72,37.81,37.38,38.03,38.47,37.25,36.44,38.0,40.19,41.19,41.5,43.03,44.88,45.78,45.25,45.81,46.75,46.75,44.72,42.41,41.72,40.88,39.19,37.22,37.19,37.44,36.28,34.0,33.0,32.88,32.44,31.06,30.84,32.69,34.06,33.88,33.91,35.56,36.91,36.81,36.59,38.41,40.62,41.5,41.69,42.44,43.62,44.16,42.91,42.16,42.78,42.62,41.19,39.91,40.91,41.97,41.56,40.34,40.47,41.03,40.53,38.72,38.22,38.66,37.66,34.88,32.59,31.88,31.0,28.88,27.75,29.12,31.09,32.25,32.81,34.94,37.22,38.44,37.88,38.19,38.94,38.75,36.5,34.75,34.91,35.16,34.38,33.88,35.25,37.03,37.22,36.81,37.88,39.56,40.41,40.34,41.81,44.56,46.56,46.69,46.28,46.34,45.41,42.06,38.16,36.0,34.66,32.59,31.03,32.12,34.47,35.94,36.44,37.22,39.12,40.88,41.09,41.0,42.25,43.0,41.66,39.81,39.56,39.78,38.62,36.25,35.53,36.16,36.91,36.53,37.06,39.16,40.5,39.88,39.38,40.16,40.88,39.53,37.59,36.62,36.5,35.56,33.81,33.72,34.72,35.25,34.31,34.09,35.09,35.5,34.22,32.69,33.28,34.22,34.25,34.31,35.41,37.22,37.16,36.09,36.12,37.25,37.97,37.12,36.75,37.19,37.75,36.16,34.78,35.16,35.91,35.12,33.88,34.06,35.66,35.97,35.56,35.75,37.22,37.66,36.72,36.5,37.53,38.28,37.41,36.19,35.88,36.44,35.28,33.34,32.5,32.28,31.19,29.16,28.69,30.47,32.59,32.97,33.47,34.62,35.69,34.06,31.72,30.97,30.53,28.38,25.41,23.75,23.0,21.59,19.06,17.66,17.47,17.5,16.25,16.25,17.84,21.16,23.09,24.69,27.47,30.0,30.84,30.12,29.81,30.72,30.91,29.59,29.06,29.97,30.94,30.25,29.69,30.69,32.0,31.84,31.19,31.53,32.56,32.38,31.75,32.09,33.56,34.75,34.78,34.97,36.94,39.12,40.0,40.97,43.19,45.91,46.44,46.38,46.34,46.22,44.47,40.97,38.28,36.84,34.81,31.72,29.19,28.38,27.75,26.22,25.03,25.28,26.59,26.72,26.31,27.31,29.5,30.62,30.88,31.53,33.28,35.28,35.19,35.19,36.44,37.59,36.72,35.59,35.53,35.94,35.0,33.38,32.78,33.53,33.78,33.41,33.59,35.09,36.53,36.12,35.88,36.81,38.06,37.69,36.88,36.97,37.38,36.28,33.88,32.53,32.25,31.38,29.25,27.97,28.53,28.91,28.16,27.78,28.91,30.41,30.75,30.72,31.56,33.06,32.72,30.97,29.34,28.69,27.22,24.44,22.84,22.91,23.31,22.88,22.47,23.97,26.41,27.88,29.25,31.69,35.28,38.03,39.88,42.41,46.47,49.0,49.25,48.59,47.88,46.44,42.97,39.44,37.25,36.53,34.91,34.0,34.72,37.19,39.09,40.03,41.09,43.12,44.53,43.66,42.66,42.56,42.12,40.19,38.03,37.47,38.34,38.44,38.22,39.09,41.0,41.84,41.38,40.56,41.0,40.56,38.75,36.62,36.47,36.75,35.91,34.31,33.72,33.53,31.97,29.38,28.0,28.19,27.97,26.16,25.0,25.69,26.41,26.12,26.19,28.0,30.25,30.88,30.78,31.66,32.75,32.75,31.78,31.47,32.47,33.19,33.03,33.38,35.66,37.16,36.78,35.56,35.0,34.16,32.31,29.56,28.25,28.19,27.84,27.09,27.19,29.25,30.75,30.59,30.16,31.41,32.5,32.5,32.34,32.72,34.16,34.12,33.19,33.31,35.19,36.53,36.69,37.5,39.06,39.88,38.69,36.81,36.38,36.31,35.16,33.91,34.0,34.88,34.56,32.69,31.44,31.59,31.38,30.0,29.5,30.97,32.28,32.34,32.25,33.78,35.44,35.91,35.88,37.06,38.97,39.5,38.81,38.22,38.78,38.41,36.78,35.66,36.28,36.91,36.34,35.78,36.81,38.31,38.94,38.91,40.16,42.41,43.75,43.38,43.19,43.97,43.78,42.16,40.75,41.19,41.47,40.28,38.34,37.91,37.84,37.5,37.03,38.0,40.22,41.31,41.09,41.22,42.34,43.16,42.47,42.16,43.06,43.84,42.59,40.81,39.94,39.41,38.5,36.97,37.0,38.56,39.62,40.09,40.62,42.75,44.22,43.75,42.88,43.06,43.09,42.16,40.84,41.06,42.38,42.75,42.75,43.41,45.12,46.22,45.62,45.25,45.88,46.0,44.16,41.75,40.34,39.19,37.16,35.22,35.16,36.84,38.28,38.75,39.72,40.97,41.19,39.69,38.06,38.47,39.12,38.81,38.0,38.66,39.88,39.91,39.16,40.03,41.62,42.12,41.28,40.59,40.75,40.03,37.66,35.22,34.03,33.19,31.62,30.25,31.22,33.47,35.59,36.88,39.47,42.25,44.41,44.59,44.97,46.16,46.5,45.31,43.66,43.97,45.0,45.03,44.75,45.38,46.25,45.41,42.84,41.25,40.94,40.19,38.16,36.81,36.75,36.84,36.03,35.47,37.12,38.91,39.41,39.0,39.38,40.09,39.56,38.16,38.06,38.91,39.31,38.09,37.47,37.94,38.34,37.19,36.0,36.47,37.25,36.91,35.59,35.53,35.56,34.66,31.94,30.09,29.53,29.09,28.0,27.78,29.69,32.38,33.81,34.56,36.78,38.91,39.38,38.44,38.62,39.69,40.19,39.69,40.06,41.53,42.38,41.56,40.06,40.12,40.38,39.19,38.0,38.44,39.94,40.81,40.66,41.03,41.69,41.44,39.75,38.78,39.47,40.34,39.5,38.53,37.97,37.41,35.34,32.84,31.94,32.38,32.38,32.09,33.25,35.22,36.62,36.44,36.75,38.06,39.62,39.5,38.91,39.25,39.38,37.81,35.75,34.97,35.41,35.16,33.84,33.81,34.88,36.06,36.44,37.5,40.22,43.38,44.78,45.84,48.19,50.59,51.09,50.12,49.84,49.94,48.69,46.28,44.72,44.75,45.0,44.03,43.47,44.09,44.47,42.47,39.75,38.31,37.81,36.53,34.88,34.75,35.66,35.69,34.5,34.44,36.28,37.84,38.09,38.34,39.62,40.75,40.0,39.03,39.69,41.38,41.81,41.59,42.38,43.91,44.62,43.78,43.34,44.44,45.34,44.66,44.03,44.22,44.34,42.62,40.56,40.22,41.38,41.5,40.62,40.69,41.22,41.09,39.75,39.41,41.0,42.25,41.84,41.16,41.31,41.78,40.38,38.38,37.44,37.28,35.91,33.12,31.94,32.19,32.41,31.53,31.31,32.81,34.78,35.03,35.47,37.16,39.28,39.47,38.91,39.28,41.03,41.81,41.47,41.66,42.81,43.25,41.84,40.78,41.0,41.97,41.22,39.88,40.38,40.97,40.56,39.62,39.41,40.41,71.62,72.84,74.44,76.34,78.03,79.97,81.12,81.84,82.03,82.53,82.41,81.97,80.69,80.03,79.91,79.53,79.12,79.31,79.66,79.41,79.06,78.78,78.88,78.53,78.16,77.91,77.94,78.47:42.19,39.53,37.78,38.03,37.47,36.28,35.97,37.28,38.59,38.78,39.06,40.91,42.72,42.44,41.56,42.06,43.47,43.84,43.53,45.0,48.06,50.28,51.41,52.91,55.03,56.88,56.06,55.31,55.97,56.97,55.72,53.41,51.88,50.94,48.84,45.5,43.88,44.5,44.75,44.0,44.25,46.78,49.12,49.56,50.03,51.28,52.62,51.75,49.56,48.31,47.91,46.28,43.56,41.66,41.84,42.09,41.19,41.62,44.41,47.72,48.94,49.91,50.84,51.41,49.69,46.62,44.69,44.25,43.12,40.81,39.09,39.0,38.62,36.62,35.22,35.47,36.09,34.97,33.69,34.12,35.47,36.19,36.22,38.0,41.47,44.56,46.72,48.66,51.84,54.19,54.62,54.53,55.75,56.94,55.56,53.09,51.5,49.97,47.03,43.06,40.06,38.5,36.94,34.03,32.44,33.0,34.31,34.41,34.69,36.44,38.75,39.25,39.16,40.19,42.41,43.25,43.03,43.06,44.31,44.84,43.53,42.72,43.81,44.84,44.56,43.75,43.81,44.0,42.28,39.72,37.75,37.34,36.25,34.0,32.84,33.0,32.56,30.75,29.59,31.22,33.75,35.31,36.31,38.31,40.78,40.59,40.09,40.47,41.88,41.84,40.41,39.28,39.22,39.28,38.19,37.25,38.16,39.16,38.47,37.06,37.19,37.72,36.53,34.25,32.16,31.62,30.31,28.69,28.66,31.44,34.38,36.06,37.59,40.16,42.94,43.66,43.22,44.03,45.09,44.59,43.38,43.47,44.94,45.72,45.25,44.59,45.44,45.16,43.31,41.19,40.56,40.47,39.41,37.56,37.34,38.0,37.5,36.53,36.31,37.91,38.84,38.72,38.72,40.06,41.69,41.38,40.88,41.47,42.69,42.41,41.69,41.94,42.91,42.66,41.03,40.03,40.53,40.78,39.78,39.41,41.38,43.5,44.0,43.94,44.84,45.75,44.88,42.75,41.78,42.25,41.78,40.22,39.47,40.72,41.25,40.5,40.16,41.47,43.09,43.16,42.38,42.72,43.47,42.94,41.25,40.59,41.25,41.19,39.66,38.25,38.59,38.75,37.91,37.12,39.09,42.03,43.75,45.0,47.22,49.66,50.22,48.78,47.69,47.62,46.5,44.56,43.25,44.38,45.84,46.28,46.41,47.75,48.88,48.0,45.38,43.97,43.69,43.25,41.97,42.12,43.19,43.75,42.06,40.47,40.28,40.44,39.5,38.25,38.88,40.44,40.84,40.16,40.47,41.19,40.41,37.91,36.03,35.78,35.53,34.25,33.5,34.44,35.62,35.06,33.53,33.62,34.66,35.09,34.53,35.53,37.5,38.72,37.81,37.38,38.03,38.47,37.25,36.44,38.0,40.19,41.19,41.5,43.03,44.88,45.78,45.25,45.81,46.75,46.75,44.72,42.41,41.72,40.88,39.19,37.22,37.19,37.44,36.28,34.0,33.0,32.88,32.44,31.06,30.84,32.69,34.06,33.88,33.91,35.56,36.91,36.81,36.59,38.41,40.62,41.5,41.69,42.44,43.62,44.16,42.91,42.16,42.78,42.62,41.19,39.91,40.91,41.97,41.56,40.34,40.47,41.03,40.53,38.72,38.22,38.66,37.66,34.88,32.59,31.88,31.0,28.88,27.75,29.12,31.09,32.25,32.81,34.94,37.22,38.44,37.88,38.19,38.94,38.75,36.5,34.75,34.91,35.16,34.38,33.88,35.25,37.03,37.22,36.81,37.88,39.56,40.41,40.34,41.81,44.56,46.56,46.69,46.28,46.34,45.41,42.06,38.16,36.0,34.66,32.59,31.03,32.12,34.47,35.94,36.44,37.22,39.12,40.88,41.09,41.0,42.25,43.0,41.66,39.81,39.56,39.78,38.62,36.25,35.53,36.16,36.91,36.53,37.06,39.16,40.5,39.88,39.38,40.16,40.88,39.53,37.59,36.62,36.5,35.56,33.81,33.72,34.72,35.25,34.31,34.09,35.09,35.5,34.22,32.69,33.28,34.22,34.25,34.31,35.41,37.22,37.16,36.09,36.12,37.25,37.97,37.12,36.75,37.19,37.75,36.16,34.78,35.16,35.91,35.12,33.88,34.06,35.66,35.97,35.56,35.75,37.22,37.66,36.72,36.5,37.53,38.28,37.41,36.19,35.88,36.44,35.28,33.34,32.5,32.28,31.19,29.16,28.69,30.47,32.59,32.97,33.47,34.62,35.69,34.06,31.72,30.97,30.53,28.38,25.41,23.75,23.0,21.59,19.06,17.66,17.47,17.5,16.25,16.25,17.84,21.16,23.09,24.69,27.47,30.0,30.84,30.12,29.81,30.72,30.91,29.59,29.06,29.97,30.94,30.25,29.69,30.69,32.0,31.84,31.19,31.53,32.56,32.38,31.75,32.09,33.56,34.75,34.78,34.97,36.94,39.12,40.0,40.97,43.19,45.91,46.44,46.38,46.34,46.22,44.47,40.97,38.28,36.84,34.81,31.72,29.19,28.38,27.75,26.22,25.03,25.28,26.59,26.72,26.31,27.31,29.5,30.62,30.88,31.53,33.28,35.28,35.19,35.19,36.44,37.59,36.72,35.59,35.53,35.94,35.0,33.38,32.78,33.53,33.78,33.41,33.59,35.09,36.53,36.12,35.88,36.81,38.06,37.69,36.88,36.97,37.38,36.28,33.88,32.53,32.25,31.38,29.25,27.97,28.53,28.91,28.16,27.78,28.91,30.41,30.75,30.72,31.56,33.06,32.72,30.97,29.34,28.69,27.22,24.44,22.84,22.91,23.31,22.88,22.47,23.97,26.41,27.88,29.25,31.69,35.28,38.03,39.88,42.41,46.47,49.0,49.25,48.59,47.88,46.44,42.97,39.44,37.25,36.53,34.91,34.0,34.72,37.19,39.09,40.03,41.09,43.12,44.53,43.66,42.66,42.56,42.12,40.19,38.03,37.47,38.34,38.44,38.22,39.09,41.0,41.84,41.38,40.56,41.0,40.56,38.75,36.62,36.47,36.75,35.91,34.31,33.72,33.53,31.97,29.38,28.0,28.19,27.97,26.16,25.0,25.69,26.41,26.12,26.19,28.0,30.25,30.88,30.78,31.66,32.75,32.75,31.78,31.47,32.47,33.19,33.03,33.38,35.66,37.16,36.78,35.56,35.0,34.16,32.31,29.56,28.25,28.19,27.84,27.09,27.19,29.25,30.75,30.59,30.16,31.41,32.5,32.5,32.34,32.72,34.16,34.12,33.19,33.31,35.19,36.53,36.69,37.5,39.06,39.88,38.69,36.81,36.38,36.31,35.16,33.91,34.0,34.88,34.56,32.69,31.44,31.59,31.38,30.0,29.5,30.97,32.28,32.34,32.25,33.78,35.44,35.91,35.88,37.06,38.97,39.5,38.81,38.22,38.78,38.41,36.78,35.66,36.28,36.91,36.34,35.78,36.81,38.31,38.94,38.91,40.16,42.41,43.75,43.38,43.19,43.97,43.78,42.16,40.75,41.19,41.47,40.28,38.34,37.91,37.84,37.5,37.03,38.0,40.22,41.31,41.09,41.22,42.34,43.16,42.47,42.16,43.06,43.84,42.59,40.81,39.94,39.41,38.5,36.97,37.0,38.56,39.62,40.09,40.62,42.75,44.22,43.75,42.88,43.06,43.09,42.16,40.84,41.06,42.38,42.75,42.75,43.41,45.12,46.22,45.62,45.25,45.88,46.0,44.16,41.75,40.34,39.19,37.16,35.22,35.16,36.84,38.28,38.75,39.72,40.97,41.19,39.69,38.06,38.47,39.12,38.81,38.0,38.66,39.88,39.91,39.16,40.03,41.62,42.12,41.28,40.59,40.75,40.03,37.66,35.22,34.03,33.19,31.62,30.25,31.22,33.47,35.59,36.88,39.47,42.25,44.41,44.59,44.97,46.16,46.5,45.31,43.66,43.97,45.0,45.03,44.75,45.38,46.25,45.41,42.84,41.25,40.94,40.19,38.16,36.81,36.75,36.84,36.03,35.47,37.12,38.91,39.41,39.0,39.38,40.09,39.56,38.16,38.06,38.91,39.31,38.09,37.47,37.94,38.34,37.19,36.0,36.47,37.25,36.91,35.59,35.53,35.56,34.66,31.94,30.09,29.53,29.09,28.0,27.78,29.69,32.38,33.81,34.56,36.78,38.91,39.38,38.44,38.62,39.69,40.19,39.69,40.06,41.53,42.38,41.56,40.06,40.12,40.38,39.19,38.0,38.44,39.94,40.81,40.66,41.03,41.69,41.44,39.75,38.78,39.47,40.34,39.5,38.53,37.97,37.41,35.34,32.84,31.94,32.38,32.38,32.09,33.25,35.22,36.62,36.44,36.75,38.06,39.62,39.5,38.91,39.25,39.38,37.81,35.75,34.97,35.41,35.16,33.84,33.81,34.88,36.06,36.44,37.5,40.22,43.38,44.78,45.84,48.19,50.59,51.09,50.12,49.84,49.94,48.69,46.28,44.72,44.75,45.0,44.03,43.47,44.09,44.47,42.47,39.75,38.31,37.81,36.53,34.88,34.75,35.66,35.69,34.5,34.44,36.28,37.84,38.09,38.34,39.62,40.75,40.0,39.03,39.69,41.38,41.81,41.59,42.38,43.91,44.62,43.78,43.34,44.44,45.34,44.66,44.03,44.22,44.34,42.62,40.56,40.22,41.38,41.5,40.62,40.69,41.22,41.09,39.75,39.41,41.0,42.25,41.84,41.16,41.31,41.78,40.38,38.38,37.44,37.28,35.91,33.12,31.94,32.19,32.41,31.53,31.31,32.81,34.78,35.03,35.47,37.16,39.28,39.47,38.91,39.28,41.03,41.81,41.47,41.66,42.81,43.25,41.84,40.78,41.0,41.97,41.22,39.88,40.38,40.97,40.56,39.62,39.41,40.41,71.62,72.84,74.44,76.34,78.03,79.97,81.12,81.84,82.03,82.53,82.41,81.97,80.69,80.03,79.91,79.53,79.12,79.31,79.66,79.41,79.06,78.78,78.88,78.53,78.16,77.91,77.94,78.47,78.38,77.56,77.16,76.06,74.47,72.28,70.66:37.28,38.59,38.78,39.06,40.91,42.72,42.44,41.56,42.06,43.47,43.84,43.53,45.0,48.06,50.28,51.41,52.91,55.03,56.88,56.06,55.31,55.97,56.97,55.72,53.41,51.88,50.94,48.84,45.5,43.88,44.5,44.75,44.0,44.25,46.78,49.12,49.56,50.03,51.28,52.62,51.75,49.56,48.31,47.91,46.28,43.56,41.66,41.84,42.09,41.19,41.62,44.41,47.72,48.94,49.91,50.84,51.41,49.69,46.62,44.69,44.25,43.12,40.81,39.09,39.0,38.62,36.62,35.22,35.47,36.09,34.97,33.69,34.12,35.47,36.19,36.22,38.0,41.47,44.56,46.72,48.66,51.84,54.19,54.62,54.53,55.75,56.94,55.56,53.09,51.5,49.97,47.03,43.06,40.06,38.5,36.94,34.03,32.44,33.0,34.31,34.41,34.69,36.44,38.75,39.25,39.16,40.19,42.41,43.25,43.03,43.06,44.31,44.84,43.53,42.72,43.81,44.84,44.56,43.75,43.81,44.0,42.28,39.72,37.75,37.34,36.25,34.0,32.84,33.0,32.56,30.75,29.59,31.22,33.75,35.31,36.31,38.31,40.78,40.59,40.09,40.47,41.88,41.84,40.41,39.28,39.22,39.28,38.19,37.25,38.16,39.16,38.47,37.06,37.19,37.72,36.53,34.25,32.16,31.62,30.31,28.69,28.66,31.44,34.38,36.06,37.59,40.16,42.94,43.66,43.22,44.03,45.09,44.59,43.38,43.47,44.94,45.72,45.25,44.59,45.44,45.16,43.31,41.19,40.56,40.47,39.41,37.56,37.34,38.0,37.5,36.53,36.31,37.91,38.84,38.72,38.72,40.06,41.69,41.38,40.88,41.47,42.69,42.41,41.69,41.94,42.91,42.66,41.03,40.03,40.53,40.78,39.78,39.41,41.38,43.5,44.0,43.94,44.84,45.75,44.88,42.75,41.78,42.25,41.78,40.22,39.47,40.72,41.25,40.5,40.16,41.47,43.09,43.16,42.38,42.72,43.47,42.94,41.25,40.59,41.25,41.19,39.66,38.25,38.59,38.75,37.91,37.12,39.09,42.03,43.75,45.0,47.22,49.66,50.22,48.78,47.69,47.62,46.5,44.56,43.25,44.38,45.84,46.28,46.41,47.75,48.88,48.0,45.38,43.97,43.69,43.25,41.97,42.12,43.19,43.75,42.06,40.47,40.28,40.44,39.5,38.25,38.88,40.44,40.84,40.16,40.47,41.19,40.41,37.91,36.03,35.78,35.53,34.25,33.5,34.44,35.62,35.06,33.53,33.62,34.66,35.09,34.53,35.53,37.5,38.72,37.81,37.38,38.03,38.47,37.25,36.44,38.0,40.19,41.19,41.5,43.03,44.88,45.78,45.25,45.81,46.75,46.75,44.72,42.41,41.72,40.88,39.19,37.22,37.19,37.44,36.28,34.0,33.0,32.88,32.44,31.06,30.84,32.69,34.06,33.88,33.91,35.56,36.91,36.81,36.59,38.41,40.62,41.5,41.69,42.44,43.62,44.16,42.91,42.16,42.78,42.62,41.19,39.91,40.91,41.97,41.56,40.34,40.47,41.03,40.53,38.72,38.22,38.66,37.66,34.88,32.59,31.88,31.0,28.88,27.75,29.12,31.09,32.25,32.81,34.94,37.22,38.44,37.88,38.19,38.94,38.75,36.5,34.75,34.91,35.16,34.38,33.88,35.25,37.03,37.22,36.81,37.88,39.56,40.41,40.34,41.81,44.56,46.56,46.69,46.28,46.34,45.41,42.06,38.16,36.0,34.66,32.59,31.03,32.12,34.47,35.94,36.44,37.22,39.12,40.88,41.09,41.0,42.25,43.0,41.66,39.81,39.56,39.78,38.62,36.25,35.53,36.16,36.91,36.53,37.06,39.16,40.5,39.88,39.38,40.16,40.88,39.53,37.59,36.62,36.5,35.56,33.81,33.72,34.72,35.25,34.31,34.09,35.09,35.5,34.22,32.69,33.28,34.22,34.25,34.31,35.41,37.22,37.16,36.09,36.12,37.25,37.97,37.12,36.75,37.19,37.75,36.16,34.78,35.16,35.91,35.12,33.88,34.06,35.66,35.97,35.56,35.75,37.22,37.66,36.72,36.5,37.53,38.28,37.41,36.19,35.88,36.44,35.28,33.34,32.5,32.28,31.19,29.16,28.69,30.47,32.59,32.97,33.47,34.62,35.69,34.06,31.72,30.97,30.53,28.38,25.41,23.75,23.0,21.59,19.06,17.66,17.47,17.5,16.25,16.25,17.84,21.16,23.09,24.69,27.47,30.0,30.84,30.12,29.81,30.72,30.91,29.59,29.06,29.97,30.94,30.25,29.69,30.69,32.0,31.84,31.19,31.53,32.56,32.38,31.75,32.09,33.56,34.75,34.78,34.97,36.94,39.12,40.0,40.97,43.19,45.91,46.44,46.38,46.34,46.22,44.47,40.97,38.28,36.84,34.81,31.72,29.19,28.38,27.75,26.22,25.03,25.28,26.59,26.72,26.31,27.31,29.5,30.62,30.88,31.53,33.28,35.28,35.19,35.19,36.44,37.59,36.72,35.59,35.53,35.94,35.0,33.38,32.78,33.53,33.78,33.41,33.59,35.09,36.53,36.12,35.88,36.81,38.06,37.69,36.88,36.97,37.38,36.28,33.88,32.53,32.25,31.38,29.25,27.97,28.53,28.91,28.16,27.78,28.91,30.41,30.75,30.72,31.56,33.06,32.72,30.97,29.34,28.69,27.22,24.44,22.84,22.91,23.31,22.88,22.47,23.97,26.41,27.88,29.25,31.69,35.28,38.03,39.88,42.41,46.47,49.0,49.25,48.59,47.88,46.44,42.97,39.44,37.25,36.53,34.91,34.0,34.72,37.19,39.09,40.03,41.09,43.12,44.53,43.66,42.66,42.56,42.12,40.19,38.03,37.47,38.34,38.44,38.22,39.09,41.0,41.84,41.38,40.56,41.0,40.56,38.75,36.62,36.47,36.75,35.91,34.31,33.72,33.53,31.97,29.38,28.0,28.19,27.97,26.16,25.0,25.69,26.41,26.12,26.19,28.0,30.25,30.88,30.78,31.66,32.75,32.75,31.78,31.47,32.47,33.19,33.03,33.38,35.66,37.16,36.78,35.56,35.0,34.16,32.31,29.56,28.25,28.19,27.84,27.09,27.19,29.25,30.75,30.59,30.16,31.41,32.5,32.5,32.34,32.72,34.16,34.12,33.19,33.31,35.19,36.53,36.69,37.5,39.06,39.88,38.69,36.81,36.38,36.31,35.16,33.91,34.0,34.88,34.56,32.69,31.44,31.59,31.38,30.0,29.5,30.97,32.28,32.34,32.25,33.78,35.44,35.91,35.88,37.06,38.97,39.5,38.81,38.22,38.78,38.41,36.78,35.66,36.28,36.91,36.34,35.78,36.81,38.31,38.94,38.91,40.16,42.41,43.75,43.38,43.19,43.97,43.78,42.16,40.75,41.19,41.47,40.28,38.34,37.91,37.84,37.5,37.03,38.0,40.22,41.31,41.09,41.22,42.34,43.16,42.47,42.16,43.06,43.84,42.59,40.81,39.94,39.41,38.5,36.97,37.0,38.56,39.62,40.09,40.62,42.75,44.22,43.75,42.88,43.06,43.09,42.16,40.84,41.06,42.38,42.75,42.75,43.41,45.12,46.22,45.62,45.25,45.88,46.0,44.16,41.75,40.34,39.19,37.16,35.22,35.16,36.84,38.28,38.75,39.72,40.97,41.19,39.69,38.06,38.47,39.12,38.81,38.0,38.66,39.88,39.91,39.16,40.03,41.62,42.12,41.28,40.59,40.75,40.03,37.66,35.22,34.03,33.19,31.62,30.25,31.22,33.47,35.59,36.88,39.47,42.25,44.41,44.59,44.97,46.16,46.5,45.31,43.66,43.97,45.0,45.03,44.75,45.38,46.25,45.41,42.84,41.25,40.94,40.19,38.16,36.81,36.75,36.84,36.03,35.47,37.12,38.91,39.41,39.0,39.38,40.09,39.56,38.16,38.06,38.91,39.31,38.09,37.47,37.94,38.34,37.19,36.0,36.47,37.25,36.91,35.59,35.53,35.56,34.66,31.94,30.09,29.53,29.09,28.0,27.78,29.69,32.38,33.81,34.56,36.78,38.91,39.38,38.44,38.62,39.69,40.19,39.69,40.06,41.53,42.38,41.56,40.06,40.12,40.38,39.19,38.0,38.44,39.94,40.81,40.66,41.03,41.69,41.44,39.75,38.78,39.47,40.34,39.5,38.53,37.97,37.41,35.34,32.84,31.94,32.38,32.38,32.09,33.25,35.22,36.62,36.44,36.75,38.06,39.62,39.5,38.91,39.25,39.38,37.81,35.75,34.97,35.41,35.16,33.84,33.81,34.88,36.06,36.44,37.5,40.22,43.38,44.78,45.84,48.19,50.59,51.09,50.12,49.84,49.94,48.69,46.28,44.72,44.75,45.0,44.03,43.47,44.09,44.47,42.47,39.75,38.31,37.81,36.53,34.88,34.75,35.66,35.69,34.5,34.44,36.28,37.84,38.09,38.34,39.62,40.75,40.0,39.03,39.69,41.38,41.81,41.59,42.38,43.91,44.62,43.78,43.34,44.44,45.34,44.66,44.03,44.22,44.34,42.62,40.56,40.22,41.38,41.5,40.62,40.69,41.22,41.09,39.75,39.41,41.0,42.25,41.84,41.16,41.31,41.78,40.38,38.38,37.44,37.28,35.91,33.12,31.94,32.19,32.41,31.53,31.31,32.81,34.78,35.03,35.47,37.16,39.28,39.47,38.91,39.28,41.03,41.81,41.47,41.66,42.81,43.25,41.84,40.78,41.0,41.97,41.22,39.88,40.38,40.97,40.56,39.62,39.41,40.41,71.62,72.84,74.44,76.34,78.03,79.97,81.12,81.84,82.03,82.53,82.41,81.97,80.69,80.03,79.91,79.53,79.12,79.31,79.66,79.41,79.06,78.78,78.88,78.53,78.16,77.91,77.94,78.47,78.38,77.56,77.16,76.06,74.47,72.28,70.66,69.91,69.5,69.16,69.59,70.22,70.53,70.53:negativity
8.72,5.16,2.88,0.5,-1.06,-1.41,-0.28,0.59,1.25,2.19,4.16,6.44,8.16,10.09,12.69,15.84,17.59,18.78,19.28,19.16,17.88,15.75,13.97,13.66,13.84,14.22,14.84,16.75,18.84,19.66,19.97,20.38,20.38,19.56,18.41,18.09,18.66,19.59,20.03,21.06,23.25,25.31,26.5,27.75,29.09,29.97,30.06,29.53,28.94,28.94,27.78,25.88,23.94,22.34,20.44,18.22,16.38,15.62,15.34,15.19,15.66,16.75,18.09,18.53,18.16,17.78,17.69,17.53,16.97,16.84,17.22,17.41,17.28,17.16,17.78,18.25,18.31,18.12,18.25,18.78,18.62,18.22,17.53,16.53,15.38,13.56,11.91,11.75,12.12,12.47,13.12,14.81,16.88,18.69,20.16,21.75,23.22,23.66,23.38,22.69,22.78,22.38,21.44,20.94,20.75,20.38,19.5,17.84,16.66,15.31,13.81,12.34,11.69,12.0,12.16,11.78,11.69,12.53,12.81,12.25,11.5,11.75,12.06,11.94,12.25,13.44,14.97,16.06,16.28,16.72,17.62,17.56,16.91,16.44,16.38,16.0,15.16,13.81,13.16,12.56,11.69,10.75,10.72,11.53,12.38,13.0,13.69,14.44,14.88,14.41,13.91,14.53,15.34,15.81,15.81,16.16,16.5,16.12,15.03,14.22,13.5,12.66,11.0,9.91,9.25,9.0,8.78,8.44,9.41,11.12,12.0,12.56,13.28,13.94,13.59,12.78,12.41,12.66,13.0,12.22,11.53,11.06,10.41,8.59,7.03,6.94,7.62,8.84,10.06,12.56,15.28,17.44,18.62,20.0,21.66,22.44,22.0,21.31,21.03,20.47,18.78,16.72,15.59,14.75,13.38,11.91,11.31,11.03,10.38,9.0,8.34,9.22,10.5,11.12,12.34,13.75,14.88,15.31,15.72,17.34,18.62,19.5,19.75,20.31,20.97,21.5,21.41,21.31,22.09,22.5,22.0,21.12,20.44,20.0,18.31,16.75,16.53,16.91,17.28,17.12,16.69,16.91,16.41,15.5,15.06,15.75,16.94,17.5,17.88,18.16,18.69,18.19,17.12,16.66,16.47,16.12,14.94,13.78,12.97,11.97,10.69,9.62,10.22,12.09,13.41,14.81,16.69,18.25,18.81,18.5,18.25,17.72,17.09,15.38,13.59,12.59,11.78,10.09,8.69,8.53,9.88,11.16,12.53,14.34,16.28,16.88,16.03,15.09,14.47,13.69,12.09,11.03,11.34,12.44,12.97,13.78,15.09,16.53,16.75,16.12,16.28,17.03,17.0,16.5,16.16,16.56,17.19,17.34,18.19,20.09,21.75,22.16,21.72,21.06,20.69,19.5,18.31,17.69,18.25,18.25,17.69,17.44,17.66,17.66,16.75,16.66,17.16,18.91,19.78,20.09,20.44,20.84,20.5,19.62,19.47,20.0,20.62,20.59,20.41,20.44,20.38,18.5,16.22,14.75,13.88,13.38,13.09,13.34,13.91,13.84,12.94,12.44,13.03,13.72,14.38,15.03,16.19,17.75,18.12,18.0,18.03,18.22,17.0,14.41,11.88,9.94,8.12,6.25,5.62,7.16,9.25,11.34,13.5,15.94,18.34,19.0,18.62,18.09,18.16,17.0,15.59,14.38,13.75,12.66,10.5,8.72,8.22,7.91,7.03,6.88,7.41,8.31,8.22,7.75,7.66,8.31,8.41,8.09,8.41,9.59,10.38,10.28,10.5,11.38,11.72,11.25,10.56,10.31,10.72,10.41,9.59,9.25,9.66,8.94,7.81,6.66,6.03,5.41,3.72,2.25,1.69,1.59,1.19,0.94,1.94,3.56,4.75,5.22,5.56,6.56,7.31,7.72,8.09,10.03,12.03,13.06,13.25,13.84,13.75,12.28,10.0,8.53,7.81,6.84,5.38,4.34,4.56,4.72,4.06,3.44,3.5,3.69,2.75,1.25,0.72,0.44,-0.06,-0.56,0.25,2.31,4.16,5.25,6.06,7.09,7.16,6.16,4.88,4.28,3.81,2.31,0.41,-1.06,-2.25,-4.19,-6.47,-8.03,-8.28,-8.5,-9.19,-9.16,-7.72,-5.81,-3.53,-0.78,3.28,7.5,10.38,12.25,13.72,15.44,16.25,15.91,15.66,15.62,14.84,13.34,11.56,11.22,11.09,10.16,8.53,6.94,4.41,0.5,-3.69,-7.22,-9.59,-11.09,-11.88,-10.91,-7.62,-3.25,1.31,5.56,10.94,15.56,18.03,19.34,20.5,21.12,20.28,19.25,18.59,18.75,18.28,16.66,15.19,14.47,14.06,12.72,11.47,11.56,11.75,11.0,10.38,11.0,12.75,14.91,17.06,19.75,23.0,25.44,25.84,25.09,23.69,20.75,16.38,11.78,8.56,6.56,5.16,4.28,4.94,6.06,7.44,7.66,8.16,9.38,9.97,9.38,8.94,9.16,9.97,10.44,10.84,12.03,13.34,13.94,13.84,14.88,16.91,18.84,19.53,19.47,18.97,16.91,12.97,8.16,3.84,0.38,-3.38,-6.59,-8.53,-9.25,-9.59,-10.03,-9.22,-7.16,-4.97,-3.09,-1.09,1.78,5.25,7.41,9.31,11.56,13.09,13.22,11.94,10.59,8.97,6.5,3.31,0.34,-1.25,-2.22,-2.66,-1.62,1.06,3.94,5.53,6.84,8.5,10.56,12.44,13.84,15.78,17.69,19.0,19.28,19.78,20.88,21.47,20.66,19.53,18.5,16.56,13.09,8.75,4.66,0.62,-3.06,-6.56,-8.75,-9.41,-9.47,-9.62,-9.03,-7.25,-5.25,-4.22,-3.16,-1.06,1.66,4.0,6.88,10.22,13.59,15.75,16.28,15.81,15.22,13.97,11.41,8.81,7.22,6.41,4.59,3.22,2.75,2.94,2.81,2.97,4.44,6.5,8.31,9.25,10.25,11.06,12.06,11.62,11.31,11.88,11.94,11.22,9.88,8.84,8.5,8.12,7.94,8.78,10.53,11.53,11.53,11.16,10.5,9.84,8.06,6.62,6.03,6.38,6.16,5.88,6.31,6.91,6.94,5.97,5.59,5.94,6.22,5.94,5.97,6.72,7.66,7.53,7.0,6.75,6.66,5.59,3.59,2.34,2.06,1.44,0.28,-0.12,0.12,0.53,0.31,-0.06,0.25,1.03,0.62,0.53,0.88,1.97,2.34,2.56,2.75,3.16,3.53,3.56,3.66,4.47,5.03,3.97,2.09,0.62,-0.16,-1.09,-1.47,-0.59,1.03,2.03,2.25,2.03,2.12,1.97,1.16,0.91,1.72,3.41,4.31,4.69,5.22,5.75,4.91,3.47,2.34,2.19,2.16,1.94,2.28,4.03,5.53,5.78,5.84,6.19,6.31,5.97,5.22,5.28,6.22,6.56,6.38,5.75,5.25,3.94,1.31,-1.06,-2.06,-2.53,-3.16,-2.91,-1.69,-0.22,0.84,1.19,1.62,2.62,2.75,2.72,3.0,4.56,5.94,7.19,8.66,10.31,11.78,11.78,11.28,10.91,11.19,10.62,9.62,9.0,8.78,7.25,4.78,1.97,0.03,-1.5,-2.91,-3.56,-3.19,-2.47,-2.44,-2.91,-3.28,-3.78,-5.06,-7.06,-8.75,-9.34,-9.31,-9.0,-8.34,-6.38,-4.59,-3.5,-2.91,-1.25,0.03,0.59,0.97,1.69,2.88,3.69,4.09,4.69,6.19,7.34,7.94,8.38,9.81,10.44,10.31,9.88,9.72,9.38,8.0,5.44,2.94,0.53,-1.97,-4.06,-5.19,-4.5,-3.25,-2.75,-2.06,-0.75,0.75,2.22,3.94,6.41,9.03,11.03,11.41,11.31,10.47,9.06,6.22,3.09,0.84,-1.25,-3.75,-5.72,-6.69,-7.22,-7.62,-7.94,-7.38,-5.91,-4.69,-3.53,-2.16,-0.78,0.25,0.22,-0.31,-0.09,-0.09,-0.53,-0.78,-0.97,-1.19,-1.0,-1.69,-1.94,-1.44,-1.12,-2.03,-3.47,-4.38,-5.75,-8.0,-10.16,-10.5,-9.78,-8.72,-7.22,-4.53,-1.78,-0.22,0.0,-0.38,-0.88,-2.31,-4.62,-6.22,-6.38,-6.03,-6.0,-5.69,-4.5,-3.06,-2.19,-1.56,-0.84,-0.31,-1.19,-3.12,-5.38,-6.94,-8.41,-10.06,-11.34,-11.84,-12.53,-13.47,-14.81,-15.31,-14.94,-14.19,-13.09,-11.19,-8.88,-6.81,-5.91,-5.31,-5.06,-4.81,-5.75,-6.97,-7.34,-7.47,-7.91,-8.5,-8.44,-8.22,-8.44,-9.16,-9.22,-8.44,-6.78,-5.44,-4.38,-3.06,-2.47,-3.31,-4.69,-5.41,-5.47,-5.69,-6.47,-6.78,-7.0,-7.88,-9.81,-11.5,-12.88,-14.0,-15.84,-16.84,-16.28,-14.94,-13.22,-10.72,-7.47,-4.41,-2.38,-1.94,-2.0,-2.34,-2.91,-4.22,-4.75,-4.53,-3.5,-3.41,-3.56,-3.12,-2.66,-3.25,-4.72,-5.56,-6.12,-6.75,-8.38,-9.03,-9.0,-8.97,-9.47,-9.34,-8.56,-6.88,-6.22,-5.69,-4.69,-2.97,-2.5,-3.09,-2.97,-2.44,-1.97,-2.12,-1.88,-1.16,-0.78,-1.59,-2.81,-3.84,-4.38,-5.34,-6.62,-6.44,-5.12,-3.97,-3.31,-1.69,0.16,1.34,1.03,0.25,-0.41,-1.19,-3.19,-5.16,-5.88,-5.75,-6.19,-6.19,-5.44,-4.19,-3.62,-4.0,-4.25,-4.22,-4.53,-5.72,-6.44,-6.06,-4.84,-4.25,-3.25,-1.59,0.72,1.91,2.66,3.25,4.31,4.59,4.16,3.72,3.31,2.91,0.97,-0.59,-1.5,-1.81,-2.38,-2.97,-2.66,-1.81,-1.56,-1.66,-1.94,-1.84,-2.31,-3.25,-3.59,-2.28,-0.31,1.03,2.28,3.62,4.41,3.66,2.62,1.59,1.19,0.59,-0.38,-1.59,-2.12,-2.94,-5.06,-7.22,-8.59,-9.53,-10.19,-10.56,-9.56,-7.56,-6.62,-6.31,-6.03,-5.0,-4.53,-4.56,-4.31,-3.22,-2.84,-3.56,-4.44,-4.47,-3.41,-3.53,-3.62,-2.72,-2.0,-2.09,-2.88,-3.41,-3.38,-3.34,-3.59,-3.91,-2.81,-2.0,-2.38,-3.0,-3.34,-3.16,-3.72,-4.59,-4.88,-5.06,-5.69,-6.84,-7.41,-6.47:0.59,1.25,2.19,4.16,6.44,8.16,10.09,12.69,15.84,17.59,18.78,19.28,19.16,17.88,15.75,13.97,13.66,13.84,14.22,14.84,16.75,18.84,19.66,19.97,20.38,20.38,19.56,18.41,18.09,18.66,19.59,20.03,21.06,23.25,25.31,26.5,27.75,29.09,29.97,30.06,29.53,28.94,28.94,27.78,25.88,23.94,22.34,20.44,18.22,16.38,15.62,15.34,15.19,15.66,16.75,18.09,18.53,18.16,17.78,17.69,17.53,16.97,16.84,17.22,17.41,17.28,17.16,17.78,18.25,18.31,18.12,18.25,18.78,18.62,18.22,17.53,16.53,15.38,13.56,11.91,11.75,12.12,12.47,13.12,14.81,16.88,18.69,20.16,21.75,23.22,23.66,23.38,22.69,22.78,22.38,21.44,20.94,20.75,20.38,19.5,17.84,16.66,15.31,13.81,12.34,11.69,12.0,12.16,11.78,11.69,12.53,12.81,12.25,11.5,11.75,12.06,11.94,12.25,13.44,14.97,16.06,16.28,16.72,17.62,17.56,16.91,16.44,16.38,16.0,15.16,13.81,13.16,12.56,11.69,10.75,10.72,11.53,12.38,13.0,13.69,14.44,14.88,14.41,13.91,14.53,15.34,15.81,15.81,16.16,16.5,16.12,15.03,14.22,13.5,12.66,11.0,9.91,9.25,9.0,8.78,8.44,9.41,11.12,12.0,12.56,13.28,13.94,13.59,12.78,12.41,12.66,13.0,12.22,11.53,11.06,10.41,8.59,7.03,6.94,7.62,8.84,10.06,12.56,15.28,17.44,18.62,20.0,21.66,22.44,22.0,21.31,21.03,20.47,18.78,16.72,15.59,14.75,13.38,11.91,11.31,11.03,10.38,9.0,8.34,9.22,10.5,11.12,12.34,13.75,14.88,15.31,15.72,17.34,18.62,19.5,19.75,20.31,20.97,21.5,21.41,21.31,22.09,22.5,22.0,21.12,20.44,20.0,18.31,16.75,16.53,16.91,17.28,17.12,16.69,16.91,16.41,15.5,15.06,15.75,16.94,17.5,17.88,18.16,18.69,18.19,17.12,16.66,16.47,16.12,14.94,13.78,12.97,11.97,10.69,9.62,10.22,12.09,13.41,14.81,16.69,18.25,18.81,18.5,18.25,17.72,17.09,15.38,13.59,12.59,11.78,10.09,8.69,8.53,9.88,11.16,12.53,14.34,16.28,16.88,16.03,15.09,14.47,13.69,12.09,11.03,11.34,12.44,12.97,13.78,15.09,16.53,16.75,16.12,16.28,17.03,17.0,16.5,16.16,16.56,17.19,17.34,18.19,20.09,21.75,22.16,21.72,21.06,20.69,19.5,18.31,17.69,18.25,18.25,17.69,17.44,17.66,17.66,16.75,16.66,17.16,18.91,19.78,20.09,20.44,20.84,20.5,19.62,19.47,20.0,20.62,20.59,20.41,20.44,20.38,18.5,16.22,14.75,13.88,13.38,13.09,13.34,13.91,13.84,12.94,12.44,13.03,13.72,14.38,15.03,16.19,17.75,18.12,18.0,18.03,18.22,17.0,14.41,11.88,9.94,8.12,6.25,5.62,7.16,9.25,11.34,13.5,15.94,18.34,19.0,18.62,18.09,18.16,17.0,15.59,14.38,13.75,12.66,10.5,8.72,8.22,7.91,7.03,6.88,7.41,8.31,8.22,7.75,7.66,8.31,8.41,8.09,8.41,9.59,10.38,10.28,10.5,11.38,11.72,11.25,10.56,10.31,10.72,10.41,9.59,9.25,9.66,8.94,7.81,6.66,6.03,5.41,3.72,2.25,1.69,1.59,1.19,0.94,1.94,3.56,4.75,5.22,5.56,6.56,7.31,7.72,8.09,10.03,12.03,13.06,13.25,13.84,13.75,12.28,10.0,8.53,7.81,6.84,5.38,4.34,4.56,4.72,4.06,3.44,3.5,3.69,2.75,1.25,0.72,0.44,-0.06,-0.56,0.25,2.31,4.16,5.25,6.06,7.09,7.16,6.16,4.88,4.28,3.81,2.31,0.41,-1.06,-2.25,-4.19,-6.47,-8.03,-8.28,-8.5,-9.19,-9.16,-7.72,-5.81,-3.53,-0.78,3.28,7.5,10.38,12.25,13.72,15.44,16.25,15.91,15.66,15.62,14.84,13.34,11.56,11.22,11.09,10.16,8.53,6.94,4.41,0.5,-3.69,-7.22,-9.59,-11.09,-11.88,-10.91,-7.62,-3.25,1.31,5.56,10.94,15.56,18.03,19.34,20.5,21.12,20.28,19.25,18.59,18.75,18.28,16.66,15.19,14.47,14.06,12.72,11.47,11.56,11.75,11.0,10.38,11.0,12.75,14.91,17.06,19.75,23.0,25.44,25.84,25.09,23.69,20.75,16.38,11.78,8.56,6.56,5.16,4.28,4.94,6.06,7.44,7.66,8.16,9.38,9.97,9.38,8.94,9.16,9.97,10.44,10.84,12.03,13.34,13.94,13.84,14.88,16.91,18.84,19.53,19.47,18.97,16.91,12.97,8.16,3.84,0.38,-3.38,-6.59,-8.53,-9.25,-9.59,-10.03,-9.22,-7.16,-4.97,-3.09,-1.09,1.78,5.25,7.41,9.31,11.56,13.09,13.22,11.94,10.59,8.97,6.5,3.31,0.34,-1.25,-2.22,-2.66,-1.62,1.06,3.94,5.53,6.84,8.5,10.56,12.44,13.84,15.78,17.69,19.0,19.28,19.78,20.88,21.47,20.66,19.53,18.5,16.56,13.09,8.75,4.66,0.62,-3.06,-6.56,-8.75,-9.41,-9.47,-9.62,-9.03,-7.25,-5.25,-4.22,-3.16,-1.06,1.66,4.0,6.88,10.22,13.59,15.75,16.28,15.81,15.22,13.97,11.41,8.81,7.22,6.41,4.59,3.22,2.75,2.94,2.81,2.97,4.44,6.5,8.31,9.25,10.25,11.06,12.06,11.62,11.31,11.88,11.94,11.22,9.88,8.84,8.5,8.12,7.94,8.78,10.53,11.53,11.53,11.16,10.5,9.84,8.06,6.62,6.03,6.38,6.16,5.88,6.31,6.91,6.94,5.97,5.59,5.94,6.22,5.94,5.97,6.72,7.66,7.53,7.0,6.75,6.66,5.59,3.59,2.34,2.06,1.44,0.28,-0.12,0.12,0.53,0.31,-0.06,0.25,1.03,0.62,0.53,0.88,1.97,2.34,2.56,2.75,3.16,3.53,3.56,3.66,4.47,5.03,3.97,2.09,0.62,-0.16,-1.09,-1.47,-0.59,1.03,2.03,2.25,2.03,2.12,1.97,1.16,0.91,1.72,3.41,4.31,4.69,5.22,5.75,4.91,3.47,2.34,2.19,2.16,1.94,2.28,4.03,5.53,5.78,5.84,6.19,6.31,5.97,5.22,5.28,6.22,6.56,6.38,5.75,5.25,3.94,1.31,-1.06,-2.06,-2.53,-3.16,-2.91,-1.69,-0.22,0.84,1.19,1.62,2.62,2.75,2.72,3.0,4.56,5.94,7.19,8.66,10.31,11.78,11.78,11.28,10.91,11.19,10.62,9.62,9.0,8.78,7.25,4.78,1.97,0.03,-1.5,-2.91,-3.56,-3.19,-2.47,-2.44,-2.91,-3.28,-3.78,-5.06,-7.06,-8.75,-9.34,-9.31,-9.0,-8.34,-6.38,-4.59,-3.5,-2.91,-1.25,0.03,0.59,0.97,1.69,2.88,3.69,4.09,4.69,6.19,7.34,7.94,8.38,9.81,10.44,10.31,9.88,9.72,9.38,8.0,5.44,2.94,0.53,-1.97,-4.06,-5.19,-4.5,-3.25,-2.75,-2.06,-0.75,0.75,2.22,3.94,6.41,9.03,11.03,11.41,11.31,10.47,9.06,6.22,3.09,0.84,-1.25,-3.75,-5.72,-6.69,-7.22,-7.62,-7.94,-7.38,-5.91,-4.69,-3.53,-2.16,-0.78,0.25,0.22,-0.31,-0.09,-0.09,-0.53,-0.78,-0.97,-1.19,-1.0,-1.69,-1.94,-1.44,-1.12,-2.03,-3.47,-4.38,-5.75,-8.0,-10.16,-10.5,-9.78,-8.72,-7.22,-4.53,-1.78,-0.22,0.0,-0.38,-0.88,-2.31,-4.62,-6.22,-6.38,-6.03,-6.0,-5.69,-4.5,-3.06,-2.19,-1.56,-0.84,-0.31,-1.19,-3.12,-5.38,-6.94,-8.41,-10.06,-11.34,-11.84,-12.53,-13.47,-14.81,-15.31,-14.94,-14.19,-13.09,-11.19,-8.88,-6.81,-5.91,-5.31,-5.06,-4.81,-5.75,-6.97,-7.34,-7.47,-7.91,-8.5,-8.44,-8.22,-8.44,-9.16,-9.22,-8.44,-6.78,-5.44,-4.38,-3.06,-2.47,-3.31,-4.69,-5.41,-5.47,-5.69,-6.47,-6.78,-7.0,-7.88,-9.81,-11.5,-12.88,-14.0,-15.84,-16.84,-16.28,-14.94,-13.22,-10.72,-7.47,-4.41,-2.38,-1.94,-2.0,-2.34,-2.91,-4.22,-4.75,-4.53,-3.5,-3.41,-3.56,-3.12,-2.66,-3.25,-4.72,-5.56,-6.12,-6.75,-8.38,-9.03,-9.0,-8.97,-9.47,-9.34,-8.56,-6.88,-6.22,-5.69,-4.69,-2.97,-2.5,-3.09,-2.97,-2.44,-1.97,-2.12,-1.88,-1.16,-0.78,-1.59,-2.81,-3.84,-4.38,-5.34,-6.62,-6.44,-5.12,-3.97,-3.31,-1.69,0.16,1.34,1.03,0.25,-0.41,-1.19,-3.19,-5.16,-5.88,-5.75,-6.19,-6.19,-5.44,-4.19,-3.62,-4.0,-4.25,-4.22,-4.53,-5.72,-6.44,-6.06,-4.84,-4.25,-3.25,-1.59,0.72,1.91,2.66,3.25,4.31,4.59,4.16,3.72,3.31,2.91,0.97,-0.59,-1.5,-1.81,-2.38,-2.97,-2.66,-1.81,-1.56,-1.66,-1.94,-1.84,-2.31,-3.25,-3.59,-2.28,-0.31,1.03,2.28,3.62,4.41,3.66,2.62,1.59,1.19,0.59,-0.38,-1.59,-2.12,-2.94,-5.06,-7.22,-8.59,-9.53,-10.19,-10.56,-9.56,-7.56,-6.62,-6.31,-6.03,-5.0,-4.53,-4.56,-4.31,-3.22,-2.84,-3.56,-4.44,-4.47,-3.41,-3.53,-3.62,-2.72,-2.0,-2.09,-2.88,-3.41,-3.38,-3.34,-3.59,-3.91,-2.81,-2.0,-2.38,-3.0,-3.34,-3.16,-3.72,-4.59,-4.88,-5.06,-5.69,-6.84,-7.41,-6.47,24.97,22.38,20.97,20.41,20.62,21.56,22.81:12.69,15.84,17.59,18.78,19.28,19.16,17.88,15.75,13.97,13.66,13.84,14.22,14.84,16.75,18.84,19.66,19.97,20.38,20.38,19.56,18.41,18.09,18.66,19.59,20.03,21.06,23.25,25.31,26.5,27.75,29.09,29.97,30.06,29.53,28.94,28.94,27.78,25.88,23.94,22.34,20.44,18.22,16.38,15.62,15.34,15.19,15.66,16.75,18.09,18.53,18.16,17.78,17.69,17.53,16.97,16.84,17.22,17.41,17.28,17.16,17.78,18.25,18.31,18.12,18.25,18.78,18.62,18.22,17.53,16.53,15.38,13.56,11.91,11.75,12.12,12.47,13.12,14.81,16.88,18.69,20.16,21.75,23.22,23.66,23.38,22.69,22.78,22.38,21.44,20.94,20.75,20.38,19.5,17.84,16.66,15.31,13.81,12.34,11.69,12.0,12.16,11.78,11.69,12.53,12.81,12.25,11.5,11.75,12.06,11.94,12.25,13.44,14.97,16.06,16.28,16.72,17.62,17.56,16.91,16.44,16.38,16.0,15.16,13.81,13.16,12.56,11.69,10.75,10.72,11.53,12.38,13.0,13.69,14.44,14.88,14.41,13.91,14.53,15.34,15.81,15.81,16.16,16.5,16.12,15.03,14.22,13.5,12.66,11.0,9.91,9.25,9.0,8.78,8.44,9.41,11.12,12.0,12.56,13.28,13.94,13.59,12.78,12.41,12.66,13.0,12.22,11.53,11.06,10.41,8.59,7.03,6.94,7.62,8.84,10.06,12.56,15.28,17.44,18.62,20.0,21.66,22.44,22.0,21.31,21.03,20.47,18.78,16.72,15.59,14.75,13.38,11.91,11.31,11.03,10.38,9.0,8.34,9.22,10.5,11.12,12.34,13.75,14.88,15.31,15.72,17.34,18.62,19.5,19.75,20.31,20.97,21.5,21.41,21.31,22.09,22.5,22.0,21.12,20.44,20.0,18.31,16.75,16.53,16.91,17.28,17.12,16.69,16.91,16.41,15.5,15.06,15.75,16.94,17.5,17.88,18.16,18.69,18.19,17.12,16.66,16.47,16.12,14.94,13.78,12.97,11.97,10.69,9.62,10.22,12.09,13.41,14.81,16.69,18.25,18.81,18.5,18.25,17.72,17.09,15.38,13.59,12.59,11.78,10.09,8.69,8.53,9.88,11.16,12.53,14.34,16.28,16.88,16.03,15.09,14.47,13.69,12.09,11.03,11.34,12.44,12.97,13.78,15.09,16.53,16.75,16.12,16.28,17.03,17.0,16.5,16.16,16.56,17.19,17.34,18.19,20.09,21.75,22.16,21.72,21.06,20.69,19.5,18.31,17.69,18.25,18.25,17.69,17.44,17.66,17.66,16.75,16.66,17.16,18.91,19.78,20.09,20.44,20.84,20.5,19.62,19.47,20.0,20.62,20.59,20.41,20.44,20.38,18.5,16.22,14.75,13.88,13.38,13.09,13.34,13.91,13.84,12.94,12.44,13.03,13.72,14.38,15.03,16.19,17.75,18.12,18.0,18.03,18.22,17.0,14.41,11.88,9.94,8.12,6.25,5.62,7.16,9.25,11.34,13.5,15.94,18.34,19.0,18.62,18.09,18.16,17.0,15.59,14.38,13.75,12.66,10.5,8.72,8.22,7.91,7.03,6.88,7.41,8.31,8.22,7.75,7.66,8.31,8.41,8.09,8.41,9.59,10.38,10.28,10.5,11.38,11.72,11.25,10.56,10.31,10.72,10.41,9.59,9.25,9.66,8.94,7.81,6.66,6.03,5.41,3.72,2.25,1.69,1.59,1.19,0.94,1.94,3.56,4.75,5.22,5.56,6.56,7.31,7.72,8.09,10.03,12.03,13.06,13.25,13.84,13.75,12.28,10.0,8.53,7.81,6.84,5.38,4.34,4.56,4.72,4.06,3.44,3.5,3.69,2.75,1.25,0.72,0.44,-0.06,-0.56,0.25,2.31,4.16,5.25,6.06,7.09,7.16,6.16,4.88,4.28,3.81,2.31,0.41,-1.06,-2.25,-4.19,-6.47,-8.03,-8.28,-8.5,-9.19,-9.16,-7.72,-5.81,-3.53,-0.78,3.28,7.5,10.38,12.25,13.72,15.44,16.25,15.91,15.66,15.62,14.84,13.34,11.56,11.22,11.09,10.16,8.53,6.94,4.41,0.5,-3.69,-7.22,-9.59,-11.09,-11.88,-10.91,-7.62,-3.25,1.31,5.56,10.94,15.56,18.03,19.34,20.5,21.12,20.28,19.25,18.59,18.75,18.28,16.66,15.19,14.47,14.06,12.72,11.47,11.56,11.75,11.0,10.38,11.0,12.75,14.91,17.06,19.75,23.0,25.44,25.84,25.09,23.69,20.75,16.38,11.78,8.56,6.56,5.16,4.28,4.94,6.06,7.44,7.66,8.16,9.38,9.97,9.38,8.94,9.16,9.97,10.44,10.84,12.03,13.34,13.94,13.84,14.88,16.91,18.84,19.53,19.47,18.97,16.91,12.97,8.16,3.84,0.38,-3.38,-6.59,-8.53,-9.25,-9.59,-10.03,-9.22,-7.16,-4.97,-3.09,-1.09,1.78,5.25,7.41,9.31,11.56,13.09,13.22,11.94,10.59,8.97,6.5,3.31,0.34,-1.25,-2.22,-2.66,-1.62,1.06,3.94,5.53,6.84,8.5,10.56,12.44,13.84,15.78,17.69,19.0,19.28,19.78,20.88,21.47,20.66,19.53,18.5,16.56,13.09,8.75,4.66,0.62,-3.06,-6.56,-8.75,-9.41,-9.47,-9.62,-9.03,-7.25,-5.25,-4.22,-3.16,-1.06,1.66,4.0,6.88,10.22,13.59,15.75,16.28,15.81,15.22,13.97,11.41,8.81,7.22,6.41,4.59,3.22,2.75,2.94,2.81,2.97,4.44,6.5,8.31,9.25,10.25,11.06,12.06,11.62,11.31,11.88,11.94,11.22,9.88,8.84,8.5,8.12,7.94,8.78,10.53,11.53,11.53,11.16,10.5,9.84,8.06,6.62,6.03,6.38,6.16,5.88,6.31,6.91,6.94,5.97,5.59,5.94,6.22,5.94,5.97,6.72,7.66,7.53,7.0,6.75,6.66,5.59,3.59,2.34,2.06,1.44,0.28,-0.12,0.12,0.53,0.31,-0.06,0.25,1.03,0.62,0.53,0.88,1.97,2.34,2.56,2.75,3.16,3.53,3.56,3.66,4.47,5.03,3.97,2.09,0.62,-0.16,-1.09,-1.47,-0.59,1.03,2.03,2.25,2.03,2.12,1.97,1.16,0.91,1.72,3.41,4.31,4.69,5.22,5.75,4.91,3.47,2.34,2.19,2.16,1.94,2.28,4.03,5.53,5.78,5.84,6.19,6.31,5.97,5.22,5.28,6.22,6.56,6.38,5.75,5.25,3.94,1.31,-1.06,-2.06,-2.53,-3.16,-2.91,-1.69,-0.22,0.84,1.19,1.62,2.62,2.75,2.72,3.0,4.56,5.94,7.19,8.66,10.31,11.78,11.78,11.28,10.91,11.19,10.62,9.62,9.0,8.78,7.25,4.78,1.97,0.03,-1.5,-2.91,-3.56,-3.19,-2.47,-2.44,-2.91,-3.28,-3.78,-5.06,-7.06,-8.75,-9.34,-9.31,-9.0,-8.34,-6.38,-4.59,-3.5,-2.91,-1.25,0.03,0.59,0.97,1.69,2.88,3.69,4.09,4.69,6.19,7.34,7.94,8.38,9.81,10.44,10.31,9.88,9.72,9.38,8.0,5.44,2.94,0.53,-1.97,-4.06,-5.19,-4.5,-3.25,-2.75,-2.06,-0.75,0.75,2.22,3.94,6.41,9.03,11.03,11.41,11.31,10.47,9.06,6.22,3.09,0.84,-1.25,-3.75,-5.72,-6.69,-7.22,-7.62,-7.94,-7.38,-5.91,-4.69,-3.53,-2.16,-0.78,0.25,0.22,-0.31,-0.09,-0.09,-0.53,-0.78,-0.97,-1.19,-1.0,-1.69,-1.94,-1.44,-1.12,-2.03,-3.47,-4.38,-5.75,-8.0,-10.16,-10.5,-9.78,-8.72,-7.22,-4.53,-1.78,-0.22,0.0,-0.38,-0.88,-2.31,-4.62,-6.22,-6.38,-6.03,-6.0,-5.69,-4.5,-3.06,-2.19,-1.56,-0.84,-0.31,-1.19,-3.12,-5.38,-6.94,-8.41,-10.06,-11.34,-11.84,-12.53,-13.47,-14.81,-15.31,-14.94,-14.19,-13.09,-11.19,-8.88,-6.81,-5.91,-5.31,-5.06,-4.81,-5.75,-6.97,-7.34,-7.47,-7.91,-8.5,-8.44,-8.22,-8.44,-9.16,-9.22,-8.44,-6.78,-5.44,-4.38,-3.06,-2.47,-3.31,-4.69,-5.41,-5.47,-5.69,-6.47,-6.78,-7.0,-7.88,-9.81,-11.5,-12.88,-14.0,-15.84,-16.84,-16.28,-14.94,-13.22,-10.72,-7.47,-4.41,-2.38,-1.94,-2.0,-2.34,-2.91,-4.22,-4.75,-4.53,-3.5,-3.41,-3.56,-3.12,-2.66,-3.25,-4.72,-5.56,-6.12,-6.75,-8.38,-9.03,-9.0,-8.97,-9.47,-9.34,-8.56,-6.88,-6.22,-5.69,-4.69,-2.97,-2.5,-3.09,-2.97,-2.44,-1.97,-2.12,-1.88,-1.16,-0.78,-1.59,-2.81,-3.84,-4.38,-5.34,-6.62,-6.44,-5.12,-3.97,-3.31,-1.69,0.16,1.34,1.03,0.25,-0.41,-1.19,-3.19,-5.16,-5.88,-5.75,-6.19,-6.19,-5.44,-4.19,-3.62,-4.0,-4.25,-4.22,-4.53,-5.72,-6.44,-6.06,-4.84,-4.25,-3.25,-1.59,0.72,1.91,2.66,3.25,4.31,4.59,4.16,3.72,3.31,2.91,0.97,-0.59,-1.5,-1.81,-2.38,-2.97,-2.66,-1.81,-1.56,-1.66,-1.94,-1.84,-2.31,-3.25,-3.59,-2.28,-0.31,1.03,2.28,3.62,4.41,3.66,2.62,1.59,1.19,0.59,-0.38,-1.59,-2.12,-2.94,-5.06,-7.22,-8.59,-9.53,-10.19,-10.56,-9.56,-7.56,-6.62,-6.31,-6.03,-5.0,-4.53,-4.56,-4.31,-3.22,-2.84,-3.56,-4.44,-4.47,-3.41,-3.53,-3.62,-2.72,-2.0,-2.09,-2.88,-3.41,-3.38,-3.34,-3.59,-3.91,-2.81,-2.0,-2.38,-3.0,-3.34,-3.16,-3.72,-4.59,-4.88,-5.06,-5.69,-6.84,-7.41,-6.47,24.97,22.38,20.97,20.41,20.62,21.56,22.81,24.72,26.34,28.25,30.19,32.5,35.12,37.78:15.75,13.97,13.66,13.84,14.22,14.84,16.75,18.84,19.66,19.97,20.38,20.38,19.56,18.41,18.09,18.66,19.59,20.03,21.06,23.25,25.31,26.5,27.75,29.09,29.97,30.06,29.53,28.94,28.94,27.78,25.88,23.94,22.34,20.44,18.22,16.38,15.62,15.34,15.19,15.66,16.75,18.09,18.53,18.16,17.78,17.69,17.53,16.97,16.84,17.22,17.41,17.28,17.16,17.78,18.25,18.31,18.12,18.25,18.78,18.62,18.22,17.53,16.53,15.38,13.56,11.91,11.75,12.12,12.47,13.12,14.81,16.88,18.69,20.16,21.75,23.22,23.66,23.38,22.69,22.78,22.38,21.44,20.94,20.75,20.38,19.5,17.84,16.66,15.31,13.81,12.34,11.69,12.0,12.16,11.78,11.69,12.53,12.81,12.25,11.5,11.75,12.06,11.94,12.25,13.44,14.97,16.06,16.28,16.72,17.62,17.56,16.91,16.44,16.38,16.0,15.16,13.81,13.16,12.56,11.69,10.75,10.72,11.53,12.38,13.0,13.69,14.44,14.88,14.41,13.91,14.53,15.34,15.81,15.81,16.16,16.5,16.12,15.03,14.22,13.5,12.66,11.0,9.91,9.25,9.0,8.78,8.44,9.41,11.12,12.0,12.56,13.28,13.94,13.59,12.78,12.41,12.66,13.0,12.22,11.53,11.06,10.41,8.59,7.03,6.94,7.62,8.84,10.06,12.56,15.28,17.44,18.62,20.0,21.66,22.44,22.0,21.31,21.03,20.47,18.78,16.72,15.59,14.75,13.38,11.91,11.31,11.03,10.38,9.0,8.34,9.22,10.5,11.12,12.34,13.75,14.88,15.31,15.72,17.34,18.62,19.5,19.75,20.31,20.97,21.5,21.41,21.31,22.09,22.5,22.0,21.12,20.44,20.0,18.31,16.75,16.53,16.91,17.28,17.12,16.69,16.91,16.41,15.5,15.06,15.75,16.94,17.5,17.88,18.16,18.69,18.19,17.12,16.66,16.47,16.12,14.94,13.78,12.97,11.97,10.69,9.62,10.22,12.09,13.41,14.81,16.69,18.25,18.81,18.5,18.25,17.72,17.09,15.38,13.59,12.59,11.78,10.09,8.69,8.53,9.88,11.16,12.53,14.34,16.28,16.88,16.03,15.09,14.47,13.69,12.09,11.03,11.34,12.44,12.97,13.78,15.09,16.53,16.75,16.12,16.28,17.03,17.0,16.5,16.16,16.56,17.19,17.34,18.19,20.09,21.75,22.16,21.72,21.06,20.69,19.5,18.31,17.69,18.25,18.25,17.69,17.44,17.66,17.66,16.75,16.66,17.16,18.91,19.78,20.09,20.44,20.84,20.5,19.62,19.47,20.0,20.62,20.59,20.41,20.44,20.38,18.5,16.22,14.75,13.88,13.38,13.09,13.34,13.91,13.84,12.94,12.44,13.03,13.72,14.38,15.03,16.19,17.75,18.12,18.0,18.03,18.22,17.0,14.41,11.88,9.94,8.12,6.25,5.62,7.16,9.25,11.34,13.5,15.94,18.34,19.0,18.62,18.09,18.16,17.0,15.59,14.38,13.75,12.66,10.5,8.72,8.22,7.91,7.03,6.88,7.41,8.31,8.22,7.75,7.66,8.31,8.41,8.09,8.41,9.59,10.38,10.28,10.5,11.38,11.72,11.25,10.56,10.31,10.72,10.41,9.59,9.25,9.66,8.94,7.81,6.66,6.03,5.41,3.72,2.25,1.69,1.59,1.19,0.94,1.94,3.56,4.75,5.22,5.56,6.56,7.31,7.72,8.09,10.03,12.03,13.06,13.25,13.84,13.75,12.28,10.0,8.53,7.81,6.84,5.38,4.34,4.56,4.72,4.06,3.44,3.5,3.69,2.75,1.25,0.72,0.44,-0.06,-0.56,0.25,2.31,4.16,5.25,6.06,7.09,7.16,6.16,4.88,4.28,3.81,2.31,0.41,-1.06,-2.25,-4.19,-6.47,-8.03,-8.28,-8.5,-9.19,-9.16,-7.72,-5.81,-3.53,-0.78,3.28,7.5,10.38,12.25,13.72,15.44,16.25,15.91,15.66,15.62,14.84,13.34,11.56,11.22,11.09,10.16,8.53,6.94,4.41,0.5,-3.69,-7.22,-9.59,-11.09,-11.88,-10.91,-7.62,-3.25,1.31,5.56,10.94,15.56,18.03,19.34,20.5,21.12,20.28,19.25,18.59,18.75,18.28,16.66,15.19,14.47,14.06,12.72,11.47,11.56,11.75,11.0,10.38,11.0,12.75,14.91,17.06,19.75,23.0,25.44,25.84,25.09,23.69,20.75,16.38,11.78,8.56,6.56,5.16,4.28,4.94,6.06,7.44,7.66,8.16,9.38,9.97,9.38,8.94,9.16,9.97,10.44,10.84,12.03,13.34,13.94,13.84,14.88,16.91,18.84,19.53,19.47,18.97,16.91,12.97,8.16,3.84,0.38,-3.38,-6.59,-8.53,-9.25,-9.59,-10.03,-9.22,-7.16,-4.97,-3.09,-1.09,1.78,5.25,7.41,9.31,11.56,13.09,13.22,11.94,10.59,8.97,6.5,3.31,0.34,-1.25,-2.22,-2.66,-1.62,1.06,3.94,5.53,6.84,8.5,10.56,12.44,13.84,15.78,17.69,19.0,19.28,19.78,20.88,21.47,20.66,19.53,18.5,16.56,13.09,8.75,4.66,0.62,-3.06,-6.56,-8.75,-9.41,-9.47,-9.62,-9.03,-7.25,-5.25,-4.22,-3.16,-1.06,1.66,4.0,6.88,10.22,13.59,15.75,16.28,15.81,15.22,13.97,11.41,8.81,7.22,6.41,4.59,3.22,2.75,2.94,2.81,2.97,4.44,6.5,8.31,9.25,10.25,11.06,12.06,11.62,11.31,11.88,11.94,11.22,9.88,8.84,8.5,8.12,7.94,8.78,10.53,11.53,11.53,11.16,10.5,9.84,8.06,6.62,6.03,6.38,6.16,5.88,6.31,6.91,6.94,5.97,5.59,5.94,6.22,5.94,5.97,6.72,7.66,7.53,7.0,6.75,6.66,5.59,3.59,2.34,2.06,1.44,0.28,-0.12,0.12,0.53,0.31,-0.06,0.25,1.03,0.62,0.53,0.88,1.97,2.34,2.56,2.75,3.16,3.53,3.56,3.66,4.47,5.03,3.97,2.09,0.62,-0.16,-1.09,-1.47,-0.59,1.03,2.03,2.25,2.03,2.12,1.97,1.16,0.91,1.72,3.41,4.31,4.69,5.22,5.75,4.91,3.47,2.34,2.19,2.16,1.94,2.28,4.03,5.53,5.78,5.84,6.19,6.31,5.97,5.22,5.28,6.22,6.56,6.38,5.75,5.25,3.94,1.31,-1.06,-2.06,-2.53,-3.16,-2.91,-1.69,-0.22,0.84,1.19,1.62,2.62,2.75,2.72,3.0,4.56,5.94,7.19,8.66,10.31,11.78,11.78,11.28,10.91,11.19,10.62,9.62,9.0,8.78,7.25,4.78,1.97,0.03,-1.5,-2.91,-3.56,-3.19,-2.47,-2.44,-2.91,-3.28,-3.78,-5.06,-7.06,-8.75,-9.34,-9.31,-9.0,-8.34,-6.38,-4.59,-3.5,-2.91,-1.25,0.03,0.59,0.97,1.69,2.88,3.69,4.09,4.69,6.19,7.34,7.94,8.38,9.81,10.44,10.31,9.88,9.72,9.38,8.0,5.44,2.94,0.53,-1.97,-4.06,-5.19,-4.5,-3.25,-2.75,-2.06,-0.75,0.75,2.22,3.94,6.41,9.03,11.03,11.41,11.31,10.47,9.06,6.22,3.09,0.84,-1.25,-3.75,-5.72,-6.69,-7.22,-7.62,-7.94,-7.38,-5.91,-4.69,-3.53,-2.16,-0.78,0.25,0.22,-0.31,-0.09,-0.09,-0.53,-0.78,-0.97,-1.19,-1.0,-1.69,-1.94,-1.44,-1.12,-2.03,-3.47,-4.38,-5.75,-8.0,-10.16,-10.5,-9.78,-8.72,-7.22,-4.53,-1.78,-0.22,0.0,-0.38,-0.88,-2.31,-4.62,-6.22,-6.38,-6.03,-6.0,-5.69,-4.5,-3.06,-2.19,-1.56,-0.84,-0.31,-1.19,-3.12,-5.38,-6.94,-8.41,-10.06,-11.34,-11.84,-12.53,-13.47,-14.81,-15.31,-14.94,-14.19,-13.09,-11.19,-8.88,-6.81,-5.91,-5.31,-5.06,-4.81,-5.75,-6.97,-7.34,-7.47,-7.91,-8.5,-8.44,-8.22,-8.44,-9.16,-9.22,-8.44,-6.78,-5.44,-4.38,-3.06,-2.47,-3.31,-4.69,-5.41,-5.47,-5.69,-6.47,-6.78,-7.0,-7.88,-9.81,-11.5,-12.88,-14.0,-15.84,-16.84,-16.28,-14.94,-13.22,-10.72,-7.47,-4.41,-2.38,-1.94,-2.0,-2.34,-2.91,-4.22,-4.75,-4.53,-3.5,-3.41,-3.56,-3.12,-2.66,-3.25,-4.72,-5.56,-6.12,-6.75,-8.38,-9.03,-9.0,-8.97,-9.47,-9.34,-8.56,-6.88,-6.22,-5.69,-4.69,-2.97,-2.5,-3.09,-2.97,-2.44,-1.97,-2.12,-1.88,-1.16,-0.78,-1.59,-2.81,-3.84,-4.38,-5.34,-6.62,-6.44,-5.12,-3.97,-3.31,-1.69,0.16,1.34,1.03,0.25,-0.41,-1.19,-3.19,-5.16,-5.88,-5.75,-6.19,-6.19,-5.44,-4.19,-3.62,-4.0,-4.25,-4.22,-4.53,-5.72,-6.44,-6.06,-4.84,-4.25,-3.25,-1.59,0.72,1.91,2.66,3.25,4.31,4.59,4.16,3.72,3.31,2.91,0.97,-0.59,-1.5,-1.81,-2.38,-2.97,-2.66,-1.81,-1.56,-1.66,-1.94,-1.84,-2.31,-3.25,-3.59,-2.28,-0.31,1.03,2.28,3.62,4.41,3.66,2.62,1.59,1.19,0.59,-0.38,-1.59,-2.12,-2.94,-5.06,-7.22,-8.59,-9.53,-10.19,-10.56,-9.56,-7.56,-6.62,-6.31,-6.03,-5.0,-4.53,-4.56,-4.31,-3.22,-2.84,-3.56,-4.44,-4.47,-3.41,-3.53,-3.62,-2.72,-2.0,-2.09,-2.88,-3.41,-3.38,-3.34,-3.59,-3.91,-2.81,-2.0,-2.38,-3.0,-3.34,-3.16,-3.72,-4.59,-4.88,-5.06,-5.69,-6.84,-7.41,-6.47,24.97,22.38,20.97,20.41,20.62,21.56,22.81,24.72,26.34,28.25,30.19,32.5,35.12,37.78,40.12,42.28,43.53,43.88,43.16,41.69,39.59:18.84,19.66,19.97,20.38,20.38,19.56,18.41,18.09,18.66,19.59,20.03,21.06,23.25,25.31,26.5,27.75,29.09,29.97,30.06,29.53,28.94,28.94,27.78,25.88,23.94,22.34,20.44,18.22,16.38,15.62,15.34,15.19,15.66,16.75,18.09,18.53,18.16,17.78,17.69,17.53,16.97,16.84,17.22,17.41,17.28,17.16,17.78,18.25,18.31,18.12,18.25,18.78,18.62,18.22,17.53,16.53,15.38,13.56,11.91,11.75,12.12,12.47,13.12,14.81,16.88,18.69,20.16,21.75,23.22,23.66,23.38,22.69,22.78,22.38,21.44,20.94,20.75,20.38,19.5,17.84,16.66,15.31,13.81,12.34,11.69,12.0,12.16,11.78,11.69,12.53,12.81,12.25,11.5,11.75,12.06,11.94,12.25,13.44,14.97,16.06,16.28,16.72,17.62,17.56,16.91,16.44,16.38,16.0,15.16,13.81,13.16,12.56,11.69,10.75,10.72,11.53,12.38,13.0,13.69,14.44,14.88,14.41,13.91,14.53,15.34,15.81,15.81,16.16,16.5,16.12,15.03,14.22,13.5,12.66,11.0,9.91,9.25,9.0,8.78,8.44,9.41,11.12,12.0,12.56,13.28,13.94,13.59,12.78,12.41,12.66,13.0,12.22,11.53,11.06,10.41,8.59,7.03,6.94,7.62,8.84,10.06,12.56,15.28,17.44,18.62,20.0,21.66,22.44,22.0,21.31,21.03,20.47,18.78,16.72,15.59,14.75,13.38,11.91,11.31,11.03,10.38,9.0,8.34,9.22,10.5,11.12,12.34,13.75,14.88,15.31,15.72,17.34,18.62,19.5,19.75,20.31,20.97,21.5,21.41,21.31,22.09,22.5,22.0,21.12,20.44,20.0,18.31,16.75,16.53,16.91,17.28,17.12,16.69,16.91,16.41,15.5,15.06,15.75,16.94,17.5,17.88,18.16,18.69,18.19,17.12,16.66,16.47,16.12,14.94,13.78,12.97,11.97,10.69,9.62,10.22,12.09,13.41,14.81,16.69,18.25,18.81,18.5,18.25,17.72,17.09,15.38,13.59,12.59,11.78,10.09,8.69,8.53,9.88,11.16,12.53,14.34,16.28,16.88,16.03,15.09,14.47,13.69,12.09,11.03,11.34,12.44,12.97,13.78,15.09,16.53,16.75,16.12,16.28,17.03,17.0,16.5,16.16,16.56,17.19,17.34,18.19,20.09,21.75,22.16,21.72,21.06,20.69,19.5,18.31,17.69,18.25,18.25,17.69,17.44,17.66,17.66,16.75,16.66,17.16,18.91,19.78,20.09,20.44,20.84,20.5,19.62,19.47,20.0,20.62,20.59,20.41,20.44,20.38,18.5,16.22,14.75,13.88,13.38,13.09,13.34,13.91,13.84,12.94,12.44,13.03,13.72,14.38,15.03,16.19,17.75,18.12,18.0,18.03,18.22,17.0,14.41,11.88,9.94,8.12,6.25,5.62,7.16,9.25,11.34,13.5,15.94,18.34,19.0,18.62,18.09,18.16,17.0,15.59,14.38,13.75,12.66,10.5,8.72,8.22,7.91,7.03,6.88,7.41,8.31,8.22,7.75,7.66,8.31,8.41,8.09,8.41,9.59,10.38,10.28,10.5,11.38,11.72,11.25,10.56,10.31,10.72,10.41,9.59,9.25,9.66,8.94,7.81,6.66,6.03,5.41,3.72,2.25,1.69,1.59,1.19,0.94,1.94,3.56,4.75,5.22,5.56,6.56,7.31,7.72,8.09,10.03,12.03,13.06,13.25,13.84,13.75,12.28,10.0,8.53,7.81,6.84,5.38,4.34,4.56,4.72,4.06,3.44,3.5,3.69,2.75,1.25,0.72,0.44,-0.06,-0.56,0.25,2.31,4.16,5.25,6.06,7.09,7.16,6.16,4.88,4.28,3.81,2.31,0.41,-1.06,-2.25,-4.19,-6.47,-8.03,-8.28,-8.5,-9.19,-9.16,-7.72,-5.81,-3.53,-0.78,3.28,7.5,10.38,12.25,13.72,15.44,16.25,15.91,15.66,15.62,14.84,13.34,11.56,11.22,11.09,10.16,8.53,6.94,4.41,0.5,-3.69,-7.22,-9.59,-11.09,-11.88,-10.91,-7.62,-3.25,1.31,5.56,10.94,15.56,18.03,19.34,20.5,21.12,20.28,19.25,18.59,18.75,18.28,16.66,15.19,14.47,14.06,12.72,11.47,11.56,11.75,11.0,10.38,11.0,12.75,14.91,17.06,19.75,23.0,25.44,25.84,25.09,23.69,20.75,16.38,11.78,8.56,6.56,5.16,4.28,4.94,6.06,7.44,7.66,8.16,9.38,9.97,9.38,8.94,9.16,9.97,10.44,10.84,12.03,13.34,13.94,13.84,14.88,16.91,18.84,19.53,19.47,18.97,16.91,12.97,8.16,3.84,0.38,-3.38,-6.59,-8.53,-9.25,-9.59,-10.03,-9.22,-7.16,-4.97,-3.09,-1.09,1.78,5.25,7.41,9.31,11.56,13.09,13.22,11.94,10.59,8.97,6.5,3.31,0.34,-1.25,-2.22,-2.66,-1.62,1.06,3.94,5.53,6.84,8.5,10.56,12.44,13.84,15.78,17.69,19.0,19.28,19.78,20.88,21.47,20.66,19.53,18.5,16.56,13.09,8.75,4.66,0.62,-3.06,-6.56,-8.75,-9.41,-9.47,-9.62,-9.03,-7.25,-5.25,-4.22,-3.16,-1.06,1.66,4.0,6.88,10.22,13.59,15.75,16.28,15.81,15.22,13.97,11.41,8.81,7.22,6.41,4.59,3.22,2.75,2.94,2.81,2.97,4.44,6.5,8.31,9.25,10.25,11.06,12.06,11.62,11.31,11.88,11.94,11.22,9.88,8.84,8.5,8.12,7.94,8.78,10.53,11.53,11.53,11.16,10.5,9.84,8.06,6.62,6.03,6.38,6.16,5.88,6.31,6.91,6.94,5.97,5.59,5.94,6.22,5.94,5.97,6.72,7.66,7.53,7.0,6.75,6.66,5.59,3.59,2.34,2.06,1.44,0.28,-0.12,0.12,0.53,0.31,-0.06,0.25,1.03,0.62,0.53,0.88,1.97,2.34,2.56,2.75,3.16,3.53,3.56,3.66,4.47,5.03,3.97,2.09,0.62,-0.16,-1.09,-1.47,-0.59,1.03,2.03,2.25,2.03,2.12,1.97,1.16,0.91,1.72,3.41,4.31,4.69,5.22,5.75,4.91,3.47,2.34,2.19,2.16,1.94,2.28,4.03,5.53,5.78,5.84,6.19,6.31,5.97,5.22,5.28,6.22,6.56,6.38,5.75,5.25,3.94,1.31,-1.06,-2.06,-2.53,-3.16,-2.91,-1.69,-0.22,0.84,1.19,1.62,2.62,2.75,2.72,3.0,4.56,5.94,7.19,8.66,10.31,11.78,11.78,11.28,10.91,11.19,10.62,9.62,9.0,8.78,7.25,4.78,1.97,0.03,-1.5,-2.91,-3.56,-3.19,-2.47,-2.44,-2.91,-3.28,-3.78,-5.06,-7.06,-8.75,-9.34,-9.31,-9.0,-8.34,-6.38,-4.59,-3.5,-2.91,-1.25,0.03,0.59,0.97,1.69,2.88,3.69,4.09,4.69,6.19,7.34,7.94,8.38,9.81,10.44,10.31,9.88,9.72,9.38,8.0,5.44,2.94,0.53,-1.97,-4.06,-5.19,-4.5,-3.25,-2.75,-2.06,-0.75,0.75,2.22,3.94,6.41,9.03,11.03,11.41,11.31,10.47,9.06,6.22,3.09,0.84,-1.25,-3.75,-5.72,-6.69,-7.22,-7.62,-7.94,-7.38,-5.91,-4.69,-3.53,-2.16,-0.78,0.25,0.22,-0.31,-0.09,-0.09,-0.53,-0.78,-0.97,-1.19,-1.0,-1.69,-1.94,-1.44,-1.12,-2.03,-3.47,-4.38,-5.75,-8.0,-10.16,-10.5,-9.78,-8.72,-7.22,-4.53,-1.78,-0.22,0.0,-0.38,-0.88,-2.31,-4.62,-6.22,-6.38,-6.03,-6.0,-5.69,-4.5,-3.06,-2.19,-1.56,-0.84,-0.31,-1.19,-3.12,-5.38,-6.94,-8.41,-10.06,-11.34,-11.84,-12.53,-13.47,-14.81,-15.31,-14.94,-14.19,-13.09,-11.19,-8.88,-6.81,-5.91,-5.31,-5.06,-4.81,-5.75,-6.97,-7.34,-7.47,-7.91,-8.5,-8.44,-8.22,-8.44,-9.16,-9.22,-8.44,-6.78,-5.44,-4.38,-3.06,-2.47,-3.31,-4.69,-5.41,-5.47,-5.69,-6.47,-6.78,-7.0,-7.88,-9.81,-11.5,-12.88,-14.0,-15.84,-16.84,-16.28,-14.94,-13.22,-10.72,-7.47,-4.41,-2.38,-1.94,-2.0,-2.34,-2.91,-4.22,-4.75,-4.53,-3.5,-3.41,-3.56,-3.12,-2.66,-3.25,-4.72,-5.56,-6.12,-6.75,-8.38,-9.03,-9.0,-8.97,-9.47,-9.34,-8.56,-6.88,-6.22,-5.69,-4.69,-2.97,-2.5,-3.09,-2.97,-2.44,-1.97,-2.12,-1.88,-1.16,-0.78,-1.59,-2.81,-3.84,-4.38,-5.34,-6.62,-6.44,-5.12,-3.97,-3.31,-1.69,0.16,1.34,1.03,0.25,-0.41,-1.19,-3.19,-5.16,-5.88,-5.75,-6.19,-6.19,-5.44,-4.19,-3.62,-4.0,-4.25,-4.22,-4.53,-5.72,-6.44,-6.06,-4.84,-4.25,-3.25,-1.59,0.72,1.91,2.66,3.25,4.31,4.59,4.16,3.72,3.31,2.91,0.97,-0.59,-1.5,-1.81,-2.38,-2.97,-2.66,-1.81,-1.56,-1.66,-1.94,-1.84,-2.31,-3.25,-3.59,-2.28,-0.31,1.03,2.28,3.62,4.41,3.66,2.62,1.59,1.19,0.59,-0.38,-1.59,-2.12,-2.94,-5.06,-7.22,-8.59,-9.53,-10.19,-10.56,-9.56,-7.56,-6.62,-6.31,-6.03,-5.0,-4.53,-4.56,-4.31,-3.22,-2.84,-3.56,-4.44,-4.47,-3.41,-3.53,-3.62,-2.72,-2.0,-2.09,-2.88,-3.41,-3.38,-3.34,-3.59,-3.91,-2.81,-2.0,-2.38,-3.0,-3.34,-3.16,-3.72,-4.59,-4.88,-5.06,-5.69,-6.84,-7.41,-6.47,24.97,22.38,20.97,20.41,20.62,21.56,22.81,24.72,26.34,28.25,30.19,32.5,35.12,37.78,40.12,42.28,43.53,43.88,43.16,41.69,39.59,37.72,35.81,34.62,34.34,34.78,35.22,35.78:18.09,18.66,19.59,20.03,21.06,23.25,25.31,26.5,27.75,29.09,29.97,30.06,29.53,28.94,28.94,27.78,25.88,23.94,22.34,20.44,18.22,16.38,15.62,15.34,15.19,15.66,16.75,18.09,18.53,18.16,17.78,17.69,17.53,16.97,16.84,17.22,17.41,17.28,17.16,17.78,18.25,18.31,18.12,18.25,18.78,18.62,18.22,17.53,16.53,15.38,13.56,11.91,11.75,12.12,12.47,13.12,14.81,16.88,18.69,20.16,21.75,23.22,23.66,23.38,22.69,22.78,22.38,21.44,20.94,20.75,20.38,19.5,17.84,16.66,15.31,13.81,12.34,11.69,12.0,12.16,11.78,11.69,12.53,12.81,12.25,11.5,11.75,12.06,11.94,12.25,13.44,14.97,16.06,16.28,16.72,17.62,17.56,16.91,16.44,16.38,16.0,15.16,13.81,13.16,12.56,11.69,10.75,10.72,11.53,12.38,13.0,13.69,14.44,14.88,14.41,13.91,14.53,15.34,15.81,15.81,16.16,16.5,16.12,15.03,14.22,13.5,12.66,11.0,9.91,9.25,9.0,8.78,8.44,9.41,11.12,12.0,12.56,13.28,13.94,13.59,12.78,12.41,12.66,13.0,12.22,11.53,11.06,10.41,8.59,7.03,6.94,7.62,8.84,10.06,12.56,15.28,17.44,18.62,20.0,21.66,22.44,22.0,21.31,21.03,20.47,18.78,16.72,15.59,14.75,13.38,11.91,11.31,11.03,10.38,9.0,8.34,9.22,10.5,11.12,12.34,13.75,14.88,15.31,15.72,17.34,18.62,19.5,19.75,20.31,20.97,21.5,21.41,21.31,22.09,22.5,22.0,21.12,20.44,20.0,18.31,16.75,16.53,16.91,17.28,17.12,16.69,16.91,16.41,15.5,15.06,15.75,16.94,17.5,17.88,18.16,18.69,18.19,17.12,16.66,16.47,16.12,14.94,13.78,12.97,11.97,10.69,9.62,10.22,12.09,13.41,14.81,16.69,18.25,18.81,18.5,18.25,17.72,17.09,15.38,13.59,12.59,11.78,10.09,8.69,8.53,9.88,11.16,12.53,14.34,16.28,16.88,16.03,15.09,14.47,13.69,12.09,11.03,11.34,12.44,12.97,13.78,15.09,16.53,16.75,16.12,16.28,17.03,17.0,16.5,16.16,16.56,17.19,17.34,18.19,20.09,21.75,22.16,21.72,21.06,20.69,19.5,18.31,17.69,18.25,18.25,17.69,17.44,17.66,17.66,16.75,16.66,17.16,18.91,19.78,20.09,20.44,20.84,20.5,19.62,19.47,20.0,20.62,20.59,20.41,20.44,20.38,18.5,16.22,14.75,13.88,13.38,13.09,13.34,13.91,13.84,12.94,12.44,13.03,13.72,14.38,15.03,16.19,17.75,18.12,18.0,18.03,18.22,17.0,14.41,11.88,9.94,8.12,6.25,5.62,7.16,9.25,11.34,13.5,15.94,18.34,19.0,18.62,18.09,18.16,17.0,15.59,14.38,13.75,12.66,10.5,8.72,8.22,7.91,7.03,6.88,7.41,8.31,8.22,7.75,7.66,8.31,8.41,8.09,8.41,9.59,10.38,10.28,10.5,11.38,11.72,11.25,10.56,10.31,10.72,10.41,9.59,9.25,9.66,8.94,7.81,6.66,6.03,5.41,3.72,2.25,1.69,1.59,1.19,0.94,1.94,3.56,4.75,5.22,5.56,6.56,7.31,7.72,8.09,10.03,12.03,13.06,13.25,13.84,13.75,12.28,10.0,8.53,7.81,6.84,5.38,4.34,4.56,4.72,4.06,3.44,3.5,3.69,2.75,1.25,0.72,0.44,-0.06,-0.56,0.25,2.31,4.16,5.25,6.06,7.09,7.16,6.16,4.88,4.28,3.81,2.31,0.41,-1.06,-2.25,-4.19,-6.47,-8.03,-8.28,-8.5,-9.19,-9.16,-7.72,-5.81,-3.53,-0.78,3.28,7.5,10.38,12.25,13.72,15.44,16.25,15.91,15.66,15.62,14.84,13.34,11.56,11.22,11.09,10.16,8.53,6.94,4.41,0.5,-3.69,-7.22,-9.59,-11.09,-11.88,-10.91,-7.62,-3.25,1.31,5.56,10.94,15.56,18.03,19.34,20.5,21.12,20.28,19.25,18.59,18.75,18.28,16.66,15.19,14.47,14.06,12.72,11.47,11.56,11.75,11.0,10.38,11.0,12.75,14.91,17.06,19.75,23.0,25.44,25.84,25.09,23.69,20.75,16.38,11.78,8.56,6.56,5.16,4.28,4.94,6.06,7.44,7.66,8.16,9.38,9.97,9.38,8.94,9.16,9.97,10.44,10.84,12.03,13.34,13.94,13.84,14.88,16.91,18.84,19.53,19.47,18.97,16.91,12.97,8.16,3.84,0.38,-3.38,-6.59,-8.53,-9.25,-9.59,-10.03,-9.22,-7.16,-4.97,-3.09,-1.09,1.78,5.25,7.41,9.31,11.56,13.09,13.22,11.94,10.59,8.97,6.5,3.31,0.34,-1.25,-2.22,-2.66,-1.62,1.06,3.94,5.53,6.84,8.5,10.56,12.44,13.84,15.78,17.69,19.0,19.28,19.78,20.88,21.47,20.66,19.53,18.5,16.56,13.09,8.75,4.66,0.62,-3.06,-6.56,-8.75,-9.41,-9.47,-9.62,-9.03,-7.25,-5.25,-4.22,-3.16,-1.06,1.66,4.0,6.88,10.22,13.59,15.75,16.28,15.81,15.22,13.97,11.41,8.81,7.22,6.41,4.59,3.22,2.75,2.94,2.81,2.97,4.44,6.5,8.31,9.25,10.25,11.06,12.06,11.62,11.31,11.88,11.94,11.22,9.88,8.84,8.5,8.12,7.94,8.78,10.53,11.53,11.53,11.16,10.5,9.84,8.06,6.62,6.03,6.38,6.16,5.88,6.31,6.91,6.94,5.97,5.59,5.94,6.22,5.94,5.97,6.72,7.66,7.53,7.0,6.75,6.66,5.59,3.59,2.34,2.06,1.44,0.28,-0.12,0.12,0.53,0.31,-0.06,0.25,1.03,0.62,0.53,0.88,1.97,2.34,2.56,2.75,3.16,3.53,3.56,3.66,4.47,5.03,3.97,2.09,0.62,-0.16,-1.09,-1.47,-0.59,1.03,2.03,2.25,2.03,2.12,1.97,1.16,0.91,1.72,3.41,4.31,4.69,5.22,5.75,4.91,3.47,2.34,2.19,2.16,1.94,2.28,4.03,5.53,5.78,5.84,6.19,6.31,5.97,5.22,5.28,6.22,6.56,6.38,5.75,5.25,3.94,1.31,-1.06,-2.06,-2.53,-3.16,-2.91,-1.69,-0.22,0.84,1.19,1.62,2.62,2.75,2.72,3.0,4.56,5.94,7.19,8.66,10.31,11.78,11.78,11.28,10.91,11.19,10.62,9.62,9.0,8.78,7.25,4.78,1.97,0.03,-1.5,-2.91,-3.56,-3.19,-2.47,-2.44,-2.91,-3.28,-3.78,-5.06,-7.06,-8.75,-9.34,-9.31,-9.0,-8.34,-6.38,-4.59,-3.5,-2.91,-1.25,0.03,0.59,0.97,1.69,2.88,3.69,4.09,4.69,6.19,7.34,7.94,8.38,9.81,10.44,10.31,9.88,9.72,9.38,8.0,5.44,2.94,0.53,-1.97,-4.06,-5.19,-4.5,-3.25,-2.75,-2.06,-0.75,0.75,2.22,3.94,6.41,9.03,11.03,11.41,11.31,10.47,9.06,6.22,3.09,0.84,-1.25,-3.75,-5.72,-6.69,-7.22,-7.62,-7.94,-7.38,-5.91,-4.69,-3.53,-2.16,-0.78,0.25,0.22,-0.31,-0.09,-0.09,-0.53,-0.78,-0.97,-1.19,-1.0,-1.69,-1.94,-1.44,-1.12,-2.03,-3.47,-4.38,-5.75,-8.0,-10.16,-10.5,-9.78,-8.72,-7.22,-4.53,-1.78,-0.22,0.0,-0.38,-0.88,-2.31,-4.62,-6.22,-6.38,-6.03,-6.0,-5.69,-4.5,-3.06,-2.19,-1.56,-0.84,-0.31,-1.19,-3.12,-5.38,-6.94,-8.41,-10.06,-11.34,-11.84,-12.53,-13.47,-14.81,-15.31,-14.94,-14.19,-13.09,-11.19,-8.88,-6.81,-5.91,-5.31,-5.06,-4.81,-5.75,-6.97,-7.34,-7.47,-7.91,-8.5,-8.44,-8.22,-8.44,-9.16,-9.22,-8.44,-6.78,-5.44,-4.38,-3.06,-2.47,-3.31,-4.69,-5.41,-5.47,-5.69,-6.47,-6.78,-7.0,-7.88,-9.81,-11.5,-12.88,-14.0,-15.84,-16.84,-16.28,-14.94,-13.22,-10.72,-7.47,-4.41,-2.38,-1.94,-2.0,-2.34,-2.91,-4.22,-4.75,-4.53,-3.5,-3.41,-3.56,-3.12,-2.66,-3.25,-4.72,-5.56,-6.12,-6.75,-8.38,-9.03,-9.0,-8.97,-9.47,-9.34,-8.56,-6.88,-6.22,-5.69,-4.69,-2.97,-2.5,-3.09,-2.97,-2.44,-1.97,-2.12,-1.88,-1.16,-0.78,-1.59,-2.81,-3.84,-4.38,-5.34,-6.62,-6.44,-5.12,-3.97,-3.31,-1.69,0.16,1.34,1.03,0.25,-0.41,-1.19,-3.19,-5.16,-5.88,-5.75,-6.19,-6.19,-5.44,-4.19,-3.62,-4.0,-4.25,-4.22,-4.53,-5.72,-6.44,-6.06,-4.84,-4.25,-3.25,-1.59,0.72,1.91,2.66,3.25,4.31,4.59,4.16,3.72,3.31,2.91,0.97,-0.59,-1.5,-1.81,-2.38,-2.97,-2.66,-1.81,-1.56,-1.66,-1.94,-1.84,-2.31,-3.25,-3.59,-2.28,-0.31,1.03,2.28,3.62,4.41,3.66,2.62,1.59,1.19,0.59,-0.38,-1.59,-2.12,-2.94,-5.06,-7.22,-8.59,-9.53,-10.19,-10.56,-9.56,-7.56,-6.62,-6.31,-6.03,-5.0,-4.53,-4.56,-4.31,-3.22,-2.84,-3.56,-4.44,-4.47,-3.41,-3.53,-3.62,-2.72,-2.0,-2.09,-2.88,-3.41,-3.38,-3.34,-3.59,-3.91,-2.81,-2.0,-2.38,-3.0,-3.34,-3.16,-3.72,-4.59,-4.88,-5.06,-5.69,-6.84,-7.41,-6.47,24.97,22.38,20.97,20.41,20.62,21.56,22.81,24.72,26.34,28.25,30.19,32.5,35.12,37.78,40.12,42.28,43.53,43.88,43.16,41.69,39.59,37.72,35.81,34.62,34.34,34.78,35.22,35.78,35.94,36.22,36.5,36.34,36.59,36.88,36.78:26.5,27.75,29.09,29.97,30.06,29.53,28.94,28.94,27.78,25.88,23.94,22.34,20.44,18.22,16.38,15.62,15.34,15.19,15.66,16.75,18.09,18.53,18.16,17.78,17.69,17.53,16.97,16.84,17.22,17.41,17.28,17.16,17.78,18.25,18.31,18.12,18.25,18.78,18.62,18.22,17.53,16.53,15.38,13.56,11.91,11.75,12.12,12.47,13.12,14.81,16.88,18.69,20.16,21.75,23.22,23.66,23.38,22.69,22.78,22.38,21.44,20.94,20.75,20.38,19.5,17.84,16.66,15.31,13.81,12.34,11.69,12.0,12.16,11.78,11.69,12.53,12.81,12.25,11.5,11.75,12.06,11.94,12.25,13.44,14.97,16.06,16.28,16.72,17.62,17.56,16.91,16.44,16.38,16.0,15.16,13.81,13.16,12.56,11.69,10.75,10.72,11.53,12.38,13.0,13.69,14.44,14.88,14.41,13.91,14.53,15.34,15.81,15.81,16.16,16.5,16.12,15.03,14.22,13.5,12.66,11.0,9.91,9.25,9.0,8.78,8.44,9.41,11.12,12.0,12.56,13.28,13.94,13.59,12.78,12.41,12.66,13.0,12.22,11.53,11.06,10.41,8.59,7.03,6.94,7.62,8.84,10.06,12.56,15.28,17.44,18.62,20.0,21.66,22.44,22.0,21.31,21.03,20.47,18.78,16.72,15.59,14.75,13.38,11.91,11.31,11.03,10.38,9.0,8.34,9.22,10.5,11.12,12.34,13.75,14.88,15.31,15.72,17.34,18.62,19.5,19.75,20.31,20.97,21.5,21.41,21.31,22.09,22.5,22.0,21.12,20.44,20.0,18.31,16.75,16.53,16.91,17.28,17.12,16.69,16.91,16.41,15.5,15.06,15.75,16.94,17.5,17.88,18.16,18.69,18.19,17.12,16.66,16.47,16.12,14.94,13.78,12.97,11.97,10.69,9.62,10.22,12.09,13.41,14.81,16.69,18.25,18.81,18.5,18.25,17.72,17.09,15.38,13.59,12.59,11.78,10.09,8.69,8.53,9.88,11.16,12.53,14.34,16.28,16.88,16.03,15.09,14.47,13.69,12.09,11.03,11.34,12.44,12.97,13.78,15.09,16.53,16.75,16.12,16.28,17.03,17.0,16.5,16.16,16.56,17.19,17.34,18.19,20.09,21.75,22.16,21.72,21.06,20.69,19.5,18.31,17.69,18.25,18.25,17.69,17.44,17.66,17.66,16.75,16.66,17.16,18.91,19.78,20.09,20.44,20.84,20.5,19.62,19.47,20.0,20.62,20.59,20.41,20.44,20.38,18.5,16.22,14.75,13.88,13.38,13.09,13.34,13.91,13.84,12.94,12.44,13.03,13.72,14.38,15.03,16.19,17.75,18.12,18.0,18.03,18.22,17.0,14.41,11.88,9.94,8.12,6.25,5.62,7.16,9.25,11.34,13.5,15.94,18.34,19.0,18.62,18.09,18.16,17.0,15.59,14.38,13.75,12.66,10.5,8.72,8.22,7.91,7.03,6.88,7.41,8.31,8.22,7.75,7.66,8.31,8.41,8.09,8.41,9.59,10.38,10.28,10.5,11.38,11.72,11.25,10.56,10.31,10.72,10.41,9.59,9.25,9.66,8.94,7.81,6.66,6.03,5.41,3.72,2.25,1.69,1.59,1.19,0.94,1.94,3.56,4.75,5.22,5.56,6.56,7.31,7.72,8.09,10.03,12.03,13.06,13.25,13.84,13.75,12.28,10.0,8.53,7.81,6.84,5.38,4.34,4.56,4.72,4.06,3.44,3.5,3.69,2.75,1.25,0.72,0.44,-0.06,-0.56,0.25,2.31,4.16,5.25,6.06,7.09,7.16,6.16,4.88,4.28,3.81,2.31,0.41,-1.06,-2.25,-4.19,-6.47,-8.03,-8.28,-8.5,-9.19,-9.16,-7.72,-5.81,-3.53,-0.78,3.28,7.5,10.38,12.25,13.72,15.44,16.25,15.91,15.66,15.62,14.84,13.34,11.56,11.22,11.09,10.16,8.53,6.94,4.41,0.5,-3.69,-7.22,-9.59,-11.09,-11.88,-10.91,-7.62,-3.25,1.31,5.56,10.94,15.56,18.03,19.34,20.5,21.12,20.28,19.25,18.59,18.75,18.28,16.66,15.19,14.47,14.06,12.72,11.47,11.56,11.75,11.0,10.38,11.0,12.75,14.91,17.06,19.75,23.0,25.44,25.84,25.09,23.69,20.75,16.38,11.78,8.56,6.56,5.16,4.28,4.94,6.06,7.44,7.66,8.16,9.38,9.97,9.38,8.94,9.16,9.97,10.44,10.84,12.03,13.34,13.94,13.84,14.88,16.91,18.84,19.53,19.47,18.97,16.91,12.97,8.16,3.84,0.38,-3.38,-6.59,-8.53,-9.25,-9.59,-10.03,-9.22,-7.16,-4.97,-3.09,-1.09,1.78,5.25,7.41,9.31,11.56,13.09,13.22,11.94,10.59,8.97,6.5,3.31,0.34,-1.25,-2.22,-2.66,-1.62,1.06,3.94,5.53,6.84,8.5,10.56,12.44,13.84,15.78,17.69,19.0,19.28,19.78,20.88,21.47,20.66,19.53,18.5,16.56,13.09,8.75,4.66,0.62,-3.06,-6.56,-8.75,-9.41,-9.47,-9.62,-9.03,-7.25,-5.25,-4.22,-3.16,-1.06,1.66,4.0,6.88,10.22,13.59,15.75,16.28,15.81,15.22,13.97,11.41,8.81,7.22,6.41,4.59,3.22,2.75,2.94,2.81,2.97,4.44,6.5,8.31,9.25,10.25,11.06,12.06,11.62,11.31,11.88,11.94,11.22,9.88,8.84,8.5,8.12,7.94,8.78,10.53,11.53,11.53,11.16,10.5,9.84,8.06,6.62,6.03,6.38,6.16,5.88,6.31,6.91,6.94,5.97,5.59,5.94,6.22,5.94,5.97,6.72,7.66,7.53,7.0,6.75,6.66,5.59,3.59,2.34,2.06,1.44,0.28,-0.12,0.12,0.53,0.31,-0.06,0.25,1.03,0.62,0.53,0.88,1.97,2.34,2.56,2.75,3.16,3.53,3.56,3.66,4.47,5.03,3.97,2.09,0.62,-0.16,-1.09,-1.47,-0.59,1.03,2.03,2.25,2.03,2.12,1.97,1.16,0.91,1.72,3.41,4.31,4.69,5.22,5.75,4.91,3.47,2.34,2.19,2.16,1.94,2.28,4.03,5.53,5.78,5.84,6.19,6.31,5.97,5.22,5.28,6.22,6.56,6.38,5.75,5.25,3.94,1.31,-1.06,-2.06,-2.53,-3.16,-2.91,-1.69,-0.22,0.84,1.19,1.62,2.62,2.75,2.72,3.0,4.56,5.94,7.19,8.66,10.31,11.78,11.78,11.28,10.91,11.19,10.62,9.62,9.0,8.78,7.25,4.78,1.97,0.03,-1.5,-2.91,-3.56,-3.19,-2.47,-2.44,-2.91,-3.28,-3.78,-5.06,-7.06,-8.75,-9.34,-9.31,-9.0,-8.34,-6.38,-4.59,-3.5,-2.91,-1.25,0.03,0.59,0.97,1.69,2.88,3.69,4.09,4.69,6.19,7.34,7.94,8.38,9.81,10.44,10.31,9.88,9.72,9.38,8.0,5.44,2.94,0.53,-1.97,-4.06,-5.19,-4.5,-3.25,-2.75,-2.06,-0.75,0.75,2.22,3.94,6.41,9.03,11.03,11.41,11.31,10.47,9.06,6.22,3.09,0.84,-1.25,-3.75,-5.72,-6.69,-7.22,-7.62,-7.94,-7.38,-5.91,-4.69,-3.53,-2.16,-0.78,0.25,0.22,-0.31,-0.09,-0.09,-0.53,-0.78,-0.97,-1.19,-1.0,-1.69,-1.94,-1.44,-1.12,-2.03,-3.47,-4.38,-5.75,-8.0,-10.16,-10.5,-9.78,-8.72,-7.22,-4.53,-1.78,-0.22,0.0,-0.38,-0.88,-2.31,-4.62,-6.22,-6.38,-6.03,-6.0,-5.69,-4.5,-3.06,-2.19,-1.56,-0.84,-0.31,-1.19,-3.12,-5.38,-6.94,-8.41,-10.06,-11.34,-11.84,-12.53,-13.47,-14.81,-15.31,-14.94,-14.19,-13.09,-11.19,-8.88,-6.81,-5.91,-5.31,-5.06,-4.81,-5.75,-6.97,-7.34,-7.47,-7.91,-8.5,-8.44,-8.22,-8.44,-9.16,-9.22,-8.44,-6.78,-5.44,-4.38,-3.06,-2.47,-3.31,-4.69,-5.41,-5.47,-5.69,-6.47,-6.78,-7.0,-7.88,-9.81,-11.5,-12.88,-14.0,-15.84,-16.84,-16.28,-14.94,-13.22,-10.72,-7.47,-4.41,-2.38,-1.94,-2.0,-2.34,-2.91,-4.22,-4.75,-4.53,-3.5,-3.41,-3.56,-3.12,-2.66,-3.25,-4.72,-5.56,-6.12,-6.75,-8.38,-9.03,-9.0,-8.97,-9.47,-9.34,-8.56,-6.88,-6.22,-5.69,-4.69,-2.97,-2.5,-3.09,-2.97,-2.44,-1.97,-2.12,-1.88,-1.16,-0.78,-1.59,-2.81,-3.84,-4.38,-5.34,-6.62,-6.44,-5.12,-3.97,-3.31,-1.69,0.16,1.34,1.03,0.25,-0.41,-1.19,-3.19,-5.16,-5.88,-5.75,-6.19,-6.19,-5.44,-4.19,-3.62,-4.0,-4.25,-4.22,-4.53,-5.72,-6.44,-6.06,-4.84,-4.25,-3.25,-1.59,0.72,1.91,2.66,3.25,4.31,4.59,4.16,3.72,3.31,2.91,0.97,-0.59,-1.5,-1.81,-2.38,-2.97,-2.66,-1.81,-1.56,-1.66,-1.94,-1.84,-2.31,-3.25,-3.59,-2.28,-0.31,1.03,2.28,3.62,4.41,3.66,2.62,1.59,1.19,0.59,-0.38,-1.59,-2.12,-2.94,-5.06,-7.22,-8.59,-9.53,-10.19,-10.56,-9.56,-7.56,-6.62,-6.31,-6.03,-5.0,-4.53,-4.56,-4.31,-3.22,-2.84,-3.56,-4.44,-4.47,-3.41,-3.53,-3.62,-2.72,-2.0,-2.09,-2.88,-3.41,-3.38,-3.34,-3.59,-3.91,-2.81,-2.0,-2.38,-3.0,-3.34,-3.16,-3.72,-4.59,-4.88,-5.06,-5.69,-6.84,-7.41,-6.47,24.97,22.38,20.97,20.41,20.62,21.56,22.81,24.72,26.34,28.25,30.19,32.5,35.12,37.78,40.12,42.28,43.53,43.88,43.16,41.69,39.59,37.72,35.81,34.62,34.34,34.78,35.22,35.78,35.94,36.22,36.5,36.34,36.59,36.88,36.78,36.69,36.75,37.56,38.5,40.03,42.22,44.62:negativity
-11.31,-11.78,-11.25,-10.06,-9.44,-7.88,-5.44,-2.38,-0.28,0.84,2.12,3.16,2.94,2.38,2.12,2.38,2.41,1.47,0.12,-0.5,-1.19,-2.72,-4.28,-4.94,-5.56,-6.88,-8.62,-9.69,-10.53,-11.22,-12.31,-12.56,-11.66,-10.0,-9.09,-7.72,-5.38,-2.66,-1.0,0.62,2.44,3.94,4.72,4.38,4.31,4.69,4.66,3.44,2.31,1.78,1.5,0.0,-1.34,-2.16,-3.0,-4.78,-6.41,-7.06,-6.59,-6.03,-5.41,-4.09,-1.53,0.56,1.47,1.91,2.59,3.25,2.56,2.59,4.0,6.34,7.81,9.06,10.47,11.06,10.47,8.12,5.97,4.62,4.0,3.09,2.69,2.91,3.06,1.72,0.59,-0.38,-0.69,-1.78,-2.94,-3.66,-3.66,-3.41,-3.41,-3.31,-2.53,-1.72,-2.03,-2.66,-2.03,-0.94,-0.72,-0.78,-0.5,-0.12,-0.69,-2.47,-4.03,-5.12,-6.44,-8.47,-10.34,-10.88,-11.09,-12.31,-13.12,-12.78,-11.97,-11.91,-11.47,-10.78,-9.31,-8.66,-8.25,-7.81,-7.0,-6.53,-7.19,-7.94,-8.16,-8.41,-9.53,-11.28,-12.0,-12.16,-13.12,-13.88,-14.41,-13.62,-13.09,-13.31,-13.38,-12.91,-12.5,-12.97,-13.06,-12.19,-10.81,-10.56,-11.34,-11.84,-12.31,-13.5,-14.5,-14.88,-13.81,-12.53,-12.06,-10.97,-9.22,-7.56,-6.44,-5.41,-3.41,-1.25,-0.03,0.44,0.88,1.78,1.88,1.38,1.0,1.41,1.66,1.41,0.41,-0.22,-0.88,-2.69,-5.22,-6.22,-6.44,-7.0,-7.94,-7.91,-6.97,-6.25,-6.06,-5.38,-3.66,-2.25,-1.66,-1.81,-1.5,-1.97,-3.75,-6.0,-7.47,-8.06,-8.88,-10.06,-9.75,-8.28,-6.72,-5.66,-5.06,-4.12,-4.09,-5.03,-5.94,-5.22,-3.5,-2.12,-0.88,0.72,3.12,4.12,3.88,3.38,3.09,2.19,0.62,-0.88,-0.94,-0.97,-1.94,-3.09,-3.53,-3.41,-4.31,-5.12,-4.78,-3.66,-2.5,-1.62,-0.62,1.56,3.25,3.75,3.47,3.78,3.53,2.34,0.69,0.66,1.69,2.88,4.22,6.16,8.66,10.72,11.12,11.66,12.88,13.28,12.31,10.09,8.09,5.78,2.16,-1.5,-3.44,-4.16,-4.56,-4.41,-3.34,-1.5,-0.72,-1.12,-2.03,-2.41,-1.88,-1.44,-0.72,1.25,2.69,2.72,1.5,0.47,-0.28,-1.0,-2.09,-2.38,-1.28,0.06,0.72,1.59,3.75,6.19,7.84,8.78,10.31,10.62,9.34,6.5,3.03,-0.03,-3.19,-7.03,-10.31,-12.56,-14.56,-17.09,-18.81,-18.88,-17.88,-16.88,-15.28,-12.16,-7.88,-3.47,0.69,6.0,11.0,14.81,16.94,17.78,18.62,18.44,17.5,16.47,16.41,16.41,16.0,14.81,14.12,13.44,12.56,11.0,10.53,11.09,11.66,12.16,13.28,15.78,18.59,20.56,22.06,23.88,25.22,25.25,24.09,23.12,22.06,20.44,17.75,15.62,14.31,12.69,9.66,6.44,3.72,1.03,-2.22,-5.09,-6.19,-6.47,-6.28,-6.09,-4.22,-0.72,3.28,6.56,10.09,14.09,16.91,18.56,19.56,20.56,21.16,20.38,18.22,16.38,14.62,11.94,8.25,5.28,2.66,0.53,-2.09,-3.62,-3.12,-1.28,0.47,2.34,5.19,8.03,10.12,11.47,13.94,16.91,19.56,21.03,22.25,23.16,22.91,20.09,16.94,14.03,11.16,7.56,4.5,2.66,1.09,-0.72,-3.31,-4.34,-3.88,-2.81,-1.81,-0.19,1.66,2.62,2.06,1.19,1.0,1.44,1.53,1.62,2.47,3.78,4.91,5.5,6.75,9.03,11.22,12.12,12.59,13.28,13.62,12.56,11.34,10.84,10.5,8.91,6.59,4.59,2.72,0.69,-1.31,-2.06,-1.78,-1.09,-1.16,-1.03,-0.31,1.22,2.25,3.72,6.09,8.84,11.16,12.12,12.84,13.19,12.84,11.03,9.47,9.03,9.31,9.0,8.88,9.38,9.66,8.97,7.72,7.16,7.25,7.0,6.53,7.16,8.5,10.03,10.28,10.03,10.34,10.06,8.41,7.78,8.12,9.28,10.28,10.94,11.97,13.22,13.5,12.88,12.47,12.72,12.88,12.0,11.66,11.62,11.69,10.56,8.97,8.38,8.0,7.75,7.53,8.31,10.03,11.06,11.88,13.44,16.09,18.91,20.59,21.5,22.12,22.25,21.06,18.97,17.34,15.88,13.56,10.78,8.94,8.19,7.41,6.19,5.06,4.75,4.69,4.16,3.97,4.66,5.69,6.25,6.12,6.44,7.31,7.91,8.34,9.41,11.81,13.78,14.91,15.28,15.44,14.97,13.06,11.0,9.47,8.78,8.09,7.56,7.84,9.84,11.09,12.09,12.62,13.47,13.31,11.94,10.19,8.88,8.38,7.19,6.38,6.38,6.81,7.03,6.88,7.38,8.56,9.69,9.97,10.41,11.53,12.75,12.88,12.41,11.97,11.22,9.41,7.41,5.84,5.34,4.66,3.69,3.12,3.59,4.09,4.06,4.09,4.84,6.06,7.12,8.31,10.5,13.06,14.34,14.75,14.91,15.69,16.31,16.38,16.66,17.69,18.16,17.22,15.84,15.03,14.19,13.19,12.5,12.22,12.28,11.62,10.22,8.69,7.91,6.97,5.56,4.06,3.5,3.19,2.59,1.94,2.44,3.09,3.38,3.25,3.72,4.97,6.0,6.5,7.12,8.66,9.72,9.44,8.62,8.19,7.09,5.66,4.53,4.28,4.91,5.59,6.0,6.78,8.44,9.88,10.59,11.16,12.06,12.28,11.72,10.78,10.97,11.62,11.56,11.31,10.88,10.44,9.22,7.22,5.56,4.56,3.56,2.44,1.44,2.06,2.88,2.66,1.81,1.44,1.09,0.62,0.25,0.94,2.5,3.69,3.81,3.69,4.0,3.56,2.28,1.19,1.25,2.56,4.34,6.41,10.06,13.66,16.69,18.47,19.78,20.75,20.84,19.22,17.31,15.94,14.03,11.97,10.16,9.5,9.56,9.62,10.0,11.22,13.38,14.84,15.16,15.06,14.84,14.09,12.06,9.84,8.62,7.41,6.28,5.62,6.84,9.47,12.44,15.19,19.03,23.22,26.75,29.19,30.72,32.25,32.69,31.66,30.38,29.78,29.41,28.56,27.03,25.78,23.75,20.88,17.16,13.47,10.97,9.34,8.34,8.84,11.06,14.72,17.22,19.38,21.56,22.53,22.03,20.47,19.16,18.59,17.97,16.56,15.84,15.47,14.94,13.03,11.56,10.12,9.28,7.97,6.66,6.56,7.28,7.62,7.41,7.41,7.22,6.38,4.44,2.31,1.38,0.66,-0.56,-1.44,-1.09,0.22,1.28,3.16,6.44,10.88,15.0,18.38,21.22,23.28,24.22,23.09,21.91,20.91,19.72,17.56,15.62,14.16,13.62,13.06,12.41,13.09,14.66,16.03,16.31,16.84,17.0,16.69,14.94,13.12,12.19,11.84,11.44,11.59,12.94,15.34,16.53,16.91,16.81,16.19,15.12,13.03,11.66,11.88,13.19,14.06,15.09,16.28,16.41,14.56,12.0,9.72,8.0,6.97,6.0,6.28,7.69,9.44,10.5,11.72,13.69,15.84,17.09,18.28,20.19,22.12,22.78,22.28,21.66,20.69,18.5,15.31,12.19,9.66,7.09,3.78,1.38,0.06,-0.03,-0.56,-0.41,0.75,2.59,3.84,4.94,6.81,9.28,11.59,12.5,13.16,14.31,15.44,15.78,16.38,17.41,18.25,17.44,15.84,14.28,13.72,12.75,11.78,11.22,11.16,10.78,9.62,8.62,9.0,9.81,9.81,9.81,10.12,11.06,11.06,11.5,12.66,14.56,15.97,16.53,16.56,16.78,16.06,14.41,12.75,12.38,11.59,9.75,7.25,4.97,2.69,0.31,-1.25,-1.62,-0.62,0.31,1.0,1.47,2.38,2.88,2.5,1.88,2.5,3.84,5.19,6.19,8.12,10.59,12.12,12.81,13.62,14.91,15.62,14.81,13.88,13.97,13.91,12.88,12.5,13.41,15.09,16.19,17.25,18.84,20.81,21.47,21.69,22.0,22.88,23.12,21.88,20.25,19.47,18.94,17.84,16.81,17.0,17.25,16.84,15.72,15.06,15.31,15.34,14.56,13.97,14.25,14.25,12.91,11.34,10.31,9.94,9.12,8.69,9.38,10.44,10.25,9.09,7.78,7.88,8.62,9.59,11.62,14.88,17.47,18.75,19.34,20.69,22.75,23.81,24.53,26.5,28.72,29.5,29.25,28.41,27.0,24.41,20.47,16.69,14.56,12.78,10.97,9.12,8.31,8.0,7.09,6.78,7.66,9.88,12.19,13.94,15.47,16.91,17.66,17.16,16.09,15.84,15.59,14.59,12.97,12.31,12.41,12.28,11.72,12.03,13.03,13.53,13.28,13.28,14.88,16.12,16.5,16.19,16.81,16.84,15.97,14.53,13.91,13.47,12.25,10.53,9.41,9.75,10.34,10.91,11.5,12.88,13.5,13.09,11.88,10.94,10.62,10.31,9.5,9.81,11.47,13.16,14.41,16.41,19.16,21.12,21.53,21.38,21.22,20.09,18.16,15.66,14.12,13.19,12.25,11.16,11.06,11.84,11.97,11.75,11.5,12.12,12.59,12.12,12.03,13.38,15.62,17.94,19.62,22.09,24.12,24.72,23.53,22.44,21.88,20.66,19.0,17.84,17.72,17.22,15.78,14.25,13.5,13.16,12.44,11.59,11.97,13.44,15.0,16.0,17.78,19.72,20.56,20.09,19.22,19.06,19.28,18.69,17.69,17.5,17.06,16.19,14.59,14.19,14.19,14.16,12.56,11.22,10.81,10.31,9.47,9.69,11.88,14.34,16.06,17.22,18.88,19.97,20.28,19.34,18.41,17.28,15.06,11.88,9.03,7.62,6.75,5.5,4.69,5.31,6.16,6.31,6.03,6.97,7.56,7.78,7.62,8.0,8.72,9.56,9.59,9.75,10.47:-2.38,-0.28,0.84,2.12,3.16,2.94,2.38,2.12,2.38,2.41,1.47,0.12,-0.5,-1.19,-2.72,-4.28,-4.94,-5.56,-6.88,-8.62,-9.69,-10.53,-11.22,-12.31,-12.56,-11.66,-10.0,-9.09,-7.72,-5.38,-2.66,-1.0,0.62,2.44,3.94,4.72,4.38,4.31,4.69,4.66,3.44,2.31,1.78,1.5,0.0,-1.34,-2.16,-3.0,-4.78,-6.41,-7.06,-6.59,-6.03,-5.41,-4.09,-1.53,0.56,1.47,1.91,2.59,3.25,2.56,2.59,4.0,6.34,7.81,9.06,10.47,11.06,10.47,8.12,5.97,4.62,4.0,3.09,2.69,2.91,3.06,1.72,0.59,-0.38,-0.69,-1.78,-2.94,-3.66,-3.66,-3.41,-3.41,-3.31,-2.53,-1.72,-2.03,-2.66,-2.03,-0.94,-0.72,-0.78,-0.5,-0.12,-0.69,-2.47,-4.03,-5.12,-6.44,-8.47,-10.34,-10.88,-11.09,-12.31,-13.12,-12.78,-11.97,-11.91,-11.47,-10.78,-9.31,-8.66,-8.25,-7.81,-7.0,-6.53,-7.19,-7.94,-8.16,-8.41,-9.53,-11.28,-12.0,-12.16,-13.12,-13.88,-14.41,-13.62,-13.09,-13.31,-13.38,-12.91,-12.5,-12.97,-13.06,-12.19,-10.81,-10.56,-11.34,-11.84,-12.31,-13.5,-14.5,-14.88,-13.81,-12.53,-12.06,-10.97,-9.22,-7.56,-6.44,-5.41,-3.41,-1.25,-0.03,0.44,0.88,1.78,1.88,1.38,1.0,1.41,1.66,1.41,0.41,-0.22,-0.88,-2.69,-5.22,-6.22,-6.44,-7.0,-7.94,-7.91,-6.97,-6.25,-6.06,-5.38,-3.66,-2.25,-1.66,-1.81,-1.5,-1.97,-3.75,-6.0,-7.47,-8.06,-8.88,-10.06,-9.75,-8.28,-6.72,-5.66,-5.06,-4.12,-4.09,-5.03,-5.94,-5.22,-3.5,-2.12,-0.88,0.72,3.12,4.12,3.88,3.38,3.09,2.19,0.62,-0.88,-0.94,-0.97,-1.94,-3.09,-3.53,-3.41,-4.31,-5.12,-4.78,-3.66,-2.5,-1.62,-0.62,1.56,3.25,3.75,3.47,3.78,3.53,2.34,0.69,0.66,1.69,2.88,4.22,6.16,8.66,10.72,11.12,11.66,12.88,13.28,12.31,10.09,8.09,5.78,2.16,-1.5,-3.44,-4.16,-4.56,-4.41,-3.34,-1.5,-0.72,-1.12,-2.03,-2.41,-1.88,-1.44,-0.72,1.25,2.69,2.72,1.5,0.47,-0.28,-1.0,-2.09,-2.38,-1.28,0.06,0.72,1.59,3.75,6.19,7.84,8.78,10.31,10.62,9.34,6.5,3.03,-0.03,-3.19,-7.03,-10.31,-12.56,-14.56,-17.09,-18.81,-18.88,-17.88,-16.88,-15.28,-12.16,-7.88,-3.47,0.69,6.0,11.0,14.81,16.94,17.78,18.62,18.44,17.5,16.47,16.41,16.41,16.0,14.81,14.12,13.44,12.56,11.0,10.53,11.09,11.66,12.16,13.28,15.78,18.59,20.56,22.06,23.88,25.22,25.25,24.09,23.12,22.06,20.44,17.75,15.62,14.31,12.69,9.66,6.44,3.72,1.03,-2.22,-5.09,-6.19,-6.47,-6.28,-6.09,-4.22,-0.72,3.28,6.56,10.09,14.09,16.91,18.56,19.56,20.56,21.16,20.38,18.22,16.38,14.62,11.94,8.25,5.28,2.66,0.53,-2.09,-3.62,-3.12,-1.28,0.47,2.34,5.19,8.03,10.12,11.47,13.94,16.91,19.56,21.03,22.25,23.16,22.91,20.09,16.94,14.03,11.16,7.56,4.5,2.66,1.09,-0.72,-3.31,-4.34,-3.88,-2.81,-1.81,-0.19,1.66,2.62,2.06,1.19,1.0,1.44,1.53,1.62,2.47,3.78,4.91,5.5,6.75,9.03,11.22,12.12,12.59,13.28,13.62,12.56,11.34,10.84,10.5,8.91,6.59,4.59,2.72,0.69,-1.31,-2.06,-1.78,-1.09,-1.16,-1.03,-0.31,1.22,2.25,3.72,6.09,8.84,11.16,12.12,12.84,13.19,12.84,11.03,9.47,9.03,9.31,9.0,8.88,9.38,9.66,8.97,7.72,7.16,7.25,7.0,6.53,7.16,8.5,10.03,10.28,10.03,10.34,10.06,8.41,7.78,8.12,9.28,10.28,10.94,11.97,13.22,13.5,12.88,12.47,12.72,12.88,12.0,11.66,11.62,11.69,10.56,8.97,8.38,8.0,7.75,7.53,8.31,10.03,11.06,11.88,13.44,16.09,18.91,20.59,21.5,22.12,22.25,21.06,18.97,17.34,15.88,13.56,10.78,8.94,8.19,7.41,6.19,5.06,4.75,4.69,4.16,3.97,4.66,5.69,6.25,6.12,6.44,7.31,7.91,8.34,9.41,11.81,13.78,14.91,15.28,15.44,14.97,13.06,11.0,9.47,8.78,8.09,7.56,7.84,9.84,11.09,12.09,12.62,13.47,13.31,11.94,10.19,8.88,8.38,7.19,6.38,6.38,6.81,7.03,6.88,7.38,8.56,9.69,9.97,10.41,11.53,12.75,12.88,12.41,11.97,11.22,9.41,7.41,5.84,5.34,4.66,3.69,3.12,3.59,4.09,4.06,4.09,4.84,6.06,7.12,8.31,10.5,13.06,14.34,14.75,14.91,15.69,16.31,16.38,16.66,17.69,18.16,17.22,15.84,15.03,14.19,13.19,12.5,12.22,12.28,11.62,10.22,8.69,7.91,6.97,5.56,4.06,3.5,3.19,2.59,1.94,2.44,3.09,3.38,3.25,3.72,4.97,6.0,6.5,7.12,8.66,9.72,9.44,8.62,8.19,7.09,5.66,4.53,4.28,4.91,5.59,6.0,6.78,8.44,9.88,10.59,11.16,12.06,12.28,11.72,10.78,10.97,11.62,11.56,11.31,10.88,10.44,9.22,7.22,5.56,4.56,3.56,2.44,1.44,2.06,2.88,2.66,1.81,1.44,1.09,0.62,0.25,0.94,2.5,3.69,3.81,3.69,4.0,3.56,2.28,1.19,1.25,2.56,4.34,6.41,10.06,13.66,16.69,18.47,19.78,20.75,20.84,19.22,17.31,15.94,14.03,11.97,10.16,9.5,9.56,9.62,10.0,11.22,13.38,14.84,15.16,15.06,14.84,14.09,12.06,9.84,8.62,7.41,6.28,5.62,6.84,9.47,12.44,15.19,19.03,23.22,26.75,29.19,30.72,32.25,32.69,31.66,30.38,29.78,29.41,28.56,27.03,25.78,23.75,20.88,17.16,13.47,10.97,9.34,8.34,8.84,11.06,14.72,17.22,19.38,21.56,22.53,22.03,20.47,19.16,18.59,17.97,16.56,15.84,15.47,14.94,13.03,11.56,10.12,9.28,7.97,6.66,6.56,7.28,7.62,7.41,7.41,7.22,6.38,4.44,2.31,1.38,0.66,-0.56,-1.44,-1.09,0.22,1.28,3.16,6.44,10.88,15.0,18.38,21.22,23.28,24.22,23.09,21.91,20.91,19.72,17.56,15.62,14.16,13.62,13.06,12.41,13.09,14.66,16.03,16.31,16.84,17.0,16.69,14.94,13.12,12.19,11.84,11.44,11.59,12.94,15.34,16.53,16.91,16.81,16.19,15.12,13.03,11.66,11.88,13.19,14.06,15.09,16.28,16.41,14.56,12.0,9.72,8.0,6.97,6.0,6.28,7.69,9.44,10.5,11.72,13.69,15.84,17.09,18.28,20.19,22.12,22.78,22.28,21.66,20.69,18.5,15.31,12.19,9.66,7.09,3.78,1.38,0.06,-0.03,-0.56,-0.41,0.75,2.59,3.84,4.94,6.81,9.28,11.59,12.5,13.16,14.31,15.44,15.78,16.38,17.41,18.25,17.44,15.84,14.28,13.72,12.75,11.78,11.22,11.16,10.78,9.62,8.62,9.0,9.81,9.81,9.81,10.12,11.06,11.06,11.5,12.66,14.56,15.97,16.53,16.56,16.78,16.06,14.41,12.75,12.38,11.59,9.75,7.25,4.97,2.69,0.31,-1.25,-1.62,-0.62,0.31,1.0,1.47,2.38,2.88,2.5,1.88,2.5,3.84,5.19,6.19,8.12,10.59,12.12,12.81,13.62,14.91,15.62,14.81,13.88,13.97,13.91,12.88,12.5,13.41,15.09,16.19,17.25,18.84,20.81,21.47,21.69,22.0,22.88,23.12,21.88,20.25,19.47,18.94,17.84,16.81,17.0,17.25,16.84,15.72,15.06,15.31,15.34,14.56,13.97,14.25,14.25,12.91,11.34,10.31,9.94,9.12,8.69,9.38,10.44,10.25,9.09,7.78,7.88,8.62,9.59,11.62,14.88,17.47,18.75,19.34,20.69,22.75,23.81,24.53,26.5,28.72,29.5,29.25,28.41,27.0,24.41,20.47,16.69,14.56,12.78,10.97,9.12,8.31,8.0,7.09,6.78,7.66,9.88,12.19,13.94,15.47,16.91,17.66,17.16,16.09,15.84,15.59,14.59,12.97,12.31,12.41,12.28,11.72,12.03,13.03,13.53,13.28,13.28,14.88,16.12,16.5,16.19,16.81,16.84,15.97,14.53,13.91,13.47,12.25,10.53,9.41,9.75,10.34,10.91,11.5,12.88,13.5,13.09,11.88,10.94,10.62,10.31,9.5,9.81,11.47,13.16,14.41,16.41,19.16,21.12,21.53,21.38,21.22,20.09,18.16,15.66,14.12,13.19,12.25,11.16,11.06,11.84,11.97,11.75,11.5,12.12,12.59,12.12,12.03,13.38,15.62,17.94,19.62,22.09,24.12,24.72,23.53,22.44,21.88,20.66,19.0,17.84,17.72,17.22,15.78,14.25,13.5,13.16,12.44,11.59,11.97,13.44,15.0,16.0,17.78,19.72,20.56,20.09,19.22,19.06,19.28,18.69,17.69,17.5,17.06,16.19,14.59,14.19,14.19,14.16,12.56,11.22,10.81,10.31,9.47,9.69,11.88,14.34,16.06,17.22,18.88,19.97,20.28,19.34,18.41,17.28,15.06,11.88,9.03,7.62,6.75,5.5,4.69,5.31,6.16,6.31,6.03,6.97,7.56,7.78,7.62,8.0,8.72,9.56,9.59,9.75,10.47,29.47,29.19,29.5,30.31,31.34,32.97,34.69:2.12,2.38,2.41,1.47,0.12,-0.5,-1.19,-2.72,-4.28,-4.94,-5.56,-6.88,-8.62,-9.69,-10.53,-11.22,-12.31,-12.56,-11.66,-10.0,-9.09,-7.72,-5.38,-2.66,-1.0,0.62,2.44,3.94,4.72,4.38,4.31,4.69,4.66,3.44,2.31,1.78,1.5,0.0,-1.34,-2.16,-3.0,-4.78,-6.41,-7.06,-6.59,-6.03,-5.41,-4.09,-1.53,0.56,1.47,1.91,2.59,3.25,2.56,2.59,4.0,6.34,7.81,9.06,10.47,11.06,10.47,8.12,5.97,4.62,4.0,3.09,2.69,2.91,3.06,1.72,0.59,-0.38,-0.69,-1.78,-2.94,-3.66,-3.66,-3.41,-3.41,-3.31,-2.53,-1.72,-2.03,-2.66,-2.03,-0.94,-0.72,-0.78,-0.5,-0.12,-0.69,-2.47,-4.03,-5.12,-6.44,-8.47,-10.34,-10.88,-11.09,-12.31,-13.12,-12.78,-11.97,-11.91,-11.47,-10.78,-9.31,-8.66,-8.25,-7.81,-7.0,-6.53,-7.19,-7.94,-8.16,-8.41,-9.53,-11.28,-12.0,-12.16,-13.12,-13.88,-14.41,-13.62,-13.09,-13.31,-13.38,-12.91,-12.5,-12.97,-13.06,-12.19,-10.81,-10.56,-11.34,-11.84,-12.31,-13.5,-14.5,-14.88,-13.81,-12.53,-12.06,-10.97,-9.22,-7.56,-6.44,-5.41,-3.41,-1.25,-0.03,0.44,0.88,1.78,1.88,1.38,1.0,1.41,1.66,1.41,0.41,-0.22,-0.88,-2.69,-5.22,-6.22,-6.44,-7.0,-7.94,-7.91,-6.97,-6.25,-6.06,-5.38,-3.66,-2.25,-1.66,-1.81,-1.5,-1.97,-3.75,-6.0,-7.47,-8.06,-8.88,-10.06,-9.75,-8.28,-6.72,-5.66,-5.06,-4.12,-4.09,-5.03,-5.94,-5.22,-3.5,-2.12,-0.88,0.72,3.12,4.12,3.88,3.38,3.09,2.19,0.62,-0.88,-0.94,-0.97,-1.94,-3.09,-3.53,-3.41,-4.31,-5.12,-4.78,-3.66,-2.5,-1.62,-0.62,1.56,3.25,3.75,3.47,3.78,3.53,2.34,0.69,0.66,1.69,2.88,4.22,6.16,8.66,10.72,11.12,11.66,12.88,13.28,12.31,10.09,8.09,5.78,2.16,-1.5,-3.44,-4.16,-4.56,-4.41,-3.34,-1.5,-0.72,-1.12,-2.03,-2.41,-1.88,-1.44,-0.72,1.25,2.69,2.72,1.5,0.47,-0.28,-1.0,-2.09,-2.38,-1.28,0.06,0.72,1.59,3.75,6.19,7.84,8.78,10.31,10.62,9.34,6.5,3.03,-0.03,-3.19,-7.03,-10.31,-12.56,-14.56,-17.09,-18.81,-18.88,-17.88,-16.88,-15.28,-12.16,-7.88,-3.47,0.69,6.0,11.0,14.81,16.94,17.78,18.62,18.44,17.5,16.47,16.41,16.41,16.0,14.81,14.12,13.44,12.56,11.0,10.53,11.09,11.66,12.16,13.28,15.78,18.59,20.56,22.06,23.88,25.22,25.25,24.09,23.12,22.06,20.44,17.75,15.62,14.31,12.69,9.66,6.44,3.72,1.03,-2.22,-5.09,-6.19,-6.47,-6.28,-6.09,-4.22,-0.72,3.28,6.56,10.09,14.09,16.91,18.56,19.56,20.56,21.16,20.38,18.22,16.38,14.62,11.94,8.25,5.28,2.66,0.53,-2.09,-3.62,-3.12,-1.28,0.47,2.34,5.19,8.03,10.12,11.47,13.94,16.91,19.56,21.03,22.25,23.16,22.91,20.09,16.94,14.03,11.16,7.56,4.5,2.66,1.09,-0.72,-3.31,-4.34,-3.88,-2.81,-1.81,-0.19,1.66,2.62,2.06,1.19,1.0,1.44,1.53,1.62,2.47,3.78,4.91,5.5,6.75,9.03,11.22,12.12,12.59,13.28,13.62,12.56,11.34,10.84,10.5,8.91,6.59,4.59,2.72,0.69,-1.31,-2.06,-1.78,-1.09,-1.16,-1.03,-0.31,1.22,2.25,3.72,6.09,8.84,11.16,12.12,12.84,13.19,12.84,11.03,9.47,9.03,9.31,9.0,8.88,9.38,9.66,8.97,7.72,7.16,7.25,7.0,6.53,7.16,8.5,10.03,10.28,10.03,10.34,10.06,8.41,7.78,8.12,9.28,10.28,10.94,11.97,13.22,13.5,12.88,12.47,12.72,12.88,12.0,11.66,11.62,11.69,10.56,8.97,8.38,8.0,7.75,7.53,8.31,10.03,11.06,11.88,13.44,16.09,18.91,20.59,21.5,22.12,22.25,21.06,18.97,17.34,15.88,13.56,10.78,8.94,8.19,7.41,6.19,5.06,4.75,4.69,4.16,3.97,4.66,5.69,6.25,6.12,6.44,7.31,7.91,8.34,9.41,11.81,13.78,14.91,15.28,15.44,14.97,13.06,11.0,9.47,8.78,8.09,7.56,7.84,9.84,11.09,12.09,12.62,13.47,13.31,11.94,10.19,8.88,8.38,7.19,6.38,6.38,6.81,7.03,6.88,7.38,8.56,9.69,9.97,10.41,11.53,12.75,12.88,12.41,11.97,11.22,9.41,7.41,5.84,5.34,4.66,3.69,3.12,3.59,4.09,4.06,4.09,4.84,6.06,7.12,8.31,10.5,13.06,14.34,14.75,14.91,15.69,16.31,16.38,16.66,17.69,18.16,17.22,15.84,15.03,14.19,13.19,12.5,12.22,12.28,11.62,10.22,8.69,7.91,6.97,5.56,4.06,3.5,3.19,2.59,1.94,2.44,3.09,3.38,3.25,3.72,4.97,6.0,6.5,7.12,8.66,9.72,9.44,8.62,8.19,7.09,5.66,4.53,4.28,4.91,5.59,6.0,6.78,8.44,9.88,10.59,11.16,12.06,12.28,11.72,10.78,10.97,11.62,11.56,11.31,10.88,10.44,9.22,7.22,5.56,4.56,3.56,2.44,1.44,2.06,2.88,2.66,1.81,1.44,1.09,0.62,0.25,0.94,2.5,3.69,3.81,3.69,4.0,3.56,2.28,1.19,1.25,2.56,4.34,6.41,10.06,13.66,16.69,18.47,19.78,20.75,20.84,19.22,17.31,15.94,14.03,11.97,10.16,9.5,9.56,9.62,10.0,11.22,13.38,14.84,15.16,15.06,14.84,14.09,12.06,9.84,8.62,7.41,6.28,5.62,6.84,9.47,12.44,15.19,19.03,23.22,26.75,29.19,30.72,32.25,32.69,31.66,30.38,29.78,29.41,28.56,27.03,25.78,23.75,20.88,17.16,13.47,10.97,9.34,8.34,8.84,11.06,14.72,17.22,19.38,21.56,22.53,22.03,20.47,19.16,18.59,17.97,16.56,15.84,15.47,14.94,13.03,11.56,10.12,9.28,7.97,6.66,6.56,7.28,7.62,7.41,7.41,7.22,6.38,4.44,2.31,1.38,0.66,-0.56,-1.44,-1.09,0.22,1.28,3.16,6.44,10.88,15.0,18.38,21.22,23.28,24.22,23.09,21.91,20.91,19.72,17.56,15.62,14.16,13.62,13.06,12.41,13.09,14.66,16.03,16.31,16.84,17.0,16.69,14.94,13.12,12.19,11.84,11.44,11.59,12.94,15.34,16.53,16.91,16.81,16.19,15.12,13.03,11.66,11.88,13.19,14.06,15.09,16.28,16.41,14.56,12.0,9.72,8.0,6.97,6.0,6.28,7.69,9.44,10.5,11.72,13.69,15.84,17.09,18.28,20.19,22.12,22.78,22.28,21.66,20.69,18.5,15.31,12.19,9.66,7.09,3.78,1.38,0.06,-0.03,-0.56,-0.41,0.75,2.59,3.84,4.94,6.81,9.28,11.59,12.5,13.16,14.31,15.44,15.78,16.38,17.41,18.25,17.44,15.84,14.28,13.72,12.75,11.78,11.22,11.16,10.78,9.62,8.62,9.0,9.81,9.81,9.81,10.12,11.06,11.06,11.5,12.66,14.56,15.97,16.53,16.56,16.78,16.06,14.41,12.75,12.38,11.59,9.75,7.25,4.97,2.69,0.31,-1.25,-1.62,-0.62,0.31,1.0,1.47,2.38,2.88,2.5,1.88,2.5,3.84,5.19,6.19,8.12,10.59,12.12,12.81,13.62,14.91,15.62,14.81,13.88,13.97,13.91,12.88,12.5,13.41,15.09,16.19,17.25,18.84,20.81,21.47,21.69,22.0,22.88,23.12,21.88,20.25,19.47,18.94,17.84,16.81,17.0,17.25,16.84,15.72,15.06,15.31,15.34,14.56,13.97,14.25,14.25,12.91,11.34,10.31,9.94,9.12,8.69,9.38,10.44,10.25,9.09,7.78,7.88,8.62,9.59,11.62,14.88,17.47,18.75,19.34,20.69,22.75,23.81,24.53,26.5,28.72,29.5,29.25,28.41,27.0,24.41,20.47,16.69,14.56,12.78,10.97,9.12,8.31,8.0,7.09,6.78,7.66,9.88,12.19,13.94,15.47,16.91,17.66,17.16,16.09,15.84,15.59,14.59,12.97,12.31,12.41,12.28,11.72,12.03,13.03,13.53,13.28,13.28,14.88,16.12,16.5,16.19,16.81,16.84,15.97,14.53,13.91,13.47,12.25,10.53,9.41,9.75,10.34,10.91,11.5,12.88,13.5,13.09,11.88,10.94,10.62,10.31,9.5,9.81,11.47,13.16,14.41,16.41,19.16,21.12,21.53,21.38,21.22,20.09,18.16,15.66,14.12,13.19,12.25,11.16,11.06,11.84,11.97,11.75,11.5,12.12,12.59,12.12,12.03,13.38,15.62,17.94,19.62,22.09,24.12,24.72,23.53,22.44,21.88,20.66,19.0,17.84,17.72,17.22,15.78,14.25,13.5,13.16,12.44,11.59,11.97,13.44,15.0,16.0,17.78,19.72,20.56,20.09,19.22,19.06,19.28,18.69,17.69,17.5,17.06,16.19,14.59,14.19,14.19,14.16,12.56,11.22,10.81,10.31,9.47,9.69,11.88,14.34,16.06,17.22,18.88,19.97,20.28,19.34,18.41,17.28,15.06,11.88,9.03,7.62,6.75,5.5,4.69,5.31,6.16,6.31,6.03,6.97,7.56,7.78,7.62,8.0,8.72,9.56,9.59,9.75,10.47,29.47,29.19,29.5,30.31,31.34,32.97,34.69,36.88,38.31,38.94,39.38,39.38,38.72,37.84:-2.72,-4.28,-4.94,-5.56,-6.88,-8.62,-9.69,-10.53,-11.22,-12.31,-12.56,-11.66,-10.0,-9.09,-7.72,-5.38,-2.66,-1.0,0.62,2.44,3.94,4.72,4.38,4.31,4.69,4.66,3.44,2.31,1.78,1.5,0.0,-1.34,-2.16,-3.0,-4.78,-6.41,-7.06,-6.59,-6.03,-5.41,-4.09,-1.53,0.56,1.47,1.91,2.59,3.25,2.56,2.59,4.0,6.34,7.81,9.06,10.47,11.06,10.47,8.12,5.97,4.62,4.0,3.09,2.69,2.91,3.06,1.72,0.59,-0.38,-0.69,-1.78,-2.94,-3.66,-3.66,-3.41,-3.41,-3.31,-2.53,-1.72,-2.03,-2.66,-2.03,-0.94,-0.72,-0.78,-0.5,-0.12,-0.69,-2.47,-4.03,-5.12,-6.44,-8.47,-10.34,-10.88,-11.09,-12.31,-13.12,-12.78,-11.97,-11.91,-11.47,-10.78,-9.31,-8.66,-8.25,-7.81,-7.0,-6.53,-7.19,-7.94,-8.16,-8.41,-9.53,-11.28,-12.0,-12.16,-13.12,-13.88,-14.41,-13.62,-13.09,-13.31,-13.38,-12.91,-12.5,-12.97,-13.06,-12.19,-10.81,-10.56,-11.34,-11.84,-12.31,-13.5,-14.5,-14.88,-13.81,-12.53,-12.06,-10.97,-9.22,-7.56,-6.44,-5.41,-3.41,-1.25,-0.03,0.44,0.88,1.78,1.88,1.38,1.0,1.41,1.66,1.41,0.41,-0.22,-0.88,-2.69,-5.22,-6.22,-6.44,-7.0,-7.94,-7.91,-6.97,-6.25,-6.06,-5.38,-3.66,-2.25,-1.66,-1.81,-1.5,-1.97,-3.75,-6.0,-7.47,-8.06,-8.88,-10.06,-9.75,-8.28,-6.72,-5.66,-5.06,-4.12,-4.09,-5.03,-5.94,-5.22,-3.5,-2.12,-0.88,0.72,3.12,4.12,3.88,3.38,3.09,2.19,0.62,-0.88,-0.94,-0.97,-1.94,-3.09,-3.53,-3.41,-4.31,-5.12,-4.78,-3.66,-2.5,-1.62,-0.62,1.56,3.25,3.75,3.47,3.78,3.53,2.34,0.69,0.66,1.69,2.88,4.22,6.16,8.66,10.72,11.12,11.66,12.88,13.28,12.31,10.09,8.09,5.78,2.16,-1.5,-3.44,-4.16,-4.56,-4.41,-3.34,-1.5,-0.72,-1.12,-2.03,-2.41,-1.88,-1.44,-0.72,1.25,2.69,2.72,1.5,0.47,-0.28,-1.0,-2.09,-2.38,-1.28,0.06,0.72,1.59,3.75,6.19,7.84,8.78,10.31,10.62,9.34,6.5,3.03,-0.03,-3.19,-7.03,-10.31,-12.56,-14.56,-17.09,-18.81,-18.88,-17.88,-16.88,-15.28,-12.16,-7.88,-3.47,0.69,6.0,11.0,14.81,16.94,17.78,18.62,18.44,17.5,16.47,16.41,16.41,16.0,14.81,14.12,13.44,12.56,11.0,10.53,11.09,11.66,12.16,13.28,15.78,18.59,20.56,22.06,23.88,25.22,25.25,24.09,23.12,22.06,20.44,17.75,15.62,14.31,12.69,9.66,6.44,3.72,1.03,-2.22,-5.09,-6.19,-6.47,-6.28,-6.09,-4.22,-0.72,3.28,6.56,10.09,14.09,16.91,18.56,19.56,20.56,21.16,20.38,18.22,16.38,14.62,11.94,8.25,5.28,2.66,0.53,-2.09,-3.62,-3.12,-1.28,0.47,2.34,5.19,8.03,10.12,11.47,13.94,16.91,19.56,21.03,22.25,23.16,22.91,20.09,16.94,14.03,11.16,7.56,4.5,2.66,1.09,-0.72,-3.31,-4.34,-3.88,-2.81,-1.81,-0.19,1.66,2.62,2.06,1.19,1.0,1.44,1.53,1.62,2.47,3.78,4.91,5.5,6.75,9.03,11.22,12.12,12.59,13.28,13.62,12.56,11.34,10.84,10.5,8.91,6.59,4.59,2.72,0.69,-1.31,-2.06,-1.78,-1.09,-1.16,-1.03,-0.31,1.22,2.25,3.72,6.09,8.84,11.16,12.12,12.84,13.19,12.84,11.03,9.47,9.03,9.31,9.0,8.88,9.38,9.66,8.97,7.72,7.16,7.25,7.0,6.53,7.16,8.5,10.03,10.28,10.03,10.34,10.06,8.41,7.78,8.12,9.28,10.28,10.94,11.97,13.22,13.5,12.88,12.47,12.72,12.88,12.0,11.66,11.62,11.69,10.56,8.97,8.38,8.0,7.75,7.53,8.31,10.03,11.06,11.88,13.44,16.09,18.91,20.59,21.5,22.12,22.25,21.06,18.97,17.34,15.88,13.56,10.78,8.94,8.19,7.41,6.19,5.06,4.75,4.69,4.16,3.97,4.66,5.69,6.25,6.12,6.44,7.31,7.91,8.34,9.41,11.81,13.78,14.91,15.28,15.44,14.97,13.06,11.0,9.47,8.78,8.09,7.56,7.84,9.84,11.09,12.09,12.62,13.47,13.31,11.94,10.19,8.88,8.38,7.19,6.38,6.38,6.81,7.03,6.88,7.38,8.56,9.69,9.97,10.41,11.53,12.75,12.88,12.41,11.97,11.22,9.41,7.41,5.84,5.34,4.66,3.69,3.12,3.59,4.09,4.06,4.09,4.84,6.06,7.12,8.31,10.5,13.06,14.34,14.75,14.91,15.69,16.31,16.38,16.66,17.69,18.16,17.22,15.84,15.03,14.19,13.19,12.5,12.22,12.28,11.62,10.22,8.69,7.91,6.97,5.56,4.06,3.5,3.19,2.59,1.94,2.44,3.09,3.38,3.25,3.72,4.97,6.0,6.5,7.12,8.66,9.72,9.44,8.62,8.19,7.09,5.66,4.53,4.28,4.91,5.59,6.0,6.78,8.44,9.88,10.59,11.16,12.06,12.28,11.72,10.78,10.97,11.62,11.56,11.31,10.88,10.44,9.22,7.22,5.56,4.56,3.56,2.44,1.44,2.06,2.88,2.66,1.81,1.44,1.09,0.62,0.25,0.94,2.5,3.69,3.81,3.69,4.0,3.56,2.28,1.19,1.25,2.56,4.34,6.41,10.06,13.66,16.69,18.47,19.78,20.75,20.84,19.22,17.31,15.94,14.03,11.97,10.16,9.5,9.56,9.62,10.0,11.22,13.38,14.84,15.16,15.06,14.84,14.09,12.06,9.84,8.62,7.41,6.28,5.62,6.84,9.47,12.44,15.19,19.03,23.22,26.75,29.19,30.72,32.25,32.69,31.66,30.38,29.78,29.41,28.56,27.03,25.78,23.75,20.88,17.16,13.47,10.97,9.34,8.34,8.84,11.06,14.72,17.22,19.38,21.56,22.53,22.03,20.47,19.16,18.59,17.97,16.56,15.84,15.47,14.94,13.03,11.56,10.12,9.28,7.97,6.66,6.56,7.28,7.62,7.41,7.41,7.22,6.38,4.44,2.31,1.38,0.66,-0.56,-1.44,-1.09,0.22,1.28,3.16,6.44,10.88,15.0,18.38,21.22,23.28,24.22,23.09,21.91,20.91,19.72,17.56,15.62,14.16,13.62,13.06,12.41,13.09,14.66,16.03,16.31,16.84,17.0,16.69,14.94,13.12,12.19,11.84,11.44,11.59,12.94,15.34,16.53,16.91,16.81,16.19,15.12,13.03,11.66,11.88,13.19,14.06,15.09,16.28,16.41,14.56,12.0,9.72,8.0,6.97,6.0,6.28,7.69,9.44,10.5,11.72,13.69,15.84,17.09,18.28,20.19,22.12,22.78,22.28,21.66,20.69,18.5,15.31,12.19,9.66,7.09,3.78,1.38,0.06,-0.03,-0.56,-0.41,0.75,2.59,3.84,4.94,6.81,9.28,11.59,12.5,13.16,14.31,15.44,15.78,16.38,17.41,18.25,17.44,15.84,14.28,13.72,12.75,11.78,11.22,11.16,10.78,9.62,8.62,9.0,9.81,9.81,9.81,10.12,11.06,11.06,11.5,12.66,14.56,15.97,16.53,16.56,16.78,16.06,14.41,12.75,12.38,11.59,9.75,7.25,4.97,2.69,0.31,-1.25,-1.62,-0.62,0.31,1.0,1.47,2.38,2.88,2.5,1.88,2.5,3.84,5.19,6.19,8.12,10.59,12.12,12.81,13.62,14.91,15.62,14.81,13.88,13.97,13.91,12.88,12.5,13.41,15.09,16.19,17.25,18.84,20.81,21.47,21.69,22.0,22.88,23.12,21.88,20.25,19.47,18.94,17.84,16.81,17.0,17.25,16.84,15.72,15.06,15.31,15.34,14.56,13.97,14.25,14.25,12.91,11.34,10.31,9.94,9.12,8.69,9.38,10.44,10.25,9.09,7.78,7.88,8.62,9.59,11.62,14.88,17.47,18.75,19.34,20.69,22.75,23.81,24.53,26.5,28.72,29.5,29.25,28.41,27.0,24.41,20.47,16.69,14.56,12.78,10.97,9.12,8.31,8.0,7.09,6.78,7.66,9.88,12.19,13.94,15.47,16.91,17.66,17.16,16.09,15.84,15.59,14.59,12.97,12.31,12.41,12.28,11.72,12.03,13.03,13.53,13.28,13.28,14.88,16.12,16.5,16.19,16.81,16.84,15.97,14.53,13.91,13.47,12.25,10.53,9.41,9.75,10.34,10.91,11.5,12.88,13.5,13.09,11.88,10.94,10.62,10.31,9.5,9.81,11.47,13.16,14.41,16.41,19.16,21.12,21.53,21.38,21.22,20.09,18.16,15.66,14.12,13.19,12.25,11.16,11.06,11.84,11.97,11.75,11.5,12.12,12.59,12.12,12.03,13.38,15.62,17.94,19.62,22.09,24.12,24.72,23.53,22.44,21.88,20.66,19.0,17.84,17.72,17.22,15.78,14.25,13.5,13.16,12.44,11.59,11.97,13.44,15.0,16.0,17.78,19.72,20.56,20.09,19.22,19.06,19.28,18.69,17.69,17.5,17.06,16.19,14.59,14.19,14.19,14.16,12.56,11.22,10.81,10.31,9.47,9.69,11.88,14.34,16.06,17.22,18.88,19.97,20.28,19.34,18.41,17.28,15.06,11.88,9.03,7.62,6.75,5.5,4.69,5.31,6.16,6.31,6.03,6.97,7.56,7.78,7.62,8.0,8.72,9.56,9.59,9.75,10.47,29.47,29.19,29.5,30.31,31.34,32.97,34.69,36.88,38.31,38.94,39.38,39.38,38.72,37.84,37.31,36.62,35.59,34.69,33.88,33.03,32.59:-10.53,-11.22,-12.31,-12.56,-11.66,-10.0,-9.09,-7.72,-5.38,-2.66,-1.0,0.62,2.44,3.94,4.72,4.38,4.31,4.69,4.66,3.44,2.31,1.78,1.5,0.0,-1.34,-2.16,-3.0,-4.78,-6.41,-7.06,-6.59,-6.03,-5.41,-4.09,-1.53,0.56,1.47,1.91,2.59,3.25,2.56,2.59,4.0,6.34,7.81,9.06,10.47,11.06,10.47,8.12,5.97,4.62,4.0,3.09,2.69,2.91,3.06,1.72,0.59,-0.38,-0.69,-1.78,-2.94,-3.66,-3.66,-3.41,-3.41,-3.31,-2.53,-1.72,-2.03,-2.66,-2.03,-0.94,-0.72,-0.78,-0.5,-0.12,-0.69,-2.47,-4.03,-5.12,-6.44,-8.47,-10.34,-10.88,-11.09,-12.31,-13.12,-12.78,-11.97,-11.91,-11.47,-10.78,-9.31,-8.66,-8.25,-7.81,-7.0,-6.53,-7.19,-7.94,-8.16,-8.41,-9.53,-11.28,-12.0,-12.16,-13.12,-13.88,-14.41,-13.62,-13.09,-13.31,-13.38,-12.91,-12.5,-12.97,-13.06,-12.19,-10.81,-10.56,-11.34,-11.84,-12.31,-13.5,-14.5,-14.88,-13.81,-12.53,-12.06,-10.97,-9.22,-7.56,-6.44,-5.41,-3.41,-1.25,-0.03,0.44,0.88,1.78,1.88,1.38,1.0,1.41,1.66,1.41,0.41,-0.22,-0.88,-2.69,-5.22,-6.22,-6.44,-7.0,-7.94,-7.91,-6.97,-6.25,-6.06,-5.38,-3.66,-2.25,-1.66,-1.81,-1.5,-1.97,-3.75,-6.0,-7.47,-8.06,-8.88,-10.06,-9.75,-8.28,-6.72,-5.66,-5.06,-4.12,-4.09,-5.03,-5.94,-5.22,-3.5,-2.12,-0.88,0.72,3.12,4.12,3.88,3.38,3.09,2.19,0.62,-0.88,-0.94,-0.97,-1.94,-3.09,-3.53,-3.41,-4.31,-5.12,-4.78,-3.66,-2.5,-1.62,-0.62,1.56,3.25,3.75,3.47,3.78,3.53,2.34,0.69,0.66,1.69,2.88,4.22,6.16,8.66,10.72,11.12,11.66,12.88,13.28,12.31,10.09,8.09,5.78,2.16,-1.5,-3.44,-4.16,-4.56,-4.41,-3.34,-1.5,-0.72,-1.12,-2.03,-2.41,-1.88,-1.44,-0.72,1.25,2.69,2.72,1.5,0.47,-0.28,-1.0,-2.09,-2.38,-1.28,0.06,0.72,1.59,3.75,6.19,7.84,8.78,10.31,10.62,9.34,6.5,3.03,-0.03,-3.19,-7.03,-10.31,-12.56,-14.56,-17.09,-18.81,-18.88,-17.88,-16.88,-15.28,-12.16,-7.88,-3.47,0.69,6.0,11.0,14.81,16.94,17.78,18.62,18.44,17.5,16.47,16.41,16.41,16.0,14.81,14.12,13.44,12.56,11.0,10.53,11.09,11.66,12.16,13.28,15.78,18.59,20.56,22.06,23.88,25.22,25.25,24.09,23.12,22.06,20.44,17.75,15.62,14.31,12.69,9.66,6.44,3.72,1.03,-2.22,-5.09,-6.19,-6.47,-6.28,-6.09,-4.22,-0.72,3.28,6.56,10.09,14.09,16.91,18.56,19.56,20.56,21.16,20.38,18.22,16.38,14.62,11.94,8.25,5.28,2.66,0.53,-2.09,-3.62,-3.12,-1.28,0.47,2.34,5.19,8.03,10.12,11.47,13.94,16.91,19.56,21.03,22.25,23.16,22.91,20.09,16.94,14.03,11.16,7.56,4.5,2.66,1.09,-0.72,-3.31,-4.34,-3.88,-2.81,-1.81,-0.19,1.66,2.62,2.06,1.19,1.0,1.44,1.53,1.62,2.47,3.78,4.91,5.5,6.75,9.03,11.22,12.12,12.59,13.28,13.62,12.56,11.34,10.84,10.5,8.91,6.59,4.59,2.72,0.69,-1.31,-2.06,-1.78,-1.09,-1.16,-1.03,-0.31,1.22,2.25,3.72,6.09,8.84,11.16,12.12,12.84,13.19,12.84,11.03,9.47,9.03,9.31,9.0,8.88,9.38,9.66,8.97,7.72,7.16,7.25,7.0,6.53,7.16,8.5,10.03,10.28,10.03,10.34,10.06,8.41,7.78,8.12,9.28,10.28,10.94,11.97,13.22,13.5,12.88,12.47,12.72,12.88,12.0,11.66,11.62,11.69,10.56,8.97,8.38,8.0,7.75,7.53,8.31,10.03,11.06,11.88,13.44,16.09,18.91,20.59,21.5,22.12,22.25,21.06,18.97,17.34,15.88,13.56,10.78,8.94,8.19,7.41,6.19,5.06,4.75,4.69,4.16,3.97,4.66,5.69,6.25,6.12,6.44,7.31,7.91,8.34,9.41,11.81,13.78,14.91,15.28,15.44,14.97,13.06,11.0,9.47,8.78,8.09,7.56,7.84,9.84,11.09,12.09,12.62,13.47,13.31,11.94,10.19,8.88,8.38,7.19,6.38,6.38,6.81,7.03,6.88,7.38,8.56,9.69,9.97,10.41,11.53,12.75,12.88,12.41,11.97,11.22,9.41,7.41,5.84,5.34,4.66,3.69,3.12,3.59,4.09,4.06,4.09,4.84,6.06,7.12,8.31,10.5,13.06,14.34,14.75,14.91,15.69,16.31,16.38,16.66,17.69,18.16,17.22,15.84,15.03,14.19,13.19,12.5,12.22,12.28,11.62,10.22,8.69,7.91,6.97,5.56,4.06,3.5,3.19,2.59,1.94,2.44,3.09,3.38,3.25,3.72,4.97,6.0,6.5,7.12,8.66,9.72,9.44,8.62,8.19,7.09,5.66,4.53,4.28,4.91,5.59,6.0,6.78,8.44,9.88,10.59,11.16,12.06,12.28,11.72,10.78,10.97,11.62,11.56,11.31,10.88,10.44,9.22,7.22,5.56,4.56,3.56,2.44,1.44,2.06,2.88,2.66,1.81,1.44,1.09,0.62,0.25,0.94,2.5,3.69,3.81,3.69,4.0,3.56,2.28,1.19,1.25,2.56,4.34,6.41,10.06,13.66,16.69,18.47,19.78,20.75,20.84,19.22,17.31,15.94,14.03,11.97,10.16,9.5,9.56,9.62,10.0,11.22,13.38,14.84,15.16,15.06,14.84,14.09,12.06,9.84,8.62,7.41,6.28,5.62,6.84,9.47,12.44,15.19,19.03,23.22,26.75,29.19,30.72,32.25,32.69,31.66,30.38,29.78,29.41,28.56,27.03,25.78,23.75,20.88,17.16,13.47,10.97,9.34,8.34,8.84,11.06,14.72,17.22,19.38,21.56,22.53,22.03,20.47,19.16,18.59,17.97,16.56,15.84,15.47,14.94,13.03,11.56,10.12,9.28,7.97,6.66,6.56,7.28,7.62,7.41,7.41,7.22,6.38,4.44,2.31,1.38,0.66,-0.56,-1.44,-1.09,0.22,1.28,3.16,6.44,10.88,15.0,18.38,21.22,23.28,24.22,23.09,21.91,20.91,19.72,17.56,15.62,14.16,13.62,13.06,12.41,13.09,14.66,16.03,16.31,16.84,17.0,16.69,14.94,13.12,12.19,11.84,11.44,11.59,12.94,15.34,16.53,16.91,16.81,16.19,15.12,13.03,11.66,11.88,13.19,14.06,15.09,16.28,16.41,14.56,12.0,9.72,8.0,6.97,6.0,6.28,7.69,9.44,10.5,11.72,13.69,15.84,17.09,18.28,20.19,22.12,22.78,22.28,21.66,20.69,18.5,15.31,12.19,9.66,7.09,3.78,1.38,0.06,-0.03,-0.56,-0.41,0.75,2.59,3.84,4.94,6.81,9.28,11.59,12.5,13.16,14.31,15.44,15.78,16.38,17.41,18.25,17.44,15.84,14.28,13.72,12.75,11.78,11.22,11.16,10.78,9.62,8.62,9.0,9.81,9.81,9.81,10.12,11.06,11.06,11.5,12.66,14.56,15.97,16.53,16.56,16.78,16.06,14.41,12.75,12.38,11.59,9.75,7.25,4.97,2.69,0.31,-1.25,-1.62,-0.62,0.31,1.0,1.47,2.38,2.88,2.5,1.88,2.5,3.84,5.19,6.19,8.12,10.59,12.12,12.81,13.62,14.91,15.62,14.81,13.88,13.97,13.91,12.88,12.5,13.41,15.09,16.19,17.25,18.84,20.81,21.47,21.69,22.0,22.88,23.12,21.88,20.25,19.47,18.94,17.84,16.81,17.0,17.25,16.84,15.72,15.06,15.31,15.34,14.56,13.97,14.25,14.25,12.91,11.34,10.31,9.94,9.12,8.69,9.38,10.44,10.25,9.09,7.78,7.88,8.62,9.59,11.62,14.88,17.47,18.75,19.34,20.69,22.75,23.81,24.53,26.5,28.72,29.5,29.25,28.41,27.0,24.41,20.47,16.69,14.56,12.78,10.97,9.12,8.31,8.0,7.09,6.78,7.66,9.88,12.19,13.94,15.47,16.91,17.66,17.16,16.09,15.84,15.59,14.59,12.97,12.31,12.41,12.28,11.72,12.03,13.03,13.53,13.28,13.28,14.88,16.12,16.5,16.19,16.81,16.84,15.97,14.53,13.91,13.47,12.25,10.53,9.41,9.75,10.34,10.91,11.5,12.88,13.5,13.09,11.88,10.94,10.62,10.31,9.5,9.81,11.47,13.16,14.41,16.41,19.16,21.12,21.53,21.38,21.22,20.09,18.16,15.66,14.12,13.19,12.25,11.16,11.06,11.84,11.97,11.75,11.5,12.12,12.59,12.12,12.03,13.38,15.62,17.94,19.62,22.09,24.12,24.72,23.53,22.44,21.88,20.66,19.0,17.84,17.72,17.22,15.78,14.25,13.5,13.16,12.44,11.59,11.97,13.44,15.0,16.0,17.78,19.72,20.56,20.09,19.22,19.06,19.28,18.69,17.69,17.5,17.06,16.19,14.59,14.19,14.19,14.16,12.56,11.22,10.81,10.31,9.47,9.69,11.88,14.34,16.06,17.22,18.88,19.97,20.28,19.34,18.41,17.28,15.06,11.88,9.03,7.62,6.75,5.5,4.69,5.31,6.16,6.31,6.03,6.97,7.56,7.78,7.62,8.0,8.72,9.56,9.59,9.75,10.47,29.47,29.19,29.5,30.31,31.34,32.97,34.69,36.88,38.31,38.94,39.38,39.38,38.72,37.84,37.31,36.62,35.59,34.69,33.88,33.03,32.59,32.41,32.03,31.97,32.28,32.78,33.47,34.31:-7.72,-5.38,-2.66,-1.0,0.62,2.44,3.94,4.72,4.38,4.31,4.69,4.66,3.44,2.31,1.78,1.5,0.0,-1.34,-2.16,-3.0,-4.78,-6.41,-7.06,-6.59,-6.03,-5.41,-4.09,-1.53,0.56,1.47,1.91,2.59,3.25,2.56,2.59,4.0,6.34,7.81,9.06,10.47,11.06,10.47,8.12,5.97,4.62,4.0,3.09,2.69,2.91,3.06,1.72,0.59,-0.38,-0.69,-1.78,-2.94,-3.66,-3.66,-3.41,-3.41,-3.31,-2.53,-1.72,-2.03,-2.66,-2.03,-0.94,-0.72,-0.78,-0.5,-0.12,-0.69,-2.47,-4.03,-5.12,-6.44,-8.47,-10.34,-10.88,-11.09,-12.31,-13.12,-12.78,-11.97,-11.91,-11.47,-10.78,-9.31,-8.66,-8.25,-7.81,-7.0,-6.53,-7.19,-7.94,-8.16,-8.41,-9.53,-11.28,-12.0,-12.16,-13.12,-13.88,-14.41,-13.62,-13.09,-13.31,-13.38,-12.91,-12.5,-12.97,-13.06,-12.19,-10.81,-10.56,-11.34,-11.84,-12.31,-13.5,-14.5,-14.88,-13.81,-12.53,-12.06,-10.97,-9.22,-7.56,-6.44,-5.41,-3.41,-1.25,-0.03,0.44,0.88,1.78,1.88,1.38,1.0,1.41,1.66,1.41,0.41,-0.22,-0.88,-2.69,-5.22,-6.22,-6.44,-7.0,-7.94,-7.91,-6.97,-6.25,-6.06,-5.38,-3.66,-2.25,-1.66,-1.81,-1.5,-1.97,-3.75,-6.0,-7.47,-8.06,-8.88,-10.06,-9.75,-8.28,-6.72,-5.66,-5.06,-4.12,-4.09,-5.03,-5.94,-5.22,-3.5,-2.12,-0.88,0.72,3.12,4.12,3.88,3.38,3.09,2.19,0.62,-0.88,-0.94,-0.97,-1.94,-3.09,-3.53,-3.41,-4.31,-5.12,-4.78,-3.66,-2.5,-1.62,-0.62,1.56,3.25,3.75,3.47,3.78,3.53,2.34,0.69,0.66,1.69,2.88,4.22,6.16,8.66,10.72,11.12,11.66,12.88,13.28,12.31,10.09,8.09,5.78,2.16,-1.5,-3.44,-4.16,-4.56,-4.41,-3.34,-1.5,-0.72,-1.12,-2.03,-2.41,-1.88,-1.44,-0.72,1.25,2.69,2.72,1.5,0.47,-0.28,-1.0,-2.09,-2.38,-1.28,0.06,0.72,1.59,3.75,6.19,7.84,8.78,10.31,10.62,9.34,6.5,3.03,-0.03,-3.19,-7.03,-10.31,-12.56,-14.56,-17.09,-18.81,-18.88,-17.88,-16.88,-15.28,-12.16,-7.88,-3.47,0.69,6.0,11.0,14.81,16.94,17.78,18.62,18.44,17.5,16.47,16.41,16.41,16.0,14.81,14.12,13.44,12.56,11.0,10.53,11.09,11.66,12.16,13.28,15.78,18.59,20.56,22.06,23.88,25.22,25.25,24.09,23.12,22.06,20.44,17.75,15.62,14.31,12.69,9.66,6.44,3.72,1.03,-2.22,-5.09,-6.19,-6.47,-6.28,-6.09,-4.22,-0.72,3.28,6.56,10.09,14.09,16.91,18.56,19.56,20.56,21.16,20.38,18.22,16.38,14.62,11.94,8.25,5.28,2.66,0.53,-2.09,-3.62,-3.12,-1.28,0.47,2.34,5.19,8.03,10.12,11.47,13.94,16.91,19.56,21.03,22.25,23.16,22.91,20.09,16.94,14.03,11.16,7.56,4.5,2.66,1.09,-0.72,-3.31,-4.34,-3.88,-2.81,-1.81,-0.19,1.66,2.62,2.06,1.19,1.0,1.44,1.53,1.62,2.47,3.78,4.91,5.5,6.75,9.03,11.22,12.12,12.59,13.28,13.62,12.56,11.34,10.84,10.5,8.91,6.59,4.59,2.72,0.69,-1.31,-2.06,-1.78,-1.09,-1.16,-1.03,-0.31,1.22,2.25,3.72,6.09,8.84,11.16,12.12,12.84,13.19,12.84,11.03,9.47,9.03,9.31,9.0,8.88,9.38,9.66,8.97,7.72,7.16,7.25,7.0,6.53,7.16,8.5,10.03,10.28,10.03,10.34,10.06,8.41,7.78,8.12,9.28,10.28,10.94,11.97,13.22,13.5,12.88,12.47,12.72,12.88,12.0,11.66,11.62,11.69,10.56,8.97,8.38,8.0,7.75,7.53,8.31,10.03,11.06,11.88,13.44,16.09,18.91,20.59,21.5,22.12,22.25,21.06,18.97,17.34,15.88,13.56,10.78,8.94,8.19,7.41,6.19,5.06,4.75,4.69,4.16,3.97,4.66,5.69,6.25,6.12,6.44,7.31,7.91,8.34,9.41,11.81,13.78,14.91,15.28,15.44,14.97,13.06,11.0,9.47,8.78,8.09,7.56,7.84,9.84,11.09,12.09,12.62,13.47,13.31,11.94,10.19,8.88,8.38,7.19,6.38,6.38,6.81,7.03,6.88,7.38,8.56,9.69,9.97,10.41,11.53,12.75,12.88,12.41,11.97,11.22,9.41,7.41,5.84,5.34,4.66,3.69,3.12,3.59,4.09,4.06,4.09,4.84,6.06,7.12,8.31,10.5,13.06,14.34,14.75,14.91,15.69,16.31,16.38,16.66,17.69,18.16,17.22,15.84,15.03,14.19,13.19,12.5,12.22,12.28,11.62,10.22,8.69,7.91,6.97,5.56,4.06,3.5,3.19,2.59,1.94,2.44,3.09,3.38,3.25,3.72,4.97,6.0,6.5,7.12,8.66,9.72,9.44,8.62,8.19,7.09,5.66,4.53,4.28,4.91,5.59,6.0,6.78,8.44,9.88,10.59,11.16,12.06,12.28,11.72,10.78,10.97,11.62,11.56,11.31,10.88,10.44,9.22,7.22,5.56,4.56,3.56,2.44,1.44,2.06,2.88,2.66,1.81,1.44,1.09,0.62,0.25,0.94,2.5,3.69,3.81,3.69,4.0,3.56,2.28,1.19,1.25,2.56,4.34,6.41,10.06,13.66,16.69,18.47,19.78,20.75,20.84,19.22,17.31,15.94,14.03,11.97,10.16,9.5,9.56,9.62,10.0,11.22,13.38,14.84,15.16,15.06,14.84,14.09,12.06,9.84,8.62,7.41,6.28,5.62,6.84,9.47,12.44,15.19,19.03,23.22,26.75,29.19,30.72,32.25,32.69,31.66,30.38,29.78,29.41,28.56,27.03,25.78,23.75,20.88,17.16,13.47,10.97,9.34,8.34,8.84,11.06,14.72,17.22,19.38,21.56,22.53,22.03,20.47,19.16,18.59,17.97,16.56,15.84,15.47,14.94,13.03,11.56,10.12,9.28,7.97,6.66,6.56,7.28,7.62,7.41,7.41,7.22,6.38,4.44,2.31,1.38,0.66,-0.56,-1.44,-1.09,0.22,1.28,3.16,6.44,10.88,15.0,18.38,21.22,23.28,24.22,23.09,21.91,20.91,19.72,17.56,15.62,14.16,13.62,13.06,12.41,13.09,14.66,16.03,16.31,16.84,17.0,16.69,14.94,13.12,12.19,11.84,11.44,11.59,12.94,15.34,16.53,16.91,16.81,16.19,15.12,13.03,11.66,11.88,13.19,14.06,15.09,16.28,16.41,14.56,12.0,9.72,8.0,6.97,6.0,6.28,7.69,9.44,10.5,11.72,13.69,15.84,17.09,18.28,20.19,22.12,22.78,22.28,21.66,20.69,18.5,15.31,12.19,9.66,7.09,3.78,1.38,0.06,-0.03,-0.56,-0.41,0.75,2.59,3.84,4.94,6.81,9.28,11.59,12.5,13.16,14.31,15.44,15.78,16.38,17.41,18.25,17.44,15.84,14.28,13.72,12.75,11.78,11.22,11.16,10.78,9.62,8.62,9.0,9.81,9.81,9.81,10.12,11.06,11.06,11.5,12.66,14.56,15.97,16.53,16.56,16.78,16.06,14.41,12.75,12.38,11.59,9.75,7.25,4.97,2.69,0.31,-1.25,-1.62,-0.62,0.31,1.0,1.47,2.38,2.88,2.5,1.88,2.5,3.84,5.19,6.19,8.12,10.59,12.12,12.81,13.62,14.91,15.62,14.81,13.88,13.97,13.91,12.88,12.5,13.41,15.09,16.19,17.25,18.84,20.81,21.47,21.69,22.0,22.88,23.12,21.88,20.25,19.47,18.94,17.84,16.81,17.0,17.25,16.84,15.72,15.06,15.31,15.34,14.56,13.97,14.25,14.25,12.91,11.34,10.31,9.94,9.12,8.69,9.38,10.44,10.25,9.09,7.78,7.88,8.62,9.59,11.62,14.88,17.47,18.75,19.34,20.69,22.75,23.81,24.53,26.5,28.72,29.5,29.25,28.41,27.0,24.41,20.47,16.69,14.56,12.78,10.97,9.12,8.31,8.0,7.09,6.78,7.66,9.88,12.19,13.94,15.47,16.91,17.66,17.16,16.09,15.84,15.59,14.59,12.97,12.31,12.41,12.28,11.72,12.03,13.03,13.53,13.28,13.28,14.88,16.12,16.5,16.19,16.81,16.84,15.97,14.53,13.91,13.47,12.25,10.53,9.41,9.75,10.34,10.91,11.5,12.88,13.5,13.09,11.88,10.94,10.62,10.31,9.5,9.81,11.47,13.16,14.41,16.41,19.16,21.12,21.53,21.38,21.22,20.09,18.16,15.66,14.12,13.19,12.25,11.16,11.06,11.84,11.97,11.75,11.5,12.12,12.59,12.12,12.03,13.38,15.62,17.94,19.62,22.09,24.12,24.72,23.53,22.44,21.88,20.66,19.0,17.84,17.72,17.22,15.78,14.25,13.5,13.16,12.44,11.59,11.97,13.44,15.0,16.0,17.78,19.72,20.56,20.09,19.22,19.06,19.28,18.69,17.69,17.5,17.06,16.19,14.59,14.19,14.19,14.16,12.56,11.22,10.81,10.31,9.47,9.69,11.88,14.34,16.06,17.22,18.88,19.97,20.28,19.34,18.41,17.28,15.06,11.88,9.03,7.62,6.75,5.5,4.69,5.31,6.16,6.31,6.03,6.97,7.56,7.78,7.62,8.0,8.72,9.56,9.59,9.75,10.47,29.47,29.19,29.5,30.31,31.34,32.97,34.69,36.88,38.31,38.94,39.38,39.38,38.72,37.84,37.31,36.62,35.59,34.69,33.88,33.03,32.59,32.41,32.03,31.97,32.28,32.78,33.47,34.31,35.0,35.56,35.62,35.09,34.66,34.69,34.5:4.72,4.38,4.31,4.69,4.66,3.44,2.31,1.78,1.5,0.0,-1.34,-2.16,-3.0,-4.78,-6.41,-7.06,-6.59,-6.03,-5.41,-4.09,-1.53,0.56,1.47,1.91,2.59,3.25,2.56,2.59,4.0,6.34,7.81,9.06,10.47,11.06,10.47,8.12,5.97,4.62,4.0,3.09,2.69,2.91,3.06,1.72,0.59,-0.38,-0.69,-1.78,-2.94,-3.66,-3.66,-3.41,-3.41,-3.31,-2.53,-1.72,-2.03,-2.66,-2.03,-0.94,-0.72,-0.78,-0.5,-0.12,-0.69,-2.47,-4.03,-5.12,-6.44,-8.47,-10.34,-10.88,-11.09,-12.31,-13.12,-12.78,-11.97,-11.91,-11.47,-10.78,-9.31,-8.66,-8.25,-7.81,-7.0,-6.53,-7.19,-7.94,-8.16,-8.41,-9.53,-11.28,-12.0,-12.16,-13.12,-13.88,-14.41,-13.62,-13.09,-13.31,-13.38,-12.91,-12.5,-12.97,-13.06,-12.19,-10.81,-10.56,-11.34,-11.84,-12.31,-13.5,-14.5,-14.88,-13.81,-12.53,-12.06,-10.97,-9.22,-7.56,-6.44,-5.41,-3.41,-1.25,-0.03,0.44,0.88,1.78,1.88,1.38,1.0,1.41,1.66,1.41,0.41,-0.22,-0.88,-2.69,-5.22,-6.22,-6.44,-7.0,-7.94,-7.91,-6.97,-6.25,-6.06,-5.38,-3.66,-2.25,-1.66,-1.81,-1.5,-1.97,-3.75,-6.0,-7.47,-8.06,-8.88,-10.06,-9.75,-8.28,-6.72,-5.66,-5.06,-4.12,-4.09,-5.03,-5.94,-5.22,-3.5,-2.12,-0.88,0.72,3.12,4.12,3.88,3.38,3.09,2.19,0.62,-0.88,-0.94,-0.97,-1.94,-3.09,-3.53,-3.41,-4.31,-5.12,-4.78,-3.66,-2.5,-1.62,-0.62,1.56,3.25,3.75,3.47,3.78,3.53,2.34,0.69,0.66,1.69,2.88,4.22,6.16,8.66,10.72,11.12,11.66,12.88,13.28,12.31,10.09,8.09,5.78,2.16,-1.5,-3.44,-4.16,-4.56,-4.41,-3.34,-1.5,-0.72,-1.12,-2.03,-2.41,-1.88,-1.44,-0.72,1.25,2.69,2.72,1.5,0.47,-0.28,-1.0,-2.09,-2.38,-1.28,0.06,0.72,1.59,3.75,6.19,7.84,8.78,10.31,10.62,9.34,6.5,3.03,-0.03,-3.19,-7.03,-10.31,-12.56,-14.56,-17.09,-18.81,-18.88,-17.88,-16.88,-15.28,-12.16,-7.88,-3.47,0.69,6.0,11.0,14.81,16.94,17.78,18.62,18.44,17.5,16.47,16.41,16.41,16.0,14.81,14.12,13.44,12.56,11.0,10.53,11.09,11.66,12.16,13.28,15.78,18.59,20.56,22.06,23.88,25.22,25.25,24.09,23.12,22.06,20.44,17.75,15.62,14.31,12.69,9.66,6.44,3.72,1.03,-2.22,-5.09,-6.19,-6.47,-6.28,-6.09,-4.22,-0.72,3.28,6.56,10.09,14.09,16.91,18.56,19.56,20.56,21.16,20.38,18.22,16.38,14.62,11.94,8.25,5.28,2.66,0.53,-2.09,-3.62,-3.12,-1.28,0.47,2.34,5.19,8.03,10.12,11.47,13.94,16.91,19.56,21.03,22.25,23.16,22.91,20.09,16.94,14.03,11.16,7.56,4.5,2.66,1.09,-0.72,-3.31,-4.34,-3.88,-2.81,-1.81,-0.19,1.66,2.62,2.06,1.19,1.0,1.44,1.53,1.62,2.47,3.78,4.91,5.5,6.75,9.03,11.22,12.12,12.59,13.28,13.62,12.56,11.34,10.84,10.5,8.91,6.59,4.59,2.72,0.69,-1.31,-2.06,-1.78,-1.09,-1.16,-1.03,-0.31,1.22,2.25,3.72,6.09,8.84,11.16,12.12,12.84,13.19,12.84,11.03,9.47,9.03,9.31,9.0,8.88,9.38,9.66,8.97,7.72,7.16,7.25,7.0,6.53,7.16,8.5,10.03,10.28,10.03,10.34,10.06,8.41,7.78,8.12,9.28,10.28,10.94,11.97,13.22,13.5,12.88,12.47,12.72,12.88,12.0,11.66,11.62,11.69,10.56,8.97,8.38,8.0,7.75,7.53,8.31,10.03,11.06,11.88,13.44,16.09,18.91,20.59,21.5,22.12,22.25,21.06,18.97,17.34,15.88,13.56,10.78,8.94,8.19,7.41,6.19,5.06,4.75,4.69,4.16,3.97,4.66,5.69,6.25,6.12,6.44,7.31,7.91,8.34,9.41,11.81,13.78,14.91,15.28,15.44,14.97,13.06,11.0,9.47,8.78,8.09,7.56,7.84,9.84,11.09,12.09,12.62,13.47,13.31,11.94,10.19,8.88,8.38,7.19,6.38,6.38,6.81,7.03,6.88,7.38,8.56,9.69,9.97,10.41,11.53,12.75,12.88,12.41,11.97,11.22,9.41,7.41,5.84,5.34,4.66,3.69,3.12,3.59,4.09,4.06,4.09,4.84,6.06,7.12,8.31,10.5,13.06,14.34,14.75,14.91,15.69,16.31,16.38,16.66,17.69,18.16,17.22,15.84,15.03,14.19,13.19,12.5,12.22,12.28,11.62,10.22,8.69,7.91,6.97,5.56,4.06,3.5,3.19,2.59,1.94,2.44,3.09,3.38,3.25,3.72,4.97,6.0,6.5,7.12,8.66,9.72,9.44,8.62,8.19,7.09,5.66,4.53,4.28,4.91,5.59,6.0,6.78,8.44,9.88,10.59,11.16,12.06,12.28,11.72,10.78,10.97,11.62,11.56,11.31,10.88,10.44,9.22,7.22,5.56,4.56,3.56,2.44,1.44,2.06,2.88,2.66,1.81,1.44,1.09,0.62,0.25,0.94,2.5,3.69,3.81,3.69,4.0,3.56,2.28,1.19,1.25,2.56,4.34,6.41,10.06,13.66,16.69,18.47,19.78,20.75,20.84,19.22,17.31,15.94,14.03,11.97,10.16,9.5,9.56,9.62,10.0,11.22,13.38,14.84,15.16,15.06,14.84,14.09,12.06,9.84,8.62,7.41,6.28,5.62,6.84,9.47,12.44,15.19,19.03,23.22,26.75,29.19,30.72,32.25,32.69,31.66,30.38,29.78,29.41,28.56,27.03,25.78,23.75,20.88,17.16,13.47,10.97,9.34,8.34,8.84,11.06,14.72,17.22,19.38,21.56,22.53,22.03,20.47,19.16,18.59,17.97,16.56,15.84,15.47,14.94,13.03,11.56,10.12,9.28,7.97,6.66,6.56,7.28,7.62,7.41,7.41,7.22,6.38,4.44,2.31,1.38,0.66,-0.56,-1.44,-1.09,0.22,1.28,3.16,6.44,10.88,15.0,18.38,21.22,23.28,24.22,23.09,21.91,20.91,19.72,17.56,15.62,14.16,13.62,13.06,12.41,13.09,14.66,16.03,16.31,16.84,17.0,16.69,14.94,13.12,12.19,11.84,11.44,11.59,12.94,15.34,16.53,16.91,16.81,16.19,15.12,13.03,11.66,11.88,13.19,14.06,15.09,16.28,16.41,14.56,12.0,9.72,8.0,6.97,6.0,6.28,7.69,9.44,10.5,11.72,13.69,15.84,17.09,18.28,20.19,22.12,22.78,22.28,21.66,20.69,18.5,15.31,12.19,9.66,7.09,3.78,1.38,0.06,-0.03,-0.56,-0.41,0.75,2.59,3.84,4.94,6.81,9.28,11.59,12.5,13.16,14.31,15.44,15.78,16.38,17.41,18.25,17.44,15.84,14.28,13.72,12.75,11.78,11.22,11.16,10.78,9.62,8.62,9.0,9.81,9.81,9.81,10.12,11.06,11.06,11.5,12.66,14.56,15.97,16.53,16.56,16.78,16.06,14.41,12.75,12.38,11.59,9.75,7.25,4.97,2.69,0.31,-1.25,-1.62,-0.62,0.31,1.0,1.47,2.38,2.88,2.5,1.88,2.5,3.84,5.19,6.19,8.12,10.59,12.12,12.81,13.62,14.91,15.62,14.81,13.88,13.97,13.91,12.88,12.5,13.41,15.09,16.19,17.25,18.84,20.81,21.47,21.69,22.0,22.88,23.12,21.88,20.25,19.47,18.94,17.84,16.81,17.0,17.25,16.84,15.72,15.06,15.31,15.34,14.56,13.97,14.25,14.25,12.91,11.34,10.31,9.94,9.12,8.69,9.38,10.44,10.25,9.09,7.78,7.88,8.62,9.59,11.62,14.88,17.47,18.75,19.34,20.69,22.75,23.81,24.53,26.5,28.72,29.5,29.25,28.41,27.0,24.41,20.47,16.69,14.56,12.78,10.97,9.12,8.31,8.0,7.09,6.78,7.66,9.88,12.19,13.94,15.47,16.91,17.66,17.16,16.09,15.84,15.59,14.59,12.97,12.31,12.41,12.28,11.72,12.03,13.03,13.53,13.28,13.28,14.88,16.12,16.5,16.19,16.81,16.84,15.97,14.53,13.91,13.47,12.25,10.53,9.41,9.75,10.34,10.91,11.5,12.88,13.5,13.09,11.88,10.94,10.62,10.31,9.5,9.81,11.47,13.16,14.41,16.41,19.16,21.12,21.53,21.38,21.22,20.09,18.16,15.66,14.12,13.19,12.25,11.16,11.06,11.84,11.97,11.75,11.5,12.12,12.59,12.12,12.03,13.38,15.62,17.94,19.62,22.09,24.12,24.72,23.53,22.44,21.88,20.66,19.0,17.84,17.72,17.22,15.78,14.25,13.5,13.16,12.44,11.59,11.97,13.44,15.0,16.0,17.78,19.72,20.56,20.09,19.22,19.06,19.28,18.69,17.69,17.5,17.06,16.19,14.59,14.19,14.19,14.16,12.56,11.22,10.81,10.31,9.47,9.69,11.88,14.34,16.06,17.22,18.88,19.97,20.28,19.34,18.41,17.28,15.06,11.88,9.03,7.62,6.75,5.5,4.69,5.31,6.16,6.31,6.03,6.97,7.56,7.78,7.62,8.0,8.72,9.56,9.59,9.75,10.47,29.47,29.19,29.5,30.31,31.34,32.97,34.69,36.88,38.31,38.94,39.38,39.38,38.72,37.84,37.31,36.62,35.59,34.69,33.88,33.03,32.59,32.41,32.03,31.97,32.28,32.78,33.47,34.31,35.0,35.56,35.62,35.09,34.66,34.69,34.5,34.53,34.78,35.47,36.59,37.84,38.97,39.97:negativity
12.62,12.31,10.22,9.62,11.62,12.88,11.62,10.69,11.88,12.31,10.09,6.75,5.72,5.19,3.38,1.0,1.53,4.66,6.94,7.88,9.88,13.62,16.47,16.69,16.53,18.66,20.41,19.62,18.19,18.69,20.44,20.09,18.69,18.69,20.28,20.53,18.22,16.56,17.09,17.09,14.84,13.22,14.31,15.97,15.28,14.03,14.81,16.56,17.03,16.0,16.31,18.34,19.47,18.03,17.66,19.53,21.09,20.22,19.03,20.19,21.59,20.75,18.81,18.78,20.12,19.97,18.44,18.16,19.81,20.25,18.47,16.84,17.41,18.22,16.72,14.62,14.69,14.5,12.28,8.72,6.56,6.34,5.53,3.75,3.75,6.56,9.03,9.19,9.0,10.72,11.94,10.72,8.97,8.97,9.5,8.53,6.19,5.78,7.41,8.56,8.12,8.78,11.5,13.72,13.03,11.62,12.28,13.12,11.81,9.72,9.62,10.78,10.31,8.28,7.38,8.56,8.75,6.06,3.88,3.75,3.62,1.59,0.34,1.59,4.0,5.25,5.53,7.47,10.56,11.78,9.97,8.69,8.5,7.66,4.91,2.84,3.22,4.44,3.0,0.94,0.59,1.44,0.22,-2.0,-2.03,0.03,1.97,2.47,4.78,9.59,14.38,16.12,17.53,21.06,23.53,22.69,20.53,19.56,18.97,16.5,12.88,10.34,9.75,8.28,5.03,3.06,3.47,3.53,1.41,-0.66,-0.53,0.59,0.25,-0.75,0.81,3.62,4.91,5.0,5.88,8.09,9.0,6.94,5.16,5.34,5.5,3.06,0.72,0.41,1.41,1.0,0.19,1.09,3.22,3.41,1.31,-0.09,0.0,-0.44,-2.88,-4.53,-3.84,-2.34,-2.94,-3.44,-1.88,1.0,2.59,2.94,5.06,8.38,10.41,10.84,11.94,14.88,17.53,17.25,16.72,18.0,19.5,19.09,18.12,18.66,20.06,19.41,16.44,14.06,12.78,10.19,5.72,2.56,2.38,3.06,2.62,3.38,6.38,10.56,12.53,13.22,14.69,16.88,17.38,15.97,15.38,16.34,16.31,14.12,11.88,11.62,12.0,10.06,8.09,8.28,9.75,9.28,7.5,7.22,7.91,7.41,5.25,4.06,5.12,6.28,5.5,5.34,8.16,11.38,12.47,12.62,13.62,14.81,13.72,11.19,10.19,11.38,12.12,11.16,10.56,12.06,13.16,11.78,10.0,9.88,10.06,7.78,4.72,3.59,4.53,4.38,3.38,3.97,6.66,8.56,8.53,8.53,10.59,12.62,12.47,11.28,11.94,12.47,10.16,6.53,3.91,3.16,1.72,-0.5,-0.69,2.12,4.62,5.16,5.5,7.72,9.31,8.78,7.44,8.25,10.59,11.88,12.41,14.16,17.5,18.53,16.81,14.78,13.78,12.12,8.5,5.59,5.88,7.19,7.16,6.81,7.81,10.12,10.56,9.72,9.78,11.56,12.03,10.47,9.44,10.94,12.09,11.19,10.47,11.53,12.72,11.84,9.5,8.56,8.84,7.69,5.31,4.19,5.97,6.81,5.88,4.62,5.78,6.31,4.47,2.38,2.44,4.03,3.97,2.91,3.97,6.06,6.72,5.34,4.28,5.47,6.22,5.06,4.56,6.78,9.59,10.72,11.5,13.34,15.06,14.47,11.62,9.75,9.78,8.84,6.06,3.94,4.03,3.53,0.84,-1.19,-0.59,1.28,2.19,2.56,4.53,7.22,8.22,6.97,6.72,8.78,10.28,9.94,9.66,11.47,12.28,10.69,8.09,8.06,8.41,7.75,6.34,6.91,9.28,10.56,9.59,9.12,10.0,10.09,8.16,6.62,7.78,9.62,9.31,8.12,8.47,9.62,8.47,6.09,5.66,7.16,7.84,6.84,6.31,8.53,10.38,9.97,9.25,10.56,12.16,11.47,9.88,10.47,12.38,13.28,12.81,13.19,15.06,15.84,14.12,12.47,13.16,13.38,11.59,8.91,8.88,9.25,8.44,6.91,7.38,9.62,10.38,9.72,10.03,12.34,13.94,13.69,13.03,14.41,15.81,14.66,12.19,12.19,13.19,12.56,11.72,12.59,14.53,14.72,12.41,10.31,10.0,9.66,7.84,6.72,8.03,10.03,9.72,7.91,7.88,8.78,8.41,6.84,6.88,8.59,9.28,7.34,5.78,6.56,7.56,6.22,5.16,6.59,8.91,9.34,8.34,9.38,11.22,11.56,9.97,9.44,10.97,12.03,11.19,11.28,13.84,16.31,16.06,14.56,14.03,13.62,10.84,6.75,4.53,4.34,3.69,1.69,1.53,3.53,5.5,5.62,5.94,9.0,12.47,13.38,13.06,14.25,15.69,15.25,13.12,12.88,14.22,14.69,12.84,11.22,11.62,12.06,10.06,8.28,9.41,11.34,11.31,9.84,10.09,10.81,9.59,6.66,5.19,6.41,7.69,7.06,7.09,9.47,11.38,10.56,9.0,10.0,12.12,12.59,12.06,13.34,15.97,16.41,14.47,12.88,12.59,11.12,6.81,3.38,2.91,3.5,2.44,1.78,3.31,5.62,6.38,5.84,7.0,10.03,12.31,12.03,12.34,14.25,15.5,13.25,11.19,10.84,10.88,8.72,5.97,5.78,7.53,7.75,6.84,7.41,9.62,10.38,8.84,7.56,7.75,7.28,4.44,1.75,1.16,1.62,0.59,-1.12,-0.97,0.47,1.25,-0.12,0.0,3.0,5.41,5.53,6.06,8.34,10.16,9.31,7.44,7.66,8.84,8.0,6.62,6.66,8.72,9.75,8.72,9.0,11.56,13.66,13.44,13.0,14.44,15.44,13.97,11.12,10.09,9.66,7.19,3.56,1.62,1.16,1.0,-0.84,-1.66,0.25,2.19,1.75,1.62,3.62,6.19,6.88,6.25,7.16,9.34,9.5,7.78,7.28,8.53,8.81,6.75,5.03,5.66,6.31,4.94,4.0,5.59,8.81,9.84,10.38,11.91,14.75,15.72,14.41,13.88,14.91,14.75,11.91,9.38,9.91,11.06,10.38,10.19,12.5,15.78,17.09,16.91,18.03,20.44,21.09,19.34,18.31,18.78,18.31,15.56,12.72,12.59,12.97,11.12,8.66,8.25,9.53,9.66,9.41,10.94,14.22,16.62,16.47,15.97,17.34,17.94,15.88,13.44,13.16,13.22,11.66,8.78,8.19,9.75,10.19,9.06,9.81,11.91,12.59,10.44,8.12,8.19,9.12,8.28,8.53,11.78,16.12,17.94,17.81,18.06,18.81,17.41,13.72,10.97,9.84,8.25,4.28,0.72,0.22,0.75,-0.34,-0.91,0.97,4.38,6.03,6.38,8.0,11.72,13.12,12.81,12.97,14.88,16.0,14.97,14.25,15.72,18.03,17.91,16.53,16.62,18.25,18.09,16.5,16.38,17.75,18.22,16.25,14.75,15.75,16.5,14.78,12.5,12.88,13.47,11.69,8.81,7.78,8.09,7.44,5.94,6.38,9.5,12.16,12.56,12.94,15.28,17.25,16.56,15.16,16.28,18.31,18.66,17.81,18.28,19.56,19.31,16.75,14.56,15.22,15.16,13.06,11.22,11.72,12.81,11.31,9.25,9.66,11.81,12.75,12.78,14.5,17.62,18.75,17.56,16.97,18.38,19.56,18.22,16.34,16.09,15.97,13.69,10.03,8.53,8.47,6.69,3.66,1.97,2.75,3.59,2.97,3.47,7.16,10.88,12.44,13.16,16.19,18.75,19.22,18.38,19.09,21.62,22.69,21.12,20.41,21.22,20.38,17.66,15.59,16.25,17.59,17.16,15.94,16.91,18.56,18.03,16.41,16.5,18.12,18.69,17.25,16.34,17.78,18.88,17.69,17.0,18.94,21.25,20.97,19.16,18.69,18.53,16.28,12.44,10.34,10.78,10.72,9.31,9.03,11.56,13.66,13.31,12.59,14.19,15.81,15.81,15.03,16.34,19.12,20.53,19.94,19.88,21.25,21.75,20.06,18.75,20.12,21.38,20.53,18.88,19.81,21.69,21.41,20.03,20.16,21.56,21.94,20.44,20.31,22.72,24.28,23.44,22.47,24.03,25.97,26.09,25.97,28.22,30.81,31.12,29.5,28.69,29.75,30.12,28.16,27.53,28.91,29.19,26.72,23.41,23.0,23.22,21.91,20.25,20.5,22.03,21.88,20.22,19.84,21.5,22.5,21.59,21.59,24.25,27.06,27.5,27.03,28.41,29.41,27.75,24.38,22.53,22.25,20.59,17.97,17.22,19.06,20.56,19.97,19.22,21.09,22.81,22.28,21.16,22.31,23.88,23.0,20.69,20.03,20.91,21.09,19.91,20.03,22.41,24.78,24.41,24.16,25.97,27.47,26.34,24.16,23.69,24.16,23.34,21.03,20.94,22.78,24.41,23.53,23.62,25.66,27.5,27.38,27.19,29.28,31.56,31.06,28.81,28.41,28.53,27.75,25.53,24.97,26.47,28.16,27.53,27.47,29.94,31.94,31.53,31.22,32.44,34.75,34.62,33.0,32.44,32.69,31.28,28.19,26.78,27.69,29.16,28.94,29.22,32.06,34.94,34.84,33.66,33.97,34.84,34.47,32.38,31.88,32.47,31.81,28.78,26.91,27.72,28.75,28.16,28.09,30.44,32.81,32.47,31.0,30.44,31.06,29.94,27.56,26.5,27.16,27.03,25.0,23.38,23.72,24.59,22.84,20.78,20.56,21.69,20.62,18.44,17.94,19.28,19.31,17.97,18.28,20.12,21.47,20.5,19.97,22.28,25.06,25.66,26.03,28.19,30.66,31.56,31.06,31.59,33.22,33.25,30.94,29.38,29.72,29.41,26.91,25.06,25.75,26.94,26.75,26.28,27.5,29.56,29.41,27.84,27.53,28.5,28.41,26.88,25.91,27.09,28.34,27.56,26.62,28.19,30.06,29.75,28.22,27.88,28.94,28.5,26.62,26.03,27.59,28.28,26.94,26.28,27.28,28.53,27.16,25.47,25.94,27.81,28.0,27.38,28.62,30.34,30.94,29.19,28.78,29.91,30.25,28.47,26.75:10.69,11.88,12.31,10.09,6.75,5.72,5.19,3.38,1.0,1.53,4.66,6.94,7.88,9.88,13.62,16.47,16.69,16.53,18.66,20.41,19.62,18.19,18.69,20.44,20.09,18.69,18.69,20.28,20.53,18.22,16.56,17.09,17.09,14.84,13.22,14.31,15.97,15.28,14.03,14.81,16.56,17.03,16.0,16.31,18.34,19.47,18.03,17.66,19.53,21.09,20.22,19.03,20.19,21.59,20.75,18.81,18.78,20.12,19.97,18.44,18.16,19.81,20.25,18.47,16.84,17.41,18.22,16.72,14.62,14.69,14.5,12.28,8.72,6.56,6.34,5.53,3.75,3.75,6.56,9.03,9.19,9.0,10.72,11.94,10.72,8.97,8.97,9.5,8.53,6.19,5.78,7.41,8.56,8.12,8.78,11.5,13.72,13.03,11.62,12.28,13.12,11.81,9.72,9.62,10.78,10.31,8.28,7.38,8.56,8.75,6.06,3.88,3.75,3.62,1.59,0.34,1.59,4.0,5.25,5.53,7.47,10.56,11.78,9.97,8.69,8.5,7.66,4.91,2.84,3.22,4.44,3.0,0.94,0.59,1.44,0.22,-2.0,-2.03,0.03,1.97,2.47,4.78,9.59,14.38,16.12,17.53,21.06,23.53,22.69,20.53,19.56,18.97,16.5,12.88,10.34,9.75,8.28,5.03,3.06,3.47,3.53,1.41,-0.66,-0.53,0.59,0.25,-0.75,0.81,3.62,4.91,5.0,5.88,8.09,9.0,6.94,5.16,5.34,5.5,3.06,0.72,0.41,1.41,1.0,0.19,1.09,3.22,3.41,1.31,-0.09,0.0,-0.44,-2.88,-4.53,-3.84,-2.34,-2.94,-3.44,-1.88,1.0,2.59,2.94,5.06,8.38,10.41,10.84,11.94,14.88,17.53,17.25,16.72,18.0,19.5,19.09,18.12,18.66,20.06,19.41,16.44,14.06,12.78,10.19,5.72,2.56,2.38,3.06,2.62,3.38,6.38,10.56,12.53,13.22,14.69,16.88,17.38,15.97,15.38,16.34,16.31,14.12,11.88,11.62,12.0,10.06,8.09,8.28,9.75,9.28,7.5,7.22,7.91,7.41,5.25,4.06,5.12,6.28,5.5,5.34,8.16,11.38,12.47,12.62,13.62,14.81,13.72,11.19,10.19,11.38,12.12,11.16,10.56,12.06,13.16,11.78,10.0,9.88,10.06,7.78,4.72,3.59,4.53,4.38,3.38,3.97,6.66,8.56,8.53,8.53,10.59,12.62,12.47,11.28,11.94,12.47,10.16,6.53,3.91,3.16,1.72,-0.5,-0.69,2.12,4.62,5.16,5.5,7.72,9.31,8.78,7.44,8.25,10.59,11.88,12.41,14.16,17.5,18.53,16.81,14.78,13.78,12.12,8.5,5.59,5.88,7.19,7.16,6.81,7.81,10.12,10.56,9.72,9.78,11.56,12.03,10.47,9.44,10.94,12.09,11.19,10.47,11.53,12.72,11.84,9.5,8.56,8.84,7.69,5.31,4.19,5.97,6.81,5.88,4.62,5.78,6.31,4.47,2.38,2.44,4.03,3.97,2.91,3.97,6.06,6.72,5.34,4.28,5.47,6.22,5.06,4.56,6.78,9.59,10.72,11.5,13.34,15.06,14.47,11.62,9.75,9.78,8.84,6.06,3.94,4.03,3.53,0.84,-1.19,-0.59,1.28,2.19,2.56,4.53,7.22,8.22,6.97,6.72,8.78,10.28,9.94,9.66,11.47,12.28,10.69,8.09,8.06,8.41,7.75,6.34,6.91,9.28,10.56,9.59,9.12,10.0,10.09,8.16,6.62,7.78,9.62,9.31,8.12,8.47,9.62,8.47,6.09,5.66,7.16,7.84,6.84,6.31,8.53,10.38,9.97,9.25,10.56,12.16,11.47,9.88,10.47,12.38,13.28,12.81,13.19,15.06,15.84,14.12,12.47,13.16,13.38,11.59,8.91,8.88,9.25,8.44,6.91,7.38,9.62,10.38,9.72,10.03,12.34,13.94,13.69,13.03,14.41,15.81,14.66,12.19,12.19,13.19,12.56,11.72,12.59,14.53,14.72,12.41,10.31,10.0,9.66,7.84,6.72,8.03,10.03,9.72,7.91,7.88,8.78,8.41,6.84,6.88,8.59,9.28,7.34,5.78,6.56,7.56,6.22,5.16,6.59,8.91,9.34,8.34,9.38,11.22,11.56,9.97,9.44,10.97,12.03,11.19,11.28,13.84,16.31,16.06,14.56,14.03,13.62,10.84,6.75,4.53,4.34,3.69,1.69,1.53,3.53,5.5,5.62,5.94,9.0,12.47,13.38,13.06,14.25,15.69,15.25,13.12,12.88,14.22,14.69,12.84,11.22,11.62,12.06,10.06,8.28,9.41,11.34,11.31,9.84,10.09,10.81,9.59,6.66,5.19,6.41,7.69,7.06,7.09,9.47,11.38,10.56,9.0,10.0,12.12,12.59,12.06,13.34,15.97,16.41,14.47,12.88,12.59,11.12,6.81,3.38,2.91,3.5,2.44,1.78,3.31,5.62,6.38,5.84,7.0,10.03,12.31,12.03,12.34,14.25,15.5,13.25,11.19,10.84,10.88,8.72,5.97,5.78,7.53,7.75,6.84,7.41,9.62,10.38,8.84,7.56,7.75,7.28,4.44,1.75,1.16,1.62,0.59,-1.12,-0.97,0.47,1.25,-0.12,0.0,3.0,5.41,5.53,6.06,8.34,10.16,9.31,7.44,7.66,8.84,8.0,6.62,6.66,8.72,9.75,8.72,9.0,11.56,13.66,13.44,13.0,14.44,15.44,13.97,11.12,10.09,9.66,7.19,3.56,1.62,1.16,1.0,-0.84,-1.66,0.25,2.19,1.75,1.62,3.62,6.19,6.88,6.25,7.16,9.34,9.5,7.78,7.28,8.53,8.81,6.75,5.03,5.66,6.31,4.94,4.0,5.59,8.81,9.84,10.38,11.91,14.75,15.72,14.41,13.88,14.91,14.75,11.91,9.38,9.91,11.06,10.38,10.19,12.5,15.78,17.09,16.91,18.03,20.44,21.09,19.34,18.31,18.78,18.31,15.56,12.72,12.59,12.97,11.12,8.66,8.25,9.53,9.66,9.41,10.94,14.22,16.62,16.47,15.97,17.34,17.94,15.88,13.44,13.16,13.22,11.66,8.78,8.19,9.75,10.19,9.06,9.81,11.91,12.59,10.44,8.12,8.19,9.12,8.28,8.53,11.78,16.12,17.94,17.81,18.06,18.81,17.41,13.72,10.97,9.84,8.25,4.28,0.72,0.22,0.75,-0.34,-0.91,0.97,4.38,6.03,6.38,8.0,11.72,13.12,12.81,12.97,14.88,16.0,14.97,14.25,15.72,18.03,17.91,16.53,16.62,18.25,18.09,16.5,16.38,17.75,18.22,16.25,14.75,15.75,16.5,14.78,12.5,12.88,13.47,11.69,8.81,7.78,8.09,7.44,5.94,6.38,9.5,12.16,12.56,12.94,15.28,17.25,16.56,15.16,16.28,18.31,18.66,17.81,18.28,19.56,19.31,16.75,14.56,15.22,15.16,13.06,11.22,11.72,12.81,11.31,9.25,9.66,11.81,12.75,12.78,14.5,17.62,18.75,17.56,16.97,18.38,19.56,18.22,16.34,16.09,15.97,13.69,10.03,8.53,8.47,6.69,3.66,1.97,2.75,3.59,2.97,3.47,7.16,10.88,12.44,13.16,16.19,18.75,19.22,18.38,19.09,21.62,22.69,21.12,20.41,21.22,20.38,17.66,15.59,16.25,17.59,17.16,15.94,16.91,18.56,18.03,16.41,16.5,18.12,18.69,17.25,16.34,17.78,18.88,17.69,17.0,18.94,21.25,20.97,19.16,18.69,18.53,16.28,12.44,10.34,10.78,10.72,9.31,9.03,11.56,13.66,13.31,12.59,14.19,15.81,15.81,15.03,16.34,19.12,20.53,19.94,19.88,21.25,21.75,20.06,18.75,20.12,21.38,20.53,18.88,19.81,21.69,21.41,20.03,20.16,21.56,21.94,20.44,20.31,22.72,24.28,23.44,22.47,24.03,25.97,26.09,25.97,28.22,30.81,31.12,29.5,28.69,29.75,30.12,28.16,27.53,28.91,29.19,26.72,23.41,23.0,23.22,21.91,20.25,20.5,22.03,21.88,20.22,19.84,21.5,22.5,21.59,21.59,24.25,27.06,27.5,27.03,28.41,29.41,27.75,24.38,22.53,22.25,20.59,17.97,17.22,19.06,20.56,19.97,19.22,21.09,22.81,22.28,21.16,22.31,23.88,23.0,20.69,20.03,20.91,21.09,19.91,20.03,22.41,24.78,24.41,24.16,25.97,27.47,26.34,24.16,23.69,24.16,23.34,21.03,20.94,22.78,24.41,23.53,23.62,25.66,27.5,27.38,27.19,29.28,31.56,31.06,28.81,28.41,28.53,27.75,25.53,24.97,26.47,28.16,27.53,27.47,29.94,31.94,31.53,31.22,32.44,34.75,34.62,33.0,32.44,32.69,31.28,28.19,26.78,27.69,29.16,28.94,29.22,32.06,34.94,34.84,33.66,33.97,34.84,34.47,32.38,31.88,32.47,31.81,28.78,26.91,27.72,28.75,28.16,28.09,30.44,32.81,32.47,31.0,30.44,31.06,29.94,27.56,26.5,27.16,27.03,25.0,23.38,23.72,24.59,22.84,20.78,20.56,21.69,20.62,18.44,17.94,19.28,19.31,17.97,18.28,20.12,21.47,20.5,19.97,22.28,25.06,25.66,26.03,28.19,30.66,31.56,31.06,31.59,33.22,33.25,30.94,29.38,29.72,29.41,26.91,25.06,25.75,26.94,26.75,26.28,27.5,29.56,29.41,27.84,27.53,28.5,28.41,26.88,25.91,27.09,28.34,27.56,26.62,28.19,30.06,29.75,28.22,27.88,28.94,28.5,26.62,26.03,27.59,28.28,26.94,26.28,27.28,28.53,27.16,25.47,25.94,27.81,28.0,27.38,28.62,30.34,30.94,29.19,28.78,29.91,30.25,28.47,26.75,29.5,29.53,28.41,28.69,30.44,31.75,31.16:3.38,1.0,1.53,4.66,6.94,7.88,9.88,13.62,16.47,16.69,16.53,18.66,20.41,19.62,18.19,18.69,20.44,20.09,18.69,18.69,20.28,20.53,18.22,16.56,17.09,17.09,14.84,13.22,14.31,15.97,15.28,14.03,14.81,16.56,17.03,16.0,16.31,18.34,19.47,18.03,17.66,19.53,21.09,20.22,19.03,20.19,21.59,20.75,18.81,18.78,20.12,19.97,18.44,18.16,19.81,20.25,18.47,16.84,17.41,18.22,16.72,14.62,14.69,14.5,12.28,8.72,6.56,6.34,5.53,3.75,3.75,6.56,9.03,9.19,9.0,10.72,11.94,10.72,8.97,8.97,9.5,8.53,6.19,5.78,7.41,8.56,8.12,8.78,11.5,13.72,13.03,11.62,12.28,13.12,11.81,9.72,9.62,10.78,10.31,8.28,7.38,8.56,8.75,6.06,3.88,3.75,3.62,1.59,0.34,1.59,4.0,5.25,5.53,7.47,10.56,11.78,9.97,8.69,8.5,7.66,4.91,2.84,3.22,4.44,3.0,0.94,0.59,1.44,0.22,-2.0,-2.03,0.03,1.97,2.47,4.78,9.59,14.38,16.12,17.53,21.06,23.53,22.69,20.53,19.56,18.97,16.5,12.88,10.34,9.75,8.28,5.03,3.06,3.47,3.53,1.41,-0.66,-0.53,0.59,0.25,-0.75,0.81,3.62,4.91,5.0,5.88,8.09,9.0,6.94,5.16,5.34,5.5,3.06,0.72,0.41,1.41,1.0,0.19,1.09,3.22,3.41,1.31,-0.09,0.0,-0.44,-2.88,-4.53,-3.84,-2.34,-2.94,-3.44,-1.88,1.0,2.59,2.94,5.06,8.38,10.41,10.84,11.94,14.88,17.53,17.25,16.72,18.0,19.5,19.09,18.12,18.66,20.06,19.41,16.44,14.06,12.78,10.19,5.72,2.56,2.38,3.06,2.62,3.38,6.38,10.56,12.53,13.22,14.69,16.88,17.38,15.97,15.38,16.34,16.31,14.12,11.88,11.62,12.0,10.06,8.09,8.28,9.75,9.28,7.5,7.22,7.91,7.41,5.25,4.06,5.12,6.28,5.5,5.34,8.16,11.38,12.47,12.62,13.62,14.81,13.72,11.19,10.19,11.38,12.12,11.16,10.56,12.06,13.16,11.78,10.0,9.88,10.06,7.78,4.72,3.59,4.53,4.38,3.38,3.97,6.66,8.56,8.53,8.53,10.59,12.62,12.47,11.28,11.94,12.47,10.16,6.53,3.91,3.16,1.72,-0.5,-0.69,2.12,4.62,5.16,5.5,7.72,9.31,8.78,7.44,8.25,10.59,11.88,12.41,14.16,17.5,18.53,16.81,14.78,13.78,12.12,8.5,5.59,5.88,7.19,7.16,6.81,7.81,10.12,10.56,9.72,9.78,11.56,12.03,10.47,9.44,10.94,12.09,11.19,10.47,11.53,12.72,11.84,9.5,8.56,8.84,7.69,5.31,4.19,5.97,6.81,5.88,4.62,5.78,6.31,4.47,2.38,2.44,4.03,3.97,2.91,3.97,6.06,6.72,5.34,4.28,5.47,6.22,5.06,4.56,6.78,9.59,10.72,11.5,13.34,15.06,14.47,11.62,9.75,9.78,8.84,6.06,3.94,4.03,3.53,0.84,-1.19,-0.59,1.28,2.19,2.56,4.53,7.22,8.22,6.97,6.72,8.78,10.28,9.94,9.66,11.47,12.28,10.69,8.09,8.06,8.41,7.75,6.34,6.91,9.28,10.56,9.59,9.12,10.0,10.09,8.16,6.62,7.78,9.62,9.31,8.12,8.47,9.62,8.47,6.09,5.66,7.16,7.84,6.84,6.31,8.53,10.38,9.97,9.25,10.56,12.16,11.47,9.88,10.47,12.38,13.28,12.81,13.19,15.06,15.84,14.12,12.47,13.16,13.38,11.59,8.91,8.88,9.25,8.44,6.91,7.38,9.62,10.38,9.72,10.03,12.34,13.94,13.69,13.03,14.41,15.81,14.66,12.19,12.19,13.19,12.56,11.72,12.59,14.53,14.72,12.41,10.31,10.0,9.66,7.84,6.72,8.03,10.03,9.72,7.91,7.88,8.78,8.41,6.84,6.88,8.59,9.28,7.34,5.78,6.56,7.56,6.22,5.16,6.59,8.91,9.34,8.34,9.38,11.22,11.56,9.97,9.44,10.97,12.03,11.19,11.28,13.84,16.31,16.06,14.56,14.03,13.62,10.84,6.75,4.53,4.34,3.69,1.69,1.53,3.53,5.5,5.62,5.94,9.0,12.47,13.38,13.06,14.25,15.69,15.25,13.12,12.88,14.22,14.69,12.84,11.22,11.62,12.06,10.06,8.28,9.41,11.34,11.31,9.84,10.09,10.81,9.59,6.66,5.19,6.41,7.69,7.06,7.09,9.47,11.38,10.56,9.0,10.0,12.12,12.59,12.06,13.34,15.97,16.41,14.47,12.88,12.59,11.12,6.81,3.38,2.91,3.5,2.44,1.78,3.31,5.62,6.38,5.84,7.0,10.03,12.31,12.03,12.34,14.25,15.5,13.25,11.19,10.84,10.88,8.72,5.97,5.78,7.53,7.75,6.84,7.41,9.62,10.38,8.84,7.56,7.75,7.28,4.44,1.75,1.16,1.62,0.59,-1.12,-0.97,0.47,1.25,-0.12,0.0,3.0,5.41,5.53,6.06,8.34,10.16,9.31,7.44,7.66,8.84,8.0,6.62,6.66,8.72,9.75,8.72,9.0,11.56,13.66,13.44,13.0,14.44,15.44,13.97,11.12,10.09,9.66,7.19,3.56,1.62,1.16,1.0,-0.84,-1.66,0.25,2.19,1.75,1.62,3.62,6.19,6.88,6.25,7.16,9.34,9.5,7.78,7.28,8.53,8.81,6.75,5.03,5.66,6.31,4.94,4.0,5.59,8.81,9.84,10.38,11.91,14.75,15.72,14.41,13.88,14.91,14.75,11.91,9.38,9.91,11.06,10.38,10.19,12.5,15.78,17.09,16.91,18.03,20.44,21.09,19.34,18.31,18.78,18.31,15.56,12.72,12.59,12.97,11.12,8.66,8.25,9.53,9.66,9.41,10.94,14.22,16.62,16.47,15.97,17.34,17.94,15.88,13.44,13.16,13.22,11.66,8.78,8.19,9.75,10.19,9.06,9.81,11.91,12.59,10.44,8.12,8.19,9.12,8.28,8.53,11.78,16.12,17.94,17.81,18.06,18.81,17.41,13.72,10.97,9.84,8.25,4.28,0.72,0.22,0.75,-0.34,-0.91,0.97,4.38,6.03,6.38,8.0,11.72,13.12,12.81,12.97,14.88,16.0,14.97,14.25,15.72,18.03,17.91,16.53,16.62,18.25,18.09,16.5,16.38,17.75,18.22,16.25,14.75,15.75,16.5,14.78,12.5,12.88,13.47,11.69,8.81,7.78,8.09,7.44,5.94,6.38,9.5,12.16,12.56,12.94,15.28,17.25,16.56,15.16,16.28,18.31,18.66,17.81,18.28,19.56,19.31,16.75,14.56,15.22,15.16,13.06,11.22,11.72,12.81,11.31,9.25,9.66,11.81,12.75,12.78,14.5,17.62,18.75,17.56,16.97,18.38,19.56,18.22,16.34,16.09,15.97,13.69,10.03,8.53,8.47,6.69,3.66,1.97,2.75,3.59,2.97,3.47,7.16,10.88,12.44,13.16,16.19,18.75,19.22,18.38,19.09,21.62,22.69,21.12,20.41,21.22,20.38,17.66,15.59,16.25,17.59,17.16,15.94,16.91,18.56,18.03,16.41,16.5,18.12,18.69,17.25,16.34,17.78,18.88,17.69,17.0,18.94,21.25,20.97,19.16,18.69,18.53,16.28,12.44,10.34,10.78,10.72,9.31,9.03,11.56,13.66,13.31,12.59,14.19,15.81,15.81,15.03,16.34,19.12,20.53,19.94,19.88,21.25,21.75,20.06,18.75,20.12,21.38,20.53,18.88,19.81,21.69,21.41,20.03,20.16,21.56,21.94,20.44,20.31,22.72,24.28,23.44,22.47,24.03,25.97,26.09,25.97,28.22,30.81,31.12,29.5,28.69,29.75,30.12,28.16,27.53,28.91,29.19,26.72,23.41,23.0,23.22,21.91,20.25,20.5,22.03,21.88,20.22,19.84,21.5,22.5,21.59,21.59,24.25,27.06,27.5,27.03,28.41,29.41,27.75,24.38,22.53,22.25,20.59,17.97,17.22,19.06,20.56,19.97,19.22,21.09,22.81,22.28,21.16,22.31,23.88,23.0,20.69,20.03,20.91,21.09,19.91,20.03,22.41,24.78,24.41,24.16,25.97,27.47,26.34,24.16,23.69,24.16,23.34,21.03,20.94,22.78,24.41,23.53,23.62,25.66,27.5,27.38,27.19,29.28,31.56,31.06,28.81,28.41,28.53,27.75,25.53,24.97,26.47,28.16,27.53,27.47,29.94,31.94,31.53,31.22,32.44,34.75,34.62,33.0,32.44,32.69,31.28,28.19,26.78,27.69,29.16,28.94,29.22,32.06,34.94,34.84,33.66,33.97,34.84,34.47,32.38,31.88,32.47,31.81,28.78,26.91,27.72,28.75,28.16,28.09,30.44,32.81,32.47,31.0,30.44,31.06,29.94,27.56,26.5,27.16,27.03,25.0,23.38,23.72,24.59,22.84,20.78,20.56,21.69,20.62,18.44,17.94,19.28,19.31,17.97,18.28,20.12,21.47,20.5,19.97,22.28,25.06,25.66,26.03,28.19,30.66,31.56,31.06,31.59,33.22,33.25,30.94,29.38,29.72,29.41,26.91,25.06,25.75,26.94,26.75,26.28,27.5,29.56,29.41,27.84,27.53,28.5,28.41,26.88,25.91,27.09,28.34,27.56,26.62,28.19,30.06,29.75,28.22,27.88,28.94,28.5,26.62,26.03,27.59,28.28,26.94,26.28,27.28,28.53,27.16,25.47,25.94,27.81,28.0,27.38,28.62,30.34,30.94,29.19,28.78,29.91,30.25,28.47,26.75,29.5,29.53,28.41,28.69,30.44,31.75,31.16,30.19,30.72,30.09,27.62,24.53,23.06,22.25:13.62,16.47,16.69,16.53,18.66,20.41,19.62,18.19,18.69,20.44,20.09,18.69,18.69,20.28,20.53,18.22,16.56,17.09,17.09,14.84,13.22,14.31,15.97,15.28,14.03,14.81,16.56,17.03,16.0,16.31,18.34,19.47,18.03,17.66,19.53,21.09,20.22,19.03,20.19,21.59,20.75,18.81,18.78,20.12,19.97,18.44,18.16,19.81,20.25,18.47,16.84,17.41,18.22,16.72,14.62,14.69,14.5,12.28,8.72,6.56,6.34,5.53,3.75,3.75,6.56,9.03,9.19,9.0,10.72,11.94,10.72,8.97,8.97,9.5,8.53,6.19,5.78,7.41,8.56,8.12,8.78,11.5,13.72,13.03,11.62,12.28,13.12,11.81,9.72,9.62,10.78,10.31,8.28,7.38,8.56,8.75,6.06,3.88,3.75,3.62,1.59,0.34,1.59,4.0,5.25,5.53,7.47,10.56,11.78,9.97,8.69,8.5,7.66,4.91,2.84,3.22,4.44,3.0,0.94,0.59,1.44,0.22,-2.0,-2.03,0.03,1.97,2.47,4.78,9.59,14.38,16.12,17.53,21.06,23.53,22.69,20.53,19.56,18.97,16.5,12.88,10.34,9.75,8.28,5.03,3.06,3.47,3.53,1.41,-0.66,-0.53,0.59,0.25,-0.75,0.81,3.62,4.91,5.0,5.88,8.09,9.0,6.94,5.16,5.34,5.5,3.06,0.72,0.41,1.41,1.0,0.19,1.09,3.22,3.41,1.31,-0.09,0.0,-0.44,-2.88,-4.53,-3.84,-2.34,-2.94,-3.44,-1.88,1.0,2.59,2.94,5.06,8.38,10.41,10.84,11.94,14.88,17.53,17.25,16.72,18.0,19.5,19.09,18.12,18.66,20.06,19.41,16.44,14.06,12.78,10.19,5.72,2.56,2.38,3.06,2.62,3.38,6.38,10.56,12.53,13.22,14.69,16.88,17.38,15.97,15.38,16.34,16.31,14.12,11.88,11.62,12.0,10.06,8.09,8.28,9.75,9.28,7.5,7.22,7.91,7.41,5.25,4.06,5.12,6.28,5.5,5.34,8.16,11.38,12.47,12.62,13.62,14.81,13.72,11.19,10.19,11.38,12.12,11.16,10.56,12.06,13.16,11.78,10.0,9.88,10.06,7.78,4.72,3.59,4.53,4.38,3.38,3.97,6.66,8.56,8.53,8.53,10.59,12.62,12.47,11.28,11.94,12.47,10.16,6.53,3.91,3.16,1.72,-0.5,-0.69,2.12,4.62,5.16,5.5,7.72,9.31,8.78,7.44,8.25,10.59,11.88,12.41,14.16,17.5,18.53,16.81,14.78,13.78,12.12,8.5,5.59,5.88,7.19,7.16,6.81,7.81,10.12,10.56,9.72,9.78,11.56,12.03,10.47,9.44,10.94,12.09,11.19,10.47,11.53,12.72,11.84,9.5,8.56,8.84,7.69,5.31,4.19,5.97,6.81,5.88,4.62,5.78,6.31,4.47,2.38,2.44,4.03,3.97,2.91,3.97,6.06,6.72,5.34,4.28,5.47,6.22,5.06,4.56,6.78,9.59,10.72,11.5,13.34,15.06,14.47,11.62,9.75,9.78,8.84,6.06,3.94,4.03,3.53,0.84,-1.19,-0.59,1.28,2.19,2.56,4.53,7.22,8.22,6.97,6.72,8.78,10.28,9.94,9.66,11.47,12.28,10.69,8.09,8.06,8.41,7.75,6.34,6.91,9.28,10.56,9.59,9.12,10.0,10.09,8.16,6.62,7.78,9.62,9.31,8.12,8.47,9.62,8.47,6.09,5.66,7.16,7.84,6.84,6.31,8.53,10.38,9.97,9.25,10.56,12.16,11.47,9.88,10.47,12.38,13.28,12.81,13.19,15.06,15.84,14.12,12.47,13.16,13.38,11.59,8.91,8.88,9.25,8.44,6.91,7.38,9.62,10.38,9.72,10.03,12.34,13.94,13.69,13.03,14.41,15.81,14.66,12.19,12.19,13.19,12.56,11.72,12.59,14.53,14.72,12.41,10.31,10.0,9.66,7.84,6.72,8.03,10.03,9.72,7.91,7.88,8.78,8.41,6.84,6.88,8.59,9.28,7.34,5.78,6.56,7.56,6.22,5.16,6.59,8.91,9.34,8.34,9.38,11.22,11.56,9.97,9.44,10.97,12.03,11.19,11.28,13.84,16.31,16.06,14.56,14.03,13.62,10.84,6.75,4.53,4.34,3.69,1.69,1.53,3.53,5.5,5.62,5.94,9.0,12.47,13.38,13.06,14.25,15.69,15.25,13.12,12.88,14.22,14.69,12.84,11.22,11.62,12.06,10.06,8.28,9.41,11.34,11.31,9.84,10.09,10.81,9.59,6.66,5.19,6.41,7.69,7.06,7.09,9.47,11.38,10.56,9.0,10.0,12.12,12.59,12.06,13.34,15.97,16.41,14.47,12.88,12.59,11.12,6.81,3.38,2.91,3.5,2.44,1.78,3.31,5.62,6.38,5.84,7.0,10.03,12.31,12.03,12.34,14.25,15.5,13.25,11.19,10.84,10.88,8.72,5.97,5.78,7.53,7.75,6.84,7.41,9.62,10.38,8.84,7.56,7.75,7.28,4.44,1.75,1.16,1.62,0.59,-1.12,-0.97,0.47,1.25,-0.12,0.0,3.0,5.41,5.53,6.06,8.34,10.16,9.31,7.44,7.66,8.84,8.0,6.62,6.66,8.72,9.75,8.72,9.0,11.56,13.66,13.44,13.0,14.44,15.44,13.97,11.12,10.09,9.66,7.19,3.56,1.62,1.16,1.0,-0.84,-1.66,0.25,2.19,1.75,1.62,3.62,6.19,6.88,6.25,7.16,9.34,9.5,7.78,7.28,8.53,8.81,6.75,5.03,5.66,6.31,4.94,4.0,5.59,8.81,9.84,10.38,11.91,14.75,15.72,14.41,13.88,14.91,14.75,11.91,9.38,9.91,11.06,10.38,10.19,12.5,15.78,17.09,16.91,18.03,20.44,21.09,19.34,18.31,18.78,18.31,15.56,12.72,12.59,12.97,11.12,8.66,8.25,9.53,9.66,9.41,10.94,14.22,16.62,16.47,15.97,17.34,17.94,15.88,13.44,13.16,13.22,11.66,8.78,8.19,9.75,10.19,9.06,9.81,11.91,12.59,10.44,8.12,8.19,9.12,8.28,8.53,11.78,16.12,17.94,17.81,18.06,18.81,17.41,13.72,10.97,9.84,8.25,4.28,0.72,0.22,0.75,-0.34,-0.91,0.97,4.38,6.03,6.38,8.0,11.72,13.12,12.81,12.97,14.88,16.0,14.97,14.25,15.72,18.03,17.91,16.53,16.62,18.25,18.09,16.5,16.38,17.75,18.22,16.25,14.75,15.75,16.5,14.78,12.5,12.88,13.47,11.69,8.81,7.78,8.09,7.44,5.94,6.38,9.5,12.16,12.56,12.94,15.28,17.25,16.56,15.16,16.28,18.31,18.66,17.81,18.28,19.56,19.31,16.75,14.56,15.22,15.16,13.06,11.22,11.72,12.81,11.31,9.25,9.66,11.81,12.75,12.78,14.5,17.62,18.75,17.56,16.97,18.38,19.56,18.22,16.34,16.09,15.97,13.69,10.03,8.53,8.47,6.69,3.66,1.97,2.75,3.59,2.97,3.47,7.16,10.88,12.44,13.16,16.19,18.75,19.22,18.38,19.09,21.62,22.69,21.12,20.41,21.22,20.38,17.66,15.59,16.25,17.59,17.16,15.94,16.91,18.56,18.03,16.41,16.5,18.12,18.69,17.25,16.34,17.78,18.88,17.69,17.0,18.94,21.25,20.97,19.16,18.69,18.53,16.28,12.44,10.34,10.78,10.72,9.31,9.03,11.56,13.66,13.31,12.59,14.19,15.81,15.81,15.03,16.34,19.12,20.53,19.94,19.88,21.25,21.75,20.06,18.75,20.12,21.38,20.53,18.88,19.81,21.69,21.41,20.03,20.16,21.56,21.94,20.44,20.31,22.72,24.28,23.44,22.47,24.03,25.97,26.09,25.97,28.22,30.81,31.12,29.5,28.69,29.75,30.12,28.16,27.53,28.91,29.19,26.72,23.41,23.0,23.22,21.91,20.25,20.5,22.03,21.88,20.22,19.84,21.5,22.5,21.59,21.59,24.25,27.06,27.5,27.03,28.41,29.41,27.75,24.38,22.53,22.25,20.59,17.97,17.22,19.06,20.56,19.97,19.22,21.09,22.81,22.28,21.16,22.31,23.88,23.0,20.69,20.03,20.91,21.09,19.91,20.03,22.41,24.78,24.41,24.16,25.97,27.47,26.34,24.16,23.69,24.16,23.34,21.03,20.94,22.78,24.41,23.53,23.62,25.66,27.5,27.38,27.19,29.28,31.56,31.06,28.81,28.41,28.53,27.75,25.53,24.97,26.47,28.16,27.53,27.47,29.94,31.94,31.53,31.22,32.44,34.75,34.62,33.0,32.44,32.69,31.28,28.19,26.78,27.69,29.16,28.94,29.22,32.06,34.94,34.84,33.66,33.97,34.84,34.47,32.38,31.88,32.47,31.81,28.78,26.91,27.72,28.75,28.16,28.09,30.44,32.81,32.47,31.0,30.44,31.06,29.94,27.56,26.5,27.16,27.03,25.0,23.38,23.72,24.59,22.84,20.78,20.56,21.69,20.62,18.44,17.94,19.28,19.31,17.97,18.28,20.12,21.47,20.5,19.97,22.28,25.06,25.66,26.03,28.19,30.66,31.56,31.06,31.59,33.22,33.25,30.94,29.38,29.72,29.41,26.91,25.06,25.75,26.94,26.75,26.28,27.5,29.56,29.41,27.84,27.53,28.5,28.41,26.88,25.91,27.09,28.34,27.56,26.62,28.19,30.06,29.75,28.22,27.88,28.94,28.5,26.62,26.03,27.59,28.28,26.94,26.28,27.28,28.53,27.16,25.47,25.94,27.81,28.0,27.38,28.62,30.34,30.94,29.19,28.78,29.91,30.25,28.47,26.75,29.5,29.53,28.41,28.69,30.44,31.75,31.16,30.19,30.72,30.09,27.62,24.53,23.06,22.25,21.0,19.72,20.59,23.0,24.94,25.66,26.75:18.19,18.69,20.44,20.09,18.69,18.69,20.28,20.53,18.22,16.56,17.09,17.09,14.84,13.22,14.31,15.97,15.28,14.03,14.81,16.56,17.03,16.0,16.31,18.34,19.47,18.03,17.66,19.53,21.09,20.22,19.03,20.19,21.59,20.75,18.81,18.78,20.12,19.97,18.44,18.16,19.81,20.25,18.47,16.84,17.41,18.22,16.72,14.62,14.69,14.5,12.28,8.72,6.56,6.34,5.53,3.75,3.75,6.56,9.03,9.19,9.0,10.72,11.94,10.72,8.97,8.97,9.5,8.53,6.19,5.78,7.41,8.56,8.12,8.78,11.5,13.72,13.03,11.62,12.28,13.12,11.81,9.72,9.62,10.78,10.31,8.28,7.38,8.56,8.75,6.06,3.88,3.75,3.62,1.59,0.34,1.59,4.0,5.25,5.53,7.47,10.56,11.78,9.97,8.69,8.5,7.66,4.91,2.84,3.22,4.44,3.0,0.94,0.59,1.44,0.22,-2.0,-2.03,0.03,1.97,2.47,4.78,9.59,14.38,16.12,17.53,21.06,23.53,22.69,20.53,19.56,18.97,16.5,12.88,10.34,9.75,8.28,5.03,3.06,3.47,3.53,1.41,-0.66,-0.53,0.59,0.25,-0.75,0.81,3.62,4.91,5.0,5.88,8.09,9.0,6.94,5.16,5.34,5.5,3.06,0.72,0.41,1.41,1.0,0.19,1.09,3.22,3.41,1.31,-0.09,0.0,-0.44,-2.88,-4.53,-3.84,-2.34,-2.94,-3.44,-1.88,1.0,2.59,2.94,5.06,8.38,10.41,10.84,11.94,14.88,17.53,17.25,16.72,18.0,19.5,19.09,18.12,18.66,20.06,19.41,16.44,14.06,12.78,10.19,5.72,2.56,2.38,3.06,2.62,3.38,6.38,10.56,12.53,13.22,14.69,16.88,17.38,15.97,15.38,16.34,16.31,14.12,11.88,11.62,12.0,10.06,8.09,8.28,9.75,9.28,7.5,7.22,7.91,7.41,5.25,4.06,5.12,6.28,5.5,5.34,8.16,11.38,12.47,12.62,13.62,14.81,13.72,11.19,10.19,11.38,12.12,11.16,10.56,12.06,13.16,11.78,10.0,9.88,10.06,7.78,4.72,3.59,4.53,4.38,3.38,3.97,6.66,8.56,8.53,8.53,10.59,12.62,12.47,11.28,11.94,12.47,10.16,6.53,3.91,3.16,1.72,-0.5,-0.69,2.12,4.62,5.16,5.5,7.72,9.31,8.78,7.44,8.25,10.59,11.88,12.41,14.16,17.5,18.53,16.81,14.78,13.78,12.12,8.5,5.59,5.88,7.19,7.16,6.81,7.81,10.12,10.56,9.72,9.78,11.56,12.03,10.47,9.44,10.94,12.09,11.19,10.47,11.53,12.72,11.84,9.5,8.56,8.84,7.69,5.31,4.19,5.97,6.81,5.88,4.62,5.78,6.31,4.47,2.38,2.44,4.03,3.97,2.91,3.97,6.06,6.72,5.34,4.28,5.47,6.22,5.06,4.56,6.78,9.59,10.72,11.5,13.34,15.06,14.47,11.62,9.75,9.78,8.84,6.06,3.94,4.03,3.53,0.84,-1.19,-0.59,1.28,2.19,2.56,4.53,7.22,8.22,6.97,6.72,8.78,10.28,9.94,9.66,11.47,12.28,10.69,8.09,8.06,8.41,7.75,6.34,6.91,9.28,10.56,9.59,9.12,10.0,10.09,8.16,6.62,7.78,9.62,9.31,8.12,8.47,9.62,8.47,6.09,5.66,7.16,7.84,6.84,6.31,8.53,10.38,9.97,9.25,10.56,12.16,11.47,9.88,10.47,12.38,13.28,12.81,13.19,15.06,15.84,14.12,12.47,13.16,13.38,11.59,8.91,8.88,9.25,8.44,6.91,7.38,9.62,10.38,9.72,10.03,12.34,13.94,13.69,13.03,14.41,15.81,14.66,12.19,12.19,13.19,12.56,11.72,12.59,14.53,14.72,12.41,10.31,10.0,9.66,7.84,6.72,8.03,10.03,9.72,7.91,7.88,8.78,8.41,6.84,6.88,8.59,9.28,7.34,5.78,6.56,7.56,6.22,5.16,6.59,8.91,9.34,8.34,9.38,11.22,11.56,9.97,9.44,10.97,12.03,11.19,11.28,13.84,16.31,16.06,14.56,14.03,13.62,10.84,6.75,4.53,4.34,3.69,1.69,1.53,3.53,5.5,5.62,5.94,9.0,12.47,13.38,13.06,14.25,15.69,15.25,13.12,12.88,14.22,14.69,12.84,11.22,11.62,12.06,10.06,8.28,9.41,11.34,11.31,9.84,10.09,10.81,9.59,6.66,5.19,6.41,7.69,7.06,7.09,9.47,11.38,10.56,9.0,10.0,12.12,12.59,12.06,13.34,15.97,16.41,14.47,12.88,12.59,11.12,6.81,3.38,2.91,3.5,2.44,1.78,3.31,5.62,6.38,5.84,7.0,10.03,12.31,12.03,12.34,14.25,15.5,13.25,11.19,10.84,10.88,8.72,5.97,5.78,7.53,7.75,6.84,7.41,9.62,10.38,8.84,7.56,7.75,7.28,4.44,1.75,1.16,1.62,0.59,-1.12,-0.97,0.47,1.25,-0.12,0.0,3.0,5.41,5.53,6.06,8.34,10.16,9.31,7.44,7.66,8.84,8.0,6.62,6.66,8.72,9.75,8.72,9.0,11.56,13.66,13.44,13.0,14.44,15.44,13.97,11.12,10.09,9.66,7.19,3.56,1.62,1.16,1.0,-0.84,-1.66,0.25,2.19,1.75,1.62,3.62,6.19,6.88,6.25,7.16,9.34,9.5,7.78,7.28,8.53,8.81,6.75,5.03,5.66,6.31,4.94,4.0,5.59,8.81,9.84,10.38,11.91,14.75,15.72,14.41,13.88,14.91,14.75,11.91,9.38,9.91,11.06,10.38,10.19,12.5,15.78,17.09,16.91,18.03,20.44,21.09,19.34,18.31,18.78,18.31,15.56,12.72,12.59,12.97,11.12,8.66,8.25,9.53,9.66,9.41,10.94,14.22,16.62,16.47,15.97,17.34,17.94,15.88,13.44,13.16,13.22,11.66,8.78,8.19,9.75,10.19,9.06,9.81,11.91,12.59,10.44,8.12,8.19,9.12,8.28,8.53,11.78,16.12,17.94,17.81,18.06,18.81,17.41,13.72,10.97,9.84,8.25,4.28,0.72,0.22,0.75,-0.34,-0.91,0.97,4.38,6.03,6.38,8.0,11.72,13.12,12.81,12.97,14.88,16.0,14.97,14.25,15.72,18.03,17.91,16.53,16.62,18.25,18.09,16.5,16.38,17.75,18.22,16.25,14.75,15.75,16.5,14.78,12.5,12.88,13.47,11.69,8.81,7.78,8.09,7.44,5.94,6.38,9.5,12.16,12.56,12.94,15.28,17.25,16.56,15.16,16.28,18.31,18.66,17.81,18.28,19.56,19.31,16.75,14.56,15.22,15.16,13.06,11.22,11.72,12.81,11.31,9.25,9.66,11.81,12.75,12.78,14.5,17.62,18.75,17.56,16.97,18.38,19.56,18.22,16.34,16.09,15.97,13.69,10.03,8.53,8.47,6.69,3.66,1.97,2.75,3.59,2.97,3.47,7.16,10.88,12.44,13.16,16.19,18.75,19.22,18.38,19.09,21.62,22.69,21.12,20.41,21.22,20.38,17.66,15.59,16.25,17.59,17.16,15.94,16.91,18.56,18.03,16.41,16.5,18.12,18.69,17.25,16.34,17.78,18.88,17.69,17.0,18.94,21.25,20.97,19.16,18.69,18.53,16.28,12.44,10.34,10.78,10.72,9.31,9.03,11.56,13.66,13.31,12.59,14.19,15.81,15.81,15.03,16.34,19.12,20.53,19.94,19.88,21.25,21.75,20.06,18.75,20.12,21.38,20.53,18.88,19.81,21.69,21.41,20.03,20.16,21.56,21.94,20.44,20.31,22.72,24.28,23.44,22.47,24.03,25.97,26.09,25.97,28.22,30.81,31.12,29.5,28.69,29.75,30.12,28.16,27.53,28.91,29.19,26.72,23.41,23.0,23.22,21.91,20.25,20.5,22.03,21.88,20.22,19.84,21.5,22.5,21.59,21.59,24.25,27.06,27.5,27.03,28.41,29.41,27.75,24.38,22.53,22.25,20.59,17.97,17.22,19.06,20.56,19.97,19.22,21.09,22.81,22.28,21.16,22.31,23.88,23.0,20.69,20.03,20.91,21.09,19.91,20.03,22.41,24.78,24.41,24.16,25.97,27.47,26.34,24.16,23.69,24.16,23.34,21.03,20.94,22.78,24.41,23.53,23.62,25.66,27.5,27.38,27.19,29.28,31.56,31.06,28.81,28.41,28.53,27.75,25.53,24.97,26.47,28.16,27.53,27.47,29.94,31.94,31.53,31.22,32.44,34.75,34.62,33.0,32.44,32.69,31.28,28.19,26.78,27.69,29.16,28.94,29.22,32.06,34.94,34.84,33.66,33.97,34.84,34.47,32.38,31.88,32.47,31.81,28.78,26.91,27.72,28.75,28.16,28.09,30.44,32.81,32.47,31.0,30.44,31.06,29.94,27.56,26.5,27.16,27.03,25.0,23.38,23.72,24.59,22.84,20.78,20.56,21.69,20.62,18.44,17.94,19.28,19.31,17.97,18.28,20.12,21.47,20.5,19.97,22.28,25.06,25.66,26.03,28.19,30.66,31.56,31.06,31.59,33.22,33.25,30.94,29.38,29.72,29.41,26.91,25.06,25.75,26.94,26.75,26.28,27.5,29.56,29.41,27.84,27.53,28.5,28.41,26.88,25.91,27.09,28.34,27.56,26.62,28.19,30.06,29.75,28.22,27.88,28.94,28.5,26.62,26.03,27.59,28.28,26.94,26.28,27.28,28.53,27.16,25.47,25.94,27.81,28.0,27.38,28.62,30.34,30.94,29.19,28.78,29.91,30.25,28.47,26.75,29.5,29.53,28.41,28.69,30.44,31.75,31.16,30.19,30.72,30.09,27.62,24.53,23.06,22.25,21.0,19.72,20.59,23.0,24.94,25.66,26.75,29.19,31.06,31.03,31.34,32.81,34.16,33.88:20.53,18.22,16.56,17.09,17.09,14.84,13.22,14.31,15.97,15.28,14.03,14.81,16.56,17.03,16.0,16.31,18.34,19.47,18.03,17.66,19.53,21.09,20.22,19.03,20.19,21.59,20.75,18.81,18.78,20.12,19.97,18.44,18.16,19.81,20.25,18.47,16.84,17.41,18.22,16.72,14.62,14.69,14.5,12.28,8.72,6.56,6.34,5.53,3.75,3.75,6.56,9.03,9.19,9.0,10.72,11.94,10.72,8.97,8.97,9.5,8.53,6.19,5.78,7.41,8.56,8.12,8.78,11.5,13.72,13.03,11.62,12.28,13.12,11.81,9.72,9.62,10.78,10.31,8.28,7.38,8.56,8.75,6.06,3.88,3.75,3.62,1.59,0.34,1.59,4.0,5.25,5.53,7.47,10.56,11.78,9.97,8.69,8.5,7.66,4.91,2.84,3.22,4.44,3.0,0.94,0.59,1.44,0.22,-2.0,-2.03,0.03,1.97,2.47,4.78,9.59,14.38,16.12,17.53,21.06,23.53,22.69,20.53,19.56,18.97,16.5,12.88,10.34,9.75,8.28,5.03,3.06,3.47,3.53,1.41,-0.66,-0.53,0.59,0.25,-0.75,0.81,3.62,4.91,5.0,5.88,8.09,9.0,6.94,5.16,5.34,5.5,3.06,0.72,0.41,1.41,1.0,0.19,1.09,3.22,3.41,1.31,-0.09,0.0,-0.44,-2.88,-4.53,-3.84,-2.34,-2.94,-3.44,-1.88,1.0,2.59,2.94,5.06,8.38,10.41,10.84,11.94,14.88,17.53,17.25,16.72,18.0,19.5,19.09,18.12,18.66,20.06,19.41,16.44,14.06,12.78,10.19,5.72,2.56,2.38,3.06,2.62,3.38,6.38,10.56,12.53,13.22,14.69,16.88,17.38,15.97,15.38,16.34,16.31,14.12,11.88,11.62,12.0,10.06,8.09,8.28,9.75,9.28,7.5,7.22,7.91,7.41,5.25,4.06,5.12,6.28,5.5,5.34,8.16,11.38,12.47,12.62,13.62,14.81,13.72,11.19,10.19,11.38,12.12,11.16,10.56,12.06,13.16,11.78,10.0,9.88,10.06,7.78,4.72,3.59,4.53,4.38,3.38,3.97,6.66,8.56,8.53,8.53,10.59,12.62,12.47,11.28,11.94,12.47,10.16,6.53,3.91,3.16,1.72,-0.5,-0.69,2.12,4.62,5.16,5.5,7.72,9.31,8.78,7.44,8.25,10.59,11.88,12.41,14.16,17.5,18.53,16.81,14.78,13.78,12.12,8.5,5.59,5.88,7.19,7.16,6.81,7.81,10.12,10.56,9.72,9.78,11.56,12.03,10.47,9.44,10.94,12.09,11.19,10.47,11.53,12.72,11.84,9.5,8.56,8.84,7.69,5.31,4.19,5.97,6.81,5.88,4.62,5.78,6.31,4.47,2.38,2.44,4.03,3.97,2.91,3.97,6.06,6.72,5.34,4.28,5.47,6.22,5.06,4.56,6.78,9.59,10.72,11.5,13.34,15.06,14.47,11.62,9.75,9.78,8.84,6.06,3.94,4.03,3.53,0.84,-1.19,-0.59,1.28,2.19,2.56,4.53,7.22,8.22,6.97,6.72,8.78,10.28,9.94,9.66,11.47,12.28,10.69,8.09,8.06,8.41,7.75,6.34,6.91,9.28,10.56,9.59,9.12,10.0,10.09,8.16,6.62,7.78,9.62,9.31,8.12,8.47,9.62,8.47,6.09,5.66,7.16,7.84,6.84,6.31,8.53,10.38,9.97,9.25,10.56,12.16,11.47,9.88,10.47,12.38,13.28,12.81,13.19,15.06,15.84,14.12,12.47,13.16,13.38,11.59,8.91,8.88,9.25,8.44,6.91,7.38,9.62,10.38,9.72,10.03,12.34,13.94,13.69,13.03,14.41,15.81,14.66,12.19,12.19,13.19,12.56,11.72,12.59,14.53,14.72,12.41,10.31,10.0,9.66,7.84,6.72,8.03,10.03,9.72,7.91,7.88,8.78,8.41,6.84,6.88,8.59,9.28,7.34,5.78,6.56,7.56,6.22,5.16,6.59,8.91,9.34,8.34,9.38,11.22,11.56,9.97,9.44,10.97,12.03,11.19,11.28,13.84,16.31,16.06,14.56,14.03,13.62,10.84,6.75,4.53,4.34,3.69,1.69,1.53,3.53,5.5,5.62,5.94,9.0,12.47,13.38,13.06,14.25,15.69,15.25,13.12,12.88,14.22,14.69,12.84,11.22,11.62,12.06,10.06,8.28,9.41,11.34,11.31,9.84,10.09,10.81,9.59,6.66,5.19,6.41,7.69,7.06,7.09,9.47,11.38,10.56,9.0,10.0,12.12,12.59,12.06,13.34,15.97,16.41,14.47,12.88,12.59,11.12,6.81,3.38,2.91,3.5,2.44,1.78,3.31,5.62,6.38,5.84,7.0,10.03,12.31,12.03,12.34,14.25,15.5,13.25,11.19,10.84,10.88,8.72,5.97,5.78,7.53,7.75,6.84,7.41,9.62,10.38,8.84,7.56,7.75,7.28,4.44,1.75,1.16,1.62,0.59,-1.12,-0.97,0.47,1.25,-0.12,0.0,3.0,5.41,5.53,6.06,8.34,10.16,9.31,7.44,7.66,8.84,8.0,6.62,6.66,8.72,9.75,8.72,9.0,11.56,13.66,13.44,13.0,14.44,15.44,13.97,11.12,10.09,9.66,7.19,3.56,1.62,1.16,1.0,-0.84,-1.66,0.25,2.19,1.75,1.62,3.62,6.19,6.88,6.25,7.16,9.34,9.5,7.78,7.28,8.53,8.81,6.75,5.03,5.66,6.31,4.94,4.0,5.59,8.81,9.84,10.38,11.91,14.75,15.72,14.41,13.88,14.91,14.75,11.91,9.38,9.91,11.06,10.38,10.19,12.5,15.78,17.09,16.91,18.03,20.44,21.09,19.34,18.31,18.78,18.31,15.56,12.72,12.59,12.97,11.12,8.66,8.25,9.53,9.66,9.41,10.94,14.22,16.62,16.47,15.97,17.34,17.94,15.88,13.44,13.16,13.22,11.66,8.78,8.19,9.75,10.19,9.06,9.81,11.91,12.59,10.44,8.12,8.19,9.12,8.28,8.53,11.78,16.12,17.94,17.81,18.06,18.81,17.41,13.72,10.97,9.84,8.25,4.28,0.72,0.22,0.75,-0.34,-0.91,0.97,4.38,6.03,6.38,8.0,11.72,13.12,12.81,12.97,14.88,16.0,14.97,14.25,15.72,18.03,17.91,16.53,16.62,18.25,18.09,16.5,16.38,17.75,18.22,16.25,14.75,15.75,16.5,14.78,12.5,12.88,13.47,11.69,8.81,7.78,8.09,7.44,5.94,6.38,9.5,12.16,12.56,12.94,15.28,17.25,16.56,15.16,16.28,18.31,18.66,17.81,18.28,19.56,19.31,16.75,14.56,15.22,15.16,13.06,11.22,11.72,12.81,11.31,9.25,9.66,11.81,12.75,12.78,14.5,17.62,18.75,17.56,16.97,18.38,19.56,18.22,16.34,16.09,15.97,13.69,10.03,8.53,8.47,6.69,3.66,1.97,2.75,3.59,2.97,3.47,7.16,10.88,12.44,13.16,16.19,18.75,19.22,18.38,19.09,21.62,22.69,21.12,20.41,21.22,20.38,17.66,15.59,16.25,17.59,17.16,15.94,16.91,18.56,18.03,16.41,16.5,18.12,18.69,17.25,16.34,17.78,18.88,17.69,17.0,18.94,21.25,20.97,19.16,18.69,18.53,16.28,12.44,10.34,10.78,10.72,9.31,9.03,11.56,13.66,13.31,12.59,14.19,15.81,15.81,15.03,16.34,19.12,20.53,19.94,19.88,21.25,21.75,20.06,18.75,20.12,21.38,20.53,18.88,19.81,21.69,21.41,20.03,20.16,21.56,21.94,20.44,20.31,22.72,24.28,23.44,22.47,24.03,25.97,26.09,25.97,28.22,30.81,31.12,29.5,28.69,29.75,30.12,28.16,27.53,28.91,29.19,26.72,23.41,23.0,23.22,21.91,20.25,20.5,22.03,21.88,20.22,19.84,21.5,22.5,21.59,21.59,24.25,27.06,27.5,27.03,28.41,29.41,27.75,24.38,22.53,22.25,20.59,17.97,17.22,19.06,20.56,19.97,19.22,21.09,22.81,22.28,21.16,22.31,23.88,23.0,20.69,20.03,20.91,21.09,19.91,20.03,22.41,24.78,24.41,24.16,25.97,27.47,26.34,24.16,23.69,24.16,23.34,21.03,20.94,22.78,24.41,23.53,23.62,25.66,27.5,27.38,27.19,29.28,31.56,31.06,28.81,28.41,28.53,27.75,25.53,24.97,26.47,28.16,27.53,27.47,29.94,31.94,31.53,31.22,32.44,34.75,34.62,33.0,32.44,32.69,31.28,28.19,26.78,27.69,29.16,28.94,29.22,32.06,34.94,34.84,33.66,33.97,34.84,34.47,32.38,31.88,32.47,31.81,28.78,26.91,27.72,28.75,28.16,28.09,30.44,32.81,32.47,31.0,30.44,31.06,29.94,27.56,26.5,27.16,27.03,25.0,23.38,23.72,24.59,22.84,20.78,20.56,21.69,20.62,18.44,17.94,19.28,19.31,17.97,18.28,20.12,21.47,20.5,19.97,22.28,25.06,25.66,26.03,28.19,30.66,31.56,31.06,31.59,33.22,33.25,30.94,29.38,29.72,29.41,26.91,25.06,25.75,26.94,26.75,26.28,27.5,29.56,29.41,27.84,27.53,28.5,28.41,26.88,25.91,27.09,28.34,27.56,26.62,28.19,30.06,29.75,28.22,27.88,28.94,28.5,26.62,26.03,27.59,28.28,26.94,26.28,27.28,28.53,27.16,25.47,25.94,27.81,28.0,27.38,28.62,30.34,30.94,29.19,28.78,29.91,30.25,28.47,26.75,29.5,29.53,28.41,28.69,30.44,31.75,31.16,30.19,30.72,30.09,27.62,24.53,23.06,22.25,21.0,19.72,20.59,23.0,24.94,25.66,26.75,29.19,31.06,31.03,31.34,32.81,34.16,33.88,33.34,34.09,35.34,35.78,35.09,35.47,36.53:14.31,15.97,15.28,14.03,14.81,16.56,17.03,16.0,16.31,18.34,19.47,18.03,17.66,19.53,21.09,20.22,19.03,20.19,21.59,20.75,18.81,18.78,20.12,19.97,18.44,18.16,19.81,20.25,18.47,16.84,17.41,18.22,16.72,14.62,14.69,14.5,12.28,8.72,6.56,6.34,5.53,3.75,3.75,6.56,9.03,9.19,9.0,10.72,11.94,10.72,8.97,8.97,9.5,8.53,6.19,5.78,7.41,8.56,8.12,8.78,11.5,13.72,13.03,11.62,12.28,13.12,11.81,9.72,9.62,10.78,10.31,8.28,7.38,8.56,8.75,6.06,3.88,3.75,3.62,1.59,0.34,1.59,4.0,5.25,5.53,7.47,10.56,11.78,9.97,8.69,8.5,7.66,4.91,2.84,3.22,4.44,3.0,0.94,0.59,1.44,0.22,-2.0,-2.03,0.03,1.97,2.47,4.78,9.59,14.38,16.12,17.53,21.06,23.53,22.69,20.53,19.56,18.97,16.5,12.88,10.34,9.75,8.28,5.03,3.06,3.47,3.53,1.41,-0.66,-0.53,0.59,0.25,-0.75,0.81,3.62,4.91,5.0,5.88,8.09,9.0,6.94,5.16,5.34,5.5,3.06,0.72,0.41,1.41,1.0,0.19,1.09,3.22,3.41,1.31,-0.09,0.0,-0.44,-2.88,-4.53,-3.84,-2.34,-2.94,-3.44,-1.88,1.0,2.59,2.94,5.06,8.38,10.41,10.84,11.94,14.88,17.53,17.25,16.72,18.0,19.5,19.09,18.12,18.66,20.06,19.41,16.44,14.06,12.78,10.19,5.72,2.56,2.38,3.06,2.62,3.38,6.38,10.56,12.53,13.22,14.69,16.88,17.38,15.97,15.38,16.34,16.31,14.12,11.88,11.62,12.0,10.06,8.09,8.28,9.75,9.28,7.5,7.22,7.91,7.41,5.25,4.06,5.12,6.28,5.5,5.34,8.16,11.38,12.47,12.62,13.62,14.81,13.72,11.19,10.19,11.38,12.12,11.16,10.56,12.06,13.16,11.78,10.0,9.88,10.06,7.78,4.72,3.59,4.53,4.38,3.38,3.97,6.66,8.56,8.53,8.53,10.59,12.62,12.47,11.28,11.94,12.47,10.16,6.53,3.91,3.16,1.72,-0.5,-0.69,2.12,4.62,5.16,5.5,7.72,9.31,8.78,7.44,8.25,10.59,11.88,12.41,14.16,17.5,18.53,16.81,14.78,13.78,12.12,8.5,5.59,5.88,7.19,7.16,6.81,7.81,10.12,10.56,9.72,9.78,11.56,12.03,10.47,9.44,10.94,12.09,11.19,10.47,11.53,12.72,11.84,9.5,8.56,8.84,7.69,5.31,4.19,5.97,6.81,5.88,4.62,5.78,6.31,4.47,2.38,2.44,4.03,3.97,2.91,3.97,6.06,6.72,5.34,4.28,5.47,6.22,5.06,4.56,6.78,9.59,10.72,11.5,13.34,15.06,14.47,11.62,9.75,9.78,8.84,6.06,3.94,4.03,3.53,0.84,-1.19,-0.59,1.28,2.19,2.56,4.53,7.22,8.22,6.97,6.72,8.78,10.28,9.94,9.66,11.47,12.28,10.69,8.09,8.06,8.41,7.75,6.34,6.91,9.28,10.56,9.59,9.12,10.0,10.09,8.16,6.62,7.78,9.62,9.31,8.12,8.47,9.62,8.47,6.09,5.66,7.16,7.84,6.84,6.31,8.53,10.38,9.97,9.25,10.56,12.16,11.47,9.88,10.47,12.38,13.28,12.81,13.19,15.06,15.84,14.12,12.47,13.16,13.38,11.59,8.91,8.88,9.25,8.44,6.91,7.38,9.62,10.38,9.72,10.03,12.34,13.94,13.69,13.03,14.41,15.81,14.66,12.19,12.19,13.19,12.56,11.72,12.59,14.53,14.72,12.41,10.31,10.0,9.66,7.84,6.72,8.03,10.03,9.72,7.91,7.88,8.78,8.41,6.84,6.88,8.59,9.28,7.34,5.78,6.56,7.56,6.22,5.16,6.59,8.91,9.34,8.34,9.38,11.22,11.56,9.97,9.44,10.97,12.03,11.19,11.28,13.84,16.31,16.06,14.56,14.03,13.62,10.84,6.75,4.53,4.34,3.69,1.69,1.53,3.53,5.5,5.62,5.94,9.0,12.47,13.38,13.06,14.25,15.69,15.25,13.12,12.88,14.22,14.69,12.84,11.22,11.62,12.06,10.06,8.28,9.41,11.34,11.31,9.84,10.09,10.81,9.59,6.66,5.19,6.41,7.69,7.06,7.09,9.47,11.38,10.56,9.0,10.0,12.12,12.59,12.06,13.34,15.97,16.41,14.47,12.88,12.59,11.12,6.81,3.38,2.91,3.5,2.44,1.78,3.31,5.62,6.38,5.84,7.0,10.03,12.31,12.03,12.34,14.25,15.5,13.25,11.19,10.84,10.88,8.72,5.97,5.78,7.53,7.75,6.84,7.41,9.62,10.38,8.84,7.56,7.75,7.28,4.44,1.75,1.16,1.62,0.59,-1.12,-0.97,0.47,1.25,-0.12,0.0,3.0,5.41,5.53,6.06,8.34,10.16,9.31,7.44,7.66,8.84,8.0,6.62,6.66,8.72,9.75,8.72,9.0,11.56,13.66,13.44,13.0,14.44,15.44,13.97,11.12,10.09,9.66,7.19,3.56,1.62,1.16,1.0,-0.84,-1.66,0.25,2.19,1.75,1.62,3.62,6.19,6.88,6.25,7.16,9.34,9.5,7.78,7.28,8.53,8.81,6.75,5.03,5.66,6.31,4.94,4.0,5.59,8.81,9.84,10.38,11.91,14.75,15.72,14.41,13.88,14.91,14.75,11.91,9.38,9.91,11.06,10.38,10.19,12.5,15.78,17.09,16.91,18.03,20.44,21.09,19.34,18.31,18.78,18.31,15.56,12.72,12.59,12.97,11.12,8.66,8.25,9.53,9.66,9.41,10.94,14.22,16.62,16.47,15.97,17.34,17.94,15.88,13.44,13.16,13.22,11.66,8.78,8.19,9.75,10.19,9.06,9.81,11.91,12.59,10.44,8.12,8.19,9.12,8.28,8.53,11.78,16.12,17.94,17.81,18.06,18.81,17.41,13.72,10.97,9.84,8.25,4.28,0.72,0.22,0.75,-0.34,-0.91,0.97,4.38,6.03,6.38,8.0,11.72,13.12,12.81,12.97,14.88,16.0,14.97,14.25,15.72,18.03,17.91,16.53,16.62,18.25,18.09,16.5,16.38,17.75,18.22,16.25,14.75,15.75,16.5,14.78,12.5,12.88,13.47,11.69,8.81,7.78,8.09,7.44,5.94,6.38,9.5,12.16,12.56,12.94,15.28,17.25,16.56,15.16,16.28,18.31,18.66,17.81,18.28,19.56,19.31,16.75,14.56,15.22,15.16,13.06,11.22,11.72,12.81,11.31,9.25,9.66,11.81,12.75,12.78,14.5,17.62,18.75,17.56,16.97,18.38,19.56,18.22,16.34,16.09,15.97,13.69,10.03,8.53,8.47,6.69,3.66,1.97,2.75,3.59,2.97,3.47,7.16,10.88,12.44,13.16,16.19,18.75,19.22,18.38,19.09,21.62,22.69,21.12,20.41,21.22,20.38,17.66,15.59,16.25,17.59,17.16,15.94,16.91,18.56,18.03,16.41,16.5,18.12,18.69,17.25,16.34,17.78,18.88,17.69,17.0,18.94,21.25,20.97,19.16,18.69,18.53,16.28,12.44,10.34,10.78,10.72,9.31,9.03,11.56,13.66,13.31,12.59,14.19,15.81,15.81,15.03,16.34,19.12,20.53,19.94,19.88,21.25,21.75,20.06,18.75,20.12,21.38,20.53,18.88,19.81,21.69,21.41,20.03,20.16,21.56,21.94,20.44,20.31,22.72,24.28,23.44,22.47,24.03,25.97,26.09,25.97,28.22,30.81,31.12,29.5,28.69,29.75,30.12,28.16,27.53,28.91,29.19,26.72,23.41,23.0,23.22,21.91,20.25,20.5,22.03,21.88,20.22,19.84,21.5,22.5,21.59,21.59,24.25,27.06,27.5,27.03,28.41,29.41,27.75,24.38,22.53,22.25,20.59,17.97,17.22,19.06,20.56,19.97,19.22,21.09,22.81,22.28,21.16,22.31,23.88,23.0,20.69,20.03,20.91,21.09,19.91,20.03,22.41,24.78,24.41,24.16,25.97,27.47,26.34,24.16,23.69,24.16,23.34,21.03,20.94,22.78,24.41,23.53,23.62,25.66,27.5,27.38,27.19,29.28,31.56,31.06,28.81,28.41,28.53,27.75,25.53,24.97,26.47,28.16,27.53,27.47,29.94,31.94,31.53,31.22,32.44,34.75,34.62,33.0,32.44,32.69,31.28,28.19,26.78,27.69,29.16,28.94,29.22,32.06,34.94,34.84,33.66,33.97,34.84,34.47,32.38,31.88,32.47,31.81,28.78,26.91,27.72,28.75,28.16,28.09,30.44,32.81,32.47,31.0,30.44,31.06,29.94,27.56,26.5,27.16,27.03,25.0,23.38,23.72,24.59,22.84,20.78,20.56,21.69,20.62,18.44,17.94,19.28,19.31,17.97,18.28,20.12,21.47,20.5,19.97,22.28,25.06,25.66,26.03,28.19,30.66,31.56,31.06,31.59,33.22,33.25,30.94,29.38,29.72,29.41,26.91,25.06,25.75,26.94,26.75,26.28,27.5,29.56,29.41,27.84,27.53,28.5,28.41,26.88,25.91,27.09,28.34,27.56,26.62,28.19,30.06,29.75,28.22,27.88,28.94,28.5,26.62,26.03,27.59,28.28,26.94,26.28,27.28,28.53,27.16,25.47,25.94,27.81,28.0,27.38,28.62,30.34,30.94,29.19,28.78,29.91,30.25,28.47,26.75,29.5,29.53,28.41,28.69,30.44,31.75,31.16,30.19,30.72,30.09,27.62,24.53,23.06,22.25,21.0,19.72,20.59,23.0,24.94,25.66,26.75,29.19,31.06,31.03,31.34,32.81,34.16,33.88,33.34,34.09,35.34,35.78,35.09,35.47,36.53,36.38,34.31,32.16,31.41,29.91,27.31,25.44:negativity
6.72,5.22,4.91,5.78,5.88,3.75,2.84,4.56,6.84,7.25,7.09,8.84,11.12,11.09,10.19,10.66,12.28,13.16,12.0,11.66,13.53,14.41,12.69,10.59,10.22,10.5,9.47,8.53,10.91,15.16,17.16,16.84,17.16,18.19,17.53,15.22,14.5,16.44,18.12,17.62,16.78,17.59,18.69,17.09,14.62,13.75,14.53,14.03,12.41,12.56,15.0,16.19,15.34,14.53,15.44,16.53,14.88,13.34,13.75,15.09,14.41,12.69,12.88,14.06,14.09,12.12,10.81,11.25,11.19,8.91,7.25,8.53,10.66,10.59,9.47,9.56,9.56,7.09,3.09,1.41,2.16,2.41,1.59,2.12,4.5,6.09,4.56,2.91,3.72,5.72,6.34,7.12,10.28,14.62,16.5,15.78,15.81,16.91,16.81,14.06,12.0,11.75,11.28,8.0,4.44,3.69,4.44,3.31,1.59,1.44,2.94,2.5,0.47,-0.5,0.66,1.22,-0.75,-2.31,-0.81,0.75,0.22,-0.25,1.56,4.19,4.81,3.75,3.88,5.56,5.88,4.91,5.56,8.84,11.94,12.69,12.94,15.16,16.16,14.0,10.38,8.28,7.47,5.16,2.34,1.56,3.25,4.78,4.75,5.81,9.75,13.66,14.84,15.19,17.47,19.44,18.38,16.12,15.31,15.72,14.16,11.0,9.06,9.41,8.97,6.16,3.75,3.34,2.69,0.19,-2.47,-2.12,-0.19,-0.12,-0.94,-0.03,2.47,3.31,2.25,2.16,4.38,5.75,4.62,4.03,6.09,8.59,9.31,9.34,11.69,14.72,15.09,13.16,12.31,12.38,10.59,6.38,2.69,1.44,0.06,-3.34,-5.75,-5.12,-3.0,-2.75,-3.09,-1.84,0.5,0.38,-1.41,-1.97,-0.5,0.31,-0.44,-1.03,0.75,2.53,2.09,1.03,2.62,4.97,5.12,4.19,5.09,7.12,7.72,6.34,5.53,6.38,6.56,4.38,2.34,3.16,3.97,2.22,-0.41,-0.81,-0.31,-1.03,-2.62,-2.19,0.09,0.88,-0.41,-0.59,2.09,3.81,3.53,2.59,4.0,5.34,5.09,3.62,4.0,5.75,5.25,3.41,3.25,5.69,7.53,7.19,7.75,10.12,12.28,12.0,11.03,12.5,14.66,14.69,13.38,14.06,16.09,16.5,14.66,13.47,13.69,12.38,8.31,4.31,2.84,2.16,-0.53,-2.78,-2.06,-0.03,0.22,-1.22,-1.03,0.41,0.34,-1.22,-1.12,1.56,4.12,4.81,5.34,8.5,11.75,11.97,10.94,10.84,10.69,8.5,4.25,2.06,2.47,2.75,2.31,3.03,6.72,9.91,10.81,11.69,14.69,18.19,19.5,19.56,21.41,23.62,23.97,22.34,21.62,22.09,20.94,17.22,13.28,11.59,9.41,4.78,0.0,-2.19,-3.25,-5.47,-7.84,-7.62,-5.16,-3.09,-2.56,-0.31,5.0,9.44,11.44,13.66,17.59,20.88,21.25,20.69,21.53,22.53,21.25,17.75,15.16,13.88,11.0,5.5,1.34,-0.66,-2.16,-5.12,-7.12,-5.44,-2.47,-0.78,0.41,3.22,6.53,7.81,6.97,7.25,9.28,10.69,9.62,9.16,10.94,12.78,12.56,12.25,14.53,17.28,17.72,16.62,16.31,16.53,14.88,11.31,8.94,8.72,8.38,5.88,3.97,4.12,4.25,2.19,-0.16,-0.75,-0.56,-2.03,-5.03,-5.88,-4.81,-4.16,-4.97,-4.66,-2.38,-0.81,-2.5,-4.25,-4.06,-3.53,-5.22,-7.53,-7.5,-6.34,-6.66,-8.25,-7.88,-5.59,-3.72,-3.88,-3.19,-0.31,2.34,2.38,2.69,5.28,8.72,10.56,11.81,15.53,19.84,22.38,21.91,20.97,20.81,19.31,15.22,11.75,11.03,10.88,8.47,6.0,5.19,5.16,2.97,-0.06,-1.25,-0.56,-0.81,-2.44,-2.84,-1.06,0.56,0.22,-0.03,1.81,4.41,4.5,4.09,5.5,8.22,8.84,8.19,9.41,12.12,14.28,14.22,14.5,16.03,16.69,14.5,11.28,10.22,10.09,8.47,7.16,8.06,10.97,12.78,12.75,13.56,16.12,17.78,17.12,16.5,17.31,16.88,12.94,8.31,5.19,3.41,0.88,-1.84,-2.31,-0.03,1.28,0.94,1.53,3.91,5.53,4.5,3.88,5.66,7.69,7.75,7.38,9.34,12.31,13.53,13.53,14.56,16.5,16.88,15.06,14.09,15.16,16.28,14.88,12.97,13.09,13.41,11.69,9.69,10.0,11.88,11.97,10.25,9.72,11.34,12.06,11.22,11.06,13.16,14.53,13.06,10.41,9.16,8.31,5.5,1.91,0.81,2.25,2.91,2.41,3.25,6.12,8.19,8.16,8.72,10.81,13.19,13.38,12.47,13.12,14.91,14.28,12.5,12.12,13.09,12.75,10.88,9.5,10.41,10.97,9.22,7.25,7.69,8.72,7.62,6.19,6.53,7.5,6.66,4.06,3.16,4.41,5.12,4.25,4.03,5.69,6.53,5.06,3.62,4.84,6.88,7.34,7.25,8.44,10.44,10.53,8.5,7.62,9.25,10.09,9.06,8.69,10.78,12.19,11.44,10.19,10.62,11.59,10.66,8.88,9.06,10.78,11.28,10.31,10.41,12.34,13.69,13.0,12.12,13.25,14.22,13.0,10.97,10.72,11.38,10.31,8.19,7.75,9.38,10.28,10.16,11.12,14.75,17.66,18.5,18.72,20.47,22.19,21.69,20.0,19.72,20.78,20.19,18.09,16.97,18.09,17.94,15.81,14.0,15.09,15.88,15.19,13.94,14.97,16.75,16.72,15.94,16.66,18.94,19.47,18.41,17.81,18.91,19.16,17.34,15.56,16.03,16.41,14.88,12.62,12.97,14.16,14.09,13.19,13.91,16.03,17.25,16.19,15.06,15.72,16.03,13.75,11.97,13.31,14.97,14.25,12.84,13.38,14.75,15.03,13.47,13.31,14.78,15.53,14.5,13.94,15.81,17.03,15.19,12.66,12.62,12.84,10.91,8.31,8.06,9.0,8.84,7.41,7.5,9.97,12.22,12.72,14.09,17.97,21.62,22.31,21.84,23.16,24.59,23.78,21.88,21.47,22.0,21.62,19.38,17.66,17.72,17.25,14.16,11.38,11.38,12.19,11.66,11.25,13.09,15.88,17.09,16.25,17.0,19.47,21.5,21.44,22.34,25.0,26.16,24.75,22.41,22.38,22.28,20.62,18.25,17.88,19.31,19.41,18.47,18.81,20.97,21.97,20.0,18.53,19.34,19.94,18.47,17.19,17.91,18.88,17.81,15.81,15.84,17.03,17.56,16.28,15.84,17.03,17.69,15.56,14.12,14.56,15.59,14.22,12.62,13.25,14.72,14.47,12.75,12.5,13.91,13.88,12.28,11.5,12.69,13.22,11.22,9.12,9.28,10.34,9.53,8.53,9.56,11.75,12.25,11.31,12.12,14.81,16.56,15.94,15.41,16.94,18.06,16.34,14.75,15.31,16.47,15.47,13.72,14.31,16.03,16.5,14.97,15.19,16.88,17.66,16.06,14.94,16.09,17.22,15.66,14.06,14.34,15.12,13.66,10.94,10.28,11.5,12.09,11.84,13.31,16.88,19.28,18.78,18.12,18.97,19.81,18.25,15.94,15.97,17.03,16.31,14.5,14.62,16.22,16.91,15.91,16.12,17.97,19.34,17.84,15.62,14.88,14.34,11.53,8.31,7.78,8.91,9.16,8.25,9.06,11.53,13.16,12.62,12.88,15.25,17.38,16.88,16.41,17.59,19.0,17.94,15.66,15.0,15.72,15.38,13.38,13.03,14.72,15.12,13.25,11.62,12.75,13.62,12.91,11.75,13.31,15.69,16.31,16.25,18.06,21.38,22.81,21.59,20.5,20.28,18.47,13.59,9.47,8.34,8.59,7.84,8.12,11.0,14.75,16.47,16.56,18.09,20.94,22.88,22.72,22.81,24.56,25.72,23.44,21.34,21.56,22.62,21.94,21.03,22.03,24.03,23.75,21.12,19.72,20.12,19.72,17.81,16.72,18.34,19.53,17.81,15.75,15.31,15.56,13.75,11.53,11.44,13.34,13.5,12.22,12.06,14.0,15.44,14.62,14.22,16.59,19.25,18.91,18.5,19.59,20.81,18.62,14.97,12.16,11.28,9.09,5.66,3.66,4.25,4.22,1.69,0.12,0.75,2.09,1.06,0.06,1.66,5.25,7.28,8.06,10.47,13.69,14.62,12.5,10.88,11.19,11.12,9.22,8.5,10.69,13.62,14.34,14.53,16.0,18.5,18.78,17.59,17.78,19.81,20.03,17.94,16.22,16.53,16.44,14.09,11.59,11.72,12.06,9.88,7.06,6.44,8.09,8.53,8.31,10.0,14.5,18.47,20.59,23.5,28.66,33.06,34.19,34.09,35.66,37.09,35.72,32.53,30.91,30.66,28.97,25.28,22.94,22.75,21.69,18.25,15.75,16.19,16.81,14.94,12.72,12.84,14.16,13.84,12.66,12.94,14.66,14.59,13.12,12.47,14.88,17.47,18.0,18.22,20.56,23.31,23.12,22.47,24.28,27.31,28.28,27.69,27.97,29.53,29.44,26.78,24.69,25.44,25.88,23.88,22.03,22.22,22.88,21.53,19.44,19.78,20.97,20.0,17.47,15.88,17.0,17.69,17.28,18.09,20.91,23.31,22.59,20.59,20.25,20.28,17.94,15.25,15.12,17.38,18.66,19.0,20.28,23.47,25.06,23.59,21.53,21.5,21.16,18.62,15.97,15.44,16.09,14.97,12.75,12.41,14.44,15.72,15.62,16.19,19.09,20.97,19.94,18.88,20.28,21.47,20.16,17.53,16.66,16.59,14.59,11.09,9.22,9.41,8.75,6.19,4.72,5.88,7.22,6.12,5.31,7.19,9.44,9.69,9.28,10.53,13.84,15.25,15.25,16.16,18.25,18.69,17.16,15.44,16.12,16.88,15.5,13.38,13.5,13.97,12.5,9.91,9.72,11.19,11.59,10.03,9.28,10.09,9.78,7.25,5.59,6.69:4.56,6.84,7.25,7.09,8.84,11.12,11.09,10.19,10.66,12.28,13.16,12.0,11.66,13.53,14.41,12.69,10.59,10.22,10.5,9.47,8.53,10.91,15.16,17.16,16.84,17.16,18.19,17.53,15.22,14.5,16.44,18.12,17.62,16.78,17.59,18.69,17.09,14.62,13.75,14.53,14.03,12.41,12.56,15.0,16.19,15.34,14.53,15.44,16.53,14.88,13.34,13.75,15.09,14.41,12.69,12.88,14.06,14.09,12.12,10.81,11.25,11.19,8.91,7.25,8.53,10.66,10.59,9.47,9.56,9.56,7.09,3.09,1.41,2.16,2.41,1.59,2.12,4.5,6.09,4.56,2.91,3.72,5.72,6.34,7.12,10.28,14.62,16.5,15.78,15.81,16.91,16.81,14.06,12.0,11.75,11.28,8.0,4.44,3.69,4.44,3.31,1.59,1.44,2.94,2.5,0.47,-0.5,0.66,1.22,-0.75,-2.31,-0.81,0.75,0.22,-0.25,1.56,4.19,4.81,3.75,3.88,5.56,5.88,4.91,5.56,8.84,11.94,12.69,12.94,15.16,16.16,14.0,10.38,8.28,7.47,5.16,2.34,1.56,3.25,4.78,4.75,5.81,9.75,13.66,14.84,15.19,17.47,19.44,18.38,16.12,15.31,15.72,14.16,11.0,9.06,9.41,8.97,6.16,3.75,3.34,2.69,0.19,-2.47,-2.12,-0.19,-0.12,-0.94,-0.03,2.47,3.31,2.25,2.16,4.38,5.75,4.62,4.03,6.09,8.59,9.31,9.34,11.69,14.72,15.09,13.16,12.31,12.38,10.59,6.38,2.69,1.44,0.06,-3.34,-5.75,-5.12,-3.0,-2.75,-3.09,-1.84,0.5,0.38,-1.41,-1.97,-0.5,0.31,-0.44,-1.03,0.75,2.53,2.09,1.03,2.62,4.97,5.12,4.19,5.09,7.12,7.72,6.34,5.53,6.38,6.56,4.38,2.34,3.16,3.97,2.22,-0.41,-0.81,-0.31,-1.03,-2.62,-2.19,0.09,0.88,-0.41,-0.59,2.09,3.81,3.53,2.59,4.0,5.34,5.09,3.62,4.0,5.75,5.25,3.41,3.25,5.69,7.53,7.19,7.75,10.12,12.28,12.0,11.03,12.5,14.66,14.69,13.38,14.06,16.09,16.5,14.66,13.47,13.69,12.38,8.31,4.31,2.84,2.16,-0.53,-2.78,-2.06,-0.03,0.22,-1.22,-1.03,0.41,0.34,-1.22,-1.12,1.56,4.12,4.81,5.34,8.5,11.75,11.97,10.94,10.84,10.69,8.5,4.25,2.06,2.47,2.75,2.31,3.03,6.72,9.91,10.81,11.69,14.69,18.19,19.5,19.56,21.41,23.62,23.97,22.34,21.62,22.09,20.94,17.22,13.28,11.59,9.41,4.78,0.0,-2.19,-3.25,-5.47,-7.84,-7.62,-5.16,-3.09,-2.56,-0.31,5.0,9.44,11.44,13.66,17.59,20.88,21.25,20.69,21.53,22.53,21.25,17.75,15.16,13.88,11.0,5.5,1.34,-0.66,-2.16,-5.12,-7.12,-5.44,-2.47,-0.78,0.41,3.22,6.53,7.81,6.97,7.25,9.28,10.69,9.62,9.16,10.94,12.78,12.56,12.25,14.53,17.28,17.72,16.62,16.31,16.53,14.88,11.31,8.94,8.72,8.38,5.88,3.97,4.12,4.25,2.19,-0.16,-0.75,-0.56,-2.03,-5.03,-5.88,-4.81,-4.16,-4.97,-4.66,-2.38,-0.81,-2.5,-4.25,-4.06,-3.53,-5.22,-7.53,-7.5,-6.34,-6.66,-8.25,-7.88,-5.59,-3.72,-3.88,-3.19,-0.31,2.34,2.38,2.69,5.28,8.72,10.56,11.81,15.53,19.84,22.38,21.91,20.97,20.81,19.31,15.22,11.75,11.03,10.88,8.47,6.0,5.19,5.16,2.97,-0.06,-1.25,-0.56,-0.81,-2.44,-2.84,-1.06,0.56,0.22,-0.03,1.81,4.41,4.5,4.09,5.5,8.22,8.84,8.19,9.41,12.12,14.28,14.22,14.5,16.03,16.69,14.5,11.28,10.22,10.09,8.47,7.16,8.06,10.97,12.78,12.75,13.56,16.12,17.78,17.12,16.5,17.31,16.88,12.94,8.31,5.19,3.41,0.88,-1.84,-2.31,-0.03,1.28,0.94,1.53,3.91,5.53,4.5,3.88,5.66,7.69,7.75,7.38,9.34,12.31,13.53,13.53,14.56,16.5,16.88,15.06,14.09,15.16,16.28,14.88,12.97,13.09,13.41,11.69,9.69,10.0,11.88,11.97,10.25,9.72,11.34,12.06,11.22,11.06,13.16,14.53,13.06,10.41,9.16,8.31,5.5,1.91,0.81,2.25,2.91,2.41,3.25,6.12,8.19,8.16,8.72,10.81,13.19,13.38,12.47,13.12,14.91,14.28,12.5,12.12,13.09,12.75,10.88,9.5,10.41,10.97,9.22,7.25,7.69,8.72,7.62,6.19,6.53,7.5,6.66,4.06,3.16,4.41,5.12,4.25,4.03,5.69,6.53,5.06,3.62,4.84,6.88,7.34,7.25,8.44,10.44,10.53,8.5,7.62,9.25,10.09,9.06,8.69,10.78,12.19,11.44,10.19,10.62,11.59,10.66,8.88,9.06,10.78,11.28,10.31,10.41,12.34,13.69,13.0,12.12,13.25,14.22,13.0,10.97,10.72,11.38,