#SelfRegulationSCP1.
#
#from 
#http://bbci.de/competition/ii/tuebingen_desc_i.html
#
#Data set Ia: Self-regulation of Slow Cortical Potentials
#
#Datasets provided by University of Tuebingen. 
#Correspondence to Thilo Hinterberger <thilo.Hinterberger@uni-tuebingen.de> 
# 
#Description of Experiments:
#The datasets were taken from a healthy subject. 
#The subject was asked to move a cursor up and down on a computer screen, while his cortical potentials were taken. During the recording, the subject received visual feedback of his slow cortical potentials (Cz-Mastoids).  Cortical positivity lead to a downward movement of the cursor on the screen.  Cortical negativity lead to an upward movement of the cursor.  Each trial lasted 6s. 
#During every trial, the task was visually presented by a highlighted goal at either the top or bottom of the screen to indicate negativity or positivity from second 0.5 until the end of the trial. The visual feedback was presented from second 2 to second 5.5. Only this 3.5 second interval of every trial is provided for training and testing. The sampling rate of 256 Hz and the recording length of 3.5s results in 896 samples per channel for every trial.
#Trial structure overview: 
#Duration: 6 s, no inter trial intervals 
#Task presentation: from 0.5 s to 6.0 s 
#Feedback period: from 2.0 s to 5.5 s 
# 
#
#Data:
#Amplifier: PsyLab EEG8 
#A/D-converter: Computer Boards PCIM-DAS1602/16 bit 
#Amplitude range: +/-1000 �V 
#Sampling rate: 256 S/s 
#EEG data was taken from the following positions: 
#Channel 1: A1-Cz (10/20 system) (A1 = left mastoid) 
#Channel 2: A2-Cz 
#Channel 3: 2 cm frontal of C3 
#Channel 4: 2 cm parietal of C3 
#Channel 5: 2 cm frontal of C4 
#Channel 6: 2 cm parietal of C4 
#All values are in �Volt. 
# 
#The train data consists of 268 trials recorded on two different days and mixed randomly. 168 of the overall 268 trials origin from day 1, the remaining 100 trials from day 2. 
#The data is derived from the two train files Traindata_0.txt and Traindata_1.txt. 
#Each instance has six dimensions (EEG channels above) of length 896. Class labels are negativity or positivity. There are 293 test data, the labels of which were released after the competition. 
#Results are here
#http://bbci.de/competition/ii/results/index.html
#best has an error rate of 11.3% on the test data (presumably 33 incorrect). 
#Reference:
#Birbaumer, N., Flor, H., Ghanayim, N., Hinterberger, T., Iverson, I., Taub, E., Kotchoubey, B., K�bler, A., & Perelmouter, J, A Brain-Controlled Spelling Device for the Completely Paralyzed, Nature, 398, 297-298.
#
# 
@problemName SelfRegulationSCP1
@timeStamps false
@missing false
@univariate false
@dimensions 6
@equalLength true
@seriesLength 896
@classLabel true negativity positivity
@data
4.06,3.0,0.69,-1.12,-3.5,-5.94,-8.28,-10.53,-10.44,-10.84,-9.47,-6.91,-5.34,-2.94,-1.16,0.5,1.62,2.84,3.44,3.94,3.91,3.56,2.84,0.62,-0.66,-2.72,-4.84,-4.75,-5.44,-5.47,-5.09,-3.91,-4.22,-4.56,-4.69,-5.91,-6.59,-6.91,-6.94,-5.28,-3.41,-0.44,1.97,3.56,4.53,4.78,4.09,2.5,2.12,1.25,0.81,-0.56,0.0,-0.47,-1.22,-0.12,0.41,1.44,1.5,2.41,1.16,2.06,0.56,0.12,-1.16,-2.41,-4.47,-6.72,-9.47,-11.53,-13.34,-14.69,-15.59,-15.75,-15.44,-14.53,-14.78,-14.62,-13.84,-14.53,-14.34,-14.22,-14.53,-13.28,-13.41,-13.47,-14.41,-15.66,-15.41,-15.53,-14.28,-12.91,-11.56,-10.84,-10.41,-8.47,-6.88,-5.09,-2.84,-0.88,-0.09,0.62,1.06,2.12,3.94,3.81,5.09,6.31,6.88,6.59,6.75,5.69,5.03,3.19,2.19,0.97,-0.16,-0.88,-0.66,-0.66,-1.0,-0.03,-0.66,-1.09,-1.16,-2.94,-3.88,-4.91,-5.19,-4.03,-2.91,-1.06,0.84,2.06,3.44,5.0,4.56,4.66,3.81,1.53,0.31,-0.91,-1.88,-2.12,-2.09,-1.38,-0.28,0.31,1.09,2.56,4.31,5.44,7.75,9.88,11.28,11.44,11.19,10.25,8.91,8.41,8.75,8.94,10.78,11.06,11.91,12.41,12.31,12.03,10.81,9.81,8.31,6.06,5.19,5.28,4.81,6.66,8.72,11.38,13.66,14.5,15.94,15.16,13.0,11.66,8.81,6.06,4.75,1.56,-0.72,-1.72,-2.66,-2.97,-3.09,-2.69,-1.47,-0.91,1.28,3.78,6.31,9.06,12.31,14.94,16.97,18.56,18.72,17.56,14.69,10.5,6.06,2.16,-0.84,-2.53,-2.59,-1.66,0.94,3.81,6.75,9.22,11.25,11.25,10.09,8.41,5.72,4.41,2.94,2.81,3.75,4.34,5.19,6.28,7.53,7.81,8.5,9.38,9.22,8.84,8.66,9.25,8.97,9.06,7.72,6.03,3.75,1.19,-0.88,-1.31,-2.28,-1.31,-0.09,0.69,2.88,4.56,5.12,5.12,4.62,2.84,0.31,-2.22,-3.66,-5.66,-6.22,-7.09,-6.88,-7.5,-8.0,-8.94,-10.5,-11.16,-11.47,-10.34,-8.88,-6.34,-4.16,-1.72,0.31,1.5,3.53,3.09,2.12,0.16,-2.59,-4.38,-6.53,-8.41,-9.53,-10.91,-11.97,-12.16,-11.03,-9.53,-6.91,-4.44,-1.19,0.72,2.66,5.34,7.84,8.88,10.25,9.38,8.03,4.5,1.12,-1.66,-5.41,-9.09,-11.34,-14.09,-15.78,-17.22,-17.34,-16.66,-14.91,-13.0,-10.72,-9.09,-6.97,-6.66,-5.0,-5.25,-3.44,-3.78,-3.59,-3.06,-2.94,-3.5,-3.53,-3.56,-4.19,-3.25,-3.16,-2.06,-0.66,0.38,1.12,1.72,2.62,3.81,3.75,4.88,5.28,5.44,5.91,6.0,6.88,6.5,7.0,6.91,5.62,4.78,4.09,3.28,2.88,2.91,2.94,2.5,1.94,0.56,-0.38,-2.31,-4.59,-7.72,-9.81,-11.12,-11.19,-9.69,-5.97,-1.16,5.28,10.97,14.75,16.31,15.16,11.81,7.31,3.25,-0.78,-2.69,-4.25,-5.25,-5.47,-5.56,-6.41,-8.25,-10.31,-11.44,-12.78,-11.94,-9.78,-7.84,-4.91,-2.28,-0.59,1.19,2.22,2.97,2.44,0.59,-1.59,-3.34,-6.28,-6.62,-8.22,-8.97,-9.47,-10.59,-10.19,-9.25,-8.91,-7.16,-6.12,-5.22,-4.0,-3.47,-1.66,1.06,4.19,7.34,10.19,12.66,12.41,12.19,11.41,11.31,10.66,11.22,11.12,10.75,10.44,10.47,9.97,10.59,10.69,11.59,13.19,14.16,15.84,18.22,18.06,20.0,20.88,20.44,20.69,19.72,17.81,16.59,15.12,13.0,12.06,10.41,9.0,6.81,5.09,2.56,-0.28,-3.66,-5.47,-6.44,-7.06,-5.56,-3.56,-1.44,0.56,2.56,4.19,4.5,4.5,3.56,2.06,0.28,-0.69,-1.66,-2.16,-1.28,0.09,1.44,3.12,4.28,3.69,3.81,2.81,3.06,3.16,4.31,5.41,4.69,5.0,4.38,2.88,1.56,0.34,-0.81,-0.94,0.28,1.31,3.16,4.75,5.41,6.19,4.09,3.19,1.09,-1.25,-2.97,-4.59,-4.94,-5.22,-4.75,-4.41,-3.72,-4.19,-5.12,-6.59,-7.97,-8.66,-8.84,-8.53,-7.59,-7.34,-6.72,-6.94,-7.31,-7.16,-6.72,-5.09,-4.16,-2.5,-0.09,2.25,3.44,5.12,5.75,5.75,5.41,5.56,5.31,5.34,5.31,5.28,4.69,3.59,2.41,1.12,0.22,-0.28,-0.69,-0.16,0.25,2.0,2.84,5.0,6.66,7.12,7.78,6.91,6.62,5.25,4.12,3.34,1.94,1.19,0.66,0.34,0.25,0.09,0.44,-0.16,-0.03,-1.06,-0.84,-0.19,0.91,3.06,4.5,4.78,4.88,3.19,1.38,-0.19,-1.31,-2.34,-2.59,-2.34,-1.5,-1.28,-1.91,-2.03,-2.47,-4.12,-5.06,-5.41,-6.03,-6.09,-3.75,-0.75,4.78,11.69,19.16,25.06,28.38,29.0,25.53,19.81,14.12,9.25,6.12,4.78,3.88,3.88,3.75,2.34,1.53,-1.09,-3.09,-5.91,-7.78,-7.94,-7.12,-5.22,-3.47,-2.59,-2.78,-4.12,-5.31,-6.91,-8.28,-8.06,-8.19,-8.06,-6.69,-6.44,-5.38,-4.41,-4.28,-3.78,-4.69,-4.06,-3.66,-3.03,-1.84,-0.66,-0.09,1.75,3.19,4.81,5.53,5.59,5.19,3.5,1.78,-0.34,-1.69,-3.16,-4.47,-4.28,-4.78,-4.5,-4.84,-5.34,-6.28,-6.78,-8.16,-8.72,-8.22,-7.34,-5.94,-3.75,-1.22,0.94,2.69,3.44,4.03,2.62,1.03,-0.47,-1.66,-3.91,-4.62,-6.19,-7.25,-8.56,-9.84,-11.03,-12.19,-13.5,-15.22,-15.16,-14.81,-13.84,-12.41,-10.34,-8.34,-6.84,-5.47,-5.28,-4.69,-4.97,-6.12,-6.09,-7.47,-7.84,-8.97,-9.22,-9.78,-9.47,-10.09,-9.91,-9.66,-9.19,-8.81,-8.44,-7.69,-6.72,-5.81,-4.78,-3.59,-2.53,-2.62,-2.59,-2.56,-3.44,-5.31,-7.19,-8.59,-10.59,-10.84,-10.16,-9.25,-7.03,-5.81,-4.19,-2.66,-1.81,-1.06,-0.53,-0.47,-1.06,-0.88,-1.12,-0.22,0.47,0.81,1.34,1.19,0.97,-0.12,-1.19,-2.66,-5.34,-6.72,-8.47,-9.34,-9.22,-7.34,-5.03,-3.59,-0.94,0.16,1.09,0.94,0.28,-0.81,-1.44,-2.72,-4.22,-5.5,-7.12,-8.69,-11.44,-13.47,-15.31,-15.69,-16.34,-16.59,-14.22,-11.81,-9.78,-7.62,-5.03,-3.81,-2.16,-1.81,-1.47,-1.84,-2.78,-3.72,-4.97,-5.41,-5.97,-7.06,-8.22,-10.88,-13.34,-15.59,-16.41,-16.75,-16.56,-14.72,-13.22,-12.44,-10.81,-9.66,-8.47,-6.66,-5.59,-4.88,-5.28,-6.78,-8.72,-11.47,-12.59,-13.19,-13.38,-12.47,-11.91,-10.72,-8.66,-6.84,-3.25,0.06,2.16,3.41,2.44,0.06,-3.97,-7.84,-10.09,-12.47,-13.12,-12.53,-12.72,-11.84,-11.66,-11.03,-9.84,-7.56,-5.81,-4.34,-3.5,-3.06,-4.66,-5.34,-6.66,-7.84,-8.28,-8.59,-9.25,-9.44,-9.66,-10.66,-10.59,-11.47,-11.06,-10.22,-8.31,-6.19,-2.66,0.94,4.94,8.34,11.62,13.91,15.78,15.22,13.47,10.0,5.81,1.81,-1.94,-4.09,-4.66,-3.22,-0.16,2.94,7.38,10.5,12.19,12.31,11.28,9.75,7.78,6.53,5.56,4.69,4.16,3.16,1.91,-0.44,-2.72,-4.5,-6.41,-8.22,-7.81,-6.53,-4.56,-1.22:-8.28,-10.53,-10.44,-10.84,-9.47,-6.91,-5.34,-2.94,-1.16,0.5,1.62,2.84,3.44,3.94,3.91,3.56,2.84,0.62,-0.66,-2.72,-4.84,-4.75,-5.44,-5.47,-5.09,-3.91,-4.22,-4.56,-4.69,-5.91,-6.59,-6.91,-6.94,-5.28,-3.41,-0.44,1.97,3.56,4.53,4.78,4.09,2.5,2.12,1.25,0.81,-0.56,0.0,-0.47,-1.22,-0.12,0.41,1.44,1.5,2.41,1.16,2.06,0.56,0.12,-1.16,-2.41,-4.47,-6.72,-9.47,-11.53,-13.34,-14.69,-15.59,-15.75,-15.44,-14.53,-14.78,-14.62,-13.84,-14.53,-14.34,-14.22,-14.53,-13.28,-13.41,-13.47,-14.41,-15.66,-15.41,-15.53,-14.28,-12.91,-11.56,-10.84,-10.41,-8.47,-6.88,-5.09,-2.84,-0.88,-0.09,0.62,1.06,2.12,3.94,3.81,5.09,6.31,6.88,6.59,6.75,5.69,5.03,3.19,2.19,0.97,-0.16,-0.88,-0.66,-0.66,-1.0,-0.03,-0.66,-1.09,-1.16,-2.94,-3.88,-4.91,-5.19,-4.03,-2.91,-1.06,0.84,2.06,3.44,5.0,4.56,4.66,3.81,1.53,0.31,-0.91,-1.88,-2.12,-2.09,-1.38,-0.28,0.31,1.09,2.56,4.31,5.44,7.75,9.88,11.28,11.44,11.19,10.25,8.91,8.41,8.75,8.94,10.78,11.06,11.91,12.41,12.31,12.03,10.81,9.81,8.31,6.06,5.19,5.28,4.81,6.66,8.72,11.38,13.66,14.5,15.94,15.16,13.0,11.66,8.81,6.06,4.75,1.56,-0.72,-1.72,-2.66,-2.97,-3.09,-2.69,-1.47,-0.91,1.28,3.78,6.31,9.06,12.31,14.94,16.97,18.56,18.72,17.56,14.69,10.5,6.06,2.16,-0.84,-2.53,-2.59,-1.66,0.94,3.81,6.75,9.22,11.25,11.25,10.09,8.41,5.72,4.41,2.94,2.81,3.75,4.34,5.19,6.28,7.53,7.81,8.5,9.38,9.22,8.84,8.66,9.25,8.97,9.06,7.72,6.03,3.75,1.19,-0.88,-1.31,-2.28,-1.31,-0.09,0.69,2.88,4.56,5.12,5.12,4.62,2.84,0.31,-2.22,-3.66,-5.66,-6.22,-7.09,-6.88,-7.5,-8.0,-8.94,-10.5,-11.16,-11.47,-10.34,-8.88,-6.34,-4.16,-1.72,0.31,1.5,3.53,3.09,2.12,0.16,-2.59,-4.38,-6.53,-8.41,-9.53,-10.91,-11.97,-12.16,-11.03,-9.53,-6.91,-4.44,-1.19,0.72,2.66,5.34,7.84,8.88,10.25,9.38,8.03,4.5,1.12,-1.66,-5.41,-9.09,-11.34,-14.09,-15.78,-17.22,-17.34,-16.66,-14.91,-13.0,-10.72,-9.09,-6.97,-6.66,-5.0,-5.25,-3.44,-3.78,-3.59,-3.06,-2.94,-3.5,-3.53,-3.56,-4.19,-3.25,-3.16,-2.06,-0.66,0.38,1.12,1.72,2.62,3.81,3.75,4.88,5.28,5.44,5.91,6.0,6.88,6.5,7.0,6.91,5.62,4.78,4.09,3.28,2.88,2.91,2.94,2.5,1.94,0.56,-0.38,-2.31,-4.59,-7.72,-9.81,-11.12,-11.19,-9.69,-5.97,-1.16,5.28,10.97,14.75,16.31,15.16,11.81,7.31,3.25,-0.78,-2.69,-4.25,-5.25,-5.47,-5.56,-6.41,-8.25,-10.31,-11.44,-12.78,-11.94,-9.78,-7.84,-4.91,-2.28,-0.59,1.19,2.22,2.97,2.44,0.59,-1.59,-3.34,-6.28,-6.62,-8.22,-8.97,-9.47,-10.59,-10.19,-9.25,-8.91,-7.16,-6.12,-5.22,-4.0,-3.47,-1.66,1.06,4.19,7.34,10.19,12.66,12.41,12.19,11.41,11.31,10.66,11.22,11.12,10.75,10.44,10.47,9.97,10.59,10.69,11.59,13.19,14.16,15.84,18.22,18.06,20.0,20.88,20.44,20.69,19.72,17.81,16.59,15.12,13.0,12.06,10.41,9.0,6.81,5.09,2.56,-0.28,-3.66,-5.47,-6.44,-7.06,-5.56,-3.56,-1.44,0.56,2.56,4.19,4.5,4.5,3.56,2.06,0.28,-0.69,-1.66,-2.16,-1.28,0.09,1.44,3.12,4.28,3.69,3.81,2.81,3.06,3.16,4.31,5.41,4.69,5.0,4.38,2.88,1.56,0.34,-0.81,-0.94,0.28,1.31,3.16,4.75,5.41,6.19,4.09,3.19,1.09,-1.25,-2.97,-4.59,-4.94,-5.22,-4.75,-4.41,-3.72,-4.19,-5.12,-6.59,-7.97,-8.66,-8.84,-8.53,-7.59,-7.34,-6.72,-6.94,-7.31,-7.16,-6.72,-5.09,-4.16,-2.5,-0.09,2.25,3.44,5.12,5.75,5.75,5.41,5.56,5.31,5.34,5.31,5.28,4.69,3.59,2.41,1.12,0.22,-0.28,-0.69,-0.16,0.25,2.0,2.84,5.0,6.66,7.12,7.78,6.91,6.62,5.25,4.12,3.34,1.94,1.19,0.66,0.34,0.25,0.09,0.44,-0.16,-0.03,-1.06,-0.84,-0.19,0.91,3.06,4.5,4.78,4.88,3.19,1.38,-0.19,-1.31,-2.34,-2.59,-2.34,-1.5,-1.28,-1.91,-2.03,-2.47,-4.12,-5.06,-5.41,-6.03,-6.09,-3.75,-0.75,4.78,11.69,19.16,25.06,28.38,29.0,25.53,19.81,14.12,9.25,6.12,4.78,3.88,3.88,3.75,2.34,1.53,-1.09,-3.09,-5.91,-7.78,-7.94,-7.12,-5.22,-3.47,-2.59,-2.78,-4.12,-5.31,-6.91,-8.28,-8.06,-8.19,-8.06,-6.69,-6.44,-5.38,-4.41,-4.28,-3.78,-4.69,-4.06,-3.66,-3.03,-1.84,-0.66,-0.09,1.75,3.19,4.81,5.53,5.59,5.19,3.5,1.78,-0.34,-1.69,-3.16,-4.47,-4.28,-4.78,-4.5,-4.84,-5.34,-6.28,-6.78,-8.16,-8.72,-8.22,-7.34,-5.94,-3.75,-1.22,0.94,2.69,3.44,4.03,2.62,1.03,-0.47,-1.66,-3.91,-4.62,-6.19,-7.25,-8.56,-9.84,-11.03,-12.19,-13.5,-15.22,-15.16,-14.81,-13.84,-12.41,-10.34,-8.34,-6.84,-5.47,-5.28,-4.69,-4.97,-6.12,-6.09,-7.47,-7.84,-8.97,-9.22,-9.78,-9.47,-10.09,-9.91,-9.66,-9.19,-8.81,-8.44,-7.69,-6.72,-5.81,-4.78,-3.59,-2.53,-2.62,-2.59,-2.56,-3.44,-5.31,-7.19,-8.59,-10.59,-10.84,-10.16,-9.25,-7.03,-5.81,-4.19,-2.66,-1.81,-1.06,-0.53,-0.47,-1.06,-0.88,-1.12,-0.22,0.47,0.81,1.34,1.19,0.97,-0.12,-1.19,-2.66,-5.34,-6.72,-8.47,-9.34,-9.22,-7.34,-5.03,-3.59,-0.94,0.16,1.09,0.94,0.28,-0.81,-1.44,-2.72,-4.22,-5.5,-7.12,-8.69,-11.44,-13.47,-15.31,-15.69,-16.34,-16.59,-14.22,-11.81,-9.78,-7.62,-5.03,-3.81,-2.16,-1.81,-1.47,-1.84,-2.78,-3.72,-4.97,-5.41,-5.97,-7.06,-8.22,-10.88,-13.34,-15.59,-16.41,-16.75,-16.56,-14.72,-13.22,-12.44,-10.81,-9.66,-8.47,-6.66,-5.59,-4.88,-5.28,-6.78,-8.72,-11.47,-12.59,-13.19,-13.38,-12.47,-11.91,-10.72,-8.66,-6.84,-3.25,0.06,2.16,3.41,2.44,0.06,-3.97,-7.84,-10.09,-12.47,-13.12,-12.53,-12.72,-11.84,-11.66,-11.03,-9.84,-7.56,-5.81,-4.34,-3.5,-3.06,-4.66,-5.34,-6.66,-7.84,-8.28,-8.59,-9.25,-9.44,-9.66,-10.66,-10.59,-11.47,-11.06,-10.22,-8.31,-6.19,-2.66,0.94,4.94,8.34,11.62,13.91,15.78,15.22,13.47,10.0,5.81,1.81,-1.94,-4.09,-4.66,-3.22,-0.16,2.94,7.38,10.5,12.19,12.31,11.28,9.75,7.78,6.53,5.56,4.69,4.16,3.16,1.91,-0.44,-2.72,-4.5,-6.41,-8.22,-7.81,-6.53,-4.56,-1.22,-2.22,-2.56,-4.19,-6.31,-7.81,-10.75:-5.34,-2.94,-1.16,0.5,1.62,2.84,3.44,3.94,3.91,3.56,2.84,0.62,-0.66,-2.72,-4.84,-4.75,-5.44,-5.47,-5.09,-3.91,-4.22,-4.56,-4.69,-5.91,-6.59,-6.91,-6.94,-5.28,-3.41,-0.44,1.97,3.56,4.53,4.78,4.09,2.5,2.12,1.25,0.81,-0.56,0.0,-0.47,-1.22,-0.12,0.41,1.44,1.5,2.41,1.16,2.06,0.56,0.12,-1.16,-2.41,-4.47,-6.72,-9.47,-11.53,-13.34,-14.69,-15.59,-15.75,-15.44,-14.53,-14.78,-14.62,-13.84,-14.53,-14.34,-14.22,-14.53,-13.28,-13.41,-13.47,-14.41,-15.66,-15.41,-15.53,-14.28,-12.91,-11.56,-10.84,-10.41,-8.47,-6.88,-5.09,-2.84,-0.88,-0.09,0.62,1.06,2.12,3.94,3.81,5.09,6.31,6.88,6.59,6.75,5.69,5.03,3.19,2.19,0.97,-0.16,-0.88,-0.66,-0.66,-1.0,-0.03,-0.66,-1.09,-1.16,-2.94,-3.88,-4.91,-5.19,-4.03,-2.91,-1.06,0.84,2.06,3.44,5.0,4.56,4.66,3.81,1.53,0.31,-0.91,-1.88,-2.12,-2.09,-1.38,-0.28,0.31,1.09,2.56,4.31,5.44,7.75,9.88,11.28,11.44,11.19,10.25,8.91,8.41,8.75,8.94,10.78,11.06,11.91,12.41,12.31,12.03,10.81,9.81,8.31,6.06,5.19,5.28,4.81,6.66,8.72,11.38,13.66,14.5,15.94,15.16,13.0,11.66,8.81,6.06,4.75,1.56,-0.72,-1.72,-2.66,-2.97,-3.09,-2.69,-1.47,-0.91,1.28,3.78,6.31,9.06,12.31,14.94,16.97,18.56,18.72,17.56,14.69,10.5,6.06,2.16,-0.84,-2.53,-2.59,-1.66,0.94,3.81,6.75,9.22,11.25,11.25,10.09,8.41,5.72,4.41,2.94,2.81,3.75,4.34,5.19,6.28,7.53,7.81,8.5,9.38,9.22,8.84,8.66,9.25,8.97,9.06,7.72,6.03,3.75,1.19,-0.88,-1.31,-2.28,-1.31,-0.09,0.69,2.88,4.56,5.12,5.12,4.62,2.84,0.31,-2.22,-3.66,-5.66,-6.22,-7.09,-6.88,-7.5,-8.0,-8.94,-10.5,-11.16,-11.47,-10.34,-8.88,-6.34,-4.16,-1.72,0.31,1.5,3.53,3.09,2.12,0.16,-2.59,-4.38,-6.53,-8.41,-9.53,-10.91,-11.97,-12.16,-11.03,-9.53,-6.91,-4.44,-1.19,0.72,2.66,5.34,7.84,8.88,10.25,9.38,8.03,4.5,1.12,-1.66,-5.41,-9.09,-11.34,-14.09,-15.78,-17.22,-17.34,-16.66,-14.91,-13.0,-10.72,-9.09,-6.97,-6.66,-5.0,-5.25,-3.44,-3.78,-3.59,-3.06,-2.94,-3.5,-3.53,-3.56,-4.19,-3.25,-3.16,-2.06,-0.66,0.38,1.12,1.72,2.62,3.81,3.75,4.88,5.28,5.44,5.91,6.0,6.88,6.5,7.0,6.91,5.62,4.78,4.09,3.28,2.88,2.91,2.94,2.5,1.94,0.56,-0.38,-2.31,-4.59,-7.72,-9.81,-11.12,-11.19,-9.69,-5.97,-1.16,5.28,10.97,14.75,16.31,15.16,11.81,7.31,3.25,-0.78,-2.69,-4.25,-5.25,-5.47,-5.56,-6.41,-8.25,-10.31,-11.44,-12.78,-11.94,-9.78,-7.84,-4.91,-2.28,-0.59,1.19,2.22,2.97,2.44,0.59,-1.59,-3.34,-6.28,-6.62,-8.22,-8.97,-9.47,-10.59,-10.19,-9.25,-8.91,-7.16,-6.12,-5.22,-4.0,-3.47,-1.66,1.06,4.19,7.34,10.19,12.66,12.41,12.19,11.41,11.31,10.66,11.22,11.12,10.75,10.44,10.47,9.97,10.59,10.69,11.59,13.19,14.16,15.84,18.22,18.06,20.0,20.88,20.44,20.69,19.72,17.81,16.59,15.12,13.0,12.06,10.41,9.0,6.81,5.09,2.56,-0.28,-3.66,-5.47,-6.44,-7.06,-5.56,-3.56,-1.44,0.56,2.56,4.19,4.5,4.5,3.56,2.06,0.28,-0.69,-1.66,-2.16,-1.28,0.09,1.44,3.12,4.28,3.69,3.81,2.81,3.06,3.16,4.31,5.41,4.69,5.0,4.38,2.88,1.56,0.34,-0.81,-0.94,0.28,1.31,3.16,4.75,5.41,6.19,4.09,3.19,1.09,-1.25,-2.97,-4.59,-4.94,-5.22,-4.75,-4.41,-3.72,-4.19,-5.12,-6.59,-7.97,-8.66,-8.84,-8.53,-7.59,-7.34,-6.72,-6.94,-7.31,-7.16,-6.72,-5.09,-4.16,-2.5,-0.09,2.25,3.44,5.12,5.75,5.75,5.41,5.56,5.31,5.34,5.31,5.28,4.69,3.59,2.41,1.12,0.22,-0.28,-0.69,-0.16,0.25,2.0,2.84,5.0,6.66,7.12,7.78,6.91,6.62,5.25,4.12,3.34,1.94,1.19,0.66,0.34,0.25,0.09,0.44,-0.16,-0.03,-1.06,-0.84,-0.19,0.91,3.06,4.5,4.78,4.88,3.19,1.38,-0.19,-1.31,-2.34,-2.59,-2.34,-1.5,-1.28,-1.91,-2.03,-2.47,-4.12,-5.06,-5.41,-6.03,-6.09,-3.75,-0.75,4.78,11.69,19.16,25.06,28.38,29.0,25.53,19.81,14.12,9.25,6.12,4.78,3.88,3.88,3.75,2.34,1.53,-1.09,-3.09,-5.91,-7.78,-7.94,-7.12,-5.22,-3.47,-2.59,-2.78,-4.12,-5.31,-6.91,-8.28,-8.06,-8.19,-8.06,-6.69,-6.44,-5.38,-4.41,-4.28,-3.78,-4.69,-4.06,-3.66,-3.03,-1.84,-0.66,-0.09,1.75,3.19,4.81,5.53,5.59,5.19,3.5,1.78,-0.34,-1.69,-3.16,-4.47,-4.28,-4.78,-4.5,-4.84,-5.34,-6.28,-6.78,-8.16,-8.72,-8.22,-7.34,-5.94,-3.75,-1.22,0.94,2.69,3.44,4.03,2.62,1.03,-0.47,-1.66,-3.91,-4.62,-6.19,-7.25,-8.56,-9.84,-11.03,-12.19,-13.5,-15.22,-15.16,-14.81,-13.84,-12.41,-10.34,-8.34,-6.84,-5.47,-5.28,-4.69,-4.97,-6.12,-6.09,-7.47,-7.84,-8.97,-9.22,-9.78,-9.47,-10.09,-9.91,-9.66,-9.19,-8.81,-8.44,-7.69,-6.72,-5.81,-4.78,-3.59,-2.53,-2.62,-2.59,-2.56,-3.44,-5.31,-7.19,-8.59,-10.59,-10.84,-10.16,-9.25,-7.03,-5.81,-4.19,-2.66,-1.81,-1.06,-0.53,-0.47,-1.06,-0.88,-1.12,-0.22,0.47,0.81,1.34,1.19,0.97,-0.12,-1.19,-2.66,-5.34,-6.72,-8.47,-9.34,-9.22,-7.34,-5.03,-3.59,-0.94,0.16,1.09,0.94,0.28,-0.81,-1.44,-2.72,-4.22,-5.5,-7.12,-8.69,-11.44,-13.47,-15.31,-15.69,-16.34,-16.59,-14.22,-11.81,-9.78,-7.62,-5.03,-3.81,-2.16,-1.81,-1.47,-1.84,-2.78,-3.72,-4.97,-5.41,-5.97,-7.06,-8.22,-10.88,-13.34,-15.59,-16.41,-16.75,-16.56,-14.72,-13.22,-12.44,-10.81,-9.66,-8.47,-6.66,-5.59,-4.88,-5.28,-6.78,-8.72,-11.47,-12.59,-13.19,-13.38,-12.47,-11.91,-10.72,-8.66,-6.84,-3.25,0.06,2.16,3.41,2.44,0.06,-3.97,-7.84,-10.09,-12.47,-13.12,-12.53,-12.72,-11.84,-11.66,-11.03,-9.84,-7.56,-5.81,-4.34,-3.5,-3.06,-4.66,-5.34,-6.66,-7.84,-8.28,-8.59,-9.25,-9.44,-9.66,-10.66,-10.59,-11.47,-11.06,-10.22,-8.31,-6.19,-2.66,0.94,4.94,8.34,11.62,13.91,15.78,15.22,13.47,10.0,5.81,1.81,-1.94,-4.09,-4.66,-3.22,-0.16,2.94,7.38,10.5,12.19,12.31,11.28,9.75,7.78,6.53,5.56,4.69,4.16,3.16,1.91,-0.44,-2.72,-4.5,-6.41,-8.22,-7.81,-6.53,-4.56,-1.22,-2.22,-2.56,-4.19,-6.31,-7.81,-10.75,-12.47,-14.75,-16.66,-17.28,-17.56,-16.31:3.44,3.94,3.91,3.56,2.84,0.62,-0.66,-2.72,-4.84,-4.75,-5.44,-5.47,-5.09,-3.91,-4.22,-4.56,-4.69,-5.91,-6.59,-6.91,-6.94,-5.28,-3.41,-0.44,1.97,3.56,4.53,4.78,4.09,2.5,2.12,1.25,0.81,-0.56,0.0,-0.47,-1.22,-0.12,0.41,1.44,1.5,2.41,1.16,2.06,0.56,0.12,-1.16,-2.41,-4.47,-6.72,-9.47,-11.53,-13.34,-14.69,-15.59,-15.75,-15.44,-14.53,-14.78,-14.62,-13.84,-14.53,-14.34,-14.22,-14.53,-13.28,-13.41,-13.47,-14.41,-15.66,-15.41,-15.53,-14.28,-12.91,-11.56,-10.84,-10.41,-8.47,-6.88,-5.09,-2.84,-0.88,-0.09,0.62,1.06,2.12,3.94,3.81,5.09,6.31,6.88,6.59,6.75,5.69,5.03,3.19,2.19,0.97,-0.16,-0.88,-0.66,-0.66,-1.0,-0.03,-0.66,-1.09,-1.16,-2.94,-3.88,-4.91,-5.19,-4.03,-2.91,-1.06,0.84,2.06,3.44,5.0,4.56,4.66,3.81,1.53,0.31,-0.91,-1.88,-2.12,-2.09,-1.38,-0.28,0.31,1.09,2.56,4.31,5.44,7.75,9.88,11.28,11.44,11.19,10.25,8.91,8.41,8.75,8.94,10.78,11.06,11.91,12.41,12.31,12.03,10.81,9.81,8.31,6.06,5.19,5.28,4.81,6.66,8.72,11.38,13.66,14.5,15.94,15.16,13.0,11.66,8.81,6.06,4.75,1.56,-0.72,-1.72,-2.66,-2.97,-3.09,-2.69,-1.47,-0.91,1.28,3.78,6.31,9.06,12.31,14.94,16.97,18.56,18.72,17.56,14.69,10.5,6.06,2.16,-0.84,-2.53,-2.59,-1.66,0.94,3.81,6.75,9.22,11.25,11.25,10.09,8.41,5.72,4.41,2.94,2.81,3.75,4.34,5.19,6.28,7.53,7.81,8.5,9.38,9.22,8.84,8.66,9.25,8.97,9.06,7.72,6.03,3.75,1.19,-0.88,-1.31,-2.28,-1.31,-0.09,0.69,2.88,4.56,5.12,5.12,4.62,2.84,0.31,-2.22,-3.66,-5.66,-6.22,-7.09,-6.88,-7.5,-8.0,-8.94,-10.5,-11.16,-11.47,-10.34,-8.88,-6.34,-4.16,-1.72,0.31,1.5,3.53,3.09,2.12,0.16,-2.59,-4.38,-6.53,-8.41,-9.53,-10.91,-11.97,-12.16,-11.03,-9.53,-6.91,-4.44,-1.19,0.72,2.66,5.34,7.84,8.88,10.25,9.38,8.03,4.5,1.12,-1.66,-5.41,-9.09,-11.34,-14.09,-15.78,-17.22,-17.34,-16.66,-14.91,-13.0,-10.72,-9.09,-6.97,-6.66,-5.0,-5.25,-3.44,-3.78,-3.59,-3.06,-2.94,-3.5,-3.53,-3.56,-4.19,-3.25,-3.16,-2.06,-0.66,0.38,1.12,1.72,2.62,3.81,3.75,4.88,5.28,5.44,5.91,6.0,6.88,6.5,7.0,6.91,5.62,4.78,4.09,3.28,2.88,2.91,2.94,2.5,1.94,0.56,-0.38,-2.31,-4.59,-7.72,-9.81,-11.12,-11.19,-9.69,-5.97,-1.16,5.28,10.97,14.75,16.31,15.16,11.81,7.31,3.25,-0.78,-2.69,-4.25,-5.25,-5.47,-5.56,-6.41,-8.25,-10.31,-11.44,-12.78,-11.94,-9.78,-7.84,-4.91,-2.28,-0.59,1.19,2.22,2.97,2.44,0.59,-1.59,-3.34,-6.28,-6.62,-8.22,-8.97,-9.47,-10.59,-10.19,-9.25,-8.91,-7.16,-6.12,-5.22,-4.0,-3.47,-1.66,1.06,4.19,7.34,10.19,12.66,12.41,12.19,11.41,11.31,10.66,11.22,11.12,10.75,10.44,10.47,9.97,10.59,10.69,11.59,13.19,14.16,15.84,18.22,18.06,20.0,20.88,20.44,20.69,19.72,17.81,16.59,15.12,13.0,12.06,10.41,9.0,6.81,5.09,2.56,-0.28,-3.66,-5.47,-6.44,-7.06,-5.56,-3.56,-1.44,0.56,2.56,4.19,4.5,4.5,3.56,2.06,0.28,-0.69,-1.66,-2.16,-1.28,0.09,1.44,3.12,4.28,3.69,3.81,2.81,3.06,3.16,4.31,5.41,4.69,5.0,4.38,2.88,1.56,0.34,-0.81,-0.94,0.28,1.31,3.16,4.75,5.41,6.19,4.09,3.19,1.09,-1.25,-2.97,-4.59,-4.94,-5.22,-4.75,-4.41,-3.72,-4.19,-5.12,-6.59,-7.97,-8.66,-8.84,-8.53,-7.59,-7.34,-6.72,-6.94,-7.31,-7.16,-6.72,-5.09,-4.16,-2.5,-0.09,2.25,3.44,5.12,5.75,5.75,5.41,5.56,5.31,5.34,5.31,5.28,4.69,3.59,2.41,1.12,0.22,-0.28,-0.69,-0.16,0.25,2.0,2.84,5.0,6.66,7.12,7.78,6.91,6.62,5.25,4.12,3.34,1.94,1.19,0.66,0.34,0.25,0.09,0.44,-0.16,-0.03,-1.06,-0.84,-0.19,0.91,3.06,4.5,4.78,4.88,3.19,1.38,-0.19,-1.31,-2.34,-2.59,-2.34,-1.5,-1.28,-1.91,-2.03,-2.47,-4.12,-5.06,-5.41,-6.03,-6.09,-3.75,-0.75,4.78,11.69,19.16,25.06,28.38,29.0,25.53,19.81,14.12,9.25,6.12,4.78,3.88,3.88,3.75,2.34,1.53,-1.09,-3.09,-5.91,-7.78,-7.94,-7.12,-5.22,-3.47,-2.59,-2.78,-4.12,-5.31,-6.91,-8.28,-8.06,-8.19,-8.06,-6.69,-6.44,-5.38,-4.41,-4.28,-3.78,-4.69,-4.06,-3.66,-3.03,-1.84,-0.66,-0.09,1.75,3.19,4.81,5.53,5.59,5.19,3.5,1.78,-0.34,-1.69,-3.16,-4.47,-4.28,-4.78,-4.5,-4.84,-5.34,-6.28,-6.78,-8.16,-8.72,-8.22,-7.34,-5.94,-3.75,-1.22,0.94,2.69,3.44,4.03,2.62,1.03,-0.47,-1.66,-3.91,-4.62,-6.19,-7.25,-8.56,-9.84,-11.03,-12.19,-13.5,-15.22,-15.16,-14.81,-13.84,-12.41,-10.34,-8.34,-6.84,-5.47,-5.28,-4.69,-4.97,-6.12,-6.09,-7.47,-7.84,-8.97,-9.22,-9.78,-9.47,-10.09,-9.91,-9.66,-9.19,-8.81,-8.44,-7.69,-6.72,-5.81,-4.78,-3.59,-2.53,-2.62,-2.59,-2.56,-3.44,-5.31,-7.19,-8.59,-10.59,-10.84,-10.16,-9.25,-7.03,-5.81,-4.19,-2.66,-1.81,-1.06,-0.53,-0.47,-1.06,-0.88,-1.12,-0.22,0.47,0.81,1.34,1.19,0.97,-0.12,-1.19,-2.66,-5.34,-6.72,-8.47,-9.34,-9.22,-7.34,-5.03,-3.59,-0.94,0.16,1.09,0.94,0.28,-0.81,-1.44,-2.72,-4.22,-5.5,-7.12,-8.69,-11.44,-13.47,-15.31,-15.69,-16.34,-16.59,-14.22,-11.81,-9.78,-7.62,-5.03,-3.81,-2.16,-1.81,-1.47,-1.84,-2.78,-3.72,-4.97,-5.41,-5.97,-7.06,-8.22,-10.88,-13.34,-15.59,-16.41,-16.75,-16.56,-14.72,-13.22,-12.44,-10.81,-9.66,-8.47,-6.66,-5.59,-4.88,-5.28,-6.78,-8.72,-11.47,-12.59,-13.19,-13.38,-12.47,-11.91,-10.72,-8.66,-6.84,-3.25,0.06,2.16,3.41,2.44,0.06,-3.97,-7.84,-10.09,-12.47,-13.12,-12.53,-12.72,-11.84,-11.66,-11.03,-9.84,-7.56,-5.81,-4.34,-3.5,-3.06,-4.66,-5.34,-6.66,-7.84,-8.28,-8.59,-9.25,-9.44,-9.66,-10.66,-10.59,-11.47,-11.06,-10.22,-8.31,-6.19,-2.66,0.94,4.94,8.34,11.62,13.91,15.78,15.22,13.47,10.0,5.81,1.81,-1.94,-4.09,-4.66,-3.22,-0.16,2.94,7.38,10.5,12.19,12.31,11.28,9.75,7.78,6.53,5.56,4.69,4.16,3.16,1.91,-0.44,-2.72,-4.5,-6.41,-8.22,-7.81,-6.53,-4.56,-1.22,-2.22,-2.56,-4.19,-6.31,-7.81,-10.75,-12.47,-14.75,-16.66,-17.28,-17.56,-16.31,-14.44,-12.31,-10.12,-7.56,-6.38,-4.34:-0.66,-2.72,-4.84,-4.75,-5.44,-5.47,-5.09,-3.91,-4.22,-4.56,-4.69,-5.91,-6.59,-6.91,-6.94,-5.28,-3.41,-0.44,1.97,3.56,4.53,4.78,4.09,2.5,2.12,1.25,0.81,-0.56,0.0,-0.47,-1.22,-0.12,0.41,1.44,1.5,2.41,1.16,2.06,0.56,0.12,-1.16,-2.41,-4.47,-6.72,-9.47,-11.53,-13.34,-14.69,-15.59,-15.75,-15.44,-14.53,-14.78,-14.62,-13.84,-14.53,-14.34,-14.22,-14.53,-13.28,-13.41,-13.47,-14.41,-15.66,-15.41,-15.53,-14.28,-12.91,-11.56,-10.84,-10.41,-8.47,-6.88,-5.09,-2.84,-0.88,-0.09,0.62,1.06,2.12,3.94,3.81,5.09,6.31,6.88,6.59,6.75,5.69,5.03,3.19,2.19,0.97,-0.16,-0.88,-0.66,-0.66,-1.0,-0.03,-0.66,-1.09,-1.16,-2.94,-3.88,-4.91,-5.19,-4.03,-2.91,-1.06,0.84,2.06,3.44,5.0,4.56,4.66,3.81,1.53,0.31,-0.91,-1.88,-2.12,-2.09,-1.38,-0.28,0.31,1.09,2.56,4.31,5.44,7.75,9.88,11.28,11.44,11.19,10.25,8.91,8.41,8.75,8.94,10.78,11.06,11.91,12.41,12.31,12.03,10.81,9.81,8.31,6.06,5.19,5.28,4.81,6.66,8.72,11.38,13.66,14.5,15.94,15.16,13.0,11.66,8.81,6.06,4.75,1.56,-0.72,-1.72,-2.66,-2.97,-3.09,-2.69,-1.47,-0.91,1.28,3.78,6.31,9.06,12.31,14.94,16.97,18.56,18.72,17.56,14.69,10.5,6.06,2.16,-0.84,-2.53,-2.59,-1.66,0.94,3.81,6.75,9.22,11.25,11.25,10.09,8.41,5.72,4.41,2.94,2.81,3.75,4.34,5.19,6.28,7.53,7.81,8.5,9.38,9.22,8.84,8.66,9.25,8.97,9.06,7.72,6.03,3.75,1.19,-0.88,-1.31,-2.28,-1.31,-0.09,0.69,2.88,4.56,5.12,5.12,4.62,2.84,0.31,-2.22,-3.66,-5.66,-6.22,-7.09,-6.88,-7.5,-8.0,-8.94,-10.5,-11.16,-11.47,-10.34,-8.88,-6.34,-4.16,-1.72,0.31,1.5,3.53,3.09,2.12,0.16,-2.59,-4.38,-6.53,-8.41,-9.53,-10.91,-11.97,-12.16,-11.03,-9.53,-6.91,-4.44,-1.19,0.72,2.66,5.34,7.84,8.88,10.25,9.38,8.03,4.5,1.12,-1.66,-5.41,-9.09,-11.34,-14.09,-15.78,-17.22,-17.34,-16.66,-14.91,-13.0,-10.72,-9.09,-6.97,-6.66,-5.0,-5.25,-3.44,-3.78,-3.59,-3.06,-2.94,-3.5,-3.53,-3.56,-4.19,-3.25,-3.16,-2.06,-0.66,0.38,1.12,1.72,2.62,3.81,3.75,4.88,5.28,5.44,5.91,6.0,6.88,6.5,7.0,6.91,5.62,4.78,4.09,3.28,2.88,2.91,2.94,2.5,1.94,0.56,-0.38,-2.31,-4.59,-7.72,-9.81,-11.12,-11.19,-9.69,-5.97,-1.16,5.28,10.97,14.75,16.31,15.16,11.81,7.31,3.25,-0.78,-2.69,-4.25,-5.25,-5.47,-5.56,-6.41,-8.25,-10.31,-11.44,-12.78,-11.94,-9.78,-7.84,-4.91,-2.28,-0.59,1.19,2.22,2.97,2.44,0.59,-1.59,-3.34,-6.28,-6.62,-8.22,-8.97,-9.47,-10.59,-10.19,-9.25,-8.91,-7.16,-6.12,-5.22,-4.0,-3.47,-1.66,1.06,4.19,7.34,10.19,12.66,12.41,12.19,11.41,11.31,10.66,11.22,11.12,10.75,10.44,10.47,9.97,10.59,10.69,11.59,13.19,14.16,15.84,18.22,18.06,20.0,20.88,20.44,20.69,19.72,17.81,16.59,15.12,13.0,12.06,10.41,9.0,6.81,5.09,2.56,-0.28,-3.66,-5.47,-6.44,-7.06,-5.56,-3.56,-1.44,0.56,2.56,4.19,4.5,4.5,3.56,2.06,0.28,-0.69,-1.66,-2.16,-1.28,0.09,1.44,3.12,4.28,3.69,3.81,2.81,3.06,3.16,4.31,5.41,4.69,5.0,4.38,2.88,1.56,0.34,-0.81,-0.94,0.28,1.31,3.16,4.75,5.41,6.19,4.09,3.19,1.09,-1.25,-2.97,-4.59,-4.94,-5.22,-4.75,-4.41,-3.72,-4.19,-5.12,-6.59,-7.97,-8.66,-8.84,-8.53,-7.59,-7.34,-6.72,-6.94,-7.31,-7.16,-6.72,-5.09,-4.16,-2.5,-0.09,2.25,3.44,5.12,5.75,5.75,5.41,5.56,5.31,5.34,5.31,5.28,4.69,3.59,2.41,1.12,0.22,-0.28,-0.69,-0.16,0.25,2.0,2.84,5.0,6.66,7.12,7.78,6.91,6.62,5.25,4.12,3.34,1.94,1.19,0.66,0.34,0.25,0.09,0.44,-0.16,-0.03,-1.06,-0.84,-0.19,0.91,3.06,4.5,4.78,4.88,3.19,1.38,-0.19,-1.31,-2.34,-2.59,-2.34,-1.5,-1.28,-1.91,-2.03,-2.47,-4.12,-5.06,-5.41,-6.03,-6.09,-3.75,-0.75,4.78,11.69,19.16,25.06,28.38,29.0,25.53,19.81,14.12,9.25,6.12,4.78,3.88,3.88,3.75,2.34,1.53,-1.09,-3.09,-5.91,-7.78,-7.94,-7.12,-5.22,-3.47,-2.59,-2.78,-4.12,-5.31,-6.91,-8.28,-8.06,-8.19,-8.06,-6.69,-6.44,-5.38,-4.41,-4.28,-3.78,-4.69,-4.06,-3.66,-3.03,-1.84,-0.66,-0.09,1.75,3.19,4.81,5.53,5.59,5.19,3.5,1.78,-0.34,-1.69,-3.16,-4.47,-4.28,-4.78,-4.5,-4.84,-5.34,-6.28,-6.78,-8.16,-8.72,-8.22,-7.34,-5.94,-3.75,-1.22,0.94,2.69,3.44,4.03,2.62,1.03,-0.47,-1.66,-3.91,-4.62,-6.19,-7.25,-8.56,-9.84,-11.03,-12.19,-13.5,-15.22,-15.16,-14.81,-13.84,-12.41,-10.34,-8.34,-6.84,-5.47,-5.28,-4.69,-4.97,-6.12,-6.09,-7.47,-7.84,-8.97,-9.22,-9.78,-9.47,-10.09,-9.91,-9.66,-9.19,-8.81,-8.44,-7.69,-6.72,-5.81,-4.78,-3.59,-2.53,-2.62,-2.59,-2.56,-3.44,-5.31,-7.19,-8.59,-10.59,-10.84,-10.16,-9.25,-7.03,-5.81,-4.19,-2.66,-1.81,-1.06,-0.53,-0.47,-1.06,-0.88,-1.12,-0.22,0.47,0.81,1.34,1.19,0.97,-0.12,-1.19,-2.66,-5.34,-6.72,-8.47,-9.34,-9.22,-7.34,-5.03,-3.59,-0.94,0.16,1.09,0.94,0.28,-0.81,-1.44,-2.72,-4.22,-5.5,-7.12,-8.69,-11.44,-13.47,-15.31,-15.69,-16.34,-16.59,-14.22,-11.81,-9.78,-7.62,-5.03,-3.81,-2.16,-1.81,-1.47,-1.84,-2.78,-3.72,-4.97,-5.41,-5.97,-7.06,-8.22,-10.88,-13.34,-15.59,-16.41,-16.75,-16.56,-14.72,-13.22,-12.44,-10.81,-9.66,-8.47,-6.66,-5.59,-4.88,-5.28,-6.78,-8.72,-11.47,-12.59,-13.19,-13.38,-12.47,-11.91,-10.72,-8.66,-6.84,-3.25,0.06,2.16,3.41,2.44,0.06,-3.97,-7.84,-10.09,-12.47,-13.12,-12.53,-12.72,-11.84,-11.66,-11.03,-9.84,-7.56,-5.81,-4.34,-3.5,-3.06,-4.66,-5.34,-6.66,-7.84,-8.28,-8.59,-9.25,-9.44,-9.66,-10.66,-10.59,-11.47,-11.06,-10.22,-8.31,-6.19,-2.66,0.94,4.94,8.34,11.62,13.91,15.78,15.22,13.47,10.0,5.81,1.81,-1.94,-4.09,-4.66,-3.22,-0.16,2.94,7.38,10.5,12.19,12.31,11.28,9.75,7.78,6.53,5.56,4.69,4.16,3.16,1.91,-0.44,-2.72,-4.5,-6.41,-8.22,-7.81,-6.53,-4.56,-1.22,-2.22,-2.56,-4.19,-6.31,-7.81,-10.75,-12.47,-14.75,-16.66,-17.28,-17.56,-16.31,-14.44,-12.31,-10.12,-7.56,-6.38,-4.34,-3.31,-2.31,-2.22,-1.84,-2.53,-4.09:-5.09,-3.91,-4.22,-4.56,-4.69,-5.91,-6.59,-6.91,-6.94,-5.28,-3.41,-0.44,1.97,3.56,4.53,4.78,4.09,2.5,2.12,1.25,0.81,-0.56,0.0,-0.47,-1.22,-0.12,0.41,1.44,1.5,2.41,1.16,2.06,0.56,0.12,-1.16,-2.41,-4.47,-6.72,-9.47,-11.53,-13.34,-14.69,-15.59,-15.75,-15.44,-14.53,-14.78,-14.62,-13.84,-14.53,-14.34,-14.22,-14.53,-13.28,-13.41,-13.47,-14.41,-15.66,-15.41,-15.53,-14.28,-12.91,-11.56,-10.84,-10.41,-8.47,-6.88,-5.09,-2.84,-0.88,-0.09,0.62,1.06,2.12,3.94,3.81,5.09,6.31,6.88,6.59,6.75,5.69,5.03,3.19,2.19,0.97,-0.16,-0.88,-0.66,-0.66,-1.0,-0.03,-0.66,-1.09,-1.16,-2.94,-3.88,-4.91,-5.19,-4.03,-2.91,-1.06,0.84,2.06,3.44,5.0,4.56,4.66,3.81,1.53,0.31,-0.91,-1.88,-2.12,-2.09,-1.38,-0.28,0.31,1.09,2.56,4.31,5.44,7.75,9.88,11.28,11.44,11.19,10.25,8.91,8.41,8.75,8.94,10.78,11.06,11.91,12.41,12.31,12.03,10.81,9.81,8.31,6.06,5.19,5.28,4.81,6.66,8.72,11.38,13.66,14.5,15.94,15.16,13.0,11.66,8.81,6.06,4.75,1.56,-0.72,-1.72,-2.66,-2.97,-3.09,-2.69,-1.47,-0.91,1.28,3.78,6.31,9.06,12.31,14.94,16.97,18.56,18.72,17.56,14.69,10.5,6.06,2.16,-0.84,-2.53,-2.59,-1.66,0.94,3.81,6.75,9.22,11.25,11.25,10.09,8.41,5.72,4.41,2.94,2.81,3.75,4.34,5.19,6.28,7.53,7.81,8.5,9.38,9.22,8.84,8.66,9.25,8.97,9.06,7.72,6.03,3.75,1.19,-0.88,-1.31,-2.28,-1.31,-0.09,0.69,2.88,4.56,5.12,5.12,4.62,2.84,0.31,-2.22,-3.66,-5.66,-6.22,-7.09,-6.88,-7.5,-8.0,-8.94,-10.5,-11.16,-11.47,-10.34,-8.88,-6.34,-4.16,-1.72,0.31,1.5,3.53,3.09,2.12,0.16,-2.59,-4.38,-6.53,-8.41,-9.53,-10.91,-11.97,-12.16,-11.03,-9.53,-6.91,-4.44,-1.19,0.72,2.66,5.34,7.84,8.88,10.25,9.38,8.03,4.5,1.12,-1.66,-5.41,-9.09,-11.34,-14.09,-15.78,-17.22,-17.34,-16.66,-14.91,-13.0,-10.72,-9.09,-6.97,-6.66,-5.0,-5.25,-3.44,-3.78,-3.59,-3.06,-2.94,-3.5,-3.53,-3.56,-4.19,-3.25,-3.16,-2.06,-0.66,0.38,1.12,1.72,2.62,3.81,3.75,4.88,5.28,5.44,5.91,6.0,6.88,6.5,7.0,6.91,5.62,4.78,4.09,3.28,2.88,2.91,2.94,2.5,1.94,0.56,-0.38,-2.31,-4.59,-7.72,-9.81,-11.12,-11.19,-9.69,-5.97,-1.16,5.28,10.97,14.75,16.31,15.16,11.81,7.31,3.25,-0.78,-2.69,-4.25,-5.25,-5.47,-5.56,-6.41,-8.25,-10.31,-11.44,-12.78,-11.94,-9.78,-7.84,-4.91,-2.28,-0.59,1.19,2.22,2.97,2.44,0.59,-1.59,-3.34,-6.28,-6.62,-8.22,-8.97,-9.47,-10.59,-10.19,-9.25,-8.91,-7.16,-6.12,-5.22,-4.0,-3.47,-1.66,1.06,4.19,7.34,10.19,12.66,12.41,12.19,11.41,11.31,10.66,11.22,11.12,10.75,10.44,10.47,9.97,10.59,10.69,11.59,13.19,14.16,15.84,18.22,18.06,20.0,20.88,20.44,20.69,19.72,17.81,16.59,15.12,13.0,12.06,10.41,9.0,6.81,5.09,2.56,-0.28,-3.66,-5.47,-6.44,-7.06,-5.56,-3.56,-1.44,0.56,2.56,4.19,4.5,4.5,3.56,2.06,0.28,-0.69,-1.66,-2.16,-1.28,0.09,1.44,3.12,4.28,3.69,3.81,2.81,3.06,3.16,4.31,5.41,4.69,5.0,4.38,2.88,1.56,0.34,-0.81,-0.94,0.28,1.31,3.16,4.75,5.41,6.19,4.09,3.19,1.09,-1.25,-2.97,-4.59,-4.94,-5.22,-4.75,-4.41,-3.72,-4.19,-5.12,-6.59,-7.97,-8.66,-8.84,-8.53,-7.59,-7.34,-6.72,-6.94,-7.31,-7.16,-6.72,-5.09,-4.16,-2.5,-0.09,2.25,3.44,5.12,5.75,5.75,5.41,5.56,5.31,5.34,5.31,5.28,4.69,3.59,2.41,1.12,0.22,-0.28,-0.69,-0.16,0.25,2.0,2.84,5.0,6.66,7.12,7.78,6.91,6.62,5.25,4.12,3.34,1.94,1.19,0.66,0.34,0.25,0.09,0.44,-0.16,-0.03,-1.06,-0.84,-0.19,0.91,3.06,4.5,4.78,4.88,3.19,1.38,-0.19,-1.31,-2.34,-2.59,-2.34,-1.5,-1.28,-1.91,-2.03,-2.47,-4.12,-5.06,-5.41,-6.03,-6.09,-3.75,-0.75,4.78,11.69,19.16,25.06,28.38,29.0,25.53,19.81,14.12,9.25,6.12,4.78,3.88,3.88,3.75,2.34,1.53,-1.09,-3.09,-5.91,-7.78,-7.94,-7.12,-5.22,-3.47,-2.59,-2.78,-4.12,-5.31,-6.91,-8.28,-8.06,-8.19,-8.06,-6.69,-6.44,-5.38,-4.41,-4.28,-3.78,-4.69,-4.06,-3.66,-3.03,-1.84,-0.66,-0.09,1.75,3.19,4.81,5.53,5.59,5.19,3.5,1.78,-0.34,-1.69,-3.16,-4.47,-4.28,-4.78,-4.5,-4.84,-5.34,-6.28,-6.78,-8.16,-8.72,-8.22,-7.34,-5.94,-3.75,-1.22,0.94,2.69,3.44,4.03,2.62,1.03,-0.47,-1.66,-3.91,-4.62,-6.19,-7.25,-8.56,-9.84,-11.03,-12.19,-13.5,-15.22,-15.16,-14.81,-13.84,-12.41,-10.34,-8.34,-6.84,-5.47,-5.28,-4.69,-4.97,-6.12,-6.09,-7.47,-7.84,-8.97,-9.22,-9.78,-9.47,-10.09,-9.91,-9.66,-9.19,-8.81,-8.44,-7.69,-6.72,-5.81,-4.78,-3.59,-2.53,-2.62,-2.59,-2.56,-3.44,-5.31,-7.19,-8.59,-10.59,-10.84,-10.16,-9.25,-7.03,-5.81,-4.19,-2.66,-1.81,-1.06,-0.53,-0.47,-1.06,-0.88,-1.12,-0.22,0.47,0.81,1.34,1.19,0.97,-0.12,-1.19,-2.66,-5.34,-6.72,-8.47,-9.34,-9.22,-7.34,-5.03,-3.59,-0.94,0.16,1.09,0.94,0.28,-0.81,-1.44,-2.72,-4.22,-5.5,-7.12,-8.69,-11.44,-13.47,-15.31,-15.69,-16.34,-16.59,-14.22,-11.81,-9.78,-7.62,-5.03,-3.81,-2.16,-1.81,-1.47,-1.84,-2.78,-3.72,-4.97,-5.41,-5.97,-7.06,-8.22,-10.88,-13.34,-15.59,-16.41,-16.75,-16.56,-14.72,-13.22,-12.44,-10.81,-9.66,-8.47,-6.66,-5.59,-4.88,-5.28,-6.78,-8.72,-11.47,-12.59,-13.19,-13.38,-12.47,-11.91,-10.72,-8.66,-6.84,-3.25,0.06,2.16,3.41,2.44,0.06,-3.97,-7.84,-10.09,-12.47,-13.12,-12.53,-12.72,-11.84,-11.66,-11.03,-9.84,-7.56,-5.81,-4.34,-3.5,-3.06,-4.66,-5.34,-6.66,-7.84,-8.28,-8.59,-9.25,-9.44,-9.66,-10.66,-10.59,-11.47,-11.06,-10.22,-8.31,-6.19,-2.66,0.94,4.94,8.34,11.62,13.91,15.78,15.22,13.47,10.0,5.81,1.81,-1.94,-4.09,-4.66,-3.22,-0.16,2.94,7.38,10.5,12.19,12.31,11.28,9.75,7.78,6.53,5.56,4.69,4.16,3.16,1.91,-0.44,-2.72,-4.5,-6.41,-8.22,-7.81,-6.53,-4.56,-1.22,-2.22,-2.56,-4.19,-6.31,-7.81,-10.75,-12.47,-14.75,-16.66,-17.28,-17.56,-16.31,-14.44,-12.31,-10.12,-7.56,-6.38,-4.34,-3.31,-2.31,-2.22,-1.84,-2.53,-4.09,-5.31,-7.34,-10.06,-11.06,-12.59,-12.94:positivity
17.16,15.62,14.81,12.06,10.12,9.34,8.53,8.66,9.69,10.06,11.0,11.25,11.22,12.25,12.25,11.56,12.06,11.72,12.41,11.59,12.25,11.78,10.22,10.75,8.22,7.31,6.31,4.94,4.41,3.78,4.62,5.44,7.38,8.41,9.12,10.69,10.81,10.69,10.69,8.75,8.59,5.91,5.12,5.44,4.81,7.66,8.78,11.25,14.5,14.62,16.47,15.91,15.56,13.41,12.09,10.19,9.81,7.72,7.03,6.69,5.53,5.28,4.84,4.0,5.03,4.38,4.56,4.41,5.97,5.53,4.97,3.22,2.03,-0.41,-3.12,-4.09,-4.84,-6.59,-6.91,-6.88,-6.0,-5.16,-4.03,-2.47,-1.0,-0.22,0.56,1.88,2.94,0.5,1.78,1.97,1.0,3.25,3.25,2.66,4.34,2.0,1.41,1.91,1.69,0.56,1.75,1.47,0.28,0.31,0.56,0.12,-0.72,-1.09,-1.19,-2.75,-4.03,-4.5,-5.0,-6.22,-6.47,-6.31,-6.72,-5.97,-4.16,-2.09,-0.78,0.12,1.5,1.16,0.0,-0.16,-1.44,-1.44,0.0,0.69,1.91,3.03,3.62,2.25,1.81,1.06,0.88,2.28,5.94,10.03,14.41,18.59,19.44,19.0,15.09,10.12,6.38,2.78,0.12,0.06,0.81,2.19,3.12,3.38,3.12,1.84,-0.03,-0.78,-1.78,-1.72,-0.78,-0.66,-1.25,-1.97,-2.72,-3.44,-2.84,-3.12,-2.59,-2.34,-1.03,-0.16,1.53,2.66,3.56,4.16,3.62,3.44,2.0,0.94,-1.28,-2.06,-4.59,-4.28,-4.28,-3.16,-3.09,-2.22,-2.06,-3.34,-4.66,-6.34,-8.47,-10.34,-10.69,-10.62,-10.03,-10.16,-8.97,-8.84,-8.84,-7.97,-7.09,-5.22,-2.84,-2.5,-1.03,0.34,1.81,2.19,2.12,2.56,1.0,1.19,-3.22,-4.56,-4.72,-6.66,-6.97,-5.16,-3.66,-1.31,-0.19,0.56,1.5,0.56,0.06,-1.16,-2.28,-4.22,-5.72,-6.94,-7.12,-8.53,-7.22,-6.59,-4.38,-3.56,-2.09,0.06,0.31,0.88,-0.03,-1.44,-3.28,-4.91,-6.94,-7.34,-7.94,-7.97,-8.31,-6.66,-6.09,-6.09,-4.16,-4.97,-4.44,-4.94,-5.03,-4.12,-4.59,-4.91,-5.78,-7.22,-8.91,-9.94,-10.75,-11.38,-9.81,-10.16,-8.53,-7.28,-6.22,-4.59,-3.66,-2.84,-2.84,-3.34,-4.12,-5.66,-6.22,-6.41,-6.88,-7.09,-6.91,-7.09,-6.44,-5.28,-5.12,-4.84,-5.03,-5.09,-6.03,-5.53,-4.75,-4.88,-4.97,-4.28,-5.03,-5.44,-5.44,-4.34,-4.53,-3.28,-1.78,-1.09,0.41,1.69,3.38,4.38,5.12,5.78,6.56,7.38,6.53,7.69,7.31,6.56,4.88,2.16,0.16,-1.88,-4.09,-5.59,-6.66,-8.12,-8.0,-8.22,-8.59,-6.91,-7.34,-6.69,-8.09,-8.09,-8.62,-8.0,-7.94,-7.22,-6.53,-7.41,-6.91,-7.66,-6.88,-5.75,-4.59,-2.84,-1.12,-0.22,1.97,3.84,4.59,6.03,5.81,5.0,3.88,2.44,0.06,-1.41,-1.72,-1.69,-1.34,0.66,1.75,3.12,4.5,5.5,5.56,5.44,5.62,3.94,3.47,3.62,3.31,4.09,5.19,4.12,3.66,4.09,3.41,4.31,6.22,7.56,9.69,9.19,8.59,7.41,6.12,6.16,5.25,5.12,4.47,3.62,3.12,2.84,2.78,3.38,3.25,3.09,1.34,0.66,-0.31,-1.41,-2.19,-1.34,0.12,3.06,6.84,10.53,12.78,13.12,12.09,8.41,4.72,1.62,-1.5,-3.16,-4.91,-5.47,-5.75,-6.44,-6.22,-7.12,-8.62,-10.06,-10.66,-11.09,-10.84,-10.59,-9.16,-8.59,-7.34,-7.66,-6.69,-4.97,-5.03,-3.56,-1.44,0.06,1.5,2.56,2.44,1.41,1.06,0.06,-0.47,0.12,-0.06,0.25,0.31,-0.28,-0.59,-0.84,-0.03,0.09,0.56,1.12,1.69,2.0,1.81,1.06,1.78,1.72,1.78,2.0,2.06,2.41,3.38,3.72,4.88,4.44,4.03,3.09,2.06,1.22,1.56,2.94,3.75,5.69,6.34,7.81,8.5,9.53,9.31,7.97,6.81,4.34,0.91,-1.0,-2.44,-3.84,-3.78,-3.81,-2.91,-1.91,-0.81,0.56,0.28,0.34,0.0,-1.22,-1.34,-1.41,-0.91,-0.62,0.09,-0.75,-2.16,-2.28,-4.22,-5.62,-6.53,-7.78,-7.28,-6.53,-6.66,-4.53,-3.47,-1.44,-0.59,1.84,2.44,3.38,3.88,4.91,4.22,4.16,4.53,3.53,3.53,3.12,2.53,2.88,2.81,2.75,3.66,3.94,5.09,5.31,5.25,4.94,4.81,6.09,6.72,8.84,9.91,11.53,11.34,11.72,10.16,9.44,8.19,6.88,4.38,3.22,2.19,1.56,0.91,1.03,1.47,1.97,2.06,3.69,4.91,6.5,8.06,9.16,9.94,10.81,11.47,11.94,10.69,9.75,7.84,6.31,4.66,3.59,2.16,1.44,1.06,1.62,2.5,3.22,4.56,5.56,7.16,7.97,9.0,9.0,8.84,7.72,5.44,5.38,4.53,3.03,3.69,3.53,3.03,3.25,3.81,4.56,6.19,8.53,11.12,12.44,13.62,13.72,13.44,12.88,13.53,13.53,14.97,16.28,17.38,16.91,17.31,17.44,16.62,15.81,14.88,14.34,13.81,12.31,11.31,10.28,9.44,8.19,6.88,5.69,5.28,5.09,5.62,5.88,6.19,7.06,6.88,6.91,5.75,6.16,4.94,4.91,4.34,4.94,5.25,6.81,8.69,10.38,12.62,13.94,14.78,14.38,14.81,13.81,12.5,11.41,11.0,9.25,9.16,9.12,8.41,8.19,7.88,7.72,8.19,8.91,9.09,8.88,9.16,8.5,8.66,7.19,7.53,7.16,6.31,7.22,9.16,11.69,15.62,19.06,19.88,20.66,17.38,13.38,8.22,4.94,2.53,2.41,3.09,4.5,5.56,6.28,7.38,7.59,7.59,7.28,6.78,5.56,4.31,4.31,3.75,3.94,4.62,2.75,3.97,3.0,2.91,3.12,3.94,4.91,5.34,5.94,4.28,2.09,0.16,-2.59,-4.5,-5.44,-5.72,-4.84,-3.28,-2.59,-1.16,-0.88,-0.31,-0.53,-0.19,-0.66,-0.66,-0.44,-0.22,-0.09,0.44,1.0,1.06,1.28,0.22,-0.22,-1.5,-1.66,-1.59,-1.28,0.16,2.59,3.75,5.84,7.88,9.84,11.31,12.56,13.56,13.06,11.97,10.22,7.94,5.94,3.41,2.25,0.41,-1.34,-1.53,-1.28,-0.88,0.31,1.44,2.81,3.25,3.78,4.62,5.5,6.56,7.41,7.91,8.41,8.56,9.34,9.19,8.84,8.03,7.09,7.12,5.94,5.72,6.31,6.25,7.12,8.09,8.75,8.53,9.72,9.81,8.88,7.94,8.19,7.34,6.19,6.69,6.5,5.91,6.66,6.19,6.97,7.44,7.16,7.28,7.56,6.66,7.12,8.12,9.44,9.25,10.78,11.34,11.41,11.06,9.97,8.84,6.44,4.62,1.88,-0.38,-2.06,-3.03,-3.25,-3.75,-4.06,-3.84,-3.84,-3.38,-2.72,-1.41,0.62,1.62,2.94,4.19,4.91,4.94,3.81,2.22,1.19,0.44,1.22,2.03,4.06,4.59,4.28,4.69,3.78,3.0,2.22,1.78,1.06,0.78,0.34,-0.5,-0.72,-0.69,-1.59,-1.97,-2.12,-3.34,-2.56,-3.28,-3.12,-3.44,-2.84,-2.66,-2.31,-1.31,-1.22,-0.66,-1.66,-2.72,-4.34,-6.28,-9.09,-12.53,-15.12,-15.91,-17.97,-18.97,-20.81,-22.34,-24.5,-26.41,-28.59,-28.28,-27.94,-27.59,-26.12,-25.03,-24.16,-23.97,-24.09,-26.66,-28.47:8.53,8.66,9.69,10.06,11.0,11.25,11.22,12.25,12.25,11.56,12.06,11.72,12.41,11.59,12.25,11.78,10.22,10.75,8.22,7.31,6.31,4.94,4.41,3.78,4.62,5.44,7.38,8.41,9.12,10.69,10.81,10.69,10.69,8.75,8.59,5.91,5.12,5.44,4.81,7.66,8.78,11.25,14.5,14.62,16.47,15.91,15.56,13.41,12.09,10.19,9.81,7.72,7.03,6.69,5.53,5.28,4.84,4.0,5.03,4.38,4.56,4.41,5.97,5.53,4.97,3.22,2.03,-0.41,-3.12,-4.09,-4.84,-6.59,-6.91,-6.88,-6.0,-5.16,-4.03,-2.47,-1.0,-0.22,0.56,1.88,2.94,0.5,1.78,1.97,1.0,3.25,3.25,2.66,4.34,2.0,1.41,1.91,1.69,0.56,1.75,1.47,0.28,0.31,0.56,0.12,-0.72,-1.09,-1.19,-2.75,-4.03,-4.5,-5.0,-6.22,-6.47,-6.31,-6.72,-5.97,-4.16,-2.09,-0.78,0.12,1.5,1.16,0.0,-0.16,-1.44,-1.44,0.0,0.69,1.91,3.03,3.62,2.25,1.81,1.06,0.88,2.28,5.94,10.03,14.41,18.59,19.44,19.0,15.09,10.12,6.38,2.78,0.12,0.06,0.81,2.19,3.12,3.38,3.12,1.84,-0.03,-0.78,-1.78,-1.72,-0.78,-0.66,-1.25,-1.97,-2.72,-3.44,-2.84,-3.12,-2.59,-2.34,-1.03,-0.16,1.53,2.66,3.56,4.16,3.62,3.44,2.0,0.94,-1.28,-2.06,-4.59,-4.28,-4.28,-3.16,-3.09,-2.22,-2.06,-3.34,-4.66,-6.34,-8.47,-10.34,-10.69,-10.62,-10.03,-10.16,-8.97,-8.84,-8.84,-7.97,-7.09,-5.22,-2.84,-2.5,-1.03,0.34,1.81,2.19,2.12,2.56,1.0,1.19,-3.22,-4.56,-4.72,-6.66,-6.97,-5.16,-3.66,-1.31,-0.19,0.56,1.5,0.56,0.06,-1.16,-2.28,-4.22,-5.72,-6.94,-7.12,-8.53,-7.22,-6.59,-4.38,-3.56,-2.09,0.06,0.31,0.88,-0.03,-1.44,-3.28,-4.91,-6.94,-7.34,-7.94,-7.97,-8.31,-6.66,-6.09,-6.09,-4.16,-4.97,-4.44,-4.94,-5.03,-4.12,-4.59,-4.91,-5.78,-7.22,-8.91,-9.94,-10.75,-11.38,-9.81,-10.16,-8.53,-7.28,-6.22,-4.59,-3.66,-2.84,-2.84,-3.34,-4.12,-5.66,-6.22,-6.41,-6.88,-7.09,-6.91,-7.09,-6.44,-5.28,-5.12,-4.84,-5.03,-5.09,-6.03,-5.53,-4.75,-4.88,-4.97,-4.28,-5.03,-5.44,-5.44,-4.34,-4.53,-3.28,-1.78,-1.09,0.41,1.69,3.38,4.38,5.12,5.78,6.56,7.38,6.53,7.69,7.31,6.56,4.88,2.16,0.16,-1.88,-4.09,-5.59,-6.66,-8.12,-8.0,-8.22,-8.59,-6.91,-7.34,-6.69,-8.09,-8.09,-8.62,-8.0,-7.94,-7.22,-6.53,-7.41,-6.91,-7.66,-6.88,-5.75,-4.59,-2.84,-1.12,-0.22,1.97,3.84,4.59,6.03,5.81,5.0,3.88,2.44,0.06,-1.41,-1.72,-1.69,-1.34,0.66,1.75,3.12,4.5,5.5,5.56,5.44,5.62,3.94,3.47,3.62,3.31,4.09,5.19,4.12,3.66,4.09,3.41,4.31,6.22,7.56,9.69,9.19,8.59,7.41,6.12,6.16,5.25,5.12,4.47,3.62,3.12,2.84,2.78,3.38,3.25,3.09,1.34,0.66,-0.31,-1.41,-2.19,-1.34,0.12,3.06,6.84,10.53,12.78,13.12,12.09,8.41,4.72,1.62,-1.5,-3.16,-4.91,-5.47,-5.75,-6.44,-6.22,-7.12,-8.62,-10.06,-10.66,-11.09,-10.84,-10.59,-9.16,-8.59,-7.34,-7.66,-6.69,-4.97,-5.03,-3.56,-1.44,0.06,1.5,2.56,2.44,1.41,1.06,0.06,-0.47,0.12,-0.06,0.25,0.31,-0.28,-0.59,-0.84,-0.03,0.09,0.56,1.12,1.69,2.0,1.81,1.06,1.78,1.72,1.78,2.0,2.06,2.41,3.38,3.72,4.88,4.44,4.03,3.09,2.06,1.22,1.56,2.94,3.75,5.69,6.34,7.81,8.5,9.53,9.31,7.97,6.81,4.34,0.91,-1.0,-2.44,-3.84,-3.78,-3.81,-2.91,-1.91,-0.81,0.56,0.28,0.34,0.0,-1.22,-1.34,-1.41,-0.91,-0.62,0.09,-0.75,-2.16,-2.28,-4.22,-5.62,-6.53,-7.78,-7.28,-6.53,-6.66,-4.53,-3.47,-1.44,-0.59,1.84,2.44,3.38,3.88,4.91,4.22,4.16,4.53,3.53,3.53,3.12,2.53,2.88,2.81,2.75,3.66,3.94,5.09,5.31,5.25,4.94,4.81,6.09,6.72,8.84,9.91,11.53,11.34,11.72,10.16,9.44,8.19,6.88,4.38,3.22,2.19,1.56,0.91,1.03,1.47,1.97,2.06,3.69,4.91,6.5,8.06,9.16,9.94,10.81,11.47,11.94,10.69,9.75,7.84,6.31,4.66,3.59,2.16,1.44,1.06,1.62,2.5,3.22,4.56,5.56,7.16,7.97,9.0,9.0,8.84,7.72,5.44,5.38,4.53,3.03,3.69,3.53,3.03,3.25,3.81,4.56,6.19,8.53,11.12,12.44,13.62,13.72,13.44,12.88,13.53,13.53,14.97,16.28,17.38,16.91,17.31,17.44,16.62,15.81,14.88,14.34,13.81,12.31,11.31,10.28,9.44,8.19,6.88,5.69,5.28,5.09,5.62,5.88,6.19,7.06,6.88,6.91,5.75,6.16,4.94,4.91,4.34,4.94,5.25,6.81,8.69,10.38,12.62,13.94,14.78,14.38,14.81,13.81,12.5,11.41,11.0,9.25,9.16,9.12,8.41,8.19,7.88,7.72,8.19,8.91,9.09,8.88,9.16,8.5,8.66,7.19,7.53,7.16,6.31,7.22,9.16,11.69,15.62,19.06,19.88,20.66,17.38,13.38,8.22,4.94,2.53,2.41,3.09,4.5,5.56,6.28,7.38,7.59,7.59,7.28,6.78,5.56,4.31,4.31,3.75,3.94,4.62,2.75,3.97,3.0,2.91,3.12,3.94,4.91,5.34,5.94,4.28,2.09,0.16,-2.59,-4.5,-5.44,-5.72,-4.84,-3.28,-2.59,-1.16,-0.88,-0.31,-0.53,-0.19,-0.66,-0.66,-0.44,-0.22,-0.09,0.44,1.0,1.06,1.28,0.22,-0.22,-1.5,-1.66,-1.59,-1.28,0.16,2.59,3.75,5.84,7.88,9.84,11.31,12.56,13.56,13.06,11.97,10.22,7.94,5.94,3.41,2.25,0.41,-1.34,-1.53,-1.28,-0.88,0.31,1.44,2.81,3.25,3.78,4.62,5.5,6.56,7.41,7.91,8.41,8.56,9.34,9.19,8.84,8.03,7.09,7.12,5.94,5.72,6.31,6.25,7.12,8.09,8.75,8.53,9.72,9.81,8.88,7.94,8.19,7.34,6.19,6.69,6.5,5.91,6.66,6.19,6.97,7.44,7.16,7.28,7.56,6.66,7.12,8.12,9.44,9.25,10.78,11.34,11.41,11.06,9.97,8.84,6.44,4.62,1.88,-0.38,-2.06,-3.03,-3.25,-3.75,-4.06,-3.84,-3.84,-3.38,-2.72,-1.41,0.62,1.62,2.94,4.19,4.91,4.94,3.81,2.22,1.19,0.44,1.22,2.03,4.06,4.59,4.28,4.69,3.78,3.0,2.22,1.78,1.06,0.78,0.34,-0.5,-0.72,-0.69,-1.59,-1.97,-2.12,-3.34,-2.56,-3.28,-3.12,-3.44,-2.84,-2.66,-2.31,-1.31,-1.22,-0.66,-1.66,-2.72,-4.34,-6.28,-9.09,-12.53,-15.12,-15.91,-17.97,-18.97,-20.81,-22.34,-24.5,-26.41,-28.59,-28.28,-27.94,-27.59,-26.12,-25.03,-24.16,-23.97,-24.09,-26.66,-28.47,2.03,0.59,0.53,-1.31,-2.22,-2.16:11.22,12.25,12.25,11.56,12.06,11.72,12.41,11.59,12.25,11.78,10.22,10.75,8.22,7.31,6.31,4.94,4.41,3.78,4.62,5.44,7.38,8.41,9.12,10.69,10.81,10.69,10.69,8.75,8.59,5.91,5.12,5.44,4.81,7.66,8.78,11.25,14.5,14.62,16.47,15.91,15.56,13.41,12.09,10.19,9.81,7.72,7.03,6.69,5.53,5.28,4.84,4.0,5.03,4.38,4.56,4.41,5.97,5.53,4.97,3.22,2.03,-0.41,-3.12,-4.09,-4.84,-6.59,-6.91,-6.88,-6.0,-5.16,-4.03,-2.47,-1.0,-0.22,0.56,1.88,2.94,0.5,1.78,1.97,1.0,3.25,3.25,2.66,4.34,2.0,1.41,1.91,1.69,0.56,1.75,1.47,0.28,0.31,0.56,0.12,-0.72,-1.09,-1.19,-2.75,-4.03,-4.5,-5.0,-6.22,-6.47,-6.31,-6.72,-5.97,-4.16,-2.09,-0.78,0.12,1.5,1.16,0.0,-0.16,-1.44,-1.44,0.0,0.69,1.91,3.03,3.62,2.25,1.81,1.06,0.88,2.28,5.94,10.03,14.41,18.59,19.44,19.0,15.09,10.12,6.38,2.78,0.12,0.06,0.81,2.19,3.12,3.38,3.12,1.84,-0.03,-0.78,-1.78,-1.72,-0.78,-0.66,-1.25,-1.97,-2.72,-3.44,-2.84,-3.12,-2.59,-2.34,-1.03,-0.16,1.53,2.66,3.56,4.16,3.62,3.44,2.0,0.94,-1.28,-2.06,-4.59,-4.28,-4.28,-3.16,-3.09,-2.22,-2.06,-3.34,-4.66,-6.34,-8.47,-10.34,-10.69,-10.62,-10.03,-10.16,-8.97,-8.84,-8.84,-7.97,-7.09,-5.22,-2.84,-2.5,-1.03,0.34,1.81,2.19,2.12,2.56,1.0,1.19,-3.22,-4.56,-4.72,-6.66,-6.97,-5.16,-3.66,-1.31,-0.19,0.56,1.5,0.56,0.06,-1.16,-2.28,-4.22,-5.72,-6.94,-7.12,-8.53,-7.22,-6.59,-4.38,-3.56,-2.09,0.06,0.31,0.88,-0.03,-1.44,-3.28,-4.91,-6.94,-7.34,-7.94,-7.97,-8.31,-6.66,-6.09,-6.09,-4.16,-4.97,-4.44,-4.94,-5.03,-4.12,-4.59,-4.91,-5.78,-7.22,-8.91,-9.94,-10.75,-11.38,-9.81,-10.16,-8.53,-7.28,-6.22,-4.59,-3.66,-2.84,-2.84,-3.34,-4.12,-5.66,-6.22,-6.41,-6.88,-7.09,-6.91,-7.09,-6.44,-5.28,-5.12,-4.84,-5.03,-5.09,-6.03,-5.53,-4.75,-4.88,-4.97,-4.28,-5.03,-5.44,-5.44,-4.34,-4.53,-3.28,-1.78,-1.09,0.41,1.69,3.38,4.38,5.12,5.78,6.56,7.38,6.53,7.69,7.31,6.56,4.88,2.16,0.16,-1.88,-4.09,-5.59,-6.66,-8.12,-8.0,-8.22,-8.59,-6.91,-7.34,-6.69,-8.09,-8.09,-8.62,-8.0,-7.94,-7.22,-6.53,-7.41,-6.91,-7.66,-6.88,-5.75,-4.59,-2.84,-1.12,-0.22,1.97,3.84,4.59,6.03,5.81,5.0,3.88,2.44,0.06,-1.41,-1.72,-1.69,-1.34,0.66,1.75,3.12,4.5,5.5,5.56,5.44,5.62,3.94,3.47,3.62,3.31,4.09,5.19,4.12,3.66,4.09,3.41,4.31,6.22,7.56,9.69,9.19,8.59,7.41,6.12,6.16,5.25,5.12,4.47,3.62,3.12,2.84,2.78,3.38,3.25,3.09,1.34,0.66,-0.31,-1.41,-2.19,-1.34,0.12,3.06,6.84,10.53,12.78,13.12,12.09,8.41,4.72,1.62,-1.5,-3.16,-4.91,-5.47,-5.75,-6.44,-6.22,-7.12,-8.62,-10.06,-10.66,-11.09,-10.84,-10.59,-9.16,-8.59,-7.34,-7.66,-6.69,-4.97,-5.03,-3.56,-1.44,0.06,1.5,2.56,2.44,1.41,1.06,0.06,-0.47,0.12,-0.06,0.25,0.31,-0.28,-0.59,-0.84,-0.03,0.09,0.56,1.12,1.69,2.0,1.81,1.06,1.78,1.72,1.78,2.0,2.06,2.41,3.38,3.72,4.88,4.44,4.03,3.09,2.06,1.22,1.56,2.94,3.75,5.69,6.34,7.81,8.5,9.53,9.31,7.97,6.81,4.34,0.91,-1.0,-2.44,-3.84,-3.78,-3.81,-2.91,-1.91,-0.81,0.56,0.28,0.34,0.0,-1.22,-1.34,-1.41,-0.91,-0.62,0.09,-0.75,-2.16,-2.28,-4.22,-5.62,-6.53,-7.78,-7.28,-6.53,-6.66,-4.53,-3.47,-1.44,-0.59,1.84,2.44,3.38,3.88,4.91,4.22,4.16,4.53,3.53,3.53,3.12,2.53,2.88,2.81,2.75,3.66,3.94,5.09,5.31,5.25,4.94,4.81,6.09,6.72,8.84,9.91,11.53,11.34,11.72,10.16,9.44,8.19,6.88,4.38,3.22,2.19,1.56,0.91,1.03,1.47,1.97,2.06,3.69,4.91,6.5,8.06,9.16,9.94,10.81,11.47,11.94,10.69,9.75,7.84,6.31,4.66,3.59,2.16,1.44,1.06,1.62,2.5,3.22,4.56,5.56,7.16,7.97,9.0,9.0,8.84,7.72,5.44,5.38,4.53,3.03,3.69,3.53,3.03,3.25,3.81,4.56,6.19,8.53,11.12,12.44,13.62,13.72,13.44,12.88,13.53,13.53,14.97,16.28,17.38,16.91,17.31,17.44,16.62,15.81,14.88,14.34,13.81,12.31,11.31,10.28,9.44,8.19,6.88,5.69,5.28,5.09,5.62,5.88,6.19,7.06,6.88,6.91,5.75,6.16,4.94,4.91,4.34,4.94,5.25,6.81,8.69,10.38,12.62,13.94,14.78,14.38,14.81,13.81,12.5,11.41,11.0,9.25,9.16,9.12,8.41,8.19,7.88,7.72,8.19,8.91,9.09,8.88,9.16,8.5,8.66,7.19,7.53,7.16,6.31,7.22,9.16,11.69,15.62,19.06,19.88,20.66,17.38,13.38,8.22,4.94,2.53,2.41,3.09,4.5,5.56,6.28,7.38,7.59,7.59,7.28,6.78,5.56,4.31,4.31,3.75,3.94,4.62,2.75,3.97,3.0,2.91,3.12,3.94,4.91,5.34,5.94,4.28,2.09,0.16,-2.59,-4.5,-5.44,-5.72,-4.84,-3.28,-2.59,-1.16,-0.88,-0.31,-0.53,-0.19,-0.66,-0.66,-0.44,-0.22,-0.09,0.44,1.0,1.06,1.28,0.22,-0.22,-1.5,-1.66,-1.59,-1.28,0.16,2.59,3.75,5.84,7.88,9.84,11.31,12.56,13.56,13.06,11.97,10.22,7.94,5.94,3.41,2.25,0.41,-1.34,-1.53,-1.28,-0.88,0.31,1.44,2.81,3.25,3.78,4.62,5.5,6.56,7.41,7.91,8.41,8.56,9.34,9.19,8.84,8.03,7.09,7.12,5.94,5.72,6.31,6.25,7.12,8.09,8.75,8.53,9.72,9.81,8.88,7.94,8.19,7.34,6.19,6.69,6.5,5.91,6.66,6.19,6.97,7.44,7.16,7.28,7.56,6.66,7.12,8.12,9.44,9.25,10.78,11.34,11.41,11.06,9.97,8.84,6.44,4.62,1.88,-0.38,-2.06,-3.03,-3.25,-3.75,-4.06,-3.84,-3.84,-3.38,-2.72,-1.41,0.62,1.62,2.94,4.19,4.91,4.94,3.81,2.22,1.19,0.44,1.22,2.03,4.06,4.59,4.28,4.69,3.78,3.0,2.22,1.78,1.06,0.78,0.34,-0.5,-0.72,-0.69,-1.59,-1.97,-2.12,-3.34,-2.56,-3.28,-3.12,-3.44,-2.84,-2.66,-2.31,-1.31,-1.22,-0.66,-1.66,-2.72,-4.34,-6.28,-9.09,-12.53,-15.12,-15.91,-17.97,-18.97,-20.81,-22.34,-24.5,-26.41,-28.59,-28.28,-27.94,-27.59,-26.12,-25.03,-24.16,-23.97,-24.09,-26.66,-28.47,2.03,0.59,0.53,-1.31,-2.22,-2.16,-3.22,-2.81,-2.72,-2.22,-1.16,-0.16:12.41,11.59,12.25,11.78,10.22,10.75,8.22,7.31,6.31,4.94,4.41,3.78,4.62,5.44,7.38,8.41,9.12,10.69,10.81,10.69,10.69,8.75,8.59,5.91,5.12,5.44,4.81,7.66,8.78,11.25,14.5,14.62,16.47,15.91,15.56,13.41,12.09,10.19,9.81,7.72,7.03,6.69,5.53,5.28,4.84,4.0,5.03,4.38,4.56,4.41,5.97,5.53,4.97,3.22,2.03,-0.41,-3.12,-4.09,-4.84,-6.59,-6.91,-6.88,-6.0,-5.16,-4.03,-2.47,-1.0,-0.22,0.56,1.88,2.94,0.5,1.78,1.97,1.0,3.25,3.25,2.66,4.34,2.0,1.41,1.91,1.69,0.56,1.75,1.47,0.28,0.31,0.56,0.12,-0.72,-1.09,-1.19,-2.75,-4.03,-4.5,-5.0,-6.22,-6.47,-6.31,-6.72,-5.97,-4.16,-2.09,-0.78,0.12,1.5,1.16,0.0,-0.16,-1.44,-1.44,0.0,0.69,1.91,3.03,3.62,2.25,1.81,1.06,0.88,2.28,5.94,10.03,14.41,18.59,19.44,19.0,15.09,10.12,6.38,2.78,0.12,0.06,0.81,2.19,3.12,3.38,3.12,1.84,-0.03,-0.78,-1.78,-1.72,-0.78,-0.66,-1.25,-1.97,-2.72,-3.44,-2.84,-3.12,-2.59,-2.34,-1.03,-0.16,1.53,2.66,3.56,4.16,3.62,3.44,2.0,0.94,-1.28,-2.06,-4.59,-4.28,-4.28,-3.16,-3.09,-2.22,-2.06,-3.34,-4.66,-6.34,-8.47,-10.34,-10.69,-10.62,-10.03,-10.16,-8.97,-8.84,-8.84,-7.97,-7.09,-5.22,-2.84,-2.5,-1.03,0.34,1.81,2.19,2.12,2.56,1.0,1.19,-3.22,-4.56,-4.72,-6.66,-6.97,-5.16,-3.66,-1.31,-0.19,0.56,1.5,0.56,0.06,-1.16,-2.28,-4.22,-5.72,-6.94,-7.12,-8.53,-7.22,-6.59,-4.38,-3.56,-2.09,0.06,0.31,0.88,-0.03,-1.44,-3.28,-4.91,-6.94,-7.34,-7.94,-7.97,-8.31,-6.66,-6.09,-6.09,-4.16,-4.97,-4.44,-4.94,-5.03,-4.12,-4.59,-4.91,-5.78,-7.22,-8.91,-9.94,-10.75,-11.38,-9.81,-10.16,-8.53,-7.28,-6.22,-4.59,-3.66,-2.84,-2.84,-3.34,-4.12,-5.66,-6.22,-6.41,-6.88,-7.09,-6.91,-7.09,-6.44,-5.28,-5.12,-4.84,-5.03,-5.09,-6.03,-5.53,-4.75,-4.88,-4.97,-4.28,-5.03,-5.44,-5.44,-4.34,-4.53,-3.28,-1.78,-1.09,0.41,1.69,3.38,4.38,5.12,5.78,6.56,7.38,6.53,7.69,7.31,6.56,4.88,2.16,0.16,-1.88,-4.09,-5.59,-6.66,-8.12,-8.0,-8.22,-8.59,-6.91,-7.34,-6.69,-8.09,-8.09,-8.62,-8.0,-7.94,-7.22,-6.53,-7.41,-6.91,-7.66,-6.88,-5.75,-4.59,-2.84,-1.12,-0.22,1.97,3.84,4.59,6.03,5.81,5.0,3.88,2.44,0.06,-1.41,-1.72,-1.69,-1.34,0.66,1.75,3.12,4.5,5.5,5.56,5.44,5.62,3.94,3.47,3.62,3.31,4.09,5.19,4.12,3.66,4.09,3.41,4.31,6.22,7.56,9.69,9.19,8.59,7.41,6.12,6.16,5.25,5.12,4.47,3.62,3.12,2.84,2.78,3.38,3.25,3.09,1.34,0.66,-0.31,-1.41,-2.19,-1.34,0.12,3.06,6.84,10.53,12.78,13.12,12.09,8.41,4.72,1.62,-1.5,-3.16,-4.91,-5.47,-5.75,-6.44,-6.22,-7.12,-8.62,-10.06,-10.66,-11.09,-10.84,-10.59,-9.16,-8.59,-7.34,-7.66,-6.69,-4.97,-5.03,-3.56,-1.44,0.06,1.5,2.56,2.44,1.41,1.06,0.06,-0.47,0.12,-0.06,0.25,0.31,-0.28,-0.59,-0.84,-0.03,0.09,0.56,1.12,1.69,2.0,1.81,1.06,1.78,1.72,1.78,2.0,2.06,2.41,3.38,3.72,4.88,4.44,4.03,3.09,2.06,1.22,1.56,2.94,3.75,5.69,6.34,7.81,8.5,9.53,9.31,7.97,6.81,4.34,0.91,-1.0,-2.44,-3.84,-3.78,-3.81,-2.91,-1.91,-0.81,0.56,0.28,0.34,0.0,-1.22,-1.34,-1.41,-0.91,-0.62,0.09,-0.75,-2.16,-2.28,-4.22,-5.62,-6.53,-7.78,-7.28,-6.53,-6.66,-4.53,-3.47,-1.44,-0.59,1.84,2.44,3.38,3.88,4.91,4.22,4.16,4.53,3.53,3.53,3.12,2.53,2.88,2.81,2.75,3.66,3.94,5.09,5.31,5.25,4.94,4.81,6.09,6.72,8.84,9.91,11.53,11.34,11.72,10.16,9.44,8.19,6.88,4.38,3.22,2.19,1.56,0.91,1.03,1.47,1.97,2.06,3.69,4.91,6.5,8.06,9.16,9.94,10.81,11.47,11.94,10.69,9.75,7.84,6.31,4.66,3.59,2.16,1.44,1.06,1.62,2.5,3.22,4.56,5.56,7.16,7.97,9.0,9.0,8.84,7.72,5.44,5.38,4.53,3.03,3.69,3.53,3.03,3.25,3.81,4.56,6.19,8.53,11.12,12.44,13.62,13.72,13.44,12.88,13.53,13.53,14.97,16.28,17.38,16.91,17.31,17.44,16.62,15.81,14.88,14.34,13.81,12.31,11.31,10.28,9.44,8.19,6.88,5.69,5.28,5.09,5.62,5.88,6.19,7.06,6.88,6.91,5.75,6.16,4.94,4.91,4.34,4.94,5.25,6.81,8.69,10.38,12.62,13.94,14.78,14.38,14.81,13.81,12.5,11.41,11.0,9.25,9.16,9.12,8.41,8.19,7.88,7.72,8.19,8.91,9.09,8.88,9.16,8.5,8.66,7.19,7.53,7.16,6.31,7.22,9.16,11.69,15.62,19.06,19.88,20.66,17.38,13.38,8.22,4.94,2.53,2.41,3.09,4.5,5.56,6.28,7.38,7.59,7.59,7.28,6.78,5.56,4.31,4.31,3.75,3.94,4.62,2.75,3.97,3.0,2.91,3.12,3.94,4.91,5.34,5.94,4.28,2.09,0.16,-2.59,-4.5,-5.44,-5.72,-4.84,-3.28,-2.59,-1.16,-0.88,-0.31,-0.53,-0.19,-0.66,-0.66,-0.44,-0.22,-0.09,0.44,1.0,1.06,1.28,0.22,-0.22,-1.5,-1.66,-1.59,-1.28,0.16,2.59,3.75,5.84,7.88,9.84,11.31,12.56,13.56,13.06,11.97,10.22,7.94,5.94,3.41,2.25,0.41,-1.34,-1.53,-1.28,-0.88,0.31,1.44,2.81,3.25,3.78,4.62,5.5,6.56,7.41,7.91,8.41,8.56,9.34,9.19,8.84,8.03,7.09,7.12,5.94,5.72,6.31,6.25,7.12,8.09,8.75,8.53,9.72,9.81,8.88,7.94,8.19,7.34,6.19,6.69,6.5,5.91,6.66,6.19,6.97,7.44,7.16,7.28,7.56,6.66,7.12,8.12,9.44,9.25,10.78,11.34,11.41,11.06,9.97,8.84,6.44,4.62,1.88,-0.38,-2.06,-3.03,-3.25,-3.75,-4.06,-3.84,-3.84,-3.38,-2.72,-1.41,0.62,1.62,2.94,4.19,4.91,4.94,3.81,2.22,1.19,0.44,1.22,2.03,4.06,4.59,4.28,4.69,3.78,3.0,2.22,1.78,1.06,0.78,0.34,-0.5,-0.72,-0.69,-1.59,-1.97,-2.12,-3.34,-2.56,-3.28,-3.12,-3.44,-2.84,-2.66,-2.31,-1.31,-1.22,-0.66,-1.66,-2.72,-4.34,-6.28,-9.09,-12.53,-15.12,-15.91,-17.97,-18.97,-20.81,-22.34,-24.5,-26.41,-28.59,-28.28,-27.94,-27.59,-26.12,-25.03,-24.16,-23.97,-24.09,-26.66,-28.47,2.03,0.59,0.53,-1.31,-2.22,-2.16,-3.22,-2.81,-2.72,-2.22,-1.16,-0.16,0.19,2.12,2.12,1.59,1.44,0.28:8.22,7.31,6.31,4.94,4.41,3.78,4.62,5.44,7.38,8.41,9.12,10.69,10.81,10.69,10.69,8.75,8.59,5.91,5.12,5.44,4.81,7.66,8.78,11.25,14.5,14.62,16.47,15.91,15.56,13.41,12.09,10.19,9.81,7.72,7.03,6.69,5.53,5.28,4.84,4.0,5.03,4.38,4.56,4.41,5.97,5.53,4.97,3.22,2.03,-0.41,-3.12,-4.09,-4.84,-6.59,-6.91,-6.88,-6.0,-5.16,-4.03,-2.47,-1.0,-0.22,0.56,1.88,2.94,0.5,1.78,1.97,1.0,3.25,3.25,2.66,4.34,2.0,1.41,1.91,1.69,0.56,1.75,1.47,0.28,0.31,0.56,0.12,-0.72,-1.09,-1.19,-2.75,-4.03,-4.5,-5.0,-6.22,-6.47,-6.31,-6.72,-5.97,-4.16,-2.09,-0.78,0.12,1.5,1.16,0.0,-0.16,-1.44,-1.44,0.0,0.69,1.91,3.03,3.62,2.25,1.81,1.06,0.88,2.28,5.94,10.03,14.41,18.59,19.44,19.0,15.09,10.12,6.38,2.78,0.12,0.06,0.81,2.19,3.12,3.38,3.12,1.84,-0.03,-0.78,-1.78,-1.72,-0.78,-0.66,-1.25,-1.97,-2.72,-3.44,-2.84,-3.12,-2.59,-2.34,-1.03,-0.16,1.53,2.66,3.56,4.16,3.62,3.44,2.0,0.94,-1.28,-2.06,-4.59,-4.28,-4.28,-3.16,-3.09,-2.22,-2.06,-3.34,-4.66,-6.34,-8.47,-10.34,-10.69,-10.62,-10.03,-10.16,-8.97,-8.84,-8.84,-7.97,-7.09,-5.22,-2.84,-2.5,-1.03,0.34,1.81,2.19,2.12,2.56,1.0,1.19,-3.22,-4.56,-4.72,-6.66,-6.97,-5.16,-3.66,-1.31,-0.19,0.56,1.5,0.56,0.06,-1.16,-2.28,-4.22,-5.72,-6.94,-7.12,-8.53,-7.22,-6.59,-4.38,-3.56,-2.09,0.06,0.31,0.88,-0.03,-1.44,-3.28,-4.91,-6.94,-7.34,-7.94,-7.97,-8.31,-6.66,-6.09,-6.09,-4.16,-4.97,-4.44,-4.94,-5.03,-4.12,-4.59,-4.91,-5.78,-7.22,-8.91,-9.94,-10.75,-11.38,-9.81,-10.16,-8.53,-7.28,-6.22,-4.59,-3.66,-2.84,-2.84,-3.34,-4.12,-5.66,-6.22,-6.41,-6.88,-7.09,-6.91,-7.09,-6.44,-5.28,-5.12,-4.84,-5.03,-5.09,-6.03,-5.53,-4.75,-4.88,-4.97,-4.28,-5.03,-5.44,-5.44,-4.34,-4.53,-3.28,-1.78,-1.09,0.41,1.69,3.38,4.38,5.12,5.78,6.56,7.38,6.53,7.69,7.31,6.56,4.88,2.16,0.16,-1.88,-4.09,-5.59,-6.66,-8.12,-8.0,-8.22,-8.59,-6.91,-7.34,-6.69,-8.09,-8.09,-8.62,-8.0,-7.94,-7.22,-6.53,-7.41,-6.91,-7.66,-6.88,-5.75,-4.59,-2.84,-1.12,-0.22,1.97,3.84,4.59,6.03,5.81,5.0,3.88,2.44,0.06,-1.41,-1.72,-1.69,-1.34,0.66,1.75,3.12,4.5,5.5,5.56,5.44,5.62,3.94,3.47,3.62,3.31,4.09,5.19,4.12,3.66,4.09,3.41,4.31,6.22,7.56,9.69,9.19,8.59,7.41,6.12,6.16,5.25,5.12,4.47,3.62,3.12,2.84,2.78,3.38,3.25,3.09,1.34,0.66,-0.31,-1.41,-2.19,-1.34,0.12,3.06,6.84,10.53,12.78,13.12,12.09,8.41,4.72,1.62,-1.5,-3.16,-4.91,-5.47,-5.75,-6.44,-6.22,-7.12,-8.62,-10.06,-10.66,-11.09,-10.84,-10.59,-9.16,-8.59,-7.34,-7.66,-6.69,-4.97,-5.03,-3.56,-1.44,0.06,1.5,2.56,2.44,1.41,1.06,0.06,-0.47,0.12,-0.06,0.25,0.31,-0.28,-0.59,-0.84,-0.03,0.09,0.56,1.12,1.69,2.0,1.81,1.06,1.78,1.72,1.78,2.0,2.06,2.41,3.38,3.72,4.88,4.44,4.03,3.09,2.06,1.22,1.56,2.94,3.75,5.69,6.34,7.81,8.5,9.53,9.31,7.97,6.81,4.34,0.91,-1.0,-2.44,-3.84,-3.78,-3.81,-2.91,-1.91,-0.81,0.56,0.28,0.34,0.0,-1.22,-1.34,-1.41,-0.91,-0.62,0.09,-0.75,-2.16,-2.28,-4.22,-5.62,-6.53,-7.78,-7.28,-6.53,-6.66,-4.53,-3.47,-1.44,-0.59,1.84,2.44,3.38,3.88,4.91,4.22,4.16,4.53,3.53,3.53,3.12,2.53,2.88,2.81,2.75,3.66,3.94,5.09,5.31,5.25,4.94,4.81,6.09,6.72,8.84,9.91,11.53,11.34,11.72,10.16,9.44,8.19,6.88,4.38,3.22,2.19,1.56,0.91,1.03,1.47,1.97,2.06,3.69,4.91,6.5,8.06,9.16,9.94,10.81,11.47,11.94,10.69,9.75,7.84,6.31,4.66,3.59,2.16,1.44,1.06,1.62,2.5,3.22,4.56,5.56,7.16,7.97,9.0,9.0,8.84,7.72,5.44,5.38,4.53,3.03,3.69,3.53,3.03,3.25,3.81,4.56,6.19,8.53,11.12,12.44,13.62,13.72,13.44,12.88,13.53,13.53,14.97,16.28,17.38,16.91,17.31,17.44,16.62,15.81,14.88,14.34,13.81,12.31,11.31,10.28,9.44,8.19,6.88,5.69,5.28,5.09,5.62,5.88,6.19,7.06,6.88,6.91,5.75,6.16,4.94,4.91,4.34,4.94,5.25,6.81,8.69,10.38,12.62,13.94,14.78,14.38,14.81,13.81,12.5,11.41,11.0,9.25,9.16,9.12,8.41,8.19,7.88,7.72,8.19,8.91,9.09,8.88,9.16,8.5,8.66,7.19,7.53,7.16,6.31,7.22,9.16,11.69,15.62,19.06,19.88,20.66,17.38,13.38,8.22,4.94,2.53,2.41,3.09,4.5,5.56,6.28,7.38,7.59,7.59,7.28,6.78,5.56,4.31,4.31,3.75,3.94,4.62,2.75,3.97,3.0,2.91,3.12,3.94,4.91,5.34,5.94,4.28,2.09,0.16,-2.59,-4.5,-5.44,-5.72,-4.84,-3.28,-2.59,-1.16,-0.88,-0.31,-0.53,-0.19,-0.66,-0.66,-0.44,-0.22,-0.09,0.44,1.0,1.06,1.28,0.22,-0.22,-1.5,-1.66,-1.59,-1.28,0.16,2.59,3.75,5.84,7.88,9.84,11.31,12.56,13.56,13.06,11.97,10.22,7.94,5.94,3.41,2.25,0.41,-1.34,-1.53,-1.28,-0.88,0.31,1.44,2.81,3.25,3.78,4.62,5.5,6.56,7.41,7.91,8.41,8.56,9.34,9.19,8.84,8.03,7.09,7.12,5.94,5.72,6.31,6.25,7.12,8.09,8.75,8.53,9.72,9.81,8.88,7.94,8.19,7.34,6.19,6.69,6.5,5.91,6.66,6.19,6.97,7.44,7.16,7.28,7.56,6.66,7.12,8.12,9.44,9.25,10.78,11.34,11.41,11.06,9.97,8.84,6.44,4.62,1.88,-0.38,-2.06,-3.03,-3.25,-3.75,-4.06,-3.84,-3.84,-3.38,-2.72,-1.41,0.62,1.62,2.94,4.19,4.91,4.94,3.81,2.22,1.19,0.44,1.22,2.03,4.06,4.59,4.28,4.69,3.78,3.0,2.22,1.78,1.06,0.78,0.34,-0.5,-0.72,-0.69,-1.59,-1.97,-2.12,-3.34,-2.56,-3.28,-3.12,-3.44,-2.84,-2.66,-2.31,-1.31,-1.22,-0.66,-1.66,-2.72,-4.34,-6.28,-9.09,-12.53,-15.12,-15.91,-17.97,-18.97,-20.81,-22.34,-24.5,-26.41,-28.59,-28.28,-27.94,-27.59,-26.12,-25.03,-24.16,-23.97,-24.09,-26.66,-28.47,2.03,0.59,0.53,-1.31,-2.22,-2.16,-3.22,-2.81,-2.72,-2.22,-1.16,-0.16,0.19,2.12,2.12,1.59,1.44,0.28,-0.53,-1.81,-0.78,-3.0,-2.78,-3.66:4.62,5.44,7.38,8.41,9.12,10.69,10.81,10.69,10.69,8.75,8.59,5.91,5.12,5.44,4.81,7.66,8.78,11.25,14.5,14.62,16.47,15.91,15.56,13.41,12.09,10.19,9.81,7.72,7.03,6.69,5.53,5.28,4.84,4.0,5.03,4.38,4.56,4.41,5.97,5.53,4.97,3.22,2.03,-0.41,-3.12,-4.09,-4.84,-6.59,-6.91,-6.88,-6.0,-5.16,-4.03,-2.47,-1.0,-0.22,0.56,1.88,2.94,0.5,1.78,1.97,1.0,3.25,3.25,2.66,4.34,2.0,1.41,1.91,1.69,0.56,1.75,1.47,0.28,0.31,0.56,0.12,-0.72,-1.09,-1.19,-2.75,-4.03,-4.5,-5.0,-6.22,-6.47,-6.31,-6.72,-5.97,-4.16,-2.09,-0.78,0.12,1.5,1.16,0.0,-0.16,-1.44,-1.44,0.0,0.69,1.91,3.03,3.62,2.25,1.81,1.06,0.88,2.28,5.94,10.03,14.41,18.59,19.44,19.0,15.09,10.12,6.38,2.78,0.12,0.06,0.81,2.19,3.12,3.38,3.12,1.84,-0.03,-0.78,-1.78,-1.72,-0.78,-0.66,-1.25,-1.97,-2.72,-3.44,-2.84,-3.12,-2.59,-2.34,-1.03,-0.16,1.53,2.66,3.56,4.16,3.62,3.44,2.0,0.94,-1.28,-2.06,-4.59,-4.28,-4.28,-3.16,-3.09,-2.22,-2.06,-3.34,-4.66,-6.34,-8.47,-10.34,-10.69,-10.62,-10.03,-10.16,-8.97,-8.84,-8.84,-7.97,-7.09,-5.22,-2.84,-2.5,-1.03,0.34,1.81,2.19,2.12,2.56,1.0,1.19,-3.22,-4.56,-4.72,-6.66,-6.97,-5.16,-3.66,-1.31,-0.19,0.56,1.5,0.56,0.06,-1.16,-2.28,-4.22,-5.72,-6.94,-7.12,-8.53,-7.22,-6.59,-4.38,-3.56,-2.09,0.06,0.31,0.88,-0.03,-1.44,-3.28,-4.91,-6.94,-7.34,-7.94,-7.97,-8.31,-6.66,-6.09,-6.09,-4.16,-4.97,-4.44,-4.94,-5.03,-4.12,-4.59,-4.91,-5.78,-7.22,-8.91,-9.94,-10.75,-11.38,-9.81,-10.16,-8.53,-7.28,-6.22,-4.59,-3.66,-2.84,-2.84,-3.34,-4.12,-5.66,-6.22,-6.41,-6.88,-7.09,-6.91,-7.09,-6.44,-5.28,-5.12,-4.84,-5.03,-5.09,-6.03,-5.53,-4.75,-4.88,-4.97,-4.28,-5.03,-5.44,-5.44,-4.34,-4.53,-3.28,-1.78,-1.09,0.41,1.69,3.38,4.38,5.12,5.78,6.56,7.38,6.53,7.69,7.31,6.56,4.88,2.16,0.16,-1.88,-4.09,-5.59,-6.66,-8.12,-8.0,-8.22,-8.59,-6.91,-7.34,-6.69,-8.09,-8.09,-8.62,-8.0,-7.94,-7.22,-6.53,-7.41,-6.91,-7.66,-6.88,-5.75,-4.59,-2.84,-1.12,-0.22,1.97,3.84,4.59,6.03,5.81,5.0,3.88,2.44,0.06,-1.41,-1.72,-1.69,-1.34,0.66,1.75,3.12,4.5,5.5,5.56,5.44,5.62,3.94,3.47,3.62,3.31,4.09,5.19,4.12,3.66,4.09,3.41,4.31,6.22,7.56,9.69,9.19,8.59,7.41,6.12,6.16,5.25,5.12,4.47,3.62,3.12,2.84,2.78,3.38,3.25,3.09,1.34,0.66,-0.31,-1.41,-2.19,-1.34,0.12,3.06,6.84,10.53,12.78,13.12,12.09,8.41,4.72,1.62,-1.5,-3.16,-4.91,-5.47,-5.75,-6.44,-6.22,-7.12,-8.62,-10.06,-10.66,-11.09,-10.84,-10.59,-9.16,-8.59,-7.34,-7.66,-6.69,-4.97,-5.03,-3.56,-1.44,0.06,1.5,2.56,2.44,1.41,1.06,0.06,-0.47,0.12,-0.06,0.25,0.31,-0.28,-0.59,-0.84,-0.03,0.09,0.56,1.12,1.69,2.0,1.81,1.06,1.78,1.72,1.78,2.0,2.06,2.41,3.38,3.72,4.88,4.44,4.03,3.09,2.06,1.22,1.56,2.94,3.75,5.69,6.34,7.81,8.5,9.53,9.31,7.97,6.81,4.34,0.91,-1.0,-2.44,-3.84,-3.78,-3.81,-2.91,-1.91,-0.81,0.56,0.28,0.34,0.0,-1.22,-1.34,-1.41,-0.91,-0.62,0.09,-0.75,-2.16,-2.28,-4.22,-5.62,-6.53,-7.78,-7.28,-6.53,-6.66,-4.53,-3.47,-1.44,-0.59,1.84,2.44,3.38,3.88,4.91,4.22,4.16,4.53,3.53,3.53,3.12,2.53,2.88,2.81,2.75,3.66,3.94,5.09,5.31,5.25,4.94,4.81,6.09,6.72,8.84,9.91,11.53,11.34,11.72,10.16,9.44,8.19,6.88,4.38,3.22,2.19,1.56,0.91,1.03,1.47,1.97,2.06,3.69,4.91,6.5,8.06,9.16,9.94,10.81,11.47,11.94,10.69,9.75,7.84,6.31,4.66,3.59,2.16,1.44,1.06,1.62,2.5,3.22,4.56,5.56,7.16,7.97,9.0,9.0,8.84,7.72,5.44,5.38,4.53,3.03,3.69,3.53,3.03,3.25,3.81,4.56,6.19,8.53,11.12,12.44,13.62,13.72,13.44,12.88,13.53,13.53,14.97,16.28,17.38,16.91,17.31,17.44,16.62,15.81,14.88,14.34,13.81,12.31,11.31,10.28,9.44,8.19,6.88,5.69,5.28,5.09,5.62,5.88,6.19,7.06,6.88,6.91,5.75,6.16,4.94,4.91,4.34,4.94,5.25,6.81,8.69,10.38,12.62,13.94,14.78,14.38,14.81,13.81,12.5,11.41,11.0,9.25,9.16,9.12,8.41,8.19,7.88,7.72,8.19,8.91,9.09,8.88,9.16,8.5,8.66,7.19,7.53,7.16,6.31,7.22,9.16,11.69,15.62,19.06,19.88,20.66,17.38,13.38,8.22,4.94,2.53,2.41,3.09,4.5,5.56,6.28,7.38,7.59,7.59,7.28,6.78,5.56,4.31,4.31,3.75,3.94,4.62,2.75,3.97,3.0,2.91,3.12,3.94,4.91,5.34,5.94,4.28,2.09,0.16,-2.59,-4.5,-5.44,-5.72,-4.84,-3.28,-2.59,-1.16,-0.88,-0.31,-0.53,-0.19,-0.66,-0.66,-0.44,-0.22,-0.09,0.44,1.0,1.06,1.28,0.22,-0.22,-1.5,-1.66,-1.59,-1.28,0.16,2.59,3.75,5.84,7.88,9.84,11.31,12.56,13.56,13.06,11.97,10.22,7.94,5.94,3.41,2.25,0.41,-1.34,-1.53,-1.28,-0.88,0.31,1.44,2.81,3.25,3.78,4.62,5.5,6.56,7.41,7.91,8.41,8.56,9.34,9.19,8.84,8.03,7.09,7.12,5.94,5.72,6.31,6.25,7.12,8.09,8.75,8.53,9.72,9.81,8.88,7.94,8.19,7.34,6.19,6.69,6.5,5.91,6.66,6.19,6.97,7.44,7.16,7.28,7.56,6.66,7.12,8.12,9.44,9.25,10.78,11.34,11.41,11.06,9.97,8.84,6.44,4.62,1.88,-0.38,-2.06,-3.03,-3.25,-3.75,-4.06,-3.84,-3.84,-3.38,-2.72,-1.41,0.62,1.62,2.94,4.19,4.91,4.94,3.81,2.22,1.19,0.44,1.22,2.03,4.06,4.59,4.28,4.69,3.78,3.0,2.22,1.78,1.06,0.78,0.34,-0.5,-0.72,-0.69,-1.59,-1.97,-2.12,-3.34,-2.56,-3.28,-3.12,-3.44,-2.84,-2.66,-2.31,-1.31,-1.22,-0.66,-1.66,-2.72,-4.34,-6.28,-9.09,-12.53,-15.12,-15.91,-17.97,-18.97,-20.81,-22.34,-24.5,-26.41,-28.59,-28.28,-27.94,-27.59,-26.12,-25.03,-24.16,-23.97,-24.09,-26.66,-28.47,2.03,0.59,0.53,-1.31,-2.22,-2.16,-3.22,-2.81,-2.72,-2.22,-1.16,-0.16,0.19,2.12,2.12,1.59,1.44,0.28,-0.53,-1.81,-0.78,-3.0,-2.78,-3.66,-4.72,-6.78,-6.28,-6.16,-5.47,-3.94:positivity
19.25,19.88,19.28,19.25,19.41,19.19,20.44,20.94,21.16,21.62,20.56,19.88,18.38,16.31,15.88,15.06,14.28,14.78,16.0,17.06,17.72,19.19,20.19,19.88,19.0,17.53,15.28,13.06,12.19,11.94,12.56,14.16,15.12,15.59,15.41,13.75,12.62,11.28,11.25,11.34,12.5,12.72,13.75,13.06,11.78,9.16,6.97,5.91,5.03,5.19,5.25,6.88,8.19,7.91,8.41,7.16,5.38,3.97,2.66,2.25,1.97,2.78,4.34,5.56,7.19,9.06,10.91,12.91,13.53,12.72,12.12,9.41,8.12,6.78,5.16,4.25,3.16,1.31,-0.53,-2.16,-3.59,-4.78,-4.41,-4.28,-4.22,-3.03,-3.19,-3.5,-3.78,-5.22,-6.28,-6.12,-5.97,-4.72,-2.88,-1.75,0.66,1.12,2.81,2.19,3.41,4.31,5.59,7.34,9.91,10.62,12.31,12.62,12.81,12.5,12.09,12.41,10.5,8.91,6.94,4.62,3.41,2.84,3.53,4.81,8.75,13.62,17.59,19.62,19.66,17.5,12.88,8.16,4.53,2.06,1.31,2.5,5.91,8.5,10.91,13.06,13.44,13.12,10.66,7.94,4.88,3.56,1.34,0.88,0.28,0.03,0.44,-0.28,0.56,1.75,2.53,3.16,3.41,3.12,2.41,1.66,1.69,1.66,2.44,2.56,4.38,5.62,7.91,8.94,10.41,11.59,11.44,11.69,10.94,9.91,10.06,8.59,7.88,7.44,6.5,5.94,5.69,5.34,5.69,5.81,6.88,7.47,8.22,8.12,7.41,7.06,6.38,6.75,6.59,7.12,8.34,7.88,7.44,7.28,5.44,4.19,3.34,1.59,0.47,-0.09,0.25,1.56,3.06,5.62,6.41,7.38,8.34,7.69,6.06,4.91,3.41,2.56,1.88,3.22,5.47,8.34,10.34,12.19,12.41,12.28,11.12,9.19,7.34,5.78,4.66,3.06,2.53,3.44,3.59,4.84,6.59,8.31,9.81,10.16,10.94,10.94,10.56,11.06,10.75,11.25,10.59,10.03,7.78,5.5,2.84,0.56,-3.25,-5.94,-8.59,-11.0,-11.22,-11.16,-8.94,-6.59,-5.44,-3.62,-2.81,-2.84,-3.12,-2.31,-1.81,-1.22,1.22,2.19,3.88,5.62,6.0,5.22,4.75,3.56,3.09,3.06,2.78,2.94,3.53,4.16,4.5,3.69,3.81,3.19,2.25,1.25,0.88,0.12,-0.34,-0.03,0.78,2.19,4.03,4.53,5.19,5.69,5.16,4.88,5.06,5.53,5.84,6.19,7.91,8.41,8.97,10.09,9.69,9.28,9.53,8.12,7.09,5.5,4.28,3.94,5.03,6.34,7.25,8.62,8.56,8.03,6.66,5.16,3.81,2.5,1.12,1.19,-0.03,0.62,1.69,2.41,5.44,6.78,8.25,10.28,10.34,11.12,11.12,10.44,10.81,9.66,9.34,9.0,9.03,8.88,10.03,10.5,10.5,11.91,12.34,12.31,12.81,14.28,14.44,14.5,15.56,15.94,15.56,14.34,14.0,12.28,10.06,7.38,6.25,3.94,2.81,2.03,1.41,0.88,0.91,2.25,3.72,6.5,10.44,15.22,19.41,22.41,24.06,24.0,23.0,21.78,19.81,18.62,18.19,17.28,16.53,14.97,13.53,11.88,9.69,8.19,7.25,5.56,5.53,4.81,5.0,4.44,5.41,6.69,7.69,10.44,12.53,15.03,17.25,20.16,22.22,23.62,24.38,24.91,24.69,24.81,24.19,22.53,22.0,19.47,16.19,14.81,12.84,11.84,12.5,13.12,13.41,13.31,11.94,11.28,10.38,11.28,12.0,14.84,18.16,21.91,25.34,27.47,29.31,30.25,30.03,28.53,27.28,25.78,24.25,21.81,21.19,19.75,19.41,19.56,20.19,18.41,19.19,18.41,18.38,19.12,20.44,21.41,22.53,23.69,23.38,22.47,20.75,19.44,17.81,16.62,15.31,13.88,13.09,12.25,11.38,10.47,10.34,9.91,10.0,9.28,9.41,9.34,9.66,9.94,11.0,11.66,12.5,13.28,14.19,14.56,14.03,14.19,13.47,12.56,11.56,10.75,9.56,9.31,9.41,9.34,9.56,9.81,9.38,10.09,11.69,12.81,14.56,16.94,18.25,18.66,18.03,18.41,18.28,18.28,19.31,20.06,20.38,20.81,21.0,20.88,20.06,19.19,18.44,18.28,18.44,18.22,18.03,18.69,18.69,19.03,20.38,21.41,21.47,22.16,21.84,20.44,19.44,18.56,17.88,17.75,18.34,17.41,16.78,15.88,13.66,11.78,11.0,10.59,11.59,12.69,14.19,15.28,16.75,17.16,18.22,18.75,17.91,16.44,15.94,12.69,10.75,9.47,9.03,9.47,10.16,10.91,11.38,10.75,10.28,8.91,7.97,6.78,6.44,5.72,5.5,6.41,7.28,9.34,11.66,13.69,15.72,18.06,18.75,19.47,19.72,19.78,19.16,18.12,18.25,18.94,19.41,21.31,23.09,26.25,27.62,28.03,26.5,25.69,23.03,20.03,18.31,18.62,18.72,20.78,22.31,22.06,20.28,16.91,12.91,9.56,6.06,3.53,2.0,0.66,-0.03,-0.66,-1.56,-2.31,-2.66,-3.06,-4.16,-3.88,-2.41,-1.06,2.16,6.16,11.66,18.59,24.81,28.88,30.28,30.38,27.41,23.88,21.34,18.94,17.12,17.0,16.12,16.34,15.97,15.44,15.19,14.88,14.34,14.31,14.5,15.66,16.56,18.59,20.0,20.94,21.5,21.91,20.41,18.84,17.44,15.56,13.81,13.31,13.44,13.59,14.62,15.03,15.25,15.09,14.53,13.69,14.31,14.88,15.56,16.72,18.78,20.56,20.94,20.25,18.62,16.06,13.16,10.0,8.31,7.19,7.5,8.03,10.03,11.75,13.44,14.94,15.59,15.62,15.44,14.19,13.94,13.59,14.09,14.41,15.31,15.53,16.12,16.62,15.88,14.75,14.12,12.44,11.0,10.56,10.66,10.72,11.5,11.66,10.09,8.97,7.12,6.0,6.03,5.72,6.97,7.91,8.19,9.22,9.03,8.41,7.41,6.47,5.06,3.75,2.25,0.66,0.03,-0.47,0.03,0.5,1.59,2.47,3.31,3.88,2.91,1.66,1.0,-0.19,0.28,1.19,3.16,5.59,7.78,9.62,10.34,10.62,10.47,10.31,10.16,9.59,9.41,9.78,9.69,10.06,9.69,10.44,11.12,12.25,13.84,15.19,15.44,15.66,15.59,15.06,15.34,15.78,17.06,18.31,18.56,18.31,17.31,16.09,15.25,15.62,15.72,16.75,16.91,15.44,14.78,13.06,11.31,9.44,7.53,6.94,6.62,6.53,7.66,10.84,13.66,16.62,18.91,20.62,19.91,19.06,17.41,14.81,13.47,12.09,10.94,9.38,6.75,6.53,5.25,5.38,6.03,6.78,6.88,7.69,7.47,8.06,8.47,8.5,9.0,9.91,10.81,11.25,11.28,11.28,9.44,8.25,6.56,4.59,4.41,4.5,3.44,4.53,3.78,4.12,3.81,4.25,5.38,5.81,6.25,6.16,5.41,4.59,3.66,4.75,6.28,7.88,10.03,10.91,12.12,12.88,12.91,12.91,13.41,13.91,13.88,15.03,15.41,16.25,16.66,16.78,18.06,17.59,17.97,18.41,18.28,18.16,17.44,16.69,16.31,16.06,17.84,19.91,23.78,25.75,27.44,27.53,25.5,23.94,21.56,21.31,21.41,22.38,22.88,23.25,23.31,23.88,24.09,23.78,23.34,24.16,23.25,23.66,24.19,24.88,25.31,26.41,25.34,25.06,23.78,22.03,20.5,20.41,19.31,19.25,20.75,21.69,23.0,24.5,25.41,26.56,27.97,28.5,29.66,29.72:20.44,20.94,21.16,21.62,20.56,19.88,18.38,16.31,15.88,15.06,14.28,14.78,16.0,17.06,17.72,19.19,20.19,19.88,19.0,17.53,15.28,13.06,12.19,11.94,12.56,14.16,15.12,15.59,15.41,13.75,12.62,11.28,11.25,11.34,12.5,12.72,13.75,13.06,11.78,9.16,6.97,5.91,5.03,5.19,5.25,6.88,8.19,7.91,8.41,7.16,5.38,3.97,2.66,2.25,1.97,2.78,4.34,5.56,7.19,9.06,10.91,12.91,13.53,12.72,12.12,9.41,8.12,6.78,5.16,4.25,3.16,1.31,-0.53,-2.16,-3.59,-4.78,-4.41,-4.28,-4.22,-3.03,-3.19,-3.5,-3.78,-5.22,-6.28,-6.12,-5.97,-4.72,-2.88,-1.75,0.66,1.12,2.81,2.19,3.41,4.31,5.59,7.34,9.91,10.62,12.31,12.62,12.81,12.5,12.09,12.41,10.5,8.91,6.94,4.62,3.41,2.84,3.53,4.81,8.75,13.62,17.59,19.62,19.66,17.5,12.88,8.16,4.53,2.06,1.31,2.5,5.91,8.5,10.91,13.06,13.44,13.12,10.66,7.94,4.88,3.56,1.34,0.88,0.28,0.03,0.44,-0.28,0.56,1.75,2.53,3.16,3.41,3.12,2.41,1.66,1.69,1.66,2.44,2.56,4.38,5.62,7.91,8.94,10.41,11.59,11.44,11.69,10.94,9.91,10.06,8.59,7.88,7.44,6.5,5.94,5.69,5.34,5.69,5.81,6.88,7.47,8.22,8.12,7.41,7.06,6.38,6.75,6.59,7.12,8.34,7.88,7.44,7.28,5.44,4.19,3.34,1.59,0.47,-0.09,0.25,1.56,3.06,5.62,6.41,7.38,8.34,7.69,6.06,4.91,3.41,2.56,1.88,3.22,5.47,8.34,10.34,12.19,12.41,12.28,11.12,9.19,7.34,5.78,4.66,3.06,2.53,3.44,3.59,4.84,6.59,8.31,9.81,10.16,10.94,10.94,10.56,11.06,10.75,11.25,10.59,10.03,7.78,5.5,2.84,0.56,-3.25,-5.94,-8.59,-11.0,-11.22,-11.16,-8.94,-6.59,-5.44,-3.62,-2.81,-2.84,-3.12,-2.31,-1.81,-1.22,1.22,2.19,3.88,5.62,6.0,5.22,4.75,3.56,3.09,3.06,2.78,2.94,3.53,4.16,4.5,3.69,3.81,3.19,2.25,1.25,0.88,0.12,-0.34,-0.03,0.78,2.19,4.03,4.53,5.19,5.69,5.16,4.88,5.06,5.53,5.84,6.19,7.91,8.41,8.97,10.09,9.69,9.28,9.53,8.12,7.09,5.5,4.28,3.94,5.03,6.34,7.25,8.62,8.56,8.03,6.66,5.16,3.81,2.5,1.12,1.19,-0.03,0.62,1.69,2.41,5.44,6.78,8.25,10.28,10.34,11.12,11.12,10.44,10.81,9.66,9.34,9.0,9.03,8.88,10.03,10.5,10.5,11.91,12.34,12.31,12.81,14.28,14.44,14.5,15.56,15.94,15.56,14.34,14.0,12.28,10.06,7.38,6.25,3.94,2.81,2.03,1.41,0.88,0.91,2.25,3.72,6.5,10.44,15.22,19.41,22.41,24.06,24.0,23.0,21.78,19.81,18.62,18.19,17.28,16.53,14.97,13.53,11.88,9.69,8.19,7.25,5.56,5.53,4.81,5.0,4.44,5.41,6.69,7.69,10.44,12.53,15.03,17.25,20.16,22.22,23.62,24.38,24.91,24.69,24.81,24.19,22.53,22.0,19.47,16.19,14.81,12.84,11.84,12.5,13.12,13.41,13.31,11.94,11.28,10.38,11.28,12.0,14.84,18.16,21.91,25.34,27.47,29.31,30.25,30.03,28.53,27.28,25.78,24.25,21.81,21.19,19.75,19.41,19.56,20.19,18.41,19.19,18.41,18.38,19.12,20.44,21.41,22.53,23.69,23.38,22.47,20.75,19.44,17.81,16.62,15.31,13.88,13.09,12.25,11.38,10.47,10.34,9.91,10.0,9.28,9.41,9.34,9.66,9.94,11.0,11.66,12.5,13.28,14.19,14.56,14.03,14.19,13.47,12.56,11.56,10.75,9.56,9.31,9.41,9.34,9.56,9.81,9.38,10.09,11.69,12.81,14.56,16.94,18.25,18.66,18.03,18.41,18.28,18.28,19.31,20.06,20.38,20.81,21.0,20.88,20.06,19.19,18.44,18.28,18.44,18.22,18.03,18.69,18.69,19.03,20.38,21.41,21.47,22.16,21.84,20.44,19.44,18.56,17.88,17.75,18.34,17.41,16.78,15.88,13.66,11.78,11.0,10.59,11.59,12.69,14.19,15.28,16.75,17.16,18.22,18.75,17.91,16.44,15.94,12.69,10.75,9.47,9.03,9.47,10.16,10.91,11.38,10.75,10.28,8.91,7.97,6.78,6.44,5.72,5.5,6.41,7.28,9.34,11.66,13.69,15.72,18.06,18.75,19.47,19.72,19.78,19.16,18.12,18.25,18.94,19.41,21.31,23.09,26.25,27.62,28.03,26.5,25.69,23.03,20.03,18.31,18.62,18.72,20.78,22.31,22.06,20.28,16.91,12.91,9.56,6.06,3.53,2.0,0.66,-0.03,-0.66,-1.56,-2.31,-2.66,-3.06,-4.16,-3.88,-2.41,-1.06,2.16,6.16,11.66,18.59,24.81,28.88,30.28,30.38,27.41,23.88,21.34,18.94,17.12,17.0,16.12,16.34,15.97,15.44,15.19,14.88,14.34,14.31,14.5,15.66,16.56,18.59,20.0,20.94,21.5,21.91,20.41,18.84,17.44,15.56,13.81,13.31,13.44,13.59,14.62,15.03,15.25,15.09,14.53,13.69,14.31,14.88,15.56,16.72,18.78,20.56,20.94,20.25,18.62,16.06,13.16,10.0,8.31,7.19,7.5,8.03,10.03,11.75,13.44,14.94,15.59,15.62,15.44,14.19,13.94,13.59,14.09,14.41,15.31,15.53,16.12,16.62,15.88,14.75,14.12,12.44,11.0,10.56,10.66,10.72,11.5,11.66,10.09,8.97,7.12,6.0,6.03,5.72,6.97,7.91,8.19,9.22,9.03,8.41,7.41,6.47,5.06,3.75,2.25,0.66,0.03,-0.47,0.03,0.5,1.59,2.47,3.31,3.88,2.91,1.66,1.0,-0.19,0.28,1.19,3.16,5.59,7.78,9.62,10.34,10.62,10.47,10.31,10.16,9.59,9.41,9.78,9.69,10.06,9.69,10.44,11.12,12.25,13.84,15.19,15.44,15.66,15.59,15.06,15.34,15.78,17.06,18.31,18.56,18.31,17.31,16.09,15.25,15.62,15.72,16.75,16.91,15.44,14.78,13.06,11.31,9.44,7.53,6.94,6.62,6.53,7.66,10.84,13.66,16.62,18.91,20.62,19.91,19.06,17.41,14.81,13.47,12.09,10.94,9.38,6.75,6.53,5.25,5.38,6.03,6.78,6.88,7.69,7.47,8.06,8.47,8.5,9.0,9.91,10.81,11.25,11.28,11.28,9.44,8.25,6.56,4.59,4.41,4.5,3.44,4.53,3.78,4.12,3.81,4.25,5.38,5.81,6.25,6.16,5.41,4.59,3.66,4.75,6.28,7.88,10.03,10.91,12.12,12.88,12.91,12.91,13.41,13.91,13.88,15.03,15.41,16.25,16.66,16.78,18.06,17.59,17.97,18.41,18.28,18.16,17.44,16.69,16.31,16.06,17.84,19.91,23.78,25.75,27.44,27.53,25.5,23.94,21.56,21.31,21.41,22.38,22.88,23.25,23.31,23.88,24.09,23.78,23.34,24.16,23.25,23.66,24.19,24.88,25.31,26.41,25.34,25.06,23.78,22.03,20.5,20.41,19.31,19.25,20.75,21.69,23.0,24.5,25.41,26.56,27.97,28.5,29.66,29.72,3.09,1.66,-0.66,-2.03,-2.12,-1.84:18.38,16.31,15.88,15.06,14.28,14.78,16.0,17.06,17.72,19.19,20.19,19.88,19.0,17.53,15.28,13.06,12.19,11.94,12.56,14.16,15.12,15.59,15.41,13.75,12.62,11.28,11.25,11.34,12.5,12.72,13.75,13.06,11.78,9.16,6.97,5.91,5.03,5.19,5.25,6.88,8.19,7.91,8.41,7.16,5.38,3.97,2.66,2.25,1.97,2.78,4.34,5.56,7.19,9.06,10.91,12.91,13.53,12.72,12.12,9.41,8.12,6.78,5.16,4.25,3.16,1.31,-0.53,-2.16,-3.59,-4.78,-4.41,-4.28,-4.22,-3.03,-3.19,-3.5,-3.78,-5.22,-6.28,-6.12,-5.97,-4.72,-2.88,-1.75,0.66,1.12,2.81,2.19,3.41,4.31,5.59,7.34,9.91,10.62,12.31,12.62,12.81,12.5,12.09,12.41,10.5,8.91,6.94,4.62,3.41,2.84,3.53,4.81,8.75,13.62,17.59,19.62,19.66,17.5,12.88,8.16,4.53,2.06,1.31,2.5,5.91,8.5,10.91,13.06,13.44,13.12,10.66,7.94,4.88,3.56,1.34,0.88,0.28,0.03,0.44,-0.28,0.56,1.75,2.53,3.16,3.41,3.12,2.41,1.66,1.69,1.66,2.44,2.56,4.38,5.62,7.91,8.94,10.41,11.59,11.44,11.69,10.94,9.91,10.06,8.59,7.88,7.44,6.5,5.94,5.69,5.34,5.69,5.81,6.88,7.47,8.22,8.12,7.41,7.06,6.38,6.75,6.59,7.12,8.34,7.88,7.44,7.28,5.44,4.19,3.34,1.59,0.47,-0.09,0.25,1.56,3.06,5.62,6.41,7.38,8.34,7.69,6.06,4.91,3.41,2.56,1.88,3.22,5.47,8.34,10.34,12.19,12.41,12.28,11.12,9.19,7.34,5.78,4.66,3.06,2.53,3.44,3.59,4.84,6.59,8.31,9.81,10.16,10.94,10.94,10.56,11.06,10.75,11.25,10.59,10.03,7.78,5.5,2.84,0.56,-3.25,-5.94,-8.59,-11.0,-11.22,-11.16,-8.94,-6.59,-5.44,-3.62,-2.81,-2.84,-3.12,-2.31,-1.81,-1.22,1.22,2.19,3.88,5.62,6.0,5.22,4.75,3.56,3.09,3.06,2.78,2.94,3.53,4.16,4.5,3.69,3.81,3.19,2.25,1.25,0.88,0.12,-0.34,-0.03,0.78,2.19,4.03,4.53,5.19,5.69,5.16,4.88,5.06,5.53,5.84,6.19,7.91,8.41,8.97,10.09,9.69,9.28,9.53,8.12,7.09,5.5,4.28,3.94,5.03,6.34,7.25,8.62,8.56,8.03,6.66,5.16,3.81,2.5,1.12,1.19,-0.03,0.62,1.69,2.41,5.44,6.78,8.25,10.28,10.34,11.12,11.12,10.44,10.81,9.66,9.34,9.0,9.03,8.88,10.03,10.5,10.5,11.91,12.34,12.31,12.81,14.28,14.44,14.5,15.56,15.94,15.56,14.34,14.0,12.28,10.06,7.38,6.25,3.94,2.81,2.03,1.41,0.88,0.91,2.25,3.72,6.5,10.44,15.22,19.41,22.41,24.06,24.0,23.0,21.78,19.81,18.62,18.19,17.28,16.53,14.97,13.53,11.88,9.69,8.19,7.25,5.56,5.53,4.81,5.0,4.44,5.41,6.69,7.69,10.44,12.53,15.03,17.25,20.16,22.22,23.62,24.38,24.91,24.69,24.81,24.19,22.53,22.0,19.47,16.19,14.81,12.84,11.84,12.5,13.12,13.41,13.31,11.94,11.28,10.38,11.28,12.0,14.84,18.16,21.91,25.34,27.47,29.31,30.25,30.03,28.53,27.28,25.78,24.25,21.81,21.19,19.75,19.41,19.56,20.19,18.41,19.19,18.41,18.38,19.12,20.44,21.41,22.53,23.69,23.38,22.47,20.75,19.44,17.81,16.62,15.31,13.88,13.09,12.25,11.38,10.47,10.34,9.91,10.0,9.28,9.41,9.34,9.66,9.94,11.0,11.66,12.5,13.28,14.19,14.56,14.03,14.19,13.47,12.56,11.56,10.75,9.56,9.31,9.41,9.34,9.56,9.81,9.38,10.09,11.69,12.81,14.56,16.94,18.25,18.66,18.03,18.41,18.28,18.28,19.31,20.06,20.38,20.81,21.0,20.88,20.06,19.19,18.44,18.28,18.44,18.22,18.03,18.69,18.69,19.03,20.38,21.41,21.47,22.16,21.84,20.44,19.44,18.56,17.88,17.75,18.34,17.41,16.78,15.88,13.66,11.78,11.0,10.59,11.59,12.69,14.19,15.28,16.75,17.16,18.22,18.75,17.91,16.44,15.94,12.69,10.75,9.47,9.03,9.47,10.16,10.91,11.38,10.75,10.28,8.91,7.97,6.78,6.44,5.72,5.5,6.41,7.28,9.34,11.66,13.69,15.72,18.06,18.75,19.47,19.72,19.78,19.16,18.12,18.25,18.94,19.41,21.31,23.09,26.25,27.62,28.03,26.5,25.69,23.03,20.03,18.31,18.62,18.72,20.78,22.31,22.06,20.28,16.91,12.91,9.56,6.06,3.53,2.0,0.66,-0.03,-0.66,-1.56,-2.31,-2.66,-3.06,-4.16,-3.88,-2.41,-1.06,2.16,6.16,11.66,18.59,24.81,28.88,30.28,30.38,27.41,23.88,21.34,18.94,17.12,17.0,16.12,16.34,15.97,15.44,15.19,14.88,14.34,14.31,14.5,15.66,16.56,18.59,20.0,20.94,21.5,21.91,20.41,18.84,17.44,15.56,13.81,13.31,13.44,13.59,14.62,15.03,15.25,15.09,14.53,13.69,14.31,14.88,15.56,16.72,18.78,20.56,20.94,20.25,18.62,16.06,13.16,10.0,8.31,7.19,7.5,8.03,10.03,11.75,13.44,14.94,15.59,15.62,15.44,14.19,13.94,13.59,14.09,14.41,15.31,15.53,16.12,16.62,15.88,14.75,14.12,12.44,11.0,10.56,10.66,10.72,11.5,11.66,10.09,8.97,7.12,6.0,6.03,5.72,6.97,7.91,8.19,9.22,9.03,8.41,7.41,6.47,5.06,3.75,2.25,0.66,0.03,-0.47,0.03,0.5,1.59,2.47,3.31,3.88,2.91,1.66,1.0,-0.19,0.28,1.19,3.16,5.59,7.78,9.62,10.34,10.62,10.47,10.31,10.16,9.59,9.41,9.78,9.69,10.06,9.69,10.44,11.12,12.25,13.84,15.19,15.44,15.66,15.59,15.06,15.34,15.78,17.06,18.31,18.56,18.31,17.31,16.09,15.25,15.62,15.72,16.75,16.91,15.44,14.78,13.06,11.31,9.44,7.53,6.94,6.62,6.53,7.66,10.84,13.66,16.62,18.91,20.62,19.91,19.06,17.41,14.81,13.47,12.09,10.94,9.38,6.75,6.53,5.25,5.38,6.03,6.78,6.88,7.69,7.47,8.06,8.47,8.5,9.0,9.91,10.81,11.25,11.28,11.28,9.44,8.25,6.56,4.59,4.41,4.5,3.44,4.53,3.78,4.12,3.81,4.25,5.38,5.81,6.25,6.16,5.41,4.59,3.66,4.75,6.28,7.88,10.03,10.91,12.12,12.88,12.91,12.91,13.41,13.91,13.88,15.03,15.41,16.25,16.66,16.78,18.06,17.59,17.97,18.41,18.28,18.16,17.44,16.69,16.31,16.06,17.84,19.91,23.78,25.75,27.44,27.53,25.5,23.94,21.56,21.31,21.41,22.38,22.88,23.25,23.31,23.88,24.09,23.78,23.34,24.16,23.25,23.66,24.19,24.88,25.31,26.41,25.34,25.06,23.78,22.03,20.5,20.41,19.31,19.25,20.75,21.69,23.0,24.5,25.41,26.56,27.97,28.5,29.66,29.72,3.09,1.66,-0.66,-2.03,-2.12,-1.84,-0.28,1.0,2.5,2.0,1.78,0.81:16.0,17.06,17.72,19.19,20.19,19.88,19.0,17.53,15.28,13.06,12.19,11.94,12.56,14.16,15.12,15.59,15.41,13.75,12.62,11.28,11.25,11.34,12.5,12.72,13.75,13.06,11.78,9.16,6.97,5.91,5.03,5.19,5.25,6.88,8.19,7.91,8.41,7.16,5.38,3.97,2.66,2.25,1.97,2.78,4.34,5.56,7.19,9.06,10.91,12.91,13.53,12.72,12.12,9.41,8.12,6.78,5.16,4.25,3.16,1.31,-0.53,-2.16,-3.59,-4.78,-4.41,-4.28,-4.22,-3.03,-3.19,-3.5,-3.78,-5.22,-6.28,-6.12,-5.97,-4.72,-2.88,-1.75,0.66,1.12,2.81,2.19,3.41,4.31,5.59,7.34,9.91,10.62,12.31,12.62,12.81,12.5,12.09,12.41,10.5,8.91,6.94,4.62,3.41,2.84,3.53,4.81,8.75,13.62,17.59,19.62,19.66,17.5,12.88,8.16,4.53,2.06,1.31,2.5,5.91,8.5,10.91,13.06,13.44,13.12,10.66,7.94,4.88,3.56,1.34,0.88,0.28,0.03,0.44,-0.28,0.56,1.75,2.53,3.16,3.41,3.12,2.41,1.66,1.69,1.66,2.44,2.56,4.38,5.62,7.91,8.94,10.41,11.59,11.44,11.69,10.94,9.91,10.06,8.59,7.88,7.44,6.5,5.94,5.69,5.34,5.69,5.81,6.88,7.47,8.22,8.12,7.41,7.06,6.38,6.75,6.59,7.12,8.34,7.88,7.44,7.28,5.44,4.19,3.34,1.59,0.47,-0.09,0.25,1.56,3.06,5.62,6.41,7.38,8.34,7.69,6.06,4.91,3.41,2.56,1.88,3.22,5.47,8.34,10.34,12.19,12.41,12.28,11.12,9.19,7.34,5.78,4.66,3.06,2.53,3.44,3.59,4.84,6.59,8.31,9.81,10.16,10.94,10.94,10.56,11.06,10.75,11.25,10.59,10.03,7.78,5.5,2.84,0.56,-3.25,-5.94,-8.59,-11.0,-11.22,-11.16,-8.94,-6.59,-5.44,-3.62,-2.81,-2.84,-3.12,-2.31,-1.81,-1.22,1.22,2.19,3.88,5.62,6.0,5.22,4.75,3.56,3.09,3.06,2.78,2.94,3.53,4.16,4.5,3.69,3.81,3.19,2.25,1.25,0.88,0.12,-0.34,-0.03,0.78,2.19,4.03,4.53,5.19,5.69,5.16,4.88,5.06,5.53,5.84,6.19,7.91,8.41,8.97,10.09,9.69,9.28,9.53,8.12,7.09,5.5,4.28,3.94,5.03,6.34,7.25,8.62,8.56,8.03,6.66,5.16,3.81,2.5,1.12,1.19,-0.03,0.62,1.69,2.41,5.44,6.78,8.25,10.28,10.34,11.12,11.12,10.44,10.81,9.66,9.34,9.0,9.03,8.88,10.03,10.5,10.5,11.91,12.34,12.31,12.81,14.28,14.44,14.5,15.56,15.94,15.56,14.34,14.0,12.28,10.06,7.38,6.25,3.94,2.81,2.03,1.41,0.88,0.91,2.25,3.72,6.5,10.44,15.22,19.41,22.41,24.06,24.0,23.0,21.78,19.81,18.62,18.19,17.28,16.53,14.97,13.53,11.88,9.69,8.19,7.25,5.56,5.53,4.81,5.0,4.44,5.41,6.69,7.69,10.44,12.53,15.03,17.25,20.16,22.22,23.62,24.38,24.91,24.69,24.81,24.19,22.53,22.0,19.47,16.19,14.81,12.84,11.84,12.5,13.12,13.41,13.31,11.94,11.28,10.38,11.28,12.0,14.84,18.16,21.91,25.34,27.47,29.31,30.25,30.03,28.53,27.28,25.78,24.25,21.81,21.19,19.75,19.41,19.56,20.19,18.41,19.19,18.41,18.38,19.12,20.44,21.41,22.53,23.69,23.38,22.47,20.75,19.44,17.81,16.62,15.31,13.88,13.09,12.25,11.38,10.47,10.34,9.91,10.0,9.28,9.41,9.34,9.66,9.94,11.0,11.66,12.5,13.28,14.19,14.56,14.03,14.19,13.47,12.56,11.56,10.75,9.56,9.31,9.41,9.34,9.56,9.81,9.38,10.09,11.69,12.81,14.56,16.94,18.25,18.66,18.03,18.41,18.28,18.28,19.31,20.06,20.38,20.81,21.0,20.88,20.06,19.19,18.44,18.28,18.44,18.22,18.03,18.69,18.69,19.03,20.38,21.41,21.47,22.16,21.84,20.44,19.44,18.56,17.88,17.75,18.34,17.41,16.78,15.88,13.66,11.78,11.0,10.59,11.59,12.69,14.19,15.28,16.75,17.16,18.22,18.75,17.91,16.44,15.94,12.69,10.75,9.47,9.03,9.47,10.16,10.91,11.38,10.75,10.28,8.91,7.97,6.78,6.44,5.72,5.5,6.41,7.28,9.34,11.66,13.69,15.72,18.06,18.75,19.47,19.72,19.78,19.16,18.12,18.25,18.94,19.41,21.31,23.09,26.25,27.62,28.03,26.5,25.69,23.03,20.03,18.31,18.62,18.72,20.78,22.31,22.06,20.28,16.91,12.91,9.56,6.06,3.53,2.0,0.66,-0.03,-0.66,-1.56,-2.31,-2.66,-3.06,-4.16,-3.88,-2.41,-1.06,2.16,6.16,11.66,18.59,24.81,28.88,30.28,30.38,27.41,23.88,21.34,18.94,17.12,17.0,16.12,16.34,15.97,15.44,15.19,14.88,14.34,14.31,14.5,15.66,16.56,18.59,20.0,20.94,21.5,21.91,20.41,18.84,17.44,15.56,13.81,13.31,13.44,13.59,14.62,15.03,15.25,15.09,14.53,13.69,14.31,14.88,15.56,16.72,18.78,20.56,20.94,20.25,18.62,16.06,13.16,10.0,8.31,7.19,7.5,8.03,10.03,11.75,13.44,14.94,15.59,15.62,15.44,14.19,13.94,13.59,14.09,14.41,15.31,15.53,16.12,16.62,15.88,14.75,14.12,12.44,11.0,10.56,10.66,10.72,11.5,11.66,10.09,8.97,7.12,6.0,6.03,5.72,6.97,7.91,8.19,9.22,9.03,8.41,7.41,6.47,5.06,3.75,2.25,0.66,0.03,-0.47,0.03,0.5,1.59,2.47,3.31,3.88,2.91,1.66,1.0,-0.19,0.28,1.19,3.16,5.59,7.78,9.62,10.34,10.62,10.47,10.31,10.16,9.59,9.41,9.78,9.69,10.06,9.69,10.44,11.12,12.25,13.84,15.19,15.44,15.66,15.59,15.06,15.34,15.78,17.06,18.31,18.56,18.31,17.31,16.09,15.25,15.62,15.72,16.75,16.91,15.44,14.78,13.06,11.31,9.44,7.53,6.94,6.62,6.53,7.66,10.84,13.66,16.62,18.91,20.62,19.91,19.06,17.41,14.81,13.47,12.09,10.94,9.38,6.75,6.53,5.25,5.38,6.03,6.78,6.88,7.69,7.47,8.06,8.47,8.5,9.0,9.91,10.81,11.25,11.28,11.28,9.44,8.25,6.56,4.59,4.41,4.5,3.44,4.53,3.78,4.12,3.81,4.25,5.38,5.81,6.25,6.16,5.41,4.59,3.66,4.75,6.28,7.88,10.03,10.91,12.12,12.88,12.91,12.91,13.41,13.91,13.88,15.03,15.41,16.25,16.66,16.78,18.06,17.59,17.97,18.41,18.28,18.16,17.44,16.69,16.31,16.06,17.84,19.91,23.78,25.75,27.44,27.53,25.5,23.94,21.56,21.31,21.41,22.38,22.88,23.25,23.31,23.88,24.09,23.78,23.34,24.16,23.25,23.66,24.19,24.88,25.31,26.41,25.34,25.06,23.78,22.03,20.5,20.41,19.31,19.25,20.75,21.69,23.0,24.5,25.41,26.56,27.97,28.5,29.66,29.72,3.09,1.66,-0.66,-2.03,-2.12,-1.84,-0.28,1.0,2.5,2.0,1.78,0.81,-0.94,-1.91,-2.41,-1.94,-1.59,-1.19:19.0,17.53,15.28,13.06,12.19,11.94,12.56,14.16,15.12,15.59,15.41,13.75,12.62,11.28,11.25,11.34,12.5,12.72,13.75,13.06,11.78,9.16,6.97,5.91,5.03,5.19,5.25,6.88,8.19,7.91,8.41,7.16,5.38,3.97,2.66,2.25,1.97,2.78,4.34,5.56,7.19,9.06,10.91,12.91,13.53,12.72,12.12,9.41,8.12,6.78,5.16,4.25,3.16,1.31,-0.53,-2.16,-3.59,-4.78,-4.41,-4.28,-4.22,-3.03,-3.19,-3.5,-3.78,-5.22,-6.28,-6.12,-5.97,-4.72,-2.88,-1.75,0.66,1.12,2.81,2.19,3.41,4.31,5.59,7.34,9.91,10.62,12.31,12.62,12.81,12.5,12.09,12.41,10.5,8.91,6.94,4.62,3.41,2.84,3.53,4.81,8.75,13.62,17.59,19.62,19.66,17.5,12.88,8.16,4.53,2.06,1.31,2.5,5.91,8.5,10.91,13.06,13.44,13.12,10.66,7.94,4.88,3.56,1.34,0.88,0.28,0.03,0.44,-0.28,0.56,1.75,2.53,3.16,3.41,3.12,2.41,1.66,1.69,1.66,2.44,2.56,4.38,5.62,7.91,8.94,10.41,11.59,11.44,11.69,10.94,9.91,10.06,8.59,7.88,7.44,6.5,5.94,5.69,5.34,5.69,5.81,6.88,7.47,8.22,8.12,7.41,7.06,6.38,6.75,6.59,7.12,8.34,7.88,7.44,7.28,5.44,4.19,3.34,1.59,0.47,-0.09,0.25,1.56,3.06,5.62,6.41,7.38,8.34,7.69,6.06,4.91,3.41,2.56,1.88,3.22,5.47,8.34,10.34,12.19,12.41,12.28,11.12,9.19,7.34,5.78,4.66,3.06,2.53,3.44,3.59,4.84,6.59,8.31,9.81,10.16,10.94,10.94,10.56,11.06,10.75,11.25,10.59,10.03,7.78,5.5,2.84,0.56,-3.25,-5.94,-8.59,-11.0,-11.22,-11.16,-8.94,-6.59,-5.44,-3.62,-2.81,-2.84,-3.12,-2.31,-1.81,-1.22,1.22,2.19,3.88,5.62,6.0,5.22,4.75,3.56,3.09,3.06,2.78,2.94,3.53,4.16,4.5,3.69,3.81,3.19,2.25,1.25,0.88,0.12,-0.34,-0.03,0.78,2.19,4.03,4.53,5.19,5.69,5.16,4.88,5.06,5.53,5.84,6.19,7.91,8.41,8.97,10.09,9.69,9.28,9.53,8.12,7.09,5.5,4.28,3.94,5.03,6.34,7.25,8.62,8.56,8.03,6.66,5.16,3.81,2.5,1.12,1.19,-0.03,0.62,1.69,2.41,5.44,6.78,8.25,10.28,10.34,11.12,11.12,10.44,10.81,9.66,9.34,9.0,9.03,8.88,10.03,10.5,10.5,11.91,12.34,12.31,12.81,14.28,14.44,14.5,15.56,15.94,15.56,14.34,14.0,12.28,10.06,7.38,6.25,3.94,2.81,2.03,1.41,0.88,0.91,2.25,3.72,6.5,10.44,15.22,19.41,22.41,24.06,24.0,23.0,21.78,19.81,18.62,18.19,17.28,16.53,14.97,13.53,11.88,9.69,8.19,7.25,5.56,5.53,4.81,5.0,4.44,5.41,6.69,7.69,10.44,12.53,15.03,17.25,20.16,22.22,23.62,24.38,24.91,24.69,24.81,24.19,22.53,22.0,19.47,16.19,14.81,12.84,11.84,12.5,13.12,13.41,13.31,11.94,11.28,10.38,11.28,12.0,14.84,18.16,21.91,25.34,27.47,29.31,30.25,30.03,28.53,27.28,25.78,24.25,21.81,21.19,19.75,19.41,19.56,20.19,18.41,19.19,18.41,18.38,19.12,20.44,21.41,22.53,23.69,23.38,22.47,20.75,19.44,17.81,16.62,15.31,13.88,13.09,12.25,11.38,10.47,10.34,9.91,10.0,9.28,9.41,9.34,9.66,9.94,11.0,11.66,12.5,13.28,14.19,14.56,14.03,14.19,13.47,12.56,11.56,10.75,9.56,9.31,9.41,9.34,9.56,9.81,9.38,10.09,11.69,12.81,14.56,16.94,18.25,18.66,18.03,18.41,18.28,18.28,19.31,20.06,20.38,20.81,21.0,20.88,20.06,19.19,18.44,18.28,18.44,18.22,18.03,18.69,18.69,19.03,20.38,21.41,21.47,22.16,21.84,20.44,19.44,18.56,17.88,17.75,18.34,17.41,16.78,15.88,13.66,11.78,11.0,10.59,11.59,12.69,14.19,15.28,16.75,17.16,18.22,18.75,17.91,16.44,15.94,12.69,10.75,9.47,9.03,9.47,10.16,10.91,11.38,10.75,10.28,8.91,7.97,6.78,6.44,5.72,5.5,6.41,7.28,9.34,11.66,13.69,15.72,18.06,18.75,19.47,19.72,19.78,19.16,18.12,18.25,18.94,19.41,21.31,23.09,26.25,27.62,28.03,26.5,25.69,23.03,20.03,18.31,18.62,18.72,20.78,22.31,22.06,20.28,16.91,12.91,9.56,6.06,3.53,2.0,0.66,-0.03,-0.66,-1.56,-2.31,-2.66,-3.06,-4.16,-3.88,-2.41,-1.06,2.16,6.16,11.66,18.59,24.81,28.88,30.28,30.38,27.41,23.88,21.34,18.94,17.12,17.0,16.12,16.34,15.97,15.44,15.19,14.88,14.34,14.31,14.5,15.66,16.56,18.59,20.0,20.94,21.5,21.91,20.41,18.84,17.44,15.56,13.81,13.31,13.44,13.59,14.62,15.03,15.25,15.09,14.53,13.69,14.31,14.88,15.56,16.72,18.78,20.56,20.94,20.25,18.62,16.06,13.16,10.0,8.31,7.19,7.5,8.03,10.03,11.75,13.44,14.94,15.59,15.62,15.44,14.19,13.94,13.59,14.09,14.41,15.31,15.53,16.12,16.62,15.88,14.75,14.12,12.44,11.0,10.56,10.66,10.72,11.5,11.66,10.09,8.97,7.12,6.0,6.03,5.72,6.97,7.91,8.19,9.22,9.03,8.41,7.41,6.47,5.06,3.75,2.25,0.66,0.03,-0.47,0.03,0.5,1.59,2.47,3.31,3.88,2.91,1.66,1.0,-0.19,0.28,1.19,3.16,5.59,7.78,9.62,10.34,10.62,10.47,10.31,10.16,9.59,9.41,9.78,9.69,10.06,9.69,10.44,11.12,12.25,13.84,15.19,15.44,15.66,15.59,15.06,15.34,15.78,17.06,18.31,18.56,18.31,17.31,16.09,15.25,15.62,15.72,16.75,16.91,15.44,14.78,13.06,11.31,9.44,7.53,6.94,6.62,6.53,7.66,10.84,13.66,16.62,18.91,20.62,19.91,19.06,17.41,14.81,13.47,12.09,10.94,9.38,6.75,6.53,5.25,5.38,6.03,6.78,6.88,7.69,7.47,8.06,8.47,8.5,9.0,9.91,10.81,11.25,11.28,11.28,9.44,8.25,6.56,4.59,4.41,4.5,3.44,4.53,3.78,4.12,3.81,4.25,5.38,5.81,6.25,6.16,5.41,4.59,3.66,4.75,6.28,7.88,10.03,10.91,12.12,12.88,12.91,12.91,13.41,13.91,13.88,15.03,15.41,16.25,16.66,16.78,18.06,17.59,17.97,18.41,18.28,18.16,17.44,16.69,16.31,16.06,17.84,19.91,23.78,25.75,27.44,27.53,25.5,23.94,21.56,21.31,21.41,22.38,22.88,23.25,23.31,23.88,24.09,23.78,23.34,24.16,23.25,23.66,24.19,24.88,25.31,26.41,25.34,25.06,23.78,22.03,20.5,20.41,19.31,19.25,20.75,21.69,23.0,24.5,25.41,26.56,27.97,28.5,29.66,29.72,3.09,1.66,-0.66,-2.03,-2.12,-1.84,-0.28,1.0,2.5,2.0,1.78,0.81,-0.94,-1.91,-2.41,-1.94,-1.59,-1.19,-0.09,1.34,2.84,4.22,4.84,5.59:12.56,14.16,15.12,15.59,15.41,13.75,12.62,11.28,11.25,11.34,12.5,12.72,13.75,13.06,11.78,9.16,6.97,5.91,5.03,5.19,5.25,6.88,8.19,7.91,8.41,7.16,5.38,3.97,2.66,2.25,1.97,2.78,4.34,5.56,7.19,9.06,10.91,12.91,13.53,12.72,12.12,9.41,8.12,6.78,5.16,4.25,3.16,1.31,-0.53,-2.16,-3.59,-4.78,-4.41,-4.28,-4.22,-3.03,-3.19,-3.5,-3.78,-5.22,-6.28,-6.12,-5.97,-4.72,-2.88,-1.75,0.66,1.12,2.81,2.19,3.41,4.31,5.59,7.34,9.91,10.62,12.31,12.62,12.81,12.5,12.09,12.41,10.5,8.91,6.94,4.62,3.41,2.84,3.53,4.81,8.75,13.62,17.59,19.62,19.66,17.5,12.88,8.16,4.53,2.06,1.31,2.5,5.91,8.5,10.91,13.06,13.44,13.12,10.66,7.94,4.88,3.56,1.34,0.88,0.28,0.03,0.44,-0.28,0.56,1.75,2.53,3.16,3.41,3.12,2.41,1.66,1.69,1.66,2.44,2.56,4.38,5.62,7.91,8.94,10.41,11.59,11.44,11.69,10.94,9.91,10.06,8.59,7.88,7.44,6.5,5.94,5.69,5.34,5.69,5.81,6.88,7.47,8.22,8.12,7.41,7.06,6.38,6.75,6.59,7.12,8.34,7.88,7.44,7.28,5.44,4.19,3.34,1.59,0.47,-0.09,0.25,1.56,3.06,5.62,6.41,7.38,8.34,7.69,6.06,4.91,3.41,2.56,1.88,3.22,5.47,8.34,10.34,12.19,12.41,12.28,11.12,9.19,7.34,5.78,4.66,3.06,2.53,3.44,3.59,4.84,6.59,8.31,9.81,10.16,10.94,10.94,10.56,11.06,10.75,11.25,10.59,10.03,7.78,5.5,2.84,0.56,-3.25,-5.94,-8.59,-11.0,-11.22,-11.16,-8.94,-6.59,-5.44,-3.62,-2.81,-2.84,-3.12,-2.31,-1.81,-1.22,1.22,2.19,3.88,5.62,6.0,5.22,4.75,3.56,3.09,3.06,2.78,2.94,3.53,4.16,4.5,3.69,3.81,3.19,2.25,1.25,0.88,0.12,-0.34,-0.03,0.78,2.19,4.03,4.53,5.19,5.69,5.16,4.88,5.06,5.53,5.84,6.19,7.91,8.41,8.97,10.09,9.69,9.28,9.53,8.12,7.09,5.5,4.28,3.94,5.03,6.34,7.25,8.62,8.56,8.03,6.66,5.16,3.81,2.5,1.12,1.19,-0.03,0.62,1.69,2.41,5.44,6.78,8.25,10.28,10.34,11.12,11.12,10.44,10.81,9.66,9.34,9.0,9.03,8.88,10.03,10.5,10.5,11.91,12.34,12.31,12.81,14.28,14.44,14.5,15.56,15.94,15.56,14.34,14.0,12.28,10.06,7.38,6.25,3.94,2.81,2.03,1.41,0.88,0.91,2.25,3.72,6.5,10.44,15.22,19.41,22.41,24.06,24.0,23.0,21.78,19.81,18.62,18.19,17.28,16.53,14.97,13.53,11.88,9.69,8.19,7.25,5.56,5.53,4.81,5.0,4.44,5.41,6.69,7.69,10.44,12.53,15.03,17.25,20.16,22.22,23.62,24.38,24.91,24.69,24.81,24.19,22.53,22.0,19.47,16.19,14.81,12.84,11.84,12.5,13.12,13.41,13.31,11.94,11.28,10.38,11.28,12.0,14.84,18.16,21.91,25.34,27.47,29.31,30.25,30.03,28.53,27.28,25.78,24.25,21.81,21.19,19.75,19.41,19.56,20.19,18.41,19.19,18.41,18.38,19.12,20.44,21.41,22.53,23.69,23.38,22.47,20.75,19.44,17.81,16.62,15.31,13.88,13.09,12.25,11.38,10.47,10.34,9.91,10.0,9.28,9.41,9.34,9.66,9.94,11.0,11.66,12.5,13.28,14.19,14.56,14.03,14.19,13.47,12.56,11.56,10.75,9.56,9.31,9.41,9.34,9.56,9.81,9.38,10.09,11.69,12.81,14.56,16.94,18.25,18.66,18.03,18.41,18.28,18.28,19.31,20.06,20.38,20.81,21.0,20.88,20.06,19.19,18.44,18.28,18.44,18.22,18.03,18.69,18.69,19.03,20.38,21.41,21.47,22.16,21.84,20.44,19.44,18.56,17.88,17.75,18.34,17.41,16.78,15.88,13.66,11.78,11.0,10.59,11.59,12.69,14.19,15.28,16.75,17.16,18.22,18.75,17.91,16.44,15.94,12.69,10.75,9.47,9.03,9.47,10.16,10.91,11.38,10.75,10.28,8.91,7.97,6.78,6.44,5.72,5.5,6.41,7.28,9.34,11.66,13.69,15.72,18.06,18.75,19.47,19.72,19.78,19.16,18.12,18.25,18.94,19.41,21.31,23.09,26.25,27.62,28.03,26.5,25.69,23.03,20.03,18.31,18.62,18.72,20.78,22.31,22.06,20.28,16.91,12.91,9.56,6.06,3.53,2.0,0.66,-0.03,-0.66,-1.56,-2.31,-2.66,-3.06,-4.16,-3.88,-2.41,-1.06,2.16,6.16,11.66,18.59,24.81,28.88,30.28,30.38,27.41,23.88,21.34,18.94,17.12,17.0,16.12,16.34,15.97,15.44,15.19,14.88,14.34,14.31,14.5,15.66,16.56,18.59,20.0,20.94,21.5,21.91,20.41,18.84,17.44,15.56,13.81,13.31,13.44,13.59,14.62,15.03,15.25,15.09,14.53,13.69,14.31,14.88,15.56,16.72,18.78,20.56,20.94,20.25,18.62,16.06,13.16,10.0,8.31,7.19,7.5,8.03,10.03,11.75,13.44,14.94,15.59,15.62,15.44,14.19,13.94,13.59,14.09,14.41,15.31,15.53,16.12,16.62,15.88,14.75,14.12,12.44,11.0,10.56,10.66,10.72,11.5,11.66,10.09,8.97,7.12,6.0,6.03,5.72,6.97,7.91,8.19,9.22,9.03,8.41,7.41,6.47,5.06,3.75,2.25,0.66,0.03,-0.47,0.03,0.5,1.59,2.47,3.31,3.88,2.91,1.66,1.0,-0.19,0.28,1.19,3.16,5.59,7.78,9.62,10.34,10.62,10.47,10.31,10.16,9.59,9.41,9.78,9.69,10.06,9.69,10.44,11.12,12.25,13.84,15.19,15.44,15.66,15.59,15.06,15.34,15.78,17.06,18.31,18.56,18.31,17.31,16.09,15.25,15.62,15.72,16.75,16.91,15.44,14.78,13.06,11.31,9.44,7.53,6.94,6.62,6.53,7.66,10.84,13.66,16.62,18.91,20.62,19.91,19.06,17.41,14.81,13.47,12.09,10.94,9.38,6.75,6.53,5.25,5.38,6.03,6.78,6.88,7.69,7.47,8.06,8.47,8.5,9.0,9.91,10.81,11.25,11.28,11.28,9.44,8.25,6.56,4.59,4.41,4.5,3.44,4.53,3.78,4.12,3.81,4.25,5.38,5.81,6.25,6.16,5.41,4.59,3.66,4.75,6.28,7.88,10.03,10.91,12.12,12.88,12.91,12.91,13.41,13.91,13.88,15.03,15.41,16.25,16.66,16.78,18.06,17.59,17.97,18.41,18.28,18.16,17.44,16.69,16.31,16.06,17.84,19.91,23.78,25.75,27.44,27.53,25.5,23.94,21.56,21.31,21.41,22.38,22.88,23.25,23.31,23.88,24.09,23.78,23.34,24.16,23.25,23.66,24.19,24.88,25.31,26.41,25.34,25.06,23.78,22.03,20.5,20.41,19.31,19.25,20.75,21.69,23.0,24.5,25.41,26.56,27.97,28.5,29.66,29.72,3.09,1.66,-0.66,-2.03,-2.12,-1.84,-0.28,1.0,2.5,2.0,1.78,0.81,-0.94,-1.91,-2.41,-1.94,-1.59,-1.19,-0.09,1.34,2.84,4.22,4.84,5.59,5.09,3.66,1.91,-0.97,-2.31,-3.16:positivity
70.94,68.16,65.09,61.25,60.91,61.25,63.53,64.78,67.5,69.53,69.44,69.47,68.5,67.06,64.09,62.5,60.09,58.44,57.06,56.94,55.16,55.62,55.94,55.97,56.28,58.38,58.84,59.22,61.03,62.78,63.81,66.47,66.44,67.06,65.69,63.34,63.75,61.34,62.72,61.88,64.0,64.16,65.28,66.44,65.03,66.16,64.88,66.12,68.56,70.91,73.0,75.25,74.22,75.72,74.5,73.66,71.31,70.06,69.78,70.12,70.56,71.91,72.31,70.16,69.03,67.94,65.25,64.16,62.84,60.81,58.06,57.81,57.25,57.31,57.97,58.94,58.66,60.44,60.62,61.44,60.69,60.06,59.5,58.25,56.75,55.56,55.53,55.19,53.72,57.09,56.19,59.22,60.06,62.78,64.16,64.88,64.91,64.69,68.09,65.81,66.06,68.81,67.38,66.59,65.66,65.19,64.12,62.12,60.97,60.06,57.69,55.75,55.03,52.41,53.06,54.06,56.03,57.62,59.78,61.47,61.28,60.28,58.0,56.16,55.88,54.28,55.66,57.16,56.84,56.09,54.97,53.22,52.56,53.97,56.47,55.66,58.5,58.66,58.28,58.12,60.88,61.19,61.41,64.16,64.25,65.03,67.25,68.03,69.62,72.0,72.09,72.12,71.31,71.75,69.78,68.28,67.06,67.53,65.69,65.72,65.53,65.22,64.41,63.56,64.19,64.38,64.91,65.53,64.44,64.28,64.38,62.5,63.94,64.69,65.91,65.69,65.28,64.78,63.03,61.94,60.44,59.78,59.62,58.06,57.56,57.56,56.91,56.28,57.28,57.28,56.94,58.75,59.0,59.0,59.56,61.88,63.19,64.5,67.25,66.38,65.69,64.31,62.31,58.97,57.16,56.72,55.22,55.84,56.81,59.28,61.47,65.25,67.94,74.22,74.75,79.06,80.5,80.19,79.28,78.06,77.28,75.31,75.06,74.12,74.0,69.97,69.81,65.38,63.38,61.84,60.88,60.44,60.66,60.91,61.19,62.22,63.06,65.25,66.44,68.59,70.44,70.19,70.66,70.09,68.81,69.66,70.0,68.81,70.75,71.25,72.12,73.06,73.41,72.0,70.03,68.03,65.88,65.25,64.38,66.25,66.72,66.62,67.91,69.22,69.72,69.91,70.38,70.59,71.53,69.5,69.5,67.75,66.31,66.25,66.25,67.41,66.5,68.75,67.44,67.12,67.75,66.91,66.69,67.31,66.72,68.81,68.47,69.56,69.0,68.12,68.0,66.88,65.53,63.53,58.66,56.03,52.06,50.31,50.72,51.94,54.53,56.84,57.06,58.56,58.56,57.84,58.69,58.62,57.5,57.91,57.88,57.88,58.84,60.44,59.41,61.5,60.94,60.09,60.62,59.97,60.84,60.47,59.31,59.38,58.56,56.25,54.53,53.69,53.25,53.91,55.41,56.44,57.62,58.38,59.44,60.31,61.5,62.16,62.09,61.31,58.81,57.69,54.41,53.38,53.19,53.41,53.72,56.19,56.03,58.75,58.28,58.62,56.69,54.81,52.59,49.69,48.56,50.41,49.53,50.97,53.84,54.0,56.41,56.53,58.72,58.91,59.84,58.34,57.91,54.56,54.28,53.91,54.16,56.75,57.69,59.97,61.69,61.28,61.88,60.5,61.12,59.53,61.38,62.94,65.12,64.59,67.75,67.66,66.06,66.66,66.41,64.94,65.06,64.41,64.5,62.72,62.06,61.12,59.19,58.25,57.5,56.78,57.44,57.41,57.19,57.31,58.06,59.62,59.91,62.25,62.81,64.59,63.56,62.38,58.69,55.19,53.5,51.31,49.25,49.94,49.53,49.47,48.16,49.81,50.12,52.53,54.31,54.59,57.97,56.75,57.06,57.72,60.16,62.66,66.16,70.28,73.0,74.28,72.12,69.53,64.94,59.16,54.22,51.53,49.53,50.16,51.62,51.78,56.25,57.0,57.78,59.91,60.25,60.19,61.44,61.59,64.12,64.38,66.31,65.31,64.56,62.12,59.25,56.0,54.84,52.66,52.16,52.16,50.16,50.53,50.22,49.62,49.12,47.84,48.84,48.69,48.81,49.97,52.47,53.06,54.06,55.31,55.56,53.12,51.62,50.19,49.44,49.0,52.34,54.41,56.88,58.38,58.19,59.41,58.09,56.75,57.53,56.25,58.09,56.94,57.0,57.25,58.34,58.84,60.19,62.91,60.56,61.0,60.66,58.28,57.19,56.38,55.62,55.06,54.34,54.69,52.03,52.16,49.72,48.31,46.94,46.34,46.38,46.09,45.78,47.16,46.06,45.69,47.38,46.78,45.31,45.44,45.62,44.19,43.5,44.69,44.72,45.09,47.19,46.34,47.44,47.06,45.91,44.0,42.69,40.28,39.78,39.44,38.69,40.06,41.28,42.28,43.19,44.44,45.78,45.28,44.28,46.59,45.03,47.06,48.81,49.88,49.81,49.34,47.59,46.84,45.91,46.16,47.0,47.38,47.16,47.25,46.56,45.62,44.81,44.88,45.81,45.0,45.38,45.41,45.25,45.09,45.66,45.38,45.5,47.12,46.62,47.72,48.62,47.78,46.53,44.75,42.41,40.5,40.06,41.16,42.0,44.12,45.75,44.88,43.41,42.5,40.62,38.44,37.28,37.41,36.28,36.5,36.41,37.25,38.41,40.28,40.62,42.25,43.81,45.16,46.81,47.06,46.69,46.5,46.69,45.41,45.53,45.91,45.91,45.12,45.97,44.66,45.91,46.69,47.56,47.53,49.28,49.41,47.62,46.38,44.81,42.91,42.56,41.97,41.19,41.12,39.91,39.19,38.28,39.53,41.31,43.31,43.97,47.5,50.22,51.78,53.53,54.66,53.81,53.16,53.38,54.12,57.03,60.44,62.31,63.03,63.31,61.72,59.88,57.84,57.88,57.12,56.56,56.66,58.16,57.66,58.41,57.47,57.44,55.5,53.31,50.94,48.94,46.75,45.94,44.78,44.91,44.62,43.62,43.03,42.28,42.44,43.31,44.31,45.84,46.97,48.34,49.56,51.0,51.97,51.56,51.53,50.34,48.94,48.72,49.47,50.19,51.47,53.69,54.03,55.94,56.44,56.56,56.81,57.34,57.66,57.03,59.31,59.19,58.94,58.62,57.12,55.81,53.72,52.25,50.19,49.91,49.44,48.31,47.84,49.06,49.16,48.56,49.47,50.31,50.78,50.34,50.41,49.59,46.97,47.06,46.72,46.91,49.06,51.41,53.31,54.06,55.0,54.5,54.34,54.03,52.69,52.94,52.31,50.78,50.31,48.5,47.31,46.34,45.66,45.28,45.12,45.84,46.88,48.12,49.28,51.75,53.06,54.5,55.16,54.75,54.34,52.94,51.06,48.53,46.97,44.91,42.06,39.88,38.53,36.22,34.38,33.53,32.81,32.91,32.62,33.03,35.84,38.97,41.66,44.44,48.94,49.69,51.0,50.19,49.75,47.12,47.19,44.62,43.66,42.88,40.69,38.78,38.09,36.53,34.41,34.31,34.25,35.31,36.12,38.84,41.62,44.12,47.53,49.91,52.41,54.16,53.38,52.94,49.06,45.72,42.12,38.75,36.69,36.22,35.62,35.94,34.91,33.91,33.25,32.5,31.72,31.62,32.66,33.16,33.5,34.47,34.19,35.75,36.0,34.75,35.53,34.09,32.25,28.56,27.53,24.25,22.03,19.53,18.06,15.56,13.19,9.34,8.19,5.53,3.62,3.69,3.62,3.97,3.56,4.25,4.75,4.94,4.41,4.41,3.91,2.94,1.81,1.28,-0.22,-1.53,-3.72,-5.53,-7.09,-8.81,-8.78,-9.78,-9.28,-8.88,-8.09,-7.38,-6.97,-6.12,-7.22,-8.84,-8.38,-8.19,-8.53,-6.47,-6.81,-6.84,-7.41,-9.72,-11.41,-14.06,-14.84,-15.09,-14.28,-12.03,-10.34:63.53,64.78,67.5,69.53,69.44,69.47,68.5,67.06,64.09,62.5,60.09,58.44,57.06,56.94,55.16,55.62,55.94,55.97,56.28,58.38,58.84,59.22,61.03,62.78,63.81,66.47,66.44,67.06,65.69,63.34,63.75,61.34,62.72,61.88,64.0,64.16,65.28,66.44,65.03,66.16,64.88,66.12,68.56,70.91,73.0,75.25,74.22,75.72,74.5,73.66,71.31,70.06,69.78,70.12,70.56,71.91,72.31,70.16,69.03,67.94,65.25,64.16,62.84,60.81,58.06,57.81,57.25,57.31,57.97,58.94,58.66,60.44,60.62,61.44,60.69,60.06,59.5,58.25,56.75,55.56,55.53,55.19,53.72,57.09,56.19,59.22,60.06,62.78,64.16,64.88,64.91,64.69,68.09,65.81,66.06,68.81,67.38,66.59,65.66,65.19,64.12,62.12,60.97,60.06,57.69,55.75,55.03,52.41,53.06,54.06,56.03,57.62,59.78,61.47,61.28,60.28,58.0,56.16,55.88,54.28,55.66,57.16,56.84,56.09,54.97,53.22,52.56,53.97,56.47,55.66,58.5,58.66,58.28,58.12,60.88,61.19,61.41,64.16,64.25,65.03,67.25,68.03,69.62,72.0,72.09,72.12,71.31,71.75,69.78,68.28,67.06,67.53,65.69,65.72,65.53,65.22,64.41,63.56,64.19,64.38,64.91,65.53,64.44,64.28,64.38,62.5,63.94,64.69,65.91,65.69,65.28,64.78,63.03,61.94,60.44,59.78,59.62,58.06,57.56,57.56,56.91,56.28,57.28,57.28,56.94,58.75,59.0,59.0,59.56,61.88,63.19,64.5,67.25,66.38,65.69,64.31,62.31,58.97,57.16,56.72,55.22,55.84,56.81,59.28,61.47,65.25,67.94,74.22,74.75,79.06,80.5,80.19,79.28,78.06,77.28,75.31,75.06,74.12,74.0,69.97,69.81,65.38,63.38,61.84,60.88,60.44,60.66,60.91,61.19,62.22,63.06,65.25,66.44,68.59,70.44,70.19,70.66,70.09,68.81,69.66,70.0,68.81,70.75,71.25,72.12,73.06,73.41,72.0,70.03,68.03,65.88,65.25,64.38,66.25,66.72,66.62,67.91,69.22,69.72,69.91,70.38,70.59,71.53,69.5,69.5,67.75,66.31,66.25,66.25,67.41,66.5,68.75,67.44,67.12,67.75,66.91,66.69,67.31,66.72,68.81,68.47,69.56,69.0,68.12,68.0,66.88,65.53,63.53,58.66,56.03,52.06,50.31,50.72,51.94,54.53,56.84,57.06,58.56,58.56,57.84,58.69,58.62,57.5,57.91,57.88,57.88,58.84,60.44,59.41,61.5,60.94,60.09,60.62,59.97,60.84,60.47,59.31,59.38,58.56,56.25,54.53,53.69,53.25,53.91,55.41,56.44,57.62,58.38,59.44,60.31,61.5,62.16,62.09,61.31,58.81,57.69,54.41,53.38,53.19,53.41,53.72,56.19,56.03,58.75,58.28,58.62,56.69,54.81,52.59,49.69,48.56,50.41,49.53,50.97,53.84,54.0,56.41,56.53,58.72,58.91,59.84,58.34,57.91,54.56,54.28,53.91,54.16,56.75,57.69,59.97,61.69,61.28,61.88,60.5,61.12,59.53,61.38,62.94,65.12,64.59,67.75,67.66,66.06,66.66,66.41,64.94,65.06,64.41,64.5,62.72,62.06,61.12,59.19,58.25,57.5,56.78,57.44,57.41,57.19,57.31,58.06,59.62,59.91,62.25,62.81,64.59,63.56,62.38,58.69,55.19,53.5,51.31,49.25,49.94,49.53,49.47,48.16,49.81,50.12,52.53,54.31,54.59,57.97,56.75,57.06,57.72,60.16,62.66,66.16,70.28,73.0,74.28,72.12,69.53,64.94,59.16,54.22,51.53,49.53,50.16,51.62,51.78,56.25,57.0,57.78,59.91,60.25,60.19,61.44,61.59,64.12,64.38,66.31,65.31,64.56,62.12,59.25,56.0,54.84,52.66,52.16,52.16,50.16,50.53,50.22,49.62,49.12,47.84,48.84,48.69,48.81,49.97,52.47,53.06,54.06,55.31,55.56,53.12,51.62,50.19,49.44,49.0,52.34,54.41,56.88,58.38,58.19,59.41,58.09,56.75,57.53,56.25,58.09,56.94,57.0,57.25,58.34,58.84,60.19,62.91,60.56,61.0,60.66,58.28,57.19,56.38,55.62,55.06,54.34,54.69,52.03,52.16,49.72,48.31,46.94,46.34,46.38,46.09,45.78,47.16,46.06,45.69,47.38,46.78,45.31,45.44,45.62,44.19,43.5,44.69,44.72,45.09,47.19,46.34,47.44,47.06,45.91,44.0,42.69,40.28,39.78,39.44,38.69,40.06,41.28,42.28,43.19,44.44,45.78,45.28,44.28,46.59,45.03,47.06,48.81,49.88,49.81,49.34,47.59,46.84,45.91,46.16,47.0,47.38,47.16,47.25,46.56,45.62,44.81,44.88,45.81,45.0,45.38,45.41,45.25,45.09,45.66,45.38,45.5,47.12,46.62,47.72,48.62,47.78,46.53,44.75,42.41,40.5,40.06,41.16,42.0,44.12,45.75,44.88,43.41,42.5,40.62,38.44,37.28,37.41,36.28,36.5,36.41,37.25,38.41,40.28,40.62,42.25,43.81,45.16,46.81,47.06,46.69,46.5,46.69,45.41,45.53,45.91,45.91,45.12,45.97,44.66,45.91,46.69,47.56,47.53,49.28,49.41,47.62,46.38,44.81,42.91,42.56,41.97,41.19,41.12,39.91,39.19,38.28,39.53,41.31,43.31,43.97,47.5,50.22,51.78,53.53,54.66,53.81,53.16,53.38,54.12,57.03,60.44,62.31,63.03,63.31,61.72,59.88,57.84,57.88,57.12,56.56,56.66,58.16,57.66,58.41,57.47,57.44,55.5,53.31,50.94,48.94,46.75,45.94,44.78,44.91,44.62,43.62,43.03,42.28,42.44,43.31,44.31,45.84,46.97,48.34,49.56,51.0,51.97,51.56,51.53,50.34,48.94,48.72,49.47,50.19,51.47,53.69,54.03,55.94,56.44,56.56,56.81,57.34,57.66,57.03,59.31,59.19,58.94,58.62,57.12,55.81,53.72,52.25,50.19,49.91,49.44,48.31,47.84,49.06,49.16,48.56,49.47,50.31,50.78,50.34,50.41,49.59,46.97,47.06,46.72,46.91,49.06,51.41,53.31,54.06,55.0,54.5,54.34,54.03,52.69,52.94,52.31,50.78,50.31,48.5,47.31,46.34,45.66,45.28,45.12,45.84,46.88,48.12,49.28,51.75,53.06,54.5,55.16,54.75,54.34,52.94,51.06,48.53,46.97,44.91,42.06,39.88,38.53,36.22,34.38,33.53,32.81,32.91,32.62,33.03,35.84,38.97,41.66,44.44,48.94,49.69,51.0,50.19,49.75,47.12,47.19,44.62,43.66,42.88,40.69,38.78,38.09,36.53,34.41,34.31,34.25,35.31,36.12,38.84,41.62,44.12,47.53,49.91,52.41,54.16,53.38,52.94,49.06,45.72,42.12,38.75,36.69,36.22,35.62,35.94,34.91,33.91,33.25,32.5,31.72,31.62,32.66,33.16,33.5,34.47,34.19,35.75,36.0,34.75,35.53,34.09,32.25,28.56,27.53,24.25,22.03,19.53,18.06,15.56,13.19,9.34,8.19,5.53,3.62,3.69,3.62,3.97,3.56,4.25,4.75,4.94,4.41,4.41,3.91,2.94,1.81,1.28,-0.22,-1.53,-3.72,-5.53,-7.09,-8.81,-8.78,-9.78,-9.28,-8.88,-8.09,-7.38,-6.97,-6.12,-7.22,-8.84,-8.38,-8.19,-8.53,-6.47,-6.81,-6.84,-7.41,-9.72,-11.41,-14.06,-14.84,-15.09,-14.28,-12.03,-10.34,59.25,60.44,62.25,61.34,61.81,62.53:68.5,67.06,64.09,62.5,60.09,58.44,57.06,56.94,55.16,55.62,55.94,55.97,56.28,58.38,58.84,59.22,61.03,62.78,63.81,66.47,66.44,67.06,65.69,63.34,63.75,61.34,62.72,61.88,64.0,64.16,65.28,66.44,65.03,66.16,64.88,66.12,68.56,70.91,73.0,75.25,74.22,75.72,74.5,73.66,71.31,70.06,69.78,70.12,70.56,71.91,72.31,70.16,69.03,67.94,65.25,64.16,62.84,60.81,58.06,57.81,57.25,57.31,57.97,58.94,58.66,60.44,60.62,61.44,60.69,60.06,59.5,58.25,56.75,55.56,55.53,55.19,53.72,57.09,56.19,59.22,60.06,62.78,64.16,64.88,64.91,64.69,68.09,65.81,66.06,68.81,67.38,66.59,65.66,65.19,64.12,62.12,60.97,60.06,57.69,55.75,55.03,52.41,53.06,54.06,56.03,57.62,59.78,61.47,61.28,60.28,58.0,56.16,55.88,54.28,55.66,57.16,56.84,56.09,54.97,53.22,52.56,53.97,56.47,55.66,58.5,58.66,58.28,58.12,60.88,61.19,61.41,64.16,64.25,65.03,67.25,68.03,69.62,72.0,72.09,72.12,71.31,71.75,69.78,68.28,67.06,67.53,65.69,65.72,65.53,65.22,64.41,63.56,64.19,64.38,64.91,65.53,64.44,64.28,64.38,62.5,63.94,64.69,65.91,65.69,65.28,64.78,63.03,61.94,60.44,59.78,59.62,58.06,57.56,57.56,56.91,56.28,57.28,57.28,56.94,58.75,59.0,59.0,59.56,61.88,63.19,64.5,67.25,66.38,65.69,64.31,62.31,58.97,57.16,56.72,55.22,55.84,56.81,59.28,61.47,65.25,67.94,74.22,74.75,79.06,80.5,80.19,79.28,78.06,77.28,75.31,75.06,74.12,74.0,69.97,69.81,65.38,63.38,61.84,60.88,60.44,60.66,60.91,61.19,62.22,63.06,65.25,66.44,68.59,70.44,70.19,70.66,70.09,68.81,69.66,70.0,68.81,70.75,71.25,72.12,73.06,73.41,72.0,70.03,68.03,65.88,65.25,64.38,66.25,66.72,66.62,67.91,69.22,69.72,69.91,70.38,70.59,71.53,69.5,69.5,67.75,66.31,66.25,66.25,67.41,66.5,68.75,67.44,67.12,67.75,66.91,66.69,67.31,66.72,68.81,68.47,69.56,69.0,68.12,68.0,66.88,65.53,63.53,58.66,56.03,52.06,50.31,50.72,51.94,54.53,56.84,57.06,58.56,58.56,57.84,58.69,58.62,57.5,57.91,57.88,57.88,58.84,60.44,59.41,61.5,60.94,60.09,60.62,59.97,60.84,60.47,59.31,59.38,58.56,56.25,54.53,53.69,53.25,53.91,55.41,56.44,57.62,58.38,59.44,60.31,61.5,62.16,62.09,61.31,58.81,57.69,54.41,53.38,53.19,53.41,53.72,56.19,56.03,58.75,58.28,58.62,56.69,54.81,52.59,49.69,48.56,50.41,49.53,50.97,53.84,54.0,56.41,56.53,58.72,58.91,59.84,58.34,57.91,54.56,54.28,53.91,54.16,56.75,57.69,59.97,61.69,61.28,61.88,60.5,61.12,59.53,61.38,62.94,65.12,64.59,67.75,67.66,66.06,66.66,66.41,64.94,65.06,64.41,64.5,62.72,62.06,61.12,59.19,58.25,57.5,56.78,57.44,57.41,57.19,57.31,58.06,59.62,59.91,62.25,62.81,64.59,63.56,62.38,58.69,55.19,53.5,51.31,49.25,49.94,49.53,49.47,48.16,49.81,50.12,52.53,54.31,54.59,57.97,56.75,57.06,57.72,60.16,62.66,66.16,70.28,73.0,74.28,72.12,69.53,64.94,59.16,54.22,51.53,49.53,50.16,51.62,51.78,56.25,57.0,57.78,59.91,60.25,60.19,61.44,61.59,64.12,64.38,66.31,65.31,64.56,62.12,59.25,56.0,54.84,52.66,52.16,52.16,50.16,50.53,50.22,49.62,49.12,47.84,48.84,48.69,48.81,49.97,52.47,53.06,54.06,55.31,55.56,53.12,51.62,50.19,49.44,49.0,52.34,54.41,56.88,58.38,58.19,59.41,58.09,56.75,57.53,56.25,58.09,56.94,57.0,57.25,58.34,58.84,60.19,62.91,60.56,61.0,60.66,58.28,57.19,56.38,55.62,55.06,54.34,54.69,52.03,52.16,49.72,48.31,46.94,46.34,46.38,46.09,45.78,47.16,46.06,45.69,47.38,46.78,45.31,45.44,45.62,44.19,43.5,44.69,44.72,45.09,47.19,46.34,47.44,47.06,45.91,44.0,42.69,40.28,39.78,39.44,38.69,40.06,41.28,42.28,43.19,44.44,45.78,45.28,44.28,46.59,45.03,47.06,48.81,49.88,49.81,49.34,47.59,46.84,45.91,46.16,47.0,47.38,47.16,47.25,46.56,45.62,44.81,44.88,45.81,45.0,45.38,45.41,45.25,45.09,45.66,45.38,45.5,47.12,46.62,47.72,48.62,47.78,46.53,44.75,42.41,40.5,40.06,41.16,42.0,44.12,45.75,44.88,43.41,42.5,40.62,38.44,37.28,37.41,36.28,36.5,36.41,37.25,38.41,40.28,40.62,42.25,43.81,45.16,46.81,47.06,46.69,46.5,46.69,45.41,45.53,45.91,45.91,45.12,45.97,44.66,45.91,46.69,47.56,47.53,49.28,49.41,47.62,46.38,44.81,42.91,42.56,41.97,41.19,41.12,39.91,39.19,38.28,39.53,41.31,43.31,43.97,47.5,50.22,51.78,53.53,54.66,53.81,53.16,53.38,54.12,57.03,60.44,62.31,63.03,63.31,61.72,59.88,57.84,57.88,57.12,56.56,56.66,58.16,57.66,58.41,57.47,57.44,55.5,53.31,50.94,48.94,46.75,45.94,44.78,44.91,44.62,43.62,43.03,42.28,42.44,43.31,44.31,45.84,46.97,48.34,49.56,51.0,51.97,51.56,51.53,50.34,48.94,48.72,49.47,50.19,51.47,53.69,54.03,55.94,56.44,56.56,56.81,57.34,57.66,57.03,59.31,59.19,58.94,58.62,57.12,55.81,53.72,52.25,50.19,49.91,49.44,48.31,47.84,49.06,49.16,48.56,49.47,50.31,50.78,50.34,50.41,49.59,46.97,47.06,46.72,46.91,49.06,51.41,53.31,54.06,55.0,54.5,54.34,54.03,52.69,52.94,52.31,50.78,50.31,48.5,47.31,46.34,45.66,45.28,45.12,45.84,46.88,48.12,49.28,51.75,53.06,54.5,55.16,54.75,54.34,52.94,51.06,48.53,46.97,44.91,42.06,39.88,38.53,36.22,34.38,33.53,32.81,32.91,32.62,33.03,35.84,38.97,41.66,44.44,48.94,49.69,51.0,50.19,49.75,47.12,47.19,44.62,43.66,42.88,40.69,38.78,38.09,36.53,34.41,34.31,34.25,35.31,36.12,38.84,41.62,44.12,47.53,49.91,52.41,54.16,53.38,52.94,49.06,45.72,42.12,38.75,36.69,36.22,35.62,35.94,34.91,33.91,33.25,32.5,31.72,31.62,32.66,33.16,33.5,34.47,34.19,35.75,36.0,34.75,35.53,34.09,32.25,28.56,27.53,24.25,22.03,19.53,18.06,15.56,13.19,9.34,8.19,5.53,3.62,3.69,3.62,3.97,3.56,4.25,4.75,4.94,4.41,4.41,3.91,2.94,1.81,1.28,-0.22,-1.53,-3.72,-5.53,-7.09,-8.81,-8.78,-9.78,-9.28,-8.88,-8.09,-7.38,-6.97,-6.12,-7.22,-8.84,-8.38,-8.19,-8.53,-6.47,-6.81,-6.84,-7.41,-9.72,-11.41,-14.06,-14.84,-15.09,-14.28,-12.03,-10.34,59.25,60.44,62.25,61.34,61.81,62.53,63.84,64.25,66.56,68.16,67.97,67.84:57.06,56.94,55.16,55.62,55.94,55.97,56.28,58.38,58.84,59.22,61.03,62.78,63.81,66.47,66.44,67.06,65.69,63.34,63.75,61.34,62.72,61.88,64.0,64.16,65.28,66.44,65.03,66.16,64.88,66.12,68.56,70.91,73.0,75.25,74.22,75.72,74.5,73.66,71.31,70.06,69.78,70.12,70.56,71.91,72.31,70.16,69.03,67.94,65.25,64.16,62.84,60.81,58.06,57.81,57.25,57.31,57.97,58.94,58.66,60.44,60.62,61.44,60.69,60.06,59.5,58.25,56.75,55.56,55.53,55.19,53.72,57.09,56.19,59.22,60.06,62.78,64.16,64.88,64.91,64.69,68.09,65.81,66.06,68.81,67.38,66.59,65.66,65.19,64.12,62.12,60.97,60.06,57.69,55.75,55.03,52.41,53.06,54.06,56.03,57.62,59.78,61.47,61.28,60.28,58.0,56.16,55.88,54.28,55.66,57.16,56.84,56.09,54.97,53.22,52.56,53.97,56.47,55.66,58.5,58.66,58.28,58.12,60.88,61.19,61.41,64.16,64.25,65.03,67.25,68.03,69.62,72.0,72.09,72.12,71.31,71.75,69.78,68.28,67.06,67.53,65.69,65.72,65.53,65.22,64.41,63.56,64.19,64.38,64.91,65.53,64.44,64.28,64.38,62.5,63.94,64.69,65.91,65.69,65.28,64.78,63.03,61.94,60.44,59.78,59.62,58.06,57.56,57.56,56.91,56.28,57.28,57.28,56.94,58.75,59.0,59.0,59.56,61.88,63.19,64.5,67.25,66.38,65.69,64.31,62.31,58.97,57.16,56.72,55.22,55.84,56.81,59.28,61.47,65.25,67.94,74.22,74.75,79.06,80.5,80.19,79.28,78.06,77.28,75.31,75.06,74.12,74.0,69.97,69.81,65.38,63.38,61.84,60.88,60.44,60.66,60.91,61.19,62.22,63.06,65.25,66.44,68.59,70.44,70.19,70.66,70.09,68.81,69.66,70.0,68.81,70.75,71.25,72.12,73.06,73.41,72.0,70.03,68.03,65.88,65.25,64.38,66.25,66.72,66.62,67.91,69.22,69.72,69.91,70.38,70.59,71.53,69.5,69.5,67.75,66.31,66.25,66.25,67.41,66.5,68.75,67.44,67.12,67.75,66.91,66.69,67.31,66.72,68.81,68.47,69.56,69.0,68.12,68.0,66.88,65.53,63.53,58.66,56.03,52.06,50.31,50.72,51.94,54.53,56.84,57.06,58.56,58.56,57.84,58.69,58.62,57.5,57.91,57.88,57.88,58.84,60.44,59.41,61.5,60.94,60.09,60.62,59.97,60.84,60.47,59.31,59.38,58.56,56.25,54.53,53.69,53.25,53.91,55.41,56.44,57.62,58.38,59.44,60.31,61.5,62.16,62.09,61.31,58.81,57.69,54.41,53.38,53.19,53.41,53.72,56.19,56.03,58.75,58.28,58.62,56.69,54.81,52.59,49.69,48.56,50.41,49.53,50.97,53.84,54.0,56.41,56.53,58.72,58.91,59.84,58.34,57.91,54.56,54.28,53.91,54.16,56.75,57.69,59.97,61.69,61.28,61.88,60.5,61.12,59.53,61.38,62.94,65.12,64.59,67.75,67.66,66.06,66.66,66.41,64.94,65.06,64.41,64.5,62.72,62.06,61.12,59.19,58.25,57.5,56.78,57.44,57.41,57.19,57.31,58.06,59.62,59.91,62.25,62.81,64.59,63.56,62.38,58.69,55.19,53.5,51.31,49.25,49.94,49.53,49.47,48.16,49.81,50.12,52.53,54.31,54.59,57.97,56.75,57.06,57.72,60.16,62.66,66.16,70.28,73.0,74.28,72.12,69.53,64.94,59.16,54.22,51.53,49.53,50.16,51.62,51.78,56.25,57.0,57.78,59.91,60.25,60.19,61.44,61.59,64.12,64.38,66.31,65.31,64.56,62.12,59.25,56.0,54.84,52.66,52.16,52.16,50.16,50.53,50.22,49.62,49.12,47.84,48.84,48.69,48.81,49.97,52.47,53.06,54.06,55.31,55.56,53.12,51.62,50.19,49.44,49.0,52.34,54.41,56.88,58.38,58.19,59.41,58.09,56.75,57.53,56.25,58.09,56.94,57.0,57.25,58.34,58.84,60.19,62.91,60.56,61.0,60.66,58.28,57.19,56.38,55.62,55.06,54.34,54.69,52.03,52.16,49.72,48.31,46.94,46.34,46.38,46.09,45.78,47.16,46.06,45.69,47.38,46.78,45.31,45.44,45.62,44.19,43.5,44.69,44.72,45.09,47.19,46.34,47.44,47.06,45.91,44.0,42.69,40.28,39.78,39.44,38.69,40.06,41.28,42.28,43.19,44.44,45.78,45.28,44.28,46.59,45.03,47.06,48.81,49.88,49.81,49.34,47.59,46.84,45.91,46.16,47.0,47.38,47.16,47.25,46.56,45.62,44.81,44.88,45.81,45.0,45.38,45.41,45.25,45.09,45.66,45.38,45.5,47.12,46.62,47.72,48.62,47.78,46.53,44.75,42.41,40.5,40.06,41.16,42.0,44.12,45.75,44.88,43.41,42.5,40.62,38.44,37.28,37.41,36.28,36.5,36.41,37.25,38.41,40.28,40.62,42.25,43.81,45.16,46.81,47.06,46.69,46.5,46.69,45.41,45.53,45.91,45.91,45.12,45.97,44.66,45.91,46.69,47.56,47.53,49.28,49.41,47.62,46.38,44.81,42.91,42.56,41.97,41.19,41.12,39.91,39.19,38.28,39.53,41.31,43.31,43.97,47.5,50.22,51.78,53.53,54.66,53.81,53.16,53.38,54.12,57.03,60.44,62.31,63.03,63.31,61.72,59.88,57.84,57.88,57.12,56.56,56.66,58.16,57.66,58.41,57.47,57.44,55.5,53.31,50.94,48.94,46.75,45.94,44.78,44.91,44.62,43.62,43.03,42.28,42.44,43.31,44.31,45.84,46.97,48.34,49.56,51.0,51.97,51.56,51.53,50.34,48.94,48.72,49.47,50.19,51.47,53.69,54.03,55.94,56.44,56.56,56.81,57.34,57.66,57.03,59.31,59.19,58.94,58.62,57.12,55.81,53.72,52.25,50.19,49.91,49.44,48.31,47.84,49.06,49.16,48.56,49.47,50.31,50.78,50.34,50.41,49.59,46.97,47.06,46.72,46.91,49.06,51.41,53.31,54.06,55.0,54.5,54.34,54.03,52.69,52.94,52.31,50.78,50.31,48.5,47.31,46.34,45.66,45.28,45.12,45.84,46.88,48.12,49.28,51.75,53.06,54.5,55.16,54.75,54.34,52.94,51.06,48.53,46.97,44.91,42.06,39.88,38.53,36.22,34.38,33.53,32.81,32.91,32.62,33.03,35.84,38.97,41.66,44.44,48.94,49.69,51.0,50.19,49.75,47.12,47.19,44.62,43.66,42.88,40.69,38.78,38.09,36.53,34.41,34.31,34.25,35.31,36.12,38.84,41.62,44.12,47.53,49.91,52.41,54.16,53.38,52.94,49.06,45.72,42.12,38.75,36.69,36.22,35.62,35.94,34.91,33.91,33.25,32.5,31.72,31.62,32.66,33.16,33.5,34.47,34.19,35.75,36.0,34.75,35.53,34.09,32.25,28.56,27.53,24.25,22.03,19.53,18.06,15.56,13.19,9.34,8.19,5.53,3.62,3.69,3.62,3.97,3.56,4.25,4.75,4.94,4.41,4.41,3.91,2.94,1.81,1.28,-0.22,-1.53,-3.72,-5.53,-7.09,-8.81,-8.78,-9.78,-9.28,-8.88,-8.09,-7.38,-6.97,-6.12,-7.22,-8.84,-8.38,-8.19,-8.53,-6.47,-6.81,-6.84,-7.41,-9.72,-11.41,-14.06,-14.84,-15.09,-14.28,-12.03,-10.34,59.25,60.44,62.25,61.34,61.81,62.53,63.84,64.25,66.56,68.16,67.97,67.84,67.78,65.75,63.31,62.88,59.88,59.12:56.28,58.38,58.84,59.22,61.03,62.78,63.81,66.47,66.44,67.06,65.69,63.34,63.75,61.34,62.72,61.88,64.0,64.16,65.28,66.44,65.03,66.16,64.88,66.12,68.56,70.91,73.0,75.25,74.22,75.72,74.5,73.66,71.31,70.06,69.78,70.12,70.56,71.91,72.31,70.16,69.03,67.94,65.25,64.16,62.84,60.81,58.06,57.81,57.25,57.31,57.97,58.94,58.66,60.44,60.62,61.44,60.69,60.06,59.5,58.25,56.75,55.56,55.53,55.19,53.72,57.09,56.19,59.22,60.06,62.78,64.16,64.88,64.91,64.69,68.09,65.81,66.06,68.81,67.38,66.59,65.66,65.19,64.12,62.12,60.97,60.06,57.69,55.75,55.03,52.41,53.06,54.06,56.03,57.62,59.78,61.47,61.28,60.28,58.0,56.16,55.88,54.28,55.66,57.16,56.84,56.09,54.97,53.22,52.56,53.97,56.47,55.66,58.5,58.66,58.28,58.12,60.88,61.19,61.41,64.16,64.25,65.03,67.25,68.03,69.62,72.0,72.09,72.12,71.31,71.75,69.78,68.28,67.06,67.53,65.69,65.72,65.53,65.22,64.41,63.56,64.19,64.38,64.91,65.53,64.44,64.28,64.38,62.5,63.94,64.69,65.91,65.69,65.28,64.78,63.03,61.94,60.44,59.78,59.62,58.06,57.56,57.56,56.91,56.28,57.28,57.28,56.94,58.75,59.0,59.0,59.56,61.88,63.19,64.5,67.25,66.38,65.69,64.31,62.31,58.97,57.16,56.72,55.22,55.84,56.81,59.28,61.47,65.25,67.94,74.22,74.75,79.06,80.5,80.19,79.28,78.06,77.28,75.31,75.06,74.12,74.0,69.97,69.81,65.38,63.38,61.84,60.88,60.44,60.66,60.91,61.19,62.22,63.06,65.25,66.44,68.59,70.44,70.19,70.66,70.09,68.81,69.66,70.0,68.81,70.75,71.25,72.12,73.06,73.41,72.0,70.03,68.03,65.88,65.25,64.38,66.25,66.72,66.62,67.91,69.22,69.72,69.91,70.38,70.59,71.53,69.5,69.5,67.75,66.31,66.25,66.25,67.41,66.5,68.75,67.44,67.12,67.75,66.91,66.69,67.31,66.72,68.81,68.47,69.56,69.0,68.12,68.0,66.88,65.53,63.53,58.66,56.03,52.06,50.31,50.72,51.94,54.53,56.84,57.06,58.56,58.56,57.84,58.69,58.62,57.5,57.91,57.88,57.88,58.84,60.44,59.41,61.5,60.94,60.09,60.62,59.97,60.84,60.47,59.31,59.38,58.56,56.25,54.53,53.69,53.25,53.91,55.41,56.44,57.62,58.38,59.44,60.31,61.5,62.16,62.09,61.31,58.81,57.69,54.41,53.38,53.19,53.41,53.72,56.19,56.03,58.75,58.28,58.62,56.69,54.81,52.59,49.69,48.56,50.41,49.53,50.97,53.84,54.0,56.41,56.53,58.72,58.91,59.84,58.34,57.91,54.56,54.28,53.91,54.16,56.75,57.69,59.97,61.69,61.28,61.88,60.5,61.12,59.53,61.38,62.94,65.12,64.59,67.75,67.66,66.06,66.66,66.41,64.94,65.06,64.41,64.5,62.72,62.06,61.12,59.19,58.25,57.5,56.78,57.44,57.41,57.19,57.31,58.06,59.62,59.91,62.25,62.81,64.59,63.56,62.38,58.69,55.19,53.5,51.31,49.25,49.94,49.53,49.47,48.16,49.81,50.12,52.53,54.31,54.59,57.97,56.75,57.06,57.72,60.16,62.66,66.16,70.28,73.0,74.28,72.12,69.53,64.94,59.16,54.22,51.53,49.53,50.16,51.62,51.78,56.25,57.0,57.78,59.91,60.25,60.19,61.44,61.59,64.12,64.38,66.31,65.31,64.56,62.12,59.25,56.0,54.84,52.66,52.16,52.16,50.16,50.53,50.22,49.62,49.12,47.84,48.84,48.69,48.81,49.97,52.47,53.06,54.06,55.31,55.56,53.12,51.62,50.19,49.44,49.0,52.34,54.41,56.88,58.38,58.19,59.41,58.09,56.75,57.53,56.25,58.09,56.94,57.0,57.25,58.34,58.84,60.19,62.91,60.56,61.0,60.66,58.28,57.19,56.38,55.62,55.06,54.34,54.69,52.03,52.16,49.72,48.31,46.94,46.34,46.38,46.09,45.78,47.16,46.06,45.69,47.38,46.78,45.31,45.44,45.62,44.19,43.5,44.69,44.72,45.09,47.19,46.34,47.44,47.06,45.91,44.0,42.69,40.28,39.78,39.44,38.69,40.06,41.28,42.28,43.19,44.44,45.78,45.28,44.28,46.59,45.03,47.06,48.81,49.88,49.81,49.34,47.59,46.84,45.91,46.16,47.0,47.38,47.16,47.25,46.56,45.62,44.81,44.88,45.81,45.0,45.38,45.41,45.25,45.09,45.66,45.38,45.5,47.12,46.62,47.72,48.62,47.78,46.53,44.75,42.41,40.5,40.06,41.16,42.0,44.12,45.75,44.88,43.41,42.5,40.62,38.44,37.28,37.41,36.28,36.5,36.41,37.25,38.41,40.28,40.62,42.25,43.81,45.16,46.81,47.06,46.69,46.5,46.69,45.41,45.53,45.91,45.91,45.12,45.97,44.66,45.91,46.69,47.56,47.53,49.28,49.41,47.62,46.38,44.81,42.91,42.56,41.97,41.19,41.12,39.91,39.19,38.28,39.53,41.31,43.31,43.97,47.5,50.22,51.78,53.53,54.66,53.81,53.16,53.38,54.12,57.03,60.44,62.31,63.03,63.31,61.72,59.88,57.84,57.88,57.12,56.56,56.66,58.16,57.66,58.41,57.47,57.44,55.5,53.31,50.94,48.94,46.75,45.94,44.78,44.91,44.62,43.62,43.03,42.28,42.44,43.31,44.31,45.84,46.97,48.34,49.56,51.0,51.97,51.56,51.53,50.34,48.94,48.72,49.47,50.19,51.47,53.69,54.03,55.94,56.44,56.56,56.81,57.34,57.66,57.03,59.31,59.19,58.94,58.62,57.12,55.81,53.72,52.25,50.19,49.91,49.44,48.31,47.84,49.06,49.16,48.56,49.47,50.31,50.78,50.34,50.41,49.59,46.97,47.06,46.72,46.91,49.06,51.41,53.31,54.06,55.0,54.5,54.34,54.03,52.69,52.94,52.31,50.78,50.31,48.5,47.31,46.34,45.66,45.28,45.12,45.84,46.88,48.12,49.28,51.75,53.06,54.5,55.16,54.75,54.34,52.94,51.06,48.53,46.97,44.91,42.06,39.88,38.53,36.22,34.38,33.53,32.81,32.91,32.62,33.03,35.84,38.97,41.66,44.44,48.94,49.69,51.0,50.19,49.75,47.12,47.19,44.62,43.66,42.88,40.69,38.78,38.09,36.53,34.41,34.31,34.25,35.31,36.12,38.84,41.62,44.12,47.53,49.91,52.41,54.16,53.38,52.94,49.06,45.72,42.12,38.75,36.69,36.22,35.62,35.94,34.91,33.91,33.25,32.5,31.72,31.62,32.66,33.16,33.5,34.47,34.19,35.75,36.0,34.75,35.53,34.09,32.25,28.56,27.53,24.25,22.03,19.53,18.06,15.56,13.19,9.34,8.19,5.53,3.62,3.69,3.62,3.97,3.56,4.25,4.75,4.94,4.41,4.41,3.91,2.94,1.81,1.28,-0.22,-1.53,-3.72,-5.53,-7.09,-8.81,-8.78,-9.78,-9.28,-8.88,-8.09,-7.38,-6.97,-6.12,-7.22,-8.84,-8.38,-8.19,-8.53,-6.47,-6.81,-6.84,-7.41,-9.72,-11.41,-14.06,-14.84,-15.09,-14.28,-12.03,-10.34,59.25,60.44,62.25,61.34,61.81,62.53,63.84,64.25,66.56,68.16,67.97,67.84,67.78,65.75,63.31,62.88,59.88,59.12,58.03,57.0,56.94,56.31,56.25,57.31:63.81,66.47,66.44,67.06,65.69,63.34,63.75,61.34,62.72,61.88,64.0,64.16,65.28,66.44,65.03,66.16,64.88,66.12,68.56,70.91,73.0,75.25,74.22,75.72,74.5,73.66,71.31,70.06,69.78,70.12,70.56,71.91,72.31,70.16,69.03,67.94,65.25,64.16,62.84,60.81,58.06,57.81,57.25,57.31,57.97,58.94,58.66,60.44,60.62,61.44,60.69,60.06,59.5,58.25,56.75,55.56,55.53,55.19,53.72,57.09,56.19,59.22,60.06,62.78,64.16,64.88,64.91,64.69,68.09,65.81,66.06,68.81,67.38,66.59,65.66,65.19,64.12,62.12,60.97,60.06,57.69,55.75,55.03,52.41,53.06,54.06,56.03,57.62,59.78,61.47,61.28,60.28,58.0,56.16,55.88,54.28,55.66,57.16,56.84,56.09,54.97,53.22,52.56,53.97,56.47,55.66,58.5,58.66,58.28,58.12,60.88,61.19,61.41,64.16,64.25,65.03,67.25,68.03,69.62,72.0,72.09,72.12,71.31,71.75,69.78,68.28,67.06,67.53,65.69,65.72,65.53,65.22,64.41,63.56,64.19,64.38,64.91,65.53,64.44,64.28,64.38,62.5,63.94,64.69,65.91,65.69,65.28,64.78,63.03,61.94,60.44,59.78,59.62,58.06,57.56,57.56,56.91,56.28,57.28,57.28,56.94,58.75,59.0,59.0,59.56,61.88,63.19,64.5,67.25,66.38,65.69,64.31,62.31,58.97,57.16,56.72,55.22,55.84,56.81,59.28,61.47,65.25,67.94,74.22,74.75,79.06,80.5,80.19,79.28,78.06,77.28,75.31,75.06,74.12,74.0,69.97,69.81,65.38,63.38,61.84,60.88,60.44,60.66,60.91,61.19,62.22,63.06,65.25,66.44,68.59,70.44,70.19,70.66,70.09,68.81,69.66,70.0,68.81,70.75,71.25,72.12,73.06,73.41,72.0,70.03,68.03,65.88,65.25,64.38,66.25,66.72,66.62,67.91,69.22,69.72,69.91,70.38,70.59,71.53,69.5,69.5,67.75,66.31,66.25,66.25,67.41,66.5,68.75,67.44,67.12,67.75,66.91,66.69,67.31,66.72,68.81,68.47,69.56,69.0,68.12,68.0,66.88,65.53,63.53,58.66,56.03,52.06,50.31,50.72,51.94,54.53,56.84,57.06,58.56,58.56,57.84,58.69,58.62,57.5,57.91,57.88,57.88,58.84,60.44,59.41,61.5,60.94,60.09,60.62,59.97,60.84,60.47,59.31,59.38,58.56,56.25,54.53,53.69,53.25,53.91,55.41,56.44,57.62,58.38,59.44,60.31,61.5,62.16,62.09,61.31,58.81,57.69,54.41,53.38,53.19,53.41,53.72,56.19,56.03,58.75,58.28,58.62,56.69,54.81,52.59,49.69,48.56,50.41,49.53,50.97,53.84,54.0,56.41,56.53,58.72,58.91,59.84,58.34,57.91,54.56,54.28,53.91,54.16,56.75,57.69,59.97,61.69,61.28,61.88,60.5,61.12,59.53,61.38,62.94,65.12,64.59,67.75,67.66,66.06,66.66,66.41,64.94,65.06,64.41,64.5,62.72,62.06,61.12,59.19,58.25,57.5,56.78,57.44,57.41,57.19,57.31,58.06,59.62,59.91,62.25,62.81,64.59,63.56,62.38,58.69,55.19,53.5,51.31,49.25,49.94,49.53,49.47,48.16,49.81,50.12,52.53,54.31,54.59,57.97,56.75,57.06,57.72,60.16,62.66,66.16,70.28,73.0,74.28,72.12,69.53,64.94,59.16,54.22,51.53,49.53,50.16,51.62,51.78,56.25,57.0,57.78,59.91,60.25,60.19,61.44,61.59,64.12,64.38,66.31,65.31,64.56,62.12,59.25,56.0,54.84,52.66,52.16,52.16,50.16,50.53,50.22,49.62,49.12,47.84,48.84,48.69,48.81,49.97,52.47,53.06,54.06,55.31,55.56,53.12,51.62,50.19,49.44,49.0,52.34,54.41,56.88,58.38,58.19,59.41,58.09,56.75,57.53,56.25,58.09,56.94,57.0,57.25,58.34,58.84,60.19,62.91,60.56,61.0,60.66,58.28,57.19,56.38,55.62,55.06,54.34,54.69,52.03,52.16,49.72,48.31,46.94,46.34,46.38,46.09,45.78,47.16,46.06,45.69,47.38,46.78,45.31,45.44,45.62,44.19,43.5,44.69,44.72,45.09,47.19,46.34,47.44,47.06,45.91,44.0,42.69,40.28,39.78,39.44,38.69,40.06,41.28,42.28,43.19,44.44,45.78,45.28,44.28,46.59,45.03,47.06,48.81,49.88,49.81,49.34,47.59,46.84,45.91,46.16,47.0,47.38,47.16,47.25,46.56,45.62,44.81,44.88,45.81,45.0,45.38,45.41,45.25,45.09,45.66,45.38,45.5,47.12,46.62,47.72,48.62,47.78,46.53,44.75,42.41,40.5,40.06,41.16,42.0,44.12,45.75,44.88,43.41,42.5,40.62,38.44,37.28,37.41,36.28,36.5,36.41,37.25,38.41,40.28,40.62,42.25,43.81,45.16,46.81,47.06,46.69,46.5,46.69,45.41,45.53,45.91,45.91,45.12,45.97,44.66,45.91,46.69,47.56,47.53,49.28,49.41,47.62,46.38,44.81,42.91,42.56,41.97,41.19,41.12,39.91,39.19,38.28,39.53,41.31,43.31,43.97,47.5,50.22,51.78,53.53,54.66,53.81,53.16,53.38,54.12,57.03,60.44,62.31,63.03,63.31,61.72,59.88,57.84,57.88,57.12,56.56,56.66,58.16,57.66,58.41,57.47,57.44,55.5,53.31,50.94,48.94,46.75,45.94,44.78,44.91,44.62,43.62,43.03,42.28,42.44,43.31,44.31,45.84,46.97,48.34,49.56,51.0,51.97,51.56,51.53,50.34,48.94,48.72,49.47,50.19,51.47,53.69,54.03,55.94,56.44,56.56,56.81,57.34,57.66,57.03,59.31,59.19,58.94,58.62,57.12,55.81,53.72,52.25,50.19,49.91,49.44,48.31,47.84,49.06,49.16,48.56,49.47,50.31,50.78,50.34,50.41,49.59,46.97,47.06,46.72,46.91,49.06,51.41,53.31,54.06,55.0,54.5,54.34,54.03,52.69,52.94,52.31,50.78,50.31,48.5,47.31,46.34,45.66,45.28,45.12,45.84,46.88,48.12,49.28,51.75,53.06,54.5,55.16,54.75,54.34,52.94,51.06,48.53,46.97,44.91,42.06,39.88,38.53,36.22,34.38,33.53,32.81,32.91,32.62,33.03,35.84,38.97,41.66,44.44,48.94,49.69,51.0,50.19,49.75,47.12,47.19,44.62,43.66,42.88,40.69,38.78,38.09,36.53,34.41,34.31,34.25,35.31,36.12,38.84,41.62,44.12,47.53,49.91,52.41,54.16,53.38,52.94,49.06,45.72,42.12,38.75,36.69,36.22,35.62,35.94,34.91,33.91,33.25,32.5,31.72,31.62,32.66,33.16,33.5,34.47,34.19,35.75,36.0,34.75,35.53,34.09,32.25,28.56,27.53,24.25,22.03,19.53,18.06,15.56,13.19,9.34,8.19,5.53,3.62,3.69,3.62,3.97,3.56,4.25,4.75,4.94,4.41,4.41,3.91,2.94,1.81,1.28,-0.22,-1.53,-3.72,-5.53,-7.09,-8.81,-8.78,-9.78,-9.28,-8.88,-8.09,-7.38,-6.97,-6.12,-7.22,-8.84,-8.38,-8.19,-8.53,-6.47,-6.81,-6.84,-7.41,-9.72,-11.41,-14.06,-14.84,-15.09,-14.28,-12.03,-10.34,59.25,60.44,62.25,61.34,61.81,62.53,63.84,64.25,66.56,68.16,67.97,67.84,67.78,65.75,63.31,62.88,59.88,59.12,58.03,57.0,56.94,56.31,56.25,57.31,57.34,58.78,59.69,59.5,61.44,62.22:negativity
6.06,6.0,4.56,2.91,1.31,0.53,1.0,1.66,3.44,5.44,6.69,6.94,6.16,4.66,4.5,3.03,2.75,3.16,3.34,4.88,5.06,5.91,5.59,5.03,4.94,3.06,3.31,2.09,0.62,1.41,1.06,1.03,0.62,1.31,1.56,2.5,3.12,2.94,3.34,3.22,3.94,4.19,5.5,5.97,6.69,6.69,7.06,8.16,9.22,10.44,10.03,8.28,6.28,3.72,1.53,1.0,1.16,1.91,2.34,2.34,1.28,1.09,0.81,0.91,1.44,1.66,0.12,-0.22,-1.12,-4.06,-3.94,-5.03,-4.84,-4.97,-5.44,-5.72,-5.22,-5.34,-4.47,-4.28,-4.34,-4.72,-5.44,-5.88,-6.53,-6.72,-6.75,-6.91,-5.75,-2.75,-0.56,2.25,4.66,6.84,7.47,9.22,10.44,10.72,9.91,8.38,4.88,2.78,0.16,-1.97,-3.59,-5.06,-6.94,-8.06,-9.59,-9.34,-8.34,-7.28,-5.03,-2.0,-1.16,1.44,3.06,3.41,2.84,3.94,3.19,3.31,3.44,4.62,5.84,6.69,6.41,7.0,6.56,7.25,9.09,11.5,15.12,17.0,19.06,19.44,18.03,16.09,15.12,14.16,13.47,12.62,14.16,13.84,13.31,11.41,8.62,6.03,2.66,0.47,-0.66,0.19,1.56,4.25,4.97,7.66,7.94,8.28,6.62,6.81,5.94,5.44,6.47,6.75,6.88,7.47,8.38,8.75,9.75,10.41,10.91,10.91,10.75,10.0,9.25,7.72,6.81,4.84,3.12,1.0,-1.5,-3.38,-5.16,-5.84,-6.97,-5.72,-5.47,-4.34,-3.41,-2.53,-1.22,0.5,1.53,1.91,2.56,3.03,2.62,2.16,1.88,2.28,2.53,3.41,3.88,4.59,4.56,5.25,3.41,2.56,2.31,1.91,1.56,2.62,2.72,3.66,5.22,5.78,6.69,6.5,5.72,4.56,3.28,1.66,0.84,-0.22,0.28,0.56,0.81,2.38,3.03,2.62,1.88,-0.31,-0.91,-3.12,-2.91,-2.84,-0.31,2.5,5.66,9.34,11.06,13.0,12.62,10.81,8.44,5.84,3.56,2.31,1.44,1.5,1.62,2.62,2.56,2.06,1.69,0.81,-0.47,-1.38,-3.59,-5.28,-6.16,-6.53,-5.94,-3.62,-1.84,-0.12,0.97,0.47,-0.97,-3.09,-5.66,-7.81,-9.16,-10.81,-11.47,-11.41,-11.97,-11.81,-11.53,-11.81,-10.94,-9.97,-8.84,-7.59,-6.47,-4.28,-4.38,-2.03,-0.97,1.22,3.84,5.66,6.59,7.81,7.72,7.97,7.78,7.41,8.0,7.81,6.94,5.88,5.66,5.78,4.5,4.56,3.44,2.56,1.81,1.62,1.19,2.84,4.03,5.38,7.0,7.94,7.41,7.75,7.72,7.25,6.34,6.84,6.66,7.22,8.84,9.06,9.62,9.59,7.84,6.53,4.69,3.81,2.72,3.62,5.31,6.62,9.28,10.31,11.03,10.34,9.44,8.56,6.56,4.94,3.03,1.34,-0.22,-1.09,-2.69,-3.25,-4.59,-4.16,-4.53,-5.47,-5.34,-6.34,-7.16,-7.47,-7.16,-6.19,-4.06,-1.97,0.16,0.75,3.06,3.72,2.75,1.91,0.53,-1.47,-2.47,-2.03,-0.72,1.03,4.38,7.47,10.34,13.47,16.41,18.03,19.31,17.31,16.44,13.66,11.62,10.44,10.44,9.28,8.88,8.06,5.19,3.94,2.0,0.81,0.25,1.41,1.78,3.06,3.28,3.5,4.25,3.44,2.5,1.41,0.44,-0.72,-1.59,-0.59,0.84,3.22,5.19,7.69,9.66,11.22,11.94,12.69,13.66,13.31,13.97,13.19,12.72,11.31,9.69,7.69,6.41,5.0,4.31,5.12,5.59,6.12,7.22,8.0,8.06,8.56,9.09,9.72,9.78,11.28,11.5,12.56,13.03,15.25,16.5,18.25,19.16,20.56,20.94,20.84,19.94,18.44,16.91,14.91,13.84,12.69,13.94,13.25,15.84,16.31,16.44,17.31,17.19,16.38,16.06,15.81,14.47,13.72,12.69,12.0,11.03,10.62,9.91,8.0,6.81,3.31,1.16,0.28,-1.09,0.34,1.41,3.28,4.12,4.62,4.78,3.78,2.03,-0.34,-3.12,-5.94,-8.31,-9.66,-10.34,-11.22,-10.66,-10.09,-9.22,-7.72,-7.66,-7.59,-8.44,-8.22,-7.97,-8.09,-6.25,-4.16,-1.91,-1.97,-1.56,-1.41,-2.41,-4.16,-4.22,-4.44,-3.31,-1.16,0.66,2.69,3.97,5.31,5.5,5.5,4.41,3.72,1.66,0.03,-2.28,-3.59,-4.34,-3.69,-2.78,-1.94,-1.34,-1.03,-2.66,-3.88,-4.66,-6.34,-6.25,-6.16,-6.22,-6.03,-5.19,-5.84,-6.44,-6.94,-7.12,-7.09,-6.59,-5.94,-5.03,-4.97,-5.69,-5.59,-6.53,-6.75,-6.28,-5.56,-5.62,-5.34,-6.22,-7.12,-7.56,-7.88,-8.28,-7.81,-7.22,-7.56,-7.78,-8.22,-8.97,-8.69,-7.41,-5.97,-5.16,-2.56,-1.03,1.03,2.75,3.06,4.25,4.19,2.94,2.25,-0.22,-2.31,-4.53,-5.78,-6.25,-6.53,-5.22,-2.47,-2.81,-1.66,-1.56,-2.44,-3.53,-5.62,-8.62,-9.97,-11.47,-12.88,-12.84,-12.28,-11.19,-9.34,-7.41,-5.28,-3.81,-2.31,-1.53,-1.72,-2.59,-2.75,-2.03,-1.53,0.0,2.84,5.66,6.09,7.12,4.91,1.66,-1.62,-5.03,-6.69,-7.47,-6.53,-5.22,-3.56,-1.69,-0.84,-0.41,0.41,-0.28,-1.22,-2.94,-4.97,-6.34,-8.09,-8.97,-9.38,-10.0,-9.72,-11.19,-12.19,-12.5,-12.72,-13.09,-12.94,-13.84,-12.97,-12.88,-11.59,-10.47,-8.75,-7.59,-7.16,-6.97,-7.03,-6.84,-6.91,-6.16,-6.38,-5.56,-6.16,-5.91,-6.12,-6.94,-7.47,-8.09,-8.09,-8.84,-8.03,-7.44,-6.72,-5.34,-3.69,-2.31,-0.72,0.25,1.16,1.16,-0.03,-1.34,-2.94,-3.84,-5.44,-6.22,-5.09,-5.66,-6.03,-7.12,-8.72,-10.06,-11.66,-12.06,-13.0,-12.72,-12.97,-13.25,-12.88,-12.41,-12.34,-11.0,-10.5,-9.94,-9.19,-9.69,-10.34,-11.16,-13.34,-14.94,-15.59,-16.44,-16.31,-15.97,-15.19,-13.59,-13.28,-11.56,-11.72,-10.72,-9.91,-8.84,-6.94,-4.97,-3.59,-1.88,-1.22,-2.16,-3.41,-5.84,-9.34,-12.66,-17.09,-21.09,-22.78,-24.16,-24.69,-23.72,-21.44,-19.78,-17.62,-16.22,-15.06,-13.62,-12.88,-11.38,-10.56,-9.16,-7.53,-6.88,-5.22,-4.59,-5.16,-5.91,-7.72,-10.31,-12.53,-13.56,-14.62,-14.34,-14.97,-14.84,-14.62,-14.09,-14.09,-14.31,-13.91,-14.66,-14.41,-13.06,-10.09,-6.31,-1.72,3.56,7.25,8.91,10.03,9.91,7.16,4.31,1.59,-1.88,-4.81,-6.97,-9.03,-11.19,-11.66,-12.69,-13.91,-13.84,-14.84,-14.34,-13.5,-11.97,-9.31,-6.22,-2.91,-0.53,1.31,2.25,2.53,2.16,0.66,-1.03,-3.16,-4.41,-5.97,-7.34,-7.84,-10.03,-12.03,-14.22,-17.12,-19.38,-20.28,-21.41,-21.22,-21.47,-20.59,-19.03,-17.22,-15.22,-12.56,-10.47,-9.97,-8.56,-7.91,-9.53,-9.66,-11.44,-12.81,-14.81,-15.75,-16.78,-17.66,-18.59,-19.59,-20.97,-20.91,-21.31,-21.03,-20.94,-21.41,-20.88,-20.34,-18.78,-18.66,-17.09,-16.03,-16.22,-16.66,-18.09,-20.34,-22.09,-24.09,-24.44,-23.09,-20.34,-16.94,-13.22,-10.75,-10.78,-11.41,-14.75,-18.78,-22.0,-24.47,-25.22,-24.38,-23.53,-21.94,-21.81,-20.91,-21.97,-23.84,-25.53,-27.22,-29.03,-30.56,-32.47,-34.47,-36.12,-38.81,-41.41,-43.03,-44.47,-44.97,-43.47,-42.44,-41.0,-39.12,-37.72,-36.41,-35.66,-34.66:1.0,1.66,3.44,5.44,6.69,6.94,6.16,4.66,4.5,3.03,2.75,3.16,3.34,4.88,5.06,5.91,5.59,5.03,4.94,3.06,3.31,2.09,0.62,1.41,1.06,1.03,0.62,1.31,1.56,2.5,3.12,2.94,3.34,3.22,3.94,4.19,5.5,5.97,6.69,6.69,7.06,8.16,9.22,10.44,10.03,8.28,6.28,3.72,1.53,1.0,1.16,1.91,2.34,2.34,1.28,1.09,0.81,0.91,1.44,1.66,0.12,-0.22,-1.12,-4.06,-3.94,-5.03,-4.84,-4.97,-5.44,-5.72,-5.22,-5.34,-4.47,-4.28,-4.34,-4.72,-5.44,-5.88,-6.53,-6.72,-6.75,-6.91,-5.75,-2.75,-0.56,2.25,4.66,6.84,7.47,9.22,10.44,10.72,9.91,8.38,4.88,2.78,0.16,-1.97,-3.59,-5.06,-6.94,-8.06,-9.59,-9.34,-8.34,-7.28,-5.03,-2.0,-1.16,1.44,3.06,3.41,2.84,3.94,3.19,3.31,3.44,4.62,5.84,6.69,6.41,7.0,6.56,7.25,9.09,11.5,15.12,17.0,19.06,19.44,18.03,16.09,15.12,14.16,13.47,12.62,14.16,13.84,13.31,11.41,8.62,6.03,2.66,0.47,-0.66,0.19,1.56,4.25,4.97,7.66,7.94,8.28,6.62,6.81,5.94,5.44,6.47,6.75,6.88,7.47,8.38,8.75,9.75,10.41,10.91,10.91,10.75,10.0,9.25,7.72,6.81,4.84,3.12,1.0,-1.5,-3.38,-5.16,-5.84,-6.97,-5.72,-5.47,-4.34,-3.41,-2.53,-1.22,0.5,1.53,1.91,2.56,3.03,2.62,2.16,1.88,2.28,2.53,3.41,3.88,4.59,4.56,5.25,3.41,2.56,2.31,1.91,1.56,2.62,2.72,3.66,5.22,5.78,6.69,6.5,5.72,4.56,3.28,1.66,0.84,-0.22,0.28,0.56,0.81,2.38,3.03,2.62,1.88,-0.31,-0.91,-3.12,-2.91,-2.84,-0.31,2.5,5.66,9.34,11.06,13.0,12.62,10.81,8.44,5.84,3.56,2.31,1.44,1.5,1.62,2.62,2.56,2.06,1.69,0.81,-0.47,-1.38,-3.59,-5.28,-6.16,-6.53,-5.94,-3.62,-1.84,-0.12,0.97,0.47,-0.97,-3.09,-5.66,-7.81,-9.16,-10.81,-11.47,-11.41,-11.97,-11.81,-11.53,-11.81,-10.94,-9.97,-8.84,-7.59,-6.47,-4.28,-4.38,-2.03,-0.97,1.22,3.84,5.66,6.59,7.81,7.72,7.97,7.78,7.41,8.0,7.81,6.94,5.88,5.66,5.78,4.5,4.56,3.44,2.56,1.81,1.62,1.19,2.84,4.03,5.38,7.0,7.94,7.41,7.75,7.72,7.25,6.34,6.84,6.66,7.22,8.84,9.06,9.62,9.59,7.84,6.53,4.69,3.81,2.72,3.62,5.31,6.62,9.28,10.31,11.03,10.34,9.44,8.56,6.56,4.94,3.03,1.34,-0.22,-1.09,-2.69,-3.25,-4.59,-4.16,-4.53,-5.47,-5.34,-6.34,-7.16,-7.47,-7.16,-6.19,-4.06,-1.97,0.16,0.75,3.06,3.72,2.75,1.91,0.53,-1.47,-2.47,-2.03,-0.72,1.03,4.38,7.47,10.34,13.47,16.41,18.03,19.31,17.31,16.44,13.66,11.62,10.44,10.44,9.28,8.88,8.06,5.19,3.94,2.0,0.81,0.25,1.41,1.78,3.06,3.28,3.5,4.25,3.44,2.5,1.41,0.44,-0.72,-1.59,-0.59,0.84,3.22,5.19,7.69,9.66,11.22,11.94,12.69,13.66,13.31,13.97,13.19,12.72,11.31,9.69,7.69,6.41,5.0,4.31,5.12,5.59,6.12,7.22,8.0,8.06,8.56,9.09,9.72,9.78,11.28,11.5,12.56,13.03,15.25,16.5,18.25,19.16,20.56,20.94,20.84,19.94,18.44,16.91,14.91,13.84,12.69,13.94,13.25,15.84,16.31,16.44,17.31,17.19,16.38,16.06,15.81,14.47,13.72,12.69,12.0,11.03,10.62,9.91,8.0,6.81,3.31,1.16,0.28,-1.09,0.34,1.41,3.28,4.12,4.62,4.78,3.78,2.03,-0.34,-3.12,-5.94,-8.31,-9.66,-10.34,-11.22,-10.66,-10.09,-9.22,-7.72,-7.66,-7.59,-8.44,-8.22,-7.97,-8.09,-6.25,-4.16,-1.91,-1.97,-1.56,-1.41,-2.41,-4.16,-4.22,-4.44,-3.31,-1.16,0.66,2.69,3.97,5.31,5.5,5.5,4.41,3.72,1.66,0.03,-2.28,-3.59,-4.34,-3.69,-2.78,-1.94,-1.34,-1.03,-2.66,-3.88,-4.66,-6.34,-6.25,-6.16,-6.22,-6.03,-5.19,-5.84,-6.44,-6.94,-7.12,-7.09,-6.59,-5.94,-5.03,-4.97,-5.69,-5.59,-6.53,-6.75,-6.28,-5.56,-5.62,-5.34,-6.22,-7.12,-7.56,-7.88,-8.28,-7.81,-7.22,-7.56,-7.78,-8.22,-8.97,-8.69,-7.41,-5.97,-5.16,-2.56,-1.03,1.03,2.75,3.06,4.25,4.19,2.94,2.25,-0.22,-2.31,-4.53,-5.78,-6.25,-6.53,-5.22,-2.47,-2.81,-1.66,-1.56,-2.44,-3.53,-5.62,-8.62,-9.97,-11.47,-12.88,-12.84,-12.28,-11.19,-9.34,-7.41,-5.28,-3.81,-2.31,-1.53,-1.72,-2.59,-2.75,-2.03,-1.53,0.0,2.84,5.66,6.09,7.12,4.91,1.66,-1.62,-5.03,-6.69,-7.47,-6.53,-5.22,-3.56,-1.69,-0.84,-0.41,0.41,-0.28,-1.22,-2.94,-4.97,-6.34,-8.09,-8.97,-9.38,-10.0,-9.72,-11.19,-12.19,-12.5,-12.72,-13.09,-12.94,-13.84,-12.97,-12.88,-11.59,-10.47,-8.75,-7.59,-7.16,-6.97,-7.03,-6.84,-6.91,-6.16,-6.38,-5.56,-6.16,-5.91,-6.12,-6.94,-7.47,-8.09,-8.09,-8.84,-8.03,-7.44,-6.72,-5.34,-3.69,-2.31,-0.72,0.25,1.16,1.16,-0.03,-1.34,-2.94,-3.84,-5.44,-6.22,-5.09,-5.66,-6.03,-7.12,-8.72,-10.06,-11.66,-12.06,-13.0,-12.72,-12.97,-13.25,-12.88,-12.41,-12.34,-11.0,-10.5,-9.94,-9.19,-9.69,-10.34,-11.16,-13.34,-14.94,-15.59,-16.44,-16.31,-15.97,-15.19,-13.59,-13.28,-11.56,-11.72,-10.72,-9.91,-8.84,-6.94,-4.97,-3.59,-1.88,-1.22,-2.16,-3.41,-5.84,-9.34,-12.66,-17.09,-21.09,-22.78,-24.16,-24.69,-23.72,-21.44,-19.78,-17.62,-16.22,-15.06,-13.62,-12.88,-11.38,-10.56,-9.16,-7.53,-6.88,-5.22,-4.59,-5.16,-5.91,-7.72,-10.31,-12.53,-13.56,-14.62,-14.34,-14.97,-14.84,-14.62,-14.09,-14.09,-14.31,-13.91,-14.66,-14.41,-13.06,-10.09,-6.31,-1.72,3.56,7.25,8.91,10.03,9.91,7.16,4.31,1.59,-1.88,-4.81,-6.97,-9.03,-11.19,-11.66,-12.69,-13.91,-13.84,-14.84,-14.34,-13.5,-11.97,-9.31,-6.22,-2.91,-0.53,1.31,2.25,2.53,2.16,0.66,-1.03,-3.16,-4.41,-5.97,-7.34,-7.84,-10.03,-12.03,-14.22,-17.12,-19.38,-20.28,-21.41,-21.22,-21.47,-20.59,-19.03,-17.22,-15.22,-12.56,-10.47,-9.97,-8.56,-7.91,-9.53,-9.66,-11.44,-12.81,-14.81,-15.75,-16.78,-17.66,-18.59,-19.59,-20.97,-20.91,-21.31,-21.03,-20.94,-21.41,-20.88,-20.34,-18.78,-18.66,-17.09,-16.03,-16.22,-16.66,-18.09,-20.34,-22.09,-24.09,-24.44,-23.09,-20.34,-16.94,-13.22,-10.75,-10.78,-11.41,-14.75,-18.78,-22.0,-24.47,-25.22,-24.38,-23.53,-21.94,-21.81,-20.91,-21.97,-23.84,-25.53,-27.22,-29.03,-30.56,-32.47,-34.47,-36.12,-38.81,-41.41,-43.03,-44.47,-44.97,-43.47,-42.44,-41.0,-39.12,-37.72,-36.41,-35.66,-34.66,4.81,4.53,3.59,2.41,2.34,1.03:6.16,4.66,4.5,3.03,2.75,3.16,3.34,4.88,5.06,5.91,5.59,5.03,4.94,3.06,3.31,2.09,0.62,1.41,1.06,1.03,0.62,1.31,1.56,2.5,3.12,2.94,3.34,3.22,3.94,4.19,5.5,5.97,6.69,6.69,7.06,8.16,9.22,10.44,10.03,8.28,6.28,3.72,1.53,1.0,1.16,1.91,2.34,2.34,1.28,1.09,0.81,0.91,1.44,1.66,0.12,-0.22,-1.12,-4.06,-3.94,-5.03,-4.84,-4.97,-5.44,-5.72,-5.22,-5.34,-4.47,-4.28,-4.34,-4.72,-5.44,-5.88,-6.53,-6.72,-6.75,-6.91,-5.75,-2.75,-0.56,2.25,4.66,6.84,7.47,9.22,10.44,10.72,9.91,8.38,4.88,2.78,0.16,-1.97,-3.59,-5.06,-6.94,-8.06,-9.59,-9.34,-8.34,-7.28,-5.03,-2.0,-1.16,1.44,3.06,3.41,2.84,3.94,3.19,3.31,3.44,4.62,5.84,6.69,6.41,7.0,6.56,7.25,9.09,11.5,15.12,17.0,19.06,19.44,18.03,16.09,15.12,14.16,13.47,12.62,14.16,13.84,13.31,11.41,8.62,6.03,2.66,0.47,-0.66,0.19,1.56,4.25,4.97,7.66,7.94,8.28,6.62,6.81,5.94,5.44,6.47,6.75,6.88,7.47,8.38,8.75,9.75,10.41,10.91,10.91,10.75,10.0,9.25,7.72,6.81,4.84,3.12,1.0,-1.5,-3.38,-5.16,-5.84,-6.97,-5.72,-5.47,-4.34,-3.41,-2.53,-1.22,0.5,1.53,1.91,2.56,3.03,2.62,2.16,1.88,2.28,2.53,3.41,3.88,4.59,4.56,5.25,3.41,2.56,2.31,1.91,1.56,2.62,2.72,3.66,5.22,5.78,6.69,6.5,5.72,4.56,3.28,1.66,0.84,-0.22,0.28,0.56,0.81,2.38,3.03,2.62,1.88,-0.31,-0.91,-3.12,-2.91,-2.84,-0.31,2.5,5.66,9.34,11.06,13.0,12.62,10.81,8.44,5.84,3.56,2.31,1.44,1.5,1.62,2.62,2.56,2.06,1.69,0.81,-0.47,-1.38,-3.59,-5.28,-6.16,-6.53,-5.94,-3.62,-1.84,-0.12,0.97,0.47,-0.97,-3.09,-5.66,-7.81,-9.16,-10.81,-11.47,-11.41,-11.97,-11.81,-11.53,-11.81,-10.94,-9.97,-8.84,-7.59,-6.47,-4.28,-4.38,-2.03,-0.97,1.22,3.84,5.66,6.59,7.81,7.72,7.97,7.78,7.41,8.0,7.81,6.94,5.88,5.66,5.78,4.5,4.56,3.44,2.56,1.81,1.62,1.19,2.84,4.03,5.38,7.0,7.94,7.41,7.75,7.72,7.25,6.34,6.84,6.66,7.22,8.84,9.06,9.62,9.59,7.84,6.53,4.69,3.81,2.72,3.62,5.31,6.62,9.28,10.31,11.03,10.34,9.44,8.56,6.56,4.94,3.03,1.34,-0.22,-1.09,-2.69,-3.25,-4.59,-4.16,-4.53,-5.47,-5.34,-6.34,-7.16,-7.47,-7.16,-6.19,-4.06,-1.97,0.16,0.75,3.06,3.72,2.75,1.91,0.53,-1.47,-2.47,-2.03,-0.72,1.03,4.38,7.47,10.34,13.47,16.41,18.03,19.31,17.31,16.44,13.66,11.62,10.44,10.44,9.28,8.88,8.06,5.19,3.94,2.0,0.81,0.25,1.41,1.78,3.06,3.28,3.5,4.25,3.44,2.5,1.41,0.44,-0.72,-1.59,-0.59,0.84,3.22,5.19,7.69,9.66,11.22,11.94,12.69,13.66,13.31,13.97,13.19,12.72,11.31,9.69,7.69,6.41,5.0,4.31,5.12,5.59,6.12,7.22,8.0,8.06,8.56,9.09,9.72,9.78,11.28,11.5,12.56,13.03,15.25,16.5,18.25,19.16,20.56,20.94,20.84,19.94,18.44,16.91,14.91,13.84,12.69,13.94,13.25,15.84,16.31,16.44,17.31,17.19,16.38,16.06,15.81,14.47,13.72,12.69,12.0,11.03,10.62,9.91,8.0,6.81,3.31,1.16,0.28,-1.09,0.34,1.41,3.28,4.12,4.62,4.78,3.78,2.03,-0.34,-3.12,-5.94,-8.31,-9.66,-10.34,-11.22,-10.66,-10.09,-9.22,-7.72,-7.66,-7.59,-8.44,-8.22,-7.97,-8.09,-6.25,-4.16,-1.91,-1.97,-1.56,-1.41,-2.41,-4.16,-4.22,-4.44,-3.31,-1.16,0.66,2.69,3.97,5.31,5.5,5.5,4.41,3.72,1.66,0.03,-2.28,-3.59,-4.34,-3.69,-2.78,-1.94,-1.34,-1.03,-2.66,-3.88,-4.66,-6.34,-6.25,-6.16,-6.22,-6.03,-5.19,-5.84,-6.44,-6.94,-7.12,-7.09,-6.59,-5.94,-5.03,-4.97,-5.69,-5.59,-6.53,-6.75,-6.28,-5.56,-5.62,-5.34,-6.22,-7.12,-7.56,-7.88,-8.28,-7.81,-7.22,-7.56,-7.78,-8.22,-8.97,-8.69,-7.41,-5.97,-5.16,-2.56,-1.03,1.03,2.75,3.06,4.25,4.19,2.94,2.25,-0.22,-2.31,-4.53,-5.78,-6.25,-6.53,-5.22,-2.47,-2.81,-1.66,-1.56,-2.44,-3.53,-5.62,-8.62,-9.97,-11.47,-12.88,-12.84,-12.28,-11.19,-9.34,-7.41,-5.28,-3.81,-2.31,-1.53,-1.72,-2.59,-2.75,-2.03,-1.53,0.0,2.84,5.66,6.09,7.12,4.91,1.66,-1.62,-5.03,-6.69,-7.47,-6.53,-5.22,-3.56,-1.69,-0.84,-0.41,0.41,-0.28,-1.22,-2.94,-4.97,-6.34,-8.09,-8.97,-9.38,-10.0,-9.72,-11.19,-12.19,-12.5,-12.72,-13.09,-12.94,-13.84,-12.97,-12.88,-11.59,-10.47,-8.75,-7.59,-7.16,-6.97,-7.03,-6.84,-6.91,-6.16,-6.38,-5.56,-6.16,-5.91,-6.12,-6.94,-7.47,-8.09,-8.09,-8.84,-8.03,-7.44,-6.72,-5.34,-3.69,-2.31,-0.72,0.25,1.16,1.16,-0.03,-1.34,-2.94,-3.84,-5.44,-6.22,-5.09,-5.66,-6.03,-7.12,-8.72,-10.06,-11.66,-12.06,-13.0,-12.72,-12.97,-13.25,-12.88,-12.41,-12.34,-11.0,-10.5,-9.94,-9.19,-9.69,-10.34,-11.16,-13.34,-14.94,-15.59,-16.44,-16.31,-15.97,-15.19,-13.59,-13.28,-11.56,-11.72,-10.72,-9.91,-8.84,-6.94,-4.97,-3.59,-1.88,-1.22,-2.16,-3.41,-5.84,-9.34,-12.66,-17.09,-21.09,-22.78,-24.16,-24.69,-23.72,-21.44,-19.78,-17.62,-16.22,-15.06,-13.62,-12.88,-11.38,-10.56,-9.16,-7.53,-6.88,-5.22,-4.59,-5.16,-5.91,-7.72,-10.31,-12.53,-13.56,-14.62,-14.34,-14.97,-14.84,-14.62,-14.09,-14.09,-14.31,-13.91,-14.66,-14.41,-13.06,-10.09,-6.31,-1.72,3.56,7.25,8.91,10.03,9.91,7.16,4.31,1.59,-1.88,-4.81,-6.97,-9.03,-11.19,-11.66,-12.69,-13.91,-13.84,-14.84,-14.34,-13.5,-11.97,-9.31,-6.22,-2.91,-0.53,1.31,2.25,2.53,2.16,0.66,-1.03,-3.16,-4.41,-5.97,-7.34,-7.84,-10.03,-12.03,-14.22,-17.12,-19.38,-20.28,-21.41,-21.22,-21.47,-20.59,-19.03,-17.22,-15.22,-12.56,-10.47,-9.97,-8.56,-7.91,-9.53,-9.66,-11.44,-12.81,-14.81,-15.75,-16.78,-17.66,-18.59,-19.59,-20.97,-20.91,-21.31,-21.03,-20.94,-21.41,-20.88,-20.34,-18.78,-18.66,-17.09,-16.03,-16.22,-16.66,-18.09,-20.34,-22.09,-24.09,-24.44,-23.09,-20.34,-16.94,-13.22,-10.75,-10.78,-11.41,-14.75,-18.78,-22.0,-24.47,-25.22,-24.38,-23.53,-21.94,-21.81,-20.91,-21.97,-23.84,-25.53,-27.22,-29.03,-30.56,-32.47,-34.47,-36.12,-38.81,-41.41,-43.03,-44.47,-44.97,-43.47,-42.44,-41.0,-39.12,-37.72,-36.41,-35.66,-34.66,4.81,4.53,3.59,2.41,2.34,1.03,1.66,3.03,4.94,6.0,7.41,7.88:3.34,4.88,5.06,5.91,5.59,5.03,4.94,3.06,3.31,2.09,0.62,1.41,1.06,1.03,0.62,1.31,1.56,2.5,3.12,2.94,3.34,3.22,3.94,4.19,5.5,5.97,6.69,6.69,7.06,8.16,9.22,10.44,10.03,8.28,6.28,3.72,1.53,1.0,1.16,1.91,2.34,2.34,1.28,1.09,0.81,0.91,1.44,1.66,0.12,-0.22,-1.12,-4.06,-3.94,-5.03,-4.84,-4.97,-5.44,-5.72,-5.22,-5.34,-4.47,-4.28,-4.34,-4.72,-5.44,-5.88,-6.53,-6.72,-6.75,-6.91,-5.75,-2.75,-0.56,2.25,4.66,6.84,7.47,9.22,10.44,10.72,9.91,8.38,4.88,2.78,0.16,-1.97,-3.59,-5.06,-6.94,-8.06,-9.59,-9.34,-8.34,-7.28,-5.03,-2.0,-1.16,1.44,3.06,3.41,2.84,3.94,3.19,3.31,3.44,4.62,5.84,6.69,6.41,7.0,6.56,7.25,9.09,11.5,15.12,17.0,19.06,19.44,18.03,16.09,15.12,14.16,13.47,12.62,14.16,13.84,13.31,11.41,8.62,6.03,2.66,0.47,-0.66,0.19,1.56,4.25,4.97,7.66,7.94,8.28,6.62,6.81,5.94,5.44,6.47,6.75,6.88,7.47,8.38,8.75,9.75,10.41,10.91,10.91,10.75,10.0,9.25,7.72,6.81,4.84,3.12,1.0,-1.5,-3.38,-5.16,-5.84,-6.97,-5.72,-5.47,-4.34,-3.41,-2.53,-1.22,0.5,1.53,1.91,2.56,3.03,2.62,2.16,1.88,2.28,2.53,3.41,3.88,4.59,4.56,5.25,3.41,2.56,2.31,1.91,1.56,2.62,2.72,3.66,5.22,5.78,6.69,6.5,5.72,4.56,3.28,1.66,0.84,-0.22,0.28,0.56,0.81,2.38,3.03,2.62,1.88,-0.31,-0.91,-3.12,-2.91,-2.84,-0.31,2.5,5.66,9.34,11.06,13.0,12.62,10.81,8.44,5.84,3.56,2.31,1.44,1.5,1.62,2.62,2.56,2.06,1.69,0.81,-0.47,-1.38,-3.59,-5.28,-6.16,-6.53,-5.94,-3.62,-1.84,-0.12,0.97,0.47,-0.97,-3.09,-5.66,-7.81,-9.16,-10.81,-11.47,-11.41,-11.97,-11.81,-11.53,-11.81,-10.94,-9.97,-8.84,-7.59,-6.47,-4.28,-4.38,-2.03,-0.97,1.22,3.84,5.66,6.59,7.81,7.72,7.97,7.78,7.41,8.0,7.81,6.94,5.88,5.66,5.78,4.5,4.56,3.44,2.56,1.81,1.62,1.19,2.84,4.03,5.38,7.0,7.94,7.41,7.75,7.72,7.25,6.34,6.84,6.66,7.22,8.84,9.06,9.62,9.59,7.84,6.53,4.69,3.81,2.72,3.62,5.31,6.62,9.28,10.31,11.03,10.34,9.44,8.56,6.56,4.94,3.03,1.34,-0.22,-1.09,-2.69,-3.25,-4.59,-4.16,-4.53,-5.47,-5.34,-6.34,-7.16,-7.47,-7.16,-6.19,-4.06,-1.97,0.16,0.75,3.06,3.72,2.75,1.91,0.53,-1.47,-2.47,-2.03,-0.72,1.03,4.38,7.47,10.34,13.47,16.41,18.03,19.31,17.31,16.44,13.66,11.62,10.44,10.44,9.28,8.88,8.06,5.19,3.94,2.0,0.81,0.25,1.41,1.78,3.06,3.28,3.5,4.25,3.44,2.5,1.41,0.44,-0.72,-1.59,-0.59,0.84,3.22,5.19,7.69,9.66,11.22,11.94,12.69,13.66,13.31,13.97,13.19,12.72,11.31,9.69,7.69,6.41,5.0,4.31,5.12,5.59,6.12,7.22,8.0,8.06,8.56,9.09,9.72,9.78,11.28,11.5,12.56,13.03,15.25,16.5,18.25,19.16,20.56,20.94,20.84,19.94,18.44,16.91,14.91,13.84,12.69,13.94,13.25,15.84,16.31,16.44,17.31,17.19,16.38,16.06,15.81,14.47,13.72,12.69,12.0,11.03,10.62,9.91,8.0,6.81,3.31,1.16,0.28,-1.09,0.34,1.41,3.28,4.12,4.62,4.78,3.78,2.03,-0.34,-3.12,-5.94,-8.31,-9.66,-10.34,-11.22,-10.66,-10.09,-9.22,-7.72,-7.66,-7.59,-8.44,-8.22,-7.97,-8.09,-6.25,-4.16,-1.91,-1.97,-1.56,-1.41,-2.41,-4.16,-4.22,-4.44,-3.31,-1.16,0.66,2.69,3.97,5.31,5.5,5.5,4.41,3.72,1.66,0.03,-2.28,-3.59,-4.34,-3.69,-2.78,-1.94,-1.34,-1.03,-2.66,-3.88,-4.66,-6.34,-6.25,-6.16,-6.22,-6.03,-5.19,-5.84,-6.44,-6.94,-7.12,-7.09,-6.59,-5.94,-5.03,-4.97,-5.69,-5.59,-6.53,-6.75,-6.28,-5.56,-5.62,-5.34,-6.22,-7.12,-7.56,-7.88,-8.28,-7.81,-7.22,-7.56,-7.78,-8.22,-8.97,-8.69,-7.41,-5.97,-5.16,-2.56,-1.03,1.03,2.75,3.06,4.25,4.19,2.94,2.25,-0.22,-2.31,-4.53,-5.78,-6.25,-6.53,-5.22,-2.47,-2.81,-1.66,-1.56,-2.44,-3.53,-5.62,-8.62,-9.97,-11.47,-12.88,-12.84,-12.28,-11.19,-9.34,-7.41,-5.28,-3.81,-2.31,-1.53,-1.72,-2.59,-2.75,-2.03,-1.53,0.0,2.84,5.66,6.09,7.12,4.91,1.66,-1.62,-5.03,-6.69,-7.47,-6.53,-5.22,-3.56,-1.69,-0.84,-0.41,0.41,-0.28,-1.22,-2.94,-4.97,-6.34,-8.09,-8.97,-9.38,-10.0,-9.72,-11.19,-12.19,-12.5,-12.72,-13.09,-12.94,-13.84,-12.97,-12.88,-11.59,-10.47,-8.75,-7.59,-7.16,-6.97,-7.03,-6.84,-6.91,-6.16,-6.38,-5.56,-6.16,-5.91,-6.12,-6.94,-7.47,-8.09,-8.09,-8.84,-8.03,-7.44,-6.72,-5.34,-3.69,-2.31,-0.72,0.25,1.16,1.16,-0.03,-1.34,-2.94,-3.84,-5.44,-6.22,-5.09,-5.66,-6.03,-7.12,-8.72,-10.06,-11.66,-12.06,-13.0,-12.72,-12.97,-13.25,-12.88,-12.41,-12.34,-11.0,-10.5,-9.94,-9.19,-9.69,-10.34,-11.16,-13.34,-14.94,-15.59,-16.44,-16.31,-15.97,-15.19,-13.59,-13.28,-11.56,-11.72,-10.72,-9.91,-8.84,-6.94,-4.97,-3.59,-1.88,-1.22,-2.16,-3.41,-5.84,-9.34,-12.66,-17.09,-21.09,-22.78,-24.16,-24.69,-23.72,-21.44,-19.78,-17.62,-16.22,-15.06,-13.62,-12.88,-11.38,-10.56,-9.16,-7.53,-6.88,-5.22,-4.59,-5.16,-5.91,-7.72,-10.31,-12.53,-13.56,-14.62,-14.34,-14.97,-14.84,-14.62,-14.09,-14.09,-14.31,-13.91,-14.66,-14.41,-13.06,-10.09,-6.31,-1.72,3.56,7.25,8.91,10.03,9.91,7.16,4.31,1.59,-1.88,-4.81,-6.97,-9.03,-11.19,-11.66,-12.69,-13.91,-13.84,-14.84,-14.34,-13.5,-11.97,-9.31,-6.22,-2.91,-0.53,1.31,2.25,2.53,2.16,0.66,-1.03,-3.16,-4.41,-5.97,-7.34,-7.84,-10.03,-12.03,-14.22,-17.12,-19.38,-20.28,-21.41,-21.22,-21.47,-20.59,-19.03,-17.22,-15.22,-12.56,-10.47,-9.97,-8.56,-7.91,-9.53,-9.66,-11.44,-12.81,-14.81,-15.75,-16.78,-17.66,-18.59,-19.59,-20.97,-20.91,-21.31,-21.03,-20.94,-21.41,-20.88,-20.34,-18.78,-18.66,-17.09,-16.03,-16.22,-16.66,-18.09,-20.34,-22.09,-24.09,-24.44,-23.09,-20.34,-16.94,-13.22,-10.75,-10.78,-11.41,-14.75,-18.78,-22.0,-24.47,-25.22,-24.38,-23.53,-21.94,-21.81,-20.91,-21.97,-23.84,-25.53,-27.22,-29.03,-30.56,-32.47,-34.47,-36.12,-38.81,-41.41,-43.03,-44.47,-44.97,-43.47,-42.44,-41.0,-39.12,-37.72,-36.41,-35.66,-34.66,4.81,4.53,3.59,2.41,2.34,1.03,1.66,3.03,4.94,6.0,7.41,7.88,6.72,6.0,5.47,4.62,5.12,5.34:4.94,3.06,3.31,2.09,0.62,1.41,1.06,1.03,0.62,1.31,1.56,2.5,3.12,2.94,3.34,3.22,3.94,4.19,5.5,5.97,6.69,6.69,7.06,8.16,9.22,10.44,10.03,8.28,6.28,3.72,1.53,1.0,1.16,1.91,2.34,2.34,1.28,1.09,0.81,0.91,1.44,1.66,0.12,-0.22,-1.12,-4.06,-3.94,-5.03,-4.84,-4.97,-5.44,-5.72,-5.22,-5.34,-4.47,-4.28,-4.34,-4.72,-5.44,-5.88,-6.53,-6.72,-6.75,-6.91,-5.75,-2.75,-0.56,2.25,4.66,6.84,7.47,9.22,10.44,10.72,9.91,8.38,4.88,2.78,0.16,-1.97,-3.59,-5.06,-6.94,-8.06,-9.59,-9.34,-8.34,-7.28,-5.03,-2.0,-1.16,1.44,3.06,3.41,2.84,3.94,3.19,3.31,3.44,4.62,5.84,6.69,6.41,7.0,6.56,7.25,9.09,11.5,15.12,17.0,19.06,19.44,18.03,16.09,15.12,14.16,13.47,12.62,14.16,13.84,13.31,11.41,8.62,6.03,2.66,0.47,-0.66,0.19,1.56,4.25,4.97,7.66,7.94,8.28,6.62,6.81,5.94,5.44,6.47,6.75,6.88,7.47,8.38,8.75,9.75,10.41,10.91,10.91,10.75,10.0,9.25,7.72,6.81,4.84,3.12,1.0,-1.5,-3.38,-5.16,-5.84,-6.97,-5.72,-5.47,-4.34,-3.41,-2.53,-1.22,0.5,1.53,1.91,2.56,3.03,2.62,2.16,1.88,2.28,2.53,3.41,3.88,4.59,4.56,5.25,3.41,2.56,2.31,1.91,1.56,2.62,2.72,3.66,5.22,5.78,6.69,6.5,5.72,4.56,3.28,1.66,0.84,-0.22,0.28,0.56,0.81,2.38,3.03,2.62,1.88,-0.31,-0.91,-3.12,-2.91,-2.84,-0.31,2.5,5.66,9.34,11.06,13.0,12.62,10.81,8.44,5.84,3.56,2.31,1.44,1.5,1.62,2.62,2.56,2.06,1.69,0.81,-0.47,-1.38,-3.59,-5.28,-6.16,-6.53,-5.94,-3.62,-1.84,-0.12,0.97,0.47,-0.97,-3.09,-5.66,-7.81,-9.16,-10.81,-11.47,-11.41,-11.97,-11.81,-11.53,-11.81,-10.94,-9.97,-8.84,-7.59,-6.47,-4.28,-4.38,-2.03,-0.97,1.22,3.84,5.66,6.59,7.81,7.72,7.97,7.78,7.41,8.0,7.81,6.94,5.88,5.66,5.78,4.5,4.56,3.44,2.56,1.81,1.62,1.19,2.84,4.03,5.38,7.0,7.94,7.41,7.75,7.72,7.25,6.34,6.84,6.66,7.22,8.84,9.06,9.62,9.59,7.84,6.53,4.69,3.81,2.72,3.62,5.31,6.62,9.28,10.31,11.03,10.34,9.44,8.56,6.56,4.94,3.03,1.34,-0.22,-1.09,-2.69,-3.25,-4.59,-4.16,-4.53,-5.47,-5.34,-6.34,-7.16,-7.47,-7.16,-6.19,-4.06,-1.97,0.16,0.75,3.06,3.72,2.75,1.91,0.53,-1.47,-2.47,-2.03,-0.72,1.03,4.38,7.47,10.34,13.47,16.41,18.03,19.31,17.31,16.44,13.66,11.62,10.44,10.44,9.28,8.88,8.06,5.19,3.94,2.0,0.81,0.25,1.41,1.78,3.06,3.28,3.5,4.25,3.44,2.5,1.41,0.44,-0.72,-1.59,-0.59,0.84,3.22,5.19,7.69,9.66,11.22,11.94,12.69,13.66,13.31,13.97,13.19,12.72,11.31,9.69,7.69,6.41,5.0,4.31,5.12,5.59,6.12,7.22,8.0,8.06,8.56,9.09,9.72,9.78,11.28,11.5,12.56,13.03,15.25,16.5,18.25,19.16,20.56,20.94,20.84,19.94,18.44,16.91,14.91,13.84,12.69,13.94,13.25,15.84,16.31,16.44,17.31,17.19,16.38,16.06,15.81,14.47,13.72,12.69,12.0,11.03,10.62,9.91,8.0,6.81,3.31,1.16,0.28,-1.09,0.34,1.41,3.28,4.12,4.62,4.78,3.78,2.03,-0.34,-3.12,-5.94,-8.31,-9.66,-10.34,-11.22,-10.66,-10.09,-9.22,-7.72,-7.66,-7.59,-8.44,-8.22,-7.97,-8.09,-6.25,-4.16,-1.91,-1.97,-1.56,-1.41,-2.41,-4.16,-4.22,-4.44,-3.31,-1.16,0.66,2.69,3.97,5.31,5.5,5.5,4.41,3.72,1.66,0.03,-2.28,-3.59,-4.34,-3.69,-2.78,-1.94,-1.34,-1.03,-2.66,-3.88,-4.66,-6.34,-6.25,-6.16,-6.22,-6.03,-5.19,-5.84,-6.44,-6.94,-7.12,-7.09,-6.59,-5.94,-5.03,-4.97,-5.69,-5.59,-6.53,-6.75,-6.28,-5.56,-5.62,-5.34,-6.22,-7.12,-7.56,-7.88,-8.28,-7.81,-7.22,-7.56,-7.78,-8.22,-8.97,-8.69,-7.41,-5.97,-5.16,-2.56,-1.03,1.03,2.75,3.06,4.25,4.19,2.94,2.25,-0.22,-2.31,-4.53,-5.78,-6.25,-6.53,-5.22,-2.47,-2.81,-1.66,-1.56,-2.44,-3.53,-5.62,-8.62,-9.97,-11.47,-12.88,-12.84,-12.28,-11.19,-9.34,-7.41,-5.28,-3.81,-2.31,-1.53,-1.72,-2.59,-2.75,-2.03,-1.53,0.0,2.84,5.66,6.09,7.12,4.91,1.66,-1.62,-5.03,-6.69,-7.47,-6.53,-5.22,-3.56,-1.69,-0.84,-0.41,0.41,-0.28,-1.22,-2.94,-4.97,-6.34,-8.09,-8.97,-9.38,-10.0,-9.72,-11.19,-12.19,-12.5,-12.72,-13.09,-12.94,-13.84,-12.97,-12.88,-11.59,-10.47,-8.75,-7.59,-7.16,-6.97,-7.03,-6.84,-6.91,-6.16,-6.38,-5.56,-6.16,-5.91,-6.12,-6.94,-7.47,-8.09,-8.09,-8.84,-8.03,-7.44,-6.72,-5.34,-3.69,-2.31,-0.72,0.25,1.16,1.16,-0.03,-1.34,-2.94,-3.84,-5.44,-6.22,-5.09,-5.66,-6.03,-7.12,-8.72,-10.06,-11.66,-12.06,-13.0,-12.72,-12.97,-13.25,-12.88,-12.41,-12.34,-11.0,-10.5,-9.94,-9.19,-9.69,-10.34,-11.16,-13.34,-14.94,-15.59,-16.44,-16.31,-15.97,-15.19,-13.59,-13.28,-11.56,-11.72,-10.72,-9.91,-8.84,-6.94,-4.97,-3.59,-1.88,-1.22,-2.16,-3.41,-5.84,-9.34,-12.66,-17.09,-21.09,-22.78,-24.16,-24.69,-23.72,-21.44,-19.78,-17.62,-16.22,-15.06,-13.62,-12.88,-11.38,-10.56,-9.16,-7.53,-6.88,-5.22,-4.59,-5.16,-5.91,-7.72,-10.31,-12.53,-13.56,-14.62,-14.34,-14.97,-14.84,-14.62,-14.09,-14.09,-14.31,-13.91,-14.66,-14.41,-13.06,-10.09,-6.31,-1.72,3.56,7.25,8.91,10.03,9.91,7.16,4.31,1.59,-1.88,-4.81,-6.97,-9.03,-11.19,-11.66,-12.69,-13.91,-13.84,-14.84,-14.34,-13.5,-11.97,-9.31,-6.22,-2.91,-0.53,1.31,2.25,2.53,2.16,0.66,-1.03,-3.16,-4.41,-5.97,-7.34,-7.84,-10.03,-12.03,-14.22,-17.12,-19.38,-20.28,-21.41,-21.22,-21.47,-20.59,-19.03,-17.22,-15.22,-12.56,-10.47,-9.97,-8.56,-7.91,-9.53,-9.66,-11.44,-12.81,-14.81,-15.75,-16.78,-17.66,-18.59,-19.59,-20.97,-20.91,-21.31,-21.03,-20.94,-21.41,-20.88,-20.34,-18.78,-18.66,-17.09,-16.03,-16.22,-16.66,-18.09,-20.34,-22.09,-24.09,-24.44,-23.09,-20.34,-16.94,-13.22,-10.75,-10.78,-11.41,-14.75,-18.78,-22.0,-24.47,-25.22,-24.38,-23.53,-21.94,-21.81,-20.91,-21.97,-23.84,-25.53,-27.22,-29.03,-30.56,-32.47,-34.47,-36.12,-38.81,-41.41,-43.03,-44.47,-44.97,-43.47,-42.44,-41.0,-39.12,-37.72,-36.41,-35.66,-34.66,4.81,4.53,3.59,2.41,2.34,1.03,1.66,3.03,4.94,6.0,7.41,7.88,6.72,6.0,5.47,4.62,5.12,5.34,6.62,7.16,6.81,6.81,6.0,4.66:1.06,1.03,0.62,1.31,1.56,2.5,3.12,2.94,3.34,3.22,3.94,4.19,5.5,5.97,6.69,6.69,7.06,8.16,9.22,10.44,10.03,8.28,6.28,3.72,1.53,1.0,1.16,1.91,2.34,2.34,1.28,1.09,0.81,0.91,1.44,1.66,0.12,-0.22,-1.12,-4.06,-3.94,-5.03,-4.84,-4.97,-5.44,-5.72,-5.22,-5.34,-4.47,-4.28,-4.34,-4.72,-5.44,-5.88,-6.53,-6.72,-6.75,-6.91,-5.75,-2.75,-0.56,2.25,4.66,6.84,7.47,9.22,10.44,10.72,9.91,8.38,4.88,2.78,0.16,-1.97,-3.59,-5.06,-6.94,-8.06,-9.59,-9.34,-8.34,-7.28,-5.03,-2.0,-1.16,1.44,3.06,3.41,2.84,3.94,3.19,3.31,3.44,4.62,5.84,6.69,6.41,7.0,6.56,7.25,9.09,11.5,15.12,17.0,19.06,19.44,18.03,16.09,15.12,14.16,13.47,12.62,14.16,13.84,13.31,11.41,8.62,6.03,2.66,0.47,-0.66,0.19,1.56,4.25,4.97,7.66,7.94,8.28,6.62,6.81,5.94,5.44,6.47,6.75,6.88,7.47,8.38,8.75,9.75,10.41,10.91,10.91,10.75,10.0,9.25,7.72,6.81,4.84,3.12,1.0,-1.5,-3.38,-5.16,-5.84,-6.97,-5.72,-5.47,-4.34,-3.41,-2.53,-1.22,0.5,1.53,1.91,2.56,3.03,2.62,2.16,1.88,2.28,2.53,3.41,3.88,4.59,4.56,5.25,3.41,2.56,2.31,1.91,1.56,2.62,2.72,3.66,5.22,5.78,6.69,6.5,5.72,4.56,3.28,1.66,0.84,-0.22,0.28,0.56,0.81,2.38,3.03,2.62,1.88,-0.31,-0.91,-3.12,-2.91,-2.84,-0.31,2.5,5.66,9.34,11.06,13.0,12.62,10.81,8.44,5.84,3.56,2.31,1.44,1.5,1.62,2.62,2.56,2.06,1.69,0.81,-0.47,-1.38,-3.59,-5.28,-6.16,-6.53,-5.94,-3.62,-1.84,-0.12,0.97,0.47,-0.97,-3.09,-5.66,-7.81,-9.16,-10.81,-11.47,-11.41,-11.97,-11.81,-11.53,-11.81,-10.94,-9.97,-8.84,-7.59,-6.47,-4.28,-4.38,-2.03,-0.97,1.22,3.84,5.66,6.59,7.81,7.72,7.97,7.78,7.41,8.0,7.81,6.94,5.88,5.66,5.78,4.5,4.56,3.44,2.56,1.81,1.62,1.19,2.84,4.03,5.38,7.0,7.94,7.41,7.75,7.72,7.25,6.34,6.84,6.66,7.22,8.84,9.06,9.62,9.59,7.84,6.53,4.69,3.81,2.72,3.62,5.31,6.62,9.28,10.31,11.03,10.34,9.44,8.56,6.56,4.94,3.03,1.34,-0.22,-1.09,-2.69,-3.25,-4.59,-4.16,-4.53,-5.47,-5.34,-6.34,-7.16,-7.47,-7.16,-6.19,-4.06,-1.97,0.16,0.75,3.06,3.72,2.75,1.91,0.53,-1.47,-2.47,-2.03,-0.72,1.03,4.38,7.47,10.34,13.47,16.41,18.03,19.31,17.31,16.44,13.66,11.62,10.44,10.44,9.28,8.88,8.06,5.19,3.94,2.0,0.81,0.25,1.41,1.78,3.06,3.28,3.5,4.25,3.44,2.5,1.41,0.44,-0.72,-1.59,-0.59,0.84,3.22,5.19,7.69,9.66,11.22,11.94,12.69,13.66,13.31,13.97,13.19,12.72,11.31,9.69,7.69,6.41,5.0,4.31,5.12,5.59,6.12,7.22,8.0,8.06,8.56,9.09,9.72,9.78,11.28,11.5,12.56,13.03,15.25,16.5,18.25,19.16,20.56,20.94,20.84,19.94,18.44,16.91,14.91,13.84,12.69,13.94,13.25,15.84,16.31,16.44,17.31,17.19,16.38,16.06,15.81,14.47,13.72,12.69,12.0,11.03,10.62,9.91,8.0,6.81,3.31,1.16,0.28,-1.09,0.34,1.41,3.28,4.12,4.62,4.78,3.78,2.03,-0.34,-3.12,-5.94,-8.31,-9.66,-10.34,-11.22,-10.66,-10.09,-9.22,-7.72,-7.66,-7.59,-8.44,-8.22,-7.97,-8.09,-6.25,-4.16,-1.91,-1.97,-1.56,-1.41,-2.41,-4.16,-4.22,-4.44,-3.31,-1.16,0.66,2.69,3.97,5.31,5.5,5.5,4.41,3.72,1.66,0.03,-2.28,-3.59,-4.34,-3.69,-2.78,-1.94,-1.34,-1.03,-2.66,-3.88,-4.66,-6.34,-6.25,-6.16,-6.22,-6.03,-5.19,-5.84,-6.44,-6.94,-7.12,-7.09,-6.59,-5.94,-5.03,-4.97,-5.69,-5.59,-6.53,-6.75,-6.28,-5.56,-5.62,-5.34,-6.22,-7.12,-7.56,-7.88,-8.28,-7.81,-7.22,-7.56,-7.78,-8.22,-8.97,-8.69,-7.41,-5.97,-5.16,-2.56,-1.03,1.03,2.75,3.06,4.25,4.19,2.94,2.25,-0.22,-2.31,-4.53,-5.78,-6.25,-6.53,-5.22,-2.47,-2.81,-1.66,-1.56,-2.44,-3.53,-5.62,-8.62,-9.97,-11.47,-12.88,-12.84,-12.28,-11.19,-9.34,-7.41,-5.28,-3.81,-2.31,-1.53,-1.72,-2.59,-2.75,-2.03,-1.53,0.0,2.84,5.66,6.09,7.12,4.91,1.66,-1.62,-5.03,-6.69,-7.47,-6.53,-5.22,-3.56,-1.69,-0.84,-0.41,0.41,-0.28,-1.22,-2.94,-4.97,-6.34,-8.09,-8.97,-9.38,-10.0,-9.72,-11.19,-12.19,-12.5,-12.72,-13.09,-12.94,-13.84,-12.97,-12.88,-11.59,-10.47,-8.75,-7.59,-7.16,-6.97,-7.03,-6.84,-6.91,-6.16,-6.38,-5.56,-6.16,-5.91,-6.12,-6.94,-7.47,-8.09,-8.09,-8.84,-8.03,-7.44,-6.72,-5.34,-3.69,-2.31,-0.72,0.25,1.16,1.16,-0.03,-1.34,-2.94,-3.84,-5.44,-6.22,-5.09,-5.66,-6.03,-7.12,-8.72,-10.06,-11.66,-12.06,-13.0,-12.72,-12.97,-13.25,-12.88,-12.41,-12.34,-11.0,-10.5,-9.94,-9.19,-9.69,-10.34,-11.16,-13.34,-14.94,-15.59,-16.44,-16.31,-15.97,-15.19,-13.59,-13.28,-11.56,-11.72,-10.72,-9.91,-8.84,-6.94,-4.97,-3.59,-1.88,-1.22,-2.16,-3.41,-5.84,-9.34,-12.66,-17.09,-21.09,-22.78,-24.16,-24.69,-23.72,-21.44,-19.78,-17.62,-16.22,-15.06,-13.62,-12.88,-11.38,-10.56,-9.16,-7.53,-6.88,-5.22,-4.59,-5.16,-5.91,-7.72,-10.31,-12.53,-13.56,-14.62,-14.34,-14.97,-14.84,-14.62,-14.09,-14.09,-14.31,-13.91,-14.66,-14.41,-13.06,-10.09,-6.31,-1.72,3.56,7.25,8.91,10.03,9.91,7.16,4.31,1.59,-1.88,-4.81,-6.97,-9.03,-11.19,-11.66,-12.69,-13.91,-13.84,-14.84,-14.34,-13.5,-11.97,-9.31,-6.22,-2.91,-0.53,1.31,2.25,2.53,2.16,0.66,-1.03,-3.16,-4.41,-5.97,-7.34,-7.84,-10.03,-12.03,-14.22,-17.12,-19.38,-20.28,-21.41,-21.22,-21.47,-20.59,-19.03,-17.22,-15.22,-12.56,-10.47,-9.97,-8.56,-7.91,-9.53,-9.66,-11.44,-12.81,-14.81,-15.75,-16.78,-17.66,-18.59,-19.59,-20.97,-20.91,-21.31,-21.03,-20.94,-21.41,-20.88,-20.34,-18.78,-18.66,-17.09,-16.03,-16.22,-16.66,-18.09,-20.34,-22.09,-24.09,-24.44,-23.09,-20.34,-16.94,-13.22,-10.75,-10.78,-11.41,-14.75,-18.78,-22.0,-24.47,-25.22,-24.38,-23.53,-21.94,-21.81,-20.91,-21.97,-23.84,-25.53,-27.22,-29.03,-30.56,-32.47,-34.47,-36.12,-38.81,-41.41,-43.03,-44.47,-44.97,-43.47,-42.44,-41.0,-39.12,-37.72,-36.41,-35.66,-34.66,4.81,4.53,3.59,2.41,2.34,1.03,1.66,3.03,4.94,6.0,7.41,7.88,6.72,6.0,5.47,4.62,5.12,5.34,6.62,7.16,6.81,6.81,6.0,4.66,4.41,3.62,4.09,4.94,4.81,5.34:negativity
1.09,2.91,4.72,5.59,7.06,10.41,12.97,16.41,20.22,23.5,26.0,29.25,29.78,28.91,27.69,22.97,16.66,11.47,6.06,1.69,-0.97,-1.25,-1.69,0.09,2.84,5.81,8.16,10.41,12.91,13.59,14.47,13.81,13.31,12.25,12.12,11.38,11.25,12.66,14.19,14.62,15.09,16.19,18.5,18.44,18.34,17.56,16.62,16.56,18.78,20.5,24.44,27.81,30.97,31.81,33.44,34.88,35.41,33.84,32.41,30.91,27.88,25.75,24.41,22.34,21.06,19.16,16.66,13.53,12.03,10.28,10.22,10.41,12.84,15.09,17.53,20.91,23.56,25.31,26.56,27.81,28.84,29.25,30.69,30.25,30.44,29.44,28.44,27.66,26.22,27.34,27.0,26.66,26.25,26.5,25.97,25.78,26.5,28.56,30.5,33.03,35.94,36.56,37.06,35.62,35.88,33.38,31.88,30.5,28.94,27.66,26.25,23.78,22.34,20.31,18.66,16.91,16.75,16.81,17.53,18.94,21.16,23.31,25.12,27.34,28.5,29.91,30.25,30.12,29.72,29.03,27.62,26.03,25.16,22.38,20.75,18.91,17.44,15.91,16.06,15.62,16.91,17.81,19.94,22.16,23.19,25.03,25.5,27.09,27.53,27.44,27.16,27.5,26.78,27.34,28.53,29.16,28.38,28.34,26.91,25.09,22.84,22.19,21.72,21.72,22.56,23.19,24.19,24.56,26.03,27.38,28.25,31.47,32.69,33.38,32.94,31.31,30.75,28.97,28.34,27.41,27.62,27.0,28.38,28.38,29.09,28.75,27.53,24.91,23.88,22.56,22.56,24.88,24.16,26.34,28.78,31.06,33.28,34.81,35.88,35.53,35.22,35.62,35.25,35.53,34.81,33.75,33.88,32.81,31.5,31.25,30.72,28.12,26.44,24.69,22.56,21.72,20.5,20.44,21.66,23.81,26.06,29.38,33.31,35.12,36.25,36.03,35.69,33.56,32.75,30.94,29.12,27.81,26.94,25.78,24.78,25.56,24.16,24.0,23.69,22.62,21.38,21.25,23.28,27.06,32.16,39.28,44.06,49.78,51.56,51.91,50.47,47.31,43.78,39.81,36.0,32.59,30.91,31.16,32.19,32.16,32.12,31.41,30.78,27.31,27.06,27.75,28.12,29.91,32.16,31.69,31.91,31.19,30.09,29.31,28.72,29.16,29.19,30.0,30.59,32.06,33.44,35.97,37.53,38.94,40.03,40.12,39.81,39.41,38.38,37.81,35.81,33.81,31.62,29.31,28.09,26.69,27.78,27.62,28.84,29.62,30.72,31.47,32.5,32.66,33.56,32.84,33.0,32.41,29.31,30.41,28.38,26.81,25.88,25.19,24.81,22.94,21.84,20.12,18.75,19.31,20.44,22.81,27.38,29.94,32.56,35.38,36.03,37.03,37.16,36.31,34.69,34.12,33.66,33.81,33.81,34.22,33.81,32.31,31.31,30.5,28.31,27.75,27.44,27.94,27.62,29.0,29.0,30.09,29.47,29.03,28.66,27.03,27.16,25.81,25.06,23.44,23.44,23.06,23.75,24.56,24.91,25.03,25.84,24.31,24.16,24.56,24.28,25.31,27.12,27.78,28.19,30.19,29.88,29.19,26.5,25.53,23.34,20.22,18.81,17.94,17.47,17.28,17.41,15.06,15.16,13.16,12.19,12.09,12.91,14.06,14.81,17.28,17.25,16.22,15.06,14.03,13.25,13.34,13.47,15.34,16.31,17.53,17.25,17.97,17.69,17.34,15.56,15.69,14.31,14.72,13.56,14.31,13.81,13.28,13.12,12.28,12.47,12.56,12.94,13.06,14.28,13.72,14.56,13.47,15.69,16.25,17.94,21.09,21.88,23.5,23.56,22.31,21.81,21.62,21.34,21.5,22.12,22.97,23.69,24.62,23.81,23.81,23.81,23.56,22.84,23.28,22.81,21.81,21.72,19.53,18.28,16.62,15.72,15.25,14.5,15.12,15.78,15.06,15.72,14.03,13.94,12.56,12.41,12.88,13.72,15.44,17.12,19.19,19.84,17.62,15.56,12.19,8.81,6.84,5.44,6.78,8.03,9.53,11.56,12.81,14.53,16.06,17.44,17.44,18.0,17.41,17.06,16.06,15.0,14.19,13.28,13.41,13.28,12.59,13.69,14.16,14.56,15.53,17.5,17.0,17.72,19.25,18.88,20.72,22.81,24.69,24.91,25.53,24.75,25.66,25.31,25.16,25.69,24.78,24.56,23.97,23.94,25.28,27.38,29.66,30.78,31.25,29.44,27.12,24.75,22.69,21.62,22.38,23.69,25.69,27.34,29.0,29.31,29.5,29.78,26.81,26.19,23.41,20.0,16.91,13.78,13.06,12.38,14.5,15.69,17.38,17.44,17.28,16.34,15.53,15.81,15.78,16.94,17.75,18.31,18.81,17.53,16.16,15.25,14.09,13.0,12.66,13.53,13.78,14.16,14.75,14.59,14.5,13.44,12.75,11.44,9.66,8.88,7.91,7.94,8.53,9.22,9.03,9.47,8.66,8.94,9.41,9.62,9.66,9.88,10.0,9.66,10.06,10.81,12.19,13.81,14.84,15.66,16.12,15.91,16.97,18.09,18.81,20.62,21.91,21.72,21.41,21.16,21.09,22.16,22.56,23.53,24.31,24.19,25.31,26.16,27.56,28.5,30.12,30.62,31.19,30.5,29.91,28.44,27.72,26.5,23.66,22.31,20.75,19.16,17.5,17.12,17.0,17.28,17.94,18.12,19.34,21.06,21.62,22.78,24.56,25.09,26.16,27.16,28.25,27.81,27.25,26.22,25.41,23.53,21.91,21.53,21.5,20.31,20.62,18.72,17.84,16.44,14.47,14.22,13.94,14.0,15.94,16.25,17.62,18.78,19.75,20.5,19.62,20.69,19.31,17.25,15.91,13.31,10.16,8.28,6.22,6.0,4.81,5.16,5.66,5.66,6.72,8.59,8.38,9.06,9.69,9.62,10.38,11.91,15.34,20.84,26.44,30.31,32.44,32.38,28.81,23.94,19.0,14.06,10.78,8.44,6.91,5.19,5.12,4.44,4.72,4.16,5.41,6.03,6.75,7.56,8.19,10.16,11.25,13.38,15.47,15.72,17.12,15.88,15.16,15.31,15.5,16.88,18.41,19.06,19.38,18.41,17.19,16.19,14.78,12.41,11.78,10.62,9.91,9.16,9.69,10.5,10.81,11.34,11.78,12.06,12.69,14.16,15.56,16.88,18.16,19.09,19.41,20.19,20.0,19.41,19.44,18.56,17.19,16.41,15.84,15.62,14.41,15.12,16.91,19.16,21.81,25.31,28.78,30.22,30.53,30.56,28.31,25.97,23.41,21.62,20.41,19.53,20.5,20.38,21.12,21.84,20.84,19.03,17.44,14.97,12.94,11.34,9.94,9.88,10.59,11.56,13.84,15.62,16.62,16.78,14.91,13.09,10.25,8.91,8.06,9.0,7.97,8.41,9.12,8.94,7.94,7.25,5.97,4.06,1.16,-0.78,-3.62,-4.91,-6.5,-8.03,-10.16,-10.34,-11.91,-12.78,-13.09,-14.06,-16.25,-17.06,-18.41,-17.94,-18.5,-18.09,-17.34,-17.19,-16.31,-16.38,-15.91,-15.41,-14.81,-13.03,-10.75,-8.31,-6.47,-5.34,-4.97,-5.59,-4.91,-5.41,-5.81,-5.28,-4.78,-5.28,-5.22,-6.5,-6.34,-6.44,-6.97,-6.78,-6.41,-6.44,-5.88,-4.28,-4.22,-2.72,-1.5,0.38,1.12,1.69,2.44,1.81,0.41,-0.91,-2.38,-4.41,-5.88,-6.28,-6.38,-4.91,-3.97,-0.56,1.12,3.72,6.0,8.0,9.41,11.72,12.25,11.75,10.78,9.34,8.69,8.69,9.16,10.06,10.12,8.53,5.53,2.12,-1.22,-4.84,-7.0,-8.28,-9.16,-8.03,-6.97,-4.34,-1.5,0.31,4.16:12.97,16.41,20.22,23.5,26.0,29.25,29.78,28.91,27.69,22.97,16.66,11.47,6.06,1.69,-0.97,-1.25,-1.69,0.09,2.84,5.81,8.16,10.41,12.91,13.59,14.47,13.81,13.31,12.25,12.12,11.38,11.25,12.66,14.19,14.62,15.09,16.19,18.5,18.44,18.34,17.56,16.62,16.56,18.78,20.5,24.44,27.81,30.97,31.81,33.44,34.88,35.41,33.84,32.41,30.91,27.88,25.75,24.41,22.34,21.06,19.16,16.66,13.53,12.03,10.28,10.22,10.41,12.84,15.09,17.53,20.91,23.56,25.31,26.56,27.81,28.84,29.25,30.69,30.25,30.44,29.44,28.44,27.66,26.22,27.34,27.0,26.66,26.25,26.5,25.97,25.78,26.5,28.56,30.5,33.03,35.94,36.56,37.06,35.62,35.88,33.38,31.88,30.5,28.94,27.66,26.25,23.78,22.34,20.31,18.66,16.91,16.75,16.81,17.53,18.94,21.16,23.31,25.12,27.34,28.5,29.91,30.25,30.12,29.72,29.03,27.62,26.03,25.16,22.38,20.75,18.91,17.44,15.91,16.06,15.62,16.91,17.81,19.94,22.16,23.19,25.03,25.5,27.09,27.53,27.44,27.16,27.5,26.78,27.34,28.53,29.16,28.38,28.34,26.91,25.09,22.84,22.19,21.72,21.72,22.56,23.19,24.19,24.56,26.03,27.38,28.25,31.47,32.69,33.38,32.94,31.31,30.75,28.97,28.34,27.41,27.62,27.0,28.38,28.38,29.09,28.75,27.53,24.91,23.88,22.56,22.56,24.88,24.16,26.34,28.78,31.06,33.28,34.81,35.88,35.53,35.22,35.62,35.25,35.53,34.81,33.75,33.88,32.81,31.5,31.25,30.72,28.12,26.44,24.69,22.56,21.72,20.5,20.44,21.66,23.81,26.06,29.38,33.31,35.12,36.25,36.03,35.69,33.56,32.75,30.94,29.12,27.81,26.94,25.78,24.78,25.56,24.16,24.0,23.69,22.62,21.38,21.25,23.28,27.06,32.16,39.28,44.06,49.78,51.56,51.91,50.47,47.31,43.78,39.81,36.0,32.59,30.91,31.16,32.19,32.16,32.12,31.41,30.78,27.31,27.06,27.75,28.12,29.91,32.16,31.69,31.91,31.19,30.09,29.31,28.72,29.16,29.19,30.0,30.59,32.06,33.44,35.97,37.53,38.94,40.03,40.12,39.81,39.41,38.38,37.81,35.81,33.81,31.62,29.31,28.09,26.69,27.78,27.62,28.84,29.62,30.72,31.47,32.5,32.66,33.56,32.84,33.0,32.41,29.31,30.41,28.38,26.81,25.88,25.19,24.81,22.94,21.84,20.12,18.75,19.31,20.44,22.81,27.38,29.94,32.56,35.38,36.03,37.03,37.16,36.31,34.69,34.12,33.66,33.81,33.81,34.22,33.81,32.31,31.31,30.5,28.31,27.75,27.44,27.94,27.62,29.0,29.0,30.09,29.47,29.03,28.66,27.03,27.16,25.81,25.06,23.44,23.44,23.06,23.75,24.56,24.91,25.03,25.84,24.31,24.16,24.56,24.28,25.31,27.12,27.78,28.19,30.19,29.88,29.19,26.5,25.53,23.34,20.22,18.81,17.94,17.47,17.28,17.41,15.06,15.16,13.16,12.19,12.09,12.91,14.06,14.81,17.28,17.25,16.22,15.06,14.03,13.25,13.34,13.47,15.34,16.31,17.53,17.25,17.97,17.69,17.34,15.56,15.69,14.31,14.72,13.56,14.31,13.81,13.28,13.12,12.28,12.47,12.56,12.94,13.06,14.28,13.72,14.56,13.47,15.69,16.25,17.94,21.09,21.88,23.5,23.56,22.31,21.81,21.62,21.34,21.5,22.12,22.97,23.69,24.62,23.81,23.81,23.81,23.56,22.84,23.28,22.81,21.81,21.72,19.53,18.28,16.62,15.72,15.25,14.5,15.12,15.78,15.06,15.72,14.03,13.94,12.56,12.41,12.88,13.72,15.44,17.12,19.19,19.84,17.62,15.56,12.19,8.81,6.84,5.44,6.78,8.03,9.53,11.56,12.81,14.53,16.06,17.44,17.44,18.0,17.41,17.06,16.06,15.0,14.19,13.28,13.41,13.28,12.59,13.69,14.16,14.56,15.53,17.5,17.0,17.72,19.25,18.88,20.72,22.81,24.69,24.91,25.53,24.75,25.66,25.31,25.16,25.69,24.78,24.56,23.97,23.94,25.28,27.38,29.66,30.78,31.25,29.44,27.12,24.75,22.69,21.62,22.38,23.69,25.69,27.34,29.0,29.31,29.5,29.78,26.81,26.19,23.41,20.0,16.91,13.78,13.06,12.38,14.5,15.69,17.38,17.44,17.28,16.34,15.53,15.81,15.78,16.94,17.75,18.31,18.81,17.53,16.16,15.25,14.09,13.0,12.66,13.53,13.78,14.16,14.75,14.59,14.5,13.44,12.75,11.44,9.66,8.88,7.91,7.94,8.53,9.22,9.03,9.47,8.66,8.94,9.41,9.62,9.66,9.88,10.0,9.66,10.06,10.81,12.19,13.81,14.84,15.66,16.12,15.91,16.97,18.09,18.81,20.62,21.91,21.72,21.41,21.16,21.09,22.16,22.56,23.53,24.31,24.19,25.31,26.16,27.56,28.5,30.12,30.62,31.19,30.5,29.91,28.44,27.72,26.5,23.66,22.31,20.75,19.16,17.5,17.12,17.0,17.28,17.94,18.12,19.34,21.06,21.62,22.78,24.56,25.09,26.16,27.16,28.25,27.81,27.25,26.22,25.41,23.53,21.91,21.53,21.5,20.31,20.62,18.72,17.84,16.44,14.47,14.22,13.94,14.0,15.94,16.25,17.62,18.78,19.75,20.5,19.62,20.69,19.31,17.25,15.91,13.31,10.16,8.28,6.22,6.0,4.81,5.16,5.66,5.66,6.72,8.59,8.38,9.06,9.69,9.62,10.38,11.91,15.34,20.84,26.44,30.31,32.44,32.38,28.81,23.94,19.0,14.06,10.78,8.44,6.91,5.19,5.12,4.44,4.72,4.16,5.41,6.03,6.75,7.56,8.19,10.16,11.25,13.38,15.47,15.72,17.12,15.88,15.16,15.31,15.5,16.88,18.41,19.06,19.38,18.41,17.19,16.19,14.78,12.41,11.78,10.62,9.91,9.16,9.69,10.5,10.81,11.34,11.78,12.06,12.69,14.16,15.56,16.88,18.16,19.09,19.41,20.19,20.0,19.41,19.44,18.56,17.19,16.41,15.84,15.62,14.41,15.12,16.91,19.16,21.81,25.31,28.78,30.22,30.53,30.56,28.31,25.97,23.41,21.62,20.41,19.53,20.5,20.38,21.12,21.84,20.84,19.03,17.44,14.97,12.94,11.34,9.94,9.88,10.59,11.56,13.84,15.62,16.62,16.78,14.91,13.09,10.25,8.91,8.06,9.0,7.97,8.41,9.12,8.94,7.94,7.25,5.97,4.06,1.16,-0.78,-3.62,-4.91,-6.5,-8.03,-10.16,-10.34,-11.91,-12.78,-13.09,-14.06,-16.25,-17.06,-18.41,-17.94,-18.5,-18.09,-17.34,-17.19,-16.31,-16.38,-15.91,-15.41,-14.81,-13.03,-10.75,-8.31,-6.47,-5.34,-4.97,-5.59,-4.91,-5.41,-5.81,-5.28,-4.78,-5.28,-5.22,-6.5,-6.34,-6.44,-6.97,-6.78,-6.41,-6.44,-5.88,-4.28,-4.22,-2.72,-1.5,0.38,1.12,1.69,2.44,1.81,0.41,-0.91,-2.38,-4.41,-5.88,-6.28,-6.38,-4.91,-3.97,-0.56,1.12,3.72,6.0,8.0,9.41,11.72,12.25,11.75,10.78,9.34,8.69,8.69,9.16,10.06,10.12,8.53,5.53,2.12,-1.22,-4.84,-7.0,-8.28,-9.16,-8.03,-6.97,-4.34,-1.5,0.31,4.16,9.72,10.38,10.44,11.91,11.34,14.34:29.78,28.91,27.69,22.97,16.66,11.47,6.06,1.69,-0.97,-1.25,-1.69,0.09,2.84,5.81,8.16,10.41,12.91,13.59,14.47,13.81,13.31,12.25,12.12,11.38,11.25,12.66,14.19,14.62,15.09,16.19,18.5,18.44,18.34,17.56,16.62,16.56,18.78,20.5,24.44,27.81,30.97,31.81,33.44,34.88,35.41,33.84,32.41,30.91,27.88,25.75,24.41,22.34,21.06,19.16,16.66,13.53,12.03,10.28,10.22,10.41,12.84,15.09,17.53,20.91,23.56,25.31,26.56,27.81,28.84,29.25,30.69,30.25,30.44,29.44,28.44,27.66,26.22,27.34,27.0,26.66,26.25,26.5,25.97,25.78,26.5,28.56,30.5,33.03,35.94,36.56,37.06,35.62,35.88,33.38,31.88,30.5,28.94,27.66,26.25,23.78,22.34,20.31,18.66,16.91,16.75,16.81,17.53,18.94,21.16,23.31,25.12,27.34,28.5,29.91,30.25,30.12,29.72,29.03,27.62,26.03,25.16,22.38,20.75,18.91,17.44,15.91,16.06,15.62,16.91,17.81,19.94,22.16,23.19,25.03,25.5,27.09,27.53,27.44,27.16,27.5,26.78,27.34,28.53,29.16,28.38,28.34,26.91,25.09,22.84,22.19,21.72,21.72,22.56,23.19,24.19,24.56,26.03,27.38,28.25,31.47,32.69,33.38,32.94,31.31,30.75,28.97,28.34,27.41,27.62,27.0,28.38,28.38,29.09,28.75,27.53,24.91,23.88,22.56,22.56,24.88,24.16,26.34,28.78,31.06,33.28,34.81,35.88,35.53,35.22,35.62,35.25,35.53,34.81,33.75,33.88,32.81,31.5,31.25,30.72,28.12,26.44,24.69,22.56,21.72,20.5,20.44,21.66,23.81,26.06,29.38,33.31,35.12,36.25,36.03,35.69,33.56,32.75,30.94,29.12,27.81,26.94,25.78,24.78,25.56,24.16,24.0,23.69,22.62,21.38,21.25,23.28,27.06,32.16,39.28,44.06,49.78,51.56,51.91,50.47,47.31,43.78,39.81,36.0,32.59,30.91,31.16,32.19,32.16,32.12,31.41,30.78,27.31,27.06,27.75,28.12,29.91,32.16,31.69,31.91,31.19,30.09,29.31,28.72,29.16,29.19,30.0,30.59,32.06,33.44,35.97,37.53,38.94,40.03,40.12,39.81,39.41,38.38,37.81,35.81,33.81,31.62,29.31,28.09,26.69,27.78,27.62,28.84,29.62,30.72,31.47,32.5,32.66,33.56,32.84,33.0,32.41,29.31,30.41,28.38,26.81,25.88,25.19,24.81,22.94,21.84,20.12,18.75,19.31,20.44,22.81,27.38,29.94,32.56,35.38,36.03,37.03,37.16,36.31,34.69,34.12,33.66,33.81,33.81,34.22,33.81,32.31,31.31,30.5,28.31,27.75,27.44,27.94,27.62,29.0,29.0,30.09,29.47,29.03,28.66,27.03,27.16,25.81,25.06,23.44,23.44,23.06,23.75,24.56,24.91,25.03,25.84,24.31,24.16,24.56,24.28,25.31,27.12,27.78,28.19,30.19,29.88,29.19,26.5,25.53,23.34,20.22,18.81,17.94,17.47,17.28,17.41,15.06,15.16,13.16,12.19,12.09,12.91,14.06,14.81,17.28,17.25,16.22,15.06,14.03,13.25,13.34,13.47,15.34,16.31,17.53,17.25,17.97,17.69,17.34,15.56,15.69,14.31,14.72,13.56,14.31,13.81,13.28,13.12,12.28,12.47,12.56,12.94,13.06,14.28,13.72,14.56,13.47,15.69,16.25,17.94,21.09,21.88,23.5,23.56,22.31,21.81,21.62,21.34,21.5,22.12,22.97,23.69,24.62,23.81,23.81,23.81,23.56,22.84,23.28,22.81,21.81,21.72,19.53,18.28,16.62,15.72,15.25,14.5,15.12,15.78,15.06,15.72,14.03,13.94,12.56,12.41,12.88,13.72,15.44,17.12,19.19,19.84,17.62,15.56,12.19,8.81,6.84,5.44,6.78,8.03,9.53,11.56,12.81,14.53,16.06,17.44,17.44,18.0,17.41,17.06,16.06,15.0,14.19,13.28,13.41,13.28,12.59,13.69,14.16,14.56,15.53,17.5,17.0,17.72,19.25,18.88,20.72,22.81,24.69,24.91,25.53,24.75,25.66,25.31,25.16,25.69,24.78,24.56,23.97,23.94,25.28,27.38,29.66,30.78,31.25,29.44,27.12,24.75,22.69,21.62,22.38,23.69,25.69,27.34,29.0,29.31,29.5,29.78,26.81,26.19,23.41,20.0,16.91,13.78,13.06,12.38,14.5,15.69,17.38,17.44,17.28,16.34,15.53,15.81,15.78,16.94,17.75,18.31,18.81,17.53,16.16,15.25,14.09,13.0,12.66,13.53,13.78,14.16,14.75,14.59,14.5,13.44,12.75,11.44,9.66,8.88,7.91,7.94,8.53,9.22,9.03,9.47,8.66,8.94,9.41,9.62,9.66,9.88,10.0,9.66,10.06,10.81,12.19,13.81,14.84,15.66,16.12,15.91,16.97,18.09,18.81,20.62,21.91,21.72,21.41,21.16,21.09,22.16,22.56,23.53,24.31,24.19,25.31,26.16,27.56,28.5,30.12,30.62,31.19,30.5,29.91,28.44,27.72,26.5,23.66,22.31,20.75,19.16,17.5,17.12,17.0,17.28,17.94,18.12,19.34,21.06,21.62,22.78,24.56,25.09,26.16,27.16,28.25,27.81,27.25,26.22,25.41,23.53,21.91,21.53,21.5,20.31,20.62,18.72,17.84,16.44,14.47,14.22,13.94,14.0,15.94,16.25,17.62,18.78,19.75,20.5,19.62,20.69,19.31,17.25,15.91,13.31,10.16,8.28,6.22,6.0,4.81,5.16,5.66,5.66,6.72,8.59,8.38,9.06,9.69,9.62,10.38,11.91,15.34,20.84,26.44,30.31,32.44,32.38,28.81,23.94,19.0,14.06,10.78,8.44,6.91,5.19,5.12,4.44,4.72,4.16,5.41,6.03,6.75,7.56,8.19,10.16,11.25,13.38,15.47,15.72,17.12,15.88,15.16,15.31,15.5,16.88,18.41,19.06,19.38,18.41,17.19,16.19,14.78,12.41,11.78,10.62,9.91,9.16,9.69,10.5,10.81,11.34,11.78,12.06,12.69,14.16,15.56,16.88,18.16,19.09,19.41,20.19,20.0,19.41,19.44,18.56,17.19,16.41,15.84,15.62,14.41,15.12,16.91,19.16,21.81,25.31,28.78,30.22,30.53,30.56,28.31,25.97,23.41,21.62,20.41,19.53,20.5,20.38,21.12,21.84,20.84,19.03,17.44,14.97,12.94,11.34,9.94,9.88,10.59,11.56,13.84,15.62,16.62,16.78,14.91,13.09,10.25,8.91,8.06,9.0,7.97,8.41,9.12,8.94,7.94,7.25,5.97,4.06,1.16,-0.78,-3.62,-4.91,-6.5,-8.03,-10.16,-10.34,-11.91,-12.78,-13.09,-14.06,-16.25,-17.06,-18.41,-17.94,-18.5,-18.09,-17.34,-17.19,-16.31,-16.38,-15.91,-15.41,-14.81,-13.03,-10.75,-8.31,-6.47,-5.34,-4.97,-5.59,-4.91,-5.41,-5.81,-5.28,-4.78,-5.28,-5.22,-6.5,-6.34,-6.44,-6.97,-6.78,-6.41,-6.44,-5.88,-4.28,-4.22,-2.72,-1.5,0.38,1.12,1.69,2.44,1.81,0.41,-0.91,-2.38,-4.41,-5.88,-6.28,-6.38,-4.91,-3.97,-0.56,1.12,3.72,6.0,8.0,9.41,11.72,12.25,11.75,10.78,9.34,8.69,8.69,9.16,10.06,10.12,8.53,5.53,2.12,-1.22,-4.84,-7.0,-8.28,-9.16,-8.03,-6.97,-4.34,-1.5,0.31,4.16,9.72,10.38,10.44,11.91,11.34,14.34,15.72,17.91,18.84,17.59,15.88,12.34:6.06,1.69,-0.97,-1.25,-1.69,0.09,2.84,5.81,8.16,10.41,12.91,13.59,14.47,13.81,13.31,12.25,12.12,11.38,11.25,12.66,14.19,14.62,15.09,16.19,18.5,18.44,18.34,17.56,16.62,16.56,18.78,20.5,24.44,27.81,30.97,31.81,33.44,34.88,35.41,33.84,32.41,30.91,27.88,25.75,24.41,22.34,21.06,19.16,16.66,13.53,12.03,10.28,10.22,10.41,12.84,15.09,17.53,20.91,23.56,25.31,26.56,27.81,28.84,29.25,30.69,30.25,30.44,29.44,28.44,27.66,26.22,27.34,27.0,26.66,26.25,26.5,25.97,25.78,26.5,28.56,30.5,33.03,35.94,36.56,37.06,35.62,35.88,33.38,31.88,30.5,28.94,27.66,26.25,23.78,22.34,20.31,18.66,16.91,16.75,16.81,17.53,18.94,21.16,23.31,25.12,27.34,28.5,29.91,30.25,30.12,29.72,29.03,27.62,26.03,25.16,22.38,20.75,18.91,17.44,15.91,16.06,15.62,16.91,17.81,19.94,22.16,23.19,25.03,25.5,27.09,27.53,27.44,27.16,27.5,26.78,27.34,28.53,29.16,28.38,28.34,26.91,25.09,22.84,22.19,21.72,21.72,22.56,23.19,24.19,24.56,26.03,27.38,28.25,31.47,32.69,33.38,32.94,31.31,30.75,28.97,28.34,27.41,27.62,27.0,28.38,28.38,29.09,28.75,27.53,24.91,23.88,22.56,22.56,24.88,24.16,26.34,28.78,31.06,33.28,34.81,35.88,35.53,35.22,35.62,35.25,35.53,34.81,33.75,33.88,32.81,31.5,31.25,30.72,28.12,26.44,24.69,22.56,21.72,20.5,20.44,21.66,23.81,26.06,29.38,33.31,35.12,36.25,36.03,35.69,33.56,32.75,30.94,29.12,27.81,26.94,25.78,24.78,25.56,24.16,24.0,23.69,22.62,21.38,21.25,23.28,27.06,32.16,39.28,44.06,49.78,51.56,51.91,50.47,47.31,43.78,39.81,36.0,32.59,30.91,31.16,32.19,32.16,32.12,31.41,30.78,27.31,27.06,27.75,28.12,29.91,32.16,31.69,31.91,31.19,30.09,29.31,28.72,29.16,29.19,30.0,30.59,32.06,33.44,35.97,37.53,38.94,40.03,40.12,39.81,39.41,38.38,37.81,35.81,33.81,31.62,29.31,28.09,26.69,27.78,27.62,28.84,29.62,30.72,31.47,32.5,32.66,33.56,32.84,33.0,32.41,29.31,30.41,28.38,26.81,25.88,25.19,24.81,22.94,21.84,20.12,18.75,19.31,20.44,22.81,27.38,29.94,32.56,35.38,36.03,37.03,37.16,36.31,34.69,34.12,33.66,33.81,33.81,34.22,33.81,32.31,31.31,30.5,28.31,27.75,27.44,27.94,27.62,29.0,29.0,30.09,29.47,29.03,28.66,27.03,27.16,25.81,25.06,23.44,23.44,23.06,23.75,24.56,24.91,25.03,25.84,24.31,24.16,24.56,24.28,25.31,27.12,27.78,28.19,30.19,29.88,29.19,26.5,25.53,23.34,20.22,18.81,17.94,17.47,17.28,17.41,15.06,15.16,13.16,12.19,12.09,12.91,14.06,14.81,17.28,17.25,16.22,15.06,14.03,13.25,13.34,13.47,15.34,16.31,17.53,17.25,17.97,17.69,17.34,15.56,15.69,14.31,14.72,13.56,14.31,13.81,13.28,13.12,12.28,12.47,12.56,12.94,13.06,14.28,13.72,14.56,13.47,15.69,16.25,17.94,21.09,21.88,23.5,23.56,22.31,21.81,21.62,21.34,21.5,22.12,22.97,23.69,24.62,23.81,23.81,23.81,23.56,22.84,23.28,22.81,21.81,21.72,19.53,18.28,16.62,15.72,15.25,14.5,15.12,15.78,15.06,15.72,14.03,13.94,12.56,12.41,12.88,13.72,15.44,17.12,19.19,19.84,17.62,15.56,12.19,8.81,6.84,5.44,6.78,8.03,9.53,11.56,12.81,14.53,16.06,17.44,17.44,18.0,17.41,17.06,16.06,15.0,14.19,13.28,13.41,13.28,12.59,13.69,14.16,14.56,15.53,17.5,17.0,17.72,19.25,18.88,20.72,22.81,24.69,24.91,25.53,24.75,25.66,25.31,25.16,25.69,24.78,24.56,23.97,23.94,25.28,27.38,29.66,30.78,31.25,29.44,27.12,24.75,22.69,21.62,22.38,23.69,25.69,27.34,29.0,29.31,29.5,29.78,26.81,26.19,23.41,20.0,16.91,13.78,13.06,12.38,14.5,15.69,17.38,17.44,17.28,16.34,15.53,15.81,15.78,16.94,17.75,18.31,18.81,17.53,16.16,15.25,14.09,13.0,12.66,13.53,13.78,14.16,14.75,14.59,14.5,13.44,12.75,11.44,9.66,8.88,7.91,7.94,8.53,9.22,9.03,9.47,8.66,8.94,9.41,9.62,9.66,9.88,10.0,9.66,10.06,10.81,12.19,13.81,14.84,15.66,16.12,15.91,16.97,18.09,18.81,20.62,21.91,21.72,21.41,21.16,21.09,22.16,22.56,23.53,24.31,24.19,25.31,26.16,27.56,28.5,30.12,30.62,31.19,30.5,29.91,28.44,27.72,26.5,23.66,22.31,20.75,19.16,17.5,17.12,17.0,17.28,17.94,18.12,19.34,21.06,21.62,22.78,24.56,25.09,26.16,27.16,28.25,27.81,27.25,26.22,25.41,23.53,21.91,21.53,21.5,20.31,20.62,18.72,17.84,16.44,14.47,14.22,13.94,14.0,15.94,16.25,17.62,18.78,19.75,20.5,19.62,20.69,19.31,17.25,15.91,13.31,10.16,8.28,6.22,6.0,4.81,5.16,5.66,5.66,6.72,8.59,8.38,9.06,9.69,9.62,10.38,11.91,15.34,20.84,26.44,30.31,32.44,32.38,28.81,23.94,19.0,14.06,10.78,8.44,6.91,5.19,5.12,4.44,4.72,4.16,5.41,6.03,6.75,7.56,8.19,10.16,11.25,13.38,15.47,15.72,17.12,15.88,15.16,15.31,15.5,16.88,18.41,19.06,19.38,18.41,17.19,16.19,14.78,12.41,11.78,10.62,9.91,9.16,9.69,10.5,10.81,11.34,11.78,12.06,12.69,14.16,15.56,16.88,18.16,19.09,19.41,20.19,20.0,19.41,19.44,18.56,17.19,16.41,15.84,15.62,14.41,15.12,16.91,19.16,21.81,25.31,28.78,30.22,30.53,30.56,28.31,25.97,23.41,21.62,20.41,19.53,20.5,20.38,21.12,21.84,20.84,19.03,17.44,14.97,12.94,11.34,9.94,9.88,10.59,11.56,13.84,15.62,16.62,16.78,14.91,13.09,10.25,8.91,8.06,9.0,7.97,8.41,9.12,8.94,7.94,7.25,5.97,4.06,1.16,-0.78,-3.62,-4.91,-6.5,-8.03,-10.16,-10.34,-11.91,-12.78,-13.09,-14.06,-16.25,-17.06,-18.41,-17.94,-18.5,-18.09,-17.34,-17.19,-16.31,-16.38,-15.91,-15.41,-14.81,-13.03,-10.75,-8.31,-6.47,-5.34,-4.97,-5.59,-4.91,-5.41,-5.81,-5.28,-4.78,-5.28,-5.22,-6.5,-6.34,-6.44,-6.97,-6.78,-6.41,-6.44,-5.88,-4.28,-4.22,-2.72,-1.5,0.38,1.12,1.69,2.44,1.81,0.41,-0.91,-2.38,-4.41,-5.88,-6.28,-6.38,-4.91,-3.97,-0.56,1.12,3.72,6.0,8.0,9.41,11.72,12.25,11.75,10.78,9.34,8.69,8.69,9.16,10.06,10.12,8.53,5.53,2.12,-1.22,-4.84,-7.0,-8.28,-9.16,-8.03,-6.97,-4.34,-1.5,0.31,4.16,9.72,10.38,10.44,11.91,11.34,14.34,15.72,17.91,18.84,17.59,15.88,12.34,8.16,4.66,1.28,-0.47,-1.66,-1.59:2.84,5.81,8.16,10.41,12.91,13.59,14.47,13.81,13.31,12.25,12.12,11.38,11.25,12.66,14.19,14.62,15.09,16.19,18.5,18.44,18.34,17.56,16.62,16.56,18.78,20.5,24.44,27.81,30.97,31.81,33.44,34.88,35.41,33.84,32.41,30.91,27.88,25.75,24.41,22.34,21.06,19.16,16.66,13.53,12.03,10.28,10.22,10.41,12.84,15.09,17.53,20.91,23.56,25.31,26.56,27.81,28.84,29.25,30.69,30.25,30.44,29.44,28.44,27.66,26.22,27.34,27.0,26.66,26.25,26.5,25.97,25.78,26.5,28.56,30.5,33.03,35.94,36.56,37.06,35.62,35.88,33.38,31.88,30.5,28.94,27.66,26.25,23.78,22.34,20.31,18.66,16.91,16.75,16.81,17.53,18.94,21.16,23.31,25.12,27.34,28.5,29.91,30.25,30.12,29.72,29.03,27.62,26.03,25.16,22.38,20.75,18.91,17.44,15.91,16.06,15.62,16.91,17.81,19.94,22.16,23.19,25.03,25.5,27.09,27.53,27.44,27.16,27.5,26.78,27.34,28.53,29.16,28.38,28.34,26.91,25.09,22.84,22.19,21.72,21.72,22.56,23.19,24.19,24.56,26.03,27.38,28.25,31.47,32.69,33.38,32.94,31.31,30.75,28.97,28.34,27.41,27.62,27.0,28.38,28.38,29.09,28.75,27.53,24.91,23.88,22.56,22.56,24.88,24.16,26.34,28.78,31.06,33.28,34.81,35.88,35.53,35.22,35.62,35.25,35.53,34.81,33.75,33.88,32.81,31.5,31.25,30.72,28.12,26.44,24.69,22.56,21.72,20.5,20.44,21.66,23.81,26.06,29.38,33.31,35.12,36.25,36.03,35.69,33.56,32.75,30.94,29.12,27.81,26.94,25.78,24.78,25.56,24.16,24.0,23.69,22.62,21.38,21.25,23.28,27.06,32.16,39.28,44.06,49.78,51.56,51.91,50.47,47.31,43.78,39.81,36.0,32.59,30.91,31.16,32.19,32.16,32.12,31.41,30.78,27.31,27.06,27.75,28.12,29.91,32.16,31.69,31.91,31.19,30.09,29.31,28.72,29.16,29.19,30.0,30.59,32.06,33.44,35.97,37.53,38.94,40.03,40.12,39.81,39.41,38.38,37.81,35.81,33.81,31.62,29.31,28.09,26.69,27.78,27.62,28.84,29.62,30.72,31.47,32.5,32.66,33.56,32.84,33.0,32.41,29.31,30.41,28.38,26.81,25.88,25.19,24.81,22.94,21.84,20.12,18.75,19.31,20.44,22.81,27.38,29.94,32.56,35.38,36.03,37.03,37.16,36.31,34.69,34.12,33.66,33.81,33.81,34.22,33.81,32.31,31.31,30.5,28.31,27.75,27.44,27.94,27.62,29.0,29.0,30.09,29.47,29.03,28.66,27.03,27.16,25.81,25.06,23.44,23.44,23.06,23.75,24.56,24.91,25.03,25.84,24.31,24.16,24.56,24.28,25.31,27.12,27.78,28.19,30.19,29.88,29.19,26.5,25.53,23.34,20.22,18.81,17.94,17.47,17.28,17.41,15.06,15.16,13.16,12.19,12.09,12.91,14.06,14.81,17.28,17.25,16.22,15.06,14.03,13.25,13.34,13.47,15.34,16.31,17.53,17.25,17.97,17.69,17.34,15.56,15.69,14.31,14.72,13.56,14.31,13.81,13.28,13.12,12.28,12.47,12.56,12.94,13.06,14.28,13.72,14.56,13.47,15.69,16.25,17.94,21.09,21.88,23.5,23.56,22.31,21.81,21.62,21.34,21.5,22.12,22.97,23.69,24.62,23.81,23.81,23.81,23.56,22.84,23.28,22.81,21.81,21.72,19.53,18.28,16.62,15.72,15.25,14.5,15.12,15.78,15.06,15.72,14.03,13.94,12.56,12.41,12.88,13.72,15.44,17.12,19.19,19.84,17.62,15.56,12.19,8.81,6.84,5.44,6.78,8.03,9.53,11.56,12.81,14.53,16.06,17.44,17.44,18.0,17.41,17.06,16.06,15.0,14.19,13.28,13.41,13.28,12.59,13.69,14.16,14.56,15.53,17.5,17.0,17.72,19.25,18.88,20.72,22.81,24.69,24.91,25.53,24.75,25.66,25.31,25.16,25.69,24.78,24.56,23.97,23.94,25.28,27.38,29.66,30.78,31.25,29.44,27.12,24.75,22.69,21.62,22.38,23.69,25.69,27.34,29.0,29.31,29.5,29.78,26.81,26.19,23.41,20.0,16.91,13.78,13.06,12.38,14.5,15.69,17.38,17.44,17.28,16.34,15.53,15.81,15.78,16.94,17.75,18.31,18.81,17.53,16.16,15.25,14.09,13.0,12.66,13.53,13.78,14.16,14.75,14.59,14.5,13.44,12.75,11.44,9.66,8.88,7.91,7.94,8.53,9.22,9.03,9.47,8.66,8.94,9.41,9.62,9.66,9.88,10.0,9.66,10.06,10.81,12.19,13.81,14.84,15.66,16.12,15.91,16.97,18.09,18.81,20.62,21.91,21.72,21.41,21.16,21.09,22.16,22.56,23.53,24.31,24.19,25.31,26.16,27.56,28.5,30.12,30.62,31.19,30.5,29.91,28.44,27.72,26.5,23.66,22.31,20.75,19.16,17.5,17.12,17.0,17.28,17.94,18.12,19.34,21.06,21.62,22.78,24.56,25.09,26.16,27.16,28.25,27.81,27.25,26.22,25.41,23.53,21.91,21.53,21.5,20.31,20.62,18.72,17.84,16.44,14.47,14.22,13.94,14.0,15.94,16.25,17.62,18.78,19.75,20.5,19.62,20.69,19.31,17.25,15.91,13.31,10.16,8.28,6.22,6.0,4.81,5.16,5.66,5.66,6.72,8.59,8.38,9.06,9.69,9.62,10.38,11.91,15.34,20.84,26.44,30.31,32.44,32.38,28.81,23.94,19.0,14.06,10.78,8.44,6.91,5.19,5.12,4.44,4.72,4.16,5.41,6.03,6.75,7.56,8.19,10.16,11.25,13.38,15.47,15.72,17.12,15.88,15.16,15.31,15.5,16.88,18.41,19.06,19.38,18.41,17.19,16.19,14.78,12.41,11.78,10.62,9.91,9.16,9.69,10.5,10.81,11.34,11.78,12.06,12.69,14.16,15.56,16.88,18.16,19.09,19.41,20.19,20.0,19.41,19.44,18.56,17.19,16.41,15.84,15.62,14.41,15.12,16.91,19.16,21.81,25.31,28.78,30.22,30.53,30.56,28.31,25.97,23.41,21.62,20.41,19.53,20.5,20.38,21.12,21.84,20.84,19.03,17.44,14.97,12.94,11.34,9.94,9.88,10.59,11.56,13.84,15.62,16.62,16.78,14.91,13.09,10.25,8.91,8.06,9.0,7.97,8.41,9.12,8.94,7.94,7.25,5.97,4.06,1.16,-0.78,-3.62,-4.91,-6.5,-8.03,-10.16,-10.34,-11.91,-12.78,-13.09,-14.06,-16.25,-17.06,-18.41,-17.94,-18.5,-18.09,-17.34,-17.19,-16.31,-16.38,-15.91,-15.41,-14.81,-13.03,-10.75,-8.31,-6.47,-5.34,-4.97,-5.59,-4.91,-5.41,-5.81,-5.28,-4.78,-5.28,-5.22,-6.5,-6.34,-6.44,-6.97,-6.78,-6.41,-6.44,-5.88,-4.28,-4.22,-2.72,-1.5,0.38,1.12,1.69,2.44,1.81,0.41,-0.91,-2.38,-4.41,-5.88,-6.28,-6.38,-4.91,-3.97,-0.56,1.12,3.72,6.0,8.0,9.41,11.72,12.25,11.75,10.78,9.34,8.69,8.69,9.16,10.06,10.12,8.53,5.53,2.12,-1.22,-4.84,-7.0,-8.28,-9.16,-8.03,-6.97,-4.34,-1.5,0.31,4.16,9.72,10.38,10.44,11.91,11.34,14.34,15.72,17.91,18.84,17.59,15.88,12.34,8.16,4.66,1.28,-0.47,-1.66,-1.59,-1.03,0.16,3.12,5.94,7.44,10.44:14.47,13.81,13.31,12.25,12.12,11.38,11.25,12.66,14.19,14.62,15.09,16.19,18.5,18.44,18.34,17.56,16.62,16.56,18.78,20.5,24.44,27.81,30.97,31.81,33.44,34.88,35.41,33.84,32.41,30.91,27.88,25.75,24.41,22.34,21.06,19.16,16.66,13.53,12.03,10.28,10.22,10.41,12.84,15.09,17.53,20.91,23.56,25.31,26.56,27.81,28.84,29.25,30.69,30.25,30.44,29.44,28.44,27.66,26.22,27.34,27.0,26.66,26.25,26.5,25.97,25.78,26.5,28.56,30.5,33.03,35.94,36.56,37.06,35.62,35.88,33.38,31.88,30.5,28.94,27.66,26.25,23.78,22.34,20.31,18.66,16.91,16.75,16.81,17.53,18.94,21.16,23.31,25.12,27.34,28.5,29.91,30.25,30.12,29.72,29.03,27.62,26.03,25.16,22.38,20.75,18.91,17.44,15.91,16.06,15.62,16.91,17.81,19.94,22.16,23.19,25.03,25.5,27.09,27.53,27.44,27.16,27.5,26.78,27.34,28.53,29.16,28.38,28.34,26.91,25.09,22.84,22.19,21.72,21.72,22.56,23.19,24.19,24.56,26.03,27.38,28.25,31.47,32.69,33.38,32.94,31.31,30.75,28.97,28.34,27.41,27.62,27.0,28.38,28.38,29.09,28.75,27.53,24.91,23.88,22.56,22.56,24.88,24.16,26.34,28.78,31.06,33.28,34.81,35.88,35.53,35.22,35.62,35.25,35.53,34.81,33.75,33.88,32.81,31.5,31.25,30.72,28.12,26.44,24.69,22.56,21.72,20.5,20.44,21.66,23.81,26.06,29.38,33.31,35.12,36.25,36.03,35.69,33.56,32.75,30.94,29.12,27.81,26.94,25.78,24.78,25.56,24.16,24.0,23.69,22.62,21.38,21.25,23.28,27.06,32.16,39.28,44.06,49.78,51.56,51.91,50.47,47.31,43.78,39.81,36.0,32.59,30.91,31.16,32.19,32.16,32.12,31.41,30.78,27.31,27.06,27.75,28.12,29.91,32.16,31.69,31.91,31.19,30.09,29.31,28.72,29.16,29.19,30.0,30.59,32.06,33.44,35.97,37.53,38.94,40.03,40.12,39.81,39.41,38.38,37.81,35.81,33.81,31.62,29.31,28.09,26.69,27.78,27.62,28.84,29.62,30.72,31.47,32.5,32.66,33.56,32.84,33.0,32.41,29.31,30.41,28.38,26.81,25.88,25.19,24.81,22.94,21.84,20.12,18.75,19.31,20.44,22.81,27.38,29.94,32.56,35.38,36.03,37.03,37.16,36.31,34.69,34.12,33.66,33.81,33.81,34.22,33.81,32.31,31.31,30.5,28.31,27.75,27.44,27.94,27.62,29.0,29.0,30.09,29.47,29.03,28.66,27.03,27.16,25.81,25.06,23.44,23.44,23.06,23.75,24.56,24.91,25.03,25.84,24.31,24.16,24.56,24.28,25.31,27.12,27.78,28.19,30.19,29.88,29.19,26.5,25.53,23.34,20.22,18.81,17.94,17.47,17.28,17.41,15.06,15.16,13.16,12.19,12.09,12.91,14.06,14.81,17.28,17.25,16.22,15.06,14.03,13.25,13.34,13.47,15.34,16.31,17.53,17.25,17.97,17.69,17.34,15.56,15.69,14.31,14.72,13.56,14.31,13.81,13.28,13.12,12.28,12.47,12.56,12.94,13.06,14.28,13.72,14.56,13.47,15.69,16.25,17.94,21.09,21.88,23.5,23.56,22.31,21.81,21.62,21.34,21.5,22.12,22.97,23.69,24.62,23.81,23.81,23.81,23.56,22.84,23.28,22.81,21.81,21.72,19.53,18.28,16.62,15.72,15.25,14.5,15.12,15.78,15.06,15.72,14.03,13.94,12.56,12.41,12.88,13.72,15.44,17.12,19.19,19.84,17.62,15.56,12.19,8.81,6.84,5.44,6.78,8.03,9.53,11.56,12.81,14.53,16.06,17.44,17.44,18.0,17.41,17.06,16.06,15.0,14.19,13.28,13.41,13.28,12.59,13.69,14.16,14.56,15.53,17.5,17.0,17.72,19.25,18.88,20.72,22.81,24.69,24.91,25.53,24.75,25.66,25.31,25.16,25.69,24.78,24.56,23.97,23.94,25.28,27.38,29.66,30.78,31.25,29.44,27.12,24.75,22.69,21.62,22.38,23.69,25.69,27.34,29.0,29.31,29.5,29.78,26.81,26.19,23.41,20.0,16.91,13.78,13.06,12.38,14.5,15.69,17.38,17.44,17.28,16.34,15.53,15.81,15.78,16.94,17.75,18.31,18.81,17.53,16.16,15.25,14.09,13.0,12.66,13.53,13.78,14.16,14.75,14.59,14.5,13.44,12.75,11.44,9.66,8.88,7.91,7.94,8.53,9.22,9.03,9.47,8.66,8.94,9.41,9.62,9.66,9.88,10.0,9.66,10.06,10.81,12.19,13.81,14.84,15.66,16.12,15.91,16.97,18.09,18.81,20.62,21.91,21.72,21.41,21.16,21.09,22.16,22.56,23.53,24.31,24.19,25.31,26.16,27.56,28.5,30.12,30.62,31.19,30.5,29.91,28.44,27.72,26.5,23.66,22.31,20.75,19.16,17.5,17.12,17.0,17.28,17.94,18.12,19.34,21.06,21.62,22.78,24.56,25.09,26.16,27.16,28.25,27.81,27.25,26.22,25.41,23.53,21.91,21.53,21.5,20.31,20.62,18.72,17.84,16.44,14.47,14.22,13.94,14.0,15.94,16.25,17.62,18.78,19.75,20.5,19.62,20.69,19.31,17.25,15.91,13.31,10.16,8.28,6.22,6.0,4.81,5.16,5.66,5.66,6.72,8.59,8.38,9.06,9.69,9.62,10.38,11.91,15.34,20.84,26.44,30.31,32.44,32.38,28.81,23.94,19.0,14.06,10.78,8.44,6.91,5.19,5.12,4.44,4.72,4.16,5.41,6.03,6.75,7.56,8.19,10.16,11.25,13.38,15.47,15.72,17.12,15.88,15.16,15.31,15.5,16.88,18.41,19.06,19.38,18.41,17.19,16.19,14.78,12.41,11.78,10.62,9.91,9.16,9.69,10.5,10.81,11.34,11.78,12.06,12.69,14.16,15.56,16.88,18.16,19.09,19.41,20.19,20.0,19.41,19.44,18.56,17.19,16.41,15.84,15.62,14.41,15.12,16.91,19.16,21.81,25.31,28.78,30.22,30.53,30.56,28.31,25.97,23.41,21.62,20.41,19.53,20.5,20.38,21.12,21.84,20.84,19.03,17.44,14.97,12.94,11.34,9.94,9.88,10.59,11.56,13.84,15.62,16.62,16.78,14.91,13.09,10.25,8.91,8.06,9.0,7.97,8.41,9.12,8.94,7.94,7.25,5.97,4.06,1.16,-0.78,-3.62,-4.91,-6.5,-8.03,-10.16,-10.34,-11.91,-12.78,-13.09,-14.06,-16.25,-17.06,-18.41,-17.94,-18.5,-18.09,-17.34,-17.19,-16.31,-16.38,-15.91,-15.41,-14.81,-13.03,-10.75,-8.31,-6.47,-5.34,-4.97,-5.59,-4.91,-5.41,-5.81,-5.28,-4.78,-5.28,-5.22,-6.5,-6.34,-6.44,-6.97,-6.78,-6.41,-6.44,-5.88,-4.28,-4.22,-2.72,-1.5,0.38,1.12,1.69,2.44,1.81,0.41,-0.91,-2.38,-4.41,-5.88,-6.28,-6.38,-4.91,-3.97,-0.56,1.12,3.72,6.0,8.0,9.41,11.72,12.25,11.75,10.78,9.34,8.69,8.69,9.16,10.06,10.12,8.53,5.53,2.12,-1.22,-4.84,-7.0,-8.28,-9.16,-8.03,-6.97,-4.34,-1.5,0.31,4.16,9.72,10.38,10.44,11.91,11.34,14.34,15.72,17.91,18.84,17.59,15.88,12.34,8.16,4.66,1.28,-0.47,-1.66,-1.59,-1.03,0.16,3.12,5.94,7.44,10.44,12.0,13.84,14.81,16.25,17.41,16.94:negativity
23.53,23.78,23.69,23.66,25.25,25.56,25.66,25.56,25.31,25.38,24.91,25.56,27.91,28.31,28.84,29.25,28.53,26.78,24.81,23.44,21.38,20.88,21.12,21.94,23.97,26.69,28.12,29.16,29.75,29.5,28.69,28.16,28.75,28.09,27.25,25.91,24.0,22.75,22.81,22.59,24.06,26.25,28.78,31.78,34.47,37.0,38.41,39.41,38.69,38.81,38.41,36.78,36.44,34.69,33.94,32.72,31.44,30.66,28.31,25.84,24.31,22.62,21.09,21.5,21.62,21.78,22.28,21.47,20.28,19.0,17.03,14.31,12.97,12.41,13.31,14.22,16.69,18.19,19.12,19.41,20.38,19.62,20.12,20.69,21.53,23.34,25.66,28.19,31.09,33.25,33.69,34.66,34.03,34.44,35.0,36.41,37.78,37.56,37.38,35.69,32.5,29.94,27.81,26.41,25.19,24.78,25.03,24.97,25.25,27.31,29.06,31.44,34.56,35.78,35.75,35.66,33.72,32.69,31.97,32.34,32.66,34.78,36.66,36.94,37.69,37.84,38.53,38.84,37.81,37.06,35.75,35.94,36.38,36.97,38.84,39.69,39.53,37.84,36.44,33.62,31.62,29.5,27.69,26.94,26.69,26.34,25.66,26.12,24.5,22.94,21.94,21.0,19.97,19.78,19.0,18.66,17.38,17.25,16.16,16.25,16.56,16.75,18.34,19.94,21.12,22.56,23.91,23.81,23.16,21.38,21.09,19.03,18.84,19.44,20.34,21.69,23.34,26.59,27.88,28.94,29.41,28.28,27.47,26.06,25.69,26.16,27.19,28.12,29.03,30.5,31.19,31.69,31.94,32.88,34.06,34.56,35.16,36.28,36.94,37.03,37.0,36.94,36.5,36.5,35.81,35.34,34.44,32.75,31.19,28.62,27.09,25.44,24.78,23.44,23.44,23.81,23.84,24.22,25.09,25.84,26.31,26.16,25.84,27.19,27.19,27.38,27.72,27.06,26.31,25.84,25.62,25.06,24.66,24.16,22.94,21.75,21.53,20.66,20.94,21.66,21.53,21.44,22.12,23.25,24.66,27.06,29.94,31.84,33.06,33.44,33.19,31.09,29.44,29.03,27.03,26.72,25.78,24.38,24.69,25.28,25.34,26.78,27.41,27.69,26.28,26.03,24.5,22.91,22.53,20.88,20.03,18.69,17.88,17.19,17.06,17.22,19.41,20.09,21.69,22.12,21.91,20.56,19.25,18.94,19.97,22.0,25.03,27.84,29.78,31.12,31.81,32.25,31.5,31.09,30.81,29.56,29.0,28.06,27.25,26.81,25.28,24.91,23.31,22.5,22.94,22.41,23.0,24.19,25.66,27.53,28.5,30.5,31.0,29.69,29.41,27.53,25.81,25.62,25.34,24.66,24.94,24.5,24.91,24.78,25.97,27.44,28.16,29.16,28.31,27.31,24.62,22.81,21.5,20.56,21.31,21.56,22.12,22.53,21.53,21.19,21.06,20.62,20.28,21.69,22.94,24.59,25.78,27.56,28.12,28.5,29.38,29.72,29.62,29.41,29.81,29.81,29.94,30.28,28.88,27.28,25.09,21.44,19.53,18.38,17.69,18.56,19.34,20.66,20.06,20.41,19.44,19.31,18.91,19.41,19.91,20.69,20.44,21.41,23.22,24.72,27.16,29.97,29.72,30.16,29.19,27.94,28.31,27.56,28.84,29.0,28.44,28.53,28.44,27.03,26.53,26.34,24.94,24.78,24.31,23.16,23.06,21.91,22.06,22.38,23.19,23.84,24.78,24.28,23.5,23.41,23.19,22.81,22.69,22.06,21.25,18.75,17.03,15.72,15.03,14.69,14.56,14.25,14.62,14.47,16.5,17.47,20.31,23.81,25.25,27.06,26.69,27.0,25.53,23.94,23.06,22.38,23.16,23.75,24.91,25.62,25.53,25.03,22.75,21.38,19.12,18.56,19.72,22.06,24.0,27.66,28.38,27.5,25.41,22.06,18.41,16.0,14.06,13.78,13.41,14.09,15.25,15.47,15.78,15.94,15.41,16.81,16.53,17.66,19.16,19.5,23.16,24.5,27.94,29.12,30.16,28.78,25.91,23.41,19.97,17.06,15.5,13.94,14.66,13.41,13.75,13.69,13.31,13.53,14.56,15.34,16.88,17.78,18.84,18.94,20.88,21.72,23.56,24.12,24.91,23.56,22.22,21.5,20.69,20.5,22.03,22.0,21.81,22.09,20.84,20.53,19.56,17.53,16.81,16.0,15.06,15.62,18.03,18.88,19.53,20.53,20.16,19.81,19.91,20.75,21.78,22.69,24.38,24.59,23.62,23.19,22.72,20.97,21.72,22.16,21.62,22.56,22.94,24.41,26.84,29.19,31.06,32.72,33.25,33.56,33.62,32.25,32.12,31.84,31.47,31.69,32.28,31.56,30.69,29.31,28.25,26.75,26.25,25.06,24.34,23.38,22.66,24.34,24.62,27.59,30.34,31.94,32.12,32.25,29.06,26.28,22.41,19.91,19.25,18.5,19.56,20.5,21.44,22.75,24.66,26.0,27.75,30.16,31.44,32.72,33.25,34.34,34.16,33.44,33.19,30.94,29.69,29.44,28.19,29.28,28.28,28.94,28.16,27.94,28.0,27.88,29.56,30.19,30.56,30.69,30.88,30.09,30.06,29.41,28.38,28.66,26.03,24.5,22.97,22.72,23.72,25.09,28.19,29.5,31.41,32.41,33.62,34.28,36.38,37.5,37.44,39.03,39.56,40.41,42.62,45.5,46.34,47.66,47.47,46.16,44.94,44.81,43.94,42.53,42.56,40.0,39.28,37.16,36.28,35.66,35.72,35.97,35.88,36.53,37.91,38.75,39.25,38.97,38.75,36.81,34.88,33.59,32.66,31.31,30.12,30.0,28.44,28.12,26.69,26.81,26.28,26.44,25.56,24.81,24.31,23.72,24.94,26.38,29.66,32.34,35.22,37.78,37.84,38.72,37.84,37.69,38.09,37.16,36.81,35.56,33.47,31.56,29.59,28.81,28.84,28.88,29.22,30.59,30.31,30.81,32.25,32.5,35.03,35.94,36.75,36.06,35.25,31.91,29.94,27.25,24.25,22.16,21.06,18.03,16.81,15.75,14.53,13.41,10.97,10.16,7.94,7.97,7.0,8.28,11.62,14.94,18.16,22.22,24.19,24.5,23.66,21.44,19.56,17.75,16.84,15.53,14.84,14.19,12.72,12.78,12.59,13.59,14.72,17.75,19.88,21.94,24.91,27.81,28.94,30.59,32.06,31.84,32.06,31.66,31.38,30.75,29.88,30.44,29.44,29.62,30.62,29.44,29.94,29.31,28.5,26.69,27.19,27.06,27.59,30.41,32.62,34.41,35.81,35.84,33.47,29.25,26.31,22.31,19.25,18.0,16.72,16.72,16.62,16.31,15.62,15.25,13.25,13.19,12.03,13.69,15.56,17.84,20.59,23.66,26.31,27.81,28.19,28.19,26.81,26.19,24.28,23.69,23.06,21.81,21.47,21.0,19.94,18.81,19.09,18.88,20.09,22.25,25.25,28.84,34.84,39.84,45.16,48.5,50.25,48.66,45.84,41.19,36.88,32.97,30.16,28.91,27.66,27.16,27.56,26.5,27.62,27.91,29.34,30.94,31.94,32.44,31.53,29.44,27.56,26.06,25.28,24.66,26.12,26.5,26.66,27.0,26.62,25.88,24.03,22.59,20.41,17.06,15.72,13.19,11.0,9.78,9.06,7.59,7.62,7.47,8.41,9.28,12.06,14.12,16.41,17.81,17.53,18.16,16.34,16.5,15.72,15.34,15.06,14.88,14.19,15.09,16.12,16.44,18.75,21.09,23.06,25.69,27.69,28.84,30.25,30.62,30.44,30.5,29.16,27.97,26.41,25.12,23.22,22.31,21.19,21.25,21.66,21.81,22.38,20.94,19.44,18.31:25.66,25.56,25.31,25.38,24.91,25.56,27.91,28.31,28.84,29.25,28.53,26.78,24.81,23.44,21.38,20.88,21.12,21.94,23.97,26.69,28.12,29.16,29.75,29.5,28.69,28.16,28.75,28.09,27.25,25.91,24.0,22.75,22.81,22.59,24.06,26.25,28.78,31.78,34.47,37.0,38.41,39.41,38.69,38.81,38.41,36.78,36.44,34.69,33.94,32.72,31.44,30.66,28.31,25.84,24.31,22.62,21.09,21.5,21.62,21.78,22.28,21.47,20.28,19.0,17.03,14.31,12.97,12.41,13.31,14.22,16.69,18.19,19.12,19.41,20.38,19.62,20.12,20.69,21.53,23.34,25.66,28.19,31.09,33.25,33.69,34.66,34.03,34.44,35.0,36.41,37.78,37.56,37.38,35.69,32.5,29.94,27.81,26.41,25.19,24.78,25.03,24.97,25.25,27.31,29.06,31.44,34.56,35.78,35.75,35.66,33.72,32.69,31.97,32.34,32.66,34.78,36.66,36.94,37.69,37.84,38.53,38.84,37.81,37.06,35.75,35.94,36.38,36.97,38.84,39.69,39.53,37.84,36.44,33.62,31.62,29.5,27.69,26.94,26.69,26.34,25.66,26.12,24.5,22.94,21.94,21.0,19.97,19.78,19.0,18.66,17.38,17.25,16.16,16.25,16.56,16.75,18.34,19.94,21.12,22.56,23.91,23.81,23.16,21.38,21.09,19.03,18.84,19.44,20.34,21.69,23.34,26.59,27.88,28.94,29.41,28.28,27.47,26.06,25.69,26.16,27.19,28.12,29.03,30.5,31.19,31.69,31.94,32.88,34.06,34.56,35.16,36.28,36.94,37.03,37.0,36.94,36.5,36.5,35.81,35.34,34.44,32.75,31.19,28.62,27.09,25.44,24.78,23.44,23.44,23.81,23.84,24.22,25.09,25.84,26.31,26.16,25.84,27.19,27.19,27.38,27.72,27.06,26.31,25.84,25.62,25.06,24.66,24.16,22.94,21.75,21.53,20.66,20.94,21.66,21.53,21.44,22.12,23.25,24.66,27.06,29.94,31.84,33.06,33.44,33.19,31.09,29.44,29.03,27.03,26.72,25.78,24.38,24.69,25.28,25.34,26.78,27.41,27.69,26.28,26.03,24.5,22.91,22.53,20.88,20.03,18.69,17.88,17.19,17.06,17.22,19.41,20.09,21.69,22.12,21.91,20.56,19.25,18.94,19.97,22.0,25.03,27.84,29.78,31.12,31.81,32.25,31.5,31.09,30.81,29.56,29.0,28.06,27.25,26.81,25.28,24.91,23.31,22.5,22.94,22.41,23.0,24.19,25.66,27.53,28.5,30.5,31.0,29.69,29.41,27.53,25.81,25.62,25.34,24.66,24.94,24.5,24.91,24.78,25.97,27.44,28.16,29.16,28.31,27.31,24.62,22.81,21.5,20.56,21.31,21.56,22.12,22.53,21.53,21.19,21.06,20.62,20.28,21.69,22.94,24.59,25.78,27.56,28.12,28.5,29.38,29.72,29.62,29.41,29.81,29.81,29.94,30.28,28.88,27.28,25.09,21.44,19.53,18.38,17.69,18.56,19.34,20.66,20.06,20.41,19.44,19.31,18.91,19.41,19.91,20.69,20.44,21.41,23.22,24.72,27.16,29.97,29.72,30.16,29.19,27.94,28.31,27.56,28.84,29.0,28.44,28.53,28.44,27.03,26.53,26.34,24.94,24.78,24.31,23.16,23.06,21.91,22.06,22.38,23.19,23.84,24.78,24.28,23.5,23.41,23.19,22.81,22.69,22.06,21.25,18.75,17.03,15.72,15.03,14.69,14.56,14.25,14.62,14.47,16.5,17.47,20.31,23.81,25.25,27.06,26.69,27.0,25.53,23.94,23.06,22.38,23.16,23.75,24.91,25.62,25.53,25.03,22.75,21.38,19.12,18.56,19.72,22.06,24.0,27.66,28.38,27.5,25.41,22.06,18.41,16.0,14.06,13.78,13.41,14.09,15.25,15.47,15.78,15.94,15.41,16.81,16.53,17.66,19.16,19.5,23.16,24.5,27.94,29.12,30.16,28.78,25.91,23.41,19.97,17.06,15.5,13.94,14.66,13.41,13.75,13.69,13.31,13.53,14.56,15.34,16.88,17.78,18.84,18.94,20.88,21.72,23.56,24.12,24.91,23.56,22.22,21.5,20.69,20.5,22.03,22.0,21.81,22.09,20.84,20.53,19.56,17.53,16.81,16.0,15.06,15.62,18.03,18.88,19.53,20.53,20.16,19.81,19.91,20.75,21.78,22.69,24.38,24.59,23.62,23.19,22.72,20.97,21.72,22.16,21.62,22.56,22.94,24.41,26.84,29.19,31.06,32.72,33.25,33.56,33.62,32.25,32.12,31.84,31.47,31.69,32.28,31.56,30.69,29.31,28.25,26.75,26.25,25.06,24.34,23.38,22.66,24.34,24.62,27.59,30.34,31.94,32.12,32.25,29.06,26.28,22.41,19.91,19.25,18.5,19.56,20.5,21.44,22.75,24.66,26.0,27.75,30.16,31.44,32.72,33.25,34.34,34.16,33.44,33.19,30.94,29.69,29.44,28.19,29.28,28.28,28.94,28.16,27.94,28.0,27.88,29.56,30.19,30.56,30.69,30.88,30.09,30.06,29.41,28.38,28.66,26.03,24.5,22.97,22.72,23.72,25.09,28.19,29.5,31.41,32.41,33.62,34.28,36.38,37.5,37.44,39.03,39.56,40.41,42.62,45.5,46.34,47.66,47.47,46.16,44.94,44.81,43.94,42.53,42.56,40.0,39.28,37.16,36.28,35.66,35.72,35.97,35.88,36.53,37.91,38.75,39.25,38.97,38.75,36.81,34.88,33.59,32.66,31.31,30.12,30.0,28.44,28.12,26.69,26.81,26.28,26.44,25.56,24.81,24.31,23.72,24.94,26.38,29.66,32.34,35.22,37.78,37.84,38.72,37.84,37.69,38.09,37.16,36.81,35.56,33.47,31.56,29.59,28.81,28.84,28.88,29.22,30.59,30.31,30.81,32.25,32.5,35.03,35.94,36.75,36.06,35.25,31.91,29.94,27.25,24.25,22.16,21.06,18.03,16.81,15.75,14.53,13.41,10.97,10.16,7.94,7.97,7.0,8.28,11.62,14.94,18.16,22.22,24.19,24.5,23.66,21.44,19.56,17.75,16.84,15.53,14.84,14.19,12.72,12.78,12.59,13.59,14.72,17.75,19.88,21.94,24.91,27.81,28.94,30.59,32.06,31.84,32.06,31.66,31.38,30.75,29.88,30.44,29.44,29.62,30.62,29.44,29.94,29.31,28.5,26.69,27.19,27.06,27.59,30.41,32.62,34.41,35.81,35.84,33.47,29.25,26.31,22.31,19.25,18.0,16.72,16.72,16.62,16.31,15.62,15.25,13.25,13.19,12.03,13.69,15.56,17.84,20.59,23.66,26.31,27.81,28.19,28.19,26.81,26.19,24.28,23.69,23.06,21.81,21.47,21.0,19.94,18.81,19.09,18.88,20.09,22.25,25.25,28.84,34.84,39.84,45.16,48.5,50.25,48.66,45.84,41.19,36.88,32.97,30.16,28.91,27.66,27.16,27.56,26.5,27.62,27.91,29.34,30.94,31.94,32.44,31.53,29.44,27.56,26.06,25.28,24.66,26.12,26.5,26.66,27.0,26.62,25.88,24.03,22.59,20.41,17.06,15.72,13.19,11.0,9.78,9.06,7.59,7.62,7.47,8.41,9.28,12.06,14.12,16.41,17.81,17.53,18.16,16.34,16.5,15.72,15.34,15.06,14.88,14.19,15.09,16.12,16.44,18.75,21.09,23.06,25.69,27.69,28.84,30.25,30.62,30.44,30.5,29.16,27.97,26.41,25.12,23.22,22.31,21.19,21.25,21.66,21.81,22.38,20.94,19.44,18.31,24.75,24.53,24.53,25.56,26.06,26.31:27.91,28.31,28.84,29.25,28.53,26.78,24.81,23.44,21.38,20.88,21.12,21.94,23.97,26.69,28.12,29.16,29.75,29.5,28.69,28.16,28.75,28.09,27.25,25.91,24.0,22.75,22.81,22.59,24.06,26.25,28.78,31.78,34.47,37.0,38.41,39.41,38.69,38.81,38.41,36.78,36.44,34.69,33.94,32.72,31.44,30.66,28.31,25.84,24.31,22.62,21.09,21.5,21.62,21.78,22.28,21.47,20.28,19.0,17.03,14.31,12.97,12.41,13.31,14.22,16.69,18.19,19.12,19.41,20.38,19.62,20.12,20.69,21.53,23.34,25.66,28.19,31.09,33.25,33.69,34.66,34.03,34.44,35.0,36.41,37.78,37.56,37.38,35.69,32.5,29.94,27.81,26.41,25.19,24.78,25.03,24.97,25.25,27.31,29.06,31.44,34.56,35.78,35.75,35.66,33.72,32.69,31.97,32.34,32.66,34.78,36.66,36.94,37.69,37.84,38.53,38.84,37.81,37.06,35.75,35.94,36.38,36.97,38.84,39.69,39.53,37.84,36.44,33.62,31.62,29.5,27.69,26.94,26.69,26.34,25.66,26.12,24.5,22.94,21.94,21.0,19.97,19.78,19.0,18.66,17.38,17.25,16.16,16.25,16.56,16.75,18.34,19.94,21.12,22.56,23.91,23.81,23.16,21.38,21.09,19.03,18.84,19.44,20.34,21.69,23.34,26.59,27.88,28.94,29.41,28.28,27.47,26.06,25.69,26.16,27.19,28.12,29.03,30.5,31.19,31.69,31.94,32.88,34.06,34.56,35.16,36.28,36.94,37.03,37.0,36.94,36.5,36.5,35.81,35.34,34.44,32.75,31.19,28.62,27.09,25.44,24.78,23.44,23.44,23.81,23.84,24.22,25.09,25.84,26.31,26.16,25.84,27.19,27.19,27.38,27.72,27.06,26.31,25.84,25.62,25.06,24.66,24.16,22.94,21.75,21.53,20.66,20.94,21.66,21.53,21.44,22.12,23.25,24.66,27.06,29.94,31.84,33.06,33.44,33.19,31.09,29.44,29.03,27.03,26.72,25.78,24.38,24.69,25.28,25.34,26.78,27.41,27.69,26.28,26.03,24.5,22.91,22.53,20.88,20.03,18.69,17.88,17.19,17.06,17.22,19.41,20.09,21.69,22.12,21.91,20.56,19.25,18.94,19.97,22.0,25.03,27.84,29.78,31.12,31.81,32.25,31.5,31.09,30.81,29.56,29.0,28.06,27.25,26.81,25.28,24.91,23.31,22.5,22.94,22.41,23.0,24.19,25.66,27.53,28.5,30.5,31.0,29.69,29.41,27.53,25.81,25.62,25.34,24.66,24.94,24.5,24.91,24.78,25.97,27.44,28.16,29.16,28.31,27.31,24.62,22.81,21.5,20.56,21.31,21.56,22.12,22.53,21.53,21.19,21.06,20.62,20.28,21.69,22.94,24.59,25.78,27.56,28.12,28.5,29.38,29.72,29.62,29.41,29.81,29.81,29.94,30.28,28.88,27.28,25.09,21.44,19.53,18.38,17.69,18.56,19.34,20.66,20.06,20.41,19.44,19.31,18.91,19.41,19.91,20.69,20.44,21.41,23.22,24.72,27.16,29.97,29.72,30.16,29.19,27.94,28.31,27.56,28.84,29.0,28.44,28.53,28.44,27.03,26.53,26.34,24.94,24.78,24.31,23.16,23.06,21.91,22.06,22.38,23.19,23.84,24.78,24.28,23.5,23.41,23.19,22.81,22.69,22.06,21.25,18.75,17.03,15.72,15.03,14.69,14.56,14.25,14.62,14.47,16.5,17.47,20.31,23.81,25.25,27.06,26.69,27.0,25.53,23.94,23.06,22.38,23.16,23.75,24.91,25.62,25.53,25.03,22.75,21.38,19.12,18.56,19.72,22.06,24.0,27.66,28.38,27.5,25.41,22.06,18.41,16.0,14.06,13.78,13.41,14.09,15.25,15.47,15.78,15.94,15.41,16.81,16.53,17.66,19.16,19.5,23.16,24.5,27.94,29.12,30.16,28.78,25.91,23.41,19.97,17.06,15.5,13.94,14.66,13.41,13.75,13.69,13.31,13.53,14.56,15.34,16.88,17.78,18.84,18.94,20.88,21.72,23.56,24.12,24.91,23.56,22.22,21.5,20.69,20.5,22.03,22.0,21.81,22.09,20.84,20.53,19.56,17.53,16.81,16.0,15.06,15.62,18.03,18.88,19.53,20.53,20.16,19.81,19.91,20.75,21.78,22.69,24.38,24.59,23.62,23.19,22.72,20.97,21.72,22.16,21.62,22.56,22.94,24.41,26.84,29.19,31.06,32.72,33.25,33.56,33.62,32.25,32.12,31.84,31.47,31.69,32.28,31.56,30.69,29.31,28.25,26.75,26.25,25.06,24.34,23.38,22.66,24.34,24.62,27.59,30.34,31.94,32.12,32.25,29.06,26.28,22.41,19.91,19.25,18.5,19.56,20.5,21.44,22.75,24.66,26.0,27.75,30.16,31.44,32.72,33.25,34.34,34.16,33.44,33.19,30.94,29.69,29.44,28.19,29.28,28.28,28.94,28.16,27.94,28.0,27.88,29.56,30.19,30.56,30.69,30.88,30.09,30.06,29.41,28.38,28.66,26.03,24.5,22.97,22.72,23.72,25.09,28.19,29.5,31.41,32.41,33.62,34.28,36.38,37.5,37.44,39.03,39.56,40.41,42.62,45.5,46.34,47.66,47.47,46.16,44.94,44.81,43.94,42.53,42.56,40.0,39.28,37.16,36.28,35.66,35.72,35.97,35.88,36.53,37.91,38.75,39.25,38.97,38.75,36.81,34.88,33.59,32.66,31.31,30.12,30.0,28.44,28.12,26.69,26.81,26.28,26.44,25.56,24.81,24.31,23.72,24.94,26.38,29.66,32.34,35.22,37.78,37.84,38.72,37.84,37.69,38.09,37.16,36.81,35.56,33.47,31.56,29.59,28.81,28.84,28.88,29.22,30.59,30.31,30.81,32.25,32.5,35.03,35.94,36.75,36.06,35.25,31.91,29.94,27.25,24.25,22.16,21.06,18.03,16.81,15.75,14.53,13.41,10.97,10.16,7.94,7.97,7.0,8.28,11.62,14.94,18.16,22.22,24.19,24.5,23.66,21.44,19.56,17.75,16.84,15.53,14.84,14.19,12.72,12.78,12.59,13.59,14.72,17.75,19.88,21.94,24.91,27.81,28.94,30.59,32.06,31.84,32.06,31.66,31.38,30.75,29.88,30.44,29.44,29.62,30.62,29.44,29.94,29.31,28.5,26.69,27.19,27.06,27.59,30.41,32.62,34.41,35.81,35.84,33.47,29.25,26.31,22.31,19.25,18.0,16.72,16.72,16.62,16.31,15.62,15.25,13.25,13.19,12.03,13.69,15.56,17.84,20.59,23.66,26.31,27.81,28.19,28.19,26.81,26.19,24.28,23.69,23.06,21.81,21.47,21.0,19.94,18.81,19.09,18.88,20.09,22.25,25.25,28.84,34.84,39.84,45.16,48.5,50.25,48.66,45.84,41.19,36.88,32.97,30.16,28.91,27.66,27.16,27.56,26.5,27.62,27.91,29.34,30.94,31.94,32.44,31.53,29.44,27.56,26.06,25.28,24.66,26.12,26.5,26.66,27.0,26.62,25.88,24.03,22.59,20.41,17.06,15.72,13.19,11.0,9.78,9.06,7.59,7.62,7.47,8.41,9.28,12.06,14.12,16.41,17.81,17.53,18.16,16.34,16.5,15.72,15.34,15.06,14.88,14.19,15.09,16.12,16.44,18.75,21.09,23.06,25.69,27.69,28.84,30.25,30.62,30.44,30.5,29.16,27.97,26.41,25.12,23.22,22.31,21.19,21.25,21.66,21.81,22.38,20.94,19.44,18.31,24.75,24.53,24.53,25.56,26.06,26.31,26.41,26.56,25.19,25.34,24.62,24.06:24.81,23.44,21.38,20.88,21.12,21.94,23.97,26.69,28.12,29.16,29.75,29.5,28.69,28.16,28.75,28.09,27.25,25.91,24.0,22.75,22.81,22.59,24.06,26.25,28.78,31.78,34.47,37.0,38.41,39.41,38.69,38.81,38.41,36.78,36.44,34.69,33.94,32.72,31.44,30.66,28.31,25.84,24.31,22.62,21.09,21.5,21.62,21.78,22.28,21.47,20.28,19.0,17.03,14.31,12.97,12.41,13.31,14.22,16.69,18.19,19.12,19.41,20.38,19.62,20.12,20.69,21.53,23.34,25.66,28.19,31.09,33.25,33.69,34.66,34.03,34.44,35.0,36.41,37.78,37.56,37.38,35.69,32.5,29.94,27.81,26.41,25.19,24.78,25.03,24.97,25.25,27.31,29.06,31.44,34.56,35.78,35.75,35.66,33.72,32.69,31.97,32.34,32.66,34.78,36.66,36.94,37.69,37.84,38.53,38.84,37.81,37.06,35.75,35.94,36.38,36.97,38.84,39.69,39.53,37.84,36.44,33.62,31.62,29.5,27.69,26.94,26.69,26.34,25.66,26.12,24.5,22.94,21.94,21.0,19.97,19.78,19.0,18.66,17.38,17.25,16.16,16.25,16.56,16.75,18.34,19.94,21.12,22.56,23.91,23.81,23.16,21.38,21.09,19.03,18.84,19.44,20.34,21.69,23.34,26.59,27.88,28.94,29.41,28.28,27.47,26.06,25.69,26.16,27.19,28.12,29.03,30.5,31.19,31.69,31.94,32.88,34.06,34.56,35.16,36.28,36.94,37.03,37.0,36.94,36.5,36.5,35.81,35.34,34.44,32.75,31.19,28.62,27.09,25.44,24.78,23.44,23.44,23.81,23.84,24.22,25.09,25.84,26.31,26.16,25.84,27.19,27.19,27.38,27.72,27.06,26.31,25.84,25.62,25.06,24.66,24.16,22.94,21.75,21.53,20.66,20.94,21.66,21.53,21.44,22.12,23.25,24.66,27.06,29.94,31.84,33.06,33.44,33.19,31.09,29.44,29.03,27.03,26.72,25.78,24.38,24.69,25.28,25.34,26.78,27.41,27.69,26.28,26.03,24.5,22.91,22.53,20.88,20.03,18.69,17.88,17.19,17.06,17.22,19.41,20.09,21.69,22.12,21.91,20.56,19.25,18.94,19.97,22.0,25.03,27.84,29.78,31.12,31.81,32.25,31.5,31.09,30.81,29.56,29.0,28.06,27.25,26.81,25.28,24.91,23.31,22.5,22.94,22.41,23.0,24.19,25.66,27.53,28.5,30.5,31.0,29.69,29.41,27.53,25.81,25.62,25.34,24.66,24.94,24.5,24.91,24.78,25.97,27.44,28.16,29.16,28.31,27.31,24.62,22.81,21.5,20.56,21.31,21.56,22.12,22.53,21.53,21.19,21.06,20.62,20.28,21.69,22.94,24.59,25.78,27.56,28.12,28.5,29.38,29.72,29.62,29.41,29.81,29.81,29.94,30.28,28.88,27.28,25.09,21.44,19.53,18.38,17.69,18.56,19.34,20.66,20.06,20.41,19.44,19.31,18.91,19.41,19.91,20.69,20.44,21.41,23.22,24.72,27.16,29.97,29.72,30.16,29.19,27.94,28.31,27.56,28.84,29.0,28.44,28.53,28.44,27.03,26.53,26.34,24.94,24.78,24.31,23.16,23.06,21.91,22.06,22.38,23.19,23.84,24.78,24.28,23.5,23.41,23.19,22.81,22.69,22.06,21.25,18.75,17.03,15.72,15.03,14.69,14.56,14.25,14.62,14.47,16.5,17.47,20.31,23.81,25.25,27.06,26.69,27.0,25.53,23.94,23.06,22.38,23.16,23.75,24.91,25.62,25.53,25.03,22.75,21.38,19.12,18.56,19.72,22.06,24.0,27.66,28.38,27.5,25.41,22.06,18.41,16.0,14.06,13.78,13.41,14.09,15.25,15.47,15.78,15.94,15.41,16.81,16.53,17.66,19.16,19.5,23.16,24.5,27.94,29.12,30.16,28.78,25.91,23.41,19.97,17.06,15.5,13.94,14.66,13.41,13.75,13.69,13.31,13.53,14.56,15.34,16.88,17.78,18.84,18.94,20.88,21.72,23.56,24.12,24.91,23.56,22.22,21.5,20.69,20.5,22.03,22.0,21.81,22.09,20.84,20.53,19.56,17.53,16.81,16.0,15.06,15.62,18.03,18.88,19.53,20.53,20.16,19.81,19.91,20.75,21.78,22.69,24.38,24.59,23.62,23.19,22.72,20.97,21.72,22.16,21.62,22.56,22.94,24.41,26.84,29.19,31.06,32.72,33.25,33.56,33.62,32.25,32.12,31.84,31.47,31.69,32.28,31.56,30.69,29.31,28.25,26.75,26.25,25.06,24.34,23.38,22.66,24.34,24.62,27.59,30.34,31.94,32.12,32.25,29.06,26.28,22.41,19.91,19.25,18.5,19.56,20.5,21.44,22.75,24.66,26.0,27.75,30.16,31.44,32.72,33.25,34.34,34.16,33.44,33.19,30.94,29.69,29.44,28.19,29.28,28.28,28.94,28.16,27.94,28.0,27.88,29.56,30.19,30.56,30.69,30.88,30.09,30.06,29.41,28.38,28.66,26.03,24.5,22.97,22.72,23.72,25.09,28.19,29.5,31.41,32.41,33.62,34.28,36.38,37.5,37.44,39.03,39.56,40.41,42.62,45.5,46.34,47.66,47.47,46.16,44.94,44.81,43.94,42.53,42.56,40.0,39.28,37.16,36.28,35.66,35.72,35.97,35.88,36.53,37.91,38.75,39.25,38.97,38.75,36.81,34.88,33.59,32.66,31.31,30.12,30.0,28.44,28.12,26.69,26.81,26.28,26.44,25.56,24.81,24.31,23.72,24.94,26.38,29.66,32.34,35.22,37.78,37.84,38.72,37.84,37.69,38.09,37.16,36.81,35.56,33.47,31.56,29.59,28.81,28.84,28.88,29.22,30.59,30.31,30.81,32.25,32.5,35.03,35.94,36.75,36.06,35.25,31.91,29.94,27.25,24.25,22.16,21.06,18.03,16.81,15.75,14.53,13.41,10.97,10.16,7.94,7.97,7.0,8.28,11.62,14.94,18.16,22.22,24.19,24.5,23.66,21.44,19.56,17.75,16.84,15.53,14.84,14.19,12.72,12.78,12.59,13.59,14.72,17.75,19.88,21.94,24.91,27.81,28.94,30.59,32.06,31.84,32.06,31.66,31.38,30.75,29.88,30.44,29.44,29.62,30.62,29.44,29.94,29.31,28.5,26.69,27.19,27.06,27.59,30.41,32.62,34.41,35.81,35.84,33.47,29.25,26.31,22.31,19.25,18.0,16.72,16.72,16.62,16.31,15.62,15.25,13.25,13.19,12.03,13.69,15.56,17.84,20.59,23.66,26.31,27.81,28.19,28.19,26.81,26.19,24.28,23.69,23.06,21.81,21.47,21.0,19.94,18.81,19.09,18.88,20.09,22.25,25.25,28.84,34.84,39.84,45.16,48.5,50.25,48.66,45.84,41.19,36.88,32.97,30.16,28.91,27.66,27.16,27.56,26.5,27.62,27.91,29.34,30.94,31.94,32.44,31.53,29.44,27.56,26.06,25.28,24.66,26.12,26.5,26.66,27.0,26.62,25.88,24.03,22.59,20.41,17.06,15.72,13.19,11.0,9.78,9.06,7.59,7.62,7.47,8.41,9.28,12.06,14.12,16.41,17.81,17.53,18.16,16.34,16.5,15.72,15.34,15.06,14.88,14.19,15.09,16.12,16.44,18.75,21.09,23.06,25.69,27.69,28.84,30.25,30.62,30.44,30.5,29.16,27.97,26.41,25.12,23.22,22.31,21.19,21.25,21.66,21.81,22.38,20.94,19.44,18.31,24.75,24.53,24.53,25.56,26.06,26.31,26.41,26.56,25.19,25.34,24.62,24.06,25.53,25.78,25.91,25.81,25.25,22.56:23.97,26.69,28.12,29.16,29.75,29.5,28.69,28.16,28.75,28.09,27.25,25.91,24.0,22.75,22.81,22.59,24.06,26.25,28.78,31.78,34.47,37.0,38.41,39.41,38.69,38.81,38.41,36.78,36.44,34.69,33.94,32.72,31.44,30.66,28.31,25.84,24.31,22.62,21.09,21.5,21.62,21.78,22.28,21.47,20.28,19.0,17.03,14.31,12.97,12.41,13.31,14.22,16.69,18.19,19.12,19.41,20.38,19.62,20.12,20.69,21.53,23.34,25.66,28.19,31.09,33.25,33.69,34.66,34.03,34.44,35.0,36.41,37.78,37.56,37.38,35.69,32.5,29.94,27.81,26.41,25.19,24.78,25.03,24.97,25.25,27.31,29.06,31.44,34.56,35.78,35.75,35.66,33.72,32.69,31.97,32.34,32.66,34.78,36.66,36.94,37.69,37.84,38.53,38.84,37.81,37.06,35.75,35.94,36.38,36.97,38.84,39.69,39.53,37.84,36.44,33.62,31.62,29.5,27.69,26.94,26.69,26.34,25.66,26.12,24.5,22.94,21.94,21.0,19.97,19.78,19.0,18.66,17.38,17.25,16.16,16.25,16.56,16.75,18.34,19.94,21.12,22.56,23.91,23.81,23.16,21.38,21.09,19.03,18.84,19.44,20.34,21.69,23.34,26.59,27.88,28.94,29.41,28.28,27.47,26.06,25.69,26.16,27.19,28.12,29.03,30.5,31.19,31.69,31.94,32.88,34.06,34.56,35.16,36.28,36.94,37.03,37.0,36.94,36.5,36.5,35.81,35.34,34.44,32.75,31.19,28.62,27.09,25.44,24.78,23.44,23.44,23.81,23.84,24.22,25.09,25.84,26.31,26.16,25.84,27.19,27.19,27.38,27.72,27.06,26.31,25.84,25.62,25.06,24.66,24.16,22.94,21.75,21.53,20.66,20.94,21.66,21.53,21.44,22.12,23.25,24.66,27.06,29.94,31.84,33.06,33.44,33.19,31.09,29.44,29.03,27.03,26.72,25.78,24.38,24.69,25.28,25.34,26.78,27.41,27.69,26.28,26.03,24.5,22.91,22.53,20.88,20.03,18.69,17.88,17.19,17.06,17.22,19.41,20.09,21.69,22.12,21.91,20.56,19.25,18.94,19.97,22.0,25.03,27.84,29.78,31.12,31.81,32.25,31.5,31.09,30.81,29.56,29.0,28.06,27.25,26.81,25.28,24.91,23.31,22.5,22.94,22.41,23.0,24.19,25.66,27.53,28.5,30.5,31.0,29.69,29.41,27.53,25.81,25.62,25.34,24.66,24.94,24.5,24.91,24.78,25.97,27.44,28.16,29.16,28.31,27.31,24.62,22.81,21.5,20.56,21.31,21.56,22.12,22.53,21.53,21.19,21.06,20.62,20.28,21.69,22.94,24.59,25.78,27.56,28.12,28.5,29.38,29.72,29.62,29.41,29.81,29.81,29.94,30.28,28.88,27.28,25.09,21.44,19.53,18.38,17.69,18.56,19.34,20.66,20.06,20.41,19.44,19.31,18.91,19.41,19.91,20.69,20.44,21.41,23.22,24.72,27.16,29.97,29.72,30.16,29.19,27.94,28.31,27.56,28.84,29.0,28.44,28.53,28.44,27.03,26.53,26.34,24.94,24.78,24.31,23.16,23.06,21.91,22.06,22.38,23.19,23.84,24.78,24.28,23.5,23.41,23.19,22.81,22.69,22.06,21.25,18.75,17.03,15.72,15.03,14.69,14.56,14.25,14.62,14.47,16.5,17.47,20.31,23.81,25.25,27.06,26.69,27.0,25.53,23.94,23.06,22.38,23.16,23.75,24.91,25.62,25.53,25.03,22.75,21.38,19.12,18.56,19.72,22.06,24.0,27.66,28.38,27.5,25.41,22.06,18.41,16.0,14.06,13.78,13.41,14.09,15.25,15.47,15.78,15.94,15.41,16.81,16.53,17.66,19.16,19.5,23.16,24.5,27.94,29.12,30.16,28.78,25.91,23.41,19.97,17.06,15.5,13.94,14.66,13.41,13.75,13.69,13.31,13.53,14.56,15.34,16.88,17.78,18.84,18.94,20.88,21.72,23.56,24.12,24.91,23.56,22.22,21.5,20.69,20.5,22.03,22.0,21.81,22.09,20.84,20.53,19.56,17.53,16.81,16.0,15.06,15.62,18.03,18.88,19.53,20.53,20.16,19.81,19.91,20.75,21.78,22.69,24.38,24.59,23.62,23.19,22.72,20.97,21.72,22.16,21.62,22.56,22.94,24.41,26.84,29.19,31.06,32.72,33.25,33.56,33.62,32.25,32.12,31.84,31.47,31.69,32.28,31.56,30.69,29.31,28.25,26.75,26.25,25.06,24.34,23.38,22.66,24.34,24.62,27.59,30.34,31.94,32.12,32.25,29.06,26.28,22.41,19.91,19.25,18.5,19.56,20.5,21.44,22.75,24.66,26.0,27.75,30.16,31.44,32.72,33.25,34.34,34.16,33.44,33.19,30.94,29.69,29.44,28.19,29.28,28.28,28.94,28.16,27.94,28.0,27.88,29.56,30.19,30.56,30.69,30.88,30.09,30.06,29.41,28.38,28.66,26.03,24.5,22.97,22.72,23.72,25.09,28.19,29.5,31.41,32.41,33.62,34.28,36.38,37.5,37.44,39.03,39.56,40.41,42.62,45.5,46.34,47.66,47.47,46.16,44.94,44.81,43.94,42.53,42.56,40.0,39.28,37.16,36.28,35.66,35.72,35.97,35.88,36.53,37.91,38.75,39.25,38.97,38.75,36.81,34.88,33.59,32.66,31.31,30.12,30.0,28.44,28.12,26.69,26.81,26.28,26.44,25.56,24.81,24.31,23.72,24.94,26.38,29.66,32.34,35.22,37.78,37.84,38.72,37.84,37.69,38.09,37.16,36.81,35.56,33.47,31.56,29.59,28.81,28.84,28.88,29.22,30.59,30.31,30.81,32.25,32.5,35.03,35.94,36.75,36.06,35.25,31.91,29.94,27.25,24.25,22.16,21.06,18.03,16.81,15.75,14.53,13.41,10.97,10.16,7.94,7.97,7.0,8.28,11.62,14.94,18.16,22.22,24.19,24.5,23.66,21.44,19.56,17.75,16.84,15.53,14.84,14.19,12.72,12.78,12.59,13.59,14.72,17.75,19.88,21.94,24.91,27.81,28.94,30.59,32.06,31.84,32.06,31.66,31.38,30.75,29.88,30.44,29.44,29.62,30.62,29.44,29.94,29.31,28.5,26.69,27.19,27.06,27.59,30.41,32.62,34.41,35.81,35.84,33.47,29.25,26.31,22.31,19.25,18.0,16.72,16.72,16.62,16.31,15.62,15.25,13.25,13.19,12.03,13.69,15.56,17.84,20.59,23.66,26.31,27.81,28.19,28.19,26.81,26.19,24.28,23.69,23.06,21.81,21.47,21.0,19.94,18.81,19.09,18.88,20.09,22.25,25.25,28.84,34.84,39.84,45.16,48.5,50.25,48.66,45.84,41.19,36.88,32.97,30.16,28.91,27.66,27.16,27.56,26.5,27.62,27.91,29.34,30.94,31.94,32.44,31.53,29.44,27.56,26.06,25.28,24.66,26.12,26.5,26.66,27.0,26.62,25.88,24.03,22.59,20.41,17.06,15.72,13.19,11.0,9.78,9.06,7.59,7.62,7.47,8.41,9.28,12.06,14.12,16.41,17.81,17.53,18.16,16.34,16.5,15.72,15.34,15.06,14.88,14.19,15.09,16.12,16.44,18.75,21.09,23.06,25.69,27.69,28.84,30.25,30.62,30.44,30.5,29.16,27.97,26.41,25.12,23.22,22.31,21.19,21.25,21.66,21.81,22.38,20.94,19.44,18.31,24.75,24.53,24.53,25.56,26.06,26.31,26.41,26.56,25.19,25.34,24.62,24.06,25.53,25.78,25.91,25.81,25.25,22.56,21.25,19.41,17.41,17.72,18.0,19.84:28.69,28.16,28.75,28.09,27.25,25.91,24.0,22.75,22.81,22.59,24.06,26.25,28.78,31.78,34.47,37.0,38.41,39.41,38.69,38.81,38.41,36.78,36.44,34.69,33.94,32.72,31.44,30.66,28.31,25.84,24.31,22.62,21.09,21.5,21.62,21.78,22.28,21.47,20.28,19.0,17.03,14.31,12.97,12.41,13.31,14.22,16.69,18.19,19.12,19.41,20.38,19.62,20.12,20.69,21.53,23.34,25.66,28.19,31.09,33.25,33.69,34.66,34.03,34.44,35.0,36.41,37.78,37.56,37.38,35.69,32.5,29.94,27.81,26.41,25.19,24.78,25.03,24.97,25.25,27.31,29.06,31.44,34.56,35.78,35.75,35.66,33.72,32.69,31.97,32.34,32.66,34.78,36.66,36.94,37.69,37.84,38.53,38.84,37.81,37.06,35.75,35.94,36.38,36.97,38.84,39.69,39.53,37.84,36.44,33.62,31.62,29.5,27.69,26.94,26.69,26.34,25.66,26.12,24.5,22.94,21.94,21.0,19.97,19.78,19.0,18.66,17.38,17.25,16.16,16.25,16.56,16.75,18.34,19.94,21.12,22.56,23.91,23.81,23.16,21.38,21.09,19.03,18.84,19.44,20.34,21.69,23.34,26.59,27.88,28.94,29.41,28.28,27.47,26.06,25.69,26.16,27.19,28.12,29.03,30.5,31.19,31.69,31.94,32.88,34.06,34.56,35.16,36.28,36.94,37.03,37.0,36.94,36.5,36.5,35.81,35.34,34.44,32.75,31.19,28.62,27.09,25.44,24.78,23.44,23.44,23.81,23.84,24.22,25.09,25.84,26.31,26.16,25.84,27.19,27.19,27.38,27.72,27.06,26.31,25.84,25.62,25.06,24.66,24.16,22.94,21.75,21.53,20.66,20.94,21.66,21.53,21.44,22.12,23.25,24.66,27.06,29.94,31.84,33.06,33.44,33.19,31.09,29.44,29.03,27.03,26.72,25.78,24.38,24.69,25.28,25.34,26.78,27.41,27.69,26.28,26.03,24.5,22.91,22.53,20.88,20.03,18.69,17.88,17.19,17.06,17.22,19.41,20.09,21.69,22.12,21.91,20.56,19.25,18.94,19.97,22.0,25.03,27.84,29.78,31.12,31.81,32.25,31.5,31.09,30.81,29.56,29.0,28.06,27.25,26.81,25.28,24.91,23.31,22.5,22.94,22.41,23.0,24.19,25.66,27.53,28.5,30.5,31.0,29.69,29.41,27.53,25.81,25.62,25.34,24.66,24.94,24.5,24.91,24.78,25.97,27.44,28.16,29.16,28.31,27.31,24.62,22.81,21.5,20.56,21.31,21.56,22.12,22.53,21.53,21.19,21.06,20.62,20.28,21.69,22.94,24.59,25.78,27.56,28.12,28.5,29.38,29.72,29.62,29.41,29.81,29.81,29.94,30.28,28.88,27.28,25.09,21.44,19.53,18.38,17.69,18.56,19.34,20.66,20.06,20.41,19.44,19.31,18.91,19.41,19.91,20.69,20.44,21.41,23.22,24.72,27.16,29.97,29.72,30.16,29.19,27.94,28.31,27.56,28.84,29.0,28.44,28.53,28.44,27.03,26.53,26.34,24.94,24.78,24.31,23.16,23.06,21.91,22.06,22.38,23.19,23.84,24.78,24.28,23.5,23.41,23.19,22.81,22.69,22.06,21.25,18.75,17.03,15.72,15.03,14.69,14.56,14.25,14.62,14.47,16.5,17.47,20.31,23.81,25.25,27.06,26.69,27.0,25.53,23.94,23.06,22.38,23.16,23.75,24.91,25.62,25.53,25.03,22.75,21.38,19.12,18.56,19.72,22.06,24.0,27.66,28.38,27.5,25.41,22.06,18.41,16.0,14.06,13.78,13.41,14.09,15.25,15.47,15.78,15.94,15.41,16.81,16.53,17.66,19.16,19.5,23.16,24.5,27.94,29.12,30.16,28.78,25.91,23.41,19.97,17.06,15.5,13.94,14.66,13.41,13.75,13.69,13.31,13.53,14.56,15.34,16.88,17.78,18.84,18.94,20.88,21.72,23.56,24.12,24.91,23.56,22.22,21.5,20.69,20.5,22.03,22.0,21.81,22.09,20.84,20.53,19.56,17.53,16.81,16.0,15.06,15.62,18.03,18.88,19.53,20.53,20.16,19.81,19.91,20.75,21.78,22.69,24.38,24.59,23.62,23.19,22.72,20.97,21.72,22.16,21.62,22.56,22.94,24.41,26.84,29.19,31.06,32.72,33.25,33.56,33.62,32.25,32.12,31.84,31.47,31.69,32.28,31.56,30.69,29.31,28.25,26.75,26.25,25.06,24.34,23.38,22.66,24.34,24.62,27.59,30.34,31.94,32.12,32.25,29.06,26.28,22.41,19.91,19.25,18.5,19.56,20.5,21.44,22.75,24.66,26.0,27.75,30.16,31.44,32.72,33.25,34.34,34.16,33.44,33.19,30.94,29.69,29.44,28.19,29.28,28.28,28.94,28.16,27.94,28.0,27.88,29.56,30.19,30.56,30.69,30.88,30.09,30.06,29.41,28.38,28.66,26.03,24.5,22.97,22.72,23.72,25.09,28.19,29.5,31.41,32.41,33.62,34.28,36.38,37.5,37.44,39.03,39.56,40.41,42.62,45.5,46.34,47.66,47.47,46.16,44.94,44.81,43.94,42.53,42.56,40.0,39.28,37.16,36.28,35.66,35.72,35.97,35.88,36.53,37.91,38.75,39.25,38.97,38.75,36.81,34.88,33.59,32.66,31.31,30.12,30.0,28.44,28.12,26.69,26.81,26.28,26.44,25.56,24.81,24.31,23.72,24.94,26.38,29.66,32.34,35.22,37.78,37.84,38.72,37.84,37.69,38.09,37.16,36.81,35.56,33.47,31.56,29.59,28.81,28.84,28.88,29.22,30.59,30.31,30.81,32.25,32.5,35.03,35.94,36.75,36.06,35.25,31.91,29.94,27.25,24.25,22.16,21.06,18.03,16.81,15.75,14.53,13.41,10.97,10.16,7.94,7.97,7.0,8.28,11.62,14.94,18.16,22.22,24.19,24.5,23.66,21.44,19.56,17.75,16.84,15.53,14.84,14.19,12.72,12.78,12.59,13.59,14.72,17.75,19.88,21.94,24.91,27.81,28.94,30.59,32.06,31.84,32.06,31.66,31.38,30.75,29.88,30.44,29.44,29.62,30.62,29.44,29.94,29.31,28.5,26.69,27.19,27.06,27.59,30.41,32.62,34.41,35.81,35.84,33.47,29.25,26.31,22.31,19.25,18.0,16.72,16.72,16.62,16.31,15.62,15.25,13.25,13.19,12.03,13.69,15.56,17.84,20.59,23.66,26.31,27.81,28.19,28.19,26.81,26.19,24.28,23.69,23.06,21.81,21.47,21.0,19.94,18.81,19.09,18.88,20.09,22.25,25.25,28.84,34.84,39.84,45.16,48.5,50.25,48.66,45.84,41.19,36.88,32.97,30.16,28.91,27.66,27.16,27.56,26.5,27.62,27.91,29.34,30.94,31.94,32.44,31.53,29.44,27.56,26.06,25.28,24.66,26.12,26.5,26.66,27.0,26.62,25.88,24.03,22.59,20.41,17.06,15.72,13.19,11.0,9.78,9.06,7.59,7.62,7.47,8.41,9.28,12.06,14.12,16.41,17.81,17.53,18.16,16.34,16.5,15.72,15.34,15.06,14.88,14.19,15.09,16.12,16.44,18.75,21.09,23.06,25.69,27.69,28.84,30.25,30.62,30.44,30.5,29.16,27.97,26.41,25.12,23.22,22.31,21.19,21.25,21.66,21.81,22.38,20.94,19.44,18.31,24.75,24.53,24.53,25.56,26.06,26.31,26.41,26.56,25.19,25.34,24.62,24.06,25.53,25.78,25.91,25.81,25.25,22.56,21.25,19.41,17.41,17.72,18.0,19.84,22.59,26.19,28.69,30.69,32.03,32.34:negativity
24.94,23.25,21.31,19.19,18.91,17.5,18.56,20.56,22.16,23.16,25.09,25.47,24.25,23.0,22.31,20.81,20.66,22.34,23.97,26.19,28.31,28.75,28.5,26.75,24.31,22.69,20.84,20.75,21.12,21.69,22.25,22.12,20.81,19.0,17.66,14.69,11.94,10.12,7.91,7.81,8.47,11.12,15.25,20.38,22.69,25.06,25.03,23.88,21.62,19.12,18.16,18.34,19.5,20.88,23.44,25.31,26.16,26.31,25.06,22.5,19.44,16.94,15.25,13.69,14.34,14.62,16.69,18.28,19.41,20.41,20.59,18.91,15.81,13.03,9.94,8.22,7.69,7.62,9.56,12.56,15.25,18.03,20.25,21.41,21.88,22.31,21.97,22.0,21.69,22.88,22.59,22.88,23.59,24.47,25.16,25.81,27.16,27.84,27.69,28.03,29.09,28.81,30.44,31.12,30.91,31.5,31.38,28.97,27.56,25.44,23.34,19.53,18.25,17.31,16.5,18.09,18.69,21.12,22.88,24.44,25.38,25.94,26.09,25.34,24.12,23.59,23.94,23.5,23.66,24.34,25.44,26.12,26.25,26.16,25.75,23.03,20.72,19.16,16.09,15.53,16.34,17.25,18.72,20.5,22.84,22.84,24.25,24.91,25.34,25.91,26.91,28.25,28.81,30.19,30.0,29.72,30.19,29.53,29.62,29.97,29.62,29.06,28.62,28.22,28.25,28.78,28.69,29.62,30.66,31.81,32.03,32.19,32.53,31.09,29.53,28.72,28.38,27.5,28.06,26.5,25.19,22.34,19.97,16.78,15.53,13.72,13.94,14.81,15.03,15.62,16.53,17.91,18.66,20.62,23.88,26.47,28.84,30.84,30.56,31.34,28.75,27.38,26.62,25.28,25.81,25.56,25.69,25.62,26.06,26.88,27.09,29.12,32.03,33.69,35.19,36.72,36.75,36.34,36.44,36.31,34.66,35.06,35.03,34.19,34.78,33.75,33.41,33.5,32.09,31.66,31.88,31.56,30.94,31.16,31.0,31.44,31.56,32.81,33.78,35.66,37.34,40.19,41.69,43.88,44.59,43.69,42.06,39.0,35.94,32.84,30.72,28.81,28.62,28.5,28.94,28.66,29.31,29.28,29.06,29.59,28.81,28.34,28.31,28.31,26.84,26.91,27.34,26.19,26.03,25.91,24.72,25.22,25.56,26.28,26.25,27.38,28.34,28.66,29.47,30.25,31.06,30.19,30.19,29.97,29.34,29.0,29.78,29.75,30.47,31.19,31.75,31.81,32.12,31.31,30.72,29.0,27.12,25.31,23.81,22.12,21.16,20.97,20.19,19.84,18.78,18.25,17.5,15.47,14.78,14.81,14.19,15.81,16.88,19.91,21.94,25.06,26.53,27.41,26.75,24.72,21.78,19.25,15.53,13.28,11.72,10.53,10.78,11.53,13.03,14.94,16.81,17.81,18.78,19.12,19.94,19.72,20.53,22.41,23.66,24.53,26.09,26.44,27.0,26.97,25.09,23.75,21.5,19.69,18.06,17.94,18.53,20.06,22.56,24.53,26.56,27.5,28.66,27.38,26.12,25.25,24.22,24.38,24.81,26.53,27.78,27.62,27.34,27.03,26.03,25.44,25.25,24.12,24.25,23.81,23.66,23.38,24.31,24.5,26.03,27.16,28.84,29.75,30.81,29.25,28.41,27.66,28.19,30.12,33.41,36.56,40.5,42.91,43.91,43.44,41.47,39.19,37.34,35.31,35.28,35.75,35.97,37.41,37.16,37.56,37.41,35.53,34.44,32.16,29.66,28.34,27.56,26.31,26.03,26.62,28.06,29.31,30.94,32.06,32.47,32.0,30.19,28.97,27.44,25.12,22.34,20.16,19.19,17.69,18.0,18.66,18.41,19.34,19.38,20.0,21.72,22.12,23.44,25.06,25.34,27.06,29.16,31.12,32.47,33.69,33.06,32.34,30.53,28.25,25.19,23.66,21.19,18.91,16.25,16.31,15.72,15.84,17.31,19.5,21.62,23.0,25.44,27.25,31.19,34.84,38.53,40.44,41.41,40.53,37.75,34.97,32.69,30.34,28.5,26.44,25.56,24.0,23.38,23.16,22.16,20.91,19.53,15.97,12.69,9.41,7.06,4.5,3.59,4.28,5.53,8.53,11.69,15.56,17.44,19.34,18.41,17.16,15.56,13.03,12.75,12.53,12.97,13.91,15.56,16.81,17.22,17.06,17.0,15.75,15.31,14.31,13.34,13.28,13.34,14.12,14.12,14.41,14.94,14.0,13.28,13.66,13.62,13.41,14.44,14.66,15.75,15.88,16.53,18.19,19.81,21.53,22.31,23.34,22.72,21.81,20.84,19.41,18.09,18.5,18.88,19.62,20.34,20.31,19.28,18.16,15.94,13.91,14.28,13.5,13.41,13.81,14.19,15.25,16.03,17.03,18.25,19.78,19.81,19.81,18.31,16.88,15.38,13.62,12.16,10.5,9.28,7.03,4.56,3.0,1.34,1.19,1.72,2.34,3.72,6.0,7.16,10.16,12.31,14.12,15.97,16.22,15.62,14.44,12.88,11.81,10.22,11.03,11.72,13.06,14.62,16.69,16.66,18.34,19.16,18.44,17.69,16.94,16.38,15.31,14.91,14.16,14.66,14.72,15.47,16.0,17.91,18.47,19.09,18.81,18.28,18.56,19.03,19.25,19.41,19.56,18.78,16.75,14.38,12.56,11.16,9.44,9.22,9.38,9.44,10.06,11.06,11.16,11.84,12.41,12.53,12.06,11.66,12.12,10.94,10.62,9.69,9.56,8.88,8.53,8.41,8.0,7.97,7.16,6.12,4.66,3.97,3.75,4.22,5.53,6.31,7.66,8.38,8.12,8.78,8.75,8.31,8.53,8.34,8.84,8.59,8.94,9.12,8.47,8.25,8.88,8.69,9.25,9.56,9.81,9.31,9.03,8.94,9.56,10.34,11.06,12.12,12.91,12.72,14.12,14.25,14.81,16.03,15.31,15.47,15.31,14.09,12.91,10.81,8.5,6.88,5.06,3.88,3.75,2.81,2.72,2.03,1.78,1.38,3.56,4.91,6.62,8.41,10.47,10.81,12.66,13.25,13.25,14.0,12.5,10.88,9.16,9.12,9.72,11.31,15.47,18.84,22.59,24.56,25.38,23.66,20.28,15.91,10.91,6.88,3.06,1.69,1.0,1.0,0.81,2.28,2.91,3.94,4.19,5.16,5.81,6.41,6.53,7.0,7.94,8.28,8.5,8.06,6.41,5.69,2.66,0.0,-2.59,-4.91,-6.22,-7.72,-7.66,-7.97,-7.94,-7.41,-6.97,-6.94,-5.66,-4.66,-3.16,-2.19,0.19,2.84,5.84,9.31,12.0,14.66,15.72,15.47,14.22,13.12,11.41,9.5,8.59,7.84,8.16,7.69,8.41,7.75,7.69,7.0,6.19,5.69,5.0,5.69,6.38,7.72,9.94,12.12,14.03,16.12,17.66,18.44,19.5,19.41,18.56,16.5,14.78,13.44,12.12,12.56,11.97,11.59,10.88,8.5,6.53,5.44,4.5,4.88,5.12,5.59,6.81,8.72,10.06,11.38,12.38,12.88,10.78,9.56,6.56,4.41,1.94,0.25,-1.53,-1.72,-2.16,-2.09,-1.22,-0.31,1.31,2.5,3.22,4.31,5.88,6.88,7.41,8.66,9.31,11.16,12.75,13.62,14.16,13.88,12.75,11.34,9.97,9.19,8.66,8.62,8.25,7.91,8.03,8.06,8.94,9.38,9.91,10.81,12.31,12.75,14.56,15.59,15.94,16.41,15.31,15.31,14.62,14.56,14.09,14.25,13.91,14.06,13.34,12.66,12.56,11.5,10.19,8.53,7.19,6.31,6.16,6.5,7.94,9.38,10.5,11.12,11.06,10.31,9.06,6.34,4.03,1.88,-0.47,-1.03,-0.91,-0.59,1.34,2.62,3.97:18.56,20.56,22.16,23.16,25.09,25.47,24.25,23.0,22.31,20.81,20.66,22.34,23.97,26.19,28.31,28.75,28.5,26.75,24.31,22.69,20.84,20.75,21.12,21.69,22.25,22.12,20.81,19.0,17.66,14.69,11.94,10.12,7.91,7.81,8.47,11.12,15.25,20.38,22.69,25.06,25.03,23.88,21.62,19.12,18.16,18.34,19.5,20.88,23.44,25.31,26.16,26.31,25.06,22.5,19.44,16.94,15.25,13.69,14.34,14.62,16.69,18.28,19.41,20.41,20.59,18.91,15.81,13.03,9.94,8.22,7.69,7.62,9.56,12.56,15.25,18.03,20.25,21.41,21.88,22.31,21.97,22.0,21.69,22.88,22.59,22.88,23.59,24.47,25.16,25.81,27.16,27.84,27.69,28.03,29.09,28.81,30.44,31.12,30.91,31.5,31.38,28.97,27.56,25.44,23.34,19.53,18.25,17.31,16.5,18.09,18.69,21.12,22.88,24.44,25.38,25.94,26.09,25.34,24.12,23.59,23.94,23.5,23.66,24.34,25.44,26.12,26.25,26.16,25.75,23.03,20.72,19.16,16.09,15.53,16.34,17.25,18.72,20.5,22.84,22.84,24.25,24.91,25.34,25.91,26.91,28.25,28.81,30.19,30.0,29.72,30.19,29.53,29.62,29.97,29.62,29.06,28.62,28.22,28.25,28.78,28.69,29.62,30.66,31.81,32.03,32.19,32.53,31.09,29.53,28.72,28.38,27.5,28.06,26.5,25.19,22.34,19.97,16.78,15.53,13.72,13.94,14.81,15.03,15.62,16.53,17.91,18.66,20.62,23.88,26.47,28.84,30.84,30.56,31.34,28.75,27.38,26.62,25.28,25.81,25.56,25.69,25.62,26.06,26.88,27.09,29.12,32.03,33.69,35.19,36.72,36.75,36.34,36.44,36.31,34.66,35.06,35.03,34.19,34.78,33.75,33.41,33.5,32.09,31.66,31.88,31.56,30.94,31.16,31.0,31.44,31.56,32.81,33.78,35.66,37.34,40.19,41.69,43.88,44.59,43.69,42.06,39.0,35.94,32.84,30.72,28.81,28.62,28.5,28.94,28.66,29.31,29.28,29.06,29.59,28.81,28.34,28.31,28.31,26.84,26.91,27.34,26.19,26.03,25.91,24.72,25.22,25.56,26.28,26.25,27.38,28.34,28.66,29.47,30.25,31.06,30.19,30.19,29.97,29.34,29.0,29.78,29.75,30.47,31.19,31.75,31.81,32.12,31.31,30.72,29.0,27.12,25.31,23.81,22.12,21.16,20.97,20.19,19.84,18.78,18.25,17.5,15.47,14.78,14.81,14.19,15.81,16.88,19.91,21.94,25.06,26.53,27.41,26.75,24.72,21.78,19.25,15.53,13.28,11.72,10.53,10.78,11.53,13.03,14.94,16.81,17.81,18.78,19.12,19.94,19.72,20.53,22.41,23.66,24.53,26.09,26.44,27.0,26.97,25.09,23.75,21.5,19.69,18.06,17.94,18.53,20.06,22.56,24.53,26.56,27.5,28.66,27.38,26.12,25.25,24.22,24.38,24.81,26.53,27.78,27.62,27.34,27.03,26.03,25.44,25.25,24.12,24.25,23.81,23.66,23.38,24.31,24.5,26.03,27.16,28.84,29.75,30.81,29.25,28.41,27.66,28.19,30.12,33.41,36.56,40.5,42.91,43.91,43.44,41.47,39.19,37.34,35.31,35.28,35.75,35.97,37.41,37.16,37.56,37.41,35.53,34.44,32.16,29.66,28.34,27.56,26.31,26.03,26.62,28.06,29.31,30.94,32.06,32.47,32.0,30.19,28.97,27.44,25.12,22.34,20.16,19.19,17.69,18.0,18.66,18.41,19.34,19.38,20.0,21.72,22.12,23.44,25.06,25.34,27.06,29.16,31.12,32.47,33.69,33.06,32.34,30.53,28.25,25.19,23.66,21.19,18.91,16.25,16.31,15.72,15.84,17.31,19.5,21.62,23.0,25.44,27.25,31.19,34.84,38.53,40.44,41.41,40.53,37.75,34.97,32.69,30.34,28.5,26.44,25.56,24.0,23.38,23.16,22.16,20.91,19.53,15.97,12.69,9.41,7.06,4.5,3.59,4.28,5.53,8.53,11.69,15.56,17.44,19.34,18.41,17.16,15.56,13.03,12.75,12.53,12.97,13.91,15.56,16.81,17.22,17.06,17.0,15.75,15.31,14.31,13.34,13.28,13.34,14.12,14.12,14.41,14.94,14.0,13.28,13.66,13.62,13.41,14.44,14.66,15.75,15.88,16.53,18.19,19.81,21.53,22.31,23.34,22.72,21.81,20.84,19.41,18.09,18.5,18.88,19.62,20.34,20.31,19.28,18.16,15.94,13.91,14.28,13.5,13.41,13.81,14.19,15.25,16.03,17.03,18.25,19.78,19.81,19.81,18.31,16.88,15.38,13.62,12.16,10.5,9.28,7.03,4.56,3.0,1.34,1.19,1.72,2.34,3.72,6.0,7.16,10.16,12.31,14.12,15.97,16.22,15.62,14.44,12.88,11.81,10.22,11.03,11.72,13.06,14.62,16.69,16.66,18.34,19.16,18.44,17.69,16.94,16.38,15.31,14.91,14.16,14.66,14.72,15.47,16.0,17.91,18.47,19.09,18.81,18.28,18.56,19.03,19.25,19.41,19.56,18.78,16.75,14.38,12.56,11.16,9.44,9.22,9.38,9.44,10.06,11.06,11.16,11.84,12.41,12.53,12.06,11.66,12.12,10.94,10.62,9.69,9.56,8.88,8.53,8.41,8.0,7.97,7.16,6.12,4.66,3.97,3.75,4.22,5.53,6.31,7.66,8.38,8.12,8.78,8.75,8.31,8.53,8.34,8.84,8.59,8.94,9.12,8.47,8.25,8.88,8.69,9.25,9.56,9.81,9.31,9.03,8.94,9.56,10.34,11.06,12.12,12.91,12.72,14.12,14.25,14.81,16.03,15.31,15.47,15.31,14.09,12.91,10.81,8.5,6.88,5.06,3.88,3.75,2.81,2.72,2.03,1.78,1.38,3.56,4.91,6.62,8.41,10.47,10.81,12.66,13.25,13.25,14.0,12.5,10.88,9.16,9.12,9.72,11.31,15.47,18.84,22.59,24.56,25.38,23.66,20.28,15.91,10.91,6.88,3.06,1.69,1.0,1.0,0.81,2.28,2.91,3.94,4.19,5.16,5.81,6.41,6.53,7.0,7.94,8.28,8.5,8.06,6.41,5.69,2.66,0.0,-2.59,-4.91,-6.22,-7.72,-7.66,-7.97,-7.94,-7.41,-6.97,-6.94,-5.66,-4.66,-3.16,-2.19,0.19,2.84,5.84,9.31,12.0,14.66,15.72,15.47,14.22,13.12,11.41,9.5,8.59,7.84,8.16,7.69,8.41,7.75,7.69,7.0,6.19,5.69,5.0,5.69,6.38,7.72,9.94,12.12,14.03,16.12,17.66,18.44,19.5,19.41,18.56,16.5,14.78,13.44,12.12,12.56,11.97,11.59,10.88,8.5,6.53,5.44,4.5,4.88,5.12,5.59,6.81,8.72,10.06,11.38,12.38,12.88,10.78,9.56,6.56,4.41,1.94,0.25,-1.53,-1.72,-2.16,-2.09,-1.22,-0.31,1.31,2.5,3.22,4.31,5.88,6.88,7.41,8.66,9.31,11.16,12.75,13.62,14.16,13.88,12.75,11.34,9.97,9.19,8.66,8.62,8.25,7.91,8.03,8.06,8.94,9.38,9.91,10.81,12.31,12.75,14.56,15.59,15.94,16.41,15.31,15.31,14.62,14.56,14.09,14.25,13.91,14.06,13.34,12.66,12.56,11.5,10.19,8.53,7.19,6.31,6.16,6.5,7.94,9.38,10.5,11.12,11.06,10.31,9.06,6.34,4.03,1.88,-0.47,-1.03,-0.91,-0.59,1.34,2.62,3.97,23.12,22.25,19.59,17.84,16.66,15.97:24.25,23.0,22.31,20.81,20.66,22.34,23.97,26.19,28.31,28.75,28.5,26.75,24.31,22.69,20.84,20.75,21.12,21.69,22.25,22.12,20.81,19.0,17.66,14.69,11.94,10.12,7.91,7.81,8.47,11.12,15.25,20.38,22.69,25.06,25.03,23.88,21.62,19.12,18.16,18.34,19.5,20.88,23.44,25.31,26.16,26.31,25.06,22.5,19.44,16.94,15.25,13.69,14.34,14.62,16.69,18.28,19.41,20.41,20.59,18.91,15.81,13.03,9.94,8.22,7.69,7.62,9.56,12.56,15.25,18.03,20.25,21.41,21.88,22.31,21.97,22.0,21.69,22.88,22.59,22.88,23.59,24.47,25.16,25.81,27.16,27.84,27.69,28.03,29.09,28.81,30.44,31.12,30.91,31.5,31.38,28.97,27.56,25.44,23.34,19.53,18.25,17.31,16.5,18.09,18.69,21.12,22.88,24.44,25.38,25.94,26.09,25.34,24.12,23.59,23.94,23.5,23.66,24.34,25.44,26.12,26.25,26.16,25.75,23.03,20.72,19.16,16.09,15.53,16.34,17.25,18.72,20.5,22.84,22.84,24.25,24.91,25.34,25.91,26.91,28.25,28.81,30.19,30.0,29.72,30.19,29.53,29.62,29.97,29.62,29.06,28.62,28.22,28.25,28.78,28.69,29.62,30.66,31.81,32.03,32.19,32.53,31.09,29.53,28.72,28.38,27.5,28.06,26.5,25.19,22.34,19.97,16.78,15.53,13.72,13.94,14.81,15.03,15.62,16.53,17.91,18.66,20.62,23.88,26.47,28.84,30.84,30.56,31.34,28.75,27.38,26.62,25.28,25.81,25.56,25.69,25.62,26.06,26.88,27.09,29.12,32.03,33.69,35.19,36.72,36.75,36.34,36.44,36.31,34.66,35.06,35.03,34.19,34.78,33.75,33.41,33.5,32.09,31.66,31.88,31.56,30.94,31.16,31.0,31.44,31.56,32.81,33.78,35.66,37.34,40.19,41.69,43.88,44.59,43.69,42.06,39.0,35.94,32.84,30.72,28.81,28.62,28.5,28.94,28.66,29.31,29.28,29.06,29.59,28.81,28.34,28.31,28.31,26.84,26.91,27.34,26.19,26.03,25.91,24.72,25.22,25.56,26.28,26.25,27.38,28.34,28.66,29.47,30.25,31.06,30.19,30.19,29.97,29.34,29.0,29.78,29.75,30.47,31.19,31.75,31.81,32.12,31.31,30.72,29.0,27.12,25.31,23.81,22.12,21.16,20.97,20.19,19.84,18.78,18.25,17.5,15.47,14.78,14.81,14.19,15.81,16.88,19.91,21.94,25.06,26.53,27.41,26.75,24.72,21.78,19.25,15.53,13.28,11.72,10.53,10.78,11.53,13.03,14.94,16.81,17.81,18.78,19.12,19.94,19.72,20.53,22.41,23.66,24.53,26.09,26.44,27.0,26.97,25.09,23.75,21.5,19.69,18.06,17.94,18.53,20.06,22.56,24.53,26.56,27.5,28.66,27.38,26.12,25.25,24.22,24.38,24.81,26.53,27.78,27.62,27.34,27.03,26.03,25.44,25.25,24.12,24.25,23.81,23.66,23.38,24.31,24.5,26.03,27.16,28.84,29.75,30.81,29.25,28.41,27.66,28.19,30.12,33.41,36.56,40.5,42.91,43.91,43.44,41.47,39.19,37.34,35.31,35.28,35.75,35.97,37.41,37.16,37.56,37.41,35.53,34.44,32.16,29.66,28.34,27.56,26.31,26.03,26.62,28.06,29.31,30.94,32.06,32.47,32.0,30.19,28.97,27.44,25.12,22.34,20.16,19.19,17.69,18.0,18.66,18.41,19.34,19.38,20.0,21.72,22.12,23.44,25.06,25.34,27.06,29.16,31.12,32.47,33.69,33.06,32.34,30.53,28.25,25.19,23.66,21.19,18.91,16.25,16.31,15.72,15.84,17.31,19.5,21.62,23.0,25.44,27.25,31.19,34.84,38.53,40.44,41.41,40.53,37.75,34.97,32.69,30.34,28.5,26.44,25.56,24.0,23.38,23.16,22.16,20.91,19.53,15.97,12.69,9.41,7.06,4.5,3.59,4.28,5.53,8.53,11.69,15.56,17.44,19.34,18.41,17.16,15.56,13.03,12.75,12.53,12.97,13.91,15.56,16.81,17.22,17.06,17.0,15.75,15.31,14.31,13.34,13.28,13.34,14.12,14.12,14.41,14.94,14.0,13.28,13.66,13.62,13.41,14.44,14.66,15.75,15.88,16.53,18.19,19.81,21.53,22.31,23.34,22.72,21.81,20.84,19.41,18.09,18.5,18.88,19.62,20.34,20.31,19.28,18.16,15.94,13.91,14.28,13.5,13.41,13.81,14.19,15.25,16.03,17.03,18.25,19.78,19.81,19.81,18.31,16.88,15.38,13.62,12.16,10.5,9.28,7.03,4.56,3.0,1.34,1.19,1.72,2.34,3.72,6.0,7.16,10.16,12.31,14.12,15.97,16.22,15.62,14.44,12.88,11.81,10.22,11.03,11.72,13.06,14.62,16.69,16.66,18.34,19.16,18.44,17.69,16.94,16.38,15.31,14.91,14.16,14.66,14.72,15.47,16.0,17.91,18.47,19.09,18.81,18.28,18.56,19.03,19.25,19.41,19.56,18.78,16.75,14.38,12.56,11.16,9.44,9.22,9.38,9.44,10.06,11.06,11.16,11.84,12.41,12.53,12.06,11.66,12.12,10.94,10.62,9.69,9.56,8.88,8.53,8.41,8.0,7.97,7.16,6.12,4.66,3.97,3.75,4.22,5.53,6.31,7.66,8.38,8.12,8.78,8.75,8.31,8.53,8.34,8.84,8.59,8.94,9.12,8.47,8.25,8.88,8.69,9.25,9.56,9.81,9.31,9.03,8.94,9.56,10.34,11.06,12.12,12.91,12.72,14.12,14.25,14.81,16.03,15.31,15.47,15.31,14.09,12.91,10.81,8.5,6.88,5.06,3.88,3.75,2.81,2.72,2.03,1.78,1.38,3.56,4.91,6.62,8.41,10.47,10.81,12.66,13.25,13.25,14.0,12.5,10.88,9.16,9.12,9.72,11.31,15.47,18.84,22.59,24.56,25.38,23.66,20.28,15.91,10.91,6.88,3.06,1.69,1.0,1.0,0.81,2.28,2.91,3.94,4.19,5.16,5.81,6.41,6.53,7.0,7.94,8.28,8.5,8.06,6.41,5.69,2.66,0.0,-2.59,-4.91,-6.22,-7.72,-7.66,-7.97,-7.94,-7.41,-6.97,-6.94,-5.66,-4.66,-3.16,-2.19,0.19,2.84,5.84,9.31,12.0,14.66,15.72,15.47,14.22,13.12,11.41,9.5,8.59,7.84,8.16,7.69,8.41,7.75,7.69,7.0,6.19,5.69,5.0,5.69,6.38,7.72,9.94,12.12,14.03,16.12,17.66,18.44,19.5,19.41,18.56,16.5,14.78,13.44,12.12,12.56,11.97,11.59,10.88,8.5,6.53,5.44,4.5,4.88,5.12,5.59,6.81,8.72,10.06,11.38,12.38,12.88,10.78,9.56,6.56,4.41,1.94,0.25,-1.53,-1.72,-2.16,-2.09,-1.22,-0.31,1.31,2.5,3.22,4.31,5.88,6.88,7.41,8.66,9.31,11.16,12.75,13.62,14.16,13.88,12.75,11.34,9.97,9.19,8.66,8.62,8.25,7.91,8.03,8.06,8.94,9.38,9.91,10.81,12.31,12.75,14.56,15.59,15.94,16.41,15.31,15.31,14.62,14.56,14.09,14.25,13.91,14.06,13.34,12.66,12.56,11.5,10.19,8.53,7.19,6.31,6.16,6.5,7.94,9.38,10.5,11.12,11.06,10.31,9.06,6.34,4.03,1.88,-0.47,-1.03,-0.91,-0.59,1.34,2.62,3.97,23.12,22.25,19.59,17.84,16.66,15.97,15.94,17.84,18.91,20.41,20.62,21.47:23.97,26.19,28.31,28.75,28.5,26.75,24.31,22.69,20.84,20.75,21.12,21.69,22.25,22.12,20.81,19.0,17.66,14.69,11.94,10.12,7.91,7.81,8.47,11.12,15.25,20.38,22.69,25.06,25.03,23.88,21.62,19.12,18.16,18.34,19.5,20.88,23.44,25.31,26.16,26.31,25.06,22.5,19.44,16.94,15.25,13.69,14.34,14.62,16.69,18.28,19.41,20.41,20.59,18.91,15.81,13.03,9.94,8.22,7.69,7.62,9.56,12.56,15.25,18.03,20.25,21.41,21.88,22.31,21.97,22.0,21.69,22.88,22.59,22.88,23.59,24.47,25.16,25.81,27.16,27.84,27.69,28.03,29.09,28.81,30.44,31.12,30.91,31.5,31.38,28.97,27.56,25.44,23.34,19.53,18.25,17.31,16.5,18.09,18.69,21.12,22.88,24.44,25.38,25.94,26.09,25.34,24.12,23.59,23.94,23.5,23.66,24.34,25.44,26.12,26.25,26.16,25.75,23.03,20.72,19.16,16.09,15.53,16.34,17.25,18.72,20.5,22.84,22.84,24.25,24.91,25.34,25.91,26.91,28.25,28.81,30.19,30.0,29.72,30.19,29.53,29.62,29.97,29.62,29.06,28.62,28.22,28.25,28.78,28.69,29.62,30.66,31.81,32.03,32.19,32.53,31.09,29.53,28.72,28.38,27.5,28.06,26.5,25.19,22.34,19.97,16.78,15.53,13.72,13.94,14.81,15.03,15.62,16.53,17.91,18.66,20.62,23.88,26.47,28.84,30.84,30.56,31.34,28.75,27.38,26.62,25.28,25.81,25.56,25.69,25.62,26.06,26.88,27.09,29.12,32.03,33.69,35.19,36.72,36.75,36.34,36.44,36.31,34.66,35.06,35.03,34.19,34.78,33.75,33.41,33.5,32.09,31.66,31.88,31.56,30.94,31.16,31.0,31.44,31.56,32.81,33.78,35.66,37.34,40.19,41.69,43.88,44.59,43.69,42.06,39.0,35.94,32.84,30.72,28.81,28.62,28.5,28.94,28.66,29.31,29.28,29.06,29.59,28.81,28.34,28.31,28.31,26.84,26.91,27.34,26.19,26.03,25.91,24.72,25.22,25.56,26.28,26.25,27.38,28.34,28.66,29.47,30.25,31.06,30.19,30.19,29.97,29.34,29.0,29.78,29.75,30.47,31.19,31.75,31.81,32.12,31.31,30.72,29.0,27.12,25.31,23.81,22.12,21.16,20.97,20.19,19.84,18.78,18.25,17.5,15.47,14.78,14.81,14.19,15.81,16.88,19.91,21.94,25.06,26.53,27.41,26.75,24.72,21.78,19.25,15.53,13.28,11.72,10.53,10.78,11.53,13.03,14.94,16.81,17.81,18.78,19.12,19.94,19.72,20.53,22.41,23.66,24.53,26.09,26.44,27.0,26.97,25.09,23.75,21.5,19.69,18.06,17.94,18.53,20.06,22.56,24.53,26.56,27.5,28.66,27.38,26.12,25.25,24.22,24.38,24.81,26.53,27.78,27.62,27.34,27.03,26.03,25.44,25.25,24.12,24.25,23.81,23.66,23.38,24.31,24.5,26.03,27.16,28.84,29.75,30.81,29.25,28.41,27.66,28.19,30.12,33.41,36.56,40.5,42.91,43.91,43.44,41.47,39.19,37.34,35.31,35.28,35.75,35.97,37.41,37.16,37.56,37.41,35.53,34.44,32.16,29.66,28.34,27.56,26.31,26.03,26.62,28.06,29.31,30.94,32.06,32.47,32.0,30.19,28.97,27.44,25.12,22.34,20.16,19.19,17.69,18.0,18.66,18.41,19.34,19.38,20.0,21.72,22.12,23.44,25.06,25.34,27.06,29.16,31.12,32.47,33.69,33.06,32.34,30.53,28.25,25.19,23.66,21.19,18.91,16.25,16.31,15.72,15.84,17.31,19.5,21.62,23.0,25.44,27.25,31.19,34.84,38.53,40.44,41.41,40.53,37.75,34.97,32.69,30.34,28.5,26.44,25.56,24.0,23.38,23.16,22.16,20.91,19.53,15.97,12.69,9.41,7.06,4.5,3.59,4.28,5.53,8.53,11.69,15.56,17.44,19.34,18.41,17.16,15.56,13.03,12.75,12.53,12.97,13.91,15.56,16.81,17.22,17.06,17.0,15.75,15.31,14.31,13.34,13.28,13.34,14.12,14.12,14.41,14.94,14.0,13.28,13.66,13.62,13.41,14.44,14.66,15.75,15.88,16.53,18.19,19.81,21.53,22.31,23.34,22.72,21.81,20.84,19.41,18.09,18.5,18.88,19.62,20.34,20.31,19.28,18.16,15.94,13.91,14.28,13.5,13.41,13.81,14.19,15.25,16.03,17.03,18.25,19.78,19.81,19.81,18.31,16.88,15.38,13.62,12.16,10.5,9.28,7.03,4.56,3.0,1.34,1.19,1.72,2.34,3.72,6.0,7.16,10.16,12.31,14.12,15.97,16.22,15.62,14.44,12.88,11.81,10.22,11.03,11.72,13.06,14.62,16.69,16.66,18.34,19.16,18.44,17.69,16.94,16.38,15.31,14.91,14.16,14.66,14.72,15.47,16.0,17.91,18.47,19.09,18.81,18.28,18.56,19.03,19.25,19.41,19.56,18.78,16.75,14.38,12.56,11.16,9.44,9.22,9.38,9.44,10.06,11.06,11.16,11.84,12.41,12.53,12.06,11.66,12.12,10.94,10.62,9.69,9.56,8.88,8.53,8.41,8.0,7.97,7.16,6.12,4.66,3.97,3.75,4.22,5.53,6.31,7.66,8.38,8.12,8.78,8.75,8.31,8.53,8.34,8.84,8.59,8.94,9.12,8.47,8.25,8.88,8.69,9.25,9.56,9.81,9.31,9.03,8.94,9.56,10.34,11.06,12.12,12.91,12.72,14.12,14.25,14.81,16.03,15.31,15.47,15.31,14.09,12.91,10.81,8.5,6.88,5.06,3.88,3.75,2.81,2.72,2.03,1.78,1.38,3.56,4.91,6.62,8.41,10.47,10.81,12.66,13.25,13.25,14.0,12.5,10.88,9.16,9.12,9.72,11.31,15.47,18.84,22.59,24.56,25.38,23.66,20.28,15.91,10.91,6.88,3.06,1.69,1.0,1.0,0.81,2.28,2.91,3.94,4.19,5.16,5.81,6.41,6.53,7.0,7.94,8.28,8.5,8.06,6.41,5.69,2.66,0.0,-2.59,-4.91,-6.22,-7.72,-7.66,-7.97,-7.94,-7.41,-6.97,-6.94,-5.66,-4.66,-3.16,-2.19,0.19,2.84,5.84,9.31,12.0,14.66,15.72,15.47,14.22,13.12,11.41,9.5,8.59,7.84,8.16,7.69,8.41,7.75,7.69,7.0,6.19,5.69,5.0,5.69,6.38,7.72,9.94,12.12,14.03,16.12,17.66,18.44,19.5,19.41,18.56,16.5,14.78,13.44,12.12,12.56,11.97,11.59,10.88,8.5,6.53,5.44,4.5,4.88,5.12,5.59,6.81,8.72,10.06,11.38,12.38,12.88,10.78,9.56,6.56,4.41,1.94,0.25,-1.53,-1.72,-2.16,-2.09,-1.22,-0.31,1.31,2.5,3.22,4.31,5.88,6.88,7.41,8.66,9.31,11.16,12.75,13.62,14.16,13.88,12.75,11.34,9.97,9.19,8.66,8.62,8.25,7.91,8.03,8.06,8.94,9.38,9.91,10.81,12.31,12.75,14.56,15.59,15.94,16.41,15.31,15.31,14.62,14.56,14.09,14.25,13.91,14.06,13.34,12.66,12.56,11.5,10.19,8.53,7.19,6.31,6.16,6.5,7.94,9.38,10.5,11.12,11.06,10.31,9.06,6.34,4.03,1.88,-0.47,-1.03,-0.91,-0.59,1.34,2.62,3.97,23.12,22.25,19.59,17.84,16.66,15.97,15.94,17.84,18.91,20.41,20.62,21.47,19.88,18.75,17.66,15.94,15.25,15.25:24.31,22.69,20.84,20.75,21.12,21.69,22.25,22.12,20.81,19.0,17.66,14.69,11.94,10.12,7.91,7.81,8.47,11.12,15.25,20.38,22.69,25.06,25.03,23.88,21.62,19.12,18.16,18.34,19.5,20.88,23.44,25.31,26.16,26.31,25.06,22.5,19.44,16.94,15.25,13.69,14.34,14.62,16.69,18.28,19.41,20.41,20.59,18.91,15.81,13.03,9.94,8.22,7.69,7.62,9.56,12.56,15.25,18.03,20.25,21.41,21.88,22.31,21.97,22.0,21.69,22.88,22.59,22.88,23.59,24.47,25.16,25.81,27.16,27.84,27.69,28.03,29.09,28.81,30.44,31.12,30.91,31.5,31.38,28.97,27.56,25.44,23.34,19.53,18.25,17.31,16.5,18.09,18.69,21.12,22.88,24.44,25.38,25.94,26.09,25.34,24.12,23.59,23.94,23.5,23.66,24.34,25.44,26.12,26.25,26.16,25.75,23.03,20.72,19.16,16.09,15.53,16.34,17.25,18.72,20.5,22.84,22.84,24.25,24.91,25.34,25.91,26.91,28.25,28.81,30.19,30.0,29.72,30.19,29.53,29.62,29.97,29.62,29.06,28.62,28.22,28.25,28.78,28.69,29.62,30.66,31.81,32.03,32.19,32.53,31.09,29.53,28.72,28.38,27.5,28.06,26.5,25.19,22.34,19.97,16.78,15.53,13.72,13.94,14.81,15.03,15.62,16.53,17.91,18.66,20.62,23.88,26.47,28.84,30.84,30.56,31.34,28.75,27.38,26.62,25.28,25.81,25.56,25.69,25.62,26.06,26.88,27.09,29.12,32.03,33.69,35.19,36.72,36.75,36.34,36.44,36.31,34.66,35.06,35.03,34.19,34.78,33.75,33.41,33.5,32.09,31.66,31.88,31.56,30.94,31.16,31.0,31.44,31.56,32.81,33.78,35.66,37.34,40.19,41.69,43.88,44.59,43.69,42.06,39.0,35.94,32.84,30.72,28.81,28.62,28.5,28.94,28.66,29.31,29.28,29.06,29.59,28.81,28.34,28.31,28.31,26.84,26.91,27.34,26.19,26.03,25.91,24.72,25.22,25.56,26.28,26.25,27.38,28.34,28.66,29.47,30.25,31.06,30.19,30.19,29.97,29.34,29.0,29.78,29.75,30.47,31.19,31.75,31.81,32.12,31.31,30.72,29.0,27.12,25.31,23.81,22.12,21.16,20.97,20.19,19.84,18.78,18.25,17.5,15.47,14.78,14.81,14.19,15.81,16.88,19.91,21.94,25.06,26.53,27.41,26.75,24.72,21.78,19.25,15.53,13.28,11.72,10.53,10.78,11.53,13.03,14.94,16.81,17.81,18.78,19.12,19.94,19.72,20.53,22.41,23.66,24.53,26.09,26.44,27.0,26.97,25.09,23.75,21.5,19.69,18.06,17.94,18.53,20.06,22.56,24.53,26.56,27.5,28.66,27.38,26.12,25.25,24.22,24.38,24.81,26.53,27.78,27.62,27.34,27.03,26.03,25.44,25.25,24.12,24.25,23.81,23.66,23.38,24.31,24.5,26.03,27.16,28.84,29.75,30.81,29.25,28.41,27.66,28.19,30.12,33.41,36.56,40.5,42.91,43.91,43.44,41.47,39.19,37.34,35.31,35.28,35.75,35.97,37.41,37.16,37.56,37.41,35.53,34.44,32.16,29.66,28.34,27.56,26.31,26.03,26.62,28.06,29.31,30.94,32.06,32.47,32.0,30.19,28.97,27.44,25.12,22.34,20.16,19.19,17.69,18.0,18.66,18.41,19.34,19.38,20.0,21.72,22.12,23.44,25.06,25.34,27.06,29.16,31.12,32.47,33.69,33.06,32.34,30.53,28.25,25.19,23.66,21.19,18.91,16.25,16.31,15.72,15.84,17.31,19.5,21.62,23.0,25.44,27.25,31.19,34.84,38.53,40.44,41.41,40.53,37.75,34.97,32.69,30.34,28.5,26.44,25.56,24.0,23.38,23.16,22.16,20.91,19.53,15.97,12.69,9.41,7.06,4.5,3.59,4.28,5.53,8.53,11.69,15.56,17.44,19.34,18.41,17.16,15.56,13.03,12.75,12.53,12.97,13.91,15.56,16.81,17.22,17.06,17.0,15.75,15.31,14.31,13.34,13.28,13.34,14.12,14.12,14.41,14.94,14.0,13.28,13.66,13.62,13.41,14.44,14.66,15.75,15.88,16.53,18.19,19.81,21.53,22.31,23.34,22.72,21.81,20.84,19.41,18.09,18.5,18.88,19.62,20.34,20.31,19.28,18.16,15.94,13.91,14.28,13.5,13.41,13.81,14.19,15.25,16.03,17.03,18.25,19.78,19.81,19.81,18.31,16.88,15.38,13.62,12.16,10.5,9.28,7.03,4.56,3.0,1.34,1.19,1.72,2.34,3.72,6.0,7.16,10.16,12.31,14.12,15.97,16.22,15.62,14.44,12.88,11.81,10.22,11.03,11.72,13.06,14.62,16.69,16.66,18.34,19.16,18.44,17.69,16.94,16.38,15.31,14.91,14.16,14.66,14.72,15.47,16.0,17.91,18.47,19.09,18.81,18.28,18.56,19.03,19.25,19.41,19.56,18.78,16.75,14.38,12.56,11.16,9.44,9.22,9.38,9.44,10.06,11.06,11.16,11.84,12.41,12.53,12.06,11.66,12.12,10.94,10.62,9.69,9.56,8.88,8.53,8.41,8.0,7.97,7.16,6.12,4.66,3.97,3.75,4.22,5.53,6.31,7.66,8.38,8.12,8.78,8.75,8.31,8.53,8.34,8.84,8.59,8.94,9.12,8.47,8.25,8.88,8.69,9.25,9.56,9.81,9.31,9.03,8.94,9.56,10.34,11.06,12.12,12.91,12.72,14.12,14.25,14.81,16.03,15.31,15.47,15.31,14.09,12.91,10.81,8.5,6.88,5.06,3.88,3.75,2.81,2.72,2.03,1.78,1.38,3.56,4.91,6.62,8.41,10.47,10.81,12.66,13.25,13.25,14.0,12.5,10.88,9.16,9.12,9.72,11.31,15.47,18.84,22.59,24.56,25.38,23.66,20.28,15.91,10.91,6.88,3.06,1.69,1.0,1.0,0.81,2.28,2.91,3.94,4.19,5.16,5.81,6.41,6.53,7.0,7.94,8.28,8.5,8.06,6.41,5.69,2.66,0.0,-2.59,-4.91,-6.22,-7.72,-7.66,-7.97,-7.94,-7.41,-6.97,-6.94,-5.66,-4.66,-3.16,-2.19,0.19,2.84,5.84,9.31,12.0,14.66,15.72,15.47,14.22,13.12,11.41,9.5,8.59,7.84,8.16,7.69,8.41,7.75,7.69,7.0,6.19,5.69,5.0,5.69,6.38,7.72,9.94,12.12,14.03,16.12,17.66,18.44,19.5,19.41,18.56,16.5,14.78,13.44,12.12,12.56,11.97,11.59,10.88,8.5,6.53,5.44,4.5,4.88,5.12,5.59,6.81,8.72,10.06,11.38,12.38,12.88,10.78,9.56,6.56,4.41,1.94,0.25,-1.53,-1.72,-2.16,-2.09,-1.22,-0.31,1.31,2.5,3.22,4.31,5.88,6.88,7.41,8.66,9.31,11.16,12.75,13.62,14.16,13.88,12.75,11.34,9.97,9.19,8.66,8.62,8.25,7.91,8.03,8.06,8.94,9.38,9.91,10.81,12.31,12.75,14.56,15.59,15.94,16.41,15.31,15.31,14.62,14.56,14.09,14.25,13.91,14.06,13.34,12.66,12.56,11.5,10.19,8.53,7.19,6.31,6.16,6.5,7.94,9.38,10.5,11.12,11.06,10.31,9.06,6.34,4.03,1.88,-0.47,-1.03,-0.91,-0.59,1.34,2.62,3.97,23.12,22.25,19.59,17.84,16.66,15.97,15.94,17.84,18.91,20.41,20.62,21.47,19.88,18.75,17.66,15.94,15.25,15.25,16.03,17.75,17.66,17.28,16.91,14.12:22.25,22.12,20.81,19.0,17.66,14.69,11.94,10.12,7.91,7.81,8.47,11.12,15.25,20.38,22.69,25.06,25.03,23.88,21.62,19.12,18.16,18.34,19.5,20.88,23.44,25.31,26.16,26.31,25.06,22.5,19.44,16.94,15.25,13.69,14.34,14.62,16.69,18.28,19.41,20.41,20.59,18.91,15.81,13.03,9.94,8.22,7.69,7.62,9.56,12.56,15.25,18.03,20.25,21.41,21.88,22.31,21.97,22.0,21.69,22.88,22.59,22.88,23.59,24.47,25.16,25.81,27.16,27.84,27.69,28.03,29.09,28.81,30.44,31.12,30.91,31.5,31.38,28.97,27.56,25.44,23.34,19.53,18.25,17.31,16.5,18.09,18.69,21.12,22.88,24.44,25.38,25.94,26.09,25.34,24.12,23.59,23.94,23.5,23.66,24.34,25.44,26.12,26.25,26.16,25.75,23.03,20.72,19.16,16.09,15.53,16.34,17.25,18.72,20.5,22.84,22.84,24.25,24.91,25.34,25.91,26.91,28.25,28.81,30.19,30.0,29.72,30.19,29.53,29.62,29.97,29.62,29.06,28.62,28.22,28.25,28.78,28.69,29.62,30.66,31.81,32.03,32.19,32.53,31.09,29.53,28.72,28.38,27.5,28.06,26.5,25.19,22.34,19.97,16.78,15.53,13.72,13.94,14.81,15.03,15.62,16.53,17.91,18.66,20.62,23.88,26.47,28.84,30.84,30.56,31.34,28.75,27.38,26.62,25.28,25.81,25.56,25.69,25.62,26.06,26.88,27.09,29.12,32.03,33.69,35.19,36.72,36.75,36.34,36.44,36.31,34.66,35.06,35.03,34.19,34.78,33.75,33.41,33.5,32.09,31.66,31.88,31.56,30.94,31.16,31.0,31.44,31.56,32.81,33.78,35.66,37.34,40.19,41.69,43.88,44.59,43.69,42.06,39.0,35.94,32.84,30.72,28.81,28.62,28.5,28.94,28.66,29.31,29.28,29.06,29.59,28.81,28.34,28.31,28.31,26.84,26.91,27.34,26.19,26.03,25.91,24.72,25.22,25.56,26.28,26.25,27.38,28.34,28.66,29.47,30.25,31.06,30.19,30.19,29.97,29.34,29.0,29.78,29.75,30.47,31.19,31.75,31.81,32.12,31.31,30.72,29.0,27.12,25.31,23.81,22.12,21.16,20.97,20.19,19.84,18.78,18.25,17.5,15.47,14.78,14.81,14.19,15.81,16.88,19.91,21.94,25.06,26.53,27.41,26.75,24.72,21.78,19.25,15.53,13.28,11.72,10.53,10.78,11.53,13.03,14.94,16.81,17.81,18.78,19.12,19.94,19.72,20.53,22.41,23.66,24.53,26.09,26.44,27.0,26.97,25.09,23.75,21.5,19.69,18.06,17.94,18.53,20.06,22.56,24.53,26.56,27.5,28.66,27.38,26.12,25.25,24.22,24.38,24.81,26.53,27.78,27.62,27.34,27.03,26.03,25.44,25.25,24.12,24.25,23.81,23.66,23.38,24.31,24.5,26.03,27.16,28.84,29.75,30.81,29.25,28.41,27.66,28.19,30.12,33.41,36.56,40.5,42.91,43.91,43.44,41.47,39.19,37.34,35.31,35.28,35.75,35.97,37.41,37.16,37.56,37.41,35.53,34.44,32.16,29.66,28.34,27.56,26.31,26.03,26.62,28.06,29.31,30.94,32.06,32.47,32.0,30.19,28.97,27.44,25.12,22.34,20.16,19.19,17.69,18.0,18.66,18.41,19.34,19.38,20.0,21.72,22.12,23.44,25.06,25.34,27.06,29.16,31.12,32.47,33.69,33.06,32.34,30.53,28.25,25.19,23.66,21.19,18.91,16.25,16.31,15.72,15.84,17.31,19.5,21.62,23.0,25.44,27.25,31.19,34.84,38.53,40.44,41.41,40.53,37.75,34.97,32.69,30.34,28.5,26.44,25.56,24.0,23.38,23.16,22.16,20.91,19.53,15.97,12.69,9.41,7.06,4.5,3.59,4.28,5.53,8.53,11.69,15.56,17.44,19.34,18.41,17.16,15.56,13.03,12.75,12.53,12.97,13.91,15.56,16.81,17.22,17.06,17.0,15.75,15.31,14.31,13.34,13.28,13.34,14.12,14.12,14.41,14.94,14.0,13.28,13.66,13.62,13.41,14.44,14.66,15.75,15.88,16.53,18.19,19.81,21.53,22.31,23.34,22.72,21.81,20.84,19.41,18.09,18.5,18.88,19.62,20.34,20.31,19.28,18.16,15.94,13.91,14.28,13.5,13.41,13.81,14.19,15.25,16.03,17.03,18.25,19.78,19.81,19.81,18.31,16.88,15.38,13.62,12.16,10.5,9.28,7.03,4.56,3.0,1.34,1.19,1.72,2.34,3.72,6.0,7.16,10.16,12.31,14.12,15.97,16.22,15.62,14.44,12.88,11.81,10.22,11.03,11.72,13.06,14.62,16.69,16.66,18.34,19.16,18.44,17.69,16.94,16.38,15.31,14.91,14.16,14.66,14.72,15.47,16.0,17.91,18.47,19.09,18.81,18.28,18.56,19.03,19.25,19.41,19.56,18.78,16.75,14.38,12.56,11.16,9.44,9.22,9.38,9.44,10.06,11.06,11.16,11.84,12.41,12.53,12.06,11.66,12.12,10.94,10.62,9.69,9.56,8.88,8.53,8.41,8.0,7.97,7.16,6.12,4.66,3.97,3.75,4.22,5.53,6.31,7.66,8.38,8.12,8.78,8.75,8.31,8.53,8.34,8.84,8.59,8.94,9.12,8.47,8.25,8.88,8.69,9.25,9.56,9.81,9.31,9.03,8.94,9.56,10.34,11.06,12.12,12.91,12.72,14.12,14.25,14.81,16.03,15.31,15.47,15.31,14.09,12.91,10.81,8.5,6.88,5.06,3.88,3.75,2.81,2.72,2.03,1.78,1.38,3.56,4.91,6.62,8.41,10.47,10.81,12.66,13.25,13.25,14.0,12.5,10.88,9.16,9.12,9.72,11.31,15.47,18.84,22.59,24.56,25.38,23.66,20.28,15.91,10.91,6.88,3.06,1.69,1.0,1.0,0.81,2.28,2.91,3.94,4.19,5.16,5.81,6.41,6.53,7.0,7.94,8.28,8.5,8.06,6.41,5.69,2.66,0.0,-2.59,-4.91,-6.22,-7.72,-7.66,-7.97,-7.94,-7.41,-6.97,-6.94,-5.66,-4.66,-3.16,-2.19,0.19,2.84,5.84,9.31,12.0,14.66,15.72,15.47,14.22,13.12,11.41,9.5,8.59,7.84,8.16,7.69,8.41,7.75,7.69,7.0,6.19,5.69,5.0,5.69,6.38,7.72,9.94,12.12,14.03,16.12,17.66,18.44,19.5,19.41,18.56,16.5,14.78,13.44,12.12,12.56,11.97,11.59,10.88,8.5,6.53,5.44,4.5,4.88,5.12,5.59,6.81,8.72,10.06,11.38,12.38,12.88,10.78,9.56,6.56,4.41,1.94,0.25,-1.53,-1.72,-2.16,-2.09,-1.22,-0.31,1.31,2.5,3.22,4.31,5.88,6.88,7.41,8.66,9.31,11.16,12.75,13.62,14.16,13.88,12.75,11.34,9.97,9.19,8.66,8.62,8.25,7.91,8.03,8.06,8.94,9.38,9.91,10.81,12.31,12.75,14.56,15.59,15.94,16.41,15.31,15.31,14.62,14.56,14.09,14.25,13.91,14.06,13.34,12.66,12.56,11.5,10.19,8.53,7.19,6.31,6.16,6.5,7.94,9.38,10.5,11.12,11.06,10.31,9.06,6.34,4.03,1.88,-0.47,-1.03,-0.91,-0.59,1.34,2.62,3.97,23.12,22.25,19.59,17.84,16.66,15.97,15.94,17.84,18.91,20.41,20.62,21.47,19.88,18.75,17.66,15.94,15.25,15.25,16.03,17.75,17.66,17.28,16.91,14.12,13.69,11.34,10.94,10.84,11.5,11.94:negativity
21.41,23.62,26.5,26.69,25.06,24.5,23.62,22.56,22.47,22.34,20.03,19.12,15.62,12.84,10.38,9.25,7.66,7.38,8.59,9.91,10.31,13.12,14.81,15.94,16.91,17.06,15.66,14.47,12.34,11.84,12.06,13.5,15.41,19.41,24.41,27.06,29.12,30.91,28.78,25.19,22.75,19.19,16.75,15.06,14.03,12.78,13.38,14.66,15.47,19.56,22.31,25.84,27.91,28.81,29.72,30.16,30.75,31.41,32.53,33.12,33.41,32.19,31.44,29.66,27.94,27.16,26.5,25.84,26.31,27.12,27.72,27.22,27.22,26.66,25.81,24.66,22.0,20.66,19.06,17.28,17.12,18.91,21.78,23.69,25.88,28.38,29.47,29.19,29.69,29.38,28.34,26.59,27.81,27.56,28.91,32.44,35.91,38.0,40.53,41.06,40.88,39.22,38.06,35.72,35.91,35.34,35.81,36.44,36.62,36.97,36.16,35.62,34.53,35.09,35.97,36.19,36.56,38.53,38.84,39.0,39.06,39.0,37.88,36.28,35.0,33.25,33.5,33.28,34.16,34.12,34.34,34.19,31.88,30.69,29.88,29.66,29.84,29.88,30.0,29.25,28.91,27.25,28.44,27.16,27.0,25.56,22.34,19.56,16.53,13.91,11.81,11.84,12.62,14.94,16.25,19.16,19.44,21.5,22.31,22.0,22.31,22.72,23.16,23.44,23.34,25.19,26.22,26.09,25.94,24.16,22.06,18.91,15.84,13.03,11.0,10.66,11.72,13.22,15.94,18.91,20.06,21.81,22.0,22.38,21.66,21.0,20.16,20.75,21.31,22.25,24.25,25.94,26.66,27.47,27.53,27.31,25.69,25.53,24.62,24.31,25.44,26.53,26.94,26.94,26.69,26.56,26.09,28.16,28.75,29.22,29.91,28.97,28.31,28.09,28.19,27.97,27.75,26.47,25.41,24.12,21.53,20.5,18.94,19.5,19.44,19.34,19.91,19.47,18.09,16.59,15.03,13.81,13.81,13.41,13.88,16.0,17.41,20.56,25.38,30.53,36.44,40.75,45.0,46.34,44.5,40.94,37.38,33.28,29.16,27.19,26.69,25.53,25.0,25.66,25.53,25.44,24.59,24.66,24.56,22.12,23.0,22.78,22.88,25.28,26.53,28.12,28.38,29.03,27.5,26.03,24.44,22.81,23.09,22.56,23.22,24.16,25.28,25.16,24.56,25.28,24.19,23.69,24.16,24.03,24.5,26.38,26.88,28.53,29.41,30.16,30.88,30.09,29.94,28.72,28.0,27.28,26.81,27.19,28.38,29.41,31.44,32.19,31.91,30.84,29.97,27.28,27.31,27.75,27.44,27.94,27.25,28.59,28.56,28.16,27.47,26.91,26.19,24.69,24.09,24.38,24.66,24.31,25.69,26.5,28.09,29.66,30.66,29.97,28.25,26.34,24.0,21.75,20.81,21.06,21.56,22.66,25.16,27.81,31.22,33.94,36.0,37.66,37.94,37.0,36.03,34.19,32.03,30.56,28.0,25.81,24.31,24.25,23.38,23.69,23.69,24.47,24.91,24.31,25.09,26.03,27.38,29.31,30.91,31.78,33.47,34.25,33.44,34.19,33.53,32.44,31.22,29.66,27.38,26.22,25.5,24.56,23.34,23.53,23.03,22.06,21.5,20.81,20.41,20.59,21.28,22.0,23.16,24.06,25.56,24.41,25.06,24.03,23.06,23.34,23.22,24.66,25.06,27.69,28.56,30.0,30.94,31.84,31.91,33.12,32.38,32.53,32.25,31.0,30.47,30.0,29.19,28.88,27.69,28.91,29.16,30.59,34.12,37.25,40.19,41.53,43.81,42.34,42.44,40.31,40.06,37.44,36.12,34.16,33.62,31.25,29.31,28.56,27.56,26.81,26.31,27.25,27.06,27.53,27.81,28.72,27.44,28.22,27.47,27.62,28.72,29.41,29.81,30.31,30.19,30.91,32.03,32.03,33.16,31.97,32.0,30.56,30.19,28.25,26.88,24.66,22.44,21.5,21.47,21.5,22.34,23.03,24.16,24.78,24.91,25.94,27.91,29.41,30.94,32.62,35.59,36.5,36.38,34.53,31.88,29.47,26.12,25.78,26.84,28.28,30.53,33.81,35.62,36.75,37.53,36.56,34.81,32.75,30.69,29.0,27.19,27.06,27.0,26.53,27.88,27.91,27.94,28.59,28.5,29.41,30.22,30.44,30.94,30.5,28.41,26.5,25.0,22.03,20.75,20.06,20.38,21.56,23.56,24.66,25.53,26.81,26.41,25.59,24.91,23.34,21.41,20.12,19.16,18.75,18.03,18.81,18.16,19.0,18.25,19.03,19.47,20.25,22.56,24.94,27.34,29.44,31.78,33.09,33.78,33.31,31.88,30.12,28.31,26.34,24.78,23.44,21.62,20.5,20.22,20.59,21.94,23.97,25.16,25.34,25.03,24.06,22.19,21.09,19.56,18.56,18.25,18.5,18.34,19.31,20.09,20.28,20.31,20.06,21.0,21.03,21.25,22.47,24.19,24.69,25.66,26.34,25.56,23.97,21.59,19.41,17.81,17.31,18.06,19.84,21.59,23.56,24.06,23.03,21.84,18.81,16.28,13.81,10.91,9.75,9.16,9.03,10.16,11.66,14.75,16.47,19.28,20.81,20.94,22.03,21.56,22.03,22.06,22.34,23.47,23.69,22.22,21.0,20.62,19.44,19.91,21.31,23.97,25.69,27.66,29.06,29.69,29.72,30.28,28.62,28.25,27.34,26.19,24.59,23.5,21.41,20.81,19.38,18.84,19.16,19.41,21.19,22.62,24.16,26.03,26.94,27.38,26.56,25.28,23.69,21.81,20.5,17.78,18.19,16.66,18.28,18.19,19.28,20.44,20.38,19.97,19.53,18.91,18.03,17.19,16.5,15.78,14.91,14.75,14.56,14.03,15.19,15.25,14.78,14.56,13.03,12.81,11.0,9.66,9.31,8.78,8.78,9.31,10.75,12.03,11.91,12.38,12.66,12.66,12.69,13.16,13.31,12.59,11.81,10.72,8.81,8.41,8.03,8.78,9.81,11.62,13.06,15.38,16.16,16.53,17.19,17.16,18.19,19.09,20.72,23.25,24.06,25.31,24.66,24.38,23.5,22.72,23.41,24.12,25.88,27.56,29.5,30.19,30.22,29.34,27.56,25.53,24.34,23.03,22.03,22.41,21.94,21.41,22.62,20.94,19.84,18.69,16.34,14.62,12.0,10.03,8.72,7.41,7.66,6.84,7.47,7.31,7.94,7.62,7.16,6.78,6.91,6.31,6.41,7.44,8.84,11.12,14.03,17.44,20.84,22.78,23.91,22.94,22.5,21.03,19.97,18.88,18.06,16.22,14.5,11.12,8.53,4.81,3.38,3.0,3.97,5.69,10.22,13.41,17.0,20.22,23.03,25.94,27.25,29.69,31.31,33.97,34.91,35.81,36.62,36.69,36.28,36.09,35.91,35.16,34.25,32.0,29.34,25.97,22.72,20.28,18.0,18.47,18.66,19.53,21.88,22.84,24.34,25.03,25.28,26.06,26.09,25.56,26.19,25.72,24.25,22.72,21.06,18.31,16.12,14.78,12.94,11.75,11.62,10.88,11.44,11.94,13.56,14.91,15.84,17.16,16.38,16.41,16.22,16.31,17.72,19.06,20.12,20.5,19.81,18.47,16.56,14.62,12.69,11.41,9.69,7.53,4.97,4.16,2.69,2.44,3.75,5.84,8.75,9.91,11.53,12.75,12.28,12.44,12.41,11.66,11.53,10.62,9.81,9.56,8.84,8.38,8.81,7.97,8.75,9.94,10.88,12.16,12.31,12.44,12.41,12.31,12.12,11.97,10.81,8.44,5.78,3.41,1.66,1.19,2.06,3.75,5.97,8.31,9.66,10.78,11.97,12.34,13.25,13.97,13.41,12.94,12.44:23.62,22.56,22.47,22.34,20.03,19.12,15.62,12.84,10.38,9.25,7.66,7.38,8.59,9.91,10.31,13.12,14.81,15.94,16.91,17.06,15.66,14.47,12.34,11.84,12.06,13.5,15.41,19.41,24.41,27.06,29.12,30.91,28.78,25.19,22.75,19.19,16.75,15.06,14.03,12.78,13.38,14.66,15.47,19.56,22.31,25.84,27.91,28.81,29.72,30.16,30.75,31.41,32.53,33.12,33.41,32.19,31.44,29.66,27.94,27.16,26.5,25.84,26.31,27.12,27.72,27.22,27.22,26.66,25.81,24.66,22.0,20.66,19.06,17.28,17.12,18.91,21.78,23.69,25.88,28.38,29.47,29.19,29.69,29.38,28.34,26.59,27.81,27.56,28.91,32.44,35.91,38.0,40.53,41.06,40.88,39.22,38.06,35.72,35.91,35.34,35.81,36.44,36.62,36.97,36.16,35.62,34.53,35.09,35.97,36.19,36.56,38.53,38.84,39.0,39.06,39.0,37.88,36.28,35.0,33.25,33.5,33.28,34.16,34.12,34.34,34.19,31.88,30.69,29.88,29.66,29.84,29.88,30.0,29.25,28.91,27.25,28.44,27.16,27.0,25.56,22.34,19.56,16.53,13.91,11.81,11.84,12.62,14.94,16.25,19.16,19.44,21.5,22.31,22.0,22.31,22.72,23.16,23.44,23.34,25.19,26.22,26.09,25.94,24.16,22.06,18.91,15.84,13.03,11.0,10.66,11.72,13.22,15.94,18.91,20.06,21.81,22.0,22.38,21.66,21.0,20.16,20.75,21.31,22.25,24.25,25.94,26.66,27.47,27.53,27.31,25.69,25.53,24.62,24.31,25.44,26.53,26.94,26.94,26.69,26.56,26.09,28.16,28.75,29.22,29.91,28.97,28.31,28.09,28.19,27.97,27.75,26.47,25.41,24.12,21.53,20.5,18.94,19.5,19.44,19.34,19.91,19.47,18.09,16.59,15.03,13.81,13.81,13.41,13.88,16.0,17.41,20.56,25.38,30.53,36.44,40.75,45.0,46.34,44.5,40.94,37.38,33.28,29.16,27.19,26.69,25.53,25.0,25.66,25.53,25.44,24.59,24.66,24.56,22.12,23.0,22.78,22.88,25.28,26.53,28.12,28.38,29.03,27.5,26.03,24.44,22.81,23.09,22.56,23.22,24.16,25.28,25.16,24.56,25.28,24.19,23.69,24.16,24.03,24.5,26.38,26.88,28.53,29.41,30.16,30.88,30.09,29.94,28.72,28.0,27.28,26.81,27.19,28.38,29.41,31.44,32.19,31.91,30.84,29.97,27.28,27.31,27.75,27.44,27.94,27.25,28.59,28.56,28.16,27.47,26.91,26.19,24.69,24.09,24.38,24.66,24.31,25.69,26.5,28.09,29.66,30.66,29.97,28.25,26.34,24.0,21.75,20.81,21.06,21.56,22.66,25.16,27.81,31.22,33.94,36.0,37.66,37.94,37.0,36.03,34.19,32.03,30.56,28.0,25.81,24.31,24.25,23.38,23.69,23.69,24.47,24.91,24.31,25.09,26.03,27.38,29.31,30.91,31.78,33.47,34.25,33.44,34.19,33.53,32.44,31.22,29.66,27.38,26.22,25.5,24.56,23.34,23.53,23.03,22.06,21.5,20.81,20.41,20.59,21.28,22.0,23.16,24.06,25.56,24.41,25.06,24.03,23.06,23.34,23.22,24.66,25.06,27.69,28.56,30.0,30.94,31.84,31.91,33.12,32.38,32.53,32.25,31.0,30.47,30.0,29.19,28.88,27.69,28.91,29.16,30.59,34.12,37.25,40.19,41.53,43.81,42.34,42.44,40.31,40.06,37.44,36.12,34.16,33.62,31.25,29.31,28.56,27.56,26.81,26.31,27.25,27.06,27.53,27.81,28.72,27.44,28.22,27.47,27.62,28.72,29.41,29.81,30.31,30.19,30.91,32.03,32.03,33.16,31.97,32.0,30.56,30.19,28.25,26.88,24.66,22.44,21.5,21.47,21.5,22.34,23.03,24.16,24.78,24.91,25.94,27.91,29.41,30.94,32.62,35.59,36.5,36.38,34.53,31.88,29.47,26.12,25.78,26.84,28.28,30.53,33.81,35.62,36.75,37.53,36.56,34.81,32.75,30.69,29.0,27.19,27.06,27.0,26.53,27.88,27.91,27.94,28.59,28.5,29.41,30.22,30.44,30.94,30.5,28.41,26.5,25.0,22.03,20.75,20.06,20.38,21.56,23.56,24.66,25.53,26.81,26.41,25.59,24.91,23.34,21.41,20.12,19.16,18.75,18.03,18.81,18.16,19.0,18.25,19.03,19.47,20.25,22.56,24.94,27.34,29.44,31.78,33.09,33.78,33.31,31.88,30.12,28.31,26.34,24.78,23.44,21.62,20.5,20.22,20.59,21.94,23.97,25.16,25.34,25.03,24.06,22.19,21.09,19.56,18.56,18.25,18.5,18.34,19.31,20.09,20.28,20.31,20.06,21.0,21.03,21.25,22.47,24.19,24.69,25.66,26.34,25.56,23.97,21.59,19.41,17.81,17.31,18.06,19.84,21.59,23.56,24.06,23.03,21.84,18.81,16.28,13.81,10.91,9.75,9.16,9.03,10.16,11.66,14.75,16.47,19.28,20.81,20.94,22.03,21.56,22.03,22.06,22.34,23.47,23.69,22.22,21.0,20.62,19.44,19.91,21.31,23.97,25.69,27.66,29.06,29.69,29.72,30.28,28.62,28.25,27.34,26.19,24.59,23.5,21.41,20.81,19.38,18.84,19.16,19.41,21.19,22.62,24.16,26.03,26.94,27.38,26.56,25.28,23.69,21.81,20.5,17.78,18.19,16.66,18.28,18.19,19.28,20.44,20.38,19.97,19.53,18.91,18.03,17.19,16.5,15.78,14.91,14.75,14.56,14.03,15.19,15.25,14.78,14.56,13.03,12.81,11.0,9.66,9.31,8.78,8.78,9.31,10.75,12.03,11.91,12.38,12.66,12.66,12.69,13.16,13.31,12.59,11.81,10.72,8.81,8.41,8.03,8.78,9.81,11.62,13.06,15.38,16.16,16.53,17.19,17.16,18.19,19.09,20.72,23.25,24.06,25.31,24.66,24.38,23.5,22.72,23.41,24.12,25.88,27.56,29.5,30.19,30.22,29.34,27.56,25.53,24.34,23.03,22.03,22.41,21.94,21.41,22.62,20.94,19.84,18.69,16.34,14.62,12.0,10.03,8.72,7.41,7.66,6.84,7.47,7.31,7.94,7.62,7.16,6.78,6.91,6.31,6.41,7.44,8.84,11.12,14.03,17.44,20.84,22.78,23.91,22.94,22.5,21.03,19.97,18.88,18.06,16.22,14.5,11.12,8.53,4.81,3.38,3.0,3.97,5.69,10.22,13.41,17.0,20.22,23.03,25.94,27.25,29.69,31.31,33.97,34.91,35.81,36.62,36.69,36.28,36.09,35.91,35.16,34.25,32.0,29.34,25.97,22.72,20.28,18.0,18.47,18.66,19.53,21.88,22.84,24.34,25.03,25.28,26.06,26.09,25.56,26.19,25.72,24.25,22.72,21.06,18.31,16.12,14.78,12.94,11.75,11.62,10.88,11.44,11.94,13.56,14.91,15.84,17.16,16.38,16.41,16.22,16.31,17.72,19.06,20.12,20.5,19.81,18.47,16.56,14.62,12.69,11.41,9.69,7.53,4.97,4.16,2.69,2.44,3.75,5.84,8.75,9.91,11.53,12.75,12.28,12.44,12.41,11.66,11.53,10.62,9.81,9.56,8.84,8.38,8.81,7.97,8.75,9.94,10.88,12.16,12.31,12.44,12.41,12.31,12.12,11.97,10.81,8.44,5.78,3.41,1.66,1.19,2.06,3.75,5.97,8.31,9.66,10.78,11.97,12.34,13.25,13.97,13.41,12.94,12.44,5.38,6.84,8.69,12.72,17.78,22.94:15.62,12.84,10.38,9.25,7.66,7.38,8.59,9.91,10.31,13.12,14.81,15.94,16.91,17.06,15.66,14.47,12.34,11.84,12.06,13.5,15.41,19.41,24.41,27.06,29.12,30.91,28.78,25.19,22.75,19.19,16.75,15.06,14.03,12.78,13.38,14.66,15.47,19.56,22.31,25.84,27.91,28.81,29.72,30.16,30.75,31.41,32.53,33.12,33.41,32.19,31.44,29.66,27.94,27.16,26.5,25.84,26.31,27.12,27.72,27.22,27.22,26.66,25.81,24.66,22.0,20.66,19.06,17.28,17.12,18.91,21.78,23.69,25.88,28.38,29.47,29.19,29.69,29.38,28.34,26.59,27.81,27.56,28.91,32.44,35.91,38.0,40.53,41.06,40.88,39.22,38.06,35.72,35.91,35.34,35.81,36.44,36.62,36.97,36.16,35.62,34.53,35.09,35.97,36.19,36.56,38.53,38.84,39.0,39.06,39.0,37.88,36.28,35.0,33.25,33.5,33.28,34.16,34.12,34.34,34.19,31.88,30.69,29.88,29.66,29.84,29.88,30.0,29.25,28.91,27.25,28.44,27.16,27.0,25.56,22.34,19.56,16.53,13.91,11.81,11.84,12.62,14.94,16.25,19.16,19.44,21.5,22.31,22.0,22.31,22.72,23.16,23.44,23.34,25.19,26.22,26.09,25.94,24.16,22.06,18.91,15.84,13.03,11.0,10.66,11.72,13.22,15.94,18.91,20.06,21.81,22.0,22.38,21.66,21.0,20.16,20.75,21.31,22.25,24.25,25.94,26.66,27.47,27.53,27.31,25.69,25.53,24.62,24.31,25.44,26.53,26.94,26.94,26.69,26.56,26.09,28.16,28.75,29.22,29.91,28.97,28.31,28.09,28.19,27.97,27.75,26.47,25.41,24.12,21.53,20.5,18.94,19.5,19.44,19.34,19.91,19.47,18.09,16.59,15.03,13.81,13.81,13.41,13.88,16.0,17.41,20.56,25.38,30.53,36.44,40.75,45.0,46.34,44.5,40.94,37.38,33.28,29.16,27.19,26.69,25.53,25.0,25.66,25.53,25.44,24.59,24.66,24.56,22.12,23.0,22.78,22.88,25.28,26.53,28.12,28.38,29.03,27.5,26.03,24.44,22.81,23.09,22.56,23.22,24.16,25.28,25.16,24.56,25.28,24.19,23.69,24.16,24.03,24.5,26.38,26.88,28.53,29.41,30.16,30.88,30.09,29.94,28.72,28.0,27.28,26.81,27.19,28.38,29.41,31.44,32.19,31.91,30.84,29.97,27.28,27.31,27.75,27.44,27.94,27.25,28.59,28.56,28.16,27.47,26.91,26.19,24.69,24.09,24.38,24.66,24.31,25.69,26.5,28.09,29.66,30.66,29.97,28.25,26.34,24.0,21.75,20.81,21.06,21.56,22.66,25.16,27.81,31.22,33.94,36.0,37.66,37.94,37.0,36.03,34.19,32.03,30.56,28.0,25.81,24.31,24.25,23.38,23.69,23.69,24.47,24.91,24.31,25.09,26.03,27.38,29.31,30.91,31.78,33.47,34.25,33.44,34.19,33.53,32.44,31.22,29.66,27.38,26.22,25.5,24.56,23.34,23.53,23.03,22.06,21.5,20.81,20.41,20.59,21.28,22.0,23.16,24.06,25.56,24.41,25.06,24.03,23.06,23.34,23.22,24.66,25.06,27.69,28.56,30.0,30.94,31.84,31.91,33.12,32.38,32.53,32.25,31.0,30.47,30.0,29.19,28.88,27.69,28.91,29.16,30.59,34.12,37.25,40.19,41.53,43.81,42.34,42.44,40.31,40.06,37.44,36.12,34.16,33.62,31.25,29.31,28.56,27.56,26.81,26.31,27.25,27.06,27.53,27.81,28.72,27.44,28.22,27.47,27.62,28.72,29.41,29.81,30.31,30.19,30.91,32.03,32.03,33.16,31.97,32.0,30.56,30.19,28.25,26.88,24.66,22.44,21.5,21.47,21.5,22.34,23.03,24.16,24.78,24.91,25.94,27.91,29.41,30.94,32.62,35.59,36.5,36.38,34.53,31.88,29.47,26.12,25.78,26.84,28.28,30.53,33.81,35.62,36.75,37.53,36.56,34.81,32.75,30.69,29.0,27.19,27.06,27.0,26.53,27.88,27.91,27.94,28.59,28.5,29.41,30.22,30.44,30.94,30.5,28.41,26.5,25.0,22.03,20.75,20.06,20.38,21.56,23.56,24.66,25.53,26.81,26.41,25.59,24.91,23.34,21.41,20.12,19.16,18.75,18.03,18.81,18.16,19.0,18.25,19.03,19.47,20.25,22.56,24.94,27.34,29.44,31.78,33.09,33.78,33.31,31.88,30.12,28.31,26.34,24.78,23.44,21.62,20.5,20.22,20.59,21.94,23.97,25.16,25.34,25.03,24.06,22.19,21.09,19.56,18.56,18.25,18.5,18.34,19.31,20.09,20.28,20.31,20.06,21.0,21.03,21.25,22.47,24.19,24.69,25.66,26.34,25.56,23.97,21.59,19.41,17.81,17.31,18.06,19.84,21.59,23.56,24.06,23.03,21.84,18.81,16.28,13.81,10.91,9.75,9.16,9.03,10.16,11.66,14.75,16.47,19.28,20.81,20.94,22.03,21.56,22.03,22.06,22.34,23.47,23.69,22.22,21.0,20.62,19.44,19.91,21.31,23.97,25.69,27.66,29.06,29.69,29.72,30.28,28.62,28.25,27.34,26.19,24.59,23.5,21.41,20.81,19.38,18.84,19.16,19.41,21.19,22.62,24.16,26.03,26.94,27.38,26.56,25.28,23.69,21.81,20.5,17.78,18.19,16.66,18.28,18.19,19.28,20.44,20.38,19.97,19.53,18.91,18.03,17.19,16.5,15.78,14.91,14.75,14.56,14.03,15.19,15.25,14.78,14.56,13.03,12.81,11.0,9.66,9.31,8.78,8.78,9.31,10.75,12.03,11.91,12.38,12.66,12.66,12.69,13.16,13.31,12.59,11.81,10.72,8.81,8.41,8.03,8.78,9.81,11.62,13.06,15.38,16.16,16.53,17.19,17.16,18.19,19.09,20.72,23.25,24.06,25.31,24.66,24.38,23.5,22.72,23.41,24.12,25.88,27.56,29.5,30.19,30.22,29.34,27.56,25.53,24.34,23.03,22.03,22.41,21.94,21.41,22.62,20.94,19.84,18.69,16.34,14.62,12.0,10.03,8.72,7.41,7.66,6.84,7.47,7.31,7.94,7.62,7.16,6.78,6.91,6.31,6.41,7.44,8.84,11.12,14.03,17.44,20.84,22.78,23.91,22.94,22.5,21.03,19.97,18.88,18.06,16.22,14.5,11.12,8.53,4.81,3.38,3.0,3.97,5.69,10.22,13.41,17.0,20.22,23.03,25.94,27.25,29.69,31.31,33.97,34.91,35.81,36.62,36.69,36.28,36.09,35.91,35.16,34.25,32.0,29.34,25.97,22.72,20.28,18.0,18.47,18.66,19.53,21.88,22.84,24.34,25.03,25.28,26.06,26.09,25.56,26.19,25.72,24.25,22.72,21.06,18.31,16.12,14.78,12.94,11.75,11.62,10.88,11.44,11.94,13.56,14.91,15.84,17.16,16.38,16.41,16.22,16.31,17.72,19.06,20.12,20.5,19.81,18.47,16.56,14.62,12.69,11.41,9.69,7.53,4.97,4.16,2.69,2.44,3.75,5.84,8.75,9.91,11.53,12.75,12.28,12.44,12.41,11.66,11.53,10.62,9.81,9.56,8.84,8.38,8.81,7.97,8.75,9.94,10.88,12.16,12.31,12.44,12.41,12.31,12.12,11.97,10.81,8.44,5.78,3.41,1.66,1.19,2.06,3.75,5.97,8.31,9.66,10.78,11.97,12.34,13.25,13.97,13.41,12.94,12.44,5.38,6.84,8.69,12.72,17.78,22.94,26.88,30.78,32.81,35.03,34.12,32.69:8.59,9.91,10.31,13.12,14.81,15.94,16.91,17.06,15.66,14.47,12.34,11.84,12.06,13.5,15.41,19.41,24.41,27.06,29.12,30.91,28.78,25.19,22.75,19.19,16.75,15.06,14.03,12.78,13.38,14.66,15.47,19.56,22.31,25.84,27.91,28.81,29.72,30.16,30.75,31.41,32.53,33.12,33.41,32.19,31.44,29.66,27.94,27.16,26.5,25.84,26.31,27.12,27.72,27.22,27.22,26.66,25.81,24.66,22.0,20.66,19.06,17.28,17.12,18.91,21.78,23.69,25.88,28.38,29.47,29.19,29.69,29.38,28.34,26.59,27.81,27.56,28.91,32.44,35.91,38.0,40.53,41.06,40.88,39.22,38.06,35.72,35.91,35.34,35.81,36.44,36.62,36.97,36.16,35.62,34.53,35.09,35.97,36.19,36.56,38.53,38.84,39.0,39.06,39.0,37.88,36.28,35.0,33.25,33.5,33.28,34.16,34.12,34.34,34.19,31.88,30.69,29.88,29.66,29.84,29.88,30.0,29.25,28.91,27.25,28.44,27.16,27.0,25.56,22.34,19.56,16.53,13.91,11.81,11.84,12.62,14.94,16.25,19.16,19.44,21.5,22.31,22.0,22.31,22.72,23.16,23.44,23.34,25.19,26.22,26.09,25.94,24.16,22.06,18.91,15.84,13.03,11.0,10.66,11.72,13.22,15.94,18.91,20.06,21.81,22.0,22.38,21.66,21.0,20.16,20.75,21.31,22.25,24.25,25.94,26.66,27.47,27.53,27.31,25.69,25.53,24.62,24.31,25.44,26.53,26.94,26.94,26.69,26.56,26.09,28.16,28.75,29.22,29.91,28.97,28.31,28.09,28.19,27.97,27.75,26.47,25.41,24.12,21.53,20.5,18.94,19.5,19.44,19.34,19.91,19.47,18.09,16.59,15.03,13.81,13.81,13.41,13.88,16.0,17.41,20.56,25.38,30.53,36.44,40.75,45.0,46.34,44.5,40.94,37.38,33.28,29.16,27.19,26.69,25.53,25.0,25.66,25.53,25.44,24.59,24.66,24.56,22.12,23.0,22.78,22.88,25.28,26.53,28.12,28.38,29.03,27.5,26.03,24.44,22.81,23.09,22.56,23.22,24.16,25.28,25.16,24.56,25.28,24.19,23.69,24.16,24.03,24.5,26.38,26.88,28.53,29.41,30.16,30.88,30.09,29.94,28.72,28.0,27.28,26.81,27.19,28.38,29.41,31.44,32.19,31.91,30.84,29.97,27.28,27.31,27.75,27.44,27.94,27.25,28.59,28.56,28.16,27.47,26.91,26.19,24.69,24.09,24.38,24.66,24.31,25.69,26.5,28.09,29.66,30.66,29.97,28.25,26.34,24.0,21.75,20.81,21.06,21.56,22.66,25.16,27.81,31.22,33.94,36.0,37.66,37.94,37.0,36.03,34.19,32.03,30.56,28.0,25.81,24.31,24.25,23.38,23.69,23.69,24.47,24.91,24.31,25.09,26.03,27.38,29.31,30.91,31.78,33.47,34.25,33.44,34.19,33.53,32.44,31.22,29.66,27.38,26.22,25.5,24.56,23.34,23.53,23.03,22.06,21.5,20.81,20.41,20.59,21.28,22.0,23.16,24.06,25.56,24.41,25.06,24.03,23.06,23.34,23.22,24.66,25.06,27.69,28.56,30.0,30.94,31.84,31.91,33.12,32.38,32.53,32.25,31.0,30.47,30.0,29.19,28.88,27.69,28.91,29.16,30.59,34.12,37.25,40.19,41.53,43.81,42.34,42.44,40.31,40.06,37.44,36.12,34.16,33.62,31.25,29.31,28.56,27.56,26.81,26.31,27.25,27.06,27.53,27.81,28.72,27.44,28.22,27.47,27.62,28.72,29.41,29.81,30.31,30.19,30.91,32.03,32.03,33.16,31.97,32.0,30.56,30.19,28.25,26.88,24.66,22.44,21.5,21.47,21.5,22.34,23.03,24.16,24.78,24.91,25.94,27.91,29.41,30.94,32.62,35.59,36.5,36.38,34.53,31.88,29.47,26.12,25.78,26.84,28.28,30.53,33.81,35.62,36.75,37.53,36.56,34.81,32.75,30.69,29.0,27.19,27.06,27.0,26.53,27.88,27.91,27.94,28.59,28.5,29.41,30.22,30.44,30.94,30.5,28.41,26.5,25.0,22.03,20.75,20.06,20.38,21.56,23.56,24.66,25.53,26.81,26.41,25.59,24.91,23.34,21.41,20.12,19.16,18.75,18.03,18.81,18.16,19.0,18.25,19.03,19.47,20.25,22.56,24.94,27.34,29.44,31.78,33.09,33.78,33.31,31.88,30.12,28.31,26.34,24.78,23.44,21.62,20.5,20.22,20.59,21.94,23.97,25.16,25.34,25.03,24.06,22.19,21.09,19.56,18.56,18.25,18.5,18.34,19.31,20.09,20.28,20.31,20.06,21.0,21.03,21.25,22.47,24.19,24.69,25.66,26.34,25.56,23.97,21.59,19.41,17.81,17.31,18.06,19.84,21.59,23.56,24.06,23.03,21.84,18.81,16.28,13.81,10.91,9.75,9.16,9.03,10.16,11.66,14.75,16.47,19.28,20.81,20.94,22.03,21.56,22.03,22.06,22.34,23.47,23.69,22.22,21.0,20.62,19.44,19.91,21.31,23.97,25.69,27.66,29.06,29.69,29.72,30.28,28.62,28.25,27.34,26.19,24.59,23.5,21.41,20.81,19.38,18.84,19.16,19.41,21.19,22.62,24.16,26.03,26.94,27.38,26.56,25.28,23.69,21.81,20.5,17.78,18.19,16.66,18.28,18.19,19.28,20.44,20.38,19.97,19.53,18.91,18.03,17.19,16.5,15.78,14.91,14.75,14.56,14.03,15.19,15.25,14.78,14.56,13.03,12.81,11.0,9.66,9.31,8.78,8.78,9.31,10.75,12.03,11.91,12.38,12.66,12.66,12.69,13.16,13.31,12.59,11.81,10.72,8.81,8.41,8.03,8.78,9.81,11.62,13.06,15.38,16.16,16.53,17.19,17.16,18.19,19.09,20.72,23.25,24.06,25.31,24.66,24.38,23.5,22.72,23.41,24.12,25.88,27.56,29.5,30.19,30.22,29.34,27.56,25.53,24.34,23.03,22.03,22.41,21.94,21.41,22.62,20.94,19.84,18.69,16.34,14.62,12.0,10.03,8.72,7.41,7.66,6.84,7.47,7.31,7.94,7.62,7.16,6.78,6.91,6.31,6.41,7.44,8.84,11.12,14.03,17.44,20.84,22.78,23.91,22.94,22.5,21.03,19.97,18.88,18.06,16.22,14.5,11.12,8.53,4.81,3.38,3.0,3.97,5.69,10.22,13.41,17.0,20.22,23.03,25.94,27.25,29.69,31.31,33.97,34.91,35.81,36.62,36.69,36.28,36.09,35.91,35.16,34.25,32.0,29.34,25.97,22.72,20.28,18.0,18.47,18.66,19.53,21.88,22.84,24.34,25.03,25.28,26.06,26.09,25.56,26.19,25.72,24.25,22.72,21.06,18.31,16.12,14.78,12.94,11.75,11.62,10.88,11.44,11.94,13.56,14.91,15.84,17.16,16.38,16.41,16.22,16.31,17.72,19.06,20.12,20.5,19.81,18.47,16.56,14.62,12.69,11.41,9.69,7.53,4.97,4.16,2.69,2.44,3.75,5.84,8.75,9.91,11.53,12.75,12.28,12.44,12.41,11.66,11.53,10.62,9.81,9.56,8.84,8.38,8.81,7.97,8.75,9.94,10.88,12.16,12.31,12.44,12.41,12.31,12.12,11.97,10.81,8.44,5.78,3.41,1.66,1.19,2.06,3.75,5.97,8.31,9.66,10.78,11.97,12.34,13.25,13.97,13.41,12.94,12.44,5.38,6.84,8.69,12.72,17.78,22.94,26.88,30.78,32.81,35.03,34.12,32.69,29.5,27.03,23.25,20.69,17.78,17.12:16.91,17.06,15.66,14.47,12.34,11.84,12.06,13.5,15.41,19.41,24.41,27.06,29.12,30.91,28.78,25.19,22.75,19.19,16.75,15.06,14.03,12.78,13.38,14.66,15.47,19.56,22.31,25.84,27.91,28.81,29.72,30.16,30.75,31.41,32.53,33.12,33.41,32.19,31.44,29.66,27.94,27.16,26.5,25.84,26.31,27.12,27.72,27.22,27.22,26.66,25.81,24.66,22.0,20.66,19.06,17.28,17.12,18.91,21.78,23.69,25.88,28.38,29.47,29.19,29.69,29.38,28.34,26.59,27.81,27.56,28.91,32.44,35.91,38.0,40.53,41.06,40.88,39.22,38.06,35.72,35.91,35.34,35.81,36.44,36.62,36.97,36.16,35.62,34.53,35.09,35.97,36.19,36.56,38.53,38.84,39.0,39.06,39.0,37.88,36.28,35.0,33.25,33.5,33.28,34.16,34.12,34.34,34.19,31.88,30.69,29.88,29.66,29.84,29.88,30.0,29.25,28.91,27.25,28.44,27.16,27.0,25.56,22.34,19.56,16.53,13.91,11.81,11.84,12.62,14.94,16.25,19.16,19.44,21.5,22.31,22.0,22.31,22.72,23.16,23.44,23.34,25.19,26.22,26.09,25.94,24.16,22.06,18.91,15.84,13.03,11.0,10.66,11.72,13.22,15.94,18.91,20.06,21.81,22.0,22.38,21.66,21.0,20.16,20.75,21.31,22.25,24.25,25.94,26.66,27.47,27.53,27.31,25.69,25.53,24.62,24.31,25.44,26.53,26.94,26.94,26.69,26.56,26.09,28.16,28.75,29.22,29.91,28.97,28.31,28.09,28.19,27.97,27.75,26.47,25.41,24.12,21.53,20.5,18.94,19.5,19.44,19.34,19.91,19.47,18.09,16.59,15.03,13.81,13.81,13.41,13.88,16.0,17.41,20.56,25.38,30.53,36.44,40.75,45.0,46.34,44.5,40.94,37.38,33.28,29.16,27.19,26.69,25.53,25.0,25.66,25.53,25.44,24.59,24.66,24.56,22.12,23.0,22.78,22.88,25.28,26.53,28.12,28.38,29.03,27.5,26.03,24.44,22.81,23.09,22.56,23.22,24.16,25.28,25.16,24.56,25.28,24.19,23.69,24.16,24.03,24.5,26.38,26.88,28.53,29.41,30.16,30.88,30.09,29.94,28.72,28.0,27.28,26.81,27.19,28.38,29.41,31.44,32.19,31.91,30.84,29.97,27.28,27.31,27.75,27.44,27.94,27.25,28.59,28.56,28.16,27.47,26.91,26.19,24.69,24.09,24.38,24.66,24.31,25.69,26.5,28.09,29.66,30.66,29.97,28.25,26.34,24.0,21.75,20.81,21.06,21.56,22.66,25.16,27.81,31.22,33.94,36.0,37.66,37.94,37.0,36.03,34.19,32.03,30.56,28.0,25.81,24.31,24.25,23.38,23.69,23.69,24.47,24.91,24.31,25.09,26.03,27.38,29.31,30.91,31.78,33.47,34.25,33.44,34.19,33.53,32.44,31.22,29.66,27.38,26.22,25.5,24.56,23.34,23.53,23.03,22.06,21.5,20.81,20.41,20.59,21.28,22.0,23.16,24.06,25.56,24.41,25.06,24.03,23.06,23.34,23.22,24.66,25.06,27.69,28.56,30.0,30.94,31.84,31.91,33.12,32.38,32.53,32.25,31.0,30.47,30.0,29.19,28.88,27.69,28.91,29.16,30.59,34.12,37.25,40.19,41.53,43.81,42.34,42.44,40.31,40.06,37.44,36.12,34.16,33.62,31.25,29.31,28.56,27.56,26.81,26.31,27.25,27.06,27.53,27.81,28.72,27.44,28.22,27.47,27.62,28.72,29.41,29.81,30.31,30.19,30.91,32.03,32.03,33.16,31.97,32.0,30.56,30.19,28.25,26.88,24.66,22.44,21.5,21.47,21.5,22.34,23.03,24.16,24.78,24.91,25.94,27.91,29.41,30.94,32.62,35.59,36.5,36.38,34.53,31.88,29.47,26.12,25.78,26.84,28.28,30.53,33.81,35.62,36.75,37.53,36.56,34.81,32.75,30.69,29.0,27.19,27.06,27.0,26.53,27.88,27.91,27.94,28.59,28.5,29.41,30.22,30.44,30.94,30.5,28.41,26.5,25.0,22.03,20.75,20.06,20.38,21.56,23.56,24.66,25.53,26.81,26.41,25.59,24.91,23.34,21.41,20.12,19.16,18.75,18.03,18.81,18.16,19.0,18.25,19.03,19.47,20.25,22.56,24.94,27.34,29.44,31.78,33.09,33.78,33.31,31.88,30.12,28.31,26.34,24.78,23.44,21.62,20.5,20.22,20.59,21.94,23.97,25.16,25.34,25.03,24.06,22.19,21.09,19.56,18.56,18.25,18.5,18.34,19.31,20.09,20.28,20.31,20.06,21.0,21.03,21.25,22.47,24.19,24.69,25.66,26.34,25.56,23.97,21.59,19.41,17.81,17.31,18.06,19.84,21.59,23.56,24.06,23.03,21.84,18.81,16.28,13.81,10.91,9.75,9.16,9.03,10.16,11.66,14.75,16.47,19.28,20.81,20.94,22.03,21.56,22.03,22.06,22.34,23.47,23.69,22.22,21.0,20.62,19.44,19.91,21.31,23.97,25.69,27.66,29.06,29.69,29.72,30.28,28.62,28.25,27.34,26.19,24.59,23.5,21.41,20.81,19.38,18.84,19.16,19.41,21.19,22.62,24.16,26.03,26.94,27.38,26.56,25.28,23.69,21.81,20.5,17.78,18.19,16.66,18.28,18.19,19.28,20.44,20.38,19.97,19.53,18.91,18.03,17.19,16.5,15.78,14.91,14.75,14.56,14.03,15.19,15.25,14.78,14.56,13.03,12.81,11.0,9.66,9.31,8.78,8.78,9.31,10.75,12.03,11.91,12.38,12.66,12.66,12.69,13.16,13.31,12.59,11.81,10.72,8.81,8.41,8.03,8.78,9.81,11.62,13.06,15.38,16.16,16.53,17.19,17.16,18.19,19.09,20.72,23.25,24.06,25.31,24.66,24.38,23.5,22.72,23.41,24.12,25.88,27.56,29.5,30.19,30.22,29.34,27.56,25.53,24.34,23.03,22.03,22.41,21.94,21.41,22.62,20.94,19.84,18.69,16.34,14.62,12.0,10.03,8.72,7.41,7.66,6.84,7.47,7.31,7.94,7.62,7.16,6.78,6.91,6.31,6.41,7.44,8.84,11.12,14.03,17.44,20.84,22.78,23.91,22.94,22.5,21.03,19.97,18.88,18.06,16.22,14.5,11.12,8.53,4.81,3.38,3.0,3.97,5.69,10.22,13.41,17.0,20.22,23.03,25.94,27.25,29.69,31.31,33.97,34.91,35.81,36.62,36.69,36.28,36.09,35.91,35.16,34.25,32.0,29.34,25.97,22.72,20.28,18.0,18.47,18.66,19.53,21.88,22.84,24.34,25.03,25.28,26.06,26.09,25.56,26.19,25.72,24.25,22.72,21.06,18.31,16.12,14.78,12.94,11.75,11.62,10.88,11.44,11.94,13.56,14.91,15.84,17.16,16.38,16.41,16.22,16.31,17.72,19.06,20.12,20.5,19.81,18.47,16.56,14.62,12.69,11.41,9.69,7.53,4.97,4.16,2.69,2.44,3.75,5.84,8.75,9.91,11.53,12.75,12.28,12.44,12.41,11.66,11.53,10.62,9.81,9.56,8.84,8.38,8.81,7.97,8.75,9.94,10.88,12.16,12.31,12.44,12.41,12.31,12.12,11.97,10.81,8.44,5.78,3.41,1.66,1.19,2.06,3.75,5.97,8.31,9.66,10.78,11.97,12.34,13.25,13.97,13.41,12.94,12.44,5.38,6.84,8.69,12.72,17.78,22.94,26.88,30.78,32.81,35.03,34.12,32.69,29.5,27.03,23.25,20.69,17.78,17.12,17.66,18.03,18.94,20.69,22.06,21.44:12.06,13.5,15.41,19.41,24.41,27.06,29.12,30.91,28.78,25.19,22.75,19.19,16.75,15.06,14.03,12.78,13.38,14.66,15.47,19.56,22.31,25.84,27.91,28.81,29.72,30.16,30.75,31.41,32.53,33.12,33.41,32.19,31.44,29.66,27.94,27.16,26.5,25.84,26.31,27.12,27.72,27.22,27.22,26.66,25.81,24.66,22.0,20.66,19.06,17.28,17.12,18.91,21.78,23.69,25.88,28.38,29.47,29.19,29.69,29.38,28.34,26.59,27.81,27.56,28.91,32.44,35.91,38.0,40.53,41.06,40.88,39.22,38.06,35.72,35.91,35.34,35.81,36.44,36.62,36.97,36.16,35.62,34.53,35.09,35.97,36.19,36.56,38.53,38.84,39.0,39.06,39.0,37.88,36.28,35.0,33.25,33.5,33.28,34.16,34.12,34.34,34.19,31.88,30.69,29.88,29.66,29.84,29.88,30.0,29.25,28.91,27.25,28.44,27.16,27.0,25.56,22.34,19.56,16.53,13.91,11.81,11.84,12.62,14.94,16.25,19.16,19.44,21.5,22.31,22.0,22.31,22.72,23.16,23.44,23.34,25.19,26.22,26.09,25.94,24.16,22.06,18.91,15.84,13.03,11.0,10.66,11.72,13.22,15.94,18.91,20.06,21.81,22.0,22.38,21.66,21.0,20.16,20.75,21.31,22.25,24.25,25.94,26.66,27.47,27.53,27.31,25.69,25.53,24.62,24.31,25.44,26.53,26.94,26.94,26.69,26.56,26.09,28.16,28.75,29.22,29.91,28.97,28.31,28.09,28.19,27.97,27.75,26.47,25.41,24.12,21.53,20.5,18.94,19.5,19.44,19.34,19.91,19.47,18.09,16.59,15.03,13.81,13.81,13.41,13.88,16.0,17.41,20.56,25.38,30.53,36.44,40.75,45.0,46.34,44.5,40.94,37.38,33.28,29.16,27.19,26.69,25.53,25.0,25.66,25.53,25.44,24.59,24.66,24.56,22.12,23.0,22.78,22.88,25.28,26.53,28.12,28.38,29.03,27.5,26.03,24.44,22.81,23.09,22.56,23.22,24.16,25.28,25.16,24.56,25.28,24.19,23.69,24.16,24.03,24.5,26.38,26.88,28.53,29.41,30.16,30.88,30.09,29.94,28.72,28.0,27.28,26.81,27.19,28.38,29.41,31.44,32.19,31.91,30.84,29.97,27.28,27.31,27.75,27.44,27.94,27.25,28.59,28.56,28.16,27.47,26.91,26.19,24.69,24.09,24.38,24.66,24.31,25.69,26.5,28.09,29.66,30.66,29.97,28.25,26.34,24.0,21.75,20.81,21.06,21.56,22.66,25.16,27.81,31.22,33.94,36.0,37.66,37.94,37.0,36.03,34.19,32.03,30.56,28.0,25.81,24.31,24.25,23.38,23.69,23.69,24.47,24.91,24.31,25.09,26.03,27.38,29.31,30.91,31.78,33.47,34.25,33.44,34.19,33.53,32.44,31.22,29.66,27.38,26.22,25.5,24.56,23.34,23.53,23.03,22.06,21.5,20.81,20.41,20.59,21.28,22.0,23.16,24.06,25.56,24.41,25.06,24.03,23.06,23.34,23.22,24.66,25.06,27.69,28.56,30.0,30.94,31.84,31.91,33.12,32.38,32.53,32.25,31.0,30.47,30.0,29.19,28.88,27.69,28.91,29.16,30.59,34.12,37.25,40.19,41.53,43.81,42.34,42.44,40.31,40.06,37.44,36.12,34.16,33.62,31.25,29.31,28.56,27.56,26.81,26.31,27.25,27.06,27.53,27.81,28.72,27.44,28.22,27.47,27.62,28.72,29.41,29.81,30.31,30.19,30.91,32.03,32.03,33.16,31.97,32.0,30.56,30.19,28.25,26.88,24.66,22.44,21.5,21.47,21.5,22.34,23.03,24.16,24.78,24.91,25.94,27.91,29.41,30.94,32.62,35.59,36.5,36.38,34.53,31.88,29.47,26.12,25.78,26.84,28.28,30.53,33.81,35.62,36.75,37.53,36.56,34.81,32.75,30.69,29.0,27.19,27.06,27.0,26.53,27.88,27.91,27.94,28.59,28.5,29.41,30.22,30.44,30.94,30.5,28.41,26.5,25.0,22.03,20.75,20.06,20.38,21.56,23.56,24.66,25.53,26.81,26.41,25.59,24.91,23.34,21.41,20.12,19.16,18.75,18.03,18.81,18.16,19.0,18.25,19.03,19.47,20.25,22.56,24.94,27.34,29.44,31.78,33.09,33.78,33.31,31.88,30.12,28.31,26.34,24.78,23.44,21.62,20.5,20.22,20.59,21.94,23.97,25.16,25.34,25.03,24.06,22.19,21.09,19.56,18.56,18.25,18.5,18.34,19.31,20.09,20.28,20.31,20.06,21.0,21.03,21.25,22.47,24.19,24.69,25.66,26.34,25.56,23.97,21.59,19.41,17.81,17.31,18.06,19.84,21.59,23.56,24.06,23.03,21.84,18.81,16.28,13.81,10.91,9.75,9.16,9.03,10.16,11.66,14.75,16.47,19.28,20.81,20.94,22.03,21.56,22.03,22.06,22.34,23.47,23.69,22.22,21.0,20.62,19.44,19.91,21.31,23.97,25.69,27.66,29.06,29.69,29.72,30.28,28.62,28.25,27.34,26.19,24.59,23.5,21.41,20.81,19.38,18.84,19.16,19.41,21.19,22.62,24.16,26.03,26.94,27.38,26.56,25.28,23.69,21.81,20.5,17.78,18.19,16.66,18.28,18.19,19.28,20.44,20.38,19.97,19.53,18.91,18.03,17.19,16.5,15.78,14.91,14.75,14.56,14.03,15.19,15.25,14.78,14.56,13.03,12.81,11.0,9.66,9.31,8.78,8.78,9.31,10.75,12.03,11.91,12.38,12.66,12.66,12.69,13.16,13.31,12.59,11.81,10.72,8.81,8.41,8.03,8.78,9.81,11.62,13.06,15.38,16.16,16.53,17.19,17.16,18.19,19.09,20.72,23.25,24.06,25.31,24.66,24.38,23.5,22.72,23.41,24.12,25.88,27.56,29.5,30.19,30.22,29.34,27.56,25.53,24.34,23.03,22.03,22.41,21.94,21.41,22.62,20.94,19.84,18.69,16.34,14.62,12.0,10.03,8.72,7.41,7.66,6.84,7.47,7.31,7.94,7.62,7.16,6.78,6.91,6.31,6.41,7.44,8.84,11.12,14.03,17.44,20.84,22.78,23.91,22.94,22.5,21.03,19.97,18.88,18.06,16.22,14.5,11.12,8.53,4.81,3.38,3.0,3.97,5.69,10.22,13.41,17.0,20.22,23.03,25.94,27.25,29.69,31.31,33.97,34.91,35.81,36.62,36.69,36.28,36.09,35.91,35.16,34.25,32.0,29.34,25.97,22.72,20.28,18.0,18.47,18.66,19.53,21.88,22.84,24.34,25.03,25.28,26.06,26.09,25.56,26.19,25.72,24.25,22.72,21.06,18.31,16.12,14.78,12.94,11.75,11.62,10.88,11.44,11.94,13.56,14.91,15.84,17.16,16.38,16.41,16.22,16.31,17.72,19.06,20.12,20.5,19.81,18.47,16.56,14.62,12.69,11.41,9.69,7.53,4.97,4.16,2.69,2.44,3.75,5.84,8.75,9.91,11.53,12.75,12.28,12.44,12.41,11.66,11.53,10.62,9.81,9.56,8.84,8.38,8.81,7.97,8.75,9.94,10.88,12.16,12.31,12.44,12.41,12.31,12.12,11.97,10.81,8.44,5.78,3.41,1.66,1.19,2.06,3.75,5.97,8.31,9.66,10.78,11.97,12.34,13.25,13.97,13.41,12.94,12.44,5.38,6.84,8.69,12.72,17.78,22.94,26.88,30.78,32.81,35.03,34.12,32.69,29.5,27.03,23.25,20.69,17.78,17.12,17.66,18.03,18.94,20.69,22.06,21.44,21.12,19.66,17.75,16.03,15.56,16.5:negativity
44.34,44.84,47.19,49.16,51.22,51.5,51.12,50.47,48.41,49.94,49.19,49.62,50.03,49.06,47.38,45.44,44.81,44.06,44.0,44.53,45.69,48.03,48.88,52.09,51.91,53.44,52.44,52.19,50.66,50.72,52.81,54.34,57.81,58.91,59.72,59.16,58.0,55.69,54.59,53.41,53.22,53.22,54.31,54.53,53.59,53.28,50.75,49.28,47.22,49.19,49.81,51.88,55.69,58.75,61.22,62.5,62.78,64.06,63.19,64.72,67.28,69.75,70.09,71.84,71.0,66.91,64.34,59.56,56.19,53.25,52.59,50.94,52.91,51.5,52.0,52.03,52.81,53.44,55.12,57.69,60.53,61.91,65.41,67.38,67.78,69.56,66.69,67.56,66.59,65.38,64.75,65.38,63.69,62.41,58.53,56.56,55.41,54.97,54.44,55.78,57.0,56.16,54.94,55.5,53.25,49.72,46.69,44.16,40.91,39.84,40.41,41.0,42.72,44.22,44.81,45.19,44.66,45.56,45.62,45.19,45.69,44.66,44.59,44.09,43.34,45.53,46.81,48.12,49.94,50.72,51.0,50.59,51.0,50.72,50.62,50.66,50.38,51.25,51.31,51.47,51.31,51.25,51.56,50.31,49.75,49.31,48.25,47.12,47.12,46.53,47.69,47.25,46.41,46.19,46.25,44.84,44.44,45.25,45.19,44.19,45.5,45.47,46.59,46.06,46.34,45.12,45.19,44.56,45.81,46.62,47.75,48.91,48.62,50.41,50.62,51.94,51.19,50.34,49.0,45.91,45.22,44.22,44.56,45.25,45.66,44.81,46.28,44.62,45.88,45.72,45.66,45.19,45.81,44.75,45.81,47.25,49.06,51.66,54.22,55.94,55.84,56.22,56.34,55.5,55.28,53.38,53.09,52.12,50.09,48.94,48.69,51.66,52.19,54.81,59.09,60.5,60.94,62.5,63.66,63.31,64.91,64.12,63.28,62.16,59.22,57.19,55.0,55.19,53.69,54.81,54.88,55.97,55.69,55.88,56.56,57.31,58.0,60.16,60.81,62.31,64.25,64.97,66.06,65.66,65.31,63.47,61.69,60.12,59.5,57.41,57.44,55.12,54.72,53.22,51.91,52.0,51.47,49.0,49.44,49.44,47.84,48.97,49.94,50.56,52.84,55.31,56.72,59.06,61.06,61.44,61.69,61.91,58.88,57.69,53.53,51.66,50.59,50.41,50.19,51.09,50.44,54.25,53.12,55.69,59.31,60.56,65.19,67.44,69.41,71.22,72.84,72.62,72.66,73.06,70.94,68.09,64.88,60.12,55.88,52.38,50.5,48.69,48.5,48.84,47.03,46.94,48.31,48.31,49.72,51.47,51.44,52.28,51.5,52.56,52.53,53.41,54.84,53.84,53.28,51.47,48.69,46.56,45.72,44.81,45.41,46.09,46.12,45.47,45.47,43.69,44.16,43.56,46.06,45.5,44.78,45.78,46.38,47.69,49.88,53.53,56.0,57.78,59.44,60.91,59.09,59.75,60.41,58.0,59.41,58.34,58.19,57.12,55.84,53.75,52.75,52.12,50.0,50.34,51.66,51.53,53.66,55.62,56.78,57.66,58.38,58.06,57.25,56.19,54.75,52.25,52.31,51.44,52.0,52.12,52.06,51.06,50.78,49.47,50.09,51.59,53.28,54.25,57.0,56.69,57.16,58.34,58.41,57.66,58.09,58.12,56.44,56.88,55.62,56.28,56.03,54.28,54.53,52.38,51.84,48.91,50.38,49.25,49.34,50.19,51.06,50.5,51.25,50.31,49.03,50.06,48.94,48.19,49.09,46.91,48.16,45.78,46.75,46.34,46.28,44.53,45.34,45.62,43.81,46.41,46.06,46.44,46.59,46.25,45.94,46.06,45.12,46.81,47.0,47.69,48.69,50.59,51.41,50.94,52.62,52.19,52.47,51.28,50.91,50.75,47.25,47.91,46.5,45.94,48.06,49.38,51.0,53.09,55.22,56.25,57.44,57.19,56.12,54.0,53.25,52.41,51.28,52.12,50.84,50.97,49.44,49.0,47.44,47.69,49.38,49.12,50.19,52.0,51.91,51.22,51.34,49.59,48.25,46.31,43.94,40.78,40.0,38.72,38.06,40.03,41.31,43.56,44.09,46.5,45.78,45.75,42.88,41.94,37.53,36.56,34.66,35.62,35.81,37.06,39.81,40.69,41.25,43.47,42.25,41.81,41.56,41.16,41.25,41.53,42.5,42.88,43.25,46.25,46.38,48.44,47.41,47.84,45.75,42.09,40.56,39.62,38.94,41.56,41.5,44.12,41.41,41.19,39.12,38.06,38.22,38.62,38.62,38.81,38.5,39.19,39.19,41.53,41.38,42.78,43.12,42.91,43.19,44.84,45.12,45.38,46.97,46.84,48.75,50.25,48.97,48.06,45.59,43.12,40.84,39.56,38.44,39.25,39.16,40.19,41.31,43.41,46.12,49.16,51.0,52.69,53.22,50.22,49.62,48.12,47.25,48.25,50.38,51.34,52.38,53.69,54.34,53.25,52.03,52.25,50.72,49.56,49.72,49.06,47.66,46.12,43.09,40.94,38.5,37.5,35.41,35.69,37.16,38.06,39.66,41.62,41.38,43.06,41.28,40.81,39.91,38.97,36.84,37.34,35.19,35.38,35.41,35.53,37.84,37.75,38.5,37.0,39.91,38.53,40.09,41.06,42.94,41.5,40.5,39.69,37.22,37.12,36.31,35.72,34.25,34.41,33.69,32.31,32.94,32.66,32.44,32.31,31.81,31.94,31.16,29.16,31.44,30.84,32.69,34.75,37.53,39.59,43.34,44.84,45.16,45.16,43.0,41.06,39.38,37.75,36.72,35.56,36.84,36.16,36.25,36.34,35.19,35.12,34.5,32.56,33.91,33.38,34.16,36.84,39.41,39.16,40.88,40.5,38.09,35.72,32.69,31.31,30.28,29.66,30.03,31.34,31.94,32.69,33.75,33.5,35.34,36.06,38.94,41.69,45.06,49.12,51.56,52.59,53.69,52.44,51.53,48.84,47.06,46.12,44.0,42.56,42.66,41.41,42.31,40.28,40.5,38.97,36.22,35.12,34.06,33.88,33.41,35.31,35.72,37.53,38.75,42.75,45.94,48.12,49.81,50.66,50.53,49.75,49.66,48.66,49.09,48.66,46.47,44.62,42.69,41.03,39.69,37.34,38.06,36.78,35.12,34.78,35.12,36.5,40.19,41.97,46.25,47.62,48.03,46.78,46.56,43.84,42.47,40.53,38.06,36.03,35.09,34.22,32.88,34.25,35.81,37.44,40.22,41.59,42.66,42.38,40.66,38.09,36.44,35.56,34.69,35.0,34.06,33.38,31.31,29.72,27.97,27.44,28.44,28.97,28.78,29.19,28.62,28.78,27.31,26.5,25.59,24.56,22.81,21.81,23.19,22.81,23.59,26.22,27.0,27.56,28.19,26.69,25.69,25.12,23.69,25.75,26.34,27.16,28.41,28.5,28.56,28.31,29.06,28.97,28.31,28.88,28.41,29.56,28.31,29.91,30.22,31.22,32.91,35.62,38.31,39.0,39.94,38.06,36.16,32.53,30.47,28.81,27.41,27.41,27.66,28.78,28.38,28.53,28.25,27.62,27.94,26.06,27.44,27.81,27.91,28.22,27.66,27.69,25.53,24.56,23.81,22.22,22.56,21.25,19.75,18.72,18.09,16.41,14.59,14.03,12.25,11.69,10.75,10.28,12.81,14.62,18.28,20.41,23.53,26.41,26.94,28.12,27.94,28.03,27.62,26.31,25.91,24.31,22.94,19.88,18.94,16.5,14.97,12.66,9.72,5.97,1.16,-2.56,-6.22,-7.59,-8.0,-7.81,-5.88,-3.94,-3.31,-0.97,-0.19,0.41,-1.81,-2.03,-3.16,-4.84,-5.28,-4.91,-4.66,-4.91,-3.97,-4.94,-3.81,-3.38,-3.88,-3.62:51.12,50.47,48.41,49.94,49.19,49.62,50.03,49.06,47.38,45.44,44.81,44.06,44.0,44.53,45.69,48.03,48.88,52.09,51.91,53.44,52.44,52.19,50.66,50.72,52.81,54.34,57.81,58.91,59.72,59.16,58.0,55.69,54.59,53.41,53.22,53.22,54.31,54.53,53.59,53.28,50.75,49.28,47.22,49.19,49.81,51.88,55.69,58.75,61.22,62.5,62.78,64.06,63.19,64.72,67.28,69.75,70.09,71.84,71.0,66.91,64.34,59.56,56.19,53.25,52.59,50.94,52.91,51.5,52.0,52.03,52.81,53.44,55.12,57.69,60.53,61.91,65.41,67.38,67.78,69.56,66.69,67.56,66.59,65.38,64.75,65.38,63.69,62.41,58.53,56.56,55.41,54.97,54.44,55.78,57.0,56.16,54.94,55.5,53.25,49.72,46.69,44.16,40.91,39.84,40.41,41.0,42.72,44.22,44.81,45.19,44.66,45.56,45.62,45.19,45.69,44.66,44.59,44.09,43.34,45.53,46.81,48.12,49.94,50.72,51.0,50.59,51.0,50.72,50.62,50.66,50.38,51.25,51.31,51.47,51.31,51.25,51.56,50.31,49.75,49.31,48.25,47.12,47.12,46.53,47.69,47.25,46.41,46.19,46.25,44.84,44.44,45.25,45.19,44.19,45.5,45.47,46.59,46.06,46.34,45.12,45.19,44.56,45.81,46.62,47.75,48.91,48.62,50.41,50.62,51.94,51.19,50.34,49.0,45.91,45.22,44.22,44.56,45.25,45.66,44.81,46.28,44.62,45.88,45.72,45.66,45.19,45.81,44.75,45.81,47.25,49.06,51.66,54.22,55.94,55.84,56.22,56.34,55.5,55.28,53.38,53.09,52.12,50.09,48.94,48.69,51.66,52.19,54.81,59.09,60.5,60.94,62.5,63.66,63.31,64.91,64.12,63.28,62.16,59.22,57.19,55.0,55.19,53.69,54.81,54.88,55.97,55.69,55.88,56.56,57.31,58.0,60.16,60.81,62.31,64.25,64.97,66.06,65.66,65.31,63.47,61.69,60.12,59.5,57.41,57.44,55.12,54.72,53.22,51.91,52.0,51.47,49.0,49.44,49.44,47.84,48.97,49.94,50.56,52.84,55.31,56.72,59.06,61.06,61.44,61.69,61.91,58.88,57.69,53.53,51.66,50.59,50.41,50.19,51.09,50.44,54.25,53.12,55.69,59.31,60.56,65.19,67.44,69.41,71.22,72.84,72.62,72.66,73.06,70.94,68.09,64.88,60.12,55.88,52.38,50.5,48.69,48.5,48.84,47.03,46.94,48.31,48.31,49.72,51.47,51.44,52.28,51.5,52.56,52.53,53.41,54.84,53.84,53.28,51.47,48.69,46.56,45.72,44.81,45.41,46.09,46.12,45.47,45.47,43.69,44.16,43.56,46.06,45.5,44.78,45.78,46.38,47.69,49.88,53.53,56.0,57.78,59.44,60.91,59.09,59.75,60.41,58.0,59.41,58.34,58.19,57.12,55.84,53.75,52.75,52.12,50.0,50.34,51.66,51.53,53.66,55.62,56.78,57.66,58.38,58.06,57.25,56.19,54.75,52.25,52.31,51.44,52.0,52.12,52.06,51.06,50.78,49.47,50.09,51.59,53.28,54.25,57.0,56.69,57.16,58.34,58.41,57.66,58.09,58.12,56.44,56.88,55.62,56.28,56.03,54.28,54.53,52.38,51.84,48.91,50.38,49.25,49.34,50.19,51.06,50.5,51.25,50.31,49.03,50.06,48.94,48.19,49.09,46.91,48.16,45.78,46.75,46.34,46.28,44.53,45.34,45.62,43.81,46.41,46.06,46.44,46.59,46.25,45.94,46.06,45.12,46.81,47.0,47.69,48.69,50.59,51.41,50.94,52.62,52.19,52.47,51.28,50.91,50.75,47.25,47.91,46.5,45.94,48.06,49.38,51.0,53.09,55.22,56.25,57.44,57.19,56.12,54.0,53.25,52.41,51.28,52.12,50.84,50.97,49.44,49.0,47.44,47.69,49.38,49.12,50.19,52.0,51.91,51.22,51.34,49.59,48.25,46.31,43.94,40.78,40.0,38.72,38.06,40.03,41.31,43.56,44.09,46.5,45.78,45.75,42.88,41.94,37.53,36.56,34.66,35.62,35.81,37.06,39.81,40.69,41.25,43.47,42.25,41.81,41.56,41.16,41.25,41.53,42.5,42.88,43.25,46.25,46.38,48.44,47.41,47.84,45.75,42.09,40.56,39.62,38.94,41.56,41.5,44.12,41.41,41.19,39.12,38.06,38.22,38.62,38.62,38.81,38.5,39.19,39.19,41.53,41.38,42.78,43.12,42.91,43.19,44.84,45.12,45.38,46.97,46.84,48.75,50.25,48.97,48.06,45.59,43.12,40.84,39.56,38.44,39.25,39.16,40.19,41.31,43.41,46.12,49.16,51.0,52.69,53.22,50.22,49.62,48.12,47.25,48.25,50.38,51.34,52.38,53.69,54.34,53.25,52.03,52.25,50.72,49.56,49.72,49.06,47.66,46.12,43.09,40.94,38.5,37.5,35.41,35.69,37.16,38.06,39.66,41.62,41.38,43.06,41.28,40.81,39.91,38.97,36.84,37.34,35.19,35.38,35.41,35.53,37.84,37.75,38.5,37.0,39.91,38.53,40.09,41.06,42.94,41.5,40.5,39.69,37.22,37.12,36.31,35.72,34.25,34.41,33.69,32.31,32.94,32.66,32.44,32.31,31.81,31.94,31.16,29.16,31.44,30.84,32.69,34.75,37.53,39.59,43.34,44.84,45.16,45.16,43.0,41.06,39.38,37.75,36.72,35.56,36.84,36.16,36.25,36.34,35.19,35.12,34.5,32.56,33.91,33.38,34.16,36.84,39.41,39.16,40.88,40.5,38.09,35.72,32.69,31.31,30.28,29.66,30.03,31.34,31.94,32.69,33.75,33.5,35.34,36.06,38.94,41.69,45.06,49.12,51.56,52.59,53.69,52.44,51.53,48.84,47.06,46.12,44.0,42.56,42.66,41.41,42.31,40.28,40.5,38.97,36.22,35.12,34.06,33.88,33.41,35.31,35.72,37.53,38.75,42.75,45.94,48.12,49.81,50.66,50.53,49.75,49.66,48.66,49.09,48.66,46.47,44.62,42.69,41.03,39.69,37.34,38.06,36.78,35.12,34.78,35.12,36.5,40.19,41.97,46.25,47.62,48.03,46.78,46.56,43.84,42.47,40.53,38.06,36.03,35.09,34.22,32.88,34.25,35.81,37.44,40.22,41.59,42.66,42.38,40.66,38.09,36.44,35.56,34.69,35.0,34.06,33.38,31.31,29.72,27.97,27.44,28.44,28.97,28.78,29.19,28.62,28.78,27.31,26.5,25.59,24.56,22.81,21.81,23.19,22.81,23.59,26.22,27.0,27.56,28.19,26.69,25.69,25.12,23.69,25.75,26.34,27.16,28.41,28.5,28.56,28.31,29.06,28.97,28.31,28.88,28.41,29.56,28.31,29.91,30.22,31.22,32.91,35.62,38.31,39.0,39.94,38.06,36.16,32.53,30.47,28.81,27.41,27.41,27.66,28.78,28.38,28.53,28.25,27.62,27.94,26.06,27.44,27.81,27.91,28.22,27.66,27.69,25.53,24.56,23.81,22.22,22.56,21.25,19.75,18.72,18.09,16.41,14.59,14.03,12.25,11.69,10.75,10.28,12.81,14.62,18.28,20.41,23.53,26.41,26.94,28.12,27.94,28.03,27.62,26.31,25.91,24.31,22.94,19.88,18.94,16.5,14.97,12.66,9.72,5.97,1.16,-2.56,-6.22,-7.59,-8.0,-7.81,-5.88,-3.94,-3.31,-0.97,-0.19,0.41,-1.81,-2.03,-3.16,-4.84,-5.28,-4.91,-4.66,-4.91,-3.97,-4.94,-3.81,-3.38,-3.88,-3.62,56.66,55.84,58.16,58.66,59.62,60.19:50.03,49.06,47.38,45.44,44.81,44.06,44.0,44.53,45.69,48.03,48.88,52.09,51.91,53.44,52.44,52.19,50.66,50.72,52.81,54.34,57.81,58.91,59.72,59.16,58.0,55.69,54.59,53.41,53.22,53.22,54.31,54.53,53.59,53.28,50.75,49.28,47.22,49.19,49.81,51.88,55.69,58.75,61.22,62.5,62.78,64.06,63.19,64.72,67.28,69.75,70.09,71.84,71.0,66.91,64.34,59.56,56.19,53.25,52.59,50.94,52.91,51.5,52.0,52.03,52.81,53.44,55.12,57.69,60.53,61.91,65.41,67.38,67.78,69.56,66.69,67.56,66.59,65.38,64.75,65.38,63.69,62.41,58.53,56.56,55.41,54.97,54.44,55.78,57.0,56.16,54.94,55.5,53.25,49.72,46.69,44.16,40.91,39.84,40.41,41.0,42.72,44.22,44.81,45.19,44.66,45.56,45.62,45.19,45.69,44.66,44.59,44.09,43.34,45.53,46.81,48.12,49.94,50.72,51.0,50.59,51.0,50.72,50.62,50.66,50.38,51.25,51.31,51.47,51.31,51.25,51.56,50.31,49.75,49.31,48.25,47.12,47.12,46.53,47.69,47.25,46.41,46.19,46.25,44.84,44.44,45.25,45.19,44.19,45.5,45.47,46.59,46.06,46.34,45.12,45.19,44.56,45.81,46.62,47.75,48.91,48.62,50.41,50.62,51.94,51.19,50.34,49.0,45.91,45.22,44.22,44.56,45.25,45.66,44.81,46.28,44.62,45.88,45.72,45.66,45.19,45.81,44.75,45.81,47.25,49.06,51.66,54.22,55.94,55.84,56.22,56.34,55.5,55.28,53.38,53.09,52.12,50.09,48.94,48.69,51.66,52.19,54.81,59.09,60.5,60.94,62.5,63.66,63.31,64.91,64.12,63.28,62.16,59.22,57.19,55.0,55.19,53.69,54.81,54.88,55.97,55.69,55.88,56.56,57.31,58.0,60.16,60.81,62.31,64.25,64.97,66.06,65.66,65.31,63.47,61.69,60.12,59.5,57.41,57.44,55.12,54.72,53.22,51.91,52.0,51.47,49.0,49.44,49.44,47.84,48.97,49.94,50.56,52.84,55.31,56.72,59.06,61.06,61.44,61.69,61.91,58.88,57.69,53.53,51.66,50.59,50.41,50.19,51.09,50.44,54.25,53.12,55.69,59.31,60.56,65.19,67.44,69.41,71.22,72.84,72.62,72.66,73.06,70.94,68.09,64.88,60.12,55.88,52.38,50.5,48.69,48.5,48.84,47.03,46.94,48.31,48.31,49.72,51.47,51.44,52.28,51.5,52.56,52.53,53.41,54.84,53.84,53.28,51.47,48.69,46.56,45.72,44.81,45.41,46.09,46.12,45.47,45.47,43.69,44.16,43.56,46.06,45.5,44.78,45.78,46.38,47.69,49.88,53.53,56.0,57.78,59.44,60.91,59.09,59.75,60.41,58.0,59.41,58.34,58.19,57.12,55.84,53.75,52.75,52.12,50.0,50.34,51.66,51.53,53.66,55.62,56.78,57.66,58.38,58.06,57.25,56.19,54.75,52.25,52.31,51.44,52.0,52.12,52.06,51.06,50.78,49.47,50.09,51.59,53.28,54.25,57.0,56.69,57.16,58.34,58.41,57.66,58.09,58.12,56.44,56.88,55.62,56.28,56.03,54.28,54.53,52.38,51.84,48.91,50.38,49.25,49.34,50.19,51.06,50.5,51.25,50.31,49.03,50.06,48.94,48.19,49.09,46.91,48.16,45.78,46.75,46.34,46.28,44.53,45.34,45.62,43.81,46.41,46.06,46.44,46.59,46.25,45.94,46.06,45.12,46.81,47.0,47.69,48.69,50.59,51.41,50.94,52.62,52.19,52.47,51.28,50.91,50.75,47.25,47.91,46.5,45.94,48.06,49.38,51.0,53.09,55.22,56.25,57.44,57.19,56.12,54.0,53.25,52.41,51.28,52.12,50.84,50.97,49.44,49.0,47.44,47.69,49.38,49.12,50.19,52.0,51.91,51.22,51.34,49.59,48.25,46.31,43.94,40.78,40.0,38.72,38.06,40.03,41.31,43.56,44.09,46.5,45.78,45.75,42.88,41.94,37.53,36.56,34.66,35.62,35.81,37.06,39.81,40.69,41.25,43.47,42.25,41.81,41.56,41.16,41.25,41.53,42.5,42.88,43.25,46.25,46.38,48.44,47.41,47.84,45.75,42.09,40.56,39.62,38.94,41.56,41.5,44.12,41.41,41.19,39.12,38.06,38.22,38.62,38.62,38.81,38.5,39.19,39.19,41.53,41.38,42.78,43.12,42.91,43.19,44.84,45.12,45.38,46.97,46.84,48.75,50.25,48.97,48.06,45.59,43.12,40.84,39.56,38.44,39.25,39.16,40.19,41.31,43.41,46.12,49.16,51.0,52.69,53.22,50.22,49.62,48.12,47.25,48.25,50.38,51.34,52.38,53.69,54.34,53.25,52.03,52.25,50.72,49.56,49.72,49.06,47.66,46.12,43.09,40.94,38.5,37.5,35.41,35.69,37.16,38.06,39.66,41.62,41.38,43.06,41.28,40.81,39.91,38.97,36.84,37.34,35.19,35.38,35.41,35.53,37.84,37.75,38.5,37.0,39.91,38.53,40.09,41.06,42.94,41.5,40.5,39.69,37.22,37.12,36.31,35.72,34.25,34.41,33.69,32.31,32.94,32.66,32.44,32.31,31.81,31.94,31.16,29.16,31.44,30.84,32.69,34.75,37.53,39.59,43.34,44.84,45.16,45.16,43.0,41.06,39.38,37.75,36.72,35.56,36.84,36.16,36.25,36.34,35.19,35.12,34.5,32.56,33.91,33.38,34.16,36.84,39.41,39.16,40.88,40.5,38.09,35.72,32.69,31.31,30.28,29.66,30.03,31.34,31.94,32.69,33.75,33.5,35.34,36.06,38.94,41.69,45.06,49.12,51.56,52.59,53.69,52.44,51.53,48.84,47.06,46.12,44.0,42.56,42.66,41.41,42.31,40.28,40.5,38.97,36.22,35.12,34.06,33.88,33.41,35.31,35.72,37.53,38.75,42.75,45.94,48.12,49.81,50.66,50.53,49.75,49.66,48.66,49.09,48.66,46.47,44.62,42.69,41.03,39.69,37.34,38.06,36.78,35.12,34.78,35.12,36.5,40.19,41.97,46.25,47.62,48.03,46.78,46.56,43.84,42.47,40.53,38.06,36.03,35.09,34.22,32.88,34.25,35.81,37.44,40.22,41.59,42.66,42.38,40.66,38.09,36.44,35.56,34.69,35.0,34.06,33.38,31.31,29.72,27.97,27.44,28.44,28.97,28.78,29.19,28.62,28.78,27.31,26.5,25.59,24.56,22.81,21.81,23.19,22.81,23.59,26.22,27.0,27.56,28.19,26.69,25.69,25.12,23.69,25.75,26.34,27.16,28.41,28.5,28.56,28.31,29.06,28.97,28.31,28.88,28.41,29.56,28.31,29.91,30.22,31.22,32.91,35.62,38.31,39.0,39.94,38.06,36.16,32.53,30.47,28.81,27.41,27.41,27.66,28.78,28.38,28.53,28.25,27.62,27.94,26.06,27.44,27.81,27.91,28.22,27.66,27.69,25.53,24.56,23.81,22.22,22.56,21.25,19.75,18.72,18.09,16.41,14.59,14.03,12.25,11.69,10.75,10.28,12.81,14.62,18.28,20.41,23.53,26.41,26.94,28.12,27.94,28.03,27.62,26.31,25.91,24.31,22.94,19.88,18.94,16.5,14.97,12.66,9.72,5.97,1.16,-2.56,-6.22,-7.59,-8.0,-7.81,-5.88,-3.94,-3.31,-0.97,-0.19,0.41,-1.81,-2.03,-3.16,-4.84,-5.28,-4.91,-4.66,-4.91,-3.97,-4.94,-3.81,-3.38,-3.88,-3.62,56.66,55.84,58.16,58.66,59.62,60.19,61.28,61.81,60.75,63.19,62.41,64.25:44.0,44.53,45.69,48.03,48.88,52.09,51.91,53.44,52.44,52.19,50.66,50.72,52.81,54.34,57.81,58.91,59.72,59.16,58.0,55.69,54.59,53.41,53.22,53.22,54.31,54.53,53.59,53.28,50.75,49.28,47.22,49.19,49.81,51.88,55.69,58.75,61.22,62.5,62.78,64.06,63.19,64.72,67.28,69.75,70.09,71.84,71.0,66.91,64.34,59.56,56.19,53.25,52.59,50.94,52.91,51.5,52.0,52.03,52.81,53.44,55.12,57.69,60.53,61.91,65.41,67.38,67.78,69.56,66.69,67.56,66.59,65.38,64.75,65.38,63.69,62.41,58.53,56.56,55.41,54.97,54.44,55.78,57.0,56.16,54.94,55.5,53.25,49.72,46.69,44.16,40.91,39.84,40.41,41.0,42.72,44.22,44.81,45.19,44.66,45.56,45.62,45.19,45.69,44.66,44.59,44.09,43.34,45.53,46.81,48.12,49.94,50.72,51.0,50.59,51.0,50.72,50.62,50.66,50.38,51.25,51.31,51.47,51.31,51.25,51.56,50.31,49.75,49.31,48.25,47.12,47.12,46.53,47.69,47.25,46.41,46.19,46.25,44.84,44.44,45.25,45.19,44.19,45.5,45.47,46.59,46.06,46.34,45.12,45.19,44.56,45.81,46.62,47.75,48.91,48.62,50.41,50.62,51.94,51.19,50.34,49.0,45.91,45.22,44.22,44.56,45.25,45.66,44.81,46.28,44.62,45.88,45.72,45.66,45.19,45.81,44.75,45.81,47.25,49.06,51.66,54.22,55.94,55.84,56.22,56.34,55.5,55.28,53.38,53.09,52.12,50.09,48.94,48.69,51.66,52.19,54.81,59.09,60.5,60.94,62.5,63.66,63.31,64.91,64.12,63.28,62.16,59.22,57.19,55.0,55.19,53.69,54.81,54.88,55.97,55.69,55.88,56.56,57.31,58.0,60.16,60.81,62.31,64.25,64.97,66.06,65.66,65.31,63.47,61.69,60.12,59.5,57.41,57.44,55.12,54.72,53.22,51.91,52.0,51.47,49.0,49.44,49.44,47.84,48.97,49.94,50.56,52.84,55.31,56.72,59.06,61.06,61.44,61.69,61.91,58.88,57.69,53.53,51.66,50.59,50.41,50.19,51.09,50.44,54.25,53.12,55.69,59.31,60.56,65.19,67.44,69.41,71.22,72.84,72.62,72.66,73.06,70.94,68.09,64.88,60.12,55.88,52.38,50.5,48.69,48.5,48.84,47.03,46.94,48.31,48.31,49.72,51.47,51.44,52.28,51.5,52.56,52.53,53.41,54.84,53.84,53.28,51.47,48.69,46.56,45.72,44.81,45.41,46.09,46.12,45.47,45.47,43.69,44.16,43.56,46.06,45.5,44.78,45.78,46.38,47.69,49.88,53.53,56.0,57.78,59.44,60.91,59.09,59.75,60.41,58.0,59.41,58.34,58.19,57.12,55.84,53.75,52.75,52.12,50.0,50.34,51.66,51.53,53.66,55.62,56.78,57.66,58.38,58.06,57.25,56.19,54.75,52.25,52.31,51.44,52.0,52.12,52.06,51.06,50.78,49.47,50.09,51.59,53.28,54.25,57.0,56.69,57.16,58.34,58.41,57.66,58.09,58.12,56.44,56.88,55.62,56.28,56.03,54.28,54.53,52.38,51.84,48.91,50.38,49.25,49.34,50.19,51.06,50.5,51.25,50.31,49.03,50.06,48.94,48.19,49.09,46.91,48.16,45.78,46.75,46.34,46.28,44.53,45.34,45.62,43.81,46.41,46.06,46.44,46.59,46.25,45.94,46.06,45.12,46.81,47.0,47.69,48.69,50.59,51.41,50.94,52.62,52.19,52.47,51.28,50.91,50.75,47.25,47.91,46.5,45.94,48.06,49.38,51.0,53.09,55.22,56.25,57.44,57.19,56.12,54.0,53.25,52.41,51.28,52.12,50.84,50.97,49.44,49.0,47.44,47.69,49.38,49.12,50.19,52.0,51.91,51.22,51.34,49.59,48.25,46.31,43.94,40.78,40.0,38.72,38.06,40.03,41.31,43.56,44.09,46.5,45.78,45.75,42.88,41.94,37.53,36.56,34.66,35.62,35.81,37.06,39.81,40.69,41.25,43.47,42.25,41.81,41.56,41.16,41.25,41.53,42.5,42.88,43.25,46.25,46.38,48.44,47.41,47.84,45.75,42.09,40.56,39.62,38.94,41.56,41.5,44.12,41.41,41.19,39.12,38.06,38.22,38.62,38.62,38.81,38.5,39.19,39.19,41.53,41.38,42.78,43.12,42.91,43.19,44.84,45.12,45.38,46.97,46.84,48.75,50.25,48.97,48.06,45.59,43.12,40.84,39.56,38.44,39.25,39.16,40.19,41.31,43.41,46.12,49.16,51.0,52.69,53.22,50.22,49.62,48.12,47.25,48.25,50.38,51.34,52.38,53.69,54.34,53.25,52.03,52.25,50.72,49.56,49.72,49.06,47.66,46.12,43.09,40.94,38.5,37.5,35.41,35.69,37.16,38.06,39.66,41.62,41.38,43.06,41.28,40.81,39.91,38.97,36.84,37.34,35.19,35.38,35.41,35.53,37.84,37.75,38.5,37.0,39.91,38.53,40.09,41.06,42.94,41.5,40.5,39.69,37.22,37.12,36.31,35.72,34.25,34.41,33.69,32.31,32.94,32.66,32.44,32.31,31.81,31.94,31.16,29.16,31.44,30.84,32.69,34.75,37.53,39.59,43.34,44.84,45.16,45.16,43.0,41.06,39.38,37.75,36.72,35.56,36.84,36.16,36.25,36.34,35.19,35.12,34.5,32.56,33.91,33.38,34.16,36.84,39.41,39.16,40.88,40.5,38.09,35.72,32.69,31.31,30.28,29.66,30.03,31.34,31.94,32.69,33.75,33.5,35.34,36.06,38.94,41.69,45.06,49.12,51.56,52.59,53.69,52.44,51.53,48.84,47.06,46.12,44.0,42.56,42.66,41.41,42.31,40.28,40.5,38.97,36.22,35.12,34.06,33.88,33.41,35.31,35.72,37.53,38.75,42.75,45.94,48.12,49.81,50.66,50.53,49.75,49.66,48.66,49.09,48.66,46.47,44.62,42.69,41.03,39.69,37.34,38.06,36.78,35.12,34.78,35.12,36.5,40.19,41.97,46.25,47.62,48.03,46.78,46.56,43.84,42.47,40.53,38.06,36.03,35.09,34.22,32.88,34.25,35.81,37.44,40.22,41.59,42.66,42.38,40.66,38.09,36.44,35.56,34.69,35.0,34.06,33.38,31.31,29.72,27.97,27.44,28.44,28.97,28.78,29.19,28.62,28.78,27.31,26.5,25.59,24.56,22.81,21.81,23.19,22.81,23.59,26.22,27.0,27.56,28.19,26.69,25.69,25.12,23.69,25.75,26.34,27.16,28.41,28.5,28.56,28.31,29.06,28.97,28.31,28.88,28.41,29.56,28.31,29.91,30.22,31.22,32.91,35.62,38.31,39.0,39.94,38.06,36.16,32.53,30.47,28.81,27.41,27.41,27.66,28.78,28.38,28.53,28.25,27.62,27.94,26.06,27.44,27.81,27.91,28.22,27.66,27.69,25.53,24.56,23.81,22.22,22.56,21.25,19.75,18.72,18.09,16.41,14.59,14.03,12.25,11.69,10.75,10.28,12.81,14.62,18.28,20.41,23.53,26.41,26.94,28.12,27.94,28.03,27.62,26.31,25.91,24.31,22.94,19.88,18.94,16.5,14.97,12.66,9.72,5.97,1.16,-2.56,-6.22,-7.59,-8.0,-7.81,-5.88,-3.94,-3.31,-0.97,-0.19,0.41,-1.81,-2.03,-3.16,-4.84,-5.28,-4.91,-4.66,-4.91,-3.97,-4.94,-3.81,-3.38,-3.88,-3.62,56.66,55.84,58.16,58.66,59.62,60.19,61.28,61.81,60.75,63.19,62.41,64.25,64.19,64.03,62.47,60.72,60.0,57.72:51.91,53.44,52.44,52.19,50.66,50.72,52.81,54.34,57.81,58.91,59.72,59.16,58.0,55.69,54.59,53.41,53.22,53.22,54.31,54.53,53.59,53.28,50.75,49.28,47.22,49.19,49.81,51.88,55.69,58.75,61.22,62.5,62.78,64.06,63.19,64.72,67.28,69.75,70.09,71.84,71.0,66.91,64.34,59.56,56.19,53.25,52.59,50.94,52.91,51.5,52.0,52.03,52.81,53.44,55.12,57.69,60.53,61.91,65.41,67.38,67.78,69.56,66.69,67.56,66.59,65.38,64.75,65.38,63.69,62.41,58.53,56.56,55.41,54.97,54.44,55.78,57.0,56.16,54.94,55.5,53.25,49.72,46.69,44.16,40.91,39.84,40.41,41.0,42.72,44.22,44.81,45.19,44.66,45.56,45.62,45.19,45.69,44.66,44.59,44.09,43.34,45.53,46.81,48.12,49.94,50.72,51.0,50.59,51.0,50.72,50.62,50.66,50.38,51.25,51.31,51.47,51.31,51.25,51.56,50.31,49.75,49.31,48.25,47.12,47.12,46.53,47.69,47.25,46.41,46.19,46.25,44.84,44.44,45.25,45.19,44.19,45.5,45.47,46.59,46.06,46.34,45.12,45.19,44.56,45.81,46.62,47.75,48.91,48.62,50.41,50.62,51.94,51.19,50.34,49.0,45.91,45.22,44.22,44.56,45.25,45.66,44.81,46.28,44.62,45.88,45.72,45.66,45.19,45.81,44.75,45.81,47.25,49.06,51.66,54.22,55.94,55.84,56.22,56.34,55.5,55.28,53.38,53.09,52.12,50.09,48.94,48.69,51.66,52.19,54.81,59.09,60.5,60.94,62.5,63.66,63.31,64.91,64.12,63.28,62.16,59.22,57.19,55.0,55.19,53.69,54.81,54.88,55.97,55.69,55.88,56.56,57.31,58.0,60.16,60.81,62.31,64.25,64.97,66.06,65.66,65.31,63.47,61.69,60.12,59.5,57.41,57.44,55.12,54.72,53.22,51.91,52.0,51.47,49.0,49.44,49.44,47.84,48.97,49.94,50.56,52.84,55.31,56.72,59.06,61.06,61.44,61.69,61.91,58.88,57.69,53.53,51.66,50.59,50.41,50.19,51.09,50.44,54.25,53.12,55.69,59.31,60.56,65.19,67.44,69.41,71.22,72.84,72.62,72.66,73.06,70.94,68.09,64.88,60.12,55.88,52.38,50.5,48.69,48.5,48.84,47.03,46.94,48.31,48.31,49.72,51.47,51.44,52.28,51.5,52.56,52.53,53.41,54.84,53.84,53.28,51.47,48.69,46.56,45.72,44.81,45.41,46.09,46.12,45.47,45.47,43.69,44.16,43.56,46.06,45.5,44.78,45.78,46.38,47.69,49.88,53.53,56.0,57.78,59.44,60.91,59.09,59.75,60.41,58.0,59.41,58.34,58.19,57.12,55.84,53.75,52.75,52.12,50.0,50.34,51.66,51.53,53.66,55.62,56.78,57.66,58.38,58.06,57.25,56.19,54.75,52.25,52.31,51.44,52.0,52.12,52.06,51.06,50.78,49.47,50.09,51.59,53.28,54.25,57.0,56.69,57.16,58.34,58.41,57.66,58.09,58.12,56.44,56.88,55.62,56.28,56.03,54.28,54.53,52.38,51.84,48.91,50.38,49.25,49.34,50.19,51.06,50.5,51.25,50.31,49.03,50.06,48.94,48.19,49.09,46.91,48.16,45.78,46.75,46.34,46.28,44.53,45.34,45.62,43.81,46.41,46.06,46.44,46.59,46.25,45.94,46.06,45.12,46.81,47.0,47.69,48.69,50.59,51.41,50.94,52.62,52.19,52.47,51.28,50.91,50.75,47.25,47.91,46.5,45.94,48.06,49.38,51.0,53.09,55.22,56.25,57.44,57.19,56.12,54.0,53.25,52.41,51.28,52.12,50.84,50.97,49.44,49.0,47.44,47.69,49.38,49.12,50.19,52.0,51.91,51.22,51.34,49.59,48.25,46.31,43.94,40.78,40.0,38.72,38.06,40.03,41.31,43.56,44.09,46.5,45.78,45.75,42.88,41.94,37.53,36.56,34.66,35.62,35.81,37.06,39.81,40.69,41.25,43.47,42.25,41.81,41.56,41.16,41.25,41.53,42.5,42.88,43.25,46.25,46.38,48.44,47.41,47.84,45.75,42.09,40.56,39.62,38.94,41.56,41.5,44.12,41.41,41.19,39.12,38.06,38.22,38.62,38.62,38.81,38.5,39.19,39.19,41.53,41.38,42.78,43.12,42.91,43.19,44.84,45.12,45.38,46.97,46.84,48.75,50.25,48.97,48.06,45.59,43.12,40.84,39.56,38.44,39.25,39.16,40.19,41.31,43.41,46.12,49.16,51.0,52.69,53.22,50.22,49.62,48.12,47.25,48.25,50.38,51.34,52.38,53.69,54.34,53.25,52.03,52.25,50.72,49.56,49.72,49.06,47.66,46.12,43.09,40.94,38.5,37.5,35.41,35.69,37.16,38.06,39.66,41.62,41.38,43.06,41.28,40.81,39.91,38.97,36.84,37.34,35.19,35.38,35.41,35.53,37.84,37.75,38.5,37.0,39.91,38.53,40.09,41.06,42.94,41.5,40.5,39.69,37.22,37.12,36.31,35.72,34.25,34.41,33.69,32.31,32.94,32.66,32.44,32.31,31.81,31.94,31.16,29.16,31.44,30.84,32.69,34.75,37.53,39.59,43.34,44.84,45.16,45.16,43.0,41.06,39.38,37.75,36.72,35.56,36.84,36.16,36.25,36.34,35.19,35.12,34.5,32.56,33.91,33.38,34.16,36.84,39.41,39.16,40.88,40.5,38.09,35.72,32.69,31.31,30.28,29.66,30.03,31.34,31.94,32.69,33.75,33.5,35.34,36.06,38.94,41.69,45.06,49.12,51.56,52.59,53.69,52.44,51.53,48.84,47.06,46.12,44.0,42.56,42.66,41.41,42.31,40.28,40.5,38.97,36.22,35.12,34.06,33.88,33.41,35.31,35.72,37.53,38.75,42.75,45.94,48.12,49.81,50.66,50.53,49.75,49.66,48.66,49.09,48.66,46.47,44.62,42.69,41.03,39.69,37.34,38.06,36.78,35.12,34.78,35.12,36.5,40.19,41.97,46.25,47.62,48.03,46.78,46.56,43.84,42.47,40.53,38.06,36.03,35.09,34.22,32.88,34.25,35.81,37.44,40.22,41.59,42.66,42.38,40.66,38.09,36.44,35.56,34.69,35.0,34.06,33.38,31.31,29.72,27.97,27.44,28.44,28.97,28.78,29.19,28.62,28.78,27.31,26.5,25.59,24.56,22.81,21.81,23.19,22.81,23.59,26.22,27.0,27.56,28.19,26.69,25.69,25.12,23.69,25.75,26.34,27.16,28.41,28.5,28.56,28.31,29.06,28.97,28.31,28.88,28.41,29.56,28.31,29.91,30.22,31.22,32.91,35.62,38.31,39.0,39.94,38.06,36.16,32.53,30.47,28.81,27.41,27.41,27.66,28.78,28.38,28.53,28.25,27.62,27.94,26.06,27.44,27.81,27.91,28.22,27.66,27.69,25.53,24.56,23.81,22.22,22.56,21.25,19.75,18.72,18.09,16.41,14.59,14.03,12.25,11.69,10.75,10.28,12.81,14.62,18.28,20.41,23.53,26.41,26.94,28.12,27.94,28.03,27.62,26.31,25.91,24.31,22.94,19.88,18.94,16.5,14.97,12.66,9.72,5.97,1.16,-2.56,-6.22,-7.59,-8.0,-7.81,-5.88,-3.94,-3.31,-0.97,-0.19,0.41,-1.81,-2.03,-3.16,-4.84,-5.28,-4.91,-4.66,-4.91,-3.97,-4.94,-3.81,-3.38,-3.88,-3.62,56.66,55.84,58.16,58.66,59.62,60.19,61.28,61.81,60.75,63.19,62.41,64.25,64.19,64.03,62.47,60.72,60.0,57.72,57.94,58.19,59.44,60.31,61.06,62.28:52.81,54.34,57.81,58.91,59.72,59.16,58.0,55.69,54.59,53.41,53.22,53.22,54.31,54.53,53.59,53.28,50.75,49.28,47.22,49.19,49.81,51.88,55.69,58.75,61.22,62.5,62.78,64.06,63.19,64.72,67.28,69.75,70.09,71.84,71.0,66.91,64.34,59.56,56.19,53.25,52.59,50.94,52.91,51.5,52.0,52.03,52.81,53.44,55.12,57.69,60.53,61.91,65.41,67.38,67.78,69.56,66.69,67.56,66.59,65.38,64.75,65.38,63.69,62.41,58.53,56.56,55.41,54.97,54.44,55.78,57.0,56.16,54.94,55.5,53.25,49.72,46.69,44.16,40.91,39.84,40.41,41.0,42.72,44.22,44.81,45.19,44.66,45.56,45.62,45.19,45.69,44.66,44.59,44.09,43.34,45.53,46.81,48.12,49.94,50.72,51.0,50.59,51.0,50.72,50.62,50.66,50.38,51.25,51.31,51.47,51.31,51.25,51.56,50.31,49.75,49.31,48.25,47.12,47.12,46.53,47.69,47.25,46.41,46.19,46.25,44.84,44.44,45.25,45.19,44.19,45.5,45.47,46.59,46.06,46.34,45.12,45.19,44.56,45.81,46.62,47.75,48.91,48.62,50.41,50.62,51.94,51.19,50.34,49.0,45.91,45.22,44.22,44.56,45.25,45.66,44.81,46.28,44.62,45.88,45.72,45.66,45.19,45.81,44.75,45.81,47.25,49.06,51.66,54.22,55.94,55.84,56.22,56.34,55.5,55.28,53.38,53.09,52.12,50.09,48.94,48.69,51.66,52.19,54.81,59.09,60.5,60.94,62.5,63.66,63.31,64.91,64.12,63.28,62.16,59.22,57.19,55.0,55.19,53.69,54.81,54.88,55.97,55.69,55.88,56.56,57.31,58.0,60.16,60.81,62.31,64.25,64.97,66.06,65.66,65.31,63.47,61.69,60.12,59.5,57.41,57.44,55.12,54.72,53.22,51.91,52.0,51.47,49.0,49.44,49.44,47.84,48.97,49.94,50.56,52.84,55.31,56.72,59.06,61.06,61.44,61.69,61.91,58.88,57.69,53.53,51.66,50.59,50.41,50.19,51.09,50.44,54.25,53.12,55.69,59.31,60.56,65.19,67.44,69.41,71.22,72.84,72.62,72.66,73.06,70.94,68.09,64.88,60.12,55.88,52.38,50.5,48.69,48.5,48.84,47.03,46.94,48.31,48.31,49.72,51.47,51.44,52.28,51.5,52.56,52.53,53.41,54.84,53.84,53.28,51.47,48.69,46.56,45.72,44.81,45.41,46.09,46.12,45.47,45.47,43.69,44.16,43.56,46.06,45.5,44.78,45.78,46.38,47.69,49.88,53.53,56.0,57.78,59.44,60.91,59.09,59.75,60.41,58.0,59.41,58.34,58.19,57.12,55.84,53.75,52.75,52.12,50.0,50.34,51.66,51.53,53.66,55.62,56.78,57.66,58.38,58.06,57.25,56.19,54.75,52.25,52.31,51.44,52.0,52.12,52.06,51.06,50.78,49.47,50.09,51.59,53.28,54.25,57.0,56.69,57.16,58.34,58.41,57.66,58.09,58.12,56.44,56.88,55.62,56.28,56.03,54.28,54.53,52.38,51.84,48.91,50.38,49.25,49.34,50.19,51.06,50.5,51.25,50.31,49.03,50.06,48.94,48.19,49.09,46.91,48.16,45.78,46.75,46.34,46.28,44.53,45.34,45.62,43.81,46.41,46.06,46.44,46.59,46.25,45.94,46.06,45.12,46.81,47.0,47.69,48.69,50.59,51.41,50.94,52.62,52.19,52.47,51.28,50.91,50.75,47.25,47.91,46.5,45.94,48.06,49.38,51.0,53.09,55.22,56.25,57.44,57.19,56.12,54.0,53.25,52.41,51.28,52.12,50.84,50.97,49.44,49.0,47.44,47.69,49.38,49.12,50.19,52.0,51.91,51.22,51.34,49.59,48.25,46.31,43.94,40.78,40.0,38.72,38.06,40.03,41.31,43.56,44.09,46.5,45.78,45.75,42.88,41.94,37.53,36.56,34.66,35.62,35.81,37.06,39.81,40.69,41.25,43.47,42.25,41.81,41.56,41.16,41.25,41.53,42.5,42.88,43.25,46.25,46.38,48.44,47.41,47.84,45.75,42.09,40.56,39.62,38.94,41.56,41.5,44.12,41.41,41.19,39.12,38.06,38.22,38.62,38.62,38.81,38.5,39.19,39.19,41.53,41.38,42.78,43.12,42.91,43.19,44.84,45.12,45.38,46.97,46.84,48.75,50.25,48.97,48.06,45.59,43.12,40.84,39.56,38.44,39.25,39.16,40.19,41.31,43.41,46.12,49.16,51.0,52.69,53.22,50.22,49.62,48.12,47.25,48.25,50.38,51.34,52.38,53.69,54.34,53.25,52.03,52.25,50.72,49.56,49.72,49.06,47.66,46.12,43.09,40.94,38.5,37.5,35.41,35.69,37.16,38.06,39.66,41.62,41.38,43.06,41.28,40.81,39.91,38.97,36.84,37.34,35.19,35.38,35.41,35.53,37.84,37.75,38.5,37.0,39.91,38.53,40.09,41.06,42.94,41.5,40.5,39.69,37.22,37.12,36.31,35.72,34.25,34.41,33.69,32.31,32.94,32.66,32.44,32.31,31.81,31.94,31.16,29.16,31.44,30.84,32.69,34.75,37.53,39.59,43.34,44.84,45.16,45.16,43.0,41.06,39.38,37.75,36.72,35.56,36.84,36.16,36.25,36.34,35.19,35.12,34.5,32.56,33.91,33.38,34.16,36.84,39.41,39.16,40.88,40.5,38.09,35.72,32.69,31.31,30.28,29.66,30.03,31.34,31.94,32.69,33.75,33.5,35.34,36.06,38.94,41.69,45.06,49.12,51.56,52.59,53.69,52.44,51.53,48.84,47.06,46.12,44.0,42.56,42.66,41.41,42.31,40.28,40.5,38.97,36.22,35.12,34.06,33.88,33.41,35.31,35.72,37.53,38.75,42.75,45.94,48.12,49.81,50.66,50.53,49.75,49.66,48.66,49.09,48.66,46.47,44.62,42.69,41.03,39.69,37.34,38.06,36.78,35.12,34.78,35.12,36.5,40.19,41.97,46.25,47.62,48.03,46.78,46.56,43.84,42.47,40.53,38.06,36.03,35.09,34.22,32.88,34.25,35.81,37.44,40.22,41.59,42.66,42.38,40.66,38.09,36.44,35.56,34.69,35.0,34.06,33.38,31.31,29.72,27.97,27.44,28.44,28.97,28.78,29.19,28.62,28.78,27.31,26.5,25.59,24.56,22.81,21.81,23.19,22.81,23.59,26.22,27.0,27.56,28.19,26.69,25.69,25.12,23.69,25.75,26.34,27.16,28.41,28.5,28.56,28.31,29.06,28.97,28.31,28.88,28.41,29.56,28.31,29.91,30.22,31.22,32.91,35.62,38.31,39.0,39.94,38.06,36.16,32.53,30.47,28.81,27.41,27.41,27.66,28.78,28.38,28.53,28.25,27.62,27.94,26.06,27.44,27.81,27.91,28.22,27.66,27.69,25.53,24.56,23.81,22.22,22.56,21.25,19.75,18.72,18.09,16.41,14.59,14.03,12.25,11.69,10.75,10.28,12.81,14.62,18.28,20.41,23.53,26.41,26.94,28.12,27.94,28.03,27.62,26.31,25.91,24.31,22.94,19.88,18.94,16.5,14.97,12.66,9.72,5.97,1.16,-2.56,-6.22,-7.59,-8.0,-7.81,-5.88,-3.94,-3.31,-0.97,-0.19,0.41,-1.81,-2.03,-3.16,-4.84,-5.28,-4.91,-4.66,-4.91,-3.97,-4.94,-3.81,-3.38,-3.88,-3.62,56.66,55.84,58.16,58.66,59.62,60.19,61.28,61.81,60.75,63.19,62.41,64.25,64.19,64.03,62.47,60.72,60.0,57.72,57.94,58.19,59.44,60.31,61.06,62.28,60.28,60.41,59.0,59.03,58.78,60.03:negativity
40.5,41.06,40.91,40.09,38.34,37.66,37.16,36.31,35.66,34.16,33.78,32.81,30.97,30.59,29.66,29.06,29.72,29.5,30.28,30.25,31.84,32.28,32.47,32.38,33.44,32.38,31.47,30.19,29.59,28.44,27.78,28.47,28.5,28.06,28.34,28.41,28.78,29.62,30.12,32.59,35.44,37.97,41.69,44.53,47.41,49.69,49.81,49.94,48.5,46.31,43.88,41.31,38.44,35.44,33.16,30.56,27.44,25.53,23.59,22.31,20.75,20.0,18.84,19.12,20.06,20.94,23.09,25.25,27.44,28.59,28.53,27.62,26.12,23.44,21.75,19.0,16.31,16.0,14.56,14.47,13.62,14.12,13.19,12.47,12.84,12.62,12.41,13.5,14.28,15.34,17.19,20.38,23.69,27.19,28.91,29.91,29.38,27.97,25.84,24.03,22.91,23.62,24.44,25.81,29.47,30.0,30.78,30.31,29.81,28.06,27.62,27.41,27.81,29.44,30.53,32.06,34.09,34.69,35.0,34.16,33.12,30.38,26.97,23.69,21.31,20.38,20.88,22.38,25.66,28.38,29.94,30.31,30.66,29.0,27.78,27.28,27.34,28.06,29.81,31.88,35.03,37.81,39.44,38.75,36.5,32.56,27.38,22.97,20.28,20.25,20.06,21.0,21.06,21.09,19.69,18.94,19.34,19.03,21.31,23.72,25.0,27.81,29.59,31.31,32.75,33.28,32.66,32.94,32.28,31.69,31.06,29.25,28.41,27.56,28.22,28.25,29.38,30.38,29.72,30.97,31.19,31.41,32.69,33.41,33.84,33.78,33.62,32.78,32.34,31.78,30.53,29.47,29.34,28.81,27.06,26.16,26.0,24.75,25.16,25.44,25.81,25.25,26.09,24.66,24.66,24.81,25.59,27.69,29.41,31.25,33.91,35.41,36.5,37.25,36.66,35.34,33.81,30.84,28.38,25.19,23.59,22.09,20.66,20.19,19.56,19.06,19.06,17.72,17.16,16.34,16.47,17.12,18.31,20.5,21.81,23.41,24.06,23.41,23.03,21.31,19.91,18.69,17.72,18.38,19.75,21.53,23.22,23.94,24.19,22.03,21.12,18.91,16.03,15.38,14.25,14.94,15.72,16.66,17.94,19.47,18.59,19.38,18.41,18.44,18.88,19.41,20.19,20.28,20.84,19.72,18.91,18.31,17.47,16.0,14.84,13.75,12.31,12.84,14.16,16.31,18.16,20.72,23.31,24.19,23.31,21.41,20.5,18.75,18.0,17.5,18.62,18.78,18.66,19.03,19.06,18.75,18.5,18.5,17.19,17.5,17.09,18.19,19.66,20.62,22.69,25.16,27.09,29.31,30.78,31.25,31.84,31.28,30.69,30.03,28.62,27.47,26.81,26.38,25.38,24.16,24.41,23.41,21.97,21.59,19.81,18.78,18.47,18.91,19.56,21.53,23.75,25.19,25.5,25.34,23.0,20.84,18.75,16.28,15.06,14.34,14.62,14.31,14.03,15.31,16.06,17.19,19.0,20.03,21.28,22.78,23.44,25.03,25.66,27.62,29.19,31.0,31.81,33.0,33.66,32.78,32.44,31.25,29.53,28.19,27.41,26.41,24.66,24.03,23.12,21.78,20.94,21.06,21.19,22.53,23.66,23.75,25.62,26.53,26.97,28.19,29.16,30.28,32.56,34.56,37.0,39.41,40.72,41.09,39.81,37.59,32.75,28.94,25.19,21.78,19.66,17.75,18.34,18.34,19.19,20.94,22.25,24.62,26.69,27.62,28.78,29.44,28.28,26.66,24.62,21.59,19.25,17.78,16.12,16.34,17.31,18.44,19.97,20.81,21.56,21.62,22.22,24.53,25.53,27.84,28.91,30.06,31.25,31.78,32.94,33.78,35.41,35.0,33.56,32.19,29.66,26.94,23.91,21.78,20.12,20.66,22.25,24.03,26.31,28.25,29.88,30.38,31.44,30.66,31.62,32.0,32.28,33.78,34.91,36.47,36.69,37.31,36.69,35.31,33.78,32.66,31.12,30.09,29.78,29.75,28.78,28.25,26.75,25.69,23.69,22.34,21.38,20.25,20.28,19.47,18.78,18.62,18.69,19.72,19.97,20.16,19.16,17.56,16.38,14.94,14.03,14.19,15.41,16.88,17.28,17.88,17.5,16.97,15.91,15.12,14.97,14.94,15.97,17.38,18.25,18.94,18.62,19.12,18.34,16.88,15.28,13.44,12.56,11.06,11.16,12.53,14.06,16.0,17.47,18.22,18.22,18.25,18.0,17.47,16.66,15.19,15.28,13.78,14.69,16.53,18.56,21.25,23.12,23.31,23.84,22.81,21.53,20.66,18.59,16.91,15.69,14.62,13.62,13.31,14.09,12.84,11.59,10.12,7.84,6.5,4.69,4.12,3.56,4.91,6.16,7.91,8.34,8.88,7.47,7.31,5.34,4.06,3.16,2.09,1.44,0.97,0.38,0.44,0.25,1.25,1.53,2.25,2.53,3.0,2.91,1.78,1.75,2.0,3.12,4.38,6.78,8.84,9.81,11.06,12.06,11.94,11.0,11.47,11.19,11.69,11.44,10.59,12.0,12.34,13.31,14.44,15.78,16.09,15.66,15.31,16.34,15.94,16.41,17.09,17.56,17.31,17.44,16.72,16.59,15.31,14.12,13.16,11.0,9.31,7.41,6.03,5.19,5.28,4.69,4.75,5.88,6.53,6.56,7.56,7.91,8.19,9.28,10.56,11.25,12.06,12.75,12.06,11.69,10.25,9.06,8.47,8.06,6.31,4.53,3.44,0.5,-1.53,-3.5,-3.41,-2.03,0.12,3.66,6.53,8.5,10.41,10.88,11.38,12.19,12.72,14.31,14.0,14.16,12.78,10.72,8.06,5.88,2.44,0.0,-2.31,-4.22,-4.91,-6.59,-6.09,-6.84,-7.22,-7.91,-9.09,-9.59,-9.66,-9.84,-9.81,-8.12,-6.78,-4.66,-0.84,1.38,3.97,5.91,6.78,6.12,5.81,5.75,5.06,5.34,4.34,3.12,2.16,2.19,1.34,1.0,1.09,0.72,1.41,2.53,4.06,6.44,8.03,8.41,6.94,5.03,1.78,-0.66,-2.69,-3.88,-4.38,-4.44,-4.41,-3.78,-4.91,-4.75,-5.41,-6.19,-6.28,-7.06,-7.09,-6.28,-4.25,-2.78,-2.06,-0.09,0.12,-0.56,-0.72,-1.03,-2.09,-2.84,-3.41,-3.97,-5.44,-5.97,-5.5,-6.59,-7.16,-7.09,-8.19,-8.34,-9.09,-9.0,-8.31,-6.84,-6.03,-5.22,-4.84,-5.34,-6.34,-7.44,-8.12,-10.12,-11.22,-12.62,-13.28,-13.06,-12.53,-12.03,-11.03,-11.69,-11.56,-11.75,-10.97,-9.44,-8.28,-6.53,-5.69,-4.53,-5.09,-6.0,-6.78,-7.69,-8.34,-7.97,-9.03,-8.09,-5.94,-3.91,-1.59,0.12,1.75,0.84,0.47,-0.94,-1.66,-0.81,-0.59,0.66,2.75,4.81,5.75,6.03,5.44,3.41,0.88,-1.53,-4.22,-6.66,-8.22,-8.16,-9.34,-9.0,-8.84,-9.78,-10.03,-10.84,-11.28,-11.78,-12.59,-12.34,-12.25,-11.91,-11.56,-10.75,-9.25,-8.72,-7.47,-6.47,-6.09,-4.72,-4.44,-3.5,-3.06,-1.94,-2.25,-2.09,-2.34,-3.28,-3.53,-3.72,-4.75,-6.03,-7.19,-8.34,-9.59,-9.47,-9.59,-8.59,-7.16,-5.72,-5.78,-5.66,-4.94,-5.28,-5.59,-5.22,-5.28,-4.94,-5.0,-4.84,-5.28,-5.19,-6.44,-6.88,-7.72,-7.41,-7.75,-8.59,-9.59,-10.84,-12.44,-13.88,-14.47,-13.03,-12.59,-12.19,-10.59,-10.03,-10.16,-10.59,-12.47,-12.78,-13.56,-14.97,-14.56,-13.47,-12.59,-12.34,-11.22,-10.81,-9.88,-8.09,-6.16,-2.84,1.09,5.97,9.69,12.31,13.69,11.91,9.5,5.72,1.44,-1.22,-3.94,-4.78,-5.22,-5.41,-5.56,-5.12,-5.19:37.16,36.31,35.66,34.16,33.78,32.81,30.97,30.59,29.66,29.06,29.72,29.5,30.28,30.25,31.84,32.28,32.47,32.38,33.44,32.38,31.47,30.19,29.59,28.44,27.78,28.47,28.5,28.06,28.34,28.41,28.78,29.62,30.12,32.59,35.44,37.97,41.69,44.53,47.41,49.69,49.81,49.94,48.5,46.31,43.88,41.31,38.44,35.44,33.16,30.56,27.44,25.53,23.59,22.31,20.75,20.0,18.84,19.12,20.06,20.94,23.09,25.25,27.44,28.59,28.53,27.62,26.12,23.44,21.75,19.0,16.31,16.0,14.56,14.47,13.62,14.12,13.19,12.47,12.84,12.62,12.41,13.5,14.28,15.34,17.19,20.38,23.69,27.19,28.91,29.91,29.38,27.97,25.84,24.03,22.91,23.62,24.44,25.81,29.47,30.0,30.78,30.31,29.81,28.06,27.62,27.41,27.81,29.44,30.53,32.06,34.09,34.69,35.0,34.16,33.12,30.38,26.97,23.69,21.31,20.38,20.88,22.38,25.66,28.38,29.94,30.31,30.66,29.0,27.78,27.28,27.34,28.06,29.81,31.88,35.03,37.81,39.44,38.75,36.5,32.56,27.38,22.97,20.28,20.25,20.06,21.0,21.06,21.09,19.69,18.94,19.34,19.03,21.31,23.72,25.0,27.81,29.59,31.31,32.75,33.28,32.66,32.94,32.28,31.69,31.06,29.25,28.41,27.56,28.22,28.25,29.38,30.38,29.72,30.97,31.19,31.41,32.69,33.41,33.84,33.78,33.62,32.78,32.34,31.78,30.53,29.47,29.34,28.81,27.06,26.16,26.0,24.75,25.16,25.44,25.81,25.25,26.09,24.66,24.66,24.81,25.59,27.69,29.41,31.25,33.91,35.41,36.5,37.25,36.66,35.34,33.81,30.84,28.38,25.19,23.59,22.09,20.66,20.19,19.56,19.06,19.06,17.72,17.16,16.34,16.47,17.12,18.31,20.5,21.81,23.41,24.06,23.41,23.03,21.31,19.91,18.69,17.72,18.38,19.75,21.53,23.22,23.94,24.19,22.03,21.12,18.91,16.03,15.38,14.25,14.94,15.72,16.66,17.94,19.47,18.59,19.38,18.41,18.44,18.88,19.41,20.19,20.28,20.84,19.72,18.91,18.31,17.47,16.0,14.84,13.75,12.31,12.84,14.16,16.31,18.16,20.72,23.31,24.19,23.31,21.41,20.5,18.75,18.0,17.5,18.62,18.78,18.66,19.03,19.06,18.75,18.5,18.5,17.19,17.5,17.09,18.19,19.66,20.62,22.69,25.16,27.09,29.31,30.78,31.25,31.84,31.28,30.69,30.03,28.62,27.47,26.81,26.38,25.38,24.16,24.41,23.41,21.97,21.59,19.81,18.78,18.47,18.91,19.56,21.53,23.75,25.19,25.5,25.34,23.0,20.84,18.75,16.28,15.06,14.34,14.62,14.31,14.03,15.31,16.06,17.19,19.0,20.03,21.28,22.78,23.44,25.03,25.66,27.62,29.19,31.0,31.81,33.0,33.66,32.78,32.44,31.25,29.53,28.19,27.41,26.41,24.66,24.03,23.12,21.78,20.94,21.06,21.19,22.53,23.66,23.75,25.62,26.53,26.97,28.19,29.16,30.28,32.56,34.56,37.0,39.41,40.72,41.09,39.81,37.59,32.75,28.94,25.19,21.78,19.66,17.75,18.34,18.34,19.19,20.94,22.25,24.62,26.69,27.62,28.78,29.44,28.28,26.66,24.62,21.59,19.25,17.78,16.12,16.34,17.31,18.44,19.97,20.81,21.56,21.62,22.22,24.53,25.53,27.84,28.91,30.06,31.25,31.78,32.94,33.78,35.41,35.0,33.56,32.19,29.66,26.94,23.91,21.78,20.12,20.66,22.25,24.03,26.31,28.25,29.88,30.38,31.44,30.66,31.62,32.0,32.28,33.78,34.91,36.47,36.69,37.31,36.69,35.31,33.78,32.66,31.12,30.09,29.78,29.75,28.78,28.25,26.75,25.69,23.69,22.34,21.38,20.25,20.28,19.47,18.78,18.62,18.69,19.72,19.97,20.16,19.16,17.56,16.38,14.94,14.03,14.19,15.41,16.88,17.28,17.88,17.5,16.97,15.91,15.12,14.97,14.94,15.97,17.38,18.25,18.94,18.62,19.12,18.34,16.88,15.28,13.44,12.56,11.06,11.16,12.53,14.06,16.0,17.47,18.22,18.22,18.25,18.0,17.47,16.66,15.19,15.28,13.78,14.69,16.53,18.56,21.25,23.12,23.31,23.84,22.81,21.53,20.66,18.59,16.91,15.69,14.62,13.62,13.31,14.09,12.84,11.59,10.12,7.84,6.5,4.69,4.12,3.56,4.91,6.16,7.91,8.34,8.88,7.47,7.31,5.34,4.06,3.16,2.09,1.44,0.97,0.38,0.44,0.25,1.25,1.53,2.25,2.53,3.0,2.91,1.78,1.75,2.0,3.12,4.38,6.78,8.84,9.81,11.06,12.06,11.94,11.0,11.47,11.19,11.69,11.44,10.59,12.0,12.34,13.31,14.44,15.78,16.09,15.66,15.31,16.34,15.94,16.41,17.09,17.56,17.31,17.44,16.72,16.59,15.31,14.12,13.16,11.0,9.31,7.41,6.03,5.19,5.28,4.69,4.75,5.88,6.53,6.56,7.56,7.91,8.19,9.28,10.56,11.25,12.06,12.75,12.06,11.69,10.25,9.06,8.47,8.06,6.31,4.53,3.44,0.5,-1.53,-3.5,-3.41,-2.03,0.12,3.66,6.53,8.5,10.41,10.88,11.38,12.19,12.72,14.31,14.0,14.16,12.78,10.72,8.06,5.88,2.44,0.0,-2.31,-4.22,-4.91,-6.59,-6.09,-6.84,-7.22,-7.91,-9.09,-9.59,-9.66,-9.84,-9.81,-8.12,-6.78,-4.66,-0.84,1.38,3.97,5.91,6.78,6.12,5.81,5.75,5.06,5.34,4.34,3.12,2.16,2.19,1.34,1.0,1.09,0.72,1.41,2.53,4.06,6.44,8.03,8.41,6.94,5.03,1.78,-0.66,-2.69,-3.88,-4.38,-4.44,-4.41,-3.78,-4.91,-4.75,-5.41,-6.19,-6.28,-7.06,-7.09,-6.28,-4.25,-2.78,-2.06,-0.09,0.12,-0.56,-0.72,-1.03,-2.09,-2.84,-3.41,-3.97,-5.44,-5.97,-5.5,-6.59,-7.16,-7.09,-8.19,-8.34,-9.09,-9.0,-8.31,-6.84,-6.03,-5.22,-4.84,-5.34,-6.34,-7.44,-8.12,-10.12,-11.22,-12.62,-13.28,-13.06,-12.53,-12.03,-11.03,-11.69,-11.56,-11.75,-10.97,-9.44,-8.28,-6.53,-5.69,-4.53,-5.09,-6.0,-6.78,-7.69,-8.34,-7.97,-9.03,-8.09,-5.94,-3.91,-1.59,0.12,1.75,0.84,0.47,-0.94,-1.66,-0.81,-0.59,0.66,2.75,4.81,5.75,6.03,5.44,3.41,0.88,-1.53,-4.22,-6.66,-8.22,-8.16,-9.34,-9.0,-8.84,-9.78,-10.03,-10.84,-11.28,-11.78,-12.59,-12.34,-12.25,-11.91,-11.56,-10.75,-9.25,-8.72,-7.47,-6.47,-6.09,-4.72,-4.44,-3.5,-3.06,-1.94,-2.25,-2.09,-2.34,-3.28,-3.53,-3.72,-4.75,-6.03,-7.19,-8.34,-9.59,-9.47,-9.59,-8.59,-7.16,-5.72,-5.78,-5.66,-4.94,-5.28,-5.59,-5.22,-5.28,-4.94,-5.0,-4.84,-5.28,-5.19,-6.44,-6.88,-7.72,-7.41,-7.75,-8.59,-9.59,-10.84,-12.44,-13.88,-14.47,-13.03,-12.59,-12.19,-10.59,-10.03,-10.16,-10.59,-12.47,-12.78,-13.56,-14.97,-14.56,-13.47,-12.59,-12.34,-11.22,-10.81,-9.88,-8.09,-6.16,-2.84,1.09,5.97,9.69,12.31,13.69,11.91,9.5,5.72,1.44,-1.22,-3.94,-4.78,-5.22,-5.41,-5.56,-5.12,-5.19,42.22,42.91,41.38,40.22,38.47,37.41:30.97,30.59,29.66,29.06,29.72,29.5,30.28,30.25,31.84,32.28,32.47,32.38,33.44,32.38,31.47,30.19,29.59,28.44,27.78,28.47,28.5,28.06,28.34,28.41,28.78,29.62,30.12,32.59,35.44,37.97,41.69,44.53,47.41,49.69,49.81,49.94,48.5,46.31,43.88,41.31,38.44,35.44,33.16,30.56,27.44,25.53,23.59,22.31,20.75,20.0,18.84,19.12,20.06,20.94,23.09,25.25,27.44,28.59,28.53,27.62,26.12,23.44,21.75,19.0,16.31,16.0,14.56,14.47,13.62,14.12,13.19,12.47,12.84,12.62,12.41,13.5,14.28,15.34,17.19,20.38,23.69,27.19,28.91,29.91,29.38,27.97,25.84,24.03,22.91,23.62,24.44,25.81,29.47,30.0,30.78,30.31,29.81,28.06,27.62,27.41,27.81,29.44,30.53,32.06,34.09,34.69,35.0,34.16,33.12,30.38,26.97,23.69,21.31,20.38,20.88,22.38,25.66,28.38,29.94,30.31,30.66,29.0,27.78,27.28,27.34,28.06,29.81,31.88,35.03,37.81,39.44,38.75,36.5,32.56,27.38,22.97,20.28,20.25,20.06,21.0,21.06,21.09,19.69,18.94,19.34,19.03,21.31,23.72,25.0,27.81,29.59,31.31,32.75,33.28,32.66,32.94,32.28,31.69,31.06,29.25,28.41,27.56,28.22,28.25,29.38,30.38,29.72,30.97,31.19,31.41,32.69,33.41,33.84,33.78,33.62,32.78,32.34,31.78,30.53,29.47,29.34,28.81,27.06,26.16,26.0,24.75,25.16,25.44,25.81,25.25,26.09,24.66,24.66,24.81,25.59,27.69,29.41,31.25,33.91,35.41,36.5,37.25,36.66,35.34,33.81,30.84,28.38,25.19,23.59,22.09,20.66,20.19,19.56,19.06,19.06,17.72,17.16,16.34,16.47,17.12,18.31,20.5,21.81,23.41,24.06,23.41,23.03,21.31,19.91,18.69,17.72,18.38,19.75,21.53,23.22,23.94,24.19,22.03,21.12,18.91,16.03,15.38,14.25,14.94,15.72,16.66,17.94,19.47,18.59,19.38,18.41,18.44,18.88,19.41,20.19,20.28,20.84,19.72,18.91,18.31,17.47,16.0,14.84,13.75,12.31,12.84,14.16,16.31,18.16,20.72,23.31,24.19,23.31,21.41,20.5,18.75,18.0,17.5,18.62,18.78,18.66,19.03,19.06,18.75,18.5,18.5,17.19,17.5,17.09,18.19,19.66,20.62,22.69,25.16,27.09,29.31,30.78,31.25,31.84,31.28,30.69,30.03,28.62,27.47,26.81,26.38,25.38,24.16,24.41,23.41,21.97,21.59,19.81,18.78,18.47,18.91,19.56,21.53,23.75,25.19,25.5,25.34,23.0,20.84,18.75,16.28,15.06,14.34,14.62,14.31,14.03,15.31,16.06,17.19,19.0,20.03,21.28,22.78,23.44,25.03,25.66,27.62,29.19,31.0,31.81,33.0,33.66,32.78,32.44,31.25,29.53,28.19,27.41,26.41,24.66,24.03,23.12,21.78,20.94,21.06,21.19,22.53,23.66,23.75,25.62,26.53,26.97,28.19,29.16,30.28,32.56,34.56,37.0,39.41,40.72,41.09,39.81,37.59,32.75,28.94,25.19,21.78,19.66,17.75,18.34,18.34,19.19,20.94,22.25,24.62,26.69,27.62,28.78,29.44,28.28,26.66,24.62,21.59,19.25,17.78,16.12,16.34,17.31,18.44,19.97,20.81,21.56,21.62,22.22,24.53,25.53,27.84,28.91,30.06,31.25,31.78,32.94,33.78,35.41,35.0,33.56,32.19,29.66,26.94,23.91,21.78,20.12,20.66,22.25,24.03,26.31,28.25,29.88,30.38,31.44,30.66,31.62,32.0,32.28,33.78,34.91,36.47,36.69,37.31,36.69,35.31,33.78,32.66,31.12,30.09,29.78,29.75,28.78,28.25,26.75,25.69,23.69,22.34,21.38,20.25,20.28,19.47,18.78,18.62,18.69,19.72,19.97,20.16,19.16,17.56,16.38,14.94,14.03,14.19,15.41,16.88,17.28,17.88,17.5,16.97,15.91,15.12,14.97,14.94,15.97,17.38,18.25,18.94,18.62,19.12,18.34,16.88,15.28,13.44,12.56,11.06,11.16,12.53,14.06,16.0,17.47,18.22,18.22,18.25,18.0,17.47,16.66,15.19,15.28,13.78,14.69,16.53,18.56,21.25,23.12,23.31,23.84,22.81,21.53,20.66,18.59,16.91,15.69,14.62,13.62,13.31,14.09,12.84,11.59,10.12,7.84,6.5,4.69,4.12,3.56,4.91,6.16,7.91,8.34,8.88,7.47,7.31,5.34,4.06,3.16,2.09,1.44,0.97,0.38,0.44,0.25,1.25,1.53,2.25,2.53,3.0,2.91,1.78,1.75,2.0,3.12,4.38,6.78,8.84,9.81,11.06,12.06,11.94,11.0,11.47,11.19,11.69,11.44,10.59,12.0,12.34,13.31,14.44,15.78,16.09,15.66,15.31,16.34,15.94,16.41,17.09,17.56,17.31,17.44,16.72,16.59,15.31,14.12,13.16,11.0,9.31,7.41,6.03,5.19,5.28,4.69,4.75,5.88,6.53,6.56,7.56,7.91,8.19,9.28,10.56,11.25,12.06,12.75,12.06,11.69,10.25,9.06,8.47,8.06,6.31,4.53,3.44,0.5,-1.53,-3.5,-3.41,-2.03,0.12,3.66,6.53,8.5,10.41,10.88,11.38,12.19,12.72,14.31,14.0,14.16,12.78,10.72,8.06,5.88,2.44,0.0,-2.31,-4.22,-4.91,-6.59,-6.09,-6.84,-7.22,-7.91,-9.09,-9.59,-9.66,-9.84,-9.81,-8.12,-6.78,-4.66,-0.84,1.38,3.97,5.91,6.78,6.12,5.81,5.75,5.06,5.34,4.34,3.12,2.16,2.19,1.34,1.0,1.09,0.72,1.41,2.53,4.06,6.44,8.03,8.41,6.94,5.03,1.78,-0.66,-2.69,-3.88,-4.38,-4.44,-4.41,-3.78,-4.91,-4.75,-5.41,-6.19,-6.28,-7.06,-7.09,-6.28,-4.25,-2.78,-2.06,-0.09,0.12,-0.56,-0.72,-1.03,-2.09,-2.84,-3.41,-3.97,-5.44,-5.97,-5.5,-6.59,-7.16,-7.09,-8.19,-8.34,-9.09,-9.0,-8.31,-6.84,-6.03,-5.22,-4.84,-5.34,-6.34,-7.44,-8.12,-10.12,-11.22,-12.62,-13.28,-13.06,-12.53,-12.03,-11.03,-11.69,-11.56,-11.75,-10.97,-9.44,-8.28,-6.53,-5.69,-4.53,-5.09,-6.0,-6.78,-7.69,-8.34,-7.97,-9.03,-8.09,-5.94,-3.91,-1.59,0.12,1.75,0.84,0.47,-0.94,-1.66,-0.81,-0.59,0.66,2.75,4.81,5.75,6.03,5.44,3.41,0.88,-1.53,-4.22,-6.66,-8.22,-8.16,-9.34,-9.0,-8.84,-9.78,-10.03,-10.84,-11.28,-11.78,-12.59,-12.34,-12.25,-11.91,-11.56,-10.75,-9.25,-8.72,-7.47,-6.47,-6.09,-4.72,-4.44,-3.5,-3.06,-1.94,-2.25,-2.09,-2.34,-3.28,-3.53,-3.72,-4.75,-6.03,-7.19,-8.34,-9.59,-9.47,-9.59,-8.59,-7.16,-5.72,-5.78,-5.66,-4.94,-5.28,-5.59,-5.22,-5.28,-4.94,-5.0,-4.84,-5.28,-5.19,-6.44,-6.88,-7.72,-7.41,-7.75,-8.59,-9.59,-10.84,-12.44,-13.88,-14.47,-13.03,-12.59,-12.19,-10.59,-10.03,-10.16,-10.59,-12.47,-12.78,-13.56,-14.97,-14.56,-13.47,-12.59,-12.34,-11.22,-10.81,-9.88,-8.09,-6.16,-2.84,1.09,5.97,9.69,12.31,13.69,11.91,9.5,5.72,1.44,-1.22,-3.94,-4.78,-5.22,-5.41,-5.56,-5.12,-5.19,42.22,42.91,41.38,40.22,38.47,37.41,35.97,34.97,33.84,32.78,32.47,31.47:30.28,30.25,31.84,32.28,32.47,32.38,33.44,32.38,31.47,30.19,29.59,28.44,27.78,28.47,28.5,28.06,28.34,28.41,28.78,29.62,30.12,32.59,35.44,37.97,41.69,44.53,47.41,49.69,49.81,49.94,48.5,46.31,43.88,41.31,38.44,35.44,33.16,30.56,27.44,25.53,23.59,22.31,20.75,20.0,18.84,19.12,20.06,20.94,23.09,25.25,27.44,28.59,28.53,27.62,26.12,23.44,21.75,19.0,16.31,16.0,14.56,14.47,13.62,14.12,13.19,12.47,12.84,12.62,12.41,13.5,14.28,15.34,17.19,20.38,23.69,27.19,28.91,29.91,29.38,27.97,25.84,24.03,22.91,23.62,24.44,25.81,29.47,30.0,30.78,30.31,29.81,28.06,27.62,27.41,27.81,29.44,30.53,32.06,34.09,34.69,35.0,34.16,33.12,30.38,26.97,23.69,21.31,20.38,20.88,22.38,25.66,28.38,29.94,30.31,30.66,29.0,27.78,27.28,27.34,28.06,29.81,31.88,35.03,37.81,39.44,38.75,36.5,32.56,27.38,22.97,20.28,20.25,20.06,21.0,21.06,21.09,19.69,18.94,19.34,19.03,21.31,23.72,25.0,27.81,29.59,31.31,32.75,33.28,32.66,32.94,32.28,31.69,31.06,29.25,28.41,27.56,28.22,28.25,29.38,30.38,29.72,30.97,31.19,31.41,32.69,33.41,33.84,33.78,33.62,32.78,32.34,31.78,30.53,29.47,29.34,28.81,27.06,26.16,26.0,24.75,25.16,25.44,25.81,25.25,26.09,24.66,24.66,24.81,25.59,27.69,29.41,31.25,33.91,35.41,36.5,37.25,36.66,35.34,33.81,30.84,28.38,25.19,23.59,22.09,20.66,20.19,19.56,19.06,19.06,17.72,17.16,16.34,16.47,17.12,18.31,20.5,21.81,23.41,24.06,23.41,23.03,21.31,19.91,18.69,17.72,18.38,19.75,21.53,23.22,23.94,24.19,22.03,21.12,18.91,16.03,15.38,14.25,14.94,15.72,16.66,17.94,19.47,18.59,19.38,18.41,18.44,18.88,19.41,20.19,20.28,20.84,19.72,18.91,18.31,17.47,16.0,14.84,13.75,12.31,12.84,14.16,16.31,18.16,20.72,23.31,24.19,23.31,21.41,20.5,18.75,18.0,17.5,18.62,18.78,18.66,19.03,19.06,18.75,18.5,18.5,17.19,17.5,17.09,18.19,19.66,20.62,22.69,25.16,27.09,29.31,30.78,31.25,31.84,31.28,30.69,30.03,28.62,27.47,26.81,26.38,25.38,24.16,24.41,23.41,21.97,21.59,19.81,18.78,18.47,18.91,19.56,21.53,23.75,25.19,25.5,25.34,23.0,20.84,18.75,16.28,15.06,14.34,14.62,14.31,14.03,15.31,16.06,17.19,19.0,20.03,21.28,22.78,23.44,25.03,25.66,27.62,29.19,31.0,31.81,33.0,33.66,32.78,32.44,31.25,29.53,28.19,27.41,26.41,24.66,24.03,23.12,21.78,20.94,21.06,21.19,22.53,23.66,23.75,25.62,26.53,26.97,28.19,29.16,30.28,32.56,34.56,37.0,39.41,40.72,41.09,39.81,37.59,32.75,28.94,25.19,21.78,19.66,17.75,18.34,18.34,19.19,20.94,22.25,24.62,26.69,27.62,28.78,29.44,28.28,26.66,24.62,21.59,19.25,17.78,16.12,16.34,17.31,18.44,19.97,20.81,21.56,21.62,22.22,24.53,25.53,27.84,28.91,30.06,31.25,31.78,32.94,33.78,35.41,35.0,33.56,32.19,29.66,26.94,23.91,21.78,20.12,20.66,22.25,24.03,26.31,28.25,29.88,30.38,31.44,30.66,31.62,32.0,32.28,33.78,34.91,36.47,36.69,37.31,36.69,35.31,33.78,32.66,31.12,30.09,29.78,29.75,28.78,28.25,26.75,25.69,23.69,22.34,21.38,20.25,20.28,19.47,18.78,18.62,18.69,19.72,19.97,20.16,19.16,17.56,16.38,14.94,14.03,14.19,15.41,16.88,17.28,17.88,17.5,16.97,15.91,15.12,14.97,14.94,15.97,17.38,18.25,18.94,18.62,19.12,18.34,16.88,15.28,13.44,12.56,11.06,11.16,12.53,14.06,16.0,17.47,18.22,18.22,18.25,18.0,17.47,16.66,15.19,15.28,13.78,14.69,16.53,18.56,21.25,23.12,23.31,23.84,22.81,21.53,20.66,18.59,16.91,15.69,14.62,13.62,13.31,14.09,12.84,11.59,10.12,7.84,6.5,4.69,4.12,3.56,4.91,6.16,7.91,8.34,8.88,7.47,7.31,5.34,4.06,3.16,2.09,1.44,0.97,0.38,0.44,0.25,1.25,1.53,2.25,2.53,3.0,2.91,1.78,1.75,2.0,3.12,4.38,6.78,8.84,9.81,11.06,12.06,11.94,11.0,11.47,11.19,11.69,11.44,10.59,12.0,12.34,13.31,14.44,15.78,16.09,15.66,15.31,16.34,15.94,16.41,17.09,17.56,17.31,17.44,16.72,16.59,15.31,14.12,13.16,11.0,9.31,7.41,6.03,5.19,5.28,4.69,4.75,5.88,6.53,6.56,7.56,7.91,8.19,9.28,10.56,11.25,12.06,12.75,12.06,11.69,10.25,9.06,8.47,8.06,6.31,4.53,3.44,0.5,-1.53,-3.5,-3.41,-2.03,0.12,3.66,6.53,8.5,10.41,10.88,11.38,12.19,12.72,14.31,14.0,14.16,12.78,10.72,8.06,5.88,2.44,0.0,-2.31,-4.22,-4.91,-6.59,-6.09,-6.84,-7.22,-7.91,-9.09,-9.59,-9.66,-9.84,-9.81,-8.12,-6.78,-4.66,-0.84,1.38,3.97,5.91,6.78,6.12,5.81,5.75,5.06,5.34,4.34,3.12,2.16,2.19,1.34,1.0,1.09,0.72,1.41,2.53,4.06,6.44,8.03,8.41,6.94,5.03,1.78,-0.66,-2.69,-3.88,-4.38,-4.44,-4.41,-3.78,-4.91,-4.75,-5.41,-6.19,-6.28,-7.06,-7.09,-6.28,-4.25,-2.78,-2.06,-0.09,0.12,-0.56,-0.72,-1.03,-2.09,-2.84,-3.41,-3.97,-5.44,-5.97,-5.5,-6.59,-7.16,-7.09,-8.19,-8.34,-9.09,-9.0,-8.31,-6.84,-6.03,-5.22,-4.84,-5.34,-6.34,-7.44,-8.12,-10.12,-11.22,-12.62,-13.28,-13.06,-12.53,-12.03,-11.03,-11.69,-11.56,-11.75,-10.97,-9.44,-8.28,-6.53,-5.69,-4.53,-5.09,-6.0,-6.78,-7.69,-8.34,-7.97,-9.03,-8.09,-5.94,-3.91,-1.59,0.12,1.75,0.84,0.47,-0.94,-1.66,-0.81,-0.59,0.66,2.75,4.81,5.75,6.03,5.44,3.41,0.88,-1.53,-4.22,-6.66,-8.22,-8.16,-9.34,-9.0,-8.84,-9.78,-10.03,-10.84,-11.28,-11.78,-12.59,-12.34,-12.25,-11.91,-11.56,-10.75,-9.25,-8.72,-7.47,-6.47,-6.09,-4.72,-4.44,-3.5,-3.06,-1.94,-2.25,-2.09,-2.34,-3.28,-3.53,-3.72,-4.75,-6.03,-7.19,-8.34,-9.59,-9.47,-9.59,-8.59,-7.16,-5.72,-5.78,-5.66,-4.94,-5.28,-5.59,-5.22,-5.28,-4.94,-5.0,-4.84,-5.28,-5.19,-6.44,-6.88,-7.72,-7.41,-7.75,-8.59,-9.59,-10.84,-12.44,-13.88,-14.47,-13.03,-12.59,-12.19,-10.59,-10.03,-10.16,-10.59,-12.47,-12.78,-13.56,-14.97,-14.56,-13.47,-12.59,-12.34,-11.22,-10.81,-9.88,-8.09,-6.16,-2.84,1.09,5.97,9.69,12.31,13.69,11.91,9.5,5.72,1.44,-1.22,-3.94,-4.78,-5.22,-5.41,-5.56,-5.12,-5.19,42.22,42.91,41.38,40.22,38.47,37.41,35.97,34.97,33.84,32.78,32.47,31.47,30.69,30.81,30.31,30.16,30.69,30.75:33.44,32.38,31.47,30.19,29.59,28.44,27.78,28.47,28.5,28.06,28.34,28.41,28.78,29.62,30.12,32.59,35.44,37.97,41.69,44.53,47.41,49.69,49.81,49.94,48.5,46.31,43.88,41.31,38.44,35.44,33.16,30.56,27.44,25.53,23.59,22.31,20.75,20.0,18.84,19.12,20.06,20.94,23.09,25.25,27.44,28.59,28.53,27.62,26.12,23.44,21.75,19.0,16.31,16.0,14.56,14.47,13.62,14.12,13.19,12.47,12.84,12.62,12.41,13.5,14.28,15.34,17.19,20.38,23.69,27.19,28.91,29.91,29.38,27.97,25.84,24.03,22.91,23.62,24.44,25.81,29.47,30.0,30.78,30.31,29.81,28.06,27.62,27.41,27.81,29.44,30.53,32.06,34.09,34.69,35.0,34.16,33.12,30.38,26.97,23.69,21.31,20.38,20.88,22.38,25.66,28.38,29.94,30.31,30.66,29.0,27.78,27.28,27.34,28.06,29.81,31.88,35.03,37.81,39.44,38.75,36.5,32.56,27.38,22.97,20.28,20.25,20.06,21.0,21.06,21.09,19.69,18.94,19.34,19.03,21.31,23.72,25.0,27.81,29.59,31.31,32.75,33.28,32.66,32.94,32.28,31.69,31.06,29.25,28.41,27.56,28.22,28.25,29.38,30.38,29.72,30.97,31.19,31.41,32.69,33.41,33.84,33.78,33.62,32.78,32.34,31.78,30.53,29.47,29.34,28.81,27.06,26.16,26.0,24.75,25.16,25.44,25.81,25.25,26.09,24.66,24.66,24.81,25.59,27.69,29.41,31.25,33.91,35.41,36.5,37.25,36.66,35.34,33.81,30.84,28.38,25.19,23.59,22.09,20.66,20.19,19.56,19.06,19.06,17.72,17.16,16.34,16.47,17.12,18.31,20.5,21.81,23.41,24.06,23.41,23.03,21.31,19.91,18.69,17.72,18.38,19.75,21.53,23.22,23.94,24.19,22.03,21.12,18.91,16.03,15.38,14.25,14.94,15.72,16.66,17.94,19.47,18.59,19.38,18.41,18.44,18.88,19.41,20.19,20.28,20.84,19.72,18.91,18.31,17.47,16.0,14.84,13.75,12.31,12.84,14.16,16.31,18.16,20.72,23.31,24.19,23.31,21.41,20.5,18.75,18.0,17.5,18.62,18.78,18.66,19.03,19.06,18.75,18.5,18.5,17.19,17.5,17.09,18.19,19.66,20.62,22.69,25.16,27.09,29.31,30.78,31.25,31.84,31.28,30.69,30.03,28.62,27.47,26.81,26.38,25.38,24.16,24.41,23.41,21.97,21.59,19.81,18.78,18.47,18.91,19.56,21.53,23.75,25.19,25.5,25.34,23.0,20.84,18.75,16.28,15.06,14.34,14.62,14.31,14.03,15.31,16.06,17.19,19.0,20.03,21.28,22.78,23.44,25.03,25.66,27.62,29.19,31.0,31.81,33.0,33.66,32.78,32.44,31.25,29.53,28.19,27.41,26.41,24.66,24.03,23.12,21.78,20.94,21.06,21.19,22.53,23.66,23.75,25.62,26.53,26.97,28.19,29.16,30.28,32.56,34.56,37.0,39.41,40.72,41.09,39.81,37.59,32.75,28.94,25.19,21.78,19.66,17.75,18.34,18.34,19.19,20.94,22.25,24.62,26.69,27.62,28.78,29.44,28.28,26.66,24.62,21.59,19.25,17.78,16.12,16.34,17.31,18.44,19.97,20.81,21.56,21.62,22.22,24.53,25.53,27.84,28.91,30.06,31.25,31.78,32.94,33.78,35.41,35.0,33.56,32.19,29.66,26.94,23.91,21.78,20.12,20.66,22.25,24.03,26.31,28.25,29.88,30.38,31.44,30.66,31.62,32.0,32.28,33.78,34.91,36.47,36.69,37.31,36.69,35.31,33.78,32.66,31.12,30.09,29.78,29.75,28.78,28.25,26.75,25.69,23.69,22.34,21.38,20.25,20.28,19.47,18.78,18.62,18.69,19.72,19.97,20.16,19.16,17.56,16.38,14.94,14.03,14.19,15.41,16.88,17.28,17.88,17.5,16.97,15.91,15.12,14.97,14.94,15.97,17.38,18.25,18.94,18.62,19.12,18.34,16.88,15.28,13.44,12.56,11.06,11.16,12.53,14.06,16.0,17.47,18.22,18.22,18.25,18.0,17.47,16.66,15.19,15.28,13.78,14.69,16.53,18.56,21.25,23.12,23.31,23.84,22.81,21.53,20.66,18.59,16.91,15.69,14.62,13.62,13.31,14.09,12.84,11.59,10.12,7.84,6.5,4.69,4.12,3.56,4.91,6.16,7.91,8.34,8.88,7.47,7.31,5.34,4.06,3.16,2.09,1.44,0.97,0.38,0.44,0.25,1.25,1.53,2.25,2.53,3.0,2.91,1.78,1.75,2.0,3.12,4.38,6.78,8.84,9.81,11.06,12.06,11.94,11.0,11.47,11.19,11.69,11.44,10.59,12.0,12.34,13.31,14.44,15.78,16.09,15.66,15.31,16.34,15.94,16.41,17.09,17.56,17.31,17.44,16.72,16.59,15.31,14.12,13.16,11.0,9.31,7.41,6.03,5.19,5.28,4.69,4.75,5.88,6.53,6.56,7.56,7.91,8.19,9.28,10.56,11.25,12.06,12.75,12.06,11.69,10.25,9.06,8.47,8.06,6.31,4.53,3.44,0.5,-1.53,-3.5,-3.41,-2.03,0.12,3.66,6.53,8.5,10.41,10.88,11.38,12.19,12.72,14.31,14.0,14.16,12.78,10.72,8.06,5.88,2.44,0.0,-2.31,-4.22,-4.91,-6.59,-6.09,-6.84,-7.22,-7.91,-9.09,-9.59,-9.66,-9.84,-9.81,-8.12,-6.78,-4.66,-0.84,1.38,3.97,5.91,6.78,6.12,5.81,5.75,5.06,5.34,4.34,3.12,2.16,2.19,1.34,1.0,1.09,0.72,1.41,2.53,4.06,6.44,8.03,8.41,6.94,5.03,1.78,-0.66,-2.69,-3.88,-4.38,-4.44,-4.41,-3.78,-4.91,-4.75,-5.41,-6.19,-6.28,-7.06,-7.09,-6.28,-4.25,-2.78,-2.06,-0.09,0.12,-0.56,-0.72,-1.03,-2.09,-2.84,-3.41,-3.97,-5.44,-5.97,-5.5,-6.59,-7.16,-7.09,-8.19,-8.34,-9.09,-9.0,-8.31,-6.84,-6.03,-5.22,-4.84,-5.34,-6.34,-7.44,-8.12,-10.12,-11.22,-12.62,-13.28,-13.06,-12.53,-12.03,-11.03,-11.69,-11.56,-11.75,-10.97,-9.44,-8.28,-6.53,-5.69,-4.53,-5.09,-6.0,-6.78,-7.69,-8.34,-7.97,-9.03,-8.09,-5.94,-3.91,-1.59,0.12,1.75,0.84,0.47,-0.94,-1.66,-0.81,-0.59,0.66,2.75,4.81,5.75,6.03,5.44,3.41,0.88,-1.53,-4.22,-6.66,-8.22,-8.16,-9.34,-9.0,-8.84,-9.78,-10.03,-10.84,-11.28,-11.78,-12.59,-12.34,-12.25,-11.91,-11.56,-10.75,-9.25,-8.72,-7.47,-6.47,-6.09,-4.72,-4.44,-3.5,-3.06,-1.94,-2.25,-2.09,-2.34,-3.28,-3.53,-3.72,-4.75,-6.03,-7.19,-8.34,-9.59,-9.47,-9.59,-8.59,-7.16,-5.72,-5.78,-5.66,-4.94,-5.28,-5.59,-5.22,-5.28,-4.94,-5.0,-4.84,-5.28,-5.19,-6.44,-6.88,-7.72,-7.41,-7.75,-8.59,-9.59,-10.84,-12.44,-13.88,-14.47,-13.03,-12.59,-12.19,-10.59,-10.03,-10.16,-10.59,-12.47,-12.78,-13.56,-14.97,-14.56,-13.47,-12.59,-12.34,-11.22,-10.81,-9.88,-8.09,-6.16,-2.84,1.09,5.97,9.69,12.31,13.69,11.91,9.5,5.72,1.44,-1.22,-3.94,-4.78,-5.22,-5.41,-5.56,-5.12,-5.19,42.22,42.91,41.38,40.22,38.47,37.41,35.97,34.97,33.84,32.78,32.47,31.47,30.69,30.81,30.31,30.16,30.69,30.75,31.56,31.66,32.56,32.56,32.56,32.38:27.78,28.47,28.5,28.06,28.34,28.41,28.78,29.62,30.12,32.59,35.44,37.97,41.69,44.53,47.41,49.69,49.81,49.94,48.5,46.31,43.88,41.31,38.44,35.44,33.16,30.56,27.44,25.53,23.59,22.31,20.75,20.0,18.84,19.12,20.06,20.94,23.09,25.25,27.44,28.59,28.53,27.62,26.12,23.44,21.75,19.0,16.31,16.0,14.56,14.47,13.62,14.12,13.19,12.47,12.84,12.62,12.41,13.5,14.28,15.34,17.19,20.38,23.69,27.19,28.91,29.91,29.38,27.97,25.84,24.03,22.91,23.62,24.44,25.81,29.47,30.0,30.78,30.31,29.81,28.06,27.62,27.41,27.81,29.44,30.53,32.06,34.09,34.69,35.0,34.16,33.12,30.38,26.97,23.69,21.31,20.38,20.88,22.38,25.66,28.38,29.94,30.31,30.66,29.0,27.78,27.28,27.34,28.06,29.81,31.88,35.03,37.81,39.44,38.75,36.5,32.56,27.38,22.97,20.28,20.25,20.06,21.0,21.06,21.09,19.69,18.94,19.34,19.03,21.31,23.72,25.0,27.81,29.59,31.31,32.75,33.28,32.66,32.94,32.28,31.69,31.06,29.25,28.41,27.56,28.22,28.25,29.38,30.38,29.72,30.97,31.19,31.41,32.69,33.41,33.84,33.78,33.62,32.78,32.34,31.78,30.53,29.47,29.34,28.81,27.06,26.16,26.0,24.75,25.16,25.44,25.81,25.25,26.09,24.66,24.66,24.81,25.59,27.69,29.41,31.25,33.91,35.41,36.5,37.25,36.66,35.34,33.81,30.84,28.38,25.19,23.59,22.09,20.66,20.19,19.56,19.06,19.06,17.72,17.16,16.34,16.47,17.12,18.31,20.5,21.81,23.41,24.06,23.41,23.03,21.31,19.91,18.69,17.72,18.38,19.75,21.53,23.22,23.94,24.19,22.03,21.12,18.91,16.03,15.38,14.25,14.94,15.72,16.66,17.94,19.47,18.59,19.38,18.41,18.44,18.88,19.41,20.19,20.28,20.84,19.72,18.91,18.31,17.47,16.0,14.84,13.75,12.31,12.84,14.16,16.31,18.16,20.72,23.31,24.19,23.31,21.41,20.5,18.75,18.0,17.5,18.62,18.78,18.66,19.03,19.06,18.75,18.5,18.5,17.19,17.5,17.09,18.19,19.66,20.62,22.69,25.16,27.09,29.31,30.78,31.25,31.84,31.28,30.69,30.03,28.62,27.47,26.81,26.38,25.38,24.16,24.41,23.41,21.97,21.59,19.81,18.78,18.47,18.91,19.56,21.53,23.75,25.19,25.5,25.34,23.0,20.84,18.75,16.28,15.06,14.34,14.62,14.31,14.03,15.31,16.06,17.19,19.0,20.03,21.28,22.78,23.44,25.03,25.66,27.62,29.19,31.0,31.81,33.0,33.66,32.78,32.44,31.25,29.53,28.19,27.41,26.41,24.66,24.03,23.12,21.78,20.94,21.06,21.19,22.53,23.66,23.75,25.62,26.53,26.97,28.19,29.16,30.28,32.56,34.56,37.0,39.41,40.72,41.09,39.81,37.59,32.75,28.94,25.19,21.78,19.66,17.75,18.34,18.34,19.19,20.94,22.25,24.62,26.69,27.62,28.78,29.44,28.28,26.66,24.62,21.59,19.25,17.78,16.12,16.34,17.31,18.44,19.97,20.81,21.56,21.62,22.22,24.53,25.53,27.84,28.91,30.06,31.25,31.78,32.94,33.78,35.41,35.0,33.56,32.19,29.66,26.94,23.91,21.78,20.12,20.66,22.25,24.03,26.31,28.25,29.88,30.38,31.44,30.66,31.62,32.0,32.28,33.78,34.91,36.47,36.69,37.31,36.69,35.31,33.78,32.66,31.12,30.09,29.78,29.75,28.78,28.25,26.75,25.69,23.69,22.34,21.38,20.25,20.28,19.47,18.78,18.62,18.69,19.72,19.97,20.16,19.16,17.56,16.38,14.94,14.03,14.19,15.41,16.88,17.28,17.88,17.5,16.97,15.91,15.12,14.97,14.94,15.97,17.38,18.25,18.94,18.62,19.12,18.34,16.88,15.28,13.44,12.56,11.06,11.16,12.53,14.06,16.0,17.47,18.22,18.22,18.25,18.0,17.47,16.66,15.19,15.28,13.78,14.69,16.53,18.56,21.25,23.12,23.31,23.84,22.81,21.53,20.66,18.59,16.91,15.69,14.62,13.62,13.31,14.09,12.84,11.59,10.12,7.84,6.5,4.69,4.12,3.56,4.91,6.16,7.91,8.34,8.88,7.47,7.31,5.34,4.06,3.16,2.09,1.44,0.97,0.38,0.44,0.25,1.25,1.53,2.25,2.53,3.0,2.91,1.78,1.75,2.0,3.12,4.38,6.78,8.84,9.81,11.06,12.06,11.94,11.0,11.47,11.19,11.69,11.44,10.59,12.0,12.34,13.31,14.44,15.78,16.09,15.66,15.31,16.34,15.94,16.41,17.09,17.56,17.31,17.44,16.72,16.59,15.31,14.12,13.16,11.0,9.31,7.41,6.03,5.19,5.28,4.69,4.75,5.88,6.53,6.56,7.56,7.91,8.19,9.28,10.56,11.25,12.06,12.75,12.06,11.69,10.25,9.06,8.47,8.06,6.31,4.53,3.44,0.5,-1.53,-3.5,-3.41,-2.03,0.12,3.66,6.53,8.5,10.41,10.88,11.38,12.19,12.72,14.31,14.0,14.16,12.78,10.72,8.06,5.88,2.44,0.0,-2.31,-4.22,-4.91,-6.59,-6.09,-6.84,-7.22,-7.91,-9.09,-9.59,-9.66,-9.84,-9.81,-8.12,-6.78,-4.66,-0.84,1.38,3.97,5.91,6.78,6.12,5.81,5.75,5.06,5.34,4.34,3.12,2.16,2.19,1.34,1.0,1.09,0.72,1.41,2.53,4.06,6.44,8.03,8.41,6.94,5.03,1.78,-0.66,-2.69,-3.88,-4.38,-4.44,-4.41,-3.78,-4.91,-4.75,-5.41,-6.19,-6.28,-7.06,-7.09,-6.28,-4.25,-2.78,-2.06,-0.09,0.12,-0.56,-0.72,-1.03,-2.09,-2.84,-3.41,-3.97,-5.44,-5.97,-5.5,-6.59,-7.16,-7.09,-8.19,-8.34,-9.09,-9.0,-8.31,-6.84,-6.03,-5.22,-4.84,-5.34,-6.34,-7.44,-8.12,-10.12,-11.22,-12.62,-13.28,-13.06,-12.53,-12.03,-11.03,-11.69,-11.56,-11.75,-10.97,-9.44,-8.28,-6.53,-5.69,-4.53,-5.09,-6.0,-6.78,-7.69,-8.34,-7.97,-9.03,-8.09,-5.94,-3.91,-1.59,0.12,1.75,0.84,0.47,-0.94,-1.66,-0.81,-0.59,0.66,2.75,4.81,5.75,6.03,5.44,3.41,0.88,-1.53,-4.22,-6.66,-8.22,-8.16,-9.34,-9.0,-8.84,-9.78,-10.03,-10.84,-11.28,-11.78,-12.59,-12.34,-12.25,-11.91,-11.56,-10.75,-9.25,-8.72,-7.47,-6.47,-6.09,-4.72,-4.44,-3.5,-3.06,-1.94,-2.25,-2.09,-2.34,-3.28,-3.53,-3.72,-4.75,-6.03,-7.19,-8.34,-9.59,-9.47,-9.59,-8.59,-7.16,-5.72,-5.78,-5.66,-4.94,-5.28,-5.59,-5.22,-5.28,-4.94,-5.0,-4.84,-5.28,-5.19,-6.44,-6.88,-7.72,-7.41,-7.75,-8.59,-9.59,-10.84,-12.44,-13.88,-14.47,-13.03,-12.59,-12.19,-10.59,-10.03,-10.16,-10.59,-12.47,-12.78,-13.56,-14.97,-14.56,-13.47,-12.59,-12.34,-11.22,-10.81,-9.88,-8.09,-6.16,-2.84,1.09,5.97,9.69,12.31,13.69,11.91,9.5,5.72,1.44,-1.22,-3.94,-4.78,-5.22,-5.41,-5.56,-5.12,-5.19,42.22,42.91,41.38,40.22,38.47,37.41,35.97,34.97,33.84,32.78,32.47,31.47,30.69,30.81,30.31,30.16,30.69,30.75,31.56,31.66,32.56,32.56,32.56,32.38,32.91,30.62,29.38,27.31,26.06,24.62:negativity
37.44,37.56,39.0,40.69,42.44,44.16,44.44,45.94,45.56,45.53,44.41,44.0,42.19,40.81,39.66,38.38,37.78,37.25,36.78,37.06,36.28,36.34,35.59,35.72,35.41,35.16,35.28,36.34,37.44,39.06,39.81,41.53,42.12,43.44,44.38,44.88,44.97,44.75,43.84,43.12,43.16,43.03,42.81,44.19,43.81,44.66,45.28,46.69,46.78,46.97,48.03,47.66,48.16,48.22,49.81,50.72,50.62,49.53,48.5,45.56,42.97,40.91,38.62,36.88,34.5,31.97,28.94,26.38,24.84,23.84,25.06,26.12,27.44,28.94,30.03,29.34,29.03,29.72,30.91,31.5,32.47,34.12,33.97,35.19,36.66,38.38,41.22,42.75,44.75,46.41,45.28,44.94,44.12,41.81,40.28,38.34,38.0,38.69,41.16,43.69,47.03,50.31,51.16,51.19,50.5,48.88,46.06,44.34,42.31,40.66,41.06,41.44,42.34,44.38,45.16,44.88,45.06,44.56,43.59,43.84,45.25,47.16,50.38,53.44,58.16,59.88,61.31,60.53,58.88,56.75,54.62,53.41,52.09,51.84,51.66,51.28,50.81,50.22,48.5,47.25,44.5,40.75,39.97,37.31,36.25,35.5,36.28,37.06,38.31,39.56,41.5,43.78,46.56,48.94,51.31,52.28,52.91,50.91,49.06,46.31,43.44,41.72,39.66,39.88,39.38,41.28,42.12,44.34,46.19,46.94,48.5,49.41,50.66,52.59,55.69,59.09,62.28,64.47,65.91,65.31,63.66,62.34,59.44,58.22,57.0,56.16,55.72,55.06,53.59,52.5,50.34,49.56,48.81,49.53,50.09,50.59,50.31,49.94,49.91,49.06,50.03,51.25,51.81,51.78,50.59,47.47,45.66,43.72,41.75,41.69,40.94,39.97,40.06,38.53,37.69,37.19,37.28,37.31,37.06,37.81,38.59,40.31,40.81,44.34,47.28,51.03,53.84,55.56,55.47,53.94,52.56,50.09,47.69,46.12,44.5,43.06,41.41,40.38,40.38,41.09,42.03,43.22,44.94,45.62,46.84,47.56,48.53,48.59,49.66,50.56,50.78,50.72,50.53,50.16,48.5,47.47,46.47,44.69,43.81,42.19,41.06,40.06,40.03,38.69,36.69,36.47,35.84,34.94,35.03,35.06,33.91,33.12,32.5,32.28,32.38,33.88,34.59,34.75,35.12,34.22,33.75,32.28,31.12,30.16,28.97,27.84,26.81,26.53,25.44,25.56,25.69,25.91,25.66,25.53,25.69,26.28,27.06,28.78,32.0,34.81,37.5,39.56,41.44,42.06,41.75,40.41,39.84,38.0,37.06,35.31,34.69,33.81,33.97,34.59,34.84,34.91,35.25,35.53,35.31,35.78,37.66,39.19,42.91,45.03,47.62,49.16,48.66,47.12,42.69,38.62,34.06,30.75,27.91,27.25,26.88,27.25,28.41,28.22,28.41,28.0,26.84,24.75,24.0,23.25,23.75,23.81,26.06,27.03,28.28,30.69,31.53,32.25,32.94,32.0,30.16,27.62,26.44,26.44,27.06,30.25,33.34,37.81,40.25,43.5,44.41,44.47,43.44,41.94,40.69,39.78,38.62,39.44,40.25,42.38,42.5,43.78,43.84,43.69,43.0,41.0,40.75,39.5,39.16,38.5,39.78,39.38,39.5,38.53,38.06,36.69,35.94,36.03,36.03,37.25,39.31,41.19,43.06,44.31,44.44,44.44,42.69,41.66,40.12,38.31,36.94,35.38,34.62,33.34,33.53,34.12,34.53,34.91,36.16,36.91,37.69,39.03,40.38,41.09,43.72,44.31,45.53,46.41,48.25,48.38,48.19,47.53,44.81,42.91,40.03,38.81,38.41,38.31,38.81,38.94,39.19,38.78,38.31,38.12,37.78,37.53,37.81,37.97,39.28,40.31,42.44,45.69,47.34,48.56,49.81,49.16,48.69,47.62,46.94,46.28,45.12,43.88,42.38,41.31,40.25,40.34,41.25,41.53,41.94,41.28,40.88,40.28,39.56,40.44,41.53,42.94,43.56,43.91,43.44,42.03,38.0,36.47,33.81,32.62,31.78,31.81,31.81,31.47,31.41,31.06,31.59,31.53,32.62,33.5,34.09,33.88,33.91,34.91,35.16,35.78,36.66,37.47,37.06,35.31,32.69,30.59,28.03,26.53,25.25,25.72,25.97,26.03,26.16,26.06,25.31,25.12,25.19,26.59,27.59,29.53,31.38,33.0,33.94,35.69,37.69,39.97,40.91,41.25,41.31,39.81,38.94,37.53,37.31,37.34,37.88,36.84,35.84,35.03,33.69,32.41,32.03,32.03,33.56,34.44,35.66,37.16,39.44,41.78,43.66,45.78,46.88,47.72,46.81,46.38,44.5,43.44,42.53,41.94,41.25,41.5,42.31,42.44,42.84,42.56,42.66,41.75,41.19,39.94,39.69,39.34,39.53,40.53,42.47,44.84,47.53,48.31,49.09,47.69,46.0,43.31,41.16,38.97,37.03,35.66,35.44,34.41,33.88,34.19,32.91,32.91,32.34,32.59,33.06,33.12,34.5,35.44,36.19,38.28,39.56,41.81,43.53,45.44,47.06,45.66,43.25,40.0,36.38,33.47,31.72,31.5,32.5,33.69,35.25,36.62,36.94,36.94,35.41,34.0,32.03,30.69,29.91,29.94,29.28,30.41,30.84,31.19,32.34,31.66,31.75,31.5,30.94,29.97,29.69,29.38,29.5,31.16,32.53,34.34,36.84,37.78,38.53,37.53,37.34,36.66,36.22,36.31,37.0,37.84,38.53,39.06,38.97,38.22,36.69,34.81,33.16,32.47,32.66,33.28,34.94,36.41,37.31,38.81,39.94,40.66,40.28,39.78,38.5,38.25,38.47,39.44,41.72,43.0,44.41,44.94,44.56,44.25,43.16,41.31,39.69,37.28,35.72,34.25,32.53,32.5,32.06,31.69,31.88,31.88,32.31,32.0,30.78,30.75,30.5,30.22,31.62,33.25,33.72,34.62,35.03,33.72,32.0,31.88,32.44,32.88,34.5,35.38,35.69,36.62,35.94,35.66,34.66,34.31,32.72,31.91,30.62,30.44,30.12,32.0,32.44,34.0,35.03,35.78,35.72,33.78,32.16,30.59,27.56,25.16,23.78,22.81,21.34,20.66,20.22,19.56,19.78,21.28,22.88,25.28,27.91,29.47,30.94,31.53,32.12,32.09,32.06,31.75,30.81,29.59,27.66,25.75,22.59,21.38,21.5,22.25,23.16,24.66,26.09,26.5,27.47,27.66,28.66,29.44,29.78,30.44,30.16,29.91,29.78,29.81,29.91,29.66,29.91,28.94,28.03,26.56,25.28,24.94,25.47,25.06,25.69,26.41,26.28,26.38,25.41,24.72,23.75,23.44,22.88,22.78,24.56,26.97,29.62,32.72,35.31,37.06,38.22,37.94,36.34,34.59,33.06,30.88,28.81,27.5,26.03,26.12,26.25,26.84,28.88,31.0,31.62,32.91,32.94,33.28,33.19,32.75,32.78,32.44,32.78,33.78,34.56,37.03,38.44,39.41,39.91,38.91,37.56,36.03,34.34,33.0,31.25,29.84,28.88,27.41,26.0,25.28,25.09,25.62,26.03,27.19,28.81,29.59,30.41,29.66,29.28,28.34,26.78,25.53,24.31,23.69,23.38,23.78,24.88,26.28,30.09,32.03,34.0,34.59,33.19,29.75,27.47,24.78,23.22,23.59,24.34,24.72,25.78,26.19,26.81,27.56,27.16,26.78,26.91,25.81,24.97,23.66,21.88,19.81,18.19,16.06,14.66,14.28,13.5,13.44,13.31,13.34,15.78,18.0,20.5,23.84,26.81,29.38,31.19,32.72,33.19,33.28,31.94,30.91,28.16,26.44,26.0,26.03,26.56,27.66:44.44,45.94,45.56,45.53,44.41,44.0,42.19,40.81,39.66,38.38,37.78,37.25,36.78,37.06,36.28,36.34,35.59,35.72,35.41,35.16,35.28,36.34,37.44,39.06,39.81,41.53,42.12,43.44,44.38,44.88,44.97,44.75,43.84,43.12,43.16,43.03,42.81,44.19,43.81,44.66,45.28,46.69,46.78,46.97,48.03,47.66,48.16,48.22,49.81,50.72,50.62,49.53,48.5,45.56,42.97,40.91,38.62,36.88,34.5,31.97,28.94,26.38,24.84,23.84,25.06,26.12,27.44,28.94,30.03,29.34,29.03,29.72,30.91,31.5,32.47,34.12,33.97,35.19,36.66,38.38,41.22,42.75,44.75,46.41,45.28,44.94,44.12,41.81,40.28,38.34,38.0,38.69,41.16,43.69,47.03,50.31,51.16,51.19,50.5,48.88,46.06,44.34,42.31,40.66,41.06,41.44,42.34,44.38,45.16,44.88,45.06,44.56,43.59,43.84,45.25,47.16,50.38,53.44,58.16,59.88,61.31,60.53,58.88,56.75,54.62,53.41,52.09,51.84,51.66,51.28,50.81,50.22,48.5,47.25,44.5,40.75,39.97,37.31,36.25,35.5,36.28,37.06,38.31,39.56,41.5,43.78,46.56,48.94,51.31,52.28,52.91,50.91,49.06,46.31,43.44,41.72,39.66,39.88,39.38,41.28,42.12,44.34,46.19,46.94,48.5,49.41,50.66,52.59,55.69,59.09,62.28,64.47,65.91,65.31,63.66,62.34,59.44,58.22,57.0,56.16,55.72,55.06,53.59,52.5,50.34,49.56,48.81,49.53,50.09,50.59,50.31,49.94,49.91,49.06,50.03,51.25,51.81,51.78,50.59,47.47,45.66,43.72,41.75,41.69,40.94,39.97,40.06,38.53,37.69,37.19,37.28,37.31,37.06,37.81,38.59,40.31,40.81,44.34,47.28,51.03,53.84,55.56,55.47,53.94,52.56,50.09,47.69,46.12,44.5,43.06,41.41,40.38,40.38,41.09,42.03,43.22,44.94,45.62,46.84,47.56,48.53,48.59,49.66,50.56,50.78,50.72,50.53,50.16,48.5,47.47,46.47,44.69,43.81,42.19,41.06,40.06,40.03,38.69,36.69,36.47,35.84,34.94,35.03,35.06,33.91,33.12,32.5,32.28,32.38,33.88,34.59,34.75,35.12,34.22,33.75,32.28,31.12,30.16,28.97,27.84,26.81,26.53,25.44,25.56,25.69,25.91,25.66,25.53,25.69,26.28,27.06,28.78,32.0,34.81,37.5,39.56,41.44,42.06,41.75,40.41,39.84,38.0,37.06,35.31,34.69,33.81,33.97,34.59,34.84,34.91,35.25,35.53,35.31,35.78,37.66,39.19,42.91,45.03,47.62,49.16,48.66,47.12,42.69,38.62,34.06,30.75,27.91,27.25,26.88,27.25,28.41,28.22,28.41,28.0,26.84,24.75,24.0,23.25,23.75,23.81,26.06,27.03,28.28,30.69,31.53,32.25,32.94,32.0,30.16,27.62,26.44,26.44,27.06,30.25,33.34,37.81,40.25,43.5,44.41,44.47,43.44,41.94,40.69,39.78,38.62,39.44,40.25,42.38,42.5,43.78,43.84,43.69,43.0,41.0,40.75,39.5,39.16,38.5,39.78,39.38,39.5,38.53,38.06,36.69,35.94,36.03,36.03,37.25,39.31,41.19,43.06,44.31,44.44,44.44,42.69,41.66,40.12,38.31,36.94,35.38,34.62,33.34,33.53,34.12,34.53,34.91,36.16,36.91,37.69,39.03,40.38,41.09,43.72,44.31,45.53,46.41,48.25,48.38,48.19,47.53,44.81,42.91,40.03,38.81,38.41,38.31,38.81,38.94,39.19,38.78,38.31,38.12,37.78,37.53,37.81,37.97,39.28,40.31,42.44,45.69,47.34,48.56,49.81,49.16,48.69,47.62,46.94,46.28,45.12,43.88,42.38,41.31,40.25,40.34,41.25,41.53,41.94,41.28,40.88,40.28,39.56,40.44,41.53,42.94,43.56,43.91,43.44,42.03,38.0,36.47,33.81,32.62,31.78,31.81,31.81,31.47,31.41,31.06,31.59,31.53,32.62,33.5,34.09,33.88,33.91,34.91,35.16,35.78,36.66,37.47,37.06,35.31,32.69,30.59,28.03,26.53,25.25,25.72,25.97,26.03,26.16,26.06,25.31,25.12,25.19,26.59,27.59,29.53,31.38,33.0,33.94,35.69,37.69,39.97,40.91,41.25,41.31,39.81,38.94,37.53,37.31,37.34,37.88,36.84,35.84,35.03,33.69,32.41,32.03,32.03,33.56,34.44,35.66,37.16,39.44,41.78,43.66,45.78,46.88,47.72,46.81,46.38,44.5,43.44,42.53,41.94,41.25,41.5,42.31,42.44,42.84,42.56,42.66,41.75,41.19,39.94,39.69,39.34,39.53,40.53,42.47,44.84,47.53,48.31,49.09,47.69,46.0,43.31,41.16,38.97,37.03,35.66,35.44,34.41,33.88,34.19,32.91,32.91,32.34,32.59,33.06,33.12,34.5,35.44,36.19,38.28,39.56,41.81,43.53,45.44,47.06,45.66,43.25,40.0,36.38,33.47,31.72,31.5,32.5,33.69,35.25,36.62,36.94,36.94,35.41,34.0,32.03,30.69,29.91,29.94,29.28,30.41,30.84,31.19,32.34,31.66,31.75,31.5,30.94,29.97,29.69,29.38,29.5,31.16,32.53,34.34,36.84,37.78,38.53,37.53,37.34,36.66,36.22,36.31,37.0,37.84,38.53,39.06,38.97,38.22,36.69,34.81,33.16,32.47,32.66,33.28,34.94,36.41,37.31,38.81,39.94,40.66,40.28,39.78,38.5,38.25,38.47,39.44,41.72,43.0,44.41,44.94,44.56,44.25,43.16,41.31,39.69,37.28,35.72,34.25,32.53,32.5,32.06,31.69,31.88,31.88,32.31,32.0,30.78,30.75,30.5,30.22,31.62,33.25,33.72,34.62,35.03,33.72,32.0,31.88,32.44,32.88,34.5,35.38,35.69,36.62,35.94,35.66,34.66,34.31,32.72,31.91,30.62,30.44,30.12,32.0,32.44,34.0,35.03,35.78,35.72,33.78,32.16,30.59,27.56,25.16,23.78,22.81,21.34,20.66,20.22,19.56,19.78,21.28,22.88,25.28,27.91,29.47,30.94,31.53,32.12,32.09,32.06,31.75,30.81,29.59,27.66,25.75,22.59,21.38,21.5,22.25,23.16,24.66,26.09,26.5,27.47,27.66,28.66,29.44,29.78,30.44,30.16,29.91,29.78,29.81,29.91,29.66,29.91,28.94,28.03,26.56,25.28,24.94,25.47,25.06,25.69,26.41,26.28,26.38,25.41,24.72,23.75,23.44,22.88,22.78,24.56,26.97,29.62,32.72,35.31,37.06,38.22,37.94,36.34,34.59,33.06,30.88,28.81,27.5,26.03,26.12,26.25,26.84,28.88,31.0,31.62,32.91,32.94,33.28,33.19,32.75,32.78,32.44,32.78,33.78,34.56,37.03,38.44,39.41,39.91,38.91,37.56,36.03,34.34,33.0,31.25,29.84,28.88,27.41,26.0,25.28,25.09,25.62,26.03,27.19,28.81,29.59,30.41,29.66,29.28,28.34,26.78,25.53,24.31,23.69,23.38,23.78,24.88,26.28,30.09,32.03,34.0,34.59,33.19,29.75,27.47,24.78,23.22,23.59,24.34,24.72,25.78,26.19,26.81,27.56,27.16,26.78,26.91,25.81,24.97,23.66,21.88,19.81,18.19,16.06,14.66,14.28,13.5,13.44,13.31,13.34,15.78,18.0,20.5,23.84,26.81,29.38,31.19,32.72,33.19,33.28,31.94,30.91,28.16,26.44,26.0,26.03,26.56,27.66,31.97,31.69,33.25,34.69,37.12,38.56:42.19,40.81,39.66,38.38,37.78,37.25,36.78,37.06,36.28,36.34,35.59,35.72,35.41,35.16,35.28,36.34,37.44,39.06,39.81,41.53,42.12,43.44,44.38,44.88,44.97,44.75,43.84,43.12,43.16,43.03,42.81,44.19,43.81,44.66,45.28,46.69,46.78,46.97,48.03,47.66,48.16,48.22,49.81,50.72,50.62,49.53,48.5,45.56,42.97,40.91,38.62,36.88,34.5,31.97,28.94,26.38,24.84,23.84,25.06,26.12,27.44,28.94,30.03,29.34,29.03,29.72,30.91,31.5,32.47,34.12,33.97,35.19,36.66,38.38,41.22,42.75,44.75,46.41,45.28,44.94,44.12,41.81,40.28,38.34,38.0,38.69,41.16,43.69,47.03,50.31,51.16,51.19,50.5,48.88,46.06,44.34,42.31,40.66,41.06,41.44,42.34,44.38,45.16,44.88,45.06,44.56,43.59,43.84,45.25,47.16,50.38,53.44,58.16,59.88,61.31,60.53,58.88,56.75,54.62,53.41,52.09,51.84,51.66,51.28,50.81,50.22,48.5,47.25,44.5,40.75,39.97,37.31,36.25,35.5,36.28,37.06,38.31,39.56,41.5,43.78,46.56,48.94,51.31,52.28,52.91,50.91,49.06,46.31,43.44,41.72,39.66,39.88,39.38,41.28,42.12,44.34,46.19,46.94,48.5,49.41,50.66,52.59,55.69,59.09,62.28,64.47,65.91,65.31,63.66,62.34,59.44,58.22,57.0,56.16,55.72,55.06,53.59,52.5,50.34,49.56,48.81,49.53,50.09,50.59,50.31,49.94,49.91,49.06,50.03,51.25,51.81,51.78,50.59,47.47,45.66,43.72,41.75,41.69,40.94,39.97,40.06,38.53,37.69,37.19,37.28,37.31,37.06,37.81,38.59,40.31,40.81,44.34,47.28,51.03,53.84,55.56,55.47,53.94,52.56,50.09,47.69,46.12,44.5,43.06,41.41,40.38,40.38,41.09,42.03,43.22,44.94,45.62,46.84,47.56,48.53,48.59,49.66,50.56,50.78,50.72,50.53,50.16,48.5,47.47,46.47,44.69,43.81,42.19,41.06,40.06,40.03,38.69,36.69,36.47,35.84,34.94,35.03,35.06,33.91,33.12,32.5,32.28,32.38,33.88,34.59,34.75,35.12,34.22,33.75,32.28,31.12,30.16,28.97,27.84,26.81,26.53,25.44,25.56,25.69,25.91,25.66,25.53,25.69,26.28,27.06,28.78,32.0,34.81,37.5,39.56,41.44,42.06,41.75,40.41,39.84,38.0,37.06,35.31,34.69,33.81,33.97,34.59,34.84,34.91,35.25,35.53,35.31,35.78,37.66,39.19,42.91,45.03,47.62,49.16,48.66,47.12,42.69,38.62,34.06,30.75,27.91,27.25,26.88,27.25,28.41,28.22,28.41,28.0,26.84,24.75,24.0,23.25,23.75,23.81,26.06,27.03,28.28,30.69,31.53,32.25,32.94,32.0,30.16,27.62,26.44,26.44,27.06,30.25,33.34,37.81,40.25,43.5,44.41,44.47,43.44,41.94,40.69,39.78,38.62,39.44,40.25,42.38,42.5,43.78,43.84,43.69,43.0,41.0,40.75,39.5,39.16,38.5,39.78,39.38,39.5,38.53,38.06,36.69,35.94,36.03,36.03,37.25,39.31,41.19,43.06,44.31,44.44,44.44,42.69,41.66,40.12,38.31,36.94,35.38,34.62,33.34,33.53,34.12,34.53,34.91,36.16,36.91,37.69,39.03,40.38,41.09,43.72,44.31,45.53,46.41,48.25,48.38,48.19,47.53,44.81,42.91,40.03,38.81,38.41,38.31,38.81,38.94,39.19,38.78,38.31,38.12,37.78,37.53,37.81,37.97,39.28,40.31,42.44,45.69,47.34,48.56,49.81,49.16,48.69,47.62,46.94,46.28,45.12,43.88,42.38,41.31,40.25,40.34,41.25,41.53,41.94,41.28,40.88,40.28,39.56,40.44,41.53,42.94,43.56,43.91,43.44,42.03,38.0,36.47,33.81,32.62,31.78,31.81,31.81,31.47,31.41,31.06,31.59,31.53,32.62,33.5,34.09,33.88,33.91,34.91,35.16,35.78,36.66,37.47,37.06,35.31,32.69,30.59,28.03,26.53,25.25,25.72,25.97,26.03,26.16,26.06,25.31,25.12,25.19,26.59,27.59,29.53,31.38,33.0,33.94,35.69,37.69,39.97,40.91,41.25,41.31,39.81,38.94,37.53,37.31,37.34,37.88,36.84,35.84,35.03,33.69,32.41,32.03,32.03,33.56,34.44,35.66,37.16,39.44,41.78,43.66,45.78,46.88,47.72,46.81,46.38,44.5,43.44,42.53,41.94,41.25,41.5,42.31,42.44,42.84,42.56,42.66,41.75,41.19,39.94,39.69,39.34,39.53,40.53,42.47,44.84,47.53,48.31,49.09,47.69,46.0,43.31,41.16,38.97,37.03,35.66,35.44,34.41,33.88,34.19,32.91,32.91,32.34,32.59,33.06,33.12,34.5,35.44,36.19,38.28,39.56,41.81,43.53,45.44,47.06,45.66,43.25,40.0,36.38,33.47,31.72,31.5,32.5,33.69,35.25,36.62,36.94,36.94,35.41,34.0,32.03,30.69,29.91,29.94,29.28,30.41,30.84,31.19,32.34,31.66,31.75,31.5,30.94,29.97,29.69,29.38,29.5,31.16,32.53,34.34,36.84,37.78,38.53,37.53,37.34,36.66,36.22,36.31,37.0,37.84,38.53,39.06,38.97,38.22,36.69,34.81,33.16,32.47,32.66,33.28,34.94,36.41,37.31,38.81,39.94,40.66,40.28,39.78,38.5,38.25,38.47,39.44,41.72,43.0,44.41,44.94,44.56,44.25,43.16,41.31,39.69,37.28,35.72,34.25,32.53,32.5,32.06,31.69,31.88,31.88,32.31,32.0,30.78,30.75,30.5,30.22,31.62,33.25,33.72,34.62,35.03,33.72,32.0,31.88,32.44,32.88,34.5,35.38,35.69,36.62,35.94,35.66,34.66,34.31,32.72,31.91,30.62,30.44,30.12,32.0,32.44,34.0,35.03,35.78,35.72,33.78,32.16,30.59,27.56,25.16,23.78,22.81,21.34,20.66,20.22,19.56,19.78,21.28,22.88,25.28,27.91,29.47,30.94,31.53,32.12,32.09,32.06,31.75,30.81,29.59,27.66,25.75,22.59,21.38,21.5,22.25,23.16,24.66,26.09,26.5,27.47,27.66,28.66,29.44,29.78,30.44,30.16,29.91,29.78,29.81,29.91,29.66,29.91,28.94,28.03,26.56,25.28,24.94,25.47,25.06,25.69,26.41,26.28,26.38,25.41,24.72,23.75,23.44,22.88,22.78,24.56,26.97,29.62,32.72,35.31,37.06,38.22,37.94,36.34,34.59,33.06,30.88,28.81,27.5,26.03,26.12,26.25,26.84,28.88,31.0,31.62,32.91,32.94,33.28,33.19,32.75,32.78,32.44,32.78,33.78,34.56,37.03,38.44,39.41,39.91,38.91,37.56,36.03,34.34,33.0,31.25,29.84,28.88,27.41,26.0,25.28,25.09,25.62,26.03,27.19,28.81,29.59,30.41,29.66,29.28,28.34,26.78,25.53,24.31,23.69,23.38,23.78,24.88,26.28,30.09,32.03,34.0,34.59,33.19,29.75,27.47,24.78,23.22,23.59,24.34,24.72,25.78,26.19,26.81,27.56,27.16,26.78,26.91,25.81,24.97,23.66,21.88,19.81,18.19,16.06,14.66,14.28,13.5,13.44,13.31,13.34,15.78,18.0,20.5,23.84,26.81,29.38,31.19,32.72,33.19,33.28,31.94,30.91,28.16,26.44,26.0,26.03,26.56,27.66,31.97,31.69,33.25,34.69,37.12,38.56,39.16,40.66,39.53,38.53,37.19,36.12:36.78,37.06,36.28,36.34,35.59,35.72,35.41,35.16,35.28,36.34,37.44,39.06,39.81,41.53,42.12,43.44,44.38,44.88,44.97,44.75,43.84,43.12,43.16,43.03,42.81,44.19,43.81,44.66,45.28,46.69,46.78,46.97,48.03,47.66,48.16,48.22,49.81,50.72,50.62,49.53,48.5,45.56,42.97,40.91,38.62,36.88,34.5,31.97,28.94,26.38,24.84,23.84,25.06,26.12,27.44,28.94,30.03,29.34,29.03,29.72,30.91,31.5,32.47,34.12,33.97,35.19,36.66,38.38,41.22,42.75,44.75,46.41,45.28,44.94,44.12,41.81,40.28,38.34,38.0,38.69,41.16,43.69,47.03,50.31,51.16,51.19,50.5,48.88,46.06,44.34,42.31,40.66,41.06,41.44,42.34,44.38,45.16,44.88,45.06,44.56,43.59,43.84,45.25,47.16,50.38,53.44,58.16,59.88,61.31,60.53,58.88,56.75,54.62,53.41,52.09,51.84,51.66,51.28,50.81,50.22,48.5,47.25,44.5,40.75,39.97,37.31,36.25,35.5,36.28,37.06,38.31,39.56,41.5,43.78,46.56,48.94,51.31,52.28,52.91,50.91,49.06,46.31,43.44,41.72,39.66,39.88,39.38,41.28,42.12,44.34,46.19,46.94,48.5,49.41,50.66,52.59,55.69,59.09,62.28,64.47,65.91,65.31,63.66,62.34,59.44,58.22,57.0,56.16,55.72,55.06,53.59,52.5,50.34,49.56,48.81,49.53,50.09,50.59,50.31,49.94,49.91,49.06,50.03,51.25,51.81,51.78,50.59,47.47,45.66,43.72,41.75,41.69,40.94,39.97,40.06,38.53,37.69,37.19,37.28,37.31,37.06,37.81,38.59,40.31,40.81,44.34,47.28,51.03,53.84,55.56,55.47,53.94,52.56,50.09,47.69,46.12,44.5,43.06,41.41,40.38,40.38,41.09,42.03,43.22,44.94,45.62,46.84,47.56,48.53,48.59,49.66,50.56,50.78,50.72,50.53,50.16,48.5,47.47,46.47,44.69,43.81,42.19,41.06,40.06,40.03,38.69,36.69,36.47,35.84,34.94,35.03,35.06,33.91,33.12,32.5,32.28,32.38,33.88,34.59,34.75,35.12,34.22,33.75,32.28,31.12,30.16,28.97,27.84,26.81,26.53,25.44,25.56,25.69,25.91,25.66,25.53,25.69,26.28,27.06,28.78,32.0,34.81,37.5,39.56,41.44,42.06,41.75,40.41,39.84,38.0,37.06,35.31,34.69,33.81,33.97,34.59,34.84,34.91,35.25,35.53,35.31,35.78,37.66,39.19,42.91,45.03,47.62,49.16,48.66,47.12,42.69,38.62,34.06,30.75,27.91,27.25,26.88,27.25,28.41,28.22,28.41,28.0,26.84,24.75,24.0,23.25,23.75,23.81,26.06,27.03,28.28,30.69,31.53,32.25,32.94,32.0,30.16,27.62,26.44,26.44,27.06,30.25,33.34,37.81,40.25,43.5,44.41,44.47,43.44,41.94,40.69,39.78,38.62,39.44,40.25,42.38,42.5,43.78,43.84,43.69,43.0,41.0,40.75,39.5,39.16,38.5,39.78,39.38,39.5,38.53,38.06,36.69,35.94,36.03,36.03,37.25,39.31,41.19,43.06,44.31,44.44,44.44,42.69,41.66,40.12,38.31,36.94,35.38,34.62,33.34,33.53,34.12,34.53,34.91,36.16,36.91,37.69,39.03,40.38,41.09,43.72,44.31,45.53,46.41,48.25,48.38,48.19,47.53,44.81,42.91,40.03,38.81,38.41,38.31,38.81,38.94,39.19,38.78,38.31,38.12,37.78,37.53,37.81,37.97,39.28,40.31,42.44,45.69,47.34,48.56,49.81,49.16,48.69,47.62,46.94,46.28,45.12,43.88,42.38,41.31,40.25,40.34,41.25,41.53,41.94,41.28,40.88,40.28,39.56,40.44,41.53,42.94,43.56,43.91,43.44,42.03,38.0,36.47,33.81,32.62,31.78,31.81,31.81,31.47,31.41,31.06,31.59,31.53,32.62,33.5,34.09,33.88,33.91,34.91,35.16,35.78,36.66,37.47,37.06,35.31,32.69,30.59,28.03,26.53,25.25,25.72,25.97,26.03,26.16,26.06,25.31,25.12,25.19,26.59,27.59,29.53,31.38,33.0,33.94,35.69,37.69,39.97,40.91,41.25,41.31,39.81,38.94,37.53,37.31,37.34,37.88,36.84,35.84,35.03,33.69,32.41,32.03,32.03,33.56,34.44,35.66,37.16,39.44,41.78,43.66,45.78,46.88,47.72,46.81,46.38,44.5,43.44,42.53,41.94,41.25,41.5,42.31,42.44,42.84,42.56,42.66,41.75,41.19,39.94,39.69,39.34,39.53,40.53,42.47,44.84,47.53,48.31,49.09,47.69,46.0,43.31,41.16,38.97,37.03,35.66,35.44,34.41,33.88,34.19,32.91,32.91,32.34,32.59,33.06,33.12,34.5,35.44,36.19,38.28,39.56,41.81,43.53,45.44,47.06,45.66,43.25,40.0,36.38,33.47,31.72,31.5,32.5,33.69,35.25,36.62,36.94,36.94,35.41,34.0,32.03,30.69,29.91,29.94,29.28,30.41,30.84,31.19,32.34,31.66,31.75,31.5,30.94,29.97,29.69,29.38,29.5,31.16,32.53,34.34,36.84,37.78,38.53,37.53,37.34,36.66,36.22,36.31,37.0,37.84,38.53,39.06,38.97,38.22,36.69,34.81,33.16,32.47,32.66,33.28,34.94,36.41,37.31,38.81,39.94,40.66,40.28,39.78,38.5,38.25,38.47,39.44,41.72,43.0,44.41,44.94,44.56,44.25,43.16,41.31,39.69,37.28,35.72,34.25,32.53,32.5,32.06,31.69,31.88,31.88,32.31,32.0,30.78,30.75,30.5,30.22,31.62,33.25,33.72,34.62,35.03,33.72,32.0,31.88,32.44,32.88,34.5,35.38,35.69,36.62,35.94,35.66,34.66,34.31,32.72,31.91,30.62,30.44,30.12,32.0,32.44,34.0,35.03,35.78,35.72,33.78,32.16,30.59,27.56,25.16,23.78,22.81,21.34,20.66,20.22,19.56,19.78,21.28,22.88,25.28,27.91,29.47,30.94,31.53,32.12,32.09,32.06,31.75,30.81,29.59,27.66,25.75,22.59,21.38,21.5,22.25,23.16,24.66,26.09,26.5,27.47,27.66,28.66,29.44,29.78,30.44,30.16,29.91,29.78,29.81,29.91,29.66,29.91,28.94,28.03,26.56,25.28,24.94,25.47,25.06,25.69,26.41,26.28,26.38,25.41,24.72,23.75,23.44,22.88,22.78,24.56,26.97,29.62,32.72,35.31,37.06,38.22,37.94,36.34,34.59,33.06,30.88,28.81,27.5,26.03,26.12,26.25,26.84,28.88,31.0,31.62,32.91,32.94,33.28,33.19,32.75,32.78,32.44,32.78,33.78,34.56,37.03,38.44,39.41,39.91,38.91,37.56,36.03,34.34,33.0,31.25,29.84,28.88,27.41,26.0,25.28,25.09,25.62,26.03,27.19,28.81,29.59,30.41,29.66,29.28,28.34,26.78,25.53,24.31,23.69,23.38,23.78,24.88,26.28,30.09,32.03,34.0,34.59,33.19,29.75,27.47,24.78,23.22,23.59,24.34,24.72,25.78,26.19,26.81,27.56,27.16,26.78,26.91,25.81,24.97,23.66,21.88,19.81,18.19,16.06,14.66,14.28,13.5,13.44,13.31,13.34,15.78,18.0,20.5,23.84,26.81,29.38,31.19,32.72,33.19,33.28,31.94,30.91,28.16,26.44,26.0,26.03,26.56,27.66,31.97,31.69,33.25,34.69,37.12,38.56,39.16,40.66,39.53,38.53,37.19,36.12,34.12,33.31,32.94,31.97,32.47,32.03:35.41,35.16,35.28,36.34,37.44,39.06,39.81,41.53,42.12,43.44,44.38,44.88,44.97,44.75,43.84,43.12,43.16,43.03,42.81,44.19,43.81,44.66,45.28,46.69,46.78,46.97,48.03,47.66,48.16,48.22,49.81,50.72,50.62,49.53,48.5,45.56,42.97,40.91,38.62,36.88,34.5,31.97,28.94,26.38,24.84,23.84,25.06,26.12,27.44,28.94,30.03,29.34,29.03,29.72,30.91,31.5,32.47,34.12,33.97,35.19,36.66,38.38,41.22,42.75,44.75,46.41,45.28,44.94,44.12,41.81,40.28,38.34,38.0,38.69,41.16,43.69,47.03,50.31,51.16,51.19,50.5,48.88,46.06,44.34,42.31,40.66,41.06,41.44,42.34,44.38,45.16,44.88,45.06,44.56,43.59,43.84,45.25,47.16,50.38,53.44,58.16,59.88,61.31,60.53,58.88,56.75,54.62,53.41,52.09,51.84,51.66,51.28,50.81,50.22,48.5,47.25,44.5,40.75,39.97,37.31,36.25,35.5,36.28,37.06,38.31,39.56,41.5,43.78,46.56,48.94,51.31,52.28,52.91,50.91,49.06,46.31,43.44,41.72,39.66,39.88,39.38,41.28,42.12,44.34,46.19,46.94,48.5,49.41,50.66,52.59,55.69,59.09,62.28,64.47,65.91,65.31,63.66,62.34,59.44,58.22,57.0,56.16,55.72,55.06,53.59,52.5,50.34,49.56,48.81,49.53,50.09,50.59,50.31,49.94,49.91,49.06,50.03,51.25,51.81,51.78,50.59,47.47,45.66,43.72,41.75,41.69,40.94,39.97,40.06,38.53,37.69,37.19,37.28,37.31,37.06,37.81,38.59,40.31,40.81,44.34,47.28,51.03,53.84,55.56,55.47,53.94,52.56,50.09,47.69,46.12,44.5,43.06,41.41,40.38,40.38,41.09,42.03,43.22,44.94,45.62,46.84,47.56,48.53,48.59,49.66,50.56,50.78,50.72,50.53,50.16,48.5,47.47,46.47,44.69,43.81,42.19,41.06,40.06,40.03,38.69,36.69,36.47,35.84,34.94,35.03,35.06,33.91,33.12,32.5,32.28,32.38,33.88,34.59,34.75,35.12,34.22,33.75,32.28,31.12,30.16,28.97,27.84,26.81,26.53,25.44,25.56,25.69,25.91,25.66,25.53,25.69,26.28,27.06,28.78,32.0,34.81,37.5,39.56,41.44,42.06,41.75,40.41,39.84,38.0,37.06,35.31,34.69,33.81,33.97,34.59,34.84,34.91,35.25,35.53,35.31,35.78,37.66,39.19,42.91,45.03,47.62,49.16,48.66,47.12,42.69,38.62,34.06,30.75,27.91,27.25,26.88,27.25,28.41,28.22,28.41,28.0,26.84,24.75,24.0,23.25,23.75,23.81,26.06,27.03,28.28,30.69,31.53,32.25,32.94,32.0,30.16,27.62,26.44,26.44,27.06,30.25,33.34,37.81,40.25,43.5,44.41,44.47,43.44,41.94,40.69,39.78,38.62,39.44,40.25,42.38,42.5,43.78,43.84,43.69,43.0,41.0,40.75,39.5,39.16,38.5,39.78,39.38,39.5,38.53,38.06,36.69,35.94,36.03,36.03,37.25,39.31,41.19,43.06,44.31,44.44,44.44,42.69,41.66,40.12,38.31,36.94,35.38,34.62,33.34,33.53,34.12,34.53,34.91,36.16,36.91,37.69,39.03,40.38,41.09,43.72,44.31,45.53,46.41,48.25,48.38,48.19,47.53,44.81,42.91,40.03,38.81,38.41,38.31,38.81,38.94,39.19,38.78,38.31,38.12,37.78,37.53,37.81,37.97,39.28,40.31,42.44,45.69,47.34,48.56,49.81,49.16,48.69,47.62,46.94,46.28,45.12,43.88,42.38,41.31,40.25,40.34,41.25,41.53,41.94,41.28,40.88,40.28,39.56,40.44,41.53,42.94,43.56,43.91,43.44,42.03,38.0,36.47,33.81,32.62,31.78,31.81,31.81,31.47,31.41,31.06,31.59,31.53,32.62,33.5,34.09,33.88,33.91,34.91,35.16,35.78,36.66,37.47,37.06,35.31,32.69,30.59,28.03,26.53,25.25,25.72,25.97,26.03,26.16,26.06,25.31,25.12,25.19,26.59,27.59,29.53,31.38,33.0,33.94,35.69,37.69,39.97,40.91,41.25,41.31,39.81,38.94,37.53,37.31,37.34,37.88,36.84,35.84,35.03,33.69,32.41,32.03,32.03,33.56,34.44,35.66,37.16,39.44,41.78,43.66,45.78,46.88,47.72,46.81,46.38,44.5,43.44,42.53,41.94,41.25,41.5,42.31,42.44,42.84,42.56,42.66,41.75,41.19,39.94,39.69,39.34,39.53,40.53,42.47,44.84,47.53,48.31,49.09,47.69,46.0,43.31,41.16,38.97,37.03,35.66,35.44,34.41,33.88,34.19,32.91,32.91,32.34,32.59,33.06,33.12,34.5,35.44,36.19,38.28,39.56,41.81,43.53,45.44,47.06,45.66,43.25,40.0,36.38,33.47,31.72,31.5,32.5,33.69,35.25,36.62,36.94,36.94,35.41,34.0,32.03,30.69,29.91,29.94,29.28,30.41,30.84,31.19,32.34,31.66,31.75,31.5,30.94,29.97,29.69,29.38,29.5,31.16,32.53,34.34,36.84,37.78,38.53,37.53,37.34,36.66,36.22,36.31,37.0,37.84,38.53,39.06,38.97,38.22,36.69,34.81,33.16,32.47,32.66,33.28,34.94,36.41,37.31,38.81,39.94,40.66,40.28,39.78,38.5,38.25,38.47,39.44,41.72,43.0,44.41,44.94,44.56,44.25,43.16,41.31,39.69,37.28,35.72,34.25,32.53,32.5,32.06,31.69,31.88,31.88,32.31,32.0,30.78,30.75,30.5,30.22,31.62,33.25,33.72,34.62,35.03,33.72,32.0,31.88,32.44,32.88,34.5,35.38,35.69,36.62,35.94,35.66,34.66,34.31,32.72,31.91,30.62,30.44,30.12,32.0,32.44,34.0,35.03,35.78,35.72,33.78,32.16,30.59,27.56,25.16,23.78,22.81,21.34,20.66,20.22,19.56,19.78,21.28,22.88,25.28,27.91,29.47,30.94,31.53,32.12,32.09,32.06,31.75,30.81,29.59,27.66,25.75,22.59,21.38,21.5,22.25,23.16,24.66,26.09,26.5,27.47,27.66,28.66,29.44,29.78,30.44,30.16,29.91,29.78,29.81,29.91,29.66,29.91,28.94,28.03,26.56,25.28,24.94,25.47,25.06,25.69,26.41,26.28,26.38,25.41,24.72,23.75,23.44,22.88,22.78,24.56,26.97,29.62,32.72,35.31,37.06,38.22,37.94,36.34,34.59,33.06,30.88,28.81,27.5,26.03,26.12,26.25,26.84,28.88,31.0,31.62,32.91,32.94,33.28,33.19,32.75,32.78,32.44,32.78,33.78,34.56,37.03,38.44,39.41,39.91,38.91,37.56,36.03,34.34,33.0,31.25,29.84,28.88,27.41,26.0,25.28,25.09,25.62,26.03,27.19,28.81,29.59,30.41,29.66,29.28,28.34,26.78,25.53,24.31,23.69,23.38,23.78,24.88,26.28,30.09,32.03,34.0,34.59,33.19,29.75,27.47,24.78,23.22,23.59,24.34,24.72,25.78,26.19,26.81,27.56,27.16,26.78,26.91,25.81,24.97,23.66,21.88,19.81,18.19,16.06,14.66,14.28,13.5,13.44,13.31,13.34,15.78,18.0,20.5,23.84,26.81,29.38,31.19,32.72,33.19,33.28,31.94,30.91,28.16,26.44,26.0,26.03,26.56,27.66,31.97,31.69,33.25,34.69,37.12,38.56,39.16,40.66,39.53,38.53,37.19,36.12,34.12,33.31,32.94,31.97,32.47,32.03,31.44,31.12,30.5,30.25,29.75,30.19:39.81,41.53,42.12,43.44,44.38,44.88,44.97,44.75,43.84,43.12,43.16,43.03,42.81,44.19,43.81,44.66,45.28,46.69,46.78,46.97,48.03,47.66,48.16,48.22,49.81,50.72,50.62,49.53,48.5,45.56,42.97,40.91,38.62,36.88,34.5,31.97,28.94,26.38,24.84,23.84,25.06,26.12,27.44,28.94,30.03,29.34,29.03,29.72,30.91,31.5,32.47,34.12,33.97,35.19,36.66,38.38,41.22,42.75,44.75,46.41,45.28,44.94,44.12,41.81,40.28,38.34,38.0,38.69,41.16,43.69,47.03,50.31,51.16,51.19,50.5,48.88,46.06,44.34,42.31,40.66,41.06,41.44,42.34,44.38,45.16,44.88,45.06,44.56,43.59,43.84,45.25,47.16,50.38,53.44,58.16,59.88,61.31,60.53,58.88,56.75,54.62,53.41,52.09,51.84,51.66,51.28,50.81,50.22,48.5,47.25,44.5,40.75,39.97,37.31,36.25,35.5,36.28,37.06,38.31,39.56,41.5,43.78,46.56,48.94,51.31,52.28,52.91,50.91,49.06,46.31,43.44,41.72,39.66,39.88,39.38,41.28,42.12,44.34,46.19,46.94,48.5,49.41,50.66,52.59,55.69,59.09,62.28,64.47,65.91,65.31,63.66,62.34,59.44,58.22,57.0,56.16,55.72,55.06,53.59,52.5,50.34,49.56,48.81,49.53,50.09,50.59,50.31,49.94,49.91,49.06,50.03,51.25,51.81,51.78,50.59,47.47,45.66,43.72,41.75,41.69,40.94,39.97,40.06,38.53,37.69,37.19,37.28,37.31,37.06,37.81,38.59,40.31,40.81,44.34,47.28,51.03,53.84,55.56,55.47,53.94,52.56,50.09,47.69,46.12,44.5,43.06,41.41,40.38,40.38,41.09,42.03,43.22,44.94,45.62,46.84,47.56,48.53,48.59,49.66,50.56,50.78,50.72,50.53,50.16,48.5,47.47,46.47,44.69,43.81,42.19,41.06,40.06,40.03,38.69,36.69,36.47,35.84,34.94,35.03,35.06,33.91,33.12,32.5,32.28,32.38,33.88,34.59,34.75,35.12,34.22,33.75,32.28,31.12,30.16,28.97,27.84,26.81,26.53,25.44,25.56,25.69,25.91,25.66,25.53,25.69,26.28,27.06,28.78,32.0,34.81,37.5,39.56,41.44,42.06,41.75,40.41,39.84,38.0,37.06,35.31,34.69,33.81,33.97,34.59,34.84,34.91,35.25,35.53,35.31,35.78,37.66,39.19,42.91,45.03,47.62,49.16,48.66,47.12,42.69,38.62,34.06,30.75,27.91,27.25,26.88,27.25,28.41,28.22,28.41,28.0,26.84,24.75,24.0,23.25,23.75,23.81,26.06,27.03,28.28,30.69,31.53,32.25,32.94,32.0,30.16,27.62,26.44,26.44,27.06,30.25,33.34,37.81,40.25,43.5,44.41,44.47,43.44,41.94,40.69,39.78,38.62,39.44,40.25,42.38,42.5,43.78,43.84,43.69,43.0,41.0,40.75,39.5,39.16,38.5,39.78,39.38,39.5,38.53,38.06,36.69,35.94,36.03,36.03,37.25,39.31,41.19,43.06,44.31,44.44,44.44,42.69,41.66,40.12,38.31,36.94,35.38,34.62,33.34,33.53,34.12,34.53,34.91,36.16,36.91,37.69,39.03,40.38,41.09,43.72,44.31,45.53,46.41,48.25,48.38,48.19,47.53,44.81,42.91,40.03,38.81,38.41,38.31,38.81,38.94,39.19,38.78,38.31,38.12,37.78,37.53,37.81,37.97,39.28,40.31,42.44,45.69,47.34,48.56,49.81,49.16,48.69,47.62,46.94,46.28,45.12,43.88,42.38,41.31,40.25,40.34,41.25,41.53,41.94,41.28,40.88,40.28,39.56,40.44,41.53,42.94,43.56,43.91,43.44,42.03,38.0,36.47,33.81,32.62,31.78,31.81,31.81,31.47,31.41,31.06,31.59,31.53,32.62,33.5,34.09,33.88,33.91,34.91,35.16,35.78,36.66,37.47,37.06,35.31,32.69,30.59,28.03,26.53,25.25,25.72,25.97,26.03,26.16,26.06,25.31,25.12,25.19,26.59,27.59,29.53,31.38,33.0,33.94,35.69,37.69,39.97,40.91,41.25,41.31,39.81,38.94,37.53,37.31,37.34,37.88,36.84,35.84,35.03,33.69,32.41,32.03,32.03,33.56,34.44,35.66,37.16,39.44,41.78,43.66,45.78,46.88,47.72,46.81,46.38,44.5,43.44,42.53,41.94,41.25,41.5,42.31,42.44,42.84,42.56,42.66,41.75,41.19,39.94,39.69,39.34,39.53,40.53,42.47,44.84,47.53,48.31,49.09,47.69,46.0,43.31,41.16,38.97,37.03,35.66,35.44,34.41,33.88,34.19,32.91,32.91,32.34,32.59,33.06,33.12,34.5,35.44,36.19,38.28,39.56,41.81,43.53,45.44,47.06,45.66,43.25,40.0,36.38,33.47,31.72,31.5,32.5,33.69,35.25,36.62,36.94,36.94,35.41,34.0,32.03,30.69,29.91,29.94,29.28,30.41,30.84,31.19,32.34,31.66,31.75,31.5,30.94,29.97,29.69,29.38,29.5,31.16,32.53,34.34,36.84,37.78,38.53,37.53,37.34,36.66,36.22,36.31,37.0,37.84,38.53,39.06,38.97,38.22,36.69,34.81,33.16,32.47,32.66,33.28,34.94,36.41,37.31,38.81,39.94,40.66,40.28,39.78,38.5,38.25,38.47,39.44,41.72,43.0,44.41,44.94,44.56,44.25,43.16,41.31,39.69,37.28,35.72,34.25,32.53,32.5,32.06,31.69,31.88,31.88,32.31,32.0,30.78,30.75,30.5,30.22,31.62,33.25,33.72,34.62,35.03,33.72,32.0,31.88,32.44,32.88,34.5,35.38,35.69,36.62,35.94,35.66,34.66,34.31,32.72,31.91,30.62,30.44,30.12,32.0,32.44,34.0,35.03,35.78,35.72,33.78,32.16,30.59,27.56,25.16,23.78,22.81,21.34,20.66,20.22,19.56,19.78,21.28,22.88,25.28,27.91,29.47,30.94,31.53,32.12,32.09,32.06,31.75,30.81,29.59,27.66,25.75,22.59,21.38,21.5,22.25,23.16,24.66,26.09,26.5,27.47,27.66,28.66,29.44,29.78,30.44,30.16,29.91,29.78,29.81,29.91,29.66,29.91,28.94,28.03,26.56,25.28,24.94,25.47,25.06,25.69,26.41,26.28,26.38,25.41,24.72,23.75,23.44,22.88,22.78,24.56,26.97,29.62,32.72,35.31,37.06,38.22,37.94,36.34,34.59,33.06,30.88,28.81,27.5,26.03,26.12,26.25,26.84,28.88,31.0,31.62,32.91,32.94,33.28,33.19,32.75,32.78,32.44,32.78,33.78,34.56,37.03,38.44,39.41,39.91,38.91,37.56,36.03,34.34,33.0,31.25,29.84,28.88,27.41,26.0,25.28,25.09,25.62,26.03,27.19,28.81,29.59,30.41,29.66,29.28,28.34,26.78,25.53,24.31,23.69,23.38,23.78,24.88,26.28,30.09,32.03,34.0,34.59,33.19,29.75,27.47,24.78,23.22,23.59,24.34,24.72,25.78,26.19,26.81,27.56,27.16,26.78,26.91,25.81,24.97,23.66,21.88,19.81,18.19,16.06,14.66,14.28,13.5,13.44,13.31,13.34,15.78,18.0,20.5,23.84,26.81,29.38,31.19,32.72,33.19,33.28,31.94,30.91,28.16,26.44,26.0,26.03,26.56,27.66,31.97,31.69,33.25,34.69,37.12,38.56,39.16,40.66,39.53,38.53,37.19,36.12,34.12,33.31,32.94,31.97,32.47,32.03,31.44,31.12,30.5,30.25,29.75,30.19,29.81,29.97,30.81,31.25,31.72,33.12:negativity
21.53,19.88,18.88,18.34,17.16,17.09,16.62,17.34,17.0,17.62,17.66,18.03,17.56,17.38,17.06,16.56,15.56,14.66,14.06,14.31,15.38,15.91,16.91,16.94,15.97,15.06,12.62,13.72,14.0,14.78,16.5,18.56,19.69,19.31,20.84,21.25,21.06,21.34,21.19,21.72,21.94,22.16,22.38,21.56,20.19,19.97,18.84,19.16,19.47,19.47,19.66,20.16,20.0,21.25,20.94,20.34,20.22,17.91,16.75,15.25,13.41,13.78,12.44,12.25,11.81,10.66,9.12,7.25,5.59,2.88,1.0,0.19,-1.88,-1.59,-1.31,-0.75,-1.56,-0.72,-0.19,-0.09,1.28,3.06,3.5,4.31,4.56,4.53,5.44,4.28,3.19,2.34,1.78,1.41,2.19,3.22,4.12,5.62,7.06,7.94,9.59,10.19,10.09,8.81,8.25,7.66,6.78,7.16,10.25,9.94,11.69,13.0,15.12,15.94,17.91,18.78,20.06,19.81,19.91,19.72,19.72,20.12,20.62,20.56,21.5,20.12,19.44,18.53,18.72,17.06,18.16,18.31,18.34,19.31,19.22,19.25,18.0,16.94,15.38,13.19,11.34,10.53,8.53,7.16,7.44,6.84,6.81,6.28,6.69,6.16,5.41,5.56,5.56,3.78,2.28,1.34,-2.34,-4.28,-6.09,-7.34,-7.91,-8.66,-8.84,-6.69,-4.69,-1.72,2.41,6.66,8.12,9.56,9.56,8.56,6.91,5.5,4.06,2.5,0.31,0.12,-0.53,-0.28,0.88,1.84,2.75,4.44,6.09,8.28,9.16,10.97,11.88,11.38,12.53,12.91,13.41,15.0,15.91,16.03,17.31,18.25,18.0,18.28,18.34,18.28,19.62,21.38,21.72,23.12,23.91,22.78,21.75,19.62,17.88,15.41,13.75,12.19,11.31,10.34,10.0,8.88,8.66,8.59,8.25,9.66,9.5,10.12,10.94,10.75,11.28,11.44,11.78,11.34,10.5,10.0,7.97,5.69,4.03,1.88,0.09,-1.69,-2.44,-2.75,-2.69,-2.16,-1.75,-2.03,-2.5,-3.09,-2.97,-2.38,-1.22,0.09,-0.69,-1.22,-1.09,-2.28,-2.28,-0.84,-1.47,0.0,-0.12,-0.66,-0.69,-1.19,-0.97,-1.47,-2.72,-2.19,-2.03,-2.38,-1.72,-0.94,-0.34,0.03,1.78,2.53,2.94,4.5,5.47,6.22,7.72,8.62,9.19,8.91,8.41,7.06,6.31,5.31,3.81,2.88,2.84,2.78,3.69,5.0,5.62,8.03,7.97,8.94,9.62,10.94,11.66,11.75,12.0,11.0,9.44,7.62,6.0,4.91,3.62,4.22,3.88,4.16,5.44,6.5,6.31,7.69,7.91,7.78,7.69,8.41,7.97,8.84,9.0,8.22,8.69,8.25,8.84,8.97,9.69,10.16,11.0,10.81,12.25,12.44,11.06,10.62,8.12,5.31,2.97,0.28,-1.94,-3.53,-4.62,-4.25,-2.66,-1.03,0.44,1.81,1.25,1.69,1.03,2.16,2.91,2.5,3.16,2.09,1.84,0.94,0.78,-0.97,-1.0,-2.22,-1.97,-1.22,-0.31,1.69,2.5,3.66,4.03,5.84,6.53,8.09,8.56,8.5,7.19,6.75,7.0,8.16,9.25,11.34,12.53,13.44,13.59,13.28,13.16,14.03,14.44,14.12,15.0,15.12,15.78,15.09,15.31,15.44,14.31,12.88,11.53,10.91,9.75,9.47,9.81,9.31,9.16,7.84,7.88,8.25,8.0,8.84,9.78,9.28,8.44,8.16,7.66,8.12,10.0,12.0,14.19,17.53,19.88,20.66,21.31,20.75,18.56,16.34,14.38,12.84,10.69,9.19,8.31,7.47,6.72,6.66,6.47,6.75,7.69,8.28,9.5,10.69,11.19,13.78,15.31,15.5,16.69,16.41,14.88,12.97,12.09,10.38,8.78,8.44,6.62,5.94,5.78,5.56,5.12,5.84,5.72,5.47,4.81,4.44,4.41,3.97,3.62,3.56,3.25,4.12,5.78,6.28,8.81,9.66,11.41,13.44,15.09,17.12,18.09,18.34,18.62,17.88,17.03,17.59,15.84,14.66,14.94,13.5,12.03,11.94,13.22,13.94,15.62,18.06,19.84,21.0,20.56,19.97,18.97,17.31,15.44,15.19,13.44,13.03,12.16,12.0,11.34,11.81,12.97,15.47,17.25,18.66,20.28,20.53,20.72,19.34,17.72,16.69,15.56,14.28,14.38,14.59,14.09,14.0,12.72,12.19,11.59,10.59,10.19,9.72,10.09,9.56,9.59,11.41,11.75,12.41,13.34,13.19,12.91,13.03,12.34,11.78,11.72,11.62,11.41,11.91,12.22,11.28,11.84,11.31,11.03,10.81,11.16,11.31,12.06,12.5,13.62,14.34,15.0,15.06,15.81,14.91,15.56,15.06,13.97,12.72,11.62,10.78,9.5,9.0,7.91,7.28,6.72,5.66,5.62,6.5,7.06,8.03,8.75,9.41,10.03,9.78,10.28,9.81,9.62,8.5,8.25,6.56,5.56,5.47,5.03,6.34,6.5,6.56,7.62,6.25,6.0,5.84,6.44,6.62,7.38,7.59,8.53,8.91,9.81,10.69,11.66,11.81,12.81,12.5,12.12,11.78,11.03,9.56,10.06,8.88,8.06,8.22,7.53,6.25,7.5,7.91,8.56,9.41,9.84,10.03,9.06,9.97,9.62,8.81,9.72,9.59,9.41,9.56,8.59,7.97,7.28,6.41,5.78,6.78,8.53,9.66,11.81,13.56,13.12,14.34,12.72,11.94,11.59,10.94,10.56,10.19,10.19,9.06,8.31,7.56,6.25,6.69,9.44,11.88,15.66,18.81,21.06,20.75,18.78,15.88,12.5,9.5,8.12,7.06,6.19,5.06,3.97,2.28,-0.38,-1.59,-2.03,-2.41,-1.72,0.06,1.06,1.97,3.53,5.41,6.03,7.56,9.0,8.94,9.03,8.97,8.62,10.16,10.62,12.03,12.78,13.25,15.06,14.69,16.19,16.88,16.19,16.44,15.78,15.41,14.53,14.25,14.53,14.69,16.16,18.16,19.53,21.69,22.19,22.06,21.5,20.0,19.06,18.12,18.12,19.31,19.94,20.59,21.19,20.5,20.38,20.31,20.34,20.72,21.84,23.03,23.16,24.5,24.34,24.69,24.53,24.31,24.78,25.31,24.91,25.0,24.53,23.78,23.28,22.88,23.34,22.81,22.97,22.88,22.16,21.62,21.59,20.81,20.38,20.31,20.38,21.19,21.06,21.56,20.91,20.88,20.31,19.44,18.88,17.25,15.56,14.06,12.31,11.16,11.94,12.34,14.44,15.41,16.06,16.84,16.91,16.28,16.22,15.38,15.28,14.5,14.16,15.12,14.28,16.12,17.19,17.25,19.16,20.25,20.56,21.0,21.41,21.84,21.81,20.53,21.44,20.75,20.31,19.94,19.19,18.41,17.78,17.62,17.66,18.31,19.34,21.19,22.88,25.47,28.06,29.84,32.88,34.75,37.19,40.0,41.97,42.41,42.56,41.0,39.34,37.22,33.81,32.12,28.53,26.53,25.12,24.28,25.06,26.47,27.88,30.06,31.5,32.56,33.0,32.69,31.91,31.75,31.19,30.56,31.25,31.19,30.16,30.53,30.31,30.31,31.34,31.81,32.97,33.22,32.94,32.62,31.06,29.78,27.84,26.41,25.53,24.34,23.41,24.53,25.12,27.44,30.62,34.28,36.84,38.22,38.31,37.94,34.88,31.62,28.31,23.81,19.88,15.12,11.5,8.59,6.19,4.41,3.59,2.34,1.94,0.91,-0.53,-0.88,-2.06,-3.25,-3.62,-4.44,-4.75,-4.59,-5.5,-5.5,-5.28,-5.91,-5.78,-5.16,-6.06,-6.38,-5.75,-5.53,-3.16,0.5,4.78,8.94,11.28,11.44:16.62,17.34,17.0,17.62,17.66,18.03,17.56,17.38,17.06,16.56,15.56,14.66,14.06,14.31,15.38,15.91,16.91,16.94,15.97,15.06,12.62,13.72,14.0,14.78,16.5,18.56,19.69,19.31,20.84,21.25,21.06,21.34,21.19,21.72,21.94,22.16,22.38,21.56,20.19,19.97,18.84,19.16,19.47,19.47,19.66,20.16,20.0,21.25,20.94,20.34,20.22,17.91,16.75,15.25,13.41,13.78,12.44,12.25,11.81,10.66,9.12,7.25,5.59,2.88,1.0,0.19,-1.88,-1.59,-1.31,-0.75,-1.56,-0.72,-0.19,-0.09,1.28,3.06,3.5,4.31,4.56,4.53,5.44,4.28,3.19,2.34,1.78,1.41,2.19,3.22,4.12,5.62,7.06,7.94,9.59,10.19,10.09,8.81,8.25,7.66,6.78,7.16,10.25,9.94,11.69,13.0,15.12,15.94,17.91,18.78,20.06,19.81,19.91,19.72,19.72,20.12,20.62,20.56,21.5,20.12,19.44,18.53,18.72,17.06,18.16,18.31,18.34,19.31,19.22,19.25,18.0,16.94,15.38,13.19,11.34,10.53,8.53,7.16,7.44,6.84,6.81,6.28,6.69,6.16,5.41,5.56,5.56,3.78,2.28,1.34,-2.34,-4.28,-6.09,-7.34,-7.91,-8.66,-8.84,-6.69,-4.69,-1.72,2.41,6.66,8.12,9.56,9.56,8.56,6.91,5.5,4.06,2.5,0.31,0.12,-0.53,-0.28,0.88,1.84,2.75,4.44,6.09,8.28,9.16,10.97,11.88,11.38,12.53,12.91,13.41,15.0,15.91,16.03,17.31,18.25,18.0,18.28,18.34,18.28,19.62,21.38,21.72,23.12,23.91,22.78,21.75,19.62,17.88,15.41,13.75,12.19,11.31,10.34,10.0,8.88,8.66,8.59,8.25,9.66,9.5,10.12,10.94,10.75,11.28,11.44,11.78,11.34,10.5,10.0,7.97,5.69,4.03,1.88,0.09,-1.69,-2.44,-2.75,-2.69,-2.16,-1.75,-2.03,-2.5,-3.09,-2.97,-2.38,-1.22,0.09,-0.69,-1.22,-1.09,-2.28,-2.28,-0.84,-1.47,0.0,-0.12,-0.66,-0.69,-1.19,-0.97,-1.47,-2.72,-2.19,-2.03,-2.38,-1.72,-0.94,-0.34,0.03,1.78,2.53,2.94,4.5,5.47,6.22,7.72,8.62,9.19,8.91,8.41,7.06,6.31,5.31,3.81,2.88,2.84,2.78,3.69,5.0,5.62,8.03,7.97,8.94,9.62,10.94,11.66,11.75,12.0,11.0,9.44,7.62,6.0,4.91,3.62,4.22,3.88,4.16,5.44,6.5,6.31,7.69,7.91,7.78,7.69,8.41,7.97,8.84,9.0,8.22,8.69,8.25,8.84,8.97,9.69,10.16,11.0,10.81,12.25,12.44,11.06,10.62,8.12,5.31,2.97,0.28,-1.94,-3.53,-4.62,-4.25,-2.66,-1.03,0.44,1.81,1.25,1.69,1.03,2.16,2.91,2.5,3.16,2.09,1.84,0.94,0.78,-0.97,-1.0,-2.22,-1.97,-1.22,-0.31,1.69,2.5,3.66,4.03,5.84,6.53,8.09,8.56,8.5,7.19,6.75,7.0,8.16,9.25,11.34,12.53,13.44,13.59,13.28,13.16,14.03,14.44,14.12,15.0,15.12,15.78,15.09,15.31,15.44,14.31,12.88,11.53,10.91,9.75,9.47,9.81,9.31,9.16,7.84,7.88,8.25,8.0,8.84,9.78,9.28,8.44,8.16,7.66,8.12,10.0,12.0,14.19,17.53,19.88,20.66,21.31,20.75,18.56,16.34,14.38,12.84,10.69,9.19,8.31,7.47,6.72,6.66,6.47,6.75,7.69,8.28,9.5,10.69,11.19,13.78,15.31,15.5,16.69,16.41,14.88,12.97,12.09,10.38,8.78,8.44,6.62,5.94,5.78,5.56,5.12,5.84,5.72,5.47,4.81,4.44,4.41,3.97,3.62,3.56,3.25,4.12,5.78,6.28,8.81,9.66,11.41,13.44,15.09,17.12,18.09,18.34,18.62,17.88,17.03,17.59,15.84,14.66,14.94,13.5,12.03,11.94,13.22,13.94,15.62,18.06,19.84,21.0,20.56,19.97,18.97,17.31,15.44,15.19,13.44,13.03,12.16,12.0,11.34,11.81,12.97,15.47,17.25,18.66,20.28,20.53,20.72,19.34,17.72,16.69,15.56,14.28,14.38,14.59,14.09,14.0,12.72,12.19,11.59,10.59,10.19,9.72,10.09,9.56,9.59,11.41,11.75,12.41,13.34,13.19,12.91,13.03,12.34,11.78,11.72,11.62,11.41,11.91,12.22,11.28,11.84,11.31,11.03,10.81,11.16,11.31,12.06,12.5,13.62,14.34,15.0,15.06,15.81,14.91,15.56,15.06,13.97,12.72,11.62,10.78,9.5,9.0,7.91,7.28,6.72,5.66,5.62,6.5,7.06,8.03,8.75,9.41,10.03,9.78,10.28,9.81,9.62,8.5,8.25,6.56,5.56,5.47,5.03,6.34,6.5,6.56,7.62,6.25,6.0,5.84,6.44,6.62,7.38,7.59,8.53,8.91,9.81,10.69,11.66,11.81,12.81,12.5,12.12,11.78,11.03,9.56,10.06,8.88,8.06,8.22,7.53,6.25,7.5,7.91,8.56,9.41,9.84,10.03,9.06,9.97,9.62,8.81,9.72,9.59,9.41,9.56,8.59,7.97,7.28,6.41,5.78,6.78,8.53,9.66,11.81,13.56,13.12,14.34,12.72,11.94,11.59,10.94,10.56,10.19,10.19,9.06,8.31,7.56,6.25,6.69,9.44,11.88,15.66,18.81,21.06,20.75,18.78,15.88,12.5,9.5,8.12,7.06,6.19,5.06,3.97,2.28,-0.38,-1.59,-2.03,-2.41,-1.72,0.06,1.06,1.97,3.53,5.41,6.03,7.56,9.0,8.94,9.03,8.97,8.62,10.16,10.62,12.03,12.78,13.25,15.06,14.69,16.19,16.88,16.19,16.44,15.78,15.41,14.53,14.25,14.53,14.69,16.16,18.16,19.53,21.69,22.19,22.06,21.5,20.0,19.06,18.12,18.12,19.31,19.94,20.59,21.19,20.5,20.38,20.31,20.34,20.72,21.84,23.03,23.16,24.5,24.34,24.69,24.53,24.31,24.78,25.31,24.91,25.0,24.53,23.78,23.28,22.88,23.34,22.81,22.97,22.88,22.16,21.62,21.59,20.81,20.38,20.31,20.38,21.19,21.06,21.56,20.91,20.88,20.31,19.44,18.88,17.25,15.56,14.06,12.31,11.16,11.94,12.34,14.44,15.41,16.06,16.84,16.91,16.28,16.22,15.38,15.28,14.5,14.16,15.12,14.28,16.12,17.19,17.25,19.16,20.25,20.56,21.0,21.41,21.84,21.81,20.53,21.44,20.75,20.31,19.94,19.19,18.41,17.78,17.62,17.66,18.31,19.34,21.19,22.88,25.47,28.06,29.84,32.88,34.75,37.19,40.0,41.97,42.41,42.56,41.0,39.34,37.22,33.81,32.12,28.53,26.53,25.12,24.28,25.06,26.47,27.88,30.06,31.5,32.56,33.0,32.69,31.91,31.75,31.19,30.56,31.25,31.19,30.16,30.53,30.31,30.31,31.34,31.81,32.97,33.22,32.94,32.62,31.06,29.78,27.84,26.41,25.53,24.34,23.41,24.53,25.12,27.44,30.62,34.28,36.84,38.22,38.31,37.94,34.88,31.62,28.31,23.81,19.88,15.12,11.5,8.59,6.19,4.41,3.59,2.34,1.94,0.91,-0.53,-0.88,-2.06,-3.25,-3.62,-4.44,-4.75,-4.59,-5.5,-5.5,-5.28,-5.91,-5.78,-5.16,-6.06,-6.38,-5.75,-5.53,-3.16,0.5,4.78,8.94,11.28,11.44,11.91,10.06,7.06,4.5,3.62,2.16:17.56,17.38,17.06,16.56,15.56,14.66,14.06,14.31,15.38,15.91,16.91,16.94,15.97,15.06,12.62,13.72,14.0,14.78,16.5,18.56,19.69,19.31,20.84,21.25,21.06,21.34,21.19,21.72,21.94,22.16,22.38,21.56,20.19,19.97,18.84,19.16,19.47,19.47,19.66,20.16,20.0,21.25,20.94,20.34,20.22,17.91,16.75,15.25,13.41,13.78,12.44,12.25,11.81,10.66,9.12,7.25,5.59,2.88,1.0,0.19,-1.88,-1.59,-1.31,-0.75,-1.56,-0.72,-0.19,-0.09,1.28,3.06,3.5,4.31,4.56,4.53,5.44,4.28,3.19,2.34,1.78,1.41,2.19,3.22,4.12,5.62,7.06,7.94,9.59,10.19,10.09,8.81,8.25,7.66,6.78,7.16,10.25,9.94,11.69,13.0,15.12,15.94,17.91,18.78,20.06,19.81,19.91,19.72,19.72,20.12,20.62,20.56,21.5,20.12,19.44,18.53,18.72,17.06,18.16,18.31,18.34,19.31,19.22,19.25,18.0,16.94,15.38,13.19,11.34,10.53,8.53,7.16,7.44,6.84,6.81,6.28,6.69,6.16,5.41,5.56,5.56,3.78,2.28,1.34,-2.34,-4.28,-6.09,-7.34,-7.91,-8.66,-8.84,-6.69,-4.69,-1.72,2.41,6.66,8.12,9.56,9.56,8.56,6.91,5.5,4.06,2.5,0.31,0.12,-0.53,-0.28,0.88,1.84,2.75,4.44,6.09,8.28,9.16,10.97,11.88,11.38,12.53,12.91,13.41,15.0,15.91,16.03,17.31,18.25,18.0,18.28,18.34,18.28,19.62,21.38,21.72,23.12,23.91,22.78,21.75,19.62,17.88,15.41,13.75,12.19,11.31,10.34,10.0,8.88,8.66,8.59,8.25,9.66,9.5,10.12,10.94,10.75,11.28,11.44,11.78,11.34,10.5,10.0,7.97,5.69,4.03,1.88,0.09,-1.69,-2.44,-2.75,-2.69,-2.16,-1.75,-2.03,-2.5,-3.09,-2.97,-2.38,-1.22,0.09,-0.69,-1.22,-1.09,-2.28,-2.28,-0.84,-1.47,0.0,-0.12,-0.66,-0.69,-1.19,-0.97,-1.47,-2.72,-2.19,-2.03,-2.38,-1.72,-0.94,-0.34,0.03,1.78,2.53,2.94,4.5,5.47,6.22,7.72,8.62,9.19,8.91,8.41,7.06,6.31,5.31,3.81,2.88,2.84,2.78,3.69,5.0,5.62,8.03,7.97,8.94,9.62,10.94,11.66,11.75,12.0,11.0,9.44,7.62,6.0,4.91,3.62,4.22,3.88,4.16,5.44,6.5,6.31,7.69,7.91,7.78,7.69,8.41,7.97,8.84,9.0,8.22,8.69,8.25,8.84,8.97,9.69,10.16,11.0,10.81,12.25,12.44,11.06,10.62,8.12,5.31,2.97,0.28,-1.94,-3.53,-4.62,-4.25,-2.66,-1.03,0.44,1.81,1.25,1.69,1.03,2.16,2.91,2.5,3.16,2.09,1.84,0.94,0.78,-0.97,-1.0,-2.22,-1.97,-1.22,-0.31,1.69,2.5,3.66,4.03,5.84,6.53,8.09,8.56,8.5,7.19,6.75,7.0,8.16,9.25,11.34,12.53,13.44,13.59,13.28,13.16,14.03,14.44,14.12,15.0,15.12,15.78,15.09,15.31,15.44,14.31,12.88,11.53,10.91,9.75,9.47,9.81,9.31,9.16,7.84,7.88,8.25,8.0,8.84,9.78,9.28,8.44,8.16,7.66,8.12,10.0,12.0,14.19,17.53,19.88,20.66,21.31,20.75,18.56,16.34,14.38,12.84,10.69,9.19,8.31,7.47,6.72,6.66,6.47,6.75,7.69,8.28,9.5,10.69,11.19,13.78,15.31,15.5,16.69,16.41,14.88,12.97,12.09,10.38,8.78,8.44,6.62,5.94,5.78,5.56,5.12,5.84,5.72,5.47,4.81,4.44,4.41,3.97,3.62,3.56,3.25,4.12,5.78,6.28,8.81,9.66,11.41,13.44,15.09,17.12,18.09,18.34,18.62,17.88,17.03,17.59,15.84,14.66,14.94,13.5,12.03,11.94,13.22,13.94,15.62,18.06,19.84,21.0,20.56,19.97,18.97,17.31,15.44,15.19,13.44,13.03,12.16,12.0,11.34,11.81,12.97,15.47,17.25,18.66,20.28,20.53,20.72,19.34,17.72,16.69,15.56,14.28,14.38,14.59,14.09,14.0,12.72,12.19,11.59,10.59,10.19,9.72,10.09,9.56,9.59,11.41,11.75,12.41,13.34,13.19,12.91,13.03,12.34,11.78,11.72,11.62,11.41,11.91,12.22,11.28,11.84,11.31,11.03,10.81,11.16,11.31,12.06,12.5,13.62,14.34,15.0,15.06,15.81,14.91,15.56,15.06,13.97,12.72,11.62,10.78,9.5,9.0,7.91,7.28,6.72,5.66,5.62,6.5,7.06,8.03,8.75,9.41,10.03,9.78,10.28,9.81,9.62,8.5,8.25,6.56,5.56,5.47,5.03,6.34,6.5,6.56,7.62,6.25,6.0,5.84,6.44,6.62,7.38,7.59,8.53,8.91,9.81,10.69,11.66,11.81,12.81,12.5,12.12,11.78,11.03,9.56,10.06,8.88,8.06,8.22,7.53,6.25,7.5,7.91,8.56,9.41,9.84,10.03,9.06,9.97,9.62,8.81,9.72,9.59,9.41,9.56,8.59,7.97,7.28,6.41,5.78,6.78,8.53,9.66,11.81,13.56,13.12,14.34,12.72,11.94,11.59,10.94,10.56,10.19,10.19,9.06,8.31,7.56,6.25,6.69,9.44,11.88,15.66,18.81,21.06,20.75,18.78,15.88,12.5,9.5,8.12,7.06,6.19,5.06,3.97,2.28,-0.38,-1.59,-2.03,-2.41,-1.72,0.06,1.06,1.97,3.53,5.41,6.03,7.56,9.0,8.94,9.03,8.97,8.62,10.16,10.62,12.03,12.78,13.25,15.06,14.69,16.19,16.88,16.19,16.44,15.78,15.41,14.53,14.25,14.53,14.69,16.16,18.16,19.53,21.69,22.19,22.06,21.5,20.0,19.06,18.12,18.12,19.31,19.94,20.59,21.19,20.5,20.38,20.31,20.34,20.72,21.84,23.03,23.16,24.5,24.34,24.69,24.53,24.31,24.78,25.31,24.91,25.0,24.53,23.78,23.28,22.88,23.34,22.81,22.97,22.88,22.16,21.62,21.59,20.81,20.38,20.31,20.38,21.19,21.06,21.56,20.91,20.88,20.31,19.44,18.88,17.25,15.56,14.06,12.31,11.16,11.94,12.34,14.44,15.41,16.06,16.84,16.91,16.28,16.22,15.38,15.28,14.5,14.16,15.12,14.28,16.12,17.19,17.25,19.16,20.25,20.56,21.0,21.41,21.84,21.81,20.53,21.44,20.75,20.31,19.94,19.19,18.41,17.78,17.62,17.66,18.31,19.34,21.19,22.88,25.47,28.06,29.84,32.88,34.75,37.19,40.0,41.97,42.41,42.56,41.0,39.34,37.22,33.81,32.12,28.53,26.53,25.12,24.28,25.06,26.47,27.88,30.06,31.5,32.56,33.0,32.69,31.91,31.75,31.19,30.56,31.25,31.19,30.16,30.53,30.31,30.31,31.34,31.81,32.97,33.22,32.94,32.62,31.06,29.78,27.84,26.41,25.53,24.34,23.41,24.53,25.12,27.44,30.62,34.28,36.84,38.22,38.31,37.94,34.88,31.62,28.31,23.81,19.88,15.12,11.5,8.59,6.19,4.41,3.59,2.34,1.94,0.91,-0.53,-0.88,-2.06,-3.25,-3.62,-4.44,-4.75,-4.59,-5.5,-5.5,-5.28,-5.91,-5.78,-5.16,-6.06,-6.38,-5.75,-5.53,-3.16,0.5,4.78,8.94,11.28,11.44,11.91,10.06,7.06,4.5,3.62,2.16,1.66,2.59,3.25,5.72,8.28,9.88:14.06,14.31,15.38,15.91,16.91,16.94,15.97,15.06,12.62,13.72,14.0,14.78,16.5,18.56,19.69,19.31,20.84,21.25,21.06,21.34,21.19,21.72,21.94,22.16,22.38,21.56,20.19,19.97,18.84,19.16,19.47,19.47,19.66,20.16,20.0,21.25,20.94,20.34,20.22,17.91,16.75,15.25,13.41,13.78,12.44,12.25,11.81,10.66,9.12,7.25,5.59,2.88,1.0,0.19,-1.88,-1.59,-1.31,-0.75,-1.56,-0.72,-0.19,-0.09,1.28,3.06,3.5,4.31,4.56,4.53,5.44,4.28,3.19,2.34,1.78,1.41,2.19,3.22,4.12,5.62,7.06,7.94,9.59,10.19,10.09,8.81,8.25,7.66,6.78,7.16,10.25,9.94,11.69,13.0,15.12,15.94,17.91,18.78,20.06,19.81,19.91,19.72,19.72,20.12,20.62,20.56,21.5,20.12,19.44,18.53,18.72,17.06,18.16,18.31,18.34,19.31,19.22,19.25,18.0,16.94,15.38,13.19,11.34,10.53,8.53,7.16,7.44,6.84,6.81,6.28,6.69,6.16,5.41,5.56,5.56,3.78,2.28,1.34,-2.34,-4.28,-6.09,-7.34,-7.91,-8.66,-8.84,-6.69,-4.69,-1.72,2.41,6.66,8.12,9.56,9.56,8.56,6.91,5.5,4.06,2.5,0.31,0.12,-0.53,-0.28,0.88,1.84,2.75,4.44,6.09,8.28,9.16,10.97,11.88,11.38,12.53,12.91,13.41,15.0,15.91,16.03,17.31,18.25,18.0,18.28,18.34,18.28,19.62,21.38,21.72,23.12,23.91,22.78,21.75,19.62,17.88,15.41,13.75,12.19,11.31,10.34,10.0,8.88,8.66,8.59,8.25,9.66,9.5,10.12,10.94,10.75,11.28,11.44,11.78,11.34,10.5,10.0,7.97,5.69,4.03,1.88,0.09,-1.69,-2.44,-2.75,-2.69,-2.16,-1.75,-2.03,-2.5,-3.09,-2.97,-2.38,-1.22,0.09,-0.69,-1.22,-1.09,-2.28,-2.28,-0.84,-1.47,0.0,-0.12,-0.66,-0.69,-1.19,-0.97,-1.47,-2.72,-2.19,-2.03,-2.38,-1.72,-0.94,-0.34,0.03,1.78,2.53,2.94,4.5,5.47,6.22,7.72,8.62,9.19,8.91,8.41,7.06,6.31,5.31,3.81,2.88,2.84,2.78,3.69,5.0,5.62,8.03,7.97,8.94,9.62,10.94,11.66,11.75,12.0,11.0,9.44,7.62,6.0,4.91,3.62,4.22,3.88,4.16,5.44,6.5,6.31,7.69,7.91,7.78,7.69,8.41,7.97,8.84,9.0,8.22,8.69,8.25,8.84,8.97,9.69,10.16,11.0,10.81,12.25,12.44,11.06,10.62,8.12,5.31,2.97,0.28,-1.94,-3.53,-4.62,-4.25,-2.66,-1.03,0.44,1.81,1.25,1.69,1.03,2.16,2.91,2.5,3.16,2.09,1.84,0.94,0.78,-0.97,-1.0,-2.22,-1.97,-1.22,-0.31,1.69,2.5,3.66,4.03,5.84,6.53,8.09,8.56,8.5,7.19,6.75,7.0,8.16,9.25,11.34,12.53,13.44,13.59,13.28,13.16,14.03,14.44,14.12,15.0,15.12,15.78,15.09,15.31,15.44,14.31,12.88,11.53,10.91,9.75,9.47,9.81,9.31,9.16,7.84,7.88,8.25,8.0,8.84,9.78,9.28,8.44,8.16,7.66,8.12,10.0,12.0,14.19,17.53,19.88,20.66,21.31,20.75,18.56,16.34,14.38,12.84,10.69,9.19,8.31,7.47,6.72,6.66,6.47,6.75,7.69,8.28,9.5,10.69,11.19,13.78,15.31,15.5,16.69,16.41,14.88,12.97,12.09,10.38,8.78,8.44,6.62,5.94,5.78,5.56,5.12,5.84,5.72,5.47,4.81,4.44,4.41,3.97,3.62,3.56,3.25,4.12,5.78,6.28,8.81,9.66,11.41,13.44,15.09,17.12,18.09,18.34,18.62,17.88,17.03,17.59,15.84,14.66,14.94,13.5,12.03,11.94,13.22,13.94,15.62,18.06,19.84,21.0,20.56,19.97,18.97,17.31,15.44,15.19,13.44,13.03,12.16,12.0,11.34,11.81,12.97,15.47,17.25,18.66,20.28,20.53,20.72,19.34,17.72,16.69,15.56,14.28,14.38,14.59,14.09,14.0,12.72,12.19,11.59,10.59,10.19,9.72,10.09,9.56,9.59,11.41,11.75,12.41,13.34,13.19,12.91,13.03,12.34,11.78,11.72,11.62,11.41,11.91,12.22,11.28,11.84,11.31,11.03,10.81,11.16,11.31,12.06,12.5,13.62,14.34,15.0,15.06,15.81,14.91,15.56,15.06,13.97,12.72,11.62,10.78,9.5,9.0,7.91,7.28,6.72,5.66,5.62,6.5,7.06,8.03,8.75,9.41,10.03,9.78,10.28,9.81,9.62,8.5,8.25,6.56,5.56,5.47,5.03,6.34,6.5,6.56,7.62,6.25,6.0,5.84,6.44,6.62,7.38,7.59,8.53,8.91,9.81,10.69,11.66,11.81,12.81,12.5,12.12,11.78,11.03,9.56,10.06,8.88,8.06,8.22,7.53,6.25,7.5,7.91,8.56,9.41,9.84,10.03,9.06,9.97,9.62,8.81,9.72,9.59,9.41,9.56,8.59,7.97,7.28,6.41,5.78,6.78,8.53,9.66,11.81,13.56,13.12,14.34,12.72,11.94,11.59,10.94,10.56,10.19,10.19,9.06,8.31,7.56,6.25,6.69,9.44,11.88,15.66,18.81,21.06,20.75,18.78,15.88,12.5,9.5,8.12,7.06,6.19,5.06,3.97,2.28,-0.38,-1.59,-2.03,-2.41,-1.72,0.06,1.06,1.97,3.53,5.41,6.03,7.56,9.0,8.94,9.03,8.97,8.62,10.16,10.62,12.03,12.78,13.25,15.06,14.69,16.19,16.88,16.19,16.44,15.78,15.41,14.53,14.25,14.53,14.69,16.16,18.16,19.53,21.69,22.19,22.06,21.5,20.0,19.06,18.12,18.12,19.31,19.94,20.59,21.19,20.5,20.38,20.31,20.34,20.72,21.84,23.03,23.16,24.5,24.34,24.69,24.53,24.31,24.78,25.31,24.91,25.0,24.53,23.78,23.28,22.88,23.34,22.81,22.97,22.88,22.16,21.62,21.59,20.81,20.38,20.31,20.38,21.19,21.06,21.56,20.91,20.88,20.31,19.44,18.88,17.25,15.56,14.06,12.31,11.16,11.94,12.34,14.44,15.41,16.06,16.84,16.91,16.28,16.22,15.38,15.28,14.5,14.16,15.12,14.28,16.12,17.19,17.25,19.16,20.25,20.56,21.0,21.41,21.84,21.81,20.53,21.44,20.75,20.31,19.94,19.19,18.41,17.78,17.62,17.66,18.31,19.34,21.19,22.88,25.47,28.06,29.84,32.88,34.75,37.19,40.0,41.97,42.41,42.56,41.0,39.34,37.22,33.81,32.12,28.53,26.53,25.12,24.28,25.06,26.47,27.88,30.06,31.5,32.56,33.0,32.69,31.91,31.75,31.19,30.56,31.25,31.19,30.16,30.53,30.31,30.31,31.34,31.81,32.97,33.22,32.94,32.62,31.06,29.78,27.84,26.41,25.53,24.34,23.41,24.53,25.12,27.44,30.62,34.28,36.84,38.22,38.31,37.94,34.88,31.62,28.31,23.81,19.88,15.12,11.5,8.59,6.19,4.41,3.59,2.34,1.94,0.91,-0.53,-0.88,-2.06,-3.25,-3.62,-4.44,-4.75,-4.59,-5.5,-5.5,-5.28,-5.91,-5.78,-5.16,-6.06,-6.38,-5.75,-5.53,-3.16,0.5,4.78,8.94,11.28,11.44,11.91,10.06,7.06,4.5,3.62,2.16,1.66,2.59,3.25,5.72,8.28,9.88,12.94,14.72,15.31,15.56,15.91,13.66:15.97,15.06,12.62,13.72,14.0,14.78,16.5,18.56,19.69,19.31,20.84,21.25,21.06,21.34,21.19,21.72,21.94,22.16,22.38,21.56,20.19,19.97,18.84,19.16,19.47,19.47,19.66,20.16,20.0,21.25,20.94,20.34,20.22,17.91,16.75,15.25,13.41,13.78,12.44,12.25,11.81,10.66,9.12,7.25,5.59,2.88,1.0,0.19,-1.88,-1.59,-1.31,-0.75,-1.56,-0.72,-0.19,-0.09,1.28,3.06,3.5,4.31,4.56,4.53,5.44,4.28,3.19,2.34,1.78,1.41,2.19,3.22,4.12,5.62,7.06,7.94,9.59,10.19,10.09,8.81,8.25,7.66,6.78,7.16,10.25,9.94,11.69,13.0,15.12,15.94,17.91,18.78,20.06,19.81,19.91,19.72,19.72,20.12,20.62,20.56,21.5,20.12,19.44,18.53,18.72,17.06,18.16,18.31,18.34,19.31,19.22,19.25,18.0,16.94,15.38,13.19,11.34,10.53,8.53,7.16,7.44,6.84,6.81,6.28,6.69,6.16,5.41,5.56,5.56,3.78,2.28,1.34,-2.34,-4.28,-6.09,-7.34,-7.91,-8.66,-8.84,-6.69,-4.69,-1.72,2.41,6.66,8.12,9.56,9.56,8.56,6.91,5.5,4.06,2.5,0.31,0.12,-0.53,-0.28,0.88,1.84,2.75,4.44,6.09,8.28,9.16,10.97,11.88,11.38,12.53,12.91,13.41,15.0,15.91,16.03,17.31,18.25,18.0,18.28,18.34,18.28,19.62,21.38,21.72,23.12,23.91,22.78,21.75,19.62,17.88,15.41,13.75,12.19,11.31,10.34,10.0,8.88,8.66,8.59,8.25,9.66,9.5,10.12,10.94,10.75,11.28,11.44,11.78,11.34,10.5,10.0,7.97,5.69,4.03,1.88,0.09,-1.69,-2.44,-2.75,-2.69,-2.16,-1.75,-2.03,-2.5,-3.09,-2.97,-2.38,-1.22,0.09,-0.69,-1.22,-1.09,-2.28,-2.28,-0.84,-1.47,0.0,-0.12,-0.66,-0.69,-1.19,-0.97,-1.47,-2.72,-2.19,-2.03,-2.38,-1.72,-0.94,-0.34,0.03,1.78,2.53,2.94,4.5,5.47,6.22,7.72,8.62,9.19,8.91,8.41,7.06,6.31,5.31,3.81,2.88,2.84,2.78,3.69,5.0,5.62,8.03,7.97,8.94,9.62,10.94,11.66,11.75,12.0,11.0,9.44,7.62,6.0,4.91,3.62,4.22,3.88,4.16,5.44,6.5,6.31,7.69,7.91,7.78,7.69,8.41,7.97,8.84,9.0,8.22,8.69,8.25,8.84,8.97,9.69,10.16,11.0,10.81,12.25,12.44,11.06,10.62,8.12,5.31,2.97,0.28,-1.94,-3.53,-4.62,-4.25,-2.66,-1.03,0.44,1.81,1.25,1.69,1.03,2.16,2.91,2.5,3.16,2.09,1.84,0.94,0.78,-0.97,-1.0,-2.22,-1.97,-1.22,-0.31,1.69,2.5,3.66,4.03,5.84,6.53,8.09,8.56,8.5,7.19,6.75,7.0,8.16,9.25,11.34,12.53,13.44,13.59,13.28,13.16,14.03,14.44,14.12,15.0,15.12,15.78,15.09,15.31,15.44,14.31,12.88,11.53,10.91,9.75,9.47,9.81,9.31,9.16,7.84,7.88,8.25,8.0,8.84,9.78,9.28,8.44,8.16,7.66,8.12,10.0,12.0,14.19,17.53,19.88,20.66,21.31,20.75,18.56,16.34,14.38,12.84,10.69,9.19,8.31,7.47,6.72,6.66,6.47,6.75,7.69,8.28,9.5,10.69,11.19,13.78,15.31,15.5,16.69,16.41,14.88,12.97,12.09,10.38,8.78,8.44,6.62,5.94,5.78,5.56,5.12,5.84,5.72,5.47,4.81,4.44,4.41,3.97,3.62,3.56,3.25,4.12,5.78,6.28,8.81,9.66,11.41,13.44,15.09,17.12,18.09,18.34,18.62,17.88,17.03,17.59,15.84,14.66,14.94,13.5,12.03,11.94,13.22,13.94,15.62,18.06,19.84,21.0,20.56,19.97,18.97,17.31,15.44,15.19,13.44,13.03,12.16,12.0,11.34,11.81,12.97,15.47,17.25,18.66,20.28,20.53,20.72,19.34,17.72,16.69,15.56,14.28,14.38,14.59,14.09,14.0,12.72,12.19,11.59,10.59,10.19,9.72,10.09,9.56,9.59,11.41,11.75,12.41,13.34,13.19,12.91,13.03,12.34,11.78,11.72,11.62,11.41,11.91,12.22,11.28,11.84,11.31,11.03,10.81,11.16,11.31,12.06,12.5,13.62,14.34,15.0,15.06,15.81,14.91,15.56,15.06,13.97,12.72,11.62,10.78,9.5,9.0,7.91,7.28,6.72,5.66,5.62,6.5,7.06,8.03,8.75,9.41,10.03,9.78,10.28,9.81,9.62,8.5,8.25,6.56,5.56,5.47,5.03,6.34,6.5,6.56,7.62,6.25,6.0,5.84,6.44,6.62,7.38,7.59,8.53,8.91,9.81,10.69,11.66,11.81,12.81,12.5,12.12,11.78,11.03,9.56,10.06,8.88,8.06,8.22,7.53,6.25,7.5,7.91,8.56,9.41,9.84,10.03,9.06,9.97,9.62,8.81,9.72,9.59,9.41,9.56,8.59,7.97,7.28,6.41,5.78,6.78,8.53,9.66,11.81,13.56,13.12,14.34,12.72,11.94,11.59,10.94,10.56,10.19,10.19,9.06,8.31,7.56,6.25,6.69,9.44,11.88,15.66,18.81,21.06,20.75,18.78,15.88,12.5,9.5,8.12,7.06,6.19,5.06,3.97,2.28,-0.38,-1.59,-2.03,-2.41,-1.72,0.06,1.06,1.97,3.53,5.41,6.03,7.56,9.0,8.94,9.03,8.97,8.62,10.16,10.62,12.03,12.78,13.25,15.06,14.69,16.19,16.88,16.19,16.44,15.78,15.41,14.53,14.25,14.53,14.69,16.16,18.16,19.53,21.69,22.19,22.06,21.5,20.0,19.06,18.12,18.12,19.31,19.94,20.59,21.19,20.5,20.38,20.31,20.34,20.72,21.84,23.03,23.16,24.5,24.34,24.69,24.53,24.31,24.78,25.31,24.91,25.0,24.53,23.78,23.28,22.88,23.34,22.81,22.97,22.88,22.16,21.62,21.59,20.81,20.38,20.31,20.38,21.19,21.06,21.56,20.91,20.88,20.31,19.44,18.88,17.25,15.56,14.06,12.31,11.16,11.94,12.34,14.44,15.41,16.06,16.84,16.91,16.28,16.22,15.38,15.28,14.5,14.16,15.12,14.28,16.12,17.19,17.25,19.16,20.25,20.56,21.0,21.41,21.84,21.81,20.53,21.44,20.75,20.31,19.94,19.19,18.41,17.78,17.62,17.66,18.31,19.34,21.19,22.88,25.47,28.06,29.84,32.88,34.75,37.19,40.0,41.97,42.41,42.56,41.0,39.34,37.22,33.81,32.12,28.53,26.53,25.12,24.28,25.06,26.47,27.88,30.06,31.5,32.56,33.0,32.69,31.91,31.75,31.19,30.56,31.25,31.19,30.16,30.53,30.31,30.31,31.34,31.81,32.97,33.22,32.94,32.62,31.06,29.78,27.84,26.41,25.53,24.34,23.41,24.53,25.12,27.44,30.62,34.28,36.84,38.22,38.31,37.94,34.88,31.62,28.31,23.81,19.88,15.12,11.5,8.59,6.19,4.41,3.59,2.34,1.94,0.91,-0.53,-0.88,-2.06,-3.25,-3.62,-4.44,-4.75,-4.59,-5.5,-5.5,-5.28,-5.91,-5.78,-5.16,-6.06,-6.38,-5.75,-5.53,-3.16,0.5,4.78,8.94,11.28,11.44,11.91,10.06,7.06,4.5,3.62,2.16,1.66,2.59,3.25,5.72,8.28,9.88,12.94,14.72,15.31,15.56,15.91,13.66,14.78,15.03,15.5,15.78,15.28,12.12:16.5,18.56,19.69,19.31,20.84,21.25,21.06,21.34,21.19,21.72,21.94,22.16,22.38,21.56,20.19,19.97,18.84,19.16,19.47,19.47,19.66,20.16,20.0,21.25,20.94,20.34,20.22,17.91,16.75,15.25,13.41,13.78,12.44,12.25,11.81,10.66,9.12,7.25,5.59,2.88,1.0,0.19,-1.88,-1.59,-1.31,-0.75,-1.56,-0.72,-0.19,-0.09,1.28,3.06,3.5,4.31,4.56,4.53,5.44,4.28,3.19,2.34,1.78,1.41,2.19,3.22,4.12,5.62,7.06,7.94,9.59,10.19,10.09,8.81,8.25,7.66,6.78,7.16,10.25,9.94,11.69,13.0,15.12,15.94,17.91,18.78,20.06,19.81,19.91,19.72,19.72,20.12,20.62,20.56,21.5,20.12,19.44,18.53,18.72,17.06,18.16,18.31,18.34,19.31,19.22,19.25,18.0,16.94,15.38,13.19,11.34,10.53,8.53,7.16,7.44,6.84,6.81,6.28,6.69,6.16,5.41,5.56,5.56,3.78,2.28,1.34,-2.34,-4.28,-6.09,-7.34,-7.91,-8.66,-8.84,-6.69,-4.69,-1.72,2.41,6.66,8.12,9.56,9.56,8.56,6.91,5.5,4.06,2.5,0.31,0.12,-0.53,-0.28,0.88,1.84,2.75,4.44,6.09,8.28,9.16,10.97,11.88,11.38,12.53,12.91,13.41,15.0,15.91,16.03,17.31,18.25,18.0,18.28,18.34,18.28,19.62,21.38,21.72,23.12,23.91,22.78,21.75,19.62,17.88,15.41,13.75,12.19,11.31,10.34,10.0,8.88,8.66,8.59,8.25,9.66,9.5,10.12,10.94,10.75,11.28,11.44,11.78,11.34,10.5,10.0,7.97,5.69,4.03,1.88,0.09,-1.69,-2.44,-2.75,-2.69,-2.16,-1.75,-2.03,-2.5,-3.09,-2.97,-2.38,-1.22,0.09,-0.69,-1.22,-1.09,-2.28,-2.28,-0.84,-1.47,0.0,-0.12,-0.66,-0.69,-1.19,-0.97,-1.47,-2.72,-2.19,-2.03,-2.38,-1.72,-0.94,-0.34,0.03,1.78,2.53,2.94,4.5,5.47,6.22,7.72,8.62,9.19,8.91,8.41,7.06,6.31,5.31,3.81,2.88,2.84,2.78,3.69,5.0,5.62,8.03,7.97,8.94,9.62,10.94,11.66,11.75,12.0,11.0,9.44,7.62,6.0,4.91,3.62,4.22,3.88,4.16,5.44,6.5,6.31,7.69,7.91,7.78,7.69,8.41,7.97,8.84,9.0,8.22,8.69,8.25,8.84,8.97,9.69,10.16,11.0,10.81,12.25,12.44,11.06,10.62,8.12,5.31,2.97,0.28,-1.94,-3.53,-4.62,-4.25,-2.66,-1.03,0.44,1.81,1.25,1.69,1.03,2.16,2.91,2.5,3.16,2.09,1.84,0.94,0.78,-0.97,-1.0,-2.22,-1.97,-1.22,-0.31,1.69,2.5,3.66,4.03,5.84,6.53,8.09,8.56,8.5,7.19,6.75,7.0,8.16,9.25,11.34,12.53,13.44,13.59,13.28,13.16,14.03,14.44,14.12,15.0,15.12,15.78,15.09,15.31,15.44,14.31,12.88,11.53,10.91,9.75,9.47,9.81,9.31,9.16,7.84,7.88,8.25,8.0,8.84,9.78,9.28,8.44,8.16,7.66,8.12,10.0,12.0,14.19,17.53,19.88,20.66,21.31,20.75,18.56,16.34,14.38,12.84,10.69,9.19,8.31,7.47,6.72,6.66,6.47,6.75,7.69,8.28,9.5,10.69,11.19,13.78,15.31,15.5,16.69,16.41,14.88,12.97,12.09,10.38,8.78,8.44,6.62,5.94,5.78,5.56,5.12,5.84,5.72,5.47,4.81,4.44,4.41,3.97,3.62,3.56,3.25,4.12,5.78,6.28,8.81,9.66,11.41,13.44,15.09,17.12,18.09,18.34,18.62,17.88,17.03,17.59,15.84,14.66,14.94,13.5,12.03,11.94,13.22,13.94,15.62,18.06,19.84,21.0,20.56,19.97,18.97,17.31,15.44,15.19,13.44,13.03,12.16,12.0,11.34,11.81,12.97,15.47,17.25,18.66,20.28,20.53,20.72,19.34,17.72,16.69,15.56,14.28,14.38,14.59,14.09,14.0,12.72,12.19,11.59,10.59,10.19,9.72,10.09,9.56,9.59,11.41,11.75,12.41,13.34,13.19,12.91,13.03,12.34,11.78,11.72,11.62,11.41,11.91,12.22,11.28,11.84,11.31,11.03,10.81,11.16,11.31,12.06,12.5,13.62,14.34,15.0,15.06,15.81,14.91,15.56,15.06,13.97,12.72,11.62,10.78,9.5,9.0,7.91,7.28,6.72,5.66,5.62,6.5,7.06,8.03,8.75,9.41,10.03,9.78,10.28,9.81,9.62,8.5,8.25,6.56,5.56,5.47,5.03,6.34,6.5,6.56,7.62,6.25,6.0,5.84,6.44,6.62,7.38,7.59,8.53,8.91,9.81,10.69,11.66,11.81,12.81,12.5,12.12,11.78,11.03,9.56,10.06,8.88,8.06,8.22,7.53,6.25,7.5,7.91,8.56,9.41,9.84,10.03,9.06,9.97,9.62,8.81,9.72,9.59,9.41,9.56,8.59,7.97,7.28,6.41,5.78,6.78,8.53,9.66,11.81,13.56,13.12,14.34,12.72,11.94,11.59,10.94,10.56,10.19,10.19,9.06,8.31,7.56,6.25,6.69,9.44,11.88,15.66,18.81,21.06,20.75,18.78,15.88,12.5,9.5,8.12,7.06,6.19,5.06,3.97,2.28,-0.38,-1.59,-2.03,-2.41,-1.72,0.06,1.06,1.97,3.53,5.41,6.03,7.56,9.0,8.94,9.03,8.97,8.62,10.16,10.62,12.03,12.78,13.25,15.06,14.69,16.19,16.88,16.19,16.44,15.78,15.41,14.53,14.25,14.53,14.69,16.16,18.16,19.53,21.69,22.19,22.06,21.5,20.0,19.06,18.12,18.12,19.31,19.94,20.59,21.19,20.5,20.38,20.31,20.34,20.72,21.84,23.03,23.16,24.5,24.34,24.69,24.53,24.31,24.78,25.31,24.91,25.0,24.53,23.78,23.28,22.88,23.34,22.81,22.97,22.88,22.16,21.62,21.59,20.81,20.38,20.31,20.38,21.19,21.06,21.56,20.91,20.88,20.31,19.44,18.88,17.25,15.56,14.06,12.31,11.16,11.94,12.34,14.44,15.41,16.06,16.84,16.91,16.28,16.22,15.38,15.28,14.5,14.16,15.12,14.28,16.12,17.19,17.25,19.16,20.25,20.56,21.0,21.41,21.84,21.81,20.53,21.44,20.75,20.31,19.94,19.19,18.41,17.78,17.62,17.66,18.31,19.34,21.19,22.88,25.47,28.06,29.84,32.88,34.75,37.19,40.0,41.97,42.41,42.56,41.0,39.34,37.22,33.81,32.12,28.53,26.53,25.12,24.28,25.06,26.47,27.88,30.06,31.5,32.56,33.0,32.69,31.91,31.75,31.19,30.56,31.25,31.19,30.16,30.53,30.31,30.31,31.34,31.81,32.97,33.22,32.94,32.62,31.06,29.78,27.84,26.41,25.53,24.34,23.41,24.53,25.12,27.44,30.62,34.28,36.84,38.22,38.31,37.94,34.88,31.62,28.31,23.81,19.88,15.12,11.5,8.59,6.19,4.41,3.59,2.34,1.94,0.91,-0.53,-0.88,-2.06,-3.25,-3.62,-4.44,-4.75,-4.59,-5.5,-5.5,-5.28,-5.91,-5.78,-5.16,-6.06,-6.38,-5.75,-5.53,-3.16,0.5,4.78,8.94,11.28,11.44,11.91,10.06,7.06,4.5,3.62,2.16,1.66,2.59,3.25,5.72,8.28,9.88,12.94,14.72,15.31,15.56,15.91,13.66,14.78,15.03,15.5,15.78,15.28,12.12,8.66,6.09,3.0,3.59,5.25,6.06:positivity
18.22,20.28,20.5,19.38,18.41,15.0,13.91,12.91,12.66,12.97,13.19,13.0,12.75,13.31,13.41,14.5,14.44,16.09,17.5,18.0,19.16,20.41,21.31,20.22,20.31,17.47,16.41,14.62,15.03,16.53,18.69,20.69,21.62,21.31,19.69,17.31,14.62,14.0,12.66,13.53,14.72,19.38,23.91,30.06,35.59,39.41,41.62,42.56,42.03,39.03,35.66,31.84,26.5,23.69,19.19,17.09,16.0,15.5,16.78,17.72,19.31,21.03,19.88,20.28,19.44,20.34,21.03,21.84,22.31,21.78,23.06,22.75,22.81,22.81,22.16,19.78,18.19,16.84,15.31,15.03,15.41,14.94,14.81,14.25,14.62,14.44,15.81,16.5,18.34,19.41,22.41,23.44,24.88,26.56,27.78,28.25,29.03,28.78,27.91,26.94,25.38,23.81,22.16,21.03,21.34,21.81,22.22,22.53,23.81,24.91,24.34,25.12,26.56,28.0,28.16,29.81,31.94,34.34,37.19,39.66,42.31,42.88,41.28,38.44,34.25,31.06,28.47,27.34,28.12,29.41,28.66,29.0,29.56,28.38,29.41,30.44,31.09,32.03,33.28,33.88,36.31,38.22,40.94,43.34,45.72,46.38,46.28,44.19,42.69,39.12,36.06,33.47,31.53,29.69,27.75,25.22,25.25,24.34,25.06,26.5,28.06,29.34,29.84,31.25,32.31,34.75,36.75,38.91,38.69,37.62,35.56,32.06,30.5,27.38,25.84,25.69,24.38,23.91,24.16,23.97,25.06,26.06,26.72,26.56,26.53,26.28,24.38,23.25,22.34,22.06,21.91,22.56,22.88,24.5,26.16,27.66,28.53,28.94,29.09,28.19,26.56,24.88,23.72,22.59,22.03,21.22,20.5,19.31,19.38,18.72,19.09,20.03,20.91,23.34,24.31,25.59,25.56,25.94,24.56,22.81,21.38,20.16,19.12,19.5,18.62,18.5,17.88,17.84,17.91,19.19,21.62,25.06,29.66,35.09,38.69,41.69,43.28,42.34,40.5,38.41,36.22,34.16,32.34,29.09,26.62,24.28,22.78,22.22,21.97,22.91,23.22,24.31,24.97,25.62,25.75,26.31,25.41,24.62,24.53,24.78,25.31,26.56,29.0,30.81,32.81,34.62,34.41,33.25,30.69,28.12,26.31,24.19,23.72,23.44,23.78,24.34,24.84,26.19,27.31,27.94,28.06,27.88,27.19,26.16,27.25,27.97,30.12,31.56,34.59,35.16,35.97,34.25,32.53,30.53,28.5,26.94,27.16,27.59,28.66,30.28,30.81,32.0,32.75,33.38,33.41,33.31,32.78,32.38,32.62,33.69,34.31,35.06,35.75,35.59,35.22,34.12,32.81,31.47,29.19,26.75,24.19,21.88,21.56,21.28,21.94,23.0,23.66,23.06,22.06,20.28,18.09,16.84,16.0,15.78,16.03,18.44,19.56,21.06,21.47,21.12,19.22,18.22,16.62,15.81,16.81,17.03,19.28,21.16,21.94,24.5,25.47,25.84,26.53,25.66,25.19,24.34,23.31,22.41,22.44,22.62,23.84,24.75,25.84,26.09,24.66,22.0,18.59,15.62,11.84,10.09,9.06,9.19,9.84,10.81,12.78,13.44,14.91,14.47,14.19,12.31,10.81,9.38,8.94,8.41,9.19,9.0,8.53,7.62,6.34,6.03,5.97,5.62,7.38,8.88,10.81,14.31,16.38,19.53,20.66,22.41,21.91,21.41,21.31,20.41,20.53,22.19,23.06,23.94,25.88,27.44,28.28,29.12,29.38,29.12,29.41,28.06,28.41,28.34,27.56,27.06,25.44,23.72,22.34,20.5,20.91,20.75,21.31,23.66,26.0,28.47,30.53,33.16,35.12,36.53,36.09,35.03,31.78,27.94,23.81,20.5,18.53,18.62,18.72,19.41,19.81,21.44,22.62,23.44,24.31,25.91,27.03,28.5,30.03,32.0,33.41,34.03,34.97,32.59,31.16,28.88,26.06,24.16,23.0,21.97,22.31,22.5,21.62,21.81,21.62,21.78,21.03,20.62,19.88,19.22,19.31,20.91,21.75,23.38,24.12,24.28,25.38,26.03,26.12,27.34,27.59,27.44,27.12,26.19,26.0,25.47,25.19,25.81,25.75,25.69,25.81,25.44,24.66,24.03,23.84,23.47,23.5,22.5,23.16,24.16,25.19,26.41,28.28,30.66,32.75,33.69,35.75,36.0,36.06,35.56,33.59,31.5,28.34,24.97,21.94,18.69,16.69,15.81,16.19,16.41,17.34,18.34,19.38,20.06,23.22,24.72,26.16,27.19,27.38,26.44,25.03,23.84,23.88,24.78,24.81,24.59,24.25,22.69,21.16,18.81,18.81,18.31,18.66,19.62,20.5,20.06,20.44,19.78,18.69,18.12,17.03,17.94,16.81,16.91,17.12,18.0,18.69,19.09,18.75,17.28,15.41,12.81,11.53,10.0,8.62,8.78,8.84,9.41,10.72,12.91,14.41,15.94,17.25,18.16,18.94,20.0,20.62,20.56,20.78,20.06,20.0,19.5,19.16,18.34,19.06,18.81,18.44,17.16,15.97,14.66,12.31,10.47,9.62,9.56,9.66,10.62,11.91,12.81,14.25,15.28,15.97,16.84,17.41,18.31,18.5,18.78,18.31,17.69,16.12,14.56,14.03,14.22,14.91,17.25,19.38,20.34,22.22,22.78,22.78,23.09,23.97,24.28,25.5,27.12,28.0,27.94,27.41,25.66,23.44,20.84,19.31,18.91,18.44,19.06,18.97,18.12,17.25,16.06,13.94,13.69,12.38,13.56,13.84,15.06,14.84,15.44,16.03,16.69,17.66,19.84,21.5,22.38,22.91,21.97,19.62,18.69,16.44,14.66,12.81,11.31,11.22,10.91,12.5,14.44,18.34,22.38,25.38,27.03,27.72,26.44,24.16,21.91,20.09,19.25,18.41,18.34,17.53,16.03,15.31,14.41,13.03,11.94,10.84,9.94,9.94,9.19,9.62,10.0,9.94,9.12,8.91,6.84,7.03,7.25,6.78,8.5,10.25,12.62,16.12,18.06,18.84,18.31,16.44,13.91,10.75,8.41,6.09,5.09,4.53,4.19,4.72,6.31,7.44,8.84,8.91,7.72,6.44,5.0,4.31,4.81,6.38,8.19,10.56,12.25,13.03,13.34,13.56,13.53,12.78,12.59,12.03,11.97,11.94,12.03,13.38,14.19,14.91,14.78,14.16,13.16,11.81,10.75,8.94,8.41,7.88,9.03,10.41,13.44,15.34,17.19,18.53,18.69,17.66,16.69,15.41,13.88,12.06,10.81,9.84,9.34,8.91,8.66,8.84,9.41,10.62,11.72,13.22,15.69,17.81,19.66,21.53,21.72,21.81,21.03,20.69,19.06,18.38,17.62,16.56,15.25,14.59,13.38,11.84,10.56,8.91,5.69,3.38,1.5,-0.44,-0.88,-0.38,0.12,1.97,3.03,5.5,7.97,10.06,11.81,13.12,12.78,11.56,9.62,8.53,6.31,5.56,4.38,3.59,2.19,-0.28,-2.44,-5.53,-7.66,-9.28,-8.84,-8.19,-6.16,-3.16,-0.22,2.41,4.78,6.5,8.25,9.31,10.81,11.25,11.19,11.12,9.91,8.16,6.78,5.41,3.41,1.44,-0.09,-1.94,-3.09,-3.34,-3.38,-3.09,-2.62,-2.03,-0.94,-0.66,0.56,2.03,3.09,5.03,5.56,5.53,5.81,5.47,4.78,4.69,4.12,4.5,3.19,2.75,2.5,2.69,3.69,5.44,7.69,8.69,9.06,9.16,7.44,5.84,4.25,2.5,0.22,-1.22,-2.59,-4.16,-5.53,-6.41,-8.19,-9.28,-9.84,-10.03,-10.44,-9.88,-9.69,-9.59,-9.16,-8.34,-7.72,-7.09,-6.09,-6.03,-5.88,-6.41,-5.91:13.91,12.91,12.66,12.97,13.19,13.0,12.75,13.31,13.41,14.5,14.44,16.09,17.5,18.0,19.16,20.41,21.31,20.22,20.31,17.47,16.41,14.62,15.03,16.53,18.69,20.69,21.62,21.31,19.69,17.31,14.62,14.0,12.66,13.53,14.72,19.38,23.91,30.06,35.59,39.41,41.62,42.56,42.03,39.03,35.66,31.84,26.5,23.69,19.19,17.09,16.0,15.5,16.78,17.72,19.31,21.03,19.88,20.28,19.44,20.34,21.03,21.84,22.31,21.78,23.06,22.75,22.81,22.81,22.16,19.78,18.19,16.84,15.31,15.03,15.41,14.94,14.81,14.25,14.62,14.44,15.81,16.5,18.34,19.41,22.41,23.44,24.88,26.56,27.78,28.25,29.03,28.78,27.91,26.94,25.38,23.81,22.16,21.03,21.34,21.81,22.22,22.53,23.81,24.91,24.34,25.12,26.56,28.0,28.16,29.81,31.94,34.34,37.19,39.66,42.31,42.88,41.28,38.44,34.25,31.06,28.47,27.34,28.12,29.41,28.66,29.0,29.56,28.38,29.41,30.44,31.09,32.03,33.28,33.88,36.31,38.22,40.94,43.34,45.72,46.38,46.28,44.19,42.69,39.12,36.06,33.47,31.53,29.69,27.75,25.22,25.25,24.34,25.06,26.5,28.06,29.34,29.84,31.25,32.31,34.75,36.75,38.91,38.69,37.62,35.56,32.06,30.5,27.38,25.84,25.69,24.38,23.91,24.16,23.97,25.06,26.06,26.72,26.56,26.53,26.28,24.38,23.25,22.34,22.06,21.91,22.56,22.88,24.5,26.16,27.66,28.53,28.94,29.09,28.19,26.56,24.88,23.72,22.59,22.03,21.22,20.5,19.31,19.38,18.72,19.09,20.03,20.91,23.34,24.31,25.59,25.56,25.94,24.56,22.81,21.38,20.16,19.12,19.5,18.62,18.5,17.88,17.84,17.91,19.19,21.62,25.06,29.66,35.09,38.69,41.69,43.28,42.34,40.5,38.41,36.22,34.16,32.34,29.09,26.62,24.28,22.78,22.22,21.97,22.91,23.22,24.31,24.97,25.62,25.75,26.31,25.41,24.62,24.53,24.78,25.31,26.56,29.0,30.81,32.81,34.62,34.41,33.25,30.69,28.12,26.31,24.19,23.72,23.44,23.78,24.34,24.84,26.19,27.31,27.94,28.06,27.88,27.19,26.16,27.25,27.97,30.12,31.56,34.59,35.16,35.97,34.25,32.53,30.53,28.5,26.94,27.16,27.59,28.66,30.28,30.81,32.0,32.75,33.38,33.41,33.31,32.78,32.38,32.62,33.69,34.31,35.06,35.75,35.59,35.22,34.12,32.81,31.47,29.19,26.75,24.19,21.88,21.56,21.28,21.94,23.0,23.66,23.06,22.06,20.28,18.09,16.84,16.0,15.78,16.03,18.44,19.56,21.06,21.47,21.12,19.22,18.22,16.62,15.81,16.81,17.03,19.28,21.16,21.94,24.5,25.47,25.84,26.53,25.66,25.19,24.34,23.31,22.41,22.44,22.62,23.84,24.75,25.84,26.09,24.66,22.0,18.59,15.62,11.84,10.09,9.06,9.19,9.84,10.81,12.78,13.44,14.91,14.47,14.19,12.31,10.81,9.38,8.94,8.41,9.19,9.0,8.53,7.62,6.34,6.03,5.97,5.62,7.38,8.88,10.81,14.31,16.38,19.53,20.66,22.41,21.91,21.41,21.31,20.41,20.53,22.19,23.06,23.94,25.88,27.44,28.28,29.12,29.38,29.12,29.41,28.06,28.41,28.34,27.56,27.06,25.44,23.72,22.34,20.5,20.91,20.75,21.31,23.66,26.0,28.47,30.53,33.16,35.12,36.53,36.09,35.03,31.78,27.94,23.81,20.5,18.53,18.62,18.72,19.41,19.81,21.44,22.62,23.44,24.31,25.91,27.03,28.5,30.03,32.0,33.41,34.03,34.97,32.59,31.16,28.88,26.06,24.16,23.0,21.97,22.31,22.5,21.62,21.81,21.62,21.78,21.03,20.62,19.88,19.22,19.31,20.91,21.75,23.38,24.12,24.28,25.38,26.03,26.12,27.34,27.59,27.44,27.12,26.19,26.0,25.47,25.19,25.81,25.75,25.69,25.81,25.44,24.66,24.03,23.84,23.47,23.5,22.5,23.16,24.16,25.19,26.41,28.28,30.66,32.75,33.69,35.75,36.0,36.06,35.56,33.59,31.5,28.34,24.97,21.94,18.69,16.69,15.81,16.19,16.41,17.34,18.34,19.38,20.06,23.22,24.72,26.16,27.19,27.38,26.44,25.03,23.84,23.88,24.78,24.81,24.59,24.25,22.69,21.16,18.81,18.81,18.31,18.66,19.62,20.5,20.06,20.44,19.78,18.69,18.12,17.03,17.94,16.81,16.91,17.12,18.0,18.69,19.09,18.75,17.28,15.41,12.81,11.53,10.0,8.62,8.78,8.84,9.41,10.72,12.91,14.41,15.94,17.25,18.16,18.94,20.0,20.62,20.56,20.78,20.06,20.0,19.5,19.16,18.34,19.06,18.81,18.44,17.16,15.97,14.66,12.31,10.47,9.62,9.56,9.66,10.62,11.91,12.81,14.25,15.28,15.97,16.84,17.41,18.31,18.5,18.78,18.31,17.69,16.12,14.56,14.03,14.22,14.91,17.25,19.38,20.34,22.22,22.78,22.78,23.09,23.97,24.28,25.5,27.12,28.0,27.94,27.41,25.66,23.44,20.84,19.31,18.91,18.44,19.06,18.97,18.12,17.25,16.06,13.94,13.69,12.38,13.56,13.84,15.06,14.84,15.44,16.03,16.69,17.66,19.84,21.5,22.38,22.91,21.97,19.62,18.69,16.44,14.66,12.81,11.31,11.22,10.91,12.5,14.44,18.34,22.38,25.38,27.03,27.72,26.44,24.16,21.91,20.09,19.25,18.41,18.34,17.53,16.03,15.31,14.41,13.03,11.94,10.84,9.94,9.94,9.19,9.62,10.0,9.94,9.12,8.91,6.84,7.03,7.25,6.78,8.5,10.25,12.62,16.12,18.06,18.84,18.31,16.44,13.91,10.75,8.41,6.09,5.09,4.53,4.19,4.72,6.31,7.44,8.84,8.91,7.72,6.44,5.0,4.31,4.81,6.38,8.19,10.56,12.25,13.03,13.34,13.56,13.53,12.78,12.59,12.03,11.97,11.94,12.03,13.38,14.19,14.91,14.78,14.16,13.16,11.81,10.75,8.94,8.41,7.88,9.03,10.41,13.44,15.34,17.19,18.53,18.69,17.66,16.69,15.41,13.88,12.06,10.81,9.84,9.34,8.91,8.66,8.84,9.41,10.62,11.72,13.22,15.69,17.81,19.66,21.53,21.72,21.81,21.03,20.69,19.06,18.38,17.62,16.56,15.25,14.59,13.38,11.84,10.56,8.91,5.69,3.38,1.5,-0.44,-0.88,-0.38,0.12,1.97,3.03,5.5,7.97,10.06,11.81,13.12,12.78,11.56,9.62,8.53,6.31,5.56,4.38,3.59,2.19,-0.28,-2.44,-5.53,-7.66,-9.28,-8.84,-8.19,-6.16,-3.16,-0.22,2.41,4.78,6.5,8.25,9.31,10.81,11.25,11.19,11.12,9.91,8.16,6.78,5.41,3.41,1.44,-0.09,-1.94,-3.09,-3.34,-3.38,-3.09,-2.62,-2.03,-0.94,-0.66,0.56,2.03,3.09,5.03,5.56,5.53,5.81,5.47,4.78,4.69,4.12,4.5,3.19,2.75,2.5,2.69,3.69,5.44,7.69,8.69,9.06,9.16,7.44,5.84,4.25,2.5,0.22,-1.22,-2.59,-4.16,-5.53,-6.41,-8.19,-9.28,-9.84,-10.03,-10.44,-9.88,-9.69,-9.59,-9.16,-8.34,-7.72,-7.09,-6.09,-6.03,-5.88,-6.41,-5.91,-0.34,-3.03,-4.91,-7.38,-6.19,-5.81:12.75,13.31,13.41,14.5,14.44,16.09,17.5,18.0,19.16,20.41,21.31,20.22,20.31,17.47,16.41,14.62,15.03,16.53,18.69,20.69,21.62,21.31,19.69,17.31,14.62,14.0,12.66,13.53,14.72,19.38,23.91,30.06,35.59,39.41,41.62,42.56,42.03,39.03,35.66,31.84,26.5,23.69,19.19,17.09,16.0,15.5,16.78,17.72,19.31,21.03,19.88,20.28,19.44,20.34,21.03,21.84,22.31,21.78,23.06,22.75,22.81,22.81,22.16,19.78,18.19,16.84,15.31,15.03,15.41,14.94,14.81,14.25,14.62,14.44,15.81,16.5,18.34,19.41,22.41,23.44,24.88,26.56,27.78,28.25,29.03,28.78,27.91,26.94,25.38,23.81,22.16,21.03,21.34,21.81,22.22,22.53,23.81,24.91,24.34,25.12,26.56,28.0,28.16,29.81,31.94,34.34,37.19,39.66,42.31,42.88,41.28,38.44,34.25,31.06,28.47,27.34,28.12,29.41,28.66,29.0,29.56,28.38,29.41,30.44,31.09,32.03,33.28,33.88,36.31,38.22,40.94,43.34,45.72,46.38,46.28,44.19,42.69,39.12,36.06,33.47,31.53,29.69,27.75,25.22,25.25,24.34,25.06,26.5,28.06,29.34,29.84,31.25,32.31,34.75,36.75,38.91,38.69,37.62,35.56,32.06,30.5,27.38,25.84,25.69,24.38,23.91,24.16,23.97,25.06,26.06,26.72,26.56,26.53,26.28,24.38,23.25,22.34,22.06,21.91,22.56,22.88,24.5,26.16,27.66,28.53,28.94,29.09,28.19,26.56,24.88,23.72,22.59,22.03,21.22,20.5,19.31,19.38,18.72,19.09,20.03,20.91,23.34,24.31,25.59,25.56,25.94,24.56,22.81,21.38,20.16,19.12,19.5,18.62,18.5,17.88,17.84,17.91,19.19,21.62,25.06,29.66,35.09,38.69,41.69,43.28,42.34,40.5,38.41,36.22,34.16,32.34,29.09,26.62,24.28,22.78,22.22,21.97,22.91,23.22,24.31,24.97,25.62,25.75,26.31,25.41,24.62,24.53,24.78,25.31,26.56,29.0,30.81,32.81,34.62,34.41,33.25,30.69,28.12,26.31,24.19,23.72,23.44,23.78,24.34,24.84,26.19,27.31,27.94,28.06,27.88,27.19,26.16,27.25,27.97,30.12,31.56,34.59,35.16,35.97,34.25,32.53,30.53,28.5,26.94,27.16,27.59,28.66,30.28,30.81,32.0,32.75,33.38,33.41,33.31,32.78,32.38,32.62,33.69,34.31,35.06,35.75,35.59,35.22,34.12,32.81,31.47,29.19,26.75,24.19,21.88,21.56,21.28,21.94,23.0,23.66,23.06,22.06,20.28,18.09,16.84,16.0,15.78,16.03,18.44,19.56,21.06,21.47,21.12,19.22,18.22,16.62,15.81,16.81,17.03,19.28,21.16,21.94,24.5,25.47,25.84,26.53,25.66,25.19,24.34,23.31,22.41,22.44,22.62,23.84,24.75,25.84,26.09,24.66,22.0,18.59,15.62,11.84,10.09,9.06,9.19,9.84,10.81,12.78,13.44,14.91,14.47,14.19,12.31,10.81,9.38,8.94,8.41,9.19,9.0,8.53,7.62,6.34,6.03,5.97,5.62,7.38,8.88,10.81,14.31,16.38,19.53,20.66,22.41,21.91,21.41,21.31,20.41,20.53,22.19,23.06,23.94,25.88,27.44,28.28,29.12,29.38,29.12,29.41,28.06,28.41,28.34,27.56,27.06,25.44,23.72,22.34,20.5,20.91,20.75,21.31,23.66,26.0,28.47,30.53,33.16,35.12,36.53,36.09,35.03,31.78,27.94,23.81,20.5,18.53,18.62,18.72,19.41,19.81,21.44,22.62,23.44,24.31,25.91,27.03,28.5,30.03,32.0,33.41,34.03,34.97,32.59,31.16,28.88,26.06,24.16,23.0,21.97,22.31,22.5,21.62,21.81,21.62,21.78,21.03,20.62,19.88,19.22,19.31,20.91,21.75,23.38,24.12,24.28,25.38,26.03,26.12,27.34,27.59,27.44,27.12,26.19,26.0,25.47,25.19,25.81,25.75,25.69,25.81,25.44,24.66,24.03,23.84,23.47,23.5,22.5,23.16,24.16,25.19,26.41,28.28,30.66,32.75,33.69,35.75,36.0,36.06,35.56,33.59,31.5,28.34,24.97,21.94,18.69,16.69,15.81,16.19,16.41,17.34,18.34,19.38,20.06,23.22,24.72,26.16,27.19,27.38,26.44,25.03,23.84,23.88,24.78,24.81,24.59,24.25,22.69,21.16,18.81,18.81,18.31,18.66,19.62,20.5,20.06,20.44,19.78,18.69,18.12,17.03,17.94,16.81,16.91,17.12,18.0,18.69,19.09,18.75,17.28,15.41,12.81,11.53,10.0,8.62,8.78,8.84,9.41,10.72,12.91,14.41,15.94,17.25,18.16,18.94,20.0,20.62,20.56,20.78,20.06,20.0,19.5,19.16,18.34,19.06,18.81,18.44,17.16,15.97,14.66,12.31,10.47,9.62,9.56,9.66,10.62,11.91,12.81,14.25,15.28,15.97,16.84,17.41,18.31,18.5,18.78,18.31,17.69,16.12,14.56,14.03,14.22,14.91,17.25,19.38,20.34,22.22,22.78,22.78,23.09,23.97,24.28,25.5,27.12,28.0,27.94,27.41,25.66,23.44,20.84,19.31,18.91,18.44,19.06,18.97,18.12,17.25,16.06,13.94,13.69,12.38,13.56,13.84,15.06,14.84,15.44,16.03,16.69,17.66,19.84,21.5,22.38,22.91,21.97,19.62,18.69,16.44,14.66,12.81,11.31,11.22,10.91,12.5,14.44,18.34,22.38,25.38,27.03,27.72,26.44,24.16,21.91,20.09,19.25,18.41,18.34,17.53,16.03,15.31,14.41,13.03,11.94,10.84,9.94,9.94,9.19,9.62,10.0,9.94,9.12,8.91,6.84,7.03,7.25,6.78,8.5,10.25,12.62,16.12,18.06,18.84,18.31,16.44,13.91,10.75,8.41,6.09,5.09,4.53,4.19,4.72,6.31,7.44,8.84,8.91,7.72,6.44,5.0,4.31,4.81,6.38,8.19,10.56,12.25,13.03,13.34,13.56,13.53,12.78,12.59,12.03,11.97,11.94,12.03,13.38,14.19,14.91,14.78,14.16,13.16,11.81,10.75,8.94,8.41,7.88,9.03,10.41,13.44,15.34,17.19,18.53,18.69,17.66,16.69,15.41,13.88,12.06,10.81,9.84,9.34,8.91,8.66,8.84,9.41,10.62,11.72,13.22,15.69,17.81,19.66,21.53,21.72,21.81,21.03,20.69,19.06,18.38,17.62,16.56,15.25,14.59,13.38,11.84,10.56,8.91,5.69,3.38,1.5,-0.44,-0.88,-0.38,0.12,1.97,3.03,5.5,7.97,10.06,11.81,13.12,12.78,11.56,9.62,8.53,6.31,5.56,4.38,3.59,2.19,-0.28,-2.44,-5.53,-7.66,-9.28,-8.84,-8.19,-6.16,-3.16,-0.22,2.41,4.78,6.5,8.25,9.31,10.81,11.25,11.19,11.12,9.91,8.16,6.78,5.41,3.41,1.44,-0.09,-1.94,-3.09,-3.34,-3.38,-3.09,-2.62,-2.03,-0.94,-0.66,0.56,2.03,3.09,5.03,5.56,5.53,5.81,5.47,4.78,4.69,4.12,4.5,3.19,2.75,2.5,2.69,3.69,5.44,7.69,8.69,9.06,9.16,7.44,5.84,4.25,2.5,0.22,-1.22,-2.59,-4.16,-5.53,-6.41,-8.19,-9.28,-9.84,-10.03,-10.44,-9.88,-9.69,-9.59,-9.16,-8.34,-7.72,-7.09,-6.09,-6.03,-5.88,-6.41,-5.91,-0.34,-3.03,-4.91,-7.38,-6.19,-5.81,-3.84,-2.19,-1.22,0.66,1.09,1.34:17.5,18.0,19.16,20.41,21.31,20.22,20.31,17.47,16.41,14.62,15.03,16.53,18.69,20.69,21.62,21.31,19.69,17.31,14.62,14.0,12.66,13.53,14.72,19.38,23.91,30.06,35.59,39.41,41.62,42.56,42.03,39.03,35.66,31.84,26.5,23.69,19.19,17.09,16.0,15.5,16.78,17.72,19.31,21.03,19.88,20.28,19.44,20.34,21.03,21.84,22.31,21.78,23.06,22.75,22.81,22.81,22.16,19.78,18.19,16.84,15.31,15.03,15.41,14.94,14.81,14.25,14.62,14.44,15.81,16.5,18.34,19.41,22.41,23.44,24.88,26.56,27.78,28.25,29.03,28.78,27.91,26.94,25.38,23.81,22.16,21.03,21.34,21.81,22.22,22.53,23.81,24.91,24.34,25.12,26.56,28.0,28.16,29.81,31.94,34.34,37.19,39.66,42.31,42.88,41.28,38.44,34.25,31.06,28.47,27.34,28.12,29.41,28.66,29.0,29.56,28.38,29.41,30.44,31.09,32.03,33.28,33.88,36.31,38.22,40.94,43.34,45.72,46.38,46.28,44.19,42.69,39.12,36.06,33.47,31.53,29.69,27.75,25.22,25.25,24.34,25.06,26.5,28.06,29.34,29.84,31.25,32.31,34.75,36.75,38.91,38.69,37.62,35.56,32.06,30.5,27.38,25.84,25.69,24.38,23.91,24.16,23.97,25.06,26.06,26.72,26.56,26.53,26.28,24.38,23.25,22.34,22.06,21.91,22.56,22.88,24.5,26.16,27.66,28.53,28.94,29.09,28.19,26.56,24.88,23.72,22.59,22.03,21.22,20.5,19.31,19.38,18.72,19.09,20.03,20.91,23.34,24.31,25.59,25.56,25.94,24.56,22.81,21.38,20.16,19.12,19.5,18.62,18.5,17.88,17.84,17.91,19.19,21.62,25.06,29.66,35.09,38.69,41.69,43.28,42.34,40.5,38.41,36.22,34.16,32.34,29.09,26.62,24.28,22.78,22.22,21.97,22.91,23.22,24.31,24.97,25.62,25.75,26.31,25.41,24.62,24.53,24.78,25.31,26.56,29.0,30.81,32.81,34.62,34.41,33.25,30.69,28.12,26.31,24.19,23.72,23.44,23.78,24.34,24.84,26.19,27.31,27.94,28.06,27.88,27.19,26.16,27.25,27.97,30.12,31.56,34.59,35.16,35.97,34.25,32.53,30.53,28.5,26.94,27.16,27.59,28.66,30.28,30.81,32.0,32.75,33.38,33.41,33.31,32.78,32.38,32.62,33.69,34.31,35.06,35.75,35.59,35.22,34.12,32.81,31.47,29.19,26.75,24.19,21.88,21.56,21.28,21.94,23.0,23.66,23.06,22.06,20.28,18.09,16.84,16.0,15.78,16.03,18.44,19.56,21.06,21.47,21.12,19.22,18.22,16.62,15.81,16.81,17.03,19.28,21.16,21.94,24.5,25.47,25.84,26.53,25.66,25.19,24.34,23.31,22.41,22.44,22.62,23.84,24.75,25.84,26.09,24.66,22.0,18.59,15.62,11.84,10.09,9.06,9.19,9.84,10.81,12.78,13.44,14.91,14.47,14.19,12.31,10.81,9.38,8.94,8.41,9.19,9.0,8.53,7.62,6.34,6.03,5.97,5.62,7.38,8.88,10.81,14.31,16.38,19.53,20.66,22.41,21.91,21.41,21.31,20.41,20.53,22.19,23.06,23.94,25.88,27.44,28.28,29.12,29.38,29.12,29.41,28.06,28.41,28.34,27.56,27.06,25.44,23.72,22.34,20.5,20.91,20.75,21.31,23.66,26.0,28.47,30.53,33.16,35.12,36.53,36.09,35.03,31.78,27.94,23.81,20.5,18.53,18.62,18.72,19.41,19.81,21.44,22.62,23.44,24.31,25.91,27.03,28.5,30.03,32.0,33.41,34.03,34.97,32.59,31.16,28.88,26.06,24.16,23.0,21.97,22.31,22.5,21.62,21.81,21.62,21.78,21.03,20.62,19.88,19.22,19.31,20.91,21.75,23.38,24.12,24.28,25.38,26.03,26.12,27.34,27.59,27.44,27.12,26.19,26.0,25.47,25.19,25.81,25.75,25.69,25.81,25.44,24.66,24.03,23.84,23.47,23.5,22.5,23.16,24.16,25.19,26.41,28.28,30.66,32.75,33.69,35.75,36.0,36.06,35.56,33.59,31.5,28.34,24.97,21.94,18.69,16.69,15.81,16.19,16.41,17.34,18.34,19.38,20.06,23.22,24.72,26.16,27.19,27.38,26.44,25.03,23.84,23.88,24.78,24.81,24.59,24.25,22.69,21.16,18.81,18.81,18.31,18.66,19.62,20.5,20.06,20.44,19.78,18.69,18.12,17.03,17.94,16.81,16.91,17.12,18.0,18.69,19.09,18.75,17.28,15.41,12.81,11.53,10.0,8.62,8.78,8.84,9.41,10.72,12.91,14.41,15.94,17.25,18.16,18.94,20.0,20.62,20.56,20.78,20.06,20.0,19.5,19.16,18.34,19.06,18.81,18.44,17.16,15.97,14.66,12.31,10.47,9.62,9.56,9.66,10.62,11.91,12.81,14.25,15.28,15.97,16.84,17.41,18.31,18.5,18.78,18.31,17.69,16.12,14.56,14.03,14.22,14.91,17.25,19.38,20.34,22.22,22.78,22.78,23.09,23.97,24.28,25.5,27.12,28.0,27.94,27.41,25.66,23.44,20.84,19.31,18.91,18.44,19.06,18.97,18.12,17.25,16.06,13.94,13.69,12.38,13.56,13.84,15.06,14.84,15.44,16.03,16.69,17.66,19.84,21.5,22.38,22.91,21.97,19.62,18.69,16.44,14.66,12.81,11.31,11.22,10.91,12.5,14.44,18.34,22.38,25.38,27.03,27.72,26.44,24.16,21.91,20.09,19.25,18.41,18.34,17.53,16.03,15.31,14.41,13.03,11.94,10.84,9.94,9.94,9.19,9.62,10.0,9.94,9.12,8.91,6.84,7.03,7.25,6.78,8.5,10.25,12.62,16.12,18.06,18.84,18.31,16.44,13.91,10.75,8.41,6.09,5.09,4.53,4.19,4.72,6.31,7.44,8.84,8.91,7.72,6.44,5.0,4.31,4.81,6.38,8.19,10.56,12.25,13.03,13.34,13.56,13.53,12.78,12.59,12.03,11.97,11.94,12.03,13.38,14.19,14.91,14.78,14.16,13.16,11.81,10.75,8.94,8.41,7.88,9.03,10.41,13.44,15.34,17.19,18.53,18.69,17.66,16.69,15.41,13.88,12.06,10.81,9.84,9.34,8.91,8.66,8.84,9.41,10.62,11.72,13.22,15.69,17.81,19.66,21.53,21.72,21.81,21.03,20.69,19.06,18.38,17.62,16.56,15.25,14.59,13.38,11.84,10.56,8.91,5.69,3.38,1.5,-0.44,-0.88,-0.38,0.12,1.97,3.03,5.5,7.97,10.06,11.81,13.12,12.78,11.56,9.62,8.53,6.31,5.56,4.38,3.59,2.19,-0.28,-2.44,-5.53,-7.66,-9.28,-8.84,-8.19,-6.16,-3.16,-0.22,2.41,4.78,6.5,8.25,9.31,10.81,11.25,11.19,11.12,9.91,8.16,6.78,5.41,3.41,1.44,-0.09,-1.94,-3.09,-3.34,-3.38,-3.09,-2.62,-2.03,-0.94,-0.66,0.56,2.03,3.09,5.03,5.56,5.53,5.81,5.47,4.78,4.69,4.12,4.5,3.19,2.75,2.5,2.69,3.69,5.44,7.69,8.69,9.06,9.16,7.44,5.84,4.25,2.5,0.22,-1.22,-2.59,-4.16,-5.53,-6.41,-8.19,-9.28,-9.84,-10.03,-10.44,-9.88,-9.69,-9.59,-9.16,-8.34,-7.72,-7.09,-6.09,-6.03,-5.88,-6.41,-5.91,-0.34,-3.03,-4.91,-7.38,-6.19,-5.81,-3.84,-2.19,-1.22,0.66,1.09,1.34,1.56,2.56,2.84,5.5,6.12,8.38:20.31,17.47,16.41,14.62,15.03,16.53,18.69,20.69,21.62,21.31,19.69,17.31,14.62,14.0,12.66,13.53,14.72,19.38,23.91,30.06,35.59,39.41,41.62,42.56,42.03,39.03,35.66,31.84,26.5,23.69,19.19,17.09,16.0,15.5,16.78,17.72,19.31,21.03,19.88,20.28,19.44,20.34,21.03,21.84,22.31,21.78,23.06,22.75,22.81,22.81,22.16,19.78,18.19,16.84,15.31,15.03,15.41,14.94,14.81,14.25,14.62,14.44,15.81,16.5,18.34,19.41,22.41,23.44,24.88,26.56,27.78,28.25,29.03,28.78,27.91,26.94,25.38,23.81,22.16,21.03,21.34,21.81,22.22,22.53,23.81,24.91,24.34,25.12,26.56,28.0,28.16,29.81,31.94,34.34,37.19,39.66,42.31,42.88,41.28,38.44,34.25,31.06,28.47,27.34,28.12,29.41,28.66,29.0,29.56,28.38,29.41,30.44,31.09,32.03,33.28,33.88,36.31,38.22,40.94,43.34,45.72,46.38,46.28,44.19,42.69,39.12,36.06,33.47,31.53,29.69,27.75,25.22,25.25,24.34,25.06,26.5,28.06,29.34,29.84,31.25,32.31,34.75,36.75,38.91,38.69,37.62,35.56,32.06,30.5,27.38,25.84,25.69,24.38,23.91,24.16,23.97,25.06,26.06,26.72,26.56,26.53,26.28,24.38,23.25,22.34,22.06,21.91,22.56,22.88,24.5,26.16,27.66,28.53,28.94,29.09,28.19,26.56,24.88,23.72,22.59,22.03,21.22,20.5,19.31,19.38,18.72,19.09,20.03,20.91,23.34,24.31,25.59,25.56,25.94,24.56,22.81,21.38,20.16,19.12,19.5,18.62,18.5,17.88,17.84,17.91,19.19,21.62,25.06,29.66,35.09,38.69,41.69,43.28,42.34,40.5,38.41,36.22,34.16,32.34,29.09,26.62,24.28,22.78,22.22,21.97,22.91,23.22,24.31,24.97,25.62,25.75,26.31,25.41,24.62,24.53,24.78,25.31,26.56,29.0,30.81,32.81,34.62,34.41,33.25,30.69,28.12,26.31,24.19,23.72,23.44,23.78,24.34,24.84,26.19,27.31,27.94,28.06,27.88,27.19,26.16,27.25,27.97,30.12,31.56,34.59,35.16,35.97,34.25,32.53,30.53,28.5,26.94,27.16,27.59,28.66,30.28,30.81,32.0,32.75,33.38,33.41,33.31,32.78,32.38,32.62,33.69,34.31,35.06,35.75,35.59,35.22,34.12,32.81,31.47,29.19,26.75,24.19,21.88,21.56,21.28,21.94,23.0,23.66,23.06,22.06,20.28,18.09,16.84,16.0,15.78,16.03,18.44,19.56,21.06,21.47,21.12,19.22,18.22,16.62,15.81,16.81,17.03,19.28,21.16,21.94,24.5,25.47,25.84,26.53,25.66,25.19,24.34,23.31,22.41,22.44,22.62,23.84,24.75,25.84,26.09,24.66,22.0,18.59,15.62,11.84,10.09,9.06,9.19,9.84,10.81,12.78,13.44,14.91,14.47,14.19,12.31,10.81,9.38,8.94,8.41,9.19,9.0,8.53,7.62,6.34,6.03,5.97,5.62,7.38,8.88,10.81,14.31,16.38,19.53,20.66,22.41,21.91,21.41,21.31,20.41,20.53,22.19,23.06,23.94,25.88,27.44,28.28,29.12,29.38,29.12,29.41,28.06,28.41,28.34,27.56,27.06,25.44,23.72,22.34,20.5,20.91,20.75,21.31,23.66,26.0,28.47,30.53,33.16,35.12,36.53,36.09,35.03,31.78,27.94,23.81,20.5,18.53,18.62,18.72,19.41,19.81,21.44,22.62,23.44,24.31,25.91,27.03,28.5,30.03,32.0,33.41,34.03,34.97,32.59,31.16,28.88,26.06,24.16,23.0,21.97,22.31,22.5,21.62,21.81,21.62,21.78,21.03,20.62,19.88,19.22,19.31,20.91,21.75,23.38,24.12,24.28,25.38,26.03,26.12,27.34,27.59,27.44,27.12,26.19,26.0,25.47,25.19,25.81,25.75,25.69,25.81,25.44,24.66,24.03,23.84,23.47,23.5,22.5,23.16,24.16,25.19,26.41,28.28,30.66,32.75,33.69,35.75,36.0,36.06,35.56,33.59,31.5,28.34,24.97,21.94,18.69,16.69,15.81,16.19,16.41,17.34,18.34,19.38,20.06,23.22,24.72,26.16,27.19,27.38,26.44,25.03,23.84,23.88,24.78,24.81,24.59,24.25,22.69,21.16,18.81,18.81,18.31,18.66,19.62,20.5,20.06,20.44,19.78,18.69,18.12,17.03,17.94,16.81,16.91,17.12,18.0,18.69,19.09,18.75,17.28,15.41,12.81,11.53,10.0,8.62,8.78,8.84,9.41,10.72,12.91,14.41,15.94,17.25,18.16,18.94,20.0,20.62,20.56,20.78,20.06,20.0,19.5,19.16,18.34,19.06,18.81,18.44,17.16,15.97,14.66,12.31,10.47,9.62,9.56,9.66,10.62,11.91,12.81,14.25,15.28,15.97,16.84,17.41,18.31,18.5,18.78,18.31,17.69,16.12,14.56,14.03,14.22,14.91,17.25,19.38,20.34,22.22,22.78,22.78,23.09,23.97,24.28,25.5,27.12,28.0,27.94,27.41,25.66,23.44,20.84,19.31,18.91,18.44,19.06,18.97,18.12,17.25,16.06,13.94,13.69,12.38,13.56,13.84,15.06,14.84,15.44,16.03,16.69,17.66,19.84,21.5,22.38,22.91,21.97,19.62,18.69,16.44,14.66,12.81,11.31,11.22,10.91,12.5,14.44,18.34,22.38,25.38,27.03,27.72,26.44,24.16,21.91,20.09,19.25,18.41,18.34,17.53,16.03,15.31,14.41,13.03,11.94,10.84,9.94,9.94,9.19,9.62,10.0,9.94,9.12,8.91,6.84,7.03,7.25,6.78,8.5,10.25,12.62,16.12,18.06,18.84,18.31,16.44,13.91,10.75,8.41,6.09,5.09,4.53,4.19,4.72,6.31,7.44,8.84,8.91,7.72,6.44,5.0,4.31,4.81,6.38,8.19,10.56,12.25,13.03,13.34,13.56,13.53,12.78,12.59,12.03,11.97,11.94,12.03,13.38,14.19,14.91,14.78,14.16,13.16,11.81,10.75,8.94,8.41,7.88,9.03,10.41,13.44,15.34,17.19,18.53,18.69,17.66,16.69,15.41,13.88,12.06,10.81,9.84,9.34,8.91,8.66,8.84,9.41,10.62,11.72,13.22,15.69,17.81,19.66,21.53,21.72,21.81,21.03,20.69,19.06,18.38,17.62,16.56,15.25,14.59,13.38,11.84,10.56,8.91,5.69,3.38,1.5,-0.44,-0.88,-0.38,0.12,1.97,3.03,5.5,7.97,10.06,11.81,13.12,12.78,11.56,9.62,8.53,6.31,5.56,4.38,3.59,2.19,-0.28,-2.44,-5.53,-7.66,-9.28,-8.84,-8.19,-6.16,-3.16,-0.22,2.41,4.78,6.5,8.25,9.31,10.81,11.25,11.19,11.12,9.91,8.16,6.78,5.41,3.41,1.44,-0.09,-1.94,-3.09,-3.34,-3.38,-3.09,-2.62,-2.03,-0.94,-0.66,0.56,2.03,3.09,5.03,5.56,5.53,5.81,5.47,4.78,4.69,4.12,4.5,3.19,2.75,2.5,2.69,3.69,5.44,7.69,8.69,9.06,9.16,7.44,5.84,4.25,2.5,0.22,-1.22,-2.59,-4.16,-5.53,-6.41,-8.19,-9.28,-9.84,-10.03,-10.44,-9.88,-9.69,-9.59,-9.16,-8.34,-7.72,-7.09,-6.09,-6.03,-5.88,-6.41,-5.91,-0.34,-3.03,-4.91,-7.38,-6.19,-5.81,-3.84,-2.19,-1.22,0.66,1.09,1.34,1.56,2.56,2.84,5.5,6.12,8.38,10.91,12.5,15.06,18.44,19.47,20.16:18.69,20.69,21.62,21.31,19.69,17.31,14.62,14.0,12.66,13.53,14.72,19.38,23.91,30.06,35.59,39.41,41.62,42.56,42.03,39.03,35.66,31.84,26.5,23.69,19.19,17.09,16.0,15.5,16.78,17.72,19.31,21.03,19.88,20.28,19.44,20.34,21.03,21.84,22.31,21.78,23.06,22.75,22.81,22.81,22.16,19.78,18.19,16.84,15.31,15.03,15.41,14.94,14.81,14.25,14.62,14.44,15.81,16.5,18.34,19.41,22.41,23.44,24.88,26.56,27.78,28.25,29.03,28.78,27.91,26.94,25.38,23.81,22.16,21.03,21.34,21.81,22.22,22.53,23.81,24.91,24.34,25.12,26.56,28.0,28.16,29.81,31.94,34.34,37.19,39.66,42.31,42.88,41.28,38.44,34.25,31.06,28.47,27.34,28.12,29.41,28.66,29.0,29.56,28.38,29.41,30.44,31.09,32.03,33.28,33.88,36.31,38.22,40.94,43.34,45.72,46.38,46.28,44.19,42.69,39.12,36.06,33.47,31.53,29.69,27.75,25.22,25.25,24.34,25.06,26.5,28.06,29.34,29.84,31.25,32.31,34.75,36.75,38.91,38.69,37.62,35.56,32.06,30.5,27.38,25.84,25.69,24.38,23.91,24.16,23.97,25.06,26.06,26.72,26.56,26.53,26.28,24.38,23.25,22.34,22.06,21.91,22.56,22.88,24.5,26.16,27.66,28.53,28.94,29.09,28.19,26.56,24.88,23.72,22.59,22.03,21.22,20.5,19.31,19.38,18.72,19.09,20.03,20.91,23.34,24.31,25.59,25.56,25.94,24.56,22.81,21.38,20.16,19.12,19.5,18.62,18.5,17.88,17.84,17.91,19.19,21.62,25.06,29.66,35.09,38.69,41.69,43.28,42.34,40.5,38.41,36.22,34.16,32.34,29.09,26.62,24.28,22.78,22.22,21.97,22.91,23.22,24.31,24.97,25.62,25.75,26.31,25.41,24.62,24.53,24.78,25.31,26.56,29.0,30.81,32.81,34.62,34.41,33.25,30.69,28.12,26.31,24.19,23.72,23.44,23.78,24.34,24.84,26.19,27.31,27.94,28.06,27.88,27.19,26.16,27.25,27.97,30.12,31.56,34.59,35.16,35.97,34.25,32.53,30.53,28.5,26.94,27.16,27.59,28.66,30.28,30.81,32.0,32.75,33.38,33.41,33.31,32.78,32.38,32.62,33.69,34.31,35.06,35.75,35.59,35.22,34.12,32.81,31.47,29.19,26.75,24.19,21.88,21.56,21.28,21.94,23.0,23.66,23.06,22.06,20.28,18.09,16.84,16.0,15.78,16.03,18.44,19.56,21.06,21.47,21.12,19.22,18.22,16.62,15.81,16.81,17.03,19.28,21.16,21.94,24.5,25.47,25.84,26.53,25.66,25.19,24.34,23.31,22.41,22.44,22.62,23.84,24.75,25.84,26.09,24.66,22.0,18.59,15.62,11.84,10.09,9.06,9.19,9.84,10.81,12.78,13.44,14.91,14.47,14.19,12.31,10.81,9.38,8.94,8.41,9.19,9.0,8.53,7.62,6.34,6.03,5.97,5.62,7.38,8.88,10.81,14.31,16.38,19.53,20.66,22.41,21.91,21.41,21.31,20.41,20.53,22.19,23.06,23.94,25.88,27.44,28.28,29.12,29.38,29.12,29.41,28.06,28.41,28.34,27.56,27.06,25.44,23.72,22.34,20.5,20.91,20.75,21.31,23.66,26.0,28.47,30.53,33.16,35.12,36.53,36.09,35.03,31.78,27.94,23.81,20.5,18.53,18.62,18.72,19.41,19.81,21.44,22.62,23.44,24.31,25.91,27.03,28.5,30.03,32.0,33.41,34.03,34.97,32.59,31.16,28.88,26.06,24.16,23.0,21.97,22.31,22.5,21.62,21.81,21.62,21.78,21.03,20.62,19.88,19.22,19.31,20.91,21.75,23.38,24.12,24.28,25.38,26.03,26.12,27.34,27.59,27.44,27.12,26.19,26.0,25.47,25.19,25.81,25.75,25.69,25.81,25.44,24.66,24.03,23.84,23.47,23.5,22.5,23.16,24.16,25.19,26.41,28.28,30.66,32.75,33.69,35.75,36.0,36.06,35.56,33.59,31.5,28.34,24.97,21.94,18.69,16.69,15.81,16.19,16.41,17.34,18.34,19.38,20.06,23.22,24.72,26.16,27.19,27.38,26.44,25.03,23.84,23.88,24.78,24.81,24.59,24.25,22.69,21.16,18.81,18.81,18.31,18.66,19.62,20.5,20.06,20.44,19.78,18.69,18.12,17.03,17.94,16.81,16.91,17.12,18.0,18.69,19.09,18.75,17.28,15.41,12.81,11.53,10.0,8.62,8.78,8.84,9.41,10.72,12.91,14.41,15.94,17.25,18.16,18.94,20.0,20.62,20.56,20.78,20.06,20.0,19.5,19.16,18.34,19.06,18.81,18.44,17.16,15.97,14.66,12.31,10.47,9.62,9.56,9.66,10.62,11.91,12.81,14.25,15.28,15.97,16.84,17.41,18.31,18.5,18.78,18.31,17.69,16.12,14.56,14.03,14.22,14.91,17.25,19.38,20.34,22.22,22.78,22.78,23.09,23.97,24.28,25.5,27.12,28.0,27.94,27.41,25.66,23.44,20.84,19.31,18.91,18.44,19.06,18.97,18.12,17.25,16.06,13.94,13.69,12.38,13.56,13.84,15.06,14.84,15.44,16.03,16.69,17.66,19.84,21.5,22.38,22.91,21.97,19.62,18.69,16.44,14.66,12.81,11.31,11.22,10.91,12.5,14.44,18.34,22.38,25.38,27.03,27.72,26.44,24.16,21.91,20.09,19.25,18.41,18.34,17.53,16.03,15.31,14.41,13.03,11.94,10.84,9.94,9.94,9.19,9.62,10.0,9.94,9.12,8.91,6.84,7.03,7.25,6.78,8.5,10.25,12.62,16.12,18.06,18.84,18.31,16.44,13.91,10.75,8.41,6.09,5.09,4.53,4.19,4.72,6.31,7.44,8.84,8.91,7.72,6.44,5.0,4.31,4.81,6.38,8.19,10.56,12.25,13.03,13.34,13.56,13.53,12.78,12.59,12.03,11.97,11.94,12.03,13.38,14.19,14.91,14.78,14.16,13.16,11.81,10.75,8.94,8.41,7.88,9.03,10.41,13.44,15.34,17.19,18.53,18.69,17.66,16.69,15.41,13.88,12.06,10.81,9.84,9.34,8.91,8.66,8.84,9.41,10.62,11.72,13.22,15.69,17.81,19.66,21.53,21.72,21.81,21.03,20.69,19.06,18.38,17.62,16.56,15.25,14.59,13.38,11.84,10.56,8.91,5.69,3.38,1.5,-0.44,-0.88,-0.38,0.12,1.97,3.03,5.5,7.97,10.06,11.81,13.12,12.78,11.56,9.62,8.53,6.31,5.56,4.38,3.59,2.19,-0.28,-2.44,-5.53,-7.66,-9.28,-8.84,-8.19,-6.16,-3.16,-0.22,2.41,4.78,6.5,8.25,9.31,10.81,11.25,11.19,11.12,9.91,8.16,6.78,5.41,3.41,1.44,-0.09,-1.94,-3.09,-3.34,-3.38,-3.09,-2.62,-2.03,-0.94,-0.66,0.56,2.03,3.09,5.03,5.56,5.53,5.81,5.47,4.78,4.69,4.12,4.5,3.19,2.75,2.5,2.69,3.69,5.44,7.69,8.69,9.06,9.16,7.44,5.84,4.25,2.5,0.22,-1.22,-2.59,-4.16,-5.53,-6.41,-8.19,-9.28,-9.84,-10.03,-10.44,-9.88,-9.69,-9.59,-9.16,-8.34,-7.72,-7.09,-6.09,-6.03,-5.88,-6.41,-5.91,-0.34,-3.03,-4.91,-7.38,-6.19,-5.81,-3.84,-2.19,-1.22,0.66,1.09,1.34,1.56,2.56,2.84,5.5,6.12,8.38,10.91,12.5,15.06,18.44,19.47,20.16,20.38,18.78,15.78,13.34,11.72,11.31:negativity
-34.88,-35.84,-38.38,-41.84,-45.03,-44.56,-44.56,-43.59,-39.75,-37.69,-38.09,-35.44,-33.94,-33.09,-32.75,-31.56,-33.03,-32.84,-33.91,-33.28,-33.28,-30.34,-31.0,-29.97,-31.22,-32.28,-33.69,-33.75,-33.69,-33.03,-31.97,-32.97,-34.75,-36.72,-38.12,-41.09,-39.41,-36.59,-33.34,-28.47,-25.22,-22.84,-22.38,-22.78,-23.84,-25.72,-27.28,-30.09,-31.69,-33.0,-37.25,-38.34,-40.09,-43.22,-44.66,-48.41,-46.97,-47.28,-45.09,-42.19,-37.44,-35.12,-33.25,-33.31,-33.16,-33.91,-34.22,-34.41,-35.38,-37.66,-40.91,-42.84,-45.53,-47.72,-50.09,-52.22,-53.88,-56.19,-55.59,-53.97,-51.0,-48.53,-48.03,-47.12,-46.22,-46.19,-45.97,-45.09,-44.62,-46.0,-46.41,-47.5,-47.16,-48.47,-46.62,-43.91,-42.22,-35.81,-32.47,-27.28,-22.5,-21.88,-21.72,-24.03,-28.12,-29.72,-33.44,-34.72,-33.84,-35.66,-33.41,-31.41,-30.47,-30.88,-28.09,-28.16,-29.72,-29.72,-30.81,-29.97,-29.44,-28.41,-26.28,-25.0,-23.66,-24.84,-28.75,-28.53,-31.69,-32.66,-32.06,-31.91,-31.5,-30.72,-29.88,-31.06,-30.16,-30.03,-29.78,-28.28,-27.97,-26.47,-27.09,-25.09,-24.94,-24.16,-22.66,-25.09,-23.62,-26.16,-27.19,-27.72,-28.16,-28.03,-29.69,-30.28,-29.84,-30.84,-28.5,-26.28,-24.44,-22.16,-21.53,-21.22,-22.47,-25.69,-27.09,-29.34,-32.53,-34.06,-35.78,-37.25,-38.28,-38.47,-37.94,-37.22,-36.56,-34.66,-33.09,-33.47,-29.97,-28.62,-28.09,-27.34,-27.41,-28.41,-31.16,-31.66,-34.81,-34.75,-34.22,-34.91,-31.56,-31.22,-31.09,-29.12,-28.59,-26.5,-25.72,-24.53,-26.09,-26.72,-29.09,-31.28,-33.06,-34.84,-35.28,-36.81,-36.16,-36.69,-36.03,-36.06,-36.94,-35.97,-36.16,-35.47,-36.16,-35.41,-34.53,-35.56,-35.47,-34.28,-36.16,-34.66,-35.72,-34.81,-35.59,-34.69,-34.59,-35.09,-34.84,-33.94,-33.97,-32.94,-33.03,-31.97,-31.25,-29.88,-30.44,-28.97,-27.59,-28.09,-28.22,-28.47,-29.31,-30.03,-32.38,-33.28,-34.38,-35.06,-33.44,-33.44,-32.69,-29.91,-29.72,-29.09,-27.66,-28.34,-29.28,-31.16,-32.59,-33.41,-35.0,-37.84,-39.09,-41.66,-43.88,-43.06,-44.22,-40.59,-40.16,-38.97,-37.31,-36.16,-37.03,-36.34,-37.25,-39.0,-40.34,-42.69,-43.53,-45.88,-45.66,-44.59,-43.62,-41.66,-40.06,-40.41,-38.25,-38.34,-38.94,-38.19,-38.56,-38.34,-36.94,-37.25,-34.75,-33.78,-33.19,-32.47,-32.53,-34.44,-36.59,-37.59,-38.16,-38.66,-37.41,-35.0,-35.47,-32.78,-31.34,-30.47,-29.06,-27.28,-26.72,-28.22,-29.62,-29.78,-31.41,-34.41,-34.06,-35.84,-35.78,-37.0,-35.81,-36.69,-34.44,-34.53,-35.31,-37.38,-39.09,-40.19,-43.09,-42.22,-41.81,-41.19,-40.72,-40.91,-42.28,-44.16,-45.19,-47.84,-47.44,-48.34,-48.09,-47.28,-47.38,-46.81,-46.84,-44.66,-42.62,-40.22,-38.59,-35.81,-32.59,-32.47,-30.19,-31.72,-33.78,-36.34,-38.56,-40.06,-42.75,-43.09,-43.88,-46.41,-47.75,-47.81,-51.75,-49.88,-49.88,-47.91,-45.97,-45.06,-44.0,-44.44,-46.31,-45.69,-46.56,-45.53,-47.34,-46.72,-45.53,-45.44,-43.5,-42.28,-41.81,-39.16,-39.75,-38.69,-35.94,-36.5,-34.41,-34.47,-33.81,-34.22,-34.03,-33.75,-36.16,-37.91,-41.41,-44.34,-47.41,-47.34,-48.81,-48.34,-47.56,-46.78,-46.44,-43.03,-42.84,-40.44,-39.94,-39.97,-38.47,-37.66,-37.03,-35.38,-34.97,-36.34,-37.97,-38.88,-41.91,-43.78,-46.03,-47.19,-49.97,-50.91,-50.34,-53.47,-53.09,-53.59,-53.47,-53.44,-51.38,-48.53,-46.28,-45.03,-40.72,-42.34,-39.47,-41.25,-41.72,-43.59,-47.34,-49.22,-51.31,-52.28,-55.03,-54.81,-53.44,-56.16,-55.12,-52.5,-54.28,-52.56,-52.41,-52.69,-52.59,-54.62,-57.31,-56.78,-61.19,-60.81,-60.28,-61.53,-61.88,-62.66,-62.62,-61.59,-58.66,-55.0,-54.59,-53.41,-52.84,-53.28,-52.91,-51.97,-49.84,-48.94,-48.41,-51.81,-51.72,-53.66,-57.97,-57.91,-57.84,-55.34,-53.41,-49.53,-49.72,-47.0,-45.41,-43.69,-40.88,-41.09,-43.72,-43.56,-48.09,-54.03,-53.34,-55.09,-57.28,-56.59,-58.41,-59.88,-61.41,-61.41,-61.34,-57.97,-54.28,-50.53,-49.12,-45.69,-46.91,-47.16,-47.06,-48.19,-49.22,-51.94,-54.19,-56.53,-58.16,-60.16,-60.66,-58.84,-60.53,-57.97,-55.62,-54.97,-51.09,-49.34,-45.88,-45.53,-43.69,-43.38,-43.91,-43.03,-44.09,-45.66,-45.53,-47.09,-48.12,-47.81,-48.38,-46.91,-48.5,-47.31,-47.16,-45.69,-44.59,-42.59,-43.28,-43.88,-43.31,-44.91,-42.81,-42.5,-40.91,-39.72,-37.84,-36.28,-36.75,-36.28,-38.34,-40.09,-40.09,-40.69,-39.69,-40.28,-38.28,-39.5,-39.41,-39.28,-39.62,-38.66,-38.72,-39.0,-38.59,-38.72,-39.31,-40.06,-40.03,-37.94,-37.22,-37.44,-35.84,-36.34,-37.59,-36.66,-39.22,-39.81,-39.94,-40.66,-42.94,-41.53,-42.16,-46.16,-45.91,-46.56,-48.31,-47.34,-48.47,-45.84,-45.47,-45.38,-43.56,-43.16,-43.72,-43.78,-42.69,-42.88,-41.34,-41.5,-39.81,-37.81,-36.84,-35.97,-34.97,-36.59,-39.78,-40.16,-42.03,-45.5,-44.78,-46.78,-46.09,-47.0,-46.53,-46.5,-48.03,-46.47,-46.59,-44.91,-42.44,-42.28,-40.06,-39.38,-38.09,-35.72,-34.19,-32.38,-31.06,-31.31,-31.09,-34.03,-38.59,-42.47,-42.28,-43.06,-41.22,-37.69,-34.78,-34.34,-35.59,-34.41,-38.72,-36.19,-35.72,-35.81,-33.88,-33.34,-33.59,-36.16,-36.81,-38.78,-41.0,-40.19,-39.22,-37.09,-35.94,-34.72,-33.47,-32.84,-33.34,-33.5,-34.28,-36.84,-38.59,-39.34,-39.28,-38.34,-37.19,-37.34,-36.47,-38.56,-37.72,-37.84,-36.97,-34.88,-33.88,-33.41,-30.94,-31.41,-31.47,-33.91,-33.75,-37.06,-36.59,-37.34,-37.31,-37.47,-36.25,-36.66,-38.19,-36.22,-35.66,-32.72,-31.16,-28.84,-27.28,-28.06,-30.91,-32.53,-32.88,-32.72,-31.78,-29.84,-29.56,-29.47,-30.28,-31.94,-31.0,-31.41,-31.72,-32.41,-32.66,-32.28,-32.69,-33.0,-31.91,-33.38,-33.62,-33.97,-33.66,-32.66,-32.84,-31.62,-31.78,-32.75,-32.31,-34.28,-34.25,-35.69,-37.09,-38.03,-37.78,-40.66,-37.47,-37.78,-36.47,-36.22,-35.78,-36.41,-37.25,-39.34,-39.91,-39.94,-40.03,-39.62,-39.41,-40.06,-40.16,-41.72,-44.28,-46.28,-47.38,-48.94,-48.94,-48.09,-47.12,-47.22,-46.03,-45.34,-44.34,-43.5,-42.09,-42.97,-42.5,-44.53,-44.16,-44.53,-47.16,-45.41,-44.59,-45.28,-43.91,-41.84,-41.19,-39.59,-36.72,-34.88,-32.72,-31.09,-30.06,-31.69,-31.66,-31.12,-32.25,-34.03,-34.19,-33.94,-36.75,-37.69,-36.69,-36.62,-37.47,-37.94,-37.56,-39.59,-40.44,-42.94,-45.75,-46.34,-48.34,-48.69,-46.16,-44.16,-41.91,-39.78,-37.22,-36.84,-36.31,-38.03,-38.94,-41.66,-45.09,-46.06,-46.34,-46.03,-43.47,-40.56,-38.22,-36.88,-32.81,-33.59,-32.09,-29.94,-30.69,-30.72,-32.19,-35.41,-35.31,-38.78,-40.53,-42.06,-43.41,-44.72,-43.97,-43.38,-43.44,-41.91,-42.03,-40.94,-40.28,-38.88,-37.72,-35.47,-35.78,-36.53,-38.12,-38.53,-39.44,-41.16,-41.84,-41.59,-43.66,-45.44,-45.59,-47.28,-49.22,-48.72,-49.34,-49.34,-44.59,-41.84,-36.19,-32.91,-28.59,-27.38,-26.97,-28.75,-31.47,-33.66,-38.72,-39.0,-39.53,-39.47,-37.28,-36.22,-33.88,-34.09,-31.03,-31.72,-29.28,-29.59:-44.56,-43.59,-39.75,-37.69,-38.09,-35.44,-33.94,-33.09,-32.75,-31.56,-33.03,-32.84,-33.91,-33.28,-33.28,-30.34,-31.0,-29.97,-31.22,-32.28,-33.69,-33.75,-33.69,-33.03,-31.97,-32.97,-34.75,-36.72,-38.12,-41.09,-39.41,-36.59,-33.34,-28.47,-25.22,-22.84,-22.38,-22.78,-23.84,-25.72,-27.28,-30.09,-31.69,-33.0,-37.25,-38.34,-40.09,-43.22,-44.66,-48.41,-46.97,-47.28,-45.09,-42.19,-37.44,-35.12,-33.25,-33.31,-33.16,-33.91,-34.22,-34.41,-35.38,-37.66,-40.91,-42.84,-45.53,-47.72,-50.09,-52.22,-53.88,-56.19,-55.59,-53.97,-51.0,-48.53,-48.03,-47.12,-46.22,-46.19,-45.97,-45.09,-44.62,-46.0,-46.41,-47.5,-47.16,-48.47,-46.62,-43.91,-42.22,-35.81,-32.47,-27.28,-22.5,-21.88,-21.72,-24.03,-28.12,-29.72,-33.44,-34.72,-33.84,-35.66,-33.41,-31.41,-30.47,-30.88,-28.09,-28.16,-29.72,-29.72,-30.81,-29.97,-29.44,-28.41,-26.28,-25.0,-23.66,-24.84,-28.75,-28.53,-31.69,-32.66,-32.06,-31.91,-31.5,-30.72,-29.88,-31.06,-30.16,-30.03,-29.78,-28.28,-27.97,-26.47,-27.09,-25.09,-24.94,-24.16,-22.66,-25.09,-23.62,-26.16,-27.19,-27.72,-28.16,-28.03,-29.69,-30.28,-29.84,-30.84,-28.5,-26.28,-24.44,-22.16,-21.53,-21.22,-22.47,-25.69,-27.09,-29.34,-32.53,-34.06,-35.78,-37.25,-38.28,-38.47,-37.94,-37.22,-36.56,-34.66,-33.09,-33.47,-29.97,-28.62,-28.09,-27.34,-27.41,-28.41,-31.16,-31.66,-34.81,-34.75,-34.22,-34.91,-31.56,-31.22,-31.09,-29.12,-28.59,-26.5,-25.72,-24.53,-26.09,-26.72,-29.09,-31.28,-33.06,-34.84,-35.28,-36.81,-36.16,-36.69,-36.03,-36.06,-36.94,-35.97,-36.16,-35.47,-36.16,-35.41,-34.53,-35.56,-35.47,-34.28,-36.16,-34.66,-35.72,-34.81,-35.59,-34.69,-34.59,-35.09,-34.84,-33.94,-33.97,-32.94,-33.03,-31.97,-31.25,-29.88,-30.44,-28.97,-27.59,-28.09,-28.22,-28.47,-29.31,-30.03,-32.38,-33.28,-34.38,-35.06,-33.44,-33.44,-32.69,-29.91,-29.72,-29.09,-27.66,-28.34,-29.28,-31.16,-32.59,-33.41,-35.0,-37.84,-39.09,-41.66,-43.88,-43.06,-44.22,-40.59,-40.16,-38.97,-37.31,-36.16,-37.03,-36.34,-37.25,-39.0,-40.34,-42.69,-43.53,-45.88,-45.66,-44.59,-43.62,-41.66,-40.06,-40.41,-38.25,-38.34,-38.94,-38.19,-38.56,-38.34,-36.94,-37.25,-34.75,-33.78,-33.19,-32.47,-32.53,-34.44,-36.59,-37.59,-38.16,-38.66,-37.41,-35.0,-35.47,-32.78,-31.34,-30.47,-29.06,-27.28,-26.72,-28.22,-29.62,-29.78,-31.41,-34.41,-34.06,-35.84,-35.78,-37.0,-35.81,-36.69,-34.44,-34.53,-35.31,-37.38,-39.09,-40.19,-43.09,-42.22,-41.81,-41.19,-40.72,-40.91,-42.28,-44.16,-45.19,-47.84,-47.44,-48.34,-48.09,-47.28,-47.38,-46.81,-46.84,-44.66,-42.62,-40.22,-38.59,-35.81,-32.59,-32.47,-30.19,-31.72,-33.78,-36.34,-38.56,-40.06,-42.75,-43.09,-43.88,-46.41,-47.75,-47.81,-51.75,-49.88,-49.88,-47.91,-45.97,-45.06,-44.0,-44.44,-46.31,-45.69,-46.56,-45.53,-47.34,-46.72,-45.53,-45.44,-43.5,-42.28,-41.81,-39.16,-39.75,-38.69,-35.94,-36.5,-34.41,-34.47,-33.81,-34.22,-34.03,-33.75,-36.16,-37.91,-41.41,-44.34,-47.41,-47.34,-48.81,-48.34,-47.56,-46.78,-46.44,-43.03,-42.84,-40.44,-39.94,-39.97,-38.47,-37.66,-37.03,-35.38,-34.97,-36.34,-37.97,-38.88,-41.91,-43.78,-46.03,-47.19,-49.97,-50.91,-50.34,-53.47,-53.09,-53.59,-53.47,-53.44,-51.38,-48.53,-46.28,-45.03,-40.72,-42.34,-39.47,-41.25,-41.72,-43.59,-47.34,-49.22,-51.31,-52.28,-55.03,-54.81,-53.44,-56.16,-55.12,-52.5,-54.28,-52.56,-52.41,-52.69,-52.59,-54.62,-57.31,-56.78,-61.19,-60.81,-60.28,-61.53,-61.88,-62.66,-62.62,-61.59,-58.66,-55.0,-54.59,-53.41,-52.84,-53.28,-52.91,-51.97,-49.84,-48.94,-48.41,-51.81,-51.72,-53.66,-57.97,-57.91,-57.84,-55.34,-53.41,-49.53,-49.72,-47.0,-45.41,-43.69,-40.88,-41.09,-43.72,-43.56,-48.09,-54.03,-53.34,-55.09,-57.28,-56.59,-58.41,-59.88,-61.41,-61.41,-61.34,-57.97,-54.28,-50.53,-49.12,-45.69,-46.91,-47.16,-47.06,-48.19,-49.22,-51.94,-54.19,-56.53,-58.16,-60.16,-60.66,-58.84,-60.53,-57.97,-55.62,-54.97,-51.09,-49.34,-45.88,-45.53,-43.69,-43.38,-43.91,-43.03,-44.09,-45.66,-45.53,-47.09,-48.12,-47.81,-48.38,-46.91,-48.5,-47.31,-47.16,-45.69,-44.59,-42.59,-43.28,-43.88,-43.31,-44.91,-42.81,-42.5,-40.91,-39.72,-37.84,-36.28,-36.75,-36.28,-38.34,-40.09,-40.09,-40.69,-39.69,-40.28,-38.28,-39.5,-39.41,-39.28,-39.62,-38.66,-38.72,-39.0,-38.59,-38.72,-39.31,-40.06,-40.03,-37.94,-37.22,-37.44,-35.84,-36.34,-37.59,-36.66,-39.22,-39.81,-39.94,-40.66,-42.94,-41.53,-42.16,-46.16,-45.91,-46.56,-48.31,-47.34,-48.47,-45.84,-45.47,-45.38,-43.56,-43.16,-43.72,-43.78,-42.69,-42.88,-41.34,-41.5,-39.81,-37.81,-36.84,-35.97,-34.97,-36.59,-39.78,-40.16,-42.03,-45.5,-44.78,-46.78,-46.09,-47.0,-46.53,-46.5,-48.03,-46.47,-46.59,-44.91,-42.44,-42.28,-40.06,-39.38,-38.09,-35.72,-34.19,-32.38,-31.06,-31.31,-31.09,-34.03,-38.59,-42.47,-42.28,-43.06,-41.22,-37.69,-34.78,-34.34,-35.59,-34.41,-38.72,-36.19,-35.72,-35.81,-33.88,-33.34,-33.59,-36.16,-36.81,-38.78,-41.0,-40.19,-39.22,-37.09,-35.94,-34.72,-33.47,-32.84,-33.34,-33.5,-34.28,-36.84,-38.59,-39.34,-39.28,-38.34,-37.19,-37.34,-36.47,-38.56,-37.72,-37.84,-36.97,-34.88,-33.88,-33.41,-30.94,-31.41,-31.47,-33.91,-33.75,-37.06,-36.59,-37.34,-37.31,-37.47,-36.25,-36.66,-38.19,-36.22,-35.66,-32.72,-31.16,-28.84,-27.28,-28.06,-30.91,-32.53,-32.88,-32.72,-31.78,-29.84,-29.56,-29.47,-30.28,-31.94,-31.0,-31.41,-31.72,-32.41,-32.66,-32.28,-32.69,-33.0,-31.91,-33.38,-33.62,-33.97,-33.66,-32.66,-32.84,-31.62,-31.78,-32.75,-32.31,-34.28,-34.25,-35.69,-37.09,-38.03,-37.78,-40.66,-37.47,-37.78,-36.47,-36.22,-35.78,-36.41,-37.25,-39.34,-39.91,-39.94,-40.03,-39.62,-39.41,-40.06,-40.16,-41.72,-44.28,-46.28,-47.38,-48.94,-48.94,-48.09,-47.12,-47.22,-46.03,-45.34,-44.34,-43.5,-42.09,-42.97,-42.5,-44.53,-44.16,-44.53,-47.16,-45.41,-44.59,-45.28,-43.91,-41.84,-41.19,-39.59,-36.72,-34.88,-32.72,-31.09,-30.06,-31.69,-31.66,-31.12,-32.25,-34.03,-34.19,-33.94,-36.75,-37.69,-36.69,-36.62,-37.47,-37.94,-37.56,-39.59,-40.44,-42.94,-45.75,-46.34,-48.34,-48.69,-46.16,-44.16,-41.91,-39.78,-37.22,-36.84,-36.31,-38.03,-38.94,-41.66,-45.09,-46.06,-46.34,-46.03,-43.47,-40.56,-38.22,-36.88,-32.81,-33.59,-32.09,-29.94,-30.69,-30.72,-32.19,-35.41,-35.31,-38.78,-40.53,-42.06,-43.41,-44.72,-43.97,-43.38,-43.44,-41.91,-42.03,-40.94,-40.28,-38.88,-37.72,-35.47,-35.78,-36.53,-38.12,-38.53,-39.44,-41.16,-41.84,-41.59,-43.66,-45.44,-45.59,-47.28,-49.22,-48.72,-49.34,-49.34,-44.59,-41.84,-36.19,-32.91,-28.59,-27.38,-26.97,-28.75,-31.47,-33.66,-38.72,-39.0,-39.53,-39.47,-37.28,-36.22,-33.88,-34.09,-31.03,-31.72,-29.28,-29.59,-46.38,-45.59,-44.66,-46.59,-48.16,-48.44:-33.94,-33.09,-32.75,-31.56,-33.03,-32.84,-33.91,-33.28,-33.28,-30.34,-31.0,-29.97,-31.22,-32.28,-33.69,-33.75,-33.69,-33.03,-31.97,-32.97,-34.75,-36.72,-38.12,-41.09,-39.41,-36.59,-33.34,-28.47,-25.22,-22.84,-22.38,-22.78,-23.84,-25.72,-27.28,-30.09,-31.69,-33.0,-37.25,-38.34,-40.09,-43.22,-44.66,-48.41,-46.97,-47.28,-45.09,-42.19,-37.44,-35.12,-33.25,-33.31,-33.16,-33.91,-34.22,-34.41,-35.38,-37.66,-40.91,-42.84,-45.53,-47.72,-50.09,-52.22,-53.88,-56.19,-55.59,-53.97,-51.0,-48.53,-48.03,-47.12,-46.22,-46.19,-45.97,-45.09,-44.62,-46.0,-46.41,-47.5,-47.16,-48.47,-46.62,-43.91,-42.22,-35.81,-32.47,-27.28,-22.5,-21.88,-21.72,-24.03,-28.12,-29.72,-33.44,-34.72,-33.84,-35.66,-33.41,-31.41,-30.47,-30.88,-28.09,-28.16,-29.72,-29.72,-30.81,-29.97,-29.44,-28.41,-26.28,-25.0,-23.66,-24.84,-28.75,-28.53,-31.69,-32.66,-32.06,-31.91,-31.5,-30.72,-29.88,-31.06,-30.16,-30.03,-29.78,-28.28,-27.97,-26.47,-27.09,-25.09,-24.94,-24.16,-22.66,-25.09,-23.62,-26.16,-27.19,-27.72,-28.16,-28.03,-29.69,-30.28,-29.84,-30.84,-28.5,-26.28,-24.44,-22.16,-21.53,-21.22,-22.47,-25.69,-27.09,-29.34,-32.53,-34.06,-35.78,-37.25,-38.28,-38.47,-37.94,-37.22,-36.56,-34.66,-33.09,-33.47,-29.97,-28.62,-28.09,-27.34,-27.41,-28.41,-31.16,-31.66,-34.81,-34.75,-34.22,-34.91,-31.56,-31.22,-31.09,-29.12,-28.59,-26.5,-25.72,-24.53,-26.09,-26.72,-29.09,-31.28,-33.06,-34.84,-35.28,-36.81,-36.16,-36.69,-36.03,-36.06,-36.94,-35.97,-36.16,-35.47,-36.16,-35.41,-34.53,-35.56,-35.47,-34.28,-36.16,-34.66,-35.72,-34.81,-35.59,-34.69,-34.59,-35.09,-34.84,-33.94,-33.97,-32.94,-33.03,-31.97,-31.25,-29.88,-30.44,-28.97,-27.59,-28.09,-28.22,-28.47,-29.31,-30.03,-32.38,-33.28,-34.38,-35.06,-33.44,-33.44,-32.69,-29.91,-29.72,-29.09,-27.66,-28.34,-29.28,-31.16,-32.59,-33.41,-35.0,-37.84,-39.09,-41.66,-43.88,-43.06,-44.22,-40.59,-40.16,-38.97,-37.31,-36.16,-37.03,-36.34,-37.25,-39.0,-40.34,-42.69,-43.53,-45.88,-45.66,-44.59,-43.62,-41.66,-40.06,-40.41,-38.25,-38.34,-38.94,-38.19,-38.56,-38.34,-36.94,-37.25,-34.75,-33.78,-33.19,-32.47,-32.53,-34.44,-36.59,-37.59,-38.16,-38.66,-37.41,-35.0,-35.47,-32.78,-31.34,-30.47,-29.06,-27.28,-26.72,-28.22,-29.62,-29.78,-31.41,-34.41,-34.06,-35.84,-35.78,-37.0,-35.81,-36.69,-34.44,-34.53,-35.31,-37.38,-39.09,-40.19,-43.09,-42.22,-41.81,-41.19,-40.72,-40.91,-42.28,-44.16,-45.19,-47.84,-47.44,-48.34,-48.09,-47.28,-47.38,-46.81,-46.84,-44.66,-42.62,-40.22,-38.59,-35.81,-32.59,-32.47,-30.19,-31.72,-33.78,-36.34,-38.56,-40.06,-42.75,-43.09,-43.88,-46.41,-47.75,-47.81,-51.75,-49.88,-49.88,-47.91,-45.97,-45.06,-44.0,-44.44,-46.31,-45.69,-46.56,-45.53,-47.34,-46.72,-45.53,-45.44,-43.5,-42.28,-41.81,-39.16,-39.75,-38.69,-35.94,-36.5,-34.41,-34.47,-33.81,-34.22,-34.03,-33.75,-36.16,-37.91,-41.41,-44.34,-47.41,-47.34,-48.81,-48.34,-47.56,-46.78,-46.44,-43.03,-42.84,-40.44,-39.94,-39.97,-38.47,-37.66,-37.03,-35.38,-34.97,-36.34,-37.97,-38.88,-41.91,-43.78,-46.03,-47.19,-49.97,-50.91,-50.34,-53.47,-53.09,-53.59,-53.47,-53.44,-51.38,-48.53,-46.28,-45.03,-40.72,-42.34,-39.47,-41.25,-41.72,-43.59,-47.34,-49.22,-51.31,-52.28,-55.03,-54.81,-53.44,-56.16,-55.12,-52.5,-54.28,-52.56,-52.41,-52.69,-52.59,-54.62,-57.31,-56.78,-61.19,-60.81,-60.28,-61.53,-61.88,-62.66,-62.62,-61.59,-58.66,-55.0,-54.59,-53.41,-52.84,-53.28,-52.91,-51.97,-49.84,-48.94,-48.41,-51.81,-51.72,-53.66,-57.97,-57.91,-57.84,-55.34,-53.41,-49.53,-49.72,-47.0,-45.41,-43.69,-40.88,-41.09,-43.72,-43.56,-48.09,-54.03,-53.34,-55.09,-57.28,-56.59,-58.41,-59.88,-61.41,-61.41,-61.34,-57.97,-54.28,-50.53,-49.12,-45.69,-46.91,-47.16,-47.06,-48.19,-49.22,-51.94,-54.19,-56.53,-58.16,-60.16,-60.66,-58.84,-60.53,-57.97,-55.62,-54.97,-51.09,-49.34,-45.88,-45.53,-43.69,-43.38,-43.91,-43.03,-44.09,-45.66,-45.53,-47.09,-48.12,-47.81,-48.38,-46.91,-48.5,-47.31,-47.16,-45.69,-44.59,-42.59,-43.28,-43.88,-43.31,-44.91,-42.81,-42.5,-40.91,-39.72,-37.84,-36.28,-36.75,-36.28,-38.34,-40.09,-40.09,-40.69,-39.69,-40.28,-38.28,-39.5,-39.41,-39.28,-39.62,-38.66,-38.72,-39.0,-38.59,-38.72,-39.31,-40.06,-40.03,-37.94,-37.22,-37.44,-35.84,-36.34,-37.59,-36.66,-39.22,-39.81,-39.94,-40.66,-42.94,-41.53,-42.16,-46.16,-45.91,-46.56,-48.31,-47.34,-48.47,-45.84,-45.47,-45.38,-43.56,-43.16,-43.72,-43.78,-42.69,-42.88,-41.34,-41.5,-39.81,-37.81,-36.84,-35.97,-34.97,-36.59,-39.78,-40.16,-42.03,-45.5,-44.78,-46.78,-46.09,-47.0,-46.53,-46.5,-48.03,-46.47,-46.59,-44.91,-42.44,-42.28,-40.06,-39.38,-38.09,-35.72,-34.19,-32.38,-31.06,-31.31,-31.09,-34.03,-38.59,-42.47,-42.28,-43.06,-41.22,-37.69,-34.78,-34.34,-35.59,-34.41,-38.72,-36.19,-35.72,-35.81,-33.88,-33.34,-33.59,-36.16,-36.81,-38.78,-41.0,-40.19,-39.22,-37.09,-35.94,-34.72,-33.47,-32.84,-33.34,-33.5,-34.28,-36.84,-38.59,-39.34,-39.28,-38.34,-37.19,-37.34,-36.47,-38.56,-37.72,-37.84,-36.97,-34.88,-33.88,-33.41,-30.94,-31.41,-31.47,-33.91,-33.75,-37.06,-36.59,-37.34,-37.31,-37.47,-36.25,-36.66,-38.19,-36.22,-35.66,-32.72,-31.16,-28.84,-27.28,-28.06,-30.91,-32.53,-32.88,-32.72,-31.78,-29.84,-29.56,-29.47,-30.28,-31.94,-31.0,-31.41,-31.72,-32.41,-32.66,-32.28,-32.69,-33.0,-31.91,-33.38,-33.62,-33.97,-33.66,-32.66,-32.84,-31.62,-31.78,-32.75,-32.31,-34.28,-34.25,-35.69,-37.09,-38.03,-37.78,-40.66,-37.47,-37.78,-36.47,-36.22,-35.78,-36.41,-37.25,-39.34,-39.91,-39.94,-40.03,-39.62,-39.41,-40.06,-40.16,-41.72,-44.28,-46.28,-47.38,-48.94,-48.94,-48.09,-47.12,-47.22,-46.03,-45.34,-44.34,-43.5,-42.09,-42.97,-42.5,-44.53,-44.16,-44.53,-47.16,-45.41,-44.59,-45.28,-43.91,-41.84,-41.19,-39.59,-36.72,-34.88,-32.72,-31.09,-30.06,-31.69,-31.66,-31.12,-32.25,-34.03,-34.19,-33.94,-36.75,-37.69,-36.69,-36.62,-37.47,-37.94,-37.56,-39.59,-40.44,-42.94,-45.75,-46.34,-48.34,-48.69,-46.16,-44.16,-41.91,-39.78,-37.22,-36.84,-36.31,-38.03,-38.94,-41.66,-45.09,-46.06,-46.34,-46.03,-43.47,-40.56,-38.22,-36.88,-32.81,-33.59,-32.09,-29.94,-30.69,-30.72,-32.19,-35.41,-35.31,-38.78,-40.53,-42.06,-43.41,-44.72,-43.97,-43.38,-43.44,-41.91,-42.03,-40.94,-40.28,-38.88,-37.72,-35.47,-35.78,-36.53,-38.12,-38.53,-39.44,-41.16,-41.84,-41.59,-43.66,-45.44,-45.59,-47.28,-49.22,-48.72,-49.34,-49.34,-44.59,-41.84,-36.19,-32.91,-28.59,-27.38,-26.97,-28.75,-31.47,-33.66,-38.72,-39.0,-39.53,-39.47,-37.28,-36.22,-33.88,-34.09,-31.03,-31.72,-29.28,-29.59,-46.38,-45.59,-44.66,-46.59,-48.16,-48.44,-50.06,-48.59,-43.62,-42.03,-39.59,-35.12:-33.91,-33.28,-33.28,-30.34,-31.0,-29.97,-31.22,-32.28,-33.69,-33.75,-33.69,-33.03,-31.97,-32.97,-34.75,-36.72,-38.12,-41.09,-39.41,-36.59,-33.34,-28.47,-25.22,-22.84,-22.38,-22.78,-23.84,-25.72,-27.28,-30.09,-31.69,-33.0,-37.25,-38.34,-40.09,-43.22,-44.66,-48.41,-46.97,-47.28,-45.09,-42.19,-37.44,-35.12,-33.25,-33.31,-33.16,-33.91,-34.22,-34.41,-35.38,-37.66,-40.91,-42.84,-45.53,-47.72,-50.09,-52.22,-53.88,-56.19,-55.59,-53.97,-51.0,-48.53,-48.03,-47.12,-46.22,-46.19,-45.97,-45.09,-44.62,-46.0,-46.41,-47.5,-47.16,-48.47,-46.62,-43.91,-42.22,-35.81,-32.47,-27.28,-22.5,-21.88,-21.72,-24.03,-28.12,-29.72,-33.44,-34.72,-33.84,-35.66,-33.41,-31.41,-30.47,-30.88,-28.09,-28.16,-29.72,-29.72,-30.81,-29.97,-29.44,-28.41,-26.28,-25.0,-23.66,-24.84,-28.75,-28.53,-31.69,-32.66,-32.06,-31.91,-31.5,-30.72,-29.88,-31.06,-30.16,-30.03,-29.78,-28.28,-27.97,-26.47,-27.09,-25.09,-24.94,-24.16,-22.66,-25.09,-23.62,-26.16,-27.19,-27.72,-28.16,-28.03,-29.69,-30.28,-29.84,-30.84,-28.5,-26.28,-24.44,-22.16,-21.53,-21.22,-22.47,-25.69,-27.09,-29.34,-32.53,-34.06,-35.78,-37.25,-38.28,-38.47,-37.94,-37.22,-36.56,-34.66,-33.09,-33.47,-29.97,-28.62,-28.09,-27.34,-27.41,-28.41,-31.16,-31.66,-34.81,-34.75,-34.22,-34.91,-31.56,-31.22,-31.09,-29.12,-28.59,-26.5,-25.72,-24.53,-26.09,-26.72,-29.09,-31.28,-33.06,-34.84,-35.28,-36.81,-36.16,-36.69,-36.03,-36.06,-36.94,-35.97,-36.16,-35.47,-36.16,-35.41,-34.53,-35.56,-35.47,-34.28,-36.16,-34.66,-35.72,-34.81,-35.59,-34.69,-34.59,-35.09,-34.84,-33.94,-33.97,-32.94,-33.03,-31.97,-31.25,-29.88,-30.44,-28.97,-27.59,-28.09,-28.22,-28.47,-29.31,-30.03,-32.38,-33.28,-34.38,-35.06,-33.44,-33.44,-32.69,-29.91,-29.72,-29.09,-27.66,-28.34,-29.28,-31.16,-32.59,-33.41,-35.0,-37.84,-39.09,-41.66,-43.88,-43.06,-44.22,-40.59,-40.16,-38.97,-37.31,-36.16,-37.03,-36.34,-37.25,-39.0,-40.34,-42.69,-43.53,-45.88,-45.66,-44.59,-43.62,-41.66,-40.06,-40.41,-38.25,-38.34,-38.94,-38.19,-38.56,-38.34,-36.94,-37.25,-34.75,-33.78,-33.19,-32.47,-32.53,-34.44,-36.59,-37.59,-38.16,-38.66,-37.41,-35.0,-35.47,-32.78,-31.34,-30.47,-29.06,-27.28,-26.72,-28.22,-29.62,-29.78,-31.41,-34.41,-34.06,-35.84,-35.78,-37.0,-35.81,-36.69,-34.44,-34.53,-35.31,-37.38,-39.09,-40.19,-43.09,-42.22,-41.81,-41.19,-40.72,-40.91,-42.28,-44.16,-45.19,-47.84,-47.44,-48.34,-48.09,-47.28,-47.38,-46.81,-46.84,-44.66,-42.62,-40.22,-38.59,-35.81,-32.59,-32.47,-30.19,-31.72,-33.78,-36.34,-38.56,-40.06,-42.75,-43.09,-43.88,-46.41,-47.75,-47.81,-51.75,-49.88,-49.88,-47.91,-45.97,-45.06,-44.0,-44.44,-46.31,-45.69,-46.56,-45.53,-47.34,-46.72,-45.53,-45.44,-43.5,-42.28,-41.81,-39.16,-39.75,-38.69,-35.94,-36.5,-34.41,-34.47,-33.81,-34.22,-34.03,-33.75,-36.16,-37.91,-41.41,-44.34,-47.41,-47.34,-48.81,-48.34,-47.56,-46.78,-46.44,-43.03,-42.84,-40.44,-39.94,-39.97,-38.47,-37.66,-37.03,-35.38,-34.97,-36.34,-37.97,-38.88,-41.91,-43.78,-46.03,-47.19,-49.97,-50.91,-50.34,-53.47,-53.09,-53.59,-53.47,-53.44,-51.38,-48.53,-46.28,-45.03,-40.72,-42.34,-39.47,-41.25,-41.72,-43.59,-47.34,-49.22,-51.31,-52.28,-55.03,-54.81,-53.44,-56.16,-55.12,-52.5,-54.28,-52.56,-52.41,-52.69,-52.59,-54.62,-57.31,-56.78,-61.19,-60.81,-60.28,-61.53,-61.88,-62.66,-62.62,-61.59,-58.66,-55.0,-54.59,-53.41,-52.84,-53.28,-52.91,-51.97,-49.84,-48.94,-48.41,-51.81,-51.72,-53.66,-57.97,-57.91,-57.84,-55.34,-53.41,-49.53,-49.72,-47.0,-45.41,-43.69,-40.88,-41.09,-43.72,-43.56,-48.09,-54.03,-53.34,-55.09,-57.28,-56.59,-58.41,-59.88,-61.41,-61.41,-61.34,-57.97,-54.28,-50.53,-49.12,-45.69,-46.91,-47.16,-47.06,-48.19,-49.22,-51.94,-54.19,-56.53,-58.16,-60.16,-60.66,-58.84,-60.53,-57.97,-55.62,-54.97,-51.09,-49.34,-45.88,-45.53,-43.69,-43.38,-43.91,-43.03,-44.09,-45.66,-45.53,-47.09,-48.12,-47.81,-48.38,-46.91,-48.5,-47.31,-47.16,-45.69,-44.59,-42.59,-43.28,-43.88,-43.31,-44.91,-42.81,-42.5,-40.91,-39.72,-37.84,-36.28,-36.75,-36.28,-38.34,-40.09,-40.09,-40.69,-39.69,-40.28,-38.28,-39.5,-39.41,-39.28,-39.62,-38.66,-38.72,-39.0,-38.59,-38.72,-39.31,-40.06,-40.03,-37.94,-37.22,-37.44,-35.84,-36.34,-37.59,-36.66,-39.22,-39.81,-39.94,-40.66,-42.94,-41.53,-42.16,-46.16,-45.91,-46.56,-48.31,-47.34,-48.47,-45.84,-45.47,-45.38,-43.56,-43.16,-43.72,-43.78,-42.69,-42.88,-41.34,-41.5,-39.81,-37.81,-36.84,-35.97,-34.97,-36.59,-39.78,-40.16,-42.03,-45.5,-44.78,-46.78,-46.09,-47.0,-46.53,-46.5,-48.03,-46.47,-46.59,-44.91,-42.44,-42.28,-40.06,-39.38,-38.09,-35.72,-34.19,-32.38,-31.06,-31.31,-31.09,-34.03,-38.59,-42.47,-42.28,-43.06,-41.22,-37.69,-34.78,-34.34,-35.59,-34.41,-38.72,-36.19,-35.72,-35.81,-33.88,-33.34,-33.59,-36.16,-36.81,-38.78,-41.0,-40.19,-39.22,-37.09,-35.94,-34.72,-33.47,-32.84,-33.34,-33.5,-34.28,-36.84,-38.59,-39.34,-39.28,-38.34,-37.19,-37.34,-36.47,-38.56,-37.72,-37.84,-36.97,-34.88,-33.88,-33.41,-30.94,-31.41,-31.47,-33.91,-33.75,-37.06,-36.59,-37.34,-37.31,-37.47,-36.25,-36.66,-38.19,-36.22,-35.66,-32.72,-31.16,-28.84,-27.28,-28.06,-30.91,-32.53,-32.88,-32.72,-31.78,-29.84,-29.56,-29.47,-30.28,-31.94,-31.0,-31.41,-31.72,-32.41,-32.66,-32.28,-32.69,-33.0,-31.91,-33.38,-33.62,-33.97,-33.66,-32.66,-32.84,-31.62,-31.78,-32.75,-32.31,-34.28,-34.25,-35.69,-37.09,-38.03,-37.78,-40.66,-37.47,-37.78,-36.47,-36.22,-35.78,-36.41,-37.25,-39.34,-39.91,-39.94,-40.03,-39.62,-39.41,-40.06,-40.16,-41.72,-44.28,-46.28,-47.38,-48.94,-48.94,-48.09,-47.12,-47.22,-46.03,-45.34,-44.34,-43.5,-42.09,-42.97,-42.5,-44.53,-44.16,-44.53,-47.16,-45.41,-44.59,-45.28,-43.91,-41.84,-41.19,-39.59,-36.72,-34.88,-32.72,-31.09,-30.06,-31.69,-31.66,-31.12,-32.25,-34.03,-34.19,-33.94,-36.75,-37.69,-36.69,-36.62,-37.47,-37.94,-37.56,-39.59,-40.44,-42.94,-45.75,-46.34,-48.34,-48.69,-46.16,-44.16,-41.91,-39.78,-37.22,-36.84,-36.31,-38.03,-38.94,-41.66,-45.09,-46.06,-46.34,-46.03,-43.47,-40.56,-38.22,-36.88,-32.81,-33.59,-32.09,-29.94,-30.69,-30.72,-32.19,-35.41,-35.31,-38.78,-40.53,-42.06,-43.41,-44.72,-43.97,-43.38,-43.44,-41.91,-42.03,-40.94,-40.28,-38.88,-37.72,-35.47,-35.78,-36.53,-38.12,-38.53,-39.44,-41.16,-41.84,-41.59,-43.66,-45.44,-45.59,-47.28,-49.22,-48.72,-49.34,-49.34,-44.59,-41.84,-36.19,-32.91,-28.59,-27.38,-26.97,-28.75,-31.47,-33.66,-38.72,-39.0,-39.53,-39.47,-37.28,-36.22,-33.88,-34.09,-31.03,-31.72,-29.28,-29.59,-46.38,-45.59,-44.66,-46.59,-48.16,-48.44,-50.06,-48.59,-43.62,-42.03,-39.59,-35.12,-32.44,-31.53,-31.47,-31.38,-32.88,-34.03:-31.22,-32.28,-33.69,-33.75,-33.69,-33.03,-31.97,-32.97,-34.75,-36.72,-38.12,-41.09,-39.41,-36.59,-33.34,-28.47,-25.22,-22.84,-22.38,-22.78,-23.84,-25.72,-27.28,-30.09,-31.69,-33.0,-37.25,-38.34,-40.09,-43.22,-44.66,-48.41,-46.97,-47.28,-45.09,-42.19,-37.44,-35.12,-33.25,-33.31,-33.16,-33.91,-34.22,-34.41,-35.38,-37.66,-40.91,-42.84,-45.53,-47.72,-50.09,-52.22,-53.88,-56.19,-55.59,-53.97,-51.0,-48.53,-48.03,-47.12,-46.22,-46.19,-45.97,-45.09,-44.62,-46.0,-46.41,-47.5,-47.16,-48.47,-46.62,-43.91,-42.22,-35.81,-32.47,-27.28,-22.5,-21.88,-21.72,-24.03,-28.12,-29.72,-33.44,-34.72,-33.84,-35.66,-33.41,-31.41,-30.47,-30.88,-28.09,-28.16,-29.72,-29.72,-30.81,-29.97,-29.44,-28.41,-26.28,-25.0,-23.66,-24.84,-28.75,-28.53,-31.69,-32.66,-32.06,-31.91,-31.5,-30.72,-29.88,-31.06,-30.16,-30.03,-29.78,-28.28,-27.97,-26.47,-27.09,-25.09,-24.94,-24.16,-22.66,-25.09,-23.62,-26.16,-27.19,-27.72,-28.16,-28.03,-29.69,-30.28,-29.84,-30.84,-28.5,-26.28,-24.44,-22.16,-21.53,-21.22,-22.47,-25.69,-27.09,-29.34,-32.53,-34.06,-35.78,-37.25,-38.28,-38.47,-37.94,-37.22,-36.56,-34.66,-33.09,-33.47,-29.97,-28.62,-28.09,-27.34,-27.41,-28.41,-31.16,-31.66,-34.81,-34.75,-34.22,-34.91,-31.56,-31.22,-31.09,-29.12,-28.59,-26.5,-25.72,-24.53,-26.09,-26.72,-29.09,-31.28,-33.06,-34.84,-35.28,-36.81,-36.16,-36.69,-36.03,-36.06,-36.94,-35.97,-36.16,-35.47,-36.16,-35.41,-34.53,-35.56,-35.47,-34.28,-36.16,-34.66,-35.72,-34.81,-35.59,-34.69,-34.59,-35.09,-34.84,-33.94,-33.97,-32.94,-33.03,-31.97,-31.25,-29.88,-30.44,-28.97,-27.59,-28.09,-28.22,-28.47,-29.31,-30.03,-32.38,-33.28,-34.38,-35.06,-33.44,-33.44,-32.69,-29.91,-29.72,-29.09,-27.66,-28.34,-29.28,-31.16,-32.59,-33.41,-35.0,-37.84,-39.09,-41.66,-43.88,-43.06,-44.22,-40.59,-40.16,-38.97,-37.31,-36.16,-37.03,-36.34,-37.25,-39.0,-40.34,-42.69,-43.53,-45.88,-45.66,-44.59,-43.62,-41.66,-40.06,-40.41,-38.25,-38.34,-38.94,-38.19,-38.56,-38.34,-36.94,-37.25,-34.75,-33.78,-33.19,-32.47,-32.53,-34.44,-36.59,-37.59,-38.16,-38.66,-37.41,-35.0,-35.47,-32.78,-31.34,-30.47,-29.06,-27.28,-26.72,-28.22,-29.62,-29.78,-31.41,-34.41,-34.06,-35.84,-35.78,-37.0,-35.81,-36.69,-34.44,-34.53,-35.31,-37.38,-39.09,-40.19,-43.09,-42.22,-41.81,-41.19,-40.72,-40.91,-42.28,-44.16,-45.19,-47.84,-47.44,-48.34,-48.09,-47.28,-47.38,-46.81,-46.84,-44.66,-42.62,-40.22,-38.59,-35.81,-32.59,-32.47,-30.19,-31.72,-33.78,-36.34,-38.56,-40.06,-42.75,-43.09,-43.88,-46.41,-47.75,-47.81,-51.75,-49.88,-49.88,-47.91,-45.97,-45.06,-44.0,-44.44,-46.31,-45.69,-46.56,-45.53,-47.34,-46.72,-45.53,-45.44,-43.5,-42.28,-41.81,-39.16,-39.75,-38.69,-35.94,-36.5,-34.41,-34.47,-33.81,-34.22,-34.03,-33.75,-36.16,-37.91,-41.41,-44.34,-47.41,-47.34,-48.81,-48.34,-47.56,-46.78,-46.44,-43.03,-42.84,-40.44,-39.94,-39.97,-38.47,-37.66,-37.03,-35.38,-34.97,-36.34,-37.97,-38.88,-41.91,-43.78,-46.03,-47.19,-49.97,-50.91,-50.34,-53.47,-53.09,-53.59,-53.47,-53.44,-51.38,-48.53,-46.28,-45.03,-40.72,-42.34,-39.47,-41.25,-41.72,-43.59,-47.34,-49.22,-51.31,-52.28,-55.03,-54.81,-53.44,-56.16,-55.12,-52.5,-54.28,-52.56,-52.41,-52.69,-52.59,-54.62,-57.31,-56.78,-61.19,-60.81,-60.28,-61.53,-61.88,-62.66,-62.62,-61.59,-58.66,-55.0,-54.59,-53.41,-52.84,-53.28,-52.91,-51.97,-49.84,-48.94,-48.41,-51.81,-51.72,-53.66,-57.97,-57.91,-57.84,-55.34,-53.41,-49.53,-49.72,-47.0,-45.41,-43.69,-40.88,-41.09,-43.72,-43.56,-48.09,-54.03,-53.34,-55.09,-57.28,-56.59,-58.41,-59.88,-61.41,-61.41,-61.34,-57.97,-54.28,-50.53,-49.12,-45.69,-46.91,-47.16,-47.06,-48.19,-49.22,-51.94,-54.19,-56.53,-58.16,-60.16,-60.66,-58.84,-60.53,-57.97,-55.62,-54.97,-51.09,-49.34,-45.88,-45.53,-43.69,-43.38,-43.91,-43.03,-44.09,-45.66,-45.53,-47.09,-48.12,-47.81,-48.38,-46.91,-48.5,-47.31,-47.16,-45.69,-44.59,-42.59,-43.28,-43.88,-43.31,-44.91,-42.81,-42.5,-40.91,-39.72,-37.84,-36.28,-36.75,-36.28,-38.34,-40.09,-40.09,-40.69,-39.69,-40.28,-38.28,-39.5,-39.41,-39.28,-39.62,-38.66,-38.72,-39.0,-38.59,-38.72,-39.31,-40.06,-40.03,-37.94,-37.22,-37.44,-35.84,-36.34,-37.59,-36.66,-39.22,-39.81,-39.94,-40.66,-42.94,-41.53,-42.16,-46.16,-45.91,-46.56,-48.31,-47.34,-48.47,-45.84,-45.47,-45.38,-43.56,-43.16,-43.72,-43.78,-42.69,-42.88,-41.34,-41.5,-39.81,-37.81,-36.84,-35.97,-34.97,-36.59,-39.78,-40.16,-42.03,-45.5,-44.78,-46.78,-46.09,-47.0,-46.53,-46.5,-48.03,-46.47,-46.59,-44.91,-42.44,-42.28,-40.06,-39.38,-38.09,-35.72,-34.19,-32.38,-31.06,-31.31,-31.09,-34.03,-38.59,-42.47,-42.28,-43.06,-41.22,-37.69,-34.78,-34.34,-35.59,-34.41,-38.72,-36.19,-35.72,-35.81,-33.88,-33.34,-33.59,-36.16,-36.81,-38.78,-41.0,-40.19,-39.22,-37.09,-35.94,-34.72,-33.47,-32.84,-33.34,-33.5,-34.28,-36.84,-38.59,-39.34,-39.28,-38.34,-37.19,-37.34,-36.47,-38.56,-37.72,-37.84,-36.97,-34.88,-33.88,-33.41,-30.94,-31.41,-31.47,-33.91,-33.75,-37.06,-36.59,-37.34,-37.31,-37.47,-36.25,-36.66,-38.19,-36.22,-35.66,-32.72,-31.16,-28.84,-27.28,-28.06,-30.91,-32.53,-32.88,-32.72,-31.78,-29.84,-29.56,-29.47,-30.28,-31.94,-31.0,-31.41,-31.72,-32.41,-32.66,-32.28,-32.69,-33.0,-31.91,-33.38,-33.62,-33.97,-33.66,-32.66,-32.84,-31.62,-31.78,-32.75,-32.31,-34.28,-34.25,-35.69,-37.09,-38.03,-37.78,-40.66,-37.47,-37.78,-36.47,-36.22,-35.78,-36.41,-37.25,-39.34,-39.91,-39.94,-40.03,-39.62,-39.41,-40.06,-40.16,-41.72,-44.28,-46.28,-47.38,-48.94,-48.94,-48.09,-47.12,-47.22,-46.03,-45.34,-44.34,-43.5,-42.09,-42.97,-42.5,-44.53,-44.16,-44.53,-47.16,-45.41,-44.59,-45.28,-43.91,-41.84,-41.19,-39.59,-36.72,-34.88,-32.72,-31.09,-30.06,-31.69,-31.66,-31.12,-32.25,-34.03,-34.19,-33.94,-36.75,-37.69,-36.69,-36.62,-37.47,-37.94,-37.56,-39.59,-40.44,-42.94,-45.75,-46.34,-48.34,-48.69,-46.16,-44.16,-41.91,-39.78,-37.22,-36.84,-36.31,-38.03,-38.94,-41.66,-45.09,-46.06,-46.34,-46.03,-43.47,-40.56,-38.22,-36.88,-32.81,-33.59,-32.09,-29.94,-30.69,-30.72,-32.19,-35.41,-35.31,-38.78,-40.53,-42.06,-43.41,-44.72,-43.97,-43.38,-43.44,-41.91,-42.03,-40.94,-40.28,-38.88,-37.72,-35.47,-35.78,-36.53,-38.12,-38.53,-39.44,-41.16,-41.84,-41.59,-43.66,-45.44,-45.59,-47.28,-49.22,-48.72,-49.34,-49.34,-44.59,-41.84,-36.19,-32.91,-28.59,-27.38,-26.97,-28.75,-31.47,-33.66,-38.72,-39.0,-39.53,-39.47,-37.28,-36.22,-33.88,-34.09,-31.03,-31.72,-29.28,-29.59,-46.38,-45.59,-44.66,-46.59,-48.16,-48.44,-50.06,-48.59,-43.62,-42.03,-39.59,-35.12,-32.44,-31.53,-31.47,-31.38,-32.88,-34.03,-35.84,-36.69,-37.84,-37.12,-39.94,-40.28:-31.97,-32.97,-34.75,-36.72,-38.12,-41.09,-39.41,-36.59,-33.34,-28.47,-25.22,-22.84,-22.38,-22.78,-23.84,-25.72,-27.28,-30.09,-31.69,-33.0,-37.25,-38.34,-40.09,-43.22,-44.66,-48.41,-46.97,-47.28,-45.09,-42.19,-37.44,-35.12,-33.25,-33.31,-33.16,-33.91,-34.22,-34.41,-35.38,-37.66,-40.91,-42.84,-45.53,-47.72,-50.09,-52.22,-53.88,-56.19,-55.59,-53.97,-51.0,-48.53,-48.03,-47.12,-46.22,-46.19,-45.97,-45.09,-44.62,-46.0,-46.41,-47.5,-47.16,-48.47,-46.62,-43.91,-42.22,-35.81,-32.47,-27.28,-22.5,-21.88,-21.72,-24.03,-28.12,-29.72,-33.44,-34.72,-33.84,-35.66,-33.41,-31.41,-30.47,-30.88,-28.09,-28.16,-29.72,-29.72,-30.81,-29.97,-29.44,-28.41,-26.28,-25.0,-23.66,-24.84,-28.75,-28.53,-31.69,-32.66,-32.06,-31.91,-31.5,-30.72,-29.88,-31.06,-30.16,-30.03,-29.78,-28.28,-27.97,-26.47,-27.09,-25.09,-24.94,-24.16,-22.66,-25.09,-23.62,-26.16,-27.19,-27.72,-28.16,-28.03,-29.69,-30.28,-29.84,-30.84,-28.5,-26.28,-24.44,-22.16,-21.53,-21.22,-22.47,-25.69,-27.09,-29.34,-32.53,-34.06,-35.78,-37.25,-38.28,-38.47,-37.94,-37.22,-36.56,-34.66,-33.09,-33.47,-29.97,-28.62,-28.09,-27.34,-27.41,-28.41,-31.16,-31.66,-34.81,-34.75,-34.22,-34.91,-31.56,-31.22,-31.09,-29.12,-28.59,-26.5,-25.72,-24.53,-26.09,-26.72,-29.09,-31.28,-33.06,-34.84,-35.28,-36.81,-36.16,-36.69,-36.03,-36.06,-36.94,-35.97,-36.16,-35.47,-36.16,-35.41,-34.53,-35.56,-35.47,-34.28,-36.16,-34.66,-35.72,-34.81,-35.59,-34.69,-34.59,-35.09,-34.84,-33.94,-33.97,-32.94,-33.03,-31.97,-31.25,-29.88,-30.44,-28.97,-27.59,-28.09,-28.22,-28.47,-29.31,-30.03,-32.38,-33.28,-34.38,-35.06,-33.44,-33.44,-32.69,-29.91,-29.72,-29.09,-27.66,-28.34,-29.28,-31.16,-32.59,-33.41,-35.0,-37.84,-39.09,-41.66,-43.88,-43.06,-44.22,-40.59,-40.16,-38.97,-37.31,-36.16,-37.03,-36.34,-37.25,-39.0,-40.34,-42.69,-43.53,-45.88,-45.66,-44.59,-43.62,-41.66,-40.06,-40.41,-38.25,-38.34,-38.94,-38.19,-38.56,-38.34,-36.94,-37.25,-34.75,-33.78,-33.19,-32.47,-32.53,-34.44,-36.59,-37.59,-38.16,-38.66,-37.41,-35.0,-35.47,-32.78,-31.34,-30.47,-29.06,-27.28,-26.72,-28.22,-29.62,-29.78,-31.41,-34.41,-34.06,-35.84,-35.78,-37.0,-35.81,-36.69,-34.44,-34.53,-35.31,-37.38,-39.09,-40.19,-43.09,-42.22,-41.81,-41.19,-40.72,-40.91,-42.28,-44.16,-45.19,-47.84,-47.44,-48.34,-48.09,-47.28,-47.38,-46.81,-46.84,-44.66,-42.62,-40.22,-38.59,-35.81,-32.59,-32.47,-30.19,-31.72,-33.78,-36.34,-38.56,-40.06,-42.75,-43.09,-43.88,-46.41,-47.75,-47.81,-51.75,-49.88,-49.88,-47.91,-45.97,-45.06,-44.0,-44.44,-46.31,-45.69,-46.56,-45.53,-47.34,-46.72,-45.53,-45.44,-43.5,-42.28,-41.81,-39.16,-39.75,-38.69,-35.94,-36.5,-34.41,-34.47,-33.81,-34.22,-34.03,-33.75,-36.16,-37.91,-41.41,-44.34,-47.41,-47.34,-48.81,-48.34,-47.56,-46.78,-46.44,-43.03,-42.84,-40.44,-39.94,-39.97,-38.47,-37.66,-37.03,-35.38,-34.97,-36.34,-37.97,-38.88,-41.91,-43.78,-46.03,-47.19,-49.97,-50.91,-50.34,-53.47,-53.09,-53.59,-53.47,-53.44,-51.38,-48.53,-46.28,-45.03,-40.72,-42.34,-39.47,-41.25,-41.72,-43.59,-47.34,-49.22,-51.31,-52.28,-55.03,-54.81,-53.44,-56.16,-55.12,-52.5,-54.28,-52.56,-52.41,-52.69,-52.59,-54.62,-57.31,-56.78,-61.19,-60.81,-60.28,-61.53,-61.88,-62.66,-62.62,-61.59,-58.66,-55.0,-54.59,-53.41,-52.84,-53.28,-52.91,-51.97,-49.84,-48.94,-48.41,-51.81,-51.72,-53.66,-57.97,-57.91,-57.84,-55.34,-53.41,-49.53,-49.72,-47.0,-45.41,-43.69,-40.88,-41.09,-43.72,-43.56,-48.09,-54.03,-53.34,-55.09,-57.28,-56.59,-58.41,-59.88,-61.41,-61.41,-61.34,-57.97,-54.28,-50.53,-49.12,-45.69,-46.91,-47.16,-47.06,-48.19,-49.22,-51.94,-54.19,-56.53,-58.16,-60.16,-60.66,-58.84,-60.53,-57.97,-55.62,-54.97,-51.09,-49.34,-45.88,-45.53,-43.69,-43.38,-43.91,-43.03,-44.09,-45.66,-45.53,-47.09,-48.12,-47.81,-48.38,-46.91,-48.5,-47.31,-47.16,-45.69,-44.59,-42.59,-43.28,-43.88,-43.31,-44.91,-42.81,-42.5,-40.91,-39.72,-37.84,-36.28,-36.75,-36.28,-38.34,-40.09,-40.09,-40.69,-39.69,-40.28,-38.28,-39.5,-39.41,-39.28,-39.62,-38.66,-38.72,-39.0,-38.59,-38.72,-39.31,-40.06,-40.03,-37.94,-37.22,-37.44,-35.84,-36.34,-37.59,-36.66,-39.22,-39.81,-39.94,-40.66,-42.94,-41.53,-42.16,-46.16,-45.91,-46.56,-48.31,-47.34,-48.47,-45.84,-45.47,-45.38,-43.56,-43.16,-43.72,-43.78,-42.69,-42.88,-41.34,-41.5,-39.81,-37.81,-36.84,-35.97,-34.97,-36.59,-39.78,-40.16,-42.03,-45.5,-44.78,-46.78,-46.09,-47.0,-46.53,-46.5,-48.03,-46.47,-46.59,-44.91,-42.44,-42.28,-40.06,-39.38,-38.09,-35.72,-34.19,-32.38,-31.06,-31.31,-31.09,-34.03,-38.59,-42.47,-42.28,-43.06,-41.22,-37.69,-34.78,-34.34,-35.59,-34.41,-38.72,-36.19,-35.72,-35.81,-33.88,-33.34,-33.59,-36.16,-36.81,-38.78,-41.0,-40.19,-39.22,-37.09,-35.94,-34.72,-33.47,-32.84,-33.34,-33.5,-34.28,-36.84,-38.59,-39.34,-39.28,-38.34,-37.19,-37.34,-36.47,-38.56,-37.72,-37.84,-36.97,-34.88,-33.88,-33.41,-30.94,-31.41,-31.47,-33.91,-33.75,-37.06,-36.59,-37.34,-37.31,-37.47,-36.25,-36.66,-38.19,-36.22,-35.66,-32.72,-31.16,-28.84,-27.28,-28.06,-30.91,-32.53,-32.88,-32.72,-31.78,-29.84,-29.56,-29.47,-30.28,-31.94,-31.0,-31.41,-31.72,-32.41,-32.66,-32.28,-32.69,-33.0,-31.91,-33.38,-33.62,-33.97,-33.66,-32.66,-32.84,-31.62,-31.78,-32.75,-32.31,-34.28,-34.25,-35.69,-37.09,-38.03,-37.78,-40.66,-37.47,-37.78,-36.47,-36.22,-35.78,-36.41,-37.25,-39.34,-39.91,-39.94,-40.03,-39.62,-39.41,-40.06,-40.16,-41.72,-44.28,-46.28,-47.38,-48.94,-48.94,-48.09,-47.12,-47.22,-46.03,-45.34,-44.34,-43.5,-42.09,-42.97,-42.5,-44.53,-44.16,-44.53,-47.16,-45.41,-44.59,-45.28,-43.91,-41.84,-41.19,-39.59,-36.72,-34.88,-32.72,-31.09,-30.06,-31.69,-31.66,-31.12,-32.25,-34.03,-34.19,-33.94,-36.75,-37.69,-36.69,-36.62,-37.47,-37.94,-37.56,-39.59,-40.44,-42.94,-45.75,-46.34,-48.34,-48.69,-46.16,-44.16,-41.91,-39.78,-37.22,-36.84,-36.31,-38.03,-38.94,-41.66,-45.09,-46.06,-46.34,-46.03,-43.47,-40.56,-38.22,-36.88,-32.81,-33.59,-32.09,-29.94,-30.69,-30.72,-32.19,-35.41,-35.31,-38.78,-40.53,-42.06,-43.41,-44.72,-43.97,-43.38,-43.44,-41.91,-42.03,-40.94,-40.28,-38.88,-37.72,-35.47,-35.78,-36.53,-38.12,-38.53,-39.44,-41.16,-41.84,-41.59,-43.66,-45.44,-45.59,-47.28,-49.22,-48.72,-49.34,-49.34,-44.59,-41.84,-36.19,-32.91,-28.59,-27.38,-26.97,-28.75,-31.47,-33.66,-38.72,-39.0,-39.53,-39.47,-37.28,-36.22,-33.88,-34.09,-31.03,-31.72,-29.28,-29.59,-46.38,-45.59,-44.66,-46.59,-48.16,-48.44,-50.06,-48.59,-43.62,-42.03,-39.59,-35.12,-32.44,-31.53,-31.47,-31.38,-32.88,-34.03,-35.84,-36.69,-37.84,-37.12,-39.94,-40.28,-41.22,-46.12,-46.0,-48.0,-53.12,-49.03:positivity
20.91,20.91,18.75,16.16,15.25,14.19,14.16,16.34,18.44,22.47,24.0,25.81,26.53,25.97,23.69,21.69,18.81,15.44,14.66,13.69,13.31,14.72,16.97,19.47,21.38,22.97,24.44,24.19,24.5,23.66,22.56,20.91,19.31,17.91,16.5,14.25,14.19,13.03,12.16,11.44,11.31,11.38,12.44,12.22,12.56,12.19,11.94,11.34,10.56,10.84,11.0,10.44,10.53,10.31,9.38,8.47,7.91,5.44,4.16,3.41,2.31,2.0,2.72,3.25,4.44,5.81,7.81,9.06,9.81,8.31,6.66,4.19,2.22,0.69,-1.34,-2.16,-4.09,-5.34,-5.16,-5.31,-5.06,-4.75,-4.53,-3.66,-2.69,-1.0,-0.34,1.41,0.5,-0.5,-1.16,-4.38,-7.28,-8.62,-10.28,-11.53,-11.03,-10.12,-9.59,-7.62,-5.97,-3.78,-1.75,0.0,0.03,0.12,-0.44,-1.28,-1.66,-0.47,-0.28,0.16,1.62,2.19,3.41,4.81,5.44,5.44,3.69,1.47,-0.06,-2.06,-2.91,-3.28,-4.12,-4.78,-5.22,-7.75,-8.84,-11.09,-13.03,-14.69,-15.41,-14.97,-12.94,-11.59,-9.84,-7.41,-6.16,-5.66,-5.28,-5.66,-6.78,-7.44,-9.69,-11.12,-10.31,-10.84,-10.88,-10.12,-10.84,-11.22,-11.94,-11.72,-10.84,-8.72,-5.28,-1.22,1.41,5.0,6.5,6.62,5.0,2.91,1.28,-0.81,-2.34,-4.19,-4.84,-6.09,-6.66,-7.47,-6.72,-6.09,-6.53,-5.28,-7.44,-8.72,-9.53,-10.62,-10.09,-9.69,-8.03,-5.28,-4.16,-2.62,-1.66,-0.97,-2.28,-3.84,-6.47,-8.09,-9.09,-9.28,-8.56,-6.88,-5.91,-5.91,-6.69,-7.75,-8.22,-9.53,-10.28,-10.38,-11.31,-10.94,-8.09,-6.22,-1.94,1.19,4.25,5.91,6.28,5.5,3.78,2.12,-0.09,-0.97,-2.59,-2.47,-1.97,-1.78,-1.31,-0.59,-0.56,-0.66,-0.84,-1.66,-1.75,-1.28,0.06,1.62,3.12,4.81,4.31,3.44,2.72,0.34,-1.09,-2.44,-4.66,-7.09,-8.16,-9.66,-9.84,-9.78,-9.47,-8.84,-8.97,-9.47,-9.56,-10.06,-10.03,-10.0,-10.38,-8.97,-7.44,-6.62,-5.84,-5.28,-6.84,-7.53,-9.09,-10.09,-10.66,-10.16,-8.94,-6.53,-5.47,-3.16,-1.94,-1.91,-3.03,-3.97,-4.91,-4.97,-5.31,-4.0,-3.97,-2.66,-2.34,-1.72,-1.03,-0.84,0.03,-0.69,-1.34,-1.88,-3.06,-4.81,-6.19,-8.41,-10.53,-12.59,-14.91,-16.38,-18.69,-18.53,-18.06,-17.66,-17.12,-15.59,-15.56,-13.78,-13.0,-11.28,-9.41,-7.88,-6.69,-6.28,-6.47,-5.78,-5.72,-5.78,-5.5,-6.25,-7.16,-8.88,-11.03,-13.34,-13.84,-14.06,-14.53,-13.16,-11.09,-9.31,-7.09,-5.47,-5.69,-6.28,-8.03,-10.97,-15.0,-17.72,-19.84,-21.31,-21.75,-21.22,-20.03,-18.69,-18.03,-18.03,-17.81,-16.59,-16.44,-16.06,-14.53,-12.94,-10.84,-9.34,-7.91,-7.66,-8.5,-8.28,-9.59,-9.97,-9.91,-10.56,-10.97,-11.47,-11.44,-10.44,-9.34,-7.78,-6.59,-6.28,-5.72,-5.84,-6.59,-6.84,-6.56,-6.06,-4.78,-3.81,-2.44,-2.44,-3.81,-5.78,-9.16,-12.16,-13.59,-14.75,-14.69,-13.47,-11.56,-9.31,-8.09,-6.84,-4.84,-3.84,-3.53,-2.5,-2.53,-2.31,-2.44,-2.84,-3.12,-3.97,-4.53,-4.94,-5.44,-6.06,-6.53,-7.84,-8.41,-9.94,-10.72,-10.69,-9.22,-7.19,-3.75,0.84,4.0,6.53,7.03,5.81,3.34,-0.28,-4.59,-8.41,-11.34,-14.03,-15.84,-16.19,-16.88,-17.44,-16.47,-16.34,-16.69,-15.97,-14.78,-14.19,-14.16,-13.19,-13.16,-12.59,-12.25,-11.47,-10.91,-8.97,-8.31,-7.53,-6.78,-6.28,-5.91,-5.78,-6.09,-6.59,-6.47,-6.03,-6.47,-5.78,-5.19,-5.41,-5.22,-6.19,-6.03,-6.31,-6.06,-5.91,-6.97,-7.22,-7.47,-7.28,-7.19,-6.09,-3.91,-1.47,1.19,2.56,4.72,4.81,5.66,5.28,5.12,5.88,5.38,5.41,4.34,3.53,2.66,1.53,0.62,-0.84,-1.66,-1.66,-2.09,-1.53,-0.84,-0.12,0.19,-0.19,0.03,-0.34,-1.06,-1.44,-1.72,-2.28,-2.19,-3.22,-3.91,-5.53,-6.66,-6.88,-7.22,-7.5,-7.47,-7.84,-9.5,-10.16,-11.0,-11.84,-11.84,-12.56,-13.5,-13.81,-14.28,-14.0,-12.75,-12.16,-11.12,-9.56,-8.53,-7.69,-7.88,-7.84,-8.38,-8.47,-8.41,-8.69,-8.72,-9.0,-10.69,-11.22,-11.53,-11.09,-10.53,-8.56,-7.31,-4.75,-3.41,-2.84,-3.84,-5.62,-8.38,-10.84,-13.53,-14.91,-15.97,-16.25,-16.38,-16.41,-15.59,-15.62,-15.31,-15.22,-15.38,-15.38,-14.66,-14.03,-13.25,-12.81,-13.03,-12.75,-11.91,-11.91,-11.59,-10.91,-11.34,-11.91,-14.22,-14.78,-16.56,-18.16,-18.94,-20.25,-19.81,-20.44,-20.72,-20.78,-21.09,-21.41,-21.19,-19.78,-17.84,-15.69,-13.03,-11.56,-10.69,-10.97,-11.16,-12.66,-14.91,-16.41,-17.53,-18.12,-18.84,-18.34,-18.78,-18.28,-17.59,-16.84,-15.91,-14.0,-13.69,-11.84,-11.69,-10.38,-9.09,-8.41,-6.47,-5.47,-4.84,-3.78,-3.69,-3.34,-3.66,-2.91,-3.25,-4.22,-5.38,-5.66,-6.03,-5.34,-4.53,-4.16,-3.88,-4.47,-5.47,-7.44,-8.72,-9.0,-9.5,-10.16,-10.22,-9.84,-9.03,-9.75,-9.75,-9.38,-8.72,-8.12,-7.62,-7.12,-6.88,-7.22,-6.72,-7.28,-6.47,-6.03,-6.19,-5.66,-5.81,-4.81,-3.69,-3.22,-2.97,-2.03,-2.78,-3.34,-5.03,-6.5,-8.34,-9.97,-10.78,-11.78,-11.34,-10.16,-8.44,-6.25,-3.12,-0.84,0.59,1.41,1.19,0.22,-0.72,-1.09,0.06,0.56,2.09,4.06,4.16,3.12,1.25,-1.81,-4.22,-6.28,-7.03,-7.28,-7.0,-6.44,-6.69,-7.88,-8.47,-9.97,-12.03,-13.38,-15.19,-14.88,-14.28,-11.91,-8.41,-4.84,-1.59,0.66,1.41,2.38,2.75,1.5,1.53,0.56,-0.03,0.16,1.91,4.16,6.28,9.06,10.72,10.25,9.28,7.44,5.06,2.78,0.38,-0.88,-0.81,-0.28,0.75,2.41,4.53,6.19,7.44,9.12,10.59,12.62,14.19,15.75,17.56,18.69,18.91,19.81,18.81,17.81,17.44,15.03,13.09,11.62,10.91,10.22,10.44,10.19,10.69,11.19,11.81,12.38,13.28,14.97,15.5,16.62,17.25,17.75,18.56,18.28,19.03,17.78,17.31,15.94,15.81,14.47,15.0,15.41,16.5,17.03,18.56,18.81,18.5,17.41,15.69,13.66,12.09,11.66,11.22,12.34,15.62,18.31,22.47,25.31,26.16,25.91,23.5,19.28,14.62,10.25,7.81,6.44,5.75,7.0,7.88,8.75,8.28,7.84,7.56,6.97,5.53,5.44,5.78,6.19,7.56,9.56,11.41,13.59,13.88,13.94,12.56,10.31,8.44,6.41,5.31,4.53,4.94,5.38,5.84,6.03,6.44,6.0,4.12,2.62,0.38,-1.66,-2.78,-3.72,-3.69,-2.69,-0.41,2.19,4.12,6.47,7.91,7.0,5.56,2.91,-0.28,-2.94,-5.09,-6.28,-5.94,-4.84,-3.28,-1.78,0.09,1.44,1.66,1.81,1.34,1.31,1.31,1.03,2.41,3.31,5.12,7.59,9.16,10.59,10.97,10.91,10.06,9.22,8.12,7.62,6.25,5.28,3.19,1.94,-0.03,-2.09,-3.06,-4.81,-6.09,-6.03,-6.47,-5.94,-3.66,-1.91,0.5,2.31,4.0,5.38,5.81,5.25,3.66,2.66,0.38,-1.56,-3.53,-4.03:14.16,16.34,18.44,22.47,24.0,25.81,26.53,25.97,23.69,21.69,18.81,15.44,14.66,13.69,13.31,14.72,16.97,19.47,21.38,22.97,24.44,24.19,24.5,23.66,22.56,20.91,19.31,17.91,16.5,14.25,14.19,13.03,12.16,11.44,11.31,11.38,12.44,12.22,12.56,12.19,11.94,11.34,10.56,10.84,11.0,10.44,10.53,10.31,9.38,8.47,7.91,5.44,4.16,3.41,2.31,2.0,2.72,3.25,4.44,5.81,7.81,9.06,9.81,8.31,6.66,4.19,2.22,0.69,-1.34,-2.16,-4.09,-5.34,-5.16,-5.31,-5.06,-4.75,-4.53,-3.66,-2.69,-1.0,-0.34,1.41,0.5,-0.5,-1.16,-4.38,-7.28,-8.62,-10.28,-11.53,-11.03,-10.12,-9.59,-7.62,-5.97,-3.78,-1.75,0.0,0.03,0.12,-0.44,-1.28,-1.66,-0.47,-0.28,0.16,1.62,2.19,3.41,4.81,5.44,5.44,3.69,1.47,-0.06,-2.06,-2.91,-3.28,-4.12,-4.78,-5.22,-7.75,-8.84,-11.09,-13.03,-14.69,-15.41,-14.97,-12.94,-11.59,-9.84,-7.41,-6.16,-5.66,-5.28,-5.66,-6.78,-7.44,-9.69,-11.12,-10.31,-10.84,-10.88,-10.12,-10.84,-11.22,-11.94,-11.72,-10.84,-8.72,-5.28,-1.22,1.41,5.0,6.5,6.62,5.0,2.91,1.28,-0.81,-2.34,-4.19,-4.84,-6.09,-6.66,-7.47,-6.72,-6.09,-6.53,-5.28,-7.44,-8.72,-9.53,-10.62,-10.09,-9.69,-8.03,-5.28,-4.16,-2.62,-1.66,-0.97,-2.28,-3.84,-6.47,-8.09,-9.09,-9.28,-8.56,-6.88,-5.91,-5.91,-6.69,-7.75,-8.22,-9.53,-10.28,-10.38,-11.31,-10.94,-8.09,-6.22,-1.94,1.19,4.25,5.91,6.28,5.5,3.78,2.12,-0.09,-0.97,-2.59,-2.47,-1.97,-1.78,-1.31,-0.59,-0.56,-0.66,-0.84,-1.66,-1.75,-1.28,0.06,1.62,3.12,4.81,4.31,3.44,2.72,0.34,-1.09,-2.44,-4.66,-7.09,-8.16,-9.66,-9.84,-9.78,-9.47,-8.84,-8.97,-9.47,-9.56,-10.06,-10.03,-10.0,-10.38,-8.97,-7.44,-6.62,-5.84,-5.28,-6.84,-7.53,-9.09,-10.09,-10.66,-10.16,-8.94,-6.53,-5.47,-3.16,-1.94,-1.91,-3.03,-3.97,-4.91,-4.97,-5.31,-4.0,-3.97,-2.66,-2.34,-1.72,-1.03,-0.84,0.03,-0.69,-1.34,-1.88,-3.06,-4.81,-6.19,-8.41,-10.53,-12.59,-14.91,-16.38,-18.69,-18.53,-18.06,-17.66,-17.12,-15.59,-15.56,-13.78,-13.0,-11.28,-9.41,-7.88,-6.69,-6.28,-6.47,-5.78,-5.72,-5.78,-5.5,-6.25,-7.16,-8.88,-11.03,-13.34,-13.84,-14.06,-14.53,-13.16,-11.09,-9.31,-7.09,-5.47,-5.69,-6.28,-8.03,-10.97,-15.0,-17.72,-19.84,-21.31,-21.75,-21.22,-20.03,-18.69,-18.03,-18.03,-17.81,-16.59,-16.44,-16.06,-14.53,-12.94,-10.84,-9.34,-7.91,-7.66,-8.5,-8.28,-9.59,-9.97,-9.91,-10.56,-10.97,-11.47,-11.44,-10.44,-9.34,-7.78,-6.59,-6.28,-5.72,-5.84,-6.59,-6.84,-6.56,-6.06,-4.78,-3.81,-2.44,-2.44,-3.81,-5.78,-9.16,-12.16,-13.59,-14.75,-14.69,-13.47,-11.56,-9.31,-8.09,-6.84,-4.84,-3.84,-3.53,-2.5,-2.53,-2.31,-2.44,-2.84,-3.12,-3.97,-4.53,-4.94,-5.44,-6.06,-6.53,-7.84,-8.41,-9.94,-10.72,-10.69,-9.22,-7.19,-3.75,0.84,4.0,6.53,7.03,5.81,3.34,-0.28,-4.59,-8.41,-11.34,-14.03,-15.84,-16.19,-16.88,-17.44,-16.47,-16.34,-16.69,-15.97,-14.78,-14.19,-14.16,-13.19,-13.16,-12.59,-12.25,-11.47,-10.91,-8.97,-8.31,-7.53,-6.78,-6.28,-5.91,-5.78,-6.09,-6.59,-6.47,-6.03,-6.47,-5.78,-5.19,-5.41,-5.22,-6.19,-6.03,-6.31,-6.06,-5.91,-6.97,-7.22,-7.47,-7.28,-7.19,-6.09,-3.91,-1.47,1.19,2.56,4.72,4.81,5.66,5.28,5.12,5.88,5.38,5.41,4.34,3.53,2.66,1.53,0.62,-0.84,-1.66,-1.66,-2.09,-1.53,-0.84,-0.12,0.19,-0.19,0.03,-0.34,-1.06,-1.44,-1.72,-2.28,-2.19,-3.22,-3.91,-5.53,-6.66,-6.88,-7.22,-7.5,-7.47,-7.84,-9.5,-10.16,-11.0,-11.84,-11.84,-12.56,-13.5,-13.81,-14.28,-14.0,-12.75,-12.16,-11.12,-9.56,-8.53,-7.69,-7.88,-7.84,-8.38,-8.47,-8.41,-8.69,-8.72,-9.0,-10.69,-11.22,-11.53,-11.09,-10.53,-8.56,-7.31,-4.75,-3.41,-2.84,-3.84,-5.62,-8.38,-10.84,-13.53,-14.91,-15.97,-16.25,-16.38,-16.41,-15.59,-15.62,-15.31,-15.22,-15.38,-15.38,-14.66,-14.03,-13.25,-12.81,-13.03,-12.75,-11.91,-11.91,-11.59,-10.91,-11.34,-11.91,-14.22,-14.78,-16.56,-18.16,-18.94,-20.25,-19.81,-20.44,-20.72,-20.78,-21.09,-21.41,-21.19,-19.78,-17.84,-15.69,-13.03,-11.56,-10.69,-10.97,-11.16,-12.66,-14.91,-16.41,-17.53,-18.12,-18.84,-18.34,-18.78,-18.28,-17.59,-16.84,-15.91,-14.0,-13.69,-11.84,-11.69,-10.38,-9.09,-8.41,-6.47,-5.47,-4.84,-3.78,-3.69,-3.34,-3.66,-2.91,-3.25,-4.22,-5.38,-5.66,-6.03,-5.34,-4.53,-4.16,-3.88,-4.47,-5.47,-7.44,-8.72,-9.0,-9.5,-10.16,-10.22,-9.84,-9.03,-9.75,-9.75,-9.38,-8.72,-8.12,-7.62,-7.12,-6.88,-7.22,-6.72,-7.28,-6.47,-6.03,-6.19,-5.66,-5.81,-4.81,-3.69,-3.22,-2.97,-2.03,-2.78,-3.34,-5.03,-6.5,-8.34,-9.97,-10.78,-11.78,-11.34,-10.16,-8.44,-6.25,-3.12,-0.84,0.59,1.41,1.19,0.22,-0.72,-1.09,0.06,0.56,2.09,4.06,4.16,3.12,1.25,-1.81,-4.22,-6.28,-7.03,-7.28,-7.0,-6.44,-6.69,-7.88,-8.47,-9.97,-12.03,-13.38,-15.19,-14.88,-14.28,-11.91,-8.41,-4.84,-1.59,0.66,1.41,2.38,2.75,1.5,1.53,0.56,-0.03,0.16,1.91,4.16,6.28,9.06,10.72,10.25,9.28,7.44,5.06,2.78,0.38,-0.88,-0.81,-0.28,0.75,2.41,4.53,6.19,7.44,9.12,10.59,12.62,14.19,15.75,17.56,18.69,18.91,19.81,18.81,17.81,17.44,15.03,13.09,11.62,10.91,10.22,10.44,10.19,10.69,11.19,11.81,12.38,13.28,14.97,15.5,16.62,17.25,17.75,18.56,18.28,19.03,17.78,17.31,15.94,15.81,14.47,15.0,15.41,16.5,17.03,18.56,18.81,18.5,17.41,15.69,13.66,12.09,11.66,11.22,12.34,15.62,18.31,22.47,25.31,26.16,25.91,23.5,19.28,14.62,10.25,7.81,6.44,5.75,7.0,7.88,8.75,8.28,7.84,7.56,6.97,5.53,5.44,5.78,6.19,7.56,9.56,11.41,13.59,13.88,13.94,12.56,10.31,8.44,6.41,5.31,4.53,4.94,5.38,5.84,6.03,6.44,6.0,4.12,2.62,0.38,-1.66,-2.78,-3.72,-3.69,-2.69,-0.41,2.19,4.12,6.47,7.91,7.0,5.56,2.91,-0.28,-2.94,-5.09,-6.28,-5.94,-4.84,-3.28,-1.78,0.09,1.44,1.66,1.81,1.34,1.31,1.31,1.03,2.41,3.31,5.12,7.59,9.16,10.59,10.97,10.91,10.06,9.22,8.12,7.62,6.25,5.28,3.19,1.94,-0.03,-2.09,-3.06,-4.81,-6.09,-6.03,-6.47,-5.94,-3.66,-1.91,0.5,2.31,4.0,5.38,5.81,5.25,3.66,2.66,0.38,-1.56,-3.53,-4.03,8.0,7.28,7.44,7.16,7.25,8.09:26.53,25.97,23.69,21.69,18.81,15.44,14.66,13.69,13.31,14.72,16.97,19.47,21.38,22.97,24.44,24.19,24.5,23.66,22.56,20.91,19.31,17.91,16.5,14.25,14.19,13.03,12.16,11.44,11.31,11.38,12.44,12.22,12.56,12.19,11.94,11.34,10.56,10.84,11.0,10.44,10.53,10.31,9.38,8.47,7.91,5.44,4.16,3.41,2.31,2.0,2.72,3.25,4.44,5.81,7.81,9.06,9.81,8.31,6.66,4.19,2.22,0.69,-1.34,-2.16,-4.09,-5.34,-5.16,-5.31,-5.06,-4.75,-4.53,-3.66,-2.69,-1.0,-0.34,1.41,0.5,-0.5,-1.16,-4.38,-7.28,-8.62,-10.28,-11.53,-11.03,-10.12,-9.59,-7.62,-5.97,-3.78,-1.75,0.0,0.03,0.12,-0.44,-1.28,-1.66,-0.47,-0.28,0.16,1.62,2.19,3.41,4.81,5.44,5.44,3.69,1.47,-0.06,-2.06,-2.91,-3.28,-4.12,-4.78,-5.22,-7.75,-8.84,-11.09,-13.03,-14.69,-15.41,-14.97,-12.94,-11.59,-9.84,-7.41,-6.16,-5.66,-5.28,-5.66,-6.78,-7.44,-9.69,-11.12,-10.31,-10.84,-10.88,-10.12,-10.84,-11.22,-11.94,-11.72,-10.84,-8.72,-5.28,-1.22,1.41,5.0,6.5,6.62,5.0,2.91,1.28,-0.81,-2.34,-4.19,-4.84,-6.09,-6.66,-7.47,-6.72,-6.09,-6.53,-5.28,-7.44,-8.72,-9.53,-10.62,-10.09,-9.69,-8.03,-5.28,-4.16,-2.62,-1.66,-0.97,-2.28,-3.84,-6.47,-8.09,-9.09,-9.28,-8.56,-6.88,-5.91,-5.91,-6.69,-7.75,-8.22,-9.53,-10.28,-10.38,-11.31,-10.94,-8.09,-6.22,-1.94,1.19,4.25,5.91,6.28,5.5,3.78,2.12,-0.09,-0.97,-2.59,-2.47,-1.97,-1.78,-1.31,-0.59,-0.56,-0.66,-0.84,-1.66,-1.75,-1.28,0.06,1.62,3.12,4.81,4.31,3.44,2.72,0.34,-1.09,-2.44,-4.66,-7.09,-8.16,-9.66,-9.84,-9.78,-9.47,-8.84,-8.97,-9.47,-9.56,-10.06,-10.03,-10.0,-10.38,-8.97,-7.44,-6.62,-5.84,-5.28,-6.84,-7.53,-9.09,-10.09,-10.66,-10.16,-8.94,-6.53,-5.47,-3.16,-1.94,-1.91,-3.03,-3.97,-4.91,-4.97,-5.31,-4.0,-3.97,-2.66,-2.34,-1.72,-1.03,-0.84,0.03,-0.69,-1.34,-1.88,-3.06,-4.81,-6.19,-8.41,-10.53,-12.59,-14.91,-16.38,-18.69,-18.53,-18.06,-17.66,-17.12,-15.59,-15.56,-13.78,-13.0,-11.28,-9.41,-7.88,-6.69,-6.28,-6.47,-5.78,-5.72,-5.78,-5.5,-6.25,-7.16,-8.88,-11.03,-13.34,-13.84,-14.06,-14.53,-13.16,-11.09,-9.31,-7.09,-5.47,-5.69,-6.28,-8.03,-10.97,-15.0,-17.72,-19.84,-21.31,-21.75,-21.22,-20.03,-18.69,-18.03,-18.03,-17.81,-16.59,-16.44,-16.06,-14.53,-12.94,-10.84,-9.34,-7.91,-7.66,-8.5,-8.28,-9.59,-9.97,-9.91,-10.56,-10.97,-11.47,-11.44,-10.44,-9.34,-7.78,-6.59,-6.28,-5.72,-5.84,-6.59,-6.84,-6.56,-6.06,-4.78,-3.81,-2.44,-2.44,-3.81,-5.78,-9.16,-12.16,-13.59,-14.75,-14.69,-13.47,-11.56,-9.31,-8.09,-6.84,-4.84,-3.84,-3.53,-2.5,-2.53,-2.31,-2.44,-2.84,-3.12,-3.97,-4.53,-4.94,-5.44,-6.06,-6.53,-7.84,-8.41,-9.94,-10.72,-10.69,-9.22,-7.19,-3.75,0.84,4.0,6.53,7.03,5.81,3.34,-0.28,-4.59,-8.41,-11.34,-14.03,-15.84,-16.19,-16.88,-17.44,-16.47,-16.34,-16.69,-15.97,-14.78,-14.19,-14.16,-13.19,-13.16,-12.59,-12.25,-11.47,-10.91,-8.97,-8.31,-7.53,-6.78,-6.28,-5.91,-5.78,-6.09,-6.59,-6.47,-6.03,-6.47,-5.78,-5.19,-5.41,-5.22,-6.19,-6.03,-6.31,-6.06,-5.91,-6.97,-7.22,-7.47,-7.28,-7.19,-6.09,-3.91,-1.47,1.19,2.56,4.72,4.81,5.66,5.28,5.12,5.88,5.38,5.41,4.34,3.53,2.66,1.53,0.62,-0.84,-1.66,-1.66,-2.09,-1.53,-0.84,-0.12,0.19,-0.19,0.03,-0.34,-1.06,-1.44,-1.72,-2.28,-2.19,-3.22,-3.91,-5.53,-6.66,-6.88,-7.22,-7.5,-7.47,-7.84,-9.5,-10.16,-11.0,-11.84,-11.84,-12.56,-13.5,-13.81,-14.28,-14.0,-12.75,-12.16,-11.12,-9.56,-8.53,-7.69,-7.88,-7.84,-8.38,-8.47,-8.41,-8.69,-8.72,-9.0,-10.69,-11.22,-11.53,-11.09,-10.53,-8.56,-7.31,-4.75,-3.41,-2.84,-3.84,-5.62,-8.38,-10.84,-13.53,-14.91,-15.97,-16.25,-16.38,-16.41,-15.59,-15.62,-15.31,-15.22,-15.38,-15.38,-14.66,-14.03,-13.25,-12.81,-13.03,-12.75,-11.91,-11.91,-11.59,-10.91,-11.34,-11.91,-14.22,-14.78,-16.56,-18.16,-18.94,-20.25,-19.81,-20.44,-20.72,-20.78,-21.09,-21.41,-21.19,-19.78,-17.84,-15.69,-13.03,-11.56,-10.69,-10.97,-11.16,-12.66,-14.91,-16.41,-17.53,-18.12,-18.84,-18.34,-18.78,-18.28,-17.59,-16.84,-15.91,-14.0,-13.69,-11.84,-11.69,-10.38,-9.09,-8.41,-6.47,-5.47,-4.84,-3.78,-3.69,-3.34,-3.66,-2.91,-3.25,-4.22,-5.38,-5.66,-6.03,-5.34,-4.53,-4.16,-3.88,-4.47,-5.47,-7.44,-8.72,-9.0,-9.5,-10.16,-10.22,-9.84,-9.03,-9.75,-9.75,-9.38,-8.72,-8.12,-7.62,-7.12,-6.88,-7.22,-6.72,-7.28,-6.47,-6.03,-6.19,-5.66,-5.81,-4.81,-3.69,-3.22,-2.97,-2.03,-2.78,-3.34,-5.03,-6.5,-8.34,-9.97,-10.78,-11.78,-11.34,-10.16,-8.44,-6.25,-3.12,-0.84,0.59,1.41,1.19,0.22,-0.72,-1.09,0.06,0.56,2.09,4.06,4.16,3.12,1.25,-1.81,-4.22,-6.28,-7.03,-7.28,-7.0,-6.44,-6.69,-7.88,-8.47,-9.97,-12.03,-13.38,-15.19,-14.88,-14.28,-11.91,-8.41,-4.84,-1.59,0.66,1.41,2.38,2.75,1.5,1.53,0.56,-0.03,0.16,1.91,4.16,6.28,9.06,10.72,10.25,9.28,7.44,5.06,2.78,0.38,-0.88,-0.81,-0.28,0.75,2.41,4.53,6.19,7.44,9.12,10.59,12.62,14.19,15.75,17.56,18.69,18.91,19.81,18.81,17.81,17.44,15.03,13.09,11.62,10.91,10.22,10.44,10.19,10.69,11.19,11.81,12.38,13.28,14.97,15.5,16.62,17.25,17.75,18.56,18.28,19.03,17.78,17.31,15.94,15.81,14.47,15.0,15.41,16.5,17.03,18.56,18.81,18.5,17.41,15.69,13.66,12.09,11.66,11.22,12.34,15.62,18.31,22.47,25.31,26.16,25.91,23.5,19.28,14.62,10.25,7.81,6.44,5.75,7.0,7.88,8.75,8.28,7.84,7.56,6.97,5.53,5.44,5.78,6.19,7.56,9.56,11.41,13.59,13.88,13.94,12.56,10.31,8.44,6.41,5.31,4.53,4.94,5.38,5.84,6.03,6.44,6.0,4.12,2.62,0.38,-1.66,-2.78,-3.72,-3.69,-2.69,-0.41,2.19,4.12,6.47,7.91,7.0,5.56,2.91,-0.28,-2.94,-5.09,-6.28,-5.94,-4.84,-3.28,-1.78,0.09,1.44,1.66,1.81,1.34,1.31,1.31,1.03,2.41,3.31,5.12,7.59,9.16,10.59,10.97,10.91,10.06,9.22,8.12,7.62,6.25,5.28,3.19,1.94,-0.03,-2.09,-3.06,-4.81,-6.09,-6.03,-6.47,-5.94,-3.66,-1.91,0.5,2.31,4.0,5.38,5.81,5.25,3.66,2.66,0.38,-1.56,-3.53,-4.03,8.0,7.28,7.44,7.16,7.25,8.09,10.22,12.44,14.12,16.19,17.47,18.12:14.66,13.69,13.31,14.72,16.97,19.47,21.38,22.97,24.44,24.19,24.5,23.66,22.56,20.91,19.31,17.91,16.5,14.25,14.19,13.03,12.16,11.44,11.31,11.38,12.44,12.22,12.56,12.19,11.94,11.34,10.56,10.84,11.0,10.44,10.53,10.31,9.38,8.47,7.91,5.44,4.16,3.41,2.31,2.0,2.72,3.25,4.44,5.81,7.81,9.06,9.81,8.31,6.66,4.19,2.22,0.69,-1.34,-2.16,-4.09,-5.34,-5.16,-5.31,-5.06,-4.75,-4.53,-3.66,-2.69,-1.0,-0.34,1.41,0.5,-0.5,-1.16,-4.38,-7.28,-8.62,-10.28,-11.53,-11.03,-10.12,-9.59,-7.62,-5.97,-3.78,-1.75,0.0,0.03,0.12,-0.44,-1.28,-1.66,-0.47,-0.28,0.16,1.62,2.19,3.41,4.81,5.44,5.44,3.69,1.47,-0.06,-2.06,-2.91,-3.28,-4.12,-4.78,-5.22,-7.75,-8.84,-11.09,-13.03,-14.69,-15.41,-14.97,-12.94,-11.59,-9.84,-7.41,-6.16,-5.66,-5.28,-5.66,-6.78,-7.44,-9.69,-11.12,-10.31,-10.84,-10.88,-10.12,-10.84,-11.22,-11.94,-11.72,-10.84,-8.72,-5.28,-1.22,1.41,5.0,6.5,6.62,5.0,2.91,1.28,-0.81,-2.34,-4.19,-4.84,-6.09,-6.66,-7.47,-6.72,-6.09,-6.53,-5.28,-7.44,-8.72,-9.53,-10.62,-10.09,-9.69,-8.03,-5.28,-4.16,-2.62,-1.66,-0.97,-2.28,-3.84,-6.47,-8.09,-9.09,-9.28,-8.56,-6.88,-5.91,-5.91,-6.69,-7.75,-8.22,-9.53,-10.28,-10.38,-11.31,-10.94,-8.09,-6.22,-1.94,1.19,4.25,5.91,6.28,5.5,3.78,2.12,-0.09,-0.97,-2.59,-2.47,-1.97,-1.78,-1.31,-0.59,-0.56,-0.66,-0.84,-1.66,-1.75,-1.28,0.06,1.62,3.12,4.81,4.31,3.44,2.72,0.34,-1.09,-2.44,-4.66,-7.09,-8.16,-9.66,-9.84,-9.78,-9.47,-8.84,-8.97,-9.47,-9.56,-10.06,-10.03,-10.0,-10.38,-8.97,-7.44,-6.62,-5.84,-5.28,-6.84,-7.53,-9.09,-10.09,-10.66,-10.16,-8.94,-6.53,-5.47,-3.16,-1.94,-1.91,-3.03,-3.97,-4.91,-4.97,-5.31,-4.0,-3.97,-2.66,-2.34,-1.72,-1.03,-0.84,0.03,-0.69,-1.34,-1.88,-3.06,-4.81,-6.19,-8.41,-10.53,-12.59,-14.91,-16.38,-18.69,-18.53,-18.06,-17.66,-17.12,-15.59,-15.56,-13.78,-13.0,-11.28,-9.41,-7.88,-6.69,-6.28,-6.47,-5.78,-5.72,-5.78,-5.5,-6.25,-7.16,-8.88,-11.03,-13.34,-13.84,-14.06,-14.53,-13.16,-11.09,-9.31,-7.09,-5.47,-5.69,-6.28,-8.03,-10.97,-15.0,-17.72,-19.84,-21.31,-21.75,-21.22,-20.03,-18.69,-18.03,-18.03,-17.81,-16.59,-16.44,-16.06,-14.53,-12.94,-10.84,-9.34,-7.91,-7.66,-8.5,-8.28,-9.59,-9.97,-9.91,-10.56,-10.97,-11.47,-11.44,-10.44,-9.34,-7.78,-6.59,-6.28,-5.72,-5.84,-6.59,-6.84,-6.56,-6.06,-4.78,-3.81,-2.44,-2.44,-3.81,-5.78,-9.16,-12.16,-13.59,-14.75,-14.69,-13.47,-11.56,-9.31,-8.09,-6.84,-4.84,-3.84,-3.53,-2.5,-2.53,-2.31,-2.44,-2.84,-3.12,-3.97,-4.53,-4.94,-5.44,-6.06,-6.53,-7.84,-8.41,-9.94,-10.72,-10.69,-9.22,-7.19,-3.75,0.84,4.0,6.53,7.03,5.81,3.34,-0.28,-4.59,-8.41,-11.34,-14.03,-15.84,-16.19,-16.88,-17.44,-16.47,-16.34,-16.69,-15.97,-14.78,-14.19,-14.16,-13.19,-13.16,-12.59,-12.25,-11.47,-10.91,-8.97,-8.31,-7.53,-6.78,-6.28,-5.91,-5.78,-6.09,-6.59,-6.47,-6.03,-6.47,-5.78,-5.19,-5.41,-5.22,-6.19,-6.03,-6.31,-6.06,-5.91,-6.97,-7.22,-7.47,-7.28,-7.19,-6.09,-3.91,-1.47,1.19,2.56,4.72,4.81,5.66,5.28,5.12,5.88,5.38,5.41,4.34,3.53,2.66,1.53,0.62,-0.84,-1.66,-1.66,-2.09,-1.53,-0.84,-0.12,0.19,-0.19,0.03,-0.34,-1.06,-1.44,-1.72,-2.28,-2.19,-3.22,-3.91,-5.53,-6.66,-6.88,-7.22,-7.5,-7.47,-7.84,-9.5,-10.16,-11.0,-11.84,-11.84,-12.56,-13.5,-13.81,-14.28,-14.0,-12.75,-12.16,-11.12,-9.56,-8.53,-7.69,-7.88,-7.84,-8.38,-8.47,-8.41,-8.69,-8.72,-9.0,-10.69,-11.22,-11.53,-11.09,-10.53,-8.56,-7.31,-4.75,-3.41,-2.84,-3.84,-5.62,-8.38,-10.84,-13.53,-14.91,-15.97,-16.25,-16.38,-16.41,-15.59,-15.62,-15.31,-15.22,-15.38,-15.38,-14.66,-14.03,-13.25,-12.81,-13.03,-12.75,-11.91,-11.91,-11.59,-10.91,-11.34,-11.91,-14.22,-14.78,-16.56,-18.16,-18.94,-20.25,-19.81,-20.44,-20.72,-20.78,-21.09,-21.41,-21.19,-19.78,-17.84,-15.69,-13.03,-11.56,-10.69,-10.97,-11.16,-12.66,-14.91,-16.41,-17.53,-18.12,-18.84,-18.34,-18.78,-18.28,-17.59,-16.84,-15.91,-14.0,-13.69,-11.84,-11.69,-10.38,-9.09,-8.41,-6.47,-5.47,-4.84,-3.78,-3.69,-3.34,-3.66,-2.91,-3.25,-4.22,-5.38,-5.66,-6.03,-5.34,-4.53,-4.16,-3.88,-4.47,-5.47,-7.44,-8.72,-9.0,-9.5,-10.16,-10.22,-9.84,-9.03,-9.75,-9.75,-9.38,-8.72,-8.12,-7.62,-7.12,-6.88,-7.22,-6.72,-7.28,-6.47,-6.03,-6.19,-5.66,-5.81,-4.81,-3.69,-3.22,-2.97,-2.03,-2.78,-3.34,-5.03,-6.5,-8.34,-9.97,-10.78,-11.78,-11.34,-10.16,-8.44,-6.25,-3.12,-0.84,0.59,1.41,1.19,0.22,-0.72,-1.09,0.06,0.56,2.09,4.06,4.16,3.12,1.25,-1.81,-4.22,-6.28,-7.03,-7.28,-7.0,-6.44,-6.69,-7.88,-8.47,-9.97,-12.03,-13.38,-15.19,-14.88,-14.28,-11.91,-8.41,-4.84,-1.59,0.66,1.41,2.38,2.75,1.5,1.53,0.56,-0.03,0.16,1.91,4.16,6.28,9.06,10.72,10.25,9.28,7.44,5.06,2.78,0.38,-0.88,-0.81,-0.28,0.75,2.41,4.53,6.19,7.44,9.12,10.59,12.62,14.19,15.75,17.56,18.69,18.91,19.81,18.81,17.81,17.44,15.03,13.09,11.62,10.91,10.22,10.44,10.19,10.69,11.19,11.81,12.38,13.28,14.97,15.5,16.62,17.25,17.75,18.56,18.28,19.03,17.78,17.31,15.94,15.81,14.47,15.0,15.41,16.5,17.03,18.56,18.81,18.5,17.41,15.69,13.66,12.09,11.66,11.22,12.34,15.62,18.31,22.47,25.31,26.16,25.91,23.5,19.28,14.62,10.25,7.81,6.44,5.75,7.0,7.88,8.75,8.28,7.84,7.56,6.97,5.53,5.44,5.78,6.19,7.56,9.56,11.41,13.59,13.88,13.94,12.56,10.31,8.44,6.41,5.31,4.53,4.94,5.38,5.84,6.03,6.44,6.0,4.12,2.62,0.38,-1.66,-2.78,-3.72,-3.69,-2.69,-0.41,2.19,4.12,6.47,7.91,7.0,5.56,2.91,-0.28,-2.94,-5.09,-6.28,-5.94,-4.84,-3.28,-1.78,0.09,1.44,1.66,1.81,1.34,1.31,1.31,1.03,2.41,3.31,5.12,7.59,9.16,10.59,10.97,10.91,10.06,9.22,8.12,7.62,6.25,5.28,3.19,1.94,-0.03,-2.09,-3.06,-4.81,-6.09,-6.03,-6.47,-5.94,-3.66,-1.91,0.5,2.31,4.0,5.38,5.81,5.25,3.66,2.66,0.38,-1.56,-3.53,-4.03,8.0,7.28,7.44,7.16,7.25,8.09,10.22,12.44,14.12,16.19,17.47,18.12,17.66,16.75,14.97,12.0,9.44,6.69:21.38,22.97,24.44,24.19,24.5,23.66,22.56,20.91,19.31,17.91,16.5,14.25,14.19,13.03,12.16,11.44,11.31,11.38,12.44,12.22,12.56,12.19,11.94,11.34,10.56,10.84,11.0,10.44,10.53,10.31,9.38,8.47,7.91,5.44,4.16,3.41,2.31,2.0,2.72,3.25,4.44,5.81,7.81,9.06,9.81,8.31,6.66,4.19,2.22,0.69,-1.34,-2.16,-4.09,-5.34,-5.16,-5.31,-5.06,-4.75,-4.53,-3.66,-2.69,-1.0,-0.34,1.41,0.5,-0.5,-1.16,-4.38,-7.28,-8.62,-10.28,-11.53,-11.03,-10.12,-9.59,-7.62,-5.97,-3.78,-1.75,0.0,0.03,0.12,-0.44,-1.28,-1.66,-0.47,-0.28,0.16,1.62,2.19,3.41,4.81,5.44,5.44,3.69,1.47,-0.06,-2.06,-2.91,-3.28,-4.12,-4.78,-5.22,-7.75,-8.84,-11.09,-13.03,-14.69,-15.41,-14.97,-12.94,-11.59,-9.84,-7.41,-6.16,-5.66,-5.28,-5.66,-6.78,-7.44,-9.69,-11.12,-10.31,-10.84,-10.88,-10.12,-10.84,-11.22,-11.94,-11.72,-10.84,-8.72,-5.28,-1.22,1.41,5.0,6.5,6.62,5.0,2.91,1.28,-0.81,-2.34,-4.19,-4.84,-6.09,-6.66,-7.47,-6.72,-6.09,-6.53,-5.28,-7.44,-8.72,-9.53,-10.62,-10.09,-9.69,-8.03,-5.28,-4.16,-2.62,-1.66,-0.97,-2.28,-3.84,-6.47,-8.09,-9.09,-9.28,-8.56,-6.88,-5.91,-5.91,-6.69,-7.75,-8.22,-9.53,-10.28,-10.38,-11.31,-10.94,-8.09,-6.22,-1.94,1.19,4.25,5.91,6.28,5.5,3.78,2.12,-0.09,-0.97,-2.59,-2.47,-1.97,-1.78,-1.31,-0.59,-0.56,-0.66,-0.84,-1.66,-1.75,-1.28,0.06,1.62,3.12,4.81,4.31,3.44,2.72,0.34,-1.09,-2.44,-4.66,-7.09,-8.16,-9.66,-9.84,-9.78,-9.47,-8.84,-8.97,-9.47,-9.56,-10.06,-10.03,-10.0,-10.38,-8.97,-7.44,-6.62,-5.84,-5.28,-6.84,-7.53,-9.09,-10.09,-10.66,-10.16,-8.94,-6.53,-5.47,-3.16,-1.94,-1.91,-3.03,-3.97,-4.91,-4.97,-5.31,-4.0,-3.97,-2.66,-2.34,-1.72,-1.03,-0.84,0.03,-0.69,-1.34,-1.88,-3.06,-4.81,-6.19,-8.41,-10.53,-12.59,-14.91,-16.38,-18.69,-18.53,-18.06,-17.66,-17.12,-15.59,-15.56,-13.78,-13.0,-11.28,-9.41,-7.88,-6.69,-6.28,-6.47,-5.78,-5.72,-5.78,-5.5,-6.25,-7.16,-8.88,-11.03,-13.34,-13.84,-14.06,-14.53,-13.16,-11.09,-9.31,-7.09,-5.47,-5.69,-6.28,-8.03,-10.97,-15.0,-17.72,-19.84,-21.31,-21.75,-21.22,-20.03,-18.69,-18.03,-18.03,-17.81,-16.59,-16.44,-16.06,-14.53,-12.94,-10.84,-9.34,-7.91,-7.66,-8.5,-8.28,-9.59,-9.97,-9.91,-10.56,-10.97,-11.47,-11.44,-10.44,-9.34,-7.78,-6.59,-6.28,-5.72,-5.84,-6.59,-6.84,-6.56,-6.06,-4.78,-3.81,-2.44,-2.44,-3.81,-5.78,-9.16,-12.16,-13.59,-14.75,-14.69,-13.47,-11.56,-9.31,-8.09,-6.84,-4.84,-3.84,-3.53,-2.5,-2.53,-2.31,-2.44,-2.84,-3.12,-3.97,-4.53,-4.94,-5.44,-6.06,-6.53,-7.84,-8.41,-9.94,-10.72,-10.69,-9.22,-7.19,-3.75,0.84,4.0,6.53,7.03,5.81,3.34,-0.28,-4.59,-8.41,-11.34,-14.03,-15.84,-16.19,-16.88,-17.44,-16.47,-16.34,-16.69,-15.97,-14.78,-14.19,-14.16,-13.19,-13.16,-12.59,-12.25,-11.47,-10.91,-8.97,-8.31,-7.53,-6.78,-6.28,-5.91,-5.78,-6.09,-6.59,-6.47,-6.03,-6.47,-5.78,-5.19,-5.41,-5.22,-6.19,-6.03,-6.31,-6.06,-5.91,-6.97,-7.22,-7.47,-7.28,-7.19,-6.09,-3.91,-1.47,1.19,2.56,4.72,4.81,5.66,5.28,5.12,5.88,5.38,5.41,4.34,3.53,2.66,1.53,0.62,-0.84,-1.66,-1.66,-2.09,-1.53,-0.84,-0.12,0.19,-0.19,0.03,-0.34,-1.06,-1.44,-1.72,-2.28,-2.19,-3.22,-3.91,-5.53,-6.66,-6.88,-7.22,-7.5,-7.47,-7.84,-9.5,-10.16,-11.0,-11.84,-11.84,-12.56,-13.5,-13.81,-14.28,-14.0,-12.75,-12.16,-11.12,-9.56,-8.53,-7.69,-7.88,-7.84,-8.38,-8.47,-8.41,-8.69,-8.72,-9.0,-10.69,-11.22,-11.53,-11.09,-10.53,-8.56,-7.31,-4.75,-3.41,-2.84,-3.84,-5.62,-8.38,-10.84,-13.53,-14.91,-15.97,-16.25,-16.38,-16.41,-15.59,-15.62,-15.31,-15.22,-15.38,-15.38,-14.66,-14.03,-13.25,-12.81,-13.03,-12.75,-11.91,-11.91,-11.59,-10.91,-11.34,-11.91,-14.22,-14.78,-16.56,-18.16,-18.94,-20.25,-19.81,-20.44,-20.72,-20.78,-21.09,-21.41,-21.19,-19.78,-17.84,-15.69,-13.03,-11.56,-10.69,-10.97,-11.16,-12.66,-14.91,-16.41,-17.53,-18.12,-18.84,-18.34,-18.78,-18.28,-17.59,-16.84,-15.91,-14.0,-13.69,-11.84,-11.69,-10.38,-9.09,-8.41,-6.47,-5.47,-4.84,-3.78,-3.69,-3.34,-3.66,-2.91,-3.25,-4.22,-5.38,-5.66,-6.03,-5.34,-4.53,-4.16,-3.88,-4.47,-5.47,-7.44,-8.72,-9.0,-9.5,-10.16,-10.22,-9.84,-9.03,-9.75,-9.75,-9.38,-8.72,-8.12,-7.62,-7.12,-6.88,-7.22,-6.72,-7.28,-6.47,-6.03,-6.19,-5.66,-5.81,-4.81,-3.69,-3.22,-2.97,-2.03,-2.78,-3.34,-5.03,-6.5,-8.34,-9.97,-10.78,-11.78,-11.34,-10.16,-8.44,-6.25,-3.12,-0.84,0.59,1.41,1.19,0.22,-0.72,-1.09,0.06,0.56,2.09,4.06,4.16,3.12,1.25,-1.81,-4.22,-6.28,-7.03,-7.28,-7.0,-6.44,-6.69,-7.88,-8.47,-9.97,-12.03,-13.38,-15.19,-14.88,-14.28,-11.91,-8.41,-4.84,-1.59,0.66,1.41,2.38,2.75,1.5,1.53,0.56,-0.03,0.16,1.91,4.16,6.28,9.06,10.72,10.25,9.28,7.44,5.06,2.78,0.38,-0.88,-0.81,-0.28,0.75,2.41,4.53,6.19,7.44,9.12,10.59,12.62,14.19,15.75,17.56,18.69,18.91,19.81,18.81,17.81,17.44,15.03,13.09,11.62,10.91,10.22,10.44,10.19,10.69,11.19,11.81,12.38,13.28,14.97,15.5,16.62,17.25,17.75,18.56,18.28,19.03,17.78,17.31,15.94,15.81,14.47,15.0,15.41,16.5,17.03,18.56,18.81,18.5,17.41,15.69,13.66,12.09,11.66,11.22,12.34,15.62,18.31,22.47,25.31,26.16,25.91,23.5,19.28,14.62,10.25,7.81,6.44,5.75,7.0,7.88,8.75,8.28,7.84,7.56,6.97,5.53,5.44,5.78,6.19,7.56,9.56,11.41,13.59,13.88,13.94,12.56,10.31,8.44,6.41,5.31,4.53,4.94,5.38,5.84,6.03,6.44,6.0,4.12,2.62,0.38,-1.66,-2.78,-3.72,-3.69,-2.69,-0.41,2.19,4.12,6.47,7.91,7.0,5.56,2.91,-0.28,-2.94,-5.09,-6.28,-5.94,-4.84,-3.28,-1.78,0.09,1.44,1.66,1.81,1.34,1.31,1.31,1.03,2.41,3.31,5.12,7.59,9.16,10.59,10.97,10.91,10.06,9.22,8.12,7.62,6.25,5.28,3.19,1.94,-0.03,-2.09,-3.06,-4.81,-6.09,-6.03,-6.47,-5.94,-3.66,-1.91,0.5,2.31,4.0,5.38,5.81,5.25,3.66,2.66,0.38,-1.56,-3.53,-4.03,8.0,7.28,7.44,7.16,7.25,8.09,10.22,12.44,14.12,16.19,17.47,18.12,17.66,16.75,14.97,12.0,9.44,6.69,4.56,3.5,3.12,5.53,7.59,11.38:22.56,20.91,19.31,17.91,16.5,14.25,14.19,13.03,12.16,11.44,11.31,11.38,12.44,12.22,12.56,12.19,11.94,11.34,10.56,10.84,11.0,10.44,10.53,10.31,9.38,8.47,7.91,5.44,4.16,3.41,2.31,2.0,2.72,3.25,4.44,5.81,7.81,9.06,9.81,8.31,6.66,4.19,2.22,0.69,-1.34,-2.16,-4.09,-5.34,-5.16,-5.31,-5.06,-4.75,-4.53,-3.66,-2.69,-1.0,-0.34,1.41,0.5,-0.5,-1.16,-4.38,-7.28,-8.62,-10.28,-11.53,-11.03,-10.12,-9.59,-7.62,-5.97,-3.78,-1.75,0.0,0.03,0.12,-0.44,-1.28,-1.66,-0.47,-0.28,0.16,1.62,2.19,3.41,4.81,5.44,5.44,3.69,1.47,-0.06,-2.06,-2.91,-3.28,-4.12,-4.78,-5.22,-7.75,-8.84,-11.09,-13.03,-14.69,-15.41,-14.97,-12.94,-11.59,-9.84,-7.41,-6.16,-5.66,-5.28,-5.66,-6.78,-7.44,-9.69,-11.12,-10.31,-10.84,-10.88,-10.12,-10.84,-11.22,-11.94,-11.72,-10.84,-8.72,-5.28,-1.22,1.41,5.0,6.5,6.62,5.0,2.91,1.28,-0.81,-2.34,-4.19,-4.84,-6.09,-6.66,-7.47,-6.72,-6.09,-6.53,-5.28,-7.44,-8.72,-9.53,-10.62,-10.09,-9.69,-8.03,-5.28,-4.16,-2.62,-1.66,-0.97,-2.28,-3.84,-6.47,-8.09,-9.09,-9.28,-8.56,-6.88,-5.91,-5.91,-6.69,-7.75,-8.22,-9.53,-10.28,-10.38,-11.31,-10.94,-8.09,-6.22,-1.94,1.19,4.25,5.91,6.28,5.5,3.78,2.12,-0.09,-0.97,-2.59,-2.47,-1.97,-1.78,-1.31,-0.59,-0.56,-0.66,-0.84,-1.66,-1.75,-1.28,0.06,1.62,3.12,4.81,4.31,3.44,2.72,0.34,-1.09,-2.44,-4.66,-7.09,-8.16,-9.66,-9.84,-9.78,-9.47,-8.84,-8.97,-9.47,-9.56,-10.06,-10.03,-10.0,-10.38,-8.97,-7.44,-6.62,-5.84,-5.28,-6.84,-7.53,-9.09,-10.09,-10.66,-10.16,-8.94,-6.53,-5.47,-3.16,-1.94,-1.91,-3.03,-3.97,-4.91,-4.97,-5.31,-4.0,-3.97,-2.66,-2.34,-1.72,-1.03,-0.84,0.03,-0.69,-1.34,-1.88,-3.06,-4.81,-6.19,-8.41,-10.53,-12.59,-14.91,-16.38,-18.69,-18.53,-18.06,-17.66,-17.12,-15.59,-15.56,-13.78,-13.0,-11.28,-9.41,-7.88,-6.69,-6.28,-6.47,-5.78,-5.72,-5.78,-5.5,-6.25,-7.16,-8.88,-11.03,-13.34,-13.84,-14.06,-14.53,-13.16,-11.09,-9.31,-7.09,-5.47,-5.69,-6.28,-8.03,-10.97,-15.0,-17.72,-19.84,-21.31,-21.75,-21.22,-20.03,-18.69,-18.03,-18.03,-17.81,-16.59,-16.44,-16.06,-14.53,-12.94,-10.84,-9.34,-7.91,-7.66,-8.5,-8.28,-9.59,-9.97,-9.91,-10.56,-10.97,-11.47,-11.44,-10.44,-9.34,-7.78,-6.59,-6.28,-5.72,-5.84,-6.59,-6.84,-6.56,-6.06,-4.78,-3.81,-2.44,-2.44,-3.81,-5.78,-9.16,-12.16,-13.59,-14.75,-14.69,-13.47,-11.56,-9.31,-8.09,-6.84,-4.84,-3.84,-3.53,-2.5,-2.53,-2.31,-2.44,-2.84,-3.12,-3.97,-4.53,-4.94,-5.44,-6.06,-6.53,-7.84,-8.41,-9.94,-10.72,-10.69,-9.22,-7.19,-3.75,0.84,4.0,6.53,7.03,5.81,3.34,-0.28,-4.59,-8.41,-11.34,-14.03,-15.84,-16.19,-16.88,-17.44,-16.47,-16.34,-16.69,-15.97,-14.78,-14.19,-14.16,-13.19,-13.16,-12.59,-12.25,-11.47,-10.91,-8.97,-8.31,-7.53,-6.78,-6.28,-5.91,-5.78,-6.09,-6.59,-6.47,-6.03,-6.47,-5.78,-5.19,-5.41,-5.22,-6.19,-6.03,-6.31,-6.06,-5.91,-6.97,-7.22,-7.47,-7.28,-7.19,-6.09,-3.91,-1.47,1.19,2.56,4.72,4.81,5.66,5.28,5.12,5.88,5.38,5.41,4.34,3.53,2.66,1.53,0.62,-0.84,-1.66,-1.66,-2.09,-1.53,-0.84,-0.12,0.19,-0.19,0.03,-0.34,-1.06,-1.44,-1.72,-2.28,-2.19,-3.22,-3.91,-5.53,-6.66,-6.88,-7.22,-7.5,-7.47,-7.84,-9.5,-10.16,-11.0,-11.84,-11.84,-12.56,-13.5,-13.81,-14.28,-14.0,-12.75,-12.16,-11.12,-9.56,-8.53,-7.69,-7.88,-7.84,-8.38,-8.47,-8.41,-8.69,-8.72,-9.0,-10.69,-11.22,-11.53,-11.09,-10.53,-8.56,-7.31,-4.75,-3.41,-2.84,-3.84,-5.62,-8.38,-10.84,-13.53,-14.91,-15.97,-16.25,-16.38,-16.41,-15.59,-15.62,-15.31,-15.22,-15.38,-15.38,-14.66,-14.03,-13.25,-12.81,-13.03,-12.75,-11.91,-11.91,-11.59,-10.91,-11.34,-11.91,-14.22,-14.78,-16.56,-18.16,-18.94,-20.25,-19.81,-20.44,-20.72,-20.78,-21.09,-21.41,-21.19,-19.78,-17.84,-15.69,-13.03,-11.56,-10.69,-10.97,-11.16,-12.66,-14.91,-16.41,-17.53,-18.12,-18.84,-18.34,-18.78,-18.28,-17.59,-16.84,-15.91,-14.0,-13.69,-11.84,-11.69,-10.38,-9.09,-8.41,-6.47,-5.47,-4.84,-3.78,-3.69,-3.34,-3.66,-2.91,-3.25,-4.22,-5.38,-5.66,-6.03,-5.34,-4.53,-4.16,-3.88,-4.47,-5.47,-7.44,-8.72,-9.0,-9.5,-10.16,-10.22,-9.84,-9.03,-9.75,-9.75,-9.38,-8.72,-8.12,-7.62,-7.12,-6.88,-7.22,-6.72,-7.28,-6.47,-6.03,-6.19,-5.66,-5.81,-4.81,-3.69,-3.22,-2.97,-2.03,-2.78,-3.34,-5.03,-6.5,-8.34,-9.97,-10.78,-11.78,-11.34,-10.16,-8.44,-6.25,-3.12,-0.84,0.59,1.41,1.19,0.22,-0.72,-1.09,0.06,0.56,2.09,4.06,4.16,3.12,1.25,-1.81,-4.22,-6.28,-7.03,-7.28,-7.0,-6.44,-6.69,-7.88,-8.47,-9.97,-12.03,-13.38,-15.19,-14.88,-14.28,-11.91,-8.41,-4.84,-1.59,0.66,1.41,2.38,2.75,1.5,1.53,0.56,-0.03,0.16,1.91,4.16,6.28,9.06,10.72,10.25,9.28,7.44,5.06,2.78,0.38,-0.88,-0.81,-0.28,0.75,2.41,4.53,6.19,7.44,9.12,10.59,12.62,14.19,15.75,17.56,18.69,18.91,19.81,18.81,17.81,17.44,15.03,13.09,11.62,10.91,10.22,10.44,10.19,10.69,11.19,11.81,12.38,13.28,14.97,15.5,16.62,17.25,17.75,18.56,18.28,19.03,17.78,17.31,15.94,15.81,14.47,15.0,15.41,16.5,17.03,18.56,18.81,18.5,17.41,15.69,13.66,12.09,11.66,11.22,12.34,15.62,18.31,22.47,25.31,26.16,25.91,23.5,19.28,14.62,10.25,7.81,6.44,5.75,7.0,7.88,8.75,8.28,7.84,7.56,6.97,5.53,5.44,5.78,6.19,7.56,9.56,11.41,13.59,13.88,13.94,12.56,10.31,8.44,6.41,5.31,4.53,4.94,5.38,5.84,6.03,6.44,6.0,4.12,2.62,0.38,-1.66,-2.78,-3.72,-3.69,-2.69,-0.41,2.19,4.12,6.47,7.91,7.0,5.56,2.91,-0.28,-2.94,-5.09,-6.28,-5.94,-4.84,-3.28,-1.78,0.09,1.44,1.66,1.81,1.34,1.31,1.31,1.03,2.41,3.31,5.12,7.59,9.16,10.59,10.97,10.91,10.06,9.22,8.12,7.62,6.25,5.28,3.19,1.94,-0.03,-2.09,-3.06,-4.81,-6.09,-6.03,-6.47,-5.94,-3.66,-1.91,0.5,2.31,4.0,5.38,5.81,5.25,3.66,2.66,0.38,-1.56,-3.53,-4.03,8.0,7.28,7.44,7.16,7.25,8.09,10.22,12.44,14.12,16.19,17.47,18.12,17.66,16.75,14.97,12.0,9.44,6.69,4.56,3.5,3.12,5.53,7.59,11.38,13.91,16.56,17.75,16.56,15.06,12.5:positivity
20.16,16.88,15.41,14.31,14.5,14.09,15.12,15.69,16.22,15.19,15.94,14.75,13.53,13.69,13.03,13.19,14.41,16.09,18.69,20.34,23.81,25.81,26.66,27.34,29.25,29.06,30.16,31.25,32.91,33.78,35.03,34.16,35.06,34.72,33.91,35.22,33.81,34.44,33.81,32.72,31.75,31.66,30.91,30.22,30.31,29.72,29.66,29.62,31.19,32.09,33.16,36.66,36.53,36.12,36.19,34.56,32.12,29.75,28.34,24.16,22.81,21.0,18.19,18.59,18.25,17.47,18.38,17.97,16.16,15.16,13.34,13.16,11.53,10.5,8.78,7.12,6.0,4.12,4.66,4.41,5.84,7.5,8.81,10.47,14.06,16.16,17.5,20.19,20.72,20.31,19.66,18.44,16.06,14.09,12.84,11.59,11.62,12.72,12.44,13.16,11.94,11.28,11.16,9.88,10.59,11.16,12.19,12.72,12.91,11.03,10.06,7.44,6.19,3.78,2.38,0.97,-1.06,-2.66,-2.28,-2.34,-1.09,-0.94,-0.25,-0.09,0.06,2.09,3.44,5.53,5.5,8.22,9.41,10.59,12.06,13.81,13.16,12.62,13.03,12.09,12.88,13.38,12.47,11.0,9.47,7.88,6.53,5.25,4.31,2.69,-0.22,-1.31,-1.72,-2.31,-0.69,0.47,1.66,2.84,1.69,2.53,0.16,-0.84,-2.69,-4.47,-5.34,-5.72,-6.97,-6.84,-7.12,-7.66,-8.5,-9.31,-8.88,-9.59,-9.06,-8.72,-8.09,-6.59,-7.0,-4.81,-3.34,-2.16,-0.56,0.81,0.56,1.5,1.5,1.69,2.31,1.53,0.25,0.41,-0.94,-1.34,0.0,0.72,2.62,3.5,6.41,7.94,10.19,13.56,15.31,15.91,13.88,11.06,5.62,1.66,-1.09,-1.62,-0.31,1.88,3.84,4.38,6.44,5.97,7.69,8.03,8.75,8.09,5.69,4.28,1.03,-0.72,-0.81,-1.59,0.31,2.12,4.66,6.44,7.44,6.78,6.19,3.94,1.78,0.34,-3.72,-3.5,-6.44,-7.59,-8.03,-8.16,-8.94,-10.22,-11.44,-12.03,-13.53,-13.19,-12.28,-10.78,-10.19,-8.03,-6.59,-5.78,-5.75,-6.84,-6.81,-9.97,-11.06,-13.34,-15.06,-15.81,-16.5,-17.53,-16.75,-17.66,-16.34,-15.81,-13.72,-11.91,-10.44,-8.94,-6.81,-4.84,-4.59,-4.34,-3.34,-4.75,-5.47,-6.38,-7.97,-10.0,-11.53,-14.03,-13.88,-13.16,-12.34,-10.28,-7.22,-5.66,-3.09,-0.53,0.5,0.56,0.81,1.12,0.75,0.06,0.69,-0.94,-2.84,-3.97,-7.09,-5.47,-6.16,-5.28,-2.22,-1.59,-0.16,-0.22,0.12,-1.31,-2.38,-1.81,-2.22,-3.31,-2.09,-2.56,-4.16,-4.06,-3.34,-2.75,-1.97,0.16,1.72,2.94,3.34,3.72,2.91,3.19,2.72,2.31,1.12,1.44,-0.06,0.41,-0.16,2.25,3.91,5.94,6.81,6.06,4.47,-1.47,-3.03,-5.84,-5.91,-5.75,-4.06,-1.75,-2.59,-2.19,-1.66,-1.25,-1.22,0.97,1.06,3.09,3.81,3.88,4.41,3.62,3.31,1.75,1.41,0.19,-0.94,-1.78,-0.44,-0.53,2.06,2.53,4.06,3.31,3.81,2.91,4.59,3.0,3.31,4.38,3.09,3.62,4.0,5.19,5.44,6.62,6.44,6.06,6.78,6.66,6.5,7.12,8.28,9.16,10.06,11.53,12.19,12.41,12.62,15.41,14.69,17.97,18.34,17.91,17.69,16.06,14.78,12.38,10.62,9.41,7.25,7.16,7.28,5.91,6.56,5.88,5.91,6.0,6.69,6.53,6.62,5.09,4.16,3.75,3.91,4.44,4.97,8.53,9.28,10.88,12.56,14.16,14.5,14.44,16.28,16.31,17.62,21.62,24.72,27.22,29.41,29.16,27.41,23.06,19.28,15.56,12.94,9.62,7.25,7.09,5.56,4.53,5.56,4.28,3.78,1.69,2.0,1.44,1.09,1.19,1.12,-0.72,-1.91,-3.09,-3.38,-4.56,-5.28,-4.94,-5.59,-4.84,-3.34,-2.22,-1.03,-0.41,-0.69,0.69,0.56,0.62,0.44,-0.84,-2.72,-4.06,-5.38,-5.66,-5.0,-3.66,-1.94,-0.34,2.38,3.41,5.62,7.78,8.53,9.0,10.72,10.16,11.03,9.06,9.41,7.88,6.78,5.56,4.94,5.19,2.06,4.31,2.97,3.72,5.31,5.56,6.09,4.66,4.06,2.28,0.81,-1.84,-2.53,-4.31,-5.28,-4.66,-5.09,-4.59,-3.91,-3.84,-4.75,-5.47,-6.41,-8.03,-7.94,-9.03,-8.53,-7.66,-7.22,-6.06,-6.19,-5.69,-5.34,-7.34,-6.34,-6.97,-7.84,-7.66,-5.66,-3.72,-1.47,1.25,2.78,3.56,2.53,1.66,0.44,-0.78,-1.72,-1.94,-2.44,-1.22,0.0,2.81,4.25,5.84,5.66,5.09,2.81,2.69,1.69,1.56,1.28,1.25,-0.09,-1.59,-2.66,-3.59,-4.09,-3.56,-3.84,-3.84,-3.09,-3.44,-3.22,-2.16,-0.94,-1.16,-0.66,-0.59,-2.22,-1.81,-3.53,-4.84,-5.62,-6.09,-7.81,-7.59,-9.59,-8.28,-7.72,-6.53,-4.06,-2.34,-0.22,-1.19,-1.06,-2.22,-4.19,-5.91,-6.81,-8.19,-8.84,-9.47,-8.38,-8.31,-5.97,-5.97,-4.47,-4.66,-5.38,-6.47,-8.09,-9.84,-11.44,-11.72,-12.94,-12.41,-12.34,-10.66,-10.06,-8.53,-6.47,-5.78,-5.66,-6.94,-7.38,-8.44,-9.91,-11.22,-11.62,-12.69,-11.97,-12.34,-11.22,-11.28,-10.34,-9.47,-9.34,-6.53,-5.97,-6.09,-4.16,-4.53,-3.41,-3.56,-2.16,-3.75,-4.41,-6.19,-8.22,-9.56,-11.09,-11.25,-12.22,-11.47,-11.66,-11.69,-12.16,-12.09,-13.09,-13.12,-12.31,-10.91,-11.12,-10.28,-10.84,-9.78,-11.44,-9.72,-8.03,-3.97,-2.91,1.38,2.31,1.72,-0.25,-3.81,-8.53,-11.19,-13.91,-14.31,-12.84,-11.19,-8.34,-7.47,-7.47,-8.72,-10.66,-12.81,-15.19,-16.31,-18.47,-18.28,-18.66,-17.22,-16.06,-14.5,-12.72,-11.78,-11.53,-10.72,-10.56,-10.44,-10.06,-11.16,-10.53,-10.59,-9.88,-8.03,-6.12,-3.78,-1.84,-0.47,-0.22,-0.66,-2.0,-3.34,-5.69,-5.97,-7.34,-7.69,-5.34,-4.72,-4.41,-2.22,-2.62,-2.84,-3.66,-3.03,-1.66,-1.47,-1.53,-0.16,0.16,-1.09,-0.72,-1.69,-2.59,-3.28,-3.91,-3.66,-2.59,-2.66,-2.34,-2.72,-3.25,-2.94,-3.72,-3.34,-3.34,-4.16,-5.38,-6.34,-6.91,-6.75,-6.31,-7.03,-6.94,-7.41,-8.09,-9.69,-9.59,-10.66,-12.09,-12.84,-14.47,-14.09,-14.41,-14.28,-12.19,-10.72,-8.16,-6.31,-6.09,-4.69,-4.72,-5.5,-5.94,-6.28,-6.53,-6.41,-6.97,-6.72,-6.56,-6.59,-5.56,-6.31,-4.19,-4.09,-4.31,-1.97,-1.97,-0.59,0.38,1.44,2.78,3.0,4.91,6.06,6.28,8.16,7.31,6.31,5.09,2.19,-0.56,-3.34,-5.09,-6.81,-6.47,-6.16,-5.47,-2.41,-1.31,2.12,4.09,7.16,9.0,9.84,11.5,11.03,11.09,10.09,8.25,6.84,4.56,2.75,0.94,0.97,0.41,0.56,2.75,3.81,5.81,7.28,8.69,9.47,10.5,9.72,10.41,9.31,8.69,9.25,8.56,10.75,11.78,13.44,13.59,13.66,13.19,12.22,11.66,12.22,10.38,9.94,9.59,10.16,9.69,10.88,10.84,10.56,9.16,7.97,7.16,5.78,5.31,5.81,6.69,8.66,12.12,13.81,16.09,18.41,19.0,19.97,20.31,20.41,18.53,16.34,13.69,12.09,9.0,8.12,7.5,6.25,7.66,7.78,9.0,7.66,6.72,4.25,0.19,-4.72:15.12,15.69,16.22,15.19,15.94,14.75,13.53,13.69,13.03,13.19,14.41,16.09,18.69,20.34,23.81,25.81,26.66,27.34,29.25,29.06,30.16,31.25,32.91,33.78,35.03,34.16,35.06,34.72,33.91,35.22,33.81,34.44,33.81,32.72,31.75,31.66,30.91,30.22,30.31,29.72,29.66,29.62,31.19,32.09,33.16,36.66,36.53,36.12,36.19,34.56,32.12,29.75,28.34,24.16,22.81,21.0,18.19,18.59,18.25,17.47,18.38,17.97,16.16,15.16,13.34,13.16,11.53,10.5,8.78,7.12,6.0,4.12,4.66,4.41,5.84,7.5,8.81,10.47,14.06,16.16,17.5,20.19,20.72,20.31,19.66,18.44,16.06,14.09,12.84,11.59,11.62,12.72,12.44,13.16,11.94,11.28,11.16,9.88,10.59,11.16,12.19,12.72,12.91,11.03,10.06,7.44,6.19,3.78,2.38,0.97,-1.06,-2.66,-2.28,-2.34,-1.09,-0.94,-0.25,-0.09,0.06,2.09,3.44,5.53,5.5,8.22,9.41,10.59,12.06,13.81,13.16,12.62,13.03,12.09,12.88,13.38,12.47,11.0,9.47,7.88,6.53,5.25,4.31,2.69,-0.22,-1.31,-1.72,-2.31,-0.69,0.47,1.66,2.84,1.69,2.53,0.16,-0.84,-2.69,-4.47,-5.34,-5.72,-6.97,-6.84,-7.12,-7.66,-8.5,-9.31,-8.88,-9.59,-9.06,-8.72,-8.09,-6.59,-7.0,-4.81,-3.34,-2.16,-0.56,0.81,0.56,1.5,1.5,1.69,2.31,1.53,0.25,0.41,-0.94,-1.34,0.0,0.72,2.62,3.5,6.41,7.94,10.19,13.56,15.31,15.91,13.88,11.06,5.62,1.66,-1.09,-1.62,-0.31,1.88,3.84,4.38,6.44,5.97,7.69,8.03,8.75,8.09,5.69,4.28,1.03,-0.72,-0.81,-1.59,0.31,2.12,4.66,6.44,7.44,6.78,6.19,3.94,1.78,0.34,-3.72,-3.5,-6.44,-7.59,-8.03,-8.16,-8.94,-10.22,-11.44,-12.03,-13.53,-13.19,-12.28,-10.78,-10.19,-8.03,-6.59,-5.78,-5.75,-6.84,-6.81,-9.97,-11.06,-13.34,-15.06,-15.81,-16.5,-17.53,-16.75,-17.66,-16.34,-15.81,-13.72,-11.91,-10.44,-8.94,-6.81,-4.84,-4.59,-4.34,-3.34,-4.75,-5.47,-6.38,-7.97,-10.0,-11.53,-14.03,-13.88,-13.16,-12.34,-10.28,-7.22,-5.66,-3.09,-0.53,0.5,0.56,0.81,1.12,0.75,0.06,0.69,-0.94,-2.84,-3.97,-7.09,-5.47,-6.16,-5.28,-2.22,-1.59,-0.16,-0.22,0.12,-1.31,-2.38,-1.81,-2.22,-3.31,-2.09,-2.56,-4.16,-4.06,-3.34,-2.75,-1.97,0.16,1.72,2.94,3.34,3.72,2.91,3.19,2.72,2.31,1.12,1.44,-0.06,0.41,-0.16,2.25,3.91,5.94,6.81,6.06,4.47,-1.47,-3.03,-5.84,-5.91,-5.75,-4.06,-1.75,-2.59,-2.19,-1.66,-1.25,-1.22,0.97,1.06,3.09,3.81,3.88,4.41,3.62,3.31,1.75,1.41,0.19,-0.94,-1.78,-0.44,-0.53,2.06,2.53,4.06,3.31,3.81,2.91,4.59,3.0,3.31,4.38,3.09,3.62,4.0,5.19,5.44,6.62,6.44,6.06,6.78,6.66,6.5,7.12,8.28,9.16,10.06,11.53,12.19,12.41,12.62,15.41,14.69,17.97,18.34,17.91,17.69,16.06,14.78,12.38,10.62,9.41,7.25,7.16,7.28,5.91,6.56,5.88,5.91,6.0,6.69,6.53,6.62,5.09,4.16,3.75,3.91,4.44,4.97,8.53,9.28,10.88,12.56,14.16,14.5,14.44,16.28,16.31,17.62,21.62,24.72,27.22,29.41,29.16,27.41,23.06,19.28,15.56,12.94,9.62,7.25,7.09,5.56,4.53,5.56,4.28,3.78,1.69,2.0,1.44,1.09,1.19,1.12,-0.72,-1.91,-3.09,-3.38,-4.56,-5.28,-4.94,-5.59,-4.84,-3.34,-2.22,-1.03,-0.41,-0.69,0.69,0.56,0.62,0.44,-0.84,-2.72,-4.06,-5.38,-5.66,-5.0,-3.66,-1.94,-0.34,2.38,3.41,5.62,7.78,8.53,9.0,10.72,10.16,11.03,9.06,9.41,7.88,6.78,5.56,4.94,5.19,2.06,4.31,2.97,3.72,5.31,5.56,6.09,4.66,4.06,2.28,0.81,-1.84,-2.53,-4.31,-5.28,-4.66,-5.09,-4.59,-3.91,-3.84,-4.75,-5.47,-6.41,-8.03,-7.94,-9.03,-8.53,-7.66,-7.22,-6.06,-6.19,-5.69,-5.34,-7.34,-6.34,-6.97,-7.84,-7.66,-5.66,-3.72,-1.47,1.25,2.78,3.56,2.53,1.66,0.44,-0.78,-1.72,-1.94,-2.44,-1.22,0.0,2.81,4.25,5.84,5.66,5.09,2.81,2.69,1.69,1.56,1.28,1.25,-0.09,-1.59,-2.66,-3.59,-4.09,-3.56,-3.84,-3.84,-3.09,-3.44,-3.22,-2.16,-0.94,-1.16,-0.66,-0.59,-2.22,-1.81,-3.53,-4.84,-5.62,-6.09,-7.81,-7.59,-9.59,-8.28,-7.72,-6.53,-4.06,-2.34,-0.22,-1.19,-1.06,-2.22,-4.19,-5.91,-6.81,-8.19,-8.84,-9.47,-8.38,-8.31,-5.97,-5.97,-4.47,-4.66,-5.38,-6.47,-8.09,-9.84,-11.44,-11.72,-12.94,-12.41,-12.34,-10.66,-10.06,-8.53,-6.47,-5.78,-5.66,-6.94,-7.38,-8.44,-9.91,-11.22,-11.62,-12.69,-11.97,-12.34,-11.22,-11.28,-10.34,-9.47,-9.34,-6.53,-5.97,-6.09,-4.16,-4.53,-3.41,-3.56,-2.16,-3.75,-4.41,-6.19,-8.22,-9.56,-11.09,-11.25,-12.22,-11.47,-11.66,-11.69,-12.16,-12.09,-13.09,-13.12,-12.31,-10.91,-11.12,-10.28,-10.84,-9.78,-11.44,-9.72,-8.03,-3.97,-2.91,1.38,2.31,1.72,-0.25,-3.81,-8.53,-11.19,-13.91,-14.31,-12.84,-11.19,-8.34,-7.47,-7.47,-8.72,-10.66,-12.81,-15.19,-16.31,-18.47,-18.28,-18.66,-17.22,-16.06,-14.5,-12.72,-11.78,-11.53,-10.72,-10.56,-10.44,-10.06,-11.16,-10.53,-10.59,-9.88,-8.03,-6.12,-3.78,-1.84,-0.47,-0.22,-0.66,-2.0,-3.34,-5.69,-5.97,-7.34,-7.69,-5.34,-4.72,-4.41,-2.22,-2.62,-2.84,-3.66,-3.03,-1.66,-1.47,-1.53,-0.16,0.16,-1.09,-0.72,-1.69,-2.59,-3.28,-3.91,-3.66,-2.59,-2.66,-2.34,-2.72,-3.25,-2.94,-3.72,-3.34,-3.34,-4.16,-5.38,-6.34,-6.91,-6.75,-6.31,-7.03,-6.94,-7.41,-8.09,-9.69,-9.59,-10.66,-12.09,-12.84,-14.47,-14.09,-14.41,-14.28,-12.19,-10.72,-8.16,-6.31,-6.09,-4.69,-4.72,-5.5,-5.94,-6.28,-6.53,-6.41,-6.97,-6.72,-6.56,-6.59,-5.56,-6.31,-4.19,-4.09,-4.31,-1.97,-1.97,-0.59,0.38,1.44,2.78,3.0,4.91,6.06,6.28,8.16,7.31,6.31,5.09,2.19,-0.56,-3.34,-5.09,-6.81,-6.47,-6.16,-5.47,-2.41,-1.31,2.12,4.09,7.16,9.0,9.84,11.5,11.03,11.09,10.09,8.25,6.84,4.56,2.75,0.94,0.97,0.41,0.56,2.75,3.81,5.81,7.28,8.69,9.47,10.5,9.72,10.41,9.31,8.69,9.25,8.56,10.75,11.78,13.44,13.59,13.66,13.19,12.22,11.66,12.22,10.38,9.94,9.59,10.16,9.69,10.88,10.84,10.56,9.16,7.97,7.16,5.78,5.31,5.81,6.69,8.66,12.12,13.81,16.09,18.41,19.0,19.97,20.31,20.41,18.53,16.34,13.69,12.09,9.0,8.12,7.5,6.25,7.66,7.78,9.0,7.66,6.72,4.25,0.19,-4.72,2.84,2.22,0.44,-1.09,-1.88,-1.97:13.53,13.69,13.03,13.19,14.41,16.09,18.69,20.34,23.81,25.81,26.66,27.34,29.25,29.06,30.16,31.25,32.91,33.78,35.03,34.16,35.06,34.72,33.91,35.22,33.81,34.44,33.81,32.72,31.75,31.66,30.91,30.22,30.31,29.72,29.66,29.62,31.19,32.09,33.16,36.66,36.53,36.12,36.19,34.56,32.12,29.75,28.34,24.16,22.81,21.0,18.19,18.59,18.25,17.47,18.38,17.97,16.16,15.16,13.34,13.16,11.53,10.5,8.78,7.12,6.0,4.12,4.66,4.41,5.84,7.5,8.81,10.47,14.06,16.16,17.5,20.19,20.72,20.31,19.66,18.44,16.06,14.09,12.84,11.59,11.62,12.72,12.44,13.16,11.94,11.28,11.16,9.88,10.59,11.16,12.19,12.72,12.91,11.03,10.06,7.44,6.19,3.78,2.38,0.97,-1.06,-2.66,-2.28,-2.34,-1.09,-0.94,-0.25,-0.09,0.06,2.09,3.44,5.53,5.5,8.22,9.41,10.59,12.06,13.81,13.16,12.62,13.03,12.09,12.88,13.38,12.47,11.0,9.47,7.88,6.53,5.25,4.31,2.69,-0.22,-1.31,-1.72,-2.31,-0.69,0.47,1.66,2.84,1.69,2.53,0.16,-0.84,-2.69,-4.47,-5.34,-5.72,-6.97,-6.84,-7.12,-7.66,-8.5,-9.31,-8.88,-9.59,-9.06,-8.72,-8.09,-6.59,-7.0,-4.81,-3.34,-2.16,-0.56,0.81,0.56,1.5,1.5,1.69,2.31,1.53,0.25,0.41,-0.94,-1.34,0.0,0.72,2.62,3.5,6.41,7.94,10.19,13.56,15.31,15.91,13.88,11.06,5.62,1.66,-1.09,-1.62,-0.31,1.88,3.84,4.38,6.44,5.97,7.69,8.03,8.75,8.09,5.69,4.28,1.03,-0.72,-0.81,-1.59,0.31,2.12,4.66,6.44,7.44,6.78,6.19,3.94,1.78,0.34,-3.72,-3.5,-6.44,-7.59,-8.03,-8.16,-8.94,-10.22,-11.44,-12.03,-13.53,-13.19,-12.28,-10.78,-10.19,-8.03,-6.59,-5.78,-5.75,-6.84,-6.81,-9.97,-11.06,-13.34,-15.06,-15.81,-16.5,-17.53,-16.75,-17.66,-16.34,-15.81,-13.72,-11.91,-10.44,-8.94,-6.81,-4.84,-4.59,-4.34,-3.34,-4.75,-5.47,-6.38,-7.97,-10.0,-11.53,-14.03,-13.88,-13.16,-12.34,-10.28,-7.22,-5.66,-3.09,-0.53,0.5,0.56,0.81,1.12,0.75,0.06,0.69,-0.94,-2.84,-3.97,-7.09,-5.47,-6.16,-5.28,-2.22,-1.59,-0.16,-0.22,0.12,-1.31,-2.38,-1.81,-2.22,-3.31,-2.09,-2.56,-4.16,-4.06,-3.34,-2.75,-1.97,0.16,1.72,2.94,3.34,3.72,2.91,3.19,2.72,2.31,1.12,1.44,-0.06,0.41,-0.16,2.25,3.91,5.94,6.81,6.06,4.47,-1.47,-3.03,-5.84,-5.91,-5.75,-4.06,-1.75,-2.59,-2.19,-1.66,-1.25,-1.22,0.97,1.06,3.09,3.81,3.88,4.41,3.62,3.31,1.75,1.41,0.19,-0.94,-1.78,-0.44,-0.53,2.06,2.53,4.06,3.31,3.81,2.91,4.59,3.0,3.31,4.38,3.09,3.62,4.0,5.19,5.44,6.62,6.44,6.06,6.78,6.66,6.5,7.12,8.28,9.16,10.06,11.53,12.19,12.41,12.62,15.41,14.69,17.97,18.34,17.91,17.69,16.06,14.78,12.38,10.62,9.41,7.25,7.16,7.28,5.91,6.56,5.88,5.91,6.0,6.69,6.53,6.62,5.09,4.16,3.75,3.91,4.44,4.97,8.53,9.28,10.88,12.56,14.16,14.5,14.44,16.28,16.31,17.62,21.62,24.72,27.22,29.41,29.16,27.41,23.06,19.28,15.56,12.94,9.62,7.25,7.09,5.56,4.53,5.56,4.28,3.78,1.69,2.0,1.44,1.09,1.19,1.12,-0.72,-1.91,-3.09,-3.38,-4.56,-5.28,-4.94,-5.59,-4.84,-3.34,-2.22,-1.03,-0.41,-0.69,0.69,0.56,0.62,0.44,-0.84,-2.72,-4.06,-5.38,-5.66,-5.0,-3.66,-1.94,-0.34,2.38,3.41,5.62,7.78,8.53,9.0,10.72,10.16,11.03,9.06,9.41,7.88,6.78,5.56,4.94,5.19,2.06,4.31,2.97,3.72,5.31,5.56,6.09,4.66,4.06,2.28,0.81,-1.84,-2.53,-4.31,-5.28,-4.66,-5.09,-4.59,-3.91,-3.84,-4.75,-5.47,-6.41,-8.03,-7.94,-9.03,-8.53,-7.66,-7.22,-6.06,-6.19,-5.69,-5.34,-7.34,-6.34,-6.97,-7.84,-7.66,-5.66,-3.72,-1.47,1.25,2.78,3.56,2.53,1.66,0.44,-0.78,-1.72,-1.94,-2.44,-1.22,0.0,2.81,4.25,5.84,5.66,5.09,2.81,2.69,1.69,1.56,1.28,1.25,-0.09,-1.59,-2.66,-3.59,-4.09,-3.56,-3.84,-3.84,-3.09,-3.44,-3.22,-2.16,-0.94,-1.16,-0.66,-0.59,-2.22,-1.81,-3.53,-4.84,-5.62,-6.09,-7.81,-7.59,-9.59,-8.28,-7.72,-6.53,-4.06,-2.34,-0.22,-1.19,-1.06,-2.22,-4.19,-5.91,-6.81,-8.19,-8.84,-9.47,-8.38,-8.31,-5.97,-5.97,-4.47,-4.66,-5.38,-6.47,-8.09,-9.84,-11.44,-11.72,-12.94,-12.41,-12.34,-10.66,-10.06,-8.53,-6.47,-5.78,-5.66,-6.94,-7.38,-8.44,-9.91,-11.22,-11.62,-12.69,-11.97,-12.34,-11.22,-11.28,-10.34,-9.47,-9.34,-6.53,-5.97,-6.09,-4.16,-4.53,-3.41,-3.56,-2.16,-3.75,-4.41,-6.19,-8.22,-9.56,-11.09,-11.25,-12.22,-11.47,-11.66,-11.69,-12.16,-12.09,-13.09,-13.12,-12.31,-10.91,-11.12,-10.28,-10.84,-9.78,-11.44,-9.72,-8.03,-3.97,-2.91,1.38,2.31,1.72,-0.25,-3.81,-8.53,-11.19,-13.91,-14.31,-12.84,-11.19,-8.34,-7.47,-7.47,-8.72,-10.66,-12.81,-15.19,-16.31,-18.47,-18.28,-18.66,-17.22,-16.06,-14.5,-12.72,-11.78,-11.53,-10.72,-10.56,-10.44,-10.06,-11.16,-10.53,-10.59,-9.88,-8.03,-6.12,-3.78,-1.84,-0.47,-0.22,-0.66,-2.0,-3.34,-5.69,-5.97,-7.34,-7.69,-5.34,-4.72,-4.41,-2.22,-2.62,-2.84,-3.66,-3.03,-1.66,-1.47,-1.53,-0.16,0.16,-1.09,-0.72,-1.69,-2.59,-3.28,-3.91,-3.66,-2.59,-2.66,-2.34,-2.72,-3.25,-2.94,-3.72,-3.34,-3.34,-4.16,-5.38,-6.34,-6.91,-6.75,-6.31,-7.03,-6.94,-7.41,-8.09,-9.69,-9.59,-10.66,-12.09,-12.84,-14.47,-14.09,-14.41,-14.28,-12.19,-10.72,-8.16,-6.31,-6.09,-4.69,-4.72,-5.5,-5.94,-6.28,-6.53,-6.41,-6.97,-6.72,-6.56,-6.59,-5.56,-6.31,-4.19,-4.09,-4.31,-1.97,-1.97,-0.59,0.38,1.44,2.78,3.0,4.91,6.06,6.28,8.16,7.31,6.31,5.09,2.19,-0.56,-3.34,-5.09,-6.81,-6.47,-6.16,-5.47,-2.41,-1.31,2.12,4.09,7.16,9.0,9.84,11.5,11.03,11.09,10.09,8.25,6.84,4.56,2.75,0.94,0.97,0.41,0.56,2.75,3.81,5.81,7.28,8.69,9.47,10.5,9.72,10.41,9.31,8.69,9.25,8.56,10.75,11.78,13.44,13.59,13.66,13.19,12.22,11.66,12.22,10.38,9.94,9.59,10.16,9.69,10.88,10.84,10.56,9.16,7.97,7.16,5.78,5.31,5.81,6.69,8.66,12.12,13.81,16.09,18.41,19.0,19.97,20.31,20.41,18.53,16.34,13.69,12.09,9.0,8.12,7.5,6.25,7.66,7.78,9.0,7.66,6.72,4.25,0.19,-4.72,2.84,2.22,0.44,-1.09,-1.88,-1.97,-2.03,-2.72,-3.44,-4.22,-6.03,-6.91:18.69,20.34,23.81,25.81,26.66,27.34,29.25,29.06,30.16,31.25,32.91,33.78,35.03,34.16,35.06,34.72,33.91,35.22,33.81,34.44,33.81,32.72,31.75,31.66,30.91,30.22,30.31,29.72,29.66,29.62,31.19,32.09,33.16,36.66,36.53,36.12,36.19,34.56,32.12,29.75,28.34,24.16,22.81,21.0,18.19,18.59,18.25,17.47,18.38,17.97,16.16,15.16,13.34,13.16,11.53,10.5,8.78,7.12,6.0,4.12,4.66,4.41,5.84,7.5,8.81,10.47,14.06,16.16,17.5,20.19,20.72,20.31,19.66,18.44,16.06,14.09,12.84,11.59,11.62,12.72,12.44,13.16,11.94,11.28,11.16,9.88,10.59,11.16,12.19,12.72,12.91,11.03,10.06,7.44,6.19,3.78,2.38,0.97,-1.06,-2.66,-2.28,-2.34,-1.09,-0.94,-0.25,-0.09,0.06,2.09,3.44,5.53,5.5,8.22,9.41,10.59,12.06,13.81,13.16,12.62,13.03,12.09,12.88,13.38,12.47,11.0,9.47,7.88,6.53,5.25,4.31,2.69,-0.22,-1.31,-1.72,-2.31,-0.69,0.47,1.66,2.84,1.69,2.53,0.16,-0.84,-2.69,-4.47,-5.34,-5.72,-6.97,-6.84,-7.12,-7.66,-8.5,-9.31,-8.88,-9.59,-9.06,-8.72,-8.09,-6.59,-7.0,-4.81,-3.34,-2.16,-0.56,0.81,0.56,1.5,1.5,1.69,2.31,1.53,0.25,0.41,-0.94,-1.34,0.0,0.72,2.62,3.5,6.41,7.94,10.19,13.56,15.31,15.91,13.88,11.06,5.62,1.66,-1.09,-1.62,-0.31,1.88,3.84,4.38,6.44,5.97,7.69,8.03,8.75,8.09,5.69,4.28,1.03,-0.72,-0.81,-1.59,0.31,2.12,4.66,6.44,7.44,6.78,6.19,3.94,1.78,0.34,-3.72,-3.5,-6.44,-7.59,-8.03,-8.16,-8.94,-10.22,-11.44,-12.03,-13.53,-13.19,-12.28,-10.78,-10.19,-8.03,-6.59,-5.78,-5.75,-6.84,-6.81,-9.97,-11.06,-13.34,-15.06,-15.81,-16.5,-17.53,-16.75,-17.66,-16.34,-15.81,-13.72,-11.91,-10.44,-8.94,-6.81,-4.84,-4.59,-4.34,-3.34,-4.75,-5.47,-6.38,-7.97,-10.0,-11.53,-14.03,-13.88,-13.16,-12.34,-10.28,-7.22,-5.66,-3.09,-0.53,0.5,0.56,0.81,1.12,0.75,0.06,0.69,-0.94,-2.84,-3.97,-7.09,-5.47,-6.16,-5.28,-2.22,-1.59,-0.16,-0.22,0.12,-1.31,-2.38,-1.81,-2.22,-3.31,-2.09,-2.56,-4.16,-4.06,-3.34,-2.75,-1.97,0.16,1.72,2.94,3.34,3.72,2.91,3.19,2.72,2.31,1.12,1.44,-0.06,0.41,-0.16,2.25,3.91,5.94,6.81,6.06,4.47,-1.47,-3.03,-5.84,-5.91,-5.75,-4.06,-1.75,-2.59,-2.19,-1.66,-1.25,-1.22,0.97,1.06,3.09,3.81,3.88,4.41,3.62,3.31,1.75,1.41,0.19,-0.94,-1.78,-0.44,-0.53,2.06,2.53,4.06,3.31,3.81,2.91,4.59,3.0,3.31,4.38,3.09,3.62,4.0,5.19,5.44,6.62,6.44,6.06,6.78,6.66,6.5,7.12,8.28,9.16,10.06,11.53,12.19,12.41,12.62,15.41,14.69,17.97,18.34,17.91,17.69,16.06,14.78,12.38,10.62,9.41,7.25,7.16,7.28,5.91,6.56,5.88,5.91,6.0,6.69,6.53,6.62,5.09,4.16,3.75,3.91,4.44,4.97,8.53,9.28,10.88,12.56,14.16,14.5,14.44,16.28,16.31,17.62,21.62,24.72,27.22,29.41,29.16,27.41,23.06,19.28,15.56,12.94,9.62,7.25,7.09,5.56,4.53,5.56,4.28,3.78,1.69,2.0,1.44,1.09,1.19,1.12,-0.72,-1.91,-3.09,-3.38,-4.56,-5.28,-4.94,-5.59,-4.84,-3.34,-2.22,-1.03,-0.41,-0.69,0.69,0.56,0.62,0.44,-0.84,-2.72,-4.06,-5.38,-5.66,-5.0,-3.66,-1.94,-0.34,2.38,3.41,5.62,7.78,8.53,9.0,10.72,10.16,11.03,9.06,9.41,7.88,6.78,5.56,4.94,5.19,2.06,4.31,2.97,3.72,5.31,5.56,6.09,4.66,4.06,2.28,0.81,-1.84,-2.53,-4.31,-5.28,-4.66,-5.09,-4.59,-3.91,-3.84,-4.75,-5.47,-6.41,-8.03,-7.94,-9.03,-8.53,-7.66,-7.22,-6.06,-6.19,-5.69,-5.34,-7.34,-6.34,-6.97,-7.84,-7.66,-5.66,-3.72,-1.47,1.25,2.78,3.56,2.53,1.66,0.44,-0.78,-1.72,-1.94,-2.44,-1.22,0.0,2.81,4.25,5.84,5.66,5.09,2.81,2.69,1.69,1.56,1.28,1.25,-0.09,-1.59,-2.66,-3.59,-4.09,-3.56,-3.84,-3.84,-3.09,-3.44,-3.22,-2.16,-0.94,-1.16,-0.66,-0.59,-2.22,-1.81,-3.53,-4.84,-5.62,-6.09,-7.81,-7.59,-9.59,-8.28,-7.72,-6.53,-4.06,-2.34,-0.22,-1.19,-1.06,-2.22,-4.19,-5.91,-6.81,-8.19,-8.84,-9.47,-8.38,-8.31,-5.97,-5.97,-4.47,-4.66,-5.38,-6.47,-8.09,-9.84,-11.44,-11.72,-12.94,-12.41,-12.34,-10.66,-10.06,-8.53,-6.47,-5.78,-5.66,-6.94,-7.38,-8.44,-9.91,-11.22,-11.62,-12.69,-11.97,-12.34,-11.22,-11.28,-10.34,-9.47,-9.34,-6.53,-5.97,-6.09,-4.16,-4.53,-3.41,-3.56,-2.16,-3.75,-4.41,-6.19,-8.22,-9.56,-11.09,-11.25,-12.22,-11.47,-11.66,-11.69,-12.16,-12.09,-13.09,-13.12,-12.31,-10.91,-11.12,-10.28,-10.84,-9.78,-11.44,-9.72,-8.03,-3.97,-2.91,1.38,2.31,1.72,-0.25,-3.81,-8.53,-11.19,-13.91,-14.31,-12.84,-11.19,-8.34,-7.47,-7.47,-8.72,-10.66,-12.81,-15.19,-16.31,-18.47,-18.28,-18.66,-17.22,-16.06,-14.5,-12.72,-11.78,-11.53,-10.72,-10.56,-10.44,-10.06,-11.16,-10.53,-10.59,-9.88,-8.03,-6.12,-3.78,-1.84,-0.47,-0.22,-0.66,-2.0,-3.34,-5.69,-5.97,-7.34,-7.69,-5.34,-4.72,-4.41,-2.22,-2.62,-2.84,-3.66,-3.03,-1.66,-1.47,-1.53,-0.16,0.16,-1.09,-0.72,-1.69,-2.59,-3.28,-3.91,-3.66,-2.59,-2.66,-2.34,-2.72,-3.25,-2.94,-3.72,-3.34,-3.34,-4.16,-5.38,-6.34,-6.91,-6.75,-6.31,-7.03,-6.94,-7.41,-8.09,-9.69,-9.59,-10.66,-12.09,-12.84,-14.47,-14.09,-14.41,-14.28,-12.19,-10.72,-8.16,-6.31,-6.09,-4.69,-4.72,-5.5,-5.94,-6.28,-6.53,-6.41,-6.97,-6.72,-6.56,-6.59,-5.56,-6.31,-4.19,-4.09,-4.31,-1.97,-1.97,-0.59,0.38,1.44,2.78,3.0,4.91,6.06,6.28,8.16,7.31,6.31,5.09,2.19,-0.56,-3.34,-5.09,-6.81,-6.47,-6.16,-5.47,-2.41,-1.31,2.12,4.09,7.16,9.0,9.84,11.5,11.03,11.09,10.09,8.25,6.84,4.56,2.75,0.94,0.97,0.41,0.56,2.75,3.81,5.81,7.28,8.69,9.47,10.5,9.72,10.41,9.31,8.69,9.25,8.56,10.75,11.78,13.44,13.59,13.66,13.19,12.22,11.66,12.22,10.38,9.94,9.59,10.16,9.69,10.88,10.84,10.56,9.16,7.97,7.16,5.78,5.31,5.81,6.69,8.66,12.12,13.81,16.09,18.41,19.0,19.97,20.31,20.41,18.53,16.34,13.69,12.09,9.0,8.12,7.5,6.25,7.66,7.78,9.0,7.66,6.72,4.25,0.19,-4.72,2.84,2.22,0.44,-1.09,-1.88,-1.97,-2.03,-2.72,-3.44,-4.22,-6.03,-6.91,-6.38,-5.31,-3.97,-2.22,0.12,1.31:29.25,29.06,30.16,31.25,32.91,33.78,35.03,34.16,35.06,34.72,33.91,35.22,33.81,34.44,33.81,32.72,31.75,31.66,30.91,30.22,30.31,29.72,29.66,29.62,31.19,32.09,33.16,36.66,36.53,36.12,36.19,34.56,32.12,29.75,28.34,24.16,22.81,21.0,18.19,18.59,18.25,17.47,18.38,17.97,16.16,15.16,13.34,13.16,11.53,10.5,8.78,7.12,6.0,4.12,4.66,4.41,5.84,7.5,8.81,10.47,14.06,16.16,17.5,20.19,20.72,20.31,19.66,18.44,16.06,14.09,12.84,11.59,11.62,12.72,12.44,13.16,11.94,11.28,11.16,9.88,10.59,11.16,12.19,12.72,12.91,11.03,10.06,7.44,6.19,3.78,2.38,0.97,-1.06,-2.66,-2.28,-2.34,-1.09,-0.94,-0.25,-0.09,0.06,2.09,3.44,5.53,5.5,8.22,9.41,10.59,12.06,13.81,13.16,12.62,13.03,12.09,12.88,13.38,12.47,11.0,9.47,7.88,6.53,5.25,4.31,2.69,-0.22,-1.31,-1.72,-2.31,-0.69,0.47,1.66,2.84,1.69,2.53,0.16,-0.84,-2.69,-4.47,-5.34,-5.72,-6.97,-6.84,-7.12,-7.66,-8.5,-9.31,-8.88,-9.59,-9.06,-8.72,-8.09,-6.59,-7.0,-4.81,-3.34,-2.16,-0.56,0.81,0.56,1.5,1.5,1.69,2.31,1.53,0.25,0.41,-0.94,-1.34,0.0,0.72,2.62,3.5,6.41,7.94,10.19,13.56,15.31,15.91,13.88,11.06,5.62,1.66,-1.09,-1.62,-0.31,1.88,3.84,4.38,6.44,5.97,7.69,8.03,8.75,8.09,5.69,4.28,1.03,-0.72,-0.81,-1.59,0.31,2.12,4.66,6.44,7.44,6.78,6.19,3.94,1.78,0.34,-3.72,-3.5,-6.44,-7.59,-8.03,-8.16,-8.94,-10.22,-11.44,-12.03,-13.53,-13.19,-12.28,-10.78,-10.19,-8.03,-6.59,-5.78,-5.75,-6.84,-6.81,-9.97,-11.06,-13.34,-15.06,-15.81,-16.5,-17.53,-16.75,-17.66,-16.34,-15.81,-13.72,-11.91,-10.44,-8.94,-6.81,-4.84,-4.59,-4.34,-3.34,-4.75,-5.47,-6.38,-7.97,-10.0,-11.53,-14.03,-13.88,-13.16,-12.34,-10.28,-7.22,-5.66,-3.09,-0.53,0.5,0.56,0.81,1.12,0.75,0.06,0.69,-0.94,-2.84,-3.97,-7.09,-5.47,-6.16,-5.28,-2.22,-1.59,-0.16,-0.22,0.12,-1.31,-2.38,-1.81,-2.22,-3.31,-2.09,-2.56,-4.16,-4.06,-3.34,-2.75,-1.97,0.16,1.72,2.94,3.34,3.72,2.91,3.19,2.72,2.31,1.12,1.44,-0.06,0.41,-0.16,2.25,3.91,5.94,6.81,6.06,4.47,-1.47,-3.03,-5.84,-5.91,-5.75,-4.06,-1.75,-2.59,-2.19,-1.66,-1.25,-1.22,0.97,1.06,3.09,3.81,3.88,4.41,3.62,3.31,1.75,1.41,0.19,-0.94,-1.78,-0.44,-0.53,2.06,2.53,4.06,3.31,3.81,2.91,4.59,3.0,3.31,4.38,3.09,3.62,4.0,5.19,5.44,6.62,6.44,6.06,6.78,6.66,6.5,7.12,8.28,9.16,10.06,11.53,12.19,12.41,12.62,15.41,14.69,17.97,18.34,17.91,17.69,16.06,14.78,12.38,10.62,9.41,7.25,7.16,7.28,5.91,6.56,5.88,5.91,6.0,6.69,6.53,6.62,5.09,4.16,3.75,3.91,4.44,4.97,8.53,9.28,10.88,12.56,14.16,14.5,14.44,16.28,16.31,17.62,21.62,24.72,27.22,29.41,29.16,27.41,23.06,19.28,15.56,12.94,9.62,7.25,7.09,5.56,4.53,5.56,4.28,3.78,1.69,2.0,1.44,1.09,1.19,1.12,-0.72,-1.91,-3.09,-3.38,-4.56,-5.28,-4.94,-5.59,-4.84,-3.34,-2.22,-1.03,-0.41,-0.69,0.69,0.56,0.62,0.44,-0.84,-2.72,-4.06,-5.38,-5.66,-5.0,-3.66,-1.94,-0.34,2.38,3.41,5.62,7.78,8.53,9.0,10.72,10.16,11.03,9.06,9.41,7.88,6.78,5.56,4.94,5.19,2.06,4.31,2.97,3.72,5.31,5.56,6.09,4.66,4.06,2.28,0.81,-1.84,-2.53,-4.31,-5.28,-4.66,-5.09,-4.59,-3.91,-3.84,-4.75,-5.47,-6.41,-8.03,-7.94,-9.03,-8.53,-7.66,-7.22,-6.06,-6.19,-5.69,-5.34,-7.34,-6.34,-6.97,-7.84,-7.66,-5.66,-3.72,-1.47,1.25,2.78,3.56,2.53,1.66,0.44,-0.78,-1.72,-1.94,-2.44,-1.22,0.0,2.81,4.25,5.84,5.66,5.09,2.81,2.69,1.69,1.56,1.28,1.25,-0.09,-1.59,-2.66,-3.59,-4.09,-3.56,-3.84,-3.84,-3.09,-3.44,-3.22,-2.16,-0.94,-1.16,-0.66,-0.59,-2.22,-1.81,-3.53,-4.84,-5.62,-6.09,-7.81,-7.59,-9.59,-8.28,-7.72,-6.53,-4.06,-2.34,-0.22,-1.19,-1.06,-2.22,-4.19,-5.91,-6.81,-8.19,-8.84,-9.47,-8.38,-8.31,-5.97,-5.97,-4.47,-4.66,-5.38,-6.47,-8.09,-9.84,-11.44,-11.72,-12.94,-12.41,-12.34,-10.66,-10.06,-8.53,-6.47,-5.78,-5.66,-6.94,-7.38,-8.44,-9.91,-11.22,-11.62,-12.69,-11.97,-12.34,-11.22,-11.28,-10.34,-9.47,-9.34,-6.53,-5.97,-6.09,-4.16,-4.53,-3.41,-3.56,-2.16,-3.75,-4.41,-6.19,-8.22,-9.56,-11.09,-11.25,-12.22,-11.47,-11.66,-11.69,-12.16,-12.09,-13.09,-13.12,-12.31,-10.91,-11.12,-10.28,-10.84,-9.78,-11.44,-9.72,-8.03,-3.97,-2.91,1.38,2.31,1.72,-0.25,-3.81,-8.53,-11.19,-13.91,-14.31,-12.84,-11.19,-8.34,-7.47,-7.47,-8.72,-10.66,-12.81,-15.19,-16.31,-18.47,-18.28,-18.66,-17.22,-16.06,-14.5,-12.72,-11.78,-11.53,-10.72,-10.56,-10.44,-10.06,-11.16,-10.53,-10.59,-9.88,-8.03,-6.12,-3.78,-1.84,-0.47,-0.22,-0.66,-2.0,-3.34,-5.69,-5.97,-7.34,-7.69,-5.34,-4.72,-4.41,-2.22,-2.62,-2.84,-3.66,-3.03,-1.66,-1.47,-1.53,-0.16,0.16,-1.09,-0.72,-1.69,-2.59,-3.28,-3.91,-3.66,-2.59,-2.66,-2.34,-2.72,-3.25,-2.94,-3.72,-3.34,-3.34,-4.16,-5.38,-6.34,-6.91,-6.75,-6.31,-7.03,-6.94,-7.41,-8.09,-9.69,-9.59,-10.66,-12.09,-12.84,-14.47,-14.09,-14.41,-14.28,-12.19,-10.72,-8.16,-6.31,-6.09,-4.69,-4.72,-5.5,-5.94,-6.28,-6.53,-6.41,-6.97,-6.72,-6.56,-6.59,-5.56,-6.31,-4.19,-4.09,-4.31,-1.97,-1.97,-0.59,0.38,1.44,2.78,3.0,4.91,6.06,6.28,8.16,7.31,6.31,5.09,2.19,-0.56,-3.34,-5.09,-6.81,-6.47,-6.16,-5.47,-2.41,-1.31,2.12,4.09,7.16,9.0,9.84,11.5,11.03,11.09,10.09,8.25,6.84,4.56,2.75,0.94,0.97,0.41,0.56,2.75,3.81,5.81,7.28,8.69,9.47,10.5,9.72,10.41,9.31,8.69,9.25,8.56,10.75,11.78,13.44,13.59,13.66,13.19,12.22,11.66,12.22,10.38,9.94,9.59,10.16,9.69,10.88,10.84,10.56,9.16,7.97,7.16,5.78,5.31,5.81,6.69,8.66,12.12,13.81,16.09,18.41,19.0,19.97,20.31,20.41,18.53,16.34,13.69,12.09,9.0,8.12,7.5,6.25,7.66,7.78,9.0,7.66,6.72,4.25,0.19,-4.72,2.84,2.22,0.44,-1.09,-1.88,-1.97,-2.03,-2.72,-3.44,-4.22,-6.03,-6.91,-6.38,-5.31,-3.97,-2.22,0.12,1.31,2.22,4.59,7.0,8.78,9.84,11.03:35.03,34.16,35.06,34.72,33.91,35.22,33.81,34.44,33.81,32.72,31.75,31.66,30.91,30.22,30.31,29.72,29.66,29.62,31.19,32.09,33.16,36.66,36.53,36.12,36.19,34.56,32.12,29.75,28.34,24.16,22.81,21.0,18.19,18.59,18.25,17.47,18.38,17.97,16.16,15.16,13.34,13.16,11.53,10.5,8.78,7.12,6.0,4.12,4.66,4.41,5.84,7.5,8.81,10.47,14.06,16.16,17.5,20.19,20.72,20.31,19.66,18.44,16.06,14.09,12.84,11.59,11.62,12.72,12.44,13.16,11.94,11.28,11.16,9.88,10.59,11.16,12.19,12.72,12.91,11.03,10.06,7.44,6.19,3.78,2.38,0.97,-1.06,-2.66,-2.28,-2.34,-1.09,-0.94,-0.25,-0.09,0.06,2.09,3.44,5.53,5.5,8.22,9.41,10.59,12.06,13.81,13.16,12.62,13.03,12.09,12.88,13.38,12.47,11.0,9.47,7.88,6.53,5.25,4.31,2.69,-0.22,-1.31,-1.72,-2.31,-0.69,0.47,1.66,2.84,1.69,2.53,0.16,-0.84,-2.69,-4.47,-5.34,-5.72,-6.97,-6.84,-7.12,-7.66,-8.5,-9.31,-8.88,-9.59,-9.06,-8.72,-8.09,-6.59,-7.0,-4.81,-3.34,-2.16,-0.56,0.81,0.56,1.5,1.5,1.69,2.31,1.53,0.25,0.41,-0.94,-1.34,0.0,0.72,2.62,3.5,6.41,7.94,10.19,13.56,15.31,15.91,13.88,11.06,5.62,1.66,-1.09,-1.62,-0.31,1.88,3.84,4.38,6.44,5.97,7.69,8.03,8.75,8.09,5.69,4.28,1.03,-0.72,-0.81,-1.59,0.31,2.12,4.66,6.44,7.44,6.78,6.19,3.94,1.78,0.34,-3.72,-3.5,-6.44,-7.59,-8.03,-8.16,-8.94,-10.22,-11.44,-12.03,-13.53,-13.19,-12.28,-10.78,-10.19,-8.03,-6.59,-5.78,-5.75,-6.84,-6.81,-9.97,-11.06,-13.34,-15.06,-15.81,-16.5,-17.53,-16.75,-17.66,-16.34,-15.81,-13.72,-11.91,-10.44,-8.94,-6.81,-4.84,-4.59,-4.34,-3.34,-4.75,-5.47,-6.38,-7.97,-10.0,-11.53,-14.03,-13.88,-13.16,-12.34,-10.28,-7.22,-5.66,-3.09,-0.53,0.5,0.56,0.81,1.12,0.75,0.06,0.69,-0.94,-2.84,-3.97,-7.09,-5.47,-6.16,-5.28,-2.22,-1.59,-0.16,-0.22,0.12,-1.31,-2.38,-1.81,-2.22,-3.31,-2.09,-2.56,-4.16,-4.06,-3.34,-2.75,-1.97,0.16,1.72,2.94,3.34,3.72,2.91,3.19,2.72,2.31,1.12,1.44,-0.06,0.41,-0.16,2.25,3.91,5.94,6.81,6.06,4.47,-1.47,-3.03,-5.84,-5.91,-5.75,-4.06,-1.75,-2.59,-2.19,-1.66,-1.25,-1.22,0.97,1.06,3.09,3.81,3.88,4.41,3.62,3.31,1.75,1.41,0.19,-0.94,-1.78,-0.44,-0.53,2.06,2.53,4.06,3.31,3.81,2.91,4.59,3.0,3.31,4.38,3.09,3.62,4.0,5.19,5.44,6.62,6.44,6.06,6.78,6.66,6.5,7.12,8.28,9.16,10.06,11.53,12.19,12.41,12.62,15.41,14.69,17.97,18.34,17.91,17.69,16.06,14.78,12.38,10.62,9.41,7.25,7.16,7.28,5.91,6.56,5.88,5.91,6.0,6.69,6.53,6.62,5.09,4.16,3.75,3.91,4.44,4.97,8.53,9.28,10.88,12.56,14.16,14.5,14.44,16.28,16.31,17.62,21.62,24.72,27.22,29.41,29.16,27.41,23.06,19.28,15.56,12.94,9.62,7.25,7.09,5.56,4.53,5.56,4.28,3.78,1.69,2.0,1.44,1.09,1.19,1.12,-0.72,-1.91,-3.09,-3.38,-4.56,-5.28,-4.94,-5.59,-4.84,-3.34,-2.22,-1.03,-0.41,-0.69,0.69,0.56,0.62,0.44,-0.84,-2.72,-4.06,-5.38,-5.66,-5.0,-3.66,-1.94,-0.34,2.38,3.41,5.62,7.78,8.53,9.0,10.72,10.16,11.03,9.06,9.41,7.88,6.78,5.56,4.94,5.19,2.06,4.31,2.97,3.72,5.31,5.56,6.09,4.66,4.06,2.28,0.81,-1.84,-2.53,-4.31,-5.28,-4.66,-5.09,-4.59,-3.91,-3.84,-4.75,-5.47,-6.41,-8.03,-7.94,-9.03,-8.53,-7.66,-7.22,-6.06,-6.19,-5.69,-5.34,-7.34,-6.34,-6.97,-7.84,-7.66,-5.66,-3.72,-1.47,1.25,2.78,3.56,2.53,1.66,0.44,-0.78,-1.72,-1.94,-2.44,-1.22,0.0,2.81,4.25,5.84,5.66,5.09,2.81,2.69,1.69,1.56,1.28,1.25,-0.09,-1.59,-2.66,-3.59,-4.09,-3.56,-3.84,-3.84,-3.09,-3.44,-3.22,-2.16,-0.94,-1.16,-0.66,-0.59,-2.22,-1.81,-3.53,-4.84,-5.62,-6.09,-7.81,-7.59,-9.59,-8.28,-7.72,-6.53,-4.06,-2.34,-0.22,-1.19,-1.06,-2.22,-4.19,-5.91,-6.81,-8.19,-8.84,-9.47,-8.38,-8.31,-5.97,-5.97,-4.47,-4.66,-5.38,-6.47,-8.09,-9.84,-11.44,-11.72,-12.94,-12.41,-12.34,-10.66,-10.06,-8.53,-6.47,-5.78,-5.66,-6.94,-7.38,-8.44,-9.91,-11.22,-11.62,-12.69,-11.97,-12.34,-11.22,-11.28,-10.34,-9.47,-9.34,-6.53,-5.97,-6.09,-4.16,-4.53,-3.41,-3.56,-2.16,-3.75,-4.41,-6.19,-8.22,-9.56,-11.09,-11.25,-12.22,-11.47,-11.66,-11.69,-12.16,-12.09,-13.09,-13.12,-12.31,-10.91,-11.12,-10.28,-10.84,-9.78,-11.44,-9.72,-8.03,-3.97,-2.91,1.38,2.31,1.72,-0.25,-3.81,-8.53,-11.19,-13.91,-14.31,-12.84,-11.19,-8.34,-7.47,-7.47,-8.72,-10.66,-12.81,-15.19,-16.31,-18.47,-18.28,-18.66,-17.22,-16.06,-14.5,-12.72,-11.78,-11.53,-10.72,-10.56,-10.44,-10.06,-11.16,-10.53,-10.59,-9.88,-8.03,-6.12,-3.78,-1.84,-0.47,-0.22,-0.66,-2.0,-3.34,-5.69,-5.97,-7.34,-7.69,-5.34,-4.72,-4.41,-2.22,-2.62,-2.84,-3.66,-3.03,-1.66,-1.47,-1.53,-0.16,0.16,-1.09,-0.72,-1.69,-2.59,-3.28,-3.91,-3.66,-2.59,-2.66,-2.34,-2.72,-3.25,-2.94,-3.72,-3.34,-3.34,-4.16,-5.38,-6.34,-6.91,-6.75,-6.31,-7.03,-6.94,-7.41,-8.09,-9.69,-9.59,-10.66,-12.09,-12.84,-14.47,-14.09,-14.41,-14.28,-12.19,-10.72,-8.16,-6.31,-6.09,-4.69,-4.72,-5.5,-5.94,-6.28,-6.53,-6.41,-6.97,-6.72,-6.56,-6.59,-5.56,-6.31,-4.19,-4.09,-4.31,-1.97,-1.97,-0.59,0.38,1.44,2.78,3.0,4.91,6.06,6.28,8.16,7.31,6.31,5.09,2.19,-0.56,-3.34,-5.09,-6.81,-6.47,-6.16,-5.47,-2.41,-1.31,2.12,4.09,7.16,9.0,9.84,11.5,11.03,11.09,10.09,8.25,6.84,4.56,2.75,0.94,0.97,0.41,0.56,2.75,3.81,5.81,7.28,8.69,9.47,10.5,9.72,10.41,9.31,8.69,9.25,8.56,10.75,11.78,13.44,13.59,13.66,13.19,12.22,11.66,12.22,10.38,9.94,9.59,10.16,9.69,10.88,10.84,10.56,9.16,7.97,7.16,5.78,5.31,5.81,6.69,8.66,12.12,13.81,16.09,18.41,19.0,19.97,20.31,20.41,18.53,16.34,13.69,12.09,9.0,8.12,7.5,6.25,7.66,7.78,9.0,7.66,6.72,4.25,0.19,-4.72,2.84,2.22,0.44,-1.09,-1.88,-1.97,-2.03,-2.72,-3.44,-4.22,-6.03,-6.91,-6.38,-5.31,-3.97,-2.22,0.12,1.31,2.22,4.59,7.0,8.78,9.84,11.03,10.88,10.66,10.19,10.5,11.38,12.28:positivity
35.09,35.97,37.66,35.91,34.0,29.44,27.62,21.19,16.28,11.5,7.59,4.09,2.0,1.25,2.19,3.81,7.41,12.66,17.38,22.0,27.81,30.56,31.69,34.19,32.41,30.5,30.03,27.53,23.94,22.59,21.19,20.38,21.16,22.03,23.03,24.91,24.25,20.78,19.62,17.19,13.41,12.97,12.0,12.91,15.31,18.53,21.22,23.38,26.5,26.78,25.34,23.62,22.19,19.12,18.0,17.72,18.12,18.19,16.34,14.69,13.31,12.5,12.5,11.69,11.03,9.88,7.62,5.16,3.53,2.66,2.0,0.91,2.0,1.59,2.22,2.75,3.59,5.34,4.41,6.69,6.84,7.12,10.28,11.38,10.78,12.56,12.31,12.5,13.78,14.91,15.81,16.66,17.56,15.78,13.78,14.69,11.28,13.66,13.97,14.12,15.56,16.69,16.34,17.75,19.81,20.97,21.53,22.59,21.47,19.59,18.84,17.66,16.62,16.5,16.84,18.09,18.19,20.25,19.28,18.62,19.28,19.06,18.81,19.69,21.41,22.59,23.47,23.75,24.31,24.81,26.41,26.97,28.16,29.22,28.5,28.06,28.72,29.81,32.88,36.41,38.88,40.16,40.72,40.19,38.34,35.72,34.25,30.84,28.66,25.94,23.75,21.31,20.66,20.62,20.62,22.41,21.0,24.12,25.44,28.38,30.62,32.62,35.25,32.81,32.09,28.0,24.44,22.12,20.09,17.94,19.88,20.5,22.97,25.25,27.12,27.25,26.69,23.25,19.72,17.56,13.44,12.12,12.44,11.47,14.94,17.69,20.38,25.5,28.69,30.06,30.72,30.94,31.47,30.12,29.16,29.78,26.31,24.81,22.0,21.16,21.03,19.69,23.16,23.41,23.19,23.44,21.66,22.06,22.0,24.31,28.38,31.62,34.16,35.41,34.56,30.94,27.03,24.16,18.91,16.47,13.88,11.22,10.84,9.44,10.53,11.81,14.03,14.53,16.84,18.72,20.75,23.66,26.03,27.59,30.31,31.22,33.66,34.75,35.75,37.38,35.78,34.72,32.97,31.0,29.06,27.53,26.28,23.97,23.84,23.81,23.06,23.47,24.91,25.06,26.41,26.19,27.5,30.69,32.22,35.56,37.97,41.09,41.78,44.06,44.5,43.25,42.56,39.84,37.09,33.56,32.0,30.5,30.97,31.19,32.12,33.91,35.25,35.75,39.28,40.31,41.5,43.34,43.44,43.34,41.56,39.56,36.0,32.97,28.44,26.41,24.41,24.31,26.28,27.75,29.53,34.19,36.0,37.41,38.81,38.06,37.03,35.0,33.09,30.91,28.28,24.56,22.59,21.53,22.81,25.5,28.94,33.25,36.38,38.38,39.88,41.41,41.31,42.5,42.56,42.06,42.94,41.94,40.34,38.31,36.09,31.41,28.09,23.56,21.94,21.59,22.53,24.69,27.16,30.78,33.12,35.81,38.88,40.06,40.0,39.94,37.44,35.19,32.62,32.75,31.78,31.16,32.56,33.03,31.31,33.84,31.75,31.56,30.34,29.78,27.38,26.16,26.16,26.75,28.91,30.34,29.41,29.81,29.25,29.44,28.69,29.12,30.53,30.88,30.25,31.06,31.47,30.06,31.56,31.41,31.06,31.06,32.03,32.09,30.19,32.5,32.0,32.06,30.88,28.91,28.22,26.56,24.28,25.06,24.81,25.0,26.81,27.56,29.91,29.72,31.03,30.69,31.25,31.19,31.78,32.88,34.72,35.34,36.81,37.69,36.81,36.19,35.0,32.09,29.31,29.06,26.19,25.16,25.0,24.78,24.56,24.84,24.12,23.84,23.88,21.84,21.84,21.94,21.81,23.19,25.0,26.69,27.78,28.03,25.16,26.19,25.25,23.0,23.59,22.56,21.91,20.56,19.19,20.34,23.66,26.91,32.44,37.75,40.0,41.69,39.84,37.47,34.56,33.38,32.97,31.91,33.12,32.16,30.94,28.72,28.41,25.09,25.31,23.59,23.66,23.91,24.12,25.16,25.97,27.97,27.94,30.06,29.94,29.56,28.53,27.16,27.69,27.56,30.88,32.72,33.44,35.28,35.81,33.44,32.5,29.94,28.41,27.03,25.62,26.62,27.19,27.91,27.0,26.06,25.81,23.66,23.47,24.84,24.91,25.56,25.62,27.16,27.25,27.44,28.56,30.66,31.34,32.34,32.38,31.88,31.16,30.31,31.47,31.59,32.5,33.94,35.81,35.31,36.78,35.62,35.53,34.31,34.16,32.44,32.81,34.5,35.38,37.44,40.06,41.72,42.41,41.06,40.44,39.16,37.69,35.81,34.31,33.97,31.69,31.62,30.75,29.5,28.75,28.19,28.44,28.31,28.88,27.69,28.5,27.88,27.25,27.34,27.5,28.0,27.78,28.03,28.84,30.06,33.0,32.72,34.75,34.5,33.53,34.16,33.16,32.81,34.44,33.81,33.56,33.56,32.25,29.41,31.44,32.44,34.34,37.03,39.19,38.88,34.94,30.5,27.59,23.19,20.91,19.72,19.75,18.12,17.19,17.69,18.06,16.0,15.12,14.91,13.44,14.28,15.19,15.91,18.94,19.56,20.53,21.56,23.66,24.75,26.19,27.47,27.12,27.41,25.62,23.22,20.44,19.91,17.0,16.75,15.31,15.25,14.84,15.59,15.53,16.53,14.94,17.28,17.16,19.19,21.62,24.25,27.0,27.94,29.06,27.19,26.81,24.97,23.44,21.06,19.88,19.34,18.84,19.38,18.28,18.06,17.53,16.12,16.44,15.72,16.84,17.25,17.72,18.69,19.5,19.66,22.16,21.41,23.53,24.12,25.44,27.19,27.66,27.22,27.56,26.56,26.31,25.97,24.62,24.09,24.53,23.53,25.0,25.5,27.84,28.25,28.97,30.16,30.41,30.25,30.41,30.97,29.34,27.62,27.19,26.66,25.19,23.12,24.44,23.78,22.78,22.81,22.5,22.91,21.5,20.5,18.75,20.59,21.06,24.69,30.16,34.19,37.97,38.94,37.19,33.66,29.09,25.06,21.06,19.56,17.84,16.78,17.81,18.12,16.25,16.81,15.75,14.09,13.53,14.09,13.81,16.31,18.06,21.09,23.47,27.12,29.03,30.44,30.62,31.03,27.72,25.28,23.09,19.94,18.53,17.0,16.66,17.25,17.75,16.88,16.12,16.62,14.81,13.47,12.62,11.16,9.16,8.94,9.19,9.28,12.91,14.91,17.62,21.28,21.31,22.59,23.44,21.25,20.19,21.16,21.09,21.91,23.28,24.03,22.53,24.25,24.31,24.25,25.47,25.28,25.03,24.91,26.03,27.91,30.06,32.69,32.81,33.12,31.31,29.12,26.47,26.0,23.62,22.69,22.28,21.5,18.88,16.88,15.47,13.31,12.38,11.16,9.78,7.41,6.5,5.16,4.03,3.69,4.44,5.12,4.66,6.34,7.22,7.88,9.75,10.75,11.12,11.25,10.72,9.75,8.09,7.47,7.66,7.53,8.31,8.91,10.41,10.97,9.62,10.31,10.62,8.75,10.28,11.31,12.53,14.0,14.41,16.59,17.0,17.72,18.84,18.78,17.47,16.66,15.12,13.78,13.19,12.56,11.41,11.03,9.56,9.12,7.66,7.62,6.62,7.59,6.62,8.47,9.25,9.0,8.75,7.44,6.44,4.28,3.5,3.31,3.34,2.0,3.84,4.62,5.03,6.81,7.34,6.66,7.16,6.44,6.06,5.31,5.12,3.34,3.0,2.59,3.19,4.16,5.38,6.53,6.88,5.78,7.72,9.28,9.94,11.81,12.81,12.88,12.34,11.84,9.88,9.0,5.66,5.78,3.12,2.75,2.34,3.84,5.12,6.03,8.12,9.19,9.03,10.06,10.06,9.06,7.44,7.75,4.12,3.84,2.78,4.19,5.41,6.81:27.62,21.19,16.28,11.5,7.59,4.09,2.0,1.25,2.19,3.81,7.41,12.66,17.38,22.0,27.81,30.56,31.69,34.19,32.41,30.5,30.03,27.53,23.94,22.59,21.19,20.38,21.16,22.03,23.03,24.91,24.25,20.78,19.62,17.19,13.41,12.97,12.0,12.91,15.31,18.53,21.22,23.38,26.5,26.78,25.34,23.62,22.19,19.12,18.0,17.72,18.12,18.19,16.34,14.69,13.31,12.5,12.5,11.69,11.03,9.88,7.62,5.16,3.53,2.66,2.0,0.91,2.0,1.59,2.22,2.75,3.59,5.34,4.41,6.69,6.84,7.12,10.28,11.38,10.78,12.56,12.31,12.5,13.78,14.91,15.81,16.66,17.56,15.78,13.78,14.69,11.28,13.66,13.97,14.12,15.56,16.69,16.34,17.75,19.81,20.97,21.53,22.59,21.47,19.59,18.84,17.66,16.62,16.5,16.84,18.09,18.19,20.25,19.28,18.62,19.28,19.06,18.81,19.69,21.41,22.59,23.47,23.75,24.31,24.81,26.41,26.97,28.16,29.22,28.5,28.06,28.72,29.81,32.88,36.41,38.88,40.16,40.72,40.19,38.34,35.72,34.25,30.84,28.66,25.94,23.75,21.31,20.66,20.62,20.62,22.41,21.0,24.12,25.44,28.38,30.62,32.62,35.25,32.81,32.09,28.0,24.44,22.12,20.09,17.94,19.88,20.5,22.97,25.25,27.12,27.25,26.69,23.25,19.72,17.56,13.44,12.12,12.44,11.47,14.94,17.69,20.38,25.5,28.69,30.06,30.72,30.94,31.47,30.12,29.16,29.78,26.31,24.81,22.0,21.16,21.03,19.69,23.16,23.41,23.19,23.44,21.66,22.06,22.0,24.31,28.38,31.62,34.16,35.41,34.56,30.94,27.03,24.16,18.91,16.47,13.88,11.22,10.84,9.44,10.53,11.81,14.03,14.53,16.84,18.72,20.75,23.66,26.03,27.59,30.31,31.22,33.66,34.75,35.75,37.38,35.78,34.72,32.97,31.0,29.06,27.53,26.28,23.97,23.84,23.81,23.06,23.47,24.91,25.06,26.41,26.19,27.5,30.69,32.22,35.56,37.97,41.09,41.78,44.06,44.5,43.25,42.56,39.84,37.09,33.56,32.0,30.5,30.97,31.19,32.12,33.91,35.25,35.75,39.28,40.31,41.5,43.34,43.44,43.34,41.56,39.56,36.0,32.97,28.44,26.41,24.41,24.31,26.28,27.75,29.53,34.19,36.0,37.41,38.81,38.06,37.03,35.0,33.09,30.91,28.28,24.56,22.59,21.53,22.81,25.5,28.94,33.25,36.38,38.38,39.88,41.41,41.31,42.5,42.56,42.06,42.94,41.94,40.34,38.31,36.09,31.41,28.09,23.56,21.94,21.59,22.53,24.69,27.16,30.78,33.12,35.81,38.88,40.06,40.0,39.94,37.44,35.19,32.62,32.75,31.78,31.16,32.56,33.03,31.31,33.84,31.75,31.56,30.34,29.78,27.38,26.16,26.16,26.75,28.91,30.34,29.41,29.81,29.25,29.44,28.69,29.12,30.53,30.88,30.25,31.06,31.47,30.06,31.56,31.41,31.06,31.06,32.03,32.09,30.19,32.5,32.0,32.06,30.88,28.91,28.22,26.56,24.28,25.06,24.81,25.0,26.81,27.56,29.91,29.72,31.03,30.69,31.25,31.19,31.78,32.88,34.72,35.34,36.81,37.69,36.81,36.19,35.0,32.09,29.31,29.06,26.19,25.16,25.0,24.78,24.56,24.84,24.12,23.84,23.88,21.84,21.84,21.94,21.81,23.19,25.0,26.69,27.78,28.03,25.16,26.19,25.25,23.0,23.59,22.56,21.91,20.56,19.19,20.34,23.66,26.91,32.44,37.75,40.0,41.69,39.84,37.47,34.56,33.38,32.97,31.91,33.12,32.16,30.94,28.72,28.41,25.09,25.31,23.59,23.66,23.91,24.12,25.16,25.97,27.97,27.94,30.06,29.94,29.56,28.53,27.16,27.69,27.56,30.88,32.72,33.44,35.28,35.81,33.44,32.5,29.94,28.41,27.03,25.62,26.62,27.19,27.91,27.0,26.06,25.81,23.66,23.47,24.84,24.91,25.56,25.62,27.16,27.25,27.44,28.56,30.66,31.34,32.34,32.38,31.88,31.16,30.31,31.47,31.59,32.5,33.94,35.81,35.31,36.78,35.62,35.53,34.31,34.16,32.44,32.81,34.5,35.38,37.44,40.06,41.72,42.41,41.06,40.44,39.16,37.69,35.81,34.31,33.97,31.69,31.62,30.75,29.5,28.75,28.19,28.44,28.31,28.88,27.69,28.5,27.88,27.25,27.34,27.5,28.0,27.78,28.03,28.84,30.06,33.0,32.72,34.75,34.5,33.53,34.16,33.16,32.81,34.44,33.81,33.56,33.56,32.25,29.41,31.44,32.44,34.34,37.03,39.19,38.88,34.94,30.5,27.59,23.19,20.91,19.72,19.75,18.12,17.19,17.69,18.06,16.0,15.12,14.91,13.44,14.28,15.19,15.91,18.94,19.56,20.53,21.56,23.66,24.75,26.19,27.47,27.12,27.41,25.62,23.22,20.44,19.91,17.0,16.75,15.31,15.25,14.84,15.59,15.53,16.53,14.94,17.28,17.16,19.19,21.62,24.25,27.0,27.94,29.06,27.19,26.81,24.97,23.44,21.06,19.88,19.34,18.84,19.38,18.28,18.06,17.53,16.12,16.44,15.72,16.84,17.25,17.72,18.69,19.5,19.66,22.16,21.41,23.53,24.12,25.44,27.19,27.66,27.22,27.56,26.56,26.31,25.97,24.62,24.09,24.53,23.53,25.0,25.5,27.84,28.25,28.97,30.16,30.41,30.25,30.41,30.97,29.34,27.62,27.19,26.66,25.19,23.12,24.44,23.78,22.78,22.81,22.5,22.91,21.5,20.5,18.75,20.59,21.06,24.69,30.16,34.19,37.97,38.94,37.19,33.66,29.09,25.06,21.06,19.56,17.84,16.78,17.81,18.12,16.25,16.81,15.75,14.09,13.53,14.09,13.81,16.31,18.06,21.09,23.47,27.12,29.03,30.44,30.62,31.03,27.72,25.28,23.09,19.94,18.53,17.0,16.66,17.25,17.75,16.88,16.12,16.62,14.81,13.47,12.62,11.16,9.16,8.94,9.19,9.28,12.91,14.91,17.62,21.28,21.31,22.59,23.44,21.25,20.19,21.16,21.09,21.91,23.28,24.03,22.53,24.25,24.31,24.25,25.47,25.28,25.03,24.91,26.03,27.91,30.06,32.69,32.81,33.12,31.31,29.12,26.47,26.0,23.62,22.69,22.28,21.5,18.88,16.88,15.47,13.31,12.38,11.16,9.78,7.41,6.5,5.16,4.03,3.69,4.44,5.12,4.66,6.34,7.22,7.88,9.75,10.75,11.12,11.25,10.72,9.75,8.09,7.47,7.66,7.53,8.31,8.91,10.41,10.97,9.62,10.31,10.62,8.75,10.28,11.31,12.53,14.0,14.41,16.59,17.0,17.72,18.84,18.78,17.47,16.66,15.12,13.78,13.19,12.56,11.41,11.03,9.56,9.12,7.66,7.62,6.62,7.59,6.62,8.47,9.25,9.0,8.75,7.44,6.44,4.28,3.5,3.31,3.34,2.0,3.84,4.62,5.03,6.81,7.34,6.66,7.16,6.44,6.06,5.31,5.12,3.34,3.0,2.59,3.19,4.16,5.38,6.53,6.88,5.78,7.72,9.28,9.94,11.81,12.81,12.88,12.34,11.84,9.88,9.0,5.66,5.78,3.12,2.75,2.34,3.84,5.12,6.03,8.12,9.19,9.03,10.06,10.06,9.06,7.44,7.75,4.12,3.84,2.78,4.19,5.41,6.81,40.5,40.62,42.25,41.34,39.53,34.28:2.0,1.25,2.19,3.81,7.41,12.66,17.38,22.0,27.81,30.56,31.69,34.19,32.41,30.5,30.03,27.53,23.94,22.59,21.19,20.38,21.16,22.03,23.03,24.91,24.25,20.78,19.62,17.19,13.41,12.97,12.0,12.91,15.31,18.53,21.22,23.38,26.5,26.78,25.34,23.62,22.19,19.12,18.0,17.72,18.12,18.19,16.34,14.69,13.31,12.5,12.5,11.69,11.03,9.88,7.62,5.16,3.53,2.66,2.0,0.91,2.0,1.59,2.22,2.75,3.59,5.34,4.41,6.69,6.84,7.12,10.28,11.38,10.78,12.56,12.31,12.5,13.78,14.91,15.81,16.66,17.56,15.78,13.78,14.69,11.28,13.66,13.97,14.12,15.56,16.69,16.34,17.75,19.81,20.97,21.53,22.59,21.47,19.59,18.84,17.66,16.62,16.5,16.84,18.09,18.19,20.25,19.28,18.62,19.28,19.06,18.81,19.69,21.41,22.59,23.47,23.75,24.31,24.81,26.41,26.97,28.16,29.22,28.5,28.06,28.72,29.81,32.88,36.41,38.88,40.16,40.72,40.19,38.34,35.72,34.25,30.84,28.66,25.94,23.75,21.31,20.66,20.62,20.62,22.41,21.0,24.12,25.44,28.38,30.62,32.62,35.25,32.81,32.09,28.0,24.44,22.12,20.09,17.94,19.88,20.5,22.97,25.25,27.12,27.25,26.69,23.25,19.72,17.56,13.44,12.12,12.44,11.47,14.94,17.69,20.38,25.5,28.69,30.06,30.72,30.94,31.47,30.12,29.16,29.78,26.31,24.81,22.0,21.16,21.03,19.69,23.16,23.41,23.19,23.44,21.66,22.06,22.0,24.31,28.38,31.62,34.16,35.41,34.56,30.94,27.03,24.16,18.91,16.47,13.88,11.22,10.84,9.44,10.53,11.81,14.03,14.53,16.84,18.72,20.75,23.66,26.03,27.59,30.31,31.22,33.66,34.75,35.75,37.38,35.78,34.72,32.97,31.0,29.06,27.53,26.28,23.97,23.84,23.81,23.06,23.47,24.91,25.06,26.41,26.19,27.5,30.69,32.22,35.56,37.97,41.09,41.78,44.06,44.5,43.25,42.56,39.84,37.09,33.56,32.0,30.5,30.97,31.19,32.12,33.91,35.25,35.75,39.28,40.31,41.5,43.34,43.44,43.34,41.56,39.56,36.0,32.97,28.44,26.41,24.41,24.31,26.28,27.75,29.53,34.19,36.0,37.41,38.81,38.06,37.03,35.0,33.09,30.91,28.28,24.56,22.59,21.53,22.81,25.5,28.94,33.25,36.38,38.38,39.88,41.41,41.31,42.5,42.56,42.06,42.94,41.94,40.34,38.31,36.09,31.41,28.09,23.56,21.94,21.59,22.53,24.69,27.16,30.78,33.12,35.81,38.88,40.06,40.0,39.94,37.44,35.19,32.62,32.75,31.78,31.16,32.56,33.03,31.31,33.84,31.75,31.56,30.34,29.78,27.38,26.16,26.16,26.75,28.91,30.34,29.41,29.81,29.25,29.44,28.69,29.12,30.53,30.88,30.25,31.06,31.47,30.06,31.56,31.41,31.06,31.06,32.03,32.09,30.19,32.5,32.0,32.06,30.88,28.91,28.22,26.56,24.28,25.06,24.81,25.0,26.81,27.56,29.91,29.72,31.03,30.69,31.25,31.19,31.78,32.88,34.72,35.34,36.81,37.69,36.81,36.19,35.0,32.09,29.31,29.06,26.19,25.16,25.0,24.78,24.56,24.84,24.12,23.84,23.88,21.84,21.84,21.94,21.81,23.19,25.0,26.69,27.78,28.03,25.16,26.19,25.25,23.0,23.59,22.56,21.91,20.56,19.19,20.34,23.66,26.91,32.44,37.75,40.0,41.69,39.84,37.47,34.56,33.38,32.97,31.91,33.12,32.16,30.94,28.72,28.41,25.09,25.31,23.59,23.66,23.91,24.12,25.16,25.97,27.97,27.94,30.06,29.94,29.56,28.53,27.16,27.69,27.56,30.88,32.72,33.44,35.28,35.81,33.44,32.5,29.94,28.41,27.03,25.62,26.62,27.19,27.91,27.0,26.06,25.81,23.66,23.47,24.84,24.91,25.56,25.62,27.16,27.25,27.44,28.56,30.66,31.34,32.34,32.38,31.88,31.16,30.31,31.47,31.59,32.5,33.94,35.81,35.31,36.78,35.62,35.53,34.31,34.16,32.44,32.81,34.5,35.38,37.44,40.06,41.72,42.41,41.06,40.44,39.16,37.69,35.81,34.31,33.97,31.69,31.62,30.75,29.5,28.75,28.19,28.44,28.31,28.88,27.69,28.5,27.88,27.25,27.34,27.5,28.0,27.78,28.03,28.84,30.06,33.0,32.72,34.75,34.5,33.53,34.16,33.16,32.81,34.44,33.81,33.56,33.56,32.25,29.41,31.44,32.44,34.34,37.03,39.19,38.88,34.94,30.5,27.59,23.19,20.91,19.72,19.75,18.12,17.19,17.69,18.06,16.0,15.12,14.91,13.44,14.28,15.19,15.91,18.94,19.56,20.53,21.56,23.66,24.75,26.19,27.47,27.12,27.41,25.62,23.22,20.44,19.91,17.0,16.75,15.31,15.25,14.84,15.59,15.53,16.53,14.94,17.28,17.16,19.19,21.62,24.25,27.0,27.94,29.06,27.19,26.81,24.97,23.44,21.06,19.88,19.34,18.84,19.38,18.28,18.06,17.53,16.12,16.44,15.72,16.84,17.25,17.72,18.69,19.5,19.66,22.16,21.41,23.53,24.12,25.44,27.19,27.66,27.22,27.56,26.56,26.31,25.97,24.62,24.09,24.53,23.53,25.0,25.5,27.84,28.25,28.97,30.16,30.41,30.25,30.41,30.97,29.34,27.62,27.19,26.66,25.19,23.12,24.44,23.78,22.78,22.81,22.5,22.91,21.5,20.5,18.75,20.59,21.06,24.69,30.16,34.19,37.97,38.94,37.19,33.66,29.09,25.06,21.06,19.56,17.84,16.78,17.81,18.12,16.25,16.81,15.75,14.09,13.53,14.09,13.81,16.31,18.06,21.09,23.47,27.12,29.03,30.44,30.62,31.03,27.72,25.28,23.09,19.94,18.53,17.0,16.66,17.25,17.75,16.88,16.12,16.62,14.81,13.47,12.62,11.16,9.16,8.94,9.19,9.28,12.91,14.91,17.62,21.28,21.31,22.59,23.44,21.25,20.19,21.16,21.09,21.91,23.28,24.03,22.53,24.25,24.31,24.25,25.47,25.28,25.03,24.91,26.03,27.91,30.06,32.69,32.81,33.12,31.31,29.12,26.47,26.0,23.62,22.69,22.28,21.5,18.88,16.88,15.47,13.31,12.38,11.16,9.78,7.41,6.5,5.16,4.03,3.69,4.44,5.12,4.66,6.34,7.22,7.88,9.75,10.75,11.12,11.25,10.72,9.75,8.09,7.47,7.66,7.53,8.31,8.91,10.41,10.97,9.62,10.31,10.62,8.75,10.28,11.31,12.53,14.0,14.41,16.59,17.0,17.72,18.84,18.78,17.47,16.66,15.12,13.78,13.19,12.56,11.41,11.03,9.56,9.12,7.66,7.62,6.62,7.59,6.62,8.47,9.25,9.0,8.75,7.44,6.44,4.28,3.5,3.31,3.34,2.0,3.84,4.62,5.03,6.81,7.34,6.66,7.16,6.44,6.06,5.31,5.12,3.34,3.0,2.59,3.19,4.16,5.38,6.53,6.88,5.78,7.72,9.28,9.94,11.81,12.81,12.88,12.34,11.84,9.88,9.0,5.66,5.78,3.12,2.75,2.34,3.84,5.12,6.03,8.12,9.19,9.03,10.06,10.06,9.06,7.44,7.75,4.12,3.84,2.78,4.19,5.41,6.81,40.5,40.62,42.25,41.34,39.53,34.28,32.31,25.88,21.25,18.0,14.06,11.66:17.38,22.0,27.81,30.56,31.69,34.19,32.41,30.5,30.03,27.53,23.94,22.59,21.19,20.38,21.16,22.03,23.03,24.91,24.25,20.78,19.62,17.19,13.41,12.97,12.0,12.91,15.31,18.53,21.22,23.38,26.5,26.78,25.34,23.62,22.19,19.12,18.0,17.72,18.12,18.19,16.34,14.69,13.31,12.5,12.5,11.69,11.03,9.88,7.62,5.16,3.53,2.66,2.0,0.91,2.0,1.59,2.22,2.75,3.59,5.34,4.41,6.69,6.84,7.12,10.28,11.38,10.78,12.56,12.31,12.5,13.78,14.91,15.81,16.66,17.56,15.78,13.78,14.69,11.28,13.66,13.97,14.12,15.56,16.69,16.34,17.75,19.81,20.97,21.53,22.59,21.47,19.59,18.84,17.66,16.62,16.5,16.84,18.09,18.19,20.25,19.28,18.62,19.28,19.06,18.81,19.69,21.41,22.59,23.47,23.75,24.31,24.81,26.41,26.97,28.16,29.22,28.5,28.06,28.72,29.81,32.88,36.41,38.88,40.16,40.72,40.19,38.34,35.72,34.25,30.84,28.66,25.94,23.75,21.31,20.66,20.62,20.62,22.41,21.0,24.12,25.44,28.38,30.62,32.62,35.25,32.81,32.09,28.0,24.44,22.12,20.09,17.94,19.88,20.5,22.97,25.25,27.12,27.25,26.69,23.25,19.72,17.56,13.44,12.12,12.44,11.47,14.94,17.69,20.38,25.5,28.69,30.06,30.72,30.94,31.47,30.12,29.16,29.78,26.31,24.81,22.0,21.16,21.03,19.69,23.16,23.41,23.19,23.44,21.66,22.06,22.0,24.31,28.38,31.62,34.16,35.41,34.56,30.94,27.03,24.16,18.91,16.47,13.88,11.22,10.84,9.44,10.53,11.81,14.03,14.53,16.84,18.72,20.75,23.66,26.03,27.59,30.31,31.22,33.66,34.75,35.75,37.38,35.78,34.72,32.97,31.0,29.06,27.53,26.28,23.97,23.84,23.81,23.06,23.47,24.91,25.06,26.41,26.19,27.5,30.69,32.22,35.56,37.97,41.09,41.78,44.06,44.5,43.25,42.56,39.84,37.09,33.56,32.0,30.5,30.97,31.19,32.12,33.91,35.25,35.75,39.28,40.31,41.5,43.34,43.44,43.34,41.56,39.56,36.0,32.97,28.44,26.41,24.41,24.31,26.28,27.75,29.53,34.19,36.0,37.41,38.81,38.06,37.03,35.0,33.09,30.91,28.28,24.56,22.59,21.53,22.81,25.5,28.94,33.25,36.38,38.38,39.88,41.41,41.31,42.5,42.56,42.06,42.94,41.94,40.34,38.31,36.09,31.41,28.09,23.56,21.94,21.59,22.53,24.69,27.16,30.78,33.12,35.81,38.88,40.06,40.0,39.94,37.44,35.19,32.62,32.75,31.78,31.16,32.56,33.03,31.31,33.84,31.75,31.56,30.34,29.78,27.38,26.16,26.16,26.75,28.91,30.34,29.41,29.81,29.25,29.44,28.69,29.12,30.53,30.88,30.25,31.06,31.47,30.06,31.56,31.41,31.06,31.06,32.03,32.09,30.19,32.5,32.0,32.06,30.88,28.91,28.22,26.56,24.28,25.06,24.81,25.0,26.81,27.56,29.91,29.72,31.03,30.69,31.25,31.19,31.78,32.88,34.72,35.34,36.81,37.69,36.81,36.19,35.0,32.09,29.31,29.06,26.19,25.16,25.0,24.78,24.56,24.84,24.12,23.84,23.88,21.84,21.84,21.94,21.81,23.19,25.0,26.69,27.78,28.03,25.16,26.19,25.25,23.0,23.59,22.56,21.91,20.56,19.19,20.34,23.66,26.91,32.44,37.75,40.0,41.69,39.84,37.47,34.56,33.38,32.97,31.91,33.12,32.16,30.94,28.72,28.41,25.09,25.31,23.59,23.66,23.91,24.12,25.16,25.97,27.97,27.94,30.06,29.94,29.56,28.53,27.16,27.69,27.56,30.88,32.72,33.44,35.28,35.81,33.44,32.5,29.94,28.41,27.03,25.62,26.62,27.19,27.91,27.0,26.06,25.81,23.66,23.47,24.84,24.91,25.56,25.62,27.16,27.25,27.44,28.56,30.66,31.34,32.34,32.38,31.88,31.16,30.31,31.47,31.59,32.5,33.94,35.81,35.31,36.78,35.62,35.53,34.31,34.16,32.44,32.81,34.5,35.38,37.44,40.06,41.72,42.41,41.06,40.44,39.16,37.69,35.81,34.31,33.97,31.69,31.62,30.75,29.5,28.75,28.19,28.44,28.31,28.88,27.69,28.5,27.88,27.25,27.34,27.5,28.0,27.78,28.03,28.84,30.06,33.0,32.72,34.75,34.5,33.53,34.16,33.16,32.81,34.44,33.81,33.56,33.56,32.25,29.41,31.44,32.44,34.34,37.03,39.19,38.88,34.94,30.5,27.59,23.19,20.91,19.72,19.75,18.12,17.19,17.69,18.06,16.0,15.12,14.91,13.44,14.28,15.19,15.91,18.94,19.56,20.53,21.56,23.66,24.75,26.19,27.47,27.12,27.41,25.62,23.22,20.44,19.91,17.0,16.75,15.31,15.25,14.84,15.59,15.53,16.53,14.94,17.28,17.16,19.19,21.62,24.25,27.0,27.94,29.06,27.19,26.81,24.97,23.44,21.06,19.88,19.34,18.84,19.38,18.28,18.06,17.53,16.12,16.44,15.72,16.84,17.25,17.72,18.69,19.5,19.66,22.16,21.41,23.53,24.12,25.44,27.19,27.66,27.22,27.56,26.56,26.31,25.97,24.62,24.09,24.53,23.53,25.0,25.5,27.84,28.25,28.97,30.16,30.41,30.25,30.41,30.97,29.34,27.62,27.19,26.66,25.19,23.12,24.44,23.78,22.78,22.81,22.5,22.91,21.5,20.5,18.75,20.59,21.06,24.69,30.16,34.19,37.97,38.94,37.19,33.66,29.09,25.06,21.06,19.56,17.84,16.78,17.81,18.12,16.25,16.81,15.75,14.09,13.53,14.09,13.81,16.31,18.06,21.09,23.47,27.12,29.03,30.44,30.62,31.03,27.72,25.28,23.09,19.94,18.53,17.0,16.66,17.25,17.75,16.88,16.12,16.62,14.81,13.47,12.62,11.16,9.16,8.94,9.19,9.28,12.91,14.91,17.62,21.28,21.31,22.59,23.44,21.25,20.19,21.16,21.09,21.91,23.28,24.03,22.53,24.25,24.31,24.25,25.47,25.28,25.03,24.91,26.03,27.91,30.06,32.69,32.81,33.12,31.31,29.12,26.47,26.0,23.62,22.69,22.28,21.5,18.88,16.88,15.47,13.31,12.38,11.16,9.78,7.41,6.5,5.16,4.03,3.69,4.44,5.12,4.66,6.34,7.22,7.88,9.75,10.75,11.12,11.25,10.72,9.75,8.09,7.47,7.66,7.53,8.31,8.91,10.41,10.97,9.62,10.31,10.62,8.75,10.28,11.31,12.53,14.0,14.41,16.59,17.0,17.72,18.84,18.78,17.47,16.66,15.12,13.78,13.19,12.56,11.41,11.03,9.56,9.12,7.66,7.62,6.62,7.59,6.62,8.47,9.25,9.0,8.75,7.44,6.44,4.28,3.5,3.31,3.34,2.0,3.84,4.62,5.03,6.81,7.34,6.66,7.16,6.44,6.06,5.31,5.12,3.34,3.0,2.59,3.19,4.16,5.38,6.53,6.88,5.78,7.72,9.28,9.94,11.81,12.81,12.88,12.34,11.84,9.88,9.0,5.66,5.78,3.12,2.75,2.34,3.84,5.12,6.03,8.12,9.19,9.03,10.06,10.06,9.06,7.44,7.75,4.12,3.84,2.78,4.19,5.41,6.81,40.5,40.62,42.25,41.34,39.53,34.28,32.31,25.88,21.25,18.0,14.06,11.66,9.31,9.56,9.62,10.66,14.03,17.44:32.41,30.5,30.03,27.53,23.94,22.59,21.19,20.38,21.16,22.03,23.03,24.91,24.25,20.78,19.62,17.19,13.41,12.97,12.0,12.91,15.31,18.53,21.22,23.38,26.5,26.78,25.34,23.62,22.19,19.12,18.0,17.72,18.12,18.19,16.34,14.69,13.31,12.5,12.5,11.69,11.03,9.88,7.62,5.16,3.53,2.66,2.0,0.91,2.0,1.59,2.22,2.75,3.59,5.34,4.41,6.69,6.84,7.12,10.28,11.38,10.78,12.56,12.31,12.5,13.78,14.91,15.81,16.66,17.56,15.78,13.78,14.69,11.28,13.66,13.97,14.12,15.56,16.69,16.34,17.75,19.81,20.97,21.53,22.59,21.47,19.59,18.84,17.66,16.62,16.5,16.84,18.09,18.19,20.25,19.28,18.62,19.28,19.06,18.81,19.69,21.41,22.59,23.47,23.75,24.31,24.81,26.41,26.97,28.16,29.22,28.5,28.06,28.72,29.81,32.88,36.41,38.88,40.16,40.72,40.19,38.34,35.72,34.25,30.84,28.66,25.94,23.75,21.31,20.66,20.62,20.62,22.41,21.0,24.12,25.44,28.38,30.62,32.62,35.25,32.81,32.09,28.0,24.44,22.12,20.09,17.94,19.88,20.5,22.97,25.25,27.12,27.25,26.69,23.25,19.72,17.56,13.44,12.12,12.44,11.47,14.94,17.69,20.38,25.5,28.69,30.06,30.72,30.94,31.47,30.12,29.16,29.78,26.31,24.81,22.0,21.16,21.03,19.69,23.16,23.41,23.19,23.44,21.66,22.06,22.0,24.31,28.38,31.62,34.16,35.41,34.56,30.94,27.03,24.16,18.91,16.47,13.88,11.22,10.84,9.44,10.53,11.81,14.03,14.53,16.84,18.72,20.75,23.66,26.03,27.59,30.31,31.22,33.66,34.75,35.75,37.38,35.78,34.72,32.97,31.0,29.06,27.53,26.28,23.97,23.84,23.81,23.06,23.47,24.91,25.06,26.41,26.19,27.5,30.69,32.22,35.56,37.97,41.09,41.78,44.06,44.5,43.25,42.56,39.84,37.09,33.56,32.0,30.5,30.97,31.19,32.12,33.91,35.25,35.75,39.28,40.31,41.5,43.34,43.44,43.34,41.56,39.56,36.0,32.97,28.44,26.41,24.41,24.31,26.28,27.75,29.53,34.19,36.0,37.41,38.81,38.06,37.03,35.0,33.09,30.91,28.28,24.56,22.59,21.53,22.81,25.5,28.94,33.25,36.38,38.38,39.88,41.41,41.31,42.5,42.56,42.06,42.94,41.94,40.34,38.31,36.09,31.41,28.09,23.56,21.94,21.59,22.53,24.69,27.16,30.78,33.12,35.81,38.88,40.06,40.0,39.94,37.44,35.19,32.62,32.75,31.78,31.16,32.56,33.03,31.31,33.84,31.75,31.56,30.34,29.78,27.38,26.16,26.16,26.75,28.91,30.34,29.41,29.81,29.25,29.44,28.69,29.12,30.53,30.88,30.25,31.06,31.47,30.06,31.56,31.41,31.06,31.06,32.03,32.09,30.19,32.5,32.0,32.06,30.88,28.91,28.22,26.56,24.28,25.06,24.81,25.0,26.81,27.56,29.91,29.72,31.03,30.69,31.25,31.19,31.78,32.88,34.72,35.34,36.81,37.69,36.81,36.19,35.0,32.09,29.31,29.06,26.19,25.16,25.0,24.78,24.56,24.84,24.12,23.84,23.88,21.84,21.84,21.94,21.81,23.19,25.0,26.69,27.78,28.03,25.16,26.19,25.25,23.0,23.59,22.56,21.91,20.56,19.19,20.34,23.66,26.91,32.44,37.75,40.0,41.69,39.84,37.47,34.56,33.38,32.97,31.91,33.12,32.16,30.94,28.72,28.41,25.09,25.31,23.59,23.66,23.91,24.12,25.16,25.97,27.97,27.94,30.06,29.94,29.56,28.53,27.16,27.69,27.56,30.88,32.72,33.44,35.28,35.81,33.44,32.5,29.94,28.41,27.03,25.62,26.62,27.19,27.91,27.0,26.06,25.81,23.66,23.47,24.84,24.91,25.56,25.62,27.16,27.25,27.44,28.56,30.66,31.34,32.34,32.38,31.88,31.16,30.31,31.47,31.59,32.5,33.94,35.81,35.31,36.78,35.62,35.53,34.31,34.16,32.44,32.81,34.5,35.38,37.44,40.06,41.72,42.41,41.06,40.44,39.16,37.69,35.81,34.31,33.97,31.69,31.62,30.75,29.5,28.75,28.19,28.44,28.31,28.88,27.69,28.5,27.88,27.25,27.34,27.5,28.0,27.78,28.03,28.84,30.06,33.0,32.72,34.75,34.5,33.53,34.16,33.16,32.81,34.44,33.81,33.56,33.56,32.25,29.41,31.44,32.44,34.34,37.03,39.19,38.88,34.94,30.5,27.59,23.19,20.91,19.72,19.75,18.12,17.19,17.69,18.06,16.0,15.12,14.91,13.44,14.28,15.19,15.91,18.94,19.56,20.53,21.56,23.66,24.75,26.19,27.47,27.12,27.41,25.62,23.22,20.44,19.91,17.0,16.75,15.31,15.25,14.84,15.59,15.53,16.53,14.94,17.28,17.16,19.19,21.62,24.25,27.0,27.94,29.06,27.19,26.81,24.97,23.44,21.06,19.88,19.34,18.84,19.38,18.28,18.06,17.53,16.12,16.44,15.72,16.84,17.25,17.72,18.69,19.5,19.66,22.16,21.41,23.53,24.12,25.44,27.19,27.66,27.22,27.56,26.56,26.31,25.97,24.62,24.09,24.53,23.53,25.0,25.5,27.84,28.25,28.97,30.16,30.41,30.25,30.41,30.97,29.34,27.62,27.19,26.66,25.19,23.12,24.44,23.78,22.78,22.81,22.5,22.91,21.5,20.5,18.75,20.59,21.06,24.69,30.16,34.19,37.97,38.94,37.19,33.66,29.09,25.06,21.06,19.56,17.84,16.78,17.81,18.12,16.25,16.81,15.75,14.09,13.53,14.09,13.81,16.31,18.06,21.09,23.47,27.12,29.03,30.44,30.62,31.03,27.72,25.28,23.09,19.94,18.53,17.0,16.66,17.25,17.75,16.88,16.12,16.62,14.81,13.47,12.62,11.16,9.16,8.94,9.19,9.28,12.91,14.91,17.62,21.28,21.31,22.59,23.44,21.25,20.19,21.16,21.09,21.91,23.28,24.03,22.53,24.25,24.31,24.25,25.47,25.28,25.03,24.91,26.03,27.91,30.06,32.69,32.81,33.12,31.31,29.12,26.47,26.0,23.62,22.69,22.28,21.5,18.88,16.88,15.47,13.31,12.38,11.16,9.78,7.41,6.5,5.16,4.03,3.69,4.44,5.12,4.66,6.34,7.22,7.88,9.75,10.75,11.12,11.25,10.72,9.75,8.09,7.47,7.66,7.53,8.31,8.91,10.41,10.97,9.62,10.31,10.62,8.75,10.28,11.31,12.53,14.0,14.41,16.59,17.0,17.72,18.84,18.78,17.47,16.66,15.12,13.78,13.19,12.56,11.41,11.03,9.56,9.12,7.66,7.62,6.62,7.59,6.62,8.47,9.25,9.0,8.75,7.44,6.44,4.28,3.5,3.31,3.34,2.0,3.84,4.62,5.03,6.81,7.34,6.66,7.16,6.44,6.06,5.31,5.12,3.34,3.0,2.59,3.19,4.16,5.38,6.53,6.88,5.78,7.72,9.28,9.94,11.81,12.81,12.88,12.34,11.84,9.88,9.0,5.66,5.78,3.12,2.75,2.34,3.84,5.12,6.03,8.12,9.19,9.03,10.06,10.06,9.06,7.44,7.75,4.12,3.84,2.78,4.19,5.41,6.81,40.5,40.62,42.25,41.34,39.53,34.28,32.31,25.88,21.25,18.0,14.06,11.66,9.31,9.56,9.62,10.66,14.03,17.44,21.53,25.34,28.81,30.31,30.81,30.41:21.19,20.38,21.16,22.03,23.03,24.91,24.25,20.78,19.62,17.19,13.41,12.97,12.0,12.91,15.31,18.53,21.22,23.38,26.5,26.78,25.34,23.62,22.19,19.12,18.0,17.72,18.12,18.19,16.34,14.69,13.31,12.5,12.5,11.69,11.03,9.88,7.62,5.16,3.53,2.66,2.0,0.91,2.0,1.59,2.22,2.75,3.59,5.34,4.41,6.69,6.84,7.12,10.28,11.38,10.78,12.56,12.31,12.5,13.78,14.91,15.81,16.66,17.56,15.78,13.78,14.69,11.28,13.66,13.97,14.12,15.56,16.69,16.34,17.75,19.81,20.97,21.53,22.59,21.47,19.59,18.84,17.66,16.62,16.5,16.84,18.09,18.19,20.25,19.28,18.62,19.28,19.06,18.81,19.69,21.41,22.59,23.47,23.75,24.31,24.81,26.41,26.97,28.16,29.22,28.5,28.06,28.72,29.81,32.88,36.41,38.88,40.16,40.72,40.19,38.34,35.72,34.25,30.84,28.66,25.94,23.75,21.31,20.66,20.62,20.62,22.41,21.0,24.12,25.44,28.38,30.62,32.62,35.25,32.81,32.09,28.0,24.44,22.12,20.09,17.94,19.88,20.5,22.97,25.25,27.12,27.25,26.69,23.25,19.72,17.56,13.44,12.12,12.44,11.47,14.94,17.69,20.38,25.5,28.69,30.06,30.72,30.94,31.47,30.12,29.16,29.78,26.31,24.81,22.0,21.16,21.03,19.69,23.16,23.41,23.19,23.44,21.66,22.06,22.0,24.31,28.38,31.62,34.16,35.41,34.56,30.94,27.03,24.16,18.91,16.47,13.88,11.22,10.84,9.44,10.53,11.81,14.03,14.53,16.84,18.72,20.75,23.66,26.03,27.59,30.31,31.22,33.66,34.75,35.75,37.38,35.78,34.72,32.97,31.0,29.06,27.53,26.28,23.97,23.84,23.81,23.06,23.47,24.91,25.06,26.41,26.19,27.5,30.69,32.22,35.56,37.97,41.09,41.78,44.06,44.5,43.25,42.56,39.84,37.09,33.56,32.0,30.5,30.97,31.19,32.12,33.91,35.25,35.75,39.28,40.31,41.5,43.34,43.44,43.34,41.56,39.56,36.0,32.97,28.44,26.41,24.41,24.31,26.28,27.75,29.53,34.19,36.0,37.41,38.81,38.06,37.03,35.0,33.09,30.91,28.28,24.56,22.59,21.53,22.81,25.5,28.94,33.25,36.38,38.38,39.88,41.41,41.31,42.5,42.56,42.06,42.94,41.94,40.34,38.31,36.09,31.41,28.09,23.56,21.94,21.59,22.53,24.69,27.16,30.78,33.12,35.81,38.88,40.06,40.0,39.94,37.44,35.19,32.62,32.75,31.78,31.16,32.56,33.03,31.31,33.84,31.75,31.56,30.34,29.78,27.38,26.16,26.16,26.75,28.91,30.34,29.41,29.81,29.25,29.44,28.69,29.12,30.53,30.88,30.25,31.06,31.47,30.06,31.56,31.41,31.06,31.06,32.03,32.09,30.19,32.5,32.0,32.06,30.88,28.91,28.22,26.56,24.28,25.06,24.81,25.0,26.81,27.56,29.91,29.72,31.03,30.69,31.25,31.19,31.78,32.88,34.72,35.34,36.81,37.69,36.81,36.19,35.0,32.09,29.31,29.06,26.19,25.16,25.0,24.78,24.56,24.84,24.12,23.84,23.88,21.84,21.84,21.94,21.81,23.19,25.0,26.69,27.78,28.03,25.16,26.19,25.25,23.0,23.59,22.56,21.91,20.56,19.19,20.34,23.66,26.91,32.44,37.75,40.0,41.69,39.84,37.47,34.56,33.38,32.97,31.91,33.12,32.16,30.94,28.72,28.41,25.09,25.31,23.59,23.66,23.91,24.12,25.16,25.97,27.97,27.94,30.06,29.94,29.56,28.53,27.16,27.69,27.56,30.88,32.72,33.44,35.28,35.81,33.44,32.5,29.94,28.41,27.03,25.62,26.62,27.19,27.91,27.0,26.06,25.81,23.66,23.47,24.84,24.91,25.56,25.62,27.16,27.25,27.44,28.56,30.66,31.34,32.34,32.38,31.88,31.16,30.31,31.47,31.59,32.5,33.94,35.81,35.31,36.78,35.62,35.53,34.31,34.16,32.44,32.81,34.5,35.38,37.44,40.06,41.72,42.41,41.06,40.44,39.16,37.69,35.81,34.31,33.97,31.69,31.62,30.75,29.5,28.75,28.19,28.44,28.31,28.88,27.69,28.5,27.88,27.25,27.34,27.5,28.0,27.78,28.03,28.84,30.06,33.0,32.72,34.75,34.5,33.53,34.16,33.16,32.81,34.44,33.81,33.56,33.56,32.25,29.41,31.44,32.44,34.34,37.03,39.19,38.88,34.94,30.5,27.59,23.19,20.91,19.72,19.75,18.12,17.19,17.69,18.06,16.0,15.12,14.91,13.44,14.28,15.19,15.91,18.94,19.56,20.53,21.56,23.66,24.75,26.19,27.47,27.12,27.41,25.62,23.22,20.44,19.91,17.0,16.75,15.31,15.25,14.84,15.59,15.53,16.53,14.94,17.28,17.16,19.19,21.62,24.25,27.0,27.94,29.06,27.19,26.81,24.97,23.44,21.06,19.88,19.34,18.84,19.38,18.28,18.06,17.53,16.12,16.44,15.72,16.84,17.25,17.72,18.69,19.5,19.66,22.16,21.41,23.53,24.12,25.44,27.19,27.66,27.22,27.56,26.56,26.31,25.97,24.62,24.09,24.53,23.53,25.0,25.5,27.84,28.25,28.97,30.16,30.41,30.25,30.41,30.97,29.34,27.62,27.19,26.66,25.19,23.12,24.44,23.78,22.78,22.81,22.5,22.91,21.5,20.5,18.75,20.59,21.06,24.69,30.16,34.19,37.97,38.94,37.19,33.66,29.09,25.06,21.06,19.56,17.84,16.78,17.81,18.12,16.25,16.81,15.75,14.09,13.53,14.09,13.81,16.31,18.06,21.09,23.47,27.12,29.03,30.44,30.62,31.03,27.72,25.28,23.09,19.94,18.53,17.0,16.66,17.25,17.75,16.88,16.12,16.62,14.81,13.47,12.62,11.16,9.16,8.94,9.19,9.28,12.91,14.91,17.62,21.28,21.31,22.59,23.44,21.25,20.19,21.16,21.09,21.91,23.28,24.03,22.53,24.25,24.31,24.25,25.47,25.28,25.03,24.91,26.03,27.91,30.06,32.69,32.81,33.12,31.31,29.12,26.47,26.0,23.62,22.69,22.28,21.5,18.88,16.88,15.47,13.31,12.38,11.16,9.78,7.41,6.5,5.16,4.03,3.69,4.44,5.12,4.66,6.34,7.22,7.88,9.75,10.75,11.12,11.25,10.72,9.75,8.09,7.47,7.66,7.53,8.31,8.91,10.41,10.97,9.62,10.31,10.62,8.75,10.28,11.31,12.53,14.0,14.41,16.59,17.0,17.72,18.84,18.78,17.47,16.66,15.12,13.78,13.19,12.56,11.41,11.03,9.56,9.12,7.66,7.62,6.62,7.59,6.62,8.47,9.25,9.0,8.75,7.44,6.44,4.28,3.5,3.31,3.34,2.0,3.84,4.62,5.03,6.81,7.34,6.66,7.16,6.44,6.06,5.31,5.12,3.34,3.0,2.59,3.19,4.16,5.38,6.53,6.88,5.78,7.72,9.28,9.94,11.81,12.81,12.88,12.34,11.84,9.88,9.0,5.66,5.78,3.12,2.75,2.34,3.84,5.12,6.03,8.12,9.19,9.03,10.06,10.06,9.06,7.44,7.75,4.12,3.84,2.78,4.19,5.41,6.81,40.5,40.62,42.25,41.34,39.53,34.28,32.31,25.88,21.25,18.0,14.06,11.66,9.31,9.56,9.62,10.66,14.03,17.44,21.53,25.34,28.81,30.31,30.81,30.41,28.5,25.62,23.16,20.34,16.5,15.44:negativity
36.12,38.28,41.19,44.06,46.19,46.97,47.25,46.88,44.5,43.03,41.84,41.09,40.03,39.75,39.44,39.25,39.44,39.75,40.25,42.09,44.44,47.03,51.12,54.28,56.5,59.16,60.22,60.19,58.16,55.62,51.41,46.94,42.78,39.59,37.59,36.97,35.75,36.75,38.56,40.03,41.84,44.69,47.09,48.28,50.56,51.88,53.31,53.56,54.91,55.44,54.88,55.53,55.03,55.5,54.91,54.06,52.97,51.44,48.66,45.91,43.16,40.28,37.0,34.56,34.03,33.59,34.12,36.44,36.97,38.12,38.75,38.28,37.56,37.91,37.47,37.97,38.31,38.28,38.62,37.94,36.12,35.31,33.66,33.03,33.22,33.16,33.91,35.16,35.81,36.81,37.84,39.94,41.53,43.31,46.5,49.06,49.94,50.84,50.88,49.31,47.53,45.16,43.34,41.25,39.69,38.56,38.31,36.69,35.0,34.72,33.94,34.88,35.47,36.44,38.97,40.12,40.44,41.91,43.0,44.69,47.31,48.25,50.94,52.59,52.66,53.34,52.91,53.12,52.91,52.5,51.81,51.0,50.16,49.66,49.66,50.25,52.88,55.94,57.34,60.38,63.12,65.5,67.31,69.25,71.06,72.34,72.28,71.81,71.81,69.69,67.41,62.81,58.5,53.41,49.62,46.44,44.66,45.31,46.16,46.84,47.53,49.81,49.56,49.72,49.19,48.31,47.16,46.59,46.5,45.91,46.06,46.34,45.16,44.81,45.03,47.53,49.66,51.72,55.0,55.31,54.72,53.53,51.84,50.19,48.75,48.06,48.91,49.91,51.66,54.69,57.44,59.94,61.59,61.47,60.88,59.66,58.06,55.16,52.41,50.28,47.88,45.97,45.81,46.75,47.69,49.28,49.25,48.44,47.19,46.97,44.31,44.41,44.28,43.94,44.0,45.34,44.91,45.59,45.47,46.66,46.22,46.81,46.88,45.16,43.03,41.66,38.56,36.88,35.69,35.16,33.97,33.62,33.94,33.72,34.25,35.66,36.91,40.16,41.31,44.91,47.5,49.62,51.34,53.69,55.06,57.53,58.0,58.91,58.16,54.84,51.25,46.88,41.69,37.03,32.97,30.62,28.31,29.0,31.38,34.34,38.5,42.34,46.81,49.56,51.34,51.59,51.25,48.66,46.69,42.62,40.06,36.16,34.06,31.38,29.62,28.31,27.5,25.72,23.78,22.28,21.88,21.06,22.12,23.44,25.78,28.06,31.0,32.53,35.12,37.22,36.69,37.5,37.19,35.03,34.28,33.0,33.66,35.5,39.44,44.94,49.94,54.31,55.62,55.31,52.66,48.34,44.28,41.09,39.06,36.78,37.5,38.97,40.06,43.38,46.06,46.88,46.53,45.09,42.12,39.12,36.09,33.19,32.03,32.03,32.97,35.16,37.53,39.38,40.81,41.75,41.94,42.28,42.38,41.41,41.69,42.12,42.28,42.91,43.0,44.44,42.81,39.88,40.41,39.06,39.06,39.47,40.06,40.91,40.91,41.22,41.81,43.47,45.19,46.25,46.62,46.16,46.56,43.78,42.44,40.78,39.06,38.97,38.94,40.22,41.28,43.03,44.88,45.69,45.75,46.25,44.28,43.25,40.94,39.66,37.28,36.25,35.78,36.5,36.81,38.62,41.38,43.16,45.16,46.69,47.66,48.03,47.75,46.94,45.22,44.53,42.25,40.59,37.22,34.72,31.59,28.66,25.5,23.75,22.41,20.69,21.44,21.81,23.31,25.41,27.53,30.03,32.34,33.75,35.03,35.31,35.31,35.91,34.12,32.31,29.69,25.44,22.44,19.31,17.59,16.88,17.31,17.62,19.84,20.88,23.09,24.72,25.38,26.78,27.56,28.06,28.06,28.78,29.78,30.53,31.31,30.97,32.03,30.84,28.78,27.75,25.44,23.53,21.44,20.5,22.16,25.0,28.81,33.56,38.88,42.19,43.91,45.84,47.19,47.31,47.66,47.22,47.41,46.75,47.44,47.72,48.81,49.19,50.5,48.94,48.19,46.38,44.38,42.09,40.66,38.53,36.06,34.25,32.88,31.19,30.62,30.06,30.22,30.66,31.94,34.16,36.41,39.0,42.34,44.19,45.19,46.75,47.0,47.69,46.5,46.56,46.78,45.69,44.12,43.31,41.69,40.28,38.81,37.44,35.09,32.84,28.31,24.78,19.94,17.81,15.41,15.81,16.91,20.28,22.66,25.34,27.94,29.38,31.06,32.25,33.0,34.09,34.16,34.75,35.41,37.38,38.78,40.66,41.59,40.84,39.47,37.19,34.56,34.0,33.66,36.38,39.69,42.12,45.16,46.94,47.0,47.0,44.78,43.25,41.94,39.69,39.31,39.09,39.06,39.97,40.91,42.12,42.28,43.59,44.44,46.81,47.19,48.12,47.53,46.66,45.62,44.25,42.66,41.31,39.06,36.16,33.41,31.44,30.22,29.78,30.31,31.06,32.88,34.84,36.31,36.84,38.47,37.88,38.56,38.94,38.19,38.06,38.03,36.88,37.56,36.34,35.72,35.94,34.97,35.28,35.03,36.16,37.03,36.78,37.12,37.22,37.31,37.62,38.09,38.72,39.75,40.59,40.78,40.94,40.69,40.44,40.0,39.91,40.75,41.19,40.72,42.12,42.56,42.0,42.19,40.38,39.75,38.69,37.56,38.31,38.44,37.97,38.38,37.91,36.69,35.78,35.44,34.75,34.44,34.25,35.03,36.72,40.03,42.81,45.91,48.56,48.88,49.97,48.12,46.34,46.34,43.81,42.22,41.41,39.31,36.06,33.34,30.62,28.19,27.19,25.72,25.19,25.78,26.09,27.22,29.12,30.97,33.78,35.59,36.19,38.12,38.25,38.66,36.81,36.91,34.91,31.62,28.53,26.5,23.81,22.0,20.66,20.25,19.41,19.03,19.72,20.84,22.31,24.56,26.03,28.06,29.34,30.34,31.94,31.59,31.44,30.56,29.56,28.28,28.72,27.53,29.12,29.69,31.69,32.94,34.81,34.69,33.94,31.25,28.41,24.75,22.12,20.66,20.53,20.41,21.66,24.31,26.5,28.41,30.97,31.59,32.69,32.31,30.75,28.5,25.56,21.34,18.12,15.19,13.12,14.44,15.66,17.97,20.16,22.69,23.53,26.09,26.91,29.5,32.16,35.75,38.81,42.06,45.81,47.0,50.12,50.62,48.88,45.31,40.88,34.91,29.41,24.94,21.69,19.75,19.06,20.25,21.62,24.31,27.28,30.84,34.0,37.19,40.31,42.53,44.38,44.0,44.03,42.75,40.06,37.66,35.38,32.28,29.31,26.59,23.28,20.16,18.88,18.62,19.72,21.12,23.22,23.0,21.5,18.72,13.97,9.69,30.44,18.5,28.81,28.03,21.56,16.72,15.09,15.31,15.75,16.28,16.28,15.69,15.19,15.5,15.16,14.44,13.94,13.66,13.72,14.19,15.91,17.28,20.31,21.88,23.53,25.16,26.16,27.16,26.78,26.97,27.03,26.0,69.47,98.69,136.56,128.38,130.56,111.38,77.41,48.69,32.19,25.0,23.34,23.75,24.69,26.03,25.97,24.53,22.84,20.28,19.16,17.03,16.5,16.59,16.59,17.84,17.72,19.38,20.53,20.34,21.66,21.94,22.31,22.91,23.75,24.12,24.69,24.81,30.31,51.78,88.38,136.19,175.06,144.59,133.28,101.25,62.41,33.62,17.44,10.59,8.5,8.94,9.34,9.91,10.12,10.59,10.41,9.53,9.03,9.47,7.81,55.0,80.97,111.81,118.28,145.0,133.56,114.56,80.91,51.0,32.91,24.78,23.0,22.19,22.28,21.97,20.59,19.59,18.31,17.31,17.25,18.5,19.31,19.69,20.16,19.56,18.97,18.12,16.78,14.94,13.81,11.91,10.38,9.19,8.75:47.25,46.88,44.5,43.03,41.84,41.09,40.03,39.75,39.44,39.25,39.44,39.75,40.25,42.09,44.44,47.03,51.12,54.28,56.5,59.16,60.22,60.19,58.16,55.62,51.41,46.94,42.78,39.59,37.59,36.97,35.75,36.75,38.56,40.03,41.84,44.69,47.09,48.28,50.56,51.88,53.31,53.56,54.91,55.44,54.88,55.53,55.03,55.5,54.91,54.06,52.97,51.44,48.66,45.91,43.16,40.28,37.0,34.56,34.03,33.59,34.12,36.44,36.97,38.12,38.75,38.28,37.56,37.91,37.47,37.97,38.31,38.28,38.62,37.94,36.12,35.31,33.66,33.03,33.22,33.16,33.91,35.16,35.81,36.81,37.84,39.94,41.53,43.31,46.5,49.06,49.94,50.84,50.88,49.31,47.53,45.16,43.34,41.25,39.69,38.56,38.31,36.69,35.0,34.72,33.94,34.88,35.47,36.44,38.97,40.12,40.44,41.91,43.0,44.69,47.31,48.25,50.94,52.59,52.66,53.34,52.91,53.12,52.91,52.5,51.81,51.0,50.16,49.66,49.66,50.25,52.88,55.94,57.34,60.38,63.12,65.5,67.31,69.25,71.06,72.34,72.28,71.81,71.81,69.69,67.41,62.81,58.5,53.41,49.62,46.44,44.66,45.31,46.16,46.84,47.53,49.81,49.56,49.72,49.19,48.31,47.16,46.59,46.5,45.91,46.06,46.34,45.16,44.81,45.03,47.53,49.66,51.72,55.0,55.31,54.72,53.53,51.84,50.19,48.75,48.06,48.91,49.91,51.66,54.69,57.44,59.94,61.59,61.47,60.88,59.66,58.06,55.16,52.41,50.28,47.88,45.97,45.81,46.75,47.69,49.28,49.25,48.44,47.19,46.97,44.31,44.41,44.28,43.94,44.0,45.34,44.91,45.59,45.47,46.66,46.22,46.81,46.88,45.16,43.03,41.66,38.56,36.88,35.69,35.16,33.97,33.62,33.94,33.72,34.25,35.66,36.91,40.16,41.31,44.91,47.5,49.62,51.34,53.69,55.06,57.53,58.0,58.91,58.16,54.84,51.25,46.88,41.69,37.03,32.97,30.62,28.31,29.0,31.38,34.34,38.5,42.34,46.81,49.56,51.34,51.59,51.25,48.66,46.69,42.62,40.06,36.16,34.06,31.38,29.62,28.31,27.5,25.72,23.78,22.28,21.88,21.06,22.12,23.44,25.78,28.06,31.0,32.53,35.12,37.22,36.69,37.5,37.19,35.03,34.28,33.0,33.66,35.5,39.44,44.94,49.94,54.31,55.62,55.31,52.66,48.34,44.28,41.09,39.06,36.78,37.5,38.97,40.06,43.38,46.06,46.88,46.53,45.09,42.12,39.12,36.09,33.19,32.03,32.03,32.97,35.16,37.53,39.38,40.81,41.75,41.94,42.28,42.38,41.41,41.69,42.12,42.28,42.91,43.0,44.44,42.81,39.88,40.41,39.06,39.06,39.47,40.06,40.91,40.91,41.22,41.81,43.47,45.19,46.25,46.62,46.16,46.56,43.78,42.44,40.78,39.06,38.97,38.94,40.22,41.28,43.03,44.88,45.69,45.75,46.25,44.28,43.25,40.94,39.66,37.28,36.25,35.78,36.5,36.81,38.62,41.38,43.16,45.16,46.69,47.66,48.03,47.75,46.94,45.22,44.53,42.25,40.59,37.22,34.72,31.59,28.66,25.5,23.75,22.41,20.69,21.44,21.81,23.31,25.41,27.53,30.03,32.34,33.75,35.03,35.31,35.31,35.91,34.12,32.31,29.69,25.44,22.44,19.31,17.59,16.88,17.31,17.62,19.84,20.88,23.09,24.72,25.38,26.78,27.56,28.06,28.06,28.78,29.78,30.53,31.31,30.97,32.03,30.84,28.78,27.75,25.44,23.53,21.44,20.5,22.16,25.0,28.81,33.56,38.88,42.19,43.91,45.84,47.19,47.31,47.66,47.22,47.41,46.75,47.44,47.72,48.81,49.19,50.5,48.94,48.19,46.38,44.38,42.09,40.66,38.53,36.06,34.25,32.88,31.19,30.62,30.06,30.22,30.66,31.94,34.16,36.41,39.0,42.34,44.19,45.19,46.75,47.0,47.69,46.5,46.56,46.78,45.69,44.12,43.31,41.69,40.28,38.81,37.44,35.09,32.84,28.31,24.78,19.94,17.81,15.41,15.81,16.91,20.28,22.66,25.34,27.94,29.38,31.06,32.25,33.0,34.09,34.16,34.75,35.41,37.38,38.78,40.66,41.59,40.84,39.47,37.19,34.56,34.0,33.66,36.38,39.69,42.12,45.16,46.94,47.0,47.0,44.78,43.25,41.94,39.69,39.31,39.09,39.06,39.97,40.91,42.12,42.28,43.59,44.44,46.81,47.19,48.12,47.53,46.66,45.62,44.25,42.66,41.31,39.06,36.16,33.41,31.44,30.22,29.78,30.31,31.06,32.88,34.84,36.31,36.84,38.47,37.88,38.56,38.94,38.19,38.06,38.03,36.88,37.56,36.34,35.72,35.94,34.97,35.28,35.03,36.16,37.03,36.78,37.12,37.22,37.31,37.62,38.09,38.72,39.75,40.59,40.78,40.94,40.69,40.44,40.0,39.91,40.75,41.19,40.72,42.12,42.56,42.0,42.19,40.38,39.75,38.69,37.56,38.31,38.44,37.97,38.38,37.91,36.69,35.78,35.44,34.75,34.44,34.25,35.03,36.72,40.03,42.81,45.91,48.56,48.88,49.97,48.12,46.34,46.34,43.81,42.22,41.41,39.31,36.06,33.34,30.62,28.19,27.19,25.72,25.19,25.78,26.09,27.22,29.12,30.97,33.78,35.59,36.19,38.12,38.25,38.66,36.81,36.91,34.91,31.62,28.53,26.5,23.81,22.0,20.66,20.25,19.41,19.03,19.72,20.84,22.31,24.56,26.03,28.06,29.34,30.34,31.94,31.59,31.44,30.56,29.56,28.28,28.72,27.53,29.12,29.69,31.69,32.94,34.81,34.69,33.94,31.25,28.41,24.75,22.12,20.66,20.53,20.41,21.66,24.31,26.5,28.41,30.97,31.59,32.69,32.31,30.75,28.5,25.56,21.34,18.12,15.19,13.12,14.44,15.66,17.97,20.16,22.69,23.53,26.09,26.91,29.5,32.16,35.75,38.81,42.06,45.81,47.0,50.12,50.62,48.88,45.31,40.88,34.91,29.41,24.94,21.69,19.75,19.06,20.25,21.62,24.31,27.28,30.84,34.0,37.19,40.31,42.53,44.38,44.0,44.03,42.75,40.06,37.66,35.38,32.28,29.31,26.59,23.28,20.16,18.88,18.62,19.72,21.12,23.22,23.0,21.5,18.72,13.97,9.69,30.44,18.5,28.81,28.03,21.56,16.72,15.09,15.31,15.75,16.28,16.28,15.69,15.19,15.5,15.16,14.44,13.94,13.66,13.72,14.19,15.91,17.28,20.31,21.88,23.53,25.16,26.16,27.16,26.78,26.97,27.03,26.0,69.47,98.69,136.56,128.38,130.56,111.38,77.41,48.69,32.19,25.0,23.34,23.75,24.69,26.03,25.97,24.53,22.84,20.28,19.16,17.03,16.5,16.59,16.59,17.84,17.72,19.38,20.53,20.34,21.66,21.94,22.31,22.91,23.75,24.12,24.69,24.81,30.31,51.78,88.38,136.19,175.06,144.59,133.28,101.25,62.41,33.62,17.44,10.59,8.5,8.94,9.34,9.91,10.12,10.59,10.41,9.53,9.03,9.47,7.81,55.0,80.97,111.81,118.28,145.0,133.56,114.56,80.91,51.0,32.91,24.78,23.0,22.19,22.28,21.97,20.59,19.59,18.31,17.31,17.25,18.5,19.31,19.69,20.16,19.56,18.97,18.12,16.78,14.94,13.81,11.91,10.38,9.19,8.75,40.0,42.69,47.06,50.31,54.19,55.72:40.03,39.75,39.44,39.25,39.44,39.75,40.25,42.09,44.44,47.03,51.12,54.28,56.5,59.16,60.22,60.19,58.16,55.62,51.41,46.94,42.78,39.59,37.59,36.97,35.75,36.75,38.56,40.03,41.84,44.69,47.09,48.28,50.56,51.88,53.31,53.56,54.91,55.44,54.88,55.53,55.03,55.5,54.91,54.06,52.97,51.44,48.66,45.91,43.16,40.28,37.0,34.56,34.03,33.59,34.12,36.44,36.97,38.12,38.75,38.28,37.56,37.91,37.47,37.97,38.31,38.28,38.62,37.94,36.12,35.31,33.66,33.03,33.22,33.16,33.91,35.16,35.81,36.81,37.84,39.94,41.53,43.31,46.5,49.06,49.94,50.84,50.88,49.31,47.53,45.16,43.34,41.25,39.69,38.56,38.31,36.69,35.0,34.72,33.94,34.88,35.47,36.44,38.97,40.12,40.44,41.91,43.0,44.69,47.31,48.25,50.94,52.59,52.66,53.34,52.91,53.12,52.91,52.5,51.81,51.0,50.16,49.66,49.66,50.25,52.88,55.94,57.34,60.38,63.12,65.5,67.31,69.25,71.06,72.34,72.28,71.81,71.81,69.69,67.41,62.81,58.5,53.41,49.62,46.44,44.66,45.31,46.16,46.84,47.53,49.81,49.56,49.72,49.19,48.31,47.16,46.59,46.5,45.91,46.06,46.34,45.16,44.81,45.03,47.53,49.66,51.72,55.0,55.31,54.72,53.53,51.84,50.19,48.75,48.06,48.91,49.91,51.66,54.69,57.44,59.94,61.59,61.47,60.88,59.66,58.06,55.16,52.41,50.28,47.88,45.97,45.81,46.75,47.69,49.28,49.25,48.44,47.19,46.97,44.31,44.41,44.28,43.94,44.0,45.34,44.91,45.59,45.47,46.66,46.22,46.81,46.88,45.16,43.03,41.66,38.56,36.88,35.69,35.16,33.97,33.62,33.94,33.72,34.25,35.66,36.91,40.16,41.31,44.91,47.5,49.62,51.34,53.69,55.06,57.53,58.0,58.91,58.16,54.84,51.25,46.88,41.69,37.03,32.97,30.62,28.31,29.0,31.38,34.34,38.5,42.34,46.81,49.56,51.34,51.59,51.25,48.66,46.69,42.62,40.06,36.16,34.06,31.38,29.62,28.31,27.5,25.72,23.78,22.28,21.88,21.06,22.12,23.44,25.78,28.06,31.0,32.53,35.12,37.22,36.69,37.5,37.19,35.03,34.28,33.0,33.66,35.5,39.44,44.94,49.94,54.31,55.62,55.31,52.66,48.34,44.28,41.09,39.06,36.78,37.5,38.97,40.06,43.38,46.06,46.88,46.53,45.09,42.12,39.12,36.09,33.19,32.03,32.03,32.97,35.16,37.53,39.38,40.81,41.75,41.94,42.28,42.38,41.41,41.69,42.12,42.28,42.91,43.0,44.44,42.81,39.88,40.41,39.06,39.06,39.47,40.06,40.91,40.91,41.22,41.81,43.47,45.19,46.25,46.62,46.16,46.56,43.78,42.44,40.78,39.06,38.97,38.94,40.22,41.28,43.03,44.88,45.69,45.75,46.25,44.28,43.25,40.94,39.66,37.28,36.25,35.78,36.5,36.81,38.62,41.38,43.16,45.16,46.69,47.66,48.03,47.75,46.94,45.22,44.53,42.25,40.59,37.22,34.72,31.59,28.66,25.5,23.75,22.41,20.69,21.44,21.81,23.31,25.41,27.53,30.03,32.34,33.75,35.03,35.31,35.31,35.91,34.12,32.31,29.69,25.44,22.44,19.31,17.59,16.88,17.31,17.62,19.84,20.88,23.09,24.72,25.38,26.78,27.56,28.06,28.06,28.78,29.78,30.53,31.31,30.97,32.03,30.84,28.78,27.75,25.44,23.53,21.44,20.5,22.16,25.0,28.81,33.56,38.88,42.19,43.91,45.84,47.19,47.31,47.66,47.22,47.41,46.75,47.44,47.72,48.81,49.19,50.5,48.94,48.19,46.38,44.38,42.09,40.66,38.53,36.06,34.25,32.88,31.19,30.62,30.06,30.22,30.66,31.94,34.16,36.41,39.0,42.34,44.19,45.19,46.75,47.0,47.69,46.5,46.56,46.78,45.69,44.12,43.31,41.69,40.28,38.81,37.44,35.09,32.84,28.31,24.78,19.94,17.81,15.41,15.81,16.91,20.28,22.66,25.34,27.94,29.38,31.06,32.25,33.0,34.09,34.16,34.75,35.41,37.38,38.78,40.66,41.59,40.84,39.47,37.19,34.56,34.0,33.66,36.38,39.69,42.12,45.16,46.94,47.0,47.0,44.78,43.25,41.94,39.69,39.31,39.09,39.06,39.97,40.91,42.12,42.28,43.59,44.44,46.81,47.19,48.12,47.53,46.66,45.62,44.25,42.66,41.31,39.06,36.16,33.41,31.44,30.22,29.78,30.31,31.06,32.88,34.84,36.31,36.84,38.47,37.88,38.56,38.94,38.19,38.06,38.03,36.88,37.56,36.34,35.72,35.94,34.97,35.28,35.03,36.16,37.03,36.78,37.12,37.22,37.31,37.62,38.09,38.72,39.75,40.59,40.78,40.94,40.69,40.44,40.0,39.91,40.75,41.19,40.72,42.12,42.56,42.0,42.19,40.38,39.75,38.69,37.56,38.31,38.44,37.97,38.38,37.91,36.69,35.78,35.44,34.75,34.44,34.25,35.03,36.72,40.03,42.81,45.91,48.56,48.88,49.97,48.12,46.34,46.34,43.81,42.22,41.41,39.31,36.06,33.34,30.62,28.19,27.19,25.72,25.19,25.78,26.09,27.22,29.12,30.97,33.78,35.59,36.19,38.12,38.25,38.66,36.81,36.91,34.91,31.62,28.53,26.5,23.81,22.0,20.66,20.25,19.41,19.03,19.72,20.84,22.31,24.56,26.03,28.06,29.34,30.34,31.94,31.59,31.44,30.56,29.56,28.28,28.72,27.53,29.12,29.69,31.69,32.94,34.81,34.69,33.94,31.25,28.41,24.75,22.12,20.66,20.53,20.41,21.66,24.31,26.5,28.41,30.97,31.59,32.69,32.31,30.75,28.5,25.56,21.34,18.12,15.19,13.12,14.44,15.66,17.97,20.16,22.69,23.53,26.09,26.91,29.5,32.16,35.75,38.81,42.06,45.81,47.0,50.12,50.62,48.88,45.31,40.88,34.91,29.41,24.94,21.69,19.75,19.06,20.25,21.62,24.31,27.28,30.84,34.0,37.19,40.31,42.53,44.38,44.0,44.03,42.75,40.06,37.66,35.38,32.28,29.31,26.59,23.28,20.16,18.88,18.62,19.72,21.12,23.22,23.0,21.5,18.72,13.97,9.69,30.44,18.5,28.81,28.03,21.56,16.72,15.09,15.31,15.75,16.28,16.28,15.69,15.19,15.5,15.16,14.44,13.94,13.66,13.72,14.19,15.91,17.28,20.31,21.88,23.53,25.16,26.16,27.16,26.78,26.97,27.03,26.0,69.47,98.69,136.56,128.38,130.56,111.38,77.41,48.69,32.19,25.0,23.34,23.75,24.69,26.03,25.97,24.53,22.84,20.28,19.16,17.03,16.5,16.59,16.59,17.84,17.72,19.38,20.53,20.34,21.66,21.94,22.31,22.91,23.75,24.12,24.69,24.81,30.31,51.78,88.38,136.19,175.06,144.59,133.28,101.25,62.41,33.62,17.44,10.59,8.5,8.94,9.34,9.91,10.12,10.59,10.41,9.53,9.03,9.47,7.81,55.0,80.97,111.81,118.28,145.0,133.56,114.56,80.91,51.0,32.91,24.78,23.0,22.19,22.28,21.97,20.59,19.59,18.31,17.31,17.25,18.5,19.31,19.69,20.16,19.56,18.97,18.12,16.78,14.94,13.81,11.91,10.38,9.19,8.75,40.0,42.69,47.06,50.31,54.19,55.72,56.91,56.81,54.88,52.0,49.66,47.5:40.25,42.09,44.44,47.03,51.12,54.28,56.5,59.16,60.22,60.19,58.16,55.62,51.41,46.94,42.78,39.59,37.59,36.97,35.75,36.75,38.56,40.03,41.84,44.69,47.09,48.28,50.56,51.88,53.31,53.56,54.91,55.44,54.88,55.53,55.03,55.5,54.91,54.06,52.97,51.44,48.66,45.91,43.16,40.28,37.0,34.56,34.03,33.59,34.12,36.44,36.97,38.12,38.75,38.28,37.56,37.91,37.47,37.97,38.31,38.28,38.62,37.94,36.12,35.31,33.66,33.03,33.22,33.16,33.91,35.16,35.81,36.81,37.84,39.94,41.53,43.31,46.5,49.06,49.94,50.84,50.88,49.31,47.53,45.16,43.34,41.25,39.69,38.56,38.31,36.69,35.0,34.72,33.94,34.88,35.47,36.44,38.97,40.12,40.44,41.91,43.0,44.69,47.31,48.25,50.94,52.59,52.66,53.34,52.91,53.12,52.91,52.5,51.81,51.0,50.16,49.66,49.66,50.25,52.88,55.94,57.34,60.38,63.12,65.5,67.31,69.25,71.06,72.34,72.28,71.81,71.81,69.69,67.41,62.81,58.5,53.41,49.62,46.44,44.66,45.31,46.16,46.84,47.53,49.81,49.56,49.72,49.19,48.31,47.16,46.59,46.5,45.91,46.06,46.34,45.16,44.81,45.03,47.53,49.66,51.72,55.0,55.31,54.72,53.53,51.84,50.19,48.75,48.06,48.91,49.91,51.66,54.69,57.44,59.94,61.59,61.47,60.88,59.66,58.06,55.16,52.41,50.28,47.88,45.97,45.81,46.75,47.69,49.28,49.25,48.44,47.19,46.97,44.31,44.41,44.28,43.94,44.0,45.34,44.91,45.59,45.47,46.66,46.22,46.81,46.88,45.16,43.03,41.66,38.56,36.88,35.69,35.16,33.97,33.62,33.94,33.72,34.25,35.66,36.91,40.16,41.31,44.91,47.5,49.62,51.34,53.69,55.06,57.53,58.0,58.91,58.16,54.84,51.25,46.88,41.69,37.03,32.97,30.62,28.31,29.0,31.38,34.34,38.5,42.34,46.81,49.56,51.34,51.59,51.25,48.66,46.69,42.62,40.06,36.16,34.06,31.38,29.62,28.31,27.5,25.72,23.78,22.28,21.88,21.06,22.12,23.44,25.78,28.06,31.0,32.53,35.12,37.22,36.69,37.5,37.19,35.03,34.28,33.0,33.66,35.5,39.44,44.94,49.94,54.31,55.62,55.31,52.66,48.34,44.28,41.09,39.06,36.78,37.5,38.97,40.06,43.38,46.06,46.88,46.53,45.09,42.12,39.12,36.09,33.19,32.03,32.03,32.97,35.16,37.53,39.38,40.81,41.75,41.94,42.28,42.38,41.41,41.69,42.12,42.28,42.91,43.0,44.44,42.81,39.88,40.41,39.06,39.06,39.47,40.06,40.91,40.91,41.22,41.81,43.47,45.19,46.25,46.62,46.16,46.56,43.78,42.44,40.78,39.06,38.97,38.94,40.22,41.28,43.03,44.88,45.69,45.75,46.25,44.28,43.25,40.94,39.66,37.28,36.25,35.78,36.5,36.81,38.62,41.38,43.16,45.16,46.69,47.66,48.03,47.75,46.94,45.22,44.53,42.25,40.59,37.22,34.72,31.59,28.66,25.5,23.75,22.41,20.69,21.44,21.81,23.31,25.41,27.53,30.03,32.34,33.75,35.03,35.31,35.31,35.91,34.12,32.31,29.69,25.44,22.44,19.31,17.59,16.88,17.31,17.62,19.84,20.88,23.09,24.72,25.38,26.78,27.56,28.06,28.06,28.78,29.78,30.53,31.31,30.97,32.03,30.84,28.78,27.75,25.44,23.53,21.44,20.5,22.16,25.0,28.81,33.56,38.88,42.19,43.91,45.84,47.19,47.31,47.66,47.22,47.41,46.75,47.44,47.72,48.81,49.19,50.5,48.94,48.19,46.38,44.38,42.09,40.66,38.53,36.06,34.25,32.88,31.19,30.62,30.06,30.22,30.66,31.94,34.16,36.41,39.0,42.34,44.19,45.19,46.75,47.0,47.69,46.5,46.56,46.78,45.69,44.12,43.31,41.69,40.28,38.81,37.44,35.09,32.84,28.31,24.78,19.94,17.81,15.41,15.81,16.91,20.28,22.66,25.34,27.94,29.38,31.06,32.25,33.0,34.09,34.16,34.75,35.41,37.38,38.78,40.66,41.59,40.84,39.47,37.19,34.56,34.0,33.66,36.38,39.69,42.12,45.16,46.94,47.0,47.0,44.78,43.25,41.94,39.69,39.31,39.09,39.06,39.97,40.91,42.12,42.28,43.59,44.44,46.81,47.19,48.12,47.53,46.66,45.62,44.25,42.66,41.31,39.06,36.16,33.41,31.44,30.22,29.78,30.31,31.06,32.88,34.84,36.31,36.84,38.47,37.88,38.56,38.94,38.19,38.06,38.03,36.88,37.56,36.34,35.72,35.94,34.97,35.28,35.03,36.16,37.03,36.78,37.12,37.22,37.31,37.62,38.09,38.72,39.75,40.59,40.78,40.94,40.69,40.44,40.0,39.91,40.75,41.19,40.72,42.12,42.56,42.0,42.19,40.38,39.75,38.69,37.56,38.31,38.44,37.97,38.38,37.91,36.69,35.78,35.44,34.75,34.44,34.25,35.03,36.72,40.03,42.81,45.91,48.56,48.88,49.97,48.12,46.34,46.34,43.81,42.22,41.41,39.31,36.06,33.34,30.62,28.19,27.19,25.72,25.19,25.78,26.09,27.22,29.12,30.97,33.78,35.59,36.19,38.12,38.25,38.66,36.81,36.91,34.91,31.62,28.53,26.5,23.81,22.0,20.66,20.25,19.41,19.03,19.72,20.84,22.31,24.56,26.03,28.06,29.34,30.34,31.94,31.59,31.44,30.56,29.56,28.28,28.72,27.53,29.12,29.69,31.69,32.94,34.81,34.69,33.94,31.25,28.41,24.75,22.12,20.66,20.53,20.41,21.66,24.31,26.5,28.41,30.97,31.59,32.69,32.31,30.75,28.5,25.56,21.34,18.12,15.19,13.12,14.44,15.66,17.97,20.16,22.69,23.53,26.09,26.91,29.5,32.16,35.75,38.81,42.06,45.81,47.0,50.12,50.62,48.88,45.31,40.88,34.91,29.41,24.94,21.69,19.75,19.06,20.25,21.62,24.31,27.28,30.84,34.0,37.19,40.31,42.53,44.38,44.0,44.03,42.75,40.06,37.66,35.38,32.28,29.31,26.59,23.28,20.16,18.88,18.62,19.72,21.12,23.22,23.0,21.5,18.72,13.97,9.69,30.44,18.5,28.81,28.03,21.56,16.72,15.09,15.31,15.75,16.28,16.28,15.69,15.19,15.5,15.16,14.44,13.94,13.66,13.72,14.19,15.91,17.28,20.31,21.88,23.53,25.16,26.16,27.16,26.78,26.97,27.03,26.0,69.47,98.69,136.56,128.38,130.56,111.38,77.41,48.69,32.19,25.0,23.34,23.75,24.69,26.03,25.97,24.53,22.84,20.28,19.16,17.03,16.5,16.59,16.59,17.84,17.72,19.38,20.53,20.34,21.66,21.94,22.31,22.91,23.75,24.12,24.69,24.81,30.31,51.78,88.38,136.19,175.06,144.59,133.28,101.25,62.41,33.62,17.44,10.59,8.5,8.94,9.34,9.91,10.12,10.59,10.41,9.53,9.03,9.47,7.81,55.0,80.97,111.81,118.28,145.0,133.56,114.56,80.91,51.0,32.91,24.78,23.0,22.19,22.28,21.97,20.59,19.59,18.31,17.31,17.25,18.5,19.31,19.69,20.16,19.56,18.97,18.12,16.78,14.94,13.81,11.91,10.38,9.19,8.75,40.0,42.69,47.06,50.31,54.19,55.72,56.91,56.81,54.88,52.0,49.66,47.5,45.28,42.75,42.25,40.91,41.09,41.34:56.5,59.16,60.22,60.19,58.16,55.62,51.41,46.94,42.78,39.59,37.59,36.97,35.75,36.75,38.56,40.03,41.84,44.69,47.09,48.28,50.56,51.88,53.31,53.56,54.91,55.44,54.88,55.53,55.03,55.5,54.91,54.06,52.97,51.44,48.66,45.91,43.16,40.28,37.0,34.56,34.03,33.59,34.12,36.44,36.97,38.12,38.75,38.28,37.56,37.91,37.47,37.97,38.31,38.28,38.62,37.94,36.12,35.31,33.66,33.03,33.22,33.16,33.91,35.16,35.81,36.81,37.84,39.94,41.53,43.31,46.5,49.06,49.94,50.84,50.88,49.31,47.53,45.16,43.34,41.25,39.69,38.56,38.31,36.69,35.0,34.72,33.94,34.88,35.47,36.44,38.97,40.12,40.44,41.91,43.0,44.69,47.31,48.25,50.94,52.59,52.66,53.34,52.91,53.12,52.91,52.5,51.81,51.0,50.16,49.66,49.66,50.25,52.88,55.94,57.34,60.38,63.12,65.5,67.31,69.25,71.06,72.34,72.28,71.81,71.81,69.69,67.41,62.81,58.5,53.41,49.62,46.44,44.66,45.31,46.16,46.84,47.53,49.81,49.56,49.72,49.19,48.31,47.16,46.59,46.5,45.91,46.06,46.34,45.16,44.81,45.03,47.53,49.66,51.72,55.0,55.31,54.72,53.53,51.84,50.19,48.75,48.06,48.91,49.91,51.66,54.69,57.44,59.94,61.59,61.47,60.88,59.66,58.06,55.16,52.41,50.28,47.88,45.97,45.81,46.75,47.69,49.28,49.25,48.44,47.19,46.97,44.31,44.41,44.28,43.94,44.0,45.34,44.91,45.59,45.47,46.66,46.22,46.81,46.88,45.16,43.03,41.66,38.56,36.88,35.69,35.16,33.97,33.62,33.94,33.72,34.25,35.66,36.91,40.16,41.31,44.91,47.5,49.62,51.34,53.69,55.06,57.53,58.0,58.91,58.16,54.84,51.25,46.88,41.69,37.03,32.97,30.62,28.31,29.0,31.38,34.34,38.5,42.34,46.81,49.56,51.34,51.59,51.25,48.66,46.69,42.62,40.06,36.16,34.06,31.38,29.62,28.31,27.5,25.72,23.78,22.28,21.88,21.06,22.12,23.44,25.78,28.06,31.0,32.53,35.12,37.22,36.69,37.5,37.19,35.03,34.28,33.0,33.66,35.5,39.44,44.94,49.94,54.31,55.62,55.31,52.66,48.34,44.28,41.09,39.06,36.78,37.5,38.97,40.06,43.38,46.06,46.88,46.53,45.09,42.12,39.12,36.09,33.19,32.03,32.03,32.97,35.16,37.53,39.38,40.81,41.75,41.94,42.28,42.38,41.41,41.69,42.12,42.28,42.91,43.0,44.44,42.81,39.88,40.41,39.06,39.06,39.47,40.06,40.91,40.91,41.22,41.81,43.47,45.19,46.25,46.62,46.16,46.56,43.78,42.44,40.78,39.06,38.97,38.94,40.22,41.28,43.03,44.88,45.69,45.75,46.25,44.28,43.25,40.94,39.66,37.28,36.25,35.78,36.5,36.81,38.62,41.38,43.16,45.16,46.69,47.66,48.03,47.75,46.94,45.22,44.53,42.25,40.59,37.22,34.72,31.59,28.66,25.5,23.75,22.41,20.69,21.44,21.81,23.31,25.41,27.53,30.03,32.34,33.75,35.03,35.31,35.31,35.91,34.12,32.31,29.69,25.44,22.44,19.31,17.59,16.88,17.31,17.62,19.84,20.88,23.09,24.72,25.38,26.78,27.56,28.06,28.06,28.78,29.78,30.53,31.31,30.97,32.03,30.84,28.78,27.75,25.44,23.53,21.44,20.5,22.16,25.0,28.81,33.56,38.88,42.19,43.91,45.84,47.19,47.31,47.66,47.22,47.41,46.75,47.44,47.72,48.81,49.19,50.5,48.94,48.19,46.38,44.38,42.09,40.66,38.53,36.06,34.25,32.88,31.19,30.62,30.06,30.22,30.66,31.94,34.16,36.41,39.0,42.34,44.19,45.19,46.75,47.0,47.69,46.5,46.56,46.78,45.69,44.12,43.31,41.69,40.28,38.81,37.44,35.09,32.84,28.31,24.78,19.94,17.81,15.41,15.81,16.91,20.28,22.66,25.34,27.94,29.38,31.06,32.25,33.0,34.09,34.16,34.75,35.41,37.38,38.78,40.66,41.59,40.84,39.47,37.19,34.56,34.0,33.66,36.38,39.69,42.12,45.16,46.94,47.0,47.0,44.78,43.25,41.94,39.69,39.31,39.09,39.06,39.97,40.91,42.12,42.28,43.59,44.44,46.81,47.19,48.12,47.53,46.66,45.62,44.25,42.66,41.31,39.06,36.16,33.41,31.44,30.22,29.78,30.31,31.06,32.88,34.84,36.31,36.84,38.47,37.88,38.56,38.94,38.19,38.06,38.03,36.88,37.56,36.34,35.72,35.94,34.97,35.28,35.03,36.16,37.03,36.78,37.12,37.22,37.31,37.62,38.09,38.72,39.75,40.59,40.78,40.94,40.69,40.44,40.0,39.91,40.75,41.19,40.72,42.12,42.56,42.0,42.19,40.38,39.75,38.69,37.56,38.31,38.44,37.97,38.38,37.91,36.69,35.78,35.44,34.75,34.44,34.25,35.03,36.72,40.03,42.81,45.91,48.56,48.88,49.97,48.12,46.34,46.34,43.81,42.22,41.41,39.31,36.06,33.34,30.62,28.19,27.19,25.72,25.19,25.78,26.09,27.22,29.12,30.97,33.78,35.59,36.19,38.12,38.25,38.66,36.81,36.91,34.91,31.62,28.53,26.5,23.81,22.0,20.66,20.25,19.41,19.03,19.72,20.84,22.31,24.56,26.03,28.06,29.34,30.34,31.94,31.59,31.44,30.56,29.56,28.28,28.72,27.53,29.12,29.69,31.69,32.94,34.81,34.69,33.94,31.25,28.41,24.75,22.12,20.66,20.53,20.41,21.66,24.31,26.5,28.41,30.97,31.59,32.69,32.31,30.75,28.5,25.56,21.34,18.12,15.19,13.12,14.44,15.66,17.97,20.16,22.69,23.53,26.09,26.91,29.5,32.16,35.75,38.81,42.06,45.81,47.0,50.12,50.62,48.88,45.31,40.88,34.91,29.41,24.94,21.69,19.75,19.06,20.25,21.62,24.31,27.28,30.84,34.0,37.19,40.31,42.53,44.38,44.0,44.03,42.75,40.06,37.66,35.38,32.28,29.31,26.59,23.28,20.16,18.88,18.62,19.72,21.12,23.22,23.0,21.5,18.72,13.97,9.69,30.44,18.5,28.81,28.03,21.56,16.72,15.09,15.31,15.75,16.28,16.28,15.69,15.19,15.5,15.16,14.44,13.94,13.66,13.72,14.19,15.91,17.28,20.31,21.88,23.53,25.16,26.16,27.16,26.78,26.97,27.03,26.0,69.47,98.69,136.56,128.38,130.56,111.38,77.41,48.69,32.19,25.0,23.34,23.75,24.69,26.03,25.97,24.53,22.84,20.28,19.16,17.03,16.5,16.59,16.59,17.84,17.72,19.38,20.53,20.34,21.66,21.94,22.31,22.91,23.75,24.12,24.69,24.81,30.31,51.78,88.38,136.19,175.06,144.59,133.28,101.25,62.41,33.62,17.44,10.59,8.5,8.94,9.34,9.91,10.12,10.59,10.41,9.53,9.03,9.47,7.81,55.0,80.97,111.81,118.28,145.0,133.56,114.56,80.91,51.0,32.91,24.78,23.0,22.19,22.28,21.97,20.59,19.59,18.31,17.31,17.25,18.5,19.31,19.69,20.16,19.56,18.97,18.12,16.78,14.94,13.81,11.91,10.38,9.19,8.75,40.0,42.69,47.06,50.31,54.19,55.72,56.91,56.81,54.88,52.0,49.66,47.5,45.28,42.75,42.25,40.91,41.09,41.34,43.0,43.94,47.31,50.34,53.72,57.19:51.41,46.94,42.78,39.59,37.59,36.97,35.75,36.75,38.56,40.03,41.84,44.69,47.09,48.28,50.56,51.88,53.31,53.56,54.91,55.44,54.88,55.53,55.03,55.5,54.91,54.06,52.97,51.44,48.66,45.91,43.16,40.28,37.0,34.56,34.03,33.59,34.12,36.44,36.97,38.12,38.75,38.28,37.56,37.91,37.47,37.97,38.31,38.28,38.62,37.94,36.12,35.31,33.66,33.03,33.22,33.16,33.91,35.16,35.81,36.81,37.84,39.94,41.53,43.31,46.5,49.06,49.94,50.84,50.88,49.31,47.53,45.16,43.34,41.25,39.69,38.56,38.31,36.69,35.0,34.72,33.94,34.88,35.47,36.44,38.97,40.12,40.44,41.91,43.0,44.69,47.31,48.25,50.94,52.59,52.66,53.34,52.91,53.12,52.91,52.5,51.81,51.0,50.16,49.66,49.66,50.25,52.88,55.94,57.34,60.38,63.12,65.5,67.31,69.25,71.06,72.34,72.28,71.81,71.81,69.69,67.41,62.81,58.5,53.41,49.62,46.44,44.66,45.31,46.16,46.84,47.53,49.81,49.56,49.72,49.19,48.31,47.16,46.59,46.5,45.91,46.06,46.34,45.16,44.81,45.03,47.53,49.66,51.72,55.0,55.31,54.72,53.53,51.84,50.19,48.75,48.06,48.91,49.91,51.66,54.69,57.44,59.94,61.59,61.47,60.88,59.66,58.06,55.16,52.41,50.28,47.88,45.97,45.81,46.75,47.69,49.28,49.25,48.44,47.19,46.97,44.31,44.41,44.28,43.94,44.0,45.34,44.91,45.59,45.47,46.66,46.22,46.81,46.88,45.16,43.03,41.66,38.56,36.88,35.69,35.16,33.97,33.62,33.94,33.72,34.25,35.66,36.91,40.16,41.31,44.91,47.5,49.62,51.34,53.69,55.06,57.53,58.0,58.91,58.16,54.84,51.25,46.88,41.69,37.03,32.97,30.62,28.31,29.0,31.38,34.34,38.5,42.34,46.81,49.56,51.34,51.59,51.25,48.66,46.69,42.62,40.06,36.16,34.06,31.38,29.62,28.31,27.5,25.72,23.78,22.28,21.88,21.06,22.12,23.44,25.78,28.06,31.0,32.53,35.12,37.22,36.69,37.5,37.19,35.03,34.28,33.0,33.66,35.5,39.44,44.94,49.94,54.31,55.62,55.31,52.66,48.34,44.28,41.09,39.06,36.78,37.5,38.97,40.06,43.38,46.06,46.88,46.53,45.09,42.12,39.12,36.09,33.19,32.03,32.03,32.97,35.16,37.53,39.38,40.81,41.75,41.94,42.28,42.38,41.41,41.69,42.12,42.28,42.91,43.0,44.44,42.81,39.88,40.41,39.06,39.06,39.47,40.06,40.91,40.91,41.22,41.81,43.47,45.19,46.25,46.62,46.16,46.56,43.78,42.44,40.78,39.06,38.97,38.94,40.22,41.28,43.03,44.88,45.69,45.75,46.25,44.28,43.25,40.94,39.66,37.28,36.25,35.78,36.5,36.81,38.62,41.38,43.16,45.16,46.69,47.66,48.03,47.75,46.94,45.22,44.53,42.25,40.59,37.22,34.72,31.59,28.66,25.5,23.75,22.41,20.69,21.44,21.81,23.31,25.41,27.53,30.03,32.34,33.75,35.03,35.31,35.31,35.91,34.12,32.31,29.69,25.44,22.44,19.31,17.59,16.88,17.31,17.62,19.84,20.88,23.09,24.72,25.38,26.78,27.56,28.06,28.06,28.78,29.78,30.53,31.31,30.97,32.03,30.84,28.78,27.75,25.44,23.53,21.44,20.5,22.16,25.0,28.81,33.56,38.88,42.19,43.91,45.84,47.19,47.31,47.66,47.22,47.41,46.75,47.44,47.72,48.81,49.19,50.5,48.94,48.19,46.38,44.38,42.09,40.66,38.53,36.06,34.25,32.88,31.19,30.62,30.06,30.22,30.66,31.94,34.16,36.41,39.0,42.34,44.19,45.19,46.75,47.0,47.69,46.5,46.56,46.78,45.69,44.12,43.31,41.69,40.28,38.81,37.44,35.09,32.84,28.31,24.78,19.94,17.81,15.41,15.81,16.91,20.28,22.66,25.34,27.94,29.38,31.06,32.25,33.0,34.09,34.16,34.75,35.41,37.38,38.78,40.66,41.59,40.84,39.47,37.19,34.56,34.0,33.66,36.38,39.69,42.12,45.16,46.94,47.0,47.0,44.78,43.25,41.94,39.69,39.31,39.09,39.06,39.97,40.91,42.12,42.28,43.59,44.44,46.81,47.19,48.12,47.53,46.66,45.62,44.25,42.66,41.31,39.06,36.16,33.41,31.44,30.22,29.78,30.31,31.06,32.88,34.84,36.31,36.84,38.47,37.88,38.56,38.94,38.19,38.06,38.03,36.88,37.56,36.34,35.72,35.94,34.97,35.28,35.03,36.16,37.03,36.78,37.12,37.22,37.31,37.62,38.09,38.72,39.75,40.59,40.78,40.94,40.69,40.44,40.0,39.91,40.75,41.19,40.72,42.12,42.56,42.0,42.19,40.38,39.75,38.69,37.56,38.31,38.44,37.97,38.38,37.91,36.69,35.78,35.44,34.75,34.44,34.25,35.03,36.72,40.03,42.81,45.91,48.56,48.88,49.97,48.12,46.34,46.34,43.81,42.22,41.41,39.31,36.06,33.34,30.62,28.19,27.19,25.72,25.19,25.78,26.09,27.22,29.12,30.97,33.78,35.59,36.19,38.12,38.25,38.66,36.81,36.91,34.91,31.62,28.53,26.5,23.81,22.0,20.66,20.25,19.41,19.03,19.72,20.84,22.31,24.56,26.03,28.06,29.34,30.34,31.94,31.59,31.44,30.56,29.56,28.28,28.72,27.53,29.12,29.69,31.69,32.94,34.81,34.69,33.94,31.25,28.41,24.75,22.12,20.66,20.53,20.41,21.66,24.31,26.5,28.41,30.97,31.59,32.69,32.31,30.75,28.5,25.56,21.34,18.12,15.19,13.12,14.44,15.66,17.97,20.16,22.69,23.53,26.09,26.91,29.5,32.16,35.75,38.81,42.06,45.81,47.0,50.12,50.62,48.88,45.31,40.88,34.91,29.41,24.94,21.69,19.75,19.06,20.25,21.62,24.31,27.28,30.84,34.0,37.19,40.31,42.53,44.38,44.0,44.03,42.75,40.06,37.66,35.38,32.28,29.31,26.59,23.28,20.16,18.88,18.62,19.72,21.12,23.22,23.0,21.5,18.72,13.97,9.69,30.44,18.5,28.81,28.03,21.56,16.72,15.09,15.31,15.75,16.28,16.28,15.69,15.19,15.5,15.16,14.44,13.94,13.66,13.72,14.19,15.91,17.28,20.31,21.88,23.53,25.16,26.16,27.16,26.78,26.97,27.03,26.0,69.47,98.69,136.56,128.38,130.56,111.38,77.41,48.69,32.19,25.0,23.34,23.75,24.69,26.03,25.97,24.53,22.84,20.28,19.16,17.03,16.5,16.59,16.59,17.84,17.72,19.38,20.53,20.34,21.66,21.94,22.31,22.91,23.75,24.12,24.69,24.81,30.31,51.78,88.38,136.19,175.06,144.59,133.28,101.25,62.41,33.62,17.44,10.59,8.5,8.94,9.34,9.91,10.12,10.59,10.41,9.53,9.03,9.47,7.81,55.0,80.97,111.81,118.28,145.0,133.56,114.56,80.91,51.0,32.91,24.78,23.0,22.19,22.28,21.97,20.59,19.59,18.31,17.31,17.25,18.5,19.31,19.69,20.16,19.56,18.97,18.12,16.78,14.94,13.81,11.91,10.38,9.19,8.75,40.0,42.69,47.06,50.31,54.19,55.72,56.91,56.81,54.88,52.0,49.66,47.5,45.28,42.75,42.25,40.91,41.09,41.34,43.0,43.94,47.31,50.34,53.72,57.19,59.12,62.62,63.34,63.22,61.25,59.44:negativity
-19.72,-19.34,-19.19,-19.97,-18.97,-18.56,-18.31,-16.0,-14.41,-11.81,-11.44,-10.78,-11.97,-13.44,-14.09,-15.06,-16.28,-16.12,-18.38,-20.47,-21.38,-21.47,-23.03,-23.0,-22.38,-21.97,-21.09,-19.66,-17.94,-17.66,-17.34,-19.34,-21.44,-22.72,-24.56,-24.66,-24.16,-22.84,-22.47,-20.47,-18.53,-16.91,-16.31,-15.84,-15.84,-16.97,-18.47,-19.03,-19.31,-20.47,-20.34,-21.91,-22.97,-22.91,-24.53,-24.0,-24.41,-24.16,-26.06,-27.72,-30.81,-36.09,-40.22,-43.06,-47.97,-49.84,-53.81,-56.84,-60.41,-63.91,-66.66,-67.56,-68.19,-67.78,-66.28,-64.81,-63.5,-60.22,-57.41,-55.28,-53.28,-52.16,-51.81,-52.09,-52.56,-51.66,-53.06,-53.34,-53.69,-54.47,-54.5,-54.09,-53.69,-52.31,-50.69,-48.53,-46.19,-45.25,-41.28,-40.44,-39.75,-39.75,-40.34,-43.38,-45.94,-48.44,-51.22,-51.19,-51.12,-48.91,-45.47,-45.34,-43.28,-44.72,-46.84,-50.19,-51.91,-51.88,-52.53,-50.5,-48.66,-46.12,-44.0,-43.09,-40.97,-41.09,-41.97,-42.94,-44.16,-45.31,-47.66,-47.19,-46.69,-47.16,-46.41,-46.66,-47.44,-49.69,-51.47,-53.84,-54.97,-55.94,-56.59,-55.34,-55.69,-52.44,-51.62,-49.03,-48.03,-48.16,-48.53,-48.47,-48.34,-48.91,-48.22,-47.84,-49.19,-49.88,-51.44,-50.34,-51.41,-50.47,-50.03,-50.41,-50.62,-50.0,-48.44,-47.34,-45.84,-44.59,-43.81,-42.25,-42.38,-41.59,-40.81,-38.47,-40.12,-39.84,-40.06,-42.59,-43.97,-45.97,-48.34,-49.97,-52.09,-52.31,-53.09,-53.97,-53.94,-52.97,-53.22,-52.41,-52.28,-52.03,-52.0,-53.0,-53.22,-53.31,-54.69,-54.75,-55.72,-55.91,-57.09,-57.22,-58.59,-58.81,-58.72,-58.72,-58.41,-57.16,-56.78,-55.41,-56.47,-56.56,-57.59,-58.34,-58.62,-59.78,-58.09,-57.59,-56.38,-54.59,-53.34,-52.91,-51.47,-51.09,-50.56,-50.66,-49.09,-50.22,-50.88,-50.78,-50.16,-49.72,-48.97,-47.78,-46.81,-47.59,-47.91,-48.88,-50.5,-52.81,-54.47,-55.34,-56.31,-56.59,-55.16,-54.72,-53.22,-51.5,-50.78,-49.59,-50.31,-50.59,-49.84,-50.34,-50.78,-48.41,-49.38,-48.69,-49.84,-50.66,-52.66,-54.5,-56.09,-57.16,-58.0,-59.06,-58.09,-58.53,-57.56,-57.78,-56.09,-53.28,-51.09,-49.34,-47.84,-46.97,-46.91,-48.16,-48.59,-49.31,-50.28,-49.72,-49.91,-50.34,-49.03,-48.06,-47.97,-47.41,-47.94,-47.69,-48.34,-48.88,-49.06,-49.91,-49.72,-49.75,-48.44,-48.47,-48.66,-48.78,-49.44,-50.22,-49.97,-49.38,-50.16,-49.19,-48.84,-49.78,-48.09,-49.09,-48.22,-48.59,-48.69,-49.22,-50.47,-50.03,-50.34,-51.66,-52.22,-52.78,-53.94,-56.22,-57.09,-58.88,-59.53,-59.41,-58.25,-56.91,-54.75,-53.16,-50.84,-50.34,-49.47,-48.47,-50.53,-51.28,-53.59,-55.84,-56.94,-56.81,-56.72,-55.09,-54.72,-52.91,-51.03,-49.0,-46.34,-44.06,-42.38,-41.41,-40.84,-41.41,-42.84,-43.28,-44.38,-43.84,-45.28,-45.38,-45.34,-45.28,-45.62,-46.78,-47.41,-47.56,-49.72,-50.78,-51.28,-50.78,-46.28,-43.44,-38.84,-35.5,-34.53,-33.38,-34.59,-36.22,-37.19,-36.94,-38.0,-38.88,-39.16,-41.03,-42.91,-43.59,-44.84,-46.53,-47.34,-48.59,-49.69,-50.06,-52.06,-52.56,-52.97,-52.81,-52.72,-51.22,-48.78,-47.12,-44.22,-41.72,-39.66,-37.03,-36.53,-35.44,-33.47,-35.88,-36.59,-38.25,-41.53,-44.03,-46.97,-48.78,-50.72,-53.81,-54.66,-56.34,-56.47,-56.53,-55.44,-53.97,-52.62,-49.62,-47.09,-44.97,-41.84,-39.59,-36.69,-33.81,-31.88,-30.97,-31.19,-31.91,-34.5,-37.09,-38.75,-40.31,-41.34,-42.28,-43.22,-43.12,-42.53,-41.66,-40.72,-39.81,-40.97,-41.69,-43.84,-44.34,-44.59,-44.03,-42.09,-39.88,-37.59,-36.28,-34.09,-33.69,-34.31,-35.97,-36.66,-38.78,-40.41,-43.09,-45.53,-49.47,-52.72,-55.72,-57.62,-57.78,-58.06,-57.66,-56.72,-55.81,-55.03,-52.25,-49.5,-45.03,-42.0,-39.56,-38.22,-38.09,-39.81,-41.09,-44.03,-45.72,-46.94,-48.53,-48.66,-49.34,-49.34,-49.59,-49.72,-51.06,-53.0,-54.81,-56.88,-59.44,-59.94,-59.94,-57.81,-55.34,-51.66,-49.22,-47.5,-46.66,-47.72,-49.84,-51.56,-52.94,-54.19,-54.84,-54.31,-52.97,-51.84,-50.09,-47.97,-46.59,-44.69,-42.84,-41.91,-41.69,-42.03,-42.75,-42.88,-44.66,-45.59,-47.91,-49.91,-52.06,-54.69,-55.91,-57.31,-58.34,-58.03,-57.0,-55.72,-54.22,-51.88,-50.78,-49.09,-47.47,-46.16,-44.53,-42.75,-41.47,-38.84,-38.03,-35.66,-34.34,-33.91,-33.06,-32.72,-33.34,-33.34,-33.66,-34.88,-34.56,-35.53,-35.34,-35.5,-35.81,-35.97,-37.0,-38.72,-40.31,-42.59,-44.28,-44.53,-43.5,-42.97,-39.97,-37.97,-35.81,-33.75,-32.41,-32.16,-32.56,-34.12,-35.75,-37.44,-38.38,-38.66,-39.59,-41.44,-43.31,-45.88,-47.69,-49.09,-48.38,-47.53,-46.31,-43.16,-41.0,-38.31,-34.41,-30.62,-28.06,-25.94,-25.81,-26.75,-28.47,-31.16,-32.66,-34.5,-34.28,-33.72,-32.75,-32.0,-30.59,-29.66,-29.09,-29.66,-29.59,-30.84,-32.03,-32.91,-33.94,-34.53,-33.41,-30.16,-25.97,-21.41,-18.47,-17.16,-18.22,-20.78,-24.72,-26.97,-27.94,-28.03,-27.78,-27.0,-27.81,-26.91,-28.09,-29.0,-30.28,-31.91,-32.59,-33.5,-33.28,-31.44,-30.84,-28.66,-27.19,-26.59,-26.53,-25.84,-26.34,-26.84,-26.62,-27.69,-26.59,-27.94,-28.09,-28.22,-29.22,-29.78,-31.56,-32.84,-34.03,-34.06,-33.66,-33.06,-31.91,-31.09,-30.53,-29.28,-27.72,-25.66,-24.16,-23.19,-22.12,-22.28,-22.25,-22.81,-21.22,-19.94,-18.59,-16.5,-15.16,-13.44,-11.97,-10.41,-10.31,-10.03,-10.03,-10.31,-11.38,-11.25,-11.81,-12.22,-11.84,-12.56,-11.97,-11.72,-12.28,-11.84,-12.72,-13.97,-14.94,-15.78,-16.47,-17.12,-18.78,-18.38,-20.56,-21.66,-23.09,-24.22,-25.25,-26.16,-25.81,-24.94,-23.56,-21.09,-17.78,-15.84,-14.16,-12.16,-12.44,-13.78,-15.12,-18.69,-22.16,-24.94,-28.0,-29.41,-29.62,-29.62,-27.69,-26.72,-25.41,-22.53,-21.12,-19.22,-18.12,-16.94,-15.59,-14.84,-14.44,-13.47,-13.66,-14.47,-14.41,-15.22,-16.16,-15.84,-15.03,-14.34,-13.09,-12.81,-12.19,-11.38,-12.72,-12.72,-14.41,-14.84,-16.0,-16.16,-15.62,-14.59,-13.09,-11.0,-10.34,-9.22,-8.91,-9.78,-10.66,-12.75,-16.09,-18.88,-21.81,-24.66,-25.69,-26.66,-26.53,-26.0,-25.38,-25.47,-24.66,-24.28,-23.47,-22.81,-21.28,-20.03,-18.53,-16.59,-14.78,-14.47,-14.44,-14.59,-14.62,-15.69,-16.66,-18.03,-19.0,-20.66,-22.72,-23.19,-24.22,-24.22,-24.41,-24.03,-23.72,-22.69,-21.75,-20.84,-19.84,-18.16,-17.25,-16.72,-16.25,-16.44,-16.34,-15.66,-15.84,-15.25,-15.19,-15.84,-16.28,-16.16,-17.09,-17.34,-17.22,-18.03,-18.84,-19.03,-19.25,-18.66,-18.38,-18.03,-16.94,-16.88,-15.78,-15.31,-15.41,-14.78,-13.62,-13.53,-12.16,-11.56,-11.19,-10.34,-10.28,-10.78,-10.09,-9.44,-9.59,-10.38,-10.53,-11.44,-12.31,-12.16,-11.62,-9.62,-8.09,-4.5,-0.91,1.19,3.06,2.94,0.09,-2.78,-5.16,-7.56,-7.84,-7.06,-7.28,-6.72,-6.41,-7.94,-7.66,-6.66,-5.72,-2.44,1.06,3.72,5.69,6.72,5.69,4.03,1.69,-0.84,-3.5,-5.78,-6.59,-8.28,-7.47,-8.34,-9.41,-10.59,-13.56,-17.03,-21.16:-18.31,-16.0,-14.41,-11.81,-11.44,-10.78,-11.97,-13.44,-14.09,-15.06,-16.28,-16.12,-18.38,-20.47,-21.38,-21.47,-23.03,-23.0,-22.38,-21.97,-21.09,-19.66,-17.94,-17.66,-17.34,-19.34,-21.44,-22.72,-24.56,-24.66,-24.16,-22.84,-22.47,-20.47,-18.53,-16.91,-16.31,-15.84,-15.84,-16.97,-18.47,-19.03,-19.31,-20.47,-20.34,-21.91,-22.97,-22.91,-24.53,-24.0,-24.41,-24.16,-26.06,-27.72,-30.81,-36.09,-40.22,-43.06,-47.97,-49.84,-53.81,-56.84,-60.41,-63.91,-66.66,-67.56,-68.19,-67.78,-66.28,-64.81,-63.5,-60.22,-57.41,-55.28,-53.28,-52.16,-51.81,-52.09,-52.56,-51.66,-53.06,-53.34,-53.69,-54.47,-54.5,-54.09,-53.69,-52.31,-50.69,-48.53,-46.19,-45.25,-41.28,-40.44,-39.75,-39.75,-40.34,-43.38,-45.94,-48.44,-51.22,-51.19,-51.12,-48.91,-45.47,-45.34,-43.28,-44.72,-46.84,-50.19,-51.91,-51.88,-52.53,-50.5,-48.66,-46.12,-44.0,-43.09,-40.97,-41.09,-41.97,-42.94,-44.16,-45.31,-47.66,-47.19,-46.69,-47.16,-46.41,-46.66,-47.44,-49.69,-51.47,-53.84,-54.97,-55.94,-56.59,-55.34,-55.69,-52.44,-51.62,-49.03,-48.03,-48.16,-48.53,-48.47,-48.34,-48.91,-48.22,-47.84,-49.19,-49.88,-51.44,-50.34,-51.41,-50.47,-50.03,-50.41,-50.62,-50.0,-48.44,-47.34,-45.84,-44.59,-43.81,-42.25,-42.38,-41.59,-40.81,-38.47,-40.12,-39.84,-40.06,-42.59,-43.97,-45.97,-48.34,-49.97,-52.09,-52.31,-53.09,-53.97,-53.94,-52.97,-53.22,-52.41,-52.28,-52.03,-52.0,-53.0,-53.22,-53.31,-54.69,-54.75,-55.72,-55.91,-57.09,-57.22,-58.59,-58.81,-58.72,-58.72,-58.41,-57.16,-56.78,-55.41,-56.47,-56.56,-57.59,-58.34,-58.62,-59.78,-58.09,-57.59,-56.38,-54.59,-53.34,-52.91,-51.47,-51.09,-50.56,-50.66,-49.09,-50.22,-50.88,-50.78,-50.16,-49.72,-48.97,-47.78,-46.81,-47.59,-47.91,-48.88,-50.5,-52.81,-54.47,-55.34,-56.31,-56.59,-55.16,-54.72,-53.22,-51.5,-50.78,-49.59,-50.31,-50.59,-49.84,-50.34,-50.78,-48.41,-49.38,-48.69,-49.84,-50.66,-52.66,-54.5,-56.09,-57.16,-58.0,-59.06,-58.09,-58.53,-57.56,-57.78,-56.09,-53.28,-51.09,-49.34,-47.84,-46.97,-46.91,-48.16,-48.59,-49.31,-50.28,-49.72,-49.91,-50.34,-49.03,-48.06,-47.97,-47.41,-47.94,-47.69,-48.34,-48.88,-49.06,-49.91,-49.72,-49.75,-48.44,-48.47,-48.66,-48.78,-49.44,-50.22,-49.97,-49.38,-50.16,-49.19,-48.84,-49.78,-48.09,-49.09,-48.22,-48.59,-48.69,-49.22,-50.47,-50.03,-50.34,-51.66,-52.22,-52.78,-53.94,-56.22,-57.09,-58.88,-59.53,-59.41,-58.25,-56.91,-54.75,-53.16,-50.84,-50.34,-49.47,-48.47,-50.53,-51.28,-53.59,-55.84,-56.94,-56.81,-56.72,-55.09,-54.72,-52.91,-51.03,-49.0,-46.34,-44.06,-42.38,-41.41,-40.84,-41.41,-42.84,-43.28,-44.38,-43.84,-45.28,-45.38,-45.34,-45.28,-45.62,-46.78,-47.41,-47.56,-49.72,-50.78,-51.28,-50.78,-46.28,-43.44,-38.84,-35.5,-34.53,-33.38,-34.59,-36.22,-37.19,-36.94,-38.0,-38.88,-39.16,-41.03,-42.91,-43.59,-44.84,-46.53,-47.34,-48.59,-49.69,-50.06,-52.06,-52.56,-52.97,-52.81,-52.72,-51.22,-48.78,-47.12,-44.22,-41.72,-39.66,-37.03,-36.53,-35.44,-33.47,-35.88,-36.59,-38.25,-41.53,-44.03,-46.97,-48.78,-50.72,-53.81,-54.66,-56.34,-56.47,-56.53,-55.44,-53.97,-52.62,-49.62,-47.09,-44.97,-41.84,-39.59,-36.69,-33.81,-31.88,-30.97,-31.19,-31.91,-34.5,-37.09,-38.75,-40.31,-41.34,-42.28,-43.22,-43.12,-42.53,-41.66,-40.72,-39.81,-40.97,-41.69,-43.84,-44.34,-44.59,-44.03,-42.09,-39.88,-37.59,-36.28,-34.09,-33.69,-34.31,-35.97,-36.66,-38.78,-40.41,-43.09,-45.53,-49.47,-52.72,-55.72,-57.62,-57.78,-58.06,-57.66,-56.72,-55.81,-55.03,-52.25,-49.5,-45.03,-42.0,-39.56,-38.22,-38.09,-39.81,-41.09,-44.03,-45.72,-46.94,-48.53,-48.66,-49.34,-49.34,-49.59,-49.72,-51.06,-53.0,-54.81,-56.88,-59.44,-59.94,-59.94,-57.81,-55.34,-51.66,-49.22,-47.5,-46.66,-47.72,-49.84,-51.56,-52.94,-54.19,-54.84,-54.31,-52.97,-51.84,-50.09,-47.97,-46.59,-44.69,-42.84,-41.91,-41.69,-42.03,-42.75,-42.88,-44.66,-45.59,-47.91,-49.91,-52.06,-54.69,-55.91,-57.31,-58.34,-58.03,-57.0,-55.72,-54.22,-51.88,-50.78,-49.09,-47.47,-46.16,-44.53,-42.75,-41.47,-38.84,-38.03,-35.66,-34.34,-33.91,-33.06,-32.72,-33.34,-33.34,-33.66,-34.88,-34.56,-35.53,-35.34,-35.5,-35.81,-35.97,-37.0,-38.72,-40.31,-42.59,-44.28,-44.53,-43.5,-42.97,-39.97,-37.97,-35.81,-33.75,-32.41,-32.16,-32.56,-34.12,-35.75,-37.44,-38.38,-38.66,-39.59,-41.44,-43.31,-45.88,-47.69,-49.09,-48.38,-47.53,-46.31,-43.16,-41.0,-38.31,-34.41,-30.62,-28.06,-25.94,-25.81,-26.75,-28.47,-31.16,-32.66,-34.5,-34.28,-33.72,-32.75,-32.0,-30.59,-29.66,-29.09,-29.66,-29.59,-30.84,-32.03,-32.91,-33.94,-34.53,-33.41,-30.16,-25.97,-21.41,-18.47,-17.16,-18.22,-20.78,-24.72,-26.97,-27.94,-28.03,-27.78,-27.0,-27.81,-26.91,-28.09,-29.0,-30.28,-31.91,-32.59,-33.5,-33.28,-31.44,-30.84,-28.66,-27.19,-26.59,-26.53,-25.84,-26.34,-26.84,-26.62,-27.69,-26.59,-27.94,-28.09,-28.22,-29.22,-29.78,-31.56,-32.84,-34.03,-34.06,-33.66,-33.06,-31.91,-31.09,-30.53,-29.28,-27.72,-25.66,-24.16,-23.19,-22.12,-22.28,-22.25,-22.81,-21.22,-19.94,-18.59,-16.5,-15.16,-13.44,-11.97,-10.41,-10.31,-10.03,-10.03,-10.31,-11.38,-11.25,-11.81,-12.22,-11.84,-12.56,-11.97,-11.72,-12.28,-11.84,-12.72,-13.97,-14.94,-15.78,-16.47,-17.12,-18.78,-18.38,-20.56,-21.66,-23.09,-24.22,-25.25,-26.16,-25.81,-24.94,-23.56,-21.09,-17.78,-15.84,-14.16,-12.16,-12.44,-13.78,-15.12,-18.69,-22.16,-24.94,-28.0,-29.41,-29.62,-29.62,-27.69,-26.72,-25.41,-22.53,-21.12,-19.22,-18.12,-16.94,-15.59,-14.84,-14.44,-13.47,-13.66,-14.47,-14.41,-15.22,-16.16,-15.84,-15.03,-14.34,-13.09,-12.81,-12.19,-11.38,-12.72,-12.72,-14.41,-14.84,-16.0,-16.16,-15.62,-14.59,-13.09,-11.0,-10.34,-9.22,-8.91,-9.78,-10.66,-12.75,-16.09,-18.88,-21.81,-24.66,-25.69,-26.66,-26.53,-26.0,-25.38,-25.47,-24.66,-24.28,-23.47,-22.81,-21.28,-20.03,-18.53,-16.59,-14.78,-14.47,-14.44,-14.59,-14.62,-15.69,-16.66,-18.03,-19.0,-20.66,-22.72,-23.19,-24.22,-24.22,-24.41,-24.03,-23.72,-22.69,-21.75,-20.84,-19.84,-18.16,-17.25,-16.72,-16.25,-16.44,-16.34,-15.66,-15.84,-15.25,-15.19,-15.84,-16.28,-16.16,-17.09,-17.34,-17.22,-18.03,-18.84,-19.03,-19.25,-18.66,-18.38,-18.03,-16.94,-16.88,-15.78,-15.31,-15.41,-14.78,-13.62,-13.53,-12.16,-11.56,-11.19,-10.34,-10.28,-10.78,-10.09,-9.44,-9.59,-10.38,-10.53,-11.44,-12.31,-12.16,-11.62,-9.62,-8.09,-4.5,-0.91,1.19,3.06,2.94,0.09,-2.78,-5.16,-7.56,-7.84,-7.06,-7.28,-6.72,-6.41,-7.94,-7.66,-6.66,-5.72,-2.44,1.06,3.72,5.69,6.72,5.69,4.03,1.69,-0.84,-3.5,-5.78,-6.59,-8.28,-7.47,-8.34,-9.41,-10.59,-13.56,-17.03,-21.16,-34.09,-35.56,-36.91,-36.62,-35.97,-34.59:-11.97,-13.44,-14.09,-15.06,-16.28,-16.12,-18.38,-20.47,-21.38,-21.47,-23.03,-23.0,-22.38,-21.97,-21.09,-19.66,-17.94,-17.66,-17.34,-19.34,-21.44,-22.72,-24.56,-24.66,-24.16,-22.84,-22.47,-20.47,-18.53,-16.91,-16.31,-15.84,-15.84,-16.97,-18.47,-19.03,-19.31,-20.47,-20.34,-21.91,-22.97,-22.91,-24.53,-24.0,-24.41,-24.16,-26.06,-27.72,-30.81,-36.09,-40.22,-43.06,-47.97,-49.84,-53.81,-56.84,-60.41,-63.91,-66.66,-67.56,-68.19,-67.78,-66.28,-64.81,-63.5,-60.22,-57.41,-55.28,-53.28,-52.16,-51.81,-52.09,-52.56,-51.66,-53.06,-53.34,-53.69,-54.47,-54.5,-54.09,-53.69,-52.31,-50.69,-48.53,-46.19,-45.25,-41.28,-40.44,-39.75,-39.75,-40.34,-43.38,-45.94,-48.44,-51.22,-51.19,-51.12,-48.91,-45.47,-45.34,-43.28,-44.72,-46.84,-50.19,-51.91,-51.88,-52.53,-50.5,-48.66,-46.12,-44.0,-43.09,-40.97,-41.09,-41.97,-42.94,-44.16,-45.31,-47.66,-47.19,-46.69,-47.16,-46.41,-46.66,-47.44,-49.69,-51.47,-53.84,-54.97,-55.94,-56.59,-55.34,-55.69,-52.44,-51.62,-49.03,-48.03,-48.16,-48.53,-48.47,-48.34,-48.91,-48.22,-47.84,-49.19,-49.88,-51.44,-50.34,-51.41,-50.47,-50.03,-50.41,-50.62,-50.0,-48.44,-47.34,-45.84,-44.59,-43.81,-42.25,-42.38,-41.59,-40.81,-38.47,-40.12,-39.84,-40.06,-42.59,-43.97,-45.97,-48.34,-49.97,-52.09,-52.31,-53.09,-53.97,-53.94,-52.97,-53.22,-52.41,-52.28,-52.03,-52.0,-53.0,-53.22,-53.31,-54.69,-54.75,-55.72,-55.91,-57.09,-57.22,-58.59,-58.81,-58.72,-58.72,-58.41,-57.16,-56.78,-55.41,-56.47,-56.56,-57.59,-58.34,-58.62,-59.78,-58.09,-57.59,-56.38,-54.59,-53.34,-52.91,-51.47,-51.09,-50.56,-50.66,-49.09,-50.22,-50.88,-50.78,-50.16,-49.72,-48.97,-47.78,-46.81,-47.59,-47.91,-48.88,-50.5,-52.81,-54.47,-55.34,-56.31,-56.59,-55.16,-54.72,-53.22,-51.5,-50.78,-49.59,-50.31,-50.59,-49.84,-50.34,-50.78,-48.41,-49.38,-48.69,-49.84,-50.66,-52.66,-54.5,-56.09,-57.16,-58.0,-59.06,-58.09,-58.53,-57.56,-57.78,-56.09,-53.28,-51.09,-49.34,-47.84,-46.97,-46.91,-48.16,-48.59,-49.31,-50.28,-49.72,-49.91,-50.34,-49.03,-48.06,-47.97,-47.41,-47.94,-47.69,-48.34,-48.88,-49.06,-49.91,-49.72,-49.75,-48.44,-48.47,-48.66,-48.78,-49.44,-50.22,-49.97,-49.38,-50.16,-49.19,-48.84,-49.78,-48.09,-49.09,-48.22,-48.59,-48.69,-49.22,-50.47,-50.03,-50.34,-51.66,-52.22,-52.78,-53.94,-56.22,-57.09,-58.88,-59.53,-59.41,-58.25,-56.91,-54.75,-53.16,-50.84,-50.34,-49.47,-48.47,-50.53,-51.28,-53.59,-55.84,-56.94,-56.81,-56.72,-55.09,-54.72,-52.91,-51.03,-49.0,-46.34,-44.06,-42.38,-41.41,-40.84,-41.41,-42.84,-43.28,-44.38,-43.84,-45.28,-45.38,-45.34,-45.28,-45.62,-46.78,-47.41,-47.56,-49.72,-50.78,-51.28,-50.78,-46.28,-43.44,-38.84,-35.5,-34.53,-33.38,-34.59,-36.22,-37.19,-36.94,-38.0,-38.88,-39.16,-41.03,-42.91,-43.59,-44.84,-46.53,-47.34,-48.59,-49.69,-50.06,-52.06,-52.56,-52.97,-52.81,-52.72,-51.22,-48.78,-47.12,-44.22,-41.72,-39.66,-37.03,-36.53,-35.44,-33.47,-35.88,-36.59,-38.25,-41.53,-44.03,-46.97,-48.78,-50.72,-53.81,-54.66,-56.34,-56.47,-56.53,-55.44,-53.97,-52.62,-49.62,-47.09,-44.97,-41.84,-39.59,-36.69,-33.81,-31.88,-30.97,-31.19,-31.91,-34.5,-37.09,-38.75,-40.31,-41.34,-42.28,-43.22,-43.12,-42.53,-41.66,-40.72,-39.81,-40.97,-41.69,-43.84,-44.34,-44.59,-44.03,-42.09,-39.88,-37.59,-36.28,-34.09,-33.69,-34.31,-35.97,-36.66,-38.78,-40.41,-43.09,-45.53,-49.47,-52.72,-55.72,-57.62,-57.78,-58.06,-57.66,-56.72,-55.81,-55.03,-52.25,-49.5,-45.03,-42.0,-39.56,-38.22,-38.09,-39.81,-41.09,-44.03,-45.72,-46.94,-48.53,-48.66,-49.34,-49.34,-49.59,-49.72,-51.06,-53.0,-54.81,-56.88,-59.44,-59.94,-59.94,-57.81,-55.34,-51.66,-49.22,-47.5,-46.66,-47.72,-49.84,-51.56,-52.94,-54.19,-54.84,-54.31,-52.97,-51.84,-50.09,-47.97,-46.59,-44.69,-42.84,-41.91,-41.69,-42.03,-42.75,-42.88,-44.66,-45.59,-47.91,-49.91,-52.06,-54.69,-55.91,-57.31,-58.34,-58.03,-57.0,-55.72,-54.22,-51.88,-50.78,-49.09,-47.47,-46.16,-44.53,-42.75,-41.47,-38.84,-38.03,-35.66,-34.34,-33.91,-33.06,-32.72,-33.34,-33.34,-33.66,-34.88,-34.56,-35.53,-35.34,-35.5,-35.81,-35.97,-37.0,-38.72,-40.31,-42.59,-44.28,-44.53,-43.5,-42.97,-39.97,-37.97,-35.81,-33.75,-32.41,-32.16,-32.56,-34.12,-35.75,-37.44,-38.38,-38.66,-39.59,-41.44,-43.31,-45.88,-47.69,-49.09,-48.38,-47.53,-46.31,-43.16,-41.0,-38.31,-34.41,-30.62,-28.06,-25.94,-25.81,-26.75,-28.47,-31.16,-32.66,-34.5,-34.28,-33.72,-32.75,-32.0,-30.59,-29.66,-29.09,-29.66,-29.59,-30.84,-32.03,-32.91,-33.94,-34.53,-33.41,-30.16,-25.97,-21.41,-18.47,-17.16,-18.22,-20.78,-24.72,-26.97,-27.94,-28.03,-27.78,-27.0,-27.81,-26.91,-28.09,-29.0,-30.28,-31.91,-32.59,-33.5,-33.28,-31.44,-30.84,-28.66,-27.19,-26.59,-26.53,-25.84,-26.34,-26.84,-26.62,-27.69,-26.59,-27.94,-28.09,-28.22,-29.22,-29.78,-31.56,-32.84,-34.03,-34.06,-33.66,-33.06,-31.91,-31.09,-30.53,-29.28,-27.72,-25.66,-24.16,-23.19,-22.12,-22.28,-22.25,-22.81,-21.22,-19.94,-18.59,-16.5,-15.16,-13.44,-11.97,-10.41,-10.31,-10.03,-10.03,-10.31,-11.38,-11.25,-11.81,-12.22,-11.84,-12.56,-11.97,-11.72,-12.28,-11.84,-12.72,-13.97,-14.94,-15.78,-16.47,-17.12,-18.78,-18.38,-20.56,-21.66,-23.09,-24.22,-25.25,-26.16,-25.81,-24.94,-23.56,-21.09,-17.78,-15.84,-14.16,-12.16,-12.44,-13.78,-15.12,-18.69,-22.16,-24.94,-28.0,-29.41,-29.62,-29.62,-27.69,-26.72,-25.41,-22.53,-21.12,-19.22,-18.12,-16.94,-15.59,-14.84,-14.44,-13.47,-13.66,-14.47,-14.41,-15.22,-16.16,-15.84,-15.03,-14.34,-13.09,-12.81,-12.19,-11.38,-12.72,-12.72,-14.41,-14.84,-16.0,-16.16,-15.62,-14.59,-13.09,-11.0,-10.34,-9.22,-8.91,-9.78,-10.66,-12.75,-16.09,-18.88,-21.81,-24.66,-25.69,-26.66,-26.53,-26.0,-25.38,-25.47,-24.66,-24.28,-23.47,-22.81,-21.28,-20.03,-18.53,-16.59,-14.78,-14.47,-14.44,-14.59,-14.62,-15.69,-16.66,-18.03,-19.0,-20.66,-22.72,-23.19,-24.22,-24.22,-24.41,-24.03,-23.72,-22.69,-21.75,-20.84,-19.84,-18.16,-17.25,-16.72,-16.25,-16.44,-16.34,-15.66,-15.84,-15.25,-15.19,-15.84,-16.28,-16.16,-17.09,-17.34,-17.22,-18.03,-18.84,-19.03,-19.25,-18.66,-18.38,-18.03,-16.94,-16.88,-15.78,-15.31,-15.41,-14.78,-13.62,-13.53,-12.16,-11.56,-11.19,-10.34,-10.28,-10.78,-10.09,-9.44,-9.59,-10.38,-10.53,-11.44,-12.31,-12.16,-11.62,-9.62,-8.09,-4.5,-0.91,1.19,3.06,2.94,0.09,-2.78,-5.16,-7.56,-7.84,-7.06,-7.28,-6.72,-6.41,-7.94,-7.66,-6.66,-5.72,-2.44,1.06,3.72,5.69,6.72,5.69,4.03,1.69,-0.84,-3.5,-5.78,-6.59,-8.28,-7.47,-8.34,-9.41,-10.59,-13.56,-17.03,-21.16,-34.09,-35.56,-36.91,-36.62,-35.97,-34.59,-32.47,-29.62,-27.72,-25.88,-24.44,-23.78:-18.38,-20.47,-21.38,-21.47,-23.03,-23.0,-22.38,-21.97,-21.09,-19.66,-17.94,-17.66,-17.34,-19.34,-21.44,-22.72,-24.56,-24.66,-24.16,-22.84,-22.47,-20.47,-18.53,-16.91,-16.31,-15.84,-15.84,-16.97,-18.47,-19.03,-19.31,-20.47,-20.34,-21.91,-22.97,-22.91,-24.53,-24.0,-24.41,-24.16,-26.06,-27.72,-30.81,-36.09,-40.22,-43.06,-47.97,-49.84,-53.81,-56.84,-60.41,-63.91,-66.66,-67.56,-68.19,-67.78,-66.28,-64.81,-63.5,-60.22,-57.41,-55.28,-53.28,-52.16,-51.81,-52.09,-52.56,-51.66,-53.06,-53.34,-53.69,-54.47,-54.5,-54.09,-53.69,-52.31,-50.69,-48.53,-46.19,-45.25,-41.28,-40.44,-39.75,-39.75,-40.34,-43.38,-45.94,-48.44,-51.22,-51.19,-51.12,-48.91,-45.47,-45.34,-43.28,-44.72,-46.84,-50.19,-51.91,-51.88,-52.53,-50.5,-48.66,-46.12,-44.0,-43.09,-40.97,-41.09,-41.97,-42.94,-44.16,-45.31,-47.66,-47.19,-46.69,-47.16,-46.41,-46.66,-47.44,-49.69,-51.47,-53.84,-54.97,-55.94,-56.59,-55.34,-55.69,-52.44,-51.62,-49.03,-48.03,-48.16,-48.53,-48.47,-48.34,-48.91,-48.22,-47.84,-49.19,-49.88,-51.44,-50.34,-51.41,-50.47,-50.03,-50.41,-50.62,-50.0,-48.44,-47.34,-45.84,-44.59,-43.81,-42.25,-42.38,-41.59,-40.81,-38.47,-40.12,-39.84,-40.06,-42.59,-43.97,-45.97,-48.34,-49.97,-52.09,-52.31,-53.09,-53.97,-53.94,-52.97,-53.22,-52.41,-52.28,-52.03,-52.0,-53.0,-53.22,-53.31,-54.69,-54.75,-55.72,-55.91,-57.09,-57.22,-58.59,-58.81,-58.72,-58.72,-58.41,-57.16,-56.78,-55.41,-56.47,-56.56,-57.59,-58.34,-58.62,-59.78,-58.09,-57.59,-56.38,-54.59,-53.34,-52.91,-51.47,-51.09,-50.56,-50.66,-49.09,-50.22,-50.88,-50.78,-50.16,-49.72,-48.97,-47.78,-46.81,-47.59,-47.91,-48.88,-50.5,-52.81,-54.47,-55.34,-56.31,-56.59,-55.16,-54.72,-53.22,-51.5,-50.78,-49.59,-50.31,-50.59,-49.84,-50.34,-50.78,-48.41,-49.38,-48.69,-49.84,-50.66,-52.66,-54.5,-56.09,-57.16,-58.0,-59.06,-58.09,-58.53,-57.56,-57.78,-56.09,-53.28,-51.09,-49.34,-47.84,-46.97,-46.91,-48.16,-48.59,-49.31,-50.28,-49.72,-49.91,-50.34,-49.03,-48.06,-47.97,-47.41,-47.94,-47.69,-48.34,-48.88,-49.06,-49.91,-49.72,-49.75,-48.44,-48.47,-48.66,-48.78,-49.44,-50.22,-49.97,-49.38,-50.16,-49.19,-48.84,-49.78,-48.09,-49.09,-48.22,-48.59,-48.69,-49.22,-50.47,-50.03,-50.34,-51.66,-52.22,-52.78,-53.94,-56.22,-57.09,-58.88,-59.53,-59.41,-58.25,-56.91,-54.75,-53.16,-50.84,-50.34,-49.47,-48.47,-50.53,-51.28,-53.59,-55.84,-56.94,-56.81,-56.72,-55.09,-54.72,-52.91,-51.03,-49.0,-46.34,-44.06,-42.38,-41.41,-40.84,-41.41,-42.84,-43.28,-44.38,-43.84,-45.28,-45.38,-45.34,-45.28,-45.62,-46.78,-47.41,-47.56,-49.72,-50.78,-51.28,-50.78,-46.28,-43.44,-38.84,-35.5,-34.53,-33.38,-34.59,-36.22,-37.19,-36.94,-38.0,-38.88,-39.16,-41.03,-42.91,-43.59,-44.84,-46.53,-47.34,-48.59,-49.69,-50.06,-52.06,-52.56,-52.97,-52.81,-52.72,-51.22,-48.78,-47.12,-44.22,-41.72,-39.66,-37.03,-36.53,-35.44,-33.47,-35.88,-36.59,-38.25,-41.53,-44.03,-46.97,-48.78,-50.72,-53.81,-54.66,-56.34,-56.47,-56.53,-55.44,-53.97,-52.62,-49.62,-47.09,-44.97,-41.84,-39.59,-36.69,-33.81,-31.88,-30.97,-31.19,-31.91,-34.5,-37.09,-38.75,-40.31,-41.34,-42.28,-43.22,-43.12,-42.53,-41.66,-40.72,-39.81,-40.97,-41.69,-43.84,-44.34,-44.59,-44.03,-42.09,-39.88,-37.59,-36.28,-34.09,-33.69,-34.31,-35.97,-36.66,-38.78,-40.41,-43.09,-45.53,-49.47,-52.72,-55.72,-57.62,-57.78,-58.06,-57.66,-56.72,-55.81,-55.03,-52.25,-49.5,-45.03,-42.0,-39.56,-38.22,-38.09,-39.81,-41.09,-44.03,-45.72,-46.94,-48.53,-48.66,-49.34,-49.34,-49.59,-49.72,-51.06,-53.0,-54.81,-56.88,-59.44,-59.94,-59.94,-57.81,-55.34,-51.66,-49.22,-47.5,-46.66,-47.72,-49.84,-51.56,-52.94,-54.19,-54.84,-54.31,-52.97,-51.84,-50.09,-47.97,-46.59,-44.69,-42.84,-41.91,-41.69,-42.03,-42.75,-42.88,-44.66,-45.59,-47.91,-49.91,-52.06,-54.69,-55.91,-57.31,-58.34,-58.03,-57.0,-55.72,-54.22,-51.88,-50.78,-49.09,-47.47,-46.16,-44.53,-42.75,-41.47,-38.84,-38.03,-35.66,-34.34,-33.91,-33.06,-32.72,-33.34,-33.34,-33.66,-34.88,-34.56,-35.53,-35.34,-35.5,-35.81,-35.97,-37.0,-38.72,-40.31,-42.59,-44.28,-44.53,-43.5,-42.97,-39.97,-37.97,-35.81,-33.75,-32.41,-32.16,-32.56,-34.12,-35.75,-37.44,-38.38,-38.66,-39.59,-41.44,-43.31,-45.88,-47.69,-49.09,-48.38,-47.53,-46.31,-43.16,-41.0,-38.31,-34.41,-30.62,-28.06,-25.94,-25.81,-26.75,-28.47,-31.16,-32.66,-34.5,-34.28,-33.72,-32.75,-32.0,-30.59,-29.66,-29.09,-29.66,-29.59,-30.84,-32.03,-32.91,-33.94,-34.53,-33.41,-30.16,-25.97,-21.41,-18.47,-17.16,-18.22,-20.78,-24.72,-26.97,-27.94,-28.03,-27.78,-27.0,-27.81,-26.91,-28.09,-29.0,-30.28,-31.91,-32.59,-33.5,-33.28,-31.44,-30.84,-28.66,-27.19,-26.59,-26.53,-25.84,-26.34,-26.84,-26.62,-27.69,-26.59,-27.94,-28.09,-28.22,-29.22,-29.78,-31.56,-32.84,-34.03,-34.06,-33.66,-33.06,-31.91,-31.09,-30.53,-29.28,-27.72,-25.66,-24.16,-23.19,-22.12,-22.28,-22.25,-22.81,-21.22,-19.94,-18.59,-16.5,-15.16,-13.44,-11.97,-10.41,-10.31,-10.03,-10.03,-10.31,-11.38,-11.25,-11.81,-12.22,-11.84,-12.56,-11.97,-11.72,-12.28,-11.84,-12.72,-13.97,-14.94,-15.78,-16.47,-17.12,-18.78,-18.38,-20.56,-21.66,-23.09,-24.22,-25.25,-26.16,-25.81,-24.94,-23.56,-21.09,-17.78,-15.84,-14.16,-12.16,-12.44,-13.78,-15.12,-18.69,-22.16,-24.94,-28.0,-29.41,-29.62,-29.62,-27.69,-26.72,-25.41,-22.53,-21.12,-19.22,-18.12,-16.94,-15.59,-14.84,-14.44,-13.47,-13.66,-14.47,-14.41,-15.22,-16.16,-15.84,-15.03,-14.34,-13.09,-12.81,-12.19,-11.38,-12.72,-12.72,-14.41,-14.84,-16.0,-16.16,-15.62,-14.59,-13.09,-11.0,-10.34,-9.22,-8.91,-9.78,-10.66,-12.75,-16.09,-18.88,-21.81,-24.66,-25.69,-26.66,-26.53,-26.0,-25.38,-25.47,-24.66,-24.28,-23.47,-22.81,-21.28,-20.03,-18.53,-16.59,-14.78,-14.47,-14.44,-14.59,-14.62,-15.69,-16.66,-18.03,-19.0,-20.66,-22.72,-23.19,-24.22,-24.22,-24.41,-24.03,-23.72,-22.69,-21.75,-20.84,-19.84,-18.16,-17.25,-16.72,-16.25,-16.44,-16.34,-15.66,-15.84,-15.25,-15.19,-15.84,-16.28,-16.16,-17.09,-17.34,-17.22,-18.03,-18.84,-19.03,-19.25,-18.66,-18.38,-18.03,-16.94,-16.88,-15.78,-15.31,-15.41,-14.78,-13.62,-13.53,-12.16,-11.56,-11.19,-10.34,-10.28,-10.78,-10.09,-9.44,-9.59,-10.38,-10.53,-11.44,-12.31,-12.16,-11.62,-9.62,-8.09,-4.5,-0.91,1.19,3.06,2.94,0.09,-2.78,-5.16,-7.56,-7.84,-7.06,-7.28,-6.72,-6.41,-7.94,-7.66,-6.66,-5.72,-2.44,1.06,3.72,5.69,6.72,5.69,4.03,1.69,-0.84,-3.5,-5.78,-6.59,-8.28,-7.47,-8.34,-9.41,-10.59,-13.56,-17.03,-21.16,-34.09,-35.56,-36.91,-36.62,-35.97,-34.59,-32.47,-29.62,-27.72,-25.88,-24.44,-23.78,-23.31,-23.78,-23.91,-24.59,-25.28,-27.62:-22.38,-21.97,-21.09,-19.66,-17.94,-17.66,-17.34,-19.34,-21.44,-22.72,-24.56,-24.66,-24.16,-22.84,-22.47,-20.47,-18.53,-16.91,-16.31,-15.84,-15.84,-16.97,-18.47,-19.03,-19.31,-20.47,-20.34,-21.91,-22.97,-22.91,-24.53,-24.0,-24.41,-24.16,-26.06,-27.72,-30.81,-36.09,-40.22,-43.06,-47.97,-49.84,-53.81,-56.84,-60.41,-63.91,-66.66,-67.56,-68.19,-67.78,-66.28,-64.81,-63.5,-60.22,-57.41,-55.28,-53.28,-52.16,-51.81,-52.09,-52.56,-51.66,-53.06,-53.34,-53.69,-54.47,-54.5,-54.09,-53.69,-52.31,-50.69,-48.53,-46.19,-45.25,-41.28,-40.44,-39.75,-39.75,-40.34,-43.38,-45.94,-48.44,-51.22,-51.19,-51.12,-48.91,-45.47,-45.34,-43.28,-44.72,-46.84,-50.19,-51.91,-51.88,-52.53,-50.5,-48.66,-46.12,-44.0,-43.09,-40.97,-41.09,-41.97,-42.94,-44.16,-45.31,-47.66,-47.19,-46.69,-47.16,-46.41,-46.66,-47.44,-49.69,-51.47,-53.84,-54.97,-55.94,-56.59,-55.34,-55.69,-52.44,-51.62,-49.03,-48.03,-48.16,-48.53,-48.47,-48.34,-48.91,-48.22,-47.84,-49.19,-49.88,-51.44,-50.34,-51.41,-50.47,-50.03,-50.41,-50.62,-50.0,-48.44,-47.34,-45.84,-44.59,-43.81,-42.25,-42.38,-41.59,-40.81,-38.47,-40.12,-39.84,-40.06,-42.59,-43.97,-45.97,-48.34,-49.97,-52.09,-52.31,-53.09,-53.97,-53.94,-52.97,-53.22,-52.41,-52.28,-52.03,-52.0,-53.0,-53.22,-53.31,-54.69,-54.75,-55.72,-55.91,-57.09,-57.22,-58.59,-58.81,-58.72,-58.72,-58.41,-57.16,-56.78,-55.41,-56.47,-56.56,-57.59,-58.34,-58.62,-59.78,-58.09,-57.59,-56.38,-54.59,-53.34,-52.91,-51.47,-51.09,-50.56,-50.66,-49.09,-50.22,-50.88,-50.78,-50.16,-49.72,-48.97,-47.78,-46.81,-47.59,-47.91,-48.88,-50.5,-52.81,-54.47,-55.34,-56.31,-56.59,-55.16,-54.72,-53.22,-51.5,-50.78,-49.59,-50.31,-50.59,-49.84,-50.34,-50.78,-48.41,-49.38,-48.69,-49.84,-50.66,-52.66,-54.5,-56.09,-57.16,-58.0,-59.06,-58.09,-58.53,-57.56,-57.78,-56.09,-53.28,-51.09,-49.34,-47.84,-46.97,-46.91,-48.16,-48.59,-49.31,-50.28,-49.72,-49.91,-50.34,-49.03,-48.06,-47.97,-47.41,-47.94,-47.69,-48.34,-48.88,-49.06,-49.91,-49.72,-49.75,-48.44,-48.47,-48.66,-48.78,-49.44,-50.22,-49.97,-49.38,-50.16,-49.19,-48.84,-49.78,-48.09,-49.09,-48.22,-48.59,-48.69,-49.22,-50.47,-50.03,-50.34,-51.66,-52.22,-52.78,-53.94,-56.22,-57.09,-58.88,-59.53,-59.41,-58.25,-56.91,-54.75,-53.16,-50.84,-50.34,-49.47,-48.47,-50.53,-51.28,-53.59,-55.84,-56.94,-56.81,-56.72,-55.09,-54.72,-52.91,-51.03,-49.0,-46.34,-44.06,-42.38,-41.41,-40.84,-41.41,-42.84,-43.28,-44.38,-43.84,-45.28,-45.38,-45.34,-45.28,-45.62,-46.78,-47.41,-47.56,-49.72,-50.78,-51.28,-50.78,-46.28,-43.44,-38.84,-35.5,-34.53,-33.38,-34.59,-36.22,-37.19,-36.94,-38.0,-38.88,-39.16,-41.03,-42.91,-43.59,-44.84,-46.53,-47.34,-48.59,-49.69,-50.06,-52.06,-52.56,-52.97,-52.81,-52.72,-51.22,-48.78,-47.12,-44.22,-41.72,-39.66,-37.03,-36.53,-35.44,-33.47,-35.88,-36.59,-38.25,-41.53,-44.03,-46.97,-48.78,-50.72,-53.81,-54.66,-56.34,-56.47,-56.53,-55.44,-53.97,-52.62,-49.62,-47.09,-44.97,-41.84,-39.59,-36.69,-33.81,-31.88,-30.97,-31.19,-31.91,-34.5,-37.09,-38.75,-40.31,-41.34,-42.28,-43.22,-43.12,-42.53,-41.66,-40.72,-39.81,-40.97,-41.69,-43.84,-44.34,-44.59,-44.03,-42.09,-39.88,-37.59,-36.28,-34.09,-33.69,-34.31,-35.97,-36.66,-38.78,-40.41,-43.09,-45.53,-49.47,-52.72,-55.72,-57.62,-57.78,-58.06,-57.66,-56.72,-55.81,-55.03,-52.25,-49.5,-45.03,-42.0,-39.56,-38.22,-38.09,-39.81,-41.09,-44.03,-45.72,-46.94,-48.53,-48.66,-49.34,-49.34,-49.59,-49.72,-51.06,-53.0,-54.81,-56.88,-59.44,-59.94,-59.94,-57.81,-55.34,-51.66,-49.22,-47.5,-46.66,-47.72,-49.84,-51.56,-52.94,-54.19,-54.84,-54.31,-52.97,-51.84,-50.09,-47.97,-46.59,-44.69,-42.84,-41.91,-41.69,-42.03,-42.75,-42.88,-44.66,-45.59,-47.91,-49.91,-52.06,-54.69,-55.91,-57.31,-58.34,-58.03,-57.0,-55.72,-54.22,-51.88,-50.78,-49.09,-47.47,-46.16,-44.53,-42.75,-41.47,-38.84,-38.03,-35.66,-34.34,-33.91,-33.06,-32.72,-33.34,-33.34,-33.66,-34.88,-34.56,-35.53,-35.34,-35.5,-35.81,-35.97,-37.0,-38.72,-40.31,-42.59,-44.28,-44.53,-43.5,-42.97,-39.97,-37.97,-35.81,-33.75,-32.41,-32.16,-32.56,-34.12,-35.75,-37.44,-38.38,-38.66,-39.59,-41.44,-43.31,-45.88,-47.69,-49.09,-48.38,-47.53,-46.31,-43.16,-41.0,-38.31,-34.41,-30.62,-28.06,-25.94,-25.81,-26.75,-28.47,-31.16,-32.66,-34.5,-34.28,-33.72,-32.75,-32.0,-30.59,-29.66,-29.09,-29.66,-29.59,-30.84,-32.03,-32.91,-33.94,-34.53,-33.41,-30.16,-25.97,-21.41,-18.47,-17.16,-18.22,-20.78,-24.72,-26.97,-27.94,-28.03,-27.78,-27.0,-27.81,-26.91,-28.09,-29.0,-30.28,-31.91,-32.59,-33.5,-33.28,-31.44,-30.84,-28.66,-27.19,-26.59,-26.53,-25.84,-26.34,-26.84,-26.62,-27.69,-26.59,-27.94,-28.09,-28.22,-29.22,-29.78,-31.56,-32.84,-34.03,-34.06,-33.66,-33.06,-31.91,-31.09,-30.53,-29.28,-27.72,-25.66,-24.16,-23.19,-22.12,-22.28,-22.25,-22.81,-21.22,-19.94,-18.59,-16.5,-15.16,-13.44,-11.97,-10.41,-10.31,-10.03,-10.03,-10.31,-11.38,-11.25,-11.81,-12.22,-11.84,-12.56,-11.97,-11.72,-12.28,-11.84,-12.72,-13.97,-14.94,-15.78,-16.47,-17.12,-18.78,-18.38,-20.56,-21.66,-23.09,-24.22,-25.25,-26.16,-25.81,-24.94,-23.56,-21.09,-17.78,-15.84,-14.16,-12.16,-12.44,-13.78,-15.12,-18.69,-22.16,-24.94,-28.0,-29.41,-29.62,-29.62,-27.69,-26.72,-25.41,-22.53,-21.12,-19.22,-18.12,-16.94,-15.59,-14.84,-14.44,-13.47,-13.66,-14.47,-14.41,-15.22,-16.16,-15.84,-15.03,-14.34,-13.09,-12.81,-12.19,-11.38,-12.72,-12.72,-14.41,-14.84,-16.0,-16.16,-15.62,-14.59,-13.09,-11.0,-10.34,-9.22,-8.91,-9.78,-10.66,-12.75,-16.09,-18.88,-21.81,-24.66,-25.69,-26.66,-26.53,-26.0,-25.38,-25.47,-24.66,-24.28,-23.47,-22.81,-21.28,-20.03,-18.53,-16.59,-14.78,-14.47,-14.44,-14.59,-14.62,-15.69,-16.66,-18.03,-19.0,-20.66,-22.72,-23.19,-24.22,-24.22,-24.41,-24.03,-23.72,-22.69,-21.75,-20.84,-19.84,-18.16,-17.25,-16.72,-16.25,-16.44,-16.34,-15.66,-15.84,-15.25,-15.19,-15.84,-16.28,-16.16,-17.09,-17.34,-17.22,-18.03,-18.84,-19.03,-19.25,-18.66,-18.38,-18.03,-16.94,-16.88,-15.78,-15.31,-15.41,-14.78,-13.62,-13.53,-12.16,-11.56,-11.19,-10.34,-10.28,-10.78,-10.09,-9.44,-9.59,-10.38,-10.53,-11.44,-12.31,-12.16,-11.62,-9.62,-8.09,-4.5,-0.91,1.19,3.06,2.94,0.09,-2.78,-5.16,-7.56,-7.84,-7.06,-7.28,-6.72,-6.41,-7.94,-7.66,-6.66,-5.72,-2.44,1.06,3.72,5.69,6.72,5.69,4.03,1.69,-0.84,-3.5,-5.78,-6.59,-8.28,-7.47,-8.34,-9.41,-10.59,-13.56,-17.03,-21.16,-34.09,-35.56,-36.91,-36.62,-35.97,-34.59,-32.47,-29.62,-27.72,-25.88,-24.44,-23.78,-23.31,-23.78,-23.91,-24.59,-25.28,-27.62,-28.44,-29.62,-30.44,-31.12,-31.0,-30.38:-17.34,-19.34,-21.44,-22.72,-24.56,-24.66,-24.16,-22.84,-22.47,-20.47,-18.53,-16.91,-16.31,-15.84,-15.84,-16.97,-18.47,-19.03,-19.31,-20.47,-20.34,-21.91,-22.97,-22.91,-24.53,-24.0,-24.41,-24.16,-26.06,-27.72,-30.81,-36.09,-40.22,-43.06,-47.97,-49.84,-53.81,-56.84,-60.41,-63.91,-66.66,-67.56,-68.19,-67.78,-66.28,-64.81,-63.5,-60.22,-57.41,-55.28,-53.28,-52.16,-51.81,-52.09,-52.56,-51.66,-53.06,-53.34,-53.69,-54.47,-54.5,-54.09,-53.69,-52.31,-50.69,-48.53,-46.19,-45.25,-41.28,-40.44,-39.75,-39.75,-40.34,-43.38,-45.94,-48.44,-51.22,-51.19,-51.12,-48.91,-45.47,-45.34,-43.28,-44.72,-46.84,-50.19,-51.91,-51.88,-52.53,-50.5,-48.66,-46.12,-44.0,-43.09,-40.97,-41.09,-41.97,-42.94,-44.16,-45.31,-47.66,-47.19,-46.69,-47.16,-46.41,-46.66,-47.44,-49.69,-51.47,-53.84,-54.97,-55.94,-56.59,-55.34,-55.69,-52.44,-51.62,-49.03,-48.03,-48.16,-48.53,-48.47,-48.34,-48.91,-48.22,-47.84,-49.19,-49.88,-51.44,-50.34,-51.41,-50.47,-50.03,-50.41,-50.62,-50.0,-48.44,-47.34,-45.84,-44.59,-43.81,-42.25,-42.38,-41.59,-40.81,-38.47,-40.12,-39.84,-40.06,-42.59,-43.97,-45.97,-48.34,-49.97,-52.09,-52.31,-53.09,-53.97,-53.94,-52.97,-53.22,-52.41,-52.28,-52.03,-52.0,-53.0,-53.22,-53.31,-54.69,-54.75,-55.72,-55.91,-57.09,-57.22,-58.59,-58.81,-58.72,-58.72,-58.41,-57.16,-56.78,-55.41,-56.47,-56.56,-57.59,-58.34,-58.62,-59.78,-58.09,-57.59,-56.38,-54.59,-53.34,-52.91,-51.47,-51.09,-50.56,-50.66,-49.09,-50.22,-50.88,-50.78,-50.16,-49.72,-48.97,-47.78,-46.81,-47.59,-47.91,-48.88,-50.5,-52.81,-54.47,-55.34,-56.31,-56.59,-55.16,-54.72,-53.22,-51.5,-50.78,-49.59,-50.31,-50.59,-49.84,-50.34,-50.78,-48.41,-49.38,-48.69,-49.84,-50.66,-52.66,-54.5,-56.09,-57.16,-58.0,-59.06,-58.09,-58.53,-57.56,-57.78,-56.09,-53.28,-51.09,-49.34,-47.84,-46.97,-46.91,-48.16,-48.59,-49.31,-50.28,-49.72,-49.91,-50.34,-49.03,-48.06,-47.97,-47.41,-47.94,-47.69,-48.34,-48.88,-49.06,-49.91,-49.72,-49.75,-48.44,-48.47,-48.66,-48.78,-49.44,-50.22,-49.97,-49.38,-50.16,-49.19,-48.84,-49.78,-48.09,-49.09,-48.22,-48.59,-48.69,-49.22,-50.47,-50.03,-50.34,-51.66,-52.22,-52.78,-53.94,-56.22,-57.09,-58.88,-59.53,-59.41,-58.25,-56.91,-54.75,-53.16,-50.84,-50.34,-49.47,-48.47,-50.53,-51.28,-53.59,-55.84,-56.94,-56.81,-56.72,-55.09,-54.72,-52.91,-51.03,-49.0,-46.34,-44.06,-42.38,-41.41,-40.84,-41.41,-42.84,-43.28,-44.38,-43.84,-45.28,-45.38,-45.34,-45.28,-45.62,-46.78,-47.41,-47.56,-49.72,-50.78,-51.28,-50.78,-46.28,-43.44,-38.84,-35.5,-34.53,-33.38,-34.59,-36.22,-37.19,-36.94,-38.0,-38.88,-39.16,-41.03,-42.91,-43.59,-44.84,-46.53,-47.34,-48.59,-49.69,-50.06,-52.06,-52.56,-52.97,-52.81,-52.72,-51.22,-48.78,-47.12,-44.22,-41.72,-39.66,-37.03,-36.53,-35.44,-33.47,-35.88,-36.59,-38.25,-41.53,-44.03,-46.97,-48.78,-50.72,-53.81,-54.66,-56.34,-56.47,-56.53,-55.44,-53.97,-52.62,-49.62,-47.09,-44.97,-41.84,-39.59,-36.69,-33.81,-31.88,-30.97,-31.19,-31.91,-34.5,-37.09,-38.75,-40.31,-41.34,-42.28,-43.22,-43.12,-42.53,-41.66,-40.72,-39.81,-40.97,-41.69,-43.84,-44.34,-44.59,-44.03,-42.09,-39.88,-37.59,-36.28,-34.09,-33.69,-34.31,-35.97,-36.66,-38.78,-40.41,-43.09,-45.53,-49.47,-52.72,-55.72,-57.62,-57.78,-58.06,-57.66,-56.72,-55.81,-55.03,-52.25,-49.5,-45.03,-42.0,-39.56,-38.22,-38.09,-39.81,-41.09,-44.03,-45.72,-46.94,-48.53,-48.66,-49.34,-49.34,-49.59,-49.72,-51.06,-53.0,-54.81,-56.88,-59.44,-59.94,-59.94,-57.81,-55.34,-51.66,-49.22,-47.5,-46.66,-47.72,-49.84,-51.56,-52.94,-54.19,-54.84,-54.31,-52.97,-51.84,-50.09,-47.97,-46.59,-44.69,-42.84,-41.91,-41.69,-42.03,-42.75,-42.88,-44.66,-45.59,-47.91,-49.91,-52.06,-54.69,-55.91,-57.31,-58.34,-58.03,-57.0,-55.72,-54.22,-51.88,-50.78,-49.09,-47.47,-46.16,-44.53,-42.75,-41.47,-38.84,-38.03,-35.66,-34.34,-33.91,-33.06,-32.72,-33.34,-33.34,-33.66,-34.88,-34.56,-35.53,-35.34,-35.5,-35.81,-35.97,-37.0,-38.72,-40.31,-42.59,-44.28,-44.53,-43.5,-42.97,-39.97,-37.97,-35.81,-33.75,-32.41,-32.16,-32.56,-34.12,-35.75,-37.44,-38.38,-38.66,-39.59,-41.44,-43.31,-45.88,-47.69,-49.09,-48.38,-47.53,-46.31,-43.16,-41.0,-38.31,-34.41,-30.62,-28.06,-25.94,-25.81,-26.75,-28.47,-31.16,-32.66,-34.5,-34.28,-33.72,-32.75,-32.0,-30.59,-29.66,-29.09,-29.66,-29.59,-30.84,-32.03,-32.91,-33.94,-34.53,-33.41,-30.16,-25.97,-21.41,-18.47,-17.16,-18.22,-20.78,-24.72,-26.97,-27.94,-28.03,-27.78,-27.0,-27.81,-26.91,-28.09,-29.0,-30.28,-31.91,-32.59,-33.5,-33.28,-31.44,-30.84,-28.66,-27.19,-26.59,-26.53,-25.84,-26.34,-26.84,-26.62,-27.69,-26.59,-27.94,-28.09,-28.22,-29.22,-29.78,-31.56,-32.84,-34.03,-34.06,-33.66,-33.06,-31.91,-31.09,-30.53,-29.28,-27.72,-25.66,-24.16,-23.19,-22.12,-22.28,-22.25,-22.81,-21.22,-19.94,-18.59,-16.5,-15.16,-13.44,-11.97,-10.41,-10.31,-10.03,-10.03,-10.31,-11.38,-11.25,-11.81,-12.22,-11.84,-12.56,-11.97,-11.72,-12.28,-11.84,-12.72,-13.97,-14.94,-15.78,-16.47,-17.12,-18.78,-18.38,-20.56,-21.66,-23.09,-24.22,-25.25,-26.16,-25.81,-24.94,-23.56,-21.09,-17.78,-15.84,-14.16,-12.16,-12.44,-13.78,-15.12,-18.69,-22.16,-24.94,-28.0,-29.41,-29.62,-29.62,-27.69,-26.72,-25.41,-22.53,-21.12,-19.22,-18.12,-16.94,-15.59,-14.84,-14.44,-13.47,-13.66,-14.47,-14.41,-15.22,-16.16,-15.84,-15.03,-14.34,-13.09,-12.81,-12.19,-11.38,-12.72,-12.72,-14.41,-14.84,-16.0,-16.16,-15.62,-14.59,-13.09,-11.0,-10.34,-9.22,-8.91,-9.78,-10.66,-12.75,-16.09,-18.88,-21.81,-24.66,-25.69,-26.66,-26.53,-26.0,-25.38,-25.47,-24.66,-24.28,-23.47,-22.81,-21.28,-20.03,-18.53,-16.59,-14.78,-14.47,-14.44,-14.59,-14.62,-15.69,-16.66,-18.03,-19.0,-20.66,-22.72,-23.19,-24.22,-24.22,-24.41,-24.03,-23.72,-22.69,-21.75,-20.84,-19.84,-18.16,-17.25,-16.72,-16.25,-16.44,-16.34,-15.66,-15.84,-15.25,-15.19,-15.84,-16.28,-16.16,-17.09,-17.34,-17.22,-18.03,-18.84,-19.03,-19.25,-18.66,-18.38,-18.03,-16.94,-16.88,-15.78,-15.31,-15.41,-14.78,-13.62,-13.53,-12.16,-11.56,-11.19,-10.34,-10.28,-10.78,-10.09,-9.44,-9.59,-10.38,-10.53,-11.44,-12.31,-12.16,-11.62,-9.62,-8.09,-4.5,-0.91,1.19,3.06,2.94,0.09,-2.78,-5.16,-7.56,-7.84,-7.06,-7.28,-6.72,-6.41,-7.94,-7.66,-6.66,-5.72,-2.44,1.06,3.72,5.69,6.72,5.69,4.03,1.69,-0.84,-3.5,-5.78,-6.59,-8.28,-7.47,-8.34,-9.41,-10.59,-13.56,-17.03,-21.16,-34.09,-35.56,-36.91,-36.62,-35.97,-34.59,-32.47,-29.62,-27.72,-25.88,-24.44,-23.78,-23.31,-23.78,-23.91,-24.59,-25.28,-27.62,-28.44,-29.62,-30.44,-31.12,-31.0,-30.38,-29.97,-29.25,-27.66,-26.19,-24.81,-24.66:positivity
11.5,13.97,18.06,19.91,20.78,21.53,20.69,19.12,18.0,16.84,15.78,14.84,13.31,13.25,13.66,14.44,16.75,18.0,19.75,19.78,19.69,18.56,17.44,16.84,15.69,14.94,14.62,13.62,13.66,13.0,13.62,13.56,13.94,14.75,16.69,15.91,17.12,17.41,16.62,15.88,16.25,15.91,16.38,17.91,16.91,17.12,15.06,12.78,13.31,10.59,11.06,9.53,10.94,10.03,11.31,11.03,9.94,11.72,10.31,10.53,11.59,10.03,9.62,8.91,8.06,6.62,7.41,6.97,7.25,7.81,7.91,8.44,7.69,6.69,5.12,2.16,1.44,-1.16,-0.72,-0.78,-0.47,2.06,2.31,3.88,5.81,6.81,7.38,9.5,8.25,9.25,8.81,7.06,6.44,3.34,1.94,1.47,0.78,0.44,1.84,3.41,3.66,5.03,5.62,7.28,8.09,7.62,7.41,7.84,7.0,7.12,7.25,8.19,9.56,10.78,11.94,11.91,11.38,12.34,11.19,12.0,12.25,10.75,11.75,11.59,12.97,15.19,17.16,17.66,18.97,18.97,18.56,19.16,18.59,18.03,15.56,11.81,12.19,9.91,10.44,11.88,12.59,13.41,14.38,13.34,12.94,13.28,11.81,13.22,12.25,13.0,13.84,14.81,13.97,16.12,16.06,15.38,14.84,13.59,11.22,10.47,9.38,6.31,4.78,3.69,2.62,2.09,2.56,4.03,6.53,7.0,8.12,12.34,12.69,14.06,17.12,17.47,17.31,17.56,16.72,17.09,15.12,14.28,13.22,11.91,10.53,11.62,12.12,12.5,14.38,15.66,16.5,17.28,18.25,19.72,18.81,19.56,17.94,18.16,15.84,16.03,16.12,16.25,18.53,20.34,23.03,24.56,26.19,27.06,27.78,26.56,26.12,24.59,25.5,23.06,23.44,21.5,20.44,19.38,17.06,16.69,14.62,16.31,16.88,19.06,20.81,20.88,21.56,20.59,18.97,18.69,20.41,21.25,23.25,25.94,26.91,27.16,26.5,25.31,21.94,21.62,19.91,18.41,17.34,15.78,15.34,12.69,15.12,15.0,15.62,17.25,16.41,18.19,16.69,18.12,19.28,19.75,20.56,19.88,19.59,20.47,21.25,19.97,22.62,23.06,24.06,26.72,26.88,27.47,27.44,25.44,24.69,22.78,21.22,23.16,21.25,22.41,21.69,21.88,21.31,21.47,20.31,20.16,19.91,18.81,18.44,17.66,18.88,20.84,24.09,26.94,30.0,31.91,33.12,33.19,32.19,31.88,29.84,26.06,25.75,23.44,21.94,21.59,20.91,20.28,18.59,16.81,15.69,14.94,14.06,15.16,15.88,17.44,17.31,16.47,15.72,13.94,14.09,14.0,14.22,16.28,15.53,14.91,13.34,11.25,9.78,9.88,10.53,11.41,13.78,14.69,16.62,18.94,20.88,23.94,26.78,28.69,31.12,31.75,31.81,31.59,33.03,31.16,30.5,30.91,30.5,30.0,30.44,29.38,27.75,24.94,23.88,19.81,20.25,18.56,17.06,17.41,17.28,15.47,17.31,17.25,16.06,17.19,15.91,15.94,14.91,15.22,15.28,13.38,14.19,12.5,11.94,11.56,10.56,11.41,11.56,11.25,10.28,9.91,10.12,8.88,9.28,8.84,10.34,10.69,11.81,12.91,13.91,14.06,13.66,14.91,13.81,15.0,16.44,17.59,18.16,19.03,20.22,20.25,20.66,19.56,18.66,17.84,15.22,14.03,13.62,15.75,17.44,19.12,20.81,22.38,22.56,23.72,23.78,27.0,29.5,31.09,32.16,33.94,31.81,29.69,28.16,26.44,25.12,25.12,24.09,22.94,21.16,18.75,17.31,15.03,15.69,14.38,16.34,17.78,19.81,22.56,24.84,25.31,25.44,26.28,23.88,22.28,19.53,16.34,13.97,10.12,8.06,9.47,10.25,11.22,15.06,16.41,18.69,20.97,23.06,24.66,27.0,27.81,29.0,27.94,28.34,26.75,25.72,24.59,21.41,21.97,20.38,19.81,20.12,20.06,19.66,19.31,19.44,17.34,17.53,16.38,15.84,17.56,19.06,21.34,23.06,26.28,26.5,26.53,26.28,24.84,22.69,22.69,19.78,20.31,20.53,20.94,22.31,23.56,24.38,24.59,24.12,22.94,22.97,22.31,22.28,21.84,22.22,20.75,19.62,18.34,16.28,15.84,14.31,14.53,14.16,13.16,14.19,13.5,12.25,11.34,13.16,12.59,13.56,15.62,15.34,13.75,10.53,7.69,5.62,1.81,0.53,-1.16,0.53,0.44,3.56,4.84,7.44,9.31,9.78,10.56,8.88,10.47,9.16,8.78,10.72,9.44,11.94,13.19,14.44,16.12,15.53,15.47,14.12,13.56,13.91,14.16,14.5,15.19,14.12,12.75,11.53,9.97,8.75,8.22,6.06,7.44,7.94,8.56,10.5,10.81,12.34,11.84,11.41,10.78,9.88,9.88,9.38,8.94,9.19,9.09,9.38,9.09,9.5,10.84,11.16,13.25,14.34,15.81,18.47,19.84,21.0,21.41,20.56,20.84,19.16,17.66,16.41,14.22,12.72,13.88,15.19,17.28,19.47,19.69,19.09,18.97,17.69,18.09,19.06,20.56,20.19,19.38,18.25,17.06,14.41,14.91,14.03,12.88,14.81,14.56,14.66,15.78,17.03,16.28,15.91,16.03,15.78,14.84,14.56,12.38,11.16,10.09,9.38,8.38,8.03,7.41,7.34,6.25,7.06,7.97,9.75,11.94,13.69,13.97,13.97,13.03,12.16,12.41,13.66,17.38,20.19,24.59,26.5,28.19,28.16,24.0,21.41,17.09,12.91,11.69,11.44,12.69,13.22,15.03,15.06,14.62,13.41,13.72,13.16,12.53,12.94,11.78,10.56,8.66,7.69,5.06,4.56,5.41,6.0,6.25,7.19,5.88,4.19,1.12,0.06,-1.41,-2.41,-2.44,-1.22,0.03,0.16,1.81,4.53,4.44,5.19,4.94,4.91,5.62,8.28,8.84,12.31,15.72,17.03,19.69,20.84,20.31,19.56,17.56,14.97,12.84,10.5,9.03,8.69,9.03,10.06,11.31,12.5,12.5,12.97,12.47,12.81,13.91,16.38,19.12,22.03,23.06,23.12,21.25,18.16,15.62,12.03,8.91,6.12,3.84,1.81,0.28,0.09,0.41,2.38,4.78,7.25,9.69,12.09,14.31,16.19,18.03,20.34,20.94,22.59,23.31,21.56,19.94,16.69,12.84,8.81,4.53,1.53,-1.94,-3.81,-5.81,-6.34,-5.09,-3.31,-0.28,3.81,5.94,9.88,12.06,13.56,14.41,16.44,15.44,15.38,15.44,14.75,14.16,12.31,11.25,9.5,7.53,6.12,6.5,7.22,9.5,10.59,12.34,13.25,13.44,13.19,10.69,9.78,6.72,5.19,3.78,2.16,2.72,2.84,4.31,5.06,6.22,7.62,7.72,8.62,8.5,8.81,8.81,9.38,9.25,8.75,9.03,7.59,8.5,8.41,8.16,7.28,9.06,9.41,10.34,12.75,12.88,15.62,16.75,17.03,18.81,19.91,19.5,19.12,17.84,14.62,14.22,11.59,10.66,10.44,11.03,11.41,12.66,13.16,12.94,12.44,13.12,12.19,11.06,11.28,11.19,10.91,11.84,12.81,12.69,13.19,13.59,12.38,11.12,12.41,11.38,11.47,12.06,12.56,12.62,14.81,16.0,16.94,17.78,18.41,17.41,16.78,15.12,13.94,13.12,12.16,10.88,10.62,11.78,12.38,13.5,14.03,14.19,13.44,13.19,12.34,12.38,12.75,14.19,15.12,17.81,19.53,21.97,23.97,24.72,23.28,20.34,17.84,16.41,14.47,14.66,14.44,14.94,14.28,12.84,11.81,10.44:20.69,19.12,18.0,16.84,15.78,14.84,13.31,13.25,13.66,14.44,16.75,18.0,19.75,19.78,19.69,18.56,17.44,16.84,15.69,14.94,14.62,13.62,13.66,13.0,13.62,13.56,13.94,14.75,16.69,15.91,17.12,17.41,16.62,15.88,16.25,15.91,16.38,17.91,16.91,17.12,15.06,12.78,13.31,10.59,11.06,9.53,10.94,10.03,11.31,11.03,9.94,11.72,10.31,10.53,11.59,10.03,9.62,8.91,8.06,6.62,7.41,6.97,7.25,7.81,7.91,8.44,7.69,6.69,5.12,2.16,1.44,-1.16,-0.72,-0.78,-0.47,2.06,2.31,3.88,5.81,6.81,7.38,9.5,8.25,9.25,8.81,7.06,6.44,3.34,1.94,1.47,0.78,0.44,1.84,3.41,3.66,5.03,5.62,7.28,8.09,7.62,7.41,7.84,7.0,7.12,7.25,8.19,9.56,10.78,11.94,11.91,11.38,12.34,11.19,12.0,12.25,10.75,11.75,11.59,12.97,15.19,17.16,17.66,18.97,18.97,18.56,19.16,18.59,18.03,15.56,11.81,12.19,9.91,10.44,11.88,12.59,13.41,14.38,13.34,12.94,13.28,11.81,13.22,12.25,13.0,13.84,14.81,13.97,16.12,16.06,15.38,14.84,13.59,11.22,10.47,9.38,6.31,4.78,3.69,2.62,2.09,2.56,4.03,6.53,7.0,8.12,12.34,12.69,14.06,17.12,17.47,17.31,17.56,16.72,17.09,15.12,14.28,13.22,11.91,10.53,11.62,12.12,12.5,14.38,15.66,16.5,17.28,18.25,19.72,18.81,19.56,17.94,18.16,15.84,16.03,16.12,16.25,18.53,20.34,23.03,24.56,26.19,27.06,27.78,26.56,26.12,24.59,25.5,23.06,23.44,21.5,20.44,19.38,17.06,16.69,14.62,16.31,16.88,19.06,20.81,20.88,21.56,20.59,18.97,18.69,20.41,21.25,23.25,25.94,26.91,27.16,26.5,25.31,21.94,21.62,19.91,18.41,17.34,15.78,15.34,12.69,15.12,15.0,15.62,17.25,16.41,18.19,16.69,18.12,19.28,19.75,20.56,19.88,19.59,20.47,21.25,19.97,22.62,23.06,24.06,26.72,26.88,27.47,27.44,25.44,24.69,22.78,21.22,23.16,21.25,22.41,21.69,21.88,21.31,21.47,20.31,20.16,19.91,18.81,18.44,17.66,18.88,20.84,24.09,26.94,30.0,31.91,33.12,33.19,32.19,31.88,29.84,26.06,25.75,23.44,21.94,21.59,20.91,20.28,18.59,16.81,15.69,14.94,14.06,15.16,15.88,17.44,17.31,16.47,15.72,13.94,14.09,14.0,14.22,16.28,15.53,14.91,13.34,11.25,9.78,9.88,10.53,11.41,13.78,14.69,16.62,18.94,20.88,23.94,26.78,28.69,31.12,31.75,31.81,31.59,33.03,31.16,30.5,30.91,30.5,30.0,30.44,29.38,27.75,24.94,23.88,19.81,20.25,18.56,17.06,17.41,17.28,15.47,17.31,17.25,16.06,17.19,15.91,15.94,14.91,15.22,15.28,13.38,14.19,12.5,11.94,11.56,10.56,11.41,11.56,11.25,10.28,9.91,10.12,8.88,9.28,8.84,10.34,10.69,11.81,12.91,13.91,14.06,13.66,14.91,13.81,15.0,16.44,17.59,18.16,19.03,20.22,20.25,20.66,19.56,18.66,17.84,15.22,14.03,13.62,15.75,17.44,19.12,20.81,22.38,22.56,23.72,23.78,27.0,29.5,31.09,32.16,33.94,31.81,29.69,28.16,26.44,25.12,25.12,24.09,22.94,21.16,18.75,17.31,15.03,15.69,14.38,16.34,17.78,19.81,22.56,24.84,25.31,25.44,26.28,23.88,22.28,19.53,16.34,13.97,10.12,8.06,9.47,10.25,11.22,15.06,16.41,18.69,20.97,23.06,24.66,27.0,27.81,29.0,27.94,28.34,26.75,25.72,24.59,21.41,21.97,20.38,19.81,20.12,20.06,19.66,19.31,19.44,17.34,17.53,16.38,15.84,17.56,19.06,21.34,23.06,26.28,26.5,26.53,26.28,24.84,22.69,22.69,19.78,20.31,20.53,20.94,22.31,23.56,24.38,24.59,24.12,22.94,22.97,22.31,22.28,21.84,22.22,20.75,19.62,18.34,16.28,15.84,14.31,14.53,14.16,13.16,14.19,13.5,12.25,11.34,13.16,12.59,13.56,15.62,15.34,13.75,10.53,7.69,5.62,1.81,0.53,-1.16,0.53,0.44,3.56,4.84,7.44,9.31,9.78,10.56,8.88,10.47,9.16,8.78,10.72,9.44,11.94,13.19,14.44,16.12,15.53,15.47,14.12,13.56,13.91,14.16,14.5,15.19,14.12,12.75,11.53,9.97,8.75,8.22,6.06,7.44,7.94,8.56,10.5,10.81,12.34,11.84,11.41,10.78,9.88,9.88,9.38,8.94,9.19,9.09,9.38,9.09,9.5,10.84,11.16,13.25,14.34,15.81,18.47,19.84,21.0,21.41,20.56,20.84,19.16,17.66,16.41,14.22,12.72,13.88,15.19,17.28,19.47,19.69,19.09,18.97,17.69,18.09,19.06,20.56,20.19,19.38,18.25,17.06,14.41,14.91,14.03,12.88,14.81,14.56,14.66,15.78,17.03,16.28,15.91,16.03,15.78,14.84,14.56,12.38,11.16,10.09,9.38,8.38,8.03,7.41,7.34,6.25,7.06,7.97,9.75,11.94,13.69,13.97,13.97,13.03,12.16,12.41,13.66,17.38,20.19,24.59,26.5,28.19,28.16,24.0,21.41,17.09,12.91,11.69,11.44,12.69,13.22,15.03,15.06,14.62,13.41,13.72,13.16,12.53,12.94,11.78,10.56,8.66,7.69,5.06,4.56,5.41,6.0,6.25,7.19,5.88,4.19,1.12,0.06,-1.41,-2.41,-2.44,-1.22,0.03,0.16,1.81,4.53,4.44,5.19,4.94,4.91,5.62,8.28,8.84,12.31,15.72,17.03,19.69,20.84,20.31,19.56,17.56,14.97,12.84,10.5,9.03,8.69,9.03,10.06,11.31,12.5,12.5,12.97,12.47,12.81,13.91,16.38,19.12,22.03,23.06,23.12,21.25,18.16,15.62,12.03,8.91,6.12,3.84,1.81,0.28,0.09,0.41,2.38,4.78,7.25,9.69,12.09,14.31,16.19,18.03,20.34,20.94,22.59,23.31,21.56,19.94,16.69,12.84,8.81,4.53,1.53,-1.94,-3.81,-5.81,-6.34,-5.09,-3.31,-0.28,3.81,5.94,9.88,12.06,13.56,14.41,16.44,15.44,15.38,15.44,14.75,14.16,12.31,11.25,9.5,7.53,6.12,6.5,7.22,9.5,10.59,12.34,13.25,13.44,13.19,10.69,9.78,6.72,5.19,3.78,2.16,2.72,2.84,4.31,5.06,6.22,7.62,7.72,8.62,8.5,8.81,8.81,9.38,9.25,8.75,9.03,7.59,8.5,8.41,8.16,7.28,9.06,9.41,10.34,12.75,12.88,15.62,16.75,17.03,18.81,19.91,19.5,19.12,17.84,14.62,14.22,11.59,10.66,10.44,11.03,11.41,12.66,13.16,12.94,12.44,13.12,12.19,11.06,11.28,11.19,10.91,11.84,12.81,12.69,13.19,13.59,12.38,11.12,12.41,11.38,11.47,12.06,12.56,12.62,14.81,16.0,16.94,17.78,18.41,17.41,16.78,15.12,13.94,13.12,12.16,10.88,10.62,11.78,12.38,13.5,14.03,14.19,13.44,13.19,12.34,12.38,12.75,14.19,15.12,17.81,19.53,21.97,23.97,24.72,23.28,20.34,17.84,16.41,14.47,14.66,14.44,14.94,14.28,12.84,11.81,10.44,17.25,22.28,26.31,30.72,33.03,33.91:13.31,13.25,13.66,14.44,16.75,18.0,19.75,19.78,19.69,18.56,17.44,16.84,15.69,14.94,14.62,13.62,13.66,13.0,13.62,13.56,13.94,14.75,16.69,15.91,17.12,17.41,16.62,15.88,16.25,15.91,16.38,17.91,16.91,17.12,15.06,12.78,13.31,10.59,11.06,9.53,10.94,10.03,11.31,11.03,9.94,11.72,10.31,10.53,11.59,10.03,9.62,8.91,8.06,6.62,7.41,6.97,7.25,7.81,7.91,8.44,7.69,6.69,5.12,2.16,1.44,-1.16,-0.72,-0.78,-0.47,2.06,2.31,3.88,5.81,6.81,7.38,9.5,8.25,9.25,8.81,7.06,6.44,3.34,1.94,1.47,0.78,0.44,1.84,3.41,3.66,5.03,5.62,7.28,8.09,7.62,7.41,7.84,7.0,7.12,7.25,8.19,9.56,10.78,11.94,11.91,11.38,12.34,11.19,12.0,12.25,10.75,11.75,11.59,12.97,15.19,17.16,17.66,18.97,18.97,18.56,19.16,18.59,18.03,15.56,11.81,12.19,9.91,10.44,11.88,12.59,13.41,14.38,13.34,12.94,13.28,11.81,13.22,12.25,13.0,13.84,14.81,13.97,16.12,16.06,15.38,14.84,13.59,11.22,10.47,9.38,6.31,4.78,3.69,2.62,2.09,2.56,4.03,6.53,7.0,8.12,12.34,12.69,14.06,17.12,17.47,17.31,17.56,16.72,17.09,15.12,14.28,13.22,11.91,10.53,11.62,12.12,12.5,14.38,15.66,16.5,17.28,18.25,19.72,18.81,19.56,17.94,18.16,15.84,16.03,16.12,16.25,18.53,20.34,23.03,24.56,26.19,27.06,27.78,26.56,26.12,24.59,25.5,23.06,23.44,21.5,20.44,19.38,17.06,16.69,14.62,16.31,16.88,19.06,20.81,20.88,21.56,20.59,18.97,18.69,20.41,21.25,23.25,25.94,26.91,27.16,26.5,25.31,21.94,21.62,19.91,18.41,17.34,15.78,15.34,12.69,15.12,15.0,15.62,17.25,16.41,18.19,16.69,18.12,19.28,19.75,20.56,19.88,19.59,20.47,21.25,19.97,22.62,23.06,24.06,26.72,26.88,27.47,27.44,25.44,24.69,22.78,21.22,23.16,21.25,22.41,21.69,21.88,21.31,21.47,20.31,20.16,19.91,18.81,18.44,17.66,18.88,20.84,24.09,26.94,30.0,31.91,33.12,33.19,32.19,31.88,29.84,26.06,25.75,23.44,21.94,21.59,20.91,20.28,18.59,16.81,15.69,14.94,14.06,15.16,15.88,17.44,17.31,16.47,15.72,13.94,14.09,14.0,14.22,16.28,15.53,14.91,13.34,11.25,9.78,9.88,10.53,11.41,13.78,14.69,16.62,18.94,20.88,23.94,26.78,28.69,31.12,31.75,31.81,31.59,33.03,31.16,30.5,30.91,30.5,30.0,30.44,29.38,27.75,24.94,23.88,19.81,20.25,18.56,17.06,17.41,17.28,15.47,17.31,17.25,16.06,17.19,15.91,15.94,14.91,15.22,15.28,13.38,14.19,12.5,11.94,11.56,10.56,11.41,11.56,11.25,10.28,9.91,10.12,8.88,9.28,8.84,10.34,10.69,11.81,12.91,13.91,14.06,13.66,14.91,13.81,15.0,16.44,17.59,18.16,19.03,20.22,20.25,20.66,19.56,18.66,17.84,15.22,14.03,13.62,15.75,17.44,19.12,20.81,22.38,22.56,23.72,23.78,27.0,29.5,31.09,32.16,33.94,31.81,29.69,28.16,26.44,25.12,25.12,24.09,22.94,21.16,18.75,17.31,15.03,15.69,14.38,16.34,17.78,19.81,22.56,24.84,25.31,25.44,26.28,23.88,22.28,19.53,16.34,13.97,10.12,8.06,9.47,10.25,11.22,15.06,16.41,18.69,20.97,23.06,24.66,27.0,27.81,29.0,27.94,28.34,26.75,25.72,24.59,21.41,21.97,20.38,19.81,20.12,20.06,19.66,19.31,19.44,17.34,17.53,16.38,15.84,17.56,19.06,21.34,23.06,26.28,26.5,26.53,26.28,24.84,22.69,22.69,19.78,20.31,20.53,20.94,22.31,23.56,24.38,24.59,24.12,22.94,22.97,22.31,22.28,21.84,22.22,20.75,19.62,18.34,16.28,15.84,14.31,14.53,14.16,13.16,14.19,13.5,12.25,11.34,13.16,12.59,13.56,15.62,15.34,13.75,10.53,7.69,5.62,1.81,0.53,-1.16,0.53,0.44,3.56,4.84,7.44,9.31,9.78,10.56,8.88,10.47,9.16,8.78,10.72,9.44,11.94,13.19,14.44,16.12,15.53,15.47,14.12,13.56,13.91,14.16,14.5,15.19,14.12,12.75,11.53,9.97,8.75,8.22,6.06,7.44,7.94,8.56,10.5,10.81,12.34,11.84,11.41,10.78,9.88,9.88,9.38,8.94,9.19,9.09,9.38,9.09,9.5,10.84,11.16,13.25,14.34,15.81,18.47,19.84,21.0,21.41,20.56,20.84,19.16,17.66,16.41,14.22,12.72,13.88,15.19,17.28,19.47,19.69,19.09,18.97,17.69,18.09,19.06,20.56,20.19,19.38,18.25,17.06,14.41,14.91,14.03,12.88,14.81,14.56,14.66,15.78,17.03,16.28,15.91,16.03,15.78,14.84,14.56,12.38,11.16,10.09,9.38,8.38,8.03,7.41,7.34,6.25,7.06,7.97,9.75,11.94,13.69,13.97,13.97,13.03,12.16,12.41,13.66,17.38,20.19,24.59,26.5,28.19,28.16,24.0,21.41,17.09,12.91,11.69,11.44,12.69,13.22,15.03,15.06,14.62,13.41,13.72,13.16,12.53,12.94,11.78,10.56,8.66,7.69,5.06,4.56,5.41,6.0,6.25,7.19,5.88,4.19,1.12,0.06,-1.41,-2.41,-2.44,-1.22,0.03,0.16,1.81,4.53,4.44,5.19,4.94,4.91,5.62,8.28,8.84,12.31,15.72,17.03,19.69,20.84,20.31,19.56,17.56,14.97,12.84,10.5,9.03,8.69,9.03,10.06,11.31,12.5,12.5,12.97,12.47,12.81,13.91,16.38,19.12,22.03,23.06,23.12,21.25,18.16,15.62,12.03,8.91,6.12,3.84,1.81,0.28,0.09,0.41,2.38,4.78,7.25,9.69,12.09,14.31,16.19,18.03,20.34,20.94,22.59,23.31,21.56,19.94,16.69,12.84,8.81,4.53,1.53,-1.94,-3.81,-5.81,-6.34,-5.09,-3.31,-0.28,3.81,5.94,9.88,12.06,13.56,14.41,16.44,15.44,15.38,15.44,14.75,14.16,12.31,11.25,9.5,7.53,6.12,6.5,7.22,9.5,10.59,12.34,13.25,13.44,13.19,10.69,9.78,6.72,5.19,3.78,2.16,2.72,2.84,4.31,5.06,6.22,7.62,7.72,8.62,8.5,8.81,8.81,9.38,9.25,8.75,9.03,7.59,8.5,8.41,8.16,7.28,9.06,9.41,10.34,12.75,12.88,15.62,16.75,17.03,18.81,19.91,19.5,19.12,17.84,14.62,14.22,11.59,10.66,10.44,11.03,11.41,12.66,13.16,12.94,12.44,13.12,12.19,11.06,11.28,11.19,10.91,11.84,12.81,12.69,13.19,13.59,12.38,11.12,12.41,11.38,11.47,12.06,12.56,12.62,14.81,16.0,16.94,17.78,18.41,17.41,16.78,15.12,13.94,13.12,12.16,10.88,10.62,11.78,12.38,13.5,14.03,14.19,13.44,13.19,12.34,12.38,12.75,14.19,15.12,17.81,19.53,21.97,23.97,24.72,23.28,20.34,17.84,16.41,14.47,14.66,14.44,14.94,14.28,12.84,11.81,10.44,17.25,22.28,26.31,30.72,33.03,33.91,33.5,32.94,31.31,30.41,30.28,29.59:19.75,19.78,19.69,18.56,17.44,16.84,15.69,14.94,14.62,13.62,13.66,13.0,13.62,13.56,13.94,14.75,16.69,15.91,17.12,17.41,16.62,15.88,16.25,15.91,16.38,17.91,16.91,17.12,15.06,12.78,13.31,10.59,11.06,9.53,10.94,10.03,11.31,11.03,9.94,11.72,10.31,10.53,11.59,10.03,9.62,8.91,8.06,6.62,7.41,6.97,7.25,7.81,7.91,8.44,7.69,6.69,5.12,2.16,1.44,-1.16,-0.72,-0.78,-0.47,2.06,2.31,3.88,5.81,6.81,7.38,9.5,8.25,9.25,8.81,7.06,6.44,3.34,1.94,1.47,0.78,0.44,1.84,3.41,3.66,5.03,5.62,7.28,8.09,7.62,7.41,7.84,7.0,7.12,7.25,8.19,9.56,10.78,11.94,11.91,11.38,12.34,11.19,12.0,12.25,10.75,11.75,11.59,12.97,15.19,17.16,17.66,18.97,18.97,18.56,19.16,18.59,18.03,15.56,11.81,12.19,9.91,10.44,11.88,12.59,13.41,14.38,13.34,12.94,13.28,11.81,13.22,12.25,13.0,13.84,14.81,13.97,16.12,16.06,15.38,14.84,13.59,11.22,10.47,9.38,6.31,4.78,3.69,2.62,2.09,2.56,4.03,6.53,7.0,8.12,12.34,12.69,14.06,17.12,17.47,17.31,17.56,16.72,17.09,15.12,14.28,13.22,11.91,10.53,11.62,12.12,12.5,14.38,15.66,16.5,17.28,18.25,19.72,18.81,19.56,17.94,18.16,15.84,16.03,16.12,16.25,18.53,20.34,23.03,24.56,26.19,27.06,27.78,26.56,26.12,24.59,25.5,23.06,23.44,21.5,20.44,19.38,17.06,16.69,14.62,16.31,16.88,19.06,20.81,20.88,21.56,20.59,18.97,18.69,20.41,21.25,23.25,25.94,26.91,27.16,26.5,25.31,21.94,21.62,19.91,18.41,17.34,15.78,15.34,12.69,15.12,15.0,15.62,17.25,16.41,18.19,16.69,18.12,19.28,19.75,20.56,19.88,19.59,20.47,21.25,19.97,22.62,23.06,24.06,26.72,26.88,27.47,27.44,25.44,24.69,22.78,21.22,23.16,21.25,22.41,21.69,21.88,21.31,21.47,20.31,20.16,19.91,18.81,18.44,17.66,18.88,20.84,24.09,26.94,30.0,31.91,33.12,33.19,32.19,31.88,29.84,26.06,25.75,23.44,21.94,21.59,20.91,20.28,18.59,16.81,15.69,14.94,14.06,15.16,15.88,17.44,17.31,16.47,15.72,13.94,14.09,14.0,14.22,16.28,15.53,14.91,13.34,11.25,9.78,9.88,10.53,11.41,13.78,14.69,16.62,18.94,20.88,23.94,26.78,28.69,31.12,31.75,31.81,31.59,33.03,31.16,30.5,30.91,30.5,30.0,30.44,29.38,27.75,24.94,23.88,19.81,20.25,18.56,17.06,17.41,17.28,15.47,17.31,17.25,16.06,17.19,15.91,15.94,14.91,15.22,15.28,13.38,14.19,12.5,11.94,11.56,10.56,11.41,11.56,11.25,10.28,9.91,10.12,8.88,9.28,8.84,10.34,10.69,11.81,12.91,13.91,14.06,13.66,14.91,13.81,15.0,16.44,17.59,18.16,19.03,20.22,20.25,20.66,19.56,18.66,17.84,15.22,14.03,13.62,15.75,17.44,19.12,20.81,22.38,22.56,23.72,23.78,27.0,29.5,31.09,32.16,33.94,31.81,29.69,28.16,26.44,25.12,25.12,24.09,22.94,21.16,18.75,17.31,15.03,15.69,14.38,16.34,17.78,19.81,22.56,24.84,25.31,25.44,26.28,23.88,22.28,19.53,16.34,13.97,10.12,8.06,9.47,10.25,11.22,15.06,16.41,18.69,20.97,23.06,24.66,27.0,27.81,29.0,27.94,28.34,26.75,25.72,24.59,21.41,21.97,20.38,19.81,20.12,20.06,19.66,19.31,19.44,17.34,17.53,16.38,15.84,17.56,19.06,21.34,23.06,26.28,26.5,26.53,26.28,24.84,22.69,22.69,19.78,20.31,20.53,20.94,22.31,23.56,24.38,24.59,24.12,22.94,22.97,22.31,22.28,21.84,22.22,20.75,19.62,18.34,16.28,15.84,14.31,14.53,14.16,13.16,14.19,13.5,12.25,11.34,13.16,12.59,13.56,15.62,15.34,13.75,10.53,7.69,5.62,1.81,0.53,-1.16,0.53,0.44,3.56,4.84,7.44,9.31,9.78,10.56,8.88,10.47,9.16,8.78,10.72,9.44,11.94,13.19,14.44,16.12,15.53,15.47,14.12,13.56,13.91,14.16,14.5,15.19,14.12,12.75,11.53,9.97,8.75,8.22,6.06,7.44,7.94,8.56,10.5,10.81,12.34,11.84,11.41,10.78,9.88,9.88,9.38,8.94,9.19,9.09,9.38,9.09,9.5,10.84,11.16,13.25,14.34,15.81,18.47,19.84,21.0,21.41,20.56,20.84,19.16,17.66,16.41,14.22,12.72,13.88,15.19,17.28,19.47,19.69,19.09,18.97,17.69,18.09,19.06,20.56,20.19,19.38,18.25,17.06,14.41,14.91,14.03,12.88,14.81,14.56,14.66,15.78,17.03,16.28,15.91,16.03,15.78,14.84,14.56,12.38,11.16,10.09,9.38,8.38,8.03,7.41,7.34,6.25,7.06,7.97,9.75,11.94,13.69,13.97,13.97,13.03,12.16,12.41,13.66,17.38,20.19,24.59,26.5,28.19,28.16,24.0,21.41,17.09,12.91,11.69,11.44,12.69,13.22,15.03,15.06,14.62,13.41,13.72,13.16,12.53,12.94,11.78,10.56,8.66,7.69,5.06,4.56,5.41,6.0,6.25,7.19,5.88,4.19,1.12,0.06,-1.41,-2.41,-2.44,-1.22,0.03,0.16,1.81,4.53,4.44,5.19,4.94,4.91,5.62,8.28,8.84,12.31,15.72,17.03,19.69,20.84,20.31,19.56,17.56,14.97,12.84,10.5,9.03,8.69,9.03,10.06,11.31,12.5,12.5,12.97,12.47,12.81,13.91,16.38,19.12,22.03,23.06,23.12,21.25,18.16,15.62,12.03,8.91,6.12,3.84,1.81,0.28,0.09,0.41,2.38,4.78,7.25,9.69,12.09,14.31,16.19,18.03,20.34,20.94,22.59,23.31,21.56,19.94,16.69,12.84,8.81,4.53,1.53,-1.94,-3.81,-5.81,-6.34,-5.09,-3.31,-0.28,3.81,5.94,9.88,12.06,13.56,14.41,16.44,15.44,15.38,15.44,14.75,14.16,12.31,11.25,9.5,7.53,6.12,6.5,7.22,9.5,10.59,12.34,13.25,13.44,13.19,10.69,9.78,6.72,5.19,3.78,2.16,2.72,2.84,4.31,5.06,6.22,7.62,7.72,8.62,8.5,8.81,8.81,9.38,9.25,8.75,9.03,7.59,8.5,8.41,8.16,7.28,9.06,9.41,10.34,12.75,12.88,15.62,16.75,17.03,18.81,19.91,19.5,19.12,17.84,14.62,14.22,11.59,10.66,10.44,11.03,11.41,12.66,13.16,12.94,12.44,13.12,12.19,11.06,11.28,11.19,10.91,11.84,12.81,12.69,13.19,13.59,12.38,11.12,12.41,11.38,11.47,12.06,12.56,12.62,14.81,16.0,16.94,17.78,18.41,17.41,16.78,15.12,13.94,13.12,12.16,10.88,10.62,11.78,12.38,13.5,14.03,14.19,13.44,13.19,12.34,12.38,12.75,14.19,15.12,17.81,19.53,21.97,23.97,24.72,23.28,20.34,17.84,16.41,14.47,14.66,14.44,14.94,14.28,12.84,11.81,10.44,17.25,22.28,26.31,30.72,33.03,33.91,33.5,32.94,31.31,30.41,30.28,29.59,28.81,29.31,28.91,29.16,30.22,31.34:15.69,14.94,14.62,13.62,13.66,13.0,13.62,13.56,13.94,14.75,16.69,15.91,17.12,17.41,16.62,15.88,16.25,15.91,16.38,17.91,16.91,17.12,15.06,12.78,13.31,10.59,11.06,9.53,10.94,10.03,11.31,11.03,9.94,11.72,10.31,10.53,11.59,10.03,9.62,8.91,8.06,6.62,7.41,6.97,7.25,7.81,7.91,8.44,7.69,6.69,5.12,2.16,1.44,-1.16,-0.72,-0.78,-0.47,2.06,2.31,3.88,5.81,6.81,7.38,9.5,8.25,9.25,8.81,7.06,6.44,3.34,1.94,1.47,0.78,0.44,1.84,3.41,3.66,5.03,5.62,7.28,8.09,7.62,7.41,7.84,7.0,7.12,7.25,8.19,9.56,10.78,11.94,11.91,11.38,12.34,11.19,12.0,12.25,10.75,11.75,11.59,12.97,15.19,17.16,17.66,18.97,18.97,18.56,19.16,18.59,18.03,15.56,11.81,12.19,9.91,10.44,11.88,12.59,13.41,14.38,13.34,12.94,13.28,11.81,13.22,12.25,13.0,13.84,14.81,13.97,16.12,16.06,15.38,14.84,13.59,11.22,10.47,9.38,6.31,4.78,3.69,2.62,2.09,2.56,4.03,6.53,7.0,8.12,12.34,12.69,14.06,17.12,17.47,17.31,17.56,16.72,17.09,15.12,14.28,13.22,11.91,10.53,11.62,12.12,12.5,14.38,15.66,16.5,17.28,18.25,19.72,18.81,19.56,17.94,18.16,15.84,16.03,16.12,16.25,18.53,20.34,23.03,24.56,26.19,27.06,27.78,26.56,26.12,24.59,25.5,23.06,23.44,21.5,20.44,19.38,17.06,16.69,14.62,16.31,16.88,19.06,20.81,20.88,21.56,20.59,18.97,18.69,20.41,21.25,23.25,25.94,26.91,27.16,26.5,25.31,21.94,21.62,19.91,18.41,17.34,15.78,15.34,12.69,15.12,15.0,15.62,17.25,16.41,18.19,16.69,18.12,19.28,19.75,20.56,19.88,19.59,20.47,21.25,19.97,22.62,23.06,24.06,26.72,26.88,27.47,27.44,25.44,24.69,22.78,21.22,23.16,21.25,22.41,21.69,21.88,21.31,21.47,20.31,20.16,19.91,18.81,18.44,17.66,18.88,20.84,24.09,26.94,30.0,31.91,33.12,33.19,32.19,31.88,29.84,26.06,25.75,23.44,21.94,21.59,20.91,20.28,18.59,16.81,15.69,14.94,14.06,15.16,15.88,17.44,17.31,16.47,15.72,13.94,14.09,14.0,14.22,16.28,15.53,14.91,13.34,11.25,9.78,9.88,10.53,11.41,13.78,14.69,16.62,18.94,20.88,23.94,26.78,28.69,31.12,31.75,31.81,31.59,33.03,31.16,30.5,30.91,30.5,30.0,30.44,29.38,27.75,24.94,23.88,19.81,20.25,18.56,17.06,17.41,17.28,15.47,17.31,17.25,16.06,17.19,15.91,15.94,14.91,15.22,15.28,13.38,14.19,12.5,11.94,11.56,10.56,11.41,11.56,11.25,10.28,9.91,10.12,8.88,9.28,8.84,10.34,10.69,11.81,12.91,13.91,14.06,13.66,14.91,13.81,15.0,16.44,17.59,18.16,19.03,20.22,20.25,20.66,19.56,18.66,17.84,15.22,14.03,13.62,15.75,17.44,19.12,20.81,22.38,22.56,23.72,23.78,27.0,29.5,31.09,32.16,33.94,31.81,29.69,28.16,26.44,25.12,25.12,24.09,22.94,21.16,18.75,17.31,15.03,15.69,14.38,16.34,17.78,19.81,22.56,24.84,25.31,25.44,26.28,23.88,22.28,19.53,16.34,13.97,10.12,8.06,9.47,10.25,11.22,15.06,16.41,18.69,20.97,23.06,24.66,27.0,27.81,29.0,27.94,28.34,26.75,25.72,24.59,21.41,21.97,20.38,19.81,20.12,20.06,19.66,19.31,19.44,17.34,17.53,16.38,15.84,17.56,19.06,21.34,23.06,26.28,26.5,26.53,26.28,24.84,22.69,22.69,19.78,20.31,20.53,20.94,22.31,23.56,24.38,24.59,24.12,22.94,22.97,22.31,22.28,21.84,22.22,20.75,19.62,18.34,16.28,15.84,14.31,14.53,14.16,13.16,14.19,13.5,12.25,11.34,13.16,12.59,13.56,15.62,15.34,13.75,10.53,7.69,5.62,1.81,0.53,-1.16,0.53,0.44,3.56,4.84,7.44,9.31,9.78,10.56,8.88,10.47,9.16,8.78,10.72,9.44,11.94,13.19,14.44,16.12,15.53,15.47,14.12,13.56,13.91,14.16,14.5,15.19,14.12,12.75,11.53,9.97,8.75,8.22,6.06,7.44,7.94,8.56,10.5,10.81,12.34,11.84,11.41,10.78,9.88,9.88,9.38,8.94,9.19,9.09,9.38,9.09,9.5,10.84,11.16,13.25,14.34,15.81,18.47,19.84,21.0,21.41,20.56,20.84,19.16,17.66,16.41,14.22,12.72,13.88,15.19,17.28,19.47,19.69,19.09,18.97,17.69,18.09,19.06,20.56,20.19,19.38,18.25,17.06,14.41,14.91,14.03,12.88,14.81,14.56,14.66,15.78,17.03,16.28,15.91,16.03,15.78,14.84,14.56,12.38,11.16,10.09,9.38,8.38,8.03,7.41,7.34,6.25,7.06,7.97,9.75,11.94,13.69,13.97,13.97,13.03,12.16,12.41,13.66,17.38,20.19,24.59,26.5,28.19,28.16,24.0,21.41,17.09,12.91,11.69,11.44,12.69,13.22,15.03,15.06,14.62,13.41,13.72,13.16,12.53,12.94,11.78,10.56,8.66,7.69,5.06,4.56,5.41,6.0,6.25,7.19,5.88,4.19,1.12,0.06,-1.41,-2.41,-2.44,-1.22,0.03,0.16,1.81,4.53,4.44,5.19,4.94,4.91,5.62,8.28,8.84,12.31,15.72,17.03,19.69,20.84,20.31,19.56,17.56,14.97,12.84,10.5,9.03,8.69,9.03,10.06,11.31,12.5,12.5,12.97,12.47,12.81,13.91,16.38,19.12,22.03,23.06,23.12,21.25,18.16,15.62,12.03,8.91,6.12,3.84,1.81,0.28,0.09,0.41,2.38,4.78,7.25,9.69,12.09,14.31,16.19,18.03,20.34,20.94,22.59,23.31,21.56,19.94,16.69,12.84,8.81,4.53,1.53,-1.94,-3.81,-5.81,-6.34,-5.09,-3.31,-0.28,3.81,5.94,9.88,12.06,13.56,14.41,16.44,15.44,15.38,15.44,14.75,14.16,12.31,11.25,9.5,7.53,6.12,6.5,7.22,9.5,10.59,12.34,13.25,13.44,13.19,10.69,9.78,6.72,5.19,3.78,2.16,2.72,2.84,4.31,5.06,6.22,7.62,7.72,8.62,8.5,8.81,8.81,9.38,9.25,8.75,9.03,7.59,8.5,8.41,8.16,7.28,9.06,9.41,10.34,12.75,12.88,15.62,16.75,17.03,18.81,19.91,19.5,19.12,17.84,14.62,14.22,11.59,10.66,10.44,11.03,11.41,12.66,13.16,12.94,12.44,13.12,12.19,11.06,11.28,11.19,10.91,11.84,12.81,12.69,13.19,13.59,12.38,11.12,12.41,11.38,11.47,12.06,12.56,12.62,14.81,16.0,16.94,17.78,18.41,17.41,16.78,15.12,13.94,13.12,12.16,10.88,10.62,11.78,12.38,13.5,14.03,14.19,13.44,13.19,12.34,12.38,12.75,14.19,15.12,17.81,19.53,21.97,23.97,24.72,23.28,20.34,17.84,16.41,14.47,14.66,14.44,14.94,14.28,12.84,11.81,10.44,17.25,22.28,26.31,30.72,33.03,33.91,33.5,32.94,31.31,30.41,30.28,29.59,28.81,29.31,28.91,29.16,30.22,31.34,31.81,30.38,30.19,27.69,27.44,26.66:13.62,13.56,13.94,14.75,16.69,15.91,17.12,17.41,16.62,15.88,16.25,15.91,16.38,17.91,16.91,17.12,15.06,12.78,13.31,10.59,11.06,9.53,10.94,10.03,11.31,11.03,9.94,11.72,10.31,10.53,11.59,10.03,9.62,8.91,8.06,6.62,7.41,6.97,7.25,7.81,7.91,8.44,7.69,6.69,5.12,2.16,1.44,-1.16,-0.72,-0.78,-0.47,2.06,2.31,3.88,5.81,6.81,7.38,9.5,8.25,9.25,8.81,7.06,6.44,3.34,1.94,1.47,0.78,0.44,1.84,3.41,3.66,5.03,5.62,7.28,8.09,7.62,7.41,7.84,7.0,7.12,7.25,8.19,9.56,10.78,11.94,11.91,11.38,12.34,11.19,12.0,12.25,10.75,11.75,11.59,12.97,15.19,17.16,17.66,18.97,18.97,18.56,19.16,18.59,18.03,15.56,11.81,12.19,9.91,10.44,11.88,12.59,13.41,14.38,13.34,12.94,13.28,11.81,13.22,12.25,13.0,13.84,14.81,13.97,16.12,16.06,15.38,14.84,13.59,11.22,10.47,9.38,6.31,4.78,3.69,2.62,2.09,2.56,4.03,6.53,7.0,8.12,12.34,12.69,14.06,17.12,17.47,17.31,17.56,16.72,17.09,15.12,14.28,13.22,11.91,10.53,11.62,12.12,12.5,14.38,15.66,16.5,17.28,18.25,19.72,18.81,19.56,17.94,18.16,15.84,16.03,16.12,16.25,18.53,20.34,23.03,24.56,26.19,27.06,27.78,26.56,26.12,24.59,25.5,23.06,23.44,21.5,20.44,19.38,17.06,16.69,14.62,16.31,16.88,19.06,20.81,20.88,21.56,20.59,18.97,18.69,20.41,21.25,23.25,25.94,26.91,27.16,26.5,25.31,21.94,21.62,19.91,18.41,17.34,15.78,15.34,12.69,15.12,15.0,15.62,17.25,16.41,18.19,16.69,18.12,19.28,19.75,20.56,19.88,19.59,20.47,21.25,19.97,22.62,23.06,24.06,26.72,26.88,27.47,27.44,25.44,24.69,22.78,21.22,23.16,21.25,22.41,21.69,21.88,21.31,21.47,20.31,20.16,19.91,18.81,18.44,17.66,18.88,20.84,24.09,26.94,30.0,31.91,33.12,33.19,32.19,31.88,29.84,26.06,25.75,23.44,21.94,21.59,20.91,20.28,18.59,16.81,15.69,14.94,14.06,15.16,15.88,17.44,17.31,16.47,15.72,13.94,14.09,14.0,14.22,16.28,15.53,14.91,13.34,11.25,9.78,9.88,10.53,11.41,13.78,14.69,16.62,18.94,20.88,23.94,26.78,28.69,31.12,31.75,31.81,31.59,33.03,31.16,30.5,30.91,30.5,30.0,30.44,29.38,27.75,24.94,23.88,19.81,20.25,18.56,17.06,17.41,17.28,15.47,17.31,17.25,16.06,17.19,15.91,15.94,14.91,15.22,15.28,13.38,14.19,12.5,11.94,11.56,10.56,11.41,11.56,11.25,10.28,9.91,10.12,8.88,9.28,8.84,10.34,10.69,11.81,12.91,13.91,14.06,13.66,14.91,13.81,15.0,16.44,17.59,18.16,19.03,20.22,20.25,20.66,19.56,18.66,17.84,15.22,14.03,13.62,15.75,17.44,19.12,20.81,22.38,22.56,23.72,23.78,27.0,29.5,31.09,32.16,33.94,31.81,29.69,28.16,26.44,25.12,25.12,24.09,22.94,21.16,18.75,17.31,15.03,15.69,14.38,16.34,17.78,19.81,22.56,24.84,25.31,25.44,26.28,23.88,22.28,19.53,16.34,13.97,10.12,8.06,9.47,10.25,11.22,15.06,16.41,18.69,20.97,23.06,24.66,27.0,27.81,29.0,27.94,28.34,26.75,25.72,24.59,21.41,21.97,20.38,19.81,20.12,20.06,19.66,19.31,19.44,17.34,17.53,16.38,15.84,17.56,19.06,21.34,23.06,26.28,26.5,26.53,26.28,24.84,22.69,22.69,19.78,20.31,20.53,20.94,22.31,23.56,24.38,24.59,24.12,22.94,22.97,22.31,22.28,21.84,22.22,20.75,19.62,18.34,16.28,15.84,14.31,14.53,14.16,13.16,14.19,13.5,12.25,11.34,13.16,12.59,13.56,15.62,15.34,13.75,10.53,7.69,5.62,1.81,0.53,-1.16,0.53,0.44,3.56,4.84,7.44,9.31,9.78,10.56,8.88,10.47,9.16,8.78,10.72,9.44,11.94,13.19,14.44,16.12,15.53,15.47,14.12,13.56,13.91,14.16,14.5,15.19,14.12,12.75,11.53,9.97,8.75,8.22,6.06,7.44,7.94,8.56,10.5,10.81,12.34,11.84,11.41,10.78,9.88,9.88,9.38,8.94,9.19,9.09,9.38,9.09,9.5,10.84,11.16,13.25,14.34,15.81,18.47,19.84,21.0,21.41,20.56,20.84,19.16,17.66,16.41,14.22,12.72,13.88,15.19,17.28,19.47,19.69,19.09,18.97,17.69,18.09,19.06,20.56,20.19,19.38,18.25,17.06,14.41,14.91,14.03,12.88,14.81,14.56,14.66,15.78,17.03,16.28,15.91,16.03,15.78,14.84,14.56,12.38,11.16,10.09,9.38,8.38,8.03,7.41,7.34,6.25,7.06,7.97,9.75,11.94,13.69,13.97,13.97,13.03,12.16,12.41,13.66,17.38,20.19,24.59,26.5,28.19,28.16,24.0,21.41,17.09,12.91,11.69,11.44,12.69,13.22,15.03,15.06,14.62,13.41,13.72,13.16,12.53,12.94,11.78,10.56,8.66,7.69,5.06,4.56,5.41,6.0,6.25,7.19,5.88,4.19,1.12,0.06,-1.41,-2.41,-2.44,-1.22,0.03,0.16,1.81,4.53,4.44,5.19,4.94,4.91,5.62,8.28,8.84,12.31,15.72,17.03,19.69,20.84,20.31,19.56,17.56,14.97,12.84,10.5,9.03,8.69,9.03,10.06,11.31,12.5,12.5,12.97,12.47,12.81,13.91,16.38,19.12,22.03,23.06,23.12,21.25,18.16,15.62,12.03,8.91,6.12,3.84,1.81,0.28,0.09,0.41,2.38,4.78,7.25,9.69,12.09,14.31,16.19,18.03,20.34,20.94,22.59,23.31,21.56,19.94,16.69,12.84,8.81,4.53,1.53,-1.94,-3.81,-5.81,-6.34,-5.09,-3.31,-0.28,3.81,5.94,9.88,12.06,13.56,14.41,16.44,15.44,15.38,15.44,14.75,14.16,12.31,11.25,9.5,7.53,6.12,6.5,7.22,9.5,10.59,12.34,13.25,13.44,13.19,10.69,9.78,6.72,5.19,3.78,2.16,2.72,2.84,4.31,5.06,6.22,7.62,7.72,8.62,8.5,8.81,8.81,9.38,9.25,8.75,9.03,7.59,8.5,8.41,8.16,7.28,9.06,9.41,10.34,12.75,12.88,15.62,16.75,17.03,18.81,19.91,19.5,19.12,17.84,14.62,14.22,11.59,10.66,10.44,11.03,11.41,12.66,13.16,12.94,12.44,13.12,12.19,11.06,11.28,11.19,10.91,11.84,12.81,12.69,13.19,13.59,12.38,11.12,12.41,11.38,11.47,12.06,12.56,12.62,14.81,16.0,16.94,17.78,18.41,17.41,16.78,15.12,13.94,13.12,12.16,10.88,10.62,11.78,12.38,13.5,14.03,14.19,13.44,13.19,12.34,12.38,12.75,14.19,15.12,17.81,19.53,21.97,23.97,24.72,23.28,20.34,17.84,16.41,14.47,14.66,14.44,14.94,14.28,12.84,11.81,10.44,17.25,22.28,26.31,30.72,33.03,33.91,33.5,32.94,31.31,30.41,30.28,29.59,28.81,29.31,28.91,29.16,30.22,31.34,31.81,30.38,30.19,27.69,27.44,26.66,24.75,24.06,22.97,21.94,20.88,20.88:negativity
10.31,13.53,11.91,12.16,10.62,9.56,6.91,7.06,7.28,7.34,6.25,6.22,6.06,3.56,0.88,-2.22,-4.03,-4.78,-4.84,-3.66,-0.16,0.97,0.88,2.91,3.06,2.97,5.66,7.62,8.56,10.03,9.94,8.56,4.5,3.69,-1.06,-3.94,-7.09,-8.09,-11.28,-11.16,-9.75,-7.28,-3.75,1.25,4.12,6.91,8.31,9.06,10.38,10.78,12.25,12.56,13.62,12.06,13.66,12.88,13.47,11.97,11.72,13.88,14.09,15.31,19.41,18.0,16.06,14.41,10.41,7.81,5.84,3.31,2.97,2.16,1.31,3.19,2.69,3.69,4.88,3.41,3.75,3.19,1.91,1.44,0.69,0.0,0.47,2.09,3.25,3.94,5.84,4.41,5.12,4.19,4.66,4.31,2.91,3.06,-0.59,-2.53,-2.69,-4.72,-3.34,0.41,2.75,5.12,8.56,9.78,8.78,8.97,7.59,7.22,5.94,5.31,4.94,4.0,2.94,3.34,2.66,3.88,5.78,6.44,7.47,6.25,4.56,4.66,1.34,-0.03,0.22,0.53,0.28,3.62,3.47,5.28,7.31,6.91,6.06,5.06,6.03,4.0,3.53,4.31,4.75,4.91,1.47,1.53,2.0,1.62,2.81,5.12,6.75,5.88,6.22,5.94,6.59,7.19,6.69,6.16,5.03,2.81,2.31,3.03,3.31,6.84,7.41,10.66,10.41,11.25,10.09,9.0,7.03,5.16,3.12,2.12,1.69,3.94,4.66,7.47,11.66,12.47,12.56,15.81,15.38,14.88,15.06,13.72,11.94,10.41,10.25,8.5,10.22,8.88,8.0,7.84,4.72,1.88,0.5,1.38,1.56,5.41,8.91,9.16,12.84,10.38,11.91,12.88,13.97,14.19,14.19,13.56,12.34,11.88,9.78,6.5,6.66,5.44,5.22,6.75,9.0,9.69,10.28,10.06,8.44,8.16,8.78,8.97,8.78,9.75,10.56,9.81,9.78,10.81,10.5,11.41,10.56,9.19,8.31,6.34,4.84,3.41,0.75,3.31,2.69,4.88,6.88,7.44,8.88,11.16,11.66,15.09,16.28,17.75,18.5,19.69,19.25,16.62,15.03,11.38,6.94,3.31,1.59,0.69,-1.72,-1.59,-1.62,-3.22,-0.69,0.69,1.84,2.31,2.38,1.59,-1.31,-2.16,-4.66,-5.09,-5.59,-5.41,-4.69,-4.97,-5.16,-7.09,-6.03,-6.53,-6.34,-3.72,-5.72,-3.09,-4.66,-5.53,-5.81,-7.41,-7.34,-8.09,-7.47,-6.94,-6.34,-6.16,-4.81,-3.09,-0.53,2.31,3.44,5.25,3.91,4.19,3.41,3.81,5.66,5.78,6.5,8.16,7.66,8.88,8.84,8.25,6.84,1.81,-0.22,-0.78,-3.78,-4.44,-0.38,0.84,1.88,3.22,5.28,5.62,5.72,7.94,7.62,6.66,9.06,9.06,8.09,9.56,10.72,12.38,12.19,13.28,11.62,8.25,5.72,0.97,-0.81,-3.22,-4.59,-4.56,-5.59,-7.84,-7.62,-5.38,-5.66,-4.78,-1.28,-0.41,1.72,3.06,3.81,4.5,3.84,3.12,0.22,0.19,-3.03,-2.81,-4.84,-6.12,-4.47,-3.91,-1.88,0.53,1.06,3.75,4.31,5.34,6.56,7.38,7.25,5.31,3.91,2.78,0.97,2.97,4.78,8.09,7.81,9.84,10.62,7.41,6.34,6.31,2.78,1.88,-0.19,-0.56,-3.56,-2.34,-1.72,-0.34,0.84,1.06,2.31,1.75,0.88,1.31,1.41,-0.12,-0.56,0.16,-1.44,-1.59,-0.47,-2.69,-2.59,-4.44,-5.84,-5.53,-4.53,-2.94,-0.47,1.69,2.81,2.62,2.94,1.66,-0.47,-1.97,-1.44,-3.47,-1.84,-2.72,0.91,1.62,2.03,3.22,4.69,1.41,1.06,-1.19,-1.44,-1.56,-2.69,-0.72,-1.47,-0.16,0.56,2.34,4.72,6.03,9.94,10.34,8.66,7.41,3.91,1.31,-2.41,-4.22,-5.53,-5.91,-8.03,-8.09,-9.78,-8.84,-9.41,-10.28,-9.41,-8.31,-8.16,-6.09,-3.03,-3.84,-4.53,-1.28,-2.78,-2.06,-0.62,-0.34,0.22,-0.16,0.12,1.31,3.72,6.81,7.53,7.31,7.5,8.56,7.31,7.16,8.0,8.16,6.69,5.0,6.75,3.72,2.06,1.31,-3.09,-4.78,-7.81,-9.69,-11.62,-10.66,-7.94,-6.16,-3.25,-2.03,-0.75,-1.69,-3.06,-3.84,-4.91,-6.03,-5.22,-4.44,-2.0,0.62,1.75,2.47,2.09,-0.12,-3.09,-6.53,-6.84,-7.69,-7.72,-6.84,-4.22,-3.62,-3.47,-3.5,-4.19,-7.59,-9.22,-11.34,-13.16,-14.91,-12.97,-11.91,-10.59,-8.22,-5.59,-4.66,-2.72,-3.44,-3.28,-5.78,-5.31,-7.62,-7.97,-6.41,-6.28,-4.28,-3.44,-3.03,-4.03,-8.16,-7.81,-8.0,-9.16,-5.5,-4.03,-1.44,-0.97,-2.31,-1.41,-4.06,-5.22,-5.25,-7.09,-7.66,-10.03,-9.38,-10.34,-9.38,-6.97,-4.97,-3.09,-2.59,-2.91,-4.78,-5.69,-6.16,-6.88,-3.78,-2.34,-0.72,-0.12,-0.56,-2.94,-2.38,-4.34,-2.44,1.03,2.59,5.06,5.59,6.0,2.59,1.75,-0.75,-3.34,-5.75,-7.94,-8.28,-9.25,-10.62,-8.91,-6.41,-5.38,-3.91,-2.47,-4.94,-7.22,-10.25,-16.06,-16.25,-17.12,-19.34,-18.25,-17.41,-17.84,-16.19,-16.47,-16.44,-14.72,-13.16,-11.34,-7.97,-6.09,-4.72,-3.28,-1.44,-1.44,-0.59,0.19,-1.97,-3.19,-4.03,-5.19,-6.78,-9.75,-8.59,-10.59,-12.41,-10.84,-10.94,-11.59,-11.72,-11.47,-14.47,-13.94,-15.66,-15.5,-13.81,-12.28,-8.72,-5.78,-4.84,-3.72,-3.31,-4.72,-6.28,-7.47,-9.91,-13.09,-15.84,-15.78,-20.31,-18.91,-15.84,-13.81,-8.97,-4.78,-2.59,-0.34,-0.81,0.16,-0.09,-1.47,-0.59,-2.19,-1.66,-1.72,-2.19,-1.47,-4.59,-4.44,-5.38,-6.34,-6.09,-7.22,-8.88,-11.31,-11.47,-13.12,-12.91,-16.0,-15.59,-14.75,-15.25,-14.12,-9.94,-6.09,-3.66,3.69,7.25,10.28,10.41,9.59,4.31,-0.59,-4.19,-5.97,-9.28,-10.91,-10.31,-11.59,-12.69,-12.72,-15.84,-13.03,-13.59,-12.78,-10.56,-8.81,-8.59,-6.44,-4.59,-3.53,-2.97,-3.09,-2.84,-5.66,-6.16,-8.09,-6.44,-4.88,-5.34,-2.84,-4.53,-4.06,-5.72,-6.03,-9.19,-8.28,-9.84,-12.16,-12.06,-13.03,-14.19,-14.44,-13.12,-13.19,-10.94,-10.53,-8.97,-9.16,-8.84,-7.09,-7.22,-6.91,-8.19,-12.22,-14.81,-19.34,-23.03,-26.94,-32.31,-35.62,-39.78,-42.84,-44.44,-45.12,-44.5,-45.69,-44.19,-44.62,-45.59,-45.97,-48.44,-51.66,-53.81,-55.81,-59.94,-60.34,-61.59,-64.03,-64.22,-61.84,-60.09,-57.28,-54.66,-51.94,-49.97,-49.56,-46.34,-44.91,-44.19,-44.44,-44.28,-47.34,-49.84,-51.34,-52.75,-53.06,-52.53,-53.16,-51.66,-49.88,-49.47,-44.84,-42.88,-39.5,-35.69,-33.28,-30.53,-29.72,-29.22,-28.28,-29.5,-29.91,-32.66,-32.03,-34.16,-34.03,-34.38,-34.53,-34.16,-35.94,-38.53,-37.97,-39.66,-40.09,-37.09,-37.53,-37.12,-36.03,-35.81,-36.53,-36.31,-35.66,-35.72,-38.44,-39.19,-43.16,-42.72,-43.44,-43.22,-41.41,-41.16,-41.72,-43.47,-42.53,-43.88,-44.03,-40.16,-36.41,-33.5,-30.47,-27.75,-27.03,-27.81,-28.56,-28.34,-28.41,-28.66,-29.72,-31.16,-30.97,-30.78,-30.94,-28.03,-28.62,-27.16,-28.16,-28.22,-27.28,-28.69,-26.72,-25.75,-24.31,-24.34,-25.16,-25.38,-28.75,-31.47,-35.0,-37.69,-38.97,-39.72,-39.16,-38.66,-36.59,-35.81,-35.59,-33.0:6.91,7.06,7.28,7.34,6.25,6.22,6.06,3.56,0.88,-2.22,-4.03,-4.78,-4.84,-3.66,-0.16,0.97,0.88,2.91,3.06,2.97,5.66,7.62,8.56,10.03,9.94,8.56,4.5,3.69,-1.06,-3.94,-7.09,-8.09,-11.28,-11.16,-9.75,-7.28,-3.75,1.25,4.12,6.91,8.31,9.06,10.38,10.78,12.25,12.56,13.62,12.06,13.66,12.88,13.47,11.97,11.72,13.88,14.09,15.31,19.41,18.0,16.06,14.41,10.41,7.81,5.84,3.31,2.97,2.16,1.31,3.19,2.69,3.69,4.88,3.41,3.75,3.19,1.91,1.44,0.69,0.0,0.47,2.09,3.25,3.94,5.84,4.41,5.12,4.19,4.66,4.31,2.91,3.06,-0.59,-2.53,-2.69,-4.72,-3.34,0.41,2.75,5.12,8.56,9.78,8.78,8.97,7.59,7.22,5.94,5.31,4.94,4.0,2.94,3.34,2.66,3.88,5.78,6.44,7.47,6.25,4.56,4.66,1.34,-0.03,0.22,0.53,0.28,3.62,3.47,5.28,7.31,6.91,6.06,5.06,6.03,4.0,3.53,4.31,4.75,4.91,1.47,1.53,2.0,1.62,2.81,5.12,6.75,5.88,6.22,5.94,6.59,7.19,6.69,6.16,5.03,2.81,2.31,3.03,3.31,6.84,7.41,10.66,10.41,11.25,10.09,9.0,7.03,5.16,3.12,2.12,1.69,3.94,4.66,7.47,11.66,12.47,12.56,15.81,15.38,14.88,15.06,13.72,11.94,10.41,10.25,8.5,10.22,8.88,8.0,7.84,4.72,1.88,0.5,1.38,1.56,5.41,8.91,9.16,12.84,10.38,11.91,12.88,13.97,14.19,14.19,13.56,12.34,11.88,9.78,6.5,6.66,5.44,5.22,6.75,9.0,9.69,10.28,10.06,8.44,8.16,8.78,8.97,8.78,9.75,10.56,9.81,9.78,10.81,10.5,11.41,10.56,9.19,8.31,6.34,4.84,3.41,0.75,3.31,2.69,4.88,6.88,7.44,8.88,11.16,11.66,15.09,16.28,17.75,18.5,19.69,19.25,16.62,15.03,11.38,6.94,3.31,1.59,0.69,-1.72,-1.59,-1.62,-3.22,-0.69,0.69,1.84,2.31,2.38,1.59,-1.31,-2.16,-4.66,-5.09,-5.59,-5.41,-4.69,-4.97,-5.16,-7.09,-6.03,-6.53,-6.34,-3.72,-5.72,-3.09,-4.66,-5.53,-5.81,-7.41,-7.34,-8.09,-7.47,-6.94,-6.34,-6.16,-4.81,-3.09,-0.53,2.31,3.44,5.25,3.91,4.19,3.41,3.81,5.66,5.78,6.5,8.16,7.66,8.88,8.84,8.25,6.84,1.81,-0.22,-0.78,-3.78,-4.44,-0.38,0.84,1.88,3.22,5.28,5.62,5.72,7.94,7.62,6.66,9.06,9.06,8.09,9.56,10.72,12.38,12.19,13.28,11.62,8.25,5.72,0.97,-0.81,-3.22,-4.59,-4.56,-5.59,-7.84,-7.62,-5.38,-5.66,-4.78,-1.28,-0.41,1.72,3.06,3.81,4.5,3.84,3.12,0.22,0.19,-3.03,-2.81,-4.84,-6.12,-4.47,-3.91,-1.88,0.53,1.06,3.75,4.31,5.34,6.56,7.38,7.25,5.31,3.91,2.78,0.97,2.97,4.78,8.09,7.81,9.84,10.62,7.41,6.34,6.31,2.78,1.88,-0.19,-0.56,-3.56,-2.34,-1.72,-0.34,0.84,1.06,2.31,1.75,0.88,1.31,1.41,-0.12,-0.56,0.16,-1.44,-1.59,-0.47,-2.69,-2.59,-4.44,-5.84,-5.53,-4.53,-2.94,-0.47,1.69,2.81,2.62,2.94,1.66,-0.47,-1.97,-1.44,-3.47,-1.84,-2.72,0.91,1.62,2.03,3.22,4.69,1.41,1.06,-1.19,-1.44,-1.56,-2.69,-0.72,-1.47,-0.16,0.56,2.34,4.72,6.03,9.94,10.34,8.66,7.41,3.91,1.31,-2.41,-4.22,-5.53,-5.91,-8.03,-8.09,-9.78,-8.84,-9.41,-10.28,-9.41,-8.31,-8.16,-6.09,-3.03,-3.84,-4.53,-1.28,-2.78,-2.06,-0.62,-0.34,0.22,-0.16,0.12,1.31,3.72,6.81,7.53,7.31,7.5,8.56,7.31,7.16,8.0,8.16,6.69,5.0,6.75,3.72,2.06,1.31,-3.09,-4.78,-7.81,-9.69,-11.62,-10.66,-7.94,-6.16,-3.25,-2.03,-0.75,-1.69,-3.06,-3.84,-4.91,-6.03,-5.22,-4.44,-2.0,0.62,1.75,2.47,2.09,-0.12,-3.09,-6.53,-6.84,-7.69,-7.72,-6.84,-4.22,-3.62,-3.47,-3.5,-4.19,-7.59,-9.22,-11.34,-13.16,-14.91,-12.97,-11.91,-10.59,-8.22,-5.59,-4.66,-2.72,-3.44,-3.28,-5.78,-5.31,-7.62,-7.97,-6.41,-6.28,-4.28,-3.44,-3.03,-4.03,-8.16,-7.81,-8.0,-9.16,-5.5,-4.03,-1.44,-0.97,-2.31,-1.41,-4.06,-5.22,-5.25,-7.09,-7.66,-10.03,-9.38,-10.34,-9.38,-6.97,-4.97,-3.09,-2.59,-2.91,-4.78,-5.69,-6.16,-6.88,-3.78,-2.34,-0.72,-0.12,-0.56,-2.94,-2.38,-4.34,-2.44,1.03,2.59,5.06,5.59,6.0,2.59,1.75,-0.75,-3.34,-5.75,-7.94,-8.28,-9.25,-10.62,-8.91,-6.41,-5.38,-3.91,-2.47,-4.94,-7.22,-10.25,-16.06,-16.25,-17.12,-19.34,-18.25,-17.41,-17.84,-16.19,-16.47,-16.44,-14.72,-13.16,-11.34,-7.97,-6.09,-4.72,-3.28,-1.44,-1.44,-0.59,0.19,-1.97,-3.19,-4.03,-5.19,-6.78,-9.75,-8.59,-10.59,-12.41,-10.84,-10.94,-11.59,-11.72,-11.47,-14.47,-13.94,-15.66,-15.5,-13.81,-12.28,-8.72,-5.78,-4.84,-3.72,-3.31,-4.72,-6.28,-7.47,-9.91,-13.09,-15.84,-15.78,-20.31,-18.91,-15.84,-13.81,-8.97,-4.78,-2.59,-0.34,-0.81,0.16,-0.09,-1.47,-0.59,-2.19,-1.66,-1.72,-2.19,-1.47,-4.59,-4.44,-5.38,-6.34,-6.09,-7.22,-8.88,-11.31,-11.47,-13.12,-12.91,-16.0,-15.59,-14.75,-15.25,-14.12,-9.94,-6.09,-3.66,3.69,7.25,10.28,10.41,9.59,4.31,-0.59,-4.19,-5.97,-9.28,-10.91,-10.31,-11.59,-12.69,-12.72,-15.84,-13.03,-13.59,-12.78,-10.56,-8.81,-8.59,-6.44,-4.59,-3.53,-2.97,-3.09,-2.84,-5.66,-6.16,-8.09,-6.44,-4.88,-5.34,-2.84,-4.53,-4.06,-5.72,-6.03,-9.19,-8.28,-9.84,-12.16,-12.06,-13.03,-14.19,-14.44,-13.12,-13.19,-10.94,-10.53,-8.97,-9.16,-8.84,-7.09,-7.22,-6.91,-8.19,-12.22,-14.81,-19.34,-23.03,-26.94,-32.31,-35.62,-39.78,-42.84,-44.44,-45.12,-44.5,-45.69,-44.19,-44.62,-45.59,-45.97,-48.44,-51.66,-53.81,-55.81,-59.94,-60.34,-61.59,-64.03,-64.22,-61.84,-60.09,-57.28,-54.66,-51.94,-49.97,-49.56,-46.34,-44.91,-44.19,-44.44,-44.28,-47.34,-49.84,-51.34,-52.75,-53.06,-52.53,-53.16,-51.66,-49.88,-49.47,-44.84,-42.88,-39.5,-35.69,-33.28,-30.53,-29.72,-29.22,-28.28,-29.5,-29.91,-32.66,-32.03,-34.16,-34.03,-34.38,-34.53,-34.16,-35.94,-38.53,-37.97,-39.66,-40.09,-37.09,-37.53,-37.12,-36.03,-35.81,-36.53,-36.31,-35.66,-35.72,-38.44,-39.19,-43.16,-42.72,-43.44,-43.22,-41.41,-41.16,-41.72,-43.47,-42.53,-43.88,-44.03,-40.16,-36.41,-33.5,-30.47,-27.75,-27.03,-27.81,-28.56,-28.34,-28.41,-28.66,-29.72,-31.16,-30.97,-30.78,-30.94,-28.03,-28.62,-27.16,-28.16,-28.22,-27.28,-28.69,-26.72,-25.75,-24.31,-24.34,-25.16,-25.38,-28.75,-31.47,-35.0,-37.69,-38.97,-39.72,-39.16,-38.66,-36.59,-35.81,-35.59,-33.0,-7.72,-11.09,-15.16,-16.06,-16.62,-13.28:6.06,3.56,0.88,-2.22,-4.03,-4.78,-4.84,-3.66,-0.16,0.97,0.88,2.91,3.06,2.97,5.66,7.62,8.56,10.03,9.94,8.56,4.5,3.69,-1.06,-3.94,-7.09,-8.09,-11.28,-11.16,-9.75,-7.28,-3.75,1.25,4.12,6.91,8.31,9.06,10.38,10.78,12.25,12.56,13.62,12.06,13.66,12.88,13.47,11.97,11.72,13.88,14.09,15.31,19.41,18.0,16.06,14.41,10.41,7.81,5.84,3.31,2.97,2.16,1.31,3.19,2.69,3.69,4.88,3.41,3.75,3.19,1.91,1.44,0.69,0.0,0.47,2.09,3.25,3.94,5.84,4.41,5.12,4.19,4.66,4.31,2.91,3.06,-0.59,-2.53,-2.69,-4.72,-3.34,0.41,2.75,5.12,8.56,9.78,8.78,8.97,7.59,7.22,5.94,5.31,4.94,4.0,2.94,3.34,2.66,3.88,5.78,6.44,7.47,6.25,4.56,4.66,1.34,-0.03,0.22,0.53,0.28,3.62,3.47,5.28,7.31,6.91,6.06,5.06,6.03,4.0,3.53,4.31,4.75,4.91,1.47,1.53,2.0,1.62,2.81,5.12,6.75,5.88,6.22,5.94,6.59,7.19,6.69,6.16,5.03,2.81,2.31,3.03,3.31,6.84,7.41,10.66,10.41,11.25,10.09,9.0,7.03,5.16,3.12,2.12,1.69,3.94,4.66,7.47,11.66,12.47,12.56,15.81,15.38,14.88,15.06,13.72,11.94,10.41,10.25,8.5,10.22,8.88,8.0,7.84,4.72,1.88,0.5,1.38,1.56,5.41,8.91,9.16,12.84,10.38,11.91,12.88,13.97,14.19,14.19,13.56,12.34,11.88,9.78,6.5,6.66,5.44,5.22,6.75,9.0,9.69,10.28,10.06,8.44,8.16,8.78,8.97,8.78,9.75,10.56,9.81,9.78,10.81,10.5,11.41,10.56,9.19,8.31,6.34,4.84,3.41,0.75,3.31,2.69,4.88,6.88,7.44,8.88,11.16,11.66,15.09,16.28,17.75,18.5,19.69,19.25,16.62,15.03,11.38,6.94,3.31,1.59,0.69,-1.72,-1.59,-1.62,-3.22,-0.69,0.69,1.84,2.31,2.38,1.59,-1.31,-2.16,-4.66,-5.09,-5.59,-5.41,-4.69,-4.97,-5.16,-7.09,-6.03,-6.53,-6.34,-3.72,-5.72,-3.09,-4.66,-5.53,-5.81,-7.41,-7.34,-8.09,-7.47,-6.94,-6.34,-6.16,-4.81,-3.09,-0.53,2.31,3.44,5.25,3.91,4.19,3.41,3.81,5.66,5.78,6.5,8.16,7.66,8.88,8.84,8.25,6.84,1.81,-0.22,-0.78,-3.78,-4.44,-0.38,0.84,1.88,3.22,5.28,5.62,5.72,7.94,7.62,6.66,9.06,9.06,8.09,9.56,10.72,12.38,12.19,13.28,11.62,8.25,5.72,0.97,-0.81,-3.22,-4.59,-4.56,-5.59,-7.84,-7.62,-5.38,-5.66,-4.78,-1.28,-0.41,1.72,3.06,3.81,4.5,3.84,3.12,0.22,0.19,-3.03,-2.81,-4.84,-6.12,-4.47,-3.91,-1.88,0.53,1.06,3.75,4.31,5.34,6.56,7.38,7.25,5.31,3.91,2.78,0.97,2.97,4.78,8.09,7.81,9.84,10.62,7.41,6.34,6.31,2.78,1.88,-0.19,-0.56,-3.56,-2.34,-1.72,-0.34,0.84,1.06,2.31,1.75,0.88,1.31,1.41,-0.12,-0.56,0.16,-1.44,-1.59,-0.47,-2.69,-2.59,-4.44,-5.84,-5.53,-4.53,-2.94,-0.47,1.69,2.81,2.62,2.94,1.66,-0.47,-1.97,-1.44,-3.47,-1.84,-2.72,0.91,1.62,2.03,3.22,4.69,1.41,1.06,-1.19,-1.44,-1.56,-2.69,-0.72,-1.47,-0.16,0.56,2.34,4.72,6.03,9.94,10.34,8.66,7.41,3.91,1.31,-2.41,-4.22,-5.53,-5.91,-8.03,-8.09,-9.78,-8.84,-9.41,-10.28,-9.41,-8.31,-8.16,-6.09,-3.03,-3.84,-4.53,-1.28,-2.78,-2.06,-0.62,-0.34,0.22,-0.16,0.12,1.31,3.72,6.81,7.53,7.31,7.5,8.56,7.31,7.16,8.0,8.16,6.69,5.0,6.75,3.72,2.06,1.31,-3.09,-4.78,-7.81,-9.69,-11.62,-10.66,-7.94,-6.16,-3.25,-2.03,-0.75,-1.69,-3.06,-3.84,-4.91,-6.03,-5.22,-4.44,-2.0,0.62,1.75,2.47,2.09,-0.12,-3.09,-6.53,-6.84,-7.69,-7.72,-6.84,-4.22,-3.62,-3.47,-3.5,-4.19,-7.59,-9.22,-11.34,-13.16,-14.91,-12.97,-11.91,-10.59,-8.22,-5.59,-4.66,-2.72,-3.44,-3.28,-5.78,-5.31,-7.62,-7.97,-6.41,-6.28,-4.28,-3.44,-3.03,-4.03,-8.16,-7.81,-8.0,-9.16,-5.5,-4.03,-1.44,-0.97,-2.31,-1.41,-4.06,-5.22,-5.25,-7.09,-7.66,-10.03,-9.38,-10.34,-9.38,-6.97,-4.97,-3.09,-2.59,-2.91,-4.78,-5.69,-6.16,-6.88,-3.78,-2.34,-0.72,-0.12,-0.56,-2.94,-2.38,-4.34,-2.44,1.03,2.59,5.06,5.59,6.0,2.59,1.75,-0.75,-3.34,-5.75,-7.94,-8.28,-9.25,-10.62,-8.91,-6.41,-5.38,-3.91,-2.47,-4.94,-7.22,-10.25,-16.06,-16.25,-17.12,-19.34,-18.25,-17.41,-17.84,-16.19,-16.47,-16.44,-14.72,-13.16,-11.34,-7.97,-6.09,-4.72,-3.28,-1.44,-1.44,-0.59,0.19,-1.97,-3.19,-4.03,-5.19,-6.78,-9.75,-8.59,-10.59,-12.41,-10.84,-10.94,-11.59,-11.72,-11.47,-14.47,-13.94,-15.66,-15.5,-13.81,-12.28,-8.72,-5.78,-4.84,-3.72,-3.31,-4.72,-6.28,-7.47,-9.91,-13.09,-15.84,-15.78,-20.31,-18.91,-15.84,-13.81,-8.97,-4.78,-2.59,-0.34,-0.81,0.16,-0.09,-1.47,-0.59,-2.19,-1.66,-1.72,-2.19,-1.47,-4.59,-4.44,-5.38,-6.34,-6.09,-7.22,-8.88,-11.31,-11.47,-13.12,-12.91,-16.0,-15.59,-14.75,-15.25,-14.12,-9.94,-6.09,-3.66,3.69,7.25,10.28,10.41,9.59,4.31,-0.59,-4.19,-5.97,-9.28,-10.91,-10.31,-11.59,-12.69,-12.72,-15.84,-13.03,-13.59,-12.78,-10.56,-8.81,-8.59,-6.44,-4.59,-3.53,-2.97,-3.09,-2.84,-5.66,-6.16,-8.09,-6.44,-4.88,-5.34,-2.84,-4.53,-4.06,-5.72,-6.03,-9.19,-8.28,-9.84,-12.16,-12.06,-13.03,-14.19,-14.44,-13.12,-13.19,-10.94,-10.53,-8.97,-9.16,-8.84,-7.09,-7.22,-6.91,-8.19,-12.22,-14.81,-19.34,-23.03,-26.94,-32.31,-35.62,-39.78,-42.84,-44.44,-45.12,-44.5,-45.69,-44.19,-44.62,-45.59,-45.97,-48.44,-51.66,-53.81,-55.81,-59.94,-60.34,-61.59,-64.03,-64.22,-61.84,-60.09,-57.28,-54.66,-51.94,-49.97,-49.56,-46.34,-44.91,-44.19,-44.44,-44.28,-47.34,-49.84,-51.34,-52.75,-53.06,-52.53,-53.16,-51.66,-49.88,-49.47,-44.84,-42.88,-39.5,-35.69,-33.28,-30.53,-29.72,-29.22,-28.28,-29.5,-29.91,-32.66,-32.03,-34.16,-34.03,-34.38,-34.53,-34.16,-35.94,-38.53,-37.97,-39.66,-40.09,-37.09,-37.53,-37.12,-36.03,-35.81,-36.53,-36.31,-35.66,-35.72,-38.44,-39.19,-43.16,-42.72,-43.44,-43.22,-41.41,-41.16,-41.72,-43.47,-42.53,-43.88,-44.03,-40.16,-36.41,-33.5,-30.47,-27.75,-27.03,-27.81,-28.56,-28.34,-28.41,-28.66,-29.72,-31.16,-30.97,-30.78,-30.94,-28.03,-28.62,-27.16,-28.16,-28.22,-27.28,-28.69,-26.72,-25.75,-24.31,-24.34,-25.16,-25.38,-28.75,-31.47,-35.0,-37.69,-38.97,-39.72,-39.16,-38.66,-36.59,-35.81,-35.59,-33.0,-7.72,-11.09,-15.16,-16.06,-16.62,-13.28,-10.28,-6.94,-2.34,-1.06,0.09,-0.91:-4.84,-3.66,-0.16,0.97,0.88,2.91,3.06,2.97,5.66,7.62,8.56,10.03,9.94,8.56,4.5,3.69,-1.06,-3.94,-7.09,-8.09,-11.28,-11.16,-9.75,-7.28,-3.75,1.25,4.12,6.91,8.31,9.06,10.38,10.78,12.25,12.56,13.62,12.06,13.66,12.88,13.47,11.97,11.72,13.88,14.09,15.31,19.41,18.0,16.06,14.41,10.41,7.81,5.84,3.31,2.97,2.16,1.31,3.19,2.69,3.69,4.88,3.41,3.75,3.19,1.91,1.44,0.69,0.0,0.47,2.09,3.25,3.94,5.84,4.41,5.12,4.19,4.66,4.31,2.91,3.06,-0.59,-2.53,-2.69,-4.72,-3.34,0.41,2.75,5.12,8.56,9.78,8.78,8.97,7.59,7.22,5.94,5.31,4.94,4.0,2.94,3.34,2.66,3.88,5.78,6.44,7.47,6.25,4.56,4.66,1.34,-0.03,0.22,0.53,0.28,3.62,3.47,5.28,7.31,6.91,6.06,5.06,6.03,4.0,3.53,4.31,4.75,4.91,1.47,1.53,2.0,1.62,2.81,5.12,6.75,5.88,6.22,5.94,6.59,7.19,6.69,6.16,5.03,2.81,2.31,3.03,3.31,6.84,7.41,10.66,10.41,11.25,10.09,9.0,7.03,5.16,3.12,2.12,1.69,3.94,4.66,7.47,11.66,12.47,12.56,15.81,15.38,14.88,15.06,13.72,11.94,10.41,10.25,8.5,10.22,8.88,8.0,7.84,4.72,1.88,0.5,1.38,1.56,5.41,8.91,9.16,12.84,10.38,11.91,12.88,13.97,14.19,14.19,13.56,12.34,11.88,9.78,6.5,6.66,5.44,5.22,6.75,9.0,9.69,10.28,10.06,8.44,8.16,8.78,8.97,8.78,9.75,10.56,9.81,9.78,10.81,10.5,11.41,10.56,9.19,8.31,6.34,4.84,3.41,0.75,3.31,2.69,4.88,6.88,7.44,8.88,11.16,11.66,15.09,16.28,17.75,18.5,19.69,19.25,16.62,15.03,11.38,6.94,3.31,1.59,0.69,-1.72,-1.59,-1.62,-3.22,-0.69,0.69,1.84,2.31,2.38,1.59,-1.31,-2.16,-4.66,-5.09,-5.59,-5.41,-4.69,-4.97,-5.16,-7.09,-6.03,-6.53,-6.34,-3.72,-5.72,-3.09,-4.66,-5.53,-5.81,-7.41,-7.34,-8.09,-7.47,-6.94,-6.34,-6.16,-4.81,-3.09,-0.53,2.31,3.44,5.25,3.91,4.19,3.41,3.81,5.66,5.78,6.5,8.16,7.66,8.88,8.84,8.25,6.84,1.81,-0.22,-0.78,-3.78,-4.44,-0.38,0.84,1.88,3.22,5.28,5.62,5.72,7.94,7.62,6.66,9.06,9.06,8.09,9.56,10.72,12.38,12.19,13.28,11.62,8.25,5.72,0.97,-0.81,-3.22,-4.59,-4.56,-5.59,-7.84,-7.62,-5.38,-5.66,-4.78,-1.28,-0.41,1.72,3.06,3.81,4.5,3.84,3.12,0.22,0.19,-3.03,-2.81,-4.84,-6.12,-4.47,-3.91,-1.88,0.53,1.06,3.75,4.31,5.34,6.56,7.38,7.25,5.31,3.91,2.78,0.97,2.97,4.78,8.09,7.81,9.84,10.62,7.41,6.34,6.31,2.78,1.88,-0.19,-0.56,-3.56,-2.34,-1.72,-0.34,0.84,1.06,2.31,1.75,0.88,1.31,1.41,-0.12,-0.56,0.16,-1.44,-1.59,-0.47,-2.69,-2.59,-4.44,-5.84,-5.53,-4.53,-2.94,-0.47,1.69,2.81,2.62,2.94,1.66,-0.47,-1.97,-1.44,-3.47,-1.84,-2.72,0.91,1.62,2.03,3.22,4.69,1.41,1.06,-1.19,-1.44,-1.56,-2.69,-0.72,-1.47,-0.16,0.56,2.34,4.72,6.03,9.94,10.34,8.66,7.41,3.91,1.31,-2.41,-4.22,-5.53,-5.91,-8.03,-8.09,-9.78,-8.84,-9.41,-10.28,-9.41,-8.31,-8.16,-6.09,-3.03,-3.84,-4.53,-1.28,-2.78,-2.06,-0.62,-0.34,0.22,-0.16,0.12,1.31,3.72,6.81,7.53,7.31,7.5,8.56,7.31,7.16,8.0,8.16,6.69,5.0,6.75,3.72,2.06,1.31,-3.09,-4.78,-7.81,-9.69,-11.62,-10.66,-7.94,-6.16,-3.25,-2.03,-0.75,-1.69,-3.06,-3.84,-4.91,-6.03,-5.22,-4.44,-2.0,0.62,1.75,2.47,2.09,-0.12,-3.09,-6.53,-6.84,-7.69,-7.72,-6.84,-4.22,-3.62,-3.47,-3.5,-4.19,-7.59,-9.22,-11.34,-13.16,-14.91,-12.97,-11.91,-10.59,-8.22,-5.59,-4.66,-2.72,-3.44,-3.28,-5.78,-5.31,-7.62,-7.97,-6.41,-6.28,-4.28,-3.44,-3.03,-4.03,-8.16,-7.81,-8.0,-9.16,-5.5,-4.03,-1.44,-0.97,-2.31,-1.41,-4.06,-5.22,-5.25,-7.09,-7.66,-10.03,-9.38,-10.34,-9.38,-6.97,-4.97,-3.09,-2.59,-2.91,-4.78,-5.69,-6.16,-6.88,-3.78,-2.34,-0.72,-0.12,-0.56,-2.94,-2.38,-4.34,-2.44,1.03,2.59,5.06,5.59,6.0,2.59,1.75,-0.75,-3.34,-5.75,-7.94,-8.28,-9.25,-10.62,-8.91,-6.41,-5.38,-3.91,-2.47,-4.94,-7.22,-10.25,-16.06,-16.25,-17.12,-19.34,-18.25,-17.41,-17.84,-16.19,-16.47,-16.44,-14.72,-13.16,-11.34,-7.97,-6.09,-4.72,-3.28,-1.44,-1.44,-0.59,0.19,-1.97,-3.19,-4.03,-5.19,-6.78,-9.75,-8.59,-10.59,-12.41,-10.84,-10.94,-11.59,-11.72,-11.47,-14.47,-13.94,-15.66,-15.5,-13.81,-12.28,-8.72,-5.78,-4.84,-3.72,-3.31,-4.72,-6.28,-7.47,-9.91,-13.09,-15.84,-15.78,-20.31,-18.91,-15.84,-13.81,-8.97,-4.78,-2.59,-0.34,-0.81,0.16,-0.09,-1.47,-0.59,-2.19,-1.66,-1.72,-2.19,-1.47,-4.59,-4.44,-5.38,-6.34,-6.09,-7.22,-8.88,-11.31,-11.47,-13.12,-12.91,-16.0,-15.59,-14.75,-15.25,-14.12,-9.94,-6.09,-3.66,3.69,7.25,10.28,10.41,9.59,4.31,-0.59,-4.19,-5.97,-9.28,-10.91,-10.31,-11.59,-12.69,-12.72,-15.84,-13.03,-13.59,-12.78,-10.56,-8.81,-8.59,-6.44,-4.59,-3.53,-2.97,-3.09,-2.84,-5.66,-6.16,-8.09,-6.44,-4.88,-5.34,-2.84,-4.53,-4.06,-5.72,-6.03,-9.19,-8.28,-9.84,-12.16,-12.06,-13.03,-14.19,-14.44,-13.12,-13.19,-10.94,-10.53,-8.97,-9.16,-8.84,-7.09,-7.22,-6.91,-8.19,-12.22,-14.81,-19.34,-23.03,-26.94,-32.31,-35.62,-39.78,-42.84,-44.44,-45.12,-44.5,-45.69,-44.19,-44.62,-45.59,-45.97,-48.44,-51.66,-53.81,-55.81,-59.94,-60.34,-61.59,-64.03,-64.22,-61.84,-60.09,-57.28,-54.66,-51.94,-49.97,-49.56,-46.34,-44.91,-44.19,-44.44,-44.28,-47.34,-49.84,-51.34,-52.75,-53.06,-52.53,-53.16,-51.66,-49.88,-49.47,-44.84,-42.88,-39.5,-35.69,-33.28,-30.53,-29.72,-29.22,-28.28,-29.5,-29.91,-32.66,-32.03,-34.16,-34.03,-34.38,-34.53,-34.16,-35.94,-38.53,-37.97,-39.66,-40.09,-37.09,-37.53,-37.12,-36.03,-35.81,-36.53,-36.31,-35.66,-35.72,-38.44,-39.19,-43.16,-42.72,-43.44,-43.22,-41.41,-41.16,-41.72,-43.47,-42.53,-43.88,-44.03,-40.16,-36.41,-33.5,-30.47,-27.75,-27.03,-27.81,-28.56,-28.34,-28.41,-28.66,-29.72,-31.16,-30.97,-30.78,-30.94,-28.03,-28.62,-27.16,-28.16,-28.22,-27.28,-28.69,-26.72,-25.75,-24.31,-24.34,-25.16,-25.38,-28.75,-31.47,-35.0,-37.69,-38.97,-39.72,-39.16,-38.66,-36.59,-35.81,-35.59,-33.0,-7.72,-11.09,-15.16,-16.06,-16.62,-13.28,-10.28,-6.94,-2.34,-1.06,0.09,-0.91,0.94,-1.09,-3.69,-4.47,-9.34,-10.03:3.06,2.97,5.66,7.62,8.56,10.03,9.94,8.56,4.5,3.69,-1.06,-3.94,-7.09,-8.09,-11.28,-11.16,-9.75,-7.28,-3.75,1.25,4.12,6.91,8.31,9.06,10.38,10.78,12.25,12.56,13.62,12.06,13.66,12.88,13.47,11.97,11.72,13.88,14.09,15.31,19.41,18.0,16.06,14.41,10.41,7.81,5.84,3.31,2.97,2.16,1.31,3.19,2.69,3.69,4.88,3.41,3.75,3.19,1.91,1.44,0.69,0.0,0.47,2.09,3.25,3.94,5.84,4.41,5.12,4.19,4.66,4.31,2.91,3.06,-0.59,-2.53,-2.69,-4.72,-3.34,0.41,2.75,5.12,8.56,9.78,8.78,8.97,7.59,7.22,5.94,5.31,4.94,4.0,2.94,3.34,2.66,3.88,5.78,6.44,7.47,6.25,4.56,4.66,1.34,-0.03,0.22,0.53,0.28,3.62,3.47,5.28,7.31,6.91,6.06,5.06,6.03,4.0,3.53,4.31,4.75,4.91,1.47,1.53,2.0,1.62,2.81,5.12,6.75,5.88,6.22,5.94,6.59,7.19,6.69,6.16,5.03,2.81,2.31,3.03,3.31,6.84,7.41,10.66,10.41,11.25,10.09,9.0,7.03,5.16,3.12,2.12,1.69,3.94,4.66,7.47,11.66,12.47,12.56,15.81,15.38,14.88,15.06,13.72,11.94,10.41,10.25,8.5,10.22,8.88,8.0,7.84,4.72,1.88,0.5,1.38,1.56,5.41,8.91,9.16,12.84,10.38,11.91,12.88,13.97,14.19,14.19,13.56,12.34,11.88,9.78,6.5,6.66,5.44,5.22,6.75,9.0,9.69,10.28,10.06,8.44,8.16,8.78,8.97,8.78,9.75,10.56,9.81,9.78,10.81,10.5,11.41,10.56,9.19,8.31,6.34,4.84,3.41,0.75,3.31,2.69,4.88,6.88,7.44,8.88,11.16,11.66,15.09,16.28,17.75,18.5,19.69,19.25,16.62,15.03,11.38,6.94,3.31,1.59,0.69,-1.72,-1.59,-1.62,-3.22,-0.69,0.69,1.84,2.31,2.38,1.59,-1.31,-2.16,-4.66,-5.09,-5.59,-5.41,-4.69,-4.97,-5.16,-7.09,-6.03,-6.53,-6.34,-3.72,-5.72,-3.09,-4.66,-5.53,-5.81,-7.41,-7.34,-8.09,-7.47,-6.94,-6.34,-6.16,-4.81,-3.09,-0.53,2.31,3.44,5.25,3.91,4.19,3.41,3.81,5.66,5.78,6.5,8.16,7.66,8.88,8.84,8.25,6.84,1.81,-0.22,-0.78,-3.78,-4.44,-0.38,0.84,1.88,3.22,5.28,5.62,5.72,7.94,7.62,6.66,9.06,9.06,8.09,9.56,10.72,12.38,12.19,13.28,11.62,8.25,5.72,0.97,-0.81,-3.22,-4.59,-4.56,-5.59,-7.84,-7.62,-5.38,-5.66,-4.78,-1.28,-0.41,1.72,3.06,3.81,4.5,3.84,3.12,0.22,0.19,-3.03,-2.81,-4.84,-6.12,-4.47,-3.91,-1.88,0.53,1.06,3.75,4.31,5.34,6.56,7.38,7.25,5.31,3.91,2.78,0.97,2.97,4.78,8.09,7.81,9.84,10.62,7.41,6.34,6.31,2.78,1.88,-0.19,-0.56,-3.56,-2.34,-1.72,-0.34,0.84,1.06,2.31,1.75,0.88,1.31,1.41,-0.12,-0.56,0.16,-1.44,-1.59,-0.47,-2.69,-2.59,-4.44,-5.84,-5.53,-4.53,-2.94,-0.47,1.69,2.81,2.62,2.94,1.66,-0.47,-1.97,-1.44,-3.47,-1.84,-2.72,0.91,1.62,2.03,3.22,4.69,1.41,1.06,-1.19,-1.44,-1.56,-2.69,-0.72,-1.47,-0.16,0.56,2.34,4.72,6.03,9.94,10.34,8.66,7.41,3.91,1.31,-2.41,-4.22,-5.53,-5.91,-8.03,-8.09,-9.78,-8.84,-9.41,-10.28,-9.41,-8.31,-8.16,-6.09,-3.03,-3.84,-4.53,-1.28,-2.78,-2.06,-0.62,-0.34,0.22,-0.16,0.12,1.31,3.72,6.81,7.53,7.31,7.5,8.56,7.31,7.16,8.0,8.16,6.69,5.0,6.75,3.72,2.06,1.31,-3.09,-4.78,-7.81,-9.69,-11.62,-10.66,-7.94,-6.16,-3.25,-2.03,-0.75,-1.69,-3.06,-3.84,-4.91,-6.03,-5.22,-4.44,-2.0,0.62,1.75,2.47,2.09,-0.12,-3.09,-6.53,-6.84,-7.69,-7.72,-6.84,-4.22,-3.62,-3.47,-3.5,-4.19,-7.59,-9.22,-11.34,-13.16,-14.91,-12.97,-11.91,-10.59,-8.22,-5.59,-4.66,-2.72,-3.44,-3.28,-5.78,-5.31,-7.62,-7.97,-6.41,-6.28,-4.28,-3.44,-3.03,-4.03,-8.16,-7.81,-8.0,-9.16,-5.5,-4.03,-1.44,-0.97,-2.31,-1.41,-4.06,-5.22,-5.25,-7.09,-7.66,-10.03,-9.38,-10.34,-9.38,-6.97,-4.97,-3.09,-2.59,-2.91,-4.78,-5.69,-6.16,-6.88,-3.78,-2.34,-0.72,-0.12,-0.56,-2.94,-2.38,-4.34,-2.44,1.03,2.59,5.06,5.59,6.0,2.59,1.75,-0.75,-3.34,-5.75,-7.94,-8.28,-9.25,-10.62,-8.91,-6.41,-5.38,-3.91,-2.47,-4.94,-7.22,-10.25,-16.06,-16.25,-17.12,-19.34,-18.25,-17.41,-17.84,-16.19,-16.47,-16.44,-14.72,-13.16,-11.34,-7.97,-6.09,-4.72,-3.28,-1.44,-1.44,-0.59,0.19,-1.97,-3.19,-4.03,-5.19,-6.78,-9.75,-8.59,-10.59,-12.41,-10.84,-10.94,-11.59,-11.72,-11.47,-14.47,-13.94,-15.66,-15.5,-13.81,-12.28,-8.72,-5.78,-4.84,-3.72,-3.31,-4.72,-6.28,-7.47,-9.91,-13.09,-15.84,-15.78,-20.31,-18.91,-15.84,-13.81,-8.97,-4.78,-2.59,-0.34,-0.81,0.16,-0.09,-1.47,-0.59,-2.19,-1.66,-1.72,-2.19,-1.47,-4.59,-4.44,-5.38,-6.34,-6.09,-7.22,-8.88,-11.31,-11.47,-13.12,-12.91,-16.0,-15.59,-14.75,-15.25,-14.12,-9.94,-6.09,-3.66,3.69,7.25,10.28,10.41,9.59,4.31,-0.59,-4.19,-5.97,-9.28,-10.91,-10.31,-11.59,-12.69,-12.72,-15.84,-13.03,-13.59,-12.78,-10.56,-8.81,-8.59,-6.44,-4.59,-3.53,-2.97,-3.09,-2.84,-5.66,-6.16,-8.09,-6.44,-4.88,-5.34,-2.84,-4.53,-4.06,-5.72,-6.03,-9.19,-8.28,-9.84,-12.16,-12.06,-13.03,-14.19,-14.44,-13.12,-13.19,-10.94,-10.53,-8.97,-9.16,-8.84,-7.09,-7.22,-6.91,-8.19,-12.22,-14.81,-19.34,-23.03,-26.94,-32.31,-35.62,-39.78,-42.84,-44.44,-45.12,-44.5,-45.69,-44.19,-44.62,-45.59,-45.97,-48.44,-51.66,-53.81,-55.81,-59.94,-60.34,-61.59,-64.03,-64.22,-61.84,-60.09,-57.28,-54.66,-51.94,-49.97,-49.56,-46.34,-44.91,-44.19,-44.44,-44.28,-47.34,-49.84,-51.34,-52.75,-53.06,-52.53,-53.16,-51.66,-49.88,-49.47,-44.84,-42.88,-39.5,-35.69,-33.28,-30.53,-29.72,-29.22,-28.28,-29.5,-29.91,-32.66,-32.03,-34.16,-34.03,-34.38,-34.53,-34.16,-35.94,-38.53,-37.97,-39.66,-40.09,-37.09,-37.53,-37.12,-36.03,-35.81,-36.53,-36.31,-35.66,-35.72,-38.44,-39.19,-43.16,-42.72,-43.44,-43.22,-41.41,-41.16,-41.72,-43.47,-42.53,-43.88,-44.03,-40.16,-36.41,-33.5,-30.47,-27.75,-27.03,-27.81,-28.56,-28.34,-28.41,-28.66,-29.72,-31.16,-30.97,-30.78,-30.94,-28.03,-28.62,-27.16,-28.16,-28.22,-27.28,-28.69,-26.72,-25.75,-24.31,-24.34,-25.16,-25.38,-28.75,-31.47,-35.0,-37.69,-38.97,-39.72,-39.16,-38.66,-36.59,-35.81,-35.59,-33.0,-7.72,-11.09,-15.16,-16.06,-16.62,-13.28,-10.28,-6.94,-2.34,-1.06,0.09,-0.91,0.94,-1.09,-3.69,-4.47,-9.34,-10.03,-12.41,-10.94,-7.47,-3.72,-0.75,1.62:9.94,8.56,4.5,3.69,-1.06,-3.94,-7.09,-8.09,-11.28,-11.16,-9.75,-7.28,-3.75,1.25,4.12,6.91,8.31,9.06,10.38,10.78,12.25,12.56,13.62,12.06,13.66,12.88,13.47,11.97,11.72,13.88,14.09,15.31,19.41,18.0,16.06,14.41,10.41,7.81,5.84,3.31,2.97,2.16,1.31,3.19,2.69,3.69,4.88,3.41,3.75,3.19,1.91,1.44,0.69,0.0,0.47,2.09,3.25,3.94,5.84,4.41,5.12,4.19,4.66,4.31,2.91,3.06,-0.59,-2.53,-2.69,-4.72,-3.34,0.41,2.75,5.12,8.56,9.78,8.78,8.97,7.59,7.22,5.94,5.31,4.94,4.0,2.94,3.34,2.66,3.88,5.78,6.44,7.47,6.25,4.56,4.66,1.34,-0.03,0.22,0.53,0.28,3.62,3.47,5.28,7.31,6.91,6.06,5.06,6.03,4.0,3.53,4.31,4.75,4.91,1.47,1.53,2.0,1.62,2.81,5.12,6.75,5.88,6.22,5.94,6.59,7.19,6.69,6.16,5.03,2.81,2.31,3.03,3.31,6.84,7.41,10.66,10.41,11.25,10.09,9.0,7.03,5.16,3.12,2.12,1.69,3.94,4.66,7.47,11.66,12.47,12.56,15.81,15.38,14.88,15.06,13.72,11.94,10.41,10.25,8.5,10.22,8.88,8.0,7.84,4.72,1.88,0.5,1.38,1.56,5.41,8.91,9.16,12.84,10.38,11.91,12.88,13.97,14.19,14.19,13.56,12.34,11.88,9.78,6.5,6.66,5.44,5.22,6.75,9.0,9.69,10.28,10.06,8.44,8.16,8.78,8.97,8.78,9.75,10.56,9.81,9.78,10.81,10.5,11.41,10.56,9.19,8.31,6.34,4.84,3.41,0.75,3.31,2.69,4.88,6.88,7.44,8.88,11.16,11.66,15.09,16.28,17.75,18.5,19.69,19.25,16.62,15.03,11.38,6.94,3.31,1.59,0.69,-1.72,-1.59,-1.62,-3.22,-0.69,0.69,1.84,2.31,2.38,1.59,-1.31,-2.16,-4.66,-5.09,-5.59,-5.41,-4.69,-4.97,-5.16,-7.09,-6.03,-6.53,-6.34,-3.72,-5.72,-3.09,-4.66,-5.53,-5.81,-7.41,-7.34,-8.09,-7.47,-6.94,-6.34,-6.16,-4.81,-3.09,-0.53,2.31,3.44,5.25,3.91,4.19,3.41,3.81,5.66,5.78,6.5,8.16,7.66,8.88,8.84,8.25,6.84,1.81,-0.22,-0.78,-3.78,-4.44,-0.38,0.84,1.88,3.22,5.28,5.62,5.72,7.94,7.62,6.66,9.06,9.06,8.09,9.56,10.72,12.38,12.19,13.28,11.62,8.25,5.72,0.97,-0.81,-3.22,-4.59,-4.56,-5.59,-7.84,-7.62,-5.38,-5.66,-4.78,-1.28,-0.41,1.72,3.06,3.81,4.5,3.84,3.12,0.22,0.19,-3.03,-2.81,-4.84,-6.12,-4.47,-3.91,-1.88,0.53,1.06,3.75,4.31,5.34,6.56,7.38,7.25,5.31,3.91,2.78,0.97,2.97,4.78,8.09,7.81,9.84,10.62,7.41,6.34,6.31,2.78,1.88,-0.19,-0.56,-3.56,-2.34,-1.72,-0.34,0.84,1.06,2.31,1.75,0.88,1.31,1.41,-0.12,-0.56,0.16,-1.44,-1.59,-0.47,-2.69,-2.59,-4.44,-5.84,-5.53,-4.53,-2.94,-0.47,1.69,2.81,2.62,2.94,1.66,-0.47,-1.97,-1.44,-3.47,-1.84,-2.72,0.91,1.62,2.03,3.22,4.69,1.41,1.06,-1.19,-1.44,-1.56,-2.69,-0.72,-1.47,-0.16,0.56,2.34,4.72,6.03,9.94,10.34,8.66,7.41,3.91,1.31,-2.41,-4.22,-5.53,-5.91,-8.03,-8.09,-9.78,-8.84,-9.41,-10.28,-9.41,-8.31,-8.16,-6.09,-3.03,-3.84,-4.53,-1.28,-2.78,-2.06,-0.62,-0.34,0.22,-0.16,0.12,1.31,3.72,6.81,7.53,7.31,7.5,8.56,7.31,7.16,8.0,8.16,6.69,5.0,6.75,3.72,2.06,1.31,-3.09,-4.78,-7.81,-9.69,-11.62,-10.66,-7.94,-6.16,-3.25,-2.03,-0.75,-1.69,-3.06,-3.84,-4.91,-6.03,-5.22,-4.44,-2.0,0.62,1.75,2.47,2.09,-0.12,-3.09,-6.53,-6.84,-7.69,-7.72,-6.84,-4.22,-3.62,-3.47,-3.5,-4.19,-7.59,-9.22,-11.34,-13.16,-14.91,-12.97,-11.91,-10.59,-8.22,-5.59,-4.66,-2.72,-3.44,-3.28,-5.78,-5.31,-7.62,-7.97,-6.41,-6.28,-4.28,-3.44,-3.03,-4.03,-8.16,-7.81,-8.0,-9.16,-5.5,-4.03,-1.44,-0.97,-2.31,-1.41,-4.06,-5.22,-5.25,-7.09,-7.66,-10.03,-9.38,-10.34,-9.38,-6.97,-4.97,-3.09,-2.59,-2.91,-4.78,-5.69,-6.16,-6.88,-3.78,-2.34,-0.72,-0.12,-0.56,-2.94,-2.38,-4.34,-2.44,1.03,2.59,5.06,5.59,6.0,2.59,1.75,-0.75,-3.34,-5.75,-7.94,-8.28,-9.25,-10.62,-8.91,-6.41,-5.38,-3.91,-2.47,-4.94,-7.22,-10.25,-16.06,-16.25,-17.12,-19.34,-18.25,-17.41,-17.84,-16.19,-16.47,-16.44,-14.72,-13.16,-11.34,-7.97,-6.09,-4.72,-3.28,-1.44,-1.44,-0.59,0.19,-1.97,-3.19,-4.03,-5.19,-6.78,-9.75,-8.59,-10.59,-12.41,-10.84,-10.94,-11.59,-11.72,-11.47,-14.47,-13.94,-15.66,-15.5,-13.81,-12.28,-8.72,-5.78,-4.84,-3.72,-3.31,-4.72,-6.28,-7.47,-9.91,-13.09,-15.84,-15.78,-20.31,-18.91,-15.84,-13.81,-8.97,-4.78,-2.59,-0.34,-0.81,0.16,-0.09,-1.47,-0.59,-2.19,-1.66,-1.72,-2.19,-1.47,-4.59,-4.44,-5.38,-6.34,-6.09,-7.22,-8.88,-11.31,-11.47,-13.12,-12.91,-16.0,-15.59,-14.75,-15.25,-14.12,-9.94,-6.09,-3.66,3.69,7.25,10.28,10.41,9.59,4.31,-0.59,-4.19,-5.97,-9.28,-10.91,-10.31,-11.59,-12.69,-12.72,-15.84,-13.03,-13.59,-12.78,-10.56,-8.81,-8.59,-6.44,-4.59,-3.53,-2.97,-3.09,-2.84,-5.66,-6.16,-8.09,-6.44,-4.88,-5.34,-2.84,-4.53,-4.06,-5.72,-6.03,-9.19,-8.28,-9.84,-12.16,-12.06,-13.03,-14.19,-14.44,-13.12,-13.19,-10.94,-10.53,-8.97,-9.16,-8.84,-7.09,-7.22,-6.91,-8.19,-12.22,-14.81,-19.34,-23.03,-26.94,-32.31,-35.62,-39.78,-42.84,-44.44,-45.12,-44.5,-45.69,-44.19,-44.62,-45.59,-45.97,-48.44,-51.66,-53.81,-55.81,-59.94,-60.34,-61.59,-64.03,-64.22,-61.84,-60.09,-57.28,-54.66,-51.94,-49.97,-49.56,-46.34,-44.91,-44.19,-44.44,-44.28,-47.34,-49.84,-51.34,-52.75,-53.06,-52.53,-53.16,-51.66,-49.88,-49.47,-44.84,-42.88,-39.5,-35.69,-33.28,-30.53,-29.72,-29.22,-28.28,-29.5,-29.91,-32.66,-32.03,-34.16,-34.03,-34.38,-34.53,-34.16,-35.94,-38.53,-37.97,-39.66,-40.09,-37.09,-37.53,-37.12,-36.03,-35.81,-36.53,-36.31,-35.66,-35.72,-38.44,-39.19,-43.16,-42.72,-43.44,-43.22,-41.41,-41.16,-41.72,-43.47,-42.53,-43.88,-44.03,-40.16,-36.41,-33.5,-30.47,-27.75,-27.03,-27.81,-28.56,-28.34,-28.41,-28.66,-29.72,-31.16,-30.97,-30.78,-30.94,-28.03,-28.62,-27.16,-28.16,-28.22,-27.28,-28.69,-26.72,-25.75,-24.31,-24.34,-25.16,-25.38,-28.75,-31.47,-35.0,-37.69,-38.97,-39.72,-39.16,-38.66,-36.59,-35.81,-35.59,-33.0,-7.72,-11.09,-15.16,-16.06,-16.62,-13.28,-10.28,-6.94,-2.34,-1.06,0.09,-0.91,0.94,-1.09,-3.69,-4.47,-9.34,-10.03,-12.41,-10.94,-7.47,-3.72,-0.75,1.62,2.78,4.03,4.06,6.25,6.44,6.0:negativity
1.31,5.62,8.66,9.47,9.16,7.47,3.94,2.44,0.62,-0.59,-1.16,-2.91,-3.53,-3.5,-3.97,-4.53,-5.03,-3.75,-3.97,-3.47,-2.69,-1.34,-2.5,-2.41,-3.81,-5.59,-6.12,-6.78,-6.53,-5.03,-4.69,-4.34,-4.34,-4.41,-3.06,-1.91,0.31,2.56,3.59,5.34,5.28,5.41,6.0,4.31,2.84,2.66,-0.31,-2.59,-2.66,-4.16,-5.47,-4.62,-5.5,-5.16,-5.06,-6.03,-5.97,-5.16,-5.09,-5.25,-4.44,-4.16,-4.91,-6.0,-7.19,-7.78,-10.12,-10.66,-11.28,-12.28,-13.66,-14.09,-14.94,-15.84,-15.72,-17.41,-16.78,-17.62,-18.53,-17.91,-16.28,-16.94,-14.84,-13.91,-13.06,-11.91,-10.66,-10.31,-10.47,-11.22,-12.03,-13.91,-15.84,-17.84,-18.28,-18.81,-19.34,-17.38,-15.09,-13.72,-11.03,-10.44,-8.41,-7.72,-7.22,-6.97,-7.78,-9.19,-11.94,-13.97,-16.91,-18.25,-19.91,-20.34,-19.91,-20.09,-19.41,-20.72,-20.97,-23.0,-24.03,-25.28,-25.41,-24.16,-22.59,-21.34,-20.16,-18.28,-17.34,-15.0,-13.41,-10.69,-8.84,-7.03,-7.34,-7.66,-8.81,-9.22,-11.12,-11.69,-11.72,-11.56,-11.0,-11.69,-9.97,-11.72,-12.69,-13.22,-14.31,-15.38,-15.97,-16.28,-15.88,-17.59,-17.88,-16.94,-16.81,-15.75,-15.88,-15.41,-15.59,-16.72,-16.09,-15.56,-15.0,-14.97,-14.09,-14.72,-13.56,-13.28,-14.16,-13.44,-13.28,-14.97,-16.22,-16.94,-18.84,-19.0,-19.34,-20.12,-18.81,-18.34,-17.44,-16.91,-15.41,-15.06,-15.22,-14.78,-14.22,-13.75,-11.69,-10.34,-9.41,-8.91,-8.62,-9.72,-10.34,-11.22,-11.69,-12.72,-12.84,-14.03,-14.03,-13.06,-10.59,-9.28,-7.22,-5.31,-5.28,-7.16,-7.78,-9.84,-12.22,-13.41,-14.5,-15.47,-15.28,-15.0,-13.84,-13.59,-13.44,-12.91,-14.09,-14.34,-13.28,-13.72,-13.03,-11.84,-12.22,-11.47,-10.0,-9.72,-7.94,-6.16,-5.12,-4.72,-4.34,-3.91,-3.59,-0.81,-0.03,4.09,5.0,5.06,2.41,-0.38,-4.66,-8.31,-9.78,-10.62,-11.28,-10.53,-10.16,-9.5,-9.94,-11.22,-10.56,-10.09,-10.56,-8.06,-6.19,-4.12,-2.84,-1.94,-0.66,0.19,0.97,1.69,1.31,1.0,0.12,-2.03,-3.09,-5.28,-6.41,-8.97,-9.16,-10.69,-11.97,-11.56,-12.34,-11.19,-11.78,-9.16,-8.94,-7.59,-7.84,-6.41,-7.09,-6.09,-5.69,-6.06,-4.66,-5.34,-4.75,-6.44,-4.91,-4.69,-4.03,-2.16,-0.88,-1.06,0.16,-0.09,-0.88,-0.41,-0.22,-0.03,0.28,0.62,1.41,0.66,-0.03,-1.25,-2.81,-4.44,-5.69,-6.22,-7.59,-8.47,-7.88,-7.28,-7.03,-6.66,-7.09,-7.88,-10.09,-11.72,-13.0,-13.84,-14.31,-14.75,-14.41,-14.53,-13.94,-14.72,-14.34,-16.12,-15.59,-15.72,-15.09,-13.81,-12.66,-10.16,-8.97,-7.97,-6.47,-6.34,-4.81,-4.41,-5.0,-3.97,-2.81,-3.19,-2.28,-1.47,-1.41,-2.22,-2.12,-3.22,-5.44,-6.28,-6.66,-8.12,-7.22,-6.34,-5.59,-4.31,-4.69,-4.41,-3.75,-3.12,-2.41,-1.03,-0.06,0.22,0.5,1.12,1.66,0.44,0.72,1.34,0.94,1.31,2.66,4.34,5.72,5.72,5.28,5.34,3.5,1.75,1.78,1.31,0.41,0.88,1.44,1.12,0.91,1.91,1.19,0.75,-0.22,-1.03,-1.22,-2.0,-1.91,-0.44,0.19,0.06,1.31,0.75,0.28,0.41,-1.84,-2.44,-4.56,-5.75,-6.16,-7.09,-6.31,-6.0,-5.16,-3.81,-3.22,-1.97,-0.88,-0.56,-0.97,-0.75,-1.97,-2.12,-2.97,-1.84,-1.69,0.16,0.72,1.56,2.25,3.16,3.19,3.41,3.44,2.34,0.88,-1.44,-2.66,-3.78,-6.44,-6.69,-7.88,-7.59,-7.59,-6.28,-4.47,-2.09,-0.66,1.66,3.56,4.94,6.31,6.69,6.88,6.66,6.25,5.41,5.88,5.38,5.81,5.59,6.44,7.12,7.5,9.31,10.78,12.91,13.41,14.12,12.22,9.72,6.59,2.97,0.31,-0.88,-1.84,-2.56,-2.97,-3.78,-4.84,-5.31,-5.91,-6.16,-6.78,-6.78,-5.09,-4.34,-2.53,-0.47,0.06,-0.66,-1.69,-3.28,-4.59,-5.41,-5.22,-4.41,-4.28,-2.66,-2.41,-1.19,-1.09,-0.97,-1.72,-2.16,-2.94,-2.97,-2.56,-2.03,-1.12,-1.34,-0.81,-0.91,-1.38,-1.12,-0.59,0.09,-0.41,-0.41,-0.22,-1.44,-1.41,-2.31,-3.22,-3.88,-3.69,-3.28,-2.31,-1.34,-1.06,-2.19,-2.09,-2.69,-5.16,-3.88,-4.06,-4.59,-4.16,-5.09,-6.16,-8.0,-9.5,-10.22,-11.06,-11.28,-10.34,-9.53,-8.28,-7.34,-5.84,-4.97,-5.03,-4.34,-4.47,-4.34,-3.09,-4.22,-3.41,-3.66,-3.97,-3.59,-3.56,-3.53,-4.16,-4.59,-5.47,-6.47,-6.59,-5.47,-5.09,-4.59,-4.16,-4.94,-5.09,-6.22,-6.75,-7.38,-6.91,-7.56,-7.75,-8.59,-9.06,-9.81,-11.38,-12.91,-13.94,-15.06,-16.59,-17.34,-18.44,-18.81,-19.53,-19.66,-20.94,-20.94,-21.47,-22.03,-21.41,-20.28,-17.84,-16.59,-14.22,-13.41,-12.19,-13.16,-12.84,-14.16,-14.34,-16.03,-18.81,-20.44,-22.44,-24.38,-25.0,-24.09,-24.97,-24.19,-24.69,-24.97,-23.66,-22.22,-19.41,-16.72,-13.06,-10.19,-8.22,-6.41,-5.72,-6.97,-7.12,-8.59,-8.91,-9.31,-10.47,-9.75,-10.84,-10.59,-9.91,-9.59,-7.28,-6.56,-5.22,-4.09,-2.59,-2.31,-1.41,-1.41,-1.84,-3.31,-5.44,-6.66,-9.19,-9.97,-11.31,-11.69,-10.47,-9.25,-8.25,-6.28,-5.16,-5.34,-6.34,-6.69,-7.84,-10.28,-11.75,-13.94,-16.19,-18.88,-21.03,-22.59,-24.12,-23.91,-22.91,-20.88,-19.34,-16.59,-15.34,-14.34,-12.84,-13.22,-12.06,-11.59,-10.56,-10.12,-8.97,-9.31,-9.31,-8.66,-9.19,-7.06,-4.81,-1.09,2.66,7.97,11.19,13.66,13.81,12.91,10.94,7.62,4.81,2.34,0.44,-0.78,-1.28,-1.34,-1.84,-1.59,-1.28,-0.47,0.78,1.91,2.16,2.0,2.03,1.06,1.19,1.16,2.09,1.06,1.19,1.12,-0.16,-0.31,-0.19,-0.62,-0.47,-1.22,-0.84,-0.88,-0.25,0.44,0.62,0.81,-0.03,-0.91,-0.03,0.22,2.34,3.22,5.62,7.25,9.0,8.72,9.38,8.38,7.34,5.53,3.69,2.69,1.28,-0.34,-1.44,-3.66,-4.66,-4.94,-5.06,-5.19,-4.03,-4.16,-3.38,-3.0,-3.5,-3.03,-2.91,-3.34,-3.56,-2.5,-1.94,-1.75,-1.59,-0.31,-0.66,-1.47,-1.53,-3.59,-4.22,-5.38,-5.59,-5.09,-4.72,-3.53,-2.34,-1.59,-1.31,0.41,0.34,1.25,1.72,2.94,3.28,3.78,2.91,3.0,1.28,-0.66,-1.84,-4.88,-7.31,-8.69,-9.94,-10.81,-9.84,-9.22,-8.09,-7.91,-8.06,-7.78,-8.91,-9.41,-10.78,-11.59,-13.09,-14.09,-14.78,-15.16,-15.16,-15.09,-15.22,-14.53,-12.97,-12.97,-10.03,-8.72,-7.41,-7.34,-7.72,-8.28,-9.94,-11.81,-14.34,-14.31,-15.03,-14.38,-11.59,-10.34,-9.19,-8.47,-9.41,-12.19,-13.28,-14.53,-15.69,-14.53,-14.34,-14.22,-12.94,-13.97,-14.72,-14.53,-14.09,-12.78,-12.34,-11.06,-11.09,-10.84,-12.34,-13.38,-13.94,-16.53,-17.69,-18.16,-17.84,-19.25,-17.09,-18.0,-18.09,-18.03,-18.09,-16.81,-15.81,-14.34,-11.97,-10.56,-8.34,-6.53,-5.0,-5.38,-4.94,-5.66,-6.16,-6.84,-6.22,-6.0,-5.34,-5.31:3.94,2.44,0.62,-0.59,-1.16,-2.91,-3.53,-3.5,-3.97,-4.53,-5.03,-3.75,-3.97,-3.47,-2.69,-1.34,-2.5,-2.41,-3.81,-5.59,-6.12,-6.78,-6.53,-5.03,-4.69,-4.34,-4.34,-4.41,-3.06,-1.91,0.31,2.56,3.59,5.34,5.28,5.41,6.0,4.31,2.84,2.66,-0.31,-2.59,-2.66,-4.16,-5.47,-4.62,-5.5,-5.16,-5.06,-6.03,-5.97,-5.16,-5.09,-5.25,-4.44,-4.16,-4.91,-6.0,-7.19,-7.78,-10.12,-10.66,-11.28,-12.28,-13.66,-14.09,-14.94,-15.84,-15.72,-17.41,-16.78,-17.62,-18.53,-17.91,-16.28,-16.94,-14.84,-13.91,-13.06,-11.91,-10.66,-10.31,-10.47,-11.22,-12.03,-13.91,-15.84,-17.84,-18.28,-18.81,-19.34,-17.38,-15.09,-13.72,-11.03,-10.44,-8.41,-7.72,-7.22,-6.97,-7.78,-9.19,-11.94,-13.97,-16.91,-18.25,-19.91,-20.34,-19.91,-20.09,-19.41,-20.72,-20.97,-23.0,-24.03,-25.28,-25.41,-24.16,-22.59,-21.34,-20.16,-18.28,-17.34,-15.0,-13.41,-10.69,-8.84,-7.03,-7.34,-7.66,-8.81,-9.22,-11.12,-11.69,-11.72,-11.56,-11.0,-11.69,-9.97,-11.72,-12.69,-13.22,-14.31,-15.38,-15.97,-16.28,-15.88,-17.59,-17.88,-16.94,-16.81,-15.75,-15.88,-15.41,-15.59,-16.72,-16.09,-15.56,-15.0,-14.97,-14.09,-14.72,-13.56,-13.28,-14.16,-13.44,-13.28,-14.97,-16.22,-16.94,-18.84,-19.0,-19.34,-20.12,-18.81,-18.34,-17.44,-16.91,-15.41,-15.06,-15.22,-14.78,-14.22,-13.75,-11.69,-10.34,-9.41,-8.91,-8.62,-9.72,-10.34,-11.22,-11.69,-12.72,-12.84,-14.03,-14.03,-13.06,-10.59,-9.28,-7.22,-5.31,-5.28,-7.16,-7.78,-9.84,-12.22,-13.41,-14.5,-15.47,-15.28,-15.0,-13.84,-13.59,-13.44,-12.91,-14.09,-14.34,-13.28,-13.72,-13.03,-11.84,-12.22,-11.47,-10.0,-9.72,-7.94,-6.16,-5.12,-4.72,-4.34,-3.91,-3.59,-0.81,-0.03,4.09,5.0,5.06,2.41,-0.38,-4.66,-8.31,-9.78,-10.62,-11.28,-10.53,-10.16,-9.5,-9.94,-11.22,-10.56,-10.09,-10.56,-8.06,-6.19,-4.12,-2.84,-1.94,-0.66,0.19,0.97,1.69,1.31,1.0,0.12,-2.03,-3.09,-5.28,-6.41,-8.97,-9.16,-10.69,-11.97,-11.56,-12.34,-11.19,-11.78,-9.16,-8.94,-7.59,-7.84,-6.41,-7.09,-6.09,-5.69,-6.06,-4.66,-5.34,-4.75,-6.44,-4.91,-4.69,-4.03,-2.16,-0.88,-1.06,0.16,-0.09,-0.88,-0.41,-0.22,-0.03,0.28,0.62,1.41,0.66,-0.03,-1.25,-2.81,-4.44,-5.69,-6.22,-7.59,-8.47,-7.88,-7.28,-7.03,-6.66,-7.09,-7.88,-10.09,-11.72,-13.0,-13.84,-14.31,-14.75,-14.41,-14.53,-13.94,-14.72,-14.34,-16.12,-15.59,-15.72,-15.09,-13.81,-12.66,-10.16,-8.97,-7.97,-6.47,-6.34,-4.81,-4.41,-5.0,-3.97,-2.81,-3.19,-2.28,-1.47,-1.41,-2.22,-2.12,-3.22,-5.44,-6.28,-6.66,-8.12,-7.22,-6.34,-5.59,-4.31,-4.69,-4.41,-3.75,-3.12,-2.41,-1.03,-0.06,0.22,0.5,1.12,1.66,0.44,0.72,1.34,0.94,1.31,2.66,4.34,5.72,5.72,5.28,5.34,3.5,1.75,1.78,1.31,0.41,0.88,1.44,1.12,0.91,1.91,1.19,0.75,-0.22,-1.03,-1.22,-2.0,-1.91,-0.44,0.19,0.06,1.31,0.75,0.28,0.41,-1.84,-2.44,-4.56,-5.75,-6.16,-7.09,-6.31,-6.0,-5.16,-3.81,-3.22,-1.97,-0.88,-0.56,-0.97,-0.75,-1.97,-2.12,-2.97,-1.84,-1.69,0.16,0.72,1.56,2.25,3.16,3.19,3.41,3.44,2.34,0.88,-1.44,-2.66,-3.78,-6.44,-6.69,-7.88,-7.59,-7.59,-6.28,-4.47,-2.09,-0.66,1.66,3.56,4.94,6.31,6.69,6.88,6.66,6.25,5.41,5.88,5.38,5.81,5.59,6.44,7.12,7.5,9.31,10.78,12.91,13.41,14.12,12.22,9.72,6.59,2.97,0.31,-0.88,-1.84,-2.56,-2.97,-3.78,-4.84,-5.31,-5.91,-6.16,-6.78,-6.78,-5.09,-4.34,-2.53,-0.47,0.06,-0.66,-1.69,-3.28,-4.59,-5.41,-5.22,-4.41,-4.28,-2.66,-2.41,-1.19,-1.09,-0.97,-1.72,-2.16,-2.94,-2.97,-2.56,-2.03,-1.12,-1.34,-0.81,-0.91,-1.38,-1.12,-0.59,0.09,-0.41,-0.41,-0.22,-1.44,-1.41,-2.31,-3.22,-3.88,-3.69,-3.28,-2.31,-1.34,-1.06,-2.19,-2.09,-2.69,-5.16,-3.88,-4.06,-4.59,-4.16,-5.09,-6.16,-8.0,-9.5,-10.22,-11.06,-11.28,-10.34,-9.53,-8.28,-7.34,-5.84,-4.97,-5.03,-4.34,-4.47,-4.34,-3.09,-4.22,-3.41,-3.66,-3.97,-3.59,-3.56,-3.53,-4.16,-4.59,-5.47,-6.47,-6.59,-5.47,-5.09,-4.59,-4.16,-4.94,-5.09,-6.22,-6.75,-7.38,-6.91,-7.56,-7.75,-8.59,-9.06,-9.81,-11.38,-12.91,-13.94,-15.06,-16.59,-17.34,-18.44,-18.81,-19.53,-19.66,-20.94,-20.94,-21.47,-22.03,-21.41,-20.28,-17.84,-16.59,-14.22,-13.41,-12.19,-13.16,-12.84,-14.16,-14.34,-16.03,-18.81,-20.44,-22.44,-24.38,-25.0,-24.09,-24.97,-24.19,-24.69,-24.97,-23.66,-22.22,-19.41,-16.72,-13.06,-10.19,-8.22,-6.41,-5.72,-6.97,-7.12,-8.59,-8.91,-9.31,-10.47,-9.75,-10.84,-10.59,-9.91,-9.59,-7.28,-6.56,-5.22,-4.09,-2.59,-2.31,-1.41,-1.41,-1.84,-3.31,-5.44,-6.66,-9.19,-9.97,-11.31,-11.69,-10.47,-9.25,-8.25,-6.28,-5.16,-5.34,-6.34,-6.69,-7.84,-10.28,-11.75,-13.94,-16.19,-18.88,-21.03,-22.59,-24.12,-23.91,-22.91,-20.88,-19.34,-16.59,-15.34,-14.34,-12.84,-13.22,-12.06,-11.59,-10.56,-10.12,-8.97,-9.31,-9.31,-8.66,-9.19,-7.06,-4.81,-1.09,2.66,7.97,11.19,13.66,13.81,12.91,10.94,7.62,4.81,2.34,0.44,-0.78,-1.28,-1.34,-1.84,-1.59,-1.28,-0.47,0.78,1.91,2.16,2.0,2.03,1.06,1.19,1.16,2.09,1.06,1.19,1.12,-0.16,-0.31,-0.19,-0.62,-0.47,-1.22,-0.84,-0.88,-0.25,0.44,0.62,0.81,-0.03,-0.91,-0.03,0.22,2.34,3.22,5.62,7.25,9.0,8.72,9.38,8.38,7.34,5.53,3.69,2.69,1.28,-0.34,-1.44,-3.66,-4.66,-4.94,-5.06,-5.19,-4.03,-4.16,-3.38,-3.0,-3.5,-3.03,-2.91,-3.34,-3.56,-2.5,-1.94,-1.75,-1.59,-0.31,-0.66,-1.47,-1.53,-3.59,-4.22,-5.38,-5.59,-5.09,-4.72,-3.53,-2.34,-1.59,-1.31,0.41,0.34,1.25,1.72,2.94,3.28,3.78,2.91,3.0,1.28,-0.66,-1.84,-4.88,-7.31,-8.69,-9.94,-10.81,-9.84,-9.22,-8.09,-7.91,-8.06,-7.78,-8.91,-9.41,-10.78,-11.59,-13.09,-14.09,-14.78,-15.16,-15.16,-15.09,-15.22,-14.53,-12.97,-12.97,-10.03,-8.72,-7.41,-7.34,-7.72,-8.28,-9.94,-11.81,-14.34,-14.31,-15.03,-14.38,-11.59,-10.34,-9.19,-8.47,-9.41,-12.19,-13.28,-14.53,-15.69,-14.53,-14.34,-14.22,-12.94,-13.97,-14.72,-14.53,-14.09,-12.78,-12.34,-11.06,-11.09,-10.84,-12.34,-13.38,-13.94,-16.53,-17.69,-18.16,-17.84,-19.25,-17.09,-18.0,-18.09,-18.03,-18.09,-16.81,-15.81,-14.34,-11.97,-10.56,-8.34,-6.53,-5.0,-5.38,-4.94,-5.66,-6.16,-6.84,-6.22,-6.0,-5.34,-5.31,-20.34,-22.5,-23.59,-22.97,-22.53,-21.22:-3.53,-3.5,-3.97,-4.53,-5.03,-3.75,-3.97,-3.47,-2.69,-1.34,-2.5,-2.41,-3.81,-5.59,-6.12,-6.78,-6.53,-5.03,-4.69,-4.34,-4.34,-4.41,-3.06,-1.91,0.31,2.56,3.59,5.34,5.28,5.41,6.0,4.31,2.84,2.66,-0.31,-2.59,-2.66,-4.16,-5.47,-4.62,-5.5,-5.16,-5.06,-6.03,-5.97,-5.16,-5.09,-5.25,-4.44,-4.16,-4.91,-6.0,-7.19,-7.78,-10.12,-10.66,-11.28,-12.28,-13.66,-14.09,-14.94,-15.84,-15.72,-17.41,-16.78,-17.62,-18.53,-17.91,-16.28,-16.94,-14.84,-13.91,-13.06,-11.91,-10.66,-10.31,-10.47,-11.22,-12.03,-13.91,-15.84,-17.84,-18.28,-18.81,-19.34,-17.38,-15.09,-13.72,-11.03,-10.44,-8.41,-7.72,-7.22,-6.97,-7.78,-9.19,-11.94,-13.97,-16.91,-18.25,-19.91,-20.34,-19.91,-20.09,-19.41,-20.72,-20.97,-23.0,-24.03,-25.28,-25.41,-24.16,-22.59,-21.34,-20.16,-18.28,-17.34,-15.0,-13.41,-10.69,-8.84,-7.03,-7.34,-7.66,-8.81,-9.22,-11.12,-11.69,-11.72,-11.56,-11.0,-11.69,-9.97,-11.72,-12.69,-13.22,-14.31,-15.38,-15.97,-16.28,-15.88,-17.59,-17.88,-16.94,-16.81,-15.75,-15.88,-15.41,-15.59,-16.72,-16.09,-15.56,-15.0,-14.97,-14.09,-14.72,-13.56,-13.28,-14.16,-13.44,-13.28,-14.97,-16.22,-16.94,-18.84,-19.0,-19.34,-20.12,-18.81,-18.34,-17.44,-16.91,-15.41,-15.06,-15.22,-14.78,-14.22,-13.75,-11.69,-10.34,-9.41,-8.91,-8.62,-9.72,-10.34,-11.22,-11.69,-12.72,-12.84,-14.03,-14.03,-13.06,-10.59,-9.28,-7.22,-5.31,-5.28,-7.16,-7.78,-9.84,-12.22,-13.41,-14.5,-15.47,-15.28,-15.0,-13.84,-13.59,-13.44,-12.91,-14.09,-14.34,-13.28,-13.72,-13.03,-11.84,-12.22,-11.47,-10.0,-9.72,-7.94,-6.16,-5.12,-4.72,-4.34,-3.91,-3.59,-0.81,-0.03,4.09,5.0,5.06,2.41,-0.38,-4.66,-8.31,-9.78,-10.62,-11.28,-10.53,-10.16,-9.5,-9.94,-11.22,-10.56,-10.09,-10.56,-8.06,-6.19,-4.12,-2.84,-1.94,-0.66,0.19,0.97,1.69,1.31,1.0,0.12,-2.03,-3.09,-5.28,-6.41,-8.97,-9.16,-10.69,-11.97,-11.56,-12.34,-11.19,-11.78,-9.16,-8.94,-7.59,-7.84,-6.41,-7.09,-6.09,-5.69,-6.06,-4.66,-5.34,-4.75,-6.44,-4.91,-4.69,-4.03,-2.16,-0.88,-1.06,0.16,-0.09,-0.88,-0.41,-0.22,-0.03,0.28,0.62,1.41,0.66,-0.03,-1.25,-2.81,-4.44,-5.69,-6.22,-7.59,-8.47,-7.88,-7.28,-7.03,-6.66,-7.09,-7.88,-10.09,-11.72,-13.0,-13.84,-14.31,-14.75,-14.41,-14.53,-13.94,-14.72,-14.34,-16.12,-15.59,-15.72,-15.09,-13.81,-12.66,-10.16,-8.97,-7.97,-6.47,-6.34,-4.81,-4.41,-5.0,-3.97,-2.81,-3.19,-2.28,-1.47,-1.41,-2.22,-2.12,-3.22,-5.44,-6.28,-6.66,-8.12,-7.22,-6.34,-5.59,-4.31,-4.69,-4.41,-3.75,-3.12,-2.41,-1.03,-0.06,0.22,0.5,1.12,1.66,0.44,0.72,1.34,0.94,1.31,2.66,4.34,5.72,5.72,5.28,5.34,3.5,1.75,1.78,1.31,0.41,0.88,1.44,1.12,0.91,1.91,1.19,0.75,-0.22,-1.03,-1.22,-2.0,-1.91,-0.44,0.19,0.06,1.31,0.75,0.28,0.41,-1.84,-2.44,-4.56,-5.75,-6.16,-7.09,-6.31,-6.0,-5.16,-3.81,-3.22,-1.97,-0.88,-0.56,-0.97,-0.75,-1.97,-2.12,-2.97,-1.84,-1.69,0.16,0.72,1.56,2.25,3.16,3.19,3.41,3.44,2.34,0.88,-1.44,-2.66,-3.78,-6.44,-6.69,-7.88,-7.59,-7.59,-6.28,-4.47,-2.09,-0.66,1.66,3.56,4.94,6.31,6.69,6.88,6.66,6.25,5.41,5.88,5.38,5.81,5.59,6.44,7.12,7.5,9.31,10.78,12.91,13.41,14.12,12.22,9.72,6.59,2.97,0.31,-0.88,-1.84,-2.56,-2.97,-3.78,-4.84,-5.31,-5.91,-6.16,-6.78,-6.78,-5.09,-4.34,-2.53,-0.47,0.06,-0.66,-1.69,-3.28,-4.59,-5.41,-5.22,-4.41,-4.28,-2.66,-2.41,-1.19,-1.09,-0.97,-1.72,-2.16,-2.94,-2.97,-2.56,-2.03,-1.12,-1.34,-0.81,-0.91,-1.38,-1.12,-0.59,0.09,-0.41,-0.41,-0.22,-1.44,-1.41,-2.31,-3.22,-3.88,-3.69,-3.28,-2.31,-1.34,-1.06,-2.19,-2.09,-2.69,-5.16,-3.88,-4.06,-4.59,-4.16,-5.09,-6.16,-8.0,-9.5,-10.22,-11.06,-11.28,-10.34,-9.53,-8.28,-7.34,-5.84,-4.97,-5.03,-4.34,-4.47,-4.34,-3.09,-4.22,-3.41,-3.66,-3.97,-3.59,-3.56,-3.53,-4.16,-4.59,-5.47,-6.47,-6.59,-5.47,-5.09,-4.59,-4.16,-4.94,-5.09,-6.22,-6.75,-7.38,-6.91,-7.56,-7.75,-8.59,-9.06,-9.81,-11.38,-12.91,-13.94,-15.06,-16.59,-17.34,-18.44,-18.81,-19.53,-19.66,-20.94,-20.94,-21.47,-22.03,-21.41,-20.28,-17.84,-16.59,-14.22,-13.41,-12.19,-13.16,-12.84,-14.16,-14.34,-16.03,-18.81,-20.44,-22.44,-24.38,-25.0,-24.09,-24.97,-24.19,-24.69,-24.97,-23.66,-22.22,-19.41,-16.72,-13.06,-10.19,-8.22,-6.41,-5.72,-6.97,-7.12,-8.59,-8.91,-9.31,-10.47,-9.75,-10.84,-10.59,-9.91,-9.59,-7.28,-6.56,-5.22,-4.09,-2.59,-2.31,-1.41,-1.41,-1.84,-3.31,-5.44,-6.66,-9.19,-9.97,-11.31,-11.69,-10.47,-9.25,-8.25,-6.28,-5.16,-5.34,-6.34,-6.69,-7.84,-10.28,-11.75,-13.94,-16.19,-18.88,-21.03,-22.59,-24.12,-23.91,-22.91,-20.88,-19.34,-16.59,-15.34,-14.34,-12.84,-13.22,-12.06,-11.59,-10.56,-10.12,-8.97,-9.31,-9.31,-8.66,-9.19,-7.06,-4.81,-1.09,2.66,7.97,11.19,13.66,13.81,12.91,10.94,7.62,4.81,2.34,0.44,-0.78,-1.28,-1.34,-1.84,-1.59,-1.28,-0.47,0.78,1.91,2.16,2.0,2.03,1.06,1.19,1.16,2.09,1.06,1.19,1.12,-0.16,-0.31,-0.19,-0.62,-0.47,-1.22,-0.84,-0.88,-0.25,0.44,0.62,0.81,-0.03,-0.91,-0.03,0.22,2.34,3.22,5.62,7.25,9.0,8.72,9.38,8.38,7.34,5.53,3.69,2.69,1.28,-0.34,-1.44,-3.66,-4.66,-4.94,-5.06,-5.19,-4.03,-4.16,-3.38,-3.0,-3.5,-3.03,-2.91,-3.34,-3.56,-2.5,-1.94,-1.75,-1.59,-0.31,-0.66,-1.47,-1.53,-3.59,-4.22,-5.38,-5.59,-5.09,-4.72,-3.53,-2.34,-1.59,-1.31,0.41,0.34,1.25,1.72,2.94,3.28,3.78,2.91,3.0,1.28,-0.66,-1.84,-4.88,-7.31,-8.69,-9.94,-10.81,-9.84,-9.22,-8.09,-7.91,-8.06,-7.78,-8.91,-9.41,-10.78,-11.59,-13.09,-14.09,-14.78,-15.16,-15.16,-15.09,-15.22,-14.53,-12.97,-12.97,-10.03,-8.72,-7.41,-7.34,-7.72,-8.28,-9.94,-11.81,-14.34,-14.31,-15.03,-14.38,-11.59,-10.34,-9.19,-8.47,-9.41,-12.19,-13.28,-14.53,-15.69,-14.53,-14.34,-14.22,-12.94,-13.97,-14.72,-14.53,-14.09,-12.78,-12.34,-11.06,-11.09,-10.84,-12.34,-13.38,-13.94,-16.53,-17.69,-18.16,-17.84,-19.25,-17.09,-18.0,-18.09,-18.03,-18.09,-16.81,-15.81,-14.34,-11.97,-10.56,-8.34,-6.53,-5.0,-5.38,-4.94,-5.66,-6.16,-6.84,-6.22,-6.0,-5.34,-5.31,-20.34,-22.5,-23.59,-22.97,-22.53,-21.22,-19.78,-17.47,-15.31,-14.28,-13.59,-14.91:-3.97,-3.47,-2.69,-1.34,-2.5,-2.41,-3.81,-5.59,-6.12,-6.78,-6.53,-5.03,-4.69,-4.34,-4.34,-4.41,-3.06,-1.91,0.31,2.56,3.59,5.34,5.28,5.41,6.0,4.31,2.84,2.66,-0.31,-2.59,-2.66,-4.16,-5.47,-4.62,-5.5,-5.16,-5.06,-6.03,-5.97,-5.16,-5.09,-5.25,-4.44,-4.16,-4.91,-6.0,-7.19,-7.78,-10.12,-10.66,-11.28,-12.28,-13.66,-14.09,-14.94,-15.84,-15.72,-17.41,-16.78,-17.62,-18.53,-17.91,-16.28,-16.94,-14.84,-13.91,-13.06,-11.91,-10.66,-10.31,-10.47,-11.22,-12.03,-13.91,-15.84,-17.84,-18.28,-18.81,-19.34,-17.38,-15.09,-13.72,-11.03,-10.44,-8.41,-7.72,-7.22,-6.97,-7.78,-9.19,-11.94,-13.97,-16.91,-18.25,-19.91,-20.34,-19.91,-20.09,-19.41,-20.72,-20.97,-23.0,-24.03,-25.28,-25.41,-24.16,-22.59,-21.34,-20.16,-18.28,-17.34,-15.0,-13.41,-10.69,-8.84,-7.03,-7.34,-7.66,-8.81,-9.22,-11.12,-11.69,-11.72,-11.56,-11.0,-11.69,-9.97,-11.72,-12.69,-13.22,-14.31,-15.38,-15.97,-16.28,-15.88,-17.59,-17.88,-16.94,-16.81,-15.75,-15.88,-15.41,-15.59,-16.72,-16.09,-15.56,-15.0,-14.97,-14.09,-14.72,-13.56,-13.28,-14.16,-13.44,-13.28,-14.97,-16.22,-16.94,-18.84,-19.0,-19.34,-20.12,-18.81,-18.34,-17.44,-16.91,-15.41,-15.06,-15.22,-14.78,-14.22,-13.75,-11.69,-10.34,-9.41,-8.91,-8.62,-9.72,-10.34,-11.22,-11.69,-12.72,-12.84,-14.03,-14.03,-13.06,-10.59,-9.28,-7.22,-5.31,-5.28,-7.16,-7.78,-9.84,-12.22,-13.41,-14.5,-15.47,-15.28,-15.0,-13.84,-13.59,-13.44,-12.91,-14.09,-14.34,-13.28,-13.72,-13.03,-11.84,-12.22,-11.47,-10.0,-9.72,-7.94,-6.16,-5.12,-4.72,-4.34,-3.91,-3.59,-0.81,-0.03,4.09,5.0,5.06,2.41,-0.38,-4.66,-8.31,-9.78,-10.62,-11.28,-10.53,-10.16,-9.5,-9.94,-11.22,-10.56,-10.09,-10.56,-8.06,-6.19,-4.12,-2.84,-1.94,-0.66,0.19,0.97,1.69,1.31,1.0,0.12,-2.03,-3.09,-5.28,-6.41,-8.97,-9.16,-10.69,-11.97,-11.56,-12.34,-11.19,-11.78,-9.16,-8.94,-7.59,-7.84,-6.41,-7.09,-6.09,-5.69,-6.06,-4.66,-5.34,-4.75,-6.44,-4.91,-4.69,-4.03,-2.16,-0.88,-1.06,0.16,-0.09,-0.88,-0.41,-0.22,-0.03,0.28,0.62,1.41,0.66,-0.03,-1.25,-2.81,-4.44,-5.69,-6.22,-7.59,-8.47,-7.88,-7.28,-7.03,-6.66,-7.09,-7.88,-10.09,-11.72,-13.0,-13.84,-14.31,-14.75,-14.41,-14.53,-13.94,-14.72,-14.34,-16.12,-15.59,-15.72,-15.09,-13.81,-12.66,-10.16,-8.97,-7.97,-6.47,-6.34,-4.81,-4.41,-5.0,-3.97,-2.81,-3.19,-2.28,-1.47,-1.41,-2.22,-2.12,-3.22,-5.44,-6.28,-6.66,-8.12,-7.22,-6.34,-5.59,-4.31,-4.69,-4.41,-3.75,-3.12,-2.41,-1.03,-0.06,0.22,0.5,1.12,1.66,0.44,0.72,1.34,0.94,1.31,2.66,4.34,5.72,5.72,5.28,5.34,3.5,1.75,1.78,1.31,0.41,0.88,1.44,1.12,0.91,1.91,1.19,0.75,-0.22,-1.03,-1.22,-2.0,-1.91,-0.44,0.19,0.06,1.31,0.75,0.28,0.41,-1.84,-2.44,-4.56,-5.75,-6.16,-7.09,-6.31,-6.0,-5.16,-3.81,-3.22,-1.97,-0.88,-0.56,-0.97,-0.75,-1.97,-2.12,-2.97,-1.84,-1.69,0.16,0.72,1.56,2.25,3.16,3.19,3.41,3.44,2.34,0.88,-1.44,-2.66,-3.78,-6.44,-6.69,-7.88,-7.59,-7.59,-6.28,-4.47,-2.09,-0.66,1.66,3.56,4.94,6.31,6.69,6.88,6.66,6.25,5.41,5.88,5.38,5.81,5.59,6.44,7.12,7.5,9.31,10.78,12.91,13.41,14.12,12.22,9.72,6.59,2.97,0.31,-0.88,-1.84,-2.56,-2.97,-3.78,-4.84,-5.31,-5.91,-6.16,-6.78,-6.78,-5.09,-4.34,-2.53,-0.47,0.06,-0.66,-1.69,-3.28,-4.59,-5.41,-5.22,-4.41,-4.28,-2.66,-2.41,-1.19,-1.09,-0.97,-1.72,-2.16,-2.94,-2.97,-2.56,-2.03,-1.12,-1.34,-0.81,-0.91,-1.38,-1.12,-0.59,0.09,-0.41,-0.41,-0.22,-1.44,-1.41,-2.31,-3.22,-3.88,-3.69,-3.28,-2.31,-1.34,-1.06,-2.19,-2.09,-2.69,-5.16,-3.88,-4.06,-4.59,-4.16,-5.09,-6.16,-8.0,-9.5,-10.22,-11.06,-11.28,-10.34,-9.53,-8.28,-7.34,-5.84,-4.97,-5.03,-4.34,-4.47,-4.34,-3.09,-4.22,-3.41,-3.66,-3.97,-3.59,-3.56,-3.53,-4.16,-4.59,-5.47,-6.47,-6.59,-5.47,-5.09,-4.59,-4.16,-4.94,-5.09,-6.22,-6.75,-7.38,-6.91,-7.56,-7.75,-8.59,-9.06,-9.81,-11.38,-12.91,-13.94,-15.06,-16.59,-17.34,-18.44,-18.81,-19.53,-19.66,-20.94,-20.94,-21.47,-22.03,-21.41,-20.28,-17.84,-16.59,-14.22,-13.41,-12.19,-13.16,-12.84,-14.16,-14.34,-16.03,-18.81,-20.44,-22.44,-24.38,-25.0,-24.09,-24.97,-24.19,-24.69,-24.97,-23.66,-22.22,-19.41,-16.72,-13.06,-10.19,-8.22,-6.41,-5.72,-6.97,-7.12,-8.59,-8.91,-9.31,-10.47,-9.75,-10.84,-10.59,-9.91,-9.59,-7.28,-6.56,-5.22,-4.09,-2.59,-2.31,-1.41,-1.41,-1.84,-3.31,-5.44,-6.66,-9.19,-9.97,-11.31,-11.69,-10.47,-9.25,-8.25,-6.28,-5.16,-5.34,-6.34,-6.69,-7.84,-10.28,-11.75,-13.94,-16.19,-18.88,-21.03,-22.59,-24.12,-23.91,-22.91,-20.88,-19.34,-16.59,-15.34,-14.34,-12.84,-13.22,-12.06,-11.59,-10.56,-10.12,-8.97,-9.31,-9.31,-8.66,-9.19,-7.06,-4.81,-1.09,2.66,7.97,11.19,13.66,13.81,12.91,10.94,7.62,4.81,2.34,0.44,-0.78,-1.28,-1.34,-1.84,-1.59,-1.28,-0.47,0.78,1.91,2.16,2.0,2.03,1.06,1.19,1.16,2.09,1.06,1.19,1.12,-0.16,-0.31,-0.19,-0.62,-0.47,-1.22,-0.84,-0.88,-0.25,0.44,0.62,0.81,-0.03,-0.91,-0.03,0.22,2.34,3.22,5.62,7.25,9.0,8.72,9.38,8.38,7.34,5.53,3.69,2.69,1.28,-0.34,-1.44,-3.66,-4.66,-4.94,-5.06,-5.19,-4.03,-4.16,-3.38,-3.0,-3.5,-3.03,-2.91,-3.34,-3.56,-2.5,-1.94,-1.75,-1.59,-0.31,-0.66,-1.47,-1.53,-3.59,-4.22,-5.38,-5.59,-5.09,-4.72,-3.53,-2.34,-1.59,-1.31,0.41,0.34,1.25,1.72,2.94,3.28,3.78,2.91,3.0,1.28,-0.66,-1.84,-4.88,-7.31,-8.69,-9.94,-10.81,-9.84,-9.22,-8.09,-7.91,-8.06,-7.78,-8.91,-9.41,-10.78,-11.59,-13.09,-14.09,-14.78,-15.16,-15.16,-15.09,-15.22,-14.53,-12.97,-12.97,-10.03,-8.72,-7.41,-7.34,-7.72,-8.28,-9.94,-11.81,-14.34,-14.31,-15.03,-14.38,-11.59,-10.34,-9.19,-8.47,-9.41,-12.19,-13.28,-14.53,-15.69,-14.53,-14.34,-14.22,-12.94,-13.97,-14.72,-14.53,-14.09,-12.78,-12.34,-11.06,-11.09,-10.84,-12.34,-13.38,-13.94,-16.53,-17.69,-18.16,-17.84,-19.25,-17.09,-18.0,-18.09,-18.03,-18.09,-16.81,-15.81,-14.34,-11.97,-10.56,-8.34,-6.53,-5.0,-5.38,-4.94,-5.66,-6.16,-6.84,-6.22,-6.0,-5.34,-5.31,-20.34,-22.5,-23.59,-22.97,-22.53,-21.22,-19.78,-17.47,-15.31,-14.28,-13.59,-14.91,-14.5,-14.66,-15.31,-13.59,-13.38,-12.69:-3.81,-5.59,-6.12,-6.78,-6.53,-5.03,-4.69,-4.34,-4.34,-4.41,-3.06,-1.91,0.31,2.56,3.59,5.34,5.28,5.41,6.0,4.31,2.84,2.66,-0.31,-2.59,-2.66,-4.16,-5.47,-4.62,-5.5,-5.16,-5.06,-6.03,-5.97,-5.16,-5.09,-5.25,-4.44,-4.16,-4.91,-6.0,-7.19,-7.78,-10.12,-10.66,-11.28,-12.28,-13.66,-14.09,-14.94,-15.84,-15.72,-17.41,-16.78,-17.62,-18.53,-17.91,-16.28,-16.94,-14.84,-13.91,-13.06,-11.91,-10.66,-10.31,-10.47,-11.22,-12.03,-13.91,-15.84,-17.84,-18.28,-18.81,-19.34,-17.38,-15.09,-13.72,-11.03,-10.44,-8.41,-7.72,-7.22,-6.97,-7.78,-9.19,-11.94,-13.97,-16.91,-18.25,-19.91,-20.34,-19.91,-20.09,-19.41,-20.72,-20.97,-23.0,-24.03,-25.28,-25.41,-24.16,-22.59,-21.34,-20.16,-18.28,-17.34,-15.0,-13.41,-10.69,-8.84,-7.03,-7.34,-7.66,-8.81,-9.22,-11.12,-11.69,-11.72,-11.56,-11.0,-11.69,-9.97,-11.72,-12.69,-13.22,-14.31,-15.38,-15.97,-16.28,-15.88,-17.59,-17.88,-16.94,-16.81,-15.75,-15.88,-15.41,-15.59,-16.72,-16.09,-15.56,-15.0,-14.97,-14.09,-14.72,-13.56,-13.28,-14.16,-13.44,-13.28,-14.97,-16.22,-16.94,-18.84,-19.0,-19.34,-20.12,-18.81,-18.34,-17.44,-16.91,-15.41,-15.06,-15.22,-14.78,-14.22,-13.75,-11.69,-10.34,-9.41,-8.91,-8.62,-9.72,-10.34,-11.22,-11.69,-12.72,-12.84,-14.03,-14.03,-13.06,-10.59,-9.28,-7.22,-5.31,-5.28,-7.16,-7.78,-9.84,-12.22,-13.41,-14.5,-15.47,-15.28,-15.0,-13.84,-13.59,-13.44,-12.91,-14.09,-14.34,-13.28,-13.72,-13.03,-11.84,-12.22,-11.47,-10.0,-9.72,-7.94,-6.16,-5.12,-4.72,-4.34,-3.91,-3.59,-0.81,-0.03,4.09,5.0,5.06,2.41,-0.38,-4.66,-8.31,-9.78,-10.62,-11.28,-10.53,-10.16,-9.5,-9.94,-11.22,-10.56,-10.09,-10.56,-8.06,-6.19,-4.12,-2.84,-1.94,-0.66,0.19,0.97,1.69,1.31,1.0,0.12,-2.03,-3.09,-5.28,-6.41,-8.97,-9.16,-10.69,-11.97,-11.56,-12.34,-11.19,-11.78,-9.16,-8.94,-7.59,-7.84,-6.41,-7.09,-6.09,-5.69,-6.06,-4.66,-5.34,-4.75,-6.44,-4.91,-4.69,-4.03,-2.16,-0.88,-1.06,0.16,-0.09,-0.88,-0.41,-0.22,-0.03,0.28,0.62,1.41,0.66,-0.03,-1.25,-2.81,-4.44,-5.69,-6.22,-7.59,-8.47,-7.88,-7.28,-7.03,-6.66,-7.09,-7.88,-10.09,-11.72,-13.0,-13.84,-14.31,-14.75,-14.41,-14.53,-13.94,-14.72,-14.34,-16.12,-15.59,-15.72,-15.09,-13.81,-12.66,-10.16,-8.97,-7.97,-6.47,-6.34,-4.81,-4.41,-5.0,-3.97,-2.81,-3.19,-2.28,-1.47,-1.41,-2.22,-2.12,-3.22,-5.44,-6.28,-6.66,-8.12,-7.22,-6.34,-5.59,-4.31,-4.69,-4.41,-3.75,-3.12,-2.41,-1.03,-0.06,0.22,0.5,1.12,1.66,0.44,0.72,1.34,0.94,1.31,2.66,4.34,5.72,5.72,5.28,5.34,3.5,1.75,1.78,1.31,0.41,0.88,1.44,1.12,0.91,1.91,1.19,0.75,-0.22,-1.03,-1.22,-2.0,-1.91,-0.44,0.19,0.06,1.31,0.75,0.28,0.41,-1.84,-2.44,-4.56,-5.75,-6.16,-7.09,-6.31,-6.0,-5.16,-3.81,-3.22,-1.97,-0.88,-0.56,-0.97,-0.75,-1.97,-2.12,-2.97,-1.84,-1.69,0.16,0.72,1.56,2.25,3.16,3.19,3.41,3.44,2.34,0.88,-1.44,-2.66,-3.78,-6.44,-6.69,-7.88,-7.59,-7.59,-6.28,-4.47,-2.09,-0.66,1.66,3.56,4.94,6.31,6.69,6.88,6.66,6.25,5.41,5.88,5.38,5.81,5.59,6.44,7.12,7.5,9.31,10.78,12.91,13.41,14.12,12.22,9.72,6.59,2.97,0.31,-0.88,-1.84,-2.56,-2.97,-3.78,-4.84,-5.31,-5.91,-6.16,-6.78,-6.78,-5.09,-4.34,-2.53,-0.47,0.06,-0.66,-1.69,-3.28,-4.59,-5.41,-5.22,-4.41,-4.28,-2.66,-2.41,-1.19,-1.09,-0.97,-1.72,-2.16,-2.94,-2.97,-2.56,-2.03,-1.12,-1.34,-0.81,-0.91,-1.38,-1.12,-0.59,0.09,-0.41,-0.41,-0.22,-1.44,-1.41,-2.31,-3.22,-3.88,-3.69,-3.28,-2.31,-1.34,-1.06,-2.19,-2.09,-2.69,-5.16,-3.88,-4.06,-4.59,-4.16,-5.09,-6.16,-8.0,-9.5,-10.22,-11.06,-11.28,-10.34,-9.53,-8.28,-7.34,-5.84,-4.97,-5.03,-4.34,-4.47,-4.34,-3.09,-4.22,-3.41,-3.66,-3.97,-3.59,-3.56,-3.53,-4.16,-4.59,-5.47,-6.47,-6.59,-5.47,-5.09,-4.59,-4.16,-4.94,-5.09,-6.22,-6.75,-7.38,-6.91,-7.56,-7.75,-8.59,-9.06,-9.81,-11.38,-12.91,-13.94,-15.06,-16.59,-17.34,-18.44,-18.81,-19.53,-19.66,-20.94,-20.94,-21.47,-22.03,-21.41,-20.28,-17.84,-16.59,-14.22,-13.41,-12.19,-13.16,-12.84,-14.16,-14.34,-16.03,-18.81,-20.44,-22.44,-24.38,-25.0,-24.09,-24.97,-24.19,-24.69,-24.97,-23.66,-22.22,-19.41,-16.72,-13.06,-10.19,-8.22,-6.41,-5.72,-6.97,-7.12,-8.59,-8.91,-9.31,-10.47,-9.75,-10.84,-10.59,-9.91,-9.59,-7.28,-6.56,-5.22,-4.09,-2.59,-2.31,-1.41,-1.41,-1.84,-3.31,-5.44,-6.66,-9.19,-9.97,-11.31,-11.69,-10.47,-9.25,-8.25,-6.28,-5.16,-5.34,-6.34,-6.69,-7.84,-10.28,-11.75,-13.94,-16.19,-18.88,-21.03,-22.59,-24.12,-23.91,-22.91,-20.88,-19.34,-16.59,-15.34,-14.34,-12.84,-13.22,-12.06,-11.59,-10.56,-10.12,-8.97,-9.31,-9.31,-8.66,-9.19,-7.06,-4.81,-1.09,2.66,7.97,11.19,13.66,13.81,12.91,10.94,7.62,4.81,2.34,0.44,-0.78,-1.28,-1.34,-1.84,-1.59,-1.28,-0.47,0.78,1.91,2.16,2.0,2.03,1.06,1.19,1.16,2.09,1.06,1.19,1.12,-0.16,-0.31,-0.19,-0.62,-0.47,-1.22,-0.84,-0.88,-0.25,0.44,0.62,0.81,-0.03,-0.91,-0.03,0.22,2.34,3.22,5.62,7.25,9.0,8.72,9.38,8.38,7.34,5.53,3.69,2.69,1.28,-0.34,-1.44,-3.66,-4.66,-4.94,-5.06,-5.19,-4.03,-4.16,-3.38,-3.0,-3.5,-3.03,-2.91,-3.34,-3.56,-2.5,-1.94,-1.75,-1.59,-0.31,-0.66,-1.47,-1.53,-3.59,-4.22,-5.38,-5.59,-5.09,-4.72,-3.53,-2.34,-1.59,-1.31,0.41,0.34,1.25,1.72,2.94,3.28,3.78,2.91,3.0,1.28,-0.66,-1.84,-4.88,-7.31,-8.69,-9.94,-10.81,-9.84,-9.22,-8.09,-7.91,-8.06,-7.78,-8.91,-9.41,-10.78,-11.59,-13.09,-14.09,-14.78,-15.16,-15.16,-15.09,-15.22,-14.53,-12.97,-12.97,-10.03,-8.72,-7.41,-7.34,-7.72,-8.28,-9.94,-11.81,-14.34,-14.31,-15.03,-14.38,-11.59,-10.34,-9.19,-8.47,-9.41,-12.19,-13.28,-14.53,-15.69,-14.53,-14.34,-14.22,-12.94,-13.97,-14.72,-14.53,-14.09,-12.78,-12.34,-11.06,-11.09,-10.84,-12.34,-13.38,-13.94,-16.53,-17.69,-18.16,-17.84,-19.25,-17.09,-18.0,-18.09,-18.03,-18.09,-16.81,-15.81,-14.34,-11.97,-10.56,-8.34,-6.53,-5.0,-5.38,-4.94,-5.66,-6.16,-6.84,-6.22,-6.0,-5.34,-5.31,-20.34,-22.5,-23.59,-22.97,-22.53,-21.22,-19.78,-17.47,-15.31,-14.28,-13.59,-14.91,-14.5,-14.66,-15.31,-13.59,-13.38,-12.69,-13.06,-13.03,-12.91,-12.06,-12.03,-12.19:-4.69,-4.34,-4.34,-4.41,-3.06,-1.91,0.31,2.56,3.59,5.34,5.28,5.41,6.0,4.31,2.84,2.66,-0.31,-2.59,-2.66,-4.16,-5.47,-4.62,-5.5,-5.16,-5.06,-6.03,-5.97,-5.16,-5.09,-5.25,-4.44,-4.16,-4.91,-6.0,-7.19,-7.78,-10.12,-10.66,-11.28,-12.28,-13.66,-14.09,-14.94,-15.84,-15.72,-17.41,-16.78,-17.62,-18.53,-17.91,-16.28,-16.94,-14.84,-13.91,-13.06,-11.91,-10.66,-10.31,-10.47,-11.22,-12.03,-13.91,-15.84,-17.84,-18.28,-18.81,-19.34,-17.38,-15.09,-13.72,-11.03,-10.44,-8.41,-7.72,-7.22,-6.97,-7.78,-9.19,-11.94,-13.97,-16.91,-18.25,-19.91,-20.34,-19.91,-20.09,-19.41,-20.72,-20.97,-23.0,-24.03,-25.28,-25.41,-24.16,-22.59,-21.34,-20.16,-18.28,-17.34,-15.0,-13.41,-10.69,-8.84,-7.03,-7.34,-7.66,-8.81,-9.22,-11.12,-11.69,-11.72,-11.56,-11.0,-11.69,-9.97,-11.72,-12.69,-13.22,-14.31,-15.38,-15.97,-16.28,-15.88,-17.59,-17.88,-16.94,-16.81,-15.75,-15.88,-15.41,-15.59,-16.72,-16.09,-15.56,-15.0,-14.97,-14.09,-14.72,-13.56,-13.28,-14.16,-13.44,-13.28,-14.97,-16.22,-16.94,-18.84,-19.0,-19.34,-20.12,-18.81,-18.34,-17.44,-16.91,-15.41,-15.06,-15.22,-14.78,-14.22,-13.75,-11.69,-10.34,-9.41,-8.91,-8.62,-9.72,-10.34,-11.22,-11.69,-12.72,-12.84,-14.03,-14.03,-13.06,-10.59,-9.28,-7.22,-5.31,-5.28,-7.16,-7.78,-9.84,-12.22,-13.41,-14.5,-15.47,-15.28,-15.0,-13.84,-13.59,-13.44,-12.91,-14.09,-14.34,-13.28,-13.72,-13.03,-11.84,-12.22,-11.47,-10.0,-9.72,-7.94,-6.16,-5.12,-4.72,-4.34,-3.91,-3.59,-0.81,-0.03,4.09,5.0,5.06,2.41,-0.38,-4.66,-8.31,-9.78,-10.62,-11.28,-10.53,-10.16,-9.5,-9.94,-11.22,-10.56,-10.09,-10.56,-8.06,-6.19,-4.12,-2.84,-1.94,-0.66,0.19,0.97,1.69,1.31,1.0,0.12,-2.03,-3.09,-5.28,-6.41,-8.97,-9.16,-10.69,-11.97,-11.56,-12.34,-11.19,-11.78,-9.16,-8.94,-7.59,-7.84,-6.41,-7.09,-6.09,-5.69,-6.06,-4.66,-5.34,-4.75,-6.44,-4.91,-4.69,-4.03,-2.16,-0.88,-1.06,0.16,-0.09,-0.88,-0.41,-0.22,-0.03,0.28,0.62,1.41,0.66,-0.03,-1.25,-2.81,-4.44,-5.69,-6.22,-7.59,-8.47,-7.88,-7.28,-7.03,-6.66,-7.09,-7.88,-10.09,-11.72,-13.0,-13.84,-14.31,-14.75,-14.41,-14.53,-13.94,-14.72,-14.34,-16.12,-15.59,-15.72,-15.09,-13.81,-12.66,-10.16,-8.97,-7.97,-6.47,-6.34,-4.81,-4.41,-5.0,-3.97,-2.81,-3.19,-2.28,-1.47,-1.41,-2.22,-2.12,-3.22,-5.44,-6.28,-6.66,-8.12,-7.22,-6.34,-5.59,-4.31,-4.69,-4.41,-3.75,-3.12,-2.41,-1.03,-0.06,0.22,0.5,1.12,1.66,0.44,0.72,1.34,0.94,1.31,2.66,4.34,5.72,5.72,5.28,5.34,3.5,1.75,1.78,1.31,0.41,0.88,1.44,1.12,0.91,1.91,1.19,0.75,-0.22,-1.03,-1.22,-2.0,-1.91,-0.44,0.19,0.06,1.31,0.75,0.28,0.41,-1.84,-2.44,-4.56,-5.75,-6.16,-7.09,-6.31,-6.0,-5.16,-3.81,-3.22,-1.97,-0.88,-0.56,-0.97,-0.75,-1.97,-2.12,-2.97,-1.84,-1.69,0.16,0.72,1.56,2.25,3.16,3.19,3.41,3.44,2.34,0.88,-1.44,-2.66,-3.78,-6.44,-6.69,-7.88,-7.59,-7.59,-6.28,-4.47,-2.09,-0.66,1.66,3.56,4.94,6.31,6.69,6.88,6.66,6.25,5.41,5.88,5.38,5.81,5.59,6.44,7.12,7.5,9.31,10.78,12.91,13.41,14.12,12.22,9.72,6.59,2.97,0.31,-0.88,-1.84,-2.56,-2.97,-3.78,-4.84,-5.31,-5.91,-6.16,-6.78,-6.78,-5.09,-4.34,-2.53,-0.47,0.06,-0.66,-1.69,-3.28,-4.59,-5.41,-5.22,-4.41,-4.28,-2.66,-2.41,-1.19,-1.09,-0.97,-1.72,-2.16,-2.94,-2.97,-2.56,-2.03,-1.12,-1.34,-0.81,-0.91,-1.38,-1.12,-0.59,0.09,-0.41,-0.41,-0.22,-1.44,-1.41,-2.31,-3.22,-3.88,-3.69,-3.28,-2.31,-1.34,-1.06,-2.19,-2.09,-2.69,-5.16,-3.88,-4.06,-4.59,-4.16,-5.09,-6.16,-8.0,-9.5,-10.22,-11.06,-11.28,-10.34,-9.53,-8.28,-7.34,-5.84,-4.97,-5.03,-4.34,-4.47,-4.34,-3.09,-4.22,-3.41,-3.66,-3.97,-3.59,-3.56,-3.53,-4.16,-4.59,-5.47,-6.47,-6.59,-5.47,-5.09,-4.59,-4.16,-4.94,-5.09,-6.22,-6.75,-7.38,-6.91,-7.56,-7.75,-8.59,-9.06,-9.81,-11.38,-12.91,-13.94,-15.06,-16.59,-17.34,-18.44,-18.81,-19.53,-19.66,-20.94,-20.94,-21.47,-22.03,-21.41,-20.28,-17.84,-16.59,-14.22,-13.41,-12.19,-13.16,-12.84,-14.16,-14.34,-16.03,-18.81,-20.44,-22.44,-24.38,-25.0,-24.09,-24.97,-24.19,-24.69,-24.97,-23.66,-22.22,-19.41,-16.72,-13.06,-10.19,-8.22,-6.41,-5.72,-6.97,-7.12,-8.59,-8.91,-9.31,-10.47,-9.75,-10.84,-10.59,-9.91,-9.59,-7.28,-6.56,-5.22,-4.09,-2.59,-2.31,-1.41,-1.41,-1.84,-3.31,-5.44,-6.66,-9.19,-9.97,-11.31,-11.69,-10.47,-9.25,-8.25,-6.28,-5.16,-5.34,-6.34,-6.69,-7.84,-10.28,-11.75,-13.94,-16.19,-18.88,-21.03,-22.59,-24.12,-23.91,-22.91,-20.88,-19.34,-16.59,-15.34,-14.34,-12.84,-13.22,-12.06,-11.59,-10.56,-10.12,-8.97,-9.31,-9.31,-8.66,-9.19,-7.06,-4.81,-1.09,2.66,7.97,11.19,13.66,13.81,12.91,10.94,7.62,4.81,2.34,0.44,-0.78,-1.28,-1.34,-1.84,-1.59,-1.28,-0.47,0.78,1.91,2.16,2.0,2.03,1.06,1.19,1.16,2.09,1.06,1.19,1.12,-0.16,-0.31,-0.19,-0.62,-0.47,-1.22,-0.84,-0.88,-0.25,0.44,0.62,0.81,-0.03,-0.91,-0.03,0.22,2.34,3.22,5.62,7.25,9.0,8.72,9.38,8.38,7.34,5.53,3.69,2.69,1.28,-0.34,-1.44,-3.66,-4.66,-4.94,-5.06,-5.19,-4.03,-4.16,-3.38,-3.0,-3.5,-3.03,-2.91,-3.34,-3.56,-2.5,-1.94,-1.75,-1.59,-0.31,-0.66,-1.47,-1.53,-3.59,-4.22,-5.38,-5.59,-5.09,-4.72,-3.53,-2.34,-1.59,-1.31,0.41,0.34,1.25,1.72,2.94,3.28,3.78,2.91,3.0,1.28,-0.66,-1.84,-4.88,-7.31,-8.69,-9.94,-10.81,-9.84,-9.22,-8.09,-7.91,-8.06,-7.78,-8.91,-9.41,-10.78,-11.59,-13.09,-14.09,-14.78,-15.16,-15.16,-15.09,-15.22,-14.53,-12.97,-12.97,-10.03,-8.72,-7.41,-7.34,-7.72,-8.28,-9.94,-11.81,-14.34,-14.31,-15.03,-14.38,-11.59,-10.34,-9.19,-8.47,-9.41,-12.19,-13.28,-14.53,-15.69,-14.53,-14.34,-14.22,-12.94,-13.97,-14.72,-14.53,-14.09,-12.78,-12.34,-11.06,-11.09,-10.84,-12.34,-13.38,-13.94,-16.53,-17.69,-18.16,-17.84,-19.25,-17.09,-18.0,-18.09,-18.03,-18.09,-16.81,-15.81,-14.34,-11.97,-10.56,-8.34,-6.53,-5.0,-5.38,-4.94,-5.66,-6.16,-6.84,-6.22,-6.0,-5.34,-5.31,-20.34,-22.5,-23.59,-22.97,-22.53,-21.22,-19.78,-17.47,-15.31,-14.28,-13.59,-14.91,-14.5,-14.66,-15.31,-13.59,-13.38,-12.69,-13.06,-13.03,-12.91,-12.06,-12.03,-12.19,-13.34,-15.78,-17.09,-20.06,-20.25,-19.88:positivity
4.0,1.0,-2.97,-5.53,-7.69,-8.66,-8.19,-7.16,-5.5,-2.62,-0.28,1.28,3.25,5.22,5.88,6.34,5.53,4.81,3.25,1.72,0.78,0.28,0.56,2.34,3.44,5.59,8.41,9.19,10.38,10.66,9.91,8.12,7.0,5.56,4.28,2.28,1.66,0.56,-0.28,0.03,0.31,1.34,2.59,2.88,3.66,4.81,5.5,6.53,8.47,9.97,9.81,8.78,7.06,4.44,2.91,-1.06,-3.28,-6.31,-9.84,-13.06,-15.62,-18.31,-20.16,-21.78,-21.41,-22.03,-21.84,-20.91,-21.44,-19.34,-19.47,-18.22,-18.03,-18.78,-19.94,-20.97,-22.47,-21.53,-22.31,-21.78,-20.94,-20.59,-20.16,-18.81,-17.34,-16.03,-13.62,-11.94,-10.53,-8.47,-8.09,-7.09,-6.91,-5.75,-5.34,-4.38,-3.66,-2.97,-1.81,-0.53,0.09,1.31,3.03,2.12,1.53,0.09,-2.22,-5.53,-7.66,-10.16,-11.59,-13.75,-13.88,-13.44,-12.34,-9.78,-6.41,-3.84,-0.62,-0.38,-0.28,-1.78,-3.47,-6.69,-7.72,-8.47,-8.53,-7.81,-7.06,-5.97,-5.5,-5.16,-5.16,-5.09,-4.91,-4.53,-4.47,-4.19,-4.47,-4.81,-6.22,-7.78,-8.78,-9.34,-9.06,-8.94,-7.22,-5.97,-4.62,-2.97,-0.59,0.53,2.31,4.09,4.78,6.34,6.44,5.88,4.78,3.53,1.59,0.16,-0.69,-2.06,-3.97,-5.28,-6.97,-7.53,-8.09,-7.34,-5.41,-2.84,-0.59,1.56,2.94,1.53,0.06,-2.88,-5.81,-8.97,-11.47,-12.97,-13.03,-10.03,-7.31,-1.81,1.69,5.09,7.66,7.53,7.38,6.28,4.28,2.72,-0.19,-2.47,-4.34,-6.38,-7.09,-8.47,-10.09,-10.84,-12.06,-13.12,-13.84,-13.97,-12.34,-10.97,-8.34,-5.34,-2.25,-1.91,-0.69,-1.84,-3.28,-6.25,-8.53,-9.84,-10.59,-11.84,-11.44,-11.84,-11.75,-13.31,-13.94,-15.59,-16.81,-17.84,-19.31,-20.0,-19.06,-18.44,-17.53,-16.25,-15.84,-17.09,-18.34,-20.97,-22.12,-22.72,-23.16,-21.88,-21.0,-19.59,-18.81,-18.31,-18.81,-19.94,-20.81,-22.0,-22.81,-21.88,-21.41,-20.97,-18.97,-18.69,-17.44,-16.91,-16.22,-15.81,-15.66,-15.41,-15.59,-15.41,-15.5,-16.09,-16.34,-16.81,-17.09,-16.16,-15.34,-12.59,-10.75,-8.59,-7.28,-6.62,-5.97,-6.09,-7.19,-7.09,-7.59,-8.66,-9.59,-11.84,-13.16,-15.44,-16.03,-17.28,-17.44,-15.94,-14.78,-12.88,-10.31,-6.53,-4.0,-1.47,1.22,1.81,2.03,0.78,-0.97,-3.16,-5.56,-7.41,-7.47,-6.97,-5.94,-5.03,-3.66,-3.31,-3.12,-2.75,-3.16,-3.38,-4.69,-5.41,-5.94,-5.84,-5.56,-4.56,-4.09,-2.78,-3.88,-2.03,-2.75,-1.81,-1.84,-2.28,-1.97,-3.28,-4.88,-6.09,-8.84,-10.53,-12.47,-12.62,-12.53,-10.22,-7.72,-4.59,-1.5,0.69,2.41,3.0,1.78,-0.09,-2.53,-5.03,-7.19,-7.81,-7.38,-5.44,-3.5,-1.78,-0.94,-0.97,-2.09,-4.22,-6.16,-8.84,-10.84,-11.09,-10.09,-6.81,-1.59,2.5,5.84,5.94,4.16,-0.03,-4.91,-8.03,-10.56,-11.72,-12.81,-12.41,-10.69,-9.97,-9.34,-7.97,-6.78,-6.59,-5.09,-4.91,-4.75,-4.59,-6.22,-8.72,-11.5,-13.69,-16.28,-17.34,-16.53,-16.03,-14.47,-13.25,-11.94,-10.84,-10.22,-8.94,-7.69,-6.97,-5.91,-4.97,-4.97,-5.34,-6.0,-6.47,-6.84,-5.78,-3.03,-0.41,3.59,5.88,7.84,8.06,7.44,6.34,3.31,0.06,-3.12,-7.5,-8.84,-8.91,-8.66,-5.84,-3.84,-2.25,-1.22,-1.97,-3.09,-5.47,-7.03,-10.03,-11.97,-13.69,-14.66,-14.09,-12.72,-11.12,-9.66,-8.38,-8.22,-7.97,-9.78,-10.34,-12.22,-14.97,-17.16,-19.0,-20.78,-21.59,-22.09,-20.53,-20.28,-19.06,-18.72,-17.97,-17.44,-18.19,-18.19,-17.44,-16.28,-15.38,-13.91,-12.78,-12.03,-12.59,-13.38,-13.94,-14.44,-14.66,-15.91,-15.41,-15.0,-15.22,-14.59,-14.59,-15.34,-15.06,-14.84,-14.47,-13.91,-13.22,-11.97,-13.66,-12.94,-14.03,-14.09,-15.59,-16.59,-17.94,-19.69,-21.75,-23.22,-24.94,-25.88,-27.88,-29.25,-30.12,-30.84,-31.03,-31.22,-29.56,-28.41,-27.34,-25.84,-23.81,-22.44,-21.03,-20.06,-19.72,-20.16,-19.94,-20.47,-21.47,-21.72,-22.16,-22.97,-22.56,-20.34,-18.38,-16.41,-14.25,-13.53,-12.59,-13.44,-13.78,-13.44,-12.5,-11.66,-9.31,-7.34,-5.03,-4.09,-3.88,-4.38,-4.59,-6.06,-7.41,-7.47,-8.97,-10.84,-13.09,-15.72,-18.5,-21.09,-23.59,-23.78,-23.69,-21.44,-17.97,-13.44,-8.22,-3.09,1.03,3.31,4.81,4.25,1.41,-1.59,-4.34,-7.84,-11.09,-13.56,-16.06,-17.06,-18.41,-18.03,-16.44,-15.09,-12.62,-10.81,-8.91,-7.88,-7.88,-7.97,-7.22,-6.62,-3.69,-1.59,2.19,5.66,7.66,9.19,8.56,6.62,3.84,0.31,-3.94,-7.5,-10.88,-14.09,-15.66,-16.81,-16.34,-14.88,-12.34,-10.66,-6.78,-4.47,-1.44,1.16,3.19,4.56,4.94,5.19,5.47,5.66,6.0,6.16,6.56,6.16,4.88,3.44,1.25,-0.94,-3.47,-5.53,-7.75,-8.16,-9.09,-8.44,-9.41,-9.22,-10.28,-11.62,-12.44,-11.09,-9.69,-5.69,-0.53,3.84,7.69,9.69,8.41,6.25,3.19,-0.34,-1.47,-1.66,-0.31,2.06,4.94,7.69,10.5,11.84,12.34,12.0,10.06,6.81,2.84,-1.5,-5.59,-9.22,-11.41,-12.41,-12.34,-11.06,-9.62,-7.47,-4.91,-3.59,-1.25,-0.28,-0.72,-1.34,-2.72,-4.03,-4.09,-3.59,-1.44,1.12,4.38,8.06,10.38,11.72,12.5,11.66,9.47,6.75,3.91,1.38,-0.47,-0.91,-0.69,0.72,1.53,1.88,2.34,2.62,2.69,2.75,2.62,2.62,2.81,2.41,3.72,4.75,6.66,8.25,8.94,9.41,10.28,9.97,10.16,9.56,8.5,6.97,4.5,1.94,-0.5,-2.53,-4.22,-4.41,-4.34,-3.97,-3.03,-2.84,-2.34,-2.28,-1.97,0.56,2.62,6.59,9.44,11.53,12.81,13.41,12.88,13.06,12.88,13.25,13.03,13.44,13.5,13.06,12.41,11.25,9.25,7.5,5.66,4.06,2.31,1.0,0.66,0.09,0.62,2.59,3.88,6.41,7.88,9.09,9.19,8.59,6.41,4.44,2.25,1.91,1.28,2.69,5.25,7.41,9.94,12.19,12.44,11.5,9.69,7.19,4.44,2.31,2.25,3.88,6.44,9.94,13.25,15.47,16.88,16.94,16.19,14.34,13.16,11.38,10.78,10.66,11.41,13.5,15.31,17.0,19.56,20.28,21.06,21.25,21.5,21.91,22.03,22.94,22.97,22.41,21.41,19.53,17.44,15.62,13.75,11.56,10.28,9.06,7.5,6.97,6.69,7.31,7.72,8.72,9.19,9.12,8.53,8.31,7.56,7.78,8.81,9.81,11.75,14.31,15.28,16.19,15.72,14.56,12.84,10.41,8.5,7.34,6.81,6.66,7.91,8.66,9.06,9.62,8.75,7.81,6.91,5.69,3.56,2.91,2.72,3.31,4.75,7.84,10.78,14.53,16.16,18.28,19.16,18.28,17.31,15.41,14.0,12.69,11.66,11.38,10.44,10.16,8.69,5.94,3.88,0.97,-0.97,-1.12,-0.31,1.94,5.41,8.69,12.53,16.34,20.09,23.5,25.62,25.91,24.91,22.22,18.75,17.19,14.94,13.53,13.31,12.34,11.03,9.44,7.22,5.41,3.94,3.03,3.06,3.28,3.75,3.72,4.62:-8.19,-7.16,-5.5,-2.62,-0.28,1.28,3.25,5.22,5.88,6.34,5.53,4.81,3.25,1.72,0.78,0.28,0.56,2.34,3.44,5.59,8.41,9.19,10.38,10.66,9.91,8.12,7.0,5.56,4.28,2.28,1.66,0.56,-0.28,0.03,0.31,1.34,2.59,2.88,3.66,4.81,5.5,6.53,8.47,9.97,9.81,8.78,7.06,4.44,2.91,-1.06,-3.28,-6.31,-9.84,-13.06,-15.62,-18.31,-20.16,-21.78,-21.41,-22.03,-21.84,-20.91,-21.44,-19.34,-19.47,-18.22,-18.03,-18.78,-19.94,-20.97,-22.47,-21.53,-22.31,-21.78,-20.94,-20.59,-20.16,-18.81,-17.34,-16.03,-13.62,-11.94,-10.53,-8.47,-8.09,-7.09,-6.91,-5.75,-5.34,-4.38,-3.66,-2.97,-1.81,-0.53,0.09,1.31,3.03,2.12,1.53,0.09,-2.22,-5.53,-7.66,-10.16,-11.59,-13.75,-13.88,-13.44,-12.34,-9.78,-6.41,-3.84,-0.62,-0.38,-0.28,-1.78,-3.47,-6.69,-7.72,-8.47,-8.53,-7.81,-7.06,-5.97,-5.5,-5.16,-5.16,-5.09,-4.91,-4.53,-4.47,-4.19,-4.47,-4.81,-6.22,-7.78,-8.78,-9.34,-9.06,-8.94,-7.22,-5.97,-4.62,-2.97,-0.59,0.53,2.31,4.09,4.78,6.34,6.44,5.88,4.78,3.53,1.59,0.16,-0.69,-2.06,-3.97,-5.28,-6.97,-7.53,-8.09,-7.34,-5.41,-2.84,-0.59,1.56,2.94,1.53,0.06,-2.88,-5.81,-8.97,-11.47,-12.97,-13.03,-10.03,-7.31,-1.81,1.69,5.09,7.66,7.53,7.38,6.28,4.28,2.72,-0.19,-2.47,-4.34,-6.38,-7.09,-8.47,-10.09,-10.84,-12.06,-13.12,-13.84,-13.97,-12.34,-10.97,-8.34,-5.34,-2.25,-1.91,-0.69,-1.84,-3.28,-6.25,-8.53,-9.84,-10.59,-11.84,-11.44,-11.84,-11.75,-13.31,-13.94,-15.59,-16.81,-17.84,-19.31,-20.0,-19.06,-18.44,-17.53,-16.25,-15.84,-17.09,-18.34,-20.97,-22.12,-22.72,-23.16,-21.88,-21.0,-19.59,-18.81,-18.31,-18.81,-19.94,-20.81,-22.0,-22.81,-21.88,-21.41,-20.97,-18.97,-18.69,-17.44,-16.91,-16.22,-15.81,-15.66,-15.41,-15.59,-15.41,-15.5,-16.09,-16.34,-16.81,-17.09,-16.16,-15.34,-12.59,-10.75,-8.59,-7.28,-6.62,-5.97,-6.09,-7.19,-7.09,-7.59,-8.66,-9.59,-11.84,-13.16,-15.44,-16.03,-17.28,-17.44,-15.94,-14.78,-12.88,-10.31,-6.53,-4.0,-1.47,1.22,1.81,2.03,0.78,-0.97,-3.16,-5.56,-7.41,-7.47,-6.97,-5.94,-5.03,-3.66,-3.31,-3.12,-2.75,-3.16,-3.38,-4.69,-5.41,-5.94,-5.84,-5.56,-4.56,-4.09,-2.78,-3.88,-2.03,-2.75,-1.81,-1.84,-2.28,-1.97,-3.28,-4.88,-6.09,-8.84,-10.53,-12.47,-12.62,-12.53,-10.22,-7.72,-4.59,-1.5,0.69,2.41,3.0,1.78,-0.09,-2.53,-5.03,-7.19,-7.81,-7.38,-5.44,-3.5,-1.78,-0.94,-0.97,-2.09,-4.22,-6.16,-8.84,-10.84,-11.09,-10.09,-6.81,-1.59,2.5,5.84,5.94,4.16,-0.03,-4.91,-8.03,-10.56,-11.72,-12.81,-12.41,-10.69,-9.97,-9.34,-7.97,-6.78,-6.59,-5.09,-4.91,-4.75,-4.59,-6.22,-8.72,-11.5,-13.69,-16.28,-17.34,-16.53,-16.03,-14.47,-13.25,-11.94,-10.84,-10.22,-8.94,-7.69,-6.97,-5.91,-4.97,-4.97,-5.34,-6.0,-6.47,-6.84,-5.78,-3.03,-0.41,3.59,5.88,7.84,8.06,7.44,6.34,3.31,0.06,-3.12,-7.5,-8.84,-8.91,-8.66,-5.84,-3.84,-2.25,-1.22,-1.97,-3.09,-5.47,-7.03,-10.03,-11.97,-13.69,-14.66,-14.09,-12.72,-11.12,-9.66,-8.38,-8.22,-7.97,-9.78,-10.34,-12.22,-14.97,-17.16,-19.0,-20.78,-21.59,-22.09,-20.53,-20.28,-19.06,-18.72,-17.97,-17.44,-18.19,-18.19,-17.44,-16.28,-15.38,-13.91,-12.78,-12.03,-12.59,-13.38,-13.94,-14.44,-14.66,-15.91,-15.41,-15.0,-15.22,-14.59,-14.59,-15.34,-15.06,-14.84,-14.47,-13.91,-13.22,-11.97,-13.66,-12.94,-14.03,-14.09,-15.59,-16.59,-17.94,-19.69,-21.75,-23.22,-24.94,-25.88,-27.88,-29.25,-30.12,-30.84,-31.03,-31.22,-29.56,-28.41,-27.34,-25.84,-23.81,-22.44,-21.03,-20.06,-19.72,-20.16,-19.94,-20.47,-21.47,-21.72,-22.16,-22.97,-22.56,-20.34,-18.38,-16.41,-14.25,-13.53,-12.59,-13.44,-13.78,-13.44,-12.5,-11.66,-9.31,-7.34,-5.03,-4.09,-3.88,-4.38,-4.59,-6.06,-7.41,-7.47,-8.97,-10.84,-13.09,-15.72,-18.5,-21.09,-23.59,-23.78,-23.69,-21.44,-17.97,-13.44,-8.22,-3.09,1.03,3.31,4.81,4.25,1.41,-1.59,-4.34,-7.84,-11.09,-13.56,-16.06,-17.06,-18.41,-18.03,-16.44,-15.09,-12.62,-10.81,-8.91,-7.88,-7.88,-7.97,-7.22,-6.62,-3.69,-1.59,2.19,5.66,7.66,9.19,8.56,6.62,3.84,0.31,-3.94,-7.5,-10.88,-14.09,-15.66,-16.81,-16.34,-14.88,-12.34,-10.66,-6.78,-4.47,-1.44,1.16,3.19,4.56,4.94,5.19,5.47,5.66,6.0,6.16,6.56,6.16,4.88,3.44,1.25,-0.94,-3.47,-5.53,-7.75,-8.16,-9.09,-8.44,-9.41,-9.22,-10.28,-11.62,-12.44,-11.09,-9.69,-5.69,-0.53,3.84,7.69,9.69,8.41,6.25,3.19,-0.34,-1.47,-1.66,-0.31,2.06,4.94,7.69,10.5,11.84,12.34,12.0,10.06,6.81,2.84,-1.5,-5.59,-9.22,-11.41,-12.41,-12.34,-11.06,-9.62,-7.47,-4.91,-3.59,-1.25,-0.28,-0.72,-1.34,-2.72,-4.03,-4.09,-3.59,-1.44,1.12,4.38,8.06,10.38,11.72,12.5,11.66,9.47,6.75,3.91,1.38,-0.47,-0.91,-0.69,0.72,1.53,1.88,2.34,2.62,2.69,2.75,2.62,2.62,2.81,2.41,3.72,4.75,6.66,8.25,8.94,9.41,10.28,9.97,10.16,9.56,8.5,6.97,4.5,1.94,-0.5,-2.53,-4.22,-4.41,-4.34,-3.97,-3.03,-2.84,-2.34,-2.28,-1.97,0.56,2.62,6.59,9.44,11.53,12.81,13.41,12.88,13.06,12.88,13.25,13.03,13.44,13.5,13.06,12.41,11.25,9.25,7.5,5.66,4.06,2.31,1.0,0.66,0.09,0.62,2.59,3.88,6.41,7.88,9.09,9.19,8.59,6.41,4.44,2.25,1.91,1.28,2.69,5.25,7.41,9.94,12.19,12.44,11.5,9.69,7.19,4.44,2.31,2.25,3.88,6.44,9.94,13.25,15.47,16.88,16.94,16.19,14.34,13.16,11.38,10.78,10.66,11.41,13.5,15.31,17.0,19.56,20.28,21.06,21.25,21.5,21.91,22.03,22.94,22.97,22.41,21.41,19.53,17.44,15.62,13.75,11.56,10.28,9.06,7.5,6.97,6.69,7.31,7.72,8.72,9.19,9.12,8.53,8.31,7.56,7.78,8.81,9.81,11.75,14.31,15.28,16.19,15.72,14.56,12.84,10.41,8.5,7.34,6.81,6.66,7.91,8.66,9.06,9.62,8.75,7.81,6.91,5.69,3.56,2.91,2.72,3.31,4.75,7.84,10.78,14.53,16.16,18.28,19.16,18.28,17.31,15.41,14.0,12.69,11.66,11.38,10.44,10.16,8.69,5.94,3.88,0.97,-0.97,-1.12,-0.31,1.94,5.41,8.69,12.53,16.34,20.09,23.5,25.62,25.91,24.91,22.22,18.75,17.19,14.94,13.53,13.31,12.34,11.03,9.44,7.22,5.41,3.94,3.03,3.06,3.28,3.75,3.72,4.62,6.28,1.38,-1.94,-6.03,-8.22,-10.16:3.25,5.22,5.88,6.34,5.53,4.81,3.25,1.72,0.78,0.28,0.56,2.34,3.44,5.59,8.41,9.19,10.38,10.66,9.91,8.12,7.0,5.56,4.28,2.28,1.66,0.56,-0.28,0.03,0.31,1.34,2.59,2.88,3.66,4.81,5.5,6.53,8.47,9.97,9.81,8.78,7.06,4.44,2.91,-1.06,-3.28,-6.31,-9.84,-13.06,-15.62,-18.31,-20.16,-21.78,-21.41,-22.03,-21.84,-20.91,-21.44,-19.34,-19.47,-18.22,-18.03,-18.78,-19.94,-20.97,-22.47,-21.53,-22.31,-21.78,-20.94,-20.59,-20.16,-18.81,-17.34,-16.03,-13.62,-11.94,-10.53,-8.47,-8.09,-7.09,-6.91,-5.75,-5.34,-4.38,-3.66,-2.97,-1.81,-0.53,0.09,1.31,3.03,2.12,1.53,0.09,-2.22,-5.53,-7.66,-10.16,-11.59,-13.75,-13.88,-13.44,-12.34,-9.78,-6.41,-3.84,-0.62,-0.38,-0.28,-1.78,-3.47,-6.69,-7.72,-8.47,-8.53,-7.81,-7.06,-5.97,-5.5,-5.16,-5.16,-5.09,-4.91,-4.53,-4.47,-4.19,-4.47,-4.81,-6.22,-7.78,-8.78,-9.34,-9.06,-8.94,-7.22,-5.97,-4.62,-2.97,-0.59,0.53,2.31,4.09,4.78,6.34,6.44,5.88,4.78,3.53,1.59,0.16,-0.69,-2.06,-3.97,-5.28,-6.97,-7.53,-8.09,-7.34,-5.41,-2.84,-0.59,1.56,2.94,1.53,0.06,-2.88,-5.81,-8.97,-11.47,-12.97,-13.03,-10.03,-7.31,-1.81,1.69,5.09,7.66,7.53,7.38,6.28,4.28,2.72,-0.19,-2.47,-4.34,-6.38,-7.09,-8.47,-10.09,-10.84,-12.06,-13.12,-13.84,-13.97,-12.34,-10.97,-8.34,-5.34,-2.25,-1.91,-0.69,-1.84,-3.28,-6.25,-8.53,-9.84,-10.59,-11.84,-11.44,-11.84,-11.75,-13.31,-13.94,-15.59,-16.81,-17.84,-19.31,-20.0,-19.06,-18.44,-17.53,-16.25,-15.84,-17.09,-18.34,-20.97,-22.12,-22.72,-23.16,-21.88,-21.0,-19.59,-18.81,-18.31,-18.81,-19.94,-20.81,-22.0,-22.81,-21.88,-21.41,-20.97,-18.97,-18.69,-17.44,-16.91,-16.22,-15.81,-15.66,-15.41,-15.59,-15.41,-15.5,-16.09,-16.34,-16.81,-17.09,-16.16,-15.34,-12.59,-10.75,-8.59,-7.28,-6.62,-5.97,-6.09,-7.19,-7.09,-7.59,-8.66,-9.59,-11.84,-13.16,-15.44,-16.03,-17.28,-17.44,-15.94,-14.78,-12.88,-10.31,-6.53,-4.0,-1.47,1.22,1.81,2.03,0.78,-0.97,-3.16,-5.56,-7.41,-7.47,-6.97,-5.94,-5.03,-3.66,-3.31,-3.12,-2.75,-3.16,-3.38,-4.69,-5.41,-5.94,-5.84,-5.56,-4.56,-4.09,-2.78,-3.88,-2.03,-2.75,-1.81,-1.84,-2.28,-1.97,-3.28,-4.88,-6.09,-8.84,-10.53,-12.47,-12.62,-12.53,-10.22,-7.72,-4.59,-1.5,0.69,2.41,3.0,1.78,-0.09,-2.53,-5.03,-7.19,-7.81,-7.38,-5.44,-3.5,-1.78,-0.94,-0.97,-2.09,-4.22,-6.16,-8.84,-10.84,-11.09,-10.09,-6.81,-1.59,2.5,5.84,5.94,4.16,-0.03,-4.91,-8.03,-10.56,-11.72,-12.81,-12.41,-10.69,-9.97,-9.34,-7.97,-6.78,-6.59,-5.09,-4.91,-4.75,-4.59,-6.22,-8.72,-11.5,-13.69,-16.28,-17.34,-16.53,-16.03,-14.47,-13.25,-11.94,-10.84,-10.22,-8.94,-7.69,-6.97,-5.91,-4.97,-4.97,-5.34,-6.0,-6.47,-6.84,-5.78,-3.03,-0.41,3.59,5.88,7.84,8.06,7.44,6.34,3.31,0.06,-3.12,-7.5,-8.84,-8.91,-8.66,-5.84,-3.84,-2.25,-1.22,-1.97,-3.09,-5.47,-7.03,-10.03,-11.97,-13.69,-14.66,-14.09,-12.72,-11.12,-9.66,-8.38,-8.22,-7.97,-9.78,-10.34,-12.22,-14.97,-17.16,-19.0,-20.78,-21.59,-22.09,-20.53,-20.28,-19.06,-18.72,-17.97,-17.44,-18.19,-18.19,-17.44,-16.28,-15.38,-13.91,-12.78,-12.03,-12.59,-13.38,-13.94,-14.44,-14.66,-15.91,-15.41,-15.0,-15.22,-14.59,-14.59,-15.34,-15.06,-14.84,-14.47,-13.91,-13.22,-11.97,-13.66,-12.94,-14.03,-14.09,-15.59,-16.59,-17.94,-19.69,-21.75,-23.22,-24.94,-25.88,-27.88,-29.25,-30.12,-30.84,-31.03,-31.22,-29.56,-28.41,-27.34,-25.84,-23.81,-22.44,-21.03,-20.06,-19.72,-20.16,-19.94,-20.47,-21.47,-21.72,-22.16,-22.97,-22.56,-20.34,-18.38,-16.41,-14.25,-13.53,-12.59,-13.44,-13.78,-13.44,-12.5,-11.66,-9.31,-7.34,-5.03,-4.09,-3.88,-4.38,-4.59,-6.06,-7.41,-7.47,-8.97,-10.84,-13.09,-15.72,-18.5,-21.09,-23.59,-23.78,-23.69,-21.44,-17.97,-13.44,-8.22,-3.09,1.03,3.31,4.81,4.25,1.41,-1.59,-4.34,-7.84,-11.09,-13.56,-16.06,-17.06,-18.41,-18.03,-16.44,-15.09,-12.62,-10.81,-8.91,-7.88,-7.88,-7.97,-7.22,-6.62,-3.69,-1.59,2.19,5.66,7.66,9.19,8.56,6.62,3.84,0.31,-3.94,-7.5,-10.88,-14.09,-15.66,-16.81,-16.34,-14.88,-12.34,-10.66,-6.78,-4.47,-1.44,1.16,3.19,4.56,4.94,5.19,5.47,5.66,6.0,6.16,6.56,6.16,4.88,3.44,1.25,-0.94,-3.47,-5.53,-7.75,-8.16,-9.09,-8.44,-9.41,-9.22,-10.28,-11.62,-12.44,-11.09,-9.69,-5.69,-0.53,3.84,7.69,9.69,8.41,6.25,3.19,-0.34,-1.47,-1.66,-0.31,2.06,4.94,7.69,10.5,11.84,12.34,12.0,10.06,6.81,2.84,-1.5,-5.59,-9.22,-11.41,-12.41,-12.34,-11.06,-9.62,-7.47,-4.91,-3.59,-1.25,-0.28,-0.72,-1.34,-2.72,-4.03,-4.09,-3.59,-1.44,1.12,4.38,8.06,10.38,11.72,12.5,11.66,9.47,6.75,3.91,1.38,-0.47,-0.91,-0.69,0.72,1.53,1.88,2.34,2.62,2.69,2.75,2.62,2.62,2.81,2.41,3.72,4.75,6.66,8.25,8.94,9.41,10.28,9.97,10.16,9.56,8.5,6.97,4.5,1.94,-0.5,-2.53,-4.22,-4.41,-4.34,-3.97,-3.03,-2.84,-2.34,-2.28,-1.97,0.56,2.62,6.59,9.44,11.53,12.81,13.41,12.88,13.06,12.88,13.25,13.03,13.44,13.5,13.06,12.41,11.25,9.25,7.5,5.66,4.06,2.31,1.0,0.66,0.09,0.62,2.59,3.88,6.41,7.88,9.09,9.19,8.59,6.41,4.44,2.25,1.91,1.28,2.69,5.25,7.41,9.94,12.19,12.44,11.5,9.69,7.19,4.44,2.31,2.25,3.88,6.44,9.94,13.25,15.47,16.88,16.94,16.19,14.34,13.16,11.38,10.78,10.66,11.41,13.5,15.31,17.0,19.56,20.28,21.06,21.25,21.5,21.91,22.03,22.94,22.97,22.41,21.41,19.53,17.44,15.62,13.75,11.56,10.28,9.06,7.5,6.97,6.69,7.31,7.72,8.72,9.19,9.12,8.53,8.31,7.56,7.78,8.81,9.81,11.75,14.31,15.28,16.19,15.72,14.56,12.84,10.41,8.5,7.34,6.81,6.66,7.91,8.66,9.06,9.62,8.75,7.81,6.91,5.69,3.56,2.91,2.72,3.31,4.75,7.84,10.78,14.53,16.16,18.28,19.16,18.28,17.31,15.41,14.0,12.69,11.66,11.38,10.44,10.16,8.69,5.94,3.88,0.97,-0.97,-1.12,-0.31,1.94,5.41,8.69,12.53,16.34,20.09,23.5,25.62,25.91,24.91,22.22,18.75,17.19,14.94,13.53,13.31,12.34,11.03,9.44,7.22,5.41,3.94,3.03,3.06,3.28,3.75,3.72,4.62,6.28,1.38,-1.94,-6.03,-8.22,-10.16,-10.22,-8.19,-7.28,-4.75,-1.81,1.19:3.25,1.72,0.78,0.28,0.56,2.34,3.44,5.59,8.41,9.19,10.38,10.66,9.91,8.12,7.0,5.56,4.28,2.28,1.66,0.56,-0.28,0.03,0.31,1.34,2.59,2.88,3.66,4.81,5.5,6.53,8.47,9.97,9.81,8.78,7.06,4.44,2.91,-1.06,-3.28,-6.31,-9.84,-13.06,-15.62,-18.31,-20.16,-21.78,-21.41,-22.03,-21.84,-20.91,-21.44,-19.34,-19.47,-18.22,-18.03,-18.78,-19.94,-20.97,-22.47,-21.53,-22.31,-21.78,-20.94,-20.59,-20.16,-18.81,-17.34,-16.03,-13.62,-11.94,-10.53,-8.47,-8.09,-7.09,-6.91,-5.75,-5.34,-4.38,-3.66,-2.97,-1.81,-0.53,0.09,1.31,3.03,2.12,1.53,0.09,-2.22,-5.53,-7.66,-10.16,-11.59,-13.75,-13.88,-13.44,-12.34,-9.78,-6.41,-3.84,-0.62,-0.38,-0.28,-1.78,-3.47,-6.69,-7.72,-8.47,-8.53,-7.81,-7.06,-5.97,-5.5,-5.16,-5.16,-5.09,-4.91,-4.53,-4.47,-4.19,-4.47,-4.81,-6.22,-7.78,-8.78,-9.34,-9.06,-8.94,-7.22,-5.97,-4.62,-2.97,-0.59,0.53,2.31,4.09,4.78,6.34,6.44,5.88,4.78,3.53,1.59,0.16,-0.69,-2.06,-3.97,-5.28,-6.97,-7.53,-8.09,-7.34,-5.41,-2.84,-0.59,1.56,2.94,1.53,0.06,-2.88,-5.81,-8.97,-11.47,-12.97,-13.03,-10.03,-7.31,-1.81,1.69,5.09,7.66,7.53,7.38,6.28,4.28,2.72,-0.19,-2.47,-4.34,-6.38,-7.09,-8.47,-10.09,-10.84,-12.06,-13.12,-13.84,-13.97,-12.34,-10.97,-8.34,-5.34,-2.25,-1.91,-0.69,-1.84,-3.28,-6.25,-8.53,-9.84,-10.59,-11.84,-11.44,-11.84,-11.75,-13.31,-13.94,-15.59,-16.81,-17.84,-19.31,-20.0,-19.06,-18.44,-17.53,-16.25,-15.84,-17.09,-18.34,-20.97,-22.12,-22.72,-23.16,-21.88,-21.0,-19.59,-18.81,-18.31,-18.81,-19.94,-20.81,-22.0,-22.81,-21.88,-21.41,-20.97,-18.97,-18.69,-17.44,-16.91,-16.22,-15.81,-15.66,-15.41,-15.59,-15.41,-15.5,-16.09,-16.34,-16.81,-17.09,-16.16,-15.34,-12.59,-10.75,-8.59,-7.28,-6.62,-5.97,-6.09,-7.19,-7.09,-7.59,-8.66,-9.59,-11.84,-13.16,-15.44,-16.03,-17.28,-17.44,-15.94,-14.78,-12.88,-10.31,-6.53,-4.0,-1.47,1.22,1.81,2.03,0.78,-0.97,-3.16,-5.56,-7.41,-7.47,-6.97,-5.94,-5.03,-3.66,-3.31,-3.12,-2.75,-3.16,-3.38,-4.69,-5.41,-5.94,-5.84,-5.56,-4.56,-4.09,-2.78,-3.88,-2.03,-2.75,-1.81,-1.84,-2.28,-1.97,-3.28,-4.88,-6.09,-8.84,-10.53,-12.47,-12.62,-12.53,-10.22,-7.72,-4.59,-1.5,0.69,2.41,3.0,1.78,-0.09,-2.53,-5.03,-7.19,-7.81,-7.38,-5.44,-3.5,-1.78,-0.94,-0.97,-2.09,-4.22,-6.16,-8.84,-10.84,-11.09,-10.09,-6.81,-1.59,2.5,5.84,5.94,4.16,-0.03,-4.91,-8.03,-10.56,-11.72,-12.81,-12.41,-10.69,-9.97,-9.34,-7.97,-6.78,-6.59,-5.09,-4.91,-4.75,-4.59,-6.22,-8.72,-11.5,-13.69,-16.28,-17.34,-16.53,-16.03,-14.47,-13.25,-11.94,-10.84,-10.22,-8.94,-7.69,-6.97,-5.91,-4.97,-4.97,-5.34,-6.0,-6.47,-6.84,-5.78,-3.03,-0.41,3.59,5.88,7.84,8.06,7.44,6.34,3.31,0.06,-3.12,-7.5,-8.84,-8.91,-8.66,-5.84,-3.84,-2.25,-1.22,-1.97,-3.09,-5.47,-7.03,-10.03,-11.97,-13.69,-14.66,-14.09,-12.72,-11.12,-9.66,-8.38,-8.22,-7.97,-9.78,-10.34,-12.22,-14.97,-17.16,-19.0,-20.78,-21.59,-22.09,-20.53,-20.28,-19.06,-18.72,-17.97,-17.44,-18.19,-18.19,-17.44,-16.28,-15.38,-13.91,-12.78,-12.03,-12.59,-13.38,-13.94,-14.44,-14.66,-15.91,-15.41,-15.0,-15.22,-14.59,-14.59,-15.34,-15.06,-14.84,-14.47,-13.91,-13.22,-11.97,-13.66,-12.94,-14.03,-14.09,-15.59,-16.59,-17.94,-19.69,-21.75,-23.22,-24.94,-25.88,-27.88,-29.25,-30.12,-30.84,-31.03,-31.22,-29.56,-28.41,-27.34,-25.84,-23.81,-22.44,-21.03,-20.06,-19.72,-20.16,-19.94,-20.47,-21.47,-21.72,-22.16,-22.97,-22.56,-20.34,-18.38,-16.41,-14.25,-13.53,-12.59,-13.44,-13.78,-13.44,-12.5,-11.66,-9.31,-7.34,-5.03,-4.09,-3.88,-4.38,-4.59,-6.06,-7.41,-7.47,-8.97,-10.84,-13.09,-15.72,-18.5,-21.09,-23.59,-23.78,-23.69,-21.44,-17.97,-13.44,-8.22,-3.09,1.03,3.31,4.81,4.25,1.41,-1.59,-4.34,-7.84,-11.09,-13.56,-16.06,-17.06,-18.41,-18.03,-16.44,-15.09,-12.62,-10.81,-8.91,-7.88,-7.88,-7.97,-7.22,-6.62,-3.69,-1.59,2.19,5.66,7.66,9.19,8.56,6.62,3.84,0.31,-3.94,-7.5,-10.88,-14.09,-15.66,-16.81,-16.34,-14.88,-12.34,-10.66,-6.78,-4.47,-1.44,1.16,3.19,4.56,4.94,5.19,5.47,5.66,6.0,6.16,6.56,6.16,4.88,3.44,1.25,-0.94,-3.47,-5.53,-7.75,-8.16,-9.09,-8.44,-9.41,-9.22,-10.28,-11.62,-12.44,-11.09,-9.69,-5.69,-0.53,3.84,7.69,9.69,8.41,6.25,3.19,-0.34,-1.47,-1.66,-0.31,2.06,4.94,7.69,10.5,11.84,12.34,12.0,10.06,6.81,2.84,-1.5,-5.59,-9.22,-11.41,-12.41,-12.34,-11.06,-9.62,-7.47,-4.91,-3.59,-1.25,-0.28,-0.72,-1.34,-2.72,-4.03,-4.09,-3.59,-1.44,1.12,4.38,8.06,10.38,11.72,12.5,11.66,9.47,6.75,3.91,1.38,-0.47,-0.91,-0.69,0.72,1.53,1.88,2.34,2.62,2.69,2.75,2.62,2.62,2.81,2.41,3.72,4.75,6.66,8.25,8.94,9.41,10.28,9.97,10.16,9.56,8.5,6.97,4.5,1.94,-0.5,-2.53,-4.22,-4.41,-4.34,-3.97,-3.03,-2.84,-2.34,-2.28,-1.97,0.56,2.62,6.59,9.44,11.53,12.81,13.41,12.88,13.06,12.88,13.25,13.03,13.44,13.5,13.06,12.41,11.25,9.25,7.5,5.66,4.06,2.31,1.0,0.66,0.09,0.62,2.59,3.88,6.41,7.88,9.09,9.19,8.59,6.41,4.44,2.25,1.91,1.28,2.69,5.25,7.41,9.94,12.19,12.44,11.5,9.69,7.19,4.44,2.31,2.25,3.88,6.44,9.94,13.25,15.47,16.88,16.94,16.19,14.34,13.16,11.38,10.78,10.66,11.41,13.5,15.31,17.0,19.56,20.28,21.06,21.25,21.5,21.91,22.03,22.94,22.97,22.41,21.41,19.53,17.44,15.62,13.75,11.56,10.28,9.06,7.5,6.97,6.69,7.31,7.72,8.72,9.19,9.12,8.53,8.31,7.56,7.78,8.81,9.81,11.75,14.31,15.28,16.19,15.72,14.56,12.84,10.41,8.5,7.34,6.81,6.66,7.91,8.66,9.06,9.62,8.75,7.81,6.91,5.69,3.56,2.91,2.72,3.31,4.75,7.84,10.78,14.53,16.16,18.28,19.16,18.28,17.31,15.41,14.0,12.69,11.66,11.38,10.44,10.16,8.69,5.94,3.88,0.97,-0.97,-1.12,-0.31,1.94,5.41,8.69,12.53,16.34,20.09,23.5,25.62,25.91,24.91,22.22,18.75,17.19,14.94,13.53,13.31,12.34,11.03,9.44,7.22,5.41,3.94,3.03,3.06,3.28,3.75,3.72,4.62,6.28,1.38,-1.94,-6.03,-8.22,-10.16,-10.22,-8.19,-7.28,-4.75,-1.81,1.19,3.31,5.97,6.12,7.12,6.34,4.97:3.44,5.59,8.41,9.19,10.38,10.66,9.91,8.12,7.0,5.56,4.28,2.28,1.66,0.56,-0.28,0.03,0.31,1.34,2.59,2.88,3.66,4.81,5.5,6.53,8.47,9.97,9.81,8.78,7.06,4.44,2.91,-1.06,-3.28,-6.31,-9.84,-13.06,-15.62,-18.31,-20.16,-21.78,-21.41,-22.03,-21.84,-20.91,-21.44,-19.34,-19.47,-18.22,-18.03,-18.78,-19.94,-20.97,-22.47,-21.53,-22.31,-21.78,-20.94,-20.59,-20.16,-18.81,-17.34,-16.03,-13.62,-11.94,-10.53,-8.47,-8.09,-7.09,-6.91,-5.75,-5.34,-4.38,-3.66,-2.97,-1.81,-0.53,0.09,1.31,3.03,2.12,1.53,0.09,-2.22,-5.53,-7.66,-10.16,-11.59,-13.75,-13.88,-13.44,-12.34,-9.78,-6.41,-3.84,-0.62,-0.38,-0.28,-1.78,-3.47,-6.69,-7.72,-8.47,-8.53,-7.81,-7.06,-5.97,-5.5,-5.16,-5.16,-5.09,-4.91,-4.53,-4.47,-4.19,-4.47,-4.81,-6.22,-7.78,-8.78,-9.34,-9.06,-8.94,-7.22,-5.97,-4.62,-2.97,-0.59,0.53,2.31,4.09,4.78,6.34,6.44,5.88,4.78,3.53,1.59,0.16,-0.69,-2.06,-3.97,-5.28,-6.97,-7.53,-8.09,-7.34,-5.41,-2.84,-0.59,1.56,2.94,1.53,0.06,-2.88,-5.81,-8.97,-11.47,-12.97,-13.03,-10.03,-7.31,-1.81,1.69,5.09,7.66,7.53,7.38,6.28,4.28,2.72,-0.19,-2.47,-4.34,-6.38,-7.09,-8.47,-10.09,-10.84,-12.06,-13.12,-13.84,-13.97,-12.34,-10.97,-8.34,-5.34,-2.25,-1.91,-0.69,-1.84,-3.28,-6.25,-8.53,-9.84,-10.59,-11.84,-11.44,-11.84,-11.75,-13.31,-13.94,-15.59,-16.81,-17.84,-19.31,-20.0,-19.06,-18.44,-17.53,-16.25,-15.84,-17.09,-18.34,-20.97,-22.12,-22.72,-23.16,-21.88,-21.0,-19.59,-18.81,-18.31,-18.81,-19.94,-20.81,-22.0,-22.81,-21.88,-21.41,-20.97,-18.97,-18.69,-17.44,-16.91,-16.22,-15.81,-15.66,-15.41,-15.59,-15.41,-15.5,-16.09,-16.34,-16.81,-17.09,-16.16,-15.34,-12.59,-10.75,-8.59,-7.28,-6.62,-5.97,-6.09,-7.19,-7.09,-7.59,-8.66,-9.59,-11.84,-13.16,-15.44,-16.03,-17.28,-17.44,-15.94,-14.78,-12.88,-10.31,-6.53,-4.0,-1.47,1.22,1.81,2.03,0.78,-0.97,-3.16,-5.56,-7.41,-7.47,-6.97,-5.94,-5.03,-3.66,-3.31,-3.12,-2.75,-3.16,-3.38,-4.69,-5.41,-5.94,-5.84,-5.56,-4.56,-4.09,-2.78,-3.88,-2.03,-2.75,-1.81,-1.84,-2.28,-1.97,-3.28,-4.88,-6.09,-8.84,-10.53,-12.47,-12.62,-12.53,-10.22,-7.72,-4.59,-1.5,0.69,2.41,3.0,1.78,-0.09,-2.53,-5.03,-7.19,-7.81,-7.38,-5.44,-3.5,-1.78,-0.94,-0.97,-2.09,-4.22,-6.16,-8.84,-10.84,-11.09,-10.09,-6.81,-1.59,2.5,5.84,5.94,4.16,-0.03,-4.91,-8.03,-10.56,-11.72,-12.81,-12.41,-10.69,-9.97,-9.34,-7.97,-6.78,-6.59,-5.09,-4.91,-4.75,-4.59,-6.22,-8.72,-11.5,-13.69,-16.28,-17.34,-16.53,-16.03,-14.47,-13.25,-11.94,-10.84,-10.22,-8.94,-7.69,-6.97,-5.91,-4.97,-4.97,-5.34,-6.0,-6.47,-6.84,-5.78,-3.03,-0.41,3.59,5.88,7.84,8.06,7.44,6.34,3.31,0.06,-3.12,-7.5,-8.84,-8.91,-8.66,-5.84,-3.84,-2.25,-1.22,-1.97,-3.09,-5.47,-7.03,-10.03,-11.97,-13.69,-14.66,-14.09,-12.72,-11.12,-9.66,-8.38,-8.22,-7.97,-9.78,-10.34,-12.22,-14.97,-17.16,-19.0,-20.78,-21.59,-22.09,-20.53,-20.28,-19.06,-18.72,-17.97,-17.44,-18.19,-18.19,-17.44,-16.28,-15.38,-13.91,-12.78,-12.03,-12.59,-13.38,-13.94,-14.44,-14.66,-15.91,-15.41,-15.0,-15.22,-14.59,-14.59,-15.34,-15.06,-14.84,-14.47,-13.91,-13.22,-11.97,-13.66,-12.94,-14.03,-14.09,-15.59,-16.59,-17.94,-19.69,-21.75,-23.22,-24.94,-25.88,-27.88,-29.25,-30.12,-30.84,-31.03,-31.22,-29.56,-28.41,-27.34,-25.84,-23.81,-22.44,-21.03,-20.06,-19.72,-20.16,-19.94,-20.47,-21.47,-21.72,-22.16,-22.97,-22.56,-20.34,-18.38,-16.41,-14.25,-13.53,-12.59,-13.44,-13.78,-13.44,-12.5,-11.66,-9.31,-7.34,-5.03,-4.09,-3.88,-4.38,-4.59,-6.06,-7.41,-7.47,-8.97,-10.84,-13.09,-15.72,-18.5,-21.09,-23.59,-23.78,-23.69,-21.44,-17.97,-13.44,-8.22,-3.09,1.03,3.31,4.81,4.25,1.41,-1.59,-4.34,-7.84,-11.09,-13.56,-16.06,-17.06,-18.41,-18.03,-16.44,-15.09,-12.62,-10.81,-8.91,-7.88,-7.88,-7.97,-7.22,-6.62,-3.69,-1.59,2.19,5.66,7.66,9.19,8.56,6.62,3.84,0.31,-3.94,-7.5,-10.88,-14.09,-15.66,-16.81,-16.34,-14.88,-12.34,-10.66,-6.78,-4.47,-1.44,1.16,3.19,4.56,4.94,5.19,5.47,5.66,6.0,6.16,6.56,6.16,4.88,3.44,1.25,-0.94,-3.47,-5.53,-7.75,-8.16,-9.09,-8.44,-9.41,-9.22,-10.28,-11.62,-12.44,-11.09,-9.69,-5.69,-0.53,3.84,7.69,9.69,8.41,6.25,3.19,-0.34,-1.47,-1.66,-0.31,2.06,4.94,7.69,10.5,11.84,12.34,12.0,10.06,6.81,2.84,-1.5,-5.59,-9.22,-11.41,-12.41,-12.34,-11.06,-9.62,-7.47,-4.91,-3.59,-1.25,-0.28,-0.72,-1.34,-2.72,-4.03,-4.09,-3.59,-1.44,1.12,4.38,8.06,10.38,11.72,12.5,11.66,9.47,6.75,3.91,1.38,-0.47,-0.91,-0.69,0.72,1.53,1.88,2.34,2.62,2.69,2.75,2.62,2.62,2.81,2.41,3.72,4.75,6.66,8.25,8.94,9.41,10.28,9.97,10.16,9.56,8.5,6.97,4.5,1.94,-0.5,-2.53,-4.22,-4.41,-4.34,-3.97,-3.03,-2.84,-2.34,-2.28,-1.97,0.56,2.62,6.59,9.44,11.53,12.81,13.41,12.88,13.06,12.88,13.25,13.03,13.44,13.5,13.06,12.41,11.25,9.25,7.5,5.66,4.06,2.31,1.0,0.66,0.09,0.62,2.59,3.88,6.41,7.88,9.09,9.19,8.59,6.41,4.44,2.25,1.91,1.28,2.69,5.25,7.41,9.94,12.19,12.44,11.5,9.69,7.19,4.44,2.31,2.25,3.88,6.44,9.94,13.25,15.47,16.88,16.94,16.19,14.34,13.16,11.38,10.78,10.66,11.41,13.5,15.31,17.0,19.56,20.28,21.06,21.25,21.5,21.91,22.03,22.94,22.97,22.41,21.41,19.53,17.44,15.62,13.75,11.56,10.28,9.06,7.5,6.97,6.69,7.31,7.72,8.72,9.19,9.12,8.53,8.31,7.56,7.78,8.81,9.81,11.75,14.31,15.28,16.19,15.72,14.56,12.84,10.41,8.5,7.34,6.81,6.66,7.91,8.66,9.06,9.62,8.75,7.81,6.91,5.69,3.56,2.91,2.72,3.31,4.75,7.84,10.78,14.53,16.16,18.28,19.16,18.28,17.31,15.41,14.0,12.69,11.66,11.38,10.44,10.16,8.69,5.94,3.88,0.97,-0.97,-1.12,-0.31,1.94,5.41,8.69,12.53,16.34,20.09,23.5,25.62,25.91,24.91,22.22,18.75,17.19,14.94,13.53,13.31,12.34,11.03,9.44,7.22,5.41,3.94,3.03,3.06,3.28,3.75,3.72,4.62,6.28,1.38,-1.94,-6.03,-8.22,-10.16,-10.22,-8.19,-7.28,-4.75,-1.81,1.19,3.31,5.97,6.12,7.12,6.34,4.97,4.75,3.59,2.66,2.75,3.0,4.31:9.91,8.12,7.0,5.56,4.28,2.28,1.66,0.56,-0.28,0.03,0.31,1.34,2.59,2.88,3.66,4.81,5.5,6.53,8.47,9.97,9.81,8.78,7.06,4.44,2.91,-1.06,-3.28,-6.31,-9.84,-13.06,-15.62,-18.31,-20.16,-21.78,-21.41,-22.03,-21.84,-20.91,-21.44,-19.34,-19.47,-18.22,-18.03,-18.78,-19.94,-20.97,-22.47,-21.53,-22.31,-21.78,-20.94,-20.59,-20.16,-18.81,-17.34,-16.03,-13.62,-11.94,-10.53,-8.47,-8.09,-7.09,-6.91,-5.75,-5.34,-4.38,-3.66,-2.97,-1.81,-0.53,0.09,1.31,3.03,2.12,1.53,0.09,-2.22,-5.53,-7.66,-10.16,-11.59,-13.75,-13.88,-13.44,-12.34,-9.78,-6.41,-3.84,-0.62,-0.38,-0.28,-1.78,-3.47,-6.69,-7.72,-8.47,-8.53,-7.81,-7.06,-5.97,-5.5,-5.16,-5.16,-5.09,-4.91,-4.53,-4.47,-4.19,-4.47,-4.81,-6.22,-7.78,-8.78,-9.34,-9.06,-8.94,-7.22,-5.97,-4.62,-2.97,-0.59,0.53,2.31,4.09,4.78,6.34,6.44,5.88,4.78,3.53,1.59,0.16,-0.69,-2.06,-3.97,-5.28,-6.97,-7.53,-8.09,-7.34,-5.41,-2.84,-0.59,1.56,2.94,1.53,0.06,-2.88,-5.81,-8.97,-11.47,-12.97,-13.03,-10.03,-7.31,-1.81,1.69,5.09,7.66,7.53,7.38,6.28,4.28,2.72,-0.19,-2.47,-4.34,-6.38,-7.09,-8.47,-10.09,-10.84,-12.06,-13.12,-13.84,-13.97,-12.34,-10.97,-8.34,-5.34,-2.25,-1.91,-0.69,-1.84,-3.28,-6.25,-8.53,-9.84,-10.59,-11.84,-11.44,-11.84,-11.75,-13.31,-13.94,-15.59,-16.81,-17.84,-19.31,-20.0,-19.06,-18.44,-17.53,-16.25,-15.84,-17.09,-18.34,-20.97,-22.12,-22.72,-23.16,-21.88,-21.0,-19.59,-18.81,-18.31,-18.81,-19.94,-20.81,-22.0,-22.81,-21.88,-21.41,-20.97,-18.97,-18.69,-17.44,-16.91,-16.22,-15.81,-15.66,-15.41,-15.59,-15.41,-15.5,-16.09,-16.34,-16.81,-17.09,-16.16,-15.34,-12.59,-10.75,-8.59,-7.28,-6.62,-5.97,-6.09,-7.19,-7.09,-7.59,-8.66,-9.59,-11.84,-13.16,-15.44,-16.03,-17.28,-17.44,-15.94,-14.78,-12.88,-10.31,-6.53,-4.0,-1.47,1.22,1.81,2.03,0.78,-0.97,-3.16,-5.56,-7.41,-7.47,-6.97,-5.94,-5.03,-3.66,-3.31,-3.12,-2.75,-3.16,-3.38,-4.69,-5.41,-5.94,-5.84,-5.56,-4.56,-4.09,-2.78,-3.88,-2.03,-2.75,-1.81,-1.84,-2.28,-1.97,-3.28,-4.88,-6.09,-8.84,-10.53,-12.47,-12.62,-12.53,-10.22,-7.72,-4.59,-1.5,0.69,2.41,3.0,1.78,-0.09,-2.53,-5.03,-7.19,-7.81,-7.38,-5.44,-3.5,-1.78,-0.94,-0.97,-2.09,-4.22,-6.16,-8.84,-10.84,-11.09,-10.09,-6.81,-1.59,2.5,5.84,5.94,4.16,-0.03,-4.91,-8.03,-10.56,-11.72,-12.81,-12.41,-10.69,-9.97,-9.34,-7.97,-6.78,-6.59,-5.09,-4.91,-4.75,-4.59,-6.22,-8.72,-11.5,-13.69,-16.28,-17.34,-16.53,-16.03,-14.47,-13.25,-11.94,-10.84,-10.22,-8.94,-7.69,-6.97,-5.91,-4.97,-4.97,-5.34,-6.0,-6.47,-6.84,-5.78,-3.03,-0.41,3.59,5.88,7.84,8.06,7.44,6.34,3.31,0.06,-3.12,-7.5,-8.84,-8.91,-8.66,-5.84,-3.84,-2.25,-1.22,-1.97,-3.09,-5.47,-7.03,-10.03,-11.97,-13.69,-14.66,-14.09,-12.72,-11.12,-9.66,-8.38,-8.22,-7.97,-9.78,-10.34,-12.22,-14.97,-17.16,-19.0,-20.78,-21.59,-22.09,-20.53,-20.28,-19.06,-18.72,-17.97,-17.44,-18.19,-18.19,-17.44,-16.28,-15.38,-13.91,-12.78,-12.03,-12.59,-13.38,-13.94,-14.44,-14.66,-15.91,-15.41,-15.0,-15.22,-14.59,-14.59,-15.34,-15.06,-14.84,-14.47,-13.91,-13.22,-11.97,-13.66,-12.94,-14.03,-14.09,-15.59,-16.59,-17.94,-19.69,-21.75,-23.22,-24.94,-25.88,-27.88,-29.25,-30.12,-30.84,-31.03,-31.22,-29.56,-28.41,-27.34,-25.84,-23.81,-22.44,-21.03,-20.06,-19.72,-20.16,-19.94,-20.47,-21.47,-21.72,-22.16,-22.97,-22.56,-20.34,-18.38,-16.41,-14.25,-13.53,-12.59,-13.44,-13.78,-13.44,-12.5,-11.66,-9.31,-7.34,-5.03,-4.09,-3.88,-4.38,-4.59,-6.06,-7.41,-7.47,-8.97,-10.84,-13.09,-15.72,-18.5,-21.09,-23.59,-23.78,-23.69,-21.44,-17.97,-13.44,-8.22,-3.09,1.03,3.31,4.81,4.25,1.41,-1.59,-4.34,-7.84,-11.09,-13.56,-16.06,-17.06,-18.41,-18.03,-16.44,-15.09,-12.62,-10.81,-8.91,-7.88,-7.88,-7.97,-7.22,-6.62,-3.69,-1.59,2.19,5.66,7.66,9.19,8.56,6.62,3.84,0.31,-3.94,-7.5,-10.88,-14.09,-15.66,-16.81,-16.34,-14.88,-12.34,-10.66,-6.78,-4.47,-1.44,1.16,3.19,4.56,4.94,5.19,5.47,5.66,6.0,6.16,6.56,6.16,4.88,3.44,1.25,-0.94,-3.47,-5.53,-7.75,-8.16,-9.09,-8.44,-9.41,-9.22,-10.28,-11.62,-12.44,-11.09,-9.69,-5.69,-0.53,3.84,7.69,9.69,8.41,6.25,3.19,-0.34,-1.47,-1.66,-0.31,2.06,4.94,7.69,10.5,11.84,12.34,12.0,10.06,6.81,2.84,-1.5,-5.59,-9.22,-11.41,-12.41,-12.34,-11.06,-9.62,-7.47,-4.91,-3.59,-1.25,-0.28,-0.72,-1.34,-2.72,-4.03,-4.09,-3.59,-1.44,1.12,4.38,8.06,10.38,11.72,12.5,11.66,9.47,6.75,3.91,1.38,-0.47,-0.91,-0.69,0.72,1.53,1.88,2.34,2.62,2.69,2.75,2.62,2.62,2.81,2.41,3.72,4.75,6.66,8.25,8.94,9.41,10.28,9.97,10.16,9.56,8.5,6.97,4.5,1.94,-0.5,-2.53,-4.22,-4.41,-4.34,-3.97,-3.03,-2.84,-2.34,-2.28,-1.97,0.56,2.62,6.59,9.44,11.53,12.81,13.41,12.88,13.06,12.88,13.25,13.03,13.44,13.5,13.06,12.41,11.25,9.25,7.5,5.66,4.06,2.31,1.0,0.66,0.09,0.62,2.59,3.88,6.41,7.88,9.09,9.19,8.59,6.41,4.44,2.25,1.91,1.28,2.69,5.25,7.41,9.94,12.19,12.44,11.5,9.69,7.19,4.44,2.31,2.25,3.88,6.44,9.94,13.25,15.47,16.88,16.94,16.19,14.34,13.16,11.38,10.78,10.66,11.41,13.5,15.31,17.0,19.56,20.28,21.06,21.25,21.5,21.91,22.03,22.94,22.97,22.41,21.41,19.53,17.44,15.62,13.75,11.56,10.28,9.06,7.5,6.97,6.69,7.31,7.72,8.72,9.19,9.12,8.53,8.31,7.56,7.78,8.81,9.81,11.75,14.31,15.28,16.19,15.72,14.56,12.84,10.41,8.5,7.34,6.81,6.66,7.91,8.66,9.06,9.62,8.75,7.81,6.91,5.69,3.56,2.91,2.72,3.31,4.75,7.84,10.78,14.53,16.16,18.28,19.16,18.28,17.31,15.41,14.0,12.69,11.66,11.38,10.44,10.16,8.69,5.94,3.88,0.97,-0.97,-1.12,-0.31,1.94,5.41,8.69,12.53,16.34,20.09,23.5,25.62,25.91,24.91,22.22,18.75,17.19,14.94,13.53,13.31,12.34,11.03,9.44,7.22,5.41,3.94,3.03,3.06,3.28,3.75,3.72,4.62,6.28,1.38,-1.94,-6.03,-8.22,-10.16,-10.22,-8.19,-7.28,-4.75,-1.81,1.19,3.31,5.97,6.12,7.12,6.34,4.97,4.75,3.59,2.66,2.75,3.0,4.31,6.0,7.62,9.62,11.41,12.41,12.97:positivity
10.84,11.72,11.34,11.19,11.62,11.28,10.31,11.81,11.06,11.75,12.12,10.78,10.12,8.16,6.56,5.69,5.31,4.62,4.84,2.25,2.31,0.22,-1.41,-3.28,-1.31,-2.16,-1.44,-1.03,-0.53,-0.16,0.31,1.84,2.66,4.03,3.56,2.28,1.94,0.28,-0.34,-1.28,-1.78,-1.97,0.31,2.19,4.75,7.66,9.44,9.81,9.28,6.88,6.41,3.81,3.03,3.19,2.16,2.5,4.44,4.69,6.25,6.38,8.47,8.88,8.59,10.31,9.22,9.19,10.19,9.81,10.81,11.97,10.69,9.41,8.34,6.94,5.62,5.47,4.81,5.41,4.78,5.22,6.75,7.91,9.69,10.66,11.72,10.03,8.5,7.72,6.69,8.44,10.06,12.72,14.94,13.72,14.66,13.91,13.81,13.81,12.44,14.19,13.75,15.5,17.84,20.59,21.28,22.81,23.44,23.91,25.03,25.62,27.09,26.16,24.78,26.41,24.69,26.34,30.03,31.38,33.84,35.53,36.38,36.28,35.66,35.66,33.66,34.84,33.62,33.88,35.47,34.12,35.19,34.38,33.25,32.69,31.94,31.06,28.16,26.62,21.44,20.41,17.31,15.62,15.94,16.44,18.03,21.0,22.06,26.31,28.06,29.72,30.25,30.28,30.84,30.06,28.56,30.88,31.31,33.12,36.81,39.62,41.34,43.38,42.25,39.75,36.53,33.06,31.16,29.0,28.56,27.91,26.41,27.19,26.81,27.41,27.91,28.69,27.62,27.06,27.44,27.28,28.44,28.62,31.5,32.69,34.81,37.91,36.31,35.69,35.56,31.69,30.53,29.97,29.5,28.44,28.12,26.97,25.84,25.97,24.78,24.41,26.19,26.25,27.28,26.97,26.0,25.75,24.69,24.88,24.81,25.69,25.59,24.09,22.53,20.94,19.69,19.88,21.62,24.66,27.19,30.44,30.84,32.97,33.06,33.59,34.62,36.06,36.25,36.81,37.47,35.41,35.38,32.03,30.62,29.16,27.12,25.78,26.81,24.94,24.19,23.62,22.06,19.78,18.66,17.16,15.16,15.59,13.62,15.56,16.62,17.84,20.69,22.25,25.94,27.75,29.5,31.56,32.03,30.66,29.91,27.44,24.91,22.84,21.06,18.78,15.84,13.16,9.81,9.56,9.16,11.53,15.25,17.97,21.47,22.53,24.06,24.41,23.78,23.88,22.62,22.44,21.62,20.19,17.47,16.94,15.97,13.69,13.25,13.75,13.16,13.53,13.91,15.94,16.44,17.5,19.19,20.34,21.03,20.06,20.81,19.56,16.56,14.97,13.88,12.66,13.34,14.44,18.56,21.38,24.88,26.03,27.44,26.5,23.56,22.09,18.81,17.72,14.12,15.41,15.84,17.47,20.56,23.44,24.81,25.59,24.38,23.66,20.72,16.72,15.19,13.28,12.03,10.69,10.25,10.91,10.5,9.69,8.84,10.34,8.31,10.12,10.31,11.81,13.5,16.12,18.16,23.5,26.0,28.69,30.62,31.09,29.69,27.47,26.12,23.41,21.59,19.81,20.03,21.03,22.56,24.22,24.41,25.72,24.16,24.16,23.56,22.28,21.94,22.62,22.16,22.06,22.66,21.56,20.41,19.72,18.25,18.12,17.56,18.41,18.06,20.12,22.34,25.81,29.88,34.69,37.19,40.59,41.28,40.09,37.84,35.16,31.12,27.72,25.16,22.81,20.91,20.88,21.34,21.34,22.31,22.06,20.78,20.56,19.91,18.53,19.81,21.94,24.16,26.25,29.34,30.56,29.66,26.81,26.72,23.72,22.47,22.84,22.66,25.19,26.06,28.06,29.56,30.88,29.5,28.94,26.88,26.5,25.88,25.88,25.41,26.38,24.12,24.06,25.0,24.03,26.12,25.34,25.0,24.41,22.09,22.06,23.78,23.66,26.41,28.84,30.94,32.28,33.62,34.06,33.56,33.0,32.09,31.19,31.69,33.66,32.47,33.75,33.94,33.38,32.53,31.44,31.47,30.44,29.28,29.44,29.03,29.69,30.34,32.19,33.56,34.66,36.22,36.75,37.06,36.31,34.53,33.66,32.41,31.12,30.03,30.22,29.84,28.41,27.28,26.59,25.19,24.47,23.56,23.88,23.53,23.25,23.31,21.5,21.72,20.81,20.0,20.12,19.81,19.12,17.41,14.91,11.81,8.78,6.88,5.84,7.19,10.03,13.47,18.34,21.69,25.44,27.38,28.5,27.69,27.44,26.78,26.72,26.38,26.06,26.31,26.5,26.66,26.28,25.84,25.72,24.44,24.12,24.38,23.81,23.25,23.84,23.62,24.38,24.69,25.38,25.75,26.22,25.91,26.44,27.34,27.47,27.94,28.22,27.78,27.28,26.09,24.72,22.91,20.31,17.44,13.94,12.5,9.69,7.62,7.19,8.28,9.19,11.62,14.09,15.94,16.69,18.62,19.0,21.66,23.41,25.0,26.69,26.56,25.94,23.09,21.44,19.28,19.12,18.41,19.25,20.5,21.47,21.38,22.25,21.06,21.72,22.03,22.34,23.88,24.38,23.91,23.09,21.78,21.69,21.56,20.72,21.31,22.25,21.0,20.06,19.94,18.41,16.03,15.59,14.47,15.22,14.66,16.06,17.03,18.03,18.97,18.91,19.94,19.31,18.69,18.81,18.34,19.03,18.75,21.31,22.94,24.12,26.88,26.69,24.94,21.88,17.88,12.41,8.94,6.22,5.28,5.28,5.75,6.09,6.16,5.38,5.03,3.66,5.28,5.19,5.75,8.16,9.47,9.19,10.31,9.53,8.78,8.66,8.25,7.75,7.69,7.56,7.25,7.19,8.69,8.22,9.31,10.06,11.34,11.69,13.09,13.81,14.75,16.0,16.72,17.31,18.03,17.5,16.91,17.44,16.75,15.44,14.25,12.75,11.38,10.72,10.69,12.03,13.0,14.38,16.19,17.34,18.44,18.16,17.88,16.94,16.06,15.81,16.09,17.5,17.53,18.84,19.25,18.88,17.91,16.94,16.59,16.78,16.0,15.44,14.16,12.78,12.25,11.84,12.25,12.5,12.28,11.78,11.69,10.81,9.91,11.41,11.31,11.41,13.06,14.0,14.44,15.78,15.88,15.34,15.31,14.5,13.56,13.91,12.94,12.41,11.72,11.88,12.12,12.28,14.44,14.75,15.09,15.53,15.25,14.62,13.84,14.66,14.38,13.94,15.72,15.56,14.81,15.06,15.88,15.62,14.34,14.09,11.25,9.88,7.34,6.25,6.38,6.53,7.53,10.06,12.31,13.38,13.19,14.03,11.66,10.75,10.41,9.06,8.56,7.0,7.62,7.16,8.47,10.38,11.59,15.03,16.22,19.62,20.44,22.94,23.84,23.75,24.06,23.69,22.97,21.66,19.25,17.62,15.56,15.0,15.62,16.75,17.78,19.09,19.34,19.94,19.94,19.0,18.94,18.72,18.44,18.47,18.81,19.12,17.72,18.16,19.16,18.81,18.94,18.59,16.59,15.75,14.03,13.53,13.84,14.75,15.88,16.62,18.0,18.91,18.09,18.69,17.72,16.38,16.0,17.03,17.31,18.06,19.56,20.03,20.09,19.97,21.47,21.94,22.97,23.09,22.72,22.41,20.88,20.38,18.5,18.69,17.03,16.12,15.19,14.28,14.72,15.56,16.25,17.66,17.56,15.84,15.28,13.34,13.25,13.12,14.28,14.72,14.12,13.19,11.25,11.16,9.84,9.47,9.12,8.78,7.66,6.78,6.88,7.62,7.56,9.22,10.81,10.75,11.56,11.66,12.16,13.5,15.78,18.56,23.38,27.28,30.06,32.09,32.03,28.66,24.75,20.72,16.34,13.25,11.19,10.28,9.19,9.38,9.09,7.53,7.59,6.88,6.94,7.06,7.69,9.12,9.34,10.91,11.97,13.31:10.31,11.81,11.06,11.75,12.12,10.78,10.12,8.16,6.56,5.69,5.31,4.62,4.84,2.25,2.31,0.22,-1.41,-3.28,-1.31,-2.16,-1.44,-1.03,-0.53,-0.16,0.31,1.84,2.66,4.03,3.56,2.28,1.94,0.28,-0.34,-1.28,-1.78,-1.97,0.31,2.19,4.75,7.66,9.44,9.81,9.28,6.88,6.41,3.81,3.03,3.19,2.16,2.5,4.44,4.69,6.25,6.38,8.47,8.88,8.59,10.31,9.22,9.19,10.19,9.81,10.81,11.97,10.69,9.41,8.34,6.94,5.62,5.47,4.81,5.41,4.78,5.22,6.75,7.91,9.69,10.66,11.72,10.03,8.5,7.72,6.69,8.44,10.06,12.72,14.94,13.72,14.66,13.91,13.81,13.81,12.44,14.19,13.75,15.5,17.84,20.59,21.28,22.81,23.44,23.91,25.03,25.62,27.09,26.16,24.78,26.41,24.69,26.34,30.03,31.38,33.84,35.53,36.38,36.28,35.66,35.66,33.66,34.84,33.62,33.88,35.47,34.12,35.19,34.38,33.25,32.69,31.94,31.06,28.16,26.62,21.44,20.41,17.31,15.62,15.94,16.44,18.03,21.0,22.06,26.31,28.06,29.72,30.25,30.28,30.84,30.06,28.56,30.88,31.31,33.12,36.81,39.62,41.34,43.38,42.25,39.75,36.53,33.06,31.16,29.0,28.56,27.91,26.41,27.19,26.81,27.41,27.91,28.69,27.62,27.06,27.44,27.28,28.44,28.62,31.5,32.69,34.81,37.91,36.31,35.69,35.56,31.69,30.53,29.97,29.5,28.44,28.12,26.97,25.84,25.97,24.78,24.41,26.19,26.25,27.28,26.97,26.0,25.75,24.69,24.88,24.81,25.69,25.59,24.09,22.53,20.94,19.69,19.88,21.62,24.66,27.19,30.44,30.84,32.97,33.06,33.59,34.62,36.06,36.25,36.81,37.47,35.41,35.38,32.03,30.62,29.16,27.12,25.78,26.81,24.94,24.19,23.62,22.06,19.78,18.66,17.16,15.16,15.59,13.62,15.56,16.62,17.84,20.69,22.25,25.94,27.75,29.5,31.56,32.03,30.66,29.91,27.44,24.91,22.84,21.06,18.78,15.84,13.16,9.81,9.56,9.16,11.53,15.25,17.97,21.47,22.53,24.06,24.41,23.78,23.88,22.62,22.44,21.62,20.19,17.47,16.94,15.97,13.69,13.25,13.75,13.16,13.53,13.91,15.94,16.44,17.5,19.19,20.34,21.03,20.06,20.81,19.56,16.56,14.97,13.88,12.66,13.34,14.44,18.56,21.38,24.88,26.03,27.44,26.5,23.56,22.09,18.81,17.72,14.12,15.41,15.84,17.47,20.56,23.44,24.81,25.59,24.38,23.66,20.72,16.72,15.19,13.28,12.03,10.69,10.25,10.91,10.5,9.69,8.84,10.34,8.31,10.12,10.31,11.81,13.5,16.12,18.16,23.5,26.0,28.69,30.62,31.09,29.69,27.47,26.12,23.41,21.59,19.81,20.03,21.03,22.56,24.22,24.41,25.72,24.16,24.16,23.56,22.28,21.94,22.62,22.16,22.06,22.66,21.56,20.41,19.72,18.25,18.12,17.56,18.41,18.06,20.12,22.34,25.81,29.88,34.69,37.19,40.59,41.28,40.09,37.84,35.16,31.12,27.72,25.16,22.81,20.91,20.88,21.34,21.34,22.31,22.06,20.78,20.56,19.91,18.53,19.81,21.94,24.16,26.25,29.34,30.56,29.66,26.81,26.72,23.72,22.47,22.84,22.66,25.19,26.06,28.06,29.56,30.88,29.5,28.94,26.88,26.5,25.88,25.88,25.41,26.38,24.12,24.06,25.0,24.03,26.12,25.34,25.0,24.41,22.09,22.06,23.78,23.66,26.41,28.84,30.94,32.28,33.62,34.06,33.56,33.0,32.09,31.19,31.69,33.66,32.47,33.75,33.94,33.38,32.53,31.44,31.47,30.44,29.28,29.44,29.03,29.69,30.34,32.19,33.56,34.66,36.22,36.75,37.06,36.31,34.53,33.66,32.41,31.12,30.03,30.22,29.84,28.41,27.28,26.59,25.19,24.47,23.56,23.88,23.53,23.25,23.31,21.5,21.72,20.81,20.0,20.12,19.81,19.12,17.41,14.91,11.81,8.78,6.88,5.84,7.19,10.03,13.47,18.34,21.69,25.44,27.38,28.5,27.69,27.44,26.78,26.72,26.38,26.06,26.31,26.5,26.66,26.28,25.84,25.72,24.44,24.12,24.38,23.81,23.25,23.84,23.62,24.38,24.69,25.38,25.75,26.22,25.91,26.44,27.34,27.47,27.94,28.22,27.78,27.28,26.09,24.72,22.91,20.31,17.44,13.94,12.5,9.69,7.62,7.19,8.28,9.19,11.62,14.09,15.94,16.69,18.62,19.0,21.66,23.41,25.0,26.69,26.56,25.94,23.09,21.44,19.28,19.12,18.41,19.25,20.5,21.47,21.38,22.25,21.06,21.72,22.03,22.34,23.88,24.38,23.91,23.09,21.78,21.69,21.56,20.72,21.31,22.25,21.0,20.06,19.94,18.41,16.03,15.59,14.47,15.22,14.66,16.06,17.03,18.03,18.97,18.91,19.94,19.31,18.69,18.81,18.34,19.03,18.75,21.31,22.94,24.12,26.88,26.69,24.94,21.88,17.88,12.41,8.94,6.22,5.28,5.28,5.75,6.09,6.16,5.38,5.03,3.66,5.28,5.19,5.75,8.16,9.47,9.19,10.31,9.53,8.78,8.66,8.25,7.75,7.69,7.56,7.25,7.19,8.69,8.22,9.31,10.06,11.34,11.69,13.09,13.81,14.75,16.0,16.72,17.31,18.03,17.5,16.91,17.44,16.75,15.44,14.25,12.75,11.38,10.72,10.69,12.03,13.0,14.38,16.19,17.34,18.44,18.16,17.88,16.94,16.06,15.81,16.09,17.5,17.53,18.84,19.25,18.88,17.91,16.94,16.59,16.78,16.0,15.44,14.16,12.78,12.25,11.84,12.25,12.5,12.28,11.78,11.69,10.81,9.91,11.41,11.31,11.41,13.06,14.0,14.44,15.78,15.88,15.34,15.31,14.5,13.56,13.91,12.94,12.41,11.72,11.88,12.12,12.28,14.44,14.75,15.09,15.53,15.25,14.62,13.84,14.66,14.38,13.94,15.72,15.56,14.81,15.06,15.88,15.62,14.34,14.09,11.25,9.88,7.34,6.25,6.38,6.53,7.53,10.06,12.31,13.38,13.19,14.03,11.66,10.75,10.41,9.06,8.56,7.0,7.62,7.16,8.47,10.38,11.59,15.03,16.22,19.62,20.44,22.94,23.84,23.75,24.06,23.69,22.97,21.66,19.25,17.62,15.56,15.0,15.62,16.75,17.78,19.09,19.34,19.94,19.94,19.0,18.94,18.72,18.44,18.47,18.81,19.12,17.72,18.16,19.16,18.81,18.94,18.59,16.59,15.75,14.03,13.53,13.84,14.75,15.88,16.62,18.0,18.91,18.09,18.69,17.72,16.38,16.0,17.03,17.31,18.06,19.56,20.03,20.09,19.97,21.47,21.94,22.97,23.09,22.72,22.41,20.88,20.38,18.5,18.69,17.03,16.12,15.19,14.28,14.72,15.56,16.25,17.66,17.56,15.84,15.28,13.34,13.25,13.12,14.28,14.72,14.12,13.19,11.25,11.16,9.84,9.47,9.12,8.78,7.66,6.78,6.88,7.62,7.56,9.22,10.81,10.75,11.56,11.66,12.16,13.5,15.78,18.56,23.38,27.28,30.06,32.09,32.03,28.66,24.75,20.72,16.34,13.25,11.19,10.28,9.19,9.38,9.09,7.53,7.59,6.88,6.94,7.06,7.69,9.12,9.34,10.91,11.97,13.31,-0.94,-0.03,0.69,0.16,1.16,1.44:10.12,8.16,6.56,5.69,5.31,4.62,4.84,2.25,2.31,0.22,-1.41,-3.28,-1.31,-2.16,-1.44,-1.03,-0.53,-0.16,0.31,1.84,2.66,4.03,3.56,2.28,1.94,0.28,-0.34,-1.28,-1.78,-1.97,0.31,2.19,4.75,7.66,9.44,9.81,9.28,6.88,6.41,3.81,3.03,3.19,2.16,2.5,4.44,4.69,6.25,6.38,8.47,8.88,8.59,10.31,9.22,9.19,10.19,9.81,10.81,11.97,10.69,9.41,8.34,6.94,5.62,5.47,4.81,5.41,4.78,5.22,6.75,7.91,9.69,10.66,11.72,10.03,8.5,7.72,6.69,8.44,10.06,12.72,14.94,13.72,14.66,13.91,13.81,13.81,12.44,14.19,13.75,15.5,17.84,20.59,21.28,22.81,23.44,23.91,25.03,25.62,27.09,26.16,24.78,26.41,24.69,26.34,30.03,31.38,33.84,35.53,36.38,36.28,35.66,35.66,33.66,34.84,33.62,33.88,35.47,34.12,35.19,34.38,33.25,32.69,31.94,31.06,28.16,26.62,21.44,20.41,17.31,15.62,15.94,16.44,18.03,21.0,22.06,26.31,28.06,29.72,30.25,30.28,30.84,30.06,28.56,30.88,31.31,33.12,36.81,39.62,41.34,43.38,42.25,39.75,36.53,33.06,31.16,29.0,28.56,27.91,26.41,27.19,26.81,27.41,27.91,28.69,27.62,27.06,27.44,27.28,28.44,28.62,31.5,32.69,34.81,37.91,36.31,35.69,35.56,31.69,30.53,29.97,29.5,28.44,28.12,26.97,25.84,25.97,24.78,24.41,26.19,26.25,27.28,26.97,26.0,25.75,24.69,24.88,24.81,25.69,25.59,24.09,22.53,20.94,19.69,19.88,21.62,24.66,27.19,30.44,30.84,32.97,33.06,33.59,34.62,36.06,36.25,36.81,37.47,35.41,35.38,32.03,30.62,29.16,27.12,25.78,26.81,24.94,24.19,23.62,22.06,19.78,18.66,17.16,15.16,15.59,13.62,15.56,16.62,17.84,20.69,22.25,25.94,27.75,29.5,31.56,32.03,30.66,29.91,27.44,24.91,22.84,21.06,18.78,15.84,13.16,9.81,9.56,9.16,11.53,15.25,17.97,21.47,22.53,24.06,24.41,23.78,23.88,22.62,22.44,21.62,20.19,17.47,16.94,15.97,13.69,13.25,13.75,13.16,13.53,13.91,15.94,16.44,17.5,19.19,20.34,21.03,20.06,20.81,19.56,16.56,14.97,13.88,12.66,13.34,14.44,18.56,21.38,24.88,26.03,27.44,26.5,23.56,22.09,18.81,17.72,14.12,15.41,15.84,17.47,20.56,23.44,24.81,25.59,24.38,23.66,20.72,16.72,15.19,13.28,12.03,10.69,10.25,10.91,10.5,9.69,8.84,10.34,8.31,10.12,10.31,11.81,13.5,16.12,18.16,23.5,26.0,28.69,30.62,31.09,29.69,27.47,26.12,23.41,21.59,19.81,20.03,21.03,22.56,24.22,24.41,25.72,24.16,24.16,23.56,22.28,21.94,22.62,22.16,22.06,22.66,21.56,20.41,19.72,18.25,18.12,17.56,18.41,18.06,20.12,22.34,25.81,29.88,34.69,37.19,40.59,41.28,40.09,37.84,35.16,31.12,27.72,25.16,22.81,20.91,20.88,21.34,21.34,22.31,22.06,20.78,20.56,19.91,18.53,19.81,21.94,24.16,26.25,29.34,30.56,29.66,26.81,26.72,23.72,22.47,22.84,22.66,25.19,26.06,28.06,29.56,30.88,29.5,28.94,26.88,26.5,25.88,25.88,25.41,26.38,24.12,24.06,25.0,24.03,26.12,25.34,25.0,24.41,22.09,22.06,23.78,23.66,26.41,28.84,30.94,32.28,33.62,34.06,33.56,33.0,32.09,31.19,31.69,33.66,32.47,33.75,33.94,33.38,32.53,31.44,31.47,30.44,29.28,29.44,29.03,29.69,30.34,32.19,33.56,34.66,36.22,36.75,37.06,36.31,34.53,33.66,32.41,31.12,30.03,30.22,29.84,28.41,27.28,26.59,25.19,24.47,23.56,23.88,23.53,23.25,23.31,21.5,21.72,20.81,20.0,20.12,19.81,19.12,17.41,14.91,11.81,8.78,6.88,5.84,7.19,10.03,13.47,18.34,21.69,25.44,27.38,28.5,27.69,27.44,26.78,26.72,26.38,26.06,26.31,26.5,26.66,26.28,25.84,25.72,24.44,24.12,24.38,23.81,23.25,23.84,23.62,24.38,24.69,25.38,25.75,26.22,25.91,26.44,27.34,27.47,27.94,28.22,27.78,27.28,26.09,24.72,22.91,20.31,17.44,13.94,12.5,9.69,7.62,7.19,8.28,9.19,11.62,14.09,15.94,16.69,18.62,19.0,21.66,23.41,25.0,26.69,26.56,25.94,23.09,21.44,19.28,19.12,18.41,19.25,20.5,21.47,21.38,22.25,21.06,21.72,22.03,22.34,23.88,24.38,23.91,23.09,21.78,21.69,21.56,20.72,21.31,22.25,21.0,20.06,19.94,18.41,16.03,15.59,14.47,15.22,14.66,16.06,17.03,18.03,18.97,18.91,19.94,19.31,18.69,18.81,18.34,19.03,18.75,21.31,22.94,24.12,26.88,26.69,24.94,21.88,17.88,12.41,8.94,6.22,5.28,5.28,5.75,6.09,6.16,5.38,5.03,3.66,5.28,5.19,5.75,8.16,9.47,9.19,10.31,9.53,8.78,8.66,8.25,7.75,7.69,7.56,7.25,7.19,8.69,8.22,9.31,10.06,11.34,11.69,13.09,13.81,14.75,16.0,16.72,17.31,18.03,17.5,16.91,17.44,16.75,15.44,14.25,12.75,11.38,10.72,10.69,12.03,13.0,14.38,16.19,17.34,18.44,18.16,17.88,16.94,16.06,15.81,16.09,17.5,17.53,18.84,19.25,18.88,17.91,16.94,16.59,16.78,16.0,15.44,14.16,12.78,12.25,11.84,12.25,12.5,12.28,11.78,11.69,10.81,9.91,11.41,11.31,11.41,13.06,14.0,14.44,15.78,15.88,15.34,15.31,14.5,13.56,13.91,12.94,12.41,11.72,11.88,12.12,12.28,14.44,14.75,15.09,15.53,15.25,14.62,13.84,14.66,14.38,13.94,15.72,15.56,14.81,15.06,15.88,15.62,14.34,14.09,11.25,9.88,7.34,6.25,6.38,6.53,7.53,10.06,12.31,13.38,13.19,14.03,11.66,10.75,10.41,9.06,8.56,7.0,7.62,7.16,8.47,10.38,11.59,15.03,16.22,19.62,20.44,22.94,23.84,23.75,24.06,23.69,22.97,21.66,19.25,17.62,15.56,15.0,15.62,16.75,17.78,19.09,19.34,19.94,19.94,19.0,18.94,18.72,18.44,18.47,18.81,19.12,17.72,18.16,19.16,18.81,18.94,18.59,16.59,15.75,14.03,13.53,13.84,14.75,15.88,16.62,18.0,18.91,18.09,18.69,17.72,16.38,16.0,17.03,17.31,18.06,19.56,20.03,20.09,19.97,21.47,21.94,22.97,23.09,22.72,22.41,20.88,20.38,18.5,18.69,17.03,16.12,15.19,14.28,14.72,15.56,16.25,17.66,17.56,15.84,15.28,13.34,13.25,13.12,14.28,14.72,14.12,13.19,11.25,11.16,9.84,9.47,9.12,8.78,7.66,6.78,6.88,7.62,7.56,9.22,10.81,10.75,11.56,11.66,12.16,13.5,15.78,18.56,23.38,27.28,30.06,32.09,32.03,28.66,24.75,20.72,16.34,13.25,11.19,10.28,9.19,9.38,9.09,7.53,7.59,6.88,6.94,7.06,7.69,9.12,9.34,10.91,11.97,13.31,-0.94,-0.03,0.69,0.16,1.16,1.44,2.78,3.88,5.12,5.56,6.19,5.28:4.84,2.25,2.31,0.22,-1.41,-3.28,-1.31,-2.16,-1.44,-1.03,-0.53,-0.16,0.31,1.84,2.66,4.03,3.56,2.28,1.94,0.28,-0.34,-1.28,-1.78,-1.97,0.31,2.19,4.75,7.66,9.44,9.81,9.28,6.88,6.41,3.81,3.03,3.19,2.16,2.5,4.44,4.69,6.25,6.38,8.47,8.88,8.59,10.31,9.22,9.19,10.19,9.81,10.81,11.97,10.69,9.41,8.34,6.94,5.62,5.47,4.81,5.41,4.78,5.22,6.75,7.91,9.69,10.66,11.72,10.03,8.5,7.72,6.69,8.44,10.06,12.72,14.94,13.72,14.66,13.91,13.81,13.81,12.44,14.19,13.75,15.5,17.84,20.59,21.28,22.81,23.44,23.91,25.03,25.62,27.09,26.16,24.78,26.41,24.69,26.34,30.03,31.38,33.84,35.53,36.38,36.28,35.66,35.66,33.66,34.84,33.62,33.88,35.47,34.12,35.19,34.38,33.25,32.69,31.94,31.06,28.16,26.62,21.44,20.41,17.31,15.62,15.94,16.44,18.03,21.0,22.06,26.31,28.06,29.72,30.25,30.28,30.84,30.06,28.56,30.88,31.31,33.12,36.81,39.62,41.34,43.38,42.25,39.75,36.53,33.06,31.16,29.0,28.56,27.91,26.41,27.19,26.81,27.41,27.91,28.69,27.62,27.06,27.44,27.28,28.44,28.62,31.5,32.69,34.81,37.91,36.31,35.69,35.56,31.69,30.53,29.97,29.5,28.44,28.12,26.97,25.84,25.97,24.78,24.41,26.19,26.25,27.28,26.97,26.0,25.75,24.69,24.88,24.81,25.69,25.59,24.09,22.53,20.94,19.69,19.88,21.62,24.66,27.19,30.44,30.84,32.97,33.06,33.59,34.62,36.06,36.25,36.81,37.47,35.41,35.38,32.03,30.62,29.16,27.12,25.78,26.81,24.94,24.19,23.62,22.06,19.78,18.66,17.16,15.16,15.59,13.62,15.56,16.62,17.84,20.69,22.25,25.94,27.75,29.5,31.56,32.03,30.66,29.91,27.44,24.91,22.84,21.06,18.78,15.84,13.16,9.81,9.56,9.16,11.53,15.25,17.97,21.47,22.53,24.06,24.41,23.78,23.88,22.62,22.44,21.62,20.19,17.47,16.94,15.97,13.69,13.25,13.75,13.16,13.53,13.91,15.94,16.44,17.5,19.19,20.34,21.03,20.06,20.81,19.56,16.56,14.97,13.88,12.66,13.34,14.44,18.56,21.38,24.88,26.03,27.44,26.5,23.56,22.09,18.81,17.72,14.12,15.41,15.84,17.47,20.56,23.44,24.81,25.59,24.38,23.66,20.72,16.72,15.19,13.28,12.03,10.69,10.25,10.91,10.5,9.69,8.84,10.34,8.31,10.12,10.31,11.81,13.5,16.12,18.16,23.5,26.0,28.69,30.62,31.09,29.69,27.47,26.12,23.41,21.59,19.81,20.03,21.03,22.56,24.22,24.41,25.72,24.16,24.16,23.56,22.28,21.94,22.62,22.16,22.06,22.66,21.56,20.41,19.72,18.25,18.12,17.56,18.41,18.06,20.12,22.34,25.81,29.88,34.69,37.19,40.59,41.28,40.09,37.84,35.16,31.12,27.72,25.16,22.81,20.91,20.88,21.34,21.34,22.31,22.06,20.78,20.56,19.91,18.53,19.81,21.94,24.16,26.25,29.34,30.56,29.66,26.81,26.72,23.72,22.47,22.84,22.66,25.19,26.06,28.06,29.56,30.88,29.5,28.94,26.88,26.5,25.88,25.88,25.41,26.38,24.12,24.06,25.0,24.03,26.12,25.34,25.0,24.41,22.09,22.06,23.78,23.66,26.41,28.84,30.94,32.28,33.62,34.06,33.56,33.0,32.09,31.19,31.69,33.66,32.47,33.75,33.94,33.38,32.53,31.44,31.47,30.44,29.28,29.44,29.03,29.69,30.34,32.19,33.56,34.66,36.22,36.75,37.06,36.31,34.53,33.66,32.41,31.12,30.03,30.22,29.84,28.41,27.28,26.59,25.19,24.47,23.56,23.88,23.53,23.25,23.31,21.5,21.72,20.81,20.0,20.12,19.81,19.12,17.41,14.91,11.81,8.78,6.88,5.84,7.19,10.03,13.47,18.34,21.69,25.44,27.38,28.5,27.69,27.44,26.78,26.72,26.38,26.06,26.31,26.5,26.66,26.28,25.84,25.72,24.44,24.12,24.38,23.81,23.25,23.84,23.62,24.38,24.69,25.38,25.75,26.22,25.91,26.44,27.34,27.47,27.94,28.22,27.78,27.28,26.09,24.72,22.91,20.31,17.44,13.94,12.5,9.69,7.62,7.19,8.28,9.19,11.62,14.09,15.94,16.69,18.62,19.0,21.66,23.41,25.0,26.69,26.56,25.94,23.09,21.44,19.28,19.12,18.41,19.25,20.5,21.47,21.38,22.25,21.06,21.72,22.03,22.34,23.88,24.38,23.91,23.09,21.78,21.69,21.56,20.72,21.31,22.25,21.0,20.06,19.94,18.41,16.03,15.59,14.47,15.22,14.66,16.06,17.03,18.03,18.97,18.91,19.94,19.31,18.69,18.81,18.34,19.03,18.75,21.31,22.94,24.12,26.88,26.69,24.94,21.88,17.88,12.41,8.94,6.22,5.28,5.28,5.75,6.09,6.16,5.38,5.03,3.66,5.28,5.19,5.75,8.16,9.47,9.19,10.31,9.53,8.78,8.66,8.25,7.75,7.69,7.56,7.25,7.19,8.69,8.22,9.31,10.06,11.34,11.69,13.09,13.81,14.75,16.0,16.72,17.31,18.03,17.5,16.91,17.44,16.75,15.44,14.25,12.75,11.38,10.72,10.69,12.03,13.0,14.38,16.19,17.34,18.44,18.16,17.88,16.94,16.06,15.81,16.09,17.5,17.53,18.84,19.25,18.88,17.91,16.94,16.59,16.78,16.0,15.44,14.16,12.78,12.25,11.84,12.25,12.5,12.28,11.78,11.69,10.81,9.91,11.41,11.31,11.41,13.06,14.0,14.44,15.78,15.88,15.34,15.31,14.5,13.56,13.91,12.94,12.41,11.72,11.88,12.12,12.28,14.44,14.75,15.09,15.53,15.25,14.62,13.84,14.66,14.38,13.94,15.72,15.56,14.81,15.06,15.88,15.62,14.34,14.09,11.25,9.88,7.34,6.25,6.38,6.53,7.53,10.06,12.31,13.38,13.19,14.03,11.66,10.75,10.41,9.06,8.56,7.0,7.62,7.16,8.47,10.38,11.59,15.03,16.22,19.62,20.44,22.94,23.84,23.75,24.06,23.69,22.97,21.66,19.25,17.62,15.56,15.0,15.62,16.75,17.78,19.09,19.34,19.94,19.94,19.0,18.94,18.72,18.44,18.47,18.81,19.12,17.72,18.16,19.16,18.81,18.94,18.59,16.59,15.75,14.03,13.53,13.84,14.75,15.88,16.62,18.0,18.91,18.09,18.69,17.72,16.38,16.0,17.03,17.31,18.06,19.56,20.03,20.09,19.97,21.47,21.94,22.97,23.09,22.72,22.41,20.88,20.38,18.5,18.69,17.03,16.12,15.19,14.28,14.72,15.56,16.25,17.66,17.56,15.84,15.28,13.34,13.25,13.12,14.28,14.72,14.12,13.19,11.25,11.16,9.84,9.47,9.12,8.78,7.66,6.78,6.88,7.62,7.56,9.22,10.81,10.75,11.56,11.66,12.16,13.5,15.78,18.56,23.38,27.28,30.06,32.09,32.03,28.66,24.75,20.72,16.34,13.25,11.19,10.28,9.19,9.38,9.09,7.53,7.59,6.88,6.94,7.06,7.69,9.12,9.34,10.91,11.97,13.31,-0.94,-0.03,0.69,0.16,1.16,1.44,2.78,3.88,5.12,5.56,6.19,5.28,5.16,3.69,3.91,5.34,4.12,4.81:-1.31,-2.16,-1.44,-1.03,-0.53,-0.16,0.31,1.84,2.66,4.03,3.56,2.28,1.94,0.28,-0.34,-1.28,-1.78,-1.97,0.31,2.19,4.75,7.66,9.44,9.81,9.28,6.88,6.41,3.81,3.03,3.19,2.16,2.5,4.44,4.69,6.25,6.38,8.47,8.88,8.59,10.31,9.22,9.19,10.19,9.81,10.81,11.97,10.69,9.41,8.34,6.94,5.62,5.47,4.81,5.41,4.78,5.22,6.75,7.91,9.69,10.66,11.72,10.03,8.5,7.72,6.69,8.44,10.06,12.72,14.94,13.72,14.66,13.91,13.81,13.81,12.44,14.19,13.75,15.5,17.84,20.59,21.28,22.81,23.44,23.91,25.03,25.62,27.09,26.16,24.78,26.41,24.69,26.34,30.03,31.38,33.84,35.53,36.38,36.28,35.66,35.66,33.66,34.84,33.62,33.88,35.47,34.12,35.19,34.38,33.25,32.69,31.94,31.06,28.16,26.62,21.44,20.41,17.31,15.62,15.94,16.44,18.03,21.0,22.06,26.31,28.06,29.72,30.25,30.28,30.84,30.06,28.56,30.88,31.31,33.12,36.81,39.62,41.34,43.38,42.25,39.75,36.53,33.06,31.16,29.0,28.56,27.91,26.41,27.19,26.81,27.41,27.91,28.69,27.62,27.06,27.44,27.28,28.44,28.62,31.5,32.69,34.81,37.91,36.31,35.69,35.56,31.69,30.53,29.97,29.5,28.44,28.12,26.97,25.84,25.97,24.78,24.41,26.19,26.25,27.28,26.97,26.0,25.75,24.69,24.88,24.81,25.69,25.59,24.09,22.53,20.94,19.69,19.88,21.62,24.66,27.19,30.44,30.84,32.97,33.06,33.59,34.62,36.06,36.25,36.81,37.47,35.41,35.38,32.03,30.62,29.16,27.12,25.78,26.81,24.94,24.19,23.62,22.06,19.78,18.66,17.16,15.16,15.59,13.62,15.56,16.62,17.84,20.69,22.25,25.94,27.75,29.5,31.56,32.03,30.66,29.91,27.44,24.91,22.84,21.06,18.78,15.84,13.16,9.81,9.56,9.16,11.53,15.25,17.97,21.47,22.53,24.06,24.41,23.78,23.88,22.62,22.44,21.62,20.19,17.47,16.94,15.97,13.69,13.25,13.75,13.16,13.53,13.91,15.94,16.44,17.5,19.19,20.34,21.03,20.06,20.81,19.56,16.56,14.97,13.88,12.66,13.34,14.44,18.56,21.38,24.88,26.03,27.44,26.5,23.56,22.09,18.81,17.72,14.12,15.41,15.84,17.47,20.56,23.44,24.81,25.59,24.38,23.66,20.72,16.72,15.19,13.28,12.03,10.69,10.25,10.91,10.5,9.69,8.84,10.34,8.31,10.12,10.31,11.81,13.5,16.12,18.16,23.5,26.0,28.69,30.62,31.09,29.69,27.47,26.12,23.41,21.59,19.81,20.03,21.03,22.56,24.22,24.41,25.72,24.16,24.16,23.56,22.28,21.94,22.62,22.16,22.06,22.66,21.56,20.41,19.72,18.25,18.12,17.56,18.41,18.06,20.12,22.34,25.81,29.88,34.69,37.19,40.59,41.28,40.09,37.84,35.16,31.12,27.72,25.16,22.81,20.91,20.88,21.34,21.34,22.31,22.06,20.78,20.56,19.91,18.53,19.81,21.94,24.16,26.25,29.34,30.56,29.66,26.81,26.72,23.72,22.47,22.84,22.66,25.19,26.06,28.06,29.56,30.88,29.5,28.94,26.88,26.5,25.88,25.88,25.41,26.38,24.12,24.06,25.0,24.03,26.12,25.34,25.0,24.41,22.09,22.06,23.78,23.66,26.41,28.84,30.94,32.28,33.62,34.06,33.56,33.0,32.09,31.19,31.69,33.66,32.47,33.75,33.94,33.38,32.53,31.44,31.47,30.44,29.28,29.44,29.03,29.69,30.34,32.19,33.56,34.66,36.22,36.75,37.06,36.31,34.53,33.66,32.41,31.12,30.03,30.22,29.84,28.41,27.28,26.59,25.19,24.47,23.56,23.88,23.53,23.25,23.31,21.5,21.72,20.81,20.0,20.12,19.81,19.12,17.41,14.91,11.81,8.78,6.88,5.84,7.19,10.03,13.47,18.34,21.69,25.44,27.38,28.5,27.69,27.44,26.78,26.72,26.38,26.06,26.31,26.5,26.66,26.28,25.84,25.72,24.44,24.12,24.38,23.81,23.25,23.84,23.62,24.38,24.69,25.38,25.75,26.22,25.91,26.44,27.34,27.47,27.94,28.22,27.78,27.28,26.09,24.72,22.91,20.31,17.44,13.94,12.5,9.69,7.62,7.19,8.28,9.19,11.62,14.09,15.94,16.69,18.62,19.0,21.66,23.41,25.0,26.69,26.56,25.94,23.09,21.44,19.28,19.12,18.41,19.25,20.5,21.47,21.38,22.25,21.06,21.72,22.03,22.34,23.88,24.38,23.91,23.09,21.78,21.69,21.56,20.72,21.31,22.25,21.0,20.06,19.94,18.41,16.03,15.59,14.47,15.22,14.66,16.06,17.03,18.03,18.97,18.91,19.94,19.31,18.69,18.81,18.34,19.03,18.75,21.31,22.94,24.12,26.88,26.69,24.94,21.88,17.88,12.41,8.94,6.22,5.28,5.28,5.75,6.09,6.16,5.38,5.03,3.66,5.28,5.19,5.75,8.16,9.47,9.19,10.31,9.53,8.78,8.66,8.25,7.75,7.69,7.56,7.25,7.19,8.69,8.22,9.31,10.06,11.34,11.69,13.09,13.81,14.75,16.0,16.72,17.31,18.03,17.5,16.91,17.44,16.75,15.44,14.25,12.75,11.38,10.72,10.69,12.03,13.0,14.38,16.19,17.34,18.44,18.16,17.88,16.94,16.06,15.81,16.09,17.5,17.53,18.84,19.25,18.88,17.91,16.94,16.59,16.78,16.0,15.44,14.16,12.78,12.25,11.84,12.25,12.5,12.28,11.78,11.69,10.81,9.91,11.41,11.31,11.41,13.06,14.0,14.44,15.78,15.88,15.34,15.31,14.5,13.56,13.91,12.94,12.41,11.72,11.88,12.12,12.28,14.44,14.75,15.09,15.53,15.25,14.62,13.84,14.66,14.38,13.94,15.72,15.56,14.81,15.06,15.88,15.62,14.34,14.09,11.25,9.88,7.34,6.25,6.38,6.53,7.53,10.06,12.31,13.38,13.19,14.03,11.66,10.75,10.41,9.06,8.56,7.0,7.62,7.16,8.47,10.38,11.59,15.03,16.22,19.62,20.44,22.94,23.84,23.75,24.06,23.69,22.97,21.66,19.25,17.62,15.56,15.0,15.62,16.75,17.78,19.09,19.34,19.94,19.94,19.0,18.94,18.72,18.44,18.47,18.81,19.12,17.72,18.16,19.16,18.81,18.94,18.59,16.59,15.75,14.03,13.53,13.84,14.75,15.88,16.62,18.0,18.91,18.09,18.69,17.72,16.38,16.0,17.03,17.31,18.06,19.56,20.03,20.09,19.97,21.47,21.94,22.97,23.09,22.72,22.41,20.88,20.38,18.5,18.69,17.03,16.12,15.19,14.28,14.72,15.56,16.25,17.66,17.56,15.84,15.28,13.34,13.25,13.12,14.28,14.72,14.12,13.19,11.25,11.16,9.84,9.47,9.12,8.78,7.66,6.78,6.88,7.62,7.56,9.22,10.81,10.75,11.56,11.66,12.16,13.5,15.78,18.56,23.38,27.28,30.06,32.09,32.03,28.66,24.75,20.72,16.34,13.25,11.19,10.28,9.19,9.38,9.09,7.53,7.59,6.88,6.94,7.06,7.69,9.12,9.34,10.91,11.97,13.31,-0.94,-0.03,0.69,0.16,1.16,1.44,2.78,3.88,5.12,5.56,6.19,5.28,5.16,3.69,3.91,5.34,4.12,4.81,4.5,2.66,0.81,-0.84,-2.75,-4.69:0.31,1.84,2.66,4.03,3.56,2.28,1.94,0.28,-0.34,-1.28,-1.78,-1.97,0.31,2.19,4.75,7.66,9.44,9.81,9.28,6.88,6.41,3.81,3.03,3.19,2.16,2.5,4.44,4.69,6.25,6.38,8.47,8.88,8.59,10.31,9.22,9.19,10.19,9.81,10.81,11.97,10.69,9.41,8.34,6.94,5.62,5.47,4.81,5.41,4.78,5.22,6.75,7.91,9.69,10.66,11.72,10.03,8.5,7.72,6.69,8.44,10.06,12.72,14.94,13.72,14.66,13.91,13.81,13.81,12.44,14.19,13.75,15.5,17.84,20.59,21.28,22.81,23.44,23.91,25.03,25.62,27.09,26.16,24.78,26.41,24.69,26.34,30.03,31.38,33.84,35.53,36.38,36.28,35.66,35.66,33.66,34.84,33.62,33.88,35.47,34.12,35.19,34.38,33.25,32.69,31.94,31.06,28.16,26.62,21.44,20.41,17.31,15.62,15.94,16.44,18.03,21.0,22.06,26.31,28.06,29.72,30.25,30.28,30.84,30.06,28.56,30.88,31.31,33.12,36.81,39.62,41.34,43.38,42.25,39.75,36.53,33.06,31.16,29.0,28.56,27.91,26.41,27.19,26.81,27.41,27.91,28.69,27.62,27.06,27.44,27.28,28.44,28.62,31.5,32.69,34.81,37.91,36.31,35.69,35.56,31.69,30.53,29.97,29.5,28.44,28.12,26.97,25.84,25.97,24.78,24.41,26.19,26.25,27.28,26.97,26.0,25.75,24.69,24.88,24.81,25.69,25.59,24.09,22.53,20.94,19.69,19.88,21.62,24.66,27.19,30.44,30.84,32.97,33.06,33.59,34.62,36.06,36.25,36.81,37.47,35.41,35.38,32.03,30.62,29.16,27.12,25.78,26.81,24.94,24.19,23.62,22.06,19.78,18.66,17.16,15.16,15.59,13.62,15.56,16.62,17.84,20.69,22.25,25.94,27.75,29.5,31.56,32.03,30.66,29.91,27.44,24.91,22.84,21.06,18.78,15.84,13.16,9.81,9.56,9.16,11.53,15.25,17.97,21.47,22.53,24.06,24.41,23.78,23.88,22.62,22.44,21.62,20.19,17.47,16.94,15.97,13.69,13.25,13.75,13.16,13.53,13.91,15.94,16.44,17.5,19.19,20.34,21.03,20.06,20.81,19.56,16.56,14.97,13.88,12.66,13.34,14.44,18.56,21.38,24.88,26.03,27.44,26.5,23.56,22.09,18.81,17.72,14.12,15.41,15.84,17.47,20.56,23.44,24.81,25.59,24.38,23.66,20.72,16.72,15.19,13.28,12.03,10.69,10.25,10.91,10.5,9.69,8.84,10.34,8.31,10.12,10.31,11.81,13.5,16.12,18.16,23.5,26.0,28.69,30.62,31.09,29.69,27.47,26.12,23.41,21.59,19.81,20.03,21.03,22.56,24.22,24.41,25.72,24.16,24.16,23.56,22.28,21.94,22.62,22.16,22.06,22.66,21.56,20.41,19.72,18.25,18.12,17.56,18.41,18.06,20.12,22.34,25.81,29.88,34.69,37.19,40.59,41.28,40.09,37.84,35.16,31.12,27.72,25.16,22.81,20.91,20.88,21.34,21.34,22.31,22.06,20.78,20.56,19.91,18.53,19.81,21.94,24.16,26.25,29.34,30.56,29.66,26.81,26.72,23.72,22.47,22.84,22.66,25.19,26.06,28.06,29.56,30.88,29.5,28.94,26.88,26.5,25.88,25.88,25.41,26.38,24.12,24.06,25.0,24.03,26.12,25.34,25.0,24.41,22.09,22.06,23.78,23.66,26.41,28.84,30.94,32.28,33.62,34.06,33.56,33.0,32.09,31.19,31.69,33.66,32.47,33.75,33.94,33.38,32.53,31.44,31.47,30.44,29.28,29.44,29.03,29.69,30.34,32.19,33.56,34.66,36.22,36.75,37.06,36.31,34.53,33.66,32.41,31.12,30.03,30.22,29.84,28.41,27.28,26.59,25.19,24.47,23.56,23.88,23.53,23.25,23.31,21.5,21.72,20.81,20.0,20.12,19.81,19.12,17.41,14.91,11.81,8.78,6.88,5.84,7.19,10.03,13.47,18.34,21.69,25.44,27.38,28.5,27.69,27.44,26.78,26.72,26.38,26.06,26.31,26.5,26.66,26.28,25.84,25.72,24.44,24.12,24.38,23.81,23.25,23.84,23.62,24.38,24.69,25.38,25.75,26.22,25.91,26.44,27.34,27.47,27.94,28.22,27.78,27.28,26.09,24.72,22.91,20.31,17.44,13.94,12.5,9.69,7.62,7.19,8.28,9.19,11.62,14.09,15.94,16.69,18.62,19.0,21.66,23.41,25.0,26.69,26.56,25.94,23.09,21.44,19.28,19.12,18.41,19.25,20.5,21.47,21.38,22.25,21.06,21.72,22.03,22.34,23.88,24.38,23.91,23.09,21.78,21.69,21.56,20.72,21.31,22.25,21.0,20.06,19.94,18.41,16.03,15.59,14.47,15.22,14.66,16.06,17.03,18.03,18.97,18.91,19.94,19.31,18.69,18.81,18.34,19.03,18.75,21.31,22.94,24.12,26.88,26.69,24.94,21.88,17.88,12.41,8.94,6.22,5.28,5.28,5.75,6.09,6.16,5.38,5.03,3.66,5.28,5.19,5.75,8.16,9.47,9.19,10.31,9.53,8.78,8.66,8.25,7.75,7.69,7.56,7.25,7.19,8.69,8.22,9.31,10.06,11.34,11.69,13.09,13.81,14.75,16.0,16.72,17.31,18.03,17.5,16.91,17.44,16.75,15.44,14.25,12.75,11.38,10.72,10.69,12.03,13.0,14.38,16.19,17.34,18.44,18.16,17.88,16.94,16.06,15.81,16.09,17.5,17.53,18.84,19.25,18.88,17.91,16.94,16.59,16.78,16.0,15.44,14.16,12.78,12.25,11.84,12.25,12.5,12.28,11.78,11.69,10.81,9.91,11.41,11.31,11.41,13.06,14.0,14.44,15.78,15.88,15.34,15.31,14.5,13.56,13.91,12.94,12.41,11.72,11.88,12.12,12.28,14.44,14.75,15.09,15.53,15.25,14.62,13.84,14.66,14.38,13.94,15.72,15.56,14.81,15.06,15.88,15.62,14.34,14.09,11.25,9.88,7.34,6.25,6.38,6.53,7.53,10.06,12.31,13.38,13.19,14.03,11.66,10.75,10.41,9.06,8.56,7.0,7.62,7.16,8.47,10.38,11.59,15.03,16.22,19.62,20.44,22.94,23.84,23.75,24.06,23.69,22.97,21.66,19.25,17.62,15.56,15.0,15.62,16.75,17.78,19.09,19.34,19.94,19.94,19.0,18.94,18.72,18.44,18.47,18.81,19.12,17.72,18.16,19.16,18.81,18.94,18.59,16.59,15.75,14.03,13.53,13.84,14.75,15.88,16.62,18.0,18.91,18.09,18.69,17.72,16.38,16.0,17.03,17.31,18.06,19.56,20.03,20.09,19.97,21.47,21.94,22.97,23.09,22.72,22.41,20.88,20.38,18.5,18.69,17.03,16.12,15.19,14.28,14.72,15.56,16.25,17.66,17.56,15.84,15.28,13.34,13.25,13.12,14.28,14.72,14.12,13.19,11.25,11.16,9.84,9.47,9.12,8.78,7.66,6.78,6.88,7.62,7.56,9.22,10.81,10.75,11.56,11.66,12.16,13.5,15.78,18.56,23.38,27.28,30.06,32.09,32.03,28.66,24.75,20.72,16.34,13.25,11.19,10.28,9.19,9.38,9.09,7.53,7.59,6.88,6.94,7.06,7.69,9.12,9.34,10.91,11.97,13.31,-0.94,-0.03,0.69,0.16,1.16,1.44,2.78,3.88,5.12,5.56,6.19,5.28,5.16,3.69,3.91,5.34,4.12,4.81,4.5,2.66,0.81,-0.84,-2.75,-4.69,-5.91,-8.03,-8.78,-8.94,-8.69,-7.53:negativity
25.0,23.44,22.16,22.19,22.34,22.47,22.28,22.34,21.66,21.03,19.56,18.34,17.34,16.5,16.66,16.97,18.53,19.53,20.31,21.88,21.84,21.94,22.25,22.03,22.66,23.0,24.09,25.34,27.81,29.28,31.66,33.53,33.91,33.66,32.16,29.16,27.28,27.03,25.59,27.12,28.06,28.62,29.66,29.97,31.75,32.78,33.56,36.22,37.0,37.78,38.97,37.53,36.47,35.06,32.75,33.44,32.66,31.41,30.56,30.91,31.06,30.28,31.66,31.19,30.62,29.97,29.81,29.19,30.03,30.72,32.62,34.0,35.41,36.25,35.53,34.59,30.78,27.91,25.16,22.62,21.31,21.53,23.31,25.25,28.75,30.66,32.03,32.69,31.34,30.0,27.44,25.28,23.53,22.25,20.88,20.75,20.94,21.03,21.0,21.0,19.81,20.16,19.62,18.88,19.53,19.19,19.56,20.22,20.69,23.03,25.81,28.12,29.38,30.62,30.53,28.81,27.75,26.41,25.66,25.28,27.56,29.75,34.06,38.94,43.0,46.84,47.69,47.66,44.03,40.12,35.62,31.47,29.34,29.91,30.5,33.0,33.53,35.25,34.78,34.25,32.53,30.81,29.59,28.31,26.78,26.0,25.38,25.25,25.88,26.81,27.66,28.69,30.91,31.12,32.53,34.53,36.53,38.66,40.41,42.69,42.81,42.16,41.88,38.31,35.56,32.5,29.81,28.88,26.88,26.59,25.88,25.75,25.81,26.75,27.81,30.25,32.66,35.34,37.41,40.09,42.38,43.53,43.97,44.44,43.78,42.28,40.59,39.03,37.84,38.16,37.94,39.28,40.84,42.31,41.31,41.12,39.81,39.12,38.72,37.16,36.69,35.47,35.44,37.34,40.03,43.5,48.03,50.41,51.66,51.81,50.06,47.19,44.81,42.91,40.0,39.16,37.62,36.75,36.34,35.06,34.94,34.75,33.62,33.53,33.78,34.41,34.81,34.88,35.31,36.16,37.81,38.69,41.03,42.41,41.41,40.12,36.62,33.09,30.97,30.12,29.62,29.34,28.59,25.41,23.66,19.97,17.53,16.56,16.59,17.56,18.69,21.22,23.16,26.44,29.0,31.88,34.31,36.91,38.16,38.47,38.81,38.41,38.03,37.81,38.22,38.31,37.0,36.78,33.78,31.44,28.75,26.75,26.12,24.81,26.09,26.38,28.31,30.03,31.56,31.66,34.22,35.16,36.94,38.84,39.06,39.69,39.03,37.44,36.81,36.03,35.44,33.81,32.31,30.53,28.75,28.28,28.16,29.06,30.31,31.56,33.31,34.31,34.66,35.19,34.41,35.28,34.81,36.06,37.62,40.09,41.12,42.19,42.34,42.09,41.84,41.03,39.75,39.12,38.12,36.69,35.31,35.16,33.53,33.28,32.12,31.78,32.16,32.44,34.41,36.66,37.84,39.84,41.91,42.31,43.34,44.81,45.34,45.84,45.19,43.91,42.53,41.06,40.28,38.59,38.56,39.34,39.41,40.28,40.91,41.34,42.16,40.88,39.94,37.91,36.44,34.19,33.22,32.25,32.75,33.72,34.75,37.0,38.5,39.06,40.91,41.34,40.53,39.34,38.41,37.06,34.62,32.66,31.81,31.84,32.19,35.5,38.5,43.78,47.09,48.5,47.97,45.34,41.16,37.81,34.12,30.88,28.38,26.84,24.88,24.38,24.31,24.59,26.06,26.78,27.56,27.88,27.81,27.25,26.0,25.91,27.66,30.03,33.53,36.38,38.84,40.0,40.41,39.03,37.94,35.94,34.81,33.19,31.38,30.72,29.97,31.03,30.66,31.03,32.88,34.47,34.97,37.69,38.69,40.25,41.31,41.53,41.94,41.91,42.66,43.38,44.66,45.53,46.53,46.69,46.56,44.5,42.66,40.34,38.72,37.69,37.94,40.16,43.03,45.09,47.03,48.38,47.59,47.41,47.19,45.16,44.69,44.0,42.62,41.31,39.94,39.16,38.06,36.22,35.47,34.44,33.53,33.06,33.31,34.72,35.19,37.94,38.5,38.88,39.56,40.06,40.78,40.44,40.38,39.78,38.34,37.0,35.62,35.12,35.84,36.5,37.03,37.53,37.34,36.25,35.06,33.84,32.94,32.25,30.94,29.41,28.47,27.03,26.25,25.44,24.09,23.81,22.19,20.75,20.31,20.06,20.03,19.91,21.66,22.0,23.12,23.84,24.25,26.31,27.34,28.66,29.31,29.38,28.12,26.38,25.41,24.94,25.0,24.97,24.06,22.0,20.31,18.81,17.06,16.97,17.47,18.34,20.0,21.59,24.34,26.75,29.81,32.19,33.47,34.16,33.41,32.41,29.5,26.41,24.59,22.81,20.84,19.31,19.16,17.56,18.0,18.62,19.12,19.78,19.28,18.84,17.22,16.09,16.69,16.72,17.25,18.25,18.88,19.09,19.94,18.84,18.75,18.06,17.91,17.75,17.91,18.59,19.44,19.97,19.78,19.31,18.59,17.66,16.75,15.53,14.31,13.75,13.66,14.28,14.38,15.41,16.03,14.94,13.62,11.72,10.19,8.53,9.03,9.25,10.78,13.34,15.16,16.44,18.41,19.47,19.81,20.31,19.94,19.53,18.31,18.38,18.5,18.59,20.66,22.62,25.25,26.94,28.38,28.53,28.66,26.75,25.72,25.41,25.28,25.06,24.94,24.66,23.41,21.78,20.16,18.81,19.06,20.56,24.56,29.25,34.19,38.72,42.31,43.28,43.03,40.91,38.25,33.94,31.5,27.66,24.41,22.5,20.97,18.97,17.28,16.91,16.06,16.91,17.75,20.75,23.62,25.94,28.78,30.56,30.41,30.41,29.66,29.19,28.0,28.66,28.69,28.53,27.91,26.5,23.91,22.91,20.03,18.5,16.0,13.88,12.31,10.06,9.34,8.81,8.31,8.69,8.81,8.97,10.62,12.12,13.75,14.97,16.44,17.44,17.69,19.09,20.41,21.84,23.19,23.94,22.91,22.12,21.34,19.47,18.56,17.94,17.56,16.59,16.0,15.06,14.22,15.03,16.19,18.16,20.91,23.75,26.34,27.88,29.22,29.56,29.41,28.94,27.94,26.66,26.53,25.84,25.19,23.88,21.97,20.28,18.16,17.25,17.03,16.91,18.31,19.72,20.62,20.78,21.41,20.88,20.88,21.0,21.44,22.62,23.06,23.38,21.81,21.16,19.31,16.84,14.25,11.47,9.31,6.78,6.06,6.25,7.19,9.47,10.91,12.62,14.12,15.09,16.88,17.69,18.88,20.44,21.19,23.31,24.69,26.34,27.88,30.03,30.41,30.66,30.5,29.56,28.25,27.38,26.25,24.59,22.69,20.94,18.88,16.41,15.12,13.81,13.09,12.62,13.88,14.88,17.59,20.19,23.19,26.19,28.0,28.66,27.53,25.81,23.12,19.56,17.47,15.56,14.28,14.19,13.94,14.0,14.09,14.91,14.84,15.12,15.12,13.81,13.44,12.81,13.75,15.25,17.84,20.12,22.97,24.56,25.53,26.25,26.25,24.88,23.69,21.47,19.12,16.94,15.19,14.34,13.75,14.78,14.38,14.81,14.84,14.47,13.97,13.75,13.56,13.62,14.47,16.12,16.62,18.72,20.09,20.69,20.94,21.06,20.47,21.03,21.44,21.84,21.53,21.88,21.66,21.47,20.69,20.19,18.75,17.81,16.34,14.69,14.66,14.69,15.62,16.81,18.56,21.0,22.31,23.56,24.31,23.69,22.53,20.59,18.53,16.69,14.88,14.91,13.91,15.59,16.72,17.78,19.31,20.44,20.25,20.56,20.09,20.5,19.44,18.69,18.78,17.31,16.16,15.88,15.25,15.44,16.44,17.62,19.25,20.69,22.34,22.62,21.12,18.91,15.19,10.28,6.5,2.94,1.19,-0.22,-0.72,0.5:22.28,22.34,21.66,21.03,19.56,18.34,17.34,16.5,16.66,16.97,18.53,19.53,20.31,21.88,21.84,21.94,22.25,22.03,22.66,23.0,24.09,25.34,27.81,29.28,31.66,33.53,33.91,33.66,32.16,29.16,27.28,27.03,25.59,27.12,28.06,28.62,29.66,29.97,31.75,32.78,33.56,36.22,37.0,37.78,38.97,37.53,36.47,35.06,32.75,33.44,32.66,31.41,30.56,30.91,31.06,30.28,31.66,31.19,30.62,29.97,29.81,29.19,30.03,30.72,32.62,34.0,35.41,36.25,35.53,34.59,30.78,27.91,25.16,22.62,21.31,21.53,23.31,25.25,28.75,30.66,32.03,32.69,31.34,30.0,27.44,25.28,23.53,22.25,20.88,20.75,20.94,21.03,21.0,21.0,19.81,20.16,19.62,18.88,19.53,19.19,19.56,20.22,20.69,23.03,25.81,28.12,29.38,30.62,30.53,28.81,27.75,26.41,25.66,25.28,27.56,29.75,34.06,38.94,43.0,46.84,47.69,47.66,44.03,40.12,35.62,31.47,29.34,29.91,30.5,33.0,33.53,35.25,34.78,34.25,32.53,30.81,29.59,28.31,26.78,26.0,25.38,25.25,25.88,26.81,27.66,28.69,30.91,31.12,32.53,34.53,36.53,38.66,40.41,42.69,42.81,42.16,41.88,38.31,35.56,32.5,29.81,28.88,26.88,26.59,25.88,25.75,25.81,26.75,27.81,30.25,32.66,35.34,37.41,40.09,42.38,43.53,43.97,44.44,43.78,42.28,40.59,39.03,37.84,38.16,37.94,39.28,40.84,42.31,41.31,41.12,39.81,39.12,38.72,37.16,36.69,35.47,35.44,37.34,40.03,43.5,48.03,50.41,51.66,51.81,50.06,47.19,44.81,42.91,40.0,39.16,37.62,36.75,36.34,35.06,34.94,34.75,33.62,33.53,33.78,34.41,34.81,34.88,35.31,36.16,37.81,38.69,41.03,42.41,41.41,40.12,36.62,33.09,30.97,30.12,29.62,29.34,28.59,25.41,23.66,19.97,17.53,16.56,16.59,17.56,18.69,21.22,23.16,26.44,29.0,31.88,34.31,36.91,38.16,38.47,38.81,38.41,38.03,37.81,38.22,38.31,37.0,36.78,33.78,31.44,28.75,26.75,26.12,24.81,26.09,26.38,28.31,30.03,31.56,31.66,34.22,35.16,36.94,38.84,39.06,39.69,39.03,37.44,36.81,36.03,35.44,33.81,32.31,30.53,28.75,28.28,28.16,29.06,30.31,31.56,33.31,34.31,34.66,35.19,34.41,35.28,34.81,36.06,37.62,40.09,41.12,42.19,42.34,42.09,41.84,41.03,39.75,39.12,38.12,36.69,35.31,35.16,33.53,33.28,32.12,31.78,32.16,32.44,34.41,36.66,37.84,39.84,41.91,42.31,43.34,44.81,45.34,45.84,45.19,43.91,42.53,41.06,40.28,38.59,38.56,39.34,39.41,40.28,40.91,41.34,42.16,40.88,39.94,37.91,36.44,34.19,33.22,32.25,32.75,33.72,34.75,37.0,38.5,39.06,40.91,41.34,40.53,39.34,38.41,37.06,34.62,32.66,31.81,31.84,32.19,35.5,38.5,43.78,47.09,48.5,47.97,45.34,41.16,37.81,34.12,30.88,28.38,26.84,24.88,24.38,24.31,24.59,26.06,26.78,27.56,27.88,27.81,27.25,26.0,25.91,27.66,30.03,33.53,36.38,38.84,40.0,40.41,39.03,37.94,35.94,34.81,33.19,31.38,30.72,29.97,31.03,30.66,31.03,32.88,34.47,34.97,37.69,38.69,40.25,41.31,41.53,41.94,41.91,42.66,43.38,44.66,45.53,46.53,46.69,46.56,44.5,42.66,40.34,38.72,37.69,37.94,40.16,43.03,45.09,47.03,48.38,47.59,47.41,47.19,45.16,44.69,44.0,42.62,41.31,39.94,39.16,38.06,36.22,35.47,34.44,33.53,33.06,33.31,34.72,35.19,37.94,38.5,38.88,39.56,40.06,40.78,40.44,40.38,39.78,38.34,37.0,35.62,35.12,35.84,36.5,37.03,37.53,37.34,36.25,35.06,33.84,32.94,32.25,30.94,29.41,28.47,27.03,26.25,25.44,24.09,23.81,22.19,20.75,20.31,20.06,20.03,19.91,21.66,22.0,23.12,23.84,24.25,26.31,27.34,28.66,29.31,29.38,28.12,26.38,25.41,24.94,25.0,24.97,24.06,22.0,20.31,18.81,17.06,16.97,17.47,18.34,20.0,21.59,24.34,26.75,29.81,32.19,33.47,34.16,33.41,32.41,29.5,26.41,24.59,22.81,20.84,19.31,19.16,17.56,18.0,18.62,19.12,19.78,19.28,18.84,17.22,16.09,16.69,16.72,17.25,18.25,18.88,19.09,19.94,18.84,18.75,18.06,17.91,17.75,17.91,18.59,19.44,19.97,19.78,19.31,18.59,17.66,16.75,15.53,14.31,13.75,13.66,14.28,14.38,15.41,16.03,14.94,13.62,11.72,10.19,8.53,9.03,9.25,10.78,13.34,15.16,16.44,18.41,19.47,19.81,20.31,19.94,19.53,18.31,18.38,18.5,18.59,20.66,22.62,25.25,26.94,28.38,28.53,28.66,26.75,25.72,25.41,25.28,25.06,24.94,24.66,23.41,21.78,20.16,18.81,19.06,20.56,24.56,29.25,34.19,38.72,42.31,43.28,43.03,40.91,38.25,33.94,31.5,27.66,24.41,22.5,20.97,18.97,17.28,16.91,16.06,16.91,17.75,20.75,23.62,25.94,28.78,30.56,30.41,30.41,29.66,29.19,28.0,28.66,28.69,28.53,27.91,26.5,23.91,22.91,20.03,18.5,16.0,13.88,12.31,10.06,9.34,8.81,8.31,8.69,8.81,8.97,10.62,12.12,13.75,14.97,16.44,17.44,17.69,19.09,20.41,21.84,23.19,23.94,22.91,22.12,21.34,19.47,18.56,17.94,17.56,16.59,16.0,15.06,14.22,15.03,16.19,18.16,20.91,23.75,26.34,27.88,29.22,29.56,29.41,28.94,27.94,26.66,26.53,25.84,25.19,23.88,21.97,20.28,18.16,17.25,17.03,16.91,18.31,19.72,20.62,20.78,21.41,20.88,20.88,21.0,21.44,22.62,23.06,23.38,21.81,21.16,19.31,16.84,14.25,11.47,9.31,6.78,6.06,6.25,7.19,9.47,10.91,12.62,14.12,15.09,16.88,17.69,18.88,20.44,21.19,23.31,24.69,26.34,27.88,30.03,30.41,30.66,30.5,29.56,28.25,27.38,26.25,24.59,22.69,20.94,18.88,16.41,15.12,13.81,13.09,12.62,13.88,14.88,17.59,20.19,23.19,26.19,28.0,28.66,27.53,25.81,23.12,19.56,17.47,15.56,14.28,14.19,13.94,14.0,14.09,14.91,14.84,15.12,15.12,13.81,13.44,12.81,13.75,15.25,17.84,20.12,22.97,24.56,25.53,26.25,26.25,24.88,23.69,21.47,19.12,16.94,15.19,14.34,13.75,14.78,14.38,14.81,14.84,14.47,13.97,13.75,13.56,13.62,14.47,16.12,16.62,18.72,20.09,20.69,20.94,21.06,20.47,21.03,21.44,21.84,21.53,21.88,21.66,21.47,20.69,20.19,18.75,17.81,16.34,14.69,14.66,14.69,15.62,16.81,18.56,21.0,22.31,23.56,24.31,23.69,22.53,20.59,18.53,16.69,14.88,14.91,13.91,15.59,16.72,17.78,19.31,20.44,20.25,20.56,20.09,20.5,19.44,18.69,18.78,17.31,16.16,15.88,15.25,15.44,16.44,17.62,19.25,20.69,22.34,22.62,21.12,18.91,15.19,10.28,6.5,2.94,1.19,-0.22,-0.72,0.5,14.44,13.72,12.53,12.25,12.12,12.03:17.34,16.5,16.66,16.97,18.53,19.53,20.31,21.88,21.84,21.94,22.25,22.03,22.66,23.0,24.09,25.34,27.81,29.28,31.66,33.53,33.91,33.66,32.16,29.16,27.28,27.03,25.59,27.12,28.06,28.62,29.66,29.97,31.75,32.78,33.56,36.22,37.0,37.78,38.97,37.53,36.47,35.06,32.75,33.44,32.66,31.41,30.56,30.91,31.06,30.28,31.66,31.19,30.62,29.97,29.81,29.19,30.03,30.72,32.62,34.0,35.41,36.25,35.53,34.59,30.78,27.91,25.16,22.62,21.31,21.53,23.31,25.25,28.75,30.66,32.03,32.69,31.34,30.0,27.44,25.28,23.53,22.25,20.88,20.75,20.94,21.03,21.0,21.0,19.81,20.16,19.62,18.88,19.53,19.19,19.56,20.22,20.69,23.03,25.81,28.12,29.38,30.62,30.53,28.81,27.75,26.41,25.66,25.28,27.56,29.75,34.06,38.94,43.0,46.84,47.69,47.66,44.03,40.12,35.62,31.47,29.34,29.91,30.5,33.0,33.53,35.25,34.78,34.25,32.53,30.81,29.59,28.31,26.78,26.0,25.38,25.25,25.88,26.81,27.66,28.69,30.91,31.12,32.53,34.53,36.53,38.66,40.41,42.69,42.81,42.16,41.88,38.31,35.56,32.5,29.81,28.88,26.88,26.59,25.88,25.75,25.81,26.75,27.81,30.25,32.66,35.34,37.41,40.09,42.38,43.53,43.97,44.44,43.78,42.28,40.59,39.03,37.84,38.16,37.94,39.28,40.84,42.31,41.31,41.12,39.81,39.12,38.72,37.16,36.69,35.47,35.44,37.34,40.03,43.5,48.03,50.41,51.66,51.81,50.06,47.19,44.81,42.91,40.0,39.16,37.62,36.75,36.34,35.06,34.94,34.75,33.62,33.53,33.78,34.41,34.81,34.88,35.31,36.16,37.81,38.69,41.03,42.41,41.41,40.12,36.62,33.09,30.97,30.12,29.62,29.34,28.59,25.41,23.66,19.97,17.53,16.56,16.59,17.56,18.69,21.22,23.16,26.44,29.0,31.88,34.31,36.91,38.16,38.47,38.81,38.41,38.03,37.81,38.22,38.31,37.0,36.78,33.78,31.44,28.75,26.75,26.12,24.81,26.09,26.38,28.31,30.03,31.56,31.66,34.22,35.16,36.94,38.84,39.06,39.69,39.03,37.44,36.81,36.03,35.44,33.81,32.31,30.53,28.75,28.28,28.16,29.06,30.31,31.56,33.31,34.31,34.66,35.19,34.41,35.28,34.81,36.06,37.62,40.09,41.12,42.19,42.34,42.09,41.84,41.03,39.75,39.12,38.12,36.69,35.31,35.16,33.53,33.28,32.12,31.78,32.16,32.44,34.41,36.66,37.84,39.84,41.91,42.31,43.34,44.81,45.34,45.84,45.19,43.91,42.53,41.06,40.28,38.59,38.56,39.34,39.41,40.28,40.91,41.34,42.16,40.88,39.94,37.91,36.44,34.19,33.22,32.25,32.75,33.72,34.75,37.0,38.5,39.06,40.91,41.34,40.53,39.34,38.41,37.06,34.62,32.66,31.81,31.84,32.19,35.5,38.5,43.78,47.09,48.5,47.97,45.34,41.16,37.81,34.12,30.88,28.38,26.84,24.88,24.38,24.31,24.59,26.06,26.78,27.56,27.88,27.81,27.25,26.0,25.91,27.66,30.03,33.53,36.38,38.84,40.0,40.41,39.03,37.94,35.94,34.81,33.19,31.38,30.72,29.97,31.03,30.66,31.03,32.88,34.47,34.97,37.69,38.69,40.25,41.31,41.53,41.94,41.91,42.66,43.38,44.66,45.53,46.53,46.69,46.56,44.5,42.66,40.34,38.72,37.69,37.94,40.16,43.03,45.09,47.03,48.38,47.59,47.41,47.19,45.16,44.69,44.0,42.62,41.31,39.94,39.16,38.06,36.22,35.47,34.44,33.53,33.06,33.31,34.72,35.19,37.94,38.5,38.88,39.56,40.06,40.78,40.44,40.38,39.78,38.34,37.0,35.62,35.12,35.84,36.5,37.03,37.53,37.34,36.25,35.06,33.84,32.94,32.25,30.94,29.41,28.47,27.03,26.25,25.44,24.09,23.81,22.19,20.75,20.31,20.06,20.03,19.91,21.66,22.0,23.12,23.84,24.25,26.31,27.34,28.66,29.31,29.38,28.12,26.38,25.41,24.94,25.0,24.97,24.06,22.0,20.31,18.81,17.06,16.97,17.47,18.34,20.0,21.59,24.34,26.75,29.81,32.19,33.47,34.16,33.41,32.41,29.5,26.41,24.59,22.81,20.84,19.31,19.16,17.56,18.0,18.62,19.12,19.78,19.28,18.84,17.22,16.09,16.69,16.72,17.25,18.25,18.88,19.09,19.94,18.84,18.75,18.06,17.91,17.75,17.91,18.59,19.44,19.97,19.78,19.31,18.59,17.66,16.75,15.53,14.31,13.75,13.66,14.28,14.38,15.41,16.03,14.94,13.62,11.72,10.19,8.53,9.03,9.25,10.78,13.34,15.16,16.44,18.41,19.47,19.81,20.31,19.94,19.53,18.31,18.38,18.5,18.59,20.66,22.62,25.25,26.94,28.38,28.53,28.66,26.75,25.72,25.41,25.28,25.06,24.94,24.66,23.41,21.78,20.16,18.81,19.06,20.56,24.56,29.25,34.19,38.72,42.31,43.28,43.03,40.91,38.25,33.94,31.5,27.66,24.41,22.5,20.97,18.97,17.28,16.91,16.06,16.91,17.75,20.75,23.62,25.94,28.78,30.56,30.41,30.41,29.66,29.19,28.0,28.66,28.69,28.53,27.91,26.5,23.91,22.91,20.03,18.5,16.0,13.88,12.31,10.06,9.34,8.81,8.31,8.69,8.81,8.97,10.62,12.12,13.75,14.97,16.44,17.44,17.69,19.09,20.41,21.84,23.19,23.94,22.91,22.12,21.34,19.47,18.56,17.94,17.56,16.59,16.0,15.06,14.22,15.03,16.19,18.16,20.91,23.75,26.34,27.88,29.22,29.56,29.41,28.94,27.94,26.66,26.53,25.84,25.19,23.88,21.97,20.28,18.16,17.25,17.03,16.91,18.31,19.72,20.62,20.78,21.41,20.88,20.88,21.0,21.44,22.62,23.06,23.38,21.81,21.16,19.31,16.84,14.25,11.47,9.31,6.78,6.06,6.25,7.19,9.47,10.91,12.62,14.12,15.09,16.88,17.69,18.88,20.44,21.19,23.31,24.69,26.34,27.88,30.03,30.41,30.66,30.5,29.56,28.25,27.38,26.25,24.59,22.69,20.94,18.88,16.41,15.12,13.81,13.09,12.62,13.88,14.88,17.59,20.19,23.19,26.19,28.0,28.66,27.53,25.81,23.12,19.56,17.47,15.56,14.28,14.19,13.94,14.0,14.09,14.91,14.84,15.12,15.12,13.81,13.44,12.81,13.75,15.25,17.84,20.12,22.97,24.56,25.53,26.25,26.25,24.88,23.69,21.47,19.12,16.94,15.19,14.34,13.75,14.78,14.38,14.81,14.84,14.47,13.97,13.75,13.56,13.62,14.47,16.12,16.62,18.72,20.09,20.69,20.94,21.06,20.47,21.03,21.44,21.84,21.53,21.88,21.66,21.47,20.69,20.19,18.75,17.81,16.34,14.69,14.66,14.69,15.62,16.81,18.56,21.0,22.31,23.56,24.31,23.69,22.53,20.59,18.53,16.69,14.88,14.91,13.91,15.59,16.72,17.78,19.31,20.44,20.25,20.56,20.09,20.5,19.44,18.69,18.78,17.31,16.16,15.88,15.25,15.44,16.44,17.62,19.25,20.69,22.34,22.62,21.12,18.91,15.19,10.28,6.5,2.94,1.19,-0.22,-0.72,0.5,14.44,13.72,12.53,12.25,12.12,12.03,11.41,10.78,8.81,7.25,4.22,2.41:20.31,21.88,21.84,21.94,22.25,22.03,22.66,23.0,24.09,25.34,27.81,29.28,31.66,33.53,33.91,33.66,32.16,29.16,27.28,27.03,25.59,27.12,28.06,28.62,29.66,29.97,31.75,32.78,33.56,36.22,37.0,37.78,38.97,37.53,36.47,35.06,32.75,33.44,32.66,31.41,30.56,30.91,31.06,30.28,31.66,31.19,30.62,29.97,29.81,29.19,30.03,30.72,32.62,34.0,35.41,36.25,35.53,34.59,30.78,27.91,25.16,22.62,21.31,21.53,23.31,25.25,28.75,30.66,32.03,32.69,31.34,30.0,27.44,25.28,23.53,22.25,20.88,20.75,20.94,21.03,21.0,21.0,19.81,20.16,19.62,18.88,19.53,19.19,19.56,20.22,20.69,23.03,25.81,28.12,29.38,30.62,30.53,28.81,27.75,26.41,25.66,25.28,27.56,29.75,34.06,38.94,43.0,46.84,47.69,47.66,44.03,40.12,35.62,31.47,29.34,29.91,30.5,33.0,33.53,35.25,34.78,34.25,32.53,30.81,29.59,28.31,26.78,26.0,25.38,25.25,25.88,26.81,27.66,28.69,30.91,31.12,32.53,34.53,36.53,38.66,40.41,42.69,42.81,42.16,41.88,38.31,35.56,32.5,29.81,28.88,26.88,26.59,25.88,25.75,25.81,26.75,27.81,30.25,32.66,35.34,37.41,40.09,42.38,43.53,43.97,44.44,43.78,42.28,40.59,39.03,37.84,38.16,37.94,39.28,40.84,42.31,41.31,41.12,39.81,39.12,38.72,37.16,36.69,35.47,35.44,37.34,40.03,43.5,48.03,50.41,51.66,51.81,50.06,47.19,44.81,42.91,40.0,39.16,37.62,36.75,36.34,35.06,34.94,34.75,33.62,33.53,33.78,34.41,34.81,34.88,35.31,36.16,37.81,38.69,41.03,42.41,41.41,40.12,36.62,33.09,30.97,30.12,29.62,29.34,28.59,25.41,23.66,19.97,17.53,16.56,16.59,17.56,18.69,21.22,23.16,26.44,29.0,31.88,34.31,36.91,38.16,38.47,38.81,38.41,38.03,37.81,38.22,38.31,37.0,36.78,33.78,31.44,28.75,26.75,26.12,24.81,26.09,26.38,28.31,30.03,31.56,31.66,34.22,35.16,36.94,38.84,39.06,39.69,39.03,37.44,36.81,36.03,35.44,33.81,32.31,30.53,28.75,28.28,28.16,29.06,30.31,31.56,33.31,34.31,34.66,35.19,34.41,35.28,34.81,36.06,37.62,40.09,41.12,42.19,42.34,42.09,41.84,41.03,39.75,39.12,38.12,36.69,35.31,35.16,33.53,33.28,32.12,31.78,32.16,32.44,34.41,36.66,37.84,39.84,41.91,42.31,43.34,44.81,45.34,45.84,45.19,43.91,42.53,41.06,40.28,38.59,38.56,39.34,39.41,40.28,40.91,41.34,42.16,40.88,39.94,37.91,36.44,34.19,33.22,32.25,32.75,33.72,34.75,37.0,38.5,39.06,40.91,41.34,40.53,39.34,38.41,37.06,34.62,32.66,31.81,31.84,32.19,35.5,38.5,43.78,47.09,48.5,47.97,45.34,41.16,37.81,34.12,30.88,28.38,26.84,24.88,24.38,24.31,24.59,26.06,26.78,27.56,27.88,27.81,27.25,26.0,25.91,27.66,30.03,33.53,36.38,38.84,40.0,40.41,39.03,37.94,35.94,34.81,33.19,31.38,30.72,29.97,31.03,30.66,31.03,32.88,34.47,34.97,37.69,38.69,40.25,41.31,41.53,41.94,41.91,42.66,43.38,44.66,45.53,46.53,46.69,46.56,44.5,42.66,40.34,38.72,37.69,37.94,40.16,43.03,45.09,47.03,48.38,47.59,47.41,47.19,45.16,44.69,44.0,42.62,41.31,39.94,39.16,38.06,36.22,35.47,34.44,33.53,33.06,33.31,34.72,35.19,37.94,38.5,38.88,39.56,40.06,40.78,40.44,40.38,39.78,38.34,37.0,35.62,35.12,35.84,36.5,37.03,37.53,37.34,36.25,35.06,33.84,32.94,32.25,30.94,29.41,28.47,27.03,26.25,25.44,24.09,23.81,22.19,20.75,20.31,20.06,20.03,19.91,21.66,22.0,23.12,23.84,24.25,26.31,27.34,28.66,29.31,29.38,28.12,26.38,25.41,24.94,25.0,24.97,24.06,22.0,20.31,18.81,17.06,16.97,17.47,18.34,20.0,21.59,24.34,26.75,29.81,32.19,33.47,34.16,33.41,32.41,29.5,26.41,24.59,22.81,20.84,19.31,19.16,17.56,18.0,18.62,19.12,19.78,19.28,18.84,17.22,16.09,16.69,16.72,17.25,18.25,18.88,19.09,19.94,18.84,18.75,18.06,17.91,17.75,17.91,18.59,19.44,19.97,19.78,19.31,18.59,17.66,16.75,15.53,14.31,13.75,13.66,14.28,14.38,15.41,16.03,14.94,13.62,11.72,10.19,8.53,9.03,9.25,10.78,13.34,15.16,16.44,18.41,19.47,19.81,20.31,19.94,19.53,18.31,18.38,18.5,18.59,20.66,22.62,25.25,26.94,28.38,28.53,28.66,26.75,25.72,25.41,25.28,25.06,24.94,24.66,23.41,21.78,20.16,18.81,19.06,20.56,24.56,29.25,34.19,38.72,42.31,43.28,43.03,40.91,38.25,33.94,31.5,27.66,24.41,22.5,20.97,18.97,17.28,16.91,16.06,16.91,17.75,20.75,23.62,25.94,28.78,30.56,30.41,30.41,29.66,29.19,28.0,28.66,28.69,28.53,27.91,26.5,23.91,22.91,20.03,18.5,16.0,13.88,12.31,10.06,9.34,8.81,8.31,8.69,8.81,8.97,10.62,12.12,13.75,14.97,16.44,17.44,17.69,19.09,20.41,21.84,23.19,23.94,22.91,22.12,21.34,19.47,18.56,17.94,17.56,16.59,16.0,15.06,14.22,15.03,16.19,18.16,20.91,23.75,26.34,27.88,29.22,29.56,29.41,28.94,27.94,26.66,26.53,25.84,25.19,23.88,21.97,20.28,18.16,17.25,17.03,16.91,18.31,19.72,20.62,20.78,21.41,20.88,20.88,21.0,21.44,22.62,23.06,23.38,21.81,21.16,19.31,16.84,14.25,11.47,9.31,6.78,6.06,6.25,7.19,9.47,10.91,12.62,14.12,15.09,16.88,17.69,18.88,20.44,21.19,23.31,24.69,26.34,27.88,30.03,30.41,30.66,30.5,29.56,28.25,27.38,26.25,24.59,22.69,20.94,18.88,16.41,15.12,13.81,13.09,12.62,13.88,14.88,17.59,20.19,23.19,26.19,28.0,28.66,27.53,25.81,23.12,19.56,17.47,15.56,14.28,14.19,13.94,14.0,14.09,14.91,14.84,15.12,15.12,13.81,13.44,12.81,13.75,15.25,17.84,20.12,22.97,24.56,25.53,26.25,26.25,24.88,23.69,21.47,19.12,16.94,15.19,14.34,13.75,14.78,14.38,14.81,14.84,14.47,13.97,13.75,13.56,13.62,14.47,16.12,16.62,18.72,20.09,20.69,20.94,21.06,20.47,21.03,21.44,21.84,21.53,21.88,21.66,21.47,20.69,20.19,18.75,17.81,16.34,14.69,14.66,14.69,15.62,16.81,18.56,21.0,22.31,23.56,24.31,23.69,22.53,20.59,18.53,16.69,14.88,14.91,13.91,15.59,16.72,17.78,19.31,20.44,20.25,20.56,20.09,20.5,19.44,18.69,18.78,17.31,16.16,15.88,15.25,15.44,16.44,17.62,19.25,20.69,22.34,22.62,21.12,18.91,15.19,10.28,6.5,2.94,1.19,-0.22,-0.72,0.5,14.44,13.72,12.53,12.25,12.12,12.03,11.41,10.78,8.81,7.25,4.22,2.41,0.5,-0.16,0.75,2.19,5.75,8.69:22.66,23.0,24.09,25.34,27.81,29.28,31.66,33.53,33.91,33.66,32.16,29.16,27.28,27.03,25.59,27.12,28.06,28.62,29.66,29.97,31.75,32.78,33.56,36.22,37.0,37.78,38.97,37.53,36.47,35.06,32.75,33.44,32.66,31.41,30.56,30.91,31.06,30.28,31.66,31.19,30.62,29.97,29.81,29.19,30.03,30.72,32.62,34.0,35.41,36.25,35.53,34.59,30.78,27.91,25.16,22.62,21.31,21.53,23.31,25.25,28.75,30.66,32.03,32.69,31.34,30.0,27.44,25.28,23.53,22.25,20.88,20.75,20.94,21.03,21.0,21.0,19.81,20.16,19.62,18.88,19.53,19.19,19.56,20.22,20.69,23.03,25.81,28.12,29.38,30.62,30.53,28.81,27.75,26.41,25.66,25.28,27.56,29.75,34.06,38.94,43.0,46.84,47.69,47.66,44.03,40.12,35.62,31.47,29.34,29.91,30.5,33.0,33.53,35.25,34.78,34.25,32.53,30.81,29.59,28.31,26.78,26.0,25.38,25.25,25.88,26.81,27.66,28.69,30.91,31.12,32.53,34.53,36.53,38.66,40.41,42.69,42.81,42.16,41.88,38.31,35.56,32.5,29.81,28.88,26.88,26.59,25.88,25.75,25.81,26.75,27.81,30.25,32.66,35.34,37.41,40.09,42.38,43.53,43.97,44.44,43.78,42.28,40.59,39.03,37.84,38.16,37.94,39.28,40.84,42.31,41.31,41.12,39.81,39.12,38.72,37.16,36.69,35.47,35.44,37.34,40.03,43.5,48.03,50.41,51.66,51.81,50.06,47.19,44.81,42.91,40.0,39.16,37.62,36.75,36.34,35.06,34.94,34.75,33.62,33.53,33.78,34.41,34.81,34.88,35.31,36.16,37.81,38.69,41.03,42.41,41.41,40.12,36.62,33.09,30.97,30.12,29.62,29.34,28.59,25.41,23.66,19.97,17.53,16.56,16.59,17.56,18.69,21.22,23.16,26.44,29.0,31.88,34.31,36.91,38.16,38.47,38.81,38.41,38.03,37.81,38.22,38.31,37.0,36.78,33.78,31.44,28.75,26.75,26.12,24.81,26.09,26.38,28.31,30.03,31.56,31.66,34.22,35.16,36.94,38.84,39.06,39.69,39.03,37.44,36.81,36.03,35.44,33.81,32.31,30.53,28.75,28.28,28.16,29.06,30.31,31.56,33.31,34.31,34.66,35.19,34.41,35.28,34.81,36.06,37.62,40.09,41.12,42.19,42.34,42.09,41.84,41.03,39.75,39.12,38.12,36.69,35.31,35.16,33.53,33.28,32.12,31.78,32.16,32.44,34.41,36.66,37.84,39.84,41.91,42.31,43.34,44.81,45.34,45.84,45.19,43.91,42.53,41.06,40.28,38.59,38.56,39.34,39.41,40.28,40.91,41.34,42.16,40.88,39.94,37.91,36.44,34.19,33.22,32.25,32.75,33.72,34.75,37.0,38.5,39.06,40.91,41.34,40.53,39.34,38.41,37.06,34.62,32.66,31.81,31.84,32.19,35.5,38.5,43.78,47.09,48.5,47.97,45.34,41.16,37.81,34.12,30.88,28.38,26.84,24.88,24.38,24.31,24.59,26.06,26.78,27.56,27.88,27.81,27.25,26.0,25.91,27.66,30.03,33.53,36.38,38.84,40.0,40.41,39.03,37.94,35.94,34.81,33.19,31.38,30.72,29.97,31.03,30.66,31.03,32.88,34.47,34.97,37.69,38.69,40.25,41.31,41.53,41.94,41.91,42.66,43.38,44.66,45.53,46.53,46.69,46.56,44.5,42.66,40.34,38.72,37.69,37.94,40.16,43.03,45.09,47.03,48.38,47.59,47.41,47.19,45.16,44.69,44.0,42.62,41.31,39.94,39.16,38.06,36.22,35.47,34.44,33.53,33.06,33.31,34.72,35.19,37.94,38.5,38.88,39.56,40.06,40.78,40.44,40.38,39.78,38.34,37.0,35.62,35.12,35.84,36.5,37.03,37.53,37.34,36.25,35.06,33.84,32.94,32.25,30.94,29.41,28.47,27.03,26.25,25.44,24.09,23.81,22.19,20.75,20.31,20.06,20.03,19.91,21.66,22.0,23.12,23.84,24.25,26.31,27.34,28.66,29.31,29.38,28.12,26.38,25.41,24.94,25.0,24.97,24.06,22.0,20.31,18.81,17.06,16.97,17.47,18.34,20.0,21.59,24.34,26.75,29.81,32.19,33.47,34.16,33.41,32.41,29.5,26.41,24.59,22.81,20.84,19.31,19.16,17.56,18.0,18.62,19.12,19.78,19.28,18.84,17.22,16.09,16.69,16.72,17.25,18.25,18.88,19.09,19.94,18.84,18.75,18.06,17.91,17.75,17.91,18.59,19.44,19.97,19.78,19.31,18.59,17.66,16.75,15.53,14.31,13.75,13.66,14.28,14.38,15.41,16.03,14.94,13.62,11.72,10.19,8.53,9.03,9.25,10.78,13.34,15.16,16.44,18.41,19.47,19.81,20.31,19.94,19.53,18.31,18.38,18.5,18.59,20.66,22.62,25.25,26.94,28.38,28.53,28.66,26.75,25.72,25.41,25.28,25.06,24.94,24.66,23.41,21.78,20.16,18.81,19.06,20.56,24.56,29.25,34.19,38.72,42.31,43.28,43.03,40.91,38.25,33.94,31.5,27.66,24.41,22.5,20.97,18.97,17.28,16.91,16.06,16.91,17.75,20.75,23.62,25.94,28.78,30.56,30.41,30.41,29.66,29.19,28.0,28.66,28.69,28.53,27.91,26.5,23.91,22.91,20.03,18.5,16.0,13.88,12.31,10.06,9.34,8.81,8.31,8.69,8.81,8.97,10.62,12.12,13.75,14.97,16.44,17.44,17.69,19.09,20.41,21.84,23.19,23.94,22.91,22.12,21.34,19.47,18.56,17.94,17.56,16.59,16.0,15.06,14.22,15.03,16.19,18.16,20.91,23.75,26.34,27.88,29.22,29.56,29.41,28.94,27.94,26.66,26.53,25.84,25.19,23.88,21.97,20.28,18.16,17.25,17.03,16.91,18.31,19.72,20.62,20.78,21.41,20.88,20.88,21.0,21.44,22.62,23.06,23.38,21.81,21.16,19.31,16.84,14.25,11.47,9.31,6.78,6.06,6.25,7.19,9.47,10.91,12.62,14.12,15.09,16.88,17.69,18.88,20.44,21.19,23.31,24.69,26.34,27.88,30.03,30.41,30.66,30.5,29.56,28.25,27.38,26.25,24.59,22.69,20.94,18.88,16.41,15.12,13.81,13.09,12.62,13.88,14.88,17.59,20.19,23.19,26.19,28.0,28.66,27.53,25.81,23.12,19.56,17.47,15.56,14.28,14.19,13.94,14.0,14.09,14.91,14.84,15.12,15.12,13.81,13.44,12.81,13.75,15.25,17.84,20.12,22.97,24.56,25.53,26.25,26.25,24.88,23.69,21.47,19.12,16.94,15.19,14.34,13.75,14.78,14.38,14.81,14.84,14.47,13.97,13.75,13.56,13.62,14.47,16.12,16.62,18.72,20.09,20.69,20.94,21.06,20.47,21.03,21.44,21.84,21.53,21.88,21.66,21.47,20.69,20.19,18.75,17.81,16.34,14.69,14.66,14.69,15.62,16.81,18.56,21.0,22.31,23.56,24.31,23.69,22.53,20.59,18.53,16.69,14.88,14.91,13.91,15.59,16.72,17.78,19.31,20.44,20.25,20.56,20.09,20.5,19.44,18.69,18.78,17.31,16.16,15.88,15.25,15.44,16.44,17.62,19.25,20.69,22.34,22.62,21.12,18.91,15.19,10.28,6.5,2.94,1.19,-0.22,-0.72,0.5,14.44,13.72,12.53,12.25,12.12,12.03,11.41,10.78,8.81,7.25,4.22,2.41,0.5,-0.16,0.75,2.19,5.75,8.69,11.53,14.41,16.56,17.41,17.91,17.31:31.66,33.53,33.91,33.66,32.16,29.16,27.28,27.03,25.59,27.12,28.06,28.62,29.66,29.97,31.75,32.78,33.56,36.22,37.0,37.78,38.97,37.53,36.47,35.06,32.75,33.44,32.66,31.41,30.56,30.91,31.06,30.28,31.66,31.19,30.62,29.97,29.81,29.19,30.03,30.72,32.62,34.0,35.41,36.25,35.53,34.59,30.78,27.91,25.16,22.62,21.31,21.53,23.31,25.25,28.75,30.66,32.03,32.69,31.34,30.0,27.44,25.28,23.53,22.25,20.88,20.75,20.94,21.03,21.0,21.0,19.81,20.16,19.62,18.88,19.53,19.19,19.56,20.22,20.69,23.03,25.81,28.12,29.38,30.62,30.53,28.81,27.75,26.41,25.66,25.28,27.56,29.75,34.06,38.94,43.0,46.84,47.69,47.66,44.03,40.12,35.62,31.47,29.34,29.91,30.5,33.0,33.53,35.25,34.78,34.25,32.53,30.81,29.59,28.31,26.78,26.0,25.38,25.25,25.88,26.81,27.66,28.69,30.91,31.12,32.53,34.53,36.53,38.66,40.41,42.69,42.81,42.16,41.88,38.31,35.56,32.5,29.81,28.88,26.88,26.59,25.88,25.75,25.81,26.75,27.81,30.25,32.66,35.34,37.41,40.09,42.38,43.53,43.97,44.44,43.78,42.28,40.59,39.03,37.84,38.16,37.94,39.28,40.84,42.31,41.31,41.12,39.81,39.12,38.72,37.16,36.69,35.47,35.44,37.34,40.03,43.5,48.03,50.41,51.66,51.81,50.06,47.19,44.81,42.91,40.0,39.16,37.62,36.75,36.34,35.06,34.94,34.75,33.62,33.53,33.78,34.41,34.81,34.88,35.31,36.16,37.81,38.69,41.03,42.41,41.41,40.12,36.62,33.09,30.97,30.12,29.62,29.34,28.59,25.41,23.66,19.97,17.53,16.56,16.59,17.56,18.69,21.22,23.16,26.44,29.0,31.88,34.31,36.91,38.16,38.47,38.81,38.41,38.03,37.81,38.22,38.31,37.0,36.78,33.78,31.44,28.75,26.75,26.12,24.81,26.09,26.38,28.31,30.03,31.56,31.66,34.22,35.16,36.94,38.84,39.06,39.69,39.03,37.44,36.81,36.03,35.44,33.81,32.31,30.53,28.75,28.28,28.16,29.06,30.31,31.56,33.31,34.31,34.66,35.19,34.41,35.28,34.81,36.06,37.62,40.09,41.12,42.19,42.34,42.09,41.84,41.03,39.75,39.12,38.12,36.69,35.31,35.16,33.53,33.28,32.12,31.78,32.16,32.44,34.41,36.66,37.84,39.84,41.91,42.31,43.34,44.81,45.34,45.84,45.19,43.91,42.53,41.06,40.28,38.59,38.56,39.34,39.41,40.28,40.91,41.34,42.16,40.88,39.94,37.91,36.44,34.19,33.22,32.25,32.75,33.72,34.75,37.0,38.5,39.06,40.91,41.34,40.53,39.34,38.41,37.06,34.62,32.66,31.81,31.84,32.19,35.5,38.5,43.78,47.09,48.5,47.97,45.34,41.16,37.81,34.12,30.88,28.38,26.84,24.88,24.38,24.31,24.59,26.06,26.78,27.56,27.88,27.81,27.25,26.0,25.91,27.66,30.03,33.53,36.38,38.84,40.0,40.41,39.03,37.94,35.94,34.81,33.19,31.38,30.72,29.97,31.03,30.66,31.03,32.88,34.47,34.97,37.69,38.69,40.25,41.31,41.53,41.94,41.91,42.66,43.38,44.66,45.53,46.53,46.69,46.56,44.5,42.66,40.34,38.72,37.69,37.94,40.16,43.03,45.09,47.03,48.38,47.59,47.41,47.19,45.16,44.69,44.0,42.62,41.31,39.94,39.16,38.06,36.22,35.47,34.44,33.53,33.06,33.31,34.72,35.19,37.94,38.5,38.88,39.56,40.06,40.78,40.44,40.38,39.78,38.34,37.0,35.62,35.12,35.84,36.5,37.03,37.53,37.34,36.25,35.06,33.84,32.94,32.25,30.94,29.41,28.47,27.03,26.25,25.44,24.09,23.81,22.19,20.75,20.31,20.06,20.03,19.91,21.66,22.0,23.12,23.84,24.25,26.31,27.34,28.66,29.31,29.38,28.12,26.38,25.41,24.94,25.0,24.97,24.06,22.0,20.31,18.81,17.06,16.97,17.47,18.34,20.0,21.59,24.34,26.75,29.81,32.19,33.47,34.16,33.41,32.41,29.5,26.41,24.59,22.81,20.84,19.31,19.16,17.56,18.0,18.62,19.12,19.78,19.28,18.84,17.22,16.09,16.69,16.72,17.25,18.25,18.88,19.09,19.94,18.84,18.75,18.06,17.91,17.75,17.91,18.59,19.44,19.97,19.78,19.31,18.59,17.66,16.75,15.53,14.31,13.75,13.66,14.28,14.38,15.41,16.03,14.94,13.62,11.72,10.19,8.53,9.03,9.25,10.78,13.34,15.16,16.44,18.41,19.47,19.81,20.31,19.94,19.53,18.31,18.38,18.5,18.59,20.66,22.62,25.25,26.94,28.38,28.53,28.66,26.75,25.72,25.41,25.28,25.06,24.94,24.66,23.41,21.78,20.16,18.81,19.06,20.56,24.56,29.25,34.19,38.72,42.31,43.28,43.03,40.91,38.25,33.94,31.5,27.66,24.41,22.5,20.97,18.97,17.28,16.91,16.06,16.91,17.75,20.75,23.62,25.94,28.78,30.56,30.41,30.41,29.66,29.19,28.0,28.66,28.69,28.53,27.91,26.5,23.91,22.91,20.03,18.5,16.0,13.88,12.31,10.06,9.34,8.81,8.31,8.69,8.81,8.97,10.62,12.12,13.75,14.97,16.44,17.44,17.69,19.09,20.41,21.84,23.19,23.94,22.91,22.12,21.34,19.47,18.56,17.94,17.56,16.59,16.0,15.06,14.22,15.03,16.19,18.16,20.91,23.75,26.34,27.88,29.22,29.56,29.41,28.94,27.94,26.66,26.53,25.84,25.19,23.88,21.97,20.28,18.16,17.25,17.03,16.91,18.31,19.72,20.62,20.78,21.41,20.88,20.88,21.0,21.44,22.62,23.06,23.38,21.81,21.16,19.31,16.84,14.25,11.47,9.31,6.78,6.06,6.25,7.19,9.47,10.91,12.62,14.12,15.09,16.88,17.69,18.88,20.44,21.19,23.31,24.69,26.34,27.88,30.03,30.41,30.66,30.5,29.56,28.25,27.38,26.25,24.59,22.69,20.94,18.88,16.41,15.12,13.81,13.09,12.62,13.88,14.88,17.59,20.19,23.19,26.19,28.0,28.66,27.53,25.81,23.12,19.56,17.47,15.56,14.28,14.19,13.94,14.0,14.09,14.91,14.84,15.12,15.12,13.81,13.44,12.81,13.75,15.25,17.84,20.12,22.97,24.56,25.53,26.25,26.25,24.88,23.69,21.47,19.12,16.94,15.19,14.34,13.75,14.78,14.38,14.81,14.84,14.47,13.97,13.75,13.56,13.62,14.47,16.12,16.62,18.72,20.09,20.69,20.94,21.06,20.47,21.03,21.44,21.84,21.53,21.88,21.66,21.47,20.69,20.19,18.75,17.81,16.34,14.69,14.66,14.69,15.62,16.81,18.56,21.0,22.31,23.56,24.31,23.69,22.53,20.59,18.53,16.69,14.88,14.91,13.91,15.59,16.72,17.78,19.31,20.44,20.25,20.56,20.09,20.5,19.44,18.69,18.78,17.31,16.16,15.88,15.25,15.44,16.44,17.62,19.25,20.69,22.34,22.62,21.12,18.91,15.19,10.28,6.5,2.94,1.19,-0.22,-0.72,0.5,14.44,13.72,12.53,12.25,12.12,12.03,11.41,10.78,8.81,7.25,4.22,2.41,0.5,-0.16,0.75,2.19,5.75,8.69,11.53,14.41,16.56,17.41,17.91,17.31,17.22,16.53,17.56,17.06,18.69,20.62:negativity
-7.94,-10.66,-9.41,-7.75,-5.5,-1.91,1.69,4.62,7.62,9.38,11.41,12.06,12.41,13.16,12.34,13.06,13.84,12.66,10.91,7.34,4.62,0.78,-3.19,-5.34,-8.91,-10.31,-12.12,-12.81,-12.66,-11.91,-9.94,-8.72,-7.03,-4.66,-1.53,2.0,4.09,5.5,6.53,5.66,4.81,3.09,0.84,-1.16,-3.91,-5.47,-3.84,-5.41,-2.69,-0.91,-0.66,0.56,1.75,0.88,1.56,-1.09,-3.81,-8.28,-12.44,-16.28,-20.47,-23.44,-26.22,-28.94,-30.22,-31.88,-32.84,-32.78,-32.16,-31.88,-31.41,-29.62,-25.97,-23.0,-18.03,-13.72,-10.44,-7.28,-6.44,-7.22,-8.06,-12.31,-13.66,-15.91,-16.41,-16.03,-14.19,-13.72,-12.38,-12.62,-13.75,-15.19,-15.25,-17.59,-17.84,-18.19,-18.16,-18.0,-18.09,-17.84,-17.47,-17.03,-15.56,-15.97,-15.06,-15.47,-14.59,-14.03,-13.12,-13.91,-14.47,-16.0,-18.09,-18.59,-20.16,-20.09,-19.72,-18.59,-18.12,-15.66,-14.34,-13.19,-12.66,-12.84,-12.03,-11.97,-11.19,-11.38,-11.62,-12.28,-13.09,-11.97,-13.41,-11.34,-13.03,-14.31,-15.81,-18.69,-20.62,-21.16,-22.06,-21.59,-20.34,-19.28,-16.03,-16.41,-15.41,-15.41,-16.66,-18.41,-20.91,-23.84,-27.09,-29.66,-30.59,-31.97,-32.66,-33.34,-31.81,-33.09,-33.28,-33.44,-34.69,-35.75,-35.91,-34.97,-32.88,-30.53,-27.66,-26.81,-27.41,-28.22,-30.16,-30.03,-30.53,-31.94,-31.09,-30.47,-29.31,-27.84,-25.62,-23.66,-22.59,-22.31,-22.44,-23.22,-24.75,-26.44,-26.56,-26.16,-23.41,-20.09,-17.66,-16.53,-16.88,-18.03,-19.81,-21.5,-22.88,-22.69,-23.81,-22.81,-21.16,-19.84,-19.84,-19.0,-18.53,-19.53,-19.12,-18.19,-19.53,-19.34,-18.19,-17.84,-16.25,-14.09,-9.72,-9.12,-6.84,-5.47,-6.19,-7.25,-8.97,-12.09,-14.94,-16.97,-18.72,-21.91,-22.09,-23.53,-23.19,-23.19,-22.22,-22.47,-21.12,-20.69,-19.0,-15.66,-13.72,-10.19,-8.03,-5.91,-6.47,-7.34,-9.97,-13.03,-17.09,-20.44,-23.34,-26.44,-28.34,-30.53,-31.16,-32.53,-32.09,-32.84,-31.47,-31.5,-30.34,-27.72,-25.97,-22.22,-18.69,-16.72,-13.53,-11.09,-11.03,-10.88,-11.78,-12.78,-15.88,-17.84,-20.19,-22.41,-23.34,-23.59,-23.97,-24.25,-23.44,-22.34,-21.78,-21.84,-19.59,-20.09,-20.41,-18.72,-17.22,-13.59,-8.94,-5.34,-2.34,-0.19,-0.16,-0.41,-2.16,-5.59,-9.34,-13.84,-19.06,-22.44,-24.59,-26.72,-27.97,-27.16,-28.16,-27.97,-26.56,-24.19,-22.88,-19.97,-18.09,-15.44,-14.03,-12.22,-13.69,-13.59,-15.09,-16.22,-17.31,-18.66,-19.69,-20.72,-21.91,-22.47,-22.91,-22.28,-21.5,-19.28,-15.41,-10.56,-6.66,-0.91,3.19,4.94,5.88,5.19,4.09,2.19,0.84,-1.34,-3.19,-4.69,-7.34,-10.34,-12.22,-14.25,-15.97,-16.66,-16.91,-16.16,-14.66,-12.03,-10.78,-8.59,-8.09,-7.12,-7.47,-8.03,-8.69,-9.47,-10.19,-9.69,-9.31,-8.62,-8.34,-7.66,-8.97,-10.44,-11.31,-13.0,-14.84,-16.66,-18.0,-18.88,-19.97,-19.56,-19.41,-19.53,-19.34,-18.41,-17.69,-15.56,-14.84,-11.88,-9.38,-7.84,-4.16,-2.66,-0.03,1.47,0.81,1.5,-0.03,-0.59,-3.06,-5.19,-7.44,-9.09,-8.94,-8.84,-7.78,-6.84,-6.28,-6.34,-6.66,-7.03,-7.44,-8.78,-10.16,-11.19,-12.69,-13.22,-13.62,-13.44,-13.91,-13.22,-13.47,-13.81,-13.09,-13.81,-14.78,-16.12,-17.72,-20.03,-22.75,-24.34,-26.31,-27.34,-27.72,-28.91,-28.69,-28.22,-26.97,-24.84,-22.59,-19.47,-16.41,-13.44,-12.09,-11.22,-10.66,-10.34,-11.66,-12.31,-14.16,-14.84,-16.94,-17.44,-18.88,-19.69,-19.19,-19.59,-20.75,-20.94,-21.53,-22.16,-21.28,-20.34,-19.31,-17.12,-15.41,-15.22,-14.59,-15.84,-18.69,-20.81,-23.38,-25.72,-26.72,-26.69,-26.81,-26.88,-25.97,-26.47,-26.34,-27.16,-28.03,-29.59,-30.41,-31.03,-31.72,-32.47,-33.44,-34.5,-34.59,-35.38,-35.09,-34.41,-32.84,-30.38,-28.47,-24.53,-23.41,-19.69,-17.47,-16.69,-15.94,-15.97,-15.94,-16.81,-16.53,-17.84,-16.53,-17.72,-17.91,-19.06,-19.72,-21.84,-22.56,-23.62,-24.34,-24.97,-25.44,-25.62,-25.0,-23.91,-23.94,-21.69,-20.41,-20.5,-20.03,-20.03,-20.25,-21.69,-22.28,-22.53,-22.84,-23.09,-22.31,-21.59,-20.44,-19.41,-18.44,-17.53,-17.94,-19.59,-21.25,-21.84,-23.59,-24.09,-23.06,-21.28,-21.66,-21.06,-20.34,-20.38,-19.47,-17.81,-16.09,-14.34,-12.91,-12.44,-12.12,-12.66,-13.69,-15.53,-19.34,-23.91,-27.28,-30.34,-31.16,-29.47,-27.25,-24.41,-20.59,-18.22,-15.56,-14.31,-13.09,-13.72,-14.78,-14.78,-14.34,-14.16,-13.53,-12.34,-12.94,-13.38,-14.03,-14.84,-15.72,-15.91,-14.84,-12.84,-10.41,-6.72,-4.81,-4.38,-4.97,-8.56,-12.28,-17.53,-19.88,-22.84,-22.97,-22.47,-21.59,-20.41,-17.84,-16.12,-13.72,-12.34,-11.44,-10.72,-10.53,-10.72,-10.94,-11.28,-10.38,-10.47,-10.47,-10.47,-9.97,-10.59,-10.19,-11.47,-12.53,-11.62,-11.84,-10.62,-9.94,-7.56,-4.38,-1.84,0.44,4.41,5.28,5.31,3.81,2.0,0.19,-1.94,-1.78,-1.09,1.03,2.28,5.0,6.34,6.47,6.06,5.31,3.88,0.97,0.34,-1.28,-1.22,0.22,0.97,1.91,2.66,3.25,3.78,4.41,5.56,6.94,7.72,8.38,8.84,9.69,9.94,11.44,13.09,12.16,11.53,9.38,6.5,3.28,0.34,-1.75,-3.09,-4.53,-4.53,-3.91,-3.22,-2.22,-2.09,-1.88,-2.66,-3.03,-2.38,-2.47,-2.12,-1.94,-2.34,-2.88,-3.81,-5.31,-7.59,-9.34,-10.91,-12.78,-13.41,-14.16,-12.69,-10.94,-9.22,-6.84,-5.12,-3.94,-4.41,-4.84,-5.0,-3.75,-3.38,-2.44,-1.97,-2.38,-3.72,-4.28,-4.91,-5.88,-5.91,-6.19,-5.22,-5.06,-4.28,-4.22,-4.47,-5.88,-8.69,-10.34,-11.12,-11.66,-11.41,-9.84,-9.53,-9.22,-7.94,-8.31,-7.59,-8.12,-8.41,-9.66,-8.84,-7.78,-6.06,-3.06,-1.41,0.16,-2.66,-4.03,-5.97,-7.66,-9.66,-9.41,-9.41,-9.31,-9.5,-9.66,-9.91,-10.22,-10.81,-10.62,-10.31,-9.22,-8.78,-8.41,-7.41,-6.94,-6.19,-5.5,-3.88,-3.91,-3.31,-2.56,-2.25,-1.41,-0.41,1.91,4.5,6.66,9.16,9.0,9.66,8.75,6.66,6.0,3.75,3.16,0.91,-0.53,-0.03,-1.31,0.94,3.12,4.25,5.75,6.03,6.0,5.19,4.53,4.09,4.47,5.75,6.47,9.03,9.84,10.72,10.31,9.72,7.41,4.91,2.66,0.41,-1.75,-3.66,-3.25,-2.16,-1.62,-0.56,1.44,1.19,2.44,2.81,3.66,4.69,6.31,8.44,8.34,9.66,9.59,7.56,5.66,4.53,2.25,1.56,1.91,2.03,2.0,1.66,1.41,1.41,2.16,1.88,2.03,4.44,6.62,9.94,15.25,20.78,25.97,29.72,31.19,30.09,28.19,26.44,23.41,22.56,21.12,18.88,17.72,13.53,10.72,7.5,5.81,4.62,4.06,4.03,5.41,5.66,8.41,11.78,16.31,20.88,26.06,29.25,30.72,30.84,30.81,29.0,27.19,24.0,21.22,17.81,15.66,13.06,12.12,11.66,10.66,10.09,9.22,8.06,7.16,6.91,5.81,5.97,6.41,8.19,9.31,10.66,12.47,14.0,15.06,16.62,16.09,16.47:1.69,4.62,7.62,9.38,11.41,12.06,12.41,13.16,12.34,13.06,13.84,12.66,10.91,7.34,4.62,0.78,-3.19,-5.34,-8.91,-10.31,-12.12,-12.81,-12.66,-11.91,-9.94,-8.72,-7.03,-4.66,-1.53,2.0,4.09,5.5,6.53,5.66,4.81,3.09,0.84,-1.16,-3.91,-5.47,-3.84,-5.41,-2.69,-0.91,-0.66,0.56,1.75,0.88,1.56,-1.09,-3.81,-8.28,-12.44,-16.28,-20.47,-23.44,-26.22,-28.94,-30.22,-31.88,-32.84,-32.78,-32.16,-31.88,-31.41,-29.62,-25.97,-23.0,-18.03,-13.72,-10.44,-7.28,-6.44,-7.22,-8.06,-12.31,-13.66,-15.91,-16.41,-16.03,-14.19,-13.72,-12.38,-12.62,-13.75,-15.19,-15.25,-17.59,-17.84,-18.19,-18.16,-18.0,-18.09,-17.84,-17.47,-17.03,-15.56,-15.97,-15.06,-15.47,-14.59,-14.03,-13.12,-13.91,-14.47,-16.0,-18.09,-18.59,-20.16,-20.09,-19.72,-18.59,-18.12,-15.66,-14.34,-13.19,-12.66,-12.84,-12.03,-11.97,-11.19,-11.38,-11.62,-12.28,-13.09,-11.97,-13.41,-11.34,-13.03,-14.31,-15.81,-18.69,-20.62,-21.16,-22.06,-21.59,-20.34,-19.28,-16.03,-16.41,-15.41,-15.41,-16.66,-18.41,-20.91,-23.84,-27.09,-29.66,-30.59,-31.97,-32.66,-33.34,-31.81,-33.09,-33.28,-33.44,-34.69,-35.75,-35.91,-34.97,-32.88,-30.53,-27.66,-26.81,-27.41,-28.22,-30.16,-30.03,-30.53,-31.94,-31.09,-30.47,-29.31,-27.84,-25.62,-23.66,-22.59,-22.31,-22.44,-23.22,-24.75,-26.44,-26.56,-26.16,-23.41,-20.09,-17.66,-16.53,-16.88,-18.03,-19.81,-21.5,-22.88,-22.69,-23.81,-22.81,-21.16,-19.84,-19.84,-19.0,-18.53,-19.53,-19.12,-18.19,-19.53,-19.34,-18.19,-17.84,-16.25,-14.09,-9.72,-9.12,-6.84,-5.47,-6.19,-7.25,-8.97,-12.09,-14.94,-16.97,-18.72,-21.91,-22.09,-23.53,-23.19,-23.19,-22.22,-22.47,-21.12,-20.69,-19.0,-15.66,-13.72,-10.19,-8.03,-5.91,-6.47,-7.34,-9.97,-13.03,-17.09,-20.44,-23.34,-26.44,-28.34,-30.53,-31.16,-32.53,-32.09,-32.84,-31.47,-31.5,-30.34,-27.72,-25.97,-22.22,-18.69,-16.72,-13.53,-11.09,-11.03,-10.88,-11.78,-12.78,-15.88,-17.84,-20.19,-22.41,-23.34,-23.59,-23.97,-24.25,-23.44,-22.34,-21.78,-21.84,-19.59,-20.09,-20.41,-18.72,-17.22,-13.59,-8.94,-5.34,-2.34,-0.19,-0.16,-0.41,-2.16,-5.59,-9.34,-13.84,-19.06,-22.44,-24.59,-26.72,-27.97,-27.16,-28.16,-27.97,-26.56,-24.19,-22.88,-19.97,-18.09,-15.44,-14.03,-12.22,-13.69,-13.59,-15.09,-16.22,-17.31,-18.66,-19.69,-20.72,-21.91,-22.47,-22.91,-22.28,-21.5,-19.28,-15.41,-10.56,-6.66,-0.91,3.19,4.94,5.88,5.19,4.09,2.19,0.84,-1.34,-3.19,-4.69,-7.34,-10.34,-12.22,-14.25,-15.97,-16.66,-16.91,-16.16,-14.66,-12.03,-10.78,-8.59,-8.09,-7.12,-7.47,-8.03,-8.69,-9.47,-10.19,-9.69,-9.31,-8.62,-8.34,-7.66,-8.97,-10.44,-11.31,-13.0,-14.84,-16.66,-18.0,-18.88,-19.97,-19.56,-19.41,-19.53,-19.34,-18.41,-17.69,-15.56,-14.84,-11.88,-9.38,-7.84,-4.16,-2.66,-0.03,1.47,0.81,1.5,-0.03,-0.59,-3.06,-5.19,-7.44,-9.09,-8.94,-8.84,-7.78,-6.84,-6.28,-6.34,-6.66,-7.03,-7.44,-8.78,-10.16,-11.19,-12.69,-13.22,-13.62,-13.44,-13.91,-13.22,-13.47,-13.81,-13.09,-13.81,-14.78,-16.12,-17.72,-20.03,-22.75,-24.34,-26.31,-27.34,-27.72,-28.91,-28.69,-28.22,-26.97,-24.84,-22.59,-19.47,-16.41,-13.44,-12.09,-11.22,-10.66,-10.34,-11.66,-12.31,-14.16,-14.84,-16.94,-17.44,-18.88,-19.69,-19.19,-19.59,-20.75,-20.94,-21.53,-22.16,-21.28,-20.34,-19.31,-17.12,-15.41,-15.22,-14.59,-15.84,-18.69,-20.81,-23.38,-25.72,-26.72,-26.69,-26.81,-26.88,-25.97,-26.47,-26.34,-27.16,-28.03,-29.59,-30.41,-31.03,-31.72,-32.47,-33.44,-34.5,-34.59,-35.38,-35.09,-34.41,-32.84,-30.38,-28.47,-24.53,-23.41,-19.69,-17.47,-16.69,-15.94,-15.97,-15.94,-16.81,-16.53,-17.84,-16.53,-17.72,-17.91,-19.06,-19.72,-21.84,-22.56,-23.62,-24.34,-24.97,-25.44,-25.62,-25.0,-23.91,-23.94,-21.69,-20.41,-20.5,-20.03,-20.03,-20.25,-21.69,-22.28,-22.53,-22.84,-23.09,-22.31,-21.59,-20.44,-19.41,-18.44,-17.53,-17.94,-19.59,-21.25,-21.84,-23.59,-24.09,-23.06,-21.28,-21.66,-21.06,-20.34,-20.38,-19.47,-17.81,-16.09,-14.34,-12.91,-12.44,-12.12,-12.66,-13.69,-15.53,-19.34,-23.91,-27.28,-30.34,-31.16,-29.47,-27.25,-24.41,-20.59,-18.22,-15.56,-14.31,-13.09,-13.72,-14.78,-14.78,-14.34,-14.16,-13.53,-12.34,-12.94,-13.38,-14.03,-14.84,-15.72,-15.91,-14.84,-12.84,-10.41,-6.72,-4.81,-4.38,-4.97,-8.56,-12.28,-17.53,-19.88,-22.84,-22.97,-22.47,-21.59,-20.41,-17.84,-16.12,-13.72,-12.34,-11.44,-10.72,-10.53,-10.72,-10.94,-11.28,-10.38,-10.47,-10.47,-10.47,-9.97,-10.59,-10.19,-11.47,-12.53,-11.62,-11.84,-10.62,-9.94,-7.56,-4.38,-1.84,0.44,4.41,5.28,5.31,3.81,2.0,0.19,-1.94,-1.78,-1.09,1.03,2.28,5.0,6.34,6.47,6.06,5.31,3.88,0.97,0.34,-1.28,-1.22,0.22,0.97,1.91,2.66,3.25,3.78,4.41,5.56,6.94,7.72,8.38,8.84,9.69,9.94,11.44,13.09,12.16,11.53,9.38,6.5,3.28,0.34,-1.75,-3.09,-4.53,-4.53,-3.91,-3.22,-2.22,-2.09,-1.88,-2.66,-3.03,-2.38,-2.47,-2.12,-1.94,-2.34,-2.88,-3.81,-5.31,-7.59,-9.34,-10.91,-12.78,-13.41,-14.16,-12.69,-10.94,-9.22,-6.84,-5.12,-3.94,-4.41,-4.84,-5.0,-3.75,-3.38,-2.44,-1.97,-2.38,-3.72,-4.28,-4.91,-5.88,-5.91,-6.19,-5.22,-5.06,-4.28,-4.22,-4.47,-5.88,-8.69,-10.34,-11.12,-11.66,-11.41,-9.84,-9.53,-9.22,-7.94,-8.31,-7.59,-8.12,-8.41,-9.66,-8.84,-7.78,-6.06,-3.06,-1.41,0.16,-2.66,-4.03,-5.97,-7.66,-9.66,-9.41,-9.41,-9.31,-9.5,-9.66,-9.91,-10.22,-10.81,-10.62,-10.31,-9.22,-8.78,-8.41,-7.41,-6.94,-6.19,-5.5,-3.88,-3.91,-3.31,-2.56,-2.25,-1.41,-0.41,1.91,4.5,6.66,9.16,9.0,9.66,8.75,6.66,6.0,3.75,3.16,0.91,-0.53,-0.03,-1.31,0.94,3.12,4.25,5.75,6.03,6.0,5.19,4.53,4.09,4.47,5.75,6.47,9.03,9.84,10.72,10.31,9.72,7.41,4.91,2.66,0.41,-1.75,-3.66,-3.25,-2.16,-1.62,-0.56,1.44,1.19,2.44,2.81,3.66,4.69,6.31,8.44,8.34,9.66,9.59,7.56,5.66,4.53,2.25,1.56,1.91,2.03,2.0,1.66,1.41,1.41,2.16,1.88,2.03,4.44,6.62,9.94,15.25,20.78,25.97,29.72,31.19,30.09,28.19,26.44,23.41,22.56,21.12,18.88,17.72,13.53,10.72,7.5,5.81,4.62,4.06,4.03,5.41,5.66,8.41,11.78,16.31,20.88,26.06,29.25,30.72,30.84,30.81,29.0,27.19,24.0,21.22,17.81,15.66,13.06,12.12,11.66,10.66,10.09,9.22,8.06,7.16,6.91,5.81,5.97,6.41,8.19,9.31,10.66,12.47,14.0,15.06,16.62,16.09,16.47,-17.34,-20.41,-20.97,-19.94,-17.59,-14.5:12.41,13.16,12.34,13.06,13.84,12.66,10.91,7.34,4.62,0.78,-3.19,-5.34,-8.91,-10.31,-12.12,-12.81,-12.66,-11.91,-9.94,-8.72,-7.03,-4.66,-1.53,2.0,4.09,5.5,6.53,5.66,4.81,3.09,0.84,-1.16,-3.91,-5.47,-3.84,-5.41,-2.69,-0.91,-0.66,0.56,1.75,0.88,1.56,-1.09,-3.81,-8.28,-12.44,-16.28,-20.47,-23.44,-26.22,-28.94,-30.22,-31.88,-32.84,-32.78,-32.16,-31.88,-31.41,-29.62,-25.97,-23.0,-18.03,-13.72,-10.44,-7.28,-6.44,-7.22,-8.06,-12.31,-13.66,-15.91,-16.41,-16.03,-14.19,-13.72,-12.38,-12.62,-13.75,-15.19,-15.25,-17.59,-17.84,-18.19,-18.16,-18.0,-18.09,-17.84,-17.47,-17.03,-15.56,-15.97,-15.06,-15.47,-14.59,-14.03,-13.12,-13.91,-14.47,-16.0,-18.09,-18.59,-20.16,-20.09,-19.72,-18.59,-18.12,-15.66,-14.34,-13.19,-12.66,-12.84,-12.03,-11.97,-11.19,-11.38,-11.62,-12.28,-13.09,-11.97,-13.41,-11.34,-13.03,-14.31,-15.81,-18.69,-20.62,-21.16,-22.06,-21.59,-20.34,-19.28,-16.03,-16.41,-15.41,-15.41,-16.66,-18.41,-20.91,-23.84,-27.09,-29.66,-30.59,-31.97,-32.66,-33.34,-31.81,-33.09,-33.28,-33.44,-34.69,-35.75,-35.91,-34.97,-32.88,-30.53,-27.66,-26.81,-27.41,-28.22,-30.16,-30.03,-30.53,-31.94,-31.09,-30.47,-29.31,-27.84,-25.62,-23.66,-22.59,-22.31,-22.44,-23.22,-24.75,-26.44,-26.56,-26.16,-23.41,-20.09,-17.66,-16.53,-16.88,-18.03,-19.81,-21.5,-22.88,-22.69,-23.81,-22.81,-21.16,-19.84,-19.84,-19.0,-18.53,-19.53,-19.12,-18.19,-19.53,-19.34,-18.19,-17.84,-16.25,-14.09,-9.72,-9.12,-6.84,-5.47,-6.19,-7.25,-8.97,-12.09,-14.94,-16.97,-18.72,-21.91,-22.09,-23.53,-23.19,-23.19,-22.22,-22.47,-21.12,-20.69,-19.0,-15.66,-13.72,-10.19,-8.03,-5.91,-6.47,-7.34,-9.97,-13.03,-17.09,-20.44,-23.34,-26.44,-28.34,-30.53,-31.16,-32.53,-32.09,-32.84,-31.47,-31.5,-30.34,-27.72,-25.97,-22.22,-18.69,-16.72,-13.53,-11.09,-11.03,-10.88,-11.78,-12.78,-15.88,-17.84,-20.19,-22.41,-23.34,-23.59,-23.97,-24.25,-23.44,-22.34,-21.78,-21.84,-19.59,-20.09,-20.41,-18.72,-17.22,-13.59,-8.94,-5.34,-2.34,-0.19,-0.16,-0.41,-2.16,-5.59,-9.34,-13.84,-19.06,-22.44,-24.59,-26.72,-27.97,-27.16,-28.16,-27.97,-26.56,-24.19,-22.88,-19.97,-18.09,-15.44,-14.03,-12.22,-13.69,-13.59,-15.09,-16.22,-17.31,-18.66,-19.69,-20.72,-21.91,-22.47,-22.91,-22.28,-21.5,-19.28,-15.41,-10.56,-6.66,-0.91,3.19,4.94,5.88,5.19,4.09,2.19,0.84,-1.34,-3.19,-4.69,-7.34,-10.34,-12.22,-14.25,-15.97,-16.66,-16.91,-16.16,-14.66,-12.03,-10.78,-8.59,-8.09,-7.12,-7.47,-8.03,-8.69,-9.47,-10.19,-9.69,-9.31,-8.62,-8.34,-7.66,-8.97,-10.44,-11.31,-13.0,-14.84,-16.66,-18.0,-18.88,-19.97,-19.56,-19.41,-19.53,-19.34,-18.41,-17.69,-15.56,-14.84,-11.88,-9.38,-7.84,-4.16,-2.66,-0.03,1.47,0.81,1.5,-0.03,-0.59,-3.06,-5.19,-7.44,-9.09,-8.94,-8.84,-7.78,-6.84,-6.28,-6.34,-6.66,-7.03,-7.44,-8.78,-10.16,-11.19,-12.69,-13.22,-13.62,-13.44,-13.91,-13.22,-13.47,-13.81,-13.09,-13.81,-14.78,-16.12,-17.72,-20.03,-22.75,-24.34,-26.31,-27.34,-27.72,-28.91,-28.69,-28.22,-26.97,-24.84,-22.59,-19.47,-16.41,-13.44,-12.09,-11.22,-10.66,-10.34,-11.66,-12.31,-14.16,-14.84,-16.94,-17.44,-18.88,-19.69,-19.19,-19.59,-20.75,-20.94,-21.53,-22.16,-21.28,-20.34,-19.31,-17.12,-15.41,-15.22,-14.59,-15.84,-18.69,-20.81,-23.38,-25.72,-26.72,-26.69,-26.81,-26.88,-25.97,-26.47,-26.34,-27.16,-28.03,-29.59,-30.41,-31.03,-31.72,-32.47,-33.44,-34.5,-34.59,-35.38,-35.09,-34.41,-32.84,-30.38,-28.47,-24.53,-23.41,-19.69,-17.47,-16.69,-15.94,-15.97,-15.94,-16.81,-16.53,-17.84,-16.53,-17.72,-17.91,-19.06,-19.72,-21.84,-22.56,-23.62,-24.34,-24.97,-25.44,-25.62,-25.0,-23.91,-23.94,-21.69,-20.41,-20.5,-20.03,-20.03,-20.25,-21.69,-22.28,-22.53,-22.84,-23.09,-22.31,-21.59,-20.44,-19.41,-18.44,-17.53,-17.94,-19.59,-21.25,-21.84,-23.59,-24.09,-23.06,-21.28,-21.66,-21.06,-20.34,-20.38,-19.47,-17.81,-16.09,-14.34,-12.91,-12.44,-12.12,-12.66,-13.69,-15.53,-19.34,-23.91,-27.28,-30.34,-31.16,-29.47,-27.25,-24.41,-20.59,-18.22,-15.56,-14.31,-13.09,-13.72,-14.78,-14.78,-14.34,-14.16,-13.53,-12.34,-12.94,-13.38,-14.03,-14.84,-15.72,-15.91,-14.84,-12.84,-10.41,-6.72,-4.81,-4.38,-4.97,-8.56,-12.28,-17.53,-19.88,-22.84,-22.97,-22.47,-21.59,-20.41,-17.84,-16.12,-13.72,-12.34,-11.44,-10.72,-10.53,-10.72,-10.94,-11.28,-10.38,-10.47,-10.47,-10.47,-9.97,-10.59,-10.19,-11.47,-12.53,-11.62,-11.84,-10.62,-9.94,-7.56,-4.38,-1.84,0.44,4.41,5.28,5.31,3.81,2.0,0.19,-1.94,-1.78,-1.09,1.03,2.28,5.0,6.34,6.47,6.06,5.31,3.88,0.97,0.34,-1.28,-1.22,0.22,0.97,1.91,2.66,3.25,3.78,4.41,5.56,6.94,7.72,8.38,8.84,9.69,9.94,11.44,13.09,12.16,11.53,9.38,6.5,3.28,0.34,-1.75,-3.09,-4.53,-4.53,-3.91,-3.22,-2.22,-2.09,-1.88,-2.66,-3.03,-2.38,-2.47,-2.12,-1.94,-2.34,-2.88,-3.81,-5.31,-7.59,-9.34,-10.91,-12.78,-13.41,-14.16,-12.69,-10.94,-9.22,-6.84,-5.12,-3.94,-4.41,-4.84,-5.0,-3.75,-3.38,-2.44,-1.97,-2.38,-3.72,-4.28,-4.91,-5.88,-5.91,-6.19,-5.22,-5.06,-4.28,-4.22,-4.47,-5.88,-8.69,-10.34,-11.12,-11.66,-11.41,-9.84,-9.53,-9.22,-7.94,-8.31,-7.59,-8.12,-8.41,-9.66,-8.84,-7.78,-6.06,-3.06,-1.41,0.16,-2.66,-4.03,-5.97,-7.66,-9.66,-9.41,-9.41,-9.31,-9.5,-9.66,-9.91,-10.22,-10.81,-10.62,-10.31,-9.22,-8.78,-8.41,-7.41,-6.94,-6.19,-5.5,-3.88,-3.91,-3.31,-2.56,-2.25,-1.41,-0.41,1.91,4.5,6.66,9.16,9.0,9.66,8.75,6.66,6.0,3.75,3.16,0.91,-0.53,-0.03,-1.31,0.94,3.12,4.25,5.75,6.03,6.0,5.19,4.53,4.09,4.47,5.75,6.47,9.03,9.84,10.72,10.31,9.72,7.41,4.91,2.66,0.41,-1.75,-3.66,-3.25,-2.16,-1.62,-0.56,1.44,1.19,2.44,2.81,3.66,4.69,6.31,8.44,8.34,9.66,9.59,7.56,5.66,4.53,2.25,1.56,1.91,2.03,2.0,1.66,1.41,1.41,2.16,1.88,2.03,4.44,6.62,9.94,15.25,20.78,25.97,29.72,31.19,30.09,28.19,26.44,23.41,22.56,21.12,18.88,17.72,13.53,10.72,7.5,5.81,4.62,4.06,4.03,5.41,5.66,8.41,11.78,16.31,20.88,26.06,29.25,30.72,30.84,30.81,29.0,27.19,24.0,21.22,17.81,15.66,13.06,12.12,11.66,10.66,10.09,9.22,8.06,7.16,6.91,5.81,5.97,6.41,8.19,9.31,10.66,12.47,14.0,15.06,16.62,16.09,16.47,-17.34,-20.41,-20.97,-19.94,-17.59,-14.5,-10.28,-6.47,-2.41,0.41,2.03,2.28:10.91,7.34,4.62,0.78,-3.19,-5.34,-8.91,-10.31,-12.12,-12.81,-12.66,-11.91,-9.94,-8.72,-7.03,-4.66,-1.53,2.0,4.09,5.5,6.53,5.66,4.81,3.09,0.84,-1.16,-3.91,-5.47,-3.84,-5.41,-2.69,-0.91,-0.66,0.56,1.75,0.88,1.56,-1.09,-3.81,-8.28,-12.44,-16.28,-20.47,-23.44,-26.22,-28.94,-30.22,-31.88,-32.84,-32.78,-32.16,-31.88,-31.41,-29.62,-25.97,-23.0,-18.03,-13.72,-10.44,-7.28,-6.44,-7.22,-8.06,-12.31,-13.66,-15.91,-16.41,-16.03,-14.19,-13.72,-12.38,-12.62,-13.75,-15.19,-15.25,-17.59,-17.84,-18.19,-18.16,-18.0,-18.09,-17.84,-17.47,-17.03,-15.56,-15.97,-15.06,-15.47,-14.59,-14.03,-13.12,-13.91,-14.47,-16.0,-18.09,-18.59,-20.16,-20.09,-19.72,-18.59,-18.12,-15.66,-14.34,-13.19,-12.66,-12.84,-12.03,-11.97,-11.19,-11.38,-11.62,-12.28,-13.09,-11.97,-13.41,-11.34,-13.03,-14.31,-15.81,-18.69,-20.62,-21.16,-22.06,-21.59,-20.34,-19.28,-16.03,-16.41,-15.41,-15.41,-16.66,-18.41,-20.91,-23.84,-27.09,-29.66,-30.59,-31.97,-32.66,-33.34,-31.81,-33.09,-33.28,-33.44,-34.69,-35.75,-35.91,-34.97,-32.88,-30.53,-27.66,-26.81,-27.41,-28.22,-30.16,-30.03,-30.53,-31.94,-31.09,-30.47,-29.31,-27.84,-25.62,-23.66,-22.59,-22.31,-22.44,-23.22,-24.75,-26.44,-26.56,-26.16,-23.41,-20.09,-17.66,-16.53,-16.88,-18.03,-19.81,-21.5,-22.88,-22.69,-23.81,-22.81,-21.16,-19.84,-19.84,-19.0,-18.53,-19.53,-19.12,-18.19,-19.53,-19.34,-18.19,-17.84,-16.25,-14.09,-9.72,-9.12,-6.84,-5.47,-6.19,-7.25,-8.97,-12.09,-14.94,-16.97,-18.72,-21.91,-22.09,-23.53,-23.19,-23.19,-22.22,-22.47,-21.12,-20.69,-19.0,-15.66,-13.72,-10.19,-8.03,-5.91,-6.47,-7.34,-9.97,-13.03,-17.09,-20.44,-23.34,-26.44,-28.34,-30.53,-31.16,-32.53,-32.09,-32.84,-31.47,-31.5,-30.34,-27.72,-25.97,-22.22,-18.69,-16.72,-13.53,-11.09,-11.03,-10.88,-11.78,-12.78,-15.88,-17.84,-20.19,-22.41,-23.34,-23.59,-23.97,-24.25,-23.44,-22.34,-21.78,-21.84,-19.59,-20.09,-20.41,-18.72,-17.22,-13.59,-8.94,-5.34,-2.34,-0.19,-0.16,-0.41,-2.16,-5.59,-9.34,-13.84,-19.06,-22.44,-24.59,-26.72,-27.97,-27.16,-28.16,-27.97,-26.56,-24.19,-22.88,-19.97,-18.09,-15.44,-14.03,-12.22,-13.69,-13.59,-15.09,-16.22,-17.31,-18.66,-19.69,-20.72,-21.91,-22.47,-22.91,-22.28,-21.5,-19.28,-15.41,-10.56,-6.66,-0.91,3.19,4.94,5.88,5.19,4.09,2.19,0.84,-1.34,-3.19,-4.69,-7.34,-10.34,-12.22,-14.25,-15.97,-16.66,-16.91,-16.16,-14.66,-12.03,-10.78,-8.59,-8.09,-7.12,-7.47,-8.03,-8.69,-9.47,-10.19,-9.69,-9.31,-8.62,-8.34,-7.66,-8.97,-10.44,-11.31,-13.0,-14.84,-16.66,-18.0,-18.88,-19.97,-19.56,-19.41,-19.53,-19.34,-18.41,-17.69,-15.56,-14.84,-11.88,-9.38,-7.84,-4.16,-2.66,-0.03,1.47,0.81,1.5,-0.03,-0.59,-3.06,-5.19,-7.44,-9.09,-8.94,-8.84,-7.78,-6.84,-6.28,-6.34,-6.66,-7.03,-7.44,-8.78,-10.16,-11.19,-12.69,-13.22,-13.62,-13.44,-13.91,-13.22,-13.47,-13.81,-13.09,-13.81,-14.78,-16.12,-17.72,-20.03,-22.75,-24.34,-26.31,-27.34,-27.72,-28.91,-28.69,-28.22,-26.97,-24.84,-22.59,-19.47,-16.41,-13.44,-12.09,-11.22,-10.66,-10.34,-11.66,-12.31,-14.16,-14.84,-16.94,-17.44,-18.88,-19.69,-19.19,-19.59,-20.75,-20.94,-21.53,-22.16,-21.28,-20.34,-19.31,-17.12,-15.41,-15.22,-14.59,-15.84,-18.69,-20.81,-23.38,-25.72,-26.72,-26.69,-26.81,-26.88,-25.97,-26.47,-26.34,-27.16,-28.03,-29.59,-30.41,-31.03,-31.72,-32.47,-33.44,-34.5,-34.59,-35.38,-35.09,-34.41,-32.84,-30.38,-28.47,-24.53,-23.41,-19.69,-17.47,-16.69,-15.94,-15.97,-15.94,-16.81,-16.53,-17.84,-16.53,-17.72,-17.91,-19.06,-19.72,-21.84,-22.56,-23.62,-24.34,-24.97,-25.44,-25.62,-25.0,-23.91,-23.94,-21.69,-20.41,-20.5,-20.03,-20.03,-20.25,-21.69,-22.28,-22.53,-22.84,-23.09,-22.31,-21.59,-20.44,-19.41,-18.44,-17.53,-17.94,-19.59,-21.25,-21.84,-23.59,-24.09,-23.06,-21.28,-21.66,-21.06,-20.34,-20.38,-19.47,-17.81,-16.09,-14.34,-12.91,-12.44,-12.12,-12.66,-13.69,-15.53,-19.34,-23.91,-27.28,-30.34,-31.16,-29.47,-27.25,-24.41,-20.59,-18.22,-15.56,-14.31,-13.09,-13.72,-14.78,-14.78,-14.34,-14.16,-13.53,-12.34,-12.94,-13.38,-14.03,-14.84,-15.72,-15.91,-14.84,-12.84,-10.41,-6.72,-4.81,-4.38,-4.97,-8.56,-12.28,-17.53,-19.88,-22.84,-22.97,-22.47,-21.59,-20.41,-17.84,-16.12,-13.72,-12.34,-11.44,-10.72,-10.53,-10.72,-10.94,-11.28,-10.38,-10.47,-10.47,-10.47,-9.97,-10.59,-10.19,-11.47,-12.53,-11.62,-11.84,-10.62,-9.94,-7.56,-4.38,-1.84,0.44,4.41,5.28,5.31,3.81,2.0,0.19,-1.94,-1.78,-1.09,1.03,2.28,5.0,6.34,6.47,6.06,5.31,3.88,0.97,0.34,-1.28,-1.22,0.22,0.97,1.91,2.66,3.25,3.78,4.41,5.56,6.94,7.72,8.38,8.84,9.69,9.94,11.44,13.09,12.16,11.53,9.38,6.5,3.28,0.34,-1.75,-3.09,-4.53,-4.53,-3.91,-3.22,-2.22,-2.09,-1.88,-2.66,-3.03,-2.38,-2.47,-2.12,-1.94,-2.34,-2.88,-3.81,-5.31,-7.59,-9.34,-10.91,-12.78,-13.41,-14.16,-12.69,-10.94,-9.22,-6.84,-5.12,-3.94,-4.41,-4.84,-5.0,-3.75,-3.38,-2.44,-1.97,-2.38,-3.72,-4.28,-4.91,-5.88,-5.91,-6.19,-5.22,-5.06,-4.28,-4.22,-4.47,-5.88,-8.69,-10.34,-11.12,-11.66,-11.41,-9.84,-9.53,-9.22,-7.94,-8.31,-7.59,-8.12,-8.41,-9.66,-8.84,-7.78,-6.06,-3.06,-1.41,0.16,-2.66,-4.03,-5.97,-7.66,-9.66,-9.41,-9.41,-9.31,-9.5,-9.66,-9.91,-10.22,-10.81,-10.62,-10.31,-9.22,-8.78,-8.41,-7.41,-6.94,-6.19,-5.5,-3.88,-3.91,-3.31,-2.56,-2.25,-1.41,-0.41,1.91,4.5,6.66,9.16,9.0,9.66,8.75,6.66,6.0,3.75,3.16,0.91,-0.53,-0.03,-1.31,0.94,3.12,4.25,5.75,6.03,6.0,5.19,4.53,4.09,4.47,5.75,6.47,9.03,9.84,10.72,10.31,9.72,7.41,4.91,2.66,0.41,-1.75,-3.66,-3.25,-2.16,-1.62,-0.56,1.44,1.19,2.44,2.81,3.66,4.69,6.31,8.44,8.34,9.66,9.59,7.56,5.66,4.53,2.25,1.56,1.91,2.03,2.0,1.66,1.41,1.41,2.16,1.88,2.03,4.44,6.62,9.94,15.25,20.78,25.97,29.72,31.19,30.09,28.19,26.44,23.41,22.56,21.12,18.88,17.72,13.53,10.72,7.5,5.81,4.62,4.06,4.03,5.41,5.66,8.41,11.78,16.31,20.88,26.06,29.25,30.72,30.84,30.81,29.0,27.19,24.0,21.22,17.81,15.66,13.06,12.12,11.66,10.66,10.09,9.22,8.06,7.16,6.91,5.81,5.97,6.41,8.19,9.31,10.66,12.47,14.0,15.06,16.62,16.09,16.47,-17.34,-20.41,-20.97,-19.94,-17.59,-14.5,-10.28,-6.47,-2.41,0.41,2.03,2.28,2.94,2.69,3.0,2.03,1.91,1.34:-8.91,-10.31,-12.12,-12.81,-12.66,-11.91,-9.94,-8.72,-7.03,-4.66,-1.53,2.0,4.09,5.5,6.53,5.66,4.81,3.09,0.84,-1.16,-3.91,-5.47,-3.84,-5.41,-2.69,-0.91,-0.66,0.56,1.75,0.88,1.56,-1.09,-3.81,-8.28,-12.44,-16.28,-20.47,-23.44,-26.22,-28.94,-30.22,-31.88,-32.84,-32.78,-32.16,-31.88,-31.41,-29.62,-25.97,-23.0,-18.03,-13.72,-10.44,-7.28,-6.44,-7.22,-8.06,-12.31,-13.66,-15.91,-16.41,-16.03,-14.19,-13.72,-12.38,-12.62,-13.75,-15.19,-15.25,-17.59,-17.84,-18.19,-18.16,-18.0,-18.09,-17.84,-17.47,-17.03,-15.56,-15.97,-15.06,-15.47,-14.59,-14.03,-13.12,-13.91,-14.47,-16.0,-18.09,-18.59,-20.16,-20.09,-19.72,-18.59,-18.12,-15.66,-14.34,-13.19,-12.66,-12.84,-12.03,-11.97,-11.19,-11.38,-11.62,-12.28,-13.09,-11.97,-13.41,-11.34,-13.03,-14.31,-15.81,-18.69,-20.62,-21.16,-22.06,-21.59,-20.34,-19.28,-16.03,-16.41,-15.41,-15.41,-16.66,-18.41,-20.91,-23.84,-27.09,-29.66,-30.59,-31.97,-32.66,-33.34,-31.81,-33.09,-33.28,-33.44,-34.69,-35.75,-35.91,-34.97,-32.88,-30.53,-27.66,-26.81,-27.41,-28.22,-30.16,-30.03,-30.53,-31.94,-31.09,-30.47,-29.31,-27.84,-25.62,-23.66,-22.59,-22.31,-22.44,-23.22,-24.75,-26.44,-26.56,-26.16,-23.41,-20.09,-17.66,-16.53,-16.88,-18.03,-19.81,-21.5,-22.88,-22.69,-23.81,-22.81,-21.16,-19.84,-19.84,-19.0,-18.53,-19.53,-19.12,-18.19,-19.53,-19.34,-18.19,-17.84,-16.25,-14.09,-9.72,-9.12,-6.84,-5.47,-6.19,-7.25,-8.97,-12.09,-14.94,-16.97,-18.72,-21.91,-22.09,-23.53,-23.19,-23.19,-22.22,-22.47,-21.12,-20.69,-19.0,-15.66,-13.72,-10.19,-8.03,-5.91,-6.47,-7.34,-9.97,-13.03,-17.09,-20.44,-23.34,-26.44,-28.34,-30.53,-31.16,-32.53,-32.09,-32.84,-31.47,-31.5,-30.34,-27.72,-25.97,-22.22,-18.69,-16.72,-13.53,-11.09,-11.03,-10.88,-11.78,-12.78,-15.88,-17.84,-20.19,-22.41,-23.34,-23.59,-23.97,-24.25,-23.44,-22.34,-21.78,-21.84,-19.59,-20.09,-20.41,-18.72,-17.22,-13.59,-8.94,-5.34,-2.34,-0.19,-0.16,-0.41,-2.16,-5.59,-9.34,-13.84,-19.06,-22.44,-24.59,-26.72,-27.97,-27.16,-28.16,-27.97,-26.56,-24.19,-22.88,-19.97,-18.09,-15.44,-14.03,-12.22,-13.69,-13.59,-15.09,-16.22,-17.31,-18.66,-19.69,-20.72,-21.91,-22.47,-22.91,-22.28,-21.5,-19.28,-15.41,-10.56,-6.66,-0.91,3.19,4.94,5.88,5.19,4.09,2.19,0.84,-1.34,-3.19,-4.69,-7.34,-10.34,-12.22,-14.25,-15.97,-16.66,-16.91,-16.16,-14.66,-12.03,-10.78,-8.59,-8.09,-7.12,-7.47,-8.03,-8.69,-9.47,-10.19,-9.69,-9.31,-8.62,-8.34,-7.66,-8.97,-10.44,-11.31,-13.0,-14.84,-16.66,-18.0,-18.88,-19.97,-19.56,-19.41,-19.53,-19.34,-18.41,-17.69,-15.56,-14.84,-11.88,-9.38,-7.84,-4.16,-2.66,-0.03,1.47,0.81,1.5,-0.03,-0.59,-3.06,-5.19,-7.44,-9.09,-8.94,-8.84,-7.78,-6.84,-6.28,-6.34,-6.66,-7.03,-7.44,-8.78,-10.16,-11.19,-12.69,-13.22,-13.62,-13.44,-13.91,-13.22,-13.47,-13.81,-13.09,-13.81,-14.78,-16.12,-17.72,-20.03,-22.75,-24.34,-26.31,-27.34,-27.72,-28.91,-28.69,-28.22,-26.97,-24.84,-22.59,-19.47,-16.41,-13.44,-12.09,-11.22,-10.66,-10.34,-11.66,-12.31,-14.16,-14.84,-16.94,-17.44,-18.88,-19.69,-19.19,-19.59,-20.75,-20.94,-21.53,-22.16,-21.28,-20.34,-19.31,-17.12,-15.41,-15.22,-14.59,-15.84,-18.69,-20.81,-23.38,-25.72,-26.72,-26.69,-26.81,-26.88,-25.97,-26.47,-26.34,-27.16,-28.03,-29.59,-30.41,-31.03,-31.72,-32.47,-33.44,-34.5,-34.59,-35.38,-35.09,-34.41,-32.84,-30.38,-28.47,-24.53,-23.41,-19.69,-17.47,-16.69,-15.94,-15.97,-15.94,-16.81,-16.53,-17.84,-16.53,-17.72,-17.91,-19.06,-19.72,-21.84,-22.56,-23.62,-24.34,-24.97,-25.44,-25.62,-25.0,-23.91,-23.94,-21.69,-20.41,-20.5,-20.03,-20.03,-20.25,-21.69,-22.28,-22.53,-22.84,-23.09,-22.31,-21.59,-20.44,-19.41,-18.44,-17.53,-17.94,-19.59,-21.25,-21.84,-23.59,-24.09,-23.06,-21.28,-21.66,-21.06,-20.34,-20.38,-19.47,-17.81,-16.09,-14.34,-12.91,-12.44,-12.12,-12.66,-13.69,-15.53,-19.34,-23.91,-27.28,-30.34,-31.16,-29.47,-27.25,-24.41,-20.59,-18.22,-15.56,-14.31,-13.09,-13.72,-14.78,-14.78,-14.34,-14.16,-13.53,-12.34,-12.94,-13.38,-14.03,-14.84,-15.72,-15.91,-14.84,-12.84,-10.41,-6.72,-4.81,-4.38,-4.97,-8.56,-12.28,-17.53,-19.88,-22.84,-22.97,-22.47,-21.59,-20.41,-17.84,-16.12,-13.72,-12.34,-11.44,-10.72,-10.53,-10.72,-10.94,-11.28,-10.38,-10.47,-10.47,-10.47,-9.97,-10.59,-10.19,-11.47,-12.53,-11.62,-11.84,-10.62,-9.94,-7.56,-4.38,-1.84,0.44,4.41,5.28,5.31,3.81,2.0,0.19,-1.94,-1.78,-1.09,1.03,2.28,5.0,6.34,6.47,6.06,5.31,3.88,0.97,0.34,-1.28,-1.22,0.22,0.97,1.91,2.66,3.25,3.78,4.41,5.56,6.94,7.72,8.38,8.84,9.69,9.94,11.44,13.09,12.16,11.53,9.38,6.5,3.28,0.34,-1.75,-3.09,-4.53,-4.53,-3.91,-3.22,-2.22,-2.09,-1.88,-2.66,-3.03,-2.38,-2.47,-2.12,-1.94,-2.34,-2.88,-3.81,-5.31,-7.59,-9.34,-10.91,-12.78,-13.41,-14.16,-12.69,-10.94,-9.22,-6.84,-5.12,-3.94,-4.41,-4.84,-5.0,-3.75,-3.38,-2.44,-1.97,-2.38,-3.72,-4.28,-4.91,-5.88,-5.91,-6.19,-5.22,-5.06,-4.28,-4.22,-4.47,-5.88,-8.69,-10.34,-11.12,-11.66,-11.41,-9.84,-9.53,-9.22,-7.94,-8.31,-7.59,-8.12,-8.41,-9.66,-8.84,-7.78,-6.06,-3.06,-1.41,0.16,-2.66,-4.03,-5.97,-7.66,-9.66,-9.41,-9.41,-9.31,-9.5,-9.66,-9.91,-10.22,-10.81,-10.62,-10.31,-9.22,-8.78,-8.41,-7.41,-6.94,-6.19,-5.5,-3.88,-3.91,-3.31,-2.56,-2.25,-1.41,-0.41,1.91,4.5,6.66,9.16,9.0,9.66,8.75,6.66,6.0,3.75,3.16,0.91,-0.53,-0.03,-1.31,0.94,3.12,4.25,5.75,6.03,6.0,5.19,4.53,4.09,4.47,5.75,6.47,9.03,9.84,10.72,10.31,9.72,7.41,4.91,2.66,0.41,-1.75,-3.66,-3.25,-2.16,-1.62,-0.56,1.44,1.19,2.44,2.81,3.66,4.69,6.31,8.44,8.34,9.66,9.59,7.56,5.66,4.53,2.25,1.56,1.91,2.03,2.0,1.66,1.41,1.41,2.16,1.88,2.03,4.44,6.62,9.94,15.25,20.78,25.97,29.72,31.19,30.09,28.19,26.44,23.41,22.56,21.12,18.88,17.72,13.53,10.72,7.5,5.81,4.62,4.06,4.03,5.41,5.66,8.41,11.78,16.31,20.88,26.06,29.25,30.72,30.84,30.81,29.0,27.19,24.0,21.22,17.81,15.66,13.06,12.12,11.66,10.66,10.09,9.22,8.06,7.16,6.91,5.81,5.97,6.41,8.19,9.31,10.66,12.47,14.0,15.06,16.62,16.09,16.47,-17.34,-20.41,-20.97,-19.94,-17.59,-14.5,-10.28,-6.47,-2.41,0.41,2.03,2.28,2.94,2.69,3.0,2.03,1.91,1.34,-0.66,-3.66,-6.97,-9.5,-12.97,-15.34:-9.94,-8.72,-7.03,-4.66,-1.53,2.0,4.09,5.5,6.53,5.66,4.81,3.09,0.84,-1.16,-3.91,-5.47,-3.84,-5.41,-2.69,-0.91,-0.66,0.56,1.75,0.88,1.56,-1.09,-3.81,-8.28,-12.44,-16.28,-20.47,-23.44,-26.22,-28.94,-30.22,-31.88,-32.84,-32.78,-32.16,-31.88,-31.41,-29.62,-25.97,-23.0,-18.03,-13.72,-10.44,-7.28,-6.44,-7.22,-8.06,-12.31,-13.66,-15.91,-16.41,-16.03,-14.19,-13.72,-12.38,-12.62,-13.75,-15.19,-15.25,-17.59,-17.84,-18.19,-18.16,-18.0,-18.09,-17.84,-17.47,-17.03,-15.56,-15.97,-15.06,-15.47,-14.59,-14.03,-13.12,-13.91,-14.47,-16.0,-18.09,-18.59,-20.16,-20.09,-19.72,-18.59,-18.12,-15.66,-14.34,-13.19,-12.66,-12.84,-12.03,-11.97,-11.19,-11.38,-11.62,-12.28,-13.09,-11.97,-13.41,-11.34,-13.03,-14.31,-15.81,-18.69,-20.62,-21.16,-22.06,-21.59,-20.34,-19.28,-16.03,-16.41,-15.41,-15.41,-16.66,-18.41,-20.91,-23.84,-27.09,-29.66,-30.59,-31.97,-32.66,-33.34,-31.81,-33.09,-33.28,-33.44,-34.69,-35.75,-35.91,-34.97,-32.88,-30.53,-27.66,-26.81,-27.41,-28.22,-30.16,-30.03,-30.53,-31.94,-31.09,-30.47,-29.31,-27.84,-25.62,-23.66,-22.59,-22.31,-22.44,-23.22,-24.75,-26.44,-26.56,-26.16,-23.41,-20.09,-17.66,-16.53,-16.88,-18.03,-19.81,-21.5,-22.88,-22.69,-23.81,-22.81,-21.16,-19.84,-19.84,-19.0,-18.53,-19.53,-19.12,-18.19,-19.53,-19.34,-18.19,-17.84,-16.25,-14.09,-9.72,-9.12,-6.84,-5.47,-6.19,-7.25,-8.97,-12.09,-14.94,-16.97,-18.72,-21.91,-22.09,-23.53,-23.19,-23.19,-22.22,-22.47,-21.12,-20.69,-19.0,-15.66,-13.72,-10.19,-8.03,-5.91,-6.47,-7.34,-9.97,-13.03,-17.09,-20.44,-23.34,-26.44,-28.34,-30.53,-31.16,-32.53,-32.09,-32.84,-31.47,-31.5,-30.34,-27.72,-25.97,-22.22,-18.69,-16.72,-13.53,-11.09,-11.03,-10.88,-11.78,-12.78,-15.88,-17.84,-20.19,-22.41,-23.34,-23.59,-23.97,-24.25,-23.44,-22.34,-21.78,-21.84,-19.59,-20.09,-20.41,-18.72,-17.22,-13.59,-8.94,-5.34,-2.34,-0.19,-0.16,-0.41,-2.16,-5.59,-9.34,-13.84,-19.06,-22.44,-24.59,-26.72,-27.97,-27.16,-28.16,-27.97,-26.56,-24.19,-22.88,-19.97,-18.09,-15.44,-14.03,-12.22,-13.69,-13.59,-15.09,-16.22,-17.31,-18.66,-19.69,-20.72,-21.91,-22.47,-22.91,-22.28,-21.5,-19.28,-15.41,-10.56,-6.66,-0.91,3.19,4.94,5.88,5.19,4.09,2.19,0.84,-1.34,-3.19,-4.69,-7.34,-10.34,-12.22,-14.25,-15.97,-16.66,-16.91,-16.16,-14.66,-12.03,-10.78,-8.59,-8.09,-7.12,-7.47,-8.03,-8.69,-9.47,-10.19,-9.69,-9.31,-8.62,-8.34,-7.66,-8.97,-10.44,-11.31,-13.0,-14.84,-16.66,-18.0,-18.88,-19.97,-19.56,-19.41,-19.53,-19.34,-18.41,-17.69,-15.56,-14.84,-11.88,-9.38,-7.84,-4.16,-2.66,-0.03,1.47,0.81,1.5,-0.03,-0.59,-3.06,-5.19,-7.44,-9.09,-8.94,-8.84,-7.78,-6.84,-6.28,-6.34,-6.66,-7.03,-7.44,-8.78,-10.16,-11.19,-12.69,-13.22,-13.62,-13.44,-13.91,-13.22,-13.47,-13.81,-13.09,-13.81,-14.78,-16.12,-17.72,-20.03,-22.75,-24.34,-26.31,-27.34,-27.72,-28.91,-28.69,-28.22,-26.97,-24.84,-22.59,-19.47,-16.41,-13.44,-12.09,-11.22,-10.66,-10.34,-11.66,-12.31,-14.16,-14.84,-16.94,-17.44,-18.88,-19.69,-19.19,-19.59,-20.75,-20.94,-21.53,-22.16,-21.28,-20.34,-19.31,-17.12,-15.41,-15.22,-14.59,-15.84,-18.69,-20.81,-23.38,-25.72,-26.72,-26.69,-26.81,-26.88,-25.97,-26.47,-26.34,-27.16,-28.03,-29.59,-30.41,-31.03,-31.72,-32.47,-33.44,-34.5,-34.59,-35.38,-35.09,-34.41,-32.84,-30.38,-28.47,-24.53,-23.41,-19.69,-17.47,-16.69,-15.94,-15.97,-15.94,-16.81,-16.53,-17.84,-16.53,-17.72,-17.91,-19.06,-19.72,-21.84,-22.56,-23.62,-24.34,-24.97,-25.44,-25.62,-25.0,-23.91,-23.94,-21.69,-20.41,-20.5,-20.03,-20.03,-20.25,-21.69,-22.28,-22.53,-22.84,-23.09,-22.31,-21.59,-20.44,-19.41,-18.44,-17.53,-17.94,-19.59,-21.25,-21.84,-23.59,-24.09,-23.06,-21.28,-21.66,-21.06,-20.34,-20.38,-19.47,-17.81,-16.09,-14.34,-12.91,-12.44,-12.12,-12.66,-13.69,-15.53,-19.34,-23.91,-27.28,-30.34,-31.16,-29.47,-27.25,-24.41,-20.59,-18.22,-15.56,-14.31,-13.09,-13.72,-14.78,-14.78,-14.34,-14.16,-13.53,-12.34,-12.94,-13.38,-14.03,-14.84,-15.72,-15.91,-14.84,-12.84,-10.41,-6.72,-4.81,-4.38,-4.97,-8.56,-12.28,-17.53,-19.88,-22.84,-22.97,-22.47,-21.59,-20.41,-17.84,-16.12,-13.72,-12.34,-11.44,-10.72,-10.53,-10.72,-10.94,-11.28,-10.38,-10.47,-10.47,-10.47,-9.97,-10.59,-10.19,-11.47,-12.53,-11.62,-11.84,-10.62,-9.94,-7.56,-4.38,-1.84,0.44,4.41,5.28,5.31,3.81,2.0,0.19,-1.94,-1.78,-1.09,1.03,2.28,5.0,6.34,6.47,6.06,5.31,3.88,0.97,0.34,-1.28,-1.22,0.22,0.97,1.91,2.66,3.25,3.78,4.41,5.56,6.94,7.72,8.38,8.84,9.69,9.94,11.44,13.09,12.16,11.53,9.38,6.5,3.28,0.34,-1.75,-3.09,-4.53,-4.53,-3.91,-3.22,-2.22,-2.09,-1.88,-2.66,-3.03,-2.38,-2.47,-2.12,-1.94,-2.34,-2.88,-3.81,-5.31,-7.59,-9.34,-10.91,-12.78,-13.41,-14.16,-12.69,-10.94,-9.22,-6.84,-5.12,-3.94,-4.41,-4.84,-5.0,-3.75,-3.38,-2.44,-1.97,-2.38,-3.72,-4.28,-4.91,-5.88,-5.91,-6.19,-5.22,-5.06,-4.28,-4.22,-4.47,-5.88,-8.69,-10.34,-11.12,-11.66,-11.41,-9.84,-9.53,-9.22,-7.94,-8.31,-7.59,-8.12,-8.41,-9.66,-8.84,-7.78,-6.06,-3.06,-1.41,0.16,-2.66,-4.03,-5.97,-7.66,-9.66,-9.41,-9.41,-9.31,-9.5,-9.66,-9.91,-10.22,-10.81,-10.62,-10.31,-9.22,-8.78,-8.41,-7.41,-6.94,-6.19,-5.5,-3.88,-3.91,-3.31,-2.56,-2.25,-1.41,-0.41,1.91,4.5,6.66,9.16,9.0,9.66,8.75,6.66,6.0,3.75,3.16,0.91,-0.53,-0.03,-1.31,0.94,3.12,4.25,5.75,6.03,6.0,5.19,4.53,4.09,4.47,5.75,6.47,9.03,9.84,10.72,10.31,9.72,7.41,4.91,2.66,0.41,-1.75,-3.66,-3.25,-2.16,-1.62,-0.56,1.44,1.19,2.44,2.81,3.66,4.69,6.31,8.44,8.34,9.66,9.59,7.56,5.66,4.53,2.25,1.56,1.91,2.03,2.0,1.66,1.41,1.41,2.16,1.88,2.03,4.44,6.62,9.94,15.25,20.78,25.97,29.72,31.19,30.09,28.19,26.44,23.41,22.56,21.12,18.88,17.72,13.53,10.72,7.5,5.81,4.62,4.06,4.03,5.41,5.66,8.41,11.78,16.31,20.88,26.06,29.25,30.72,30.84,30.81,29.0,27.19,24.0,21.22,17.81,15.66,13.06,12.12,11.66,10.66,10.09,9.22,8.06,7.16,6.91,5.81,5.97,6.41,8.19,9.31,10.66,12.47,14.0,15.06,16.62,16.09,16.47,-17.34,-20.41,-20.97,-19.94,-17.59,-14.5,-10.28,-6.47,-2.41,0.41,2.03,2.28,2.94,2.69,3.0,2.03,1.91,1.34,-0.66,-3.66,-6.97,-9.5,-12.97,-15.34,-17.88,-19.25,-20.34,-20.41,-20.28,-19.25:positivity
22.03,21.97,22.03,21.56,21.66,22.16,23.06,24.41,26.47,27.69,30.41,31.44,31.88,32.25,32.06,31.0,30.59,29.88,29.19,28.44,27.34,26.44,27.47,27.94,29.56,32.41,34.34,35.59,36.5,36.66,35.91,34.88,33.62,33.03,31.91,31.66,32.0,32.78,33.59,34.66,35.16,35.28,34.62,33.16,31.44,29.12,27.94,27.09,27.44,28.66,31.34,33.53,35.38,36.41,37.5,36.97,36.38,35.06,33.03,30.38,27.5,25.38,23.41,22.81,22.31,20.66,19.16,17.78,14.38,12.34,10.94,8.78,7.88,7.31,7.16,6.31,7.66,8.94,11.09,14.41,16.88,19.47,20.09,20.06,19.66,18.19,16.5,15.41,14.84,13.22,12.41,11.38,11.09,11.56,12.88,15.12,18.56,21.22,22.88,23.69,23.16,23.28,23.28,23.41,23.34,25.38,26.0,25.81,25.25,24.94,23.69,24.06,23.06,24.41,25.91,27.19,29.44,31.88,34.16,37.44,40.19,41.94,42.34,41.78,40.09,37.94,35.84,34.31,33.12,32.66,31.38,31.69,30.25,29.91,28.06,26.47,24.72,22.5,20.5,19.34,17.94,17.91,18.16,17.94,18.16,18.5,19.19,20.0,20.94,22.28,23.34,23.81,24.91,24.75,24.62,24.0,22.97,21.84,21.03,20.41,21.03,21.69,22.94,24.53,26.5,26.66,26.84,26.66,25.94,24.84,24.72,24.44,24.31,23.84,23.19,21.78,21.78,21.97,23.34,26.09,28.41,30.62,33.16,34.0,35.19,36.06,35.94,36.31,34.66,33.59,31.91,30.09,28.75,28.34,28.31,27.75,28.06,28.03,28.5,26.91,27.53,27.03,25.88,26.31,25.88,26.19,26.94,28.53,30.84,32.94,33.91,34.5,33.59,32.53,30.88,31.25,30.94,30.16,29.62,28.0,25.03,23.06,21.16,19.25,18.53,18.34,17.75,16.94,16.31,15.75,16.06,17.06,19.03,21.28,23.47,24.47,23.81,22.81,21.5,20.47,19.41,17.78,17.12,16.5,15.81,16.31,16.88,17.88,18.56,19.19,18.62,18.56,17.5,16.84,16.09,14.94,15.06,14.12,12.62,12.22,11.81,12.44,13.88,16.81,19.28,21.81,24.56,27.56,28.91,30.31,31.31,31.31,31.81,31.75,32.59,33.28,33.53,32.81,33.5,32.94,32.09,32.5,31.38,30.12,29.25,28.38,27.56,27.88,28.34,28.44,28.0,27.5,25.47,23.97,23.0,22.38,21.69,22.19,23.03,22.75,23.69,24.31,25.78,27.09,27.78,29.75,29.81,30.28,30.19,29.12,28.03,27.12,26.44,26.16,25.53,25.72,27.19,28.28,30.97,33.66,36.62,38.38,40.06,41.31,40.94,40.5,39.69,37.81,35.47,33.28,29.25,25.81,23.06,19.31,16.34,15.47,15.22,15.53,18.31,22.88,27.41,34.28,38.09,41.31,42.34,40.81,38.38,34.88,32.81,30.88,28.66,26.66,24.38,22.25,19.81,18.66,19.53,20.38,23.16,26.03,28.44,31.31,33.31,34.59,34.88,34.62,33.5,31.19,27.78,24.91,21.12,18.56,15.81,13.94,13.0,13.31,13.75,15.78,18.84,21.69,24.97,27.38,28.41,29.41,29.66,29.44,29.31,30.0,29.94,29.72,28.56,26.81,24.72,22.78,20.97,20.72,19.72,19.53,19.06,18.41,17.94,18.0,18.44,19.66,21.0,23.94,26.38,28.75,31.81,33.19,34.38,35.25,34.62,33.5,31.81,29.62,28.72,26.75,24.62,24.19,22.56,20.25,19.88,18.94,17.16,17.12,16.28,15.97,16.06,15.66,15.97,14.97,13.47,13.25,12.12,12.16,12.91,14.5,17.0,19.19,21.84,22.88,23.5,23.69,22.84,21.81,21.03,21.25,20.75,20.41,20.59,19.72,17.78,16.56,14.81,12.66,12.19,11.47,11.06,12.34,14.12,15.59,15.94,17.19,16.91,16.22,16.94,17.53,17.88,18.72,19.06,18.75,18.38,18.34,17.72,15.38,14.62,12.38,10.59,9.25,8.66,8.16,8.59,8.41,9.19,10.0,11.09,11.72,13.12,14.22,14.94,16.09,16.66,17.66,17.84,18.25,17.78,17.25,17.47,17.25,18.25,20.0,21.44,23.62,24.25,25.41,24.62,23.94,22.81,21.38,20.94,20.53,21.41,21.62,22.59,24.06,24.69,25.41,25.81,25.94,24.62,23.69,21.56,19.38,17.84,16.22,14.84,14.59,14.28,13.94,14.62,14.78,13.81,14.06,13.31,13.12,13.06,13.25,15.03,15.62,16.16,17.62,17.53,18.06,17.81,17.56,18.16,17.97,17.84,18.47,18.72,18.94,19.88,20.28,21.34,21.69,22.0,23.72,24.66,25.47,26.75,26.56,27.09,26.72,27.5,28.19,28.84,29.97,29.41,29.19,28.72,27.34,25.94,24.0,21.31,18.28,15.88,13.56,12.19,11.47,11.66,12.16,14.06,13.88,13.72,13.38,10.97,9.56,6.91,5.25,4.06,3.38,2.41,3.0,2.56,2.81,2.06,3.06,3.72,5.69,8.69,12.59,17.28,22.53,25.59,27.78,28.66,26.94,24.66,21.5,18.19,15.84,14.06,12.81,12.41,12.44,11.78,11.81,11.66,11.16,9.56,8.75,7.59,6.22,5.44,4.53,4.31,4.47,3.88,3.78,4.28,4.44,4.75,6.31,7.56,8.91,10.72,11.66,11.97,10.81,9.75,8.16,6.94,6.06,5.62,4.69,4.94,4.94,6.19,7.44,10.78,13.16,15.25,16.5,16.69,15.25,15.47,13.66,13.31,12.91,12.38,11.19,10.81,9.5,8.88,8.12,8.31,7.84,8.41,9.41,9.38,10.88,11.34,11.59,12.38,12.59,11.44,11.34,10.59,9.97,9.25,8.53,8.56,8.09,8.84,8.91,9.19,9.75,8.91,8.56,8.44,8.84,9.53,10.97,12.72,14.72,15.81,17.78,18.19,18.19,18.53,18.56,17.66,18.06,17.62,18.0,18.5,18.88,19.38,18.91,18.28,16.16,14.22,12.31,11.44,11.47,12.0,13.0,14.19,13.12,13.28,12.34,11.41,10.53,9.38,8.12,6.91,5.81,4.38,3.78,3.94,3.97,4.25,4.88,5.12,5.53,5.31,6.0,7.16,8.78,10.75,11.78,13.34,14.59,15.66,16.19,16.81,16.66,15.75,13.16,11.44,9.0,7.56,5.94,6.0,6.34,7.28,9.16,9.69,10.31,9.81,10.44,10.12,10.56,10.94,11.25,11.22,9.94,8.97,7.84,6.91,7.22,7.28,8.31,9.78,10.12,9.94,8.75,7.88,6.91,5.44,4.84,4.28,3.31,2.97,1.91,2.34,2.41,1.84,3.19,2.88,2.12,1.72,0.38,-0.94,-2.12,-2.97,-2.12,-2.69,-2.38,-2.5,-2.31,-2.47,-2.03,-1.94,-1.53,-1.66,-1.22,-1.22,-0.69,-0.47,-0.22,-0.78,-2.03,-2.84,-3.84,-4.41,-3.69,-2.59,-1.16,-0.03,1.31,2.06,3.38,3.62,4.88,4.97,4.91,4.16,2.47,0.44,-1.84,-3.09,-4.41,-4.91,-4.62,-4.94,-4.38,-4.72,-4.16,-4.34,-4.84,-4.97,-4.91,-5.03,-4.47,-3.97,-3.84,-3.59,-3.06,-2.28,0.31,4.0,9.06,14.28,17.88,20.06,19.56,18.0,13.62,8.62,4.41,0.66,-0.94,-2.34,-2.69,-2.47,-2.47,-3.16,-4.34,-4.34,-4.75,-5.91,-5.81,-5.22,-5.78,-4.91,-4.62,-4.03,-3.31,-2.72,-2.75,-1.34,-2.59,-1.84,-1.66,-1.22,-2.16,-2.5,-3.03,-4.22,-4.59,-4.91,-4.66,-3.94,-4.03:23.06,24.41,26.47,27.69,30.41,31.44,31.88,32.25,32.06,31.0,30.59,29.88,29.19,28.44,27.34,26.44,27.47,27.94,29.56,32.41,34.34,35.59,36.5,36.66,35.91,34.88,33.62,33.03,31.91,31.66,32.0,32.78,33.59,34.66,35.16,35.28,34.62,33.16,31.44,29.12,27.94,27.09,27.44,28.66,31.34,33.53,35.38,36.41,37.5,36.97,36.38,35.06,33.03,30.38,27.5,25.38,23.41,22.81,22.31,20.66,19.16,17.78,14.38,12.34,10.94,8.78,7.88,7.31,7.16,6.31,7.66,8.94,11.09,14.41,16.88,19.47,20.09,20.06,19.66,18.19,16.5,15.41,14.84,13.22,12.41,11.38,11.09,11.56,12.88,15.12,18.56,21.22,22.88,23.69,23.16,23.28,23.28,23.41,23.34,25.38,26.0,25.81,25.25,24.94,23.69,24.06,23.06,24.41,25.91,27.19,29.44,31.88,34.16,37.44,40.19,41.94,42.34,41.78,40.09,37.94,35.84,34.31,33.12,32.66,31.38,31.69,30.25,29.91,28.06,26.47,24.72,22.5,20.5,19.34,17.94,17.91,18.16,17.94,18.16,18.5,19.19,20.0,20.94,22.28,23.34,23.81,24.91,24.75,24.62,24.0,22.97,21.84,21.03,20.41,21.03,21.69,22.94,24.53,26.5,26.66,26.84,26.66,25.94,24.84,24.72,24.44,24.31,23.84,23.19,21.78,21.78,21.97,23.34,26.09,28.41,30.62,33.16,34.0,35.19,36.06,35.94,36.31,34.66,33.59,31.91,30.09,28.75,28.34,28.31,27.75,28.06,28.03,28.5,26.91,27.53,27.03,25.88,26.31,25.88,26.19,26.94,28.53,30.84,32.94,33.91,34.5,33.59,32.53,30.88,31.25,30.94,30.16,29.62,28.0,25.03,23.06,21.16,19.25,18.53,18.34,17.75,16.94,16.31,15.75,16.06,17.06,19.03,21.28,23.47,24.47,23.81,22.81,21.5,20.47,19.41,17.78,17.12,16.5,15.81,16.31,16.88,17.88,18.56,19.19,18.62,18.56,17.5,16.84,16.09,14.94,15.06,14.12,12.62,12.22,11.81,12.44,13.88,16.81,19.28,21.81,24.56,27.56,28.91,30.31,31.31,31.31,31.81,31.75,32.59,33.28,33.53,32.81,33.5,32.94,32.09,32.5,31.38,30.12,29.25,28.38,27.56,27.88,28.34,28.44,28.0,27.5,25.47,23.97,23.0,22.38,21.69,22.19,23.03,22.75,23.69,24.31,25.78,27.09,27.78,29.75,29.81,30.28,30.19,29.12,28.03,27.12,26.44,26.16,25.53,25.72,27.19,28.28,30.97,33.66,36.62,38.38,40.06,41.31,40.94,40.5,39.69,37.81,35.47,33.28,29.25,25.81,23.06,19.31,16.34,15.47,15.22,15.53,18.31,22.88,27.41,34.28,38.09,41.31,42.34,40.81,38.38,34.88,32.81,30.88,28.66,26.66,24.38,22.25,19.81,18.66,19.53,20.38,23.16,26.03,28.44,31.31,33.31,34.59,34.88,34.62,33.5,31.19,27.78,24.91,21.12,18.56,15.81,13.94,13.0,13.31,13.75,15.78,18.84,21.69,24.97,27.38,28.41,29.41,29.66,29.44,29.31,30.0,29.94,29.72,28.56,26.81,24.72,22.78,20.97,20.72,19.72,19.53,19.06,18.41,17.94,18.0,18.44,19.66,21.0,23.94,26.38,28.75,31.81,33.19,34.38,35.25,34.62,33.5,31.81,29.62,28.72,26.75,24.62,24.19,22.56,20.25,19.88,18.94,17.16,17.12,16.28,15.97,16.06,15.66,15.97,14.97,13.47,13.25,12.12,12.16,12.91,14.5,17.0,19.19,21.84,22.88,23.5,23.69,22.84,21.81,21.03,21.25,20.75,20.41,20.59,19.72,17.78,16.56,14.81,12.66,12.19,11.47,11.06,12.34,14.12,15.59,15.94,17.19,16.91,16.22,16.94,17.53,17.88,18.72,19.06,18.75,18.38,18.34,17.72,15.38,14.62,12.38,10.59,9.25,8.66,8.16,8.59,8.41,9.19,10.0,11.09,11.72,13.12,14.22,14.94,16.09,16.66,17.66,17.84,18.25,17.78,17.25,17.47,17.25,18.25,20.0,21.44,23.62,24.25,25.41,24.62,23.94,22.81,21.38,20.94,20.53,21.41,21.62,22.59,24.06,24.69,25.41,25.81,25.94,24.62,23.69,21.56,19.38,17.84,16.22,14.84,14.59,14.28,13.94,14.62,14.78,13.81,14.06,13.31,13.12,13.06,13.25,15.03,15.62,16.16,17.62,17.53,18.06,17.81,17.56,18.16,17.97,17.84,18.47,18.72,18.94,19.88,20.28,21.34,21.69,22.0,23.72,24.66,25.47,26.75,26.56,27.09,26.72,27.5,28.19,28.84,29.97,29.41,29.19,28.72,27.34,25.94,24.0,21.31,18.28,15.88,13.56,12.19,11.47,11.66,12.16,14.06,13.88,13.72,13.38,10.97,9.56,6.91,5.25,4.06,3.38,2.41,3.0,2.56,2.81,2.06,3.06,3.72,5.69,8.69,12.59,17.28,22.53,25.59,27.78,28.66,26.94,24.66,21.5,18.19,15.84,14.06,12.81,12.41,12.44,11.78,11.81,11.66,11.16,9.56,8.75,7.59,6.22,5.44,4.53,4.31,4.47,3.88,3.78,4.28,4.44,4.75,6.31,7.56,8.91,10.72,11.66,11.97,10.81,9.75,8.16,6.94,6.06,5.62,4.69,4.94,4.94,6.19,7.44,10.78,13.16,15.25,16.5,16.69,15.25,15.47,13.66,13.31,12.91,12.38,11.19,10.81,9.5,8.88,8.12,8.31,7.84,8.41,9.41,9.38,10.88,11.34,11.59,12.38,12.59,11.44,11.34,10.59,9.97,9.25,8.53,8.56,8.09,8.84,8.91,9.19,9.75,8.91,8.56,8.44,8.84,9.53,10.97,12.72,14.72,15.81,17.78,18.19,18.19,18.53,18.56,17.66,18.06,17.62,18.0,18.5,18.88,19.38,18.91,18.28,16.16,14.22,12.31,11.44,11.47,12.0,13.0,14.19,13.12,13.28,12.34,11.41,10.53,9.38,8.12,6.91,5.81,4.38,3.78,3.94,3.97,4.25,4.88,5.12,5.53,5.31,6.0,7.16,8.78,10.75,11.78,13.34,14.59,15.66,16.19,16.81,16.66,15.75,13.16,11.44,9.0,7.56,5.94,6.0,6.34,7.28,9.16,9.69,10.31,9.81,10.44,10.12,10.56,10.94,11.25,11.22,9.94,8.97,7.84,6.91,7.22,7.28,8.31,9.78,10.12,9.94,8.75,7.88,6.91,5.44,4.84,4.28,3.31,2.97,1.91,2.34,2.41,1.84,3.19,2.88,2.12,1.72,0.38,-0.94,-2.12,-2.97,-2.12,-2.69,-2.38,-2.5,-2.31,-2.47,-2.03,-1.94,-1.53,-1.66,-1.22,-1.22,-0.69,-0.47,-0.22,-0.78,-2.03,-2.84,-3.84,-4.41,-3.69,-2.59,-1.16,-0.03,1.31,2.06,3.38,3.62,4.88,4.97,4.91,4.16,2.47,0.44,-1.84,-3.09,-4.41,-4.91,-4.62,-4.94,-4.38,-4.72,-4.16,-4.34,-4.84,-4.97,-4.91,-5.03,-4.47,-3.97,-3.84,-3.59,-3.06,-2.28,0.31,4.0,9.06,14.28,17.88,20.06,19.56,18.0,13.62,8.62,4.41,0.66,-0.94,-2.34,-2.69,-2.47,-2.47,-3.16,-4.34,-4.34,-4.75,-5.91,-5.81,-5.22,-5.78,-4.91,-4.62,-4.03,-3.31,-2.72,-2.75,-1.34,-2.59,-1.84,-1.66,-1.22,-2.16,-2.5,-3.03,-4.22,-4.59,-4.91,-4.66,-3.94,-4.03,15.28,14.91,14.69,14.31,14.12,14.62:31.88,32.25,32.06,31.0,30.59,29.88,29.19,28.44,27.34,26.44,27.47,27.94,29.56,32.41,34.34,35.59,36.5,36.66,35.91,34.88,33.62,33.03,31.91,31.66,32.0,32.78,33.59,34.66,35.16,35.28,34.62,33.16,31.44,29.12,27.94,27.09,27.44,28.66,31.34,33.53,35.38,36.41,37.5,36.97,36.38,35.06,33.03,30.38,27.5,25.38,23.41,22.81,22.31,20.66,19.16,17.78,14.38,12.34,10.94,8.78,7.88,7.31,7.16,6.31,7.66,8.94,11.09,14.41,16.88,19.47,20.09,20.06,19.66,18.19,16.5,15.41,14.84,13.22,12.41,11.38,11.09,11.56,12.88,15.12,18.56,21.22,22.88,23.69,23.16,23.28,23.28,23.41,23.34,25.38,26.0,25.81,25.25,24.94,23.69,24.06,23.06,24.41,25.91,27.19,29.44,31.88,34.16,37.44,40.19,41.94,42.34,41.78,40.09,37.94,35.84,34.31,33.12,32.66,31.38,31.69,30.25,29.91,28.06,26.47,24.72,22.5,20.5,19.34,17.94,17.91,18.16,17.94,18.16,18.5,19.19,20.0,20.94,22.28,23.34,23.81,24.91,24.75,24.62,24.0,22.97,21.84,21.03,20.41,21.03,21.69,22.94,24.53,26.5,26.66,26.84,26.66,25.94,24.84,24.72,24.44,24.31,23.84,23.19,21.78,21.78,21.97,23.34,26.09,28.41,30.62,33.16,34.0,35.19,36.06,35.94,36.31,34.66,33.59,31.91,30.09,28.75,28.34,28.31,27.75,28.06,28.03,28.5,26.91,27.53,27.03,25.88,26.31,25.88,26.19,26.94,28.53,30.84,32.94,33.91,34.5,33.59,32.53,30.88,31.25,30.94,30.16,29.62,28.0,25.03,23.06,21.16,19.25,18.53,18.34,17.75,16.94,16.31,15.75,16.06,17.06,19.03,21.28,23.47,24.47,23.81,22.81,21.5,20.47,19.41,17.78,17.12,16.5,15.81,16.31,16.88,17.88,18.56,19.19,18.62,18.56,17.5,16.84,16.09,14.94,15.06,14.12,12.62,12.22,11.81,12.44,13.88,16.81,19.28,21.81,24.56,27.56,28.91,30.31,31.31,31.31,31.81,31.75,32.59,33.28,33.53,32.81,33.5,32.94,32.09,32.5,31.38,30.12,29.25,28.38,27.56,27.88,28.34,28.44,28.0,27.5,25.47,23.97,23.0,22.38,21.69,22.19,23.03,22.75,23.69,24.31,25.78,27.09,27.78,29.75,29.81,30.28,30.19,29.12,28.03,27.12,26.44,26.16,25.53,25.72,27.19,28.28,30.97,33.66,36.62,38.38,40.06,41.31,40.94,40.5,39.69,37.81,35.47,33.28,29.25,25.81,23.06,19.31,16.34,15.47,15.22,15.53,18.31,22.88,27.41,34.28,38.09,41.31,42.34,40.81,38.38,34.88,32.81,30.88,28.66,26.66,24.38,22.25,19.81,18.66,19.53,20.38,23.16,26.03,28.44,31.31,33.31,34.59,34.88,34.62,33.5,31.19,27.78,24.91,21.12,18.56,15.81,13.94,13.0,13.31,13.75,15.78,18.84,21.69,24.97,27.38,28.41,29.41,29.66,29.44,29.31,30.0,29.94,29.72,28.56,26.81,24.72,22.78,20.97,20.72,19.72,19.53,19.06,18.41,17.94,18.0,18.44,19.66,21.0,23.94,26.38,28.75,31.81,33.19,34.38,35.25,34.62,33.5,31.81,29.62,28.72,26.75,24.62,24.19,22.56,20.25,19.88,18.94,17.16,17.12,16.28,15.97,16.06,15.66,15.97,14.97,13.47,13.25,12.12,12.16,12.91,14.5,17.0,19.19,21.84,22.88,23.5,23.69,22.84,21.81,21.03,21.25,20.75,20.41,20.59,19.72,17.78,16.56,14.81,12.66,12.19,11.47,11.06,12.34,14.12,15.59,15.94,17.19,16.91,16.22,16.94,17.53,17.88,18.72,19.06,18.75,18.38,18.34,17.72,15.38,14.62,12.38,10.59,9.25,8.66,8.16,8.59,8.41,9.19,10.0,11.09,11.72,13.12,14.22,14.94,16.09,16.66,17.66,17.84,18.25,17.78,17.25,17.47,17.25,18.25,20.0,21.44,23.62,24.25,25.41,24.62,23.94,22.81,21.38,20.94,20.53,21.41,21.62,22.59,24.06,24.69,25.41,25.81,25.94,24.62,23.69,21.56,19.38,17.84,16.22,14.84,14.59,14.28,13.94,14.62,14.78,13.81,14.06,13.31,13.12,13.06,13.25,15.03,15.62,16.16,17.62,17.53,18.06,17.81,17.56,18.16,17.97,17.84,18.47,18.72,18.94,19.88,20.28,21.34,21.69,22.0,23.72,24.66,25.47,26.75,26.56,27.09,26.72,27.5,28.19,28.84,29.97,29.41,29.19,28.72,27.34,25.94,24.0,21.31,18.28,15.88,13.56,12.19,11.47,11.66,12.16,14.06,13.88,13.72,13.38,10.97,9.56,6.91,5.25,4.06,3.38,2.41,3.0,2.56,2.81,2.06,3.06,3.72,5.69,8.69,12.59,17.28,22.53,25.59,27.78,28.66,26.94,24.66,21.5,18.19,15.84,14.06,12.81,12.41,12.44,11.78,11.81,11.66,11.16,9.56,8.75,7.59,6.22,5.44,4.53,4.31,4.47,3.88,3.78,4.28,4.44,4.75,6.31,7.56,8.91,10.72,11.66,11.97,10.81,9.75,8.16,6.94,6.06,5.62,4.69,4.94,4.94,6.19,7.44,10.78,13.16,15.25,16.5,16.69,15.25,15.47,13.66,13.31,12.91,12.38,11.19,10.81,9.5,8.88,8.12,8.31,7.84,8.41,9.41,9.38,10.88,11.34,11.59,12.38,12.59,11.44,11.34,10.59,9.97,9.25,8.53,8.56,8.09,8.84,8.91,9.19,9.75,8.91,8.56,8.44,8.84,9.53,10.97,12.72,14.72,15.81,17.78,18.19,18.19,18.53,18.56,17.66,18.06,17.62,18.0,18.5,18.88,19.38,18.91,18.28,16.16,14.22,12.31,11.44,11.47,12.0,13.0,14.19,13.12,13.28,12.34,11.41,10.53,9.38,8.12,6.91,5.81,4.38,3.78,3.94,3.97,4.25,4.88,5.12,5.53,5.31,6.0,7.16,8.78,10.75,11.78,13.34,14.59,15.66,16.19,16.81,16.66,15.75,13.16,11.44,9.0,7.56,5.94,6.0,6.34,7.28,9.16,9.69,10.31,9.81,10.44,10.12,10.56,10.94,11.25,11.22,9.94,8.97,7.84,6.91,7.22,7.28,8.31,9.78,10.12,9.94,8.75,7.88,6.91,5.44,4.84,4.28,3.31,2.97,1.91,2.34,2.41,1.84,3.19,2.88,2.12,1.72,0.38,-0.94,-2.12,-2.97,-2.12,-2.69,-2.38,-2.5,-2.31,-2.47,-2.03,-1.94,-1.53,-1.66,-1.22,-1.22,-0.69,-0.47,-0.22,-0.78,-2.03,-2.84,-3.84,-4.41,-3.69,-2.59,-1.16,-0.03,1.31,2.06,3.38,3.62,4.88,4.97,4.91,4.16,2.47,0.44,-1.84,-3.09,-4.41,-4.91,-4.62,-4.94,-4.38,-4.72,-4.16,-4.34,-4.84,-4.97,-4.91,-5.03,-4.47,-3.97,-3.84,-3.59,-3.06,-2.28,0.31,4.0,9.06,14.28,17.88,20.06,19.56,18.0,13.62,8.62,4.41,0.66,-0.94,-2.34,-2.69,-2.47,-2.47,-3.16,-4.34,-4.34,-4.75,-5.91,-5.81,-5.22,-5.78,-4.91,-4.62,-4.03,-3.31,-2.72,-2.75,-1.34,-2.59,-1.84,-1.66,-1.22,-2.16,-2.5,-3.03,-4.22,-4.59,-4.91,-4.66,-3.94,-4.03,15.28,14.91,14.69,14.31,14.12,14.62,16.03,18.5,21.84,24.78,27.84,29.25:29.19,28.44,27.34,26.44,27.47,27.94,29.56,32.41,34.34,35.59,36.5,36.66,35.91,34.88,33.62,33.03,31.91,31.66,32.0,32.78,33.59,34.66,35.16,35.28,34.62,33.16,31.44,29.12,27.94,27.09,27.44,28.66,31.34,33.53,35.38,36.41,37.5,36.97,36.38,35.06,33.03,30.38,27.5,25.38,23.41,22.81,22.31,20.66,19.16,17.78,14.38,12.34,10.94,8.78,7.88,7.31,7.16,6.31,7.66,8.94,11.09,14.41,16.88,19.47,20.09,20.06,19.66,18.19,16.5,15.41,14.84,13.22,12.41,11.38,11.09,11.56,12.88,15.12,18.56,21.22,22.88,23.69,23.16,23.28,23.28,23.41,23.34,25.38,26.0,25.81,25.25,24.94,23.69,24.06,23.06,24.41,25.91,27.19,29.44,31.88,34.16,37.44,40.19,41.94,42.34,41.78,40.09,37.94,35.84,34.31,33.12,32.66,31.38,31.69,30.25,29.91,28.06,26.47,24.72,22.5,20.5,19.34,17.94,17.91,18.16,17.94,18.16,18.5,19.19,20.0,20.94,22.28,23.34,23.81,24.91,24.75,24.62,24.0,22.97,21.84,21.03,20.41,21.03,21.69,22.94,24.53,26.5,26.66,26.84,26.66,25.94,24.84,24.72,24.44,24.31,23.84,23.19,21.78,21.78,21.97,23.34,26.09,28.41,30.62,33.16,34.0,35.19,36.06,35.94,36.31,34.66,33.59,31.91,30.09,28.75,28.34,28.31,27.75,28.06,28.03,28.5,26.91,27.53,27.03,25.88,26.31,25.88,26.19,26.94,28.53,30.84,32.94,33.91,34.5,33.59,32.53,30.88,31.25,30.94,30.16,29.62,28.0,25.03,23.06,21.16,19.25,18.53,18.34,17.75,16.94,16.31,15.75,16.06,17.06,19.03,21.28,23.47,24.47,23.81,22.81,21.5,20.47,19.41,17.78,17.12,16.5,15.81,16.31,16.88,17.88,18.56,19.19,18.62,18.56,17.5,16.84,16.09,14.94,15.06,14.12,12.62,12.22,11.81,12.44,13.88,16.81,19.28,21.81,24.56,27.56,28.91,30.31,31.31,31.31,31.81,31.75,32.59,33.28,33.53,32.81,33.5,32.94,32.09,32.5,31.38,30.12,29.25,28.38,27.56,27.88,28.34,28.44,28.0,27.5,25.47,23.97,23.0,22.38,21.69,22.19,23.03,22.75,23.69,24.31,25.78,27.09,27.78,29.75,29.81,30.28,30.19,29.12,28.03,27.12,26.44,26.16,25.53,25.72,27.19,28.28,30.97,33.66,36.62,38.38,40.06,41.31,40.94,40.5,39.69,37.81,35.47,33.28,29.25,25.81,23.06,19.31,16.34,15.47,15.22,15.53,18.31,22.88,27.41,34.28,38.09,41.31,42.34,40.81,38.38,34.88,32.81,30.88,28.66,26.66,24.38,22.25,19.81,18.66,19.53,20.38,23.16,26.03,28.44,31.31,33.31,34.59,34.88,34.62,33.5,31.19,27.78,24.91,21.12,18.56,15.81,13.94,13.0,13.31,13.75,15.78,18.84,21.69,24.97,27.38,28.41,29.41,29.66,29.44,29.31,30.0,29.94,29.72,28.56,26.81,24.72,22.78,20.97,20.72,19.72,19.53,19.06,18.41,17.94,18.0,18.44,19.66,21.0,23.94,26.38,28.75,31.81,33.19,34.38,35.25,34.62,33.5,31.81,29.62,28.72,26.75,24.62,24.19,22.56,20.25,19.88,18.94,17.16,17.12,16.28,15.97,16.06,15.66,15.97,14.97,13.47,13.25,12.12,12.16,12.91,14.5,17.0,19.19,21.84,22.88,23.5,23.69,22.84,21.81,21.03,21.25,20.75,20.41,20.59,19.72,17.78,16.56,14.81,12.66,12.19,11.47,11.06,12.34,14.12,15.59,15.94,17.19,16.91,16.22,16.94,17.53,17.88,18.72,19.06,18.75,18.38,18.34,17.72,15.38,14.62,12.38,10.59,9.25,8.66,8.16,8.59,8.41,9.19,10.0,11.09,11.72,13.12,14.22,14.94,16.09,16.66,17.66,17.84,18.25,17.78,17.25,17.47,17.25,18.25,20.0,21.44,23.62,24.25,25.41,24.62,23.94,22.81,21.38,20.94,20.53,21.41,21.62,22.59,24.06,24.69,25.41,25.81,25.94,24.62,23.69,21.56,19.38,17.84,16.22,14.84,14.59,14.28,13.94,14.62,14.78,13.81,14.06,13.31,13.12,13.06,13.25,15.03,15.62,16.16,17.62,17.53,18.06,17.81,17.56,18.16,17.97,17.84,18.47,18.72,18.94,19.88,20.28,21.34,21.69,22.0,23.72,24.66,25.47,26.75,26.56,27.09,26.72,27.5,28.19,28.84,29.97,29.41,29.19,28.72,27.34,25.94,24.0,21.31,18.28,15.88,13.56,12.19,11.47,11.66,12.16,14.06,13.88,13.72,13.38,10.97,9.56,6.91,5.25,4.06,3.38,2.41,3.0,2.56,2.81,2.06,3.06,3.72,5.69,8.69,12.59,17.28,22.53,25.59,27.78,28.66,26.94,24.66,21.5,18.19,15.84,14.06,12.81,12.41,12.44,11.78,11.81,11.66,11.16,9.56,8.75,7.59,6.22,5.44,4.53,4.31,4.47,3.88,3.78,4.28,4.44,4.75,6.31,7.56,8.91,10.72,11.66,11.97,10.81,9.75,8.16,6.94,6.06,5.62,4.69,4.94,4.94,6.19,7.44,10.78,13.16,15.25,16.5,16.69,15.25,15.47,13.66,13.31,12.91,12.38,11.19,10.81,9.5,8.88,8.12,8.31,7.84,8.41,9.41,9.38,10.88,11.34,11.59,12.38,12.59,11.44,11.34,10.59,9.97,9.25,8.53,8.56,8.09,8.84,8.91,9.19,9.75,8.91,8.56,8.44,8.84,9.53,10.97,12.72,14.72,15.81,17.78,18.19,18.19,18.53,18.56,17.66,18.06,17.62,18.0,18.5,18.88,19.38,18.91,18.28,16.16,14.22,12.31,11.44,11.47,12.0,13.0,14.19,13.12,13.28,12.34,11.41,10.53,9.38,8.12,6.91,5.81,4.38,3.78,3.94,3.97,4.25,4.88,5.12,5.53,5.31,6.0,7.16,8.78,10.75,11.78,13.34,14.59,15.66,16.19,16.81,16.66,15.75,13.16,11.44,9.0,7.56,5.94,6.0,6.34,7.28,9.16,9.69,10.31,9.81,10.44,10.12,10.56,10.94,11.25,11.22,9.94,8.97,7.84,6.91,7.22,7.28,8.31,9.78,10.12,9.94,8.75,7.88,6.91,5.44,4.84,4.28,3.31,2.97,1.91,2.34,2.41,1.84,3.19,2.88,2.12,1.72,0.38,-0.94,-2.12,-2.97,-2.12,-2.69,-2.38,-2.5,-2.31,-2.47,-2.03,-1.94,-1.53,-1.66,-1.22,-1.22,-0.69,-0.47,-0.22,-0.78,-2.03,-2.84,-3.84,-4.41,-3.69,-2.59,-1.16,-0.03,1.31,2.06,3.38,3.62,4.88,4.97,4.91,4.16,2.47,0.44,-1.84,-3.09,-4.41,-4.91,-4.62,-4.94,-4.38,-4.72,-4.16,-4.34,-4.84,-4.97,-4.91,-5.03,-4.47,-3.97,-3.84,-3.59,-3.06,-2.28,0.31,4.0,9.06,14.28,17.88,20.06,19.56,18.0,13.62,8.62,4.41,0.66,-0.94,-2.34,-2.69,-2.47,-2.47,-3.16,-4.34,-4.34,-4.75,-5.91,-5.81,-5.22,-5.78,-4.91,-4.62,-4.03,-3.31,-2.72,-2.75,-1.34,-2.59,-1.84,-1.66,-1.22,-2.16,-2.5,-3.03,-4.22,-4.59,-4.91,-4.66,-3.94,-4.03,15.28,14.91,14.69,14.31,14.12,14.62,16.03,18.5,21.84,24.78,27.84,29.25,29.0,29.25,27.0,26.69,25.28,23.69:29.56,32.41,34.34,35.59,36.5,36.66,35.91,34.88,33.62,33.03,31.91,31.66,32.0,32.78,33.59,34.66,35.16,35.28,34.62,33.16,31.44,29.12,27.94,27.09,27.44,28.66,31.34,33.53,35.38,36.41,37.5,36.97,36.38,35.06,33.03,30.38,27.5,25.38,23.41,22.81,22.31,20.66,19.16,17.78,14.38,12.34,10.94,8.78,7.88,7.31,7.16,6.31,7.66,8.94,11.09,14.41,16.88,19.47,20.09,20.06,19.66,18.19,16.5,15.41,14.84,13.22,12.41,11.38,11.09,11.56,12.88,15.12,18.56,21.22,22.88,23.69,23.16,23.28,23.28,23.41,23.34,25.38,26.0,25.81,25.25,24.94,23.69,24.06,23.06,24.41,25.91,27.19,29.44,31.88,34.16,37.44,40.19,41.94,42.34,41.78,40.09,37.94,35.84,34.31,33.12,32.66,31.38,31.69,30.25,29.91,28.06,26.47,24.72,22.5,20.5,19.34,17.94,17.91,18.16,17.94,18.16,18.5,19.19,20.0,20.94,22.28,23.34,23.81,24.91,24.75,24.62,24.0,22.97,21.84,21.03,20.41,21.03,21.69,22.94,24.53,26.5,26.66,26.84,26.66,25.94,24.84,24.72,24.44,24.31,23.84,23.19,21.78,21.78,21.97,23.34,26.09,28.41,30.62,33.16,34.0,35.19,36.06,35.94,36.31,34.66,33.59,31.91,30.09,28.75,28.34,28.31,27.75,28.06,28.03,28.5,26.91,27.53,27.03,25.88,26.31,25.88,26.19,26.94,28.53,30.84,32.94,33.91,34.5,33.59,32.53,30.88,31.25,30.94,30.16,29.62,28.0,25.03,23.06,21.16,19.25,18.53,18.34,17.75,16.94,16.31,15.75,16.06,17.06,19.03,21.28,23.47,24.47,23.81,22.81,21.5,20.47,19.41,17.78,17.12,16.5,15.81,16.31,16.88,17.88,18.56,19.19,18.62,18.56,17.5,16.84,16.09,14.94,15.06,14.12,12.62,12.22,11.81,12.44,13.88,16.81,19.28,21.81,24.56,27.56,28.91,30.31,31.31,31.31,31.81,31.75,32.59,33.28,33.53,32.81,33.5,32.94,32.09,32.5,31.38,30.12,29.25,28.38,27.56,27.88,28.34,28.44,28.0,27.5,25.47,23.97,23.0,22.38,21.69,22.19,23.03,22.75,23.69,24.31,25.78,27.09,27.78,29.75,29.81,30.28,30.19,29.12,28.03,27.12,26.44,26.16,25.53,25.72,27.19,28.28,30.97,33.66,36.62,38.38,40.06,41.31,40.94,40.5,39.69,37.81,35.47,33.28,29.25,25.81,23.06,19.31,16.34,15.47,15.22,15.53,18.31,22.88,27.41,34.28,38.09,41.31,42.34,40.81,38.38,34.88,32.81,30.88,28.66,26.66,24.38,22.25,19.81,18.66,19.53,20.38,23.16,26.03,28.44,31.31,33.31,34.59,34.88,34.62,33.5,31.19,27.78,24.91,21.12,18.56,15.81,13.94,13.0,13.31,13.75,15.78,18.84,21.69,24.97,27.38,28.41,29.41,29.66,29.44,29.31,30.0,29.94,29.72,28.56,26.81,24.72,22.78,20.97,20.72,19.72,19.53,19.06,18.41,17.94,18.0,18.44,19.66,21.0,23.94,26.38,28.75,31.81,33.19,34.38,35.25,34.62,33.5,31.81,29.62,28.72,26.75,24.62,24.19,22.56,20.25,19.88,18.94,17.16,17.12,16.28,15.97,16.06,15.66,15.97,14.97,13.47,13.25,12.12,12.16,12.91,14.5,17.0,19.19,21.84,22.88,23.5,23.69,22.84,21.81,21.03,21.25,20.75,20.41,20.59,19.72,17.78,16.56,14.81,12.66,12.19,11.47,11.06,12.34,14.12,15.59,15.94,17.19,16.91,16.22,16.94,17.53,17.88,18.72,19.06,18.75,18.38,18.34,17.72,15.38,14.62,12.38,10.59,9.25,8.66,8.16,8.59,8.41,9.19,10.0,11.09,11.72,13.12,14.22,14.94,16.09,16.66,17.66,17.84,18.25,17.78,17.25,17.47,17.25,18.25,20.0,21.44,23.62,24.25,25.41,24.62,23.94,22.81,21.38,20.94,20.53,21.41,21.62,22.59,24.06,24.69,25.41,25.81,25.94,24.62,23.69,21.56,19.38,17.84,16.22,14.84,14.59,14.28,13.94,14.62,14.78,13.81,14.06,13.31,13.12,13.06,13.25,15.03,15.62,16.16,17.62,17.53,18.06,17.81,17.56,18.16,17.97,17.84,18.47,18.72,18.94,19.88,20.28,21.34,21.69,22.0,23.72,24.66,25.47,26.75,26.56,27.09,26.72,27.5,28.19,28.84,29.97,29.41,29.19,28.72,27.34,25.94,24.0,21.31,18.28,15.88,13.56,12.19,11.47,11.66,12.16,14.06,13.88,13.72,13.38,10.97,9.56,6.91,5.25,4.06,3.38,2.41,3.0,2.56,2.81,2.06,3.06,3.72,5.69,8.69,12.59,17.28,22.53,25.59,27.78,28.66,26.94,24.66,21.5,18.19,15.84,14.06,12.81,12.41,12.44,11.78,11.81,11.66,11.16,9.56,8.75,7.59,6.22,5.44,4.53,4.31,4.47,3.88,3.78,4.28,4.44,4.75,6.31,7.56,8.91,10.72,11.66,11.97,10.81,9.75,8.16,6.94,6.06,5.62,4.69,4.94,4.94,6.19,7.44,10.78,13.16,15.25,16.5,16.69,15.25,15.47,13.66,13.31,12.91,12.38,11.19,10.81,9.5,8.88,8.12,8.31,7.84,8.41,9.41,9.38,10.88,11.34,11.59,12.38,12.59,11.44,11.34,10.59,9.97,9.25,8.53,8.56,8.09,8.84,8.91,9.19,9.75,8.91,8.56,8.44,8.84,9.53,10.97,12.72,14.72,15.81,17.78,18.19,18.19,18.53,18.56,17.66,18.06,17.62,18.0,18.5,18.88,19.38,18.91,18.28,16.16,14.22,12.31,11.44,11.47,12.0,13.0,14.19,13.12,13.28,12.34,11.41,10.53,9.38,8.12,6.91,5.81,4.38,3.78,3.94,3.97,4.25,4.88,5.12,5.53,5.31,6.0,7.16,8.78,10.75,11.78,13.34,14.59,15.66,16.19,16.81,16.66,15.75,13.16,11.44,9.0,7.56,5.94,6.0,6.34,7.28,9.16,9.69,10.31,9.81,10.44,10.12,10.56,10.94,11.25,11.22,9.94,8.97,7.84,6.91,7.22,7.28,8.31,9.78,10.12,9.94,8.75,7.88,6.91,5.44,4.84,4.28,3.31,2.97,1.91,2.34,2.41,1.84,3.19,2.88,2.12,1.72,0.38,-0.94,-2.12,-2.97,-2.12,-2.69,-2.38,-2.5,-2.31,-2.47,-2.03,-1.94,-1.53,-1.66,-1.22,-1.22,-0.69,-0.47,-0.22,-0.78,-2.03,-2.84,-3.84,-4.41,-3.69,-2.59,-1.16,-0.03,1.31,2.06,3.38,3.62,4.88,4.97,4.91,4.16,2.47,0.44,-1.84,-3.09,-4.41,-4.91,-4.62,-4.94,-4.38,-4.72,-4.16,-4.34,-4.84,-4.97,-4.91,-5.03,-4.47,-3.97,-3.84,-3.59,-3.06,-2.28,0.31,4.0,9.06,14.28,17.88,20.06,19.56,18.0,13.62,8.62,4.41,0.66,-0.94,-2.34,-2.69,-2.47,-2.47,-3.16,-4.34,-4.34,-4.75,-5.91,-5.81,-5.22,-5.78,-4.91,-4.62,-4.03,-3.31,-2.72,-2.75,-1.34,-2.59,-1.84,-1.66,-1.22,-2.16,-2.5,-3.03,-4.22,-4.59,-4.91,-4.66,-3.94,-4.03,15.28,14.91,14.69,14.31,14.12,14.62,16.03,18.5,21.84,24.78,27.84,29.25,29.0,29.25,27.0,26.69,25.28,23.69,22.25,20.78,20.12,18.91,18.59,20.41:35.91,34.88,33.62,33.03,31.91,31.66,32.0,32.78,33.59,34.66,35.16,35.28,34.62,33.16,31.44,29.12,27.94,27.09,27.44,28.66,31.34,33.53,35.38,36.41,37.5,36.97,36.38,35.06,33.03,30.38,27.5,25.38,23.41,22.81,22.31,20.66,19.16,17.78,14.38,12.34,10.94,8.78,7.88,7.31,7.16,6.31,7.66,8.94,11.09,14.41,16.88,19.47,20.09,20.06,19.66,18.19,16.5,15.41,14.84,13.22,12.41,11.38,11.09,11.56,12.88,15.12,18.56,21.22,22.88,23.69,23.16,23.28,23.28,23.41,23.34,25.38,26.0,25.81,25.25,24.94,23.69,24.06,23.06,24.41,25.91,27.19,29.44,31.88,34.16,37.44,40.19,41.94,42.34,41.78,40.09,37.94,35.84,34.31,33.12,32.66,31.38,31.69,30.25,29.91,28.06,26.47,24.72,22.5,20.5,19.34,17.94,17.91,18.16,17.94,18.16,18.5,19.19,20.0,20.94,22.28,23.34,23.81,24.91,24.75,24.62,24.0,22.97,21.84,21.03,20.41,21.03,21.69,22.94,24.53,26.5,26.66,26.84,26.66,25.94,24.84,24.72,24.44,24.31,23.84,23.19,21.78,21.78,21.97,23.34,26.09,28.41,30.62,33.16,34.0,35.19,36.06,35.94,36.31,34.66,33.59,31.91,30.09,28.75,28.34,28.31,27.75,28.06,28.03,28.5,26.91,27.53,27.03,25.88,26.31,25.88,26.19,26.94,28.53,30.84,32.94,33.91,34.5,33.59,32.53,30.88,31.25,30.94,30.16,29.62,28.0,25.03,23.06,21.16,19.25,18.53,18.34,17.75,16.94,16.31,15.75,16.06,17.06,19.03,21.28,23.47,24.47,23.81,22.81,21.5,20.47,19.41,17.78,17.12,16.5,15.81,16.31,16.88,17.88,18.56,19.19,18.62,18.56,17.5,16.84,16.09,14.94,15.06,14.12,12.62,12.22,11.81,12.44,13.88,16.81,19.28,21.81,24.56,27.56,28.91,30.31,31.31,31.31,31.81,31.75,32.59,33.28,33.53,32.81,33.5,32.94,32.09,32.5,31.38,30.12,29.25,28.38,27.56,27.88,28.34,28.44,28.0,27.5,25.47,23.97,23.0,22.38,21.69,22.19,23.03,22.75,23.69,24.31,25.78,27.09,27.78,29.75,29.81,30.28,30.19,29.12,28.03,27.12,26.44,26.16,25.53,25.72,27.19,28.28,30.97,33.66,36.62,38.38,40.06,41.31,40.94,40.5,39.69,37.81,35.47,33.28,29.25,25.81,23.06,19.31,16.34,15.47,15.22,15.53,18.31,22.88,27.41,34.28,38.09,41.31,42.34,40.81,38.38,34.88,32.81,30.88,28.66,26.66,24.38,22.25,19.81,18.66,19.53,20.38,23.16,26.03,28.44,31.31,33.31,34.59,34.88,34.62,33.5,31.19,27.78,24.91,21.12,18.56,15.81,13.94,13.0,13.31,13.75,15.78,18.84,21.69,24.97,27.38,28.41,29.41,29.66,29.44,29.31,30.0,29.94,29.72,28.56,26.81,24.72,22.78,20.97,20.72,19.72,19.53,19.06,18.41,17.94,18.0,18.44,19.66,21.0,23.94,26.38,28.75,31.81,33.19,34.38,35.25,34.62,33.5,31.81,29.62,28.72,26.75,24.62,24.19,22.56,20.25,19.88,18.94,17.16,17.12,16.28,15.97,16.06,15.66,15.97,14.97,13.47,13.25,12.12,12.16,12.91,14.5,17.0,19.19,21.84,22.88,23.5,23.69,22.84,21.81,21.03,21.25,20.75,20.41,20.59,19.72,17.78,16.56,14.81,12.66,12.19,11.47,11.06,12.34,14.12,15.59,15.94,17.19,16.91,16.22,16.94,17.53,17.88,18.72,19.06,18.75,18.38,18.34,17.72,15.38,14.62,12.38,10.59,9.25,8.66,8.16,8.59,8.41,9.19,10.0,11.09,11.72,13.12,14.22,14.94,16.09,16.66,17.66,17.84,18.25,17.78,17.25,17.47,17.25,18.25,20.0,21.44,23.62,24.25,25.41,24.62,23.94,22.81,21.38,20.94,20.53,21.41,21.62,22.59,24.06,24.69,25.41,25.81,25.94,24.62,23.69,21.56,19.38,17.84,16.22,14.84,14.59,14.28,13.94,14.62,14.78,13.81,14.06,13.31,13.12,13.06,13.25,15.03,15.62,16.16,17.62,17.53,18.06,17.81,17.56,18.16,17.97,17.84,18.47,18.72,18.94,19.88,20.28,21.34,21.69,22.0,23.72,24.66,25.47,26.75,26.56,27.09,26.72,27.5,28.19,28.84,29.97,29.41,29.19,28.72,27.34,25.94,24.0,21.31,18.28,15.88,13.56,12.19,11.47,11.66,12.16,14.06,13.88,13.72,13.38,10.97,9.56,6.91,5.25,4.06,3.38,2.41,3.0,2.56,2.81,2.06,3.06,3.72,5.69,8.69,12.59,17.28,22.53,25.59,27.78,28.66,26.94,24.66,21.5,18.19,15.84,14.06,12.81,12.41,12.44,11.78,11.81,11.66,11.16,9.56,8.75,7.59,6.22,5.44,4.53,4.31,4.47,3.88,3.78,4.28,4.44,4.75,6.31,7.56,8.91,10.72,11.66,11.97,10.81,9.75,8.16,6.94,6.06,5.62,4.69,4.94,4.94,6.19,7.44,10.78,13.16,15.25,16.5,16.69,15.25,15.47,13.66,13.31,12.91,12.38,11.19,10.81,9.5,8.88,8.12,8.31,7.84,8.41,9.41,9.38,10.88,11.34,11.59,12.38,12.59,11.44,11.34,10.59,9.97,9.25,8.53,8.56,8.09,8.84,8.91,9.19,9.75,8.91,8.56,8.44,8.84,9.53,10.97,12.72,14.72,15.81,17.78,18.19,18.19,18.53,18.56,17.66,18.06,17.62,18.0,18.5,18.88,19.38,18.91,18.28,16.16,14.22,12.31,11.44,11.47,12.0,13.0,14.19,13.12,13.28,12.34,11.41,10.53,9.38,8.12,6.91,5.81,4.38,3.78,3.94,3.97,4.25,4.88,5.12,5.53,5.31,6.0,7.16,8.78,10.75,11.78,13.34,14.59,15.66,16.19,16.81,16.66,15.75,13.16,11.44,9.0,7.56,5.94,6.0,6.34,7.28,9.16,9.69,10.31,9.81,10.44,10.12,10.56,10.94,11.25,11.22,9.94,8.97,7.84,6.91,7.22,7.28,8.31,9.78,10.12,9.94,8.75,7.88,6.91,5.44,4.84,4.28,3.31,2.97,1.91,2.34,2.41,1.84,3.19,2.88,2.12,1.72,0.38,-0.94,-2.12,-2.97,-2.12,-2.69,-2.38,-2.5,-2.31,-2.47,-2.03,-1.94,-1.53,-1.66,-1.22,-1.22,-0.69,-0.47,-0.22,-0.78,-2.03,-2.84,-3.84,-4.41,-3.69,-2.59,-1.16,-0.03,1.31,2.06,3.38,3.62,4.88,4.97,4.91,4.16,2.47,0.44,-1.84,-3.09,-4.41,-4.91,-4.62,-4.94,-4.38,-4.72,-4.16,-4.34,-4.84,-4.97,-4.91,-5.03,-4.47,-3.97,-3.84,-3.59,-3.06,-2.28,0.31,4.0,9.06,14.28,17.88,20.06,19.56,18.0,13.62,8.62,4.41,0.66,-0.94,-2.34,-2.69,-2.47,-2.47,-3.16,-4.34,-4.34,-4.75,-5.91,-5.81,-5.22,-5.78,-4.91,-4.62,-4.03,-3.31,-2.72,-2.75,-1.34,-2.59,-1.84,-1.66,-1.22,-2.16,-2.5,-3.03,-4.22,-4.59,-4.91,-4.66,-3.94,-4.03,15.28,14.91,14.69,14.31,14.12,14.62,16.03,18.5,21.84,24.78,27.84,29.25,29.0,29.25,27.0,26.69,25.28,23.69,22.25,20.78,20.12,18.91,18.59,20.41,22.66,24.34,27.03,29.44,30.06,29.31:positivity
23.84,23.84,23.03,22.84,23.28,22.78,22.94,22.03,21.66,21.09,22.06,21.06,21.78,22.0,22.66,24.31,25.25,25.06,27.25,26.78,27.88,29.28,29.81,30.0,29.5,28.0,27.16,25.56,23.81,22.84,21.94,22.16,21.0,21.78,23.72,24.16,27.34,28.81,32.28,33.5,34.59,36.0,36.69,36.91,37.19,36.78,35.91,34.56,31.56,29.0,25.06,21.91,18.31,15.03,13.53,13.09,11.12,11.5,11.44,10.72,10.16,8.56,6.53,3.06,-0.47,-4.28,-6.44,-7.84,-7.22,-5.34,-3.88,-0.31,2.84,3.0,4.66,4.31,3.19,2.38,1.72,1.28,2.16,1.97,2.09,2.69,3.19,5.66,8.38,11.31,14.22,17.31,17.44,16.56,16.28,15.06,14.72,14.06,14.66,14.38,13.56,13.28,12.22,10.12,8.12,6.03,3.47,1.59,1.25,0.28,1.59,1.56,1.97,2.41,3.12,4.72,6.06,8.41,11.44,13.5,14.94,16.12,16.09,15.38,14.94,15.59,14.25,14.75,14.0,13.56,13.03,13.78,13.12,14.22,14.5,14.94,14.59,14.19,13.28,12.34,10.94,9.97,10.0,10.12,11.03,12.03,11.91,11.44,11.0,11.84,12.5,13.69,15.88,17.03,17.66,19.28,18.5,18.38,18.12,16.75,16.5,16.09,15.94,16.19,15.78,15.91,17.78,17.94,18.94,20.28,20.0,20.44,19.97,20.66,20.34,21.16,21.28,22.0,22.06,21.25,21.69,20.31,20.19,19.66,19.03,18.06,17.75,17.12,17.12,17.34,19.06,20.5,23.25,24.22,24.97,27.78,27.19,27.19,26.72,27.44,26.25,26.5,26.91,26.66,26.59,27.59,26.97,27.81,28.38,28.06,27.56,28.62,28.5,30.59,33.88,37.75,42.16,47.28,49.88,51.94,52.25,50.38,47.0,43.28,39.69,35.72,31.88,30.12,29.84,28.94,29.38,30.06,29.91,28.62,26.72,25.5,24.19,23.97,23.56,24.03,24.75,25.84,26.72,26.56,27.66,26.41,24.31,22.91,20.19,18.34,17.56,16.97,17.38,18.56,19.69,21.97,22.94,24.06,24.53,24.78,24.5,24.84,25.22,25.62,28.19,29.62,29.62,30.41,31.06,30.75,30.84,31.19,32.09,32.81,32.75,33.06,33.31,33.03,31.25,30.41,28.94,27.44,25.75,24.0,24.94,23.44,24.38,25.31,25.09,25.69,25.16,24.66,24.28,23.16,20.28,18.09,15.25,11.97,10.16,10.31,11.12,13.59,14.34,16.06,16.78,16.69,16.28,16.12,16.69,16.28,17.47,18.06,20.44,21.09,22.72,23.19,23.62,23.03,22.59,22.66,22.91,22.56,23.19,24.78,25.84,26.59,27.0,27.25,26.66,25.75,24.44,23.53,21.66,21.0,20.53,21.25,22.03,24.47,25.25,25.12,25.69,24.81,24.0,24.19,24.59,25.69,26.81,26.91,27.44,26.53,26.19,25.91,25.69,26.78,27.75,29.31,31.16,32.34,33.5,34.09,33.66,34.09,32.97,32.06,31.66,30.31,29.0,27.38,26.62,24.16,23.94,23.31,22.69,23.88,23.81,24.28,24.53,25.12,25.44,25.41,25.53,23.81,23.59,22.69,21.31,21.0,21.16,21.44,22.53,23.56,25.19,26.66,27.19,28.41,28.62,28.81,29.22,29.75,30.41,31.91,32.41,32.19,32.25,29.72,28.06,25.81,23.75,22.31,20.88,20.06,19.41,19.09,19.31,19.19,19.44,18.75,19.41,18.69,18.84,18.84,18.72,18.97,19.44,20.31,20.31,20.41,21.16,21.25,21.53,22.03,22.75,23.09,23.09,23.56,23.53,23.62,23.47,21.94,21.84,19.5,17.59,17.44,15.69,15.06,14.28,12.91,11.34,9.34,7.47,6.56,4.47,3.59,4.03,3.03,3.19,3.5,3.44,3.53,3.91,3.62,4.28,4.72,4.44,5.25,4.31,3.5,3.41,2.06,2.78,3.38,3.94,5.56,7.94,9.97,13.62,17.69,20.88,22.69,23.56,22.12,19.38,17.41,14.88,14.22,13.72,14.06,14.53,14.38,14.12,14.5,14.94,15.47,16.19,16.19,16.56,15.78,14.28,13.41,11.03,10.5,8.12,7.12,6.84,6.44,6.75,7.56,9.12,9.56,11.53,12.34,12.81,13.94,12.91,12.44,11.81,10.56,8.84,8.66,7.03,6.38,5.41,4.53,4.06,4.47,4.69,5.94,6.69,7.84,8.94,10.0,12.31,14.06,16.31,17.78,19.56,19.12,18.38,18.69,16.53,15.38,14.81,13.44,12.5,12.16,11.5,11.62,10.78,11.25,10.22,9.75,9.06,7.41,7.28,5.81,5.84,5.69,5.16,5.06,4.88,4.53,4.69,5.25,6.69,7.53,8.25,8.91,8.91,8.97,8.44,8.91,9.0,9.0,9.91,9.94,10.41,10.91,12.44,13.81,15.84,17.94,18.41,19.56,19.62,19.69,19.19,18.03,16.94,14.72,13.03,11.34,10.38,11.22,11.84,13.25,14.0,14.16,13.69,12.41,11.66,11.0,11.97,12.78,14.03,15.25,15.25,15.56,14.06,12.91,11.31,9.12,7.28,7.16,6.53,6.44,7.62,8.53,9.75,10.72,11.09,12.16,12.03,11.44,12.78,12.81,13.12,13.66,13.28,12.78,12.28,12.03,11.62,11.34,12.19,12.12,12.5,11.91,12.19,12.5,12.28,14.5,15.94,17.41,17.97,18.09,17.69,18.5,18.5,19.38,20.31,20.38,20.5,19.75,19.06,19.38,17.97,16.0,15.28,13.28,13.41,11.47,11.41,11.28,10.72,10.31,12.12,13.5,15.84,18.44,21.31,23.0,25.41,26.0,26.16,25.84,23.69,22.38,22.0,21.81,22.97,24.66,25.91,27.19,27.5,27.59,26.28,24.59,21.75,18.97,16.28,14.25,14.31,14.41,16.78,18.38,20.19,21.19,20.88,19.03,16.69,15.44,13.38,14.12,14.5,15.66,16.06,16.03,15.12,13.75,11.91,11.56,10.53,10.94,11.09,11.41,12.69,13.03,13.66,14.25,14.62,14.28,14.81,14.94,15.0,14.81,14.53,13.09,12.81,12.5,12.41,13.75,14.66,15.78,17.97,20.22,23.38,27.12,30.53,31.12,31.78,30.09,25.44,20.62,16.91,13.31,11.16,10.72,10.69,11.84,12.81,13.97,15.28,16.59,16.59,16.06,14.41,13.44,11.44,10.41,11.31,11.69,13.34,14.59,16.78,17.75,18.69,20.31,20.31,20.5,19.53,18.66,17.34,17.41,17.16,18.19,19.97,20.5,20.22,19.5,18.59,18.03,18.31,18.59,19.44,20.69,21.44,22.25,22.75,24.25,24.38,23.84,22.91,23.0,21.5,21.62,20.75,22.03,23.06,24.0,26.47,28.91,32.22,34.56,36.03,37.72,36.78,33.88,31.81,29.25,25.19,22.0,18.44,15.94,13.28,12.56,13.66,15.66,18.0,20.34,22.16,23.53,24.28,24.06,24.06,23.47,21.31,19.94,18.69,16.53,15.19,14.38,13.69,13.62,13.56,13.19,12.88,12.22,9.69,10.44,8.88,9.19,10.03,11.22,12.56,15.72,17.56,20.75,23.06,24.56,25.97,25.81,24.34,23.03,20.56,17.78,15.56,13.56,11.19,10.78,9.09,7.41,7.47,6.62,6.28,6.59,6.97,6.75,7.41,8.12,8.62,9.31,9.28,9.47,8.28,7.78,8.25,8.03,8.69,8.72,8.22,7.31,5.19,3.81,2.09,1.28,2.06,3.44,4.66,7.41,10.16,10.88,13.44,13.19,12.75,11.94,9.81,7.97,5.41,4.75:22.94,22.03,21.66,21.09,22.06,21.06,21.78,22.0,22.66,24.31,25.25,25.06,27.25,26.78,27.88,29.28,29.81,30.0,29.5,28.0,27.16,25.56,23.81,22.84,21.94,22.16,21.0,21.78,23.72,24.16,27.34,28.81,32.28,33.5,34.59,36.0,36.69,36.91,37.19,36.78,35.91,34.56,31.56,29.0,25.06,21.91,18.31,15.03,13.53,13.09,11.12,11.5,11.44,10.72,10.16,8.56,6.53,3.06,-0.47,-4.28,-6.44,-7.84,-7.22,-5.34,-3.88,-0.31,2.84,3.0,4.66,4.31,3.19,2.38,1.72,1.28,2.16,1.97,2.09,2.69,3.19,5.66,8.38,11.31,14.22,17.31,17.44,16.56,16.28,15.06,14.72,14.06,14.66,14.38,13.56,13.28,12.22,10.12,8.12,6.03,3.47,1.59,1.25,0.28,1.59,1.56,1.97,2.41,3.12,4.72,6.06,8.41,11.44,13.5,14.94,16.12,16.09,15.38,14.94,15.59,14.25,14.75,14.0,13.56,13.03,13.78,13.12,14.22,14.5,14.94,14.59,14.19,13.28,12.34,10.94,9.97,10.0,10.12,11.03,12.03,11.91,11.44,11.0,11.84,12.5,13.69,15.88,17.03,17.66,19.28,18.5,18.38,18.12,16.75,16.5,16.09,15.94,16.19,15.78,15.91,17.78,17.94,18.94,20.28,20.0,20.44,19.97,20.66,20.34,21.16,21.28,22.0,22.06,21.25,21.69,20.31,20.19,19.66,19.03,18.06,17.75,17.12,17.12,17.34,19.06,20.5,23.25,24.22,24.97,27.78,27.19,27.19,26.72,27.44,26.25,26.5,26.91,26.66,26.59,27.59,26.97,27.81,28.38,28.06,27.56,28.62,28.5,30.59,33.88,37.75,42.16,47.28,49.88,51.94,52.25,50.38,47.0,43.28,39.69,35.72,31.88,30.12,29.84,28.94,29.38,30.06,29.91,28.62,26.72,25.5,24.19,23.97,23.56,24.03,24.75,25.84,26.72,26.56,27.66,26.41,24.31,22.91,20.19,18.34,17.56,16.97,17.38,18.56,19.69,21.97,22.94,24.06,24.53,24.78,24.5,24.84,25.22,25.62,28.19,29.62,29.62,30.41,31.06,30.75,30.84,31.19,32.09,32.81,32.75,33.06,33.31,33.03,31.25,30.41,28.94,27.44,25.75,24.0,24.94,23.44,24.38,25.31,25.09,25.69,25.16,24.66,24.28,23.16,20.28,18.09,15.25,11.97,10.16,10.31,11.12,13.59,14.34,16.06,16.78,16.69,16.28,16.12,16.69,16.28,17.47,18.06,20.44,21.09,22.72,23.19,23.62,23.03,22.59,22.66,22.91,22.56,23.19,24.78,25.84,26.59,27.0,27.25,26.66,25.75,24.44,23.53,21.66,21.0,20.53,21.25,22.03,24.47,25.25,25.12,25.69,24.81,24.0,24.19,24.59,25.69,26.81,26.91,27.44,26.53,26.19,25.91,25.69,26.78,27.75,29.31,31.16,32.34,33.5,34.09,33.66,34.09,32.97,32.06,31.66,30.31,29.0,27.38,26.62,24.16,23.94,23.31,22.69,23.88,23.81,24.28,24.53,25.12,25.44,25.41,25.53,23.81,23.59,22.69,21.31,21.0,21.16,21.44,22.53,23.56,25.19,26.66,27.19,28.41,28.62,28.81,29.22,29.75,30.41,31.91,32.41,32.19,32.25,29.72,28.06,25.81,23.75,22.31,20.88,20.06,19.41,19.09,19.31,19.19,19.44,18.75,19.41,18.69,18.84,18.84,18.72,18.97,19.44,20.31,20.31,20.41,21.16,21.25,21.53,22.03,22.75,23.09,23.09,23.56,23.53,23.62,23.47,21.94,21.84,19.5,17.59,17.44,15.69,15.06,14.28,12.91,11.34,9.34,7.47,6.56,4.47,3.59,4.03,3.03,3.19,3.5,3.44,3.53,3.91,3.62,4.28,4.72,4.44,5.25,4.31,3.5,3.41,2.06,2.78,3.38,3.94,5.56,7.94,9.97,13.62,17.69,20.88,22.69,23.56,22.12,19.38,17.41,14.88,14.22,13.72,14.06,14.53,14.38,14.12,14.5,14.94,15.47,16.19,16.19,16.56,15.78,14.28,13.41,11.03,10.5,8.12,7.12,6.84,6.44,6.75,7.56,9.12,9.56,11.53,12.34,12.81,13.94,12.91,12.44,11.81,10.56,8.84,8.66,7.03,6.38,5.41,4.53,4.06,4.47,4.69,5.94,6.69,7.84,8.94,10.0,12.31,14.06,16.31,17.78,19.56,19.12,18.38,18.69,16.53,15.38,14.81,13.44,12.5,12.16,11.5,11.62,10.78,11.25,10.22,9.75,9.06,7.41,7.28,5.81,5.84,5.69,5.16,5.06,4.88,4.53,4.69,5.25,6.69,7.53,8.25,8.91,8.91,8.97,8.44,8.91,9.0,9.0,9.91,9.94,10.41,10.91,12.44,13.81,15.84,17.94,18.41,19.56,19.62,19.69,19.19,18.03,16.94,14.72,13.03,11.34,10.38,11.22,11.84,13.25,14.0,14.16,13.69,12.41,11.66,11.0,11.97,12.78,14.03,15.25,15.25,15.56,14.06,12.91,11.31,9.12,7.28,7.16,6.53,6.44,7.62,8.53,9.75,10.72,11.09,12.16,12.03,11.44,12.78,12.81,13.12,13.66,13.28,12.78,12.28,12.03,11.62,11.34,12.19,12.12,12.5,11.91,12.19,12.5,12.28,14.5,15.94,17.41,17.97,18.09,17.69,18.5,18.5,19.38,20.31,20.38,20.5,19.75,19.06,19.38,17.97,16.0,15.28,13.28,13.41,11.47,11.41,11.28,10.72,10.31,12.12,13.5,15.84,18.44,21.31,23.0,25.41,26.0,26.16,25.84,23.69,22.38,22.0,21.81,22.97,24.66,25.91,27.19,27.5,27.59,26.28,24.59,21.75,18.97,16.28,14.25,14.31,14.41,16.78,18.38,20.19,21.19,20.88,19.03,16.69,15.44,13.38,14.12,14.5,15.66,16.06,16.03,15.12,13.75,11.91,11.56,10.53,10.94,11.09,11.41,12.69,13.03,13.66,14.25,14.62,14.28,14.81,14.94,15.0,14.81,14.53,13.09,12.81,12.5,12.41,13.75,14.66,15.78,17.97,20.22,23.38,27.12,30.53,31.12,31.78,30.09,25.44,20.62,16.91,13.31,11.16,10.72,10.69,11.84,12.81,13.97,15.28,16.59,16.59,16.06,14.41,13.44,11.44,10.41,11.31,11.69,13.34,14.59,16.78,17.75,18.69,20.31,20.31,20.5,19.53,18.66,17.34,17.41,17.16,18.19,19.97,20.5,20.22,19.5,18.59,18.03,18.31,18.59,19.44,20.69,21.44,22.25,22.75,24.25,24.38,23.84,22.91,23.0,21.5,21.62,20.75,22.03,23.06,24.0,26.47,28.91,32.22,34.56,36.03,37.72,36.78,33.88,31.81,29.25,25.19,22.0,18.44,15.94,13.28,12.56,13.66,15.66,18.0,20.34,22.16,23.53,24.28,24.06,24.06,23.47,21.31,19.94,18.69,16.53,15.19,14.38,13.69,13.62,13.56,13.19,12.88,12.22,9.69,10.44,8.88,9.19,10.03,11.22,12.56,15.72,17.56,20.75,23.06,24.56,25.97,25.81,24.34,23.03,20.56,17.78,15.56,13.56,11.19,10.78,9.09,7.41,7.47,6.62,6.28,6.59,6.97,6.75,7.41,8.12,8.62,9.31,9.28,9.47,8.28,7.78,8.25,8.03,8.69,8.72,8.22,7.31,5.19,3.81,2.09,1.28,2.06,3.44,4.66,7.41,10.16,10.88,13.44,13.19,12.75,11.94,9.81,7.97,5.41,4.75,7.56,7.28,5.88,6.0,4.94,4.72:21.78,22.0,22.66,24.31,25.25,25.06,27.25,26.78,27.88,29.28,29.81,30.0,29.5,28.0,27.16,25.56,23.81,22.84,21.94,22.16,21.0,21.78,23.72,24.16,27.34,28.81,32.28,33.5,34.59,36.0,36.69,36.91,37.19,36.78,35.91,34.56,31.56,29.0,25.06,21.91,18.31,15.03,13.53,13.09,11.12,11.5,11.44,10.72,10.16,8.56,6.53,3.06,-0.47,-4.28,-6.44,-7.84,-7.22,-5.34,-3.88,-0.31,2.84,3.0,4.66,4.31,3.19,2.38,1.72,1.28,2.16,1.97,2.09,2.69,3.19,5.66,8.38,11.31,14.22,17.31,17.44,16.56,16.28,15.06,14.72,14.06,14.66,14.38,13.56,13.28,12.22,10.12,8.12,6.03,3.47,1.59,1.25,0.28,1.59,1.56,1.97,2.41,3.12,4.72,6.06,8.41,11.44,13.5,14.94,16.12,16.09,15.38,14.94,15.59,14.25,14.75,14.0,13.56,13.03,13.78,13.12,14.22,14.5,14.94,14.59,14.19,13.28,12.34,10.94,9.97,10.0,10.12,11.03,12.03,11.91,11.44,11.0,11.84,12.5,13.69,15.88,17.03,17.66,19.28,18.5,18.38,18.12,16.75,16.5,16.09,15.94,16.19,15.78,15.91,17.78,17.94,18.94,20.28,20.0,20.44,19.97,20.66,20.34,21.16,21.28,22.0,22.06,21.25,21.69,20.31,20.19,19.66,19.03,18.06,17.75,17.12,17.12,17.34,19.06,20.5,23.25,24.22,24.97,27.78,27.19,27.19,26.72,27.44,26.25,26.5,26.91,26.66,26.59,27.59,26.97,27.81,28.38,28.06,27.56,28.62,28.5,30.59,33.88,37.75,42.16,47.28,49.88,51.94,52.25,50.38,47.0,43.28,39.69,35.72,31.88,30.12,29.84,28.94,29.38,30.06,29.91,28.62,26.72,25.5,24.19,23.97,23.56,24.03,24.75,25.84,26.72,26.56,27.66,26.41,24.31,22.91,20.19,18.34,17.56,16.97,17.38,18.56,19.69,21.97,22.94,24.06,24.53,24.78,24.5,24.84,25.22,25.62,28.19,29.62,29.62,30.41,31.06,30.75,30.84,31.19,32.09,32.81,32.75,33.06,33.31,33.03,31.25,30.41,28.94,27.44,25.75,24.0,24.94,23.44,24.38,25.31,25.09,25.69,25.16,24.66,24.28,23.16,20.28,18.09,15.25,11.97,10.16,10.31,11.12,13.59,14.34,16.06,16.78,16.69,16.28,16.12,16.69,16.28,17.47,18.06,20.44,21.09,22.72,23.19,23.62,23.03,22.59,22.66,22.91,22.56,23.19,24.78,25.84,26.59,27.0,27.25,26.66,25.75,24.44,23.53,21.66,21.0,20.53,21.25,22.03,24.47,25.25,25.12,25.69,24.81,24.0,24.19,24.59,25.69,26.81,26.91,27.44,26.53,26.19,25.91,25.69,26.78,27.75,29.31,31.16,32.34,33.5,34.09,33.66,34.09,32.97,32.06,31.66,30.31,29.0,27.38,26.62,24.16,23.94,23.31,22.69,23.88,23.81,24.28,24.53,25.12,25.44,25.41,25.53,23.81,23.59,22.69,21.31,21.0,21.16,21.44,22.53,23.56,25.19,26.66,27.19,28.41,28.62,28.81,29.22,29.75,30.41,31.91,32.41,32.19,32.25,29.72,28.06,25.81,23.75,22.31,20.88,20.06,19.41,19.09,19.31,19.19,19.44,18.75,19.41,18.69,18.84,18.84,18.72,18.97,19.44,20.31,20.31,20.41,21.16,21.25,21.53,22.03,22.75,23.09,23.09,23.56,23.53,23.62,23.47,21.94,21.84,19.5,17.59,17.44,15.69,15.06,14.28,12.91,11.34,9.34,7.47,6.56,4.47,3.59,4.03,3.03,3.19,3.5,3.44,3.53,3.91,3.62,4.28,4.72,4.44,5.25,4.31,3.5,3.41,2.06,2.78,3.38,3.94,5.56,7.94,9.97,13.62,17.69,20.88,22.69,23.56,22.12,19.38,17.41,14.88,14.22,13.72,14.06,14.53,14.38,14.12,14.5,14.94,15.47,16.19,16.19,16.56,15.78,14.28,13.41,11.03,10.5,8.12,7.12,6.84,6.44,6.75,7.56,9.12,9.56,11.53,12.34,12.81,13.94,12.91,12.44,11.81,10.56,8.84,8.66,7.03,6.38,5.41,4.53,4.06,4.47,4.69,5.94,6.69,7.84,8.94,10.0,12.31,14.06,16.31,17.78,19.56,19.12,18.38,18.69,16.53,15.38,14.81,13.44,12.5,12.16,11.5,11.62,10.78,11.25,10.22,9.75,9.06,7.41,7.28,5.81,5.84,5.69,5.16,5.06,4.88,4.53,4.69,5.25,6.69,7.53,8.25,8.91,8.91,8.97,8.44,8.91,9.0,9.0,9.91,9.94,10.41,10.91,12.44,13.81,15.84,17.94,18.41,19.56,19.62,19.69,19.19,18.03,16.94,14.72,13.03,11.34,10.38,11.22,11.84,13.25,14.0,14.16,13.69,12.41,11.66,11.0,11.97,12.78,14.03,15.25,15.25,15.56,14.06,12.91,11.31,9.12,7.28,7.16,6.53,6.44,7.62,8.53,9.75,10.72,11.09,12.16,12.03,11.44,12.78,12.81,13.12,13.66,13.28,12.78,12.28,12.03,11.62,11.34,12.19,12.12,12.5,11.91,12.19,12.5,12.28,14.5,15.94,17.41,17.97,18.09,17.69,18.5,18.5,19.38,20.31,20.38,20.5,19.75,19.06,19.38,17.97,16.0,15.28,13.28,13.41,11.47,11.41,11.28,10.72,10.31,12.12,13.5,15.84,18.44,21.31,23.0,25.41,26.0,26.16,25.84,23.69,22.38,22.0,21.81,22.97,24.66,25.91,27.19,27.5,27.59,26.28,24.59,21.75,18.97,16.28,14.25,14.31,14.41,16.78,18.38,20.19,21.19,20.88,19.03,16.69,15.44,13.38,14.12,14.5,15.66,16.06,16.03,15.12,13.75,11.91,11.56,10.53,10.94,11.09,11.41,12.69,13.03,13.66,14.25,14.62,14.28,14.81,14.94,15.0,14.81,14.53,13.09,12.81,12.5,12.41,13.75,14.66,15.78,17.97,20.22,23.38,27.12,30.53,31.12,31.78,30.09,25.44,20.62,16.91,13.31,11.16,10.72,10.69,11.84,12.81,13.97,15.28,16.59,16.59,16.06,14.41,13.44,11.44,10.41,11.31,11.69,13.34,14.59,16.78,17.75,18.69,20.31,20.31,20.5,19.53,18.66,17.34,17.41,17.16,18.19,19.97,20.5,20.22,19.5,18.59,18.03,18.31,18.59,19.44,20.69,21.44,22.25,22.75,24.25,24.38,23.84,22.91,23.0,21.5,21.62,20.75,22.03,23.06,24.0,26.47,28.91,32.22,34.56,36.03,37.72,36.78,33.88,31.81,29.25,25.19,22.0,18.44,15.94,13.28,12.56,13.66,15.66,18.0,20.34,22.16,23.53,24.28,24.06,24.06,23.47,21.31,19.94,18.69,16.53,15.19,14.38,13.69,13.62,13.56,13.19,12.88,12.22,9.69,10.44,8.88,9.19,10.03,11.22,12.56,15.72,17.56,20.75,23.06,24.56,25.97,25.81,24.34,23.03,20.56,17.78,15.56,13.56,11.19,10.78,9.09,7.41,7.47,6.62,6.28,6.59,6.97,6.75,7.41,8.12,8.62,9.31,9.28,9.47,8.28,7.78,8.25,8.03,8.69,8.72,8.22,7.31,5.19,3.81,2.09,1.28,2.06,3.44,4.66,7.41,10.16,10.88,13.44,13.19,12.75,11.94,9.81,7.97,5.41,4.75,7.56,7.28,5.88,6.0,4.94,4.72,3.28,1.97,1.56,0.28,-0.34,0.34:27.25,26.78,27.88,29.28,29.81,30.0,29.5,28.0,27.16,25.56,23.81,22.84,21.94,22.16,21.0,21.78,23.72,24.16,27.34,28.81,32.28,33.5,34.59,36.0,36.69,36.91,37.19,36.78,35.91,34.56,31.56,29.0,25.06,21.91,18.31,15.03,13.53,13.09,11.12,11.5,11.44,10.72,10.16,8.56,6.53,3.06,-0.47,-4.28,-6.44,-7.84,-7.22,-5.34,-3.88,-0.31,2.84,3.0,4.66,4.31,3.19,2.38,1.72,1.28,2.16,1.97,2.09,2.69,3.19,5.66,8.38,11.31,14.22,17.31,17.44,16.56,16.28,15.06,14.72,14.06,14.66,14.38,13.56,13.28,12.22,10.12,8.12,6.03,3.47,1.59,1.25,0.28,1.59,1.56,1.97,2.41,3.12,4.72,6.06,8.41,11.44,13.5,14.94,16.12,16.09,15.38,14.94,15.59,14.25,14.75,14.0,13.56,13.03,13.78,13.12,14.22,14.5,14.94,14.59,14.19,13.28,12.34,10.94,9.97,10.0,10.12,11.03,12.03,11.91,11.44,11.0,11.84,12.5,13.69,15.88,17.03,17.66,19.28,18.5,18.38,18.12,16.75,16.5,16.09,15.94,16.19,15.78,15.91,17.78,17.94,18.94,20.28,20.0,20.44,19.97,20.66,20.34,21.16,21.28,22.0,22.06,21.25,21.69,20.31,20.19,19.66,19.03,18.06,17.75,17.12,17.12,17.34,19.06,20.5,23.25,24.22,24.97,27.78,27.19,27.19,26.72,27.44,26.25,26.5,26.91,26.66,26.59,27.59,26.97,27.81,28.38,28.06,27.56,28.62,28.5,30.59,33.88,37.75,42.16,47.28,49.88,51.94,52.25,50.38,47.0,43.28,39.69,35.72,31.88,30.12,29.84,28.94,29.38,30.06,29.91,28.62,26.72,25.5,24.19,23.97,23.56,24.03,24.75,25.84,26.72,26.56,27.66,26.41,24.31,22.91,20.19,18.34,17.56,16.97,17.38,18.56,19.69,21.97,22.94,24.06,24.53,24.78,24.5,24.84,25.22,25.62,28.19,29.62,29.62,30.41,31.06,30.75,30.84,31.19,32.09,32.81,32.75,33.06,33.31,33.03,31.25,30.41,28.94,27.44,25.75,24.0,24.94,23.44,24.38,25.31,25.09,25.69,25.16,24.66,24.28,23.16,20.28,18.09,15.25,11.97,10.16,10.31,11.12,13.59,14.34,16.06,16.78,16.69,16.28,16.12,16.69,16.28,17.47,18.06,20.44,21.09,22.72,23.19,23.62,23.03,22.59,22.66,22.91,22.56,23.19,24.78,25.84,26.59,27.0,27.25,26.66,25.75,24.44,23.53,21.66,21.0,20.53,21.25,22.03,24.47,25.25,25.12,25.69,24.81,24.0,24.19,24.59,25.69,26.81,26.91,27.44,26.53,26.19,25.91,25.69,26.78,27.75,29.31,31.16,32.34,33.5,34.09,33.66,34.09,32.97,32.06,31.66,30.31,29.0,27.38,26.62,24.16,23.94,23.31,22.69,23.88,23.81,24.28,24.53,25.12,25.44,25.41,25.53,23.81,23.59,22.69,21.31,21.0,21.16,21.44,22.53,23.56,25.19,26.66,27.19,28.41,28.62,28.81,29.22,29.75,30.41,31.91,32.41,32.19,32.25,29.72,28.06,25.81,23.75,22.31,20.88,20.06,19.41,19.09,19.31,19.19,19.44,18.75,19.41,18.69,18.84,18.84,18.72,18.97,19.44,20.31,20.31,20.41,21.16,21.25,21.53,22.03,22.75,23.09,23.09,23.56,23.53,23.62,23.47,21.94,21.84,19.5,17.59,17.44,15.69,15.06,14.28,12.91,11.34,9.34,7.47,6.56,4.47,3.59,4.03,3.03,3.19,3.5,3.44,3.53,3.91,3.62,4.28,4.72,4.44,5.25,4.31,3.5,3.41,2.06,2.78,3.38,3.94,5.56,7.94,9.97,13.62,17.69,20.88,22.69,23.56,22.12,19.38,17.41,14.88,14.22,13.72,14.06,14.53,14.38,14.12,14.5,14.94,15.47,16.19,16.19,16.56,15.78,14.28,13.41,11.03,10.5,8.12,7.12,6.84,6.44,6.75,7.56,9.12,9.56,11.53,12.34,12.81,13.94,12.91,12.44,11.81,10.56,8.84,8.66,7.03,6.38,5.41,4.53,4.06,4.47,4.69,5.94,6.69,7.84,8.94,10.0,12.31,14.06,16.31,17.78,19.56,19.12,18.38,18.69,16.53,15.38,14.81,13.44,12.5,12.16,11.5,11.62,10.78,11.25,10.22,9.75,9.06,7.41,7.28,5.81,5.84,5.69,5.16,5.06,4.88,4.53,4.69,5.25,6.69,7.53,8.25,8.91,8.91,8.97,8.44,8.91,9.0,9.0,9.91,9.94,10.41,10.91,12.44,13.81,15.84,17.94,18.41,19.56,19.62,19.69,19.19,18.03,16.94,14.72,13.03,11.34,10.38,11.22,11.84,13.25,14.0,14.16,13.69,12.41,11.66,11.0,11.97,12.78,14.03,15.25,15.25,15.56,14.06,12.91,11.31,9.12,7.28,7.16,6.53,6.44,7.62,8.53,9.75,10.72,11.09,12.16,12.03,11.44,12.78,12.81,13.12,13.66,13.28,12.78,12.28,12.03,11.62,11.34,12.19,12.12,12.5,11.91,12.19,12.5,12.28,14.5,15.94,17.41,17.97,18.09,17.69,18.5,18.5,19.38,20.31,20.38,20.5,19.75,19.06,19.38,17.97,16.0,15.28,13.28,13.41,11.47,11.41,11.28,10.72,10.31,12.12,13.5,15.84,18.44,21.31,23.0,25.41,26.0,26.16,25.84,23.69,22.38,22.0,21.81,22.97,24.66,25.91,27.19,27.5,27.59,26.28,24.59,21.75,18.97,16.28,14.25,14.31,14.41,16.78,18.38,20.19,21.19,20.88,19.03,16.69,15.44,13.38,14.12,14.5,15.66,16.06,16.03,15.12,13.75,11.91,11.56,10.53,10.94,11.09,11.41,12.69,13.03,13.66,14.25,14.62,14.28,14.81,14.94,15.0,14.81,14.53,13.09,12.81,12.5,12.41,13.75,14.66,15.78,17.97,20.22,23.38,27.12,30.53,31.12,31.78,30.09,25.44,20.62,16.91,13.31,11.16,10.72,10.69,11.84,12.81,13.97,15.28,16.59,16.59,16.06,14.41,13.44,11.44,10.41,11.31,11.69,13.34,14.59,16.78,17.75,18.69,20.31,20.31,20.5,19.53,18.66,17.34,17.41,17.16,18.19,19.97,20.5,20.22,19.5,18.59,18.03,18.31,18.59,19.44,20.69,21.44,22.25,22.75,24.25,24.38,23.84,22.91,23.0,21.5,21.62,20.75,22.03,23.06,24.0,26.47,28.91,32.22,34.56,36.03,37.72,36.78,33.88,31.81,29.25,25.19,22.0,18.44,15.94,13.28,12.56,13.66,15.66,18.0,20.34,22.16,23.53,24.28,24.06,24.06,23.47,21.31,19.94,18.69,16.53,15.19,14.38,13.69,13.62,13.56,13.19,12.88,12.22,9.69,10.44,8.88,9.19,10.03,11.22,12.56,15.72,17.56,20.75,23.06,24.56,25.97,25.81,24.34,23.03,20.56,17.78,15.56,13.56,11.19,10.78,9.09,7.41,7.47,6.62,6.28,6.59,6.97,6.75,7.41,8.12,8.62,9.31,9.28,9.47,8.28,7.78,8.25,8.03,8.69,8.72,8.22,7.31,5.19,3.81,2.09,1.28,2.06,3.44,4.66,7.41,10.16,10.88,13.44,13.19,12.75,11.94,9.81,7.97,5.41,4.75,7.56,7.28,5.88,6.0,4.94,4.72,3.28,1.97,1.56,0.28,-0.34,0.34,0.34,-0.03,0.28,0.47,2.25,4.34:29.5,28.0,27.16,25.56,23.81,22.84,21.94,22.16,21.0,21.78,23.72,24.16,27.34,28.81,32.28,33.5,34.59,36.0,36.69,36.91,37.19,36.78,35.91,34.56,31.56,29.0,25.06,21.91,18.31,15.03,13.53,13.09,11.12,11.5,11.44,10.72,10.16,8.56,6.53,3.06,-0.47,-4.28,-6.44,-7.84,-7.22,-5.34,-3.88,-0.31,2.84,3.0,4.66,4.31,3.19,2.38,1.72,1.28,2.16,1.97,2.09,2.69,3.19,5.66,8.38,11.31,14.22,17.31,17.44,16.56,16.28,15.06,14.72,14.06,14.66,14.38,13.56,13.28,12.22,10.12,8.12,6.03,3.47,1.59,1.25,0.28,1.59,1.56,1.97,2.41,3.12,4.72,6.06,8.41,11.44,13.5,14.94,16.12,16.09,15.38,14.94,15.59,14.25,14.75,14.0,13.56,13.03,13.78,13.12,14.22,14.5,14.94,14.59,14.19,13.28,12.34,10.94,9.97,10.0,10.12,11.03,12.03,11.91,11.44,11.0,11.84,12.5,13.69,15.88,17.03,17.66,19.28,18.5,18.38,18.12,16.75,16.5,16.09,15.94,16.19,15.78,15.91,17.78,17.94,18.94,20.28,20.0,20.44,19.97,20.66,20.34,21.16,21.28,22.0,22.06,21.25,21.69,20.31,20.19,19.66,19.03,18.06,17.75,17.12,17.12,17.34,19.06,20.5,23.25,24.22,24.97,27.78,27.19,27.19,26.72,27.44,26.25,26.5,26.91,26.66,26.59,27.59,26.97,27.81,28.38,28.06,27.56,28.62,28.5,30.59,33.88,37.75,42.16,47.28,49.88,51.94,52.25,50.38,47.0,43.28,39.69,35.72,31.88,30.12,29.84,28.94,29.38,30.06,29.91,28.62,26.72,25.5,24.19,23.97,23.56,24.03,24.75,25.84,26.72,26.56,27.66,26.41,24.31,22.91,20.19,18.34,17.56,16.97,17.38,18.56,19.69,21.97,22.94,24.06,24.53,24.78,24.5,24.84,25.22,25.62,28.19,29.62,29.62,30.41,31.06,30.75,30.84,31.19,32.09,32.81,32.75,33.06,33.31,33.03,31.25,30.41,28.94,27.44,25.75,24.0,24.94,23.44,24.38,25.31,25.09,25.69,25.16,24.66,24.28,23.16,20.28,18.09,15.25,11.97,10.16,10.31,11.12,13.59,14.34,16.06,16.78,16.69,16.28,16.12,16.69,16.28,17.47,18.06,20.44,21.09,22.72,23.19,23.62,23.03,22.59,22.66,22.91,22.56,23.19,24.78,25.84,26.59,27.0,27.25,26.66,25.75,24.44,23.53,21.66,21.0,20.53,21.25,22.03,24.47,25.25,25.12,25.69,24.81,24.0,24.19,24.59,25.69,26.81,26.91,27.44,26.53,26.19,25.91,25.69,26.78,27.75,29.31,31.16,32.34,33.5,34.09,33.66,34.09,32.97,32.06,31.66,30.31,29.0,27.38,26.62,24.16,23.94,23.31,22.69,23.88,23.81,24.28,24.53,25.12,25.44,25.41,25.53,23.81,23.59,22.69,21.31,21.0,21.16,21.44,22.53,23.56,25.19,26.66,27.19,28.41,28.62,28.81,29.22,29.75,30.41,31.91,32.41,32.19,32.25,29.72,28.06,25.81,23.75,22.31,20.88,20.06,19.41,19.09,19.31,19.19,19.44,18.75,19.41,18.69,18.84,18.84,18.72,18.97,19.44,20.31,20.31,20.41,21.16,21.25,21.53,22.03,22.75,23.09,23.09,23.56,23.53,23.62,23.47,21.94,21.84,19.5,17.59,17.44,15.69,15.06,14.28,12.91,11.34,9.34,7.47,6.56,4.47,3.59,4.03,3.03,3.19,3.5,3.44,3.53,3.91,3.62,4.28,4.72,4.44,5.25,4.31,3.5,3.41,2.06,2.78,3.38,3.94,5.56,7.94,9.97,13.62,17.69,20.88,22.69,23.56,22.12,19.38,17.41,14.88,14.22,13.72,14.06,14.53,14.38,14.12,14.5,14.94,15.47,16.19,16.19,16.56,15.78,14.28,13.41,11.03,10.5,8.12,7.12,6.84,6.44,6.75,7.56,9.12,9.56,11.53,12.34,12.81,13.94,12.91,12.44,11.81,10.56,8.84,8.66,7.03,6.38,5.41,4.53,4.06,4.47,4.69,5.94,6.69,7.84,8.94,10.0,12.31,14.06,16.31,17.78,19.56,19.12,18.38,18.69,16.53,15.38,14.81,13.44,12.5,12.16,11.5,11.62,10.78,11.25,10.22,9.75,9.06,7.41,7.28,5.81,5.84,5.69,5.16,5.06,4.88,4.53,4.69,5.25,6.69,7.53,8.25,8.91,8.91,8.97,8.44,8.91,9.0,9.0,9.91,9.94,10.41,10.91,12.44,13.81,15.84,17.94,18.41,19.56,19.62,19.69,19.19,18.03,16.94,14.72,13.03,11.34,10.38,11.22,11.84,13.25,14.0,14.16,13.69,12.41,11.66,11.0,11.97,12.78,14.03,15.25,15.25,15.56,14.06,12.91,11.31,9.12,7.28,7.16,6.53,6.44,7.62,8.53,9.75,10.72,11.09,12.16,12.03,11.44,12.78,12.81,13.12,13.66,13.28,12.78,12.28,12.03,11.62,11.34,12.19,12.12,12.5,11.91,12.19,12.5,12.28,14.5,15.94,17.41,17.97,18.09,17.69,18.5,18.5,19.38,20.31,20.38,20.5,19.75,19.06,19.38,17.97,16.0,15.28,13.28,13.41,11.47,11.41,11.28,10.72,10.31,12.12,13.5,15.84,18.44,21.31,23.0,25.41,26.0,26.16,25.84,23.69,22.38,22.0,21.81,22.97,24.66,25.91,27.19,27.5,27.59,26.28,24.59,21.75,18.97,16.28,14.25,14.31,14.41,16.78,18.38,20.19,21.19,20.88,19.03,16.69,15.44,13.38,14.12,14.5,15.66,16.06,16.03,15.12,13.75,11.91,11.56,10.53,10.94,11.09,11.41,12.69,13.03,13.66,14.25,14.62,14.28,14.81,14.94,15.0,14.81,14.53,13.09,12.81,12.5,12.41,13.75,14.66,15.78,17.97,20.22,23.38,27.12,30.53,31.12,31.78,30.09,25.44,20.62,16.91,13.31,11.16,10.72,10.69,11.84,12.81,13.97,15.28,16.59,16.59,16.06,14.41,13.44,11.44,10.41,11.31,11.69,13.34,14.59,16.78,17.75,18.69,20.31,20.31,20.5,19.53,18.66,17.34,17.41,17.16,18.19,19.97,20.5,20.22,19.5,18.59,18.03,18.31,18.59,19.44,20.69,21.44,22.25,22.75,24.25,24.38,23.84,22.91,23.0,21.5,21.62,20.75,22.03,23.06,24.0,26.47,28.91,32.22,34.56,36.03,37.72,36.78,33.88,31.81,29.25,25.19,22.0,18.44,15.94,13.28,12.56,13.66,15.66,18.0,20.34,22.16,23.53,24.28,24.06,24.06,23.47,21.31,19.94,18.69,16.53,15.19,14.38,13.69,13.62,13.56,13.19,12.88,12.22,9.69,10.44,8.88,9.19,10.03,11.22,12.56,15.72,17.56,20.75,23.06,24.56,25.97,25.81,24.34,23.03,20.56,17.78,15.56,13.56,11.19,10.78,9.09,7.41,7.47,6.62,6.28,6.59,6.97,6.75,7.41,8.12,8.62,9.31,9.28,9.47,8.28,7.78,8.25,8.03,8.69,8.72,8.22,7.31,5.19,3.81,2.09,1.28,2.06,3.44,4.66,7.41,10.16,10.88,13.44,13.19,12.75,11.94,9.81,7.97,5.41,4.75,7.56,7.28,5.88,6.0,4.94,4.72,3.28,1.97,1.56,0.28,-0.34,0.34,0.34,-0.03,0.28,0.47,2.25,4.34,6.44,8.38,9.91,11.38,11.31,12.19:21.94,22.16,21.0,21.78,23.72,24.16,27.34,28.81,32.28,33.5,34.59,36.0,36.69,36.91,37.19,36.78,35.91,34.56,31.56,29.0,25.06,21.91,18.31,15.03,13.53,13.09,11.12,11.5,11.44,10.72,10.16,8.56,6.53,3.06,-0.47,-4.28,-6.44,-7.84,-7.22,-5.34,-3.88,-0.31,2.84,3.0,4.66,4.31,3.19,2.38,1.72,1.28,2.16,1.97,2.09,2.69,3.19,5.66,8.38,11.31,14.22,17.31,17.44,16.56,16.28,15.06,14.72,14.06,14.66,14.38,13.56,13.28,12.22,10.12,8.12,6.03,3.47,1.59,1.25,0.28,1.59,1.56,1.97,2.41,3.12,4.72,6.06,8.41,11.44,13.5,14.94,16.12,16.09,15.38,14.94,15.59,14.25,14.75,14.0,13.56,13.03,13.78,13.12,14.22,14.5,14.94,14.59,14.19,13.28,12.34,10.94,9.97,10.0,10.12,11.03,12.03,11.91,11.44,11.0,11.84,12.5,13.69,15.88,17.03,17.66,19.28,18.5,18.38,18.12,16.75,16.5,16.09,15.94,16.19,15.78,15.91,17.78,17.94,18.94,20.28,20.0,20.44,19.97,20.66,20.34,21.16,21.28,22.0,22.06,21.25,21.69,20.31,20.19,19.66,19.03,18.06,17.75,17.12,17.12,17.34,19.06,20.5,23.25,24.22,24.97,27.78,27.19,27.19,26.72,27.44,26.25,26.5,26.91,26.66,26.59,27.59,26.97,27.81,28.38,28.06,27.56,28.62,28.5,30.59,33.88,37.75,42.16,47.28,49.88,51.94,52.25,50.38,47.0,43.28,39.69,35.72,31.88,30.12,29.84,28.94,29.38,30.06,29.91,28.62,26.72,25.5,24.19,23.97,23.56,24.03,24.75,25.84,26.72,26.56,27.66,26.41,24.31,22.91,20.19,18.34,17.56,16.97,17.38,18.56,19.69,21.97,22.94,24.06,24.53,24.78,24.5,24.84,25.22,25.62,28.19,29.62,29.62,30.41,31.06,30.75,30.84,31.19,32.09,32.81,32.75,33.06,33.31,33.03,31.25,30.41,28.94,27.44,25.75,24.0,24.94,23.44,24.38,25.31,25.09,25.69,25.16,24.66,24.28,23.16,20.28,18.09,15.25,11.97,10.16,10.31,11.12,13.59,14.34,16.06,16.78,16.69,16.28,16.12,16.69,16.28,17.47,18.06,20.44,21.09,22.72,23.19,23.62,23.03,22.59,22.66,22.91,22.56,23.19,24.78,25.84,26.59,27.0,27.25,26.66,25.75,24.44,23.53,21.66,21.0,20.53,21.25,22.03,24.47,25.25,25.12,25.69,24.81,24.0,24.19,24.59,25.69,26.81,26.91,27.44,26.53,26.19,25.91,25.69,26.78,27.75,29.31,31.16,32.34,33.5,34.09,33.66,34.09,32.97,32.06,31.66,30.31,29.0,27.38,26.62,24.16,23.94,23.31,22.69,23.88,23.81,24.28,24.53,25.12,25.44,25.41,25.53,23.81,23.59,22.69,21.31,21.0,21.16,21.44,22.53,23.56,25.19,26.66,27.19,28.41,28.62,28.81,29.22,29.75,30.41,31.91,32.41,32.19,32.25,29.72,28.06,25.81,23.75,22.31,20.88,20.06,19.41,19.09,19.31,19.19,19.44,18.75,19.41,18.69,18.84,18.84,18.72,18.97,19.44,20.31,20.31,20.41,21.16,21.25,21.53,22.03,22.75,23.09,23.09,23.56,23.53,23.62,23.47,21.94,21.84,19.5,17.59,17.44,15.69,15.06,14.28,12.91,11.34,9.34,7.47,6.56,4.47,3.59,4.03,3.03,3.19,3.5,3.44,3.53,3.91,3.62,4.28,4.72,4.44,5.25,4.31,3.5,3.41,2.06,2.78,3.38,3.94,5.56,7.94,9.97,13.62,17.69,20.88,22.69,23.56,22.12,19.38,17.41,14.88,14.22,13.72,14.06,14.53,14.38,14.12,14.5,14.94,15.47,16.19,16.19,16.56,15.78,14.28,13.41,11.03,10.5,8.12,7.12,6.84,6.44,6.75,7.56,9.12,9.56,11.53,12.34,12.81,13.94,12.91,12.44,11.81,10.56,8.84,8.66,7.03,6.38,5.41,4.53,4.06,4.47,4.69,5.94,6.69,7.84,8.94,10.0,12.31,14.06,16.31,17.78,19.56,19.12,18.38,18.69,16.53,15.38,14.81,13.44,12.5,12.16,11.5,11.62,10.78,11.25,10.22,9.75,9.06,7.41,7.28,5.81,5.84,5.69,5.16,5.06,4.88,4.53,4.69,5.25,6.69,7.53,8.25,8.91,8.91,8.97,8.44,8.91,9.0,9.0,9.91,9.94,10.41,10.91,12.44,13.81,15.84,17.94,18.41,19.56,19.62,19.69,19.19,18.03,16.94,14.72,13.03,11.34,10.38,11.22,11.84,13.25,14.0,14.16,13.69,12.41,11.66,11.0,11.97,12.78,14.03,15.25,15.25,15.56,14.06,12.91,11.31,9.12,7.28,7.16,6.53,6.44,7.62,8.53,9.75,10.72,11.09,12.16,12.03,11.44,12.78,12.81,13.12,13.66,13.28,12.78,12.28,12.03,11.62,11.34,12.19,12.12,12.5,11.91,12.19,12.5,12.28,14.5,15.94,17.41,17.97,18.09,17.69,18.5,18.5,19.38,20.31,20.38,20.5,19.75,19.06,19.38,17.97,16.0,15.28,13.28,13.41,11.47,11.41,11.28,10.72,10.31,12.12,13.5,15.84,18.44,21.31,23.0,25.41,26.0,26.16,25.84,23.69,22.38,22.0,21.81,22.97,24.66,25.91,27.19,27.5,27.59,26.28,24.59,21.75,18.97,16.28,14.25,14.31,14.41,16.78,18.38,20.19,21.19,20.88,19.03,16.69,15.44,13.38,14.12,14.5,15.66,16.06,16.03,15.12,13.75,11.91,11.56,10.53,10.94,11.09,11.41,12.69,13.03,13.66,14.25,14.62,14.28,14.81,14.94,15.0,14.81,14.53,13.09,12.81,12.5,12.41,13.75,14.66,15.78,17.97,20.22,23.38,27.12,30.53,31.12,31.78,30.09,25.44,20.62,16.91,13.31,11.16,10.72,10.69,11.84,12.81,13.97,15.28,16.59,16.59,16.06,14.41,13.44,11.44,10.41,11.31,11.69,13.34,14.59,16.78,17.75,18.69,20.31,20.31,20.5,19.53,18.66,17.34,17.41,17.16,18.19,19.97,20.5,20.22,19.5,18.59,18.03,18.31,18.59,19.44,20.69,21.44,22.25,22.75,24.25,24.38,23.84,22.91,23.0,21.5,21.62,20.75,22.03,23.06,24.0,26.47,28.91,32.22,34.56,36.03,37.72,36.78,33.88,31.81,29.25,25.19,22.0,18.44,15.94,13.28,12.56,13.66,15.66,18.0,20.34,22.16,23.53,24.28,24.06,24.06,23.47,21.31,19.94,18.69,16.53,15.19,14.38,13.69,13.62,13.56,13.19,12.88,12.22,9.69,10.44,8.88,9.19,10.03,11.22,12.56,15.72,17.56,20.75,23.06,24.56,25.97,25.81,24.34,23.03,20.56,17.78,15.56,13.56,11.19,10.78,9.09,7.41,7.47,6.62,6.28,6.59,6.97,6.75,7.41,8.12,8.62,9.31,9.28,9.47,8.28,7.78,8.25,8.03,8.69,8.72,8.22,7.31,5.19,3.81,2.09,1.28,2.06,3.44,4.66,7.41,10.16,10.88,13.44,13.19,12.75,11.94,9.81,7.97,5.41,4.75,7.56,7.28,5.88,6.0,4.94,4.72,3.28,1.97,1.56,0.28,-0.34,0.34,0.34,-0.03,0.28,0.47,2.25,4.34,6.44,8.38,9.91,11.38,11.31,12.19,11.97,11.56,9.22,7.16,4.28,0.75:positivity
12.31,13.19,14.34,15.0,16.22,17.88,18.03,20.19,20.06,19.97,18.44,17.78,14.88,13.78,13.56,13.78,12.69,16.0,17.84,20.12,22.06,24.56,26.78,27.12,28.0,30.38,30.81,31.44,32.09,32.09,29.31,29.12,28.03,24.38,23.47,22.72,21.78,20.81,21.94,22.09,21.81,22.59,22.53,23.81,26.25,27.56,28.81,31.0,30.28,29.0,28.16,26.62,23.97,23.31,23.31,22.5,22.56,22.56,21.69,19.97,19.88,20.53,19.38,20.06,21.66,24.19,25.22,27.62,27.28,26.12,23.03,18.72,16.28,14.19,11.72,12.22,10.59,10.5,11.81,11.69,14.09,17.19,19.22,22.03,23.47,25.0,26.06,25.72,26.19,26.38,25.12,25.47,26.12,25.88,28.12,28.03,28.22,28.84,30.31,31.25,32.5,35.09,36.69,38.41,38.25,41.12,41.47,40.91,42.69,42.81,43.31,44.06,44.59,45.25,45.62,44.84,45.44,43.94,44.66,44.31,43.62,43.22,41.62,42.34,41.16,42.97,41.94,44.66,45.44,45.41,46.81,48.31,47.47,48.84,50.53,48.81,49.78,49.97,49.03,47.72,48.44,47.66,47.03,46.91,46.19,42.81,40.47,38.72,35.72,33.66,33.25,33.78,31.91,33.62,35.12,35.91,40.19,42.31,43.31,43.91,41.66,39.53,36.69,35.62,35.5,35.22,36.06,35.16,33.66,31.75,30.41,27.56,26.19,26.19,26.34,27.84,29.44,32.81,34.12,36.38,38.06,39.38,40.47,39.56,37.47,36.53,33.97,30.56,29.94,27.16,27.12,25.59,24.56,22.0,20.41,19.34,16.66,16.75,17.69,20.12,22.03,22.53,24.5,26.94,30.12,32.25,35.06,37.5,36.94,35.31,35.12,34.41,32.94,33.97,34.31,35.62,36.38,38.44,41.59,42.28,41.41,40.34,38.09,35.53,34.16,33.53,34.22,34.56,35.66,36.72,39.31,40.56,42.81,43.81,43.53,41.19,39.97,38.69,37.25,36.31,34.19,32.16,31.06,28.12,25.62,24.72,23.38,22.12,20.5,21.5,21.72,21.88,23.59,24.91,27.25,28.91,31.22,33.62,35.12,35.09,36.06,35.97,36.19,36.62,37.81,37.91,36.78,36.47,32.97,31.53,31.31,30.97,33.03,32.66,31.72,31.44,31.06,30.62,31.44,32.75,36.44,37.34,39.94,42.69,45.0,46.06,45.78,45.81,44.44,41.41,40.56,37.56,35.38,33.84,32.44,31.72,31.12,32.16,33.0,33.34,34.38,35.09,35.78,37.06,36.62,37.62,37.41,37.25,38.5,38.5,40.97,41.19,42.03,42.75,43.44,41.56,41.25,41.47,42.06,43.94,46.62,48.03,49.06,48.06,45.25,42.66,39.59,38.12,37.03,37.84,38.47,40.12,42.5,43.5,44.44,44.09,43.12,42.88,40.91,40.16,40.97,40.38,41.31,41.41,40.44,40.0,37.94,36.97,36.44,36.44,36.62,36.66,36.53,34.66,35.12,35.0,35.69,36.31,38.0,38.5,38.22,37.06,35.56,35.16,33.75,33.06,34.72,34.38,34.31,34.69,35.34,35.28,35.5,36.69,36.75,39.0,40.0,41.69,43.09,44.97,45.78,44.44,45.06,43.69,42.78,41.16,39.31,36.06,35.44,32.69,32.19,32.12,33.78,34.53,36.0,37.31,37.78,38.41,38.69,37.5,38.91,37.47,38.41,38.94,39.31,39.22,39.38,39.41,38.66,38.22,35.41,34.03,33.72,32.78,32.28,32.41,33.47,34.06,33.72,34.5,34.59,36.81,37.44,39.19,39.94,40.5,40.72,39.81,36.62,35.78,32.72,29.31,28.06,26.12,24.94,23.62,25.0,24.69,25.12,26.47,26.03,24.88,25.41,23.28,22.59,23.53,24.62,25.31,27.09,29.16,30.34,32.31,32.12,31.34,31.22,31.0,32.59,34.16,35.66,39.59,40.03,41.03,42.88,42.34,43.91,43.66,43.69,43.59,44.06,43.12,42.62,41.5,40.94,40.75,40.25,38.03,36.88,34.12,31.47,30.0,29.34,29.03,29.69,29.91,30.56,31.19,32.97,35.12,37.19,38.94,40.81,43.31,44.47,45.94,49.78,49.44,49.25,49.09,47.31,45.44,46.0,43.84,44.56,45.25,42.84,41.56,39.97,38.5,36.03,35.34,33.72,33.03,31.41,31.09,30.91,32.25,32.91,36.69,38.66,40.19,41.81,42.47,40.97,39.16,38.31,37.0,36.66,38.47,40.56,41.66,42.81,43.94,44.84,44.91,44.06,43.59,41.38,38.75,36.53,35.12,36.09,36.44,39.72,43.5,45.78,47.94,49.94,49.44,47.28,45.44,41.66,40.31,37.03,35.31,33.06,32.59,29.56,30.31,30.84,31.41,34.41,36.22,38.09,38.22,40.19,40.38,40.12,40.31,42.28,43.06,43.38,45.03,45.28,45.34,45.28,41.78,39.22,35.06,30.66,28.12,24.56,24.19,24.25,25.0,26.94,28.06,29.53,33.19,34.78,38.06,40.0,41.0,43.94,45.25,46.5,48.81,49.47,48.78,45.72,42.66,37.72,33.31,31.59,27.62,27.16,25.84,25.94,26.62,28.06,29.94,32.31,33.94,34.91,37.12,36.0,35.91,36.16,33.81,32.88,30.56,30.19,30.25,29.44,28.56,28.53,28.69,26.91,25.84,24.06,23.03,20.81,20.5,19.34,19.31,21.53,22.09,23.16,27.0,28.03,30.19,32.41,34.69,35.41,36.5,37.28,37.72,38.06,36.62,35.94,33.0,31.5,28.09,24.97,23.31,22.16,19.31,19.28,20.25,20.25,22.16,24.69,26.78,28.38,31.66,33.03,34.28,36.09,35.06,35.16,33.06,31.59,30.66,29.06,29.12,28.09,27.75,26.66,25.12,24.84,23.69,23.62,24.03,24.75,27.56,29.0,31.75,33.56,36.28,37.56,38.03,37.81,38.94,37.31,34.88,32.53,28.81,25.75,21.88,18.56,17.0,15.16,14.56,15.66,15.38,16.34,17.59,18.47,18.81,19.81,20.38,21.62,21.34,21.66,21.44,19.16,19.19,17.12,15.91,16.06,13.66,14.44,14.0,12.31,13.12,14.19,15.19,15.25,16.69,16.56,17.81,17.09,17.94,17.84,18.81,19.56,19.41,20.06,20.12,20.91,21.34,20.97,21.44,21.12,19.91,19.91,19.16,18.06,17.56,15.75,15.12,15.19,15.84,18.0,19.56,22.53,23.81,25.12,26.5,27.47,28.62,26.84,26.44,24.41,22.75,21.53,20.44,19.38,19.78,18.34,18.06,17.0,17.22,17.22,16.81,17.19,16.91,17.91,19.06,20.72,22.19,24.56,24.88,25.56,26.5,26.06,26.59,25.97,25.62,24.69,22.88,21.81,20.0,17.88,15.28,13.44,11.88,11.12,10.94,11.56,13.12,16.66,19.59,23.84,28.78,31.91,33.41,33.59,31.06,28.03,25.12,20.75,17.34,14.69,13.72,12.84,13.12,14.06,14.25,13.41,13.25,11.59,11.38,11.28,11.62,12.34,13.41,14.56,16.41,17.47,17.75,18.0,17.56,15.84,14.34,13.44,11.38,10.78,10.31,10.75,10.25,11.66,11.56,12.5,12.69,11.91,12.38,12.19,12.78,14.94,14.31,16.0,17.78,18.41,19.31,19.81,20.25,19.25,18.75,18.69,18.19,19.09,20.28,20.62,21.28,20.06,20.38,19.78,18.62,18.03,17.25,17.94,19.09,20.78,24.16,25.94,27.25,27.72,26.19,25.03,22.72,21.84,20.97,20.41,20.56,21.12,20.91,20.81,19.31,19.72,17.59,16.91,17.69,17.97,17.56,19.19,21.56:18.03,20.19,20.06,19.97,18.44,17.78,14.88,13.78,13.56,13.78,12.69,16.0,17.84,20.12,22.06,24.56,26.78,27.12,28.0,30.38,30.81,31.44,32.09,32.09,29.31,29.12,28.03,24.38,23.47,22.72,21.78,20.81,21.94,22.09,21.81,22.59,22.53,23.81,26.25,27.56,28.81,31.0,30.28,29.0,28.16,26.62,23.97,23.31,23.31,22.5,22.56,22.56,21.69,19.97,19.88,20.53,19.38,20.06,21.66,24.19,25.22,27.62,27.28,26.12,23.03,18.72,16.28,14.19,11.72,12.22,10.59,10.5,11.81,11.69,14.09,17.19,19.22,22.03,23.47,25.0,26.06,25.72,26.19,26.38,25.12,25.47,26.12,25.88,28.12,28.03,28.22,28.84,30.31,31.25,32.5,35.09,36.69,38.41,38.25,41.12,41.47,40.91,42.69,42.81,43.31,44.06,44.59,45.25,45.62,44.84,45.44,43.94,44.66,44.31,43.62,43.22,41.62,42.34,41.16,42.97,41.94,44.66,45.44,45.41,46.81,48.31,47.47,48.84,50.53,48.81,49.78,49.97,49.03,47.72,48.44,47.66,47.03,46.91,46.19,42.81,40.47,38.72,35.72,33.66,33.25,33.78,31.91,33.62,35.12,35.91,40.19,42.31,43.31,43.91,41.66,39.53,36.69,35.62,35.5,35.22,36.06,35.16,33.66,31.75,30.41,27.56,26.19,26.19,26.34,27.84,29.44,32.81,34.12,36.38,38.06,39.38,40.47,39.56,37.47,36.53,33.97,30.56,29.94,27.16,27.12,25.59,24.56,22.0,20.41,19.34,16.66,16.75,17.69,20.12,22.03,22.53,24.5,26.94,30.12,32.25,35.06,37.5,36.94,35.31,35.12,34.41,32.94,33.97,34.31,35.62,36.38,38.44,41.59,42.28,41.41,40.34,38.09,35.53,34.16,33.53,34.22,34.56,35.66,36.72,39.31,40.56,42.81,43.81,43.53,41.19,39.97,38.69,37.25,36.31,34.19,32.16,31.06,28.12,25.62,24.72,23.38,22.12,20.5,21.5,21.72,21.88,23.59,24.91,27.25,28.91,31.22,33.62,35.12,35.09,36.06,35.97,36.19,36.62,37.81,37.91,36.78,36.47,32.97,31.53,31.31,30.97,33.03,32.66,31.72,31.44,31.06,30.62,31.44,32.75,36.44,37.34,39.94,42.69,45.0,46.06,45.78,45.81,44.44,41.41,40.56,37.56,35.38,33.84,32.44,31.72,31.12,32.16,33.0,33.34,34.38,35.09,35.78,37.06,36.62,37.62,37.41,37.25,38.5,38.5,40.97,41.19,42.03,42.75,43.44,41.56,41.25,41.47,42.06,43.94,46.62,48.03,49.06,48.06,45.25,42.66,39.59,38.12,37.03,37.84,38.47,40.12,42.5,43.5,44.44,44.09,43.12,42.88,40.91,40.16,40.97,40.38,41.31,41.41,40.44,40.0,37.94,36.97,36.44,36.44,36.62,36.66,36.53,34.66,35.12,35.0,35.69,36.31,38.0,38.5,38.22,37.06,35.56,35.16,33.75,33.06,34.72,34.38,34.31,34.69,35.34,35.28,35.5,36.69,36.75,39.0,40.0,41.69,43.09,44.97,45.78,44.44,45.06,43.69,42.78,41.16,39.31,36.06,35.44,32.69,32.19,32.12,33.78,34.53,36.0,37.31,37.78,38.41,38.69,37.5,38.91,37.47,38.41,38.94,39.31,39.22,39.38,39.41,38.66,38.22,35.41,34.03,33.72,32.78,32.28,32.41,33.47,34.06,33.72,34.5,34.59,36.81,37.44,39.19,39.94,40.5,40.72,39.81,36.62,35.78,32.72,29.31,28.06,26.12,24.94,23.62,25.0,24.69,25.12,26.47,26.03,24.88,25.41,23.28,22.59,23.53,24.62,25.31,27.09,29.16,30.34,32.31,32.12,31.34,31.22,31.0,32.59,34.16,35.66,39.59,40.03,41.03,42.88,42.34,43.91,43.66,43.69,43.59,44.06,43.12,42.62,41.5,40.94,40.75,40.25,38.03,36.88,34.12,31.47,30.0,29.34,29.03,29.69,29.91,30.56,31.19,32.97,35.12,37.19,38.94,40.81,43.31,44.47,45.94,49.78,49.44,49.25,49.09,47.31,45.44,46.0,43.84,44.56,45.25,42.84,41.56,39.97,38.5,36.03,35.34,33.72,33.03,31.41,31.09,30.91,32.25,32.91,36.69,38.66,40.19,41.81,42.47,40.97,39.16,38.31,37.0,36.66,38.47,40.56,41.66,42.81,43.94,44.84,44.91,44.06,43.59,41.38,38.75,36.53,35.12,36.09,36.44,39.72,43.5,45.78,47.94,49.94,49.44,47.28,45.44,41.66,40.31,37.03,35.31,33.06,32.59,29.56,30.31,30.84,31.41,34.41,36.22,38.09,38.22,40.19,40.38,40.12,40.31,42.28,43.06,43.38,45.03,45.28,45.34,45.28,41.78,39.22,35.06,30.66,28.12,24.56,24.19,24.25,25.0,26.94,28.06,29.53,33.19,34.78,38.06,40.0,41.0,43.94,45.25,46.5,48.81,49.47,48.78,45.72,42.66,37.72,33.31,31.59,27.62,27.16,25.84,25.94,26.62,28.06,29.94,32.31,33.94,34.91,37.12,36.0,35.91,36.16,33.81,32.88,30.56,30.19,30.25,29.44,28.56,28.53,28.69,26.91,25.84,24.06,23.03,20.81,20.5,19.34,19.31,21.53,22.09,23.16,27.0,28.03,30.19,32.41,34.69,35.41,36.5,37.28,37.72,38.06,36.62,35.94,33.0,31.5,28.09,24.97,23.31,22.16,19.31,19.28,20.25,20.25,22.16,24.69,26.78,28.38,31.66,33.03,34.28,36.09,35.06,35.16,33.06,31.59,30.66,29.06,29.12,28.09,27.75,26.66,25.12,24.84,23.69,23.62,24.03,24.75,27.56,29.0,31.75,33.56,36.28,37.56,38.03,37.81,38.94,37.31,34.88,32.53,28.81,25.75,21.88,18.56,17.0,15.16,14.56,15.66,15.38,16.34,17.59,18.47,18.81,19.81,20.38,21.62,21.34,21.66,21.44,19.16,19.19,17.12,15.91,16.06,13.66,14.44,14.0,12.31,13.12,14.19,15.19,15.25,16.69,16.56,17.81,17.09,17.94,17.84,18.81,19.56,19.41,20.06,20.12,20.91,21.34,20.97,21.44,21.12,19.91,19.91,19.16,18.06,17.56,15.75,15.12,15.19,15.84,18.0,19.56,22.53,23.81,25.12,26.5,27.47,28.62,26.84,26.44,24.41,22.75,21.53,20.44,19.38,19.78,18.34,18.06,17.0,17.22,17.22,16.81,17.19,16.91,17.91,19.06,20.72,22.19,24.56,24.88,25.56,26.5,26.06,26.59,25.97,25.62,24.69,22.88,21.81,20.0,17.88,15.28,13.44,11.88,11.12,10.94,11.56,13.12,16.66,19.59,23.84,28.78,31.91,33.41,33.59,31.06,28.03,25.12,20.75,17.34,14.69,13.72,12.84,13.12,14.06,14.25,13.41,13.25,11.59,11.38,11.28,11.62,12.34,13.41,14.56,16.41,17.47,17.75,18.0,17.56,15.84,14.34,13.44,11.38,10.78,10.31,10.75,10.25,11.66,11.56,12.5,12.69,11.91,12.38,12.19,12.78,14.94,14.31,16.0,17.78,18.41,19.31,19.81,20.25,19.25,18.75,18.69,18.19,19.09,20.28,20.62,21.28,20.06,20.38,19.78,18.62,18.03,17.25,17.94,19.09,20.78,24.16,25.94,27.25,27.72,26.19,25.03,22.72,21.84,20.97,20.41,20.56,21.12,20.91,20.81,19.31,19.72,17.59,16.91,17.69,17.97,17.56,19.19,21.56,10.97,11.94,14.59,16.91,20.5,23.38:14.88,13.78,13.56,13.78,12.69,16.0,17.84,20.12,22.06,24.56,26.78,27.12,28.0,30.38,30.81,31.44,32.09,32.09,29.31,29.12,28.03,24.38,23.47,22.72,21.78,20.81,21.94,22.09,21.81,22.59,22.53,23.81,26.25,27.56,28.81,31.0,30.28,29.0,28.16,26.62,23.97,23.31,23.31,22.5,22.56,22.56,21.69,19.97,19.88,20.53,19.38,20.06,21.66,24.19,25.22,27.62,27.28,26.12,23.03,18.72,16.28,14.19,11.72,12.22,10.59,10.5,11.81,11.69,14.09,17.19,19.22,22.03,23.47,25.0,26.06,25.72,26.19,26.38,25.12,25.47,26.12,25.88,28.12,28.03,28.22,28.84,30.31,31.25,32.5,35.09,36.69,38.41,38.25,41.12,41.47,40.91,42.69,42.81,43.31,44.06,44.59,45.25,45.62,44.84,45.44,43.94,44.66,44.31,43.62,43.22,41.62,42.34,41.16,42.97,41.94,44.66,45.44,45.41,46.81,48.31,47.47,48.84,50.53,48.81,49.78,49.97,49.03,47.72,48.44,47.66,47.03,46.91,46.19,42.81,40.47,38.72,35.72,33.66,33.25,33.78,31.91,33.62,35.12,35.91,40.19,42.31,43.31,43.91,41.66,39.53,36.69,35.62,35.5,35.22,36.06,35.16,33.66,31.75,30.41,27.56,26.19,26.19,26.34,27.84,29.44,32.81,34.12,36.38,38.06,39.38,40.47,39.56,37.47,36.53,33.97,30.56,29.94,27.16,27.12,25.59,24.56,22.0,20.41,19.34,16.66,16.75,17.69,20.12,22.03,22.53,24.5,26.94,30.12,32.25,35.06,37.5,36.94,35.31,35.12,34.41,32.94,33.97,34.31,35.62,36.38,38.44,41.59,42.28,41.41,40.34,38.09,35.53,34.16,33.53,34.22,34.56,35.66,36.72,39.31,40.56,42.81,43.81,43.53,41.19,39.97,38.69,37.25,36.31,34.19,32.16,31.06,28.12,25.62,24.72,23.38,22.12,20.5,21.5,21.72,21.88,23.59,24.91,27.25,28.91,31.22,33.62,35.12,35.09,36.06,35.97,36.19,36.62,37.81,37.91,36.78,36.47,32.97,31.53,31.31,30.97,33.03,32.66,31.72,31.44,31.06,30.62,31.44,32.75,36.44,37.34,39.94,42.69,45.0,46.06,45.78,45.81,44.44,41.41,40.56,37.56,35.38,33.84,32.44,31.72,31.12,32.16,33.0,33.34,34.38,35.09,35.78,37.06,36.62,37.62,37.41,37.25,38.5,38.5,40.97,41.19,42.03,42.75,43.44,41.56,41.25,41.47,42.06,43.94,46.62,48.03,49.06,48.06,45.25,42.66,39.59,38.12,37.03,37.84,38.47,40.12,42.5,43.5,44.44,44.09,43.12,42.88,40.91,40.16,40.97,40.38,41.31,41.41,40.44,40.0,37.94,36.97,36.44,36.44,36.62,36.66,36.53,34.66,35.12,35.0,35.69,36.31,38.0,38.5,38.22,37.06,35.56,35.16,33.75,33.06,34.72,34.38,34.31,34.69,35.34,35.28,35.5,36.69,36.75,39.0,40.0,41.69,43.09,44.97,45.78,44.44,45.06,43.69,42.78,41.16,39.31,36.06,35.44,32.69,32.19,32.12,33.78,34.53,36.0,37.31,37.78,38.41,38.69,37.5,38.91,37.47,38.41,38.94,39.31,39.22,39.38,39.41,38.66,38.22,35.41,34.03,33.72,32.78,32.28,32.41,33.47,34.06,33.72,34.5,34.59,36.81,37.44,39.19,39.94,40.5,40.72,39.81,36.62,35.78,32.72,29.31,28.06,26.12,24.94,23.62,25.0,24.69,25.12,26.47,26.03,24.88,25.41,23.28,22.59,23.53,24.62,25.31,27.09,29.16,30.34,32.31,32.12,31.34,31.22,31.0,32.59,34.16,35.66,39.59,40.03,41.03,42.88,42.34,43.91,43.66,43.69,43.59,44.06,43.12,42.62,41.5,40.94,40.75,40.25,38.03,36.88,34.12,31.47,30.0,29.34,29.03,29.69,29.91,30.56,31.19,32.97,35.12,37.19,38.94,40.81,43.31,44.47,45.94,49.78,49.44,49.25,49.09,47.31,45.44,46.0,43.84,44.56,45.25,42.84,41.56,39.97,38.5,36.03,35.34,33.72,33.03,31.41,31.09,30.91,32.25,32.91,36.69,38.66,40.19,41.81,42.47,40.97,39.16,38.31,37.0,36.66,38.47,40.56,41.66,42.81,43.94,44.84,44.91,44.06,43.59,41.38,38.75,36.53,35.12,36.09,36.44,39.72,43.5,45.78,47.94,49.94,49.44,47.28,45.44,41.66,40.31,37.03,35.31,33.06,32.59,29.56,30.31,30.84,31.41,34.41,36.22,38.09,38.22,40.19,40.38,40.12,40.31,42.28,43.06,43.38,45.03,45.28,45.34,45.28,41.78,39.22,35.06,30.66,28.12,24.56,24.19,24.25,25.0,26.94,28.06,29.53,33.19,34.78,38.06,40.0,41.0,43.94,45.25,46.5,48.81,49.47,48.78,45.72,42.66,37.72,33.31,31.59,27.62,27.16,25.84,25.94,26.62,28.06,29.94,32.31,33.94,34.91,37.12,36.0,35.91,36.16,33.81,32.88,30.56,30.19,30.25,29.44,28.56,28.53,28.69,26.91,25.84,24.06,23.03,20.81,20.5,19.34,19.31,21.53,22.09,23.16,27.0,28.03,30.19,32.41,34.69,35.41,36.5,37.28,37.72,38.06,36.62,35.94,33.0,31.5,28.09,24.97,23.31,22.16,19.31,19.28,20.25,20.25,22.16,24.69,26.78,28.38,31.66,33.03,34.28,36.09,35.06,35.16,33.06,31.59,30.66,29.06,29.12,28.09,27.75,26.66,25.12,24.84,23.69,23.62,24.03,24.75,27.56,29.0,31.75,33.56,36.28,37.56,38.03,37.81,38.94,37.31,34.88,32.53,28.81,25.75,21.88,18.56,17.0,15.16,14.56,15.66,15.38,16.34,17.59,18.47,18.81,19.81,20.38,21.62,21.34,21.66,21.44,19.16,19.19,17.12,15.91,16.06,13.66,14.44,14.0,12.31,13.12,14.19,15.19,15.25,16.69,16.56,17.81,17.09,17.94,17.84,18.81,19.56,19.41,20.06,20.12,20.91,21.34,20.97,21.44,21.12,19.91,19.91,19.16,18.06,17.56,15.75,15.12,15.19,15.84,18.0,19.56,22.53,23.81,25.12,26.5,27.47,28.62,26.84,26.44,24.41,22.75,21.53,20.44,19.38,19.78,18.34,18.06,17.0,17.22,17.22,16.81,17.19,16.91,17.91,19.06,20.72,22.19,24.56,24.88,25.56,26.5,26.06,26.59,25.97,25.62,24.69,22.88,21.81,20.0,17.88,15.28,13.44,11.88,11.12,10.94,11.56,13.12,16.66,19.59,23.84,28.78,31.91,33.41,33.59,31.06,28.03,25.12,20.75,17.34,14.69,13.72,12.84,13.12,14.06,14.25,13.41,13.25,11.59,11.38,11.28,11.62,12.34,13.41,14.56,16.41,17.47,17.75,18.0,17.56,15.84,14.34,13.44,11.38,10.78,10.31,10.75,10.25,11.66,11.56,12.5,12.69,11.91,12.38,12.19,12.78,14.94,14.31,16.0,17.78,18.41,19.31,19.81,20.25,19.25,18.75,18.69,18.19,19.09,20.28,20.62,21.28,20.06,20.38,19.78,18.62,18.03,17.25,17.94,19.09,20.78,24.16,25.94,27.25,27.72,26.19,25.03,22.72,21.84,20.97,20.41,20.56,21.12,20.91,20.81,19.31,19.72,17.59,16.91,17.69,17.97,17.56,19.19,21.56,10.97,11.94,14.59,16.91,20.5,23.38,25.0,27.75,26.91,26.78,24.34,22.38:17.84,20.12,22.06,24.56,26.78,27.12,28.0,30.38,30.81,31.44,32.09,32.09,29.31,29.12,28.03,24.38,23.47,22.72,21.78,20.81,21.94,22.09,21.81,22.59,22.53,23.81,26.25,27.56,28.81,31.0,30.28,29.0,28.16,26.62,23.97,23.31,23.31,22.5,22.56,22.56,21.69,19.97,19.88,20.53,19.38,20.06,21.66,24.19,25.22,27.62,27.28,26.12,23.03,18.72,16.28,14.19,11.72,12.22,10.59,10.5,11.81,11.69,14.09,17.19,19.22,22.03,23.47,25.0,26.06,25.72,26.19,26.38,25.12,25.47,26.12,25.88,28.12,28.03,28.22,28.84,30.31,31.25,32.5,35.09,36.69,38.41,38.25,41.12,41.47,40.91,42.69,42.81,43.31,44.06,44.59,45.25,45.62,44.84,45.44,43.94,44.66,44.31,43.62,43.22,41.62,42.34,41.16,42.97,41.94,44.66,45.44,45.41,46.81,48.31,47.47,48.84,50.53,48.81,49.78,49.97,49.03,47.72,48.44,47.66,47.03,46.91,46.19,42.81,40.47,38.72,35.72,33.66,33.25,33.78,31.91,33.62,35.12,35.91,40.19,42.31,43.31,43.91,41.66,39.53,36.69,35.62,35.5,35.22,36.06,35.16,33.66,31.75,30.41,27.56,26.19,26.19,26.34,27.84,29.44,32.81,34.12,36.38,38.06,39.38,40.47,39.56,37.47,36.53,33.97,30.56,29.94,27.16,27.12,25.59,24.56,22.0,20.41,19.34,16.66,16.75,17.69,20.12,22.03,22.53,24.5,26.94,30.12,32.25,35.06,37.5,36.94,35.31,35.12,34.41,32.94,33.97,34.31,35.62,36.38,38.44,41.59,42.28,41.41,40.34,38.09,35.53,34.16,33.53,34.22,34.56,35.66,36.72,39.31,40.56,42.81,43.81,43.53,41.19,39.97,38.69,37.25,36.31,34.19,32.16,31.06,28.12,25.62,24.72,23.38,22.12,20.5,21.5,21.72,21.88,23.59,24.91,27.25,28.91,31.22,33.62,35.12,35.09,36.06,35.97,36.19,36.62,37.81,37.91,36.78,36.47,32.97,31.53,31.31,30.97,33.03,32.66,31.72,31.44,31.06,30.62,31.44,32.75,36.44,37.34,39.94,42.69,45.0,46.06,45.78,45.81,44.44,41.41,40.56,37.56,35.38,33.84,32.44,31.72,31.12,32.16,33.0,33.34,34.38,35.09,35.78,37.06,36.62,37.62,37.41,37.25,38.5,38.5,40.97,41.19,42.03,42.75,43.44,41.56,41.25,41.47,42.06,43.94,46.62,48.03,49.06,48.06,45.25,42.66,39.59,38.12,37.03,37.84,38.47,40.12,42.5,43.5,44.44,44.09,43.12,42.88,40.91,40.16,40.97,40.38,41.31,41.41,40.44,40.0,37.94,36.97,36.44,36.44,36.62,36.66,36.53,34.66,35.12,35.0,35.69,36.31,38.0,38.5,38.22,37.06,35.56,35.16,33.75,33.06,34.72,34.38,34.31,34.69,35.34,35.28,35.5,36.69,36.75,39.0,40.0,41.69,43.09,44.97,45.78,44.44,45.06,43.69,42.78,41.16,39.31,36.06,35.44,32.69,32.19,32.12,33.78,34.53,36.0,37.31,37.78,38.41,38.69,37.5,38.91,37.47,38.41,38.94,39.31,39.22,39.38,39.41,38.66,38.22,35.41,34.03,33.72,32.78,32.28,32.41,33.47,34.06,33.72,34.5,34.59,36.81,37.44,39.19,39.94,40.5,40.72,39.81,36.62,35.78,32.72,29.31,28.06,26.12,24.94,23.62,25.0,24.69,25.12,26.47,26.03,24.88,25.41,23.28,22.59,23.53,24.62,25.31,27.09,29.16,30.34,32.31,32.12,31.34,31.22,31.0,32.59,34.16,35.66,39.59,40.03,41.03,42.88,42.34,43.91,43.66,43.69,43.59,44.06,43.12,42.62,41.5,40.94,40.75,40.25,38.03,36.88,34.12,31.47,30.0,29.34,29.03,29.69,29.91,30.56,31.19,32.97,35.12,37.19,38.94,40.81,43.31,44.47,45.94,49.78,49.44,49.25,49.09,47.31,45.44,46.0,43.84,44.56,45.25,42.84,41.56,39.97,38.5,36.03,35.34,33.72,33.03,31.41,31.09,30.91,32.25,32.91,36.69,38.66,40.19,41.81,42.47,40.97,39.16,38.31,37.0,36.66,38.47,40.56,41.66,42.81,43.94,44.84,44.91,44.06,43.59,41.38,38.75,36.53,35.12,36.09,36.44,39.72,43.5,45.78,47.94,49.94,49.44,47.28,45.44,41.66,40.31,37.03,35.31,33.06,32.59,29.56,30.31,30.84,31.41,34.41,36.22,38.09,38.22,40.19,40.38,40.12,40.31,42.28,43.06,43.38,45.03,45.28,45.34,45.28,41.78,39.22,35.06,30.66,28.12,24.56,24.19,24.25,25.0,26.94,28.06,29.53,33.19,34.78,38.06,40.0,41.0,43.94,45.25,46.5,48.81,49.47,48.78,45.72,42.66,37.72,33.31,31.59,27.62,27.16,25.84,25.94,26.62,28.06,29.94,32.31,33.94,34.91,37.12,36.0,35.91,36.16,33.81,32.88,30.56,30.19,30.25,29.44,28.56,28.53,28.69,26.91,25.84,24.06,23.03,20.81,20.5,19.34,19.31,21.53,22.09,23.16,27.0,28.03,30.19,32.41,34.69,35.41,36.5,37.28,37.72,38.06,36.62,35.94,33.0,31.5,28.09,24.97,23.31,22.16,19.31,19.28,20.25,20.25,22.16,24.69,26.78,28.38,31.66,33.03,34.28,36.09,35.06,35.16,33.06,31.59,30.66,29.06,29.12,28.09,27.75,26.66,25.12,24.84,23.69,23.62,24.03,24.75,27.56,29.0,31.75,33.56,36.28,37.56,38.03,37.81,38.94,37.31,34.88,32.53,28.81,25.75,21.88,18.56,17.0,15.16,14.56,15.66,15.38,16.34,17.59,18.47,18.81,19.81,20.38,21.62,21.34,21.66,21.44,19.16,19.19,17.12,15.91,16.06,13.66,14.44,14.0,12.31,13.12,14.19,15.19,15.25,16.69,16.56,17.81,17.09,17.94,17.84,18.81,19.56,19.41,20.06,20.12,20.91,21.34,20.97,21.44,21.12,19.91,19.91,19.16,18.06,17.56,15.75,15.12,15.19,15.84,18.0,19.56,22.53,23.81,25.12,26.5,27.47,28.62,26.84,26.44,24.41,22.75,21.53,20.44,19.38,19.78,18.34,18.06,17.0,17.22,17.22,16.81,17.19,16.91,17.91,19.06,20.72,22.19,24.56,24.88,25.56,26.5,26.06,26.59,25.97,25.62,24.69,22.88,21.81,20.0,17.88,15.28,13.44,11.88,11.12,10.94,11.56,13.12,16.66,19.59,23.84,28.78,31.91,33.41,33.59,31.06,28.03,25.12,20.75,17.34,14.69,13.72,12.84,13.12,14.06,14.25,13.41,13.25,11.59,11.38,11.28,11.62,12.34,13.41,14.56,16.41,17.47,17.75,18.0,17.56,15.84,14.34,13.44,11.38,10.78,10.31,10.75,10.25,11.66,11.56,12.5,12.69,11.91,12.38,12.19,12.78,14.94,14.31,16.0,17.78,18.41,19.31,19.81,20.25,19.25,18.75,18.69,18.19,19.09,20.28,20.62,21.28,20.06,20.38,19.78,18.62,18.03,17.25,17.94,19.09,20.78,24.16,25.94,27.25,27.72,26.19,25.03,22.72,21.84,20.97,20.41,20.56,21.12,20.91,20.81,19.31,19.72,17.59,16.91,17.69,17.97,17.56,19.19,21.56,10.97,11.94,14.59,16.91,20.5,23.38,25.0,27.75,26.91,26.78,24.34,22.38,19.56,17.66,15.06,14.16,13.47,13.81:28.0,30.38,30.81,31.44,32.09,32.09,29.31,29.12,28.03,24.38,23.47,22.72,21.78,20.81,21.94,22.09,21.81,22.59,22.53,23.81,26.25,27.56,28.81,31.0,30.28,29.0,28.16,26.62,23.97,23.31,23.31,22.5,22.56,22.56,21.69,19.97,19.88,20.53,19.38,20.06,21.66,24.19,25.22,27.62,27.28,26.12,23.03,18.72,16.28,14.19,11.72,12.22,10.59,10.5,11.81,11.69,14.09,17.19,19.22,22.03,23.47,25.0,26.06,25.72,26.19,26.38,25.12,25.47,26.12,25.88,28.12,28.03,28.22,28.84,30.31,31.25,32.5,35.09,36.69,38.41,38.25,41.12,41.47,40.91,42.69,42.81,43.31,44.06,44.59,45.25,45.62,44.84,45.44,43.94,44.66,44.31,43.62,43.22,41.62,42.34,41.16,42.97,41.94,44.66,45.44,45.41,46.81,48.31,47.47,48.84,50.53,48.81,49.78,49.97,49.03,47.72,48.44,47.66,47.03,46.91,46.19,42.81,40.47,38.72,35.72,33.66,33.25,33.78,31.91,33.62,35.12,35.91,40.19,42.31,43.31,43.91,41.66,39.53,36.69,35.62,35.5,35.22,36.06,35.16,33.66,31.75,30.41,27.56,26.19,26.19,26.34,27.84,29.44,32.81,34.12,36.38,38.06,39.38,40.47,39.56,37.47,36.53,33.97,30.56,29.94,27.16,27.12,25.59,24.56,22.0,20.41,19.34,16.66,16.75,17.69,20.12,22.03,22.53,24.5,26.94,30.12,32.25,35.06,37.5,36.94,35.31,35.12,34.41,32.94,33.97,34.31,35.62,36.38,38.44,41.59,42.28,41.41,40.34,38.09,35.53,34.16,33.53,34.22,34.56,35.66,36.72,39.31,40.56,42.81,43.81,43.53,41.19,39.97,38.69,37.25,36.31,34.19,32.16,31.06,28.12,25.62,24.72,23.38,22.12,20.5,21.5,21.72,21.88,23.59,24.91,27.25,28.91,31.22,33.62,35.12,35.09,36.06,35.97,36.19,36.62,37.81,37.91,36.78,36.47,32.97,31.53,31.31,30.97,33.03,32.66,31.72,31.44,31.06,30.62,31.44,32.75,36.44,37.34,39.94,42.69,45.0,46.06,45.78,45.81,44.44,41.41,40.56,37.56,35.38,33.84,32.44,31.72,31.12,32.16,33.0,33.34,34.38,35.09,35.78,37.06,36.62,37.62,37.41,37.25,38.5,38.5,40.97,41.19,42.03,42.75,43.44,41.56,41.25,41.47,42.06,43.94,46.62,48.03,49.06,48.06,45.25,42.66,39.59,38.12,37.03,37.84,38.47,40.12,42.5,43.5,44.44,44.09,43.12,42.88,40.91,40.16,40.97,40.38,41.31,41.41,40.44,40.0,37.94,36.97,36.44,36.44,36.62,36.66,36.53,34.66,35.12,35.0,35.69,36.31,38.0,38.5,38.22,37.06,35.56,35.16,33.75,33.06,34.72,34.38,34.31,34.69,35.34,35.28,35.5,36.69,36.75,39.0,40.0,41.69,43.09,44.97,45.78,44.44,45.06,43.69,42.78,41.16,39.31,36.06,35.44,32.69,32.19,32.12,33.78,34.53,36.0,37.31,37.78,38.41,38.69,37.5,38.91,37.47,38.41,38.94,39.31,39.22,39.38,39.41,38.66,38.22,35.41,34.03,33.72,32.78,32.28,32.41,33.47,34.06,33.72,34.5,34.59,36.81,37.44,39.19,39.94,40.5,40.72,39.81,36.62,35.78,32.72,29.31,28.06,26.12,24.94,23.62,25.0,24.69,25.12,26.47,26.03,24.88,25.41,23.28,22.59,23.53,24.62,25.31,27.09,29.16,30.34,32.31,32.12,31.34,31.22,31.0,32.59,34.16,35.66,39.59,40.03,41.03,42.88,42.34,43.91,43.66,43.69,43.59,44.06,43.12,42.62,41.5,40.94,40.75,40.25,38.03,36.88,34.12,31.47,30.0,29.34,29.03,29.69,29.91,30.56,31.19,32.97,35.12,37.19,38.94,40.81,43.31,44.47,45.94,49.78,49.44,49.25,49.09,47.31,45.44,46.0,43.84,44.56,45.25,42.84,41.56,39.97,38.5,36.03,35.34,33.72,33.03,31.41,31.09,30.91,32.25,32.91,36.69,38.66,40.19,41.81,42.47,40.97,39.16,38.31,37.0,36.66,38.47,40.56,41.66,42.81,43.94,44.84,44.91,44.06,43.59,41.38,38.75,36.53,35.12,36.09,36.44,39.72,43.5,45.78,47.94,49.94,49.44,47.28,45.44,41.66,40.31,37.03,35.31,33.06,32.59,29.56,30.31,30.84,31.41,34.41,36.22,38.09,38.22,40.19,40.38,40.12,40.31,42.28,43.06,43.38,45.03,45.28,45.34,45.28,41.78,39.22,35.06,30.66,28.12,24.56,24.19,24.25,25.0,26.94,28.06,29.53,33.19,34.78,38.06,40.0,41.0,43.94,45.25,46.5,48.81,49.47,48.78,45.72,42.66,37.72,33.31,31.59,27.62,27.16,25.84,25.94,26.62,28.06,29.94,32.31,33.94,34.91,37.12,36.0,35.91,36.16,33.81,32.88,30.56,30.19,30.25,29.44,28.56,28.53,28.69,26.91,25.84,24.06,23.03,20.81,20.5,19.34,19.31,21.53,22.09,23.16,27.0,28.03,30.19,32.41,34.69,35.41,36.5,37.28,37.72,38.06,36.62,35.94,33.0,31.5,28.09,24.97,23.31,22.16,19.31,19.28,20.25,20.25,22.16,24.69,26.78,28.38,31.66,33.03,34.28,36.09,35.06,35.16,33.06,31.59,30.66,29.06,29.12,28.09,27.75,26.66,25.12,24.84,23.69,23.62,24.03,24.75,27.56,29.0,31.75,33.56,36.28,37.56,38.03,37.81,38.94,37.31,34.88,32.53,28.81,25.75,21.88,18.56,17.0,15.16,14.56,15.66,15.38,16.34,17.59,18.47,18.81,19.81,20.38,21.62,21.34,21.66,21.44,19.16,19.19,17.12,15.91,16.06,13.66,14.44,14.0,12.31,13.12,14.19,15.19,15.25,16.69,16.56,17.81,17.09,17.94,17.84,18.81,19.56,19.41,20.06,20.12,20.91,21.34,20.97,21.44,21.12,19.91,19.91,19.16,18.06,17.56,15.75,15.12,15.19,15.84,18.0,19.56,22.53,23.81,25.12,26.5,27.47,28.62,26.84,26.44,24.41,22.75,21.53,20.44,19.38,19.78,18.34,18.06,17.0,17.22,17.22,16.81,17.19,16.91,17.91,19.06,20.72,22.19,24.56,24.88,25.56,26.5,26.06,26.59,25.97,25.62,24.69,22.88,21.81,20.0,17.88,15.28,13.44,11.88,11.12,10.94,11.56,13.12,16.66,19.59,23.84,28.78,31.91,33.41,33.59,31.06,28.03,25.12,20.75,17.34,14.69,13.72,12.84,13.12,14.06,14.25,13.41,13.25,11.59,11.38,11.28,11.62,12.34,13.41,14.56,16.41,17.47,17.75,18.0,17.56,15.84,14.34,13.44,11.38,10.78,10.31,10.75,10.25,11.66,11.56,12.5,12.69,11.91,12.38,12.19,12.78,14.94,14.31,16.0,17.78,18.41,19.31,19.81,20.25,19.25,18.75,18.69,18.19,19.09,20.28,20.62,21.28,20.06,20.38,19.78,18.62,18.03,17.25,17.94,19.09,20.78,24.16,25.94,27.25,27.72,26.19,25.03,22.72,21.84,20.97,20.41,20.56,21.12,20.91,20.81,19.31,19.72,17.59,16.91,17.69,17.97,17.56,19.19,21.56,10.97,11.94,14.59,16.91,20.5,23.38,25.0,27.75,26.91,26.78,24.34,22.38,19.56,17.66,15.06,14.16,13.47,13.81,15.16,16.94,18.25,21.19,23.28,25.16:29.31,29.12,28.03,24.38,23.47,22.72,21.78,20.81,21.94,22.09,21.81,22.59,22.53,23.81,26.25,27.56,28.81,31.0,30.28,29.0,28.16,26.62,23.97,23.31,23.31,22.5,22.56,22.56,21.69,19.97,19.88,20.53,19.38,20.06,21.66,24.19,25.22,27.62,27.28,26.12,23.03,18.72,16.28,14.19,11.72,12.22,10.59,10.5,11.81,11.69,14.09,17.19,19.22,22.03,23.47,25.0,26.06,25.72,26.19,26.38,25.12,25.47,26.12,25.88,28.12,28.03,28.22,28.84,30.31,31.25,32.5,35.09,36.69,38.41,38.25,41.12,41.47,40.91,42.69,42.81,43.31,44.06,44.59,45.25,45.62,44.84,45.44,43.94,44.66,44.31,43.62,43.22,41.62,42.34,41.16,42.97,41.94,44.66,45.44,45.41,46.81,48.31,47.47,48.84,50.53,48.81,49.78,49.97,49.03,47.72,48.44,47.66,47.03,46.91,46.19,42.81,40.47,38.72,35.72,33.66,33.25,33.78,31.91,33.62,35.12,35.91,40.19,42.31,43.31,43.91,41.66,39.53,36.69,35.62,35.5,35.22,36.06,35.16,33.66,31.75,30.41,27.56,26.19,26.19,26.34,27.84,29.44,32.81,34.12,36.38,38.06,39.38,40.47,39.56,37.47,36.53,33.97,30.56,29.94,27.16,27.12,25.59,24.56,22.0,20.41,19.34,16.66,16.75,17.69,20.12,22.03,22.53,24.5,26.94,30.12,32.25,35.06,37.5,36.94,35.31,35.12,34.41,32.94,33.97,34.31,35.62,36.38,38.44,41.59,42.28,41.41,40.34,38.09,35.53,34.16,33.53,34.22,34.56,35.66,36.72,39.31,40.56,42.81,43.81,43.53,41.19,39.97,38.69,37.25,36.31,34.19,32.16,31.06,28.12,25.62,24.72,23.38,22.12,20.5,21.5,21.72,21.88,23.59,24.91,27.25,28.91,31.22,33.62,35.12,35.09,36.06,35.97,36.19,36.62,37.81,37.91,36.78,36.47,32.97,31.53,31.31,30.97,33.03,32.66,31.72,31.44,31.06,30.62,31.44,32.75,36.44,37.34,39.94,42.69,45.0,46.06,45.78,45.81,44.44,41.41,40.56,37.56,35.38,33.84,32.44,31.72,31.12,32.16,33.0,33.34,34.38,35.09,35.78,37.06,36.62,37.62,37.41,37.25,38.5,38.5,40.97,41.19,42.03,42.75,43.44,41.56,41.25,41.47,42.06,43.94,46.62,48.03,49.06,48.06,45.25,42.66,39.59,38.12,37.03,37.84,38.47,40.12,42.5,43.5,44.44,44.09,43.12,42.88,40.91,40.16,40.97,40.38,41.31,41.41,40.44,40.0,37.94,36.97,36.44,36.44,36.62,36.66,36.53,34.66,35.12,35.0,35.69,36.31,38.0,38.5,38.22,37.06,35.56,35.16,33.75,33.06,34.72,34.38,34.31,34.69,35.34,35.28,35.5,36.69,36.75,39.0,40.0,41.69,43.09,44.97,45.78,44.44,45.06,43.69,42.78,41.16,39.31,36.06,35.44,32.69,32.19,32.12,33.78,34.53,36.0,37.31,37.78,38.41,38.69,37.5,38.91,37.47,38.41,38.94,39.31,39.22,39.38,39.41,38.66,38.22,35.41,34.03,33.72,32.78,32.28,32.41,33.47,34.06,33.72,34.5,34.59,36.81,37.44,39.19,39.94,40.5,40.72,39.81,36.62,35.78,32.72,29.31,28.06,26.12,24.94,23.62,25.0,24.69,25.12,26.47,26.03,24.88,25.41,23.28,22.59,23.53,24.62,25.31,27.09,29.16,30.34,32.31,32.12,31.34,31.22,31.0,32.59,34.16,35.66,39.59,40.03,41.03,42.88,42.34,43.91,43.66,43.69,43.59,44.06,43.12,42.62,41.5,40.94,40.75,40.25,38.03,36.88,34.12,31.47,30.0,29.34,29.03,29.69,29.91,30.56,31.19,32.97,35.12,37.19,38.94,40.81,43.31,44.47,45.94,49.78,49.44,49.25,49.09,47.31,45.44,46.0,43.84,44.56,45.25,42.84,41.56,39.97,38.5,36.03,35.34,33.72,33.03,31.41,31.09,30.91,32.25,32.91,36.69,38.66,40.19,41.81,42.47,40.97,39.16,38.31,37.0,36.66,38.47,40.56,41.66,42.81,43.94,44.84,44.91,44.06,43.59,41.38,38.75,36.53,35.12,36.09,36.44,39.72,43.5,45.78,47.94,49.94,49.44,47.28,45.44,41.66,40.31,37.03,35.31,33.06,32.59,29.56,30.31,30.84,31.41,34.41,36.22,38.09,38.22,40.19,40.38,40.12,40.31,42.28,43.06,43.38,45.03,45.28,45.34,45.28,41.78,39.22,35.06,30.66,28.12,24.56,24.19,24.25,25.0,26.94,28.06,29.53,33.19,34.78,38.06,40.0,41.0,43.94,45.25,46.5,48.81,49.47,48.78,45.72,42.66,37.72,33.31,31.59,27.62,27.16,25.84,25.94,26.62,28.06,29.94,32.31,33.94,34.91,37.12,36.0,35.91,36.16,33.81,32.88,30.56,30.19,30.25,29.44,28.56,28.53,28.69,26.91,25.84,24.06,23.03,20.81,20.5,19.34,19.31,21.53,22.09,23.16,27.0,28.03,30.19,32.41,34.69,35.41,36.5,37.28,37.72,38.06,36.62,35.94,33.0,31.5,28.09,24.97,23.31,22.16,19.31,19.28,20.25,20.25,22.16,24.69,26.78,28.38,31.66,33.03,34.28,36.09,35.06,35.16,33.06,31.59,30.66,29.06,29.12,28.09,27.75,26.66,25.12,24.84,23.69,23.62,24.03,24.75,27.56,29.0,31.75,33.56,36.28,37.56,38.03,37.81,38.94,37.31,34.88,32.53,28.81,25.75,21.88,18.56,17.0,15.16,14.56,15.66,15.38,16.34,17.59,18.47,18.81,19.81,20.38,21.62,21.34,21.66,21.44,19.16,19.19,17.12,15.91,16.06,13.66,14.44,14.0,12.31,13.12,14.19,15.19,15.25,16.69,16.56,17.81,17.09,17.94,17.84,18.81,19.56,19.41,20.06,20.12,20.91,21.34,20.97,21.44,21.12,19.91,19.91,19.16,18.06,17.56,15.75,15.12,15.19,15.84,18.0,19.56,22.53,23.81,25.12,26.5,27.47,28.62,26.84,26.44,24.41,22.75,21.53,20.44,19.38,19.78,18.34,18.06,17.0,17.22,17.22,16.81,17.19,16.91,17.91,19.06,20.72,22.19,24.56,24.88,25.56,26.5,26.06,26.59,25.97,25.62,24.69,22.88,21.81,20.0,17.88,15.28,13.44,11.88,11.12,10.94,11.56,13.12,16.66,19.59,23.84,28.78,31.91,33.41,33.59,31.06,28.03,25.12,20.75,17.34,14.69,13.72,12.84,13.12,14.06,14.25,13.41,13.25,11.59,11.38,11.28,11.62,12.34,13.41,14.56,16.41,17.47,17.75,18.0,17.56,15.84,14.34,13.44,11.38,10.78,10.31,10.75,10.25,11.66,11.56,12.5,12.69,11.91,12.38,12.19,12.78,14.94,14.31,16.0,17.78,18.41,19.31,19.81,20.25,19.25,18.75,18.69,18.19,19.09,20.28,20.62,21.28,20.06,20.38,19.78,18.62,18.03,17.25,17.94,19.09,20.78,24.16,25.94,27.25,27.72,26.19,25.03,22.72,21.84,20.97,20.41,20.56,21.12,20.91,20.81,19.31,19.72,17.59,16.91,17.69,17.97,17.56,19.19,21.56,10.97,11.94,14.59,16.91,20.5,23.38,25.0,27.75,26.91,26.78,24.34,22.38,19.56,17.66,15.06,14.16,13.47,13.81,15.16,16.94,18.25,21.19,23.28,25.16,26.56,28.03,30.31,28.5,28.66,27.09:negativity
14.66,13.53,13.22,12.5,12.0,12.72,12.91,13.38,13.53,13.75,13.78,13.38,12.25,10.31,7.94,6.0,3.41,1.66,-0.28,-1.59,-3.09,-4.41,-5.69,-6.03,-5.97,-5.25,-4.78,-3.69,-2.06,-1.38,0.25,1.31,3.41,4.28,7.72,9.81,12.03,13.97,15.44,15.16,15.03,14.56,14.12,13.19,12.66,11.78,10.75,9.97,9.25,8.34,8.16,7.81,8.31,8.38,9.56,11.66,12.44,14.38,15.41,15.16,15.06,12.78,10.31,7.81,5.16,2.69,0.38,-0.97,-2.44,-3.03,-2.41,-1.44,0.28,2.69,4.34,6.47,8.19,9.06,11.19,13.25,14.69,16.75,18.66,19.12,18.88,18.12,16.59,15.34,13.56,12.78,11.88,12.0,11.31,11.62,12.44,12.0,12.62,13.06,13.66,15.25,16.06,17.84,19.25,20.19,21.22,22.78,23.81,24.91,25.12,25.34,23.72,22.0,20.53,17.25,14.06,12.56,9.06,7.69,6.59,6.28,6.62,7.25,7.94,8.62,9.0,10.09,10.16,11.66,12.53,15.53,16.81,18.94,20.72,21.72,22.44,23.06,22.94,23.78,23.62,23.03,22.03,21.72,19.97,20.41,22.31,24.53,27.88,30.81,32.0,31.78,29.56,26.84,23.16,19.94,16.72,14.12,11.34,9.25,7.06,5.31,4.88,3.88,4.0,4.19,4.75,4.59,4.94,5.25,5.53,6.19,6.31,6.66,7.03,7.94,8.84,11.34,13.0,13.47,14.31,14.28,13.31,12.28,11.28,10.44,9.53,8.91,8.5,8.44,8.25,8.72,9.03,10.31,10.75,12.31,14.0,14.31,15.69,17.31,17.78,19.97,20.19,21.62,21.38,21.06,19.44,17.38,15.91,14.66,14.16,14.06,14.69,15.41,14.91,15.84,15.81,16.22,16.72,16.06,15.91,15.66,14.53,13.44,13.41,13.12,13.25,12.62,12.31,10.62,8.56,6.97,5.06,4.69,4.88,5.91,7.91,9.72,11.06,12.41,12.31,10.62,10.09,9.16,7.84,7.72,6.81,6.31,6.06,6.56,8.34,10.62,13.41,15.22,15.62,15.84,14.69,13.91,13.34,12.25,11.56,10.28,8.97,8.19,6.5,7.06,7.06,9.16,12.03,13.62,15.81,17.44,16.62,15.66,15.47,14.72,14.56,14.22,15.16,14.25,13.44,13.38,12.69,12.0,10.72,10.03,9.72,9.22,8.91,8.31,7.88,5.94,4.72,3.62,2.59,3.81,4.78,5.31,8.19,10.44,12.41,15.0,18.12,20.34,21.84,22.09,19.88,17.41,14.44,11.09,8.88,8.88,7.94,10.06,12.19,13.81,15.84,17.62,17.94,17.88,17.69,16.72,14.88,13.62,12.12,11.16,11.06,11.75,12.53,13.06,13.09,13.06,13.09,13.31,14.16,15.78,17.47,19.06,18.5,17.81,16.38,14.03,11.97,9.28,6.69,5.03,2.97,2.62,2.44,4.62,7.06,9.72,13.03,15.75,19.44,21.69,25.28,27.94,28.91,29.41,27.91,24.19,21.25,17.12,14.56,12.5,11.12,10.56,9.41,8.34,8.53,6.72,8.56,10.78,14.06,18.12,22.94,26.31,28.97,30.59,31.09,29.81,27.56,26.09,23.06,20.94,19.94,18.5,16.31,14.62,12.84,11.56,11.84,12.66,14.56,17.53,20.5,22.69,25.22,26.41,26.91,26.34,25.28,23.88,22.03,21.16,20.62,20.09,19.75,19.97,19.97,20.94,21.62,22.69,23.06,24.44,25.06,25.81,28.12,29.0,29.62,30.81,30.81,30.62,30.69,31.62,31.94,32.16,32.72,32.5,31.31,30.03,28.69,27.41,25.94,24.72,23.0,22.41,21.62,20.5,20.44,20.5,19.0,18.03,17.16,15.38,13.75,12.44,11.12,8.81,7.72,6.31,5.44,4.03,3.69,2.88,2.25,1.59,1.25,0.44,0.62,1.44,3.09,5.34,9.12,12.09,15.78,18.28,19.44,20.41,20.06,19.12,18.84,18.31,18.5,17.47,17.47,16.66,16.5,14.78,14.12,14.41,13.91,14.47,15.56,16.62,16.53,17.41,18.5,18.03,18.16,18.19,16.91,15.41,13.66,12.56,11.94,11.25,13.31,13.91,14.88,16.16,16.41,17.06,16.41,16.28,15.47,14.5,13.16,12.25,12.88,13.31,14.12,16.31,17.69,18.25,19.16,18.06,16.56,14.34,12.19,10.31,8.91,8.47,8.06,6.56,4.97,2.66,0.03,-0.97,-2.28,-2.28,-0.34,1.62,4.69,7.41,10.66,13.12,14.94,15.81,16.44,16.47,15.56,14.56,12.88,11.09,9.0,7.12,6.19,5.44,5.06,5.72,5.31,5.88,6.75,7.03,7.47,8.44,8.12,8.69,10.31,12.0,13.72,15.56,16.38,16.0,15.56,13.97,14.66,15.41,17.75,18.91,19.06,17.28,13.28,8.19,3.06,-1.66,-4.97,-7.47,-8.28,-8.88,-7.75,-6.59,-4.06,0.31,5.22,10.31,16.44,21.0,24.5,26.91,27.72,27.31,25.94,24.41,22.0,20.41,18.5,16.25,14.62,13.69,12.44,12.44,13.12,14.53,15.62,17.47,19.31,20.22,21.34,22.81,24.19,25.28,26.19,27.62,27.81,27.06,26.31,25.31,24.03,22.41,21.41,19.91,18.16,17.0,15.62,15.03,15.41,15.81,16.56,17.81,18.03,19.5,20.75,22.69,25.12,28.16,30.19,31.66,32.19,31.44,30.19,27.53,25.06,21.25,18.06,15.22,12.16,10.81,9.53,10.38,11.31,12.28,13.69,14.94,15.16,15.03,13.94,13.66,12.25,11.56,11.25,10.31,11.16,11.12,11.66,12.78,13.97,14.03,14.31,14.28,14.0,13.31,13.66,14.0,13.53,14.5,14.41,14.41,14.16,14.69,15.19,15.53,16.97,17.62,18.03,17.88,17.47,16.69,16.38,15.19,14.22,13.16,12.12,11.56,11.62,12.38,14.5,16.41,18.19,19.62,20.62,20.25,19.16,18.5,15.34,13.25,10.19,7.25,4.97,4.38,4.69,5.94,7.66,10.03,12.5,13.66,15.75,16.22,16.28,15.0,11.31,7.16,2.84,-1.69,-5.94,-8.91,-9.59,-9.5,-7.22,-3.41,1.94,7.41,13.53,18.81,23.28,26.44,28.56,28.06,26.31,23.41,19.78,16.84,13.94,11.44,8.91,7.59,6.75,6.44,8.31,9.53,11.53,13.47,15.19,16.12,17.12,18.81,19.94,20.38,21.94,22.31,22.78,21.72,21.16,20.19,18.5,17.97,17.44,17.38,17.03,16.12,14.81,12.91,10.19,8.34,6.56,5.06,4.66,4.81,6.44,8.19,9.53,10.59,11.78,12.25,13.12,14.25,15.16,16.53,16.94,15.66,14.16,12.38,8.94,7.12,5.81,6.12,6.5,9.12,12.31,16.31,19.72,21.12,20.69,18.94,15.56,11.62,8.81,6.31,4.72,4.16,3.94,3.72,4.94,6.41,7.12,8.5,9.5,9.56,8.47,7.91,6.44,6.06,5.25,5.47,5.16,5.41,5.97,5.44,5.56,4.91,3.66,2.41,0.44,-1.28,-2.09,-2.53,-2.78,-1.34,-0.72,1.09,2.69,4.12,5.5,6.09,6.75,6.53,5.62,4.53,4.19,4.34,3.81,4.38,5.19,4.94,5.0,5.03,5.94,6.72,6.81,7.47,7.72,7.91,7.69,7.5,7.59,7.56,7.12,7.25,7.56,8.0,9.19,10.97,12.94,15.12,17.06,17.91,17.62,16.41,14.09,10.69,8.25,5.5,2.84,1.41,1.16,0.84,1.91,4.56,5.69,7.06,7.47,7.16,5.97,4.56,4.66,5.0:12.91,13.38,13.53,13.75,13.78,13.38,12.25,10.31,7.94,6.0,3.41,1.66,-0.28,-1.59,-3.09,-4.41,-5.69,-6.03,-5.97,-5.25,-4.78,-3.69,-2.06,-1.38,0.25,1.31,3.41,4.28,7.72,9.81,12.03,13.97,15.44,15.16,15.03,14.56,14.12,13.19,12.66,11.78,10.75,9.97,9.25,8.34,8.16,7.81,8.31,8.38,9.56,11.66,12.44,14.38,15.41,15.16,15.06,12.78,10.31,7.81,5.16,2.69,0.38,-0.97,-2.44,-3.03,-2.41,-1.44,0.28,2.69,4.34,6.47,8.19,9.06,11.19,13.25,14.69,16.75,18.66,19.12,18.88,18.12,16.59,15.34,13.56,12.78,11.88,12.0,11.31,11.62,12.44,12.0,12.62,13.06,13.66,15.25,16.06,17.84,19.25,20.19,21.22,22.78,23.81,24.91,25.12,25.34,23.72,22.0,20.53,17.25,14.06,12.56,9.06,7.69,6.59,6.28,6.62,7.25,7.94,8.62,9.0,10.09,10.16,11.66,12.53,15.53,16.81,18.94,20.72,21.72,22.44,23.06,22.94,23.78,23.62,23.03,22.03,21.72,19.97,20.41,22.31,24.53,27.88,30.81,32.0,31.78,29.56,26.84,23.16,19.94,16.72,14.12,11.34,9.25,7.06,5.31,4.88,3.88,4.0,4.19,4.75,4.59,4.94,5.25,5.53,6.19,6.31,6.66,7.03,7.94,8.84,11.34,13.0,13.47,14.31,14.28,13.31,12.28,11.28,10.44,9.53,8.91,8.5,8.44,8.25,8.72,9.03,10.31,10.75,12.31,14.0,14.31,15.69,17.31,17.78,19.97,20.19,21.62,21.38,21.06,19.44,17.38,15.91,14.66,14.16,14.06,14.69,15.41,14.91,15.84,15.81,16.22,16.72,16.06,15.91,15.66,14.53,13.44,13.41,13.12,13.25,12.62,12.31,10.62,8.56,6.97,5.06,4.69,4.88,5.91,7.91,9.72,11.06,12.41,12.31,10.62,10.09,9.16,7.84,7.72,6.81,6.31,6.06,6.56,8.34,10.62,13.41,15.22,15.62,15.84,14.69,13.91,13.34,12.25,11.56,10.28,8.97,8.19,6.5,7.06,7.06,9.16,12.03,13.62,15.81,17.44,16.62,15.66,15.47,14.72,14.56,14.22,15.16,14.25,13.44,13.38,12.69,12.0,10.72,10.03,9.72,9.22,8.91,8.31,7.88,5.94,4.72,3.62,2.59,3.81,4.78,5.31,8.19,10.44,12.41,15.0,18.12,20.34,21.84,22.09,19.88,17.41,14.44,11.09,8.88,8.88,7.94,10.06,12.19,13.81,15.84,17.62,17.94,17.88,17.69,16.72,14.88,13.62,12.12,11.16,11.06,11.75,12.53,13.06,13.09,13.06,13.09,13.31,14.16,15.78,17.47,19.06,18.5,17.81,16.38,14.03,11.97,9.28,6.69,5.03,2.97,2.62,2.44,4.62,7.06,9.72,13.03,15.75,19.44,21.69,25.28,27.94,28.91,29.41,27.91,24.19,21.25,17.12,14.56,12.5,11.12,10.56,9.41,8.34,8.53,6.72,8.56,10.78,14.06,18.12,22.94,26.31,28.97,30.59,31.09,29.81,27.56,26.09,23.06,20.94,19.94,18.5,16.31,14.62,12.84,11.56,11.84,12.66,14.56,17.53,20.5,22.69,25.22,26.41,26.91,26.34,25.28,23.88,22.03,21.16,20.62,20.09,19.75,19.97,19.97,20.94,21.62,22.69,23.06,24.44,25.06,25.81,28.12,29.0,29.62,30.81,30.81,30.62,30.69,31.62,31.94,32.16,32.72,32.5,31.31,30.03,28.69,27.41,25.94,24.72,23.0,22.41,21.62,20.5,20.44,20.5,19.0,18.03,17.16,15.38,13.75,12.44,11.12,8.81,7.72,6.31,5.44,4.03,3.69,2.88,2.25,1.59,1.25,0.44,0.62,1.44,3.09,5.34,9.12,12.09,15.78,18.28,19.44,20.41,20.06,19.12,18.84,18.31,18.5,17.47,17.47,16.66,16.5,14.78,14.12,14.41,13.91,14.47,15.56,16.62,16.53,17.41,18.5,18.03,18.16,18.19,16.91,15.41,13.66,12.56,11.94,11.25,13.31,13.91,14.88,16.16,16.41,17.06,16.41,16.28,15.47,14.5,13.16,12.25,12.88,13.31,14.12,16.31,17.69,18.25,19.16,18.06,16.56,14.34,12.19,10.31,8.91,8.47,8.06,6.56,4.97,2.66,0.03,-0.97,-2.28,-2.28,-0.34,1.62,4.69,7.41,10.66,13.12,14.94,15.81,16.44,16.47,15.56,14.56,12.88,11.09,9.0,7.12,6.19,5.44,5.06,5.72,5.31,5.88,6.75,7.03,7.47,8.44,8.12,8.69,10.31,12.0,13.72,15.56,16.38,16.0,15.56,13.97,14.66,15.41,17.75,18.91,19.06,17.28,13.28,8.19,3.06,-1.66,-4.97,-7.47,-8.28,-8.88,-7.75,-6.59,-4.06,0.31,5.22,10.31,16.44,21.0,24.5,26.91,27.72,27.31,25.94,24.41,22.0,20.41,18.5,16.25,14.62,13.69,12.44,12.44,13.12,14.53,15.62,17.47,19.31,20.22,21.34,22.81,24.19,25.28,26.19,27.62,27.81,27.06,26.31,25.31,24.03,22.41,21.41,19.91,18.16,17.0,15.62,15.03,15.41,15.81,16.56,17.81,18.03,19.5,20.75,22.69,25.12,28.16,30.19,31.66,32.19,31.44,30.19,27.53,25.06,21.25,18.06,15.22,12.16,10.81,9.53,10.38,11.31,12.28,13.69,14.94,15.16,15.03,13.94,13.66,12.25,11.56,11.25,10.31,11.16,11.12,11.66,12.78,13.97,14.03,14.31,14.28,14.0,13.31,13.66,14.0,13.53,14.5,14.41,14.41,14.16,14.69,15.19,15.53,16.97,17.62,18.03,17.88,17.47,16.69,16.38,15.19,14.22,13.16,12.12,11.56,11.62,12.38,14.5,16.41,18.19,19.62,20.62,20.25,19.16,18.5,15.34,13.25,10.19,7.25,4.97,4.38,4.69,5.94,7.66,10.03,12.5,13.66,15.75,16.22,16.28,15.0,11.31,7.16,2.84,-1.69,-5.94,-8.91,-9.59,-9.5,-7.22,-3.41,1.94,7.41,13.53,18.81,23.28,26.44,28.56,28.06,26.31,23.41,19.78,16.84,13.94,11.44,8.91,7.59,6.75,6.44,8.31,9.53,11.53,13.47,15.19,16.12,17.12,18.81,19.94,20.38,21.94,22.31,22.78,21.72,21.16,20.19,18.5,17.97,17.44,17.38,17.03,16.12,14.81,12.91,10.19,8.34,6.56,5.06,4.66,4.81,6.44,8.19,9.53,10.59,11.78,12.25,13.12,14.25,15.16,16.53,16.94,15.66,14.16,12.38,8.94,7.12,5.81,6.12,6.5,9.12,12.31,16.31,19.72,21.12,20.69,18.94,15.56,11.62,8.81,6.31,4.72,4.16,3.94,3.72,4.94,6.41,7.12,8.5,9.5,9.56,8.47,7.91,6.44,6.06,5.25,5.47,5.16,5.41,5.97,5.44,5.56,4.91,3.66,2.41,0.44,-1.28,-2.09,-2.53,-2.78,-1.34,-0.72,1.09,2.69,4.12,5.5,6.09,6.75,6.53,5.62,4.53,4.19,4.34,3.81,4.38,5.19,4.94,5.0,5.03,5.94,6.72,6.81,7.47,7.72,7.91,7.69,7.5,7.59,7.56,7.12,7.25,7.56,8.0,9.19,10.97,12.94,15.12,17.06,17.91,17.62,16.41,14.09,10.69,8.25,5.5,2.84,1.41,1.16,0.84,1.91,4.56,5.69,7.06,7.47,7.16,5.97,4.56,4.66,5.0,18.62,18.69,19.53,19.78,20.78,21.66:12.25,10.31,7.94,6.0,3.41,1.66,-0.28,-1.59,-3.09,-4.41,-5.69,-6.03,-5.97,-5.25,-4.78,-3.69,-2.06,-1.38,0.25,1.31,3.41,4.28,7.72,9.81,12.03,13.97,15.44,15.16,15.03,14.56,14.12,13.19,12.66,11.78,10.75,9.97,9.25,8.34,8.16,7.81,8.31,8.38,9.56,11.66,12.44,14.38,15.41,15.16,15.06,12.78,10.31,7.81,5.16,2.69,0.38,-0.97,-2.44,-3.03,-2.41,-1.44,0.28,2.69,4.34,6.47,8.19,9.06,11.19,13.25,14.69,16.75,18.66,19.12,18.88,18.12,16.59,15.34,13.56,12.78,11.88,12.0,11.31,11.62,12.44,12.0,12.62,13.06,13.66,15.25,16.06,17.84,19.25,20.19,21.22,22.78,23.81,24.91,25.12,25.34,23.72,22.0,20.53,17.25,14.06,12.56,9.06,7.69,6.59,6.28,6.62,7.25,7.94,8.62,9.0,10.09,10.16,11.66,12.53,15.53,16.81,18.94,20.72,21.72,22.44,23.06,22.94,23.78,23.62,23.03,22.03,21.72,19.97,20.41,22.31,24.53,27.88,30.81,32.0,31.78,29.56,26.84,23.16,19.94,16.72,14.12,11.34,9.25,7.06,5.31,4.88,3.88,4.0,4.19,4.75,4.59,4.94,5.25,5.53,6.19,6.31,6.66,7.03,7.94,8.84,11.34,13.0,13.47,14.31,14.28,13.31,12.28,11.28,10.44,9.53,8.91,8.5,8.44,8.25,8.72,9.03,10.31,10.75,12.31,14.0,14.31,15.69,17.31,17.78,19.97,20.19,21.62,21.38,21.06,19.44,17.38,15.91,14.66,14.16,14.06,14.69,15.41,14.91,15.84,15.81,16.22,16.72,16.06,15.91,15.66,14.53,13.44,13.41,13.12,13.25,12.62,12.31,10.62,8.56,6.97,5.06,4.69,4.88,5.91,7.91,9.72,11.06,12.41,12.31,10.62,10.09,9.16,7.84,7.72,6.81,6.31,6.06,6.56,8.34,10.62,13.41,15.22,15.62,15.84,14.69,13.91,13.34,12.25,11.56,10.28,8.97,8.19,6.5,7.06,7.06,9.16,12.03,13.62,15.81,17.44,16.62,15.66,15.47,14.72,14.56,14.22,15.16,14.25,13.44,13.38,12.69,12.0,10.72,10.03,9.72,9.22,8.91,8.31,7.88,5.94,4.72,3.62,2.59,3.81,4.78,5.31,8.19,10.44,12.41,15.0,18.12,20.34,21.84,22.09,19.88,17.41,14.44,11.09,8.88,8.88,7.94,10.06,12.19,13.81,15.84,17.62,17.94,17.88,17.69,16.72,14.88,13.62,12.12,11.16,11.06,11.75,12.53,13.06,13.09,13.06,13.09,13.31,14.16,15.78,17.47,19.06,18.5,17.81,16.38,14.03,11.97,9.28,6.69,5.03,2.97,2.62,2.44,4.62,7.06,9.72,13.03,15.75,19.44,21.69,25.28,27.94,28.91,29.41,27.91,24.19,21.25,17.12,14.56,12.5,11.12,10.56,9.41,8.34,8.53,6.72,8.56,10.78,14.06,18.12,22.94,26.31,28.97,30.59,31.09,29.81,27.56,26.09,23.06,20.94,19.94,18.5,16.31,14.62,12.84,11.56,11.84,12.66,14.56,17.53,20.5,22.69,25.22,26.41,26.91,26.34,25.28,23.88,22.03,21.16,20.62,20.09,19.75,19.97,19.97,20.94,21.62,22.69,23.06,24.44,25.06,25.81,28.12,29.0,29.62,30.81,30.81,30.62,30.69,31.62,31.94,32.16,32.72,32.5,31.31,30.03,28.69,27.41,25.94,24.72,23.0,22.41,21.62,20.5,20.44,20.5,19.0,18.03,17.16,15.38,13.75,12.44,11.12,8.81,7.72,6.31,5.44,4.03,3.69,2.88,2.25,1.59,1.25,0.44,0.62,1.44,3.09,5.34,9.12,12.09,15.78,18.28,19.44,20.41,20.06,19.12,18.84,18.31,18.5,17.47,17.47,16.66,16.5,14.78,14.12,14.41,13.91,14.47,15.56,16.62,16.53,17.41,18.5,18.03,18.16,18.19,16.91,15.41,13.66,12.56,11.94,11.25,13.31,13.91,14.88,16.16,16.41,17.06,16.41,16.28,15.47,14.5,13.16,12.25,12.88,13.31,14.12,16.31,17.69,18.25,19.16,18.06,16.56,14.34,12.19,10.31,8.91,8.47,8.06,6.56,4.97,2.66,0.03,-0.97,-2.28,-2.28,-0.34,1.62,4.69,7.41,10.66,13.12,14.94,15.81,16.44,16.47,15.56,14.56,12.88,11.09,9.0,7.12,6.19,5.44,5.06,5.72,5.31,5.88,6.75,7.03,7.47,8.44,8.12,8.69,10.31,12.0,13.72,15.56,16.38,16.0,15.56,13.97,14.66,15.41,17.75,18.91,19.06,17.28,13.28,8.19,3.06,-1.66,-4.97,-7.47,-8.28,-8.88,-7.75,-6.59,-4.06,0.31,5.22,10.31,16.44,21.0,24.5,26.91,27.72,27.31,25.94,24.41,22.0,20.41,18.5,16.25,14.62,13.69,12.44,12.44,13.12,14.53,15.62,17.47,19.31,20.22,21.34,22.81,24.19,25.28,26.19,27.62,27.81,27.06,26.31,25.31,24.03,22.41,21.41,19.91,18.16,17.0,15.62,15.03,15.41,15.81,16.56,17.81,18.03,19.5,20.75,22.69,25.12,28.16,30.19,31.66,32.19,31.44,30.19,27.53,25.06,21.25,18.06,15.22,12.16,10.81,9.53,10.38,11.31,12.28,13.69,14.94,15.16,15.03,13.94,13.66,12.25,11.56,11.25,10.31,11.16,11.12,11.66,12.78,13.97,14.03,14.31,14.28,14.0,13.31,13.66,14.0,13.53,14.5,14.41,14.41,14.16,14.69,15.19,15.53,16.97,17.62,18.03,17.88,17.47,16.69,16.38,15.19,14.22,13.16,12.12,11.56,11.62,12.38,14.5,16.41,18.19,19.62,20.62,20.25,19.16,18.5,15.34,13.25,10.19,7.25,4.97,4.38,4.69,5.94,7.66,10.03,12.5,13.66,15.75,16.22,16.28,15.0,11.31,7.16,2.84,-1.69,-5.94,-8.91,-9.59,-9.5,-7.22,-3.41,1.94,7.41,13.53,18.81,23.28,26.44,28.56,28.06,26.31,23.41,19.78,16.84,13.94,11.44,8.91,7.59,6.75,6.44,8.31,9.53,11.53,13.47,15.19,16.12,17.12,18.81,19.94,20.38,21.94,22.31,22.78,21.72,21.16,20.19,18.5,17.97,17.44,17.38,17.03,16.12,14.81,12.91,10.19,8.34,6.56,5.06,4.66,4.81,6.44,8.19,9.53,10.59,11.78,12.25,13.12,14.25,15.16,16.53,16.94,15.66,14.16,12.38,8.94,7.12,5.81,6.12,6.5,9.12,12.31,16.31,19.72,21.12,20.69,18.94,15.56,11.62,8.81,6.31,4.72,4.16,3.94,3.72,4.94,6.41,7.12,8.5,9.5,9.56,8.47,7.91,6.44,6.06,5.25,5.47,5.16,5.41,5.97,5.44,5.56,4.91,3.66,2.41,0.44,-1.28,-2.09,-2.53,-2.78,-1.34,-0.72,1.09,2.69,4.12,5.5,6.09,6.75,6.53,5.62,4.53,4.19,4.34,3.81,4.38,5.19,4.94,5.0,5.03,5.94,6.72,6.81,7.47,7.72,7.91,7.69,7.5,7.59,7.56,7.12,7.25,7.56,8.0,9.19,10.97,12.94,15.12,17.06,17.91,17.62,16.41,14.09,10.69,8.25,5.5,2.84,1.41,1.16,0.84,1.91,4.56,5.69,7.06,7.47,7.16,5.97,4.56,4.66,5.0,18.62,18.69,19.53,19.78,20.78,21.66,22.38,23.53,24.06,25.28,26.41,25.81:-0.28,-1.59,-3.09,-4.41,-5.69,-6.03,-5.97,-5.25,-4.78,-3.69,-2.06,-1.38,0.25,1.31,3.41,4.28,7.72,9.81,12.03,13.97,15.44,15.16,15.03,14.56,14.12,13.19,12.66,11.78,10.75,9.97,9.25,8.34,8.16,7.81,8.31,8.38,9.56,11.66,12.44,14.38,15.41,15.16,15.06,12.78,10.31,7.81,5.16,2.69,0.38,-0.97,-2.44,-3.03,-2.41,-1.44,0.28,2.69,4.34,6.47,8.19,9.06,11.19,13.25,14.69,16.75,18.66,19.12,18.88,18.12,16.59,15.34,13.56,12.78,11.88,12.0,11.31,11.62,12.44,12.0,12.62,13.06,13.66,15.25,16.06,17.84,19.25,20.19,21.22,22.78,23.81,24.91,25.12,25.34,23.72,22.0,20.53,17.25,14.06,12.56,9.06,7.69,6.59,6.28,6.62,7.25,7.94,8.62,9.0,10.09,10.16,11.66,12.53,15.53,16.81,18.94,20.72,21.72,22.44,23.06,22.94,23.78,23.62,23.03,22.03,21.72,19.97,20.41,22.31,24.53,27.88,30.81,32.0,31.78,29.56,26.84,23.16,19.94,16.72,14.12,11.34,9.25,7.06,5.31,4.88,3.88,4.0,4.19,4.75,4.59,4.94,5.25,5.53,6.19,6.31,6.66,7.03,7.94,8.84,11.34,13.0,13.47,14.31,14.28,13.31,12.28,11.28,10.44,9.53,8.91,8.5,8.44,8.25,8.72,9.03,10.31,10.75,12.31,14.0,14.31,15.69,17.31,17.78,19.97,20.19,21.62,21.38,21.06,19.44,17.38,15.91,14.66,14.16,14.06,14.69,15.41,14.91,15.84,15.81,16.22,16.72,16.06,15.91,15.66,14.53,13.44,13.41,13.12,13.25,12.62,12.31,10.62,8.56,6.97,5.06,4.69,4.88,5.91,7.91,9.72,11.06,12.41,12.31,10.62,10.09,9.16,7.84,7.72,6.81,6.31,6.06,6.56,8.34,10.62,13.41,15.22,15.62,15.84,14.69,13.91,13.34,12.25,11.56,10.28,8.97,8.19,6.5,7.06,7.06,9.16,12.03,13.62,15.81,17.44,16.62,15.66,15.47,14.72,14.56,14.22,15.16,14.25,13.44,13.38,12.69,12.0,10.72,10.03,9.72,9.22,8.91,8.31,7.88,5.94,4.72,3.62,2.59,3.81,4.78,5.31,8.19,10.44,12.41,15.0,18.12,20.34,21.84,22.09,19.88,17.41,14.44,11.09,8.88,8.88,7.94,10.06,12.19,13.81,15.84,17.62,17.94,17.88,17.69,16.72,14.88,13.62,12.12,11.16,11.06,11.75,12.53,13.06,13.09,13.06,13.09,13.31,14.16,15.78,17.47,19.06,18.5,17.81,16.38,14.03,11.97,9.28,6.69,5.03,2.97,2.62,2.44,4.62,7.06,9.72,13.03,15.75,19.44,21.69,25.28,27.94,28.91,29.41,27.91,24.19,21.25,17.12,14.56,12.5,11.12,10.56,9.41,8.34,8.53,6.72,8.56,10.78,14.06,18.12,22.94,26.31,28.97,30.59,31.09,29.81,27.56,26.09,23.06,20.94,19.94,18.5,16.31,14.62,12.84,11.56,11.84,12.66,14.56,17.53,20.5,22.69,25.22,26.41,26.91,26.34,25.28,23.88,22.03,21.16,20.62,20.09,19.75,19.97,19.97,20.94,21.62,22.69,23.06,24.44,25.06,25.81,28.12,29.0,29.62,30.81,30.81,30.62,30.69,31.62,31.94,32.16,32.72,32.5,31.31,30.03,28.69,27.41,25.94,24.72,23.0,22.41,21.62,20.5,20.44,20.5,19.0,18.03,17.16,15.38,13.75,12.44,11.12,8.81,7.72,6.31,5.44,4.03,3.69,2.88,2.25,1.59,1.25,0.44,0.62,1.44,3.09,5.34,9.12,12.09,15.78,18.28,19.44,20.41,20.06,19.12,18.84,18.31,18.5,17.47,17.47,16.66,16.5,14.78,14.12,14.41,13.91,14.47,15.56,16.62,16.53,17.41,18.5,18.03,18.16,18.19,16.91,15.41,13.66,12.56,11.94,11.25,13.31,13.91,14.88,16.16,16.41,17.06,16.41,16.28,15.47,14.5,13.16,12.25,12.88,13.31,14.12,16.31,17.69,18.25,19.16,18.06,16.56,14.34,12.19,10.31,8.91,8.47,8.06,6.56,4.97,2.66,0.03,-0.97,-2.28,-2.28,-0.34,1.62,4.69,7.41,10.66,13.12,14.94,15.81,16.44,16.47,15.56,14.56,12.88,11.09,9.0,7.12,6.19,5.44,5.06,5.72,5.31,5.88,6.75,7.03,7.47,8.44,8.12,8.69,10.31,12.0,13.72,15.56,16.38,16.0,15.56,13.97,14.66,15.41,17.75,18.91,19.06,17.28,13.28,8.19,3.06,-1.66,-4.97,-7.47,-8.28,-8.88,-7.75,-6.59,-4.06,0.31,5.22,10.31,16.44,21.0,24.5,26.91,27.72,27.31,25.94,24.41,22.0,20.41,18.5,16.25,14.62,13.69,12.44,12.44,13.12,14.53,15.62,17.47,19.31,20.22,21.34,22.81,24.19,25.28,26.19,27.62,27.81,27.06,26.31,25.31,24.03,22.41,21.41,19.91,18.16,17.0,15.62,15.03,15.41,15.81,16.56,17.81,18.03,19.5,20.75,22.69,25.12,28.16,30.19,31.66,32.19,31.44,30.19,27.53,25.06,21.25,18.06,15.22,12.16,10.81,9.53,10.38,11.31,12.28,13.69,14.94,15.16,15.03,13.94,13.66,12.25,11.56,11.25,10.31,11.16,11.12,11.66,12.78,13.97,14.03,14.31,14.28,14.0,13.31,13.66,14.0,13.53,14.5,14.41,14.41,14.16,14.69,15.19,15.53,16.97,17.62,18.03,17.88,17.47,16.69,16.38,15.19,14.22,13.16,12.12,11.56,11.62,12.38,14.5,16.41,18.19,19.62,20.62,20.25,19.16,18.5,15.34,13.25,10.19,7.25,4.97,4.38,4.69,5.94,7.66,10.03,12.5,13.66,15.75,16.22,16.28,15.0,11.31,7.16,2.84,-1.69,-5.94,-8.91,-9.59,-9.5,-7.22,-3.41,1.94,7.41,13.53,18.81,23.28,26.44,28.56,28.06,26.31,23.41,19.78,16.84,13.94,11.44,8.91,7.59,6.75,6.44,8.31,9.53,11.53,13.47,15.19,16.12,17.12,18.81,19.94,20.38,21.94,22.31,22.78,21.72,21.16,20.19,18.5,17.97,17.44,17.38,17.03,16.12,14.81,12.91,10.19,8.34,6.56,5.06,4.66,4.81,6.44,8.19,9.53,10.59,11.78,12.25,13.12,14.25,15.16,16.53,16.94,15.66,14.16,12.38,8.94,7.12,5.81,6.12,6.5,9.12,12.31,16.31,19.72,21.12,20.69,18.94,15.56,11.62,8.81,6.31,4.72,4.16,3.94,3.72,4.94,6.41,7.12,8.5,9.5,9.56,8.47,7.91,6.44,6.06,5.25,5.47,5.16,5.41,5.97,5.44,5.56,4.91,3.66,2.41,0.44,-1.28,-2.09,-2.53,-2.78,-1.34,-0.72,1.09,2.69,4.12,5.5,6.09,6.75,6.53,5.62,4.53,4.19,4.34,3.81,4.38,5.19,4.94,5.0,5.03,5.94,6.72,6.81,7.47,7.72,7.91,7.69,7.5,7.59,7.56,7.12,7.25,7.56,8.0,9.19,10.97,12.94,15.12,17.06,17.91,17.62,16.41,14.09,10.69,8.25,5.5,2.84,1.41,1.16,0.84,1.91,4.56,5.69,7.06,7.47,7.16,5.97,4.56,4.66,5.0,18.62,18.69,19.53,19.78,20.78,21.66,22.38,23.53,24.06,25.28,26.41,25.81,25.66,24.81,23.03,21.78,19.12,17.53:-5.97,-5.25,-4.78,-3.69,-2.06,-1.38,0.25,1.31,3.41,4.28,7.72,9.81,12.03,13.97,15.44,15.16,15.03,14.56,14.12,13.19,12.66,11.78,10.75,9.97,9.25,8.34,8.16,7.81,8.31,8.38,9.56,11.66,12.44,14.38,15.41,15.16,15.06,12.78,10.31,7.81,5.16,2.69,0.38,-0.97,-2.44,-3.03,-2.41,-1.44,0.28,2.69,4.34,6.47,8.19,9.06,11.19,13.25,14.69,16.75,18.66,19.12,18.88,18.12,16.59,15.34,13.56,12.78,11.88,12.0,11.31,11.62,12.44,12.0,12.62,13.06,13.66,15.25,16.06,17.84,19.25,20.19,21.22,22.78,23.81,24.91,25.12,25.34,23.72,22.0,20.53,17.25,14.06,12.56,9.06,7.69,6.59,6.28,6.62,7.25,7.94,8.62,9.0,10.09,10.16,11.66,12.53,15.53,16.81,18.94,20.72,21.72,22.44,23.06,22.94,23.78,23.62,23.03,22.03,21.72,19.97,20.41,22.31,24.53,27.88,30.81,32.0,31.78,29.56,26.84,23.16,19.94,16.72,14.12,11.34,9.25,7.06,5.31,4.88,3.88,4.0,4.19,4.75,4.59,4.94,5.25,5.53,6.19,6.31,6.66,7.03,7.94,8.84,11.34,13.0,13.47,14.31,14.28,13.31,12.28,11.28,10.44,9.53,8.91,8.5,8.44,8.25,8.72,9.03,10.31,10.75,12.31,14.0,14.31,15.69,17.31,17.78,19.97,20.19,21.62,21.38,21.06,19.44,17.38,15.91,14.66,14.16,14.06,14.69,15.41,14.91,15.84,15.81,16.22,16.72,16.06,15.91,15.66,14.53,13.44,13.41,13.12,13.25,12.62,12.31,10.62,8.56,6.97,5.06,4.69,4.88,5.91,7.91,9.72,11.06,12.41,12.31,10.62,10.09,9.16,7.84,7.72,6.81,6.31,6.06,6.56,8.34,10.62,13.41,15.22,15.62,15.84,14.69,13.91,13.34,12.25,11.56,10.28,8.97,8.19,6.5,7.06,7.06,9.16,12.03,13.62,15.81,17.44,16.62,15.66,15.47,14.72,14.56,14.22,15.16,14.25,13.44,13.38,12.69,12.0,10.72,10.03,9.72,9.22,8.91,8.31,7.88,5.94,4.72,3.62,2.59,3.81,4.78,5.31,8.19,10.44,12.41,15.0,18.12,20.34,21.84,22.09,19.88,17.41,14.44,11.09,8.88,8.88,7.94,10.06,12.19,13.81,15.84,17.62,17.94,17.88,17.69,16.72,14.88,13.62,12.12,11.16,11.06,11.75,12.53,13.06,13.09,13.06,13.09,13.31,14.16,15.78,17.47,19.06,18.5,17.81,16.38,14.03,11.97,9.28,6.69,5.03,2.97,2.62,2.44,4.62,7.06,9.72,13.03,15.75,19.44,21.69,25.28,27.94,28.91,29.41,27.91,24.19,21.25,17.12,14.56,12.5,11.12,10.56,9.41,8.34,8.53,6.72,8.56,10.78,14.06,18.12,22.94,26.31,28.97,30.59,31.09,29.81,27.56,26.09,23.06,20.94,19.94,18.5,16.31,14.62,12.84,11.56,11.84,12.66,14.56,17.53,20.5,22.69,25.22,26.41,26.91,26.34,25.28,23.88,22.03,21.16,20.62,20.09,19.75,19.97,19.97,20.94,21.62,22.69,23.06,24.44,25.06,25.81,28.12,29.0,29.62,30.81,30.81,30.62,30.69,31.62,31.94,32.16,32.72,32.5,31.31,30.03,28.69,27.41,25.94,24.72,23.0,22.41,21.62,20.5,20.44,20.5,19.0,18.03,17.16,15.38,13.75,12.44,11.12,8.81,7.72,6.31,5.44,4.03,3.69,2.88,2.25,1.59,1.25,0.44,0.62,1.44,3.09,5.34,9.12,12.09,15.78,18.28,19.44,20.41,20.06,19.12,18.84,18.31,18.5,17.47,17.47,16.66,16.5,14.78,14.12,14.41,13.91,14.47,15.56,16.62,16.53,17.41,18.5,18.03,18.16,18.19,16.91,15.41,13.66,12.56,11.94,11.25,13.31,13.91,14.88,16.16,16.41,17.06,16.41,16.28,15.47,14.5,13.16,12.25,12.88,13.31,14.12,16.31,17.69,18.25,19.16,18.06,16.56,14.34,12.19,10.31,8.91,8.47,8.06,6.56,4.97,2.66,0.03,-0.97,-2.28,-2.28,-0.34,1.62,4.69,7.41,10.66,13.12,14.94,15.81,16.44,16.47,15.56,14.56,12.88,11.09,9.0,7.12,6.19,5.44,5.06,5.72,5.31,5.88,6.75,7.03,7.47,8.44,8.12,8.69,10.31,12.0,13.72,15.56,16.38,16.0,15.56,13.97,14.66,15.41,17.75,18.91,19.06,17.28,13.28,8.19,3.06,-1.66,-4.97,-7.47,-8.28,-8.88,-7.75,-6.59,-4.06,0.31,5.22,10.31,16.44,21.0,24.5,26.91,27.72,27.31,25.94,24.41,22.0,20.41,18.5,16.25,14.62,13.69,12.44,12.44,13.12,14.53,15.62,17.47,19.31,20.22,21.34,22.81,24.19,25.28,26.19,27.62,27.81,27.06,26.31,25.31,24.03,22.41,21.41,19.91,18.16,17.0,15.62,15.03,15.41,15.81,16.56,17.81,18.03,19.5,20.75,22.69,25.12,28.16,30.19,31.66,32.19,31.44,30.19,27.53,25.06,21.25,18.06,15.22,12.16,10.81,9.53,10.38,11.31,12.28,13.69,14.94,15.16,15.03,13.94,13.66,12.25,11.56,11.25,10.31,11.16,11.12,11.66,12.78,13.97,14.03,14.31,14.28,14.0,13.31,13.66,14.0,13.53,14.5,14.41,14.41,14.16,14.69,15.19,15.53,16.97,17.62,18.03,17.88,17.47,16.69,16.38,15.19,14.22,13.16,12.12,11.56,11.62,12.38,14.5,16.41,18.19,19.62,20.62,20.25,19.16,18.5,15.34,13.25,10.19,7.25,4.97,4.38,4.69,5.94,7.66,10.03,12.5,13.66,15.75,16.22,16.28,15.0,11.31,7.16,2.84,-1.69,-5.94,-8.91,-9.59,-9.5,-7.22,-3.41,1.94,7.41,13.53,18.81,23.28,26.44,28.56,28.06,26.31,23.41,19.78,16.84,13.94,11.44,8.91,7.59,6.75,6.44,8.31,9.53,11.53,13.47,15.19,16.12,17.12,18.81,19.94,20.38,21.94,22.31,22.78,21.72,21.16,20.19,18.5,17.97,17.44,17.38,17.03,16.12,14.81,12.91,10.19,8.34,6.56,5.06,4.66,4.81,6.44,8.19,9.53,10.59,11.78,12.25,13.12,14.25,15.16,16.53,16.94,15.66,14.16,12.38,8.94,7.12,5.81,6.12,6.5,9.12,12.31,16.31,19.72,21.12,20.69,18.94,15.56,11.62,8.81,6.31,4.72,4.16,3.94,3.72,4.94,6.41,7.12,8.5,9.5,9.56,8.47,7.91,6.44,6.06,5.25,5.47,5.16,5.41,5.97,5.44,5.56,4.91,3.66,2.41,0.44,-1.28,-2.09,-2.53,-2.78,-1.34,-0.72,1.09,2.69,4.12,5.5,6.09,6.75,6.53,5.62,4.53,4.19,4.34,3.81,4.38,5.19,4.94,5.0,5.03,5.94,6.72,6.81,7.47,7.72,7.91,7.69,7.5,7.59,7.56,7.12,7.25,7.56,8.0,9.19,10.97,12.94,15.12,17.06,17.91,17.62,16.41,14.09,10.69,8.25,5.5,2.84,1.41,1.16,0.84,1.91,4.56,5.69,7.06,7.47,7.16,5.97,4.56,4.66,5.0,18.62,18.69,19.53,19.78,20.78,21.66,22.38,23.53,24.06,25.28,26.41,25.81,25.66,24.81,23.03,21.78,19.12,17.53,16.0,14.38,14.06,13.34,12.5,12.53:0.25,1.31,3.41,4.28,7.72,9.81,12.03,13.97,15.44,15.16,15.03,14.56,14.12,13.19,12.66,11.78,10.75,9.97,9.25,8.34,8.16,7.81,8.31,8.38,9.56,11.66,12.44,14.38,15.41,15.16,15.06,12.78,10.31,7.81,5.16,2.69,0.38,-0.97,-2.44,-3.03,-2.41,-1.44,0.28,2.69,4.34,6.47,8.19,9.06,11.19,13.25,14.69,16.75,18.66,19.12,18.88,18.12,16.59,15.34,13.56,12.78,11.88,12.0,11.31,11.62,12.44,12.0,12.62,13.06,13.66,15.25,16.06,17.84,19.25,20.19,21.22,22.78,23.81,24.91,25.12,25.34,23.72,22.0,20.53,17.25,14.06,12.56,9.06,7.69,6.59,6.28,6.62,7.25,7.94,8.62,9.0,10.09,10.16,11.66,12.53,15.53,16.81,18.94,20.72,21.72,22.44,23.06,22.94,23.78,23.62,23.03,22.03,21.72,19.97,20.41,22.31,24.53,27.88,30.81,32.0,31.78,29.56,26.84,23.16,19.94,16.72,14.12,11.34,9.25,7.06,5.31,4.88,3.88,4.0,4.19,4.75,4.59,4.94,5.25,5.53,6.19,6.31,6.66,7.03,7.94,8.84,11.34,13.0,13.47,14.31,14.28,13.31,12.28,11.28,10.44,9.53,8.91,8.5,8.44,8.25,8.72,9.03,10.31,10.75,12.31,14.0,14.31,15.69,17.31,17.78,19.97,20.19,21.62,21.38,21.06,19.44,17.38,15.91,14.66,14.16,14.06,14.69,15.41,14.91,15.84,15.81,16.22,16.72,16.06,15.91,15.66,14.53,13.44,13.41,13.12,13.25,12.62,12.31,10.62,8.56,6.97,5.06,4.69,4.88,5.91,7.91,9.72,11.06,12.41,12.31,10.62,10.09,9.16,7.84,7.72,6.81,6.31,6.06,6.56,8.34,10.62,13.41,15.22,15.62,15.84,14.69,13.91,13.34,12.25,11.56,10.28,8.97,8.19,6.5,7.06,7.06,9.16,12.03,13.62,15.81,17.44,16.62,15.66,15.47,14.72,14.56,14.22,15.16,14.25,13.44,13.38,12.69,12.0,10.72,10.03,9.72,9.22,8.91,8.31,7.88,5.94,4.72,3.62,2.59,3.81,4.78,5.31,8.19,10.44,12.41,15.0,18.12,20.34,21.84,22.09,19.88,17.41,14.44,11.09,8.88,8.88,7.94,10.06,12.19,13.81,15.84,17.62,17.94,17.88,17.69,16.72,14.88,13.62,12.12,11.16,11.06,11.75,12.53,13.06,13.09,13.06,13.09,13.31,14.16,15.78,17.47,19.06,18.5,17.81,16.38,14.03,11.97,9.28,6.69,5.03,2.97,2.62,2.44,4.62,7.06,9.72,13.03,15.75,19.44,21.69,25.28,27.94,28.91,29.41,27.91,24.19,21.25,17.12,14.56,12.5,11.12,10.56,9.41,8.34,8.53,6.72,8.56,10.78,14.06,18.12,22.94,26.31,28.97,30.59,31.09,29.81,27.56,26.09,23.06,20.94,19.94,18.5,16.31,14.62,12.84,11.56,11.84,12.66,14.56,17.53,20.5,22.69,25.22,26.41,26.91,26.34,25.28,23.88,22.03,21.16,20.62,20.09,19.75,19.97,19.97,20.94,21.62,22.69,23.06,24.44,25.06,25.81,28.12,29.0,29.62,30.81,30.81,30.62,30.69,31.62,31.94,32.16,32.72,32.5,31.31,30.03,28.69,27.41,25.94,24.72,23.0,22.41,21.62,20.5,20.44,20.5,19.0,18.03,17.16,15.38,13.75,12.44,11.12,8.81,7.72,6.31,5.44,4.03,3.69,2.88,2.25,1.59,1.25,0.44,0.62,1.44,3.09,5.34,9.12,12.09,15.78,18.28,19.44,20.41,20.06,19.12,18.84,18.31,18.5,17.47,17.47,16.66,16.5,14.78,14.12,14.41,13.91,14.47,15.56,16.62,16.53,17.41,18.5,18.03,18.16,18.19,16.91,15.41,13.66,12.56,11.94,11.25,13.31,13.91,14.88,16.16,16.41,17.06,16.41,16.28,15.47,14.5,13.16,12.25,12.88,13.31,14.12,16.31,17.69,18.25,19.16,18.06,16.56,14.34,12.19,10.31,8.91,8.47,8.06,6.56,4.97,2.66,0.03,-0.97,-2.28,-2.28,-0.34,1.62,4.69,7.41,10.66,13.12,14.94,15.81,16.44,16.47,15.56,14.56,12.88,11.09,9.0,7.12,6.19,5.44,5.06,5.72,5.31,5.88,6.75,7.03,7.47,8.44,8.12,8.69,10.31,12.0,13.72,15.56,16.38,16.0,15.56,13.97,14.66,15.41,17.75,18.91,19.06,17.28,13.28,8.19,3.06,-1.66,-4.97,-7.47,-8.28,-8.88,-7.75,-6.59,-4.06,0.31,5.22,10.31,16.44,21.0,24.5,26.91,27.72,27.31,25.94,24.41,22.0,20.41,18.5,16.25,14.62,13.69,12.44,12.44,13.12,14.53,15.62,17.47,19.31,20.22,21.34,22.81,24.19,25.28,26.19,27.62,27.81,27.06,26.31,25.31,24.03,22.41,21.41,19.91,18.16,17.0,15.62,15.03,15.41,15.81,16.56,17.81,18.03,19.5,20.75,22.69,25.12,28.16,30.19,31.66,32.19,31.44,30.19,27.53,25.06,21.25,18.06,15.22,12.16,10.81,9.53,10.38,11.31,12.28,13.69,14.94,15.16,15.03,13.94,13.66,12.25,11.56,11.25,10.31,11.16,11.12,11.66,12.78,13.97,14.03,14.31,14.28,14.0,13.31,13.66,14.0,13.53,14.5,14.41,14.41,14.16,14.69,15.19,15.53,16.97,17.62,18.03,17.88,17.47,16.69,16.38,15.19,14.22,13.16,12.12,11.56,11.62,12.38,14.5,16.41,18.19,19.62,20.62,20.25,19.16,18.5,15.34,13.25,10.19,7.25,4.97,4.38,4.69,5.94,7.66,10.03,12.5,13.66,15.75,16.22,16.28,15.0,11.31,7.16,2.84,-1.69,-5.94,-8.91,-9.59,-9.5,-7.22,-3.41,1.94,7.41,13.53,18.81,23.28,26.44,28.56,28.06,26.31,23.41,19.78,16.84,13.94,11.44,8.91,7.59,6.75,6.44,8.31,9.53,11.53,13.47,15.19,16.12,17.12,18.81,19.94,20.38,21.94,22.31,22.78,21.72,21.16,20.19,18.5,17.97,17.44,17.38,17.03,16.12,14.81,12.91,10.19,8.34,6.56,5.06,4.66,4.81,6.44,8.19,9.53,10.59,11.78,12.25,13.12,14.25,15.16,16.53,16.94,15.66,14.16,12.38,8.94,7.12,5.81,6.12,6.5,9.12,12.31,16.31,19.72,21.12,20.69,18.94,15.56,11.62,8.81,6.31,4.72,4.16,3.94,3.72,4.94,6.41,7.12,8.5,9.5,9.56,8.47,7.91,6.44,6.06,5.25,5.47,5.16,5.41,5.97,5.44,5.56,4.91,3.66,2.41,0.44,-1.28,-2.09,-2.53,-2.78,-1.34,-0.72,1.09,2.69,4.12,5.5,6.09,6.75,6.53,5.62,4.53,4.19,4.34,3.81,4.38,5.19,4.94,5.0,5.03,5.94,6.72,6.81,7.47,7.72,7.91,7.69,7.5,7.59,7.56,7.12,7.25,7.56,8.0,9.19,10.97,12.94,15.12,17.06,17.91,17.62,16.41,14.09,10.69,8.25,5.5,2.84,1.41,1.16,0.84,1.91,4.56,5.69,7.06,7.47,7.16,5.97,4.56,4.66,5.0,18.62,18.69,19.53,19.78,20.78,21.66,22.38,23.53,24.06,25.28,26.41,25.81,25.66,24.81,23.03,21.78,19.12,17.53,16.0,14.38,14.06,13.34,12.5,12.53,11.56,11.5,12.19,11.69,12.25,12.66:negativity
30.75,30.22,28.34,26.31,23.69,21.19,18.91,17.31,16.62,16.62,16.84,17.94,18.44,18.94,19.03,18.41,17.69,17.19,17.16,17.53,18.59,19.25,20.16,21.06,21.91,21.91,21.94,22.19,22.25,23.62,25.0,27.03,29.19,31.06,32.0,33.19,32.31,31.03,29.94,28.56,26.38,24.97,24.31,24.47,25.41,26.56,28.28,28.47,28.56,28.78,26.16,24.56,21.44,18.97,16.34,14.91,14.41,13.5,13.41,12.84,12.78,12.22,11.75,11.72,10.56,10.47,10.5,10.09,9.69,10.34,9.94,9.94,7.75,7.28,6.19,5.31,5.5,6.53,6.47,7.06,6.84,7.06,7.56,8.28,8.56,8.44,7.97,7.0,5.91,4.81,5.69,6.16,6.81,8.03,10.41,11.25,12.62,13.41,13.66,13.19,13.56,13.12,13.62,13.0,12.12,11.28,9.44,7.59,4.5,2.81,0.84,-0.94,-1.53,-3.19,-3.84,-4.44,-5.59,-5.44,-6.38,-5.19,-4.28,-2.59,-0.41,-0.09,-0.59,-0.97,-3.34,-5.22,-7.69,-8.59,-9.69,-8.91,-7.84,-6.75,-4.44,-3.19,-1.06,0.53,1.69,2.41,3.34,2.53,3.22,4.53,5.19,6.44,8.59,9.69,8.75,7.78,6.34,5.03,3.84,3.16,1.84,1.19,-0.22,-0.72,0.19,0.41,2.34,5.03,5.62,6.75,6.06,4.66,3.88,1.78,1.47,0.66,0.44,0.25,-0.25,-0.97,-2.22,-1.34,-1.19,0.34,2.34,4.56,4.38,5.56,5.12,5.28,5.53,5.19,5.16,4.66,3.62,2.34,2.25,2.0,1.59,2.91,2.84,1.81,1.47,1.09,-0.72,-2.0,-2.75,-3.19,-3.34,-2.53,-1.78,-1.16,-0.91,-1.0,-1.94,-2.34,-3.28,-3.16,-2.44,0.19,2.41,5.09,6.44,7.72,7.12,6.88,4.06,3.72,1.38,1.03,0.19,0.97,1.5,1.97,2.62,3.56,3.06,1.94,1.31,0.28,-0.62,-1.56,-1.19,0.03,1.59,4.56,7.22,8.59,9.41,8.81,7.94,5.72,4.28,3.06,2.28,2.72,2.56,2.97,3.53,4.03,3.44,4.0,3.22,3.38,4.66,4.12,4.66,5.47,5.44,6.03,6.03,5.44,4.78,3.5,2.78,1.91,1.0,0.0,-2.03,-1.78,-3.03,-2.03,-1.47,-0.78,-0.12,0.41,1.88,2.81,5.5,6.34,8.53,9.28,9.94,10.38,11.47,11.56,11.53,10.69,8.12,6.34,3.94,2.19,0.78,-0.22,-1.44,-1.44,-1.47,-1.38,-0.97,0.12,0.53,1.28,1.06,1.06,1.25,1.47,2.31,3.12,4.94,5.53,6.09,5.84,5.25,3.78,2.56,1.75,0.94,1.56,1.53,2.06,1.84,1.38,1.12,0.28,0.56,1.16,1.91,2.66,3.59,4.16,5.88,5.88,7.31,8.53,8.19,7.97,7.31,6.84,5.91,4.91,5.66,6.06,6.38,7.59,8.38,8.5,8.97,8.84,7.75,6.12,5.31,4.12,2.44,2.25,2.22,3.31,5.88,8.09,10.44,12.03,12.0,12.56,11.5,10.88,9.88,8.97,7.62,7.16,5.59,4.41,2.81,1.41,0.47,-0.09,-0.72,-0.66,0.56,1.34,3.25,4.41,4.88,5.81,5.12,5.06,5.03,4.06,4.09,3.12,2.53,1.97,1.84,2.41,4.06,5.75,7.84,9.53,9.72,11.97,13.06,13.41,15.56,17.56,19.84,20.97,22.62,22.53,20.53,18.22,14.56,9.97,5.81,0.91,-2.84,-6.16,-6.47,-6.84,-5.84,-4.31,-2.72,-1.84,-1.59,-2.84,-3.97,-5.56,-6.81,-7.81,-7.47,-5.72,-3.84,-1.62,0.44,2.12,2.72,3.16,3.34,3.03,2.81,3.06,4.34,4.97,7.0,8.66,9.97,12.03,12.91,13.34,12.56,10.5,8.5,8.03,6.84,8.06,10.09,12.81,15.88,18.16,18.78,18.22,16.75,14.06,11.41,9.91,8.0,6.56,6.66,6.66,6.78,7.06,7.41,7.12,7.03,6.84,6.25,5.72,4.88,3.66,2.75,0.62,-0.53,-1.78,-2.88,-3.88,-5.03,-5.22,-5.16,-4.84,-4.09,-2.34,-0.75,1.72,4.06,6.84,9.69,10.78,12.12,13.41,13.75,14.09,13.91,12.62,11.66,9.38,6.41,3.62,0.59,-2.22,-4.09,-5.06,-5.72,-5.47,-3.84,-2.28,-0.56,1.72,3.56,4.97,5.66,6.19,3.91,2.94,1.81,0.75,1.12,0.78,0.66,1.16,1.94,2.38,3.75,5.72,7.16,9.0,10.09,11.78,12.28,13.12,13.5,13.53,14.22,15.03,16.19,17.25,17.5,16.91,15.69,13.5,11.41,8.69,6.81,4.94,3.56,2.97,3.03,4.56,5.31,5.78,6.84,6.41,5.94,5.78,4.62,3.06,1.88,0.12,-2.84,-4.59,-5.41,-6.53,-5.47,-4.69,-4.72,-3.66,-3.34,-3.22,-3.16,-2.47,-1.59,-0.69,1.12,2.62,4.41,5.72,6.78,8.91,10.22,11.84,13.22,14.88,17.06,18.88,20.81,21.09,20.78,19.12,16.41,13.0,10.44,8.12,6.03,4.06,3.19,0.94,-0.59,-1.0,-1.91,-2.16,-1.72,-1.25,0.03,0.62,1.16,0.41,0.03,-1.19,-0.84,-0.19,0.78,2.91,5.44,7.41,9.06,9.97,9.75,10.28,9.69,9.34,9.03,8.81,7.53,7.38,7.16,8.03,8.94,10.06,11.81,12.56,13.16,13.28,12.81,11.78,12.16,10.44,8.78,7.88,6.5,5.56,5.16,4.25,4.47,3.91,4.22,4.38,4.62,5.28,6.03,7.84,9.56,11.53,14.5,17.16,19.12,20.41,21.09,20.31,19.03,17.41,15.69,13.88,11.91,9.78,9.16,8.62,7.56,7.44,6.53,6.38,6.03,5.72,5.66,5.91,6.56,6.69,6.72,6.31,7.16,7.34,8.81,10.22,11.41,12.69,12.72,12.69,12.78,12.69,11.94,12.09,13.28,13.06,13.12,13.09,13.25,13.94,15.06,16.69,18.0,20.16,23.16,26.28,30.31,33.91,36.56,38.06,38.06,36.0,32.91,28.5,23.91,19.19,15.12,11.38,8.72,6.19,6.03,4.22,4.16,3.53,3.53,3.56,3.16,4.0,2.75,3.62,4.62,5.81,8.06,9.72,10.41,10.88,10.5,9.44,7.81,6.34,6.84,5.75,6.38,8.59,9.03,11.59,14.62,16.84,19.41,20.12,20.5,20.41,19.44,19.59,19.75,20.84,21.59,22.66,22.94,22.34,21.25,19.69,18.28,16.16,15.16,14.72,14.56,15.41,16.44,16.34,17.25,17.91,18.22,19.38,19.22,18.88,18.38,18.03,15.97,15.06,12.25,8.53,6.31,1.66,-1.66,-4.19,-5.97,-5.47,-4.69,-3.19,-1.34,0.53,2.22,4.81,6.5,7.56,9.41,9.72,9.38,10.09,9.41,9.53,8.81,8.75,7.47,5.38,3.91,1.09,-1.94,-3.34,-4.62,-4.91,-4.16,-2.47,-0.34,1.66,3.06,5.25,6.19,6.78,7.72,8.47,9.88,11.66,12.59,13.0,12.0,10.25,8.25,6.75,5.0,4.5,4.59,6.25,7.0,8.34,9.12,9.66,9.38,8.12,8.0,6.66,4.81,3.38,1.56,-0.97,-3.16,-5.84,-7.84,-10.25,-10.97,-11.88,-12.34,-12.09,-12.72,-10.78,-10.09,-10.22,-8.56,-8.0,-7.84,-6.97,-5.22,-4.22,-2.97,-2.16,-1.34,-2.12,-1.41,-0.84,-1.09,-2.0,-2.94,-4.22,-6.03,-6.84,-8.12,-8.72,-9.22,-7.78,-7.72,-5.72,-3.78,-1.59,-1.16,0.53,1.38,2.31,2.88,5.0:18.91,17.31,16.62,16.62,16.84,17.94,18.44,18.94,19.03,18.41,17.69,17.19,17.16,17.53,18.59,19.25,20.16,21.06,21.91,21.91,21.94,22.19,22.25,23.62,25.0,27.03,29.19,31.06,32.0,33.19,32.31,31.03,29.94,28.56,26.38,24.97,24.31,24.47,25.41,26.56,28.28,28.47,28.56,28.78,26.16,24.56,21.44,18.97,16.34,14.91,14.41,13.5,13.41,12.84,12.78,12.22,11.75,11.72,10.56,10.47,10.5,10.09,9.69,10.34,9.94,9.94,7.75,7.28,6.19,5.31,5.5,6.53,6.47,7.06,6.84,7.06,7.56,8.28,8.56,8.44,7.97,7.0,5.91,4.81,5.69,6.16,6.81,8.03,10.41,11.25,12.62,13.41,13.66,13.19,13.56,13.12,13.62,13.0,12.12,11.28,9.44,7.59,4.5,2.81,0.84,-0.94,-1.53,-3.19,-3.84,-4.44,-5.59,-5.44,-6.38,-5.19,-4.28,-2.59,-0.41,-0.09,-0.59,-0.97,-3.34,-5.22,-7.69,-8.59,-9.69,-8.91,-7.84,-6.75,-4.44,-3.19,-1.06,0.53,1.69,2.41,3.34,2.53,3.22,4.53,5.19,6.44,8.59,9.69,8.75,7.78,6.34,5.03,3.84,3.16,1.84,1.19,-0.22,-0.72,0.19,0.41,2.34,5.03,5.62,6.75,6.06,4.66,3.88,1.78,1.47,0.66,0.44,0.25,-0.25,-0.97,-2.22,-1.34,-1.19,0.34,2.34,4.56,4.38,5.56,5.12,5.28,5.53,5.19,5.16,4.66,3.62,2.34,2.25,2.0,1.59,2.91,2.84,1.81,1.47,1.09,-0.72,-2.0,-2.75,-3.19,-3.34,-2.53,-1.78,-1.16,-0.91,-1.0,-1.94,-2.34,-3.28,-3.16,-2.44,0.19,2.41,5.09,6.44,7.72,7.12,6.88,4.06,3.72,1.38,1.03,0.19,0.97,1.5,1.97,2.62,3.56,3.06,1.94,1.31,0.28,-0.62,-1.56,-1.19,0.03,1.59,4.56,7.22,8.59,9.41,8.81,7.94,5.72,4.28,3.06,2.28,2.72,2.56,2.97,3.53,4.03,3.44,4.0,3.22,3.38,4.66,4.12,4.66,5.47,5.44,6.03,6.03,5.44,4.78,3.5,2.78,1.91,1.0,0.0,-2.03,-1.78,-3.03,-2.03,-1.47,-0.78,-0.12,0.41,1.88,2.81,5.5,6.34,8.53,9.28,9.94,10.38,11.47,11.56,11.53,10.69,8.12,6.34,3.94,2.19,0.78,-0.22,-1.44,-1.44,-1.47,-1.38,-0.97,0.12,0.53,1.28,1.06,1.06,1.25,1.47,2.31,3.12,4.94,5.53,6.09,5.84,5.25,3.78,2.56,1.75,0.94,1.56,1.53,2.06,1.84,1.38,1.12,0.28,0.56,1.16,1.91,2.66,3.59,4.16,5.88,5.88,7.31,8.53,8.19,7.97,7.31,6.84,5.91,4.91,5.66,6.06,6.38,7.59,8.38,8.5,8.97,8.84,7.75,6.12,5.31,4.12,2.44,2.25,2.22,3.31,5.88,8.09,10.44,12.03,12.0,12.56,11.5,10.88,9.88,8.97,7.62,7.16,5.59,4.41,2.81,1.41,0.47,-0.09,-0.72,-0.66,0.56,1.34,3.25,4.41,4.88,5.81,5.12,5.06,5.03,4.06,4.09,3.12,2.53,1.97,1.84,2.41,4.06,5.75,7.84,9.53,9.72,11.97,13.06,13.41,15.56,17.56,19.84,20.97,22.62,22.53,20.53,18.22,14.56,9.97,5.81,0.91,-2.84,-6.16,-6.47,-6.84,-5.84,-4.31,-2.72,-1.84,-1.59,-2.84,-3.97,-5.56,-6.81,-7.81,-7.47,-5.72,-3.84,-1.62,0.44,2.12,2.72,3.16,3.34,3.03,2.81,3.06,4.34,4.97,7.0,8.66,9.97,12.03,12.91,13.34,12.56,10.5,8.5,8.03,6.84,8.06,10.09,12.81,15.88,18.16,18.78,18.22,16.75,14.06,11.41,9.91,8.0,6.56,6.66,6.66,6.78,7.06,7.41,7.12,7.03,6.84,6.25,5.72,4.88,3.66,2.75,0.62,-0.53,-1.78,-2.88,-3.88,-5.03,-5.22,-5.16,-4.84,-4.09,-2.34,-0.75,1.72,4.06,6.84,9.69,10.78,12.12,13.41,13.75,14.09,13.91,12.62,11.66,9.38,6.41,3.62,0.59,-2.22,-4.09,-5.06,-5.72,-5.47,-3.84,-2.28,-0.56,1.72,3.56,4.97,5.66,6.19,3.91,2.94,1.81,0.75,1.12,0.78,0.66,1.16,1.94,2.38,3.75,5.72,7.16,9.0,10.09,11.78,12.28,13.12,13.5,13.53,14.22,15.03,16.19,17.25,17.5,16.91,15.69,13.5,11.41,8.69,6.81,4.94,3.56,2.97,3.03,4.56,5.31,5.78,6.84,6.41,5.94,5.78,4.62,3.06,1.88,0.12,-2.84,-4.59,-5.41,-6.53,-5.47,-4.69,-4.72,-3.66,-3.34,-3.22,-3.16,-2.47,-1.59,-0.69,1.12,2.62,4.41,5.72,6.78,8.91,10.22,11.84,13.22,14.88,17.06,18.88,20.81,21.09,20.78,19.12,16.41,13.0,10.44,8.12,6.03,4.06,3.19,0.94,-0.59,-1.0,-1.91,-2.16,-1.72,-1.25,0.03,0.62,1.16,0.41,0.03,-1.19,-0.84,-0.19,0.78,2.91,5.44,7.41,9.06,9.97,9.75,10.28,9.69,9.34,9.03,8.81,7.53,7.38,7.16,8.03,8.94,10.06,11.81,12.56,13.16,13.28,12.81,11.78,12.16,10.44,8.78,7.88,6.5,5.56,5.16,4.25,4.47,3.91,4.22,4.38,4.62,5.28,6.03,7.84,9.56,11.53,14.5,17.16,19.12,20.41,21.09,20.31,19.03,17.41,15.69,13.88,11.91,9.78,9.16,8.62,7.56,7.44,6.53,6.38,6.03,5.72,5.66,5.91,6.56,6.69,6.72,6.31,7.16,7.34,8.81,10.22,11.41,12.69,12.72,12.69,12.78,12.69,11.94,12.09,13.28,13.06,13.12,13.09,13.25,13.94,15.06,16.69,18.0,20.16,23.16,26.28,30.31,33.91,36.56,38.06,38.06,36.0,32.91,28.5,23.91,19.19,15.12,11.38,8.72,6.19,6.03,4.22,4.16,3.53,3.53,3.56,3.16,4.0,2.75,3.62,4.62,5.81,8.06,9.72,10.41,10.88,10.5,9.44,7.81,6.34,6.84,5.75,6.38,8.59,9.03,11.59,14.62,16.84,19.41,20.12,20.5,20.41,19.44,19.59,19.75,20.84,21.59,22.66,22.94,22.34,21.25,19.69,18.28,16.16,15.16,14.72,14.56,15.41,16.44,16.34,17.25,17.91,18.22,19.38,19.22,18.88,18.38,18.03,15.97,15.06,12.25,8.53,6.31,1.66,-1.66,-4.19,-5.97,-5.47,-4.69,-3.19,-1.34,0.53,2.22,4.81,6.5,7.56,9.41,9.72,9.38,10.09,9.41,9.53,8.81,8.75,7.47,5.38,3.91,1.09,-1.94,-3.34,-4.62,-4.91,-4.16,-2.47,-0.34,1.66,3.06,5.25,6.19,6.78,7.72,8.47,9.88,11.66,12.59,13.0,12.0,10.25,8.25,6.75,5.0,4.5,4.59,6.25,7.0,8.34,9.12,9.66,9.38,8.12,8.0,6.66,4.81,3.38,1.56,-0.97,-3.16,-5.84,-7.84,-10.25,-10.97,-11.88,-12.34,-12.09,-12.72,-10.78,-10.09,-10.22,-8.56,-8.0,-7.84,-6.97,-5.22,-4.22,-2.97,-2.16,-1.34,-2.12,-1.41,-0.84,-1.09,-2.0,-2.94,-4.22,-6.03,-6.84,-8.12,-8.72,-9.22,-7.78,-7.72,-5.72,-3.78,-1.59,-1.16,0.53,1.38,2.31,2.88,5.0,7.34,7.56,6.22,4.41,2.09,-1.41:18.44,18.94,19.03,18.41,17.69,17.19,17.16,17.53,18.59,19.25,20.16,21.06,21.91,21.91,21.94,22.19,22.25,23.62,25.0,27.03,29.19,31.06,32.0,33.19,32.31,31.03,29.94,28.56,26.38,24.97,24.31,24.47,25.41,26.56,28.28,28.47,28.56,28.78,26.16,24.56,21.44,18.97,16.34,14.91,14.41,13.5,13.41,12.84,12.78,12.22,11.75,11.72,10.56,10.47,10.5,10.09,9.69,10.34,9.94,9.94,7.75,7.28,6.19,5.31,5.5,6.53,6.47,7.06,6.84,7.06,7.56,8.28,8.56,8.44,7.97,7.0,5.91,4.81,5.69,6.16,6.81,8.03,10.41,11.25,12.62,13.41,13.66,13.19,13.56,13.12,13.62,13.0,12.12,11.28,9.44,7.59,4.5,2.81,0.84,-0.94,-1.53,-3.19,-3.84,-4.44,-5.59,-5.44,-6.38,-5.19,-4.28,-2.59,-0.41,-0.09,-0.59,-0.97,-3.34,-5.22,-7.69,-8.59,-9.69,-8.91,-7.84,-6.75,-4.44,-3.19,-1.06,0.53,1.69,2.41,3.34,2.53,3.22,4.53,5.19,6.44,8.59,9.69,8.75,7.78,6.34,5.03,3.84,3.16,1.84,1.19,-0.22,-0.72,0.19,0.41,2.34,5.03,5.62,6.75,6.06,4.66,3.88,1.78,1.47,0.66,0.44,0.25,-0.25,-0.97,-2.22,-1.34,-1.19,0.34,2.34,4.56,4.38,5.56,5.12,5.28,5.53,5.19,5.16,4.66,3.62,2.34,2.25,2.0,1.59,2.91,2.84,1.81,1.47,1.09,-0.72,-2.0,-2.75,-3.19,-3.34,-2.53,-1.78,-1.16,-0.91,-1.0,-1.94,-2.34,-3.28,-3.16,-2.44,0.19,2.41,5.09,6.44,7.72,7.12,6.88,4.06,3.72,1.38,1.03,0.19,0.97,1.5,1.97,2.62,3.56,3.06,1.94,1.31,0.28,-0.62,-1.56,-1.19,0.03,1.59,4.56,7.22,8.59,9.41,8.81,7.94,5.72,4.28,3.06,2.28,2.72,2.56,2.97,3.53,4.03,3.44,4.0,3.22,3.38,4.66,4.12,4.66,5.47,5.44,6.03,6.03,5.44,4.78,3.5,2.78,1.91,1.0,0.0,-2.03,-1.78,-3.03,-2.03,-1.47,-0.78,-0.12,0.41,1.88,2.81,5.5,6.34,8.53,9.28,9.94,10.38,11.47,11.56,11.53,10.69,8.12,6.34,3.94,2.19,0.78,-0.22,-1.44,-1.44,-1.47,-1.38,-0.97,0.12,0.53,1.28,1.06,1.06,1.25,1.47,2.31,3.12,4.94,5.53,6.09,5.84,5.25,3.78,2.56,1.75,0.94,1.56,1.53,2.06,1.84,1.38,1.12,0.28,0.56,1.16,1.91,2.66,3.59,4.16,5.88,5.88,7.31,8.53,8.19,7.97,7.31,6.84,5.91,4.91,5.66,6.06,6.38,7.59,8.38,8.5,8.97,8.84,7.75,6.12,5.31,4.12,2.44,2.25,2.22,3.31,5.88,8.09,10.44,12.03,12.0,12.56,11.5,10.88,9.88,8.97,7.62,7.16,5.59,4.41,2.81,1.41,0.47,-0.09,-0.72,-0.66,0.56,1.34,3.25,4.41,4.88,5.81,5.12,5.06,5.03,4.06,4.09,3.12,2.53,1.97,1.84,2.41,4.06,5.75,7.84,9.53,9.72,11.97,13.06,13.41,15.56,17.56,19.84,20.97,22.62,22.53,20.53,18.22,14.56,9.97,5.81,0.91,-2.84,-6.16,-6.47,-6.84,-5.84,-4.31,-2.72,-1.84,-1.59,-2.84,-3.97,-5.56,-6.81,-7.81,-7.47,-5.72,-3.84,-1.62,0.44,2.12,2.72,3.16,3.34,3.03,2.81,3.06,4.34,4.97,7.0,8.66,9.97,12.03,12.91,13.34,12.56,10.5,8.5,8.03,6.84,8.06,10.09,12.81,15.88,18.16,18.78,18.22,16.75,14.06,11.41,9.91,8.0,6.56,6.66,6.66,6.78,7.06,7.41,7.12,7.03,6.84,6.25,5.72,4.88,3.66,2