export PYTHONPATH=/path/to/trl:$PYTHONPATH 

accelerate launch   --main_process_port=39501 --config_file /path/to/trl/examples/accelerate_configs/deepspeed_zero3.yaml \
    /path/to/trl/run_scripts/rloo_ultrafeedback_feedback_v2.py \
    --dataset_name /path/to/trl/datasets/datasets--HuggingFaceH4--ultrafeedback_binarized \
    --dataset_train_split train_prefs \
    --output_dir /path/to/output_ckpt/$TASK/$EXP_NAME \
    --rloo_k 32 \
    --response_length 512 \
    --num_ppo_epochs 2 \
    --num_mini_batches 2 \
    --learning_rate 1e-6 \
    --per_device_train_batch_size 1 \
    --gradient_accumulation_steps 16 \
    --total_episodes  24000 \
    --model_name_or_path /path/to/trl/data/Meta-Llama-3-8B-Instruct \
    --sft_model_path /path/to/trl/data/Meta-Llama-3-8B-Instruct \
    --reward_model_path /path/to/trl/data/Skywork-Reward-V2-Llama-3.1-8B \
    --local_rollout_forward_batch_size 4 \
    --stop_token eos \
    --missing_eos_penalty 2.0 \
    --eval_steps 10 \
    --save_steps 20 \
    --save_strategy steps \
    --save_total_limit 8  \
    --exp_name $EXP_NAME  \
    --save_only_model true \
    --rm_with_feedback true \
    --kl_coef 0.02 \
    --rm_lr 1e-6 \
    --lqh false \
    --agg attention \
    --filter_length 512 \
    --fw 1.0 \
    --enable_lm false \
    --enable_le true \
    --le_weight 0.5 \
    --gradient_checkpointing true \
    --dynamic_fw true \
    --train_rm true \


