export CUDA_VISIBLE_DEVICES=3

target_model=(gpt)
n=5
m=50

datasets=(
    antonyms
    auto_categorization
    auto_debugging
    cause_and_effect
    common_concept
    diff
    informal_to_formal
    letters_list
    negation
    object_counting
    odd_one_out
    orthography_starts_with
    rhymes
    second_word_letter
    sentence_similarity
    sum
    synonyms
    taxonomy_animal
    word_sorting
    word_unscrambling
 )

for i in "${datasets[@]}"; do
    for j in "${target_model[@]}"; do
        for s in 1 2 3; do
            python experiments/run_neural_bandits.py \
            --seed $s \
            --task $i \
            --target_model $j \
            --n_prompt_tokens $n \
            --nu 1 \
            --lamdba 0.1 \
            --n_init 40 \
            --n_domain 10000 \
            --total_iter 165 \
            --local_training_iter 1000 \
            --n_eval 1000 \
            --intrinsic_dim $m \
            --gpt gpt-4.1 \
            --name iter165_gpt
        done
    done
done