class LinearIncreasingLRScheduler:
    def __init__(self, optimizer, lr_name, initial_lr, final_lr, num_epochs):
        self.optimizer = optimizer
        self.lr_name = lr_name
        self.initial_lr = initial_lr
        self.final_lr = final_lr
        self.num_epochs = num_epochs
        self.epoch = 0

    def get_lr(self):
        return self.initial_lr + (self.final_lr - self.initial_lr) * (self.epoch / self.num_epochs)

    def step(self):
        new_lr = self.get_lr()
        for param_group in self.optimizer.param_groups:
            param_group[self.lr_name] = new_lr
        self.epoch += 1