# BBL Anonymous Repository

### Prerequisites

```
# 1. Setup and activate conda environment
conda create --name env python=3.10.13 && conda activate env

# 2. Install OSL into the environment (anonymously modified public library)
pip install -e ./osl

# 3. Install PNPL into the environment
pip install -e ./pnpl

# 4. Install requirements for the paper (anonymized)
cd bbl
pip install -r requirements.txt
```

### Download datasets
- Armeni et al. https://data.ru.nl/collections/di/dccn/DSC_3011085.05_995
- Gwilliams et al. https://osf.io/ag3kj/
- Cam-CAN https://camcan-archive.mrc-cbu.cam.ac.uk/dataaccess/
- MOUS (optional) https://data.ru.nl/collections/di/dccn/DSC_3011020.09_236

Modify any `<config>.yaml` files you use to point to the directory of your downloaded datasets.

### Pre-training
Make sure you are inside the `bbl` folder.

Pre-train using all tasks with the Cam-CAN dataset:
`python train_rep.py --config configs/pretrain_camcan.yaml --name <your_experiment_name>`

### Fine-tuning

Train a linear probe with a frozen pre-trained backbone on your choice of dataset/task:

`python train_rep.py --config configs/<config> --checkpoint <pretrain_ckpt_location> --name <your_experiment_name>`

Choices of `<config>`:
- `armeni_speech_heldout.yaml`
- `armeni_voicing_heldout.yaml`
- `gwilliams_speech_heldout.yaml`
- `gwilliams_voicing_heldout.yaml`

All results will be reported under a project called "BBL" to your Weights & Biases account.