# Lie Group-Induced Dynamics in Score-Based Generative Modeling

We provide the code and instruction how to reproduce our experiments.
## Installation
The environment is best installed using the conda or [mamba](https://github.com/mamba-org/mamba) packaging manager.+

```bash
mamba env create -f environment.yaml
mamba activate sism
pip install -e .
```

## Repository Structure
The code for the MNIST, QM9, CrossDocked2020 experiments can be found in the `mnist`, `qm9` and `plcomplex` directories under this root.

The experiments to the 2D and 3D distributions can be found in the `notebooks` directory.

Configuration files are stored in the `config` directory with default configurations saved in `config/base_qm9.yaml` and `config/base_crossdocked`.

## Experiments
Currently the experiments for the 2D/3D toy datasets, MNIST, and QM9 can be performed since the CrossDocked experiments require the upload of the dataset which we currently cannot share on Github. 

The code to run the generalized score model on CrossDocked with the forward and reverse dynamics can be however found in `plcomplex/model.py`

### MNIST
```bash
mamba activate sism
python sism/mnist/train.py --use_conv --save_dir $PATH_TO_SAVE_EXPERIMENT
```

### QM9

```bash
mamba activate sism
python sism/qm9/run_train.py --conf config/base_qm9.yaml
```

### CrossDocked2020
Requires the processed dataset which is currently not provided. The training would be executed via
```bash
mamba activate sism
python sism/plcomplex/run_train.py --conf config/base_crossdocked.yaml
```

### Toy Distributions
We provide the jupyter notebook code in the `notebooks` directory from this root.
Specifically, we implement generalized score matching networks within the SDE formalism and compare against Fisher score networks for 2D and 3D toy distributions.