# Experiment Scripts for T1 Model

This directory contains scripts to reproduce experiments for the T1 model and baseline comparisons.

## Configuration

Before running the experiments, you may need to modify the dataset path and worker settings in each script:

```bash
export ROOT_BASE="/ssd/datasets/TimeSeries"  # Change to your dataset directory  
export NUM_WORKERS=8                         # Number of workers for data loading
```

## Available Scripts

### Dataset-specific scripts
- `run_ETTh1.sh` - ETT hourly dataset (subset 1)
- `run_ETTh2.sh` - ETT hourly dataset (subset 2)
- `run_ETTm1.sh` - ETT minute dataset (subset 1)
- `run_ETTm2.sh` - ETT minute dataset (subset 2)
- `run_electricity.sh` - Electricity load diagrams dataset
- `run_weather.sh` - Weather dataset
- `run_exchange.sh` - Exchange rate dataset
- `run_illness.sh` - Illness dataset
- `run_PEMS03.sh` - PEMS traffic dataset (subset 03)
- `run_physionet2012.sh` - PhysioNet Challenge 2012 dataset
- `run_pm25.sh` - PM2.5 air quality dataset

### Run all experiments
- `run_all.sh` - Runs all dataset experiments in sequence

## Usage

1. Make scripts executable:
```bash
chmod +x *.sh
```

2. Run a specific dataset experiment:
```bash
./run_ETTh1.sh
```

3. Run all experiments:
```bash
./run_all.sh
```

4. Run with custom settings:
```bash
ROOT_BASE=/path/to/your/data NUM_WORKERS=16 ./run_ETTh1.sh
```

## Models Included

Each script runs the following models:
1. **T1** (Our proposed model) - Always runs first
2. **SAITS** - Self-Attention-based Imputation
3. **BRITS** - Bidirectional RNN Imputation
4. **CSDI** - Conditional Score-based Diffusion
5. **ImputeFormer** - Imputation Transformer
6. **iTransformer** - Inverted Transformer
7. **PatchTST** - Patching Time Series Transformer
8. **DLinear** - Direct Linear
9. **ModernTCN** - Modern Temporal Convolutional Network
10. **TimesNet** - Time Series Network
11. **TimeMixerPP** - Time Series Mixer++

Note: Not all models are available for all datasets. Some configurations may be missing.

## Output

Results are saved in `lab/results/imputation_pypots/{dataset}/{model}/{config_id}/`

## Training Configuration

All models are configured with:
- `train_epochs`: 300
- `patience`: 30  
- `itr`: 5 (iterations)

These can be modified in the individual config files in `lab/configs/imputation_pypots/`.