#!/bin/bash
# ETTh1 dataset experiments
# This script runs all models for the ETTh1 dataset

# Configuration
export ROOT_BASE="datasets/TimeSeries"  # Change this to your dataset directory
export NUM_WORKERS=8                         # Number of workers for data loading

# Change to project root directory
cd "$(dirname "$0")/.."

echo "=========================================="
echo "Running ETTh1 experiments"
echo "Dataset root: $ROOT_BASE"
echo "Number of workers: $NUM_WORKERS"
echo "=========================================="

# T1 model (Our proposed model) - FIRST
echo -e "\n=== Running T1 model (Proposed) ==="
bash run.sh imputation_pypots/ETTh1/T1/9062_0000

# Baseline models
echo -e "\n=== Running SAITS ==="
bash run.sh imputation_pypots/ETTh1/SAITS/9051_0001

echo -e "\n=== Running BRITS ==="
bash run.sh imputation_pypots/ETTh1/BRITS/9010_0001

echo -e "\n=== Running CSDI ==="
bash run.sh imputation_pypots/ETTh1/CSDI/9010_0002

echo -e "\n=== Running ImputeFormer ==="
bash run.sh imputation_pypots/ETTh1/ImputeFormer/9051_0000

echo -e "\n=== Running iTransformer ==="
bash run.sh imputation_pypots/ETTh1/iTransformer/9051_0006

echo -e "\n=== Running PatchTST ==="
bash run.sh imputation_pypots/ETTh1/PatchTST/9051_0003

echo -e "\n=== Running DLinear ==="
bash run.sh imputation_pypots/ETTh1/DLinear/9051_0002

echo -e "\n=== Running ModernTCN ==="
bash run.sh imputation_pypots/ETTh1/ModernTCN/9051_0004

echo -e "\n=== Running TimesNet ==="
bash run.sh imputation_pypots/ETTh1/TimesNet/9051_0005

echo -e "\n=== Running TimeMixerPP ==="
bash run.sh imputation_pypots/ETTh1/TimeMixerPP/9051_0004

echo "=========================================="
echo "ETTh1 experiments completed!"
echo "=========================================="