#!/bin/bash
# ETTh2 dataset experiments
# This script runs all models for the ETTh2 dataset

# Configuration
export ROOT_BASE="datasets/TimeSeries"  # Change this to your dataset directory
export NUM_WORKERS=8                         # Number of workers for data loading

# Change to project root directory
cd "$(dirname "$0")/.."

echo "=========================================="
echo "Running ETTh2 experiments"
echo "Dataset root: $ROOT_BASE"
echo "Number of workers: $NUM_WORKERS"
echo "=========================================="

# T1 model (Our proposed model) - FIRST
echo -e "\n=== Running T1 model (Proposed) ==="
bash run.sh imputation_pypots/ETTh2/T1/9062_0001

# Baseline models
echo -e "\n=== Running SAITS ==="
bash run.sh imputation_pypots/ETTh2/SAITS/9051_0011

echo -e "\n=== Running BRITS ==="
bash run.sh imputation_pypots/ETTh2/BRITS/9010_0010

echo -e "\n=== Running CSDI ==="
bash run.sh imputation_pypots/ETTh2/CSDI/9010_0011

echo -e "\n=== Running ImputeFormer ==="
bash run.sh imputation_pypots/ETTh2/ImputeFormer/9051_0010

echo -e "\n=== Running iTransformer ==="
bash run.sh imputation_pypots/ETTh2/iTransformer/9051_0016

echo -e "\n=== Running PatchTST ==="
bash run.sh imputation_pypots/ETTh2/PatchTST/9051_0013

echo -e "\n=== Running DLinear ==="
bash run.sh imputation_pypots/ETTh2/DLinear/9051_0012

echo -e "\n=== Running ModernTCN ==="
bash run.sh imputation_pypots/ETTh2/ModernTCN/9051_0013

echo -e "\n=== Running TimesNet ==="
bash run.sh imputation_pypots/ETTh2/TimesNet/9051_0015

echo -e "\n=== Running TimeMixerPP ==="
bash run.sh imputation_pypots/ETTh2/TimeMixerPP/9051_0014

echo "=========================================="
echo "ETTh2 experiments completed!"
echo "=========================================="