#!/bin/bash
# ETTm1 dataset experiments
# This script runs all models for the ETTm1 dataset

# Configuration
export ROOT_BASE="datasets/TimeSeries"  # Change this to your dataset directory
export NUM_WORKERS=8                         # Number of workers for data loading

# Change to project root directory
cd "$(dirname "$0")/.."

echo "=========================================="
echo "Running ETTm1 experiments"
echo "Dataset root: $ROOT_BASE"
echo "Number of workers: $NUM_WORKERS"
echo "=========================================="

# T1 model (Our proposed model) - FIRST
echo -e "\n=== Running T1 model (Proposed) ==="
bash run.sh imputation_pypots/ETTm1/T1/9062_0002

# Baseline models
echo -e "\n=== Running SAITS ==="
bash run.sh imputation_pypots/ETTm1/SAITS/9051_0021

echo -e "\n=== Running BRITS ==="
bash run.sh imputation_pypots/ETTm1/BRITS/9010_0021

echo -e "\n=== Running CSDI ==="
bash run.sh imputation_pypots/ETTm1/CSDI/9010_0022

echo -e "\n=== Running ImputeFormer ==="
bash run.sh imputation_pypots/ETTm1/ImputeFormer/9051_0020

echo -e "\n=== Running iTransformer ==="
bash run.sh imputation_pypots/ETTm1/iTransformer/9051_0026

echo -e "\n=== Running PatchTST ==="
bash run.sh imputation_pypots/ETTm1/PatchTST/9051_0023

echo -e "\n=== Running DLinear ==="
bash run.sh imputation_pypots/ETTm1/DLinear/9051_0022

echo -e "\n=== Running ModernTCN ==="
bash run.sh imputation_pypots/ETTm1/ModernTCN/9051_0024

# Note: TimesNet config not found for ETTm1

echo -e "\n=== Running TimeMixerPP ==="
bash run.sh imputation_pypots/ETTm1/TimeMixerPP/9051_0024

echo "=========================================="
echo "ETTm1 experiments completed!"
echo "=========================================="