#!/bin/bash
# ETTm2 dataset experiments
# This script runs all models for the ETTm2 dataset

# Configuration
export ROOT_BASE="datasets/TimeSeries"  # Change this to your dataset directory
export NUM_WORKERS=8                         # Number of workers for data loading

# Change to project root directory
cd "$(dirname "$0")/.."

echo "=========================================="
echo "Running ETTm2 experiments"
echo "Dataset root: $ROOT_BASE"
echo "Number of workers: $NUM_WORKERS"
echo "=========================================="

# T1 model (Our proposed model) - FIRST
echo -e "\n=== Running T1 model (Proposed) ==="
bash run.sh imputation_pypots/ETTm2/T1/9062_0003

# Baseline models
echo -e "\n=== Running SAITS ==="
bash run.sh imputation_pypots/ETTm2/SAITS/9051_0031

echo -e "\n=== Running BRITS ==="
bash run.sh imputation_pypots/ETTm2/BRITS/9010_0031

echo -e "\n=== Running CSDI ==="
bash run.sh imputation_pypots/ETTm2/CSDI/9010_0032

echo -e "\n=== Running ImputeFormer ==="
bash run.sh imputation_pypots/ETTm2/ImputeFormer/9051_0030

echo -e "\n=== Running iTransformer ==="
bash run.sh imputation_pypots/ETTm2/iTransformer/9051_0036

echo -e "\n=== Running PatchTST ==="
bash run.sh imputation_pypots/ETTm2/PatchTST/9051_0033

echo -e "\n=== Running DLinear ==="
bash run.sh imputation_pypots/ETTm2/DLinear/9051_0032

echo -e "\n=== Running ModernTCN ==="
bash run.sh imputation_pypots/ETTm2/ModernTCN/9051_0034

# Note: TimesNet config not found for ETTm2

echo -e "\n=== Running TimeMixerPP ==="
bash run.sh imputation_pypots/ETTm2/TimeMixerPP/9051_0034

echo "=========================================="
echo "ETTm2 experiments completed!"
echo "=========================================="