#!/bin/bash
# PEMS03 dataset experiments
# This script runs all models for the PEMS03 dataset

# Configuration
export ROOT_BASE="datasets/TimeSeries"  # Change this to your dataset directory
export NUM_WORKERS=8                         # Number of workers for data loading

# Change to project root directory
cd "$(dirname "$0")/.."

echo "=========================================="
echo "Running PEMS03 experiments"
echo "Dataset root: $ROOT_BASE"
echo "Number of workers: $NUM_WORKERS"
echo "=========================================="

# T1 model (Our proposed model) - FIRST
echo -e "\n=== Running T1 model (Proposed) ==="
bash run.sh imputation_pypots/PEMS03/T1/9062_0008

# Baseline models
echo -e "\n=== Running SAITS ==="
bash run.sh imputation_pypots/PEMS03/SAITS/9051_0071

echo -e "\n=== Running BRITS ==="
bash run.sh imputation_pypots/PEMS03/BRITS/9010_0071

echo -e "\n=== Running CSDI ==="
bash run.sh imputation_pypots/PEMS03/CSDI/9010_0072

echo -e "\n=== Running ImputeFormer ==="
bash run.sh imputation_pypots/PEMS03/ImputeFormer/9051_0070

echo -e "\n=== Running iTransformer ==="
bash run.sh imputation_pypots/PEMS03/iTransformer/9051_0076

echo -e "\n=== Running PatchTST ==="
bash run.sh imputation_pypots/PEMS03/PatchTST/9051_0073

echo -e "\n=== Running DLinear ==="
bash run.sh imputation_pypots/PEMS03/DLinear/9051_0072

echo -e "\n=== Running ModernTCN ==="
bash run.sh imputation_pypots/PEMS03/ModernTCN/9051_0074

echo -e "\n=== Running TimesNet ==="
bash run.sh imputation_pypots/PEMS03/TimesNet/9051_0075

echo -e "\n=== Running TimeMixerPP ==="
bash run.sh imputation_pypots/PEMS03/TimeMixerPP/9051_0074

echo "=========================================="
echo "PEMS03 experiments completed!"
echo "=========================================="