#!/bin/bash
# Run all experiments across all datasets
# This script executes all dataset-specific scripts in sequence

# Configuration
export ROOT_BASE="datasets/TimeSeries"  # Change this to your dataset directory
export NUM_WORKERS=8                         # Number of workers for data loading

# Change to scripts directory
cd "$(dirname "$0")"

echo "=========================================="
echo "Running ALL experiments"
echo "Dataset root: $ROOT_BASE"
echo "Number of workers: $NUM_WORKERS"
echo "=========================================="

# Run each dataset experiment
datasets=(
    "ETTh1"
    "ETTh2"
    "ETTm1"
    "ETTm2"
    "electricity"
    "weather"
    "exchange"
    "illness"
    "PEMS03"
    "physionet2012"
    "pm25"
)

for dataset in "${datasets[@]}"; do
    echo -e "\n=========================================="
    echo "Starting $dataset experiments..."
    echo "=========================================="
    
    if [ -f "./run_${dataset}.sh" ]; then
        bash "./run_${dataset}.sh"
    else
        echo "Warning: Script run_${dataset}.sh not found!"
    fi
    
    echo -e "\n$dataset experiments finished."
done

echo -e "\n=========================================="
echo "ALL experiments completed!"
echo "=========================================="