#!/bin/bash
# Electricity dataset experiments
# This script runs all models for the electricity dataset

# Configuration
export ROOT_BASE="datasets/TimeSeries"  # Change this to your dataset directory
export NUM_WORKERS=8                         # Number of workers for data loading

# Change to project root directory
cd "$(dirname "$0")/.."

echo "=========================================="
echo "Running electricity experiments"
echo "Dataset root: $ROOT_BASE"
echo "Number of workers: $NUM_WORKERS"
echo "=========================================="

# T1 model (Our proposed model) - FIRST
echo -e "\n=== Running T1 model (Proposed) ==="
bash run.sh imputation_pypots/electricity/T1/9062_0005

# Baseline models
echo -e "\n=== Running SAITS ==="
bash run.sh imputation_pypots/electricity/SAITS/9051_0061

echo -e "\n=== Running BRITS ==="
bash run.sh imputation_pypots/electricity/BRITS/9010_0041

echo -e "\n=== Running CSDI ==="
bash run.sh imputation_pypots/electricity/CSDI/9010_0042

echo -e "\n=== Running ImputeFormer ==="
bash run.sh imputation_pypots/electricity/ImputeFormer/9051_0060

echo -e "\n=== Running iTransformer ==="
bash run.sh imputation_pypots/electricity/iTransformer/9051_0066

echo -e "\n=== Running PatchTST ==="
bash run.sh imputation_pypots/electricity/PatchTST/9051_0063

echo -e "\n=== Running DLinear ==="
bash run.sh imputation_pypots/electricity/DLinear/9051_0062

echo -e "\n=== Running ModernTCN ==="
bash run.sh imputation_pypots/electricity/ModernTCN/9051_0044

echo -e "\n=== Running TimesNet ==="
bash run.sh imputation_pypots/electricity/TimesNet/9051_0065

echo -e "\n=== Running TimeMixerPP ==="
bash run.sh imputation_pypots/electricity/TimeMixerPP/9051_0064

echo "=========================================="
echo "electricity experiments completed!"
echo "=========================================="