#!/bin/bash
# Exchange dataset experiments
# This script runs all models for the exchange dataset

# Configuration
export ROOT_BASE="datasets/TimeSeries"  # Change this to your dataset directory
export NUM_WORKERS=8                         # Number of workers for data loading

# Change to project root directory
cd "$(dirname "$0")/.."

echo "=========================================="
echo "Running exchange experiments"
echo "Dataset root: $ROOT_BASE"
echo "Number of workers: $NUM_WORKERS"
echo "=========================================="

# T1 model (Our proposed model) - FIRST
echo -e "\n=== Running T1 model (Proposed) ==="
bash run.sh imputation_pypots/exchange/T1/9062_0006

# Baseline models
echo -e "\n=== Running SAITS ==="
bash run.sh imputation_pypots/exchange/SAITS/9051_0041

echo -e "\n=== Running BRITS ==="
bash run.sh imputation_pypots/exchange/BRITS/9010_0051

echo -e "\n=== Running CSDI ==="
bash run.sh imputation_pypots/exchange/CSDI/9010_0052

echo -e "\n=== Running ImputeFormer ==="
bash run.sh imputation_pypots/exchange/ImputeFormer/9051_0040

echo -e "\n=== Running iTransformer ==="
bash run.sh imputation_pypots/exchange/iTransformer/9051_0046

echo -e "\n=== Running PatchTST ==="
bash run.sh imputation_pypots/exchange/PatchTST/9051_0043

echo -e "\n=== Running DLinear ==="
bash run.sh imputation_pypots/exchange/DLinear/9051_0042

echo -e "\n=== Running ModernTCN ==="
bash run.sh imputation_pypots/exchange/ModernTCN/9051_0054

echo -e "\n=== Running TimesNet ==="
bash run.sh imputation_pypots/exchange/TimesNet/9051_0045

echo -e "\n=== Running TimeMixerPP ==="
bash run.sh imputation_pypots/exchange/TimeMixerPP/9051_0044

echo "=========================================="
echo "exchange experiments completed!"
echo "=========================================="