#!/bin/bash
# Illness dataset experiments
# This script runs all models for the illness dataset

# Configuration
export ROOT_BASE="datasets/TimeSeries"  # Change this to your dataset directory
export NUM_WORKERS=8                         # Number of workers for data loading

# Change to project root directory
cd "$(dirname "$0")/.."

echo "=========================================="
echo "Running illness experiments"
echo "Dataset root: $ROOT_BASE"
echo "Number of workers: $NUM_WORKERS"
echo "=========================================="

# T1 model (Our proposed model) - FIRST
echo -e "\n=== Running T1 model (Proposed) ==="
bash run.sh imputation_pypots/illness/T1/9062_0007

# Baseline models
echo -e "\n=== Running SAITS ==="
bash run.sh imputation_pypots/illness/SAITS/9051_0051

echo -e "\n=== Running BRITS ==="
bash run.sh imputation_pypots/illness/BRITS/9010_0061

echo -e "\n=== Running CSDI ==="
bash run.sh imputation_pypots/illness/CSDI/9010_0062

echo -e "\n=== Running ImputeFormer ==="
bash run.sh imputation_pypots/illness/ImputeFormer/9051_0050

echo -e "\n=== Running iTransformer ==="
bash run.sh imputation_pypots/illness/iTransformer/9051_0056

echo -e "\n=== Running PatchTST ==="
bash run.sh imputation_pypots/illness/PatchTST/9051_0053

echo -e "\n=== Running DLinear ==="
bash run.sh imputation_pypots/illness/DLinear/9051_0052

echo -e "\n=== Running ModernTCN ==="
bash run.sh imputation_pypots/illness/ModernTCN/9051_0064

echo -e "\n=== Running TimesNet ==="
bash run.sh imputation_pypots/illness/TimesNet/9051_0055

echo -e "\n=== Running TimeMixerPP ==="
bash run.sh imputation_pypots/illness/TimeMixerPP/9051_0054

echo "=========================================="
echo "illness experiments completed!"
echo "=========================================="