#!/bin/bash
# PhysioNet 2012 dataset experiments
# This script runs all models for the physionet2012 dataset

# Configuration
export ROOT_BASE="datasets/TimeSeries"  # Change this to your dataset directory
export NUM_WORKERS=8                         # Number of workers for data loading

# Change to project root directory
cd "$(dirname "$0")/.."

echo "=========================================="
echo "Running physionet2012 experiments"
echo "Dataset root: $ROOT_BASE"
echo "Number of workers: $NUM_WORKERS"
echo "=========================================="

# T1 model (Our proposed model) - FIRST
echo -e "\n=== Running T1 model (Proposed) ==="
bash run.sh imputation_pypots/physionet2012/T1/9062_0010

# Baseline models
echo -e "\n=== Running SAITS ==="
bash run.sh imputation_pypots/physionet2012/SAITS/9051_0091

# Note: BRITS and CSDI configs not found for physionet2012

echo -e "\n=== Running ImputeFormer ==="
bash run.sh imputation_pypots/physionet2012/ImputeFormer/9051_0090

echo -e "\n=== Running iTransformer ==="
bash run.sh imputation_pypots/physionet2012/iTransformer/9051_0096

echo -e "\n=== Running PatchTST ==="
bash run.sh imputation_pypots/physionet2012/PatchTST/9051_0093

echo -e "\n=== Running DLinear ==="
bash run.sh imputation_pypots/physionet2012/DLinear/9051_0092

echo -e "\n=== Running ModernTCN ==="
bash run.sh imputation_pypots/physionet2012/ModernTCN/9051_0004

echo -e "\n=== Running TimesNet ==="
bash run.sh imputation_pypots/physionet2012/TimesNet/9051_0095

echo -e "\n=== Running TimeMixerPP ==="
bash run.sh imputation_pypots/physionet2012/TimeMixerPP/9051_0094

echo "=========================================="
echo "physionet2012 experiments completed!"
echo "=========================================="