#!/bin/bash
# PM2.5 dataset experiments
# This script runs all models for the pm25 dataset

# Configuration
export ROOT_BASE="datasets/TimeSeries"  # Change this to your dataset directory
export NUM_WORKERS=8                         # Number of workers for data loading

# Change to project root directory
cd "$(dirname "$0")/.."

echo "=========================================="
echo "Running pm25 experiments"
echo "Dataset root: $ROOT_BASE"
echo "Number of workers: $NUM_WORKERS"
echo "=========================================="

# T1 model (Our proposed model) - FIRST
echo -e "\n=== Running T1 model (Proposed) ==="
bash run.sh imputation_pypots/pm25/T1/9062_0011

# Baseline models
echo -e "\n=== Running SAITS ==="
bash run.sh imputation_pypots/pm25/SAITS/9051_0101

# Note: BRITS and CSDI configs not found for pm25

echo -e "\n=== Running ImputeFormer ==="
bash run.sh imputation_pypots/pm25/ImputeFormer/9051_0100

echo -e "\n=== Running iTransformer ==="
bash run.sh imputation_pypots/pm25/iTransformer/9051_0106

echo -e "\n=== Running PatchTST ==="
bash run.sh imputation_pypots/pm25/PatchTST/9051_0103

echo -e "\n=== Running DLinear ==="
bash run.sh imputation_pypots/pm25/DLinear/9051_0102

echo -e "\n=== Running ModernTCN ==="
bash run.sh imputation_pypots/pm25/ModernTCN/9051_0004

echo -e "\n=== Running TimesNet ==="
bash run.sh imputation_pypots/pm25/TimesNet/9051_0105

# Note: TimeMixerPP config not found for pm25

echo "=========================================="
echo "pm25 experiments completed!"
echo "=========================================="