#!/bin/bash
# Weather dataset experiments
# This script runs all models for the weather dataset

# Configuration
export ROOT_BASE="datasets/TimeSeries"  # Change this to your dataset directory
export NUM_WORKERS=8                         # Number of workers for data loading

# Change to project root directory
cd "$(dirname "$0")/.."

echo "=========================================="
echo "Running weather experiments"
echo "Dataset root: $ROOT_BASE"
echo "Number of workers: $NUM_WORKERS"
echo "=========================================="

# T1 model (Our proposed model) - FIRST
echo -e "\n=== Running T1 model (Proposed) ==="
bash run.sh imputation_pypots/weather/T1/9062_0004

# Baseline models
echo -e "\n=== Running SAITS ==="
bash run.sh imputation_pypots/weather/SAITS/9051_0111

echo -e "\n=== Running BRITS ==="
bash run.sh imputation_pypots/weather/BRITS/9010_0091

echo -e "\n=== Running CSDI ==="
bash run.sh imputation_pypots/weather/CSDI/9010_0092

echo -e "\n=== Running ImputeFormer ==="
bash run.sh imputation_pypots/weather/ImputeFormer/9051_0110

echo -e "\n=== Running iTransformer ==="
bash run.sh imputation_pypots/weather/iTransformer/9051_0116

echo -e "\n=== Running PatchTST ==="
bash run.sh imputation_pypots/weather/PatchTST/9051_0113

echo -e "\n=== Running DLinear ==="
bash run.sh imputation_pypots/weather/DLinear/9051_0112

echo -e "\n=== Running ModernTCN ==="
bash run.sh imputation_pypots/weather/ModernTCN/9051_0094

# Note: TimesNet config not found for weather

echo -e "\n=== Running TimeMixerPP ==="
bash run.sh imputation_pypots/weather/TimeMixerPP/9051_0114

echo "=========================================="
echo "weather experiments completed!"
echo "=========================================="