#!/bin/bash

echo "--- Ablation Study on Data Fractions for OPT-1.3B on GSM8K ---"

if [ -f "trained_models/gsm8k/opt-1.3b/ablation/prop0/training_args.bin" ]; then
    echo "Proportion 0 model already trained, skipping..."
else
    echo "Starting Proportion 0 Training"
    accelerate launch --config_file configs/accelerate_config/multi_gpu.yaml \
            curriculum_distill/train/self_evolve_cl_fix.py \
            --config configs/ablation/gsm8k/opt-1.3b/prop_0.json
    echo "Finished Proportion 0 Training"
fi

if [ -f "trained_models/gsm8k/opt-1.3b/ablation/prop25/training_args.bin" ]; then
    echo "Proportion 25 model already trained, skipping..."
else
    echo "Starting Proportion 25 Training"
    python3 curriculum_distill/cli.py --config configs/ablation/gsm8k/opt-1.3b/prop_25.json
    echo "Finished Proportion 25 Training"
fi

if [ -f "trained_models/gsm8k/opt-1.3b/ablation/prop50/training_args.bin" ]; then  
    echo "Proportion 50 model already trained, skipping..."
else
    echo "Starting Proportion 50 Training"
    python3 curriculum_distill/cli.py --config configs/ablation/gsm8k/opt-1.3b/prop_50.json
    echo "Finished Proportion 50 Training"
fi

if [ -f "trained_models/gsm8k/opt-1.3b/ablation/prop75/training_args.bin" ]; then  
    echo "Proportion 75 model already trained, skipping..."
else
    echo "Starting Proportion 75 Training"
    python3 curriculum_distill/cli.py --config configs/ablation/gsm8k/opt-1.3b/prop_75.json
    echo "Finished Proportion 75 Training"
fi  

# if [ -f "trained_models/gsm8k/opt-1.3b/ablation/prop100/training_args.bin" ]; then
#     echo "Proportion 100 model already trained, skipping..."
# else
#     echo "Starting Proportion 100 Training"
#     python3 curriculum_distill/cli.py --config configs/ablation/gsm8k/opt-1.3b/prop_100.json
#     echo "Finished Proportion 100 Training"
# fi

echo "--- Ablation Study on Data Depth for OPT-1.3B on GSM8K ---"

# if [ -f "trained_models/gsm8k/opt-1.3b/ablation/depth0/training_args.bin" ]; then
#     echo "Depth 0 model already trained, skipping..."
# else
#     echo "Starting Depth 0 Training"
#     python3 curriculum_distill/cli.py --config configs/ablation/gsm8k/opt-1.3b/depth_0.json
#     echo "Finished Depth 0 Training"
# fi

if [ -f "trained_models/gsm8k/opt-1.3b/ablation/depth1/training_args.bin" ]; then
    echo "Depth 1 model already trained, skipping..."
else
    echo "Starting Depth 1 Training"
    python3 curriculum_distill/cli.py --config configs/ablation/gsm8k/opt-1.3b/depth_1.json
    echo "Finished Depth 1 Training"
fi

if [ -f "trained_models/gsm8k/opt-1.3b/ablation/depth2/training_args.bin" ]; then
    echo "Depth 2 model already trained, skipping..."
else
    echo "Starting Depth 2 Training"
    python3 curriculum_distill/cli.py --config configs/ablation/gsm8k/opt-1.3b/depth_2.json
    echo "Finished Depth 2 Training"
fi


if [ -f "trained_models/gsm8k/opt-1.3b/ablation/depth3/training_args.bin" ]; then
    echo "Depth 3 model already trained, skipping..."
else
    echo "Starting Depth 3 Training"
    python3 curriculum_distill/cli.py --config configs/ablation/gsm8k/opt-1.3b/depth_3.json
    echo "Finished Depth 3 Training"
fi

# if [ -f "trained_models/gsm8k/opt-1.3b/ablation/depth4plus/training_args.bin" ]; then
#     echo "Depth 4+ model already trained, skipping..."
# else
#     echo "Starting Depth 4+ Training"
#     python3 curriculum_distill/cli.py --config configs/ablation/gsm8k/opt-1.3b/depth_4plus.json
#     echo "Finished Depth 4+ Training"
# fi


echo "--- Ablation Study on Data Fractions for OPT-2.7B on GSM8K ---"

if [ -f "trained_models/gsm8k/opt-2.7b/ablation/prop0/training_args.bin" ]; then
    echo "Proportion 0 model already trained, skipping..."
else
    echo "Starting Proportion 0 Training"
    accelerate launch --config_file configs/accelerate_config/multi_gpu.yaml \
            curriculum_distill/train/self_evolve_cl_fix.py \
            --config configs/ablation/gsm8k/opt-2.7b/prop_0.json
    echo "Finished Proportion 0 Training"
fi

if [ -f "trained_models/gsm8k/opt-2.7b/ablation/prop25/training_args.bin" ]; then
    echo "Proportion 25 model already trained, skipping..."
else
    echo "Starting Proportion 25 Training"
    python3 curriculum_distill/cli.py --config configs/ablation/gsm8k/opt-2.7b/prop_25.json
    echo "Finished Proportion 25 Training"
fi

if [ -f "trained_models/gsm8k/opt-2.7b/ablation/prop50/training_args.bin" ]; then  
    echo "Proportion 50 model already trained, skipping..."
else
    echo "Starting Proportion 50 Training"
    python3 curriculum_distill/cli.py --config configs/ablation/gsm8k/opt-2.7b/prop_50.json
    echo "Finished Proportion 50 Training"
fi

if [ -f "trained_models/gsm8k/opt-2.7b/ablation/prop75/training_args.bin" ]; then  
    echo "Proportion 75 model already trained, skipping..."
else
    echo "Starting Proportion 75 Training"
    python3 curriculum_distill/cli.py --config configs/ablation/gsm8k/opt-2.7b/prop_75.json
    echo "Finished Proportion 75 Training"
fi

# if [ -f "trained_models/gsm8k/opt-2.7b/ablation/prop100/training_args.bin" ]; then
#     echo "Proportion 100 model already trained, skipping..."
# else
#     echo "Starting Proportion 100 Training"
#     python3 curriculum_distill/cli.py --config configs/ablation/gsm8k/opt-2.7b/prop_100.json
#     echo "Finished Proportion 100 Training"
# fi    

echo "--- Ablation Study on Data Depth for OPT-2.7B on GSM8K ---"
# if [ -f "trained_models/gsm8k/opt-2.7b/ablation/depth0/training_args.bin" ]; then
#     echo "Depth 0 model already trained, skipping..."
# else
#     echo "Starting Depth 0 Training"
#     python3 curriculum_distill/cli.py --config configs/ablation/gsm8k/opt-2.7b/depth_0.json
#     echo "Finished Depth 0 Training"
# fi

if [ -f "trained_models/gsm8k/opt-2.7b/ablation/depth1/training_args.bin" ]; then
    echo "Depth 1 model already trained, skipping..."
else
    echo "Starting Depth 1 Training"
    python3 curriculum_distill/cli.py --config configs/ablation/gsm8k/opt-2.7b/depth_1.json
    echo "Finished Depth 1 Training"
fi

if [ -f "trained_models/gsm8k/opt-2.7b/ablation/depth2/training_args.bin" ]; then
    echo "Depth 2 model already trained, skipping..."
else
    echo "Starting Depth 2 Training"
    python3 curriculum_distill/cli.py --config configs/ablation/gsm8k/opt-2.7b/depth_2.json
    echo "Finished Depth 2 Training"
fi

if [ -f "trained_models/gsm8k/opt-2.7b/ablation/depth3/training_args.bin" ]; then
    echo "Depth 3 model already trained, skipping..."
else
    echo "Starting Depth 3 Training"
    python3 curriculum_distill/cli.py --config configs/ablation/gsm8k/opt-2.7b/depth_3.json
    echo "Finished Depth 3 Training"
fi

# if [ -f "trained_models/gsm8k/opt-2.7b/ablation/depth4plus/training_args.bin" ]; then
#     echo "Depth 4+ model already trained, skipping..."
# else
#     echo "Starting Depth 4+ Training"
#     python3 curriculum_distill/cli.py --config configs/ablation/gsm8k/opt-2.7b/depth_4plus.json
#     echo "Finished Depth 4+ Training"
# fi

