#!/bin/bash


echo "--- Ablation Study on Training Schedules for OPT-1.3B on GSM8K ---"

if [ -f "trained_models/gsm8k/opt-1.3b/naive_cl/training_args.bin" ]; then
    echo "Naive CL model already trained, skipping..."
else
    echo "Starting Naive CL Training"
    python3 curriculum_distill/cli.py --config configs/gsm8k/opt-1.3b/naive_cl.json
    echo "Finished Naive CL Training"
fi

if [ -f "trained_models/gsm8k/opt-1.3b/naive_cl_reverse/training_args.bin" ]; then
    echo "Reverse Naive CL model already trained, skipping..."
else
    echo "Starting Reverse Naive CL Training"
    python3 curriculum_distill/cli.py --config configs/gsm8k/opt-1.3b/naive_cl_reverse.json
    echo "Finished Reverse Naive CL Training"
fi

if [ -f "trained_models/gsm8k/opt-1.3b/kd/training_args.bin" ]; then
    echo "KD model already trained, skipping..."
else
    echo "Starting KD Training"
    python3 curriculum_distill/cli.py --config configs/gsm8k/opt-1.3b/kd.json
    echo "Finished KD Training"
fi

echo "--- Ablation Study on Training Schedules for OPT-2.7B on GSM8K ---"

if [ -f "trained_models/gsm8k/opt-2.7b/naive_cl/training_args.bin" ]; then
    echo "Naive CL model already trained, skipping..."
else
    echo "Starting Naive CL Training"
    python3 curriculum_distill/cli.py --config configs/gsm8k/opt-2.7b/naive_cl.json
    echo "Finished Naive CL Training"
fi

if [ -f "trained_models/gsm8k/opt-2.7b/naive_cl_reverse/training_args.bin" ]; then
    echo "Reverse Naive CL model already trained, skipping..."
else
    echo "Starting Reverse Naive CL Training"
    python3 curriculum_distill/cli.py --config configs/gsm8k/opt-2.7b/naive_cl_reverse.json
    echo "Finished Reverse Naive CL Training"
fi

if [ -f "trained_models/gsm8k/opt-2.7b/kd/training_args.bin" ]; then
    echo "KD model already trained, skipping..."
else
    echo "Starting KD Training"
    python3 curriculum_distill/cli.py --config configs/gsm8k/opt-2.7b/kd.json
    echo "Finished KD Training"
fi
