#!/bin/bash

echo "--- Training OPT-1.3B on GSM8K ---"


# check if there is any *.safetensors file in the save path
if [ -f "trained_models/gsm8k/opt-1.3b/self_evolve_cl/training_args.bin" ]; then
    echo "Found existing checkpoint, skipping training."
else
    echo "No existing checkpoint found, starting training."
    echo "Starting Self-Evolve CL Training"
    python3 curriculum_distill/cli.py --config configs/gsm8k/opt-1.3b/self_evolve_cl.json
    echo "Finished Self-Evolve CL Training"
fi

if [ -f "trained_models/gsm8k/opt-1.3b/kd_original/training_args.bin" ]; then
    echo "Found existing checkpoint, skipping training."
else
    echo "No existing checkpoint found, starting training."
    echo "Starting KD Original Training"
    python3 curriculum_distill/cli.py --config configs/gsm8k/opt-1.3b/kd_original.json
    echo "Finished KD Original Training"
fi



echo "--- Training OPT-2.7B on GSM8K ---"


if [ -f "trained_models/gsm8k/opt-2.7b/self_evolve_cl/training_args.bin" ]; then
    echo "Found existing checkpoint, skipping training."
else
    echo "No existing checkpoint found, starting training."
    echo "Starting Self-Evolve CL Training"
    python3 curriculum_distill/cli.py --config configs/gsm8k/opt-2.7b/self_evolve_cl.json
    echo "Finished Self-Evolve CL Training"
fi

if [ -f "trained_models/gsm8k/opt-2.7b/kd_original/training_args.bin" ]; then
    echo "Found existing checkpoint, skipping training."
else
    echo "No existing checkpoint found, starting training."
    echo "Starting KD Original Training"
    python3 curriculum_distill/cli.py --config configs/gsm8k/opt-2.7b/kd_original.json
    echo "Finished KD Original Training"
fi



echo "--- Training Pythia-1.4B on GSM8K ---"

if [ -f "trained_models/gsm8k/pythia-1.4b/self_evolve_cl/training_args.bin" ]; then
    echo "Found existing checkpoint, skipping training."
else
    echo "No existing checkpoint found, starting training."
    echo "Starting Self-Evolve CL Training"
    python3 curriculum_distill/cli.py --config configs/gsm8k/pythia-1.4b/self_evolve_cl.json
    echo "Finished Self-Evolve CL Training"
fi

if [ -f "trained_models/gsm8k/pythia-1.4b/kd_original/training_args.bin" ]; then
    echo "Found existing checkpoint, skipping training."
else
    echo "No existing checkpoint found, starting training."
    echo "Starting KD Original Training"
    python3 curriculum_distill/cli.py --config configs/gsm8k/pythia-1.4b/kd_original.json
    echo "Finished KD Original Training"
fi



echo "--- Training Pythia-2.8B on GSM8K ---"

if [ -f "trained_models/gsm8k/pythia-2.8b/self_evolve_cl/training_args.bin" ]; then
    echo "Found existing checkpoint, skipping training."
else
    echo "No existing checkpoint found, starting training."
    echo "Starting Self-Evolve CL Training"
    python3 curriculum_distill/cli.py --config configs/gsm8k/pythia-2.8b/self_evolve_cl.json
    echo "Finished Self-Evolve CL Training"
fi

if [ -f "trained_models/gsm8k/pythia-2.8b/kd_original/training_args.bin" ]; then
    echo "Found existing checkpoint, skipping training."
else
    echo "No existing checkpoint found, starting training."
    echo "Starting KD Original Training"
    python3 curriculum_distill/cli.py --config configs/gsm8k/pythia-2.8b/kd_original.json
    echo "Finished KD Original Training"
fi



echo "--- Training OPT-1.3B on entailment-bank ---"

if [ -f "trained_models/entailment-bank/opt-1.3b/self_evolve_cl/training_args.bin" ]; then
    echo "Found existing checkpoint, skipping training."
else
    echo "No existing checkpoint found, starting training."
    echo "Starting Self-Evolve CL Training"
    python3 curriculum_distill/cli.py --config configs/entailment-bank/opt-1.3b/self_evolve_cl.json
    echo "Finished Self-Evolve CL Training"
fi

if [ -f "trained_models/entailment-bank/opt-1.3b/kd_original/training_args.bin" ]; then
    echo "Found existing checkpoint, skipping training."
else
    echo "No existing checkpoint found, starting training."
    echo "Starting KD Original Training"
    python3 curriculum_distill/cli.py --config configs/entailment-bank/opt-1.3b/kd_original.json
    echo "Finished KD Original Training"
fi


echo "--- Training OPT-2.7B on entailment-bank ---"

if [ -f "trained_models/entailment-bank/opt-2.7b/self_evolve_cl/training_args.bin" ]; then
    echo "Found existing checkpoint, skipping training."
else
    echo "No existing checkpoint found, starting training."
    echo "Starting Self-Evolve CL Training"
    python3 curriculum_distill/cli.py --config configs/entailment-bank/opt-2.7b/self_evolve_cl.json
    echo "Finished Self-Evolve CL Training"
fi

if [ -f "trained_models/entailment-bank/opt-2.7b/kd_original/training_args.bin" ]; then
    echo "Found existing checkpoint, skipping training."
else
    echo "No existing checkpoint found, starting training."
    echo "Starting KD Original Training"
    python3 curriculum_distill/cli.py --config configs/entailment-bank/opt-2.7b/kd_original.json
    echo "Finished KD Original Training"
fi



echo "--- Training Pythia-1.4B on entailment-bank ---"

if [ -f "trained_models/entailment-bank/pythia-1.4b/self_evolve_cl/training_args.bin" ]; then
    echo "Found existing checkpoint, skipping training."
else
    echo "No existing checkpoint found, starting training."
    echo "Starting Self-Evolve CL Training"
    python3 curriculum_distill/cli.py --config configs/entailment-bank/pythia-1.4b/self_evolve_cl.json
    echo "Finished Self-Evolve CL Training"
fi

if [ -f "trained_models/entailment-bank/pythia-1.4b/kd_original/training_args.bin" ]; then
    echo "Found existing checkpoint, skipping training."
else
    echo "No existing checkpoint found, starting training."
    echo "Starting KD Original Training"
    python3 curriculum_distill/cli.py --config configs/entailment-bank/pythia-1.4b/kd_original.json
    echo "Finished KD Original Training"
fi




echo "--- Training Pythia-2.8B on entailment-bank ---"

if [ -f "trained_models/entailment-bank/pythia-2.8b/self_evolve_cl/training_args.bin" ]; then
    echo "Found existing checkpoint, skipping training."
else
    echo "No existing checkpoint found, starting training."
    echo "Starting Self-Evolve CL Training"
    python3 curriculum_distill/cli.py --config configs/entailment-bank/pythia-2.8b/self_evolve_cl.json
    echo "Finished Self-Evolve CL Training"
fi

if [ -f "trained_models/entailment-bank/pythia-2.8b/kd_original/training_args.bin" ]; then
    echo "Found existing checkpoint, skipping training."
else
    echo "No existing checkpoint found, starting training."
    echo "Starting KD Original Training"
    python3 curriculum_distill/cli.py --config configs/entailment-bank/pythia-2.8b/kd_original.json
    echo "Finished KD Original Training"
fi

