function [R_pos, P_pos, R_neg, P_neg, test_R_pos, test_P_pos, test_R_neg, test_P_neg] = CPM(path,path3)
%myFun - Description
%
% Syntax: output = myFun(input)
%
% Long description
% ------------ INPUTS -------------------
load(path)
load(path3)

all_mats  = rest_1_mats;
all_behav = PMAT_CR;

final_test_mats = all_mats(:,test_id);
final_test_behave = all_behav(test_id);

all_mats = all_mats(:,train_id);
all_behav = all_behav(train_id);

% threshold for feature selection
thresh = 0.05; 

% ---------------------------------------

no_sub = size(all_mats,2);
no_test_sub = size(final_test_mats,2);
no_node = size(all_mats,1);

behav_pred_pos = zeros(no_sub,1);
behav_pred_neg = zeros(no_sub,1);

for leftout = 1:no_sub
    fprintf('\n Leaving out subj # %6.3f',leftout);
    
    % leave out subject from matrices and behavior
    
    train_mats = all_mats;
    train_mats(:,leftout) = [];
    train_vcts = reshape(train_mats,[],size(train_mats,2));
    
    train_behav = all_behav;
    train_behav(leftout) = [];
    
    % correlate all edges with behavior

    [r_mat,p_mat] = corr(train_vcts',train_behav);

    % set threshold and define masks
    
    pos_mask = zeros(no_node,1);
    neg_mask = zeros(no_node,1);
    
    pos_edges = find(r_mat > 0 & p_mat < thresh);
    neg_edges = find(r_mat < 0 & p_mat < thresh);
    
    pos_mask(pos_edges) = 1;
    neg_mask(neg_edges) = 1;
    
    % get sum of all edges in TRAIN subs (divide by 2 to control for the
    % fact that matrices are symmetric)
    
    train_sumpos = zeros(no_sub-1,1);
    train_sumneg = zeros(no_sub-1,1);
    
    for ss = 1:size(train_sumpos)
        train_sumpos(ss) = sum(sum(train_mats(:,ss).*pos_mask));
        train_sumneg(ss) = sum(sum(train_mats(:,ss).*neg_mask));
    end
    
    % build model on TRAIN subs
    
    fit_pos = polyfit(train_sumpos, train_behav,1);
    fit_neg = polyfit(train_sumneg, train_behav,1);
    
    % run model on TEST sub
    
    test_mat = all_mats(:,leftout);
    test_sumpos = sum(sum(test_mat.*pos_mask));
    test_sumneg = sum(sum(test_mat.*neg_mask));
    
    behav_pred_pos(leftout) = fit_pos(1)*test_sumpos + fit_pos(2);
    behav_pred_neg(leftout) = fit_neg(1)*test_sumneg + fit_neg(2);
    
end

% compare predicted and observed scores

[R_pos, P_pos] = corr(behav_pred_pos,all_behav);
[R_neg, P_neg] = corr(behav_pred_neg,all_behav);

%final test
% correlate all edges with behavior

[r_mat,p_mat] = corr(all_mats',all_behav);

final_pos_mask = zeros(no_node,1);
final_neg_mask = zeros(no_node,1);

final_neg_edges =  find(r_mat < 0 & p_mat < thresh);
final_pos_edges =  find(r_mat > 0 & p_mat < thresh);

final_pos_mask(final_pos_edges) = 1;
final_neg_mask(final_neg_edges) = 1;

% first get the train linear model
train_sumpos = zeros(no_sub,1);
train_sumneg = zeros(no_sub,1);

for ss = 1:size(train_sumpos)
    train_sumpos(ss) = sum(sum(all_mats(:,ss).*final_pos_mask));
    train_sumneg(ss) = sum(sum(all_mats(:,ss).*final_neg_mask));
end

fit_pos = polyfit(train_sumpos, all_behav,1);
fit_neg = polyfit(train_sumneg, all_behav,1);

% evual on test

test_sumpos = zeros(no_test_sub,1);
test_sumneg = zeros(no_test_sub,1);

for ss = 1:size(test_sumpos)
    test_sumpos(ss) = sum(sum(final_test_mats(:,ss).*final_pos_mask));
    test_sumneg(ss) = sum(sum(final_test_mats(:,ss).*final_neg_mask));
end

test_behav_pos = fit_pos(1)*test_sumpos + fit_pos(2);
test_behav_neg = fit_neg(1)*test_sumneg + fit_neg(2);


[test_R_pos, test_P_pos] = corr(test_behav_pos,final_test_behave);
[test_R_neg, test_P_neg] = corr(test_behav_neg,final_test_behave);

