function [R_pos, P_pos, R_neg, P_neg, test_R_pos, test_P_pos, test_R_neg, test_P_neg, final_pos_mask1, final_neg_mask1, r_mat1, r_mat2, p_mat1, p_mat2] = CPM2(path, path2, path3)
% ------------ INPUTS -------------------
    load(path)
    load(path2)
    load(path3)
    
    hyper_mats  = rest_1_mats;
    con_mats = pearson;
    all_behav = fluidcomp;
%set test set
    final_test_hyper_mats = hyper_mats(:,test_id);
    final_test_con_mats = con_mats(:,test_id);
    final_test_behave = all_behav(test_id);
%set train set
    hyper_mats = hyper_mats(:,train_id);
    con_mats  = con_mats(:,train_id);
    all_behav = all_behav(train_id);
    
    % threshold for feature selection
    thresh = 0.05; 
    
    % ---------------------------------------
    
    no_sub = size(hyper_mats,2);
    no_node = size(hyper_mats,1);
    no_node2 = size(con_mats,1);
    no_test_sub = size(final_test_con_mats,2);


    behav_pred_pos = zeros(no_sub,1);
    behav_pred_neg = zeros(no_sub,1);
    
    
    for leftout = 1:no_sub
        fprintf('\rLeaving out subj # %6.3f', leftout);
        
        % leave out subject from matrices and behavior
        
        train_mats1 = hyper_mats;
        train_mats1(:,leftout) = [];
        train_vcts1 = reshape(train_mats1,[],size(train_mats1,2));
        train_mats2 = con_mats;
        train_mats2(:,leftout) = [];
        train_vcts2 = reshape(train_mats2,[],size(train_mats2,2));
        
        train_behav = all_behav;
        train_behav(leftout) = [];
        
        % correlate all hyperedges with behavior
    
        [r_mat1,p_mat1] = corr(train_vcts1',train_behav);
    
        % set threshold and define masks
        
        pos_mask1 = zeros(no_node,1);
        neg_mask1 = zeros(no_node,1);
        
        pos_edges1 = find(r_mat1 > 0 & p_mat1 < thresh);
        neg_edges1 = find(r_mat1 < 0 & p_mat1 < thresh);
        
        pos_mask1(pos_edges1) = 1;
        neg_mask1(neg_edges1) = 1;
        
        % get sum of all edges in TRAIN subs (divide by 2 to control for the
        % fact that matrices are symmetric)
        
        train_sumpos1 = zeros(no_sub-1,1);
        train_sumneg1 = zeros(no_sub-1,1);
        
        for ss = 1:size(train_sumpos1)
            train_sumpos1(ss) = sum(sum(train_mats1(:,ss).*pos_mask1));
            train_sumneg1(ss) = sum(sum(train_mats1(:,ss).*neg_mask1));
        end
        

        % correlate all person edges with behavior
    
        [r_mat2,p_mat2] = corr(train_vcts2',train_behav);
    
        % set threshold and define masks
        
        pos_mask2 = zeros(no_node2,1);
        neg_mask2 = zeros(no_node2,1);
        
        pos_edges2 = find(r_mat2 > 0 & p_mat2 < thresh);
        neg_edges2 = find(r_mat2 < 0 & p_mat2 < thresh);
        
        pos_mask2(pos_edges2) = 1;
        neg_mask2(neg_edges2) = 1;
        
        % get sum of all edges in TRAIN subs (divide by 2 to control for the
        % fact that matrices are symmetric)
        
        train_sumpos2 = zeros(no_sub-1,1);
        train_sumneg2 = zeros(no_sub-1,1);
        
        for ss = 1:size(train_sumpos2)
            train_sumpos2(ss) = sum(sum(train_mats2(:,ss).*pos_mask2));
            train_sumneg2(ss) = sum(sum(train_mats2(:,ss).*neg_mask2));
        end

        % build model on TRAIN subs
        X_pos=[ones(size(train_behav)) train_sumpos1 train_sumpos2];  
        b_pos= regress(train_behav,X_pos);
    
        X_neg=[ones(size(train_behav)) train_sumneg1 train_sumneg2];  
        b_neg= regress(train_behav,X_neg);
        
        % run model on TEST sub
        
        test_mat1 = hyper_mats(:,leftout);
        test_mat2 = con_mats(:,leftout);

        test_sumpos1 = sum(sum(test_mat1.*pos_mask1));
        test_sumneg1 = sum(sum(test_mat1.*neg_mask1));
        
        test_sumpos2 = sum(sum(test_mat2.*pos_mask2))/2;
        test_sumneg2 = sum(sum(test_mat2.*neg_mask2))/2;

        behav_pred_pos(leftout) = b_pos(2)*test_sumpos1 + b_pos(3)*test_sumpos2 + b_pos(1);
        behav_pred_neg(leftout) = b_neg(2)*test_sumneg1 + b_neg(3)*test_sumneg2 + b_neg(1);
        
    end
    
    % compare predicted and observed scores
    
    [R_pos, P_pos] = corr(behav_pred_pos,all_behav);
    [R_neg, P_neg] = corr(behav_pred_neg,all_behav);

    %final test
    % correlate all edges with behavior
    [r_mat1,p_mat1] = corr(hyper_mats',all_behav);
    
    % set threshold and define masks
    
    final_pos_mask1 = zeros(no_node,1);
    final_neg_mask1 = zeros(no_node,1);
    
    final_pos_edges1 = find(r_mat1 > 0 & p_mat1 < thresh);
    final_neg_edges1 = find(r_mat1 < 0 & p_mat1 < thresh);
    
    final_pos_mask1(final_pos_edges1) = 1;
    final_neg_mask1(final_neg_edges1) = 1;
    
    
    
    % first get the train linear model
    train_sumpos1 = zeros(no_sub,1);
    train_sumneg1 = zeros(no_sub,1);
    
    for ss = 1:size(train_sumpos1)
        train_sumpos1(ss) = sum(sum(hyper_mats(:,ss).*final_pos_mask1));
        train_sumneg1(ss) = sum(sum(hyper_mats(:,ss).*final_neg_mask1));
    end
    

    % correlate all person edges with behavior

    [r_mat2,p_mat2] = corr(con_mats',all_behav);

    % set threshold and define masks
    
    final_pos_mask2 = zeros(no_node2,1);
    final_neg_mask2 = zeros(no_node2,1);
    
    final_pos_edges2 = find(r_mat2 > 0 & p_mat2 < thresh);
    final_neg_edges2 = find(r_mat2 < 0 & p_mat2 < thresh);
    
    final_pos_mask2(final_pos_edges2) = 1;
    final_neg_mask2(final_neg_edges2) = 1;



    % get sum of all edges in TRAIN subs (divide by 2 to control for the
    % fact that matrices are symmetric)
    
    train_sumpos2 = zeros(no_sub,1);
    train_sumneg2 = zeros(no_sub,1);
    
    for ss = 1:size(train_sumpos2)
        train_sumpos2(ss) = sum(sum(con_mats(:,ss).*final_pos_mask2));
        train_sumneg2(ss) = sum(sum(con_mats(:,ss).*final_neg_mask2));
    end

    % build model on TRAIN subs
    X_pos=[ones(size(all_behav)) train_sumpos1 train_sumpos2];  
    b_pos= regress(all_behav,X_pos);

    X_neg=[ones(size(all_behav)) train_sumneg1 train_sumneg2];  
    b_neg= regress(all_behav,X_neg);
    
    

    % run model on TEST sub
    %hyper
    test_sumpos1 = zeros(no_test_sub,1);
    test_sumneg1 = zeros(no_test_sub,1);    
    %pearson con 
    test_sumpos2 = zeros(no_test_sub,1);
    test_sumneg2 = zeros(no_test_sub,1);    
    
    for ss = 1:size(test_sumpos1)
        test_sumpos1(ss) = sum(sum(final_test_hyper_mats(:,ss).*final_pos_mask1));
        test_sumneg1(ss) = sum(sum(final_test_hyper_mats(:,ss).*final_neg_mask1));
        %devide by two since symmetric
        test_sumpos2(ss) = sum(sum(final_test_con_mats(:,ss).*final_pos_mask2))/2;
        test_sumneg2(ss) = sum(sum(final_test_con_mats(:,ss).*final_neg_mask2))/2;
    end

    test_behav_pos= b_pos(2)*test_sumpos1 + b_pos(3)*test_sumpos2 + b_pos(1);
    test_behav_neg = b_neg(2)*test_sumneg1 + b_neg(3)*test_sumneg2 + b_neg(1);

    % evual on test
    [test_R_pos, test_P_pos] = corr(test_behav_pos,final_test_behave);
    [test_R_neg, test_P_neg] = corr(test_behav_neg,final_test_behave);


end