#Fooling Contrastive Language-Image Pre-training with CLIPMasterPrints

Installation
-------

clipmasterprints builds upon the stable diffusion conda enviroment and decoder model.
To run LVE optimization code in the repository, you need to download and set up both (otherwise you'll probably be fine skipping these steps and can just install from source):

```
mkdir external
cd external

# clone repository
git clone https://github.com/CompVis/stable-diffusion.git

# get correct commit
git checkout 69ae4b35e0a0f6ee1af8bb9a5d0016ccb27e36dc

# created and activate conda env with SD dependencies
cd stable-diffusion
conda env create -f environment.yaml
conda activate ldm

# install SD from source into conda env
pip install -e .

# move previously downloaded SD sd-v1-4.ckpt into correct folder
# (Refer to https://github.com/CompVis/ for where to download the checkpoint)
ln -s <path/to/sd-v1-4.ckpt> models/ldm/stable-diffusion-v1/model.ckpt 

# return to base dir
cd ../..

```

After all Stable Diffusion dependencies are installed, install the package from source using

```
pip install -e .
```

Mining and evaluating CLIPMasterPrints
-------

To mine fooling master images, use
```
python train/mine.py --config-path config/<config-name>.yaml
```
where ```<config-name>``` is a placeholder for the desired config file.
Use ```cmp_artworks*.yaml``` to target artwork captions or ```cmp_imagenet_classes_*.yaml``` to reproduce our experiments on imagenet class captions.

To display some plots for mined images, execute
```
python eval/eval_results.py
```
