if [ ! -d "./logs" ]; then
    mkdir ./logs
fi

model_name=MixLinear

root_path_name=./dataset/
data_path_name=electricity.csv
model_id_name=Electricity
data_name=custom
alpha=1
batch_size=16
seq_len=720

pred_len=96
batch_size=64
python3 -u run_longExp.py \
    --is_training 1 \
    --root_path $root_path_name \
    --data_path $data_path_name \
    --model_id $model_id_name'_'$seq_len'_'$pred_len \
    --model $model_name \
    --data $data_name \
    --features M \
    --seq_len $seq_len \
    --pred_len $pred_len \
    --period_len 24 \
    --enc_in 321 \
    --train_epochs 30 \
    --patience 5 \
    --alpha $alpha \
    --gpu 0 \
    --itr 1 --batch_size $batch_size --learning_rate 0.03 > logs/${model_name}_${model_id_name}_${pred_len}_${batch_size}_${alpha}.log & 


pred_len=192
batch_size=256
python3 -u run_longExp.py \
    --is_training 1 \
    --root_path $root_path_name \
    --data_path $data_path_name \
    --model_id $model_id_name'_'$seq_len'_'$pred_len \
    --model $model_name \
    --data $data_name \
    --features M \
    --seq_len $seq_len \
    --pred_len $pred_len \
    --period_len 24 \
    --enc_in 321 \
    --train_epochs 30 \
    --patience 5 \
    --alpha $alpha \
    --gpu 1 \
    --itr 1 --batch_size $batch_size --learning_rate 0.03 > logs/${model_name}_${model_id_name}_${pred_len}_${batch_size}_${alpha}.log &



pred_len=336
batch_size=310
python3 -u run_longExp.py \
    --is_training 1 \
    --root_path $root_path_name \
    --data_path $data_path_name \
    --model_id $model_id_name'_'$seq_len'_'$pred_len \
    --model $model_name \
    --data $data_name \
    --features M \
    --seq_len $seq_len \
    --pred_len $pred_len \
    --period_len 24 \
    --enc_in 321 \
    --train_epochs 30 \
    --patience 5 \
    --alpha $alpha \
    --gpu 2 \
    --itr 1 --batch_size $batch_size --learning_rate 0.03 > logs/${model_name}_${model_id_name}_${pred_len}_${batch_size}_${alpha}.log &



pred_len=720
batch_size=310
python3 -u run_longExp.py \
    --is_training 1 \
    --root_path $root_path_name \
    --data_path $data_path_name \
    --model_id $model_id_name'_'$seq_len'_'$pred_len \
    --model $model_name \
    --data $data_name \
    --features M \
    --seq_len $seq_len \
    --pred_len $pred_len \
    --period_len 24 \
    --enc_in 321 \
    --train_epochs 30 \
    --patience 5 \
    --alpha $alpha \
    --gpu 3 \
    --itr 1 --batch_size $batch_size --learning_rate 0.03 > logs/${model_name}_${model_id_name}_${pred_len}_${batch_size}_${alpha}.log &


