if [ ! -d "./logs" ]; then
    mkdir ./logs
fi

#model_name=CSparseTSF
model_name=MixLinear

root_path_name=./dataset/
data_path_name=ETTh2.csv
model_id_name=ETTh2
data_name=ETTh2
alpha=0.5
batch_size=256
seq_len=720

lpf=19
pred_len=96
alpha=0.5
python3 -u run_longExp.py \
    --is_training 1 \
    --root_path $root_path_name \
    --data_path $data_path_name \
    --model_id $model_id_name'_'$seq_len'_'$pred_len \
    --model $model_name \
    --data $data_name \
    --features M \
    --seq_len $seq_len \
    --pred_len $pred_len \
    --period_len 24 \
    --enc_in 7 \
    --train_epochs 30 \
    --patience 5 \
    --lpf $lpf \
    --alpha $alpha \
    --gpu 3\
    --itr 1 --batch_size $batch_size --learning_rate 0.02 > logs/${model_name}_${data_name}_${pred_len}_${batch_size}_${lpf}_${alpha}.log  &

batch_size=310

pred_len=192
lpf=19
alpha=0.01
python3 -u run_longExp.py \
    --is_training 1 \
    --root_path $root_path_name \
    --data_path $data_path_name \
    --model_id $model_id_name'_'$seq_len'_'$pred_len \
    --model $model_name \
    --data $data_name \
    --features M \
    --seq_len $seq_len \
    --pred_len $pred_len \
    --period_len 24 \
    --enc_in 7 \
    --train_epochs 30 \
    --patience 5 \
    --alpha $alpha \
    --lpf $lpf \
    --gpu 3 \
    --itr 1 --batch_size $batch_size --learning_rate 0.02 > logs/${model_name}_${data_name}_${pred_len}_${batch_size}_${lpf}_${alpha}.log  &

batch_size=128
pred_len=336
lpf=15
alpha=0.01
python3 -u run_longExp.py \
    --is_training 1 \
    --root_path $root_path_name \
    --data_path $data_path_name \
    --model_id $model_id_name'_'$seq_len'_'$pred_len \
    --model $model_name \
    --data $data_name \
    --features M \
    --seq_len $seq_len \
    --pred_len $pred_len \
    --period_len 24 \
    --enc_in 7 \
    --train_epochs 30 \
    --patience 5 \
    --alpha $alpha \
    --lpf $lpf \
    --gpu 3 \
    --itr 1 --batch_size $batch_size --learning_rate 0.02 > logs/${model_name}_${data_name}_${pred_len}_${batch_size}_${lpf}_${alpha}.log  &

batch_size=310
pred_len=720
lpf=19
alpha=0.5
python3 -u run_longExp.py \
    --is_training 1 \
    --root_path $root_path_name \
    --data_path $data_path_name \
    --model_id $model_id_name'_'$seq_len'_'$pred_len \
    --model $model_name \
    --data $data_name \
    --features M \
    --seq_len $seq_len \
    --pred_len $pred_len \
    --period_len 24 \
    --enc_in 7 \
    --train_epochs 30 \
    --patience 5 \
    --alpha $alpha \
    --lpf $lpf \
    --gpu 3 \
    --itr 1 --batch_size $batch_size --learning_rate 0.02 > logs/${model_name}_${data_name}_${pred_len}_${batch_size}_${lpf}_${alpha}.log  &


