if [ ! -d "./logs" ]; then
    mkdir ./logs
fi

model_name=MixLinear

root_path_name=./dataset/
data_path_name=ETTh2.csv
model_id_name=ETTh2
data_name=ETTh2
seq_len=720
batch_size=1024


for alpha in 0.1 0.2 0.5 0.7 0.9
 do

  pred_len=96
  python3 -u run_longExp.py \
      --is_training 1 \
      --root_path $root_path_name \
      --data_path $data_path_name \
      --model_id $model_id_name'_'$seq_len'_'$pred_len \
      --model $model_name \
      --data $data_name \
      --features M \
      --seq_len $seq_len \
      --pred_len $pred_len \
      --period_len 24 \
      --enc_in 7 \
      --train_epochs 30 \
      --patience 5 \
      --alpha $alpha \
      --gpu 0\
      --itr 1 --batch_size $batch_size --learning_rate 0.03 > logs/${model_name}_${data_name}_${pred_len}_${batch_size}_${alpha}.log  &

  pred_len=192
  python3 -u run_longExp.py \
      --is_training 1 \
      --root_path $root_path_name \
      --data_path $data_path_name \
      --model_id $model_id_name'_'$seq_len'_'$pred_len \
      --model $model_name \
      --data $data_name \
      --features M \
      --seq_len $seq_len \
      --pred_len $pred_len \
      --period_len 24 \
      --enc_in 7 \
      --train_epochs 30 \
      --patience 5 \
      --alpha $alpha \
      --gpu 1\
      --itr 1 --batch_size $batch_size --learning_rate 0.03 > logs/${model_name}_${data_name}_${pred_len}_${batch_size}_${alpha}.log  &


  pred_len=336
  python3 -u run_longExp.py \
      --is_training 1 \
      --root_path $root_path_name \
      --data_path $data_path_name \
      --model_id $model_id_name'_'$seq_len'_'$pred_len \
      --model $model_name \
      --data $data_name \
      --features M \
      --seq_len $seq_len \
      --pred_len $pred_len \
      --period_len 24 \
      --enc_in 7 \
      --train_epochs 30 \
      --patience 5 \
      --alpha $alpha \
      --gpu 2\
      --itr 1 --batch_size $batch_size --learning_rate 0.03 > logs/${model_name}_${data_name}_${pred_len}_${batch_size}_${alpha}.log  &


  pred_len=720
  python3 -u run_longExp.py \
      --is_training 1 \
      --root_path $root_path_name \
      --data_path $data_path_name \
      --model_id $model_id_name'_'$seq_len'_'$pred_len \
      --model $model_name \
      --data $data_name \
      --features M \
      --seq_len $seq_len \
      --pred_len $pred_len \
      --period_len 24 \
      --enc_in 7 \
      --train_epochs 30 \
      --patience 5 \
      --alpha $alpha \
      --gpu 3\
      --itr 1 --batch_size $batch_size --learning_rate 0.03 > logs/${model_name}_${data_name}_${pred_len}_${batch_size}_${alpha}.log  &

done
