if [ ! -d "./logs" ]; then
    mkdir ./logs
fi

model_name=SparseTSF
#model_name=MixLinear

root_path_name=./dataset/
data_path_name=ETTh2.csv
model_id_name=ETTh2
data_name=ETTh2
alpha=0.5
batch_size=1024
seq_len=720
gpu_id=0

for batch_size in  256 
do
for period_len in 24 48 72 120 144
do
for pred_len in  720
do
  gpu_id=$(((gpu_id+1)%4))
  python3 -u run_longExp.py \
    --is_training 1 \
    --root_path $root_path_name \
    --data_path $data_path_name \
    --model_id $model_id_name'_'$seq_len'_'$pred_len \
    --model $model_name \
    --data $data_name \
    --features M \
    --seq_len $seq_len \
    --pred_len $pred_len \
    --period_len $period_len \
    --enc_in 7 \
    --train_epochs 30 \
    --patience 5 \
    --alpha $alpha \
    --gpu $gpu_id \
    --itr 1 --batch_size $batch_size --learning_rate 0.02 > logs/${model_name}_${data_name}_${pred_len}_${batch_size}_${alpha}_${period_len}.log  &
done
done
done
