# MCP Servers for drbench

This directory contains Model Context Protocol (MCP) servers for the drbench environment. Each subdirectory is a separate MCP server that provides integration with a specific service.

## Available MCP Servers

- [Nextcloud MCP Server](./nextcloud/): Integration with Nextcloud

## Adding New MCP Servers

To add a new MCP server:

1. Create a new directory under `mcp_servers/` with your server name
2. Follow the structure of existing servers
3. Add your server to the supervisord configuration in `drbench/services/supervisord_mcp.conf`

## Common Structure

Each MCP server typically follows this structure:

```
mcp_servers/service_name/
├── __init__.py
├── config.py            # Configuration settings
├── service_client.py    # Service API wrapper
├── server.py            # MCP server implementation
└── README.md            # Documentation
```

## Running MCP Servers

MCP servers are managed by supervisord and start automatically with the drbench environment. You can check their status with:

```bash
supervisorctl status
```

## Configuration

Each MCP server has its own configuration in a `.env` file. To modify the configuration:

1. Edit the `.env` file in the server directory
2. Restart the server with: `supervisorctl restart mcp-service_name`
