# suppress warnings
import warnings

warnings.filterwarnings("ignore")


from drbench import drbench_enterprise_space, task_loader
from drbench.agents.drbench_agent.drbench_agent import DrBenchAgentDummy
from drbench.score_report import score_report

# Step 0 - Load one task
task = task_loader.get_task_from_id(task_id="DR0001")
print(task.summary())

# Step 1 - Bring your own agent
dr_agent = DrBenchAgentDummy(model="gpt-4o-mini")

# Step 2 Start environment
env = drbench_enterprise_space.DrBenchEnterpriseSearchSpace(
    task=task.get_path(),
    start_container=True,
)

# Step 3 Generate report
report, _ = dr_agent.generate_report(
    query=task.get_task_config()["dr_question"], env=env
)

# Step 4 Evaluate report
score_dict = score_report(
    predicted_report=report,
    task=task,
    savedir="results/minimal",
)

# Step 5 - Print Scores
print("Insights Recall: ", score_dict["insights_recall"])

# Step 6 - Delete Environment
env.delete()
