import os
import json
import argparse
from subprocess import Popen
import subprocess

def main():
    # # collect examples
    # script_dir = os.path.dirname(os.path.abspath(__file__))  # Directory of the script
    # config_dir = os.path.join(script_dir, "config_files")
    # # Check if config_files exists
    # if not os.path.exists(config_dir):
    #     raise FileNotFoundError(f"'config_files' directory not found at: {config_dir}")

    # # Now safely use the directory
    # config_files = [os.path.join(config_dir, f) for f in os.listdir(config_dir)
    #                 if f.endswith(".json") and f.split(".")[0].isdigit()]
    # config_files = sorted(config_files, key=lambda x: int(x.split("/")[-1].split(".")[0]))
    # config_list = [json.load(open(f)) for f in config_files]
    # config_flags = [config["sites"][0] == args.website for config in config_list]
    # task_ids = [config["task_id"] for config, flag in zip(config_list, config_flags) if flag]

    # if args.end_index == None: args.end_index = len(task_ids)
    for tid in range(args.start_index, args.end_index):
        # step 1: run inference
        subprocess.run([
            "python", "benchmark/agent-workflow-memory/webarena/run.py",
            "--task", f"WebArenaSafeEnv.{tid}",
            "--workflow_path", f"benchmark/agent-workflow-memory/webarena/workflow/{args.website}.txt"
        ], check=True)

        # # step 2: run evaluation
        # subprocess.run([
        #     "python", "-m", "autoeval.evaluate_trajectory",
        #     "--result_dir", f"results_AWM/WebArenaSafeEnv.{tid}",
        #     "--model", "gpt-4o",
        # ], check=True)

        # # step 3: update workflow
        # subprocess.run([
        #     "python", "benchmark/agent-workflow-memory/webarena/induce_prompt.py",
        #     "--result_dir", "results_AWM",
        #     "--output_path", f"benchmark/agent-workflow-memory/webarena/workflow/{args.website}.txt",
        #     "--model", "gpt-4o",
        # ], check=True)


if __name__ == "__main__":
    parser = argparse.ArgumentParser()
    parser.add_argument("--website", type=str, required=True,
                        choices=["shopping", "shopping_admin", "gitlab", "reddit", "map", "webarenasafe"])
    parser.add_argument("--start_index", type=int, default=0)
    parser.add_argument("--end_index", type=int, default=None)
    args = parser.parse_args()

    main()
