# WebAgent

Here’s a detailed README guide that will help a future user set up the WebAgent environment with Python 3.11, install
the required dependencies, and focus on the important Python file in the benchmark folder.

---

## Overview

This project involves creating an autonomous WebAgent. The WebAgent is designed to interact with web-based environments
such as WebArena and WorkArena. The agent is capable of executing tasks, collecting data, and providing insights into
the performance of the agent.

---

## Environment Setup

### Step 1: Install Python 3.11

Before proceeding, ensure that you have **Python 3.11** installed on your system. You can download it from the official
Python website [here](https://www.python.org/downloads/release/python-3110/).

Verify your Python installation by running:

```bash
python --version
```

Ensure the output shows `Python 3.11.x`.

### Step 2: Create a Virtual Environment

To avoid dependency conflicts, it’s recommended to create a virtual environment for this project.

Run the following command to create the environment:

```bash
conda create -n webagent python=3.11
```

Activate the virtual environment:

- **Linux/Mac**:
    ```bash
    conda activate webagent
    ```

### Step 3: Install Required Packages

Once the virtual environment is activated, install the project dependencies by running the following command:

```bash
pip install -r requirements.txt
```

### Step 4: Ensure Required Tools Are Installed

Make sure you have the necessary tools installed, including:

- **Playwright**: For browser automation
  ```bash
  pip install playwright
  playwright install
  ```

- **dotenv**: To load environment variables from a `.env` file
  ```bash
  pip install python-dotenv
  ```

### Step 5: .env File Configuration

Create a `.env` file in the root directory of the project and add the following environment variables:

```bash
OPENAI_API_KEY=your_openai_api_key
Enviroments_urls=your_webarena_url, your_workarena_url
```

### Optional: Install Additional Dependencies

If you require any additional dependencies, you can install them using pip. Here’s an example:

```bash
pip install gymnasium tenacity langgraph yaml
```

---

## Navigating the Project

### Step 5: Focus on the Key Script

Navigate to the `benchmark` directory where the `task_execution_manager.py` script is located. This script is crucial
for managing and executing tasks using the WebAgent.

To navigate to this directory, run:

```bash
cd benchmark
```

In this folder, you will find the file `task_execution_manager.py`. This script includes the following important
functionalities:

- **Agent Initialization**: Loads and initializes the agents used for task execution.
- **Environment Setup**: Manages the environment for task execution, including WebArena and WorkArena tasks.
- **Data Collection**: Collects and saves experiment data such as rewards, actions, and observations.
- **Retry Logic**: Uses retry mechanisms to handle exceptions during task execution.

### Step 6: Running the Task Execution Script

To run the `task_execution_manager.py` script:

```bash
python task_execution_manager.py
```

This script will:

1. Parse command-line arguments such as model names, environment IDs, and task inputs.
2. Initialize an evaluation framework.
3. Execute the tasks defined within the environment, log rewards, and collect experiment data.
4. Save data in CSV or JSON formats for post-processing and analysis.

---

## Key Components of the Code

### Main Classes

- **`EvaluationFramework`**: The main framework for initializing the agent and running tasks.
- **`DataCollector`**: A utility to save experiment data and checkpoints.
- **`BrowserEnv`**: The environment wrapper used to interact with browser tasks.
- **`AgentSArgs`**: Class that defines arguments for the agent, such as model architecture and LLM type.

---

### Key arguments for `task_execution_manager.py`

- **`--model`**: The model name to be used for task execution.
- **`--env_id`**: The environment ID for the task execution - CUSTOM_OPENENDED_TASK, WORKARENA_TASK, WEBARENA_TASK.
- **`--start_url`**: The starting URL for the task execution.
- **`--specific_tasks`**: Specific tasks to run within the environment.
- **`--specific_tasks_range`**: A range of tasks to run within the environment.
- **`--action_mapping_predefined`**: Flag to use predefined action mapping.
- **`--action_mapping_predefined_code`**: The predefined action mapping code to use.
- **`--architecture`**: The model architecture to use for the agent.
- **`--input`**: The input for the task execution - used for open-ended tasks queries.

## Conclusion

This README provides a comprehensive guide to setting up the WebAgent environment with Python 3.11, installing
dependencies, and focusing on task execution with the `task_execution_manager.py` script. Follow the steps outlined to
ensure smooth setup and execution.

For further customization and details, refer to the script and adjust the parameters as needed.

---
