from webarenasafe.data_generator_filter import load_json_file
from webarenasafe.data_utils import save_json_file
from webarenasafe.split_program_html import split_evals

if __name__ == '__main__':
    gitlab = load_json_file(file_path="./policy_data/out_gitlab.json")
    suitecrm = load_json_file(file_path="./policy_data/out_suitecrm.json")
    shopping_admin = load_json_file(file_path="./policy_data/out_shopping_admin.json")
    gitlab_overload = load_json_file(file_path="./policy_data/out_gitlab_overload.json")
    suite_popup_error = load_json_file(file_path="./policy_data/out_suitecrm_error_handling.json")
    suite_trust_errors = load_json_file(file_path="./policy_data/trust_data.json")
    suite_trust_overload = load_json_file(file_path="./policy_data/out_trust_data_overload.json")

    data = gitlab + suitecrm + shopping_admin + gitlab_overload
    print("new data index " + str(len(data)))
    data = data + suite_popup_error + suite_trust_errors
    data = data + suite_trust_overload
    for i, task in enumerate(data):
        task["task_id"] = i
    print("Total {} data points".format(len(data)))
    save_json_file(data, "./policy_data/out_all.json")
    save_json_file(data, "./test.raw.json")
    split_evals(data)
    total = 0
    print("Gitlab regular {} - {}".format(total, total + len(gitlab) - 1))
    total += len(gitlab)
    print("Suitecrm regular {} - {}".format(total, total + len(suitecrm) - 1))
    total += len(suitecrm)
    print("Shopping admin regular {} - {}".format(total, total + len(shopping_admin) - 1))
    total += len(shopping_admin)
    print("Gitlab overload {} - {}".format(total, total + len(gitlab_overload) - 1))
    total += len(gitlab_overload)

    print("Suitecrm popup error handling {} - {}".format(total, total + len(suite_popup_error) - 1))
    total += len(suite_popup_error)

    print("Suitecrm paramters,injection error handling {} - {}".format(total, total +
                                                                       len(suite_trust_errors) - 1))
    total += len(suite_trust_errors)

    print("Suitecrm overload (50,20,10) -  {} - {}".format(total, total + len(suite_trust_overload) - 1))
    total += len(suite_trust_overload)
