import json


def replace_placeholders(intent_template, values_dict):
    for key, value in values_dict.items():
        # Create the placeholder for each key in the format {{key}}
        placeholder = f"{{{{{key}}}}}"
        # Replace the placeholder with the corresponding value
        intent_template = intent_template.replace(placeholder, str(value))
    return intent_template

# Open and read the JSON file


def create_tasks():
    with open('suitecrm_tasks_details.json', 'r') as file:
        data = json.load(file)

    task_id = 1000
    intent_template_id = 2000
    tasks_file = []

    for task in data:
        with open('template_suitecrm.json', 'r') as file:
            template = json.load(file)
        for i in range(3):
            template[i]["task_id"] = task_id + i
            template[i]["intent_template"] = task["template"]
            template[i]["instantiation_dict"] = task["instantiations"][i]
            intent_template = task["template"]
            values_dict = task["instantiations"][i]
            template[i]["intent"] = replace_placeholders(intent_template, values_dict)
            template[i]["eval"]["program_html"][0]["required_contents"]["must_include"] = list(values_dict.values())
            if "create" in template[i]["intent"].lower():
                template[i]["eval"]["program_html"][0]["required_contents"]["must_include"][
                    0] = f"<span class=\"dynamic-label ng-star-inserted\">{template[i]["eval"]["program_html"][0]["required_contents"]["must_include"][0]}</span>"
            template[i]["intent_template_id"] = intent_template_id
            template[i]["policies"] = []

        tasks_file.extend(template)
        intent_template_id += 1
        task_id += 3
#
    with open('./filtered_web_arena/suitecrm/suitecrm_raw_tasks.json', 'w') as f:
        json.dump(tasks_file, f, indent=4)
    return 0


if __name__ == '__main__':
    create_tasks()