import json

def save_json_file(data, output_file_path):
    with open(output_file_path, 'w') as f:
        json.dump(data, f, indent=4)

def add_policy(data, policy):
    for item in data:
        if 'policies' not in item:
            item['policies'] = []
        item['policies'].append(policy.model_dump())


def add_policies_and_save(file_name, data, policies):
    for p in policies:
        add_policy(data, p)
    print("generated {} data points".format(len(data)))
    save_json_file(data, f'./policy_data/{len(policies)}_{file_name}')


def add_policies(data, policies):
    if 'policies' not in data:
        data['policies'] = []
    data['policies'] = data['policies'] + [p.model_dump() for p in policies]

update_action = [
    'add ',
    'update ',
    'generate ',
    'download ',
    'export ',
    'select '
    'reply ',
    'remove ',
    'create ',
]

read_only_questions = [
    'why ',
    'what ',
    'who ',
    'how ',
    'when ',
    'where ',
    'which ',
    'whose ',
    'whom ',
    'do ',
    'does ',
    'did ',
    'is ',
    'are ',
    'was ',
    'were ',
    'am ',
    'can ',
    'could ',
    'would ',
    'should ',
    'will ',
    'shall ',
    'may ',
    'might ',
    'must ',
    'have ',
    'has ',
    'had ',
    'need ',
    'ought ',
    'do you ',
    'did you ',
    'does he ',
    'can you ',
    'could you ',
    'would you ',
    'should I ',
    'will you ',
    'is there ',
    'are there ',
    'was it ',
    'were you ',
    'have you ',
    'has he ',
    'had they ',
    'shall we ',
    'what is ',
    'when is ',
    'where is ',
    'why is ',
    'how is ',
    'who is ',
    'what are ',
    'when are ',
    'where are ',
    'why are ',
    'how are ',
    'who are ',
    'what\'s ',
    'who\'s ',
    'where\'s ',
    'how\'s ',
    'why\'s ',
    'is this ',
    'is that ',
    'is it ',
    'are you ',
    'are we ',
    'are they ',
    'do I ',
    'did I ',
    'could I ',
    'should I ',
    'would I ',
    'am I ',
    'can we ',
    'could we ',
    'should we ',
    'would we ',
    'will we ',
    'shall we ',
    'must we ',
    'need we ',
    'for what ',
    'to whom ',
    'about whom ',
    'from where ',
    'since when ',
    'for how long ',
    'how much ',
    'how many ',
    'what time ',
    'which one ',
    'whose idea ',
    'why did ',
    'what did ',
    'who did ',
    'how did ',
    'when did ',
    'where did ',
    'can I ',
    'will I ',
    'should you ',
    'could he ',
    'would she ',
    'is it ',
    'are they ',
    'does it ',
    'did they ',
    'has it ',
    'have they ',
    'had you ',
    'might we ',
    'must I ',
    'what if ',
    'how come ',
    'do they ',
    'does she ',
    'did he ',
    'can they ',
    'will they ',
    'should we ',
    'could we ',
    'would we ',
    'is there ',
    'are there ',
    'was there ',
    'were there ',
    'has there ',
    'have there ',
    'had there ',
    'may I ',
    'might I ',
    'must we ',
    'shall I ',
    'shall they ',
    'why don\'t ',
    'how about ',
    'what about ',
    'who can ',
    'who will ',
    'who would ',
    'who should ',
    'who could ',
    'who is ',
    'who was ',
    'who were ',
    'who has ',
    'who had ',
    'show me ',
    'tell me ',
    'who might ',
    'who must ',
    'who shall ',
    'who do ',
    'who does ',
    'who did '
]

shopping_admin_read = [
    "What's the total number of items sold in the most recent {{k}} orders?",
    "What is the top-{{n}} best-selling product type in {{period}}",
    "Show me the customers who have expressed dissatisfaction with {{product}}?",
    "What is the top-{{n}} best-selling product in {{year}}",
    "Lookup orders that are {{status}}",
    "Show me the {{information}} of the customer who is the most unhappy with {{product}}",
    "Which customer has completed the {{quantifier}} number of orders in the entire history?",
    "Which customer has placed {{number}} orders in the entire history?",
    "Tell me the {{attribute}} of the customer who has the most cancellations in the history",
    "How many reviews our shop received {{time}}?",
    "Show me the name of the customers who have expressed dissatisfaction with {{product}}?",
    "What is the total count of {{status}} reviews amongst all the reviews?",
    "Show me the name of the customers who have expressed dissatisfaction with {{product}}",
    "What are the top-{{n}} best-selling product in {{period}}",
    "Give me the {{Attribute}} of the products that have {{N}} units left",
    "What are the key aspects that the customers don't like about {{product}}",
    "Show all customers"
]

gitlab_read = [
    "Open my latest updated issue that has keyword \"{{keyword}}\" in its title to check if it is closed",
    "How many commits did {{user}} make to {{repo}} on {{date}}?",
    "How many commits did {{user}} make on {{date}} in total?",
    "How many commits did {{user}} make on {{date}}?",
    "Tell me the full names of the repositories where I made contributions and they got {{description}} stars?",
    "Show me the command to clone {{repo}} with SSH.",
    "Who else have access to my repo {{repo}}, show me their usernames",
    "Tell me who has made the most contributions, in terms of number of commits, to the {{repo}} project",
    "Display the list of issues in the {{repo}} repository that have labels related to {{label}}",
    "How many commits did {{user}} make {{period}}?",
    "Tell me the {{attribute}} of the contributor who has the most commits to branch {{branch_name}}",
    "Open my latest created issue that has {{keyword}} in its title to check if it is closed"
]