from PIL import Image, ImageDraw, ImageFont
import sys
import os

from .dashed_image_draw import DashedImageDraw
import numpy as np
import matplotlib.pyplot as plt
from scipy import ndimage
import math

try:
    # font = ImageFont.truetype('/Users/benwiesel/Downloads/Arial Bold.ttf', size=12)  # specify path and size
    font = ImageFont.truetype('/Users/benwiesel/Downloads/open-sans/OpenSans-Bold.ttf', size=12)  # specify path and size
except IOError:
    font = ImageFont.load_default()  # Load default font if custom font fails

def analyze_image(image):
    # Open the image
    image = image.convert('L')  # Convert to grayscale
    
    # Convert image to numpy array
    image_array = np.array(image)
    
    # Get the average pixel value
    avg_pixel_value = np.mean(image_array)
    
    # Define a threshold to determine if the image is mostly white or black
    threshold = 128  # Midpoint of the 0-255 range in grayscale
    
    if avg_pixel_value > threshold:
        return False
    else:
        return True