from pydantic import BaseModel
from typing import List, Optional, Literal, Dict, Any

class ProgramHTML(BaseModel):
    url: Optional[str] = "last"
    locator: Optional[str] = ""
    required_contents: Optional[Dict[str, Any]] = None


class EvalModel(BaseModel):
    eval_types: List[str]
    must_include: Optional[str] = None
    must_include_action: Optional[str] = None
    url_note: Optional[Literal['contains_any']] = None
    reference_url: Optional[str] = None
    element_selector: Optional[str] = None
    program_html: Optional[ProgramHTML] = None
    action_sequence: Optional[List[Dict[str, str]]] = None
    matching_type: Optional[Literal['contiguous', 'non-contiguous']] = None
    action_type: Optional[str] = None
    global_count: Optional[int] = None
    global_count_less_than: Optional[int] = None
    element_selectors: Optional[List[str]] = None

class PolicyModel(BaseModel):
    policy_template_id: str
    policy_category: str
    source: str
    description: str
    policy_template: str
    eval: EvalModel