This file will be overwritten by `index.ipynb`

# Vision Transformer for Multivariate Time-Series Classification (VitMTSC)

> Multivariate time-series classification (MTSC) is an important problem in different domains (economics, retail, health, etc.) due to the proliferation of multiple data sources and sensors. It still remains a challenge though, due to the high-dimensionality and large scale of continuously updating data. We propose a pure-transformer based Vision Transformer for Multivariate Time-Series Classification (VitMTSC) model that learns latent features from raw time-series data for classification task and works for large-scale time-series data - millions of data samples of variable length. To our knowledge, this is the first application of Vision Transformer (ViT) for MTSC. We show that our model works on datasets that has only thousand samples to multi-million samples and achieve close to state-of-the-art (SOTA) results on open datasets. In a real-world application, using click-stream data from a popular retail website, we show that our model can scale to millions of samples and beat the performance of other neural net based MTSC models. To facilitate further research, we release code at https://github.com/mtsc-research/vitmtsc.


## Development

* In this project, we develop end-to-end modeling pipeline in Jupyter and use nbdev(https://nbdev.fast.ai/) to automatically create python library that also allows automatic code sharing across notebooks.
* Get a machine with NVIDIA GPU and create conda environment using provided file

##### $conda env create --file environment.yml

##### $conda activate rapids-22.08_ploomber && cd vitmtsc_nbdev && nbdev_export && python3 setup.py install && python -m ipykernel install --user --name rapids-22.08_ploomber

### Local Development

* Using ploomber (https://github.com/ploomber/ploomber) and soopervisor(https://github.com/ploomber/soopervisor)
* Following command directly runs Jupyter Notebook and generates HTML output of notebook execution. 
 
##### $ploomber build 


### Cloud Deployment to AWS Batch (https://soopervisor.readthedocs.io/en/latest/tutorials/aws-batch.html)
* This creates Docker image corresponding to each Jupyter notebook and deploys to AWS Batch job for workflow execution. 

##### $aws ecr get-login-password --region your-region | docker login --username AWS --password-stdin your-repository-url/name

##### $soopervisor export training —skip-tests —ignore-git