# Interacting-Contour-Stochastic-Gradient-Langevin-Dynamics

An embarrassingly parallel multiple-chain contour stochastic gradient Langevin dynamics (CSGLD) sampler with efficient interactions, where the interacting parallel version can be theoretically more efficient than a single-chain CSGLD with an equivalent computational budget.


### Requirement
* Python 2.7
* [PyTorch = 1.1](https://pytorch.org/) or similar
* numpy
* CUDA

## Simulations

Please check the **ipynb** files for the ICSGLD algorithm and the baselines, respectively.

## Deep Contextual Bandits on Mushroom tasks

Move to the folder: **contextual_bandits**.

All the algorithms run 2,000 epochs based on 4 parallel chains.

#### Const SGD (SGLD with temperature 0)

```python
$ python main.py -c sgld -lr 1e-6 
```

#### EpsGreedy (with decaying learning rates and uniform exploration)

```python
$ python main.py -c sgld -decay 0.999 -epsilon 0.003 -lr 1e-6 
```

#### Dropout

```python
$ python main.py -c sgld -lr 1e-6 -rate 0.5 -samples 5 
```

#### pSGLD (preconditioner requires a different learning rate)
```python
$ python main.py -c sgld -precondition 1 -lr 3e-7 -T 0.3
```

#### ICSGLD xP4

```python
$ python main.py -c csgld -precondition 1 -lr 3e-7 -T 0.3 -part 200 -div 10 -sz 0.03 -zeta 20
```

## Uncertainty Estimation via Image Data

Move to the folder: **resnet100_cifar100**.

m-SGDxP4
```python
$ python bayes_cnn.py -sn 500 -model resnet -depth 20 -c sghmc -period 0 -warm 0.85 -burn 0.98
```

Replica exchange method
```python
$ python bayes_cnn.py -sn 500 -model resnet -depth 20 -c replica -correction 4000 -warm 0.8 -burn 0.8
```

cycSGHMC & cycSWAG
```python
$ python bayes_cnn.py -chains 1 -model resnet -depth 20 -c cswag -period 0 -cycle 10 -warm 0.94 -burn 0.94
```

CSGHMC
```python
$ python bayes_cnn.py -sn 500 -model resnet -depth 20 -c csghmc -stepsize 0.003 -zeta 3e6 -part 200 -div 200 -bias 2e4 -warm 0.75 -burn 0.80
```

