#!/bin/bash

# Activate conda environment
conda activate edge

# Run the Python script
python ../main_edge_training.py \
        --epochs 50000 \
        --num_generation 64 \
        --num_iter 256 \
        --diffusion_dim 64 \
        --diffusion_steps 512 \
        --device cuda:0 \
        --data_path ./arrow_diff/data \
        --dataset Cora_ML \
        --batch_size 4 \
        --clip_value 1 \
        --lr 1e-4 \
        --optimizer adam \
        --final_prob_edge 1 0 \
        --sample_time_method importance \
        --check_every 50 \
        --eval_every 50 \
        --noise_schedule linear \
        --dp_rate 0.1 \
        --loss_type vb_ce_xt_prescribred_st \
        --arch TGNN_degree_guided \
        --parametrization xt_prescribed_st \
        --degree \
        --num_heads 8 8 8 8 1 \
        --num_workers 4 \
        --log_home ./results/edge \
        --seed 149 \
#        --resume 2023-09-19_17-58-07

#python ../main_edge_evaluation.py \
#        --base_path ./arrow_diff \
#        --run_name 2023-09-21_19-10-38 \
#        --dataset Cora_ML \
#        --num_samples 10 \
#        --checkpoint 5550 \
#        --seed 149

