#!/bin/bash --login
########## SBATCH Lines for Resource Request ##########

#SBATCH -e ./log/graph_pred.err
#SBATCH -o ./log/graph_pred.out
#SBATCH --time=4:00:00             # limit of wall clock time - how long the job will run (same as -t)
#SBATCH --nodes=1                # number of different nodes - could be an exact number or a range of nodes (same as -N)
#SBATCH -c 1           # number of CPUs (or cores) per task (same as -c
#SBATCH --gres=gpu:a100:1
#SBATCH --mem=200G            # memory required per allocated CPU (or core) - amount of memory (in bytes)
#SBATCH --job-name graph_pred # you can give your job a name for easier identification (same as -J)

# source ~/.bashrc
# source ~/anaconda3/bin/activate graph

trap "echo ERROR && exit 1" ERR

# --------------------
export CUDA_VISIBLE_DEVICES=${CUDA_VISIBLE_DEVICES:-0}
TEST_FLAG=${TEST_FLAG:-0}
AUG_FLAG=${AUG_FLAG:-1}
TRAIN_GUI_FLAG=${TRAIN_GUI_FLAG:-1}
NEG_FLAG=${NEG_FLAG:-1}
# --------------------

launch () {
    full_settings=($@)
    cfg_name=${full_settings[0]}
    ckpt_name=${full_settings[1]}
    seed=${full_settings[2]}
    fold=${full_settings[3]}
    thres=${full_settings[4]}
    settings=${full_settings[@]:5}

    extra_config=""
    extra_args="--fold ${fold} --thres ${thres} "

    ### modifying
    # extra_config+="augment.num_repeats=1 "
    # extra_config+="augment.num_repeats=2 "
    # extra_config+="augment.num_repeats=5 "
    # extra_config+="augment.num_repeats=10 "
    # extra_config+="augment.num_repeats=20 "

    # extra_config+="augment.replace_flag=True "
    # extra_config+="augment.replace_flag=False "

    ## num_sample_steps
    # extra_args+="--prefix n_sample_steps-64 "
    # extra_config+="augment.sample.num_sample_steps=64 "

    # extra_args+="--prefix n_sample_steps-32 "
    # extra_config+="augment.sample.num_sample_steps=32 "
    
    # extra_args+="--prefix n_sample_steps-16 "
    # extra_config+="augment.sample.num_sample_steps=16 "

    # extra_args+="--prefix n_sample_steps-8 "
    # extra_config+="augment.sample.num_sample_steps=8 "

    # extra_args+="--prefix n_sample_steps-4 "
    # extra_config+="augment.sample.num_sample_steps=4 "

    ## augment
    # extra_args+="--prefix aug_val "
    # extra_config+="augment.augment_valid=True "

    # extra_args+="--prefix aug_test "
    # extra_config+="augment.augment_test=True "

    # extra_args+="--prefix aug_val_aug_test "
    # extra_config+="augment.augment_valid=True augment.augment_test=True "

    ## guidance
    # extra_args+="--prefix step_size-0.5 "
    # extra_config+="augment.sample.step_size=0.5 "

    # extra_args+="--prefix n_step-10 "
    # extra_config+="augment.sample.num_steps=10 "

    # extra_args+="--prefix coef-10 "
    # extra_config+="augment.sample.stability_coef=10 "

    ## guidance head
    # extra_args+="--prefix head_l1 "
    # extra_config+="augment.guidance_config.guidance.num_layers=1 "

    # extra_args+="--prefix head_dp0.5 "
    # extra_config+="augment.guidance_config.guidance.dropout=0.5 "

    # extra_config+="augment.guidance_config.diffusion.guidance_type=node_degree "
    # extra_config+="augment.guidance_config.guidance.target=node "

    ## combined
    # extra_args+="--prefix coef-10_n_step-10 "
    # extra_config+="augment.sample.stability_coef=10 augment.sample.num_steps=10 "

    # extra_args+="--prefix step_size-0.5_n_step-10 "
    # extra_config+="augment.sample.step_size=0.5 augment.sample.num_steps=10 "

    # extra_args+="--prefix coef-10_n_sam_steps-16 "
    # extra_config+="augment.sample.num_sample_steps=16 augment.sample.stability_coef=10 "

    # extra_args+="--prefix aug_val_aug_test_step_size-0.5 "
    # extra_config+="augment.sample.step_size=0.5 "
    # extra_config+="augment.augment_valid=True augment.augment_test=True "

    # extra_args+="--prefix aug_val_aug_test_coef-100 "
    # extra_config+="augment.sample.stability_coef=100 "
    # extra_config+="augment.augment_valid=True augment.augment_test=True "

    # extra_args+="--prefix aug_val_aug_test_n_step-10 "
    # extra_config+="augment.sample.num_steps=10 "
    # extra_config+="augment.augment_valid=True augment.augment_test=True "
    
    # extra_args+="--prefix aug_val_aug_test_coef-10_n_sam_steps-16 "
    # extra_config+="augment.sample.num_sample_steps=16 augment.sample.stability_coef=10 "
    # extra_config+="augment.augment_valid=True augment.augment_test=True "

    if [[ $TRAIN_GUI_FLAG == 1 ]]; then
        extra_args+="--train_guidance t "
    fi

    if [[ $NEG_FLAG == 1 ]]; then
        extra_args+="--neg_guide t "
    fi

    if [[ $AUG_FLAG == 1 ]]; then
        extra_args+="--augment t "
        ckpt_path="checkpoints/network_repository/"

        extra_config+="data.extract_attributes=True "

        if [[ $ckpt_name == nr_gnn_gt_l4_deg_lin ]]; then
            ckpt_path+="nr_gnn_gt_l4_deg_lin-r.1-Feb21-21:45:49.pth"

        elif [[ $ckpt_name == nr_snap_gnn_gt_l4_deg_lin ]]; then
            ckpt_path+="nr_snap_gnn_gt_l4_deg_lin-r.1-Feb22-19:42:52_6000.pth"

        elif [[ $ckpt_name == full_nr_gnn_gt_l4_dnnm-0_deg_lin_self_guide ]]; then
            ckpt_path+="full_nr_gnn_gt_l4_dnnm-0_deg_lin_self_guide-r.1-Mar08-02:01:14.pth"

        elif [[ $ckpt_name == full_nr_github_gnn_gt_l4_dnnm-50_deg_lin_self_guide ]]; then
            ckpt_path+="full_nr_github_gnn_gt_l4_dnnm-50_deg_lin_self_guide-r.1-Mar29-21:15:57.pth"
        
        elif [[ $ckpt_name == full_nr_github_gnn_gt_l4_dnnm-50_deg_lin_self_guide_1000 ]]; then
            ckpt_path+="full_nr_github_gnn_gt_l4_dnnm-50_deg_lin_self_guide-r.1-Mar26-21:29:46_1000.pth"
        
        elif [[ $ckpt_name == full_nr_github_gnn_gt_l4_dnnm-50_deg_lin_self_guide_3000 ]]; then
            ckpt_path+="full_nr_github_gnn_gt_l4_dnnm-50_deg_lin_self_guide-r.1-Mar26-21:29:46_3000.pth"
        
        elif [[ $ckpt_name == full_nr_github_gnn_gt_l4_dnnm-50_deg_lin_self_guide_5000 ]]; then
            ckpt_path+="full_nr_github_gnn_gt_l4_dnnm-50_deg_lin_self_guide-r.1-Mar26-21:29:46_5000.pth"
        
        elif [[ $ckpt_name == full_nr_github_gnn_gt_l4_dnnm-50_deg_lin_self_guide_7000 ]]; then
            ckpt_path+="full_nr_github_gnn_gt_l4_dnnm-50_deg_lin_self_guide-r.1-Mar26-21:29:46_7000.pth"

        else
            echo Unknown ckpt name $ckpt_name && exit 1
        fi
        extra_config+="augment.ckpt_path=${ckpt_path} "

    else
        extra_config=""
    fi

    config_file="config/graph_pred/${cfg_name}.yaml"

    script="PYTORCH_CUDA_ALLOC_CONF=expandable_segments:True singularity exec --nv ~/pyg.sif "
    script+="python graph_pred.py --config ${config_file} --seed ${seed} ${extra_args} ${settings[@]} ${extra_config} "

    echo ${script} && [[ $TEST_FLAG == 0 ]] && eval ${script}
}

# AUG_FLAG=0 CUDA_VISIBLE_DEVICES=0 bash run/graph_pred.sh
# AUG_FLAG=1 CUDA_VISIBLE_DEVICES=0 bash run/graph_pred.sh
# AUG_FLAG=1 TRAIN_GUI_FLAG=1 CUDA_VISIBLE_DEVICES=0 bash run/graph_pred.sh

thres=None

# thres=0.5
# thres=0.6
# thres=0.7
# thres=0.8

# thres=0.9
# thres=0.99
# thres=0.999

# thres=0.9999
# thres=0.99999
# thres=0.999999

# thres=0.9999999
# thres=0.99999999
# thres=0.999999999

# thres=0.9999999999
# thres=0.99999999999
# thres=0.999999999999

echo thres=${thres}


seed=0

echo seed=${seed}

# folds=(0)

folds=(0 1 2 3 4 5 6 7 8 9)

# folds=(0 1 2 3 4)
# folds=(5 6 7 8 9)

# folds=(0 1 2 3)
# folds=(4 5 6 7)
# folds=(8 9)

# folds=(0 1 2)
# folds=(3 4 5)
# folds=(6 7)
# folds=(8 9)

# folds=(0 1)
# folds=(2 3)
# folds=(4 5)
# folds=(6 7)
# folds=(8 9)

# folds=(0)
# folds=(1)
# folds=(2)
# folds=(3)
# folds=(4)
# folds=(5)
# folds=(6)
# folds=(7)
# folds=(8)
# folds=(9)

for fold in ${folds[@]}; do

echo fold=${fold}


### full_nr_gnn_gt_l4_dnnm-0_deg_lin_self_guide
# launch Enzymes full_nr_gnn_gt_l4_dnnm-0_deg_lin_self_guide ${seed} ${fold} ${thres}&
# launch NCI1 full_nr_gnn_gt_l4_dnnm-0_deg_lin_self_guide ${seed} ${fold} ${thres}&
# launch Proteins full_nr_gnn_gt_l4_dnnm-0_deg_lin_self_guide ${seed} ${fold} ${thres}&

# launch IMDB_binary full_nr_gnn_gt_l4_dnnm-0_deg_lin_self_guide ${seed} ${fold} ${thres}&
# launch IMDB_multi full_nr_gnn_gt_l4_dnnm-0_deg_lin_self_guide ${seed} ${fold} ${thres}&

# launch Collab full_nr_gnn_gt_l4_dnnm-0_deg_lin_self_guide ${seed} ${fold} ${thres}&
# launch DD full_nr_gnn_gt_l4_dnnm-0_deg_lin_self_guide ${seed} ${fold} ${thres}&
# launch Reddit_multi_5k full_nr_gnn_gt_l4_dnnm-0_deg_lin_self_guide ${seed} ${fold} ${thres}&
# launch Reddit_multi_12k full_nr_gnn_gt_l4_dnnm-0_deg_lin_self_guide ${seed} ${fold} ${thres}&

# launch Reddit_binary full_nr_gnn_gt_l4_dnnm-0_deg_lin_self_guide ${seed} ${fold} ${thres}&


### full_nr_github_gnn_gt_l4_dnnm-50_deg_lin_self_guide
launch Enzymes full_nr_github_gnn_gt_l4_dnnm-50_deg_lin_self_guide ${seed} ${fold} ${thres}&
# launch NCI1 full_nr_github_gnn_gt_l4_dnnm-50_deg_lin_self_guide ${seed} ${fold} ${thres}&
# launch Proteins full_nr_github_gnn_gt_l4_dnnm-50_deg_lin_self_guide ${seed} ${fold} ${thres}&

# launch IMDB_binary full_nr_github_gnn_gt_l4_dnnm-50_deg_lin_self_guide ${seed} ${fold} ${thres}&
# launch IMDB_multi full_nr_github_gnn_gt_l4_dnnm-50_deg_lin_self_guide ${seed} ${fold} ${thres}&

# launch Collab full_nr_github_gnn_gt_l4_dnnm-50_deg_lin_self_guide ${seed} ${fold} ${thres}&
# launch DD full_nr_github_gnn_gt_l4_dnnm-50_deg_lin_self_guide ${seed} ${fold} ${thres}&
# launch Reddit_binary full_nr_github_gnn_gt_l4_dnnm-50_deg_lin_self_guide ${seed} ${fold} ${thres}&
# launch Reddit_multi_5k full_nr_github_gnn_gt_l4_dnnm-50_deg_lin_self_guide ${seed} ${fold} ${thres}&
# launch Reddit_multi_12k full_nr_github_gnn_gt_l4_dnnm-50_deg_lin_self_guide ${seed} ${fold} ${thres}&


### nr_snap_gnn_gt_l4_deg_lin
# launch Enzymes nr_snap_gnn_gt_l4_deg_lin ${seed} ${fold} ${thres}&
# launch Proteins nr_snap_gnn_gt_l4_deg_lin ${seed} ${fold} ${thres}&
# launch IMDB_binary nr_snap_gnn_gt_l4_deg_lin ${seed} ${fold} ${thres}&
# launch IMDB_multi nr_snap_gnn_gt_l4_deg_lin ${seed} ${fold} ${thres}&


### full_nr_github_gnn_gt_l4_dnnm-50_deg_lin_self_guide_1000
# launch Enzymes full_nr_github_gnn_gt_l4_dnnm-50_deg_lin_self_guide_1000 ${seed} ${fold} ${thres}&
# launch Proteins full_nr_github_gnn_gt_l4_dnnm-50_deg_lin_self_guide_1000 ${seed} ${fold} ${thres}&
# launch IMDB_binary full_nr_github_gnn_gt_l4_dnnm-50_deg_lin_self_guide_1000 ${seed} ${fold} ${thres}&
# launch IMDB_multi full_nr_github_gnn_gt_l4_dnnm-50_deg_lin_self_guide_1000 ${seed} ${fold} ${thres}&

### full_nr_github_gnn_gt_l4_dnnm-50_deg_lin_self_guide_3000
# launch Enzymes full_nr_github_gnn_gt_l4_dnnm-50_deg_lin_self_guide_3000 ${seed} ${fold} ${thres}&
# launch Proteins full_nr_github_gnn_gt_l4_dnnm-50_deg_lin_self_guide_3000 ${seed} ${fold} ${thres}&
# launch IMDB_binary full_nr_github_gnn_gt_l4_dnnm-50_deg_lin_self_guide_3000 ${seed} ${fold} ${thres}&
# launch IMDB_multi full_nr_github_gnn_gt_l4_dnnm-50_deg_lin_self_guide_3000 ${seed} ${fold} ${thres}&

### full_nr_github_gnn_gt_l4_dnnm-50_deg_lin_self_guide_5000
# launch Enzymes full_nr_github_gnn_gt_l4_dnnm-50_deg_lin_self_guide_5000 ${seed} ${fold} ${thres}&
# launch Proteins full_nr_github_gnn_gt_l4_dnnm-50_deg_lin_self_guide_5000 ${seed} ${fold} ${thres}&
# launch IMDB_binary full_nr_github_gnn_gt_l4_dnnm-50_deg_lin_self_guide_5000 ${seed} ${fold} ${thres}&
# launch IMDB_multi full_nr_github_gnn_gt_l4_dnnm-50_deg_lin_self_guide_5000 ${seed} ${fold} ${thres}&

### full_nr_github_gnn_gt_l4_dnnm-50_deg_lin_self_guide_7000
# launch Enzymes full_nr_github_gnn_gt_l4_dnnm-50_deg_lin_self_guide_7000 ${seed} ${fold} ${thres}&
# launch Proteins full_nr_github_gnn_gt_l4_dnnm-50_deg_lin_self_guide_7000 ${seed} ${fold} ${thres}&
# launch IMDB_binary full_nr_github_gnn_gt_l4_dnnm-50_deg_lin_self_guide_7000 ${seed} ${fold} ${thres}&
# launch IMDB_multi full_nr_github_gnn_gt_l4_dnnm-50_deg_lin_self_guide_7000 ${seed} ${fold} ${thres}&

# wait

done

wait




### iterate over seeds

# seeds=(0)

# seeds=(0 1 2 3 4 5 6 7 8 9)

# seeds=(0 1 2 3 4)
# seeds=(5 6 7 8 9)

# seeds=(0 1 2 3)
# seeds=(4 5 6 7)
# seeds=(8 9)

# seeds=(0 1 2)
# seeds=(3 4 5)
# seeds=(6 7)
# seeds=(8 9)


# for seed in ${seeds[@]}; do

# echo seed=${seed}

### nr_gnn_gt_l4_deg_lin
# launch Reddit_multi_12k nr_gnn_gt_l4_deg_lin ${seed} ${fold} ${thres}&

### full_nr_gnn_gt_l4_dnnm-0_deg_lin_self_guide
# launch Reddit_multi_12k full_nr_gnn_gt_l4_dnnm-0_deg_lin_self_guide ${seed} ${fold} ${thres}&

# wait

# done

# wait





