#!/usr/bin/env python3

import argparse
import sys
from pathlib import Path


ROOT_PATH = Path(__file__).parent.parent.resolve()
sys.path.insert(0, str(ROOT_PATH / "src"))

from lib_dl.docker.build import build_image


# This script builds the project as a docker container and then runs
# the commands provided to it, or starts an interactive shell session
# if there are none.
# You can specify the GPUs it should use via the --gpus id1,id2,... flag.
# If no GPUs are specified, it will only use the CPU.


build_image(
    image_name="llm",
    lib_docker_dir=Path("src/lib_dl/docker"),
    project_docker_dir=Path("scripts"),
    # export_image=False,
)
