#!/bin/bash

# Check if server configuration is provided
if [ $# -eq 0 ]; then
    echo "Usage: $0 username@server"
    exit 1
fi

# Extract username and server from the argument
username=$(echo "$1" | cut -d '@' -f1)
server=$(echo "$1" | cut -d '@' -f2)
port=8881

# Start SSH connection with port forwarding
# ssh -f -N -M -S ~/.ssh/control-%C -L localhost:8888:localhost:8888 "$username"@"$server"
ssh -f -N -M -S ~/.ssh/control-%C -L $port:localhost:$port "$username"@"$server"

echo "SSH connection established with port forwarding from $server:$port to localhost:$port"

# Wait for user input to terminate the connection
echo "Press any key to terminate the SSH connection..."
read -n 1 -s

# Terminate the SSH connection
ssh -S ~/.ssh/control-%C -O exit "$username"@"$server"
echo "SSH connection terminated."


# ssh -L 8888:localhost:8888 "@1
