#!/usr/bin/env python3

import sys
from pathlib import Path


ROOT_PATH = Path(__file__).parent.parent.resolve()
sys.path.insert(0, str(ROOT_PATH / "src"))

from lib_dl.docker.run import CONTAINER_HOME_DIR, run_container


# This script builds the project as a docker container and then runs
# the commands provided to it, or starts an interactive shell session
# if there are none.
# You can specify the GPUs it should use via the --gpus id1,id2,... flag.
# If no GPUs are specified, it will only use the CPU.

run_container(
    image_name="llm",
    additional_mount_options=[
        "-v",
        f"<redacted>",
        "-v",
        f"<redacted>",
        "-e",
        f"<redacted>",
        "-v",
        f"<redacted>",
        "-v",
        f"<redacted>",
        "-e",
        "HF_DATASETS_CACHE=./data/huggingface_cache",
        "--env-file",
        "$HOME/.config/dot_envs/wandb.env",
    ],
    # Use different ports than the default ones to avoid conflicts
    exposed_ports=[
        29500,  # deepspeed
        8881,  # jupyter
        # 6007,  # tensorboard
        # 9901,  # torch.distributed
    ],
)
